<TeXmacs|1.0.1.11>

<style|tmdoc>

<\body>
  <expand|tmdoc-title|<TeXmacs> with CAS>

  <\expand|make-title>
    <title|><author|><author|Chu-Ching Huang>

    <expand|title-email|cchuang@mail.cgu.edu.tw>

    <expand|title-date|<date|%B %d, %Y>>
  </expand>

  <\abstract>
    Some famous computer algebra systems (CAS) will be integrated into the
    Linux-based platform as CAI tools for the higher Mathematical courses.
    The mini memo will cover some \ topics as follows:

    <\expand|enumerate-numeric>
      <item>Maxima: This software is famous for its "Symbolic calculation",
      including finding limit of functions, differentiation, integration of
      functions, series expansion etc;

      <item>Octave: This software has full features about "Numerical
      calculation" and \ simple syntax to be programmed.\ 

      <item>Gnuplot: The powerful plotting package, it almost has no problem
      to deal with the scientific or data plotting especially for 2D plots.

      <item><TeXmacs>: Certainly, you have known if you can see this article.
      Word processing and "GUI" of CAS. It is the simplest way for you to
      make mathematical document from input to output, I think.
    </expand>

    All the packages will be integrated into bootable Linux CDROM. In other
    words, you can continue your paper work in any place with this platform (
    and disk for storing data) even in net-coffee store. Now, let us explore
    the journey and hope you enjoy it!
  </abstract>

  <chapter|Preliminary>

  In this chapter, the individual basic introductions about <TeXmacs>, core
  of this book, and the tools about computer algebra systems, CAS, and graph
  will be given.

  <section|Ahead navigation with <TeXmacs>>

  This is not only introduction for the people who want to learn how to use
  <TeXmacs>, but a note for <TeXmacs> newbie with some <TeX> experiences. We
  try to follow the <TeX> rules to describe how to making documents. From now
  on, [<with|color|red|content>] means the option, <with|color|red|content>,
  in the menu bar.

  <subsection|Presume setup>

  While you execute the <TeXmacs> from X-terminal, you will see the <TeXmacs>
  window. If you are first use this application, the <with|color|red|"help">
  document is also opened in the worksheet windows. Press the button in the
  menu bar, [File] <with|mode|math|\<rightarrow\>> [New], to open a new
  buffer for writing document directly or just as <LaTeX> doing something
  "presume document setting":

  <\expand|enumerate-numeric>
    <item>[Document] <with|mode|math|\<rightarrow\>> [style]
    <with|mode|math|\<rightarrow\>> [format that you want to write], almost
    styles generally used in <LaTeX>, for example: article, letter etc., can
    be found in this menu.\ 

    <item>[Text] <with|mode|math|\<rightarrow\>> [Title]
    \ <with|mode|math|\<rightarrow\>> [Make title]
    \ <with|mode|math|\<rightarrow\>> [Abstract], author, date and address
    can also be added.\ 

    <item>[Text] <with|mode|math|\<rightarrow\>> [Section] and so on. The
    content part of article can be manipulated just as any work processing
    programs do. \ 
  </expand>

  Generally, part 1 and 2 \ can be omitted if your do not hear about <TeX> or
  simply type a document. For <TeX>ers, the document uses "letter" style.

  <subsection|Content Cooking>

  If you do not care about how to make content with any mathematical symbols,
  now stop reading. If text input can not satisfy you, just go continuously.
  The philosophy for <TeXmacs> to manipulate the contents is <strong|very>
  similar to <LaTeX> does ( but not equal to). Content inputs are divided
  into three types: <with|color|blue|text, math and display> modes.\ 

  <\expand|enumerate-numeric>
    <item>Type text as any WYSIWYG editors do.

    <item>Math content, i.e. mathematical symbols together with text content
    in one line. Then:\ 

    <\expand|enumerate-alpha>
      <item>Press the menu bar [<with|mode|math| <big|sum><rsup|m><rsub|r>]>,
      or [Text] <with|mode|math|\<rightarrow\>> [Mathematics]
      <with|mode|math|\<rightarrow\>> [Formula] or press <with|color|red|US
      dollar sign>, to change the mode from text mode into math mode. The
      third line of menu bar changes for suitable mathematical choice icons.
      But the usages are still functional mostly.\ 

      <item>Press [<with|mode|math|\<rightarrow\>>] or <with|color|red|US
      dollar sign> back to the text mode after inputting mathematical
      content.
    </expand>

    The symbols are just like these of usages in <TeX>. For example:
    <with|mode|math|\<backslash\>backslash> produces
    <with|mode|math|\<backslash\>>.

    <item>Display Math content, i.e. independent line or lines for
    Mathematical symbols.\ 

    <\expand|enumerate-alpha>
      <item>Choose [<with|mode|math|<big|sum><rsup|m><rsub|r>]>
      <with|mode|math|\<rightarrow\>> [Equation], for one-line mathematical
      input, corresponding <TeX> command is double US dollar sign;

      <item>choose [<with|mode|math|<big|sum><rsup|m><rsub|r>]>
      <with|mode|math|\<rightarrow\>> [Equations], multi-line mathematical
      input, corresponding <TeX> command is <with|color|blue|eqnarray>
      environment. Use [<with|mode|math|\<rightarrow\>>] to change next cell
      and [Enter] to change new line. The exact cell position is shown at the
      right-down corner.\ 
    </expand>

    <item>How do I know at which is in "text" mode or in "math" mode? The
    same environment is enclosed by a<with|color|blue| light
    blue<with|color|black|>> rectangle. Yor can move by the mouse or the
    "right arrow", [<with|mode|math|<with|color|red|\<rightarrow\>>>], and
    "left arrow", [<with|mode|math|<with|color|red|\<leftarrow\>>>], keys to
    change the mode.
  </expand>

  Now, let us show some examples:

  <\example>
    (Riemann Integral) \ \ \ \ [Text]<with|mode|math|\<rightarrow\>[Environment]
    ><with|mode|math|\<rightarrow\>> [Example], just like <LaTeX>, it is
    auto-numbered. Press [Enter] to input the following:

    \;

    Let <with|color|blue|<with|mode|math|f> > be defined on the closed
    interval <with|mode|math|<with|color|blue|[a,b]>>, and let
    <with|mode|math|<with|color|blue|\<Delta\>>> be a partition of
    <with|mode|math|<with|color|blue|[a,b]>><with|color|black|> given that

    <\expand|equation*>
      <with|color|orange|<\with|color|red>
        a=x<rsub|0>\<less\>x<rsub|1>\<less\>x<rsub|2>\<less\>\<cdots\>\<less\>x<rsub|n-1>\<less\>x<rsub|n>=b
      </with>>
    </expand>

    where <with|mode|math|<with|color|blue|\<Delta\><rsub|>x<rsub|i>>><with|color|black|>
    is the width of the <with|mode|math|<with|color|blue|i>>th subinterval.
    If <with|mode|math|<with|color|blue|c<rsub|i>>><with|color|black|> is any
    point in the <with|mode|math|<with|color|blue|i>>th subinterval, then the
    sum

    <\expand|equation*>
      <\with|paragraph mode|left>
        <\with|right margin|>
          <with|color|red|<big|sum><rsub|i=1><rsup|n>f(c<rsub|i>)\<Delta\>x<rsub|i>,
          \ \ \ \ > \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ <with|color|red|x<rsub|i-1>\<leqslant\>c<rsub|i>\<leqslant\>x<rsub|i>>
        </with>
      </with>
    </expand>

    is called the <strong|<with|color|grey|<em|Riemann sum>>> of
    <with|color|blue|<with|mode|math|f>> for the partition of
    <with|mode|math|<with|color|blue|\<Delta\>>>.

    \;

    The parts in blue color are in math mode (<with|color|red|>press
    <with|color|red|US dollar sign> and then
    [<with|mode|math|<with|color|red|\<rightarrow\>>>] back to the text mode
    again) and the parts in red are in display Math mode ( press
    [<with|mode|math|<big|sum><rsup|m><rsub|r>]>
    <with|mode|math|\<rightarrow\>> [Equation] and move cursor by mouse into
    next line back to the text mode). The messages shown at the bottom line
    of <TeXmacs> may help you at which mode you are and what you have done.
  </example>

  <\example>
    As above, if the limit

    <\equation>
      <with|color|red|lim<rsub|\<\|\|\>\<Delta\>\<\|\|\>
      \<rightarrow\>0><big|sum><rsub|i=1><rsup|n>f(c<rsub|i>)\<Delta\>x<rsub|i>>
    </equation>

    exists where <with|color|red|<with|mode|math|<with|color|blue|\<\|\|\>\<Delta\>\<\|\|\>=<below|max|1\<leqslant\>i\<leqslant\>n>\|x<rsub|i>-x<rsub|i-1>\|>><with|color|blue|>>
    then <with|mode|math|<with|color|blue|f>> is integrable on
    <with|mode|math|<with|color|blue|[a,b]>> and the limit is denoted by

    <\equation>
      <with|color|red|lim<rsub|\<\|\|\>\<Delta\>\<\|\|\>
      \<rightarrow\>0><big|sum><rsub|i=1><rsup|n>f(c<rsub|i>)\<Delta\>x<rsub|i>=<big|int><rsub|a><rsup|b>f(x)
      d x.>
    </equation>

    The limit is call the <strong|definite integral>.

    The number of equation is produced by [Mathematics]
    <with|mode|math|\<rightarrow\>>[Number equation] in display Math mode.
  </example>

  \;

  In these two examples, just type as you do in <TeX> environment, for
  example <with|mode|math|<with|color|red|<with|font size|0.84|\<wedge\>>>>
  means upper script input and <with|mode|math|<rsub|<with|color|red|->>>
  means lower script input, but not all same.

  <\example>
    (Gauss Law)

    In Math or display Math mode, we can adjust the script by:

    <\expand|itemize-dot>
      <item>Press [Mathematics] <with|mode|math|\<rightarrow\>> [Script]
      <with|mode|math|\<rightarrow\>>[Script below] or [Script above], to add
      new line below or above the math symbol. This is as like the effect of
      <with|color|red|<with|mode|math|\<backslash\>limit>> <TeX> command
      after normal mathematical command.\ 

      <item>Input symbols under or above other symbols in display math mode,
      as above adding script space ahead,

      <\expand|equation*>
        <\with|mode|text>
          <\equation>
            <vspace|1fn><below|<big|int><big|int>|S>\<b-B\>\<cdot\>\<b-N\>
            \ \ \ d S =4\<pi\>q
          </equation>
        </with>
      </expand>
    </expand>
  </example>

  After working, choose [File] <with|mode|math|\<rightarrow\>>[Save] and give
  a filename, for example \ <with|color|red|filename.tm>. This will create a
  file named as <with|color|red|filename.tm> in your home directory. If you
  work on Knoppix Linux, everything will be disappeared after turning off the
  power since it works on RAM. You had better to use the following command to
  backup worksheet:

  <\code>
    \<gtr\> mcopy filename.tm a:
  </code>

  Now you can turn off the system. Then you can fire up your <TeXmacs> and
  enjoy!

  <section|CAS's and Graph softwares>

  Not only the powerful ability of publishing text and math documents, CAS
  applications can be executed within session of <TeXmacs>, solving problems
  and making graphs. The computation ability of CAS will be introduced later
  and how-to making graphs will be introduced first. Some \ CAS sessions
  allow to produce in-line postscript graph in worksheets, i.e. Gnuplot,
  Octave, but some are not, for example Maxima. For the latter case, users
  have to embed the result graphs into the worksheet. \ 

  <\example>
    How can <TeXmacs> do with CAS?

    The answer is very simple: <with|color|red|calculation>, including
    <with|color|red|symbolic calculation>, for example Maxima and
    Yacas,<with|color|red| numerical calculation>, for example Octave, and
    <with|color|red|plotting utility>.
  </example>

  <\note>
    Remember, Before quit out from the CAS session, remember to close session
    by pressing the third icon in the third line of menu bars.
  </note>

  <section|Functions>

  Here, we will give a brief introduction for CAS working within <TeXmacs>.

  <\definition>
    <with|mode|math|f(x)> is called a function of <with|mode|math|D>, subset
    of real numbers, if there is only unique
    <with|mode|math|y\<in\>\<bbb-R\>> for each point, <with|mode|math|x> in
    <with|mode|math|D>.
  </definition>

  <\example>
    Maxima session: [Text] <with|mode|math|\<rightarrow\>>[Session]
    <with|mode|math|\<rightarrow\> > [Maxima]

    <\session|maxima|default>
      <\output>
        GCL (GNU Common Lisp) \ Version(2.5.0) g \ 2 \ 7 19:50:19 CST
        2003

        Licensed under GNU Library General Public License

        Contains Enhancements by W. Schelter

        Maxima 5.9.0rc3 http://maxima.sourceforge.net

        Distributed under the GNU Public License. See the file COPYING.

        Dedicated to the memory of William Schelter.

        This is a development version of Maxima. The function bug_report()

        provides bug reporting information.

        \;
      </output>

      <\input|<\with|color|red>
        (C1) <with|color|black|>
      </with>>
        f(x):=x^3+sin(x)
      </input>

      <\output>
        <\with|mode|math>
          <with|formula style|true|<with|mode|text|font
          family|tt|color|red|(D1) <with|color|black|>>f<left|(>x<right|)>:=x<rsup|3>+sin
          x>
        </with>

        \;
      </output>

      <\input|<\with|color|red>
        (C2) <with|color|black|>
      </with>>
        f(%pi)
      </input>

      <\output>
        <\with|mode|math>
          <with|formula style|true|<with|mode|text|font
          family|tt|color|red|(D2) <with|color|black|>>\<pi\><rsup|3>>
        </with>

        \;
      </output>

      <\input|<\with|color|red>
        (C3) <with|color|black|>
      </with>>
        h(x):=block([u:x,w], if (u\<gtr\>0) then w:sin(x) else w:-sin(x),
        u+w)
      </input>

      <\output>
        <\with|mode|math>
          <with|formula style|true|<with|mode|text|font
          family|tt|color|red|(D3) <with|color|black|>>h<left|(>x<right|)>:=<with|math
          font family|bf|block><hspace|0.75spc><left|(><left|[>u:x,w<right|]>,<with|math
          font family|bf|if><hspace|0.75spc>u\<gtr\>0<hspace|0.75spc><with|math
          font family|bf|then><hspace|0.75spc>w:sin
          x<hspace|0.75spc><with|math font
          family|bf|else><hspace|0.75spc>w:-sin x,u+w<right|)>>
        </with>

        \;
      </output>

      <\input|<\with|color|red>
        (C4) <with|color|black|>
      </with>>
        h(1)
      </input>

      <\output>
        <\with|mode|math>
          <with|formula style|true|<with|mode|text|font
          family|tt|color|red|(D4) <with|color|black|>>sin 1+1>
        </with>

        \;
      </output>

      <\input|<\with|color|red>
        (C5) <with|color|black|>
      </with>>
        h(-2.0)
      </input>

      <\output>
        <\with|mode|math>
          <with|formula style|true|<with|mode|text|font
          family|tt|color|red|(D5) <with|color|black|>>-1.090702573174318>
        </with>

        \;
      </output>

      <\input|<\with|color|red>
        (C6) <with|color|black|>
      </with>>
        integrate(x*((x-1)/(x+1))**(1/2),x);
      </input>

      <\output>
        <\with|mode|math>
          <with|formula style|true|<with|mode|text|font
          family|tt|color|red|(D6) <with|color|black|>>4*<left|(><frac|log
          <left|(><sqrt|<frac|x-1|x+1>>+1<right|)>|8>-<frac|log
          <left|(><sqrt|<frac|x-1|x+1>>-1<right|)>|8>+<frac|3*<left|(><frac|x-1|x+1><right|)><rsup|<frac|3|2>>-<sqrt|<frac|x-1|x+1>>|-<frac|8*<left|(>x-1<right|)>|x+1>+<frac|4*<left|(>x-1<right|)><rsup|2>|<left|(>x+1<right|)><rsup|2>>+4><right|)>>
        </with>

        \;
      </output>

      <\input|<\with|color|red>
        (C7) <with|color|black|>
      </with>>
        diff(d6,x)
      </input>

      <\output>
        <\with|mode|math>
          <with|formula style|true|<with|mode|text|font
          family|tt|color|red|(D7) <with|color|black|>>4*<left|(>-<frac|<left|(>-<frac|8|x+1>+<frac|16*<left|(>x-1<right|)>|<left|(>x+1<right|)><rsup|2>>-<frac|8*<left|(>x-1<right|)><rsup|2>|<left|(>x+1<right|)><rsup|3>><right|)>*<left|(>3*<left|(><frac|x-1|x+1><right|)><rsup|<frac|3|2>>-<sqrt|<frac|x-1|x+1>><right|)>|<left|(>-<frac|8*<left|(>x-1<right|)>|x+1>+<frac|4*<left|(>x-1<right|)><rsup|2>|<left|(>x+1<right|)><rsup|2>>+4<right|)><rsup|2>>+<frac|<frac|1|x+1>-<frac|x-1|<left|(>x+1<right|)><rsup|2>>|16*<sqrt|<frac|x-1|x+1>>*<left|(><sqrt|<frac|x-1|x+1>>+1<right|)>>-<frac|<frac|1|x+1>-<frac|x-1|<left|(>x+1<right|)><rsup|2>>|16*<sqrt|<frac|x-1|x+1>>*<left|(><sqrt|<frac|x-1|x+1>>-1<right|)>>+<frac|<frac|9*<sqrt|<frac|x-1|x+1>>*<left|(><frac|1|x+1>-<frac|x-1|<left|(>x+1<right|)><rsup|2>><right|)>|2>-<frac|<frac|1|x+1>-<frac|x-1|<left|(>x+1<right|)><rsup|2>>|2*<sqrt|<frac|x-1|x+1>>>|-<frac|8*<left|(>x-1<right|)>|x+1>+<frac|4*<left|(>x-1<right|)><rsup|2>|<left|(>x+1<right|)><rsup|2>>+4><right|)>>
        </with>

        \;
      </output>

      <\input|<\with|color|red>
        (C8) <with|color|black|>
      </with>>
        plot2d(x+sin(x),[x,0,%pi]);
      </input>

      <\output>
        <\with|mode|math>
          <with|formula style|true|<with|mode|text|font
          family|tt|color|red|(D8) <with|color|black|>>0>
        </with>

        \;
      </output>

      <\input|<\with|color|red>
        (C9) <with|color|black|>
      </with>>
        \;
      </input>
    </session>
  </example>

  Here, you can directly define functions or use <with|color|red|<em|block>>
  structure to define complicate function as (C3). Here,
  <with|mode|math|h(x)> is defined as <with|mode|math|x+sin(x)> if
  <with|mode|math|x\<gtr\>0> and as <with|mode|math|x-sin(x)> if
  <with|mode|math|x\<leqslant\>0>. Plotting graph is the best way to
  understand function. Maxima also applies plot functions,
  <with|color|red|polt2d>. The graph is produced in another X-terminal but
  not in the <TeXmacs> worksheet. Use another KDE applications to produce the
  graph and embed the graph into the worksheet by:\ 

  <\expand|enumerate-alpha>
    <item>Press [KDE] <with|mode|math|\<rightarrow\>> [graph]
    <with|mode|math|\<rightarrow\> >[ksnapshot] to catch the graph and save
    it,

    <item>Press [Insert] <with|mode|math|\<rightarrow\>> [Image]
    <with|mode|math|\<rightarrow\>> [Insert Image] to embed the picture file
    and scale the sizes of height and width if necessary.
  </expand>

  <\example>
    (3D Brownian Motion Particle's Trajectory) Although the graphs of
    produced by Octave can be embedded into worksheet in general, but it does
    not always work. example, the following Octave code is is used to
    simulated Brownian motion within 1 second with time interval,
    <with|mode|math|1/500> sec. Then output the 3D trajectory of particle in
    encapsulated postscript format:

    <\expand|enumerate-roman>
      <item>Prepare the image file in the one of following formats: PS, EPS,
      pdf, fig, png, tif, xpm, fig etc. Or,

      <item>Make graph from CAS and save the screen-shot or store it directly
      into storage. For\ 

      <\expand|enumerate-alpha>
        <item>Open [Text] <with|mode|math|\<rightarrow\>>[Session]
        <with|mode|math|\<rightarrow\>>[shell], execute the following octave
        code to make graph:

        <\session|octave|default>
          <\output>
            GNU Octave, version 2.1.45 (i686-pc-linux-gnu).

            Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003 John
            W. Eaton.

            This is free software; see the source code for copying
            conditions.

            There is ABSOLUTELY NO WARRANTY; not even for MERCHANTIBILITY or

            FITNESS FOR A PARTICULAR PURPOSE.

            \;

            Report bugs to \<less\>bug-octave@bevo.che.wisc.edu\<gtr\>.

            \;
          </output>

          <\input|octave\<gtr\> >
            t_total=1;
          </input>

          <\input|octave\<gtr\> >
            t_step=500;
          </input>

          <\input|octave\<gtr\> >
            dim=3;
          </input>

          <\input|octave\<gtr\> >
            init_po=[0,0,0];
          </input>

          <\input|octave\<gtr\> >
            increment=sqrt(t_total/t_step)*randn(t_step,dim);
          </input>

          <\input|octave\<gtr\> >
            po=[init_po;increment]; b(1,:)=zeros(1,dim);
          </input>

          <\input|octave\<gtr\> >
            gset parametric;\ 
          </input>

          <\input|octave\<gtr\> >
            gset xrange [-2:2];\ 
          </input>

          <\input|octave\<gtr\> >
            gset yrange [-2:2];
          </input>

          <\input|octave\<gtr\> >
            gset zrange [-2:2];
          </input>

          <\input|octave\<gtr\> >
            for i=2:t_step b(i,:)=po(i,:)+b(i-1,:); endfor
          </input>

          <\input|octave\<gtr\> >
            gset set term postscript enhanced color eps;
          </input>

          <\input|octave\<gtr\> >
            gset xtics 1;gset ytics 1; gset ztics 1;
          </input>

          <\input|octave\<gtr\> >
            gset output '/home/cchuang/texmacs/brownian.eps';
          </input>

          <\input|octave\<gtr\> >
            gsplot b title "3D Brownian Motion";
          </input>

          <\input|octave\<gtr\> >
            \;
          </input>
        </session>

        <item>After executing the code, brownian.eps is created. Terminate
        the \ session and back to the <TeXmacs> environment. Now choose
        [Insert] <with|mode|math|\<rightarrow\>>[Image]
        <with|mode|math|\<rightarrow\>> [Insert image] to embed the result
        graph as follows:\ 

        <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
        /home/cchuang/texmacs/brownian.eps\n%%Creator: gnuplot 3.8h
        patchlevel 0\n%%CreationDate: Mon Apr \ 7 09:16:51
        2003\n%%DocumentFonts: (atend)\n%%BoundingBox: 50 50 230
        176\n%%Orientation: Portrait\n%%EndComments\n/gnudict 256 dict
        def\ngnudict begin\n/Color true def\n/Solid false def\n/gnulinewidth
        5.000 def\n/userlinewidth gnulinewidth def\n/vshift -46 def\n/dl
        {10.0 mul} def\n/hpt_ 31.5 def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt
        vpt_ def\n/M {moveto} bind def\n/L {lineto} bind def\n/R {rmoveto}
        bind def\n/V {rlineto} bind def\n/N {newpath moveto} bind def\n/f
        {rlineto fill} bind def\n/vpt2 vpt 2 mul def\n/hpt2 hpt 2 mul
        def\n/Lshow { currentpoint stroke M\n \ 0 vshift R show } def\n/Rshow
        { currentpoint stroke M\n \ dup stringwidth pop neg vshift R show }
        def\n/Cshow { currentpoint stroke M\n \ dup stringwidth pop -2 div
        vshift R show } def\n/UP { dup vpt_ mul /vpt exch def hpt_ mul /hpt
        exch def\n \ /hpt2 hpt 2 mul def /vpt2 vpt 2 mul def } def\n/DL {
        Color {setrgbcolor Solid {pop []} if 0 setdash }\n {pop pop pop Solid
        {pop []} if 0 setdash} ifelse } def\n/BL { stroke userlinewidth 2 mul
        setlinewidth } def\n/AL { stroke userlinewidth 2 div setlinewidth }
        def\n/UL { dup gnulinewidth mul /userlinewidth exch def\n
        \ \ \ \ \ dup 1 lt {pop 1} if 10 mul /udl exch def } def\n/PL {
        stroke userlinewidth setlinewidth } def\n/LTb { BL [] 0 0 0 DL }
        def\n/LTa { AL [1 udl mul 2 udl mul] 0 setdash 0 0 0 setrgbcolor }
        def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 { PL [4 dl 2 dl] 0 1 0 DL }
        def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL } def\n/LT3 { PL [1 dl 1.5 dl] 1
        0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1 dl 2 dl] 0 1 1 DL } def\n/LT5 {
        PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL } def\n/LT6 { PL [2 dl 2 dl 2 dl 4
        dl] 0 0 0 DL } def\n/LT7 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 4 dl] 1 0.3 0
        DL } def\n/LT8 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 4 dl] 0.5 0.5
        0.5 DL } def\n/Pnt { stroke [] 0 setdash\n \ \ gsave 1 setlinecap M 0
        0 V stroke grestore } def\n/Dia { stroke [] 0 setdash 2 copy vpt add
        M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V
        closepath stroke\n \ Pnt } def\n/Pls { stroke [] 0 setdash vpt sub M
        0 vpt2 V\n \ currentpoint stroke M\n \ hpt neg vpt neg R hpt2 0 V
        stroke\n \ } def\n/Box { stroke [] 0 setdash 2 copy exch hpt sub exch
        vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
        closepath stroke\n \ Pnt } def\n/Crs { stroke [] 0 setdash exch hpt
        sub exch vpt add M\n \ hpt2 vpt2 neg V currentpoint stroke M\n \ hpt2
        neg 0 R hpt2 vpt2 V stroke } def\n/TriU { stroke [] 0 setdash 2 copy
        vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n
        \ hpt neg vpt 1.62 mul V closepath stroke\n \ Pnt \ } def\n/Star { 2
        copy Pls Crs } def\n/BoxF { stroke [] 0 setdash exch hpt sub exch vpt
        add M\n \ 0 vpt2 neg V \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V
        \ closepath fill } def\n/TriUF { stroke [] 0 setdash vpt 1.12 mul add
        M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62
        mul V closepath fill } def\n/TriD { stroke [] 0 setdash 2 copy vpt
        1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt
        neg vpt -1.62 mul V closepath stroke\n \ Pnt \ } def\n/TriDF { stroke
        [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2
        mul 0 V\n \ hpt neg vpt -1.62 mul V closepath fill} def\n/DiaF {
        stroke [] 0 setdash vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n
        \ hpt vpt V hpt neg vpt V closepath fill } def\n/Pent { stroke [] 0
        setdash 2 copy gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
        repeat\n \ closepath stroke grestore Pnt } def\n/PentF { stroke [] 0
        setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n
        \ closepath fill grestore } def\n/Circle { stroke [] 0 setdash 2
        copy\n \ hpt 0 360 arc stroke Pnt } def\n/CircleF { stroke [] 0
        setdash hpt 0 360 arc fill } def\n/C0 { BL [] 0 setdash 2 copy moveto
        vpt 90 450 \ arc } bind def\n/C1 { BL [] 0 setdash 2 copy
        \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc closepath
        fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
        def\n/C2 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        90 180 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
        closepath } bind def\n/C3 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ \ 2 copy \ vpt 0 180 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C4 {
        BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 180 270 arc
        closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
        } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
        \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360
        arc } bind def\n/C6 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
        copy \ vpt 90 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt
        0 360 arc closepath } bind def\n/C7 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ 2 copy \ vpt 0 270 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C8 {
        BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt 270 360 arc
        closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
        bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy
        \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
        360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
        moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
        \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11
        { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
        closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360
        arc closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13
        { BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
        closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360
        arc closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
        setdash 2 copy vpt 0 360 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
        \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
        \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
        bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
        def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
        bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
        def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
        Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch
        vpt2 vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy
        exch vpt sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 {
        BL [] 0 setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt
        sub exch vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0
        setdash 2 copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare }
        bind def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt
        vpt2 Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n
        \ \ \ \ \ \ Bsquare } bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub
        vpt Square fill Bsquare } bind def\n/S9 { BL [] 0 setdash 2 copy vpt
        sub vpt vpt2 Rec fill Bsquare } bind def\n/S10 { BL [] 0 setdash 2
        copy vpt sub vpt Square fill 2 copy exch vpt sub exch vpt Square
        fill\n \ \ \ \ \ \ Bsquare } bind def\n/S11 { BL [] 0 setdash 2 copy
        vpt sub vpt Square fill 2 copy exch vpt sub exch vpt2 vpt Rec fill\n
        \ \ \ \ \ \ Bsquare } bind def\n/S12 { BL [] 0 setdash 2 copy exch
        vpt sub exch vpt sub vpt2 vpt Rec fill Bsquare } bind def\n/S13 { BL
        [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt Rec fill\n
        \ \ \ \ \ \ 2 copy vpt Square fill Bsquare } bind def\n/S14 { BL [] 0
        setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt Rec fill\n
        \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square fill Bsquare } bind
        def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill Bsquare } bind
        def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke grestore } bind
        def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke grestore } bind
        def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke grestore } bind
        def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke grestore } bind
        def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke grestore } bind
        def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke grestore } bind
        def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke grestore } bind
        def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke grestore } bind
        def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke grestore } bind
        def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke grestore } bind
        def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke grestore } bind
        def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke grestore } bind
        def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke grestore } bind
        def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke grestore } bind
        def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke grestore } bind
        def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke grestore } bind
        def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg vpt neg V hpt
        vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke } def\n/BoxE {
        stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2 neg V hpt2
        0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE { stroke
        [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2
        mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke } def\n/TriDE {
        stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
        \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath stroke }
        def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72
        rotate 0 hpt L} repeat\n \ closepath stroke grestore } def\n/CircE {
        stroke [] 0 setdash \n \ hpt 0 360 arc stroke } def\n/Opaque { gsave
        closepath 1 setgray fill grestore 0 setgray closepath } def\n/DiaW {
        stroke [] 0 setdash vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n
        \ hpt vpt V hpt neg vpt V Opaque stroke } def\n/BoxW { stroke [] 0
        setdash exch hpt sub exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2
        V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW { stroke [] 0 setdash
        vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n
        \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW { stroke [] 0
        setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0
        V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW { stroke []
        0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n
        \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash \n \ hpt
        0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray fill
        grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
        makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
        ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0
        get findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ]
        exch dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch
        4 get {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n
        \ \ \ \ {dup 3 get {2 get neg 0 exch R pop} {pop aload pop M} ifelse}
        {dup 5\n \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get
        stringwidth pop -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop
        -2 div 0 R 6 get\n \ \ \ \ show 2 index {aload pop M neg 3 -1 roll
        neg R pop pop} {pop pop pop\n \ \ \ \ pop aload pop M} ifelse }ifelse
        }ifelse } forall} bind def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get
        findfont exch 1 get scalefont\n \ \ \ \ setfont 6 get stringwidth pop
        add} {pop} ifelse} forall} bind def\n/MLshow { currentpoint stroke
        M\n \ 0 exch R MFshow } bind def\n/MRshow { currentpoint stroke M\n
        \ exch dup MFwidth neg 3 -1 roll R MFshow } def\n/MCshow {
        currentpoint stroke M\n \ exch dup MFwidth -2 div 3 -1 roll R MFshow
        } def\nend\n%%EndProlog\ngnudict begin\ngsave\n50 50 translate\n0.050
        0.050 scale\n0 setgray\nnewpath\n(Helvetica) findfont 140 scalefont
        setfont\n1.000 UL\nLTb\n1.000 UP\n1.000 UL\nLT0\n2802 2036 M\n[
        [(Helvetica) 140.0 0.0 true true 0 (3D Brownian Motion)]\n] -46.7
        MRshow\n2886 2036 M\n399 0 V\n1800 1491 M\n-1 11 V\n-41 3 V\n-2 3
        V\n-13 0 V\n19 -3 V\n-2 3 V\n19 -6 V\n40 -2 V\n-7 -15 V\n13 5 V\n-21
        4 V\n-34 20 V\n5 3 V\n-4 -10 V\n4 -18 V\n-2 -8 V\n-14 -10 V\n-3 5
        V\n4 3 V\n5 -8 V\n-16 6 V\n14 -11 V\n12 5 V\n-17 -2 V\n-4 23 V\n35 11
        V\n-11 -4 V\n3 17 V\n-9 -3 V\n21 -4 V\n-15 2 V\n3 -2 V\n-38 -10 V\n10
        0 V\n-42 -10 V\n-4 -1 V\n14 -5 V\n3 9 V\n-17 4 V\n25 -6 V\n29 -19
        V\n27 8 V\n-5 11 V\n22 8 V\n-7 0 V\n-10 9 V\n36 -3 V\n13 0 V\n-13 -6
        V\n13 4 V\n20 -8 V\n10 -6 V\n-2 -19 V\n-12 -9 V\n-25 -31 V\n15 2
        V\n-21 -12 V\n2 7 V\n-12 11 V\n2 19 V\n-17 6 V\n1 3 V\n-17 5 V\n6 -5
        V\n-38 -9 V\n-3 -8 V\n-25 5 V\n-4 0 V\n-23 -7 V\n-12 1 V\n13 8 V\n-27
        0 V\n30 -6 V\n-14 -4 V\n21 4 V\n30 -19 V\n1 -12 V\n12 -4 V\n19 8
        V\n-25 2 V\n-14 -15 V\n-9 2 V\n0 -8 V\n4 -3 V\n18 -20 V\n-16 10 V\n42
        8 V\n9 -3 V\n9 1 V\n54 21 V\n56 5 V\n-16 -7 V\n3 19 V\n17 3 V\n1 0
        V\n-7 1 V\n30 3 V\n21 6 V\n-7 -5 V\n-9 2 V\n11 -10 V\n26 8 V\n-16 6
        V\n19 -8 V\n-25 -3 V\n-14 6 V\n-42 -15 V\n-19 6 V\n20 11 V\n-40 -7
        V\n20 -5 V\n-21 1 V\n-39 6 V\n10 13 V\n-6 2 V\n17 3 V\n15 4 V\n-13 7
        V\n5 0 V\n18 -12 V\n-30 13 V\n-26 -6 V\n-24 8 V\n7 -10 V\n13 -6
        V\n-20 3 V\n1 8 V\n-7 5 V\n-27 -14 V\n16 0 V\n-9 0 V\n-7 4 V\n-13 3
        V\n0 6 V\n-9 4 V\n-9 2 V\n18 -7 V\n6 4 V\n-13 -5 V\n5 0 V\n2 -5 V\n-3
        0 V\n-14 10 V\n25 -12 V\n-6 -11 V\n-21 5 V\n12 6 V\n11 1 V\n19 22
        V\n0 2 V\n-5 21 V\n-17 4 V\n4 0 V\n12 -6 V\n9 8 V\n-5 1 V\n1 -7
        V\n-10 6 V\n6 6 V\n-18 1 V\n-20 10 V\n10 11 V\n-20 11 V\n15 -20
        V\n-14 -12 V\n-7 1 V\n-1 9 V\n-6 -5 V\n7 8 V\n-48 -15 V\n16 5 V\n5 -5
        V\n21 13 V\n-14 -13 V\n22 -14 V\n-5 -1 V\n19 19 V\n35 4 V\n16 -9
        V\n-6 0 V\n26 -5 V\n-17 -3 V\n-10 -7 V\n-8 -8 V\n-22 -9 V\n-22 5
        V\n-13 -3 V\n-10 13 V\n15 -4 V\n-42 6 V\n11 -12 V\n4 6 V\n1 5 V\n-11
        -16 V\n-4 0 V\n-18 4 V\n27 28 V\n32 -12 V\n-82 5 V\n41 7 V\n-22 -14
        V\n-2 16 V\n38 -2 V\n33 -14 V\n-18 -1 V\n-17 -4 V\n4 -5 V\n19 -8
        V\n-1 15 V\n7 -7 V\n-29 -1 V\n-35 -12 V\n-2 -7 V\n-35 2 V\n-27 -6
        V\n35 -9 V\n14 -14 V\n-46 5 V\n25 -11 V\n-14 -9 V\n24 -4 V\n1 -3
        V\n-37 6 V\n10 8 V\n-12 -9 V\n-27 9 V\n-5 -10 V\n4 5 V\n-6 -4 V\n10 4
        V\n3 -10 V\n-41 8 V\n25 -4 V\n0 -3 V\n8 0 V\n14 12 V\n11 0 V\n3 8
        V\n4 2 V\n48 22 V\n-10 -7 V\n-4 7 V\n25 18 V\n-3 7 V\n5 2 V\n31 2
        V\n-27 1 V\n-3 4 V\n6 1 V\n29 -3 V\n3 20 V\n2 -2 V\n-4 3 V\n15 -10
        V\n-9 6 V\n-36 -6 V\n-26 9 V\n25 10 V\n-20 2 V\n5 7 V\n-1 1 V\n28 -3
        V\n6 -8 V\n-17 9 V\n10 -8 V\n-12 -8 V\n2 1 V\n1 6 V\n15 0 V\n-1 -6
        V\n-3 -2 V\n-32 3 V\n16 14 V\n8 13 V\n-9 8 V\n6 -14 V\n11 -5 V\n-31
        -5 V\n-15 8 V\n-34 9 V\n-13 -3 V\n-10 -1 V\n-19 19 V\n-2 2 V\n-22 0
        V\n-23 8 V\n9 8 V\n29 18 V\n2 -8 V\n20 15 V\n5 9 V\n-17 -9 V\n28 -5
        V\n22 -2 V\n13 -15 V\n0 4 V\n35 -4 V\n-23 10 V\n7 15 V\n-22 -5 V\n-12
        -15 V\n3 -14 V\n6 -2 V\n7 9 V\n-23 27 V\n2 -6 V\n4 -8 V\n-3 -8 V\n-2
        11 V\n24 6 V\n16 -6 V\n6 -14 V\n-18 1 V\n-17 10 V\n19 9 V\n-34 -6
        V\n33 6 V\n-2 -11 V\n25 -20 V\n-6 -16 V\n8 -13 V\n-38 -8 V\n5 -6
        V\n-14 11 V\n25 -2 V\n24 -2 V\n4 4 V\n-5 -13 V\n-41 -6 V\n-36 6 V\n7
        -6 V\n-10 -9 V\n17 14 V\n-31 -14 V\n-2 -20 V\n-3 -2 V\n23 3 V\n-10 9
        V\n7 -10 V\n-22 4 V\n18 -12 V\n16 -2 V\n-41 7 V\n-35 -1 V\n4 -2 V\n22
        9 V\n3 -10 V\n-15 3 V\n12 1 V\n-3 2 V\n-5 5 V\n-18 -2 V\n2 6 V\n13 15
        V\n27 22 V\n5 -9 V\n-5 2 V\n-22 3 V\n15 -11 V\n15 7 V\n-46 -5 V\n-23
        3 V\n-24 -7 V\n-53 6 V\n29 8 V\n-13 16 V\n-30 14 V\n17 15 V\n3 7
        V\n14 -5 V\n24 12 V\n-2 -16 V\n-56 4 V\n6 -11 V\n2 -3 V\n21 -10
        V\n-34 4 V\n-8 -6 V\n23 7 V\n-28 9 V\n-22 11 V\n-6 10 V\n-8 -2 V\n2
        -1 V\n-15 -12 V\n3 -15 V\n-11 -9 V\n-10 2 V\n-11 5 V\n-22 -15 V\n-45
        -16 V\n-4 -13 V\n-3 -13 V\n10 9 V\n-3 12 V\n-2 15 V\n54 6
        V\ncurrentpoint stroke M\n-6 0 V\n8 -13 V\n-11 -2 V\n-30 5 V\n-12 -2
        V\n6 -6 V\n15 -1 V\n7 12 V\n-27 -10 V\n-1 -3 V\n-49 5 V\n-18 -2 V\n20
        -11 V\n-16 3 V\n-23 -11 V\n-13 2 V\n-11 -20 V\n-19 -7 V\n11 -3 V\n6 5
        V\n15 3 V\n7 6 V\n-32 -1 V\n-38 2 V\n54 -1 V\n-20 -6 V\n-1 -21 V\n-16
        -14 V\n4 -14 V\n5 -6 V\n18 5 V\n-10 4 V\n-15 19 V\n-35 15 V\n7 -16
        V\n15 -9 V\n32 6 V\n-3 -7 V\n-11 -4 V\n-12 -1 V\n-9 0 V\n8 -1 V\n65 6
        V\n-9 6 V\n14 -11 V\n-41 3 V\n24 7 V\n25 22 V\n-33 6 V\n-4 23 V\n7 -5
        V\n11 -5 V\n-39 9 V\n-10 -2 V\n5 10 V\n1 -15 V\n15 4 V\n17 1 V\n-2 2
        V\n-8 3 V\n11 1 V\n-5 9 V\n14 3 V\n0 10 V\n31 17 V\n-19 2 V\n-48 -13
        V\n-2 3 V\n12 -3 V\n21 31 V\n1 10 V\n3 20 V\n16 2 V\n17 10 V\n-13 2
        V\n20 -2 V\n0 3 V\n-28 22 V\n-35 -25 V\n-56 10 V\n-22 2 V\n-4 4 V\n6
        -57 R\n19 7 V\n25 4 V\n-2 11 V\n-7 1 V\n-14 -13 V\n1.000
        UL\nLTb\nLTb\n3024 949 M\n2128 465 L\n1.000 UL\nLTb\nLTb\n576 744
        M\n2128 465 L\n1.000 UL\nLTb\nLTb\n576 744 M\n896 484 V\n1.000
        UL\nLTb\nLTb\n3024 949 M\n1472 1228 L\n1.000 UL\nLTb\nLTb\n576 744
        M\n0 967 V\n1.000 UL\nLTb\nLTb\n576 744 M\n47 41 V\n1.000
        UL\nLTb\n512 652 M\n[ [(Helvetica) 140.0 0.0 true true 0 (-2)]\n]
        -46.7 MCshow\n1.000 UL\nLTb\nLTb\n1472 1228 M\n-47 -41 V\n1.000
        UL\nLTb\nLTb\n964 674 M\n48 41 V\n1.000 UL\nLTb\n901 583 M\n[
        [(Helvetica) 140.0 0.0 true true 0 (-1)]\n] -46.7 MCshow\n1.000
        UL\nLTb\nLTb\n1860 1158 M\n-48 -41 V\n1.000 UL\nLTb\nLTb\n1352 604
        M\n48 42 V\n1.000 UL\nLTb\n1289 513 M\n[ [(Helvetica) 140.0 0.0 true
        true 0 ( 0)]\n] -46.7 MCshow\n1.000 UL\nLTb\nLTb\n2248 1088 M\n-48
        -41 V\n1.000 UL\nLTb\nLTb\n1740 534 M\n48 42 V\n1.000 UL\nLTb\n1677
        443 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 1)]\n] -46.7
        MCshow\n1.000 UL\nLTb\nLTb\n2636 1019 M\n-48 -42 V\n1.000
        UL\nLTb\nLTb\n2128 465 M\n47 41 V\n1.000 UL\nLTb\n2064 373 M\n[
        [(Helvetica) 140.0 0.0 true true 0 ( 2)]\n] -46.7 MCshow\n1.000
        UL\nLTb\nLTb\n3024 949 M\n-47 -42 V\n1.000 UL\nLTb\nLTb\n2128 465
        M\n-61 17 V\n stroke\n2208 426 M\n[ [(Helvetica) 140.0 0.0 true true
        0 (-2)]\n] -46.7 MLshow\n1.000 UL\nLTb\nLTb\n576 744 M\n60 -17
        V\n1.000 UL\nLTb\nLTb\n2352 586 M\n-61 17 V\n stroke\n2432 547 M\n[
        [(Helvetica) 140.0 0.0 true true 0 (-1)]\n] -46.7 MLshow\n1.000
        UL\nLTb\nLTb\n800 865 M\n61 -17 V\n1.000 UL\nLTb\nLTb\n2576 707
        M\n-61 17 V\n stroke\n2657 668 M\n[ [(Helvetica) 140.0 0.0 true true
        0 ( 0)]\n] -46.7 MLshow\n1.000 UL\nLTb\nLTb\n1024 986 M\n61 -17
        V\n1.000 UL\nLTb\nLTb\n2800 828 M\n-61 17 V\n stroke\n2881 789 M\n[
        [(Helvetica) 140.0 0.0 true true 0 ( 1)]\n] -46.7 MLshow\n1.000
        UL\nLTb\nLTb\n1248 1107 M\n61 -17 V\n1.000 UL\nLTb\nLTb\n3024 949
        M\n-60 17 V\n stroke\n3105 910 M\n[ [(Helvetica) 140.0 0.0 true true
        0 ( 2)]\n] -46.7 MLshow\n1.000 UL\nLTb\nLTb\n1472 1228 M\n61 -17
        V\n1.000 UL\nLTb\nLTb\n576 1067 M\n63 0 V\n stroke\n450 1067 M\n[
        [(Helvetica) 140.0 0.0 true true 0 (-2)]\n] -46.7 MRshow\n1.000
        UL\nLTb\nLTb\n576 1228 M\n63 0 V\n stroke\n450 1228 M\n[ [(Helvetica)
        140.0 0.0 true true 0 (-1)]\n] -46.7 MRshow\n1.000 UL\nLTb\nLTb\n576
        1389 M\n63 0 V\n stroke\n450 1389 M\n[ [(Helvetica) 140.0 0.0 true
        true 0 ( 0)]\n] -46.7 MRshow\n1.000 UL\nLTb\nLTb\n576 1550 M\n63 0
        V\n stroke\n450 1550 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 1)]\n]
        -46.7 MRshow\n1.000 UL\nLTb\nLTb\n576 1711 M\n63 0 V\n stroke\n450
        1711 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 2)]\n] -46.7
        MRshow\n1.000 UP\nstroke\ngrestore\nend\nshowpage\n>|eps>||||||>
      </expand>

      Octave can use the gnuplot syntax to generate graph, but cannot
      interpreter the resulted PostScript code. Theirfore output the graph
      and embed it back.\ 
    </expand>
  </example>

  If the effect is not good-looking enough, you can consider another
  application session, Gnuplot. Gnuplot is more flexible since it applies
  many utility functions to manipulate graph, including the off-line
  modification. For example, press [Text]
  <with|mode|math|\<rightarrow\>>[Sessions]
  <with|mode|math|\<rightarrow\>>[Gnuplot] enters the session. Some simple
  examples as follows:

  <\session|gnuplot|default>
    <\output>
      <with|color|red|This is a TeXmacs interface for GNUplot.>

      \;
    </output>

    <\input|GNUplot] >
      plot [-pi/2:pi/2][-2:2] x+sin(x)
    </input>

    <\output>
      <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
      temp.eps\n%%Creator: gnuplot 3.8h patchlevel 0\n%%CreationDate: Mon Feb
      24 19:39:02 2003\n%%DocumentFonts: (atend)\n%%BoundingBox: 50 50 410
      302\n%%Orientation: Portrait\n%%EndComments\n/gnudict 256 dict
      def\ngnudict begin\n/Color false def\n/Solid false def\n/gnulinewidth
      5.000 def\n/userlinewidth gnulinewidth def\n/vshift -46 def\n/dl {10.0
      mul} def\n/hpt_ 31.5 def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_
      def\n/M {moveto} bind def\n/L {lineto} bind def\n/R {rmoveto} bind
      def\n/V {rlineto} bind def\n/N {newpath moveto} bind def\n/f {rlineto
      fill} bind def\n/vpt2 vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow {
      currentpoint stroke M\n \ 0 vshift R show } def\n/Rshow { currentpoint
      stroke M\n \ dup stringwidth pop neg vshift R show } def\n/Cshow {
      currentpoint stroke M\n \ dup stringwidth pop -2 div vshift R show }
      def\n/UP { dup vpt_ mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2
      hpt 2 mul def /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid
      {pop []} if 0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash}
      ifelse } def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL
      { stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
      mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul /udl
      exch def } def\n/PL { stroke userlinewidth setlinewidth } def\n/LTb {
      BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0 setdash 0 0 0
      setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 { PL [4 dl 2 dl] 0
      1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL } def\n/LT3 { PL [1 dl 1.5
      dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1 dl 2 dl] 0 1 1 DL }
      def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL } def\n/LT6 { PL [2 dl 2
      dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0 setdash\n \ \ gsave 1
      setlinecap M 0 0 V stroke grestore } def\n/Dia { stroke [] 0 setdash 2
      copy vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt
      neg vpt V closepath stroke\n \ Pnt } def\n/Pls { stroke [] 0 setdash
      vpt sub M 0 vpt2 V\n \ currentpoint stroke M\n \ hpt neg vpt neg R hpt2
      0 V stroke\n \ } def\n/Box { stroke [] 0 setdash 2 copy exch hpt sub
      exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
      closepath stroke\n \ Pnt } def\n/Crs { stroke [] 0 setdash exch hpt sub
      exch vpt add M\n \ hpt2 vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0
      R hpt2 vpt2 V stroke } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12
      mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      1.62 mul V closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs }
      def\n/BoxF { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill }
      def\n/TriUF { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt
      -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill
      } def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
      neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
      closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt 1.12
      mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash vpt add
      M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V
      closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy gsave\n
      \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath stroke
      grestore Pnt } def\n/PentF { stroke [] 0 setdash gsave\n \ translate 0
      hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath fill grestore }
      def\n/Circle { stroke [] 0 setdash 2 copy\n \ hpt 0 360 arc stroke Pnt
      } def\n/CircleF { stroke [] 0 setdash hpt 0 360 arc fill } def\n/C0 {
      BL [] 0 setdash 2 copy moveto vpt 90 450 \ arc } bind def\n/C1 { BL []
      0 setdash 2 copy \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C2 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C3 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
      bind def\n/C4 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
      \ vpt 180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 270 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C6 { BL [] 0
      setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 90 270 arc closepath
      fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
      def\n/C7 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 0 270
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
      } bind def\n/C8 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
      copy \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
      moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13 {
      BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
      setdash 2 copy vpt 0 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
      \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
      \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
      bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
      def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
      bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
      def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
      Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch vpt2
      vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy exch vpt
      sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 { BL [] 0
      setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt sub exch
      vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0 setdash 2
      copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare } bind
      def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt vpt2
      Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub vpt Square fill Bsquare
      } bind def\n/S9 { BL [] 0 setdash 2 copy vpt sub vpt vpt2 Rec fill
      Bsquare } bind def\n/S10 { BL [] 0 setdash 2 copy vpt sub vpt Square
      fill 2 copy exch vpt sub exch vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S11 { BL [] 0 setdash 2 copy vpt sub vpt Square fill 2 copy
      exch vpt sub exch vpt2 vpt Rec fill\n \ \ \ \ \ \ Bsquare } bind
      def\n/S12 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt
      Rec fill Bsquare } bind def\n/S13 { BL [] 0 setdash 2 copy exch vpt sub
      exch vpt sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill
      Bsquare } bind def\n/S14 { BL [] 0 setdash 2 copy exch vpt sub exch vpt
      sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square
      fill Bsquare } bind def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill
      Bsquare } bind def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke
      grestore } bind def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke
      grestore } bind def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke
      grestore } bind def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke
      grestore } bind def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke
      grestore } bind def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke
      grestore } bind def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke
      grestore } bind def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke
      grestore } bind def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke
      grestore } bind def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke
      grestore } bind def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke
      grestore } bind def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke
      grestore } bind def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke
      grestore } bind def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke
      grestore } bind def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke
      grestore } bind def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke
      grestore } bind def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg
      vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke }
      def\n/BoxE { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE
      { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke }
      def\n/TriDE { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt
      1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath
      stroke } def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M
      4 {72 rotate 0 hpt L} repeat\n \ closepath stroke grestore }
      def\n/CircE { stroke [] 0 setdash \n \ hpt 0 360 arc stroke }
      def\n/Opaque { gsave closepath 1 setgray fill grestore 0 setgray
      closepath } def\n/DiaW { stroke [] 0 setdash vpt add M\n \ hpt neg vpt
      neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V Opaque stroke }
      def\n/BoxW { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW {
      stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW
      { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW
      { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
      repeat\n \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash
      \n \ hpt 0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray
      fill grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
      makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
      ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0 get
      findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ] exch
      dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch 4 get
      {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n \ \ \ \ {dup 3
      get {2 get neg 0 exch R pop} {pop aload pop M} ifelse} {dup 5\n
      \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get stringwidth pop
      -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop -2 div 0 R 6 get\n
      \ \ \ \ show 2 index {aload pop M neg 3 -1 roll neg R pop pop} {pop pop
      pop\n \ \ \ \ pop aload pop M} ifelse }ifelse }ifelse } forall} bind
      def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get findfont exch 1 get
      scalefont\n \ \ \ \ setfont 6 get stringwidth pop add} {pop} ifelse}
      forall} bind def\n/MLshow { currentpoint stroke M\n \ 0 exch R MFshow }
      bind def\n/MRshow { currentpoint stroke M\n \ exch dup MFwidth neg 3 -1
      roll R MFshow } def\n/MCshow { currentpoint stroke M\n \ exch dup
      MFwidth -2 div 3 -1 roll R MFshow } def\nend\n%%EndProlog\ngnudict
      begin\ngsave\n50 50 translate\n0.050 0.050 scale\n0
      setgray\nnewpath\n(Helvetica) findfont 140 scalefont setfont\n1.000
      UL\nLTb\n574 280 M\n63 0 V\n6325 0 R\n-63 0 V\n stroke\n490 280
      M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-2)]\n] -46.7
      MRshow\ngrestore\n574 854 M\n63 0 V\n6325 0 R\n-63 0 V\n stroke\n490
      854 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-1.5)]\n]
      -46.7 MRshow\ngrestore\n574 1428 M\n63 0 V\n6325 0 R\n-63 0 V\n
      stroke\n490 1428 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 (-1)]\n] -46.7 MRshow\ngrestore\n574 2002 M\n63 0 V\n6325 0 R\n-63 0
      V\n stroke\n490 2002 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 (-0.5)]\n] -46.7 MRshow\ngrestore\n574 2576 M\n63 0 V\n6325 0
      R\n-63 0 V\n stroke\n490 2576 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 ( 0)]\n] -46.7 MRshow\ngrestore\n574 3150 M\n63 0
      V\n6325 0 R\n-63 0 V\n stroke\n490 3150 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 ( 0.5)]\n] -46.7
      MRshow\ngrestore\n574 3724 M\n63 0 V\n6325 0 R\n-63 0 V\n stroke\n490
      3724 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 ( 1)]\n]
      -46.7 MRshow\ngrestore\n574 4298 M\n63 0 V\n6325 0 R\n-63 0 V\n
      stroke\n490 4298 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 ( 1.5)]\n] -46.7 MRshow\ngrestore\n574 4872 M\n63 0 V\n6325 0 R\n-63
      0 V\n stroke\n490 4872 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0
      true true 0 ( 2)]\n] -46.7 MRshow\ngrestore\n718 280 M\n0 63 V\n0 4529
      R\n0 -63 V\n stroke\n718 140 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 (-1.5)]\n] -46.7 MCshow\ngrestore\n1735 280 M\n0 63
      V\n0 4529 R\n0 -63 V\n stroke\n1735 140 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 (-1)]\n] -46.7
      MCshow\ngrestore\n2751 280 M\n0 63 V\n0 4529 R\n0 -63 V\n stroke\n2751
      140 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-0.5)]\n]
      -46.7 MCshow\ngrestore\n3768 280 M\n0 63 V\n0 4529 R\n0 -63 V\n
      stroke\n3768 140 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 ( 0)]\n] -46.7 MCshow\ngrestore\n4785 280 M\n0 63 V\n0 4529 R\n0 -63
      V\n stroke\n4785 140 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 ( 0.5)]\n] -46.7 MCshow\ngrestore\n5801 280 M\n0 63 V\n0 4529
      R\n0 -63 V\n stroke\n5801 140 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 ( 1)]\n] -46.7 MCshow\ngrestore\n6818 280 M\n0 63 V\n0
      4529 R\n0 -63 V\n stroke\n6818 140 M\ngsave 0 setgray\n[ [(Helvetica)
      140.0 0.0 true true 0 ( 1.5)]\n] -46.7 MCshow\ngrestore\n1.000
      UL\nLTb\n574 280 M\n6388 0 V\n0 4592 V\n-6388 0 V\n574 280 L\n1.000
      UP\n1.000 UL\nLT0\n6311 4739 M\ngsave 0 setgray\n(x+sin\\(x\\))
      Rshow\ngrestore\n6395 4739 M\n399 0 V\n1519 280 M\n23 19 V\n64 53 V\n65
      55 V\n64 56 V\n65 56 V\n65 58 V\n64 58 V\n65 60 V\n64 60 V\n65 61 V\n64
      62 V\n65 63 V\n64 64 V\n65 64 V\n64 65 V\n65 66 V\n64 66 V\n65 67 V\n64
      68 V\n65 68 V\n64 69 V\n65 69 V\n64 70 V\n65 70 V\n64 71 V\n65 71 V\n65
      71 V\n64 72 V\n65 72 V\n64 72 V\n65 73 V\n64 72 V\n65 73 V\n64 73 V\n65
      73 V\n64 72 V\n65 73 V\n64 73 V\n65 73 V\n64 72 V\n65 73 V\n64 72 V\n65
      72 V\n64 72 V\n65 71 V\n65 71 V\n64 71 V\n65 70 V\n64 70 V\n65 69 V\n64
      69 V\n65 68 V\n64 68 V\n65 67 V\n64 66 V\n65 66 V\n64 65 V\n65 64 V\n64
      64 V\n65 63 V\n64 62 V\n65 61 V\n64 60 V\n65 60 V\n64 58 V\n65 58 V\n65
      56 V\n64 56 V\n65 55 V\n64 53 V\n23 19 V\n1.000
      UP\nstroke\ngrestore\nend\nshowpage\n%%Trailer\n%%DocumentFonts:
      Helvetica\n>|ps>||||||>

      \;
    </output>

    <\input|GNUplot] >
      set noclip ~set yrange[-30:10] ~plot x*(abs((x-4)/(x+4)))**(1./2.)\ 
    </input>

    <\output>
      <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
      temp.eps\n%%Creator: gnuplot 3.8h patchlevel 0\n%%CreationDate: Sun Apr
      \ 6 18:37:14 2003\n%%DocumentFonts: (atend)\n%%BoundingBox: 50 50 410
      302\n%%Orientation: Portrait\n%%EndComments\n/gnudict 256 dict
      def\ngnudict begin\n/Color false def\n/Solid false def\n/gnulinewidth
      5.000 def\n/userlinewidth gnulinewidth def\n/vshift -46 def\n/dl {10.0
      mul} def\n/hpt_ 31.5 def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_
      def\n/M {moveto} bind def\n/L {lineto} bind def\n/R {rmoveto} bind
      def\n/V {rlineto} bind def\n/N {newpath moveto} bind def\n/f {rlineto
      fill} bind def\n/vpt2 vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow {
      currentpoint stroke M\n \ 0 vshift R show } def\n/Rshow { currentpoint
      stroke M\n \ dup stringwidth pop neg vshift R show } def\n/Cshow {
      currentpoint stroke M\n \ dup stringwidth pop -2 div vshift R show }
      def\n/UP { dup vpt_ mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2
      hpt 2 mul def /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid
      {pop []} if 0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash}
      ifelse } def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL
      { stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
      mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul /udl
      exch def } def\n/PL { stroke userlinewidth setlinewidth } def\n/LTb {
      BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0 setdash 0 0 0
      setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 { PL [4 dl 2 dl] 0
      1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL } def\n/LT3 { PL [1 dl 1.5
      dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1 dl 2 dl] 0 1 1 DL }
      def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL } def\n/LT6 { PL [2 dl 2
      dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0 setdash\n \ \ gsave 1
      setlinecap M 0 0 V stroke grestore } def\n/Dia { stroke [] 0 setdash 2
      copy vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt
      neg vpt V closepath stroke\n \ Pnt } def\n/Pls { stroke [] 0 setdash
      vpt sub M 0 vpt2 V\n \ currentpoint stroke M\n \ hpt neg vpt neg R hpt2
      0 V stroke\n \ } def\n/Box { stroke [] 0 setdash 2 copy exch hpt sub
      exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
      closepath stroke\n \ Pnt } def\n/Crs { stroke [] 0 setdash exch hpt sub
      exch vpt add M\n \ hpt2 vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0
      R hpt2 vpt2 V stroke } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12
      mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      1.62 mul V closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs }
      def\n/BoxF { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill }
      def\n/TriUF { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt
      -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill
      } def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
      neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
      closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt 1.12
      mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash vpt add
      M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V
      closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy gsave\n
      \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath stroke
      grestore Pnt } def\n/PentF { stroke [] 0 setdash gsave\n \ translate 0
      hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath fill grestore }
      def\n/Circle { stroke [] 0 setdash 2 copy\n \ hpt 0 360 arc stroke Pnt
      } def\n/CircleF { stroke [] 0 setdash hpt 0 360 arc fill } def\n/C0 {
      BL [] 0 setdash 2 copy moveto vpt 90 450 \ arc } bind def\n/C1 { BL []
      0 setdash 2 copy \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C2 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C3 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
      bind def\n/C4 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
      \ vpt 180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 270 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C6 { BL [] 0
      setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 90 270 arc closepath
      fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
      def\n/C7 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 0 270
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
      } bind def\n/C8 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
      copy \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
      moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13 {
      BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
      setdash 2 copy vpt 0 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
      \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
      \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
      bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
      def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
      bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
      def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
      Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch vpt2
      vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy exch vpt
      sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 { BL [] 0
      setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt sub exch
      vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0 setdash 2
      copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare } bind
      def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt vpt2
      Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub vpt Square fill Bsquare
      } bind def\n/S9 { BL [] 0 setdash 2 copy vpt sub vpt vpt2 Rec fill
      Bsquare } bind def\n/S10 { BL [] 0 setdash 2 copy vpt sub vpt Square
      fill 2 copy exch vpt sub exch vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S11 { BL [] 0 setdash 2 copy vpt sub vpt Square fill 2 copy
      exch vpt sub exch vpt2 vpt Rec fill\n \ \ \ \ \ \ Bsquare } bind
      def\n/S12 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt
      Rec fill Bsquare } bind def\n/S13 { BL [] 0 setdash 2 copy exch vpt sub
      exch vpt sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill
      Bsquare } bind def\n/S14 { BL [] 0 setdash 2 copy exch vpt sub exch vpt
      sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square
      fill Bsquare } bind def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill
      Bsquare } bind def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke
      grestore } bind def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke
      grestore } bind def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke
      grestore } bind def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke
      grestore } bind def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke
      grestore } bind def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke
      grestore } bind def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke
      grestore } bind def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke
      grestore } bind def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke
      grestore } bind def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke
      grestore } bind def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke
      grestore } bind def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke
      grestore } bind def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke
      grestore } bind def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke
      grestore } bind def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke
      grestore } bind def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke
      grestore } bind def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg
      vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke }
      def\n/BoxE { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE
      { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke }
      def\n/TriDE { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt
      1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath
      stroke } def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M
      4 {72 rotate 0 hpt L} repeat\n \ closepath stroke grestore }
      def\n/CircE { stroke [] 0 setdash \n \ hpt 0 360 arc stroke }
      def\n/Opaque { gsave closepath 1 setgray fill grestore 0 setgray
      closepath } def\n/DiaW { stroke [] 0 setdash vpt add M\n \ hpt neg vpt
      neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V Opaque stroke }
      def\n/BoxW { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW {
      stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW
      { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW
      { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
      repeat\n \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash
      \n \ hpt 0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray
      fill grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
      makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
      ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0 get
      findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ] exch
      dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch 4 get
      {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n \ \ \ \ {dup 3
      get {2 get neg 0 exch R pop} {pop aload pop M} ifelse} {dup 5\n
      \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get stringwidth pop
      -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop -2 div 0 R 6 get\n
      \ \ \ \ show 2 index {aload pop M neg 3 -1 roll neg R pop pop} {pop pop
      pop\n \ \ \ \ pop aload pop M} ifelse }ifelse }ifelse } forall} bind
      def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get findfont exch 1 get
      scalefont\n \ \ \ \ setfont 6 get stringwidth pop add} {pop} ifelse}
      forall} bind def\n/MLshow { currentpoint stroke M\n \ 0 exch R MFshow }
      bind def\n/MRshow { currentpoint stroke M\n \ exch dup MFwidth neg 3 -1
      roll R MFshow } def\n/MCshow { currentpoint stroke M\n \ exch dup
      MFwidth -2 div 3 -1 roll R MFshow } def\nend\n%%EndProlog\ngnudict
      begin\ngsave\n50 50 translate\n0.050 0.050 scale\n0
      setgray\nnewpath\n(Helvetica) findfont 140 scalefont setfont\n1.000
      UL\nLTb\n490 280 M\n63 0 V\n6409 0 R\n-63 0 V\n stroke\n406 280
      M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-30)]\n]
      -46.7 MRshow\ngrestore\n490 854 M\n63 0 V\n6409 0 R\n-63 0 V\n
      stroke\n406 854 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 (-25)]\n] -46.7 MRshow\ngrestore\n490 1428 M\n63 0 V\n6409 0 R\n-63 0
      V\n stroke\n406 1428 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 (-20)]\n] -46.7 MRshow\ngrestore\n490 2002 M\n63 0 V\n6409 0
      R\n-63 0 V\n stroke\n406 2002 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 (-15)]\n] -46.7 MRshow\ngrestore\n490 2576 M\n63 0
      V\n6409 0 R\n-63 0 V\n stroke\n406 2576 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 (-10)]\n] -46.7
      MRshow\ngrestore\n490 3150 M\n63 0 V\n6409 0 R\n-63 0 V\n stroke\n406
      3150 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-5)]\n]
      -46.7 MRshow\ngrestore\n490 3724 M\n63 0 V\n6409 0 R\n-63 0 V\n
      stroke\n406 3724 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 ( 0)]\n] -46.7 MRshow\ngrestore\n490 4298 M\n63 0 V\n6409 0 R\n-63 0
      V\n stroke\n406 4298 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 ( 5)]\n] -46.7 MRshow\ngrestore\n490 4872 M\n63 0 V\n6409 0
      R\n-63 0 V\n stroke\n406 4872 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 ( 10)]\n] -46.7 MRshow\ngrestore\n490 280 M\n0 63 V\n0
      4529 R\n0 -63 V\n stroke\n490 140 M\ngsave 0 setgray\n[ [(Helvetica)
      140.0 0.0 true true 0 (-10)]\n] -46.7 MCshow\ngrestore\n2108 280 M\n0
      63 V\n0 4529 R\n0 -63 V\n stroke\n2108 140 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 (-5)]\n] -46.7
      MCshow\ngrestore\n3726 280 M\n0 63 V\n0 4529 R\n0 -63 V\n stroke\n3726
      140 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 ( 0)]\n]
      -46.7 MCshow\ngrestore\n5344 280 M\n0 63 V\n0 4529 R\n0 -63 V\n
      stroke\n5344 140 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 ( 5)]\n] -46.7 MCshow\ngrestore\n6962 280 M\n0 63 V\n0 4529 R\n0 -63
      V\n stroke\n6962 140 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 ( 10)]\n] -46.7 MCshow\ngrestore\n1.000 UL\nLTb\n490 280 M\n6472
      0 V\n0 4592 V\n-6472 0 V\n490 280 L\n1.000 UP\n1.000 UL\nLT0\n6311 4739
      M\ngsave 0 setgray\n(x*\\(abs\\(\\(x-4\\)/\\(x+4\\)\\)\\)**\\(1./2.\\))
      Rshow\ngrestore\n6395 4739 M\n399 0 V\n490 1970 M\n65 19 V\n66 18 V\n65
      18 V\n65 17 V\n66 17 V\n65 16 V\n66 16 V\n65 15 V\n65 15 V\n66 14 V\n65
      12 V\n65 12 V\n66 11 V\n65 9 V\n66 7 V\n65 6 V\n65 2 V\n66 0 V\n65 -4
      V\n65 -8 V\n66 -15 V\n65 -24 V\n66 -35 V\n65 -51 V\n65 -77 V\n66 -120
      V\n65 -201 V\n65 -393 V\n197 129 R\n65 695 V\n65 365 V\n66 239 V\n65
      175 V\n65 135 V\n66 110 V\n65 92 V\n66 78 V\n65 68 V\n65 60 V\n66 53
      V\n65 47 V\n65 42 V\n66 38 V\n65 35 V\n66 31 V\n65 28 V\n65 26 V\n66 23
      V\n65 21 V\n65 19 V\n66 17 V\n65 15 V\n66 13 V\n65 11 V\n65 10 V\n66 8
      V\n65 6 V\n65 4 V\n66 2 V\n65 1 V\n66 -2 V\n65 -4 V\n65 -7 V\n66 -10
      V\n65 -14 V\n65 -22 V\n66 -39 V\n65 23 V\n66 38 V\n65 31 V\n65 27 V\n66
      26 V\n65 25 V\n65 24 V\n66 23 V\n65 24 V\n66 22 V\n65 23 V\n65 23 V\n66
      22 V\n65 23 V\n65 22 V\n66 23 V\n65 22 V\n66 22 V\n65 23 V\n65 22 V\n66
      22 V\n65 23 V\n65 22 V\n66 22 V\n65 23 V\n66 22 V\n65 22 V\n65 23 V\n66
      22 V\n65 23 V\n1.000 UP\nstroke\ngrestore\nend\nshowpage\n%%Trailer\n%%DocumentFonts:
      Helvetica\n>|ps>||||||>

      \;
    </output>

    <\input|GNUplot] >
      \;
    </input>

    \;

    <\input|GNUplot] >
      set key left ~set xlabel 'x:[cm]' ~ plot [-pi/2:pi/2] x+sin(x)
    </input>

    <\output>
      <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
      temp.eps\n%%Creator: gnuplot 3.8h patchlevel 0\n%%CreationDate: Sun Apr
      \ 6 12:34:51 2003\n%%DocumentFonts: (atend)\n%%BoundingBox: 50 50 410
      302\n%%Orientation: Portrait\n%%EndComments\n/gnudict 256 dict
      def\ngnudict begin\n/Color false def\n/Solid false def\n/gnulinewidth
      5.000 def\n/userlinewidth gnulinewidth def\n/vshift -46 def\n/dl {10.0
      mul} def\n/hpt_ 31.5 def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_
      def\n/M {moveto} bind def\n/L {lineto} bind def\n/R {rmoveto} bind
      def\n/V {rlineto} bind def\n/N {newpath moveto} bind def\n/f {rlineto
      fill} bind def\n/vpt2 vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow {
      currentpoint stroke M\n \ 0 vshift R show } def\n/Rshow { currentpoint
      stroke M\n \ dup stringwidth pop neg vshift R show } def\n/Cshow {
      currentpoint stroke M\n \ dup stringwidth pop -2 div vshift R show }
      def\n/UP { dup vpt_ mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2
      hpt 2 mul def /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid
      {pop []} if 0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash}
      ifelse } def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL
      { stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
      mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul /udl
      exch def } def\n/PL { stroke userlinewidth setlinewidth } def\n/LTb {
      BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0 setdash 0 0 0
      setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 { PL [4 dl 2 dl] 0
      1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL } def\n/LT3 { PL [1 dl 1.5
      dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1 dl 2 dl] 0 1 1 DL }
      def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL } def\n/LT6 { PL [2 dl 2
      dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0 setdash\n \ \ gsave 1
      setlinecap M 0 0 V stroke grestore } def\n/Dia { stroke [] 0 setdash 2
      copy vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt
      neg vpt V closepath stroke\n \ Pnt } def\n/Pls { stroke [] 0 setdash
      vpt sub M 0 vpt2 V\n \ currentpoint stroke M\n \ hpt neg vpt neg R hpt2
      0 V stroke\n \ } def\n/Box { stroke [] 0 setdash 2 copy exch hpt sub
      exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
      closepath stroke\n \ Pnt } def\n/Crs { stroke [] 0 setdash exch hpt sub
      exch vpt add M\n \ hpt2 vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0
      R hpt2 vpt2 V stroke } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12
      mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      1.62 mul V closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs }
      def\n/BoxF { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill }
      def\n/TriUF { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt
      -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill
      } def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
      neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
      closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt 1.12
      mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash vpt add
      M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V
      closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy gsave\n
      \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath stroke
      grestore Pnt } def\n/PentF { stroke [] 0 setdash gsave\n \ translate 0
      hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath fill grestore }
      def\n/Circle { stroke [] 0 setdash 2 copy\n \ hpt 0 360 arc stroke Pnt
      } def\n/CircleF { stroke [] 0 setdash hpt 0 360 arc fill } def\n/C0 {
      BL [] 0 setdash 2 copy moveto vpt 90 450 \ arc } bind def\n/C1 { BL []
      0 setdash 2 copy \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C2 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C3 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
      bind def\n/C4 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
      \ vpt 180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 270 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C6 { BL [] 0
      setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 90 270 arc closepath
      fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
      def\n/C7 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 0 270
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
      } bind def\n/C8 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
      copy \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
      moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13 {
      BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
      setdash 2 copy vpt 0 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
      \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
      \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
      bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
      def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
      bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
      def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
      Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch vpt2
      vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy exch vpt
      sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 { BL [] 0
      setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt sub exch
      vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0 setdash 2
      copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare } bind
      def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt vpt2
      Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub vpt Square fill Bsquare
      } bind def\n/S9 { BL [] 0 setdash 2 copy vpt sub vpt vpt2 Rec fill
      Bsquare } bind def\n/S10 { BL [] 0 setdash 2 copy vpt sub vpt Square
      fill 2 copy exch vpt sub exch vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S11 { BL [] 0 setdash 2 copy vpt sub vpt Square fill 2 copy
      exch vpt sub exch vpt2 vpt Rec fill\n \ \ \ \ \ \ Bsquare } bind
      def\n/S12 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt
      Rec fill Bsquare } bind def\n/S13 { BL [] 0 setdash 2 copy exch vpt sub
      exch vpt sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill
      Bsquare } bind def\n/S14 { BL [] 0 setdash 2 copy exch vpt sub exch vpt
      sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square
      fill Bsquare } bind def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill
      Bsquare } bind def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke
      grestore } bind def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke
      grestore } bind def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke
      grestore } bind def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke
      grestore } bind def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke
      grestore } bind def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke
      grestore } bind def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke
      grestore } bind def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke
      grestore } bind def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke
      grestore } bind def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke
      grestore } bind def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke
      grestore } bind def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke
      grestore } bind def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke
      grestore } bind def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke
      grestore } bind def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke
      grestore } bind def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke
      grestore } bind def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg
      vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke }
      def\n/BoxE { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE
      { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke }
      def\n/TriDE { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt
      1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath
      stroke } def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M
      4 {72 rotate 0 hpt L} repeat\n \ closepath stroke grestore }
      def\n/CircE { stroke [] 0 setdash \n \ hpt 0 360 arc stroke }
      def\n/Opaque { gsave closepath 1 setgray fill grestore 0 setgray
      closepath } def\n/DiaW { stroke [] 0 setdash vpt add M\n \ hpt neg vpt
      neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V Opaque stroke }
      def\n/BoxW { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW {
      stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW
      { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW
      { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
      repeat\n \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash
      \n \ hpt 0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray
      fill grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
      makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
      ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0 get
      findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ] exch
      dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch 4 get
      {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n \ \ \ \ {dup 3
      get {2 get neg 0 exch R pop} {pop aload pop M} ifelse} {dup 5\n
      \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get stringwidth pop
      -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop -2 div 0 R 6 get\n
      \ \ \ \ show 2 index {aload pop M neg 3 -1 roll neg R pop pop} {pop pop
      pop\n \ \ \ \ pop aload pop M} ifelse }ifelse }ifelse } forall} bind
      def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get findfont exch 1 get
      scalefont\n \ \ \ \ setfont 6 get stringwidth pop add} {pop} ifelse}
      forall} bind def\n/MLshow { currentpoint stroke M\n \ 0 exch R MFshow }
      bind def\n/MRshow { currentpoint stroke M\n \ exch dup MFwidth neg 3 -1
      roll R MFshow } def\n/MCshow { currentpoint stroke M\n \ exch dup
      MFwidth -2 div 3 -1 roll R MFshow } def\nend\n%%EndProlog\ngnudict
      begin\ngsave\n50 50 translate\n0.050 0.050 scale\n0
      setgray\nnewpath\n(Helvetica) findfont 140 scalefont setfont\n1.000
      UL\nLTb\n406 420 M\n63 0 V\n6493 0 R\n-63 0 V\n stroke\n322 420
      M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-3)]\n] -46.7
      MRshow\ngrestore\n406 1162 M\n63 0 V\n6493 0 R\n-63 0 V\n stroke\n322
      1162 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-2)]\n]
      -46.7 MRshow\ngrestore\n406 1904 M\n63 0 V\n6493 0 R\n-63 0 V\n
      stroke\n322 1904 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 (-1)]\n] -46.7 MRshow\ngrestore\n406 2646 M\n63 0 V\n6493 0 R\n-63 0
      V\n stroke\n322 2646 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 ( 0)]\n] -46.7 MRshow\ngrestore\n406 3388 M\n63 0 V\n6493 0
      R\n-63 0 V\n stroke\n322 3388 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 ( 1)]\n] -46.7 MRshow\ngrestore\n406 4130 M\n63 0
      V\n6493 0 R\n-63 0 V\n stroke\n322 4130 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 ( 2)]\n] -46.7 MRshow\ngrestore\n406
      4872 M\n63 0 V\n6493 0 R\n-63 0 V\n stroke\n322 4872 M\ngsave 0
      setgray\n[ [(Helvetica) 140.0 0.0 true true 0 ( 3)]\n] -46.7
      MRshow\ngrestore\n554 420 M\n0 63 V\n0 4389 R\n0 -63 V\n stroke\n554
      280 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-1.5)]\n]
      -46.7 MCshow\ngrestore\n1597 420 M\n0 63 V\n0 4389 R\n0 -63 V\n
      stroke\n1597 280 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 (-1)]\n] -46.7 MCshow\ngrestore\n2641 420 M\n0 63 V\n0 4389 R\n0 -63
      V\n stroke\n2641 280 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 (-0.5)]\n] -46.7 MCshow\ngrestore\n3684 420 M\n0 63 V\n0 4389
      R\n0 -63 V\n stroke\n3684 280 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 ( 0)]\n] -46.7 MCshow\ngrestore\n4727 420 M\n0 63 V\n0
      4389 R\n0 -63 V\n stroke\n4727 280 M\ngsave 0 setgray\n[ [(Helvetica)
      140.0 0.0 true true 0 ( 0.5)]\n] -46.7 MCshow\ngrestore\n5771 420 M\n0
      63 V\n0 4389 R\n0 -63 V\n stroke\n5771 280 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 ( 1)]\n] -46.7
      MCshow\ngrestore\n6814 420 M\n0 63 V\n0 4389 R\n0 -63 V\n stroke\n6814
      280 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 ( 1.5)]\n]
      -46.7 MCshow\ngrestore\n1.000 UL\nLTb\n406 420 M\n6556 0 V\n0 4452
      V\n-6556 0 V\n406 420 L\n stroke\n3684 70 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 (x:[cm])]\n] -46.7
      MCshow\ngrestore\n1.000 UP\n1.000 UL\nLT0\n1162 4739 M\ngsave 0
      setgray\n(x+sin\\(x\\)) Rshow\ngrestore\n1246 4739 M\n399 0 V\n406 738
      M\n66 24 V\n66 25 V\n67 25 V\n66 27 V\n66 27 V\n66 27 V\n67 29 V\n66 29
      V\n66 29 V\n66 31 V\n66 31 V\n67 32 V\n66 33 V\n66 33 V\n66 34 V\n67 35
      V\n66 35 V\n66 36 V\n66 37 V\n66 37 V\n67 38 V\n66 38 V\n66 39 V\n66 40
      V\n67 40 V\n66 40 V\n66 41 V\n66 42 V\n66 42 V\n67 42 V\n66 43 V\n66 44
      V\n66 43 V\n67 45 V\n66 44 V\n66 45 V\n66 45 V\n66 45 V\n67 46 V\n66 46
      V\n66 46 V\n66 46 V\n67 47 V\n66 47 V\n66 46 V\n66 47 V\n66 47 V\n67 47
      V\n66 47 V\n66 48 V\n66 47 V\n67 47 V\n66 47 V\n66 47 V\n66 46 V\n66 47
      V\n67 47 V\n66 46 V\n66 46 V\n66 46 V\n67 46 V\n66 45 V\n66 45 V\n66 45
      V\n66 44 V\n67 45 V\n66 43 V\n66 44 V\n66 43 V\n67 42 V\n66 42 V\n66 42
      V\n66 41 V\n66 40 V\n67 40 V\n66 40 V\n66 39 V\n66 38 V\n67 38 V\n66 37
      V\n66 37 V\n66 36 V\n66 35 V\n67 35 V\n66 34 V\n66 33 V\n66 33 V\n67 32
      V\n66 31 V\n66 31 V\n66 29 V\n66 29 V\n67 29 V\n66 27 V\n66 27 V\n66 27
      V\n67 25 V\n66 25 V\n66 24 V\n1.000
      UP\nstroke\ngrestore\nend\nshowpage\n%%Trailer\n%%DocumentFonts:
      Helvetica\n>|ps>||||||>

      \;
    </output>

    <\input|GNUplot] >
      set xlabel 'x:[cm]' ~ plot sin(x)
    </input>

    <\output>
      <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
      temp.eps\n%%Creator: gnuplot 3.8h patchlevel 0\n%%CreationDate: Thu Feb
      20 22:05:38 2003\n%%DocumentFonts: (atend)\n%%BoundingBox: 50 50 410
      302\n%%Orientation: Portrait\n%%EndComments\n/gnudict 256 dict
      def\ngnudict begin\n/Color false def\n/Solid false def\n/gnulinewidth
      5.000 def\n/userlinewidth gnulinewidth def\n/vshift -46 def\n/dl {10.0
      mul} def\n/hpt_ 31.5 def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_
      def\n/M {moveto} bind def\n/L {lineto} bind def\n/R {rmoveto} bind
      def\n/V {rlineto} bind def\n/N {newpath moveto} bind def\n/f {rlineto
      fill} bind def\n/vpt2 vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow {
      currentpoint stroke M\n \ 0 vshift R show } def\n/Rshow { currentpoint
      stroke M\n \ dup stringwidth pop neg vshift R show } def\n/Cshow {
      currentpoint stroke M\n \ dup stringwidth pop -2 div vshift R show }
      def\n/UP { dup vpt_ mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2
      hpt 2 mul def /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid
      {pop []} if 0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash}
      ifelse } def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL
      { stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
      mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul /udl
      exch def } def\n/PL { stroke userlinewidth setlinewidth } def\n/LTb {
      BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0 setdash 0 0 0
      setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 { PL [4 dl 2 dl] 0
      1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL } def\n/LT3 { PL [1 dl 1.5
      dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1 dl 2 dl] 0 1 1 DL }
      def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL } def\n/LT6 { PL [2 dl 2
      dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0 setdash\n \ \ gsave 1
      setlinecap M 0 0 V stroke grestore } def\n/Dia { stroke [] 0 setdash 2
      copy vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt
      neg vpt V closepath stroke\n \ Pnt } def\n/Pls { stroke [] 0 setdash
      vpt sub M 0 vpt2 V\n \ currentpoint stroke M\n \ hpt neg vpt neg R hpt2
      0 V stroke\n \ } def\n/Box { stroke [] 0 setdash 2 copy exch hpt sub
      exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
      closepath stroke\n \ Pnt } def\n/Crs { stroke [] 0 setdash exch hpt sub
      exch vpt add M\n \ hpt2 vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0
      R hpt2 vpt2 V stroke } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12
      mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      1.62 mul V closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs }
      def\n/BoxF { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill }
      def\n/TriUF { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt
      -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill
      } def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
      neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
      closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt 1.12
      mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash vpt add
      M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V
      closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy gsave\n
      \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath stroke
      grestore Pnt } def\n/PentF { stroke [] 0 setdash gsave\n \ translate 0
      hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath fill grestore }
      def\n/Circle { stroke [] 0 setdash 2 copy\n \ hpt 0 360 arc stroke Pnt
      } def\n/CircleF { stroke [] 0 setdash hpt 0 360 arc fill } def\n/C0 {
      BL [] 0 setdash 2 copy moveto vpt 90 450 \ arc } bind def\n/C1 { BL []
      0 setdash 2 copy \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C2 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C3 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
      bind def\n/C4 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
      \ vpt 180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 270 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C6 { BL [] 0
      setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 90 270 arc closepath
      fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
      def\n/C7 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 0 270
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
      } bind def\n/C8 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
      copy \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
      moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13 {
      BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
      setdash 2 copy vpt 0 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
      \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
      \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
      bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
      def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
      bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
      def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
      Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch vpt2
      vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy exch vpt
      sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 { BL [] 0
      setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt sub exch
      vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0 setdash 2
      copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare } bind
      def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt vpt2
      Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub vpt Square fill Bsquare
      } bind def\n/S9 { BL [] 0 setdash 2 copy vpt sub vpt vpt2 Rec fill
      Bsquare } bind def\n/S10 { BL [] 0 setdash 2 copy vpt sub vpt Square
      fill 2 copy exch vpt sub exch vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S11 { BL [] 0 setdash 2 copy vpt sub vpt Square fill 2 copy
      exch vpt sub exch vpt2 vpt Rec fill\n \ \ \ \ \ \ Bsquare } bind
      def\n/S12 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt
      Rec fill Bsquare } bind def\n/S13 { BL [] 0 setdash 2 copy exch vpt sub
      exch vpt sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill
      Bsquare } bind def\n/S14 { BL [] 0 setdash 2 copy exch vpt sub exch vpt
      sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square
      fill Bsquare } bind def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill
      Bsquare } bind def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke
      grestore } bind def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke
      grestore } bind def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke
      grestore } bind def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke
      grestore } bind def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke
      grestore } bind def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke
      grestore } bind def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke
      grestore } bind def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke
      grestore } bind def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke
      grestore } bind def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke
      grestore } bind def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke
      grestore } bind def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke
      grestore } bind def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke
      grestore } bind def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke
      grestore } bind def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke
      grestore } bind def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke
      grestore } bind def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg
      vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke }
      def\n/BoxE { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE
      { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke }
      def\n/TriDE { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt
      1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath
      stroke } def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M
      4 {72 rotate 0 hpt L} repeat\n \ closepath stroke grestore }
      def\n/CircE { stroke [] 0 setdash \n \ hpt 0 360 arc stroke }
      def\n/Opaque { gsave closepath 1 setgray fill grestore 0 setgray
      closepath } def\n/DiaW { stroke [] 0 setdash vpt add M\n \ hpt neg vpt
      neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V Opaque stroke }
      def\n/BoxW { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW {
      stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW
      { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW
      { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
      repeat\n \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash
      \n \ hpt 0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray
      fill grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
      makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
      ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0 get
      findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ] exch
      dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch 4 get
      {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n \ \ \ \ {dup 3
      get {2 get neg 0 exch R pop} {pop aload pop M} ifelse} {dup 5\n
      \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get stringwidth pop
      -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop -2 div 0 R 6 get\n
      \ \ \ \ show 2 index {aload pop M neg 3 -1 roll neg R pop pop} {pop pop
      pop\n \ \ \ \ pop aload pop M} ifelse }ifelse }ifelse } forall} bind
      def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get findfont exch 1 get
      scalefont\n \ \ \ \ setfont 6 get stringwidth pop add} {pop} ifelse}
      forall} bind def\n/MLshow { currentpoint stroke M\n \ 0 exch R MFshow }
      bind def\n/MRshow { currentpoint stroke M\n \ exch dup MFwidth neg 3 -1
      roll R MFshow } def\n/MCshow { currentpoint stroke M\n \ exch dup
      MFwidth -2 div 3 -1 roll R MFshow } def\nend\n%%EndProlog\ngnudict
      begin\ngsave\n50 50 translate\n0.050 0.050 scale\n0
      setgray\nnewpath\n(Helvetica) findfont 140 scalefont setfont\n1.000
      UL\nLTb\n574 420 M\n63 0 V\n6325 0 R\n-63 0 V\n stroke\n490 420
      M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-1)]\n] -46.7
      MRshow\ngrestore\n574 865 M\n63 0 V\n6325 0 R\n-63 0 V\n stroke\n490
      865 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-0.8)]\n]
      -46.7 MRshow\ngrestore\n574 1310 M\n63 0 V\n6325 0 R\n-63 0 V\n
      stroke\n490 1310 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 (-0.6)]\n] -46.7 MRshow\ngrestore\n574 1756 M\n63 0 V\n6325 0 R\n-63
      0 V\n stroke\n490 1756 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0
      true true 0 (-0.4)]\n] -46.7 MRshow\ngrestore\n574 2201 M\n63 0 V\n6325
      0 R\n-63 0 V\n stroke\n490 2201 M\ngsave 0 setgray\n[ [(Helvetica)
      140.0 0.0 true true 0 (-0.2)]\n] -46.7 MRshow\ngrestore\n574 2646 M\n63
      0 V\n6325 0 R\n-63 0 V\n stroke\n490 2646 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 ( 0)]\n] -46.7 MRshow\ngrestore\n574
      3091 M\n63 0 V\n6325 0 R\n-63 0 V\n stroke\n490 3091 M\ngsave 0
      setgray\n[ [(Helvetica) 140.0 0.0 true true 0 ( 0.2)]\n] -46.7
      MRshow\ngrestore\n574 3536 M\n63 0 V\n6325 0 R\n-63 0 V\n stroke\n490
      3536 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (
      0.4)]\n] -46.7 MRshow\ngrestore\n574 3982 M\n63 0 V\n6325 0 R\n-63 0
      V\n stroke\n490 3982 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 ( 0.6)]\n] -46.7 MRshow\ngrestore\n574 4427 M\n63 0 V\n6325 0
      R\n-63 0 V\n stroke\n490 4427 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 ( 0.8)]\n] -46.7 MRshow\ngrestore\n574 4872 M\n63 0
      V\n6325 0 R\n-63 0 V\n stroke\n490 4872 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 ( 1)]\n] -46.7 MRshow\ngrestore\n574
      420 M\n0 63 V\n0 4389 R\n0 -63 V\n stroke\n574 280 M\ngsave 0
      setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-10)]\n] -46.7
      MCshow\ngrestore\n2171 420 M\n0 63 V\n0 4389 R\n0 -63 V\n stroke\n2171
      280 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-5)]\n]
      -46.7 MCshow\ngrestore\n3768 420 M\n0 63 V\n0 4389 R\n0 -63 V\n
      stroke\n3768 280 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 ( 0)]\n] -46.7 MCshow\ngrestore\n5365 420 M\n0 63 V\n0 4389 R\n0 -63
      V\n stroke\n5365 280 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 ( 5)]\n] -46.7 MCshow\ngrestore\n6962 420 M\n0 63 V\n0 4389 R\n0
      -63 V\n stroke\n6962 280 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0
      true true 0 ( 10)]\n] -46.7 MCshow\ngrestore\n1.000 UL\nLTb\n574 420
      M\n6388 0 V\n0 4452 V\n-6388 0 V\n574 420 L\n stroke\n3768 70 M\ngsave
      0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (x:[cm])]\n] -46.7
      MCshow\ngrestore\n1.000 UP\n1.000 UL\nLT0\n6311 4739 M\ngsave 0
      setgray\n(sin\\(x\\)) Rshow\ngrestore\n6395 4739 M\n399 0 V\n574 3857
      M\n65 -399 V\n64 -433 V\n65 -448 V\n64 -445 V\n65 -424 V\n64 -386 V\n65
      -332 V\n64 -265 V\n65 -186 V\n64 -101 V\n65 -12 V\n64 80 V\n65 166
      V\n64 246 V\n65 317 V\n64 374 V\n65 417 V\n64 441 V\n65 449 V\n65 438
      V\n64 409 V\n65 364 V\n64 303 V\n65 231 V\n64 149 V\n65 61 V\n64 -30
      V\n65 -119 V\n64 -203 V\n65 -280 V\n64 -344 V\n65 -395 V\n64 -430 V\n65
      -447 V\n64 -446 V\n65 -427 V\n64 -391 V\n65 -338 V\n64 -272 V\n65 -195
      V\n65 -110 V\n64 -21 V\n65 70 V\n64 158 V\n65 239 V\n64 310 V\n65 369
      V\n64 413 V\n65 440 V\n64 448 V\n65 440 V\n64 413 V\n65 369 V\n64 310
      V\n65 239 V\n64 158 V\n65 70 V\n64 -21 V\n65 -110 V\n65 -195 V\n64 -272
      V\n65 -338 V\n64 -391 V\n65 -427 V\n64 -446 V\n65 -447 V\n64 -430 V\n65
      -395 V\n64 -344 V\n65 -280 V\n64 -203 V\n65 -119 V\n64 -30 V\n65 61
      V\n64 149 V\n65 231 V\n64 303 V\n65 364 V\n64 409 V\n65 438 V\n65 449
      V\n64 441 V\n65 417 V\n64 374 V\n65 317 V\n64 246 V\n65 166 V\n64 80
      V\n65 -12 V\n64 -101 V\n65 -186 V\n64 -265 V\n65 -332 V\n64 -386 V\n65
      -424 V\n64 -445 V\n65 -448 V\n64 -433 V\n65 -399 V\n1.000
      UP\nstroke\ngrestore\nend\nshowpage\n%%Trailer\n%%DocumentFonts:
      Helvetica\n>|ps>||||||>

      \;
    </output>

    <\input|GNUplot] >
      set pm3d hidden 100 ~set style line 100 lt 3
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~set nosurface
      ~set size 0.7,1 ~set view 80,180,1,1 \ ~set noborder
      \ \ \ \ \ \ \ \ \ \ \ \ ~set noxtics ~set noytics ~set noztics ~set
      parametric ~set samples 36 \ \ \ \ \ \ \ ~set isosamples 20,36 ~set
      ticslevel 0 \ \ ~set nocolorbox \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~set
      urange [0:pi] ~set vrange [0:2*pi] \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~splot
      sin(u)*cos(v),sin(u)*sin(v),cos(u)
    </input>

    <\output>
      <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
      temp.eps\n%%Creator: gnuplot 3.8h patchlevel 0\n%%CreationDate: Mon Mar
      31 07:27:25 2003\n%%DocumentFonts: (atend)\n%%BoundingBox: 50 50 301
      302\n%%Orientation: Portrait\n%%EndComments\n/gnudict 256 dict
      def\ngnudict begin\n/Color false def\n/Solid false def\n/gnulinewidth
      5.000 def\n/userlinewidth gnulinewidth def\n/vshift -46 def\n/dl {10.0
      mul} def\n/hpt_ 31.5 def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_
      def\n/M {moveto} bind def\n/L {lineto} bind def\n/R {rmoveto} bind
      def\n/V {rlineto} bind def\n/N {newpath moveto} bind def\n/f {rlineto
      fill} bind def\n/vpt2 vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow {
      currentpoint stroke M\n \ 0 vshift R show } def\n/Rshow { currentpoint
      stroke M\n \ dup stringwidth pop neg vshift R show } def\n/Cshow {
      currentpoint stroke M\n \ dup stringwidth pop -2 div vshift R show }
      def\n/UP { dup vpt_ mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2
      hpt 2 mul def /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid
      {pop []} if 0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash}
      ifelse } def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL
      { stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
      mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul /udl
      exch def } def\n/PL { stroke userlinewidth setlinewidth } def\n/LTb {
      BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0 setdash 0 0 0
      setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 { PL [4 dl 2 dl] 0
      1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL } def\n/LT3 { PL [1 dl 1.5
      dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1 dl 2 dl] 0 1 1 DL }
      def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL } def\n/LT6 { PL [2 dl 2
      dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0 setdash\n \ \ gsave 1
      setlinecap M 0 0 V stroke grestore } def\n/Dia { stroke [] 0 setdash 2
      copy vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt
      neg vpt V closepath stroke\n \ Pnt } def\n/Pls { stroke [] 0 setdash
      vpt sub M 0 vpt2 V\n \ currentpoint stroke M\n \ hpt neg vpt neg R hpt2
      0 V stroke\n \ } def\n/Box { stroke [] 0 setdash 2 copy exch hpt sub
      exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
      closepath stroke\n \ Pnt } def\n/Crs { stroke [] 0 setdash exch hpt sub
      exch vpt add M\n \ hpt2 vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0
      R hpt2 vpt2 V stroke } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12
      mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      1.62 mul V closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs }
      def\n/BoxF { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill }
      def\n/TriUF { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt
      -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill
      } def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
      neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
      closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt 1.12
      mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash vpt add
      M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V
      closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy gsave\n
      \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath stroke
      grestore Pnt } def\n/PentF { stroke [] 0 setdash gsave\n \ translate 0
      hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath fill grestore }
      def\n/Circle { stroke [] 0 setdash 2 copy\n \ hpt 0 360 arc stroke Pnt
      } def\n/CircleF { stroke [] 0 setdash hpt 0 360 arc fill } def\n/C0 {
      BL [] 0 setdash 2 copy moveto vpt 90 450 \ arc } bind def\n/C1 { BL []
      0 setdash 2 copy \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C2 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C3 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
      bind def\n/C4 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
      \ vpt 180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 270 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C6 { BL [] 0
      setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 90 270 arc closepath
      fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
      def\n/C7 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 0 270
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
      } bind def\n/C8 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
      copy \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
      moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13 {
      BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
      setdash 2 copy vpt 0 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
      \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
      \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
      bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
      def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
      bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
      def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
      Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch vpt2
      vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy exch vpt
      sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 { BL [] 0
      setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt sub exch
      vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0 setdash 2
      copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare } bind
      def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt vpt2
      Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub vpt Square fill Bsquare
      } bind def\n/S9 { BL [] 0 setdash 2 copy vpt sub vpt vpt2 Rec fill
      Bsquare } bind def\n/S10 { BL [] 0 setdash 2 copy vpt sub vpt Square
      fill 2 copy exch vpt sub exch vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S11 { BL [] 0 setdash 2 copy vpt sub vpt Square fill 2 copy
      exch vpt sub exch vpt2 vpt Rec fill\n \ \ \ \ \ \ Bsquare } bind
      def\n/S12 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt
      Rec fill Bsquare } bind def\n/S13 { BL [] 0 setdash 2 copy exch vpt sub
      exch vpt sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill
      Bsquare } bind def\n/S14 { BL [] 0 setdash 2 copy exch vpt sub exch vpt
      sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square
      fill Bsquare } bind def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill
      Bsquare } bind def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke
      grestore } bind def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke
      grestore } bind def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke
      grestore } bind def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke
      grestore } bind def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke
      grestore } bind def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke
      grestore } bind def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke
      grestore } bind def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke
      grestore } bind def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke
      grestore } bind def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke
      grestore } bind def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke
      grestore } bind def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke
      grestore } bind def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke
      grestore } bind def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke
      grestore } bind def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke
      grestore } bind def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke
      grestore } bind def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg
      vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke }
      def\n/BoxE { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE
      { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke }
      def\n/TriDE { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt
      1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath
      stroke } def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M
      4 {72 rotate 0 hpt L} repeat\n \ closepath stroke grestore }
      def\n/CircE { stroke [] 0 setdash \n \ hpt 0 360 arc stroke }
      def\n/Opaque { gsave closepath 1 setgray fill grestore 0 setgray
      closepath } def\n/DiaW { stroke [] 0 setdash vpt add M\n \ hpt neg vpt
      neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V Opaque stroke }
      def\n/BoxW { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW {
      stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW
      { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW
      { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
      repeat\n \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash
      \n \ hpt 0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray
      fill grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
      makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
      ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0 get
      findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ] exch
      dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch 4 get
      {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n \ \ \ \ {dup 3
      get {2 get neg 0 exch R pop} {pop aload pop M} ifelse} {dup 5\n
      \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get stringwidth pop
      -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop -2 div 0 R 6 get\n
      \ \ \ \ show 2 index {aload pop M neg 3 -1 roll neg R pop pop} {pop pop
      pop\n \ \ \ \ pop aload pop M} ifelse }ifelse }ifelse } forall} bind
      def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get findfont exch 1 get
      scalefont\n \ \ \ \ setfont 6 get stringwidth pop add} {pop} ifelse}
      forall} bind def\n/MLshow { currentpoint stroke M\n \ 0 exch R MFshow }
      bind def\n/MRshow { currentpoint stroke M\n \ exch dup MFwidth neg 3 -1
      roll R MFshow } def\n/MCshow { currentpoint stroke M\n \ exch dup
      MFwidth -2 div 3 -1 roll R MFshow } def\nend\n%%EndProlog\ngnudict
      begin\ngsave\n50 50 translate\n0.050 0.050 scale\n0
      setgray\nnewpath\n(Helvetica) findfont 140 scalefont setfont\n1.000
      UL\nLTb\ngsave %% colour palette begin\n/maxcolors 0
      def\n/maxcolorsLast {maxcolors 1 sub maxcolors div} def\n/pm3dround
      {maxcolors 0 gt {dup maxcolorsLast ge {pop 1} {maxcolors mul floor
      maxcolors div} ifelse} if} def\n/cF7 {sqrt} bind def\t% sqrt(x)\n/cF5
      {dup dup mul mul} bind def\t% x^3\n/cF15 {360 mul sin} bind def\t%
      sin(360x)\nColor true and { % COLOUR vs. GRAY map\n \ /g {stroke
      pm3dround dup cF7 exch dup cF5 exch cF15 setrgbcolor} bind def\n \ /h
      {rlineto rlineto rlineto fill} bind def\n}{\n \ /g {stroke pm3dround
      setgray} bind def\n \ /h {rlineto rlineto rlineto fill} bind def\n}
      ifelse\n%pm3d_map_begin\n.001 g 2404 1335 N 0 0 116 -9 1 4 h\n1.000
      UP\n1.000 UL\nLT2\n2404 1335 M\n117 -5 V\n-116 9 V\n-1 -4 V\n.005 g
      2287 1350 N -1 -4 114 -18 4 7 h\n1.000 UP\n1.000 UL\nLT2\n2287 1350
      M\n117 -15 V\n1 4 V\n-114 18 V\n-4 -7 V\n.013 g 2172 1375 N -4 -7 113
      -29 6 11 h\n1.000 UP\n1.000 UL\nLT2\n2172 1375 M\n115 -25 V\n4 7
      V\n-113 29 V\n-6 -11 V\n.025 g 2060 1410 N -6 -11 110 -38 8 14 h\n1.000
      UP\n1.000 UL\nLT2\n2060 1410 M\n112 -35 V\n6 11 V\n-110 38 V\n-8 -14
      V\n.0407 g 1952 1455 N -8 -14 107 -48 9 17 h\n1.000 UP\n1.000
      UL\nLT2\n1952 1455 M\n108 -45 V\n8 14 V\n-107 48 V\n-9 -17 V\n.0601 g
      1848 1508 N -9 -17 102 -57 11 21 h\n1.000 UP\n1.000 UL\nLT2\n1848 1508
      M\n104 -53 V\n9 17 V\n-102 57 V\n-11 -21 V\n.0831 g 1750 1570 N -11 -21
      96 -65 13 24 h\n1.000 UP\n1.000 UL\nLT2\n1750 1570 M\n98 -62 V\n11 21
      V\n-96 65 V\n-13 -24 V\n.1095 g 1658 1641 N -13 -24 91 -73 14 26
      h\n1.000 UP\n1.000 UL\nLT2\n1658 1641 M\n92 -71 V\n13 24 V\n-91 73
      V\n-14 -26 V\n.139 g 1573 1719 N -14 -26 84 -81 15 29 h\n1.000
      UP\n1.000 UL\nLT2\n1573 1719 M\n85 -78 V\n14 26 V\n-84 81 V\n-15 -29
      V\n.1714 g 1496 1804 N -15 -29 76 -87 16 31 h\n1.000 UP\n1.000
      UL\nLT2\n1496 1804 M\n77 -85 V\n15 29 V\n-76 87 V\n-16 -31 V\n.2064 g
      1427 1896 N -16 -31 68 -94 17 33 h\n1.000 UP\n1.000 UL\nLT2\n1427 1896
      M\n69 -92 V\n16 31 V\n-68 94 V\n-17 -33 V\n.2438 g 1366 1993 N -17 -33
      59 -99 19 35 h\n1.000 UP\n1.000 UL\nLT2\n1366 1993 M\n61 -97 V\n17 33
      V\n-59 99 V\n-19 -35 V\n.2833 g 1315 2094 N -19 -35 50 -103 20 37
      h\n1.000 UP\n1.000 UL\nLT2\n1315 2094 M\n51 -101 V\n19 35 V\n-50 103
      V\n-20 -37 V\n.3245 g 1274 2200 N -20 -37 41 -107 20 38 h\n1.000
      UP\n1.000 UL\nLT2\n1274 2200 M\n41 -106 V\n20 37 V\n-41 107 V\n-20 -38
      V\n.3671 g 1243 2309 N -20 -38 31 -110 20 39 h\n1.000 UP\n1.000
      UL\nLT2\n1243 2309 M\n31 -109 V\n20 38 V\n-31 110 V\n-20 -39 V\n.4108 g
      1222 2420 N -20 -39 21 -112 20 40 h\n1.000 UP\n1.000 UL\nLT2\n1222 2420
      M\n21 -111 V\n20 39 V\n-21 112 V\n-20 -40 V\n.4552 g 1211 2533 N -20
      -40 10 -113 21 40 h\n1.000 UP\n1.000 UL\nLT2\n1211 2533 M\n11 -113
      V\n20 40 V\n-10 113 V\n-21 -40 V\n.5 g 1211 2646 N -21 -40 0 -113 21 40
      h\n1.000 UP\n1.000 UL\nLT2\n1211 2646 M\n0 -113 V\n21 40 V\n0 113
      V\n-21 -40 V\n.5448 g 1222 2759 N -21 -40 -10 -112 20 39 h\n1.000
      UP\n1.000 UL\nLT2\n1222 2759 M\n-11 -113 V\n21 40 V\n10 112 V\n-20 -39
      V\n.5892 g 1243 2870 N -20 -39 -21 -111 20 39 h\n1.000 UP\n1.000
      UL\nLT2\n1243 2870 M\n-21 -111 V\n20 39 V\n21 111 V\n-20 -39 V\n.6329 g
      1274 2979 N -20 -39 -31 -108 20 38 h\n1.000 UP\n1.000 UL\nLT2\n1274
      2979 M\n-31 -109 V\n20 39 V\n31 108 V\n-20 -38 V\n.6755 g 1315 3085 N
      -20 -38 -41 -104 20 36 h\n1.000 UP\n1.000 UL\nLT2\n1315 3085 M\n-41
      -106 V\n20 38 V\n41 104 V\n-20 -36 V\n.7167 g 1366 3186 N -20 -36 -50
      -100 19 35 h\n1.000 UP\n1.000 UL\nLT2\n1366 3186 M\n-51 -101 V\n20 36
      V\n50 100 V\n-19 -35 V\n.7562 g 1427 3283 N -19 -35 -59 -96 17 34
      h\n1.000 UP\n1.000 UL\nLT2\n1427 3283 M\n-61 -97 V\n19 35 V\n59 96
      V\n-17 -34 V\n.7936 g 1496 3375 N -17 -34 -68 -89 16 31 h\n1.000
      UP\n1.000 UL\nLT2\n1496 3375 M\n-69 -92 V\n17 34 V\n68 89 V\n-16 -31
      V\n.8286 g 1573 3460 N -16 -31 -76 -83 15 29 h\n1.000 UP\n1.000
      UL\nLT2\n1573 3460 M\n-77 -85 V\n16 31 V\n76 83 V\n-15 -29 V\n.861 g
      1658 3538 N -15 -29 -84 -75 14 26 h\n1.000 UP\n1.000 UL\nLT2\n1658 3538
      M\n-85 -78 V\n15 29 V\n84 75 V\n-14 -26 V\n.8905 g 1750 3609 N -14 -26
      -91 -68 13 23 h\n1.000 UP\n1.000 UL\nLT2\n1750 3609 M\n-92 -71 V\n14 26
      V\n91 68 V\n-13 -23 V\n.9169 g 1848 3671 N -13 -23 -96 -59 11 20
      h\n1.000 UP\n1.000 UL\nLT2\n1848 3671 M\n-98 -62 V\n13 23 V\n96 59
      V\n-11 -20 V\n.9399 g 1952 3724 N -11 -20 -102 -51 9 18 h\n1.000
      UP\n1.000 UL\nLT2\n1952 3724 M\n-104 -53 V\n11 20 V\n102 51 V\n-9 -18
      V\n.9593 g 2060 3769 N -9 -18 -107 -41 8 14 h\n1.000 UP\n1.000
      UL\nLT2\n2060 3769 M\n-108 -45 V\n9 18 V\n107 41 V\n-8 -14 V\n.975 g
      2172 3804 N -8 -14 -110 -31 6 10 h\n1.000 UP\n1.000 UL\nLT2\n2172 3804
      M\n-112 -35 V\n8 14 V\n110 31 V\n-6 -10 V\n.987 g 2287 3829 N -6 -10
      -113 -22 4 7 h\n1.000 UP\n1.000 UL\nLT2\n2287 3829 M\n-115 -25 V\n6 10
      V\n113 22 V\n-4 -7 V\n.995 g 2404 3844 N -4 -7 -114 -12 1 4 h\n1.000
      UP\n1.000 UL\nLT2\n2404 3844 M\n-117 -15 V\n4 7 V\n114 12 V\n-1 -4
      V\n.999 g 2521 3849 N -1 -4 -116 -1 0 0 h\n1.000 UP\n1.000
      UL\nLT2\n2521 3849 M\n-117 -5 V\n1 4 V\n116 1 V\n.001 g 2405 1339 N 0 0
      110 -12 6 3 h\n1.000 UP\n1.000 UL\nLT2\n2405 1339 M\n116 -9 V\n-110 12
      V\n-6 -3 V\n.005 g 2291 1357 N -6 -3 109 -22 11 7 h\n1.000 UP\n1.000
      UL\nLT2\n2291 1357 M\n114 -18 V\n6 3 V\n-109 22 V\n-11 -7 V\n.013 g
      2178 1386 N -11 -7 108 -32 16 10 h\n1.000 UP\n1.000 UL\nLT2\n2178 1386
      M\n113 -29 V\n11 7 V\n-108 32 V\n-16 -10 V\n.025 g 2068 1424 N -16 -10
      104 -42 22 14 h\n1.000 UP\n1.000 UL\nLT2\n2068 1424 M\n110 -38 V\n16 10
      V\n-104 42 V\n-22 -14 V\n.0407 g 1961 1472 N -22 -14 102 -51 27 17
      h\n1.000 UP\n1.000 UL\nLT2\n1961 1472 M\n107 -48 V\n22 14 V\n-102 51
      V\n-27 -17 V\n.0601 g 1859 1529 N -27 -17 97 -59 32 19 h\n1.000
      UP\n1.000 UL\nLT2\n1859 1529 M\n102 -57 V\n27 17 V\n-97 59 V\n-32 -19
      V\n.0831 g 1763 1594 N -32 -19 92 -68 36 22 h\n1.000 UP\n1.000
      UL\nLT2\n1763 1594 M\n96 -65 V\n32 19 V\n-92 68 V\n-36 -22 V\n.1095 g
      1672 1667 N -36 -22 86 -76 41 25 h\n1.000 UP\n1.000 UL\nLT2\n1672 1667
      M\n91 -73 V\n36 22 V\n-86 76 V\n-41 -25 V\n.139 g 1588 1748 N -41 -25
      79 -84 46 28 h\n1.000 UP\n1.000 UL\nLT2\n1588 1748 M\n84 -81 V\n41 25
      V\n-79 84 V\n-46 -28 V\n.1714 g 1512 1835 N -46 -28 73 -89 49 30
      h\n1.000 UP\n1.000 UL\nLT2\n1512 1835 M\n76 -87 V\n46 28 V\n-73 89
      V\n-49 -30 V\n.2064 g 1444 1929 N -49 -30 65 -96 52 32 h\n1.000
      UP\n1.000 UL\nLT2\n1444 1929 M\n68 -94 V\n49 30 V\n-65 96 V\n-52 -32
      V\n.2438 g 1385 2028 N -52 -32 56 -100 55 33 h\n1.000 UP\n1.000
      UL\nLT2\n1385 2028 M\n59 -99 V\n52 32 V\n-56 100 V\n-55 -33 V\n.2833 g
      1335 2131 N -55 -33 48 -105 57 35 h\n1.000 UP\n1.000 UL\nLT2\n1335 2131
      M\n50 -103 V\n55 33 V\n-48 105 V\n-57 -35 V\n.3245 g 1294 2238 N -57
      -35 39 -109 59 37 h\n1.000 UP\n1.000 UL\nLT2\n1294 2238 M\n41 -107
      V\n57 35 V\n-39 109 V\n-59 -37 V\n.3671 g 1263 2348 N -59 -37 29 -110
      61 37 h\n1.000 UP\n1.000 UL\nLT2\n1263 2348 M\n31 -110 V\n59 37 V\n-29
      110 V\n-61 -37 V\n.4108 g 1242 2460 N -61 -37 20 -113 62 38 h\n1.000
      UP\n1.000 UL\nLT2\n1242 2460 M\n21 -112 V\n61 37 V\n-20 113 V\n-62 -38
      V\n.4552 g 1232 2573 N -62 -38 9 -113 63 38 h\n1.000 UP\n1.000
      UL\nLT2\n1232 2573 M\n10 -113 V\n62 38 V\n-9 113 V\n-63 -38 V\n.5 g
      1232 2686 N -63 -38 0 -113 63 38 h\n1.000 UP\n1.000 UL\nLT2\n1232 2686
      M\n0 -113 V\n63 38 V\n0 113 V\n-63 -38 V\n.5448 g 1242 2798 N -63 -38
      -9 -112 62 38 h\n1.000 UP\n1.000 UL\nLT2\n1242 2798 M\n-10 -112 V\n63
      38 V\n9 112 V\n-62 -38 V\n.5892 g 1263 2909 N -62 -38 -20 -110 61 37
      h\n1.000 UP\n1.000 UL\nLT2\n1263 2909 M\n-21 -111 V\n62 38 V\n20 110
      V\n-61 -37 V\n.6329 g 1294 3017 N -61 -37 -29 -107 59 36 h\n1.000
      UP\n1.000 UL\nLT2\n1294 3017 M\n-31 -108 V\n61 37 V\n29 107 V\n-59 -36
      V\n.6755 g 1335 3121 N -59 -36 -39 -103 57 35 h\n1.000 UP\n1.000
      UL\nLT2\n1335 3121 M\n-41 -104 V\n59 36 V\n39 103 V\n-57 -35 V\n.7167 g
      1385 3221 N -57 -35 -48 -99 55 34 h\n1.000 UP\n1.000 UL\nLT2\n1385 3221
      M\n-50 -100 V\n57 35 V\n48 99 V\n-55 -34 V\n.7562 g 1444 3317 N -55 -34
      -56 -94 52 32 h\n1.000 UP\n1.000 UL\nLT2\n1444 3317 M\n-59 -96 V\n55 34
      V\n56 94 V\n-52 -32 V\n.7936 g 1512 3406 N -52 -32 -65 -87 49 30
      h\n1.000 UP\n1.000 UL\nLT2\n1512 3406 M\n-68 -89 V\n52 32 V\n65 87
      V\n-49 -30 V\n.8286 g 1588 3489 N -49 -30 -73 -80 46 27 h\n1.000
      UP\n1.000 UL\nLT2\n1588 3489 M\n-76 -83 V\n49 30 V\n73 80 V\n-46 -27
      V\n.861 g 1672 3564 N -46 -27 -79 -73 41 25 h\n1.000 UP\n1.000
      UL\nLT2\n1672 3564 M\n-84 -75 V\n46 27 V\n79 73 V\n-41 -25 V\n.8905 g
      1763 3632 N -41 -25 -86 -65 36 22 h\n1.000 UP\n1.000 UL\nLT2\n1763 3632
      M\n-91 -68 V\n41 25 V\n86 65 V\n-36 -22 V\n.9169 g 1859 3691 N -36 -22
      -92 -57 32 20 h\n1.000 UP\n1.000 UL\nLT2\n1859 3691 M\n-96 -59 V\n36 22
      V\n92 57 V\n-32 -20 V\n.9399 g 1961 3742 N -32 -20 -97 -47 27 16
      h\n1.000 UP\n1.000 UL\nLT2\n1961 3742 M\n-102 -51 V\n32 20 V\n97 47
      V\n-27 -16 V\n.9593 g 2068 3783 N -27 -16 -102 -38 22 13 h\n1.000
      UP\n1.000 UL\nLT2\n2068 3783 M\n-107 -41 V\n27 16 V\n102 38 V\n-22 -13
      V\n.975 g 2178 3814 N -22 -13 -104 -28 16 10 h\n1.000 UP\n1.000
      UL\nLT2\n2178 3814 M\n-110 -31 V\n22 13 V\n104 28 V\n-16 -10 V\n.987 g
      2291 3836 N -16 -10 -108 -19 11 7 h\n1.000 UP\n1.000 UL\nLT2\n2291 3836
      M\n-113 -22 V\n16 10 V\n108 19 V\n-11 -7 V\n.995 g 2405 3848 N -11 -7
      -109 -8 6 3 h\n1.000 UP\n1.000 UL\nLT2\n2405 3848 M\n-114 -12 V\n11 7
      V\n109 8 V\n-6 -3 V\n.999 g 2521 3849 N -6 -3 -110 2 0 0 h\n1.000
      UP\n1.000 UL\nLT2\n2521 3849 M\n-116 -1 V\n6 3 V\n110 -2 V\n.001 g 2411
      1342 N 0 0 101 -15 9 3 h\n1.000 UP\n1.000 UL\nLT2\n2411 1342 M\n110 -12
      V\n-101 15 V\n-9 -3 V\n.005 g 2302 1364 N -9 -3 100 -26 18 7 h\n1.000
      UP\n1.000 UL\nLT2\n2302 1364 M\n109 -22 V\n9 3 V\n-100 26 V\n-18 -7
      V\n.013 g 2194 1396 N -18 -7 98 -35 28 10 h\n1.000 UP\n1.000
      UL\nLT2\n2194 1396 M\n108 -32 V\n18 7 V\n-98 35 V\n-28 -10 V\n.025 g
      2090 1438 N -28 -10 96 -44 36 12 h\n1.000 UP\n1.000 UL\nLT2\n2090 1438
      M\n104 -42 V\n28 10 V\n-96 44 V\n-36 -12 V\n.0407 g 1988 1489 N -36 -12
      93 -54 45 15 h\n1.000 UP\n1.000 UL\nLT2\n1988 1489 M\n102 -51 V\n36 12
      V\n-93 54 V\n-45 -15 V\n.0601 g 1891 1548 N -45 -15 89 -63 53 19
      h\n1.000 UP\n1.000 UL\nLT2\n1891 1548 M\n97 -59 V\n45 15 V\n-89 63
      V\n-53 -19 V\n.0831 g 1799 1616 N -53 -19 85 -71 60 22 h\n1.000
      UP\n1.000 UL\nLT2\n1799 1616 M\n92 -68 V\n53 19 V\n-85 71 V\n-60 -22
      V\n.1095 g 1713 1692 N -60 -22 79 -78 67 24 h\n1.000 UP\n1.000
      UL\nLT2\n1713 1692 M\n86 -76 V\n60 22 V\n-79 78 V\n-67 -24 V\n.139 g
      1634 1776 N -67 -24 73 -86 73 26 h\n1.000 UP\n1.000 UL\nLT2\n1634 1776
      M\n79 -84 V\n67 24 V\n-73 86 V\n-73 -26 V\n.1714 g 1561 1865 N -73 -26
      66 -91 80 28 h\n1.000 UP\n1.000 UL\nLT2\n1561 1865 M\n73 -89 V\n73 26
      V\n-66 91 V\n-80 -28 V\n.2064 g 1496 1961 N -80 -28 59 -98 86 30
      h\n1.000 UP\n1.000 UL\nLT2\n1496 1961 M\n65 -96 V\n80 28 V\n-59 98
      V\n-86 -30 V\n.2438 g 1440 2061 N -86 -30 52 -102 90 32 h\n1.000
      UP\n1.000 UL\nLT2\n1440 2061 M\n56 -100 V\n86 30 V\n-52 102 V\n-90 -32
      V\n.2833 g 1392 2166 N -90 -32 44 -106 94 33 h\n1.000 UP\n1.000
      UL\nLT2\n1392 2166 M\n48 -105 V\n90 32 V\n-44 106 V\n-94 -33 V\n.3245 g
      1353 2275 N -94 -33 36 -110 97 34 h\n1.000 UP\n1.000 UL\nLT2\n1353 2275
      M\n39 -109 V\n94 33 V\n-36 110 V\n-97 -34 V\n.3671 g 1324 2385 N -97
      -34 26 -112 100 36 h\n1.000 UP\n1.000 UL\nLT2\n1324 2385 M\n29 -110
      V\n97 34 V\n-26 112 V\n-100 -36 V\n.4108 g 1304 2498 N -100 -36 18 -113
      102 36 h\n1.000 UP\n1.000 UL\nLT2\n1304 2498 M\n20 -113 V\n100 36
      V\n-18 113 V\n-102 -36 V\n.4552 g 1295 2611 N -102 -36 10 -113 101 36
      h\n1.000 UP\n1.000 UL\nLT2\n1295 2611 M\n9 -113 V\n102 36 V\n-10 113
      V\n-101 -36 V\n.5 g 1295 2724 N -101 -36 0 -113 101 36 h\n1.000
      UP\n1.000 UL\nLT2\n1295 2724 M\n0 -113 V\n101 36 V\n0 113 V\n-101 -36
      V\n.5448 g 1304 2836 N -101 -36 -10 -112 102 36 h\n1.000 UP\n1.000
      UL\nLT2\n1304 2836 M\n-9 -112 V\n101 36 V\n10 112 V\n-102 -36 V\n.5892
      g 1324 2946 N -102 -36 -18 -109 100 35 h\n1.000 UP\n1.000 UL\nLT2\n1324
      2946 M\n-20 -110 V\n102 36 V\n18 109 V\n-100 -35 V\n.6329 g 1353 3053 N
      -100 -35 -26 -106 97 34 h\n1.000 UP\n1.000 UL\nLT2\n1353 3053 M\n-29
      -107 V\n100 35 V\n26 106 V\n-97 -34 V\n.6755 g 1392 3156 N -97 -34 -36
      -102 94 33 h\n1.000 UP\n1.000 UL\nLT2\n1392 3156 M\n-39 -103 V\n97 34
      V\n36 102 V\n-94 -33 V\n.7167 g 1440 3255 N -94 -33 -44 -98 90 32
      h\n1.000 UP\n1.000 UL\nLT2\n1440 3255 M\n-48 -99 V\n94 33 V\n44 98
      V\n-90 -32 V\n.7562 g 1496 3349 N -90 -32 -52 -92 86 30 h\n1.000
      UP\n1.000 UL\nLT2\n1496 3349 M\n-56 -94 V\n90 32 V\n52 92 V\n-86 -30
      V\n.7936 g 1561 3436 N -86 -30 -59 -85 80 28 h\n1.000 UP\n1.000
      UL\nLT2\n1561 3436 M\n-65 -87 V\n86 30 V\n59 85 V\n-80 -28 V\n.8286 g
      1634 3516 N -80 -28 -66 -78 73 26 h\n1.000 UP\n1.000 UL\nLT2\n1634 3516
      M\n-73 -80 V\n80 28 V\n66 78 V\n-73 -26 V\n.861 g 1713 3589 N -73 -26
      -73 -71 67 24 h\n1.000 UP\n1.000 UL\nLT2\n1713 3589 M\n-79 -73 V\n73 26
      V\n73 71 V\n-67 -24 V\n.8905 g 1799 3654 N -67 -24 -79 -63 60 22
      h\n1.000 UP\n1.000 UL\nLT2\n1799 3654 M\n-86 -65 V\n67 24 V\n79 63
      V\n-60 -22 V\n.9169 g 1891 3711 N -60 -22 -85 -53 53 18 h\n1.000
      UP\n1.000 UL\nLT2\n1891 3711 M\n-92 -57 V\n60 22 V\n85 53 V\n-53 -18
      V\n.9399 g 1988 3758 N -53 -18 -89 -45 45 16 h\n1.000 UP\n1.000
      UL\nLT2\n1988 3758 M\n-97 -47 V\n53 18 V\n89 45 V\n-45 -16 V\n.9593 g
      2090 3796 N -45 -16 -93 -35 36 13 h\n1.000 UP\n1.000 UL\nLT2\n2090 3796
      M\n-102 -38 V\n45 16 V\n93 35 V\n-36 -13 V\n.975 g 2194 3824 N -36 -13
      -96 -25 28 10 h\n1.000 UP\n1.000 UL\nLT2\n2194 3824 M\n-104 -28 V\n36
      13 V\n96 25 V\n-28 -10 V\n.987 g 2302 3843 N -28 -10 -98 -15 18 6
      h\n1.000 UP\n1.000 UL\nLT2\n2302 3843 M\n-108 -19 V\n28 10 V\n98 15
      V\n-18 -6 V\n.995 g 2411 3851 N -18 -6 -100 -5 9 3 h\n1.000 UP\n1.000
      UL\nLT2\n2411 3851 M\n-109 -8 V\n18 6 V\n100 5 V\n-9 -3 V\n.999 g 2521
      3849 N -9 -3 -101 5 0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n-110 2
      V\n9 3 V\n101 -5 V\n.001 g 2420 1345 N 0 0 88 -18 13 3 h\n1.000
      UP\n1.000 UL\nLT2\n2420 1345 M\n101 -15 V\n-88 18 V\n-13 -3 V\n.005 g
      2320 1371 N -13 -3 88 -28 25 5 h\n1.000 UP\n1.000 UL\nLT2\n2320 1371
      M\n100 -26 V\n13 3 V\n-88 28 V\n-25 -5 V\n.013 g 2222 1406 N -25 -5 87
      -38 36 8 h\n1.000 UP\n1.000 UL\nLT2\n2222 1406 M\n98 -35 V\n25 5 V\n-87
      38 V\n-36 -8 V\n.025 g 2126 1450 N -36 -8 84 -48 48 12 h\n1.000
      UP\n1.000 UL\nLT2\n2126 1450 M\n96 -44 V\n36 8 V\n-84 48 V\n-48 -12
      V\n.0407 g 2033 1504 N -48 -12 81 -56 60 14 h\n1.000 UP\n1.000
      UL\nLT2\n2033 1504 M\n93 -54 V\n48 12 V\n-81 56 V\n-60 -14 V\n.0601 g
      1944 1567 N -60 -14 78 -65 71 16 h\n1.000 UP\n1.000 UL\nLT2\n1944 1567
      M\n89 -63 V\n60 14 V\n-78 65 V\n-71 -16 V\n.0831 g 1859 1638 N -71 -16
      74 -74 82 19 h\n1.000 UP\n1.000 UL\nLT2\n1859 1638 M\n85 -71 V\n71 16
      V\n-74 74 V\n-82 -19 V\n.1095 g 1780 1716 N -82 -19 70 -80 91 21
      h\n1.000 UP\n1.000 UL\nLT2\n1780 1716 M\n79 -78 V\n82 19 V\n-70 80
      V\n-91 -21 V\n.139 g 1707 1802 N -91 -21 64 -88 100 23 h\n1.000
      UP\n1.000 UL\nLT2\n1707 1802 M\n73 -86 V\n91 21 V\n-64 88 V\n-100 -23
      V\n.1714 g 1641 1893 N -100 -23 58 -94 108 26 h\n1.000 UP\n1.000
      UL\nLT2\n1641 1893 M\n66 -91 V\n100 23 V\n-58 94 V\n-108 -26 V\n.2064 g
      1582 1991 N -108 -26 52 -99 115 27 h\n1.000 UP\n1.000 UL\nLT2\n1582
      1991 M\n59 -98 V\n108 26 V\n-52 99 V\n-115 -27 V\n.2438 g 1530 2093 N
      -115 -27 46 -104 121 29 h\n1.000 UP\n1.000 UL\nLT2\n1530 2093 M\n52
      -102 V\n115 27 V\n-46 104 V\n-121 -29 V\n.2833 g 1486 2199 N -121 -29
      38 -107 127 30 h\n1.000 UP\n1.000 UL\nLT2\n1486 2199 M\n44 -106 V\n121
      29 V\n-38 107 V\n-127 -30 V\n.3245 g 1450 2309 N -127 -30 31 -111 132
      31 h\n1.000 UP\n1.000 UL\nLT2\n1450 2309 M\n36 -110 V\n127 30 V\n-31
      111 V\n-132 -31 V\n.3671 g 1424 2421 N -132 -31 24 -112 134 31 h\n1.000
      UP\n1.000 UL\nLT2\n1424 2421 M\n26 -112 V\n132 31 V\n-24 112 V\n-134
      -31 V\n.4108 g 1406 2534 N -134 -31 16 -114 136 32 h\n1.000 UP\n1.000
      UL\nLT2\n1406 2534 M\n18 -113 V\n134 31 V\n-16 114 V\n-136 -32 V\n.4552
      g 1396 2647 N -136 -32 7 -113 139 32 h\n1.000 UP\n1.000 UL\nLT2\n1396
      2647 M\n10 -113 V\n136 32 V\n-7 113 V\n-139 -32 V\n.5 g 1396 2760 N
      -139 -32 0 -113 139 32 h\n1.000 UP\n1.000 UL\nLT2\n1396 2760 M\n0 -113
      V\n139 32 V\n0 113 V\n-139 -32 V\n.5448 g 1406 2872 N -139 -32 -7 -112
      136 32 h\n1.000 UP\n1.000 UL\nLT2\n1406 2872 M\n-10 -112 V\n139 32 V\n7
      112 V\n-136 -32 V\n.5892 g 1424 2981 N -136 -32 -16 -109 134 32
      h\n1.000 UP\n1.000 UL\nLT2\n1424 2981 M\n-18 -109 V\n136 32 V\n16 109
      V\n-134 -32 V\n.6329 g 1450 3087 N -134 -32 -24 -105 132 31 h\n1.000
      UP\n1.000 UL\nLT2\n1450 3087 M\n-26 -106 V\n134 32 V\n24 105 V\n-132
      -31 V\n.6755 g 1486 3189 N -132 -31 -31 -101 127 30 h\n1.000 UP\n1.000
      UL\nLT2\n1486 3189 M\n-36 -102 V\n132 31 V\n31 101 V\n-127 -30 V\n.7167
      g 1530 3287 N -127 -30 -38 -96 121 28 h\n1.000 UP\n1.000 UL\nLT2\n1530
      3287 M\n-44 -98 V\n127 30 V\n38 96 V\n-121 -28 V\n.7562 g 1582 3379 N
      -121 -28 -46 -91 115 27 h\n1.000 UP\n1.000 UL\nLT2\n1582 3379 M\n-52
      -92 V\n121 28 V\n46 91 V\n-115 -27 V\n.7936 g 1641 3464 N -115 -27 -52
      -83 108 25 h\n1.000 UP\n1.000 UL\nLT2\n1641 3464 M\n-59 -85 V\n115 27
      V\n52 83 V\n-108 -25 V\n.8286 g 1707 3542 N -108 -25 -58 -77 100 24
      h\n1.000 UP\n1.000 UL\nLT2\n1707 3542 M\n-66 -78 V\n108 25 V\n58 77
      V\n-100 -24 V\n.861 g 1780 3613 N -100 -24 -64 -68 91 21 h\n1.000
      UP\n1.000 UL\nLT2\n1780 3613 M\n-73 -71 V\n100 24 V\n64 68 V\n-91 -21
      V\n.8905 g 1859 3676 N -91 -21 -70 -61 82 19 h\n1.000 UP\n1.000
      UL\nLT2\n1859 3676 M\n-79 -63 V\n91 21 V\n70 61 V\n-82 -19 V\n.9169 g
      1944 3729 N -82 -19 -74 -51 71 17 h\n1.000 UP\n1.000 UL\nLT2\n1944 3729
      M\n-85 -53 V\n82 19 V\n74 51 V\n-71 -17 V\n.9399 g 2033 3774 N -71 -17
      -78 -42 60 14 h\n1.000 UP\n1.000 UL\nLT2\n2033 3774 M\n-89 -45 V\n71 17
      V\n78 42 V\n-60 -14 V\n.9593 g 2126 3809 N -60 -14 -81 -32 48 11
      h\n1.000 UP\n1.000 UL\nLT2\n2126 3809 M\n-93 -35 V\n60 14 V\n81 32
      V\n-48 -11 V\n.975 g 2222 3834 N -48 -11 -84 -23 36 9 h\n1.000
      UP\n1.000 UL\nLT2\n2222 3834 M\n-96 -25 V\n48 11 V\n84 23 V\n-36 -9
      V\n.987 g 2320 3849 N -36 -9 -87 -12 25 6 h\n1.000 UP\n1.000
      UL\nLT2\n2320 3849 M\n-98 -15 V\n36 9 V\n87 12 V\n-25 -6 V\n.995 g 2420
      3854 N -25 -6 -88 -2 13 3 h\n1.000 UP\n1.000 UL\nLT2\n2420 3854 M\n-100
      -5 V\n25 6 V\n88 2 V\n-13 -3 V\n.999 g 2521 3849 N -13 -3 -88 8 0 0
      h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n-101 5 V\n13 3 V\n88 -8
      V\n.001 g 2433 1348 N 0 0 73 -21 15 3 h\n1.000 UP\n1.000 UL\nLT2\n2433
      1348 M\n88 -18 V\n-73 21 V\n-15 -3 V\n.005 g 2345 1376 N -15 -3 73 -30
      30 5 h\n1.000 UP\n1.000 UL\nLT2\n2345 1376 M\n88 -28 V\n15 3 V\n-73 30
      V\n-30 -5 V\n.013 g 2258 1414 N -30 -5 71 -41 46 8 h\n1.000 UP\n1.000
      UL\nLT2\n2258 1414 M\n87 -38 V\n30 5 V\n-71 41 V\n-46 -8 V\n.025 g 2174
      1462 N -46 -8 70 -49 60 9 h\n1.000 UP\n1.000 UL\nLT2\n2174 1462 M\n84
      -48 V\n46 8 V\n-70 49 V\n-60 -9 V\n.0407 g 2093 1518 N -60 -9 68 -59 73
      12 h\n1.000 UP\n1.000 UL\nLT2\n2093 1518 M\n81 -56 V\n60 9 V\n-68 59
      V\n-73 -12 V\n.0601 g 2015 1583 N -73 -12 64 -67 87 14 h\n1.000
      UP\n1.000 UL\nLT2\n2015 1583 M\n78 -65 V\n73 12 V\n-64 67 V\n-87 -14
      V\n.0831 g 1941 1657 N -87 -14 61 -76 100 16 h\n1.000 UP\n1.000
      UL\nLT2\n1941 1657 M\n74 -74 V\n87 14 V\n-61 76 V\n-100 -16 V\n.1095 g
      1871 1737 N -100 -16 58 -82 112 18 h\n1.000 UP\n1.000 UL\nLT2\n1871
      1737 M\n70 -80 V\n100 16 V\n-58 82 V\n-112 -18 V\n.139 g 1807 1825 N
      -112 -18 53 -90 123 20 h\n1.000 UP\n1.000 UL\nLT2\n1807 1825 M\n64 -88
      V\n112 18 V\n-53 90 V\n-123 -20 V\n.1714 g 1749 1919 N -123 -20 48 -95
      133 21 h\n1.000 UP\n1.000 UL\nLT2\n1749 1919 M\n58 -94 V\n123 20 V\n-48
      95 V\n-133 -21 V\n.2064 g 1697 2018 N -133 -21 43 -101 142 23 h\n1.000
      UP\n1.000 UL\nLT2\n1697 2018 M\n52 -99 V\n133 21 V\n-43 101 V\n-142 -23
      V\n.2438 g 1651 2122 N -142 -23 38 -105 150 24 h\n1.000 UP\n1.000
      UL\nLT2\n1651 2122 M\n46 -104 V\n142 23 V\n-38 105 V\n-150 -24 V\n.2833
      g 1613 2229 N -150 -24 32 -108 156 25 h\n1.000 UP\n1.000 UL\nLT2\n1613
      2229 M\n38 -107 V\n150 24 V\n-32 108 V\n-156 -25 V\n.3245 g 1582 2340 N
      -156 -25 26 -112 161 26 h\n1.000 UP\n1.000 UL\nLT2\n1582 2340 M\n31
      -111 V\n156 25 V\n-26 112 V\n-161 -26 V\n.3671 g 1558 2452 N -161 -26
      19 -113 166 27 h\n1.000 UP\n1.000 UL\nLT2\n1558 2452 M\n24 -112 V\n161
      26 V\n-19 113 V\n-166 -27 V\n.4108 g 1542 2566 N -166 -27 13 -114 169
      27 h\n1.000 UP\n1.000 UL\nLT2\n1542 2566 M\n16 -114 V\n166 27 V\n-13
      114 V\n-169 -27 V\n.4552 g 1535 2679 N -169 -27 7 -114 169 28 h\n1.000
      UP\n1.000 UL\nLT2\n1535 2679 M\n7 -113 V\n169 27 V\n-7 114 V\n-169 -28
      V\n.5 g 1535 2792 N -169 -28 0 -113 169 28 h\n1.000 UP\n1.000
      UL\nLT2\n1535 2792 M\n0 -113 V\n169 28 V\n0 113 V\n-169 -28 V\n.5448 g
      1542 2904 N -169 -28 -7 -111 169 27 h\n1.000 UP\n1.000 UL\nLT2\n1542
      2904 M\n-7 -112 V\n169 28 V\n7 111 V\n-169 -27 V\n.5892 g 1558 3013 N
      -169 -27 -13 -108 166 26 h\n1.000 UP\n1.000 UL\nLT2\n1558 3013 M\n-16
      -109 V\n169 27 V\n13 108 V\n-166 -26 V\n.6329 g 1582 3118 N -166 -26
      -19 -105 161 26 h\n1.000 UP\n1.000 UL\nLT2\n1582 3118 M\n-24 -105
      V\n166 26 V\n19 105 V\n-161 -26 V\n.6755 g 1613 3219 N -161 -26 -26
      -101 156 26 h\n1.000 UP\n1.000 UL\nLT2\n1613 3219 M\n-31 -101 V\n161 26
      V\n26 101 V\n-156 -26 V\n.7167 g 1651 3315 N -156 -26 -32 -95 150 25
      h\n1.000 UP\n1.000 UL\nLT2\n1651 3315 M\n-38 -96 V\n156 26 V\n32 95
      V\n-150 -25 V\n.7562 g 1697 3406 N -150 -25 -38 -89 142 23 h\n1.000
      UP\n1.000 UL\nLT2\n1697 3406 M\n-46 -91 V\n150 25 V\n38 89 V\n-142 -23
      V\n.7936 g 1749 3489 N -142 -23 -43 -82 133 22 h\n1.000 UP\n1.000
      UL\nLT2\n1749 3489 M\n-52 -83 V\n142 23 V\n43 82 V\n-133 -22 V\n.8286 g
      1807 3566 N -133 -22 -48 -75 123 20 h\n1.000 UP\n1.000 UL\nLT2\n1807
      3566 M\n-58 -77 V\n133 22 V\n48 75 V\n-123 -20 V\n.861 g 1871 3634 N
      -123 -20 -53 -67 112 19 h\n1.000 UP\n1.000 UL\nLT2\n1871 3634 M\n-64
      -68 V\n123 20 V\n53 67 V\n-112 -19 V\n.8905 g 1941 3695 N -112 -19 -58
      -58 100 16 h\n1.000 UP\n1.000 UL\nLT2\n1941 3695 M\n-70 -61 V\n112 19
      V\n58 58 V\n-100 -16 V\n.9169 g 2015 3746 N -100 -16 -61 -49 87 14
      h\n1.000 UP\n1.000 UL\nLT2\n2015 3746 M\n-74 -51 V\n100 16 V\n61 49
      V\n-87 -14 V\n.9399 g 2093 3788 N -87 -14 -64 -40 73 12 h\n1.000
      UP\n1.000 UL\nLT2\n2093 3788 M\n-78 -42 V\n87 14 V\n64 40 V\n-73 -12
      V\n.9593 g 2174 3820 N -73 -12 -68 -30 60 10 h\n1.000 UP\n1.000
      UL\nLT2\n2174 3820 M\n-81 -32 V\n73 12 V\n68 30 V\n-60 -10 V\n.975 g
      2258 3843 N -60 -10 -70 -20 46 7 h\n1.000 UP\n1.000 UL\nLT2\n2258 3843
      M\n-84 -23 V\n60 10 V\n70 20 V\n-46 -7 V\n.987 g 2345 3855 N -46 -7 -71
      -10 30 5 h\n1.000 UP\n1.000 UL\nLT2\n2345 3855 M\n-87 -12 V\n46 7 V\n71
      10 V\n-30 -5 V\n.995 g 2433 3857 N -30 -5 -73 0 15 3 h\n1.000 UP\n1.000
      UL\nLT2\n2433 3857 M\n-88 -2 V\n30 5 V\n73 0 V\n-15 -3 V\n.999 g 2521
      3849 N -15 -3 -73 11 0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n-88 8
      V\n15 3 V\n73 -11 V\n.001 g 2448 1351 N 0 0 56 -23 17 2 h\n1.000
      UP\n1.000 UL\nLT2\n2448 1351 M\n73 -21 V\n-56 23 V\n-17 -2 V\n.005 g
      2375 1381 N -17 -2 55 -32 35 4 h\n1.000 UP\n1.000 UL\nLT2\n2375 1381
      M\n73 -30 V\n17 2 V\n-55 32 V\n-35 -4 V\n.013 g 2304 1422 N -35 -4 54
      -42 52 5 h\n1.000 UP\n1.000 UL\nLT2\n2304 1422 M\n71 -41 V\n35 4 V\n-54
      42 V\n-52 -5 V\n.025 g 2234 1471 N -52 -5 53 -52 69 8 h\n1.000
      UP\n1.000 UL\nLT2\n2234 1471 M\n70 -49 V\n52 5 V\n-53 52 V\n-69 -8
      V\n.0407 g 2166 1530 N -69 -8 52 -61 85 10 h\n1.000 UP\n1.000
      UL\nLT2\n2166 1530 M\n68 -59 V\n69 8 V\n-52 61 V\n-85 -10 V\n.0601 g
      2102 1597 N -85 -10 49 -69 100 12 h\n1.000 UP\n1.000 UL\nLT2\n2102 1597
      M\n64 -67 V\n85 10 V\n-49 69 V\n-100 -12 V\n.0831 g 2041 1673 N -100
      -12 46 -77 115 13 h\n1.000 UP\n1.000 UL\nLT2\n2041 1673 M\n61 -76
      V\n100 12 V\n-46 77 V\n-115 -13 V\n.1095 g 1983 1755 N -115 -13 44 -84
      129 15 h\n1.000 UP\n1.000 UL\nLT2\n1983 1755 M\n58 -82 V\n115 13 V\n-44
      84 V\n-129 -15 V\n.139 g 1930 1845 N -129 -15 40 -91 142 16 h\n1.000
      UP\n1.000 UL\nLT2\n1930 1845 M\n53 -90 V\n129 15 V\n-40 91 V\n-142 -16
      V\n.1714 g 1882 1940 N -142 -16 37 -96 153 17 h\n1.000 UP\n1.000
      UL\nLT2\n1882 1940 M\n48 -95 V\n142 16 V\n-37 96 V\n-153 -17 V\n.2064 g
      1839 2041 N -153 -17 33 -102 163 18 h\n1.000 UP\n1.000 UL\nLT2\n1839
      2041 M\n43 -101 V\n153 17 V\n-33 102 V\n-163 -18 V\n.2438 g 1801 2146 N
      -163 -18 28 -106 173 19 h\n1.000 UP\n1.000 UL\nLT2\n1801 2146 M\n38
      -105 V\n163 18 V\n-28 106 V\n-173 -19 V\n.2833 g 1769 2254 N -173 -19
      24 -110 181 21 h\n1.000 UP\n1.000 UL\nLT2\n1769 2254 M\n32 -108 V\n173
      19 V\n-24 110 V\n-181 -21 V\n.3245 g 1743 2366 N -181 -21 20 -112 187
      21 h\n1.000 UP\n1.000 UL\nLT2\n1743 2366 M\n26 -112 V\n181 21 V\n-20
      112 V\n-187 -21 V\n.3671 g 1724 2479 N -187 -21 15 -113 191 21 h\n1.000
      UP\n1.000 UL\nLT2\n1724 2479 M\n19 -113 V\n187 21 V\n-15 113 V\n-191
      -21 V\n.4108 g 1711 2593 N -191 -21 10 -115 194 22 h\n1.000 UP\n1.000
      UL\nLT2\n1711 2593 M\n13 -114 V\n191 21 V\n-10 115 V\n-194 -22 V\n.4552
      g 1704 2707 N -194 -22 5 -114 196 22 h\n1.000 UP\n1.000 UL\nLT2\n1704
      2707 M\n7 -114 V\n194 22 V\n-5 114 V\n-196 -22 V\n.5 g 1704 2820 N -196
      -22 0 -113 196 22 h\n1.000 UP\n1.000 UL\nLT2\n1704 2820 M\n0 -113
      V\n196 22 V\n0 113 V\n-196 -22 V\n.5448 g 1711 2931 N -196 -22 -5 -111
      194 22 h\n1.000 UP\n1.000 UL\nLT2\n1711 2931 M\n-7 -111 V\n196 22 V\n5
      111 V\n-194 -22 V\n.5892 g 1724 3039 N -194 -22 -10 -108 191 22
      h\n1.000 UP\n1.000 UL\nLT2\n1724 3039 M\n-13 -108 V\n194 22 V\n10 108
      V\n-191 -22 V\n.6329 g 1743 3144 N -191 -22 -15 -104 187 21 h\n1.000
      UP\n1.000 UL\nLT2\n1743 3144 M\n-19 -105 V\n191 22 V\n15 104 V\n-187
      -21 V\n.6755 g 1769 3245 N -187 -21 -20 -100 181 20 h\n1.000 UP\n1.000
      UL\nLT2\n1769 3245 M\n-26 -101 V\n187 21 V\n20 100 V\n-181 -20 V\n.7167
      g 1801 3340 N -181 -20 -24 -94 173 19 h\n1.000 UP\n1.000 UL\nLT2\n1801
      3340 M\n-32 -95 V\n181 20 V\n24 94 V\n-173 -19 V\n.7562 g 1839 3429 N
      -173 -19 -28 -88 163 18 h\n1.000 UP\n1.000 UL\nLT2\n1839 3429 M\n-38
      -89 V\n173 19 V\n28 88 V\n-163 -18 V\n.7936 g 1882 3511 N -163 -18 -33
      -81 153 17 h\n1.000 UP\n1.000 UL\nLT2\n1882 3511 M\n-43 -82 V\n163 18
      V\n33 81 V\n-153 -17 V\n.8286 g 1930 3586 N -153 -17 -37 -74 142 16
      h\n1.000 UP\n1.000 UL\nLT2\n1930 3586 M\n-48 -75 V\n153 17 V\n37 74
      V\n-142 -16 V\n.861 g 1983 3653 N -142 -16 -40 -65 129 14 h\n1.000
      UP\n1.000 UL\nLT2\n1983 3653 M\n-53 -67 V\n142 16 V\n40 65 V\n-129 -14
      V\n.8905 g 2041 3711 N -129 -14 -44 -57 115 13 h\n1.000 UP\n1.000
      UL\nLT2\n2041 3711 M\n-58 -58 V\n129 14 V\n44 57 V\n-115 -13 V\n.9169 g
      2102 3760 N -115 -13 -46 -47 100 11 h\n1.000 UP\n1.000 UL\nLT2\n2102
      3760 M\n-61 -49 V\n115 13 V\n46 47 V\n-100 -11 V\n.9399 g 2166 3800 N
      -100 -11 -49 -38 85 9 h\n1.000 UP\n1.000 UL\nLT2\n2166 3800 M\n-64 -40
      V\n100 11 V\n49 38 V\n-85 -9 V\n.9593 g 2234 3830 N -85 -9 -52 -29 69 8
      h\n1.000 UP\n1.000 UL\nLT2\n2234 3830 M\n-68 -30 V\n85 9 V\n52 29
      V\n-69 -8 V\n.975 g 2304 3850 N -69 -8 -53 -18 52 6 h\n1.000 UP\n1.000
      UL\nLT2\n2304 3850 M\n-70 -20 V\n69 8 V\n53 18 V\n-52 -6 V\n.987 g 2375
      3860 N -52 -6 -54 -8 35 4 h\n1.000 UP\n1.000 UL\nLT2\n2375 3860 M\n-71
      -10 V\n52 6 V\n54 8 V\n-35 -4 V\n.995 g 2448 3860 N -35 -4 -55 2 17 2
      h\n1.000 UP\n1.000 UL\nLT2\n2448 3860 M\n-73 0 V\n35 4 V\n55 -2 V\n-17
      -2 V\n.999 g 2521 3849 N -17 -2 -56 13 0 0 h\n1.000 UP\n1.000
      UL\nLT2\n2521 3849 M\n-73 11 V\n17 2 V\n56 -13 V\n.001 g 2465 1353 N 0
      0 36 -24 20 1 h\n1.000 UP\n1.000 UL\nLT2\n2465 1353 M\n56 -23 V\n-36 24
      V\n-20 -1 V\n.005 g 2410 1385 N -20 -1 36 -34 39 3 h\n1.000 UP\n1.000
      UL\nLT2\n2410 1385 M\n55 -32 V\n20 1 V\n-36 34 V\n-39 -3 V\n.013 g 2356
      1427 N -39 -3 36 -44 57 5 h\n1.000 UP\n1.000 UL\nLT2\n2356 1427 M\n54
      -42 V\n39 3 V\n-36 44 V\n-57 -5 V\n.025 g 2303 1479 N -57 -5 34 -53 76
      6 h\n1.000 UP\n1.000 UL\nLT2\n2303 1479 M\n53 -52 V\n57 5 V\n-34 53
      V\n-76 -6 V\n.0407 g 2251 1540 N -76 -6 34 -61 94 6 h\n1.000 UP\n1.000
      UL\nLT2\n2251 1540 M\n52 -61 V\n76 6 V\n-34 61 V\n-94 -6 V\n.0601 g
      2202 1609 N -94 -6 32 -71 111 8 h\n1.000 UP\n1.000 UL\nLT2\n2202 1609
      M\n49 -69 V\n94 6 V\n-32 71 V\n-111 -8 V\n.0831 g 2156 1686 N -111 -8
      30 -78 127 9 h\n1.000 UP\n1.000 UL\nLT2\n2156 1686 M\n46 -77 V\n111 8
      V\n-30 78 V\n-127 -9 V\n.1095 g 2112 1770 N -127 -9 29 -85 142 10
      h\n1.000 UP\n1.000 UL\nLT2\n2112 1770 M\n44 -84 V\n127 9 V\n-29 85
      V\n-142 -10 V\n.139 g 2072 1861 N -142 -10 26 -92 156 11 h\n1.000
      UP\n1.000 UL\nLT2\n2072 1861 M\n40 -91 V\n142 10 V\n-26 92 V\n-156 -11
      V\n.1714 g 2035 1957 N -156 -11 24 -98 169 13 h\n1.000 UP\n1.000
      UL\nLT2\n2035 1957 M\n37 -96 V\n156 11 V\n-24 98 V\n-169 -13 V\n.2064 g
      2002 2059 N -169 -13 21 -102 181 13 h\n1.000 UP\n1.000 UL\nLT2\n2002
      2059 M\n33 -102 V\n169 13 V\n-21 102 V\n-181 -13 V\n.2438 g 1974 2165 N
      -181 -13 19 -107 190 14 h\n1.000 UP\n1.000 UL\nLT2\n1974 2165 M\n28
      -106 V\n181 13 V\n-19 107 V\n-190 -14 V\n.2833 g 1950 2275 N -190 -14
      16 -110 198 14 h\n1.000 UP\n1.000 UL\nLT2\n1950 2275 M\n24 -110 V\n190
      14 V\n-16 110 V\n-198 -14 V\n.3245 g 1930 2387 N -198 -14 12 -113 206
      15 h\n1.000 UP\n1.000 UL\nLT2\n1930 2387 M\n20 -112 V\n198 14 V\n-12
      113 V\n-206 -15 V\n.3671 g 1915 2500 N -206 -15 10 -114 211 16 h\n1.000
      UP\n1.000 UL\nLT2\n1915 2500 M\n15 -113 V\n206 15 V\n-10 114 V\n-211
      -16 V\n.4108 g 1905 2615 N -211 -16 6 -114 215 15 h\n1.000 UP\n1.000
      UL\nLT2\n1905 2615 M\n10 -115 V\n211 16 V\n-6 114 V\n-215 -15 V\n.4552
      g 1900 2729 N -215 -15 4 -114 216 15 h\n1.000 UP\n1.000 UL\nLT2\n1900
      2729 M\n5 -114 V\n215 15 V\n-4 114 V\n-216 -15 V\n.5 g 1900 2842 N -216
      -15 0 -113 216 15 h\n1.000 UP\n1.000 UL\nLT2\n1900 2842 M\n0 -113
      V\n216 15 V\n0 113 V\n-216 -15 V\n.5448 g 1905 2953 N -216 -15 -4 -111
      215 15 h\n1.000 UP\n1.000 UL\nLT2\n1905 2953 M\n-5 -111 V\n216 15 V\n4
      111 V\n-215 -15 V\n.5892 g 1915 3061 N -215 -15 -6 -108 211 15 h\n1.000
      UP\n1.000 UL\nLT2\n1915 3061 M\n-10 -108 V\n215 15 V\n6 108 V\n-211 -15
      V\n.6329 g 1930 3165 N -211 -15 -10 -104 206 15 h\n1.000 UP\n1.000
      UL\nLT2\n1930 3165 M\n-15 -104 V\n211 15 V\n10 104 V\n-206 -15 V\n.6755
      g 1950 3265 N -206 -15 -12 -99 198 14 h\n1.000 UP\n1.000 UL\nLT2\n1950
      3265 M\n-20 -100 V\n206 15 V\n12 99 V\n-198 -14 V\n.7167 g 1974 3359 N
      -198 -14 -16 -94 190 14 h\n1.000 UP\n1.000 UL\nLT2\n1974 3359 M\n-24
      -94 V\n198 14 V\n16 94 V\n-190 -14 V\n.7562 g 2002 3447 N -190 -14 -19
      -87 181 13 h\n1.000 UP\n1.000 UL\nLT2\n2002 3447 M\n-28 -88 V\n190 14
      V\n19 87 V\n-181 -13 V\n.7936 g 2035 3528 N -181 -13 -21 -80 169 12
      h\n1.000 UP\n1.000 UL\nLT2\n2035 3528 M\n-33 -81 V\n181 13 V\n21 80
      V\n-169 -12 V\n.8286 g 2072 3602 N -169 -12 -24 -73 156 11 h\n1.000
      UP\n1.000 UL\nLT2\n2072 3602 M\n-37 -74 V\n169 12 V\n24 73 V\n-156 -11
      V\n.861 g 2112 3667 N -156 -11 -26 -64 142 10 h\n1.000 UP\n1.000
      UL\nLT2\n2112 3667 M\n-40 -65 V\n156 11 V\n26 64 V\n-142 -10 V\n.8905 g
      2156 3724 N -142 -10 -29 -56 127 9 h\n1.000 UP\n1.000 UL\nLT2\n2156
      3724 M\n-44 -57 V\n142 10 V\n29 56 V\n-127 -9 V\n.9169 g 2202 3771 N
      -127 -9 -30 -46 111 8 h\n1.000 UP\n1.000 UL\nLT2\n2202 3771 M\n-46 -47
      V\n127 9 V\n30 46 V\n-111 -8 V\n.9399 g 2251 3809 N -111 -8 -32 -37 94
      7 h\n1.000 UP\n1.000 UL\nLT2\n2251 3809 M\n-49 -38 V\n111 8 V\n32 37
      V\n-94 -7 V\n.9593 g 2303 3838 N -94 -7 -34 -27 76 5 h\n1.000 UP\n1.000
      UL\nLT2\n2303 3838 M\n-52 -29 V\n94 7 V\n34 27 V\n-76 -5 V\n.975 g 2356
      3856 N -76 -5 -34 -17 57 4 h\n1.000 UP\n1.000 UL\nLT2\n2356 3856 M\n-53
      -18 V\n76 5 V\n34 17 V\n-57 -4 V\n.987 g 2410 3864 N -57 -4 -36 -7 39 3
      h\n1.000 UP\n1.000 UL\nLT2\n2410 3864 M\n-54 -8 V\n57 4 V\n36 7 V\n-39
      -3 V\n.995 g 2465 3862 N -39 -3 -36 4 20 1 h\n1.000 UP\n1.000
      UL\nLT2\n2465 3862 M\n-55 2 V\n39 3 V\n36 -4 V\n-20 -1 V\n.999 g 2521
      3849 N -20 -1 -36 14 0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n-56
      13 V\n20 1 V\n36 -14 V\n.001 g 2485 1354 N 0 0 16 -25 20 1 h\n1.000
      UP\n1.000 UL\nLT2\n2485 1354 M\n36 -24 V\n-16 25 V\n-20 -1 V\n.005 g
      2449 1388 N -20 -1 15 -35 41 2 h\n1.000 UP\n1.000 UL\nLT2\n2449 1388
      M\n36 -34 V\n20 1 V\n-15 35 V\n-41 -2 V\n.013 g 2413 1432 N -41 -2 16
      -44 61 2 h\n1.000 UP\n1.000 UL\nLT2\n2413 1432 M\n36 -44 V\n41 2 V\n-16
      44 V\n-61 -2 V\n.025 g 2379 1485 N -61 -2 15 -54 80 3 h\n1.000
      UP\n1.000 UL\nLT2\n2379 1485 M\n34 -53 V\n61 2 V\n-15 54 V\n-80 -3
      V\n.0407 g 2345 1546 N -80 -3 14 -62 100 4 h\n1.000 UP\n1.000
      UL\nLT2\n2345 1546 M\n34 -61 V\n80 3 V\n-14 62 V\n-100 -4 V\n.0601 g
      2313 1617 N -100 -4 14 -71 118 4 h\n1.000 UP\n1.000 UL\nLT2\n2313 1617
      M\n32 -71 V\n100 4 V\n-14 71 V\n-118 -4 V\n.0831 g 2283 1695 N -118 -4
      13 -79 135 5 h\n1.000 UP\n1.000 UL\nLT2\n2283 1695 M\n30 -78 V\n118 4
      V\n-13 79 V\n-135 -5 V\n.1095 g 2254 1780 N -135 -5 13 -86 151 6
      h\n1.000 UP\n1.000 UL\nLT2\n2254 1780 M\n29 -85 V\n135 5 V\n-13 86
      V\n-151 -6 V\n.139 g 2228 1872 N -151 -6 11 -92 166 6 h\n1.000
      UP\n1.000 UL\nLT2\n2228 1872 M\n26 -92 V\n151 6 V\n-11 92 V\n-166 -6
      V\n.1714 g 2204 1970 N -166 -6 10 -99 180 7 h\n1.000 UP\n1.000
      UL\nLT2\n2204 1970 M\n24 -98 V\n166 6 V\n-10 99 V\n-180 -7 V\n.2064 g
      2183 2072 N -180 -7 10 -103 191 8 h\n1.000 UP\n1.000 UL\nLT2\n2183 2072
      M\n21 -102 V\n180 7 V\n-10 103 V\n-191 -8 V\n.2438 g 2164 2179 N -191
      -8 8 -107 202 8 h\n1.000 UP\n1.000 UL\nLT2\n2164 2179 M\n19 -107 V\n191
      8 V\n-8 107 V\n-202 -8 V\n.2833 g 2148 2289 N -202 -8 7 -110 211 8
      h\n1.000 UP\n1.000 UL\nLT2\n2148 2289 M\n16 -110 V\n202 8 V\n-7 110
      V\n-211 -8 V\n.3245 g 2136 2402 N -211 -8 5 -113 218 8 h\n1.000
      UP\n1.000 UL\nLT2\n2136 2402 M\n12 -113 V\n211 8 V\n-5 113 V\n-218 -8
      V\n.3671 g 2126 2516 N -218 -8 4 -114 224 8 h\n1.000 UP\n1.000
      UL\nLT2\n2126 2516 M\n10 -114 V\n218 8 V\n-4 114 V\n-224 -8 V\n.4108 g
      2120 2630 N -224 -8 3 -115 227 9 h\n1.000 UP\n1.000 UL\nLT2\n2120 2630
      M\n6 -114 V\n224 8 V\n-3 115 V\n-227 -9 V\n.4552 g 2116 2744 N -227 -9
      2 -114 229 9 h\n1.000 UP\n1.000 UL\nLT2\n2116 2744 M\n4 -114 V\n227 9
      V\n-2 114 V\n-229 -9 V\n.5 g 2116 2857 N -229 -9 0 -113 229 9 h\n1.000
      UP\n1.000 UL\nLT2\n2116 2857 M\n0 -113 V\n229 9 V\n0 113 V\n-229 -9
      V\n.5448 g 2120 2968 N -229 -9 -2 -111 227 9 h\n1.000 UP\n1.000
      UL\nLT2\n2120 2968 M\n-4 -111 V\n229 9 V\n2 111 V\n-227 -9 V\n.5892 g
      2126 3076 N -227 -9 -3 -108 224 9 h\n1.000 UP\n1.000 UL\nLT2\n2126 3076
      M\n-6 -108 V\n227 9 V\n3 108 V\n-224 -9 V\n.6329 g 2136 3180 N -224 -9
      -4 -103 218 8 h\n1.000 UP\n1.000 UL\nLT2\n2136 3180 M\n-10 -104 V\n224
      9 V\n4 103 V\n-218 -8 V\n.6755 g 2148 3279 N -218 -8 -5 -99 211 8
      h\n1.000 UP\n1.000 UL\nLT2\n2148 3279 M\n-12 -99 V\n218 8 V\n5 99
      V\n-211 -8 V\n.7167 g 2164 3373 N -211 -8 -7 -94 202 8 h\n1.000
      UP\n1.000 UL\nLT2\n2164 3373 M\n-16 -94 V\n211 8 V\n7 94 V\n-202 -8
      V\n.7562 g 2183 3460 N -202 -8 -8 -86 191 7 h\n1.000 UP\n1.000
      UL\nLT2\n2183 3460 M\n-19 -87 V\n202 8 V\n8 86 V\n-191 -7 V\n.7936 g
      2204 3540 N -191 -7 -10 -80 180 7 h\n1.000 UP\n1.000 UL\nLT2\n2204 3540
      M\n-21 -80 V\n191 7 V\n10 80 V\n-180 -7 V\n.8286 g 2228 3613 N -180 -7
      -10 -72 166 6 h\n1.000 UP\n1.000 UL\nLT2\n2228 3613 M\n-24 -73 V\n180 7
      V\n10 72 V\n-166 -6 V\n.861 g 2254 3677 N -166 -6 -11 -64 151 6
      h\n1.000 UP\n1.000 UL\nLT2\n2254 3677 M\n-26 -64 V\n166 6 V\n11 64
      V\n-151 -6 V\n.8905 g 2283 3733 N -151 -6 -13 -55 135 5 h\n1.000
      UP\n1.000 UL\nLT2\n2283 3733 M\n-29 -56 V\n151 6 V\n13 55 V\n-135 -5
      V\n.9169 g 2313 3779 N -135 -5 -13 -46 118 5 h\n1.000 UP\n1.000
      UL\nLT2\n2313 3779 M\n-30 -46 V\n135 5 V\n13 46 V\n-118 -5 V\n.9399 g
      2345 3816 N -118 -5 -14 -36 100 4 h\n1.000 UP\n1.000 UL\nLT2\n2345 3816
      M\n-32 -37 V\n118 5 V\n14 36 V\n-100 -4 V\n.9593 g 2379 3843 N -100 -4
      -14 -26 80 3 h\n1.000 UP\n1.000 UL\nLT2\n2379 3843 M\n-34 -27 V\n100 4
      V\n14 26 V\n-80 -3 V\n.975 g 2413 3860 N -80 -3 -15 -16 61 2 h\n1.000
      UP\n1.000 UL\nLT2\n2413 3860 M\n-34 -17 V\n80 3 V\n15 16 V\n-61 -2
      V\n.987 g 2449 3867 N -61 -2 -16 -6 41 1 h\n1.000 UP\n1.000
      UL\nLT2\n2449 3867 M\n-36 -7 V\n61 2 V\n16 6 V\n-41 -1 V\n.995 g 2485
      3863 N -41 -1 -15 4 20 1 h\n1.000 UP\n1.000 UL\nLT2\n2485 3863 M\n-36 4
      V\n41 1 V\n15 -4 V\n-20 -1 V\n.999 g 2521 3849 N -20 -1 -16 15 0 0
      h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n-36 14 V\n20 1 V\n16 -15
      V\n.001 g 2505 1355 N 0 0 -5 -25 21 0 h\n1.000 UP\n1.000 UL\nLT2\n2505
      1355 M\n16 -25 V\n5 25 V\n-21 0 V\n.005 g 2490 1390 N -21 0 -6 -35 42 0
      h\n1.000 UP\n1.000 UL\nLT2\n2490 1390 M\n15 -35 V\n21 0 V\n6 35 V\n-42
      0 V\n.013 g 2474 1434 N -42 0 -5 -44 63 0 h\n1.000 UP\n1.000
      UL\nLT2\n2474 1434 M\n16 -44 V\n42 0 V\n5 44 V\n-63 0 V\n.025 g 2459
      1488 N -63 0 -5 -54 83 0 h\n1.000 UP\n1.000 UL\nLT2\n2459 1488 M\n15
      -54 V\n63 0 V\n5 54 V\n-83 0 V\n.0407 g 2445 1550 N -83 0 -5 -63 102 1
      h\n1.000 UP\n1.000 UL\nLT2\n2445 1550 M\n14 -62 V\n83 0 V\n5 63 V\n-102
      -1 V\n.0601 g 2431 1621 N -102 -1 -4 -71 120 1 h\n1.000 UP\n1.000
      UL\nLT2\n2431 1621 M\n14 -71 V\n102 1 V\n4 71 V\n-120 -1 V\n.0831 g
      2418 1700 N -120 -1 -5 -79 138 1 h\n1.000 UP\n1.000 UL\nLT2\n2418 1700
      M\n13 -79 V\n120 1 V\n5 79 V\n-138 -1 V\n.1095 g 2405 1786 N -138 -1 -4
      -86 155 1 h\n1.000 UP\n1.000 UL\nLT2\n2405 1786 M\n13 -86 V\n138 1 V\n4
      86 V\n-155 -1 V\n.139 g 2394 1878 N -155 -1 -4 -93 170 2 h\n1.000
      UP\n1.000 UL\nLT2\n2394 1878 M\n11 -92 V\n155 1 V\n4 93 V\n-170 -2
      V\n.1714 g 2384 1977 N -170 -2 -3 -98 183 1 h\n1.000 UP\n1.000
      UL\nLT2\n2384 1977 M\n10 -99 V\n170 2 V\n3 98 V\n-183 -1 V\n.2064 g
      2374 2080 N -183 -1 -3 -103 196 1 h\n1.000 UP\n1.000 UL\nLT2\n2374 2080
      M\n10 -103 V\n183 1 V\n3 103 V\n-196 -1 V\n.2438 g 2366 2187 N -196 -1
      -3 -107 207 1 h\n1.000 UP\n1.000 UL\nLT2\n2366 2187 M\n8 -107 V\n196 1
      V\n3 107 V\n-207 -1 V\n.2833 g 2359 2297 N -207 -1 -2 -111 216 2
      h\n1.000 UP\n1.000 UL\nLT2\n2359 2297 M\n7 -110 V\n207 1 V\n2 111
      V\n-216 -2 V\n.3245 g 2354 2410 N -216 -2 -2 -113 223 2 h\n1.000
      UP\n1.000 UL\nLT2\n2354 2410 M\n5 -113 V\n216 2 V\n2 113 V\n-223 -2
      V\n.3671 g 2350 2524 N -223 -2 -2 -114 229 2 h\n1.000 UP\n1.000
      UL\nLT2\n2350 2524 M\n4 -114 V\n223 2 V\n2 114 V\n-229 -2 V\n.4108 g
      2347 2639 N -229 -2 0 -115 232 2 h\n1.000 UP\n1.000 UL\nLT2\n2347 2639
      M\n3 -115 V\n229 2 V\n0 115 V\n-232 -2 V\n.4552 g 2345 2753 N -232 -2
      -1 -114 235 2 h\n1.000 UP\n1.000 UL\nLT2\n2345 2753 M\n2 -114 V\n232 2
      V\n1 114 V\n-235 -2 V\n.5 g 2345 2866 N -235 -2 0 -113 235 2 h\n1.000
      UP\n1.000 UL\nLT2\n2345 2866 M\n0 -113 V\n235 2 V\n0 113 V\n-235 -2
      V\n.5448 g 2347 2977 N -235 -2 1 -111 232 2 h\n1.000 UP\n1.000
      UL\nLT2\n2347 2977 M\n-2 -111 V\n235 2 V\n-1 111 V\n-232 -2 V\n.5892 g
      2350 3085 N -232 -2 0 -108 229 2 h\n1.000 UP\n1.000 UL\nLT2\n2350 3085
      M\n-3 -108 V\n232 2 V\n0 108 V\n-229 -2 V\n.6329 g 2354 3188 N -229 -2
      2 -103 223 2 h\n1.000 UP\n1.000 UL\nLT2\n2354 3188 M\n-4 -103 V\n229 2
      V\n-2 103 V\n-223 -2 V\n.6755 g 2359 3287 N -223 -2 2 -99 216 2
      h\n1.000 UP\n1.000 UL\nLT2\n2359 3287 M\n-5 -99 V\n223 2 V\n-2 99
      V\n-216 -2 V\n.7167 g 2366 3381 N -216 -2 2 -93 207 1 h\n1.000
      UP\n1.000 UL\nLT2\n2366 3381 M\n-7 -94 V\n216 2 V\n-2 93 V\n-207 -1
      V\n.7562 g 2374 3467 N -207 -1 3 -87 196 2 h\n1.000 UP\n1.000
      UL\nLT2\n2374 3467 M\n-8 -86 V\n207 1 V\n-3 87 V\n-196 -2 V\n.7936 g
      2384 3547 N -196 -2 3 -80 183 2 h\n1.000 UP\n1.000 UL\nLT2\n2384 3547
      M\n-10 -80 V\n196 2 V\n-3 80 V\n-183 -2 V\n.8286 g 2394 3619 N -183 -2
      3 -72 170 2 h\n1.000 UP\n1.000 UL\nLT2\n2394 3619 M\n-10 -72 V\n183 2
      V\n-3 72 V\n-170 -2 V\n.861 g 2405 3683 N -170 -2 4 -63 155 1 h\n1.000
      UP\n1.000 UL\nLT2\n2405 3683 M\n-11 -64 V\n170 2 V\n-4 63 V\n-155 -1
      V\n.8905 g 2418 3738 N -155 -1 4 -55 138 1 h\n1.000 UP\n1.000
      UL\nLT2\n2418 3738 M\n-13 -55 V\n155 1 V\n-4 55 V\n-138 -1 V\n.9169 g
      2431 3784 N -138 -1 5 -46 120 1 h\n1.000 UP\n1.000 UL\nLT2\n2431 3784
      M\n-13 -46 V\n138 1 V\n-5 46 V\n-120 -1 V\n.9399 g 2445 3820 N -120 -1
      4 -36 102 1 h\n1.000 UP\n1.000 UL\nLT2\n2445 3820 M\n-14 -36 V\n120 1
      V\n-4 36 V\n-102 -1 V\n.9593 g 2459 3846 N -102 -1 5 -26 83 1 h\n1.000
      UP\n1.000 UL\nLT2\n2459 3846 M\n-14 -26 V\n102 1 V\n-5 26 V\n-83 -1
      V\n.975 g 2474 3862 N -83 -1 5 -16 63 1 h\n1.000 UP\n1.000
      UL\nLT2\n2474 3862 M\n-15 -16 V\n83 1 V\n-5 16 V\n-63 -1 V\n.987 g 2490
      3868 N -63 -1 5 -6 42 1 h\n1.000 UP\n1.000 UL\nLT2\n2490 3868 M\n-16 -6
      V\n63 1 V\n-5 6 V\n-42 -1 V\n.995 g 2505 3864 N -42 -1 6 5 21 0
      h\n1.000 UP\n1.000 UL\nLT2\n2505 3864 M\n-15 4 V\n42 1 V\n-6 -5 V\n-21
      0 V\n.999 g 2521 3849 N -21 0 5 15 0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521
      3849 M\n-16 15 V\n21 0 V\n-5 -15 V\n.001 g 2526 1355 N 0 0 -26 -24 21
      -1 h\n1.000 UP\n1.000 UL\nLT2\n2526 1355 M\n-5 -25 V\n26 24 V\n-21 1
      V\n.005 g 2532 1390 N -21 1 -26 -35 41 -1 h\n1.000 UP\n1.000
      UL\nLT2\n2532 1390 M\n-6 -35 V\n21 -1 V\n26 35 V\n-41 1 V\n.013 g 2537
      1434 N -41 1 -26 -44 62 -1 h\n1.000 UP\n1.000 UL\nLT2\n2537 1434 M\n-5
      -44 V\n41 -1 V\n26 44 V\n-62 1 V\n.025 g 2542 1488 N -62 1 -25 -53 82
      -2 h\n1.000 UP\n1.000 UL\nLT2\n2542 1488 M\n-5 -54 V\n62 -1 V\n25 53
      V\n-82 2 V\n.0407 g 2547 1551 N -82 2 -24 -63 101 -2 h\n1.000 UP\n1.000
      UL\nLT2\n2547 1551 M\n-5 -63 V\n82 -2 V\n24 63 V\n-101 2 V\n.0601 g
      2551 1622 N -101 2 -23 -71 120 -2 h\n1.000 UP\n1.000 UL\nLT2\n2551 1622
      M\n-4 -71 V\n101 -2 V\n23 71 V\n-120 2 V\n.0831 g 2556 1701 N -120 2
      -22 -78 137 -3 h\n1.000 UP\n1.000 UL\nLT2\n2556 1701 M\n-5 -79 V\n120
      -2 V\n22 78 V\n-137 3 V\n.1095 g 2560 1787 N -137 3 -20 -86 153 -3
      h\n1.000 UP\n1.000 UL\nLT2\n2560 1787 M\n-4 -86 V\n137 -3 V\n20 86
      V\n-153 3 V\n.139 g 2564 1880 N -153 3 -19 -92 168 -4 h\n1.000
      UP\n1.000 UL\nLT2\n2564 1880 M\n-4 -93 V\n153 -3 V\n19 92 V\n-168 4
      V\n.1714 g 2567 1978 N -168 4 -17 -98 182 -4 h\n1.000 UP\n1.000
      UL\nLT2\n2567 1978 M\n-3 -98 V\n168 -4 V\n17 98 V\n-182 4 V\n.2064 g
      2570 2081 N -182 4 -16 -103 195 -4 h\n1.000 UP\n1.000 UL\nLT2\n2570
      2081 M\n-3 -103 V\n182 -4 V\n16 103 V\n-195 4 V\n.2438 g 2573 2188 N
      -195 4 -13 -107 205 -4 h\n1.000 UP\n1.000 UL\nLT2\n2573 2188 M\n-3 -107
      V\n195 -4 V\n13 107 V\n-205 4 V\n.2833 g 2575 2299 N -205 4 -11 -110
      214 -5 h\n1.000 UP\n1.000 UL\nLT2\n2575 2299 M\n-2 -111 V\n205 -4 V\n11
      110 V\n-214 5 V\n.3245 g 2577 2412 N -214 5 -10 -113 222 -5 h\n1.000
      UP\n1.000 UL\nLT2\n2577 2412 M\n-2 -113 V\n214 -5 V\n10 113 V\n-222 5
      V\n.3671 g 2579 2526 N -222 5 -7 -114 227 -5 h\n1.000 UP\n1.000
      UL\nLT2\n2579 2526 M\n-2 -114 V\n222 -5 V\n7 114 V\n-227 5 V\n.4108 g
      2579 2641 N -227 5 -4 -114 231 -6 h\n1.000 UP\n1.000 UL\nLT2\n2579 2641
      M\n0 -115 V\n227 -5 V\n4 114 V\n-231 6 V\n.4552 g 2580 2755 N -231 6 -3
      -115 233 -5 h\n1.000 UP\n1.000 UL\nLT2\n2580 2755 M\n-1 -114 V\n231 -6
      V\n3 115 V\n-233 5 V\n.5 g 2580 2868 N -233 5 0 -113 233 -5 h\n1.000
      UP\n1.000 UL\nLT2\n2580 2868 M\n0 -113 V\n233 -5 V\n0 113 V\n-233 5
      V\n.5448 g 2579 2979 N -233 5 3 -111 231 -5 h\n1.000 UP\n1.000
      UL\nLT2\n2579 2979 M\n1 -111 V\n233 -5 V\n-3 111 V\n-231 5 V\n.5892 g
      2579 3087 N -231 5 4 -107 227 -6 h\n1.000 UP\n1.000 UL\nLT2\n2579 3087
      M\n0 -108 V\n231 -5 V\n-4 107 V\n-227 6 V\n.6329 g 2577 3190 N -227 6 7
      -104 222 -5 h\n1.000 UP\n1.000 UL\nLT2\n2577 3190 M\n2 -103 V\n227 -6
      V\n-7 104 V\n-222 5 V\n.6755 g 2575 3289 N -222 5 10 -99 214 -5
      h\n1.000 UP\n1.000 UL\nLT2\n2575 3289 M\n2 -99 V\n222 -5 V\n-10 99
      V\n-214 5 V\n.7167 g 2573 3382 N -214 5 11 -93 205 -5 h\n1.000
      UP\n1.000 UL\nLT2\n2573 3382 M\n2 -93 V\n214 -5 V\n-11 93 V\n-205 5
      V\n.7562 g 2570 3469 N -205 5 13 -87 195 -5 h\n1.000 UP\n1.000
      UL\nLT2\n2570 3469 M\n3 -87 V\n205 -5 V\n-13 87 V\n-195 5 V\n.7936 g
      2567 3549 N -195 5 16 -80 182 -5 h\n1.000 UP\n1.000 UL\nLT2\n2567 3549
      M\n3 -80 V\n195 -5 V\n-16 80 V\n-182 5 V\n.8286 g 2564 3621 N -182 5 17
      -73 168 -4 h\n1.000 UP\n1.000 UL\nLT2\n2564 3621 M\n3 -72 V\n182 -5
      V\n-17 73 V\n-168 4 V\n.861 g 2560 3684 N -168 4 19 -64 153 -3 h\n1.000
      UP\n1.000 UL\nLT2\n2560 3684 M\n4 -63 V\n168 -4 V\n-19 64 V\n-153 3
      V\n.8905 g 2556 3739 N -153 3 20 -55 137 -3 h\n1.000 UP\n1.000
      UL\nLT2\n2556 3739 M\n4 -55 V\n153 -3 V\n-20 55 V\n-137 3 V\n.9169 g
      2551 3785 N -137 3 22 -46 120 -3 h\n1.000 UP\n1.000 UL\nLT2\n2551 3785
      M\n5 -46 V\n137 -3 V\n-22 46 V\n-120 3 V\n.9399 g 2547 3821 N -120 3 23
      -36 101 -3 h\n1.000 UP\n1.000 UL\nLT2\n2547 3821 M\n4 -36 V\n120 -3
      V\n-23 36 V\n-101 3 V\n.9593 g 2542 3847 N -101 3 24 -27 82 -2 h\n1.000
      UP\n1.000 UL\nLT2\n2542 3847 M\n5 -26 V\n101 -3 V\n-24 27 V\n-82 2
      V\n.975 g 2537 3863 N -82 2 25 -16 62 -2 h\n1.000 UP\n1.000
      UL\nLT2\n2537 3863 M\n5 -16 V\n82 -2 V\n-25 16 V\n-62 2 V\n.987 g 2532
      3869 N -62 2 26 -7 41 -1 h\n1.000 UP\n1.000 UL\nLT2\n2532 3869 M\n5 -6
      V\n62 -2 V\n-26 7 V\n-41 1 V\n.995 g 2526 3864 N -41 1 26 5 21 -1
      h\n1.000 UP\n1.000 UL\nLT2\n2526 3864 M\n6 5 V\n41 -1 V\n-26 -5 V\n-21
      1 V\n.999 g 2521 3849 N -21 1 26 14 0 0 h\n1.000 UP\n1.000
      UL\nLT2\n2521 3849 M\n5 15 V\n21 -1 V\n-26 -14 V\n.001 g 2547 1354 N 0
      0 -46 -23 20 -1 h\n1.000 UP\n1.000 UL\nLT2\n2547 1354 M\n-26 -24 V\n46
      23 V\n-20 1 V\n.005 g 2573 1389 N -20 1 -46 -34 40 -2 h\n1.000
      UP\n1.000 UL\nLT2\n2573 1389 M\n-26 -35 V\n20 -1 V\n46 34 V\n-40 2
      V\n.013 g 2599 1433 N -40 2 -45 -43 59 -3 h\n1.000 UP\n1.000
      UL\nLT2\n2599 1433 M\n-26 -44 V\n40 -2 V\n45 43 V\n-59 3 V\n.025 g 2624
      1486 N -59 3 -44 -52 78 -4 h\n1.000 UP\n1.000 UL\nLT2\n2624 1486 M\n-25
      -53 V\n59 -3 V\n44 52 V\n-78 4 V\n.0407 g 2648 1549 N -78 4 -43 -61 97
      -6 h\n1.000 UP\n1.000 UL\nLT2\n2648 1549 M\n-24 -63 V\n78 -4 V\n43 61
      V\n-97 6 V\n.0601 g 2671 1620 N -97 6 -41 -70 115 -7 h\n1.000 UP\n1.000
      UL\nLT2\n2671 1620 M\n-23 -71 V\n97 -6 V\n41 70 V\n-115 7 V\n.0831 g
      2693 1698 N -115 7 -38 -78 131 -7 h\n1.000 UP\n1.000 UL\nLT2\n2693 1698
      M\n-22 -78 V\n115 -7 V\n38 78 V\n-131 7 V\n.1095 g 2713 1784 N -131 7
      -36 -85 147 -8 h\n1.000 UP\n1.000 UL\nLT2\n2713 1784 M\n-20 -86 V\n131
      -7 V\n36 85 V\n-147 8 V\n.139 g 2732 1876 N -147 8 -34 -91 162 -9
      h\n1.000 UP\n1.000 UL\nLT2\n2732 1876 M\n-19 -92 V\n147 -8 V\n34 91
      V\n-162 9 V\n.1714 g 2749 1974 N -162 9 -30 -97 175 -10 h\n1.000
      UP\n1.000 UL\nLT2\n2749 1974 M\n-17 -98 V\n162 -9 V\n30 97 V\n-175 10
      V\n.2064 g 2765 2077 N -175 10 -27 -102 186 -11 h\n1.000 UP\n1.000
      UL\nLT2\n2765 2077 M\n-16 -103 V\n175 -10 V\n27 102 V\n-186 11 V\n.2438
      g 2778 2184 N -186 11 -24 -107 197 -11 h\n1.000 UP\n1.000 UL\nLT2\n2778
      2184 M\n-13 -107 V\n186 -11 V\n24 107 V\n-197 11 V\n.2833 g 2789 2294 N
      -197 11 -20 -110 206 -11 h\n1.000 UP\n1.000 UL\nLT2\n2789 2294 M\n-11
      -110 V\n197 -11 V\n20 110 V\n-206 11 V\n.3245 g 2799 2407 N -206 11 -16
      -112 212 -12 h\n1.000 UP\n1.000 UL\nLT2\n2799 2407 M\n-10 -113 V\n206
      -11 V\n16 112 V\n-212 12 V\n.3671 g 2806 2521 N -212 12 -13 -114 218
      -12 h\n1.000 UP\n1.000 UL\nLT2\n2806 2521 M\n-7 -114 V\n212 -12 V\n13
      114 V\n-218 12 V\n.4108 g 2810 2635 N -218 12 -8 -114 222 -12 h\n1.000
      UP\n1.000 UL\nLT2\n2810 2635 M\n-4 -114 V\n218 -12 V\n8 114 V\n-222 12
      V\n.4552 g 2813 2750 N -222 12 -4 -114 223 -13 h\n1.000 UP\n1.000
      UL\nLT2\n2813 2750 M\n-3 -115 V\n222 -12 V\n4 114 V\n-223 13 V\n.5 g
      2813 2863 N -223 13 0 -113 223 -13 h\n1.000 UP\n1.000 UL\nLT2\n2813
      2863 M\n0 -113 V\n223 -13 V\n0 113 V\n-223 13 V\n.5448 g 2810 2974 N
      -223 13 4 -111 222 -13 h\n1.000 UP\n1.000 UL\nLT2\n2810 2974 M\n3 -111
      V\n223 -13 V\n-4 111 V\n-222 13 V\n.5892 g 2806 3081 N -222 13 8 -108
      218 -12 h\n1.000 UP\n1.000 UL\nLT2\n2806 3081 M\n4 -107 V\n222 -13
      V\n-8 108 V\n-218 12 V\n.6329 g 2799 3185 N -218 12 13 -104 212 -12
      h\n1.000 UP\n1.000 UL\nLT2\n2799 3185 M\n7 -104 V\n218 -12 V\n-13 104
      V\n-212 12 V\n.6755 g 2789 3284 N -212 12 16 -100 206 -11 h\n1.000
      UP\n1.000 UL\nLT2\n2789 3284 M\n10 -99 V\n212 -12 V\n-16 100 V\n-206 11
      V\n.7167 g 2778 3377 N -206 11 20 -94 197 -10 h\n1.000 UP\n1.000
      UL\nLT2\n2778 3377 M\n11 -93 V\n206 -11 V\n-20 94 V\n-197 10 V\n.7562 g
      2765 3464 N -197 10 24 -87 186 -10 h\n1.000 UP\n1.000 UL\nLT2\n2765
      3464 M\n13 -87 V\n197 -10 V\n-24 87 V\n-186 10 V\n.7936 g 2749 3544 N
      -186 10 27 -81 175 -9 h\n1.000 UP\n1.000 UL\nLT2\n2749 3544 M\n16 -80
      V\n186 -10 V\n-27 81 V\n-175 9 V\n.8286 g 2732 3617 N -175 9 30 -73 162
      -9 h\n1.000 UP\n1.000 UL\nLT2\n2732 3617 M\n17 -73 V\n175 -9 V\n-30 73
      V\n-162 9 V\n.861 g 2713 3681 N -162 9 34 -65 147 -8 h\n1.000 UP\n1.000
      UL\nLT2\n2713 3681 M\n19 -64 V\n162 -9 V\n-34 65 V\n-147 8 V\n.8905 g
      2693 3736 N -147 8 36 -56 131 -7 h\n1.000 UP\n1.000 UL\nLT2\n2693 3736
      M\n20 -55 V\n147 -8 V\n-36 56 V\n-131 7 V\n.9169 g 2671 3782 N -131 7
      38 -47 115 -6 h\n1.000 UP\n1.000 UL\nLT2\n2671 3782 M\n22 -46 V\n131 -7
      V\n-38 47 V\n-115 6 V\n.9399 g 2648 3818 N -115 6 41 -37 97 -5 h\n1.000
      UP\n1.000 UL\nLT2\n2648 3818 M\n23 -36 V\n115 -6 V\n-41 37 V\n-97 5
      V\n.9593 g 2624 3845 N -97 5 43 -28 78 -4 h\n1.000 UP\n1.000
      UL\nLT2\n2624 3845 M\n24 -27 V\n97 -5 V\n-43 28 V\n-78 4 V\n.975 g 2599
      3861 N -78 4 44 -17 59 -3 h\n1.000 UP\n1.000 UL\nLT2\n2599 3861 M\n25
      -16 V\n78 -4 V\n-44 17 V\n-59 3 V\n.987 g 2573 3868 N -59 3 45 -7 40 -3
      h\n1.000 UP\n1.000 UL\nLT2\n2573 3868 M\n26 -7 V\n59 -3 V\n-45 7 V\n-40
      3 V\n.995 g 2547 3863 N -40 3 46 3 20 -1 h\n1.000 UP\n1.000
      UL\nLT2\n2547 3863 M\n26 5 V\n40 -3 V\n-46 -3 V\n-20 1 V\n.999 g 2521
      3849 N -20 1 46 13 0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n26 14
      V\n20 -1 V\n-46 -13 V\n.001 g 2567 1353 N 0 0 -65 -22 19 -1 h\n1.000
      UP\n1.000 UL\nLT2\n2567 1353 M\n-46 -23 V\n65 22 V\n-19 1 V\n.005 g
      2613 1387 N -19 1 -64 -31 37 -4 h\n1.000 UP\n1.000 UL\nLT2\n2613 1387
      M\n-46 -34 V\n19 -1 V\n64 31 V\n-37 4 V\n.013 g 2658 1430 N -37 4 -63
      -42 55 -5 h\n1.000 UP\n1.000 UL\nLT2\n2658 1430 M\n-45 -43 V\n37 -4
      V\n63 42 V\n-55 5 V\n.025 g 2702 1482 N -55 5 -62 -51 73 -6 h\n1.000
      UP\n1.000 UL\nLT2\n2702 1482 M\n-44 -52 V\n55 -5 V\n62 51 V\n-73 6
      V\n.0407 g 2745 1543 N -73 6 -60 -59 90 -8 h\n1.000 UP\n1.000
      UL\nLT2\n2745 1543 M\n-43 -61 V\n73 -6 V\n60 59 V\n-90 8 V\n.0601 g
      2786 1613 N -90 8 -57 -68 106 -10 h\n1.000 UP\n1.000 UL\nLT2\n2786 1613
      M\n-41 -70 V\n90 -8 V\n57 68 V\n-106 10 V\n.0831 g 2824 1691 N -106 10
      -54 -77 122 -11 h\n1.000 UP\n1.000 UL\nLT2\n2824 1691 M\n-38 -78 V\n106
      -10 V\n54 77 V\n-122 11 V\n.1095 g 2860 1776 N -122 11 -50 -83 136 -13
      h\n1.000 UP\n1.000 UL\nLT2\n2860 1776 M\n-36 -85 V\n122 -11 V\n50 83
      V\n-136 13 V\n.139 g 2894 1867 N -136 13 -47 -90 149 -14 h\n1.000
      UP\n1.000 UL\nLT2\n2894 1867 M\n-34 -91 V\n136 -13 V\n47 90 V\n-149 14
      V\n.1714 g 2924 1964 N -149 14 -43 -96 162 -15 h\n1.000 UP\n1.000
      UL\nLT2\n2924 1964 M\n-30 -97 V\n149 -14 V\n43 96 V\n-162 15 V\n.2064 g
      2951 2066 N -162 15 -38 -102 173 -15 h\n1.000 UP\n1.000 UL\nLT2\n2951
      2066 M\n-27 -102 V\n162 -15 V\n38 102 V\n-173 15 V\n.2438 g 2975 2173 N
      -173 15 -33 -105 182 -17 h\n1.000 UP\n1.000 UL\nLT2\n2975 2173 M\n-24
      -107 V\n173 -15 V\n33 105 V\n-182 17 V\n.2833 g 2995 2283 N -182 17 -28
      -109 190 -18 h\n1.000 UP\n1.000 UL\nLT2\n2995 2283 M\n-20 -110 V\n182
      -17 V\n28 109 V\n-190 18 V\n.3245 g 3011 2395 N -190 18 -23 -112 197
      -18 h\n1.000 UP\n1.000 UL\nLT2\n3011 2395 M\n-16 -112 V\n190 -18 V\n23
      112 V\n-197 18 V\n.3671 g 3024 2509 N -197 18 -18 -113 202 -19 h\n1.000
      UP\n1.000 UL\nLT2\n3024 2509 M\n-13 -114 V\n197 -18 V\n18 113 V\n-202
      19 V\n.4108 g 3032 2623 N -202 19 -11 -114 205 -19 h\n1.000 UP\n1.000
      UL\nLT2\n3032 2623 M\n-8 -114 V\n202 -19 V\n11 114 V\n-205 19 V\n.4552
      g 3036 2737 N -205 19 -6 -115 207 -18 h\n1.000 UP\n1.000 UL\nLT2\n3036
      2737 M\n-4 -114 V\n205 -19 V\n6 115 V\n-207 18 V\n.5 g 3036 2850 N -207
      18 0 -113 207 -18 h\n1.000 UP\n1.000 UL\nLT2\n3036 2850 M\n0 -113
      V\n207 -18 V\n0 113 V\n-207 18 V\n.5448 g 3032 2961 N -207 18 6 -111
      205 -18 h\n1.000 UP\n1.000 UL\nLT2\n3032 2961 M\n4 -111 V\n207 -18
      V\n-6 111 V\n-205 18 V\n.5892 g 3024 3069 N -205 18 11 -108 202 -18
      h\n1.000 UP\n1.000 UL\nLT2\n3024 3069 M\n8 -108 V\n205 -18 V\n-11 108
      V\n-202 18 V\n.6329 g 3011 3173 N -202 18 18 -104 197 -18 h\n1.000
      UP\n1.000 UL\nLT2\n3011 3173 M\n13 -104 V\n202 -18 V\n-18 104 V\n-197
      18 V\n.6755 g 2995 3273 N -197 18 23 -100 190 -18 h\n1.000 UP\n1.000
      UL\nLT2\n2995 3273 M\n16 -100 V\n197 -18 V\n-23 100 V\n-190 18 V\n.7167
      g 2975 3367 N -190 18 28 -95 182 -17 h\n1.000 UP\n1.000 UL\nLT2\n2975
      3367 M\n20 -94 V\n190 -18 V\n-28 95 V\n-182 17 V\n.7562 g 2951 3454 N
      -182 17 33 -88 173 -16 h\n1.000 UP\n1.000 UL\nLT2\n2951 3454 M\n24 -87
      V\n182 -17 V\n-33 88 V\n-173 16 V\n.7936 g 2924 3535 N -173 16 38 -82
      162 -15 h\n1.000 UP\n1.000 UL\nLT2\n2924 3535 M\n27 -81 V\n173 -16
      V\n-38 82 V\n-162 15 V\n.8286 g 2894 3608 N -162 15 43 -74 149 -14
      h\n1.000 UP\n1.000 UL\nLT2\n2894 3608 M\n30 -73 V\n162 -15 V\n-43 74
      V\n-149 14 V\n.861 g 2860 3673 N -149 14 47 -66 136 -13 h\n1.000
      UP\n1.000 UL\nLT2\n2860 3673 M\n34 -65 V\n149 -14 V\n-47 66 V\n-136 13
      V\n.8905 g 2824 3729 N -136 13 50 -58 122 -11 h\n1.000 UP\n1.000
      UL\nLT2\n2824 3729 M\n36 -56 V\n136 -13 V\n-50 58 V\n-122 11 V\n.9169 g
      2786 3776 N -122 11 54 -48 106 -10 h\n1.000 UP\n1.000 UL\nLT2\n2786
      3776 M\n38 -47 V\n122 -11 V\n-54 48 V\n-106 10 V\n.9399 g 2745 3813 N
      -106 10 57 -39 90 -8 h\n1.000 UP\n1.000 UL\nLT2\n2745 3813 M\n41 -37
      V\n106 -10 V\n-57 39 V\n-90 8 V\n.9593 g 2702 3841 N -90 8 60 -29 73 -7
      h\n1.000 UP\n1.000 UL\nLT2\n2702 3841 M\n43 -28 V\n90 -8 V\n-60 29
      V\n-73 7 V\n.975 g 2658 3858 N -73 7 62 -19 55 -5 h\n1.000 UP\n1.000
      UL\nLT2\n2658 3858 M\n44 -17 V\n73 -7 V\n-62 19 V\n-55 5 V\n.987 g 2613
      3865 N -55 5 63 -9 37 -3 h\n1.000 UP\n1.000 UL\nLT2\n2613 3865 M\n45 -7
      V\n55 -5 V\n-63 9 V\n-37 3 V\n.995 g 2567 3862 N -37 3 64 1 19 -1
      h\n1.000 UP\n1.000 UL\nLT2\n2567 3862 M\n46 3 V\n37 -3 V\n-64 -1 V\n-19
      1 V\n.999 g 2521 3849 N -19 1 65 12 0 0 h\n1.000 UP\n1.000
      UL\nLT2\n2521 3849 M\n46 13 V\n19 -1 V\n-65 -12 V\n.001 g 2586 1352 N 0
      0 -81 -19 16 -3 h\n1.000 UP\n1.000 UL\nLT2\n2586 1352 M\n-65 -22 V\n81
      19 V\n-16 3 V\n.005 g 2650 1383 N -16 3 -81 -30 33 -4 h\n1.000
      UP\n1.000 UL\nLT2\n2650 1383 M\n-64 -31 V\n16 -3 V\n81 30 V\n-33 4
      V\n.013 g 2713 1425 N -33 4 -79 -39 49 -7 h\n1.000 UP\n1.000
      UL\nLT2\n2713 1425 M\n-63 -42 V\n33 -4 V\n79 39 V\n-49 7 V\n.025 g 2775
      1476 N -49 7 -78 -49 65 -9 h\n1.000 UP\n1.000 UL\nLT2\n2775 1476 M\n-62
      -51 V\n49 -7 V\n78 49 V\n-65 9 V\n.0407 g 2835 1535 N -65 9 -74 -57 79
      -11 h\n1.000 UP\n1.000 UL\nLT2\n2835 1535 M\n-60 -59 V\n65 -9 V\n74 57
      V\n-79 11 V\n.0601 g 2892 1603 N -79 11 -72 -67 94 -12 h\n1.000
      UP\n1.000 UL\nLT2\n2892 1603 M\n-57 -68 V\n79 -11 V\n72 67 V\n-94 12
      V\n.0831 g 2946 1680 N -94 12 -68 -74 108 -15 h\n1.000 UP\n1.000
      UL\nLT2\n2946 1680 M\n-54 -77 V\n94 -12 V\n68 74 V\n-108 15 V\n.1095 g
      2996 1763 N -108 15 -63 -82 121 -16 h\n1.000 UP\n1.000 UL\nLT2\n2996
      1763 M\n-50 -83 V\n108 -15 V\n63 82 V\n-121 16 V\n.139 g 3043 1853 N
      -121 16 -59 -88 133 -18 h\n1.000 UP\n1.000 UL\nLT2\n3043 1853 M\n-47
      -90 V\n121 -16 V\n59 88 V\n-133 18 V\n.1714 g 3086 1949 N -133 18 -54
      -95 144 -19 h\n1.000 UP\n1.000 UL\nLT2\n3086 1949 M\n-43 -96 V\n133 -18
      V\n54 95 V\n-144 19 V\n.2064 g 3124 2051 N -144 19 -48 -100 154 -21
      h\n1.000 UP\n1.000 UL\nLT2\n3124 2051 M\n-38 -102 V\n144 -19 V\n48 100
      V\n-154 21 V\n.2438 g 3157 2156 N -154 21 -41 -104 162 -22 h\n1.000
      UP\n1.000 UL\nLT2\n3157 2156 M\n-33 -105 V\n154 -21 V\n41 104 V\n-162
      22 V\n.2833 g 3185 2265 N -162 22 -36 -108 170 -23 h\n1.000 UP\n1.000
      UL\nLT2\n3185 2265 M\n-28 -109 V\n162 -22 V\n36 108 V\n-170 23 V\n.3245
      g 3208 2377 N -170 23 -28 -111 175 -24 h\n1.000 UP\n1.000 UL\nLT2\n3208
      2377 M\n-23 -112 V\n170 -23 V\n28 111 V\n-175 24 V\n.3671 g 3226 2490 N
      -175 24 -22 -113 179 -24 h\n1.000 UP\n1.000 UL\nLT2\n3226 2490 M\n-18
      -113 V\n175 -24 V\n22 113 V\n-179 24 V\n.4108 g 3237 2604 N -179 24 -14
      -114 182 -24 h\n1.000 UP\n1.000 UL\nLT2\n3237 2604 M\n-11 -114 V\n179
      -24 V\n14 114 V\n-182 24 V\n.4552 g 3243 2719 N -182 24 -8 -114 184 -25
      h\n1.000 UP\n1.000 UL\nLT2\n3243 2719 M\n-6 -115 V\n182 -24 V\n8 114
      V\n-184 25 V\n.5 g 3243 2832 N -184 25 0 -113 184 -25 h\n1.000
      UP\n1.000 UL\nLT2\n3243 2832 M\n0 -113 V\n184 -25 V\n0 113 V\n-184 25
      V\n.5448 g 3237 2943 N -184 25 8 -111 182 -25 h\n1.000 UP\n1.000
      UL\nLT2\n3237 2943 M\n6 -111 V\n184 -25 V\n-8 111 V\n-182 25 V\n.5892 g
      3226 3051 N -182 25 14 -109 179 -24 h\n1.000 UP\n1.000 UL\nLT2\n3226
      3051 M\n11 -108 V\n182 -25 V\n-14 109 V\n-179 24 V\n.6329 g 3208 3155 N
      -179 24 22 -105 175 -23 h\n1.000 UP\n1.000 UL\nLT2\n3208 3155 M\n18
      -104 V\n179 -24 V\n-22 105 V\n-175 23 V\n.6755 g 3185 3255 N -175 23 28
      -100 170 -23 h\n1.000 UP\n1.000 UL\nLT2\n3185 3255 M\n23 -100 V\n175
      -23 V\n-28 100 V\n-170 23 V\n.7167 g 3157 3350 N -170 23 36 -96 162 -22
      h\n1.000 UP\n1.000 UL\nLT2\n3157 3350 M\n28 -95 V\n170 -23 V\n-36 96
      V\n-162 22 V\n.7562 g 3124 3438 N -162 22 41 -90 154 -20 h\n1.000
      UP\n1.000 UL\nLT2\n3124 3438 M\n33 -88 V\n162 -22 V\n-41 90 V\n-154 20
      V\n.7936 g 3086 3520 N -154 20 48 -83 144 -19 h\n1.000 UP\n1.000
      UL\nLT2\n3086 3520 M\n38 -82 V\n154 -20 V\n-48 83 V\n-144 19 V\n.8286 g
      3043 3594 N -144 19 54 -75 133 -18 h\n1.000 UP\n1.000 UL\nLT2\n3043
      3594 M\n43 -74 V\n144 -19 V\n-54 75 V\n-133 18 V\n.861 g 2996 3660 N
      -133 18 59 -68 121 -16 h\n1.000 UP\n1.000 UL\nLT2\n2996 3660 M\n47 -66
      V\n133 -18 V\n-59 68 V\n-121 16 V\n.8905 g 2946 3718 N -121 16 63 -59
      108 -15 h\n1.000 UP\n1.000 UL\nLT2\n2946 3718 M\n50 -58 V\n121 -16
      V\n-63 59 V\n-108 15 V\n.9169 g 2892 3766 N -108 15 68 -50 94 -13
      h\n1.000 UP\n1.000 UL\nLT2\n2892 3766 M\n54 -48 V\n108 -15 V\n-68 50
      V\n-94 13 V\n.9399 g 2835 3805 N -94 13 72 -41 79 -11 h\n1.000
      UP\n1.000 UL\nLT2\n2835 3805 M\n57 -39 V\n94 -13 V\n-72 41 V\n-79 11
      V\n.9593 g 2775 3834 N -79 11 74 -31 65 -9 h\n1.000 UP\n1.000
      UL\nLT2\n2775 3834 M\n60 -29 V\n79 -11 V\n-74 31 V\n-65 9 V\n.975 g
      2713 3853 N -65 9 78 -21 49 -7 h\n1.000 UP\n1.000 UL\nLT2\n2713 3853
      M\n62 -19 V\n65 -9 V\n-78 21 V\n-49 7 V\n.987 g 2650 3862 N -49 7 79
      -12 33 -4 h\n1.000 UP\n1.000 UL\nLT2\n2650 3862 M\n63 -9 V\n49 -7
      V\n-79 12 V\n-33 4 V\n.995 g 2586 3861 N -33 4 81 0 16 -3 h\n1.000
      UP\n1.000 UL\nLT2\n2586 3861 M\n64 1 V\n33 -4 V\n-81 0 V\n-16 3 V\n.999
      g 2521 3849 N -16 3 81 9 0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521 3849
      M\n65 12 V\n16 -3 V\n-81 -9 V\n.001 g 2602 1349 N 0 0 -95 -17 14 -2
      h\n1.000 UP\n1.000 UL\nLT2\n2602 1349 M\n-81 -19 V\n95 17 V\n-14 2
      V\n.005 g 2683 1379 N -14 2 -95 -27 28 -5 h\n1.000 UP\n1.000
      UL\nLT2\n2683 1379 M\n-81 -30 V\n14 -2 V\n95 27 V\n-28 5 V\n.013 g 2762
      1418 N -28 5 -92 -36 41 -8 h\n1.000 UP\n1.000 UL\nLT2\n2762 1418 M\n-79
      -39 V\n28 -5 V\n92 36 V\n-41 8 V\n.025 g 2840 1467 N -41 8 -91 -46 54
      -11 h\n1.000 UP\n1.000 UL\nLT2\n2840 1467 M\n-78 -49 V\n41 -8 V\n91 46
      V\n-54 11 V\n.0407 g 2914 1524 N -54 11 -87 -55 67 -13 h\n1.000
      UP\n1.000 UL\nLT2\n2914 1524 M\n-74 -57 V\n54 -11 V\n87 55 V\n-67 13
      V\n.0601 g 2986 1591 N -67 13 -84 -64 79 -16 h\n1.000 UP\n1.000
      UL\nLT2\n2986 1591 M\n-72 -67 V\n67 -13 V\n84 64 V\n-79 16 V\n.0831 g
      3054 1665 N -79 16 -80 -72 91 -18 h\n1.000 UP\n1.000 UL\nLT2\n3054 1665
      M\n-68 -74 V\n79 -16 V\n80 72 V\n-91 18 V\n.1095 g 3117 1747 N -91 18
      -74 -80 102 -20 h\n1.000 UP\n1.000 UL\nLT2\n3117 1747 M\n-63 -82 V\n91
      -18 V\n74 80 V\n-102 20 V\n.139 g 3176 1835 N -102 20 -69 -87 112 -21
      h\n1.000 UP\n1.000 UL\nLT2\n3176 1835 M\n-59 -88 V\n102 -20 V\n69 87
      V\n-112 21 V\n.1714 g 3230 1930 N -112 21 -63 -92 121 -24 h\n1.000
      UP\n1.000 UL\nLT2\n3230 1930 M\n-54 -95 V\n112 -21 V\n63 92 V\n-121 24
      V\n.2064 g 3278 2030 N -121 24 -56 -99 129 -25 h\n1.000 UP\n1.000
      UL\nLT2\n3278 2030 M\n-48 -100 V\n121 -24 V\n56 99 V\n-129 25 V\n.2438
      g 3319 2134 N -129 25 -48 -103 136 -26 h\n1.000 UP\n1.000 UL\nLT2\n3319
      2134 M\n-41 -104 V\n129 -25 V\n48 103 V\n-136 26 V\n.2833 g 3355 2242 N
      -136 26 -42 -107 142 -27 h\n1.000 UP\n1.000 UL\nLT2\n3355 2242 M\n-36
      -108 V\n136 -26 V\n42 107 V\n-142 27 V\n.3245 g 3383 2353 N -142 27 -33
      -110 147 -28 h\n1.000 UP\n1.000 UL\nLT2\n3383 2353 M\n-28 -111 V\n142
      -27 V\n33 110 V\n-147 28 V\n.3671 g 3405 2466 N -147 28 -26 -112 151
      -29 h\n1.000 UP\n1.000 UL\nLT2\n3405 2466 M\n-22 -113 V\n147 -28 V\n26
      112 V\n-151 29 V\n.4108 g 3419 2580 N -151 29 -17 -113 154 -30 h\n1.000
      UP\n1.000 UL\nLT2\n3419 2580 M\n-14 -114 V\n151 -29 V\n17 113 V\n-154
      30 V\n.4552 g 3427 2694 N -154 30 -8 -114 154 -30 h\n1.000 UP\n1.000
      UL\nLT2\n3427 2694 M\n-8 -114 V\n154 -30 V\n8 114 V\n-154 30 V\n.5 g
      3427 2807 N -154 30 0 -113 154 -30 h\n1.000 UP\n1.000 UL\nLT2\n3427
      2807 M\n0 -113 V\n154 -30 V\n0 113 V\n-154 30 V\n.5448 g 3419 2918 N
      -154 30 8 -111 154 -30 h\n1.000 UP\n1.000 UL\nLT2\n3419 2918 M\n8 -111
      V\n154 -30 V\n-8 111 V\n-154 30 V\n.5892 g 3405 3027 N -154 30 17 -109
      151 -30 h\n1.000 UP\n1.000 UL\nLT2\n3405 3027 M\n14 -109 V\n154 -30
      V\n-17 109 V\n-151 30 V\n.6329 g 3383 3132 N -151 30 26 -106 147 -29
      h\n1.000 UP\n1.000 UL\nLT2\n3383 3132 M\n22 -105 V\n151 -30 V\n-26 106
      V\n-147 29 V\n.6755 g 3355 3232 N -147 29 33 -102 142 -27 h\n1.000
      UP\n1.000 UL\nLT2\n3355 3232 M\n28 -100 V\n147 -29 V\n-33 102 V\n-142
      27 V\n.7167 g 3319 3328 N -142 27 42 -97 136 -26 h\n1.000 UP\n1.000
      UL\nLT2\n3319 3328 M\n36 -96 V\n142 -27 V\n-42 97 V\n-136 26 V\n.7562 g
      3278 3418 N -136 26 48 -91 129 -25 h\n1.000 UP\n1.000 UL\nLT2\n3278
      3418 M\n41 -90 V\n136 -26 V\n-48 91 V\n-129 25 V\n.7936 g 3230 3501 N
      -129 25 56 -84 121 -24 h\n1.000 UP\n1.000 UL\nLT2\n3230 3501 M\n48 -83
      V\n129 -25 V\n-56 84 V\n-121 24 V\n.8286 g 3176 3576 N -121 24 63 -77
      112 -22 h\n1.000 UP\n1.000 UL\nLT2\n3176 3576 M\n54 -75 V\n121 -24
      V\n-63 77 V\n-112 22 V\n.861 g 3117 3644 N -112 22 69 -70 102 -20
      h\n1.000 UP\n1.000 UL\nLT2\n3117 3644 M\n59 -68 V\n112 -22 V\n-69 70
      V\n-102 20 V\n.8905 g 3054 3703 N -102 20 74 -61 91 -18 h\n1.000
      UP\n1.000 UL\nLT2\n3054 3703 M\n63 -59 V\n102 -20 V\n-74 61 V\n-91 18
      V\n.9169 g 2986 3753 N -91 18 80 -53 79 -15 h\n1.000 UP\n1.000
      UL\nLT2\n2986 3753 M\n68 -50 V\n91 -18 V\n-80 53 V\n-79 15 V\n.9399 g
      2914 3794 N -79 15 84 -43 67 -13 h\n1.000 UP\n1.000 UL\nLT2\n2914 3794
      M\n72 -41 V\n79 -15 V\n-84 43 V\n-67 13 V\n.9593 g 2840 3825 N -67 13
      87 -34 54 -10 h\n1.000 UP\n1.000 UL\nLT2\n2840 3825 M\n74 -31 V\n67 -13
      V\n-87 34 V\n-54 10 V\n.975 g 2762 3846 N -54 10 91 -23 41 -8 h\n1.000
      UP\n1.000 UL\nLT2\n2762 3846 M\n78 -21 V\n54 -10 V\n-91 23 V\n-41 8
      V\n.987 g 2683 3858 N -41 8 92 -14 28 -6 h\n1.000 UP\n1.000
      UL\nLT2\n2683 3858 M\n79 -12 V\n41 -8 V\n-92 14 V\n-28 6 V\n.995 g 2602
      3858 N -28 6 95 -4 14 -2 h\n1.000 UP\n1.000 UL\nLT2\n2602 3858 M\n81 0
      V\n28 -6 V\n-95 4 V\n-14 2 V\n.999 g 2521 3849 N -14 2 95 7 0 0
      h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n81 9 V\n14 -2 V\n-95 -7
      V\n.001 g 2616 1347 N 0 0 -106 -14 11 -3 h\n1.000 UP\n1.000
      UL\nLT2\n2616 1347 M\n-95 -17 V\n106 14 V\n-11 3 V\n.005 g 2711 1374 N
      -11 3 -105 -23 21 -7 h\n1.000 UP\n1.000 UL\nLT2\n2711 1374 M\n-95 -27
      V\n11 -3 V\n105 23 V\n-21 7 V\n.013 g 2803 1410 N -21 7 -103 -34 32 -9
      h\n1.000 UP\n1.000 UL\nLT2\n2803 1410 M\n-92 -36 V\n21 -7 V\n103 34
      V\n-32 9 V\n.025 g 2894 1456 N -32 9 -101 -43 42 -12 h\n1.000 UP\n1.000
      UL\nLT2\n2894 1456 M\n-91 -46 V\n32 -9 V\n101 43 V\n-42 12 V\n.0407 g
      2981 1511 N -42 12 -98 -53 53 -14 h\n1.000 UP\n1.000 UL\nLT2\n2981 1511
      M\n-87 -55 V\n42 -12 V\n98 53 V\n-53 14 V\n.0601 g 3065 1575 N -53 14
      -93 -61 62 -17 h\n1.000 UP\n1.000 UL\nLT2\n3065 1575 M\n-84 -64 V\n53
      -14 V\n93 61 V\n-62 17 V\n.0831 g 3145 1647 N -62 17 -89 -69 71 -20
      h\n1.000 UP\n1.000 UL\nLT2\n3145 1647 M\n-80 -72 V\n62 -17 V\n89 69
      V\n-71 20 V\n.1095 g 3219 1727 N -71 20 -83 -77 80 -23 h\n1.000
      UP\n1.000 UL\nLT2\n3219 1727 M\n-74 -80 V\n71 -20 V\n83 77 V\n-80 23
      V\n.139 g 3288 1814 N -80 23 -76 -85 87 -25 h\n1.000 UP\n1.000
      UL\nLT2\n3288 1814 M\n-69 -87 V\n80 -23 V\n76 85 V\n-87 25 V\n.1714 g
      3351 1906 N -87 25 -70 -91 94 -26 h\n1.000 UP\n1.000 UL\nLT2\n3351 1906
      M\n-63 -92 V\n87 -25 V\n70 91 V\n-94 26 V\n.2064 g 3407 2005 N -94 26
      -62 -96 100 -29 h\n1.000 UP\n1.000 UL\nLT2\n3407 2005 M\n-56 -99 V\n94
      -26 V\n62 96 V\n-100 29 V\n.2438 g 3455 2108 N -100 29 -55 -102 107 -30
      h\n1.000 UP\n1.000 UL\nLT2\n3455 2108 M\n-48 -103 V\n100 -29 V\n55 102
      V\n-107 30 V\n.2833 g 3497 2215 N -107 30 -46 -105 111 -32 h\n1.000
      UP\n1.000 UL\nLT2\n3497 2215 M\n-42 -107 V\n107 -30 V\n46 105 V\n-111
      32 V\n.3245 g 3530 2325 N -111 32 -37 -109 115 -33 h\n1.000 UP\n1.000
      UL\nLT2\n3530 2325 M\n-33 -110 V\n111 -32 V\n37 109 V\n-115 33 V\n.3671
      g 3556 2437 N -115 33 -28 -111 117 -34 h\n1.000 UP\n1.000 UL\nLT2\n3556
      2437 M\n-26 -112 V\n115 -33 V\n28 111 V\n-117 34 V\n.4108 g 3573 2550 N
      -117 34 -19 -113 119 -34 h\n1.000 UP\n1.000 UL\nLT2\n3573 2550 M\n-17
      -113 V\n117 -34 V\n19 113 V\n-119 34 V\n.4552 g 3581 2664 N -119 34 -10
      -113 121 -35 h\n1.000 UP\n1.000 UL\nLT2\n3581 2664 M\n-8 -114 V\n119
      -34 V\n10 113 V\n-121 35 V\n.5 g 3581 2777 N -121 35 0 -113 121 -35
      h\n1.000 UP\n1.000 UL\nLT2\n3581 2777 M\n0 -113 V\n121 -35 V\n0 113
      V\n-121 35 V\n.5448 g 3573 2888 N -121 35 10 -112 119 -34 h\n1.000
      UP\n1.000 UL\nLT2\n3573 2888 M\n8 -111 V\n121 -35 V\n-10 112 V\n-119 34
      V\n.5892 g 3556 2997 N -119 34 19 -110 117 -33 h\n1.000 UP\n1.000
      UL\nLT2\n3556 2997 M\n17 -109 V\n119 -34 V\n-19 110 V\n-117 33 V\n.6329
      g 3530 3103 N -117 33 28 -107 115 -32 h\n1.000 UP\n1.000 UL\nLT2\n3530
      3103 M\n26 -106 V\n117 -33 V\n-28 107 V\n-115 32 V\n.6755 g 3497 3205 N
      -115 32 37 -102 111 -32 h\n1.000 UP\n1.000 UL\nLT2\n3497 3205 M\n33
      -102 V\n115 -32 V\n-37 102 V\n-111 32 V\n.7167 g 3455 3302 N -111 32 46
      -98 107 -31 h\n1.000 UP\n1.000 UL\nLT2\n3455 3302 M\n42 -97 V\n111 -32
      V\n-46 98 V\n-107 31 V\n.7562 g 3407 3393 N -107 31 55 -93 100 -29
      h\n1.000 UP\n1.000 UL\nLT2\n3407 3393 M\n48 -91 V\n107 -31 V\n-55 93
      V\n-100 29 V\n.7936 g 3351 3477 N -100 29 62 -86 94 -27 h\n1.000
      UP\n1.000 UL\nLT2\n3351 3477 M\n56 -84 V\n100 -29 V\n-62 86 V\n-94 27
      V\n.8286 g 3288 3554 N -94 27 70 -80 87 -24 h\n1.000 UP\n1.000
      UL\nLT2\n3288 3554 M\n63 -77 V\n94 -27 V\n-70 80 V\n-87 24 V\n.861 g
      3219 3624 N -87 24 76 -72 80 -22 h\n1.000 UP\n1.000 UL\nLT2\n3219 3624
      M\n69 -70 V\n87 -24 V\n-76 72 V\n-80 22 V\n.8905 g 3145 3685 N -80 22
      83 -63 71 -20 h\n1.000 UP\n1.000 UL\nLT2\n3145 3685 M\n74 -61 V\n80 -22
      V\n-83 63 V\n-71 20 V\n.9169 g 3065 3738 N -71 20 89 -55 62 -18
      h\n1.000 UP\n1.000 UL\nLT2\n3065 3738 M\n80 -53 V\n71 -20 V\n-89 55
      V\n-62 18 V\n.9399 g 2981 3781 N -62 18 93 -46 53 -15 h\n1.000
      UP\n1.000 UL\nLT2\n2981 3781 M\n84 -43 V\n62 -18 V\n-93 46 V\n-53 15
      V\n.9593 g 2894 3815 N -53 15 98 -37 42 -12 h\n1.000 UP\n1.000
      UL\nLT2\n2894 3815 M\n87 -34 V\n53 -15 V\n-98 37 V\n-42 12 V\n.975 g
      2803 3838 N -42 12 101 -26 32 -9 h\n1.000 UP\n1.000 UL\nLT2\n2803 3838
      M\n91 -23 V\n42 -12 V\n-101 26 V\n-32 9 V\n.987 g 2711 3852 N -32 9 103
      -17 21 -6 h\n1.000 UP\n1.000 UL\nLT2\n2711 3852 M\n92 -14 V\n32 -9
      V\n-103 17 V\n-21 6 V\n.995 g 2616 3856 N -21 6 105 -7 11 -3 h\n1.000
      UP\n1.000 UL\nLT2\n2616 3856 M\n95 -4 V\n21 -6 V\n-105 7 V\n-11 3
      V\n.999 g 2521 3849 N -11 3 106 4 0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521
      3849 M\n95 7 V\n11 -3 V\n-106 -4 V\n.001 g 2627 1344 N 0 0 -113 -10 7
      -4 h\n1.000 UP\n1.000 UL\nLT2\n2627 1344 M\n-106 -14 V\n113 10 V\n-7 4
      V\n.005 g 2732 1367 N -7 4 -113 -21 15 -6 h\n1.000 UP\n1.000
      UL\nLT2\n2732 1367 M\n-105 -23 V\n7 -4 V\n113 21 V\n-15 6 V\n.013 g
      2835 1401 N -15 6 -110 -30 22 -10 h\n1.000 UP\n1.000 UL\nLT2\n2835 1401
      M\n-103 -34 V\n15 -6 V\n110 30 V\n-22 10 V\n.025 g 2936 1444 N -22 10
      -108 -40 29 -13 h\n1.000 UP\n1.000 UL\nLT2\n2936 1444 M\n-101 -43 V\n22
      -10 V\n108 40 V\n-29 13 V\n.0407 g 3034 1497 N -29 13 -105 -49 36 -17
      h\n1.000 UP\n1.000 UL\nLT2\n3034 1497 M\n-98 -53 V\n29 -13 V\n105 49
      V\n-36 17 V\n.0601 g 3127 1558 N -36 17 -100 -59 43 -19 h\n1.000
      UP\n1.000 UL\nLT2\n3127 1558 M\n-93 -61 V\n36 -17 V\n100 59 V\n-43 19
      V\n.0831 g 3216 1627 N -43 19 -94 -66 48 -22 h\n1.000 UP\n1.000
      UL\nLT2\n3216 1627 M\n-89 -69 V\n43 -19 V\n94 66 V\n-48 22 V\n.1095 g
      3299 1704 N -48 22 -89 -75 54 -24 h\n1.000 UP\n1.000 UL\nLT2\n3299 1704
      M\n-83 -77 V\n48 -22 V\n89 75 V\n-54 24 V\n.139 g 3375 1789 N -54 24
      -82 -82 60 -27 h\n1.000 UP\n1.000 UL\nLT2\n3375 1789 M\n-76 -85 V\n54
      -24 V\n82 82 V\n-60 27 V\n.1714 g 3445 1880 N -60 27 -75 -88 65 -30
      h\n1.000 UP\n1.000 UL\nLT2\n3445 1880 M\n-70 -91 V\n60 -27 V\n75 88
      V\n-65 30 V\n.2064 g 3507 1976 N -65 30 -66 -95 69 -31 h\n1.000
      UP\n1.000 UL\nLT2\n3507 1976 M\n-62 -96 V\n65 -30 V\n66 95 V\n-69 31
      V\n.2438 g 3562 2078 N -69 31 -58 -100 72 -33 h\n1.000 UP\n1.000
      UL\nLT2\n3562 2078 M\n-55 -102 V\n69 -31 V\n58 100 V\n-72 33 V\n.2833 g
      3608 2183 N -72 33 -50 -104 76 -34 h\n1.000 UP\n1.000 UL\nLT2\n3608
      2183 M\n-46 -105 V\n72 -33 V\n50 104 V\n-76 34 V\n.3245 g 3645 2292 N
      -76 34 -39 -108 78 -35 h\n1.000 UP\n1.000 UL\nLT2\n3645 2292 M\n-37
      -109 V\n76 -34 V\n39 108 V\n-78 35 V\n.3671 g 3673 2403 N -78 35 -31
      -110 81 -36 h\n1.000 UP\n1.000 UL\nLT2\n3673 2403 M\n-28 -111 V\n78 -35
      V\n31 110 V\n-81 36 V\n.4108 g 3692 2516 N -81 36 -20 -112 82 -37
      h\n1.000 UP\n1.000 UL\nLT2\n3692 2516 M\n-19 -113 V\n81 -36 V\n20 112
      V\n-82 37 V\n.4552 g 3702 2629 N -82 37 -10 -113 82 -37 h\n1.000
      UP\n1.000 UL\nLT2\n3702 2629 M\n-10 -113 V\n82 -37 V\n10 113 V\n-82 37
      V\n.5 g 3702 2742 N -82 37 0 -113 82 -37 h\n1.000 UP\n1.000
      UL\nLT2\n3702 2742 M\n0 -113 V\n82 -37 V\n0 113 V\n-82 37 V\n.5448 g
      3692 2854 N -82 37 10 -112 82 -37 h\n1.000 UP\n1.000 UL\nLT2\n3692 2854
      M\n10 -112 V\n82 -37 V\n-10 112 V\n-82 37 V\n.5892 g 3673 2964 N -82 37
      20 -111 81 -36 h\n1.000 UP\n1.000 UL\nLT2\n3673 2964 M\n19 -110 V\n82
      -37 V\n-20 111 V\n-81 36 V\n.6329 g 3645 3071 N -81 36 31 -107 78 -36
      h\n1.000 UP\n1.000 UL\nLT2\n3645 3071 M\n28 -107 V\n81 -36 V\n-31 107
      V\n-78 36 V\n.6755 g 3608 3173 N -78 36 39 -104 76 -34 h\n1.000
      UP\n1.000 UL\nLT2\n3608 3173 M\n37 -102 V\n78 -36 V\n-39 104 V\n-76 34
      V\n.7167 g 3562 3271 N -76 34 50 -100 72 -32 h\n1.000 UP\n1.000
      UL\nLT2\n3562 3271 M\n46 -98 V\n76 -34 V\n-50 100 V\n-72 32 V\n.7562 g
      3507 3364 N -72 32 58 -94 69 -31 h\n1.000 UP\n1.000 UL\nLT2\n3507 3364
      M\n55 -93 V\n72 -32 V\n-58 94 V\n-69 31 V\n.7936 g 3445 3450 N -69 31
      66 -88 65 -29 h\n1.000 UP\n1.000 UL\nLT2\n3445 3450 M\n62 -86 V\n69 -31
      V\n-66 88 V\n-65 29 V\n.8286 g 3375 3530 N -65 29 75 -82 60 -27
      h\n1.000 UP\n1.000 UL\nLT2\n3375 3530 M\n70 -80 V\n65 -29 V\n-75 82
      V\n-60 27 V\n.861 g 3299 3602 N -60 27 82 -74 54 -25 h\n1.000 UP\n1.000
      UL\nLT2\n3299 3602 M\n76 -72 V\n60 -27 V\n-82 74 V\n-54 25 V\n.8905 g
      3216 3665 N -54 25 89 -66 48 -22 h\n1.000 UP\n1.000 UL\nLT2\n3216 3665
      M\n83 -63 V\n54 -25 V\n-89 66 V\n-48 22 V\n.9169 g 3127 3720 N -48 22
      94 -58 43 -19 h\n1.000 UP\n1.000 UL\nLT2\n3127 3720 M\n89 -55 V\n48 -22
      V\n-94 58 V\n-43 19 V\n.9399 g 3034 3766 N -43 19 100 -49 36 -16
      h\n1.000 UP\n1.000 UL\nLT2\n3034 3766 M\n93 -46 V\n43 -19 V\n-100 49
      V\n-36 16 V\n.9593 g 2936 3803 N -36 16 105 -40 29 -13 h\n1.000
      UP\n1.000 UL\nLT2\n2936 3803 M\n98 -37 V\n36 -16 V\n-105 40 V\n-29 13
      V\n.975 g 2835 3829 N -29 13 108 -29 22 -10 h\n1.000 UP\n1.000
      UL\nLT2\n2835 3829 M\n101 -26 V\n29 -13 V\n-108 29 V\n-22 10 V\n.987 g
      2732 3846 N -22 10 110 -20 15 -7 h\n1.000 UP\n1.000 UL\nLT2\n2732 3846
      M\n103 -17 V\n22 -10 V\n-110 20 V\n-15 7 V\n.995 g 2627 3853 N -15 7
      113 -10 7 -4 h\n1.000 UP\n1.000 UL\nLT2\n2627 3853 M\n105 -7 V\n15 -7
      V\n-113 10 V\n-7 4 V\n.999 g 2521 3849 N -7 4 113 0 0 0 h\n1.000
      UP\n1.000 UL\nLT2\n2521 3849 M\n106 4 V\n7 -4 V\n-113 0 V\n.001 g 2634
      1340 N 0 0 -117 -7 4 -3 h\n1.000 UP\n1.000 UL\nLT2\n2634 1340 M\n-113
      -10 V\n117 7 V\n-4 3 V\n.005 g 2747 1361 N -4 3 -116 -17 7 -7 h\n1.000
      UP\n1.000 UL\nLT2\n2747 1361 M\n-113 -21 V\n4 -3 V\n116 17 V\n-7 7
      V\n.013 g 2857 1391 N -7 7 -115 -27 12 -10 h\n1.000 UP\n1.000
      UL\nLT2\n2857 1391 M\n-110 -30 V\n7 -7 V\n115 27 V\n-12 10 V\n.025 g
      2965 1431 N -12 10 -111 -36 15 -14 h\n1.000 UP\n1.000 UL\nLT2\n2965
      1431 M\n-108 -40 V\n12 -10 V\n111 36 V\n-15 14 V\n.0407 g 3070 1480 N
      -15 14 -108 -46 18 -17 h\n1.000 UP\n1.000 UL\nLT2\n3070 1480 M\n-105
      -49 V\n15 -14 V\n108 46 V\n-18 17 V\n.0601 g 3170 1539 N -18 17 -103
      -55 21 -21 h\n1.000 UP\n1.000 UL\nLT2\n3170 1539 M\n-100 -59 V\n18 -17
      V\n103 55 V\n-21 21 V\n.0831 g 3264 1605 N -21 21 -98 -64 25 -23
      h\n1.000 UP\n1.000 UL\nLT2\n3264 1605 M\n-94 -66 V\n21 -21 V\n98 64
      V\n-25 23 V\n.1095 g 3353 1680 N -25 23 -92 -72 28 -26 h\n1.000
      UP\n1.000 UL\nLT2\n3353 1680 M\n-89 -75 V\n25 -23 V\n92 72 V\n-28 26
      V\n.139 g 3435 1762 N -28 26 -84 -79 30 -29 h\n1.000 UP\n1.000
      UL\nLT2\n3435 1762 M\n-82 -82 V\n28 -26 V\n84 79 V\n-30 29 V\n.1714 g
      3510 1850 N -30 29 -77 -87 32 -30 h\n1.000 UP\n1.000 UL\nLT2\n3510 1850
      M\n-75 -88 V\n30 -29 V\n77 87 V\n-32 30 V\n.2064 g 3576 1945 N -32 30
      -69 -92 35 -33 h\n1.000 UP\n1.000 UL\nLT2\n3576 1945 M\n-66 -95 V\n32
      -30 V\n69 92 V\n-35 33 V\n.2438 g 3634 2045 N -35 33 -60 -98 37 -35
      h\n1.000 UP\n1.000 UL\nLT2\n3634 2045 M\n-58 -100 V\n35 -33 V\n60 98
      V\n-37 35 V\n.2833 g 3684 2149 N -37 35 -51 -103 38 -36 h\n1.000
      UP\n1.000 UL\nLT2\n3684 2149 M\n-50 -104 V\n37 -35 V\n51 103 V\n-38 36
      V\n.3245 g 3723 2257 N -38 36 -41 -106 40 -38 h\n1.000 UP\n1.000
      UL\nLT2\n3723 2257 M\n-39 -108 V\n38 -36 V\n41 106 V\n-40 38 V\n.3671 g
      3754 2367 N -40 38 -32 -110 41 -38 h\n1.000 UP\n1.000 UL\nLT2\n3754
      2367 M\n-31 -110 V\n40 -38 V\n32 110 V\n-41 38 V\n.4108 g 3774 2479 N
      -41 38 -20 -111 41 -39 h\n1.000 UP\n1.000 UL\nLT2\n3774 2479 M\n-20
      -112 V\n41 -38 V\n20 111 V\n-41 39 V\n.4552 g 3784 2592 N -41 39 -11
      -113 42 -39 h\n1.000 UP\n1.000 UL\nLT2\n3784 2592 M\n-10 -113 V\n41 -39
      V\n11 113 V\n-42 39 V\n.5 g 3784 2705 N -42 39 0 -113 42 -39 h\n1.000
      UP\n1.000 UL\nLT2\n3784 2705 M\n0 -113 V\n42 -39 V\n0 113 V\n-42 39
      V\n.5448 g 3774 2817 N -42 39 11 -112 41 -39 h\n1.000 UP\n1.000
      UL\nLT2\n3774 2817 M\n10 -112 V\n42 -39 V\n-11 112 V\n-41 39 V\n.5892 g
      3754 2928 N -41 39 20 -111 41 -39 h\n1.000 UP\n1.000 UL\nLT2\n3754 2928
      M\n20 -111 V\n41 -39 V\n-20 111 V\n-41 39 V\n.6329 g 3723 3035 N -41 39
      32 -109 40 -37 h\n1.000 UP\n1.000 UL\nLT2\n3723 3035 M\n31 -107 V\n41
      -39 V\n-32 109 V\n-40 37 V\n.6755 g 3684 3139 N -40 37 41 -105 38 -36
      h\n1.000 UP\n1.000 UL\nLT2\n3684 3139 M\n39 -104 V\n40 -37 V\n-41 105
      V\n-38 36 V\n.7167 g 3634 3239 N -38 36 51 -101 37 -35 h\n1.000
      UP\n1.000 UL\nLT2\n3634 3239 M\n50 -100 V\n38 -36 V\n-51 101 V\n-37 35
      V\n.7562 g 3576 3333 N -37 35 60 -96 35 -33 h\n1.000 UP\n1.000
      UL\nLT2\n3576 3333 M\n58 -94 V\n37 -35 V\n-60 96 V\n-35 33 V\n.7936 g
      3510 3421 N -35 33 69 -90 32 -31 h\n1.000 UP\n1.000 UL\nLT2\n3510 3421
      M\n66 -88 V\n35 -33 V\n-69 90 V\n-32 31 V\n.8286 g 3435 3503 N -32 31
      77 -84 30 -29 h\n1.000 UP\n1.000 UL\nLT2\n3435 3503 M\n75 -82 V\n32 -31
      V\n-77 84 V\n-30 29 V\n.861 g 3353 3577 N -30 29 84 -77 28 -26 h\n1.000
      UP\n1.000 UL\nLT2\n3353 3577 M\n82 -74 V\n30 -29 V\n-84 77 V\n-28 26
      V\n.8905 g 3264 3643 N -28 26 92 -69 25 -23 h\n1.000 UP\n1.000
      UL\nLT2\n3264 3643 M\n89 -66 V\n28 -26 V\n-92 69 V\n-25 23 V\n.9169 g
      3170 3701 N -25 23 98 -61 21 -20 h\n1.000 UP\n1.000 UL\nLT2\n3170 3701
      M\n94 -58 V\n25 -23 V\n-98 61 V\n-21 20 V\n.9399 g 3070 3750 N -21 20
      103 -52 18 -17 h\n1.000 UP\n1.000 UL\nLT2\n3070 3750 M\n100 -49 V\n21
      -20 V\n-103 52 V\n-18 17 V\n.9593 g 2965 3790 N -18 17 108 -43 15 -14
      h\n1.000 UP\n1.000 UL\nLT2\n2965 3790 M\n105 -40 V\n18 -17 V\n-108 43
      V\n-15 14 V\n.975 g 2857 3819 N -15 14 111 -33 12 -10 h\n1.000
      UP\n1.000 UL\nLT2\n2857 3819 M\n108 -29 V\n15 -14 V\n-111 33 V\n-12 10
      V\n.987 g 2747 3839 N -12 10 115 -23 7 -7 h\n1.000 UP\n1.000
      UL\nLT2\n2747 3839 M\n110 -20 V\n12 -10 V\n-115 23 V\n-7 7 V\n.995 g
      2634 3849 N -7 7 116 -14 4 -3 h\n1.000 UP\n1.000 UL\nLT2\n2634 3849
      M\n113 -10 V\n7 -7 V\n-116 14 V\n-4 3 V\n.999 g 2521 3849 N -4 3 117 -3
      0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n113 0 V\n4 -3 V\n-117 3
      V\n.001 g 2638 1337 N 0 0 -117 -3 0 -4 h\n1.000 UP\n1.000 UL\nLT2\n2638
      1337 M\n-117 -7 V\n117 3 V\n0 4 V\n.005 g 2754 1354 N 0 4 -116 -14 0 -7
      h\n1.000 UP\n1.000 UL\nLT2\n2754 1354 M\n-116 -17 V\n0 -4 V\n116 14
      V\n0 7 V\n.013 g 2869 1381 N 0 7 -115 -23 0 -11 h\n1.000 UP\n1.000
      UL\nLT2\n2869 1381 M\n-115 -27 V\n0 -7 V\n115 23 V\n0 11 V\n.025 g 2980
      1417 N 0 11 -111 -33 0 -14 h\n1.000 UP\n1.000 UL\nLT2\n2980 1417
      M\n-111 -36 V\n0 -11 V\n111 33 V\n0 14 V\n.0407 g 3088 1463 N 0 14 -108
      -43 0 -17 h\n1.000 UP\n1.000 UL\nLT2\n3088 1463 M\n-108 -46 V\n0 -14
      V\n108 43 V\n0 17 V\n.0601 g 3191 1518 N 0 17 -103 -52 0 -20 h\n1.000
      UP\n1.000 UL\nLT2\n3191 1518 M\n-103 -55 V\n0 -17 V\n103 52 V\n0 20
      V\n.0831 g 3289 1582 N 0 20 -98 -61 0 -23 h\n1.000 UP\n1.000
      UL\nLT2\n3289 1582 M\n-98 -64 V\n0 -20 V\n98 61 V\n0 23 V\n.1095 g 3381
      1654 N 0 23 -92 -69 0 -26 h\n1.000 UP\n1.000 UL\nLT2\n3381 1654 M\n-92
      -72 V\n0 -23 V\n92 69 V\n0 26 V\n.139 g 3465 1733 N 0 26 -84 -77 0 -28
      h\n1.000 UP\n1.000 UL\nLT2\n3465 1733 M\n-84 -79 V\n0 -26 V\n84 77 V\n0
      28 V\n.1714 g 3542 1820 N 0 28 -77 -84 0 -31 h\n1.000 UP\n1.000
      UL\nLT2\n3542 1820 M\n-77 -87 V\n0 -28 V\n77 84 V\n0 31 V\n.2064 g 3611
      1912 N 0 31 -69 -90 0 -33 h\n1.000 UP\n1.000 UL\nLT2\n3611 1912 M\n-69
      -92 V\n0 -31 V\n69 90 V\n0 33 V\n.2438 g 3671 2010 N 0 33 -60 -96 0 -35
      h\n1.000 UP\n1.000 UL\nLT2\n3671 2010 M\n-60 -98 V\n0 -33 V\n60 96 V\n0
      35 V\n.2833 g 3722 2113 N 0 35 -51 -101 0 -37 h\n1.000 UP\n1.000
      UL\nLT2\n3722 2113 M\n-51 -103 V\n0 -35 V\n51 101 V\n0 37 V\n.3245 g
      3763 2219 N 0 37 -41 -105 0 -38 h\n1.000 UP\n1.000 UL\nLT2\n3763 2219
      M\n-41 -106 V\n0 -37 V\n41 105 V\n0 38 V\n.3671 g 3795 2329 N 0 38 -32
      -109 0 -39 h\n1.000 UP\n1.000 UL\nLT2\n3795 2329 M\n-32 -110 V\n0 -38
      V\n32 109 V\n0 39 V\n.4108 g 3815 2440 N 0 39 -20 -111 0 -39 h\n1.000
      UP\n1.000 UL\nLT2\n3815 2440 M\n-20 -111 V\n0 -39 V\n20 111 V\n0 39
      V\n.4552 g 3826 2553 N 0 39 -11 -112 0 -40 h\n1.000 UP\n1.000
      UL\nLT2\n3826 2553 M\n-11 -113 V\n0 -39 V\n11 112 V\n0 40 V\n.5 g 3826
      2666 N 0 40 0 -113 0 -40 h\n1.000 UP\n1.000 UL\nLT2\n3826 2666 M\n0
      -113 V\n0 -40 V\n0 113 V\n0 40 V\n.5448 g 3815 2778 N 0 40 11 -113 0
      -39 h\n1.000 UP\n1.000 UL\nLT2\n3815 2778 M\n11 -112 V\n0 -40 V\n-11
      113 V\n0 39 V\n.5892 g 3795 2889 N 0 39 20 -111 0 -39 h\n1.000
      UP\n1.000 UL\nLT2\n3795 2889 M\n20 -111 V\n0 -39 V\n-20 111 V\n0 39
      V\n.6329 g 3763 2998 N 0 39 32 -110 0 -38 h\n1.000 UP\n1.000
      UL\nLT2\n3763 2998 M\n32 -109 V\n0 -39 V\n-32 110 V\n0 38 V\n.6755 g
      3722 3103 N 0 38 41 -106 0 -37 h\n1.000 UP\n1.000 UL\nLT2\n3722 3103
      M\n41 -105 V\n0 -38 V\n-41 106 V\n0 37 V\n.7167 g 3671 3204 N 0 37 51
      -103 0 -35 h\n1.000 UP\n1.000 UL\nLT2\n3671 3204 M\n51 -101 V\n0 -37
      V\n-51 103 V\n0 35 V\n.7562 g 3611 3300 N 0 35 60 -98 0 -33 h\n1.000
      UP\n1.000 UL\nLT2\n3611 3300 M\n60 -96 V\n0 -35 V\n-60 98 V\n0 33
      V\n.7936 g 3542 3390 N 0 33 69 -92 0 -31 h\n1.000 UP\n1.000
      UL\nLT2\n3542 3390 M\n69 -90 V\n0 -33 V\n-69 92 V\n0 31 V\n.8286 g 3465
      3474 N 0 31 77 -87 0 -28 h\n1.000 UP\n1.000 UL\nLT2\n3465 3474 M\n77
      -84 V\n0 -31 V\n-77 87 V\n0 28 V\n.861 g 3381 3551 N 0 28 84 -79 0 -26
      h\n1.000 UP\n1.000 UL\nLT2\n3381 3551 M\n84 -77 V\n0 -28 V\n-84 79 V\n0
      26 V\n.8905 g 3289 3620 N 0 26 92 -72 0 -23 h\n1.000 UP\n1.000
      UL\nLT2\n3289 3620 M\n92 -69 V\n0 -26 V\n-92 72 V\n0 23 V\n.9169 g 3191
      3681 N 0 23 98 -64 0 -20 h\n1.000 UP\n1.000 UL\nLT2\n3191 3681 M\n98
      -61 V\n0 -23 V\n-98 64 V\n0 20 V\n.9399 g 3088 3733 N 0 20 103 -55 0
      -17 h\n1.000 UP\n1.000 UL\nLT2\n3088 3733 M\n103 -52 V\n0 -20 V\n-103
      55 V\n0 17 V\n.9593 g 2980 3776 N 0 17 108 -46 0 -14 h\n1.000 UP\n1.000
      UL\nLT2\n2980 3776 M\n108 -43 V\n0 -17 V\n-108 46 V\n0 14 V\n.975 g
      2869 3809 N 0 14 111 -36 0 -11 h\n1.000 UP\n1.000 UL\nLT2\n2869 3809
      M\n111 -33 V\n0 -14 V\n-111 36 V\n0 11 V\n.987 g 2754 3832 N 0 11 115
      -27 0 -7 h\n1.000 UP\n1.000 UL\nLT2\n2754 3832 M\n115 -23 V\n0 -11
      V\n-115 27 V\n0 7 V\n.995 g 2638 3846 N 0 7 116 -17 0 -4 h\n1.000
      UP\n1.000 UL\nLT2\n2638 3846 M\n116 -14 V\n0 -7 V\n-116 17 V\n0 4
      V\n.999 g 2521 3849 N 0 4 117 -7 0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521
      3849 M\n117 -3 V\n0 -4 V\n-117 7 V\n.001 g 2638 1333 N 0 0 -113 0 -4 -3
      h\n1.000 UP\n1.000 UL\nLT2\n2638 1333 M\n-117 -3 V\n113 0 V\n4 3
      V\n.005 g 2754 1347 N 4 3 -113 -10 -7 -7 h\n1.000 UP\n1.000
      UL\nLT2\n2754 1347 M\n-116 -14 V\n-4 -3 V\n113 10 V\n7 7 V\n.013 g 2869
      1370 N 7 7 -110 -20 -12 -10 h\n1.000 UP\n1.000 UL\nLT2\n2869 1370
      M\n-115 -23 V\n-7 -7 V\n110 20 V\n12 10 V\n.025 g 2980 1403 N 12 10
      -108 -29 -15 -14 h\n1.000 UP\n1.000 UL\nLT2\n2980 1403 M\n-111 -33
      V\n-12 -10 V\n108 29 V\n15 14 V\n.0407 g 3088 1446 N 15 14 -105 -40 -18
      -17 h\n1.000 UP\n1.000 UL\nLT2\n3088 1446 M\n-108 -43 V\n-15 -14 V\n105
      40 V\n18 17 V\n.0601 g 3191 1498 N 18 17 -100 -49 -21 -20 h\n1.000
      UP\n1.000 UL\nLT2\n3191 1498 M\n-103 -52 V\n-18 -17 V\n100 49 V\n21 20
      V\n.0831 g 3289 1559 N 21 20 -94 -58 -25 -23 h\n1.000 UP\n1.000
      UL\nLT2\n3289 1559 M\n-98 -61 V\n-21 -20 V\n94 58 V\n25 23 V\n.1095 g
      3381 1628 N 25 23 -89 -66 -28 -26 h\n1.000 UP\n1.000 UL\nLT2\n3381 1628
      M\n-92 -69 V\n-25 -23 V\n89 66 V\n28 26 V\n.139 g 3465 1705 N 28 26 -82
      -74 -30 -29 h\n1.000 UP\n1.000 UL\nLT2\n3465 1705 M\n-84 -77 V\n-28 -26
      V\n82 74 V\n30 29 V\n.1714 g 3542 1789 N 30 29 -75 -82 -32 -31 h\n1.000
      UP\n1.000 UL\nLT2\n3542 1789 M\n-77 -84 V\n-30 -29 V\n75 82 V\n32 31
      V\n.2064 g 3611 1879 N 32 31 -66 -88 -35 -33 h\n1.000 UP\n1.000
      UL\nLT2\n3611 1879 M\n-69 -90 V\n-32 -31 V\n66 88 V\n35 33 V\n.2438 g
      3671 1975 N 35 33 -58 -94 -37 -35 h\n1.000 UP\n1.000 UL\nLT2\n3671 1975
      M\n-60 -96 V\n-35 -33 V\n58 94 V\n37 35 V\n.2833 g 3722 2076 N 37 35
      -50 -100 -38 -36 h\n1.000 UP\n1.000 UL\nLT2\n3722 2076 M\n-51 -101
      V\n-37 -35 V\n50 100 V\n38 36 V\n.3245 g 3763 2181 N 38 36 -39 -104 -40
      -37 h\n1.000 UP\n1.000 UL\nLT2\n3763 2181 M\n-41 -105 V\n-38 -36 V\n39
      104 V\n40 37 V\n.3671 g 3795 2290 N 40 37 -31 -107 -41 -39 h\n1.000
      UP\n1.000 UL\nLT2\n3795 2290 M\n-32 -109 V\n-40 -37 V\n31 107 V\n41 39
      V\n.4108 g 3815 2401 N 41 39 -20 -111 -41 -39 h\n1.000 UP\n1.000
      UL\nLT2\n3815 2401 M\n-20 -111 V\n-41 -39 V\n20 111 V\n41 39 V\n.4552 g
      3826 2513 N 41 39 -10 -112 -42 -39 h\n1.000 UP\n1.000 UL\nLT2\n3826
      2513 M\n-11 -112 V\n-41 -39 V\n10 112 V\n42 39 V\n.5 g 3826 2626 N 42
      39 0 -113 -42 -39 h\n1.000 UP\n1.000 UL\nLT2\n3826 2626 M\n0 -113
      V\n-42 -39 V\n0 113 V\n42 39 V\n.5448 g 3815 2739 N 42 39 10 -113 -41
      -39 h\n1.000 UP\n1.000 UL\nLT2\n3815 2739 M\n11 -113 V\n-42 -39 V\n-10
      113 V\n41 39 V\n.5892 g 3795 2850 N 41 39 20 -112 -41 -38 h\n1.000
      UP\n1.000 UL\nLT2\n3795 2850 M\n20 -111 V\n-41 -39 V\n-20 112 V\n41 38
      V\n.6329 g 3763 2960 N 41 38 31 -110 -40 -38 h\n1.000 UP\n1.000
      UL\nLT2\n3763 2960 M\n32 -110 V\n-41 -38 V\n-31 110 V\n40 38 V\n.6755 g
      3722 3066 N 40 38 39 -108 -38 -36 h\n1.000 UP\n1.000 UL\nLT2\n3722 3066
      M\n41 -106 V\n-40 -38 V\n-39 108 V\n38 36 V\n.7167 g 3671 3169 N 38 36
      50 -104 -37 -35 h\n1.000 UP\n1.000 UL\nLT2\n3671 3169 M\n51 -103 V\n-38
      -36 V\n-50 104 V\n37 35 V\n.7562 g 3611 3267 N 37 35 58 -100 -35 -33
      h\n1.000 UP\n1.000 UL\nLT2\n3611 3267 M\n60 -98 V\n-37 -35 V\n-58 100
      V\n35 33 V\n.7936 g 3542 3359 N 35 33 66 -95 -32 -30 h\n1.000 UP\n1.000
      UL\nLT2\n3542 3359 M\n69 -92 V\n-35 -33 V\n-66 95 V\n32 30 V\n.8286 g
      3465 3446 N 32 30 75 -88 -30 -29 h\n1.000 UP\n1.000 UL\nLT2\n3465 3446
      M\n77 -87 V\n-32 -30 V\n-75 88 V\n30 29 V\n.861 g 3381 3525 N 30 29 82
      -82 -28 -26 h\n1.000 UP\n1.000 UL\nLT2\n3381 3525 M\n84 -79 V\n-30 -29
      V\n-82 82 V\n28 26 V\n.8905 g 3289 3597 N 28 26 89 -75 -25 -23 h\n1.000
      UP\n1.000 UL\nLT2\n3289 3597 M\n92 -72 V\n-28 -26 V\n-89 75 V\n25 23
      V\n.9169 g 3191 3661 N 25 23 94 -66 -21 -21 h\n1.000 UP\n1.000
      UL\nLT2\n3191 3661 M\n98 -64 V\n-25 -23 V\n-94 66 V\n21 21 V\n.9399 g
      3088 3716 N 21 21 100 -59 -18 -17 h\n1.000 UP\n1.000 UL\nLT2\n3088 3716
      M\n103 -55 V\n-21 -21 V\n-100 59 V\n18 17 V\n.9593 g 2980 3762 N 18 17
      105 -49 -15 -14 h\n1.000 UP\n1.000 UL\nLT2\n2980 3762 M\n108 -46 V\n-18
      -17 V\n-105 49 V\n15 14 V\n.975 g 2869 3798 N 15 14 108 -40 -12 -10
      h\n1.000 UP\n1.000 UL\nLT2\n2869 3798 M\n111 -36 V\n-15 -14 V\n-108 40
      V\n12 10 V\n.987 g 2754 3825 N 12 10 110 -30 -7 -7 h\n1.000 UP\n1.000
      UL\nLT2\n2754 3825 M\n115 -27 V\n-12 -10 V\n-110 30 V\n7 7 V\n.995 g
      2638 3842 N 7 7 113 -21 -4 -3 h\n1.000 UP\n1.000 UL\nLT2\n2638 3842
      M\n116 -17 V\n-7 -7 V\n-113 21 V\n4 3 V\n.999 g 2521 3849 N 4 3 113 -10
      0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n117 -7 V\n-4 -3 V\n-113 10
      V\n.001 g 2634 1330 N 0 0 -106 4 -7 -4 h\n1.000 UP\n1.000 UL\nLT2\n2634
      1330 M\n-113 0 V\n106 -4 V\n7 4 V\n.005 g 2747 1340 N 7 4 -105 -7 -15
      -7 h\n1.000 UP\n1.000 UL\nLT2\n2747 1340 M\n-113 -10 V\n-7 -4 V\n105 7
      V\n15 7 V\n.013 g 2857 1360 N 15 7 -103 -17 -22 -10 h\n1.000 UP\n1.000
      UL\nLT2\n2857 1360 M\n-110 -20 V\n-15 -7 V\n103 17 V\n22 10 V\n.025 g
      2965 1389 N 22 10 -101 -26 -29 -13 h\n1.000 UP\n1.000 UL\nLT2\n2965
      1389 M\n-108 -29 V\n-22 -10 V\n101 26 V\n29 13 V\n.0407 g 3070 1429 N
      29 13 -98 -37 -36 -16 h\n1.000 UP\n1.000 UL\nLT2\n3070 1429 M\n-105 -40
      V\n-29 -13 V\n98 37 V\n36 16 V\n.0601 g 3170 1478 N 36 16 -93 -46 -43
      -19 h\n1.000 UP\n1.000 UL\nLT2\n3170 1478 M\n-100 -49 V\n-36 -16 V\n93
      46 V\n43 19 V\n.0831 g 3264 1536 N 43 19 -89 -55 -48 -22 h\n1.000
      UP\n1.000 UL\nLT2\n3264 1536 M\n-94 -58 V\n-43 -19 V\n89 55 V\n48 22
      V\n.1095 g 3353 1602 N 48 22 -83 -63 -54 -25 h\n1.000 UP\n1.000
      UL\nLT2\n3353 1602 M\n-89 -66 V\n-48 -22 V\n83 63 V\n54 25 V\n.139 g
      3435 1676 N 54 25 -76 -72 -60 -27 h\n1.000 UP\n1.000 UL\nLT2\n3435 1676
      M\n-82 -74 V\n-54 -25 V\n76 72 V\n60 27 V\n.1714 g 3510 1758 N 60 27
      -70 -80 -65 -29 h\n1.000 UP\n1.000 UL\nLT2\n3510 1758 M\n-75 -82 V\n-60
      -27 V\n70 80 V\n65 29 V\n.2064 g 3576 1846 N 65 29 -62 -86 -69 -31
      h\n1.000 UP\n1.000 UL\nLT2\n3576 1846 M\n-66 -88 V\n-65 -29 V\n62 86
      V\n69 31 V\n.2438 g 3634 1940 N 69 31 -55 -93 -72 -32 h\n1.000
      UP\n1.000 UL\nLT2\n3634 1940 M\n-58 -94 V\n-69 -31 V\n55 93 V\n72 32
      V\n.2833 g 3684 2040 N 72 32 -46 -98 -76 -34 h\n1.000 UP\n1.000
      UL\nLT2\n3684 2040 M\n-50 -100 V\n-72 -32 V\n46 98 V\n76 34 V\n.3245 g
      3723 2144 N 76 34 -37 -102 -78 -36 h\n1.000 UP\n1.000 UL\nLT2\n3723
      2144 M\n-39 -104 V\n-76 -34 V\n37 102 V\n78 36 V\n.3671 g 3754 2251 N
      78 36 -28 -107 -81 -36 h\n1.000 UP\n1.000 UL\nLT2\n3754 2251 M\n-31
      -107 V\n-78 -36 V\n28 107 V\n81 36 V\n.4108 g 3774 2362 N 81 36 -19
      -110 -82 -37 h\n1.000 UP\n1.000 UL\nLT2\n3774 2362 M\n-20 -111 V\n-81
      -36 V\n19 110 V\n82 37 V\n.4552 g 3784 2474 N 82 37 -10 -112 -82 -37
      h\n1.000 UP\n1.000 UL\nLT2\n3784 2474 M\n-10 -112 V\n-82 -37 V\n10 112
      V\n82 37 V\n.5 g 3784 2587 N 82 37 0 -113 -82 -37 h\n1.000 UP\n1.000
      UL\nLT2\n3784 2587 M\n0 -113 V\n-82 -37 V\n0 113 V\n82 37 V\n.5448 g
      3774 2700 N 82 37 10 -113 -82 -37 h\n1.000 UP\n1.000 UL\nLT2\n3774 2700
      M\n10 -113 V\n-82 -37 V\n-10 113 V\n82 37 V\n.5892 g 3754 2812 N 82 37
      19 -113 -81 -36 h\n1.000 UP\n1.000 UL\nLT2\n3754 2812 M\n20 -112 V\n-82
      -37 V\n-19 113 V\n81 36 V\n.6329 g 3723 2922 N 81 36 28 -111 -78 -35
      h\n1.000 UP\n1.000 UL\nLT2\n3723 2922 M\n31 -110 V\n-81 -36 V\n-28 111
      V\n78 35 V\n.6755 g 3684 3030 N 78 35 37 -109 -76 -34 h\n1.000
      UP\n1.000 UL\nLT2\n3684 3030 M\n39 -108 V\n-78 -35 V\n-37 109 V\n76 34
      V\n.7167 g 3634 3134 N 76 34 46 -105 -72 -33 h\n1.000 UP\n1.000
      UL\nLT2\n3634 3134 M\n50 -104 V\n-76 -34 V\n-46 105 V\n72 33 V\n.7562 g
      3576 3234 N 72 33 55 -102 -69 -31 h\n1.000 UP\n1.000 UL\nLT2\n3576 3234
      M\n58 -100 V\n-72 -33 V\n-55 102 V\n69 31 V\n.7936 g 3510 3329 N 69 31
      62 -96 -65 -30 h\n1.000 UP\n1.000 UL\nLT2\n3510 3329 M\n66 -95 V\n-69
      -31 V\n-62 96 V\n65 30 V\n.8286 g 3435 3417 N 65 30 70 -91 -60 -27
      h\n1.000 UP\n1.000 UL\nLT2\n3435 3417 M\n75 -88 V\n-65 -30 V\n-70 91
      V\n60 27 V\n.861 g 3353 3499 N 60 27 76 -85 -54 -24 h\n1.000 UP\n1.000
      UL\nLT2\n3353 3499 M\n82 -82 V\n-60 -27 V\n-76 85 V\n54 24 V\n.8905 g
      3264 3574 N 54 24 83 -77 -48 -22 h\n1.000 UP\n1.000 UL\nLT2\n3264 3574
      M\n89 -75 V\n-54 -24 V\n-83 77 V\n48 22 V\n.9169 g 3170 3640 N 48 22 89
      -69 -43 -19 h\n1.000 UP\n1.000 UL\nLT2\n3170 3640 M\n94 -66 V\n-48 -22
      V\n-89 69 V\n43 19 V\n.9399 g 3070 3699 N 43 19 93 -61 -36 -17 h\n1.000
      UP\n1.000 UL\nLT2\n3070 3699 M\n100 -59 V\n-43 -19 V\n-93 61 V\n36 17
      V\n.9593 g 2965 3748 N 36 17 98 -53 -29 -13 h\n1.000 UP\n1.000
      UL\nLT2\n2965 3748 M\n105 -49 V\n-36 -17 V\n-98 53 V\n29 13 V\n.975 g
      2857 3788 N 29 13 101 -43 -22 -10 h\n1.000 UP\n1.000 UL\nLT2\n2857 3788
      M\n108 -40 V\n-29 -13 V\n-101 43 V\n22 10 V\n.987 g 2747 3818 N 22 10
      103 -34 -15 -6 h\n1.000 UP\n1.000 UL\nLT2\n2747 3818 M\n110 -30 V\n-22
      -10 V\n-103 34 V\n15 6 V\n.995 g 2634 3839 N 15 6 105 -23 -7 -4
      h\n1.000 UP\n1.000 UL\nLT2\n2634 3839 M\n113 -21 V\n-15 -6 V\n-105 23
      V\n7 4 V\n.999 g 2521 3849 N 7 4 106 -14 0 0 h\n1.000 UP\n1.000
      UL\nLT2\n2521 3849 M\n113 -10 V\n-7 -4 V\n-106 14 V\n.001 g 2627 1326 N
      0 0 -95 7 -11 -3 h\n1.000 UP\n1.000 UL\nLT2\n2627 1326 M\n-106 4 V\n95
      -7 V\n11 3 V\n.005 g 2732 1333 N 11 3 -95 -4 -21 -6 h\n1.000 UP\n1.000
      UL\nLT2\n2732 1333 M\n-105 -7 V\n-11 -3 V\n95 4 V\n21 6 V\n.013 g 2835
      1350 N 21 6 -92 -14 -32 -9 h\n1.000 UP\n1.000 UL\nLT2\n2835 1350
      M\n-103 -17 V\n-21 -6 V\n92 14 V\n32 9 V\n.025 g 2936 1376 N 32 9 -91
      -23 -42 -12 h\n1.000 UP\n1.000 UL\nLT2\n2936 1376 M\n-101 -26 V\n-32 -9
      V\n91 23 V\n42 12 V\n.0407 g 3034 1413 N 42 12 -87 -34 -53 -15 h\n1.000
      UP\n1.000 UL\nLT2\n3034 1413 M\n-98 -37 V\n-42 -12 V\n87 34 V\n53 15
      V\n.0601 g 3127 1459 N 53 15 -84 -43 -62 -18 h\n1.000 UP\n1.000
      UL\nLT2\n3127 1459 M\n-93 -46 V\n-53 -15 V\n84 43 V\n62 18 V\n.0831 g
      3216 1514 N 62 18 -80 -53 -71 -20 h\n1.000 UP\n1.000 UL\nLT2\n3216 1514
      M\n-89 -55 V\n-62 -18 V\n80 53 V\n71 20 V\n.1095 g 3299 1577 N 71 20
      -74 -61 -80 -22 h\n1.000 UP\n1.000 UL\nLT2\n3299 1577 M\n-83 -63 V\n-71
      -20 V\n74 61 V\n80 22 V\n.139 g 3375 1649 N 80 22 -69 -70 -87 -24
      h\n1.000 UP\n1.000 UL\nLT2\n3375 1649 M\n-76 -72 V\n-80 -22 V\n69 70
      V\n87 24 V\n.1714 g 3445 1729 N 87 24 -63 -77 -94 -27 h\n1.000
      UP\n1.000 UL\nLT2\n3445 1729 M\n-70 -80 V\n-87 -24 V\n63 77 V\n94 27
      V\n.2064 g 3507 1815 N 94 27 -56 -84 -100 -29 h\n1.000 UP\n1.000
      UL\nLT2\n3507 1815 M\n-62 -86 V\n-94 -27 V\n56 84 V\n100 29 V\n.2438 g
      3562 1908 N 100 29 -48 -91 -107 -31 h\n1.000 UP\n1.000 UL\nLT2\n3562
      1908 M\n-55 -93 V\n-100 -29 V\n48 91 V\n107 31 V\n.2833 g 3608 2006 N
      107 31 -42 -97 -111 -32 h\n1.000 UP\n1.000 UL\nLT2\n3608 2006 M\n-46
      -98 V\n-107 -31 V\n42 97 V\n111 32 V\n.3245 g 3645 2108 N 111 32 -33
      -102 -115 -32 h\n1.000 UP\n1.000 UL\nLT2\n3645 2108 M\n-37 -102 V\n-111
      -32 V\n33 102 V\n115 32 V\n.3671 g 3673 2215 N 115 32 -26 -106 -117 -33
      h\n1.000 UP\n1.000 UL\nLT2\n3673 2215 M\n-28 -107 V\n-115 -32 V\n26 106
      V\n117 33 V\n.4108 g 3692 2325 N 117 33 -17 -109 -119 -34 h\n1.000
      UP\n1.000 UL\nLT2\n3692 2325 M\n-19 -110 V\n-117 -33 V\n17 109 V\n119
      34 V\n.4552 g 3702 2437 N 119 34 -8 -111 -121 -35 h\n1.000 UP\n1.000
      UL\nLT2\n3702 2437 M\n-10 -112 V\n-119 -34 V\n8 111 V\n121 35 V\n.5 g
      3702 2550 N 121 35 0 -113 -121 -35 h\n1.000 UP\n1.000 UL\nLT2\n3702
      2550 M\n0 -113 V\n-121 -35 V\n0 113 V\n121 35 V\n.5448 g 3692 2663 N
      121 35 8 -114 -119 -34 h\n1.000 UP\n1.000 UL\nLT2\n3692 2663 M\n10 -113
      V\n-121 -35 V\n-8 114 V\n119 34 V\n.5892 g 3673 2776 N 119 34 17 -113
      -117 -34 h\n1.000 UP\n1.000 UL\nLT2\n3673 2776 M\n19 -113 V\n-119 -34
      V\n-17 113 V\n117 34 V\n.6329 g 3645 2887 N 117 34 26 -112 -115 -33
      h\n1.000 UP\n1.000 UL\nLT2\n3645 2887 M\n28 -111 V\n-117 -34 V\n-26 112
      V\n115 33 V\n.6755 g 3608 2996 N 115 33 33 -110 -111 -32 h\n1.000
      UP\n1.000 UL\nLT2\n3608 2996 M\n37 -109 V\n-115 -33 V\n-33 110 V\n111
      32 V\n.7167 g 3562 3101 N 111 32 42 -107 -107 -30 h\n1.000 UP\n1.000
      UL\nLT2\n3562 3101 M\n46 -105 V\n-111 -32 V\n-42 107 V\n107 30 V\n.7562
      g 3507 3203 N 107 30 48 -103 -100 -29 h\n1.000 UP\n1.000 UL\nLT2\n3507
      3203 M\n55 -102 V\n-107 -30 V\n-48 103 V\n100 29 V\n.7936 g 3445 3299 N
      100 29 56 -99 -94 -26 h\n1.000 UP\n1.000 UL\nLT2\n3445 3299 M\n62 -96
      V\n-100 -29 V\n-56 99 V\n94 26 V\n.8286 g 3375 3390 N 94 26 63 -92 -87
      -25 h\n1.000 UP\n1.000 UL\nLT2\n3375 3390 M\n70 -91 V\n-94 -26 V\n-63
      92 V\n87 25 V\n.861 g 3299 3475 N 87 25 69 -87 -80 -23 h\n1.000
      UP\n1.000 UL\nLT2\n3299 3475 M\n76 -85 V\n-87 -25 V\n-69 87 V\n80 23
      V\n.8905 g 3216 3552 N 80 23 74 -80 -71 -20 h\n1.000 UP\n1.000
      UL\nLT2\n3216 3552 M\n83 -77 V\n-80 -23 V\n-74 80 V\n71 20 V\n.9169 g
      3127 3621 N 71 20 80 -72 -62 -17 h\n1.000 UP\n1.000 UL\nLT2\n3127 3621
      M\n89 -69 V\n-71 -20 V\n-80 72 V\n62 17 V\n.9399 g 3034 3682 N 62 17 84
      -64 -53 -14 h\n1.000 UP\n1.000 UL\nLT2\n3034 3682 M\n93 -61 V\n-62 -17
      V\n-84 64 V\n53 14 V\n.9593 g 2936 3735 N 53 14 87 -55 -42 -12 h\n1.000
      UP\n1.000 UL\nLT2\n2936 3735 M\n98 -53 V\n-53 -14 V\n-87 55 V\n42 12
      V\n.975 g 2835 3778 N 42 12 91 -46 -32 -9 h\n1.000 UP\n1.000
      UL\nLT2\n2835 3778 M\n101 -43 V\n-42 -12 V\n-91 46 V\n32 9 V\n.987 g
      2732 3812 N 32 9 92 -36 -21 -7 h\n1.000 UP\n1.000 UL\nLT2\n2732 3812
      M\n103 -34 V\n-32 -9 V\n-92 36 V\n21 7 V\n.995 g 2627 3835 N 21 7 95
      -27 -11 -3 h\n1.000 UP\n1.000 UL\nLT2\n2627 3835 M\n105 -23 V\n-21 -7
      V\n-95 27 V\n11 3 V\n.999 g 2521 3849 N 11 3 95 -17 0 0 h\n1.000
      UP\n1.000 UL\nLT2\n2521 3849 M\n106 -14 V\n-11 -3 V\n-95 17 V\n.001 g
      2616 1323 N 0 0 -81 9 -14 -2 h\n1.000 UP\n1.000 UL\nLT2\n2616 1323
      M\n-95 7 V\n81 -9 V\n14 2 V\n.005 g 2711 1327 N 14 2 -81 0 -28 -6
      h\n1.000 UP\n1.000 UL\nLT2\n2711 1327 M\n-95 -4 V\n-14 -2 V\n81 0 V\n28
      6 V\n.013 g 2803 1341 N 28 6 -79 -12 -41 -8 h\n1.000 UP\n1.000
      UL\nLT2\n2803 1341 M\n-92 -14 V\n-28 -6 V\n79 12 V\n41 8 V\n.025 g 2894
      1364 N 41 8 -78 -21 -54 -10 h\n1.000 UP\n1.000 UL\nLT2\n2894 1364
      M\n-91 -23 V\n-41 -8 V\n78 21 V\n54 10 V\n.0407 g 2981 1398 N 54 10 -74
      -31 -67 -13 h\n1.000 UP\n1.000 UL\nLT2\n2981 1398 M\n-87 -34 V\n-54 -10
      V\n74 31 V\n67 13 V\n.0601 g 3065 1441 N 67 13 -72 -41 -79 -15 h\n1.000
      UP\n1.000 UL\nLT2\n3065 1441 M\n-84 -43 V\n-67 -13 V\n72 41 V\n79 15
      V\n.0831 g 3145 1494 N 79 15 -68 -50 -91 -18 h\n1.000 UP\n1.000
      UL\nLT2\n3145 1494 M\n-80 -53 V\n-79 -15 V\n68 50 V\n91 18 V\n.1095 g
      3219 1555 N 91 18 -63 -59 -102 -20 h\n1.000 UP\n1.000 UL\nLT2\n3219
      1555 M\n-74 -61 V\n-91 -18 V\n63 59 V\n102 20 V\n.139 g 3288 1625 N 102
      20 -59 -68 -112 -22 h\n1.000 UP\n1.000 UL\nLT2\n3288 1625 M\n-69 -70
      V\n-102 -20 V\n59 68 V\n112 22 V\n.1714 g 3351 1702 N 112 22 -54 -75
      -121 -24 h\n1.000 UP\n1.000 UL\nLT2\n3351 1702 M\n-63 -77 V\n-112 -22
      V\n54 75 V\n121 24 V\n.2064 g 3407 1786 N 121 24 -48 -83 -129 -25
      h\n1.000 UP\n1.000 UL\nLT2\n3407 1786 M\n-56 -84 V\n-121 -24 V\n48 83
      V\n129 25 V\n.2438 g 3455 1877 N 129 25 -41 -90 -136 -26 h\n1.000
      UP\n1.000 UL\nLT2\n3455 1877 M\n-48 -91 V\n-129 -25 V\n41 90 V\n136 26
      V\n.2833 g 3497 1974 N 136 26 -36 -96 -142 -27 h\n1.000 UP\n1.000
      UL\nLT2\n3497 1974 M\n-42 -97 V\n-136 -26 V\n36 96 V\n142 27 V\n.3245 g
      3530 2076 N 142 27 -28 -100 -147 -29 h\n1.000 UP\n1.000 UL\nLT2\n3530
      2076 M\n-33 -102 V\n-142 -27 V\n28 100 V\n147 29 V\n.3671 g 3556 2182 N
      147 29 -22 -105 -151 -30 h\n1.000 UP\n1.000 UL\nLT2\n3556 2182 M\n-26
      -106 V\n-147 -29 V\n22 105 V\n151 30 V\n.4108 g 3573 2291 N 151 30 -14
      -109 -154 -30 h\n1.000 UP\n1.000 UL\nLT2\n3573 2291 M\n-17 -109 V\n-151
      -30 V\n14 109 V\n154 30 V\n.4552 g 3581 2402 N 154 30 -8 -111 -154 -30
      h\n1.000 UP\n1.000 UL\nLT2\n3581 2402 M\n-8 -111 V\n-154 -30 V\n8 111
      V\n154 30 V\n.5 g 3581 2515 N 154 30 0 -113 -154 -30 h\n1.000 UP\n1.000
      UL\nLT2\n3581 2515 M\n0 -113 V\n-154 -30 V\n0 113 V\n154 30 V\n.5448 g
      3573 2629 N 154 30 8 -114 -154 -30 h\n1.000 UP\n1.000 UL\nLT2\n3573
      2629 M\n8 -114 V\n-154 -30 V\n-8 114 V\n154 30 V\n.5892 g 3556 2742 N
      154 30 14 -114 -151 -29 h\n1.000 UP\n1.000 UL\nLT2\n3556 2742 M\n17
      -113 V\n-154 -30 V\n-14 114 V\n151 29 V\n.6329 g 3530 2854 N 151 29 22
      -113 -147 -28 h\n1.000 UP\n1.000 UL\nLT2\n3530 2854 M\n26 -112 V\n-151
      -29 V\n-22 113 V\n147 28 V\n.6755 g 3497 2964 N 147 28 28 -111 -142 -27
      h\n1.000 UP\n1.000 UL\nLT2\n3497 2964 M\n33 -110 V\n-147 -28 V\n-28 111
      V\n142 27 V\n.7167 g 3455 3071 N 142 27 36 -108 -136 -26 h\n1.000
      UP\n1.000 UL\nLT2\n3455 3071 M\n42 -107 V\n-142 -27 V\n-36 108 V\n136
      26 V\n.7562 g 3407 3174 N 136 26 41 -104 -129 -25 h\n1.000 UP\n1.000
      UL\nLT2\n3407 3174 M\n48 -103 V\n-136 -26 V\n-41 104 V\n129 25 V\n.7936
      g 3351 3273 N 129 25 48 -100 -121 -24 h\n1.000 UP\n1.000 UL\nLT2\n3351
      3273 M\n56 -99 V\n-129 -25 V\n-48 100 V\n121 24 V\n.8286 g 3288 3365 N
      121 24 54 -95 -112 -21 h\n1.000 UP\n1.000 UL\nLT2\n3288 3365 M\n63 -92
      V\n-121 -24 V\n-54 95 V\n112 21 V\n.861 g 3219 3452 N 112 21 59 -88
      -102 -20 h\n1.000 UP\n1.000 UL\nLT2\n3219 3452 M\n69 -87 V\n-112 -21
      V\n-59 88 V\n102 20 V\n.8905 g 3145 3532 N 102 20 63 -82 -91 -18
      h\n1.000 UP\n1.000 UL\nLT2\n3145 3532 M\n74 -80 V\n-102 -20 V\n-63 82
      V\n91 18 V\n.9169 g 3065 3604 N 91 18 68 -74 -79 -16 h\n1.000 UP\n1.000
      UL\nLT2\n3065 3604 M\n80 -72 V\n-91 -18 V\n-68 74 V\n79 16 V\n.9399 g
      2981 3668 N 79 16 72 -67 -67 -13 h\n1.000 UP\n1.000 UL\nLT2\n2981 3668
      M\n84 -64 V\n-79 -16 V\n-72 67 V\n67 13 V\n.9593 g 2894 3723 N 67 13 74
      -57 -54 -11 h\n1.000 UP\n1.000 UL\nLT2\n2894 3723 M\n87 -55 V\n-67 -13
      V\n-74 57 V\n54 11 V\n.975 g 2803 3769 N 54 11 78 -49 -41 -8 h\n1.000
      UP\n1.000 UL\nLT2\n2803 3769 M\n91 -46 V\n-54 -11 V\n-78 49 V\n41 8
      V\n.987 g 2711 3805 N 41 8 79 -39 -28 -5 h\n1.000 UP\n1.000
      UL\nLT2\n2711 3805 M\n92 -36 V\n-41 -8 V\n-79 39 V\n28 5 V\n.995 g 2616
      3832 N 28 5 81 -30 -14 -2 h\n1.000 UP\n1.000 UL\nLT2\n2616 3832 M\n95
      -27 V\n-28 -5 V\n-81 30 V\n14 2 V\n.999 g 2521 3849 N 14 2 81 -19 0 0
      h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n95 -17 V\n-14 -2 V\n-81 19
      V\n.001 g 2602 1321 N 0 0 -65 12 -16 -3 h\n1.000 UP\n1.000
      UL\nLT2\n2602 1321 M\n-81 9 V\n65 -12 V\n16 3 V\n.005 g 2683 1321 N 16
      3 -64 1 -33 -4 h\n1.000 UP\n1.000 UL\nLT2\n2683 1321 M\n-81 0 V\n-16 -3
      V\n64 -1 V\n33 4 V\n.013 g 2762 1333 N 33 4 -63 -9 -49 -7 h\n1.000
      UP\n1.000 UL\nLT2\n2762 1333 M\n-79 -12 V\n-33 -4 V\n63 9 V\n49 7
      V\n.025 g 2840 1354 N 49 7 -62 -19 -65 -9 h\n1.000 UP\n1.000
      UL\nLT2\n2840 1354 M\n-78 -21 V\n-49 -7 V\n62 19 V\n65 9 V\n.0407 g
      2914 1385 N 65 9 -60 -29 -79 -11 h\n1.000 UP\n1.000 UL\nLT2\n2914 1385
      M\n-74 -31 V\n-65 -9 V\n60 29 V\n79 11 V\n.0601 g 2986 1426 N 79 11 -57
      -39 -94 -13 h\n1.000 UP\n1.000 UL\nLT2\n2986 1426 M\n-72 -41 V\n-79 -11
      V\n57 39 V\n94 13 V\n.0831 g 3054 1476 N 94 13 -54 -48 -108 -15
      h\n1.000 UP\n1.000 UL\nLT2\n3054 1476 M\n-68 -50 V\n-94 -13 V\n54 48
      V\n108 15 V\n.1095 g 3117 1535 N 108 15 -50 -58 -121 -16 h\n1.000
      UP\n1.000 UL\nLT2\n3117 1535 M\n-63 -59 V\n-108 -15 V\n50 58 V\n121 16
      V\n.139 g 3176 1603 N 121 16 -47 -66 -133 -18 h\n1.000 UP\n1.000
      UL\nLT2\n3176 1603 M\n-59 -68 V\n-121 -16 V\n47 66 V\n133 18 V\n.1714 g
      3230 1678 N 133 18 -43 -74 -144 -19 h\n1.000 UP\n1.000 UL\nLT2\n3230
      1678 M\n-54 -75 V\n-133 -18 V\n43 74 V\n144 19 V\n.2064 g 3278 1761 N
      144 19 -38 -82 -154 -20 h\n1.000 UP\n1.000 UL\nLT2\n3278 1761 M\n-48
      -83 V\n-144 -19 V\n38 82 V\n154 20 V\n.2438 g 3319 1851 N 154 20 -33
      -88 -162 -22 h\n1.000 UP\n1.000 UL\nLT2\n3319 1851 M\n-41 -90 V\n-154
      -20 V\n33 88 V\n162 22 V\n.2833 g 3355 1947 N 162 22 -28 -95 -170 -23
      h\n1.000 UP\n1.000 UL\nLT2\n3355 1947 M\n-36 -96 V\n-162 -22 V\n28 95
      V\n170 23 V\n.3245 g 3383 2047 N 170 23 -23 -100 -175 -23 h\n1.000
      UP\n1.000 UL\nLT2\n3383 2047 M\n-28 -100 V\n-170 -23 V\n23 100 V\n175
      23 V\n.3671 g 3405 2152 N 175 23 -18 -104 -179 -24 h\n1.000 UP\n1.000
      UL\nLT2\n3405 2152 M\n-22 -105 V\n-175 -23 V\n18 104 V\n179 24 V\n.4108
      g 3419 2261 N 179 24 -11 -108 -182 -25 h\n1.000 UP\n1.000 UL\nLT2\n3419
      2261 M\n-14 -109 V\n-179 -24 V\n11 108 V\n182 25 V\n.4552 g 3427 2372 N
      182 25 -6 -111 -184 -25 h\n1.000 UP\n1.000 UL\nLT2\n3427 2372 M\n-8
      -111 V\n-182 -25 V\n6 111 V\n184 25 V\n.5 g 3427 2485 N 184 25 0 -113
      -184 -25 h\n1.000 UP\n1.000 UL\nLT2\n3427 2485 M\n0 -113 V\n-184 -25
      V\n0 113 V\n184 25 V\n.5448 g 3419 2599 N 184 25 6 -115 -182 -24
      h\n1.000 UP\n1.000 UL\nLT2\n3419 2599 M\n8 -114 V\n-184 -25 V\n-6 115
      V\n182 24 V\n.5892 g 3405 2713 N 182 24 11 -114 -179 -24 h\n1.000
      UP\n1.000 UL\nLT2\n3405 2713 M\n14 -114 V\n-182 -24 V\n-11 114 V\n179
      24 V\n.6329 g 3383 2826 N 179 24 18 -113 -175 -24 h\n1.000 UP\n1.000
      UL\nLT2\n3383 2826 M\n22 -113 V\n-179 -24 V\n-18 113 V\n175 24 V\n.6755
      g 3355 2937 N 175 24 23 -112 -170 -23 h\n1.000 UP\n1.000 UL\nLT2\n3355
      2937 M\n28 -111 V\n-175 -24 V\n-23 112 V\n170 23 V\n.7167 g 3319 3045 N
      170 23 28 -109 -162 -22 h\n1.000 UP\n1.000 UL\nLT2\n3319 3045 M\n36
      -108 V\n-170 -23 V\n-28 109 V\n162 22 V\n.7562 g 3278 3149 N 162 22 33
      -105 -154 -21 h\n1.000 UP\n1.000 UL\nLT2\n3278 3149 M\n41 -104 V\n-162
      -22 V\n-33 105 V\n154 21 V\n.7936 g 3230 3249 N 154 21 38 -102 -144 -19
      h\n1.000 UP\n1.000 UL\nLT2\n3230 3249 M\n48 -100 V\n-154 -21 V\n-38 102
      V\n144 19 V\n.8286 g 3176 3344 N 144 19 43 -96 -133 -18 h\n1.000
      UP\n1.000 UL\nLT2\n3176 3344 M\n54 -95 V\n-144 -19 V\n-43 96 V\n133 18
      V\n.861 g 3117 3432 N 133 18 47 -90 -121 -16 h\n1.000 UP\n1.000
      UL\nLT2\n3117 3432 M\n59 -88 V\n-133 -18 V\n-47 90 V\n121 16 V\n.8905 g
      3054 3514 N 121 16 50 -83 -108 -15 h\n1.000 UP\n1.000 UL\nLT2\n3054
      3514 M\n63 -82 V\n-121 -16 V\n-50 83 V\n108 15 V\n.9169 g 2986 3588 N
      108 15 54 -77 -94 -12 h\n1.000 UP\n1.000 UL\nLT2\n2986 3588 M\n68 -74
      V\n-108 -15 V\n-54 77 V\n94 12 V\n.9399 g 2914 3655 N 94 12 57 -68 -79
      -11 h\n1.000 UP\n1.000 UL\nLT2\n2914 3655 M\n72 -67 V\n-94 -12 V\n-57
      68 V\n79 11 V\n.9593 g 2840 3712 N 79 11 60 -59 -65 -9 h\n1.000
      UP\n1.000 UL\nLT2\n2840 3712 M\n74 -57 V\n-79 -11 V\n-60 59 V\n65 9
      V\n.975 g 2762 3761 N 65 9 62 -51 -49 -7 h\n1.000 UP\n1.000
      UL\nLT2\n2762 3761 M\n78 -49 V\n-65 -9 V\n-62 51 V\n49 7 V\n.987 g 2683
      3800 N 49 7 63 -42 -33 -4 h\n1.000 UP\n1.000 UL\nLT2\n2683 3800 M\n79
      -39 V\n-49 -7 V\n-63 42 V\n33 4 V\n.995 g 2602 3830 N 33 4 64 -31 -16
      -3 h\n1.000 UP\n1.000 UL\nLT2\n2602 3830 M\n81 -30 V\n-33 -4 V\n-64 31
      V\n16 3 V\n.999 g 2521 3849 N 16 3 65 -22 0 0 h\n1.000 UP\n1.000
      UL\nLT2\n2521 3849 M\n81 -19 V\n-16 -3 V\n-65 22 V\n.001 g 2586 1318 N
      0 0 -46 13 -19 -1 h\n1.000 UP\n1.000 UL\nLT2\n2586 1318 M\n-65 12 V\n46
      -13 V\n19 1 V\n.005 g 2650 1317 N 19 1 -46 3 -37 -3 h\n1.000 UP\n1.000
      UL\nLT2\n2650 1317 M\n-64 1 V\n-19 -1 V\n46 -3 V\n37 3 V\n.013 g 2713
      1326 N 37 3 -45 -7 -55 -5 h\n1.000 UP\n1.000 UL\nLT2\n2713 1326 M\n-63
      -9 V\n-37 -3 V\n45 7 V\n55 5 V\n.025 g 2775 1345 N 55 5 -44 -17 -73 -7
      h\n1.000 UP\n1.000 UL\nLT2\n2775 1345 M\n-62 -19 V\n-55 -5 V\n44 17
      V\n73 7 V\n.0407 g 2835 1374 N 73 7 -43 -28 -90 -8 h\n1.000 UP\n1.000
      UL\nLT2\n2835 1374 M\n-60 -29 V\n-73 -7 V\n43 28 V\n90 8 V\n.0601 g
      2892 1413 N 90 8 -41 -37 -106 -10 h\n1.000 UP\n1.000 UL\nLT2\n2892 1413
      M\n-57 -39 V\n-90 -8 V\n41 37 V\n106 10 V\n.0831 g 2946 1461 N 106 10
      -38 -47 -122 -11 h\n1.000 UP\n1.000 UL\nLT2\n2946 1461 M\n-54 -48
      V\n-106 -10 V\n38 47 V\n122 11 V\n.1095 g 2996 1519 N 122 11 -36 -56
      -136 -13 h\n1.000 UP\n1.000 UL\nLT2\n2996 1519 M\n-50 -58 V\n-122 -11
      V\n36 56 V\n136 13 V\n.139 g 3043 1585 N 136 13 -34 -65 -149 -14
      h\n1.000 UP\n1.000 UL\nLT2\n3043 1585 M\n-47 -66 V\n-136 -13 V\n34 65
      V\n149 14 V\n.1714 g 3086 1659 N 149 14 -30 -73 -162 -15 h\n1.000
      UP\n1.000 UL\nLT2\n3086 1659 M\n-43 -74 V\n-149 -14 V\n30 73 V\n162 15
      V\n.2064 g 3124 1741 N 162 15 -27 -81 -173 -16 h\n1.000 UP\n1.000
      UL\nLT2\n3124 1741 M\n-38 -82 V\n-162 -15 V\n27 81 V\n173 16 V\n.2438 g
      3157 1829 N 173 16 -24 -87 -182 -17 h\n1.000 UP\n1.000 UL\nLT2\n3157
      1829 M\n-33 -88 V\n-173 -16 V\n24 87 V\n182 17 V\n.2833 g 3185 1924 N
      182 17 -20 -94 -190 -18 h\n1.000 UP\n1.000 UL\nLT2\n3185 1924 M\n-28
      -95 V\n-182 -17 V\n20 94 V\n190 18 V\n.3245 g 3208 2024 N 190 18 -16
      -100 -197 -18 h\n1.000 UP\n1.000 UL\nLT2\n3208 2024 M\n-23 -100 V\n-190
      -18 V\n16 100 V\n197 18 V\n.3671 g 3226 2128 N 197 18 -13 -104 -202 -18
      h\n1.000 UP\n1.000 UL\nLT2\n3226 2128 M\n-18 -104 V\n-197 -18 V\n13 104
      V\n202 18 V\n.4108 g 3237 2236 N 202 18 -8 -108 -205 -18 h\n1.000
      UP\n1.000 UL\nLT2\n3237 2236 M\n-11 -108 V\n-202 -18 V\n8 108 V\n205 18
      V\n.4552 g 3243 2347 N 205 18 -4 -111 -207 -18 h\n1.000 UP\n1.000
      UL\nLT2\n3243 2347 M\n-6 -111 V\n-205 -18 V\n4 111 V\n207 18 V\n.5 g
      3243 2460 N 207 18 0 -113 -207 -18 h\n1.000 UP\n1.000 UL\nLT2\n3243
      2460 M\n0 -113 V\n-207 -18 V\n0 113 V\n207 18 V\n.5448 g 3237 2575 N
      207 18 4 -114 -205 -19 h\n1.000 UP\n1.000 UL\nLT2\n3237 2575 M\n6 -115
      V\n-207 -18 V\n-4 114 V\n205 19 V\n.5892 g 3226 2689 N 205 19 8 -114
      -202 -19 h\n1.000 UP\n1.000 UL\nLT2\n3226 2689 M\n11 -114 V\n-205 -19
      V\n-8 114 V\n202 19 V\n.6329 g 3208 2802 N 202 19 13 -114 -197 -18
      h\n1.000 UP\n1.000 UL\nLT2\n3208 2802 M\n18 -113 V\n-202 -19 V\n-13 114
      V\n197 18 V\n.6755 g 3185 2914 N 197 18 16 -112 -190 -18 h\n1.000
      UP\n1.000 UL\nLT2\n3185 2914 M\n23 -112 V\n-197 -18 V\n-16 112 V\n190
      18 V\n.7167 g 3157 3023 N 190 18 20 -110 -182 -17 h\n1.000 UP\n1.000
      UL\nLT2\n3157 3023 M\n28 -109 V\n-190 -18 V\n-20 110 V\n182 17 V\n.7562
      g 3124 3128 N 182 17 24 -107 -173 -15 h\n1.000 UP\n1.000 UL\nLT2\n3124
      3128 M\n33 -105 V\n-182 -17 V\n-24 107 V\n173 15 V\n.7936 g 3086 3230 N
      173 15 27 -102 -162 -15 h\n1.000 UP\n1.000 UL\nLT2\n3086 3230 M\n38
      -102 V\n-173 -15 V\n-27 102 V\n162 15 V\n.8286 g 3043 3326 N 162 15 30
      -97 -149 -14 h\n1.000 UP\n1.000 UL\nLT2\n3043 3326 M\n43 -96 V\n-162
      -15 V\n-30 97 V\n149 14 V\n.861 g 2996 3416 N 149 14 34 -91 -136 -13
      h\n1.000 UP\n1.000 UL\nLT2\n2996 3416 M\n47 -90 V\n-149 -14 V\n-34 91
      V\n136 13 V\n.8905 g 2946 3499 N 136 13 36 -85 -122 -11 h\n1.000
      UP\n1.000 UL\nLT2\n2946 3499 M\n50 -83 V\n-136 -13 V\n-36 85 V\n122 11
      V\n.9169 g 2892 3576 N 122 11 38 -78 -106 -10 h\n1.000 UP\n1.000
      UL\nLT2\n2892 3576 M\n54 -77 V\n-122 -11 V\n-38 78 V\n106 10 V\n.9399 g
      2835 3644 N 106 10 41 -70 -90 -8 h\n1.000 UP\n1.000 UL\nLT2\n2835 3644
      M\n57 -68 V\n-106 -10 V\n-41 70 V\n90 8 V\n.9593 g 2775 3703 N 90 8 43
      -61 -73 -6 h\n1.000 UP\n1.000 UL\nLT2\n2775 3703 M\n60 -59 V\n-90 -8
      V\n-43 61 V\n73 6 V\n.975 g 2713 3754 N 73 6 44 -52 -55 -5 h\n1.000
      UP\n1.000 UL\nLT2\n2713 3754 M\n62 -51 V\n-73 -6 V\n-44 52 V\n55 5
      V\n.987 g 2650 3796 N 55 5 45 -43 -37 -4 h\n1.000 UP\n1.000
      UL\nLT2\n2650 3796 M\n63 -42 V\n-55 -5 V\n-45 43 V\n37 4 V\n.995 g 2586
      3827 N 37 4 46 -34 -19 -1 h\n1.000 UP\n1.000 UL\nLT2\n2586 3827 M\n64
      -31 V\n-37 -4 V\n-46 34 V\n19 1 V\n.999 g 2521 3849 N 19 1 46 -23 0 0
      h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n65 -22 V\n-19 -1 V\n-46 23
      V\n.001 g 2567 1317 N 0 0 -26 14 -20 -1 h\n1.000 UP\n1.000
      UL\nLT2\n2567 1317 M\n-46 13 V\n26 -14 V\n20 1 V\n.005 g 2613 1314 N 20
      1 -26 5 -40 -3 h\n1.000 UP\n1.000 UL\nLT2\n2613 1314 M\n-46 3 V\n-20 -1
      V\n26 -5 V\n40 3 V\n.013 g 2658 1321 N 40 3 -26 -7 -59 -3 h\n1.000
      UP\n1.000 UL\nLT2\n2658 1321 M\n-45 -7 V\n-40 -3 V\n26 7 V\n59 3
      V\n.025 g 2702 1338 N 59 3 -25 -16 -78 -4 h\n1.000 UP\n1.000
      UL\nLT2\n2702 1338 M\n-44 -17 V\n-59 -3 V\n25 16 V\n78 4 V\n.0407 g
      2745 1366 N 78 4 -24 -27 -97 -5 h\n1.000 UP\n1.000 UL\nLT2\n2745 1366
      M\n-43 -28 V\n-78 -4 V\n24 27 V\n97 5 V\n.0601 g 2786 1403 N 97 5 -23
      -36 -115 -6 h\n1.000 UP\n1.000 UL\nLT2\n2786 1403 M\n-41 -37 V\n-97 -5
      V\n23 36 V\n115 6 V\n.0831 g 2824 1450 N 115 6 -22 -46 -131 -7 h\n1.000
      UP\n1.000 UL\nLT2\n2824 1450 M\n-38 -47 V\n-115 -6 V\n22 46 V\n131 7
      V\n.1095 g 2860 1506 N 131 7 -20 -55 -147 -8 h\n1.000 UP\n1.000
      UL\nLT2\n2860 1506 M\n-36 -56 V\n-131 -7 V\n20 55 V\n147 8 V\n.139 g
      2894 1571 N 147 8 -19 -64 -162 -9 h\n1.000 UP\n1.000 UL\nLT2\n2894 1571
      M\n-34 -65 V\n-147 -8 V\n19 64 V\n162 9 V\n.1714 g 2924 1644 N 162 9
      -17 -73 -175 -9 h\n1.000 UP\n1.000 UL\nLT2\n2924 1644 M\n-30 -73
      V\n-162 -9 V\n17 73 V\n175 9 V\n.2064 g 2951 1725 N 175 9 -16 -80 -186
      -10 h\n1.000 UP\n1.000 UL\nLT2\n2951 1725 M\n-27 -81 V\n-175 -9 V\n16
      80 V\n186 10 V\n.2438 g 2975 1812 N 186 10 -13 -87 -197 -10 h\n1.000
      UP\n1.000 UL\nLT2\n2975 1812 M\n-24 -87 V\n-186 -10 V\n13 87 V\n197 10
      V\n.2833 g 2995 1906 N 197 10 -11 -93 -206 -11 h\n1.000 UP\n1.000
      UL\nLT2\n2995 1906 M\n-20 -94 V\n-197 -10 V\n11 93 V\n206 11 V\n.3245 g
      3011 2006 N 206 11 -10 -99 -212 -12 h\n1.000 UP\n1.000 UL\nLT2\n3011
      2006 M\n-16 -100 V\n-206 -11 V\n10 99 V\n212 12 V\n.3671 g 3024 2110 N
      212 12 -7 -104 -218 -12 h\n1.000 UP\n1.000 UL\nLT2\n3024 2110 M\n-13
      -104 V\n-212 -12 V\n7 104 V\n218 12 V\n.4108 g 3032 2218 N 218 12 -4
      -107 -222 -13 h\n1.000 UP\n1.000 UL\nLT2\n3032 2218 M\n-8 -108 V\n-218
      -12 V\n4 107 V\n222 13 V\n.4552 g 3036 2329 N 222 13 -3 -111 -223 -13
      h\n1.000 UP\n1.000 UL\nLT2\n3036 2329 M\n-4 -111 V\n-222 -13 V\n3 111
      V\n223 13 V\n.5 g 3036 2442 N 223 13 0 -113 -223 -13 h\n1.000 UP\n1.000
      UL\nLT2\n3036 2442 M\n0 -113 V\n-223 -13 V\n0 113 V\n223 13 V\n.5448 g
      3032 2556 N 223 13 3 -115 -222 -12 h\n1.000 UP\n1.000 UL\nLT2\n3032
      2556 M\n4 -114 V\n-223 -13 V\n-3 115 V\n222 12 V\n.5892 g 3024 2670 N
      222 12 4 -114 -218 -12 h\n1.000 UP\n1.000 UL\nLT2\n3024 2670 M\n8 -114
      V\n-222 -12 V\n-4 114 V\n218 12 V\n.6329 g 3011 2784 N 218 12 7 -114
      -212 -12 h\n1.000 UP\n1.000 UL\nLT2\n3011 2784 M\n13 -114 V\n-218 -12
      V\n-7 114 V\n212 12 V\n.6755 g 2995 2896 N 212 12 10 -113 -206 -11
      h\n1.000 UP\n1.000 UL\nLT2\n2995 2896 M\n16 -112 V\n-212 -12 V\n-10 113
      V\n206 11 V\n.7167 g 2975 3006 N 206 11 11 -110 -197 -11 h\n1.000
      UP\n1.000 UL\nLT2\n2975 3006 M\n20 -110 V\n-206 -11 V\n-11 110 V\n197
      11 V\n.7562 g 2951 3113 N 197 11 13 -107 -186 -11 h\n1.000 UP\n1.000
      UL\nLT2\n2951 3113 M\n24 -107 V\n-197 -11 V\n-13 107 V\n186 11 V\n.7936
      g 2924 3215 N 186 11 16 -103 -175 -10 h\n1.000 UP\n1.000 UL\nLT2\n2924
      3215 M\n27 -102 V\n-186 -11 V\n-16 103 V\n175 10 V\n.8286 g 2894 3312 N
      175 10 17 -98 -162 -9 h\n1.000 UP\n1.000 UL\nLT2\n2894 3312 M\n30 -97
      V\n-175 -10 V\n-17 98 V\n162 9 V\n.861 g 2860 3403 N 162 9 19 -92 -147
      -8 h\n1.000 UP\n1.000 UL\nLT2\n2860 3403 M\n34 -91 V\n-162 -9 V\n-19 92
      V\n147 8 V\n.8905 g 2824 3488 N 147 8 20 -86 -131 -7 h\n1.000 UP\n1.000
      UL\nLT2\n2824 3488 M\n36 -85 V\n-147 -8 V\n-20 86 V\n131 7 V\n.9169 g
      2786 3566 N 131 7 22 -78 -115 -7 h\n1.000 UP\n1.000 UL\nLT2\n2786 3566
      M\n38 -78 V\n-131 -7 V\n-22 78 V\n115 7 V\n.9399 g 2745 3636 N 115 7 23
      -71 -97 -6 h\n1.000 UP\n1.000 UL\nLT2\n2745 3636 M\n41 -70 V\n-115 -7
      V\n-23 71 V\n97 6 V\n.9593 g 2702 3697 N 97 6 24 -63 -78 -4 h\n1.000
      UP\n1.000 UL\nLT2\n2702 3697 M\n43 -61 V\n-97 -6 V\n-24 63 V\n78 4
      V\n.975 g 2658 3749 N 78 4 25 -53 -59 -3 h\n1.000 UP\n1.000
      UL\nLT2\n2658 3749 M\n44 -52 V\n-78 -4 V\n-25 53 V\n59 3 V\n.987 g 2613
      3792 N 59 3 26 -44 -40 -2 h\n1.000 UP\n1.000 UL\nLT2\n2613 3792 M\n45
      -43 V\n-59 -3 V\n-26 44 V\n40 2 V\n.995 g 2567 3826 N 40 2 26 -35 -20
      -1 h\n1.000 UP\n1.000 UL\nLT2\n2567 3826 M\n46 -34 V\n-40 -2 V\n-26 35
      V\n20 1 V\n.999 g 2521 3849 N 20 1 26 -24 0 0 h\n1.000 UP\n1.000
      UL\nLT2\n2521 3849 M\n46 -23 V\n-20 -1 V\n-26 24 V\n.001 g 2547 1316 N
      0 0 -5 15 -21 -1 h\n1.000 UP\n1.000 UL\nLT2\n2547 1316 M\n-26 14 V\n5
      -15 V\n21 1 V\n.005 g 2573 1311 N 21 1 -6 5 -41 -1 h\n1.000 UP\n1.000
      UL\nLT2\n2573 1311 M\n-26 5 V\n-21 -1 V\n6 -5 V\n41 1 V\n.013 g 2599
      1318 N 41 1 -5 -6 -62 -2 h\n1.000 UP\n1.000 UL\nLT2\n2599 1318 M\n-26
      -7 V\n-41 -1 V\n5 6 V\n62 2 V\n.025 g 2624 1334 N 62 2 -5 -16 -82 -2
      h\n1.000 UP\n1.000 UL\nLT2\n2624 1334 M\n-25 -16 V\n-62 -2 V\n5 16
      V\n82 2 V\n.0407 g 2648 1361 N 82 2 -5 -26 -101 -3 h\n1.000 UP\n1.000
      UL\nLT2\n2648 1361 M\n-24 -27 V\n-82 -2 V\n5 26 V\n101 3 V\n.0601 g
      2671 1397 N 101 3 -4 -36 -120 -3 h\n1.000 UP\n1.000 UL\nLT2\n2671 1397
      M\n-23 -36 V\n-101 -3 V\n4 36 V\n120 3 V\n.0831 g 2693 1443 N 120 3 -5
      -46 -137 -3 h\n1.000 UP\n1.000 UL\nLT2\n2693 1443 M\n-22 -46 V\n-120 -3
      V\n5 46 V\n137 3 V\n.1095 g 2713 1498 N 137 3 -4 -55 -153 -3 h\n1.000
      UP\n1.000 UL\nLT2\n2713 1498 M\n-20 -55 V\n-137 -3 V\n4 55 V\n153 3
      V\n.139 g 2732 1562 N 153 3 -4 -63 -168 -4 h\n1.000 UP\n1.000
      UL\nLT2\n2732 1562 M\n-19 -64 V\n-153 -3 V\n4 63 V\n168 4 V\n.1714 g
      2749 1635 N 168 4 -3 -72 -182 -5 h\n1.000 UP\n1.000 UL\nLT2\n2749 1635
      M\n-17 -73 V\n-168 -4 V\n3 72 V\n182 5 V\n.2064 g 2765 1715 N 182 5 -3
      -80 -195 -5 h\n1.000 UP\n1.000 UL\nLT2\n2765 1715 M\n-16 -80 V\n-182 -5
      V\n3 80 V\n195 5 V\n.2438 g 2778 1802 N 195 5 -3 -87 -205 -5 h\n1.000
      UP\n1.000 UL\nLT2\n2778 1802 M\n-13 -87 V\n-195 -5 V\n3 87 V\n205 5
      V\n.2833 g 2789 1895 N 205 5 -2 -93 -214 -5 h\n1.000 UP\n1.000
      UL\nLT2\n2789 1895 M\n-11 -93 V\n-205 -5 V\n2 93 V\n214 5 V\n.3245 g
      2799 1994 N 214 5 -2 -99 -222 -5 h\n1.000 UP\n1.000 UL\nLT2\n2799 1994
      M\n-10 -99 V\n-214 -5 V\n2 99 V\n222 5 V\n.3671 g 2806 2098 N 222 5 -2
      -103 -227 -6 h\n1.000 UP\n1.000 UL\nLT2\n2806 2098 M\n-7 -104 V\n-222
      -5 V\n2 103 V\n227 6 V\n.4108 g 2810 2205 N 227 6 0 -108 -231 -5
      h\n1.000 UP\n1.000 UL\nLT2\n2810 2205 M\n-4 -107 V\n-227 -6 V\n0 108
      V\n231 5 V\n.4552 g 2813 2316 N 231 5 -1 -111 -233 -5 h\n1.000
      UP\n1.000 UL\nLT2\n2813 2316 M\n-3 -111 V\n-231 -5 V\n1 111 V\n233 5
      V\n.5 g 2813 2429 N 233 5 0 -113 -233 -5 h\n1.000 UP\n1.000
      UL\nLT2\n2813 2429 M\n0 -113 V\n-233 -5 V\n0 113 V\n233 5 V\n.5448 g
      2810 2544 N 233 5 1 -114 -231 -6 h\n1.000 UP\n1.000 UL\nLT2\n2810 2544
      M\n3 -115 V\n-233 -5 V\n-1 114 V\n231 6 V\n.5892 g 2806 2658 N 231 6 0
      -115 -227 -5 h\n1.000 UP\n1.000 UL\nLT2\n2806 2658 M\n4 -114 V\n-231 -6
      V\n0 115 V\n227 5 V\n.6329 g 2799 2772 N 227 5 2 -114 -222 -5 h\n1.000
      UP\n1.000 UL\nLT2\n2799 2772 M\n7 -114 V\n-227 -5 V\n-2 114 V\n222 5
      V\n.6755 g 2789 2885 N 222 5 2 -113 -214 -5 h\n1.000 UP\n1.000
      UL\nLT2\n2789 2885 M\n10 -113 V\n-222 -5 V\n-2 113 V\n214 5 V\n.7167 g
      2778 2995 N 214 5 2 -111 -205 -4 h\n1.000 UP\n1.000 UL\nLT2\n2778 2995
      M\n11 -110 V\n-214 -5 V\n-2 111 V\n205 4 V\n.7562 g 2765 3102 N 205 4 3
      -107 -195 -4 h\n1.000 UP\n1.000 UL\nLT2\n2765 3102 M\n13 -107 V\n-205
      -4 V\n-3 107 V\n195 4 V\n.7936 g 2749 3205 N 195 4 3 -103 -182 -4
      h\n1.000 UP\n1.000 UL\nLT2\n2749 3205 M\n16 -103 V\n-195 -4 V\n-3 103
      V\n182 4 V\n.8286 g 2732 3303 N 182 4 3 -98 -168 -4 h\n1.000 UP\n1.000
      UL\nLT2\n2732 3303 M\n17 -98 V\n-182 -4 V\n-3 98 V\n168 4 V\n.861 g
      2713 3395 N 168 4 4 -93 -153 -3 h\n1.000 UP\n1.000 UL\nLT2\n2713 3395
      M\n19 -92 V\n-168 -4 V\n-4 93 V\n153 3 V\n.8905 g 2693 3481 N 153 3 4
      -86 -137 -3 h\n1.000 UP\n1.000 UL\nLT2\n2693 3481 M\n20 -86 V\n-153 -3
      V\n-4 86 V\n137 3 V\n.9169 g 2671 3559 N 137 3 5 -79 -120 -2 h\n1.000
      UP\n1.000 UL\nLT2\n2671 3559 M\n22 -78 V\n-137 -3 V\n-5 79 V\n120 2
      V\n.9399 g 2648 3630 N 120 2 4 -71 -101 -2 h\n1.000 UP\n1.000
      UL\nLT2\n2648 3630 M\n23 -71 V\n-120 -2 V\n-4 71 V\n101 2 V\n.9593 g
      2624 3693 N 101 2 5 -63 -82 -2 h\n1.000 UP\n1.000 UL\nLT2\n2624 3693
      M\n24 -63 V\n-101 -2 V\n-5 63 V\n82 2 V\n.975 g 2599 3746 N 82 2 5 -54
      -62 -1 h\n1.000 UP\n1.000 UL\nLT2\n2599 3746 M\n25 -53 V\n-82 -2 V\n-5
      54 V\n62 1 V\n.987 g 2573 3790 N 62 1 5 -44 -41 -1 h\n1.000 UP\n1.000
      UL\nLT2\n2573 3790 M\n26 -44 V\n-62 -1 V\n-5 44 V\n41 1 V\n.995 g 2547
      3825 N 41 1 6 -35 -21 -1 h\n1.000 UP\n1.000 UL\nLT2\n2547 3825 M\n26
      -35 V\n-41 -1 V\n-6 35 V\n21 1 V\n.999 g 2521 3849 N 21 1 5 -25 0 0
      h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n26 -24 V\n-21 -1 V\n-5 25
      V\n.001 g 2526 1315 N 0 0 16 15 -21 0 h\n1.000 UP\n1.000 UL\nLT2\n2526
      1315 M\n-5 15 V\n-16 -15 V\n21 0 V\n.005 g 2532 1310 N 21 0 15 4 -42 1
      h\n1.000 UP\n1.000 UL\nLT2\n2532 1310 M\n-6 5 V\n-21 0 V\n-15 -4 V\n42
      -1 V\n.013 g 2537 1316 N 42 -1 16 -6 -63 1 h\n1.000 UP\n1.000
      UL\nLT2\n2537 1316 M\n-5 -6 V\n-42 1 V\n-16 6 V\n63 -1 V\n.025 g 2542
      1332 N 63 -1 15 -16 -83 1 h\n1.000 UP\n1.000 UL\nLT2\n2542 1332 M\n-5
      -16 V\n-63 1 V\n-15 16 V\n83 -1 V\n.0407 g 2547 1358 N 83 -1 14 -26
      -102 1 h\n1.000 UP\n1.000 UL\nLT2\n2547 1358 M\n-5 -26 V\n-83 1 V\n-14
      26 V\n102 -1 V\n.0601 g 2551 1394 N 102 -1 14 -36 -120 1 h\n1.000
      UP\n1.000 UL\nLT2\n2551 1394 M\n-4 -36 V\n-102 1 V\n-14 36 V\n120 -1
      V\n.0831 g 2556 1440 N 120 -1 13 -46 -138 1 h\n1.000 UP\n1.000
      UL\nLT2\n2556 1440 M\n-5 -46 V\n-120 1 V\n-13 46 V\n138 -1 V\n.1095 g
      2560 1495 N 138 -1 13 -55 -155 1 h\n1.000 UP\n1.000 UL\nLT2\n2560 1495
      M\n-4 -55 V\n-138 1 V\n-13 55 V\n155 -1 V\n.139 g 2564 1558 N 155 -1 11
      -64 -170 2 h\n1.000 UP\n1.000 UL\nLT2\n2564 1558 M\n-4 -63 V\n-155 1
      V\n-11 64 V\n170 -2 V\n.1714 g 2567 1630 N 170 -2 10 -72 -183 2
      h\n1.000 UP\n1.000 UL\nLT2\n2567 1630 M\n-3 -72 V\n-170 2 V\n-10 72
      V\n183 -2 V\n.2064 g 2570 1710 N 183 -2 10 -80 -196 2 h\n1.000
      UP\n1.000 UL\nLT2\n2570 1710 M\n-3 -80 V\n-183 2 V\n-10 80 V\n196 -2
      V\n.2438 g 2573 1797 N 196 -2 8 -86 -207 1 h\n1.000 UP\n1.000
      UL\nLT2\n2573 1797 M\n-3 -87 V\n-196 2 V\n-8 86 V\n207 -1 V\n.2833 g
      2575 1890 N 207 -1 7 -94 -216 2 h\n1.000 UP\n1.000 UL\nLT2\n2575 1890
      M\n-2 -93 V\n-207 1 V\n-7 94 V\n216 -2 V\n.3245 g 2577 1989 N 216 -2 5
      -99 -223 2 h\n1.000 UP\n1.000 UL\nLT2\n2577 1989 M\n-2 -99 V\n-216 2
      V\n-5 99 V\n223 -2 V\n.3671 g 2579 2092 N 223 -2 4 -103 -229 2 h\n1.000
      UP\n1.000 UL\nLT2\n2579 2092 M\n-2 -103 V\n-223 2 V\n-4 103 V\n229 -2
      V\n.4108 g 2579 2200 N 229 -2 3 -108 -232 2 h\n1.000 UP\n1.000
      UL\nLT2\n2579 2200 M\n0 -108 V\n-229 2 V\n-3 108 V\n232 -2 V\n.4552 g
      2580 2311 N 232 -2 2 -111 -235 2 h\n1.000 UP\n1.000 UL\nLT2\n2580 2311
      M\n-1 -111 V\n-232 2 V\n-2 111 V\n235 -2 V\n.5 g 2580 2424 N 235 -2 0
      -113 -235 2 h\n1.000 UP\n1.000 UL\nLT2\n2580 2424 M\n0 -113 V\n-235 2
      V\n0 113 V\n235 -2 V\n.5448 g 2579 2538 N 235 -2 -2 -114 -232 2
      h\n1.000 UP\n1.000 UL\nLT2\n2579 2538 M\n1 -114 V\n-235 2 V\n2 114
      V\n232 -2 V\n.5892 g 2579 2653 N 232 -2 -3 -115 -229 2 h\n1.000
      UP\n1.000 UL\nLT2\n2579 2653 M\n0 -115 V\n-232 2 V\n3 115 V\n229 -2
      V\n.6329 g 2577 2767 N 229 -2 -4 -114 -223 2 h\n1.000 UP\n1.000
      UL\nLT2\n2577 2767 M\n2 -114 V\n-229 2 V\n4 114 V\n223 -2 V\n.6755 g
      2575 2880 N 223 -2 -5 -113 -216 2 h\n1.000 UP\n1.000 UL\nLT2\n2575 2880
      M\n2 -113 V\n-223 2 V\n5 113 V\n216 -2 V\n.7167 g 2573 2991 N 216 -2 -7
      -110 -207 1 h\n1.000 UP\n1.000 UL\nLT2\n2573 2991 M\n2 -111 V\n-216 2
      V\n7 110 V\n207 -1 V\n.7562 g 2570 3098 N 207 -1 -8 -107 -196 1
      h\n1.000 UP\n1.000 UL\nLT2\n2570 3098 M\n3 -107 V\n-207 1 V\n8 107
      V\n196 -1 V\n.7936 g 2567 3201 N 196 -1 -10 -103 -183 1 h\n1.000
      UP\n1.000 UL\nLT2\n2567 3201 M\n3 -103 V\n-196 1 V\n10 103 V\n183 -1
      V\n.8286 g 2564 3299 N 183 -1 -10 -99 -170 2 h\n1.000 UP\n1.000
      UL\nLT2\n2564 3299 M\n3 -98 V\n-183 1 V\n10 99 V\n170 -2 V\n.861 g 2560
      3392 N 170 -2 -11 -92 -155 1 h\n1.000 UP\n1.000 UL\nLT2\n2560 3392 M\n4
      -93 V\n-170 2 V\n11 92 V\n155 -1 V\n.8905 g 2556 3478 N 155 -1 -13 -86
      -138 1 h\n1.000 UP\n1.000 UL\nLT2\n2556 3478 M\n4 -86 V\n-155 1 V\n13
      86 V\n138 -1 V\n.9169 g 2551 3557 N 138 -1 -13 -79 -120 1 h\n1.000
      UP\n1.000 UL\nLT2\n2551 3557 M\n5 -79 V\n-138 1 V\n13 79 V\n120 -1
      V\n.9399 g 2547 3628 N 120 -1 -14 -71 -102 1 h\n1.000 UP\n1.000
      UL\nLT2\n2547 3628 M\n4 -71 V\n-120 1 V\n14 71 V\n102 -1 V\n.9593 g
      2542 3691 N 102 -1 -14 -62 -83 0 h\n1.000 UP\n1.000 UL\nLT2\n2542 3691
      M\n5 -63 V\n-102 1 V\n14 62 V\n83 0 V\n.975 g 2537 3745 N 83 0 -15 -54
      -63 0 h\n1.000 UP\n1.000 UL\nLT2\n2537 3745 M\n5 -54 V\n-83 0 V\n15 54
      V\n63 0 V\n.987 g 2532 3789 N 63 0 -16 -44 -42 0 h\n1.000 UP\n1.000
      UL\nLT2\n2532 3789 M\n5 -44 V\n-63 0 V\n16 44 V\n42 0 V\n.995 g 2526
      3824 N 42 0 -15 -35 -21 0 h\n1.000 UP\n1.000 UL\nLT2\n2526 3824 M\n6
      -35 V\n-42 0 V\n15 35 V\n21 0 V\n.999 g 2521 3849 N 21 0 -16 -25 0 0
      h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n5 -25 V\n-21 0 V\n16 25
      V\n.001 g 2505 1315 N 0 0 36 14 -20 1 h\n1.000 UP\n1.000 UL\nLT2\n2505
      1315 M\n16 15 V\n-36 -14 V\n20 -1 V\n.005 g 2490 1311 N 20 -1 36 4 -41
      1 h\n1.000 UP\n1.000 UL\nLT2\n2490 1311 M\n15 4 V\n-20 1 V\n-36 -4
      V\n41 -1 V\n.013 g 2474 1317 N 41 -1 36 -7 -61 2 h\n1.000 UP\n1.000
      UL\nLT2\n2474 1317 M\n16 -6 V\n-41 1 V\n-36 7 V\n61 -2 V\n.025 g 2459
      1333 N 61 -2 34 -17 -80 3 h\n1.000 UP\n1.000 UL\nLT2\n2459 1333 M\n15
      -16 V\n-61 2 V\n-34 17 V\n80 -3 V\n.0407 g 2445 1359 N 80 -3 34 -27
      -100 4 h\n1.000 UP\n1.000 UL\nLT2\n2445 1359 M\n14 -26 V\n-80 3 V\n-34
      27 V\n100 -4 V\n.0601 g 2431 1395 N 100 -4 32 -37 -118 5 h\n1.000
      UP\n1.000 UL\nLT2\n2431 1395 M\n14 -36 V\n-100 4 V\n-32 37 V\n118 -5
      V\n.0831 g 2418 1441 N 118 -5 30 -46 -135 5 h\n1.000 UP\n1.000
      UL\nLT2\n2418 1441 M\n13 -46 V\n-118 5 V\n-30 46 V\n135 -5 V\n.1095 g
      2405 1496 N 135 -5 29 -56 -151 6 h\n1.000 UP\n1.000 UL\nLT2\n2405 1496
      M\n13 -55 V\n-135 5 V\n-29 56 V\n151 -6 V\n.139 g 2394 1560 N 151 -6 26
      -64 -166 6 h\n1.000 UP\n1.000 UL\nLT2\n2394 1560 M\n11 -64 V\n-151 6
      V\n-26 64 V\n166 -6 V\n.1714 g 2384 1632 N 166 -6 24 -73 -180 7
      h\n1.000 UP\n1.000 UL\nLT2\n2384 1632 M\n10 -72 V\n-166 6 V\n-24 73
      V\n180 -7 V\n.2064 g 2374 1712 N 180 -7 21 -80 -191 7 h\n1.000
      UP\n1.000 UL\nLT2\n2374 1712 M\n10 -80 V\n-180 7 V\n-21 80 V\n191 -7
      V\n.2438 g 2366 1798 N 191 -7 19 -87 -202 8 h\n1.000 UP\n1.000
      UL\nLT2\n2366 1798 M\n8 -86 V\n-191 7 V\n-19 87 V\n202 -8 V\n.2833 g
      2359 1892 N 202 -8 16 -94 -211 8 h\n1.000 UP\n1.000 UL\nLT2\n2359 1892
      M\n7 -94 V\n-202 8 V\n-16 94 V\n211 -8 V\n.3245 g 2354 1991 N 211 -8 12
      -99 -218 8 h\n1.000 UP\n1.000 UL\nLT2\n2354 1991 M\n5 -99 V\n-211 8
      V\n-12 99 V\n218 -8 V\n.3671 g 2350 2094 N 218 -8 10 -104 -224 9
      h\n1.000 UP\n1.000 UL\nLT2\n2350 2094 M\n4 -103 V\n-218 8 V\n-10 104
      V\n224 -9 V\n.4108 g 2347 2202 N 224 -9 6 -108 -227 9 h\n1.000
      UP\n1.000 UL\nLT2\n2347 2202 M\n3 -108 V\n-224 9 V\n-6 108 V\n227 -9
      V\n.4552 g 2345 2313 N 227 -9 4 -111 -229 9 h\n1.000 UP\n1.000
      UL\nLT2\n2345 2313 M\n2 -111 V\n-227 9 V\n-4 111 V\n229 -9 V\n.5 g 2345
      2426 N 229 -9 0 -113 -229 9 h\n1.000 UP\n1.000 UL\nLT2\n2345 2426 M\n0
      -113 V\n-229 9 V\n0 113 V\n229 -9 V\n.5448 g 2347 2540 N 229 -9 -4 -114
      -227 9 h\n1.000 UP\n1.000 UL\nLT2\n2347 2540 M\n-2 -114 V\n-229 9 V\n4
      114 V\n227 -9 V\n.5892 g 2350 2655 N 227 -9 -6 -114 -224 8 h\n1.000
      UP\n1.000 UL\nLT2\n2350 2655 M\n-3 -115 V\n-227 9 V\n6 114 V\n224 -8
      V\n.6329 g 2354 2769 N 224 -8 -10 -114 -218 8 h\n1.000 UP\n1.000
      UL\nLT2\n2354 2769 M\n-4 -114 V\n-224 8 V\n10 114 V\n218 -8 V\n.6755 g
      2359 2882 N 218 -8 -12 -113 -211 8 h\n1.000 UP\n1.000 UL\nLT2\n2359
      2882 M\n-5 -113 V\n-218 8 V\n12 113 V\n211 -8 V\n.7167 g 2366 2992 N
      211 -8 -16 -110 -202 8 h\n1.000 UP\n1.000 UL\nLT2\n2366 2992 M\n-7 -110
      V\n-211 8 V\n16 110 V\n202 -8 V\n.7562 g 2374 3099 N 202 -8 -19 -107
      -191 8 h\n1.000 UP\n1.000 UL\nLT2\n2374 3099 M\n-8 -107 V\n-202 8 V\n19
      107 V\n191 -8 V\n.7936 g 2384 3202 N 191 -8 -21 -102 -180 7 h\n1.000
      UP\n1.000 UL\nLT2\n2384 3202 M\n-10 -103 V\n-191 8 V\n21 102 V\n180 -7
      V\n.8286 g 2394 3301 N 180 -7 -24 -98 -166 6 h\n1.000 UP\n1.000
      UL\nLT2\n2394 3301 M\n-10 -99 V\n-180 7 V\n24 98 V\n166 -6 V\n.861 g
      2405 3393 N 166 -6 -26 -92 -151 6 h\n1.000 UP\n1.000 UL\nLT2\n2405 3393
      M\n-11 -92 V\n-166 6 V\n26 92 V\n151 -6 V\n.8905 g 2418 3479 N 151 -6
      -29 -85 -135 5 h\n1.000 UP\n1.000 UL\nLT2\n2418 3479 M\n-13 -86 V\n-151
      6 V\n29 85 V\n135 -5 V\n.9169 g 2431 3558 N 135 -5 -30 -78 -118 4
      h\n1.000 UP\n1.000 UL\nLT2\n2431 3558 M\n-13 -79 V\n-135 5 V\n30 78
      V\n118 -4 V\n.9399 g 2445 3629 N 118 -4 -32 -71 -100 4 h\n1.000
      UP\n1.000 UL\nLT2\n2445 3629 M\n-14 -71 V\n-118 4 V\n32 71 V\n100 -4
      V\n.9593 g 2459 3691 N 100 -4 -34 -61 -80 3 h\n1.000 UP\n1.000
      UL\nLT2\n2459 3691 M\n-14 -62 V\n-100 4 V\n34 61 V\n80 -3 V\n.975 g
      2474 3745 N 80 -3 -34 -53 -61 2 h\n1.000 UP\n1.000 UL\nLT2\n2474 3745
      M\n-15 -54 V\n-80 3 V\n34 53 V\n61 -2 V\n.987 g 2490 3789 N 61 -2 -36
      -44 -41 2 h\n1.000 UP\n1.000 UL\nLT2\n2490 3789 M\n-16 -44 V\n-61 2
      V\n36 44 V\n41 -2 V\n.995 g 2505 3824 N 41 -2 -36 -34 -20 1 h\n1.000
      UP\n1.000 UL\nLT2\n2505 3824 M\n-15 -35 V\n-41 2 V\n36 34 V\n20 -1
      V\n.999 g 2521 3849 N 20 -1 -36 -24 0 0 h\n1.000 UP\n1.000
      UL\nLT2\n2521 3849 M\n-16 -25 V\n-20 1 V\n36 24 V\n.001 g 2485 1316 N 0
      0 56 13 -20 1 h\n1.000 UP\n1.000 UL\nLT2\n2485 1316 M\n36 14 V\n-56 -13
      V\n20 -1 V\n.005 g 2449 1312 N 20 -1 55 2 -39 3 h\n1.000 UP\n1.000
      UL\nLT2\n2449 1312 M\n36 4 V\n-20 1 V\n-55 -2 V\n39 -3 V\n.013 g 2413
      1319 N 39 -3 54 -8 -57 4 h\n1.000 UP\n1.000 UL\nLT2\n2413 1319 M\n36 -7
      V\n-39 3 V\n-54 8 V\n57 -4 V\n.025 g 2379 1336 N 57 -4 53 -18 -76 5
      h\n1.000 UP\n1.000 UL\nLT2\n2379 1336 M\n34 -17 V\n-57 4 V\n-53 18
      V\n76 -5 V\n.0407 g 2345 1363 N 76 -5 52 -29 -94 7 h\n1.000 UP\n1.000
      UL\nLT2\n2345 1363 M\n34 -27 V\n-76 5 V\n-52 29 V\n94 -7 V\n.0601 g
      2313 1400 N 94 -7 49 -38 -111 8 h\n1.000 UP\n1.000 UL\nLT2\n2313 1400
      M\n32 -37 V\n-94 7 V\n-49 38 V\n111 -8 V\n.0831 g 2283 1446 N 111 -8 46
      -47 -127 9 h\n1.000 UP\n1.000 UL\nLT2\n2283 1446 M\n30 -46 V\n-111 8
      V\n-46 47 V\n127 -9 V\n.1095 g 2254 1502 N 127 -9 44 -57 -142 10
      h\n1.000 UP\n1.000 UL\nLT2\n2254 1502 M\n29 -56 V\n-127 9 V\n-44 57
      V\n142 -10 V\n.139 g 2228 1566 N 142 -10 40 -65 -156 11 h\n1.000
      UP\n1.000 UL\nLT2\n2228 1566 M\n26 -64 V\n-142 10 V\n-40 65 V\n156 -11
      V\n.1714 g 2204 1639 N 156 -11 37 -74 -169 12 h\n1.000 UP\n1.000
      UL\nLT2\n2204 1639 M\n24 -73 V\n-156 11 V\n-37 74 V\n169 -12 V\n.2064 g
      2183 1719 N 169 -12 33 -81 -181 13 h\n1.000 UP\n1.000 UL\nLT2\n2183
      1719 M\n21 -80 V\n-169 12 V\n-33 81 V\n181 -13 V\n.2438 g 2164 1806 N
      181 -13 28 -88 -190 14 h\n1.000 UP\n1.000 UL\nLT2\n2164 1806 M\n19 -87
      V\n-181 13 V\n-28 88 V\n190 -14 V\n.2833 g 2148 1900 N 190 -14 24 -94
      -198 14 h\n1.000 UP\n1.000 UL\nLT2\n2148 1900 M\n16 -94 V\n-190 14
      V\n-24 94 V\n198 -14 V\n.3245 g 2136 1999 N 198 -14 20 -100 -206 15
      h\n1.000 UP\n1.000 UL\nLT2\n2136 1999 M\n12 -99 V\n-198 14 V\n-20 100
      V\n206 -15 V\n.3671 g 2126 2103 N 206 -15 15 -104 -211 15 h\n1.000
      UP\n1.000 UL\nLT2\n2126 2103 M\n10 -104 V\n-206 15 V\n-15 104 V\n211
      -15 V\n.4108 g 2120 2211 N 211 -15 10 -108 -215 15 h\n1.000 UP\n1.000
      UL\nLT2\n2120 2211 M\n6 -108 V\n-211 15 V\n-10 108 V\n215 -15 V\n.4552
      g 2116 2322 N 215 -15 5 -111 -216 15 h\n1.000 UP\n1.000 UL\nLT2\n2116
      2322 M\n4 -111 V\n-215 15 V\n-5 111 V\n216 -15 V\n.5 g 2116 2435 N 216
      -15 0 -113 -216 15 h\n1.000 UP\n1.000 UL\nLT2\n2116 2435 M\n0 -113
      V\n-216 15 V\n0 113 V\n216 -15 V\n.5448 g 2120 2549 N 216 -15 -5 -114
      -215 15 h\n1.000 UP\n1.000 UL\nLT2\n2120 2549 M\n-4 -114 V\n-216 15
      V\n5 114 V\n215 -15 V\n.5892 g 2126 2663 N 215 -15 -10 -115 -211 16
      h\n1.000 UP\n1.000 UL\nLT2\n2126 2663 M\n-6 -114 V\n-215 15 V\n10 115
      V\n211 -16 V\n.6329 g 2136 2777 N 211 -16 -15 -113 -206 15 h\n1.000
      UP\n1.000 UL\nLT2\n2136 2777 M\n-10 -114 V\n-211 16 V\n15 113 V\n206
      -15 V\n.6755 g 2148 2890 N 206 -15 -20 -112 -198 14 h\n1.000 UP\n1.000
      UL\nLT2\n2148 2890 M\n-12 -113 V\n-206 15 V\n20 112 V\n198 -14 V\n.7167
      g 2164 3000 N 198 -14 -24 -110 -190 14 h\n1.000 UP\n1.000 UL\nLT2\n2164
      3000 M\n-16 -110 V\n-198 14 V\n24 110 V\n190 -14 V\n.7562 g 2183 3107 N
      190 -14 -28 -106 -181 13 h\n1.000 UP\n1.000 UL\nLT2\n2183 3107 M\n-19
      -107 V\n-190 14 V\n28 106 V\n181 -13 V\n.7936 g 2204 3209 N 181 -13 -33
      -102 -169 13 h\n1.000 UP\n1.000 UL\nLT2\n2204 3209 M\n-21 -102 V\n-181
      13 V\n33 102 V\n169 -13 V\n.8286 g 2228 3307 N 169 -13 -37 -96 -156 11
      h\n1.000 UP\n1.000 UL\nLT2\n2228 3307 M\n-24 -98 V\n-169 13 V\n37 96
      V\n156 -11 V\n.861 g 2254 3399 N 156 -11 -40 -91 -142 10 h\n1.000
      UP\n1.000 UL\nLT2\n2254 3399 M\n-26 -92 V\n-156 11 V\n40 91 V\n142 -10
      V\n.8905 g 2283 3484 N 142 -10 -44 -84 -127 9 h\n1.000 UP\n1.000
      UL\nLT2\n2283 3484 M\n-29 -85 V\n-142 10 V\n44 84 V\n127 -9 V\n.9169 g
      2313 3562 N 127 -9 -46 -77 -111 8 h\n1.000 UP\n1.000 UL\nLT2\n2313 3562
      M\n-30 -78 V\n-127 9 V\n46 77 V\n111 -8 V\n.9399 g 2345 3633 N 111 -8
      -49 -69 -94 6 h\n1.000 UP\n1.000 UL\nLT2\n2345 3633 M\n-32 -71 V\n-111
      8 V\n49 69 V\n94 -6 V\n.9593 g 2379 3694 N 94 -6 -52 -61 -76 6 h\n1.000
      UP\n1.000 UL\nLT2\n2379 3694 M\n-34 -61 V\n-94 6 V\n52 61 V\n76 -6
      V\n.975 g 2413 3747 N 76 -6 -53 -52 -57 5 h\n1.000 UP\n1.000
      UL\nLT2\n2413 3747 M\n-34 -53 V\n-76 6 V\n53 52 V\n57 -5 V\n.987 g 2449
      3791 N 57 -5 -54 -42 -39 3 h\n1.000 UP\n1.000 UL\nLT2\n2449 3791 M\n-36
      -44 V\n-57 5 V\n54 42 V\n39 -3 V\n.995 g 2485 3825 N 39 -3 -55 -32 -20
      1 h\n1.000 UP\n1.000 UL\nLT2\n2485 3825 M\n-36 -34 V\n-39 3 V\n55 32
      V\n20 -1 V\n.999 g 2521 3849 N 20 -1 -56 -23 0 0 h\n1.000 UP\n1.000
      UL\nLT2\n2521 3849 M\n-36 -24 V\n-20 1 V\n56 23 V\n.001 g 2465 1317 N 0
      0 73 11 -17 2 h\n1.000 UP\n1.000 UL\nLT2\n2465 1317 M\n56 13 V\n-73 -11
      V\n17 -2 V\n.005 g 2410 1315 N 17 -2 73 0 -35 4 h\n1.000 UP\n1.000
      UL\nLT2\n2410 1315 M\n55 2 V\n-17 2 V\n-73 0 V\n35 -4 V\n.013 g 2356
      1323 N 35 -4 71 -10 -52 6 h\n1.000 UP\n1.000 UL\nLT2\n2356 1323 M\n54
      -8 V\n-35 4 V\n-71 10 V\n52 -6 V\n.025 g 2303 1341 N 52 -6 70 -20 -69 8
      h\n1.000 UP\n1.000 UL\nLT2\n2303 1341 M\n53 -18 V\n-52 6 V\n-70 20
      V\n69 -8 V\n.0407 g 2251 1370 N 69 -8 68 -30 -85 9 h\n1.000 UP\n1.000
      UL\nLT2\n2251 1370 M\n52 -29 V\n-69 8 V\n-68 30 V\n85 -9 V\n.0601 g
      2202 1408 N 85 -9 64 -40 -100 11 h\n1.000 UP\n1.000 UL\nLT2\n2202 1408
      M\n49 -38 V\n-85 9 V\n-64 40 V\n100 -11 V\n.0831 g 2156 1455 N 100 -11
      61 -49 -115 13 h\n1.000 UP\n1.000 UL\nLT2\n2156 1455 M\n46 -47 V\n-100
      11 V\n-61 49 V\n115 -13 V\n.1095 g 2112 1512 N 115 -13 58 -58 -129 14
      h\n1.000 UP\n1.000 UL\nLT2\n2112 1512 M\n44 -57 V\n-115 13 V\n-58 58
      V\n129 -14 V\n.139 g 2072 1577 N 129 -14 53 -67 -142 16 h\n1.000
      UP\n1.000 UL\nLT2\n2072 1577 M\n40 -65 V\n-129 14 V\n-53 67 V\n142 -16
      V\n.1714 g 2035 1651 N 142 -16 48 -75 -153 17 h\n1.000 UP\n1.000
      UL\nLT2\n2035 1651 M\n37 -74 V\n-142 16 V\n-48 75 V\n153 -17 V\n.2064 g
      2002 1732 N 153 -17 43 -82 -163 18 h\n1.000 UP\n1.000 UL\nLT2\n2002
      1732 M\n33 -81 V\n-153 17 V\n-43 82 V\n163 -18 V\n.2438 g 1974 1820 N
      163 -18 38 -89 -173 19 h\n1.000 UP\n1.000 UL\nLT2\n1974 1820 M\n28 -88
      V\n-163 18 V\n-38 89 V\n173 -19 V\n.2833 g 1950 1914 N 173 -19 32 -95
      -181 20 h\n1.000 UP\n1.000 UL\nLT2\n1950 1914 M\n24 -94 V\n-173 19
      V\n-32 95 V\n181 -20 V\n.3245 g 1930 2014 N 181 -20 26 -101 -187 21
      h\n1.000 UP\n1.000 UL\nLT2\n1930 2014 M\n20 -100 V\n-181 20 V\n-26 101
      V\n187 -21 V\n.3671 g 1915 2118 N 187 -21 19 -105 -191 22 h\n1.000
      UP\n1.000 UL\nLT2\n1915 2118 M\n15 -104 V\n-187 21 V\n-19 105 V\n191
      -22 V\n.4108 g 1905 2226 N 191 -22 13 -108 -194 22 h\n1.000 UP\n1.000
      UL\nLT2\n1905 2226 M\n10 -108 V\n-191 22 V\n-13 108 V\n194 -22 V\n.4552
      g 1900 2337 N 194 -22 7 -111 -196 22 h\n1.000 UP\n1.000 UL\nLT2\n1900
      2337 M\n5 -111 V\n-194 22 V\n-7 111 V\n196 -22 V\n.5 g 1900 2450 N 196
      -22 0 -113 -196 22 h\n1.000 UP\n1.000 UL\nLT2\n1900 2450 M\n0 -113
      V\n-196 22 V\n0 113 V\n196 -22 V\n.5448 g 1905 2564 N 196 -22 -7 -114
      -194 22 h\n1.000 UP\n1.000 UL\nLT2\n1905 2564 M\n-5 -114 V\n-196 22
      V\n7 114 V\n194 -22 V\n.5892 g 1915 2679 N 194 -22 -13 -114 -191 21
      h\n1.000 UP\n1.000 UL\nLT2\n1915 2679 M\n-10 -115 V\n-194 22 V\n13 114
      V\n191 -21 V\n.6329 g 1930 2792 N 191 -21 -19 -113 -187 21 h\n1.000
      UP\n1.000 UL\nLT2\n1930 2792 M\n-15 -113 V\n-191 21 V\n19 113 V\n187
      -21 V\n.6755 g 1950 2904 N 187 -21 -26 -112 -181 21 h\n1.000 UP\n1.000
      UL\nLT2\n1950 2904 M\n-20 -112 V\n-187 21 V\n26 112 V\n181 -21 V\n.7167
      g 1974 3014 N 181 -21 -32 -108 -173 19 h\n1.000 UP\n1.000 UL\nLT2\n1974
      3014 M\n-24 -110 V\n-181 21 V\n32 108 V\n173 -19 V\n.7562 g 2002 3120 N
      173 -19 -38 -105 -163 18 h\n1.000 UP\n1.000 UL\nLT2\n2002 3120 M\n-28
      -106 V\n-173 19 V\n38 105 V\n163 -18 V\n.7936 g 2035 3222 N 163 -18 -43
      -101 -153 17 h\n1.000 UP\n1.000 UL\nLT2\n2035 3222 M\n-33 -102 V\n-163
      18 V\n43 101 V\n153 -17 V\n.8286 g 2072 3318 N 153 -17 -48 -95 -142 16
      h\n1.000 UP\n1.000 UL\nLT2\n2072 3318 M\n-37 -96 V\n-153 17 V\n48 95
      V\n142 -16 V\n.861 g 2112 3409 N 142 -16 -53 -90 -129 15 h\n1.000
      UP\n1.000 UL\nLT2\n2112 3409 M\n-40 -91 V\n-142 16 V\n53 90 V\n129 -15
      V\n.8905 g 2156 3493 N 129 -15 -58 -82 -115 13 h\n1.000 UP\n1.000
      UL\nLT2\n2156 3493 M\n-44 -84 V\n-129 15 V\n58 82 V\n115 -13 V\n.9169 g
      2202 3570 N 115 -13 -61 -76 -100 12 h\n1.000 UP\n1.000 UL\nLT2\n2202
      3570 M\n-46 -77 V\n-115 13 V\n61 76 V\n100 -12 V\n.9399 g 2251 3639 N
      100 -12 -64 -67 -85 10 h\n1.000 UP\n1.000 UL\nLT2\n2251 3639 M\n-49 -69
      V\n-100 12 V\n64 67 V\n85 -10 V\n.9593 g 2303 3700 N 85 -10 -68 -59 -69
      8 h\n1.000 UP\n1.000 UL\nLT2\n2303 3700 M\n-52 -61 V\n-85 10 V\n68 59
      V\n69 -8 V\n.975 g 2356 3752 N 69 -8 -70 -49 -52 5 h\n1.000 UP\n1.000
      UL\nLT2\n2356 3752 M\n-53 -52 V\n-69 8 V\n70 49 V\n52 -5 V\n.987 g 2410
      3794 N 52 -5 -71 -41 -35 4 h\n1.000 UP\n1.000 UL\nLT2\n2410 3794 M\n-54
      -42 V\n-52 5 V\n71 41 V\n35 -4 V\n.995 g 2465 3826 N 35 -4 -73 -30 -17
      2 h\n1.000 UP\n1.000 UL\nLT2\n2465 3826 M\n-55 -32 V\n-35 4 V\n73 30
      V\n17 -2 V\n.999 g 2521 3849 N 17 -2 -73 -21 0 0 h\n1.000 UP\n1.000
      UL\nLT2\n2521 3849 M\n-56 -23 V\n-17 2 V\n73 21 V\n.001 g 2448 1319 N 0
      0 88 8 -15 3 h\n1.000 UP\n1.000 UL\nLT2\n2448 1319 M\n73 11 V\n-88 -8
      V\n15 -3 V\n.005 g 2375 1319 N 15 -3 88 -2 -30 5 h\n1.000 UP\n1.000
      UL\nLT2\n2375 1319 M\n73 0 V\n-15 3 V\n-88 2 V\n30 -5 V\n.013 g 2304
      1329 N 30 -5 87 -12 -46 7 h\n1.000 UP\n1.000 UL\nLT2\n2304 1329 M\n71
      -10 V\n-30 5 V\n-87 12 V\n46 -7 V\n.025 g 2234 1349 N 46 -7 84 -23 -60
      10 h\n1.000 UP\n1.000 UL\nLT2\n2234 1349 M\n70 -20 V\n-46 7 V\n-84 23
      V\n60 -10 V\n.0407 g 2166 1379 N 60 -10 81 -32 -73 12 h\n1.000
      UP\n1.000 UL\nLT2\n2166 1379 M\n68 -30 V\n-60 10 V\n-81 32 V\n73 -12
      V\n.0601 g 2102 1419 N 73 -12 78 -42 -87 14 h\n1.000 UP\n1.000
      UL\nLT2\n2102 1419 M\n64 -40 V\n-73 12 V\n-78 42 V\n87 -14 V\n.0831 g
      2041 1468 N 87 -14 74 -51 -100 16 h\n1.000 UP\n1.000 UL\nLT2\n2041 1468
      M\n61 -49 V\n-87 14 V\n-74 51 V\n100 -16 V\n.1095 g 1983 1526 N 100 -16
      70 -61 -112 19 h\n1.000 UP\n1.000 UL\nLT2\n1983 1526 M\n58 -58 V\n-100
      16 V\n-70 61 V\n112 -19 V\n.139 g 1930 1593 N 112 -19 64 -68 -123 20
      h\n1.000 UP\n1.000 UL\nLT2\n1930 1593 M\n53 -67 V\n-112 19 V\n-64 68
      V\n123 -20 V\n.1714 g 1882 1668 N 123 -20 58 -77 -133 22 h\n1.000
      UP\n1.000 UL\nLT2\n1882 1668 M\n48 -75 V\n-123 20 V\n-58 77 V\n133 -22
      V\n.2064 g 1839 1750 N 133 -22 52 -83 -142 23 h\n1.000 UP\n1.000
      UL\nLT2\n1839 1750 M\n43 -82 V\n-133 22 V\n-52 83 V\n142 -23 V\n.2438 g
      1801 1839 N 142 -23 46 -91 -150 25 h\n1.000 UP\n1.000 UL\nLT2\n1801
      1839 M\n38 -89 V\n-142 23 V\n-46 91 V\n150 -25 V\n.2833 g 1769 1934 N
      150 -25 38 -96 -156 26 h\n1.000 UP\n1.000 UL\nLT2\n1769 1934 M\n32 -95
      V\n-150 25 V\n-38 96 V\n156 -26 V\n.3245 g 1743 2035 N 156 -26 31 -101
      -161 26 h\n1.000 UP\n1.000 UL\nLT2\n1743 2035 M\n26 -101 V\n-156 26
      V\n-31 101 V\n161 -26 V\n.3671 g 1724 2140 N 161 -26 24 -105 -166 26
      h\n1.000 UP\n1.000 UL\nLT2\n1724 2140 M\n19 -105 V\n-161 26 V\n-24 105
      V\n166 -26 V\n.4108 g 1711 2248 N 166 -26 16 -109 -169 27 h\n1.000
      UP\n1.000 UL\nLT2\n1711 2248 M\n13 -108 V\n-166 26 V\n-16 109 V\n169
      -27 V\n.4552 g 1704 2359 N 169 -27 7 -112 -169 28 h\n1.000 UP\n1.000
      UL\nLT2\n1704 2359 M\n7 -111 V\n-169 27 V\n-7 112 V\n169 -28 V\n.5 g
      1704 2472 N 169 -28 0 -113 -169 28 h\n1.000 UP\n1.000 UL\nLT2\n1704
      2472 M\n0 -113 V\n-169 28 V\n0 113 V\n169 -28 V\n.5448 g 1711 2586 N
      169 -28 -7 -113 -169 27 h\n1.000 UP\n1.000 UL\nLT2\n1711 2586 M\n-7
      -114 V\n-169 28 V\n7 113 V\n169 -27 V\n.5892 g 1724 2700 N 169 -27 -16
      -114 -166 27 h\n1.000 UP\n1.000 UL\nLT2\n1724 2700 M\n-13 -114 V\n-169
      27 V\n16 114 V\n166 -27 V\n.6329 g 1743 2813 N 166 -27 -24 -112 -161 26
      h\n1.000 UP\n1.000 UL\nLT2\n1743 2813 M\n-19 -113 V\n-166 27 V\n24 112
      V\n161 -26 V\n.6755 g 1769 2925 N 161 -26 -31 -111 -156 25 h\n1.000
      UP\n1.000 UL\nLT2\n1769 2925 M\n-26 -112 V\n-161 26 V\n31 111 V\n156
      -25 V\n.7167 g 1801 3033 N 156 -25 -38 -107 -150 24 h\n1.000 UP\n1.000
      UL\nLT2\n1801 3033 M\n-32 -108 V\n-156 25 V\n38 107 V\n150 -24 V\n.7562
      g 1839 3138 N 150 -24 -46 -104 -142 23 h\n1.000 UP\n1.000 UL\nLT2\n1839
      3138 M\n-38 -105 V\n-150 24 V\n46 104 V\n142 -23 V\n.7936 g 1882 3239 N
      142 -23 -52 -99 -133 21 h\n1.000 UP\n1.000 UL\nLT2\n1882 3239 M\n-43
      -101 V\n-142 23 V\n52 99 V\n133 -21 V\n.8286 g 1930 3334 N 133 -21 -58
      -94 -123 20 h\n1.000 UP\n1.000 UL\nLT2\n1930 3334 M\n-48 -95 V\n-133 21
      V\n58 94 V\n123 -20 V\n.861 g 1983 3424 N 123 -20 -64 -88 -112 18
      h\n1.000 UP\n1.000 UL\nLT2\n1983 3424 M\n-53 -90 V\n-123 20 V\n64 88
      V\n112 -18 V\n.8905 g 2041 3506 N 112 -18 -70 -80 -100 16 h\n1.000
      UP\n1.000 UL\nLT2\n2041 3506 M\n-58 -82 V\n-112 18 V\n70 80 V\n100 -16
      V\n.9169 g 2102 3582 N 100 -16 -74 -74 -87 14 h\n1.000 UP\n1.000
      UL\nLT2\n2102 3582 M\n-61 -76 V\n-100 16 V\n74 74 V\n87 -14 V\n.9399 g
      2166 3649 N 87 -14 -78 -65 -73 12 h\n1.000 UP\n1.000 UL\nLT2\n2166 3649
      M\n-64 -67 V\n-87 14 V\n78 65 V\n73 -12 V\n.9593 g 2234 3708 N 73 -12
      -81 -56 -60 9 h\n1.000 UP\n1.000 UL\nLT2\n2234 3708 M\n-68 -59 V\n-73
      12 V\n81 56 V\n60 -9 V\n.975 g 2304 3757 N 60 -9 -84 -48 -46 8 h\n1.000
      UP\n1.000 UL\nLT2\n2304 3757 M\n-70 -49 V\n-60 9 V\n84 48 V\n46 -8
      V\n.987 g 2375 3798 N 46 -8 -87 -38 -30 5 h\n1.000 UP\n1.000
      UL\nLT2\n2375 3798 M\n-71 -41 V\n-46 8 V\n87 38 V\n30 -5 V\n.995 g 2448
      3828 N 30 -5 -88 -28 -15 3 h\n1.000 UP\n1.000 UL\nLT2\n2448 3828 M\n-73
      -30 V\n-30 5 V\n88 28 V\n15 -3 V\n.999 g 2521 3849 N 15 -3 -88 -18 0 0
      h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n-73 -21 V\n-15 3 V\n88 18
      V\n.001 g 2433 1322 N 0 0 101 5 -13 3 h\n1.000 UP\n1.000 UL\nLT2\n2433
      1322 M\n88 8 V\n-101 -5 V\n13 -3 V\n.005 g 2345 1324 N 13 -3 100 -5 -25
      6 h\n1.000 UP\n1.000 UL\nLT2\n2345 1324 M\n88 -2 V\n-13 3 V\n-100 5
      V\n25 -6 V\n.013 g 2258 1336 N 25 -6 98 -15 -36 9 h\n1.000 UP\n1.000
      UL\nLT2\n2258 1336 M\n87 -12 V\n-25 6 V\n-98 15 V\n36 -9 V\n.025 g 2174
      1359 N 36 -9 96 -25 -48 11 h\n1.000 UP\n1.000 UL\nLT2\n2174 1359 M\n84
      -23 V\n-36 9 V\n-96 25 V\n48 -11 V\n.0407 g 2093 1391 N 48 -11 93 -35
      -60 14 h\n1.000 UP\n1.000 UL\nLT2\n2093 1391 M\n81 -32 V\n-48 11 V\n-93
      35 V\n60 -14 V\n.0601 g 2015 1433 N 60 -14 89 -45 -71 17 h\n1.000
      UP\n1.000 UL\nLT2\n2015 1433 M\n78 -42 V\n-60 14 V\n-89 45 V\n71 -17
      V\n.0831 g 1941 1484 N 71 -17 85 -53 -82 19 h\n1.000 UP\n1.000
      UL\nLT2\n1941 1484 M\n74 -51 V\n-71 17 V\n-85 53 V\n82 -19 V\n.1095 g
      1871 1545 N 82 -19 79 -63 -91 21 h\n1.000 UP\n1.000 UL\nLT2\n1871 1545
      M\n70 -61 V\n-82 19 V\n-79 63 V\n91 -21 V\n.139 g 1807 1613 N 91 -21 73
      -71 -100 24 h\n1.000 UP\n1.000 UL\nLT2\n1807 1613 M\n64 -68 V\n-91 21
      V\n-73 71 V\n100 -24 V\n.1714 g 1749 1690 N 100 -24 66 -78 -108 25
      h\n1.000 UP\n1.000 UL\nLT2\n1749 1690 M\n58 -77 V\n-100 24 V\n-66 78
      V\n108 -25 V\n.2064 g 1697 1773 N 108 -25 59 -85 -115 27 h\n1.000
      UP\n1.000 UL\nLT2\n1697 1773 M\n52 -83 V\n-108 25 V\n-59 85 V\n115 -27
      V\n.2438 g 1651 1864 N 115 -27 52 -92 -121 28 h\n1.000 UP\n1.000
      UL\nLT2\n1651 1864 M\n46 -91 V\n-115 27 V\n-52 92 V\n121 -28 V\n.2833 g
      1613 1960 N 121 -28 44 -98 -127 30 h\n1.000 UP\n1.000 UL\nLT2\n1613
      1960 M\n38 -96 V\n-121 28 V\n-44 98 V\n127 -30 V\n.3245 g 1582 2061 N
      127 -30 36 -102 -132 31 h\n1.000 UP\n1.000 UL\nLT2\n1582 2061 M\n31
      -101 V\n-127 30 V\n-36 102 V\n132 -31 V\n.3671 g 1558 2166 N 132 -31 26
      -106 -134 32 h\n1.000 UP\n1.000 UL\nLT2\n1558 2166 M\n24 -105 V\n-132
      31 V\n-26 106 V\n134 -32 V\n.4108 g 1542 2275 N 134 -32 18 -109 -136 32
      h\n1.000 UP\n1.000 UL\nLT2\n1542 2275 M\n16 -109 V\n-134 32 V\n-18 109
      V\n136 -32 V\n.4552 g 1535 2387 N 136 -32 10 -112 -139 32 h\n1.000
      UP\n1.000 UL\nLT2\n1535 2387 M\n7 -112 V\n-136 32 V\n-10 112 V\n139 -32
      V\n.5 g 1535 2500 N 139 -32 0 -113 -139 32 h\n1.000 UP\n1.000
      UL\nLT2\n1535 2500 M\n0 -113 V\n-139 32 V\n0 113 V\n139 -32 V\n.5448 g
      1542 2613 N 139 -32 -10 -113 -136 32 h\n1.000 UP\n1.000 UL\nLT2\n1542
      2613 M\n-7 -113 V\n-139 32 V\n10 113 V\n136 -32 V\n.5892 g 1558 2727 N
      136 -32 -18 -113 -134 31 h\n1.000 UP\n1.000 UL\nLT2\n1558 2727 M\n-16
      -114 V\n-136 32 V\n18 113 V\n134 -31 V\n.6329 g 1582 2839 N 134 -31 -26
      -112 -132 31 h\n1.000 UP\n1.000 UL\nLT2\n1582 2839 M\n-24 -112 V\n-134
      31 V\n26 112 V\n132 -31 V\n.6755 g 1613 2950 N 132 -31 -36 -110 -127 30
      h\n1.000 UP\n1.000 UL\nLT2\n1613 2950 M\n-31 -111 V\n-132 31 V\n36 110
      V\n127 -30 V\n.7167 g 1651 3057 N 127 -30 -44 -106 -121 29 h\n1.000
      UP\n1.000 UL\nLT2\n1651 3057 M\n-38 -107 V\n-127 30 V\n44 106 V\n121
      -29 V\n.7562 g 1697 3161 N 121 -29 -52 -102 -115 27 h\n1.000 UP\n1.000
      UL\nLT2\n1697 3161 M\n-46 -104 V\n-121 29 V\n52 102 V\n115 -27 V\n.7936
      g 1749 3260 N 115 -27 -59 -98 -108 26 h\n1.000 UP\n1.000 UL\nLT2\n1749
      3260 M\n-52 -99 V\n-115 27 V\n59 98 V\n108 -26 V\n.8286 g 1807 3354 N
      108 -26 -66 -91 -100 23 h\n1.000 UP\n1.000 UL\nLT2\n1807 3354 M\n-58
      -94 V\n-108 26 V\n66 91 V\n100 -23 V\n.861 g 1871 3442 N 100 -23 -73
      -86 -91 21 h\n1.000 UP\n1.000 UL\nLT2\n1871 3442 M\n-64 -88 V\n-100 23
      V\n73 86 V\n91 -21 V\n.8905 g 1941 3522 N 91 -21 -79 -78 -82 19
      h\n1.000 UP\n1.000 UL\nLT2\n1941 3522 M\n-70 -80 V\n-91 21 V\n79 78
      V\n82 -19 V\n.9169 g 2015 3596 N 82 -19 -85 -71 -71 16 h\n1.000
      UP\n1.000 UL\nLT2\n2015 3596 M\n-74 -74 V\n-82 19 V\n85 71 V\n71 -16
      V\n.9399 g 2093 3661 N 71 -16 -89 -63 -60 14 h\n1.000 UP\n1.000
      UL\nLT2\n2093 3661 M\n-78 -65 V\n-71 16 V\n89 63 V\n60 -14 V\n.9593 g
      2174 3717 N 60 -14 -93 -54 -48 12 h\n1.000 UP\n1.000 UL\nLT2\n2174 3717
      M\n-81 -56 V\n-60 14 V\n93 54 V\n48 -12 V\n.975 g 2258 3765 N 48 -12
      -96 -44 -36 8 h\n1.000 UP\n1.000 UL\nLT2\n2258 3765 M\n-84 -48 V\n-48
      12 V\n96 44 V\n36 -8 V\n.987 g 2345 3803 N 36 -8 -98 -35 -25 5 h\n1.000
      UP\n1.000 UL\nLT2\n2345 3803 M\n-87 -38 V\n-36 8 V\n98 35 V\n25 -5
      V\n.995 g 2433 3831 N 25 -5 -100 -26 -13 3 h\n1.000 UP\n1.000
      UL\nLT2\n2433 3831 M\n-88 -28 V\n-25 5 V\n100 26 V\n13 -3 V\n.999 g
      2521 3849 N 13 -3 -101 -15 0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521 3849
      M\n-88 -18 V\n-13 3 V\n101 15 V\n.001 g 2420 1325 N 0 0 110 2 -9 3
      h\n1.000 UP\n1.000 UL\nLT2\n2420 1325 M\n101 5 V\n-110 -2 V\n9 -3
      V\n.005 g 2320 1330 N 9 -3 109 -8 -18 6 h\n1.000 UP\n1.000
      UL\nLT2\n2320 1330 M\n100 -5 V\n-9 3 V\n-109 8 V\n18 -6 V\n.013 g 2222
      1345 N 18 -6 108 -19 -28 10 h\n1.000 UP\n1.000 UL\nLT2\n2222 1345 M\n98
      -15 V\n-18 6 V\n-108 19 V\n28 -10 V\n.025 g 2126 1370 N 28 -10 104 -28
      -36 13 h\n1.000 UP\n1.000 UL\nLT2\n2126 1370 M\n96 -25 V\n-28 10
      V\n-104 28 V\n36 -13 V\n.0407 g 2033 1405 N 36 -13 102 -38 -45 16
      h\n1.000 UP\n1.000 UL\nLT2\n2033 1405 M\n93 -35 V\n-36 13 V\n-102 38
      V\n45 -16 V\n.0601 g 1944 1450 N 45 -16 97 -47 -53 18 h\n1.000
      UP\n1.000 UL\nLT2\n1944 1450 M\n89 -45 V\n-45 16 V\n-97 47 V\n53 -18
      V\n.0831 g 1859 1503 N 53 -18 92 -57 -60 22 h\n1.000 UP\n1.000
      UL\nLT2\n1859 1503 M\n85 -53 V\n-53 18 V\n-92 57 V\n60 -22 V\n.1095 g
      1780 1566 N 60 -22 86 -65 -67 24 h\n1.000 UP\n1.000 UL\nLT2\n1780 1566
      M\n79 -63 V\n-60 22 V\n-86 65 V\n67 -24 V\n.139 g 1707 1637 N 67 -24 79
      -73 -73 26 h\n1.000 UP\n1.000 UL\nLT2\n1707 1637 M\n73 -71 V\n-67 24
      V\n-79 73 V\n73 -26 V\n.1714 g 1641 1715 N 73 -26 73 -80 -80 28
      h\n1.000 UP\n1.000 UL\nLT2\n1641 1715 M\n66 -78 V\n-73 26 V\n-73 80
      V\n80 -28 V\n.2064 g 1582 1800 N 80 -28 65 -87 -86 30 h\n1.000
      UP\n1.000 UL\nLT2\n1582 1800 M\n59 -85 V\n-80 28 V\n-65 87 V\n86 -30
      V\n.2438 g 1530 1892 N 86 -30 56 -94 -90 32 h\n1.000 UP\n1.000
      UL\nLT2\n1530 1892 M\n52 -92 V\n-86 30 V\n-56 94 V\n90 -32 V\n.2833 g
      1486 1990 N 90 -32 48 -99 -94 33 h\n1.000 UP\n1.000 UL\nLT2\n1486 1990
      M\n44 -98 V\n-90 32 V\n-48 99 V\n94 -33 V\n.3245 g 1450 2092 N 94 -33
      39 -103 -97 34 h\n1.000 UP\n1.000 UL\nLT2\n1450 2092 M\n36 -102 V\n-94
      33 V\n-39 103 V\n97 -34 V\n.3671 g 1424 2198 N 97 -34 29 -107 -100 35
      h\n1.000 UP\n1.000 UL\nLT2\n1424 2198 M\n26 -106 V\n-97 34 V\n-29 107
      V\n100 -35 V\n.4108 g 1406 2307 N 100 -35 20 -110 -102 36 h\n1.000
      UP\n1.000 UL\nLT2\n1406 2307 M\n18 -109 V\n-100 35 V\n-20 110 V\n102
      -36 V\n.4552 g 1396 2419 N 102 -36 9 -112 -101 36 h\n1.000 UP\n1.000
      UL\nLT2\n1396 2419 M\n10 -112 V\n-102 36 V\n-9 112 V\n101 -36 V\n.5 g
      1396 2532 N 101 -36 0 -113 -101 36 h\n1.000 UP\n1.000 UL\nLT2\n1396
      2532 M\n0 -113 V\n-101 36 V\n0 113 V\n101 -36 V\n.5448 g 1406 2645 N
      101 -36 -9 -113 -102 36 h\n1.000 UP\n1.000 UL\nLT2\n1406 2645 M\n-10
      -113 V\n-101 36 V\n9 113 V\n102 -36 V\n.5892 g 1424 2758 N 102 -36 -20
      -113 -100 36 h\n1.000 UP\n1.000 UL\nLT2\n1424 2758 M\n-18 -113 V\n-102
      36 V\n20 113 V\n100 -36 V\n.6329 g 1450 2870 N 100 -36 -29 -110 -97 34
      h\n1.000 UP\n1.000 UL\nLT2\n1450 2870 M\n-26 -112 V\n-100 36 V\n29 110
      V\n97 -34 V\n.6755 g 1486 2980 N 97 -34 -39 -109 -94 33 h\n1.000
      UP\n1.000 UL\nLT2\n1486 2980 M\n-36 -110 V\n-97 34 V\n39 109 V\n94 -33
      V\n.7167 g 1530 3086 N 94 -33 -48 -105 -90 32 h\n1.000 UP\n1.000
      UL\nLT2\n1530 3086 M\n-44 -106 V\n-94 33 V\n48 105 V\n90 -32 V\n.7562 g
      1582 3188 N 90 -32 -56 -100 -86 30 h\n1.000 UP\n1.000 UL\nLT2\n1582
      3188 M\n-52 -102 V\n-90 32 V\n56 100 V\n86 -30 V\n.7936 g 1641 3286 N
      86 -30 -65 -96 -80 28 h\n1.000 UP\n1.000 UL\nLT2\n1641 3286 M\n-59 -98
      V\n-86 30 V\n65 96 V\n80 -28 V\n.8286 g 1707 3377 N 80 -28 -73 -89 -73
      26 h\n1.000 UP\n1.000 UL\nLT2\n1707 3377 M\n-66 -91 V\n-80 28 V\n73 89
      V\n73 -26 V\n.861 g 1780 3463 N 73 -26 -79 -84 -67 24 h\n1.000
      UP\n1.000 UL\nLT2\n1780 3463 M\n-73 -86 V\n-73 26 V\n79 84 V\n67 -24
      V\n.8905 g 1859 3541 N 67 -24 -86 -76 -60 22 h\n1.000 UP\n1.000
      UL\nLT2\n1859 3541 M\n-79 -78 V\n-67 24 V\n86 76 V\n60 -22 V\n.9169 g
      1944 3612 N 60 -22 -92 -68 -53 19 h\n1.000 UP\n1.000 UL\nLT2\n1944 3612
      M\n-85 -71 V\n-60 22 V\n92 68 V\n53 -19 V\n.9399 g 2033 3675 N 53 -19
      -97 -59 -45 15 h\n1.000 UP\n1.000 UL\nLT2\n2033 3675 M\n-89 -63 V\n-53
      19 V\n97 59 V\n45 -15 V\n.9593 g 2126 3729 N 45 -15 -102 -51 -36 12
      h\n1.000 UP\n1.000 UL\nLT2\n2126 3729 M\n-93 -54 V\n-45 15 V\n102 51
      V\n36 -12 V\n.975 g 2222 3773 N 36 -12 -104 -42 -28 10 h\n1.000
      UP\n1.000 UL\nLT2\n2222 3773 M\n-96 -44 V\n-36 12 V\n104 42 V\n28 -10
      V\n.987 g 2320 3808 N 28 -10 -108 -32 -18 7 h\n1.000 UP\n1.000
      UL\nLT2\n2320 3808 M\n-98 -35 V\n-28 10 V\n108 32 V\n18 -7 V\n.995 g
      2420 3834 N 18 -7 -109 -22 -9 3 h\n1.000 UP\n1.000 UL\nLT2\n2420 3834
      M\n-100 -26 V\n-18 7 V\n109 22 V\n9 -3 V\n.999 g 2521 3849 N 9 -3 -110
      -12 0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n-101 -15 V\n-9 3
      V\n110 12 V\n.001 g 2411 1328 N 0 0 116 -1 -6 3 h\n1.000 UP\n1.000
      UL\nLT2\n2411 1328 M\n110 2 V\n-116 1 V\n6 -3 V\n.005 g 2302 1336 N 6
      -3 114 -12 -11 7 h\n1.000 UP\n1.000 UL\nLT2\n2302 1336 M\n109 -8 V\n-6
      3 V\n-114 12 V\n11 -7 V\n.013 g 2194 1355 N 11 -7 113 -22 -16 10
      h\n1.000 UP\n1.000 UL\nLT2\n2194 1355 M\n108 -19 V\n-11 7 V\n-113 22
      V\n16 -10 V\n.025 g 2090 1383 N 16 -10 110 -31 -22 13 h\n1.000
      UP\n1.000 UL\nLT2\n2090 1383 M\n104 -28 V\n-16 10 V\n-110 31 V\n22 -13
      V\n.0407 g 1988 1421 N 22 -13 107 -41 -27 16 h\n1.000 UP\n1.000
      UL\nLT2\n1988 1421 M\n102 -38 V\n-22 13 V\n-107 41 V\n27 -16 V\n.0601 g
      1891 1468 N 27 -16 102 -51 -32 20 h\n1.000 UP\n1.000 UL\nLT2\n1891 1468
      M\n97 -47 V\n-27 16 V\n-102 51 V\n32 -20 V\n.0831 g 1799 1525 N 32 -20
      96 -59 -36 22 h\n1.000 UP\n1.000 UL\nLT2\n1799 1525 M\n92 -57 V\n-32 20
      V\n-96 59 V\n36 -22 V\n.1095 g 1713 1590 N 36 -22 91 -68 -41 25
      h\n1.000 UP\n1.000 UL\nLT2\n1713 1590 M\n86 -65 V\n-36 22 V\n-91 68
      V\n41 -25 V\n.139 g 1634 1663 N 41 -25 84 -75 -46 27 h\n1.000 UP\n1.000
      UL\nLT2\n1634 1663 M\n79 -73 V\n-41 25 V\n-84 75 V\n46 -27 V\n.1714 g
      1561 1743 N 46 -27 76 -83 -49 30 h\n1.000 UP\n1.000 UL\nLT2\n1561 1743
      M\n73 -80 V\n-46 27 V\n-76 83 V\n49 -30 V\n.2064 g 1496 1830 N 49 -30
      68 -89 -52 32 h\n1.000 UP\n1.000 UL\nLT2\n1496 1830 M\n65 -87 V\n-49 30
      V\n-68 89 V\n52 -32 V\n.2438 g 1440 1924 N 52 -32 59 -96 -55 34
      h\n1.000 UP\n1.000 UL\nLT2\n1440 1924 M\n56 -94 V\n-52 32 V\n-59 96
      V\n55 -34 V\n.2833 g 1392 2023 N 55 -34 50 -100 -57 35 h\n1.000
      UP\n1.000 UL\nLT2\n1392 2023 M\n48 -99 V\n-55 34 V\n-50 100 V\n57 -35
      V\n.3245 g 1353 2126 N 57 -35 41 -104 -59 36 h\n1.000 UP\n1.000
      UL\nLT2\n1353 2126 M\n39 -103 V\n-57 35 V\n-41 104 V\n59 -36 V\n.3671 g
      1324 2233 N 59 -36 31 -108 -61 37 h\n1.000 UP\n1.000 UL\nLT2\n1324 2233
      M\n29 -107 V\n-59 36 V\n-31 108 V\n61 -37 V\n.4108 g 1304 2343 N 61 -37
      21 -111 -62 38 h\n1.000 UP\n1.000 UL\nLT2\n1304 2343 M\n20 -110 V\n-61
      37 V\n-21 111 V\n62 -38 V\n.4552 g 1295 2455 N 62 -38 10 -112 -63 38
      h\n1.000 UP\n1.000 UL\nLT2\n1295 2455 M\n9 -112 V\n-62 38 V\n-10 112
      V\n63 -38 V\n.5 g 1295 2568 N 63 -38 0 -113 -63 38 h\n1.000 UP\n1.000
      UL\nLT2\n1295 2568 M\n0 -113 V\n-63 38 V\n0 113 V\n63 -38 V\n.5448 g
      1304 2681 N 63 -38 -10 -113 -62 38 h\n1.000 UP\n1.000 UL\nLT2\n1304
      2681 M\n-9 -113 V\n-63 38 V\n10 113 V\n62 -38 V\n.5892 g 1324 2794 N 62
      -38 -21 -112 -61 37 h\n1.000 UP\n1.000 UL\nLT2\n1324 2794 M\n-20 -113
      V\n-62 38 V\n21 112 V\n61 -37 V\n.6329 g 1353 2904 N 61 -37 -31 -110
      -59 37 h\n1.000 UP\n1.000 UL\nLT2\n1353 2904 M\n-29 -110 V\n-61 37
      V\n31 110 V\n59 -37 V\n.6755 g 1392 3013 N 59 -37 -41 -107 -57 35
      h\n1.000 UP\n1.000 UL\nLT2\n1392 3013 M\n-39 -109 V\n-59 37 V\n41 107
      V\n57 -35 V\n.7167 g 1440 3118 N 57 -35 -50 -103 -55 33 h\n1.000
      UP\n1.000 UL\nLT2\n1440 3118 M\n-48 -105 V\n-57 35 V\n50 103 V\n55 -33
      V\n.7562 g 1496 3218 N 55 -33 -59 -99 -52 32 h\n1.000 UP\n1.000
      UL\nLT2\n1496 3218 M\n-56 -100 V\n-55 33 V\n59 99 V\n52 -32 V\n.7936 g
      1561 3314 N 52 -32 -68 -94 -49 30 h\n1.000 UP\n1.000 UL\nLT2\n1561 3314
      M\n-65 -96 V\n-52 32 V\n68 94 V\n49 -30 V\n.8286 g 1634 3403 N 49 -30
      -76 -87 -46 28 h\n1.000 UP\n1.000 UL\nLT2\n1634 3403 M\n-73 -89 V\n-49
      30 V\n76 87 V\n46 -28 V\n.861 g 1713 3487 N 46 -28 -84 -81 -41 25
      h\n1.000 UP\n1.000 UL\nLT2\n1713 3487 M\n-79 -84 V\n-46 28 V\n84 81
      V\n41 -25 V\n.8905 g 1799 3563 N 41 -25 -91 -73 -36 22 h\n1.000
      UP\n1.000 UL\nLT2\n1799 3563 M\n-86 -76 V\n-41 25 V\n91 73 V\n36 -22
      V\n.9169 g 1891 3631 N 36 -22 -96 -65 -32 19 h\n1.000 UP\n1.000
      UL\nLT2\n1891 3631 M\n-92 -68 V\n-36 22 V\n96 65 V\n32 -19 V\n.9399 g
      1988 3690 N 32 -19 -102 -57 -27 17 h\n1.000 UP\n1.000 UL\nLT2\n1988
      3690 M\n-97 -59 V\n-32 19 V\n102 57 V\n27 -17 V\n.9593 g 2090 3741 N 27
      -17 -107 -48 -22 14 h\n1.000 UP\n1.000 UL\nLT2\n2090 3741 M\n-102 -51
      V\n-27 17 V\n107 48 V\n22 -14 V\n.975 g 2194 3783 N 22 -14 -110 -38 -16
      10 h\n1.000 UP\n1.000 UL\nLT2\n2194 3783 M\n-104 -42 V\n-22 14 V\n110
      38 V\n16 -10 V\n.987 g 2302 3815 N 16 -10 -113 -29 -11 7 h\n1.000
      UP\n1.000 UL\nLT2\n2302 3815 M\n-108 -32 V\n-16 10 V\n113 29 V\n11 -7
      V\n.995 g 2411 3837 N 11 -7 -114 -18 -6 3 h\n1.000 UP\n1.000
      UL\nLT2\n2411 3837 M\n-109 -22 V\n-11 7 V\n114 18 V\n6 -3 V\n.999 g
      2521 3849 N 6 -3 -116 -9 0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521 3849
      M\n-110 -12 V\n-6 3 V\n116 9 V\n.001 g 2405 1331 N 0 0 117 -5 -1 4
      h\n1.000 UP\n1.000 UL\nLT2\n2405 1331 M\n116 -1 V\n-117 5 V\n1 -4
      V\n.005 g 2291 1343 N 1 -4 117 -15 -4 7 h\n1.000 UP\n1.000
      UL\nLT2\n2291 1343 M\n114 -12 V\n-1 4 V\n-117 15 V\n4 -7 V\n.013 g 2178
      1365 N 4 -7 115 -25 -6 10 h\n1.000 UP\n1.000 UL\nLT2\n2178 1365 M\n113
      -22 V\n-4 7 V\n-115 25 V\n6 -10 V\n.025 g 2068 1396 N 6 -10 112 -35 -8
      14 h\n1.000 UP\n1.000 UL\nLT2\n2068 1396 M\n110 -31 V\n-6 10 V\n-112 35
      V\n8 -14 V\n.0407 g 1961 1437 N 8 -14 108 -45 -9 18 h\n1.000 UP\n1.000
      UL\nLT2\n1961 1437 M\n107 -41 V\n-8 14 V\n-108 45 V\n9 -18 V\n.0601 g
      1859 1488 N 9 -18 104 -53 -11 20 h\n1.000 UP\n1.000 UL\nLT2\n1859 1488
      M\n102 -51 V\n-9 18 V\n-104 53 V\n11 -20 V\n.0831 g 1763 1547 N 11 -20
      98 -62 -13 23 h\n1.000 UP\n1.000 UL\nLT2\n1763 1547 M\n96 -59 V\n-11 20
      V\n-98 62 V\n13 -23 V\n.1095 g 1672 1615 N 13 -23 92 -71 -14 26
      h\n1.000 UP\n1.000 UL\nLT2\n1672 1615 M\n91 -68 V\n-13 23 V\n-92 71
      V\n14 -26 V\n.139 g 1588 1690 N 14 -26 85 -78 -15 29 h\n1.000 UP\n1.000
      UL\nLT2\n1588 1690 M\n84 -75 V\n-14 26 V\n-85 78 V\n15 -29 V\n.1714 g
      1512 1773 N 15 -29 77 -85 -16 31 h\n1.000 UP\n1.000 UL\nLT2\n1512 1773
      M\n76 -83 V\n-15 29 V\n-77 85 V\n16 -31 V\n.2064 g 1444 1862 N 16 -31
      69 -92 -17 34 h\n1.000 UP\n1.000 UL\nLT2\n1444 1862 M\n68 -89 V\n-16 31
      V\n-69 92 V\n17 -34 V\n.2438 g 1385 1958 N 17 -34 61 -97 -19 35
      h\n1.000 UP\n1.000 UL\nLT2\n1385 1958 M\n59 -96 V\n-17 34 V\n-61 97
      V\n19 -35 V\n.2833 g 1335 2058 N 19 -35 51 -101 -20 36 h\n1.000
      UP\n1.000 UL\nLT2\n1335 2058 M\n50 -100 V\n-19 35 V\n-51 101 V\n20 -36
      V\n.3245 g 1294 2162 N 20 -36 41 -106 -20 38 h\n1.000 UP\n1.000
      UL\nLT2\n1294 2162 M\n41 -104 V\n-20 36 V\n-41 106 V\n20 -38 V\n.3671 g
      1263 2270 N 20 -38 31 -109 -20 39 h\n1.000 UP\n1.000 UL\nLT2\n1263 2270
      M\n31 -108 V\n-20 38 V\n-31 109 V\n20 -39 V\n.4108 g 1242 2381 N 20 -39
      21 -111 -20 39 h\n1.000 UP\n1.000 UL\nLT2\n1242 2381 M\n21 -111 V\n-20
      39 V\n-21 111 V\n20 -39 V\n.4552 g 1232 2493 N 20 -39 11 -113 -21 40
      h\n1.000 UP\n1.000 UL\nLT2\n1232 2493 M\n10 -112 V\n-20 39 V\n-11 113
      V\n21 -40 V\n.5 g 1232 2606 N 21 -40 0 -113 -21 40 h\n1.000 UP\n1.000
      UL\nLT2\n1232 2606 M\n0 -113 V\n-21 40 V\n0 113 V\n21 -40 V\n.5448 g
      1242 2719 N 21 -40 -11 -113 -20 40 h\n1.000 UP\n1.000 UL\nLT2\n1242
      2719 M\n-10 -113 V\n-21 40 V\n11 113 V\n20 -40 V\n.5892 g 1263 2831 N
      20 -40 -21 -111 -20 39 h\n1.000 UP\n1.000 UL\nLT2\n1263 2831 M\n-21
      -112 V\n-20 40 V\n21 111 V\n20 -39 V\n.6329 g 1294 2941 N 20 -39 -31
      -109 -20 38 h\n1.000 UP\n1.000 UL\nLT2\n1294 2941 M\n-31 -110 V\n-20 39
      V\n31 109 V\n20 -38 V\n.6755 g 1335 3048 N 20 -38 -41 -106 -20 37
      h\n1.000 UP\n1.000 UL\nLT2\n1335 3048 M\n-41 -107 V\n-20 38 V\n41 106
      V\n20 -37 V\n.7167 g 1385 3151 N 20 -37 -51 -101 -19 35 h\n1.000
      UP\n1.000 UL\nLT2\n1385 3151 M\n-50 -103 V\n-20 37 V\n51 101 V\n19 -35
      V\n.7562 g 1444 3250 N 19 -35 -61 -97 -17 33 h\n1.000 UP\n1.000
      UL\nLT2\n1444 3250 M\n-59 -99 V\n-19 35 V\n61 97 V\n17 -33 V\n.7936 g
      1512 3344 N 17 -33 -69 -92 -16 31 h\n1.000 UP\n1.000 UL\nLT2\n1512 3344
      M\n-68 -94 V\n-17 33 V\n69 92 V\n16 -31 V\n.8286 g 1588 3431 N 16 -31
      -77 -85 -15 29 h\n1.000 UP\n1.000 UL\nLT2\n1588 3431 M\n-76 -87 V\n-16
      31 V\n77 85 V\n15 -29 V\n.861 g 1672 3512 N 15 -29 -85 -78 -14 26
      h\n1.000 UP\n1.000 UL\nLT2\n1672 3512 M\n-84 -81 V\n-15 29 V\n85 78
      V\n14 -26 V\n.8905 g 1763 3585 N 14 -26 -92 -71 -13 24 h\n1.000
      UP\n1.000 UL\nLT2\n1763 3585 M\n-91 -73 V\n-14 26 V\n92 71 V\n13 -24
      V\n.9169 g 1859 3650 N 13 -24 -98 -62 -11 21 h\n1.000 UP\n1.000
      UL\nLT2\n1859 3650 M\n-96 -65 V\n-13 24 V\n98 62 V\n11 -21 V\n.9399 g
      1961 3707 N 11 -21 -104 -53 -9 17 h\n1.000 UP\n1.000 UL\nLT2\n1961 3707
      M\n-102 -57 V\n-11 21 V\n104 53 V\n9 -17 V\n.9593 g 2068 3755 N 9 -17
      -108 -45 -8 14 h\n1.000 UP\n1.000 UL\nLT2\n2068 3755 M\n-107 -48 V\n-9
      17 V\n108 45 V\n8 -14 V\n.975 g 2178 3793 N 8 -14 -112 -35 -6 11
      h\n1.000 UP\n1.000 UL\nLT2\n2178 3793 M\n-110 -38 V\n-8 14 V\n112 35
      V\n6 -11 V\n.987 g 2291 3822 N 6 -11 -115 -25 -4 7 h\n1.000 UP\n1.000
      UL\nLT2\n2291 3822 M\n-113 -29 V\n-6 11 V\n115 25 V\n4 -7 V\n.995 g
      2405 3840 N 4 -7 -117 -15 -1 4 h\n1.000 UP\n1.000 UL\nLT2\n2405 3840
      M\n-114 -18 V\n-4 7 V\n117 15 V\n1 -4 V\n.999 g 2521 3849 N 1 -4 -117
      -5 0 0 h\n1.000 UP\n1.000 UL\nLT2\n2521 3849 M\n-116 -9 V\n-1 4 V\n117
      5 V\n%pm3d_map_end\ngrestore % colour palette end\n1.000 UP\n1.000
      UP\nstroke\ngrestore\nend\nshowpage\n%%Trailer\n%%DocumentFonts:
      Helvetica\n>|ps>||||||>

      \;
    </output>

    <\input|GNUplot] >
      set xrange[-5:5] ~set yrange[-2:2] ~f(x)=x\<less\>0?-1:1 ~plot f(x)
    </input>

    <\output>
      <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
      temp.eps\n%%Creator: gnuplot 3.8h patchlevel 0\n%%CreationDate: Sun Apr
      \ 6 12:33:46 2003\n%%DocumentFonts: (atend)\n%%BoundingBox: 50 50 410
      302\n%%Orientation: Portrait\n%%EndComments\n/gnudict 256 dict
      def\ngnudict begin\n/Color false def\n/Solid false def\n/gnulinewidth
      5.000 def\n/userlinewidth gnulinewidth def\n/vshift -46 def\n/dl {10.0
      mul} def\n/hpt_ 31.5 def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_
      def\n/M {moveto} bind def\n/L {lineto} bind def\n/R {rmoveto} bind
      def\n/V {rlineto} bind def\n/N {newpath moveto} bind def\n/f {rlineto
      fill} bind def\n/vpt2 vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow {
      currentpoint stroke M\n \ 0 vshift R show } def\n/Rshow { currentpoint
      stroke M\n \ dup stringwidth pop neg vshift R show } def\n/Cshow {
      currentpoint stroke M\n \ dup stringwidth pop -2 div vshift R show }
      def\n/UP { dup vpt_ mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2
      hpt 2 mul def /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid
      {pop []} if 0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash}
      ifelse } def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL
      { stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
      mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul /udl
      exch def } def\n/PL { stroke userlinewidth setlinewidth } def\n/LTb {
      BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0 setdash 0 0 0
      setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 { PL [4 dl 2 dl] 0
      1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL } def\n/LT3 { PL [1 dl 1.5
      dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1 dl 2 dl] 0 1 1 DL }
      def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL } def\n/LT6 { PL [2 dl 2
      dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0 setdash\n \ \ gsave 1
      setlinecap M 0 0 V stroke grestore } def\n/Dia { stroke [] 0 setdash 2
      copy vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt
      neg vpt V closepath stroke\n \ Pnt } def\n/Pls { stroke [] 0 setdash
      vpt sub M 0 vpt2 V\n \ currentpoint stroke M\n \ hpt neg vpt neg R hpt2
      0 V stroke\n \ } def\n/Box { stroke [] 0 setdash 2 copy exch hpt sub
      exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
      closepath stroke\n \ Pnt } def\n/Crs { stroke [] 0 setdash exch hpt sub
      exch vpt add M\n \ hpt2 vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0
      R hpt2 vpt2 V stroke } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12
      mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      1.62 mul V closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs }
      def\n/BoxF { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill }
      def\n/TriUF { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt
      -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill
      } def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
      neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
      closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt 1.12
      mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash vpt add
      M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V
      closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy gsave\n
      \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath stroke
      grestore Pnt } def\n/PentF { stroke [] 0 setdash gsave\n \ translate 0
      hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath fill grestore }
      def\n/Circle { stroke [] 0 setdash 2 copy\n \ hpt 0 360 arc stroke Pnt
      } def\n/CircleF { stroke [] 0 setdash hpt 0 360 arc fill } def\n/C0 {
      BL [] 0 setdash 2 copy moveto vpt 90 450 \ arc } bind def\n/C1 { BL []
      0 setdash 2 copy \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C2 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C3 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
      bind def\n/C4 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
      \ vpt 180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 270 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C6 { BL [] 0
      setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 90 270 arc closepath
      fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
      def\n/C7 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 0 270
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
      } bind def\n/C8 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
      copy \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
      moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13 {
      BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
      setdash 2 copy vpt 0 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
      \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
      \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
      bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
      def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
      bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
      def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
      Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch vpt2
      vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy exch vpt
      sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 { BL [] 0
      setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt sub exch
      vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0 setdash 2
      copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare } bind
      def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt vpt2
      Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub vpt Square fill Bsquare
      } bind def\n/S9 { BL [] 0 setdash 2 copy vpt sub vpt vpt2 Rec fill
      Bsquare } bind def\n/S10 { BL [] 0 setdash 2 copy vpt sub vpt Square
      fill 2 copy exch vpt sub exch vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S11 { BL [] 0 setdash 2 copy vpt sub vpt Square fill 2 copy
      exch vpt sub exch vpt2 vpt Rec fill\n \ \ \ \ \ \ Bsquare } bind
      def\n/S12 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt
      Rec fill Bsquare } bind def\n/S13 { BL [] 0 setdash 2 copy exch vpt sub
      exch vpt sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill
      Bsquare } bind def\n/S14 { BL [] 0 setdash 2 copy exch vpt sub exch vpt
      sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square
      fill Bsquare } bind def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill
      Bsquare } bind def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke
      grestore } bind def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke
      grestore } bind def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke
      grestore } bind def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke
      grestore } bind def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke
      grestore } bind def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke
      grestore } bind def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke
      grestore } bind def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke
      grestore } bind def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke
      grestore } bind def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke
      grestore } bind def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke
      grestore } bind def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke
      grestore } bind def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke
      grestore } bind def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke
      grestore } bind def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke
      grestore } bind def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke
      grestore } bind def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg
      vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke }
      def\n/BoxE { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE
      { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke }
      def\n/TriDE { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt
      1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath
      stroke } def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M
      4 {72 rotate 0 hpt L} repeat\n \ closepath stroke grestore }
      def\n/CircE { stroke [] 0 setdash \n \ hpt 0 360 arc stroke }
      def\n/Opaque { gsave closepath 1 setgray fill grestore 0 setgray
      closepath } def\n/DiaW { stroke [] 0 setdash vpt add M\n \ hpt neg vpt
      neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V Opaque stroke }
      def\n/BoxW { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW {
      stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW
      { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW
      { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
      repeat\n \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash
      \n \ hpt 0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray
      fill grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
      makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
      ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0 get
      findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ] exch
      dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch 4 get
      {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n \ \ \ \ {dup 3
      get {2 get neg 0 exch R pop} {pop aload pop M} ifelse} {dup 5\n
      \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get stringwidth pop
      -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop -2 div 0 R 6 get\n
      \ \ \ \ show 2 index {aload pop M neg 3 -1 roll neg R pop pop} {pop pop
      pop\n \ \ \ \ pop aload pop M} ifelse }ifelse }ifelse } forall} bind
      def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get findfont exch 1 get
      scalefont\n \ \ \ \ setfont 6 get stringwidth pop add} {pop} ifelse}
      forall} bind def\n/MLshow { currentpoint stroke M\n \ 0 exch R MFshow }
      bind def\n/MRshow { currentpoint stroke M\n \ exch dup MFwidth neg 3 -1
      roll R MFshow } def\n/MCshow { currentpoint stroke M\n \ exch dup
      MFwidth -2 div 3 -1 roll R MFshow } def\nend\n%%EndProlog\ngnudict
      begin\ngsave\n50 50 translate\n0.050 0.050 scale\n0
      setgray\nnewpath\n(Helvetica) findfont 140 scalefont setfont\n1.000
      UL\nLTb\n574 280 M\n63 0 V\n6325 0 R\n-63 0 V\n stroke\n490 280
      M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-2)]\n] -46.7
      MRshow\ngrestore\n574 854 M\n63 0 V\n6325 0 R\n-63 0 V\n stroke\n490
      854 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-1.5)]\n]
      -46.7 MRshow\ngrestore\n574 1428 M\n63 0 V\n6325 0 R\n-63 0 V\n
      stroke\n490 1428 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 (-1)]\n] -46.7 MRshow\ngrestore\n574 2002 M\n63 0 V\n6325 0 R\n-63 0
      V\n stroke\n490 2002 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 (-0.5)]\n] -46.7 MRshow\ngrestore\n574 2576 M\n63 0 V\n6325 0
      R\n-63 0 V\n stroke\n490 2576 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 ( 0)]\n] -46.7 MRshow\ngrestore\n574 3150 M\n63 0
      V\n6325 0 R\n-63 0 V\n stroke\n490 3150 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 ( 0.5)]\n] -46.7
      MRshow\ngrestore\n574 3724 M\n63 0 V\n6325 0 R\n-63 0 V\n stroke\n490
      3724 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 ( 1)]\n]
      -46.7 MRshow\ngrestore\n574 4298 M\n63 0 V\n6325 0 R\n-63 0 V\n
      stroke\n490 4298 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 ( 1.5)]\n] -46.7 MRshow\ngrestore\n574 4872 M\n63 0 V\n6325 0 R\n-63
      0 V\n stroke\n490 4872 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0
      true true 0 ( 2)]\n] -46.7 MRshow\ngrestore\n1213 280 M\n0 63 V\n0 4529
      R\n0 -63 V\n stroke\n1213 140 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 (-4)]\n] -46.7 MCshow\ngrestore\n2490 280 M\n0 63 V\n0
      4529 R\n0 -63 V\n stroke\n2490 140 M\ngsave 0 setgray\n[ [(Helvetica)
      140.0 0.0 true true 0 (-2)]\n] -46.7 MCshow\ngrestore\n3768 280 M\n0 63
      V\n0 4529 R\n0 -63 V\n stroke\n3768 140 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 ( 0)]\n] -46.7
      MCshow\ngrestore\n5046 280 M\n0 63 V\n0 4529 R\n0 -63 V\n stroke\n5046
      140 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 ( 2)]\n]
      -46.7 MCshow\ngrestore\n6323 280 M\n0 63 V\n0 4529 R\n0 -63 V\n
      stroke\n6323 140 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true
      0 ( 4)]\n] -46.7 MCshow\ngrestore\n1.000 UL\nLTb\n574 280 M\n6388 0
      V\n0 4592 V\n-6388 0 V\n574 280 L\n1.000 UP\n1.000 UL\nLT0\n6311 4739
      M\ngsave 0 setgray\n(f\\(x\\)) Rshow\ngrestore\n6395 4739 M\n399 0
      V\n574 1428 M\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0
      V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0
      V\n65 0 V\n64 0 V\n65 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0
      V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0
      V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n65 0 V\n64 0 V\n65 0
      V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 2296 V\n65 0
      V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n65 0
      V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0
      V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0
      V\n64 0 V\n65 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0
      V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0 V\n65 0 V\n64 0
      V\n65 0 V\n64 0 V\n65 0 V\n1.000 UP\nstroke\ngrestore\nend\nshowpage\n%%Trailer\n%%DocumentFonts:
      Helvetica\n>|ps>||||||>

      \;
    </output>

    <\input|GNUplot] >
      \;
    </input>
  </session>

  Due to the auto-scaling effect, not all the range of domain of
  <with|mode|math|x+sin(x)> is shown in the first graph. After given the
  range of variable of <with|mode|math|x>, we can observe the graph more
  explicitly. But how about "<with|color|red|set xlabel '[x]'>" in single
  line with other plotting command lines? Due to bug interpretation of the
  interface of gnuplot, <with|mode|math|>tm_gnuplot, gnuplot cannot handle
  this code with ghostscript. Instead of inputting <with|color|red|plot> and
  <with|color|red|set option> in different lines, input "<with|color|red|set
  options ~ plot <with|mode|math|\<cdots\><with|color|black|>>>" \ to add the
  set option in normal plotting command. Try directly \ execute the above
  code to see what about the differences between two statements. Almost CAS's
  have their plotting philosophy. For example, Octave, the other famous one,
  not only has its built-in command, <strong|<verbatim|<em|<strong|<with|color|red|plot>>>>>,
  but also fully supports the Gnuplot functions, only by adding a pre
  "<with|color|red|g>" before the relative plotting commands.\ 

  <\session|octave|default>
    <\output>
      GNU Octave, version 2.1.45 (i686-pc-linux-gnu).

      Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003 John W.
      Eaton.

      This is free software; see the source code for copying conditions.

      There is ABSOLUTELY NO WARRANTY; not even for MERCHANTIBILITY or

      FITNESS FOR A PARTICULAR PURPOSE.

      \;

      Report bugs to \<less\>bug-octave@bevo.che.wisc.edu\<gtr\>.

      \;
    </output>

    <\input|octave\<gtr\> >
      x=linspace(-10,10,1000);
    </input>

    <\input|octave\<gtr\> >
      y=x+sin(x);
    </input>

    <\input|octave\<gtr\> >
      plot(x,y,";Function y=x+sin(x);");
    </input>

    <\output>
      \;

      \;

      <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
      /tmp/tmplot.eps\n%%Creator: gnuplot 3.8h patchlevel 0\n%%CreationDate:
      Sat Apr \ 5 19:59:37 2003\n%%DocumentFonts: (atend)\n%%BoundingBox: 50
      50 230 176\n%%Orientation: Portrait\n%%EndComments\n/gnudict 256 dict
      def\ngnudict begin\n/Color true def\n/Solid false def\n/gnulinewidth
      5.000 def\n/userlinewidth gnulinewidth def\n/vshift -46 def\n/dl {10.0
      mul} def\n/hpt_ 31.5 def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_
      def\n/M {moveto} bind def\n/L {lineto} bind def\n/R {rmoveto} bind
      def\n/V {rlineto} bind def\n/N {newpath moveto} bind def\n/f {rlineto
      fill} bind def\n/vpt2 vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow {
      currentpoint stroke M\n \ 0 vshift R show } def\n/Rshow { currentpoint
      stroke M\n \ dup stringwidth pop neg vshift R show } def\n/Cshow {
      currentpoint stroke M\n \ dup stringwidth pop -2 div vshift R show }
      def\n/UP { dup vpt_ mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2
      hpt 2 mul def /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid
      {pop []} if 0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash}
      ifelse } def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL
      { stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
      mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul /udl
      exch def } def\n/PL { stroke userlinewidth setlinewidth } def\n/LTb {
      BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0 setdash 0 0 0
      setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 { PL [4 dl 2 dl] 0
      1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL } def\n/LT3 { PL [1 dl 1.5
      dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1 dl 2 dl] 0 1 1 DL }
      def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL } def\n/LT6 { PL [2 dl 2
      dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0 setdash\n \ \ gsave 1
      setlinecap M 0 0 V stroke grestore } def\n/Dia { stroke [] 0 setdash 2
      copy vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt
      neg vpt V closepath stroke\n \ Pnt } def\n/Pls { stroke [] 0 setdash
      vpt sub M 0 vpt2 V\n \ currentpoint stroke M\n \ hpt neg vpt neg R hpt2
      0 V stroke\n \ } def\n/Box { stroke [] 0 setdash 2 copy exch hpt sub
      exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
      closepath stroke\n \ Pnt } def\n/Crs { stroke [] 0 setdash exch hpt sub
      exch vpt add M\n \ hpt2 vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0
      R hpt2 vpt2 V stroke } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12
      mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      1.62 mul V closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs }
      def\n/BoxF { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill }
      def\n/TriUF { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt
      -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill
      } def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
      neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
      closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt 1.12
      mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash vpt add
      M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V
      closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy gsave\n
      \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath stroke
      grestore Pnt } def\n/PentF { stroke [] 0 setdash gsave\n \ translate 0
      hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath fill grestore }
      def\n/Circle { stroke [] 0 setdash 2 copy\n \ hpt 0 360 arc stroke Pnt
      } def\n/CircleF { stroke [] 0 setdash hpt 0 360 arc fill } def\n/C0 {
      BL [] 0 setdash 2 copy moveto vpt 90 450 \ arc } bind def\n/C1 { BL []
      0 setdash 2 copy \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C2 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C3 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
      bind def\n/C4 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
      \ vpt 180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 270 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C6 { BL [] 0
      setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 90 270 arc closepath
      fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
      def\n/C7 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 0 270
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
      } bind def\n/C8 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
      copy \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
      moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13 {
      BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
      setdash 2 copy vpt 0 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
      \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
      \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
      bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
      def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
      bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
      def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
      Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch vpt2
      vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy exch vpt
      sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 { BL [] 0
      setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt sub exch
      vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0 setdash 2
      copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare } bind
      def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt vpt2
      Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub vpt Square fill Bsquare
      } bind def\n/S9 { BL [] 0 setdash 2 copy vpt sub vpt vpt2 Rec fill
      Bsquare } bind def\n/S10 { BL [] 0 setdash 2 copy vpt sub vpt Square
      fill 2 copy exch vpt sub exch vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S11 { BL [] 0 setdash 2 copy vpt sub vpt Square fill 2 copy
      exch vpt sub exch vpt2 vpt Rec fill\n \ \ \ \ \ \ Bsquare } bind
      def\n/S12 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt
      Rec fill Bsquare } bind def\n/S13 { BL [] 0 setdash 2 copy exch vpt sub
      exch vpt sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill
      Bsquare } bind def\n/S14 { BL [] 0 setdash 2 copy exch vpt sub exch vpt
      sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square
      fill Bsquare } bind def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill
      Bsquare } bind def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke
      grestore } bind def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke
      grestore } bind def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke
      grestore } bind def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke
      grestore } bind def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke
      grestore } bind def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke
      grestore } bind def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke
      grestore } bind def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke
      grestore } bind def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke
      grestore } bind def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke
      grestore } bind def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke
      grestore } bind def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke
      grestore } bind def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke
      grestore } bind def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke
      grestore } bind def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke
      grestore } bind def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke
      grestore } bind def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg
      vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke }
      def\n/BoxE { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE
      { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke }
      def\n/TriDE { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt
      1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath
      stroke } def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M
      4 {72 rotate 0 hpt L} repeat\n \ closepath stroke grestore }
      def\n/CircE { stroke [] 0 setdash \n \ hpt 0 360 arc stroke }
      def\n/Opaque { gsave closepath 1 setgray fill grestore 0 setgray
      closepath } def\n/DiaW { stroke [] 0 setdash vpt add M\n \ hpt neg vpt
      neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V Opaque stroke }
      def\n/BoxW { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW {
      stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW
      { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW
      { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
      repeat\n \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash
      \n \ hpt 0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray
      fill grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
      makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
      ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0 get
      findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ] exch
      dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch 4 get
      {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n \ \ \ \ {dup 3
      get {2 get neg 0 exch R pop} {pop aload pop M} ifelse} {dup 5\n
      \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get stringwidth pop
      -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop -2 div 0 R 6 get\n
      \ \ \ \ show 2 index {aload pop M neg 3 -1 roll neg R pop pop} {pop pop
      pop\n \ \ \ \ pop aload pop M} ifelse }ifelse }ifelse } forall} bind
      def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get findfont exch 1 get
      scalefont\n \ \ \ \ setfont 6 get stringwidth pop add} {pop} ifelse}
      forall} bind def\n/MLshow { currentpoint stroke M\n \ 0 exch R MFshow }
      bind def\n/MRshow { currentpoint stroke M\n \ exch dup MFwidth neg 3 -1
      roll R MFshow } def\n/MCshow { currentpoint stroke M\n \ exch dup
      MFwidth -2 div 3 -1 roll R MFshow } def\nend\n%%EndProlog\ngnudict
      begin\ngsave\n50 50 translate\n0.050 0.050 scale\n0
      setgray\nnewpath\n(Helvetica) findfont 140 scalefont setfont\n1.000
      UL\nLTb\n490 280 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 280 M\n[
      [(Helvetica) 140.0 0.0 true true 0 (-10)]\n] -46.7 MRshow\n490 487
      M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 487 M\n[ [(Helvetica) 140.0
      0.0 true true 0 (-8)]\n] -46.7 MRshow\n490 694 M\n63 0 V\n2809 0 R\n-63
      0 V\n stroke\n406 694 M\n[ [(Helvetica) 140.0 0.0 true true 0 (-6)]\n]
      -46.7 MRshow\n490 902 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 902
      M\n[ [(Helvetica) 140.0 0.0 true true 0 (-4)]\n] -46.7 MRshow\n490 1109
      M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 1109 M\n[ [(Helvetica) 140.0
      0.0 true true 0 (-2)]\n] -46.7 MRshow\n490 1316 M\n63 0 V\n2809 0
      R\n-63 0 V\n stroke\n406 1316 M\n[ [(Helvetica) 140.0 0.0 true true 0 (
      0)]\n] -46.7 MRshow\n490 1523 M\n63 0 V\n2809 0 R\n-63 0 V\n
      stroke\n406 1523 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 2)]\n] -46.7
      MRshow\n490 1730 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 1730 M\n[
      [(Helvetica) 140.0 0.0 true true 0 ( 4)]\n] -46.7 MRshow\n490 1938
      M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 1938 M\n[ [(Helvetica) 140.0
      0.0 true true 0 ( 6)]\n] -46.7 MRshow\n490 2145 M\n63 0 V\n2809 0
      R\n-63 0 V\n stroke\n406 2145 M\n[ [(Helvetica) 140.0 0.0 true true 0 (
      8)]\n] -46.7 MRshow\n490 2352 M\n63 0 V\n2809 0 R\n-63 0 V\n
      stroke\n406 2352 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 10)]\n]
      -46.7 MRshow\n490 280 M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n490 140
      M\n[ [(Helvetica) 140.0 0.0 true true 0 (-10)]\n] -46.7 MCshow\n1208
      280 M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n1208 140 M\n[ [(Helvetica)
      140.0 0.0 true true 0 (-5)]\n] -46.7 MCshow\n1926 280 M\n0 63 V\n0 2009
      R\n0 -63 V\n stroke\n1926 140 M\n[ [(Helvetica) 140.0 0.0 true true 0 (
      0)]\n] -46.7 MCshow\n2644 280 M\n0 63 V\n0 2009 R\n0 -63 V\n
      stroke\n2644 140 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 5)]\n] -46.7
      MCshow\n3362 280 M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n3362 140 M\n[
      [(Helvetica) 140.0 0.0 true true 0 ( 10)]\n] -46.7 MCshow\n1.000
      UL\nLTb\n490 280 M\n2872 0 V\n0 2072 V\n-2872 0 V\n490 280 L\n1.000
      UP\n1.000 UL\nLT0\n2711 2219 M\n[ [(Helvetica) 140.0 0.0 true true 0
      (Function y=x+sin\\(x\\))]\n] -46.7 MRshow\n2795 2219 M\n399 0 V\n490
      336 M\n3 1 V\n3 0 V\n3 0 V\n2 1 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 1 V\n3
      0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 1
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0
      V\n3 0 V\n2 0 V\n3 1 V\n3 0 V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n2 1
      V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n2 1 V\n3 0 V\n3 1
      V\n3 1 V\n3 0 V\n3 1 V\n3 1 V\n3 1 V\n2 1 V\n3 0 V\n3 1 V\n3 1 V\n3 1
      V\n3 1 V\n3 1 V\n3 1 V\n2 2 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 2 V\n3 1
      V\n3 2 V\n2 1 V\n3 1 V\n3 2 V\n3 2 V\n3 1 V\n3 2 V\n3 1 V\n3 2 V\n2 2
      V\n3 2 V\n3 2 V\n3 1 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n2 2 V\n3 3 V\n3 2
      V\n3 2 V\n3 2 V\n3 2 V\n3 3 V\n3 2 V\n2 3 V\n3 2 V\n3 3 V\n3 2 V\n3 3
      V\n3 2 V\n3 3 V\n3 3 V\n2 2 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3
      V\n3 3 V\n2 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n2 3
      V\n3 4 V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n3 4 V\n3 3 V\n2 4 V\n3 4 V\n3 3
      V\n3 4 V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n2 4 V\n3 3 V\n3 4 V\n3 4 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 5
      V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 5 V\n2 4 V\n3 4 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n3 5 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n3 4 V\n3 3 V\n2 4
      V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n3 3 V\n3 4 V\n3 3 V\n2 4 V\n3 3 V\n3 3
      V\n3 4 V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n2 3 V\n3 3 V\n3 3 V\n3 3 V\n3 4
      V\n3 3 V\n3 3 V\n3 2 V\n2 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 2 V\n3 3
      V\n3 3 V\n2 2 V\n3 3 V\n3 2 V\n3 3 V\n3 2 V\n3 3 V\n3 2 V\n3 2 V\n2 3
      V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n2 2 V\n3 2 V\n3 2
      V\n3 2 V\n3 1 V\n3 2 V\n3 2 V\n3 2 V\n2 1 V\n3 2 V\n3 1 V\n3 2 V\n3 1
      V\n3 2 V\n3 1 V\n3 1 V\n2 2 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 1
      V\n3 2 V\n2 1 V\n3 0 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 0 V\n2 1
      V\n3 1 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n2 1 V\n3 0 V\n3 1
      V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n3 1 V\n2 0 V\n3 0 V\n3 0 V\n3 1 V\n3 0
      V\n3 0 V\n3 0 V\n3 0 V\n2 1 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n2 0
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 1 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n3 0
      V\n3 1 V\n2 0 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n2 1
      V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 1 V\n3 0 V\n3 1 V\n2 1 V\n3 1 V\n3 1
      V\n3 1 V\n3 0 V\n3 1 V\n3 1 V\n3 1 V\n2 1 V\n3 2 V\ncurrentpoint stroke
      M\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 2 V\n3 1 V\n2 1 V\n3 2 V\n3 1 V\n3 2
      V\n3 1 V\n3 2 V\n3 1 V\n3 2 V\n2 2 V\n3 1 V\n3 2 V\n3 2 V\n3 2 V\n3 2
      V\n3 2 V\n3 2 V\n2 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 3
      V\n2 2 V\n3 2 V\n3 3 V\n3 2 V\n3 3 V\n3 2 V\n3 3 V\n3 3 V\n2 2 V\n3 3
      V\n3 3 V\n3 3 V\n3 2 V\n3 3 V\n3 3 V\n3 3 V\n2 3 V\n3 3 V\n3 3 V\n3 3
      V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n2 3 V\n3 3 V\n3 4 V\n3 3 V\n3 4 V\n3 3
      V\n3 3 V\n3 4 V\n2 3 V\n3 4 V\n3 4 V\n3 3 V\n3 4 V\n3 3 V\n3 4 V\n3 4
      V\n2 4 V\n3 3 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 3 V\n3 4 V\n2 4 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4
      V\n3 5 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 5
      V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 5 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 5 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 3 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n3 3 V\n2 4 V\n3 4 V\n3 4 V\n3 3 V\n3 4 V\n3 3
      V\n3 4 V\n3 4 V\n2 3 V\n3 4 V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n3 4 V\n3 3
      V\n2 3 V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n2 3 V\n3 3
      V\n3 3 V\n3 3 V\n3 2 V\n3 3 V\n3 3 V\n3 3 V\n2 2 V\n3 3 V\n3 3 V\n3 2
      V\n3 3 V\n3 2 V\n3 3 V\n3 2 V\n2 2 V\n3 3 V\n3 2 V\n3 2 V\n3 2 V\n3 2
      V\n3 2 V\n3 2 V\n2 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 1
      V\n2 2 V\n3 2 V\n3 1 V\n3 2 V\n3 1 V\n3 2 V\n3 1 V\n3 2 V\n2 1 V\n3 1
      V\n3 2 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 2 V\n2 1 V\n3 1 V\n3 1 V\n3 1
      V\n3 0 V\n3 1 V\n3 1 V\n3 1 V\n2 1 V\n3 1 V\n3 0 V\n3 1 V\n3 1 V\n3 0
      V\n3 1 V\n3 0 V\n2 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0
      V\n2 0 V\n3 1 V\n3 0 V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n2 0 V\n3 0
      V\n3 1 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 1 V\n3 0
      V\n3 0 V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n2 0 V\n3 1 V\n3 0 V\n3 0
      V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n2 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0
      V\n3 1 V\n3 1 V\n2 1 V\n3 0 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 0
      V\n2 1 V\n3 2 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n2 2 V\n3 1
      V\n3 1 V\n3 2 V\n3 1 V\n3 2 V\n3 1 V\n3 2 V\n2 1 V\n3 2 V\n3 2 V\n3 2
      V\n3 1 V\n3 2 V\n3 2 V\n3 2 V\n2 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2
      V\n3 2 V\n3 2 V\n2 3 V\n3 2 V\n3 2 V\n3 3 V\n3 2 V\n3 3 V\n3 2 V\n3 3
      V\n2 2 V\n3 3 V\n3 3 V\n3 2 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n2 3 V\n3 2
      V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n3 3 V\n2 3 V\n3 3 V\n3 4 V\n3 3
      V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n2 4 V\n3 3 V\n3 4 V\n3 3 V\n3 4 V\n3 4
      V\n3 3 V\n3 4 V\n2 4 V\n3 3 V\n3 4 V\n3 4 V\n3 4 V\n3 3 V\n3 4 V\n3 4
      V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4
      V\ncurrentpoint stroke M\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 4
      V\n3 4 V\n3 5 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 5 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 5 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 3 V\n2 4
      V\n3 4 V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n3 3 V\n3 4 V\n2 4 V\n3 3 V\n3 4
      V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n3 4 V\n2 3 V\n3 3 V\n3 4 V\n3 3 V\n3 3
      V\n3 3 V\n3 3 V\n3 3 V\n2 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3
      V\n3 3 V\n2 2 V\n3 3 V\n3 3 V\n3 2 V\n3 3 V\n3 2 V\n3 3 V\n3 2 V\n2 3
      V\n3 2 V\n3 3 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 3 V\n2 2 V\n3 2 V\n3 2
      V\n3 2 V\n3 2 V\n3 1 V\n3 2 V\n3 2 V\n2 2 V\n3 2 V\n3 1 V\n3 2 V\n3 1
      V\n3 2 V\n3 2 V\n3 1 V\n2 1 V\n3 2 V\n3 1 V\n3 2 V\n3 1 V\n3 1 V\n3 1
      V\n3 1 V\n2 2 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 0 V\n2 1
      V\n3 1 V\n3 1 V\n3 1 V\n3 0 V\n3 1 V\n3 1 V\n3 0 V\n2 1 V\n3 0 V\n3 1
      V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n2 1 V\n3 0 V\n3 0 V\n3 1 V\n3 0
      V\n3 0 V\n3 0 V\n3 1 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0
      V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 1 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n2 1 V\n3 0 V\n3 0 V\n3 1 V\n1.000
      UP\nstroke\ngrestore\nend\nshowpage\n>|ps>||||||>

      \;
    </output>

    <\input|octave\<gtr\> >
      gset term postscript enhanced eps color;
    </input>

    <\input|octave\<gtr\> >
      gset output "demo.eps"
    </input>

    <\input|octave\<gtr\> >
      plot(x,y,";Function y=x+sin(x);")
    </input>

    <\output>
      \;

      \;

      <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
      /tmp/tmplot.eps\n%%Creator: gnuplot 3.8h patchlevel 0\n%%CreationDate:
      Sun Mar 30 22:23:06 2003\n%%DocumentFonts: (atend)\n%%BoundingBox: 50
      50 230 176\n%%Orientation: Portrait\n%%EndComments\n/gnudict 256 dict
      def\ngnudict begin\n/Color true def\n/Solid false def\n/gnulinewidth
      5.000 def\n/userlinewidth gnulinewidth def\n/vshift -46 def\n/dl {10.0
      mul} def\n/hpt_ 31.5 def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_
      def\n/M {moveto} bind def\n/L {lineto} bind def\n/R {rmoveto} bind
      def\n/V {rlineto} bind def\n/N {newpath moveto} bind def\n/f {rlineto
      fill} bind def\n/vpt2 vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow {
      currentpoint stroke M\n \ 0 vshift R show } def\n/Rshow { currentpoint
      stroke M\n \ dup stringwidth pop neg vshift R show } def\n/Cshow {
      currentpoint stroke M\n \ dup stringwidth pop -2 div vshift R show }
      def\n/UP { dup vpt_ mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2
      hpt 2 mul def /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid
      {pop []} if 0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash}
      ifelse } def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL
      { stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
      mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul /udl
      exch def } def\n/PL { stroke userlinewidth setlinewidth } def\n/LTb {
      BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0 setdash 0 0 0
      setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 { PL [4 dl 2 dl] 0
      1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL } def\n/LT3 { PL [1 dl 1.5
      dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1 dl 2 dl] 0 1 1 DL }
      def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL } def\n/LT6 { PL [2 dl 2
      dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0 setdash\n \ \ gsave 1
      setlinecap M 0 0 V stroke grestore } def\n/Dia { stroke [] 0 setdash 2
      copy vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt
      neg vpt V closepath stroke\n \ Pnt } def\n/Pls { stroke [] 0 setdash
      vpt sub M 0 vpt2 V\n \ currentpoint stroke M\n \ hpt neg vpt neg R hpt2
      0 V stroke\n \ } def\n/Box { stroke [] 0 setdash 2 copy exch hpt sub
      exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
      closepath stroke\n \ Pnt } def\n/Crs { stroke [] 0 setdash exch hpt sub
      exch vpt add M\n \ hpt2 vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0
      R hpt2 vpt2 V stroke } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12
      mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      1.62 mul V closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs }
      def\n/BoxF { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill }
      def\n/TriUF { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt
      -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill
      } def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
      neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
      closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt 1.12
      mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash vpt add
      M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V
      closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy gsave\n
      \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath stroke
      grestore Pnt } def\n/PentF { stroke [] 0 setdash gsave\n \ translate 0
      hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath fill grestore }
      def\n/Circle { stroke [] 0 setdash 2 copy\n \ hpt 0 360 arc stroke Pnt
      } def\n/CircleF { stroke [] 0 setdash hpt 0 360 arc fill } def\n/C0 {
      BL [] 0 setdash 2 copy moveto vpt 90 450 \ arc } bind def\n/C1 { BL []
      0 setdash 2 copy \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C2 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C3 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
      bind def\n/C4 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
      \ vpt 180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 270 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C6 { BL [] 0
      setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 90 270 arc closepath
      fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
      def\n/C7 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 0 270
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
      } bind def\n/C8 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
      copy \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
      moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13 {
      BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
      setdash 2 copy vpt 0 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
      \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
      \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
      bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
      def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
      bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
      def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
      Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch vpt2
      vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy exch vpt
      sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 { BL [] 0
      setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt sub exch
      vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0 setdash 2
      copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare } bind
      def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt vpt2
      Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub vpt Square fill Bsquare
      } bind def\n/S9 { BL [] 0 setdash 2 copy vpt sub vpt vpt2 Rec fill
      Bsquare } bind def\n/S10 { BL [] 0 setdash 2 copy vpt sub vpt Square
      fill 2 copy exch vpt sub exch vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S11 { BL [] 0 setdash 2 copy vpt sub vpt Square fill 2 copy
      exch vpt sub exch vpt2 vpt Rec fill\n \ \ \ \ \ \ Bsquare } bind
      def\n/S12 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt
      Rec fill Bsquare } bind def\n/S13 { BL [] 0 setdash 2 copy exch vpt sub
      exch vpt sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill
      Bsquare } bind def\n/S14 { BL [] 0 setdash 2 copy exch vpt sub exch vpt
      sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square
      fill Bsquare } bind def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill
      Bsquare } bind def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke
      grestore } bind def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke
      grestore } bind def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke
      grestore } bind def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke
      grestore } bind def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke
      grestore } bind def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke
      grestore } bind def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke
      grestore } bind def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke
      grestore } bind def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke
      grestore } bind def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke
      grestore } bind def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke
      grestore } bind def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke
      grestore } bind def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke
      grestore } bind def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke
      grestore } bind def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke
      grestore } bind def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke
      grestore } bind def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg
      vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke }
      def\n/BoxE { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE
      { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke }
      def\n/TriDE { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt
      1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath
      stroke } def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M
      4 {72 rotate 0 hpt L} repeat\n \ closepath stroke grestore }
      def\n/CircE { stroke [] 0 setdash \n \ hpt 0 360 arc stroke }
      def\n/Opaque { gsave closepath 1 setgray fill grestore 0 setgray
      closepath } def\n/DiaW { stroke [] 0 setdash vpt add M\n \ hpt neg vpt
      neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V Opaque stroke }
      def\n/BoxW { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW {
      stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW
      { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW
      { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
      repeat\n \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash
      \n \ hpt 0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray
      fill grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
      makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
      ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0 get
      findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ] exch
      dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch 4 get
      {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n \ \ \ \ {dup 3
      get {2 get neg 0 exch R pop} {pop aload pop M} ifelse} {dup 5\n
      \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get stringwidth pop
      -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop -2 div 0 R 6 get\n
      \ \ \ \ show 2 index {aload pop M neg 3 -1 roll neg R pop pop} {pop pop
      pop\n \ \ \ \ pop aload pop M} ifelse }ifelse }ifelse } forall} bind
      def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get findfont exch 1 get
      scalefont\n \ \ \ \ setfont 6 get stringwidth pop add} {pop} ifelse}
      forall} bind def\n/MLshow { currentpoint stroke M\n \ 0 exch R MFshow }
      bind def\n/MRshow { currentpoint stroke M\n \ exch dup MFwidth neg 3 -1
      roll R MFshow } def\n/MCshow { currentpoint stroke M\n \ exch dup
      MFwidth -2 div 3 -1 roll R MFshow } def\nend\n%%EndProlog\ngnudict
      begin\ngsave\n50 50 translate\n0.050 0.050 scale\n0
      setgray\nnewpath\n(Helvetica) findfont 140 scalefont setfont\n1.000
      UL\nLTb\n490 280 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 280 M\n[
      [(Helvetica) 140.0 0.0 true true 0 (-10)]\n] -46.7 MRshow\n490 487
      M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 487 M\n[ [(Helvetica) 140.0
      0.0 true true 0 (-8)]\n] -46.7 MRshow\n490 694 M\n63 0 V\n2809 0 R\n-63
      0 V\n stroke\n406 694 M\n[ [(Helvetica) 140.0 0.0 true true 0 (-6)]\n]
      -46.7 MRshow\n490 902 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 902
      M\n[ [(Helvetica) 140.0 0.0 true true 0 (-4)]\n] -46.7 MRshow\n490 1109
      M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 1109 M\n[ [(Helvetica) 140.0
      0.0 true true 0 (-2)]\n] -46.7 MRshow\n490 1316 M\n63 0 V\n2809 0
      R\n-63 0 V\n stroke\n406 1316 M\n[ [(Helvetica) 140.0 0.0 true true 0 (
      0)]\n] -46.7 MRshow\n490 1523 M\n63 0 V\n2809 0 R\n-63 0 V\n
      stroke\n406 1523 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 2)]\n] -46.7
      MRshow\n490 1730 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 1730 M\n[
      [(Helvetica) 140.0 0.0 true true 0 ( 4)]\n] -46.7 MRshow\n490 1938
      M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 1938 M\n[ [(Helvetica) 140.0
      0.0 true true 0 ( 6)]\n] -46.7 MRshow\n490 2145 M\n63 0 V\n2809 0
      R\n-63 0 V\n stroke\n406 2145 M\n[ [(Helvetica) 140.0 0.0 true true 0 (
      8)]\n] -46.7 MRshow\n490 2352 M\n63 0 V\n2809 0 R\n-63 0 V\n
      stroke\n406 2352 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 10)]\n]
      -46.7 MRshow\n490 280 M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n490 140
      M\n[ [(Helvetica) 140.0 0.0 true true 0 (-10)]\n] -46.7 MCshow\n1208
      280 M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n1208 140 M\n[ [(Helvetica)
      140.0 0.0 true true 0 (-5)]\n] -46.7 MCshow\n1926 280 M\n0 63 V\n0 2009
      R\n0 -63 V\n stroke\n1926 140 M\n[ [(Helvetica) 140.0 0.0 true true 0 (
      0)]\n] -46.7 MCshow\n2644 280 M\n0 63 V\n0 2009 R\n0 -63 V\n
      stroke\n2644 140 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 5)]\n] -46.7
      MCshow\n3362 280 M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n3362 140 M\n[
      [(Helvetica) 140.0 0.0 true true 0 ( 10)]\n] -46.7 MCshow\n1.000
      UL\nLTb\n490 280 M\n2872 0 V\n0 2072 V\n-2872 0 V\n490 280 L\n1.000
      UP\n1.000 UL\nLT0\n490 336 M\n3 1 V\n3 0 V\n3 0 V\n2 1 V\n3 0 V\n3 0
      V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 0 V\n3 0 V\n2 1 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 1 V\n3 0 V\n3 0 V\n3 0
      V\n3 1 V\n3 0 V\n3 0 V\n2 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1
      V\n3 0 V\n2 1 V\n3 0 V\n3 1 V\n3 1 V\n3 0 V\n3 1 V\n3 1 V\n3 1 V\n2 1
      V\n3 0 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n2 2 V\n3 1 V\n3 1
      V\n3 1 V\n3 1 V\n3 2 V\n3 1 V\n3 2 V\n2 1 V\n3 1 V\n3 2 V\n3 2 V\n3 1
      V\n3 2 V\n3 1 V\n3 2 V\n2 2 V\n3 2 V\n3 2 V\n3 1 V\n3 2 V\n3 2 V\n3 2
      V\n3 2 V\n2 2 V\n3 3 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 3 V\n3 2 V\n2 3
      V\n3 2 V\n3 3 V\n3 2 V\n3 3 V\n3 2 V\n3 3 V\n3 3 V\n2 2 V\n3 3 V\n3 3
      V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n2 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3
      V\n3 3 V\n3 4 V\n3 3 V\n2 3 V\n3 4 V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n3 4
      V\n3 3 V\n2 4 V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n2 4
      V\n3 3 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n2 5 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n3 5 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 5 V\n3 4 V\n2 4
      V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 3 V\n3 4
      V\n3 4 V\n3 4 V\n3 3 V\n2 4 V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n3 3 V\n3 4
      V\n3 3 V\n2 4 V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n2 3
      V\n3 3 V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n3 2 V\n2 3 V\n3 3 V\n3 3
      V\n3 3 V\n3 3 V\n3 2 V\n3 3 V\n3 3 V\n2 2 V\n3 3 V\n3 2 V\n3 3 V\n3 2
      V\n3 3 V\n3 2 V\n3 2 V\n2 3 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2
      V\n3 2 V\n2 2 V\n3 2 V\n3 2 V\n3 2 V\n3 1 V\n3 2 V\n3 2 V\n3 2 V\n2 1
      V\n3 2 V\n3 1 V\n3 2 V\n3 1 V\n3 2 V\n3 1 V\n3 1 V\n2 2 V\n3 1 V\n3 1
      V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 2 V\n2 1 V\n3 0 V\n3 1 V\n3 1 V\n3 1
      V\n3 1 V\n3 1 V\n3 0 V\n2 1 V\n3 1 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1
      V\n3 0 V\n2 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n3 1 V\n2 0
      V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 1 V\n3 0 V\n3 0
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 1 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n2 0 V\n3 0 V\n3 0
      V\n3 1 V\n3 0 V\n3 0 V\n3 0 V\n3 1 V\n2 0 V\n3 0 V\n3 1 V\n3 0 V\n3 1
      V\n3 0 V\n3 1 V\n3 0 V\n2 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 1 V\n3 0
      V\n3 1 V\n2 1 V\n3 1 V\n3 1 V\n3 1 V\n3 0 V\n3 1 V\n3 1 V\n3 1 V\n2 1
      V\n3 2 V\n3 1 V\n3 1 V\ncurrentpoint stroke M\n3 1 V\n3 1 V\n3 2 V\n3 1
      V\n2 1 V\n3 2 V\n3 1 V\n3 2 V\n3 1 V\n3 2 V\n3 1 V\n3 2 V\n2 2 V\n3 1
      V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n2 2 V\n3 2 V\n3 2 V\n3 2
      V\n3 2 V\n3 2 V\n3 2 V\n3 3 V\n2 2 V\n3 2 V\n3 3 V\n3 2 V\n3 3 V\n3 2
      V\n3 3 V\n3 3 V\n2 2 V\n3 3 V\n3 3 V\n3 3 V\n3 2 V\n3 3 V\n3 3 V\n3 3
      V\n2 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n2 3 V\n3 3
      V\n3 4 V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n3 4 V\n2 3 V\n3 4 V\n3 4 V\n3 3
      V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n2 4 V\n3 3 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n3 3 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 5 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n3 5 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 5
      V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 5 V\n3 4
      V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n2 4 V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 3 V\n2 4 V\n3 4
      V\n3 4 V\n3 3 V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n2 3 V\n3 4 V\n3 3 V\n3 3
      V\n3 4 V\n3 3 V\n3 4 V\n3 3 V\n2 3 V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n3 3
      V\n3 3 V\n3 3 V\n2 3 V\n3 3 V\n3 3 V\n3 3 V\n3 2 V\n3 3 V\n3 3 V\n3 3
      V\n2 2 V\n3 3 V\n3 3 V\n3 2 V\n3 3 V\n3 2 V\n3 3 V\n3 2 V\n2 2 V\n3 3
      V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n2 2 V\n3 2 V\n3 2 V\n3 2
      V\n3 2 V\n3 2 V\n3 2 V\n3 1 V\n2 2 V\n3 2 V\n3 1 V\n3 2 V\n3 1 V\n3 2
      V\n3 1 V\n3 2 V\n2 1 V\n3 1 V\n3 2 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n3 2
      V\n2 1 V\n3 1 V\n3 1 V\n3 1 V\n3 0 V\n3 1 V\n3 1 V\n3 1 V\n2 1 V\n3 1
      V\n3 0 V\n3 1 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n2 1 V\n3 0 V\n3 1 V\n3 0
      V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n2 0 V\n3 1 V\n3 0 V\n3 0 V\n3 0 V\n3 1
      V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 1
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 0 V\n2 1 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0
      V\n2 0 V\n3 1 V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n2 1 V\n3 0
      V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 1 V\n2 1 V\n3 0 V\n3 1 V\n3 1
      V\n3 1 V\n3 1 V\n3 1 V\n3 0 V\n2 1 V\n3 2 V\n3 1 V\n3 1 V\n3 1 V\n3 1
      V\n3 1 V\n3 1 V\n2 2 V\n3 1 V\n3 1 V\n3 2 V\n3 1 V\n3 2 V\n3 1 V\n3 2
      V\n2 1 V\n3 2 V\n3 2 V\n3 2 V\n3 1 V\n3 2 V\n3 2 V\n3 2 V\n2 2 V\n3 2
      V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n2 3 V\n3 2 V\n3 2 V\n3 3
      V\n3 2 V\n3 3 V\n3 2 V\n3 3 V\n2 2 V\n3 3 V\n3 3 V\n3 2 V\n3 3 V\n3 3
      V\n3 3 V\n3 3 V\n2 3 V\n3 2 V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n3 3
      V\n2 3 V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n2 4 V\n3 3
      V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n3 3 V\n3 4 V\n2 4 V\n3 3 V\n3 4 V\n3 4
      V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\ncurrentpoint stroke M\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 5 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n3 4 V\n2 4 V\n3 5 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 5
      V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4
      V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4 V\n2 4 V\n3 4 V\n3 4 V\n3 4 V\n3 4
      V\n3 4 V\n3 4 V\n3 3 V\n2 4 V\n3 4 V\n3 4 V\n3 3 V\n3 4 V\n3 4 V\n3 3
      V\n3 4 V\n2 4 V\n3 3 V\n3 4 V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n3 4 V\n2 3
      V\n3 3 V\n3 4 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n2 3 V\n3 3 V\n3 3
      V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n3 3 V\n2 2 V\n3 3 V\n3 3 V\n3 2 V\n3 3
      V\n3 2 V\n3 3 V\n3 2 V\n2 3 V\n3 2 V\n3 3 V\n3 2 V\n3 2 V\n3 2 V\n3 2
      V\n3 3 V\n2 2 V\n3 2 V\n3 2 V\n3 2 V\n3 2 V\n3 1 V\n3 2 V\n3 2 V\n2 2
      V\n3 2 V\n3 1 V\n3 2 V\n3 1 V\n3 2 V\n3 2 V\n3 1 V\n2 1 V\n3 2 V\n3 1
      V\n3 2 V\n3 1 V\n3 1 V\n3 1 V\n3 1 V\n2 2 V\n3 1 V\n3 1 V\n3 1 V\n3 1
      V\n3 1 V\n3 1 V\n3 0 V\n2 1 V\n3 1 V\n3 1 V\n3 1 V\n3 0 V\n3 1 V\n3 1
      V\n3 0 V\n2 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n3 1 V\n3 0 V\n2 1
      V\n3 0 V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n3 0 V\n3 1 V\n2 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 1 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0
      V\n3 0 V\n2 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 1
      V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 0 V\n3 0 V\n3 0
      V\n3 1 V\n3 0 V\n3 0 V\n3 0 V\n3 0 V\n2 1 V\n3 0 V\n3 0 V\n3 1 V\n1.000
      UP\nstroke\ngrestore\nend\nshowpage\n>|ps>||||||>

      \;
    </output>

    \;

    <\input|octave\<gtr\> >
      \;
    </input>
  </session>

  In the octave generic terminal, the graph will not appear instead of
  demo.eps being created. By the way, note that its syntax is similar to
  Matlab but not similar to Maple.\ 

  \;

  Maxima applies many functions for mathematical calculation, for example, it
  can be also used to solve the algebra equations:

  <\session|maxima|default>
    <\output>
      GCL (GNU Common Lisp) \ Version(2.5.0) g \ 2 \ 7 19:50:19 CST 2003

      Licensed under GNU Library General Public License

      Contains Enhancements by W. Schelter

      Maxima 5.9.0rc3 http://maxima.sourceforge.net

      Distributed under the GNU Public License. See the file COPYING.

      Dedicated to the memory of William Schelter.

      This is a development version of Maxima. The function bug_report()

      provides bug reporting information.

      \;
    </output>

    <\input|<\with|color|red>
      (C1) <with|color|black|>
    </with>>
      linsolve([a*x+b*y=m,c*x+d*y=n],[x,y]);
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<with|mode|text|font
        family|tt|color|red|(D7) <with|color|black|>><left|[>x=-<frac|d*m-b*n|b*C-a*d>,y=<frac|C*m-a*n|b*C-a*d><right|]>>
      </with>

      \;
    </output>

    <\input|<\with|color|red>
      (C8) <with|color|black|>
    </with>>
      solve(x^3-x=0,x);
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<with|mode|text|font
        family|tt|color|red|(D8) <with|color|black|>><left|[>x=-1,x=1,x=0<right|]>>
      </with>

      \;
    </output>

    <\input|<\with|color|red>
      (C9) <with|color|black|>
    </with>>
      diff((x^2+a)^(1/2),x);
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<with|mode|text|font
        family|tt|color|red|(D9) <with|color|black|>><frac|x|<sqrt|x<rsup|2>+a>>>
      </with>

      \;
    </output>

    <\input|<\with|color|red>
      (C10) <with|color|black|>
    </with>>
      integrate((x^2+a)^(1/2),x);
    </input>

    <\input|<\with|color|red>
      <with|mode|math|formula style|true|<with|mode|text|Is
      >a<with|mode|text| positive or negative?>> <with|color|black|>
    </with>>
      positive
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<with|mode|text|font
        family|tt|color|red|(D10) <with|color|black|>><frac|a*<with|math font
        family|rm|ASINH><left|(><frac|x|<sqrt|a>><right|)>|2>+<frac|x*<sqrt|x<rsup|2>+a>|2>>
      </with>

      \;
    </output>

    <\input|<\with|color|red>
      (C11) <with|color|black|>
    </with>>
      integrate((x^2+a)^(1/2),x,0,1);
    </input>

    <\input|<\with|color|red>
      <with|mode|math|formula style|true|<with|mode|text|Is
      >a<with|mode|text| positive or negative?>> <with|color|black|>
    </with>>
      negative
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<with|mode|text|font
        family|tt|color|red|(D11) <with|color|black|>><frac|a*log
        <left|(>2*<sqrt|a+1>+2<right|)>+<sqrt|a+1>|2>-<frac|log
        <left|(>2*<sqrt|a><right|)>*a|2>>
      </with>

      \;
    </output>

    <\input|<\with|color|red>
      (C12) <with|color|black|>
    </with>>
      limit((x^2+a)^(1/2),x,0);
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<with|mode|text|font
        family|tt|color|red|(D12) <with|color|black|>><sqrt|a>>
      </with>

      \;
    </output>

    <\input|<\with|color|red>
      (C13) <with|color|black|>
    </with>>
      \;
    </input>
  </session>

  The symbolic calculation of Maxima has shown above, including solving
  equations, evaluating limit, differentiation and integration. In the
  examples of integration, maxima will ask the user more conditions if
  necessarily.

  Now let us introduce Yacas (yes, another CAS). The following is mini demo:

  <\session|yacas|default>
    <\input|yacas] >
      Solve(x^3+b+1==0,x);
    </input>

    <\output>
      <\with|mode|math>
        <sqrt|b+1|3>
      </with>
    </output>

    <\input|yacas] >
      D(x) (x^2+a)^(1/2);
    </input>

    <\output>
      <\with|mode|math>
        <frac|<left|(>x<rsup|2>+a<right|)><rsup|<frac|-1|2>>2x|2>
      </with>
    </output>

    <\input|yacas] >
      Limit(x,0) (1-Cos(x))/x^2;
    </input>

    <\output>
      <\with|mode|math>
        <frac|1|2>
      </with>
    </output>

    <\input|yacas] >
      Integrate(x,0,pi) x+Sin(x);
    </input>

    <\output>
      <\with|mode|math>
        <frac|\<pi\><rsup|2>|2>-<left|(>cos \<pi\><right|)>+1
      </with>
    </output>

    <\input|yacas] >
      f(x):= x+sin(x);
    </input>

    <\output>
      <\with|mode|math>
        <with|math font family|rm|True>
      </with>
    </output>

    <\input|yacas] >
      GnuPlot(-Pi/2,Pi/2,80,f(x));
    </input>

    <\output>
      <\with|mode|math>
        <with|math font family|rm|GnuPlot><left|(>-<frac|\<pi\>|2>,<frac|\<pi\>|2>,80,f<left|(>x<right|)><right|)>
      </with>
    </output>

    <\input|yacas] >
      \;
    </input>
  </session>

  The last command of plotting will not have any correspondence here.

  <\exercise>
    Plot the graphs of the following functions: a)
    <with|mode|math|x<rsup|2>+3x-2> \ \ b)
    <with|mode|math|<frac|x<rsup|2>+1|x<rsup|4>+x+1>> \ c)
    <with|mode|math|<sqrt|s<rsup|2>+1>>

    \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ d)
    <with|mode|math|<frac|sin(\<pi\>x/2)-1|1-x<rsup|2>>> \ e)
    <with|mode|math|x<rsup|3>+<frac|3|x<rsup|2>>> \ \ f)
    <with|mode|math|(x+1)<rsup|1/3>>
  </exercise>

  <\exercise>
    Plot the graph of the function:

    <\expand|equation*>
      f(x)= <choice|<tformat|<table|<row|<cell|(x+1)<rsup|2> \ \ if
      x\<gtr\>-1, >>|<row|<cell| x \ +1 \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ otherwise
      \ \ \ \ \ \ \ \ >>>>>
    </expand>
  </exercise>

  <\exercise>
    Solve <with|mode|math|><with|mode|math|3x+4y=5, 9x+10y=11> for
    <with|mode|math|x,y>.
  </exercise>

  <\exercise>
    Differentiate the functions in <strong|Exercise 1<strong|>>.
  </exercise>

  Which application with plotting ability is excellent? This answer will be
  different for different persons. From my view, Maxima or Gnuplot is better
  one if the solutions of functions are in explicit form. But if the solution
  are in implicit form, consider the tools with numerical utility, for
  example Octave.\ 

  <\example>
    (Butterfly Effect) Remember what the crazy physician said about this in
    movie "Jurassic Park". This is one phenomenon about atmosphere and named
    by its solution curve. This effect depends on the differential equations:

    <\expand|eqnarray*>
      <tformat|<table|<row|<cell|<frac|d x<rsub|1>(t)|d
      t>>|<cell|=>|<cell|-10(x<rsub|1>(t)-x<rsub|2>(t))>>|<row|<cell|<frac|d
      x<rsub|2>(t)|d t>>|<cell|=>|<cell|28x<rsub|1>(t)-x<rsub|2>(t)-x<rsub|1>(t)x<rsub|3>(t)>>|<row|<cell|<frac|d
      x<rsub|3>(t)|d t>>|<cell|=>|<cell|<frac|8|3> \ <left|(>
      x<rsub|1>(t)x<rsub|2>(t)-x<rsub|3>(t) <right|)>>>|<row|<cell|Initial
      condition:>|<cell|>|<cell|x<rsub|1>(0)=2, x<rsub|2>(0)=5,
      x<rsub|3>(0)=10>>>>
    </expand>

    Solve this initial value problem by Octave:

    <\session|octave|default>
      <\output>
        GNU Octave, version 2.1.45 (i686-pc-linux-gnu).

        Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003 John W.
        Eaton.

        This is free software; see the source code for copying conditions.

        There is ABSOLUTELY NO WARRANTY; not even for MERCHANTIBILITY or

        FITNESS FOR A PARTICULAR PURPOSE.

        \;

        Report bugs to \<less\>bug-octave@bevo.che.wisc.edu\<gtr\>.

        \;
      </output>

      <\input|octave\<gtr\> >
        x0=[2;5;10];
      </input>

      <\input|octave\<gtr\> >
        t = linspace (0,10,800);
      </input>

      <\input|octave\<gtr\> >
        function dx = butter (x ,t) \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ dx(1)
        = -10.0*(x(1)-x(2)); \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ dx(2)
        = 28.0*x(1)-x(2)-x(1)*x(3); \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ dx(3)
        = 8.0/3.0*( x(1)*x(2) -x(3) ); \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ end;
      </input>

      <\input|octave\<gtr\> >
        y=lsode("butter",x0,t);
      </input>

      <\input|octave\<gtr\> >
        gset parametric;
      </input>

      <\input|octave\<gtr\> >
        plot(y(:,1),y(:,3))
      </input>

      <\output>
        \;

        \;

        <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
        /tmp/tmplot.eps\n%%Creator: gnuplot 3.8h patchlevel
        0\n%%CreationDate: Sun Apr \ 6 18:03:11 2003\n%%DocumentFonts:
        (atend)\n%%BoundingBox: 50 50 230 176\n%%Orientation:
        Portrait\n%%EndComments\n/gnudict 256 dict def\ngnudict begin\n/Color
        true def\n/Solid false def\n/gnulinewidth 5.000 def\n/userlinewidth
        gnulinewidth def\n/vshift -46 def\n/dl {10.0 mul} def\n/hpt_ 31.5
        def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_ def\n/M {moveto} bind
        def\n/L {lineto} bind def\n/R {rmoveto} bind def\n/V {rlineto} bind
        def\n/N {newpath moveto} bind def\n/f {rlineto fill} bind def\n/vpt2
        vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow { currentpoint stroke M\n
        \ 0 vshift R show } def\n/Rshow { currentpoint stroke M\n \ dup
        stringwidth pop neg vshift R show } def\n/Cshow { currentpoint stroke
        M\n \ dup stringwidth pop -2 div vshift R show } def\n/UP { dup vpt_
        mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2 hpt 2 mul def
        /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid {pop []} if
        0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash} ifelse }
        def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL {
        stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
        mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul
        /udl exch def } def\n/PL { stroke userlinewidth setlinewidth }
        def\n/LTb { BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0
        setdash 0 0 0 setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 {
        PL [4 dl 2 dl] 0 1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL }
        def\n/LT3 { PL [1 dl 1.5 dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1
        dl 2 dl] 0 1 1 DL } def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL }
        def\n/LT6 { PL [2 dl 2 dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl
        2 dl 2 dl 2 dl 2 dl 4 dl] 1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl
        2 dl 2 dl 2 dl 2 dl 4 dl] 0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0
        setdash\n \ \ gsave 1 setlinecap M 0 0 V stroke grestore } def\n/Dia
        { stroke [] 0 setdash 2 copy vpt add M\n \ hpt neg vpt neg V hpt vpt
        neg V\n \ hpt vpt V hpt neg vpt V closepath stroke\n \ Pnt }
        def\n/Pls { stroke [] 0 setdash vpt sub M 0 vpt2 V\n \ currentpoint
        stroke M\n \ hpt neg vpt neg R hpt2 0 V stroke\n \ } def\n/Box {
        stroke [] 0 setdash 2 copy exch hpt sub exch vpt add M\n \ 0 vpt2 neg
        V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke\n \ Pnt }
        def\n/Crs { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ hpt2
        vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0 R hpt2 vpt2 V stroke
        } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12 mul add M\n \ hpt
        neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V
        closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs } def\n/BoxF
        { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2 neg V
        \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill } def\n/TriUF
        { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul
        V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill }
        def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
        neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
        closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt
        1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt
        neg vpt -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash
        vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg
        vpt V closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy
        gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n
        \ closepath stroke grestore Pnt } def\n/PentF { stroke [] 0 setdash
        gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n
        \ closepath fill grestore } def\n/Circle { stroke [] 0 setdash 2
        copy\n \ hpt 0 360 arc stroke Pnt } def\n/CircleF { stroke [] 0
        setdash hpt 0 360 arc fill } def\n/C0 { BL [] 0 setdash 2 copy moveto
        vpt 90 450 \ arc } bind def\n/C1 { BL [] 0 setdash 2 copy
        \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc closepath
        fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
        def\n/C2 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        90 180 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
        closepath } bind def\n/C3 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ \ 2 copy \ vpt 0 180 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C4 {
        BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 180 270 arc
        closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
        } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
        \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360
        arc } bind def\n/C6 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
        copy \ vpt 90 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt
        0 360 arc closepath } bind def\n/C7 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ 2 copy \ vpt 0 270 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C8 {
        BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt 270 360 arc
        closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
        bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy
        \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
        360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
        moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
        \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11
        { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
        closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360
        arc closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13
        { BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
        closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360
        arc closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
        setdash 2 copy vpt 0 360 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
        \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
        \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
        bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
        def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
        bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
        def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
        Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch
        vpt2 vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy
        exch vpt sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 {
        BL [] 0 setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt
        sub exch vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0
        setdash 2 copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare }
        bind def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt
        vpt2 Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n
        \ \ \ \ \ \ Bsquare } bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub
        vpt Square fill Bsquare } bind def\n/S9 { BL [] 0 setdash 2 copy vpt
        sub vpt vpt2 Rec fill Bsquare } bind def\n/S10 { BL [] 0 setdash 2
        copy vpt sub vpt Square fill 2 copy exch vpt sub exch vpt Square
        fill\n \ \ \ \ \ \ Bsquare } bind def\n/S11 { BL [] 0 setdash 2 copy
        vpt sub vpt Square fill 2 copy exch vpt sub exch vpt2 vpt Rec fill\n
        \ \ \ \ \ \ Bsquare } bind def\n/S12 { BL [] 0 setdash 2 copy exch
        vpt sub exch vpt sub vpt2 vpt Rec fill Bsquare } bind def\n/S13 { BL
        [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt Rec fill\n
        \ \ \ \ \ \ 2 copy vpt Square fill Bsquare } bind def\n/S14 { BL [] 0
        setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt Rec fill\n
        \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square fill Bsquare } bind
        def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill Bsquare } bind
        def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke grestore } bind
        def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke grestore } bind
        def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke grestore } bind
        def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke grestore } bind
        def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke grestore } bind
        def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke grestore } bind
        def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke grestore } bind
        def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke grestore } bind
        def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke grestore } bind
        def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke grestore } bind
        def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke grestore } bind
        def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke grestore } bind
        def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke grestore } bind
        def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke grestore } bind
        def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke grestore } bind
        def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke grestore } bind
        def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg vpt neg V hpt
        vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke } def\n/BoxE {
        stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2 neg V hpt2
        0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE { stroke
        [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2
        mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke } def\n/TriDE {
        stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
        \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath stroke }
        def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72
        rotate 0 hpt L} repeat\n \ closepath stroke grestore } def\n/CircE {
        stroke [] 0 setdash \n \ hpt 0 360 arc stroke } def\n/Opaque { gsave
        closepath 1 setgray fill grestore 0 setgray closepath } def\n/DiaW {
        stroke [] 0 setdash vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n
        \ hpt vpt V hpt neg vpt V Opaque stroke } def\n/BoxW { stroke [] 0
        setdash exch hpt sub exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2
        V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW { stroke [] 0 setdash
        vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n
        \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW { stroke [] 0
        setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0
        V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW { stroke []
        0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n
        \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash \n \ hpt
        0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray fill
        grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
        makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
        ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0
        get findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ]
        exch dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch
        4 get {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n
        \ \ \ \ {dup 3 get {2 get neg 0 exch R pop} {pop aload pop M} ifelse}
        {dup 5\n \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get
        stringwidth pop -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop
        -2 div 0 R 6 get\n \ \ \ \ show 2 index {aload pop M neg 3 -1 roll
        neg R pop pop} {pop pop pop\n \ \ \ \ pop aload pop M} ifelse }ifelse
        }ifelse } forall} bind def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get
        findfont exch 1 get scalefont\n \ \ \ \ setfont 6 get stringwidth pop
        add} {pop} ifelse} forall} bind def\n/MLshow { currentpoint stroke
        M\n \ 0 exch R MFshow } bind def\n/MRshow { currentpoint stroke M\n
        \ exch dup MFwidth neg 3 -1 roll R MFshow } def\n/MCshow {
        currentpoint stroke M\n \ exch dup MFwidth -2 div 3 -1 roll R MFshow
        } def\nend\n%%EndProlog\ngnudict begin\ngsave\n50 50 translate\n0.050
        0.050 scale\n0 setgray\nnewpath\n(Helvetica) findfont 140 scalefont
        setfont\n1.000 UL\nLTb\n490 280 M\n63 0 V\n2809 0 R\n-63 0 V\n
        stroke\n406 280 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 5)]\n]
        -46.7 MRshow\n490 539 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 539
        M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 10)]\n] -46.7 MRshow\n490
        798 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 798 M\n[ [(Helvetica)
        140.0 0.0 true true 0 ( 15)]\n] -46.7 MRshow\n490 1057 M\n63 0
        V\n2809 0 R\n-63 0 V\n stroke\n406 1057 M\n[ [(Helvetica) 140.0 0.0
        true true 0 ( 20)]\n] -46.7 MRshow\n490 1316 M\n63 0 V\n2809 0 R\n-63
        0 V\n stroke\n406 1316 M\n[ [(Helvetica) 140.0 0.0 true true 0 (
        25)]\n] -46.7 MRshow\n490 1575 M\n63 0 V\n2809 0 R\n-63 0 V\n
        stroke\n406 1575 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 30)]\n]
        -46.7 MRshow\n490 1834 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406
        1834 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 35)]\n] -46.7
        MRshow\n490 2093 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 2093 M\n[
        [(Helvetica) 140.0 0.0 true true 0 ( 40)]\n] -46.7 MRshow\n490 2352
        M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 2352 M\n[ [(Helvetica)
        140.0 0.0 true true 0 ( 45)]\n] -46.7 MRshow\n490 280 M\n0 63 V\n0
        2009 R\n0 -63 V\n stroke\n490 140 M\n[ [(Helvetica) 140.0 0.0 true
        true 0 (-15)]\n] -46.7 MCshow\n969 280 M\n0 63 V\n0 2009 R\n0 -63 V\n
        stroke\n969 140 M\n[ [(Helvetica) 140.0 0.0 true true 0 (-10)]\n]
        -46.7 MCshow\n1447 280 M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n1447
        140 M\n[ [(Helvetica) 140.0 0.0 true true 0 (-5)]\n] -46.7
        MCshow\n1926 280 M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n1926 140 M\n[
        [(Helvetica) 140.0 0.0 true true 0 ( 0)]\n] -46.7 MCshow\n2405 280
        M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n2405 140 M\n[ [(Helvetica)
        140.0 0.0 true true 0 ( 5)]\n] -46.7 MCshow\n2883 280 M\n0 63 V\n0
        2009 R\n0 -63 V\n stroke\n2883 140 M\n[ [(Helvetica) 140.0 0.0 true
        true 0 ( 10)]\n] -46.7 MCshow\n3362 280 M\n0 63 V\n0 2009 R\n0 -63
        V\n stroke\n3362 140 M\n[ [(Helvetica) 140.0 0.0 true true 0 (
        15)]\n] -46.7 MCshow\n1.000 UL\nLTb\n490 280 M\n2872 0 V\n0 2072
        V\n-2872 0 V\n490 280 L\n1.000 UP\n1.000 UL\nLT0\n2711 2219 M\n[
        [(Helvetica) 140.0 0.0 true true 0 (line 1)]\n] -46.7 MRshow\n2795
        2219 M\n399 0 V\n2117 539 M\n37 2 V\n37 8 V\n39 14 V\n41 22 V\n44 30
        V\n47 41 V\n51 54 V\n54 67 V\n56 83 V\n59 100 V\n60 117 V\n59 134
        V\n55 147 V\n50 155 V\n41 157 V\n30 149 V\n14 133 V\n-1 107 V\n-19 76
        V\n-35 42 V\n-51 9 V\n-62 -20 V\n-71 -43 V\n-76 -59 V\n-78 -68 V\n-78
        -73 V\n-74 -75 V\n-70 -72 V\n-65 -69 V\n-58 -66 V\n-53 -61 V\n-46 -57
        V\n-41 -54 V\n-36 -50 V\n-31 -48 V\n-28 -44 V\n-23 -42 V\n-21 -40
        V\n-18 -38 V\n-17 -36 V\n-15 -34 V\n-14 -32 V\n-13 -30 V\n-12 -29
        V\n-13 -27 V\n-12 -25 V\n-14 -23 V\n-13 -21 V\n-15 -19 V\n-15 -16
        V\n-17 -14 V\n-18 -10 V\n-19 -8 V\n-22 -4 V\n-23 0 V\n-25 5 V\n-27 11
        V\n-29 16 V\n-31 22 V\n-33 30 V\n-35 38 V\n-36 46 V\n-38 54 V\n-37 64
        V\n-37 71 V\n-36 79 V\n-33 83 V\n-29 87 V\n-24 86 V\n-18 83 V\n-10 76
        V\n-2 66 V\n7 52 V\n15 37 V\n24 21 V\n31 6 V\n37 -9 V\n42 -20 V\n45
        -31 V\n46 -37 V\n47 -44 V\n46 -46 V\n43 -49 V\n41 -49 V\n38 -49 V\n35
        -48 V\n31 -48 V\n28 -46 V\n24 -45 V\n21 -43 V\n18 -42 V\n15 -40 V\n12
        -39 V\n10 -38 V\n8 -36 V\n5 -35 V\n4 -33 V\n2 -33 V\n1 -31 V\n-1 -29
        V\n-3 -29 V\n-3 -27 V\n-5 -25 V\n-7 -24 V\n-8 -23 V\n-9 -21 V\n-11
        -19 V\n-12 -17 V\n-14 -15 V\n-15 -13 V\n-18 -10 V\n-19 -7 V\n-22 -3
        V\n-24 1 V\n-26 6 V\n-29 11 V\n-32 18 V\n-34 25 V\n-37 33 V\n-40 42
        V\n-42 53 V\n-43 63 V\n-45 75 V\n-44 85 V\n-44 96 V\n-41 104 V\n-37
        108 V\n-30 110 V\n-23 105 V\n-13 96 V\n-3 82 V\n9 65 V\n20 43 V\n30
        23 V\n40 2 V\n47 -16 V\n53 -30 V\n56 -42 V\n57 -49 V\n57 -54 V\n54
        -57 V\n52 -57 V\n49 -57 V\n44 -56 V\n40 -53 V\n36 -52 V\n31 -50 V\n28
        -48 V\n23 -46 V\n21 -44 V\n17 -43 V\n15 -40 V\n12 -40 V\n10 -38 V\n9
        -36 V\n7 -36 V\n5 -34 V\n5 -33 V\n3 -32 V\n3 -31 V\n2 -30 V\n1 -28
        V\n1 -28 V\n0 -27 V\n0 -26 V\n0 -25 V\n-1 -25 V\n-1 -23 V\n-2 -23
        V\n-2 -22 V\n-2 -21 V\n-3 -21 V\n-3 -19 V\n-3 -19 V\n-4 -18 V\n-5 -18
        V\n-5 -17 V\n-6 -16 V\n-6 -15 V\n-8 -14 V\n-8 -14 V\n-10 -12 V\n-11
        -12 V\n-12 -10 V\n-14 -9 V\n-15 -7 V\n-18 -5 V\n-20 -3 V\n-22 0
        V\n-25 4 V\n-29 8 V\n-32 13 V\n-36 20 V\n-40 28 V\n-44 38 V\n-49 49
        V\n-53 64 V\n-58 80 V\n-61 99 V\n-64 118 V\n-65 138 V\n-64 157 V\n-60
        171 V\n-52 178 V\n-41 176 V\n-26 163 V\n-8 139 V\n11 104 V\n31 64
        V\n49 25 V\n65 -12 V\n76 -41 V\n84 -62 V\n87 -75 V\n87 -81 V\n84 -82
        V\n79 -79 V\n74 -75 V\n66 -70 V\n60 -65 V\n53 -59 V\n46 -55 V\n41 -51
        V\n35 -47 V\n31 -44 V\n27 -40 V\n24 -39 V\n21 -35 V\n19 -34 V\n18 -31
        V\n16 -29 V\n15 -27 V\n15 -25 V\n15 -23 V\n15 -20 V\n16 -18 V\n16 -15
        V\n17 -12 V\n18 -9 V\n19 -6 V\n21 -2 V\n22 2 V\n23 7 V\n25 12 V\n26
        17 V\n28 23 V\n29 29 V\n30 35 V\n30 42 V\n31 48 V\n29 54 V\n29 59
        V\n27 63 V\n24 65 V\n20 66 V\n15 64 V\n10 59 V\n5 54 V\n-2 44 V\n-9
        35 V\n-15 24 V\n-20 13 V\n-26 2 V\n-30 -8 V\n-33 -16 V\n-35 -24
        V\n-36 -30 V\n-36 -34 V\n-36 -38 V\n-34 -39 V\n-32 -41 V\n-30 -41
        V\n-28 -41 V\n-24 -40 V\n-22 -40 V\n-20 -39 V\n-16 -38 V\n-14 -37
        V\n-11 -36 V\n-9 -34 V\n-6 -33 V\n-4 -31 V\n-3 -30 V\n0 -29 V\n2 -27
        V\n3 -25 V\n5 -24 V\n7 -22 V\n9 -19 V\n10 -18 V\n12 -15 V\n14 -12
        V\n15 -9 V\n18 -6 V\n20 -3 V\n21 2 V\n23 6 V\n26 12 V\n27 17 V\n29 24
        V\n31 30 V\n33 37 V\n33 45 V\n34 53 V\n33 59 V\n33 66 V\n31 72 V\n28
        75 V\n25 76 V\n19 75 V\n13 71 V\n7 64 V\n-1 54 V\n-9 42 V\n-15 29
        V\n-23 16 V\n-29 3 V\n-34 -9 V\n-37 -19 V\n-40 -27 V\n-42 -34 V\n-41
        -39 V\n-41 -43 V\n-39 -44 V\n-36 -45 V\n-34 -45 V\n-31 -45 V\n-28 -44
        V\n-24 -43 V\n-22 -42 V\n-18 -41 V\n-16 -39 V\n-13 -39 V\n-10 -36
        V\n-8 -36 V\n-6 -34 V\n-4 -33 V\n-2 -31 V\n0 -30 V\n2 -28 V\n3 -27
        V\n5 -26 V\n6 -23 V\n8 -22 V\n10 -20 V\n11 -18 V\n14 -15 V\n14 -13
        V\n17 -10 V\n19 -7 V\n20 -3 V\n23 1 V\n25 6 V\n27 11 V\n30 17 V\n32
        24 V\n34 32 V\n36 40 V\n37 48 V\n39 58 V\n39 67 V\n38 75 V\n37 83
        V\n35 88 V\n30 92 V\n24 91 V\n18 86 V\n10 79 V\n1 68 V\n-9 52 V\n-17
        37 V\n-26 19 V\n-34 4 V\n-40 -12 V\n-44 -23 V\n-47 -34 V\n-49 -41
        V\n-49 -46 V\n-47 -49 V\n-45 -50 V\n-42 -51 V\n-39 -51 V\n-36 -49
        V\n-32 -49 V\n-28 -46 V\n-24 -46 V\n-21 -44 V\n-18 -42 V\n-15 -41
        V\n-13 -39 V\n-10 -38 V\n-8 -37 V\n-6 -35 V\n-4 -34 V\n-3 -33 V\n-1
        -31 V\n1 -31 V\ncurrentpoint stroke M\n1 -29 V\n3 -27 V\n4 -27 V\n5
        -25 V\n7 -24 V\n7 -22 V\n9 -21 V\n11 -19 V\n12 -18 V\n13 -15 V\n15
        -14 V\n17 -10 V\n19 -8 V\n21 -5 V\n23 -1 V\n26 4 V\n28 9 V\n32 15
        V\n34 22 V\n37 30 V\n40 39 V\n42 49 V\n45 61 V\n47 73 V\n47 85 V\n47
        97 V\n46 108 V\n42 114 V\n36 119 V\n29 117 V\n20 109 V\n8 97 V\n-3 79
        V\n-16 57 V\n-28 33 V\n-39 11 V\n-48 -11 V\n-54 -27 V\n-59 -41 V\n-61
        -51 V\n-61 -57 V\n-59 -59 V\n-57 -61 V\n-53 -60 V\n-48 -58 V\n-44 -56
        V\n-40 -54 V\n-35 -52 V\n-30 -50 V\n-27 -47 V\n-23 -46 V\n-19 -43
        V\n-17 -42 V\n-14 -40 V\n-13 -39 V\n-10 -37 V\n-9 -36 V\n-7 -35 V\n-7
        -33 V\n-6 -33 V\n-5 -31 V\n-4 -30 V\n-4 -29 V\n-4 -28 V\n-4 -27 V\n-4
        -27 V\n-3 -25 V\n-4 -24 V\n-5 -24 V\n-4 -22 V\n-5 -22 V\n-5 -21 V\n-6
        -20 V\n-6 -19 V\n-8 -18 V\n-8 -17 V\n-9 -16 V\n-10 -15 V\n-11 -13
        V\n-13 -13 V\n-14 -10 V\n-16 -9 V\n-18 -6 V\n-20 -4 V\n-23 -1 V\n-26
        3 V\n-28 7 V\n-32 13 V\n-36 20 V\n-39 28 V\n-43 37 V\n-48 49 V\n-51
        63 V\n-55 78 V\n-58 95 V\n-60 112 V\n-60 130 V\n-58 145 V\n-54 157
        V\n-47 162 V\n-35 159 V\n-22 145 V\n-6 123 V\n12 92 V\n29 58 V\n46 23
        V\n59 -10 V\n70 -35 V\n76 -55 V\n80 -68 V\n80 -73 V\n78 -76 V\n74 -75
        V\n68 -72 V\n62 -67 V\n56 -64 V\n50 -59 V\n44 -55 V\n38 -52 V\n34 -48
        V\n29 -45 V\n26 -43 V\n22 -40 V\n20 -38 V\n17 -36 V\n16 -34 V\n15 -33
        V\n14 -30 V\n13 -28 V\n13 -27 V\n13 -25 V\n14 -22 V\n14 -21 V\n15 -18
        V\n16 -15 V\n17 -13 V\n18 -10 V\n20 -6 V\n22 -3 V\n23 2 V\n25 6 V\n27
        12 V\n30 18 V\n30 24 V\n33 32 V\n34 39 V\n35 47 V\n36 55 V\n36 63
        V\n35 71 V\n33 76 V\n31 80 V\n26 82 V\n20 81 V\n14 76 V\n7 68 V\n-1
        58 V\n-9 45 V\n-17 30 V\n-25 16 V\n-32 2 V\n-36 -11 V\n-41 -22 V\n-43
        -31 V\n-44 -37 V\n-44 -42 V\n-43 -45 V\n-41 -47 V\n-38 -47 V\n-36 -48
        V\n-32 -46 V\n-29 -46 V\n-26 -45 V\n-22 -43 V\n-19 -42 V\n-16 -40
        V\n-14 -39 V\n-11 -38 V\n-8 -37 V\n-7 -35 V\n-4 -33 V\n-2 -33 V\n-1
        -31 V\n1 -29 V\n2 -29 V\n4 -26 V\n5 -26 V\n7 -23 V\n8 -22 V\n10 -20
        V\n12 -18 V\n13 -16 V\n14 -14 V\n17 -11 V\n19 -8 V\n20 -4 V\n23 0
        V\n25 4 V\n28 10 V\n30 16 V\n32 22 V\n35 30 V\n38 39 V\n39 48 V\n41
        58 V\n42 69 V\n42 78 V\n40 87 V\n39 95 V\n35 99 V\n29 101 V\n23 98
        V\n14 90 V\n4 79 V\n-6 63 V\n-16 45 V\n-26 26 V\n-34 8 V\n-42 -9
        V\n-47 -24 V\n-51 -35 V\n-53 -43 V\n-53 -49 V\n-52 -53 V\n-49 -54
        V\n-47 -54 V\n-43 -53 V\n-39 -53 V\n-34 -50 V\n-31 -49 V\n-27 -48
        V\n-24 -45 V\n-20 -44 V\n-17 -42 V\n-14 -41 V\n-12 -39 V\n-10 -38
        V\n-8 -37 V\n-6 -35 V\n-4 -34 V\n-3 -33 V\n-2 -32 V\n-1 -30 V\n0 -30
        V\n1 -28 V\n2 -28 V\n3 -26 V\n4 -25 V\n4 -24 V\n6 -23 V\n6 -22 V\n8
        -21 V\n8 -20 V\n10 -18 V\n10 -17 V\n12 -15 V\n14 -14 V\n16 -11 V\n17
        -9 V\n19 -7 V\n22 -3 V\n24 0 V\n27 4 V\n29 10 V\n33 16 V\n37 23 V\n39
        32 V\n44 43 V\n46 53 V\n50 67 V\n52 81 V\n54 97 V\n54 111 V\n53 124
        V\n49 135 V\n43 140 V\n35 139 V\n23 131 V\n11 115 V\n-5 93 V\n-19 64
        V\n-34 35 V\n-47 7 V\n-57 -18 V\n-64 -38 V\n-69 -52 V\n-72 -62 V\n-70
        -67 V\n-68 -68 V\n-64 -67 V\n-59 -66 V\n-54 -63 V\n-49 -59 V\n-43 -56
        V\n-38 -53 V\n-33 -50 V\n-29 -48 V\n-25 -45 V\n-22 -43 V\n-18 -41
        V\n-17 -39 V\n-15 -38 V\n-12 -36 V\n-12 -34 V\n-11 -33 V\n-10 -31
        V\n-10 -30 V\n-10 -29 V\n-10 -27 V\n-10 -25 V\n-11 -24 V\n-11 -22
        V\n-12 -21 V\n-13 -19 V\n-15 -16 V\n-16 -14 V\n-17 -12 V\n-19 -9
        V\n-21 -5 V\n-23 -2 V\n-25 3 V\n-28 8 V\n-31 14 V\n-32 20 V\n-36 29
        V\n-38 37 V\n-41 46 V\n-42 57 V\n-44 68 V\n-45 79 V\n-44 90 V\n-42 99
        V\n-39 106 V\n-35 108 V\n-27 108 V\n-18 101 V\n-9 90 V\n2 75 V\n14 55
        V\n25 34 V\n34 13 V\n43 -6 V\n49 -22 V\n54 -35 V\n57 -45 V\n56 -52
        V\n56 -55 V\n54 -57 V\n50 -57 V\n46 -56 V\n43 -55 V\n38 -53 V\n33 -50
        V\n30 -49 V\n25 -47 V\n23 -45 V\n19 -44 V\n16 -41 V\n13 -41 V\n12 -38
        V\n9 -38 V\n8 -36 V\n6 -35 V\n5 -33 V\n4 -33 V\n3 -31 V\n2 -31 V\n1
        -29 V\n1 -28 V\n0 -28 V\n0 -26 V\n0 -26 V\n-1 -25 V\n-2 -24 V\n-2 -23
        V\n-2 -22 V\n-2 -21 V\n-3 -21 V\n-4 -20 V\n-4 -19 V\n-5 -19 V\n-5 -17
        V\n-6 -17 V\n-7 -16 V\n-7 -15 V\n-9 -14 V\n-9 -14 V\n-11 -12 V\n-13
        -10 V\n-14 -10 V\n-15 -7 V\n-18 -6 V\n-20 -3 V\n-23 0 V\n-25 4 V\n-29
        8 V\n-32 13 V\n-36 20 V\n-40 28 V\n-44 38 V\ncurrentpoint stroke
        M\n-49 50 V\n-53 64 V\n1.000 UP\nstroke\ngrestore\nend\nshowpage\n>|ps>||||||>

        \;
      </output>

      <\input|octave\<gtr\> >
        plot(y(:,2),y(:,3))
      </input>

      <\output>
        \;

        \;

        <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
        /tmp/tmplot.eps\n%%Creator: gnuplot 3.8h patchlevel
        0\n%%CreationDate: Sun Apr \ 6 18:03:12 2003\n%%DocumentFonts:
        (atend)\n%%BoundingBox: 50 50 230 176\n%%Orientation:
        Portrait\n%%EndComments\n/gnudict 256 dict def\ngnudict begin\n/Color
        true def\n/Solid false def\n/gnulinewidth 5.000 def\n/userlinewidth
        gnulinewidth def\n/vshift -46 def\n/dl {10.0 mul} def\n/hpt_ 31.5
        def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_ def\n/M {moveto} bind
        def\n/L {lineto} bind def\n/R {rmoveto} bind def\n/V {rlineto} bind
        def\n/N {newpath moveto} bind def\n/f {rlineto fill} bind def\n/vpt2
        vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow { currentpoint stroke M\n
        \ 0 vshift R show } def\n/Rshow { currentpoint stroke M\n \ dup
        stringwidth pop neg vshift R show } def\n/Cshow { currentpoint stroke
        M\n \ dup stringwidth pop -2 div vshift R show } def\n/UP { dup vpt_
        mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2 hpt 2 mul def
        /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid {pop []} if
        0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash} ifelse }
        def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL {
        stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
        mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul
        /udl exch def } def\n/PL { stroke userlinewidth setlinewidth }
        def\n/LTb { BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0
        setdash 0 0 0 setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 {
        PL [4 dl 2 dl] 0 1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL }
        def\n/LT3 { PL [1 dl 1.5 dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1
        dl 2 dl] 0 1 1 DL } def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL }
        def\n/LT6 { PL [2 dl 2 dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl
        2 dl 2 dl 2 dl 2 dl 4 dl] 1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl
        2 dl 2 dl 2 dl 2 dl 4 dl] 0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0
        setdash\n \ \ gsave 1 setlinecap M 0 0 V stroke grestore } def\n/Dia
        { stroke [] 0 setdash 2 copy vpt add M\n \ hpt neg vpt neg V hpt vpt
        neg V\n \ hpt vpt V hpt neg vpt V closepath stroke\n \ Pnt }
        def\n/Pls { stroke [] 0 setdash vpt sub M 0 vpt2 V\n \ currentpoint
        stroke M\n \ hpt neg vpt neg R hpt2 0 V stroke\n \ } def\n/Box {
        stroke [] 0 setdash 2 copy exch hpt sub exch vpt add M\n \ 0 vpt2 neg
        V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke\n \ Pnt }
        def\n/Crs { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ hpt2
        vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0 R hpt2 vpt2 V stroke
        } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12 mul add M\n \ hpt
        neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V
        closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs } def\n/BoxF
        { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2 neg V
        \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill } def\n/TriUF
        { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul
        V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill }
        def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
        neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
        closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt
        1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt
        neg vpt -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash
        vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg
        vpt V closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy
        gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n
        \ closepath stroke grestore Pnt } def\n/PentF { stroke [] 0 setdash
        gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n
        \ closepath fill grestore } def\n/Circle { stroke [] 0 setdash 2
        copy\n \ hpt 0 360 arc stroke Pnt } def\n/CircleF { stroke [] 0
        setdash hpt 0 360 arc fill } def\n/C0 { BL [] 0 setdash 2 copy moveto
        vpt 90 450 \ arc } bind def\n/C1 { BL [] 0 setdash 2 copy
        \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc closepath
        fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
        def\n/C2 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        90 180 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
        closepath } bind def\n/C3 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ \ 2 copy \ vpt 0 180 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C4 {
        BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 180 270 arc
        closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
        } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
        \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360
        arc } bind def\n/C6 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
        copy \ vpt 90 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt
        0 360 arc closepath } bind def\n/C7 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ 2 copy \ vpt 0 270 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C8 {
        BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt 270 360 arc
        closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
        bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy
        \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
        360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
        moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
        \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11
        { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
        closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360
        arc closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13
        { BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
        closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360
        arc closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
        setdash 2 copy vpt 0 360 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
        \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
        \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
        bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
        def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
        bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
        def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
        Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch
        vpt2 vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy
        exch vpt sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 {
        BL [] 0 setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt
        sub exch vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0
        setdash 2 copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare }
        bind def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt
        vpt2 Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n
        \ \ \ \ \ \ Bsquare } bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub
        vpt Square fill Bsquare } bind def\n/S9 { BL [] 0 setdash 2 copy vpt
        sub vpt vpt2 Rec fill Bsquare } bind def\n/S10 { BL [] 0 setdash 2
        copy vpt sub vpt Square fill 2 copy exch vpt sub exch vpt Square
        fill\n \ \ \ \ \ \ Bsquare } bind def\n/S11 { BL [] 0 setdash 2 copy
        vpt sub vpt Square fill 2 copy exch vpt sub exch vpt2 vpt Rec fill\n
        \ \ \ \ \ \ Bsquare } bind def\n/S12 { BL [] 0 setdash 2 copy exch
        vpt sub exch vpt sub vpt2 vpt Rec fill Bsquare } bind def\n/S13 { BL
        [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt Rec fill\n
        \ \ \ \ \ \ 2 copy vpt Square fill Bsquare } bind def\n/S14 { BL [] 0
        setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt Rec fill\n
        \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square fill Bsquare } bind
        def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill Bsquare } bind
        def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke grestore } bind
        def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke grestore } bind
        def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke grestore } bind
        def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke grestore } bind
        def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke grestore } bind
        def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke grestore } bind
        def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke grestore } bind
        def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke grestore } bind
        def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke grestore } bind
        def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke grestore } bind
        def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke grestore } bind
        def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke grestore } bind
        def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke grestore } bind
        def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke grestore } bind
        def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke grestore } bind
        def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke grestore } bind
        def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg vpt neg V hpt
        vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke } def\n/BoxE {
        stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2 neg V hpt2
        0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE { stroke
        [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2
        mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke } def\n/TriDE {
        stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
        \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath stroke }
        def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72
        rotate 0 hpt L} repeat\n \ closepath stroke grestore } def\n/CircE {
        stroke [] 0 setdash \n \ hpt 0 360 arc stroke } def\n/Opaque { gsave
        closepath 1 setgray fill grestore 0 setgray closepath } def\n/DiaW {
        stroke [] 0 setdash vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n
        \ hpt vpt V hpt neg vpt V Opaque stroke } def\n/BoxW { stroke [] 0
        setdash exch hpt sub exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2
        V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW { stroke [] 0 setdash
        vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n
        \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW { stroke [] 0
        setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0
        V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW { stroke []
        0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n
        \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash \n \ hpt
        0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray fill
        grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
        makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
        ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0
        get findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ]
        exch dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch
        4 get {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n
        \ \ \ \ {dup 3 get {2 get neg 0 exch R pop} {pop aload pop M} ifelse}
        {dup 5\n \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get
        stringwidth pop -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop
        -2 div 0 R 6 get\n \ \ \ \ show 2 index {aload pop M neg 3 -1 roll
        neg R pop pop} {pop pop pop\n \ \ \ \ pop aload pop M} ifelse }ifelse
        }ifelse } forall} bind def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get
        findfont exch 1 get scalefont\n \ \ \ \ setfont 6 get stringwidth pop
        add} {pop} ifelse} forall} bind def\n/MLshow { currentpoint stroke
        M\n \ 0 exch R MFshow } bind def\n/MRshow { currentpoint stroke M\n
        \ exch dup MFwidth neg 3 -1 roll R MFshow } def\n/MCshow {
        currentpoint stroke M\n \ exch dup MFwidth -2 div 3 -1 roll R MFshow
        } def\nend\n%%EndProlog\ngnudict begin\ngsave\n50 50 translate\n0.050
        0.050 scale\n0 setgray\nnewpath\n(Helvetica) findfont 140 scalefont
        setfont\n1.000 UL\nLTb\n490 280 M\n63 0 V\n2809 0 R\n-63 0 V\n
        stroke\n406 280 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 5)]\n]
        -46.7 MRshow\n490 539 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 539
        M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 10)]\n] -46.7 MRshow\n490
        798 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 798 M\n[ [(Helvetica)
        140.0 0.0 true true 0 ( 15)]\n] -46.7 MRshow\n490 1057 M\n63 0
        V\n2809 0 R\n-63 0 V\n stroke\n406 1057 M\n[ [(Helvetica) 140.0 0.0
        true true 0 ( 20)]\n] -46.7 MRshow\n490 1316 M\n63 0 V\n2809 0 R\n-63
        0 V\n stroke\n406 1316 M\n[ [(Helvetica) 140.0 0.0 true true 0 (
        25)]\n] -46.7 MRshow\n490 1575 M\n63 0 V\n2809 0 R\n-63 0 V\n
        stroke\n406 1575 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 30)]\n]
        -46.7 MRshow\n490 1834 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406
        1834 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 35)]\n] -46.7
        MRshow\n490 2093 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 2093 M\n[
        [(Helvetica) 140.0 0.0 true true 0 ( 40)]\n] -46.7 MRshow\n490 2352
        M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 2352 M\n[ [(Helvetica)
        140.0 0.0 true true 0 ( 45)]\n] -46.7 MRshow\n490 280 M\n0 63 V\n0
        2009 R\n0 -63 V\n stroke\n490 140 M\n[ [(Helvetica) 140.0 0.0 true
        true 0 (-15)]\n] -46.7 MCshow\n969 280 M\n0 63 V\n0 2009 R\n0 -63 V\n
        stroke\n969 140 M\n[ [(Helvetica) 140.0 0.0 true true 0 (-10)]\n]
        -46.7 MCshow\n1447 280 M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n1447
        140 M\n[ [(Helvetica) 140.0 0.0 true true 0 (-5)]\n] -46.7
        MCshow\n1926 280 M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n1926 140 M\n[
        [(Helvetica) 140.0 0.0 true true 0 ( 0)]\n] -46.7 MCshow\n2405 280
        M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n2405 140 M\n[ [(Helvetica)
        140.0 0.0 true true 0 ( 5)]\n] -46.7 MCshow\n2883 280 M\n0 63 V\n0
        2009 R\n0 -63 V\n stroke\n2883 140 M\n[ [(Helvetica) 140.0 0.0 true
        true 0 ( 10)]\n] -46.7 MCshow\n3362 280 M\n0 63 V\n0 2009 R\n0 -63
        V\n stroke\n3362 140 M\n[ [(Helvetica) 140.0 0.0 true true 0 (
        15)]\n] -46.7 MCshow\n1.000 UL\nLTb\n490 280 M\n2872 0 V\n0 2072
        V\n-2872 0 V\n490 280 L\n1.000 UP\n1.000 UL\nLT0\n2711 2219 M\n[
        [(Helvetica) 140.0 0.0 true true 0 (line 1)]\n] -46.7 MRshow\n2795
        2219 M\n399 0 V\n2405 539 M\n41 2 V\n48 8 V\n55 14 V\n62 22 V\n69 30
        V\n73 41 V\n77 54 V\n79 67 V\n77 83 V\n71 100 V\n61 117 V\n44 134
        V\n20 147 V\n-8 155 V\n-42 157 V\n-77 149 V\n-110 133 V\n-137 107
        V\n-155 76 V\n-162 42 V\n-159 9 V\n-145 -20 V\n-127 -43 V\n-105 -59
        V\n-83 -68 V\n-61 -73 V\n-44 -75 V\n-30 -72 V\n-18 -69 V\n-10 -66
        V\n-4 -61 V\n0 -57 V\n2 -54 V\n3 -50 V\n3 -48 V\n3 -44 V\n2 -42 V\n0
        -40 V\n-1 -38 V\n-3 -36 V\n-4 -34 V\n-7 -32 V\n-8 -30 V\n-10 -29
        V\n-13 -27 V\n-15 -25 V\n-17 -23 V\n-19 -21 V\n-22 -19 V\n-24 -16
        V\n-27 -14 V\n-30 -10 V\n-32 -8 V\n-36 -4 V\n-38 0 V\n-41 5 V\n-43 11
        V\n-46 16 V\n-47 22 V\n-48 30 V\n-48 38 V\n-46 46 V\n-43 54 V\n-37 64
        V\n-30 71 V\n-20 79 V\n-7 83 V\n7 87 V\n22 86 V\n39 83 V\n53 76 V\n67
        66 V\n77 52 V\n84 37 V\n86 21 V\n85 6 V\n79 -9 V\n73 -20 V\n63 -31
        V\n53 -37 V\n44 -44 V\n34 -46 V\n25 -49 V\n18 -49 V\n13 -49 V\n7 -48
        V\n2 -48 V\n0 -46 V\n-3 -45 V\n-4 -43 V\n-6 -42 V\n-7 -40 V\n-8 -39
        V\n-9 -38 V\n-9 -36 V\n-10 -35 V\n-11 -33 V\n-11 -33 V\n-11 -31
        V\n-13 -29 V\n-13 -29 V\n-15 -27 V\n-16 -25 V\n-17 -24 V\n-19 -23
        V\n-20 -21 V\n-23 -19 V\n-25 -17 V\n-27 -15 V\n-30 -13 V\n-33 -10
        V\n-36 -7 V\n-40 -3 V\n-43 1 V\n-46 6 V\n-50 11 V\n-54 18 V\n-55 25
        V\n-58 33 V\n-59 42 V\n-58 53 V\n-55 63 V\n-50 75 V\n-41 85 V\n-29 96
        V\n-14 104 V\n5 108 V\n25 110 V\n47 105 V\n68 96 V\n86 82 V\n100 65
        V\n108 43 V\n110 23 V\n107 2 V\n98 -16 V\n87 -30 V\n74 -42 V\n61 -49
        V\n47 -54 V\n36 -57 V\n25 -57 V\n17 -57 V\n11 -56 V\n5 -53 V\n1 -52
        V\n-1 -50 V\n-3 -48 V\n-5 -46 V\n-5 -44 V\n-5 -43 V\n-6 -40 V\n-5 -40
        V\n-5 -38 V\n-5 -36 V\n-4 -36 V\n-5 -34 V\n-4 -33 V\n-3 -32 V\n-4 -31
        V\n-3 -30 V\n-3 -28 V\n-4 -28 V\n-3 -27 V\n-3 -26 V\n-4 -25 V\n-3 -25
        V\n-4 -23 V\n-5 -23 V\n-4 -22 V\n-6 -21 V\n-5 -21 V\n-7 -19 V\n-7 -19
        V\n-8 -18 V\n-9 -18 V\n-11 -17 V\n-11 -16 V\n-13 -15 V\n-15 -14
        V\n-17 -14 V\n-19 -12 V\n-21 -12 V\n-24 -10 V\n-27 -9 V\n-31 -7
        V\n-35 -5 V\n-39 -3 V\n-44 0 V\n-50 4 V\n-55 8 V\n-61 13 V\n-68 20
        V\n-74 28 V\n-80 38 V\n-86 49 V\n-89 64 V\n-90 80 V\n-87 99 V\n713
        945 L\n-65 138 V\n-43 157 V\n-14 171 V\n23 178 V\n64 176 V\n106 163
        V\n142 139 V\n169 104 V\n185 64 V\n185 25 V\n173 -12 V\n152 -41
        V\n127 -62 V\n100 -75 V\n75 -81 V\n53 -82 V\n35 -79 V\n21 -75 V\n12
        -70 V\n4 -65 V\n0 -59 V\n-2 -55 V\n-4 -51 V\n-3 -47 V\n-3 -44 V\n-1
        -40 V\n0 -39 V\n2 -35 V\n4 -34 V\n6 -31 V\n8 -29 V\n11 -27 V\n13 -25
        V\n15 -23 V\n18 -20 V\n20 -18 V\n22 -15 V\n25 -12 V\n27 -9 V\n29 -6
        V\n32 -2 V\n33 2 V\n35 7 V\n37 12 V\n38 17 V\n38 23 V\n37 29 V\n36 35
        V\n33 42 V\n28 48 V\n24 54 V\n16 59 V\n7 63 V\n-3 65 V\n-13 66 V\n-24
        64 V\n-36 59 V\n-45 54 V\n-53 44 V\n-60 35 V\n-63 24 V\n-64 13 V\n-63
        2 V\n-59 -8 V\n-54 -16 V\n-47 -24 V\n-41 -30 V\n-34 -34 V\n-27 -38
        V\n-21 -39 V\n-16 -41 V\n-10 -41 V\n-6 -41 V\n-3 -40 V\n1 -40 V\n3
        -39 V\n5 -38 V\n7 -37 V\n9 -36 V\n10 -34 V\n11 -33 V\n13 -31 V\n13
        -30 V\n15 -29 V\n16 -27 V\n18 -25 V\n19 -24 V\n21 -22 V\n22 -19 V\n24
        -18 V\n26 -15 V\n29 -12 V\n30 -9 V\n33 -6 V\n35 -3 V\n37 2 V\n40 6
        V\n41 12 V\n42 17 V\n44 24 V\n43 30 V\n42 37 V\n40 45 V\n35 53 V\n30
        59 V\n23 66 V\n12 72 V\n1 75 V\n-11 76 V\n-25 75 V\n-38 71 V\n-50 64
        V\n-61 54 V\n-69 42 V\n-74 29 V\n-75 16 V\n-73 3 V\n-69 -9 V\n-62 -19
        V\n-55 -27 V\n-47 -34 V\n-38 -39 V\n-30 -43 V\n-23 -44 V\n-16 -45
        V\n-11 -45 V\n-7 -45 V\n-2 -44 V\n0 -43 V\n3 -42 V\n5 -41 V\n7 -39
        V\n8 -39 V\n9 -36 V\n10 -36 V\n12 -34 V\n12 -33 V\n13 -31 V\n13 -30
        V\n16 -28 V\n16 -27 V\n17 -26 V\n20 -23 V\n20 -22 V\n23 -20 V\n25 -18
        V\n27 -15 V\n29 -13 V\n32 -10 V\n34 -7 V\n38 -3 V\n40 1 V\n43 6 V\n46
        11 V\n47 17 V\n50 24 V\n50 32 V\n50 40 V\n49 48 V\n45 58 V\n39 67
        V\n31 75 V\n20 83 V\n7 88 V\n-8 92 V\n-25 91 V\n-42 86 V\n-59 79
        V\n-72 68 V\n-83 52 V\n-89 37 V\n-91 19 V\n-88 4 V\n-83 -12 V\n-74
        -23 V\n-65 -34 V\n-53 -41 V\n-43 -46 V\n-34 -49 V\n-25 -50 V\n-17 -51
        V\n-11 -51 V\n-6 -49 V\n-2 -49 V\n1 -46 V\n3 -46 V\n4 -44 V\n6 -42
        V\n7 -41 V\n8 -39 V\n8 -38 V\n9 -37 V\n9 -35 V\n9 -34 V\n10 -33 V\n10
        -31 V\n11 -31 V\ncurrentpoint stroke M\n12 -29 V\n13 -27 V\n13 -27
        V\n15 -25 V\n16 -24 V\n18 -22 V\n20 -21 V\n21 -19 V\n24 -18 V\n26 -15
        V\n29 -14 V\n32 -10 V\n36 -8 V\n39 -5 V\n42 -1 V\n46 4 V\n51 9 V\n54
        15 V\n57 22 V\n60 30 V\n63 39 V\n62 49 V\n62 61 V\n57 73 V\n50 85
        V\n40 97 V\n24 108 V\n7 114 V\n-16 119 V\n-39 117 V\n-63 109 V\n-84
        97 V\n-103 79 V\n-114 57 V\n-120 33 V\n-118 11 V\n-110 -11 V\n-99 -27
        V\n-85 -41 V\n-69 -51 V\n-55 -57 V\n-42 -59 V\n-30 -61 V\n-20 -60
        V\n-13 -58 V\n-6 -56 V\n-3 -54 V\n1 -52 V\n2 -50 V\n4 -47 V\n5 -46
        V\n4 -43 V\n5 -42 V\n4 -40 V\n4 -39 V\n3 -37 V\n2 -36 V\n2 -35 V\n1
        -33 V\n0 -33 V\n0 -31 V\n-2 -30 V\n-1 -29 V\n-3 -28 V\n-3 -27 V\n-4
        -27 V\n-4 -25 V\n-6 -24 V\n-6 -24 V\n-7 -22 V\n-8 -22 V\n-9 -21
        V\n-11 -20 V\n-12 -19 V\n-13 -18 V\n-15 -17 V\n-18 -16 V\n-19 -15
        V\n-22 -13 V\n-24 -13 V\n-28 -10 V\n-31 -9 V\n-35 -6 V\n-39 -4 V\n-43
        -1 V\n-49 3 V\n-54 7 V\n-60 13 V\n-65 20 V\n-71 28 V\n-76 37 V\n-80
        49 V\n-82 63 V\n-82 78 V\n-78 95 V\n-69 112 V\n-55 130 V\n-34 145
        V\n-6 157 V\n27 162 V\n63 159 V\n98 145 V\n131 123 V\n153 92 V\n166
        58 V\n166 23 V\n157 -10 V\n138 -35 V\n117 -55 V\n93 -68 V\n71 -73
        V\n52 -76 V\n35 -75 V\n22 -72 V\n13 -67 V\n6 -64 V\n1 -59 V\n-2 -55
        V\n-3 -52 V\n-3 -48 V\n-3 -45 V\n-2 -43 V\n-1 -40 V\n1 -38 V\n3 -36
        V\n4 -34 V\n6 -33 V\n9 -30 V\n10 -28 V\n13 -27 V\n15 -25 V\n17 -22
        V\n20 -21 V\n22 -18 V\n24 -15 V\n27 -13 V\n30 -10 V\n33 -6 V\n35 -3
        V\n38 2 V\n40 6 V\n43 12 V\n44 18 V\n46 24 V\n45 32 V\n45 39 V\n43 47
        V\n38 55 V\n33 63 V\n24 71 V\n14 76 V\n2 80 V\n-12 82 V\n-27 81
        V\n-41 76 V\n-55 68 V\n-66 58 V\n-75 45 V\n-80 30 V\n-81 16 V\n-78 2
        V\n-74 -11 V\n-66 -22 V\n-57 -31 V\n-48 -37 V\n-40 -42 V\n-30 -45
        V\n-23 -47 V\n-16 -47 V\n-11 -48 V\n-6 -46 V\n-2 -46 V\n1 -45 V\n4
        -43 V\n5 -42 V\n6 -40 V\n8 -39 V\n9 -38 V\n9 -37 V\n11 -35 V\n11 -33
        V\n11 -33 V\n13 -31 V\n14 -29 V\n14 -29 V\n16 -26 V\n17 -26 V\n19 -23
        V\n20 -22 V\n22 -20 V\n24 -18 V\n27 -16 V\n29 -14 V\n32 -11 V\n34 -8
        V\n38 -4 V\n41 0 V\n44 4 V\n47 10 V\n50 16 V\n52 22 V\n54 30 V\n55 39
        V\n54 48 V\n51 58 V\n46 69 V\n39 78 V\n28 87 V\n15 95 V\n-2 99 V\n-20
        101 V\n-40 98 V\n-58 90 V\n-76 79 V\n-88 63 V\n-97 45 V\n-101 26
        V\n-99 8 V\n-93 -9 V\n-84 -24 V\n-72 -35 V\n-61 -43 V\n-48 -49 V\n-38
        -53 V\n-27 -54 V\n-20 -54 V\n-12 -53 V\n-7 -53 V\n-3 -50 V\n0 -49
        V\n3 -48 V\n4 -45 V\n6 -44 V\n6 -42 V\n6 -41 V\n7 -39 V\n7 -38 V\n7
        -37 V\n7 -35 V\n7 -34 V\n7 -33 V\n7 -32 V\n8 -30 V\n8 -30 V\n8 -28
        V\n9 -28 V\n9 -26 V\n11 -25 V\n11 -24 V\n13 -23 V\n14 -22 V\n15 -21
        V\n17 -20 V\n20 -18 V\n21 -17 V\n24 -15 V\n26 -14 V\n30 -11 V\n32 -9
        V\n37 -7 V\n41 -3 V\n45 0 V\n49 4 V\n55 10 V\n59 16 V\n63 23 V\n68 32
        V\n71 43 V\n73 53 V\n72 67 V\n69 81 V\n62 97 V\n50 111 V\n34 124
        V\n12 135 V\n-15 140 V\n-44 139 V\n-75 131 V\n-102 115 V\n-124 93
        V\n-139 64 V\n-144 35 V\n-141 7 V\n-129 -18 V\n-113 -38 V\n-94 -52
        V\n-76 -62 V\n-57 -67 V\n-42 -68 V\n-29 -67 V\n-18 -66 V\n-10 -63
        V\n-5 -59 V\n-1 -56 V\n2 -53 V\n3 -50 V\n3 -48 V\n4 -45 V\n3 -43 V\n2
        -41 V\n0 -39 V\n0 -38 V\n-2 -36 V\n-3 -34 V\n-5 -33 V\n-6 -31 V\n-8
        -30 V\n-10 -29 V\n-12 -27 V\n-13 -25 V\n-15 -24 V\n-18 -22 V\n-19 -21
        V\n-22 -19 V\n-25 -16 V\n-28 -14 V\n-30 -12 V\n-34 -9 V\n-37 -5
        V\n-40 -2 V\n-45 3 V\n-47 8 V\n-51 14 V\n-54 20 V\n-57 29 V\n-58 37
        V\n-58 46 V\n-57 57 V\n-52 68 V\n-46 79 V\n-36 90 V\n-22 99 V\n-6 106
        V\n13 108 V\n35 108 V\n56 101 V\n76 90 V\n92 75 V\n103 55 V\n109 34
        V\n109 13 V\n103 -6 V\n93 -22 V\n81 -35 V\n68 -45 V\n54 -52 V\n42 -55
        V\n31 -57 V\n22 -57 V\n14 -56 V\n8 -55 V\n3 -53 V\n0 -50 V\n-2 -49
        V\n-4 -47 V\n-4 -45 V\n-6 -44 V\n-5 -41 V\n-6 -41 V\n-5 -38 V\n-5 -38
        V\n-5 -36 V\n-5 -35 V\n-4 -33 V\n-4 -33 V\n-4 -31 V\n-4 -31 V\n-4 -29
        V\n-3 -28 V\n-4 -28 V\n-4 -26 V\n-4 -26 V\n-4 -25 V\n-5 -24 V\n-5 -23
        V\n-5 -22 V\n-6 -21 V\n-7 -21 V\n-7 -20 V\n-9 -19 V\n-9 -19 V\n-10
        -17 V\n-12 -17 V\n-13 -16 V\n-15 -15 V\n-17 -14 V\n-19 -14 V\n-22 -12
        V\n-24 -10 V\n-28 -10 V\n-31 -7 V\n-35 -6 V\n-39 -3 V\n-44 0 V\n-50 4
        V\n-55 8 V\n-61 13 V\n-67 20 V\n-74 28 V\n-79 38 V\ncurrentpoint
        stroke M\n-84 50 V\n-87 64 V\n1.000
        UP\nstroke\ngrestore\nend\nshowpage\n>|ps>||||||>

        \;
      </output>

      <\input|octave\<gtr\> >
        plot(y(:,1),y(:,2))
      </input>

      <\output>
        \;

        \;

        <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
        /tmp/tmplot.eps\n%%Creator: gnuplot 3.8h patchlevel
        0\n%%CreationDate: Sun Apr \ 6 18:03:14 2003\n%%DocumentFonts:
        (atend)\n%%BoundingBox: 50 50 230 176\n%%Orientation:
        Portrait\n%%EndComments\n/gnudict 256 dict def\ngnudict begin\n/Color
        true def\n/Solid false def\n/gnulinewidth 5.000 def\n/userlinewidth
        gnulinewidth def\n/vshift -46 def\n/dl {10.0 mul} def\n/hpt_ 31.5
        def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_ def\n/M {moveto} bind
        def\n/L {lineto} bind def\n/R {rmoveto} bind def\n/V {rlineto} bind
        def\n/N {newpath moveto} bind def\n/f {rlineto fill} bind def\n/vpt2
        vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow { currentpoint stroke M\n
        \ 0 vshift R show } def\n/Rshow { currentpoint stroke M\n \ dup
        stringwidth pop neg vshift R show } def\n/Cshow { currentpoint stroke
        M\n \ dup stringwidth pop -2 div vshift R show } def\n/UP { dup vpt_
        mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2 hpt 2 mul def
        /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid {pop []} if
        0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash} ifelse }
        def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL {
        stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
        mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul
        /udl exch def } def\n/PL { stroke userlinewidth setlinewidth }
        def\n/LTb { BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0
        setdash 0 0 0 setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 {
        PL [4 dl 2 dl] 0 1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL }
        def\n/LT3 { PL [1 dl 1.5 dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1
        dl 2 dl] 0 1 1 DL } def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL }
        def\n/LT6 { PL [2 dl 2 dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl
        2 dl 2 dl 2 dl 2 dl 4 dl] 1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl
        2 dl 2 dl 2 dl 2 dl 4 dl] 0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0
        setdash\n \ \ gsave 1 setlinecap M 0 0 V stroke grestore } def\n/Dia
        { stroke [] 0 setdash 2 copy vpt add M\n \ hpt neg vpt neg V hpt vpt
        neg V\n \ hpt vpt V hpt neg vpt V closepath stroke\n \ Pnt }
        def\n/Pls { stroke [] 0 setdash vpt sub M 0 vpt2 V\n \ currentpoint
        stroke M\n \ hpt neg vpt neg R hpt2 0 V stroke\n \ } def\n/Box {
        stroke [] 0 setdash 2 copy exch hpt sub exch vpt add M\n \ 0 vpt2 neg
        V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke\n \ Pnt }
        def\n/Crs { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ hpt2
        vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0 R hpt2 vpt2 V stroke
        } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12 mul add M\n \ hpt
        neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V
        closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs } def\n/BoxF
        { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2 neg V
        \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill } def\n/TriUF
        { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul
        V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill }
        def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
        neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
        closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt
        1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt
        neg vpt -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash
        vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg
        vpt V closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy
        gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n
        \ closepath stroke grestore Pnt } def\n/PentF { stroke [] 0 setdash
        gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n
        \ closepath fill grestore } def\n/Circle { stroke [] 0 setdash 2
        copy\n \ hpt 0 360 arc stroke Pnt } def\n/CircleF { stroke [] 0
        setdash hpt 0 360 arc fill } def\n/C0 { BL [] 0 setdash 2 copy moveto
        vpt 90 450 \ arc } bind def\n/C1 { BL [] 0 setdash 2 copy
        \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc closepath
        fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
        def\n/C2 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        90 180 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
        closepath } bind def\n/C3 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ \ 2 copy \ vpt 0 180 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C4 {
        BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 180 270 arc
        closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
        } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
        \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360
        arc } bind def\n/C6 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
        copy \ vpt 90 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt
        0 360 arc closepath } bind def\n/C7 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ 2 copy \ vpt 0 270 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C8 {
        BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt 270 360 arc
        closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
        bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy
        \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
        360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
        moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
        \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11
        { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
        closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360
        arc closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13
        { BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
        closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
        180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360
        arc closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
        \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
        setdash 2 copy vpt 0 360 arc closepath fill\n
        \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
        \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
        \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
        bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
        def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
        bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
        def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
        Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch
        vpt2 vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy
        exch vpt sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 {
        BL [] 0 setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt
        sub exch vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0
        setdash 2 copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare }
        bind def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt
        vpt2 Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n
        \ \ \ \ \ \ Bsquare } bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub
        vpt Square fill Bsquare } bind def\n/S9 { BL [] 0 setdash 2 copy vpt
        sub vpt vpt2 Rec fill Bsquare } bind def\n/S10 { BL [] 0 setdash 2
        copy vpt sub vpt Square fill 2 copy exch vpt sub exch vpt Square
        fill\n \ \ \ \ \ \ Bsquare } bind def\n/S11 { BL [] 0 setdash 2 copy
        vpt sub vpt Square fill 2 copy exch vpt sub exch vpt2 vpt Rec fill\n
        \ \ \ \ \ \ Bsquare } bind def\n/S12 { BL [] 0 setdash 2 copy exch
        vpt sub exch vpt sub vpt2 vpt Rec fill Bsquare } bind def\n/S13 { BL
        [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt Rec fill\n
        \ \ \ \ \ \ 2 copy vpt Square fill Bsquare } bind def\n/S14 { BL [] 0
        setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt Rec fill\n
        \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square fill Bsquare } bind
        def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill Bsquare } bind
        def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke grestore } bind
        def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke grestore } bind
        def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke grestore } bind
        def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke grestore } bind
        def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke grestore } bind
        def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke grestore } bind
        def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke grestore } bind
        def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke grestore } bind
        def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke grestore } bind
        def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke grestore } bind
        def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke grestore } bind
        def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke grestore } bind
        def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke grestore } bind
        def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke grestore } bind
        def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke grestore } bind
        def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke grestore } bind
        def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg vpt neg V hpt
        vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke } def\n/BoxE {
        stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2 neg V hpt2
        0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE { stroke
        [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2
        mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke } def\n/TriDE {
        stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
        \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath stroke }
        def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72
        rotate 0 hpt L} repeat\n \ closepath stroke grestore } def\n/CircE {
        stroke [] 0 setdash \n \ hpt 0 360 arc stroke } def\n/Opaque { gsave
        closepath 1 setgray fill grestore 0 setgray closepath } def\n/DiaW {
        stroke [] 0 setdash vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n
        \ hpt vpt V hpt neg vpt V Opaque stroke } def\n/BoxW { stroke [] 0
        setdash exch hpt sub exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2
        V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW { stroke [] 0 setdash
        vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n
        \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW { stroke [] 0
        setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0
        V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW { stroke []
        0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n
        \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash \n \ hpt
        0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray fill
        grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
        makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
        ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0
        get findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ]
        exch dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch
        4 get {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n
        \ \ \ \ {dup 3 get {2 get neg 0 exch R pop} {pop aload pop M} ifelse}
        {dup 5\n \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get
        stringwidth pop -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop
        -2 div 0 R 6 get\n \ \ \ \ show 2 index {aload pop M neg 3 -1 roll
        neg R pop pop} {pop pop pop\n \ \ \ \ pop aload pop M} ifelse }ifelse
        }ifelse } forall} bind def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get
        findfont exch 1 get scalefont\n \ \ \ \ setfont 6 get stringwidth pop
        add} {pop} ifelse} forall} bind def\n/MLshow { currentpoint stroke
        M\n \ 0 exch R MFshow } bind def\n/MRshow { currentpoint stroke M\n
        \ exch dup MFwidth neg 3 -1 roll R MFshow } def\n/MCshow {
        currentpoint stroke M\n \ exch dup MFwidth -2 div 3 -1 roll R MFshow
        } def\nend\n%%EndProlog\ngnudict begin\ngsave\n50 50 translate\n0.050
        0.050 scale\n0 setgray\nnewpath\n(Helvetica) findfont 140 scalefont
        setfont\n1.000 UL\nLTb\n490 280 M\n63 0 V\n2809 0 R\n-63 0 V\n
        stroke\n406 280 M\n[ [(Helvetica) 140.0 0.0 true true 0 (-15)]\n]
        -46.7 MRshow\n490 625 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 625
        M\n[ [(Helvetica) 140.0 0.0 true true 0 (-10)]\n] -46.7 MRshow\n490
        971 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 971 M\n[ [(Helvetica)
        140.0 0.0 true true 0 (-5)]\n] -46.7 MRshow\n490 1316 M\n63 0 V\n2809
        0 R\n-63 0 V\n stroke\n406 1316 M\n[ [(Helvetica) 140.0 0.0 true true
        0 ( 0)]\n] -46.7 MRshow\n490 1661 M\n63 0 V\n2809 0 R\n-63 0 V\n
        stroke\n406 1661 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 5)]\n]
        -46.7 MRshow\n490 2007 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406
        2007 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 10)]\n] -46.7
        MRshow\n490 2352 M\n63 0 V\n2809 0 R\n-63 0 V\n stroke\n406 2352 M\n[
        [(Helvetica) 140.0 0.0 true true 0 ( 15)]\n] -46.7 MRshow\n490 280
        M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n490 140 M\n[ [(Helvetica)
        140.0 0.0 true true 0 (-15)]\n] -46.7 MCshow\n969 280 M\n0 63 V\n0
        2009 R\n0 -63 V\n stroke\n969 140 M\n[ [(Helvetica) 140.0 0.0 true
        true 0 (-10)]\n] -46.7 MCshow\n1447 280 M\n0 63 V\n0 2009 R\n0 -63
        V\n stroke\n1447 140 M\n[ [(Helvetica) 140.0 0.0 true true 0 (-5)]\n]
        -46.7 MCshow\n1926 280 M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n1926
        140 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 0)]\n] -46.7
        MCshow\n2405 280 M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n2405 140 M\n[
        [(Helvetica) 140.0 0.0 true true 0 ( 5)]\n] -46.7 MCshow\n2883 280
        M\n0 63 V\n0 2009 R\n0 -63 V\n stroke\n2883 140 M\n[ [(Helvetica)
        140.0 0.0 true true 0 ( 10)]\n] -46.7 MCshow\n3362 280 M\n0 63 V\n0
        2009 R\n0 -63 V\n stroke\n3362 140 M\n[ [(Helvetica) 140.0 0.0 true
        true 0 ( 15)]\n] -46.7 MCshow\n1.000 UL\nLTb\n490 280 M\n2872 0 V\n0
        2072 V\n-2872 0 V\n490 280 L\n1.000 UP\n1.000 UL\nLT0\n2711 2219 M\n[
        [(Helvetica) 140.0 0.0 true true 0 (line 1)]\n] -46.7 MRshow\n2795
        2219 M\n399 0 V\n2117 1661 M\n37 30 V\n37 35 V\n39 40 V\n41 44 V\n44
        50 V\n47 53 V\n51 55 V\n54 57 V\n56 56 V\n59 51 V\n60 44 V\n59 31
        V\n55 15 V\n50 -6 V\n41 -30 V\n30 -55 V\n14 -80 V\n-1 -98 V\n-19 -112
        V\n-35 -118 V\n-51 -114 V\n-62 -105 V\n-71 -92 V\n-76 -75 V\n-78 -60
        V\n-78 -44 V\n-74 -32 V\n-70 -21 V\n-65 -14 V\n-58 -7 V\n-53 -3
        V\n-46 0 V\n-41 2 V\n-36 2 V\n-31 2 V\n-28 2 V\n-23 2 V\n-21 0 V\n-18
        -1 V\n-17 -2 V\n-15 -3 V\n-14 -5 V\n-13 -6 V\n-12 -7 V\n-13 -9 V\n-12
        -11 V\n-14 -12 V\n-13 -14 V\n-15 -16 V\n-15 -17 V\n-17 -20 V\n-18 -21
        V\n-19 -24 V\n-22 -25 V\n-23 -28 V\n-25 -29 V\n-27 -31 V\n-29 -33
        V\n-31 -34 V\n-33 -35 V\n-35 -35 V\n-36 -33 V\n-38 -31 V\n-37 -27
        V\n-37 -21 V\n-36 -15 V\n-33 -5 V\n-29 5 V\n-24 16 V\n-18 28 V\n-10
        39 V\n-2 48 V\n7 56 V\n15 60 V\n24 62 V\n31 61 V\n37 58 V\n42 52
        V\n45 45 V\n46 39 V\n47 31 V\n46 25 V\n43 18 V\n41 13 V\n38 9 V\n35 5
        V\n31 2 V\n28 0 V\n24 -2 V\n21 -3 V\n18 -5 V\n15 -5 V\n12 -6 V\n10 -6
        V\n8 -7 V\n5 -7 V\n4 -7 V\n2 -8 V\n1 -9 V\n-1 -9 V\n-3 -9 V\n-3 -11
        V\n-5 -11 V\n-7 -13 V\n-8 -13 V\n-9 -15 V\n-11 -16 V\n-12 -18 V\n-14
        -20 V\n-15 -22 V\n-18 -24 V\n-19 -26 V\n-22 -28 V\n-24 -31 V\n-26 -34
        V\n-29 -36 V\n-32 -38 V\n-34 -41 V\n-37 -41 V\n-40 -43 V\n-42 -41
        V\n-43 -40 V\n-45 -36 V\n-44 -30 V\n-44 -21 V\n-41 -10 V\n-37 4
        V\n-30 18 V\n-23 34 V\n-13 49 V\n-3 62 V\n9 72 V\n20 78 V\n30 79
        V\n40 77 V\n47 71 V\n53 63 V\n56 54 V\n57 43 V\n57 34 V\n54 26 V\n52
        18 V\n49 13 V\n44 7 V\n40 4 V\n36 1 V\n31 -1 V\n28 -2 V\n23 -3 V\n21
        -4 V\n17 -4 V\n15 -4 V\n12 -4 V\n10 -4 V\n9 -3 V\n7 -3 V\n5 -3 V\n5
        -3 V\n3 -3 V\n3 -2 V\n2 -3 V\n1 -2 V\n1 -2 V\n0 -3 V\n0 -2 V\n0 -3
        V\n-1 -2 V\n-1 -3 V\n-2 -3 V\n-2 -4 V\n-2 -4 V\n-3 -4 V\n-3 -4 V\n-3
        -6 V\n-4 -5 V\n-5 -7 V\n-5 -7 V\n-6 -9 V\n-6 -9 V\n-8 -11 V\n-8 -12
        V\n-10 -14 V\n-11 -15 V\n-12 -17 V\n-14 -20 V\n-15 -22 V\n-18 -25
        V\n-20 -29 V\n-22 -31 V\n-25 -36 V\n-29 -40 V\n-32 -44 V\n-36 -49
        V\n-40 -54 V\n-44 -58 V\n-49 -61 V\n-53 -64 V\n-58 -65 V\n-61 -63
        V\n-64 -57 V\n-65 -47 V\n-64 -31 V\n-60 -10 V\n-52 17 V\n-41 46
        V\n-26 76 V\n-8 102 V\n11 123 V\n31 133 V\n49 133 V\n65 125 V\n76 110
        V\n84 92 V\n87 72 V\n87 54 V\n84 38 V\n79 25 V\n74 16 V\n66 8 V\n60 3
        V\n53 0 V\n46 -2 V\n41 -2 V\n35 -3 V\n31 -2 V\n27 -1 V\n24 0 V\n21 2
        V\n19 3 V\n18 4 V\n16 6 V\n15 8 V\n15 9 V\n15 11 V\n15 13 V\n16 14
        V\n16 16 V\n17 18 V\n18 20 V\n19 21 V\n21 23 V\n22 24 V\n23 25 V\n25
        27 V\n26 27 V\n28 27 V\n29 27 V\n30 26 V\n30 24 V\n31 20 V\n29 17
        V\n29 12 V\n27 5 V\n24 -2 V\n20 -9 V\n15 -18 V\n10 -25 V\n5 -33 V\n-2
        -39 V\n-9 -43 V\n-15 -45 V\n-20 -46 V\n-26 -45 V\n-30 -43 V\n-33 -39
        V\n-35 -34 V\n-36 -30 V\n-36 -25 V\n-36 -19 V\n-34 -15 V\n-32 -11
        V\n-30 -8 V\n-28 -4 V\n-24 -2 V\n-22 0 V\n-20 3 V\n-16 3 V\n-14 5
        V\n-11 7 V\n-9 7 V\n-6 8 V\n-4 9 V\n-3 10 V\n0 11 V\n2 11 V\n3 13
        V\n5 14 V\n7 15 V\n9 16 V\n10 17 V\n12 19 V\n14 21 V\n15 22 V\n18 23
        V\n20 26 V\n21 26 V\n23 29 V\n26 29 V\n27 31 V\n29 31 V\n31 32 V\n33
        30 V\n33 29 V\n34 25 V\n33 22 V\n33 16 V\n31 9 V\n28 1 V\n25 -8 V\n19
        -18 V\n13 -28 V\n7 -36 V\n-1 -44 V\n-9 -50 V\n-15 -53 V\n-23 -54
        V\n-29 -53 V\n-34 -49 V\n-37 -45 V\n-40 -40 V\n-42 -33 V\n-41 -28
        V\n-41 -22 V\n-39 -16 V\n-36 -12 V\n-34 -8 V\n-31 -5 V\n-28 -2 V\n-24
        1 V\n-22 2 V\n-18 4 V\n-16 5 V\n-13 5 V\n-10 7 V\n-8 7 V\n-6 8 V\n-4
        9 V\n-2 9 V\n0 10 V\n2 11 V\n3 12 V\n5 13 V\n6 13 V\n8 15 V\n10 17
        V\n11 18 V\n14 19 V\n14 21 V\n17 23 V\n19 25 V\n20 27 V\n23 29 V\n25
        31 V\n27 33 V\n30 34 V\n32 36 V\n34 37 V\n36 36 V\n37 35 V\n39 32
        V\n39 28 V\n38 23 V\n37 14 V\n35 5 V\n30 -6 V\n24 -18 V\n18 -30 V\n10
        -42 V\n1 -52 V\n-9 -60 V\n-17 -64 V\n-26 -66 V\n-34 -64 V\n-40 -60
        V\n-44 -53 V\n-47 -46 V\n-49 -39 V\n-49 -31 V\n-47 -24 V\n-45 -18
        V\n-42 -13 V\n-39 -8 V\n-36 -4 V\n-32 -2 V\n-28 1 V\n-24 2 V\n-21 4
        V\n-18 4 V\n-15 5 V\n-13 5 V\n-10 6 V\n-8 6 V\n-6 7 V\n-4 7 V\n-3 7
        V\n-1 7 V\n1 8 V\ncurrentpoint stroke M\n1 9 V\n3 9 V\n4 10 V\n5 10
        V\n7 12 V\n7 13 V\n9 14 V\n11 15 V\n12 18 V\n13 19 V\n15 21 V\n17 23
        V\n19 25 V\n21 28 V\n23 31 V\n26 33 V\n28 37 V\n32 39 V\n34 41 V\n37
        43 V\n40 45 V\n42 46 V\n45 44 V\n47 41 V\n47 36 V\n47 29 V\n46 18
        V\n42 4 V\n36 -11 V\n29 -28 V\n20 -45 V\n8 -62 V\n-3 -73 V\n-16 -83
        V\n-28 -86 V\n-39 -85 V\n-48 -80 V\n-54 -71 V\n-59 -62 V\n-61 -50
        V\n-61 -39 V\n-59 -30 V\n-57 -22 V\n-53 -14 V\n-48 -9 V\n-44 -5
        V\n-40 -2 V\n-35 0 V\n-30 2 V\n-27 3 V\n-23 3 V\n-19 4 V\n-17 3
        V\n-14 3 V\n-13 2 V\n-10 3 V\n-9 1 V\n-7 1 V\n-7 1 V\n-6 0 V\n-5 0
        V\n-4 -1 V\n-4 -1 V\n-4 -2 V\n-4 -2 V\n-4 -3 V\n-3 -3 V\n-4 -4 V\n-5
        -4 V\n-4 -6 V\n-5 -5 V\n-5 -7 V\n-6 -8 V\n-6 -8 V\n-8 -10 V\n-8 -11
        V\n-9 -12 V\n-10 -14 V\n-11 -16 V\n-13 -18 V\n-14 -20 V\n-16 -22
        V\n-18 -25 V\n-20 -28 V\n-23 -32 V\n-26 -35 V\n-28 -39 V\n-32 -43
        V\n-36 -47 V\n-39 -51 V\n-43 -55 V\n-48 -58 V\n-51 -59 V\n-55 -59
        V\n-58 -56 V\n-60 -50 V\n-60 -40 V\n-58 -24 V\n-54 -5 V\n-47 20
        V\n-35 45 V\n-22 71 V\n-6 94 V\n12 111 V\n29 120 V\n46 120 V\n59 112
        V\n70 101 V\n76 84 V\n80 67 V\n80 51 V\n78 37 V\n74 26 V\n68 16 V\n62
        9 V\n56 4 V\n50 1 V\n44 -1 V\n38 -2 V\n34 -3 V\n29 -2 V\n26 -1 V\n22
        -1 V\n20 1 V\n17 1 V\n16 4 V\n15 4 V\n14 6 V\n13 8 V\n13 9 V\n13 11
        V\n14 12 V\n14 14 V\n15 16 V\n16 18 V\n17 20 V\n18 21 V\n20 24 V\n22
        25 V\n23 27 V\n25 29 V\n27 31 V\n30 32 V\n30 33 V\n33 33 V\n34 32
        V\n35 31 V\n36 28 V\n36 23 V\n35 18 V\n33 10 V\n31 1 V\n26 -9 V\n20
        -19 V\n14 -30 V\n7 -39 V\n-1 -48 V\n-9 -54 V\n-17 -58 V\n-25 -58
        V\n-32 -57 V\n-36 -52 V\n-41 -48 V\n-43 -42 V\n-44 -34 V\n-44 -29
        V\n-43 -22 V\n-41 -16 V\n-38 -12 V\n-36 -8 V\n-32 -4 V\n-29 -1 V\n-26
        0 V\n-22 3 V\n-19 4 V\n-16 4 V\n-14 6 V\n-11 6 V\n-8 7 V\n-7 8 V\n-4
        8 V\n-2 8 V\n-1 9 V\n1 10 V\n2 10 V\n4 12 V\n5 12 V\n7 13 V\n8 15
        V\n10 16 V\n12 18 V\n13 19 V\n14 21 V\n17 23 V\n19 25 V\n20 27 V\n23
        29 V\n25 32 V\n28 34 V\n30 36 V\n32 38 V\n35 39 V\n38 39 V\n39 39
        V\n41 37 V\n42 33 V\n42 28 V\n40 21 V\n39 10 V\n35 -1 V\n29 -15 V\n23
        -28 V\n14 -42 V\n4 -55 V\n-6 -64 V\n-16 -70 V\n-26 -72 V\n-34 -72
        V\n-42 -67 V\n-47 -60 V\n-51 -53 V\n-53 -43 V\n-53 -35 V\n-52 -27
        V\n-49 -20 V\n-47 -14 V\n-43 -9 V\n-39 -5 V\n-34 -2 V\n-31 0 V\n-27 2
        V\n-24 3 V\n-20 4 V\n-17 4 V\n-14 5 V\n-12 5 V\n-10 5 V\n-8 5 V\n-6 5
        V\n-4 5 V\n-3 5 V\n-2 5 V\n-1 6 V\n0 5 V\n1 6 V\n2 7 V\n3 7 V\n4 7
        V\n4 9 V\n6 9 V\n6 10 V\n8 11 V\n8 12 V\n10 14 V\n10 15 V\n12 17
        V\n14 20 V\n16 21 V\n17 24 V\n19 26 V\n22 29 V\n24 33 V\n27 35 V\n29
        40 V\n33 42 V\n37 46 V\n39 49 V\n44 51 V\n46 53 V\n50 52 V\n52 50
        V\n54 44 V\n54 37 V\n53 24 V\n49 8 V\n43 -10 V\n35 -32 V\n23 -54
        V\n11 -74 V\n-5 -89 V\n-19 -100 V\n-34 -104 V\n-47 -102 V\n-57 -93
        V\n-64 -82 V\n-69 -68 V\n-72 -54 V\n-70 -41 V\n-68 -31 V\n-64 -20
        V\n-59 -13 V\n-54 -8 V\n-49 -3 V\n-43 -1 V\n-38 1 V\n-33 2 V\n-29 3
        V\n-25 2 V\n-22 3 V\n-18 1 V\n-17 1 V\n-15 -1 V\n-12 -1 V\n-12 -2
        V\n-11 -4 V\n-10 -5 V\n-10 -5 V\n-10 -7 V\n-10 -9 V\n-10 -9 V\n-11
        -11 V\n-11 -13 V\n-12 -14 V\n-13 -16 V\n-15 -18 V\n-16 -20 V\n-17 -22
        V\n-19 -24 V\n-21 -27 V\n-23 -29 V\n-25 -32 V\n-28 -34 V\n-31 -37
        V\n-32 -39 V\n-36 -41 V\n-38 -42 V\n-41 -42 V\n-42 -40 V\n-44 -38
        V\n-45 -33 V\n-44 -26 V\n-42 -17 V\n-39 -4 V\n-35 10 V\n-27 25 V\n-18
        41 V\n-9 54 V\n2 67 V\n14 74 V\n25 79 V\n34 78 V\n43 74 V\n49 68
        V\n54 58 V\n57 49 V\n56 39 V\n56 31 V\n54 22 V\n50 15 V\n46 11 V\n43
        5 V\n38 3 V\n33 0 V\n30 -2 V\n25 -2 V\n23 -4 V\n19 -4 V\n16 -4 V\n13
        -4 V\n12 -4 V\n9 -3 V\n8 -4 V\n6 -3 V\n5 -3 V\n4 -3 V\n3 -3 V\n2 -3
        V\n1 -2 V\n1 -3 V\n0 -3 V\n0 -2 V\n0 -3 V\n-1 -3 V\n-2 -4 V\n-2 -3
        V\n-2 -4 V\n-2 -5 V\n-3 -4 V\n-4 -6 V\n-4 -6 V\n-5 -7 V\n-5 -7 V\n-6
        -9 V\n-7 -9 V\n-7 -11 V\n-9 -12 V\n-9 -14 V\n-11 -16 V\n-13 -17
        V\n-14 -20 V\n-15 -22 V\n-18 -26 V\n-20 -28 V\n-23 -32 V\n-25 -35
        V\n-29 -40 V\n-32 -44 V\n-36 -49 V\n-40 -53 V\n-44 -57
        V\ncurrentpoint stroke M\n-49 -61 V\n-53 -62 V\n1.000
        UP\nstroke\ngrestore\nend\nshowpage\n>|ps>||||||>

        \;
      </output>

      <\input|octave\<gtr\> >
        gset set term postscript enhanced color eps;
      </input>

      <\input|octave\<gtr\> >
        gset out "/home/cchuang/texmacs/butterfly.eps";
      </input>

      <\input|octave\<gtr\> >
        gset xtics 10;gset ytics 10; gset ztics 10;
      </input>

      <\input|octave\<gtr\> >
        gsplot y title "Butterfly Effect"
      </input>

      <\input|octave\<gtr\> >
        \;
      </input>
    </session>

    At the last part of Octave code, we want to save the 3D trajectory as
    butterfly.eps. Then we can embed this EPS file:

    <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
    /home/cchuang/texmacs/butterfly.eps\n%%Creator: gnuplot 3.8h patchlevel
    0\n%%CreationDate: Sun Apr \ 6 18:17:44 2003\n%%DocumentFonts:
    (atend)\n%%BoundingBox: 50 50 230 176\n%%Orientation:
    Portrait\n%%EndComments\n/gnudict 256 dict def\ngnudict begin\n/Color
    true def\n/Solid false def\n/gnulinewidth 5.000 def\n/userlinewidth
    gnulinewidth def\n/vshift -46 def\n/dl {10.0 mul} def\n/hpt_ 31.5
    def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_ def\n/M {moveto} bind
    def\n/L {lineto} bind def\n/R {rmoveto} bind def\n/V {rlineto} bind
    def\n/N {newpath moveto} bind def\n/f {rlineto fill} bind def\n/vpt2 vpt
    2 mul def\n/hpt2 hpt 2 mul def\n/Lshow { currentpoint stroke M\n \ 0
    vshift R show } def\n/Rshow { currentpoint stroke M\n \ dup stringwidth
    pop neg vshift R show } def\n/Cshow { currentpoint stroke M\n \ dup
    stringwidth pop -2 div vshift R show } def\n/UP { dup vpt_ mul /vpt exch
    def hpt_ mul /hpt exch def\n \ /hpt2 hpt 2 mul def /vpt2 vpt 2 mul def }
    def\n/DL { Color {setrgbcolor Solid {pop []} if 0 setdash }\n {pop pop
    pop Solid {pop []} if 0 setdash} ifelse } def\n/BL { stroke userlinewidth
    2 mul setlinewidth } def\n/AL { stroke userlinewidth 2 div setlinewidth }
    def\n/UL { dup gnulinewidth mul /userlinewidth exch def\n \ \ \ \ \ dup 1
    lt {pop 1} if 10 mul /udl exch def } def\n/PL { stroke userlinewidth
    setlinewidth } def\n/LTb { BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2
    udl mul] 0 setdash 0 0 0 setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL }
    def\n/LT1 { PL [4 dl 2 dl] 0 1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL
    } def\n/LT3 { PL [1 dl 1.5 dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1 dl
    2 dl] 0 1 1 DL } def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL }
    def\n/LT6 { PL [2 dl 2 dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl 2 dl
    2 dl 2 dl 2 dl 4 dl] 1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl 2 dl 2
    dl 2 dl 2 dl 4 dl] 0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0 setdash\n
    \ \ gsave 1 setlinecap M 0 0 V stroke grestore } def\n/Dia { stroke [] 0
    setdash 2 copy vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt
    V hpt neg vpt V closepath stroke\n \ Pnt } def\n/Pls { stroke [] 0
    setdash vpt sub M 0 vpt2 V\n \ currentpoint stroke M\n \ hpt neg vpt neg
    R hpt2 0 V stroke\n \ } def\n/Box { stroke [] 0 setdash 2 copy exch hpt
    sub exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
    closepath stroke\n \ Pnt } def\n/Crs { stroke [] 0 setdash exch hpt sub
    exch vpt add M\n \ hpt2 vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0 R
    hpt2 vpt2 V stroke } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12 mul
    add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62
    mul V closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs }
    def\n/BoxF { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
    neg V \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill }
    def\n/TriUF { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt
    -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill }
    def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt neg
    vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath
    stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt 1.12 mul sub M\n
    \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
    closepath fill} def\n/DiaF { stroke [] 0 setdash vpt add M\n \ hpt neg
    vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V closepath fill }
    def\n/Pent { stroke [] 0 setdash 2 copy gsave\n \ translate 0 hpt M 4 {72
    rotate 0 hpt L} repeat\n \ closepath stroke grestore Pnt } def\n/PentF {
    stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
    repeat\n \ closepath fill grestore } def\n/Circle { stroke [] 0 setdash 2
    copy\n \ hpt 0 360 arc stroke Pnt } def\n/CircleF { stroke [] 0 setdash
    hpt 0 360 arc fill } def\n/C0 { BL [] 0 setdash 2 copy moveto vpt 90 450
    \ arc } bind def\n/C1 { BL [] 0 setdash 2 copy \ \ \ \ \ \ \ moveto\n
    \ \ \ \ \ \ 2 copy \ vpt 0 90 arc closepath fill\n
    \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C2 { BL
    [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 90 180 arc
    closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
    bind def\n/C3 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
    0 180 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
    closepath } bind def\n/C4 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2
    copy \ vpt 180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
    360 arc closepath } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n
    \ \ \ \ \ \ 2 copy \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n
    \ \ \ \ \ \ 2 copy \ vpt 180 270 arc closepath fill\n
    \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C6 { BL [] 0
    setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 90 270 arc closepath
    fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C7
    { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 0 270 arc
    closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
    def\n/C8 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt 270 360
    arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
    bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt
    270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
    closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy moveto vpt 270
    360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy
    vpt 90 180 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
    closepath } bind def\n/C11 { BL [] 0 setdash 2 copy moveto\n
    \ \ \ \ \ \ 2 copy \ vpt 0 180 arc closepath fill\n \ \ \ \ \ \ 2 copy
    moveto\n \ \ \ \ \ \ 2 copy \ vpt 270 360 arc closepath fill\n
    \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C12 { BL
    [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 180 360 arc
    closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
    bind def\n/C13 { BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy
    \ vpt 0 90 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2
    copy \ vpt 180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
    360 arc closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
    \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
    \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
    setdash 2 copy vpt 0 360 arc closepath fill\n
    \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
    \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
    \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec } bind
    def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind def\n/S0 {
    BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare } bind def\n/S1 {
    BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind def\n/S2 { BL [] 0
    setdash 2 copy exch vpt sub exch vpt Square fill Bsquare } bind def\n/S3
    { BL [] 0 setdash 2 copy exch vpt sub exch vpt2 vpt Rec fill Bsquare }
    bind def\n/S4 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt
    Square fill Bsquare } bind def\n/S5 { BL [] 0 setdash 2 copy 2 copy vpt
    Square fill\n \ \ \ \ \ \ exch vpt sub exch vpt sub vpt Square fill
    Bsquare } bind def\n/S6 { BL [] 0 setdash 2 copy exch vpt sub exch vpt
    sub vpt vpt2 Rec fill Bsquare } bind def\n/S7 { BL [] 0 setdash 2 copy
    exch vpt sub exch vpt sub vpt vpt2 Rec fill\n \ \ \ \ \ \ 2 copy vpt
    Square fill\n \ \ \ \ \ \ Bsquare } bind def\n/S8 { BL [] 0 setdash 2
    copy vpt sub vpt Square fill Bsquare } bind def\n/S9 { BL [] 0 setdash 2
    copy vpt sub vpt vpt2 Rec fill Bsquare } bind def\n/S10 { BL [] 0 setdash
    2 copy vpt sub vpt Square fill 2 copy exch vpt sub exch vpt Square fill\n
    \ \ \ \ \ \ Bsquare } bind def\n/S11 { BL [] 0 setdash 2 copy vpt sub vpt
    Square fill 2 copy exch vpt sub exch vpt2 vpt Rec fill\n
    \ \ \ \ \ \ Bsquare } bind def\n/S12 { BL [] 0 setdash 2 copy exch vpt
    sub exch vpt sub vpt2 vpt Rec fill Bsquare } bind def\n/S13 { BL [] 0
    setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt Rec fill\n
    \ \ \ \ \ \ 2 copy vpt Square fill Bsquare } bind def\n/S14 { BL [] 0
    setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt Rec fill\n
    \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square fill Bsquare } bind
    def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill Bsquare } bind def\n/D0 {
    gsave translate 45 rotate 0 0 S0 stroke grestore } bind def\n/D1 { gsave
    translate 45 rotate 0 0 S1 stroke grestore } bind def\n/D2 { gsave
    translate 45 rotate 0 0 S2 stroke grestore } bind def\n/D3 { gsave
    translate 45 rotate 0 0 S3 stroke grestore } bind def\n/D4 { gsave
    translate 45 rotate 0 0 S4 stroke grestore } bind def\n/D5 { gsave
    translate 45 rotate 0 0 S5 stroke grestore } bind def\n/D6 { gsave
    translate 45 rotate 0 0 S6 stroke grestore } bind def\n/D7 { gsave
    translate 45 rotate 0 0 S7 stroke grestore } bind def\n/D8 { gsave
    translate 45 rotate 0 0 S8 stroke grestore } bind def\n/D9 { gsave
    translate 45 rotate 0 0 S9 stroke grestore } bind def\n/D10 { gsave
    translate 45 rotate 0 0 S10 stroke grestore } bind def\n/D11 { gsave
    translate 45 rotate 0 0 S11 stroke grestore } bind def\n/D12 { gsave
    translate 45 rotate 0 0 S12 stroke grestore } bind def\n/D13 { gsave
    translate 45 rotate 0 0 S13 stroke grestore } bind def\n/D14 { gsave
    translate 45 rotate 0 0 S14 stroke grestore } bind def\n/D15 { gsave
    translate 45 rotate 0 0 S15 stroke grestore } bind def\n/DiaE { stroke []
    0 setdash vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt
    neg vpt V closepath stroke } def\n/BoxE { stroke [] 0 setdash exch hpt
    sub exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
    closepath stroke } def\n/TriUE { stroke [] 0 setdash vpt 1.12 mul add M\n
    \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V
    closepath stroke } def\n/TriDE { stroke [] 0 setdash vpt 1.12 mul sub M\n
    \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
    closepath stroke } def\n/PentE { stroke [] 0 setdash gsave\n \ translate
    0 hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath stroke grestore }
    def\n/CircE { stroke [] 0 setdash \n \ hpt 0 360 arc stroke }
    def\n/Opaque { gsave closepath 1 setgray fill grestore 0 setgray
    closepath } def\n/DiaW { stroke [] 0 setdash vpt add M\n \ hpt neg vpt
    neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V Opaque stroke }
    def\n/BoxW { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
    neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW {
    stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
    \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW {
    stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt
    2 mul 0 V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW {
    stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
    repeat\n \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash \n
    \ hpt 0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray fill
    grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
    makefont\ndup length dict begin {1 index /FID eq {pop pop} {def} ifelse}
    forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0 get findfont
    exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ] exch dup 2 get 0
    exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch 4 get {show}
    {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n \ \ \ \ {dup 3 get {2
    get neg 0 exch R pop} {pop aload pop M} ifelse} {dup 5\n \ \ \ \ get 1 eq
    {dup 2 get exch dup 3 get exch 6 get stringwidth pop -2 div\n \ \ \ \ dup
    0 R} {dup 6 get stringwidth pop -2 div 0 R 6 get\n \ \ \ \ show 2 index
    {aload pop M neg 3 -1 roll neg R pop pop} {pop pop pop\n \ \ \ \ pop
    aload pop M} ifelse }ifelse }ifelse } forall} bind def\n/MFwidth {0 exch
    {dup 3 get{dup dup 0 get findfont exch 1 get scalefont\n \ \ \ \ setfont
    6 get stringwidth pop add} {pop} ifelse} forall} bind def\n/MLshow {
    currentpoint stroke M\n \ 0 exch R MFshow } bind def\n/MRshow {
    currentpoint stroke M\n \ exch dup MFwidth neg 3 -1 roll R MFshow }
    def\n/MCshow { currentpoint stroke M\n \ exch dup MFwidth -2 div 3 -1
    roll R MFshow } def\nend\n%%EndProlog\ngnudict begin\ngsave\n50 50
    translate\n0.050 0.050 scale\n0 setgray\nnewpath\n(Helvetica) findfont
    140 scalefont setfont\n1.000 UL\nLTb\n1.000 UP\n1.000 UL\nLT0\n2802 2036
    M\n[ [(Helvetica) 140.0 0.0 true true 0 (Butterfly Effect)]\n] -46.7
    MRshow\n2886 2036 M\n399 0 V\n1989 1344 M\n24 3 V\n27 5 V\n29 8 V\n31 10
    V\n34 13 V\n36 16 V\n39 20 V\n40 22 V\n41 27 V\n40 29 V\n39 33 V\n34 34
    V\n27 35 V\n19 35 V\n6 30 V\n-6 26 V\n-19 18 V\n-33 9 V\n-44 1 V\n-52 -8
    V\n-58 -14 V\n-59 -19 V\n-59 -21 V\n-55 -22 V\n-51 -22 V\n-46 -21 V\n-41
    -18 V\n-35 -17 V\n-30 -15 V\n-26 -13 V\n-23 -12 V\n-19 -11 V\n-16 -10
    V\n-13 -10 V\n-12 -9 V\n-11 -8 V\n-9 -9 V\n-8 -8 V\n-8 -9 V\n-7 -8 V\n-7
    -8 V\n-7 -7 V\n-8 -8 V\n-7 -8 V\n-8 -7 V\n-9 -7 V\n-9 -7 V\n-10 -7 V\n-11
    -6 V\n-12 -6 V\n-13 -6 V\n-14 -5 V\n-16 -4 V\n-17 -4 V\n-18 -3 V\n-20 -3
    V\n-21 0 V\n-23 0 V\n-23 2 V\n-25 4 V\n-25 5 V\n-26 9 V\n-25 11 V\n-24 13
    V\n-22 17 V\n-19 20 V\n-15 22 V\n-10 25 V\n-5 26 V\n2 27 V\n8 26 V\n15 25
    V\n21 22 V\n26 19 V\n30 14 V\n32 10 V\n34 6 V\n34 1 V\n33 -3 V\n31 -6
    V\n29 -9 V\n27 -11 V\n23 -12 V\n21 -13 V\n18 -13 V\n16 -14 V\n14 -14
    V\n11 -13 V\n9 -13 V\n7 -13 V\n6 -13 V\n4 -12 V\n4 -11 V\n2 -12 V\n0 -10
    V\n0 -11 V\n0 -10 V\n-2 -9 V\n-3 -10 V\n-3 -8 V\n-4 -9 V\n-5 -8 V\n-6 -8
    V\n-7 -8 V\n-7 -8 V\n-9 -7 V\n-9 -7 V\n-11 -6 V\n-12 -6 V\n-13 -6 V\n-15
    -5 V\n-17 -5 V\n-18 -4 V\n-19 -4 V\n-22 -2 V\n-23 -2 V\n-26 0 V\n-27 2
    V\n-28 3 V\n-30 6 V\n-31 9 V\n-30 12 V\n-30 16 V\n-28 19 V\n-24 24 V\n-20
    27 V\n-14 30 V\n-6 33 V\n2 34 V\n10 33 V\n19 32 V\n27 28 V\n34 23 V\n38
    17 V\n41 11 V\n42 5 V\n42 0 V\n40 -5 V\n37 -9 V\n34 -12 V\n31 -13 V\n27
    -15 V\n23 -16 V\n21 -16 V\n17 -15 V\n15 -16 V\n12 -14 V\n11 -15 V\n8 -14
    V\n7 -13 V\n6 -12 V\n5 -12 V\n4 -12 V\n2 -10 V\n3 -11 V\n2 -10 V\n1 -9
    V\n1 -9 V\n0 -9 V\n1 -8 V\n0 -8 V\n-1 -8 V\n0 -7 V\n-1 -7 V\n-1 -7 V\n-1
    -7 V\n-1 -6 V\n-1 -7 V\n-2 -6 V\n-2 -6 V\n-2 -6 V\n-2 -5 V\n-3 -6 V\n-3
    -5 V\n-4 -5 V\n-4 -6 V\n-4 -5 V\n-5 -5 V\n-6 -5 V\n-7 -4 V\n-7 -5 V\n-8
    -5 V\n-10 -5 V\n-10 -5 V\n-12 -4 V\n-14 -5 V\n-15 -4 V\n-17 -4 V\n-20 -4
    V\n-21 -4 V\n-25 -3 V\n-27 -2 V\n-31 -1 V\n-33 1 V\n-37 2 V\n-40 5 V\n-42
    9 V\n-45 13 V\n-45 18 V\n-44 24 V\n-42 31 V\n-36 38 V\n-27 45 V\n-16 51
    V\n-2 55 V\n15 56 V\n29 53 V\n45 47 V\n55 37 V\n64 26 V\n66 14 V\n67 4
    V\n63 -6 V\n59 -12 V\n53 -17 V\n46 -20 V\n41 -21 V\n35 -22 V\n29 -21
    V\n26 -19 V\n21 -19 V\n18 -17 V\n16 -17 V\n14 -14 V\n11 -14 V\n11 -12
    V\n10 -11 V\n9 -11 V\n8 -9 V\n9 -8 V\n8 -7 V\n9 -7 V\n9 -6 V\n10 -4 V\n10
    -4 V\n11 -3 V\n12 -2 V\n12 -2 V\n14 0 V\n15 1 V\n16 2 V\n16 3 V\n18 5
    V\n19 5 V\n19 7 V\n20 9 V\n21 10 V\n20 11 V\n20 12 V\n19 14 V\n18 14
    V\n15 15 V\n13 14 V\n9 14 V\n5 14 V\n1 11 V\n-5 10 V\n-8 7 V\n-14 5
    V\n-17 2 V\n-21 -1 V\n-23 -4 V\n-25 -5 V\n-26 -8 V\n-26 -8 V\n-26 -10
    V\n-24 -9 V\n-23 -11 V\n-20 -10 V\n-19 -10 V\n-17 -9 V\n-15 -10 V\n-12 -9
    V\n-11 -8 V\n-8 -9 V\n-7 -8 V\n-6 -7 V\n-4 -8 V\n-2 -7 V\n-1 -6 V\n0 -6
    V\n1 -6 V\n2 -6 V\n3 -5 V\n5 -5 V\n5 -4 V\n7 -4 V\n7 -4 V\n9 -2 V\n10 -2
    V\n11 -2 V\n12 0 V\n14 0 V\n15 2 V\n16 2 V\n17 4 V\n19 5 V\n20 6 V\n21 7
    V\n22 10 V\n22 10 V\n23 13 V\n23 13 V\n22 16 V\n21 16 V\n18 17 V\n16 17
    V\n12 17 V\n7 15 V\n2 14 V\n-4 12 V\n-9 9 V\n-15 6 V\n-19 3 V\n-24 -1
    V\n-26 -4 V\n-29 -6 V\n-30 -9 V\n-30 -10 V\n-29 -11 V\n-28 -11 V\n-25 -12
    V\n-24 -11 V\n-21 -11 V\n-19 -11 V\n-16 -10 V\n-14 -10 V\n-12 -9 V\n-10
    -9 V\n-8 -8 V\n-6 -8 V\n-5 -8 V\n-3 -8 V\n-2 -7 V\n-1 -7 V\n0 -7 V\n1 -6
    V\n3 -6 V\n3 -6 V\n4 -5 V\n5 -5 V\n6 -4 V\n7 -4 V\n8 -4 V\n10 -3 V\n10 -2
    V\n12 -1 V\n13 -1 V\n14 1 V\n15 1 V\n18 2 V\n18 4 V\n20 5 V\n22 7 V\n23 8
    V\n25 10 V\n25 12 V\n27 13 V\n26 16 V\n26 17 V\n25 19 V\n23 20 V\n20 20
    V\n16 20 V\n10 20 V\n4 18 V\n-3 15 V\n-9 11 V\n-17 8 V\n-23 3 V\n-28 -1
    V\n-32 -4 V\n-34 -8 V\n-35 -11 V\n-36 -12 V\n-34 -13 V\n-32 -13 V\n-30
    -14 V\n-27 -13 V\n-24 -12 V\n-21 -12 V\n-19 -11 V\n-16 -11 V\n-13 -10
    V\n-11 -9 V\n-9 -9 V\n-8 -9 V\n-6 -8 V\n-4 -9 V\n-4 -8 V\n-2 -7 V\n-1 -8
    V\n0 -7 V\n0 -7 V\n1 -7 V\n2 -6 V\n3 -6 V\ncurrentpoint stroke M\n3 -6
    V\n5 -6 V\n4 -5 V\n6 -5 V\n6 -4 V\n8 -4 V\n8 -3 V\n9 -3 V\n11 -2 V\n11 -2
    V\n13 -1 V\n14 1 V\n16 1 V\n18 2 V\n19 3 V\n22 5 V\n23 7 V\n25 8 V\n28 10
    V\n29 13 V\n30 14 V\n32 18 V\n33 19 V\n32 22 V\n31 24 V\n29 26 V\n24 27
    V\n18 26 V\n11 25 V\n3 22 V\n-7 18 V\n-16 13 V\n-26 7 V\n-33 0 V\n-39 -4
    V\n-43 -10 V\n-46 -13 V\n-45 -15 V\n-44 -17 V\n-41 -17 V\n-37 -16 V\n-34
    -16 V\n-30 -15 V\n-26 -14 V\n-23 -12 V\n-19 -12 V\n-17 -11 V\n-14 -10
    V\n-11 -10 V\n-10 -9 V\n-9 -9 V\n-6 -9 V\n-6 -9 V\n-5 -8 V\n-4 -9 V\n-4
    -8 V\n-3 -8 V\n-2 -8 V\n-3 -7 V\n-2 -8 V\n-2 -7 V\n-2 -8 V\n-2 -7 V\n-2
    -7 V\n-3 -7 V\n-2 -7 V\n-3 -6 V\n-3 -7 V\n-3 -6 V\n-3 -6 V\n-4 -6 V\n-4
    -6 V\n-5 -6 V\n-6 -6 V\n-6 -6 V\n-7 -5 V\n-7 -6 V\n-9 -5 V\n-9 -5 V\n-11
    -6 V\n-13 -5 V\n-13 -5 V\n-16 -4 V\n-17 -5 V\n-20 -4 V\n-21 -3 V\n-25 -3
    V\n-27 -2 V\n-29 -1 V\n-33 1 V\n-35 3 V\n-38 5 V\n-40 9 V\n-42 13 V\n-41
    18 V\n-41 24 V\n-37 30 V\n-32 36 V\n-23 42 V\n-13 47 V\n1 51 V\n14 50
    V\n28 47 V\n41 42 V\n51 33 V\n57 23 V\n61 14 V\n60 3 V\n59 -4 V\n54 -11
    V\n49 -15 V\n44 -19 V\n38 -19 V\n33 -20 V\n28 -20 V\n24 -19 V\n20 -18
    V\n18 -18 V\n15 -16 V\n13 -14 V\n11 -14 V\n10 -13 V\n8 -12 V\n9 -11 V\n7
    -10 V\n8 -9 V\n7 -8 V\n8 -7 V\n8 -7 V\n8 -6 V\n9 -5 V\n9 -5 V\n11 -3
    V\n11 -3 V\n12 -2 V\n13 -1 V\n15 0 V\n16 1 V\n17 2 V\n18 4 V\n20 4 V\n20
    7 V\n23 8 V\n23 9 V\n24 12 V\n24 12 V\n24 15 V\n24 16 V\n22 17 V\n20 18
    V\n17 19 V\n12 18 V\n8 17 V\n2 15 V\n-4 13 V\n-10 9 V\n-16 6 V\n-21 3
    V\n-26 -2 V\n-29 -4 V\n-31 -7 V\n-32 -10 V\n-32 -10 V\n-31 -12 V\n-29 -12
    V\n-27 -13 V\n-24 -12 V\n-22 -11 V\n-20 -11 V\n-17 -11 V\n-14 -10 V\n-12
    -9 V\n-10 -9 V\n-9 -9 V\n-6 -8 V\n-5 -9 V\n-4 -7 V\n-2 -8 V\n-2 -7 V\n0
    -7 V\n1 -7 V\n2 -6 V\n2 -6 V\n4 -6 V\n4 -5 V\n6 -5 V\n6 -5 V\n7 -4 V\n8
    -3 V\n9 -3 V\n10 -3 V\n12 -1 V\n13 -1 V\n14 0 V\n16 1 V\n17 2 V\n19 4
    V\n20 5 V\n22 6 V\n24 8 V\n26 10 V\n27 12 V\n27 14 V\n29 16 V\n29 18
    V\n27 19 V\n26 22 V\n24 22 V\n19 23 V\n13 22 V\n7 20 V\n0 18 V\n-8 14
    V\n-15 10 V\n-24 5 V\n-29 0 V\n-34 -5 V\n-37 -8 V\n-39 -11 V\n-39 -13
    V\n-37 -14 V\n-36 -14 V\n-33 -15 V\n-30 -14 V\n-26 -13 V\n-23 -13 V\n-21
    -12 V\n-17 -11 V\n-15 -10 V\n-12 -10 V\n-11 -10 V\n-8 -9 V\n-7 -8 V\n-6
    -9 V\n-4 -8 V\n-3 -8 V\n-2 -8 V\n-2 -8 V\n-1 -7 V\n0 -8 V\n0 -7 V\n1 -7
    V\n2 -6 V\n2 -6 V\n2 -7 V\n3 -5 V\n3 -6 V\n4 -5 V\n5 -5 V\n5 -5 V\n6 -4
    V\n7 -4 V\n7 -3 V\n8 -3 V\n10 -2 V\n10 -2 V\n12 -1 V\n13 0 V\n15 1 V\n16
    1 V\n18 3 V\n21 4 V\n22 5 V\n25 7 V\n27 9 V\n30 12 V\n32 13 V\n34 17
    V\n36 19 V\n37 22 V\n37 25 V\n37 28 V\n33 30 V\n29 31 V\n23 32 V\n14 30
    V\n4 26 V\n-8 22 V\n-20 15 V\n-31 8 V\n-40 0 V\n-47 -7 V\n-52 -13 V\n-54
    -17 V\n-52 -19 V\n-50 -20 V\n-47 -19 V\n-42 -19 V\n-37 -18 V\n-33 -15
    V\n-28 -15 V\n-24 -13 V\n-21 -11 V\n-18 -11 V\n-15 -11 V\n-13 -9 V\n-11
    -10 V\n-9 -9 V\n-8 -8 V\n-7 -9 V\n-7 -9 V\n-6 -8 V\n-5 -8 V\n-6 -8 V\n-6
    -8 V\n-5 -8 V\n-6 -8 V\n-6 -7 V\n-7 -8 V\n-7 -7 V\n-8 -7 V\n-9 -7 V\n-9
    -7 V\n-11 -6 V\n-11 -7 V\n-13 -6 V\n-15 -5 V\n-15 -5 V\n-17 -5 V\n-19 -3
    V\n-21 -3 V\n-22 -2 V\n-24 -1 V\n-26 0 V\n-28 3 V\n-29 5 V\n-30 7 V\n-31
    10 V\n-30 14 V\n-29 17 V\n-26 21 V\n-22 25 V\n-18 28 V\n-10 31 V\n-3 34
    V\n5 33 V\n15 33 V\n22 30 V\n30 26 V\n35 20 V\n40 15 V\n41 8 V\n42 3
    V\n41 -3 V\n39 -6 V\n35 -11 V\n33 -12 V\n29 -14 V\n25 -15 V\n22 -16 V\n19
    -16 V\n17 -15 V\n13 -15 V\n12 -15 V\n9 -14 V\n8 -13 V\n7 -13 V\n5 -13
    V\n4 -11 V\n3 -11 V\n3 -11 V\n2 -10 V\n1 -10 V\n1 -9 V\n1 -9 V\n0 -9 V\n0
    -8 V\n0 -8 V\n-1 -7 V\n0 -8 V\n-1 -7 V\n-1 -7 V\n-2 -6 V\n-2 -7 V\n-1 -6
    V\n-3 -6 V\n-2 -6 V\n-3 -6 V\n-3 -5 V\n-4 -6 V\n-4 -5 V\n-4 -6 V\n-5 -5
    V\n-6 -5 V\n-7 -5 V\n-7 -5 V\n-9 -5 V\n-9 -5 V\n-11 -5 V\n-12 -5 V\n-14
    -5 V\n-15 -4 V\n-17 -4 V\n-20 -4 V\n-22 -4 V\n-24 -3 V\n-28 -2 V\n-30 -1
    V\n-33 1 V\n-37 3 V\ncurrentpoint stroke M\n-39 5 V\n-42 9 V\n1.000
    UL\nLTb\nLTb\n3024 949 M\n2128 465 L\n1.000 UL\nLTb\nLTb\n576 744 M\n2128
    465 L\n1.000 UL\nLTb\nLTb\n576 744 M\n896 484 V\n1.000 UL\nLTb\nLTb\n3024
    949 M\n1472 1228 L\n1.000 UL\nLTb\nLTb\n576 744 M\n0 967 V\n1.000
    UL\nLTb\nLTb\n576 744 M\n47 41 V\n1.000 UL\nLTb\n512 652 M\n[
    [(Helvetica) 140.0 0.0 true true 0 (-20)]\n] -46.7 MCshow\n1.000
    UL\nLTb\nLTb\n1472 1228 M\n-47 -41 V\n1.000 UL\nLTb\nLTb\n964 674 M\n48
    41 V\n1.000 UL\nLTb\n901 583 M\n[ [(Helvetica) 140.0 0.0 true true 0
    (-10)]\n] -46.7 MCshow\n1.000 UL\nLTb\nLTb\n1860 1158 M\n-48 -41 V\n1.000
    UL\nLTb\nLTb\n1352 604 M\n48 42 V\n1.000 UL\nLTb\n1289 513 M\n[
    [(Helvetica) 140.0 0.0 true true 0 ( 0)]\n] -46.7 MCshow\n1.000
    UL\nLTb\nLTb\n2248 1088 M\n-48 -41 V\n1.000 UL\nLTb\nLTb\n1740 534 M\n48
    42 V\n1.000 UL\nLTb\n1677 443 M\n[ [(Helvetica) 140.0 0.0 true true 0 (
    10)]\n] -46.7 MCshow\n1.000 UL\nLTb\nLTb\n2636 1019 M\n-48 -42 V\n1.000
    UL\nLTb\nLTb\n2128 465 M\n47 41 V\n1.000 UL\nLTb\n2064 373 M\n[
    [(Helvetica) 140.0 0.0 true true 0 ( 20)]\n] -46.7 MCshow\n1.000
    UL\nLTb\nLTb\n3024 949 M\n-47 -42 V\n1.000 UL\nLTb\nLTb\n2128 465 M\n-61
    17 V\n stroke\n2208 426 M\n[ [(Helvetica) 140.0 0.0 true true 0 (-20)]\n]
    -46.7 MLshow\n1.000 UL\nLTb\nLTb\n576 744 M\n60 -17 V\n1.000
    UL\nLTb\nLTb\n2352 586 M\n-61 17 V\n stroke\n2432 547 M\n[ [(Helvetica)
    140.0 0.0 true true 0 (-10)]\n] -46.7 MLshow\n1.000 UL\nLTb\nLTb\n800 865
    M\n61 -17 V\n1.000 UL\nLTb\nLTb\n2576 707 M\n-61 17 V\n stroke\n2657 668
    M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 0)]\n] -46.7 MLshow\n1.000
    UL\nLTb\nLTb\n1024 986 M\n61 -17 V\n1.000 UL\nLTb\nLTb\n2800 828 M\n-61
    17 V\n stroke\n2881 789 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 10)]\n]
    -46.7 MLshow\n1.000 UL\nLTb\nLTb\n1248 1107 M\n61 -17 V\n1.000
    UL\nLTb\nLTb\n3024 949 M\n-60 17 V\n stroke\n3105 910 M\n[ [(Helvetica)
    140.0 0.0 true true 0 ( 20)]\n] -46.7 MLshow\n1.000 UL\nLTb\nLTb\n1472
    1228 M\n61 -17 V\n1.000 UL\nLTb\nLTb\n576 1067 M\n63 0 V\n stroke\n450
    1067 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 0)]\n] -46.7 MRshow\n1.000
    UL\nLTb\nLTb\n576 1196 M\n63 0 V\n stroke\n450 1196 M\n[ [(Helvetica)
    140.0 0.0 true true 0 ( 10)]\n] -46.7 MRshow\n1.000 UL\nLTb\nLTb\n576
    1325 M\n63 0 V\n stroke\n450 1325 M\n[ [(Helvetica) 140.0 0.0 true true 0
    ( 20)]\n] -46.7 MRshow\n1.000 UL\nLTb\nLTb\n576 1453 M\n63 0 V\n
    stroke\n450 1453 M\n[ [(Helvetica) 140.0 0.0 true true 0 ( 30)]\n] -46.7
    MRshow\n1.000 UL\nLTb\nLTb\n576 1582 M\n63 0 V\n stroke\n450 1582 M\n[
    [(Helvetica) 140.0 0.0 true true 0 ( 40)]\n] -46.7 MRshow\n1.000
    UL\nLTb\nLTb\n576 1711 M\n63 0 V\n stroke\n450 1711 M\n[ [(Helvetica)
    140.0 0.0 true true 0 ( 50)]\n] -46.7 MRshow\n1.000
    UP\nstroke\ngrestore\nend\nshowpage\n>|eps>||||||>

    Certainly, we can also save the data of <with|mode|math|y> and plot with
    Gnuplot.
  </example>

  \ 

  Before the end of this topic, don't forget to save the result,
  <with|color|red|[File]<with|mode|math|\<rightarrow\>>[Saved
  as]>.<with|color|black| You can choose the default file-extension, tm,>
  then all the data will be stored in XML-like format. If you want to output
  the data, press "<with|color|red|printer>" or export as postscript file
  since the postscript format is full supported in any Linux systems and this
  format is the default output format in Linux box.\ 

  <section|Graph Gallery>

  Just as mentioned before, gnuplot is a very professional software for
  maintaining scientific data. Here, we collect some interesting plots:

  <\session|gnuplot|default>
    <\output>
      This is a TeXmacs interface for GNUplot.

      \;
    </output>

    <\input|GNUplot] >
      f(x,y)=x**6+3*y**2*x**4+(3*y**4-4*y**2)*x**2+y**6
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~set pm3d hidden 100 ~set
      style line 100 lt 6 ~set nokey \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~set
      xrange[-1:1] ~set yrange[-1:1] ~set isosamples 30,30
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~set hidden3d ~set contour
      ~set cntrparam levels discrete 0.05,0,-0.05,-0.5 \ \ \ ~set size 0.7,1
      ~splot -f(x,y) w dots lt 2
    </input>

    <\output>
      <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
      temp.eps\n%%Creator: gnuplot 3.8h patchlevel 0\n%%CreationDate: Sun Mar
      30 13:15:27 2003\n%%DocumentFonts: (atend)\n%%BoundingBox: 50 50 301
      302\n%%Orientation: Portrait\n%%EndComments\n/gnudict 256 dict
      def\ngnudict begin\n/Color false def\n/Solid false def\n/gnulinewidth
      5.000 def\n/userlinewidth gnulinewidth def\n/vshift -46 def\n/dl {10.0
      mul} def\n/hpt_ 31.5 def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_
      def\n/M {moveto} bind def\n/L {lineto} bind def\n/R {rmoveto} bind
      def\n/V {rlineto} bind def\n/N {newpath moveto} bind def\n/f {rlineto
      fill} bind def\n/vpt2 vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow {
      currentpoint stroke M\n \ 0 vshift R show } def\n/Rshow { currentpoint
      stroke M\n \ dup stringwidth pop neg vshift R show } def\n/Cshow {
      currentpoint stroke M\n \ dup stringwidth pop -2 div vshift R show }
      def\n/UP { dup vpt_ mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2
      hpt 2 mul def /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid
      {pop []} if 0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash}
      ifelse } def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL
      { stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
      mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul /udl
      exch def } def\n/PL { stroke userlinewidth setlinewidth } def\n/LTb {
      BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0 setdash 0 0 0
      setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 { PL [4 dl 2 dl] 0
      1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL } def\n/LT3 { PL [1 dl 1.5
      dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1 dl 2 dl] 0 1 1 DL }
      def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL } def\n/LT6 { PL [2 dl 2
      dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0 setdash\n \ \ gsave 1
      setlinecap M 0 0 V stroke grestore } def\n/Dia { stroke [] 0 setdash 2
      copy vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt
      neg vpt V closepath stroke\n \ Pnt } def\n/Pls { stroke [] 0 setdash
      vpt sub M 0 vpt2 V\n \ currentpoint stroke M\n \ hpt neg vpt neg R hpt2
      0 V stroke\n \ } def\n/Box { stroke [] 0 setdash 2 copy exch hpt sub
      exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
      closepath stroke\n \ Pnt } def\n/Crs { stroke [] 0 setdash exch hpt sub
      exch vpt add M\n \ hpt2 vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0
      R hpt2 vpt2 V stroke } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12
      mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      1.62 mul V closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs }
      def\n/BoxF { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill }
      def\n/TriUF { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt
      -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill
      } def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
      neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
      closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt 1.12
      mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash vpt add
      M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V
      closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy gsave\n
      \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath stroke
      grestore Pnt } def\n/PentF { stroke [] 0 setdash gsave\n \ translate 0
      hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath fill grestore }
      def\n/Circle { stroke [] 0 setdash 2 copy\n \ hpt 0 360 arc stroke Pnt
      } def\n/CircleF { stroke [] 0 setdash hpt 0 360 arc fill } def\n/C0 {
      BL [] 0 setdash 2 copy moveto vpt 90 450 \ arc } bind def\n/C1 { BL []
      0 setdash 2 copy \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C2 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C3 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
      bind def\n/C4 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
      \ vpt 180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 270 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C6 { BL [] 0
      setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 90 270 arc closepath
      fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
      def\n/C7 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 0 270
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
      } bind def\n/C8 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
      copy \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
      moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13 {
      BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
      setdash 2 copy vpt 0 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
      \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
      \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
      bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
      def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
      bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
      def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
      Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch vpt2
      vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy exch vpt
      sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 { BL [] 0
      setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt sub exch
      vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0 setdash 2
      copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare } bind
      def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt vpt2
      Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub vpt Square fill Bsquare
      } bind def\n/S9 { BL [] 0 setdash 2 copy vpt sub vpt vpt2 Rec fill
      Bsquare } bind def\n/S10 { BL [] 0 setdash 2 copy vpt sub vpt Square
      fill 2 copy exch vpt sub exch vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S11 { BL [] 0 setdash 2 copy vpt sub vpt Square fill 2 copy
      exch vpt sub exch vpt2 vpt Rec fill\n \ \ \ \ \ \ Bsquare } bind
      def\n/S12 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt
      Rec fill Bsquare } bind def\n/S13 { BL [] 0 setdash 2 copy exch vpt sub
      exch vpt sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill
      Bsquare } bind def\n/S14 { BL [] 0 setdash 2 copy exch vpt sub exch vpt
      sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square
      fill Bsquare } bind def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill
      Bsquare } bind def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke
      grestore } bind def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke
      grestore } bind def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke
      grestore } bind def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke
      grestore } bind def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke
      grestore } bind def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke
      grestore } bind def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke
      grestore } bind def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke
      grestore } bind def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke
      grestore } bind def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke
      grestore } bind def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke
      grestore } bind def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke
      grestore } bind def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke
      grestore } bind def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke
      grestore } bind def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke
      grestore } bind def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke
      grestore } bind def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg
      vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke }
      def\n/BoxE { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE
      { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke }
      def\n/TriDE { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt
      1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath
      stroke } def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M
      4 {72 rotate 0 hpt L} repeat\n \ closepath stroke grestore }
      def\n/CircE { stroke [] 0 setdash \n \ hpt 0 360 arc stroke }
      def\n/Opaque { gsave closepath 1 setgray fill grestore 0 setgray
      closepath } def\n/DiaW { stroke [] 0 setdash vpt add M\n \ hpt neg vpt
      neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V Opaque stroke }
      def\n/BoxW { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW {
      stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW
      { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW
      { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
      repeat\n \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash
      \n \ hpt 0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray
      fill grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
      makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
      ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0 get
      findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ] exch
      dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch 4 get
      {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n \ \ \ \ {dup 3
      get {2 get neg 0 exch R pop} {pop aload pop M} ifelse} {dup 5\n
      \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get stringwidth pop
      -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop -2 div 0 R 6 get\n
      \ \ \ \ show 2 index {aload pop M neg 3 -1 roll neg R pop pop} {pop pop
      pop\n \ \ \ \ pop aload pop M} ifelse }ifelse }ifelse } forall} bind
      def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get findfont exch 1 get
      scalefont\n \ \ \ \ setfont 6 get stringwidth pop add} {pop} ifelse}
      forall} bind def\n/MLshow { currentpoint stroke M\n \ 0 exch R MFshow }
      bind def\n/MRshow { currentpoint stroke M\n \ exch dup MFwidth neg 3 -1
      roll R MFshow } def\n/MCshow { currentpoint stroke M\n \ exch dup
      MFwidth -2 div 3 -1 roll R MFshow } def\nend\n%%EndProlog\ngnudict
      begin\ngsave\n50 50 translate\n0.050 0.050 scale\n0
      setgray\nnewpath\n(Helvetica) findfont 140 scalefont setfont\n1.000
      UL\nLTb\ngsave %% colour palette begin\n/maxcolors 0
      def\n/maxcolorsLast {maxcolors 1 sub maxcolors div} def\n/pm3dround
      {maxcolors 0 gt {dup maxcolorsLast ge {pop 1} {maxcolors mul floor
      maxcolors div} ifelse} if} def\n/cF7 {sqrt} bind def\t% sqrt(x)\n/cF5
      {dup dup mul mul} bind def\t% x^3\n/cF15 {360 mul sin} bind def\t%
      sin(360x)\nColor true and { % COLOUR vs. GRAY map\n \ /g {stroke
      pm3dround dup cF7 exch dup cF5 exch cF15 setrgbcolor} bind def\n \ /h
      {rlineto rlineto rlineto fill} bind def\n}{\n \ /g {stroke pm3dround
      setgray} bind def\n \ /h {rlineto rlineto rlineto fill} bind def\n}
      ifelse\n%pm3d_map_begin\n.2065 g 2040 3094 N 45 -236 78 252 -45 277
      h\n1.000 UP\n1.000 UL\nLT5\n2040 3094 M\n78 293 V\n-45 236 V\n-78 -252
      V\n45 -277 V\n.3798 g 2118 3387 N 45 -200 78 177 -45 236 h\n1.000
      UP\n1.000 UL\nLT5\n2118 3387 M\n78 213 V\n-45 200 V\n-78 -177 V\n45
      -236 V\n.5059 g 2196 3600 N 45 -173 78 120 -45 200 h\n1.000 UP\n1.000
      UL\nLT5\n2196 3600 M\n78 147 V\n-45 173 V\n-78 -120 V\n45 -200 V\n.5949
      g 2274 3747 N 45 -149 78 73 -45 173 h\n1.000 UP\n1.000 UL\nLT5\n2274
      3747 M\n78 97 V\n-45 149 V\n-78 -73 V\n45 -173 V\n.655 g 2352 3844 N 45
      -130 78 39 -45 149 h\n1.000 UP\n1.000 UL\nLT5\n2352 3844 M\n78 58
      V\n-45 130 V\n-78 -39 V\n45 -149 V\n.6931 g 2430 3902 N 45 -116 78 13
      -45 130 h\n1.000 UP\n1.000 UL\nLT5\n2430 3902 M\n78 27 V\n-45 116
      V\n-78 -13 V\n45 -130 V\n.7149 g 2508 3929 N 46 -104 78 -6 -45 116
      h\n1.000 UP\n1.000 UL\nLT5\n2508 3929 M\n79 6 V\n-46 104 V\n-78 6 V\n45
      -116 V\n.7251 g 2587 3935 N 45 -95 79 -18 -46 104 h\n1.000 UP\n1.000
      UL\nLT5\n2587 3935 M\n78 -9 V\n-45 95 V\n-79 18 V\n46 -104 V\n.7276 g
      2665 3926 N 45 -89 78 -26 -45 95 h\n1.000 UP\n1.000 UL\nLT5\n2665 3926
      M\n78 -20 V\n-45 89 V\n-78 26 V\n45 -95 V\n.7252 g 2743 3906 N 45 -84
      78 -31 -45 89 h\n1.000 UP\n1.000 UL\nLT5\n2743 3906 M\n78 -26 V\n-45 84
      V\n-78 31 V\n45 -89 V\n.7204 g 2821 3880 N 45 -80 78 -32 -45 84
      h\n1.000 UP\n1.000 UL\nLT5\n2821 3880 M\n78 -28 V\n-45 80 V\n-78 32
      V\n45 -84 V\n.7149 g 2899 3852 N 45 -78 78 -31 -45 80 h\n1.000
      UP\n1.000 UL\nLT5\n2899 3852 M\n78 -29 V\n-45 78 V\n-78 31 V\n45 -80
      V\n.7101 g 2977 3823 N 45 -77 78 -29 -45 78 h\n1.000 UP\n1.000
      UL\nLT5\n2977 3823 M\n78 -28 V\n-45 77 V\n-78 29 V\n45 -78 V\n.7068 g
      3055 3795 N 45 -76 78 -26 -45 77 h\n1.000 UP\n1.000 UL\nLT5\n3055 3795
      M\n78 -25 V\n-45 76 V\n-78 26 V\n45 -77 V\n.7057 g 3133 3770 N 45 -76
      78 -22 -45 76 h\n1.000 UP\n1.000 UL\nLT5\n3133 3770 M\n78 -22 V\n-45 76
      V\n-78 22 V\n45 -76 V\n.7068 g 3211 3748 N 45 -77 78 -18 -45 76
      h\n1.000 UP\n1.000 UL\nLT5\n3211 3748 M\n78 -19 V\n-45 77 V\n-78 18
      V\n45 -76 V\n.7101 g 3289 3729 N 45 -79 78 -15 -45 77 h\n1.000
      UP\n1.000 UL\nLT5\n3289 3729 M\n78 -17 V\n-45 79 V\n-78 15 V\n45 -77
      V\n.7149 g 3367 3712 N 46 -81 78 -13 -45 79 h\n1.000 UP\n1.000
      UL\nLT5\n3367 3712 M\n79 -15 V\n-46 81 V\n-78 13 V\n45 -79 V\n.7204 g
      3446 3697 N 45 -84 79 -12 -46 81 h\n1.000 UP\n1.000 UL\nLT5\n3446 3697
      M\n78 -15 V\n-45 84 V\n-79 12 V\n46 -81 V\n.7252 g 3524 3682 N 45 -89
      78 -14 -45 84 h\n1.000 UP\n1.000 UL\nLT5\n3524 3682 M\n78 -19 V\n-45 89
      V\n-78 14 V\n45 -84 V\n.7276 g 3602 3663 N 45 -95 78 -18 -45 89
      h\n1.000 UP\n1.000 UL\nLT5\n3602 3663 M\n78 -24 V\n-45 95 V\n-78 18
      V\n45 -89 V\n.7251 g 3680 3639 N 45 -105 78 -25 -45 95 h\n1.000
      UP\n1.000 UL\nLT5\n3680 3639 M\n78 -35 V\n-45 105 V\n-78 25 V\n45 -95
      V\n.7149 g 3758 3604 N 45 -116 78 -39 -45 105 h\n1.000 UP\n1.000
      UL\nLT5\n3758 3604 M\n78 -50 V\n-45 116 V\n-78 39 V\n45 -105 V\n.6931 g
      3836 3554 N 45 -130 78 -57 -45 116 h\n1.000 UP\n1.000 UL\nLT5\n3836
      3554 M\n78 -71 V\n-45 130 V\n-78 57 V\n45 -116 V\n.655 g 3914 3483 N 45
      -149 78 -83 -45 130 h\n1.000 UP\n1.000 UL\nLT5\n3914 3483 M\n78 -102
      V\n-45 149 V\n-78 83 V\n45 -130 V\n.5949 g 3992 3381 N 45 -172 78 -118
      -45 149 h\n1.000 UP\n1.000 UL\nLT5\n3992 3381 M\n78 -141 V\n-45 172
      V\n-78 118 V\n45 -149 V\n.5059 g 4070 3240 N 45 -201 78 -163 -45 172
      h\n1.000 UP\n1.000 UL\nLT5\n4070 3240 M\n78 -192 V\n-45 201 V\n-78 163
      V\n45 -172 V\n.3798 g 4148 3048 N 45 -235 78 -222 -45 201 h\n1.000
      UP\n1.000 UL\nLT5\n4148 3048 M\n78 -256 V\n-45 235 V\n-78 222 V\n45
      -201 V\n.2065 g 4226 2792 N 46 -278 78 -295 -45 235 h\n1.000 UP\n1.000
      UL\nLT5\n4226 2792 M\n79 -338 V\n-46 278 V\n-78 295 V\n45 -235 V\n.3798
      g 1995 3371 N 45 -161 78 217 -45 196 h\n1.000 UP\n1.000 UL\nLT5\n1995
      3371 M\n78 252 V\n-45 161 V\n-78 -217 V\n45 -196 V\n.5293 g 2073 3623 N
      45 -134 78 150 -45 161 h\n1.000 UP\n1.000 UL\nLT5\n2073 3623 M\n78 177
      V\n-45 134 V\n-78 -150 V\n45 -161 V\n.6361 g 2151 3800 N 45 -110 78 96
      -45 134 h\n1.000 UP\n1.000 UL\nLT5\n2151 3800 M\n78 120 V\n-45 110
      V\n-78 -96 V\n45 -134 V\n.7093 g 2229 3920 N 45 -92 78 55 -45 110
      h\n1.000 UP\n1.000 UL\nLT5\n2229 3920 M\n78 73 V\n-45 92 V\n-78 -55
      V\n45 -110 V\n.7569 g 2307 3993 N 45 -78 78 25 -45 92 h\n1.000
      UP\n1.000 UL\nLT5\n2307 3993 M\n78 39 V\n-45 78 V\n-78 -25 V\n45 -92
      V\n.7851 g 2385 4032 N 45 -67 78 2 -45 78 h\n1.000 UP\n1.000
      UL\nLT5\n2385 4032 M\n78 13 V\n-45 67 V\n-78 -2 V\n45 -78 V\n.7993 g
      2463 4045 N 45 -59 78 -14 -45 67 h\n1.000 UP\n1.000 UL\nLT5\n2463 4045
      M\n78 -6 V\n-45 59 V\n-78 14 V\n45 -67 V\n.8037 g 2541 4039 N 46 -53 78
      -24 -45 59 h\n1.000 UP\n1.000 UL\nLT5\n2541 4039 M\n79 -18 V\n-46 53
      V\n-78 24 V\n45 -59 V\n.8017 g 2620 4021 N 45 -48 79 -31 -46 53
      h\n1.000 UP\n1.000 UL\nLT5\n2620 4021 M\n78 -26 V\n-45 48 V\n-79 31
      V\n46 -53 V\n.7962 g 2698 3995 N 45 -46 78 -33 -45 48 h\n1.000
      UP\n1.000 UL\nLT5\n2698 3995 M\n78 -31 V\n-45 46 V\n-78 33 V\n45 -48
      V\n.7891 g 2776 3964 N 45 -44 78 -34 -45 46 h\n1.000 UP\n1.000
      UL\nLT5\n2776 3964 M\n78 -32 V\n-45 44 V\n-78 34 V\n45 -46 V\n.7821 g
      2854 3932 N 45 -42 78 -33 -45 44 h\n1.000 UP\n1.000 UL\nLT5\n2854 3932
      M\n78 -31 V\n-45 42 V\n-78 33 V\n45 -44 V\n.7763 g 2932 3901 N 45 -41
      78 -30 -45 42 h\n1.000 UP\n1.000 UL\nLT5\n2932 3901 M\n78 -29 V\n-45 41
      V\n-78 30 V\n45 -42 V\n.7726 g 3010 3872 N 45 -41 78 -26 -45 41
      h\n1.000 UP\n1.000 UL\nLT5\n3010 3872 M\n78 -26 V\n-45 41 V\n-78 26
      V\n45 -41 V\n.7712 g 3088 3846 N 45 -41 78 -22 -45 41 h\n1.000
      UP\n1.000 UL\nLT5\n3088 3846 M\n78 -22 V\n-45 41 V\n-78 22 V\n45 -41
      V\n.7726 g 3166 3824 N 45 -41 78 -18 -45 41 h\n1.000 UP\n1.000
      UL\nLT5\n3166 3824 M\n78 -18 V\n-45 41 V\n-78 18 V\n45 -41 V\n.7763 g
      3244 3806 N 45 -42 78 -14 -45 41 h\n1.000 UP\n1.000 UL\nLT5\n3244 3806
      M\n78 -15 V\n-45 42 V\n-78 14 V\n45 -41 V\n.7821 g 3322 3791 N 45 -43
      78 -12 -45 42 h\n1.000 UP\n1.000 UL\nLT5\n3322 3791 M\n78 -13 V\n-45 43
      V\n-78 12 V\n45 -42 V\n.7891 g 3400 3778 N 46 -45 78 -10 -45 43
      h\n1.000 UP\n1.000 UL\nLT5\n3400 3778 M\n79 -12 V\n-46 45 V\n-78 10
      V\n45 -43 V\n.7962 g 3479 3766 N 45 -49 79 -10 -46 45 h\n1.000
      UP\n1.000 UL\nLT5\n3479 3766 M\n78 -14 V\n-45 49 V\n-79 10 V\n46 -45
      V\n.8017 g 3557 3752 N 45 -53 78 -14 -45 49 h\n1.000 UP\n1.000
      UL\nLT5\n3557 3752 M\n78 -18 V\n-45 53 V\n-78 14 V\n45 -49 V\n.8037 g
      3635 3734 N 45 -58 78 -20 -45 53 h\n1.000 UP\n1.000 UL\nLT5\n3635 3734
      M\n78 -25 V\n-45 58 V\n-78 20 V\n45 -53 V\n.7993 g 3713 3709 N 45 -67
      78 -30 -45 58 h\n1.000 UP\n1.000 UL\nLT5\n3713 3709 M\n78 -39 V\n-45 67
      V\n-78 30 V\n45 -58 V\n.7851 g 3791 3670 N 45 -78 78 -46 -45 67
      h\n1.000 UP\n1.000 UL\nLT5\n3791 3670 M\n78 -57 V\n-45 78 V\n-78 46
      V\n45 -67 V\n.7569 g 3869 3613 N 45 -92 78 -69 -45 78 h\n1.000
      UP\n1.000 UL\nLT5\n3869 3613 M\n78 -83 V\n-45 92 V\n-78 69 V\n45 -78
      V\n.7093 g 3947 3530 N 45 -111 78 -99 -45 92 h\n1.000 UP\n1.000
      UL\nLT5\n3947 3530 M\n78 -118 V\n-45 111 V\n-78 99 V\n45 -92 V\n.6361 g
      4025 3412 N 45 -133 78 -141 -45 111 h\n1.000 UP\n1.000 UL\nLT5\n4025
      3412 M\n78 -163 V\n-45 133 V\n-78 141 V\n45 -111 V\n.5293 g 4103 3249 N
      45 -162 78 -193 -45 133 h\n1.000 UP\n1.000 UL\nLT5\n4103 3249 M\n78
      -222 V\n-45 162 V\n-78 193 V\n45 -133 V\n.3798 g 4181 3027 N 45 -196 78
      -261 -45 162 h\n1.000 UP\n1.000 UL\nLT5\n4181 3027 M\n78 -295 V\n-45
      196 V\n-78 261 V\n45 -162 V\n.5059 g 1950 3567 N 45 -103 78 188 -45 132
      h\n1.000 UP\n1.000 UL\nLT5\n1950 3567 M\n78 217 V\n-45 103 V\n-78 -188
      V\n45 -132 V\n.6361 g 2028 3784 N 45 -80 78 127 -45 103 h\n1.000
      UP\n1.000 UL\nLT5\n2028 3784 M\n78 150 V\n-45 80 V\n-78 -127 V\n45 -103
      V\n.7272 g 2106 3934 N 45 -62 78 78 -45 80 h\n1.000 UP\n1.000
      UL\nLT5\n2106 3934 M\n78 96 V\n-45 62 V\n-78 -78 V\n45 -80 V\n.7881 g
      2184 4030 N 45 -48 78 41 -45 62 h\n1.000 UP\n1.000 UL\nLT5\n2184 4030
      M\n78 55 V\n-45 48 V\n-78 -41 V\n45 -62 V\n.8259 g 2262 4085 N 45 -37
      78 14 -45 48 h\n1.000 UP\n1.000 UL\nLT5\n2262 4085 M\n78 25 V\n-45 37
      V\n-78 -14 V\n45 -48 V\n.8468 g 2340 4110 N 45 -29 78 -6 -45 37
      h\n1.000 UP\n1.000 UL\nLT5\n2340 4110 M\n78 2 V\n-45 29 V\n-78 6 V\n45
      -37 V\n.8554 g 2418 4112 N 45 -24 78 -19 -45 29 h\n1.000 UP\n1.000
      UL\nLT5\n2418 4112 M\n78 -14 V\n-45 24 V\n-78 19 V\n45 -29 V\n.8558 g
      2496 4098 N 45 -20 78 -28 -45 24 h\n1.000 UP\n1.000 UL\nLT5\n2496 4098
      M\n78 -24 V\n-45 20 V\n-78 28 V\n45 -24 V\n.8511 g 2574 4074 N 46 -18
      78 -33 -45 20 h\n1.000 UP\n1.000 UL\nLT5\n2574 4074 M\n79 -31 V\n-46 18
      V\n-78 33 V\n45 -20 V\n.8436 g 2653 4043 N 45 -16 79 -35 -46 18
      h\n1.000 UP\n1.000 UL\nLT5\n2653 4043 M\n78 -33 V\n-45 16 V\n-79 35
      V\n46 -18 V\n.8353 g 2731 4010 N 45 -15 78 -35 -45 16 h\n1.000
      UP\n1.000 UL\nLT5\n2731 4010 M\n78 -34 V\n-45 15 V\n-78 35 V\n45 -16
      V\n.8276 g 2809 3976 N 45 -15 78 -33 -45 15 h\n1.000 UP\n1.000
      UL\nLT5\n2809 3976 M\n78 -33 V\n-45 15 V\n-78 33 V\n45 -15 V\n.8213 g
      2887 3943 N 45 -15 78 -30 -45 15 h\n1.000 UP\n1.000 UL\nLT5\n2887 3943
      M\n78 -30 V\n-45 15 V\n-78 30 V\n45 -15 V\n.8174 g 2965 3913 N 45 -15
      78 -26 -45 15 h\n1.000 UP\n1.000 UL\nLT5\n2965 3913 M\n78 -26 V\n-45 15
      V\n-78 26 V\n45 -15 V\n.816 g 3043 3887 N 45 -15 78 -22 -45 15 h\n1.000
      UP\n1.000 UL\nLT5\n3043 3887 M\n78 -22 V\n-45 15 V\n-78 22 V\n45 -15
      V\n.8174 g 3121 3865 N 45 -15 78 -18 -45 15 h\n1.000 UP\n1.000
      UL\nLT5\n3121 3865 M\n78 -18 V\n-45 15 V\n-78 18 V\n45 -15 V\n.8213 g
      3199 3847 N 45 -15 78 -14 -45 15 h\n1.000 UP\n1.000 UL\nLT5\n3199 3847
      M\n78 -14 V\n-45 15 V\n-78 14 V\n45 -15 V\n.8276 g 3277 3833 N 45 -16
      78 -11 -45 15 h\n1.000 UP\n1.000 UL\nLT5\n3277 3833 M\n78 -12 V\n-45 16
      V\n-78 11 V\n45 -15 V\n.8353 g 3355 3821 N 45 -16 78 -10 -45 16
      h\n1.000 UP\n1.000 UL\nLT5\n3355 3821 M\n78 -10 V\n-45 16 V\n-78 10
      V\n45 -16 V\n.8436 g 3433 3811 N 46 -17 78 -9 -45 16 h\n1.000 UP\n1.000
      UL\nLT5\n3433 3811 M\n79 -10 V\n-46 17 V\n-78 9 V\n45 -16 V\n.8511 g
      3512 3801 N 45 -20 79 -11 -46 17 h\n1.000 UP\n1.000 UL\nLT5\n3512 3801
      M\n78 -14 V\n-45 20 V\n-79 11 V\n46 -17 V\n.8558 g 3590 3787 N 45 -24
      78 -16 -45 20 h\n1.000 UP\n1.000 UL\nLT5\n3590 3787 M\n78 -20 V\n-45 24
      V\n-78 16 V\n45 -20 V\n.8554 g 3668 3767 N 45 -30 78 -24 -45 24
      h\n1.000 UP\n1.000 UL\nLT5\n3668 3767 M\n78 -30 V\n-45 30 V\n-78 24
      V\n45 -24 V\n.8468 g 3746 3737 N 45 -37 78 -39 -45 30 h\n1.000
      UP\n1.000 UL\nLT5\n3746 3737 M\n78 -46 V\n-45 37 V\n-78 39 V\n45 -30
      V\n.8259 g 3824 3691 N 45 -48 78 -58 -45 37 h\n1.000 UP\n1.000
      UL\nLT5\n3824 3691 M\n78 -69 V\n-45 48 V\n-78 58 V\n45 -37 V\n.7881 g
      3902 3622 N 45 -62 78 -85 -45 48 h\n1.000 UP\n1.000 UL\nLT5\n3902 3622
      M\n78 -99 V\n-45 62 V\n-78 85 V\n45 -48 V\n.7272 g 3980 3523 N 45 -80
      78 -123 -45 62 h\n1.000 UP\n1.000 UL\nLT5\n3980 3523 M\n78 -141 V\n-45
      80 V\n-78 123 V\n45 -62 V\n.6361 g 4058 3382 N 45 -103 78 -170 -45 80
      h\n1.000 UP\n1.000 UL\nLT5\n4058 3382 M\n78 -193 V\n-45 103 V\n-78 170
      V\n45 -80 V\n.5059 g 4136 3189 N 45 -132 78 -232 -45 103 h\n1.000
      UP\n1.000 UL\nLT5\n4136 3189 M\n78 -261 V\n-45 132 V\n-78 232 V\n45
      -103 V\n.5949 g 1905 3699 N 45 -58 78 165 -45 81 h\n1.000 UP\n1.000
      UL\nLT5\n1905 3699 M\n78 188 V\n-45 58 V\n-78 -165 V\n45 -81 V\n.7093 g
      1983 3887 N 45 -39 78 108 -45 58 h\n1.000 UP\n1.000 UL\nLT5\n1983 3887
      M\n78 127 V\n-45 39 V\n-78 -108 V\n45 -58 V\n.7881 g 2061 4014 N 45 -25
      78 64 -45 39 h\n1.000 UP\n1.000 UL\nLT5\n2061 4014 M\n78 78 V\n-45 25
      V\n-78 -64 V\n45 -39 V\n.8393 g 2139 4092 N 45 -15 78 31 -45 25
      h\n1.000 UP\n1.000 UL\nLT5\n2139 4092 M\n78 41 V\n-45 15 V\n-78 -31
      V\n45 -25 V\n.87 g 2217 4133 N 45 -7 78 6 -45 15 h\n1.000 UP\n1.000
      UL\nLT5\n2217 4133 M\n78 14 V\n-45 7 V\n-78 -6 V\n45 -15 V\n.8855 g
      2295 4147 N 45 -2 78 -11 -45 7 h\n1.000 UP\n1.000 UL\nLT5\n2295 4147
      M\n78 -6 V\n-45 2 V\n-78 11 V\n45 -7 V\n.8905 g 2373 4141 N 45 1 78 -22
      -45 2 h\n1.000 UP\n1.000 UL\nLT5\n2373 4141 M\n78 -19 V\n-45 -1 V\n-78
      22 V\n45 -2 V\n.8884 g 2451 4122 N 45 3 78 -30 -45 -1 h\n1.000
      UP\n1.000 UL\nLT5\n2451 4122 M\n78 -28 V\n-45 -3 V\n-78 30 V\n45 1
      V\n.8821 g 2529 4094 N 45 5 78 -35 -45 -3 h\n1.000 UP\n1.000
      UL\nLT5\n2529 4094 M\n78 -33 V\n-45 -5 V\n-78 35 V\n45 3 V\n.8737 g
      2607 4061 N 46 5 78 -35 -45 -5 h\n1.000 UP\n1.000 UL\nLT5\n2607 4061
      M\n79 -35 V\n-46 -5 V\n-78 35 V\n45 5 V\n.865 g 2686 4026 N 45 5 79 -35
      -46 -5 h\n1.000 UP\n1.000 UL\nLT5\n2686 4026 M\n78 -35 V\n-45 -5 V\n-79
      35 V\n46 5 V\n.8571 g 2764 3991 N 45 4 78 -32 -45 -5 h\n1.000 UP\n1.000
      UL\nLT5\n2764 3991 M\n78 -33 V\n-45 -4 V\n-78 32 V\n45 5 V\n.8509 g
      2842 3958 N 45 4 78 -30 -45 -4 h\n1.000 UP\n1.000 UL\nLT5\n2842 3958
      M\n78 -30 V\n-45 -4 V\n-78 30 V\n45 4 V\n.8469 g 2920 3928 N 45 4 78
      -26 -45 -4 h\n1.000 UP\n1.000 UL\nLT5\n2920 3928 M\n78 -26 V\n-45 -4
      V\n-78 26 V\n45 4 V\n.8456 g 2998 3902 N 45 4 78 -22 -45 -4 h\n1.000
      UP\n1.000 UL\nLT5\n2998 3902 M\n78 -22 V\n-45 -4 V\n-78 22 V\n45 4
      V\n.8469 g 3076 3880 N 45 4 78 -18 -45 -4 h\n1.000 UP\n1.000
      UL\nLT5\n3076 3880 M\n78 -18 V\n-45 -4 V\n-78 18 V\n45 4 V\n.8509 g
      3154 3862 N 45 4 78 -14 -45 -4 h\n1.000 UP\n1.000 UL\nLT5\n3154 3862
      M\n78 -14 V\n-45 -4 V\n-78 14 V\n45 4 V\n.8571 g 3232 3848 N 45 5 78
      -12 -45 -4 h\n1.000 UP\n1.000 UL\nLT5\n3232 3848 M\n78 -11 V\n-45 -5
      V\n-78 12 V\n45 4 V\n.865 g 3310 3837 N 45 4 78 -9 -45 -5 h\n1.000
      UP\n1.000 UL\nLT5\n3310 3837 M\n78 -10 V\n-45 -4 V\n-78 9 V\n45 5
      V\n.8737 g 3388 3827 N 45 4 78 -9 -45 -4 h\n1.000 UP\n1.000
      UL\nLT5\n3388 3827 M\n78 -9 V\n-45 -4 V\n-78 9 V\n45 4 V\n.8821 g 3466
      3818 N 45 3 79 -10 -45 -4 h\n1.000 UP\n1.000 UL\nLT5\n3466 3818 M\n79
      -11 V\n-45 -3 V\n-79 10 V\n45 4 V\n.8884 g 3545 3807 N 45 1 78 -14 -45
      -3 h\n1.000 UP\n1.000 UL\nLT5\n3545 3807 M\n78 -16 V\n-45 -1 V\n-78 14
      V\n45 3 V\n.8905 g 3623 3791 N 45 -2 78 -21 -45 -1 h\n1.000 UP\n1.000
      UL\nLT5\n3623 3791 M\n78 -24 V\n-45 2 V\n-78 21 V\n45 1 V\n.8855 g 3701
      3767 N 45 -7 78 -34 -45 2 h\n1.000 UP\n1.000 UL\nLT5\n3701 3767 M\n78
      -39 V\n-45 7 V\n-78 34 V\n45 -2 V\n.87 g 3779 3728 N 45 -15 78 -50 -45
      7 h\n1.000 UP\n1.000 UL\nLT5\n3779 3728 M\n78 -58 V\n-45 15 V\n-78 50
      V\n45 -7 V\n.8393 g 3857 3670 N 45 -25 78 -75 -45 15 h\n1.000 UP\n1.000
      UL\nLT5\n3857 3670 M\n78 -85 V\n-45 25 V\n-78 75 V\n45 -15 V\n.7881 g
      3935 3585 N 45 -40 78 -108 -45 25 h\n1.000 UP\n1.000 UL\nLT5\n3935 3585
      M\n78 -123 V\n-45 40 V\n-78 108 V\n45 -25 V\n.7093 g 4013 3462 N 45 -57
      78 -153 -45 40 h\n1.000 UP\n1.000 UL\nLT5\n4013 3462 M\n78 -170 V\n-45
      57 V\n-78 153 V\n45 -40 V\n.5949 g 4091 3292 N 45 -80 78 -209 -45 57
      h\n1.000 UP\n1.000 UL\nLT5\n4091 3292 M\n78 -232 V\n-45 80 V\n-78 209
      V\n45 -57 V\n.655 g 1860 3780 N 45 -23 79 147 -46 41 h\n1.000 UP\n1.000
      UL\nLT5\n1860 3780 M\n78 165 V\n-45 23 V\n-79 -147 V\n46 -41 V\n.7569 g
      1938 3945 N 45 -8 78 93 -45 23 h\n1.000 UP\n1.000 UL\nLT5\n1938 3945
      M\n78 108 V\n-45 8 V\n-78 -93 V\n45 -23 V\n.8259 g 2016 4053 N 45 2 78
      54 -45 8 h\n1.000 UP\n1.000 UL\nLT5\n2016 4053 M\n78 64 V\n-45 -2
      V\n-78 -54 V\n45 -8 V\n.87 g 2094 4117 N 45 10 78 23 -45 -2 h\n1.000
      UP\n1.000 UL\nLT5\n2094 4117 M\n78 31 V\n-45 -10 V\n-78 -23 V\n45 2
      V\n.8954 g 2172 4148 N 45 14 78 2 -45 -10 h\n1.000 UP\n1.000
      UL\nLT5\n2172 4148 M\n78 6 V\n-45 -14 V\n-78 -2 V\n45 10 V\n.9074 g
      2250 4154 N 45 18 78 -15 -45 -14 h\n1.000 UP\n1.000 UL\nLT5\n2250 4154
      M\n78 -11 V\n-45 -18 V\n-78 15 V\n45 14 V\n.91 g 2328 4143 N 45 20 78
      -24 -45 -18 h\n1.000 UP\n1.000 UL\nLT5\n2328 4143 M\n78 -22 V\n-45 -20
      V\n-78 24 V\n45 18 V\n.9067 g 2406 4121 N 45 21 78 -31 -45 -20 h\n1.000
      UP\n1.000 UL\nLT5\n2406 4121 M\n78 -30 V\n-45 -21 V\n-78 31 V\n45 20
      V\n.8998 g 2484 4091 N 45 20 78 -34 -45 -21 h\n1.000 UP\n1.000
      UL\nLT5\n2484 4091 M\n78 -35 V\n-45 -20 V\n-78 34 V\n45 21 V\n.8914 g
      2562 4056 N 45 19 78 -34 -45 -20 h\n1.000 UP\n1.000 UL\nLT5\n2562 4056
      M\n78 -35 V\n-45 -19 V\n-78 34 V\n45 20 V\n.8829 g 2640 4021 N 46 18 78
      -34 -45 -19 h\n1.000 UP\n1.000 UL\nLT5\n2640 4021 M\n79 -35 V\n-46 -18
      V\n-78 34 V\n45 19 V\n.8753 g 2719 3986 N 45 18 79 -32 -46 -18 h\n1.000
      UP\n1.000 UL\nLT5\n2719 3986 M\n78 -32 V\n-45 -18 V\n-79 32 V\n46 18
      V\n.8694 g 2797 3954 N 45 17 78 -29 -45 -18 h\n1.000 UP\n1.000
      UL\nLT5\n2797 3954 M\n78 -30 V\n-45 -17 V\n-78 29 V\n45 18 V\n.8657 g
      2875 3924 N 45 17 78 -26 -45 -17 h\n1.000 UP\n1.000 UL\nLT5\n2875 3924
      M\n78 -26 V\n-45 -17 V\n-78 26 V\n45 17 V\n.8644 g 2953 3898 N 45 17 78
      -22 -45 -17 h\n1.000 UP\n1.000 UL\nLT5\n2953 3898 M\n78 -22 V\n-45 -17
      V\n-78 22 V\n45 17 V\n.8657 g 3031 3876 N 45 17 78 -18 -45 -17 h\n1.000
      UP\n1.000 UL\nLT5\n3031 3876 M\n78 -18 V\n-45 -17 V\n-78 18 V\n45 17
      V\n.8694 g 3109 3858 N 45 18 78 -15 -45 -17 h\n1.000 UP\n1.000
      UL\nLT5\n3109 3858 M\n78 -14 V\n-45 -18 V\n-78 15 V\n45 17 V\n.8753 g
      3187 3844 N 45 18 78 -12 -45 -18 h\n1.000 UP\n1.000 UL\nLT5\n3187 3844
      M\n78 -12 V\n-45 -18 V\n-78 12 V\n45 18 V\n.8829 g 3265 3832 N 45 20 78
      -11 -45 -18 h\n1.000 UP\n1.000 UL\nLT5\n3265 3832 M\n78 -9 V\n-45 -20
      V\n-78 11 V\n45 18 V\n.8914 g 3343 3823 N 45 20 78 -9 -45 -20 h\n1.000
      UP\n1.000 UL\nLT5\n3343 3823 M\n78 -9 V\n-45 -20 V\n-78 9 V\n45 20
      V\n.8998 g 3421 3814 N 46 20 78 -10 -45 -20 h\n1.000 UP\n1.000
      UL\nLT5\n3421 3814 M\n79 -10 V\n-46 -20 V\n-78 10 V\n45 20 V\n.9067 g
      3500 3804 N 45 20 79 -14 -46 -20 h\n1.000 UP\n1.000 UL\nLT5\n3500 3804
      M\n78 -14 V\n-45 -20 V\n-79 14 V\n46 20 V\n.91 g 3578 3790 N 45 18 78
      -19 -45 -20 h\n1.000 UP\n1.000 UL\nLT5\n3578 3790 M\n78 -21 V\n-45 -18
      V\n-78 19 V\n45 20 V\n.9074 g 3656 3769 N 45 14 78 -30 -45 -18 h\n1.000
      UP\n1.000 UL\nLT5\n3656 3769 M\n78 -34 V\n-45 -14 V\n-78 30 V\n45 18
      V\n.8954 g 3734 3735 N 45 10 78 -46 -45 -14 h\n1.000 UP\n1.000
      UL\nLT5\n3734 3735 M\n78 -50 V\n-45 -10 V\n-78 46 V\n45 14 V\n.87 g
      3812 3685 N 45 2 78 -67 -45 -10 h\n1.000 UP\n1.000 UL\nLT5\n3812 3685
      M\n78 -75 V\n-45 -2 V\n-78 67 V\n45 10 V\n.8259 g 3890 3610 N 45 -8 78
      -98 -45 -2 h\n1.000 UP\n1.000 UL\nLT5\n3890 3610 M\n78 -108 V\n-45 8
      V\n-78 98 V\n45 2 V\n.7569 g 3968 3502 N 45 -23 78 -138 -45 8 h\n1.000
      UP\n1.000 UL\nLT5\n3968 3502 M\n78 -153 V\n-45 23 V\n-78 138 V\n45 -8
      V\n.655 g 4046 3349 N 45 -41 78 -191 -45 23 h\n1.000 UP\n1.000
      UL\nLT5\n4046 3349 M\n78 -209 V\n-45 41 V\n-78 191 V\n45 -23 V\n.6931 g
      1814 3821 N 46 4 78 132 -45 11 h\n1.000 UP\n1.000 UL\nLT5\n1814 3821
      M\n79 147 V\n-46 -4 V\n-78 -132 V\n45 -11 V\n.7851 g 1893 3968 N 45 14
      79 83 -46 -4 h\n1.000 UP\n1.000 UL\nLT5\n1893 3968 M\n78 93 V\n-45 -14
      V\n-79 -83 V\n46 4 V\n.8468 g 1971 4061 N 45 22 78 46 -45 -14 h\n1.000
      UP\n1.000 UL\nLT5\n1971 4061 M\n78 54 V\n-45 -22 V\n-78 -46 V\n45 14
      V\n.8855 g 2049 4115 N 45 27 78 18 -45 -22 h\n1.000 UP\n1.000
      UL\nLT5\n2049 4115 M\n78 23 V\n-45 -27 V\n-78 -18 V\n45 22 V\n.9074 g
      2127 4138 N 45 31 78 -2 -45 -27 h\n1.000 UP\n1.000 UL\nLT5\n2127 4138
      M\n78 2 V\n-45 -31 V\n-78 2 V\n45 27 V\n.9171 g 2205 4140 N 45 31 78
      -15 -45 -31 h\n1.000 UP\n1.000 UL\nLT5\n2205 4140 M\n78 -15 V\n-45 -31
      V\n-78 15 V\n45 31 V\n.9187 g 2283 4125 N 45 32 78 -25 -45 -31 h\n1.000
      UP\n1.000 UL\nLT5\n2283 4125 M\n78 -24 V\n-45 -32 V\n-78 25 V\n45 31
      V\n.915 g 2361 4101 N 45 31 78 -30 -45 -32 h\n1.000 UP\n1.000
      UL\nLT5\n2361 4101 M\n78 -31 V\n-45 -31 V\n-78 30 V\n45 32 V\n.9083 g
      2439 4070 N 45 30 78 -33 -45 -31 h\n1.000 UP\n1.000 UL\nLT5\n2439 4070
      M\n78 -34 V\n-45 -30 V\n-78 33 V\n45 31 V\n.9005 g 2517 4036 N 45 30 78
      -34 -45 -30 h\n1.000 UP\n1.000 UL\nLT5\n2517 4036 M\n78 -34 V\n-45 -30
      V\n-78 34 V\n45 30 V\n.8926 g 2595 4002 N 45 28 78 -32 -45 -30 h\n1.000
      UP\n1.000 UL\nLT5\n2595 4002 M\n78 -34 V\n-45 -28 V\n-78 32 V\n45 30
      V\n.8857 g 2673 3968 N 45 27 79 -31 -45 -28 h\n1.000 UP\n1.000
      UL\nLT5\n2673 3968 M\n79 -32 V\n-45 -27 V\n-79 31 V\n45 28 V\n.8804 g
      2752 3936 N 45 26 78 -28 -45 -27 h\n1.000 UP\n1.000 UL\nLT5\n2752 3936
      M\n78 -29 V\n-45 -26 V\n-78 28 V\n45 27 V\n.877 g 2830 3907 N 45 25 78
      -25 -45 -26 h\n1.000 UP\n1.000 UL\nLT5\n2830 3907 M\n78 -26 V\n-45 -25
      V\n-78 25 V\n45 26 V\n.8759 g 2908 3881 N 45 25 78 -22 -45 -25 h\n1.000
      UP\n1.000 UL\nLT5\n2908 3881 M\n78 -22 V\n-45 -25 V\n-78 22 V\n45 25
      V\n.877 g 2986 3859 N 45 26 78 -19 -45 -25 h\n1.000 UP\n1.000
      UL\nLT5\n2986 3859 M\n78 -18 V\n-45 -26 V\n-78 19 V\n45 25 V\n.8804 g
      3064 3841 N 45 27 78 -16 -45 -26 h\n1.000 UP\n1.000 UL\nLT5\n3064 3841
      M\n78 -15 V\n-45 -27 V\n-78 16 V\n45 26 V\n.8857 g 3142 3826 N 45 28 78
      -13 -45 -27 h\n1.000 UP\n1.000 UL\nLT5\n3142 3826 M\n78 -12 V\n-45 -28
      V\n-78 13 V\n45 27 V\n.8926 g 3220 3814 N 45 29 78 -12 -45 -28 h\n1.000
      UP\n1.000 UL\nLT5\n3220 3814 M\n78 -11 V\n-45 -29 V\n-78 12 V\n45 28
      V\n.9005 g 3298 3803 N 45 31 78 -11 -45 -29 h\n1.000 UP\n1.000
      UL\nLT5\n3298 3803 M\n78 -9 V\n-45 -31 V\n-78 11 V\n45 29 V\n.9083 g
      3376 3794 N 45 32 78 -11 -45 -31 h\n1.000 UP\n1.000 UL\nLT5\n3376 3794
      M\n78 -10 V\n-45 -32 V\n-78 11 V\n45 31 V\n.915 g 3454 3784 N 46 32 78
      -14 -45 -32 h\n1.000 UP\n1.000 UL\nLT5\n3454 3784 M\n79 -14 V\n-46 -32
      V\n-78 14 V\n45 32 V\n.9187 g 3533 3770 N 45 32 79 -19 -46 -32 h\n1.000
      UP\n1.000 UL\nLT5\n3533 3770 M\n78 -19 V\n-45 -32 V\n-79 19 V\n46 32
      V\n.9171 g 3611 3751 N 45 31 78 -29 -45 -32 h\n1.000 UP\n1.000
      UL\nLT5\n3611 3751 M\n78 -30 V\n-45 -31 V\n-78 29 V\n45 32 V\n.9074 g
      3689 3721 N 45 27 78 -42 -45 -31 h\n1.000 UP\n1.000 UL\nLT5\n3689 3721
      M\n78 -46 V\n-45 -27 V\n-78 42 V\n45 31 V\n.8855 g 3767 3675 N 45 22 78
      -62 -45 -27 h\n1.000 UP\n1.000 UL\nLT5\n3767 3675 M\n78 -67 V\n-45 -22
      V\n-78 62 V\n45 27 V\n.8468 g 3845 3608 N 45 14 78 -90 -45 -22 h\n1.000
      UP\n1.000 UL\nLT5\n3845 3608 M\n78 -98 V\n-45 -14 V\n-78 90 V\n45 22
      V\n.7851 g 3923 3510 N 45 3 78 -127 -45 -14 h\n1.000 UP\n1.000
      UL\nLT5\n3923 3510 M\n78 -138 V\n-45 -3 V\n-78 127 V\n45 14 V\n.6931 g
      4001 3372 N 45 -12 78 -176 -45 -3 h\n1.000 UP\n1.000 UL\nLT5\n4001 3372
      M\n78 -191 V\n-45 12 V\n-78 176 V\n45 3 V\n.7149 g 1769 3832 N 45 21 78
      121 -45 -10 h\n1.000 UP\n1.000 UL\nLT5\n1769 3832 M\n78 132 V\n-45 -21
      V\n-78 -121 V\n45 10 V\n.7993 g 1847 3964 N 45 30 79 74 -45 -21
      h\n1.000 UP\n1.000 UL\nLT5\n1847 3964 M\n79 83 V\n-45 -30 V\n-79 -74
      V\n45 21 V\n.8554 g 1926 4047 N 45 35 78 41 -45 -30 h\n1.000 UP\n1.000
      UL\nLT5\n1926 4047 M\n78 46 V\n-45 -35 V\n-78 -41 V\n45 30 V\n.8905 g
      2004 4093 N 45 39 78 14 -45 -35 h\n1.000 UP\n1.000 UL\nLT5\n2004 4093
      M\n78 18 V\n-45 -39 V\n-78 -14 V\n45 35 V\n.91 g 2082 4111 N 45 40 78
      -3 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2082 4111 M\n78 -2 V\n-45 -40
      V\n-78 3 V\n45 39 V\n.9187 g 2160 4109 N 45 41 78 -16 -45 -40 h\n1.000
      UP\n1.000 UL\nLT5\n2160 4109 M\n78 -15 V\n-45 -41 V\n-78 16 V\n45 40
      V\n.92 g 2238 4094 N 45 40 78 -24 -45 -41 h\n1.000 UP\n1.000
      UL\nLT5\n2238 4094 M\n78 -25 V\n-45 -40 V\n-78 24 V\n45 41 V\n.9166 g
      2316 4069 N 45 39 78 -29 -45 -40 h\n1.000 UP\n1.000 UL\nLT5\n2316 4069
      M\n78 -30 V\n-45 -39 V\n-78 29 V\n45 40 V\n.9107 g 2394 4039 N 45 38 78
      -32 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2394 4039 M\n78 -33 V\n-45 -38
      V\n-78 32 V\n45 39 V\n.9038 g 2472 4006 N 45 35 78 -31 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n2472 4006 M\n78 -34 V\n-45 -35 V\n-78 31 V\n45 38
      V\n.8969 g 2550 3972 N 45 34 78 -31 -45 -35 h\n1.000 UP\n1.000
      UL\nLT5\n2550 3972 M\n78 -32 V\n-45 -34 V\n-78 31 V\n45 35 V\n.891 g
      2628 3940 N 46 33 78 -30 -45 -34 h\n1.000 UP\n1.000 UL\nLT5\n2628 3940
      M\n79 -31 V\n-46 -33 V\n-78 30 V\n45 34 V\n.8864 g 2707 3909 N 45 32 79
      -27 -46 -33 h\n1.000 UP\n1.000 UL\nLT5\n2707 3909 M\n78 -28 V\n-45 -32
      V\n-79 27 V\n46 33 V\n.8835 g 2785 3881 N 45 31 78 -24 -45 -32 h\n1.000
      UP\n1.000 UL\nLT5\n2785 3881 M\n78 -25 V\n-45 -31 V\n-78 24 V\n45 32
      V\n.8825 g 2863 3856 N 45 31 78 -22 -45 -31 h\n1.000 UP\n1.000
      UL\nLT5\n2863 3856 M\n78 -22 V\n-45 -31 V\n-78 22 V\n45 31 V\n.8835 g
      2941 3834 N 45 32 78 -20 -45 -31 h\n1.000 UP\n1.000 UL\nLT5\n2941 3834
      M\n78 -19 V\n-45 -32 V\n-78 20 V\n45 31 V\n.8864 g 3019 3815 N 45 33 78
      -17 -45 -32 h\n1.000 UP\n1.000 UL\nLT5\n3019 3815 M\n78 -16 V\n-45 -33
      V\n-78 17 V\n45 32 V\n.891 g 3097 3799 N 45 35 78 -15 -45 -33 h\n1.000
      UP\n1.000 UL\nLT5\n3097 3799 M\n78 -13 V\n-45 -35 V\n-78 15 V\n45 33
      V\n.8969 g 3175 3786 N 45 36 78 -13 -45 -35 h\n1.000 UP\n1.000
      UL\nLT5\n3175 3786 M\n78 -12 V\n-45 -36 V\n-78 13 V\n45 35 V\n.9038 g
      3253 3774 N 45 37 78 -12 -45 -36 h\n1.000 UP\n1.000 UL\nLT5\n3253 3774
      M\n78 -11 V\n-45 -37 V\n-78 12 V\n45 36 V\n.9107 g 3331 3763 N 45 39 78
      -13 -45 -37 h\n1.000 UP\n1.000 UL\nLT5\n3331 3763 M\n78 -11 V\n-45 -39
      V\n-78 13 V\n45 37 V\n.9166 g 3409 3752 N 45 40 78 -15 -45 -39 h\n1.000
      UP\n1.000 UL\nLT5\n3409 3752 M\n78 -14 V\n-45 -40 V\n-78 15 V\n45 39
      V\n.92 g 3487 3738 N 46 41 78 -20 -45 -40 h\n1.000 UP\n1.000
      UL\nLT5\n3487 3738 M\n79 -19 V\n-46 -41 V\n-78 20 V\n45 40 V\n.9187 g
      3566 3719 N 45 40 79 -28 -46 -41 h\n1.000 UP\n1.000 UL\nLT5\n3566 3719
      M\n78 -29 V\n-45 -40 V\n-79 28 V\n46 41 V\n.91 g 3644 3690 N 45 39 78
      -41 -45 -40 h\n1.000 UP\n1.000 UL\nLT5\n3644 3690 M\n78 -42 V\n-45 -39
      V\n-78 41 V\n45 40 V\n.8905 g 3722 3648 N 45 36 78 -59 -45 -39 h\n1.000
      UP\n1.000 UL\nLT5\n3722 3648 M\n78 -62 V\n-45 -36 V\n-78 59 V\n45 39
      V\n.8554 g 3800 3586 N 45 30 78 -84 -45 -36 h\n1.000 UP\n1.000
      UL\nLT5\n3800 3586 M\n78 -90 V\n-45 -30 V\n-78 84 V\n45 36 V\n.7993 g
      3878 3496 N 45 22 78 -119 -45 -30 h\n1.000 UP\n1.000 UL\nLT5\n3878 3496
      M\n78 -127 V\n-45 -22 V\n-78 119 V\n45 30 V\n.7149 g 3956 3369 N 45 10
      78 -164 -45 -22 h\n1.000 UP\n1.000 UL\nLT5\n3956 3369 M\n78 -176 V\n-45
      -10 V\n-78 164 V\n45 22 V\n.7251 g 1724 3822 N 45 35 78 112 -45 -26
      h\n1.000 UP\n1.000 UL\nLT5\n1724 3822 M\n78 121 V\n-45 -35 V\n-78 -112
      V\n45 26 V\n.8037 g 1802 3943 N 46 40 78 69 -45 -35 h\n1.000 UP\n1.000
      UL\nLT5\n1802 3943 M\n79 74 V\n-46 -40 V\n-78 -69 V\n45 35 V\n.8558 g
      1881 4017 N 45 45 79 36 -46 -40 h\n1.000 UP\n1.000 UL\nLT5\n1881 4017
      M\n78 41 V\n-45 -45 V\n-79 -36 V\n46 40 V\n.8884 g 1959 4058 N 45 46 78
      13 -45 -45 h\n1.000 UP\n1.000 UL\nLT5\n1959 4058 M\n78 14 V\n-45 -46
      V\n-78 -13 V\n45 45 V\n.9067 g 2037 4072 N 45 47 78 -4 -45 -46 h\n1.000
      UP\n1.000 UL\nLT5\n2037 4072 M\n78 -3 V\n-45 -47 V\n-78 4 V\n45 46
      V\n.915 g 2115 4069 N 45 47 78 -16 -45 -47 h\n1.000 UP\n1.000
      UL\nLT5\n2115 4069 M\n78 -16 V\n-45 -47 V\n-78 16 V\n45 47 V\n.9166 g
      2193 4053 N 45 45 78 -22 -45 -47 h\n1.000 UP\n1.000 UL\nLT5\n2193 4053
      M\n78 -24 V\n-45 -45 V\n-78 22 V\n45 47 V\n.9141 g 2271 4029 N 45 44 78
      -28 -45 -45 h\n1.000 UP\n1.000 UL\nLT5\n2271 4029 M\n78 -29 V\n-45 -44
      V\n-78 28 V\n45 45 V\n.9093 g 2349 4000 N 45 41 78 -29 -45 -44 h\n1.000
      UP\n1.000 UL\nLT5\n2349 4000 M\n78 -32 V\n-45 -41 V\n-78 29 V\n45 44
      V\n.9036 g 2427 3968 N 45 40 78 -30 -45 -41 h\n1.000 UP\n1.000
      UL\nLT5\n2427 3968 M\n78 -31 V\n-45 -40 V\n-78 30 V\n45 41 V\n.898 g
      2505 3937 N 45 38 78 -29 -45 -40 h\n1.000 UP\n1.000 UL\nLT5\n2505 3937
      M\n78 -31 V\n-45 -38 V\n-78 29 V\n45 40 V\n.893 g 2583 3906 N 45 36 78
      -28 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2583 3906 M\n78 -30 V\n-45 -36
      V\n-78 28 V\n45 38 V\n.8892 g 2661 3876 N 46 35 78 -26 -45 -36 h\n1.000
      UP\n1.000 UL\nLT5\n2661 3876 M\n79 -27 V\n-46 -35 V\n-78 26 V\n45 36
      V\n.8869 g 2740 3849 N 45 35 79 -24 -46 -35 h\n1.000 UP\n1.000
      UL\nLT5\n2740 3849 M\n78 -24 V\n-45 -35 V\n-79 24 V\n46 35 V\n.8861 g
      2818 3825 N 45 35 78 -22 -45 -35 h\n1.000 UP\n1.000 UL\nLT5\n2818 3825
      M\n78 -22 V\n-45 -35 V\n-78 22 V\n45 35 V\n.8869 g 2896 3803 N 45 35 78
      -20 -45 -35 h\n1.000 UP\n1.000 UL\nLT5\n2896 3803 M\n78 -20 V\n-45 -35
      V\n-78 20 V\n45 35 V\n.8892 g 2974 3783 N 45 36 78 -18 -45 -35 h\n1.000
      UP\n1.000 UL\nLT5\n2974 3783 M\n78 -17 V\n-45 -36 V\n-78 18 V\n45 35
      V\n.893 g 3052 3766 N 45 37 78 -16 -45 -36 h\n1.000 UP\n1.000
      UL\nLT5\n3052 3766 M\n78 -15 V\n-45 -37 V\n-78 16 V\n45 36 V\n.898 g
      3130 3751 N 45 39 78 -15 -45 -37 h\n1.000 UP\n1.000 UL\nLT5\n3130 3751
      M\n78 -13 V\n-45 -39 V\n-78 15 V\n45 37 V\n.9036 g 3208 3738 N 45 41 78
      -14 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n3208 3738 M\n78 -12 V\n-45 -41
      V\n-78 14 V\n45 39 V\n.9093 g 3286 3726 N 45 43 78 -15 -45 -41 h\n1.000
      UP\n1.000 UL\nLT5\n3286 3726 M\n78 -13 V\n-45 -43 V\n-78 15 V\n45 41
      V\n.9141 g 3364 3713 N 45 45 78 -17 -45 -43 h\n1.000 UP\n1.000
      UL\nLT5\n3364 3713 M\n78 -15 V\n-45 -45 V\n-78 17 V\n45 43 V\n.9166 g
      3442 3698 N 45 46 78 -21 -45 -45 h\n1.000 UP\n1.000 UL\nLT5\n3442 3698
      M\n78 -20 V\n-45 -46 V\n-78 21 V\n45 45 V\n.915 g 3520 3678 N 46 47 78
      -29 -45 -46 h\n1.000 UP\n1.000 UL\nLT5\n3520 3678 M\n79 -28 V\n-46 -47
      V\n-78 29 V\n45 46 V\n.9067 g 3599 3650 N 45 46 79 -40 -46 -47 h\n1.000
      UP\n1.000 UL\nLT5\n3599 3650 M\n78 -41 V\n-45 -46 V\n-79 40 V\n46 47
      V\n.8884 g 3677 3609 N 45 44 78 -57 -45 -46 h\n1.000 UP\n1.000
      UL\nLT5\n3677 3609 M\n78 -59 V\n-45 -44 V\n-78 57 V\n45 46 V\n.8558 g
      3755 3550 N 45 40 78 -80 -45 -44 h\n1.000 UP\n1.000 UL\nLT5\n3755 3550
      M\n78 -84 V\n-45 -40 V\n-78 80 V\n45 44 V\n.8037 g 3833 3466 N 45 34 78
      -113 -45 -40 h\n1.000 UP\n1.000 UL\nLT5\n3833 3466 M\n78 -119 V\n-45
      -34 V\n-78 113 V\n45 40 V\n.7251 g 3911 3347 N 45 26 78 -156 -45 -34
      h\n1.000 UP\n1.000 UL\nLT5\n3911 3347 M\n78 -164 V\n-45 -26 V\n-78 156
      V\n45 34 V\n.7276 g 1679 3796 N 45 42 78 105 -45 -35 h\n1.000 UP\n1.000
      UL\nLT5\n1679 3796 M\n78 112 V\n-45 -42 V\n-78 -105 V\n45 35 V\n.8017 g
      1757 3908 N 45 47 78 64 -45 -42 h\n1.000 UP\n1.000 UL\nLT5\n1757 3908
      M\n78 69 V\n-45 -47 V\n-78 -64 V\n45 42 V\n.8511 g 1835 3977 N 46 49 78
      34 -45 -47 h\n1.000 UP\n1.000 UL\nLT5\n1835 3977 M\n79 36 V\n-46 -49
      V\n-78 -34 V\n45 47 V\n.8821 g 1914 4013 N 45 50 79 12 -46 -49 h\n1.000
      UP\n1.000 UL\nLT5\n1914 4013 M\n78 13 V\n-45 -50 V\n-79 -12 V\n46 49
      V\n.8998 g 1992 4026 N 45 50 78 -4 -45 -50 h\n1.000 UP\n1.000
      UL\nLT5\n1992 4026 M\n78 -4 V\n-45 -50 V\n-78 4 V\n45 50 V\n.9083 g
      2070 4022 N 45 49 78 -15 -45 -50 h\n1.000 UP\n1.000 UL\nLT5\n2070 4022
      M\n78 -16 V\n-45 -49 V\n-78 15 V\n45 50 V\n.9107 g 2148 4006 N 45 48 78
      -21 -45 -49 h\n1.000 UP\n1.000 UL\nLT5\n2148 4006 M\n78 -22 V\n-45 -48
      V\n-78 21 V\n45 49 V\n.9093 g 2226 3984 N 45 45 78 -25 -45 -48 h\n1.000
      UP\n1.000 UL\nLT5\n2226 3984 M\n78 -28 V\n-45 -45 V\n-78 25 V\n45 48
      V\n.9058 g 2304 3956 N 45 43 78 -27 -45 -45 h\n1.000 UP\n1.000
      UL\nLT5\n2304 3956 M\n78 -29 V\n-45 -43 V\n-78 27 V\n45 45 V\n.9015 g
      2382 3927 N 45 41 78 -28 -45 -43 h\n1.000 UP\n1.000 UL\nLT5\n2382 3927
      M\n78 -30 V\n-45 -41 V\n-78 28 V\n45 43 V\n.8971 g 2460 3897 N 45 39 78
      -27 -45 -41 h\n1.000 UP\n1.000 UL\nLT5\n2460 3897 M\n78 -29 V\n-45 -39
      V\n-78 27 V\n45 41 V\n.8932 g 2538 3868 N 45 38 78 -27 -45 -39 h\n1.000
      UP\n1.000 UL\nLT5\n2538 3868 M\n78 -28 V\n-45 -38 V\n-78 27 V\n45 39
      V\n.8903 g 2616 3840 N 45 37 78 -25 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2616 3840 M\n78 -26 V\n-45 -37 V\n-78 25 V\n45 38 V\n.8884 g
      2694 3814 N 46 37 78 -24 -45 -37 h\n1.000 UP\n1.000 UL\nLT5\n2694 3814
      M\n79 -24 V\n-46 -37 V\n-78 24 V\n45 37 V\n.8878 g 2773 3790 N 45 37 79
      -22 -46 -37 h\n1.000 UP\n1.000 UL\nLT5\n2773 3790 M\n78 -22 V\n-45 -37
      V\n-79 22 V\n46 37 V\n.8884 g 2851 3768 N 45 37 78 -20 -45 -37 h\n1.000
      UP\n1.000 UL\nLT5\n2851 3768 M\n78 -20 V\n-45 -37 V\n-78 20 V\n45 37
      V\n.8903 g 2929 3748 N 45 38 78 -19 -45 -37 h\n1.000 UP\n1.000
      UL\nLT5\n2929 3748 M\n78 -18 V\n-45 -38 V\n-78 19 V\n45 37 V\n.8932 g
      3007 3730 N 45 40 78 -18 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n3007 3730
      M\n78 -16 V\n-45 -40 V\n-78 18 V\n45 38 V\n.8971 g 3085 3714 N 45 41 78
      -16 -45 -40 h\n1.000 UP\n1.000 UL\nLT5\n3085 3714 M\n78 -15 V\n-45 -41
      V\n-78 16 V\n45 40 V\n.9015 g 3163 3699 N 45 44 78 -17 -45 -41 h\n1.000
      UP\n1.000 UL\nLT5\n3163 3699 M\n78 -14 V\n-45 -44 V\n-78 17 V\n45 41
      V\n.9058 g 3241 3685 N 45 46 78 -17 -45 -44 h\n1.000 UP\n1.000
      UL\nLT5\n3241 3685 M\n78 -15 V\n-45 -46 V\n-78 17 V\n45 44 V\n.9093 g
      3319 3670 N 45 48 78 -19 -45 -46 h\n1.000 UP\n1.000 UL\nLT5\n3319 3670
      M\n78 -17 V\n-45 -48 V\n-78 19 V\n45 46 V\n.9107 g 3397 3653 N 45 49 78
      -22 -45 -48 h\n1.000 UP\n1.000 UL\nLT5\n3397 3653 M\n78 -21 V\n-45 -49
      V\n-78 22 V\n45 48 V\n.9083 g 3475 3632 N 45 50 78 -30 -45 -49 h\n1.000
      UP\n1.000 UL\nLT5\n3475 3632 M\n78 -29 V\n-45 -50 V\n-78 30 V\n45 49
      V\n.8998 g 3553 3603 N 46 50 78 -40 -45 -50 h\n1.000 UP\n1.000
      UL\nLT5\n3553 3603 M\n79 -40 V\n-46 -50 V\n-78 40 V\n45 50 V\n.8821 g
      3632 3563 N 45 49 79 -56 -46 -50 h\n1.000 UP\n1.000 UL\nLT5\n3632 3563
      M\n78 -57 V\n-45 -49 V\n-79 56 V\n46 50 V\n.8511 g 3710 3506 N 45 47 78
      -78 -45 -49 h\n1.000 UP\n1.000 UL\nLT5\n3710 3506 M\n78 -80 V\n-45 -47
      V\n-78 78 V\n45 49 V\n.8017 g 3788 3426 N 45 43 78 -109 -45 -47
      h\n1.000 UP\n1.000 UL\nLT5\n3788 3426 M\n78 -113 V\n-45 -43 V\n-78 109
      V\n45 47 V\n.7276 g 3866 3313 N 45 36 78 -149 -45 -43 h\n1.000
      UP\n1.000 UL\nLT5\n3866 3313 M\n78 -156 V\n-45 -36 V\n-78 149 V\n45 43
      V\n.7252 g 1634 3761 N 45 47 78 100 -45 -42 h\n1.000 UP\n1.000
      UL\nLT5\n1634 3761 M\n78 105 V\n-45 -47 V\n-78 -100 V\n45 42 V\n.7962 g
      1712 3866 N 45 50 78 61 -45 -47 h\n1.000 UP\n1.000 UL\nLT5\n1712 3866
      M\n78 64 V\n-45 -50 V\n-78 -61 V\n45 47 V\n.8436 g 1790 3930 N 45 51 78
      33 -45 -50 h\n1.000 UP\n1.000 UL\nLT5\n1790 3930 M\n78 34 V\n-45 -51
      V\n-78 -33 V\n45 50 V\n.8737 g 1868 3964 N 46 52 78 11 -45 -51 h\n1.000
      UP\n1.000 UL\nLT5\n1868 3964 M\n79 12 V\n-46 -52 V\n-78 -11 V\n45 51
      V\n.8914 g 1947 3976 N 45 51 79 -3 -46 -52 h\n1.000 UP\n1.000
      UL\nLT5\n1947 3976 M\n78 -4 V\n-45 -51 V\n-79 3 V\n46 52 V\n.9005 g
      2025 3972 N 45 49 78 -13 -45 -51 h\n1.000 UP\n1.000 UL\nLT5\n2025 3972
      M\n78 -15 V\n-45 -49 V\n-78 13 V\n45 51 V\n.9038 g 2103 3957 N 45 48 78
      -20 -45 -49 h\n1.000 UP\n1.000 UL\nLT5\n2103 3957 M\n78 -21 V\n-45 -48
      V\n-78 20 V\n45 49 V\n.9036 g 2181 3936 N 45 46 78 -23 -45 -48 h\n1.000
      UP\n1.000 UL\nLT5\n2181 3936 M\n78 -25 V\n-45 -46 V\n-78 23 V\n45 48
      V\n.9015 g 2259 3911 N 45 44 78 -25 -45 -46 h\n1.000 UP\n1.000
      UL\nLT5\n2259 3911 M\n78 -27 V\n-45 -44 V\n-78 25 V\n45 46 V\n.8984 g
      2337 3884 N 45 42 78 -26 -45 -44 h\n1.000 UP\n1.000 UL\nLT5\n2337 3884
      M\n78 -28 V\n-45 -42 V\n-78 26 V\n45 44 V\n.8953 g 2415 3856 N 45 41 78
      -26 -45 -42 h\n1.000 UP\n1.000 UL\nLT5\n2415 3856 M\n78 -27 V\n-45 -41
      V\n-78 26 V\n45 42 V\n.8925 g 2493 3829 N 45 39 78 -25 -45 -41 h\n1.000
      UP\n1.000 UL\nLT5\n2493 3829 M\n78 -27 V\n-45 -39 V\n-78 25 V\n45 41
      V\n.8904 g 2571 3802 N 45 38 78 -24 -45 -39 h\n1.000 UP\n1.000
      UL\nLT5\n2571 3802 M\n78 -25 V\n-45 -38 V\n-78 24 V\n45 39 V\n.889 g
      2649 3777 N 45 37 78 -23 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2649 3777
      M\n78 -24 V\n-45 -37 V\n-78 23 V\n45 38 V\n.8886 g 2727 3753 N 46 37 78
      -22 -45 -37 h\n1.000 UP\n1.000 UL\nLT5\n2727 3753 M\n79 -22 V\n-46 -37
      V\n-78 22 V\n45 37 V\n.889 g 2806 3731 N 45 38 79 -21 -46 -37 h\n1.000
      UP\n1.000 UL\nLT5\n2806 3731 M\n78 -20 V\n-45 -38 V\n-79 21 V\n46 37
      V\n.8904 g 2884 3711 N 45 39 78 -20 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2884 3711 M\n78 -19 V\n-45 -39 V\n-78 20 V\n45 38 V\n.8925 g
      2962 3692 N 45 40 78 -19 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2962 3692
      M\n78 -18 V\n-45 -40 V\n-78 19 V\n45 39 V\n.8953 g 3040 3674 N 45 42 78
      -18 -45 -40 h\n1.000 UP\n1.000 UL\nLT5\n3040 3674 M\n78 -16 V\n-45 -42
      V\n-78 18 V\n45 40 V\n.8984 g 3118 3658 N 45 44 78 -19 -45 -42 h\n1.000
      UP\n1.000 UL\nLT5\n3118 3658 M\n78 -17 V\n-45 -44 V\n-78 19 V\n45 42
      V\n.9015 g 3196 3641 N 45 46 78 -19 -45 -44 h\n1.000 UP\n1.000
      UL\nLT5\n3196 3641 M\n78 -17 V\n-45 -46 V\n-78 19 V\n45 44 V\n.9036 g
      3274 3624 N 45 47 78 -20 -45 -46 h\n1.000 UP\n1.000 UL\nLT5\n3274 3624
      M\n78 -19 V\n-45 -47 V\n-78 20 V\n45 46 V\n.9038 g 3352 3605 N 45 50 78
      -25 -45 -47 h\n1.000 UP\n1.000 UL\nLT5\n3352 3605 M\n78 -22 V\n-45 -50
      V\n-78 25 V\n45 47 V\n.9005 g 3430 3583 N 45 51 78 -31 -45 -50 h\n1.000
      UP\n1.000 UL\nLT5\n3430 3583 M\n78 -30 V\n-45 -51 V\n-78 31 V\n45 50
      V\n.8914 g 3508 3553 N 45 52 78 -41 -45 -51 h\n1.000 UP\n1.000
      UL\nLT5\n3508 3553 M\n78 -40 V\n-45 -52 V\n-78 41 V\n45 51 V\n.8737 g
      3586 3513 N 46 51 78 -55 -45 -52 h\n1.000 UP\n1.000 UL\nLT5\n3586 3513
      M\n79 -56 V\n-46 -51 V\n-78 55 V\n45 52 V\n.8436 g 3665 3457 N 45 50 79
      -77 -46 -51 h\n1.000 UP\n1.000 UL\nLT5\n3665 3457 M\n78 -78 V\n-45 -50
      V\n-79 77 V\n46 51 V\n.7962 g 3743 3379 N 45 46 78 -105 -45 -50
      h\n1.000 UP\n1.000 UL\nLT5\n3743 3379 M\n78 -109 V\n-45 -46 V\n-78 105
      V\n45 50 V\n.7252 g 3821 3270 N 45 42 78 -145 -45 -46 h\n1.000
      UP\n1.000 UL\nLT5\n3821 3270 M\n78 -149 V\n-45 -42 V\n-78 145 V\n45 46
      V\n.7204 g 1589 3719 N 45 48 78 97 -45 -45 h\n1.000 UP\n1.000
      UL\nLT5\n1589 3719 M\n78 100 V\n-45 -48 V\n-78 -97 V\n45 45 V\n.7891 g
      1667 3819 N 45 50 78 59 -45 -48 h\n1.000 UP\n1.000 UL\nLT5\n1667 3819
      M\n78 61 V\n-45 -50 V\n-78 -59 V\n45 48 V\n.8353 g 1745 3880 N 45 51 78
      32 -45 -50 h\n1.000 UP\n1.000 UL\nLT5\n1745 3880 M\n78 33 V\n-45 -51
      V\n-78 -32 V\n45 50 V\n.865 g 1823 3913 N 45 51 78 11 -45 -51 h\n1.000
      UP\n1.000 UL\nLT5\n1823 3913 M\n78 11 V\n-45 -51 V\n-78 -11 V\n45 51
      V\n.8829 g 1901 3924 N 46 50 78 -2 -45 -51 h\n1.000 UP\n1.000
      UL\nLT5\n1901 3924 M\n79 -3 V\n-46 -50 V\n-78 2 V\n45 51 V\n.8926 g
      1980 3921 N 45 49 79 -12 -46 -50 h\n1.000 UP\n1.000 UL\nLT5\n1980 3921
      M\n78 -13 V\n-45 -49 V\n-79 12 V\n46 50 V\n.8969 g 2058 3908 N 45 47 78
      -18 -45 -49 h\n1.000 UP\n1.000 UL\nLT5\n2058 3908 M\n78 -20 V\n-45 -47
      V\n-78 18 V\n45 49 V\n.898 g 2136 3888 N 45 45 78 -21 -45 -47 h\n1.000
      UP\n1.000 UL\nLT5\n2136 3888 M\n78 -23 V\n-45 -45 V\n-78 21 V\n45 47
      V\n.8971 g 2214 3865 N 45 44 78 -24 -45 -45 h\n1.000 UP\n1.000
      UL\nLT5\n2214 3865 M\n78 -25 V\n-45 -44 V\n-78 24 V\n45 45 V\n.8953 g
      2292 3840 N 45 42 78 -24 -45 -44 h\n1.000 UP\n1.000 UL\nLT5\n2292 3840
      M\n78 -26 V\n-45 -42 V\n-78 24 V\n45 44 V\n.8933 g 2370 3814 N 45 40 78
      -24 -45 -42 h\n1.000 UP\n1.000 UL\nLT5\n2370 3814 M\n78 -26 V\n-45 -40
      V\n-78 24 V\n45 42 V\n.8915 g 2448 3788 N 45 39 78 -24 -45 -40 h\n1.000
      UP\n1.000 UL\nLT5\n2448 3788 M\n78 -25 V\n-45 -39 V\n-78 24 V\n45 40
      V\n.89 g 2526 3763 N 45 38 78 -23 -45 -39 h\n1.000 UP\n1.000
      UL\nLT5\n2526 3763 M\n78 -24 V\n-45 -38 V\n-78 23 V\n45 39 V\n.8891 g
      2604 3739 N 45 38 78 -23 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2604 3739
      M\n78 -23 V\n-45 -38 V\n-78 23 V\n45 38 V\n.8888 g 2682 3716 N 45 38 78
      -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2682 3716 M\n78 -22 V\n-45 -38
      V\n-78 22 V\n45 38 V\n.8891 g 2760 3694 N 46 39 78 -22 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n2760 3694 M\n79 -21 V\n-46 -39 V\n-78 22 V\n45 38
      V\n.89 g 2839 3673 N 45 39 79 -20 -46 -39 h\n1.000 UP\n1.000
      UL\nLT5\n2839 3673 M\n78 -20 V\n-45 -39 V\n-79 20 V\n46 39 V\n.8915 g
      2917 3653 N 45 41 78 -21 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2917 3653
      M\n78 -19 V\n-45 -41 V\n-78 21 V\n45 39 V\n.8933 g 2995 3634 N 45 42 78
      -19 -45 -41 h\n1.000 UP\n1.000 UL\nLT5\n2995 3634 M\n78 -18 V\n-45 -42
      V\n-78 19 V\n45 41 V\n.8953 g 3073 3616 N 45 43 78 -20 -45 -42 h\n1.000
      UP\n1.000 UL\nLT5\n3073 3616 M\n78 -19 V\n-45 -43 V\n-78 20 V\n45 42
      V\n.8971 g 3151 3597 N 45 45 78 -21 -45 -43 h\n1.000 UP\n1.000
      UL\nLT5\n3151 3597 M\n78 -19 V\n-45 -45 V\n-78 21 V\n45 43 V\n.898 g
      3229 3578 N 45 48 78 -23 -45 -45 h\n1.000 UP\n1.000 UL\nLT5\n3229 3578
      M\n78 -20 V\n-45 -48 V\n-78 23 V\n45 45 V\n.8969 g 3307 3558 N 45 49 78
      -26 -45 -48 h\n1.000 UP\n1.000 UL\nLT5\n3307 3558 M\n78 -25 V\n-45 -49
      V\n-78 26 V\n45 48 V\n.8926 g 3385 3533 N 45 50 78 -32 -45 -49 h\n1.000
      UP\n1.000 UL\nLT5\n3385 3533 M\n78 -31 V\n-45 -50 V\n-78 32 V\n45 49
      V\n.8829 g 3463 3502 N 45 51 78 -42 -45 -50 h\n1.000 UP\n1.000
      UL\nLT5\n3463 3502 M\n78 -41 V\n-45 -51 V\n-78 42 V\n45 50 V\n.865 g
      3541 3461 N 45 51 78 -55 -45 -51 h\n1.000 UP\n1.000 UL\nLT5\n3541 3461
      M\n78 -55 V\n-45 -51 V\n-78 55 V\n45 51 V\n.8353 g 3619 3406 N 46 50 78
      -76 -45 -51 h\n1.000 UP\n1.000 UL\nLT5\n3619 3406 M\n79 -77 V\n-46 -50
      V\n-78 76 V\n45 51 V\n.7891 g 3698 3329 N 45 48 79 -103 -46 -50
      h\n1.000 UP\n1.000 UL\nLT5\n3698 3329 M\n78 -105 V\n-45 -48 V\n-79 103
      V\n46 50 V\n.7204 g 3776 3224 N 45 44 78 -141 -45 -48 h\n1.000
      UP\n1.000 UL\nLT5\n3776 3224 M\n78 -145 V\n-45 -44 V\n-78 141 V\n45 48
      V\n.7149 g 1544 3674 N 45 47 78 95 -45 -45 h\n1.000 UP\n1.000
      UL\nLT5\n1544 3674 M\n78 97 V\n-45 -47 V\n-78 -95 V\n45 45 V\n.7821 g
      1622 3771 N 45 48 78 58 -45 -47 h\n1.000 UP\n1.000 UL\nLT5\n1622 3771
      M\n78 59 V\n-45 -48 V\n-78 -58 V\n45 47 V\n.8276 g 1700 3830 N 45 49 78
      31 -45 -48 h\n1.000 UP\n1.000 UL\nLT5\n1700 3830 M\n78 32 V\n-45 -49
      V\n-78 -31 V\n45 48 V\n.8571 g 1778 3862 N 45 48 78 12 -45 -49 h\n1.000
      UP\n1.000 UL\nLT5\n1778 3862 M\n78 11 V\n-45 -48 V\n-78 -12 V\n45 49
      V\n.8753 g 1856 3873 N 45 48 78 -2 -45 -48 h\n1.000 UP\n1.000
      UL\nLT5\n1856 3873 M\n78 -2 V\n-45 -48 V\n-78 2 V\n45 48 V\n.8857 g
      1934 3871 N 46 47 78 -11 -45 -48 h\n1.000 UP\n1.000 UL\nLT5\n1934 3871
      M\n79 -12 V\n-46 -47 V\n-78 11 V\n45 48 V\n.891 g 2013 3859 N 45 45 79
      -16 -46 -47 h\n1.000 UP\n1.000 UL\nLT5\n2013 3859 M\n78 -18 V\n-45 -45
      V\n-79 16 V\n46 47 V\n.893 g 2091 3841 N 45 44 78 -20 -45 -45 h\n1.000
      UP\n1.000 UL\nLT5\n2091 3841 M\n78 -21 V\n-45 -44 V\n-78 20 V\n45 45
      V\n.8932 g 2169 3820 N 45 42 78 -22 -45 -44 h\n1.000 UP\n1.000
      UL\nLT5\n2169 3820 M\n78 -24 V\n-45 -42 V\n-78 22 V\n45 44 V\n.8925 g
      2247 3796 N 45 41 78 -23 -45 -42 h\n1.000 UP\n1.000 UL\nLT5\n2247 3796
      M\n78 -24 V\n-45 -41 V\n-78 23 V\n45 42 V\n.8915 g 2325 3772 N 45 40 78
      -23 -45 -41 h\n1.000 UP\n1.000 UL\nLT5\n2325 3772 M\n78 -24 V\n-45 -40
      V\n-78 23 V\n45 41 V\n.8904 g 2403 3748 N 45 39 78 -23 -45 -40 h\n1.000
      UP\n1.000 UL\nLT5\n2403 3748 M\n78 -24 V\n-45 -39 V\n-78 23 V\n45 40
      V\n.8896 g 2481 3724 N 45 39 78 -23 -45 -39 h\n1.000 UP\n1.000
      UL\nLT5\n2481 3724 M\n78 -23 V\n-45 -39 V\n-78 23 V\n45 39 V\n.8891 g
      2559 3701 N 45 38 78 -22 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2559 3701
      M\n78 -23 V\n-45 -38 V\n-78 22 V\n45 39 V\n.8889 g 2637 3678 N 45 38 78
      -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2637 3678 M\n78 -22 V\n-45 -38
      V\n-78 22 V\n45 38 V\n.8891 g 2715 3656 N 45 38 78 -22 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n2715 3656 M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38
      V\n.8896 g 2793 3634 N 46 40 78 -22 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2793 3634 M\n79 -20 V\n-46 -40 V\n-78 22 V\n45 38 V\n.8904 g
      2872 3614 N 45 40 79 -21 -46 -40 h\n1.000 UP\n1.000 UL\nLT5\n2872 3614
      M\n78 -21 V\n-45 -40 V\n-79 21 V\n46 40 V\n.8915 g 2950 3593 N 45 42 78
      -21 -45 -40 h\n1.000 UP\n1.000 UL\nLT5\n2950 3593 M\n78 -19 V\n-45 -42
      V\n-78 21 V\n45 40 V\n.8925 g 3028 3574 N 45 43 78 -21 -45 -42 h\n1.000
      UP\n1.000 UL\nLT5\n3028 3574 M\n78 -20 V\n-45 -43 V\n-78 21 V\n45 42
      V\n.8932 g 3106 3554 N 45 44 78 -22 -45 -43 h\n1.000 UP\n1.000
      UL\nLT5\n3106 3554 M\n78 -21 V\n-45 -44 V\n-78 22 V\n45 43 V\n.893 g
      3184 3533 N 45 45 78 -24 -45 -44 h\n1.000 UP\n1.000 UL\nLT5\n3184 3533
      M\n78 -23 V\n-45 -45 V\n-78 24 V\n45 44 V\n.891 g 3262 3510 N 45 47 78
      -28 -45 -45 h\n1.000 UP\n1.000 UL\nLT5\n3262 3510 M\n78 -26 V\n-45 -47
      V\n-78 28 V\n45 45 V\n.8857 g 3340 3484 N 45 48 78 -33 -45 -47 h\n1.000
      UP\n1.000 UL\nLT5\n3340 3484 M\n78 -32 V\n-45 -48 V\n-78 33 V\n45 47
      V\n.8753 g 3418 3452 N 45 48 78 -42 -45 -48 h\n1.000 UP\n1.000
      UL\nLT5\n3418 3452 M\n78 -42 V\n-45 -48 V\n-78 42 V\n45 48 V\n.8571 g
      3496 3410 N 45 49 78 -56 -45 -48 h\n1.000 UP\n1.000 UL\nLT5\n3496 3410
      M\n78 -55 V\n-45 -49 V\n-78 56 V\n45 48 V\n.8276 g 3574 3355 N 45 49 78
      -76 -45 -49 h\n1.000 UP\n1.000 UL\nLT5\n3574 3355 M\n78 -76 V\n-45 -49
      V\n-78 76 V\n45 49 V\n.7821 g 3652 3279 N 46 48 78 -102 -45 -49
      h\n1.000 UP\n1.000 UL\nLT5\n3652 3279 M\n79 -103 V\n-46 -48 V\n-78 102
      V\n45 49 V\n.7149 g 3731 3176 N 45 46 79 -139 -46 -48 h\n1.000
      UP\n1.000 UL\nLT5\n3731 3176 M\n78 -141 V\n-45 -46 V\n-79 139 V\n46 48
      V\n.7101 g 1499 3629 N 45 46 78 93 -45 -44 h\n1.000 UP\n1.000
      UL\nLT5\n1499 3629 M\n78 95 V\n-45 -46 V\n-78 -93 V\n45 44 V\n.7763 g
      1577 3724 N 45 46 78 58 -45 -46 h\n1.000 UP\n1.000 UL\nLT5\n1577 3724
      M\n78 58 V\n-45 -46 V\n-78 -58 V\n45 46 V\n.8213 g 1655 3782 N 45 46 78
      31 -45 -46 h\n1.000 UP\n1.000 UL\nLT5\n1655 3782 M\n78 31 V\n-45 -46
      V\n-78 -31 V\n45 46 V\n.8509 g 1733 3813 N 45 46 78 12 -45 -46 h\n1.000
      UP\n1.000 UL\nLT5\n1733 3813 M\n78 12 V\n-45 -46 V\n-78 -12 V\n45 46
      V\n.8694 g 1811 3825 N 45 45 78 -1 -45 -46 h\n1.000 UP\n1.000
      UL\nLT5\n1811 3825 M\n78 -2 V\n-45 -45 V\n-78 1 V\n45 46 V\n.8804 g
      1889 3823 N 45 44 78 -10 -45 -45 h\n1.000 UP\n1.000 UL\nLT5\n1889 3823
      M\n78 -11 V\n-45 -44 V\n-78 10 V\n45 45 V\n.8864 g 1967 3812 N 46 44 78
      -16 -45 -44 h\n1.000 UP\n1.000 UL\nLT5\n1967 3812 M\n79 -16 V\n-46 -44
      V\n-78 16 V\n45 44 V\n.8892 g 2046 3796 N 45 43 79 -19 -46 -44 h\n1.000
      UP\n1.000 UL\nLT5\n2046 3796 M\n78 -20 V\n-45 -43 V\n-79 19 V\n46 44
      V\n.8903 g 2124 3776 N 45 42 78 -21 -45 -43 h\n1.000 UP\n1.000
      UL\nLT5\n2124 3776 M\n78 -22 V\n-45 -42 V\n-78 21 V\n45 43 V\n.8904 g
      2202 3754 N 45 40 78 -21 -45 -42 h\n1.000 UP\n1.000 UL\nLT5\n2202 3754
      M\n78 -23 V\n-45 -40 V\n-78 21 V\n45 42 V\n.89 g 2280 3731 N 45 40 78
      -23 -45 -40 h\n1.000 UP\n1.000 UL\nLT5\n2280 3731 M\n78 -23 V\n-45 -40
      V\n-78 23 V\n45 40 V\n.8896 g 2358 3708 N 45 39 78 -22 -45 -40 h\n1.000
      UP\n1.000 UL\nLT5\n2358 3708 M\n78 -23 V\n-45 -39 V\n-78 22 V\n45 40
      V\n.8892 g 2436 3685 N 45 38 78 -22 -45 -39 h\n1.000 UP\n1.000
      UL\nLT5\n2436 3685 M\n78 -23 V\n-45 -38 V\n-78 22 V\n45 39 V\n.889 g
      2514 3662 N 45 39 78 -23 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2514 3662
      M\n78 -22 V\n-45 -39 V\n-78 23 V\n45 38 V\n.8889 g 2592 3640 N 45 39 78
      -22 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2592 3640 M\n78 -22 V\n-45 -39
      V\n-78 22 V\n45 39 V\n.889 g 2670 3618 N 45 39 78 -22 -45 -39 h\n1.000
      UP\n1.000 UL\nLT5\n2670 3618 M\n78 -22 V\n-45 -39 V\n-78 22 V\n45 39
      V\n.8892 g 2748 3596 N 45 38 78 -21 -45 -39 h\n1.000 UP\n1.000
      UL\nLT5\n2748 3596 M\n78 -22 V\n-45 -38 V\n-78 21 V\n45 39 V\n.8896 g
      2826 3574 N 46 39 78 -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2826 3574
      M\n79 -21 V\n-46 -39 V\n-78 22 V\n45 38 V\n.89 g 2905 3553 N 45 40 79
      -22 -46 -39 h\n1.000 UP\n1.000 UL\nLT5\n2905 3553 M\n78 -21 V\n-45 -40
      V\n-79 22 V\n46 39 V\n.8904 g 2983 3532 N 45 41 78 -22 -45 -40 h\n1.000
      UP\n1.000 UL\nLT5\n2983 3532 M\n78 -21 V\n-45 -41 V\n-78 22 V\n45 40
      V\n.8903 g 3061 3511 N 45 42 78 -23 -45 -41 h\n1.000 UP\n1.000
      UL\nLT5\n3061 3511 M\n78 -22 V\n-45 -42 V\n-78 23 V\n45 41 V\n.8892 g
      3139 3489 N 45 43 78 -25 -45 -42 h\n1.000 UP\n1.000 UL\nLT5\n3139 3489
      M\n78 -24 V\n-45 -43 V\n-78 25 V\n45 42 V\n.8864 g 3217 3465 N 45 44 78
      -29 -45 -43 h\n1.000 UP\n1.000 UL\nLT5\n3217 3465 M\n78 -28 V\n-45 -44
      V\n-78 29 V\n45 43 V\n.8804 g 3295 3437 N 45 45 78 -34 -45 -44 h\n1.000
      UP\n1.000 UL\nLT5\n3295 3437 M\n78 -33 V\n-45 -45 V\n-78 34 V\n45 44
      V\n.8694 g 3373 3404 N 45 46 78 -43 -45 -45 h\n1.000 UP\n1.000
      UL\nLT5\n3373 3404 M\n78 -42 V\n-45 -46 V\n-78 43 V\n45 45 V\n.8509 g
      3451 3362 N 45 46 78 -56 -45 -46 h\n1.000 UP\n1.000 UL\nLT5\n3451 3362
      M\n78 -56 V\n-45 -46 V\n-78 56 V\n45 46 V\n.8213 g 3529 3306 N 45 45 78
      -75 -45 -46 h\n1.000 UP\n1.000 UL\nLT5\n3529 3306 M\n78 -76 V\n-45 -45
      V\n-78 75 V\n45 46 V\n.7763 g 3607 3230 N 45 45 78 -102 -45 -45
      h\n1.000 UP\n1.000 UL\nLT5\n3607 3230 M\n78 -102 V\n-45 -45 V\n-78 102
      V\n45 45 V\n.7101 g 3685 3128 N 46 43 78 -137 -45 -45 h\n1.000
      UP\n1.000 UL\nLT5\n3685 3128 M\n79 -139 V\n-46 -43 V\n-78 137 V\n45 45
      V\n.7068 g 1454 3585 N 45 41 78 93 -45 -41 h\n1.000 UP\n1.000
      UL\nLT5\n1454 3585 M\n78 93 V\n-45 -41 V\n-78 -93 V\n45 41 V\n.7726 g
      1532 3678 N 45 42 78 57 -45 -41 h\n1.000 UP\n1.000 UL\nLT5\n1532 3678
      M\n78 58 V\n-45 -42 V\n-78 -57 V\n45 41 V\n.8174 g 1610 3736 N 45 42 78
      31 -45 -42 h\n1.000 UP\n1.000 UL\nLT5\n1610 3736 M\n78 31 V\n-45 -42
      V\n-78 -31 V\n45 42 V\n.8469 g 1688 3767 N 45 42 78 12 -45 -42 h\n1.000
      UP\n1.000 UL\nLT5\n1688 3767 M\n78 12 V\n-45 -42 V\n-78 -12 V\n45 42
      V\n.8657 g 1766 3779 N 45 42 78 -1 -45 -42 h\n1.000 UP\n1.000
      UL\nLT5\n1766 3779 M\n78 -1 V\n-45 -42 V\n-78 1 V\n45 42 V\n.877 g 1844
      3778 N 45 41 78 -9 -45 -42 h\n1.000 UP\n1.000 UL\nLT5\n1844 3778 M\n78
      -10 V\n-45 -41 V\n-78 9 V\n45 42 V\n.8835 g 1922 3768 N 45 40 78 -15
      -45 -41 h\n1.000 UP\n1.000 UL\nLT5\n1922 3768 M\n78 -16 V\n-45 -40
      V\n-78 15 V\n45 41 V\n.8869 g 2000 3752 N 46 40 78 -19 -45 -40 h\n1.000
      UP\n1.000 UL\nLT5\n2000 3752 M\n79 -19 V\n-46 -40 V\n-78 19 V\n45 40
      V\n.8884 g 2079 3733 N 45 39 79 -20 -46 -40 h\n1.000 UP\n1.000
      UL\nLT5\n2079 3733 M\n78 -21 V\n-45 -39 V\n-79 20 V\n46 40 V\n.889 g
      2157 3712 N 45 40 78 -22 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2157 3712
      M\n78 -21 V\n-45 -40 V\n-78 22 V\n45 39 V\n.8891 g 2235 3691 N 45 39 78
      -22 -45 -40 h\n1.000 UP\n1.000 UL\nLT5\n2235 3691 M\n78 -23 V\n-45 -39
      V\n-78 22 V\n45 40 V\n.8891 g 2313 3668 N 45 39 78 -22 -45 -39 h\n1.000
      UP\n1.000 UL\nLT5\n2313 3668 M\n78 -22 V\n-45 -39 V\n-78 22 V\n45 39
      V\n.889 g 2391 3646 N 45 39 78 -22 -45 -39 h\n1.000 UP\n1.000
      UL\nLT5\n2391 3646 M\n78 -22 V\n-45 -39 V\n-78 22 V\n45 39 V\n.8889 g
      2469 3624 N 45 38 78 -22 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2469 3624
      M\n78 -23 V\n-45 -38 V\n-78 22 V\n45 39 V\n.8889 g 2547 3601 N 45 38 78
      -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2547 3601 M\n78 -22 V\n-45 -38
      V\n-78 22 V\n45 38 V\n.8889 g 2625 3579 N 45 38 78 -22 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n2625 3579 M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38
      V\n.889 g 2703 3557 N 45 39 78 -22 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2703 3557 M\n78 -21 V\n-45 -39 V\n-78 22 V\n45 38 V\n.8891 g
      2781 3536 N 45 39 78 -22 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2781 3536
      M\n78 -22 V\n-45 -39 V\n-78 22 V\n45 39 V\n.8891 g 2859 3514 N 46 39 78
      -22 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2859 3514 M\n79 -22 V\n-46 -39
      V\n-78 22 V\n45 39 V\n.889 g 2938 3492 N 45 40 79 -23 -46 -39 h\n1.000
      UP\n1.000 UL\nLT5\n2938 3492 M\n78 -22 V\n-45 -40 V\n-79 23 V\n46 39
      V\n.8884 g 3016 3470 N 45 41 78 -24 -45 -40 h\n1.000 UP\n1.000
      UL\nLT5\n3016 3470 M\n78 -23 V\n-45 -41 V\n-78 24 V\n45 40 V\n.8869 g
      3094 3447 N 45 41 78 -25 -45 -41 h\n1.000 UP\n1.000 UL\nLT5\n3094 3447
      M\n78 -25 V\n-45 -41 V\n-78 25 V\n45 41 V\n.8835 g 3172 3422 N 45 41 78
      -29 -45 -41 h\n1.000 UP\n1.000 UL\nLT5\n3172 3422 M\n78 -29 V\n-45 -41
      V\n-78 29 V\n45 41 V\n.877 g 3250 3393 N 45 42 78 -35 -45 -41 h\n1.000
      UP\n1.000 UL\nLT5\n3250 3393 M\n78 -34 V\n-45 -42 V\n-78 35 V\n45 41
      V\n.8657 g 3328 3359 N 45 42 78 -43 -45 -42 h\n1.000 UP\n1.000
      UL\nLT5\n3328 3359 M\n78 -43 V\n-45 -42 V\n-78 43 V\n45 42 V\n.8469 g
      3406 3316 N 45 43 78 -57 -45 -42 h\n1.000 UP\n1.000 UL\nLT5\n3406 3316
      M\n78 -56 V\n-45 -43 V\n-78 57 V\n45 42 V\n.8174 g 3484 3260 N 45 43 78
      -75 -45 -43 h\n1.000 UP\n1.000 UL\nLT5\n3484 3260 M\n78 -75 V\n-45 -43
      V\n-78 75 V\n45 43 V\n.7726 g 3562 3185 N 45 42 78 -101 -45 -43
      h\n1.000 UP\n1.000 UL\nLT5\n3562 3185 M\n78 -102 V\n-45 -42 V\n-78 101
      V\n45 43 V\n.7068 g 3640 3083 N 45 41 78 -136 -45 -42 h\n1.000
      UP\n1.000 UL\nLT5\n3640 3083 M\n78 -137 V\n-45 -41 V\n-78 136 V\n45 42
      V\n.7057 g 1409 3544 N 45 39 78 92 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n1409 3544 M\n78 93 V\n-45 -39 V\n-78 -92 V\n45 38 V\n.7712 g
      1487 3637 N 45 39 78 57 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n1487 3637
      M\n78 57 V\n-45 -39 V\n-78 -57 V\n45 39 V\n.816 g 1565 3694 N 45 39 78
      31 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n1565 3694 M\n78 31 V\n-45 -39
      V\n-78 -31 V\n45 39 V\n.8456 g 1643 3725 N 45 38 78 13 -45 -39 h\n1.000
      UP\n1.000 UL\nLT5\n1643 3725 M\n78 12 V\n-45 -38 V\n-78 -13 V\n45 39
      V\n.8644 g 1721 3737 N 45 38 78 -1 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n1721 3737 M\n78 -1 V\n-45 -38 V\n-78 1 V\n45 38 V\n.8759 g
      1799 3736 N 45 39 78 -10 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n1799 3736
      M\n78 -9 V\n-45 -39 V\n-78 10 V\n45 38 V\n.8825 g 1877 3727 N 45 39 78
      -15 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n1877 3727 M\n78 -15 V\n-45 -39
      V\n-78 15 V\n45 39 V\n.8861 g 1955 3712 N 45 38 78 -18 -45 -39 h\n1.000
      UP\n1.000 UL\nLT5\n1955 3712 M\n78 -19 V\n-45 -38 V\n-78 18 V\n45 39
      V\n.8878 g 2033 3693 N 46 39 78 -21 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2033 3693 M\n79 -20 V\n-46 -39 V\n-78 21 V\n45 38 V\n.8886 g
      2112 3673 N 45 38 79 -21 -46 -39 h\n1.000 UP\n1.000 UL\nLT5\n2112 3673
      M\n78 -22 V\n-45 -38 V\n-79 21 V\n46 39 V\n.8888 g 2190 3651 N 45 38 78
      -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2190 3651 M\n78 -22 V\n-45 -38
      V\n-78 22 V\n45 38 V\n.8889 g 2268 3629 N 45 38 78 -22 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n2268 3629 M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38
      V\n.8889 g 2346 3607 N 45 38 78 -22 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2346 3607 M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38 V\n.8889 g
      2424 3585 N 45 38 78 -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2424 3585
      M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38 V\n.8889 g 2502 3563 N 45 38 78
      -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2502 3563 M\n78 -22 V\n-45 -38
      V\n-78 22 V\n45 38 V\n.8889 g 2580 3541 N 45 38 78 -22 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n2580 3541 M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38
      V\n.8889 g 2658 3519 N 45 38 78 -22 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2658 3519 M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38 V\n.8889 g
      2736 3497 N 45 38 78 -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2736 3497
      M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38 V\n.8888 g 2814 3475 N 45 38 78
      -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2814 3475 M\n78 -22 V\n-45 -38
      V\n-78 22 V\n45 38 V\n.8886 g 2892 3453 N 46 38 78 -23 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n2892 3453 M\n79 -23 V\n-46 -38 V\n-78 23 V\n45 38
      V\n.8878 g 2971 3430 N 45 38 79 -24 -46 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2971 3430 M\n78 -24 V\n-45 -38 V\n-79 24 V\n46 38 V\n.8861 g
      3049 3406 N 45 38 78 -25 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n3049 3406
      M\n78 -25 V\n-45 -38 V\n-78 25 V\n45 38 V\n.8825 g 3127 3381 N 45 38 78
      -29 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n3127 3381 M\n78 -29 V\n-45 -38
      V\n-78 29 V\n45 38 V\n.8759 g 3205 3352 N 45 38 78 -35 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n3205 3352 M\n78 -35 V\n-45 -38 V\n-78 35 V\n45 38
      V\n.8644 g 3283 3317 N 45 38 78 -43 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n3283 3317 M\n78 -43 V\n-45 -38 V\n-78 43 V\n45 38 V\n.8456 g
      3361 3274 N 45 38 78 -57 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n3361 3274
      M\n78 -57 V\n-45 -38 V\n-78 57 V\n45 38 V\n.816 g 3439 3217 N 45 38 78
      -75 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n3439 3217 M\n78 -75 V\n-45 -38
      V\n-78 75 V\n45 38 V\n.7712 g 3517 3142 N 45 38 78 -101 -45 -38
      h\n1.000 UP\n1.000 UL\nLT5\n3517 3142 M\n78 -101 V\n-45 -38 V\n-78 101
      V\n45 38 V\n.7057 g 3595 3041 N 45 39 78 -137 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n3595 3041 M\n78 -136 V\n-45 -39 V\n-78 137 V\n45 38
      V\n.7068 g 1364 3506 N 45 34 78 93 -45 -35 h\n1.000 UP\n1.000
      UL\nLT5\n1364 3506 M\n78 92 V\n-45 -34 V\n-78 -93 V\n45 35 V\n.7726 g
      1442 3598 N 45 34 78 57 -45 -34 h\n1.000 UP\n1.000 UL\nLT5\n1442 3598
      M\n78 57 V\n-45 -34 V\n-78 -57 V\n45 34 V\n.8174 g 1520 3655 N 45 34 78
      31 -45 -34 h\n1.000 UP\n1.000 UL\nLT5\n1520 3655 M\n78 31 V\n-45 -34
      V\n-78 -31 V\n45 34 V\n.8469 g 1598 3686 N 45 35 78 12 -45 -34 h\n1.000
      UP\n1.000 UL\nLT5\n1598 3686 M\n78 13 V\n-45 -35 V\n-78 -12 V\n45 34
      V\n.8657 g 1676 3699 N 45 35 78 -1 -45 -35 h\n1.000 UP\n1.000
      UL\nLT5\n1676 3699 M\n78 -1 V\n-45 -35 V\n-78 1 V\n45 35 V\n.877 g 1754
      3698 N 45 35 78 -10 -45 -35 h\n1.000 UP\n1.000 UL\nLT5\n1754 3698 M\n78
      -10 V\n-45 -35 V\n-78 10 V\n45 35 V\n.8835 g 1832 3688 N 45 35 78 -15
      -45 -35 h\n1.000 UP\n1.000 UL\nLT5\n1832 3688 M\n78 -15 V\n-45 -35
      V\n-78 15 V\n45 35 V\n.8869 g 1910 3673 N 45 36 78 -19 -45 -35 h\n1.000
      UP\n1.000 UL\nLT5\n1910 3673 M\n78 -18 V\n-45 -36 V\n-78 19 V\n45 35
      V\n.8884 g 1988 3655 N 45 36 78 -21 -45 -36 h\n1.000 UP\n1.000
      UL\nLT5\n1988 3655 M\n78 -21 V\n-45 -36 V\n-78 21 V\n45 36 V\n.889 g
      2066 3634 N 46 37 78 -22 -45 -36 h\n1.000 UP\n1.000 UL\nLT5\n2066 3634
      M\n79 -21 V\n-46 -37 V\n-78 22 V\n45 36 V\n.8891 g 2145 3613 N 45 37 79
      -22 -46 -37 h\n1.000 UP\n1.000 UL\nLT5\n2145 3613 M\n78 -22 V\n-45 -37
      V\n-79 22 V\n46 37 V\n.8891 g 2223 3591 N 45 38 78 -23 -45 -37 h\n1.000
      UP\n1.000 UL\nLT5\n2223 3591 M\n78 -22 V\n-45 -38 V\n-78 23 V\n45 37
      V\n.889 g 2301 3569 N 45 38 78 -22 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2301 3569 M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38 V\n.8889 g
      2379 3547 N 45 38 78 -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2379 3547
      M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38 V\n.8889 g 2457 3525 N 45 38 78
      -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2457 3525 M\n78 -22 V\n-45 -38
      V\n-78 22 V\n45 38 V\n.8889 g 2535 3503 N 45 38 78 -22 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n2535 3503 M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38
      V\n.889 g 2613 3481 N 45 38 78 -22 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2613 3481 M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38 V\n.8891 g
      2691 3459 N 45 38 78 -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2691 3459
      M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38 V\n.8891 g 2769 3437 N 45 38 78
      -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2769 3437 M\n78 -22 V\n-45 -38
      V\n-78 22 V\n45 38 V\n.889 g 2847 3415 N 45 37 78 -22 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n2847 3415 M\n78 -23 V\n-45 -37 V\n-78 22 V\n45 38
      V\n.8884 g 2925 3392 N 46 36 78 -23 -45 -37 h\n1.000 UP\n1.000
      UL\nLT5\n2925 3392 M\n79 -24 V\n-46 -36 V\n-78 23 V\n45 37 V\n.8869 g
      3004 3368 N 45 36 79 -25 -46 -36 h\n1.000 UP\n1.000 UL\nLT5\n3004 3368
      M\n78 -25 V\n-45 -36 V\n-79 25 V\n46 36 V\n.8835 g 3082 3343 N 45 35 78
      -28 -45 -36 h\n1.000 UP\n1.000 UL\nLT5\n3082 3343 M\n78 -29 V\n-45 -35
      V\n-78 28 V\n45 36 V\n.877 g 3160 3314 N 45 35 78 -35 -45 -35 h\n1.000
      UP\n1.000 UL\nLT5\n3160 3314 M\n78 -35 V\n-45 -35 V\n-78 35 V\n45 35
      V\n.8657 g 3238 3279 N 45 35 78 -43 -45 -35 h\n1.000 UP\n1.000
      UL\nLT5\n3238 3279 M\n78 -43 V\n-45 -35 V\n-78 43 V\n45 35 V\n.8469 g
      3316 3236 N 45 34 78 -56 -45 -35 h\n1.000 UP\n1.000 UL\nLT5\n3316 3236
      M\n78 -57 V\n-45 -34 V\n-78 56 V\n45 35 V\n.8174 g 3394 3179 N 45 34 78
      -75 -45 -34 h\n1.000 UP\n1.000 UL\nLT5\n3394 3179 M\n78 -75 V\n-45 -34
      V\n-78 75 V\n45 34 V\n.7726 g 3472 3104 N 45 35 78 -102 -45 -34
      h\n1.000 UP\n1.000 UL\nLT5\n3472 3104 M\n78 -101 V\n-45 -35 V\n-78 102
      V\n45 34 V\n.7068 g 3550 3003 N 45 35 78 -137 -45 -35 h\n1.000
      UP\n1.000 UL\nLT5\n3550 3003 M\n78 -137 V\n-45 -35 V\n-78 137 V\n45 35
      V\n.7101 g 1319 3471 N 45 31 79 95 -46 -33 h\n1.000 UP\n1.000
      UL\nLT5\n1319 3471 M\n78 93 V\n-45 -31 V\n-79 -95 V\n46 33 V\n.7763 g
      1397 3564 N 45 30 78 58 -45 -31 h\n1.000 UP\n1.000 UL\nLT5\n1397 3564
      M\n78 57 V\n-45 -30 V\n-78 -58 V\n45 31 V\n.8213 g 1475 3621 N 45 30 78
      31 -45 -30 h\n1.000 UP\n1.000 UL\nLT5\n1475 3621 M\n78 31 V\n-45 -30
      V\n-78 -31 V\n45 30 V\n.8509 g 1553 3652 N 45 30 78 12 -45 -30 h\n1.000
      UP\n1.000 UL\nLT5\n1553 3652 M\n78 12 V\n-45 -30 V\n-78 -12 V\n45 30
      V\n.8694 g 1631 3664 N 45 31 78 -2 -45 -30 h\n1.000 UP\n1.000
      UL\nLT5\n1631 3664 M\n78 -1 V\n-45 -31 V\n-78 2 V\n45 30 V\n.8804 g
      1709 3663 N 45 32 78 -11 -45 -31 h\n1.000 UP\n1.000 UL\nLT5\n1709 3663
      M\n78 -10 V\n-45 -32 V\n-78 11 V\n45 31 V\n.8864 g 1787 3653 N 45 33 78
      -16 -45 -32 h\n1.000 UP\n1.000 UL\nLT5\n1787 3653 M\n78 -15 V\n-45 -33
      V\n-78 16 V\n45 32 V\n.8892 g 1865 3638 N 45 34 78 -20 -45 -33 h\n1.000
      UP\n1.000 UL\nLT5\n1865 3638 M\n78 -19 V\n-45 -34 V\n-78 20 V\n45 33
      V\n.8903 g 1943 3619 N 45 35 78 -22 -45 -34 h\n1.000 UP\n1.000
      UL\nLT5\n1943 3619 M\n78 -21 V\n-45 -35 V\n-78 22 V\n45 34 V\n.8904 g
      2021 3598 N 45 36 78 -23 -45 -35 h\n1.000 UP\n1.000 UL\nLT5\n2021 3598
      M\n78 -22 V\n-45 -36 V\n-78 23 V\n45 35 V\n.89 g 2099 3576 N 46 37 78
      -23 -45 -36 h\n1.000 UP\n1.000 UL\nLT5\n2099 3576 M\n79 -22 V\n-46 -37
      V\n-78 23 V\n45 36 V\n.8896 g 2178 3554 N 45 37 79 -23 -46 -37 h\n1.000
      UP\n1.000 UL\nLT5\n2178 3554 M\n78 -23 V\n-45 -37 V\n-79 23 V\n46 37
      V\n.8892 g 2256 3531 N 45 38 78 -23 -45 -37 h\n1.000 UP\n1.000
      UL\nLT5\n2256 3531 M\n78 -22 V\n-45 -38 V\n-78 23 V\n45 37 V\n.889 g
      2334 3509 N 45 38 78 -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2334 3509
      M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38 V\n.8889 g 2412 3487 N 45 38 78
      -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2412 3487 M\n78 -22 V\n-45 -38
      V\n-78 22 V\n45 38 V\n.889 g 2490 3465 N 45 38 78 -22 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n2490 3465 M\n78 -22 V\n-45 -38 V\n-78 22 V\n45 38
      V\n.8892 g 2568 3443 N 45 37 78 -21 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2568 3443 M\n78 -22 V\n-45 -37 V\n-78 21 V\n45 38 V\n.8896 g
      2646 3421 N 45 37 78 -22 -45 -37 h\n1.000 UP\n1.000 UL\nLT5\n2646 3421
      M\n78 -22 V\n-45 -37 V\n-78 22 V\n45 37 V\n.89 g 2724 3399 N 45 36 78
      -21 -45 -37 h\n1.000 UP\n1.000 UL\nLT5\n2724 3399 M\n78 -22 V\n-45 -36
      V\n-78 21 V\n45 37 V\n.8904 g 2802 3377 N 45 35 78 -21 -45 -36 h\n1.000
      UP\n1.000 UL\nLT5\n2802 3377 M\n78 -22 V\n-45 -35 V\n-78 21 V\n45 36
      V\n.8903 g 2880 3355 N 45 34 78 -22 -45 -35 h\n1.000 UP\n1.000
      UL\nLT5\n2880 3355 M\n78 -23 V\n-45 -34 V\n-78 22 V\n45 35 V\n.8892 g
      2958 3332 N 46 33 78 -24 -45 -34 h\n1.000 UP\n1.000 UL\nLT5\n2958 3332
      M\n79 -25 V\n-46 -33 V\n-78 24 V\n45 34 V\n.8864 g 3037 3307 N 45 33 79
      -28 -46 -33 h\n1.000 UP\n1.000 UL\nLT5\n3037 3307 M\n78 -28 V\n-45 -33
      V\n-79 28 V\n46 33 V\n.8804 g 3115 3279 N 45 31 78 -33 -45 -33 h\n1.000
      UP\n1.000 UL\nLT5\n3115 3279 M\n78 -35 V\n-45 -31 V\n-78 33 V\n45 33
      V\n.8694 g 3193 3244 N 45 30 78 -42 -45 -31 h\n1.000 UP\n1.000
      UL\nLT5\n3193 3244 M\n78 -43 V\n-45 -30 V\n-78 42 V\n45 31 V\n.8509 g
      3271 3201 N 45 30 78 -56 -45 -30 h\n1.000 UP\n1.000 UL\nLT5\n3271 3201
      M\n78 -56 V\n-45 -30 V\n-78 56 V\n45 30 V\n.8213 g 3349 3145 N 45 31 78
      -76 -45 -30 h\n1.000 UP\n1.000 UL\nLT5\n3349 3145 M\n78 -75 V\n-45 -31
      V\n-78 76 V\n45 30 V\n.7763 g 3427 3070 N 45 31 78 -102 -45 -31
      h\n1.000 UP\n1.000 UL\nLT5\n3427 3070 M\n78 -102 V\n-45 -31 V\n-78 102
      V\n45 31 V\n.7101 g 3505 2968 N 45 33 78 -139 -45 -31 h\n1.000
      UP\n1.000 UL\nLT5\n3505 2968 M\n78 -137 V\n-45 -33 V\n-78 139 V\n45 31
      V\n.7149 g 1273 3438 N 46 29 78 97 -45 -31 h\n1.000 UP\n1.000
      UL\nLT5\n1273 3438 M\n79 95 V\n-46 -29 V\n-78 -97 V\n45 31 V\n.7821 g
      1352 3533 N 45 28 79 59 -46 -29 h\n1.000 UP\n1.000 UL\nLT5\n1352 3533
      M\n78 58 V\n-45 -28 V\n-79 -59 V\n46 29 V\n.8276 g 1430 3591 N 45 27 78
      32 -45 -28 h\n1.000 UP\n1.000 UL\nLT5\n1430 3591 M\n78 31 V\n-45 -27
      V\n-78 -32 V\n45 28 V\n.8571 g 1508 3622 N 45 28 78 11 -45 -27 h\n1.000
      UP\n1.000 UL\nLT5\n1508 3622 M\n78 12 V\n-45 -28 V\n-78 -11 V\n45 27
      V\n.8753 g 1586 3634 N 45 28 78 -2 -45 -28 h\n1.000 UP\n1.000
      UL\nLT5\n1586 3634 M\n78 -2 V\n-45 -28 V\n-78 2 V\n45 28 V\n.8857 g
      1664 3632 N 45 29 78 -12 -45 -28 h\n1.000 UP\n1.000 UL\nLT5\n1664 3632
      M\n78 -11 V\n-45 -29 V\n-78 12 V\n45 28 V\n.891 g 1742 3621 N 45 31 78
      -18 -45 -29 h\n1.000 UP\n1.000 UL\nLT5\n1742 3621 M\n78 -16 V\n-45 -31
      V\n-78 18 V\n45 29 V\n.893 g 1820 3605 N 45 33 78 -22 -45 -31 h\n1.000
      UP\n1.000 UL\nLT5\n1820 3605 M\n78 -20 V\n-45 -33 V\n-78 22 V\n45 31
      V\n.8932 g 1898 3585 N 45 34 78 -23 -45 -33 h\n1.000 UP\n1.000
      UL\nLT5\n1898 3585 M\n78 -22 V\n-45 -34 V\n-78 23 V\n45 33 V\n.8925 g
      1976 3563 N 45 35 78 -24 -45 -34 h\n1.000 UP\n1.000 UL\nLT5\n1976 3563
      M\n78 -23 V\n-45 -35 V\n-78 24 V\n45 34 V\n.8915 g 2054 3540 N 45 37 78
      -25 -45 -35 h\n1.000 UP\n1.000 UL\nLT5\n2054 3540 M\n78 -23 V\n-45 -37
      V\n-78 25 V\n45 35 V\n.8904 g 2132 3517 N 46 37 78 -23 -45 -37 h\n1.000
      UP\n1.000 UL\nLT5\n2132 3517 M\n79 -23 V\n-46 -37 V\n-78 23 V\n45 37
      V\n.8896 g 2211 3494 N 45 38 79 -24 -46 -37 h\n1.000 UP\n1.000
      UL\nLT5\n2211 3494 M\n78 -23 V\n-45 -38 V\n-79 24 V\n46 37 V\n.8891 g
      2289 3471 N 45 39 78 -23 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2289 3471
      M\n78 -22 V\n-45 -39 V\n-78 23 V\n45 38 V\n.8889 g 2367 3449 N 45 39 78
      -22 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2367 3449 M\n78 -22 V\n-45 -39
      V\n-78 22 V\n45 39 V\n.8891 g 2445 3427 N 45 38 78 -21 -45 -39 h\n1.000
      UP\n1.000 UL\nLT5\n2445 3427 M\n78 -22 V\n-45 -38 V\n-78 21 V\n45 39
      V\n.8896 g 2523 3405 N 45 38 78 -21 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2523 3405 M\n78 -21 V\n-45 -38 V\n-78 21 V\n45 38 V\n.8904 g
      2601 3384 N 45 36 78 -20 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2601 3384
      M\n78 -22 V\n-45 -36 V\n-78 20 V\n45 38 V\n.8915 g 2679 3362 N 45 35 78
      -20 -45 -36 h\n1.000 UP\n1.000 UL\nLT5\n2679 3362 M\n78 -21 V\n-45 -35
      V\n-78 20 V\n45 36 V\n.8925 g 2757 3341 N 45 34 78 -20 -45 -35 h\n1.000
      UP\n1.000 UL\nLT5\n2757 3341 M\n78 -21 V\n-45 -34 V\n-78 20 V\n45 35
      V\n.8932 g 2835 3320 N 45 32 78 -20 -45 -34 h\n1.000 UP\n1.000
      UL\nLT5\n2835 3320 M\n78 -22 V\n-45 -32 V\n-78 20 V\n45 34 V\n.893 g
      2913 3298 N 45 31 78 -23 -45 -32 h\n1.000 UP\n1.000 UL\nLT5\n2913 3298
      M\n78 -24 V\n-45 -31 V\n-78 23 V\n45 32 V\n.891 g 2991 3274 N 46 29 78
      -26 -45 -31 h\n1.000 UP\n1.000 UL\nLT5\n2991 3274 M\n79 -28 V\n-46 -29
      V\n-78 26 V\n45 31 V\n.8857 g 3070 3246 N 45 28 79 -32 -46 -29 h\n1.000
      UP\n1.000 UL\nLT5\n3070 3246 M\n78 -33 V\n-45 -28 V\n-79 32 V\n46 29
      V\n.8753 g 3148 3213 N 45 28 78 -42 -45 -28 h\n1.000 UP\n1.000
      UL\nLT5\n3148 3213 M\n78 -42 V\n-45 -28 V\n-78 42 V\n45 28 V\n.8571 g
      3226 3171 N 45 28 78 -56 -45 -28 h\n1.000 UP\n1.000 UL\nLT5\n3226 3171
      M\n78 -56 V\n-45 -28 V\n-78 56 V\n45 28 V\n.8276 g 3304 3115 N 45 27 78
      -75 -45 -28 h\n1.000 UP\n1.000 UL\nLT5\n3304 3115 M\n78 -76 V\n-45 -27
      V\n-78 75 V\n45 28 V\n.7821 g 3382 3039 N 45 29 78 -104 -45 -27
      h\n1.000 UP\n1.000 UL\nLT5\n3382 3039 M\n78 -102 V\n-45 -29 V\n-78 104
      V\n45 27 V\n.7149 g 3460 2937 N 45 31 78 -141 -45 -29 h\n1.000
      UP\n1.000 UL\nLT5\n3460 2937 M\n78 -139 V\n-45 -31 V\n-78 141 V\n45 29
      V\n.7204 g 1228 3407 N 45 29 78 100 -45 -32 h\n1.000 UP\n1.000
      UL\nLT5\n1228 3407 M\n78 97 V\n-45 -29 V\n-78 -100 V\n45 32 V\n.7891 g
      1306 3504 N 46 26 78 62 -45 -29 h\n1.000 UP\n1.000 UL\nLT5\n1306 3504
      M\n79 59 V\n-46 -26 V\n-78 -62 V\n45 29 V\n.8353 g 1385 3563 N 45 26 79
      32 -46 -26 h\n1.000 UP\n1.000 UL\nLT5\n1385 3563 M\n78 32 V\n-45 -26
      V\n-79 -32 V\n46 26 V\n.865 g 1463 3595 N 45 25 78 12 -45 -26 h\n1.000
      UP\n1.000 UL\nLT5\n1463 3595 M\n78 11 V\n-45 -25 V\n-78 -12 V\n45 26
      V\n.8829 g 1541 3606 N 45 27 78 -4 -45 -25 h\n1.000 UP\n1.000
      UL\nLT5\n1541 3606 M\n78 -2 V\n-45 -27 V\n-78 4 V\n45 25 V\n.8926 g
      1619 3604 N 45 28 78 -13 -45 -27 h\n1.000 UP\n1.000 UL\nLT5\n1619 3604
      M\n78 -12 V\n-45 -28 V\n-78 13 V\n45 27 V\n.8969 g 1697 3592 N 45 29 78
      -19 -45 -28 h\n1.000 UP\n1.000 UL\nLT5\n1697 3592 M\n78 -18 V\n-45 -29
      V\n-78 19 V\n45 28 V\n.898 g 1775 3574 N 45 31 78 -24 -45 -29 h\n1.000
      UP\n1.000 UL\nLT5\n1775 3574 M\n78 -22 V\n-45 -31 V\n-78 24 V\n45 29
      V\n.8971 g 1853 3552 N 45 33 78 -25 -45 -31 h\n1.000 UP\n1.000
      UL\nLT5\n1853 3552 M\n78 -23 V\n-45 -33 V\n-78 25 V\n45 31 V\n.8953 g
      1931 3529 N 45 35 78 -26 -45 -33 h\n1.000 UP\n1.000 UL\nLT5\n1931 3529
      M\n78 -24 V\n-45 -35 V\n-78 26 V\n45 33 V\n.8933 g 2009 3505 N 45 35 78
      -25 -45 -35 h\n1.000 UP\n1.000 UL\nLT5\n2009 3505 M\n78 -25 V\n-45 -35
      V\n-78 25 V\n45 35 V\n.8915 g 2087 3480 N 45 38 78 -26 -45 -35 h\n1.000
      UP\n1.000 UL\nLT5\n2087 3480 M\n78 -23 V\n-45 -38 V\n-78 26 V\n45 35
      V\n.89 g 2165 3457 N 46 38 78 -24 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2165 3457 M\n79 -24 V\n-46 -38 V\n-78 24 V\n45 38 V\n.8891 g
      2244 3433 N 45 38 79 -23 -46 -38 h\n1.000 UP\n1.000 UL\nLT5\n2244 3433
      M\n78 -23 V\n-45 -38 V\n-79 23 V\n46 38 V\n.8888 g 2322 3410 N 45 38 78
      -22 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2322 3410 M\n78 -22 V\n-45 -38
      V\n-78 22 V\n45 38 V\n.8891 g 2400 3388 N 45 38 78 -21 -45 -38 h\n1.000
      UP\n1.000 UL\nLT5\n2400 3388 M\n78 -21 V\n-45 -38 V\n-78 21 V\n45 38
      V\n.89 g 2478 3367 N 45 37 78 -20 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2478 3367 M\n78 -21 V\n-45 -37 V\n-78 20 V\n45 38 V\n.8915 g
      2556 3346 N 45 36 78 -19 -45 -37 h\n1.000 UP\n1.000 UL\nLT5\n2556 3346
      M\n78 -20 V\n-45 -36 V\n-78 19 V\n45 37 V\n.8933 g 2634 3326 N 45 34 78
      -18 -45 -36 h\n1.000 UP\n1.000 UL\nLT5\n2634 3326 M\n78 -20 V\n-45 -34
      V\n-78 18 V\n45 36 V\n.8953 g 2712 3306 N 45 32 78 -18 -45 -34 h\n1.000
      UP\n1.000 UL\nLT5\n2712 3306 M\n78 -20 V\n-45 -32 V\n-78 18 V\n45 34
      V\n.8971 g 2790 3286 N 45 31 78 -19 -45 -32 h\n1.000 UP\n1.000
      UL\nLT5\n2790 3286 M\n78 -20 V\n-45 -31 V\n-78 19 V\n45 32 V\n.898 g
      2868 3266 N 45 29 78 -21 -45 -31 h\n1.000 UP\n1.000 UL\nLT5\n2868 3266
      M\n78 -23 V\n-45 -29 V\n-78 21 V\n45 31 V\n.8969 g 2946 3243 N 45 28 78
      -25 -45 -29 h\n1.000 UP\n1.000 UL\nLT5\n2946 3243 M\n78 -26 V\n-45 -28
      V\n-78 25 V\n45 29 V\n.8926 g 3024 3217 N 46 27 78 -31 -45 -28 h\n1.000
      UP\n1.000 UL\nLT5\n3024 3217 M\n79 -32 V\n-46 -27 V\n-78 31 V\n45 28
      V\n.8829 g 3103 3185 N 45 26 79 -41 -46 -27 h\n1.000 UP\n1.000
      UL\nLT5\n3103 3185 M\n78 -42 V\n-45 -26 V\n-79 41 V\n46 27 V\n.865 g
      3181 3143 N 45 25 78 -55 -45 -26 h\n1.000 UP\n1.000 UL\nLT5\n3181 3143
      M\n78 -56 V\n-45 -25 V\n-78 55 V\n45 26 V\n.8353 g 3259 3087 N 45 27 78
      -77 -45 -25 h\n1.000 UP\n1.000 UL\nLT5\n3259 3087 M\n78 -75 V\n-45 -27
      V\n-78 77 V\n45 25 V\n.7891 g 3337 3012 N 45 28 78 -105 -45 -27
      h\n1.000 UP\n1.000 UL\nLT5\n3337 3012 M\n78 -104 V\n-45 -28 V\n-78 105
      V\n45 27 V\n.7204 g 3415 2908 N 45 32 78 -145 -45 -28 h\n1.000
      UP\n1.000 UL\nLT5\n3415 2908 M\n78 -141 V\n-45 -32 V\n-78 145 V\n45 28
      V\n.7252 g 1183 3375 N 45 29 78 106 -45 -35 h\n1.000 UP\n1.000
      UL\nLT5\n1183 3375 M\n78 100 V\n-45 -29 V\n-78 -106 V\n45 35 V\n.7962 g
      1261 3475 N 45 27 78 64 -45 -29 h\n1.000 UP\n1.000 UL\nLT5\n1261 3475
      M\n78 62 V\n-45 -27 V\n-78 -64 V\n45 29 V\n.8436 g 1339 3537 N 46 25 78
      34 -45 -27 h\n1.000 UP\n1.000 UL\nLT5\n1339 3537 M\n79 32 V\n-46 -25
      V\n-78 -34 V\n45 27 V\n.8737 g 1418 3569 N 45 25 79 12 -46 -25 h\n1.000
      UP\n1.000 UL\nLT5\n1418 3569 M\n78 12 V\n-45 -25 V\n-79 -12 V\n46 25
      V\n.8914 g 1496 3581 N 45 25 78 -4 -45 -25 h\n1.000 UP\n1.000
      UL\nLT5\n1496 3581 M\n78 -4 V\n-45 -25 V\n-78 4 V\n45 25 V\n.9005 g
      1574 3577 N 45 27 78 -15 -45 -25 h\n1.000 UP\n1.000 UL\nLT5\n1574 3577
      M\n78 -13 V\n-45 -27 V\n-78 15 V\n45 25 V\n.9038 g 1652 3564 N 45 29 78
      -21 -45 -27 h\n1.000 UP\n1.000 UL\nLT5\n1652 3564 M\n78 -19 V\n-45 -29
      V\n-78 21 V\n45 27 V\n.9036 g 1730 3545 N 45 30 78 -25 -45 -29 h\n1.000
      UP\n1.000 UL\nLT5\n1730 3545 M\n78 -24 V\n-45 -30 V\n-78 25 V\n45 29
      V\n.9015 g 1808 3521 N 45 32 78 -27 -45 -30 h\n1.000 UP\n1.000
      UL\nLT5\n1808 3521 M\n78 -25 V\n-45 -32 V\n-78 27 V\n45 30 V\n.8984 g
      1886 3496 N 45 34 78 -28 -45 -32 h\n1.000 UP\n1.000 UL\nLT5\n1886 3496
      M\n78 -26 V\n-45 -34 V\n-78 28 V\n45 32 V\n.8953 g 1964 3470 N 45 37 78
      -28 -45 -34 h\n1.000 UP\n1.000 UL\nLT5\n1964 3470 M\n78 -25 V\n-45 -37
      V\n-78 28 V\n45 34 V\n.8925 g 2042 3445 N 45 37 78 -26 -45 -37 h\n1.000
      UP\n1.000 UL\nLT5\n2042 3445 M\n78 -26 V\n-45 -37 V\n-78 26 V\n45 37
      V\n.8904 g 2120 3419 N 45 38 78 -25 -45 -37 h\n1.000 UP\n1.000
      UL\nLT5\n2120 3419 M\n78 -24 V\n-45 -38 V\n-78 25 V\n45 37 V\n.889 g
      2198 3395 N 46 39 78 -24 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2198 3395
      M\n79 -23 V\n-46 -39 V\n-78 24 V\n45 38 V\n.8886 g 2277 3372 N 45 39 79
      -22 -46 -39 h\n1.000 UP\n1.000 UL\nLT5\n2277 3372 M\n78 -22 V\n-45 -39
      V\n-79 22 V\n46 39 V\n.889 g 2355 3350 N 45 38 78 -20 -45 -39 h\n1.000
      UP\n1.000 UL\nLT5\n2355 3350 M\n78 -21 V\n-45 -38 V\n-78 20 V\n45 39
      V\n.8904 g 2433 3329 N 45 37 78 -19 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2433 3329 M\n78 -20 V\n-45 -37 V\n-78 19 V\n45 38 V\n.8925 g
      2511 3309 N 45 36 78 -18 -45 -37 h\n1.000 UP\n1.000 UL\nLT5\n2511 3309
      M\n78 -19 V\n-45 -36 V\n-78 18 V\n45 37 V\n.8953 g 2589 3290 N 45 35 78
      -17 -45 -36 h\n1.000 UP\n1.000 UL\nLT5\n2589 3290 M\n78 -18 V\n-45 -35
      V\n-78 17 V\n45 36 V\n.8984 g 2667 3272 N 45 33 78 -16 -45 -35 h\n1.000
      UP\n1.000 UL\nLT5\n2667 3272 M\n78 -18 V\n-45 -33 V\n-78 16 V\n45 35
      V\n.9015 g 2745 3254 N 45 31 78 -17 -45 -33 h\n1.000 UP\n1.000
      UL\nLT5\n2745 3254 M\n78 -19 V\n-45 -31 V\n-78 17 V\n45 33 V\n.9036 g
      2823 3235 N 45 29 78 -19 -45 -31 h\n1.000 UP\n1.000 UL\nLT5\n2823 3235
      M\n78 -21 V\n-45 -29 V\n-78 19 V\n45 31 V\n.9038 g 2901 3214 N 45 27 78
      -23 -45 -29 h\n1.000 UP\n1.000 UL\nLT5\n2901 3214 M\n78 -25 V\n-45 -27
      V\n-78 23 V\n45 29 V\n.9005 g 2979 3189 N 45 25 78 -29 -45 -27 h\n1.000
      UP\n1.000 UL\nLT5\n2979 3189 M\n78 -31 V\n-45 -25 V\n-78 29 V\n45 27
      V\n.8914 g 3057 3158 N 46 24 78 -40 -45 -25 h\n1.000 UP\n1.000
      UL\nLT5\n3057 3158 M\n79 -41 V\n-46 -24 V\n-78 40 V\n45 25 V\n.8737 g
      3136 3117 N 45 25 79 -56 -46 -24 h\n1.000 UP\n1.000 UL\nLT5\n3136 3117
      M\n78 -55 V\n-45 -25 V\n-79 56 V\n46 24 V\n.8436 g 3214 3062 N 45 26 78
      -78 -45 -25 h\n1.000 UP\n1.000 UL\nLT5\n3214 3062 M\n78 -77 V\n-45 -26
      V\n-78 78 V\n45 25 V\n.7962 g 3292 2985 N 45 30 78 -109 -45 -26
      h\n1.000 UP\n1.000 UL\nLT5\n3292 2985 M\n78 -105 V\n-45 -30 V\n-78 109
      V\n45 26 V\n.7252 g 3370 2880 N 45 34 78 -149 -45 -30 h\n1.000
      UP\n1.000 UL\nLT5\n3370 2880 M\n78 -145 V\n-45 -34 V\n-78 149 V\n45 30
      V\n.7276 g 1138 3340 N 45 34 78 112 -45 -40 h\n1.000 UP\n1.000
      UL\nLT5\n1138 3340 M\n78 106 V\n-45 -34 V\n-78 -112 V\n45 40 V\n.8017 g
      1216 3446 N 45 30 78 68 -45 -34 h\n1.000 UP\n1.000 UL\nLT5\n1216 3446
      M\n78 64 V\n-45 -30 V\n-78 -68 V\n45 34 V\n.8511 g 1294 3510 N 45 27 78
      37 -45 -30 h\n1.000 UP\n1.000 UL\nLT5\n1294 3510 M\n78 34 V\n-45 -27
      V\n-78 -37 V\n45 30 V\n.8821 g 1372 3544 N 46 27 78 12 -45 -27 h\n1.000
      UP\n1.000 UL\nLT5\n1372 3544 M\n79 12 V\n-46 -27 V\n-78 -12 V\n45 27
      V\n.8998 g 1451 3556 N 45 27 79 -4 -46 -27 h\n1.000 UP\n1.000
      UL\nLT5\n1451 3556 M\n78 -4 V\n-45 -27 V\n-79 4 V\n46 27 V\n.9083 g
      1529 3552 N 45 27 78 -15 -45 -27 h\n1.000 UP\n1.000 UL\nLT5\n1529 3552
      M\n78 -15 V\n-45 -27 V\n-78 15 V\n45 27 V\n.9107 g 1607 3537 N 45 29 78
      -23 -45 -27 h\n1.000 UP\n1.000 UL\nLT5\n1607 3537 M\n78 -21 V\n-45 -29
      V\n-78 23 V\n45 27 V\n.9093 g 1685 3516 N 45 31 78 -27 -45 -29 h\n1.000
      UP\n1.000 UL\nLT5\n1685 3516 M\n78 -25 V\n-45 -31 V\n-78 27 V\n45 29
      V\n.9058 g 1763 3491 N 45 33 78 -29 -45 -31 h\n1.000 UP\n1.000
      UL\nLT5\n1763 3491 M\n78 -27 V\n-45 -33 V\n-78 29 V\n45 31 V\n.9015 g
      1841 3464 N 45 35 78 -30 -45 -33 h\n1.000 UP\n1.000 UL\nLT5\n1841 3464
      M\n78 -28 V\n-45 -35 V\n-78 30 V\n45 33 V\n.8971 g 1919 3436 N 45 36 78
      -29 -45 -35 h\n1.000 UP\n1.000 UL\nLT5\n1919 3436 M\n78 -28 V\n-45 -36
      V\n-78 29 V\n45 35 V\n.8932 g 1997 3408 N 45 38 78 -28 -45 -36 h\n1.000
      UP\n1.000 UL\nLT5\n1997 3408 M\n78 -26 V\n-45 -38 V\n-78 28 V\n45 36
      V\n.8903 g 2075 3382 N 45 39 78 -26 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n2075 3382 M\n78 -25 V\n-45 -39 V\n-78 26 V\n45 38 V\n.8884 g
      2153 3357 N 45 40 78 -25 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2153 3357
      M\n78 -24 V\n-45 -40 V\n-78 25 V\n45 39 V\n.8878 g 2231 3333 N 46 40 78
      -22 -45 -40 h\n1.000 UP\n1.000 UL\nLT5\n2231 3333 M\n79 -22 V\n-46 -40
      V\n-78 22 V\n45 40 V\n.8884 g 2310 3311 N 45 40 79 -20 -46 -40 h\n1.000
      UP\n1.000 UL\nLT5\n2310 3311 M\n78 -20 V\n-45 -40 V\n-79 20 V\n46 40
      V\n.8903 g 2388 3291 N 45 39 78 -18 -45 -40 h\n1.000 UP\n1.000
      UL\nLT5\n2388 3291 M\n78 -19 V\n-45 -39 V\n-78 18 V\n45 40 V\n.8932 g
      2466 3272 N 45 37 78 -16 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n2466 3272
      M\n78 -18 V\n-45 -37 V\n-78 16 V\n45 39 V\n.8971 g 2544 3254 N 45 35 78
      -15 -45 -37 h\n1.000 UP\n1.000 UL\nLT5\n2544 3254 M\n78 -17 V\n-45 -35
      V\n-78 15 V\n45 37 V\n.9015 g 2622 3237 N 45 33 78 -14 -45 -35 h\n1.000
      UP\n1.000 UL\nLT5\n2622 3237 M\n78 -16 V\n-45 -33 V\n-78 14 V\n45 35
      V\n.9058 g 2700 3221 N 45 31 78 -15 -45 -33 h\n1.000 UP\n1.000
      UL\nLT5\n2700 3221 M\n78 -17 V\n-45 -31 V\n-78 15 V\n45 33 V\n.9093 g
      2778 3204 N 45 29 78 -17 -45 -31 h\n1.000 UP\n1.000 UL\nLT5\n2778 3204
      M\n78 -19 V\n-45 -29 V\n-78 17 V\n45 31 V\n.9107 g 2856 3185 N 45 27 78
      -21 -45 -29 h\n1.000 UP\n1.000 UL\nLT5\n2856 3185 M\n78 -23 V\n-45 -27
      V\n-78 21 V\n45 29 V\n.9083 g 2934 3162 N 45 27 78 -29 -45 -27 h\n1.000
      UP\n1.000 UL\nLT5\n2934 3162 M\n78 -29 V\n-45 -27 V\n-78 29 V\n45 27
      V\n.8998 g 3012 3133 N 45 27 78 -40 -45 -27 h\n1.000 UP\n1.000
      UL\nLT5\n3012 3133 M\n78 -40 V\n-45 -27 V\n-78 40 V\n45 27 V\n.8821 g
      3090 3093 N 46 28 78 -57 -45 -27 h\n1.000 UP\n1.000 UL\nLT5\n3090 3093
      M\n79 -56 V\n-46 -28 V\n-78 57 V\n45 27 V\n.8511 g 3169 3037 N 45 30 79
      -80 -46 -28 h\n1.000 UP\n1.000 UL\nLT5\n3169 3037 M\n78 -78 V\n-45 -30
      V\n-79 80 V\n46 28 V\n.8017 g 3247 2959 N 45 34 78 -113 -45 -30
      h\n1.000 UP\n1.000 UL\nLT5\n3247 2959 M\n78 -109 V\n-45 -34 V\n-78 113
      V\n45 30 V\n.7276 g 3325 2850 N 45 41 78 -156 -45 -34 h\n1.000
      UP\n1.000 UL\nLT5\n3325 2850 M\n78 -149 V\n-45 -41 V\n-78 156 V\n45 34
      V\n.7251 g 1093 3300 N 45 42 78 121 -45 -51 h\n1.000 UP\n1.000
      UL\nLT5\n1093 3300 M\n78 112 V\n-45 -42 V\n-78 -121 V\n45 51 V\n.8037 g
      1171 3412 N 45 36 78 74 -45 -42 h\n1.000 UP\n1.000 UL\nLT5\n1171 3412
      M\n78 68 V\n-45 -36 V\n-78 -74 V\n45 42 V\n.8558 g 1249 3480 N 45 32 78
      41 -45 -36 h\n1.000 UP\n1.000 UL\nLT5\n1249 3480 M\n78 37 V\n-45 -32
      V\n-78 -41 V\n45 36 V\n.8884 g 1327 3517 N 45 30 78 14 -45 -32 h\n1.000
      UP\n1.000 UL\nLT5\n1327 3517 M\n78 12 V\n-45 -30 V\n-78 -14 V\n45 32
      V\n.9067 g 1405 3529 N 46 29 78 -3 -45 -30 h\n1.000 UP\n1.000
      UL\nLT5\n1405 3529 M\n79 -4 V\n-46 -29 V\n-78 3 V\n45 30 V\n.915 g 1484
      3525 N 45 30 79 -16 -46 -29 h\n1.000 UP\n1.000 UL\nLT5\n1484 3525 M\n78
      -15 V\n-45 -30 V\n-79 16 V\n46 29 V\n.9166 g 1562 3510 N 45 31 78 -24
      -45 -30 h\n1.000 UP\n1.000 UL\nLT5\n1562 3510 M\n78 -23 V\n-45 -31
      V\n-78 24 V\n45 30 V\n.9141 g 1640 3487 N 45 33 78 -29 -45 -31 h\n1.000
      UP\n1.000 UL\nLT5\n1640 3487 M\n78 -27 V\n-45 -33 V\n-78 29 V\n45 31
      V\n.9093 g 1718 3460 N 45 35 78 -31 -45 -33 h\n1.000 UP\n1.000
      UL\nLT5\n1718 3460 M\n78 -29 V\n-45 -35 V\n-78 31 V\n45 33 V\n.9036 g
      1796 3431 N 45 37 78 -32 -45 -35 h\n1.000 UP\n1.000 UL\nLT5\n1796 3431
      M\n78 -30 V\n-45 -37 V\n-78 32 V\n45 35 V\n.898 g 1874 3401 N 45 39 78
      -31 -45 -37 h\n1.000 UP\n1.000 UL\nLT5\n1874 3401 M\n78 -29 V\n-45 -39
      V\n-78 31 V\n45 37 V\n.893 g 1952 3372 N 45 40 78 -29 -45 -39 h\n1.000
      UP\n1.000 UL\nLT5\n1952 3372 M\n78 -28 V\n-45 -40 V\n-78 29 V\n45 39
      V\n.8892 g 2030 3344 N 45 42 78 -28 -45 -40 h\n1.000 UP\n1.000
      UL\nLT5\n2030 3344 M\n78 -26 V\n-45 -42 V\n-78 28 V\n45 40 V\n.8869 g
      2108 3318 N 45 41 78 -24 -45 -42 h\n1.000 UP\n1.000 UL\nLT5\n2108 3318
      M\n78 -25 V\n-45 -41 V\n-78 24 V\n45 42 V\n.8861 g 2186 3293 N 45 41 78
      -22 -45 -41 h\n1.000 UP\n1.000 UL\nLT5\n2186 3293 M\n78 -22 V\n-45 -41
      V\n-78 22 V\n45 41 V\n.8869 g 2264 3271 N 46 41 78 -20 -45 -41 h\n1.000
      UP\n1.000 UL\nLT5\n2264 3271 M\n79 -20 V\n-46 -41 V\n-78 20 V\n45 41
      V\n.8892 g 2343 3251 N 45 40 79 -17 -46 -41 h\n1.000 UP\n1.000
      UL\nLT5\n2343 3251 M\n78 -18 V\n-45 -40 V\n-79 17 V\n46 41 V\n.893 g
      2421 3233 N 45 38 78 -14 -45 -40 h\n1.000 UP\n1.000 UL\nLT5\n2421 3233
      M\n78 -16 V\n-45 -38 V\n-78 14 V\n45 40 V\n.898 g 2499 3217 N 45 37 78
      -14 -45 -38 h\n1.000 UP\n1.000 UL\nLT5\n2499 3217 M\n78 -15 V\n-45 -37
      V\n-78 14 V\n45 38 V\n.9036 g 2577 3202 N 45 35 78 -12 -45 -37 h\n1.000
      UP\n1.000 UL\nLT5\n2577 3202 M\n78 -14 V\n-45 -35 V\n-78 12 V\n45 37
      V\n.9093 g 2655 3188 N 45 33 78 -13 -45 -35 h\n1.000 UP\n1.000
      UL\nLT5\n2655 3188 M\n78 -15 V\n-45 -33 V\n-78 13 V\n45 35 V\n.9141 g
      2733 3173 N 45 31 78 -15 -45 -33 h\n1.000 UP\n1.000 UL\nLT5\n2733 3173
      M\n78 -17 V\n-45 -31 V\n-78 15 V\n45 33 V\n.9166 g 2811 3156 N 45 30 78
      -20 -45 -31 h\n1.000 UP\n1.000 UL\nLT5\n2811 3156 M\n78 -21 V\n-45 -30
      V\n-78 20 V\n45 31 V\n.915 g 2889 3135 N 45 29 78 -28 -45 -30 h\n1.000
      UP\n1.000 UL\nLT5\n2889 3135 M\n78 -29 V\n-45 -29 V\n-78 28 V\n45 30
      V\n.9067 g 2967 3106 N 45 30 78 -41 -45 -29 h\n1.000 UP\n1.000
      UL\nLT5\n2967 3106 M\n78 -40 V\n-45 -30 V\n-78 41 V\n45 29 V\n.8884 g
      3045 3066 N 45 32 78 -59 -45 -30 h\n1.000 UP\n1.000 UL\nLT5\n3045 3066
      M\n78 -57 V\n-45 -32 V\n-78 59 V\n45 30 V\n.8558 g 3123 3009 N 46 36 78
      -84 -45 -32 h\n1.000 UP\n1.000 UL\nLT5\n3123 3009 M\n79 -80 V\n-46 -36
      V\n-78 84 V\n45 32 V\n.8037 g 3202 2929 N 45 42 79 -119 -46 -36
      h\n1.000 UP\n1.000 UL\nLT5\n3202 2929 M\n78 -113 V\n-45 -42 V\n-79 119
      V\n46 36 V\n.7251 g 3280 2816 N 45 50 78 -164 -45 -42 h\n1.000
      UP\n1.000 UL\nLT5\n3280 2816 M\n78 -156 V\n-45 -50 V\n-78 164 V\n45 42
      V\n.7149 g 1048 3249 N 45 55 78 132 -45 -66 h\n1.000 UP\n1.000
      UL\nLT5\n1048 3249 M\n78 121 V\n-45 -55 V\n-78 -132 V\n45 66 V\n.7993 g
      1126 3370 N 45 46 78 83 -45 -55 h\n1.000 UP\n1.000 UL\nLT5\n1126 3370
      M\n78 74 V\n-45 -46 V\n-78 -83 V\n45 55 V\n.8554 g 1204 3444 N 45 41 78
      46 -45 -46 h\n1.000 UP\n1.000 UL\nLT5\n1204 3444 M\n78 41 V\n-45 -41
      V\n-78 -46 V\n45 46 V\n.8905 g 1282 3485 N 45 37 78 18 -45 -41 h\n1.000
      UP\n1.000 UL\nLT5\n1282 3485 M\n78 14 V\n-45 -37 V\n-78 -18 V\n45 41
      V\n.91 g 1360 3499 N 45 36 78 -2 -45 -37 h\n1.000 UP\n1.000
      UL\nLT5\n1360 3499 M\n78 -3 V\n-45 -36 V\n-78 2 V\n45 37 V\n.9187 g
      1438 3496 N 46 36 78 -16 -45 -36 h\n1.000 UP\n1.000 UL\nLT5\n1438 3496
      M\n79 -16 V\n-46 -36 V\n-78 16 V\n45 36 V\n.92 g 1517 3480 N 45 36 79
      -24 -46 -36 h\n1.000 UP\n1.000 UL\nLT5\n1517 3480 M\n78 -24 V\n-45 -36
      V\n-79 24 V\n46 36 V\n.9166 g 1595 3456 N 45 38 78 -31 -45 -36 h\n1.000
      UP\n1.000 UL\nLT5\n1595 3456 M\n78 -29 V\n-45 -38 V\n-78 31 V\n45 36
      V\n.9107 g 1673 3427 N 45 39 78 -32 -45 -38 h\n1.000 UP\n1.000
      UL\nLT5\n1673 3427 M\n78 -31 V\n-45 -39 V\n-78 32 V\n45 38 V\n.9038 g
      1751 3396 N 45 41 78 -34 -45 -39 h\n1.000 UP\n1.000 UL\nLT5\n1751 3396
      M\n78 -32 V\n-45 -41 V\n-78 34 V\n45 39 V\n.8969 g 1829 3364 N 45 42 78
      -32 -45 -41 h\n1.000 UP\n1.000 UL\nLT5\n1829 3364 M\n78 -31 V\n-45 -42
      V\n-78 32 V\n45 41 V\n.891 g 1907 3333 N 45 44 78 -31 -45 -42 h\n1.000
      UP\n1.000 UL\nLT5\n1907 3333 M\n78 -29 V\n-45 -44 V\n-78 31 V\n45 42
      V\n.8864 g 1985 3304 N 45 44 78 -28 -45 -44 h\n1.000 UP\n1.000
      UL\nLT5\n1985 3304 M\n78 -28 V\n-45 -44 V\n-78 28 V\n45 44 V\n.8835 g
      2063 3276 N 45 45 78 -25 -45 -44 h\n1.000 UP\n1.000 UL\nLT5\n2063 3276
      M\n78 -24 V\n-45 -45 V\n-78 25 V\n45 44 V\n.8825 g 2141 3252 N 45 46 78
      -23 -45 -45 h\n1.000 UP\n1.000 UL\nLT5\n2141 3252 M\n78 -22 V\n-45 -46
      V\n-78 23 V\n45 45 V\n.8835 g 2219 3230 N 45 44 78 -18 -45 -46 h\n1.000
      UP\n1.000 UL\nLT5\n2219 3230 M\n78 -20 V\n-45 -44 V\n-78 18 V\n45 46
      V\n.8864 g 2297 3210 N 46 43 78 -16 -45 -44 h\n1.000 UP\n1.000
      UL\nLT5\n2297 3210 M\n79 -17 V\n-46 -43 V\n-78 16 V\n45 44 V\n.891 g
      2376 3193 N 45 43 79 -14 -46 -43 h\n1.000 UP\n1.000 UL\nLT5\n2376 3193
      M\n78 -14 V\n-45 -43 V\n-79 14 V\n46 43 V\n.8969 g 2454 3179 N 45 40 78
      -11 -45 -43 h\n1.000 UP\n1.000 UL\nLT5\n2454 3179 M\n78 -14 V\n-45 -40
      V\n-78 11 V\n45 43 V\n.9038 g 2532 3165 N 45 39 78 -11 -45 -40 h\n1.000
      UP\n1.000 UL\nLT5\n2532 3165 M\n78 -12 V\n-45 -39 V\n-78 11 V\n45 40
      V\n.9107 g 2610 3153 N 45 37 78 -11 -45 -39 h\n1.000 UP\n1.000
      UL\nLT5\n2610 3153 M\n78 -13 V\n-45 -37 V\n-78 11 V\n45 39 V\n.9166 g
      2688 3140 N 45 36 78 -14 -45 -37 h\n1.000 UP\n1.000 UL\nLT5\n2688 3140
      M\n78 -15 V\n-45 -36 V\n-78 14 V\n45 37 V\n.92 g 2766 3125 N 45 36 78
      -20 -45 -36 h\n1.000 UP\n1.000 UL\nLT5\n2766 3125 M\n78 -20 V\n-45 -36
      V\n-78 20 V\n45 36 V\n.9187 g 2844 3105 N 45 36 78 -28 -45 -36 h\n1.000
      UP\n1.000 UL\nLT5\n2844 3105 M\n78 -28 V\n-45 -36 V\n-78 28 V\n45 36
      V\n.91 g 2922 3077 N 45 37 78 -42 -45 -36 h\n1.000 UP\n1.000
      UL\nLT5\n2922 3077 M\n78 -41 V\n-45 -37 V\n-78 42 V\n45 36 V\n.8905 g
      3000 3036 N 45 40 78 -62 -45 -37 h\n1.000 UP\n1.000 UL\nLT5\n3000 3036
      M\n78 -59 V\n-45 -40 V\n-78 62 V\n45 37 V\n.8554 g 3078 2977 N 45 46 78
      -90 -45 -40 h\n1.000 UP\n1.000 UL\nLT5\n3078 2977 M\n78 -84 V\n-45 -46
      V\n-78 90 V\n45 40 V\n.7993 g 3156 2893 N 45 54 79 -127 -45 -46
      h\n1.000 UP\n1.000 UL\nLT5\n3156 2893 M\n79 -119 V\n-45 -54 V\n-79 127
      V\n45 46 V\n.7149 g 3235 2774 N 45 66 78 -176 -45 -54 h\n1.000
      UP\n1.000 UL\nLT5\n3235 2774 M\n78 -164 V\n-45 -66 V\n-78 176 V\n45 54
      V\n.6931 g 1003 3183 N 45 73 78 147 -45 -88 h\n1.000 UP\n1.000
      UL\nLT5\n1003 3183 M\n78 132 V\n-45 -73 V\n958 3095 L\n45 88 V\n.7851 g
      1081 3315 N 45 62 78 94 -45 -73 h\n1.000 UP\n1.000 UL\nLT5\n1081 3315
      M\n78 83 V\n-45 -62 V\n-78 -94 V\n45 73 V\n.8468 g 1159 3398 N 45 55 78
      53 -45 -62 h\n1.000 UP\n1.000 UL\nLT5\n1159 3398 M\n78 46 V\n-45 -55
      V\n-78 -53 V\n45 62 V\n.8855 g 1237 3444 N 45 49 78 24 -45 -55 h\n1.000
      UP\n1.000 UL\nLT5\n1237 3444 M\n78 18 V\n-45 -49 V\n-78 -24 V\n45 55
      V\n.9074 g 1315 3462 N 45 46 78 1 -45 -49 h\n1.000 UP\n1.000
      UL\nLT5\n1315 3462 M\n78 -2 V\n-45 -46 V\n-78 -1 V\n45 49 V\n.9171 g
      1393 3460 N 45 44 78 -14 -45 -46 h\n1.000 UP\n1.000 UL\nLT5\n1393 3460
      M\n78 -16 V\n-45 -44 V\n-78 14 V\n45 46 V\n.9187 g 1471 3444 N 46 45 78
      -25 -45 -44 h\n1.000 UP\n1.000 UL\nLT5\n1471 3444 M\n79 -24 V\n-46 -45
      V\n-78 25 V\n45 44 V\n.915 g 1550 3420 N 45 44 79 -30 -46 -45 h\n1.000
      UP\n1.000 UL\nLT5\n1550 3420 M\n78 -31 V\n-45 -44 V\n-79 30 V\n46 45
      V\n.9083 g 1628 3389 N 45 46 78 -34 -45 -44 h\n1.000 UP\n1.000
      UL\nLT5\n1628 3389 M\n78 -32 V\n-45 -46 V\n-78 34 V\n45 44 V\n.9005 g
      1706 3357 N 45 47 78 -35 -45 -46 h\n1.000 UP\n1.000 UL\nLT5\n1706 3357
      M\n78 -34 V\n-45 -47 V\n-78 35 V\n45 46 V\n.8926 g 1784 3323 N 45 49 78
      -34 -45 -47 h\n1.000 UP\n1.000 UL\nLT5\n1784 3323 M\n78 -32 V\n-45 -49
      V\n-78 34 V\n45 47 V\n.8857 g 1862 3291 N 45 50 78 -32 -45 -49 h\n1.000
      UP\n1.000 UL\nLT5\n1862 3291 M\n78 -31 V\n-45 -50 V\n-78 32 V\n45 49
      V\n.8804 g 1940 3260 N 45 51 78 -29 -45 -50 h\n1.000 UP\n1.000
      UL\nLT5\n1940 3260 M\n78 -28 V\n-45 -51 V\n-78 29 V\n45 50 V\n.877 g
      2018 3232 N 45 51 78 -25 -45 -51 h\n1.000 UP\n1.000 UL\nLT5\n2018 3232
      M\n78 -25 V\n-45 -51 V\n-78 25 V\n45 51 V\n.8759 g 2096 3207 N 45 50 78
      -22 -45 -51 h\n1.000 UP\n1.000 UL\nLT5\n2096 3207 M\n78 -23 V\n-45 -50
      V\n-78 22 V\n45 51 V\n.877 g 2174 3184 N 45 51 78 -19 -45 -50 h\n1.000
      UP\n1.000 UL\nLT5\n2174 3184 M\n78 -18 V\n-45 -51 V\n-78 19 V\n45 50
      V\n.8804 g 2252 3166 N 45 50 78 -15 -45 -51 h\n1.000 UP\n1.000
      UL\nLT5\n2252 3166 M\n78 -16 V\n-45 -50 V\n-78 15 V\n45 51 V\n.8857 g
      2330 3150 N 45 48 79 -12 -45 -50 h\n1.000 UP\n1.000 UL\nLT5\n2330 3150
      M\n79 -14 V\n-45 -48 V\n-79 12 V\n45 50 V\n.8926 g 2409 3136 N 45 47 78
      -10 -45 -48 h\n1.000 UP\n1.000 UL\nLT5\n2409 3136 M\n78 -11 V\n-45 -47
      V\n-78 10 V\n45 48 V\n.9005 g 2487 3125 N 45 46 78 -10 -45 -47 h\n1.000
      UP\n1.000 UL\nLT5\n2487 3125 M\n78 -11 V\n-45 -46 V\n-78 10 V\n45 47
      V\n.9083 g 2565 3114 N 45 45 78 -10 -45 -46 h\n1.000 UP\n1.000
      UL\nLT5\n2565 3114 M\n78 -11 V\n-45 -45 V\n-78 10 V\n45 46 V\n.915 g
      2643 3103 N 45 44 78 -13 -45 -45 h\n1.000 UP\n1.000 UL\nLT5\n2643 3103
      M\n78 -14 V\n-45 -44 V\n-78 13 V\n45 45 V\n.9187 g 2721 3089 N 45 44 78
      -20 -45 -44 h\n1.000 UP\n1.000 UL\nLT5\n2721 3089 M\n78 -20 V\n-45 -44
      V\n-78 20 V\n45 44 V\n.9171 g 2799 3069 N 45 46 78 -30 -45 -44 h\n1.000
      UP\n1.000 UL\nLT5\n2799 3069 M\n78 -28 V\n-45 -46 V\n-78 30 V\n45 44
      V\n.9074 g 2877 3041 N 45 49 78 -45 -45 -46 h\n1.000 UP\n1.000
      UL\nLT5\n2877 3041 M\n78 -42 V\n-45 -49 V\n-78 45 V\n45 46 V\n.8855 g
      2955 2999 N 45 55 78 -68 -45 -49 h\n1.000 UP\n1.000 UL\nLT5\n2955 2999
      M\n78 -62 V\n-45 -55 V\n-78 68 V\n45 49 V\n.8468 g 3033 2937 N 45 63 78
      -98 -45 -55 h\n1.000 UP\n1.000 UL\nLT5\n3033 2937 M\n78 -90 V\n-45 -63
      V\n-78 98 V\n45 55 V\n.7851 g 3111 2847 N 46 74 78 -138 -45 -63
      h\n1.000 UP\n1.000 UL\nLT5\n3111 2847 M\n79 -127 V\n-46 -74 V\n-78 138
      V\n45 63 V\n.6931 g 3190 2720 N 45 88 79 -190 -46 -74 h\n1.000
      UP\n1.000 UL\nLT5\n3190 2720 M\n78 -176 V\n-45 -88 V\n-79 190 V\n46 74
      V\n.655 g 958 3095 N 45 99 78 165 -45 -117 h\n1.000 UP\n1.000
      UL\nLT5\n958 3095 M\n78 147 V\n-45 -99 V\n913 2978 L\n45 117 V\n.7569 g
      1036 3242 N 45 85 78 108 -45 -99 h\n1.000 UP\n1.000 UL\nLT5\n1036 3242
      M\n78 94 V\n-45 -85 V\n991 3143 L\n45 99 V\n.8259 g 1114 3336 N 45 74
      78 64 -45 -85 h\n1.000 UP\n1.000 UL\nLT5\n1114 3336 M\n78 53 V\n-45 -74
      V\n-78 -64 V\n45 85 V\n.87 g 1192 3389 N 45 67 78 31 -45 -74 h\n1.000
      UP\n1.000 UL\nLT5\n1192 3389 M\n78 24 V\n-45 -67 V\n-78 -31 V\n45 74
      V\n.8954 g 1270 3413 N 45 62 78 6 -45 -67 h\n1.000 UP\n1.000
      UL\nLT5\n1270 3413 M\n78 1 V\n-45 -62 V\n-78 -6 V\n45 67 V\n.9074 g
      1348 3414 N 45 59 78 -11 -45 -62 h\n1.000 UP\n1.000 UL\nLT5\n1348 3414
      M\n78 -14 V\n-45 -59 V\n-78 11 V\n45 62 V\n.91 g 1426 3400 N 45 56 78
      -22 -45 -59 h\n1.000 UP\n1.000 UL\nLT5\n1426 3400 M\n78 -25 V\n-45 -56
      V\n-78 22 V\n45 59 V\n.9067 g 1504 3375 N 46 57 78 -31 -45 -56 h\n1.000
      UP\n1.000 UL\nLT5\n1504 3375 M\n79 -30 V\n-46 -57 V\n-78 31 V\n45 56
      V\n.8998 g 1583 3345 N 45 57 79 -34 -46 -57 h\n1.000 UP\n1.000
      UL\nLT5\n1583 3345 M\n78 -34 V\n-45 -57 V\n-79 34 V\n46 57 V\n.8914 g
      1661 3311 N 45 57 78 -35 -45 -57 h\n1.000 UP\n1.000 UL\nLT5\n1661 3311
      M\n78 -35 V\n-45 -57 V\n-78 35 V\n45 57 V\n.8829 g 1739 3276 N 45 58 78
      -35 -45 -57 h\n1.000 UP\n1.000 UL\nLT5\n1739 3276 M\n78 -34 V\n-45 -58
      V\n-78 35 V\n45 57 V\n.8753 g 1817 3242 N 45 58 78 -32 -45 -58 h\n1.000
      UP\n1.000 UL\nLT5\n1817 3242 M\n78 -32 V\n-45 -58 V\n-78 32 V\n45 58
      V\n.8694 g 1895 3210 N 45 59 78 -30 -45 -58 h\n1.000 UP\n1.000
      UL\nLT5\n1895 3210 M\n78 -29 V\n-45 -59 V\n-78 30 V\n45 58 V\n.8657 g
      1973 3181 N 45 60 78 -26 -45 -59 h\n1.000 UP\n1.000 UL\nLT5\n1973 3181
      M\n78 -25 V\n-45 -60 V\n-78 26 V\n45 59 V\n.8644 g 2051 3156 N 45 60 78
      -22 -45 -60 h\n1.000 UP\n1.000 UL\nLT5\n2051 3156 M\n78 -22 V\n-45 -60
      V\n-78 22 V\n45 60 V\n.8657 g 2129 3134 N 45 59 78 -18 -45 -60 h\n1.000
      UP\n1.000 UL\nLT5\n2129 3134 M\n78 -19 V\n-45 -59 V\n-78 18 V\n45 60
      V\n.8694 g 2207 3115 N 45 58 78 -14 -45 -59 h\n1.000 UP\n1.000
      UL\nLT5\n2207 3115 M\n78 -15 V\n-45 -58 V\n-78 14 V\n45 59 V\n.8753 g
      2285 3100 N 46 58 78 -12 -45 -58 h\n1.000 UP\n1.000 UL\nLT5\n2285 3100
      M\n79 -12 V\n-46 -58 V\n-78 12 V\n45 58 V\n.8829 g 2364 3088 N 45 57 79
      -9 -46 -58 h\n1.000 UP\n1.000 UL\nLT5\n2364 3088 M\n78 -10 V\n-45 -57
      V\n-79 9 V\n46 58 V\n.8914 g 2442 3078 N 45 56 78 -9 -45 -57 h\n1.000
      UP\n1.000 UL\nLT5\n2442 3078 M\n78 -10 V\n-45 -56 V\n-78 9 V\n45 57
      V\n.8998 g 2520 3068 N 45 56 78 -10 -45 -56 h\n1.000 UP\n1.000
      UL\nLT5\n2520 3068 M\n78 -10 V\n-45 -56 V\n-78 10 V\n45 56 V\n.9067 g
      2598 3058 N 45 57 78 -14 -45 -56 h\n1.000 UP\n1.000 UL\nLT5\n2598 3058
      M\n78 -13 V\n-45 -57 V\n-78 14 V\n45 56 V\n.91 g 2676 3045 N 45 59 78
      -22 -45 -57 h\n1.000 UP\n1.000 UL\nLT5\n2676 3045 M\n78 -20 V\n-45 -59
      V\n-78 22 V\n45 57 V\n.9074 g 2754 3025 N 45 62 78 -33 -45 -59 h\n1.000
      UP\n1.000 UL\nLT5\n2754 3025 M\n78 -30 V\n-45 -62 V\n-78 33 V\n45 59
      V\n.8954 g 2832 2995 N 45 67 78 -50 -45 -62 h\n1.000 UP\n1.000
      UL\nLT5\n2832 2995 M\n78 -45 V\n-45 -67 V\n-78 50 V\n45 62 V\n.87 g
      2910 2950 N 45 74 78 -75 -45 -67 h\n1.000 UP\n1.000 UL\nLT5\n2910 2950
      M\n78 -68 V\n-45 -74 V\n-78 75 V\n45 67 V\n.8259 g 2988 2882 N 45 84 78
      -108 -45 -74 h\n1.000 UP\n1.000 UL\nLT5\n2988 2882 M\n78 -98 V\n-45 -84
      V\n-78 108 V\n45 74 V\n.7569 g 3066 2784 N 45 99 78 -153 -45 -84
      h\n1.000 UP\n1.000 UL\nLT5\n3066 2784 M\n78 -138 V\n-45 -99 V\n-78 153
      V\n45 84 V\n.655 g 3144 2646 N 46 118 78 -209 -45 -99 h\n1.000
      UP\n1.000 UL\nLT5\n3144 2646 M\n79 -190 V\n-46 -118 V\n-78 209 V\n45 99
      V\n.5949 g 913 2978 N 45 134 78 188 -45 -157 h\n1.000 UP\n1.000
      UL\nLT5\n913 2978 M\n78 165 V\n946 3009 L\n868 2821 L\n45 157 V\n.7093
      g 991 3143 N 45 116 78 126 -45 -134 h\n1.000 UP\n1.000 UL\nLT5\n991
      3143 M\n78 108 V\n-45 -116 V\n946 3009 L\n45 134 V\n.7881 g 1069 3251 N
      45 102 78 78 -45 -116 h\n1.000 UP\n1.000 UL\nLT5\n1069 3251 M\n78 64
      V\n-45 -102 V\n-78 -78 V\n45 116 V\n.8393 g 1147 3315 N 45 91 78 42 -45
      -102 h\n1.000 UP\n1.000 UL\nLT5\n1147 3315 M\n78 31 V\n-45 -91 V\n-78
      -42 V\n45 102 V\n.87 g 1225 3346 N 45 83 78 14 -45 -91 h\n1.000
      UP\n1.000 UL\nLT5\n1225 3346 M\n78 6 V\n-45 -83 V\n-78 -14 V\n45 91
      V\n.8855 g 1303 3352 N 45 78 78 -6 -45 -83 h\n1.000 UP\n1.000
      UL\nLT5\n1303 3352 M\n78 -11 V\n-45 -78 V\n-78 6 V\n45 83 V\n.8905 g
      1381 3341 N 45 75 78 -19 -45 -78 h\n1.000 UP\n1.000 UL\nLT5\n1381 3341
      M\n78 -22 V\n-45 -75 V\n-78 19 V\n45 78 V\n.8884 g 1459 3319 N 45 73 78
      -29 -45 -75 h\n1.000 UP\n1.000 UL\nLT5\n1459 3319 M\n78 -31 V\n-45 -73
      V\n-78 29 V\n45 75 V\n.8821 g 1537 3288 N 45 72 79 -33 -45 -73 h\n1.000
      UP\n1.000 UL\nLT5\n1537 3288 M\n79 -34 V\n-45 -72 V\n-79 33 V\n45 73
      V\n.8737 g 1616 3254 N 45 72 78 -35 -45 -72 h\n1.000 UP\n1.000
      UL\nLT5\n1616 3254 M\n78 -35 V\n-45 -72 V\n-78 35 V\n45 72 V\n.865 g
      1694 3219 N 45 71 78 -34 -45 -72 h\n1.000 UP\n1.000 UL\nLT5\n1694 3219
      M\n78 -35 V\n-45 -71 V\n-78 34 V\n45 72 V\n.8571 g 1772 3184 N 45 72 78
      -33 -45 -71 h\n1.000 UP\n1.000 UL\nLT5\n1772 3184 M\n78 -32 V\n-45 -72
      V\n-78 33 V\n45 71 V\n.8509 g 1850 3152 N 45 72 78 -30 -45 -72 h\n1.000
      UP\n1.000 UL\nLT5\n1850 3152 M\n78 -30 V\n-45 -72 V\n-78 30 V\n45 72
      V\n.8469 g 1928 3122 N 45 72 78 -26 -45 -72 h\n1.000 UP\n1.000
      UL\nLT5\n1928 3122 M\n78 -26 V\n-45 -72 V\n-78 26 V\n45 72 V\n.8456 g
      2006 3096 N 45 72 78 -22 -45 -72 h\n1.000 UP\n1.000 UL\nLT5\n2006 3096
      M\n78 -22 V\n-45 -72 V\n-78 22 V\n45 72 V\n.8469 g 2084 3074 N 45 72 78
      -18 -45 -72 h\n1.000 UP\n1.000 UL\nLT5\n2084 3074 M\n78 -18 V\n-45 -72
      V\n-78 18 V\n45 72 V\n.8509 g 2162 3056 N 45 73 78 -15 -45 -72 h\n1.000
      UP\n1.000 UL\nLT5\n2162 3056 M\n78 -14 V\n-45 -73 V\n-78 15 V\n45 72
      V\n.8571 g 2240 3042 N 45 72 78 -11 -45 -73 h\n1.000 UP\n1.000
      UL\nLT5\n2240 3042 M\n78 -12 V\n-45 -72 V\n-78 11 V\n45 73 V\n.865 g
      2318 3030 N 46 72 78 -9 -45 -72 h\n1.000 UP\n1.000 UL\nLT5\n2318 3030
      M\n79 -9 V\n-46 -72 V\n-78 9 V\n45 72 V\n.8737 g 2397 3021 N 45 72 79
      -9 -46 -72 h\n1.000 UP\n1.000 UL\nLT5\n2397 3021 M\n78 -9 V\n-45 -72
      V\n-79 9 V\n46 72 V\n.8821 g 2475 3012 N 45 73 78 -11 -45 -72 h\n1.000
      UP\n1.000 UL\nLT5\n2475 3012 M\n78 -10 V\n-45 -73 V\n-78 11 V\n45 72
      V\n.8884 g 2553 3002 N 45 75 78 -16 -45 -73 h\n1.000 UP\n1.000
      UL\nLT5\n2553 3002 M\n78 -14 V\n-45 -75 V\n-78 16 V\n45 73 V\n.8905 g
      2631 2988 N 45 78 78 -25 -45 -75 h\n1.000 UP\n1.000 UL\nLT5\n2631 2988
      M\n78 -22 V\n-45 -78 V\n-78 25 V\n45 75 V\n.8855 g 2709 2966 N 45 83 78
      -38 -45 -78 h\n1.000 UP\n1.000 UL\nLT5\n2709 2966 M\n78 -33 V\n-45 -83
      V\n-78 38 V\n45 78 V\n.87 g 2787 2933 N 45 91 78 -58 -45 -83 h\n1.000
      UP\n1.000 UL\nLT5\n2787 2933 M\n78 -50 V\n-45 -91 V\n-78 58 V\n45 83
      V\n.8393 g 2865 2883 N 45 102 78 -86 -45 -91 h\n1.000 UP\n1.000
      UL\nLT5\n2865 2883 M\n78 -75 V\n-45 -102 V\n-78 86 V\n45 91 V\n.7881 g
      2943 2808 N 45 116 78 -122 -45 -102 h\n1.000 UP\n1.000 UL\nLT5\n2943
      2808 M\n78 -108 V\n-45 -116 V\n-78 122 V\n45 102 V\n.7093 g 3021 2700 N
      45 134 78 -171 -45 -116 h\n1.000 UP\n1.000 UL\nLT5\n3021 2700 M\n78
      -153 V\n-45 -134 V\n-78 171 V\n45 116 V\n.5949 g 3099 2547 N 45 157 78
      -232 -45 -134 h\n1.000 UP\n1.000 UL\nLT5\n3099 2547 M\n78 -209 V\n-45
      -157 V\n-78 232 V\n45 134 V\n.5059 g 868 2821 N 45 180 78 216 -45 -208
      h\n1.000 UP\n1.000 UL\nLT5\n868 2821 M\n78 188 V\n901 2829 L\n823 2613
      L\n45 208 V\n.6361 g 946 3009 N 45 156 78 150 -45 -180 h\n1.000
      UP\n1.000 UL\nLT5\n946 3009 M\n78 126 V\n979 2979 L\n901 2829 L\n45 180
      V\n.7272 g 1024 3135 N 45 138 78 96 -45 -156 h\n1.000 UP\n1.000
      UL\nLT5\n1024 3135 M\n78 78 V\n-45 -138 V\n-78 -96 V\n45 156 V\n.7881 g
      1102 3213 N 45 125 78 55 -45 -138 h\n1.000 UP\n1.000 UL\nLT5\n1102 3213
      M\n78 42 V\n-45 -125 V\n-78 -55 V\n45 138 V\n.8259 g 1180 3255 N 45 114
      78 25 -45 -125 h\n1.000 UP\n1.000 UL\nLT5\n1180 3255 M\n78 14 V\n-45
      -114 V\n-78 -25 V\n45 125 V\n.8468 g 1258 3269 N 45 106 78 2 -45 -114
      h\n1.000 UP\n1.000 UL\nLT5\n1258 3269 M\n78 -6 V\n-45 -106 V\n-78 -2
      V\n45 114 V\n.8554 g 1336 3263 N 45 101 78 -14 -45 -106 h\n1.000
      UP\n1.000 UL\nLT5\n1336 3263 M\n78 -19 V\n-45 -101 V\n-78 14 V\n45 106
      V\n.8558 g 1414 3244 N 45 96 78 -24 -45 -101 h\n1.000 UP\n1.000
      UL\nLT5\n1414 3244 M\n78 -29 V\n-45 -96 V\n-78 24 V\n45 101 V\n.8511 g
      1492 3215 N 46 94 78 -31 -45 -96 h\n1.000 UP\n1.000 UL\nLT5\n1492 3215
      M\n79 -33 V\n-46 -94 V\n-78 31 V\n45 96 V\n.8436 g 1571 3182 N 45 92 79
      -33 -46 -94 h\n1.000 UP\n1.000 UL\nLT5\n1571 3182 M\n78 -35 V\n-45 -92
      V\n-79 33 V\n46 94 V\n.8353 g 1649 3147 N 45 92 78 -34 -45 -92 h\n1.000
      UP\n1.000 UL\nLT5\n1649 3147 M\n78 -34 V\n-45 -92 V\n-78 34 V\n45 92
      V\n.8276 g 1727 3113 N 45 92 78 -33 -45 -92 h\n1.000 UP\n1.000
      UL\nLT5\n1727 3113 M\n78 -33 V\n-45 -92 V\n-78 33 V\n45 92 V\n.8213 g
      1805 3080 N 45 91 78 -29 -45 -92 h\n1.000 UP\n1.000 UL\nLT5\n1805 3080
      M\n78 -30 V\n-45 -91 V\n-78 29 V\n45 92 V\n.8174 g 1883 3050 N 45 92 78
      -27 -45 -91 h\n1.000 UP\n1.000 UL\nLT5\n1883 3050 M\n78 -26 V\n-45 -92
      V\n-78 27 V\n45 91 V\n.816 g 1961 3024 N 45 92 78 -22 -45 -92 h\n1.000
      UP\n1.000 UL\nLT5\n1961 3024 M\n78 -22 V\n-45 -92 V\n-78 22 V\n45 92
      V\n.8174 g 2039 3002 N 45 92 78 -18 -45 -92 h\n1.000 UP\n1.000
      UL\nLT5\n2039 3002 M\n78 -18 V\n-45 -92 V\n-78 18 V\n45 92 V\n.8213 g
      2117 2984 N 45 91 78 -14 -45 -92 h\n1.000 UP\n1.000 UL\nLT5\n2117 2984
      M\n78 -15 V\n-45 -91 V\n-78 14 V\n45 92 V\n.8276 g 2195 2969 N 45 92 78
      -12 -45 -91 h\n1.000 UP\n1.000 UL\nLT5\n2195 2969 M\n78 -11 V\n-45 -92
      V\n-78 12 V\n45 91 V\n.8353 g 2273 2958 N 45 93 78 -10 -45 -92 h\n1.000
      UP\n1.000 UL\nLT5\n2273 2958 M\n78 -9 V\n-45 -93 V\n-78 10 V\n45 92
      V\n.8436 g 2351 2949 N 46 94 78 -10 -45 -93 h\n1.000 UP\n1.000
      UL\nLT5\n2351 2949 M\n79 -9 V\n-46 -94 V\n-78 10 V\n45 93 V\n.8511 g
      2430 2940 N 45 97 79 -14 -46 -94 h\n1.000 UP\n1.000 UL\nLT5\n2430 2940
      M\n78 -11 V\n-45 -97 V\n-79 14 V\n46 94 V\n.8558 g 2508 2929 N 45 101
      78 -20 -45 -97 h\n1.000 UP\n1.000 UL\nLT5\n2508 2929 M\n78 -16 V\n-45
      -101 V\n-78 20 V\n45 97 V\n.8554 g 2586 2913 N 45 106 78 -30 -45 -101
      h\n1.000 UP\n1.000 UL\nLT5\n2586 2913 M\n78 -25 V\n-45 -106 V\n-78 30
      V\n45 101 V\n.8468 g 2664 2888 N 45 114 78 -46 -45 -106 h\n1.000
      UP\n1.000 UL\nLT5\n2664 2888 M\n78 -38 V\n-45 -114 V\n-78 46 V\n45 106
      V\n.8259 g 2742 2850 N 45 125 78 -69 -45 -114 h\n1.000 UP\n1.000
      UL\nLT5\n2742 2850 M\n78 -58 V\n-45 -125 V\n-78 69 V\n45 114 V\n.7881 g
      2820 2792 N 45 138 78 -99 -45 -125 h\n1.000 UP\n1.000 UL\nLT5\n2820
      2792 M\n78 -86 V\n-45 -138 V\n-78 99 V\n45 125 V\n.7272 g 2898 2706 N
      45 157 78 -141 -45 -138 h\n1.000 UP\n1.000 UL\nLT5\n2898 2706 M\n78
      -122 V\n-45 -157 V\n-78 141 V\n45 138 V\n.6361 g 2976 2584 N 45 179 78
      -193 -45 -157 h\n1.000 UP\n1.000 UL\nLT5\n2976 2584 M\n78 -171 V\n-45
      -179 V\n-78 193 V\n45 157 V\n.5059 g 3054 2413 N 45 208 78 -261 -45
      -179 h\n1.000 UP\n1.000 UL\nLT5\n3054 2413 M\n78 -232 V\n-45 -208
      V\n-78 261 V\n45 179 V\n.3798 g 823 2613 N 45 238 78 251 -45 -273
      h\n1.000 UP\n1.000 UL\nLT5\n823 2613 M\n78 216 V\n856 2591 L\n778 2340
      L\n45 273 V\n.5293 g 901 2829 N 45 210 78 178 -45 -238 h\n1.000
      UP\n1.000 UL\nLT5\n901 2829 M\n78 150 V\n934 2769 L\n856 2591 L\n45 238
      V\n.6361 g 979 2979 N 45 187 78 119 -45 -210 h\n1.000 UP\n1.000
      UL\nLT5\n979 2979 M\n78 96 V\n-45 -187 V\n934 2769 L\n45 210 V\n.7093 g
      1057 3075 N 45 168 78 74 -45 -187 h\n1.000 UP\n1.000 UL\nLT5\n1057 3075
      M\n78 55 V\n-45 -168 V\n-78 -74 V\n45 187 V\n.7569 g 1135 3130 N 45 154
      78 39 -45 -168 h\n1.000 UP\n1.000 UL\nLT5\n1135 3130 M\n78 25 V\n-45
      -154 V\n-78 -39 V\n45 168 V\n.7851 g 1213 3155 N 45 143 78 13 -45 -154
      h\n1.000 UP\n1.000 UL\nLT5\n1213 3155 M\n78 2 V\n-45 -143 V\n-78 -13
      V\n45 154 V\n.7993 g 1291 3157 N 45 135 78 -6 -45 -143 h\n1.000
      UP\n1.000 UL\nLT5\n1291 3157 M\n78 -14 V\n-45 -135 V\n-78 6 V\n45 143
      V\n.8037 g 1369 3143 N 45 129 78 -18 -45 -135 h\n1.000 UP\n1.000
      UL\nLT5\n1369 3143 M\n78 -24 V\n-45 -129 V\n-78 18 V\n45 135 V\n.8017 g
      1447 3119 N 45 124 78 -26 -45 -129 h\n1.000 UP\n1.000 UL\nLT5\n1447
      3119 M\n78 -31 V\n-45 -124 V\n-78 26 V\n45 129 V\n.7962 g 1525 3088 N
      46 122 78 -31 -45 -124 h\n1.000 UP\n1.000 UL\nLT5\n1525 3088 M\n79 -33
      V\n-46 -122 V\n-78 31 V\n45 124 V\n.7891 g 1604 3055 N 45 120 79 -32
      -46 -122 h\n1.000 UP\n1.000 UL\nLT5\n1604 3055 M\n78 -34 V\n-45 -120
      V\n-79 32 V\n46 122 V\n.7821 g 1682 3021 N 45 118 78 -31 -45 -120
      h\n1.000 UP\n1.000 UL\nLT5\n1682 3021 M\n78 -33 V\n-45 -118 V\n-78 31
      V\n45 120 V\n.7763 g 1760 2988 N 45 118 78 -29 -45 -118 h\n1.000
      UP\n1.000 UL\nLT5\n1760 2988 M\n78 -29 V\n-45 -118 V\n-78 29 V\n45 118
      V\n.7726 g 1838 2959 N 45 117 78 -26 -45 -118 h\n1.000 UP\n1.000
      UL\nLT5\n1838 2959 M\n78 -27 V\n-45 -117 V\n-78 26 V\n45 118 V\n.7712 g
      1916 2932 N 45 117 78 -22 -45 -117 h\n1.000 UP\n1.000 UL\nLT5\n1916
      2932 M\n78 -22 V\n-45 -117 V\n-78 22 V\n45 117 V\n.7726 g 1994 2910 N
      45 117 78 -18 -45 -117 h\n1.000 UP\n1.000 UL\nLT5\n1994 2910 M\n78 -18
      V\n-45 -117 V\n-78 18 V\n45 117 V\n.7763 g 2072 2892 N 45 118 78 -15
      -45 -117 h\n1.000 UP\n1.000 UL\nLT5\n2072 2892 M\n78 -14 V\n-45 -118
      V\n-78 15 V\n45 117 V\n.7821 g 2150 2878 N 45 119 78 -13 -45 -118
      h\n1.000 UP\n1.000 UL\nLT5\n2150 2878 M\n78 -12 V\n-45 -119 V\n-78 13
      V\n45 118 V\n.7891 g 2228 2866 N 45 121 78 -12 -45 -119 h\n1.000
      UP\n1.000 UL\nLT5\n2228 2866 M\n78 -10 V\n-45 -121 V\n-78 12 V\n45 119
      V\n.7962 g 2306 2856 N 45 125 78 -14 -45 -121 h\n1.000 UP\n1.000
      UL\nLT5\n2306 2856 M\n78 -10 V\n-45 -125 V\n-78 14 V\n45 121 V\n.8017 g
      2384 2846 N 46 129 78 -18 -45 -125 h\n1.000 UP\n1.000 UL\nLT5\n2384
      2846 M\n79 -14 V\n-46 -129 V\n-78 18 V\n45 125 V\n.8037 g 2463 2832 N
      45 135 79 -26 -46 -129 h\n1.000 UP\n1.000 UL\nLT5\n2463 2832 M\n78 -20
      V\n-45 -135 V\n-79 26 V\n46 129 V\n.7993 g 2541 2812 N 45 143 78 -38
      -45 -135 h\n1.000 UP\n1.000 UL\nLT5\n2541 2812 M\n78 -30 V\n-45 -143
      V\n-78 38 V\n45 135 V\n.7851 g 2619 2782 N 45 154 78 -57 -45 -143
      h\n1.000 UP\n1.000 UL\nLT5\n2619 2782 M\n78 -46 V\n-45 -154 V\n-78 57
      V\n45 143 V\n.7569 g 2697 2736 N 45 168 78 -83 -45 -154 h\n1.000
      UP\n1.000 UL\nLT5\n2697 2736 M\n78 -69 V\n-45 -168 V\n-78 83 V\n45 154
      V\n.7093 g 2775 2667 N 45 187 78 -118 -45 -168 h\n1.000 UP\n1.000
      UL\nLT5\n2775 2667 M\n78 -99 V\n-45 -187 V\n-78 118 V\n45 168 V\n.6361
      g 2853 2568 N 45 209 78 -163 -45 -187 h\n1.000 UP\n1.000 UL\nLT5\n2853
      2568 M\n78 -141 V\n-45 -209 V\n-78 163 V\n45 187 V\n.5293 g 2931 2427 N
      45 238 78 -222 -45 -209 h\n1.000 UP\n1.000 UL\nLT5\n2931 2427 M\n78
      -193 V\n-45 -238 V\n-78 222 V\n45 209 V\n.3798 g 3009 2234 N 45 273 78
      -296 -45 -238 h\n1.000 UP\n1.000 UL\nLT5\n3009 2234 M\n78 -261 V\n-45
      -273 V\n-78 296 V\n45 238 V\n.2065 g 778 2340 N 45 311 79 294 -46 -354
      h\n1.000 UP\n1.000 UL\nLT5\n778 2340 M\n78 251 V\n811 2280 L\n732 1986
      L\n46 354 V\n.3798 g 856 2591 N 45 277 78 212 -45 -311 h\n1.000
      UP\n1.000 UL\nLT5\n856 2591 M\n78 178 V\n889 2492 L\n811 2280 L\n45 311
      V\n.5059 g 934 2769 N 45 248 78 148 -45 -277 h\n1.000 UP\n1.000
      UL\nLT5\n934 2769 M\n78 119 V\n967 2640 L\n889 2492 L\n45 277 V\n.5949
      g 1012 2888 N 45 225 78 97 -45 -248 h\n1.000 UP\n1.000 UL\nLT5\n1012
      2888 M\n78 74 V\n-45 -225 V\n-78 -97 V\n45 248 V\n.655 g 1090 2962 N 45
      207 78 57 -45 -225 h\n1.000 UP\n1.000 UL\nLT5\n1090 2962 M\n78 39
      V\n-45 -207 V\n-78 -57 V\n45 225 V\n.6931 g 1168 3001 N 45 192 78 28
      -45 -207 h\n1.000 UP\n1.000 UL\nLT5\n1168 3001 M\n78 13 V\n-45 -192
      V\n-78 -28 V\n45 207 V\n.7149 g 1246 3014 N 45 181 78 5 -45 -192
      h\n1.000 UP\n1.000 UL\nLT5\n1246 3014 M\n78 -6 V\n-45 -181 V\n-78 -5
      V\n45 192 V\n.7251 g 1324 3008 N 45 172 78 -9 -45 -181 h\n1.000
      UP\n1.000 UL\nLT5\n1324 3008 M\n78 -18 V\n-45 -172 V\n-78 9 V\n45 181
      V\n.7276 g 1402 2990 N 45 166 78 -20 -45 -172 h\n1.000 UP\n1.000
      UL\nLT5\n1402 2990 M\n78 -26 V\n-45 -166 V\n-78 20 V\n45 172 V\n.7252 g
      1480 2964 N 45 161 78 -26 -45 -166 h\n1.000 UP\n1.000 UL\nLT5\n1480
      2964 M\n78 -31 V\n-45 -161 V\n-78 26 V\n45 166 V\n.7204 g 1558 2933 N
      46 157 78 -28 -45 -161 h\n1.000 UP\n1.000 UL\nLT5\n1558 2933 M\n79 -32
      V\n-46 -157 V\n-78 28 V\n45 161 V\n.7149 g 1637 2901 N 45 155 79 -29
      -46 -157 h\n1.000 UP\n1.000 UL\nLT5\n1637 2901 M\n78 -31 V\n-45 -155
      V\n-79 29 V\n46 157 V\n.7101 g 1715 2870 N 45 153 78 -27 -45 -155
      h\n1.000 UP\n1.000 UL\nLT5\n1715 2870 M\n78 -29 V\n-45 -153 V\n-78 27
      V\n45 155 V\n.7068 g 1793 2841 N 45 153 78 -26 -45 -153 h\n1.000
      UP\n1.000 UL\nLT5\n1793 2841 M\n78 -26 V\n-45 -153 V\n-78 26 V\n45 153
      V\n.7057 g 1871 2815 N 45 153 78 -22 -45 -153 h\n1.000 UP\n1.000
      UL\nLT5\n1871 2815 M\n78 -22 V\n-45 -153 V\n-78 22 V\n45 153 V\n.7068 g
      1949 2793 N 45 154 78 -19 -45 -153 h\n1.000 UP\n1.000 UL\nLT5\n1949
      2793 M\n78 -18 V\n-45 -154 V\n-78 19 V\n45 153 V\n.7101 g 2027 2775 N
      45 155 78 -16 -45 -154 h\n1.000 UP\n1.000 UL\nLT5\n2027 2775 M\n78 -15
      V\n-45 -155 V\n-78 16 V\n45 154 V\n.7149 g 2105 2760 N 45 157 78 -15
      -45 -155 h\n1.000 UP\n1.000 UL\nLT5\n2105 2760 M\n78 -13 V\n-45 -157
      V\n-78 15 V\n45 155 V\n.7204 g 2183 2747 N 45 161 78 -16 -45 -157
      h\n1.000 UP\n1.000 UL\nLT5\n2183 2747 M\n78 -12 V\n-45 -161 V\n-78 16
      V\n45 157 V\n.7252 g 2261 2735 N 45 165 78 -18 -45 -161 h\n1.000
      UP\n1.000 UL\nLT5\n2261 2735 M\n78 -14 V\n-45 -165 V\n-78 18 V\n45 161
      V\n.7276 g 2339 2721 N 45 172 78 -25 -45 -165 h\n1.000 UP\n1.000
      UL\nLT5\n2339 2721 M\n78 -18 V\n-45 -172 V\n-78 25 V\n45 165 V\n.7251 g
      2417 2703 N 46 180 78 -34 -45 -172 h\n1.000 UP\n1.000 UL\nLT5\n2417
      2703 M\n79 -26 V\n-46 -180 V\n-78 34 V\n45 172 V\n.7149 g 2496 2677 N
      45 192 79 -50 -46 -180 h\n1.000 UP\n1.000 UL\nLT5\n2496 2677 M\n78 -38
      V\n-45 -192 V\n-79 50 V\n46 180 V\n.6931 g 2574 2639 N 45 207 78 -72
      -45 -192 h\n1.000 UP\n1.000 UL\nLT5\n2574 2639 M\n78 -57 V\n-45 -207
      V\n-78 72 V\n45 192 V\n.655 g 2652 2582 N 45 225 78 -101 -45 -207
      h\n1.000 UP\n1.000 UL\nLT5\n2652 2582 M\n78 -83 V\n-45 -225 V\n-78 101
      V\n45 207 V\n.5949 g 2730 2499 N 45 248 78 -141 -45 -225 h\n1.000
      UP\n1.000 UL\nLT5\n2730 2499 M\n78 -118 V\n-45 -248 V\n-78 141 V\n45
      225 V\n.5059 g 2808 2381 N 45 277 78 -192 -45 -248 h\n1.000 UP\n1.000
      UL\nLT5\n2808 2381 M\n78 -163 V\n-45 -277 V\n-78 192 V\n45 248 V\n.3798
      g 2886 2218 N 45 312 78 -257 -45 -277 h\n1.000 UP\n1.000 UL\nLT5\n2886
      2218 M\n78 -222 V\n-45 -312 V\n-78 257 V\n45 277 V\n.2065 g 2964 1996 N
      45 353 78 -337 -45 -312 h\n1.000 UP\n1.000 UL\nLT5\n2964 1996 M\n78
      -296 V\n-45 -353 V\n-78 337 V\n45 312 V\n%pm3d_map_end\ngrestore %
      colour palette end\nstroke gsave\t%% draw gray scale smooth
      box\nmaxcolors 0 gt {/imax maxcolors def} {/imax 1024 def} ifelse\n4373
      2214 translate 181 1647 scale 0 setlinewidth\n/ystep 1 imax div def /y0
      0 def /ii 0 def\n{ y0 g 0 y0 N 1 0 V 0 ystep V -1 0 f\n/y0 y0 ystep add
      def /ii ii 1 add def\nii imax ge {exit} if } loop\ngrestore 0
      setgray\n1.000 UL\nLTb\n4373 2214 M\n181 0 V\n0 1647 V\n-181 0 V\n0
      -1647 V\n1.000 UL\nLTb\n1.000 UL\nLTb\n4554 2214 M\n-63 0 V\n
      stroke\n4656 2214 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 (-4)]\n] -46.7 MLshow\ngrestore\n4373 2214 M\n63 0 V\n118 183
      R\n-63 0 V\n stroke\n4656 2397 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 (-3.5)]\n] -46.7 MLshow\ngrestore\n4373 2397 M\n63 0
      V\n118 183 R\n-63 0 V\n stroke\n4656 2580 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 (-3)]\n] -46.7
      MLshow\ngrestore\n4373 2580 M\n63 0 V\n118 183 R\n-63 0 V\n
      stroke\n4656 2763 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 (-2.5)]\n] -46.7 MLshow\ngrestore\n4373 2763 M\n63 0 V\n118 183
      R\n-63 0 V\n stroke\n4656 2946 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 (-2)]\n] -46.7 MLshow\ngrestore\n4373 2946 M\n63 0
      V\n118 183 R\n-63 0 V\n stroke\n4656 3129 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 (-1.5)]\n] -46.7
      MLshow\ngrestore\n4373 3129 M\n63 0 V\n118 183 R\n-63 0 V\n
      stroke\n4656 3312 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 (-1)]\n] -46.7 MLshow\ngrestore\n4373 3312 M\n63 0 V\n118 183
      R\n-63 0 V\n stroke\n4656 3495 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 (-0.5)]\n] -46.7 MLshow\ngrestore\n4373 3495 M\n63 0
      V\n118 183 R\n-63 0 V\n stroke\n4656 3678 M\ngsave 0 setgray\n[
      [(Helvetica) 140.0 0.0 true true 0 ( 0)]\n] -46.7
      MLshow\ngrestore\n4373 3678 M\n63 0 V\n118 183 R\n-63 0 V\n
      stroke\n4656 3861 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 ( 0.5)]\n] -46.7 MLshow\ngrestore\n4373 3861 M\n63 0 V\n1.000
      UP\n1.000 UL\nLT1\nLT1\n733 1987 M\n1.000 UL\nLT1\nLT1\n812 2281
      M\n1.000 UL\nLT1\nLT1\n890 2493 M\n1.000 UL\nLT1\nLT1\n968 2640
      M\n1.000 UL\nLT1\nLT1\n1046 2737 M\n1.000 UL\nLT1\nLT1\n1124 2794
      M\n1.000 UL\nLT1\nLT1\n1202 2822 M\n1.000 UL\nLT1\nLT1\n1280 2827
      M\n1.000 UL\nLT1\nLT1\n1358 2818 M\n1.000 UL\nLT1\nLT1\n1436 2798
      M\n1.000 UL\nLT1\nLT1\n1514 2772 M\n1.000 UL\nLT1\nLT1\n1592 2744
      M\n1.000 UL\nLT1\nLT1\n1671 2715 M\n1.000 UL\nLT1\nLT1\n1749 2688
      M\n1.000 UL\nLT1\nLT1\n1827 2662 M\n1.000 UL\nLT1\nLT1\n1905 2640
      M\n1.000 UL\nLT1\nLT1\n1983 2621 M\n1.000 UL\nLT1\nLT1\n2061 2605
      M\n1.000 UL\nLT1\nLT1\n2139 2590 M\n1.000 UL\nLT1\nLT1\n2217 2575
      M\n1.000 UL\nLT1\nLT1\n2295 2557 M\n1.000 UL\nLT1\nLT1\n2373 2532
      M\n1.000 UL\nLT1\nLT1\n2451 2498 M\n1.000 UL\nLT1\nLT1\n2529 2448
      M\n1.000 UL\nLT1\nLT1\n2607 2376 M\n1.000 UL\nLT1\nLT1\n2685 2275
      M\n1.000 UL\nLT1\nLT1\n2763 2134 M\n1.000 UL\nLT1\nLT1\n2841 1942
      M\n1.000 UL\nLT1\nLT1\n2919 1685 M\n1.000 UL\nLT1\nLT1\n2997 1348
      M\n1.000 UL\nLT1\nLT1\n779 2341 M\n1.000 UL\nLT1\nLT1\n857 2591
      M\n1.000 UL\nLT1\nLT1\n935 2769 M\n1.000 UL\nLT1\nLT1\n1013 2888
      M\n1.000 UL\nLT1\nLT1\n1091 2962 M\n1.000 UL\nLT1\nLT1\n1169 3001
      M\n1.000 UL\nLT1\nLT1\n1247 3014 M\n1.000 UL\nLT1\nLT1\n1325 3008
      M\n1.000 UL\nLT1\nLT1\n1403 2990 M\n1.000 UL\nLT1\nLT1\n1481 2964
      M\n1.000 UL\nLT1\nLT1\n1559 2933 M\n1.000 UL\nLT1\nLT1\n1638 2901
      M\n1.000 UL\nLT1\nLT1\n1716 2870 M\n1.000 UL\nLT1\nLT1\n1794 2841
      M\n1.000 UL\nLT1\nLT1\n1872 2815 M\n1.000 UL\nLT1\nLT1\n1950 2793
      M\n1.000 UL\nLT1\nLT1\n2028 2775 M\n1.000 UL\nLT1\nLT1\n2106 2760
      M\n1.000 UL\nLT1\nLT1\n2184 2747 M\n1.000 UL\nLT1\nLT1\n2262 2735
      M\n1.000 UL\nLT1\nLT1\n2340 2721 M\n1.000 UL\nLT1\nLT1\n2418 2703
      M\n1.000 UL\nLT1\nLT1\n2497 2677 M\n1.000 UL\nLT1\nLT1\n2574 2639
      M\n1.000 UL\nLT1\nLT1\n2652 2583 M\n1.000 UL\nLT1\nLT1\n2730 2500
      M\n1.000 UL\nLT1\nLT1\n2808 2382 M\n1.000 UL\nLT1\nLT1\n2886 2219
      M\n1.000 UL\nLT1\nLT1\n2964 1997 M\n1.000 UL\nLT1\nLT1\n3042 1701
      M\n1.000 UL\nLT1\nLT1\n824 2613 M\n1.000 UL\nLT1\nLT1\n902 2829
      M\n1.000 UL\nLT1\nLT1\n980 2979 M\n1.000 UL\nLT1\nLT1\n1058 3075
      M\n1.000 UL\nLT1\nLT1\n1136 3130 M\n1.000 UL\nLT1\nLT1\n1214 3155
      M\n1.000 UL\nLT1\nLT1\n1292 3157 M\n1.000 UL\nLT1\nLT1\n1370 3143
      M\n1.000 UL\nLT1\nLT1\n1448 3119 M\n1.000 UL\nLT1\nLT1\n1526 3088
      M\n1.000 UL\nLT1\nLT1\n1605 3055 M\n1.000 UL\nLT1\nLT1\n1683 3021
      M\n1.000 UL\nLT1\nLT1\n1761 2988 M\n1.000 UL\nLT1\nLT1\n1839 2959
      M\n1.000 UL\nLT1\nLT1\n1917 2932 M\n1.000 UL\nLT1\nLT1\n1995 2910
      M\n1.000 UL\nLT1\nLT1\n2073 2892 M\n1.000 UL\nLT1\nLT1\n2151 2878
      M\n1.000 UL\nLT1\nLT1\n2229 2866 M\n1.000 UL\nLT1\nLT1\n2307 2856
      M\n1.000 UL\nLT1\nLT1\n2385 2846 M\n1.000 UL\nLT1\nLT1\n2464 2832
      M\n1.000 UL\nLT1\nLT1\n2541 2812 M\n1.000 UL\nLT1\nLT1\n2619 2782
      M\n1.000 UL\nLT1\nLT1\n2697 2736 M\n1.000 UL\nLT1\nLT1\n2775 2667
      M\n1.000 UL\nLT1\nLT1\n2853 2569 M\n1.000 UL\nLT1\nLT1\n2931 2428
      M\n1.000 UL\nLT1\nLT1\n3009 2235 M\n1.000 UL\nLT1\nLT1\n3087 1974
      M\n1.000 UL\nLT1\nLT1\n869 2821 M\n1.000 UL\nLT1\nLT1\n947 3009
      M\n1.000 UL\nLT1\nLT1\n1025 3135 M\n1.000 UL\nLT1\nLT1\n1103 3213
      M\n1.000 UL\nLT1\nLT1\n1181 3255 M\n1.000 UL\nLT1\nLT1\n1259 3269
      M\n1.000 UL\nLT1\nLT1\n1337 3263 M\n1.000 UL\nLT1\nLT1\n1415 3244
      M\n1.000 UL\nLT1\nLT1\n1493 3215 M\n1.000 UL\nLT1\nLT1\n1572 3182
      M\n1.000 UL\nLT1\nLT1\n1650 3147 M\n1.000 UL\nLT1\nLT1\n1728 3113
      M\n1.000 UL\nLT1\nLT1\n1806 3080 M\n1.000 UL\nLT1\nLT1\n1884 3050
      M\n1.000 UL\nLT1\nLT1\n1962 3024 M\n1.000 UL\nLT1\nLT1\n2040 3002
      M\n1.000 UL\nLT1\nLT1\n2118 2984 M\n1.000 UL\nLT1\nLT1\n2196 2969
      M\n1.000 UL\nLT1\nLT1\n2274 2958 M\n1.000 UL\nLT1\nLT1\n2352 2949
      M\n1.000 UL\nLT1\nLT1\n2431 2940 M\n1.000 UL\nLT1\nLT1\n2509 2929
      M\n1.000 UL\nLT1\nLT1\n2586 2913 M\n1.000 UL\nLT1\nLT1\n2664 2888
      M\n1.000 UL\nLT1\nLT1\n2742 2850 M\n1.000 UL\nLT1\nLT1\n2820 2792
      M\n1.000 UL\nLT1\nLT1\n2898 2706 M\n1.000 UL\nLT1\nLT1\n2976 2585
      M\n1.000 UL\nLT1\nLT1\n3054 2414 M\n1.000 UL\nLT1\nLT1\n3132 2182
      M\n1.000 UL\nLT1\nLT1\n914 2978 M\n1.000 UL\nLT1\nLT1\n992 3143
      M\n1.000 UL\nLT1\nLT1\n1070 3251 M\n1.000 UL\nLT1\nLT1\n1148 3315
      M\n1.000 UL\nLT1\nLT1\n1226 3346 M\n1.000 UL\nLT1\nLT1\n1304 3352
      M\n1.000 UL\nLT1\nLT1\n1382 3341 M\n1.000 UL\nLT1\nLT1\n1460 3319
      M\n1.000 UL\nLT1\nLT1\n1538 3288 M\n1.000 UL\nLT1\nLT1\n1617 3254
      M\n1.000 UL\nLT1\nLT1\n1695 3219 M\n1.000 UL\nLT1\nLT1\n1773 3184
      M\n1.000 UL\nLT1\nLT1\n1851 3152 M\n1.000 UL\nLT1\nLT1\n1929 3122
      M\n1.000 UL\nLT1\nLT1\n2007 3096 M\n1.000 UL\nLT1\nLT1\n2085 3074
      M\n1.000 UL\nLT1\nLT1\n2163 3056 M\n1.000 UL\nLT1\nLT1\n2241 3042
      M\n1.000 UL\nLT1\nLT1\n2319 3030 M\n1.000 UL\nLT1\nLT1\n2398 3021
      M\n1.000 UL\nLT1\nLT1\n2476 3012 M\n1.000 UL\nLT1\nLT1\n2553 3002
      M\n1.000 UL\nLT1\nLT1\n2631 2988 M\n1.000 UL\nLT1\nLT1\n2709 2966
      M\n1.000 UL\nLT1\nLT1\n2787 2933 M\n1.000 UL\nLT1\nLT1\n2865 2883
      M\n1.000 UL\nLT1\nLT1\n2943 2808 M\n1.000 UL\nLT1\nLT1\n3021 2700
      M\n1.000 UL\nLT1\nLT1\n3099 2548 M\n1.000 UL\nLT1\nLT1\n3177 2339
      M\n1.000 UL\nLT1\nLT1\n959 3095 M\n1.000 UL\nLT1\nLT1\n1037 3242
      M\n1.000 UL\nLT1\nLT1\n1115 3336 M\n1.000 UL\nLT1\nLT1\n1193 3389
      M\n1.000 UL\nLT1\nLT1\n1271 3413 M\n1.000 UL\nLT1\nLT1\n1349 3414
      M\n1.000 UL\nLT1\nLT1\n1427 3400 M\n1.000 UL\nLT1\nLT1\n1505 3375
      M\n1.000 UL\nLT1\nLT1\n1584 3345 M\n1.000 UL\nLT1\nLT1\n1662 3311
      M\n1.000 UL\nLT1\nLT1\n1740 3276 M\n1.000 UL\nLT1\nLT1\n1818 3242
      M\n1.000 UL\nLT1\nLT1\n1896 3210 M\n1.000 UL\nLT1\nLT1\n1974 3181
      M\n1.000 UL\nLT1\nLT1\n2052 3156 M\n1.000 UL\nLT1\nLT1\n2130 3134
      M\n1.000 UL\nLT1\nLT1\n2208 3115 M\n1.000 UL\nLT1\nLT1\n2286 3100
      M\n1.000 UL\nLT1\nLT1\n2365 3088 M\n1.000 UL\nLT1\nLT1\n2443 3078
      M\n1.000 UL\nLT1\nLT1\n2520 3068 M\n1.000 UL\nLT1\nLT1\n2598 3058
      M\n1.000 UL\nLT1\nLT1\n2676 3045 M\n1.000 UL\nLT1\nLT1\n2754 3025
      M\n1.000 UL\nLT1\nLT1\n2832 2995 M\n1.000 UL\nLT1\nLT1\n2910 2950
      M\n1.000 UL\nLT1\nLT1\n2988 2882 M\n1.000 UL\nLT1\nLT1\n3066 2784
      M\n1.000 UL\nLT1\nLT1\n3144 2646 M\n1.000 UL\nLT1\nLT1\n3223 2457
      M\n1.000 UL\nLT1\nLT1\n1004 3183 M\n1.000 UL\nLT1\nLT1\n1082 3315
      M\n1.000 UL\nLT1\nLT1\n1160 3398 M\n1.000 UL\nLT1\nLT1\n1238 3444
      M\n1.000 UL\nLT1\nLT1\n1316 3462 M\n1.000 UL\nLT1\nLT1\n1394 3460
      M\n1.000 UL\nLT1\nLT1\n1472 3444 M\n1.000 UL\nLT1\nLT1\n1551 3420
      M\n1.000 UL\nLT1\nLT1\n1629 3389 M\n1.000 UL\nLT1\nLT1\n1707 3357
      M\n1.000 UL\nLT1\nLT1\n1785 3323 M\n1.000 UL\nLT1\nLT1\n1863 3291
      M\n1.000 UL\nLT1\nLT1\n1941 3260 M\n1.000 UL\nLT1\nLT1\n2019 3232
      M\n1.000 UL\nLT1\nLT1\n2097 3207 M\n1.000 UL\nLT1\nLT1\n2175 3184
      M\n1.000 UL\nLT1\nLT1\n2253 3166 M\n1.000 UL\nLT1\nLT1\n2331 3150
      M\n1.000 UL\nLT1\nLT1\n2410 3136 M\n1.000 UL\nLT1\nLT1\n2488 3125
      M\n1.000 UL\nLT1\nLT1\n2565 3114 M\n1.000 UL\nLT1\nLT1\n2643 3103
      M\n1.000 UL\nLT1\nLT1\n2721 3089 M\n1.000 UL\nLT1\nLT1\n2799 3069
      M\n1.000 UL\nLT1\nLT1\n2877 3041 M\n1.000 UL\nLT1\nLT1\n2955 2999
      M\n1.000 UL\nLT1\nLT1\n3033 2937 M\n1.000 UL\nLT1\nLT1\n3111 2847
      M\n1.000 UL\nLT1\nLT1\n3190 2720 M\n1.000 UL\nLT1\nLT1\n3268 2545
      M\n1.000 UL\nLT1\nLT1\n1049 3249 M\n1.000 UL\nLT1\nLT1\n1127 3370
      M\n1.000 UL\nLT1\nLT1\n1205 3444 M\n1.000 UL\nLT1\nLT1\n1283 3485
      M\n1.000 UL\nLT1\nLT1\n1361 3499 M\n1.000 UL\nLT1\nLT1\n1439 3496
      M\n1.000 UL\nLT1\nLT1\n1518 3480 M\n1.000 UL\nLT1\nLT1\n1596 3456
      M\n1.000 UL\nLT1\nLT1\n1674 3427 M\n1.000 UL\nLT1\nLT1\n1752 3396
      M\n1.000 UL\nLT1\nLT1\n1830 3364 M\n1.000 UL\nLT1\nLT1\n1908 3333
      M\n1.000 UL\nLT1\nLT1\n1986 3304 M\n1.000 UL\nLT1\nLT1\n2064 3276
      M\n1.000 UL\nLT1\nLT1\n2142 3252 M\n1.000 UL\nLT1\nLT1\n2220 3230
      M\n1.000 UL\nLT1\nLT1\n2298 3210 M\n1.000 UL\nLT1\nLT1\n2377 3193
      M\n1.000 UL\nLT1\nLT1\n2455 3179 M\n1.000 UL\nLT1\nLT1\n2532 3165
      M\n1.000 UL\nLT1\nLT1\n2610 3153 M\n1.000 UL\nLT1\nLT1\n2688 3140
      M\n1.000 UL\nLT1\nLT1\n2766 3125 M\n1.000 UL\nLT1\nLT1\n2844 3105
      M\n1.000 UL\nLT1\nLT1\n2922 3077 M\n1.000 UL\nLT1\nLT1\n3000 3036
      M\n1.000 UL\nLT1\nLT1\n3078 2977 M\n1.000 UL\nLT1\nLT1\n3156 2893
      M\n1.000 UL\nLT1\nLT1\n3235 2774 M\n1.000 UL\nLT1\nLT1\n3313 2610
      M\n1.000 UL\nLT1\nLT1\n1094 3300 M\n1.000 UL\nLT1\nLT1\n1172 3412
      M\n1.000 UL\nLT1\nLT1\n1250 3480 M\n1.000 UL\nLT1\nLT1\n1328 3517
      M\n1.000 UL\nLT1\nLT1\n1406 3529 M\n1.000 UL\nLT1\nLT1\n1485 3525
      M\n1.000 UL\nLT1\nLT1\n1563 3510 M\n1.000 UL\nLT1\nLT1\n1641 3487
      M\n1.000 UL\nLT1\nLT1\n1719 3460 M\n1.000 UL\nLT1\nLT1\n1797 3431
      M\n1.000 UL\nLT1\nLT1\n1875 3401 M\n1.000 UL\nLT1\nLT1\n1953 3372
      M\n1.000 UL\nLT1\nLT1\n2031 3344 M\n1.000 UL\nLT1\nLT1\n2109 3318
      M\n1.000 UL\nLT1\nLT1\n2187 3293 M\n1.000 UL\nLT1\nLT1\n2265 3271
      M\n1.000 UL\nLT1\nLT1\n2344 3251 M\n1.000 UL\nLT1\nLT1\n2422 3233
      M\n1.000 UL\nLT1\nLT1\n2500 3217 M\n1.000 UL\nLT1\nLT1\n2577 3202
      M\n1.000 UL\nLT1\nLT1\n2655 3188 M\n1.000 UL\nLT1\nLT1\n2733 3173
      M\n1.000 UL\nLT1\nLT1\n2811 3156 M\n1.000 UL\nLT1\nLT1\n2889 3135
      M\n1.000 UL\nLT1\nLT1\n2967 3106 M\n1.000 UL\nLT1\nLT1\n3045 3066
      M\n1.000 UL\nLT1\nLT1\n3123 3009 M\n1.000 UL\nLT1\nLT1\n3202 2929
      M\n1.000 UL\nLT1\nLT1\n3280 2816 M\n1.000 UL\nLT1\nLT1\n3358 2660
      M\n1.000 UL\nLT1\nLT1\n1139 3340 M\n1.000 UL\nLT1\nLT1\n1217 3446
      M\n1.000 UL\nLT1\nLT1\n1295 3510 M\n1.000 UL\nLT1\nLT1\n1373 3544
      M\n1.000 UL\nLT1\nLT1\n1452 3556 M\n1.000 UL\nLT1\nLT1\n1530 3552
      M\n1.000 UL\nLT1\nLT1\n1608 3537 M\n1.000 UL\nLT1\nLT1\n1686 3516
      M\n1.000 UL\nLT1\nLT1\n1764 3491 M\n1.000 UL\nLT1\nLT1\n1842 3464
      M\n1.000 UL\nLT1\nLT1\n1920 3436 M\n1.000 UL\nLT1\nLT1\n1998 3408
      M\n1.000 UL\nLT1\nLT1\n2076 3382 M\n1.000 UL\nLT1\nLT1\n2154 3357
      M\n1.000 UL\nLT1\nLT1\n2232 3333 M\n1.000 UL\nLT1\nLT1\n2311 3311
      M\n1.000 UL\nLT1\nLT1\n2389 3291 M\n1.000 UL\nLT1\nLT1\n2467 3272
      M\n1.000 UL\nLT1\nLT1\n2544 3254 M\n1.000 UL\nLT1\nLT1\n2622 3237
      M\n1.000 UL\nLT1\nLT1\n2700 3221 M\n1.000 UL\nLT1\nLT1\n2778 3204
      M\n1.000 UL\nLT1\nLT1\n2856 3185 M\n1.000 UL\nLT1\nLT1\n2934 3162
      M\n1.000 UL\nLT1\nLT1\n3012 3133 M\n1.000 UL\nLT1\nLT1\n3090 3093
      M\n1.000 UL\nLT1\nLT1\n3169 3037 M\n1.000 UL\nLT1\nLT1\n3247 2959
      M\n1.000 UL\nLT1\nLT1\n3325 2850 M\n1.000 UL\nLT1\nLT1\n3403 2701
      M\n1.000 UL\nLT1\nLT1\n1184 3375 M\n1.000 UL\nLT1\nLT1\n1262 3475
      M\n1.000 UL\nLT1\nLT1\n1340 3537 M\n1.000 UL\nLT1\nLT1\n1419 3569
      M\n1.000 UL\nLT1\nLT1\n1497 3581 M\n1.000 UL\nLT1\nLT1\n1575 3577
      M\n1.000 UL\nLT1\nLT1\n1653 3564 M\n1.000 UL\nLT1\nLT1\n1731 3545
      M\n1.000 UL\nLT1\nLT1\n1809 3521 M\n1.000 UL\nLT1\nLT1\n1887 3496
      M\n1.000 UL\nLT1\nLT1\n1965 3470 M\n1.000 UL\nLT1\nLT1\n2043 3445
      M\n1.000 UL\nLT1\nLT1\n2121 3419 M\n1.000 UL\nLT1\nLT1\n2199 3395
      M\n1.000 UL\nLT1\nLT1\n2278 3372 M\n1.000 UL\nLT1\nLT1\n2356 3350
      M\n1.000 UL\nLT1\nLT1\n2434 3329 M\n1.000 UL\nLT1\nLT1\n2512 3309
      M\n1.000 UL\nLT1\nLT1\n2589 3290 M\n1.000 UL\nLT1\nLT1\n2667 3272
      M\n1.000 UL\nLT1\nLT1\n2745 3254 M\n1.000 UL\nLT1\nLT1\n2823 3235
      M\n1.000 UL\nLT1\nLT1\n2901 3214 M\n1.000 UL\nLT1\nLT1\n2979 3189
      M\n1.000 UL\nLT1\nLT1\n3057 3158 M\n1.000 UL\nLT1\nLT1\n3136 3117
      M\n1.000 UL\nLT1\nLT1\n3214 3062 M\n1.000 UL\nLT1\nLT1\n3292 2985
      M\n1.000 UL\nLT1\nLT1\n3370 2880 M\n1.000 UL\nLT1\nLT1\n3448 2735
      M\n1.000 UL\nLT1\nLT1\n1229 3407 M\n1.000 UL\nLT1\nLT1\n1307 3504
      M\n1.000 UL\nLT1\nLT1\n1386 3563 M\n1.000 UL\nLT1\nLT1\n1464 3595
      M\n1.000 UL\nLT1\nLT1\n1542 3606 M\n1.000 UL\nLT1\nLT1\n1620 3604
      M\n1.000 UL\nLT1\nLT1\n1698 3592 M\n1.000 UL\nLT1\nLT1\n1776 3574
      M\n1.000 UL\nLT1\nLT1\n1854 3552 M\n1.000 UL\nLT1\nLT1\n1932 3529
      M\n1.000 UL\nLT1\nLT1\n2010 3505 M\n1.000 UL\nLT1\nLT1\n2088 3480
      M\n1.000 UL\nLT1\nLT1\n2166 3457 M\n1.000 UL\nLT1\nLT1\n2245 3433
      M\n1.000 UL\nLT1\nLT1\n2323 3410 M\n1.000 UL\nLT1\nLT1\n2401 3388
      M\n1.000 UL\nLT1\nLT1\n2479 3367 M\n1.000 UL\nLT1\nLT1\n2556 3346
      M\n1.000 UL\nLT1\nLT1\n2634 3326 M\n1.000 UL\nLT1\nLT1\n2712 3306
      M\n1.000 UL\nLT1\nLT1\n2790 3286 M\n1.000 UL\nLT1\nLT1\n2868 3266
      M\n1.000 UL\nLT1\nLT1\n2946 3243 M\n1.000 UL\nLT1\nLT1\n3024 3217
      M\n1.000 UL\nLT1\nLT1\n3103 3185 M\n1.000 UL\nLT1\nLT1\n3181 3143
      M\n1.000 UL\nLT1\nLT1\n3259 3087 M\n1.000 UL\nLT1\nLT1\n3337 3012
      M\n1.000 UL\nLT1\nLT1\n3415 2908 M\n1.000 UL\nLT1\nLT1\n3493 2767
      M\n1.000 UL\nLT1\nLT1\n1274 3438 M\n1.000 UL\nLT1\nLT1\n1353 3533
      M\n1.000 UL\nLT1\nLT1\n1431 3591 M\n1.000 UL\nLT1\nLT1\n1509 3622
      M\n1.000 UL\nLT1\nLT1\n1587 3634 M\n1.000 UL\nLT1\nLT1\n1665 3632
      M\n1.000 UL\nLT1\nLT1\n1743 3621 M\n1.000 UL\nLT1\nLT1\n1821 3605
      M\n1.000 UL\nLT1\nLT1\n1899 3585 M\n1.000 UL\nLT1\nLT1\n1977 3563
      M\n1.000 UL\nLT1\nLT1\n2055 3540 M\n1.000 UL\nLT1\nLT1\n2133 3517
      M\n1.000 UL\nLT1\nLT1\n2212 3494 M\n1.000 UL\nLT1\nLT1\n2290 3471
      M\n1.000 UL\nLT1\nLT1\n2368 3449 M\n1.000 UL\nLT1\nLT1\n2446 3427
      M\n1.000 UL\nLT1\nLT1\n2523 3405 M\n1.000 UL\nLT1\nLT1\n2601 3384
      M\n1.000 UL\nLT1\nLT1\n2679 3362 M\n1.000 UL\nLT1\nLT1\n2757 3341
      M\n1.000 UL\nLT1\nLT1\n2835 3320 M\n1.000 UL\nLT1\nLT1\n2913 3298
      M\n1.000 UL\nLT1\nLT1\n2991 3274 M\n1.000 UL\nLT1\nLT1\n3070 3246
      M\n1.000 UL\nLT1\nLT1\n3148 3213 M\n1.000 UL\nLT1\nLT1\n3226 3171
      M\n1.000 UL\nLT1\nLT1\n3304 3115 M\n1.000 UL\nLT1\nLT1\n3382 3039
      M\n1.000 UL\nLT1\nLT1\n3460 2937 M\n1.000 UL\nLT1\nLT1\n3538 2798
      M\n1.000 UL\nLT1\nLT1\n1320 3471 M\n1.000 UL\nLT1\nLT1\n1398 3564
      M\n1.000 UL\nLT1\nLT1\n1476 3621 M\n1.000 UL\nLT1\nLT1\n1554 3652
      M\n1.000 UL\nLT1\nLT1\n1632 3664 M\n1.000 UL\nLT1\nLT1\n1710 3663
      M\n1.000 UL\nLT1\nLT1\n1788 3653 M\n1.000 UL\nLT1\nLT1\n1866 3638
      M\n1.000 UL\nLT1\nLT1\n1944 3619 M\n1.000 UL\nLT1\nLT1\n2022 3598
      M\n1.000 UL\nLT1\nLT1\n2100 3576 M\n1.000 UL\nLT1\nLT1\n2179 3554
      M\n1.000 UL\nLT1\nLT1\n2257 3531 M\n1.000 UL\nLT1\nLT1\n2335 3509
      M\n1.000 UL\nLT1\nLT1\n2413 3487 M\n1.000 UL\nLT1\nLT1\n2491 3465
      M\n1.000 UL\nLT1\nLT1\n2568 3443 M\n1.000 UL\nLT1\nLT1\n2646 3421
      M\n1.000 UL\nLT1\nLT1\n2724 3399 M\n1.000 UL\nLT1\nLT1\n2802 3377
      M\n1.000 UL\nLT1\nLT1\n2880 3355 M\n1.000 UL\nLT1\nLT1\n2958 3332
      M\n1.000 UL\nLT1\nLT1\n3037 3307 M\n1.000 UL\nLT1\nLT1\n3115 3279
      M\n1.000 UL\nLT1\nLT1\n3193 3244 M\n1.000 UL\nLT1\nLT1\n3271 3201
      M\n1.000 UL\nLT1\nLT1\n3349 3145 M\n1.000 UL\nLT1\nLT1\n3427 3070
      M\n1.000 UL\nLT1\nLT1\n3505 2968 M\n1.000 UL\nLT1\nLT1\n3583 2831
      M\n1.000 UL\nLT1\nLT1\n1365 3506 M\n1.000 UL\nLT1\nLT1\n1443 3598
      M\n1.000 UL\nLT1\nLT1\n1521 3655 M\n1.000 UL\nLT1\nLT1\n1599 3686
      M\n1.000 UL\nLT1\nLT1\n1677 3699 M\n1.000 UL\nLT1\nLT1\n1755 3698
      M\n1.000 UL\nLT1\nLT1\n1833 3688 M\n1.000 UL\nLT1\nLT1\n1911 3673
      M\n1.000 UL\nLT1\nLT1\n1989 3655 M\n1.000 UL\nLT1\nLT1\n2067 3634
      M\n1.000 UL\nLT1\nLT1\n2146 3613 M\n1.000 UL\nLT1\nLT1\n2224 3591
      M\n1.000 UL\nLT1\nLT1\n2302 3569 M\n1.000 UL\nLT1\nLT1\n2380 3547
      M\n1.000 UL\nLT1\nLT1\n2458 3525 M\n1.000 UL\nLT1\nLT1\n2535 3503
      M\n1.000 UL\nLT1\nLT1\n2613 3481 M\n1.000 UL\nLT1\nLT1\n2691 3459
      M\n1.000 UL\nLT1\nLT1\n2769 3437 M\n1.000 UL\nLT1\nLT1\n2847 3415
      M\n1.000 UL\nLT1\nLT1\n2925 3392 M\n1.000 UL\nLT1\nLT1\n3004 3368
      M\n1.000 UL\nLT1\nLT1\n3082 3343 M\n1.000 UL\nLT1\nLT1\n3160 3314
      M\n1.000 UL\nLT1\nLT1\n3238 3279 M\n1.000 UL\nLT1\nLT1\n3316 3236
      M\n1.000 UL\nLT1\nLT1\n3394 3179 M\n1.000 UL\nLT1\nLT1\n3472 3104
      M\n1.000 UL\nLT1\nLT1\n3550 3003 M\n1.000 UL\nLT1\nLT1\n3628 2866
      M\n1.000 UL\nLT1\nLT1\n1410 3544 M\n1.000 UL\nLT1\nLT1\n1488 3637
      M\n1.000 UL\nLT1\nLT1\n1566 3694 M\n1.000 UL\nLT1\nLT1\n1644 3725
      M\n1.000 UL\nLT1\nLT1\n1722 3737 M\n1.000 UL\nLT1\nLT1\n1800 3736
      M\n1.000 UL\nLT1\nLT1\n1878 3727 M\n1.000 UL\nLT1\nLT1\n1956 3712
      M\n1.000 UL\nLT1\nLT1\n2034 3693 M\n1.000 UL\nLT1\nLT1\n2113 3673
      M\n1.000 UL\nLT1\nLT1\n2191 3651 M\n1.000 UL\nLT1\nLT1\n2269 3629
      M\n1.000 UL\nLT1\nLT1\n2347 3607 M\n1.000 UL\nLT1\nLT1\n2425 3585
      M\n1.000 UL\nLT1\nLT1\n2503 3563 M\n1.000 UL\nLT1\nLT1\n2580 3541
      M\n1.000 UL\nLT1\nLT1\n2658 3519 M\n1.000 UL\nLT1\nLT1\n2736 3497
      M\n1.000 UL\nLT1\nLT1\n2814 3475 M\n1.000 UL\nLT1\nLT1\n2892 3453
      M\n1.000 UL\nLT1\nLT1\n2971 3430 M\n1.000 UL\nLT1\nLT1\n3049 3406
      M\n1.000 UL\nLT1\nLT1\n3127 3381 M\n1.000 UL\nLT1\nLT1\n3205 3352
      M\n1.000 UL\nLT1\nLT1\n3283 3317 M\n1.000 UL\nLT1\nLT1\n3361 3274
      M\n1.000 UL\nLT1\nLT1\n3439 3217 M\n1.000 UL\nLT1\nLT1\n3517 3142
      M\n1.000 UL\nLT1\nLT1\n3595 3041 M\n1.000 UL\nLT1\nLT1\n3673 2905
      M\n1.000 UL\nLT1\nLT1\n1455 3585 M\n1.000 UL\nLT1\nLT1\n1533 3678
      M\n1.000 UL\nLT1\nLT1\n1611 3736 M\n1.000 UL\nLT1\nLT1\n1689 3767
      M\n1.000 UL\nLT1\nLT1\n1767 3779 M\n1.000 UL\nLT1\nLT1\n1845 3778
      M\n1.000 UL\nLT1\nLT1\n1923 3768 M\n1.000 UL\nLT1\nLT1\n2001 3752
      M\n1.000 UL\nLT1\nLT1\n2080 3733 M\n1.000 UL\nLT1\nLT1\n2158 3712
      M\n1.000 UL\nLT1\nLT1\n2236 3691 M\n1.000 UL\nLT1\nLT1\n2314 3668
      M\n1.000 UL\nLT1\nLT1\n2392 3646 M\n1.000 UL\nLT1\nLT1\n2470 3624
      M\n1.000 UL\nLT1\nLT1\n2547 3601 M\n1.000 UL\nLT1\nLT1\n2625 3579
      M\n1.000 UL\nLT1\nLT1\n2703 3557 M\n1.000 UL\nLT1\nLT1\n2781 3536
      M\n1.000 UL\nLT1\nLT1\n2859 3514 M\n1.000 UL\nLT1\nLT1\n2938 3492
      M\n1.000 UL\nLT1\nLT1\n3016 3470 M\n1.000 UL\nLT1\nLT1\n3094 3447
      M\n1.000 UL\nLT1\nLT1\n3172 3422 M\n1.000 UL\nLT1\nLT1\n3250 3393
      M\n1.000 UL\nLT1\nLT1\n3328 3359 M\n1.000 UL\nLT1\nLT1\n3406 3316
      M\n1.000 UL\nLT1\nLT1\n3484 3260 M\n1.000 UL\nLT1\nLT1\n3562 3185
      M\n1.000 UL\nLT1\nLT1\n3640 3083 M\n1.000 UL\nLT1\nLT1\n3718 2946
      M\n1.000 UL\nLT1\nLT1\n1500 3629 M\n1.000 UL\nLT1\nLT1\n1578 3724
      M\n1.000 UL\nLT1\nLT1\n1656 3782 M\n1.000 UL\nLT1\nLT1\n1734 3813
      M\n1.000 UL\nLT1\nLT1\n1812 3825 M\n1.000 UL\nLT1\nLT1\n1890 3823
      M\n1.000 UL\nLT1\nLT1\n1968 3812 M\n1.000 UL\nLT1\nLT1\n2047 3796
      M\n1.000 UL\nLT1\nLT1\n2125 3776 M\n1.000 UL\nLT1\nLT1\n2203 3754
      M\n1.000 UL\nLT1\nLT1\n2281 3731 M\n1.000 UL\nLT1\nLT1\n2359 3708
      M\n1.000 UL\nLT1\nLT1\n2437 3685 M\n1.000 UL\nLT1\nLT1\n2515 3662
      M\n1.000 UL\nLT1\nLT1\n2592 3640 M\n1.000 UL\nLT1\nLT1\n2670 3618
      M\n1.000 UL\nLT1\nLT1\n2748 3596 M\n1.000 UL\nLT1\nLT1\n2826 3574
      M\n1.000 UL\nLT1\nLT1\n2905 3553 M\n1.000 UL\nLT1\nLT1\n2983 3532
      M\n1.000 UL\nLT1\nLT1\n3061 3511 M\n1.000 UL\nLT1\nLT1\n3139 3489
      M\n1.000 UL\nLT1\nLT1\n3217 3465 M\n1.000 UL\nLT1\nLT1\n3295 3437
      M\n1.000 UL\nLT1\nLT1\n3373 3404 M\n1.000 UL\nLT1\nLT1\n3451 3362
      M\n1.000 UL\nLT1\nLT1\n3529 3306 M\n1.000 UL\nLT1\nLT1\n3607 3230
      M\n1.000 UL\nLT1\nLT1\n3685 3128 M\n1.000 UL\nLT1\nLT1\n3764 2989
      M\n1.000 UL\nLT1\nLT1\n1545 3674 M\n1.000 UL\nLT1\nLT1\n1623 3771
      M\n1.000 UL\nLT1\nLT1\n1701 3830 M\n1.000 UL\nLT1\nLT1\n1779 3862
      M\n1.000 UL\nLT1\nLT1\n1857 3873 M\n1.000 UL\nLT1\nLT1\n1935 3871
      M\n1.000 UL\nLT1\nLT1\n2014 3859 M\n1.000 UL\nLT1\nLT1\n2092 3841
      M\n1.000 UL\nLT1\nLT1\n2170 3820 M\n1.000 UL\nLT1\nLT1\n2248 3796
      M\n1.000 UL\nLT1\nLT1\n2326 3772 M\n1.000 UL\nLT1\nLT1\n2404 3748
      M\n1.000 UL\nLT1\nLT1\n2482 3724 M\n1.000 UL\nLT1\nLT1\n2559 3701
      M\n1.000 UL\nLT1\nLT1\n2637 3678 M\n1.000 UL\nLT1\nLT1\n2715 3656
      M\n1.000 UL\nLT1\nLT1\n2793 3634 M\n1.000 UL\nLT1\nLT1\n2872 3614
      M\n1.000 UL\nLT1\nLT1\n2950 3593 M\n1.000 UL\nLT1\nLT1\n3028 3574
      M\n1.000 UL\nLT1\nLT1\n3106 3554 M\n1.000 UL\nLT1\nLT1\n3184 3533
      M\n1.000 UL\nLT1\nLT1\n3262 3510 M\n1.000 UL\nLT1\nLT1\n3340 3484
      M\n1.000 UL\nLT1\nLT1\n3418 3452 M\n1.000 UL\nLT1\nLT1\n3496 3410
      M\n1.000 UL\nLT1\nLT1\n3574 3355 M\n1.000 UL\nLT1\nLT1\n3652 3279
      M\n1.000 UL\nLT1\nLT1\n3731 3176 M\n1.000 UL\nLT1\nLT1\n3809 3035
      M\n1.000 UL\nLT1\nLT1\n1590 3719 M\n1.000 UL\nLT1\nLT1\n1668 3819
      M\n1.000 UL\nLT1\nLT1\n1746 3880 M\n1.000 UL\nLT1\nLT1\n1824 3913
      M\n1.000 UL\nLT1\nLT1\n1902 3924 M\n1.000 UL\nLT1\nLT1\n1981 3921
      M\n1.000 UL\nLT1\nLT1\n2059 3908 M\n1.000 UL\nLT1\nLT1\n2137 3888
      M\n1.000 UL\nLT1\nLT1\n2215 3865 M\n1.000 UL\nLT1\nLT1\n2293 3840
      M\n1.000 UL\nLT1\nLT1\n2371 3814 M\n1.000 UL\nLT1\nLT1\n2449 3788
      M\n1.000 UL\nLT1\nLT1\n2526 3763 M\n1.000 UL\nLT1\nLT1\n2604 3739
      M\n1.000 UL\nLT1\nLT1\n2682 3716 M\n1.000 UL\nLT1\nLT1\n2760 3694
      M\n1.000 UL\nLT1\nLT1\n2839 3673 M\n1.000 UL\nLT1\nLT1\n2917 3653
      M\n1.000 UL\nLT1\nLT1\n2995 3634 M\n1.000 UL\nLT1\nLT1\n3073 3616
      M\n1.000 UL\nLT1\nLT1\n3151 3597 M\n1.000 UL\nLT1\nLT1\n3229 3578
      M\n1.000 UL\nLT1\nLT1\n3307 3558 M\n1.000 UL\nLT1\nLT1\n3385 3533
      M\n1.000 UL\nLT1\nLT1\n3463 3502 M\n1.000 UL\nLT1\nLT1\n3541 3461
      M\n1.000 UL\nLT1\nLT1\n3619 3406 M\n1.000 UL\nLT1\nLT1\n3698 3329
      M\n1.000 UL\nLT1\nLT1\n3776 3224 M\n1.000 UL\nLT1\nLT1\n3854 3079
      M\n1.000 UL\nLT1\nLT1\n1635 3761 M\n1.000 UL\nLT1\nLT1\n1713 3866
      M\n1.000 UL\nLT1\nLT1\n1791 3930 M\n1.000 UL\nLT1\nLT1\n1869 3964
      M\n1.000 UL\nLT1\nLT1\n1948 3976 M\n1.000 UL\nLT1\nLT1\n2026 3972
      M\n1.000 UL\nLT1\nLT1\n2104 3957 M\n1.000 UL\nLT1\nLT1\n2182 3936
      M\n1.000 UL\nLT1\nLT1\n2260 3911 M\n1.000 UL\nLT1\nLT1\n2338 3884
      M\n1.000 UL\nLT1\nLT1\n2416 3856 M\n1.000 UL\nLT1\nLT1\n2494 3829
      M\n1.000 UL\nLT1\nLT1\n2571 3802 M\n1.000 UL\nLT1\nLT1\n2649 3777
      M\n1.000 UL\nLT1\nLT1\n2727 3753 M\n1.000 UL\nLT1\nLT1\n2806 3731
      M\n1.000 UL\nLT1\nLT1\n2884 3711 M\n1.000 UL\nLT1\nLT1\n2962 3692
      M\n1.000 UL\nLT1\nLT1\n3040 3674 M\n1.000 UL\nLT1\nLT1\n3118 3658
      M\n1.000 UL\nLT1\nLT1\n3196 3641 M\n1.000 UL\nLT1\nLT1\n3274 3624
      M\n1.000 UL\nLT1\nLT1\n3352 3605 M\n1.000 UL\nLT1\nLT1\n3430 3583
      M\n1.000 UL\nLT1\nLT1\n3508 3553 M\n1.000 UL\nLT1\nLT1\n3586 3513
      M\n1.000 UL\nLT1\nLT1\n3665 3457 M\n1.000 UL\nLT1\nLT1\n3743 3379
      M\n1.000 UL\nLT1\nLT1\n3821 3270 M\n1.000 UL\nLT1\nLT1\n3899 3121
      M\n1.000 UL\nLT1\nLT1\n1680 3796 M\n1.000 UL\nLT1\nLT1\n1758 3908
      M\n1.000 UL\nLT1\nLT1\n1836 3977 M\n1.000 UL\nLT1\nLT1\n1915 4013
      M\n1.000 UL\nLT1\nLT1\n1993 4026 M\n1.000 UL\nLT1\nLT1\n2071 4022
      M\n1.000 UL\nLT1\nLT1\n2149 4006 M\n1.000 UL\nLT1\nLT1\n2227 3984
      M\n1.000 UL\nLT1\nLT1\n2305 3956 M\n1.000 UL\nLT1\nLT1\n2383 3927
      M\n1.000 UL\nLT1\nLT1\n2461 3897 M\n1.000 UL\nLT1\nLT1\n2538 3868
      M\n1.000 UL\nLT1\nLT1\n2616 3840 M\n1.000 UL\nLT1\nLT1\n2694 3814
      M\n1.000 UL\nLT1\nLT1\n2773 3790 M\n1.000 UL\nLT1\nLT1\n2851 3768
      M\n1.000 UL\nLT1\nLT1\n2929 3748 M\n1.000 UL\nLT1\nLT1\n3007 3730
      M\n1.000 UL\nLT1\nLT1\n3085 3714 M\n1.000 UL\nLT1\nLT1\n3163 3699
      M\n1.000 UL\nLT1\nLT1\n3241 3685 M\n1.000 UL\nLT1\nLT1\n3319 3670
      M\n1.000 UL\nLT1\nLT1\n3397 3653 M\n1.000 UL\nLT1\nLT1\n3475 3632
      M\n1.000 UL\nLT1\nLT1\n3553 3603 M\n1.000 UL\nLT1\nLT1\n3632 3563
      M\n1.000 UL\nLT1\nLT1\n3710 3506 M\n1.000 UL\nLT1\nLT1\n3788 3426
      M\n1.000 UL\nLT1\nLT1\n3866 3313 M\n1.000 UL\nLT1\nLT1\n3944 3157
      M\n1.000 UL\nLT1\nLT1\n1725 3822 M\n1.000 UL\nLT1\nLT1\n1803 3943
      M\n1.000 UL\nLT1\nLT1\n1882 4017 M\n1.000 UL\nLT1\nLT1\n1960 4058
      M\n1.000 UL\nLT1\nLT1\n2038 4072 M\n1.000 UL\nLT1\nLT1\n2116 4069
      M\n1.000 UL\nLT1\nLT1\n2194 4053 M\n1.000 UL\nLT1\nLT1\n2272 4029
      M\n1.000 UL\nLT1\nLT1\n2350 4000 M\n1.000 UL\nLT1\nLT1\n2428 3968
      M\n1.000 UL\nLT1\nLT1\n2506 3937 M\n1.000 UL\nLT1\nLT1\n2583 3906
      M\n1.000 UL\nLT1\nLT1\n2661 3876 M\n1.000 UL\nLT1\nLT1\n2740 3849
      M\n1.000 UL\nLT1\nLT1\n2818 3825 M\n1.000 UL\nLT1\nLT1\n2896 3803
      M\n1.000 UL\nLT1\nLT1\n2974 3783 M\n1.000 UL\nLT1\nLT1\n3052 3766
      M\n1.000 UL\nLT1\nLT1\n3130 3751 M\n1.000 UL\nLT1\nLT1\n3208 3738
      M\n1.000 UL\nLT1\nLT1\n3286 3726 M\n1.000 UL\nLT1\nLT1\n3364 3713
      M\n1.000 UL\nLT1\nLT1\n3442 3698 M\n1.000 UL\nLT1\nLT1\n3520 3678
      M\n1.000 UL\nLT1\nLT1\n3599 3650 M\n1.000 UL\nLT1\nLT1\n3677 3609
      M\n1.000 UL\nLT1\nLT1\n3755 3550 M\n1.000 UL\nLT1\nLT1\n3833 3466
      M\n1.000 UL\nLT1\nLT1\n3911 3347 M\n1.000 UL\nLT1\nLT1\n3989 3183
      M\n1.000 UL\nLT1\nLT1\n1770 3832 M\n1.000 UL\nLT1\nLT1\n1848 3964
      M\n1.000 UL\nLT1\nLT1\n1927 4047 M\n1.000 UL\nLT1\nLT1\n2005 4093
      M\n1.000 UL\nLT1\nLT1\n2083 4111 M\n1.000 UL\nLT1\nLT1\n2161 4109
      M\n1.000 UL\nLT1\nLT1\n2239 4094 M\n1.000 UL\nLT1\nLT1\n2317 4069
      M\n1.000 UL\nLT1\nLT1\n2395 4039 M\n1.000 UL\nLT1\nLT1\n2473 4006
      M\n1.000 UL\nLT1\nLT1\n2550 3972 M\n1.000 UL\nLT1\nLT1\n2628 3940
      M\n1.000 UL\nLT1\nLT1\n2707 3909 M\n1.000 UL\nLT1\nLT1\n2785 3881
      M\n1.000 UL\nLT1\nLT1\n2863 3856 M\n1.000 UL\nLT1\nLT1\n2941 3834
      M\n1.000 UL\nLT1\nLT1\n3019 3815 M\n1.000 UL\nLT1\nLT1\n3097 3799
      M\n1.000 UL\nLT1\nLT1\n3175 3786 M\n1.000 UL\nLT1\nLT1\n3253 3774
      M\n1.000 UL\nLT1\nLT1\n3331 3763 M\n1.000 UL\nLT1\nLT1\n3409 3752
      M\n1.000 UL\nLT1\nLT1\n3487 3738 M\n1.000 UL\nLT1\nLT1\n3566 3719
      M\n1.000 UL\nLT1\nLT1\n3644 3690 M\n1.000 UL\nLT1\nLT1\n3722 3648
      M\n1.000 UL\nLT1\nLT1\n3800 3586 M\n1.000 UL\nLT1\nLT1\n3878 3496
      M\n1.000 UL\nLT1\nLT1\n3956 3369 M\n1.000 UL\nLT1\nLT1\n4034 3193
      M\n1.000 UL\nLT1\nLT1\n1815 3821 M\n1.000 UL\nLT1\nLT1\n1894 3968
      M\n1.000 UL\nLT1\nLT1\n1972 4061 M\n1.000 UL\nLT1\nLT1\n2050 4115
      M\n1.000 UL\nLT1\nLT1\n2128 4138 M\n1.000 UL\nLT1\nLT1\n2206 4140
      M\n1.000 UL\nLT1\nLT1\n2284 4125 M\n1.000 UL\nLT1\nLT1\n2362 4101
      M\n1.000 UL\nLT1\nLT1\n2440 4070 M\n1.000 UL\nLT1\nLT1\n2518 4036
      M\n1.000 UL\nLT1\nLT1\n2595 4002 M\n1.000 UL\nLT1\nLT1\n2673 3968
      M\n1.000 UL\nLT1\nLT1\n2752 3936 M\n1.000 UL\nLT1\nLT1\n2830 3907
      M\n1.000 UL\nLT1\nLT1\n2908 3881 M\n1.000 UL\nLT1\nLT1\n2986 3859
      M\n1.000 UL\nLT1\nLT1\n3064 3841 M\n1.000 UL\nLT1\nLT1\n3142 3826
      M\n1.000 UL\nLT1\nLT1\n3220 3814 M\n1.000 UL\nLT1\nLT1\n3298 3803
      M\n1.000 UL\nLT1\nLT1\n3376 3794 M\n1.000 UL\nLT1\nLT1\n3454 3784
      M\n1.000 UL\nLT1\nLT1\n3533 3770 M\n1.000 UL\nLT1\nLT1\n3611 3751
      M\n1.000 UL\nLT1\nLT1\n3689 3721 M\n1.000 UL\nLT1\nLT1\n3767 3675
      M\n1.000 UL\nLT1\nLT1\n3845 3608 M\n1.000 UL\nLT1\nLT1\n3923 3510
      M\n1.000 UL\nLT1\nLT1\n4001 3372 M\n1.000 UL\nLT1\nLT1\n4079 3181
      M\n1.000 UL\nLT1\nLT1\n1861 3780 M\n1.000 UL\nLT1\nLT1\n1939 3945
      M\n1.000 UL\nLT1\nLT1\n2017 4053 M\n1.000 UL\nLT1\nLT1\n2095 4117
      M\n1.000 UL\nLT1\nLT1\n2173 4148 M\n1.000 UL\nLT1\nLT1\n2251 4154
      M\n1.000 UL\nLT1\nLT1\n2329 4143 M\n1.000 UL\nLT1\nLT1\n2407 4121
      M\n1.000 UL\nLT1\nLT1\n2485 4091 M\n1.000 UL\nLT1\nLT1\n2562 4056
      M\n1.000 UL\nLT1\nLT1\n2640 4021 M\n1.000 UL\nLT1\nLT1\n2719 3986
      M\n1.000 UL\nLT1\nLT1\n2797 3954 M\n1.000 UL\nLT1\nLT1\n2875 3924
      M\n1.000 UL\nLT1\nLT1\n2953 3898 M\n1.000 UL\nLT1\nLT1\n3031 3876
      M\n1.000 UL\nLT1\nLT1\n3109 3858 M\n1.000 UL\nLT1\nLT1\n3187 3844
      M\n1.000 UL\nLT1\nLT1\n3265 3832 M\n1.000 UL\nLT1\nLT1\n3343 3823
      M\n1.000 UL\nLT1\nLT1\n3421 3814 M\n1.000 UL\nLT1\nLT1\n3500 3804
      M\n1.000 UL\nLT1\nLT1\n3578 3790 M\n1.000 UL\nLT1\nLT1\n3656 3769
      M\n1.000 UL\nLT1\nLT1\n3734 3735 M\n1.000 UL\nLT1\nLT1\n3812 3685
      M\n1.000 UL\nLT1\nLT1\n3890 3610 M\n1.000 UL\nLT1\nLT1\n3968 3502
      M\n1.000 UL\nLT1\nLT1\n4046 3349 M\n1.000 UL\nLT1\nLT1\n4124 3140
      M\n1.000 UL\nLT1\nLT1\n1906 3699 M\n1.000 UL\nLT1\nLT1\n1984 3887
      M\n1.000 UL\nLT1\nLT1\n2062 4014 M\n1.000 UL\nLT1\nLT1\n2140 4092
      M\n1.000 UL\nLT1\nLT1\n2218 4133 M\n1.000 UL\nLT1\nLT1\n2296 4147
      M\n1.000 UL\nLT1\nLT1\n2374 4141 M\n1.000 UL\nLT1\nLT1\n2452 4122
      M\n1.000 UL\nLT1\nLT1\n2529 4094 M\n1.000 UL\nLT1\nLT1\n2607 4061
      M\n1.000 UL\nLT1\nLT1\n2686 4026 M\n1.000 UL\nLT1\nLT1\n2764 3991
      M\n1.000 UL\nLT1\nLT1\n2842 3958 M\n1.000 UL\nLT1\nLT1\n2920 3928
      M\n1.000 UL\nLT1\nLT1\n2998 3902 M\n1.000 UL\nLT1\nLT1\n3076 3880
      M\n1.000 UL\nLT1\nLT1\n3154 3862 M\n1.000 UL\nLT1\nLT1\n3232 3848
      M\n1.000 UL\nLT1\nLT1\n3310 3837 M\n1.000 UL\nLT1\nLT1\n3388 3827
      M\n1.000 UL\nLT1\nLT1\n3466 3818 M\n1.000 UL\nLT1\nLT1\n3545 3807
      M\n1.000 UL\nLT1\nLT1\n3623 3791 M\n1.000 UL\nLT1\nLT1\n3701 3767
      M\n1.000 UL\nLT1\nLT1\n3779 3728 M\n1.000 UL\nLT1\nLT1\n3857 3670
      M\n1.000 UL\nLT1\nLT1\n3935 3585 M\n1.000 UL\nLT1\nLT1\n4013 3462
      M\n1.000 UL\nLT1\nLT1\n4091 3292 M\n1.000 UL\nLT1\nLT1\n4169 3060
      M\n1.000 UL\nLT1\nLT1\n1951 3567 M\n1.000 UL\nLT1\nLT1\n2029 3784
      M\n1.000 UL\nLT1\nLT1\n2107 3934 M\n1.000 UL\nLT1\nLT1\n2185 4030
      M\n1.000 UL\nLT1\nLT1\n2263 4085 M\n1.000 UL\nLT1\nLT1\n2341 4110
      M\n1.000 UL\nLT1\nLT1\n2419 4112 M\n1.000 UL\nLT1\nLT1\n2497 4098
      M\n1.000 UL\nLT1\nLT1\n2574 4074 M\n1.000 UL\nLT1\nLT1\n2653 4043
      M\n1.000 UL\nLT1\nLT1\n2731 4010 M\n1.000 UL\nLT1\nLT1\n2809 3976
      M\n1.000 UL\nLT1\nLT1\n2887 3943 M\n1.000 UL\nLT1\nLT1\n2965 3913
      M\n1.000 UL\nLT1\nLT1\n3043 3887 M\n1.000 UL\nLT1\nLT1\n3121 3865
      M\n1.000 UL\nLT1\nLT1\n3199 3847 M\n1.000 UL\nLT1\nLT1\n3277 3833
      M\n1.000 UL\nLT1\nLT1\n3355 3821 M\n1.000 UL\nLT1\nLT1\n3433 3811
      M\n1.000 UL\nLT1\nLT1\n3512 3801 M\n1.000 UL\nLT1\nLT1\n3590 3787
      M\n1.000 UL\nLT1\nLT1\n3668 3767 M\n1.000 UL\nLT1\nLT1\n3746 3737
      M\n1.000 UL\nLT1\nLT1\n3824 3691 M\n1.000 UL\nLT1\nLT1\n3902 3622
      M\n1.000 UL\nLT1\nLT1\n3980 3523 M\n1.000 UL\nLT1\nLT1\n4058 3382
      M\n1.000 UL\nLT1\nLT1\n4136 3189 M\n1.000 UL\nLT1\nLT1\n4214 2928
      M\n1.000 UL\nLT1\nLT1\n1996 3371 M\n1.000 UL\nLT1\nLT1\n2074 3623
      M\n1.000 UL\nLT1\nLT1\n2152 3800 M\n1.000 UL\nLT1\nLT1\n2230 3920
      M\n1.000 UL\nLT1\nLT1\n2308 3993 M\n1.000 UL\nLT1\nLT1\n2386 4032
      M\n1.000 UL\nLT1\nLT1\n2464 4045 M\n1.000 UL\nLT1\nLT1\n2541 4039
      M\n1.000 UL\nLT1\nLT1\n2620 4021 M\n1.000 UL\nLT1\nLT1\n2698 3995
      M\n1.000 UL\nLT1\nLT1\n2776 3964 M\n1.000 UL\nLT1\nLT1\n2854 3932
      M\n1.000 UL\nLT1\nLT1\n2932 3901 M\n1.000 UL\nLT1\nLT1\n3010 3872
      M\n1.000 UL\nLT1\nLT1\n3088 3846 M\n1.000 UL\nLT1\nLT1\n3166 3824
      M\n1.000 UL\nLT1\nLT1\n3244 3806 M\n1.000 UL\nLT1\nLT1\n3322 3791
      M\n1.000 UL\nLT1\nLT1\n3400 3778 M\n1.000 UL\nLT1\nLT1\n3479 3766
      M\n1.000 UL\nLT1\nLT1\n3557 3752 M\n1.000 UL\nLT1\nLT1\n3635 3734
      M\n1.000 UL\nLT1\nLT1\n3713 3709 M\n1.000 UL\nLT1\nLT1\n3791 3670
      M\n1.000 UL\nLT1\nLT1\n3869 3613 M\n1.000 UL\nLT1\nLT1\n3947 3530
      M\n1.000 UL\nLT1\nLT1\n4025 3412 M\n1.000 UL\nLT1\nLT1\n4103 3249
      M\n1.000 UL\nLT1\nLT1\n4181 3027 M\n1.000 UL\nLT1\nLT1\n4259 2732
      M\n1.000 UL\nLT1\nLT1\n2041 3094 M\n1.000 UL\nLT1\nLT1\n2119 3387
      M\n1.000 UL\nLT1\nLT1\n2197 3600 M\n1.000 UL\nLT1\nLT1\n2275 3747
      M\n1.000 UL\nLT1\nLT1\n2353 3844 M\n1.000 UL\nLT1\nLT1\n2431 3902
      M\n1.000 UL\nLT1\nLT1\n2509 3929 M\n1.000 UL\nLT1\nLT1\n2587 3935
      M\n1.000 UL\nLT1\nLT1\n2665 3926 M\n1.000 UL\nLT1\nLT1\n2743 3906
      M\n1.000 UL\nLT1\nLT1\n2821 3880 M\n1.000 UL\nLT1\nLT1\n2899 3852
      M\n1.000 UL\nLT1\nLT1\n2977 3823 M\n1.000 UL\nLT1\nLT1\n3055 3795
      M\n1.000 UL\nLT1\nLT1\n3133 3770 M\n1.000 UL\nLT1\nLT1\n3211 3748
      M\n1.000 UL\nLT1\nLT1\n3289 3729 M\n1.000 UL\nLT1\nLT1\n3367 3712
      M\n1.000 UL\nLT1\nLT1\n3446 3697 M\n1.000 UL\nLT1\nLT1\n3524 3682
      M\n1.000 UL\nLT1\nLT1\n3602 3663 M\n1.000 UL\nLT1\nLT1\n3680 3639
      M\n1.000 UL\nLT1\nLT1\n3758 3604 M\n1.000 UL\nLT1\nLT1\n3836 3554
      M\n1.000 UL\nLT1\nLT1\n3914 3483 M\n1.000 UL\nLT1\nLT1\n3992 3381
      M\n1.000 UL\nLT1\nLT1\n4070 3240 M\n1.000 UL\nLT1\nLT1\n4148 3048
      M\n1.000 UL\nLT1\nLT1\n4226 2792 M\n1.000 UL\nLT1\nLT1\n4305 2455
      M\n1.000 UL\nLT1\n1.000 UL\nLT2\nLT3\n1569 1074 Pnt\n1486 1092
      Pnt\n1406 1112 Pnt\n1329 1136 Pnt\n1258 1163 Pnt\n1192 1196 Pnt\n1132
      1234 Pnt\n1132 1234 Pnt\n1128 1238 Pnt\n1088 1285 Pnt\n1079 1303
      Pnt\n1065 1353 Pnt\n1065 1358 Pnt\n1078 1405 Pnt\n1101 1449 Pnt\n1135
      1491 Pnt\n1177 1530 Pnt\n1226 1567 Pnt\n1280 1603 Pnt\n1335 1638
      Pnt\n1389 1673 Pnt\n1441 1710 Pnt\n1490 1747 Pnt\n1535 1785 Pnt\n1577
      1824 Pnt\n1615 1864 Pnt\n1650 1905 Pnt\n1685 1946 Pnt\n1722 1987
      Pnt\n1763 2026 Pnt\n1811 2064 Pnt\n1868 2099 Pnt\n1934 2131 Pnt\n2011
      2160 Pnt\n2020 2162 Pnt\n2116 2181 Pnt\n2152 2186 Pnt\n2255 2193
      Pnt\n2265 2193 Pnt\n2361 2187 Pnt\n2452 2175 Pnt\n2537 2159 Pnt\n2616
      2138 Pnt\n2692 2114 Pnt\n2765 2088 Pnt\n2838 2061 Pnt\n2910 2034
      Pnt\n2984 2009 Pnt\n3060 1985 Pnt\n3138 1963 Pnt\n3218 1943 Pnt\n3301
      1924 Pnt\n3384 1906 Pnt\n3468 1889 Pnt\n3551 1871 Pnt\n3631 1851
      Pnt\n3708 1828 Pnt\n3779 1800 Pnt\n3845 1768 Pnt\n3905 1730 Pnt\n3909
      1726 Pnt\n3949 1679 Pnt\n3958 1661 Pnt\n3972 1611 Pnt\n3972 1606
      Pnt\n3959 1559 Pnt\n3936 1514 Pnt\n3902 1473 Pnt\n3860 1434 Pnt\n3811
      1397 Pnt\n3757 1361 Pnt\n3702 1326 Pnt\n3648 1290 Pnt\n3596 1254
      Pnt\n3547 1217 Pnt\n3502 1179 Pnt\n3460 1139 Pnt\n3422 1099 Pnt\n3387
      1058 Pnt\n3352 1017 Pnt\n3315 977 Pnt\n3274 938 Pnt\n3226 900 Pnt\n3169
      865 Pnt\n3103 833 Pnt\n3026 804 Pnt\n3017 802 Pnt\n2921 782 Pnt\n2885
      778 Pnt\n2782 771 Pnt\n2772 771 Pnt\n2676 777 Pnt\n2585 789 Pnt\n2500
      805 Pnt\n2421 826 Pnt\n2345 850 Pnt\n2272 876 Pnt\n2199 903 Pnt\n2127
      929 Pnt\n2053 955 Pnt\n1977 979 Pnt\n1899 1001 Pnt\n1819 1021 Pnt\n1736
      1040 Pnt\n1653 1057 Pnt\n1569 1074 Pnt\nLT4\n2610 870 Pnt\n2585 877
      Pnt\n2575 880 Pnt\n2514 905 Pnt\n2451 940 Pnt\n2391 977 Pnt\n2370 989
      Pnt\n2338 1020 Pnt\n2282 1061 Pnt\n2269 1068 Pnt\n2228 1103 Pnt\n2162
      1136 Pnt\n2084 1158 Pnt\n1993 1169 Pnt\n1911 1170 Pnt\n1892 1171
      Pnt\n1791 1174 Pnt\n1720 1173 Pnt\n1688 1175 Pnt\n1592 1182 Pnt\n1499
      1192 Pnt\n1425 1205 Pnt\n1414 1208 Pnt\n1414 1208 Pnt\n1390 1215
      Pnt\n1338 1232 Pnt\n1276 1267 Pnt\n1228 1311 Pnt\n1227 1314 Pnt\n1223
      1364 Pnt\n1241 1410 Pnt\n1268 1437 Pnt\n1281 1449 Pnt\n1288 1454
      Pnt\n1339 1484 Pnt\n1410 1515 Pnt\n1486 1544 Pnt\n1511 1554 Pnt\n1574
      1570 Pnt\n1658 1597 Pnt\n1673 1604 Pnt\n1744 1624 Pnt\n1811 1656
      Pnt\n1856 1695 Pnt\n1880 1739 Pnt\n1880 1779 Pnt\n1884 1788 Pnt\n1890
      1838 Pnt\n1886 1872 Pnt\n1892 1888 Pnt\n1906 1935 Pnt\n1925 1980
      Pnt\n1953 2017 Pnt\n1958 2022 Pnt\n1973 2034 Pnt\n2007 2059 Pnt\n2080
      2090 Pnt\n2170 2113 Pnt\n2175 2114 Pnt\n2277 2115 Pnt\n2371 2107
      Pnt\n2427 2093 Pnt\n2452 2087 Pnt\n2462 2084 Pnt\n2523 2059 Pnt\n2586
      2024 Pnt\n2646 1987 Pnt\n2667 1975 Pnt\n2699 1944 Pnt\n2755 1903
      Pnt\n2768 1895 Pnt\n2809 1860 Pnt\n2875 1828 Pnt\n2953 1806 Pnt\n3044
      1794 Pnt\n3126 1794 Pnt\n3145 1792 Pnt\n3246 1789 Pnt\n3317 1791
      Pnt\n3349 1788 Pnt\n3445 1781 Pnt\n3538 1772 Pnt\n3612 1759 Pnt\n3623
      1756 Pnt\n3647 1749 Pnt\n3699 1732 Pnt\n3761 1696 Pnt\n3809 1652
      Pnt\n3810 1650 Pnt\n3814 1600 Pnt\n3796 1554 Pnt\n3769 1527 Pnt\n3756
      1514 Pnt\n3749 1510 Pnt\n3698 1480 Pnt\n3627 1449 Pnt\n3551 1419
      Pnt\n3526 1409 Pnt\n3463 1393 Pnt\n3379 1366 Pnt\n3364 1360 Pnt\n3293
      1340 Pnt\n3226 1307 Pnt\n3181 1269 Pnt\n3157 1225 Pnt\n3157 1185
      Pnt\n3153 1175 Pnt\n3147 1126 Pnt\n3151 1091 Pnt\n3145 1076 Pnt\n3131
      1029 Pnt\n3112 983 Pnt\n3084 947 Pnt\n3079 942 Pnt\n3064 930 Pnt\n3030
      905 Pnt\n2957 874 Pnt\n2867 851 Pnt\n2862 850 Pnt\n2760 848 Pnt\n2666
      857 Pnt\n2610 870 Pnt\nLT5\n3017 1214 Pnt\n3050 1183 Pnt\n3063 1150
      Pnt\n3083 1122 Pnt\n3085 1093 Pnt\n3094 1043 Pnt\n3093 1040 Pnt\n3075
      994 Pnt\n3045 951 Pnt\n2998 914 Pnt\n2929 882 Pnt\n2893 873 Pnt\n2817
      863 Pnt\n2776 862 Pnt\n2684 873 Pnt\n2605 893 Pnt\n2536 923 Pnt\n2473
      958 Pnt\n2468 961 Pnt\n2426 1006 Pnt\n2398 1032 Pnt\n2387 1061
      Pnt\n2364 1093 Pnt\n2361 1128 Pnt\n2348 1148 Pnt\n2348 1199 Pnt\n2354
      1211 Pnt\n2348 1250 Pnt\n2366 1296 Pnt\n2394 1332 Pnt\n2316 1354
      Pnt\n2266 1324 Pnt\n2193 1294 Pnt\n2120 1277 Pnt\n2103 1268 Pnt\n2013
      1243 Pnt\n1970 1238 Pnt\n1907 1222 Pnt\n1840 1216 Pnt\n1783 1206
      Pnt\n1723 1205 Pnt\n1622 1200 Pnt\n1614 1201 Pnt\n1521 1210 Pnt\n1433
      1224 Pnt\n1357 1247 Pnt\n1292 1281 Pnt\n1292 1281 Pnt\n1273 1299
      Pnt\n1253 1336 Pnt\n1252 1356 Pnt\n1273 1401 Pnt\n1315 1440 Pnt\n1376
      1473 Pnt\n1448 1504 Pnt\n1454 1507 Pnt\n1546 1527 Pnt\n1599 1541
      Pnt\n1659 1546 Pnt\n1723 1558 Pnt\n1794 1559 Pnt\n1836 1565 Pnt\n1940
      1565 Pnt\n1964 1562 Pnt\n2044 1565 Pnt\n2138 1557 Pnt\n2213 1543
      Pnt\n2258 1581 Pnt\n2196 1606 Pnt\n2134 1641 Pnt\n2099 1677 Pnt\n2082
      1685 Pnt\n2030 1729 Pnt\n2020 1750 Pnt\n1987 1781 Pnt\n1974 1814
      Pnt\n1954 1842 Pnt\n1952 1871 Pnt\n1943 1920 Pnt\n1944 1924 Pnt\n1962
      1970 Pnt\n1992 2013 Pnt\n2039 2050 Pnt\n2108 2082 Pnt\n2144 2091
      Pnt\n2220 2101 Pnt\n2261 2102 Pnt\n2353 2091 Pnt\n2432 2070 Pnt\n2501
      2041 Pnt\n2564 2005 Pnt\n2569 2002 Pnt\n2611 1957 Pnt\n2639 1932
      Pnt\n2650 1902 Pnt\n2673 1871 Pnt\n2676 1836 Pnt\n2689 1816 Pnt\n2689
      1765 Pnt\n2683 1753 Pnt\n2689 1714 Pnt\n2671 1668 Pnt\n2643 1631
      Pnt\n2721 1609 Pnt\n2771 1640 Pnt\n2844 1670 Pnt\n2917 1687 Pnt\n2934
      1695 Pnt\n3024 1721 Pnt\n3067 1726 Pnt\n3130 1742 Pnt\n3197 1748
      Pnt\n3254 1758 Pnt\n3314 1759 Pnt\n3415 1763 Pnt\n3423 1763 Pnt\n3516
      1754 Pnt\n3604 1740 Pnt\n3680 1716 Pnt\n3745 1683 Pnt\n3764 1665
      Pnt\n3784 1628 Pnt\n3785 1608 Pnt\n3764 1563 Pnt\n3722 1524 Pnt\n3661
      1490 Pnt\n3589 1460 Pnt\n3583 1457 Pnt\n3491 1436 Pnt\n3438 1423
      Pnt\n3378 1417 Pnt\n3314 1406 Pnt\n3243 1405 Pnt\n3201 1398 Pnt\n3097
      1398 Pnt\n3073 1402 Pnt\n2993 1398 Pnt\n2899 1407 Pnt\n2824 1421
      Pnt\n2779 1383 Pnt\n2841 1358 Pnt\n2903 1323 Pnt\n2938 1287 Pnt\n2955
      1279 Pnt\n3007 1235 Pnt\n3017 1214 Pnt\nLT6\n3227 1508 Pnt\n3220 1513
      Pnt\n3173 1551 Pnt\n3156 1582 Pnt\n3158 1626 Pnt\n3159 1632 Pnt\n3194
      1673 Pnt\n3237 1693 Pnt\n3259 1706 Pnt\n3359 1728 Pnt\n3383 1729
      Pnt\n3491 1733 Pnt\n3532 1731 Pnt\n3583 1722 Pnt\n3662 1701 Pnt\n3695
      1684 Pnt\n3723 1664 Pnt\n3748 1618 Pnt\n3744 1594 Pnt\n3732 1572
      Pnt\n3687 1534 Pnt\n3650 1514 Pnt\n3617 1503 Pnt\n3521 1479 Pnt\n3498
      1474 Pnt\n3389 1469 Pnt\n3357 1474 Pnt\n3299 1481 Pnt\n3227 1508
      Pnt\n2128 1812 Pnt\n2086 1833 Pnt\n2061 1844 Pnt\n2014 1893 Pnt\n2012
      1905 Pnt\n2006 1958 Pnt\n2010 1977 Pnt\n2027 2003 Pnt\n2071 2041
      Pnt\n2104 2057 Pnt\n2145 2071 Pnt\n2239 2083 Pnt\n2289 2081 Pnt\n2334
      2076 Pnt\n2412 2053 Pnt\n2452 2035 Pnt\n2476 2019 Pnt\n2524 1972
      Pnt\n2535 1961 Pnt\n2544 1908 Pnt\n2534 1892 Pnt\n2519 1864 Pnt\n2464
      1828 Pnt\n2455 1825 Pnt\n2377 1802 Pnt\n2314 1794 Pnt\n2223 1794
      Pnt\n2211 1795 Pnt\n2128 1812 Pnt\n2625 910 Pnt\n2585 928 Pnt\n2561 945
      Pnt\n2513 992 Pnt\n2502 1003 Pnt\n2493 1056 Pnt\n2503 1072 Pnt\n2518
      1100 Pnt\n2573 1136 Pnt\n2582 1139 Pnt\n2660 1162 Pnt\n2723 1170
      Pnt\n2814 1169 Pnt\n2826 1169 Pnt\n2909 1151 Pnt\n2951 1130 Pnt\n2976
      1119 Pnt\n3023 1071 Pnt\n3025 1059 Pnt\n3031 1006 Pnt\n3027 986
      Pnt\n3010 961 Pnt\n2966 923 Pnt\n2933 907 Pnt\n2892 893 Pnt\n2798 880
      Pnt\n2748 882 Pnt\n2703 888 Pnt\n2625 910 Pnt\n1375 1263 Pnt\n1342 1279
      Pnt\n1314 1299 Pnt\n1289 1345 Pnt\n1293 1370 Pnt\n1305 1392 Pnt\n1350
      1430 Pnt\n1387 1449 Pnt\n1420 1461 Pnt\n1516 1485 Pnt\n1539 1490
      Pnt\n1648 1494 Pnt\n1680 1489 Pnt\n1738 1482 Pnt\n1810 1455 Pnt\n1817
      1451 Pnt\n1864 1413 Pnt\n1881 1382 Pnt\n1879 1337 Pnt\n1878 1332
      Pnt\n1843 1291 Pnt\n1800 1270 Pnt\n1778 1258 Pnt\n1678 1235 Pnt\n1654
      1234 Pnt\n1546 1231 Pnt\n1505 1233 Pnt\n1454 1241 Pnt\n1375 1263
      Pnt\n1.000 UL\nLTb\nLTb\n4305 1717 M\n2997 609 L\n1.000
      UL\nLTb\nLTb\n733 1249 M\n2997 609 L\n1.000 UL\nLTb\nLTb\n733 1249
      M\n2041 2356 L\n1.000 UL\nLTb\nLTb\n4305 1717 M\n2041 2356 L\n1.000
      UL\nLTb\nLTb\n733 1249 M\n0 2214 V\n1.000 UL\nLTb\nLTb\n2041 2356 M\n0
      738 V\n1.000 UL\nLTb\nLTb\n4305 1717 M\n0 738 V\n1.000
      UL\nLTb\nLTb\n2997 609 M\n0 739 V\n1.000 UL\nLTb\nLTb\n733 1249 M\n48
      41 V\n1.000 UL\nLTb\n670 1157 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 (-1)]\n] -46.7 MCshow\ngrestore\n1.000
      UL\nLTb\nLTb\n2041 2356 M\n-48 -41 V\n1.000 UL\nLTb\nLTb\n1300 1089
      M\n47 41 V\n1.000 UL\nLTb\n1236 997 M\ngsave 0 setgray\n[ [(Helvetica)
      140.0 0.0 true true 0 (-0.5)]\n] -46.7 MCshow\ngrestore\n1.000
      UL\nLTb\nLTb\n2606 2197 M\n-48 -42 V\n1.000 UL\nLTb\nLTb\n1866 929
      M\n47 41 V\n1.000 UL\nLTb\n1802 837 M\ngsave 0 setgray\n[ [(Helvetica)
      140.0 0.0 true true 0 ( 0)]\n] -46.7 MCshow\ngrestore\n1.000
      UL\nLTb\nLTb\n3172 2037 M\n-47 -42 V\n1.000 UL\nLTb\nLTb\n2432 769
      M\n48 41 V\n1.000 UL\nLTb\n2368 678 M\ngsave 0 setgray\n[ [(Helvetica)
      140.0 0.0 true true 0 ( 0.5)]\n] -46.7 MCshow\ngrestore\n1.000
      UL\nLTb\nLTb\n3738 1877 M\n-47 -41 V\n1.000 UL\nLTb\nLTb\n2997 609
      M\n48 42 V\n1.000 UL\nLTb\n2934 518 M\ngsave 0 setgray\n[ [(Helvetica)
      140.0 0.0 true true 0 ( 1)]\n] -46.7 MCshow\ngrestore\n1.000
      UL\nLTb\nLTb\n4305 1717 M\n-48 -41 V\n1.000 UL\nLTb\nLTb\n2997 609
      M\n-60 18 V\n stroke\n3078 570 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 (-1)]\n] -46.7 MLshow\ngrestore\n1.000
      UL\nLTb\nLTb\n733 1249 M\n61 -18 V\n1.000 UL\nLTb\nLTb\n3324 886 M\n-61
      18 V\n stroke\n3405 847 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0
      true true 0 (-0.5)]\n] -46.7 MLshow\ngrestore\n1.000 UL\nLTb\nLTb\n1060
      1526 M\n61 -18 V\n1.000 UL\nLTb\nLTb\n3651 1163 M\n-61 18 V\n
      stroke\n3732 1124 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 ( 0)]\n] -46.7 MLshow\ngrestore\n1.000 UL\nLTb\nLTb\n1387 1803
      M\n61 -18 V\n1.000 UL\nLTb\nLTb\n3978 1440 M\n-61 17 V\n stroke\n4058
      1401 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (
      0.5)]\n] -46.7 MLshow\ngrestore\n1.000 UL\nLTb\nLTb\n1714 2080 M\n61
      -18 V\n1.000 UL\nLTb\nLTb\n4305 1717 M\n-61 17 V\n stroke\n4385 1678
      M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 ( 1)]\n] -46.7
      MLshow\ngrestore\n1.000 UL\nLTb\nLTb\n2041 2356 M\n60 -17 V\n1.000
      UL\nLTb\nLTb\n733 1987 M\n63 0 V\n stroke\n607 1987 M\ngsave 0
      setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-4)]\n] -46.7
      MRshow\ngrestore\n1.000 UL\nLTb\nLTb\n733 2151 M\n63 0 V\n stroke\n607
      2151 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0
      (-3.5)]\n] -46.7 MRshow\ngrestore\n1.000 UL\nLTb\nLTb\n733 2315 M\n63 0
      V\n stroke\n607 2315 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 (-3)]\n] -46.7 MRshow\ngrestore\n1.000 UL\nLTb\nLTb\n733 2479
      M\n63 0 V\n stroke\n607 2479 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 (-2.5)]\n] -46.7 MRshow\ngrestore\n1.000
      UL\nLTb\nLTb\n733 2643 M\n63 0 V\n stroke\n607 2643 M\ngsave 0
      setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (-2)]\n] -46.7
      MRshow\ngrestore\n1.000 UL\nLTb\nLTb\n733 2807 M\n63 0 V\n stroke\n607
      2807 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0
      (-1.5)]\n] -46.7 MRshow\ngrestore\n1.000 UL\nLTb\nLTb\n733 2971 M\n63 0
      V\n stroke\n607 2971 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true
      true 0 (-1)]\n] -46.7 MRshow\ngrestore\n1.000 UL\nLTb\nLTb\n733 3135
      M\n63 0 V\n stroke\n607 3135 M\ngsave 0 setgray\n[ [(Helvetica) 140.0
      0.0 true true 0 (-0.5)]\n] -46.7 MRshow\ngrestore\n1.000
      UL\nLTb\nLTb\n733 3299 M\n63 0 V\n stroke\n607 3299 M\ngsave 0
      setgray\n[ [(Helvetica) 140.0 0.0 true true 0 ( 0)]\n] -46.7
      MRshow\ngrestore\n1.000 UL\nLTb\nLTb\n733 3463 M\n63 0 V\n stroke\n607
      3463 M\ngsave 0 setgray\n[ [(Helvetica) 140.0 0.0 true true 0 (
      0.5)]\n] -46.7 MRshow\ngrestore\n1.000
      UP\nstroke\ngrestore\nend\nshowpage\n%%Trailer\n%%DocumentFonts:
      Helvetica\n>|ps>||||||>

      \;
    </output>

    <\input|GNUplot] >
      set pm3d at s ~set palette rgb 3,3,3 ~set nocolorbox
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~set parametric ~set nokey ~set
      noztics \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~set
      urange[-5:5] ~set vrange[0:10] ~set yrange[0:10] ~set zrange[0:1]
      \ \ \ \ \ \ \ ~set isosamples 100,100 ~set view 0,0,1.5,1
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~set
      multiplot ~set size 1,1 ~set origin 0,0 ~set nosurface
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~splot u, v, (v\<less\> u**2)? 1:0.8
      ~set size 1,1 \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~set
      origin ~set surface \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~splot
      u, u**2, 1 with lines lt 1 lw 3 \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ~unset
      multiplot
    </input>

    <\output>
      <postscript|<tuple|<raw_data|%!PS-Adobe-2.0 EPSF-2.0\n%%Title:
      temp.eps\n%%Creator: gnuplot 3.8h patchlevel 0\n%%CreationDate: Sat Mar
      29 13:01:26 2003\n%%DocumentFonts: (atend)\n%%BoundingBox: 50 50 410
      302\n%%Orientation: Portrait\n%%EndComments\n/gnudict 256 dict
      def\ngnudict begin\n/Color false def\n/Solid false def\n/gnulinewidth
      5.000 def\n/userlinewidth gnulinewidth def\n/vshift -46 def\n/dl {10.0
      mul} def\n/hpt_ 31.5 def\n/vpt_ 31.5 def\n/hpt hpt_ def\n/vpt vpt_
      def\n/M {moveto} bind def\n/L {lineto} bind def\n/R {rmoveto} bind
      def\n/V {rlineto} bind def\n/N {newpath moveto} bind def\n/f {rlineto
      fill} bind def\n/vpt2 vpt 2 mul def\n/hpt2 hpt 2 mul def\n/Lshow {
      currentpoint stroke M\n \ 0 vshift R show } def\n/Rshow { currentpoint
      stroke M\n \ dup stringwidth pop neg vshift R show } def\n/Cshow {
      currentpoint stroke M\n \ dup stringwidth pop -2 div vshift R show }
      def\n/UP { dup vpt_ mul /vpt exch def hpt_ mul /hpt exch def\n \ /hpt2
      hpt 2 mul def /vpt2 vpt 2 mul def } def\n/DL { Color {setrgbcolor Solid
      {pop []} if 0 setdash }\n {pop pop pop Solid {pop []} if 0 setdash}
      ifelse } def\n/BL { stroke userlinewidth 2 mul setlinewidth } def\n/AL
      { stroke userlinewidth 2 div setlinewidth } def\n/UL { dup gnulinewidth
      mul /userlinewidth exch def\n \ \ \ \ \ dup 1 lt {pop 1} if 10 mul /udl
      exch def } def\n/PL { stroke userlinewidth setlinewidth } def\n/LTb {
      BL [] 0 0 0 DL } def\n/LTa { AL [1 udl mul 2 udl mul] 0 setdash 0 0 0
      setrgbcolor } def\n/LT0 { PL [] 1 0 0 DL } def\n/LT1 { PL [4 dl 2 dl] 0
      1 0 DL } def\n/LT2 { PL [2 dl 3 dl] 0 0 1 DL } def\n/LT3 { PL [1 dl 1.5
      dl] 1 0 1 DL } def\n/LT4 { PL [5 dl 2 dl 1 dl 2 dl] 0 1 1 DL }
      def\n/LT5 { PL [4 dl 3 dl 1 dl 3 dl] 1 1 0 DL } def\n/LT6 { PL [2 dl 2
      dl 2 dl 4 dl] 0 0 0 DL } def\n/LT7 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      1 0.3 0 DL } def\n/LT8 { PL [2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 2 dl 4 dl]
      0.5 0.5 0.5 DL } def\n/Pnt { stroke [] 0 setdash\n \ \ gsave 1
      setlinecap M 0 0 V stroke grestore } def\n/Dia { stroke [] 0 setdash 2
      copy vpt add M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt
      neg vpt V closepath stroke\n \ Pnt } def\n/Pls { stroke [] 0 setdash
      vpt sub M 0 vpt2 V\n \ currentpoint stroke M\n \ hpt neg vpt neg R hpt2
      0 V stroke\n \ } def\n/Box { stroke [] 0 setdash 2 copy exch hpt sub
      exch vpt add M\n \ 0 vpt2 neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V
      closepath stroke\n \ Pnt } def\n/Crs { stroke [] 0 setdash exch hpt sub
      exch vpt add M\n \ hpt2 vpt2 neg V currentpoint stroke M\n \ hpt2 neg 0
      R hpt2 vpt2 V stroke } def\n/TriU { stroke [] 0 setdash 2 copy vpt 1.12
      mul add M\n \ hpt neg vpt -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      1.62 mul V closepath stroke\n \ Pnt \ } def\n/Star { 2 copy Pls Crs }
      def\n/BoxF { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V \ hpt2 0 V \ 0 vpt2 V\n \ hpt2 neg 0 V \ closepath fill }
      def\n/TriUF { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt
      -1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath fill
      } def\n/TriD { stroke [] 0 setdash 2 copy vpt 1.12 mul sub M\n \ hpt
      neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V
      closepath stroke\n \ Pnt \ } def\n/TriDF { stroke [] 0 setdash vpt 1.12
      mul sub M\n \ hpt neg vpt 1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt
      -1.62 mul V closepath fill} def\n/DiaF { stroke [] 0 setdash vpt add
      M\n \ hpt neg vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V
      closepath fill } def\n/Pent { stroke [] 0 setdash 2 copy gsave\n
      \ translate 0 hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath stroke
      grestore Pnt } def\n/PentF { stroke [] 0 setdash gsave\n \ translate 0
      hpt M 4 {72 rotate 0 hpt L} repeat\n \ closepath fill grestore }
      def\n/Circle { stroke [] 0 setdash 2 copy\n \ hpt 0 360 arc stroke Pnt
      } def\n/CircleF { stroke [] 0 setdash hpt 0 360 arc fill } def\n/C0 {
      BL [] 0 setdash 2 copy moveto vpt 90 450 \ arc } bind def\n/C1 { BL []
      0 setdash 2 copy \ \ \ \ \ \ \ moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C2 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C3 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath }
      bind def\n/C4 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy
      \ vpt 180 270 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C5 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 0 90 arc\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 270 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C6 { BL [] 0
      setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 90 270 arc closepath
      fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind
      def\n/C7 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy \ vpt 0 270
      arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath
      } bind def\n/C8 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2 copy vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C9 { BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ 2
      copy \ vpt 270 450 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0
      360 arc closepath } bind def\n/C10 { BL [] 0 setdash 2 copy 2 copy
      moveto vpt 270 360 arc closepath fill\n \ \ \ \ \ \ 2 copy moveto\n
      \ \ \ \ \ \ 2 copy vpt 90 180 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C11 {
      BL [] 0 setdash 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 180 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      270 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C12 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 180 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/C13 {
      BL [] 0 setdash \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt 0 90 arc
      closepath fill\n \ \ \ \ \ \ 2 copy moveto\n \ \ \ \ \ \ 2 copy \ vpt
      180 360 arc closepath fill\n \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc
      closepath } bind def\n/C14 { BL [] 0 setdash 2 copy moveto\n
      \ \ \ \ \ \ 2 copy \ vpt 90 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc } bind def\n/C15 { BL [] 0
      setdash 2 copy vpt 0 360 arc closepath fill\n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ vpt 0 360 arc closepath } bind def\n/Rec
      \ \ { newpath 4 2 roll moveto 1 index 0 rlineto 0 exch rlineto\n
      \ \ \ \ \ \ neg 0 rlineto closepath } bind def\n/Square { dup Rec }
      bind def\n/Bsquare { vpt sub exch vpt sub exch vpt2 Square } bind
      def\n/S0 { BL [] 0 setdash 2 copy moveto 0 vpt rlineto BL Bsquare }
      bind def\n/S1 { BL [] 0 setdash 2 copy vpt Square fill Bsquare } bind
      def\n/S2 { BL [] 0 setdash 2 copy exch vpt sub exch vpt Square fill
      Bsquare } bind def\n/S3 { BL [] 0 setdash 2 copy exch vpt sub exch vpt2
      vpt Rec fill Bsquare } bind def\n/S4 { BL [] 0 setdash 2 copy exch vpt
      sub exch vpt sub vpt Square fill Bsquare } bind def\n/S5 { BL [] 0
      setdash 2 copy 2 copy vpt Square fill\n \ \ \ \ \ \ exch vpt sub exch
      vpt sub vpt Square fill Bsquare } bind def\n/S6 { BL [] 0 setdash 2
      copy exch vpt sub exch vpt sub vpt vpt2 Rec fill Bsquare } bind
      def\n/S7 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt vpt2
      Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S8 { BL [] 0 setdash 2 copy vpt sub vpt Square fill Bsquare
      } bind def\n/S9 { BL [] 0 setdash 2 copy vpt sub vpt vpt2 Rec fill
      Bsquare } bind def\n/S10 { BL [] 0 setdash 2 copy vpt sub vpt Square
      fill 2 copy exch vpt sub exch vpt Square fill\n \ \ \ \ \ \ Bsquare }
      bind def\n/S11 { BL [] 0 setdash 2 copy vpt sub vpt Square fill 2 copy
      exch vpt sub exch vpt2 vpt Rec fill\n \ \ \ \ \ \ Bsquare } bind
      def\n/S12 { BL [] 0 setdash 2 copy exch vpt sub exch vpt sub vpt2 vpt
      Rec fill Bsquare } bind def\n/S13 { BL [] 0 setdash 2 copy exch vpt sub
      exch vpt sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy vpt Square fill
      Bsquare } bind def\n/S14 { BL [] 0 setdash 2 copy exch vpt sub exch vpt
      sub vpt2 vpt Rec fill\n \ \ \ \ \ \ 2 copy exch vpt sub exch vpt Square
      fill Bsquare } bind def\n/S15 { BL [] 0 setdash 2 copy Bsquare fill
      Bsquare } bind def\n/D0 { gsave translate 45 rotate 0 0 S0 stroke
      grestore } bind def\n/D1 { gsave translate 45 rotate 0 0 S1 stroke
      grestore } bind def\n/D2 { gsave translate 45 rotate 0 0 S2 stroke
      grestore } bind def\n/D3 { gsave translate 45 rotate 0 0 S3 stroke
      grestore } bind def\n/D4 { gsave translate 45 rotate 0 0 S4 stroke
      grestore } bind def\n/D5 { gsave translate 45 rotate 0 0 S5 stroke
      grestore } bind def\n/D6 { gsave translate 45 rotate 0 0 S6 stroke
      grestore } bind def\n/D7 { gsave translate 45 rotate 0 0 S7 stroke
      grestore } bind def\n/D8 { gsave translate 45 rotate 0 0 S8 stroke
      grestore } bind def\n/D9 { gsave translate 45 rotate 0 0 S9 stroke
      grestore } bind def\n/D10 { gsave translate 45 rotate 0 0 S10 stroke
      grestore } bind def\n/D11 { gsave translate 45 rotate 0 0 S11 stroke
      grestore } bind def\n/D12 { gsave translate 45 rotate 0 0 S12 stroke
      grestore } bind def\n/D13 { gsave translate 45 rotate 0 0 S13 stroke
      grestore } bind def\n/D14 { gsave translate 45 rotate 0 0 S14 stroke
      grestore } bind def\n/D15 { gsave translate 45 rotate 0 0 S15 stroke
      grestore } bind def\n/DiaE { stroke [] 0 setdash vpt add M\n \ hpt neg
      vpt neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V closepath stroke }
      def\n/BoxE { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V closepath stroke } def\n/TriUE
      { stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V closepath stroke }
      def\n/TriDE { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt
      1.62 mul V\n \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V closepath
      stroke } def\n/PentE { stroke [] 0 setdash gsave\n \ translate 0 hpt M
      4 {72 rotate 0 hpt L} repeat\n \ closepath stroke grestore }
      def\n/CircE { stroke [] 0 setdash \n \ hpt 0 360 arc stroke }
      def\n/Opaque { gsave closepath 1 setgray fill grestore 0 setgray
      closepath } def\n/DiaW { stroke [] 0 setdash vpt add M\n \ hpt neg vpt
      neg V hpt vpt neg V\n \ hpt vpt V hpt neg vpt V Opaque stroke }
      def\n/BoxW { stroke [] 0 setdash exch hpt sub exch vpt add M\n \ 0 vpt2
      neg V hpt2 0 V 0 vpt2 V\n \ hpt2 neg 0 V Opaque stroke } def\n/TriUW {
      stroke [] 0 setdash vpt 1.12 mul add M\n \ hpt neg vpt -1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt 1.62 mul V Opaque stroke } def\n/TriDW
      { stroke [] 0 setdash vpt 1.12 mul sub M\n \ hpt neg vpt 1.62 mul V\n
      \ hpt 2 mul 0 V\n \ hpt neg vpt -1.62 mul V Opaque stroke } def\n/PentW
      { stroke [] 0 setdash gsave\n \ translate 0 hpt M 4 {72 rotate 0 hpt L}
      repeat\n \ Opaque stroke grestore } def\n/CircW { stroke [] 0 setdash
      \n \ hpt 0 360 arc Opaque stroke } def\n/BoxFill { gsave Rec 1 setgray
      fill grestore } def\n/Symbol-Oblique /Symbol findfont [1 0 .167 1 0 0]
      makefont\ndup length dict begin {1 index /FID eq {pop pop} {def}
      ifelse} forall\ncurrentdict end definefont pop\n/MFshow {{dup dup 0 get
      findfont exch 1 get scalefont setfont\n \ \ \ \ [ currentpoint ] exch
      dup 2 get 0 exch R dup 5 get 2 ne {dup dup 6\n \ \ \ \ get exch 4 get
      {show} {stringwidth pop 0 R} ifelse }if dup 5 get 0 eq\n \ \ \ \ {dup 3
      get {2 get neg 0 exch R pop} {pop aload pop M} ifelse} {dup 5\n
      \ \ \ \ get 1 eq {dup 2 get exch dup 3 get exch 6 get stringwidth pop
      -2 div\n \ \ \ \ dup 0 R} {dup 6 get stringwidth pop -2 div 0 R 6 get\n
      \ \ \ \ show 2 index {aload pop M neg 3 -1 roll neg R pop pop} {pop pop
      pop\n \ \ \ \ pop aload pop M} ifelse }ifelse }ifelse } forall} bind
      def\n/MFwidth {0 exch {dup 3 get{dup dup 0 get findfont exch 1 get
      scalefont\n \ \ \ \ setfont 6 get stringwidth pop add} {pop} ifelse}
      forall} bind def\n/MLshow { currentpoint stroke M\n \ 0 exch R MFshow }
      bind def\n/MRshow { currentpoint stroke M\n \ exch dup MFwidth neg 3 -1
      roll R MFshow } def\n/MCshow { currentpoint stroke M\n \ exch dup
      MFwidth -2 div 3 -1 roll R MFshow } def\nend\n%%EndProlog\ngnudict
      begin\ngsave\n50 50 translate\n0.050 0.050 scale\n0
      setgray\nnewpath\n(Helvetica) findfont 140 scalefont setfont\n1.000
      UL\nLTb\ngsave %% colour palette begin\n/maxcolors 0
      def\n/maxcolorsLast {maxcolors 1 sub maxcolors div} def\n/pm3dround
      {maxcolors 0 gt {dup maxcolorsLast ge {pop 1} {maxcolors mul floor
      maxcolors div} ifelse} if} def\n/cF3 { } bind def\t% x\nColor true and
      { % COLOUR vs. GRAY map\n \ /g {stroke pm3dround dup cF3 exch dup cF3
      exch cF3 setrgbcolor} bind def\n \ /h {rlineto rlineto rlineto fill}
      bind def\n}{\n \ /g {stroke pm3dround setgray} bind def\n \ /h {rlineto
      rlineto rlineto fill} bind def\n} ifelse\n%pm3d_map_begin\n1 g 5957
      4508 N 0 39 49 0 0 -39 h\n1 g 5909 4508 N 0 39 48 0 0 -39 h\n1 g 5860
      4508 N 0 39 49 0 0 -39 h\n1 g 5811 4508 N 0 39 49 0 0 -39 h\n1 g 5763
      4508 N 0 39 48 0 0 -39 h\n1 g 5714 4508 N 0 39 49 0 0 -39 h\n1 g 5665
      4508 N 0 39 49 0 0 -39 h\n1 g 5617 4508 N 0 39 48 0 0 -39 h\n1 g 5568
      4508 N 0 39 49 0 0 -39 h\n1 g 5520 4508 N 0 39 48 0 0 -39 h\n1 g 5471
      4508 N 0 39 49 0 0 -39 h\n1 g 5422 4508 N 0 39 49 0 0 -39 h\n1 g 5374
      4508 N 0 39 48 0 0 -39 h\n1 g 5325 4508 N 0 39 49 0 0 -39 h\n1 g 5277
      4508 N 0 39 48 0 0 -39 h\n1 g 5228 4508 N 0 39 49 0 0 -39 h\n1 g 5179
      4508 N 0 39 49 0 0 -39 h\n1 g 5131 4508 N 0 39 48 0 0 -39 h\n.9 g 5082
      4508 N 0 39 49 0 0 -39 h\n.8 g 5034 4508 N 0 39 48 0 0 -39 h\n.8 g 4985
      4508 N 0 39 49 0 0 -39 h\n.8 g 4936 4508 N 0 39 49 0 0 -39 h\n.8 g 4888
      4508 N 0 39 48 0 0 -39 h\n.8 g 4839 4508 N 0 39 49 0 0 -39 h\n.8 g 4790
      4508 N 0 39 49 0 0 -39 h\n.8 g 4742 4508 N 0 39 48 0 0 -39 h\n.8 g 4693
      4508 N 0 39 49 0 0 -39 h\n.8 g 4645 4508 N 0 39 48 0 0 -39 h\n.8 g 4596
      4508 N 0 39 49 0 0 -39 h\n.8 g 4547 4508 N 0 39 49 0 0 -39 h\n.8 g 4499
      4508 N 0 39 48 0 0 -39 h\n.8 g 4450 4508 N 0 39 49 0 0 -39 h\n.8 g 4402
      4508 N 0 39 48 0 0 -39 h\n.8 g 4353 4508 N 0 39 49 0 0 -39 h\n.8 g 4304
      4508 N 0 39 49 0 0 -39 h\n.8 g 4256 4508 N 0 39 48 0 0 -39 h\n.8 g 4207
      4508 N 0 39 49 0 0 -39 h\n.8 g 4159 4508 N 0 39 48 0 0 -39 h\n.8 g 4110
      4508 N 0 39 49 0 0 -39 h\n.8 g 4061 4508 N 0 39 49 0 0 -39 h\n.8 g 4013
      4508 N 0 39 48 0 0 -39 h\n.8 g 3964 4508 N 0 39 49 0 0 -39 h\n.8 g 3915
      4508 N 0 39 49 0 0 -39 h\n.8 g 3867 4508 N 0 39 48 0 0 -39 h\n.8 g 3818
      4508 N 0 39 49 0 0 -39 h\n.8 g 3770 4508 N 0 39 48 0 0 -39 h\n.8 g 3721
      4508 N 0 39 49 0 0 -39 h\n.8 g 3672 4508 N 0 39 49 0 0 -39 h\n.8 g 3624
      4508 N 0 39 48 0 0 -39 h\n.8 g 3575 4508 N 0 39 49 0 0 -39 h\n.8 g 3527
      4508 N 0 39 48 0 0 -39 h\n.8 g 3478 4508 N 0 39 49 0 0 -39 h\n.8 g 3429
      4508 N 0 39 49 0 0 -39 h\n.8 g 3381 4508 N 0 39 48 0 0 -39 h\n.8 g 3332
      4508 N 0 39 49 0 0 -39 h\n.8 g 3284 4508 N 0 39 48 0 0 -39 h\n.8 g 3235
      4508 N 0 39 49 0 0 -39 h\n.8 g 3186 4508 N 0 39 49 0 0 -39 h\n.8 g 3138
      4508 N 0 39 48 0 0 -39 h\n.8 g 3089 4508 N 0 39 49 0 0 -39 h\n.8 g 3040
      4508 N 0 39 49 0 0 -39 h\n.8 g 2992 4508 N 0 39 48 0 0 -39 h\n.8 g 2943
      4508 N 0 39 49 0 0 -39 h\n.8 g 2895 4508 N 0 39 48 0 0 -39 h\n.8 g 2846
      4508 N 0 39 49 0 0 -39 h\n.8 g 2797 4508 N 0 39 49 0 0 -39 h\n.8 g 2749
      4508 N 0 39 48 0 0 -39 h\n.8 g 2700 4508 N 0 39 49 0 0 -39 h\n.8 g 2652
      4508 N 0 39 48 0 0 -39 h\n.8 g 2603 4508 N 0 39 49 0 0 -39 h\n.8 g 2554
      4508 N 0 39 49 0 0 -39 h\n.8 g 2506 4508 N 0 39 48 0 0 -39 h\n.8 g 2457
      4508 N 0 39 49 0 0 -39 h\n.8 g 2409 4508 N 0 39 48 0 0 -39 h\n.8 g 2360
      4508 N 0 39 49 0 0 -39 h\n.8 g 2311 4508 N 0 39 49 0 0 -39 h\n.8 g 2263
      4508 N 0 39 48 0 0 -39 h\n.8 g 2214 4508 N 0 39 49 0 0 -39 h\n.8 g 2165
      4508 N 0 39 49 0 0 -39 h\n.8 g 2117 4508 N 0 39 48 0 0 -39 h\n.9 g 2068
      4508 N 0 39 49 0 0 -39 h\n1 g 2020 4508 N 0 39 48 0 0 -39 h\n1 g 1971
      4508 N 0 39 49 0 0 -39 h\n1 g 1922 4508 N 0 39 49 0 0 -39 h\n1 g 1874
      4508 N 0 39 48 0 0 -39 h\n1 g 1825 4508 N 0 39 49 0 0 -39 h\n1 g 1777
      4508 N 0 39 48 0 0 -39 h\n1 g 1728 4508 N 0 39 49 0 0 -39 h\n1 g 1679
      4508 N 0 39 49 0 0 -39 h\n1 g 1631 4508 N 0 39 48 0 0 -39 h\n1 g 1582
      4508 N 0 39 49 0 0 -39 h\n1 g 1534 4508 N 0 39 48 0 0 -39 h\n1 g 1485
      4508 N 0 39 49 0 0 -39 h\n1 g 1436 4508 N 0 39 49 0 0 -39 h\n1 g 1388
      4508 N 0 39 48 0 0 -39 h\n1 g 1339 4508 N 0 39 49 0 0 -39 h\n1 g 1290
      4508 N 0 39 49 0 0 -39 h\n1 g 1242 4508 N 0 39 48 0 0 -39 h\n1 g 1193
      4508 N 0 39 49 0 0 -39 h\n1 g 5957 4469 N 0 39 49 0 0 -39 h\n1 g 5909
      4469 N 0 39 48 0 0 -39 h\n1 g 5860 4469 N 0 39 49 0 0 -39 h\n1 g 5811
      4469 N 0 39 49 0 0 -39 h\n1 g 5763 4469 N 0 39 48 0 0 -39 h\n1 g 5714
      4469 N 0 39 49 0 0 -39 h\n1 g 5665 4469 N 0 39 49 0 0 -39 h\n1 g 5617
      4469 N 0 39 48 0 0 -39 h\n1 g 5568 4469 N 0 39 49 0 0 -39 h\n1 g 5520
      4469 N 0 39 48 0 0 -39 h\n1 g 5471 4469 N 0 39 49 0 0 -39 h\n1 g 5422
      4469 N 0 39 49 0 0 -39 h\n1 g 5374 4469 N 0 39 48 0 0 -39 h\n1 g 5325
      4469 N 0 39 49 0 0 -39 h\n1 g 5277 4469 N 0 39 48 0 0 -39 h\n1 g 5228
      4469 N 0 39 49 0 0 -39 h\n1 g 5179 4469 N 0 39 49 0 0 -39 h\n1 g 5131
      4469 N 0 39 48 0 0 -39 h\n.9 g 5082 4469 N 0 39 49 0 0 -39 h\n.8 g 5034
      4469 N 0 39 48 0 0 -39 h\n.8 g 4985 4469 N 0 39 49 0 0 -39 h\n.8 g 4936
      4469 N 0 39 49 0 0 -39 h\n.8 g 4888 4469 N 0 39 48 0 0 -39 h\n.8 g 4839
      4469 N 0 39 49 0 0 -39 h\n.8 g 4790 4469 N 0 39 49 0 0 -39 h\n.8 g 4742
      4469 N 0 39 48 0 0 -39 h\n.8 g 4693 4469 N 0 39 49 0 0 -39 h\n.8 g 4645
      4469 N 0 39 48 0 0 -39 h\n.8 g 4596 4469 N 0 39 49 0 0 -39 h\n.8 g 4547
      4469 N 0 39 49 0 0 -39 h\n.8 g 4499 4469 N 0 39 48 0 0 -39 h\n.8 g 4450
      4469 N 0 39 49 0 0 -39 h\n.8 g 4402 4469 N 0 39 48 0 0 -39 h\n.8 g 4353
      4469 N 0 39 49 0 0 -39 h\n.8 g 4304 4469 N 0 39 49 0 0 -39 h\n.8 g 4256
      4469 N 0 39 48 0 0 -39 h\n.8 g 4207 4469 N 0 39 49 0 0 -39 h\n.8 g 4159
      4469 N 0 39 48 0 0 -39 h\n.8 g 4110 4469 N 0 39 49 0 0 -39 h\n.8 g 4061
      4469 N 0 39 49 0 0 -39 h\n.8 g 4013 4469 N 0 39 48 0 0 -39 h\n.8 g 3964
      4469 N 0 39 49 0 0 -39 h\n.8 g 3915 4469 N 0 39 49 0 0 -39 h\n.8 g 3867
      4469 N 0 39 48 0 0 -39 h\n.8 g 3818 4469 N 0 39 49 0 0 -39 h\n.8 g 3770
      4469 N 0 39 48 0 0 -39 h\n.8 g 3721 4469 N 0 39 49 0 0 -39 h\n.8 g 3672
      4469 N 0 39 49 0 0 -39 h\n.8 g 3624 4469 N 0 39 48 0 0 -39 h\n.8 g 3575
      4469 N 0 39 49 0 0 -39 h\n.8 g 3527 4469 N 0 39 48 0 0 -39 h\n.8 g 3478
      4469 N 0 39 49 0 0 -39 h\n.8 g 3429 4469 N 0 39 49 0 0 -39 h\n.8 g 3381
      4469 N 0 39 48 0 0 -39 h\n.8 g 3332 4469 N 0 39 49 0 0 -39 h\n.8 g 3284
      4469 N 0 39 48 0 0 -39 h\n.8 g 3235 4469 N 0 39 49 0 0 -39 h\n.8 g 3186
      4469 N 0 39 49 0 0 -39 h\n.8 g 3138 4469 N 0 39 48 0 0 -39 h\n.8 g 3089
      4469 N 0 39 49 0 0 -39 h\n.8 g 3040 4469 N 0 39 49 0 0 -39 h\n.8 g 2992
      4469 N 0 39 48 0 0 -39 h\n.8 g 2943 4469 N 0 39 49 0 0 -39 h\n.8 g 2895
      4469 N 0 39 48 0 0 -39 h\n.8 g 2846 4469 N 0 39 49 0 0 -39 h\n.8 g 2797
      4469 N 0 39 49 0 0 -39 h\n.8 g 2749 4469 N 0 39 48 0 0 -39 h\n.8 g 2700
      4469 N 0 39 49 0 0 -39 h\n.8 g 2652 4469 N 0 39 48 0 0 -39 h\n.8 g 2603
      4469 N 0 39 49 0 0 -39 h\n.8 g 2554 4469 N 0 39 49 0 0 -39 h\n.8 g 2506
      4469 N 0 39 48 0 0 -39 h\n.8 g 2457 4469 N 0 39 49 0 0 -39 h\n.8 g 2409
      4469 N 0 39 48 0 0 -39 h\n.8 g 2360 4469 N 0 39 49 0 0 -39 h\n.8 g 2311
      4469 N 0 39 49 0 0 -39 h\n.8 g 2263 4469 N 0 39 48 0 0 -39 h\n.8 g 2214
      4469 N 0 39 49 0 0 -39 h\n.8 g 2165 4469 N 0 39 49 0 0 -39 h\n.8 g 2117
      4469 N 0 39 48 0 0 -39 h\n.9 g 2068 4469 N 0 39 49 0 0 -39 h\n1 g 2020
      4469 N 0 39 48 0 0 -39 h\n1 g 1971 4469 N 0 39 49 0 0 -39 h\n1 g 1922
      4469 N 0 39 49 0 0 -39 h\n1 g 1874 4469 N 0 39 48 0 0 -39 h\n1 g 1825
      4469 N 0 39 49 0 0 -39 h\n1 g 1777 4469 N 0 39 48 0 0 -39 h\n1 g 1728
      4469 N 0 39 49 0 0 -39 h\n1 g 1679 4469 N 0 39 49 0 0 -39 h\n1 g 1631
      4469 N 0 39 48 0 0 -39 h\n1 g 1582 4469 N 0 39 49 0 0 -39 h\n1 g 1534
      4469 N 0 39 48 0 0 -39 h\n1 g 1485 4469 N 0 39 49 0 0 -39 h\n1 g 1436
      4469 N 0 39 49 0 0 -39 h\n1 g 1388 4469 N 0 39 48 0 0 -39 h\n1 g 1339
      4469 N 0 39 49 0 0 -39 h\n1 g 1290 4469 N 0 39 49 0 0 -39 h\n1 g 1242
      4469 N 0 39 48 0 0 -39 h\n1 g 1193 4469 N 0 39 49 0 0 -39 h\n1 g 5957
      4430 N 0 38 49 0 0 -38 h\n1 g 5909 4430 N 0 38 48 0 0 -38 h\n1 g 5860
      4430 N 0 38 49 0 0 -38 h\n1 g 5811 4430 N 0 38 49 0 0 -38 h\n1 g 5763
      4430 N 0 38 48 0 0 -38 h\n1 g 5714 4430 N 0 38 49 0 0 -38 h\n1 g 5665
      4430 N 0 38 49 0 0 -38 h\n1 g 5617 4430 N 0 38 48 0 0 -38 h\n1 g 5568
      4430 N 0 38 49 0 0 -38 h\n1 g 5520 4430 N 0 38 48 0 0 -38 h\n1 g 5471
      4430 N 0 38 49 0 0 -38 h\n1 g 5422 4430 N 0 38 49 0 0 -38 h\n1 g 5374
      4430 N 0 38 48 0 0 -38 h\n1 g 5325 4430 N 0 38 49 0 0 -38 h\n1 g 5277
      4430 N 0 38 48 0 0 -38 h\n1 g 5228 4430 N 0 38 49 0 0 -38 h\n1 g 5179
      4430 N 0 38 49 0 0 -38 h\n1 g 5131 4430 N 0 38 48 0 0 -38 h\n.9 g 5082
      4430 N 0 38 49 0 0 -38 h\n.8 g 5034 4430 N 0 38 48 0 0 -38 h\n.8 g 4985
      4430 N 0 38 49 0 0 -38 h\n.8 g 4936 4430 N 0 38 49 0 0 -38 h\n.8 g 4888
      4430 N 0 38 48 0 0 -38 h\n.8 g 4839 4430 N 0 38 49 0 0 -38 h\n.8 g 4790
      4430 N 0 38 49 0 0 -38 h\n.8 g 4742 4430 N 0 38 48 0 0 -38 h\n.8 g 4693
      4430 N 0 38 49 0 0 -38 h\n.8 g 4645 4430 N 0 38 48 0 0 -38 h\n.8 g 4596
      4430 N 0 38 49 0 0 -38 h\n.8 g 4547 4430 N 0 38 49 0 0 -38 h\n.8 g 4499
      4430 N 0 38 48 0 0 -38 h\n.8 g 4450 4430 N 0 38 49 0 0 -38 h\n.8 g 4402
      4430 N 0 38 48 0 0 -38 h\n.8 g 4353 4430 N 0 38 49 0 0 -38 h\n.8 g 4304
      4430 N 0 38 49 0 0 -38 h\n.8 g 4256 4430 N 0 38 48 0 0 -38 h\n.8 g 4207
      4430 N 0 38 49 0 0 -38 h\n.8 g 4159 4430 N 0 38 48 0 0 -38 h\n.8 g 4110
      4430 N 0 38 49 0 0 -38 h\n.8 g 4061 4430 N 0 38 49 0 0 -38 h\n.8 g 4013
      4430 N 0 38 48 0 0 -38 h\n.8 g 3964 4430 N 0 38 49 0 0 -38 h\n.8 g 3915
      4430 N 0 38 49 0 0 -38 h\n.8 g 3867 4430 N 0 38 48 0 0 -38 h\n.8 g 3818
      4430 N 0 38 49 0 0 -38 h\n.8 g 3770 4430 N 0 38 48 0 0 -38 h\n.8 g 3721
      4430 N 0 38 49 0 0 -38 h\n.8 g 3672 4430 N 0 38 49 0 0 -38 h\n.8 g 3624
      4430 N 0 38 48 0 0 -38 h\n.8 g 3575 4430 N 0 38 49 0 0 -38 h\n.8 g 3527
      4430 N 0 38 48 0 0 -38 h\n.8 g 3478 4430 N 0 38 49 0 0 -38 h\n.8 g 3429
      4430 N 0 38 49 0 0 -38 h\n.8 g 3381 4430 N 0 38 48 0 0 -38 h\n.8 g 3332
      4430 N 0 38 49 0 0 -38 h\n.8 g 3284 4430 N 0 38 48 0 0 -38 h\n.8 g 3235
      4430 N 0 38 49 0 0 -38 h\n.8 g 3186 4430 N 0 38 49 0 0 -38 h\n.8 g 3138
      4430 N 0 38 48 0 0 -38 h\n.8 g 3089 4430 N 0 38 49 0 0 -38 h\n.8 g 3040
      4430 N 0 38 49 0 0 -38 h\n.8 g 2992 4430 N 0 38 48 0 0 -38 h\n.8 g 2943
      4430 N 0 38 49 0 0 -38 h\n.8 g 2895 4430 N 0 38 48 0 0 -38 h\n.8 g 2846
      4430 N 0 38 49 0 0 -38 h\n.8 g 2797 4430 N 0 38 49 0 0 -38 h\n.8 g 2749
      4430 N 0 38 48 0 0 -38 h\n.8 g 2700 4430 N 0 38 49 0 0 -38 h\n.8 g 2652
      4430 N 0 38 48 0 0 -38 h\n.8 g 2603 4430 N 0 38 49 0 0 -38 h\n.8 g 2554
      4430 N 0 38 49 0 0 -38 h\n.8 g 2506 4430 N 0 38 48 0 0 -38 h\n.8 g 2457
      4430 N 0 38 49 0 0 -38 h\n.8 g 2409 4430 N 0 38 48 0 0 -38 h\n.8 g 2360
      4430 N 0 38 49 0 0 -38 h\n.8 g 2311 4430 N 0 38 49 0 0 -38 h\n.8 g 2263
      4430 N 0 38 48 0 0 -38 h\n.8 g 2214 4430 N 0 38 49 0 0 -38 h\n.8 g 2165
      4430 N 0 38 49 0 0 -38 h\n.8 g 2117 4430 N 0 38 48 0 0 -38 h\n.9 g 2068
      4430 N 0 38 49 0 0 -38 h\n1 g 2020 4430 N 0 38 48 0 0 -38 h\n1 g 1971
      4430 N 0 38 49 0 0 -38 h\n1 g 1922 4430 N 0 38 49 0 0 -38 h\n1 g 1874
      4430 N 0 38 48 0 0 -38 h\n1 g 1825 4430 N 0 38 49 0 0 -38 h\n1 g 1777
      4430 N 0 38 48 0 0 -38 h\n1 g 1728 4430 N 0 38 49 0 0 -38 h\n1 g 1679
      4430 N 0 38 49 0 0 -38 h\n1 g 1631 4430 N 0 38 48 0 0 -38 h\n1 g 1582
      4430 N 0 38 49 0 0 -38 h\n1 g 1534 4430 N 0 38 48 0 0 -38 h\n1 g 1485
      4430 N 0 38 49 0 0 -38 h\n1 g 1436 4430 N 0 38 49 0 0 -38 h\n1 g 1388
      4430 N 0 38 48 0 0 -38 h\n1 g 1339 4430 N 0 38 49 0 0 -38 h\n1 g 1290
      4430 N 0 38 49 0 0 -38 h\n1 g 1242 4430 N 0 38 48 0 0 -38 h\n1 g 1193
      4430 N 0 38 49 0 0 -38 h\n1 g 5957 4392 N 0 39 49 0 0 -39 h\n1 g 5909
      4392 N 0 39 48 0 0 -39 h\n1 g 5860 4392 N 0 39 49 0 0 -39 h\n1 g 5811
      4392 N 0 39 49 0 0 -39 h\n1 g 5763 4392 N 0 39 48 0 0 -39 h\n1 g 5714
      4392 N 0 39 49 0 0 -39 h\n1 g 5665 4392 N 0 39 49 0 0 -39 h\n1 g 5617
      4392 N 0 39 48 0 0 -39 h\n1 g 5568 4392 N 0 39 49 0 0 -39 h\n1 g 5520
      4392 N 0 39 48 0 0 -39 h\n1 g 5471 4392 N 0 39 49 0 0 -39 h\n1 g 5422
      4392 N 0 39 49 0 0 -39 h\n1 g 5374 4392 N 0 39 48 0 0 -39 h\n1 g 5325
      4392 N 0 39 49 0 0 -39 h\n1 g 5277 4392 N 0 39 48 0 0 -39 h\n1 g 5228
      4392 N 0 39 49 0 0 -39 h\n1 g 5179 4392 N 0 39 49 0 0 -39 h\n1 g 5131
      4392 N 0 39 48 0 0 -39 h\n.9 g 5082 4392 N 0 39 49 0 0 -39 h\n.8 g 5034
      4392 N 0 39 48 0 0 -39 h\n.8 g 4985 4392 N 0 39 49 0 0 -39 h\n.8 g 4936
      4392 N 0 39 49 0 0 -39 h\n.8 g 4888 4392 N 0 39 48 0 0 -39 h\n.8 g 4839
      4392 N 0 39 49 0 0 -39 h\n.8 g 4790 4392 N 0 39 49 0 0 -39 h\n.8 g 4742
      4392 N 0 39 48 0 0 -39 h\n.8 g 4693 4392 N 0 39 49 0 0 -39 h\n.8 g 4645
      4392 N 0 39 48 0 0 -39 h\n.8 g 4596 4392 N 0 39 49 0 0 -39 h\n.8 g 4547
      4392 N 0 39 49 0 0 -39 h\n.8 g 4499 4392 N 0 39 48 0 0 -39 h\n.8 g 4450
      4392 N 0 39 49 0 0 -39 h\n.8 g 4402 4392 N 0 39 48 0 0 -39 h\n.8 g 4353
      4392 N 0 39 49 0 0 -39 h\n.8 g 4304 4392 N 0 39 49 0 0 -39 h\n.8 g 4256
      4392 N 0 39 48 0 0 -39 h\n.8 g 4207 4392 N 0 39 49 0 0 -39 h\n.8 g 4159
      4392 N 0 39 48 0 0 -39 h\n.8 g 4110 4392 N 0 39 49 0 0 -39 h\n.8 g 4061
      4392 N 0 39 49 0 0 -39 h\n.8 g 4013 4392 N 0 39 48 0 0 -39 h\n.8 g 3964
      4392 N 0 39 49 0 0 -39 h\n.8 g 3915 4392 N 0 39 49 0 0 -39 h\n.8 g 3867
      4392 N 0 39 48 0 0 -39 h\n.8 g 3818 4392 N 0 39 49 0 0 -39 h\n.8 g 3770
      4392 N 0 39 48 0 0 -39 h\n.8 g 3721 4392 N 0 39 49 0 0 -39 h\n.8 g 3672
      4392 N 0 39 49 0 0 -39 h\n.8 g 3624 4392 N 0 39 48 0 0 -39 h\n.8 g 3575
      4392 N 0 39 49 0 0 -39 h\n.8 g 3527 4392 N 0 39 48 0 0 -39 h\n.8 g 3478
      4392 N 0 39 49 0 0 -39 h\n.8 g 3429 4392 N 0 39 49 0 0 -39 h\n.8 g 3381
      4392 N 0 39 48 0 0 -39 h\n.8 g 3332 4392 N 0 39 49 0 0 -39 h\n.8 g 3284
      4392 N 0 39 48 0 0 -39 h\n.8 g 3235 4392 N 0 39 49 0 0 -39 h\n.8 g 3186
      4392 N 0 39 49 0 0 -39 h\n.8 g 3138 4392 N 0 39 48 0 0 -39 h\n.8 g 3089
      4392 N 0 39 49 0 0 -39 h\n.8 g 3040 4392 N 0 39 49 0 0 -39 h\n.8 g 2992
      4392 N 0 39 48 0 0 -39 h\n.8 g 2943 4392 N 0 39 49 0 0 -39 h\n.8 g 2895
      4392 N 0 39 48 0 0 -39 h\n.8 g 2846 4392 N 0 39 49 0 0 -39 h\n.8 g 2797
      4392 N 0 39 49 0 0 -39 h\n.8 g 2749 4392 N 0 39 48 0 0 -39 h\n.8 g 2700
      4392 N 0 39 49 0 0 -39 h\n.8 g 2652 4392 N 0 39 48 0 0 -39 h\n.8 g 2603
      4392 N 0 39 49 0 0 -39 h\n.8 g 2554 4392 N 0 39 49 0 0 -39 h\n.8 g 2506
      4392 N 0 39 48 0 0 -39 h\n.8 g 2457 4392 N 0 39 49 0 0 -39 h\n.8 g 2409
      4392 N 0 39 48 0 0 -39 h\n.8 g 2360 4392 N 0 39 49 0 0 -39 h\n.8 g 2311
      4392 N 0 39 49 0 0 -39 h\n.8 g 2263 4392 N 0 39 48 0 0 -39 h\n.8 g 2214
      4392 N 0 39 49 0 0 -39 h\n.8 g 2165 4392 N 0 39 49 0 0 -39 h\n.8 g 2117
      4392 N 0 39 48 0 0 -39 h\n.9 g 2068 4392 N 0 39 49 0 0 -39 h\n1 g 2020
      4392 N 0 39 48 0 0 -39 h\n1 g 1971 4392 N 0 39 49 0 0 -39 h\n1 g 1922
      4392 N 0 39 49 0 0 -39 h\n1 g 1874 4392 N 0 39 48 0 0 -39 h\n1 g 1825
      4392 N 0 39 49 0 0 -39 h\n1 g 1777 4392 N 0 39 48 0 0 -39 h\n1 g 1728
      4392 N 0 39 49 0 0 -39 h\n1 g 1679 4392 N 0 39 49 0 0 -39 h\n1 g 1631
      4392 N 0 39 48 0 0 -39 h\n1 g 1582 4392 N 0 39 49 0 0 -39 h\n1 g 1534
      4392 N 0 39 48 0 0 -39 h\n1 g 1485 4392 N 0 39 49 0 0 -39 h\n1 g 1436
      4392 N 0 39 49 0 0 -39 h\n1 g 1388 4392 N 0 39 48 0 0 -39 h\n1 g 1339
      4392 N 0 39 49 0 0 -39 h\n1 g 1290 4392 N 0 39 49 0 0 -39 h\n1 g 1242
      4392 N 0 39 48 0 0 -39 h\n1 g 1193 4392 N 0 39 49 0 0 -39 h\n1 g 5957
      4353 N 0 39 49 0 0 -39 h\n1 g 5909 4353 N 0 39 48 0 0 -39 h\n1 g 5860
      4353 N 0 39 49 0 0 -39 h\n1 g 5811 4353 N 0 39 49 0 0 -39 h\n1 g 5763
      4353 N 0 39 48 0 0 -39 h\n1 g 5714 4353 N 0 39 49 0 0 -39 h\n1 g 5665
      4353 N 0 39 49 0 0 -39 h\n1 g 5617 4353 N 0 39 48 0 0 -39 h\n1 g 5568
      4353 N 0 39 49 0 0 -39 h\n1 g 5520 4353 N 0 39 48 0 0 -39 h\n1 g 5471
      4353 N 0 39 49 0 0 -39 h\n1 g 5422 4353 N 0 39 49 0 0 -39 h\n1 g 5374
      4353 N 0 39 48 0 0 -39 h\n1 g 5325 4353 N 0 39 49 0 0 -39 h\n1 g 5277
      4353 N 0 39 48 0 0 -39 h\n1 g 5228 4353 N 0 39 49 0 0 -39 h\n1 g 5179
      4353 N 0 39 49 0 0 -39 h\n1 g 5131 4353 N 0 39 48 0 0 -39 h\n.9 g 5082
      4353 N 0 39 49 0 0 -39 h\n.8 g 5034 4353 N 0 39 48 0 0 -39 h\n.8 g 4985
      4353 N 0 39 49 0 0 -39 h\n.8 g 4936 4353 N 0 39 49 0 0 -39 h\n.8 g 4888
      4353 N 0 39 48 0 0 -39 h\n.8 g 4839 4353 N 0 39 49 0 0 -39 h\n.8 g 4790
      4353 N 0 39 49 0 0 -39 h\n.8 g 4742 4353 N 0 39 48 0 0 -39 h\n.8 g 4693
      4353 N 0 39 49 0 0 -39 h\n.8 g 4645 4353 N 0 39 48 0 0 -39 h\n.8 g 4596
      4353 N 0 39 49 0 0 -39 h\n.8 g 4547 4353 N 0 39 49 0 0 -39 h\n.8 g 4499
      4353 N 0 39 48 0 0 -39 h\n.8 g 4450 4353 N 0 39 49 0 0 -39 h\n.8 g 4402
      4353 N 0 39 48 0 0 -39 h\n.8 g 4353 4353 N 0 39 49 0 0 -39 h\n.8 g 4304
      4353 N 0 39 49 0 0 -39 h\n.8 g 4256 4353 N 0 39 48 0 0 -39 h\n.8 g 4207
      4353 N 0 39 49 0 0 -39 h\n.8 g 4159 4353 N 0 39 48 0 0 -39 h\n.8 g 4110
      4353 N 0 39 49 0 0 -39 h\n.8 g 4061 4353 N 0 39 49 0 0 -39 h\n.8 g 4013
      4353 N 0 39 48 0 0 -39 h\n.8 g 3964 4353 N 0 39 49 0 0 -39 h\n.8 g 3915
      4353 N 0 39 49 0 0 -39 h\n.8 g 3867 4353 N 0 39 48 0 0 -39 h\n.8 g 3818
      4353 N 0 39 49 0 0 -39 h\n.8 g 3770 4353 N 0 39 48 0 0 -39 h\n.8 g 3721
      4353 N 0 39 49 0 0 -39 h\n.8 g 3672 4353 N 0 39 49 0 0 -39 h\n.8 g 3624
      4353 N 0 39 48 0 0 -39 h\n.8 g 3575 4353 N 0 39 49 0 0 -39 h\n.8 g 3527
      4353 N 0 39 48 0 0 -39 h\n.8 g 3478 4353 N 0 39 49 0 0 -39 h\n.8 g 3429
      4353 N 0 39 49 0 0 -39 h\n.8 g 3381 4353 N 0 39 48 0 0 -39 h\n.8 g 3332
      4353 N 0 39 49 0 0 -39 h\n.8 g 3284 4353 N 0 39 48 0 0 -39 h\n.8 g 3235
      4353 N 0 39 49 0 0 -39 h\n.8 g 3186 4353 N 0 39 49 0 0 -39 h\n.8 g 3138
      4353 N 0 39 48 0 0 -39 h\n.8 g 3089 4353 N 0 39 49 0 0 -39 h\n.8 g 3040
      4353 N 0 39 49 0 0 -39 h\n.8 g 2992 4353 N 0 39 48 0 0 -39 h\n.8 g 2943
      4353 N 0 39 49 0 0 -39 h\n.8 g 2895 4353 N 0 39 48 0 0 -39 h\n.8 g 2846
      4353 N 0 39 49 0 0 -39 h\n.8 g 2797 4353 N 0 39 49 0 0 -39 h\n.8 g 2749
      4353 N 0 39 48 0 0 -39 h\n.8 g 2700 4353 N 0 39 49 0 0 -39 h\n.8 g 2652
      4353 N 0 39 48 0 0 -39 h\n.8 g 2603 4353 N 0 39 49 0 0 -39 h\n.8 g 2554
      4353 N 0 39 49 0 0 -39 h\n.8 g 2506 4353 N 0 39 48 0 0 -39 h\n.8 g 2457
      4353 N 0 39 49 0 0 -39 h\n.8 g 2409 4353 N 0 39 48 0 0 -39 h\n.8 g 2360
      4353 N 0 39 49 0 0 -39 h\n.8 g 2311 4353 N 0 39 49 0 0 -39 h\n.8 g 2263
      4353 N 0 39 48 0 0 -39 h\n.8 g 2214 4353 N 0 39 49 0 0 -39 h\n.8 g 2165
      4353 N 0 39 49 0 0 -39 h\n.8 g 2117 4353 N 0 39 48 0 0 -39 h\n.9 g 2068
      4353 N 0 39 49 0 0 -39 h\n1 g 2020 4353 N 0 39 48 0 0 -39 h\n1 g 1971
      4353 N 0 39 49 0 0 -39 h\n1 g 1922 4353 N 0 39 49 0 0 -39 h\n1 g 1874
      4353 N 0 39 48 0 0 -39 h\n1 g 1825 4353 N 0 39 49 0 0 -39 h\n1 g 1777
      4353 N 0 39 48 0 0 -39 h\n1 g 1728 4353 N 0 39 49 0 0 -39 h\n1 g 1679
      4353 N 0 39 49 0 0 -39 h\n1 g 1631 4353 N 0 39 48 0 0 -39 h\n1 g 1582
      4353 N 0 39 49 0 0 -39 h\n1 g 1534 4353 N 0 39 48 0 0 -39 h\n1 g 1485
      4353 N 0 39 49 0 0 -39 h\n1 g 1436 4353 N 0 39 49 0 0 -39 h\n1 g 1388
      4353 N 0 39 48 0 0 -39 h\n1 g 1339 4353 N 0 39 49 0 0 -39 h\n1 g 1290
      4353 N 0 39 49 0 0 -39 h\n1 g 1242 4353 N 0 39 48 0 0 -39 h\n1 g 1193
      4353 N 0 39 49 0 0 -39 h\n1 g 5957 4314 N 0 39 49 0 0 -39 h\n1 g 5909
      4314 N 0 39 48 0 0 -39 h\n1 g 5860 4314 N 0 39 49 0 0 -39 h\n1 g 5811
      4314 N 0 39 49 0 0 -39 h\n1 g 5763 4314 N 0 39 48 0 0 -39 h\n1 g 5714
      4314 N 0 39 49 0 0 -39 h\n1 g 5665 4314 N 0 39 49 0 0 -39 h\n1 g 5617
      4314 N 0 39 48 0 0 -39 h\n1 g 5568 4314 N 0 39 49 0 0 -39 h\n1 g 5520
      4314 N 0 39 48 0 0 -39 h\n1 g 5471 4314 N 0 39 49 0 0 -39 h\n1 g 5422
      4314 N 0 39 49 0 0 -39 h\n1 g 5374 4314 N 0 39 48 0 0 -39 h\n1 g 5325
      4314 N 0 39 49 0 0 -39 h\n1 g 5277 4314 N 0 39 48 0 0 -39 h\n1 g 5228
      4314 N 0 39 49 0 0 -39 h\n1 g 5179 4314 N 0 39 49 0 0 -39 h\n1 g 5131
      4314 N 0 39 48 0 0 -39 h\n.95 g 5082 4314 N 0 39 49 0 0 -39 h\n.85 g
      5034 4314 N 0 39 48 0 0 -39 h\n.8 g 4985 4314 N 0 39 49 0 0 -39 h\n.8 g
      4936 4314 N 0 39 49 0 0 -39 h\n.8 g 4888 4314 N 0 39 48 0 0 -39 h\n.8 g
      4839 4314 N 0 39 49 0 0 -39 h\n.8 g 4790 4314 N 0 39 49 0 0 -39 h\n.8 g
      4742 4314 N 0 39 48 0 0 -39 h\n.8 g 4693 4314 N 0 39 49 0 0 -39 h\n.8 g
      4645 4314 N 0 39 48 0 0 -39 h\n.8 g 4596 4314 N 0 39 49 0 0 -39 h\n.8 g
      4547 4314 N 0 39 49 0 0 -39 h\n.8 g 4499 4314 N 0 39 48 0 0 -39 h\n.8 g
      4450 4314 N 0 39 49 0 0 -39 h\n.8 g 4402 4314 N 0 39 48 0 0 -39 h\n.8 g
      4353 4314 N 0 39 49 0 0 -39 h\n.8 g 4304 4314 N 0 39 49 0 0 -39 h\n.8 g
      4256 4314 N 0 39 48 0 0 -39 h\n.8 g 4207 4314 N 0 39 49 0 0 -39 h\n.8 g
      4159 4314 N 0 39 48 0 0 -39 h\n.8 g 4110 4314 N 0 39 49 0 0 -39 h\n.8 g
      4061 4314 N 0 39 49 0 0 -39 h\n.8 g 4013 4314 N 0 39 48 0 0 -39 h\n.8 g
      3964 4314 N 0 39 49 0 0 -39 h\n.8 g 3915 4314 N 0 39 49 0 0 -39 h\n.8 g
      3867 4314 N 0 39 48 0 0 -39 h\n.8 g 3818 4314 N 0 39 49 0 0 -39 h\n.8 g
      3770 4314 N 0 39 48 0 0 -39 h\n.8 g 3721 4314 N 0 39 49 0 0 -39 h\n.8 g
      3672 4314 N 0 39 49 0 0 -39 h\n.8 g 3624 4314 N 0 39 48 0 0 -39 h\n.8 g
      3575 4314 N 0 39 49 0 0 -39 h\n.8 g 3527 4314 N 0 39 48 0 0 -39 h\n.8 g
      3478 4314 N 0 39 49 0 0 -39 h\n.8 g 3429 4314 N 0 39 49 0 0 -39 h\n.8 g
      3381 4314 N 0 39 48 0 0 -39 h\n.8 g 3332 4314 N 0 39 49 0 0 -39 h\n.8 g
      3284 4314 N 0 39 48 0 0 -39 h\n.8 g 3235 4314 N 0 39 49 0 0 -39 h\n.8 g
      3186 4314 N 0 39 49 0 0 -39 h\n.8 g 3138 4314 N 0 39 48 0 0 -39 h\n.8 g
      3089 4314 N 0 39 49 0 0 -39 h\n.8 g 3040 4314 N 0 39 49 0 0 -39 h\n.8 g
      2992 4314 N 0 39 48 0 0 -39 h\n.8 g 2943 4314 N 0 39 49 0 0 -39 h\n.8 g
      2895 4314 N 0 39 48 0 0 -39 h\n.8 g 2846 4314 N 0 39 49 0 0 -39 h\n.8 g
      2797 4314 N 0 39 49 0 0 -39 h\n.8 g 2749 4314 N 0 39 48 0 0 -39 h\n.8 g
      2700 4314 N 0 39 49 0 0 -39 h\n.8 g 2652 4314 N 0 39 48 0 0 -39 h\n.8 g
      2603 4314 N 0 39 49 0 0 -39 h\n.8 g 2554 4314 N 0 39 49 0 0 -39 h\n.8 g
      2506 4314 N 0 39 48 0 0 -39 h\n.8 g 2457 4314 N 0 39 49 0 0 -39 h\n.8 g
      2409 4314 N 0 39 48 0 0 -39 h\n.8 g 2360 4314 N 0 39 49 0 0 -39 h\n.8 g
      2311 4314 N 0 39 49 0 0 -39 h\n.8 g 2263 4314 N 0 39 48 0 0 -39 h\n.8 g
      2214 4314 N 0 39 49 0 0 -39 h\n.8 g 2165 4314 N 0 39 49 0 0 -39 h\n.85
      g 2117 4314 N 0 39 48 0 0 -39 h\n.95 g 2068 4314 N 0 39 49 0 0 -39 h\n1
      g 2020 4314 N 0 39 48 0 0 -39 h\n1 g 1971 4314 N 0 39 49 0 0 -39 h\n1 g
      1922 4314 N 0 39 49 0 0 -39 h\n1 g 1874 4314 N 0 39 48 0 0 -39 h\n1 g
      1825 4314 N 0 39 49 0 0 -39 h\n1 g 1777 4314 N 0 39 48 0 0 -39 h\n1 g
      1728 4314 N 0 39 49 0 0 -39 h\n1 g 1679 4314 N 0 39 49 0 0 -39 h\n1 g
      1631 4314 N 0 39 48 0 0 -39 h\n1 g 1582 4314 N 0 39 49 0 0 -39 h\n1 g
      1534 4314 N 0 39 48 0 0 -39 h\n1 g 1485 4314 N 0 39 49 0 0 -39 h\n1 g
      1436 4314 N 0 39 49 0 0 -39 h\n1 g 1388 4314 N 0 39 48 0 0 -39 h\n1 g
      1339 4314 N 0 39 49 0 0 -39 h\n1 g 1290 4314 N 0 39 49 0 0 -39 h\n1 g
      1242 4314 N 0 39 48 0 0 -39 h\n1 g 1193 4314 N 0 39 49 0 0 -39 h\n1 g
      5957 4275 N 0 38 49 0 0 -38 h\n1 g 5909 4275 N 0 38 48 0 0 -38 h\n1 g
      5860 4275 N 0 38 49 0 0 -38 h\n1 g 5811 4275 N 0 38 49 0 0 -38 h\n1 g
      5763 4275 N 0 38 48 0 0 -38 h\n1 g 5714 4275 N 0 38 49 0 0 -38 h\n1 g
      5665 4275 N 0 38 49 0 0 -38 h\n1 g 5617 4275 N 0 38 48 0 0 -38 h\n1 g
      5568 4275 N 0 38 49 0 0 -38 h\n1 g 5520 4275 N 0 38 48 0 0 -38 h\n1 g
      5471 4275 N 0 38 49 0 0 -38 h\n1 g 5422 4275 N 0 38 49 0 0 -38 h\n1 g
      5374 4275 N 0 38 48 0 0 -38 h\n1 g 5325 4275 N 0 38 49 0 0 -38 h\n1 g
      5277 4275 N 0 38 48 0 0 -38 h\n1 g 5228 4275 N 0 38 49 0 0 -38 h\n1 g
      5179 4275 N 0 38 49 0 0 -38 h\n1 g 5131 4275 N 0 38 48 0 0 -38 h\n1 g
      5082 4275 N 0 38 49 0 0 -38 h\n.9 g 5034 4275 N 0 38 48 0 0 -38 h\n.8 g
      4985 4275 N 0 38 49 0 0 -38 h\n.8 g 4936 4275 N 0 38 49 0 0 -38 h\n.8 g
      4888 4275 N 0 38 48 0 0 -38 h\n.8 g 4839 4275 N 0 38 49 0 0 -38 h\n.8 g
      4790 4275 N 0 38 49 0 0 -38 h\n.8 g 4742 4275 N 0 38 48 0 0 -38 h\n.8 g
      4693 4275 N 0 38 49 0 0 -38 h\n.8 g 4645 4275 N 0 38 48 0 0 -38 h\n.8 g
      4596 4275 N 0 38 49 0 0 -38 h\n.8 g 4547 4275 N 0 38 49 0 0 -38 h\n.8 g
      4499 4275 N 0 38 48 0 0 -38 h\n.8 g 4450 4275 N 0 38 49 0 0 -38 h\n.8 g
      4402 4275 N 0 38 48 0 0 -38 h\n.8 g 4353 4275 N 0 38 49 0 0 -38 h\n.8 g
      4304 4275 N 0 38 49 0 0 -38 h\n.8 g 4256 4275 N 0 38 48 0 0 -38 h\n.8 g
      4207 4275 N 0 38 49 0 0 -38 h\n.8 g 4159 4275 N 0 38 48 0 0 -38 h\n.8 g
      4110 4275 N 0 38 49 0 0 -38 h\n.8 g 4061 4275 N 0 38 49 0 0 -38 h\n.8 g
      4013 4275 N 0 38 48 0 0 -38 h\n.8 g 3964 4275 N 0 38 49 0 0 -38 h\n.8 g
      3915 4275 N 0 38 49 0 0 -38 h\n.8 g 3867 4275 N 0 38 48 0 0 -38 h\n.8 g
      3818 4275 N 0 38 49 0 0 -38 h\n.8 g 3770 4275 N 0 38 48 0 0 -38 h\n.8 g
      3721 4275 N 0 38 49 0 0 -38 h\n.8 g 3672 4275 N 0 38 49 0 0 -38 h\n.8 g
      3624 4275 N 0 38 48 0 0 -38 h\n.8 g 3575 4275 N 0 38 49 0 0 -38 h\n.8 g
      3527 4275 N 0 38 48 0 0 -38 h\n.8 g 3478 4275 N 0 38 49 0 0 -38 h\n.8 g
      3429 4275 N 0 38 49 0 0 -38 h\n.8 g 3381 4275 N 0 38 48 0 0 -38 h\n.8 g
      3332 4275 N 0 38 49 0 0 -38 h\n.8 g 3284 4275 N 0 38 48 0 0 -38 h\n.8 g
      3235 4275 N 0 38 49 0 0 -38 h\n.8 g 3186 4275 N 0 38 49 0 0 -38 h\n.8 g
      3138 4275 N 0 38 48 0 0 -38 h\n.8 g 3089 4275 N 0 38 49 0 0 -38 h\n.8 g
      3040 4275 N 0 38 49 0 0 -38 h\n.8 g 2992 4275 N 0 38 48 0 0 -38 h\n.8 g
      2943 4275 N 0 38 49 0 0 -38 h\n.8 g 2895 4275 N 0 38 48 0 0 -38 h\n.8 g
      2846 4275 N 0 38 49 0 0 -38 h\n.8 g 2797 4275 N 0 38 49 0 0 -38 h\n.8 g
      2749 4275 N 0 38 48 0 0 -38 h\n.8 g 2700 4275 N 0 38 49 0 0 -38 h\n.8 g
      2652 4275 N 0 38 48 0 0 -38 h\n.8 g 2603 4275 N 0 38 49 0 0 -38 h\n.8 g
      2554 4275 N 0 38 49 0 0 -38 h\n.8 g 2506 4275 N 0 38 48 0 0 -38 h\n.8 g
      2457 4275 N 0 38 49 0 0 -38 h\n.8 g 2409 4275 N 0 38 48 0 0 -38 h\n.8 g
      2360 4275 N 0 38 49 0 0 -38 h\n.8 g 2311 4275 N 0 38 49 0 0 -38 h\n.8 g
      2263 4275 N 0 38 48 0 0 -38 h\n.8 g 2214 4275 N 0 38 49 0 0 -38 h\n.8 g
      2165 4275 N 0 38 49 0 0 -38 h\n.9 g 2117 4275 N 0 38 48 0 0 -38 h\n1 g
      2068 4275 N 0 38 49 0 0 -38 h\n1 g 2020 4275 N 0 38 48 0 0 -38 h\n1 g
      1971 4275 N 0 38 49 0 0 -38 h\n1 g 1922 4275 N 0 38 49 0 0 -38 h\n1 g
      1874 4275 N 0 38 48 0 0 -38 h\n1 g 1825 4275 N 0 38 49 0 0 -38 h\n1 g
      1777 4275 N 0 38 48 0 0 -38 h\n1 g 1728 4275 N 0 38 49 0 0 -38 h\n1 g
      1679 4275 N 0 38 49 0 0 -38 h\n1 g 1631 4275 N 0 38 48 0 0 -38 h\n1 g
      1582 4275 N 0 38 49 0 0 -38 h\n1 g 1534 4275 N 0 38 48 0 0 -38 h\n1 g
      1485 4275 N 0 38 49 0 0 -38 h\n1 g 1436 4275 N 0 38 49 0 0 -38 h\n1 g
      1388 4275 N 0 38 48 0 0 -38 h\n1 g 1339 4275 N 0 38 49 0 0 -38 h\n1 g
      1290 4275 N 0 38 49 0 0 -38 h\n1 g 1242 4275 N 0 38 48 0 0 -38 h\n1 g
      1193 4275 N 0 38 49 0 0 -38 h\n1 g 5957 4237 N 0 39 49 0 0 -39 h\n1 g
      5909 4237 N 0 39 48 0 0 -39 h\n1 g 5860 4237 N 0 39 49 0 0 -39 h\n1 g
      5811 4237 N 0 39 49 0 0 -39 h\n1 g 5763 4237 N 0 39 48 0 0 -39 h\n1 g
      5714 4237 N 0 39 49 0 0 -39 h\n1 g 5665 4237 N 0 39 49 0 0 -39 h\n1 g
      5617 4237 N 0 39 48 0 0 -39 h\n1 g 5568 4237 N 0 39 49 0 0 -39 h\n1 g
      5520 4237 N 0 39 48 0 0 -39 h\n1 g 5471 4237 N 0 39 49 0 0 -39 h\n1 g
      5422 4237 N 0 39 49 0 0 -39 h\n1 g 5374 4237 N 0 39 48 0 0 -39 h\n1 g
      5325 4237 N 0 39 49 0 0 -39 h\n1 g 5277 4237 N 0 39 48 0 0 -39 h\n1 g
      5228 4237 N 0 39 49 0 0 -39 h\n1 g 5179 4237 N 0 39 49 0 0 -39 h\n1 g
      5131 4237 N 0 39 48 0 0 -39 h\n1 g 5082 4237 N 0 39 49 0 0 -39 h\n.9 g
      5034 4237 N 0 39 48 0 0 -39 h\n.8 g 4985 4237 N 0 39 49 0 0 -39 h\n.8 g
      4936 4237 N 0 39 49 0 0 -39 h\n.8 g 4888 4237 N 0 39 48 0 0 -39 h\n.8 g
      4839 4237 N 0 39 49 0 0 -39 h\n.8 g 4790 4237 N 0 39 49 0 0 -39 h\n.8 g
      4742 4237 N 0 39 48 0 0 -39 h\n.8 g 4693 4237 N 0 39 49 0 0 -39 h\n.8 g
      4645 4237 N 0 39 48 0 0 -39 h\n.8 g 4596 4237 N 0 39 49 0 0 -39 h\n.8 g
      4547 4237 N 0 39 49 0 0 -39 h\n.8 g 4499 4237 N 0 39 48 0 0 -39 h\n.8 g
      4450 4237 N 0 39 49 0 0 -39 h\n.8 g 4402 4237 N 0 39 48 0 0 -39 h\n.8 g
      4353 4237 N 0 39 49 0 0 -39 h\n.8 g 4304 4237 N 0 39 49 0 0 -39 h\n.8 g
      4256 4237 N 0 39 48 0 0 -39 h\n.8 g 4207 4237 N 0 39 49 0 0 -39 h\n.8 g
      4159 4237 N 0 39 48 0 0 -39 h\n.8 g 4110 4237 N 0 39 49 0 0 -39 h\n.8 g
      4061 4237 N 0 39 49 0 0 -39 h\n.8 g 4013 4237 N 0 39 48 0 0 -39 h\n.8 g
      3964 4237 N 0 39 49 0 0 -39 h\n.8 g 3915 4237 N 0 39 49 0 0 -39 h\n.8 g
      3867 4237 N 0 39 48 0 0 -39 h\n.8 g 3818 4237 N 0 39 49 0 0 -39 h\n.8 g
      3770 4237 N 0 39 48 0 0 -39 h\n.8 g 3721 4237 N 0 39 49 0 0 -39 h\n.8 g
      3672 4237 N 0 39 49 0 0 -39 h\n.8 g 3624 4237 N 0 39 48 0 0 -39 h\n.8 g
      3575 4237 N 0 39 49 0 0 -39 h\n.8 g 3527 4237 N 0 39 48 0 0 -39 h\n.8 g
      3478 4237 N 0 39 49 0 0 -39 h\n.8 g 3429 4237 N 0 39 49 0 0 -39 h\n.8 g
      3381 4237 N 0 39 48 0 0 -39 h\n.8 g 3332 4237 N 0 39 49 0 0 -39 h\n.8 g
      3284 4237 N 0 39 48 0 0 -39 h\n.8 g 3235 4237 N 0 39 49 0 0 -39 h\n.8 g
      3186 4237 N 0 39 49 0 0 -39 h\n.8 g 3138 4237 N 0 39 48 0 0 -39 h\n.8 g
      3089 4237 N 0 39 49 0 0 -39 h\n.8 g 3040 4237 N 0 39 49 0 0 -39 h\n.8 g
      2992 4237 N 0 39 48 0 0 -39 h\n.8 g 2943 4237 N 0 39 49 0 0 -39 h\n.8 g
      2895 4237 N 0 39 48 0 0 -39 h\n.8 g 2846 4237 N 0 39 49 0 0 -39 h\n.8 g
      2797 4237 N 0 39 49 0 0 -39 h\n.8 g 2749 4237 N 0 39 48 0 0 -39 h\n.8 g
      2700 4237 N 0 39 49 0 0 -39 h\n.8 g 2652 4237 N 0 39 48 0 0 -39 h\n.8 g
      2603 4237 N 0 39 49 0 0 -39 h\n.8 g 2554 4237 N 0 39 49 0 0 -39 h\n.8 g
      2506 4237 N 0 39 48 0 0 -39 h\n.8 g 2457 4237 N 0 39 49 0 0 -39 h\n.8 g
      2409 4237 N 0 39 48 0 0 -39 h\n.8 g 2360 4237 N 0 39 49 0 0 -39 h\n.8 g
      2311 4237 N 0 39 49 0 0 -39 h\n.8 g 2263 4237 N 0 39 48 0 0 -39 h\n.8 g
      2214 4237 N 0 39 49 0 0 -39 h\n.8 g 2165 4237 N 0 39 49 0 0 -39 h\n.9 g
      2117 4237 N 0 39 48 0 0 -39 h\n1 g 2068 4237 N 0 39 49 0 0 -39 h\n1 g
      2020 4237 N 0 39 48 0 0 -39 h\n1 g 1971 4237 N 0 39 49 0 0 -39 h\n1 g
      1922 4237 N 0 39 49 0 0 -39 h\n1 g 1874 4237 N 0 39 48 0 0 -39 h\n1 g
      1825 4237 N 0 39 49 0 0 -39 h\n1 g 1777 4237 N 0 39 48 0 0 -39 h\n1 g
      1728 4237 N 0 39 49 0 0 -39 h\n1 g 1679 4237 N 0 39 49 0 0 -39 h\n1 g
      1631 4237 N 0 39 48 0 0 -39 h\n1 g 1582 4237 N 0 39 49 0 0 -39 h\n1 g
      1534 4237 N 0 39 48 0 0 -39 h\n1 g 1485 4237 N 0 39 49 0 0 -39 h\n1 g
      1436 4237 N 0 39 49 0 0 -39 h\n1 g 1388 4237 N 0 39 48 0 0 -39 h\n1 g
      1339 4237 N 0 39 49 0 0 -39 h\n1 g 1290 4237 N 0 39 49 0 0 -39 h\n1 g
      1242 4237 N 0 39 48 0 0 -39 h\n1 g 1193 4237 N 0 39 49 0 0 -39 h\n1 g
      5957 4198 N 0 39 49 0 0 -39 h\n1 g 5909 4198 N 0 39 48 0 0 -39 h\n1 g
      5860 4198 N 0 39 49 0 0 -39 h\n1 g 5811 4198 N 0 39 49 0 0 -39 h\n1 g
      5763 4198 N 0 39 48 0 0 -39 h\n1 g 5714 4198 N 0 39 49 0 0 -39 h\n1 g
      5665 4198 N 0 39 49 0 0 -39 h\n1 g 5617 4198 N 0 39 48 0 0 -39 h\n1 g
      5568 4198 N 0 39 49 0 0 -39 h\n1 g 5520 4198 N 0 39 48 0 0 -39 h\n1 g
      5471 4198 N 0 39 49 0 0 -39 h\n1 g 5422 4198 N 0 39 49 0 0 -39 h\n1 g
      5374 4198 N 0 39 48 0 0 -39 h\n1 g 5325 4198 N 0 39 49 0 0 -39 h\n1 g
      5277 4198 N 0 39 48 0 0 -39 h\n1 g 5228 4198 N 0 39 49 0 0 -39 h\n1 g
      5179 4198 N 0 39 49 0 0 -39 h\n1 g 5131 4198 N 0 39 48 0 0 -39 h\n1 g
      5082 4198 N 0 39 49 0 0 -39 h\n.9 g 5034 4198 N 0 39 48 0 0 -39 h\n.8 g
      4985 4198 N 0 39 49 0 0 -39 h\n.8 g 4936 4198 N 0 39 49 0 0 -39 h\n.8 g
      4888 4198 N 0 39 48 0 0 -39 h\n.8 g 4839 4198 N 0 39 49 0 0 -39 h\n.8 g
      4790 4198 N 0 39 49 0 0 -39 h\n.8 g 4742 4198 N 0 39 48 0 0 -39 h\n.8 g
      4693 4198 N 0 39 49 0 0 -39 h\n.8 g 4645 4198 N 0 39 48 0 0 -39 h\n.8 g
      4596 4198 N 0 39 49 0 0 -39 h\n.8 g 4547 4198 N 0 39 49 0 0 -39 h\n.8 g
      4499 4198 N 0 39 48 0 0 -39 h\n.8 g 4450 4198 N 0 39 49 0 0 -39 h\n.8 g
      4402 4198 N 0 39 48 0 0 -39 h\n.8 g 4353 4198 N 0 39 49 0 0 -39 h\n.8 g
      4304 4198 N 0 39 49 0 0 -39 h\n.8 g 4256 4198 N 0 39 48 0 0 -39 h\n.8 g
      4207 4198 N 0 39 49 0 0 -39 h\n.8 g 4159 4198 N 0 39 48 0 0 -39 h\n.8 g
      4110 4198 N 0 39 49 0 0 -39 h\n.8 g 4061 4198 N 0 39 49 0 0 -39 h\n.8 g
      4013 4198 N 0 39 48 0 0 -39 h\n.8 g 3964 4198 N 0 39 49 0 0 -39 h\n.8 g
      3915 4198 N 0 39 49 0 0 -39 h\n.8 g 3867 4198 N 0 39 48 0 0 -39 h\n.8 g
      3818 4198 N 0 39 49 0 0 -39 h\n.8 g 3770 4198 N 0 39 48 0 0 -39 h\n.8 g
      3721 4198 N 0 39 49 0 0 -39 h\n.8 g 3672 4198 N 0 39 49 0 0 -39 h\n.8 g
      3624 4198 N 0 39 48 0 0 -39 h\n.8 g 3575 4198 N 0 39 49 0 0 -39 h\n.8 g
      3527 4198 N 0 39 48 0 0 -39 h\n.8 g 3478 4198 N 0 39 49 0 0 -39 h\n.8 g
      3429 4198 N 0 39 49 0 0 -39 h\n.8 g 3381 4198 N 0 39 48 0 0 -39 h\n.8 g
      3332 4198 N 0 39 49 0 0 -39 h\n.8 g 3284 4198 N 0 39 48 0 0 -39 h\n.8 g
      3235 4198 N 0 39 49 0 0 -39 h\n.8 g 3186 4198 N 0 39 49 0 0 -39 h\n.8 g
      3138 4198 N 0 39 48 0 0 -39 h\n.8 g 3089 4198 N 0 39 49 0 0 -39 h\n.8 g
      3040 4198 N 0 39 49 0 0 -39 h\n.8 g 2992 4198 N 0 39 48 0 0 -39 h\n.8 g
      2943 4198 N 0 39 49 0 0 -39 h\n.8 g 2895 4198 N 0 39 48 0 0 -39 h\n.8 g
      2846 4198 N 0 39 49 0 0 -39 h\n.8 g 2797 4198 N 0 39 49 0 0 -39 h\n.8 g
      2749 4198 N 0 39 48 0 0 -39 h\n.8 g 2700 4198 N 0 39 49 0 0 -39 h\n.8 g
      2652 4198 N 0 39 48 0 0 -39 h\n.8 g 2603 4198 N 0 39 49 0 0 -39 h\n.8 g
      2554 4198 N 0 39 49 0 0 -39 h\n.8 g 2506 4198 N 0 39 48 0 0 -39 h\n.8 g
      2457 4198 N 0 39 49 0 0 -39 h\n.8 g 2409 4198 N 0 39 48 0 0 -39 h\n.8 g
      2360 4198 N 0 39 49 0 0 -39 h\n.8 g 2311 4198 N 0 39 49 0 0 -39 h\n.8 g
      2263 4198 N 0 39 48 0 0 -39 h\n.8 g 2214 4198 N 0 39 49 0 0 -39 h\n.8 g
      2165 4198 N 0 39 49 0 0 -39 h\n.9 g 2117 4198 N 0 39 48 0 0 -39 h\n1 g
      2068 4198 N 0 39 49 0 0 -39 h\n1 g 2020 4198 N 0 39 48 0 0 -39 h\n1 g
      1971 4198 N 0 39 49 0 0 -39 h\n1 g 1922 4198 N 0 39 49 0 0 -39 h\n1 g
      1874 4198 N 0 39 48 0 0 -39 h\n1 g 1825 4198 N 0 39 49 0 0 -39 h\n1 g
      1777 4198 N 0 39 48 0 0 -39 h\n1 g 1728 4198 N 0 39 49 0 0 -39 h\n1 g
      1679 4198 N 0 39 49 0 0 -39 h\n1 g 1631 4198 N 0 39 48 0 0 -39 h\n1 g
      1582 4198 N 0 39 49 0 0 -39 h\n1 g 1534 4198 N 0 39 48 0 0 -39 h\n1 g
      1485 4198 N 0 39 49 0 0 -39 h\n1 g 1436 4198 N 0 39 49 0 0 -39 h\n1 g
      1388 4198 N 0 39 48 0 0 -39 h\n1 g 1339 4198 N 0 39 49 0 0 -39 h\n1 g
      1290 4198 N 0 39 49 0 0 -39 h\n1 g 1242 4198 N 0 39 48 0 0 -39 h\n1 g
      1193 4198 N 0 39 49 0 0 -39 h\n1 g 5957 4159 N 0 39 49 0 0 -39 h\n1 g
      5909 4159 N 0 39 48 0 0 -39 h\n1 g 5860 4159 N 0 39 49 0 0 -39 h\n1 g
      5811 4159 N 0 39 49 0 0 -39 h\n1 g 5763 4159 N 0 39 48 0 0 -39 h\n1 g
      5714 4159 N 0 39 49 0 0 -39 h\n1 g 5665 4159 N 0 39 49 0 0 -39 h\n1 g
      5617 4159 N 0 39 48 0 0 -39 h\n1 g 5568 4159 N 0 39 49 0 0 -39 h\n1 g
      5520 4159 N 0 39 48 0 0 -39 h\n1 g 5471 4159 N 0 39 49 0 0 -39 h\n1 g
      5422 4159 N 0 39 49 0 0 -39 h\n1 g 5374 4159 N 0 39 48 0 0 -39 h\n1 g
      5325 4159 N 0 39 49 0 0 -39 h\n1 g 5277 4159 N 0 39 48 0 0 -39 h\n1 g
      5228 4159 N 0 39 49 0 0 -39 h\n1 g 5179 4159 N 0 39 49 0 0 -39 h\n1 g
      5131 4159 N 0 39 48 0 0 -39 h\n1 g 5082 4159 N 0 39 49 0 0 -39 h\n.9 g
      5034 4159 N 0 39 48 0 0 -39 h\n.8 g 4985 4159 N 0 39 49 0 0 -39 h\n.8 g
      4936 4159 N 0 39 49 0 0 -39 h\n.8 g 4888 4159 N 0 39 48 0 0 -39 h\n.8 g
      4839 4159 N 0 39 49 0 0 -39 h\n.8 g 4790 4159 N 0 39 49 0 0 -39 h\n.8 g
      4742 4159 N 0 39 48 0 0 -39 h\n.8 g 4693 4159 N 0 39 49 0 0 -39 h\n.8 g
      4645 4159 N 0 39 48 0 0 -39 h\n.8 g 4596 4159 N 0 39 49 0 0 -39 h\n.8 g
      4547 4159 N 0 39 49 0 0 -39 h\n.8 g 4499 4159 N 0 39 48 0 0 -39 h\n.8 g
      4450 4159 N 0 39 49 0 0 -39 h\n.8 g 4402 4159 N 0 39 48 0 0 -39 h\n.8 g
      4353 4159 N 0 39 49 0 0 -39 h\n.8 g 4304 4159 N 0 39 49 0 0 -39 h\n.8 g
      4256 4159 N 0 39 48 0 0 -39 h\n.8 g 4207 4159 N 0 39 49 0 0 -39 h\n.8 g
      4159 4159 N 0 39 48 0 0 -39 h\n.8 g 4110 4159 N 0 39 49 0 0 -39 h\n.8 g
      4061 4159 N 0 39 49 0 0 -39 h\n.8 g 4013 4159 N 0 39 48 0 0 -39 h\n.8 g
      3964 4159 N 0 39 49 0 0 -39 h\n.8 g 3915 4159 N 0 39 49 0 0 -39 h\n.8 g
      3867 4159 N 0 39 48 0 0 -39 h\n.8 g 3818 4159 N 0 39 49 0 0 -39 h\n.8 g
      3770 4159 N 0 39 48 0 0 -39 h\n.8 g 3721 4159 N 0 39 49 0 0 -39 h\n.8 g
      3672 4159 N 0 39 49 0 0 -39 h\n.8 g 3624 4159 N 0 39 48 0 0 -39 h\n.8 g
      3575 4159 N 0 39 49 0 0 -39 h\n.8 g 3527 4159 N 0 39 48 0 0 -39 h\n.8 g
      3478 4159 N 0 39 49 0 0 -39 h\n.8 g 3429 4159 N 0 39 49 0 0 -39 h\n.8 g
      3381 4159 N 0 39 48 0 0 -39 h\n.8 g 3332 4159 N 0 39 49 0 0 -39 h\n.8 g
      3284 4159 N 0 39 48 0 0 -39 h\n.8 g 3235 4159 N 0 39 49 0 0 -39 h\n.8 g
      3186 4159 N 0 39 49 0 0 -39 h\n.8 g 3138 4159 N 0 39 48 0 0 -39 h\n.8 g
      3089 4159 N 0 39 49 0 0 -39 h\n.8 g 3040 4159 N 0 39 49 0 0 -39 h\n.8 g
      2992 4159 N 0 39 48 0 0 -39 h\n.8 g 2943 4159 N 0 39 49 0 0 -39 h\n.8 g
      2895 4159 N 0 39 48 0 0 -39 h\n.8 g 2846 4159 N 0 39 49 0 0 -39 h\n.8 g
      2797 4159 N 0 39 49 0 0 -39 h\n.8 g 2749 4159 N 0 39 48 0 0 -39 h\n.8 g
      2700 4159 N 0 39 49 0 0 -39 h\n.8 g 2652 4159 N 0 39 48 0 0 -39 h\n.8 g
      2603 4159 N 0 39 49 0 0 -39 h\n.8 g 2554 4159 N 0 39 49 0 0 -39 h\n.8 g
      2506 4159 N 0 39 48 0 0 -39 h\n.8 g 2457 4159 N 0 39 49 0 0 -39 h\n.8 g
      2409 4159 N 0 39 48 0 0 -39 h\n.8 g 2360 4159 N 0 39 49 0 0 -39 h\n.8 g
      2311 4159 N 0 39 49 0 0 -39 h\n.8 g 2263 4159 N 0 39 48 0 0 -39 h\n.8 g
      2214 4159 N 0 39 49 0 0 -39 h\n.8 g 2165 4159 N 0 39 49 0 0 -39 h\n.9 g
      2117 4159 N 0 39 48 0 0 -39 h\n1 g 2068 4159 N 0 39 49 0 0 -39 h\n1 g
      2020 4159 N 0 39 48 0 0 -39 h\n1 g 1971 4159 N 0 39 49 0 0 -39 h\n1 g
      1922 4159 N 0 39 49 0 0 -39 h\n1 g 1874 4159 N 0 39 48 0 0 -39 h\n1 g
      1825 4159 N 0 39 49 0 0 -39 h\n1 g 1777 4159 N 0 39 48 0 0 -39 h\n1 g
      1728 4159 N 0 39 49 0 0 -39 h\n1 g 1679 4159 N 0 39 49 0 0 -39 h\n1 g
      1631 4159 N 0 39 48 0 0 -39 h\n1 g 1582 4159 N 0 39 49 0 0 -39 h\n1 g
      1534 4159 N 0 39 48 0 0 -39 h\n1 g 1485 4159 N 0 39 49 0 0 -39 h\n1 g
      1436 4159 N 0 39 49 0 0 -39 h\n1 g 1388 4159 N 0 39 48 0 0 -39 h\n1 g
      1339 4159 N 0 39 49 0 0 -39 h\n1 g 1290 4159 N 0 39 49 0 0 -39 h\n1 g
      1242 4159 N 0 39 48 0 0 -39 h\n1 g 1193 4159 N 0 39 49 0 0 -39 h\n1 g
      5957 4120 N 0 38 49 0 0 -38 h\n1 g 5909 4120 N 0 38 48 0 0 -38 h\n1 g
      5860 4120 N 0 38 49 0 0 -38 h\n1 g 5811 4120 N 0 38 49 0 0 -38 h\n1 g
      5763 4120 N 0 38 48 0 0 -38 h\n1 g 5714 4120 N 0 38 49 0 0 -38 h\n1 g
      5665 4120 N 0 38 49 0 0 -38 h\n1 g 5617 4120 N 0 38 48 0 0 -38 h\n1 g
      5568 4120 N 0 38 49 0 0 -38 h\n1 g 5520 4120 N 0 38 48 0 0 -38 h\n1 g
      5471 4120 N 0 38 49 0 0 -38 h\n1 g 5422 4120 N 0 38 49 0 0 -38 h\n1 g
      5374 4120 N 0 38 48 0 0 -38 h\n1 g 5325 4120 N 0 38 49 0 0 -38 h\n1 g
      5277 4120 N 0 38 48 0 0 -38 h\n1 g 5228 4120 N 0 38 49 0 0 -38 h\n1 g
      5179 4120 N 0 38 49 0 0 -38 h\n1 g 5131 4120 N 0 38 48 0 0 -38 h\n1 g
      5082 4120 N 0 38 49 0 0 -38 h\n.9 g 5034 4120 N 0 38 48 0 0 -38 h\n.8 g
      4985 4120 N 0 38 49 0 0 -38 h\n.8 g 4936 4120 N 0 38 49 0 0 -38 h\n.8 g
      4888 4120 N 0 38 48 0 0 -38 h\n.8 g 4839 4120 N 0 38 49 0 0 -38 h\n.8 g
      4790 4120 N 0 38 49 0 0 -38 h\n.8 g 4742 4120 N 0 38 48 0 0 -38 h\n.8 g
      4693 4120 N 0 38 49 0 0 -38 h\n.8 g 4645 4120 N 0 38 48 0 0 -38 h\n.8 g
      4596 4120 N 0 38 49 0 0 -38 h\n.8 g 4547 4120 N 0 38 49 0 0 -38 h\n.8 g
      4499 4120 N 0 38 48 0 0 -38 h\n.8 g 4450 4120 N 0 38 49 0 0 -38 h\n.8 g
      4402 4120 N 0 38 48 0 0 -38 h\n.8 g 4353 4120 N 0 38 49 0 0 -38 h\n.8 g
      4304 4120 N 0 38 49 0 0 -38 h\n.8 g 4256 4120 N 0 38 48 0 0 -38 h\n.8 g
      4207 4120 N 0 38 49 0 0 -38 h\n.8 g 4159 4120 N 0 38 48 0 0 -38 h\n.8 g
      4110 4120 N 0 38 49 0 0 -38 h\n.8 g 4061 4120 N 0 38 49 0 0 -38 h\n.8 g
      4013 4120 N 0 38 48 0 0 -38 h\n.8 g 3964 4120 N 0 38 49 0 0 -38 h\n.8 g
      3915 4120 N 0 38 49 0 0 -38 h\n.8 g 3867 4120 N 0 38 48 0 0 -38 h\n.8 g
      3818 4120 N 0 38 49 0 0 -38 h\n.8 g 3770 4120 N 0 38 48 0 0 -38 h\n.8 g
      3721 4120 N 0 38 49 0 0 -38 h\n.8 g 3672 4120 N 0 38 49 0 0 -38 h\n.8 g
      3624 4120 N 0 38 48 0 0 -38 h\n.8 g 3575 4120 N 0 38 49 0 0 -38 h\n.8 g
      3527 4120 N 0 38 48 0 0 -38 h\n.8 g 3478 4120 N 0 38 49 0 0 -38 h\n.8 g
      3429 4120 N 0 38 49 0 0 -38 h\n.8 g 3381 4120 N 0 38 48 0 0 -38 h\n.8 g
      3332 4120 N 0 38 49 0 0 -38 h\n.8 g 3284 4120 N 0 38 48 0 0 -38 h\n.8 g
      3235 4120 N 0 38 49 0 0 -38 h\n.8 g 3186 4120 N 0 38 49 0 0 -38 h\n.8 g
      3138 4120 N 0 38 48 0 0 -38 h\n.8 g 3089 4120 N 0 38 49 0 0 -38 h\n.8 g
      3040 4120 N 0 38 49 0 0 -38 h\n.8 g 2992 4120 N 0 38 48 0 0 -38 h\n.8 g
      2943 4120 N 0 38 49 0 0 -38 h\n.8 g 2895 4120 N 0 38 48 0 0 -38 h\n.8 g
      2846 4120 N 0 38 49 0 0 -38 h\n.8 g 2797 4120 N 0 38 49 0 0 -38 h\n.8 g
      2749 4120 N 0 38 48 0 0 -38 h\n.8 g 2700 4120 N 0 38 49 0 0 -38 h\n.8 g
      2652 4120 N 0 38 48 0 0 -38 h\n.8 g 2603 4120 N 0 38 49 0 0 -38 h\n.8 g
      2554 4120 N 0 38 49 0 0 -38 h\n.8 g 2506 4120 N 0 38 48 0 0 -38 h\n.8 g
      2457 4120 N 0 38 49 0 0 -38 h\n.8 g 2409 4120 N 0 38 48 0 0 -38 h\n.8 g
      2360 4120 N 0 38 49 0 0 -38 h\n.8 g 2311 4120 N 0 38 49 0 0 -38 h\n.8 g
      2263 4120 N 0 38 48 0 0 -38 h\n.8 g 2214 4120 N 0 38 49 0 0 -38 h\n.8 g
      2165 4120 N 0 38 49 0 0 -38 h\n.9 g 2117 4120 N 0 38 48 0 0 -38 h\n1 g
      2068 4120 N 0 38 49 0 0 -38 h\n1 g 2020 4120 N 0 38 48 0 0 -38 h\n1 g
      1971 4120 N 0 38 49 0 0 -38 h\n1 g 1922 4120 N 0 38 49 0 0 -38 h\n1 g
      1874 4120 N 0 38 48 0 0 -38 h\n1 g 1825 4120 N 0 38 49 0 0 -38 h\n1 g
      1777 4120 N 0 38 48 0 0 -38 h\n1 g 1728 4120 N 0 38 49 0 0 -38 h\n1 g
      1679 4120 N 0 38 49 0 0 -38 h\n1 g 1631 4120 N 0 38 48 0 0 -38 h\n1 g
      1582 4120 N 0 38 49 0 0 -38 h\n1 g 1534 4120 N 0 38 48 0 0 -38 h\n1 g
      1485 4120 N 0 38 49 0 0 -38 h\n1 g 1436 4120 N 0 38 49 0 0 -38 h\n1 g
      1388 4120 N 0 38 48 0 0 -38 h\n1 g 1339 4120 N 0 38 49 0 0 -38 h\n1 g
      1290 4120 N 0 38 49 0 0 -38 h\n1 g 1242 4120 N 0 38 48 0 0 -38 h\n1 g
      1193 4120 N 0 38 49 0 0 -38 h\n1 g 5957 4082 N 0 39 49 0 0 -39 h\n1 g
      5909 4082 N 0 39 48 0 0 -39 h\n1 g 5860 4082 N 0 39 49 0 0 -39 h\n1 g
      5811 4082 N 0 39 49 0 0 -39 h\n1 g 5763 4082 N 0 39 48 0 0 -39 h\n1 g
      5714 4082 N 0 39 49 0 0 -39 h\n1 g 5665 4082 N 0 39 49 0 0 -39 h\n1 g
      5617 4082 N 0 39 48 0 0 -39 h\n1 g 5568 4082 N 0 39 49 0 0 -39 h\n1 g
      5520 4082 N 0 39 48 0 0 -39 h\n1 g 5471 4082 N 0 39 49 0 0 -39 h\n1 g
      5422 4082 N 0 39 49 0 0 -39 h\n1 g 5374 4082 N 0 39 48 0 0 -39 h\n1 g
      5325 4082 N 0 39 49 0 0 -39 h\n1 g 5277 4082 N 0 39 48 0 0 -39 h\n1 g
      5228 4082 N 0 39 49 0 0 -39 h\n1 g 5179 4082 N 0 39 49 0 0 -39 h\n1 g
      5131 4082 N 0 39 48 0 0 -39 h\n1 g 5082 4082 N 0 39 49 0 0 -39 h\n.95 g
      5034 4082 N 0 39 48 0 0 -39 h\n.85 g 4985 4082 N 0 39 49 0 0 -39 h\n.8
      g 4936 4082 N 0 39 49 0 0 -39 h\n.8 g 4888 4082 N 0 39 48 0 0 -39 h\n.8
      g 4839 4082 N 0 39 49 0 0 -39 h\n.8 g 4790 4082 N 0 39 49 0 0 -39 h\n.8
      g 4742 4082 N 0 39 48 0 0 -39 h\n.8 g 4693 4082 N 0 39 49 0 0 -39 h\n.8
      g 4645 4082 N 0 39 48 0 0 -39 h\n.8 g 4596 4082 N 0 39 49 0 0 -39 h\n.8
      g 4547 4082 N 0 39 49 0 0 -39 h\n.8 g 4499 4082 N 0 39 48 0 0 -39 h\n.8
      g 4450 4082 N 0 39 49 0 0 -39 h\n.8 g 4402 4082 N 0 39 48 0 0 -39 h\n.8
      g 4353 4082 N 0 39 49 0 0 -39 h\n.8 g 4304 4082 N 0 39 49 0 0 -39 h\n.8
      g 4256 4082 N 0 39 48 0 0 -39 h\n.8 g 4207 4082 N 0 39 49 0 0 -39 h\n.8
      g 4159 4082 N 0 39 48 0 0 -39 h\n.8 g 4110 4082 N 0 39 49 0 0 -39 h\n.8
      g 4061 4082 N 0 39 49 0 0 -39 h\n.8 g 4013 4082 N 0 39 48 0 0 -39 h\n.8
      g 3964 4082 N 0 39 49 0 0 -39 h\n.8 g 3915 4082 N 0 39 49 0 0 -39 h\n.8
      g 3867 4082 N 0 39 48 0 0 -39 h\n.8 g 3818 4082 N 0 39 49 0 0 -39 h\n.8
      g 3770 4082 N 0 39 48 0 0 -39 h\n.8 g 3721 4082 N 0 39 49 0 0 -39 h\n.8
      g 3672 4082 N 0 39 49 0 0 -39 h\n.8 g 3624 4082 N 0 39 48 0 0 -39 h\n.8
      g 3575 4082 N 0 39 49 0 0 -39 h\n.8 g 3527 4082 N 0 39 48 0 0 -39 h\n.8
      g 3478 4082 N 0 39 49 0 0 -39 h\n.8 g 3429 4082 N 0 39 49 0 0 -39 h\n.8
      g 3381 4082 N 0 39 48 0 0 -39 h\n.8 g 3332 4082 N 0 39 49 0 0 -39 h\n.8
      g 3284 4082 N 0 39 48 0 0 -39 h\n.8 g 3235 4082 N 0 39 49 0 0 -39 h\n.8
      g 3186 4082 N 0 39 49 0 0 -39 h\n.8 g 3138 4082 N 0 39 48 0 0 -39 h\n.8
      g 3089 4082 N 0 39 49 0 0 -39 h\n.8 g 3040 4082 N 0 39 49 0 0 -39 h\n.8
      g 2992 4082 N 0 39 48 0 0 -39 h\n.8 g 2943 4082 N 0 39 49 0 0 -39 h\n.8
      g 2895 4082 N 0 39 48 0 0 -39 h\n.8 g 2846 4082 N 0 39 49 0 0 -39 h\n.8
      g 2797 4082 N 0 39 49 0 0 -39 h\n.8 g 2749 4082 N 0 39 48 0 0 -39 h\n.8
      g 2700 4082 N 0 39 49 0 0 -39 h\n.8 g 2652 4082 N 0 39 48 0 0 -39 h\n.8
      g 2603 4082 N 0 39 49 0 0 -39 h\n.8 g 2554 4082 N 0 39 49 0 0 -39 h\n.8
      g 2506 4082 N 0 39 48 0 0 -39 h\n.8 g 2457 4082 N 0 39 49 0 0 -39 h\n.8
      g 2409 4082 N 0 39 48 0 0 -39 h\n.8 g 2360 4082 N 0 39 49 0 0 -39 h\n.8
      g 2311 4082 N 0 39 49 0 0 -39 h\n.8 g 2263 4082 N 0 39 48 0 0 -39 h\n.8
      g 2214 4082 N 0 39 49 0 0 -39 h\n.85 g 2165 4082 N 0 39 49 0 0 -39
      h\n.95 g 2117 4082 N 0 39 48 0 0 -39 h\n1 g 2068 4082 N 0 39 49 0 0 -39
      h\n1 g 2020 4082 N 0 39 48 0 0 -39 h\n1 g 1971 4082 N 0 39 49 0 0 -39
      h\n1 g 1922 4082 N 0 39 49 0 0 -39 h\n1 g 1874 4082 N 0 39 48 0 0 -39
      h\n1 g 1825 4082 N 0 39 49 0 0 -39 h\n1 g 1777 4082 N 0 39 48 0 0 -39
      h\n1 g 1728 4082 N 0 39 49 0 0 -39 h\n1 g 1679 4082 N 0 39 49 0 0 -39
      h\n1 g 1631 4082 N 0 39 48 0 0 -39 h\n1 g 1582 4082 N 0 39 49 0 0 -39
      h\n1 g 1534 4082 N 0 39 48 0 0 -39 h\n1 g 1485 4082 N 0 39 49 0 0 -39
      h\n1 g 1436 4082 N 0 39 49 0 0 -39 h\n1 g 1388 4082 N 0 39 48 0 0 -39
      h\n1 g 1339 4082 N 0 39 49 0 0 -39 h\n1 g 1290 4082 N 0 39 49 0 0 -39
      h\n1 g 1242 4082 N 0 39 48 0 0 -39 h\n1 g 1193 4082 N 0 39 49 0 0 -39
      h\n1 g 5957 4043 N 0 39 49 0 0 -39 h\n1 g 5909 4043 N 0 39 48 0 0 -39
      h\n1 g 5860 4043 N 0 39 49 0 0 -39 h\n1 g 5811 4043 N 0 39 49 0 0 -39
      h\n1 g 5763 4043 N 0 39 48 0 0 -39 h\n1 g 5714 4043 N 0 39 49 0 0 -39
      h\n1 g 5665 4043 N 0 39 49 0 0 -39 h\n1 g 5617 4043 N 0 39 48 0 0 -39
      h\n1 g 5568 4043 N 0 39 49 0 0 -39 h\n1 g 5520 4043 N 0 39 48 0 0 -39
      h\n1 g 5471 4043 N 0 39 49 0 0 -39 h\n1 g 5422 4043 N 0 39 49 0 0 -39
      h\n1 g 5374 4043 N 0 39 48 0 0 -39 h\n1 g 5325 4043 N 0 39 49 0 0 -39
      h\n1 g 5277 4043 N 0 39 48 0 0 -39 h\n1 g 5228 4043 N 0 39 49 0 0 -39
      h\n1 g 5179 4043 N 0 39 49 0 0 -39 h\n1 g 5131 4043 N 0 39 48 0 0 -39
      h\n1 g 5082 4043 N 0 39 49 0 0 -39 h\n1 g 5034 4043 N 0 39 48 0 0 -39
      h\n.9 g 4985 4043 N 0 39 49 0 0 -39 h\n.8 g 4936 4043 N 0 39 49 0 0 -39
      h\n.8 g 4888 4043 N 0 39 48 0 0 -39 h\n.8 g 4839 4043 N 0 39 49 0 0 -39
      h\n.8 g 4790 4043 N 0 39 49 0 0 -39 h\n.8 g 4742 4043 N 0 39 48 0 0 -39
      h\n.8 g 4693 4043 N 0 39 49 0 0 -39 h\n.8 g 4645 4043 N 0 39 48 0 0 -39
      h\n.8 g 4596 4043 N 0 39 49 0 0 -39 h\n.8 g 4547 4043 N 0 39 49 0 0 -39
      h\n.8 g 4499 4043 N 0 39 48 0 0 -39 h\n.8 g 4450 4043 N 0 39 49 0 0 -39
      h\n.8 g 4402 4043 N 0 39 48 0 0 -39 h\n.8 g 4353 4043 N 0 39 49 0 0 -39
      h\n.8 g 4304 4043 N 0 39 49 0 0 -39 h\n.8 g 4256 4043 N 0 39 48 0 0 -39
      h\n.8 g 4207 4043 N 0 39 49 0 0 -39 h\n.8 g 4159 4043 N 0 39 48 0 0 -39
      h\n.8 g 4110 4043 N 0 39 49 0 0 -39 h\n.8 g 4061 4043 N 0 39 49 0 0 -39
      h\n.8 g 4013 4043 N 0 39 48 0 0 -39 h\n.8 g 3964 4043 N 0 39 49 0 0 -39
      h\n.8 g 3915 4043 N 0 39 49 0 0 -39 h\n.8 g 3867 4043 N 0 39 48 0 0 -39
      h\n.8 g 3818 4043 N 0 39 49 0 0 -39 h\n.8 g 3770 4043 N 0 39 48 0 0 -39
      h\n.8 g 3721 4043 N 0 39 49 0 0 -39 h\n.8 g 3672 4043 N 0 39 49 0 0 -39
      h\n.8 g 3624 4043 N 0 39 48 0 0 -39 h\n.8 g 3575 4043 N 0 39 49 0 0 -39
      h\n.8 g 3527 4043 N 0 39 48 0 0 -39 h\n.8 g 3478 4043 N 0 39 49 0 0 -39
      h\n.8 g 3429 4043 N 0 39 49 0 0 -39 h\n.8 g 3381 4043 N 0 39 48 0 0 -39
      h\n.8 g 3332 4043 N 0 39 49 0 0 -39 h\n.8 g 3284 4043 N 0 39 48 0 0 -39
      h\n.8 g 3235 4043 N 0 39 49 0 0 -39 h\n.8 g 3186 4043 N 0 39 49 0 0 -39
      h\n.8 g 3138 4043 N 0 39 48 0 0 -39 h\n.8 g 3089 4043 N 0 39 49 0 0 -39
      h\n.8 g 3040 4043 N 0 39 49 0 0 -39 h\n.8 g 2992 4043 N 0 39 48 0 0 -39
      h\n.8 g 2943 4043 N 0 39 49 0 0 -39 h\n.8 g 2895 4043 N 0 39 48 0 0 -39
      h\n.8 g 2846 4043 N 0 39 49 0 0 -39 h\n.8 g 2797 4043 N 0 39 49 0 0 -39
      h\n.8 g 2749 4043 N 0 39 48 0 0 -39 h\n.8 g 2700 4043 N 0 39 49 0 0 -39
      h\n.8 g 2652 4043 N 0 39 48 0 0 -39 h\n.8 g 2603 4043 N 0 39 49 0 0 -39
      h\n.8 g 2554 4043 N 0 39 49 0 0 -39 h\n.8 g 2506 4043 N 0 39 48 0 0 -39
      h\n.8 g 2457 4043 N 0 39 49 0 0 -39 h\n.8 g 2409 4043 N 0 39 48 0 0 -39
      h\n.8 g 2360 4043 N 0 39 49 0 0 -39 h\n.8 g 2311 4043 N 0 39 49 0 0 -39
      h\n.8 g 2263 4043 N 0 39 48 0 0 -39 h\n.8 g 2214 4043 N 0 39 49 0 0 -39
      h\n.9 g 2165 4043 N 0 39 49 0 0 -39 h\n1 g 2117 4043 N 0 39 48 0 0 -39
      h\n1 g 2068 4043 N 0 39 49 0 0 -39 h\n1 g 2020 4043 N 0 39 48 0 0 -39
      h\n1 g 1971 4043 N 0 39 49 0 0 -39 h\n1 g 1922 4043 N 0 39 49 0 0 -39
      h\n1 g 1874 4043 N 0 39 48 0 0 -39 h\n1 g 1825 4043 N 0 39 49 0 0 -39
      h\n1 g 1777 4043 N 0 39 48 0 0 -39 h\n1 g 1728 4043 N 0 39 49 0 0 -39
      h\n1 g 1679 4043 N 0 39 49 0 0 -39 h\n1 g 1631 4043 N 0 39 48 0 0 -39
      h\n1 g 1582 4043 N 0 39 49 0 0 -39 h\n1 g 1534 4043 N 0 39 48 0 0 -39
      h\n1 g 1485 4043 N 0 39 49 0 0 -39 h\n1 g 1436 4043 N 0 39 49 0 0 -39
      h\n1 g 1388 4043 N 0 39 48 0 0 -39 h\n1 g 1339 4043 N 0 39 49 0 0 -39
      h\n1 g 1290 4043 N 0 39 49 0 0 -39 h\n1 g 1242 4043 N 0 39 48 0 0 -39
      h\n1 g 1193 4043 N 0 39 49 0 0 -39 h\n1 g 5957 4004 N 0 39 49 0 0 -39
      h\n1 g 5909 4004 N 0 39 48 0 0 -39 h\n1 g 5860 4004 N 0 39 49 0 0 -39
      h\n1 g 5811 4004 N 0 39 49 0 0 -39 h\n1 g 5763 4004 N 0 39 48 0 0 -39
      h\n1 g 5714 4004 N 0 39 49 0 0 -39 h\n1 g 5665 4004 N 0 39 49 0 0 -39
      h\n1 g 5617 4004 N 0 39 48 0 0 -39 h\n1 g 5568 4004 N 0 39 49 0 0 -39
      h\n1 g 5520 4004 N 0 39 48 0 0 -39 h\n1 g 5471 4004 N 0 39 49 0 0 -39
      h\n1 g 5422 4004 N 0 39 49 0 0 -39 h\n1 g 5374 4004 N 0 39 48 0 0 -39
      h\n1 g 5325 4004 N 0 39 49 0 0 -39 h\n1 g 5277 4004 N 0 39 48 0 0 -39
      h\n1 g 5228 4004 N 0 39 49 0 0 -39 h\n1 g 5179 4004 N 0 39 49 0 0 -39
      h\n1 g 5131 4004 N 0 39 48 0 0 -39 h\n1 g 5082 4004 N 0 39 49 0 0 -39
      h\n1 g 5034 4004 N 0 39 48 0 0 -39 h\n.9 g 4985 4004 N 0 39 49 0 0 -39
      h\n.8 g 4936 4004 N 0 39 49 0 0 -39 h\n.8 g 4888 4004 N 0 39 48 0 0 -39
      h\n.8 g 4839 4004 N 0 39 49 0 0 -39 h\n.8 g 4790 4004 N 0 39 49 0 0 -39
      h\n.8 g 4742 4004 N 0 39 48 0 0 -39 h\n.8 g 4693 4004 N 0 39 49 0 0 -39
      h\n.8 g 4645 4004 N 0 39 48 0 0 -39 h\n.8 g 4596 4004 N 0 39 49 0 0 -39
      h\n.8 g 4547 4004 N 0 39 49 0 0 -39 h\n.8 g 4499 4004 N 0 39 48 0 0 -39
      h\n.8 g 4450 4004 N 0 39 49 0 0 -39 h\n.8 g 4402 4004 N 0 39 48 0 0 -39
      h\n.8 g 4353 4004 N 0 39 49 0 0 -39 h\n.8 g 4304 4004 N 0 39 49 0 0 -39
      h\n.8 g 4256 4004 N 0 39 48 0 0 -39 h\n.8 g 4207 4004 N 0 39 49 0 0 -39
      h\n.8 g 4159 4004 N 0 39 48 0 0 -39 h\n.8 g 4110 4004 N 0 39 49 0 0 -39
      h\n.8 g 4061 4004 N 0 39 49 0 0 -39 h\n.8 g 4013 4004 N 0 39 48 0 0 -39
      h\n.8 g 3964 4004 N 0 39 49 0 0 -39 h\n.8 g 3915 4004 N 0 39 49 0 0 -39
      h\n.8 g 3867 4004 N 0 39 48 0 0 -39 h\n.8 g 3818 4004 N 0 39 49 0 0 -39
      h\n.8 g 3770 4004 N 0 39 48 0 0 -39 h\n.8 g 3721 4004 N 0 39 49 0 0 -39
      h\n.8 g 3672 4004 N 0 39 49 0 0 -39 h\n.8 g 3624 4004 N 0 39 48 0 0 -39
      h\n.8 g 3575 4004 N 0 39 49 0 0 -39 h\n.8 g 3527 4004 N 0 39 48 0 0 -39
      h\n.8 g 3478 4004 N 0 39 49 0 0 -39 h\n.8 g 3429 4004 N 0 39 49 0 0 -39
      h\n.8 g 3381 4004 N 0 39 48 0 0 -39 h\n.8 g 3332 4004 N 0 39 49 0 0 -39
      h\n.8 g 3284 4004 N 0 39 48 0 0 -39 h\n.8 g 3235 4004 N 0 39 49 0 0 -39
      h\n.8 g 3186 4004 N 0 39 49 0 0 -39 h\n.8 g 3138 4004 N 0 39 48 0 0 -39
      h\n.8 g 3089 4004 N 0 39 49 0 0 -39 h\n.8 g 3040 4004 N 0 39 49 0 0 -39
      h\n.8 g 2992 4004 N 0 39 48 0 0 -39 h\n.8 g 2943 4004 N 0 39 49 0 0 -39
      h\n.8 g 2895 4004 N 0 39 48 0 0 -39 h\n.8 g 2846 4004 N 0 39 49 0 0 -39
      h\n.8 g 2797 4004 N 0 39 49 0 0 -39 h\n.8 g 2749 4004 N 0 39 48 0 0 -39
      h\n.8 g 2700 4004 N 0 39 49 0 0 -39 h\n.8 g 2652 4004 N 0 39 48 0 0 -39
      h\n.8 g 2603 4004 N 0 39 49 0 0 -39 h\n.8 g 2554 4004 N 0 39 49 0 0 -39
      h\n.8 g 2506 4004 N 0 39 48 0 0 -39 h\n.8 g 2457 4004 N 0 39 49 0 0 -39
      h\n.8 g 2409 4004 N 0 39 48 0 0 -39 h\n.8 g 2360 4004 N 0 39 49 0 0 -39
      h\n.8 g 2311 4004 N 0 39 49 0 0 -39 h\n.8 g 2263 4004 N 0 39 48 0 0 -39
      h\n.8 g 2214 4004 N 0 39 49 0 0 -39 h\n.9 g 2165 4004 N 0 39 49 0 0 -39
      h\n1 g 2117 4004 N 0 39 48 0 0 -39 h\n1 g 2068 4004 N 0 39 49 0 0 -39
      h\n1 g 2020 4004 N 0 39 48 0 0 -39 h\n1 g 1971 4004 N 0 39 49 0 0 -39
      h\n1 g 1922 4004 N 0 39 49 0 0 -39 h\n1 g 1874 4004 N 0 39 48 0 0 -39
      h\n1 g 1825 4004 N 0 39 49 0 0 -39 h\n1 g 1777 4004 N 0 39 48 0 0 -39
      h\n1 g 1728 4004 N 0 39 49 0 0 -39 h\n1 g 1679 4004 N 0 39 49 0 0 -39
      h\n1 g 1631 4004 N 0 39 48 0 0 -39 h\n1 g 1582 4004 N 0 39 49 0 0 -39
      h\n1 g 1534 4004 N 0 39 48 0 0 -39 h\n1 g 1485 4004 N 0 39 49 0 0 -39
      h\n1 g 1436 4004 N 0 39 49 0 0 -39 h\n1 g 1388 4004 N 0 39 48 0 0 -39
      h\n1 g 1339 4004 N 0 39 49 0 0 -39 h\n1 g 1290 4004 N 0 39 49 0 0 -39
      h\n1 g 1242 4004 N 0 39 48 0 0 -39 h\n1 g 1193 4004 N 0 39 49 0 0 -39
      h\n1 g 5957 3965 N 0 38 49 0 0 -38 h\n1 g 5909 3965 N 0 38 48 0 0 -38
      h\n1 g 5860 3965 N 0 38 49 0 0 -38 h\n1 g 5811 3965 N 0 38 49 0 0 -38
      h\n1 g 5763 3965 N 0 38 48 0 0 -38 h\n1 g 5714 3965 N 0 38 49 0 0 -38
      h\n1 g 5665 3965 N 0 38 49 0 0 -38 h\n1 g 5617 3965 N 0 38 48 0 0 -38
      h\n1 g 5568 3965 N 0 38 49 0 0 -38 h\n1 g 5520 3965 N 0 38 48 0 0 -38
      h\n1 g 5471 3965 N 0 38 49 0 0 -38 h\n1 g 5422 3965 N 0 38 49 0 0 -38
      h\n1 g 5374 3965 N 0 38 48 0 0 -38 h\n1 g 5325 3965 N 0 38 49 0 0 -38
      h\n1 g 5277 3965 N 0 38 48 0 0 -38 h\n1 g 5228 3965 N 0 38 49 0 0 -38
      h\n1 g 5179 3965 N 0 38 49 0 0 -38 h\n1 g 5131 3965 N 0 38 48 0 0 -38
      h\n1 g 5082 3965 N 0 38 49 0 0 -38 h\n1 g 5034 3965 N 0 38 48 0 0 -38
      h\n.9 g 4985 3965 N 0 38 49 0 0 -38 h\n.8 g 4936 3965 N 0 38 49 0 0 -38
      h\n.8 g 4888 3965 N 0 38 48 0 0 -38 h\n.8 g 4839 3965 N 0 38 49 0 0 -38
      h\n.8 g 4790 3965 N 0 38 49 0 0 -38 h\n.8 g 4742 3965 N 0 38 48 0 0 -38
      h\n.8 g 4693 3965 N 0 38 49 0 0 -38 h\n.8 g 4645 3965 N 0 38 48 0 0 -38
      h\n.8 g 4596 3965 N 0 38 49 0 0 -38 h\n.8 g 4547 3965 N 0 38 49 0 0 -38
      h\n.8 g 4499 3965 N 0 38 48 0 0 -38 h\n.8 g 4450 3965 N 0 38 49 0 0 -38
      h\n.8 g 4402 3965 N 0 38 48 0 0 -38 h\n.8 g 4353 3965 N 0 38 49 0 0 -38
      h\n.8 g 4304 3965 N 0 38 49 0 0 -38 h\n.8 g 4256 3965 N 0 38 48 0 0 -38
      h\n.8 g 4207 3965 N 0 38 49 0 0 -38 h\n.8 g 4159 3965 N 0 38 48 0 0 -38
      h\n.8 g 4110 3965 N 0 38 49 0 0 -38 h\n.8 g 4061 3965 N 0 38 49 0 0 -38
      h\n.8 g 4013 3965 N 0 38 48 0 0 -38 h\n.8 g 3964 3965 N 0 38 49 0 0 -38
      h\n.8 g 3915 3965 N 0 38 49 0 0 -38 h\n.8 g 3867 3965 N 0 38 48 0 0 -38
      h\n.8 g 3818 3965 N 0 38 49 0 0 -38 h\n.8 g 3770 3965 N 0 38 48 0 0 -38
      h\n.8 g 3721 3965 N 0 38 49 0 0 -38 h\n.8 g 3672 3965 N 0 38 49 0 0 -38
      h\n.8 g 3624 3965 N 0 38 48 0 0 -38 h\n.8 g 3575 3965 N 0 38 49 0 0 -38
      h\n.8 g 3527 3965 N 0 38 48 0 0 -38 h\n.8 g 3478 3965 N 0 38 49 0 0 -38
      h\n.8 g 3429 3965 N 0 38 49 0 0 -38 h\n.8 g 3381 3965 N 0 38 48 0 0 -38
      h\n.8 g 3332 3965 N 0 38 49 0 0 -38 h\n.8 g 3284 3965 N 0 38 48 0 0 -38
      h\n.8 g 3235 3965 N 0 38 49 0 0 -38 h\n.8 g 3186 3965 N 0 38 49 0 0 -38
      h\n.8 g 3138 3965 N 0 38 48 0 0 -38 h\n.8 g 3089 3965 N 0 38 49 0 0 -38
      h\n.8 g 3040 3965 N 0 38 49 0 0 -38 h\n.8 g 2992 3965 N 0 38 48 0 0 -38
      h\n.8 g 2943 3965 N 0 38 49 0 0 -38 h\n.8 g 2895 3965 N 0 38 48 0 0 -38
      h\n.8 g 2846 3965 N 0 38 49 0 0 -38 h\n.8 g 2797 3965 N 0 38 49 0 0 -38
      h\n.8 g 2749 3965 N 0 38 48 0 0 -38 h\n.8 g 2700 3965 N 0 38 49 0 0 -38
      h\n.8 g 2652 3965 N 0 38 48 0 0 -38 h\n.8 g 2603 3965 N 0 38 49 0 0 -38
      h\n.8 g 2554 3965 N 0 38 49 0 0 -38 h\n.8 g 2506 3965 N 0 38 48 0 0 -38
      h\n.8 g 2457 3965 N 0 38 49 0 0 -38 h\n.8 g 2409 3965 N 0 38 48 0 0 -38
      h\n.8 g 2360 3965 N 0 38 49 0 0 -38 h\n.8 g 2311 3965 N 0 38 49 0 0 -38
      h\n.8 g 2263 3965 N 0 38 48 0 0 -38 h\n.8 g 2214 3965 N 0 38 49 0 0 -38
      h\n.9 g 2165 3965 N 0 38 49 0 0 -38 h\n1 g 2117 3965 N 0 38 48 0 0 -38
      h\n1 g 2068 3965 N 0 38 49 0 0 -38 h\n1 g 2020 3965 N 0 38 48 0 0 -38
      h\n1 g 1971 3965 N 0 38 49 0 0 -38 h\n1 g 1922 3965 N 0 38 49 0 0 -38
      h\n1 g 1874 3965 N 0 38 48 0 0 -38 h\n1 g 1825 3965 N 0 38 49 0 0 -38
      h\n1 g 1777 3965 N 0 38 48 0 0 -38 h\n1 g 1728 3965 N 0 38 49 0 0 -38
      h\n1 g 1679 3965 N 0 38 49 0 0 -38 h\n1 g 1631 3965 N 0 38 48 0 0 -38
      h\n1 g 1582 3965 N 0 38 49 0 0 -38 h\n1 g 1534 3965 N 0 38 48 0 0 -38
      h\n1 g 1485 3965 N 0 38 49 0 0 -38 h\n1 g 1436 3965 N 0 38 49 0 0 -38
      h\n1 g 1388 3965 N 0 38 48 0 0 -38 h\n1 g 1339 3965 N 0 38 49 0 0 -38
      h\n1 g 1290 3965 N 0 38 49 0 0 -38 h\n1 g 1242 3965 N 0 38 48 0 0 -38
      h\n1 g 1193 3965 N 0 38 49 0 0 -38 h\n1 g 5957 3927 N 0 39 49 0 0 -39
      h\n1 g 5909 3927 N 0 39 48 0 0 -39 h\n1 g 5860 3927 N 0 39 49 0 0 -39
      h\n1 g 5811 3927 N 0 39 49 0 0 -39 h\n1 g 5763 3927 N 0 39 48 0 0 -39
      h\n1 g 5714 3927 N 0 39 49 0 0 -39 h\n1 g 5665 3927 N 0 39 49 0 0 -39
      h\n1 g 5617 3927 N 0 39 48 0 0 -39 h\n1 g 5568 3927 N 0 39 49 0 0 -39
      h\n1 g 5520 3927 N 0 39 48 0 0 -39 h\n1 g 5471 3927 N 0 39 49 0 0 -39
      h\n1 g 5422 3927 N 0 39 49 0 0 -39 h\n1 g 5374 3927 N 0 39 48 0 0 -39
      h\n1 g 5325 3927 N 0 39 49 0 0 -39 h\n1 g 5277 3927 N 0 39 48 0 0 -39
      h\n1 g 5228 3927 N 0 39 49 0 0 -39 h\n1 g 5179 3927 N 0 39 49 0 0 -39
      h\n1 g 5131 3927 N 0 39 48 0 0 -39 h\n1 g 5082 3927 N 0 39 49 0 0 -39
      h\n1 g 5034 3927 N 0 39 48 0 0 -39 h\n.9 g 4985 3927 N 0 39 49 0 0 -39
      h\n.8 g 4936 3927 N 0 39 49 0 0 -39 h\n.8 g 4888 3927 N 0 39 48 0 0 -39
      h\n.8 g 4839 3927 N 0 39 49 0 0 -39 h\n.8 g 4790 3927 N 0 39 49 0 0 -39
      h\n.8 g 4742 3927 N 0 39 48 0 0 -39 h\n.8 g 4693 3927 N 0 39 49 0 0 -39
      h\n.8 g 4645 3927 N 0 39 48 0 0 -39 h\n.8 g 4596 3927 N 0 39 49 0 0 -39
      h\n.8 g 4547 3927 N 0 39 49 0 0 -39 h\n.8 g 4499 3927 N 0 39 48 0 0 -39
      h\n.8 g 4450 3927 N 0 39 49 0 0 -39 h\n.8 g 4402 3927 N 0 39 48 0 0 -39
      h\n.8 g 4353 3927 N 0 39 49 0 0 -39 h\n.8 g 4304 3927 N 0 39 49 0 0 -39
      h\n.8 g 4256 3927 N 0 39 48 0 0 -39 h\n.8 g 4207 3927 N 0 39 49 0 0 -39
      h\n.8 g 4159 3927 N 0 39 48 0 0 -39 h\n.8 g 4110 3927 N 0 39 49 0 0 -39
      h\n.8 g 4061 3927 N 0 39 49 0 0 -39 h\n.8 g 4013 3927 N 0 39 48 0 0 -39
      h\n.8 g 3964 3927 N 0 39 49 0 0 -39 h\n.8 g 3915 3927 N 0 39 49 0 0 -39
      h\n.8 g 3867 3927 N 0 39 48 0 0 -39 h\n.8 g 3818 3927 N 0 39 49 0 0 -39
      h\n.8 g 3770 3927 N 0 39 48 0 0 -39 h\n.8 g 3721 3927 N 0 39 49 0 0 -39
      h\n.8 g 3672 3927 N 0 39 49 0 0 -39 h\n.8 g 3624 3927 N 0 39 48 0 0 -39
      h\n.8 g 3575 3927 N 0 39 49 0 0 -39 h\n.8 g 3527 3927 N 0 39 48 0 0 -39
      h\n.8 g 3478 3927 N 0 39 49 0 0 -39 h\n.8 g 3429 3927 N 0 39 49 0 0 -39
      h\n.8 g 3381 3927 N 0 39 48 0 0 -39 h\n.8 g 3332 3927 N 0 39 49 0 0 -39
      h\n.8 g 3284 3927 N 0 39 48 0 0 -39 h\n.8 g 3235 3927 N 0 39 49 0 0 -39
      h\n.8 g 3186 3927 N 0 39 49 0 0 -39 h\n.8 g 3138 3927 N 0 39 48 0 0 -39
      h\n.8 g 3089 3927 N 0 39 49 0 0 -39 h\n.8 g 3040 3927 N 0 39 49 0 0 -39
      h\n.8 g 2992 3927 N 0 39 48 0 0 -39 h\n.8 g 2943 3927 N 0 39 49 0 0 -39
      h\n.8 g 2895 3927 N 0 39 48 0 0 -39 h\n.8 g 2846 3927 N 0 39 49 0 0 -39
      h\n.8 g 2797 3927 N 0 39 49 0 0 -39 h\n.8 g 2749 3927 N 0 39 48 0 0 -39
      h\n.8 g 2700 3927 N 0 39 49 0 0 -39 h\n.8 g 2652 3927 N 0 39 48 0 0 -39
      h\n.8 g 2603 3927 N 0 39 49 0 0 -39 h\n.8 g 2554 3927 N 0 39 49 0 0 -39
      h\n.8 g 2506 3927 N 0 39 48 0 0 -39 h\n.8 g 2457 3927 N 0 39 49 0 0 -39
      h\n.8 g 2409 3927 N 0 39 48 0 0 -39 h\n.8 g 2360 3927 N 0 39 49 0 0 -39
      h\n.8 g 2311 3927 N 0 39 49 0 0 -39 h\n.8 g 2263 3927 N 0 39 48 0 0 -39
      h\n.8 g 2214 3927 N 0 39 49 0 0 -39 h\n.9 g 2165 3927 N 0 39 49 0 0 -39
      h\n1 g 2117 3927 N 0 39 48 0 0 -39 h\n1 g 2068 3927 N 0 39 49 0 0 -39
      h\n1 g 2020 3927 N 0 39 48 0 0 -39 h\n1 g 1971 3927 N 0 39 49 0 0 -39
      h\n1 g 1922 3927 N 0 39 49 0 0 -39 h\n1 g 1874 3927 N 0 39 48 0 0 -39
      h\n1 g 1825 3927 N 0 39 49 0 0 -39 h\n1 g 1777 3927 N 0 39 48 0 0 -39
      h\n1 g 1728 3927 N 0 39 49 0 0 -39 h\n1 g 1679 3927 N 0 39 49 0 0 -39
      h\n1 g 1631 3927 N 0 39 48 0 0 -39 h\n1 g 1582 3927 N 0 39 49 0 0 -39
      h\n1 g 1534 3927 N 0 39 48 0 0 -39 h\n1 g 1485 3927 N 0 39 49 0 0 -39
      h\n1 g 1436 3927 N 0 39 49 0 0 -39 h\n1 g 1388 3927 N 0 39 48 0 0 -39
      h\n1 g 1339 3927 N 0 39 49 0 0 -39 h\n1 g 1290 3927 N 0 39 49 0 0 -39
      h\n1 g 1242 3927 N 0 39 48 0 0 -39 h\n1 g 1193 3927 N 0 39 49 0 0 -39
      h\n1 g 5957 3888 N 0 39 49 0 0 -39 h\n1 g 5909 3888 N 0 39 48 0 0 -39
      h\n1 g 5860 3888 N 0 39 49 0 0 -39 h\n1 g 5811 3888 N 0 39 49 0 0 -39
      h\n1 g 5763 3888 N 0 39 48 0 0 -39 h\n1 g 5714 3888 N 0 39 49 0 0 -39
      h\n1 g 5665 3888 N 0 39 49 0 0 -39 h\n1 g 5617 3888 N 0 39 48 0 0 -39
      h\n1 g 5568 3888 N 0 39 49 0 0 -39 h\n1 g 5520 3888 N 0 39 48 0 0 -39
      h\n1 g 5471 3888 N 0 39 49 0 0 -39 h\n1 g 5422 3888 N 0 39 49 0 0 -39
      h\n1 g 5374 3888 N 0 39 48 0 0 -39 h\n1 g 5325 3888 N 0 39 49 0 0 -39
      h\n1 g 5277 3888 N 0 39 48 0 0 -39 h\n1 g 5228 3888 N 0 39 49 0 0 -39
      h\n1 g 5179 3888 N 0 39 49 0 0 -39 h\n1 g 5131 3888 N 0 39 48 0 0 -39
      h\n1 g 5082 3888 N 0 39 49 0 0 -39 h\n1 g 5034 3888 N 0 39 48 0 0 -39
      h\n.95 g 4985 3888 N 0 39 49 0 0 -39 h\n.85 g 4936 3888 N 0 39 49 0 0
      -39 h\n.8 g 4888 3888 N 0 39 48 0 0 -39 h\n.8 g 4839 3888 N 0 39 49 0 0
      -39 h\n.8 g 4790 3888 N 0 39 49 0 0 -39 h\n.8 g 4742 3888 N 0 39 48 0 0
      -39 h\n.8 g 4693 3888 N 0 39 49 0 0 -39 h\n.8 g 4645 3888 N 0 39 48 0 0
      -39 h\n.8 g 4596 3888 N 0 39 49 0 0 -39 h\n.8 g 4547 3888 N 0 39 49 0 0
      -39 h\n.8 g 4499 3888 N 0 39 48 0 0 -39 h\n.8 g 4450 3888 N 0 39 49 0 0
      -39 h\n.8 g 4402 3888 N 0 39 48 0 0 -39 h\n.8 g 4353 3888 N 0 39 49 0 0
      -39 h\n.8 g 4304 3888 N 0 39 49 0 0 -39 h\n.8 g 4256 3888 N 0 39 48 0 0
      -39 h\n.8 g 4207 3888 N 0 39 49 0 0 -39 h\n.8 g 4159 3888 N 0 39 48 0 0
      -39 h\n.8 g 4110 3888 N 0 39 49 0 0 -39 h\n.8 g 4061 3888 N 0 39 49 0 0
      -39 h\n.8 g 4013 3888 N 0 39 48 0 0 -39 h\n.8 g 3964 3888 N 0 39 49 0 0
      -39 h\n.8 g 3915 3888 N 0 39 49 0 0 -39 h\n.8 g 3867 3888 N 0 39 48 0 0
      -39 h\n.8 g 3818 3888 N 0 39 49 0 0 -39 h\n.8 g 3770 3888 N 0 39 48 0 0
      -39 h\n.8 g 3721 3888 N 0 39 49 0 0 -39 h\n.8 g 3672 3888 N 0 39 49 0 0
      -39 h\n.8 g 3624 3888 N 0 39 48 0 0 -39 h\n.8 g 3575 3888 N 0 39 49 0 0
      -39 h\n.8 g 3527 3888 N 0 39 48 0 0 -39 h\n.8 g 3478 3888 N 0 39 49 0 0
      -39 h\n.8 g 3429 3888 N 0 39 49 0 0 -39 h\n.8 g 3381 3888 N 0 39 48 0 0
      -39 h\n.8 g 3332 3888 N 0 39 49 0 0 -39 h\n.8 g 3284 3888 N 0 39 48 0 0
      -39 h\n.8 g 3235 3888 N 0 39 49 0 0 -39 h\n.8 g 3186 3888 N 0 39 49 0 0
      -39 h\n.8 g 3138 3888 N 0 39 48 0 0 -39 h\n.8 g 3089 3888 N 0 39 49 0 0
      -39 h\n.8 g 3040 3888 N 0 39 49 0 0 -39 h\n.8 g 2992 3888 N 0 39 48 0 0
      -39 h\n.8 g 2943 3888 N 0 39 49 0 0 -39 h\n.8 g 2895 3888 N 0 39 48 0 0
      -39 h\n.8 g 2846 3888 N 0 39 49 0 0 -39 h\n.8 g 2797 3888 N 0 39 49 0 0
      -39 h\n.8 g 2749 3888 N 0 39 48 0 0 -39 h\n.8 g 2700 3888 N 0 39 49 0 0
      -39 h\n.8 g 2652 3888 N 0 39 48 0 0 -39 h\n.8 g 2603 3888 N 0 39 49 0 0
      -39 h\n.8 g 2554 3888 N 0 39 49 0 0 -39 h\n.8 g 2506 3888 N 0 39 48 0 0
      -39 h\n.8 g 2457 3888 N 0 39 49 0 0 -39 h\n.8 g 2409 3888 N 0 39 48 0 0
      -39 h\n.8 g 2360 3888 N 0 39 49 0 0 -39 h\n.8 g 2311 3888 N 0 39 49 0 0
      -39 h\n.8 g 2263 3888 N 0 39 48 0 0 -39 h\n.85 g 2214 3888 N 0 39 49 0
      0 -39 h\n.95 g 2165 3888 N 0 39 49 0 0 -39 h\n1 g 2117 3888 N 0 39 48 0
      0 -39 h\n1 g 2068 3888 N 0 39 49 0 0 -39 h\n1 g 2020 3888 N 0 39 48 0 0
      -39 h\n1 g 1971 3888 N 0 39 49 0 0 -39 h\n1 g 1922 3888 N 0 39 49 0 0
      -39 h\n1 g 1874 3888 N 0 39 48 0 0 -39 h\n1 g 1825 3888 N 0 39 49 0 0
      -39 h\n1 g 1777 3888 N 0 39 48 0 0 -39 h\n1 g 1728 3888 N 0 39 49 0 0
      -39 h\n1 g 1679 3888 N 0 39 49 0 0 -39 h\n1 g 1631 3888 N 0 39 48 0 0
      -39 h\n1 g 1582 3888 N 0 39 49 0 0 -39 h\n1 g 1534 3888 N 0 39 48 0 0
      -39 h\n1 g 1485 3888 N 0 39 49 0 0 -39 h\n1 g 1436 3888 N 0 39 49 0 0
      -39 h\n1 g 1388 3888 N 0 39 48 0 0 -39 h\n1 g 1339 3888 N 0 39 49 0 0
      -39 h\n1 g 1290 3888 N 0 39 49 0 0 -39 h\n1 g 1242 3888 N 0 39 48 0 0
      -39 h\n1 g 1193 3888 N 0 39 49 0 0 -39 h\n1 g 5957 3849 N 0 39 49 0 0
      -39 h\n1 g 5909 3849 N 0 39 48 0 0 -39 h\n1 g 5860 3849 N 0 39 49 0 0
      -39 h\n1 g 5811 3849 N 0 39 49 0 0 -39 h\n1 g 5763 3849 N 0 39 48 0 0
      -39 h\n1 g 5714 3849 N 0 39 49 0 0 -39 h\n1 g 5665 3849 N 0 39 49 0 0
      -39 h\n1 g 5617 3849 N 0 39 48 0 0 -39 h\n1 g 5568 3849 N 0 39 49 0 0
      -39 h\n1 g 5520 3849 N 0 39 48 0 0 -39 h\n1 g 5471 3849 N 0 39 49 0 0
      -39 h\n1 g 5422 3849 N 0 39 49 0 0 -39 h\n1 g 5374 3849 N 0 39 48 0 0
      -39 h\n1 g 5325 3849 N 0 39 49 0 0 -39 h\n1 g 5277 3849 N 0 39 48 0 0
      -39 h\n1 g 5228 3849 N 0 39 49 0 0 -39 h\n1 g 5179 3849 N 0 39 49 0 0
      -39 h\n1 g 5131 3849 N 0 39 48 0 0 -39 h\n1 g 5082 3849 N 0 39 49 0 0
      -39 h\n1 g 5034 3849 N 0 39 48 0 0 -39 h\n1 g 4985 3849 N 0 39 49 0 0
      -39 h\n.9 g 4936 3849 N 0 39 49 0 0 -39 h\n.8 g 4888 3849 N 0 39 48 0 0
      -39 h\n.8 g 4839 3849 N 0 39 49 0 0 -39 h\n.8 g 4790 3849 N 0 39 49 0 0
      -39 h\n.8 g 4742 3849 N 0 39 48 0 0 -39 h\n.8 g 4693 3849 N 0 39 49 0 0
      -39 h\n.8 g 4645 3849 N 0 39 48 0 0 -39 h\n.8 g 4596 3849 N 0 39 49 0 0
      -39 h\n.8 g 4547 3849 N 0 39 49 0 0 -39 h\n.8 g 4499 3849 N 0 39 48 0 0
      -39 h\n.8 g 4450 3849 N 0 39 49 0 0 -39 h\n.8 g 4402 3849 N 0 39 48 0 0
      -39 h\n.8 g 4353 3849 N 0 39 49 0 0 -39 h\n.8 g 4304 3849 N 0 39 49 0 0
      -39 h\n.8 g 4256 3849 N 0 39 48 0 0 -39 h\n.8 g 4207 3849 N 0 39 49 0 0
      -39 h\n.8 g 4159 3849 N 0 39 48 0 0 -39 h\n.8 g 4110 3849 N 0 39 49 0 0
      -39 h\n.8 g 4061 3849 N 0 39 49 0 0 -39 h\n.8 g 4013 3849 N 0 39 48 0 0
      -39 h\n.8 g 3964 3849 N 0 39 49 0 0 -39 h\n.8 g 3915 3849 N 0 39 49 0 0
      -39 h\n.8 g 3867 3849 N 0 39 48 0 0 -39 h\n.8 g 3818 3849 N 0 39 49 0 0
      -39 h\n.8 g 3770 3849 N 0 39 48 0 0 -39 h\n.8 g 3721 3849 N 0 39 49 0 0
      -39 h\n.8 g 3672 3849 N 0 39 49 0 0 -39 h\n.8 g 3624 3849 N 0 39 48 0 0
      -39 h\n.8 g 3575 3849 N 0 39 49 0 0 -39 h\n.8 g 3527 3849 N 0 39 48 0 0
      -39 h\n.8 g 3478 3849 N 0 39 49 0 0 -39 h\n.8 g 3429 3849 N 0 39 49 0 0
      -39 h\n.8 g 3381 3849 N 0 39 48 0 0 -39 h\n.8 g 3332 3849 N 0 39 49 0 0
      -39 h\n.8 g 3284 3849 N 0 39 48 0 0 -39 h\n.8 g 3235 3849 N 0 39 49 0 0
      -39 h\n.8 g 3186 3849 N 0 39 49 0 0 -39 h\n.8 g 3138 3849 N 0 39 48 0 0
      -39 h\n.8 g 3089 3849 N 0 39 49 0 0 -39 h\n.8 g 3040 3849 N 0 39 49 0 0
      -39 h\n.8 g 2992 3849 N 0 39 48 0 0 -39 h\n.8 g 2943 3849 N 0 39 49 0 0
      -39 h\n.8 g 2895 3849 N 0 39 48 0 0 -39 h\n.8 g 2846 3849 N 0 39 49 0 0
      -39 h\n.8 g 2797 3849 N 0 39 49 0 0 -39 h\n.8 g 2749 3849 N 0 39 48 0 0
      -39 h\n.8 g 2700 3849 N 0 39 49 0 0 -39 h\n.8 g 2652 3849 N 0 39 48 0 0
      -39 h\n.8 g 2603 3849 N 0 39 49 0 0 -39 h\n.8 g 2554 3849 N 0 39 49 0 0
      -39 h\n.8 g 2506 3849 N 0 39 48 0 0 -39 h\n.8 g 2457 3849 N 0 39 49 0 0
      -39 h\n.8 g 2409 3849 N 0 39 48 0 0 -39 h\n.8 g 2360 3849 N 0 39 49 0 0
      -39 h\n.8 g 2311 3849 N 0 39 49 0 0 -39 h\n.8 g 2263 3849 N 0 39 48 0 0
      -39 h\n.9 g 2214 3849 N 0 39 49 0 0 -39 h\n1 g 2165 3849 N 0 39 49 0 0
      -39 h\n1 g 2117 3849 N 0 39 48 0 0 -39 h\n1 g 2068 3849 N 0 39 49 0 0
      -39 h\n1 g 2020 3849 N 0 39 48 0 0 -39 h\n1 g 1971 3849 N 0 39 49 0 0
      -39 h\n1 g 1922 3849 N 0 39 49 0 0 -39 h\n1 g 1874 3849 N 0 39 48 0 0
      -39 h\n1 g 1825 3849 N 0 39 49 0 0 -39 h\n1 g 1777 3849 N 0 39 48 0 0
      -39 h\n1 g 1728 3849 N 0 39 49 0 0 -39 h\n1 g 1679 3849 N 0 39 49 0 0
      -39 h\n1 g 1631 3849 N 0 39 48 0 0 -39 h\n1 g 1582 3849 N 0 39 49 0 0
      -39 h\n1 g 1534 3849 N 0 39 48 0 0 -39 h\n1 g 1485 3849 N 0 39 49 0 0
      -39 h\n1 g 1436 3849 N 0 39 49 0 0 -39 h\n1 g 1388 3849 N 0 39 48 0 0
      -39 h\n1 g 1339 3849 N 0 39 49 0 0 -39 h\n1 g 1290 3849 N 0 39 49 0 0
      -39 h\n1 g 1242 3849 N 0 39 48 0 0 -39 h\n1 g 1193 3849 N 0 39 49 0 0
      -39 h\n1 g 5957 3810 N 0 38 49 0 0 -38 h\n1 g 5909 3810 N 0 38 48 0 0
      -38 h\n1 g 5860 3810 N 0 38 49 0 0 -38 h\n1 g 5811 3810 N 0 38 49 0 0
      -38 h\n1 g 5763 3810 N 0 38 48 0 0 -38 h\n1 g 5714 3810 N 0 38 49 0 0
      -38 h\n1 g 5665 3810 N 0 38 49 0 0 -38 h\n1 g 5617 3810 N 0 38 48 0 0
      -38 h\n1 g 5568 3810 N 0 38 49 0 0 -38 h\n1 g 5520 3810 N 0 38 48 0 0
      -38 h\n1 g 5471 3810 N 0 38 49 0 0 -38 h\n1 g 5422 3810 N 0 38 49 0 0
      -38 h\n1 g 5374 3810 N 0 38 48 0 0 -38 h\n1 g 5325 3810 N 0 38 49 0 0
      -38 h\n1 g 5277 3810 N 0 38 48 0 0 -38 h\n1 g 5228 3810 N 0 38 49 0 0
      -38 h\n1 g 5179 3810 N 0 38 49 0 0 -38 h\n1 g 5131 3810 N 0 38 48 0 0
      -38 h\n1 g 5082 3810 N 0 38 49 0 0 -38 h\n1 g 5034 3810 N 0 38 48 0 0
      -38 h\n1 g 4985 3810 N 0 38 49 0 0 -38 h\n.9 g 4936 3810 N 0 38 49 0 0
      -38 h\n.8 g 4888 3810 N 0 38 48 0 0 -38 h\n.8 g 4839 3810 N 0 38 49 0 0
      -38 h\n.8 g 4790 3810 N 0 38 49 0 0 -38 h\n.8 g 4742 3810 N 0 38 48 0 0
      -38 h\n.8 g 4693 3810 N 0 38 49 0 0 -38 h\n.8 g 4645 3810 N 0 38 48 0 0
      -38 h\n.8 g 4596 3810 N 0 38 49 0 0 -38 h\n.8 g 4547 3810 N 0 38 49 0 0
      -38 h\n.8 g 4499 3810 N 0 38 48 0 0 -38 h\n.8 g 4450 3810 N 0 38 49 0 0
      -38 h\n.8 g 4402 3810 N 0 38 48 0 0 -38 h\n.8 g 4353 3810 N 0 38 49 0 0
      -38 h\n.8 g 4304 3810 N 0 38 49 0 0 -38 h\n.8 g 4256 3810 N 0 38 48 0 0
      -38 h\n.8 g 4207 3810 N 0 38 49 0 0 -38 h\n.8 g 4159 3810 N 0 38 48 0 0
      -38 h\n.8 g 4110 3810 N 0 38 49 0 0 -38 h\n.8 g 4061 3810 N 0 38 49 0 0
      -38 h\n.8 g 4013 3810 N 0 38 48 0 0 -38 h\n.8 g 3964 3810 N 0 38 49 0 0
      -38 h\n.8 g 3915 3810 N 0 38 49 0 0 -38 h\n.8 g 3867 3810 N 0 38 48 0 0
      -38 h\n.8 g 3818 3810 N 0 38 49 0 0 -38 h\n.8 g 3770 3810 N 0 38 48 0 0
      -38 h\n.8 g 3721 3810 N 0 38 49 0 0 -38 h\n.8 g 3672 3810 N 0 38 49 0 0
      -38 h\n.8 g 3624 3810 N 0 38 48 0 0 -38 h\n.8 g 3575 3810 N 0 38 49 0 0
      -38 h\n.8 g 3527 3810 N 0 38 48 0 0 -38 h\n.8 g 3478 3810 N 0 38 49 0 0
      -38 h\n.8 g 3429 3810 N 0 38 49 0 0 -38 h\n.8 g 3381 3810 N 0 38 48 0 0
      -38 h\n.8 g 3332 3810 N 0 38 49 0 0 -38 h\n.8 g 3284 3810 N 0 38 48 0 0
      -38 h\n.8 g 3235 3810 N 0 38 49 0 0 -38 h\n.8 g 3186 3810 N 0 38 49 0 0
      -38 h\n.8 g 3138 3810 N 0 38 48 0 0 -38 h\n.8 g 3089 3810 N 0 38 49 0 0
      -38 h\n.8 g 3040 3810 N 0 38 49 0 0 -38 h\n.8 g 2992 3810 N 0 38 48 0 0
      -38 h\n.8 g 2943 3810 N 0 38 49 0 0 -38 h\n.8 g 2895 3810 N 0 38 48 0 0
      -38 h\n.8 g 2846 3810 N 0 38 49 0 0 -38 h\n.8 g 2797 3810 N 0 38 49 0 0
      -38 h\n.8 g 2749 3810 N 0 38 48 0 0 -38 h\n.8 g 2700 3810 N 0 38 49 0 0
      -38 h\n.8 g 2652 3810 N 0 38 48 0 0 -38 h\n.8 g 2603 3810 N 0 38 49 0 0
      -38 h\n.8 g 2554 3810 N 0 38 49 0 0 -38 h\n.8 g 2506 3810 N 0 38 48 0 0
      -38 h\n.8 g 2457 3810 N 0 38 49 0 0 -38 h\n.8 g 2409 3810 N 0 38 48 0 0
      -38 h\n.8 g 2360 3810 N 0 38 49 0 0 -38 h\n.8 g 2311 3810 N 0 38 49 0 0
      -38 h\n.8 g 2263 3810 N 0 38 48 0 0 -38 h\n.9 g 2214 3810 N 0 38 49 0 0
      -38 h\n1 g 2165 3810 N 0 38 49 0 0 -38 h\n1 g 2117 3810 N 0 38 48 0 0
      -38 h\n1 g 2068 3810 N 0 38 49 0 0 -38 h\n1 g 2020 3810 N 0 38 48 0 0
      -38 h\n1 g 1971 3810 N 0 38 49 0 0 -38 h\n1 g 1922 3810 N 0 38 49 0 0
      -38 h\n1 g 1874 3810 N 0 38 48 0 0 -38 h\n1 g 1825 3810 N 0 38 49 0 0
      -38 h\n1 g 1777 3810 N 0 38 48 0 0 -38 h\n1 g 1728 3810 N 0 38 49 0 0
      -38 h\n1 g 1679 3810 N 0 38 49 0 0 -38 h\n1 g 1631 3810 N 0 38 48 0 0
      -38 h\n1 g 1582 3810 N 0 38 49 0 0 -38 h\n1 g 1534 3810 N 0 38 48 0 0
      -38 h\n1 g 1485 3810 N 0 38 49 0 0 -38 h\n1 g 1436 3810 N 0 38 49 0 0
      -38 h\n1 g 1388 3810 N 0 38 48 0 0 -38 h\n1 g 1339 3810 N 0 38 49 0 0
      -38 h\n1 g 1290 3810 N 0 38 49 0 0 -38 h\n1 g 1242 3810 N 0 38 48 0 0
      -38 h\n1 g 1193 3810 N 0 38 49 0 0 -38 h\n1 g 5957 3772 N 0 39 49 0 0
      -39 h\n1 g 5909 3772 N 0 39 48 0 0 -39 h\n1 g 5860 3772 N 0 39 49 0 0
      -39 h\n1 g 5811 3772 N 0 39 49 0 0 -39 h\n1 g 5763 3772 N 0 39 48 0 0
      -39 h\n1 g 5714 3772 N 0 39 49 0 0 -39 h\n1 g 5665 3772 N 0 39 49 0 0
      -39 h\n1 g 5617 3772 N 0 39 48 0 0 -39 h\n1 g 5568 3772 N 0 39 49 0 0
      -39 h\n1 g 5520 3772 N 0 39 48 0 0 -39 h\n1 g 5471 3772 N 0 39 49 0 0
      -39 h\n1 g 5422 3772 N 0 39 49 0 0 -39 h\n1 g 5374 3772 N 0 39 48 0 0
      -39 h\n1 g 5325 3772 N 0 39 49 0 0 -39 h\n1 g 5277 3772 N 0 39 48 0 0
      -39 h\n1 g 5228 3772 N 0 39 49 0 0 -39 h\n1 g 5179 3772 N 0 39 49 0 0
      -39 h\n1 g 5131 3772 N 0 39 48 0 0 -39 h\n1 g 5082 3772 N 0 39 49 0 0
      -39 h\n1 g 5034 3772 N 0 39 48 0 0 -39 h\n1 g 4985 3772 N 0 39 49 0 0
      -39 h\n.9 g 4936 3772 N 0 39 49 0 0 -39 h\n.8 g 4888 3772 N 0 39 48 0 0
      -39 h\n.8 g 4839 3772 N 0 39 49 0 0 -39 h\n.8 g 4790 3772 N 0 39 49 0 0
      -39 h\n.8 g 4742 3772 N 0 39 48 0 0 -39 h\n.8 g 4693 3772 N 0 39 49 0 0
      -39 h\n.8 g 4645 3772 N 0 39 48 0 0 -39 h\n.8 g 4596 3772 N 0 39 49 0 0
      -39 h\n.8 g 4547 3772 N 0 39 49 0 0 -39 h\n.8 g 4499 3772 N 0 39 48 0 0
      -39 h\n.8 g 4450 3772 N 0 39 49 0 0 -39 h\n.8 g 4402 3772 N 0 39 48 0 0
      -39 h\n.8 g 4353 3772 N 0 39 49 0 0 -39 h\n.8 g 4304 3772 N 0 39 49 0 0
      -39 h\n.8 g 4256 3772 N 0 39 48 0 0 -39 h\n.8 g 4207 3772 N 0 39 49 0 0
      -39 h\n.8 g 4159 3772 N 0 39 48 0 0 -39 h\n.8 g 4110 3772 N 0 39 49 0 0
      -39 h\n.8 g 4061 3772 N 0 39 49 0 0 -39 h\n.8 g 4013 3772 N 0 39 48 0 0
      -39 h\n.8 g 3964 3772 N 0 39 49 0 0 -39 h\n.8 g 3915 3772 N 0 39 49 0 0
      -39 h\n.8 g 3867 3772 N 0 39 48 0 0 -39 h\n.8 g 3818 3772 N 0 39 49 0 0
      -39 h\n.8 g 3770 3772 N 0 39 48 0 0 -39 h\n.8 g 3721 3772 N 0 39 49 0 0
      -39 h\n.8 g 3672 3772 N 0 39 49 0 0 -39 h\n.8 g 3624 3772 N 0 39 48 0 0
      -39 h\n.8 g 3575 3772 N 0 39 49 0 0 -39 h\n.8 g 3527 3772 N 0 39 48 0 0
      -39 h\n.8 g 3478 3772 N 0 39 49 0 0 -39 h\n.8 g 3429 3772 N 0 39 49 0 0
      -39 h\n.8 g 3381 3772 N 0 39 48 0 0 -39 h\n.8 g 3332 3772 N 0 39 49 0 0
      -39 h\n.8 g 3284 3772 N 0 39 48 0 0 -39 h\n.8 g 3235 3772 N 0 39 49 0 0
      -39 h\n.8 g 3186 3772 N 0 39 49 0 0 -39 h\n.8 g 3138 3772 N 0 39 48 0 0
      -39 h\n.8 g 3089 3772 N 0 39 49 0 0 -39 h\n.8 g 3040 3772 N 0 39 49 0 0
      -39 h\n.8 g 2992 3772 N 0 39 48 0 0 -39 h\n.8 g 2943 3772 N 0 39 49 0 0
      -39 h\n.8 g 2895 3772 N 0 39 48 0 0 -39 h\n.8 g 2846 3772 N 0 39 49 0 0
      -39 h\n.8 g 2797 3772 N 0 39 49 0 0 -39 h\n.8 g 2749 3772 N 0 39 48 0 0
      -39 h\n.8 g 2700 3772 N 0 39 49 0 0 -39 h\n.8 g 2652 3772 N 0 39 48 0 0
      -39 h\n.8 g 2603 3772 N 0 39 49 0 0 -39 h\n.8 g 2554 3772 N 0 39 49 0 0
      -39 h\n.8 g 2506 3772 N 0 39 48 0 0 -39 h\n.8 g 2457 3772 N 0 39 49 0 0
      -39 h\n.8 g 2409 3772 N 0 39 48 0 0 -39 h\n.8 g 2360 3772 N 0 39 49 0 0
      -39 h\n.8 g 2311 3772 N 0 39 49 0 0 -39 h\n.8 g 2263 3772 N 0 39 48 0 0
      -39 h\n.9 g 2214 3772 N 0 39 49 0 0 -39 h\n1 g 2165 3772 N 0 39 49 0 0
      -39 h\n1 g 2117 3772 N 0 39 48 0 0 -39 h\n1 g 2068 3772 N 0 39 49 0 0
      -39 h\n1 g 2020 3772 N 0 39 48 0 0 -39 h\n1 g 1971 3772 N 0 39 49 0 0
      -39 h\n1 g 1922 3772 N 0 39 49 0 0 -39 h\n1 g 1874 3772 N 0 39 48 0 0
      -39 h\n1 g 1825 3772 N 0 39 49 0 0 -39 h\n1 g 1777 3772 N 0 39 48 0 0
      -39 h\n1 g 1728 3772 N 0 39 49 0 0 -39 h\n1 g 1679 3772 N 0 39 49 0 0
      -39 h\n1 g 1631 3772 N 0 39 48 0 0 -39 h\n1 g 1582 3772 N 0 39 49 0 0
      -39 h\n1 g 1534 3772 N 0 39 48 0 0 -39 h\n1 g 1485 3772 N 0 39 49 0 0
      -39 h\n1 g 1436 3772 N 0 39 49 0 0 -39 h\n1 g 1388 3772 N 0 39 48 0 0
      -39 h\n1 g 1339 3772 N 0 39 49 0 0 -39 h\n1 g 1290 3772 N 0 39 49 0 0
      -39 h\n1 g 1242 3772 N 0 39 48 0 0 -39 h\n1 g 1193 3772 N 0 39 49 0 0
      -39 h\n1 g 5957 3733 N 0 39 49 0 0 -39 h\n1 g 5909 3733 N 0 39 48 0 0
      -39 h\n1 g 5860 3733 N 0 39 49 0 0 -39 h\n1 g 5811 3733 N 0 39 49 0 0
      -39 h\n1 g 5763 3733 N 0 39 48 0 0 -39 h\n1 g 5714 3733 N 0 39 49 0 0
      -39 h\n1 g 5665 3733 N 0 39 49 0 0 -39 h\n1 g 5617 3733 N 0 39 48 0 0
      -39 h\n1 g 5568 3733 N 0 39 49 0 0 -39 h\n1 g 5520 3733 N 0 39 48 0 0
      -39 h\n1 g 5471 3733 N 0 39 49 0 0 -39 h\n1 g 5422 3733 N 0 39 49 0 0
      -39 h\n1 g 5374 3733 N 0 39 48 0 0 -39 h\n1 g 5325 3733 N 0 39 49 0 0
      -39 h\n1 g 5277 3733 N 0 39 48 0 0 -39 h\n1 g 5228 3733 N 0 39 49 0 0
      -39 h\n1 g 5179 3733 N 0 39 49 0 0 -39 h\n1 g 5131 3733 N 0 39 48 0 0
      -39 h\n1 g 5082 3733 N 0 39 49 0 0 -39 h\n1 g 5034 3733 N 0 39 48 0 0
      -39 h\n1 g 4985 3733 N 0 39 49 0 0 -39 h\n.9 g 4936 3733 N 0 39 49 0 0
      -39 h\n.8 g 4888 3733 N 0 39 48 0 0 -39 h\n.8 g 4839 3733 N 0 39 49 0 0
      -39 h\n.8 g 4790 3733 N 0 39 49 0 0 -39 h\n.8 g 4742 3733 N 0 39 48 0 0
      -39 h\n.8 g 4693 3733 N 0 39 49 0 0 -39 h\n.8 g 4645 3733 N 0 39 48 0 0
      -39 h\n.8 g 4596 3733 N 0 39 49 0 0 -39 h\n.8 g 4547 3733 N 0 39 49 0 0
      -39 h\n.8 g 4499 3733 N 0 39 48 0 0 -39 h\n.8 g 4450 3733 N 0 39 49 0 0
      -39 h\n.8 g 4402 3733 N 0 39 48 0 0 -39 h\n.8 g 4353 3733 N 0 39 49 0 0
      -39 h\n.8 g 4304 3733 N 0 39 49 0 0 -39 h\n.8 g 4256 3733 N 0 39 48 0 0
      -39 h\n.8 g 4207 3733 N 0 39 49 0 0 -39 h\n.8 g 4159 3733 N 0 39 48 0 0
      -39 h\n.8 g 4110 3733 N 0 39 49 0 0 -39 h\n.8 g 4061 3733 N 0 39 49 0 0
      -39 h\n.8 g 4013 3733 N 0 39 48 0 0 -39 h\n.8 g 3964 3733 N 0 39 49 0 0
      -39 h\n.8 g 3915 3733 N 0 39 49 0 0 -39 h\n.8 g 3867 3733 N 0 39 48 0 0
      -39 h\n.8 g 3818 3733 N 0 39 49 0 0 -39 h\n.8 g 3770 3733 N 0 39 48 0 0
      -39 h\n.8 g 3721 3733 N 0 39 49 0 0 -39 h\n.8 g 3672 3733 N 0 39 49 0 0
      -39 h\n.8 g 3624 3733 N 0 39 48 0 0 -39 h\n.8 g 3575 3733 N 0 39 49 0 0
      -39 h\n.8 g 3527 3733 N 0 39 48 0 0 -39 h\n.8 g 3478 3733 N 0 39 49 0 0
      -39 h\n.8 g 3429 3733 N 0 39 49 0 0 -39 h\n.8 g 3381 3733 N 0 39 48 0 0
      -39 h\n.8 g 3332 3733 N 0 39 49 0 0 -39 h\n.8 g 3284 3733 N 0 39 48 0 0
      -39 h\n.8 g 3235 3733 N 0 39 49 0 0 -39 h\n.8 g 3186 3733 N 0 39 49 0 0
      -39 h\n.8 g 3138 3733 N 0 39 48 0 0 -39 h\n.8 g 3089 3733 N 0 39 49 0 0
      -39 h\n.8 g 3040 3733 N 0 39 49 0 0 -39 h\n.8 g 2992 3733 N 0 39 48 0 0
      -39 h\n.8 g 2943 3733 N 0 39 49 0 0 -39 h\n.8 g 2895 3733 N 0 39 48 0 0
      -39 h\n.8 g 2846 3733 N 0 39 49 0 0 -39 h\n.8 g 2797 3733 N 0 39 49 0 0
      -39 h\n.8 g 2749 3733 N 0 39 48 0 0 -39 h\n.8 g 2700 3733 N 0 39 49 0 0
      -39 h\n.8 g 2652 3733 N 0 39 48 0 0 -39 h\n.8 g 2603 3733 N 0 39 49 0 0
      -39 h\n.8 g 2554 3733 N 0 39 49 0 0 -39 h\n.8 g 2506 3733 N 0 39 48 0 0
      -39 h\n.8 g 2457 3733 N 0 39 49 0 0 -39 h\n.8 g 2409 3733 N 0 39 48 0 0
      -39 h\n.8 g 2360 3733 N 0 39 49 0 0 -39 h\n.8 g 2311 3733 N 0 39 49 0 0
      -39 h\n.8 g 2263 3733 N 0 39 48 0 0 -39 h\n.9 g 2214 3733 N 0 39 49 0 0
      -39 h\n1 g 2165 3733 N 0 39 49 0 0 -39 h\n1 g 2117 3733 N 0 39 48 0 0
      -39 h\n1 g 2068 3733 N 0 39 49 0 0 -39 h\n1 g 2020 3733 N 0 39 48 0 0
      -39 h\n1 g 1971 3733 N 0 39 49 0 0 -39 h\n1 g 1922 3733 N 0 39 49 0 0
      -39 h\n1 g 1874 3733 N 0 39 48 0 0 -39 h\n1 g 1825 3733 N 0 39 49 0 0
      -39 h\n1 g 1777 3733 N 0 39 48 0 0 -39 h\n1 g 1728 3733 N 0 39 49 0 0
      -39 h\n1 g 1679 3733 N 0 39 49 0 0 -39 h\n1 g 1631 3733 N 0 39 48 0 0
      -39 h\n1 g 1582 3733 N 0 39 49 0 0 -39 h\n1 g 1534 3733 N 0 39 48 0 0
      -39 h\n1 g 1485 3733 N 0 39 49 0 0 -39 h\n1 g 1436 3733 N 0 39 49 0 0
      -39 h\n1 g 1388 3733 N 0 39 48 0 0 -39 h\n1 g 1339 3733 N 0 39 49 0 0
      -39 h\n1 g 1290 3733 N 0 39 49 0 0 -39 h\n1 g 1242 3733 N 0 39 48 0 0
      -39 h\n1 g 1193 3733 N 0 39 49 0 0 -39 h\n1 g 5957 3694 N 0 39 49 0 0
      -39 h\n1 g 5909 3694 N 0 39 48 0 0 -39 h\n1 g 5860 3694 N 0 39 49 0 0
      -39 h\n1 g 5811 3694 N 0 39 49 0 0 -39 h\n1 g 5763 3694 N 0 39 48 0 0
      -39 h\n1 g 5714 3694 N 0 39 49 0 0 -39 h\n1 g 5665 3694 N 0 39 49 0 0
      -39 h\n1 g 5617 3694 N 0 39 48 0 0 -39 h\n1 g 5568 3694 N 0 39 49 0 0
      -39 h\n1 g 5520 3694 N 0 39 48 0 0 -39 h\n1 g 5471 3694 N 0 39 49 0 0
      -39 h\n1 g 5422 3694 N 0 39 49 0 0 -39 h\n1 g 5374 3694 N 0 39 48 0 0
      -39 h\n1 g 5325 3694 N 0 39 49 0 0 -39 h\n1 g 5277 3694 N 0 39 48 0 0
      -39 h\n1 g 5228 3694 N 0 39 49 0 0 -39 h\n1 g 5179 3694 N 0 39 49 0 0
      -39 h\n1 g 5131 3694 N 0 39 48 0 0 -39 h\n1 g 5082 3694 N 0 39 49 0 0
      -39 h\n1 g 5034 3694 N 0 39 48 0 0 -39 h\n1 g 4985 3694 N 0 39 49 0 0
      -39 h\n.9 g 4936 3694 N 0 39 49 0 0 -39 h\n.8 g 4888 3694 N 0 39 48 0 0
      -39 h\n.8 g 4839 3694 N 0 39 49 0 0 -39 h\n.8 g 4790 3694 N 0 39 49 0 0
      -39 h\n.8 g 4742 3694 N 0 39 48 0 0 -39 h\n.8 g 4693 3694 N 0 39 49 0 0
      -39 h\n.8 g 4645 3694 N 0 39 48 0 0 -39 h\n.8 g 4596 3694 N 0 39 49 0 0
      -39 h\n.8 g 4547 3694 N 0 39 49 0 0 -39 h\n.8 g 4499 3694 N 0 39 48 0 0
      -39 h\n.8 g 4450 3694 N 0 39 49 0 0 -39 h\n.8 g 4402 3694 N 0 39 48 0 0
      -39 h\n.8 g 4353 3694 N 0 39 49 0 0 -39 h\n.8 g 4304 3694 N 0 39 49 0 0
      -39 h\n.8 g 4256 3694 N 0 39 48 0 0 -39 h\n.8 g 4207 3694 N 0 39 49 0 0
      -39 h\n.8 g 4159 3694 N 0 39 48 0 0 -39 h\n.8 g 4110 3694 N 0 39 49 0 0
      -39 h\n.8 g 4061 3694 N 0 39 49 0 0 -39 h\n.8 g 4013 3694 N 0 39 48 0 0
      -39 h\n.8 g 3964 3694 N 0 39 49 0 0 -39 h\n.8 g 3915 3694 N 0 39 49 0 0
      -39 h\n.8 g 3867 3694 N 0 39 48 0 0 -39 h\n.8 g 3818 3694 N 0 39 49 0 0
      -39 h\n.8 g 3770 3694 N 0 39 48 0 0 -39 h\n.8 g 3721 3694 N 0 39 49 0 0
      -39 h\n.8 g 3672 3694 N 0 39 49 0 0 -39 h\n.8 g 3624 3694 N 0 39 48 0 0
      -39 h\n.8 g 3575 3694 N 0 39 49 0 0 -39 h\n.8 g 3527 3694 N 0 39 48 0 0
      -39 h\n.8 g 3478 3694 N 0 39 49 0 0 -39 h\n.8 g 3429 3694 N 0 39 49 0 0
      -39 h\n.8 g 3381 3694 N 0 39 48 0 0 -39 h\n.8 g 3332 3694 N 0 39 49 0 0
      -39 h\n.8 g 3284 3694 N 0 39 48 0 0 -39 h\n.8 g 3235 3694 N 0 39 49 0 0
      -39 h\n.8 g 3186 3694 N 0 39 49 0 0 -39 h\n.8 g 3138 3694 N 0 39 48 0 0
      -39 h\n.8 g 3089 3694 N 0 39 49 0 0 -39 h\n.8 g 3040 3694 N 0 39 49 0 0
      -39 h\n.8 g 2992 3694 N 0 39 48 0 0 -39 h\n.8 g 2943 3694 N 0 39 49 0 0
      -39 h\n.8 g 2895 3694 N 0 39 48 0 0 -39 h\n.8 g 2846 3694 N 0 39 49 0 0
      -39 h\n.8 g 2797 3694 N 0 39 49 0 0 -39 h\n.8 g 2749 3694 N 0 39 48 0 0
      -39 h\n.8 g 2700 3694 N 0 39 49 0 0 -39 h\n.8 g 2652 3694 N 0 39 48 0 0
      -39 h\n.8 g 2603 3694 N 0 39 49 0 0 -39 h\n.8 g 2554 3694 N 0 39 49 0 0
      -39 h\n.8 g 2506 3694 N 0 39 48 0 0 -39 h\n.8 g 2457 3694 N 0 39 49 0 0
      -39 h\n.8 g 2409 3694 N 0 39 48 0 0 -39 h\n.8 g 2360 3694 N 0 39 49 0 0
      -39 h\n.8 g 2311 3694 N 0 39 49 0 0 -39 h\n.8 g 2263 3694 N 0 39 48 0 0
      -39 h\n.9 g 2214 3694 N 0 39 49 0 0 -39 h\n1 g 2165 3694 N 0 39 49 0 0
      -39 h\n1 g 2117 3694 N 0 39 48 0 0 -39 h\n1 g 2068 3694 N 0 39 49 0 0
      -39 h\n1 g 2020 3694 N 0 39 48 0 0 -39 h\n1 g 1971 3694 N 0 39 49 0 0
      -39 h\n1 g 1922 3694 N 0 39 49 0 0 -39 h\n1 g 1874 3694 N 0 39 48 0 0
      -39 h\n1 g 1825 3694 N 0 39 49 0 0 -39 h\n1 g 1777 3694 N 0 39 48 0 0
      -39 h\n1 g 1728 3694 N 0 39 49 0 0 -39 h\n1 g 1679 3694 N 0 39 49 0 0
      -39 h\n1 g 1631 3694 N 0 39 48 0 0 -39 h\n1 g 1582 3694 N 0 39 49 0 0
      -39 h\n1 g 1534 3694 N 0 39 48 0 0 -39 h\n1 g 1485 3694 N 0 39 49 0 0
      -39 h\n1 g 1436 3694 N 0 39 49 0 0 -39 h\n1 g 1388 3694 N 0 39 48 0 0
      -39 h\n1 g 1339 3694 N 0 39 49 0 0 -39 h\n1 g 1290 3694 N 0 39 49 0 0
      -39 h\n1 g 1242 3694 N 0 39 48 0 0 -39 h\n1 g 1193 3694 N 0 39 49 0 0
      -39 h\n1 g 5957 3655 N 0 38 49 0 0 -38 h\n1 g 5909 3655 N 0 38 48 0 0
      -38 h\n1 g 5860 3655 N 0 38 49 0 0 -38 h\n1 g 5811 3655 N 0 38 49 0 0
      -38 h\n1 g 5763 3655 N 0 38 48 0 0 -38 h\n1 g 5714 3655 N 0 38 49 0 0
      -38 h\n1 g 5665 3655 N 0 38 49 0 0 -38 h\n1 g 5617 3655 N 0 38 48 0 0
      -38 h\n1 g 5568 3655 N 0 38 49 0 0 -38 h\n1 g 5520 3655 N 0 38 48 0 0
      -38 h\n1 g 5471 3655 N 0 38 49 0 0 -38 h\n1 g 5422 3655 N 0 38 49 0 0
      -38 h\n1 g 5374 3655 N 0 38 48 0 0 -38 h\n1 g 5325 3655 N 0 38 49 0 0
      -38 h\n1 g 5277 3655 N 0 38 48 0 0 -38 h\n1 g 5228 3655 N 0 38 49 0 0
      -38 h\n1 g 5179 3655 N 0 38 49 0 0 -38 h\n1 g 5131 3655 N 0 38 48 0 0
      -38 h\n1 g 5082 3655 N 0 38 49 0 0 -38 h\n1 g 5034 3655 N 0 38 48 0 0
      -38 h\n1 g 4985 3655 N 0 38 49 0 0 -38 h\n.95 g 4936 3655 N 0 38 49 0 0
      -38 h\n.85 g 4888 3655 N 0 38 48 0 0 -38 h\n.8 g 4839 3655 N 0 38 49 0
      0 -38 h\n.8 g 4790 3655 N 0 38 49 0 0 -38 h\n.8 g 4742 3655 N 0 38 48 0
      0 -38 h\n.8 g 4693 3655 N 0 38 49 0 0 -38 h\n.8 g 4645 3655 N 0 38 48 0
      0 -38 h\n.8 g 4596 3655 N 0 38 49 0 0 -38 h\n.8 g 4547 3655 N 0 38 49 0
      0 -38 h\n.8 g 4499 3655 N 0 38 48 0 0 -38 h\n.8 g 4450 3655 N 0 38 49 0
      0 -38 h\n.8 g 4402 3655 N 0 38 48 0 0 -38 h\n.8 g 4353 3655 N 0 38 49 0
      0 -38 h\n.8 g 4304 3655 N 0 38 49 0 0 -38 h\n.8 g 4256 3655 N 0 38 48 0
      0 -38 h\n.8 g 4207 3655 N 0 38 49 0 0 -38 h\n.8 g 4159 3655 N 0 38 48 0
      0 -38 h\n.8 g 4110 3655 N 0 38 49 0 0 -38 h\n.8 g 4061 3655 N 0 38 49 0
      0 -38 h\n.8 g 4013 3655 N 0 38 48 0 0 -38 h\n.8 g 3964 3655 N 0 38 49 0
      0 -38 h\n.8 g 3915 3655 N 0 38 49 0 0 -38 h\n.8 g 3867 3655 N 0 38 48 0
      0 -38 h\n.8 g 3818 3655 N 0 38 49 0 0 -38 h\n.8 g 3770 3655 N 0 38 48 0
      0 -38 h\n.8 g 3721 3655 N 0 38 49 0 0 -38 h\n.8 g 3672 3655 N 0 38 49 0
      0 -38 h\n.8 g 3624 3655 N 0 38 48 0 0 -38 h\n.8 g 3575 3655 N 0 38 49 0
      0 -38 h\n.8 g 3527 3655 N 0 38 48 0 0 -38 h\n.8 g 3478 3655 N 0 38 49 0
      0 -38 h\n.8 g 3429 3655 N 0 38 49 0 0 -38 h\n.8 g 3381 3655 N 0 38 48 0
      0 -38 h\n.8 g 3332 3655 N 0 38 49 0 0 -38 h\n.8 g 3284 3655 N 0 38 48 0
      0 -38 h\n.8 g 3235 3655 N 0 38 49 0 0 -38 h\n.8 g 3186 3655 N 0 38 49 0
      0 -38 h\n.8 g 3138 3655 N 0 38 48 0 0 -38 h\n.8 g 3089 3655 N 0 38 49 0
      0 -38 h\n.8 g 3040 3655 N 0 38 49 0 0 -38 h\n.8 g 2992 3655 N 0 38 48 0
      0 -38 h\n.8 g 2943 3655 N 0 38 49 0 0 -38 h\n.8 g 2895 3655 N 0 38 48 0
      0 -38 h\n.8 g 2846 3655 N 0 38 49 0 0 -38 h\n.8 g 2797 3655 N 0 38 49 0
      0 -38 h\n.8 g 2749 3655 N 0 38 48 0 0 -38 h\n.8 g 2700 3655 N 0 38 49 0
      0 -38 h\n.8 g 2652 3655 N 0 38 48 0 0 -38 h\n.8 g 2603 3655 N 0 38 49 0
      0 -38 h\n.8 g 2554 3655 N 0 38 49 0 0 -38 h\n.8 g 2506 3655 N 0 38 48 0
      0 -38 h\n.8 g 2457 3655 N 0 38 49 0 0 -38 h\n.8 g 2409 3655 N 0 38 48 0
      0 -38 h\n.8 g 2360 3655 N 0 38 49 0 0 -38 h\n.8 g 2311 3655 N 0 38 49 0
      0 -38 h\n.85 g 2263 3655 N 0 38 48 0 0 -38 h\n.95 g 2214 3655 N 0 38 49
      0 0 -38 h\n1 g 2165 3655 N 0 38 49 0 0 -38 h\n1 g 2117 3655 N 0 38 48 0
      0 -38 h\n1 g 2068 3655 N 0 38 49 0 0 -38 h\n1 g 2020 3655 N 0 38 48 0 0
      -38 h\n1 g 1971 3655 N 0 38 49 0 0 -38 h\n1 g 1922 3655 N 0 38 49 0 0
      -38 h\n1 g 1874 3655 N 0 38 48 0 0 -38 h\n1 g 1825 3655 N 0 38 49 0 0
      -38 h\n1 g 1777 3655 N 0 38 48 0 0 -38 h\n1 g 1728 3655 N 0 38 49 0 0
      -38 h\n1 g 1679 3655 N 0 38 49 0 0 -38 h\n1 g 1631 3655 N 0 38 48 0 0
      -38 h\n1 g 1582 3655 N 0 38 49 0 0 -38 h\n1 g 1534 3655 N 0 38 48 0 0
      -38 h\n1 g 1485 3655 N 0 38 49 0 0 -38 h\n1 g 1436 3655 N 0 38 49 0 0
      -38 h\n1 g 1388 3655 N 0 38 48 0 0 -38 h\n1 g 1339 3655 N 0 38 49 0 0
      -38 h\n1 g 1290 3655 N 0 38 49 0 0 -38 h\n1 g 1242 3655 N 0 38 48 0 0
      -38 h\n1 g 1193 3655 N 0 38 49 0 0 -38 h\n1 g 5957 3617 N 0 39 49 0 0
      -39 h\n1 g 5909 3617 N 0 39 48 0 0 -39 h\n1 g 5860 3617 N 0 39 49 0 0
      -39 h\n1 g 5811 3617 N 0 39 49 0 0 -39 h\n1 g 5763 3617 N 0 39 48 0 0
      -39 h\n1 g 5714 3617 N 0 39 49 0 0 -39 h\n1 g 5665 3617 N 0 39 49 0 0
      -39 h\n1 g 5617 3617 N 0 39 48 0 0 -39 h\n1 g 5568 3617 N 0 39 49 0 0
      -39 h\n1 g 5520 3617 N 0 39 48 0 0 -39 h\n1 g 5471 3617 N 0 39 49 0 0
      -39 h\n1 g 5422 3617 N 0 39 49 0 0 -39 h\n1 g 5374 3617 N 0 39 48 0 0
      -39 h\n1 g 5325 3617 N 0 39 49 0 0 -39 h\n1 g 5277 3617 N 0 39 48 0 0
      -39 h\n1 g 5228 3617 N 0 39 49 0 0 -39 h\n1 g 5179 3617 N 0 39 49 0 0
      -39 h\n1 g 5131 3617 N 0 39 48 0 0 -39 h\n1 g 5082 3617 N 0 39 49 0 0
      -39 h\n1 g 5034 3617 N 0 39 48 0 0 -39 h\n1 g 4985 3617 N 0 39 49 0 0
      -39 h\n1 g 4936 3617 N 0 39 49 0 0 -39 h\n.9 g 4888 3617 N 0 39 48 0 0
      -39 h\n.8 g 4839 3617 N 0 39 49 0 0 -39 h\n.8 g 4790 3617 N 0 39 49 0 0
      -39 h\n.8 g 4742 3617 N 0 39 48 0 0 -39 h\n.8 g 4693 3617 N 0 39 49 0 0
      -39 h\n.8 g 4645 3617 N 0 39 48 0 0 -39 h\n.8 g 4596 3617 N 0 39 49 0 0
      -39 h\n.8 g 4547 3617 N 0 39 49 0 0 -39 h\n.8 g 4499 3617 N 0 39 48 0 0
      -39 h\n.8 g 4450 3617 N 0 39 49 0 0 -39 h\n.8 g 4402 3617 N 0 39 48 0 0
      -39 h\n.8 g 4353 3617 N 0 39 49 0 0 -39 h\n.8 g 4304 3617 N 0 39 49 0 0
      -39 h\n.8 g 4256 3617 N 0 39 48 0 0 -39 h\n.8 g 4207 3617 N 0 39 49 0 0
      -39 h\n.8 g 4159 3617 N 0 39 48 0 0 -39 h\n.8 g 4110 3617 N 0 39 49 0 0
      -39 h\n.8 g 4061 3617 N 0 39 49 0 0 -39 h\n.8 g 4013 3617 N 0 39 48 0 0
      -39 h\n.8 g 3964 3617 N 0 39 49 0 0 -39 h\n.8 g 3915 3617 N 0 39 49 0 0
      -39 h\n.8 g 3867 3617 N 0 39 48 0 0 -39 h\n.8 g 3818 3617 N 0 39 49 0 0
      -39 h\n.8 g 3770 3617 N 0 39 48 0 0 -39 h\n.8 g 3721 3617 N 0 39 49 0 0
      -39 h\n.8 g 3672 3617 N 0 39 49 0 0 -39 h\n.8 g 3624 3617 N 0 39 48 0 0
      -39 h\n.8 g 3575 3617 N 0 39 49 0 0 -39 h\n.8 g 3527 3617 N 0 39 48 0 0
      -39 h\n.8 g 3478 3617 N 0 39 49 0 0 -39 h\n.8 g 3429 3617 N 0 39 49 0 0
      -39 h\n.8 g 3381 3617 N 0 39 48 0 0 -39 h\n.8 g 3332 3617 N 0 39 49 0 0
      -39 h\n.8 g 3284 3617 N 0 39 48 0 0 -39 h\n.8 g 3235 3617 N 0 39 49 0 0
      -39 h\n.8 g 3186 3617 N 0 39 49 0 0 -39 h\n.8 g 3138 3617 N 0 39 48 0 0
      -39 h\n.8 g 3089 3617 N 0 39 49 0 0 -39 h\n.8 g 3040 3617 N 0 39 49 0 0
      -39 h\n.8 g 2992 3617 N 0 39 48 0 0 -39 h\n.8 g 2943 3617 N 0 39 49 0 0
      -39 h\n.8 g 2895 3617 N 0 39 48 0 0 -39 h\n.8 g 2846 3617 N 0 39 49 0 0
      -39 h\n.8 g 2797 3617 N 0 39 49 0 0 -39 h\n.8 g 2749 3617 N 0 39 48 0 0
      -39 h\n.8 g 2700 3617 N 0 39 49 0 0 -39 h\n.8 g 2652 3617 N 0 39 48 0 0
      -39 h\n.8 g 2603 3617 N 0 39 49 0 0 -39 h\n.8 g 2554 3617 N 0 39 49 0 0
      -39 h\n.8 g 2506 3617 N 0 39 48 0 0 -39 h\n.8 g 2457 3617 N 0 39 49 0 0
      -39 h\n.8 g 2409 3617 N 0 39 48 0 0 -39 h\n.8 g 2360 3617 N 0 39 49 0 0
      -39 h\n.8 g 2311 3617 N 0 39 49 0 0 -39 h\n.9 g 2263 3617 N 0 39 48 0 0
      -39 h\n1 g 2214 3617 N 0 39 49 0 0 -39 h\n1 g 2165 3617 N 0 39 49 0 0
      -39 h\n1 g 2117 3617 N 0 39 48 0 0 -39 h\n1 g 2068 3617 N 0 39 49 0 0
      -39 h\n1 g 2020 3617 N 0 39 48 0 0 -39 h\n1 g 1971 3617 N 0 39 49 0 0
      -39 h\n1 g 1922 3617 N 0 39 49 0 0 -39 h\n1 g 1874 3617 N 0 39 48 0 0
      -39 h\n1 g 1825 3617 N 0 39 49 0 0 -39 h\n1 g 1777 3617 N 0 39 48 0 0
      -39 h\n1 g 1728 3617 N 0 39 49 0 0 -39 h\n1 g 1679 3617 N 0 39 49 0 0
      -39 h\n1 g 1631 3617 N 0 39 48 0 0 -39 h\n1 g 1582 3617 N 0 39 49 0 0
      -39 h\n1 g 1534 3617 N 0 39 48 0 0 -39 h\n1 g 1485 3617 N 0 39 49 0 0
      -39 h\n1 g 1436 3617 N 0 39 49 0 0 -39 h\n1 g 1388 3617 N 0 39 48 0 0
      -39 h\n1 g 1339 3617 N 0 39 49 0 0 -39 h\n1 g 1290 3617 N 0 39 49 0 0
      -39 h\n1 g 1242 3617 N 0 39 48 0 0 -39 h\n1 g 1193 3617 N 0 39 49 0 0
      -39 h\n1 g 5957 3578 N 0 39 49 0 0 -39 h\n1 g 5909 3578 N 0 39 48 0 0
      -39 h\n1 g 5860 3578 N 0 39 49 0 0 -39 h\n1 g 5811 3578 N 0 39 49 0 0
      -39 h\n1 g 5763 3578 N 0 39 48 0 0 -39 h\n1 g 5714 3578 N 0 39 49 0 0
      -39 h\n1 g 5665 3578 N 0 39 49 0 0 -39 h\n1 g 5617 3578 N 0 39 48 0 0
      -39 h\n1 g 5568 3578 N 0 39 49 0 0 -39 h\n1 g 5520 3578 N 0 39 48 0 0
      -39 h\n1 g 5471 3578 N 0 39 49 0 0 -39 h\n1 g 5422 3578 N 0 39 49 0 0
      -39 h\n1 g 5374 3578 N 0 39 48 0 0 -39 h\n1 g 5325 3578 N 0 39 49 0 0
      -39 h\n1 g 5277 3578 N 0 39 48 0 0 -39 h\n1 g 5228 3578 N 0 39 49 0 0
      -39 h\n1 g 5179 3578 N 0 39 49 0 0 -39 h\n1 g 5131 3578 N 0 39 48 0 0
      -39 h\n1 g 5082 3578 N 0 39 49 0 0 -39 h\n1 g 5034 3578 N 0 39 48 0 0
      -39 h\n1 g 4985 3578 N 0 39 49 0 0 -39 h\n1 g 4936 3578 N 0 39 49 0 0
      -39 h\n.9 g 4888 3578 N 0 39 48 0 0 -39 h\n.8 g 4839 3578 N 0 39 49 0 0
      -39 h\n.8 g 4790 3578 N 0 39 49 0 0 -39 h\n.8 g 4742 3578 N 0 39 48 0 0
      -39 h\n.8 g 4693 3578 N 0 39 49 0 0 -39 h\n.8 g 4645 3578 N 0 39 48 0 0
      -39 h\n.8 g 4596 3578 N 0 39 49 0 0 -39 h\n.8 g 4547 3578 N 0 39 49 0 0
      -39 h\n.8 g 4499 3578 N 0 39 48 0 0 -39 h\n.8 g 4450 3578 N 0 39 49 0 0
      -39 h\n.8 g 4402 3578 N 0 39 48 0 0 -39 h\n.8 g 4353 3578 N 0 39 49 0 0
      -39 h\n.8 g 4304 3578 N 0 39 49 0 0 -39 h\n.8 g 4256 3578 N 0 39 48 0 0
      -39 h\n.8 g 4207 3578 N 0 39 49 0 0 -39 h\n.8 g 4159 3578 N 0 39 48 0 0
      -39 h\n.8 g 4110 3578 N 0 39 49 0 0 -39 h\n.8 g 4061 3578 N 0 39 49 0 0
      -39 h\n.8 g 4013 3578 N 0 39 48 0 0 -39 h\n.8 g 3964 3578 N 0 39 49 0 0
      -39 h\n.8 g 3915 3578 N 0 39 49 0 0 -39 h\n.8 g 3867 3578 N 0 39 48 0 0
      -39 h\n.8 g 3818 3578 N 0 39 49 0 0 -39 h\n.8 g 3770 3578 N 0 39 48 0 0
      -39 h\n.8 g 3721 3578 N 0 39 49 0 0 -39 h\n.8 g 3672 3578 N 0 39 49 0 0
      -39 h\n.8 g 3624 3578 N 0 39 48 0 0 -39 h\n.8 g 3575 3578 N 0 39 49 0 0
      -39 h\n.8 g 3527 3578 N 0 39 48 0 0 -39 h\n.8 g 3478 3578 N 0 39 49 0 0
      -39 h\n.8 g 3429 3578 N 0 39 49 0 0 -39 h\n.8 g 3381 3578 N 0 39 48 0 0
      -39 h\n.8 g 3332 3578 N 0 39 49 0 0 -39 h\n.8 g 3284 3578 N 0 39 48 0 0
      -39 h\n.8 g 3235 3578 N 0 39 49 0 0 -39 h\n.8 g 3186 3578 N 0 39 49 0 0
      -39 h\n.8 g 3138 3578 N 0 39 48 0 0 -39 h\n.8 g 3089 3578 N 0 39 49 0 0
      -39 h\n.8 g 3040 3578 N 0 39 49 0 0 -39 h\n.8 g 2992 3578 N 0 39 48 0 0
      -39 h\n.8 g 2943 3578 N 0 39 49 0 0 -39 h\n.8 g 2895 3578 N 0 39 48 0 0
      -39 h\n.8 g 2846 3578 N 0 39 49 0 0 -39 h\n.8 g 2797 3578 N 0 39 49 0 0
      -39 h\n.8 g 2749 3578 N 0 39 48 0 0 -39 h\n.8 g 2700 3578 N 0 39 49 0 0
      -39 h\n.8 g 2652 3578 N 0 39 48 0 0 -39 h\n.8 g 2603 3578 N 0 39 49 0 0
      -39 h\n.8 g 2554 3578 N 0 39 49 0 0 -39 h\n.8 g 2506 3578 N 0 39 48 0 0
      -39 h\n.8 g 2457 3578 N 0 39 49 0 0 -39 h\n.8 g 2409 3578 N 0 39 48 0 0
      -39 h\n.8 g 2360 3578 N 0 39 49 0 0 -39 h\n.8 g 2311 3578 N 0 39 49 0 0
      -39 h\n.9 g 2263 3578 N 0 39 48 0 0 -39 h\n1 g 2214 3578 N 0 39 49 0 0
      -39 h\n1 g 2165 3578 N 0 39 49 0 0 -39 h\n1 g 2117 3578 N 0 39 48 0 0
      -39 h\n1 g 2068 3578 N 0 39 49 0 0 -39 h\n1 g 2020 3578 N 0 39 48 0 0
      -39 h\n1 g 1971 3578 N 0 39 49 0 0 -39 h\n1 g 1922 3578 N 0 39 49 0 0
      -39 h\n1 g 1874 3578 N 0 39 48 0 0 -39 h\n1 g 1825 3578 N 0 39 49 0 0
      -39 h\n1 g 1777 3578 N 0 39 48 0 0 -39 h\n1 g 1728 3578 N 0 39 49 0 0
      -39 h\n1 g 1679 3578 N 0 39 49 0 0 -39 h\n1 g 1631 3578 N 0 39 48 0 0
      -39 h\n1 g 1582 3578 N 0 39 49 0 0 -39 h\n1 g 1534 3578 N 0 39 48 0 0
      -39 h\n1 g 1485 3578 N 0 39 49 0 0 -39 h\n1 g 1436 3578 N 0 39 49 0 0
      -39 h\n1 g 1388 3578 N 0 39 48 0 0 -39 h\n1 g 1339 3578 N 0 39 49 0 0
      -39 h\n1 g 1290 3578 N 0 39 49 0 0 -39 h\n1 g 1242 3578 N 0 39 48 0 0
      -39 h\n1 g 1193 3578 N 0 39 49 0 0 -39 h\n1 g 5957 3539 N 0 39 49 0 0
      -39 h\n1 g 5909 3539 N 0 39 48 0 0 -39 h\n1 g 5860 3539 N 0 39 49 0 0
      -39 h\n1 g 5811 3539 N 0 39 49 0 0 -39 h\n1 g 5763 3539 N 0 39 48 0 0
      -39 h\n1 g 5714 3539 N 0 39 49 0 0 -39 h\n1 g 5665 3539 N 0 39 49 0 0
      -39 h\n1 g 5617 3539 N 0 39 48 0 0 -39 h\n1 g 5568 3539 N 0 39 49 0 0
      -39 h\n1 g 5520 3539 N 0 39 48 0 0 -39 h\n1 g 5471 3539 N 0 39 49 0 0
      -39 h\n1 g 5422 3539 N 0 39 49 0 0 -39 h\n1 g 5374 3539 N 0 39 48 0 0
      -39 h\n1 g 5325 3539 N 0 39 49 0 0 -39 h\n1 g 5277 3539 N 0 39 48 0 0
      -39 h\n1 g 5228 3539 N 0 39 49 0 0 -39 h\n1 g 5179 3539 N 0 39 49 0 0
      -39 h\n1 g 5131 3539 N 0 39 48 0 0 -39 h\n1 g 5082 3539 N 0 39 49 0 0
      -39 h\n1 g 5034 3539 N 0 39 48 0 0 -39 h\n1 g 4985 3539 N 0 39 49 0 0
      -39 h\n1 g 4936 3539 N 0 39 49 0 0 -39 h\n.9 g 4888 3539 N 0 39 48 0 0
      -39 h\n.8 g 4839 3539 N 0 39 49 0 0 -39 h\n.8 g 4790 3539 N 0 39 49 0 0
      -39 h\n.8 g 4742 3539 N 0 39 48 0 0 -39 h\n.8 g 4693 3539 N 0 39 49 0 0
      -39 h\n.8 g 4645 3539 N 0 39 48 0 0 -39 h\n.8 g 4596 3539 N 0 39 49 0 0
      -39 h\n.8 g 4547 3539 N 0 39 49 0 0 -39 h\n.8 g 4499 3539 N 0 39 48 0 0
      -39 h\n.8 g 4450 3539 N 0 39 49 0 0 -39 h\n.8 g 4402 3539 N 0 39 48 0 0
      -39 h\n.8 g 4353 3539 N 0 39 49 0 0 -39 h\n.8 g 4304 3539 N 0 39 49 0 0
      -39 h\n.8 g 4256 3539 N 0 39 48 0 0 -39 h\n.8 g 4207 3539 N 0 39 49 0 0
      -39 h\n.8 g 4159 3539 N 0 39 48 0 0 -39 h\n.8 g 4110 3539 N 0 39 49 0 0
      -39 h\n.8 g 4061 3539 N 0 39 49 0 0 -39 h\n.8 g 4013 3539 N 0 39 48 0 0
      -39 h\n.8 g 3964 3539 N 0 39 49 0 0 -39 h\n.8 g 3915 3539 N 0 39 49 0 0
      -39 h\n.8 g 3867 3539 N 0 39 48 0 0 -39 h\n.8 g 3818 3539 N 0 39 49 0 0
      -39 h\n.8 g 3770 3539 N 0 39 48 0 0 -39 h\n.8 g 3721 3539 N 0 39 49 0 0
      -39 h\n.8 g 3672 3539 N 0 39 49 0 0 -39 h\n.8 g 3624 3539 N 0 39 48 0 0
      -39 h\n.8 g 3575 3539 N 0 39 49 0 0 -39 h\n.8 g 3527 3539 N 0 39 48 0 0
      -39 h\n.8 g 3478 3539 N 0 39 49 0 0 -39 h\n.8 g 3429 3539 N 0 39 49 0 0
      -39 h\n.8 g 3381 3539 N 0 39 48 0 0 -39 h\n.8 g 3332 3539 N 0 39 49 0 0
      -39 h\n.8 g 3284 3539 N 0 39 48 0 0 -39 h\n.8 g 3235 3539 N 0 39 49 0 0
      -39 h\n.8 g 3186 3539 N 0 39 49 0 0 -39 h\n.8 g 3138 3539 N 0 39 48 0 0
      -39 h\n.8 g 3089 3539 N 0 39 49 0 0 -39 h\n.8 g 3040 3539 N 0 39 49 0 0
      -39 h\n.8 g 2992 3539 N 0 39 48 0 0 -39 h\n.8 g 2943 3539 N 0 39 49 0 0
      -39 h\n.8 g 2895 3539 N 0 39 48 0 0 -39 h\n.8 g 2846 3539 N 0 39 49 0 0
      -39 h\n.8 g 2797 3539 N 0 39 49 0 0 -39 h\n.8 g 2749 3539 N 0 39 48 0 0
      -39 h\n.8 g 2700 3539 N 0 39 49 0 0 -39 h\n.8 g 2652 3539 N 0 39 48 0 0
      -39 h\n.8 g 2603 3539 N 0 39 49 0 0 -39 h\n.8 g 2554 3539 N 0 39 49 0 0
      -39 h\n.8 g 2506 3539 N 0 39 48 0 0 -39 h\n.8 g 2457 3539 N 0 39 49 0 0
      -39 h\n.8 g 2409 3539 N 0 39 48 0 0 -39 h\n.8 g 2360 3539 N 0 39 49 0 0
      -39 h\n.8 g 2311 3539 N 0 39 49 0 0 -39 h\n.9 g 2263 3539 N 0 39 48 0 0
      -39 h\n1 g 2214 3539 N 0 39 49 0 0 -39 h\n1 g 2165 3539 N 0 39 49 0 0
      -39 h\n1 g 2117 3539 N 0 39 48 0 0 -39 h\n1 g 2068 3539 N 0 39 49 0 0
      -39 h\n1 g 2020 3539 N 0 39 48 0 0 -39 h\n1 g 1971 3539 N 0 39 49 0 0
      -39 h\n1 g 1922 3539 N 0 39 49 0 0 -39 h\n1 g 1874 3539 N 0 39 48 0 0
      -39 h\n1 g 1825 3539 N 0 39 49 0 0 -39 h\n1 g 1777 3539 N 0 39 48 0 0
      -39 h\n1 g 1728 3539 N 0 39 49 0 0 -39 h\n1 g 1679 3539 N 0 39 49 0 0
      -39 h\n1 g 1631 3539 N 0 39 48 0 0 -39 h\n1 g 1582 3539 N 0 39 49 0 0
      -39 h\n1 g 1534 3539 N 0 39 48 0 0 -39 h\n1 g 1485 3539 N 0 39 49 0 0
      -39 h\n1 g 1436 3539 N 0 39 49 0 0 -39 h\n1 g 1388 3539 N 0 39 48 0 0
      -39 h\n1 g 1339 3539 N 0 39 49 0 0 -39 h\n1 g 1290 3539 N 0 39 49 0 0
      -39 h\n1 g 1242 3539 N 0 39 48 0 0 -39 h\n1 g 1193 3539 N 0 39 49 0 0
      -39 h\n1 g 5957 3500 N 0 38 49 0 0 -38 h\n1 g 5909 3500 N 0 38 48 0 0
      -38 h\n1 g 5860 3500 N 0 38 49 0 0 -38 h\n1 g 5811 3500 N 0 38 49 0 0
      -38 h\n1 g 5763 3500 N 0 38 48 0 0 -38 h\n1 g 5714 3500 N 0 38 49 0 0
      -38 h\n1 g 5665 3500 N 0 38 49 0 0 -38 h\n1 g 5617 3500 N 0 38 48 0 0
      -38 h\n1 g 5568 3500 N 0 38 49 0 0 -38 h\n1 g 5520 3500 N 0 38 48 0 0
      -38 h\n1 g 5471 3500 N 0 38 49 0 0 -38 h\n1 g 5422 3500 N 0 38 49 0 0
      -38 h\n1 g 5374 3500 N 0 38 48 0 0 -38 h\n1 g 5325 3500 N 0 38 49 0 0
      -38 h\n1 g 5277 3500 N 0 38 48 0 0 -38 h\n1 g 5228 3500 N 0 38 49 0 0
      -38 h\n1 g 5179 3500 N 0 38 49 0 0 -38 h\n1 g 5131 3500 N 0 38 48 0 0
      -38 h\n1 g 5082 3500 N 0 38 49 0 0 -38 h\n1 g 5034 3500 N 0 38 48 0 0
      -38 h\n1 g 4985 3500 N 0 38 49 0 0 -38 h\n1 g 4936 3500 N 0 38 49 0 0
      -38 h\n.9 g 4888 3500 N 0 38 48 0 0 -38 h\n.8 g 4839 3500 N 0 38 49 0 0
      -38 h\n.8 g 4790 3500 N 0 38 49 0 0 -38 h\n.8 g 4742 3500 N 0 38 48 0 0
      -38 h\n.8 g 4693 3500 N 0 38 49 0 0 -38 h\n.8 g 4645 3500 N 0 38 48 0 0
      -38 h\n.8 g 4596 3500 N 0 38 49 0 0 -38 h\n.8 g 4547 3500 N 0 38 49 0 0
      -38 h\n.8 g 4499 3500 N 0 38 48 0 0 -38 h\n.8 g 4450 3500 N 0 38 49 0 0
      -38 h\n.8 g 4402 3500 N 0 38 48 0 0 -38 h\n.8 g 4353 3500 N 0 38 49 0 0
      -38 h\n.8 g 4304 3500 N 0 38 49 0 0 -38 h\n.8 g 4256 3500 N 0 38 48 0 0
      -38 h\n.8 g 4207 3500 N 0 38 49 0 0 -38 h\n.8 g 4159 3500 N 0 38 48 0 0
      -38 h\n.8 g 4110 3500 N 0 38 49 0 0 -38 h\n.8 g 4061 3500 N 0 38 49 0 0
      -38 h\n.8 g 4013 3500 N 0 38 48 0 0 -38 h\n.8 g 3964 3500 N 0 38 49 0 0
      -38 h\n.8 g 3915 3500 N 0 38 49 0 0 -38 h\n.8 g 3867 3500 N 0 38 48 0 0
      -38 h\n.8 g 3818 3500 N 0 38 49 0 0 -38 h\n.8 g 3770 3500 N 0 38 48 0 0
      -38 h\n.8 g 3721 3500 N 0 38 49 0 0 -38 h\n.8 g 3672 3500 N 0 38 49 0 0
      -38 h\n.8 g 3624 3500 N 0 38 48 0 0 -38 h\n.8 g 3575 3500 N 0 38 49 0 0
      -38 h\n.8 g 3527 3500 N 0 38 48 0 0 -38 h\n.8 g 3478 3500 N 0 38 49 0 0
      -38 h\n.8 g 3429 3500 N 0 38 49 0 0 -38 h\n.8 g 3381 3500 N 0 38 48 0 0
      -38 h\n.8 g 3332 3500 N 0 38 49 0 0 -38 h\n.8 g 3284 3500 N 0 38 48 0 0
      -38 h\n.8 g 3235 3500 N 0 38 49 0 0 -38 h\n.8 g 3186 3500 N 0 38 49 0 0
      -38 h\n.8 g 3138 3500 N 0 38 48 0 0 -38 h\n.8 g 3089 3500 N 0 38 49 0 0
      -38 h\n.8 g 3040 3500 N 0 38 49 0 0 -38 h\n.8 g 2992 3500 N 0 38 48 0 0
      -38 h\n.8 g 2943 3500 N 0 38 49 0 0 -38 h\n.8 g 2895 3500 N 0 38 48 0 0
      -38 h\n.8 g 2846 3500 N 0 38 49 0 0 -38 h\n.8 g 2797 3500 N 0 38 49 0 0
      -38 h\n.8 g 2749 3500 N 0 38 48 0 0 -38 h\n.8 g 2700 3500 N 0 38 49 0 0
      -38 h\n.8 g 2652 3500 N 0 38 48 0 0 -38 h\n.8 g 2603 3500 N 0 38 49 0 0
      -38 h\n.8 g 2554 3500 N 0 38 49 0 0 -38 h\n.8 g 2506 3500 N 0 38 48 0 0
      -38 h\n.8 g 2457 3500 N 0 38 49 0 0 -38 h\n.8 g 2409 3500 N 0 38 48 0 0
      -38 h\n.8 g 2360 3500 N 0 38 49 0 0 -38 h\n.8 g 2311 3500 N 0 38 49 0 0
      -38 h\n.9 g 2263 3500 N 0 38 48 0 0 -38 h\n1 g 2214 3500 N 0 38 49 0 0
      -38 h\n1 g 2165 3500 N 0 38 49 0 0 -38 h\n1 g 2117 3500 N 0 38 48 0 0
      -38 h\n1 g 2068 3500 N 0 38 49 0 0 -38 h\n1 g 2020 3500 N 0 38 48 0 0
      -38 h\n1 g 1971 3500 N 0 38 49 0 0 -38 h\n1 g 1922 3500 N 0 38 49 0 0
      -38 h\n1 g 1874 3500 N 0 38 48 0 0 -38 h\n1 g 1825 3500 N 0 38 49 0 0
      -38 h\n1 g 1777 3500 N 0 38 48 0 0 -38 h\n1 g 1728 3500 N 0 38 49 0 0
      -38 h\n1 g 1679 3500 N 0 38 49 0 0 -38 h\n1 g 1631 3500 N 0 38 48 0 0
      -38 h\n1 g 1582 3500 N 0 38 49 0 0 -38 h\n1 g 1534 3500 N 0 38 48 0 0
      -38 h\n1 g 1485 3500 N 0 38 49 0 0 -38 h\n1 g 1436 3500 N 0 38 49 0 0
      -38 h\n1 g 1388 3500 N 0 38 48 0 0 -38 h\n1 g 1339 3500 N 0 38 49 0 0
      -38 h\n1 g 1290 3500 N 0 38 49 0 0 -38 h\n1 g 1242 3500 N 0 38 48 0 0
      -38 h\n1 g 1193 3500 N 0 38 49 0 0 -38 h\n1 g 5957 3462 N 0 39 49 0 0
      -39 h\n1 g 5909 3462 N 0 39 48 0 0 -39 h\n1 g 5860 3462 N 0 39 49 0 0
      -39 h\n1 g 5811 3462 N 0 39 49 0 0 -39 h\n1 g 5763 3462 N 0 39 48 0 0
      -39 h\n1 g 5714 3462 N 0 39 49 0 0 -39 h\n1 g 5665 3462 N 0 39 49 0 0
      -39 h\n1 g 5617 3462 N 0 39 48 0 0 -39 h\n1 g 5568 3462 N 0 39 49 0 0
      -39 h\n1 g 5520 3462 N 0 39 48 0 0 -39 h\n1 g 5471 3462 N 0 39 49 0 0
      -39 h\n1 g 5422 3462 N 0 39 49 0 0 -39 h\n1 g 5374 3462 N 0 39 48 0 0
      -39 h\n1 g 5325 3462 N 0 39 49 0 0 -39 h\n1 g 5277 3462 N 0 39 48 0 0
      -39 h\n1 g 5228 3462 N 0 39 49 0 0 -39 h\n1 g 5179 3462 N 0 39 49 0 0
      -39 h\n1 g 5131 3462 N 0 39 48 0 0 -39 h\n1 g 5082 3462 N 0 39 49 0 0
      -39 h\n1 g 5034 3462 N 0 39 48 0 0 -39 h\n1 g 4985 3462 N 0 39 49 0 0
      -39 h\n1 g 4936 3462 N 0 39 49 0 0 -39 h\n.9 g 4888 3462 N 0 39 48 0 0
      -39 h\n.8 g 4839 3462 N 0 39 49 0 0 -39 h\n.8 g 4790 3462 N 0 39 49 0 0
      -39 h\n.8 g 4742 3462 N 0 39 48 0 0 -39 h\n.8 g 4693 3462 N 0 39 49 0 0
      -39 h\n.8 g 4645 3462 N 0 39 48 0 0 -39 h\n.8 g 4596 3462 N 0 39 49 0 0
      -39 h\n.8 g 4547 3462 N 0 39 49 0 0 -39 h\n.8 g 4499 3462 N 0 39 48 0 0
      -39 h\n.8 g 4450 3462 N 0 39 49 0 0 -39 h\n.8 g 4402 3462 N 0 39 48 0 0
      -39 h\n.8 g 4353 3462 N 0 39 49 0 0 -39 h\n.8 g 4304 3462 N 0 39 49 0 0
      -39 h\n.8 g 4256 3462 N 0 39 48 0 0 -39 h\n.8 g 4207 3462 N 0 39 49 0 0
      -39 h\n.8 g 4159 3462 N 0 39 48 0 0 -39 h\n.8 g 4110 3462 N 0 39 49 0 0
      -39 h\n.8 g 4061 3462 N 0 39 49 0 0 -39 h\n.8 g 4013 3462 N 0 39 48 0 0
      -39 h\n.8 g 3964 3462 N 0 39 49 0 0 -39 h\n.8 g 3915 3462 N 0 39 49 0 0
      -39 h\n.8 g 3867 3462 N 0 39 48 0 0 -39 h\n.8 g 3818 3462 N 0 39 49 0 0
      -39 h\n.8 g 3770 3462 N 0 39 48 0 0 -39 h\n.8 g 3721 3462 N 0 39 49 0 0
      -39 h\n.8 g 3672 3462 N 0 39 49 0 0 -39 h\n.8 g 3624 3462 N 0 39 48 0 0
      -39 h\n.8 g 3575 3462 N 0 39 49 0 0 -39 h\n.8 g 3527 3462 N 0 39 48 0 0
      -39 h\n.8 g 3478 3462 N 0 39 49 0 0 -39 h\n.8 g 3429 3462 N 0 39 49 0 0
      -39 h\n.8 g 3381 3462 N 0 39 48 0 0 -39 h\n.8 g 3332 3462 N 0 39 49 0 0
      -39 h\n.8 g 3284 3462 N 0 39 48 0 0 -39 h\n.8 g 3235 3462 N 0 39 49 0 0
      -39 h\n.8 g 3186 3462 N 0 39 49 0 0 -39 h\n.8 g 3138 3462 N 0 39 48 0 0
      -39 h\n.8 g 3089 3462 N 0 39 49 0 0 -39 h\n.8 g 3040 3462 N 0 39 49 0 0
      -39 h\n.8 g 2992 3462 N 0 39 48 0 0 -39 h\n.8 g 2943 3462 N 0 39 49 0 0
      -39 h\n.8 g 2895 3462 N 0 39 48 0 0 -39 h\n.8 g 2846 3462 N 0 39 49 0 0
      -39 h\n.8 g 2797 3462 N 0 39 49 0 0 -39 h\n.8 g 2749 3462 N 0 39 48 0 0
      -39 h\n.8 g 2700 3462 N 0 39 49 0 0 -39 h\n.8 g 2652 3462 N 0 39 48 0 0
      -39 h\n.8 g 2603 3462 N 0 39 49 0 0 -39 h\n.8 g 2554 3462 N 0 39 49 0 0
      -39 h\n.8 g 2506 3462 N 0 39 48 0 0 -39 h\n.8 g 2457 3462 N 0 39 49 0 0
      -39 h\n.8 g 2409 3462 N 0 39 48 0 0 -39 h\n.8 g 2360 3462 N 0 39 49 0 0
      -39 h\n.8 g 2311 3462 N 0 39 49 0 0 -39 h\n.9 g 2263 3462 N 0 39 48 0 0
      -39 h\n1 g 2214 3462 N 0 39 49 0 0 -39 h\n1 g 2165 3462 N 0 39 49 0 0
      -39 h\n1 g 2117 3462 N 0 39 48 0 0 -39 h\n1 g 2068 3462 N 0 39 49 0 0
      -39 h\n1 g 2020 3462 N 0 39 48 0 0 -39 h\n1 g 1971 3462 N 0 39 49 0 0
      -39 h\n1 g 1922 3462 N 0 39 49 0 0 -39 h\n1 g 1874 3462 N 0 39 48 0 0
      -39 h\n1 g 1825 3462 N 0 39 49 0 0 -39 h\n1 g 1777 3462 N 0 39 48 0 0
      -39 h\n1 g 1728 3462 N 0 39 49 0 0 -39 h\n1 g 1679 3462 N 0 39 49 0 0
      -39 h\n1 g 1631 3462 N 0 39 48 0 0 -39 h\n1 g 1582 3462 N 0 39 49 0 0
      -39 h\n1 g 1534 3462 N 0 39 48 0 0 -39 h\n1 g 1485 3462 N 0 39 49 0 0
      -39 h\n1 g 1436 3462 N 0 39 49 0 0 -39 h\n1 g 1388 3462 N 0 39 48 0 0
      -39 h\n1 g 1339 3462 N 0 39 49 0 0 -39 h\n1 g 1290 3462 N 0 39 49 0 0
      -39 h\n1 g 1242 3462 N 0 39 48 0 0 -39 h\n1 g 1193 3462 N 0 39 49 0 0
      -39 h\n1 g 5957 3423 N 0 39 49 0 0 -39 h\n1 g 5909 3423 N 0 39 48 0 0
      -39 h\n1 g 5860 3423 N 0 39 49 0 0 -39 h\n1 g 5811 3423 N 0 39 49 0 0
      -39 h\n1 g 5763 3423 N 0 39 48 0 0 -39 h\n1 g 5714 3423 N 0 39 49 0 0
      -39 h\n1 g 5665 3423 N 0 39 49 0 0 -39 h\n1 g 5617 3423 N 0 39 48 0 0
      -39 h\n1 g 5568 3423 N 0 39 49 0 0 -39 h\n1 g 5520 3423 N 0 39 48 0 0
      -39 h\n1 g 5471 3423 N 0 39 49 0 0 -39 h\n1 g 5422 3423 N 0 39 49 0 0
      -39 h\n1 g 5374 3423 N 0 39 48 0 0 -39 h\n1 g 5325 3423 N 0 39 49 0 0
      -39 h\n1 g 5277 3423 N 0 39 48 0 0 -39 h\n1 g 5228 3423 N 0 39 49 0 0
      -39 h\n1 g 5179 3423 N 0 39 49 0 0 -39 h\n1 g 5131 3423 N 0 39 48 0 0
      -39 h\n1 g 5082 3423 N 0 39 49 0 0 -39 h\n1 g 5034 3423 N 0 39 48 0 0
      -39 h\n1 g 4985 3423 N 0 39 49 0 0 -39 h\n1 g 4936 3423 N 0 39 49 0 0
      -39 h\n.95 g 4888 3423 N 0 39 48 0 0 -39 h\n.85 g 4839 3423 N 0 39 49 0
      0 -39 h\n.8 g 4790 3423 N 0 39 49 0 0 -39 h\n.8 g 4742 3423 N 0 39 48 0
      0 -39 h\n.8 g 4693 3423 N 0 39 49 0 0 -39 h\n.8 g 4645 3423 N 0 39 48 0
      0 -39 h\n.8 g 4596 3423 N 0 39 49 0 0 -39 h\n.8 g 4547 3423 N 0 39 49 0
      0 -39 h\n.8 g 4499 3423 N 0 39 48 0 0 -39 h\n.8 g 4450 3423 N 0 39 49 0
      0 -39 h\n.8 g 4402 3423 N 0 39 48 0 0 -39 h\n.8 g 4353 3423 N 0 39 49 0
      0 -39 h\n.8 g 4304 3423 N 0 39 49 0 0 -39 h\n.8 g 4256 3423 N 0 39 48 0
      0 -39 h\n.8 g 4207 3423 N 0 39 49 0 0 -39 h\n.8 g 4159 3423 N 0 39 48 0
      0 -39 h\n.8 g 4110 3423 N 0 39 49 0 0 -39 h\n.8 g 4061 3423 N 0 39 49 0
      0 -39 h\n.8 g 4013 3423 N 0 39 48 0 0 -39 h\n.8 g 3964 3423 N 0 39 49 0
      0 -39 h\n.8 g 3915 3423 N 0 39 49 0 0 -39 h\n.8 g 3867 3423 N 0 39 48 0
      0 -39 h\n.8 g 3818 3423 N 0 39 49 0 0 -39 h\n.8 g 3770 3423 N 0 39 48 0
      0 -39 h\n.8 g 3721 3423 N 0 39 49 0 0 -39 h\n.8 g 3672 3423 N 0 39 49 0
      0 -39 h\n.8 g 3624 3423 N 0 39 48 0 0 -39 h\n.8 g 3575 3423 N 0 39 49 0
      0 -39 h\n.8 g 3527 3423 N 0 39 48 0 0 -39 h\n.8 g 3478 3423 N 0 39 49 0
      0 -39 h\n.8 g 3429 3423 N 0 39 49 0 0 -39 h\n.8 g 3381 3423 N 0 39 48 0
      0 -39 h\n.8 g 3332 3423 N 0 39 49 0 0 -39 h\n.8 g 3284 3423 N 0 39 48 0
      0 -39 h\n.8 g 3235 3423 N 0 39 49 0 0 -39 h\n.8 g 3186 3423 N 0 39 49 0
      0 -39 h\n.8 g 3138 3423 N 0 39 48 0 0 -39 h\n.8 g 3089 3423 N 0 39 49 0
      0 -39 h\n.8 g 3040 3423 N 0 39 49 0 0 -39 h\n.8 g 2992 3423 N 0 39 48 0
      0 -39 h\n.8 g 2943 3423 N 0 39 49 0 0 -39 h\n.8 g 2895 3423 N 0 39 48 0
      0 -39 h\n.8 g 2846 3423 N 0 39 49 0 0 -39 h\n.8 g 2797 3423 N 0 39 49 0
      0 -39 h\n.8 g 2749 3423 N 0 39 48 0 0 -39 h\n.8 g 2700 3423 N 0 39 49 0
      0 -39 h\n.8 g 2652 3423 N 0 39 48 0 0 -39 h\n.8 g 2603 3423 N 0 39 49 0
      0 -39 h\n.8 g 2554 3423 N 0 39 49 0 0 -39 h\n.8 g 2506 3423 N 0 39 48 0
      0 -39 h\n.8 g 2457 3423 N 0 39 49 0 0 -39 h\n.8 g 2409 3423 N 0 39 48 0
      0 -39 h\n.8 g 2360 3423 N 0 39 49 0 0 -39 h\n.85 g 2311 3423 N 0 39 49
      0 0 -39 h\n.95 g 2263 3423 N 0 39 48 0 0 -39 h\n1 g 2214 3423 N 0 39 49
      0 0 -39 h\n1 g 2165 3423 N 0 39 49 0 0 -39 h\n1 g 2117 3423 N 0 39 48 0
      0 -39 h\n1 g 2068 3423 N 0 39 49 0 0 -39 h\n1 g 2020 3423 N 0 39 48 0 0
      -39 h\n1 g 1971 3423 N 0 39 49 0 0 -39 h\n1 g 1922 3423 N 0 39 49 0 0
      -39 h\n1 g 1874 3423 N 0 39 48 0 0 -39 h\n1 g 1825 3423 N 0 39 49 0 0
      -39 h\n1 g 1777 3423 N 0 39 48 0 0 -39 h\n1 g 1728 3423 N 0 39 49 0 0
      -39 h\n1 g 1679 3423 N 0 39 49 0 0 -39 h\n1 g 1631 3423 N 0 39 48 0 0
      -39 h\n1 g 1582 3423 N 0 39 49 0 0 -39 h\n1 g 1534 3423 N 0 39 48 0 0
      -39 h\n1 g 1485 3423 N 0 39 49 0 0 -39 h\n1 g 1436 3423 N 0 39 49 0 0
      -39 h\n1 g 1388 3423 N 0 39 48 0 0 -39 h\n1 g 1339 3423 N 0 39 49 0 0
      -39 h\n1 g 1290 3423 N 0 39 49 0 0 -39 h\n1 g 1242 3423 N 0 39 48 0 0
      -39 h\n1 g 1193 3423 N 0 39 49 0 0 -39 h\n1 g 5957 3384 N 0 39 49 0 0
      -39 h\n1 g 5909 3384 N 0 39 48 0 0 -39 h\n1 g 5860 3384 N 0 39 49 0 0
      -39 h\n1 g 5811 3384 N 0 39 49 0 0 -39 h\n1 g 5763 3384 N 0 39 48 0 0
      -39 h\n1 g 5714 3384 N 0 39 49 0 0 -39 h\n1 g 5665 3384 N 0 39 49 0 0
      -39 h\n1 g 5617 3384 N 0 39 48 0 0 -39 h\n1 g 5568 3384 N 0 39 49 0 0
      -39 h\n1 g 5520 3384 N 0 39 48 0 0 -39 h\n1 g 5471 3384 N 0 39 49 0 0
      -39 h\n1 g 5422 3384 N 0 39 49 0 0 -39 h\n1 g 5374 3384 N 0 39 48 0 0
      -39 h\n1 g 5325 3384 N 0 39 49 0 0 -39 h\n1 g 5277 3384 N 0 39 48 0 0
      -39 h\n1 g 5228 3384 N 0 39 49 0 0 -39 h\n1 g 5179 3384 N 0 39 49 0 0
      -39 h\n1 g 5131 3384 N 0 39 48 0 0 -39 h\n1 g 5082 3384 N 0 39 49 0 0
      -39 h\n1 g 5034 3384 N 0 39 48 0 0 -39 h\n1 g 4985 3384 N 0 39 49 0 0
      -39 h\n1 g 4936 3384 N 0 39 49 0 0 -39 h\n1 g 4888 3384 N 0 39 48 0 0
      -39 h\n.9 g 4839 3384 N 0 39 49 0 0 -39 h\n.8 g 4790 3384 N 0 39 49 0 0
      -39 h\n.8 g 4742 3384 N 0 39 48 0 0 -39 h\n.8 g 4693 3384 N 0 39 49 0 0
      -39 h\n.8 g 4645 3384 N 0 39 48 0 0 -39 h\n.8 g 4596 3384 N 0 39 49 0 0
      -39 h\n.8 g 4547 3384 N 0 39 49 0 0 -39 h\n.8 g 4499 3384 N 0 39 48 0 0
      -39 h\n.8 g 4450 3384 N 0 39 49 0 0 -39 h\n.8 g 4402 3384 N 0 39 48 0 0
      -39 h\n.8 g 4353 3384 N 0 39 49 0 0 -39 h\n.8 g 4304 3384 N 0 39 49 0 0
      -39 h\n.8 g 4256 3384 N 0 39 48 0 0 -39 h\n.8 g 4207 3384 N 0 39 49 0 0
      -39 h\n.8 g 4159 3384 N 0 39 48 0 0 -39 h\n.8 g 4110 3384 N 0 39 49 0 0
      -39 h\n.8 g 4061 3384 N 0 39 49 0 0 -39 h\n.8 g 4013 3384 N 0 39 48 0 0
      -39 h\n.8 g 3964 3384 N 0 39 49 0 0 -39 h\n.8 g 3915 3384 N 0 39 49 0 0
      -39 h\n.8 g 3867 3384 N 0 39 48 0 0 -39 h\n.8 g 3818 3384 N 0 39 49 0 0
      -39 h\n.8 g 3770 3384 N 0 39 48 0 0 -39 h\n.8 g 3721 3384 N 0 39 49 0 0
      -39 h\n.8 g 3672 3384 N 0 39 49 0 0 -39 h\n.8 g 3624 3384 N 0 39 48 0 0
      -39 h\n.8 g 3575 3384 N 0 39 49 0 0 -39 h\n.8 g 3527 3384 N 0 39 48 0 0
      -39 h\n.8 g 3478 3384 N 0 39 49 0 0 -39 h\n.8 g 3429 3384 N 0 39 49 0 0
      -39 h\n.8 g 3381 3384 N 0 39 48 0 0 -39 h\n.8 g 3332 3384 N 0 39 49 0 0
      -39 h\n.8 g 3284 3384 N 0 39 48 0 0 -39 h\n.8 g 3235 3384 N 0 39 49 0 0
      -39 h\n.8 g 3186 3384 N 0 39 49 0 0 -39 h\n.8 g 3138 3384 N 0 39 48 0 0
      -39 h\n.8 g 3089 3384 N 0 39 49 0 0 -39 h\n.8 g 3040 3384 N 0 39 49 0 0
      -39 h\n.8 g 2992 3384 N 0 39 48 0 0 -39 h\n.8 g 2943 3384 N 0 39 49 0 0
      -39 h\n.8 g 2895 3384 N 0 39 48 0 0 -39 h\n.8 g 2846 3384 N 0 39 49 0 0
      -39 h\n.8 g 2797 3384 N 0 39 49 0 0 -39 h\n.8 g 2749 3384 N 0 39 48 0 0
      -39 h\n.8 g 2700 3384 N 0 39 49 0 0 -39 h\n.8 g 2652 3384 N 0 39 48 0 0
      -39 h\n.8 g 2603 3384 N 0 39 49 0 0 -39 h\n.8 g 2554 3384 N 0 39 49 0 0
      -39 h\n.8 g 2506 3384 N 0 39 48 0 0 -39 h\n.8 g 2457 3384 N 0 39 49 0 0
      -39 h\n.8 g 2409 3384 N 0 39 48 0 0 -39 h\n.8 g 2360 3384 N 0 39 49 0 0
      -39 h\n.9 g 2311 3384 N 0 39 49 0 0 -39 h\n1 g 2263 3384 N 0 39 48 0 0
      -39 h\n1 g 2214 3384 N 0 39 49 0 0 -39 h\n1 g 2165 3384 N 0 39 49 0 0
      -39 h\n1 g 2117 3384 N 0 39 48 0 0 -39 h\n1 g 2068 3384 N 0 39 49 0 0
      -39 h\n1 g 2020 3384 N 0 39 48 0 0 -39 h\n1 g 1971 3384 N 0 39 49 0 0
      -39 h\n1 g 1922 3384 N 0 39 49 0 0 -39 h\n1 g 1874 3384 N 0 39 48 0 0
      -39 h\n1 g 1825 3384 N 0 39 49 0 0 -39 h\n1 g 1777 3384 N 0 39 48 0 0
      -39 h\n1 g 1728 3384 N 0 39 49 0 0 -39 h\n1 g 1679 3384 N 0 39 49 0 0
      -39 h\n1 g 1631 3384 N 0 39 48 0 0 -39 h\n1 g 1582 3384 N 0 39 49 0 0
      -39 h\n1 g 1534 3384 N 0 39 48 0 0 -39 h\n1 g 1485 3384 N 0 39 49 0 0
      -39 h\n1 g 1436 3384 N 0 39 49 0 0 -39 h\n1 g 1388 3384 N 0 39 48 0 0
      -39 h\n1 g 1339 3384 N 0 39 49 0 0 -39 h\n1 g 1290 3384 N 0 39 49 0 0
      -39 h\n1 g 1242 3384 N 0 39 48 0 0 -39 h\n1 g 1193 3384 N 0 39 49 0 0
      -39 h\n1 g 5957 3345 N 0 38 49 0 0 -38 h\n1 g 5909 3345 N 0 38 48 0 0
      -38 h\n1 g 5860 3345 N 0 38 49 0 0 -38 h\n1 g 5811 3345 N 0 38 49 0 0
      -38 h\n1 g 5763 3345 N 0 38 48 0 0 -38 h\n1 g 5714 3345 N 0 38 49 0 0
      -38 h\n1 g 5665 3345 N 0 38 49 0 0 -38 h\n1 g 5617 3345 N 0 38 48 0 0
      -38 h\n1 g 5568 3345 N 0 38 49 0 0 -38 h\n1 g 5520 3345 N 0 38 48 0 0
      -38 h\n1 g 5471 3345 N 0 38 49 0 0 -38 h\n1 g 5422 3345 N 0 38 49 0 0
      -38 h\n1 g 5374 3345 N 0 38 48 0 0 -38 h\n1 g 5325 3345 N 0 38 49 0 0
      -38 h\n1 g 5277 3345 N 0 38 48 0 0 -38 h\n1 g 5228 3345 N 0 38 49 0 0
      -38 h\n1 g 5179 3345 N 0 38 49 0 0 -38 h\n1 g 5131 3345 N 0 38 48 0 0
      -38 h\n1 g 5082 3345 N 0 38 49 0 0 -38 h\n1 g 5034 3345 N 0 38 48 0 0
      -38 h\n1 g 4985 3345 N 0 38 49 0 0 -38 h\n1 g 4936 3345 N 0 38 49 0 0
      -38 h\n1 g 4888 3345 N 0 38 48 0 0 -38 h\n.9 g 4839 3345 N 0 38 49 0 0
      -38 h\n.8 g 4790 3345 N 0 38 49 0 0 -38 h\n.8 g 4742 3345 N 0 38 48 0 0
      -38 h\n.8 g 4693 3345 N 0 38 49 0 0 -38 h\n.8 g 4645 3345 N 0 38 48 0 0
      -38 h\n.8 g 4596 3345 N 0 38 49 0 0 -38 h\n.8 g 4547 3345 N 0 38 49 0 0
      -38 h\n.8 g 4499 3345 N 0 38 48 0 0 -38 h\n.8 g 4450 3345 N 0 38 49 0 0
      -38 h\n.8 g 4402 3345 N 0 38 48 0 0 -38 h\n.8 g 4353 3345 N 0 38 49 0 0
      -38 h\n.8 g 4304 3345 N 0 38 49 0 0 -38 h\n.8 g 4256 3345 N 0 38 48 0 0
      -38 h\n.8 g 4207 3345 N 0 38 49 0 0 -38 h\n.8 g 4159 3345 N 0 38 48 0 0
      -38 h\n.8 g 4110 3345 N 0 38 49 0 0 -38 h\n.8 g 4061 3345 N 0 38 49 0 0
      -38 h\n.8 g 4013 3345 N 0 38 48 0 0 -38 h\n.8 g 3964 3345 N 0 38 49 0 0
      -38 h\n.8 g 3915 3345 N 0 38 49 0 0 -38 h\n.8 g 3867 3345 N 0 38 48 0 0
      -38 h\n.8 g 3818 3345 N 0 38 49 0 0 -38 h\n.8 g 3770 3345 N 0 38 48 0 0
      -38 h\n.8 g 3721 3345 N 0 38 49 0 0 -38 h\n.8 g 3672 3345 N 0 38 49 0 0
      -38 h\n.8 g 3624 3345 N 0 38 48 0 0 -38 h\n.8 g 3575 3345 N 0 38 49 0 0
      -38 h\n.8 g 3527 3345 N 0 38 48 0 0 -38 h\n.8 g 3478 3345 N 0 38 49 0 0
      -38 h\n.8 g 3429 3345 N 0 38 49 0 0 -38 h\n.8 g 3381 3345 N 0 38 48 0 0
      -38 h\n.8 g 3332 3345 N 0 38 49 0 0 -38 h\n.8 g 3284 3345 N 0 38 48 0 0
      -38 h\n.8 g 3235 3345 N 0 38 49 0 0 -38 h\n.8 g 3186 3345 N 0 38 49 0 0
      -38 h\n.8 g 3138 3345 N 0 38 48 0 0 -38 h\n.8 g 3089 3345 N 0 38 49 0 0
      -38 h\n.8 g 3040 3345 N 0 38 49 0 0 -38 h\n.8 g 2992 3345 N 0 38 48 0 0
      -38 h\n.8 g 2943 3345 N 0 38 49 0 0 -38 h\n.8 g 2895 3345 N 0 38 48 0 0
      -38 h\n.8 g 2846 3345 N 0 38 49 0 0 -38 h\n.8 g 2797 3345 N 0 38 49 0 0
      -38 h\n.8 g 2749 3345 N 0 38 48 0 0 -38 h\n.8 g 2700 3345 N 0 38 49 0 0
      -38 h\n.8 g 2652 3345 N 0 38 48 0 0 -38 h\n.8 g 2603 3345 N 0 38 49 0 0
      -38 h\n.8 g 2554 3345 N 0 38 49 0 0 -38 h\n.8 g 2506 3345 N 0 38 48 0 0
      -38 h\n.8 g 2457 3345 N 0 38 49 0 0 -38 h\n.8 g 2409 3345 N 0 38 48 0 0
      -38 h\n.8 g 2360 3345 N 0 38 49 0 0 -38 h\n.9 g 2311 3345 N 0 38 49 0 0
      -38 h\n1 g 2263 3345 N 0 38 48 0 0 -38 h\n1 g 2214 3345 N 0 38 49 0 0
      -38 h\n1 g 2165 3345 N 0 38 49 0 0 -38 h\n1 g 2117 3345 N 0 38 48 0 0
      -38 h\n1 g 2068 3345 N 0 38 49 0 0 -38 h\n1 g 2020 3345 N 0 38 48 0 0
      -38 h\n1 g 1971 3345 N 0 38 49 0 0 -38 h\n1 g 1922 3345 N 0 38 49 0 0
      -38 h\n1 g 1874 3345 N 0 38 48 0 0 -38 h\n1 g 1825 3345 N 0 38 49 0 0
      -38 h\n1 g 1777 3345 N 0 38 48 0 0 -38 h\n1 g 1728 3345 N 0 38 49 0 0
      -38 h\n1 g 1679 3345 N 0 38 49 0 0 -38 h\n1 g 1631 3345 N 0 38 48 0 0
      -38 h\n1 g 1582 3345 N 0 38 49 0 0 -38 h\n1 g 1534 3345 N 0 38 48 0 0
      -38 h\n1 g 1485 3345 N 0 38 49 0 0 -38 h\n1 g 1436 3345 N 0 38 49 0 0
      -38 h\n1 g 1388 3345 N 0 38 48 0 0 -38 h\n1 g 1339 3345 N 0 38 49 0 0
      -38 h\n1 g 1290 3345 N 0 38 49 0 0 -38 h\n1 g 1242 3345 N 0 38 48 0 0
      -38 h\n1 g 1193 3345 N 0 38 49 0 0 -38 h\n1 g 5957 3307 N 0 39 49 0 0
      -39 h\n1 g 5909 3307 N 0 39 48 0 0 -39 h\n1 g 5860 3307 N 0 39 49 0 0
      -39 h\n1 g 5811 3307 N 0 39 49 0 0 -39 h\n1 g 5763 3307 N 0 39 48 0 0
      -39 h\n1 g 5714 3307 N 0 39 49 0 0 -39 h\n1 g 5665 3307 N 0 39 49 0 0
      -39 h\n1 g 5617 3307 N 0 39 48 0 0 -39 h\n1 g 5568 3307 N 0 39 49 0 0
      -39 h\n1 g 5520 3307 N 0 39 48 0 0 -39 h\n1 g 5471 3307 N 0 39 49 0 0
      -39 h\n1 g 5422 3307 N 0 39 49 0 0 -39 h\n1 g 5374 3307 N 0 39 48 0 0
      -39 h\n1 g 5325 3307 N 0 39 49 0 0 -39 h\n1 g 5277 3307 N 0 39 48 0 0
      -39 h\n1 g 5228 3307 N 0 39 49 0 0 -39 h\n1 g 5179 3307 N 0 39 49 0 0
      -39 h\n1 g 5131 3307 N 0 39 48 0 0 -39 h\n1 g 5082 3307 N 0 39 49 0 0
      -39 h\n1 g 5034 3307 N 0 39 48 0 0 -39 h\n1 g 4985 3307 N 0 39 49 0 0
      -39 h\n1 g 4936 3307 N 0 39 49 0 0 -39 h\n1 g 4888 3307 N 0 39 48 0 0
      -39 h\n.9 g 4839 3307 N 0 39 49 0 0 -39 h\n.8 g 4790 3307 N 0 39 49 0 0
      -39 h\n.8 g 4742 3307 N 0 39 48 0 0 -39 h\n.8 g 4693 3307 N 0 39 49 0 0
      -39 h\n.8 g 4645 3307 N 0 39 48 0 0 -39 h\n.8 g 4596 3307 N 0 39 49 0 0
      -39 h\n.8 g 4547 3307 N 0 39 49 0 0 -39 h\n.8 g 4499 3307 N 0 39 48 0 0
      -39 h\n.8 g 4450 3307 N 0 39 49 0 0 -39 h\n.8 g 4402 3307 N 0 39 48 0 0
      -39 h\n.8 g 4353 3307 N 0 39 49 0 0 -39 h\n.8 g 4304 3307 N 0 39 49 0 0
      -39 h\n.8 g 4256 3307 N 0 39 48 0 0 -39 h\n.8 g 4207 3307 N 0 39 49 0 0
      -39 h\n.8 g 4159 3307 N 0 39 48 0 0 -39 h\n.8 g 4110 3307 N 0 39 49 0 0
      -39 h\n.8 g 4061 3307 N 0 39 49 0 0 -39 h\n.8 g 4013 3307 N 0 39 48 0 0
      -39 h\n.8 g 3964 3307 N 0 39 49 0 0 -39 h\n.8 g 3915 3307 N 0 39 49 0 0
      -39 h\n.8 g 3867 3307 N 0 39 48 0 0 -39 h\n.8 g 3818 3307 N 0 39 49 0 0
      -39 h\n.8 g 3770 3307 N 0 39 48 0 0 -39 h\n.8 g 3721 3307 N 0 39 49 0 0
      -39 h\n.8 g 3672 3307 N 0 39 49 0 0 -39 h\n.8 g 3624 3307 N 0 39 48 0 0
      -39 h\n.8 g 3575 3307 N 0 39 49 0 0 -39 h\n.8 g 3527 3307 N 0 39 48 0 0
      -39 h\n.8 g 3478 3307 N 0 39 49 0 0 -39 h\n.8 g 3429 3307 N 0 39 49 0 0
      -39 h\n.8 g 3381 3307 N 0 39 48 0 0 -39 h\n.8 g 3332 3307 N 0 39 49 0 0
      -39 h\n.8 g 3284 3307 N 0 39 48 0 0 -39 h\n.8 g 3235 3307 N 0 39 49 0 0
      -39 h\n.8 g 3186 3307 N 0 39 49 0 0 -39 h\n.8 g 3138 3307 N 0 39 48 0 0
      -39 h\n.8 g 3089 3307 N 0 39 49 0 0 -39 h\n.8 g 3040 3307 N 0 39 49 0 0
      -39 h\n.8 g 2992 3307 N 0 39 48 0 0 -39 h\n.8 g 2943 3307 N 0 39 49 0 0
      -39 h\n.8 g 2895 3307 N 0 39 48 0 0 -39 h\n.8 g 2846 3307 N 0 39 49 0 0
      -39 h\n.8 g 2797 3307 N 0 39 49 0 0 -39 h\n.8 g 2749 3307 N 0 39 48 0 0
      -39 h\n.8 g 2700 3307 N 0 39 49 0 0 -39 h\n.8 g 2652 3307 N 0 39 48 0 0
      -39 h\n.8 g 2603 3307 N 0 39 49 0 0 -39 h\n.8 g 2554 3307 N 0 39 49 0 0
      -39 h\n.8 g 2506 3307 N 0 39 48 0 0 -39 h\n.8 g 2457 3307 N 0 39 49 0 0
      -39 h\n.8 g 2409 3307 N 0 39 48 0 0 -39 h\n.8 g 2360 3307 N 0 39 49 0 0
      -39 h\n.9 g 2311 3307 N 0 39 49 0 0 -39 h\n1 g 2263 3307 N 0 39 48 0 0
      -39 h\n1 g 2214 3307 N 0 39 49 0 0 -39 h\n1 g 2165 3307 N 0 39 49 0 0
      -39 h\n1 g 2117 3307 N 0 39 48 0 0 -39 h\n1 g 2068 3307 N 0 39 49 0 0
      -39 h\n1 g 2020 3307 N 0 39 48 0 0 -39 h\n1 g 1971 3307 N 0 39 49 0 0
      -39 h\n1 g 1922 3307 N 0 39 49 0 0 -39 h\n1 g 1874 3307 N 0 39 48 0 0
      -39 h\n1 g 1825 3307 N 0 39 49 0 0 -39 h\n1 g 1777 3307 N 0 39 48 0 0
      -39 h\n1 g 1728 3307 N 0 39 49 0 0 -39 h\n1 g 1679 3307 N 0 39 49 0 0
      -39 h\n1 g 1631 3307 N 0 39 48 0 0 -39 h\n1 g 1582 3307 N 0 39 49 0 0
      -39 h\n1 g 1534 3307 N 0 39 48 0 0 -39 h\n1 g 1485 3307 N 0 39 49 0 0
      -39 h\n1 g 1436 3307 N 0 39 49 0 0 -39 h\n1 g 1388 3307 N 0 39 48 0 0
      -39 h\n1 g 1339 3307 N 0 39 49 0 0 -39 h\n1 g 1290 3307 N 0 39 49 0 0
      -39 h\n1 g 1242 3307 N 0 39 48 0 0 -39 h\n1 g 1193 3307 N 0 39 49 0 0
      -39 h\n1 g 5957 3268 N 0 39 49 0 0 -39 h\n1 g 5909 3268 N 0 39 48 0 0
      -39 h\n1 g 5860 3268 N 0 39 49 0 0 -39 h\n1 g 5811 3268 N 0 39 49 0 0
      -39 h\n1 g 5763 3268 N 0 39 48 0 0 -39 h\n1 g 5714 3268 N 0 39 49 0 0
      -39 h\n1 g 5665 3268 N 0 39 49 0 0 -39 h\n1 g 5617 3268 N 0 39 48 0 0
      -39 h\n1 g 5568 3268 N 0 39 49 0 0 -39 h\n1 g 5520 3268 N 0 39 48 0 0
      -39 h\n1 g 5471 3268 N 0 39 49 0 0 -39 h\n1 g 5422 3268 N 0 39 49 0 0
      -39 h\n1 g 5374 3268 N 0 39 48 0 0 -39 h\n1 g 5325 3268 N 0 39 49 0 0
      -39 h\n1 g 5277 3268 N 0 39 48 0 0 -39 h\n1 g 5228 3268 N 0 39 49 0 0
      -39 h\n1 g 5179 3268 N 0 39 49 0 0 -39 h\n1 g 5131 3268 N 0 39 48 0 0
      -39 h\n1 g 5082 3268 N 0 39 49 0 0 -39 h\n1 g 5034 3268 N 0 39 48 0 0
      -39 h\n1 g 4985 3268 N 0 39 49 0 0 -39 h\n1 g 4936 3268 N 0 39 49 0 0
      -39 h\n1 g 4888 3268 N 0 39 48 0 0 -39 h\n.9 g 4839 3268 N 0 39 49 0 0
      -39 h\n.8 g 4790 3268 N 0 39 49 0 0 -39 h\n.8 g 4742 3268 N 0 39 48 0 0
      -39 h\n.8 g 4693 3268 N 0 39 49 0 0 -39 h\n.8 g 4645 3268 N 0 39 48 0 0
      -39 h\n.8 g 4596 3268 N 0 39 49 0 0 -39 h\n.8 g 4547 3268 N 0 39 49 0 0
      -39 h\n.8 g 4499 3268 N 0 39 48 0 0 -39 h\n.8 g 4450 3268 N 0 39 49 0 0
      -39 h\n.8 g 4402 3268 N 0 39 48 0 0 -39 h\n.8 g 4353 3268 N 0 39 49 0 0
      -39 h\n.8 g 4304 3268 N 0 39 49 0 0 -39 h\n.8 g 4256 3268 N 0 39 48 0 0
      -39 h\n.8 g 4207 3268 N 0 39 49 0 0 -39 h\n.8 g 4159 3268 N 0 39 48 0 0
      -39 h\n.8 g 4110 3268 N 0 39 49 0 0 -39 h\n.8 g 4061 3268 N 0 39 49 0 0
      -39 h\n.8 g 4013 3268 N 0 39 48 0 0 -39 h\n.8 g 3964 3268 N 0 39 49 0 0
      -39 h\n.8 g 3915 3268 N 0 39 49 0 0 -39 h\n.8 g 3867 3268 N 0 39 48 0 0
      -39 h\n.8 g 3818 3268 N 0 39 49 0 0 -39 h\n.8 g 3770 3268 N 0 39 48 0 0
      -39 h\n.8 g 3721 3268 N 0 39 49 0 0 -39 h\n.8 g 3672 3268 N 0 39 49 0 0
      -39 h\n.8 g 3624 3268 N 0 39 48 0 0 -39 h\n.8 g 3575 3268 N 0 39 49 0 0
      -39 h\n.8 g 3527 3268 N 0 39 48 0 0 -39 h\n.8 g 3478 3268 N 0 39 49 0 0
      -39 h\n.8 g 3429 3268 N 0 39 49 0 0 -39 h\n.8 g 3381 3268 N 0 39 48 0 0
      -39 h\n.8 g 3332 3268 N 0 39 49 0 0 -39 h\n.8 g 3284 3268 N 0 39 48 0 0
      -39 h\n.8 g 3235 3268 N 0 39 49 0 0 -39 h\n.8 g 3186 3268 N 0 39 49 0 0
      -39 h\n.8 g 3138 3268 N 0 39 48 0 0 -39 h\n.8 g 3089 3268 N 0 39 49 0 0
      -39 h\n.8 g 3040 3268 N 0 39 49 0 0 -39 h\n.8 g 2992 3268 N 0 39 48 0 0
      -39 h\n.8 g 2943 3268 N 0 39 49 0 0 -39 h\n.8 g 2895 3268 N 0 39 48 0 0
      -39 h\n.8 g 2846 3268 N 0 39 49 0 0 -39 h\n.8 g 2797 3268 N 0 39 49 0 0
      -39 h\n.8 g 2749 3268 N 0 39 48 0 0 -39 h\n.8 g 2700 3268 N 0 39 49 0 0
      -39 h\n.8 g 2652 3268 N 0 39 48 0 0 -39 h\n.8 g 2603 3268 N 0 39 49 0 0
      -39 h\n.8 g 2554 3268 N 0 39 49 0 0 -39 h\n.8 g 2506 3268 N 0 39 48 0 0
      -39 h\n.8 g 2457 3268 N 0 39 49 0 0 -39 h\n.8 g 2409 3268 N 0 39 48 0 0
      -39 h\n.8 g 2360 3268 N 0 39 49 0 0 -39 h\n.9 g 2311 3268 N 0 39 49 0 0
      -39 h\n1 g 2263 3268 N 0 39 48 0 0 -39 h\n1 g 2214 3268 N 0 39 49 0 0
      -39 h\n1 g 2165 3268 N 0 39 49 0 0 -39 h\n1 g 2117 3268 N 0 39 48 0 0
      -39 h\n1 g 2068 3268 N 0 39 49 0 0 -39 h\n1 g 2020 3268 N 0 39 48 0 0
      -39 h\n1 g 1971 3268 N 0 39 49 0 0 -39 h\n1 g 1922 3268 N 0 39 49 0 0
      -39 h\n1 g 1874 3268 N 0 39 48 0 0 -39 h\n1 g 1825 3268 N 0 39 49 0 0
      -39 h\n1 g 1777 3268 N 0 39 48 0 0 -39 h\n1 g 1728 3268 N 0 39 49 0 0
      -39 h\n1 g 1679 3268 N 0 39 49 0 0 -39 h\n1 g 1631 3268 N 0 39 48 0 0
      -39 h\n1 g 1582 3268 N 0 39 49 0 0 -39 h\n1 g 1534 3268 N 0 39 48 0 0
      -39 h\n1 g 1485 3268 N 0 39 49 0 0 -39 h\n1 g 1436 3268 N 0 39 49 0 0
      -39 h\n1 g 1388 3268 N 0 39 48 0 0 -39 h\n1 g 1339 3268 N 0 39 49 0 0
      -39 h\n1 g 1290 3268 N 0 39 49 0 0 -39 h\n1 g 1242 3268 N 0 39 48 0 0
      -39 h\n1 g 1193 3268 N 0 39 49 0 0 -39 h\n1 g 5957 3229 N 0 39 49 0 0
      -39 h\n1 g 5909 3229 N 0 39 48 0 0 -39 h\n1 g 5860 3229 N 0 39 49 0 0
      -39 h\n1 g 5811 3229 N 0 39 49 0 0 -39 h\n1 g 5763 3229 N 0 39 48 0 0
      -39 h\n1 g 5714 3229 N 0 39 49 0 0 -39 h\n1 g 5665 3229 N 0 39 49 0 0
      -39 h\n1 g 5617 3229 N 0 39 48 0 0 -39 h\n1 g 5568 3229 N 0 39 49 0 0
      -39 h\n1 g 5520 3229 N 0 39 48 0 0 -39 h\n1 g 5471 3229 N 0 39 49 0 0
      -39 h\n1 g 5422 3229 N 0 39 49 0 0 -39 h\n1 g 5374 3229 N 0 39 48 0 0
      -39 h\n1 g 5325 3229 N 0 39 49 0 0 -39 h\n1 g 5277 3229 N 0 39 48 0 0
      -39 h\n1 g 5228 3229 N 0 39 49 0 0 -39 h\n1 g 5179 3229 N 0 39 49 0 0
      -39 h\n1 g 5131 3229 N 0 39 48 0 0 -39 h\n1 g 5082 3229 N 0 39 49 0 0
      -39 h\n1 g 5034 3229 N 0 39 48 0 0 -39 h\n1 g 4985 3229 N 0 39 49 0 0
      -39 h\n1 g 4936 3229 N 0 39 49 0 0 -39 h\n1 g 4888 3229 N 0 39 48 0 0
      -39 h\n.95 g 4839 3229 N 0 39 49 0 0 -39 h\n.85 g 4790 3229 N 0 39 49 0
      0 -39 h\n.8 g 4742 3229 N 0 39 48 0 0 -39 h\n.8 g 4693 3229 N 0 39 49 0
      0 -39 h\n.8 g 4645 3229 N 0 39 48 0 0 -39 h\n.8 g 4596 3229 N 0 39 49 0
      0 -39 h\n.8 g 4547 3229 N 0 39 49 0 0 -39 h\n.8 g 4499 3229 N 0 39 48 0
      0 -39 h\n.8 g 4450 3229 N 0 39 49 0 0 -39 h\n.8 g 4402 3229 N 0 39 48 0
      0 -39 h\n.8 g 4353 3229 N 0 39 49 0 0 -39 h\n.8 g 4304 3229 N 0 39 49 0
      0 -39 h\n.8 g 4256 3229 N 0 39 48 0 0 -39 h\n.8 g 4207 3229 N 0 39 49 0
      0 -39 h\n.8 g 4159 3229 N 0 39 48 0 0 -39 h\n.8 g 4110 3229 N 0 39 49 0
      0 -39 h\n.8 g 4061 3229 N 0 39 49 0 0 -39 h\n.8 g 4013 3229 N 0 39 48 0
      0 -39 h\n.8 g 3964 3229 N 0 39 49 0 0 -39 h\n.8 g 3915 3229 N 0 39 49 0
      0 -39 h\n.8 g 3867 3229 N 0 39 48 0 0 -39 h\n.8 g 3818 3229 N 0 39 49 0
      0 -39 h\n.8 g 3770 3229 N 0 39 48 0 0 -39 h\n.8 g 3721 3229 N 0 39 49 0
      0 -39 h\n.8 g 3672 3229 N 0 39 49 0 0 -39 h\n.8 g 3624 3229 N 0 39 48 0
      0 -39 h\n.8 g 3575 3229 N 0 39 49 0 0 -39 h\n.8 g 3527 3229 N 0 39 48 0
      0 -39 h\n.8 g 3478 3229 N 0 39 49 0 0 -39 h\n.8 g 3429 3229 N 0 39 49 0
      0 -39 h\n.8 g 3381 3229 N 0 39 48 0 0 -39 h\n.8 g 3332 3229 N 0 39 49 0
      0 -39 h\n.8 g 3284 3229 N 0 39 48 0 0 -39 h\n.8 g 3235 3229 N 0 39 49 0
      0 -39 h\n.8 g 3186 3229 N 0 39 49 0 0 -39 h\n.8 g 3138 3229 N 0 39 48 0
      0 -39 h\n.8 g 3089 3229 N 0 39 49 0 0 -39 h\n.8 g 3040 3229 N 0 39 49 0
      0 -39 h\n.8 g 2992 3229 N 0 39 48 0 0 -39 h\n.8 g 2943 3229 N 0 39 49 0
      0 -39 h\n.8 g 2895 3229 N 0 39 48 0 0 -39 h\n.8 g 2846 3229 N 0 39 49 0
      0 -39 h\n.8 g 2797 3229 N 0 39 49 0 0 -39 h\n.8 g 2749 3229 N 0 39 48 0
      0 -39 h\n.8 g 2700 3229 N 0 39 49 0 0 -39 h\n.8 g 2652 3229 N 0 39 48 0
      0 -39 h\n.8 g 2603 3229 N 0 39 49 0 0 -39 h\n.8 g 2554 3229 N 0 39 49 0
      0 -39 h\n.8 g 2506 3229 N 0 39 48 0 0 -39 h\n.8 g 2457 3229 N 0 39 49 0
      0 -39 h\n.8 g 2409 3229 N 0 39 48 0 0 -39 h\n.85 g 2360 3229 N 0 39 49
      0 0 -39 h\n.95 g 2311 3229 N 0 39 49 0 0 -39 h\n1 g 2263 3229 N 0 39 48
      0 0 -39 h\n1 g 2214 3229 N 0 39 49 0 0 -39 h\n1 g 2165 3229 N 0 39 49 0
      0 -39 h\n1 g 2117 3229 N 0 39 48 0 0 -39 h\n1 g 2068 3229 N 0 39 49 0 0
      -39 h\n1 g 2020 3229 N 0 39 48 0 0 -39 h\n1 g 1971 3229 N 0 39 49 0 0
      -39 h\n1 g 1922 3229 N 0 39 49 0 0 -39 h\n1 g 1874 3229 N 0 39 48 0 0
      -39 h\n1 g 1825 3229 N 0 39 49 0 0 -39 h\n1 g 1777 3229 N 0 39 48 0 0
      -39 h\n1 g 1728 3229 N 0 39 49 0 0 -39 h\n1 g 1679 3229 N 0 39 49 0 0
      -39 h\n1 g 1631 3229 N 0 39 48 0 0 -39 h\n1 g 1582 3229 N 0 39 49 0 0
      -39 h\n1 g 1534 3229 N 0 39 48 0 0 -39 h\n1 g 1485 3229 N 0 39 49 0 0
      -39 h\n1 g 1436 3229 N 0 39 49 0 0 -39 h\n1 g 1388 3229 N 0 39 48 0 0
      -39 h\n1 g 1339 3229 N 0 39 49 0 0 -39 h\n1 g 1290 3229 N 0 39 49 0 0
      -39 h\n1 g 1242 3229 N 0 39 48 0 0 -39 h\n1 g 1193 3229 N 0 39 49 0 0
      -39 h\n1 g 5957 3190 N 0 39 49 0 0 -39 h\n1 g 5909 3190 N 0 39 48 0 0
      -39 h\n1 g 5860 3190 N 0 39 49 0 0 -39 h\n1 g 5811 3190 N 0 39 49 0 0
      -39 h\n1 g 5763 3190 N 0 39 48 0 0 -39 h\n1 g 5714 3190 N 0 39 49 0 0
      -39 h\n1 g 5665 3190 N 0 39 49 0 0 -39 h\n1 g 5617 3190 N 0 39 48 0 0
      -39 h\n1 g 5568 3190 N 0 39 49 0 0 -39 h\n1 g 5520 3190 N 0 39 48 0 0
      -39 h\n1 g 5471 3190 N 0 39 49 0 0 -39 h\n1 g 5422 3190 N 0 39 49 0 0
      -39 h\n1 g 5374 3190 N 0 39 48 0 0 -39 h\n1 g 5325 3190 N 0 39 49 0 0
      -39 h\n1 g 5277 3190 N 0 39 48 0 0 -39 h\n1 g 5228 3190 N 0 39 49 0 0
      -39 h\n1 g 5179 3190 N 0 39 49 0 0 -39 h\n1 g 5131 3190 N 0 39 48 0 0
      -39 h\n1 g 5082 3190 N 0 39 49 0 0 -39 h\n1 g 5034 3190 N 0 39 48 0 0
      -39 h\n1 g 4985 3190 N 0 39 49 0 0 -39 h\n1 g 4936 3190 N 0 39 49 0 0
      -39 h\n1 g 4888 3190 N 0 39 48 0 0 -39 h\n1 g 4839 3190 N 0 39 49 0 0
      -39 h\n.9 g 4790 3190 N 0 39 49 0 0 -39 h\n.8 g 4742 3190 N 0 39 48 0 0
      -39 h\n.8 g 4693 3190 N 0 39 49 0 0 -39 h\n.8 g 4645 3190 N 0 39 48 0 0
      -39 h\n.8 g 4596 3190 N 0 39 49 0 0 -39 h\n.8 g 4547 3190 N 0 39 49 0 0
      -39 h\n.8 g 4499 3190 N 0 39 48 0 0 -39 h\n.8 g 4450 3190 N 0 39 49 0 0
      -39 h\n.8 g 4402 3190 N 0 39 48 0 0 -39 h\n.8 g 4353 3190 N 0 39 49 0 0
      -39 h\n.8 g 4304 3190 N 0 39 49 0 0 -39 h\n.8 g 4256 3190 N 0 39 48 0 0
      -39 h\n.8 g 4207 3190 N 0 39 49 0 0 -39 h\n.8 g 4159 3190 N 0 39 48 0 0
      -39 h\n.8 g 4110 3190 N 0 39 49 0 0 -39 h\n.8 g 4061 3190 N 0 39 49 0 0
      -39 h\n.8 g 4013 3190 N 0 39 48 0 0 -39 h\n.8 g 3964 3190 N 0 39 49 0 0
      -39 h\n.8 g 3915 3190 N 0 39 49 0 0 -39 h\n.8 g 3867 3190 N 0 39 48 0 0
      -39 h\n.8 g 3818 3190 N 0 39 49 0 0 -39 h\n.8 g 3770 3190 N 0 39 48 0 0
      -39 h\n.8 g 3721 3190 N 0 39 49 0 0 -39 h\n.8 g 3672 3190 N 0 39 49 0 0
      -39 h\n.8 g 3624 3190 N 0 39 48 0 0 -39 h\n.8 g 3575 3190 N 0 39 49 0 0
      -39 h\n.8 g 3527 3190 N 0 39 48 0 0 -39 h\n.8 g 3478 3190 N 0 39 49 0 0
      -39 h\n.8 g 3429 3190 N 0 39 49 0 0 -39 h\n.8 g 3381 3190 N 0 39 48 0 0
      -39 h\n.8 g 3332 3190 N 0 39 49 0 0 -39 h\n.8 g 3284 3190 N 0 39 48 0 0
      -39 h\n.8 g 3235 3190 N 0 39 49 0 0 -39 h\n.8 g 3186 3190 N 0 39 49 0 0
      -39 h\n.8 g 3138 3190 N 0 39 48 0 0 -39 h\n.8 g 3089 3190 N 0 39 49 0 0
      -39 h\n.8 g 3040 3190 N 0 39 49 0 0 -39 h\n.8 g 2992 3190 N 0 39 48 0 0
      -39 h\n.8 g 2943 3190 N 0 39 49 0 0 -39 h\n.8 g 2895 3190 N 0 39 48 0 0
      -39 h\n.8 g 2846 3190 N 0 39 49 0 0 -39 h\n.8 g 2797 3190 N 0 39 49 0 0
      -39 h\n.8 g 2749 3190 N 0 39 48 0 0 -39 h\n.8 g 2700 3190 N 0 39 49 0 0
      -39 h\n.8 g 2652 3190 N 0 39 48 0 0 -39 h\n.8 g 2603 3190 N 0 39 49 0 0
      -39 h\n.8 g 2554 3190 N 0 39 49 0 0 -39 h\n.8 g 2506 3190 N 0 39 48 0 0
      -39 h\n.8 g 2457 3190 N 0 39 49 0 0 -39 h\n.8 g 2409 3190 N 0 39 48 0 0
      -39 h\n.9 g 2360 3190 N 0 39 49 0 0 -39 h\n1 g 2311 3190 N 0 39 49 0 0
      -39 h\n1 g 2263 3190 N 0 39 48 0 0 -39 h\n1 g 2214 3190 N 0 39 49 0 0
      -39 h\n1 g 2165 3190 N 0 39 49 0 0 -39 h\n1 g 2117 3190 N 0 39 48 0 0
      -39 h\n1 g 2068 3190 N 0 39 49 0 0 -39 h\n1 g 2020 3190 N 0 39 48 0 0
      -39 h\n1 g 1971 3190 N 0 39 49 0 0 -39 h\n1 g 1922 3190 N 0 39 49 0 0
      -39 h\n1 g 1874 3190 N 0 39 48 0 0 -39 h\n1 g 1825 3190 N 0 39 49 0 0
      -39 h\n1 g 1777 3190 N 0 39 48 0 0 -39 h\n1 g 1728 3190 N 0 39 49 0 0
      -39 h\n1 g 1679 3190 N 0 39 49 0 0 -39 h\n1 g 1631 3190 N 0 39 48 0 0
      -39 h\n1 g 1582 3190 N 0 39 49 0 0 -39 h\n1 g 1534 3190 N 0 39 48 0 0
      -39 h\n1 g 1485 3190 N 0 39 49 0 0 -39 h\n1 g 1436 3190 N 0 39 49 0 0
      -39 h\n1 g 1388 3190 N 0 39 48 0 0 -39 h\n1 g 1339 3190 N 0 39 49 0 0
      -39 h\n1 g 1290 3190 N 0 39 49 0 0 -39 h\n1 g 1242 3190 N 0 39 48 0 0
      -39 h\n1 g 1193 3190 N 0 39 49 0 0 -39 h\n1 g 5957 3151 N 0 38 49 0 0
      -38 h\n1 g 5909 3151 N 0 38 48 0 0 -38 h\n1 g 5860 3151 N 0 38 49 0 0
      -38 h\n1 g 5811 3151 N 0 38 49 0 0 -38 h\n1 g 5763 3151 N 0 38 48 0 0
      -38 h\n1 g 5714 3151 N 0 38 49 0 0 -38 h\n1 g 5665 3151 N 0 38 49 0 0
      -38 h\n1 g 5617 3151 N 0 38 48 0 0 -38 h\n1 g 5568 3151 N 0 38 49 0 0
      -38 h\n1 g 5520 3151 N 0 38 48 0 0 -38 h\n1 g 5471 3151 N 0 38 49 0 0
      -38 h\n1 g 5422 3151 N 0 38 49 0 0 -38 h\n1 g 5374 3151 N 0 38 48 0 0
      -38 h\n1 g 5325 3151 N 0 38 49 0 0 -38 h\n1 g 5277 3151 N 0 38 48 0 0
      -38 h\n1 g 5228 3151 N 0 38 49 0 0 -38 h\n1 g 5179 3151 N 0 38 49 0 0
      -38 h\n1 g 5131 3151 N 0 38 48 0 0 -38 h\n1 g 5082 3151 N 0 38 49 0 0
      -38 h\n1 g 5034 3151 N 0 38 48 0 0 -38 h\n1 g 4985 3151 N 0 38 49 0 0
      -38 h\n1 g 4936 3151 N 0 38 49 0 0 -38 h\n1 g 4888 3151 N 0 38 48 0 0
      -38 h\n1 g 4839 3151 N 0 38 49 0 0 -38 h\n.9 g 4790 3151 N 0 38 49 0 0
      -38 h\n.8 g 4742 3151 N 0 38 48 0 0 -38 h\n.8 g 4693 3151 N 0 38 49 0 0
      -38 h\n.8 g 4645 3151 N 0 38 48 0 0 -38 h\n.8 g 4596 3151 N 0 38 49 0 0
      -38 h\n.8 g 4547 3151 N 0 38 49 0 0 -38 h\n.8 g 4499 3151 N 0 38 48 0 0
      -38 h\n.8 g 4450 3151 N 0 38 49 0 0 -38 h\n.8 g 4402 3151 N 0 38 48 0 0
      -38 h\n.8 g 4353 3151 N 0 38 49 0 0 -38 h\n.8 g 4304 3151 N 0 38 49 0 0
      -38 h\n.8 g 4256 3151 N 0 38 48 0 0 -38 h\n.8 g 4207 3151 N 0 38 49 0 0
      -38 h\n.8 g 4159 3151 N 0 38 48 0 0 -38 h\n.8 g 4110 3151 N 0 38 49 0 0
      -38 h\n.8 g 4061 3151 N 0 38 49 0 0 -38 h\n.8 g 4013 3151 N 0 38 48 0 0
      -38 h\n.8 g 3964 3151 N 0 38 49 0 0 -38 h\n.8 g 3915 3151 N 0 38 49 0 0
      -38 h\n.8 g 3867 3151 N 0 38 48 0 0 -38 h\n.8 g 3818 3151 N 0 38 49 0 0
      -38 h\n.8 g 3770 3151 N 0 38 48 0 0 -38 h\n.8 g 3721 3151 N 0 38 49 0 0
      -38 h\n.8 g 3672 3151 N 0 38 49 0 0 -38 h\n.8 g 3624 3151 N 0 38 48 0 0
      -38 h\n.8 g 3575 3151 N 0 38 49 0 0 -38 h\n.8 g 3527 3151 N 0 38 48 0 0
      -38 h\n.8 g 3478 3151 N 0 38 49 0 0 -38 h\n.8 g 3429 3151 N 0 38 49 0 0
      -38 h\n.8 g 3381 3151 N 0 38 48 0 0 -38 h\n.8 g 3332 3151 N 0 38 49 0 0
      -38 h\n.8 g 3284 3151 N 0 38 48 0 0 -38 h\n.8 g 3235 3151 N 0 38 49 0 0
      -38 h\n.8 g 3186 3151 N 0 38 49 0 0 -38 h\n.8 g 3138 3151 N 0 38 48 0 0
      -38 h\n.8 g 3089 3151 N 0 38 49 0 0 -38 h\n.8 g 3040 3151 N 0 38 49 0 0
      -38 h\n.8 g 2992 3151 N 0 38 48 0 0 -38 h\n.8 g 2943 3151 N 0 38 49 0 0
      -38 h\n.8 g 2895 3151 N 0 38 48 0 0 -38 h\n.8 g 2846 3151 N 0 38 49 0 0
      -38 h\n.8 g 2797 3151 N 0 38 49 0 0 -38 h\n.8 g 2749 3151 N 0 38 48 0 0
      -38 h\n.8 g 2700 3151 N 0 38 49 0 0 -38 h\n.8 g 2652 3151 N 0 38 48 0 0
      -38 h\n.8 g 2603 3151 N 0 38 49 0 0 -38 h\n.8 g 2554 3151 N 0 38 49 0 0
      -38 h\n.8 g 2506 3151 N 0 38 48 0 0 -38 h\n.8 g 2457 3151 N 0 38 49 0 0
      -38 h\n.8 g 2409 3151 N 0 38 48 0 0 -38 h\n.9 g 2360 3151 N 0 38 49 0 0
      -38 h\n1 g 2311 3151 N 0 38 49 0 0 -38 h\n1 g 2263 3151 N 0 38 48 0 0
      -38 h\n1 g 2214 3151 N 0 38 49 0 0 -38 h\n1 g 2165 3151 N 0 38 49 0 0
      -38 h\n1 g 2117 3151 N 0 38 48 0 0 -38 h\n1 g 2068 3151 N 0 38 49 0 0
      -38 h\n1 g 2020 3151 N 0 38 48 0 0 -38 h\n1 g 1971 3151 N 0 38 49 0 0
      -38 h\n1 g 1922 3151 N 0 38 49 0 0 -38 h\n1 g 1874 3151 N 0 38 48 0 0
      -38 h\n1 g 1825 3151 N 0 38 49 0 0 -38 h\n1 g 1777 3151 N 0 38 48 0 0
      -38 h\n1 g 1728 3151 N 0 38 49 0 0 -38 h\n1 g 1679 3151 N 0 38 49 0 0
      -38 h\n1 g 1631 3151 N 0 38 48 0 0 -38 h\n1 g 1582 3151 N 0 38 49 0 0
      -38 h\n1 g 1534 3151 N 0 38 48 0 0 -38 h\n1 g 1485 3151 N 0 38 49 0 0
      -38 h\n1 g 1436 3151 N 0 38 49 0 0 -38 h\n1 g 1388 3151 N 0 38 48 0 0
      -38 h\n1 g 1339 3151 N 0 38 49 0 0 -38 h\n1 g 1290 3151 N 0 38 49 0 0
      -38 h\n1 g 1242 3151 N 0 38 48 0 0 -38 h\n1 g 1193 3151 N 0 38 49 0 0
      -38 h\n1 g 5957 3113 N 0 39 49 0 0 -39 h\n1 g 5909 3113 N 0 39 48 0 0
      -39 h\n1 g 5860 3113 N 0 39 49 0 0 -39 h\n1 g 5811 3113 N 0 39 49 0 0
      -39 h\n1 g 5763 3113 N 0 39 48 0 0 -39 h\n1 g 5714 3113 N 0 39 49 0 0
      -39 h\n1 g 5665 3113 N 0 39 49 0 0 -39 h\n1 g 5617 3113 N 0 39 48 0 0
      -39 h\n1 g 5568 3113 N 0 39 49 0 0 -39 h\n1 g 5520 3113 N 0 39 48 0 0
      -39 h\n1 g 5471 3113 N 0 39 49 0 0 -39 h\n1 g 5422 3113 N 0 39 49 0 0
      -39 h\n1 g 5374 3113 N 0 39 48 0 0 -39 h\n1 g 5325 3113 N 0 39 49 0 0
      -39 h\n1 g 5277 3113 N 0 39 48 0 0 -39 h\n1 g 5228 3113 N 0 39 49 0 0
      -39 h\n1 g 5179 3113 N 0 39 49 0 0 -39 h\n1 g 5131 3113 N 0 39 48 0 0
      -39 h\n1 g 5082 3113 N 0 39 49 0 0 -39 h\n1 g 5034 3113 N 0 39 48 0 0
      -39 h\n1 g 4985 3113 N 0 39 49 0 0 -39 h\n1 g 4936 3113 N 0 39 49 0 0
      -39 h\n1 g 4888 3113 N 0 39 48 0 0 -39 h\n1 g 4839 3113 N 0 39 49 0 0
      -39 h\n.9 g 4790 3113 N 0 39 49 0 0 -39 h\n.8 g 4742 3113 N 0 39 48 0 0
      -39 h\n.8 g 4693 3113 N 0 39 49 0 0 -39 h\n.8 g 4645 3113 N 0 39 48 0 0
      -39 h\n.8 g 4596 3113 N 0 39 49 0 0 -39 h\n.8 g 4547 3113 N 0 39 49 0 0
      -39 h\n.8 g 4499 3113 N 0 39 48 0 0 -39 h\n.8 g 4450 3113 N 0 39 49 0 0
      -39 h\n.8 g 4402 3113 N 0 39 48 0 0 -39 h\n.8 g 4353 3113 N 0 39 49 0 0
      -39 h\n.8 g 4304 3113 N 0 39 49 0 0 -39 h\n.8 g 4256 3113 N 0 39 48 0 0
      -39 h\n.8 g 4207 3113 N 0 39 49 0 0 -39 h\n.8 g 4159 3113 N 0 39 48 0 0
      -39 h\n.8 g 4110 3113 N 0 39 49 0 0 -39 h\n.8 g 4061 3113 N 0 39 49 0 0
      -39 h\n.8 g 4013 3113 N 0 39 48 0 0 -39 h\n.8 g 3964 3113 N 0 39 49 0 0
      -39 h\n.8 g 3915 3113 N 0 39 49 0 0 -39 h\n.8 g 3867 3113 N 0 39 48 0 0
      -39 h\n.8 g 3818 3113 N 0 39 49 0 0 -39 h\n.8 g 3770 3113 N 0 39 48 0 0
      -39 h\n.8 g 3721 3113 N 0 39 49 0 0 -39 h\n.8 g 3672 3113 N 0 39 49 0 0
      -39 h\n.8 g 3624 3113 N 0 39 48 0 0 -39 h\n.8 g 3575 3113 N 0 39 49 0 0
      -39 h\n.8 g 3527 3113 N 0 39 48 0 0 -39 h\n.8 g 3478 3113 N 0 39 49 0 0
      -39 h\n.8 g 3429 3113 N 0 39 49 0 0 -39 h\n.8 g 3381 3113 N 0 39 48 0 0
      -39 h\n.8 g 3332 3113 N 0 39 49 0 0 -39 h\n.8 g 3284 3113 N 0 39 48 0 0
      -39 h\n.8 g 3235 3113 N 0 39 49 0 0 -39 h\n.8 g 3186 3113 N 0 39 49 0 0
      -39 h\n.8 g 3138 3113 N 0 39 48 0 0 -39 h\n.8 g 3089 3113 N 0 39 49 0 0
      -39 h\n.8 g 3040 3113 N 0 39 49 0 0 -39 h\n.8 g 2992 3113 N 0 39 48 0 0
      -39 h\n.8 g 2943 3113 N 0 39 49 0 0 -39 h\n.8 g 2895 3113 N 0 39 48 0 0
      -39 h\n.8 g 2846 3113 N 0 39 49 0 0 -39 h\n.8 g 2797 3113 N 0 39 49 0 0
      -39 h\n.8 g 2749 3113 N 0 39 48 0 0 -39 h\n.8 g 2700 3113 N 0 39 49 0 0
      -39 h\n.8 g 2652 3113 N 0 39 48 0 0 -39 h\n.8 g 2603 3113 N 0 39 49 0 0
      -39 h\n.8 g 2554 3113 N 0 39 49 0 0 -39 h\n.8 g 2506 3113 N 0 39 48 0 0
      -39 h\n.8 g 2457 3113 N 0 39 49 0 0 -39 h\n.8 g 2409 3113 N 0 39 48 0 0
      -39 h\n.9 g 2360 3113 N 0 39 49 0 0 -39 h\n1 g 2311 3113 N 0 39 49 0 0
      -39 h\n1 g 2263 3113 N 0 39 48 0 0 -39 h\n1 g 2214 3113 N 0 39 49 0 0
      -39 h\n1 g 2165 3113 N 0 39 49 0 0 -39 h\n1 g 2117 3113 N 0 39 48 0 0
      -39 h\n1 g 2068 3113 N 0 39 49 0 0 -39 h\n1 g 2020 3113 N 0 39 48 0 0
      -39 h\n1 g 1971 3113 N 0 39 49 0 0 -39 h\n1 g 1922 3113 N 0 39 49 0 0
      -39 h\n1 g 1874 3113 N 0 39 48 0 0 -39 h\n1 g 1825 3113 N 0 39 49 0 0
      -39 h\n1 g 1777 3113 N 0 39 48 0 0 -39 h\n1 g 1728 3113 N 0 39 49 0 0
      -39 h\n1 g 1679 3113 N 0 39 49 0 0 -39 h\n1 g 1631 3113 N 0 39 48 0 0
      -39 h\n1 g 1582 3113 N 0 39 49 0 0 -39 h\n1 g 1534 3113 N 0 39 48 0 0
      -39 h\n1 g 1485 3113 N 0 39 49 0 0 -39 h\n1 g 1436 3113 N 0 39 49 0 0
      -39 h\n1 g 1388 3113 N 0 39 48 0 0 -39 h\n1 g 1339 3113 N 0 39 49 0 0
      -39 h\n1 g 1290 3113 N 0 39 49 0 0 -39 h\n1 g 1242 3113 N 0 39 48 0 0
      -39 h\n1 g 1193 3113 N 0 39 49 0 0 -39 h\n1 g 5957 3074 N 0 39 49 0 0
      -39 h\n1 g 5909 3074 N 0 39 48 0 0 -39 h\n1 g 5860 3074 N 0 39 49 0 0
      -39 h\n1 g 5811 3074 N 0 39 49 0 0 -39 h\n1 g 5763 3074 N 0 39 48 0 0
      -39 h\n1 g 5714 3074 N 0 39 49 0 0 -39 h\n1 g 5665 3074 N 0 39 49 0 0
      -39 h\n1 g 5617 3074 N 0 39 48 0 0 -39 h\n1 g 5568 3074 N 0 39 49 0 0
      -39 h\n1 g 5520 3074 N 0 39 48 0 0 -39 h\n1 g 5471 3074 N 0 39 49 0 0
      -39 h\n1 g 5422 3074 N 0 39 49 0 0 -39 h\n1 g 5374 3074 N 0 39 48 0 0
      -39 h\n1 g 5325 3074 N 0 39 49 0 0 -39 h\n1 g 5277 3074 N 0 39 48 0 0
      -39 h\n1 g 5228 3074 N 0 39 49 0 0 -39 h\n1 g 5179 3074 N 0 39 49 0 0
      -39 h\n1 g 5131 3074 N 0 39 48 0 0 -39 h\n1 g 5082 3074 N 0 39 49 0 0
      -39 h\n1 g 5034 3074 N 0 39 48 0 0 -39 h\n1 g 4985 3074 N 0 39 49 0 0
      -39 h\n1 g 4936 3074 N 0 39 49 0 0 -39 h\n1 g 4888 3074 N 0 39 48 0 0
      -39 h\n1 g 4839 3074 N 0 39 49 0 0 -39 h\n.9 g 4790 3074 N 0 39 49 0 0
      -39 h\n.8 g 4742 3074 N 0 39 48 0 0 -39 h\n.8 g 4693 3074 N 0 39 49 0 0
      -39 h\n.8 g 4645 3074 N 0 39 48 0 0 -39 h\n.8 g 4596 3074 N 0 39 49 0 0
      -39 h\n.8 g 4547 3074 N 0 39 49 0 0 -39 h\n.8 g 4499 3074 N 0 39 48 0 0
      -39 h\n.8 g 4450 3074 N 0 39 49 0 0 -39 h\n.8 g 4402 3074 N 0 39 48 0 0
      -39 h\n.8 g 4353 3074 N 0 39 49 0 0 -39 h\n.8 g 4304 3074 N 0 39 49 0 0
      -39 h\n.8 g 4256 3074 N 0 39 48 0 0 -39 h\n.8 g 4207 3074 N 0 39 49 0 0
      -39 h\n.8 g 4159 3074 N 0 39 48 0 0 -39 h\n.8 g 4110 3074 N 0 39 49 0 0
      -39 h\n.8 g 4061 3074 N 0 39 49 0 0 -39 h\n.8 g 4013 3074 N 0 39 48 0 0
      -39 h\n.8 g 3964 3074 N 0 39 49 0 0 -39 h\n.8 g 3915 3074 N 0 39 49 0 0
      -39 h\n.8 g 3867 3074 N 0 39 48 0 0 -39 h\n.8 g 3818 3074 N 0 39 49 0 0
      -39 h\n.8 g 3770 3074 N 0 39 48 0 0 -39 h\n.8 g 3721 3074 N 0 39 49 0 0
      -39 h\n.8 g 3672 3074 N 0 39 49 0 0 -39 h\n.8 g 3624 3074 N 0 39 48 0 0
      -39 h\n.8 g 3575 3074 N 0 39 49 0 0 -39 h\n.8 g 3527 3074 N 0 39 48 0 0
      -39 h\n.8 g 3478 3074 N 0 39 49 0 0 -39 h\n.8 g 3429 3074 N 0 39 49 0 0
      -39 h\n.8 g 3381 3074 N 0 39 48 0 0 -39 h\n.8 g 3332 3074 N 0 39 49 0 0
      -39 h\n.8 g 3284 3074 N 0 39 48 0 0 -39 h\n.8 g 3235 3074 N 0 39 49 0 0
      -39 h\n.8 g 3186 3074 N 0 39 49 0 0 -39 h\n.8 g 3138 3074 N 0 39 48 0 0
      -39 h\n.8 g 3089 3074 N 0 39 49 0 0 -39 h\n.8 g 3040 3074 N 0 39 49 0 0
      -39 h\n.8 g 2992 3074 N 0 39 48 0 0 -39 h\n.8 g 2943 3074 N 0 39 49 0 0
      -39 h\n.8 g 2895 3074 N 0 39 48 0 0 -39 h\n.8 g 2846 3074 N 0 39 49 0 0
      -39 h\n.8 g 2797 3074 N 0 39 49 0 0 -39 h\n.8 g 2749 3074 N 0 39 48 0 0
      -39 h\n.8 g 2700 3074 N 0 39 49 0 0 -39 h\n.8 g 2652 3074 N 0 39 48 0 0
      -39 h\n.8 g 2603 3074 N 0 39 49 0 0 -39 h\n.8 g 2554 3074 N 0 39 49 0 0
      -39 h\n.8 g 2506 3074 N 0 39 48 0 0 -39 h\n.8 g 2457 3074 N 0 39 49 0 0
      -39 h\n.8 g 2409 3074 N 0 39 48 0 0 -39 h\n.9 g 2360 3074 N 0 39 49 0 0
      -39 h\n1 g 2311 3074 N 0 39 49 0 0 -39 h\n1 g 2263 3074 N 0 39 48 0 0
      -39 h\n1 g 2214 3074 N 0 39 49 0 0 -39 h\n1 g 2165 3074 N 0 39 49 0 0
      -39 h\n1 g 2117 3074 N 0 39 48 0 0 -39 h\n1 g 2068 3074 N 0 39 49 0 0
      -39 h\n1 g 2020 3074 N 0 39 48 0 0 -39 h\n1 g 1971 3074 N 0 39 49 0 0
      -39 h\n1 g 1922 3074 N 0 39 49 0 0 -39 h\n1 g 1874 3074 N 0 39 48 0 0
      -39 h\n1 g 1825 3074 N 0 39 49 0 0 -39 h\n1 g 1777 3074 N 0 39 48 0 0
      -39 h\n1 g 1728 3074 N 0 39 49 0 0 -39 h\n1 g 1679 3074 N 0 39 49 0 0
      -39 h\n1 g 1631 3074 N 0 39 48 0 0 -39 h\n1 g 1582 3074 N 0 39 49 0 0
      -39 h\n1 g 1534 3074 N 0 39 48 0 0 -39 h\n1 g 1485 3074 N 0 39 49 0 0
      -39 h\n1 g 1436 3074 N 0 39 49 0 0 -39 h\n1 g 1388 3074 N 0 39 48 0 0
      -39 h\n1 g 1339 3074 N 0 39 49 0 0 -39 h\n1 g 1290 3074 N 0 39 49 0 0
      -39 h\n1 g 1242 3074 N 0 39 48 0 0 -39 h\n1 g 1193 3074 N 0 39 49 0 0
      -39 h\n1 g 5957 3035 N 0 39 49 0 0 -39 h\n1 g 5909 3035 N 0 39 48 0 0
      -39 h\n1 g 5860 3035 N 0 39 49 0 0 -39 h\n1 g 5811 3035 N 0 39 49 0 0
      -39 h\n1 g 5763 3035 N 0 39 48 0 0 -39 h\n1 g 5714 3035 N 0 39 49 0 0
      -39 h\n1 g 5665 3035 N 0 39 49 0 0 -39 h\n1 g 5617 3035 N 0 39 48 0 0
      -39 h\n1 g 5568 3035 N 0 39 49 0 0 -39 h\n1 g 5520 3035 N 0 39 48 0 0
      -39 h\n1 g 5471 3035 N 0 39 49 0 0 -39 h\n1 g 5422 3035 N 0 39 49 0 0
      -39 h\n1 g 5374 3035 N 0 39 48 0 0 -39 h\n1 g 5325 3035 N 0 39 49 0 0
      -39 h\n1 g 5277 3035 N 0 39 48 0 0 -39 h\n1 g 5228 3035 N 0 39 49 0 0
      -39 h\n1 g 5179 3035 N 0 39 49 0 0 -39 h\n1 g 5131 3035 N 0 39 48 0 0
      -39 h\n1 g 5082 3035 N 0 39 49 0 0 -39 h\n1 g 5034 3035 N 0 39 48 0 0
      -39 h\n1 g 4985 3035 N 0 39 49 0 0 -39 h\n1 g 4936 3035 N 0 39 49 0 0
      -39 h\n1 g 4888 3035 N 0 39 48 0 0 -39 h\n1 g 4839 3035 N 0 39 49 0 0
      -39 h\n.95 g 4790 3035 N 0 39 49 0 0 -39 h\n.85 g 4742 3035 N 0 39 48 0
      0 -39 h\n.8 g 4693 3035 N 0 39 49 0 0 -39 h\n.8 g 4645 3035 N 0 39 48 0
      0 -39 h\n.8 g 4596 3035 N 0 39 49 0 0 -39 h\n.8 g 4547 3035 N 0 39 49 0
      0 -39 h\n.8 g 4499 3035 N 0 39 48 0 0 -39 h\n.8 g 4450 3035 N 0 39 49 0
      0 -39 h\n.8 g 4402 3035 N 0 39 48 0 0 -39 h\n.8 g 4353 3035 N 0 39 49 0
      0 -39 h\n.8 g 4304 3035 N 0 39 49 0 0 -39 h\n.8 g 4256 3035 N 0 39 48 0
      0 -39 h\n.8 g 4207 3035 N 0 39 49 0 0 -39 h\n.8 g 4159 3035 N 0 39 48 0
      0 -39 h\n.8 g 4110 3035 N 0 39 49 0 0 -39 h\n.8 g 4061 3035 N 0 39 49 0
      0 -39 h\n.8 g 4013 3035 N 0 39 48 0 0 -39 h\n.8 g 3964 3035 N 0 39 49 0
      0 -39 h\n.8 g 3915 3035 N 0 39 49 0 0 -39 h\n.8 g 3867 3035 N 0 39 48 0
      0 -39 h\n.8 g 3818 3035 N 0 39 49 0 0 -39 h\n.8 g 3770 3035 N 0 39 48 0
      0 -39 h\n.8 g 3721 3035 N 0 39 49 0 0 -39 h\n.8 g 3672 3035 N 0 39 49 0
      0 -39 h\n.8 g 3624 3035 N 0 39 48 0 0 -39 h\n.8 g 3575 3035 N 0 39 49 0
      0 -39 h\n.8 g 3527 3035 N 0 39 48 0 0 -39 h\n.8 g 3478 3035 N 0 39 49 0
      0 -39 h\n.8 g 3429 3035 N 0 39 49 0 0 -39 h\n.8 g 3381 3035 N 0 39 48 0
      0 -39 h\n.8 g 3332 3035 N 0 39 49 0 0 -39 h\n.8 g 3284 3035 N 0 39 48 0
      0 -39 h\n.8 g 3235 3035 N 0 39 49 0 0 -39 h\n.8 g 3186 3035 N 0 39 49 0
      0 -39 h\n.8 g 3138 3035 N 0 39 48 0 0 -39 h\n.8 g 3089 3035 N 0 39 49 0
      0 -39 h\n.8 g 3040 3035 N 0 39 49 0 0 -39 h\n.8 g 2992 3035 N 0 39 48 0
      0 -39 h\n.8 g 2943 3035 N 0 39 49 0 0 -39 h\n.8 g 2895 3035 N 0 39 48 0
      0 -39 h\n.8 g 2846 3035 N 0 39 49 0 0 -39 h\n.8 g 2797 3035 N 0 39 49 0
      0 -39 h\n.8 g 2749 3035 N 0 39 48 0 0 -39 h\n.8 g 2700 3035 N 0 39 49 0
      0 -39 h\n.8 g 2652 3035 N 0 39 48 0 0 -39 h\n.8 g 2603 3035 N 0 39 49 0
      0 -39 h\n.8 g 2554 3035 N 0 39 49 0 0 -39 h\n.8 g 2506 3035 N 0 39 48 0
      0 -39 h\n.8 g 2457 3035 N 0 39 49 0 0 -39 h\n.85 g 2409 3035 N 0 39 48
      0 0 -39 h\n.95 g 2360 3035 N 0 39 49 0 0 -39 h\n1 g 2311 3035 N 0 39 49
      0 0 -39 h\n1 g 2263 3035 N 0 39 48 0 0 -39 h\n1 g 2214 3035 N 0 39 49 0
      0 -39 h\n1 g 2165 3035 N 0 39 49 0 0 -39 h\n1 g 2117 3035 N 0 39 48 0 0
      -39 h\n1 g 2068 3035 N 0 39 49 0 0 -39 h\n1 g 2020 3035 N 0 39 48 0 0
      -39 h\n1 g 1971 3035 N 0 39 49 0 0 -39 h\n1 g 1922 3035 N 0 39 49 0 0
      -39 h\n1 g 1874 3035 N 0 39 48 0 0 -39 h\n1 g 1825 3035 N 0 39 49 0 0
      -39 h\n1 g 1777 3035 N 0 39 48 0 0 -39 h\n1 g 1728 3035 N 0 39 49 0 0
      -39 h\n1 g 1679 3035 N 0 39 49 0 0 -39 h\n1 g 1631 3035 N 0 39 48 0 0
      -39 h\n1 g 1582 3035 N 0 39 49 0 0 -39 h\n1 g 1534 3035 N 0 39 48 0 0
      -39 h\n1 g 1485 3035 N 0 39 49 0 0 -39 h\n1 g 1436 3035 N 0 39 49 0 0
      -39 h\n1 g 1388 3035 N 0 39 48 0 0 -39 h\n1 g 1339 3035 N 0 39 49 0 0
      -39 h\n1 g 1290 3035 N 0 39 49 0 0 -39 h\n1 g 1242 3035 N 0 39 48 0 0
      -39 h\n1 g 1193 3035 N 0 39 49 0 0 -39 h\n1 g 5957 2996 N 0 38 49 0 0
      -38 h\n1 g 5909 2996 N 0 38 48 0 0 -38 h\n1 g 5860 2996 N 0 38 49 0 0
      -38 h\n1 g 5811 2996 N 0 38 49 0 0 -38 h\n1 g 5763 2996 N 0 38 48 0 0
      -38 h\n1 g 5714 2996 N 0 38 49 0 0 -38 h\n1 g 5665 2996 N 0 38 49 0 0
      -38 h\n1 g 5617 2996 N 0 38 48 0 0 -38 h\n1 g 5568 2996 N 0 38 49 0 0
      -38 h\n1 g 5520 2996 N 0 38 48 0 0 -38 h\n1 g 5471 2996 N 0 38 49 0 0
      -38 h\n1 g 5422 2996 N 0 38 49 0 0 -38 h\n1 g 5374 2996 N 0 38 48 0 0
      -38 h\n1 g 5325 2996 N 0 38 49 0 0 -38 h\n1 g 5277 2996 N 0 38 48 0 0
      -38 h\n1 g 5228 2996 N 0 38 49 0 0 -38 h\n1 g 5179 2996 N 0 38 49 0 0
      -38 h\n1 g 5131 2996 N 0 38 48 0 0 -38 h\n1 g 5082 2996 N 0 38 49 0 0
      -38 h\n1 g 5034 2996 N 0 38 48 0 0 -38 h\n1 g 4985 2996 N 0 38 49 0 0
      -38 h\n1 g 4936 2996 N 0 38 49 0 0 -38 h\n1 g 4888 2996 N 0 38 48 0 0
      -38 h\n1 g 4839 2996 N 0 38 49 0 0 -38 h\n1 g 4790 2996 N 0 38 49 0 0
      -38 h\n.9 g 4742 2996 N 0 38 48 0 0 -38 h\n.8 g 4693 2996 N 0 38 49 0 0
      -38 h\n.8 g 4645 2996 N 0 38 48 0 0 -38 h\n.8 g 4596 2996 N 0 38 49 0 0
      -38 h\n.8 g 4547 2996 N 0 38 49 0 0 -38 h\n.8 g 4499 2996 N 0 38 48 0 0
      -38 h\n.8 g 4450 2996 N 0 38 49 0 0 -38 h\n.8 g 4402 2996 N 0 38 48 0 0
      -38 h\n.8 g 4353 2996 N 0 38 49 0 0 -38 h\n.8 g 4304 2996 N 0 38 49 0 0
      -38 h\n.8 g 4256 2996 N 0 38 48 0 0 -38 h\n.8 g 4207 2996 N 0 38 49 0 0
      -38 h\n.8 g 4159 2996 N 0 38 48 0 0 -38 h\n.8 g 4110 2996 N 0 38 49 0 0
      -38 h\n.8 g 4061 2996 N 0 38 49 0 0 -38 h\n.8 g 4013 2996 N 0 38 48 0 0
      -38 h\n.8 g 3964 2996 N 0 38 49 0 0 -38 h\n.8 g 3915 2996 N 0 38 49 0 0
      -38 h\n.8 g 3867 2996 N 0 38 48 0 0 -38 h\n.8 g 3818 2996 N 0 38 49 0 0
      -38 h\n.8 g 3770 2996 N 0 38 48 0 0 -38 h\n.8 g 3721 2996 N 0 38 49 0 0
      -38 h\n.8 g 3672 2996 N 0 38 49 0 0 -38 h\n.8 g 3624 2996 N 0 38 48 0 0
      -38 h\n.8 g 3575 2996 N 0 38 49 0 0 -38 h\n.8 g 3527 2996 N 0 38 48 0 0
      -38 h\n.8 g 3478 2996 N 0 38 49 0 0 -38 h\n.8 g 3429 2996 N 0 38 49 0 0
      -38 h\n.8 g 3381 2996 N 0 38 48 0 0 -38 h\n.8 g 3332 2996 N 0 38 49 0 0
      -38 h\n.8 g 3284 2996 N 0 38 48 0 0 -38 h\n.8 g 3235 2996 N 0 38 49 0 0
      -38 h\n.8 g 3186 2996 N 0 38 49 0 0 -38 h\n.8 g 3138 2996 N 0 38 48 0 0
      -38 h\n.8 g 3089 2996 N 0 38 49 0 0 -38 h\n.8 g 3040 2996 N 0 38 49 0 0
      -38 h\n.8 g 2992 2996 N 0 38 48 0 0 -38 h\n.8 g 2943 2996 N 0 38 49 0 0
      -38 h\n.8 g 2895 2996 N 0 38 48 0 0 -38 h\n.8 g 2846 2996 N 0 38 49 0 0
      -38 h\n.8 g 2797 2996 N 0 38 49 0 0 -38 h\n.8 g 2749 2996 N 0 38 48 0 0
      -38 h\n.8 g 2700 2996 N 0 38 49 0 0 -38 h\n.8 g 2652 2996 N 0 38 48 0 0
      -38 h\n.8 g 2603 2996 N 0 38 49 0 0 -38 h\n.8 g 2554 2996 N 0 38 49 0 0
      -38 h\n.8 g 2506 2996 N 0 38 48 0 0 -38 h\n.8 g 2457 2996 N 0 38 49 0 0
      -38 h\n.9 g 2409 2996 N 0 38 48 0 0 -38 h\n1 g 2360 2996 N 0 38 49 0 0
      -38 h\n1 g 2311 2996 N 0 38 49 0 0 -38 h\n1 g 2263 2996 N 0 38 48 0 0
      -38 h\n1 g 2214 2996 N 0 38 49 0 0 -38 h\n1 g 2165 2996 N 0 38 49 0 0
      -38 h\n1 g 2117 2996 N 0 38 48 0 0 -38 h\n1 g 2068 2996 N 0 38 49 0 0
      -38 h\n1 g 2020 2996 N 0 38 48 0 0 -38 h\n1 g 1971 2996 N 0 38 49 0 0
      -38 h\n1 g 1922 2996 N 0 38 49 0 0 -38 h\n1 g 1874 2996 N 0 38 48 0 0
      -38 h\n1 g 1825 2996 N 0 38 49 0 0 -38 h\n1 g 1777 2996 N 0 38 48 0 0
      -38 h\n1 g 1728 2996 N 0 38 49 0 0 -38 h\n1 g 1679 2996 N 0 38 49 0 0
      -38 h\n1 g 1631 2996 N 0 38 48 0 0 -38 h\n1 g 1582 2996 N 0 38 49 0 0
      -38 h\n1 g 1534 2996 N 0 38 48 0 0 -38 h\n1 g 1485 2996 N 0 38 49 0 0
      -38 h\n1 g 1436 2996 N 0 38 49 0 0 -38 h\n1 g 1388 2996 N 0 38 48 0 0
      -38 h\n1 g 1339 2996 N 0 38 49 0 0 -38 h\n1 g 1290 2996 N 0 38 49 0 0
      -38 h\n1 g 1242 2996 N 0 38 48 0 0 -38 h\n1 g 1193 2996 N 0 38 49 0 0
      -38 h\n1 g 5957 2958 N 0 39 49 0 0 -39 h\n1 g 5909 2958 N 0 39 48 0 0
      -39 h\n1 g 5860 2958 N 0 39 49 0 0 -39 h\n1 g 5811 2958 N 0 39 49 0 0
      -39 h\n1 g 5763 2958 N 0 39 48 0 0 -39 h\n1 g 5714 2958 N 0 39 49 0 0
      -39 h\n1 g 5665 2958 N 0 39 49 0 0 -39 h\n1 g 5617 2958 N 0 39 48 0 0
      -39 h\n1 g 5568 2958 N 0 39 49 0 0 -39 h\n1 g 5520 2958 N 0 39 48 0 0
      -39 h\n1 g 5471 2958 N 0 39 49 0 0 -39 h\n1 g 5422 2958 N 0 39 49 0 0
      -39 h\n1 g 5374 2958 N 0 39 48 0 0 -39 h\n1 g 5325 2958 N 0 39 49 0 0
      -39 h\n1 g 5277 2958 N 0 39 48 0 0 -39 h\n1 g 5228 2958 N 0 39 49 0 0
      -39 h\n1 g 5179 2958 N 0 39 49 0 0 -39 h\n1 g 5131 2958 N 0 39 48 0 0
      -39 h\n1 g 5082 2958 N 0 39 49 0 0 -39 h\n1 g 5034 2958 N 0 39 48 0 0
      -39 h\n1 g 4985 2958 N 0 39 49 0 0 -39 h\n1 g 4936 2958 N 0 39 49 0 0
      -39 h\n1 g 4888 2958 N 0 39 48 0 0 -39 h\n1 g 4839 2958 N 0 39 49 0 0
      -39 h\n1 g 4790 2958 N 0 39 49 0 0 -39 h\n.9 g 4742 2958 N 0 39 48 0 0
      -39 h\n.8 g 4693 2958 N 0 39 49 0 0 -39 h\n.8 g 4645 2958 N 0 39 48 0 0
      -39 h\n.8 g 4596 2958 N 0 39 49 0 0 -39 h\n.8 g 4547 2958 N 0 39 49 0 0
      -39 h\n.8 g 4499 2958 N 0 39 48 0 0 -39 h\n.8 g 4450 2958 N 0 39 49 0 0
      -39 h\n.8 g 4402 2958 N 0 39 48 0 0 -39 h\n.8 g 4353 2958 N 0 39 49 0 0
      -39 h\n.8 g 4304 2958 N 0 39 49 0 0 -39 h\n.8 g 4256 2958 N 0 39 48 0 0
      -39 h\n.8 g 4207 2958 N 0 39 49 0 0 -39 h\n.8 g 4159 2958 N 0 39 48 0 0
      -39 h\n.8 g 4110 2958 N 0 39 49 0 0 -39 h\n.8 g 4061 2958 N 0 39 49 0 0
      -39 h\n.8 g 4013 2958 N 0 39 48 0 0 -39 h\n.8 g 3964 2958 N 0 39 49 0 0
      -39 h\n.8 g 3915 2958 N 0 39 49 0 0 -39 h\n.8 g 3867 2958 N 0 39 48 0 0
      -39 h\n.8 g 3818 2958 N 0 39 49 0 0 -39 h\n.8 g 3770 2958 N 0 39 48 0 0
      -39 h\n.8 g 3721 2958 N 0 39 49 0 0 -39 h\n.8 g 3672 2958 N 0 39 49 0 0
      -39 h\n.8 g 3624 2958 N 0 39 48 0 0 -39 h\n.8 g 3575 2958 N 0 39 49 0 0
      -39 h\n.8 g 3527 2958 N 0 39 48 0 0 -39 h\n.8 g 3478 2958 N 0 39 49 0 0
      -39 h\n.8 g 3429 2958 N 0 39 49 0 0 -39 h\n.8 g 3381 2958 N 0 39 48 0 0
      -39 h\n.8 g 3332 2958 N 0 39 49 0 0 -39 h\n.8 g 3284 2958 N 0 39 48 0 0
      -39 h\n.8 g 3235 2958 N 0 39 49 0 0 -39 h\n.8 g 3186 2958 N 0 39 49 0 0
      -39 h\n.8 g 3138 2958 N 0 39 48 0 0 -39 h\n.8 g 3089 2958 N 0 39 49 0 0
      -39 h\n.8 g 3040 2958 N 0 39 49 0 0 -39 h\n.8 g 2992 2958 N 0 39 48 0 0
      -39 h\n.8 g 2943 2958 N 0 39 49 0 0 -39 h\n.8 g 2895 2958 N 0 39 48 0 0
      -39 h\n.8 g 2846 2958 N 0 39 49 0 0 -39 h\n.8 g 2797 2958 N 0 39 49 0 0
      -39 h\n.8 g 2749 2958 N 0 39 48 0 0 -39 h\n.8 g 2700 2958 N 0 39 49 0 0
      -39 h\n.8 g 2652 2958 N 0 39 48 0 0 -39 h\n.8 g 2603 2958 N 0 39 49 0 0
      -39 h\n.8 g 2554 2958 N 0 39 49 0 0 -39 h\n.8 g 2506 2958 N 0 39 48 0 0
      -39 h\n.8 g 2457 2958 N 0 39 49 0 0 -39 h\n.9 g 2409 2958 N 0 39 48 0 0
      -39 h\n1 g 2360 2958 N 0 39 49 0 0 -39 h\n1 g 2311 2958 N 0 39 49 0 0
      -39 h\n1 g 2263 2958 N 0 39 48 0 0 -39 h\n1 g 2214 2958 N 0 39 49 0 0
      -39 h\n1 g 2165 2958 N 0 39 49 0 0 -39 h\n1 g 2117 2958 N 0 39 48 0 0
      -39 h\n1 g 2068 2958 N 0 39 49 0 0 -39 h\n1 g 2020 2958 N 0 39 48 0 0
      -39 h\n1 g 1971 2958 N 0 39 49 0 0 -39 h\n1 g 1922 2958 N 0 39 49 0 0
      -39 h\n1 g 1874 2958 N 0 39 48 0 0 -39 h\n1 g 1825 2958 N 0 39 49 0 0
      -39 h\n1 g 1777 2958 N 0 39 48 0 0 -39 h\n1 g 1728 2958 N 0 39 49 0 0
      -39 h\n1 g 1679 2958 N 0 39 49 0 0 -39 h\n1 g 1631 2958 N 0 39 48 0 0
      -39 h\n1 g 1582 2958 N 0 39 49 0 0 -39 h\n1 g 1534 2958 N 0 39 48 0 0
      -39 h\n1 g 1485 2958 N 0 39 49 0 0 -39 h\n1 g 1436 2958 N 0 39 49 0 0
      -39 h\n1 g 1388 2958 N 0 39 48 0 0 -39 h\n1 g 1339 2958 N 0 39 49 0 0
      -39 h\n1 g 1290 2958 N 0 39 49 0 0 -39 h\n1 g 1242 2958 N 0 39 48 0 0
      -39 h\n1 g 1193 2958 N 0 39 49 0 0 -39 h\n1 g 5957 2919 N 0 39 49 0 0
      -39 h\n1 g 5909 2919 N 0 39 48 0 0 -39 h\n1 g 5860 2919 N 0 39 49 0 0
      -39 h\n1 g 5811 2919 N 0 39 49 0 0 -39 h\n1 g 5763 2919 N 0 39 48 0 0
      -39 h\n1 g 5714 2919 N 0 39 49 0 0 -39 h\n1 g 5665 2919 N 0 39 49 0 0
      -39 h\n1 g 5617 2919 N 0 39 48 0 0 -39 h\n1 g 5568 2919 N 0 39 49 0 0
      -39 h\n1 g 5520 2919 N 0 39 48 0 0 -39 h\n1 g 5471 2919 N 0 39 49 0 0
      -39 h\n1 g 5422 2919 N 0 39 49 0 0 -39 h\n1 g 5374 2919 N 0 39 48 0 0
      -39 h\n1 g 5325 2919 N 0 39 49 0 0 -39 h\n1 g 5277 2919 N 0 39 48 0 0
      -39 h\n1 g 5228 2919 N 0 39 49 0 0 -39 h\n1 g 5179 2919 N 0 39 49 0 0
      -39 h\n1 g 5131 2919 N 0 39 48 0 0 -39 h\n1 g 5082 2919 N 0 39 49 0 0
      -39 h\n1 g 5034 2919 N 0 39 48 0 0 -39 h\n1 g 4985 2919 N 0 39 49 0 0
      -39 h\n1 g 4936 2919 N 0 39 49 0 0 -39 h\n1 g 4888 2919 N 0 39 48 0 0
      -39 h\n1 g 4839 2919 N 0 39 49 0 0 -39 h\n1 g 4790 2919 N 0 39 49 0 0
      -39 h\n.9 g 4742 2919 N 0 39 48 0 0 -39 h\n.8 g 4693 2919 N 0 39 49 0 0
      -39 h\n.8 g 4645 2919 N 0 39 48 0 0 -39 h\n.8 g 4596 2919 N 0 39 49 0 0
      -39 h\n.8 g 4547 2919 N 0 39 49 0 0 -39 h\n.8 g 4499 2919 N 0 39 48 0 0
      -39 h\n.8 g 4450 2919 N 0 39 49 0 0 -39 h\n.8 g 4402 2919 N 0 39 48 0 0
      -39 h\n.8 g 4353 2919 N 0 39 49 0 0 -39 h\n.8 g 4304 2919 N 0 39 49 0 0
      -39 h\n.8 g 4256 2919 N 0 39 48 0 0 -39 h\n.8 g 4207 2919 N 0 39 49 0 0
      -39 h\n.8 g 4159 2919 N 0 39 48 0 0 -39 h\n.8 g 4110 2919 N 0 39 49 0 0
      -39 h\n.8 g 4061 2919 N 0 39 49 0 0 -39 h\n.8 g 4013 2919 N 0 39 48 0 0
      -39 h\n.8 g 3964 2919 N 0 39 49 0 0 -39 h\n.8 g 3915 2919 N 0 39 49 0 0
      -39 h\n.8 g 3867 2919 N 0 39 48 0 0 -39 h\n.8 g 3818 2919 N 0 39 49 0 0
      -39 h\n.8 g 3770 2919 N 0 39 48 0 0 -39 h\n.8 g 3721 2919 N 0 39 49 0 0
      -39 h\n.8 g 3672 2919 N 0 39 49 0 0 -39 h\n.8 g 3624 2919 N 0 39 48 0 0
      -39 h\n.8 g 3575 2919 N 0 39 49 0 0 -39 h\n.8 g 3527 2919 N 0 39 48 0 0
      -39 h\n.8 g 3478 2919 N 0 39 49 0 0 -39 h\n.8 g 3429 2919 N 0 39 49 0 0
      -39 h\n.8 g 3381 2919 N 0 39 48 0 0 -39 h\n.8 g 3332 2919 N 0 39 49 0 0
      -39 h\n.8 g 3284 2919 N 0 39 48 0 0 -39 h\n.8 g 3235 2919 N 0 39 49 0 0
      -39 h\n.8 g 3186 2919 N 0 39 49 0 0 -39 h\n.8 g 3138 2919 N 0 39 48 0 0
      -39 h\n.8 g 3089 2919 N 0 39 49 0 0 -39 h\n.8 g 3040 2919 N 0 39 49 0 0
      -39 h\n.8 g 2992 2919 N 0 39 48 0 0 -39 h\n.8 g 2943 2919 N 0 39 49 0 0
      -39 h\n.8 g 2895 2919 N 0 39 48 0 0 -39 h\n.8 g 2846 2919 N 0 39 49 0 0
      -39 h\n.8 g 2797 2919 N 0 39 49 0 0 -39 h\n.8 g 2749 2919 N 0 39 48 0 0
      -39 h\n.8 g 2700 2919 N 0 39 49 0 0 -39 h\n.8 g 2652 2919 N 0 39 48 0 0
      -39 h\n.8 g 2603 2919 N 0 39 49 0 0 -39 h\n.8 g 2554 2919 N 0 39 49 0 0
      -39 h\n.8 g 2506 2919 N 0 39 48 0 0 -39 h\n.8 g 2457 2919 N 0 39 49 0 0
      -39 h\n.9 g 2409 2919 N 0 39 48 0 0 -39 h\n1 g 2360 2919 N 0 39 49 0 0
      -39 h\n1 g 2311 2919 N 0 39 49 0 0 -39 h\n1 g 2263 2919 N 0 39 48 0 0
      -39 h\n1 g 2214 2919 N 0 39 49 0 0 -39 h\n1 g 2165 2919 N 0 39 49 0 0
      -39 h\n1 g 2117 2919 N 0 39 48 0 0 -39 h\n1 g 2068 2919 N 0 39 49 0 0
      -39 h\n1 g 2020 2919 N 0 39 48 0 0 -39 h\n1 g 1971 2919 N 0 39 49 0 0
      -39 h\n1 g 1922 2919 N 0 39 49 0 0 -39 h\n1 g 1874 2919 N 0 39 48 0 0
      -39 h\n1 g 1825 2919 N 0 39 49 0 0 -39 h\n1 g 1777 2919 N 0 39 48 0 0
      -39 h\n1 g 1728 2919 N 0 39 49 0 0 -39 h\n1 g 1679 2919 N 0 39 49 0 0
      -39 h\n1 g 1631 2919 N 0 39 48 0 0 -39 h\n1 g 1582 2919 N 0 39 49 0 0
      -39 h\n1 g 1534 2919 N 0 39 48 0 0 -39 h\n1 g 1485 2919 N 0 39 49 0 0
      -39 h\n1 g 1436 2919 N 0 39 49 0 0 -39 h\n1 g 1388 2919 N 0 39 48 0 0
      -39 h\n1 g 1339 2919 N 0 39 49 0 0 -39 h\n1 g 1290 2919 N 0 39 49 0 0
      -39 h\n1 g 1242 2919 N 0 39 48 0 0 -39 h\n1 g 1193 2919 N 0 39 49 0 0
      -39 h\n1 g 5957 2880 N 0 39 49 0 0 -39 h\n1 g 5909 2880 N 0 39 48 0 0
      -39 h\n1 g 5860 2880 N 0 39 49 0 0 -39 h\n1 g 5811 2880 N 0 39 49 0 0
      -39 h\n1 g 5763 2880 N 0 39 48 0 0 -39 h\n1 g 5714 2880 N 0 39 49 0 0
      -39 h\n1 g 5665 2880 N 0 39 49 0 0 -39 h\n1 g 5617 2880 N 0 39 48 0 0
      -39 h\n1 g 5568 2880 N 0 39 49 0 0 -39 h\n1 g 5520 2880 N 0 39 48 0 0
      -39 h\n1 g 5471 2880 N 0 39 49 0 0 -39 h\n1 g 5422 2880 N 0 39 49 0 0
      -39 h\n1 g 5374 2880 N 0 39 48 0 0 -39 h\n1 g 5325 2880 N 0 39 49 0 0
      -39 h\n1 g 5277 2880 N 0 39 48 0 0 -39 h\n1 g 5228 2880 N 0 39 49 0 0
      -39 h\n1 g 5179 2880 N 0 39 49 0 0 -39 h\n1 g 5131 2880 N 0 39 48 0 0
      -39 h\n1 g 5082 2880 N 0 39 49 0 0 -39 h\n1 g 5034 2880 N 0 39 48 0 0
      -39 h\n1 g 4985 2880 N 0 39 49 0 0 -39 h\n1 g 4936 2880 N 0 39 49 0 0
      -39 h\n1 g 4888 2880 N 0 39 48 0 0 -39 h\n1 g 4839 2880 N 0 39 49 0 0
      -39 h\n1 g 4790 2880 N 0 39 49 0 0 -39 h\n.9 g 4742 2880 N 0 39 48 0 0
      -39 h\n.8 g 4693 2880 N 0 39 49 0 0 -39 h\n.8 g 4645 2880 N 0 39 48 0 0
      -39 h\n.8 g 4596 2880 N 0 39 49 0 0 -39 h\n.8 g 4547 2880 N 0 39 49 0 0
      -39 h\n.8 g 4499 2880 N 0 39 48 0 0 -39 h\n.8 g 4450 2880 N 0 39 49 0 0
      -39 h\n.8 g 4402 2880 N 0 39 48 0 0 -39 h\n.8 g 4353 2880 N 0 39 49 0 0
      -39 h\n.8 g 4304 2880 N 0 39 49 0 0 -39 h\n.8 g 4256 2880 N 0 39 48 0 0
      -39 h\n.8 g 4207 2880 N 0 39 49 0 0 -39 h\n.8 g 4159 2880 N 0 39 48 0 0
      -39 h\n.8 g 4110 2880 N 0 39 49 0 0 -39 h\n.8 g 4061 2880 N 0 39 49 0 0
      -39 h\n.8 g 4013 2880 N 0 39 48 0 0 -39 h\n.8 g 3964 2880 N 0 39 49 0 0
      -39 h\n.8 g 3915 2880 N 0 39 49 0 0 -39 h\n.8 g 3867 2880 N 0 39 48 0 0
      -39 h\n.8 g 3818 2880 N 0 39 49 0 0 -39 h\n.8 g 3770 2880 N 0 39 48 0 0
      -39 h\n.8 g 3721 2880 N 0 39 49 0 0 -39 h\n.8 g 3672 2880 N 0 39 49 0 0
      -39 h\n.8 g 3624 2880 N 0 39 48 0 0 -39 h\n.8 g 3575 2880 N 0 39 49 0 0
      -39 h\n.8 g 3527 2880 N 0 39 48 0 0 -39 h\n.8 g 3478 2880 N 0 39 49 0 0
      -39 h\n.8 g 3429 2880 N 0 39 49 0 0 -39 h\n.8 g 3381 2880 N 0 39 48 0 0
      -39 h\n.8 g 3332 2880 N 0 39 49 0 0 -39 h\n.8 g 3284 2880 N 0 39 48 0 0
      -39 h\n.8 g 3235 2880 N 0 39 49 0 0 -39 h\n.8 g 3186 2880 N 0 39 49 0 0
      -39 h\n.8 g 3138 2880 N 0 39 48 0 0 -39 h\n.8 g 3089 2880 N 0 39 49 0 0
      -39 h\n.8 g 3040 2880 N 0 39 49 0 0 -39 h\n.8 g 2992 2880 N 0 39 48 0 0
      -39 h\n.8 g 2943 2880 N 0 39 49 0 0 -39 h\n.8 g 2895 2880 N 0 39 48 0 0
      -39 h\n.8 g 2846 2880 N 0 39 49 0 0 -39 h\n.8 g 2797 2880 N 0 39 49 0 0
      -39 h\n.8 g 2749 2880 N 0 39 48 0 0 -39 h\n.8 g 2700 2880 N 0 39 49 0 0
      -39 h\n.8 g 2652 2880 N 0 39 48 0 0 -39 h\n.8 g 2603 2880 N 0 39 49 0 0
      -39 h\n.8 g 2554 2880 N 0 39 49 0 0 -39 h\n.8 g 2506 2880 N 0 39 48 0 0
      -39 h\n.8 g 2457 2880 N 0 39 49 0 0 -39 h\n.9 g 2409 2880 N 0 39 48 0 0
      -39 h\n1 g 2360 2880 N 0 39 49 0 0 -39 h\n1 g 2311 2880 N 0 39 49 0 0
      -39 h\n1 g 2263 2880 N 0 39 48 0 0 -39 h\n1 g 2214 2880 N 0 39 49 0 0
      -39 h\n1 g 2165 2880 N 0 39 49 0 0 -39 h\n1 g 2117 2880 N 0 39 48 0 0
      -39 h\n1 g 2068 2880 N 0 39 49 0 0 -39 h\n1 g 2020 2880 N 0 39 48 0 0
      -39 h\n1 g 1971 2880 N 0 39 49 0 0 -39 h\n1 g 1922 2880 N 0 39 49 0 0
      -39 h\n1 g 1874 2880 N 0 39 48 0 0 -39 h\n1 g 1825 2880 N 0 39 49 0 0
      -39 h\n1 g 1777 2880 N 0 39 48 0 0 -39 h\n1 g 1728 2880 N 0 39 49 0 0
      -39 h\n1 g 1679 2880 N 0 39 49 0 0 -39 h\n1 g 1631 2880 N 0 39 48 0 0
      -39 h\n1 g 1582 2880 N 0 39 49 0 0 -39 h\n1 g 1534 2880 N 0 39 48 0 0
      -39 h\n1 g 1485 2880 N 0 39 49 0 0 -39 h\n1 g 1436 2880 N 0 39 49 0 0
      -39 h\n1 g 1388 2880 N 0 39 48 0 0 -39 h\n1 g 1339 2880 N 0 39 49 0 0
      -39 h\n1 g 1290 2880 N 0 39 49 0 0 -39 h\n1 g 1242 2880 N 0 39 48 0 0
      -39 h\n1 g 1193 2880 N 0 39 49 0 0 -39 h\n1 g 5957 2841 N 0 38 49 0 0
      -38 h\n1 g 5909 2841 N 0 38 48 0 0 -38 h\n1 g 5860 2841 N 0 38 49 0 0
      -38 h\n1 g 5811 2841 N 0 38 49 0 0 -38 h\n1 g 5763 2841 N 0 38 48 0 0
      -38 h\n1 g 5714 2841 N 0 38 49 0 0 -38 h\n1 g 5665 2841 N 0 38 49 0 0
      -38 h\n1 g 5617 2841 N 0 38 48 0 0 -38 h\n1 g 5568 2841 N 0 38 49 0 0
      -38 h\n1 g 5520 2841 N 0 38 48 0 0 -38 h\n1 g 5471 2841 N 0 38 49 0 0
      -38 h\n1 g 5422 2841 N 0 38 49 0 0 -38 h\n1 g 5374 2841 N 0 38 48 0 0
      -38 h\n1 g 5325 2841 N 0 38 49 0 0 -38 h\n1 g 5277 2841 N 0 38 48 0 0
      -38 h\n1 g 5228 2841 N 0 38 49 0 0 -38 h\n1 g 5179 2841 N 0 38 49 0 0
      -38 h\n1 g 5131 2841 N 0 38 48 0 0 -38 h\n1 g 5082 2841 N 0 38 49 0 0
      -38 h\n1 g 5034 2841 N 0 38 48 0 0 -38 h\n1 g 4985 2841 N 0 38 49 0 0
      -38 h\n1 g 4936 2841 N 0 38 49 0 0 -38 h\n1 g 4888 2841 N 0 38 48 0 0
      -38 h\n1 g 4839 2841 N 0 38 49 0 0 -38 h\n1 g 4790 2841 N 0 38 49 0 0
      -38 h\n.95 g 4742 2841 N 0 38 48 0 0 -38 h\n.85 g 4693 2841 N 0 38 49 0
      0 -38 h\n.8 g 4645 2841 N 0 38 48 0 0 -38 h\n.8 g 4596 2841 N 0 38 49 0
      0 -38 h\n.8 g 4547 2841 N 0 38 49 0 0 -38 h\n.8 g 4499 2841 N 0 38 48 0
      0 -38 h\n.8 g 4450 2841 N 0 38 49 0 0 -38 h\n.8 g 4402 2841 N 0 38 48 0
      0 -38 h\n.8 g 4353 2841 N 0 38 49 0 0 -38 h\n.8 g 4304 2841 N 0 38 49 0
      0 -38 h\n.8 g 4256 2841 N 0 38 48 0 0 -38 h\n.8 g 4207 2841 N 0 38 49 0
      0 -38 h\n.8 g 4159 2841 N 0 38 48 0 0 -38 h\n.8 g 4110 2841 N 0 38 49 0
      0 -38 h\n.8 g 4061 2841 N 0 38 49 0 0 -38 h\n.8 g 4013 2841 N 0 38 48 0
      0 -38 h\n.8 g 3964 2841 N 0 38 49 0 0 -38 h\n.8 g 3915 2841 N 0 38 49 0
      0 -38 h\n.8 g 3867 2841 N 0 38 48 0 0 -38 h\n.8 g 3818 2841 N 0 38 49 0
      0 -38 h\n.8 g 3770 2841 N 0 38 48 0 0 -38 h\n.8 g 3721 2841 N 0 38 49 0
      0 -38 h\n.8 g 3672 2841 N 0 38 49 0 0 -38 h\n.8 g 3624 2841 N 0 38 48 0
      0 -38 h\n.8 g 3575 2841 N 0 38 49 0 0 -38 h\n.8 g 3527 2841 N 0 38 48 0
      0 -38 h\n.8 g 3478 2841 N 0 38 49 0 0 -38 h\n.8 g 3429 2841 N 0 38 49 0
      0 -38 h\n.8 g 3381 2841 N 0 38 48 0 0 -38 h\n.8 g 3332 2841 N 0 38 49 0
      0 -38 h\n.8 g 3284 2841 N 0 38 48 0 0 -38 h\n.8 g 3235 2841 N 0 38 49 0
      0 -38 h\n.8 g 3186 2841 N 0 38 49 0 0 -38 h\n.8 g 3138 2841 N 0 38 48 0
      0 -38 h\n.8 g 3089 2841 N 0 38 49 0 0 -38 h\n.8 g 3040 2841 N 0 38 49 0
      0 -38 h\n.8 g 2992 2841 N 0 38 48 0 0 -38 h\n.8 g 2943 2841 N 0 38 49 0
      0 -38 h\n.8 g 2895 2841 N 0 38 48 0 0 -38 h\n.8 g 2846 2841 N 0 38 49 0
      0 -38 h\n.8 g 2797 2841 N 0 38 49 0 0 -38 h\n.8 g 2749 2841 N 0 38 48 0
      0 -38 h\n.8 g 2700 2841 N 0 38 49 0 0 -38 h\n.8 g 2652 2841 N 0 38 48 0
      0 -38 h\n.8 g 2603 2841 N 0 38 49 0 0 -38 h\n.8 g 2554 2841 N 0 38 49 0
      0 -38 h\n.8 g 2506 2841 N 0 38 48 0 0 -38 h\n.85 g 2457 2841 N 0 38 49
      0 0 -38 h\n.95 g 2409 2841 N 0 38 48 0 0 -38 h\n1 g 2360 2841 N 0 38 49
      0 0 -38 h\n1 g 2311 2841 N 0 38 49 0 0 -38 h\n1 g 2263 2841 N 0 38 48 0
      0 -38 h\n1 g 2214 2841 N 0 38 49 0 0 -38 h\n1 g 2165 2841 N 0 38 49 0 0
      -38 h\n1 g 2117 2841 N 0 38 48 0 0 -38 h\n1 g 2068 2841 N 0 38 49 0 0
      -38 h\n1 g 2020 2841 N 0 38 48 0 0 -38 h\n1 g 1971 2841 N 0 38 49 0 0
      -38 h\n1 g 1922 2841 N 0 38 49 0 0 -38 h\n1 g 1874 2841 N 0 38 48 0 0
      -38 h\n1 g 1825 2841 N 0 38 49 0 0 -38 h\n1 g 1777 2841 N 0 38 48 0 0
      -38 h\n1 g 1728 2841 N 0 38 49 0 0 -38 h\n1 g 1679 2841 N 0 38 49 0 0
      -38 h\n1 g 1631 2841 N 0 38 48 0 0 -38 h\n1 g 1582 2841 N 0 38 49 0 0
      -38 h\n1 g 1534 2841 N 0 38 48 0 0 -38 h\n1 g 1485 2841 N 0 38 49 0 0
      -38 h\n1 g 1436 2841 N 0 38 49 0 0 -38 h\n1 g 1388 2841 N 0 38 48 0 0
      -38 h\n1 g 1339 2841 N 0 38 49 0 0 -38 h\n1 g 1290 2841 N 0 38 49 0 0
      -38 h\n1 g 1242 2841 N 0 38 48 0 0 -38 h\n1 g 1193 2841 N 0 38 49 0 0
      -38 h\n1 g 5957 2803 N 0 39 49 0 0 -39 h\n1 g 5909 2803 N 0 39 48 0 0
      -39 h\n1 g 5860 2803 N 0 39 49 0 0 -39 h\n1 g 5811 2803 N 0 39 49 0 0
      -39 h\n1 g 5763 2803 N 0 39 48 0 0 -39 h\n1 g 5714 2803 N 0 39 49 0 0
      -39 h\n1 g 5665 2803 N 0 39 49 0 0 -39 h\n1 g 5617 2803 N 0 39 48 0 0
      -39 h\n1 g 5568 2803 N 0 39 49 0 0 -39 h\n1 g 5520 2803 N 0 39 48 0 0
      -39 h\n1 g 5471 2803 N 0 39 49 0 0 -39 h\n1 g 5422 2803 N 0 39 49 0 0
      -39 h\n1 g 5374 2803 N 0 39 48 0 0 -39 h\n1 g 5325 2803 N 0 39 49 0 0
      -39 h\n1 g 5277 2803 N 0 39 48 0 0 -39 h\n1 g 5228 2803 N 0 39 49 0 0
      -39 h\n1 g 5179 2803 N 0 39 49 0 0 -39 h\n1 g 5131 2803 N 0 39 48 0 0
      -39 h\n1 g 5082 2803 N 0 39 49 0 0 -39 h\n1 g 5034 2803 N 0 39 48 0 0
      -39 h\n1 g 4985 2803 N 0 39 49 0 0 -39 h\n1 g 4936 2803 N 0 39 49 0 0
      -39 h\n1 g 4888 2803 N 0 39 48 0 0 -39 h\n1 g 4839 2803 N 0 39 49 0 0
      -39 h\n1 g 4790 2803 N 0 39 49 0 0 -39 h\n1 g 4742 2803 N 0 39 48 0 0
      -39 h\n.9 g 4693 2803 N 0 39 49 0 0 -39 h\n.8 g 4645 2803 N 0 39 48 0 0
      -39 h\n.8 g 4596 2803 N 0 39 49 0 0 -39 h\n.8 g 4547 2803 N 0 39 49 0 0
      -39 h\n.8 g 4499 2803 N 0 39 48 0 0 -39 h\n.8 g 4450 2803 N 0 39 49 0 0
      -39 h\n.8 g 4402 2803 N 0 39 48 0 0 -39 h\n.8 g 4353 2803 N 0 39 49 0 0
      -39 h\n.8 g 4304 2803 N 0 39 49 0 0 -39 h\n.8 g 4256 2803 N 0 39 48 0 0
      -39 h\n.8 g 4207 2803 N 0 39 49 0 0 -39 h\n.8 g 4159 2803 N 0 39 48 0 0
      -39 h\n.8 g 4110 2803 N 0 39 49 0 0 -39 h\n.8 g 4061 2803 N 0 39 49 0 0
      -39 h\n.8 g 4013 2803 N 0 39 48 0 0 -39 h\n.8 g 3964 2803 N 0 39 49 0 0
      -39 h\n.8 g 3915 2803 N 0 39 49 0 0 -39 h\n.8 g 3867 2803 N 0 39 48 0 0
      -39 h\n.8 g 3818 2803 N 0 39 49 0 0 -39 h\n.8 g 3770 2803 N 0 39 48 0 0
      -39 h\n.8 g 3721 2803 N 0 39 49 0 0 -39 h\n.8 g 3672 2803 N 0 39 49 0 0
      -39 h\n.8 g 3624 2803 N 0 39 48 0 0 -39 h\n.8 g 3575 2803 N 0 39 49 0 0
      -39 h\n.8 g 3527 2803 N 0 39 48 0 0 -39 h\n.8 g 3478 2803 N 0 39 49 0 0
      -39 h\n.8 g 3429 2803 N 0 39 49 0 0 -39 h\n.8 g 3381 2803 N 0 39 48 0 0
      -39 h\n.8 g 3332 2803 N 0 39 49 0 0 -39 h\n.8 g 3284 2803 N 0 39 48 0 0
      -39 h\n.8 g 3235 2803 N 0 39 49 0 0 -39 h\n.8 g 3186 2803 N 0 39 49 0 0
      -39 h\n.8 g 3138 2803 N 0 39 48 0 0 -39 h\n.8 g 3089 2803 N 0 39 49 0 0
      -39 h\n.8 g 3040 2803 N 0 39 49 0 0 -39 h\n.8 g 2992 2803 N 0 39 48 0 0
      -39 h\n.8 g 2943 2803 N 0 39 49 0 0 -39 h\n.8 g 2895 2803 N 0 39 48 0 0
      -39 h\n.8 g 2846 2803 N 0 39 49 0 0 -39 h\n.8 g 2797 2803 N 0 39 49 0 0
      -39 h\n.8 g 2749 2803 N 0 39 48 0 0 -39 h\n.8 g 2700 2803 N 0 39 49 0 0
      -39 h\n.8 g 2652 2803 N 0 39 48 0 0 -39 h\n.8 g 2603 2803 N 0 39 49 0 0
      -39 h\n.8 g 2554 2803 N 0 39 49 0 0 -39 h\n.8 g 2506 2803 N 0 39 48 0 0
      -39 h\n.9 g 2457 2803 N 0 39 49 0 0 -39 h\n1 g 2409 2803 N 0 39 48 0 0
      -39 h\n1 g 2360 2803 N 0 39 49 0 0 -39 h\n1 g 2311 2803 N 0 39 49 0 0
      -39 h\n1 g 2263 2803 N 0 39 48 0 0 -39 h\n1 g 2214 2803 N 0 39 49 0 0
      -39 h\n1 g 2165 2803 N 0 39 49 0 0 -39 h\n1 g 2117 2803 N 0 39 48 0 0
      -39 h\n1 g 2068 2803 N 0 39 49 0 0 -39 h\n1 g 2020 2803 N 0 39 48 0 0
      -39 h\n1 g 1971 2803 N 0 39 49 0 0 -39 h\n1 g 1922 2803 N 0 39 49 0 0
      -39 h\n1 g 1874 2803 N 0 39 48 0 0 -39 h\n1 g 1825 2803 N 0 39 49 0 0
      -39 h\n1 g 1777 2803 N 0 39 48 0 0 -39 h\n1 g 1728 2803 N 0 39 49 0 0
      -39 h\n1 g 1679 2803 N 0 39 49 0 0 -39 h\n1 g 1631 2803 N 0 39 48 0 0
      -39 h\n1 g 1582 2803 N 0 39 49 0 0 -39 h\n1 g 1534 2803 N 0 39 48 0 0
      -39 h\n1 g 1485 2803 N 0 39 49 0 0 -39 h\n1 g 1436 2803 N 0 39 49 0 0
      -39 h\n1 g 1388 2803 N 0 39 48 0 0 -39 h\n1 g 1339 2803 N 0 39 49 0 0
      -39 h\n1 g 1290 2803 N 0 39 49 0 0 -39 h\n1 g 1242 2803 N 0 39 48 0 0
      -39 h\n1 g 1193 2803 N 0 39 49 0 0 -39 h\n1 g 5957 2764 N 0 39 49 0 0
      -39 h\n1 g 5909 2764 N 0 39 48 0 0 -39 h\n1 g 5860 2764 N 0 39 49 0 0
      -39 h\n1 g 5811 2764 N 0 39 49 0 0 -39 h\n1 g 5763 2764 N 0 39 48 0 0
      -39 h\n1 g 5714 2764 N 0 39 49 0 0 -39 h\n1 g 5665 2764 N 0 39 49 0 0
      -39 h\n1 g 5617 2764 N 0 39 48 0 0 -39 h\n1 g 5568 2764 N 0 39 49 0 0
      -39 h\n1 g 5520 2764 N 0 39 48 0 0 -39 h\n1 g 5471 2764 N 0 39 49 0 0
      -39 h\n1 g 5422 2764 N 0 39 49 0 0 -39 h\n1 g 5374 2764 N 0 39 48 0 0
      -39 h\n1 g 5325 2764 N 0 39 49 0 0 -39 h\n1 g 5277 2764 N 0 39 48 0 0
      -39 h\n1 g 5228 2764 N 0 39 49 0 0 -39 h\n1 g 5179 2764 N 0 39 49 0 0
      -39 h\n1 g 5131 2764 N 0 39 48 0 0 -39 h\n1 g 5082 2764 N 0 39 49 0 0
      -39 h\n1 g 5034 2764 N 0 39 48 0 0 -39 h\n1 g 4985 2764 N 0 39 49 0 0
      -39 h\n1 g 4936 2764 N 0 39 49 0 0 -39 h\n1 g 4888 2764 N 0 39 48 0 0
      -39 h\n1 g 4839 2764 N 0 39 49 0 0 -39 h\n1 g 4790 2764 N 0 39 49 0 0
      -39 h\n1 g 4742 2764 N 0 39 48 0 0 -39 h\n.9 g 4693 2764 N 0 39 49 0 0
      -39 h\n.8 g 4645 2764 N 0 39 48 0 0 -39 h\n.8 g 4596 2764 N 0 39 49 0 0
      -39 h\n.8 g 4547 2764 N 0 39 49 0 0 -39 h\n.8 g 4499 2764 N 0 39 48 0 0
      -39 h\n.8 g 4450 2764 N 0 39 49 0 0 -39 h\n.8 g 4402 2764 N 0 39 48 0 0
      -39 h\n.8 g 4353 2764 N 0 39 49 0 0 -39 h\n.8 g 4304 2764 N 0 39 49 0 0
      -39 h\n.8 g 4256 2764 N 0 39 48 0 0 -39 h\n.8 g 4207 2764 N 0 39 49 0 0
      -39 h\n.8 g 4159 2764 N 0 39 48 0 0 -39 h\n.8 g 4110 2764 N 0 39 49 0 0
      -39 h\n.8 g 4061 2764 N 0 39 49 0 0 -39 h\n.8 g 4013 2764 N 0 39 48 0 0
      -39 h\n.8 g 3964 2764 N 0 39 49 0 0 -39 h\n.8 g 3915 2764 N 0 39 49 0 0
      -39 h\n.8 g 3867 2764 N 0 39 48 0 0 -39 h\n.8 g 3818 2764 N 0 39 49 0 0
      -39 h\n.8 g 3770 2764 N 0 39 48 0 0 -39 h\n.8 g 3721 2764 N 0 39 49 0 0
      -39 h\n.8 g 3672 2764 N 0 39 49 0 0 -39 h\n.8 g 3624 2764 N 0 39 48 0 0
      -39 h\n.8 g 3575 2764 N 0 39 49 0 0 -39 h\n.8 g 3527 2764 N 0 39 48 0 0
      -39 h\n.8 g 3478 2764 N 0 39 49 0 0 -39 h\n.8 g 3429 2764 N 0 39 49 0 0
      -39 h\n.8 g 3381 2764 N 0 39 48 0 0 -39 h\n.8 g 3332 2764 N 0 39 49 0 0
      -39 h\n.8 g 3284 2764 N 0 39 48 0 0 -39 h\n.8 g 3235 2764 N 0 39 49 0 0
      -39 h\n.8 g 3186 2764 N 0 39 49 0 0 -39 h\n.8 g 3138 2764 N 0 39 48 0 0
      -39 h\n.8 g 3089 2764 N 0 39 49 0 0 -39 h\n.8 g 3040 2764 N 0 39 49 0 0
      -39 h\n.8 g 2992 2764 N 0 39 48 0 0 -39 h\n.8 g 2943 2764 N 0 39 49 0 0
      -39 h\n.8 g 2895 2764 N 0 39 48 0 0 -39 h\n.8 g 2846 2764 N 0 39 49 0 0
      -39 h\n.8 g 2797 2764 N 0 39 49 0 0 -39 h\n.8 g 2749 2764 N 0 39 48 0 0
      -39 h\n.8 g 2700 2764 N 0 39 49 0 0 -39 h\n.8 g 2652 2764 N 0 39 48 0 0
      -39 h\n.8 g 2603 2764 N 0 39 49 0 0 -39 h\n.8 g 2554 2764 N 0 39 49 0 0
      -39 h\n.8 g 2506 2764 N 0 39 48 0 0 -39 h\n.9 g 2457 2764 N 0 39 49 0 0
      -39 h\n1 g 2409 2764 N 0 39 48 0 0 -39 h\n1 g 2360 2764 N 0 39 49 0 0
      -39 h\n1 g 2311 2764 N 0 39 49 0 0 -39 h\n1 g 2263 2764 N 0 39 48 0 0
      -39 h\n1 g 2214 2764 N 0 39 49 0 0 -39 h\n1 g 2165 2764 N 0 39 49 0 0
      -39 h\n1 g 2117 2764 N 0 39 48 0 0 -39 h\n1 g 2068 2764 N 0 39 49 0 0
      -39 h\n1 g 2020 2764 N 0 39 48 0 0 -39 h\n1 g 1971 2764 N 0 39 49 0 0
      -39 h\n1 g 1922 2764 N 0 39 49 0 0 -39 h\n1 g 1874 2764 N 0 39 48 0 0
      -39 h\n1 g 1825 2764 N 0 39 49 0 0 -39 h\n1 g 1777 2764 N 0 39 48 0 0
      -39 h\n1 g 1728 2764 N 0 39 49 0 0 -39 h\n1 g 1679 2764 N 0 39 49 0 0
      -39 h\n1 g 1631 2764 N 0 39 48 0 0 -39 h\n1 g 1582 2764 N 0 39 49 0 0
      -39 h\n1 g 1534 2764 N 0 39 48 0 0 -39 h\n1 g 1485 2764 N 0 39 49 0 0
      -39 h\n1 g 1436 2764 N 0 39 49 0 0 -39 h\n1 g 1388 2764 N 0 39 48 0 0
      -39 h\n1 g 1339 2764 N 0 39 49 0 0 -39 h\n1 g 1290 2764 N 0 39 49 0 0
      -39 h\n1 g 1242 2764 N 0 39 48 0 0 -39 h\n1 g 1193 2764 N 0 39 49 0 0
      -39 h\n1 g 5957 2725 N 0 39 49 0 0 -39 h\n1 g 5909 2725 N 0 39 48 0 0
      -39 h\n1 g 5860 2725 N 0 39 49 0 0 -39 h\n1 g 5811 2725 N 0 39 49 0 0
      -39 h\n1 g 5763 2725 N 0 39 48 0 0 -39 h\n1 g 5714 2725 N 0 39 49 0 0
      -39 h\n1 g 5665 2725 N 0 39 49 0 0 -39 h\n1 g 5617 2725 N 0 39 48 0 0
      -39 h\n1 g 5568 2725 N 0 39 49 0 0 -39 h\n1 g 5520 2725 N 0 39 48 0 0
      -39 h\n1 g 5471 2725 N 0 39 49 0 0 -39 h\n1 g 5422 2725 N 0 39 49 0 0
      -39 h\n1 g 5374 2725 N 0 39 48 0 0 -39 h\n1 g 5325 2725 N 0 39 49 0 0
      -39 h\n1 g 5277 2725 N 0 39 48 0 0 -39 h\n1 g 5228 2725 N 0 39 49 0 0
      -39 h\n1 g 5179 2725 N 0 39 49 0 0 -39 h\n1 g 5131 2725 N 0 39 48 0 0
      -39 h\n1 g 5082 2725 N 0 39 49 0 0 -39 h\n1 g 5034 2725 N 0 39 48 0 0
      -39 h\n1 g 4985 2725 N 0 39 49 0 0 -39 h\n1 g 4936 2725 N 0 39 49 0 0
      -39 h\n1 g 4888 2725 N 0 39 48 0 0 -39 h\n1 g 4839 2725 N 0 39 49 0 0
      -39 h\n1 g 4790 2725 N 0 39 49 0 0 -39 h\n1 g 4742 2725 N 0 39 48 0 0
      -39 h\n.9 g 4693 2725 N 0 39 49 0 0 -39 h\n.8 g 4645 2725 N 0 39 48 0 0
      -39 h\n.8 g 4596 2725 N 0 39 49 0 0 -39 h\n.8 g 4547 2725 N 0 39 49 0 0
      -39 h\n.8 g 4499 2725 N 0 39 48 0 0 -39 h\n.8 g 4450 2725 N 0 39 49 0 0
      -39 h\n.8 g 4402 2725 N 0 39 48 0 0 -39 h\n.8 g 4353 2725 N 0 39 49 0 0
      -39 h\n.8 g 4304 2725 N 0 39 49 0 0 -39 h\n.8 g 4256 2725 N 0 39 48 0 0
      -39 h\n.8 g 4207 2725 N 0 39 49 0 0 -39 h\n.8 g 4159 2725 N 0 39 48 0 0
      -39 h\n.8 g 4110 2725 N 0 39 49 0 0 -39 h\n.8 g 4061 2725 N 0 39 49 0 0
      -39 h\n.8 g 4013 2725 N 0 39 48 0 0 -39 h\n.8 g 3964 2725 N 0 39 49 0 0
      -39 h\n.8 g 3915 2725 N 0 39 49 0 0 -39 h\n.8 g 3867 2725 N 0 39 48 0 0
      -39 h\n.8 g 3818 2725 N 0 39 49 0 0 -39 h\n.8 g 3770 2725 N 0 39 48 0 0
      -39 h\n.8 g 3721 2725 N 0 39 49 0 0 -39 h\n.8 g 3672 2725 N 0 39 49 0 0
      -39 h\n.8 g 3624 2725 N 0 39 48 0 0 -39 h\n.8 g 3575 2725 N 0 39 49 0 0
      -39 h\n.8 g 3527 2725 N 0 39 48 0 0 -39 h\n.8 g 3478 2725 N 0 39 49 0 0
      -39 h\n.8 g 3429 2725 N 0 39 49 0 0 -39 h\n.8 g 3381 2725 N 0 39 48 0 0
      -39 h\n.8 g 3332 2725 N 0 39 49 0 0 -39 h\n.8 g 3284 2725 N 0 39 48 0 0
      -39 h\n.8 g 3235 2725 N 0 39 49 0 0 -39 h\n.8 g 3186 2725 N 0 39 49 0 0
      -39 h\n.8 g 3138 2725 N 0 39 48 0 0 -39 h\n.8 g 3089 2725 N 0 39 49 0 0
      -39 h\n.8 g 3040 2725 N 0 39 49 0 0 -39 h\n.8 g 2992 2725 N 0 39 48 0 0
      -39 h\n.8 g 2943 2725 N 0 39 49 0 0 -39 h\n.8 g 2895 2725 N 0 39 48 0 0
      -39 h\n.8 g 2846 2725 N 0 39 49 0 0 -39 h\n.8 g 2797 2725 N 0 39 49 0 0
      -39 h\n.8 g 2749 2725 N 0 39 48 0 0 -39 h\n.8 g 2700 2725 N 0 39 49 0 0
      -39 h\n.8 g 2652 2725 N 0 39 48 0 0 -39 h\n.8 g 2603 2725 N 0 39 49 0 0
      -39 h\n.8 g 2554 2725 N 0 39 49 0 0 -39 h\n.8 g 2506 2725 N 0 39 48 0 0
      -39 h\n.9 g 2457 2725 N 0 39 49 0 0 -39 h\n1 g 2409 2725 N 0 39 48 0 0
      -39 h\n1 g 2360 2725 N 0 39 49 0 0 -39 h\n1 g 2311 2725 N 0 39 49 0 0
      -39 h\n1 g 2263 2725 N 0 39 48 0 0 -39 h\n1 g 2214 2725 N 0 39 49 0 0
      -39 h\n1 g 2165 2725 N 0 39 49 0 0 -39 h\n1 g 2117 2725 N 0 39 48 0 0
      -39 h\n1 g 2068 2725 N 0 39 49 0 0 -39 h\n1 g 2020 2725 N 0 39 48 0 0
      -39 h\n1 g 1971 2725 N 0 39 49 0 0 -39 h\n1 g 1922 2725 N 0 39 49 0 0
      -39 h\n1 g 1874 2725 N 0 39 48 0 0 -39 h\n1 g 1825 2725 N 0 39 49 0 0
      -39 h\n1 g 1777 2725 N 0 39 48 0 0 -39 h\n1 g 1728 2725 N 0 39 49 0 0
      -39 h\n1 g 1679 2725 N 0 39 49 0 0 -39 h\n1 g 1631 2725 N 0 39 48 0 0
      -39 h\n1 g 1582 2725 N 0 39 49 0 0 -39 h\n1 g 1534 2725 N 0 39 48 0 0
      -39 h\n1 g 1485 2725 N 0 39 49 0 0 -39 h\n1 g 1436 2725 N 0 39 49 0 0
      -39 h\n1 g 1388 2725 N 0 39 48 0 0 -39 h\n1 g 1339 2725 N 0 39 49 0 0
      -39 h\n1 g 1290 2725 N 0 39 49 0 0 -39 h\n1 g 1242 2725 N 0 39 48 0 0
      -39 h\n1 g 1193 2725 N 0 39 49 0 0 -39 h\n1 g 5957 2686 N 0 38 49 0 0
      -38 h\n1 g 5909 2686 N 0 38 48 0 0 -38 h\n1 g 5860 2686 N 0 38 49 0 0
      -38 h\n1 g 5811 2686 N 0 38 49 0 0 -38 h\n1 g 5763 2686 N 0 38 48 0 0
      -38 h\n1 g 5714 2686 N 0 38 49 0 0 -38 h\n1 g 5665 2686 N 0 38 49 0 0
      -38 h\n1 g 5617 2686 N 0 38 48 0 0 -38 h\n1 g 5568 2686 N 0 38 49 0 0
      -38 h\n1 g 5520 2686 N 0 38 48 0 0 -38 h\n1 g 5471 2686 N 0 38 49 0 0
      -38 h\n1 g 5422 2686 N 0 38 49 0 0 -38 h\n1 g 5374 2686 N 0 38 48 0 0
      -38 h\n1 g 5325 2686 N 0 38 49 0 0 -38 h\n1 g 5277 2686 N 0 38 48 0 0
      -38 h\n1 g 5228 2686 N 0 38 49 0 0 -38 h\n1 g 5179 2686 N 0 38 49 0 0
      -38 h\n1 g 5131 2686 N 0 38 48 0 0 -38 h\n1 g 5082 2686 N 0 38 49 0 0
      -38 h\n1 g 5034 2686 N 0 38 48 0 0 -38 h\n1 g 4985 2686 N 0 38 49 0 0
      -38 h\n1 g 4936 2686 N 0 38 49 0 0 -38 h\n1 g 4888 2686 N 0 38 48 0 0
      -38 h\n1 g 4839 2686 N 0 38 49 0 0 -38 h\n1 g 4790 2686 N 0 38 49 0 0
      -38 h\n1 g 4742 2686 N 0 38 48 0 0 -38 h\n.95 g 4693 2686 N 0 38 49 0 0
      -38 h\n.85 g 4645 2686 N 0 38 48 0 0 -38 h\n.8 g 4596 2686 N 0 38 49 0
      0 -38 h\n.8 g 4547 2686 N 0 38 49 0 0 -38 h\n.8 g 4499 2686 N 0 38 48 0
      0 -38 h\n.8 g 4450 2686 N 0 38 49 0 0 -38 h\n.8 g 4402 2686 N 0 38 48 0
      0 -38 h\n.8 g 4353 2686 N 0 38 49 0 0 -38 h\n.8 g 4304 2686 N 0 38 49 0
      0 -38 h\n.8 g 4256 2686 N 0 38 48 0 0 -38 h\n.8 g 4207 2686 N 0 38 49 0
      0 -38 h\n.8 g 4159 2686 N 0 38 48 0 0 -38 h\n.8 g 4110 2686 N 0 38 49 0
      0 -38 h\n.8 g 4061 2686 N 0 38 49 0 0 -38 h\n.8 g 4013 2686 N 0 38 48 0
      0 -38 h\n.8 g 3964 2686 N 0 38 49 0 0 -38 h\n.8 g 3915 2686 N 0 38 49 0
      0 -38 h\n.8 g 3867 2686 N 0 38 48 0 0 -38 h\n.8 g 3818 2686 N 0 38 49 0
      0 -38 h\n.8 g 3770 2686 N 0 38 48 0 0 -38 h\n.8 g 3721 2686 N 0 38 49 0
      0 -38 h\n.8 g 3672 2686 N 0 38 49 0 0 -38 h\n.8 g 3624 2686 N 0 38 48 0
      0 -38 h\n.8 g 3575 2686 N 0 38 49 0 0 -38 h\n.8 g 3527 2686 N 0 38 48 0
      0 -38 h\n.8 g 3478 2686 N 0 38 49 0 0 -38 h\n.8 g 3429 2686 N 0 38 49 0
      0 -38 h\n.8 g 3381 2686 N 0 38 48 0 0 -38 h\n.8 g 3332 2686 N 0 38 49 0
      0 -38 h\n.8 g 3284 2686 N 0 38 48 0 0 -38 h\n.8 g 3235 2686 N 0 38 49 0
      0 -38 h\n.8 g 3186 2686 N 0 38 49 0 0 -38 h\n.8 g 3138 2686 N 0 38 48 0
      0 -38 h\n.8 g 3089 2686 N 0 38 49 0 0 -38 h\n.8 g 3040 2686 N 0 38 49 0
      0 -38 h\n.8 g 2992 2686 N 0 38 48 0 0 -38 h\n.8 g 2943 2686 N 0 38 49 0
      0 -38 h\n.8 g 2895 2686 N 0 38 48 0 0 -38 h\n.8 g 2846 2686 N 0 38 49 0
      0 -38 h\n.8 g 2797 2686 N 0 38 49 0 0 -38 h\n.8 g 2749 2686 N 0 38 48 0
      0 -38 h\n.8 g 2700 2686 N 0 38 49 0 0 -38 h\n.8 g 2652 2686 N 0 38 48 0
      0 -38 h\n.8 g 2603 2686 N 0 38 49 0 0 -38 h\n.8 g 2554 2686 N 0 38 49 0
      0 -38 h\n.85 g 2506 2686 N 0 38 48 0 0 -38 h\n.95 g 2457 2686 N 0 38 49
      0 0 -38 h\n1 g 2409 2686 N 0 38 48 0 0 -38 h\n1 g 2360 2686 N 0 38 49 0
      0 -38 h\n1 g 2311 2686 N 0 38 49 0 0 -38 h\n1 g 2263 2686 N 0 38 48 0 0
      -38 h\n1 g 2214 2686 N 0 38 49 0 0 -38 h\n1 g 2165 2686 N 0 38 49 0 0
      -38 h\n1 g 2117 2686 N 0 38 48 0 0 -38 h\n1 g 2068 2686 N 0 38 49 0 0
      -38 h\n1 g 2020 2686 N 0 38 48 0 0 -38 h\n1 g 1971 2686 N 0 38 49 0 0
      -38 h\n1 g 1922 2686 N 0 38 49 0 0 -38 h\n1 g 1874 2686 N 0 38 48 0 0
      -38 h\n1 g 1825 2686 N 0 38 49 0 0 -38 h\n1 g 1777 2686 N 0 38 48 0 0
      -38 h\n1 g 1728 2686 N 0 38 49 0 0 -38 h\n1 g 1679 2686 N 0 38 49 0 0
      -38 h\n1 g 1631 2686 N 0 38 48 0 0 -38 h\n1 g 1582 2686 N 0 38 49 0 0
      -38 h\n1 g 1534 2686 N 0 38 48 0 0 -38 h\n1 g 1485 2686 N 0 38 49 0 0
      -38 h\n1 g 1436 2686 N 0 38 49 0 0 -38 h\n1 g 1388 2686 N 0 38 48 0 0
      -38 h\n1 g 1339 2686 N 0 38 49 0 0 -38 h\n1 g 1290 2686 N 0 38 49 0 0
      -38 h\n1 g 1242 2686 N 0 38 48 0 0 -38 h\n1 g 1193 2686 N 0 38 49 0 0
      -38 h\n1 g 5957 2648 N 0 39 49 0 0 -39 h\n1 g 5909 2648 N 0 39 48 0 0
      -39 h\n1 g 5860 2648 N 0 39 49 0 0 -39 h\n1 g 5811 2648 N 0 39 49 0 0
      -39 h\n1 g 5763 2648 N 0 39 48 0 0 -39 h\n1 g 5714 2648 N 0 39 49 0 0
      -39 h\n1 g 5665 2648 N 0 39 49 0 0 -39 h\n1 g 5617 2648 N 0 39 48 0 0
      -39 h\n1 g 5568 2648 N 0 39 49 0 0 -39 h\n1 g 5520 2648 N 0 39 48 0 0
      -39 h\n1 g 5471 2648 N 0 39 49 0 0 -39 h\n1 g 5422 2648 N 0 39 49 0 0
      -39 h\n1 g 5374 2648 N 0 39 48 0 0 -39 h\n1 g 5325 2648 N 0 39 49 0 0
      -39 h\n1 g 5277 2648 N 0 39 48 0 0 -39 h\n1 g 5228 2648 N 0 39 49 0 0
      -39 h\n1 g 5179 2648 N 0 39 49 0 0 -39 h\n1 g 5131 2648 N 0 39 48 0 0
      -39 h\n1 g 5082 2648 N 0 39 49 0 0 -39 h\n1 g 5034 2648 N 0 39 48 0 0
      -39 h\n1 g 4985 2648 N 0 39 49 0 0 -39 h\n1 g 4936 2648 N 0 39 49 0 0
      -39 h\n1 g 4888 2648 N 0 39 48 0 0 -39 h\n1 g 4839 2648 N 0 39 49 0 0
      -39 h\n1 g 4790 2648 N 0 39 49 0 0 -39 h\n1 g 4742 2648 N 0 39 48 0 0
      -39 h\n1 g 4693 2648 N 0 39 49 0 0 -39 h\n.9 g 4645 2648 N 0 39 48 0 0
      -39 h\n.8 g 4596 2648 N 0 39 49 0 0 -39 h\n.8 g 4547 2648 N 0 39 49 0 0
      -39 h\n.8 g 4499 2648 N 0 39 48 0 0 -39 h\n.8 g 4450 2648 N 0 39 49 0 0
      -39 h\n.8 g 4402 2648 N 0 39 48 0 0 -39 h\n.8 g 4353 2648 N 0 39 49 0 0
      -39 h\n.8 g 4304 2648 N 0 39 49 0 0 -39 h\n.8 g 4256 2648 N 0 39 48 0 0
      -39 h\n.8 g 4207 2648 N 0 39 49 0 0 -39 h\n.8 g 4159 2648 N 0 39 48 0 0
      -39 h\n.8 g 4110 2648 N 0 39 49 0 0 -39 h\n.8 g 4061 2648 N 0 39 49 0 0
      -39 h\n.8 g 4013 2648 N 0 39 48 0 0 -39 h\n.8 g 3964 2648 N 0 39 49 0 0
      -39 h\n.8 g 3915 2648 N 0 39 49 0 0 -39 h\n.8 g 3867 2648 N 0 39 48 0 0
      -39 h\n.8 g 3818 2648 N 0 39 49 0 0 -39 h\n.8 g 3770 2648 N 0 39 48 0 0
      -39 h\n.8 g 3721 2648 N 0 39 49 0 0 -39 h\n.8 g 3672 2648 N 0 39 49 0 0
      -39 h\n.8 g 3624 2648 N 0 39 48 0 0 -39 h\n.8 g 3575 2648 N 0 39 49 0 0
      -39 h\n.8 g 3527 2648 N 0 39 48 0 0 -39 h\n.8 g 3478 2648 N 0 39 49 0 0
      -39 h\n.8 g 3429 2648 N 0 39 49 0 0 -39 h\n.8 g 3381 2648 N 0 39 48 0 0
      -39 h\n.8 g 3332 2648 N 0 39 49 0 0 -39 h\n.8 g 3284 2648 N 0 39 48 0 0
      -39 h\n.8 g 3235 2648 N 0 39 49 0 0 -39 h\n.8 g 3186 2648 N 0 39 49 0 0
      -39 h\n.8 g 3138 2648 N 0 39 48 0 0 -39 h\n.8 g 3089 2648 N 0 39 49 0 0
      -39 h\n.8 g 3040 2648 N 0 39 49 0 0 -39 h\n.8 g 2992 2648 N 0 39 48 0 0
      -39 h\n.8 g 2943 2648 N 0 39 49 0 0 -39 h\n.8 g 2895 2648 N 0 39 48 0 0
      -39 h\n.8 g 2846 2648 N 0 39 49 0 0 -39 h\n.8 g 2797 2648 N 0 39 49 0 0
      -39 h\n.8 g 2749 2648 N 0 39 48 0 0 -39 h\n.8 g 2700 2648 N 0 39 49 0 0
      -39 h\n.8 g 2652 2648 N 0 39 48 0 0 -39 h\n.8 g 2603 2648 N 0 39 49 0 0
      -39 h\n.8 g 2554 2648 N 0 39 49 0 0 -39 h\n.9 g 2506 2648 N 0 39 48 0 0
      -39 h\n1 g 2457 2648 N 0 39 49 0 0 -39 h\n1 g 2409 2648 N 0 39 48 0 0
      -39 h\n1 g 2360 2648 N 0 39 49 0 0 -39 h\n1 g 2311 2648 N 0 39 49 0 0
      -39 h\n1 g 2263 2648 N 0 39 48 0 0 -39 h\n1 g 2214 2648 N 0 39 49 0 0
      -39 h\n1 g 2165 2648 N 0 39 49 0 0 -39 h\n1 g 2117 2648 N 0 39 48 0 0
      -39 h\n1 g 2068 2648 N 0 39 49 0 0 -39 h\n1 g 2020 2648 N 0 39 48 0 0
      -39 h\n1 g 1971 2648 N 0 39 49 0 0 -39 h\n1 g 1922 2648 N 0 39 49 0 0
      -39 h\n1 g 1874 2648 N 0 39 48 0 0 -39 h\n1 g 1825 2648 N 0 39 49 0 0
      -39 h\n1 g 1777 2648 N 0 39 48 0 0 -39 h\n1 g 1728 2648 N 0 39 49 0 0
      -39 h\n1 g 1679 2648 N 0 39 49 0 0 -39 h\n1 g 1631 2648 N 0 39 48 0 0
      -39 h\n1 g 1582 2648 N 0 39 49 0 0 -39 h\n1 g 1534 2648 N 0 39 48 0 0
      -39 h\n1 g 1485 2648 N 0 39 49 0 0 -39 h\n1 g 1436 2648 N 0 39 49 0 0
      -39 h\n1 g 1388 2648 N 0 39 48 0 0 -39 h\n1 g 1339 2648 N 0 39 49 0 0
      -39 h\n1 g 1290 2648 N 0 39 49 0 0 -39 h\n1 g 1242 2648 N 0 39 48 0 0
      -39 h\n1 g 1193 2648 N 0 39 49 0 0 -39 h\n1 g 5957 2609 N 0 39 49 0 0
      -39 h\n1 g 5909 2609 N 0 39 48 0 0 -39 h\n1 g 5860 2609 N 0 39 49 0 0
      -39 h\n1 g 5811 2609 N 0 39 49 0 0 -39 h\n1 g 5763 2609 N 0 39 48 0 0
      -39 h\n1 g 5714 2609 N 0 39 49 0 0 -39 h\n1 g 5665 2609 N 0 39 49 0 0
      -39 h\n1 g 5617 2609 N 0 39 48 0 0 -39 h\n1 g 5568 2609 N 0 39 49 0 0
      -39 h\n1 g 5520 2609 N 0 39 48 0 0 -39 h\n1 g 5471 2609 N 0 39 49 0 0
      -39 h\n1 g 5422 2609 N 0 39 49 0 0 -39 h\n1 g 5374 2609 N 0 39 48 0 0
      -39 h\n1 g 5325 2609 N 0 39 49 0 0 -39 h\n1 g 5277 2609 N 0 39 48 0 0
      -39 h\n1 g 5228 2609 N 0 39 49 0 0 -39 h\n1 g 5179 2609 N 0 39 49 0 0
      -39 h\n1 g 5131 2609 N 0 39 48 0 0 -39 h\n1 g 5082 2609 N 0 39 49 0 0
      -39 h\n1 g 5034 2609 N 0 39 48 0 0 -39 h\n1 g 4985 2609 N 0 39 49 0 0
      -39 h\n1 g 4936 2609 N 0 39 49 0 0 -39 h\n1 g 4888 2609 N 0 39 48 0 0
      -39 h\n1 g 4839 2609 N 0 39 49 0 0 -39 h\n1 g 4790 2609 N 0 39 49 0 0
      -39 h\n1 g 4742 2609 N 0 39 48 0 0 -39 h\n1 g 4693 2609 N 0 39 49 0 0
      -39 h\n.9 g 4645 2609 N 0 39 48 0 0 -39 h\n.8 g 4596 2609 N 0 39 49 0 0
      -39 h\n.8 g 4547 2609 N 0 39 49 0 0 -39 h\n.8 g 4499 2609 N 0 39 48 0 0
      -39 h\n.8 g 4450 2609 N 0 39 49 0 0 -39 h\n.8 g 4402 2609 N 0 39 48 0 0
      -39 h\n.8 g 4353 2609 N 0 39 49 0 0 -39 h\n.8 g 4304 2609 N 0 39 49 0 0
      -39 h\n.8 g 4256 2609 N 0 39 48 0 0 -39 h\n.8 g 4207 2609 N 0 39 49 0 0
      -39 h\n.8 g 4159 2609 N 0 39 48 0 0 -39 h\n.8 g 4110 2609 N 0 39 49 0 0
      -39 h\n.8 g 4061 2609 N 0 39 49 0 0 -39 h\n.8 g 4013 2609 N 0 39 48 0 0
      -39 h\n.8 g 3964 2609 N 0 39 49 0 0 -39 h\n.8 g 3915 2609 N 0 39 49 0 0
      -39 h\n.8 g 3867 2609 N 0 39 48 0 0 -39 h\n.8 g 3818 2609 N 0 39 49 0 0
      -39 h\n.8 g 3770 2609 N 0 39 48 0 0 -39 h\n.8 g 3721 2609 N 0 39 49 0 0
      -39 h\n.8 g 3672 2609 N 0 39 49 0 0 -39 h\n.8 g 3624 2609 N 0 39 48 0 0
      -39 h\n.8 g 3575 2609 N 0 39 49 0 0 -39 h\n.8 g 3527 2609 N 0 39 48 0 0
      -39 h\n.8 g 3478 2609 N 0 39 49 0 0 -39 h\n.8 g 3429 2609 N 0 39 49 0 0
      -39 h\n.8 g 3381 2609 N 0 39 48 0 0 -39 h\n.8 g 3332 2609 N 0 39 49 0 0
      -39 h\n.8 g 3284 2609 N 0 39 48 0 0 -39 h\n.8 g 3235 2609 N 0 39 49 0 0
      -39 h\n.8 g 3186 2609 N 0 39 49 0 0 -39 h\n.8 g 3138 2609 N 0 39 48 0 0
      -39 h\n.8 g 3089 2609 N 0 39 49 0 0 -39 h\n.8 g 3040 2609 N 0 39 49 0 0
      -39 h\n.8 g 2992 2609 N 0 39 48 0 0 -39 h\n.8 g 2943 2609 N 0 39 49 0 0
      -39 h\n.8 g 2895 2609 N 0 39 48 0 0 -39 h\n.8 g 2846 2609 N 0 39 49 0 0
      -39 h\n.8 g 2797 2609 N 0 39 49 0 0 -39 h\n.8 g 2749 2609 N 0 39 48 0 0
      -39 h\n.8 g 2700 2609 N 0 39 49 0 0 -39 h\n.8 g 2652 2609 N 0 39 48 0 0
      -39 h\n.8 g 2603 2609 N 0 39 49 0 0 -39 h\n.8 g 2554 2609 N 0 39 49 0 0
      -39 h\n.9 g 2506 2609 N 0 39 48 0 0 -39 h\n1 g 2457 2609 N 0 39 49 0 0
      -39 h\n1 g 2409 2609 N 0 39 48 0 0 -39 h\n1 g 2360 2609 N 0 39 49 0 0
      -39 h\n1 g 2311 2609 N 0 39 49 0 0 -39 h\n1 g 2263 2609 N 0 39 48 0 0
      -39 h\n1 g 2214 2609 N 0 39 49 0 0 -39 h\n1 g 2165 2609 N 0 39 49 0 0
      -39 h\n1 g 2117 2609 N 0 39 48 0 0 -39 h\n1 g 2068 2609 N 0 39 49 0 0
      -39 h\n1 g 2020 2609 N 0 39 48 0 0 -39 h\n1 g 1971 2609 N 0 39 49 0 0
      -39 h\n1 g 1922 2609 N 0 39 49 0 0 -39 h\n1 g 1874 2609 N 0 39 48 0 0
      -39 h\n1 g 1825 2609 N 0 39 49 0 0 -39 h\n1 g 1777 2609 N 0 39 48 0 0
      -39 h\n1 g 1728 2609 N 0 39 49 0 0 -39 h\n1 g 1679 2609 N 0 39 49 0 0
      -39 h\n1 g 1631 2609 N 0 39 48 0 0 -39 h\n1 g 1582 2609 N 0 39 49 0 0
      -39 h\n1 g 1534 2609 N 0 39 48 0 0 -39 h\n1 g 1485 2609 N 0 39 49 0 0
      -39 h\n1 g 1436 2609 N 0 39 49 0 0 -39 h\n1 g 1388 2609 N 0 39 48 0 0
      -39 h\n1 g 1339 2609 N 0 39 49 0 0 -39 h\n1 g 1290 2609 N 0 39 49 0 0
      -39 h\n1 g 1242 2609 N 0 39 48 0 0 -39 h\n1 g 1193 2609 N 0 39 49 0 0
      -39 h\n1 g 5957 2570 N 0 39 49 0 0 -39 h\n1 g 5909 2570 N 0 39 48 0 0
      -39 h\n1 g 5860 2570 N 0 39 49 0 0 -39 h\n1 g 5811 2570 N 0 39 49 0 0
      -39 h\n1 g 5763 2570 N 0 39 48 0 0 -39 h\n1 g 5714 2570 N 0 39 49 0 0
      -39 h\n1 g 5665 2570 N 0 39 49 0 0 -39 h\n1 g 5617 2570 N 0 39 48 0 0
      -39 h\n1 g 5568 2570 N 0 39 49 0 0 -39 h\n1 g 5520 2570 N 0 39 48 0 0
      -39 h\n1 g 5471 2570 N 0 39 49 0 0 -39 h\n1 g 5422 2570 N 0 39 49 0 0
      -39 h\n1 g 5374 2570 N 0 39 48 0 0 -39 h\n1 g 5325 2570 N 0 39 49 0 0
      -39 h\n1 g 5277 2570 N 0 39 48 0 0 -39 h\n1 g 5228 2570 N 0 39 49 0 0
      -39 h\n1 g 5179 2570 N 0 39 49 0 0 -39 h\n1 g 5131 2570 N 0 39 48 0 0
      -39 h\n1 g 5082 2570 N 0 39 49 0 0 -39 h\n1 g 5034 2570 N 0 39 48 0 0
      -39 h\n1 g 4985 2570 N 0 39 49 0 0 -39 h\n1 g 4936 2570 N 0 39 49 0 0
      -39 h\n1 g 4888 2570 N 0 39 48 0 0 -39 h\n1 g 4839 2570 N 0 39 49 0 0
      -39 h\n1 g 4790 2570 N 0 39 49 0 0 -39 h\n1 g 4742 2570 N 0 39 48 0 0
      -39 h\n1 g 4693 2570 N 0 39 49 0 0 -39 h\n.9 g 4645 2570 N 0 39 48 0 0
      -39 h\n.8 g 4596 2570 N 0 39 49 0 0 -39 h\n.8 g 4547 2570 N 0 39 49 0 0
      -39 h\n.8 g 4499 2570 N 0 39 48 0 0 -39 h\n.8 g 4450 2570 N 0 39 49 0 0
      -39 h\n.8 g 4402 2570 N 0 39 48 0 0 -39 h\n.8 g 4353 2570 N 0 39 49 0 0
      -39 h\n.8 g 4304 2570 N 0 39 49 0 0 -39 h\n.8 g 4256 2570 N 0 39 48 0 0
      -39 h\n.8 g 4207 2570 N 0 39 49 0 0 -39 h\n.8 g 4159 2570 N 0 39 48 0 0
      -39 h\n.8 g 4110 2570 N 0 39 49 0 0 -39 h\n.8 g 4061 2570 N 0 39 49 0 0
      -39 h\n.8 g 4013 2570 N 0 39 48 0 0 -39 h\n.8 g 3964 2570 N 0 39 49 0 0
      -39 h\n.8 g 3915 2570 N 0 39 49 0 0 -39 h\n.8 g 3867 2570 N 0 39 48 0 0
      -39 h\n.8 g 3818 2570 N 0 39 49 0 0 -39 h\n.8 g 3770 2570 N 0 39 48 0 0
      -39 h\n.8 g 3721 2570 N 0 39 49 0 0 -39 h\n.8 g 3672 2570 N 0 39 49 0 0
      -39 h\n.8 g 3624 2570 N 0 39 48 0 0 -39 h\n.8 g 3575 2570 N 0 39 49 0 0
      -39 h\n.8 g 3527 2570 N 0 39 48 0 0 -39 h\n.8 g 3478 2570 N 0 39 49 0 0
      -39 h\n.8 g 3429 2570 N 0 39 49 0 0 -39 h\n.8 g 3381 2570 N 0 39 48 0 0
      -39 h\n.8 g 3332 2570 N 0 39 49 0 0 -39 h\n.8 g 3284 2570 N 0 39 48 0 0
      -39 h\n.8 g 3235 2570 N 0 39 49 0 0 -39 h\n.8 g 3186 2570 N 0 39 49 0 0
      -39 h\n.8 g 3138 2570 N 0 39 48 0 0 -39 h\n.8 g 3089 2570 N 0 39 49 0 0
      -39 h\n.8 g 3040 2570 N 0 39 49 0 0 -39 h\n.8 g 2992 2570 N 0 39 48 0 0
      -39 h\n.8 g 2943 2570 N 0 39 49 0 0 -39 h\n.8 g 2895 2570 N 0 39 48 0 0
      -39 h\n.8 g 2846 2570 N 0 39 49 0 0 -39 h\n.8 g 2797 2570 N 0 39 49 0 0
      -39 h\n.8 g 2749 2570 N 0 39 48 0 0 -39 h\n.8 g 2700 2570 N 0 39 49 0 0
      -39 h\n.8 g 2652 2570 N 0 39 48 0 0 -39 h\n.8 g 2603 2570 N 0 39 49 0 0
      -39 h\n.8 g 2554 2570 N 0 39 49 0 0 -39 h\n.9 g 2506 2570 N 0 39 48 0 0
      -39 h\n1 g 2457 2570 N 0 39 49 0 0 -39 h\n1 g 2409 2570 N 0 39 48 0 0
      -39 h\n1 g 2360 2570 N 0 39 49 0 0 -39 h\n1 g 2311 2570 N 0 39 49 0 0
      -39 h\n1 g 2263 2570 N 0 39 48 0 0 -39 h\n1 g 2214 2570 N 0 39 49 0 0
      -39 h\n1 g 2165 2570 N 0 39 49 0 0 -39 h\n1 g 2117 2570 N 0 39 48 0 0
      -39 h\n1 g 2068 2570 N 0 39 49 0 0 -39 h\n1 g 2020 2570 N 0 39 48 0 0
      -39 h\n1 g 1971 2570 N 0 39 49 0 0 -39 h\n1 g 1922 2570 N 0 39 49 0 0
      -39 h\n1 g 1874 2570 N 0 39 48 0 0 -39 h\n1 g 1825 2570 N 0 39 49 0 0
      -39 h\n1 g 1777 2570 N 0 39 48 0 0 -39 h\n1 g 1728 2570 N 0 39 49 0 0
      -39 h\n1 g 1679 2570 N 0 39 49 0 0 -39 h\n1 g 1631 2570 N 0 39 48 0 0
      -39 h\n1 g 1582 2570 N 0 39 49 0 0 -39 h\n1 g 1534 2570 N 0 39 48 0 0
      -39 h\n1 g 1485 2570 N 0 39 49 0 0 -39 h\n1 g 1436 2570 N 0 39 49 0 0
      -39 h\n1 g 1388 2570 N 0 39 48 0 0 -39 h\n1 g 1339 2570 N 0 39 49 0 0
      -39 h\n1 g 1290 2570 N 0 39 49 0 0 -39 h\n1 g 1242 2570 N 0 39 48 0 0
      -39 h\n1 g 1193 2570 N 0 39 49 0 0 -39 h\n1 g 5957 2531 N 0 38 49 0 0
      -38 h\n1 g 5909 2531 N 0 38 48 0 0 -38 h\n1 g 5860 2531 N 0 38 49 0 0
      -38 h\n1 g 5811 2531 N 0 38 49 0 0 -38 h\n1 g 5763 2531 N 0 38 48 0 0
      -38 h\n1 g 5714 2531 N 0 38 49 0 0 -38 h\n1 g 5665 2531 N 0 38 49 0 0
      -38 h\n1 g 5617 2531 N 0 38 48 0 0 -38 h\n1 g 5568 2531 N 0 38 49 0 0
      -38 h\n1 g 5520 2531 N 0 38 48 0 0 -38 h\n1 g 5471 2531 N 0 38 49 0 0
      -38 h\n1 g 5422 2531 N 0 38 49 0 0 -38 h\n1 g 5374 2531 N 0 38 48 0 0
      -38 h\n1 g 5325 2531 N 0 38 49 0 0 -38 h\n1 g 5277 2531 N 0 38 48 0 0
      -38 h\n1 g 5228 2531 N 0 38 49 0 0 -38 h\n1 g 5179 2531 N 0 38 49 0 0
      -38 h\n1 g 5131 2531 N 0 38 48 0 0 -38 h\n1 g 5082 2531 N 0 38 49 0 0
      -38 h\n1 g 5034 2531 N 0 38 48 0 0 -38 h\n1 g 4985 2531 N 0 38 49 0 0
      -38 h\n1 g 4936 2531 N 0 38 49 0 0 -38 h\n1 g 4888 2531 N 0 38 48 0 0
      -38 h\n1 g 4839 2531 N 0 38 49 0 0 -38 h\n1 g 4790 2531 N 0 38 49 0 0
      -38 h\n1 g 4742 2531 N 0 38 48 0 0 -38 h\n1 g 4693 2531 N 0 38 49 0 0
      -38 h\n.9 g 4645 2531 N 0 38 48 0 0 -38 h\n.8 g 4596 2531 N 0 38 49 0 0
      -38 h\n.8 g 4547 2531 N 0 38 49 0 0 -38 h\n.8 g 4499 2531 N 0 38 48 0 0
      -38 h\n.8 g 4450 2531 N 0 38 49 0 0 -38 h\n.8 g 4402 2531 N 0 38 48 0 0
      -38 h\n.8 g 4353 2531 N 0 38 49 0 0 -38 h\n.8 g 4304 2531 N 0 38 49 0 0
      -38 h\n.8 g 4256 2531 N 0 38 48 0 0 -38 h\n.8 g 4207 2531 N 0 38 49 0 0
      -38 h\n.8 g 4159 2531 N 0 38 48 0 0 -38 h\n.8 g 4110 2531 N 0 38 49 0 0
      -38 h\n.8 g 4061 2531 N 0 38 49 0 0 -38 h\n.8 g 4013 2531 N 0 38 48 0 0
      -38 h\n.8 g 3964 2531 N 0 38 49 0 0 -38 h\n.8 g 3915 2531 N 0 38 49 0 0
      -38 h\n.8 g 3867 2531 N 0 38 48 0 0 -38 h\n.8 g 3818 2531 N 0 38 49 0 0
      -38 h\n.8 g 3770 2531 N 0 38 48 0 0 -38 h\n.8 g 3721 2531 N 0 38 49 0 0
      -38 h\n.8 g 3672 2531 N 0 38 49 0 0 -38 h\n.8 g 3624 2531 N 0 38 48 0 0
      -38 h\n.8 g 3575 2531 N 0 38 49 0 0 -38 h\n.8 g 3527 2531 N 0 38 48 0 0
      -38 h\n.8 g 3478 2531 N 0 38 49 0 0 -38 h\n.8 g 3429 2531 N 0 38 49 0 0
      -38 h\n.8 g 3381 2531 N 0 38 48 0 0 -38 h\n.8 g 3332 2531 N 0 38 49 0 0
      -38 h\n.8 g 3284 2531 N 0 38 48 0 0 -38 h\n.8 g 3235 2531 N 0 38 49 0 0
      -38 h\n.8 g 3186 2531 N 0 38 49 0 0 -38 h\n.8 g 3138 2531 N 0 38 48 0 0
      -38 h\n.8 g 3089 2531 N 0 38 49 0 0 -38 h\n.8 g 3040 2531 N 0 38 49 0 0
      -38 h\n.8 g 2992 2531 N 0 38 48 0 0 -38 h\n.8 g 2943 2531 N 0 38 49 0 0
      -38 h\n.8 g 2895 2531 N 0 38 48 0 0 -38 h\n.8 g 2846 2531 N 0 38 49 0 0
      -38 h\n.8 g 2797 2531 N 0 38 49 0 0 -38 h\n.8 g 2749 2531 N 0 38 48 0 0
      -38 h\n.8 g 2700 2531 N 0 38 49 0 0 -38 h\n.8 g 2652 2531 N 0 38 48 0 0
      -38 h\n.8 g 2603 2531 N 0 38 49 0 0 -38 h\n.8 g 2554 2531 N 0 38 49 0 0
      -38 h\n.9 g 2506 2531 N 0 38 48 0 0 -38 h\n1 g 2457 2531 N 0 38 49 0 0
      -38 h\n1 g 2409 2531 N 0 38 48 0 0 -38 h\n1 g 2360 2531 N 0 38 49 0 0
      -38 h\n1 g 2311 2531 N 0 38 49 0 0 -38 h\n1 g 2263 2531 N 0 38 48 0 0
      -38 h\n1 g 2214 2531 N 0 38 49 0 0 -38 h\n1 g 2165 2531 N 0 38 49 0 0
      -38 h\n1 g 2117 2531 N 0 38 48 0 0 -38 h\n1 g 2068 2531 N 0 38 49 0 0
      -38 h\n1 g 2020 2531 N 0 38 48 0 0 -38 h\n1 g 1971 2531 N 0 38 49 0 0
      -38 h\n1 g 1922 2531 N 0 38 49 0 0 -38 h\n1 g 1874 2531 N 0 38 48 0 0
      -38 h\n1 g 1825 2531 N 0 38 49 0 0 -38 h\n1 g 1777 2531 N 0 38 48 0 0
      -38 h\n1 g 1728 2531 N 0 38 49 0 0 -38 h\n1 g 1679 2531 N 0 38 49 0 0
      -38 h\n1 g 1631 2531 N 0 38 48 0 0 -38 h\n1 g 1582 2531 N 0 38 49 0 0
      -38 h\n1 g 1534 2531 N 0 38 48 0 0 -38 h\n1 g 1485 2531 N 0 38 49 0 0
      -38 h\n1 g 1436 2531 N 0 38 49 0 0 -38 h\n1 g 1388 2531 N 0 38 48 0 0
      -38 h\n1 g 1339 2531 N 0 38 49 0 0 -38 h\n1 g 1290 2531 N 0 38 49 0 0
      -38 h\n1 g 1242 2531 N 0 38 48 0 0 -38 h\n1 g 1193 2531 N 0 38 49 0 0
      -38 h\n1 g 5957 2493 N 0 39 49 0 0 -39 h\n1 g 5909 2493 N 0 39 48 0 0
      -39 h\n1 g 5860 2493 N 0 39 49 0 0 -39 h\n1 g 5811 2493 N 0 39 49 0 0
      -39 h\n1 g 5763 2493 N 0 39 48 0 0 -39 h\n1 g 5714 2493 N 0 39 49 0 0
      -39 h\n1 g 5665 2493 N 0 39 49 0 0 -39 h\n1 g 5617 2493 N 0 39 48 0 0
      -39 h\n1 g 5568 2493 N 0 39 49 0 0 -39 h\n1 g 5520 2493 N 0 39 48 0 0
      -39 h\n1 g 5471 2493 N 0 39 49 0 0 -39 h\n1 g 5422 2493 N 0 39 49 0 0
      -39 h\n1 g 5374 2493 N 0 39 48 0 0 -39 h\n1 g 5325 2493 N 0 39 49 0 0
      -39 h\n1 g 5277 2493 N 0 39 48 0 0 -39 h\n1 g 5228 2493 N 0 39 49 0 0
      -39 h\n1 g 5179 2493 N 0 39 49 0 0 -39 h\n1 g 5131 2493 N 0 39 48 0 0
      -39 h\n1 g 5082 2493 N 0 39 49 0 0 -39 h\n1 g 5034 2493 N 0 39 48 0 0
      -39 h\n1 g 4985 2493 N 0 39 49 0 0 -39 h\n1 g 4936 2493 N 0 39 49 0 0
      -39 h\n1 g 4888 2493 N 0 39 48 0 0 -39 h\n1 g 4839 2493 N 0 39 49 0 0
      -39 h\n1 g 4790 2493 N 0 39 49 0 0 -39 h\n1 g 4742 2493 N 0 39 48 0 0
      -39 h\n1 g 4693 2493 N 0 39 49 0 0 -39 h\n.95 g 4645 2493 N 0 39 48 0 0
      -39 h\n.85 g 4596 2493 N 0 39 49 0 0 -39 h\n.8 g 4547 2493 N 0 39 49 0
      0 -39 h\n.8 g 4499 2493 N 0 39 48 0 0 -39 h\n.8 g 4450 2493 N 0 39 49 0
      0 -39 h\n.8 g 4402 2493 N 0 39 48 0 0 -39 h\n.8 g 4353 2493 N 0 39 49 0
      0 -39 h\n.8 g 4304 2493 N 0 39 49 0 0 -39 h\n.8 g 4256 2493 N 0 39 48 0
      0 -39 h\n.8 g 4207 2493 N 0 39 49 0 0 -39 h\n.8 g 4159 2493 N 0 39 48 0
      0 -39 h\n.8 g 4110 2493 N 0 39 49 0 0 -39 h\n.8 g 4061 2493 N 0 39 49 0
      0 -39 h\n.8 g 4013 2493 N 0 39 48 0 0 -39 h\n.8 g 3964 2493 N 0 39 49 0
      0 -39 h\n.8 g 3915 2493 N 0 39 49 0 0 -39 h\n.8 g 3867 2493 N 0 39 48 0
      0 -39 h\n.8 g 3818 2493 N 0 39 49 0 0 -39 h\n.8 g 3770 2493 N 0 39 48 0
      0 -39 h\n.8 g 3721 2493 N 0 39 49 0 0 -39 h\n.8 g 3672 2493 N 0 39 49 0
      0 -39 h\n.8 g 3624 2493 N 0 39 48 0 0 -39 h\n.8 g 3575 2493 N 0 39 49 0
      0 -39 h\n.8 g 3527 2493 N 0 39 48 0 0 -39 h\n.8 g 3478 2493 N 0 39 49 0
      0 -39 h\n.8 g 3429 2493 N 0 39 49 0 0 -39 h\n.8 g 3381 2493 N 0 39 48 0
      0 -39 h\n.8 g 3332 2493 N 0 39 49 0 0 -39 h\n.8 g 3284 2493 N 0 39 48 0
      0 -39 h\n.8 g 3235 2493 N 0 39 49 0 0 -39 h\n.8 g 3186 2493 N 0 39 49 0
      0 -39 h\n.8 g 3138 2493 N 0 39 48 0 0 -39 h\n.8 g 3089 2493 N 0 39 49 0
      0 -39 h\n.8 g 3040 2493 N 0 39 49 0 0 -39 h\n.8 g 2992 2493 N 0 39 48 0
      0 -39 h\n.8 g 2943 2493 N 0 39 49 0 0 -39 h\n.8 g 2895 2493 N 0 39 48 0
      0 -39 h\n.8 g 2846 2493 N 0 39 49 0 0 -39 h\n.8 g 2797 2493 N 0 39 49 0
      0 -39 h\n.8 g 2749 2493 N 0 39 48 0 0 -39 h\n.8 g 2700 2493 N 0 39 49 0
      0 -39 h\n.8 g 2652 2493 N 0 39 48 0 0 -39 h\n.8 g 2603 2493 N 0 39 49 0
      0 -39 h\n.85 g 2554 2493 N 0 39 49 0 0 -39 h\n.95 g 2506 2493 N 0 39 48
      0 0 -39 h\n1 g 2457 2493 N 0 39 49 0 0 -39 h\n1 g 2409 2493 N 0 39 48 0
      0 -39 h\n1 g 2360 2493 N 0 39 49 0 0 -39 h\n1 g 2311 2493 N 0 39 49 0 0
      -39 h\n1 g 2263 2493 N 0 39 48 0 0 -39 h\n1 g 2214 2493 N 0 39 49 0 0
      -39 h\n1 g 2165 2493 N 0 39 49 0 0 -39 h\n1 g 2117 2493 N 0 39 48 0 0
      -39 h\n1 g 2068 2493 N 0 39 49 0 0 -39 h\n1 g 2020 2493 N 0 39 48 0 0
      -39 h\n1 g 1971 2493 N 0 39 49 0 0 -39 h\n1 g 1922 2493 N 0 39 49 0 0
      -39 h\n1 g 1874 2493 N 0 39 48 0 0 -39 h\n1 g 1825 2493 N 0 39 49 0 0
      -39 h\n1 g 1777 2493 N 0 39 48 0 0 -39 h\n1 g 1728 2493 N 0 39 49 0 0
      -39 h\n1 g 1679 2493 N 0 39 49 0 0 -39 h\n1 g 1631 2493 N 0 39 48 0 0
      -39 h\n1 g 1582 2493 N 0 39 49 0 0 -39 h\n1 g 1534 2493 N 0 39 48 0 0
      -39 h\n1 g 1485 2493 N 0 39 49 0 0 -39 h\n1 g 1436 2493 N 0 39 49 0 0
      -39 h\n1 g 1388 2493 N 0 39 48 0 0 -39 h\n1 g 1339 2493 N 0 39 49 0 0
      -39 h\n1 g 1290 2493 N 0 39 49 0 0 -39 h\n1 g 1242 2493 N 0 39 48 0 0
      -39 h\n1 g 1193 2493 N 0 39 49 0 0 -39 h\n1 g 5957 2454 N 0 39 49 0 0
      -39 h\n1 g 5909 2454 N 0 39 48 0 0 -39 h\n1 g 5860 2454 N 0 39 49 0 0
      -39 h\n1 g 5811 2454 N 0 39 49 0 0 -39 h\n1 g 5763 2454 N 0 39 48 0 0
      -39 h\n1 g 5714 2454 N 0 39 49 0 0 -39 h\n1 g 5665 2454 N 0 39 49 0 0
      -39 h\n1 g 5617 2454 N 0 39 48 0 0 -39 h\n1 g 5568 2454 N 0 39 49 0 0
      -39 h\n1 g 5520 2454 N 0 39 48 0 0 -39 h\n1 g 5471 2454 N 0 39 49 0 0
      -39 h\n1 g 5422 2454 N 0 39 49 0 0 -39 h\n1 g 5374 2454 N 0 39 48 0 0
      -39 h\n1 g 5325 2454 N 0 39 49 0 0 -39 h\n1 g 5277 2454 N 0 39 48 0 0
      -39 h\n1 g 5228 2454 N 0 39 49 0 0 -39 h\n1 g 5179 2454 N 0 39 49 0 0
      -39 h\n1 g 5131 2454 N 0 39 48 0 0 -39 h\n1 g 5082 2454 N 0 39 49 0 0
      -39 h\n1 g 5034 2454 N 0 39 48 0 0 -39 h\n1 g 4985 2454 N 0 39 49 0 0
      -39 h\n1 g 4936 2454 N 0 39 49 0 0 -39 h\n1 g 4888 2454 N 0 39 48 0 0
      -39 h\n1 g 4839 2454 N 0 39 49 0 0 -39 h\n1 g 4790 2454 N 0 39 49 0 0
      -39 h\n1 g 4742 2454 N 0 39 48 0 0 -39 h\n1 g 4693 2454 N 0 39 49 0 0
      -39 h\n1 g 4645 2454 N 0 39 48 0 0 -39 h\n.9 g 4596 2454 N 0 39 49 0 0
      -39 h\n.8 g 4547 2454 N 0 39 49 0 0 -39 h\n.8 g 4499 2454 N 0 39 48 0 0
      -39 h\n.8 g 4450 2454 N 0 39 49 0 0 -39 h\n.8 g 4402 2454 N 0 39 48 0 0
      -39 h\n.8 g 4353 2454 N 0 39 49 0 0 -39 h\n.8 g 4304 2454 N 0 39 49 0 0
      -39 h\n.8 g 4256 2454 N 0 39 48 0 0 -39 h\n.8 g 4207 2454 N 0 39 49 0 0
      -39 h\n.8 g 4159 2454 N 0 39 48 0 0 -39 h\n.8 g 4110 2454 N 0 39 49 0 0
      -39 h\n.8 g 4061 2454 N 0 39 49 0 0 -39 h\n.8 g 4013 2454 N 0 39 48 0 0
      -39 h\n.8 g 3964 2454 N 0 39 49 0 0 -39 h\n.8 g 3915 2454 N 0 39 49 0 0
      -39 h\n.8 g 3867 2454 N 0 39 48 0 0 -39 h\n.8 g 3818 2454 N 0 39 49 0 0
      -39 h\n.8 g 3770 2454 N 0 39 48 0 0 -39 h\n.8 g 3721 2454 N 0 39 49 0 0
      -39 h\n.8 g 3672 2454 N 0 39 49 0 0 -39 h\n.8 g 3624 2454 N 0 39 48 0 0
      -39 h\n.8 g 3575 2454 N 0 39 49 0 0 -39 h\n.8 g 3527 2454 N 0 39 48 0 0
      -39 h\n.8 g 3478 2454 N 0 39 49 0 0 -39 h\n.8 g 3429 2454 N 0 39 49 0 0
      -39 h\n.8 g 3381 2454 N 0 39 48 0 0 -39 h\n.8 g 3332 2454 N 0 39 49 0 0
      -39 h\n.8 g 3284 2454 N 0 39 48 0 0 -39 h\n.8 g 3235 2454 N 0 39 49 0 0
      -39 h\n.8 g 3186 2454 N 0 39 49 0 0 -39 h\n.8 g 3138 2454 N 0 39 48 0 0
      -39 h\n.8 g 3089 2454 N 0 39 49 0 0 -39 h\n.8 g 3040 2454 N 0 39 49 0 0
      -39 h\n.8 g 2992 2454 N 0 39 48 0 0 -39 h\n.8 g 2943 2454 N 0 39 49 0 0
      -39 h\n.8 g 2895 2454 N 0 39 48 0 0 -39 h\n.8 g 2846 2454 N 0 39 49 0 0
      -39 h\n.8 g 2797 2454 N 0 39 49 0 0 -39 h\n.8 g 2749 2454 N 0 39 48 0 0
      -39 h\n.8 g 2700 2454 N 0 39 49 0 0 -39 h\n.8 g 2652 2454 N 0 39 48 0 0
      -39 h\n.8 g 2603 2454 N 0 39 49 0 0 -39 h\n.9 g 2554 2454 N 0 39 49 0 0
      -39 h\n1 g 2506 2454 N 0 39 48 0 0 -39 h\n1 g 2457 2454 N 0 39 49 0 0
      -39 h\n1 g 2409 2454 N 0 39 48 0 0 -39 h\n1 g 2360 2454 N 0 39 49 0 0
      -39 h\n1 g 2311 2454 N 0 39 49 0 0 -39 h\n1 g 2263 2454 N 0 39 48 0 0
      -39 h\n1 g 2214 2454 N 0 39 49 0 0 -39 h\n1 g 2165 2454 N 0 39 49 0 0
      -39 h\n1 g 2117 2454 N 0 39 48 0 0 -39 h\n1 g 2068 2454 N 0 39 49 0 0
      -39 h\n1 g 2020 2454 N 0 39 48 0 0 -39 h\n1 g 1971 2454 N 0 39 49 0 0
      -39 h\n1 g 1922 2454 N 0 39 49 0 0 -39 h\n1 g 1874 2454 N 0 39 48 0 0
      -39 h\n1 g 1825 2454 N 0 39 49 0 0 -39 h\n1 g 1777 2454 N 0 39 48 0 0
      -39 h\n1 g 1728 2454 N 0 39 49 0 0 -39 h\n1 g 1679 2454 N 0 39 49 0 0
      -39 h\n1 g 1631 2454 N 0 39 48 0 0 -39 h\n1 g 1582 2454 N 0 39 49 0 0
      -39 h\n1 g 1534 2454 N 0 39 48 0 0 -39 h\n1 g 1485 2454 N 0 39 49 0 0
      -39 h\n1 g 1436 2454 N 0 39 49 0 0 -39 h\n1 g 1388 2454 N 0 39 48 0 0
      -39 h\n1 g 1339 2454 N 0 39 49 0 0 -39 h\n1 g 1290 2454 N 0 39 49 0 0
      -39 h\n1 g 1242 2454 N 0 39 48 0 0 -39 h\n1 g 1193 2454 N 0 39 49 0 0
      -39 h\n1 g 5957 2415 N 0 39 49 0 0 -39 h\n1 g 5909 2415 N 0 39 48 0 0
      -39 h\n1 g 5860 2415 N 0 39 49 0 0 -39 h\n1 g 5811 2415 N 0 39 49 0 0
      -39 h\n1 g 5763 2415 N 0 39 48 0 0 -39 h\n1 g 5714 2415 N 0 39 49 0 0
      -39 h\n1 g 5665 2415 N 0 39 49 0 0 -39 h\n1 g 5617 2415 N 0 39 48 0 0
      -39 h\n1 g 5568 2415 N 0 39 49 0 0 -39 h\n1 g 5520 2415 N 0 39 48 0 0
      -39 h\n1 g 5471 2415 N 0 39 49 0 0 -39 h\n1 g 5422 2415 N 0 39 49 0 0
      -39 h\n1 g 5374 2415 N 0 39 48 0 0 -39 h\n1 g 5325 2415 N 0 39 49 0 0
      -39 h\n1 g 5277 2415 N 0 39 48 0 0 -39 h\n1 g 5228 2415 N 0 39 49 0 0
      -39 h\n1 g 5179 2415 N 0 39 49 0 0 -39 h\n1 g 5131 2415 N 0 39 48 0 0
      -39 h\n1 g 5082 2415 N 0 39 49 0 0 -39 h\n1 g 5034 2415 N 0 39 48 0 0
      -39 h\n1 g 4985 2415 N 0 39 49 0 0 -39 h\n1 g 4936 2415 N 0 39 49 0 0
      -39 h\n1 g 4888 2415 N 0 39 48 0 0 -39 h\n1 g 4839 2415 N 0 39 49 0 0
      -39 h\n1 g 4790 2415 N 0 39 49 0 0 -39 h\n1 g 4742 2415 N 0 39 48 0 0
      -39 h\n1 g 4693 2415 N 0 39 49 0 0 -39 h\n1 g 4645 2415 N 0 39 48 0 0
      -39 h\n.9 g 4596 2415 N 0 39 49 0 0 -39 h\n.8 g 4547 2415 N 0 39 49 0 0
      -39 h\n.8 g 4499 2415 N 0 39 48 0 0 -39 h\n.8 g 4450 2415 N 0 39 49 0 0
      -39 h\n.8 g 4402 2415 N 0 39 48 0 0 -39 h\n.8 g 4353 2415 N 0 39 49 0 0
      -39 h\n.8 g 4304 2415 N 0 39 49 0 0 -39 h\n.8 g 4256 2415 N 0 39 48 0 0
      -39 h\n.8 g 4207 2415 N 0 39 49 0 0 -39 h\n.8 g 4159 2415 N 0 39 48 0 0
      -39 h\n.8 g 4110 2415 N 0 39 49 0 0 -39 h\n.8 g 4061 2415 N 0 39 49 0 0
      -39 h\n.8 g 4013 2415 N 0 39 48 0 0 -39 h\n.8 g 3964 2415 N 0 39 49 0 0
      -39 h\n.8 g 3915 2415 N 0 39 49 0 0 -39 h\n.8 g 3867 2415 N 0 39 48 0 0
      -39 h\n.8 g 3818 2415 N 0 39 49 0 0 -39 h\n.8 g 3770 2415 N 0 39 48 0 0
      -39 h\n.8 g 3721 2415 N 0 39 49 0 0 -39 h\n.8 g 3672 2415 N 0 39 49 0 0
      -39 h\n.8 g 3624 2415 N 0 39 48 0 0 -39 h\n.8 g 3575 2415 N 0 39 49 0 0
      -39 h\n.8 g 3527 2415 N 0 39 48 0 0 -39 h\n.8 g 3478 2415 N 0 39 49 0 0
      -39 h\n.8 g 3429 2415 N 0 39 49 0 0 -39 h\n.8 g 3381 2415 N 0 39 48 0 0
      -39 h\n.8 g 3332 2415 N 0 39 49 0 0 -39 h\n.8 g 3284 2415 N 0 39 48 0 0
      -39 h\n.8 g 3235 2415 N 0 39 49 0 0 -39 h\n.8 g 3186 2415 N 0 39 49 0 0
      -39 h\n.8 g 3138 2415 N 0 39 48 0 0 -39 h\n.8 g 3089 2415 N 0 39 49 0 0
      -39 h\n.8 g 3040 2415 N 0 39 49 0 0 -39 h\n.8 g 2992 2415 N 0 39 48 0 0
      -39 h\n.8 g 2943 2415 N 0 39 49 0 0 -39 h\n.8 g 2895 2415 N 0 39 48 0 0
      -39 h\n.8 g 2846 2415 N 0 39 49 0 0 -39 h\n.8 g 2797 2415 N 0 39 49 0 0
      -39 h\n.8 g 2749 2415 N 0 39 48 0 0 -39 h\n.8 g 2700 2415 N 0 39 49 0 0
      -39 h\n.8 g 2652 2415 N 0 39 48 0 0 -39 h\n.8 g 2603 2415 N 0 39 49 0 0
      -39 h\n.9 g 2554 2415 N 0 39 49 0 0 -39 h\n1 g 2506 2415 N 0 39 48 0 0
      -39 h\n1 g 2457 2415 N 0 39 49 0 0 -39 h\n1 g 2409 2415 N 0 39 48 0 0
      -39 h\n1 g 2360 2415 N 0 39 49 0 0 -39 h\n1 g 2311 2415 N 0 39 49 0 0
      -39 h\n1 g 2263 2415 N 0 39 48 0 0 -39 h\n1 g 2214 2415 N 0 39 49 0 0
      -39 h\n1 g 2165 2415 N 0 39 49 0 0 -39 h\n1 g 2117 2415 N 0 39 48 0 0
      -39 h\n1 g 2068 2415 N 0 39 49 0 0 -39 h\n1 g 2020 2415 N 0 39 48 0 0
      -39 h\n1 g 1971 2415 N 0 39 49 0 0 -39 h\n1 g 1922 2415 N 0 39 49 0 0
      -39 h\n1 g 1874 2415 N 0 39 48 0 0 -39 h\n1 g 1825 2415 N 0 39 49 0 0
      -39 h\n1 g 1777 2415 N 0 39 48 0 0 -39 h\n1 g 1728 2415 N 0 39 49 0 0
      -39 h\n1 g 1679 2415 N 0 39 49 0 0 -39 h\n1 g 1631 2415 N 0 39 48 0 0
      -39 h\n1 g 1582 2415 N 0 39 49 0 0 -39 h\n1 g 1534 2415 N 0 39 48 0 0
      -39 h\n1 g 1485 2415 N 0 39 49 0 0 -39 h\n1 g 1436 2415 N 0 39 49 0 0
      -39 h\n1 g 1388 2415 N 0 39 48 0 0 -39 h\n1 g 1339 2415 N 0 39 49 0 0
      -39 h\n1 g 1290 2415 N 0 39 49 0 0 -39 h\n1 g 1242 2415 N 0 39 48 0 0
      -39 h\n1 g 1193 2415 N 0 39 49 0 0 -39 h\n1 g 5957 2376 N 0 38 49 0 0
      -38 h\n1 g 5909 2376 N 0 38 48 0 0 -38 h\n1 g 5860 2376 N 0 38 49 0 0
      -38 h\n1 g 5811 2376 N 0 38 49 0 0 -38 h\n1 g 5763 2376 N 0 38 48 0 0
      -38 h\n1 g 5714 2376 N 0 38 49 0 0 -38 h\n1 g 5665 2376 N 0 38 49 0 0
      -38 h\n1 g 5617 2376 N 0 38 48 0 0 -38 h\n1 g 5568 2376 N 0 38 49 0 0
      -38 h\n1 g 5520 2376 N 0 38 48 0 0 -38 h\n1 g 5471 2376 N 0 38 49 0 0
      -38 h\n1 g 5422 2376 N 0 38 49 0 0 -38 h\n1 g 5374 2376 N 0 38 48 0 0
      -38 h\n1 g 5325 2376 N 0 38 49 0 0 -38 h\n1 g 5277 2376 N 0 38 48 0 0
      -38 h\n1 g 5228 2376 N 0 38 49 0 0 -38 h\n1 g 5179 2376 N 0 38 49 0 0
      -38 h\n1 g 5131 2376 N 0 38 48 0 0 -38 h\n1 g 5082 2376 N 0 38 49 0 0
      -38 h\n1 g 5034 2376 N 0 38 48 0 0 -38 h\n1 g 4985 2376 N 0 38 49 0 0
      -38 h\n1 g 4936 2376 N 0 38 49 0 0 -38 h\n1 g 4888 2376 N 0 38 48 0 0
      -38 h\n1 g 4839 2376 N 0 38 49 0 0 -38 h\n1 g 4790 2376 N 0 38 49 0 0
      -38 h\n1 g 4742 2376 N 0 38 48 0 0 -38 h\n1 g 4693 2376 N 0 38 49 0 0
      -38 h\n1 g 4645 2376 N 0 38 48 0 0 -38 h\n.9 g 4596 2376 N 0 38 49 0 0
      -38 h\n.8 g 4547 2376 N 0 38 49 0 0 -38 h\n.8 g 4499 2376 N 0 38 48 0 0
      -38 h\n.8 g 4450 2376 N 0 38 49 0 0 -38 h\n.8 g 4402 2376 N 0 38 48 0 0
      -38 h\n.8 g 4353 2376 N 0 38 49 0 0 -38 h\n.8 g 4304 2376 N 0 38 49 0 0
      -38 h\n.8 g 4256 2376 N 0 38 48 0 0 -38 h\n.8 g 4207 2376 N 0 38 49 0 0
      -38 h\n.8 g 4159 2376 N 0 38 48 0 0 -38 h\n.8 g 4110 2376 N 0 38 49 0 0
      -38 h\n.8 g 4061 2376 N 0 38 49 0 0 -38 h\n.8 g 4013 2376 N 0 38 48 0 0
      -38 h\n.8 g 3964 2376 N 0 38 49 0 0 -38 h\n.8 g 3915 2376 N 0 38 49 0 0
      -38 h\n.8 g 3867 2376 N 0 38 48 0 0 -38 h\n.8 g 3818 2376 N 0 38 49 0 0
      -38 h\n.8 g 3770 2376 N 0 38 48 0 0 -38 h\n.8 g 3721 2376 N 0 38 49 0 0
      -38 h\n.8 g 3672 2376 N 0 38 49 0 0 -38 h\n.8 g 3624 2376 N 0 38 48 0 0
      -38 h\n.8 g 3575 2376 N 0 38 49 0 0 -38 h\n.8 g 3527 2376 N 0 38 48 0 0
      -38 h\n.8 g 3478 2376 N 0 38 49 0 0 -38 h\n.8 g 3429 2376 N 0 38 49 0 0
      -38 h\n.8 g 3381 2376 N 0 38 48 0 0 -38 h\n.8 g 3332 2376 N 0 38 49 0 0
      -38 h\n.8 g 3284 2376 N 0 38 48 0 0 -38 h\n.8 g 3235 2376 N 0 38 49 0 0
      -38 h\n.8 g 3186 2376 N 0 38 49 0 0 -38 h\n.8 g 3138 2376 N 0 38 48 0 0
      -38 h\n.8 g 3089 2376 N 0 38 49 0 0 -38 h\n.8 g 3040 2376 N 0 38 49 0 0
      -38 h\n.8 g 2992 2376 N 0 38 48 0 0 -38 h\n.8 g 2943 2376 N 0 38 49 0 0
      -38 h\n.8 g 2895 2376 N 0 38 48 0 0 -38 h\n.8 g 2846 2376 N 0 38 49 0 0
      -38 h\n.8 g 2797 2376 N 0 38 49 0 0 -38 h\n.8 g 2749 2376 N 0 38 48 0 0
      -38 h\n.8 g 2700 2376 N 0 38 49 0 0 -38 h\n.8 g 2652 2376 N 0 38 48 0 0
      -38 h\n.8 g 2603 2376 N 0 38 49 0 0 -38 h\n.9 g 2554 2376 N 0 38 49 0 0
      -38 h\n1 g 2506 2376 N 0 38 48 0 0 -38 h\n1 g 2457 2376 N 0 38 49 0 0
      -38 h\n1 g 2409 2376 N 0 38 48 0 0 -38 h\n1 g 2360 2376 N 0 38 49 0 0
      -38 h\n1 g 2311 2376 N 0 38 49 0 0 -38 h\n1 g 2263 2376 N 0 38 48 0 0
      -38 h\n1 g 2214 2376 N 0 38 49 0 0 -38 h\n1 g 2165 2376 N 0 38 49 0 0
      -38 h\n1 g 2117 2376 N 0 38 48 0 0 -38 h\n1 g 2068 2376 N 0 38 49 0 0
      -38 h\n1 g 2020 2376 N 0 38 48 0 0 -38 h\n1 g 1971 2376 N 0 38 49 0 0
      -38 h\n1 g 1922 2376 N 0 38 49 0 0 -38 h\n1 g 1874 2376 N 0 38 48 0 0
      -38 h\n1 g 1825 2376 N 0 38 49 0 0 -38 h\n1 g 1777 2376 N 0 38 48 0 0
      -38 h\n1 g 1728 2376 N 0 38 49 0 0 -38 h\n1 g 1679 2376 N 0 38 49 0 0
      -38 h\n1 g 1631 2376 N 0 38 48 0 0 -38 h\n1 g 1582 2376 N 0 38 49 0 0
      -38 h\n1 g 1534 2376 N 0 38 48 0 0 -38 h\n1 g 1485 2376 N 0 38 49 0 0
      -38 h\n1 g 1436 2376 N 0 38 49 0 0 -38 h\n1 g 1388 2376 N 0 38 48 0 0
      -38 h\n1 g 1339 2376 N 0 38 49 0 0 -38 h\n1 g 1290 2376 N 0 38 49 0 0
      -38 h\n1 g 1242 2376 N 0 38 48 0 0 -38 h\n1 g 1193 2376 N 0 38 49 0 0
      -38 h\n1 g 5957 2338 N 0 39 49 0 0 -39 h\n1 g 5909 2338 N 0 39 48 0 0
      -39 h\n1 g 5860 2338 N 0 39 49 0 0 -39 h\n1 g 5811 2338 N 0 39 49 0 0
      -39 h\n1 g 5763 2338 N 0 39 48 0 0 -39 h\n1 g 5714 2338 N 0 39 49 0 0
      -39 h\n1 g 5665 2338 N 0 39 49 0 0 -39 h\n1 g 5617 2338 N 0 39 48 0 0
      -39 h\n1 g 5568 2338 N 0 39 49 0 0 -39 h\n1 g 5520 2338 N 0 39 48 0 0
      -39 h\n1 g 5471 2338 N 0 39 49 0 0 -39 h\n1 g 5422 2338 N 0 39 49 0 0
      -39 h\n1 g 5374 2338 N 0 39 48 0 0 -39 h\n1 g 5325 2338 N 0 39 49 0 0
      -39 h\n1 g 5277 2338 N 0 39 48 0 0 -39 h\n1 g 5228 2338 N 0 39 49 0 0
      -39 h\n1 g 5179 2338 N 0 39 49 0 0 -39 h\n1 g 5131 2338 N 0 39 48 0 0
      -39 h\n1 g 5082 2338 N 0 39 49 0 0 -39 h\n1 g 5034 2338 N 0 39 48 0 0
      -39 h\n1 g 4985 2338 N 0 39 49 0 0 -39 h\n1 g 4936 2338 N 0 39 49 0 0
      -39 h\n1 g 4888 2338 N 0 39 48 0 0 -39 h\n1 g 4839 2338 N 0 39 49 0 0
      -39 h\n1 g 4790 2338 N 0 39 49 0 0 -39 h\n1 g 4742 2338 N 0 39 48 0 0
      -39 h\n1 g 4693 2338 N 0 39 49 0 0 -39 h\n1 g 4645 2338 N 0 39 48 0 0
      -39 h\n.95 g 4596 2338 N 0 39 49 0 0 -39 h\n.85 g 4547 2338 N 0 39 49 0
      0 -39 h\n.8 g 4499 2338 N 0 39 48 0 0 -39 h\n.8 g 4450 2338 N 0 39 49 0
      0 -39 h\n.8 g 4402 2338 N 0 39 48 0 0 -39 h\n.8 g 4353 2338 N 0 39 49 0
      0 -39 h\n.8 g 4304 2338 N 0 39 49 0 0 -39 h\n.8 g 4256 2338 N 0 39 48 0
      0 -39 h\n.8 g 4207 2338 N 0 39 49 0 0 -39 h\n.8 g 4159 2338 N 0 39 48 0
      0 -39 h\n.8 g 4110 2338 N 0 39 49 0 0 -39 h\n.8 g 4061 2338 N 0 39 49 0
      0 -39 h\n.8 g 4013 2338 N 0 39 48 0 0 -39 h\n.8 g 3964 2338 N 0 39 49 0
      0 -39 h\n.8 g 3915 2338 N 0 39 49 0 0 -39 h\n.8 g 3867 2338 N 0 39 48 0
      0 -39 h\n.8 g 3818 2338 N 0 39 49 0 0 -39 h\n.8 g 3770 2338 N 0 39 48 0
      0 -39 h\n.8 g 3721 2338 N 0 39 49 0 0 -39 h\n.8 g 3672 2338 N 0 39 49 0
      0 -39 h\n.8 g 3624 2338 N 0 39 48 0 0 -39 h\n.8 g 3575 2338 N 0 39 49 0
      0 -39 h\n.8 g 3527 2338 N 0 39 48 0 0 -39 h\n.8 g 3478 2338 N 0 39 49 0
      0 -39 h\n.8 g 3429 2338 N 0 39 49 0 0 -39 h\n.8 g 3381 2338 N 0 39 48 0
      0 -39 h\n.8 g 3332 2338 N 0 39 49 0 0 -39 h\n.8 g 3284 2338 N 0 39 48 0
      0 -39 h\n.8 g 3235 2338 N 0 39 49 0 0 -39 h\n.8 g 3186 2338 N 0 39 49 0
      0 -39 h\n.8 g 3138 2338 N 0 39 48 0 0 -39 h\n.8 g 3089 2338 N 0 39 49 0
      0 -39 h\n.8 g 3040 2338 N 0 39 49 0 0 -39 h\n.8 g 2992 2338 N 0 39 48 0
      0 -39 h\n.8 g 2943 2338 N 0 39 49 0 0 -39 h\n.8 g 2895 2338 N 0 39 48 0
      0 -39 h\n.8 g 2846 2338 N 0 39 49 0 0 -39 h\n.8 g 2797 2338 N 0 39 49 0
      0 -39 h\n.8 g 2749 2338 N 0 39 48 0 0 -39 h\n.8 g 2700 2338 N 0 39 49 0
      0 -39 h\n.8 g 2652 2338 N 0 39 48 0 0 -39 h\n.85 g 2603 2338 N 0 39 49
      0 0 -39 h\n.95 g 2554 2338 N 0 39 49 0 0 -39 h\n1 g 2506 2338 N 0 39 48
      0 0 -39 h\n1 g 2457 2338 N 0 39 49 0 0 -39 h\n1 g 2409 2338 N 0 39 48 0
      0 -39 h\n1 g 2360 2338 N 0 39 49 0 0 -39 h\n1 g 2311 2338 N 0 39 49 0 0
      -39 h\n1 g 2263 2338 N 0 39 48 0 0 -39 h\n1 g 2214 2338 N 0 39 49 0 0
      -39 h\n1 g 2165 2338 N 0 39 49 0 0 -39 h\n1 g 2117 2338 N 0 39 48 0 0
      -39 h\n1 g 2068 2338 N 0 39 49 0 0 -39 h\n1 g 2020 2338 N 0 39 48 0 0
      -39 h\n1 g 1971 2338 N 0 39 49 0 0 -39 h\n1 g 1922 2338 N 0 39 49 0 0
      -39 h\n1 g 1874 2338 N 0 39 48 0 0 -39 h\n1 g 1825 2338 N 0 39 49 0 0
      -39 h\n1 g 1777 2338 N 0 39 48 0 0 -39 h\n1 g 1728 2338 N 0 39 49 0 0
      -39 h\n1 g 1679 2338 N 0 39 49 0 0 -39 h\n1 g 1631 2338 N 0 39 48 0 0
      -39 h\n1 g 1582 2338 N 0 39 49 0 0 -39 h\n1 g 1534 2338 N 0 39 48 0 0
      -39 h\n1 g 1485 2338 N 0 39 49 0 0 -39 h\n1 g 1436 2338 N 0 39 49 0 0
      -39 h\n1 g 1388 2338 N 0 39 48 0 0 -39 h\n1 g 1339 2338 N 0 39 49 0 0
      -39 h\n1 g 1290 2338 N 0 39 49 0 0 -39 h\n1 g 1242 2338 N 0 39 48 0 0
      -39 h\n1 g 1193 2338 N 0 39 49 0 0 -39 h\n1 g 5957 2299 N 0 39 49 0 0
      -39 h\n1 g 5909 2299 N 0 39 48 0 0 -39 h\n1 g 5860 2299 N 0 39 49 0 0
      -39 h\n1 g 5811 2299 N 0 39 49 0 0 -39 h\n1 g 5763 2299 N 0 39 48 0 0
      -39 h\n1 g 5714 2299 N 0 39 49 0 0 -39 h\n1 g 5665 2299 N 0 39 49 0 0
      -39 h\n1 g 5617 2299 N 0 39 48 0 0 -39 h\n1 g 5568 2299 N 0 39 49 0 0
      -39 h\n1 g 5520 2299 N 0 39 48 0 0 -39 h\n1 g 5471 2299 N 0 39 49 0 0
      -39 h\n1 g 5422 2299 N 0 39 49 0 0 -39 h\n1 g 5374 2299 N 0 39 48 0 0
      -39 h\n1 g 5325 2299 N 0 39 49 0 0 -39 h\n1 g 5277 2299 N 0 39 48 0 0
      -39 h\n1 g 5228 2299 N 0 39 49 0 0 -39 h\n1 g 5179 2299 N 0 39 49 0 0
      -39 h\n1 g 5131 2299 N 0 39 48 0 0 -39 h\n1 g 5082 2299 N 0 39 49 0 0
      -39 h\n1 g 5034 2299 N 0 39 48 0 0 -39 h\n1 g 4985 2299 N 0 39 49 0 0
      -39 h\n1 g 4936 2299 N 0 39 49 0 0 -39 h\n1 g 4888 2299 N 0 39 48 0 0
      -39 h\n1 g 4839 2299 N 0 39 49 0 0 -39 h\n1 g 4790 2299 N 0 39 49 0 0
      -39 h\n1 g 4742 2299 N 0 39 48 0 0 -39 h\n1 g 4693 2299 N 0 39 49 0 0
      -39 h\n1 g 4645 2299 N 0 39 48 0 0 -39 h\n1 g 4596 2299 N 0 39 49 0 0
      -39 h\n.9 g 4547 2299 N 0 39 49 0 0 -39 h\n.8 g 4499 2299 N 0 39 48 0 0
      -39 h\n.8 g 4450 2299 N 0 39 49 0 0 -39 h\n.8 g 4402 2299 N 0 39 48 0 0
      -39 h\n.8 g 4353 2299 N 0 39 49 0 0 -39 h\n.8 g 4304 2299 N 0 39 49 0 0
      -39 h\n.8 g 4256 2299 N 0 39 48 0 0 -39 h\n.8 g 4207 2299 N 0 39 49 0 0
      -39 h\n.8 g 4159 2299 N 0 39 48 0 0 -39 h\n.8 g 4110 2299 N 0 39 49 0 0
      -39 h\n.8 g 4061 2299 N 0 39 49 0 0 -39 h\n.8 g 4013 2299 N 0 39 48 0 0
      -39 h\n.8 g 3964 2299 N 0 39 49 0 0 -39 h\n.8 g 3915 2299 N 0 39 49 0 0
      -39 h\n.8 g 3867 2299 N 0 39 48 0 0 -39 h\n.8 g 3818 2299 N 0 39 49 0 0
      -39 h\n.8 g 3770 2299 N 0 39 48 0 0 -39 h\n.8 g 3721 2299 N 0 39 49 0 0
      -39 h\n.8 g 3672 2299 N 0 39 49 0 0 -39 h\n.8 g 3624 2299 N 0 39 48 0 0
      -39 h\n.8 g 3575 2299 N 0 39 49 0 0 -39 h\n.8 g 3527 2299 N 0 39 48 0 0
      -39 h\n.8 g 3478 2299 N 0 39 49 0 0 -39 h\n.8 g 3429 2299 N 0 39 49 0 0
      -39 h\n.8 g 3381 2299 N 0 39 48 0 0 -39 h\n.8 g 3332 2299 N 0 39 49 0 0
      -39 h\n.8 g 3284 2299 N 0 39 48 0 0 -39 h\n.8 g 3235 2299 N 0 39 49 0 0
      -39 h\n.8 g 3186 2299 N 0 39 49 0 0 -39 h\n.8 g 3138 2299 N 0 39 48 0 0
      -39 h\n.8 g 3089 2299 N 0 39 49 0 0 -39 h\n.8 g 3040 2299 N 0 39 49 0 0
      -39 h\n.8 g 2992 2299 N 0 39 48 0 0 -39 h\n.8 g 2943 2299 N 0 39 49 0 0
      -39 h\n.8 g 2895 2299 N 0 39 48 0 0 -39 h\n.8 g 2846 2299 N 0 39 49 0 0
      -39 h\n.8 g 2797 2299 N 0 39 49 0 0 -39 h\n.8 g 2749 2299 N 0 39 48 0 0
      -39 h\n.8 g 2700 2299 N 0 39 49 0 0 -39 h\n.8 g 2652 2299 N 0 39 48 0 0
      -39 h\n.9 g 2603 2299 N 0 39 49 0 0 -39 h\n1 g 2554 2299 N 0 39 49 0 0
      -39 h\n1 g 2506 2299 N 0 39 48 0 0 -39 h\n1 g 2457 2299 N 0 39 49 0 0
      -39 h\n1 g 2409 2299 N 0 39 48 0 0 -39 h\n1 g 2360 2299 N 0 39 49 0 0
      -39 h\n1 g 2311 2299 N 0 39 49 0 0 -39 h\n1 g 2263 2299 N 0 39 48 0 0
      -39 h\n1 g 2214 2299 N 0 39 49 0 0 -39 h\n1 g 2165 2299 N 0 39 49 0 0
      -39 h\n1 g 2117 2299 N 0 39 48 0 0 -39 h\n1 g 2068 2299 N 0 39 49 0 0
      -39 h\n1 g 2020 2299 N 0 39 48 0 0 -39 h\n1 g 1971 2299 N 0 39 49 0 0
      -39 h\n1 g 1922 2299 N 0 39 49 0 0 -39 h\n1 g 1874 2299 N 0 39 48 0 0
      -39 h\n1 g 1825 2299 N 0 39 49 0 0 -39 h\n1 g 1777 2299 N 0 39 48 0 0
      -39 h\n1 g 1728 2299 N 0 39 49 0 0 -39 h\n1 g 1679 2299 N 0 39 49 0 0
      -39 h\n1 g 1631 2299 N 0 39 48 0 0 -39 h\n1 g 1582 2299 N 0 39 49 0 0
      -39 h\n1 g 1534 2299 N 0 39 48 0 0 -39 h\n1 g 1485 2299 N 0 39 49 0 0
      -39 h\n1 g 1436 2299 N 0 39 49 0 0 -39 h\n1 g 1388 2299 N 0 39 48 0 0
      -39 h\n1 g 1339 2299 N 0 39 49 0 0 -39 h\n1 g 1290 2299 N 0 39 49 0 0
      -39 h\n1 g 1242 2299 N 0 39 48 0 0 -39 h\n1 g 1193 2299 N 0 39 49 0 0
      -39 h\n1 g 5957 2260 N 0 39 49 0 0 -39 h\n1 g 5909 2260 N 0 39 48 0 0
      -39 h\n1 g 5860 2260 N 0 39 49 0 0 -39 h\n1 g 5811 2260 N 0 39 49 0 0
      -39 h\n1 g 5763 2260 N 0 39 48 0 0 -39 h\n1 g 5714 2260 N 0 39 49 0 0
      -39 h\n1 g 5665 2260 N 0 39 49 0 0 -39 h\n1 g 5617 2260 N 0 39 48 0 0
      -39 h\n1 g 5568 2260 N 0 39 49 0 0 -39 h\n1 g 5520 2260 N 0 39 48 0 0
      -39 h\n1 g 5471 2260 N 0 39 49 0 0 -39 h\n1 g 5422 2260 N 0 39 49 0 0
      -39 h\n1 g 5374 2260 N 0 39 48 0 0 -39 h\n1 g 5325 2260 N 0 39 49 0 0
      -39 h\n1 g 5277 2260 N 0 39 48 0 0 -39 h\n1 g 5228 2260 N 0 39 49 0 0
      -39 h\n1 g 5179 2260 N 0 39 49 0 0 -39 h\n1 g 5131 2260 N 0 39 48 0 0
      -39 h\n1 g 5082 2260 N 0 39 49 0 0 -39 h\n1 g 5034 2260 N 0 39 48 0 0
      -39 h\n1 g 4985 2260 N 0 39 49 0 0 -39 h\n1 g 4936 2260 N 0 39 49 0 0
      -39 h\n1 g 4888 2260 N 0 39 48 0 0 -39 h\n1 g 4839 2260 N 0 39 49 0 0
      -39 h\n1 g 4790 2260 N 0 39 49 0 0 -39 h\n1 g 4742 2260 N 0 39 48 0 0
      -39 h\n1 g 4693 2260 N 0 39 49 0 0 -39 h\n1 g 4645 2260 N 0 39 48 0 0
      -39 h\n1 g 4596 2260 N 0 39 49 0 0 -39 h\n.9 g 4547 2260 N 0 39 49 0 0
      -39 h\n.8 g 4499 2260 N 0 39 48 0 0 -39 h\n.8 g 4450 2260 N 0 39 49 0 0
      -39 h\n.8 g 4402 2260 N 0 39 48 0 0 -39 h\n.8 g 4353 2260 N 0 39 49 0 0
      -39 h\n.8 g 4304 2260 N 0 39 49 0 0 -39 h\n.8 g 4256 2260 N 0 39 48 0 0
      -39 h\n.8 g 4207 2260 N 0 39 49 0 0 -39 h\n.8 g 4159 2260 N 0 39 48 0 0
      -39 h\n.8 g 4110 2260 N 0 39 49 0 0 -39 h\n.8 g 4061 2260 N 0 39 49 0 0
      -39 h\n.8 g 4013 2260 N 0 39 48 0 0 -39 h\n.8 g 3964 2260 N 0 39 49 0 0
      -39 h\n.8 g 3915 2260 N 0 39 49 0 0 -39 h\n.8 g 3867 2260 N 0 39 48 0 0
      -39 h\n.8 g 3818 2260 N 0 39 49 0 0 -39 h\n.8 g 3770 2260 N 0 39 48 0 0
      -39 h\n.8 g 3721 2260 N 0 39 49 0 0 -39 h\n.8 g 3672 2260 N 0 39 49 0 0
      -39 h\n.8 g 3624 2260 N 0 39 48 0 0 -39 h\n.8 g 3575 2260 N 0 39 49 0 0
      -39 h\n.8 g 3527 2260 N 0 39 48 0 0 -39 h\n.8 g 3478 2260 N 0 39 49 0 0
      -39 h\n.8 g 3429 2260 N 0 39 49 0 0 -39 h\n.8 g 3381 2260 N 0 39 48 0 0
      -39 h\n.8 g 3332 2260 N 0 39 49 0 0 -39 h\n.8 g 3284 2260 N 0 39 48 0 0
      -39 h\n.8 g 3235 2260 N 0 39 49 0 0 -39 h\n.8 g 3186 2260 N 0 39 49 0 0
      -39 h\n.8 g 3138 2260 N 0 39 48 0 0 -39 h\n.8 g 3089 2260 N 0 39 49 0 0
      -39 h\n.8 g 3040 2260 N 0 39 49 0 0 -39 h\n.8 g 2992 2260 N 0 39 48 0 0
      -39 h\n.8 g 2943 2260 N 0 39 49 0 0 -39 h\n.8 g 2895 2260 N 0 39 48 0 0
      -39 h\n.8 g 2846 2260 N 0 39 49 0 0 -39 h\n.8 g 2797 2260 N 0 39 49 0 0
      -39 h\n.8 g 2749 2260 N 0 39 48 0 0 -39 h\n.8 g 2700 2260 N 0 39 49 0 0
      -39 h\n.8 g 2652 2260 N 0 39 48 0 0 -39 h\n.9 g 2603 2260 N 0 39 49 0 0
      -39 h\n1 g 2554 2260 N 0 39 49 0 0 -39 h\n1 g 2506 2260 N 0 39 48 0 0
      -39 h\n1 g 2457 2260 N 0 39 49 0 0 -39 h\n1 g 2409 2260 N 0 39 48 0 0
      -39 h\n1 g 2360 2260 N 0 39 49 0 0 -39 h\n1 g 2311 2260 N 0 39 49 0 0
      -39 h\n1 g 2263 2260 N 0 39 48 0 0 -39 h\n1 g 2214 2260 N 0 39 49 0 0
      -39 h\n1 g 2165 2260 N 0 39 49 0 0 -39 h\n1 g 2117 2260 N 0 39 48 0 0
      -39 h\n1 g 2068 2260 N 0 39 49 0 0 -39 h\n1 g 2020 2260 N 0 39 48 0 0
      -39 h\n1 g 1971 2260 N 0 39 49 0 0 -39 h\n1 g 1922 2260 N 0 39 49 0 0
      -39 h\n1 g 1874 2260 N 0 39 48 0 0 -39 h\n1 g 1825 2260 N 0 39 49 0 0
      -39 h\n1 g 1777 2260 N 0 39 48 0 0 -39 h\n1 g 1728 2260 N 0 39 49 0 0
      -39 h\n1 g 1679 2260 N 0 39 49 0 0 -39 h\n1 g 1631 2260 N 0 39 48 0 0
      -39 h\n1 g 1582 2260 N 0 39 49 0 0 -39 h\n1 g 1534 2260 N 0 39 48 0 0
      -39 h\n1 g 1485 2260 N 0 39 49 0 0 -39 h\n1 g 1436 2260 N 0 39 49 0 0
      -39 h\n1 g 1388 2260 N 0 39 48 0 0 -39 h\n1 g 1339 2260 N 0 39 49 0 0
      -39 h\n1 g 1290 2260 N 0 39 49 0 0 -39 h\n1 g 1242 2260 N 0 39 48 0 0
      -39 h\n1 g 1193 2260 N 0 39 49 0 0 -39 h\n1 g 5957 2221 N 0 38 49 0 0
      -38 h\n1 g 5909 2221 N 0 38 48 0 0 -38 h\n1 g 5860 2221 N 0 38 49 0 0
      -38 h\n1 g 5811 2221 N 0 38 49 0 0 -38 h\n1 g 5763 2221 N 0 38 48 0 0
      -38 h\n1 g 5714 2221 N 0 38 49 0 0 -38 h\n1 g 5665 2221 N 0 38 49 0 0
      -38 h\n1 g 5617 2221 N 0 38 48 0 0 -38 h\n1 g 5568 2221 N 0 38 49 0 0
      -38 h\n1 g 5520 2221 N 0 38 48 0 0 -38 h\n1 g 5471 2221 N 0 38 49 0 0
      -38 h\n1 g 5422 2221 N 0 38 49 0 0 -38 h\n1 g 5374 2221 N 0 38 48 0 0
      -38 h\n1 g 5325 2221 N 0 38 49 0 0 -38 h\n1 g 5277 2221 N 0 38 48 0 0
      -38 h\n1 g 5228 2221 N 0 38 49 0 0 -38 h\n1 g 5179 2221 N 0 38 49 0 0
      -38 h\n1 g 5131 2221 N 0 38 48 0 0 -38 h\n1 g 5082 2221 N 0 38 49 0 0
      -38 h\n1 g 5034 2221 N 0 38 48 0 0 -38 h\n1 g 4985 2221 N 0 38 49 0 0
      -38 h\n1 g 4936 2221 N 0 38 49 0 0 -38 h\n1 g 4888 2221 N 0 38 48 0 0
      -38 h\n1 g 4839 2221 N 0 38 49 0 0 -38 h\n1 g 4790 2221 N 0 38 49 0 0
      -38 h\n1 g 4742 2221 N 0 38 48 0 0 -38 h\n1 g 4693 2221 N 0 38 49 0 0
      -38 h\n1 g 4645 2221 N 0 38 48 0 0 -38 h\n1 g 4596 2221 N 0 38 49 0 0
      -38 h\n.9 g 4547 2221 N 0 38 49 0 0 -38 h\n.8 g 4499 2221 N 0 38 48 0 0
      -38 h\n.8 g 4450 2221 N 0 38 49 0 0 -38 h\n.8 g 4402 2221 N 0 38 48 0 0
      -38 h\n.8 g 4353 2221 N 0 38 49 0 0 -38 h\n.8 g 4304 2221 N 0 38 49 0 0
      -38 h\n.8 g 4256 2221 N 0 38 48 0 0 -38 h\n.8 g 4207 2221 N 0 38 49 0 0
      -38 h\n.8 g 4159 2221 N 0 38 48 0 0 -38 h\n.8 g 4110 2221 N 0 38 49 0 0
      -38 h\n.8 g 4061 2221 N 0 38 49 0 0 -38 h\n.8 g 4013 2221 N 0 38 48 0 0
      -38 h\n.8 g 3964 2221 N 0 38 49 0 0 -38 h\n.8 g 3915 2221 N 0 38 49 0 0
      -38 h\n.8 g 3867 2221 N 0 38 48 0 0 -38 h\n.8 g 3818 2221 N 0 38 49 0 0
      -38 h\n.8 g 3770 2221 N 0 38 48 0 0 -38 h\n.8 g 3721 2221 N 0 38 49 0 0
      -38 h\n.8 g 3672 2221 N 0 38 49 0 0 -38 h\n.8 g 3624 2221 N 0 38 48 0 0
      -38 h\n.8 g 3575 2221 N 0 38 49 0 0 -38 h\n.8 g 3527 2221 N 0 38 48 0 0
      -38 h\n.8 g 3478 2221 N 0 38 49 0 0 -38 h\n.8 g 3429 2221 N 0 38 49 0 0
      -38 h\n.8 g 3381 2221 N 0 38 48 0 0 -38 h\n.8 g 3332 2221 N 0 38 49 0 0
      -38 h\n.8 g 3284 2221 N 0 38 48 0 0 -38 h\n.8 g 3235 2221 N 0 38 49 0 0
      -38 h\n.8 g 3186 2221 N 0 38 49 0 0 -38 h\n.8 g 3138 2221 N 0 38 48 0 0
      -38 h\n.8 g 3089 2221 N 0 38 49 0 0 -38 h\n.8 g 3040 2221 N 0 38 49 0 0
      -38 h\n.8 g 2992 2221 N 0 38 48 0 0 -38 h\n.8 g 2943 2221 N 0 38 49 0 0
      -38 h\n.8 g 2895 2221 N 0 38 48 0 0 -38 h\n.8 g 2846 2221 N 0 38 49 0 0
      -38 h\n.8 g 2797 2221 N 0 38 49 0 0 -38 h\n.8 g 2749 2221 N 0 38 48 0 0
      -38 h\n.8 g 2700 2221 N 0 38 49 0 0 -38 h\n.8 g 2652 2221 N 0 38 48 0 0
      -38 h\n.9 g 2603 2221 N 0 38 49 0 0 -38 h\n1 g 2554 2221 N 0 38 49 0 0
      -38 h\n1 g 2506 2221 N 0 38 48 0 0 -38 h\n1 g 2457 2221 N 0 38 49 0 0
      -38 h\n1 g 2409 2221 N 0 38 48 0 0 -38 h\n1 g 2360 2221 N 0 38 49 0 0
      -38 h\n1 g 2311 2221 N 0 38 49 0 0 -38 h\n1 g 2263 2221 N 0 38 48 0 0
      -38 h\n1 g 2214 2221 N 0 38 49 0 0 -38 h\n1 g 2165 2221 N 0 38 49 0 0
      -38 h\n1 g 2117 2221 N 0 38 48 0 0 -38 h\n1 g 2068 2221 N 0 38 49 0 0
      -38 h\n1 g 2020 2221 N 0 38 48 0 0 -38 h\n1 g 1971 2221 N 0 38 49 0 0
      -38 h\n1 g 1922 2221 N 0 38 49 0 0 -38 h\n1 g 1874 2221 N 0 38 48 0 0
      -38 h\n1 g 1825 2221 N 0 38 49 0 0 -38 h\n1 g 1777 2221 N 0 38 48 0 0
      -38 h\n1 g 1728 2221 N 0 38 49 0 0 -38 h\n1 g 1679 2221 N 0 38 49 0 0
      -38 h\n1 g 1631 2221 N 0 38 48 0 0 -38 h\n1 g 1582 2221 N 0 38 49 0 0
      -38 h\n1 g 1534 2221 N 0 38 48 0 0 -38 h\n1 g 1485 2221 N 0 38 49 0 0
      -38 h\n1 g 1436 2221 N 0 38 49 0 0 -38 h\n1 g 1388 2221 N 0 38 48 0 0
      -38 h\n1 g 1339 2221 N 0 38 49 0 0 -38 h\n1 g 1290 2221 N 0 38 49 0 0
      -38 h\n1 g 1242 2221 N 0 38 48 0 0 -38 h\n1 g 1193 2221 N 0 38 49 0 0
      -38 h\n1 g 5957 2183 N 0 39 49 0 0 -39 h\n1 g 5909 2183 N 0 39 48 0 0
      -39 h\n1 g 5860 2183 N 0 39 49 0 0 -39 h\n1 g 5811 2183 N 0 39 49 0 0
      -39 h\n1 g 5763 2183 N 0 39 48 0 0 -39 h\n1 g 5714 2183 N 0 39 49 0 0
      -39 h\n1 g 5665 2183 N 0 39 49 0 0 -39 h\n1 g 5617 2183 N 0 39 48 0 0
      -39 h\n1 g 5568 2183 N 0 39 49 0 0 -39 h\n1 g 5520 2183 N 0 39 48 0 0
      -39 h\n1 g 5471 2183 N 0 39 49 0 0 -39 h\n1 g 5422 2183 N 0 39 49 0 0
      -39 h\n1 g 5374 2183 N 0 39 48 0 0 -39 h\n1 g 5325 2183 N 0 39 49 0 0
      -39 h\n1 g 5277 2183 N 0 39 48 0 0 -39 h\n1 g 5228 2183 N 0 39 49 0 0
      -39 h\n1 g 5179 2183 N 0 39 49 0 0 -39 h\n1 g 5131 2183 N 0 39 48 0 0
      -39 h\n1 g 5082 2183 N 0 39 49 0 0 -39 h\n1 g 5034 2183 N 0 39 48 0 0
      -39 h\n1 g 4985 2183 N 0 39 49 0 0 -39 h\n1 g 4936 2183 N 0 39 49 0 0
      -39 h\n1 g 4888 2183 N 0 39 48 0 0 -39 h\n1 g 4839 2183 N 0 39 49 0 0
      -39 h\n1 g 4790 2183 N 0 39 49 0 0 -39 h\n1 g 4742 2183 N 0 39 48 0 0
      -39 h\n1 g 4693 2183 N 0 39 49 0 0 -39 h\n1 g 4645 2183 N 0 39 48 0 0
      -39 h\n1 g 4596 2183 N 0 39 49 0 0 -39 h\n.95 g 4547 2183 N 0 39 49 0 0
      -39 h\n.85 g 4499 2183 N 0 39 48 0 0 -39 h\n.8 g 4450 2183 N 0 39 49 0
      0 -39 h\n.8 g 4402 2183 N 0 39 48 0 0 -39 h\n.8 g 4353 2183 N 0 39 49 0
      0 -39 h\n.8 g 4304 2183 N 0 39 49 0 0 -39 h\n.8 g 4256 2183 N 0 39 48 0
      0 -39 h\n.8 g 4207 2183 N 0 39 49 0 0 -39 h\n.8 g 4159 2183 N 0 39 48 0
      0 -39 h\n.8 g 4110 2183 N 0 39 49 0 0 -39 h\n.8 g 4061 2183 N 0 39 49 0
      0 -39 h\n.8 g 4013 2183 N 0 39 48 0 0 -39 h\n.8 g 3964 2183 N 0 39 49 0
      0 -39 h\n.8 g 3915 2183 N 0 39 49 0 0 -39 h\n.8 g 3867 2183 N 0 39 48 0
      0 -39 h\n.8 g 3818 2183 N 0 39 49 0 0 -39 h\n.8 g 3770 2183 N 0 39 48 0
      0 -39 h\n.8 g 3721 2183 N 0 39 49 0 0 -39 h\n.8 g 3672 2183 N 0 39 49 0
      0 -39 h\n.8 g 3624 2183 N 0 39 48 0 0 -39 h\n.8 g 3575 2183 N 0 39 49 0
      0 -39 h\n.8 g 3527 2183 N 0 39 48 0 0 -39 h\n.8 g 3478 2183 N 0 39 49 0
      0 -39 h\n.8 g 3429 2183 N 0 39 49 0 0 -39 h\n.8 g 3381 2183 N 0 39 48 0
      0 -39 h\n.8 g 3332 2183 N 0 39 49 0 0 -39 h\n.8 g 3284 2183 N 0 39 48 0
      0 -39 h\n.8 g 3235 2183 N 0 39 49 0 0 -39 h\n.8 g 3186 2183 N 0 39 49 0
      0 -39 h\n.8 g 3138 2183 N 0 39 48 0 0 -39 h\n.8 g 3089 2183 N 0 39 49 0
      0 -39 h\n.8 g 3040 2183 N 0 39 49 0 0 -39 h\n.8 g 2992 2183 N 0 39 48 0
      0 -39 h\n.8 g 2943 2183 N 0 39 49 0 0 -39 h\n.8 g 2895 2183 N 0 39 48 0
      0 -39 h\n.8 g 2846 2183 N 0 39 49 0 0 -39 h\n.8 g 2797 2183 N 0 39 49 0
      0 -39 h\n.8 g 2749 2183 N 0 39 48 0 0 -39 h\n.8 g 2700 2183 N 0 39 49 0
      0 -39 h\n.85 g 2652 2183 N 0 39 48 0 0 -39 h\n.95 g 2603 2183 N 0 39 49
      0 0 -39 h\n1 g 2554 2183 N 0 39 49 0 0 -39 h\n1 g 2506 2183 N 0 39 48 0
      0 -39 h\n1 g 2457 2183 N 0 39 49 0 0 -39 h\n1 g 2409 2183 N 0 39 48 0 0
      -39 h\n1 g 2360 2183 N 0 39 49 0 0 -39 h\n1 g 2311 2183 N 0 39 49 0 0
      -39 h\n1 g 2263 2183 N 0 39 48 0 0 -39 h\n1 g 2214 2183 N 0 39 49 0 0
      -39 h\n1 g 2165 2183 N 0 39 49 0 0 -39 h\n1 g 2117 2183 N 0 39 48 0 0
      -39 h\n1 g 2068 2183 N 0 39 49 0 0 -39 h\n1 g 2020 2183 N 0 39 48 0 0
      -39 h\n1 g 1971 2183 N 0 39 49 0 0 -39 h\n1 g 1922 2183 N 0 39 49 0 0
      -39 h\n1 g 1874 2183 N 0 39 48 0 0 -39 h\n1 g 1825 2183 N 0 39 49 0 0
      -39 h\n1 g 1777 2183 N 0 39 48 0 0 -39 h\n1 g 1728 2183 N 0 39 49 0 0
      -39 h\n1 g 1679 2183 N 0 39 49 0 0 -39 h\n1 g 1631 2183 N 0 39 48 0 0
      -39 h\n1 g 1582 2183 N 0 39 49 0 0 -39 h\n1 g 1534 2183 N 0 39 48 0 0
      -39 h\n1 g 1485 2183 N 0 39 49 0 0 -39 h\n1 g 1436 2183 N 0 39 49 0 0
      -39 h\n1 g 1388 2183 N 0 39 48 0 0 -39 h\n1 g 1339 2183 N 0 39 49 0 0
      -39 h\n1 g 1290 2183 N 0 39 49 0 0 -39 h\n1 g 1242 2183 N 0 39 48 0 0
      -39 h\n1 g 1193 2183 N 0 39 49 0 0 -39 h\n1 g 5957 2144 N 0 39 49 0 0
      -39 h\n1 g 5909 2144 N 0 39 48 0 0 -39 h\n1 g 5860 2144 N 0 39 49 0 0
      -39 h\n1 g 5811 2144 N 0 39 49 0 0 -39 h\n1 g 5763 2144 N 0 39 48 0 0
      -39 h\n1 g 5714 2144 N 0 39 49 0 0 -39 h\n1 g 5665 2144 N 0 39 49 0 0
      -39 h\n1 g 5617 2144 N 0 39 48 0 0 -39 h\n1 g 5568 2144 N 0 39 49 0 0
      -39 h\n1 g 5520 2144 N 0 39 48 0 0 -39 h\n1 g 5471 2144 N 0 39 49 0 0
      -39 h\n1 g 5422 2144 N 0 39 49 0 0 -39 h\n1 g 5374 2144 N 0 39 48 0 0
      -39 h\n1 g 5325 2144 N 0 39 49 0 0 -39 h\n1 g 5277 2144 N 0 39 48 0 0
      -39 h\n1 g 5228 2144 N 0 39 49 0 0 -39 h\n1 g 5179 2144 N 0 39 49 0 0
      -39 h\n1 g 5131 2144 N 0 39 48 0 0 -39 h\n1 g 5082 2144 N 0 39 49 0 0
      -39 h\n1 g 5034 2144 N 0 39 48 0 0 -39 h\n1 g 4985 2144 N 0 39 49 0 0
      -39 h\n1 g 4936 2144 N 0 39 49 0 0 -39 h\n1 g 4888 2144 N 0 39 48 0 0
      -39 h\n1 g 4839 2144 N 0 39 49 0 0 -39 h\n1 g 4790 2144 N 0 39 49 0 0
      -39 h\n1 g 4742 2144 N 0 39 48 0 0 -39 h\n1 g 4693 2144 N 0 39 49 0 0
      -39 h\n1 g 4645 2144 N 0 39 48 0 0 -39 h\n1 g 4596 2144 N 0 39 49 0 0
      -39 h\n1 g 4547 2144 N 0 39 49 0 0 -39 h\n.9 g 4499 2144 N 0 39 48 0 0
      -39 h\n.8 g 4450 2144 N 0 39 49 0 0 -39 h\n.8 g 4402 2144 N 0 39 48 0 0
      -39 h\n.8 g 4353 2144 N 0 39 49 0 0 -39 h\n.8 g 4304 2144 N 0 39 49 0 0
      -39 h\n.8 g 4256 2144 N 0 39 48 0 0 -39 h\n.8 g 4207 2144 N 0 39 49 0 0
      -39 h\n.8 g 4159 2144 N 0 39 48 0 0 -39 h\n.8 g 4110 2144 N 0 39 49 0 0
      -39 h\n.8 g 4061 2144 N 0 39 49 0 0 -39 h\n.8 g 4013 2144 N 0 39 48 0 0
      -39 h\n.8 g 3964 2144 N 0 39 49 0 0 -39 h\n.8 g 3915 2144 N 0 39 49 0 0
      -39 h\n.8 g 3867 2144 N 0 39 48 0 0 -39 h\n.8 g 3818 2144 N 0 39 49 0 0
      -39 h\n.8 g 3770 2144 N 0 39 48 0 0 -39 h\n.8 g 3721 2144 N 0 39 49 0 0
      -39 h\n.8 g 3672 2144 N 0 39 49 0 0 -39 h\n.8 g 3624 2144 N 0 39 48 0 0
      -39 h\n.8 g 3575 2144 N 0 39 49 0 0 -39 h\n.8 g 3527 2144 N 0 39 48 0 0
      -39 h\n.8 g 3478 2144 N 0 39 49 0 0 -39 h\n.8 g 3429 2144 N 0 39 49 0 0
      -39 h\n.8 g 3381 2144 N 0 39 48 0 0 -39 h\n.8 g 3332 2144 N 0 39 49 0 0
      -39 h\n.8 g 3284 2144 N 0 39 48 0 0 -39 h\n.8 g 3235 2144 N 0 39 49 0 0
      -39 h\n.8 g 3186 2144 N 0 39 49 0 0 -39 h\n.8 g 3138 2144 N 0 39 48 0 0
      -39 h\n.8 g 3089 2144 N 0 39 49 0 0 -39 h\n.8 g 3040 2144 N 0 39 49 0 0
      -39 h\n.8 g 2992 2144 N 0 39 48 0 0 -39 h\n.8 g 2943 2144 N 0 39 49 0 0
      -39 h\n.8 g 2895 2144 N 0 39 48 0 0 -39 h\n.8 g 2846 2144 N 0 39 49 0 0
      -39 h\n.8 g 2797 2144 N 0 39 49 0 0 -39 h\n.8 g 2749 2144 N 0 39 48 0 0
      -39 h\n.8 g 2700 2144 N 0 39 49 0 0 -39 h\n.9 g 2652 2144 N 0 39 48 0 0
      -39 h\n1 g 2603 2144 N 0 39 49 0 0 -39 h\n1 g 2554 2144 N 0 39 49 0 0
      -39 h\n1 g 2506 2144 N 0 39 48 0 0 -39 h\n1 g 2457 2144 N 0 39 49 0 0
      -39 h\n1 g 2409 2144 N 0 39 48 0 0 -39 h\n1 g 2360 2144 N 0 39 49 0 0
      -39 h\n1 g 2311 2144 N 0 39 49 0 0 -39 h\n1 g 2263 2144 N 0 39 48 0 0
      -39 h\n1 g 2214 2144 N 0 39 49 0 0 -39 h\n1 g 2165 2144 N 0 39 49 0 0
      -39 h\n1 g 2117 2144 N 0 39 48 0 0 -39 h\n1 g 2068 2144 N 0 39 49 0 0
      -39 h\n1 g 2020 2144 N 0 39 48 0 0 -39 h\n1 g 1971 2144 N 0 39 49 0 0
      -39 h\n1 g 1922 2144 N 0 39 49 0 0 -39 h\n1 g 1874 2144 N 0 39 48 0 0
      -39 h\n1 g 1825 2144 N 0 39 49 0 0 -39 h\n1 g 1777 2144 N 0 39 48 0 0
      -39 h\n1 g 1728 2144 N 0 39 49 0 0 -39 h\n1 g 1679 2144 N 0 39 49 0 0
      -39 h\n1 g 1631 2144 N 0 39 48 0 0 -39 h\n1 g 1582 2144 N 0 39 49 0 0
      -39 h\n1 g 1534 2144 N 0 39 48 0 0 -39 h\n1 g 1485 2144 N 0 39 49 0 0
      -39 h\n1 g 1436 2144 N 0 39 49 0 0 -39 h\n1 g 1388 2144 N 0 39 48 0 0
      -39 h\n1 g 1339 2144 N 0 39 49 0 0 -39 h\n1 g 1290 2144 N 0 39 49 0 0
      -39 h\n1 g 1242 2144 N 0 39 48 0 0 -39 h\n1 g 1193 2144 N 0 39 49 0 0
      -39 h\n1 g 5957 2105 N 0 39 49 0 0 -39 h\n1 g 5909 2105 N 0 39 48 0 0
      -39 h\n1 g 5860 2105 N 0 39 49 0 0 -39 h\n1 g 5811 2105 N 0 39 49 0 0
      -39 h\n1 g 5763 2105 N 0 39 48 0 0 -39 h\n1 g 5714 2105 N 0 39 49 0 0
      -39 h\n1 g 5665 2105 N 0 39 49 0 0 -39 h\n1 g 5617 2105 N 0 39 48 0 0
      -39 h\n1 g 5568 2105 N 0 39 49 0 0 -39 h\n1 g 5520 2105 N 0 39 48 0 0
      -39 h\n1 g 5471 2105 N 0 39 49 0 0 -39 h\n1 g 5422 2105 N 0 39 49 0 0
      -39 h\n1 g 5374 2105 N 0 39 48 0 0 -39 h\n1 g 5325 2105 N 0 39 49 0 0
      -39 h\n1 g 5277 2105 N 0 39 48 0 0 -39 h\n1 g 5228 2105 N 0 39 49 0 0
      -39 h\n1 g 5179 2105 N 0 39 49 0 0 -39 h\n1 g 5131 2105 N 0 39 48 0 0
      -39 h\n1 g 5082 2105 N 0 39 49 0 0 -39 h\n1 g 5034 2105 N 0 39 48 0 0
      -39 h\n1 g 4985 2105 N 0 39 49 0 0 -39 h\n1 g 4936 2105 N 0 39 49 0 0
      -39 h\n1 g 4888 2105 N 0 39 48 0 0 -39 h\n1 g 4839 2105 N 0 39 49 0 0
      -39 h\n1 g 4790 2105 N 0 39 49 0 0 -39 h\n1 g 4742 2105 N 0 39 48 0 0
      -39 h\n1 g 4693 2105 N 0 39 49 0 0 -39 h\n1 g 4645 2105 N 0 39 48 0 0
      -39 h\n1 g 4596 2105 N 0 39 49 0 0 -39 h\n1 g 4547 2105 N 0 39 49 0 0
      -39 h\n.9 g 4499 2105 N 0 39 48 0 0 -39 h\n.8 g 4450 2105 N 0 39 49 0 0
      -39 h\n.8 g 4402 2105 N 0 39 48 0 0 -39 h\n.8 g 4353 2105 N 0 39 49 0 0
      -39 h\n.8 g 4304 2105 N 0 39 49 0 0 -39 h\n.8 g 4256 2105 N 0 39 48 0 0
      -39 h\n.8 g 4207 2105 N 0 39 49 0 0 -39 h\n.8 g 4159 2105 N 0 39 48 0 0
      -39 h\n.8 g 4110 2105 N 0 39 49 0 0 -39 h\n.8 g 4061 2105 N 0 39 49 0 0
      -39 h\n.8 g 4013 2105 N 0 39 48 0 0 -39 h\n.8 g 3964 2105 N 0 39 49 0 0
      -39 h\n.8 g 3915 2105 N 0 39 49 0 0 -39 h\n.8 g 3867 2105 N 0 39 48 0 0
      -39 h\n.8 g 3818 2105 N 0 39 49 0 0 -39 h\n.8 g 3770 2105 N 0 39 48 0 0
      -39 h\n.8 g 3721 2105 N 0 39 49 0 0 -39 h\n.8 g 3672 2105 N 0 39 49 0 0
      -39 h\n.8 g 3624 2105 N 0 39 48 0 0 -39 h\n.8 g 3575 2105 N 0 39 49 0 0
      -39 h\n.8 g 3527 2105 N 0 39 48 0 0 -39 h\n.8 g 3478 2105 N 0 39 49 0 0
      -39 h\n.8 g 3429 2105 N 0 39 49 0 0 -39 h\n.8 g 3381 2105 N 0 39 48 0 0
      -39 h\n.8 g 3332 2105 N 0 39 49 0 0 -39 h\n.8 g 3284 2105 N 0 39 48 0 0
      -39 h\n.8 g 3235 2105 N 0 39 49 0 0 -39 h\n.8 g 3186 2105 N 0 39 49 0 0
      -39 h\n.8 g 3138 2105 N 0 39 48 0 0 -39 h\n.8 g 3089 2105 N 0 39 49 0 0
      -39 h\n.8 g 3040 2105 N 0 39 49 0 0 -39 h\n.8 g 2992 2105 N 0 39 48 0 0
      -39 h\n.8 g 2943 2105 N 0 39 49 0 0 -39 h\n.8 g 2895 2105 N 0 39 48 0 0
      -39 h\n.8 g 2846 2105 N 0 39 49 0 0 -39 h\n.8 g 2797 2105 N 0 39 49 0 0
      -39 h\n.8 g 2749 2105 N 0 39 48 0 0 -39 h\n.8 g 2700 2105 N 0 39 49 0 0
      -39 h\n.9 g 2652 2105 N 0 39 48 0 0 -39 h\n1 g 2603 2105 N 0 39 49 0 0
      -39 h\n1 g 2554 2105 N 0 39 49 0 0 -39 h\n1 g 2506 2105 N 0 39 48 0 0
      -39 h\n1 g 2457 2105 N 0 39 49 0 0 -39 h\n1 g 2409 2105 N 0 39 48 0 0
      -39 h\n1 g 2360 2105 N 0 39 49 0 0 -39 h\n1 g 2311 2105 N 0 39 49 0 0
      -39 h\n1 g 2263 2105 N 0 39 48 0 0 -39 h\n1 g 2214 2105 N 0 39 49 0 0
      -39 h\n1 g 2165 2105 N 0 39 49 0 0 -39 h\n1 g 2117 2105 N 0 39 48 0 0
      -39 h\n1 g 2068 2105 N 0 39 49 0 0 -39 h\n1 g 2020 2105 N 0 39 48 0 0
      -39 h\n1 g 1971 2105 N 0 39 49 0 0 -39 h\n1 g 1922 2105 N 0 39 49 0 0
      -39 h\n1 g 1874 2105 N 0 39 48 0 0 -39 h\n1 g 1825 2105 N 0 39 49 0 0
      -39 h\n1 g 1777 2105 N 0 39 48 0 0 -39 h\n1 g 1728 2105 N 0 39 49 0 0
      -39 h\n1 g 1679 2105 N 0 39 49 0 0 -39 h\n1 g 1631 2105 N 0 39 48 0 0
      -39 h\n1 g 1582 2105 N 0 39 49 0 0 -39 h\n1 g 1534 2105 N 0 39 48 0 0
      -39 h\n1 g 1485 2105 N 0 39 49 0 0 -39 h\n1 g 1436 2105 N 0 39 49 0 0
      -39 h\n1 g 1388 2105 N 0 39 48 0 0 -39 h\n1 g 1339 2105 N 0 39 49 0 0
      -39 h\n1 g 1290 2105 N 0 39 49 0 0 -39 h\n1 g 1242 2105 N 0 39 48 0 0
      -39 h\n1 g 1193 2105 N 0 39 49 0 0 -39 h\n1 g 5957 2066 N 0 38 49 0 0
      -38 h\n1 g 5909 2066 N 0 38 48 0 0 -38 h\n1 g 5860 2066 N 0 38 49 0 0
      -38 h\n1 g 5811 2066 N 0 38 49 0 0 -38 h\n1 g 5763 2066 N 0 38 48 0 0
      -38 h\n1 g 5714 2066 N 0 38 49 0 0 -38 h\n1 g 5665 2066 N 0 38 49 0 0
      -38 h\n1 g 5617 2066 N 0 38 48 0 0 -38 h\n1 g 5568 2066 N 0 38 49 0 0
      -38 h\n1 g 5520 2066 N 0 38 48 0 0 -38 h\n1 g 5471 2066 N 0 38 49 0 0
      -38 h\n1 g 5422 2066 N 0 38 49 0 0 -38 h\n1 g 5374 2066 N 0 38 48 0 0
      -38 h\n1 g 5325 2066 N 0 38 49 0 0 -38 h\n1 g 5277 2066 N 0 38 48 0 0
      -38 h\n1 g 5228 2066 N 0 38 49 0 0 -38 h\n1 g 5179 2066 N 0 38 49 0 0
      -38 h\n1 g 5131 2066 N 0 38 48 0 0 -38 h\n1 g 5082 2066 N 0 38 49 0 0
      -38 h\n1 g 5034 2066 N 0 38 48 0 0 -38 h\n1 g 4985 2066 N 0 38 49 0 0
      -38 h\n1 g 4936 2066 N 0 38 49 0 0 -38 h\n1 g 4888 2066 N 0 38 48 0 0
      -38 h\n1 g 4839 2066 N 0 38 49 0 0 -38 h\n1 g 4790 2066 N 0 38 49 0 0
      -38 h\n1 g 4742 2066 N 0 38 48 0 0 -38 h\n1 g 4693 2066 N 0 38 49 0 0
      -38 h\n1 g 4645 2066 N 0 38 48 0 0 -38 h\n1 g 4596 2066 N 0 38 49 0 0
      -38 h\n1 g 4547 2066 N 0 38 49 0 0 -38 h\n.9 g 4499 2066 N 0 38 48 0 0
      -38 h\n.8 g 4450 2066 N 0 38 49 0 0 -38 h\n.8 g 4402 2066 N 0 38 48 0 0
      -38 h\n.8 g 4353 2066 N 0 38 49 0 0 -38 h\n.8 g 4304 2066 N 0 38 49 0 0
      -38 h\n.8 g 4256 2066 N 0 38 48 0 0 -38 h\n.8 g 4207 2066 N 0 38 49 0 0
      -38 h\n.8 g 4159 2066 N 0 38 48 0 0 -38 h\n.8 g 4110 2066 N 0 38 49 0 0
      -38 h\n.8 g 4061 2066 N 0 38 49 0 0 -38 h\n.8 g 4013 2066 N 0 38 48 0 0
      -38 h\n.8 g 3964 2066 N 0 38 49 0 0 -38 h\n.8 g 3915 2066 N 0 38 49 0 0
      -38 h\n.8 g 3867 2066 N 0 38 48 0 0 -38 h\n.8 g 3818 2066 N 0 38 49 0 0
      -38 h\n.8 g 3770 2066 N 0 38 48 0 0 -38 h\n.8 g 3721 2066 N 0 38 49 0 0
      -38 h\n.8 g 3672 2066 N 0 38 49 0 0 -38 h\n.8 g 3624 2066 N 0 38 48 0 0
      -38 h\n.8 g 3575 2066 N 0 38 49 0 0 -38 h\n.8 g 3527 2066 N 0 38 48 0 0
      -38 h\n.8 g 3478 2066 N 0 38 49 0 0 -38 h\n.8 g 3429 2066 N 0 38 49 0 0
      -38 h\n.8 g 3381 2066 N 0 38 48 0 0 -38 h\n.8 g 3332 2066 N 0 38 49 0 0
      -38 h\n.8 g 3284 2066 N 0 38 48 0 0 -38 h\n.8 g 3235 2066 N 0 38 49 0 0
      -38 h\n.8 g 3186 2066 N 0 38 49 0 0 -38 h\n.8 g 3138 2066 N 0 38 48 0 0
      -38 h\n.8 g 3089 2066 N 0 38 49 0 0 -38 h\n.8 g 3040 2066 N 0 38 49 0 0
      -38 h\n.8 g 2992 2066 N 0 38 48 0 0 -38 h\n.8 g 2943 2066 N 0 38 49 0 0
      -38 h\n.8 g 2895 2066 N 0 38 48 0 0 -38 h\n.8 g 2846 2066 N 0 38 49 0 0
      -38 h\n.8 g 2797 2066 N 0 38 49 0 0 -38 h\n.8 g 2749 2066 N 0 38 48 0 0
      -38 h\n.8 g 2700 2066 N 0 38 49 0 0 -38 h\n.9 g 2652 2066 N 0 38 48 0 0
      -38 h\n1 g 2603 2066 N 0 38 49 0 0 -38 h\n1 g 2554 2066 N 0 38 49 0 0
      -38 h\n1 g 2506 2066 N 0 38 48 0 0 -38 h\n1 g 2457 2066 N 0 38 49 0 0
      -38 h\n1 g 2409 2066 N 0 38 48 0 0 -38 h\n1 g 2360 2066 N 0 38 49 0 0
      -38 h\n1 g 2311 2066 N 0 38 49 0 0 -38 h\n1 g 2263 2066 N 0 38 48 0 0
      -38 h\n1 g 2214 2066 N 0 38 49 0 0 -38 h\n1 g 2165 2066 N 0 38 49 0 0
      -38 h\n1 g 2117 2066 N 0 38 48 0 0 -38 h\n1 g 2068 2066 N 0 38 49 0 0
      -38 h\n1 g 2020 2066 N 0 38 48 0 0 -38 h\n1 g 1971 2066 N 0 38 49 0 0
      -38 h\n1 g 1922 2066 N 0 38 49 0 0 -38 h\n1 g 1874 2066 N 0 38 48 0 0
      -38 h\n1 g 1825 2066 N 0 38 49 0 0 -38 h\n1 g 1777 2066 N 0 38 48 0 0
      -38 h\n1 g 1728 2066 N 0 38 49 0 0 -38 h\n1 g 1679 2066 N 0 38 49 0 0
      -38 h\n1 g 1631 2066 N 0 38 48 0 0 -38 h\n1 g 1582 2066 N 0 38 49 0 0
      -38 h\n1 g 1534 2066 N 0 38 48 0 0 -38 h\n1 g 1485 2066 N 0 38 49 0 0
      -38 h\n1 g 1436 2066 N 0 38 49 0 0 -38 h\n1 g 1388 2066 N 0 38 48 0 0
      -38 h\n1 g 1339 2066 N 0 38 49 0 0 -38 h\n1 g 1290 2066 N 0 38 49 0 0
      -38 h\n1 g 1242 2066 N 0 38 48 0 0 -38 h\n1 g 1193 2066 N 0 38 49 0 0
      -38 h\n1 g 5957 2028 N 0 39 49 0 0 -39 h\n1 g 5909 2028 N 0 39 48 0 0
      -39 h\n1 g 5860 2028 N 0 39 49 0 0 -39 h\n1 g 5811 2028 N 0 39 49 0 0
      -39 h\n1 g 5763 2028 N 0 39 48 0 0 -39 h\n1 g 5714 2028 N 0 39 49 0 0
      -39 h\n1 g 5665 2028 N 0 39 49 0 0 -39 h\n1 g 5617 2028 N 0 39 48 0 0
      -39 h\n1 g 5568 2028 N 0 39 49 0 0 -39 h\n1 g 5520 2028 N 0 39 48 0 0
      -39 h\n1 g 5471 2028 N 0 39 49 0 0 -39 h\n1 g 5422 2028 N 0 39 49 0 0
      -39 h\n1 g 5374 2028 N 0 39 48 0 0 -39 h\n1 g 5325 2028 N 0 39 49 0 0
      -39 h\n1 g 5277 2028 N 0 39 48 0 0 -39 h\n1 g 5228 2028 N 0 39 49 0 0
      -39 h\n1 g 5179 2028 N 0 39 49 0 0 -39 h\n1 g 5131 2028 N 0 39 48 0 0
      -39 h\n1 g 5082 2028 N 0 39 49 0 0 -39 h\n1 g 5034 2028 N 0 39 48 0 0
      -39 h\n1 g 4985 2028 N 0 39 49 0 0 -39 h\n1 g 4936 2028 N 0 39 49 0 0
      -39 h\n1 g 4888 2028 N 0 39 48 0 0 -39 h\n1 g 4839 2028 N 0 39 49 0 0
      -39 h\n1 g 4790 2028 N 0 39 49 0 0 -39 h\n1 g 4742 2028 N 0 39 48 0 0
      -39 h\n1 g 4693 2028 N 0 39 49 0 0 -39 h\n1 g 4645 2028 N 0 39 48 0 0
      -39 h\n1 g 4596 2028 N 0 39 49 0 0 -39 h\n1 g 4547 2028 N 0 39 49 0 0
      -39 h\n.95 g 4499 2028 N 0 39 48 0 0 -39 h\n.85 g 4450 2028 N 0 39 49 0
      0 -39 h\n.8 g 4402 2028 N 0 39 48 0 0 -39 h\n.8 g 4353 2028 N 0 39 49 0
      0 -39 h\n.8 g 4304 2028 N 0 39 49 0 0 -39 h\n.8 g 4256 2028 N 0 39 48 0
      0 -39 h\n.8 g 4207 2028 N 0 39 49 0 0 -39 h\n.8 g 4159 2028 N 0 39 48 0
      0 -39 h\n.8 g 4110 2028 N 0 39 49 0 0 -39 h\n.8 g 4061 2028 N 0 39 49 0
      0 -39 h\n.8 g 4013 2028 N 0 39 48 0 0 -39 h\n.8 g 3964 2028 N 0 39 49 0
      0 -39 h\n.8 g 3915 2028 N 0 39 49 0 0 -39 h\n.8 g 3867 2028 N 0 39 48 0
      0 -39 h\n.8 g 3818 2028 N 0 39 49 0 0 -39 h\n.8 g 3770 2028 N 0 39 48 0
      0 -39 h\n.8 g 3721 2028 N 0 39 49 0 0 -39 h\n.8 g 3672 2028 N 0 39 49 0
      0 -39 h\n.8 g 3624 2028 N 0 39 48 0 0 -39 h\n.8 g 3575 2028 N 0 39 49 0
      0 -39 h\n.8 g 3527 2028 N 0 39 48 0 0 -39 h\n.8 g 3478 2028 N 0 39 49 0
      0 -39 h\n.8 g 3429 2028 N 0 39 49 0 0 -39 h\n.8 g 3381 2028 N 0 39 48 0
      0 -39 h\n.8 g 3332 2028 N 0 39 49 0 0 -39 h\n.8 g 3284 2028 N 0 39 48 0
      0 -39 h\n.8 g 3235 2028 N 0 39 49 0 0 -39 h\n.8 g 3186 2028 N 0 39 49 0
      0 -39 h\n.8 g 3138 2028 N 0 39 48 0 0 -39 h\n.8 g 3089 2028 N 0 39 49 0
      0 -39 h\n.8 g 3040 2028 N 0 39 49 0 0 -39 h\n.8 g 2992 2028 N 0 39 48 0
      0 -39 h\n.8 g 2943 2028 N 0 39 49 0 0 -39 h\n.8 g 2895 2028 N 0 39 48 0
      0 -39 h\n.8 g 2846 2028 N 0 39 49 0 0 -39 h\n.8 g 2797 2028 N 0 39 49 0
      0 -39 h\n.8 g 2749 2028 N 0 39 48 0 0 -39 h\n.85 g 2700 2028 N 0 39 49
      0 0 -39 h\n.95 g 2652 2028 N 0 39 48 0 0 -39 h\n1 g 2603 2028 N 0 39 49
      0 0 -39 h\n1 g 2554 2028 N 0 39 49 0 0 -39 h\n1 g 2506 2028 N 0 39 48 0
      0 -39 h\n1 g 2457 2028 N 0 39 49 0 0 -39 h\n1 g 2409 2028 N 0 39 48 0 0
      -39 h\n1 g 2360 2028 N 0 39 49 0 0 -39 h\n1 g 2311 2028 N 0 39 49 0 0
      -39 h\n1 g 2263 2028 N 0 39 48 0 0 -39 h\n1 g 2214 2028 N 0 39 49 0 0
      -39 h\n1 g 2165 2028 N 0 39 49 0 0 -39 h\n1 g 2117 2028 N 0 39 48 0 0
      -39 h\n1 g 2068 2028 N 0 39 49 0 0 -39 h\n1 g 2020 2028 N 0 39 48 0 0
      -39 h\n1 g 1971 2028 N 0 39 49 0 0 -39 h\n1 g 1922 2028 N 0 39 49 0 0
      -39 h\n1 g 1874 2028 N 0 39 48 0 0 -39 h\n1 g 1825 2028 N 0 39 49 0 0
      -39 h\n1 g 1777 2028 N 0 39 48 0 0 -39 h\n1 g 1728 2028 N 0 39 49 0 0
      -39 h\n1 g 1679 2028 N 0 39 49 0 0 -39 h\n1 g 1631 2028 N 0 39 48 0 0
      -39 h\n1 g 1582 2028 N 0 39 49 0 0 -39 h\n1 g 1534 2028 N 0 39 48 0 0
      -39 h\n1 g 1485 2028 N 0 39 49 0 0 -39 h\n1 g 1436 2028 N 0 39 49 0 0
      -39 h\n1 g 1388 2028 N 0 39 48 0 0 -39 h\n1 g 1339 2028 N 0 39 49 0 0
      -39 h\n1 g 1290 2028 N 0 39 49 0 0 -39 h\n1 g 1242 2028 N 0 39 48 0 0
      -39 h\n1 g 1193 2028 N 0 39 49 0 0 -39 h\n1 g 5957 1989 N 0 39 49 0 0
      -39 h\n1 g 5909 1989 N 0 39 48 0 0 -39 h\n1 g 5860 1989 N 0 39 49 0 0
      -39 h\n1 g 5811 1989 N 0 39 49 0 0 -39 h\n1 g 5763 1989 N 0 39 48 0 0
      -39 h\n1 g 5714 1989 N 0 39 49 0 0 -39 h\n1 g 5665 1989 N 0 39 49 0 0
      -39 h\n1 g 5617 1989 N 0 39 48 0 0 -39 h\n1 g 5568 1989 N 0 39 49 0 0
      -39 h\n1 g 5520 1989 N 0 39 48 0 0 -39 h\n1 g 5471 1989 N 0 39 49 0 0
      -39 h\n1 g 5422 1989 N 0 39 49 0 0 -39 h\n1 g 5374 1989 N 0 39 48 0 0
      -39 h\n1 g 5325 1989 N 0 39 49 0 0 -39 h\n1 g 5277 1989 N 0 39 48 0 0
      -39 h\n1 g 5228 1989 N 0 39 49 0 0 -39 h\n1 g 5179 1989 N 0 39 49 0 0
      -39 h\n1 g 5131 1989 N 0 39 48 0 0 -39 h\n1 g 5082 1989 N 0 39 49 0 0
      -39 h\n1 g 5034 1989 N 0 39 48 0 0 -39 h\n1 g 4985 1989 N 0 39 49 0 0
      -39 h\n1 g 4936 1989 N 0 39 49 0 0 -39 h\n1 g 4888 1989 N 0 39 48 0 0
      -39 h\n1 g 4839 1989 N 0 39 49 0 0 -39 h\n1 g 4790 1989 N 0 39 49 0 0
      -39 h\n1 g 4742 1989 N 0 39 48 0 0 -39 h\n1 g 4693 1989 N 0 39 49 0 0
      -39 h\n1 g 4645 1989 N 0 39 48 0 0 -39 h\n1 g 4596 1989 N 0 39 49 0 0
      -39 h\n1 g 4547 1989 N 0 39 49 0 0 -39 h\n1 g 4499 1989 N 0 39 48 0 0
      -39 h\n.9 g 4450 1989 N 0 39 49 0 0 -39 h\n.8 g 4402 1989 N 0 39 48 0 0
      -39 h\n.8 g 4353 1989 N 0 39 49 0 0 -39 h\n.8 g 4304 1989 N 0 39 49 0 0
      -39 h\n.8 g 4256 1989 N 0 39 48 0 0 -39 h\n.8 g 4207 1989 N 0 39 49 0 0
      -39 h\n.8 g 4159 1989 N 0 39 48 0 0 -39 h\n.8 g 4110 1989 N 0 39 49 0 0
      -39 h\n.8 g 4061 1989 N 0 39 49 0 0 -39 h\n.8 g 4013 1989 N 0 39 48 0 0
      -39 h\n.8 g 3964 1989 N 0 39 49 0 0 -39 h\n.8 g 3915 1989 N 0 39 49 0 0
      -39 h\n.8 g 3867 1989 N 0 39 48 0 0 -39 h\n.8 g 3818 1989 N 0 39 49 0 0
      -39 h\n.8 g 3770 1989 N 0 39 48 0 0 -39 h\n.8 g 3721 1989 N 0 39 49 0 0
      -39 h\n.8 g 3672 1989 N 0 39 49 0 0 -39 h\n.8 g 3624 1989 N 0 39 48 0 0
      -39 h\n.8 g 3575 1989 N 0 39 49 0 0 -39 h\n.8 g 3527 1989 N 0 39 48 0 0
      -39 h\n.8 g 3478 1989 N 0 39 49 0 0 -39 h\n.8 g 3429 1989 N 0 39 49 0 0
      -39 h\n.8 g 3381 1989 N 0 39 48 0 0 -39 h\n.8 g 3332 1989 N 0 39 49 0 0
      -39 h\n.8 g 3284 1989 N 0 39 48 0 0 -39 h\n.8 g 3235 1989 N 0 39 49 0 0
      -39 h\n.8 g 3186 1989 N 0 39 49 0 0 -39 h\n.8 g 3138 1989 N 0 39 48 0 0
      -39 h\n.8 g 3089 1989 N 0 39 49 0 0 -39 h\n.8 g 3040 1989 N 0 39 49 0 0
      -39 h\n.8 g 2992 1989 N 0 39 48 0 0 -39 h\n.8 g 2943 1989 N 0 39 49 0 0
      -39 h\n.8 g 2895 1989 N 0 39 48 0 0 -39 h\n.8 g 2846 1989 N 0 39 49 0 0
      -39 h\n.8 g 2797 1989 N 0 39 49 0 0 -39 h\n.8 g 2749 1989 N 0 39 48 0 0
      -39 h\n.9 g 2700 1989 N 0 39 49 0 0 -39 h\n1 g 2652 1989 N 0 39 48 0 0
      -39 h\n1 g 2603 1989 N 0 39 49 0 0 -39 h\n1 g 2554 1989 N 0 39 49 0 0
      -39 h\n1 g 2506 1989 N 0 39 48 0 0 -39 h\n1 g 2457 1989 N 0 39 49 0 0
      -39 h\n1 g 2409 1989 N 0 39 48 0 0 -39 h\n1 g 2360 1989 N 0 39 49 0 0
      -39 h\n1 g 2311 1989 N 0 39 49 0 0 -39 h\n1 g 2263 1989 N 0 39 48 0 0
      -39 h\n1 g 2214 1989 N 0 39 49 0 0 -39 h\n1 g 2165 1989 N 0 39 49 0 0
      -39 h\n1 g 2117 1989 N 0 39 48 0 0 -39 h\n1 g 2068 1989 N 0 39 49 0 0
      -39 h\n1 g 2020 1989 N 0 39 48 0 0 -39 h\n1 g 1971 1989 N 0 39 49 0 0
      -39 h\n1 g 1922 1989 N 0 39 49 0 0 -39 h\n1 g 1874 1989 N 0 39 48 0 0
      -39 h\n1 g 1825 1989 N 0 39 49 0 0 -39 h\n1 g 1777 1989 N 0 39 48 0 0
      -39 h\n1 g 1728 1989 N 0 39 49 0 0 -39 h\n1 g 1679 1989 N 0 39 49 0 0
      -39 h\n1 g 1631 1989 N 0 39 48 0 0 -39 h\n1 g 1582 1989 N 0 39 49 0 0
      -39 h\n1 g 1534 1989 N 0 39 48 0 0 -39 h\n1 g 1485 1989 N 0 39 49 0 0
      -39 h\n1 g 1436 1989 N 0 39 49 0 0 -39 h\n1 g 1388 1989 N 0 39 48 0 0
      -39 h\n1 g 1339 1989 N 0 39 49 0 0 -39 h\n1 g 1290 1989 N 0 39 49 0 0
      -39 h\n1 g 1242 1989 N 0 39 48 0 0 -39 h\n1 g 1193 1989 N 0 39 49 0 0
      -39 h\n1 g 5957 1950 N 0 39 49 0 0 -39 h\n1 g 5909 1950 N 0 39 48 0 0
      -39 h\n1 g 5860 1950 N 0 39 49 0 0 -39 h\n1 g 5811 1950 N 0 39 49 0 0
      -39 h\n1 g 5763 1950 N 0 39 48 0 0 -39 h\n1 g 5714 1950 N 0 39 49 0 0
      -39 h\n1 g 5665 1950 N 0 39 49 0 0 -39 h\n1 g 5617 1950 N 0 39 48 0 0
      -39 h\n1 g 5568 1950 N 0 39 49 0 0 -39 h\n1 g 5520 1950 N 0 39 48 0 0
      -39 h\n1 g 5471 1950 N 0 39 49 0 0 -39 h\n1 g 5422 1950 N 0 39 49 0 0
      -39 h\n1 g 5374 1950 N 0 39 48 0 0 -39 h\n1 g 5325 1950 N 0 39 49 0 0
      -39 h\n1 g 5277 1950 N 0 39 48 0 0 -39 h\n1 g 5228 1950 N 0 39 49 0 0
      -39 h\n1 g 5179 1950 N 0 39 49 0 0 -39 h\n1 g 5131 1950 N 0 39 48 0 0
      -39 h\n1 g 5082 1950 N 0 39 49 0 0 -39 h\n1 g 5034 1950 N 0 39 48 0 0
      -39 h\n1 g 4985 1950 N 0 39 49 0 0 -39 h\n1 g 4936 1950 N 0 39 49 0 0
      -39 h\n1 g 4888 1950 N 0 39 48 0 0 -39 h\n1 g 4839 1950 N 0 39 49 0 0
      -39 h\n1 g 4790 1950 N 0 39 49 0 0 -39 h\n1 g 4742 1950 N 0 39 48 0 0
      -39 h\n1 g 4693 1950 N 0 39 49 0 0 -39 h\n1 g 4645 1950 N 0 39 48 0 0
      -39 h\n1 g 4596 1950 N 0 39 49 0 0 -39 h\n1 g 4547 1950 N 0 39 49 0 0
      -39 h\n1 g 4499 1950 N 0 39 48 0 0 -39 h\n.9 g 4450 1950 N 0 39 49 0 0
      -39 h\n.8 g 4402 1950 N 0 39 48 0 0 -39 h\n.8 g 4353 1950 N 0 39 49 0 0
      -39 h\n.8 g 4304 1950 N 0 39 49 0 0 -39 h\n.8 g 4256 1950 N 0 39 48 0 0
      -39 h\n.8 g 4207 1950 N 0 39 49 0 0 -39 h\n.8 g 4159 1950 N 0 39 48 0 0
      -39 h\n.8 g 4110 1950 N 0 39 49 0 0 -39 h\n.8 g 4061 1950 N 0 39 49 0 0
      -39 h\n.8 g 4013 1950 N 0 39 48 0 0 -39 h\n.8 g 3964 1950 N 0 39 49 0 0
      -39 h\n.8 g 3915 1950 N 0 39 49 0 0 -39 h\n.8 g 3867 1950 N 0 39 48 0 0
      -39 h\n.8 g 3818 1950 N 0 39 49 0 0 -39 h\n.8 g 3770 1950 N 0 39 48 0 0
      -39 h\n.8 g 3721 1950 N 0 39 49 0 0 -39 h\n.8 g 3672 1950 N 0 39 49 0 0
      -39 h\n.8 g 3624 1950 N 0 39 48 0 0 -39 h\n.8 g 3575 1950 N 0 39 49 0 0
      -39 h\n.8 g 3527 1950 N 0 39 48 0 0 -39 h\n.8 g 3478 1950 N 0 39 49 0 0
      -39 h\n.8 g 3429 1950 N 0 39 49 0 0 -39 h\n.8 g 3381 1950 N 0 39 48 0 0
      -39 h\n.8 g 3332 1950 N 0 39 49 0 0 -39 h\n.8 g 3284 1950 N 0 39 48 0 0
      -39 h\n.8 g 3235 1950 N 0 39 49 0 0 -39 h\n.8 g 3186 1950 N 0 39 49 0 0
      -39 h\n.8 g 3138 1950 N 0 39 48 0 0 -39 h\n.8 g 3089 1950 N 0 39 49 0 0
      -39 h\n.8 g 3040 1950 N 0 39 49 0 0 -39 h\n.8 g 2992 1950 N 0 39 48 0 0
      -39 h\n.8 g 2943 1950 N 0 39 49 0 0 -39 h\n.8 g 2895 1950 N 0 39 48 0 0
      -39 h\n.8 g 2846 1950 N 0 39 49 0 0 -39 h\n.8 g 2797 1950 N 0 39 49 0 0
      -39 h\n.8 g 2749 1950 N 0 39 48 0 0 -39 h\n.9 g 2700 1950 N 0 39 49 0 0
      -39 h\n1 g 2652 1950 N 0 39 48 0 0 -39 h\n1 g 2603 1950 N 0 39 49 0 0
      -39 h\n1 g 2554 1950 N 0 39 49 0 0 -39 h\n1 g 2506 1950 N 0 39 48 0 0
      -39 h\n1 g 2457 1950 N 0 39 49 0 0 -39 h\n1 g 2409 1950 N 0 39 48 0 0
      -39 h\n1 g 2360 1950 N 0 39 49 0 0 -39 h\n1 g 2311 1950 N 0 39 49 0 0
      -39 h\n1 g 2263 1950 N 0 39 48 0 0 -39 h\n1 g 2214 1950 N 0 39 49 0 0
      -39 h\n1 g 2165 1950 N 0 39 49 0 0 -39 h\n1 g 2117 1950 N 0 39 48 0 0
      -39 h\n1 g 2068 1950 N 0 39 49 0 0 -39 h\n1 g 2020 1950 N 0 39 48 0 0
      -39 h\n1 g 1971 1950 N 0 39 49 0 0 -39 h\n1 g 1922 1950 N 0 39 49 0 0
      -39 h\n1 g 1874 1950 N 0 39 48 0 0 -39 h\n1 g 1825 1950 N 0 39 49 0 0
      -39 h\n1 g 1777 1950 N 0 39 48 0 0 -39 h\n1 g 1728 1950 N 0 39 49 0 0
      -39 h\n1 g 1679 1950 N 0 39 49 0 0 -39 h\n1 g 1631 1950 N 0 39 48 0 0
      -39 h\n1 g 1582 1950 N 0 39 49 0 0 -39 h\n1 g 1534 1950 N 0 39 48 0 0
      -39 h\n1 g 1485 1950 N 0 39 49 0 0 -39 h\n1 g 1436 1950 N 0 39 49 0 0
      -39 h\n1 g 1388 1950 N 0 39 48 0 0 -39 h\n1 g 1339 1950 N 0 39 49 0 0
      -39 h\n1 g 1290 1950 N 0 39 49 0 0 -39 h\n1 g 1242 1950 N 0 39 48 0 0
      -39 h\n1 g 1193 1950 N 0 39 49 0 0 -39 h\n1 g 5957 1911 N 0 39 49 0 0
      -39 h\n1 g 5909 1911 N 0 39 48 0 0 -39 h\n1 g 5860 1911 N 0 39 49 0 0
      -39 h\n1 g 5811 1911 N 0 39 49 0 0 -39 h\n1 g 5763 1911 N 0 39 48 0 0
      -39 h\n1 g 5714 1911 N 0 39 49 0 0 -39 h\n1 g 5665 1911 N 0 39 49 0 0
      -39 h\n1 g 5617 1911 N 0 39 48 0 0 -39 h\n1 g 5568 1911 N 0 39 49 0 0
      -39 h\n1 g 5520 1911 N 0 39 48 0 0 -39 h\n1 g 5471 1911 N 0 39 49 0 0
      -39 h\n1 g 5422 1911 N 0 39 49 0 0 -39 h\n1 g 5374 1911 N 0 39 48 0 0
      -39 h\n1 g 5325 1911 N 0 39 49 0 0 -39 h\n1 g 5277 1911 N 0 39 48 0 0
      -39 h\n1 g 5228 1911 N 0 39 49 0 0 -39 h\n1 g 5179 1911 N 0 39 49 0 0
      -39 h\n1 g 5131 1911 N 0 39 48 0 0 -39 h\n1 g 5082 1911 N 0 39 49 0 0
      -39 h\n1 g 5034 1911 N 0 39 48 0 0 -39 h\n1 g 4985 1911 N 0 39 49 0 0
      -39 h\n1 g 4936 1911 N 0 39 49 0 0 -39 h\n1 g 4888 1911 N 0 39 48 0 0
      -39 h\n1 g 4839 1911 N 0 39 49 0 0 -39 h\n1 g 4790 1911 N 0 39 49 0 0
      -39 h\n1 g 4742 1911 N 0 39 48 0 0 -39 h\n1 g 4693 1911 N 0 39 49 0 0
      -39 h\n1 g 4645 1911 N 0 39 48 0 0 -39 h\n1 g 4596 1911 N 0 39 49 0 0
      -39 h\n1 g 4547 1911 N 0 39 49 0 0 -39 h\n1 g 4499 1911 N 0 39 48 0 0
      -39 h\n.9 g 4450 1911 N 0 39 49 0 0 -39 h\n.8 g 4402 1911 N 0 39 48 0 0
      -39 h\n.8 g 4353 1911 N 0 39 49 0 0 -39 h\n.8 g 4304 1911 N 0 39 49 0 0
      -39 h\n.8 g 4256 1911 N 0 39 48 0 0 -39 h\n.8 g 4207 1911 N 0 39 49 0 0
      -39 h\n.8 g 4159 1911 N 0 39 48 0 0 -39 h\n.8 g 4110 1911 N 0 39 49 0 0
      -39 h\n.8 g 4061 1911 N 0 39 49 0 0 -39 h\n.8 g 4013 1911 N 0 39 48 0 0
      -39 h\n.8 g 3964 1911 N 0 39 49 0 0 -39 h\n.8 g 3915 1911 N 0 39 49 0 0
      -39 h\n.8 g 3867 1911 N 0 39 48 0 0 -39 h\n.8 g 3818 1911 N 0 39 49 0 0
      -39 h\n.8 g 3770 1911 N 0 39 48 0 0 -39 h\n.8 g 3721 1911 N 0 39 49 0 0
      -39 h\n.8 g 3672 1911 N 0 39 49 0 0 -39 h\n.8 g 3624 1911 N 0 39 48 0 0
      -39 h\n.8 g 3575 1911 N 0 39 49 0 0 -39 h\n.8 g 3527 1911 N 0 39 48 0 0
      -39 h\n.8 g 3478 1911 N 0 39 49 0 0 -39 h\n.8 g 3429 1911 N 0 39 49 0 0
      -39 h\n.8 g 3381 1911 N 0 39 48 0 0 -39 h\n.8 g 3332 1911 N 0 39 49 0 0
      -39 h\n.8 g 3284 1911 N 0 39 48 0 0 -39 h\n.8 g 3235 1911 N 0 39 49 0 0
      -39 h\n.8 g 3186 1911 N 0 39 49 0 0 -39 h\n.8 g 3138 1911 N 0 39 48 0 0
      -39 h\n.8 g 3089 1911 N 0 39 49 0 0 -39 h\n.8 g 3040 1911 N 0 39 49 0 0
      -39 h\n.8 g 2992 1911 N 0 39 48 0 0 -39 h\n.8 g 2943 1911 N 0 39 49 0 0
      -39 h\n.8 g 2895 1911 N 0 39 48 0 0 -39 h\n.8 g 2846 1911 N 0 39 49 0 0
      -39 h\n.8 g 2797 1911 N 0 39 49 0 0 -39 h\n.8 g 2749 1911 N 0 39 48 0 0
      -39 h\n.9 g 2700 1911 N 0 39 49 0 0 -39 h\n1 g 2652 1911 N 0 39 48 0 0
      -39 h\n1 g 2603 1911 N 0 39 49 0 0 -39 h\n1 g 2554 1911 N 0 39 49 0 0
      -39 h\n1 g 2506 1911 N 0 39 48 0 0 -39 h\n1 g 2457 1911 N 0 39 49 0 0
      -39 h\n1 g 2409 1911 N 0 39 48 0 0 -39 h\n1 g 2360 1911 N 0 39 49 0 0
      -39 h\n1 g 2311 1911 N 0 39 49 0 0 -39 h\n1 g 2263 1911 N 0 39 48 0 0
      -39 h\n1 g 2214 1911 N 0 39 49 0 0 -39 h\n1 g 2165 1911 N 0 39 49 0 0
      -39 h\n1 g 2117 1911 N 0 39 48 0 0 -39 h\n1 g 2068 1911 N 0 39 49 0 0
      -39 h\n1 g 2020 1911 N 0 39 48 0 0 -39 h\n1 g 1971 1911 N 0 39 49 0 0
      -39 h\n1 g 1922 1911 N 0 39 49 0 0 -39 h\n1 g 1874 1911 N 0 39 48 0 0
      -39 h\n1 g 1825 1911 N 0 39 49 0 0 -39 h\n1 g 1777 1911 N 0 39 48 0 0
      -39 h\n1 g 1728 1911 N 0 39 49 0 0 -39 h\n1 g 1679 1911 N 0 39 49 0 0
      -39 h\n1 g 1631 1911 N 0 39 48 0 0 -39 h\n1 g 1582 1911 N 0 39 49 0 0
      -39 h\n1 g 1534 1911 N 0 39 48 0 0 -39 h\n1 g 1485 1911 N 0 39 49 0 0
      -39 h\n1 g 1436 1911 N 0 39 49 0 0 -39 h\n1 g 1388 1911 N 0 39 48 0 0
      -39 h\n1 g 1339 1911 N 0 39 49 0 0 -39 h\n1 g 1290 1911 N 0 39 49 0 0
      -39 h\n1 g 1242 1911 N 0 39 48 0 0 -39 h\n1 g 1193 1911 N 0 39 49 0 0
      -39 h\n1 g 5957 1872 N 0 38 49 0 0 -38 h\n1 g 5909 1872 N 0 38 48 0 0
      -38 h\n1 g 5860 1872 N 0 38 49 0 0 -38 h\n1 g 5811 1872 N 0 38 49 0 0
      -38 h\n1 g 5763 1872 N 0 38 48 0 0 -38 h\n1 g 5714 1872 N 0 38 49 0 0
      -38 h\n1 g 5665 1872 N 0 38 49 0 0 -38 h\n1 g 5617 1872 N 0 38 48 0 0
      -38 h\n1 g 5568 1872 N 0 38 49 0 0 -38 h\n1 g 5520 1872 N 0 38 48 0 0
      -38 h\n1 g 5471 1872 N 0 38 49 0 0 -38 h\n1 g 5422 1872 N 0 38 49 0 0
      -38 h\n1 g 5374 1872 N 0 38 48 0 0 -38 h\n1 g 5325 1872 N 0 38 49 0 0
      -38 h\n1 g 5277 1872 N 0 38 48 0 0 -38 h\n1 g 5228 1872 N 0 38 49 0 0
      -38 h\n1 g 5179 1872 N 0 38 49 0 0 -38 h\n1 g 5131 1872 N 0 38 48 0 0
      -38 h\n1 g 5082 1872 N 0 38 49 0 0 -38 h\n1 g 5034 1872 N 0 38 48 0 0
      -38 h\n1 g 4985 1872 N 0 38 49 0 0 -38 h\n1 g 4936 1872 N 0 38 49 0 0
      -38 h\n1 g 4888 1872 N 0 38 48 0 0 -38 h\n1 g 4839 1872 N 0 38 49 0 0
      -38 h\n1 g 4790 1872 N 0 38 49 0 0 -38 h\n1 g 4742 1872 N 0 38 48 0 0
      -38 h\n1 g 4693 1872 N 0 38 49 0 0 -38 h\n1 g 4645 1872 N 0 38 48 0 0
      -38 h\n1 g 4596 1872 N 0 38 49 0 0 -38 h\n1 g 4547 1872 N 0 38 49 0 0
      -38 h\n1 g 4499 1872 N 0 38 48 0 0 -38 h\n.95 g 4450 1872 N 0 38 49 0 0
      -38 h\n.85 g 4402 1872 N 0 38 48 0 0 -38 h\n.8 g 4353 1872 N 0 38 49 0
      0 -38 h\n.8 g 4304 1872 N 0 38 49 0 0 -38 h\n.8 g 4256 1872 N 0 38 48 0
      0 -38 h\n.8 g 4207 1872 N 0 38 49 0 0 -38 h\n.8 g 4159 1872 N 0 38 48 0
      0 -38 h\n.8 g 4110 1872 N 0 38 49 0 0 -38 h\n.8 g 4061 1872 N 0 38 49 0
      0 -38 h\n.8 g 4013 1872 N 0 38 48 0 0 -38 h\n.8 g 3964 1872 N 0 38 49 0
      0 -38 h\n.8 g 3915 1872 N 0 38 49 0 0 -38 h\n.8 g 3867 1872 N 0 38 48 0
      0 -38 h\n.8 g 3818 1872 N 0 38 49 0 0 -38 h\n.8 g 3770 1872 N 0 38 48 0
      0 -38 h\n.8 g 3721 1872 N 0 38 49 0 0 -38 h\n.8 g 3672 1872 N 0 38 49 0
      0 -38 h\n.8 g 3624 1872 N 0 38 48 0 0 -38 h\n.8 g 3575 1872 N 0 38 49 0
      0 -38 h\n.8 g 3527 1872 N 0 38 48 0 0 -38 h\n.8 g 3478 1872 N 0 38 49 0
      0 -38 h\n.8 g 3429 1872 N 0 38 49 0 0 -38 h\n.8 g 3381 1872 N 0 38 48 0
      0 -38 h\n.8 g 3332 1872 N 0 38 49 0 0 -38 h\n.8 g 3284 1872 N 0 38 48 0
      0 -38 h\n.8 g 3235 1872 N 0 38 49 0 0 -38 h\n.8 g 3186 1872 N 0 38 49 0
      0 -38 h\n.8 g 3138 1872 N 0 38 48 0 0 -38 h\n.8 g 3089 1872 N 0 38 49 0
      0 -38 h\n.8 g 3040 1872 N 0 38 49 0 0 -38 h\n.8 g 2992 1872 N 0 38 48 0
      0 -38 h\n.8 g 2943 1872 N 0 38 49 0 0 -38 h\n.8 g 2895 1872 N 0 38 48 0
      0 -38 h\n.8 g 2846 1872 N 0 38 49 0 0 -38 h\n.8 g 2797 1872 N 0 38 49 0
      0 -38 h\n.85 g 2749 1872 N 0 38 48 0 0 -38 h\n.95 g 2700 1872 N 0 38 49
      0 0 -38 h\n1 g 2652 1872 N 0 38 48 0 0 -38 h\n1 g 2603 1872 N 0 38 49 0
      0 -38 h\n1 g 2554 1872 N 0 38 49 0 0 -38 h\n1 g 2506 1872 N 0 38 48 0 0
      -38 h\n1 g 2457 1872 N 0 38 49 0 0 -38 h\n1 g 2409 1872 N 0 38 48 0 0
      -38 h\n1 g 2360 1872 N 0 38 49 0 0 -38 h\n1 g 2311 1872 N 0 38 49 0 0
      -38 h\n1 g 2263 1872 N 0 38 48 0 0 -38 h\n1 g 2214 1872 N 0 38 49 0 0
      -38 h\n1 g 2165 1872 N 0 38 49 0 0 -38 h\n1 g 2117 1872 N 0 38 48 0 0
      -38 h\n1 g 2068 1872 N 0 38 49 0 0 -38 h\n1 g 2020 1872 N 0 38 48 0 0
      -38 h\n1 g 1971 1872 N 0 38 49 0 0 -38 h\n1 g 1922 1872 N 0 38 49 0 0
      -38 h\n1 g 1874 1872 N 0 38 48 0 0 -38 h\n1 g 1825 1872 N 0 38 49 0 0
      -38 h\n1 g 1777 1872 N 0 38 48 0 0 -38 h\n1 g 1728 1872 N 0 38 49 0 0
      -38 h\n1 g 1679 1872 N 0 38 49 0 0 -38 h\n1 g 1631 1872 N 0 38 48 0 0
      -38 h\n1 g 1582 1872 N 0 38 49 0 0 -38 h\n1 g 1534 1872 N 0 38 48 0 0
      -38 h\n1 g 1485 1872 N 0 38 49 0 0 -38 h\n1 g 1436 1872 N 0 38 49 0 0
      -38 h\n1 g 1388 1872 N 0 38 48 0 0 -38 h\n1 g 1339 1872 N 0 38 49 0 0
      -38 h\n1 g 1290 1872 N 0 38 49 0 0 -38 h\n1 g 1242 1872 N 0 38 48 0 0
      -38 h\n1 g 1193 1872 N 0 38 49 0 0 -38 h\n1 g 5957 1834 N 0 39 49 0 0
      -39 h\n1 g 5909 1834 N 0 39 48 0 0 -39 h\n1 g 5860 1834 N 0 39 49 0 0
      -39 h\n1 g 5811 1834 N 0 39 49 0 0 -39 h\n1 g 5763 1834 N 0 39 48 0 0
      -39 h\n1 g 5714 1834 N 0 39 49 0 0 -39 h\n1 g 5665 1834 N 0 39 49 0 0
      -39 h\n1 g 5617 1834 N 0 39 48 0 0 -39 h\n1 g 5568 1834 N 0 39 49 0 0
      -39 h\n1 g 5520 1834 N 0 39 48 0 0 -39 h\n1 g 5471 1834 N 0 39 49 0 0
      -39 h\n1 g 5422 1834 N 0 39 49 0 0 -39 h\n1 g 5374 1834 N 0 39 48 0 0
      -39 h\n1 g 5325 1834 N 0 39 49 0 0 -39 h\n1 g 5277 1834 N 0 39 48 0 0
      -39 h\n1 g 5228 1834 N 0 39 49 0 0 -39 h\n1 g 5179 1834 N 0 39 49 0 0
      -39 h\n1 g 5131 1834 N 0 39 48 0 0 -39 h\n1 g 5082 1834 N 0 39 49 0 0
      -39 h\n1 g 5034 1834 N 0 39 48 0 0 -39 h\n1 g 4985 1834 N 0 39 49 0 0
      -39 h\n1 g 4936 1834 N 0 39 49 0 0 -39 h\n1 g 4888 1834 N 0 39 48 0 0
      -39 h\n1 g 4839 1834 N 0 39 49 0 0 -39 h\n1 g 4790 1834 N 0 39 49 0 0
      -39 h\n1 g 4742 1834 N 0 39 48 0 0 -39 h\n1 g 4693 1834 N 0 39 49 0 0
      -39 h\n1 g 4645 1834 N 0 39 48 0 0 -39 h\n1 g 4596 1834 N 0 39 49 0 0
      -39 h\n1 g 4547 1834 N 0 39 49 0 0 -39 h\n1 g 4499 1834 N 0 39 48 0 0
      -39 h\n1 g 4450 1834 N 0 39 49 0 0 -39 h\n.9 g 4402 1834 N 0 39 48 0 0
      -39 h\n.8 g 4353 1834 N 0 39 49 0 0 -39 h\n.8 g 4304 1834 N 0 39 49 0 0
      -39 h\n.8 g 4256 1834 N 0 39 48 0 0 -39 h\n.8 g 4207 1834 N 0 39 49 0 0
      -39 h\n.8 g 4159 1834 N 0 39 48 0 0 -39 h\n.8 g 4110 1834 N 0 39 49 0 0
      -39 h\n.8 g 4061 1834 N 0 39 49 0 0 -39 h\n.8 g 4013 1834 N 0 39 48 0 0
      -39 h\n.8 g 3964 1834 N 0 39 49 0 0 -39 h\n.8 g 3915 1834 N 0 39 49 0 0
      -39 h\n.8 g 3867 1834 N 0 39 48 0 0 -39 h\n.8 g 3818 1834 N 0 39 49 0 0
      -39 h\n.8 g 3770 1834 N 0 39 48 0 0 -39 h\n.8 g 3721 1834 N 0 39 49 0 0
      -39 h\n.8 g 3672 1834 N 0 39 49 0 0 -39 h\n.8 g 3624 1834 N 0 39 48 0 0
      -39 h\n.8 g 3575 1834 N 0 39 49 0 0 -39 h\n.8 g 3527 1834 N 0 39 48 0 0
      -39 h\n.8 g 3478 1834 N 0 39 49 0 0 -39 h\n.8 g 3429 1834 N 0 39 49 0 0
      -39 h\n.8 g 3381 1834 N 0 39 48 0 0 -39 h\n.8 g 3332 1834 N 0 39 49 0 0
      -39 h\n.8 g 3284 1834 N 0 39 48 0 0 -39 h\n.8 g 3235 1834 N 0 39 49 0 0
      -39 h\n.8 g 3186 1834 N 0 39 49 0 0 -39 h\n.8 g 3138 1834 N 0 39 48 0 0
      -39 h\n.8 g 3089 1834 N 0 39 49 0 0 -39 h\n.8 g 3040 1834 N 0 39 49 0 0
      -39 h\n.8 g 2992 1834 N 0 39 48 0 0 -39 h\n.8 g 2943 1834 N 0 39 49 0 0
      -39 h\n.8 g 2895 1834 N 0 39 48 0 0 -39 h\n.8 g 2846 1834 N 0 39 49 0 0
      -39 h\n.8 g 2797 1834 N 0 39 49 0 0 -39 h\n.9 g 2749 1834 N 0 39 48 0 0
      -39 h\n1 g 2700 1834 N 0 39 49 0 0 -39 h\n1 g 2652 1834 N 0 39 48 0 0
      -39 h\n1 g 2603 1834 N 0 39 49 0 0 -39 h\n1 g 2554 1834 N 0 39 49 0 0
      -39 h\n1 g 2506 1834 N 0 39 48 0 0 -39 h\n1 g 2457 1834 N 0 39 49 0 0
      -39 h\n1 g 2409 1834 N 0 39 48 0 0 -39 h\n1 g 2360 1834 N 0 39 49 0 0
      -39 h\n1 g 2311 1834 N 0 39 49 0 0 -39 h\n1 g 2263 1834 N 0 39 48 0 0
      -39 h\n1 g 2214 1834 N 0 39 49 0 0 -39 h\n1 g 2165 1834 N 0 39 49 0 0
      -39 h\n1 g 2117 1834 N 0 39 48 0 0 -39 h\n1 g 2068 1834 N 0 39 49 0 0
      -39 h\n1 g 2020 1834 N 0 39 48 0 0 -39 h\n1 g 1971 1834 N 0 39 49 0 0
      -39 h\n1 g 1922 1834 N 0 39 49 0 0 -39 h\n1 g 1874 1834 N 0 39 48 0 0
      -39 h\n1 g 1825 1834 N 0 39 49 0 0 -39 h\n1 g 1777 1834 N 0 39 48 0 0
      -39 h\n1 g 1728 1834 N 0 39 49 0 0 -39 h\n1 g 1679 1834 N 0 39 49 0 0
      -39 h\n1 g 1631 1834 N 0 39 48 0 0 -39 h\n1 g 1582 1834 N 0 39 49 0 0
      -39 h\n1 g 1534 1834 N 0 39 48 0 0 -39 h\n1 g 1485 1834 N 0 39 49 0 0
      -39 h\n1 g 1436 1834 N 0 39 49 0 0 -39 h\n1 g 1388 1834 N 0 39 48 0 0
      -39 h\n1 g 1339 1834 N 0 39 49 0 0 -39 h\n1 g 1290 1834 N 0 39 49 0 0
      -39 h\n1 g 1242 1834 N 0 39 48 0 0 -39 h\n1 g 1193 1834 N 0 39 49 0 0
      -39 h\n1 g 5957 1795 N 0 39 49 0 0 -39 h\n1 g 5909 1795 N 0 39 48 0 0
      -39 h\n1 g 5860 1795 N 0 39 49 0 0 -39 h\n1 g 5811 1795 N 0 39 49 0 0
      -39 h\n1 g 5763 1795 N 0 39 48 0 0 -39 h\n1 g 5714 1795 N 0 39 49 0 0
      -39 h\n1 g 5665 1795 N 0 39 49 0 0 -39 h\n1 g 5617 1795 N 0 39 48 0 0
      -39 h\n1 g 5568 1795 N 0 39 49 0 0 -39 h\n1 g 5520 1795 N 0 39 48 0 0
      -39 h\n1 g 5471 1795 N 0 39 49 0 0 -39 h\n1 g 5422 1795 N 0 39 49 0 0
      -39 h\n1 g 5374 1795 N 0 39 48 0 0 -39 h\n1 g 5325 1795 N 0 39 49 0 0
      -39 h\n1 g 5277 1795 N 0 39 48 0 0 -39 h\n1 g 5228 1795 N 0 39 49 0 0
      -39 h\n1 g 5179 1795 N 0 39 49 0 0 -39 h\n1 g 5131 1795 N 0 39 48 0 0
      -39 h\n1 g 5082 1795 N 0 39 49 0 0 -39 h\n1 g 5034 1795 N 0 39 48 0 0
      -39 h\n1 g 4985 1795 N 0 39 49 0 0 -39 h\n1 g 4936 1795 N 0 39 49 0 0
      -39 h\n1 g 4888 1795 N 0 39 48 0 0 -39 h\n1 g 4839 1795 N 0 39 49 0 0
      -39 h\n1 g 4790 1795 N 0 39 49 0 0 -39 h\n1 g 4742 1795 N 0 39 48 0 0
      -39 h\n1 g 4693 1795 N 0 39 49 0 0 -39 h\n1 g 4645 1795 N 0 39 48 0 0
      -39 h\n1 g 4596 1795 N 0 39 49 0 0 -39 h\n1 g 4547 1795 N 0 39 49 0 0
      -39 h\n1 g 4499 1795 N 0 39 48 0 0 -39 h\n1 g 4450 1795 N 0 39 49 0 0
      -39 h\n.9 g 4402 1795 N 0 39 48 0 0 -39 h\n.8 g 4353 1795 N 0 39 49 0 0
      -39 h\n.8 g 4304 1795 N 0 39 49 0 0 -39 h\n.8 g 4256 1795 N 0 39 48 0 0
      -39 h\n.8 g 4207 1795 N 0 39 49 0 0 -39 h\n.8 g 4159 1795 N 0 39 48 0 0
      -39 h\n.8 g 4110 1795 N 0 39 49 0 0 -39 h\n.8 g 4061 1795 N 0 39 49 0 0
      -39 h\n.8 g 4013 1795 N 0 39 48 0 0 -39 h\n.8 g 3964 1795 N 0 39 49 0 0
      -39 h\n.8 g 3915 1795 N 0 39 49 0 0 -39 h\n.8 g 3867 1795 N 0 39 48 0 0
      -39 h\n.8 g 3818 1795 N 0 39 49 0 0 -39 h\n.8 g 3770 1795 N 0 39 48 0 0
      -39 h\n.8 g 3721 1795 N 0 39 49 0 0 -39 h\n.8 g 3672 1795 N 0 39 49 0 0
      -39 h\n.8 g 3624 1795 N 0 39 48 0 0 -39 h\n.8 g 3575 1795 N 0 39 49 0 0
      -39 h\n.8 g 3527 1795 N 0 39 48 0 0 -39 h\n.8 g 3478 1795 N 0 39 49 0 0
      -39 h\n.8 g 3429 1795 N 0 39 49 0 0 -39 h\n.8 g 3381 1795 N 0 39 48 0 0
      -39 h\n.8 g 3332 1795 N 0 39 49 0 0 -39 h\n.8 g 3284 1795 N 0 39 48 0 0
      -39 h\n.8 g 3235 1795 N 0 39 49 0 0 -39 h\n.8 g 3186 1795 N 0 39 49 0 0
      -39 h\n.8 g 3138 1795 N 0 39 48 0 0 -39 h\n.8 g 3089 1795 N 0 39 49 0 0
      -39 h\n.8 g 3040 1795 N 0 39 49 0 0 -39 h\n.8 g 2992 1795 N 0 39 48 0 0
      -39 h\n.8 g 2943 1795 N 0 39 49 0 0 -39 h\n.8 g 2895 1795 N 0 39 48 0 0
      -39 h\n.8 g 2846 1795 N 0 39 49 0 0 -39 h\n.8 g 2797 1795 N 0 39 49 0 0
      -39 h\n.9 g 2749 1795 N 0 39 48 0 0 -39 h\n1 g 2700 1795 N 0 39 49 0 0
      -39 h\n1 g 2652 1795 N 0 39 48 0 0 -39 h\n1 g 2603 1795 N 0 39 49 0 0
      -39 h\n1 g 2554 1795 N 0 39 49 0 0 -39 h\n1 g 2506 1795 N 0 39 48 0 0
      -39 h\n1 g 2457 1795 N 0 39 49 0 0 -39 h\n1 g 2409 1795 N 0 39 48 0 0
      -39 h\n1 g 2360 1795 N 0 39 49 0 0 -39 h\n1 g 2311 1795 N 0 39 49 0 0
      -39 h\n1 g 2263 1795 N 0 39 48 0 0 -39 h\n1 g 2214 1795 N 0 39 49 0 0
      -39 h\n1 g 2165 1795 N 0 39 49 0 0 -39 h\n1 g 2117 1795 N 0 39 48 0 0
      -39 h\n1 g 2068 1795 N 0 39 49 0 0 -39 h\n1 g 2020 1795 N 0 39 48 0 0
      -39 h\n1 g 1971 1795 N 0 39 49 0 0 -39 h\n1 g 1922 1795 N 0 39 49 0 0
      -39 h\n1 g 1874 1795 N 0 39 48 0 0 -39 h\n1 g 1825 1795 N 0 39 49 0 0
      -39 h\n1 g 1777 1795 N 0 39 48 0 0 -39 h\n1 g 1728 1795 N 0 39 49 0 0
      -39 h\n1 g 1679 1795 N 0 39 49 0 0 -39 h\n1 g 1631 1795 N 0 39 48 0 0
      -39 h\n1 g 1582 1795 N 0 39 49 0 0 -39 h\n1 g 1534 1795 N 0 39 48 0 0
      -39 h\n1 g 1485 1795 N 0 39 49 0 0 -39 h\n1 g 1436 1795 N 0 39 49 0 0
      -39 h\n1 g 1388 1795 N 0 39 48 0 0 -39 h\n1 g 1339 1795 N 0 39 49 0 0
      -39 h\n1 g 1290 1795 N 0 39 49 0 0 -39 h\n1 g 1242 1795 N 0 39 48 0 0
      -39 h\n1 g 1193 1795 N 0 39 49 0 0 -39 h\n1 g 5957 1756 N 0 39 49 0 0
      -39 h\n1 g 5909 1756 N 0 39 48 0 0 -39 h\n1 g 5860 1756 N 0 39 49 0 0
      -39 h\n1 g 5811 1756 N 0 39 49 0 0 -39 h\n1 g 5763 1756 N 0 39 48 0 0
      -39 h\n1 g 5714 1756 N 0 39 49 0 0 -39 h\n1 g 5665 1756 N 0 39 49 0 0
      -39 h\n1 g 5617 1756 N 0 39 48 0 0 -39 h\n1 g 5568 1756 N 0 39 49 0 0
      -39 h\n1 g 5520 1756 N 0 39 48 0 0 -39 h\n1 g 5471 1756 N 0 39 49 0 0
      -39 h\n1 g 5422 1756 N 0 39 49 0 0 -39 h\n1 g 5374 1756 N 0 39 48 0 0
      -39 h\n1 g 5325 1756 N 0 39 49 0 0 -39 h\n1 g 5277 1756 N 0 39 48 0 0
      -39 h\n1 g 5228 1756 N 0 39 49 0 0 -39 h\n1 g 5179 1756 N 0 39 49 0 0
      -39 h\n1 g 5131 1756 N 0 39 48 0 0 -39 h\n1 g 5082 1756 N 0 39 49 0 0
      -39 h\n1 g 5034 1756 N 0 39 48 0 0 -39 h\n1 g 4985 1756 N 0 39 49 0 0
      -39 h\n1 g 4936 1756 N 0 39 49 0 0 -39 h\n1 g 4888 1756 N 0 39 48 0 0
      -39 h\n1 g 4839 1756 N 0 39 49 0 0 -39 h\n1 g 4790 1756 N 0 39 49 0 0
      -39 h\n1 g 4742 1756 N 0 39 48 0 0 -39 h\n1 g 4693 1756 N 0 39 49 0 0
      -39 h\n1 g 4645 1756 N 0 39 48 0 0 -39 h\n1 g 4596 1756 N 0 39 49 0 0
      -39 h\n1 g 4547 1756 N 0 39 49 0 0 -39 h\n1 g 4499 1756 N 0 39 48 0 0
      -39 h\n1 g 4450 1756 N 0 39 49 0 0 -39 h\n.95 g 4402 1756 N 0 39 48 0 0
      -39 h\n.85 g 4353 1756 N 0 39 49 0 0 -39 h\n.8 g 4304 1756 N 0 39 49 0
      0 -39 h\n.8 g 4256 1756 N 0 39 48 0 0 -39 h\n.8 g 4207 1756 N 0 39 49 0
      0 -39 h\n.8 g 4159 1756 N 0 39 48 0 0 -39 h\n.8 g 4110 1756 N 0 39 49 0
      0 -39 h\n.8 g 4061 1756 N 0 39 49 0 0 -39 h\n.8 g 4013 1756 N 0 39 48 0
      0 -39 h\n.8 g 3964 1756 N 0 39 49 0 0 -39 h\n.8 g 3915 1756 N 0 39 49 0
      0 -39 h\n.8 g 3867 1756 N 0 39 48 0 0 -39 h\n.8 g 3818 1756 N 0 39 49 0
      0 -39 h\n.8 g 3770 1756 N 0 39 48 0 0 -39 h\n.8 g 3721 1756 N 0 39 49 0
      0 -39 h\n.8 g 3672 1756 N 0 39 49 0 0 -39 h\n.8 g 3624 1756 N 0 39 48 0
      0 -39 h\n.8 g 3575 1756 N 0 39 49 0 0 -39 h\n.8 g 3527 1756 N 0 39 48 0
      0 -39 h\n.8 g 3478 1756 N 0 39 49 0 0 -39 h\n.8 g 3429 1756 N 0 39 49 0
      0 -39 h\n.8 g 3381 1756 N 0 39 48 0 0 -39 h\n.8 g 3332 1756 N 0 39 49 0
      0 -39 h\n.8 g 3284 1756 N 0 39 48 0 0 -39 h\n.8 g 3235 1756 N 0 39 49 0
      0 -39 h\n.8 g 3186 1756 N 0 39 49 0 0 -39 h\n.8 g 3138 1756 N 0 39 48 0
      0 -39 h\n.8 g 3089 1756 N 0 39 49 0 0 -39 h\n.8 g 3040 1756 N 0 39 49 0
      0 -39 h\n.8 g 2992 1756 N 0 39 48 0 0 -39 h\n.8 g 2943 1756 N 0 39 49 0
      0 -39 h\n.8 g 2895 1756 N 0 39 48 0 0 -39 h\n.8 g 2846 1756 N 0 39 49 0
      0 -39 h\n.85 g 2797 1756 N 0 39 49 0 0 -39 h\n.95 g 2749 1756 N 0 39 48
      0 0 -39 h\n1 g 2700 1756 N 0 39 49 0 0 -39 h\n1 g 2652 1756 N 0 39 48 0
      0 -39 h\n1 g 2603 1756 N 0 39 49 0 0 -39 h\n1 g 2554 1756 N 0 39 49 0 0
      -39 h\n1 g 2506 1756 N 0 39 48 0 0 -39 h\n1 g 2457 1756 N 0 39 49 0 0
      -39 h\n1 g 2409 1756 N 0 39 48 0 0 -39 h\n1 g 2360 1756 N 0 39 49 0 0
      -39 h\n1 g 2311 1756 N 0 39 49 0 0 -39 h\n1 g 2263 1756 N 0 39 48 0 0
      -39 h\n1 g 2214 1756 N 0 39 49 0 0 -39 h\n1 g 2165 1756 N 0 39 49 0 0
      -39 h\n1 g 2117 1756 N 0 39 48 0 0 -39 h\n1 g 2068 1756 N 0 39 49 0 0
      -39 h\n1 g 2020 1756 N 0 39 48 0 0 -39 h\n1 g 1971 1756 N 0 39 49 0 0
      -39 h\n1 g 1922 1756 N 0 39 49 0 0 -39 h\n1 g 1874 1756 N 0 39 48 0 0
      -39 h\n1 g 1825 1756 N 0 39 49 0 0 -39 h\n1 g 1777 1756 N 0 39 48 0 0
      -39 h\n1 g 1728 1756 N 0 39 49 0 0 -39 h\n1 g 1679 1756 N 0 39 49 0 0
      -39 h\n1 g 1631 1756 N 0 39 48 0 0 -39 h\n1 g 1582 1756 N 0 39 49 0 0
      -39 h\n1 g 1534 1756 N 0 39 48 0 0 -39 h\n1 g 1485 1756 N 0 39 49 0 0
      -39 h\n1 g 1436 1756 N 0 39 49 0 0 -39 h\n1 g 1388 1756 N 0 39 48 0 0
      -39 h\n1 g 1339 1756 N 0 39 49 0 0 -39 h\n1 g 1290 1756 N 0 39 49 0 0
      -39 h\n1 g 1242 1756 N 0 39 48 0 0 -39 h\n1 g 1193 1756 N 0 39 49 0 0
      -39 h\n1 g 5957 1717 N 0 38 49 0 0 -38 h\n1 g 5909 1717 N 0 38 48 0 0
      -38 h\n1 g 5860 1717 N 0 38 49 0 0 -38 h\n1 g 5811 1717 N 0 38 49 0 0
      -38 h\n1 g 5763 1717 N 0 38 48 0 0 -38 h\n1 g 5714 1717 N 0 38 49 0 0
      -38 h\n1 g 5665 1717 N 0 38 49 0 0 -38 h\n1 g 5617 1717 N 0 38 48 0 0
      -38 h\n1 g 5568 1717 N 0 38 49 0 0 -38 h\n1 g 5520 1717 N 0 38 48 0 0
      -38 h\n1 g 5471 1717 N 0 38 49 0 0 -38 h\n1 g 5422 1717 N 0 38 49 0 0
      -38 h\n1 g 5374 1717 N 0 38 48 0 0 -38 h\n1 g 5325 1717 N 0 38 49 0 0
      -38 h\n1 g 5277 1717 N 0 38 48 0 0 -38 h\n1 g 5228 1717 N 0 38 49 0 0
      -38 h\n1 g 5179 1717 N 0 38 49 0 0 -38 h\n1 g 5131 1717 N 0 38 48 0 0
      -38 h\n1 g 5082 1717 N 0 38 49 0 0 -38 h\n1 g 5034 1717 N 0 38 48 0 0
      -38 h\n1 g 4985 1717 N 0 38 49 0 0 -38 h\n1 g 4936 1717 N 0 38 49 0 0
      -38 h\n1 g 4888 1717 N 0 38 48 0 0 -38 h\n1 g 4839 1717 N 0 38 49 0 0
      -38 h\n1 g 4790 1717 N 0 38 49 0 0 -38 h\n1 g 4742 1717 N 0 38 48 0 0
      -38 h\n1 g 4693 1717 N 0 38 49 0 0 -38 h\n1 g 4645 1717 N 0 38 48 0 0
      -38 h\n1 g 4596 1717 N 0 38 49 0 0 -38 h\n1 g 4547 1717 N 0 38 49 0 0
      -38 h\n1 g 4499 1717 N 0 38 48 0 0 -38 h\n1 g 4450 1717 N 0 38 49 0 0
      -38 h\n1 g 4402 1717 N 0 38 48 0 0 -38 h\n.9 g 4353 1717 N 0 38 49 0 0
      -38 h\n.8 g 4304 1717 N 0 38 49 0 0 -38 h\n.8 g 4256 1717 N 0 38 48 0 0
      -38 h\n.8 g 4207 1717 N 0 38 49 0 0 -38 h\n.8 g 4159 1717 N 0 38 48 0 0
      -38 h\n.8 g 4110 1717 N 0 38 49 0 0 -38 h\n.8 g 4061 1717 N 0 38 49 0 0
      -38 h\n.8 g 4013 1717 N 0 38 48 0 0 -38 h\n.8 g 3964 1717 N 0 38 49 0 0
      -38 h\n.8 g 3915 1717 N 0 38 49 0 0 -38 h\n.8 g 3867 1717 N 0 38 48 0 0
      -38 h\n.8 g 3818 1717 N 0 38 49 0 0 -38 h\n.8 g 3770 1717 N 0 38 48 0 0
      -38 h\n.8 g 3721 1717 N 0 38 49 0 0 -38 h\n.8 g 3672 1717 N 0 38 49 0 0
      -38 h\n.8 g 3624 1717 N 0 38 48 0 0 -38 h\n.8 g 3575 1717 N 0 38 49 0 0
      -38 h\n.8 g 3527 1717 N 0 38 48 0 0 -38 h\n.8 g 3478 1717 N 0 38 49 0 0
      -38 h\n.8 g 3429 1717 N 0 38 49 0 0 -38 h\n.8 g 3381 1717 N 0 38 48 0 0
      -38 h\n.8 g 3332 1717 N 0 38 49 0 0 -38 h\n.8 g 3284 1717 N 0 38 48 0 0
      -38 h\n.8 g 3235 1717 N 0 38 49 0 0 -38 h\n.8 g 3186 1717 N 0 38 49 0 0
      -38 h\n.8 g 3138 1717 N 0 38 48 0 0 -38 h\n.8 g 3089 1717 N 0 38 49 0 0
      -38 h\n.8 g 3040 1717 N 0 38 49 0 0 -38 h\n.8 g 2992 1717 N 0 38 48 0 0
      -38 h\n.8 g 2943 1717 N 0 38 49 0 0 -38 h\n.8 g 2895 1717 N 0 38 48 0 0
      -38 h\n.8 g 2846 1717 N 0 38 49 0 0 -38 h\n.9 g 2797 1717 N 0 38 49 0 0
      -38 h\n1 g 2749 1717 N 0 38 48 0 0 -38 h\n1 g 2700 1717 N 0 38 49 0 0
      -38 h\n1 g 2652 1717 N 0 38 48 0 0 -38 h\n1 g 2603 1717 N 0 38 49 0 0
      -38 h\n1 g 2554 1717 N 0 38 49 0 0 -38 h\n1 g 2506 1717 N 0 38 48 0 0
      -38 h\n1 g 2457 1717 N 0 38 49 0 0 -38 h\n1 g 2409 1717 N 0 38 48 0 0
      -38 h\n1 g 2360 1717 N 0 38 49 0 0 -38 h\n1 g 2311 1717 N 0 38 49 0 0
      -38 h\n1 g 2263 1717 N 0 38 48 0 0 -38 h\n1 g 2214 1717 N 0 38 49 0 0
      -38 h\n1 g 2165 1717 N 0 38 49 0 0 -38 h\n1 g 2117 1717 N 0 38 48 0 0
      -38 h\n1 g 2068 1717 N 0 38 49 0 0 -38 h\n1 g 2020 1717 N 0 38 48 0 0
      -38 h\n1 g 1971 1717 N 0 38 49 0 0 -38 h\n1 g 1922 1717 N 0 38 49 0 0
      -38 h\n1 g 1874 1717 N 0 38 48 0 0 -38 h\n1 g 1825 1717 N 0 38 49 0 0
      -38 h\n1 g 1777 1717 N 0 38 48 0 0 -38 h\n1 g 1728 1717 N 0 38 49 0 0
      -38 h\n1 g 1679 1717 N 0 38 49 0 0 -38 h\n1 g 1631 1717 N 0 38 48 0 0
      -38 h\n1 g 1582 1717 N 0 38 49 0 0 -38 h\n1 g 1534 1717 N 0 38 48 0 0
      -38 h\n1 g 1485 1717 N 0 38 49 0 0 -38 h\n1 g 1436 1717 N 0 38 49 0 0
      -38 h\n1 g 1388 1717 N 0 38 48 0 0 -38 h\n1 g 1339 1717 N 0 38 49 0 0
      -38 h\n1 g 1290 1717 N 0 38 49 0 0 -38 h\n1 g 1242 1717 N 0 38 48 0 0
      -38 h\n1 g 1193 1717 N 0 38 49 0 0 -38 h\n1 g 5957 1679 N 0 39 49 0 0
      -39 h\n1 g 5909 1679 N 0 39 48 0 0 -39 h\n1 g 5860 1679 N 0 39 49 0 0
      -39 h\n1 g 5811 1679 N 0 39 49 0 0 -39 h\n1 g 5763 1679 N 0 39 48 0 0
      -39 h\n1 g 5714 1679 N 0 39 49 0 0 -39 h\n1 g 5665 1679 N 0 39 49 0 0
      -39 h\n1 g 5617 1679 N 0 39 48 0 0 -39 h\n1 g 5568 1679 N 0 39 49 0 0
      -39 h\n1 g 5520 1679 N 0 39 48 0 0 -39 h\n1 g 5471 1679 N 0 39 49 0 0
      -39 h\n1 g 5422 1679 N 0 39 49 0 0 -39 h\n1 g 5374 1679 N 0 39 48 0 0
      -39 h\n1 g 5325 1679 N 0 39 49 0 0 -39 h\n1 g 5277 1679 N 0 39 48 0 0
      -39 h\n1 g 5228 1679 N 0 39 49 0 0 -39 h\n1 g 5179 1679 N 0 39 49 0 0
      -39 h\n1 g 5131 1679 N 0 39 48 0 0 -39 h\n1 g 5082 1679 N 0 39 49 0 0
      -39 h\n1 g 5034 1679 N 0 39 48 0 0 -39 h\n1 g 4985 1679 N 0 39 49 0 0
      -39 h\n1 g 4936 1679 N 0 39 49 0 0 -39 h\n1 g 4888 1679 N 0 39 48 0 0
      -39 h\n1 g 4839 1679 N 0 39 49 0 0 -39 h\n1 g 4790 1679 N 0 39 49 0 0
      -39 h\n1 g 4742 1679 N 0 39 48 0 0 -39 h\n1 g 4693 1679 N 0 39 49 0 0
      -39 h\n1 g 4645 1679 N 0 39 48 0 0 -39 h\n1 g 4596 1679 N 0 39 49 0 0
      -39 h\n1 g 4547 1679 N 0 39 49 0 0 -39 h\n1 g 4499 1679 N 0 39 48 0 0
      -39 h\n1 g 4450 1679 N 0 39 49 0 0 -39 h\n1 g 4402 1679 N 0 39 48 0 0
      -39 h\n.9 g 4353 1679 N 0 39 49 0 0 -39 h\n.8 g 4304 1679 N 0 39 49 0 0
      -39 h\n.8 g 4256 1679 N 0 39 48 0 0 -39 h\n.8 g 4207 1679 N 0 39 49 0 0
      -39 h\n.8 g 4159 1679 N 0 39 48 0 0 -39 h\n.8 g 4110 1679 N 0 39 49 0 0
      -39 h\n.8 g 4061 1679 N 0 39 49 0 0 -39 h\n.8 g 4013 1679 N 0 39 48 0 0
      -39 h\n.8 g 3964 1679 N 0 39 49 0 0 -39 h\n.8 g 3915 1679 N 0 39 49 0 0
      -39 h\n.8 g 3867 1679 N 0 39 48 0 0 -39 h\n.8 g 3818 1679 N 0 39 49 0 0
      -39 h\n.8 g 3770 1679 N 0 39 48 0 0 -39 h\n.8 g 3721 1679 N 0 39 49 0 0
      -39 h\n.8 g 3672 1679 N 0 39 49 0 0 -39 h\n.8 g 3624 1679 N 0 39 48 0 0
      -39 h\n.8 g 3575 1679 N 0 39 49 0 0 -39 h\n.8 g 3527 1679 N 0 39 48 0 0
      -39 h\n.8 g 3478 1679 N 0 39 49 0 0 -39 h\n.8 g 3429 1679 N 0 39 49 0 0
      -39 h\n.8 g 3381 1679 N 0 39 48 0 0 -39 h\n.8 g 3332 1679 N 0 39 49 0 0
      -39 h\n.8 g 3284 1679 N 0 39 48 0 0 -39 h\n.8 g 3235 1679 N 0 39 49 0 0
      -39 h\n.8 g 3186 1679 N 0 39 49 0 0 -39 h\n.8 g 3138 1679 N 0 39 48 0 0
      -39 h\n.8 g 3089 1679 N 0 39 49 0 0 -39 h\n.8 g 3040 1679 N 0 39 49 0 0
      -39 h\n.8 g 2992 1679 N 0 39 48 0 0 -39 h\n.8 g 2943 1679 N 0 39 49 0 0
      -39 h\n.8 g 2895 1679 N 0 39 48 0 0 -39 h\n.8 g 2846 1679 N 0 39 49 0 0
      -39 h\n.9 g 2797 1679 N 0 39 49 0 0 -39 h\n1 g 2749 1679 N 0 39 48 0 0
      -39 h\n1 g 2700 1679 N 0 39 49 0 0 -39 h\n1 g 2652 1679 N 0 39 48 0 0
      -39 h\n1 g 2603 1679 N 0 39 49 0 0 -39 h\n1 g 2554 1679 N 0 39 49 0 0
      -39 h\n1 g 2506 1679 N 0 39 48 0 0 -39 h\n1 g 2457 1679 N 0 39 49 0 0
      -39 h\n1 g 2409 1679 N 0 39 48 0 0 -39 h\n1 g 2360 1679 N 0 39 49 0 0
      -39 h\n1 g 2311 1679 N 0 39 49 0 0 -39 h\n1 g 2263 1679 N 0 39 48 0 0
      -39 h\n1 g 2214 1679 N 0 39 49 0 0 -39 h\n1 g 2165 1679 N 0 39 49 0 0
      -39 h\n1 g 2117 1679 N 0 39 48 0 0 -39 h\n1 g 2068 1679 N 0 39 49 0 0
      -39 h\n1 g 2020 1679 N 0 39 48 0 0 -39 h\n1 g 1971 1679 N 0 39 49 0 0
      -39 h\n1 g 1922 1679 N 0 39 49 0 0 -39 h\n1 g 1874 1679 N 0 39 48 0 0
      -39 h\n1 g 1825 1679 N 0 39 49 0 0 -39 h\n1 g 1777 1679 N 0 39 48 0 0
      -39 h\n1 g 1728 1679 N 0 39 49 0 0 -39 h\n1 g 1679 1679 N 0 39 49 0 0
      -39 h\n1 g 1631 1679 N 0 39 48 0 0 -39 h\n1 g 1582 1679 N 0 39 49 0 0
      -39 h\n1 g 1534 1679 N 0 39 48 0 0 -39 h\n1 g 1485 1679 N 0 39 49 0 0
      -39 h\n1 g 1436 1679 N 0 39 49 0 0 -39 h\n1 g 1388 1679 N 0 39 48 0 0
      -39 h\n1 g 1339 1679 N 0 39 49 0 0 -39 h\n1 g 1290 1679 N 0 39 49 0 0
      -39 h\n1 g 1242 1679 N 0 39 48 0 0 -39 h\n1 g 1193 1679 N 0 39 49 0 0
      -39 h\n1 g 5957 1640 N 0 39 49 0 0 -39 h\n1 g 5909 1640 N 0 39 48 0 0
      -39 h\n1 g 5860 1640 N 0 39 49 0 0 -39 h\n1 g 5811 1640 N 0 39 49 0 0
      -39 h\n1 g 5763 1640 N 0 39 48 0 0 -39 h\n1 g 5714 1640 N 0 39 49 0 0
      -39 h\n1 g 5665 1640 N 0 39 49 0 0 -39 h\n1 g 5617 1640 N 0 39 48 0 0
      -39 h\n1 g 5568 1640 N 0 39 49 0 0 -39 h\n1 g 5520 1640 N 0 39 48 0 0
      -39 h\n1 g 5471 1640 N 0 39 49 0 0 -39 h\n1 g 5422 1640 N 0 39 49 0 0
      -39 h\n1 g 5374 1640 N 0 39 48 0 0 -39 h\n1 g 5325 1640 N 0 39 49 0 0
      -39 h\n1 g 5277 1640 N 0 39 48 0 0 -39 h\n1 g 5228 1640 N 0 39 49 0 0
      -39 h\n1 g 5179 1640 N 0 39 49 0 0 -39 h\n1 g 5131 1640 N 0 39 48 0 0
      -39 h\n1 g 5082 1640 N 0 39 49 0 0 -39 h\n1 g 5034 1640 N 0 39 48 0 0
      -39 h\n1 g 4985 1640 N 0 39 49 0 0 -39 h\n1 g 4936 1640 N 0 39 49 0 0
      -39 h\n1 g 4888 1640 N 0 39 48 0 0 -39 h\n1 g 4839 1640 N 0 39 49 0 0
      -39 h\n1 g 4790 1640 N 0 39 49 0 0 -39 h\n1 g 4742 1640 N 0 39 48 0 0
      -39 h\n1 g 4693 1640 N 0 39 49 0 0 -39 h\n1 g 4645 1640 N 0 39 48 0 0
      -39 h\n1 g 4596 1640 N 0 39 49 0 0 -39 h\n1 g 4547 1640 N 0 39 49 0 0
      -39 h\n1 g 4499 1640 N 0 39 48 0 0 -39 h\n1 g 4450 1640 N 0 39 49 0 0
      -39 h\n1 g 4402 1640 N 0 39 48 0 0 -39 h\n.95 g 4353 1640 N 0 39 49 0 0
      -39 h\n.85 g 4304 1640 N 0 39 49 0 0 -39 h\n.8 g 4256 1640 N 0 39 48 0
      0 -39 h\n.8 g 4207 1640 N 0 39 49 0 0 -39 h\n.8 g 4159 1640 N 0 39 48 0
      0 -39 h\n.8 g 4110 1640 N 0 39 49 0 0 -39 h\n.8 g 4061 1640 N 0 39 49 0
      0 -39 h\n.8 g 4013 1640 N 0 39 48 0 0 -39 h\n.8 g 3964 1640 N 0 39 49 0
      0 -39 h\n.8 g 3915 1640 N 0 39 49 0 0 -39 h\n.8 g 3867 1640 N 0 39 48 0
      0 -39 h\n.8 g 3818 1640 N 0 39 49 0 0 -39 h\n.8 g 3770 1640 N 0 39 48 0
      0 -39 h\n.8 g 3721 1640 N 0 39 49 0 0 -39 h\n.8 g 3672 1640 N 0 39 49 0
      0 -39 h\n.8 g 3624 1640 N 0 39 48 0 0 -39 h\n.8 g 3575 1640 N 0 39 49 0
      0 -39 h\n.8 g 3527 1640 N 0 39 48 0 0 -39 h\n.8 g 3478 1640 N 0 39 49 0
      0 -39 h\n.8 g 3429 1640 N 0 39 49 0 0 -39 h\n.8 g 3381 1640 N 0 39 48 0
      0 -39 h\n.8 g 3332 1640 N 0 39 49 0 0 -39 h\n.8 g 3284 1640 N 0 39 48 0
      0 -39 h\n.8 g 3235 1640 N 0 39 49 0 0 -39 h\n.8 g 3186 1640 N 0 39 49 0
      0 -39 h\n.8 g 3138 1640 N 0 39 48 0 0 -39 h\n.8 g 3089 1640 N 0 39 49 0
      0 -39 h\n.8 g 3040 1640 N 0 39 49 0 0 -39 h\n.8 g 2992 1640 N 0 39 48 0
      0 -39 h\n.8 g 2943 1640 N 0 39 49 0 0 -39 h\n.8 g 2895 1640 N 0 39 48 0
      0 -39 h\n.85 g 2846 1640 N 0 39 49 0 0 -39 h\n.95 g 2797 1640 N 0 39 49
      0 0 -39 h\n1 g 2749 1640 N 0 39 48 0 0 -39 h\n1 g 2700 1640 N 0 39 49 0
      0 -39 h\n1 g 2652 1640 N 0 39 48 0 0 -39 h\n1 g 2603 1640 N 0 39 49 0 0
      -39 h\n1 g 2554 1640 N 0 39 49 0 0 -39 h\n1 g 2506 1640 N 0 39 48 0 0
      -39 h\n1 g 2457 1640 N 0 39 49 0 0 -39 h\n1 g 2409 1640 N 0 39 48 0 0
      -39 h\n1 g 2360 1640 N 0 39 49 0 0 -39 h\n1 g 2311 1640 N 0 39 49 0 0
      -39 h\n1 g 2263 1640 N 0 39 48 0 0 -39 h\n1 g 2214 1640 N 0 39 49 0 0
      -39 h\n1 g 2165 1640 N 0 39 49 0 0 -39 h\n1 g 2117 1640 N 0 39 48 0 0
      -39 h\n1 g 2068 1640 N 0 39 49 0 0 -39 h\n1 g 2020 1640 N 0 39 48 0 0
      -39 h\n1 g 1971 1640 N 0 39 49 0 0 -39 h\n1 g 1922 1640 N 0 39 49 0 0
      -39 h\n1 g 1874 1640 N 0 39 48 0 0 -39 h\n1 g 1825 1640 N 0 39 49 0 0
      -39 h\n1 g 1777 1640 N 0 39 48 0 0 -39 h\n1 g 1728 1640 N 0 39 49 0 0
      -39 h\n1 g 1679 1640 N 0 39 49 0 0 -39 h\n1 g 1631 1640 N 0 39 48 0 0
      -39 h\n1 g 1582 1640 N 0 39 49 0 0 -39 h\n1 g 1534 1640 N 0 39 48 0 0
      -39 h\n1 g 1485 1640 N 0 39 49 0 0 -39 h\n1 g 1436 1640 N 0 39 49 0 0
      -39 h\n1 g 1388 1640 N 0 39 48 0 0 -39 h\n1 g 1339 1640 N 0 39 49 0 0
      -39 h\n1 g 1290 1640 N 0 39 49 0 0 -39 h\n1 g 1242 1640 N 0 39 48 0 0
      -39 h\n1 g 1193 1640 N 0 39 49 0 0 -39 h\n1 g 5957 1601 N 0 39 49 0 0
      -39 h\n1 g 5909 1601 N 0 39 48 0 0 -39 h\n1 g 5860 1601 N 0 39 49 0 0
      -39 h\n1 g 5811 1601 N 0 39 49 0 0 -39 h\n1 g 5763 1601 N 0 39 48 0 0
      -39 h\n1 g 5714 1601 N 0 39 49 0 0 -39 h\n1 g 5665 1601 N 0 39 49 0 0
      -39 h\n1 g 5617 1601 N 0 39 48 0 0 -39 h\n1 g 5568 1601 N 0 39 49 0 0
      -39 h\n1 g 5520 1601 N 0 39 48 0 0 -39 h\n1 g 5471 1601 N 0 39 49 0 0
      -39 h\n1 g 5422 1601 N 0 39 49 0 0 -39 h\n1 g 5374 1601 N 0 39 48 0 0
      -39 h\n1 g 5325 1601 N 0 39 49 0 0 -39 h\n1 g 5277 1601 N 0 39 48 0 0
      -39 h\n1 g 5228 1601 N 0 39 49 0 0 -39 h\n1 g 5179 1601 N 0 39 49 0 0
      -39 h\n1 g 5131 1601 N 0 39 48 0 0 -39 h\n1 g 5082 1601 N 0 39 49 0 0
      -39 h\n1 g 5034 1601 N 0 39 48 0 0 -39 h\n1 g 4985 1601 N 0 39 49 0 0
      -39 h\n1 g 4936 1601 N 0 39 49 0 0 -39 h\n1 g 4888 1601 N 0 39 48 0 0
      -39 h\n1 g 4839 1601 N 0 39 49 0 0 -39 h\n1 g 4790 1601 N 0 39 49 0 0
      -39 h\n1 g 4742 1601 N 0 39 48 0 0 -39 h\n1 g 4693 1601 N 0 39 49 0 0
      -39 h\n1 g 4645 1601 N 0 39 48 0 0 -39 h\n1 g 4596 1601 N 0 39 49 0 0
      -39 h\n1 g 4547 1601 N 0 39 49 0 0 -39 h\n1 g 4499 1601 N 0 39 48 0 0
      -39 h\n1 g 4450 1601 N 0 39 49 0 0 -39 h\n1 g 4402 1601 N 0 39 48 0 0
      -39 h\n1 g 4353 1601 N 0 39 49 0 0 -39 h\n.9 g 4304 1601 N 0 39 49 0 0
      -39 h\n.8 g 4256 1601 N 0 39 48 0 0 -39 h\n.8 g 4207 1601 N 0 39 49 0 0
      -39 h\n.8 g 4159 1601 N 0 39 48 0 0 -39 h\n.8 g 4110 1601 N 0 39 49 0 0
      -39 h\n.8 g 4061 1601 N 0 39 49 0 0 -39 h\n.8 g 4013 1601 N 0 39 48 0 0
      -39 h\n.8 g 3964 1601 N 0 39 49 0 0 -39 h\n.8 g 3915 1601 N 0 39 49 0 0
      -39 h\n.8 g 3867 1601 N 0 39 48 0 0 -39 h\n.8 g 3818 1601 N 0 39 49 0 0
      -39 h\n.8 g 3770 1601 N 0 39 48 0 0 -39 h\n.8 g 3721 1601 N 0 39 49 0 0
      -39 h\n.8 g 3672 1601 N 0 39 49 0 0 -39 h\n.8 g 3624 1601 N 0 39 48 0 0
      -39 h\n.8 g 3575 1601 N 0 39 49 0 0 -39 h\n.8 g 3527 1601 N 0 39 48 0 0
      -39 h\n.8 g 3478 1601 N 0 39 49 0 0 -39 h\n.8 g 3429 1601 N 0 39 49 0 0
      -39 h\n.8 g 3381 1601 N 0 39 48 0 0 -39 h\n.8 g 3332 1601 N 0 39 49 0 0
      -39 h\n.8 g 3284 1601 N 0 39 48 0 0 -39 h\n.8 g 3235 1601 N 0 39 49 0 0
      -39 h\n.8 g 3186 1601 N 0 39 49 0 0 -39 h\n.8 g 3138 1601 N 0 39 48 0 0
      -39 h\n.8 g 3089 1601 N 0 39 49 0 0 -39 h\n.8 g 3040 1601 N 0 39 49 0 0
      -39 h\n.8 g 2992 1601 N 0 39 48 0 0 -39 h\n.8 g 2943 1601 N 0 39 49 0 0
      -39 h\n.8 g 2895 1601 N 0 39 48 0 0 -39 h\n.9 g 2846 1601 N 0 39 49 0 0
      -39 h\n1 g 2797 1601 N 0 39 49 0 0 -39 h\n1 g 2749 1601 N 0 39 48 0 0
      -39 h\n1 g 2700 1601 N 0 39 49 0 0 -39 h\n1 g 2652 1601 N 0 39 48 0 0
      -39 h\n1 g 2603 1601 N 0 39 49 0 0 -39 h\n1 g 2554 1601 N 0 39 49 0 0
      -39 h\n1 g 2506 1601 N 0 39 48 0 0 -39 h\n1 g 2457 1601 N 0 39 49 0 0
      -39 h\n1 g 2409 1601 N 0 39 48 0 0 -39 h\n1 g 2360 1601 N 0 39 49 0 0
      -39 h\n1 g 2311 1601 N 0 39 49 0 0 -39 h\n1 g 2263 1601 N 0 39 48 0 0
      -39 h\n1 g 2214 1601 N 0 39 49 0 0 -39 h\n1 g 2165 1601 N 0 39 49 0 0
      -39 h\n1 g 2117 1601 N 0 39 48 0 0 -39 h\n1 g 2068 1601 N 0 39 49 0 0
      -39 h\n1 g 2020 1601 N 0 39 48 0 0 -39 h\n1 g 1971 1601 N 0 39 49 0 0
      -39 h\n1 g 1922 1601 N 0 39 49 0 0 -39 h\n1 g 1874 1601 N 0 39 48 0 0
      -39 h\n1 g 1825 1601 N 0 39 49 0 0 -39 h\n1 g 1777 1601 N 0 39 48 0 0
      -39 h\n1 g 1728 1601 N 0 39 49 0 0 -39 h\n1 g 1679 1601 N 0 39 49 0 0
      -39 h\n1 g 1631 1601 N 0 39 48 0 0 -39 h\n1 g 1582 1601 N 0 39 49 0 0
      -39 h\n1 g 1534 1601 N 0 39 48 0 0 -39 h\n1 g 1485 1601 N 0 39 49 0 0
      -39 h\n1 g 1436 1601 N 0 39 49 0 0 -39 h\n1 g 1388 1601 N 0 39 48 0 0
      -39 h\n1 g 1339 1601 N 0 39 49 0 0 -39 h\n1 g 1290 1601 N 0 39 49 0 0
      -39 h\n1 g 1242 1601 N 0 39 48 0 0 -39 h\n1 g 1193 1601 N 0 39 49 0 0
      -39 h\n1 g 5957 1562 N 0 38 49 0 0 -38 h\n1 g 5909 1562 N 0 38 48 0 0
      -38 h\n1 g 5860 1562 N 0 38 49 0 0 -38 h\n1 g 5811 1562 N 0 38 49 0 0
      -38 h\n1 g 5763 1562 N 0 38 48 0 0 -38 h\n1 g 5714 1562 N 0 38 49 0 0
      -38 h\n1 g 5665 1562 N 0 38 49 0 0 -38 h\n1 g 5617 1562 N 0 38 48 0 0
      -38 h\n1 g 5568 1562 N 0 38 49 0 0 -38 h\n1 g 5520 1562 N 0 38 48 0 0
      -38 h\n1 g 5471 1562 N 0 38 49 0 0 -38 h\n1 g 5422 1562 N 0 38 49 0 0
      -38 h\n1 g 5374 1562 N 0 38 48 0 0 -38 h\n1 g 5325 1562 N 0 38 49 0 0
      -38 h\n1 g 5277 1562 N 0 38 48 0 0 -38 h\n1 g 5228 1562 N 0 38 49 0 0
      -38 h\n1 g 5179 1562 N 0 38 49 0 0 -38 h\n1 g 5131 1562 N 0 38 48 0 0
      -38 h\n1 g 5082 1562 N 0 38 49 0 0 -38 h\n1 g 5034 1562 N 0 38 48 0 0
      -38 h\n1 g 4985 1562 N 0 38 49 0 0 -38 h\n1 g 4936 1562 N 0 38 49 0 0
      -38 h\n1 g 4888 1562 N 0 38 48 0 0 -38 h\n1 g 4839 1562 N 0 38 49 0 0
      -38 h\n1 g 4790 1562 N 0 38 49 0 0 -38 h\n1 g 4742 1562 N 0 38 48 0 0
      -38 h\n1 g 4693 1562 N 0 38 49 0 0 -38 h\n1 g 4645 1562 N 0 38 48 0 0
      -38 h\n1 g 4596 1562 N 0 38 49 0 0 -38 h\n1 g 4547 1562 N 0 38 49 0 0
      -38 h\n1 g 4499 1562 N 0 38 48 0 0 -38 h\n1 g 4450 1562 N 0 38 49 0 0
      -38 h\n1 g 4402 1562 N 0 38 48 0 0 -38 h\n1 g 4353 1562 N 0 38 49 0 0
      -38 h\n.9 g 4304 1562 N 0 38 49 0 0 -38 h\n.8 g 4256 1562 N 0 38 48 0 0
      -38 h\n.8 g 4207 1562 N 0 38 49 0 0 -38 h\n.8 g 4159 1562 N 0 38 48 0 0
      -38 h\n.8 g 4110 1562 N 0 38 49 0 0 -38 h\n.8 g 4061 1562 N 0 38 49 0 0
      -38 h\n.8 g 4013 1562 N 0 38 48 0 0 -38 h\n.8 g 3964 1562 N 0 38 49 0 0
      -38 h\n.8 g 3915 1562 N 0 38 49 0 0 -38 h\n.8 g 3867 1562 N 0 38 48 0 0
      -38 h\n.8 g 3818 1562 N 0 38 49 0 0 -38 h\n.8 g 3770 1562 N 0 38 48 0 0
      -38 h\n.8 g 3721 1562 N 0 38 49 0 0 -38 h\n.8 g 3672 1562 N 0 38 49 0 0
      -38 h\n.8 g 3624 1562 N 0 38 48 0 0 -38 h\n.8 g 3575 1562 N 0 38 49 0 0
      -38 h\n.8 g 3527 1562 N 0 38 48 0 0 -38 h\n.8 g 3478 1562 N 0 38 49 0 0
      -38 h\n.8 g 3429 1562 N 0 38 49 0 0 -38 h\n.8 g 3381 1562 N 0 38 48 0 0
      -38 h\n.8 g 3332 1562 N 0 38 49 0 0 -38 h\n.8 g 3284 1562 N 0 38 48 0 0
      -38 h\n.8 g 3235 1562 N 0 38 49 0 0 -38 h\n.8 g 3186 1562 N 0 38 49 0 0
      -38 h\n.8 g 3138 1562 N 0 38 48 0 0 -38 h\n.8 g 3089 1562 N 0 38 49 0 0
      -38 h\n.8 g 3040 1562 N 0 38 49 0 0 -38 h\n.8 g 2992 1562 N 0 38 48 0 0
      -38 h\n.8 g 2943 1562 N 0 38 49 0 0 -38 h\n.8 g 2895 1562 N 0 38 48 0 0
      -38 h\n.9 g 2846 1562 N 0 38 49 0 0 -38 h\n1 g 2797 1562 N 0 38 49 0 0
      -38 h\n1 g 2749 1562 N 0 38 48 0 0 -38 h\n1 g 2700 1562 N 0 38 49 0 0
      -38 h\n1 g 2652 1562 N 0 38 48 0 0 -38 h\n1 g 2603 1562 N 0 38 49 0 0
      -38 h\n1 g 2554 1562 N 0 38 49 0 0 -38 h\n1 g 2506 1562 N 0 38 48 0 0
      -38 h\n1 g 2457 1562 N 0 38 49 0 0 -38 h\n1 g 2409 1562 N 0 38 48 0 0
      -38 h\n1 g 2360 1562 N 0 38 49 0 0 -38 h\n1 g 2311 1562 N 0 38 49 0 0
      -38 h\n1 g 2263 1562 N 0 38 48 0 0 -38 h\n1 g 2214 1562 N 0 38 49 0 0
      -38 h\n1 g 2165 1562 N 0 38 49 0 0 -38 h\n1 g 2117 1562 N 0 38 48 0 0
      -38 h\n1 g 2068 1562 N 0 38 49 0 0 -38 h\n1 g 2020 1562 N 0 38 48 0 0
      -38 h\n1 g 1971 1562 N 0 38 49 0 0 -38 h\n1 g 1922 1562 N 0 38 49 0 0
      -38 h\n1 g 1874 1562 N 0 38 48 0 0 -38 h\n1 g 1825 1562 N 0 38 49 0 0
      -38 h\n1 g 1777 1562 N 0 38 48 0 0 -38 h\n1 g 1728 1562 N 0 38 49 0 0
      -38 h\n1 g 1679 1562 N 0 38 49 0 0 -38 h\n1 g 1631 1562 N 0 38 48 0 0
      -38 h\n1 g 1582 1562 N 0 38 49 0 0 -38 h\n1 g 1534 1562 N 0 38 48 0 0
      -38 h\n1 g 1485 1562 N 0 38 49 0 0 -38 h\n1 g 1436 1562 N 0 38 49 0 0
      -38 h\n1 g 1388 1562 N 0 38 48 0 0 -38 h\n1 g 1339 1562 N 0 38 49 0 0
      -38 h\n1 g 1290 1562 N 0 38 49 0 0 -38 h\n1 g 1242 1562 N 0 38 48 0 0
      -38 h\n1 g 1193 1562 N 0 38 49 0 0 -38 h\n1 g 5957 1524 N 0 39 49 0 0
      -39 h\n1 g 5909 1524 N 0 39 48 0 0 -39 h\n1 g 5860 1524 N 0 39 49 0 0
      -39 h\n1 g 5811 1524 N 0 39 49 0 0 -39 h\n1 g 5763 1524 N 0 39 48 0 0
      -39 h\n1 g 5714 1524 N 0 39 49 0 0 -39 h\n1 g 5665 1524 N 0 39 49 0 0
      -39 h\n1 g 5617 1524 N 0 39 48 0 0 -39 h\n1 g 5568 1524 N 0 39 49 0 0
      -39 h\n1 g 5520 1524 N 0 39 48 0 0 -39 h\n1 g 5471 1524 N 0 39 49 0 0
      -39 h\n1 g 5422 1524 N 0 39 49 0 0 -39 h\n1 g 5374 1524 N 0 39 48 0 0
      -39 h\n1 g 5325 1524 N 0 39 49 0 0 -39 h\n1 g 5277 1524 N 0 39 48 0 0
      -39 h\n1 g 5228 1524 N 0 39 49 0 0 -39 h\n1 g 5179 1524 N 0 39 49 0 0
      -39 h\n1 g 5131 1524 N 0 39 48 0 0 -39 h\n1 g 5082 1524 N 0 39 49 0 0
      -39 h\n1 g 5034 1524 N 0 39 48 0 0 -39 h\n1 g 4985 1524 N 0 39 49 0 0
      -39 h\n1 g 4936 1524 N 0 39 49 0 0 -39 h\n1 g 4888 1524 N 0 39 48 0 0
      -39 h\n1 g 4839 1524 N 0 39 49 0 0 -39 h\n1 g 4790 1524 N 0 39 49 0 0
      -39 h\n1 g 4742 1524 N 0 39 48 0 0 -39 h\n1 g 4693 1524 N 0 39 49 0 0
      -39 h\n1 g 4645 1524 N 0 39 48 0 0 -39 h\n1 g 4596 1524 N 0 39 49 0 0
      -39 h\n1 g 4547 1524 N 0 39 49 0 0 -39 h\n1 g 4499 1524 N 0 39 48 0 0
      -39 h\n1 g 4450 1524 N 0 39 49 0 0 -39 h\n1 g 4402 1524 N 0 39 48 0 0
      -39 h\n1 g 4353 1524 N 0 39 49 0 0 -39 h\n.95 g 4304 1524 N 0 39 49 0 0
      -39 h\n.85 g 4256 1524 N 0 39 48 0 0 -39 h\n.8 g 4207 1524 N 0 39 49 0
      0 -39 h\n.8 g 4159 1524 N 0 39 48 0 0 -39 h\n.8 g 4110 1524 N 0 39 49 0
      0 -39 h\n.8 g 4061 1524 N 0 39 49 0 0 -39 h\n.8 g 4013 1524 N 0 39 48 0
      0 -39 h\n.8 g 3964 1524 N 0 39 49 0 0 -39 h\n.8 g 3915 1524 N 0 39 49 0
      0 -39 h\n.8 g 3867 1524 N 0 39 48 0 0 -39 h\n.8 g 3818 1524 N 0 39 49 0
      0 -39 h\n.8 g 3770 1524 N 0 39 48 0 0 -39 h\n.8 g 3721 1524 N 0 39 49 0
      0 -39 h\n.8 g 3672 1524 N 0 39 49 0 0 -39 h\n.8 g 3624 1524 N 0 39 48 0
      0 -39 h\n.8 g 3575 1524 N 0 39 49 0 0 -39 h\n.8 g 3527 1524 N 0 39 48 0
      0 -39 h\n.8 g 3478 1524 N 0 39 49 0 0 -39 h\n.8 g 3429 1524 N 0 39 49 0
      0 -39 h\n.8 g 3381 1524 N 0 39 48 0 0 -39 h\n.8 g 3332 1524 N 0 39 49 0
      0 -39 h\n.8 g 3284 1524 N 0 39 48 0 0 -39 h\n.8 g 3235 1524 N 0 39 49 0
      0 -39 h\n.8 g 3186 1524 N 0 39 49 0 0 -39 h\n.8 g 3138 1524 N 0 39 48 0
      0 -39 h\n.8 g 3089 1524 N 0 39 49 0 0 -39 h\n.8 g 3040 1524 N 0 39 49 0
      0 -39 h\n.8 g 2992 1524 N 0 39 48 0 0 -39 h\n.8 g 2943 1524 N 0 39 49 0
      0 -39 h\n.85 g 2895 1524 N 0 39 48 0 0 -39 h\n.95 g 2846 1524 N 0 39 49
      0 0 -39 h\n1 g 2797 1524 N 0 39 49 0 0 -39 h\n1 g 2749 1524 N 0 39 48 0
      0 -39 h\n1 g 2700 1524 N 0 39 49 0 0 -39 h\n1 g 2652 1524 N 0 39 48 0 0
      -39 h\n1 g 2603 1524 N 0 39 49 0 0 -39 h\n1 g 2554 1524 N 0 39 49 0 0
      -39 h\n1 g 2506 1524 N 0 39 48 0 0 -39 h\n1 g 2457 1524 N 0 39 49 0 0
      -39 h\n1 g 2409 1524 N 0 39 48 0 0 -39 h\n1 g 2360 1524 N 0 39 49 0 0
      -39 h\n1 g 2311 1524 N 0 39 49 0 0 -39 h\n1 g 2263 1524 N 0 39 48 0 0
      -39 h\n1 g 2214 1524 N 0 39 49 0 0 -39 h\n1 g 2165 1524 N 0 39 49 0 0
      -39 h\n1 g 2117 1524 N 0 39 48 0 0 -39 h\n1 g 2068 1524 N 0 39 49 0 0
      -39 h\n1 g 2020 1524 N 0 39 48 0 0 -39 h\n1 g 1971 1524 N 0 39 49 0 0
      -39 h\n1 g 1922 1524 N 0 39 49 0 0 -39 h\n1 g 1874 1524 N 0 39 48 0 0
      -39 h\n1 g 1825 1524 N 0 39 49 0 0 -39 h\n1 g 1777 1524 N 0 39 48 0 0
      -39 h\n1 g 1728 1524 N 0 39 49 0 0 -39 h\n1 g 1679 1524 N 0 39 49 0 0
      -39 h\n1 g 1631 1524 N 0 39 48 0 0 -39 h\n1 g 1582 1524 N 0 39 49 0 0
      -39 h\n1 g 1534 1524 N 0 39 48 0 0 -39 h\n1 g 1485 1524 N 0 39 49 0 0
      -39 h\n1 g 1436 1524 N 0 39 49 0 0 -39 h\n1 g 1388 1524 N 0 39 48 0 0
      -39 h\n1 g 1339 1524 N 0 39 49 0 0 -39 h\n1 g 1290 1524 N 0 39 49 0 0
      -39 h\n1 g 1242 1524 N 0 39 48 0 0 -39 h\n1 g 1193 1524 N 0 39 49 0 0
      -39 h\n1 g 5957 1485 N 0 39 49 0 0 -39 h\n1 g 5909 1485 N 0 39 48 0 0
      -39 h\n1 g 5860 1485 N 0 39 49 0 0 -39 h\n1 g 5811 1485 N 0 39 49 0 0
      -39 h\n1 g 5763 1485 N 0 39 48 0 0 -39 h\n1 g 5714 1485 N 0 39 49 0 0
      -39 h\n1 g 5665 1485 N 0 39 49 0 0 -39 h\n1 g 5617 1485 N 0 39 48 0 0
      -39 h\n1 g 5568 1485 N 0 39 49 0 0 -39 h\n1 g 5520 1485 N 0 39 48 0 0
      -39 h\n1 g 5471 1485 N 0 39 49 0 0 -39 h\n1 g 5422 1485 N 0 39 49 0 0
      -39 h\n1 g 5374 1485 N 0 39 48 0 0 -39 h\n1 g 5325 1485 N 0 39 49 0 0
      -39 h\n1 g 5277 1485 N 0 39 48 0 0 -39 h\n1 g 5228 1485 N 0 39 49 0 0
      -39 h\n1 g 5179 1485 N 0 39 49 0 0 -39 h\n1 g 5131 1485 N 0 39 48 0 0
      -39 h\n1 g 5082 1485 N 0 39 49 0 0 -39 h\n1 g 5034 1485 N 0 39 48 0 0
      -39 h\n1 g 4985 1485 N 0 39 49 0 0 -39 h\n1 g 4936 1485 N 0 39 49 0 0
      -39 h\n1 g 4888 1485 N 0 39 48 0 0 -39 h\n1 g 4839 1485 N 0 39 49 0 0
      -39 h\n1 g 4790 1485 N 0 39 49 0 0 -39 h\n1 g 4742 1485 N 0 39 48 0 0
      -39 h\n1 g 4693 1485 N 0 39 49 0 0 -39 h\n1 g 4645 1485 N 0 39 48 0 0
      -39 h\n1 g 4596 1485 N 0 39 49 0 0 -39 h\n1 g 4547 1485 N 0 39 49 0 0
      -39 h\n1 g 4499 1485 N 0 39 48 0 0 -39 h\n1 g 4450 1485 N 0 39 49 0 0
      -39 h\n1 g 4402 1485 N 0 39 48 0 0 -39 h\n1 g 4353 1485 N 0 39 49 0 0
      -39 h\n1 g 4304 1485 N 0 39 49 0 0 -39 h\n.9 g 4256 1485 N 0 39 48 0 0
      -39 h\n.8 g 4207 1485 N 0 39 49 0 0 -39 h\n.8 g 4159 1485 N 0 39 48 0 0
      -39 h\n.8 g 4110 1485 N 0 39 49 0 0 -39 h\n.8 g 4061 1485 N 0 39 49 0 0
      -39 h\n.8 g 4013 1485 N 0 39 48 0 0 -39 h\n.8 g 3964 1485 N 0 39 49 0 0
      -39 h\n.8 g 3915 1485 N 0 39 49 0 0 -39 h\n.8 g 3867 1485 N 0 39 48 0 0
      -39 h\n.8 g 3818 1485 N 0 39 49 0 0 -39 h\n.8 g 3770 1485 N 0 39 48 0 0
      -39 h\n.8 g 3721 1485 N 0 39 49 0 0 -39 h\n.8 g 3672 1485 N 0 39 49 0 0
      -39 h\n.8 g 3624 1485 N 0 39 48 0 0 -39 h\n.8 g 3575 1485 N 0 39 49 0 0
      -39 h\n.8 g 3527 1485 N 0 39 48 0 0 -39 h\n.8 g 3478 1485 N 0 39 49 0 0
      -39 h\n.8 g 3429 1485 N 0 39 49 0 0 -39 h\n.8 g 3381 1485 N 0 39 48 0 0
      -39 h\n.8 g 3332 1485 N 0 39 49 0 0 -39 h\n.8 g 3284 1485 N 0 39 48 0 0
      -39 h\n.8 g 3235 1485 N 0 39 49 0 0 -39 h\n.8 g 3186 1485 N 0 39 49 0 0
      -39 h\n.8 g 3138 1485 N 0 39 48 0 0 -39 h\n.8 g 3089 1485 N 0 39 49 0 0
      -39 h\n.8 g 3040 1485 N 0 39 49 0 0 -39 h\n.8 g 2992 1485 N 0 39 48 0 0
      -39 h\n.8 g 2943 1485 N 0 39 49 0 0 -39 h\n.9 g 2895 1485 N 0 39 48 0 0
      -39 h\n1 g 2846 1485 N 0 39 49 0 0 -39 h\n1 g 2797 1485 N 0 39 49 0 0
      -39 h\n1 g 2749 1485 N 0 39 48 0 0 -39 h\n1 g 2700 1485 N 0 39 49 0 0
      -39 h\n1 g 2652 1485 N 0 39 48 0 0 -39 h\n1 g 2603 1485 N 0 39 49 0 0
      -39 h\n1 g 2554 1485 N 0 39 49 0 0 -39 h\n1 g 2506 1485 N 0 39 48 0 0
      -39 h\n1 g 2457 1485 N 0 39 49 0 0 -39 h\n1 g 2409 1485 N 0 39 48 0 0
      -39 h\n1 g 2360 1485 N 0 39 49 0 0 -39 h\n1 g 2311 1485 N 0 39 49 0 0
      -39 h\n1 g 2263 1485 N 0 39 48 0 0 -39 h\n1 g 2214 1485 N 0 39 49 0 0
      -39 h\n1 g 2165 1485 N 0 39 49 0 0 -39 h\n1 g 2117 1485 N 0 39 48 0 0
      -39 h\n1 g 2068 1485 N 0 39 49 0 0 -39 h\n1 g 2020 1485 N 0 39 48 0 0
      -39 h\n1 g 1971 1485 N 0 39 49 0 0 -39 h\n1 g 1922 1485 N 0 39 49 0 0
      -39 h\n1 g 1874 1485 N 0 39 48 0 0 -39 h\n1 g 1825 1485 N 0 39 49 0 0
      -39 h\n1 g 1777 1485 N 0 39 48 0 0 -39 h\n1 g 1728 1485 N 0 39 49 0 0
      -39 h\n1 g 1679 1485 N 0 39 49 0 0 -39 h\n1 g 1631 1485 N 0 39 48 0 0
      -39 h\n1 g 1582 1485 N 0 39 49 0 0 -39 h\n1 g 1534 1485 N 0 39 48 0 0
      -39 h\n1 g 1485 1485 N 0 39 49 0 0 -39 h\n1 g 1436 1485 N 0 39 49 0 0
      -39 h\n1 g 1388 1485 N 0 39 48 0 0 -39 h\n1 g 1339 1485 N 0 39 49 0 0
      -39 h\n1 g 1290 1485 N 0 39 49 0 0 -39 h\n1 g 1242 1485 N 0 39 48 0 0
      -39 h\n1 g 1193 1485 N 0 39 49 0 0 -39 h\n1 g 5957 1446 N 0 39 49 0 0
      -39 h\n1 g 5909 1446 N 0 39 48 0 0 -39 h\n1 g 5860 1446 N 0 39 49 0 0
      -39 h\n1 g 5811 1446 N 0 39 49 0 0 -39 h\n1 g 5763 1446 N 0 39 48 0 0
      -39 h\n1 g 5714 1446 N 0 39 49 0 0 -39 h\n1 g 5665 1446 N 0 39 49 0 0
      -39 h\n1 g 5617 1446 N 0 39 48 0 0 -39 h\n1 g 5568 1446 N 0 39 49 0 0
      -39 h\n1 g 5520 1446 N 0 39 48 0 0 -39 h\n1 g 5471 1446 N 0 39 49 0 0
      -39 h\n1 g 5422 1446 N 0 39 49 0 0 -39 h\n1 g 5374 1446 N 0 39 48 0 0
      -39 h\n1 g 5325 1446 N 0 39 49 0 0 -39 h\n1 g 5277 1446 N 0 39 48 0 0
      -39 h\n1 g 5228 1446 N 0 39 49 0 0 -39 h\n1 g 5179 1446 N 0 39 49 0 0
      -39 h\n1 g 5131 1446 N 0 39 48 0 0 -39 h\n1 g 5082 1446 N 0 39 49 0 0
      -39 h\n1 g 5034 1446 N 0 39 48 0 0 -39 h\n1 g 4985 1446 N 0 39 49 0 0
      -39 h\n1 g 4936 1446 N 0 39 49 0 0 -39 h\n1 g 4888 1446 N 0 39 48 0 0
      -39 h\n1 g 4839 1446 N 0 39 49 0 0 -39 h\n1 g 4790 1446 N 0 39 49 0 0
      -39 h\n1 g 4742 1446 N 0 39 48 0 0 -39 h\n1 g 4693 1446 N 0 39 49 0 0
      -39 h\n1 g 4645 1446 N 0 39 48 0 0 -39 h\n1 g 4596 1446 N 0 39 49 0 0
      -39 h\n1 g 4547 1446 N 0 39 49 0 0 -39 h\n1 g 4499 1446 N 0 39 48 0 0
      -39 h\n1 g 4450 1446 N 0 39 49 0 0 -39 h\n1 g 4402 1446 N 0 39 48 0 0
      -39 h\n1 g 4353 1446 N 0 39 49 0 0 -39 h\n1 g 4304 1446 N 0 39 49 0 0
      -39 h\n.9 g 4256 1446 N 0 39 48 0 0 -39 h\n.8 g 4207 1446 N 0 39 49 0 0
      -39 h\n.8 g 4159 1446 N 0 39 48 0 0 -39 h\n.8 g 4110 1446 N 0 39 49 0 0
      -39 h\n.8 g 4061 1446 N 0 39 49 0 0 -39 h\n.8 g 4013 1446 N 0 39 48 0 0
      -39 h\n.8 g 3964 1446 N 0 39 49 0 0 -39 h\n.8 g 3915 1446 N 0 39 49 0 0
      -39 h\n.8 g 3867 1446 N 0 39 48 0 0 -39 h\n.8 g 3818 1446 N 0 39 49 0 0
      -39 h\n.8 g 3770 1446 N 0 39 48 0 0 -39 h\n.8 g 3721 1446 N 0 39 49 0 0
      -39 h\n.8 g 3672 1446 N 0 39 49 0 0 -39 h\n.8 g 3624 1446 N 0 39 48 0 0
      -39 h\n.8 g 3575 1446 N 0 39 49 0 0 -39 h\n.8 g 3527 1446 N 0 39 48 0 0
      -39 h\n.8 g 3478 1446 N 0 39 49 0 0 -39 h\n.8 g 3429 1446 N 0 39 49 0 0
      -39 h\n.8 g 3381 1446 N 0 39 48 0 0 -39 h\n.8 g 3332 1446 N 0 39 49 0 0
      -39 h\n.8 g 3284 1446 N 0 39 48 0 0 -39 h\n.8 g 3235 1446 N 0 39 49 0 0
      -39 h\n.8 g 3186 1446 N 0 39 49 0 0 -39 h\n.8 g 3138 1446 N 0 39 48 0 0
      -39 h\n.8 g 3089 1446 N 0 39 49 0 0 -39 h\n.8 g 3040 1446 N 0 39 49 0 0
      -39 h\n.8 g 2992 1446 N 0 39 48 0 0 -39 h\n.8 g 2943 1446 N 0 39 49 0 0
      -39 h\n.9 g 2895 1446 N 0 39 48 0 0 -39 h\n1 g 2846 1446 N 0 39 49 0 0
      -39 h\n1 g 2797 1446 N 0 39 49 0 0 -39 h\n1 g 2749 1446 N 0 39 48 0 0
      -39 h\n1 g 2700 1446 N 0 39 49 0 0 -39 h\n1 g 2652 1446 N 0 39 48 0 0
      -39 h\n1 g 2603 1446 N 0 39 49 0 0 -39 h\n1 g 2554 1446 N 0 39 49 0 0
      -39 h\n1 g 2506 1446 N 0 39 48 0 0 -39 h\n1 g 2457 1446 N 0 39 49 0 0
      -39 h\n1 g 2409 1446 N 0 39 48 0 0 -39 h\n1 g 2360 1446 N 0 39 49 0 0
      -39 h\n1 g 2311 1446 N 0 39 49 0 0 -39 h\n1 g 2263 1446 N 0 39 48 0 0
      -39 h\n1 g 2214 1446 N 0 39 49 0 0 -39 h\n1 g 2165 1446 N 0 39 49 0 0
      -39 h\n1 g 2117 1446 N 0 39 48 0 0 -39 h\n1 g 2068 1446 N 0 39 49 0 0
      -39 h\n1 g 2020 1446 N 0 39 48 0 0 -39 h\n1 g 1971 1446 N 0 39 49 0 0
      -39 h\n1 g 1922 1446 N 0 39 49 0 0 -39 h\n1 g 1874 1446 N 0 39 48 0 0
      -39 h\n1 g 1825 1446 N 0 39 49 0 0 -39 h\n1 g 1777 1446 N 0 39 48 0 0
      -39 h\n1 g 1728 1446 N 0 39 49 0 0 -39 h\n1 g 1679 1446 N 0 39 49 0 0
      -39 h\n1 g 1631 1446 N 0 39 48 0 0 -39 h\n1 g 1582 1446 N 0 39 49 0 0
      -39 h\n1 g 1534 1446 N 0 39 48 0 0 -39 h\n1 g 1485 1446 N 0 39 49 0 0
      -39 h\n1 g 1436 1446 N 0 39 49 0 0 -39 h\n1 g 1388 1446 N 0 39 48 0 0
      -39 h\n1 g 1339 1446 N 0 39 49 0 0 -39 h\n1 g 1290 1446 N 0 39 49 0 0
      -39 h\n1 g 1242 1446 N 0 39 48 0 0 -39 h\n1 g 1193 1446 N 0 39 49 0 0
      -39 h\n1 g 5957 1407 N 0 38 49 0 0 -38 h\n1 g 5909 1407 N 0 38 48 0 0
      -38 h\n1 g 5860 1407 N 0 38 49 0 0 -38 h\n1 g 5811 1407 N 0 38 49 0 0
      -38 h\n1 g 5763 1407 N 0 38 48 0 0 -38 h\n1 g 5714 1407 N 0 38 49 0 0
      -38 h\n1 g 5665 1407 N 0 38 49 0 0 -38 h\n1 g 5617 1407 N 0 38 48 0 0
      -38 h\n1 g 5568 1407 N 0 38 49 0 0 -38 h\n1 g 5520 1407 N 0 38 48 0 0
      -38 h\n1 g 5471 1407 N 0 38 49 0 0 -38 h\n1 g 5422 1407 N 0 38 49 0 0
      -38 h\n1 g 5374 1407 N 0 38 48 0 0 -38 h\n1 g 5325 1407 N 0 38 49 0 0
      -38 h\n1 g 5277 1407 N 0 38 48 0 0 -38 h\n1 g 5228 1407 N 0 38 49 0 0
      -38 h\n1 g 5179 1407 N 0 38 49 0 0 -38 h\n1 g 5131 1407 N 0 38 48 0 0
      -38 h\n1 g 5082 1407 N 0 38 49 0 0 -38 h\n1 g 5034 1407 N 0 38 48 0 0
      -38 h\n1 g 4985 1407 N 0 38 49 0 0 -38 h\n1 g 4936 1407 N 0 38 49 0 0
      -38 h\n1 g 4888 1407 N 0 38 48 0 0 -38 h\n1 g 4839 1407 N 0 38 49 0 0
      -38 h\n1 g 4790 1407 N 0 38 49 0 0 -38 h\n1 g 4742 1407 N 0 38 48 0 0
      -38 h\n1 g 4693 1407 N 0 38 49 0 0 -38 h\n1 g 4645 1407 N 0 38 48 0 0
      -38 h\n1 g 4596 1407 N 0 38 49 0 0 -38 h\n1 g 4547 1407 N 0 38 49 0 0
      -38 h\n1 g 4499 1407 N 0 38 48 0 0 -38 h\n1 g 4450 1407 N 0 38 49 0 0
      -38 h\n1 g 4402 1407 N 0 38 48 0 0 -38 h\n1 g 4353 1407 N 0 38 49 0 0
      -38 h\n1 g 4304 1407 N 0 38 49 0 0 -38 h\n.95 g 4256 1407 N 0 38 48 0 0
      -38 h\n.85 g 4207 1407 N 0 38 49 0 0 -38 h\n.8 g 4159 1407 N 0 38 48 0
      0 -38 h\n.8 g 4110 1407 N 0 38 49 0 0 -38 h\n.8 g 4061 1407 N 0 38 49 0
      0 -38 h\n.8 g 4013 1407 N 0 38 48 0 0 -38 h\n.8 g 3964 1407 N 0 38 49 0
      0 -38 h\n.8 g 3915 1407 N 0 38 49 0 0 -38 h\n.8 g 3867 1407 N 0 38 48 0
      0 -38 h\n.8 g 3818 1407 N 0 38 49 0 0 -38 h\n.8 g 3770 1407 N 0 38 48 0
      0 -38 h\n.8 g 3721 1407 N 0 38 49 0 0 -38 h\n.8 g 3672 1407 N 0 38 49 0
      0 -38 h\n.8 g 3624 1407 N 0 38 48 0 0 -38 h\n.8 g 3575 1407 N 0 38 49 0
      0 -38 h\n.8 g 3527 1407 N 0 38 48 0 0 -38 h\n.8 g 3478 1407 N 0 38 49 0
      0 -38 h\n.8 g 3429 1407 N 0 38 49 0 0 -38 h\n.8 g 3381 1407 N 0 38 48 0
      0 -38 h\n.8 g 3332 1407 N 0 38 49 0 0 -38 h\n.8 g 3284 1407 N 0 38 48 0
      0 -38 h\n.8 g 3235 1407 N 0 38 49 0 0 -38 h\n.8 g 3186 1407 N 0 38 49 0
      0 -38 h\n.8 g 3138 1407 N 0 38 48 0 0 -38 h\n.8 g 3089 1407 N 0 38 49 0
      0 -38 h\n.8 g 3040 1407 N 0 38 49 0 0 -38 h\n.8 g 2992 1407 N 0 38 48 0
      0 -38 h\n.85 g 2943 1407 N 0 38 49 0 0 -38 h\n.95 g 2895 1407 N 0 38 48
      0 0 -38 h\n1 g 2846 1407 N 0 38 49 0 0 -38 h\n1 g 2797 1407 N 0 38 49 0
      0 -38 h\n1 g 2749 1407 N 0 38 48 0 0 -38 h\n1 g 2700 1407 N 0 38 49 0 0
      -38 h\n1 g 2652 1407 N 0 38 48 0 0 -38 h\n1 g 2603 1407 N 0 38 49 0 0
      -38 h\n1 g 2554 1407 N 0 38 49 0 0 -38 h\n1 g 2506 1407 N 0 38 48 0 0
      -38 h\n1 g 2457 1407 N 0 38 49 0 0 -38 h\n1 g 2409 1407 N 0 38 48 0 0
      -38 h\n1 g 2360 1407 N 0 38 49 0 0 -38 h\n1 g 2311 1407 N 0 38 49 0 0
      -38 h\n1 g 2263 1407 N 0 38 48 0 0 -38 h\n1 g 2214 1407 N 0 38 49 0 0
      -38 h\n1 g 2165 1407 N 0 38 49 0 0 -38 h\n1 g 2117 1407 N 0 38 48 0 0
      -38 h\n1 g 2068 1407 N 0 38 49 0 0 -38 h\n1 g 2020 1407 N 0 38 48 0 0
      -38 h\n1 g 1971 1407 N 0 38 49 0 0 -38 h\n1 g 1922 1407 N 0 38 49 0 0
      -38 h\n1 g 1874 1407 N 0 38 48 0 0 -38 h\n1 g 1825 1407 N 0 38 49 0 0
      -38 h\n1 g 1777 1407 N 0 38 48 0 0 -38 h\n1 g 1728 1407 N 0 38 49 0 0
      -38 h\n1 g 1679 1407 N 0 38 49 0 0 -38 h\n1 g 1631 1407 N 0 38 48 0 0
      -38 h\n1 g 1582 1407 N 0 38 49 0 0 -38 h\n1 g 1534 1407 N 0 38 48 0 0
      -38 h\n1 g 1485 1407 N 0 38 49 0 0 -38 h\n1 g 1436 1407 N 0 38 49 0 0
      -38 h\n1 g 1388 1407 N 0 38 48 0 0 -38 h\n1 g 1339 1407 N 0 38 49 0 0
      -38 h\n1 g 1290 1407 N 0 38 49 0 0 -38 h\n1 g 1242 1407 N 0 38 48 0 0
      -38 h\n1 g 1193 1407 N 0 38 49 0 0 -38 h\n1 g 5957 1369 N 0 39 49 0 0
      -39 h\n1 g 5909 1369 N 0 39 48 0 0 -39 h\n1 g 5860 1369 N 0 39 49 0 0
      -39 h\n1 g 5811 1369 N 0 39 49 0 0 -39 h\n1 g 5763 1369 N 0 39 48 0 0
      -39 h\n1 g 5714 1369 N 0 39 49 0 0 -39 h\n1 g 5665 1369 N 0 39 49 0 0
      -39 h\n1 g 5617 1369 N 0 39 48 0 0 -39 h\n1 g 5568 1369 N 0 39 49 0 0
      -39 h\n1 g 5520 1369 N 0 39 48 0 0 -39 h\n1 g 5471 1369 N 0 39 49 0 0
      -39 h\n1 g 5422 1369 N 0 39 49 0 0 -39 h\n1 g 5374 1369 N 0 39 48 0 0
      -39 h\n1 g 5325 1369 N 0 39 49 0 0 -39 h\n1 g 5277 1369 N 0 39 48 0 0
      -39 h\n1 g 5228 1369 N 0 39 49 0 0 -39 h\n1 g 5179 1369 N 0 39 49 0 0
      -39 h\n1 g 5131 1369 N 0 39 48 0 0 -39 h\n1 g 5082 1369 N 0 39 49 0 0
      -39 h\n1 g 5034 1369 N 0 39 48 0 0 -39 h\n1 g 4985 1369 N 0 39 49 0 0
      -39 h\n1 g 4936 1369 N 0 39 49 0 0 -39 h\n1 g 4888 1369 N 0 39 48 0 0
      -39 h\n1 g 4839 1369 N 0 39 49 0 0 -39 h\n1 g 4790 1369 N 0 39 49 0 0
      -39 h\n1 g 4742 1369 N 0 39 48 0 0 -39 h\n1 g 4693 1369 N 0 39 49 0 0
      -39 h\n1 g 4645 1369 N 0 39 48 0 0 -39 h\n1 g 4596 1369 N 0 39 49 0 0
      -39 h\n1 g 4547 1369 N 0 39 49 0 0 -39 h\n1 g 4499 1369 N 0 39 48 0 0
      -39 h\n1 g 4450 1369 N 0 39 49 0 0 -39 h\n1 g 4402 1369 N 0 39 48 0 0
      -39 h\n1 g 4353 1369 N 0 39 49 0 0 -39 h\n1 g 4304 1369 N 0 39 49 0 0
      -39 h\n1 g 4256 1369 N 0 39 48 0 0 -39 h\n.9 g 4207 1369 N 0 39 49 0 0
      -39 h\n.8 g 4159 1369 N 0 39 48 0 0 -39 h\n.8 g 4110 1369 N 0 39 49 0 0
      -39 h\n.8 g 4061 1369 N 0 39 49 0 0 -39 h\n.8 g 4013 1369 N 0 39 48 0 0
      -39 h\n.8 g 3964 1369 N 0 39 49 0 0 -39 h\n.8 g 3915 1369 N 0 39 49 0 0
      -39 h\n.8 g 3867 1369 N 0 39 48 0 0 -39 h\n.8 g 3818 1369 N 0 39 49 0 0
      -39 h\n.8 g 3770 1369 N 0 39 48 0 0 -39 h\n.8 g 3721 1369 N 0 39 49 0 0
      -39 h\n.8 g 3672 1369 N 0 39 49 0 0 -39 h\n.8 g 3624 1369 N 0 39 48 0 0
      -39 h\n.8 g 3575 1369 N 0 39 49 0 0 -39 h\n.8 g 3527 1369 N 0 39 48 0 0
      -39 h\n.8 g 3478 1369 N 0 39 49 0 0 -39 h\n.8 g 3429 1369 N 0 39 49 0 0
      -39 h\n.8 g 3381 1369 N 0 39 48 0 0 -39 h\n.8 g 3332 1369 N 0 39 49 0 0
      -39 h\n.8 g 3284 1369 N 0 39 48 0 0 -39 h\n.8 g 3235 1369 N 0 39 49 0 0
      -39 h\n.8 g 3186 1369 N 0 39 49 0 0 -39 h\n.8 g 3138 1369 N 0 39 48 0 0
      -39 h\n.8 g 3089 1369 N 0 39 49 0 0 -39 h\n.8 g 3040 1369 N 0 39 49 0 0
      -39 h\n.8 g 2992 1369 N 0 39 48 0 0 -39 h\n.9 g 2943 1369 N 0 39 49 0 0
      -39 h\n1 g 2895 1369 N 0 39 48 0 0 -39 h\n1 g 2846 1369 N 0 39 49 0 0
      -39 h\n1 g 2797 1369 N 0 39 49 0 0 -39 h\n1 g 2749 1369 N 0 39 48 0 0
      -39 h\n1 g 2700 1369 N 0 39 49 0 0 -39 h\n1 g 2652 1369 N 0 39 48 0 0
      -39 h\n1 g 2603 1369 N 0 39 49 0 0 -39 h\n1 g 2554 1369 N 0 39 49 0 0
      -39 h\n1 g 2506 1369 N 0 39 48 0 0 -39 h\n1 g 2457 1369 N 0 39 49 0 0
      -39 h\n1 g 2409 1369 N 0 39 48 0 0 -39 h\n1 g 2360 1369 N 0 39 49 0 0
      -39 h\n1 g 2311 1369 N 0 39 49 0 0 -39 h\n1 g 2263 1369 N 0 39 48 0 0
      -39 h\n1 g 2214 1369 N 0 39 49 0 0 -39 h\n1 g 2165 1369 N 0 39 49 0 0
      -39 h\n1 g 2117 1369 N 0 39 48 0 0 -39 h\n1 g 2068 1369 N 0 39 49 0 0
      -39 h\n1 g 2020 1369 N 0 39 48 0 0 -39 h\n1 g 1971 1369 N 0 39 49 0 0
      -39 h\n1 g 1922 1369 N 0 39 49 0 0 -39 h\n1 g 1874 1369 N 0 39 48 0 0
      -39 h\n1 g 1825 1369 N 0 39 49 0 0 -39 h\n1 g 1777 1369 N 0 39 48 0 0
      -39 h\n1 g 1728 1369 N 0 39 49 0 0 -39 h\n1 g 1679 1369 N 0 39 49 0 0
      -39 h\n1 g 1631 1369 N 0 39 48 0 0 -39 h\n1 g 1582 1369 N 0 39 49 0 0
      -39 h\n1 g 1534 1369 N 0 39 48 0 0 -39 h\n1 g 1485 1369 N 0 39 49 0 0
      -39 h\n1 g 1436 1369 N 0 39 49 0 0 -39 h\n1 g 1388 1369 N 0 39 48 0 0
      -39 h\n1 g 1339 1369 N 0 39 49 0 0 -39 h\n1 g 1290 1369 N 0 39 49 0 0
      -39 h\n1 g 1242 1369 N 0 39 48 0 0 -39 h\n1 g 1193 1369 N 0 39 49 0 0
      -39 h\n1 g 5957 1330 N 0 39 49 0 0 -39 h\n1 g 5909 1330 N 0 39 48 0 0
      -39 h\n1 g 5860 1330 N 0 39 49 0 0 -39 h\n1 g 5811 1330 N 0 39 49 0 0
      -39 h\n1 g 5763 1330 N 0 39 48 0 0 -39 h\n1 g 5714 1330 N 0 39 49 0 0
      -39 h\n1 g 5665 1330 N 0 39 49 0 0 -39 h\n1 g 5617 1330 N 0 39 48 0 0
      -39 h\n1 g 5568 1330 N 0 39 49 0 0 -39 h\n1 g 5520 1330 N 0 39 48 0 0
      -39 h\n1 g 5471 1330 N 0 39 49 0 0 -39 h\n1 g 5422 1330 N 0 39 49 0 0
      -39 h\n1 g 5374 1330 N 0 39 48 0 0 -39 h\n1 g 5325 1330 N 0 39 49 0 0
      -39 h\n1 g 5277 1330 N 0 39 48 0 0 -39 h\n1 g 5228 1330 N 0 39 49 0 0
      -39 h\n1 g 5179 1330 N 0 39 49 0 0 -39 h\n1 g 5131 1330 N 0 39 48 0 0
      -39 h\n1 g 5082 1330 N 0 39 49 0 0 -39 h\n1 g 5034 1330 N 0 39 48 0 0
      -39 h\n1 g 4985 1330 N 0 39 49 0 0 -39 h\n1 g 4936 1330 N 0 39 49 0 0
      -39 h\n1 g 4888 1330 N 0 39 48 0 0 -39 h\n1 g 4839 1330 N 0 39 49 0 0
      -39 h\n1 g 4790 1330 N 0 39 49 0 0 -39 h\n1 g 4742 1330 N 0 39 48 0 0
      -39 h\n1 g 4693 1330 N 0 39 49 0 0 -39 h\n1 g 4645 1330 N 0 39 48 0 0
      -39 h\n1 g 4596 1330 N 0 39 49 0 0 -39 h\n1 g 4547 1330 N 0 39 49 0 0
      -39 h\n1 g 4499 1330 N 0 39 48 0 0 -39 h\n1 g 4450 1330 N 0 39 49 0 0
      -39 h\n1 g 4402 1330 N 0 39 48 0 0 -39 h\n1 g 4353 1330 N 0 39 49 0 0
      -39 h\n1 g 4304 1330 N 0 39 49 0 0 -39 h\n1 g 4256 1330 N 0 39 48 0 0
      -39 h\n.9 g 4207 1330 N 0 39 49 0 0 -39 h\n.8 g 4159 1330 N 0 39 48 0 0
      -39 h\n.8 g 4110 1330 N 0 39 49 0 0 -39 h\n.8 g 4061 1330 N 0 39 49 0 0
      -39 h\n.8 g 4013 1330 N 0 39 48 0 0 -39 h\n.8 g 3964 1330 N 0 39 49 0 0
      -39 h\n.8 g 3915 1330 N 0 39 49 0 0 -39 h\n.8 g 3867 1330 N 0 39 48 0 0
      -39 h\n.8 g 3818 1330 N 0 39 49 0 0 -39 h\n.8 g 3770 1330 N 0 39 48 0 0
      -39 h\n.8 g 3721 1330 N 0 39 49 0 0 -39 h\n.8 g 3672 1330 N 0 39 49 0 0
      -39 h\n.8 g 3624 1330 N 0 39 48 0 0 -39 h\n.8 g 3575 1330 N 0 39 49 0 0
      -39 h\n.8 g 3527 1330 N 0 39 48 0 0 -39 h\n.8 g 3478 1330 N 0 39 49 0 0
      -39 h\n.8 g 3429 1330 N 0 39 49 0 0 -39 h\n.8 g 3381 1330 N 0 39 48 0 0
      -39 h\n.8 g 3332 1330 N 0 39 49 0 0 -39 h\n.8 g 3284 1330 N 0 39 48 0 0
      -39 h\n.8 g 3235 1330 N 0 39 49 0 0 -39 h\n.8 g 3186 1330 N 0 39 49 0 0
      -39 h\n.8 g 3138 1330 N 0 39 48 0 0 -39 h\n.8 g 3089 1330 N 0 39 49 0 0
      -39 h\n.8 g 3040 1330 N 0 39 49 0 0 -39 h\n.8 g 2992 1330 N 0 39 48 0 0
      -39 h\n.9 g 2943 1330 N 0 39 49 0 0 -39 h\n1 g 2895 1330 N 0 39 48 0 0
      -39 h\n1 g 2846 1330 N 0 39 49 0 0 -39 h\n1 g 2797 1330 N 0 39 49 0 0
      -39 h\n1 g 2749 1330 N 0 39 48 0 0 -39 h\n1 g 2700 1330 N 0 39 49 0 0
      -39 h\n1 g 2652 1330 N 0 39 48 0 0 -39 h\n1 g 2603 1330 N 0 39 49 0 0
      -39 h\n1 g 2554 1330 N 0 39 49 0 0 -39 h\n1 g 2506 1330 N 0 39 48 0 0
      -39 h\n1 g 2457 1330 N 0 39 49 0 0 -39 h\n1 g 2409 1330 N 0 39 48 0 0
      -39 h\n1 g 2360 1330 N 0 39 49 0 0 -39 h\n1 g 2311 1330 N 0 39 49 0 0
      -39 h\n1 g 2263 1330 N 0 39 48 0 0 -39 h\n1 g 2214 1330 N 0 39 49 0 0
      -39 h\n1 g 2165 1330 N 0 39 49 0 0 -39 h\n1 g 2117 1330 N 0 39 48 0 0
      -39 h\n1 g 2068 1330 N 0 39 49 0 0 -39 h\n1 g 2020 1330 N 0 39 48 0 0
      -39 h\n1 g 1971 1330 N 0 39 49 0 0 -39 h\n1 g 1922 1330 N 0 39 49 0 0
      -39 h\n1 g 1874 1330 N 0 39 48 0 0 -39 h\n1 g 1825 1330 N 0 39 49 0 0
      -39 h\n1 g 1777 1330 N 0 39 48 0 0 -39 h\n1 g 1728 1330 N 0 39 49 0 0
      -39 h\n1 g 1679 1330 N 0 39 49 0 0 -39 h\n1 g 1631 1330 N 0 39 48 0 0
      -39 h\n1 g 1582 1330 N 0 39 49 0 0 -39 h\n1 g 1534 1330 N 0 39 48 0 0
      -39 h\n1 g 1485 1330 N 0 39 49 0 0 -39 h\n1 g 1436 1330 N 0 39 49 0 0
      -39 h\n1 g 1388 1330 N 0 39 48 0 0 -39 h\n1 g 1339 1330 N 0 39 49 0 0
      -39 h\n1 g 1290 1330 N 0 39 49 0 0 -39 h\n1 g 1242 1330 N 0 39 48 0 0
      -39 h\n1 g 1193 1330 N 0 39 49 0 0 -39 h\n1 g 5957 1291 N 0 39 49 0 0
      -39 h\n1 g 5909 1291 N 0 39 48 0 0 -39 h\n1 g 5860 1291 N 0 39 49 0 0
      -39 h\n1 g 5811 1291 N 0 39 49 0 0 -39 h\n1 g 5763 1291 N 0 39 48 0 0
      -39 h\n1 g 5714 1291 N 0 39 49 0 0 -39 h\n1 g 5665 1291 N 0 39 49 0 0
      -39 h\n1 g 5617 1291 N 0 39 48 0 0 -39 h\n1 g 5568 1291 N 0 39 49 0 0
      -39 h\n1 g 5520 1291 N 0 39 48 0 0 -39 h\n1 g 5471 1291 N 0 39 49 0 0
      -39 h\n1 g 5422 1291 N 0 39 49 0 0 -39 h\n1 g 5374 1291 N 0 39 48 0 0
      -39 h\n1 g 5325 1291 N 0 39 49 0 0 -39 h\n1 g 5277 1291 N 0 39 48 0 0
      -39 h\n1 g 5228 1291 N 0 39 49 0 0 -39 h\n1 g 5179 1291 N 0 39 49 0 0
      -39 h\n1 g 5131 1291 N 0 39 48 0 0 -39 h\n1 g 5082 1291 N 0 39 49 0 0
      -39 h\n1 g 5034 1291 N 0 39 48 0 0 -39 h\n1 g 4985 1291 N 0 39 49 0 0
      -39 h\n1 g 4936 1291 N 0 39 49 0 0 -39 h\n1 g 4888 1291 N 0 39 48 0 0
      -39 h\n1 g 4839 1291 N 0 39 49 0 0 -39 h\n1 g 4790 1291 N 0 39 49 0 0
      -39 h\n1 g 4742 1291 N 0 39 48 0 0 -39 h\n1 g 4693 1291 N 0 39 49 0 0
      -39 h\n1 g 4645 1291 N 0 39 48 0 0 -39 h\n1 g 4596 1291 N 0 39 49 0 0
      -39 h\n1 g 4547 1291 N 0 39 49 0 0 -39 h\n1 g 4499 1291 N 0 39 48 0 0
      -39 h\n1 g 4450 1291 N 0 39 49 0 0 -39 h\n1 g 4402 1291 N 0 39 48 0 0
      -39 h\n1 g 4353 1291 N 0 39 49 0 0 -39 h\n1 g 4304 1291 N 0 39 49 0 0
      -39 h\n1 g 4256 1291 N 0 39 48 0 0 -39 h\n.95 g 4207 1291 N 0 39 49 0 0
      -39 h\n.85 g 4159 1291 N 0 39 48 0 0 -39 h\n.8 g 4110 1291 N 0 39 49 0
      0 -39 h\n.8 g 4061 1291 N 0 39 49 0 0 -39 h\n.8 g 4013 1291 N 0 39 48 0
      0 -39 h\n.8 g 3964 1291 N 0 39 49 0 0 -39 h\n.8 g 3915 1291 N 0 39 49 0
      0 -39 h\n.8 g 3867 1291 N 0 39 48 0 0 -39 h\n.8 g 3818 1291 N 0 39 49 0
      0 -39 h\n.8 g 3770 1291 N 0 39 48 0 0 -39 h\n.8 g 3721 1291 N 0 39 49 0
      0 -39 h\n.8 g 3672 1291 N 0 39 49 0 0 -39 h\n.8 g 3624 1291 N 0 39 48 0
      0 -39 h\n.8 g 3575 1291 N 0 39 49 0 0 -39 h\n.8 g 3527 1291 N 0 39 48 0
      0 -39 h\n.8 g 3478 1291 N 0 39 49 0 0 -39 h\n.8 g 3429 1291 N 0 39 49 0
      0 -39 h\n.8 g 3381 1291 N 0 39 48 0 0 -39 h\n.8 g 3332 1291 N 0 39 49 0
      0 -39 h\n.8 g 3284 1291 N 0 39 48 0 0 -39 h\n.8 g 3235 1291 N 0 39 49 0
      0 -39 h\n.8 g 3186 1291 N 0 39 49 0 0 -39 h\n.8 g 3138 1291 N 0 39 48 0
      0 -39 h\n.8 g 3089 1291 N 0 39 49 0 0 -39 h\n.8 g 3040 1291 N 0 39 49 0
      0 -39 h\n.85 g 2992 1291 N 0 39 48 0 0 -39 h\n.95 g 2943 1291 N 0 39 49
      0 0 -39 h\n1 g 2895 1291 N 0 39 48 0 0 -39 h\n1 g 2846 1291 N 0 39 49 0
      0 -39 h\n1 g 2797 1291 N 0 39 49 0 0 -39 h\n1 g 2749 1291 N 0 39 48 0 0
      -39 h\n1 g 2700 1291 N 0 39 49 0 0 -39 h\n1 g 2652 1291 N 0 39 48 0 0
      -39 h\n1 g 2603 1291 N 0 39 49 0 0 -39 h\n1 g 2554 1291 N 0 39 49 0 0
      -39 h\n1 g 2506 1291 N 0 39 48 0 0 -39 h\n1 g 2457 1291 N 0 39 49 0 0
      -39 h\n1 g 2409 1291 N 0 39 48 0 0 -39 h\n1 g 2360 1291 N 0 39 49 0 0
      -39 h\n1 g 2311 1291 N 0 39 49 0 0 -39 h\n1 g 2263 1291 N 0 39 48 0 0
      -39 h\n1 g 2214 1291 N 0 39 49 0 0 -39 h\n1 g 2165 1291 N 0 39 49 0 0
      -39 h\n1 g 2117 1291 N 0 39 48 0 0 -39 h\n1 g 2068 1291 N 0 39 49 0 0
      -39 h\n1 g 2020 1291 N 0 39 48 0 0 -39 h\n1 g 1971 1291 N 0 39 49 0 0
      -39 h\n1 g 1922 1291 N 0 39 49 0 0 -39 h\n1 g 1874 1291 N 0 39 48 0 0
      -39 h\n1 g 1825 1291 N 0 39 49 0 0 -39 h\n1 g 1777 1291 N 0 39 48 0 0
      -39 h\n1 g 1728 1291 N 0 39 49 0 0 -39 h\n1 g 1679 1291 N 0 39 49 0 0
      -39 h\n1 g 1631 1291 N 0 39 48 0 0 -39 h\n1 g 1582 1291 N 0 39 49 0 0
      -39 h\n1 g 1534 1291 N 0 39 48 0 0 -39 h\n1 g 1485 1291 N 0 39 49 0 0
      -39 h\n1 g 1436 1291 N 0 39 49 0 0 -39 h\n1 g 1388 1291 N 0 39 48 0 0
      -39 h\n1 g 1339 1291 N 0 39 49 0 0 -39 h\n1 g 1290 1291 N 0 39 49 0 0
      -39 h\n1 g 1242 1291 N 0 39 48 0 0 -39 h\n1 g 1193 1291 N 0 39 49 0 0
      -39 h\n1 g 5957 1252 N 0 38 49 0 0 -38 h\n1 g 5909 1252 N 0 38 48 0 0
      -38 h\n1 g 5860 1252 N 0 38 49 0 0 -38 h\n1 g 5811 1252 N 0 38 49 0 0
      -38 h\n1 g 5763 1252 N 0 38 48 0 0 -38 h\n1 g 5714 1252 N 0 38 49 0 0
      -38 h\n1 g 5665 1252 N 0 38 49 0 0 -38 h\n1 g 5617 1252 N 0 38 48 0 0
      -38 h\n1 g 5568 1252 N 0 38 49 0 0 -38 h\n1 g 5520 1252 N 0 38 48 0 0
      -38 h\n1 g 5471 1252 N 0 38 49 0 0 -38 h\n1 g 5422 1252 N 0 38 49 0 0
      -38 h\n1 g 5374 1252 N 0 38 48 0 0 -38 h\n1 g 5325 1252 N 0 38 49 0 0
      -38 h\n1 g 5277 1252 N 0 38 48 0 0 -38 h\n1 g 5228 1252 N 0 38 49 0 0
      -38 h\n1 g 5179 1252 N 0 38 49 0 0 -38 h\n1 g 5131 1252 N 0 38 48 0 0
      -38 h\n1 g 5082 1252 N 0 38 49 0 0 -38 h\n1 g 5034 1252 N 0 38 48 0 0
      -38 h\n1 g 4985 1252 N 0 38 49 0 0 -38 h\n1 g 4936 1252 N 0 38 49 0 0
      -38 h\n1 g 4888 1252 N 0 38 48 0 0 -38 h\n1 g 4839 1252 N 0 38 49 0 0
      -38 h\n1 g 4790 1252 N 0 38 49 0 0 -38 h\n1 g 4742 1252 N 0 38 48 0 0
      -38 h\n1 g 4693 1252 N 0 38 49 0 0 -38 h\n1 g 4645 1252 N 0 38 48 0 0
      -38 h\n1 g 4596 1252 N 0 38 49 0 0 -38 h\n1 g 4547 1252 N 0 38 49 0 0
      -38 h\n1 g 4499 1252 N 0 38 48 0 0 -38 h\n1 g 4450 1252 N 0 38 49 0 0
      -38 h\n1 g 4402 1252 N 0 38 48 0 0 -38 h\n1 g 4353 1252 N 0 38 49 0 0
      -38 h\n1 g 4304 1252 N 0 38 49 0 0 -38 h\n1 g 4256 1252 N 0 38 48 0 0
      -38 h\n1 g 4207 1252 N 0 38 49 0 0 -38 h\n.9 g 4159 1252 N 0 38 48 0 0
      -38 h\n.8 g 4110 1252 N 0 38 49 0 0 -38 h\n.8 g 4061 1252 N 0 38 49 0 0
      -38 h\n.8 g 4013 1252 N 0 38 48 0 0 -38 h\n.8 g 3964 1252 N 0 38 49 0 0
      -38 h\n.8 g 3915 1252 N 0 38 49 0 0 -38 h\n.8 g 3867 1252 N 0 38 48 0 0
      -38 h\n.8 g 3818 1252 N 0 38 49 0 0 -38 h\n.8 g 3770 1252 N 0 38 48 0 0
      -38 h\n.8 g 3721 1252 N 0 38 49 0 0 -38 h\n.8 g 3672 1252 N 0 38 49 0 0
      -38 h\n.8 g 3624 1252 N 0 38 48 0 0 -38 h\n.8 g 3575 1252 N 0 38 49 0 0
      -38 h\n.8 g 3527 1252 N 0 38 48 0 0 -38 h\n.8 g 3478 1252 N 0 38 49 0 0
      -38 h\n.8 g 3429 1252 N 0 38 49 0 0 -38 h\n.8 g 3381 1252 N 0 38 48 0 0
      -38 h\n.8 g 3332 1252 N 0 38 49 0 0 -38 h\n.8 g 3284 1252 N 0 38 48 0 0
      -38 h\n.8 g 3235 1252 N 0 38 49 0 0 -38 h\n.8 g 3186 1252 N 0 38 49 0 0
      -38 h\n.8 g 3138 1252 N 0 38 48 0 0 -38 h\n.8 g 3089 1252 N 0 38 49 0 0
      -38 h\n.8 g 3040 1252 N 0 38 49 0 0 -38 h\n.9 g 2992 1252 N 0 38 48 0 0
      -38 h\n1 g 2943 1252 N 0 38 49 0 0 -38 h\n1 g 2895 1252 N 0 38 48 0 0
      -38 h\n1 g 2846 1252 N 0 38 49 0 0 -38 h\n1 g 2797 1252 N 0 38 49 0 0
      -38 h\n1 g 2749 1252 N 0 38 48 0 0 -38 h\n1 g 2700 1252 N 0 38 49 0 0
      -38 h\n1 g 2652 1252 N 0 38 48 0 0 -38 h\n1 g 2603 1252 N 0 38 49 0 0
      -38 h\n1 g 2554 1252 N 0 38 49 0 0 -38 h\n1 g 2506 1252 N 0 38 48 0 0
      -38 h\n1 g 2457 1252 N 0 38 49 0 0 -38 h\n1 g 2409 1252 N 0 38 48 0 0
      -38 h\n1 g 2360 1252 N 0 38 49 0 0 -38 h\n1 g 2311 1252 N 0 38 49 0 0
      -38 h\n1 g 2263 1252 N 0 38 48 0 0 -38 h\n1 g 2214 1252 N 0 38 49 0 0
      -38 h\n1 g 2165 1252 N 0 38 49 0 0 -38 h\n1 g 2117 1252 N 0 38 48 0 0
      -38 h\n1 g 2068 1252 N 0 38 49 0 0 -38 h\n1 g 2020 1252 N 0 38 48 0 0
      -38 h\n1 g 1971 1252 N 0 38 49 0 0 -38 h\n1 g 1922 1252 N 0 38 49 0 0
      -38 h\n1 g 1874 1252 N 0 38 48 0 0 -38 h\n1 g 1825 1252 N 0 38 49 0 0
      -38 h\n1 g 1777 1252 N 0 38 48 0 0 -38 h\n1 g 1728 1252 N 0 38 49 0 0
      -38 h\n1 g 1679 1252 N 0 38 49 0 0 -38 h\n1 g 1631 1252 N 0 38 48 0 0
      -38 h\n1 g 1582 1252 N 0 38 49 0 0 -38 h\n1 g 1534 1252 N 0 38 48 0 0
      -38 h\n1 g 1485 1252 N 0 38 49 0 0 -38 h\n1 g 1436 1252 N 0 38 49 0 0
      -38 h\n1 g 1388 1252 N 0 38 48 0 0 -38 h\n1 g 1339 1252 N 0 38 49 0 0
      -38 h\n1 g 1290 1252 N 0 38 49 0 0 -38 h\n1 g 1242 1252 N 0 38 48 0 0
      -38 h\n1 g 1193 1252 N 0 38 49 0 0 -38 h\n1 g 5957 1214 N 0 39 49 0 0
      -39 h\n1 g 5909 1214 N 0 39 48 0 0 -39 h\n1 g 5860 1214 N 0 39 49 0 0
      -39 h\n1 g 5811 1214 N 0 39 49 0 0 -39 h\n1 g 5763 1214 N 0 39 48 0 0
      -39 h\n1 g 5714 1214 N 0 39 49 0 0 -39 h\n1 g 5665 1214 N 0 39 49 0 0
      -39 h\n1 g 5617 1214 N 0 39 48 0 0 -39 h\n1 g 5568 1214 N 0 39 49 0 0
      -39 h\n1 g 5520 1214 N 0 39 48 0 0 -39 h\n1 g 5471 1214 N 0 39 49 0 0
      -39 h\n1 g 5422 1214 N 0 39 49 0 0 -39 h\n1 g 5374 1214 N 0 39 48 0 0
      -39 h\n1 g 5325 1214 N 0 39 49 0 0 -39 h\n1 g 5277 1214 N 0 39 48 0 0
      -39 h\n1 g 5228 1214 N 0 39 49 0 0 -39 h\n1 g 5179 1214 N 0 39 49 0 0
      -39 h\n1 g 5131 1214 N 0 39 48 0 0 -39 h\n1 g 5082 1214 N 0 39 49 0 0
      -39 h\n1 g 5034 1214 N 0 39 48 0 0 -39 h\n1 g 4985 1214 N 0 39 49 0 0
      -39 h\n1 g 4936 1214 N 0 39 49 0 0 -39 h\n1 g 4888 1214 N 0 39 48 0 0
      -39 h\n1 g 4839 1214 N 0 39 49 0 0 -39 h\n1 g 4790 1214 N 0 39 49 0 0
      -39 h\n1 g 4742 1214 N 0 39 48 0 0 -39 h\n1 g 4693 1214 N 0 39 49 0 0
      -39 h\n1 g 4645 1214 N 0 39 48 0 0 -39 h\n1 g 4596 1214 N 0 39 49 0 0
      -39 h\n1 g 4547 1214 N 0 39 49 0 0 -39 h\n1 g 4499 1214 N 0 39 48 0 0
      -39 h\n1 g 4450 1214 N 0 39 49 0 0 -39 h\n1 g 4402 1214 N 0 39 48 0 0
      -39 h\n1 g 4353 1214 N 0 39 49 0 0 -39 h\n1 g 4304 1214 N 0 39 49 0 0
      -39 h\n1 g 4256 1214 N 0 39 48 0 0 -39 h\n1 g 4207 1214 N 0 39 49 0 0
      -39 h\n.95 g 4159 1214 N 0 39 48 0 0 -39 h\n.85 g 4110 1214 N 0 39 49 0
      0 -39 h\n.8 g 4061 1214 N 0 39 49 0 0 -39 h\n.8 g 4013 1214 N 0 39 48 0
      0 -39 h\n.8 g 3964 1214 N 0 39 49 0 0 -39 h\n.8 g 3915 1214 N 0 39 49 0
      0 -39 h\n.8 g 3867 1214 N 0 39 48 0 0 -39 h\n.8 g 3818 1214 N 0 39 49 0
      0 -39 h\n.8 g 3770 1214 N 0 39 48 0 0 -39 h\n.8 g 3721 1214 N 0 39 49 0
      0 -39 h\n.8 g 3672 1214 N 0 39 49 0 0 -39 h\n.8 g 3624 1214 N 0 39 48 0
      0 -39 h\n.8 g 3575 1214 N 0 39 49 0 0 -39 h\n.8 g 3527 1214 N 0 39 48 0
      0 -39 h\n.8 g 3478 1214 N 0 39 49 0 0 -39 h\n.8 g 3429 1214 N 0 39 49 0
      0 -39 h\n.8 g 3381 1214 N 0 39 48 0 0 -39 h\n.8 g 3332 1214 N 0 39 49 0
      0 -39 h\n.8 g 3284 1214 N 0 39 48 0 0 -39 h\n.8 g 3235 1214 N 0 39 49 0
      0 -39 h\n.8 g 3186 1214 N 0 39 49 0 0 -39 h\n.8 g 3138 1214 N 0 39 48 0
      0 -39 h\n.8 g 3089 1214 N 0 39 49 0 0 -39 h\n.85 g 3040 1214 N 0 39 49
      0 0 -39 h\n.95 g 2992 1214 N 0 39 48 0 0 -39 h\n1 g 2943 1214 N 0 39 49
      0 0 -39 h\n1 g 2895 1214 N 0 39 48 0 0 -39 h\n1 g 2846 1214 N 0 39 49 0
      0 -39 h\n1 g 2797 1214 N 0 39 49 0 0 -39 h\n1 g 2749 1214 N 0 39 48 0 0
      -39 h\n1 g 2700 1214 N 0 39 49 0 0 -39 h\n1 g 2652 1214 N 0 39 48 0 0
      -39 h\n1 g 2603 1214 N 0 39 49 0 0 -39 h\n1 g 2554 1214 N 0 39 49 0 0
      -39 h\n1 g 2506 1214 N 0 39 48 0 0 -39 h\n1 g 2457 1214 N 0 39 49 0 0
      -39 h\n1 g 2409 1214 N 0 39 48 0 0 -39 h\n1 g 2360 1214 N 0 39 49 0 0
      -39 h\n1 g 2311 1214 N 0 39 49 0 0 -39 h\n1 g 2263 1214 N 0 39 48 0 0
      -39 h\n1 g 2214 1214 N 0 39 49 0 0 -39 h\n1 g 2165 1214 N 0 39 49 0 0
      -39 h\n1 g 2117 1214 N 0 39 48 0 0 -39 h\n1 g 2068 1214 N 0 39 49 0 0
      -39 h\n1 g 2020 1214 N 0 39 48 0 0 -39 h\n1 g 1971 1214 N 0 39 49 0 0
      -39 h\n1 g 1922 1214 N 0 39 49 0 0 -39 h\n1 g 1874 1214 N 0 39 48 0 0
      -39 h\n1 g 1825 1214 N 0 39 49 0 0 -39 h\n1 g 1777 1214 N 0 39 48 0 0
      -39 h\n1 g 1728 1214 N 0 39 49 0 0 -39 h\n1 g 1679 1214 N 0 39 49 0 0
      -39 h\n1 g 1631 1214 N 0 39 48 0 0 -39 h\n1 g 1582 1214 N 0 39 49 0 0
      -39 h\n1 g 1534 1214 N 0 39 48 0 0 -39 h\n1 g 1485 1214 N 0 39 49 0 0
      -39 h\n1 g 1436 1214 N 0 39 49 0 0 -39 h\n1 g 1388 1214 N 0 39 48 0 0
      -39 h\n1 g 1339 1214 N 0 39 49 0 0 -39 h\n1 g 1290 1214 N 0 39 49 0 0
      -39 h\n1 g 1242 1214 N 0 39 48 0 0 -39 h\n1 g 1193 1214 N 0 39 49 0 0
      -39 h\n1 g 5957 1175 N 0 39 49 0 0 -39 h\n1 g 5909 1175 N 0 39 48 0 0
      -39 h\n1 g 5860 1175 N 0 39 49 0 0 -39 h\n1 g 5811 1175 N 0 39 49 0 0
      -39 h\n1 g 5763 1175 N 0 39 48 0 0 -39 h\n1 g 5714 1175 N 0 39 49 0 0
      -39 h\n1 g 5665 1175 N 0 39 49 0 0 -39 h\n1 g 5617 1175 N 0 39 48 0 0
      -39 h\n1 g 5568 1175 N 0 39 49 0 0 -39 h\n1 g 5520 1175 N 0 39 48 0 0
      -39 h\n1 g 5471 1175 N 0 39 49 0 0 -39 h\n1 g 5422 1175 N 0 39 49 0 0
      -39 h\n1 g 5374 1175 N 0 39 48 0 0 -39 h\n1 g 5325 1175 N 0 39 49 0 0
      -39 h\n1 g 5277 1175 N 0 39 48 0 0 -39 h\n1 g 5228 1175 N 0 39 49 0 0
      -39 h\n1 g 5179 1175 N 0 39 49 0 0 -39 h\n1 g 5131 1175 N 0 39 48 0 0
      -39 h\n1 g 5082 1175 N 0 39 49 0 0 -39 h\n1 g 5034 1175 N 0 39 48 0 0
      -39 h\n1 g 4985 1175 N 0 39 49 0 0 -39 h\n1 g 4936 1175 N 0 39 49 0 0
      -39 h\n1 g 4888 1175 N 0 39 48 0 0 -39 h\n1 g 4839 1175 N 0 39 49 0 0
      -39 h\n1 g 4790 1175 N 0 39 49 0 0 -39 h\n1 g 4742 1175 N 0 39 48 0 0
      -39 h\n1 g 4693 1175 N 0 39 49 0 0 -39 h\n1 g 4645 1175 N 0 39 48 0 0
      -39 h\n1 g 4596 1175 N 0 39 49 0 0 -39 h\n1 g 4547 1175 N 0 39 49 0 0
      -39 h\n1 g 4499 1175 N 0 39 48 0 0 -39 h\n1 g 4450 1175 N 0 39 49 0 0
      -39 h\n1 g 4402 1175 N 0 39 48 0 0 -39 h\n1 g 4353 1175 N 0 39 49 0 0
      -39 h\n1 g 4304 1175 N 0 39 49 0 0 -39 h\n1 g 4256 1175 N 0 39 48 0 0
      -39 h\n1 g 4207 1175 N 0 39 49 0 0 -39 h\n1 g 4159 1175 N 0 39 48 0 0
      -39 h\n.9 g 4110 1175 N 0 39 49 0 0 -39 h\n.8 g 4061 1175 N 0 39 49 0 0
      -39 h\n.8 g 4013 1175 N 0 39 48 0 0 -39 h\n.8 g 3964 1175 N 0 39 49 0 0
      -39 h\n.8 g 3915 1175 N 0 39 49 0 0 -39 h\n.8 g 3867 1175 N 0 39 48 0 0
      -39 h\n.8 g 3818 1175 N 0 39 49 0 0 -39 h\n.8 g 3770 1175 N 0 39 48 0 0
      -39 h\n.8 g 3721 1175 N 0 39 49 0 0 -39 h\n.8 g 3672 1175 N 0 39 49 0 0
      -39 h\n.8 g 3624 1175 N 0 39 48 0 0 -39 h\n.8 g 3575 1175 N 0 39 49 0 0
      -39 h\n.8 g 3527 1175 N 0 39 48 0 0 -39 h\n.8 g 3478 1175 N 0 39 49 0 0
      -39 h\n.8 g 3429 1175 N 0 39 49 0 0 -39 h\n.8 g 3381 1175 N 0 39 48 0 0
      -39 h\n.8 g 3332 1175 N 0 39 49 0 0 -39 h\n.8 g 3284 1175 N 0 39 48 0 0
      -39 h\n.8 g 3235 1175 N 0 39 49 0 0 -39 h\n.8 g 3186 1175 N 0 39 49 0 0
      -39 h\n.8 g 3138 1175 N 0 39 48 0 0 -39 h\n.8 g 3089 1175 N 0 39 49 0 0
      -39 h\n.9 g 3040 1175 N 0 39 49 0 0 -39 h\n1 g 2992 1175 N 0 39 48 0 0
      -39 h\n1 g 2943 1175 N 0 39 49 0 0 -39 h\n1 g 2895 1175 N 0 39 48 0 0
      -39 h\n1 g 2846 1175 N 0 39 49 0 0 -39 h\n1 g 2797 1175 N 0 39 49 0 0
      -39 h\n1 g 2749 1175 N 0 39 48 0 0 -39 h\n1 g 2700 1175 N 0 39 49 0 0
      -39 h\n1 g 2652 1175 N 0 39 48 0 0 -39 h\n1 g 2603 1175 N 0 39 49 0 0
      -39 h\n1 g 2554 1175 N 0 39 49 0 0 -39 h\n1 g 2506 1175 N 0 39 48 0 0
      -39 h\n1 g 2457 1175 N 0 39 49 0 0 -39 h\n1 g 2409 1175 N 0 39 48 0 0
      -39 h\n1 g 2360 1175 N 0 39 49 0 0 -39 h\n1 g 2311 1175 N 0 39 49 0 0
      -39 h\n1 g 2263 1175 N 0 39 48 0 0 -39 h\n1 g 2214 1175 N 0 39 49 0 0
      -39 h\n1 g 2165 1175 N 0 39 49 0 0 -39 h\n1 g 2117 1175 N 0 39 48 0 0
      -39 h\n1 g 2068 1175 N 0 39 49 0 0 -39 h\n1 g 2020 1175 N 0 39 48 0 0
      -39 h\n1 g 1971 1175 N 0 39 49 0 0 -39 h\n1 g 1922 1175 N 0 39 49 0 0
      -39 h\n1 g 1874 1175 N 0 39 48 0 0 -39 h\n1 g 1825 1175 N 0 39 49 0 0
      -39 h\n1 g 1777 1175 N 0 39 48 0 0 -39 h\n1 g 1728 1175 N 0 39 49 0 0
      -39 h\n1 g 1679 1175 N 0 39 49 0 0 -39 h\n1 g 1631 1175 N 0 39 48 0 0
      -39 h\n1 g 1582 1175 N 0 39 49 0 0 -39 h\n1 g 1534 1175 N 0 39 48 0 0
      -39 h\n1 g 1485 1175 N 0 39 49 0 0 -39 h\n1 g 1436 1175 N 0 39 49 0 0
      -39 h\n1 g 1388 1175 N 0 39 48 0 0 -39 h\n1 g 1339 1175 N 0 39 49 0 0
      -39 h\n1 g 1290 1175 N 0 39 49 0 0 -39 h\n1 g 1242 1175 N 0 39 48 0 0
      -39 h\n1 g 1193 1175 N 0 39 49 0 0 -39 h\n1 g 5957 1136 N 0 39 49 0 0
      -39 h\n1 g 5909 1136 N 0 39 48 0 0 -39 h\n1 g 5860 1136 N 0 39 49 0 0
      -39 h\n1 g 5811 1136 N 0 39 49 0 0 -39 h\n1 g 5763 1136 N 0 39 48 0 0
      -39 h\n1 g 5714 1136 N 0 39 49 0 0 -39 h\n1 g 5665 1136 N 0 39 49 0 0
      -39 h\n1 g 5617 1136 N 0 39 48 0 0 -39 h\n1 g 5568 1136 N 0 39 49 0 0
      -39 h\n1 g 5520 1136 N 0 39 48 0 0 -39 h\n1 g 5471 1136 N 0 39 49 0 0
      -39 h\n1 g 5422 1136 N 0 39 49 0 0 -39 h\n1 g 5374 1136 N 0 39 48 0 0
      -39 h\n1 g 5325 1136 N 0 39 49 0 0 -39 h\n1 g 5277 1136 N 0 39 48 0 0
      -39 h\n1 g 5228 1136 N 0 39 49 0 0 -39 h\n1 g 5179 1136 N 0 39 49 0 0
      -39 h\n1 g 5131 1136 N 0 39 48 0 0 -39 h\n1 g 5082 1136 N 0 39 49 0 0
      -39 h\n1 g 5034 1136 N 0 39 48 0 0 -39 h\n1 g 4985 1136 N 0 39 49 0 0
      -39 h\n1 g 4936 1136 N 0 39 49 0 0 -39 h\n1 g 4888 1136 N 0 39 48 0 0
      -39 h\n1 g 4839 1136 N 0 39 49 0 0 -39 h\n1 g 4790 1136 N 0 39 49 0 0
      -39 h\n1 g 4742 1136 N 0 39 48 0 0 -39 h\n1 g 4693 1136 N 0 39 49 0 0
      -39 h\n1 g 4645 1136 N 0 39 48 0 0 -39 h\n1 g 4596 1136 N 0 39 49 0 0
      -39 h\n1 g 4547 1136 N 0 39 49 0 0 -39 h\n1 g 4499 1136 N 0 39 48 0 0
      -39 h\n1 g 4450 1136 N 0 39 49 0 0 -39 h\n1 g 4402 1136 N 0 39 48 0 0
      -39 h\n1 g 4353 1136 N 0 39 49 0 0 -39 h\n1 g 4304 1136 N 0 39 49 0 0
      -39 h\n1 g 4256 1136 N 0 39 48 0 0 -39 h\n1 g 4207 1136 N 0 39 49 0 0
      -39 h\n1 g 4159 1136 N 0 39 48 0 0 -39 h\n.95 g 4110 1136 N 0 39 49 0 0
      -39 h\n.85 g 4061 1136 N 0 39 49 0 0 -39 h\n.8 g 4013 1136 N 0 39 48 0
      0 -39 h\n.8 g 3964 1136 N 0 39 49 0 0 -39 h\n.8 g 3915 1136 N 0 39 49 0
      0 -39 h\n.8 g 3867 1136 N 0 39 48 0 0 -39 h\n.8 g 3818 1136 N 0 39 49 0
      0 -39 h\n.8 g 3770 1136 N 0 39 48 0 0 -39 h\n.8 g 3721 1136 N 0 39 49 0
      0 -39 h\n.8 g 3672 1136 N 0 39 49 0 0 -39 h\n.8 g 3624 1136 N 0 39 48 0
      0 -39 h\n.8 g 3575 1136 N 0 39 49 0 0 -39 h\n.8 g 3527 1136 N 0 39 48 0
      0 -39 h\n.8 g 3478 1136 N 0 39 49 0 0 -39 h\n.8 g 3429 1136 N 0 39 49 0
      0 -39 h\n.8 g 3381 1136 N 0 39 48 0 0 -39 h\n.8 g 3332 1136 N 0 39 49 0
      0 -39 h\n.8 g 3284 1136 N 0 39 48 0 0 -39 h\n.8 g 3235 1136 N 0 39 49 0
      0 -39 h\n.8 g 3186 1136 N 0 39 49 0 0 -39 h\n.8 g 3138 1136 N 0 39 48 0
      0 -39 h\n.85 g 3089 1136 N 0 39 49 0 0 -39 h\n.95 g 3040 1136 N 0 39 49
      0 0 -39 h\n1 g 2992 1136 N 0 39 48 0 0 -39 h\n1 g 2943 1136 N 0 39 49 0
      0 -39 h\n1 g 2895 1136 N 0 39 48 0 0 -39 h\n1 g 2846 1136 N 0 39 49 0 0
      -39 h\n1 g 2797 1136 N 0 39 49 0 0 -39 h\n1 g 2749 1136 N 0 39 48 0 0
      -39 h\n1 g 2700 1136 N 0 39 49 0 0 -39 h\n1 g 2652 1136 N 0 39 48 0 0
      -39 h\n1 g 2603 1136 N 0 39 49 0 0 -39 h\n1 g 2554 1136 N 0 39 49 0 0
      -39 h\n1 g 2506 1136 N 0 39 48 0 0 -39 h\n1 g 2457 1136 N 0 39 49 0 0
      -39 h\n1 g 2409 1136 N 0 39 48 0 0 -39 h\n1 g 2360 1136 N 0 39 49 0 0
      -39 h\n1 g 2311 1136 N 0 39 49 0 0 -39 h\n1 g 2263 1136 N 0 39 48 0 0
      -39 h\n1 g 2214 1136 N 0 39 49 0 0 -39 h\n1 g 2165 1136 N 0 39 49 0 0
      -39 h\n1 g 2117 1136 N 0 39 48 0 0 -39 h\n1 g 2068 1136 N 0 39 49 0 0
      -39 h\n1 g 2020 1136 N 0 39 48 0 0 -39 h\n1 g 1971 1136 N 0 39 49 0 0
      -39 h\n1 g 1922 1136 N 0 39 49 0 0 -39 h\n1 g 1874 1136 N 0 39 48 0 0
      -39 h\n1 g 1825 1136 N 0 39 49 0 0 -39 h\n1 g 1777 1136 N 0 39 48 0 0
      -39 h\n1 g 1728 1136 N 0 39 49 0 0 -39 h\n1 g 1679 1136 N 0 39 49 0 0
      -39 h\n1 g 1631 1136 N 0 39 48 0 0 -39 h\n1 g 1582 1136 N 0 39 49 0 0
      -39 h\n1 g 1534 1136 N 0 39 48 0 0 -39 h\n1 g 1485 1136 N 0 39 49 0 0
      -39 h\n1 g 1436 1136 N 0 39 49 0 0 -39 h\n1 g 1388 1136 N 0 39 48 0 0
      -39 h\n1 g 1339 1136 N 0 39 49 0 0 -39 h\n1 g 1290 1136 N 0 39 49 0 0
      -39 h\n1 g 1242 1136 N 0 39 48 0 0 -39 h\n1 g 1193 1136 N 0 39 49 0 0
      -39 h\n1 g 5957 1097 N 0 38 49 0 0 -38 h\n1 g 5909 1097 N 0 38 48 0 0
      -38 h\n1 g 5860 1097 N 0 38 49 0 0 -38 h\n1 g 5811 1097 N 0 38 49 0 0
      -38 h\n1 g 5763 1097 N 0 38 48 0 0 -38 h\n1 g 5714 1097 N 0 38 49 0 0
      -38 h\n1 g 5665 1097 N 0 38 49 0 0 -38 h\n1 g 5617 1097 N 0 38 48 0 0
      -38 h\n1 g 5568 1097 N 0 38 49 0 0 -38 h\n1 g 5520 1097 N 0 38 48 0 0
      -38 h\n1 g 5471 1097 N 0 38 49 0 0 -38 h\n1 g 5422 1097 N 0 38 49 0 0
      -38 h\n1 g 5374 1097 N 0 38 48 0 0 -38 h\n1 g 5325 1097 N 0 38 49 0 0
      -38 h\n1 g 5277 1097 N 0 38 48 0 0 -38 h\n1 g 5228 1097 N 0 38 49 0 0
      -38 h\n1 g 5179 1097 N 0 38 49 0 0 -38 h\n1 g 5131 1097 N 0 38 48 0 0
      -38 h\n1 g 5082 1097 N 0 38 49 0 0 -38 h\n1 g 5034 1097 N 0 38 48 0 0
      -38 h\n1 g 4985 1097 N 0 38 49 0 0 -38 h\n1 g 4936 1097 N 0 38 49 0 0
      -38 h\n1 g 4888 1097 N 0 38 48 0 0 -38 h\n1 g 4839 1097 N 0 38 49 0 0
      -38 h\n1 g 4790 1097 N 0 38 49 0 0 -38 h\n1 g 4742 1097 N 0 38 48 0 0
      -38 h\n1 g 4693 1097 N 0 38 49 0 0 -38 h\n1 g 4645 1097 N 0 38 48 0 0
      -38 h\n1 g 4596 1097 N 0 38 49 0 0 -38 h\n1 g 4547 1097 N 0 38 49 0 0
      -38 h\n1 g 4499 1097 N 0 38 48 0 0 -38 h\n1 g 4450 1097 N 0 38 49 0 0
      -38 h\n1 g 4402 1097 N 0 38 48 0 0 -38 h\n1 g 4353 1097 N 0 38 49 0 0
      -38 h\n1 g 4304 1097 N 0 38 49 0 0 -38 h\n1 g 4256 1097 N 0 38 48 0 0
      -38 h\n1 g 4207 1097 N 0 38 49 0 0 -38 h\n1 g 4159 1097 N 0 38 48 0 0
      -38 h\n1 g 4110 1097 N 0 38 49 0 0 -38 h\n.9 g 4061 1097 N 0 38 49 0 0
      -38 h\n.8 g 4013 1097 N 0 38 48 0 0 -38 h\n.8 g 3964 1097 N 0 38 49 0 0
      -38 h\n.8 g 3915 1097 N 0 38 49 0 0 -38 h\n.8 g 3867 1097 N 0 38 48 0 0
      -38 h\n.8 g 3818 1097 N 0 38 49 0 0 -38 h\n.8 g 3770 1097 N 0 38 48 0 0
      -38 h\n.8 g 3721 1097 N 0 38 49 0 0 -38 h\n.8 g 3672 1097 N 0 38 49 0 0
      -38 h\n.8 g 3624 1097 N 0 38 48 0 0 -38 h\n.8 g 3575 1097 N 0 38 49 0 0
      -38 h\n.8 g 3527 1097 N 0 38 48 0 0 -38 h\n.8 g 3478 1097 N 0 38 49 0 0
      -38 h\n.8 g 3429 1097 N 0 38 49 0 0 -38 h\n.8 g 3381 1097 N 0 38 48 0 0
      -38 h\n.8 g 3332 1097 N 0 38 49 0 0 -38 h\n.8 g 3284 1097 N 0 38 48 0 0
      -38 h\n.8 g 3235 1097 N 0 38 49 0 0 -38 h\n.8 g 3186 1097 N 0 38 49 0 0
      -38 h\n.8 g 3138 1097 N 0 38 48 0 0 -38 h\n.9 g 3089 1097 N 0 38 49 0 0
      -38 h\n1 g 3040 1097 N 0 38 49 0 0 -38 h\n1 g 2992 1097 N 0 38 48 0 0
      -38 h\n1 g 2943 1097 N 0 38 49 0 0 -38 h\n1 g 2895 1097 N 0 38 48 0 0
      -38 h\n1 g 2846 1097 N 0 38 49 0 0 -38 h\n1 g 2797 1097 N 0 38 49 0 0
      -38 h\n1 g 2749 1097 N 0 38 48 0 0 -38 h\n1 g 2700 1097 N 0 38 49 0 0
      -38 h\n1 g 2652 1097 N 0 38 48 0 0 -38 h\n1 g 2603 1097 N 0 38 49 0 0
      -38 h\n1 g 2554 1097 N 0 38 49 0 0 -38 h\n1 g 2506 1097 N 0 38 48 0 0
      -38 h\n1 g 2457 1097 N 0 38 49 0 0 -38 h\n1 g 2409 1097 N 0 38 48 0 0
      -38 h\n1 g 2360 1097 N 0 38 49 0 0 -38 h\n1 g 2311 1097 N 0 38 49 0 0
      -38 h\n1 g 2263 1097 N 0 38 48 0 0 -38 h\n1 g 2214 1097 N 0 38 49 0 0
      -38 h\n1 g 2165 1097 N 0 38 49 0 0 -38 h\n1 g 2117 1097 N 0 38 48 0 0
      -38 h\n1 g 2068 1097 N 0 38 49 0 0 -38 h\n1 g 2020 1097 N 0 38 48 0 0
      -38 h\n1 g 1971 1097 N 0 38 49 0 0 -38 h\n1 g 1922 1097 N 0 38 49 0 0
      -38 h\n1 g 1874 1097 N 0 38 48 0 0 -38 h\n1 g 1825 1097 N 0 38 49 0 0
      -38 h\n1 g 1777 1097 N 0 38 48 0 0 -38 h\n1 g 1728 1097 N 0 38 49 0 0
      -38 h\n1 g 1679 1097 N 0 38 49 0 0 -38 h\n1 g 1631 1097 N 0 38 48 0 0
      -38 h\n1 g 1582 1097 N 0 38 49 0 0 -38 h\n1 g 1534 1097 N 0 38 48 0 0
      -38 h\n1 g 1485 1097 N 0 38 49 0 0 -38 h\n1 g 1436 1097 N 0 38 49 0 0
      -38 h\n1 g 1388 1097 N 0 38 48 0 0 -38 h\n1 g 1339 1097 N 0 38 49 0 0
      -38 h\n1 g 1290 1097 N 0 38 49 0 0 -38 h\n1 g 1242 1097 N 0 38 48 0 0
      -38 h\n1 g 1193 1097 N 0 38 49 0 0 -38 h\n1 g 5957 1059 N 0 39 49 0 0
      -39 h\n1 g 5909 1059 N 0 39 48 0 0 -39 h\n1 g 5860 1059 N 0 39 49 0 0
      -39 h\n1 g 5811 1059 N 0 39 49 0 0 -39 h\n1 g 5763 1059 N 0 39 48 0 0
      -39 h\n1 g 5714 1059 N 0 39 49 0 0 -39 h\n1 g 5665 1059 N 0 39 49 0 0
      -39 h\n1 g 5617 1059 N 0 39 48 0 0 -39 h\n1 g 5568 1059 N 0 39 49 0 0
      -39 h\n1 g 5520 1059 N 0 39 48 0 0 -39 h\n1 g 5471 1059 N 0 39 49 0 0
      -39 h\n1 g 5422 1059 N 0 39 49 0 0 -39 h\n1 g 5374 1059 N 0 39 48 0 0
      -39 h\n1 g 5325 1059 N 0 39 49 0 0 -39 h\n1 g 5277 1059 N 0 39 48 0 0
      -39 h\n1 g 5228 1059 N 0 39 49 0 0 -39 h\n1 g 5179 1059 N 0 39 49 0 0
      -39 h\n1 g 5131 1059 N 0 39 48 0 0 -39 h\n1 g 5082 1059 N 0 39 49 0 0
      -39 h\n1 g 5034 1059 N 0 39 48 0 0 -39 h\n1 g 4985 1059 N 0 39 49 0 0
      -39 h\n1 g 4936 1059 N 0 39 49 0 0 -39 h\n1 g 4888 1059 N 0 39 48 0 0
      -39 h\n1 g 4839 1059 N 0 39 49 0 0 -39 h\n1 g 4790 1059 N 0 39 49 0 0
      -39 h\n1 g 4742 1059 N 0 39 48 0 0 -39 h\n1 g 4693 1059 N 0 39 49 0 0
      -39 h\n1 g 4645 1059 N 0 39 48 0 0 -39 h\n1 g 4596 1059 N 0 39 49 0 0
      -39 h\n1 g 4547 1059 N 0 39 49 0 0 -39 h\n1 g 4499 1059 N 0 39 48 0 0
      -39 h\n1 g 4450 1059 N 0 39 49 0 0 -39 h\n1 g 4402 1059 N 0 39 48 0 0
      -39 h\n1 g 4353 1059 N 0 39 49 0 0 -39 h\n1 g 4304 1059 N 0 39 49 0 0
      -39 h\n1 g 4256 1059 N 0 39 48 0 0 -39 h\n1 g 4207 1059 N 0 39 49 0 0
      -39 h\n1 g 4159 1059 N 0 39 48 0 0 -39 h\n1 g 4110 1059 N 0 39 49 0 0
      -39 h\n.95 g 4061 1059 N 0 39 49 0 0 -39 h\n.85 g 4013 1059 N 0 39 48 0
      0 -39 h\n.8 g 3964 1059 N 0 39 49 0 0 -39 h\n.8 g 3915 1059 N 0 39 49 0
      0 -39 h\n.8 g 3867 1059 N 0 39 48 0 0 -39 h\n.8 g 3818 1059 N 0 39 49 0
      0 -39 h\n.8 g 3770 1059 N 0 39 48 0 0 -39 h\n.8 g 3721 1059 N 0 39 49 0
      0 -39 h\n.8 g 3672 1059 N 0 39 49 0 0 -39 h\n.8 g 3624 1059 N 0 39 48 0
      0 -39 h\n.8 g 3575 1059 N 0 39 49 0 0 -39 h\n.8 g 3527 1059 N 0 39 48 0
      0 -39 h\n.8 g 3478 1059 N 0 39 49 0 0 -39 h\n.8 g 3429 1059 N 0 39 49 0
      0 -39 h\n.8 g 3381 1059 N 0 39 48 0 0 -39 h\n.8 g 3332 1059 N 0 39 49 0
      0 -39 h\n.8 g 3284 1059 N 0 39 48 0 0 -39 h\n.8 g 3235 1059 N 0 39 49 0
      0 -39 h\n.8 g 3186 1059 N 0 39 49 0 0 -39 h\n.85 g 3138 1059 N 0 39 48
      0 0 -39 h\n.95 g 3089 1059 N 0 39 49 0 0 -39 h\n1 g 3040 1059 N 0 39 49
      0 0 -39 h\n1 g 2992 1059 N 0 39 48 0 0 -39 h\n1 g 2943 1059 N 0 39 49 0
      0 -39 h\n1 g 2895 1059 N 0 39 48 0 0 -39 h\n1 g 2846 1059 N 0 39 49 0 0
      -39 h\n1 g 2797 1059 N 0 39 49 0 0 -39 h\n1 g 2749 1059 N 0 39 48 0 0
      -39 h\n1 g 2700 1059 N 0 39 49 0 0 -39 h\n1 g 2652 1059 N 0 39 48 0 0
      -39 h\n1 g 2603 1059 N 0 39 49 0 0 -39 h\n1 g 2554 1059 N 0 39 49 0 0
      -39 h\n1 g 2506 1059 N 0 39 48 0 0 -39 h\n1 g 2457 1059 N 0 39 49 0 0
      -39 h\n1 g 2409 1059 N 0 39 48 0 0 -39 h\n1 g 2360 1059 N 0 39 49 0 0
      -39 h\n1 g 2311 1059 N 0 39 49 0 0 -39 h\n1 g 2263 1059 N 0 39 48 0 0
      -39 h\n1 g 2214 1059 N 0 39 49 0 0 -39 h\n1 g 2165 1059 N 0 39 49 0 0
      -39 h\n1 g 2117 1059 N 0 39 48 0 0 -39 h\n1 g 2068 1059 N 0 39 49 0 0
      -39 h\n1 g 2020 1059 N 0 39 48 0 0 -39 h\n1 g 1971 1059 N 0 39 49 0 0
      -39 h\n1 g 1922 1059 N 0 39 49 0 0 -39 h\n1 g 1874 1059 N 0 39 48 0 0
      -39 h\n1 g 1825 1059 N 0 39 49 0 0 -39 h\n1 g 1777 1059 N 0 39 48 0 0
      -39 h\n1 g 1728 1059 N 0 39 49 0 0 -39 h\n1 g 1679 1059 N 0 39 49 0 0
      -39 h\n1 g 1631 1059 N 0 39 48 0 0 -39 h\n1 g 1582 1059 N 0 39 49 0 0
      -39 h\n1 g 1534 1059 N 0 39 48 0 0 -39 h\n1 g 1485 1059 N 0 39 49 0 0
      -39 h\n1 g 1436 1059 N 0 39 49 0 0 -39 h\n1 g 1388 1059 N 0 39 48 0 0
      -39 h\n1 g 1339 1059 N 0 39 49 0 0 -39 h\n1 g 1290 1059 N 0 39 49 0 0
      -39 h\n1 g 1242 1059 N 0 39 48 0 0 -39 h\n1 g 1193 1059 N 0 39 49 0 0
      -39 h\n1 g 5957 1020 N 0 39 49 0 0 -39 h\n1 g 5909 1020 N 0 39 48 0 0
      -39 h\n1 g 5860 1020 N 0 39 49 0 0 -39 h\n1 g 5811 1020 N 0 39 49 0 0
      -39 h\n1 g 5763 1020 N 0 39 48 0 0 -39 h\n1 g 5714 1020 N 0 39 49 0 0
      -39 h\n1 g 5665 1020 N 0 39 49 0 0 -39 h\n1 g 5617 1020 N 0 39 48 0 0
      -39 h\n1 g 5568 1020 N 0 39 49 0 0 -39 h\n1 g 5520 1020 N 0 39 48 0 0
      -39 h\n1 g 5471 1020 N 0 39 49 0 0 -39 h\n1 g 5422 1020 N 0 39 49 0 0
      -39 h\n1 g 5374 1020 N 0 39 48 0 0 -39 h\n1 g 5325 1020 N 0 39 49 0 0
      -39 h\n1 g 5277 1020 N 0 39 48 0 0 -39 h\n1 g 5228 1020 N 0 39 49 0 0
      -39 h\n1 g 5179 1020 N 0 39 49 0 0 -39 h\n1 g 5131 1020 N 0 39 48 0 0
      -39 h\n1 g 5082 1020 N 0 39 49 0 0 -39 h\n1 g 5034 1020 N 0 39 48 0 0
      -39 h\n1 g 4985 1020 N 0 39 49 0 0 -39 h\n1 g 4936 1020 N 0 39 49 0 0
      -39 h\n1 g 4888 1020 N 0 39 48 0 0 -39 h\n1 g 4839 1020 N 0 39 49 0 0
      -39 h\n1 g 4790 1020 N 0 39 49 0 0 -39 h\n1 g 4742 1020 N 0 39 48 0 0
      -39 h\n1 g 4693 1020 N 0 39 49 0 0 -39 h\n1 g 4645 1020 N 0 39 48 0 0
      -39 h\n1 g 4596 1020 N 0 39 49 0 0 -39 h\n1 g 4547 1020 N 0 39 49 0 0
      -39 h\n1 g 4499 1020 N 0 39 48 0 0 -39 h\n1 g 4450 1020 N 0 39 49 0 0
      -39 h\n1 g 4402 1020 N 0 39 48 0 0 -39 h\n1 g 4353 1020 N 0 39 49 0 0
      -39 h\n1 g 4304 1020 N 0 39 49 0 0 -39 h\n1 g 4256 1020 N 0 39 48 0 0
      -39 h\n1 g 4207 1020 N 0 39 49 0 0 -39 h\n1 g 4159 1020 N 0 39 48 0 0
      -39 h\n1 g 4110 1020 N 0 39 49 0 0 -39 h\n1 g 4061 1020 N 0 39 49 0 0
      -39 h\n.9 g 4013 1020 N 0 39 48 0 0 -39 h\n.8 g 3964 1020 N 0 39 49 0 0
      -39 h\n.8 g 3915 1020 N 0 39 49 0 0 -39 h\n.8 g 3867 1020 N 0 39 48 0 0
      -39 h\n.8 g 3818 1020 N 0 39 49 0 0 -39 h\n.8 g 3770 1020 N 0 39 48 0 0
      -39 h\n.8 g 3721 1020 N 0 39 49 0 0 -39 h\n.8 g 3672 1020 N 0 39 49 0 0
      -39 h\n.8 g 3624 1020 N 0 39 48 0 0 -39 h\n.8 g 3575 1020 N 0 39 49 0 0
      -39 h\n.8 g 3527 1020 N 0 39 48 0 0 -39 h\n.8 g 3478 1020 N 0 39 49 0 0
      -39 h\n.8 g 3429 1020 N 0 39 49 0 0 -39 h\n.8 g 3381 1020 N 0 39 48 0 0
      -39 h\n.8 g 3332 1020 N 0 39 49 0 0 -39 h\n.8 g 3284 1020 N 0 39 48 0 0
      -39 h\n.8 g 3235 1020 N 0 39 49 0 0 -39 h\n.8 g 3186 1020 N 0 39 49 0 0
      -39 h\n.9 g 3138 1020 N 0 39 48 0 0 -39 h\n1 g 3089 1020 N 0 39 49 0 0
      -39 h\n1 g 3040 1020 N 0 39 49 0 0 -39 h\n1 g 2992 1020 N 0 39 48 0 0
      -39 h\n1 g 2943 1020 N 0 39 49 0 0 -39 h\n1 g 2895 1020 N 0 39 48 0 0
      -39 h\n1 g 2846 1020 N 0 39 49 0 0 -39 h\n1 g 2797 1020 N 0 39 49 0 0
      -39 h\n1 g 2749 1020 N 0 39 48 0 0 -39 h\n1 g 2700 1020 N 0 39 49 0 0
      -39 h\n1 g 2652 1020 N 0 39 48 0 0 -39 h\n1 g 2603 1020 N 0 39 49 0 0
      -39 h\n1 g 2554 1020 N 0 39 49 0 0 -39 h\n1 g 2506 1020 N 0 39 48 0 0
      -39 h\n1 g 2457 1020 N 0 39 49 0 0 -39 h\n1 g 2409 1020 N 0 39 48 0 0
      -39 h\n1 g 2360 1020 N 0 39 49 0 0 -39 h\n1 g 2311 1020 N 0 39 49 0 0
      -39 h\n1 g 2263 1020 N 0 39 48 0 0 -39 h\n1 g 2214 1020 N 0 39 49 0 0
      -39 h\n1 g 2165 1020 N 0 39 49 0 0 -39 h\n1 g 2117 1020 N 0 39 48 0 0
      -39 h\n1 g 2068 1020 N 0 39 49 0 0 -39 h\n1 g 2020 1020 N 0 39 48 0 0
      -39 h\n1 g 1971 1020 N 0 39 49 0 0 -39 h\n1 g 1922 1020 N 0 39 49 0 0
      -39 h\n1 g 1874 1020 N 0 39 48 0 0 -39 h\n1 g 1825 1020 N 0 39 49 0 0
      -39 h\n1 g 1777 1020 N 0 39 48 0 0 -39 h\n1 g 1728 1020 N 0 39 49 0 0
      -39 h\n1 g 1679 1020 N 0 39 49 0 0 -39 h\n1 g 1631 1020 N 0 39 48 0 0
      -39 h\n1 g 1582 1020 N 0 39 49 0 0 -39 h\n1 g 1534 1020 N 0 39 48 0 0
      -39 h\n1 g 1485 1020 N 0 39 49 0 0 -39 h\n1 g 1436 1020 N 0 39 49 0 0
      -39 h\n1 g 1388 1020 N 0 39 48 0 0 -39 h\n1 g 1339 1020 N 0 39 49 0 0
      -39 h\n1 g 1290 1020 N 0 39 49 0 0 -39 h\n1 g 1242 1020 N 0 39 48 0 0
      -39 h\n1 g 1193 1020 N 0 39 49 0 0 -39 h\n1 g 5957 981 N 0 39 49 0 0
      -39 h\n1 g 5909 981 N 0 39 48 0 0 -39 h\n1 g 5860 981 N 0 39 49 0 0 -39
      h\n1 g 5811 981 N 0 39 49 0 0 -39 h\n1 g 5763 981 N 0 39 48 0 0 -39
      h\n1 g 5714 981 N 0 39 49 0 0 -39 h\n1 g 5665 981 N 0 39 49 0 0 -39
      h\n1 g 5617 981 N 0 39 48 0 0 -39 h\n1 g 5568 981 N 0 39 49 0 0 -39
      h\n1 g 5520 981 N 0 39 48 0 0 -39 h\n1 g 5471 981 N 0 39 49 0 0 -39
      h\n1 g 5422 981 N 0 39 49 0 0 -39 h\n1 g 5374 981 N 0 39 48 0 0 -39
      h\n1 g 5325 981 N 0 39 49 0 0 -39 h\n1 g 5277 981 N 0 39 48 0 0 -39
      h\n1 g 5228 981 N 0 39 49 0 0 -39 h\n1 g 5179 981 N 0 39 49 0 0 -39
      h\n1 g 5131 981 N 0 39 48 0 0 -39 h\n1 g 5082 981 N 0 39 49 0 0 -39
      h\n1 g 5034 981 N 0 39 48 0 0 -39 h\n1 g 4985 981 N 0 39 49 0 0 -39
      h\n1 g 4936 981 N 0 39 49 0 0 -39 h\n1 g 4888 981 N 0 39 48 0 0 -39
      h\n1 g 4839 981 N 0 39 49 0 0 -39 h\n1 g 4790 981 N 0 39 49 0 0 -39
      h\n1 g 4742 981 N 0 39 48 0 0 -39 h\n1 g 4693 981 N 0 39 49 0 0 -39
      h\n1 g 4645 981 N 0 39 48 0 0 -39 h\n1 g 4596 981 N 0 39 49 0 0 -39
      h\n1 g 4547 981 N 0 39 49 0 0 -39 h\n1 g 4499 981 N 0 39 48 0 0 -39
      h\n1 g 4450 981 N 0 39 49 0 0 -39 h\n1 g 4402 981 N 0 39 48 0 0 -39
      h\n1 g 4353 981 N 0 39 49 0 0 -39 h\n1 g 4304 981 N 0 39 49 0 0 -39
 