; -- CodePrepareToInstall.iss --
;
; This script shows how the PrepareToInstall event function can be used to
; install prerequisites and handle any reboots in between, while remembering
; user selections across reboots.

[Setup]
AppName=My Program
AppVerName=My Program version 1.5
DefaultDirName={pf}\My Program
DefaultGroupName=My Program
UninstallDisplayIcon={app}\MyProg.exe
OutputDir=userdocs:Inno Setup Examples Output

[Files]
Source: "MyProg.exe"; DestDir: "{app}";
Source: "MyProg.chm"; DestDir: "{app}";
Source: "Readme.txt"; DestDir: "{app}"; Flags: isreadme;

[Icons]
Name: "{group}\My Program"; Filename: "{app}\MyProg.exe"

[Code]
const
  (*** Customize the following to your own name. ***)
  RunOnceLinkName = 'My Program Setup restart';

  QuitMessageReboot = 'Need restart. Setup will continue after restart. Please restart now.';
  QuitMessageError = 'Error. Cannot continue.';

var
  Restarted: Boolean;
  RunOnceLinkFileName: String;

function InitializeSetup(): Boolean;
begin
  Restarted := ExpandConstant('{param:restart|0}') = '1';
  RunOnceLinkFileName := AddBackslash(ExpandConstant('{commonstartup}')) + RunOnceLinkName + '.lnk';

  if not Restarted then begin
    Result := not FileExists(RunOnceLinkFilename);
    if not Result then
      MsgBox(QuitMessageReboot, mbError, mb_Ok);
  end else begin
    if FileExists(RunOnceLinkFileName) and not DeleteFile(RunOnceLinkFileName) then
      RestartReplace(RunOnceLinkFileName, '');
    Result := True;
  end;
end;

function DetectAndInstallPrerequisites: Boolean;
begin
  (*** Place your prerequisite detection and installation code below. ***)
  (*** Return False if missing prerequisites were detected but their installation failed, else return True. ***)

  //<your code here>

  Result := True;

  (*** Remove the following block! Used by this demo to simulate a prerequisite install requiring a reboot. ***)
  if not Restarted then
    RestartReplace(ParamStr(0), '');
end;

function Quote(const S: String): String;
begin
  Result := '"' + S + '"';
end;

function AddParam(const S, P, V: String): String;
begin
  if V <> '""' then
    Result := S + ' /' + P + '=' + V;
end;

function AddSimpleParam(const S, P: String): String;
begin
 Result := S + ' /' + P;
end;

procedure CreateRunOnceEntry;
var
  RunOnceData: String;
begin
  RunOnceData := '/restart=1';
  RunOnceData := AddParam(RunOnceData, 'LANG', ExpandConstant('{language}'));
  RunOnceData := AddParam(RunOnceData, 'DIR', Quote(WizardDirValue));
  RunOnceData := AddParam(RunOnceData, 'GROUP', Quote(WizardGroupValue));
  if WizardNoIcons then
    RunOnceData := AddSimpleParam(RunOnceData, 'NOICONS');
  RunOnceData := AddParam(RunOnceData, 'TYPE', Quote(WizardSetupType(False)));
  RunOnceData := AddParam(RunOnceData, 'COMPONENTS', Quote(WizardSelectedComponents(False)));
  RunOnceData := AddParam(RunOnceData, 'TASKS', Quote(WizardSelectedTasks(False)));

  (*** Place any custom user selection you want to remember below. ***)

  //<your code here>

  CreateShellLink(RunOnceLinkFileName, '', ExpandConstant('{srcexe}'), RunOnceData, '', '', 0, SW_SHOW);
end;

function PrepareToInstall: String;
var
  ChecksumBefore, ChecksumAfter: String;
begin
  ChecksumBefore := MakePendingFileRenameOperationsChecksum;
  if DetectAndInstallPrerequisites then begin
    ChecksumAfter := MakePendingFileRenameOperationsChecksum;
    if ChecksumBefore <> ChecksumAfter then begin
      CreateRunOnceEntry;
      Result := QuitMessageReboot;
    end;
  end else
    Result := QuitMessageError;
end;

function ShouldSkipPage(PageID: Integer): Boolean;
begin
  Result := Restarted and (PageID < wpReady);
end;

