#!/bin/bash --norc
# *******************************************************************************
# * MODULE     : mkauto.sh
# * DESCRIPTION: update or install m4 and autotool in SDK directory 
# * COPYRIGHT  : (C) 2016-2019 Denis RAUX
# *******************************************************************************
# * This software falls under the GNU general public license version 3 or later.
# * It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
# * in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
# *******************************************************************************

. common.sh

#if type autoconf 2>/dev/null 1>&2
function decodeversion { 
	local version
	[[ "$*" =~ ([[:digit:]]+\.[[:digit:]]+\.*[[:digit:]]*) ]] && version=${BASH_REMATCH[1]}
	echo $version
}

function cmpver {
	# $1 eq $2 return 0
	# $1 gt $2 return 1
	# $1 lt $2 return 2
	local s1="$1." s2="$2." #dot is for empty the string
	local -i n1 n2
	while [[ -n $s1 || -n $s2 ]]
	do n1=${s1%%.*}; n2=${s2%%.*}
		 [ $n1 -gt $n2 ] &&  return 1
		 [ $n1 -lt $n2 ] &&  return 2
		 s1=${s1#*.}; s2=${s2#*.}
	done
	return 0
}

function GorE {
	cmpver "$1" "$2"
	[[ $? -lt 2 ]]
	 return $?
}

function getversion { 
	if type $1 2>/dev/null 1>&2
	then 
		savGLOB=$(shopt -p extglob)
		shopt -s extglob
		local version
	
		while read line
		do version=$(decodeversion $line)
			if test -n "$version"
			then echo $version
					 return
			fi
		done <<<$($1 --version)
		$savGLOB
		echo 0.0.0
	else echo 0.0.0
	fi
}
	
declare m4=1.4.6 autoconf=2.69 automake=1.14 libtool=2.4.6
declare version

#autoreconf and aclocal not needed now
#for l in m4 autoconf automake libtool

for l in m4 autoconf
do
	test -d $l && continue
	version=$(getversion $l)
	echo $l version $version
	GorE $version ${!l} && echo $l is already to a decent version && continue
	echo installing $l
	tar -zxf ../TAR/$l-*
	pushd $l-* || exit
	./configure  --prefix=$TMSDKPH --enable-static --disable-shared && make -j$cntproc && make install || exit
	popd
done

