#!/bin/bash --norc
# *******************************************************************************
# * MODULE     : mklib.sh
# * DESCRIPTION: copy the host static libs in TeXmacs SDK lib directory for linux
# * COPYRIGHT  : (C) 2016-2017 Denis RAUX
# *******************************************************************************
# * This software falls under the GNU general public license version 3 or later.
# * It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
# * in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
# *******************************************************************************
# Only for Linux
# No wildcard libraries are mandatory

. common.sh

function GetLibPath {
   local target path out
   while read target path
   do test "$target" = libraries: && out=${path//:/ } && echo ${out#=} 
   done <<< $(${CC:-gcc} -print-search-dirs)
}

typeset targets l blib
res=staticlib
[[ "$TMMODE" == a ]] && isDone $res && exit 0

if [[ $TMOS == lin ]]
then 
	test -d $TMSDKPH/lib || mkdir $TMSDKPH/lib
  targets="libglib*  libgthread* libstdc++ libjpeg  libtiff libcrypt libm"
  for l in $targets
  do  
    ll=$(find $(GetLibPath) -maxdepth 1 -type f -name $l.a -print -quit 2>/dev/null)

    if test -n "$ll"
    then if ! cp $ll $TMSDKPH/lib/
          then  res=-$res
                echo copy fails for $ll
          else
            echo $ll .... copied
            blib=$(basename $ll)
            pkg-config --exists $blib || 
            	echo "pkg-config does not find package description for $blib, link may fail"
          fi
    else if ! [[ $l =~ \* ]]
        then  echo "warning $l not found, static version may be missing on target host"
    		      echo "you should install the related devel package (ie $l-devel)"
    			    res=-$res
    	  fi
    fi
  done
fi
setStatus true $res
