#!/bin/bash --norc
# *******************************************************************************
# * MODULE     : mktool.sh
# * DESCRIPTION: untar and install pkg-config if there is not any 
# * COPYRIGHT  : (C) 2016-2017 Denis RAUX
# *******************************************************************************
# * This software falls under the GNU general public license version 3 or later.
# * It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
# * in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
# *******************************************************************************

. common.sh

# we need to install pkg-config is not present.
if ! type pkg-config 2>/dev/null 1>&2 || [[ $(pkg-config --version) < 0.25 ]]
then 
  echo pkg-config installation
  #unset CFLAGS CPPFLAGS LDFLAGS CXXFLAGS
  if test $TMOS = mac
  then 
    export LDFLAGS+=" -framework CoreFoundation -framework Carbon"
  fi
  # we have to find the right option for iconv or else pkg-config stops compiling
  if gcc -E -xc - 2>/dev/null 1>&2    # check for the header
  then 
    if gcc -xc -liconv - 2>/dev/null 1>&2  # check for the lib
    then iconv=native
          rm a.out
    else iconv=native
    fi <<-EOF1
     #include <iconv.h>
      main(int c, char **v) {
       (void) iconv_open ("", "");
       return 0; }
EOF1
  else iconv=no
  fi <<-EOF
     #include <iconv.h>
EOF
  test -d pkg-config-* || tar -zxf ../TAR/pkg-config*
  pushd pkg-config-* && ./configure --prefix=$(absPath $(dirname $0)/..) --with-internal-glib \
  		--disable-compile-warnings --with-libiconv=$iconv &&\
    make -j$cntproc && make install
  popd
  ln -s $PWD/bin/pkg-config $TMSDKPH/bin/pkg-config
else echo pkg-config already exists at a recent version
fi

# install cmake if package is present
if ! type cmake 2>/dev/null 1>&2
then
	test -f ../TAR/cmake-* && tar -zxf ../TAR/cmake-*
	if test -d cmake-*
	then pushd cmake-* && ./configure --prefix=$TMSDKPH --parallel=$cntproc --system-curl &&
					make -j$cntproc && make install
	fi
fi
