<TeXmacs|1.99.7>

<style|<tuple|aps|std-latex>>

<\body>
  <\hide-preamble>
    <assign|spin|<macro|1|2|<left|(><tabular*|<tformat|<table|<row|<cell|<arg|1>>>|<row|<cell|<arg|2>>>>>><right|)>>>

    <assign|jjj|<macro|1|2|3|4|5|6|<left|(><tabular*|<tformat|<table|<row|<cell|<arg|1>>|<cell|<arg|2>>|<cell|<arg|3>>>|<row|<cell|<arg|4>>|<cell|<arg|5>>|<cell|<arg|6>>>>>><right|)>>>

    <assign|val|<macro|\<b-alpha\>>>

    <assign|vna|<macro|<with|math-font-series|bold|\<nabla\>>>>

    <assign|vr|<macro|<with|math-font-family|rm|math-font-family|bf|r>>>

    <assign|vp|<macro|<with|math-font-family|rm|math-font-family|bf|p>>>

    <assign|vA|<macro|<with|math-font-family|rm|math-font-family|bf|A>>>

    <assign|vF|<macro|<with|math-font-family|rm|math-font-family|bf|F>>>

    <assign|hr|<macro|<wide|<vr>|^>>>
  </hide-preamble>

  <doc-data|<doc-title|Solution of the time-dependent Dirac equation for
  describing multiphoton ionization of highly-charged hydrogenlike
  ions>|<doc-author|<author-data|<author-name|Yulian V.
  Vanne>>>|<doc-author|<author-data|<author-name|Alejandro
  Saenz>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    A theoretical study of the intense-field multiphoton ionization of
    hydrogenlike systems is performed by solving the time-dependent Dirac
    equation within the dipole approximation. It is shown that the
    velocity-gauge results agree to the ones in length gauge only if the
    negative-energy states are included in the time propagation. On the other
    hand, for the considered laser parameters, no significant difference is
    found in length gauge if the negative-energy states are included or not.
    Within the adopted dipole approximation the main relativistic effect is
    the shift of the ionization potential. A simple scaling procedure is
    proposed to account for this effect.
  </abstract>>

  <section|Introduction><label|sec:Intro>

  Future experiments using an electron-beam ion trap (EBIT) at the Linear
  Coherent Light Source (LCLS) at Stanford and X-ray Free Electron Laser
  (XFEL) at Hamburg are expected to permit the study of photoabsorption
  processes of highly charged atomic ions in the wavelength range of 0.1 to
  100<space|0.17em>nm with a peak intensity up to
  <math|10<rsup|25>><space|0.17em>W/cm<rsup|<math|2>> or even higher. Also at
  the GSI (Darmstadt) experimental investigations of highly charged ions
  exposed to intense laser fields are planned within the SPARC project. The
  analysis of these experiments will require a relativistic treatment of the
  ion-laser interaction.

  Clearly, a full treatment demands to solve the time-dependent Dirac
  equation (TDDE) incorporating also the spatial dependence of the vector
  potential. Since such a treatment is very demanding, most earlier
  treatments adopted simplifications. Low-dimensional models are especially
  popular. Starting first with a one-dimensional treatment
  <cite|sfa:kyls97a>, elaborate two-dimensional calculations have been
  reported, e.<space|0.17em>g., in<nbsp><cite|sfa:rath97|sfa:mock04|sfa:mock08>.
  However, such models can certainly not provide quantitative predictions and
  it is, at least <with|font-shape|italic|a priori>, not even clear whether
  they are always qualitatively correct. Similarly to the non-relativistic
  case, also simplified ionization models like the strong-field approximation
  <cite|sfa:reis90a|sfa:fais04|sfa:klai06|sfm:fais09>, semiclassical
  tunneling theory <cite|sfa:milo02a>, or classical models like in
  <cite|sfa:keit95|sfa:gaie02|sfa:hetz09> have been proposed. However, in
  order to allow for quantitative predictions or the validation of such
  simplified models a full-dimensional solution of the TDDE is needed.

  Very recently, a three-dimensional solution of the TDDE for hydrogenlike
  systems has been reported in <cite|sfa:sels09>. The radial solutions were
  expanded on a grid and the TDDE was either solved by a direct propagation
  on the grid or using a spectral expansion in field-free eigenstates. The
  spatial dependence of the vector potential of the carrier part of the laser
  pulse was also considered, while the one in the envelope was ignored. The
  velocity gauge was used and the importance of including the negative-energy
  (NE) states was emphasized in the case of a treatment beyond the dipole
  approximation, even for the considered laser parameters where the photon
  energy is insufficient to produce real positron-electron pairs. Based on
  general theoretical considerations it was conjectured that in length gauge
  the importance of the NE states may be reduced. On the other hand, it was
  concluded on the basis of the numerical results that within the dipole
  approximation the inclusion of NE states is not needed, even if the TDDE is
  solved in velocity gauge. A comparison of the numerically obtained
  ionization rates for various nuclear charges with the ones in
  non-relativistic approximation showed that, expectedly, increasing
  differences are found with increasing charge. However, it was concluded
  that the ionization rate (shown as a function of the peak value of the
  laser field) obtained within the relativistic TDDE calculation may be
  larger or smaller than the non-relativistic result. The authors found the
  higher rate easier to understand and could only speculate on possible
  reasons for the lower one.

  A solution of the TDDE within the length gauge was reported more recently
  in <cite|sfa:pind10>. A direct time propagation on a grid was used. As in
  <cite|sfa:sels09> the electron-nucleus interaction is described by the
  unmodified non-relativistic Coulomb interaction. While solely the dipole
  approximation is adopted, not only results for one-electron, but also for
  two-electron ions are reported. In the latter case the electron-electron
  interaction is also described by the non-relativistic Coulomb interaction.
  No explicit discussion of the inclusion or omission of the NE states is
  given. Comparing for Ne<rsup|<math|9+>>, Ne<rsup|<math|8+>>,
  U<rsup|<math|91+>>, and U<rsup|<math|90+>> the photoionization cross
  sections obtained by solving the TDDE for 10-cycle pulses (using a single
  pulse with one set of laser parameters for every ion) with the ones of
  relativistic perturbation theory, a good quantitative agreement is found.
  This result is, of course, expected, if the laser parameters are chosen in
  a way that perturbation theory is applicable, as was the case in
  <cite|sfa:pind10> where relatively low intensities (in relation to the
  ionization potentials and photon frequencies) were considered.

  In this work a further approach for solving the TDDE is presented. It is
  based on the spectral expansion in field-free eigenstates where the radial
  wavefunctions are expressed in a <math|B>-spline basis. It may be seen as
  an extension of the corresponding approaches for solving the
  non-relativistic time-dependent Schrdinger equation (TDSE) for one- and
  two-electron atoms in, e.<space|0.17em>g.,
  <cite|sfa:tang90b|sfa:tang90|sfa:lamb98a|sfa:nubb08>, for molecular
  hydrogen <cite|sfm:awas05|sfm:pala06|sfm:vann09|sfm:sans10|sfm:vann10>, and
  for in principle arbitrary molecules within the single-active-electron
  approximation <cite|sfm:awas08|sfm:petr10a>. While <cite|sfa:sels09> and
  <cite|sfa:pind10> considered mostly (or solely) one-photon ionization, an
  extension to multiphoton ionization is presented. Clearly, such
  calculations are very demanding as they require larger expansions, because
  more angular momenta are involved. Within the dipole approximation a
  systematic investigation of the importance of NE states as well as the
  convergence behavior within either length or velocity gauge is performed. A
  simple scaling relation is proposed that allows to relate relativistic TDDE
  solutions to the ones obtained with the non-relativistic TDSE, if both are
  performed within the dipole approximation.

  In this work atomic units (<math|e=m<rsub|e>=\<hbar\>=1>) are used unless
  specified otherwise.

  <section|Theory><label|sec:Theory>

  The dynamics of a highly charged atomic ion exposed to an external
  electromagnetic field is considered by means of both a relativistic and a
  non-relativistic treatment within the dipole approximation. The vector
  potential <math|<vA><around|(|t|)>> is chosen in the form of an
  <math|N>-cycle <math|cos<rsup|2>>-shaped laser pulse that is
  linear-polarized along the <math|z> axis,

  <\equation>
    <vA><around|(|t|)>=<choice|<tformat|<table|<row|<cell|<with|math-font-family|rm|math-font-family|bf|e><rsub|z>*A<rsub|0>*cos<rsup|2><around*|(|<frac|\<pi\>*t|T>|)>*sin
    <around|(|\<omega\>*t|)>,>|<cell|t\<in\>(-<frac|T|2>,<frac|T|2>);>>|<row|<cell|0,>|<cell|<text|otherwise,>>>>>><label|>
  </equation>

  where <math|\<omega\>> is the radiation frequency and
  <math|T=2*\<pi\>*N/\<omega\>> is the pulse duration. Ignoring finite
  nuclear size effects, the interaction of an electron with the nucleus may
  be approximated by the Coulomb potential

  <\equation>
    U<around|(|r|)>=-<frac|Z|r>,<label|>
  </equation>

  where <math|Z> is the nuclear charge. In all calculations presented in this
  work the hydrogenlike system is initially prepared in its ground state.

  <subsection|Relativistic calculations><label|subsec:RelCalc>

  The relativistic dynamics of the quantum system is governed by the TDDE

  <\equation>
    i*<frac|\<partial\>*\<Psi\><around|(|t|)>|\<partial\>*t>=<around*|[|H<rsup|<textrm>>*D<rsub|0>+V<around|(|t|)>|]>*\<Psi\><around|(|t|)><label|eq:TDDE>
  </equation>

  where <math|H<rsup|<textrm>>*D<rsub|0>> is the field-free Dirac Hamiltonian
  <math|H<rsup|<textrm>>*D<rsub|0>>,

  <\equation>
    H<rsup|<textrm>>*D<rsub|0>=c<space|0.17em><val>\<cdot\><vp>+c<rsup|2>*\<beta\>+U<around|(|r|)>,<label|>
  </equation>

  and the interaction with the electromagnetic field <math|V<around|(|t|)>>
  can be presented within the dipole approximation either in the velocity (V)
  or length (L) gauge,

  <\equation>
    <eqsplit|<tformat|<table|<row|<cell|V<rsup|<textrm>>*V<around|(|t|)>>|<cell|=c<space|0.17em><val>\<cdot\><vA><around|(|t|)>=c*<space|0.17em>\<alpha\><rsub|z>*A<around|(|t|)>,>>|<row|<cell|V<rsup|<textrm>>*L<around|(|t|)>>|<cell|=<vr>\<cdot\><vF><around|(|t|)>=z*F<around|(|t|)>.>>>>>

    <label|>
  </equation>

  Here, <math|\<beta\>> and the components of the vector <math|<val>> are the
  Dirac matrices, <math|<vp>=-i<vna>> is the momentum operator,
  <math|c\<approx\>137> is the speed of light, and
  <math|<vF><around|(|t|)>=-d<vA><around|(|t|)>/d*t> is the electric field.

  As is well known (see, e.<space|0.17em>g., <cite|gen:gran07>), the
  eigenstates of <math|H<rsup|<textrm>>*D<rsub|0>> can be presented as four
  component spinors

  <\equation>
    \<Phi\><rsub|\<kappa\>*m><around|(|<vr>|)>=<frac|1|r><spin|P<rsub|\<kappa\>><around|(|r|)>*<space|0.17em>\<chi\><rsub|\<kappa\>,m><around|(|<hr>|)>|i*<space|0.17em>Q<rsub|\<kappa\>><around|(|r|)>*<space|0.17em>\<chi\><rsub|-\<kappa\>,m><around|(|<hr>|)>><label|>
  </equation>

  where <math|\<chi\><rsub|\<kappa\>,m><around|(|<hr>|)>> is an <math|l*s>
  coupled spherical spinor, <math|\<kappa\>> is the relativistic quantum
  number of angular momentum, related to the orbital and total angular
  momenta, <math|l> and <math|j>, as

  <\equation>
    \<kappa\>=<choice|<tformat|<table|<row|<cell|-<around|(|j+1/2|)>=-<around|(|l+1|)>,>|<cell|<text|for><space|0.17em><space|0.17em>j=l+1/2,>>|<row|<cell|<phantom|-(>j+1/2<phantom|)>=<phantom|->l,>|<cell|<text|for><space|0.17em><space|0.17em>j=l-1/2;>>>>><label|>
  </equation>

  and the radial functions <math|P<rsub|\<kappa\>><around|(|r|)>> and
  <math|Q<rsub|\<kappa\>><around|(|r|)>> are solutions of the coupled
  equations

  <\equation>
    <choice|<tformat|<table|<row|<cell|<around|[|U<around|(|r|)>+c<rsup|2>-E|]>*P<rsub|\<kappa\>><around|(|r|)>+c*<around*|[|<frac|\<kappa\>|r>-<frac|d|d*r>|]>*Q<rsub|\<kappa\>><around|(|r|)>=0>>|<row|<cell|<around|[|U<around|(|r|)>-c<rsup|2>-E|]>*Q<rsub|\<kappa\>><around|(|r|)>+c*<around*|[|<frac|\<kappa\>|r>+<frac|d|d*r>|]>*P<rsub|\<kappa\>><around|(|r|)>=0.>>>>><label|eq:RES>
  </equation>

  For two spinor states, <math|\<Phi\><rsub|i>> and <math|\<Phi\><rsub|f>>,
  characterized by the quantum numbers <math|<around|{|n<rsub|i>,\<kappa\><rsub|i>,j<rsub|i>,l<rsub|i>,m<rsub|i>|}>>
  and <math|<around|{|n<rsub|f>,\<kappa\><rsub|f>,j<rsub|f>,l<rsub|f>,m<rsub|f>|}>>,
  respectively, the time-dependent matrix element
  <math|V<rsub|f*i><around|(|t|)>=<around|\<langle\>|\<Phi\><rsub|f><around|\||V<around|(|t|)>|\|>*\<Phi\><rsub|i>|\<rangle\>>>
  can be written as

  <\equation>
    V<rsub|f*i><around|(|t|)>=\<delta\><rsub|m<rsub|f>,m<rsub|i>>*<space|0.17em>\<delta\><rsub|<around|\||l<rsub|f>-l<rsub|i>|\|>,1>*<space|0.17em>W<rsub|f*i>*<space|0.17em>M<rsub|f*i><around|(|t|)><label|eq:Vfi>
  </equation>

  where

  <\equation>
    <eqsplit|<tformat|<table|<row|<cell|W<rsub|f*i>>|<cell|=(-1)<rsup|j<rsub|f>-m<rsub|f>>(-1)<rsup|j<rsub|i>+1/2><sqrt|<around|(|2*j<rsub|f>+1|)>*<around|(|2*j<rsub|i>+1|)>>>>|<row|<cell|>|<cell|\<times\><jjj|j<rsub|f>|1|j<rsub|i>|-m<rsub|f>|0|m<rsub|i>><jjj|j<rsub|f>|1|j<rsub|i>|-1/2|0|1/2>>>>>>

    <label|>
  </equation>

  and

  <\equation>
    M<rsup|<textrm>>*L<rsub|f*i><around|(|t|)>=F<around|(|t|)>*<big|int>d*r*<space|0.17em>r*<space|0.17em><around*|[|P<rsub|i><around|(|r|)>*P<rsub|f><around|(|r|)>+Q<rsub|i><around|(|r|)>*Q<rsub|f><around|(|r|)>|]>,<label|>
  </equation>

  <\equation>
    <eqsplit|<tformat|<table|<row|<cell|M<rsup|<textrm>>*V<rsub|f*i><around|(|t|)>=-i*c*A<around|(|t|)>*<big|int>d*r<space|0.17em>>|<cell|<around*|[|<around|(|1+\<Delta\><rsub|f*i>|)>*P<rsub|i><around|(|r|)>*Q<rsub|f><around|(|r|)>|\<nobracket\>>>>|<row|<cell|>|<cell|<around*|\<nobracket\>|-<around|(|1-\<Delta\><rsub|f*i>|)>*Q<rsub|i><around|(|r|)>*P<rsub|f><around|(|r|)>|]>>>>>>

    <label|>
  </equation>

  with <math|\<Delta\><rsub|f*i>=(-1)<rsup|j<rsub|f>-j<rsub|i>><around|(|\<kappa\><rsub|f>-\<kappa\><rsub|i>|)>>.

  In order to describe both bound and continuum states, the atom is confined
  within a spherical box boundary of radius <math|R>. This leads to the
  discretization of the continuum spectrum, whereas the bound states remain
  unmodified, if <math|R> is chosen sufficiently large and not too highly
  excited Rydberg states are considered.

  Introducing in a region <math|<around|[|0,R|]>> a <math|B>-spline set
  consisting of <math|n+2> spline functions <math|B<rsub|i><around|(|r|)>> of
  order <math|k>, the radial functions <math|P<around|(|r|)>> and
  <math|Q<around|(|r|)>> can be expanded in a <math|B>-spline basis as

  <\equation>
    P<around|(|r|)>=<big|sum><rsub|i=1><rsup|n>p<rsub|i>*B<rsub|i+1><around|(|r|)>*<space|1em>Q<around|(|r|)>=<big|sum><rsub|i=1><rsup|n>q<rsub|i>*B<rsub|i+1><around|(|r|)><label|>
  </equation>

  where the first and the last spline are removed from the expansion to
  ensure the boundary conditions <math|P<around|(|0|)>=Q<around|(|0|)>=P<around|(|R|)>=Q<around|(|R|)>=0>.
  Defining the coefficient vector

  <\equation>
    <math-bf|C>=<around|(|p<rsub|1>,q<rsub|1>,p<rsub|2>,q<rsub|2>,\<ldots\>,p<rsub|n>,q<rsub|n>|)>,<label|>
  </equation>

  the system of equations<nbsp>(<reference|eq:RES>) is transformed into a
  <math|2*n\<times\>2*n> generalized banded eigenvalue problem which is
  efficiently solved using LAPACK routine DSBGVX. This procedure yields for
  every value of <math|\<kappa\>> exactly <math|n> negative energy solutions
  and <math|n> positive energy solutions.

  As has been discussed in literature since the first solution of the
  time-independent (stationary) Dirac equation using <math|B>
  splines<nbsp><cite|bsp:john88>, there is the problem of the occurrence of
  spurious states <cite|gen:drak81> that are non-physical. Different
  procedures were proposed to avoid this problem
  <cite|bsp:shab04|bsp:belo08|bsp:gran09>. While there can be a problem with
  their identification in the case of many-electron systems, it is the lowest
  positive energy state for <math|\<kappa\>\<gtr\>0> that represents a
  spurious state in the present case.

  <subsection|Non-relativistic calculations><label|subsec:NonrelCalc>

  The non-relativistic TDSE

  <\equation>
    i*<frac|\<partial\>*\<Psi\><around|(|t|)>|\<partial\>*t>=<around*|[|H<rsub|0>+V<around|(|t|)>|]>*\<Psi\><around|(|t|)><label|eq:TDSE>
  </equation>

  where <math|H<rsub|0>> is the non-relativistic field-free Hamiltonian
  <math|H<rsub|0>>,

  <\equation>
    H<rsub|0>=<frac|<vp><rsup|2>|2>+U<around|(|r|)>,<label|>
  </equation>

  and in contrast to the relativistic case, the interaction with the
  electromagnetic field <math|V<around|(|t|)>> is given in the velocity gauge
  by

  <\equation>
    V<rsup|<textrm>>*V<around|(|t|)>=<vp>\<cdot\><vA><around|(|t|)>=p<rsub|z>*A<around|(|t|)>.<label|>
  </equation>

  Similar to the relativistic case, the eigenstates of <math|H<rsub|0>>,
  <math|\<Phi\><rsub|l*m><around|(|<vr>|)>=r<rsup|-1>*R<rsub|l><around|(|r|)>*Y<rsub|l*m><around|(|<hr>|)>>,
  are obtained by projecting the radial function
  <math|R<rsub|l><around|(|r|)>> onto the <math|B>-spline basis

  <\equation>
    R<around|(|r|)>=<big|sum><rsub|i=1><rsup|n>\<rho\><rsub|i>*<space|0.17em>B<rsub|i+1><around|(|r|)><label|>
  </equation>

  and transforming the radial Schrdinger equation into the
  <math|n\<times\>n> generalized banded eigenvalue problem with respect to a
  coefficient vector

  <\equation>
    <math-bf|C>=<around|(|\<rho\><rsub|1>,\<rho\><rsub|2>,\<ldots\>,\<rho\><rsub|n>|)>,<label|>
  </equation>

  which yields <math|n> solutions for every orbital quantum number <math|l>.

  For two states, <math|\<Phi\><rsub|i>> and <math|\<Phi\><rsub|f>>,
  characterized by the quantum numbers <math|<around|{|n<rsub|i>,l<rsub|i>,m<rsub|i>|}>>
  and <math|<around|{|n<rsub|f>,l<rsub|f>,m<rsub|f>|}>>, respectively, the
  time-dependent matrix element <math|V<rsub|f*i><around|(|t|)>=<around|\<langle\>|\<Phi\><rsub|f><around|\||V<around|(|t|)>|\|>*\<Phi\><rsub|i>|\<rangle\>>>
  can also be written in form of Eq.<nbsp><reference|eq:Vfi>, but with

  <\equation>
    <eqsplit|<tformat|<table|<row|<cell|W<rsub|f*i>>|<cell|=(-1)<rsup|l<rsub|f>-m<rsub|f>>(-1)<rsup|l<rsub|f>><sqrt|<around|(|2*l<rsub|f>+1|)>*<around|(|2*l<rsub|i>+1|)>>>>|<row|<cell|>|<cell|\<times\><jjj|l<rsub|f>|1|l<rsub|i>|-m<rsub|f>|0|m<rsub|i>><jjj|l<rsub|f>|1|l<rsub|i>|0|0|0>>>>>>

    <label|>
  </equation>

  and

  <\equation>
    M<rsup|<textrm>>*L<rsub|f*i><around|(|t|)>=F<around|(|t|)>*<big|int>d*r*<space|0.17em>r*<space|0.17em>R<rsub|i><around|(|r|)>*R<rsub|f><around|(|r|)>,<label|>
  </equation>

  <\equation>
    M<rsup|<textrm>>*V<rsub|f*i><around|(|t|)>=-i*A<around|(|t|)>*<big|int>d*r*<space|0.17em>R<rsub|f><around|(|r|)>*<around*|[|<frac|l|r>*R<rsub|i><around|(|r|)>+R<rprime|'><rsub|i><around|(|r|)>|]>.<label|>
  </equation>

  <subsection|Time propagation><label|subsec:TimeProp>

  Within the spectral approach, the integration of the
  TDDE<nbsp>(<reference|eq:TDDE>) and the TDSE<nbsp>(<reference|eq:TDSE>) is
  performed by expanding the function <math|\<Psi\><around|(|t|)>> describing
  the dynamics of the system in the basis of field-free eigenstates
  <math|\<Phi\><rsub|K>>,

  <\equation>
    \<Psi\><around|(|<vr>,t|)>=<big|sum><rsub|K>C<rsub|K><around|(|t|)>*e<rsup|-i*E<rsub|K>*t>*\<Phi\><rsub|K><around|(|<vr>|)><label|eq:PsiExp>
  </equation>

  where the compound index <math|K> represents the full set of quantum
  numbers and the coefficients <math|C<rsub|K>*<around|(|t=-T/2|)>> are set
  to zero for all states except for the initial state for which its value is
  set to 1. Since the quantum number <math|m> is conserved for both cases and
  the ground state is chosen as initial state, the value of <math|m> is fixed
  to <math|1/2> for the relativistic case and to <math|0> for the
  non-relativistic case.

  Substituting Eq.<nbsp>(<reference|eq:PsiExp>) into
  Eq.<nbsp>(<reference|eq:TDDE>) or TDSE<nbsp>(<reference|eq:TDSE>) the
  latter ones are reduced to a system of coupled first-order ordinary
  differential equations,

  <\equation>
    C<rprime|'><rsub|K><around|(|t|)>=<big|sum><rsub|K<rprime|'>>e<rsup|i*<around|(|E<rsub|K>-E<rsub|K<rprime|'>>|)>*t>*<space|0.17em>V<rsub|K*K<rprime|'>><around|(|t|)>*C<rsub|K<rprime|'>><around|(|t|)><space|1em>,<label|>
  </equation>

  which is integrated numerically using a variable-order, variable-step Adams
  solver.

  The ionization yield (after the pulse) is then defined as

  <\equation>
    Y<rsub|<math-up|ion>>=<big|sum><rsub|K><around*|\||C<rsub|K>*<around|(|t=T/2|)>|\|><rsup|2><label|eq:Yion>
  </equation>

  where the summation in Eq.<nbsp>(<reference|eq:Yion>) is performed over all
  discretized continuum states. The convergence can be controlled by varying
  the value of <math|l<rsub|<textrm>>*m*a*x> (or
  <math|j<rsub|<textrm>>*m*a*x>) which limits the number of different
  symmetries involved in the summation<nbsp>(<reference|eq:PsiExp>).

  In the case of the TDDE the question of a proper treatment of the spurious
  states mentioned in Sec.<reference|subsec:RelCalc> arises. The success of
  the spectral approach relies on the completeness of the states included in
  the summation, at least for a given box size. In fact, already in the case
  of the non-relativistic Schrdinger equation the use of a finite box leads
  to the occurrence of non-physical pseudo states (see, e.<space|0.17em>g.,
  <cite|sfa:lamb98a>). In this case it turned out to be in fact important to
  include those states in the spectral expansion, since otherwise some
  relevant part of the Hilbert space is omitted. In order to decide on the
  proper treatment of the spurious states of the Dirac equation (due to the
  <math|B>-spline expansion), a careful check of the relativistic sum
  rules<nbsp><cite|gen:drak81> was performed that also served as a check of
  the proper implementation of the length and velocity forms of the
  dipole-operator matrix elements. On this basis it was concluded that the
  spurious states could be omitted from the basis for solving the TDDE, since
  the sum rules were fulfilled in this case. The agreement of the TDDE
  solutions obtained within the length and the velocity gauge discussed below
  is another indication that the omission of the spurious states is
  appropriate.

  <subsection|Computational details and scaling of the TDSE with
  <math|Z>><label|subsec:Zvar>

  For the sake of consistency, the same <math|B>-spline basis set is used for
  both the relativistic and the non-relativistic treatment. Typically, the
  values <math|k=9> and <math|n=500> are used to construct an almost linear
  knot sequence in which the first 40 intervals increase with a geometric
  progression using <math|g=1.05> and all following intervals have the length
  of the 40th one. Such a choice ensures an accurate numerical description in
  the vicinity of the nucleus and, at the same time, a sufficient
  completeness for a description of the discretized continuum
  <cite|bsp:vann04>. Depending on the nuclear charge <math|Z>, a box size of
  <math|R=<around|(|250/Z|)>*<space|0.17em>a<rsub|0>> is adopted. This choice
  of <math|R> reflects the well-known scaling property of the
  time-independent Schrdinger equation of hydrogenlike systems. With the
  substitution <math|<vr><rprime|'>=<vr>/Z> and
  <math|E<rprime|'>=Z<rsup|2>*E> for the position <math|<vr>> and the energy
  <math|E>, respectively, the eigensolutions for a hydrogenlike system with
  charge <math|Z> reduces to the one of the hydrogen atom with <math|Z=1>.

  Within the dipole approximation this property is preserved also for the
  TDSE, if the pulse parameters are also properly scaled, e.<space|0.17em>g.,
  the time as <math|t<rprime|'>=t/Z<rsup|2>>, the laser frequency as
  <math|\<omega\><rprime|'>=Z<rsup|2>*\<omega\>>, the amplitude of the vector
  potential as <math|A<rsub|0><rprime|'>=Z*A<rsub|0>>, and the laser peak
  intensity as <math|I<rprime|'>=Z<rsup|6>*I>. Since this property does not
  persist in case of the relativistic treatment, and the properly scaled
  solutions of the TDDE are thus not identical anymore, any deviation from
  the non-relativistic prediction based on the scaling relations can be
  classified as a relativistic effect, cf. <cite|sfa:sels09>.

  <section|Results and discussion><label|sec:Res>

  <subsection|Convergence behavior><label|subsec:Conv>

  <\big-figure>
    <image|figure1|0.45tex-text-width|||>
  </big-figure|<label|fig:Jconv> Convergence study with respect to the
  maximal value of the total angular momentum <math|j<rsub|<textrm>>*m*a*x>.
  The relativistic calculations of the ionization yield for an ion with the
  nuclear charge <math|Z=50> exposed to a <math|20>-cycle
  cos<rsup|<math|2>>-shaped laser pulse with peak intensity
  <math|I=5\<times\>10<rsup|23>>W/cm<rsup|<math|2>> and a photon energy of
  <math|500> a.u. are performed using the length (L) or velocity (V) gauge
  either including or excluding the negative energy (NE) states in the
  expansion<nbsp>(<reference|eq:PsiExp>).>

  The handling of the NE solutions of the Dirac equation is an important
  issue and steered considerable attention in the literature, see
  <cite|gen:furs08|sfa:sels09> and references therein. The question is
  whether the NE states should be removed from the basis as long as the
  creation of real positron-electron pair is energetically out of reach. Such
  a situation occurs, for example, in case of ionization of an ion with the
  nuclear charge <math|Z=50> exposed to a pulse with photon energy 500 a.u.
  (see Fig.<nbsp><reference|fig:Jconv>). Whereas only 3 photons are
  sufficient for ionization, more than 70 photons are required for
  positron-electron pair creation. As is demonstrated in
  Fig.<nbsp><reference|fig:Jconv>, the answer to the question of the proper
  treatment of the NE states depends already within the dipole approximation
  adopted here clearly on the gauge and thus the interaction operator used in
  the time propagation. For the length gauge the exclusion of NE states has
  virtually no effect on the final result. In contrast, for the velocity
  gauge the results are obviously different. If the NE states are included in
  the time propagation, the converged result agrees with the one obtained
  using the length gauge, whereas without the NE states the converged result
  differs in this example by a factor of about 1.5. Therefore, these states
  are absolutely necessary for obtaining the correct result.

  From the practical point of view the finding is also interesting, since the
  omission of the NE states and thus half of the total number of states
  reduces the numerical efforts tremendously. Clearly, doubling the number of
  states leads to an increase of the number of operations per time step by a
  factor 4, since the number of transition dipole matrix elements increases
  by this factor. In the present example (and for a given number of
  <math|j<rsub|<textrm>>*m*a*x>) the time propagation in length gauge without
  the NE states is by about a factor of 6 faster compared to the one where
  the NE states are included. The additional time difference (factor of about
  1.5) arises from an increased number of time steps required for convergence
  in the used adaptive time propagation, if the NE states are included. In
  fact, the length-gauge time propagation by itself is found to be about 6
  times faster than the one performed in velocity gauge, even if the NE
  states are included in both of them. This factor is due to the finer time
  grid needed for convergence in velocity gauge. Considering both effects
  together, even a speed-up by a factor of 50 is found when comparing the
  length-gauge calculation without NE states and the velocity-gauge variant
  with NE states that for sufficiently large value of
  <math|j<rsub|<textrm>>*m*a*x> both yield practically identical results.

  However, Fig.<nbsp><reference|fig:Jconv> reveals also that the calculations
  in velocity gauge converge faster with respect to the quantum numbers
  <math|j> included in the calculation. Therefore, the efficiency gain of the
  length gauge is smaller than the value given above. In the concrete example
  shown in Fig.<nbsp><reference|fig:Jconv> the (within better than
  0.1<space|0.17em>%) converged length-gauge calculation
  (<math|j<rsub|<textrm>>*m*a*x=15/2>, without NE states) is by a factor of
  about 40 faster than the (within about 10<math|<rsup|-3><space|0.17em>>%)
  converged velocity-gauge result (<math|j<rsub|<textrm>>*m*a*x=11/2>, with
  NE states). Even compared to the only about <math|0.5<space|0.17em>>%
  converged velocity-gauge result with <math|j<rsub|<textrm>>*m*a*x=9/2>
  (with NE states) there is still a factor of about 30 in time gain. On the
  other hand, the question of the most efficient choice of the gauge depends
  on the laser parameters. If few-photon processes, in the most extreme case
  one-photon ionization at low intensities, are considered, the average
  angular momentum <math|j> transferred to the ion is small. In such a case
  the need for a larger value of <math|j<rsub|<textrm>>*m*a*x> in the
  length-gauge calculation could even overcompensate the gain from the
  exclusion of the NE states. However, if the average number of absorbed
  photons increases (due to a smaller ratio of the photon frequency with
  respect to the ionization potential or due to a higher laser intensity),
  the relative increase in <math|j> due to the slower convergence leads to a
  smaller increase of the total number of states than the inclusion of the NE
  states. In this multiphoton regime calculations in length gauge appear to
  be much more efficient. This finding for the TDDE solution seems to differs
  from the one for the non-relativistic TDSE where the velocity gauge is
  often supposed to converge faster than the length gauge.

  For extremely high intensities around and above the critical field strength
  <math|F<rsub|<math-up|cr>>=c<rsup|3>\<approx\>2.57<space|0.17em>\<times\><space|0.17em>10<rsup|6>>
  where real pair production is possible, the inclusion of the NE states is,
  of course, required also in length gauge. In fact, already for the
  parameters discussed in the context of Fig.<nbsp><reference|fig:Jconv> we
  find a relative deviation between otherwise converged length-gauge results
  with and without NE states of about <math|2.2<space|0.17em>\<times\><space|0.17em>10<rsup|-5>>.
  This appears reasonable, since it is of the order of the (reciprocal) rest
  energy <math|c<rsup|-2>\<approx\>5.3<space|0.17em>\<times\><space|0.17em>10<rsup|-5>>.
  For very high laser intensities the gain from omitting the NE states is
  thus lost and future calculations will have to show whether in that regime
  length-gauge calculations can still profit from the need of a sparser time
  grid, or whether the faster convergence with <math|j> persists in velocity
  gauge and may make this gauge more efficient.

  <\big-figure>
    <image|figure2|0.45tex-text-width|||>
  </big-figure|<label|fig:RPES> Ratio of the ionization yields that are
  obtained by either excluding or including the negative energy states in the
  expansion<nbsp>(<reference|eq:PsiExp>) adopting either length (L) or
  velocity (V) gauge. The calculations are performed for an ion with two
  different values of nuclear charge <math|Z> by varying the wavelength
  <math|\<lambda\>> of a <math|20>-cycle cos<rsup|<math|2>>-shaped laser
  pulse with the peak intensity <math|Z<rsup|6>\<times\>10<rsup|13>>W/cm<rsup|<math|2>>.
  The character of the ionization process changes from single-photon
  ionization (<math|\<lambda\>*Z<rsup|2>=40<space|0.17em>>nm) to three-photon
  ionization (<math|\<lambda\>*Z<rsup|2>=260<space|0.17em>>nm). >

  In <cite|sfa:sels09> it was concluded on the basis of the numerical results
  that the inclusion of the NE states is not crucial for solving the TDDE, if
  the dipole approximation is adopted. This result was found despite the fact
  that the calculation was performed in velocity gauge. Therefore, this
  finding appears to contradict our conclusions. However, it turns out that
  the importance of the inclusion of the NE states depends in fact on the
  character of the multiphoton ionization process, i.<space|0.17em>e. on the
  number of photons. Figure<nbsp><reference|fig:RPES> shows the ratio of the
  ionization yields obtained either with or without inclusion of the NE
  states for both gauges and two values of the nuclear charge <math|Z>. In
  agreement with the findings discussed above, the inclusion of the NE states
  has practically no influence for the length-gauge results, independently of
  the number of photons involved or the nuclear charge. This changes,
  however, if the velocity gauge is used in the time propagation. The
  importance of the NE states increases with the order of the multiphoton
  process (the number of photons required for ionization) and with the
  nuclear charge. Within the one-photon regime there is practically no
  influence of the NE states. Thus the finding in <cite|sfa:sels09> is
  confirmed that even in velocity gauge an inclusion of the NE states is not
  required for calculations in the dipole approximation. However, it is to be
  understood that those findings apply only to the case where one photon is
  sufficient to reach into the ionization continuum. Quite remarkable is also
  the strong dependence of the importance of the NE states on <math|Z>. For
  example, for the wavelength <math|\<lambda\>=260/Z<rsup|2>><space|0.17em>nm
  the exclusion of the NE states leads to a three times smaller value of the
  ionization yield for <math|Z=80>, whereas for <math|Z=40> the decrease is
  only about 10<space|0.17em>%. The <math|Z> dependence can also explain the
  negligible effect of NE states within the dipole approximation found in
  Fig.<space|0.17em>1 of <cite|sfa:sels09> where <math|Z=1> was used.
  Furthermore, only the probability of remaining in the initial ground state
  was considered and this quantity is found to converge much faster than,
  e.<space|0.17em>g., the ionization yield. This could possibly make it also
  less sensitive to the NE states.

  <subsection|Single-photon ionization><label|subsec:1ph>

  As has been discussed in Sec.<nbsp><reference|subsec:Zvar>, the solution of
  the TDSE for different nuclear charges <math|Z> gives identical ionization
  yields, if the laser pulse parameters are scaled properly. For example, the
  insert in Fig.<nbsp><reference|fig:R1ph> shows the non-relativistic
  ionization yields obtained for an ion with the nuclear charge <math|Z>
  exposed to a <math|20>-cycle cos<rsup|<math|2>>-shaped laser pulse with a
  peak intensity of <math|Z<rsup|6>\<times\>10<rsup|11>>W/cm<rsup|<math|2>>
  for photon energies varying in the range between
  <math|15*<space|0.17em>Z<rsup|2><space|0.17em>>eV and
  <math|45*<space|0.17em>Z<rsup|2>><space|0.17em>eV. Since the ionization
  potential of the ion is equal to <math|13.6*<space|0.17em>Z<rsup|2>><space|0.17em>eV,
  the ionization should occur via absorption of a single photon. In order to
  study the relativistic effects in this one-photon ionization regime, the
  TDDE is solved for the same system and for 5 different values of <math|Z>
  (in between 40 and 80 with a stepsize of 10).

  <\big-figure>
    <image|figure3|0.45tex-text-width|||>
  </big-figure|<label|fig:R1ph> Ratios of the relativistic ionization yields
  to the non-relativistic ones (shown in the insert) obtained for 5 different
  values of the nuclear charge <math|Z> by varying the carrier frequency
  <math|\<omega\>> of a <math|20>-cycle cos<rsup|<math|2>>-shaped laser pulse
  with the peak intensity of <math|Z<rsup|6>\<times\>10<rsup|11>>W/cm<rsup|<math|2>>.>

  The ratio of the relativistic to the non-relativistic ionization yield is
  shown in Fig.<nbsp><reference|fig:R1ph>. Two features can be observed.
  First, above <math|18*<space|0.17em>Z<rsup|2><space|0.17em>>eV the ratio
  decreases with increasing photon energy. Thus relativistic effects are more
  pronounced for higher photon frequencies <math|\<omega\>>. As could be
  expected, this effect becomes more and more important as <math|Z>
  increases. Second, a discontinuity develops with increasing <math|Z> at a
  photon energy of about <math|18*<space|0.17em>Z<rsup|2><space|0.17em>>eV.
  Especially for large values of <math|Z> the ratio for the lowest considered
  photon energy drops down substantially for increasing <math|Z>. This is a
  manifestation of the fact that the ionization potential of the ion
  increases as a consequence of the relativistic velocity of an electron in
  the vicinity of strong Coulomb potentials. The shift of the ionization
  potential

  <\equation>
    \<Delta\>*I<rsub|p>=I<rsup|<textrm>>*r*e*l<rsub|p><around|(|Z|)>-I<rsub|p><rsup|<textrm>>*n*r<around|(|Z|)>=c<rsup|2>*<around*|(|1-<sqrt|1-<frac|Z<rsup|2>|c<rsup|2>>>|)>-<frac|Z<rsup|2>|2><label|>
  </equation>

  rapidly increases with increasing <math|Z>. (For example,
  <math|\<Delta\>*I<rsub|p>\<approx\>Z<rsup|4>/<around|(|8*c<rsup|2>|)>> for
  small <math|Z>.) Thus, for <math|Z=80> the absorption of a single photon
  with the energy <math|15*<space|0.17em>Z<rsup|2>><space|0.17em>eV is not
  sufficient for ionization anymore and the character of the ionization
  process changes from single-photon to two-photon ionization. For the
  considered intensities the latter process possesses of course a much
  smaller probability. In fact, the ratio would be even smaller, if the ratio
  at <math|15*<space|0.17em>Z<rsup|2>><space|0.17em>eV would correspond to
  pure two-photon ionization. The finite spectral width of the adopted
  20-cycle laser pulse allows, however, one-photon ionization to occur even
  at this energy and increases thus the ionization yield. Therefore, a finer
  photon-frequency grid in between <math|15*<space|0.17em>Z<rsup|2>><space|0.17em>eV
  and <math|20*<space|0.17em>Z<rsup|2>><space|0.17em>eV would show a much
  smoother behavior than the one visible from Fig.<nbsp><reference|fig:R1ph>.

  In <cite|sfa:sels09> (Fig.<space|0.17em>5) relativistic effects were
  considered by a comparison of the ionization rates obtained with the TDSE
  and the TDDE where the latter was solved for 8 different values of
  <math|Z>. However, there the behavior was studied as a function of the
  laser field amplitude (also scaled by the corresponding non-relativistic
  scaling relations) and for a fixed photon frequency. The authors discuss
  stabilization, since the ionization rate does not increase monotonously
  with the field strength, but instead decreases for intensities beyond about
  <math|F<rsub|0>=1*<space|0.17em>Z<rsup|3>>. The for large values of
  <math|Z> increasing value of <math|F<rsub|0>> for which the ionization rate
  has its maximum is then explained by the stabilization criterion of Gavrila
  (see <cite|sfa:gavr02> and references therein) and the conjecture that due
  to the lower energy of the ground state in the relativistic case the
  condition for the occurrence of stabilization shifts to higher field
  strengths.

  In fact, the dependence of the ionization rates on <math|Z> discussed in
  <cite|sfa:sels09> may be quantitatively understood from the scaling
  relations together with the lowering of the ground-state energy due to
  relativistic effects. This is illustrated in the following way. From the
  condition <math|I<rsup|<textrm>>*r*e*l<rsub|p><around|(|Z|)>=I<rsub|p><rsup|<textrm>>*n*r<around|(|Z<rprime|'>|)>>
  one finds a scaled nuclear charge

  <\equation>
    Z<rprime|'>=<sqrt|2*c<rsup|2>*<around*|(|1-<sqrt|1-Z<rsup|2>/c<rsup|2>>|)>>,<label|eq:Zp>
  </equation>

  for a given true charge <math|Z>. This allows to estimate the relativistic
  ionization rate from a non-relativistic calculation using

  <\equation>
    \<Gamma\><rprime|'><around|(|F<rsub|0>|)>=<around*|(|<frac|Z<rprime|'>|Z>|)><rsup|2>*<space|0.17em>\<Gamma\><around*|(|F<rsub|0><around*|[|<frac|Z|Z<rprime|'>>|]><rsup|3>|)><space|1em>,<label|eq:Ratesc>
  </equation>

  if the dependence of the non-relativistic ionization rate on the photon
  frequency is ignored. In order to obtain non-relativistic ionization rates
  <math|\<Gamma\><around|(|F<rsub|0>|)>>, Floquet calculations were performed
  as a function of the peak amplitude <math|F<rsub|0>> of the electric field
  using program STRFLO<nbsp><cite|sfa:potv98>. They are shown in
  Fig.<nbsp><reference|fig:Floq> and are in reasonable agreement with the
  TDSE rates in<nbsp><cite|sfa:sels09>. Based on the non-relativistic Floquet
  rates the scaling relation (<reference|eq:Ratesc>) allows to estimate the
  relativistic rates that are also shown in Fig.<nbsp><reference|fig:Floq>
  for <math|Z=36>, 54, and 86. The qualitative agreement with the TDDE
  results in Fig.<space|0.17em>5 of <cite|sfa:sels09> is satisfactory and
  especially the shift of the maximum to higher fields is well reproduced.
  However, in agreement with the discussion in <cite|sfa:sels09> the model
  predicts that the maximum of the ionization rate increases monotonically
  with <math|Z>. This is in contrast to the numerical findings in
  <cite|sfa:sels09>.

  <\big-figure>
    <image|figure4|0.45tex-text-width|||>
  </big-figure|<label|fig:Floq> Ionization rate (in units of <math|Z<rsup|2>>
  a.u.) of a hydrogenlike ion exposed to a monochromatic laser field with the
  frequency <math|\<omega\>=Z<rsup|2>> as a function of the amplitude of the
  electric field (given in units of <math|Z<rsup|3>> a.u.) The black solid
  curve presents the (non-relativistic) Floquet ionization rate, whereas the
  other curves present the ionization rates obtained using the scaling
  relation<nbsp><reference|eq:Ratesc> in order to estimate the relativistic
  ionization rates for three different values of <math|Z>. >

  <\big-figure>
    <image|figure5|0.45tex-text-width|||>
  </big-figure|<label|fig:MPI> Relativistic (blue circles) and
  non-relativistic (black circles) ionization yields obtained for an ion with
  the nuclear charge <math|Z=50> exposed to a <math|20>-cycle
  cos<rsup|<math|2>>-shaped laser pulse with a peak intensity of
  <math|5\<times\>10<rsup|22>> W/cm<rsup|<math|2>> and various laser
  wavelengths. Additionally, the non-relativistic ionization yields (red
  squares) for an ion with the nuclear charge <math|Z<rprime|'>=50.88> are
  shown whose non-relativistic ionization potential is equal to the
  relativistic ionization potential of the ion with <math|Z=50>. The
  non-relativistic <math|N>-photon thresholds (<math|N=2-4>) for <math|Z> and
  <math|Z<rprime|'>> are indicated by black and red vertical dashed lines,
  respectively.>

  <subsection|Multiphoton ionization><label|subsec:MPI>

  If many photons are required for ionization, the relativistic results may
  deviate from the non-relativistic ones by an order of magnitude or more.
  This is demonstrated in Fig.<nbsp><reference|fig:MPI> where relativistic
  and non-relativistic ionization yields are compared for an ion with the
  nuclear charge <math|Z=50>. The laser wavelength varies in the range from
  0.05<space|0.17em>nm (2-photon ionization) to 0.15<space|0.17em>nm
  (5-photon ionization). Whereas the general structure of the wavelength
  dependence is similar for both relativistic and non-relativistic
  treatments, the difference in the positions of all pronounced features like
  peaks and minima may result in a substantial discrepancy, if the ion yields
  are compared at a single photon frequency. Obviously, the sharp steps are
  due to the <math|N>-photon channel closings and the peaks are signatures of
  resonantly enhanced multiphoton ionization (REMPI) processes. Their
  positions are directly related to excitation energies and the ionization
  potential, respectively, and both are higher in the relativistic than in
  the non-relativistic case.

  In view of the scaling relation (<reference|eq:Zp>) it is interesting to
  compare the TDDE result (for <math|Z=50>) with the non-relativistic TDSE
  result for the scaled nuclear charge <math|Z<rprime|'>=50.88>. As can be
  seen from Fig.<nbsp><reference|fig:MPI>, the obtained TDSE results deviate
  from the relativistic ones for <math|Z=50> only by a few percent. This
  indicates that the change of the ionization potential is the by far
  dominating relativistic effect, at least if multiphoton ionization is
  described within the dipole approximation. Other possible effects like the
  splitting of (resonant) intermediate states due to spin-orbit coupling are
  thus very small, but can be quantified more easily, after the scaling
  relation has accounted for the main effect. The dominant influence of the
  shift of the ionization potential is likely to depend on the considered
  laser intensity and photon frequency. It should be reminded that the
  Keldysh parameter <math|\<gamma\>=<sqrt|2*<space|0.17em>I<rsub|p>>*\<omega\>/F<rsub|0>>
  <cite|sfa:keld65> varies in Fig.<nbsp><reference|fig:MPI> in between 38.17
  and 12.72. This is deep in the multiphoton regime, in fact even in the
  perturbative one.

  <section|Conclusion><label|sec:Concl>

  Single- and multiphoton ionization of highly charged atomic ions has been
  numerically studied by a direct solution of the time-dependent Dirac
  equation within the dipole approximation. The stationary Dirac equation is
  solved by projecting the radial part onto a <math|B>-spline basis and the
  obtained field-free eigensolutions are used in the subsequent time
  propagation. Results for both length and velocity gauges for describing the
  ion-field interaction are obtained and compared. The inclusion of the
  negative-energy Dirac states for the description of the relativistic
  dynamics is shown to be important in the case of the multiphoton
  ionization, if the velocity gauge is adopted, even if the considered
  intensities and frequencies are too low for allowing non-negligible real
  pair creation. If ionization occurs via absorption of a single photon or
  the time propagation is performed in the length form, the role of negative
  energy states is much less significant.

  Comparing solutions of the time-dependent Dirac and Schrdinger equations
  for the same ion and laser pulses, the relativistic change of the
  ionization potential is demonstrated to dominate other relativistic effects
  in the case of multiphoton ionization. It is shown that this effect is
  successfully accounted for by a simple scaling relation.

  <section*|Acknowledgments>

  The authors acknowledge financial support by the German Ministry for
  Research and Education (BMBF) within the SPARC.de network under grant
  06BY9015, by the COST programme CM<space|0.17em>0702, and by the Fonds der
  Chemischen Industrie. This work was supported in parts by the National
  Science Foundation under Grant No. NSF PHY05-51164.

  <\thebibliography|36>
    <expandafter><ifx><csname>natexlab<endcsname><assign|natexlab|<macro|1|<arg|1>>><fi><expandafter><ifx><csname>bibnamefont<endcsname>

    <assign|bibnamefont|<macro|1|<arg|1>>><fi><expandafter><ifx><csname>bibfnamefont<endcsname>

    <assign|bibfnamefont|<macro|1|<arg|1>>><fi><expandafter><ifx><csname>citenamefont<endcsname>

    <assign|citenamefont|<macro|1|<arg|1>>><fi><expandafter><ifx><csname>url<endcsname>

    <assign|url|<macro|1|<with|font-family|tt|<arg|1>>>><fi><expandafter><ifx><csname>urlprefix<endcsname><assign|urlprefix|<macro|URL
    >><fi><assign|bibinfo|<macro|1|2|<arg|2>>>
    <assign|eprint*|<macro|1|2|<slink|>>><assign|eprint|<macro|2|<eprint*||<arg|2>>>>

    <bibitem-with-key|(1997)|sfa:kyls97a>
    <bibinfo|author|<bibfnamefont|N.<nbsp>J.> <bibnamefont|Kylstra>>,
    <bibinfo|author|<bibfnamefont|A.<nbsp>M.> <bibnamefont|Ermolaev>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|C.<nbsp>J.>
    <bibnamefont|Joachain>>, <bibinfo|journal|J.<space|0.17em>Phys.<space|0.17em>B>
    <with|font-series|bold|<bibinfo|volume|30>>, <bibinfo|pages|L449>
    (<bibinfo|year|1997>).

    <bibitem-with-key|(1997)|sfa:rath97> <bibinfo|author|<bibfnamefont|U.<nbsp>W.>
    <bibnamefont|Rathe>>, <bibinfo|author|<bibfnamefont|C.<nbsp>H.>
    <bibnamefont|Keitel>>, <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Protopapas>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|P.<nbsp>L.>
    <bibnamefont|Knight>>, <bibinfo|journal|J.<space|0.17em>Phys.<space|0.17em>B>
    <with|font-series|bold|<bibinfo|volume|30>>, <bibinfo|pages|L531>
    (<bibinfo|year|1997>).

    <bibitem-with-key|(2004)|sfa:mock04> <bibinfo|author|<bibfnamefont|G.<nbsp>R.>
    <bibnamefont|Mocken>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|C.<nbsp>H.> <bibnamefont|Keitel>>,
    <bibinfo|journal|J.<space|0.17em>Comp.<space|0.17em>Phys.>
    <with|font-series|bold|<bibinfo|volume|199>>, <bibinfo|pages|558>
    (<bibinfo|year|2004>).

    <bibitem-with-key|(2008)|sfa:mock08> <bibinfo|author|<bibfnamefont|G.<nbsp>R.>
    <bibnamefont|Mocken>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|C.<nbsp>H.> <bibnamefont|Keitel>>,
    <bibinfo|journal|Comp.<space|0.17em>Phys.<space|0.17em>Comm.>
    <with|font-series|bold|<bibinfo|volume|178>>, <bibinfo|pages|868>
    (<bibinfo|year|2008>).

    <bibitem-with-key|(1990)|sfa:reis90a>
    <bibinfo|author|<bibfnamefont|H.<nbsp>R.> <bibnamefont|Reiss>>,
    <bibinfo|journal|JOSA B> <with|font-series|bold|<bibinfo|volume|7>>,
    <bibinfo|pages|574> (<bibinfo|year|1990>).

    <bibitem-with-key|(2004)|sfa:fais04> <bibinfo|author|<bibfnamefont|F.<nbsp>H.<nbsp>M.>
    <bibnamefont|Faisal>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|S.><nbsp><bibnamefont|Bhattacharyya>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>Lett.>
    <with|font-series|bold|<bibinfo|volume|93>>, <bibinfo|pages|053002>
    (<bibinfo|year|2004>).

    <bibitem-with-key|(2006)|sfa:klai06> <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Klaiber>>,
    <bibinfo|author|<bibfnamefont|K.<nbsp>Z.> <bibnamefont|Hatsagortsyan>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|C.<nbsp>H.>
    <bibnamefont|Keitel>>, <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>A>
    <with|font-series|bold|<bibinfo|volume|73>>, <bibinfo|pages|053411>
    (<bibinfo|year|2006>).

    <bibitem-with-key|(2009)|sfm:fais09> <bibinfo|author|<bibfnamefont|F.<nbsp>H.<nbsp>M.>
    <bibnamefont|Faisal>>, <bibinfo|journal|J.<space|0.17em>Phys.<space|0.17em>B>
    <with|font-series|bold|<bibinfo|volume|42>>, <bibinfo|pages|171003>
    (<bibinfo|year|2009>).

    <bibitem-with-key|(2002)|sfa:milo02a>
    <bibinfo|author|<bibfnamefont|N.><nbsp><bibnamefont|Milosevic>>,
    <bibinfo|author|<bibfnamefont|V.<nbsp>P.> <bibnamefont|Krainov>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|T.><nbsp><bibnamefont|Brabec>>,
    <bibinfo|journal|J.<space|0.17em>Phys.<space|0.17em>B>
    <with|font-series|bold|<bibinfo|volume|35>>, <bibinfo|pages|3515>
    (<bibinfo|year|2002>).

    <bibitem-with-key|(1995)|sfa:keit95> <bibinfo|author|<bibfnamefont|C.<nbsp>H.>
    <bibnamefont|Keitel>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|P.<nbsp>L.> <bibnamefont|Knight>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>A>
    <with|font-series|bold|<bibinfo|volume|51>>, <bibinfo|pages|1420>
    (<bibinfo|year|1995>).

    <bibitem-with-key|(2002)|sfa:gaie02> <bibinfo|author|<bibfnamefont|L.<nbsp>N.>
    <bibnamefont|Gaier>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|C.<nbsp>H.> <bibnamefont|Keitel>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>A>
    <with|font-series|bold|<bibinfo|volume|65>>, <bibinfo|pages|023406>
    (<bibinfo|year|2002>).

    <bibitem-with-key|(2009)|sfa:hetz09> <bibinfo|author|<bibfnamefont|H.<nbsp>G.>
    <bibnamefont|Hetzheim>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|C.<nbsp>H.> <bibnamefont|Keitel>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>Lett.>
    <with|font-series|bold|<bibinfo|volume|102>>, <bibinfo|pages|083003>
    (<bibinfo|year|2009>).

    <bibitem-with-key|(2009)|sfa:sels09> <bibinfo|author|<bibfnamefont|S.><nbsp><bibnamefont|Selst>>,
    <bibinfo|author|<bibfnamefont|E.><nbsp><bibnamefont|Lindroth>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Bengtsson>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>A>
    <with|font-series|bold|<bibinfo|volume|79>>, <bibinfo|pages|043418>
    (<bibinfo|year|2009>).

    <bibitem-with-key|(2010)|sfa:pind10> <bibinfo|author|<bibfnamefont|M.<nbsp>S.>
    <bibnamefont|Pindzola>>, <bibinfo|author|<bibfnamefont|J.<nbsp>A.>
    <bibnamefont|Ludlow>>, <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Colgan>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>A>
    <with|font-series|bold|<bibinfo|volume|81>>, <bibinfo|pages|063431>
    (<bibinfo|year|2010>).

    <bibitem-with-key|(1990a)|sfa:tang90b>
    <bibinfo|author|<bibfnamefont|X.><nbsp><bibnamefont|Tang>>,
    <bibinfo|author|<bibfnamefont|H.><nbsp><bibnamefont|Rudolph>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Lambropoulos>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>Lett.>
    <with|font-series|bold|<bibinfo|volume|65>>, <bibinfo|pages|3269>
    (<bibinfo|year|1990>a).

    <bibitem-with-key|(1990b)|sfa:tang90>
    <bibinfo|author|<bibfnamefont|X.><nbsp><bibnamefont|Tang>>,
    <bibinfo|author|<bibfnamefont|T.<nbsp>N.> <bibnamefont|Chang>>,
    <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Lambropoulos>>,
    <bibinfo|author|<bibfnamefont|S.><nbsp><bibnamefont|Fournier>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|L.<nbsp>F.>
    <bibnamefont|DiMauro>>, <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>A>
    <with|font-series|bold|<bibinfo|volume|41>>, <bibinfo|pages|5265>
    (<bibinfo|year|1990>b).

    <bibitem-with-key|(1998)|sfa:lamb98a>
    <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Lambropoulos>>,
    <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Maragakis>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Zhang>>,
    <bibinfo|journal|Phys.<space|0.17em>Rep.>
    <with|font-series|bold|<bibinfo|volume|305>>, <bibinfo|pages|203>
    (<bibinfo|year|1998>).

    <bibitem-with-key|(2008)|sfa:nubb08> <bibinfo|author|<bibfnamefont|T.><nbsp><bibnamefont|Nubbemeyer>>,
    <bibinfo|author|<bibfnamefont|K.><nbsp><bibnamefont|Gorling>>,
    <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Saenz>>,
    <bibinfo|author|<bibfnamefont|U.><nbsp><bibnamefont|Eichmann>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|W.><nbsp><bibnamefont|Sandner>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>Lett.>
    <with|font-series|bold|<bibinfo|volume|101>>, <bibinfo|pages|233001>
    (<bibinfo|year|2008>).

    <bibitem-with-key|(2005)|sfm:awas05> <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Awasthi>>,
    <bibinfo|author|<bibfnamefont|Y.<nbsp>V.> <bibnamefont|Vanne>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Saenz>>,
    <bibinfo|journal|J.<space|0.17em>Phys.<space|0.17em>B>
    <with|font-series|bold|<bibinfo|volume|38>>, <bibinfo|pages|3973>
    (<bibinfo|year|2005>).

    <bibitem-with-key|(2006)|sfm:pala06> <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Palacios>>,
    <bibinfo|author|<bibfnamefont|H.><nbsp><bibnamefont|Bachau>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|F.><nbsp><bibnamefont|Martn>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>Lett.>
    <with|font-series|bold|<bibinfo|volume|96>>, <bibinfo|pages|143001>
    (<bibinfo|year|2006>).

    <bibitem-with-key|(2009)|sfm:vann09> <bibinfo|author|<bibfnamefont|Y.<nbsp>V.>
    <bibnamefont|Vanne>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Saenz>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>A>
    <with|font-series|bold|<bibinfo|volume|80>>, <bibinfo|pages|053422>
    (<bibinfo|year|2009>).

    <bibitem-with-key|(2010)|sfm:sans10> <bibinfo|author|<bibfnamefont|G.><nbsp><bibnamefont|Sansone>>,
    <bibinfo|author|<bibfnamefont|F.><nbsp><bibnamefont|Kelkensberg>>,
    <bibinfo|author|<bibfnamefont|J.<nbsp>F.> <bibnamefont|Perez-Torres>>,
    <bibinfo|author|<bibfnamefont|F.><nbsp><bibnamefont|Morales>>,
    <bibinfo|author|<bibfnamefont|M.<nbsp>F.> <bibnamefont|Kling>>,
    <bibinfo|author|<bibfnamefont|W.><nbsp><bibnamefont|Siu>>,
    <bibinfo|author|<bibfnamefont|O.><nbsp><bibnamefont|Ghafur>>,
    <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Johnsson>>,
    <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Swoboda>>,
    <bibinfo|author|<bibfnamefont|E.><nbsp><bibnamefont|Benedetti>>,
    <bibnamefont|et<nbsp>al.>, <bibinfo|journal|Nature>
    <with|font-series|bold|<bibinfo|volume|465>>, <bibinfo|pages|763>
    (<bibinfo|year|2010>).

    <bibitem-with-key|(2010)|sfm:vann10> <bibinfo|author|<bibfnamefont|Y.<nbsp>V.>
    <bibnamefont|Vanne>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Saenz>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>A>
    <with|font-series|bold|<bibinfo|volume|82>>, <bibinfo|pages|011403>
    (<bibinfo|year|2010>).

    <bibitem-with-key|(2008)|sfm:awas08> <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Awasthi>>,
    <bibinfo|author|<bibfnamefont|Y.<nbsp>V.> <bibnamefont|Vanne>>,
    <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Saenz>>,
    <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Castro>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Decleva>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>A>
    <with|font-series|bold|<bibinfo|volume|77>>, <bibinfo|pages|063403>
    (<bibinfo|year|2008>).

    <bibitem-with-key|(2010)|sfm:petr10a>
    <bibinfo|author|<bibfnamefont|S.><nbsp><bibnamefont|Petretti>>,
    <bibinfo|author|<bibfnamefont|Y.<nbsp>V.> <bibnamefont|Vanne>>,
    <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Saenz>>,
    <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Castro>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Decleva>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>Lett.>
    <with|font-series|bold|<bibinfo|volume|104>>, <bibinfo|pages|223001>
    (<bibinfo|year|2010>).

    <bibitem-with-key|(2007)|gen:gran07> <bibinfo|author|<bibfnamefont|I.><nbsp><bibnamefont|Grant>>,
    <em|<bibinfo|title|Relativistic Quantum Theory of Atoms and Molecules>>,
    vol.<nbsp><bibinfo|volume|40> of <em|<bibinfo|series|Atomic, Optical, and
    Plasma Physics>> (<bibinfo|publisher|Springer>, <bibinfo|address|New
    York>, <bibinfo|year|2007>).

    <bibitem-with-key|(1988)|bsp:john88> <bibinfo|author|<bibfnamefont|W.<nbsp>R.>
    <bibnamefont|Johnson>>, <bibinfo|author|<bibfnamefont|S.<nbsp>A.>
    <bibnamefont|Blundell>>, <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Sapirstein>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>A>
    <with|font-series|bold|<bibinfo|volume|37>>, <bibinfo|pages|307>
    (<bibinfo|year|1988>).

    <bibitem-with-key|(1981)|gen:drak81> <bibinfo|author|<bibfnamefont|G.<nbsp>W.<nbsp>F.>
    <bibnamefont|Drake>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|S.<nbsp>P.> <bibnamefont|Goldman>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>A>
    <with|font-series|bold|<bibinfo|volume|23>>, <bibinfo|pages|2093>
    (<bibinfo|year|1981>).

    <bibitem-with-key|(2004)|bsp:shab04> <bibinfo|author|<bibfnamefont|V.<nbsp>M.>
    <bibnamefont|Shabaev>>, <bibinfo|author|<bibfnamefont|I.<nbsp>I.>
    <bibnamefont|Tupitsyn>>, <bibinfo|author|<bibfnamefont|V.<nbsp>A.>
    <bibnamefont|Yerokhin>>, <bibinfo|author|<bibfnamefont|G.><nbsp><bibnamefont|Plunien>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|G.><nbsp><bibnamefont|Soff>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>Lett.>
    <with|font-series|bold|<bibinfo|volume|93>>, <bibinfo|pages|130405>
    (<bibinfo|year|2004>).

    <bibitem-with-key|(2008)|bsp:belo08> <bibinfo|author|<bibfnamefont|K.><nbsp><bibnamefont|Beloy>>
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Derevianko>>,
    <bibinfo|journal|Comp.<space|0.17em>Phys.<space|0.17em>Comm.>
    <with|font-series|bold|<bibinfo|volume|179>>, <bibinfo|pages|310>
    (<bibinfo|year|2008>).

    <bibitem-with-key|(2009)|bsp:gran09> <bibinfo|author|<bibfnamefont|I.<nbsp>P.>
    <bibnamefont|Grant>>, <bibinfo|journal|J.<space|0.17em>Phys.<space|0.17em>B>
    <with|font-series|bold|<bibinfo|volume|42>>, <bibinfo|pages|055002>
    (<bibinfo|year|2009>).

    <bibitem-with-key|(2004)|bsp:vann04> <bibinfo|author|<bibfnamefont|Y.<nbsp>V.>
    <bibnamefont|Vanne>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Saenz>>,
    <bibinfo|journal|J.<space|0.17em>Phys.<space|0.17em>B>
    <with|font-series|bold|<bibinfo|volume|37>>, <bibinfo|pages|4101>
    (<bibinfo|year|2004>).

    <bibitem-with-key|(2008)|gen:furs08> <bibinfo|author|<bibfnamefont|D.<nbsp>V.>
    <bibnamefont|Fursa>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|I.><nbsp><bibnamefont|Bray>>,
    <bibinfo|journal|Phys.<space|0.17em>Rev.<space|0.17em>Lett.>
    <with|font-series|bold|<bibinfo|volume|100>>, <bibinfo|pages|113201>
    (<bibinfo|year|2008>).

    <bibitem-with-key|(2002)|sfa:gavr02> <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Gavrila>>,
    <bibinfo|journal|J.<space|0.17em>Phys.<space|0.17em>B>
    <with|font-series|bold|<bibinfo|volume|35>>, <bibinfo|pages|R147>
    (<bibinfo|year|2002>).

    <bibitem-with-key|(1998)|sfa:potv98> <bibinfo|author|<bibfnamefont|R.<nbsp>M.>
    <bibnamefont|Potvliege>>, <bibinfo|journal|Comp.<space|0.17em>Phys.<space|0.17em>Comm.>
    <with|font-series|bold|<bibinfo|volume|114>>, <bibinfo|pages|42>
    (<bibinfo|year|1998>).

    <bibitem-with-key|(1965)|sfa:keld65> <bibinfo|author|<bibfnamefont|L.<nbsp>V.>
    <bibnamefont|Keldysh>>, <bibinfo|journal|Sov.<space|0.17em>Phys.<space|0.17em>JETP>
    <with|font-series|bold|<bibinfo|volume|20>>, <bibinfo|pages|1307>
    (<bibinfo|year|1965>).
  </thebibliography>
</body>