<TeXmacs|1.99.7>

<style|<tuple|aps|std-latex>>

<\body>
  <doc-data|<doc-title|Electromagnetically Induced Transparency in strongly
  interacting Rydberg Gases>|<doc-date|<date|>>|<doc-author|<author-data|<author-name|C.
  Ates>|<author-affiliation|Max Planck Institute for the Physics of Complex
  Systems, Nthnitzer Strasse 38, 01187 Dresden,
  Germany>>>|<doc-author|<author-data|<author-name|S.
  Sevinli>|<author-affiliation|Max Planck Institute for the Physics of
  Complex Systems, Nthnitzer Strasse 38, 01187 Dresden,
  Germany>>>|<doc-author|<author-data|<author-name|T.
  Pohl>|<author-affiliation|Max Planck Institute for the Physics of Complex
  Systems, Nthnitzer Strasse 38, 01187 Dresden, Germany>>>>

  <abstract-data|<\abstract>
    We develop an efficient Monte-Carlo approach to describe the optical
    response of cold three-level atoms in the presence of EIT and strong
    atomic interactions. In particular, we consider a "Rydberg-EIT medium"
    where one involved level is subject to large shifts due to strong van der
    Waals interactions with surrounding Rydberg atoms. We find excellent
    agreement with much more involved quantum calculations and demonstrate
    its applicability over a wide range of densities and interaction
    strengths. The calculations show that the nonlinear absorption due to
    Rydberg-Rydberg atom interactions exhibits universal behavior.
  </abstract>|<abstract-pacs|42.50.Nn| 32.80.Ee| 42.50.Gy>>

  \ The effect of electromagnetically induced transparency (EIT)
  <cite|EIT_rev> in light-driven multi-level systems continues to play a
  pivotal role in quantum and nonlinear optics. Enabling slow light
  propagation and thus long photon interaction times at low loss levels
  <cite|luim00|hafi99>, EIT media provide a promising route to applications
  in optical communication and quantum information science. Optical
  nonlinearities, however, typically arise from higher order light-atom
  interactions, such that realizations of such applications at very low light
  intensities <cite|bhb09> remain challenging. In this respect, recent
  experimental studies of EIT in cold Rydberg gases
  <cite|moja07|moba08|wepr08|rahe09|pgw10> are opening up new perspectives
  for nonlinear optics on a few photon level. Exploiting the exaggerated
  properties of Rydberg atoms and, in particular, the strong interactions
  among the atoms, nonlinear phenomena can be greatly enhanced in ultracold
  Rydberg gases.

  Recently, several different methods have been used to study laser-driven
  interacting gases <cite|fde10|sgh10|welo08|pode10|slm10>. A simultaneous
  treatment of EIT and long-range interactions, however, poses additional
  challenges. Common meanfield approaches, as successfully applied to
  radiation trapping effects on EIT <cite|fde10>, are found to fail
  <cite|sgh10> due to the large strength and enormous range of the van der
  Waals interaction, which lead to non-negligible correlations between the
  atoms. On the other hand, exact descriptions, based on Hilbert space
  truncation by interaction-blocked many-body states <cite|welo08|pode10>,
  are also inapplicable since there always remains an exponentially large
  number of many-body states involved in the interaction-free probe
  transition.

  Here we present a theoretical approach that allows to obtain the fully
  correlated steady state populations via classical Monte Carlo sampling.
  This is shown to yield the nonlinear optical response to classical light
  fields in the presence of arbitrarily strong atomic interactions. A
  comparison to reduced density matrix calculations shows very good agreement
  for small and moderate densities. Upon proper scaling the simulation
  results reveal a universal behavior of the nonlinear absorption, which
  illustrates the role of Rydberg atom interactions in the emergence of
  dissipative photon-photon interactions.

  The considered Rydberg-EIT level scheme is shown in Fig.<reference|fig1>.
  The signal laser couples the ground state <math|<around|\||1|\<rangle\>>>
  to a low lying state <math|<around|\||2|\<rangle\>>> with Rabi frequency
  <math|\<Omega\><rsub|1>>. State <math|<around|\||2|\<rangle\>>> is coupled
  by a strong control laser (<math|\<Omega\><rsub|2>\<gtr\>\<Omega\><rsub|1>>)
  to a highly excited Rydberg state <math|<around|\||3|\<rangle\>>>. The
  resulting dynamics of a gas composed of <math|N> such independent atoms is,
  thus, governed by the Hamiltonian

  <eqnarray|<tformat|<table|<row|<cell|<label|eq1>H<rsub|0>>|<cell|=>|<cell|-<frac|1|2>*<big|sum><rsub|i=1><rsup|N><around|(|\<Delta\><rsub|1>\|2<rsub|i>|\<rangle\>><around|\<langle\>|2<rsub|i>|\|>+<around|(|\<Delta\><rsub|1>+\<Delta\><rsub|2>|)>\|3<rsub|i>\<rangle\>\<langle\>3<rsub|i>\|>>|<row|<cell|>|<cell|>|<cell|-\<Omega\><rsub|1>\|2<rsub|i>\<rangle\><around|\<langle\>|1<rsub|i>|\|>-\<Omega\><rsub|2>\|3<rsub|i>\<rangle\><around|\<langle\>|2<rsub|i>|\|>+<text|h.c.>)<space|0.27em>.<eq-number>>>>>>

  In addition, the intermediate state <math|<around|\||2|\<rangle\>>>
  radiatively decays with a rate <math|\<gamma\>>, whereas spontaneous decay
  of the long-lived Rydberg level can safely be neglected. For resonant
  driving, each atom settles into a dark state,
  <math|<around|\||d<rsub|i>|\<rangle\>>\<sim\>\<Omega\><rsub|2>\|1<rsub|i>\<rangle\>-\<Omega\><rsub|1>\|3<rsub|i>\<rangle\>>,
  which is immune to the laser coupling and radiative decay <cite|EIT_rev>.
  Consequently, the complex susceptibility <math|\<chi\><rsub|12>> of the
  lower transition vanishes and the medium becomes transparent.

  <\big-figure>
    <resizebox|0.9tex-column-width|!|<image|fig1.eps||||>>
  </big-figure|Illustration of the considered three-level ladder scheme. Two
  laser fields successively couple the states
  <math|<around|\||1|\<rangle\>>>, <math|<around|\||2|\<rangle\>>> and
  <math|<around|\||3|\<rangle\>>>. For isolated atoms, EIT is realized on
  two-photon resonance <math|\<Delta\><rsub|1>=-\<Delta\><rsub|2>>. The van
  der Waals interaction shift <math|C<rsub|6>/r<rsub|i*j><rsup|6>> between
  atoms in the Rydberg state <math|<around|\||3|\<rangle\>>> modifies this
  ideal transparency and leads to a nonlinear optical response of the
  medium.<label|fig1>>

  In the presence of van der Waals interactions

  <\equation>
    <label|eq2>U=<big|sum><rsub|i\<less\>j><frac|C<rsub|6>|<around|\||<math-bf|r><rsub|i>-<math-bf|r><rsub|j>|\|><rsup|6>>\|3<rsub|i>*3<rsub|j>\<rangle\><around|\<langle\>|3<rsub|i>*3<rsub|j>|\|>
  </equation>

  between atoms in state <math|<around|\||3|\<rangle\>>> the situation
  becomes more complex. Note that the van der Waals coefficient
  <math|C<rsub|6>\<sim\>n<rsup|11>> strongly increases with the atom's
  principal quantum number <math|n>. For typical values <math|n\<sim\>60>
  this yields an enhancement of about <math|10<rsup|11>> compared to
  interactions in low-lying states, implying a drastically different
  excitation dynamics. On the one hand, the resulting level shifts lead to a
  strong suppression of Rydberg excitation<cite|Rydexp>, due to an excitation
  blockade of close atoms <cite|lfc01>. On the other hand, the interactions
  perturb the atomic dark states <cite|mmm08|mlw09>, and admix the
  dissipative intermediate state <cite|pgw10|sgh10>. To account for these
  effects, we start from the von Neumann equation

  <\equation>
    <label|eq3>i*<wide|\<rho\>|\<dot\>><rsup|<around|(|N|)>>=<around*|[|H<rsub|0>+U|]>-i*\<cal-L\><around|[|\<rho\><rsup|<around|(|N|)>>|]><space|0.27em>,
  </equation>

  for the <math|N>-body density matrix <math|<wide|\<rho\>|^><rsup|<around|(|N|)>>>
  of the gas. The Lindblad operator <math|\<cal-L\>> describes spontaneous
  decay of the intermediate state, but can also include finite laser band
  widths, denoted by <math|\<gamma\><rsub|12>> and <math|\<gamma\><rsub|23>>,
  respectively.

  To obtain the steady state populations of eq.(<reference|eq3>), we
  transform it to a many-body rate equation. For clarity we start from the
  simple case <math|C<rsub|6>=0> for which the <math|N>-particle density
  matrix factorizes, and eq.(<reference|eq3>) reduces to a set of single-atom
  optical Bloch equations. Upon adiabatic elimination the dynamics of the
  atomic level populations follows

  <\equation>
    <label|eq4><frac|<text|d>|<text|d>t><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|\<rho\><rsub|11><rsup|<around|(|i|)>>>>|<row|<cell|\<rho\><rsub|22><rsup|<around|(|i|)>>>>|<row|<cell|\<rho\><rsub|33><rsup|<around|(|i|)>>>>>>>|)>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-a<rsub|11>>|<cell|a<rsub|12>>|<cell|a<rsub|13>>>|<row|<cell|a<rsub|21>>|<cell|-a<rsub|22>>|<cell|a<rsub|23>>>|<row|<cell|a<rsub|31>>|<cell|a<rsub|32>>|<cell|-a<rsub|33>>>>>>|)><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|\<rho\><rsub|11><rsup|<around|(|i|)>>>>|<row|<cell|\<rho\><rsub|22><rsup|<around|(|i|)>>>>|<row|<cell|\<rho\><rsub|33><rsup|<around|(|i|)>>>>>>>|)><space|0.17em>,
  </equation>

  where the coefficients <math|a<rsub|\<alpha\>*\<beta\>>> are
  straightforwardly obtained as a function of the laser parameters.

  This is a common approximation to the long-time dynamics of two-level
  systems <cite|ae75>. Applications of the described elimination procedure to
  three-level atoms are, however, rather scarce, since it often leads to
  negative transition rates <cite|wila60>. To resolve this obstacle we
  propose a linear transformation that removes the negativity and, at the
  same time, preserves the correct steady states of the underlying von
  Neumann equation (<reference|eq3>). For
  <math|\<Omega\><rsub|1>\<less\>\<Omega\><rsub|2>> this is accomplished by
  adding a correction matrix

  <\widetext>
    <\equation>
      <label|trafo>\<Delta\><math-bf|a>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|\<sigma\><rsub|21>*<around|(|1-R<rsub|21>|)>+\<sigma\><rsub|32>>|<cell|\<sigma\><rsub|31>*<around|(|1-R<rsub|31>|)>>>|<row|<cell|-\<sigma\><rsub|21>+\<sigma\><rsub|31>-\<sigma\><rsub|32>*R<rsub|32>>|<cell|-\<sigma\><rsub|21>*<around|(|1-R<rsub|21>|)>-\<sigma\><rsub|31>*R<rsub|31>>|<cell|\<sigma\><rsub|21>*R<rsub|21>+\<sigma\><rsub|32>*<around|(|1-R<rsub|32>|)>>>|<row|<cell|\<sigma\><rsub|21>-\<sigma\><rsub|31>+\<sigma\><rsub|32>*R<rsub|32>>|<cell|-\<sigma\><rsub|32>+\<sigma\><rsub|31>*R<rsub|31>>|<cell|-\<sigma\><rsub|21>*R<rsub|21>-\<sigma\><rsub|31>*<around|(|1-R<rsub|31>|)>-\<sigma\><rsub|32>*<around|(|1-R<rsub|32>|)>>>>>>|)><space|0.27em>,
    </equation>
  </widetext>

  \ to the original coefficient matrix <math|<with|font-series|bold|a>> in
  eq.(<reference|eq4>), where <math|\<sigma\><rsub|\<alpha\>*\<beta\>>=<around|(|<around|\||a<rsub|\<alpha\>*\<beta\>>|\|>-a<rsub|\<alpha\>*\<beta\>>|)>/2>
  and <math|R<rsub|\<alpha\>*\<beta\>>> are free parameters. With this
  definition of the <math|\<sigma\><rsub|\<alpha\>*\<beta\>>> any negative
  rate coefficient <math|a<rsub|\<alpha\>*\<beta\>>> is set to zero, while
  the additional terms compensate for the according changes of the steady
  states. Consequently, the parameters <math|R<rsub|\<alpha\>*\<beta\>>> are
  chosen such that the transformed rate equations
  <math|<wide|\<b-rho\>|\<dot\>><rsup|<around|(|i|)>>=<around|(|<with|font-series|bold|a>+\<Delta\><with|font-series|bold|a>|)>*\<b-rho\><rsup|<around|(|i|)>>>
  yield steady states identical to those of the original equation
  <math|<wide|\<b-rho\>|\<dot\>><rsup|<around|(|i|)>>=<with|font-series|bold|a>*\<b-rho\><rsup|<around|(|i|)>>>.
  Explicitely, this condition gives

  <\subequations>
    <eqnarray|<tformat|<table|<row|<cell|R<rsub|21>>|<cell|=>|<cell|<frac|a<rsub|33>*<around*|(|a<rsub|21>+a<rsub|22>|)>+a<rsub|23>*<around*|(|a<rsub|31>-a<rsub|32>|)>|a<rsub|31>*<around*|(|a<rsub|22>+a<rsub|23>|)>+a<rsub|21>*<around*|(|a<rsub|32>+a<rsub|33>|)>><eq-number>>>|<row|<cell|R<rsub|31>>|<cell|=>|<cell|<frac|a<rsub|22>*<around*|(|a<rsub|31>+a<rsub|33>|)>+a<rsub|32>*<around*|(|a<rsub|21>-a<rsub|23>|)>|a<rsub|31>*<around*|(|a<rsub|22>+a<rsub|23>|)>+a<rsub|21>*<around*|(|a<rsub|32>+a<rsub|33>|)>><eq-number>>>|<row|<cell|R<rsub|32>>|<cell|=>|<cell|<frac|a<rsub|21>*<around*|(|a<rsub|32>+a<rsub|33>|)>+a<rsub|31>*<around*|(|a<rsub|23>+a<rsub|33>|)>|a<rsub|22>*<around*|(|a<rsub|31>+a<rsub|33>|)>+a<rsub|32>*<around*|(|a<rsub|21>-a<rsub|23>|)>><eq-number>>>>>>
  </subequations>

  \ for the transformation coefficients in eq.(<reference|trafo>).

  Having established a proper rate equation description for the single
  particle dynamics, the approach can be extended to interacting atoms. As
  shown in <cite|app07>, this is straightforwardly accomplished by replacing
  the upper detuning of each atom by <math|\<Delta\><rsub|2><rsup|<around|(|i|)>>=\<Delta\><rsub|2>-<big|sum><rprime|'><rsub|j\<neq\>i>U<rsub|i*j>>.
  Here, the sum only runs over atoms in the Rydberg state
  <math|<around|\||3|\<rangle\>>>, such that the local detunings and, hence,
  the individual atomic transition rates become dynamical variables that
  depend on the entire many-body state of the system. As a result one obtains
  a many-body rate equation where the dynamics of the <math|i>th atom is
  governed by its individual transition rates
  <math|<wide|a|~><rsub|\<alpha\>*\<beta\>><rsup|<around|(|i|)>>> which
  depend on the actual Rydberg atom configuration through the local detuning
  <math|\<Delta\><rsub|2><rsup|<around|(|i|)>>>. Although this rate equation
  still covers the exponentially large number of all <math|3<rsup|N>>
  many-body states, it can be efficiently solved via classical Monte-Carlo
  sampling. Starting from the initial state with all atoms in their ground
  state <math|<around|\||\<alpha\>|\<rangle\>>=<around|\||1|\<rangle\>>>, the
  steady state is obtained by performing repeated random transitions
  according to the probabilities <math|p<rsub|\<alpha\>\<to\>\<beta\>><rsup|<around|(|i|)>>=\<delta\>*t\<cdot\><wide|a|~><rsub|\<alpha\>*\<beta\>><rsup|<around|(|i|)>>>
  to make a transition within a time step <math|\<delta\>*t>. In this way, we
  are able to obtain the fully correlated <math|N>-body state-distribution of
  the particles, and in particular the average level populations
  <math|\<rho\><rsub|\<alpha\>*\<alpha\>>=N<rsup|-1>*<big|sum><rsub|i>\<rho\><rsub|\<alpha\>*\<alpha\>><rsup|<around|(|i|)>>>.
  Since

  <\equation>
    <label|ab><text|Im><around|(|\<rho\><rsub|12>|)>=<frac|\<gamma\>|\<Omega\><rsub|1>>*\<rho\><rsub|22><space|0.27em>,
  </equation>

  the Monte-Carlo approach also allows to determine the imaginary part of the
  complex optical susceptibility

  <\equation>
    <label|suscept>\<chi\><rsub|12>=<frac|2*\<mu\><rsub|12><rsup|2>*\<rho\><rsub|0>|\<epsilon\><rsub|0>*\<hbar\>*\<Omega\><rsub|1>>*\<rho\><rsub|12><space|0.17em>,
  </equation>

  where <math|\<mu\><rsub|12>> denotes the dipole moment of the probe
  transition and <math|\<epsilon\><rsub|0>> is the permittivity of vacuum. In
  addition, the resonant real part of <math|\<chi\><rsub|12>> can be obtained
  from the nonlinear absorption spectrum using the Kramers-Kronig relations.

  <\big-figure>
    <image|fig2.eps|0.95tex-column-width|||><label|fig2>
  </big-figure|Calculated probe beam absorption spectra for a Rubidium
  Rydberg-EIT medium at various densities. The lines show results of the
  Monte-Carlo simulations compared to quantum calculations based on a
  reduced-density matrix expansion <cite|sgh10> (symbols). The atoms are
  resonantly (<math|\<Delta\><rsub|2>=0>) excited to <math|55*S> Rydberg
  states. The probe and coupling beams have Rabi frequencies of
  <math|\<Omega\><rsub|1>=1>MHz and <math|\<Omega\><rsub|2>=2>MHz,
  respectively, with linewidths of <math|\<gamma\><rsub|12>=\<gamma\><rsub|23>=100>kHz.>

  In the following we consider the specific case of a Rubidium Rydberg gas.
  The atoms are excited by the probe laser (<math|\<Omega\><rsub|1>>) from
  the <math|<around|\||5*S<rsub|1/2>|\<rangle\>>=<around|\||1|\<rangle\>>>
  ground state to the <math|<around|\||5*P<rsub|3/2>|\<rangle\>>=<around|\||2|\<rangle\>>>
  intermediate state, while the coupling laser resonantly
  (<math|\<Delta\><rsub|2>=0>) drives the transition between
  <math|<around|\||5*P|\<rangle\>>> and a
  <math|<around|\||n*S<rsub|1/2>|\<rangle\>>=<around|\||3|\<rangle\>>>
  Rydberg state with <math|\<Omega\><rsub|2>=2>MHz. We include the
  intermediate state decay of <math|\<gamma\>=6.1>MHz and further assume
  realistic linewidths <cite|pgw10> of <math|\<gamma\><rsub|12>=\<gamma\><rsub|23>=100>kHz
  for both beams.

  Fig.<reference|fig2> shows the calculated absorption spectrum at different
  densities for <math|\<Omega\><rsub|1>=1>MHz and <math|n=55>. In order to
  check our results at low densities we have also performed simulations based
  on a reduced-density expansion of the von Neumann equation
  (<reference|eq3>), as described in <cite|sgh10>. The excellent agreement
  between these entirely different calculations attests to the quality of
  both approaches. At the lowest density, Rydberg-Rydberg atom interactions
  are ineffective, giving a small resonant absorption due the finite laser
  linewidths <math|\<gamma\><rsub|12>> and <math|\<gamma\><rsub|23>>. At
  higher densities the interactions lead to a significant suppression of the
  resonant transmission. In accord with recent experiments <cite|pgw10>, the
  position and width of the absorption minimum are, however, largely
  unaffected by the interactions, which are as large as
  <math|C<rsub|6>*<around|(|4*\<pi\>*\<rho\>/3|)><rsup|2>\<approx\>20>MHz at
  the highest density of <math|5\<cdot\>10<rsup|9>>cm<rsup|<math|-3>>.
  Apparently, this is due to the van der Waals blockade that prohibits
  simultaneous Rydberg excitation of close atoms.

  The density dependence of the complex susceptibility is shown in
  Fig.<reference|fig3>. For low and moderate densities our Monte Carlo
  calculations and the reduced-density matrix expansion <cite|sgh10> give
  consistent results for both the real and imaginary part of
  <math|\<rho\><rsub|12>> (and hence of <math|\<chi\><rsub|12>>). As expected
  from a low-density expansion the latter tends to deviate with increasing
  densities, with significant deviations occurring only at rather high
  densities <math|\<gtrsim\>10<rsup|10>>cm<rsup|<math|-3>>. As we show in the
  following, the Monte-Carlo calculations yield the expected high density
  limit, and should thus applicable for arbitrary densities.

  <\big-figure>
    <image|fig3.eps|0.95tex-column-width|||><label|fig3>
  </big-figure|Complex susceptibility <math|\<chi\><rsub|12>> as a function
  of the gas density <math|\<rho\><rsub|0>> under EIT conditions,
  <math|\<Delta\><rsub|1>=\<Delta\><rsub|2>=0>. The reduced density matrix
  calculations (symbols) start to deviate from the Monte Carlo results
  (lines) for densities <math|\<gtrsim\>10<rsup|10>>cm<rsup|<math|-3>>.
  Remaining parameters are identical to those of Fig.<reference|fig2>.>

  As the density increases the imaginary part of <math|\<chi\><rsub|12>>
  starts to saturate while the real part develops a maximum and goes to zero
  at high densities. In fact, this behavior can be understood from simple
  arguments. At very high densities, a single Rydberg atom strongly shifts a
  large number of surrounding atoms out of resonance. As a consequence the
  Rydberg laser appears far detuned for the majority of atoms, such that they
  act as an effective two-level medium. Taking the limit
  <math|\<Delta\><rsub|2><rsup|<around|(|i|)>>\<rightarrow\>\<infty\>> the
  asymptotic high-density steady state value of <math|\<rho\><rsub|12>>,
  hence, approaches

  <eqnarray|<tformat|<table|<row|<cell|<text|Im><around|[|\<rho\><rsub|12><rsup|<around|(|\<infty\>|)>>|]>>|<cell|=>|<cell|<frac|\<Omega\><rsub|1>*\<gamma\>|g<rsub|12>*\<gamma\><rsup|2>+g<rsub|23>*\<Omega\><rsub|1><rsup|2>><eq-number><label|scale>>>>>>

  where <math|g<rsub|12>=<around|(|\<gamma\>+\<gamma\><rsub|12>|)>/\<gamma\>>,
  <math|g<rsub|23>=<around|(|2*\<gamma\>+3*\<gamma\><rsub|23>|)>/<around|(|\<gamma\>+\<gamma\><rsub|23>|)>>.
  This simple limit is indicated by the horizontal arrow in
  Fig.<reference|fig3> and gives very good agreement with the Monte Carlo
  simulations.

  <\big-figure>
    <image|fig4.eps|0.99tex-column-width|||><label|chi>
  </big-figure|(a) Nonlinear absorption coefficient
  <math-up|Im><math|<around|[|\<chi\><rsub|12>|]>> as a function of the
  density of Rubidium atoms for <math|\<Omega\><rsub|2>=2>MHz and
  <math|\<gamma\><rsub|12>=\<gamma\><rsub|23>=0>. The different symbols
  correspond to different principal quantum numbers and probe Rabi
  frequencies: <math|\<Omega\><rsub|1>=1>MHz, <math|n=50> (squares),
  <math|\<Omega\><rsub|1>=0.5>MHz, <math|n=50> (circles),
  <math|\<Omega\><rsub|1>=1>MHz, <math|n=70> (triangles) and
  <math|\<Omega\><rsub|1>=1>MHz, <math|n=50> (diamonds). (b) After proper
  scaling [cf. eqs.(<reference|scale>) and (<reference|scale>)] all data
  points follow the simple universal scaling relation
  eq.(<reference|universal>) (line).>

  It thus appears reasonable to employ the derived high-density limit as a
  natural scale for <math|\<chi\><rsub|12>>. In addition we can use the
  interaction blockade of Rydberg excitation <cite|lfc01> to rescale the gas
  density, i.e. the abscissa in Fig.<reference|fig3>. Comparing the Rydberg
  atom density <math|\<rho\><rsub|<math-up|ryd>>=\<rho\><rsub|0>*N<rsup|-1>*<big|sum><rsub|i>\<rho\><rsub|33><rsup|<around|(|i|)>>>
  obtained from the Monte Carlo calculation to the corresponding value
  <math|\<rho\><rsub|<math-up|ryd>><rsup|<around|(|0|)>>> for vanishing
  interactions one obtains the fraction

  <\equation>
    <label|scale>f<rsub|<math-up|bl>>=<frac|\<rho\><rsub|<math-up|ryd>><rsup|<around|(|0|)>>|\<rho\><rsub|<math-up|ryd>>>-1
  </equation>

  of suppressed Rydberg excitations. Re-expressing the total atomic density
  through eq.(<reference|scale>) and scaling the probe beam absorption by
  eq.(<reference|scale>), yields a universal dependence of
  <math|<wide|\<chi\>|~><rsub|12>=\<chi\><rsub|12>/\<chi\><rsub|12><rsup|<around|(|\<infty\>|)>>>
  on the laser parameters, atomic density and interaction strength. We have
  verified this behavior for a wide range of parameters, some of which are
  exemplified in Fig.<reference|chi> for <math|\<gamma\><rsub|12>=\<gamma\><rsub|23>=0>
  (Fig.<reference|chi>a). Indeed, all data points collapse on a single curve
  (Fig.<reference|chi>b) described by

  <\equation>
    <label|universal><wide|\<chi\>|~><rsub|12>=<frac|f<rsub|<math-up|bl>>|1+f<rsub|<math-up|bl>>><space|0.27em>.
  </equation>

  This simple formula nicely illustrates the effects of excitation blocking
  on the optical susceptibility of the Rydberg-EIT medium: For
  <math|f<rsub|<math-up|bl>>\<less\>1> one finds a nonlinear absorption
  proportional to the blockade fraction, which, however, saturates at the
  two-level limit <math|\<chi\><rsub|12><rsup|<around|(|\<infty\>|)>>> for
  <math|f<rsub|<math-up|bl>>\<gtrsim\>1>, i.e. at the onset of a strong
  excitation blockade. Since <math|f<rsub|<math-up|bl>>\<sim\>\<Omega\><rsub|1><rsup|4>>
  for weak Rydberg excitation <cite|hnp10> this implies a finite cubic
  nonlinearity, as observed in <cite|pgw10>.

  In conclusion, we have presented a numerical method that permits to explore
  the optical response of an EIT medium in the presence of strong atomic
  interactions. In particular, we considered, Rydberg-Rydberg atom
  interactions, which yield strong photon-photon interactions, manifested in
  a nonlinear <math|\<Omega\><rsub|1>>-dependence of the optical
  susceptibility. At small atomic densities our Monte Carlo results are in
  excellent agreement with reduced-density matrix calculations, but in
  addition are shown to be applicable over a much wider range of densities
  and interaction strengths. Beyond the present calculations, the described
  approach permits efficient simulations of very large atom numbers, which in
  future studies should enable detailed comparisons with experiments. Besides
  illuminating the effect of Rydberg interactions, the revealed universal
  behavior of the probe absorption may be of use in experiments, by
  permitting quick estimates of optical nonlinearities and allowing to
  determine the medium absorption from pure population measurements. While we
  have primarily focussed on nonlinear absorption phenomena the developed
  approach can also be used to study the optical response of far-detuned EIT
  media and, thus, to explore prospects for realizing strong coherent
  photon-photon interactions.

  <thebibliography|99|<bibitem|EIT_rev>M. Fleischhauer, A. Imamoglu, and J.P.
  Marangos, Rev. Mod. Phys. <with|font-series|bold|77>, 633
  (2005).<bibitem|hafi99>S. E. Harris, J. E. Field, and A. Imamoglu, Phys
  Rev. Lett. <with|font-series|bold|64>, 1107 (1990).<bibitem|luim00>M. D.
  Lukin and A. Imamoglu, Phys. Rev. Lett. <with|font-series|bold|84>, 1419
  (2000).<bibitem|bhb09>M. Bajcsy et al., Phys. Rev. Lett.
  <with|font-series|bold|102>, 203902 (2009).<bibitem|moja07>A.K. Mohapatra,
  T.R. Jackson, and C.S. Adams, Phys. Rev. Lett. <with|font-series|bold|98>,
  113003 (2007).<bibitem|moba08>A.K. Mohapatra et al., Nature Phys.
  <with|font-series|bold|4>, 890 (2008).<bibitem|wepr08>K.J. Weatherill et
  al., J. Phys. B <with|font-series|bold|41>, 201002
  (2008).<bibitem|rahe09>U. Raitzsch et al., New J. Phys.
  <with|font-series|bold|11>, 055014 (2009).<bibitem|pgw10>J.D.Pritchard et
  al., Phys. Rev. Lett. 105, 193603 (2010)<bibitem|fde10>R. Fleischhaker,
  T.N. Dey, and J. Evers, Phys. Rev. A <with|font-series|bold|82>, 013815
  (2010).<bibitem|sgh10>H. Schempp et al., Phys. Rev. Lett.
  <with|font-series|bold|104>, 173602 (2010).<bibitem|welo08>H. Weimer, et
  al., Phys. Rev. Lett. <with|font-series|bold|101>, 250601
  (2008).<bibitem|pode10>T. Pohl, E. Demler, and M.D. Lukin, Phys. Rev. Lett.
  <with|font-series|bold|104>, 043002 (2010).<bibitem|slm10>J. Schachenmayer,
  I. Lesanovsky, A. Micheli and A.J. Daley, New J. Phys.
  <with|font-series|bold|12> 103044 (2010).<bibitem|Rydexp>D. Tong et al.,
  Phys. Rev. Lett. <with|font-series|bold|93>, 063001 (2004); K. Singer et
  al., Phys. Rev. Lett. <with|font-series|bold|93>, 163001 (2004); T. Vogt et
  al., Phys. Rev. Lett. <with|font-series|bold|97>, 083003 (2006); R.
  Heidemann et al., Phys. Rev. Lett. 99, 163601 (2007).<bibitem|lfc01>M.D.
  Lukin et al., Phys. Rev. Lett. <with|font-series|bold|87>, 037901
  (2001).<bibitem|mmm08>D. Moller, L.B. Madsen, and K. Molmer, Phys. Rev.
  Lett. <with|font-series|bold|100>, 170504 (2008).<bibitem|mlw09>M. Mller
  et al., Phys. Rev. Lett. <with|font-series|bold|102>, 170502
  (2009).<bibitem|ae75>L. Allen, and J.H. Eberly,
  <with|font-shape|italic|Optical Resonance and Two-level Atoms> (Wiley, New
  York, 1975).<bibitem|wila60>L.R. Wilcox and W.E. Lamb, Phys. Rev.
  <with|font-series|bold|119>, 1915 (1960).<bibitem|app07>C. Ates et al.,
  Phys. Rev. A <with|font-series|bold|76>, 013413 (2007).<bibitem|hnp10>N.
  Henkel, R. Nath, and T. Pohl Phys. Rev. Lett. <with|font-series|bold|104>,
  195302 (2010).>
</body>