<TeXmacs|1.99.7>

<style|<tuple|aps|std-latex>>

<\body>
  <doc-data|<doc-title|Absorption Imaging of Ultracold Atoms on Atom
  Chips>|<doc-author|<author-data|<author-name|David<nbsp>A.<nbsp>Smith<rsup|<math|1>>,
  Simon<nbsp>Aigner<rsup|<math|2>>, Sebastian<nbsp>Hofferberth<rsup|<math|3>>,
  Michael<nbsp>Gring<rsup|<math|1>>, Mauritz<nbsp>Andersson<rsup|<math|4>>,
  Stefan<nbsp>Wildermuth<rsup|<math|2>>, Peter<nbsp>Krger<rsup|<math|5>>,
  Stephan<nbsp>Schneider<rsup|<math|1>>, Thorsten<nbsp>Schumm<rsup|<math|1>>,
  Jrg<nbsp>Schmiedmayer<rsup|<math|1,2>>>|<author-affiliation|<rsup|<math|1>>
  Vienna Center for Quantum Science and Technology, Atominstitut, TU Wien,
  Vienna, Austria>|<author-affiliation|<rsup|<math|2>> Physikalisches
  Institut, Universitt Heidelberg, Heidelberg,
  Germany>|<author-affiliation|<rsup|<math|3>> Harvard-MIT Center for
  Ultracold Atoms, Harvard University, USA>|<author-affiliation|<rsup|<math|4>>
  School of Information and Communication Technology, KTH, Stockholm,
  Sweden>|<author-affiliation|<rsup|<math|5>> Midlands Ultracold Atom
  Research Centre, University of Nottingham, UK>>>>

  <abstract-data|<\abstract>
    Imaging ultracold atomic gases close to surfaces is an important tool for
    the detailed analysis of experiments carried out using atom chips. We
    describe the critical factors that need be considered, especially when
    the imaging beam is purposely reflected from the surface. In particular
    we present methods to measure the atom-surface distance, which is a
    prerequisite for magnetic field imaging and studies of atom
    surface-interactions.
  </abstract>>

  <section|Introduction>

  Microtraps created above microfabricated surfaces, or atom chips
  <cite|Folman2000>, are a promising approach towards the precise
  manipulation of ultracold atoms. A variety of trapping, guiding and
  transporting potentials have been realised using current-carrying wires
  <cite|Folman2000|Folman2002|Fortagh2007|Reichel1999|Mue99|Dekker2000|Cassettari00|Cas00b|hans01conveyor>,
  atom manipulation with electric fields has been integrated
  <cite|Krueger2003>, and formation of Bose-Einstein condensates (BECs) has
  been demonstrated <cite|Ott2001|Haensel2001b>. Ultracold atoms held in
  close proximity to the chip surface are versatile probes for atom-surface
  interactions <cite|Lin04>, local magnetic fields
  <cite|Wildermuth2005b|Guent05> and current flow irregularities
  <cite|Wildermuth2006|Aigner2008>. Furthermore, microwave fields have been
  used to coherently manipulate internal states
  <cite|Treutlein2004|Deutsch2010> and radio-frequency (RF) fields have been
  used to form double-well potentials <cite|Lesanovsky2006|Hofferberth2006>
  that coherently split a BEC and form an interferometer
  <cite|Schumm2005b|Boehi2009>. These advances enable new routes to implement
  quantum information processing <cite|Calarco2000|Treutlein2006|Charron2006>
  and the detailed study of 1d quantum many-body systems
  <cite|Hofferberth2007b|Hofferberth2008|Armijo2010|VanAmerongen2008>.

  In experiments atoms are held and manipulated at short distances (a few
  microns) from the chip surface. A main measurement tool is absorption
  imaging <cite|Ketterle1999b> and a thorough understanding of the
  disturbances caused by the close atom chip surface is essential for the
  analysis of atom chip experiments. In this paper, we describe the key
  ingredients for imaging atomic clouds close to the chip surface and give
  examples of specific implementations. We cover three different scenarios,
  two of which involve reflecting the imaging beam from the atom chip
  surface, showing that reflecting at grazing incidence produces a standing
  wave that strongly influences the images.

  <section|Basics of Absorption Imaging><label|sec:AbsTheory>

  Absorption imaging, where the attenuation of a laser beam passing through
  an atom cloud is measured, is the workhorse of ultracold atom experiments
  <cite|Ketterle1999b>. The shadow cast by the atom cloud onto the CCD allows
  an estimation of the atomic column density. In the case of low atom
  numbers, the laser light is chosen to be resonant with an atomic
  transition, whereas off-resonant phase-contrast imaging offers a
  non-destructive imaging alternative for large column densities (large atom
  numbers). Here we only consider imaging with resonant light.

  <subsection|Basic Optical Setups>

  Figure<nbsp><reference|fig:translong> shows a schematic of three different
  imaging configurations. When imaging atoms close to the chip surface
  <cite|PhysRevA.67.023612> (Figs.<nbsp><reference|fig:translong>(a)
  and<nbsp><reference|fig:translong>(b)) diffraction and/or reflection of the
  imaging beam is unavoidable . For images taken far from the chip
  Fig.<nbsp><reference|fig:translong>(c)) the influence of the surface
  becomes negligible and this configuration operates as in standard
  absorption imaging. In the rest of the paper <math|\<theta\>> describes the
  angle of incidence of the imaging beam with respect to the chip surface.
  For <math|\<theta\>=0<rsup|\<circ\>>> the imaging beam propagates parallel
  to the surface of the atom chip. For <math|0\<less\>\<theta\>\<leq\>90<rsup|\<circ\>>>
  the imaging beam is reflected from the surface.

  <with|par-columns|1|<big-figure|<with|par-mode|center|<image|fig1.eps|17cm|||><label|fig:translong>>|Sketch
  of Imaging Configurations (not to scale). (a)
  <with|font-shape|italic|Grazing Incidence Imaging>. The imaging beam is
  reflected off the atom chip surface and the atom cloud (blue circle)
  produces two shadows. For the direct image, the imaging beam first reflects
  off the atom chip surface, then interacts with the atom cloud. For the
  mirror image, the imaging beam first interacts with the atom cloud, then
  reflects off the atom chip. (b) <with|font-shape|italic|Normal Incidence
  Imaging> provides the location of the atom cloud relative to the structures
  on the atom chip surface. (c) <with|font-shape|italic|Time-of-flight
  Imaging>, where the atom cloud is far from the atom chip surface.>>

  A typical imaging configuration uses a two-lens setup to focus the image of
  the atom cloud onto the CCD. Lens 1 is positioned at (or close to) its
  infinity optical working point from the atom cloud (such that the lens
  collimates the diffracted light) and lens 2 is used to form the image.

  The atomic samples on atom chips are usually in a very elongated
  quasi-one-dimensional configuration. In
  <with|font-shape|italic|longitudinal> imaging the probe beam is parallel to
  the elongated extent of the atom cloud and integrates over the full length
  of the cloud. In <with|font-shape|italic|transversal> imaging the probe
  beam is orthogonal to the long axis of the cloud, allowing the study of
  properties along the quasi-1d cloud. The short extent of the cloud in the
  transversal direction, especially for in situ images or after a short time
  of flight, allows a relatively small depth of field for transversal
  imaging, and consequently higher resolution. In contrast, the resolution of
  a longitudinal imaging system is limited by the large extent of the cloud
  which requires a depth of field up to several hundred microns, thus putting
  a lower bound on the achievable resolution. We define here the axes
  convention that will be used below: the <math|x>-direction is the direction
  of gravity, the <math|y>-direction is along the longitudinal direction of
  the atom cloud, and the <math|z>-direction is along the (horizontal)
  transverse direction of the atom cloud.

  <subsection|Resonant Atom-Light Interaction>

  In our absorption imaging we use resonant light. If the incoming intensity
  <math|I<rsub|<mathrm>>*i*n> is sufficiently below saturation, the
  attenuation of the incident probe beam is given by

  <\equation>
    <frac|I<rsub|<mathrm>>*o*u*t|I<rsub|<mathrm>>*i*n>=exp
    (-n*\<sigma\>).<label|eq:absorption>
  </equation>

  <math|I<rsub|<mathrm>>*o*u*t> is the outgoing (i.e. unscattered) intensity,
  <math|n> the column density of the atoms and <math|\<sigma\>> the
  absorption cross section of the specific atomic transition. For large
  intensities <math|\<sigma\>> has to be multiplied by a factor
  <math|1/<around|(|1+I<rsub|<mathrm>>*i*n/I<rsub|<mathrm>>*s*a*t|)>> to
  account for saturation effects (<math|I<rsub|<mathrm>>*s*a*t> is the
  saturation intensity of the optical transition). Estimating <math|n> relies
  on knowing both <math|I<rsub|<mathrm>>*i*n> and
  <math|I<rsub|<mathrm>>*o*u*t>. Experimentally, a CCD camera is used to take
  two pictures: one without atoms giving <math|I<rsub|<mathrm>>*i*n> and one
  with atoms giving <math|I<rsub|<mathrm>>*o*u*t>, from which one can then
  calculate the density profile of the atom cloud using
  eq.<nbsp><reference|eq:absorption>. The division of the two images
  (<math|I<rsub|<mathrm>>*o*u*t/I<rsub|<mathrm>>*i*n>) mostly eliminates the
  effects of any inhomogeneous spatial intensity distribution. However,
  ultimately, detection is limited by photon shot
  noise<nbsp><cite|Bucker2009>.

  <section|Experimental Implementation><label|sec:ChipSetup>

  The imaging systems described here have been implemented in atom chip
  setups in Heidelberg/Vienna. We typically load <math|\<gtr\>10<rsup|6>>
  cold (<math|\<less\>10*\<mu\><math-up|K>>) Rb atoms into a selected chip
  trap. Using RF evaporative cooling we create either an ultracold thermal
  cloud or a BEC <cite|Wildermuth2004>.

  Our atom chips have been discussed in detail
  in<nbsp><cite|Groth2004|Trinker2008>. For imaging it is important that
  their high-quality gold surfaces are exceptionally clean and excellent
  mirrors. Scattered light comes predominantly from the thin etchings
  (typically <math|\<less\><space|0.17em>10*<space|0.17em>\<mu\>>m) that
  define the wire structures. Multilayer atom chips <cite|Trinker2008> may
  have distinct surface profiles that have to be taken into account.

  The imaging light is guided to the experiment using a single-mode
  polarization-preserving optical fibre. The light expanding from the fibre
  core is collimated using a precision achromat and sent through a
  high-quality optical window into the vacuum chamber containing the atom
  chip and the atom cloud. In most of our imaging systems we use optics built
  from two lenses, as in Fig. <reference|fig:translong>. For details on
  specific systems, see section<nbsp><reference|sec:TwoLens>.

  <with|par-columns|1|<big-figure|<with|par-mode|center|<image|fig2.eps|16cm|||><label|fig:ShadowsIm><label|fig:Fig5p2>>|(a,<space|0.17em>b)
  Images without atoms (<math|I<rsub|<mathrm>>*i*n>) with (a) the imaging
  beam propagating parallel to chip surface and (b) the imaging beam
  reflected from chip surface with <math|\<theta\>=2<rsup|\<circ\>>>. The
  dark region at the top is the shadow cast by the chip and its mounting. The
  red boxes represent the region where the atom cloud would be located in
  situ or for short times of flight. The strong horizontal fringes are due to
  diffraction from the edges of the chip. The inclination of the beam allows
  the diffraction effects to be moved in the image relative to the position
  of the atom cloud. The circular fringes and other structures are due to
  small dust particles in the beam path. (c,<space|0.17em>d) Reflecting the
  imaging beam off the atom chip surface results in a standing wave (d) and 2
  clouds in the image (c) because the atom cloud (blue circle) is passed by
  two different beam paths. Path (1) is mapped by the imaging system to a
  real image, path (2) to a mirror image. The image in (c) would lie in the
  area denoted in (b).>>

  <section|Grazing-Incidence Imaging><label|sec:TransIm>

  The propagation of the imaging beam (almost) parallel to the atom chip
  surface results in diffraction from the surface edge, as seen in
  Fig.<nbsp><reference|fig:ShadowsIm>(a)). Even though intensity variations
  are vastly reduced in the final absorption image, residual noise much
  larger than photon shot noise usually remains. A more uniform image in the
  region of the atom cloud can be achieved by inclining the imaging beam such
  that it reflects from the chip surface (Fig.<nbsp><reference|fig:translong>(a))<nbsp><cite|PhysRevA.67.023612>,
  moving the diffraction effects within the image, as can be seen in
  Figs.<nbsp><reference|fig:ShadowsIm>(a)
  and<nbsp><reference|fig:ShadowsIm>(b).

  When the imaging beam is reflected from the chip surface, two beam paths
  traverse the cloud (Fig.<nbsp><reference|fig:ShadowsIm>(d)). One first
  passes through the atom cloud, then reflects from the atom chip surface.
  The second path first reflects from the atom chip surface, then passes
  through the atom cloud. This creates two images, their separation <math|d>
  measures the distance <math|h> of the atoms from the chip surface
  (<math|d=2*h*cos \<theta\>>). At an angle of incidence of
  <math|\<theta\>\<sim\>2<rsup|\<circ\>>>, one can typically observe
  two-shadow images for cloud-surface distances up to
  <math|\<sim\>300*\<mu\>>m. At very small <math|h> the two shadows merge
  into one, dictated by the resolution of the imaging system.

  At grazing angles of incidence one has to consider carefully the
  polarization of the imaging beam. Circularly polarized light does not
  preserve its polarization upon reflection from the gold surface and creates
  a polarization grating above the surface, with both effects leading to a
  poorly defined imaging situation. Linear polarization is preserved but
  results in a standing wave above the surface (Fig. <reference|fig:Fig5p2>).
  Consequently, a simple geometrical picture of imaging by reflecting the
  imaging beam from the surface neglects important details which need to be
  considered in detail.

  <subsection|Reflection and Standing Waves><label|sec:Reflec>

  The illumination of the atomic cloud by a standing wave is highly
  inhomogeneous. Atoms in the nodes of the standing wave experience very low
  intensity, scatter little light and therefore contribute little to the
  absorption signal. The image of the atomic sample is therefore highly
  dependent on the size and position of the atom cloud (or features in the
  cloud that one wishes to image) relative to the standing wave. For
  780<nbsp>nm light (relevant for Rb), the period of the standing wave varies
  from 390<nbsp>nm for <math|\<theta\>=90<rsup|\<circ\>>> to
  <math|\<gtr\>>22<nbsp><math|\<mu\>>m for
  <math|\<theta\>\<less\>1<rsup|\<circ\>>>.

  For an atomic cloud with a Gaussian width <math|w>, the total scattered
  power is given by

  <\equation>
    P<rsub|<math-up|sc>>=2*P<rsub|0>*<around|[|1-cos
    <around|(|2*k<rsub|x>*h|)>*e<rsup|-k<rsub|x><rsup|2>*w<rsup|2>>|]>,<label|eq:ScattPow>
  </equation>

  where <math|P<rsub|0>> is the power that would be scattered by the same
  absorber in a single plane wave of intensity <math|I<rsub|<math-up|in>>>.
  The cloud probes the local intensity of the standing wave.

  For <math|k<rsub|x>*w<nbsp>\<less\>\<less\><nbsp>1> (i.e., the cloud is
  small compared to the period of the standing wave), the scattered power is
  determined by the local intensity at the position of the atoms and is
  therefore modulated depending on the position within the standing wave. As
  the phase of the standing wave is fixed by the surface, this modulation of
  the scattered power can be used as a reference ruler for measuring the
  distance to the surface (see section<nbsp><reference|sec:Ruler>).

  For <math|k<rsub|x>*w<nbsp>\<gtr\>\<gtr\><nbsp>1>, the scattered power
  becomes independent of the position within one period of the standing wave.
  It approaches twice the amount obtained from illumination by a single plane
  wave of intensity <math|I<rsub|<math-up|in>>>. This is the regime of
  geometric optics. The light passing through the cloud can be thought of as
  coming from two beams (Fig.<nbsp><reference|fig:Fig5p2>(e)), where one beam
  hits the cloud directly and the other one is first reflected by the chip
  surface. Consequently, the influence of the standing wave can be reduced by
  inclining the probe beam by a large enough angle so that the typical
  standing wave periodicity is much smaller then the transverse sizes under
  interest, as used in the microscopy scans in <cite|Aigner2008>.

  <with|par-columns|1|<big-figure|<with|par-mode|center|<image|fig3.eps|11cm|||><label|fig:Fig5p3>>|The
  total scattered power <math|P<rsub|s*c>> for trapped condensates at
  different heights above a wire. The blue and green curves show the result
  for in-plane and out-of-plane linear polarization of the imaging beam,
  which have a small relative phase shift caused by the different boundary
  conditions of the standing wave at the mirror surface. The angle of
  incidence of the imaging beam <math|\<theta\>> was
  4.2<rsup|<math|\<circ\>>>. The jump in signal between <math|h=20> and
  <math|h=25> is due to wires of different heights obscuring part of the
  beams (see Fig.<nbsp><reference|fig:diffheights>). Imaging System 2 in
  section<nbsp><reference|sec:TwoLens> was used in this case.>>

  <subsection|The Standing Wave as a Ruler><label|sec:Ruler>

  By varying the position of a thin cloud
  (<math|k<rsub|x>*w<nbsp>\<less\>\<less\><nbsp>1>) and counting the minima
  and maxima of the detected scattered power, it should be possible to
  determine the absolute position above the atom chip surface. Figure
  <reference|fig:Fig5p3> shows the result of such a measurement. The total
  scattered power <math|P<rsub|s*c>> has been measured for trapped
  condensates at different heights above the surface of the atom chip. The
  blue curve shows the result for an imaging beam which is linearly
  <with|font-shape|italic|p>-polarized in the plane of incidence, whereas the
  green curve is for linear <with|font-shape|slanted|s>-polarization. As can
  be seen, the measurements do not follow a simple harmonic modulation: phase
  shifts and changes in the modulation amplitude appear. These artifacts are
  caused by the details of the wire structures on the chip surface. The
  dominant effect is the different heights of the wires
  (Fig.<nbsp><reference|fig:diffheights>) which, besides casting shadows,
  results in a phase shift of the reflected beam that is proportional to the
  local surface structure height. As the reflected beam has to propagate a
  significant distance to reach the position of the atomic cloud, diffraction
  has a significant influence on the observed patterns.

  <with|par-columns|1|<big-figure|<with|par-mode|center|<image|fig4.eps|15cm|||><label|fig:diffheights><label|fig:Fig5p6>>|(a-c).
  Imaging close to wires of different heights. The three scenarios show the
  atom cloud (blue circle) above different parts of the chip in the situation
  where the atom chip surface has wires of different heights. Shadows cast by
  the wires into the imaging beam result in part of the cloud not being
  imaged in each case. (d) Angular aliasing. If a plane wave component
  scattered by the atom cloud is reflected by the surface (dashed line), it
  exits under an angle that is already occupied by a wave component that
  travels directly away from the surface.>>

  A second effect is connected to the non-ideal boundary conditions of a real
  gold surface. The phase shift that occurs upon reflection is not exactly
  the one expected from an ideal conductor and depends upon the angle of
  incidence <math|\<theta\>> and polarization
  (Fig.<nbsp><reference|fig:Fig5p3>).

  <subsection|Angular Aliasing><label|sec:AngAliasing>

  A different modification of the image results from diffraction and
  scattering from the atomic cloud. Figure<nbsp><reference|fig:Fig5p6>(d)
  sketches the basic scenario for the situation where the incident plane wave
  is reflected by the mirror surface and then passes through the atomic
  cloud. If the size of this cloud is large, then the image is dominated by a
  geometric shadow that propagates along the same direction as the plane
  wave. However, as the cloud becomes smaller, important components of the
  scattered wave occupy a larger angular spread relative to the direction of
  the plane wave. As long as this spread is small compared to the angle
  between the imaging beam and the atom chip surface, all the light
  propagates away from the mirror: a lens will reconstruct the true wavefront
  in the object plane. This situation changes when the angle spread of the
  scattered wave becomes large enough that a significant fraction propagates
  towards the mirror surface. This part of the wave is reflected and wrongly
  mapped to an angle under which another part of the wave travels directly
  away from the mirror. This aliasing effect is most important in the regime
  of grazing incidence imaging.

  <subsection|Wavefront Propagation>

  The fine details of the imaging depend on the light propagation close to
  the surface of the atom chip. For a full understanding we implemented a
  numerical model of the absorption imaging setup, including the specific
  properties of the surface and the imaging lenses. Such a model includes
  diffraction and scattering of the propagating wave by the chip and, of
  course, by the atoms.

  We consider an linearly s-polarized optical plane wave propagating mainly
  along the <math|z>-direction with <math|k>-vector
  <math|<wide|k|\<vect\>>=<around|(|k<rsub|x>,k<rsub|y>,k<rsub|z>|)>> and
  wavelength <math|\<lambda\>=2*\<pi\>/k>. We assume that in the plane
  <math|z=z<rsub|0>> the optical amplitude is given by
  <math|U<around|(|x,y,z<rsub|0>|)>> in the scalar approximation. The
  propagator for relating <math|U<around|(|x,y,z<rsub|0>|)>> to the amplitude
  in a later plane <math|U*<around|(|x,y,z<rsub|0>+\<Delta\>*z|)>> is given
  by <cite|SalehTeich>

  <eqnarray|<tformat|<table|<row|<cell|K<around|(|\<nu\><rsub|x>,\<nu\><rsub|y>|)>>|<cell|=>|<cell|exp
  <around*|(|-i*2*\<pi\><sqrt|1/\<lambda\><rsup|2>-\<nu\><rsub|x><rsup|2>-\<nu\><rsub|y><rsup|2>>*\<Delta\>*z|)><eq-number><label|propagator>>>>>>

  where <math|\<nu\><rsub|i>=sin <around|(|\<phi\><rsub|i>|)>/\<lambda\>\<approx\>\<phi\><rsub|i>/\<lambda\>>
  in the paraxial approximation and <math|\<phi\><rsub|i>> is the wave vector
  angle. Since this propagator is diagonal in the angular representation it
  can be conveniently implemented in the Fourier representation
  <cite|SalehTeich>:

  <\widetext>
    <eqnarray|<tformat|<table|<row|<cell|V<around|(|\<nu\><rsub|x>,\<nu\><rsub|y>,z<rsub|0>|)>>|<cell|=>|<cell|<big|int><rsub|-\<infty\>><rsup|\<infty\>><big|int><rsub|-\<infty\>><rsup|\<infty\>>U<around|(|x,y,z<rsub|0>|)>*e<rsup|-i*2*\<pi\>*<around|(|\<nu\><rsub|x>*x+\<nu\><rsub|y>*y|)>>*d*x*d*y<eq-number><label|fft>>>|<row|<cell|U*<around|(|x,y,z<rsub|0>+\<Delta\>*z|)>>|<cell|=>|<cell|<big|int><rsub|-\<infty\>><rsup|\<infty\>><big|int><rsub|-\<infty\>><rsup|\<infty\>>K<around|(|\<nu\><rsub|x>,\<nu\><rsub|y>|)>*V<around|(|\<nu\><rsub|x>,\<nu\><rsub|y>,z<rsub|0>|)>*e<rsup|-i*2*\<pi\>*<around|(|\<nu\><rsub|x>*x+\<nu\><rsub|y>*y|)>>*d*x*d*y<eq-number>>>>>>
  </widetext>

  \ i.e. <math|V<around|(|\<nu\><rsub|x>,\<nu\><rsub|y>,z<rsub|0>|)>> is the
  Fourier transform of <math|U<around|(|x,y,z<rsub|0>|)>>, and the amplitude
  <math|U*<around|(|x,y,z<rsub|0>+\<Delta\>*z|)>> at a point
  <math|z<rsub|0>+\<Delta\>*z> is related to
  <math|U<around|(|x,y,z<rsub|0>|)>> through the propagator
  <math|K<around|(|\<nu\><rsub|x>,\<nu\><rsub|y>|)>>. Numerically, the above
  can be efficiently implemented using the fast Fourier transform (FFT),
  which we utilise in the following calculations.

  The optical propagation now consists of the following steps. The initial
  wavefront is considered to be a wide Gaussian (wide with respect to the
  chip structures) with a small adjustable angle <math|\<theta\>> to the chip
  surface. The wavefront is truncated by the chip edge and the first
  propagation step is to the chip centre. For propagation over the chip
  (mirror) surface, a reflecting boundary condition at the mirror surface is
  implemented with a phase shift <math|\<delta\>=-\<pi\>> (for s-polarized
  light). At the centre of the chip, the atoms absorb, at their location,
  part of the light. The such modified light is propagated to the end of the
  chip and then to the first lens in the imaging system. The wavefront is
  truncated by the first lens (which leads to a finite optical resolution)
  and subsequently propagated through the Fourier plane, the second lens,
  then finally to the detector plane. This last step also involves an
  adjustable defocus. Finally, the intensity at the detector is down-sampled
  to the pixel resolution of the CCD. In order to calculate the absorption
  signal, two propagations are made: one with atoms present (resulting in
  <math|I<rsub|<mathrm>>*o*u*t> in terms of CCD images discussed previously)
  and one without atoms present (<math|I<rsub|<mathrm>>*i*n>). The resulting
  signal is calculated in the same way as for the real experimental images.

  <with|par-columns|1|<big-figure|<with|par-mode|center|<image|fig5.eps|13cm|||><label|fig:propagation>>|(a)
  Simulation and (b) experimental data of absorption images for varying
  distance between the atom cloud and the chip surface. Shown are vertical
  line densities for different trap distances, with two separate absorption
  positions emerging as the distance between the atom cloud and the chip
  increases (Fig.<nbsp><reference|fig:Fig5p2>). It can be seen that many of
  the features resulting from interference effects due to the reflecting
  surface, such as dark fringes where the atoms are located, are well
  reproduced by the simulation. The good agreement between theory and
  experiment allows for an accurate calibration of the trap distance from the
  surface, which in turn allows for precise calibration of the magnetic
  fields applied to form the magnetic trap. Imaging System 1 in
  section<nbsp><reference|sec:TwoLens> was used in this case.>>

  Figure<nbsp><reference|fig:propagation>(a) shows the results of simulating
  the imaging of an atom cloud at various heights above the chip surface for
  an actual experimental implementation. The corresponding experimental data
  for in situ absorption images of the atom cloud is shown in
  Fig.<nbsp><reference|fig:propagation>(b), where for each individual trap
  height the image was integrated in the direction parallel to the chip
  surface to obtain the line density. Experiment and simulation are in
  remarkable agreement. In accordance with the simple geometric picture
  (Fig.<nbsp><reference|fig:translong>(a)), two lines of images emerge with
  increasing height above the chip. Due to the effect of the standing wave
  above the surface, atoms are detected with different clarity at different
  heights. In addition, intricate details emerge which are related to
  scattering and diffraction of the imaging light from the chip and the
  atoms. Clearly, to find a good position for imaging, a full understanding
  of the wave propagation close to the surface is essential. Only then will a
  comparison between experimental data and simulation allow an accurate
  determination of the trap height <math|h> for each image. With the
  precisely known current in the chip wire, this yields a very good
  calibration of the homogeneous magnetic bias field applied to form the atom
  chip traps, and faithful calculation of atom positions for other trapping
  parameters.

  <with|par-columns|1|<big-figure|<with|par-mode|center|<image|fig6.eps|13cm|||><label|fig:Comparison><label|fig:Fourier>>|Extracting
  the height above the chip by Fourier method. (a) Fourier transform
  <math|<wide|I|~><rsub|<mathrm>>*s*c<around|(|k<rsub|x>|)>> of (b) the
  scattered intensity <math|I<rsub|<mathrm>>*s*c<around|(|x|)>>. The
  transverse wave vector <math|k<rsub|x>> has been translated to the
  propagation angle <math|\<beta\>> of the corresponding plane wave
  component. The green curve shows a fit of the model
  eq.<nbsp><reference|eq:Fourier> to the data, the red curve shows the
  envelope <math|e*x*p(-k<rsup|2><rsub|x>*w<rsup|2>/4>), where <math|w> is
  from a fit to the experimental data <math|I<rsub|<mathrm>>*s*c<around|(|x|)>>
  shown in (b), which shows the scattered intensity profile
  <math|I<rsub|<mathrm>>*s*c<around|(|x|)>> together with the profile
  obtained from the fit in Fourier space (green line). (c) Comparing height
  estimation methods: The blue curve has been obtained by taking the distance
  directly from <math|I<rsub|<mathrm>>*s*c<around|(|x|)>> to obtain <math|h>,
  whereas the green curve is the result of the Fourier method. The
  experimental control parameter is nearly linear in height above the surface
  and is related to the magnetic field controlling the magnetic trap. The
  Fourier approach presents the more stable and less noisy method. Imaging
  System 2 in section<nbsp><reference|sec:TwoLens> was used in this case.>>

  <subsection|Fourier Analysis><label|sec:Fourier>

  Although it is instructive to analyze the full wave propagation, Fourier
  analysis provides a powerful method to ascertain the distance between the
  atom cloud and the surface by neglecting frequency components associated
  with deleterious effects. An experimentally determined absorption profile
  (Fig.<nbsp><reference|fig:Fourier>(b)) of the scattered intensity
  <math|I<rsub|<mathrm>>*s*c<around|(|x|)>> can be decomposed into its
  Fourier components <math|<wide|I|~><rsub|<mathrm>>*s*c<around|(|k<rsub|x>|)>>.
  If the scattered intensity is well described by two Gaussian curves of
  width <math|2*w>, separated by the distance <math|2*h>, the real part of
  the Fourier transform of <math|I<rsub|<mathrm>>*s*c<around|(|x|)>> can then
  be written as follows:

  <\equation>
    <wide|I|~><rsub|<mathrm>>*s*c<rsup|<mathrm>><nbsp>m*o*d*e*l<around|(|k<rsub|x>|)>\<propto\>cos
    <around|(|k<rsub|x>*h|)><nbsp>exp (-k<rsub|x><rsup|2>*w<rsup|2>/4).<label|eq:Fourier>
  </equation>

  This simple model of the Fourier transform
  <math|<wide|I|~><rsub|<mathrm>>*s*c<rsup|<mathrm>><nbsp>m*o*d*e*l> can be
  fitted to the Fourier transform of the experimental profile
  <math|<wide|I|~><rsub|<mathrm>>*s*c<rsup|<mathrm>><nbsp>e*x*p>. The
  distance <math|h> can then be extracted, using only the small
  <math|k<rsub|x>> component of the experimental spectrum, which is affected
  little by the aliasing problem of angles and the high frequency noise in
  <math|I<rsub|<mathrm>>*s*c<rsup|<mathrm>><nbsp>e*x*p>.
  Figure<nbsp><reference|fig:Fourier> shows a typical example of a scattered
  intensity profile <math|I<rsub|<mathrm>>*s*c<around|(|x|)>> and its Fourier
  transform <math|<wide|I|~><rsub|<mathrm>>*s*c<around|(|k<rsub|x>|)>>.
  Figure<nbsp><reference|fig:Fourier>(b) shows both the original
  <math|I<rsub|<mathrm>>*s*c<around|(|x|)>> and that calculated from the fit
  to <math|<wide|I|~><rsub|<mathrm>>*s*c<around|(|k<rsub|x>|)>>. This Fourier
  method circumnavigates the problem of dealing with the noise in
  <math|I<rsub|<mathrm>>*s*c<around|(|x|)>> directly. In comparison to a
  direct evaluation of <math|h> from <math|I<rsub|<mathrm>>*s*c<around|(|x|)>>,
  the Fourier method is also significantly more stable, as demonstrated in
  Fig.<nbsp><reference|fig:Comparison>(c).

  <section|Orthogonal-Angle-of-Incidence Imaging><label|sec:SmallAngle>

  Orthogonal-angle-of-incidence imaging (<math|\<theta\>\<sim\>90<rsup|\<circ\>>>)
  is primarily used to locate the atom cloud relative to the chip structures
  (Fig.<nbsp><reference|fig:translong>(b)). The imaging beam is reflected
  from the gold surface of the chip and hence interacts with the atom cloud
  twice, giving two images. For atoms close to the surface, both images are
  in focus and overlap with each other nearly perfectly. However, when the
  atom cloud is further from the chip, the two shadows separate and in many
  cases only one shadow can be in focus. With decreasing <math|\<theta\>> the
  two shadows also separate further laterally.

  This imaging method relies even more on high-quality reflection from the
  chip surface. Image quality is very sensitive to light scattering and
  diffraction due to residual surface roughness and the gaps between the
  structures defining the wires on the atom chip. The image quality also
  depends on the position of the atoms. It can be excellent if the atoms are
  far away from wire edges, for example, above the centre of a broad wire, as
  shown in Fig. <reference|fig:VertImage>. Images degrade for atoms located
  close to the wire edges because near-field diffraction effects make it
  difficult to interpret the images.

  In our implementation of orthogonal-angle-of-incidence imaging
  (Fig.<nbsp><reference|fig:VertImage>), we introduce a small deviation from
  normal incidence (<math|\<theta\>\<sim\>84<rsup|\<circ\>>>), just large
  enough so that the incoming imaging beam can pass the imaging objective
  lens. The input imaging beam is sent through an optical fibre (from which
  it is collimated to have a diameter of approximately 2 cm) and reflected
  from the atom chip surface. The atom cloud absorption is imaged by a
  two-lens system that has a working distance of approximately 13 cm (Imaging
  System 3 in section<nbsp><reference|sec:TwoLens>).

  <with|par-columns|1|<big-figure|<with|par-mode|center|<image|fig7.eps|12cm|||><label|fig:VertImage><label|fig:LongituImage>>|<with|font-shape|italic|(left)>
  Orthogonal-angle-of-incidence imaging of an atomic cloud above a broad 100
  <math|\<mu\>>m wide Z-shaped trapping wire. (a) The direct image reveals
  the features on the chip. The atom cloud is just visible in the center of
  the central broad wire. (b) Processed absorption picture (divided by a
  reference image without atoms). The atoms are clearly visible and the
  speckle patterns are reduced. (Imaging System 3
  section<nbsp><reference|sec:TwoLens>). <with|font-shape|italic|(right)>:
  Longitudinal imaging. (c) in situ image, 80 <math|\<mu\>> m away from the
  chip surface showing a BEC that has been split by <math|\<sim\>> 45
  <math|\<mu\>>m using a RF dressed-state double-well potential. (d) Image of
  time-of-flight matter-wave interference of two BECs after 15<nbsp>ms time
  of flight<nbsp><cite|Schumm2005b>. (Imaging System 4
  section<nbsp><reference|sec:TwoLens>).>>

  <section|Imaging Far from the Chip Surface and Longitudinal
  Imaging><label|sec:LongIm>

  When imaging far from the atom chip surface, the imaging beam can be passed
  parallel to the chip surface, as shown in
  Fig.<nbsp><reference|fig:translong>(c). At distances <math|\<gtr\>50>
  <math|\<mu\>>m from the surface, the effects of the diffraction from the
  chip edge (Fig.<nbsp><reference|fig:ShadowsIm>(a),(b)) and chip structures
  are less deleterious to the image quality. This imaging configuration can
  be used for both transverse and longitudinal imaging.

  The longitudinal imaging system is typically chosen to work at a lower
  resolution, smaller f-number, compared to the transverse imaging direction,
  mainly because the atom clouds have a large extension along the imaging
  beam, and therefore require imaging with a larger depth of field.
  Additionally, in our setups, the horizontal MOT beams for initial atom
  cooling and the longitudinal imaging beam are overlapped with polarizing
  beam-splitter cubes, which places limitations on how close to the atom
  cloud the first imaging lens can be placed.

  Figure<nbsp><reference|fig:LongituImage> shows two examples of longitudinal
  images. Figure<nbsp><reference|fig:LongituImage>(c) is an in situ image of
  a Bose-Einstein condensate (BEC) that has been split in a double-well
  potential 80 <math|\<mu\>>m away from the chip.
  Figure<nbsp><reference|fig:LongituImage>(d) shows a time-of-flight image of
  matter-wave interference between two BECs released from a double-well
  potential <cite|Schumm2005b>. In this case, the resolution of the imaging
  system must be good enough to observe the interference fringes whilst
  having a sufficiently large depth of field to keep the entire length of the
  cloud in focus. Imaging system 4, as detailed in
  section<nbsp><reference|sec:TwoLens>, was used for these images.

  <section|Image Quality Optimisation><label|sec:ImQual>

  Generally, the raw CCD images contain large amplitude fringes and speckle
  arising from the interference of spuriously scattered light with the
  imaging beams<nbsp><reference|fig:ShadowsIm>. In principle, these fringes
  can be divided out when the attenuation is calculated from the two recorded
  images (<math|I<rsub|<mathrm>>*o*u*t> and <math|I<rsub|<mathrm>>*i*n>).
  However, even small shifts in the position of structures in the imaging
  beam path (e.g. due to vibrations) can lead to significant changes in the
  speckle pattern and large disturbances in the resulting absorption image.
  To minimize these disturbances we usually implement the following:

  <\itemize>
    <item>Low-noise (in terms of loudness) light beam shutters are used to
    block laser light. The shutters are mechanically isolated from the laser
    table.

    <item>All optical elements are attached as rigidly as possible onto the
    laser table to avoid vibrations and all stray light at optical elements
    in the beam path is minimised. Covering the complete imaging beam path
    with dust-free tubes (whether plastic or card) not only prevents optical
    elements from being soiled with dust but additionally avoids air
    turbulence.

    <item>Any fans operating in the CCD cameras for cooling are operated in a
    pulsed mode and are switched off several seconds before the images are
    taken.

    <item>Good overlap of the two images (atom cloud and reference images)
    can be reached if the delay time between the two images is reduced as
    much as possible. A frame-transfer camera enables a shift of the first
    image within a few ms across to a masked region on the CCD chip before
    the second image is taken. After both images have been taken, the
    low-noise readout of the CCD chip then usually takes several seconds.
  </itemize>

  In addition, interference structures can originate from the interference of
  light being reflected between the CCD chip and vacuum window of the CCD
  camera. These fringes can be avoided if the CCD vacuum window is
  anti-reflection coated for the specific wavelength or if the camera is
  tilted with respect to the incoming light, however the tilting limits the
  field of view.

  The noise level in our images can be estimated from a region where no atoms
  are present. In images far from the chip surface, we observe a
  gaussian-shaped noise distribution corresponding to typically 1-2
  atoms/pixel and no pronounced structures in the images. For images close to
  the surface where it is possible to observe reflected, diffracted and
  direct light, the noise depends on the specific region of the image. In
  regions where there is large contrast in the resulting interference
  fringes, the noise can be significantly larger. When the beam angle is
  adjusted carefully, we obtain noise levels similar to those of images taken
  far from the surface. Figure <reference|fig:noiseTOF>(a) shows an
  absorption image of a BEC of <math|<nbsp><rsup|87>>Rb atoms taken 5 ms
  after release from a trap formed 10 <math|\<mu\>>m from the surface of the
  atom chip. The image is taken with an imaging beam angle of incidence of
  <math|\<theta\>\<sim\>1<rsup|\<circ\>>>. The modulation of the BEC density
  (Fig.<nbsp><reference|fig:noiseTOF>(b),(c)) is caused by inhomogeneous
  current flow through the atom chip wire used to form the magnetic trap
  <cite|Krueger2007|Wildermuth2005b>. The noise floor of the image can be
  estimated to be <math|\<sim\>> 2 atoms/<math|\<mu\>>m rms. With an object
  pixel size for the image of 3.35<nbsp>x<nbsp>3.35<nbsp><math|\<mu\>>m<rsup|<math|2>>
  we estimate a noise of <math|\<sim\>> 7 atoms/pixel row in the image of the
  cloud in Fig.<nbsp><reference|fig:noiseTOF>. With a half width of
  <math|\<sim\>> 15<nbsp><math|\<mu\>>m rms for the cloud in
  Fig.<nbsp><reference|fig:noiseTOF>, a pixel row corresponds to
  <math|\<sim\>>100<nbsp><math|\<mu\>>m<rsup|<math|2>>. The rms noise of the
  picture correspond to a column density <math|n\<sim\>0.07><nbsp>atoms/<math|\<mu\>>m<rsup|<math|2>>.
  With a shorter expansion time the detectable linear density
  <math|n<rsub|1*D>> in this imaging setup is on the order of
  <math|n<rsub|1*d>\<less\>0.5><nbsp>atoms/<math|\<mu\>>m.

  <with|par-columns|1|<big-figure|<with|par-mode|center|<image|fig8.eps|12cm|||><label|fig:noiseTOF>>|(a)
  Absorption image of a fragmented BEC taken after 5 ms of time-of-flight
  expansion. The BEC has been formed at a distance of 10 <math|\<mu\>>m from
  the wire surface. (b) Longitudinal one-dimensional density profile (blue)
  derived from the absorption image. The noise-level is shown in red. (c) To
  accentuate the noise-floor of <math|\<sim\>> 2<nbsp>atoms/<math|\<mu\>>m
  rms, the same data has been plotted logarithmically. Imaging System 1 in
  section<nbsp><reference|sec:TwoLens> was used for this image.>>

  <section|Detection Limits>

  The information available from an absorption image is limited by the
  signal-to-noise ratio (SNR) which determines the minimum detectable atom
  number. We can rewrite eq.<nbsp><reference|eq:absorption> as

  <\equation>
    n=<frac|1|\<sigma\>>*ln <around|(|<frac|p<rsub|<mathrm>>*o*u*t|p<rsub|<mathrm>>*i*n>|)>,<label|eq:absorption2>
  </equation>

  where <math|p<rsub|<mathrm>>*i*n> and <math|p<rsub|<mathrm>>*o*u*t> are the
  incoming and outgoing photon numbers, which are proportional to
  <math|I<rsub|<mathrm>>*i*n> and <math|I<rsub|<mathrm>>*o*u*t>,
  respectively. Assuming that the signal is photon shot noise limited (i.e.
  <math|\<Delta\>*p=<sqrt|p>>)), the SNR can be written as

  <\equation>
    <math-up|SNR>=<frac|n|\<Delta\>*n>=<frac|n*\<sigma\><sqrt|p<rsub|<mathrm>>*i*n>|<sqrt|exp
    <around|(|n*\<sigma\>|)>+1>>,<label|eq:absorption>
  </equation>

  where <math|\<Delta\>*n> is the error on <math|n>. The detection limit is
  reached when <math|<math-up|SNR>=1>. By rearranging
  eq.<nbsp><reference|eq:absorption> and taking a Taylor expansion of the
  exponential term to the second order, one can gain an approximate solution
  for the minimum observable column density <math|n<rsub|m*i*n>>,

  <\equation>
    n<rsub|m*i*n>\<gtr\><frac|1|\<sigma\>>*<sqrt|<frac|2|p<rsub|<mathrm>>*i*n>>.<label|eq:n>
  </equation>

  Recognising that <math|n<rsub|m*i*n>> is the minimum number of atoms
  <math|N<rsub|m*i*n>> in an area <math|A>, and that the photon number
  <math|p<rsub|<mathrm>>*i*n=I<rsub|<mathrm>>*i*nA \<tau\>*\<lambda\>/h*c>
  (where <math|\<tau\>> is the imaging duration and <math|\<lambda\>> is the
  wavelength of the light), we can write <math|N<rsub|m*i*n>> as

  <\equation>
    N<rsub|m*i*n>\<gtr\><frac|1|\<sigma\>>*<sqrt|<frac|2*A*h*c|\<lambda\>*I<rsub|<mathrm>>*i*n*\<tau\>>>.<label|eq:N>
  </equation>

  Increasing the intensity <math|I<rsub|<mathrm>>*i*n> and imaging duration
  <math|\<tau\>>, leads to a decrease in the detectable atom number
  <math|N<rsub|m*i*n>>. However, the photon recoil in the atom-light
  scattering process heats the atoms and they move during the imaging
  duration. For freely propagating atoms this results in a limit to the
  imaging duration <math|\<tau\>> requiring the atoms will remain in the area
  <math|A>. Increasing <math|I<rsub|<mathrm>>*i*n> to too large a value
  brings two problems. Firstly, increasing <math|I<rsub|<mathrm>>*i*n>
  increases the heating of the atom cloud as the atom-light scattering rate
  is increased. Secondly, the absorption cross section <math|\<sigma\>> can
  only be considered to be intensity independent for intensities that are
  small compared to the saturation intensity of the optical transition used
  for imaging: beyond this, eq.<nbsp><reference|eq:absorption2> is no longer
  valid. For simplicity, the derivation here has assumed a perfect detection
  efficiency of the incoming photons, whereas, in reality, CCD cameras have a
  quantum efficiency <math|\<eta\>> for the conversion of photons to
  electrons that must be taken into account: the number of photons incident
  on the CCD camera <math|p<rsub|<mathrm>>*i*n> or
  <math|p<rsub|<mathrm>>*o*u*t> should be replaced with the actual number of
  detected photons <math|p<rsub|<mathrm>>*d*e*t>, i.e.,
  <math|p<rsub|<mathrm>>*i*n,d*e*t=\<eta\>*p<rsub|<mathrm>>*i*n>.

  As an example we estimate the limits for <rsup|<math|87>>Rb and an imaging
  beam intensity <math|I<rsub|<mathrm>>*i*n> of <math|10%> of the saturation
  intensity <math|I<rsub|<mathrm>>*s*a*t> of the transition (a typical value
  used in our experiments). For the <math|<around|\||F=2,m<rsub|F>=2|\<rangle\>>\<rightarrow\><around|\||F<rprime|'>=3,m<rsub|F>=3|\<rangle\>>>
  transition on the <with|font-shape|italic|D><rsub|<math|2>> line,
  (<math|\<lambda\>=780><nbsp>nm) the absorption cross section
  <math|\<sigma\><rsub|l*i*n>=0.19><nbsp><math|\<mu\>>m<rsup|<math|2>>
  (<math|I<rsub|<mathrm>>*s*a*t*<around|(|l*i*n|)>=25><nbsp>Wm<rsup|<math|-2>>)
  for linearly polarised light and <math|\<sigma\><rsub|c*i*r>=0.29><nbsp><math|\<mu\>>m<rsup|<math|2>>
  (<math|I<rsub|<mathrm>>*s*a*t*<around|(|c*i*r|)>=17><nbsp>Wm<rsup|<math|-2>>
  ) for circularly polarised light <cite|Steck2001>. Using an optical imaging
  system resolution was <math|\<sim\>> 3 <math|\<mu\>>m, gives
  <math|A=\<pi\>\<times\>3<rsup|2>=28<nbsp>\<mu\>>m<rsup|<math|2>> and we
  obtail an approximate minimum column density <math|n<rsub|m*i*n>> (in atoms
  per <math|\<mu\>>m<rsup|<math|2>>) as <math|n<rsub|m*i*n*<around|(|l*i*n|)>>\<gtr\>0.44<nbsp>\<tau\><rsup|-1/2>>
  and <math|n<rsub|m*i*n*<around|(|c*i*r|)>>\<gtr\>0.35<nbsp>\<tau\><rsup|-1/2>>
  for linear and circularly polarised light, respectively (<math|\<tau\>> (in
  <math|\<mu\>>s) is the duration of the imaging pulse). Consequently,
  <math|N<rsub|m*i*n*<around|(|l*i*n|)>>\<gtr\>12<nbsp>\<tau\><rsup|-1/2>>
  and <math|N<rsub|m*i*n*<around|(|c*i*r|)>>\<gtr\>10<nbsp>\<tau\><rsup|-1/2>>.

  Experimentally, the imaging duration <math|\<tau\>> is usually in the
  region of <math|\<sim\>> 30<nbsp><math|\<mu\>>s which leads to the
  following limits: <math|n<rsub|m*i*n*<around|(|l*i*n|)>>=0.08<nbsp>\<mu\>>m<rsup|<math|-2>>
  and <math|N<rsub|m*i*n*<around|(|l*i*n|)>>=3><nbsp>atoms for linearly
  polarised light and <math|n<rsub|m*i*n*<around|(|c*i*r|)>>=0.06<nbsp>\<mu\>>m<rsup|<math|-2>>
  and <math|N<rsub|m*i*n*<around|(|c*i*r|)>>=2><nbsp>atoms for circularly
  polarised light, for the experimental parameters given above. These values
  correspond to an attenuation of the incoming imaging beam of <math|1.5%>
  and <math|1.7%> for linearly and circularly polarised light, respectively.
  To achieve <math|N<rsub|m*i*n>=1>, would require a much longer imaging
  pulse, by which time most of the atoms would have moved out of the area
  <math|A> under observation. For single atom detection by absorption, the
  atoms would have to be tightly confined during the imaging pulse, whereas
  freely propagating single atoms can be detected by fluorescence, as
  described in<nbsp><cite|Bucker2009>.

  <section|Imaging Systems: Two-Lens Imaging Systems><label|sec:TwoLens>

  All of the imaging systems used for this work were composed of two lenses
  (Fig.<nbsp><reference|fig:translong>) located outside the vacuum chamber,
  which typically results in moderate numerical aperture (NA) and resolution
  of the imaging system. By selecting the right combination of standard
  precision achromats, one can achieve diffraction-limited imaging with a
  resolution down to 3 <math|\<mu\>>m at a working distance of 10 cm. Higher
  resolution (<math|\<less\>3<nbsp>\<mu\>>m) usually requires the first lens
  to be located closer to the atom cloud and a multi-lens design. The four
  imaging systems implemented in our experiments are detailed below.

  <with|font-series|bold|Imaging System 1>. Lens 1: Melles Griot 06LAI011
  (<math|f=100><nbsp>mm); Lens 2: Melles Griot 01LA0339
  (<math|f=400><nbsp>mm). The CCD camera was a MicroMAX:1024BFT,
  back-illuminated CCD with a quantum efficiency of 72<math|%> at
  780<nbsp>nm, from Roper Scientific. The camera had a pixel size of
  13<nbsp>x<nbsp>13<nbsp><math|\<mu\>>m<rsup|<math|2>>, which gave a pixel
  size of 3.35<nbsp>x<nbsp>3.35<nbsp><math|\<mu\>>m<rsup|<math|2>> in object
  space. The system was designed to give a magnification of 3.9, with a NA of
  0.13. The calculated Airy disc for the optimised system had a radius of
  3.7<nbsp><math|\<mu\>>m, with the imaging being diffraction-limited within
  a radius of <math|\<gtr\>1><nbsp>mm (in object space) from the central
  axis.

  <with|font-series|bold|Imaging System 2>. Lens 1: Melles Griot 06LAI011
  (<math|f=100><nbsp>mm); Lens 2: Thorlabs AC508-750B (<math|f=750><nbsp>mm)
  achromat resulting in a measured magnification of 7.4. The NA of 0.13 gives
  an optimised calculated Airy radius of 3.7<nbsp><math|\<mu\>>m, with the
  imaging being diffraction-limited within a radius of
  <math|\<gtr\>1><nbsp>mm (in object space) from the central axis. The images
  are recorded with an Andor frame-transfer CCD camera with a pixel size of
  13 x 13<nbsp><math|\<mu\>>m<rsup|<math|2>> giving a pixel size in the
  object plane of 1.8 x 1.8<nbsp><math|\<mu\>>m<rsup|<math|2>>.

  <with|font-series|bold|Imaging System 3>. Lens 1: Melles Griot 06LAI013
  (<math|f=145><nbsp>mm); Lens 2: Thorlabs AC508-750B (<math|f=750><nbsp>mm).
  A Princeton Instruments spectroscopy CCD camera with 1300 pixels x 400
  pixels was used, where each pixel was 20 x
  20<nbsp><math|\<mu\>>m<rsup|<math|2>>. A magnification of 4.8 gave an
  object pixel size of 4.2<nbsp><math|\<mu\>>m and a NA of 0.09. In this
  case, the system was calculated to be diffraction-limited within a radius
  of <math|\<gtr\>2><nbsp>mm from the central axis, with an optimised Airy
  disk radius of 5.4<nbsp><math|\<mu\>>m.

  <with|font-series|bold|Imaging System 4>. Lens 1: Thorlabs AC254-150-B
  (<math|f=150><nbsp>mm); Lens 2 Thorlabs AC508-1000-B
  (<math|f=1000><nbsp>mm). A Princeton Instruments spectroscopy CCD camera
  with 1300 pixels x 400 pixels was used, where each pixel was 20 x
  20<nbsp><math|\<mu\>>m<rsup|<math|2>>. A magnification of 9.3 gave an
  object pixel size of 2.2<nbsp><math|\<mu\>>m and a NA of 0.08. The system
  was calculated to be diffraction-limited within a radius of
  <math|\<gtr\>2><nbsp>mm from the central axis, with an optimised Airy disk
  size of 5.7<nbsp><math|\<mu\>>m.

  <section|Conclusion and Outlook>

  We have detailed the absorption imaging of ultracold atoms above the
  surface of atom chips, particularly focusing on the case where the imaging
  beam is purposely reflected off the atom chip surface. We have shown that a
  standing wave is produced above the chip surface due to this reflection and
  that this must be taken into account when imaging, particularly for atom
  cloud sizes smaller than the standing-wave wavelength. Having built both a
  simple E-field model for the light and carried out a wave-propagation
  simulation to demonstrate the standing wave phenomenon, we demonstrated a
  Fourier method that is a stable way to extract the height of the atom cloud
  above the atom chip surface. We also discussed other configurations for
  absorption imaging when using the atom chip experimental environment,
  before discussing experimental optimisation, detection limits and two-lens
  imaging systems. Absorption imaging techniques close to a surface, or
  particularly on atom chips, are complimentary to other methods, including
  chip-based optical fibres for fluorescence detection<nbsp><cite|Heine2010>,
  chip-based optical cavities<nbsp><cite|Colombe2007>, and
  photoionization<nbsp><cite|Kraft2007>, as well as fluorescence detection
  far from the chip surface<nbsp><cite|Bucker2009>, each having their
  particular benefits and drawbacks that together make a comprehensive
  toolbox for atom detection close to surfaces.

  <section|Acknowledgments>

  This work was supported by the European Union (CHIMONO), the Deutsche
  Forschungsgemeinschaft and the Austrian FWF through the Wittgenstein prize,
  the CoQuS doctoral program, grant no. P20372, and the SFB FoQuS. DAS thanks
  the Austrian FWF Lise Meitner fellowship program. The authors thank Robert
  Bcker and Georg Winkler for interesting discussions.

  <\thebibliography|10>
    <assign|enquote|<macro|1|\P<arg|1>\Q>><bibitem|Folman2000>R.<nbsp>Folman,
    P.<nbsp>Krger, D.<nbsp>Cassettari, B.<nbsp>Hessmo, T.<nbsp>Maier, and
    J.<nbsp>Schmiedmayer, <enquote|Controlling Cold Atoms using
    Nanofabricated Surfaces: Atom Chips,> Phys. Rev. Lett.
    <with|font-series|bold|84>, 4749 (2000).

    <bibitem|Folman2002>R.<nbsp>Folman, P.<nbsp>Krger, J.<nbsp>Schmiedmayer,
    J.<nbsp>Denschlag, and C.<nbsp>Henkel, <enquote|Microscopic atom optics:
    from wires to an atom chip,> Adv. At. Mol. Opt. Phys.
    <with|font-series|bold|48>, 263\U356 (2002).

    <bibitem|Fortagh2007>J.<nbsp>Fortgh and C.<nbsp>Zimmermann,
    <enquote|Magnetic microtraps for ultracold atoms,> Rev. Mod. Phys.
    <with|font-series|bold|79>, 235 (2007).

    <bibitem|Reichel1999>J.<nbsp>Reichel, W.<nbsp>Hnsel, and T.<nbsp>W.
    Hnsch, <enquote|Atomic Micromanipulation with Magnetic Surface Traps,>
    Phys. Rev. Lett. <with|font-series|bold|83>, 3398 (1999).

    <bibitem|Mue99>D.<nbsp>Mller, D.<nbsp>Z. Anderson, R.<nbsp>J. Grow,
    P.<nbsp>D.<nbsp>D. Schwindt, and E.<nbsp>A. Cornell, <enquote|Guiding
    Neutral Atoms Around Curves with Lithographically Patterned
    Current-Carrying Wires,> Phys. Rev. Lett. <with|font-series|bold|83>,
    5194 (1999).

    <bibitem|Dekker2000>N.<nbsp>H. Dekker, C.<nbsp>S. Lee, V.<nbsp>Lorent,
    J.<nbsp>H. Thywissen, S.<nbsp>P. Smith, M.<nbsp>Drndi, R.<nbsp>M.
    Westervelt, and M.<nbsp>Prentiss, <enquote|Guiding Neutral Atoms on a
    Chip,> Phys. Rev. Lett. <with|font-series|bold|84>, 1124 (2000).

    <bibitem|Cassettari00>D.<nbsp>Cassettari, B.<nbsp>Hessmo, R.<nbsp>Folman,
    T.<nbsp>Maier, and J.<nbsp>Schmiedmayer, <enquote|Beam Splitter for
    Guided Atoms,> Phys. Rev. Lett. <with|font-series|bold|85>, 5483\U5487
    (2000).

    <bibitem|Cas00b>D.<nbsp>Cassettari, A.<nbsp>Chenet, R.<nbsp>Folman,
    A.<nbsp>Haase, B.<nbsp>Hessmo, P.<nbsp>Krger, T.<nbsp>Maier,
    S.<nbsp>Schneider, T.<nbsp>Calarco, and J.<nbsp>Schmiedmayer,
    <enquote|Micromanipulation of Neutral Atoms with Nanofabricated
    Structures,> Appl. Phys. B <with|font-series|bold|70>, 721 (2000).

    <bibitem|hans01conveyor>W.<nbsp>Hnsel, P.<nbsp>Hommelhoff, T.<nbsp>W.
    Hnsch, and J.<nbsp>Reichel, <enquote|Magnetic conveyor belt for
    transporting and merging trapped atom clouds,> Phys. Rev. Lett.
    <with|font-series|bold|86>, 608 (2001).

    <bibitem|Krueger2003>P.<nbsp>Krger, X.<nbsp>Luo, M.<nbsp>W. Klein,
    K.<nbsp>Brugger, A.<nbsp>Haase, S.<nbsp>Wildermuth, S.<nbsp>Groth,
    I.<nbsp>Bar-Joseph, R.<nbsp>Folman, and J.<nbsp>Schmiedmayer,
    <enquote|Trapping and manipulating neutral atoms with electrostatic
    fields,> Phys. Rev. Lett. <with|font-series|bold|91>, 233201 (2003).

    <bibitem|Ott2001>H.<nbsp>Ott, J.<nbsp>Fortagh, G.<nbsp>Schlotterbeck,
    A.<nbsp>Grossmann, and C.<nbsp>Zimmermann, <enquote|Bose-Einstein
    Condensation in a Surface Microtrap,> Phys. Rev. Lett.
    <with|font-series|bold|87>, 230401 (2001).

    <bibitem|Haensel2001b>W.<nbsp>Hnsel, P.<nbsp>Hommelhoff, T.<nbsp>W.
    Hnsch, and J.<nbsp>Reichel, <enquote|Bose-Einstein condensation on a
    microelectronic chip,> Nature <with|font-series|bold|413>, 498 (2001).

    <bibitem|Lin04>Y.<nbsp>Lin, I.<nbsp>Teper, C.<nbsp>Chin, and
    V.<nbsp>Vuleti, <enquote|Impact of the Casimir-Polder Potential and
    Johnson Noise on Bose-Einstein Condensate Stability Near Surfaces,> Phys.
    Rev. Lett. <with|font-series|bold|92>, 50404 (2004).

    <bibitem|Wildermuth2005b>S.<nbsp>Wildermuth, S.<nbsp>Hofferberth,
    I.<nbsp>Lesanovsky, E.<nbsp>Haller, L.<nbsp>M. Andersson, S.<nbsp>Groth,
    I.<nbsp>Bar-Joseph, P.<nbsp>Krger, and J.<nbsp>Schmiedmayer,
    <enquote|Microscopic magnetic-field imaging,> Nature
    <with|font-series|bold|435>, 440 (2005).

    <bibitem|Guent05>A.<nbsp>Gnther, M.<nbsp>Kemmler, S.<nbsp>Kraft,
    C.<nbsp>J. Vale, C.<nbsp>Zimmermann, and J.<nbsp>Fortagh,
    <enquote|Combined chips for atom-optics,> Phys. Rev. A
    <with|font-series|bold|71>, 63619 (2005).

    <bibitem|Wildermuth2006>S.<nbsp>Wildermuth, S.<nbsp>Hofferberth,
    I.<nbsp>Lesanovsky, S.<nbsp>Groth, P.<nbsp>Krger, J.<nbsp>Schmiedmayer,
    and I.<nbsp>Bar-Joseph, <enquote|Sensing electric and magnetic fields
    with Bose-Einstein condensates,> Appl. Phys. Lett.
    <with|font-series|bold|88>, 264103 (2006).

    <bibitem|Aigner2008>S.<nbsp>Aigner, L.<nbsp>Della Pietra, Y.<nbsp>Japha,
    O.<nbsp>Entin-Wohlman, T.<nbsp>David, R.<nbsp>Salem, R.<nbsp>Folman, and
    J.<nbsp>Schmiedmayer, <enquote|Long-range order in electronic transport
    through disordered metal films,> SCIENCE <with|font-series|bold|319>,
    1226\U1229 (2008).

    <bibitem|Treutlein2004>P.<nbsp>Treutlein, P.<nbsp>Hommelhoff,
    T.<nbsp>Steinmetz, T.<nbsp>W. Hnsch, and J.<nbsp>Reichel,
    <enquote|Coherence in Microchip Traps,> Phys. Rev. Lett.
    <with|font-series|bold|92>, 203005 (2004).

    <bibitem|Deutsch2010>C.<nbsp>Deutsch, F.<nbsp>Ramirez-Martinez,
    C.<nbsp>Lacrote, F.<nbsp>Reinhard, T.<nbsp>Schneider, J.<nbsp>N. Fuchs,
    F.<nbsp>Pichon, F.<nbsp>Lalo, J.<nbsp>Reichel, and P.<nbsp>Rosenbusch,
    <enquote|Spin Self-Rephasing and Very Long Coherence Times in a Trapped
    Atomic Ensemble,> Phys. Rev. Lett. <with|font-series|bold|105>, 20401
    (2010).

    <bibitem|Lesanovsky2006>I.<nbsp>Lesanovsky, T.<nbsp>Schumm,
    S.<nbsp>Hofferberth, L.<nbsp>M. Andersson, P.<nbsp>Krger, and
    J.<nbsp>Schmiedmayer, <enquote|Adiabatic radio frequency potentials for
    the coherent manipulation of matter waves,> Phys. Rev. A
    <with|font-series|bold|73>, 33619 (2006).

    <bibitem|Hofferberth2006>S.<nbsp>Hofferberth, I.<nbsp>Lesanovsky,
    B.<nbsp>Fischer, J.<nbsp>Verd, and J.<nbsp>Schmiedmayer,
    <enquote|Radio-frequency dressed state potentials for neutral atoms,>
    Nature Phys. <with|font-series|bold|2>, 710\U716 (2006).

    <bibitem|Schumm2005b>T.<nbsp>Schumm, S.<nbsp>Hofferberth, L.<nbsp>M.
    Andersson, S.<nbsp>Wildermuth, S.<nbsp>Groth, I.<nbsp>Bar-Joseph,
    J.<nbsp>Schmiedmayer, and P.<nbsp>Krger, <enquote|Matter wave
    interferometry in a double well on an atom chip,> Nature Phys.
    <with|font-series|bold|1>, 57\U62 (2005).

    <bibitem|Boehi2009>P.<nbsp>Bhi, M.<nbsp>F. Riedel, J.<nbsp>Hoffrogge,
    J.<nbsp>Reichel, T.<nbsp>W. Hnsch, and P.<nbsp>Treutlein,
    <enquote|Coherent manipulation of Bose-Einstein condensates with
    state-dependent microwave potentials on an atom chip,> Nature Physics
    <with|font-series|bold|5>, 592 (2009).

    <bibitem|Calarco2000>T.<nbsp>Calarco, E.<nbsp>A. Hinds, D.<nbsp>Jaksch,
    J.<nbsp>Schmiedmayer, J.<nbsp>I. Cirac, and P.<nbsp>Zoller,
    <enquote|Quantum Gates with Neutral Atoms: Controlling Collisional
    Interactions in Time-Dependent Traps,> Phys. Rev. A
    <with|font-series|bold|61>, 22304 (2000).

    <bibitem|Treutlein2006>P.<nbsp>Treutlein, T.<nbsp>W. Hnsch,
    J.<nbsp>Reichel, A.<nbsp>Negretti, M.<nbsp>A. Cirone, and
    T.<nbsp>Calarco, <enquote|Microwave potentials and optimal control for
    robust quantum gates on an atom chip,> Phys. Rev. A
    <with|font-series|bold|74>, 22312 (2006).

    <bibitem|Charron2006>E.<nbsp>Charron, M.<nbsp>A. Cirone,
    A.<nbsp>Negretti, J.<nbsp>Schmiedmayer, and T.<nbsp>Calarco,
    <enquote|Theoretical analysis of a realistic atom-chip quantum gate,>
    Phys. Rev. A <with|font-series|bold|74>, 12308 (2006).

    <bibitem|Hofferberth2007b>S.<nbsp>Hofferberth, I.<nbsp>Lesanovsky,
    B.<nbsp>Fischer, T.<nbsp>Schumm, and J.<nbsp>Schmiedmayer,
    <enquote|Non-equilibrium coherence dynamics in one-dimensional Bose
    gases,> Nature <with|font-series|bold|449>, 324\U327 (2007).

    <bibitem|Hofferberth2008>S.<nbsp>Hofferberth, I.<nbsp>Lesanovsky,
    T.<nbsp>Schumm, A.<nbsp>Imambekov, V.<nbsp>Gritsev, E.<nbsp>Demler, and
    J.<nbsp>Schmiedmayer, <enquote|Probing quantum and thermal noise in an
    interacting many-body system,> Nature Physics <with|font-series|bold|4>,
    489\U495 (2008).

    <bibitem|Armijo2010>J.<nbsp>Armijo, T.<nbsp>Jacqmin, K.<nbsp>Kheruntsyan,
    and I.<nbsp>Bouchoule, <enquote|Probing Three-Body Correlations in a
    Quantum Gas Using the Measurement of the Third Moment of Density
    Fluctuations,> Physical Review Letters <with|font-series|bold|105>, 3\U6
    (2010).

    <bibitem|VanAmerongen2008>a.<nbsp>van Amerongen, J.<nbsp>van Es,
    P.<nbsp>Wicke, K.<nbsp>Kheruntsyan, and N.<nbsp>van Druten,
    <enquote|Yang-Yang Thermodynamics on an Atom Chip,> Physical Review
    Letters <with|font-series|bold|100>, 13\U15 (2008).

    <bibitem|Ketterle1999b>W.<nbsp>Ketterle, D.<nbsp>S. Durfee, and
    D.<nbsp>M. Stamper-Kurn, <enquote|Making, probing and understanding
    Bose-Einstein condensates,> in <enquote|Bose-Einstein condensation in
    atomic gases,> , M.<nbsp>Inguscio, S.<nbsp>Stringari, and C.<nbsp>E.
    Wieman, eds. (IOS Press, Amsterdam, 1999), Proceedings of the
    International School of Physics Enrico Fermi, Course CXL, pp. 67\U176.

    <bibitem|PhysRevA.67.023612>S.<nbsp>Schneider, A.<nbsp>Kasper,
    C.<nbsp>vom Hagen, M.<nbsp>Bartenstein, B.<nbsp>Engeser, T.<nbsp>Schumm,
    I.<nbsp>Bar-Joseph, R.<nbsp>Folman, L.<nbsp>Feenstra, and
    J.<nbsp>Schmiedmayer, <enquote|Bose-Einstein condensation in a simple
    microtrap,> Phys. Rev. A <with|font-series|bold|67>, 23612 (2003).

    <bibitem|Bucker2009>R.<nbsp>Bcker, A.<nbsp>Perrin, S.<nbsp>Manz,
    T.<nbsp>Betz, C.<nbsp>Koller, T.<nbsp>Plisson, J.<nbsp>Rottmann,
    T.<nbsp>Schumm, and J.<nbsp>Schmiedmayer,
    <enquote|Single-particle-sensitive imaging of freely propagating
    ultracold atoms,> New Journal of Physics <with|font-series|bold|11>,
    103039 (25pp) (2009).

    <bibitem|Wildermuth2004>S.<nbsp>Wildermuth, P.<nbsp>Krger,
    C.<nbsp>Becker, M.<nbsp>Brajdic, S.<nbsp>Haupt, A.<nbsp>Kasper,
    R.<nbsp>Folman, and J.<nbsp>Schmiedmayer, <enquote|Optimized
    magneto-optical trap for experiments with ultracold atoms near surfaces,>
    Phys. Rev. A <with|font-series|bold|69>, 030901(R) (2004).

    <bibitem|Groth2004>S.<nbsp>Groth, P.<nbsp>Krger, S.<nbsp>Wildermuth,
    R.<nbsp>Folman, T.<nbsp>Fernholz, J.<nbsp>Schmiedmayer, D.<nbsp>Mahalu,
    and I.<nbsp>Bar-Joseph, <enquote|Atom chips: Fabrication and thermal
    properties,> Appl. Phys. Lett. <with|font-series|bold|85>, 2980 (2004).

    <bibitem|Trinker2008>M.<nbsp>Trinker, S.<nbsp>Groth, S.<nbsp>Haslinger,
    S.<nbsp>Manz, T.<nbsp>Betz, S.<nbsp>Schneider, I.<nbsp>Bar-Joseph,
    T.<nbsp>Schumm, and J.<nbsp>Schmiedmayer, <enquote|Multilayer atom chips
    for versatile atom micromanipulation,> Appl. Phys. Lett.
    <with|font-series|bold|92>, 254102 (2008).

    <bibitem|SalehTeich>B.<nbsp>E.<nbsp>A. Saleh and M.<nbsp>C. Teich,
    <em|Fundamentals Of Photonics> (John Wiley & Sons, 1991).

    <bibitem|Krueger2007>P.<nbsp>Krger, L.<nbsp>M. Andersson,
    S.<nbsp>Wildermuth, S.<nbsp>Hofferberth, E.<nbsp>Haller, S.<nbsp>Aigner,
    S.<nbsp>Groth, I.<nbsp>Bar-Joseph, and J.<nbsp>Schmiedmayer,
    <enquote|Potential roughness near lithographically fabricated atom
    chips,> Phys. Rev. A <with|font-series|bold|76>, 063621 (2007).

    <bibitem|Steck2001>D.<nbsp>A. Steck, <enquote|Rubidium 87 D Line Data,>
    (2001), http://steck.us/alkalidata/rubidium87numbers.pdf.

    <bibitem|Heine2010>D.<nbsp>Heine, W.<nbsp>Rohringer, D.<nbsp>Fischer,
    M.<nbsp>Wilzbach, T.<nbsp>Raub, S.<nbsp>Loziczky, X.<nbsp>Liu,
    S.<nbsp>Groth, B.<nbsp>Hessmo, and J.<nbsp>Schmiedmayer, <enquote|A
    single-atom detector integrated on an atom chip: fabrication,
    characterization and application,> New Journal of Physics
    <with|font-series|bold|12>, 095005 (2010).

    <bibitem|Colombe2007>Y.<nbsp>Colombe, T.<nbsp>Steinmetz, G.<nbsp>Dubois,
    F.<nbsp>Linke, D.<nbsp>Hunger, and J.<nbsp>Reichel, <enquote|Strong
    atom-field coupling for Bose-Einstein condensates in an optical cavity on
    a chip,> Nature <with|font-series|bold|450>, 272 (2007).

    <bibitem|Kraft2007>S.<nbsp>Kraft, a.<nbsp>Gnther, J.<nbsp>Fortgh, and
    C.<nbsp>Zimmermann, <enquote|Spatially resolved photoionization of
    ultracold atoms on an atom chip,> Physical Review A
    <with|font-series|bold|75>, 1\U5 (2007).
  </thebibliography>
</body>