<TeXmacs|1.99.7>

<style|<tuple|aps|std-latex>>

<\body>
  <doc-data|<doc-title|A Bright, Slow Cryogenic Molecular Beam Source for
  Free Radicals>|<doc-author|<author-data|<author-name|J.F. Barry, E.S.
  Shuman, and D. DeMille>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    We demonstrate and characterize a cryogenic buffer gas-cooled molecular
    beam source capable of producing bright beams of free radicals and
    refractory species. Details of the beam properties (brightness, forward
    velocity distribution, transverse velocity spread, rotational and
    vibrational temperatures) are measured under varying conditions for the
    molecular species SrF. Under typical conditions we produce a beam of
    brightness <math|1.2\<times\>10<rsup|11>> molecules/sr/pulse in the
    <math|X<rsup|2>*\<Sigma\><rsup|+>*<around|(|v=0,N<rsub|r*o*t>=0|)>>
    state, with <math|140*<frac|m|s>> forward velocity and a rotational
    temperature of <math|\<approx\><space|-0.17em>> 1 K. This source compares
    favorably to other methods for producing beams of free radicals and
    refractory species for many types of experiments. We provide details of
    construction that may be helpful for others attempting to use this
    method.
  </abstract>>

  There has recently been a renewed interest in diatomic molecules because of
  their potential applications to a variety of areas. In particular, cold
  polar molecules are expected to be useful in fields including quantum
  computation <cite|DeMille2002|Maxwell2006>, quantum simulation of condensed
  matter systems <cite|Goral2002|Micheli2006|Barnett2006>, precision
  measurements <cite|Vutha2010|Leanhardt2010|Hudson2002|Cahn2008>, and
  controlled chemistry <cite|Balakrishnan2001|Krems2008|Hudson2006a>.
  Although many methods for cooling and trapping molecules have been proposed
  <cite|Carr2009>, only a few have been demonstrated. One successful
  technique for producing cold molecules is by binding laser-cooled atoms
  into molecules via photoassociation <cite|Sage2005> or Feshbach resonance
  <cite|Ni2008>; however, both these methods have so far been limited to
  bialkali molecules.

  A more general technique for trapping molecules is to directly load them
  into a trap from a molecular beam <cite|DeMille2004>. In this case the
  number of molecules trapped is directly tied to the flux, translational and
  internal (rotational and vibrational) temperatures, and forward velocity of
  the beam. Specifically, slow, cold molecular beams with high flux are ideal
  for loading traps. Such beams of molecules are also useful for high
  precision spectroscopy <cite|Flambaum2007>.

  Unfortunately, traditional supersonic and effusive molecular beams are not
  ideally suited to these requirements. Thermal effusive sources can produce
  translationally slow molecules, but the finite rovibrational temperatures
  of the molecules vastly reduce the effective flux of these beams. On the
  other hand, supersonic beam sources are quite efficient at cooling both
  internal and external molecular degrees of freedom, but the resultant
  molecular beam velocity is quite high, which prohibits direct molecular
  trapping.

  The development of general methods for directly producing slow, cold
  molecules applicable to a variety of molecular species remains an active
  area of research. Tremendous advances have been made in the deceleration of
  supersonic beams in the past decade. Stark deceleration
  <cite|Meerakker2005|Hudson2006>, Zeeman deceleration
  <cite|Vanhaecke2007|Narevicius2008>, optical deceleration
  <cite|Fulton2004>, collisional deceleration <cite|Chandler2003>, and
  rotating nozzles <cite|Gupta1999|Strebel2010> have all been developed to
  slow supersonic beams to velocities of a few m/s, where molecules can be
  loaded into a trap. Although this is a highly general technique for
  producing beams of slow, cold molecules, it becomes significantly more
  challenging for unstable molecules (e.g. free radicals) or molecules that
  do not have substantial vapor pressure at room temperature. The high
  forward velocity in supersonic beams also makes slowing heavy molecules
  much more challenging, and thus far the slowing techniques have primarily
  been limited to light molecules <cite|Tarbutt2004>. Furthermore, these
  slowing techniques have so far resulted in molecular beams with relatively
  low flux.

  Another promising technique is cryogenic buffer gas gas cooling. Typically
  in these experiments, the target molecules and the buffer gas are enclosed
  in a cell. Collisions with the buffer gas cool both the internal and
  external degrees of freedom to the temperature of the cell. This technique
  has been demonstrated for a wide variety of molecular species
  <cite|Krems2009>, with resulting molecular temperatures as low as 100 mK
  and the ability to trap molecules demonstrated in situ <cite|Weinstein98>.
  The primary disadvantage of buffer gas cooling is that the cold molecules
  remain in the cell where collisions prohibit most further measurements and
  manipulation of the molecules. It remains a significant challenge to
  separate the buffer gas from the molecules of interest.

  Cryogenic buffer gas cooling has also served as the basis for molecular
  beams <cite|Maxwell2005|Buuren2009|Patterson2007|Patterson2009>. In these
  experiments, the cell has an exit aperture through which the molecules can
  escape and form a beam. These sources can be operated both in an effusive
  regime and a \Phydrodynamically enhanced\Q regime, depending on the buffer
  gas density. For low buffer gas densities, there are relatively few
  collisions near the exit aperture, and the beam exits effusively from the
  cell. Effusive beams are characterized by thermal molecular beam velocities
  and low flux due to poor extraction of molecules from the cell. For higher
  buffer gas densities, hydrodynamic effects inside the cell lead to nearly
  complete extraction of molecules from the cell. However, in the
  hydrodynamic regime, collisions between molecules and buffer gas near the
  exit aperture can result in a boosted forward velocity.

  Here we report on the development and characterization of an
  ablation-loaded, cryogenic buffer gas beam source of a diatomic free
  radical. The source is designed to produce a beam of molecules which will
  subsequently be laser cooled <cite|Shuman2009|Shuman2010>, and ultimately
  loaded into a trap. We operate the source at intermediate buffer gas
  densities, where the extraction efficiency of molecules into the beam is
  high, while the forward velocity of the beam is significantly lower than
  the full supersonic speed of the buffer gas. Previous studies on such beams
  have focused on only a few of the properties under a limited range of
  conditions <cite|Maxwell2005|Buuren2009|Patterson2007|Patterson2009>. The
  characterization given here provides a more complete description of a
  cryogenic buffer gas beam source, including measurement of the beam
  brightness, forward velocity distribution, transverse velocity spread, and
  rotational and vibrational temperatures over a wide range of buffer gas
  densities. We also characterize the molecular beam flux into a
  room-temperature apparatus for the first time. We find that the brightness
  of the cryogenic beam source compares very favorably with other sources
  capable of producing beams of similar refractory species. Although the
  measurements presented here were all conducted using strontium monofluoride
  (SrF), we expect similar performance from other species which can be
  vaporized by ablation of solid precursors.

  The remainder of the paper is structured as follows: Part II details basic
  properties of buffer gas beams. Part III describes the experimental
  construction and design principles. Part IV presents measurements of the
  beam properties, additional observations regarding source operation and a
  detailed comparison to existing sources based on other technologies. Part V
  consists of a short conclusion.

  <section|General Source Properties>

  The basic principles of a buffer gas beam source are simple. A cold cell is
  held at temperature <math|T<rsub|0>> while gaseous buffer gas atoms
  <math|b>, also at <math|T<rsub|0>>, are continuously flowed through the
  cell at a rate <math|\<cal-F\>>. The value of <math|\<cal-F\>> can
  typically be continuously varied over a wide range of values, which allows
  control over the density of <math|b> inside the cell. The target molecules
  <math|a> are injected into the cell at an initial temperature
  <math|T<rsub|a>*<around|(|t=0|)>\<gg\>T<rsub|0>>, in our case by laser
  ablation of a solid precursor inside the cell. These initially hot
  molecules undergo many collisions with the buffer gas, which cool both the
  translational and rotational degrees of freedom to near <math|T<rsub|0>>.
  During and after this thermalization, the target molecules diffuse through
  the buffer gas to the cell walls, where they stick and are lost.
  Simultaneously, both the target molecules and the buffer gas are extracted
  into a beam through a hole in the cell. The ratio of the time scales for
  these competing processes determines the efficiency of molecule extraction
  from the cell. Meanwhile the number of collisions between the buffer gas
  atoms and the molecules around the exit aperture determines the divergence,
  forward velocity distribution, and internal temperatures of the molecules
  in the beam. Although these basic principles of buffer gas beam sources are
  simple, the actual dynamics in and around the cell can be quite complex for
  ablation-loaded sources such as ours. In the remainder of this section we
  describe relevant characteristics of the cell conditions and the resulting
  molecular beam. The description given here is meant to provide a
  qualitative description of a few of the relevant parameters of these
  sources. More sophisticated models would be necessary to give a complete
  quantitative description.

  <subsection|Mean Free Path>

  The basic properties of the buffer gas beam are primarily determined by the
  mean free paths <math|\<lambda\><rsub|a>> and <math|\<lambda\><rsub|b>> of
  particles <math|a> and <math|b> inside the cell. Under typical operating
  conditions, the density <math|n<rsub|b>> of the buffer gas far exceeds that
  of the target molecules <math|n<rsub|a>>. This allows two simplifying
  assumptions to be made. First, collisions involving two <math|a> particles
  are rare and therefore may be ignored; thus <math|\<lambda\><rsub|a>> then
  depends only on <math|n<rsub|b>>. Similarly, collisions between two
  <math|b> particles are much more likely than between <math|a> and <math|b>
  particles, so <math|\<lambda\><rsub|b>> also depends only on
  <math|n<rsub|b>>. Under these conditions the mean free paths are

  <\equation>
    <label|eq:meanfreepath>\<lambda\><rsub|a>=<frac|1|n<rsub|b>*\<sigma\><rsub|a*b>*<sqrt|m<rsub|a>/m<rsub|b>+1>>*<space|5
    mm><text|and><space|5 mm>\<lambda\><rsub|b>=<frac|1|<sqrt|2>*n<rsub|b>*\<sigma\><rsub|b*b>>,
  </equation>

  where <math|\<sigma\><rsub|a*b>> is the elastic collision cross section
  between species <math|a> and <math|b>, <math|\<sigma\><rsub|b*b>> is the
  elastic collision cross section between <math|b> particles, and
  <math|m<rsub|a>> and <math|m<rsub|b>> are the masses of <math|a> and
  <math|b>, respectively.

  In practice <math|b> is usually a noble gas, so <math|n<rsub|b>> is not
  easy to measure using laser absorption or fluorescence techniques. Instead
  the value of <math|n<rsub|b>> in our experiments is inferred from simple
  cell dynamics described here. Under steady state conditions, the flow rate
  of <math|b> into the cell, <math|\<cal-F\>>, will equal the rate of
  <math|b> out. The rate at which particles of <math|a<around|(|b|)>> are
  emitted out of the source exit aperture (with area <math|A>) into solid
  angle <math|d*\<omega\>> at angle <math|\<theta\>> is

  <\equation>
    <label|eq:ramsey>d*Q<rsub|a<around|(|b|)>>=<frac|d*\<omega\>|4*\<pi\>>*n<rsub|a<around|(|b|)>>*v<rsup|e*x*i*t><rsub|a<around|(|b|)>>*A*cos
    \<theta\>,
  </equation>

  where <math|v<rsup|e*x*i*t><rsub|a<around|(|b|)>>> is the mean velocity at
  the exit aperture of species <math|a<around|(|b|)>> <cite|Ramsey1956>.

  The values of <math|v<rsup|e*x*i*t><rsub|a>> and
  <math|v<rsup|e*x*i*t><rsub|b>> can vary significantly depending on the
  number of collisions particles of the given species experience near the
  exit aperture. The Reynolds number for <math|a> and <math|b>, defined as
  <math|R*e<rsub|a>=<frac|d|\<lambda\><rsub|a>>> and
  <math|R*e<rsub|b>=<frac|d|\<lambda\><rsub|b>>> where <math|d> is the cell
  aperture diameter, characterizes the number of collisions each species
  experiences while exiting the cell aperture. Typically
  <math|m<rsub|a>\<gtr\>m<rsub|b>> and <math|\<sigma\><rsub|a*b>\<approx\>\<sigma\><rsub|b*b>>,
  so we assume hereon that <math|R*e<rsub|a>\<gtr\>R*e<rsub|b>>. For
  <math|1\<gg\>R*e<rsub|a>\<gtr\>R*e<rsub|b>>, the molecules exit the hole
  effusively. For <math|R*e<rsub|a>\<gtr\>R*e<rsub|b>\<gg\>1>, the particles
  undergo many collisions around the exit aperture, resulting in supersonic
  velocities as the beam escapes the source.

  We relate <math|n<rsub|b>> to the flow rate <math|\<cal-F\>> via the
  following reasoning. Under effusive conditions,
  <math|v<rsup|e*x*i*t><rsub|b>> is the same as the mean velocity of <math|b>
  inside the cell: <math|v<rsup|e*x*i*t><rsub|b>=<wide|v|\<bar\>><rsub|b>=<around|(|2/<sqrt|\<pi\>>|)>*\<beta\>>.
  Here <math|\<beta\>\<equiv\><sqrt|2*k<rsub|B>*T<rsub|b>/m<rsub|b>>>, where
  <math|T<rsub|b>> is the translational temperature of <math|b>. Integration
  of Eq. (<reference|eq:ramsey>) over all angles leads to a total rate of
  <math|Q<rsub|b><rsup|e>=<frac|n<rsub|b>*A*\<beta\>|2*<sqrt|\<pi\>>>>, in
  the effusive regime. In the fully supersonic regime, the value of
  <math|v<rsup|e*x*i*t><rsub|b>> is less clear. Collisions in and around the
  aperture boost the forward velocity of the buffer gas atoms from
  <math|<wide|v|\<bar\>><rsub|b>> up to a maximum value given by the fully
  supersonic velocity <cite|Scoles88|Pauly2000>

  <\equation>
    <label|eq:supersonicvelocity>v<rsub|b\<parallel\>><rsup|s>=<sqrt|\<gamma\>/<around|(|\<gamma\>-1|)>>*\<beta\>,
  </equation>

  where for a noble gas <math|\<gamma\>=5/3>. We can obtain an upper limit on
  the total rate in the supersonic regime by assuming that all particles of
  <math|b> exit the cell along the beam line at
  <math|v<rsub|b\<parallel\>><rsup|s>>. Under these assumptions Eq.
  (<reference|eq:ramsey>) yields an upper limit on the total rate
  <math|Q<rsup|s><rsub|b>=<sqrt|5/2>*n<rsub|b>*A*\<beta\>>. By equating
  <math|\<cal-F\>> to <math|Q<rsub|b>> we arrive at the density of
  <math|n<rsub|b>> for the two cases given by

  <\equation>
    <label|eq:n>n<rsub|b>=<frac|\<kappa\>*\<cal-F\>|A*\<beta\>>,
  </equation>

  where <math|\<kappa\>=\<kappa\><rsup|e>=2*<sqrt|\<pi\>>> for fully effusive
  and <math|\<kappa\>=\<kappa\><rsup|s>=1/<sqrt|\<gamma\>/<around|(|\<gamma\>-1|)>>>
  for fully supersonic; hence <math|<frac|\<kappa\><rsup|e>*\<cal-F\>|A*\<beta\>>\<gtr\>n<rsub|b>\<gtr\><frac|\<kappa\><rsup|s>*\<cal-F\>|A*\<beta\>>>.

  <subsection|Thermalization>

  The extraction of target molecules into the beam depends critically on
  their thermalization with the buffer gas. If the molecules do not
  thermalize before they make contact with the cell walls, they will stick
  and be lost. Thermalization of initially hot molecules inside a cold buffer
  gas cell can be described by a simple kinematic model
  <cite|Decarvalho1999>. At time <math|t=0>, ablation creates
  <math|N<rsub|a><rsup|c*e*l*l>> particles of species <math|a> at initial
  high translational temperature <math|T<rsub|a><around|(|0|)>>. The
  particles cool via collisions with the buffer gas; the translational
  temperature <math|T<rsub|a><around|(|\<cal-N\>|)>> of species <math|a>
  after <math|\<cal-N\>> collisions can be written as a differential
  equation:

  <\equation>
    <label|eq:cool><frac|d*T<rsub|a><around|(|\<cal-N\>|)>|d*\<cal-N\>>=-<frac|T<rsub|a><around|(|\<cal-N\>|)>-T<rsub|b>|C>,
  </equation>

  where <math|C\<equiv\><around|(|m<rsub|a>+m<rsub|b>|)><rsup|2>/<around|(|2*m<rsub|a>*m<rsub|b>|)>>.
  This simple model assumes <math|T<rsub|b>=T<rsub|0>> at all times.
  Integration of Eq. (<reference|eq:cool>) yields

  <\equation>
    <label|eq:temp>T<rsub|a><around|(|\<cal-N\>|)>=T<rsub|b>+<around|(|T<rsub|a><around|(|0|)>-T<rsub|b>|)>*e<rsup|-\<cal-N\>/C>.
  </equation>

  The temperature of species <math|a> then asymptotically approaches
  <math|T<rsub|b>>. We define a nominal number of collisions necessary to
  thermalize species <math|a>, <math|\<cal-N\><rsub|T*h>>, as the number of
  collisions such that <math|T<rsub|a><around|(|\<cal-N\><rsub|T*h>|)>> is of
  the same order of magnitude as <math|T<rsub|b>>, i.e. by setting the second
  term in Eq. (<reference|eq:temp>) equal to <math|T<rsub|b>>. This yields
  <math|\<cal-N\><rsub|T*h>\<equiv\>C<nbsp><with|font-family|rm|l*o*g><around*|(|<frac|T<rsub|a><around|(|0|)>-T<rsub|b>|T<rsub|b>>|)>\<approx\>C<nbsp><with|font-family|rm|l*o*g><around*|(|<frac|T<rsub|a><around|(|0|)>|T<rsub|b>>|)>>.
  The resulting thermalization time <math|\<tau\><rsub|T*h>> is given by

  <\equation>
    <label|eq:thermalizationtime>\<tau\><rsub|T*h>=<frac|\<cal-N\><rsub|T*h>|R>,
  </equation>

  where <math|R\<approx\>n<rsub|b>*\<sigma\><rsub|a*b>*<wide|v|\<bar\>><rsub|b>*<sqrt|1+m<rsub|b>/m<rsub|a>>>
  is the approximate collision rate for species <math|a>.

  The value of <math|\<cal-N\><rsub|T*h>> allows us to estimate the minimum
  density <math|n<rsub|b>> necessary to achieve thermalization. After
  <math|\<cal-N\><rsub|T*h>> collisions, each particle <math|a> travels a
  characteristic distance <math|X<rsub|T*h>>, which must range between the
  distance traveled by a diffusive random walk and purely ballistic flow, or
  <math|<sqrt|\<cal-N\><rsub|T*h>>*\<lambda\><rsub|a>\<leq\>X<rsub|T*h>\<leq\>\<cal-N\><rsub|T*h>*\<lambda\><rsub|a>>.
  The heavy and initially hot molecules have much more momentum than the
  light and cold buffer gas, so we take the ballistic limit
  <math|X<rsub|T*h>=\<cal-N\><rsub|T*h>*\<lambda\><rsub|a>>. For ablation in
  the middle of a cubic cell of side length <math|L<rsub|c>>, the particles
  of <math|a> exiting through the aperture will be efficiently thermalized
  only if <math|X<rsub|T*h>\<lesssim\>L<rsub|c>/2>. Using Eq.
  (<reference|eq:meanfreepath>) leads to a density requirement for
  thermalization given by

  <\equation>
    <label|eq:thermalizationdensity>n<rsub|T*h>\<gtrsim\><frac|2*C|\<sigma\><rsub|a*b>*L<rsub|c>*<sqrt|m<rsub|a>/m<rsub|b>+1>>*<with|font-family|rm|l*o*g><around*|(|<frac|T<rsub|a><around|(|0|)>-T<rsub|b>|T<rsub|b>>|)>.
  </equation>

  For most species <math|\<sigma\><rsub|a*b>> is unknown; however,
  <math|\<sigma\><rsub|a*b>> typically shows little variation among target
  species <math|a> for a given buffer gas <math|b>
  <cite|Lu2009|Nguyen2005|Tsikata2010|Jessiephd2007|Skoff2010>, and for noble
  gases <math|\<sigma\><rsub|a*b>\<approx\>\<sigma\><rsub|b*b>><nbsp><cite|Hamel1986|Hogervorst1971>.
  Furthermore, the exact value of <math|T<rsub|a><around|(|0|)>> is unknown,
  and must be estimated (typical estimates for ablation temperatures are
  <math|T<rsub|a><around|(|0|)>\<sim\>10<rsup|4>> K <cite|Davis1985>).
  Nonetheless, we expect that Eq. (<reference|eq:thermalizationdensity>)
  provides the correct order of magnitude for the density required for
  thermalization.

  Similar arguments are applicable to the internal (vibrational and
  rotational) temperatures of <math|a>, provided that the appropriate
  collisional cross sections are used. In general the collision cross
  sections for vibrational, rotational and translational relaxation obey
  <cite|Scoles88|Pauly2000>

  <\equation>
    <label|eq:cross sections>\<sigma\><rsup|v*i*b><rsub|a*b>\<ll\>\<sigma\><rsup|r*o*t><rsub|a*b>\<less\>\<sigma\><rsub|a*b>,
  </equation>

  where <math|\<sigma\><rsup|v*i*b><rsub|a*b>>,
  <math|\<sigma\><rsup|r*o*t><rsub|a*b>>, and <math|\<sigma\><rsub|a*b>> are
  the respective vibrational, rotational and translational collisional cross
  sections between species <math|a> and buffer gas <math|b>. In this case we
  expect similar thermalization behavior for rotational and translational
  degrees of freedom, while vibrational thermalization may occur over much
  longer time scales.

  <subsection|Diffusion and Extraction>

  After thermalization, particles of both species <math|a> and <math|b> are
  extracted from the cell through the cell aperture and into the beam. The
  efficiency of extraction of <math|a> through the hole is primarily limited
  by the diffusion of these particles to the cell walls. The diffusion of
  species <math|a> into species <math|b> at temperature <math|T> is governed
  by the diffusion equation, <math|<frac|d*n<rsub|a>|d*t>=\<nabla\><rsup|2>*<around|(|D*n<rsub|a>|)>><nbsp><cite|Hasted1972>.
  Here <math|D> is the diffusion constant, given to good approximation by
  <math|D=3/<around|(|16*\<sigma\><rsub|a*b>*n<rsub|b>|)>\<times\><sqrt|2*\<pi\>*k<rsub|B>*T/\<mu\>>><nbsp><cite|Hasted1972>,
  where <math|\<mu\>=<around|(|m<rsub|a>*m<rsub|b>|)>/<around|(|m<rsub|a>+m<rsub|b>|)>>
  is the reduced mass. We can therefore approximate the time for species
  <math|a> to be lost to the cell walls via diffusion,
  <math|\<tau\><rsub|d*i*f*f>>, by the time constant of the lowest-order
  diffusion mode <cite|Hasted1972>, giving

  <\equation>
    <label|eq:diffusion>\<tau\><rsub|d*i*f*f>\<approx\><frac|L<rsub|c><rsup|2>|4*\<pi\><rsup|2>*D>.
  </equation>

  We approximate <math|\<tau\><rsup|b><rsub|p*u*m*p>>, the time constant
  governing the extraction of <math|b> through the cell aperture, by the
  typical time for the cell volume to be emptied by flow out of the exit
  aperture:

  <\equation>
    <label|eq:pumpout>\<tau\><rsup|b><rsub|p*u*m*p>\<approx\><frac|L<rsub|c><rsup|3>*n<rsub|b>|\<cal-F\>>=<frac|\<kappa\>*L<rsub|c><rsup|3>|A*\<beta\>>.
  </equation>

  In the remainder of the paper we assume that species <math|a> is fully
  entrained in the flow of species <math|b> inside the cell. With this
  assumption, species <math|a> also will exit the cell with the same time
  constant. The cell extraction efficiency <math|\<epsilon\>> is the fraction
  of <math|a>, which, once produced and thermalized inside the cell, is
  extracted into a beam. The quantity

  <\equation>
    <label|eq:efficiency>\<xi\>\<equiv\><frac|\<tau\><rsub|d*i*f*f>|\<tau\><rsup|b><rsub|p*u*m*p>>\<propto\><frac|\<cal-F\>|L<rsub|c>>
  </equation>

  has been found to be strongly correlated with
  <math|\<epsilon\>><nbsp><cite|Patterson2007>. Eq.
  (<reference|eq:efficiency>) suggests that small cells operated at high flow
  rates are ideal for maximal extraction efficiencies. For
  <math|\<xi\>\<gg\>1> we expect particles of <math|a> to exit the cell
  before they diffuse to the cell walls; therefore in this \Phydrodynamic\Q
  regime we expect to observe <math|\<epsilon\><rsub|h*y*d>\<sim\>1>. Values
  of <math|\<epsilon\>\<gtr\>0.4> have been reported <cite|Patterson2007> for
  <math|\<xi\>\<gtrsim\>1>. For <math|\<xi\>\<ll\>1> we expect purely
  diffusive in-cell behavior, with <math|\<epsilon\>> determined by the
  geometric extraction efficiency <math|\<sim\>A/<around|(|\<pi\>*L<rsub|c><rsup|2>|)>>
  for molecules produced in the center of the cell. In this regime values of
  <math|\<epsilon\>\<sim\>0.001> have been reported <cite|Maxwell2005>.

  <subsection|Beam Formation>

  As the molecules pass through the exit aperture, the number of collisions
  that particles of <math|a> and <math|b> experience determines to a large
  extent the properties of the beam. For <math|1\<gg\>R*e<rsub|a>\<gtr\>R*e<rsub|b>>
  (effusive regime), there are no collisions for either species in the
  vicinity of the aperture and the extracted beam is purely effusive. In this
  regime the mean forward velocities of <math|a> and <math|b> in the beam,
  denoted by <math|v<rsub|a\<parallel\>>> and <math|v<rsub|b\<parallel\>>>
  respectively, are given by <cite|Ramsey1956>

  <\equation>
    <label|eq:effusivevelocity>v<rsub|a\<parallel\>>=v<rsub|a\<parallel\>><rsup|e>=<frac|3|4>*<sqrt|\<pi\>>*\<alpha\><nbsp><nbsp><nbsp><text|and><nbsp><nbsp><nbsp>v<rsub|b\<parallel\>>=v<rsub|b\<parallel\>><rsup|e>=<frac|3|4>*<sqrt|\<pi\>>*\<beta\>,
  </equation>

  where <math|\<alpha\>\<equiv\><sqrt|2*k<rsub|B>*T<rsub|a>/m<rsub|a>>>. We
  also expect the translational temperatures of <math|a> and <math|b> in the
  beam obey <math|T<rsub|a><rsup|b*e*a*m>=T<rsub|b><rsup|b*e*a*m>=T<rsub|0>>.

  For <math|R*e<rsub|a>\<gtr\>R*e<rsub|b>\<gg\>1> (supersonic regime), all
  particles experience many collisions as they exit the aperture and expand
  into vacuum. Because <math|n<rsub|b>\<gg\>n<rsub|a>> the buffer gas species
  <math|b> drives the expansion, and the properties of <math|b> in the beam
  determine to a large extent the beam properties of <math|a>. During the
  isentropic expansion, <math|v<rsub|b\<parallel\>>> increases while
  <math|T<rsub|b><rsup|b*e*a*m>> cools, resulting in a boosted but narrow
  velocity distribution. Using a simple hard-sphere scattering model to
  describe the cooling during the expansion <cite|Pauly2000>, we can estimate
  <math|T<rsub|b><rsup|b*e*a*m>> to be

  <\equation>
    <label|eq:supersonicfinaltemp>T<rsub|b><rsup|b*e*a*m>\<lesssim\>3.12*<around|(|\<sigma\><rsub|b*b>*n<rsub|b>*d|)><rsup|-<frac|4|5>>*T<rsub|0>.
  </equation>

  This value of <math|T<rsub|b><rsup|b*e*a*m>> represents an upper bound on
  the beam temperature because it neglects quantum mechanical effects which
  become more important for low values of <math|T<rsub|b><rsup|b*e*a*m>>
  <cite|Toennies1977|Wang1988>, particularly for <math|b=> He. In the
  supersonic regime we expect <math|T<rsub|a><rsup|b*e*a*m>> to approach
  <math|T<rsub|b><rsup|b*e*a*m>>. We also expect <math|v<rsub|a\<parallel\>>>
  to approach <math|v<rsub|b\<parallel\>>> and <math|v<rsub|b\<parallel\>>>
  to approach <math|v<rsub|b\<parallel\>><rsup|s>>.

  <section|Experimental Apparatus>

  In this experiment, SrF is the molecule of interest <math|a>, and the
  buffer gas species <math|b> is He. The apparatus is built around a 2-stage
  closed cycle pulse tube refrigerator (Cryomech PT415). A vacuum chamber
  contains the pulse tube head, with vacuum ports providing access for
  temperature sensor and helium gas feedthroughs as well as for various
  vacuum connections and gauges. A radiation shield attached to the first
  stage of the pulse tube (at <math|\<approx\>> 30 K) reduces the heat load
  on the colder second stage (at <math|\<approx\>3> K). Rectangular windows
  on both sides of the 30K shield allow optical access to the cell and along
  the beam line. A hole at the front of the 30K shield allows extraction of
  the molecular beam.

  The cell is attached to a 3K cold plate bolted to the second stage of the
  pulse tube. A 3K shield reduces the blackbody heat load on the cell.
  Windowless holes in the shield allow optical access to the cell and along
  the beam line, while a hole in the front enables beam extraction. The
  inside of the shield is covered with coconut charcoal (PCB
  12<math|\<times\>>30 mesh Calgon Charcoal), which acts as a cryopump for
  helium gas <cite|Tobin1987|Sedgley1987>; the charcoal is affixed to the
  shield with epoxy (Arctic Silver Thermal Epoxy).

  Room temperature helium gas (<math|99.999%> purity) flows into the cell
  through a series of stainless steel and copper tubes. The flow rate
  <math|\<cal-F\>> is monitored outside the vacuum chamber (using an MKS 246
  Flowmeter). The helium gas first thermalizes to 30 K and then to 3 K via
  copper bobbins on the two cryogenic stages. Thin-walled stainless steel
  tubes thermally isolate the bobbin stages from each other and from room
  temperature. High-purity helium is used to reduce the risk of clogging the
  flow tubes through condensation of impurities in the gas. The cooled helium
  enters the back of the cell through a 3.2 mm OD copper tube. The cell is
  formed by drilling two perpendicular holes (22.9 mm diameter) into a copper
  block, giving the cell an interior volume of <math|\<approx\>> 15
  cm<rsup|<math|3>> with characteristic size <math|L<rsub|c>\<approx\>2.5>
  cm. The size of the cell was chosen to be small such that large extraction
  of molecules into the beam could be achieved (see Eq.
  (<reference|eq:efficiency>)). The ablation target is mounted at 45 degrees
  relative to the molecular beam axis on a copper holder near the helium gas
  inlet. Cell windows are uncoated sapphire for maximum thermal conductivity
  and are sealed to the cell with indium for good thermal contact. AR coated
  windows are avoided since they tend to become opaque, presumably from
  reacting with products of the ablation.

  A mixture of helium, SrF, and other particles created via ablation exit the
  cell through a <math|d=3> mm diameter hole in a 0.5 mm thick copper plate
  at the front of the cell to form a beam. The beam passes through a 6 mm
  diameter hole in a coconut charcoal-covered 3K copper plate, typically
  placed 34 mm from the cell. This plate acts to reduce the helium gas load
  into the rest of the apparatus. 73 and 86 mm from the cell, the beam passes
  through holes in the 3K and 30K shields respectively, and propagates into a
  room temperature vacuum apparatus.

  We optically probe the SrF molecules at various distances <math|L<rsub|p>>
  from the exit aperture to measure the characteristics of the molecular
  beam. We have optical access to the molecular beam for 1 mm
  <math|\<less\>L<rsub|p>\<less\>> 65 mm through rectangular holes in the
  vacuum chamber and the radiation shields. All measurements for
  <math|L<rsub|p>\<gtr\>> 65 mm occur in the room-temperature beam region.
  This region consists of either a small cross or an octagonal structure. The
  cross has two viewports perpendicular to the molecular beam, and allows
  optical access to the beam at <math|L<rsub|p>=135> mm. The octagon has 6
  viewports, two perpendicular to the molecular beam and four oriented at
  <math|\<pm\>45<rsup|\<circ\>>>, and allows measurements at
  <math|L<rsub|p>=305> mm. Fig. <reference|fig:experimentdiagram> depicts the
  apparatus.

  A Nd:YAG laser (Big Sky Laser CFR200) produces 25 mJ pulses of 1064 nm
  light with <math|\<approx\>10> ns pulse duration for ablation of the
  molecular precursor target. The laser beam is expanded through a telescope
  to a diameter of <math|\<sim\>> 15 mm before being tightly focused onto the
  ablation target by a lens of focal length <math|f=20> cm. We note that the
  optimal conditions for focusing are observed to differ between species and
  targets; this configuration represents the optimum for production of SrF
  from our SrF<rsub|<math|2>> targets. Ablation targets are typically made by
  subjecting anhydrous SrF<rsub|<math|2>> powder (Sigma Aldrich 450030) to a
  pressure of 600 MPa using a die (Carver 3619) and a hydraulic press.

  The continuous operation time of the beam is limited in part by saturation
  of the charcoal cryopump. We use <math|\<approx\>> 400 cm<rsup|<math|2>> of
  charcoal and find that it is adequate to allow run times of <math|\<gtr\>>
  20 hours at <math|\<cal-F\>=5> sccm. At this flow rate we estimate the
  vacuum to be <math|\<sim\>4\<times\>10<rsup|-8>> Torr inside the cryogenic
  region based on measured pumping speeds for coconut charcoal
  <cite|Tobin1987|Sedgley1987>. Once the charcoal is saturated, it must be
  warmed to <math|\<gtrsim\>> 20 K to allow the He to desorb and then be
  removed by the room-temperature vacuum pumps. The regeneration process for
  the charcoal cryopump (including the subsequent cooldown) takes
  <math|\<sim\>> 1 hour. Outside the cryogenic region, a 70 L/s turbo pump
  maintains the vacuum at <math|\<sim\>5\<times\>10<rsup|-7>> Torr for a flow
  rate of <math|\<cal-F\>=5> sccm.

  <big-figure|<image|experimentdiagram.eps||2.5in||><label|fig:experimentdiagram>|Experimental
  setup. Absorption measurements were made in-cell, perpendicular to the beam
  with <math|1> mm <math|\<less\>L<rsub|p>\<less\>> 65 mm, at 30 degrees to
  the beam at <math|L<rsub|p>=20> mm, and perpendicular to the beam outside
  the cryostat at <math|L<rsub|p>=> 135 mm. Fluorescence measurements were
  made perpendicular to and at 45 degrees to the beam at <math|L<rsub|p>=305>
  mm using the octagonal room-temperature apparatus.>

  <big-figure|<image|typicalabsorptiontrace.eps||2.6in||><label|fig:typicalabsorptiontrace>|Typical
  raw absorption traces in the cell (<with|color|black|font-series|bold|<emdash><emdash>>)
  and immediately outside at <math|L<rsub|p>=1> mm
  (<with|color|red|font-series|bold|<emdash><emdash>>) for <math|\<cal-F\>=5>
  sccm (main figure) and <math|\<cal-F\>=> 50 sccm (inset). The in-cell and
  beam time traces are very similar to each other for each flow rate. For
  short times a rapid increase in the absorption signal occurs as population
  in the X (<math|N<rsub|r*o*t>=0>) state increases via thermalization and
  passes through the probe laser. At long times the absorption signal
  decreases as molecules are lost from the cell through the exit aperture,
  and through collisions with the cell walls.>

  <big-figure|<image|integratedabsorptionlineshape.eps||2.6in||><label|fig:integratedabsorptionlineshape>|Typical
  in-cell absorption Doppler profile. This spectrum was recorded by scanning
  a probe laser located inside the cell over the X
  (<math|v=0,N<rsub|r*o*t>=0>) <math|\<rightarrow\>> A
  (<math|v<rprime|'>=0,J<rprime|'>=3/2<rsup|->>) transition. This plot shows
  the total time-integrated absorption (traces similar to those shown in Fig.
  <reference|fig:typicalabsorptiontrace>) for each laser frequency. The four
  peaks correspond to the two <math|F=0,1> hyperfine levels for the two
  <rsup|<math|88>>Sr<rsup|<math|19>>F and <rsup|<math|86>>Sr<rsup|<math|19>>F
  isotopes as labeled. The hyperfine levels exhibit the expected 3:1 signal
  height ratios due to their Zeeman degeneracy, while the isotopes exhibit
  the expected 8.5:1 height ratio based on their natural abundance. The solid
  line indicates the Doppler fit as described in the main text.>

  <section|Experimental Results>

  We probe the number, temperature, and velocities of SrF in the cell and in
  the beam with resonant laser light from an external cavity diode laser
  using either absorption or laser-induced fluorescence (LIF). Unless
  explicitly noted otherwise, the laser drives
  <math|Q<rsub|11>*<around|(|1/2|)>> transitions from the ground state,
  X<math|<rsup|2>\<Sigma\><rsup|+><rsub|1/2>*<around|(|v=0,N<rsub|r*o*t>=0,J=1/2|)>>,
  to the electronically excited state, A<math|<rsup|2>\<Pi\><rsub|1/2>*<around|(|v<rprime|'>=0,J<rprime|'>=1/2<rsup|->|)>>,
  at 663 nm as defined in <cite|Shuman2009>.

  <subsection|In-cell Dynamics and SrF Properties>

  <subsubsection|Thermalization>

  In Fig. <reference|fig:typicalabsorptiontrace> we show typical in-cell
  absorption time traces. At time <math|t=0> the ablation laser pulse fires.
  For the first <math|\<sim\>500> <math|\<mu\>>s after the ablation pulse,
  the number of molecules in the <math|N<rsub|r*o*t>=0> state rapidly
  increases as SrF molecules thermalize with the 3K helium gas and pass
  through the probe laser. This process causes the initial sharp increase in
  the absorption shown in Fig. <reference|fig:typicalabsorptiontrace>.
  Although we did not study in-cell thermalization in detail, we can compare
  this thermalization time to that predicted by Eq.
  (<reference|eq:thermalizationtime>). There are no measurements of
  <math|\<sigma\><rsub|S*r*F-H*e>>, so we assume that
  <math|\<sigma\><rsub|S*r*F-H*e>\<approx\>\<sigma\><rsub|H*e-H*e>=1.05\<times\>10<rsup|-14>>
  cm<rsup|<math|2>> <cite|Dondi1969>. The calculated value of
  <math|\<tau\><rsub|T*h>> also depends on the value of <math|n<rsub|H*e>>.
  Here and for the remainder of this paper, <math|\<kappa\>> is estimated to
  be the geometric mean of the completely effusive and completely supersonic
  limiting cases, which yields <math|\<kappa\>=1.5>. For <math|\<cal-F\>=5>
  sccm this corresponds to a density <math|n<rsub|H*e>=3.5\<times\>10<rsup|15>>
  cm<rsup|<math|-3>>. We also estimate here and throughout that the initial
  translational temperature of the SrF molecules is
  <math|T<rsub|S*r*F><around|(|0|)>=10<rsup|4>> K <cite|Davis1985>. However
  we note the thermalization characteristics of this model depend only weakly
  on <math|T<rsub|S*r*F><around|(|0|)>>. Under these assumptions we obtain
  <math|\<tau\><rsub|T*h>\<approx\>250> <math|\<mu\>>s, which is in
  reasonable agreement with our observations.

  After the initial thermalization time, the absorption signal peaks and then
  decays as the molecules diffuse throughout the cell to the walls, and are
  pumped out the exit aperture. By fitting this decay to an exponential, we
  can determine the molecule removal time constant
  <math|\<tau\><rsub|r*m*v*l>>. For example, we find
  <math|\<tau\><rsub|r*m*v*l>=7> ms for the in-cell data with
  <math|\<cal-F\>=5> sccm shown in Fig. <reference|fig:typicalabsorptiontrace>.
  We find that <math|\<tau\><rsub|r*m*v*l>> depends critically on ablation
  parameters. Under only nominally different ablation locations on the
  target, or slightly different YAG focusing conditions, we observe that
  <math|\<tau\><rsub|r*m*v*l>> can vary by a factor of 2 or more. This
  indicates that the simple model of diffusion and extraction is heavily
  perturbed by the ablation process. We also find that for high flow rates,
  <math|\<cal-F\>\<gtrsim\>30> sccm, the temporal shape of the absorption
  signal changes significantly as shown in the inset of Fig.
  <reference|fig:typicalabsorptiontrace>, indicating more complicated in-cell
  processes than just simple diffusion. Nonetheless, by fitting the decay at
  long times to an exponential, we find that <math|\<tau\><rsub|r*m*v*l>> is
  of the same order of magnitude as either
  <math|\<tau\><rsub|p*u*m*p><rsup|H*e>> or <math|\<tau\><rsub|d*i*f*f>> for
  all flow rates investigated. For example, at <math|\<cal-F\>=5> sccm,
  <math|\<tau\><rsub|d*i*f*f>=1.2> ms, <math|\<tau\><rsub|r*m*v*l>=7> ms, and
  <math|\<tau\><rsub|p*u*m*p><rsup|H*e>=25> ms.

  <subsubsection|In-cell Translational, Rotational and Vibrational
  Temperature>

  During thermalization, collisions with <math|b> cause the in-cell
  translational temperature of SrF, <math|T<rsub|S*r*F><rsup|c*e*l*l>>, to
  cool. We obtain <math|T<rsub|S*r*F><rsup|c*e*l*l>> and in-cell velocity
  distributions for the molecules by incrementally scanning the probe laser
  frequency and recording a signal trace in time for each discrete frequency.
  The raw signals are integrated in time, starting 300 <math|\<mu\>>s after
  the ablation for a duration of 20 ms unless explicitly noted otherwise. A
  typical in-cell absorption spectrum is shown in Fig.
  <reference|fig:integratedabsorptionlineshape>. The four peaks correspond to
  the two <math|F=0,1> hyperfine levels for
  <rsup|<math|86>>Sr<rsup|<math|19>>F and
  <rsup|<math|88>>Sr<rsup|<math|19>>F. The integrated signal versus frequency
  lineshape is then fit to a sum of four Gaussians. The relative amplitudes
  of the Gaussians are constrained by the known abundance of the Sr isotopes
  and the Zeeman degeneracies for the hyperfine levels. The widths of the
  Gaussians are constrained to be the same for each peak. From the fitted
  width we extract a translational Doppler temperature and a velocity
  distribution.

  We find <math|T<rsup|c*e*l*l><rsub|S*r*F>\<approx\>5> K over the full range
  of flow rates investigated. The value of
  <math|T<rsup|c*e*l*l><rsub|S*r*F>\<approx\>5> K we observe is larger than
  the temperature of the cell, <math|T<rsub|0>\<approx\>3> K. This is
  believed to be due to the initial heating of the buffer gas by the ablation
  of the target. In support of this claim, we have measured the in-cell
  translational Doppler width in 1 ms time increments after ablation and
  found that the translational width decreases at longer times
  (<math|t\<gtrsim\>2> ms), despite the fact that these observation times are
  very long compared to <math|\<tau\><rsub|T*h>>. This type of behavior has
  also been observed in other similar experiments <cite|Skoff2010>.

  Thermalization also cools the in-cell rotational temperature,
  <math|T<rsub|r*o*t><rsup|c*e*l*l>>. For temperatures <math|\<sim\>4> K,
  typically <math|\<sigma\><rsub|S*r*F-H*e>/\<sigma\><rsup|r*o*t><rsub|S*r*F-H*e>\<sim\>10-100>
  <cite|Ball1999|Krems2009>. However, due to the large mass mismatch between
  SrF and He, overall we expect both translational and rotational
  thermalization to occur with similar efficiency. We determine
  <math|T<rsub|r*o*t><rsup|c*e*l*l>> by comparing the relative populations in
  the X (<math|N<rsub|r*o*t>=0-4>) states using the
  X<math|<rsup|2>\<Sigma\><rsup|+><rsub|1/2>>(<math|v=0,N<rsub|r*o*t>=0-4>)
  <math|\<rightarrow\>> A<math|<rsup|2>\<Pi\><rsub|1/2>>(<math|v<rprime|'>=0,J<rprime|'>=1/2<rsup|->-9/2<rsup|->>)
  transitions. We then fit the relative populations to a Boltzmann
  distribution. As shown in Fig. <reference|fig:rotationalinsideoutsidechecked>,
  inside the cell we find <math|T<rsub|r*o*t><rsup|c*e*l*l>=5.3> K,
  comparable to results obtained with a similar apparatus and another
  molecular species <cite|Lu2009>. We note
  <math|T<rsup|c*e*l*l><rsub|S*r*F>\<approx\>T<rsub|r*o*t><rsup|c*e*l*l>> as
  expected.

  Vibrational temperatures are expected to thermalize much more slowly than
  the rotational and translational temperatures because
  <math|\<sigma\><rsup|v*i*b><rsub|S*r*F-H*e>\<ll\>\<sigma\><rsub|S*r*F-H*e>>.
  In Fig. <reference|fig:vibrationalpopulationschecked> we plot the relative
  populations of the first four vibrational levels
  <math|<around|(|v=0,1,2,3|)>> inside the cell obtained by probing the
  X<math|<rsup|2>\<Sigma\><rsup|+><rsub|1/2>>(<math|v=0-3,N<rsub|r*o*t>=0>)
  <math|\<rightarrow\>> A<math|<rsup|2>\<Pi\><rsub|1/2>>(<math|v<rprime|'>=0-3,J<rprime|'>=1/2<rsup|->>)
  transitions. As shown in Fig. <reference|fig:vibrationalpopulationschecked>,
  the data cannot be described by a Boltzmann distribution. Nonetheless, we
  can roughly characterize the distribution by fitting the relative
  populations of the first two vibrational levels to a Boltzmann distribution
  to yield the in-cell vibrational temperature,
  <math|T<rsup|c*e*l*l><rsub|v*i*b>\<sim\><space|-0.17em>300> K. We find that
  <math|T<rsup|c*e*l*l><rsub|v*i*b>\<gg\>T<rsub|0>> which indicates that the
  vibrational degree of freedom has not completely thermalized with the
  helium buffer gas. Nevertheless, <math|T<rsup|c*e*l*l><rsub|v*i*b>> is
  still far lower than would be expected for that of unthermalized ablation
  products.

  <big-figure|<image|yieldversusflowrate.eps||2.6in||><label|fig:yieldversusflowrate>|Number
  of SrF molecules <math|N<rsub|S*r*F><rsup|c*e*l*l>> at <math|L<rsub|p>=-1>
  mm <with|font-size|0.84|(<with|font-size|0.71|<math|\<blacksquare\>>>) and
  <math|N<rsub|S*r*F><rsup|b*e*a*m>> at <math|L<rsub|p>=+1> mm
  (<with|font-size|1.19|color|red|mode|math|\<bullet\>>), as a function of
  <math|\<cal-F\>>. Although the parameter <math|\<xi\>> in Eq.
  (<reference|eq:efficiency>) varies between 0.01 and 0.5 over the flow rates
  examined here, the data indicate an extraction efficiency of
  <math|\<epsilon\>\<approx\>0.5> independent of <math|\<cal-F\>>. >>

  <subsubsection|SrF Yield>

  In Fig. <reference|fig:yieldversusflowrate> we show the number of molecules
  in the <math|N<rsub|r*o*t>=0> state created in the cell,
  <math|N<rsup|c*e*l*l><rsub|S*r*F>>, for various flow rates and approximate
  values of <math|n<rsub|H*e>>. The number of molecules is determined through
  the direct absorption of an in-cell probe laser with a diameter of 2 mm
  located at <math|L<rsub|p>=-1> mm (1 mm before the exit aperture). For a
  resonant probe laser sampling species <math|a> over a path length
  <math|L<rsub|s>>, the ratio of the transmitted power <math|P<rsub|T>> to
  the initial power <math|P<rsub|0>> will vary as

  <\equation>
    <label|eq:simpleabsorption><frac|P<rsub|T>|P<rsub|0>>=e<rsup|-n<rsub|a>*L<rsub|s>*\<sigma\><rsub|D>>.
  </equation>

  Here <math|\<sigma\><rsub|D>> is the Doppler broadened absorption cross
  section <cite|Budker2008>, which is calculated from the lifetime of the
  A<math|<rsup|2>\<Pi\><rsub|1/2>> state and the Hnl-London factors
  <cite|Sauer2009> for SrF. We use the peak absorption signal to calculate
  the in-cell number. Using Eq. (<reference|eq:simpleabsorption>) and
  assuming a uniform <math|n<rsub|S*r*F>> within the entire volume of the
  cell, we obtain <math|N<rsub|S*r*F><rsup|c*e*l*l>>.

  As shown in Fig. <reference|fig:yieldversusflowrate>,
  <math|N<rsup|c*e*l*l><rsub|S*r*F>> increases with <math|\<cal-F\>> for
  flows up to <math|F\<sim\><space|-0.17em>5> sccm, then reaches a maximum
  value of <math|N<rsub|S*r*F><rsup|c*e*l*l>\<approx\>4\<times\>10<rsup|10>>
  and remains constant for higher flow rates. We attribute the decrease in
  <math|N<rsub|S*r*F><rsup|c*e*l*l>> at low flow rates to insufficient helium
  density to completely thermalize all the molecules. The helium density at
  <math|\<cal-F\>=5> sccm is <math|n<rsub|H*e>\<approx\>3.5\<times\>10<rsup|15>>
  cm<rsup|<math|-3>>, which is in reasonable agreement with the minimum
  density required for thermalization as predicted by Eq.
  (<reference|eq:thermalizationdensity>),
  <math|n<rsub|T*h>\<approx\>1.5\<times\>10<rsup|-15>> cm<rsup|<math|-3>>.

  <subsection|Molecular Beam Properties>

  In Fig. <reference|fig:typicalabsorptiontrace> we show a typical absorption
  time trace taken for <math|\<cal-F\>=5> sccm with the probe laser located
  at <math|L<rsub|p>=1> mm (just outside the cell exit aperture). The
  molecules that exit the cell exhibit a similar temporal profile as
  molecules in the cell. As the SrF molecules exit the cell, the number of
  collisions between SrF and helium in and around the exit aperture largely
  determines the properties of the molecular beam far downstream. We expect
  <math|R*e<rsub|S*r*F>\<gtr\>R*e<rsub|H*e>> as discussed previously, but
  since we do not have an accurate value for
  <math|\<sigma\><rsub|S*r*F-H*e>>, we solely use <math|R*e<rsub|H*e>> to
  provide a qualitative indicator of whether the molecular beam should
  exhibit supersonic or effusive characteristics. Values of
  <math|R*e<rsub|H*e>> are estimated using Eqns.
  (<reference|eq:meanfreepath>) and (<reference|eq:n>).

  <subsubsection|Extraction from Cell>

  We determine the number of molecules in the X (<math|N<rsub|r*o*t>=0>)
  state which exit the cell by measuring the absorption of a resonant probe
  laser with diameter small compared to <math|d> and located at
  <math|L<rsub|p>=1> mm. We then time-integrate the resonant absorption
  traces (similar to the one shown in Fig.
  <reference|fig:typicalabsorptiontrace>). We also assume a uniform
  <math|n<rsub|S*r*F>> over the same area as the exit aperture and the
  measured Doppler spread (<math|\<approx\>5> K). The number of molecules in
  the beam at distance <math|L<rsub|p>> from the aperture,
  <math|N<rsub|a><rsup|b*e*a*m>>, can then be found using

  <\equation>
    <label|eq:beamnumber>N<rsub|a><rsup|b*e*a*m>=<frac|A<rsub|d>*v<rsub|a\<parallel\>>|L<rsub|s>*\<sigma\><rsub|D>>*<big|int>ln
    <around*|[|<frac|P<rsub|0>|P<rsub|T>>|]>*d*t,
  </equation>

  where <math|P<rsub|0>/P<rsub|T>> is the ratio of incident to transmitted
  power of the probe laser and <math|A<rsub|d>> is the cross sectional area
  of the molecular beam at <math|L<rsub|p>>, determined either by geometric
  constraints after any collimators or by the measured divergence of the beam
  prior to any collimators. In Fig. <reference|fig:yieldversusflowrate> we
  plot <math|N<rsub|S*r*F><rsup|c*e*l*l>> (at <math|L<rsub|p>=-1> mm) and
  <math|N<rsub|S*r*F><rsup|b*e*a*m>> immediately outside the cell (at
  <math|L<rsub|p>=1> mm) for various flow rates. By comparing the number of
  molecules inside and just outside the cell, we can determine the extraction
  efficiency <math|\<epsilon\>> for the cell. Over the range of flows
  examined, the ratio of the estimated diffusion time to the estimated
  pumpout time, <math|\<xi\>>, varies between 0.01 and 0.5. Based on the
  extraction model presented earlier, we would crudely expect
  <math|\<epsilon\>> to vary between <math|\<epsilon\><rsub|e*f*f>\<sim\>0.003>
  and <math|\<epsilon\><rsub|h*y*d>\<sim\>1> over this range. Instead, we
  find that <math|\<epsilon\>\<sim\><space|-0.17em>0.5>, independent of
  <math|\<cal-F\>> over this range. This suggests that the extraction model
  presented earlier is too simplistic to fully capture the dynamics inside
  the cell.

  <big-figure|<image|transversewidthversusdistancefromaperturechecked.eps||2.6in||>
  <image|transversevelocityversusflowratechecked.eps||2.6in||><label|fig:transversewidthversusdistancefromaperturechecked>|(a)
  FWHM transverse velocity of the molecular beam
  <math|\<Delta\>*v<rsub|S*r*F\<perp\>>> versus probe distances
  <math|L<rsub|p>>, for <math|\<cal-F\>=>
  5(<with|color|blue|mode|math|\<blacktriangle\>>),
  15<with|font-size|0.84|(<with|font-size|1.19|color|red|mode|math|\<bullet\>>),
  and 30(<with|font-size|0.71|<math|\<blacksquare\>>>) sccm respectively. We
  observe <math|\<Delta\>*v<rsub|S*r*F\<perp\>>> is consistent with a
  <math|\<sim\><space|-0.17em>5> K Boltzmann distribution for SrF just
  outside the cell, and that <math|\<Delta\>*v<rsub|S*r*F\<perp\>>> increases
  with increasing probe distance <math|L<rsub|p>> before leveling off for
  <math|L<rsub|p>\<gtrsim\>10> mm. Larger values of <math|\<cal-F\>> result
  in greater final values of <math|\<Delta\>*v<rsub|S*r*F\<perp\>>>. The
  value of <math|\<Delta\>*v<rsub|S*r*F\<perp\>><rsup|e>> is calculated from
  <cite|Ramsey1956>. (b) FWHM transverse velocity of the molecular beam
  versus <math|\<cal-F\>> for <math|L<rsub|p>=20> mm, where the width is no
  longer increasing with distance from the cell. We attribute the increase in
  <math|\<Delta\>*v<rsub|S*r*F\<perp\>>> with increasing <math|\<cal-F\>> to
  a helium pressure gradient outside the cell, as discussed in the main text.
  Error bars in this and in all figures hereon represent the standard
  deviation of a set of several (typically 3-10) data points taken under
  nominally identical conditions.>>

  <big-figure|<image|beamdivergenceversusflowrate.eps||2.6in||><label|fig:beamdivergenceversusflowrate>|Molecular
  beam divergence for various flow rates. The final beam divergence
  demonstrates little dependence on <math|\<cal-F\>>. Included is a
  comparison of beam divergences for different types of beams. The beam in
  this work is more directional than either an effusive beam or a
  single-species supersonic free jet expansion from an ideal aperture. The
  divergence of an effusive beam is calculated from <cite|Ramsey1956> while
  the divergence of a single-species supersonic free jet expansion from an
  ideal aperture is calculated from <cite|Tejeda1996>, in agreement with
  measurements <cite|Hillenkamp2003>.>

  <subsubsection|Beam Transverse Measurements>

  As the SrF molecules propagate from the cell, they experience fewer
  collisions with the helium buffer gas, as its density falls as
  <math|1/L<rsub|p><rsup|2>>. However, the expansion of the helium gas into
  the vacuum outside the cell and ongoing helium-SrF collisions dramatically
  change the characteristics of the beam. An example of this behavior is
  shown in Fig. <reference|fig:transversewidthversusdistancefromaperturechecked>(a).
  Here we plot the FWHM transverse velocity spread,
  <math|\<Delta\>*v<rsub|S*r*F\<perp\>>>, of the molecular beam as a function
  of <math|L<rsub|p>> for a few different values of <math|\<cal-F\>>. Within
  one hole radius of the aperture, <math|\<Delta\>*v<rsub|S*r*F\<perp\>>> was
  measured to be consistent with a <math|\<sim\><space|-0.17em>5> K Boltzmann
  distribution for SrF, independent of <math|\<cal-F\>>. This value is very
  similar to <math|T<rsup|c*e*l*l><rsub|S*r*F>\<approx\>5> K. However,
  <math|\<Delta\>*v<rsub|S*r*F\<perp\>>> increases at further distances
  downstream before leveling off to a constant value, as shown in Fig.
  <reference|fig:transversewidthversusdistancefromaperturechecked>(a), with
  larger <math|\<cal-F\>> resulting in larger final values of
  <math|\<Delta\>*v<rsub|S*r*F\<perp\>>>. The broadening of
  <math|\<Delta\>*v<rsub|S*r*F\<perp\>>> outside the aperture nozzle is in
  qualitative agreement with the presence of a He pressure gradient
  transverse to the molecular beam outside the cell
  <cite|Sherman1965|Dun1979|Ramos2009>. This would cause the greatest rate of
  broadening closest to the cell aperture where pressure gradients are
  strongest. Larger values of <math|\<cal-F\>> would also produce larger
  pressure gradients, resulting in greater broadening of
  <math|\<Delta\>*v<rsub|S*r*F\<perp\>>>. Additional broadening beyond
  <math|L<rsub|p>\<gtrsim\>10> mm is not observed, as shown in Fig.
  <reference|fig:transversewidthversusdistancefromaperturechecked>(a),
  indicating that collisions with helium no longer affect the characteristics
  of the SrF beam beyond this distance. Fig.
  <reference|fig:transversewidthversusdistancefromaperturechecked>(b) depicts
  <math|\<Delta\>*v<rsub|S*r*F\<perp\>>> for <math|L<rsub|p>=20> mm for a
  variety of flow rates <math|\<cal-F\>>. Combining this data with the beam
  forward velocities measured in the next section, we determine the beam
  divergence to be nominally independent of <math|\<cal-F\>> as shown in Fig.
  <reference|fig:beamdivergenceversusflowrate>. Compared to both an effusive
  beam and a single-species supersonic free jet expansion beam from an ideal
  aperture, the beam in this work is significantly more directional.

  <big-figure|<image|forwardvelocityversusflowratechecked.eps||2.6in||><label|fig:forwardvelocityversusflowratechecked>|Forward
  velocity for various flow rates. The data were taken at <math|L<rsub|p>=15>
  mm in absorption <with|font-size|0.84|(<with|font-size|0.71|<math|\<blacksquare\>>>)
  and at <math|L<rsub|p>=305> mm using LIF
  (<with|font-size|1.19|color|blue|mode|math|\<bullet\>>). For all
  <math|\<cal-F\>> we observe <math|v<rsub|S*r*F\<parallel\>>\<gtr\>v<rsub|S*r*F\<parallel\>><rsup|e>>.
  Although we estimate <math|R*e<rsub|H*e>\<sim\>1> for the lowest
  <math|\<cal-F\>>, this observation indicates that there are still enough
  collisions in the aperture to boost the forward velocity of SrF above
  <math|v<rsub|S*r*F\<parallel\>><rsup|e>>. At the highest <math|\<cal-F\>>
  where <math|R*e<rsub|H*e>\<gg\>1>, we observe
  <math|v<rsub|S*r*F\<parallel\>>\<less\>v<rsub|H*e\<parallel\>><rsup|s>>, as
  we expect. Measurements at different values of <math|L<rsub|p>> are in good
  agreement.>>

  <big-figure|<image|forwardvelocityspreadversusflowratechecked.eps||2.6in||><label|fig:forwardvelocityspreadversusflowratechecked>|FWHM
  forward velocity spread for various flow rates. The typical measured value
  of <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>\<approx\>75*<frac|m|s>> is
  roughly constant across the range of <math|\<cal-F\>> explored. The value
  of <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>> is well above the maximum
  expected value of <math|\<Delta\>*v<rsub|S*r*F\<parallel\>><rsup|e>>
  (<with|color|blue|font-series|bold|<emdash><emdash>>), calculated from
  <cite|Ramsey1956>. We note as well that for fixed <math|\<cal-F\>>, the
  measured values of <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>> varied
  appreciably (<math|\<sim\>40%>) under nominally identical conditions. These
  observations are not compatible with the simple thermalization model
  presented in the text, and suggest that the ablation significantly perturbs
  the in-cell thermalization process.>

  <big-figure|<image|binnedforwarddata.eps||2.6in||><label|fig:binnedforwarddata>|Measured
  forward velocity <with|font-size|0.84|(<with|font-size|1.19|color|black|mode|math|\<bullet\>>),
  measured forward velocity spread (<with|font-size|0.71|color|blue|mode|math|\<blacksquare\>>),
  simulated forward velocity (<with|font-size|1|color|black|mode|math|\<circ\>>)
  and simulated forward velocity spread (<with|font-size|0.71|color|blue|mode|math|\<Box\>>)
  versus time. The data were taken at <math|L<rsub|p>=305> mm in LIF using 1
  ms time bins for a flow rate of <math|\<cal-F\>=5> sccm. The size of the
  points indicate relative molecule number. The measured data indicate that
  both <math|v<rsub|S*r*F\<parallel\>>> and
  <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>> vary significantly over the time
  the beam persists; molecules detected earliest have the largest
  <math|v<rsub|S*r*F\<parallel\>>> and <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>>,
  and both decrease with time. The simulated data assume a time-invariant
  gaussian velocity distribution at the exit aperture with
  <math|v<rsub|S*r*F\<parallel\>>=145> m/s and
  <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>=75> m/s; thus, the time
  dependence of the simulated data downstream is solely due to time of flight
  effects. Although the simulated data exhibit similar time variation in
  <math|v<rsub|S*r*F\<parallel\>>>, the magnitude of the effect is not
  sufficient to completely describe the measurements. Furthermore the
  simulation is in qualitative disagreement with the measured time variation
  in <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>>. These observations are
  consistent with initial heating of the buffer gas at early times, as
  described previously.>>

  <subsubsection|Beam Forward Velocity and Temperature>

  The remainder of the measurements are made for <math|L<rsub|p>\<gtr\>10>
  mm, where collisions within the beam have largely ceased, and the
  characteristics of the beam are expected to be static. In Fig.
  <reference|fig:forwardvelocityversusflowratechecked> we show the measured
  dependence of the beam forward velocity, <math|v<rsub|S*r*F\<parallel\>>>,
  on the helium flow rate <math|\<cal-F\>> taken at two different places
  downstream from the cell. For <math|L<rsub|p>=15> mm, we determine
  <math|v<rsub|S*r*F\<parallel\>>> by comparing the Doppler shifts of direct
  absorption profiles of two probe lasers, one normal to the molecular beam
  and one at 30 degrees relative to normal. For <math|L<rsub|p>=305> mm, the
  same technique is employed but using LIF instead.

  For all values of <math|\<cal-F\>>, we observe
  <math|v<rsub|S*r*F\<parallel\>>\<gtr\>v<rsub|S*r*F\<parallel\>><rsup|e>>,
  indicating that there are still sufficient collisions near the aperture to
  cause significant increase in <math|v<rsub|S*r*F\<parallel\>>> even at the
  lowest flow rates where <math|R*e<rsub|H*e>\<sim\>1>. At the highest
  <math|\<cal-F\>> where <math|R*e<rsub|H*e>\<gg\>1>, we expect that
  <math|v<rsub|S*r*F\<parallel\>>> should approach
  <math|v<rsup|s><rsub|H*e\<parallel\>>>, in agreement with our observations.
  However even at the highest <math|\<cal-F\>>,
  <math|v<rsub|S*r*F\<parallel\>>\<less\>v<rsub|H*e\<parallel\>><rsup|s>>.
  Since we cannot measure the forward velocity of the helium in the beam,
  <math|v<rsub|H*e\<parallel\>>>, this observation may simply result from
  <math|v<rsub|H*e\<parallel\>>\<less\>v<rsup|s><rsub|H*e\<parallel\>>> with
  <math|v<rsub|S*r*F\<parallel\>>=v<rsub|H*e\<parallel\>>>. It may also be
  due to the phenomenon known as velocity slip, where the speed of the seeded
  species does not get fully boosted to the speed of the carrier
  <cite|Mazely1995|Abuaf1967|Pauly2000|Scoles88|Dea2009>.

  In Fig. <reference|fig:forwardvelocityspreadversusflowratechecked> we show
  the FWHM of the forward velocity, <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>>,
  for various values of <math|\<cal-F\>>.
  <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>> was measured in LIF by varying
  the frequency of a <math|45<rsup|\<circ\>>> probe laser 305 mm downstream
  and integrating over the entire duration of the molecular beam pulse. An
  aperture collimates the molecular beam so that the transverse Doppler width
  is reduced to near the natural linewidth of the X-A probe transition
  (<math|\<approx\>7> MHz). The Doppler broadening from the forward velocity
  of the beam is substantially larger than this
  (<math|\<sim\><space|-0.17em>100> MHz); thus, fitting these distributions
  to a Gaussian enables extraction of the forward temperatures of the
  molecular beam. For the range of <math|\<cal-F\>> explored, the typical
  measured values of <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>\<approx\>75*<frac|m|s>>
  (corresponding to <math|T<rsub|S*r*F\<parallel\>>\<approx\>13> K) are well
  above <math|\<Delta\>*v<rsub|S*r*F\<parallel\>><rsup|e>>. This is in
  contrast to the behavior of typical seeded free jet expansions where
  <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>\<less\>\<Delta\>*v<rsub|S*r*F\<parallel\>><rsup|e>>
  due to cooling during the isentropic expansion.

  A number of observations regarding the forward velocity suggest that the
  simplistic thermalization model described previously may not be adequate to
  describe this system. For example, we find that the measured values of
  <math|v<rsub|S*r*F\<parallel\>>> and <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>>
  vary by <math|\<sim\><space|-0.17em>15%> under nominally similar ablation
  conditions, depending on the location ablated on the target. Specifically,
  ablating closest to the He gas inlet and furthest from the exit aperture
  tended to produce the lowest <math|v<rsub|S*r*F\<parallel\>>> and
  <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>>. We also find that the
  characteristics of the ablation laser also change
  <math|v<rsub|S*r*F\<parallel\>>> and <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>>.
  In particular, the focus and the power of the ablation laser can alter
  <math|v<rsub|S*r*F\<parallel\>>> and <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>>
  by <math|\<sim\><space|-0.17em>15%>. Finally, we observe very fast
  molecules (<math|\<gtrsim\>225> m/s) with large
  <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>> at early times
  (<math|t\<lesssim\>2> ms) in the molecular pulse, as shown in Fig.
  <reference|fig:binnedforwarddata>. The observed time variation in
  <math|v<rsub|S*r*F\<parallel\>>> and <math|\<Delta\>*v<rsub|S*r*F\<parallel\>>>
  cannot be fully explained by time of flight effects, which suggests that
  molecules leaving the cell at different times thermalize to different
  temperatures. These observations are difficult to explain using the simple
  models outlined earlier, and suggest more complicated in-cell dynamics.

  <big-figure|<image|rotationalinsideoutsidechecked.eps||2.6in||><label|fig:rotationalinsideoutsidechecked>|Fractional
  rotational populations in-cell <with|font-size|0.84|(<with|font-size|1.19|color|black|mode|math|\<bullet\>>)
  and at <math|L<rsub|p>=20> mm downstream
  (<with|font-size|0.71|color|red|mode|math|\<blacksquare\>>), with
  associated fits to a Boltzmann distribution. This data was taken at
  <math|\<cal-F\>=5> sccm. The fits indicate
  <math|T<rsup|c*e*l*l><rsub|r*o*t>=5.3> K and
  <math|T<rsup|b*e*a*m><rsub|r*o*t>>(<math|L<rsub|p>=20> mm) <math|=1.2> K;
  this shows substantial rotational cooling as the beam leaves the cell.>>

  <big-figure|<image|rotationaltemperatureversusflowratechecked.eps||2.6in||><label|fig:rotationaltemperatureversusflowratechecked>|<math|T<rsub|r*o*t><rsup|b*e*a*m>(L<rsub|p>=20>
  mm) versus <math|\<cal-F\>>. For the range of <math|\<cal-F\>>
  investigated, rotational temperatures in the beam are <math|\<approx\>> 1
  K. While we expect <math|T<rsub|r*o*t><rsup|b*e*a*m>> to decrease with
  increasing <math|\<cal-F\>>, these observations are consistent with other
  free jet sources that show a termination of rotational cooling. These
  temperatures were determined by a fit to data similar to those shown in
  Fig. <reference|fig:rotationalinsideoutsidechecked>. >

  <big-figure|<image|vibrationalpopulationschecked.eps||2.6in||><label|fig:vibrationalpopulationschecked>|Relative
  vibrational populations in-cell <with|font-size|0.84|(<with|font-size|0.71|<math|\<blacksquare\>>>)
  and at <math|L<rsub|p>=> 10 mm (<with|font-size|1.19|color|red|mode|math|\<bullet\>>),
  at <math|\<cal-F\>=5> sccm. Both datasets are normalized to 1 at
  <math|v=0>. The data cannot be fit to a simple Boltzmann distribution as
  the population does not decrease exponentially with <math|v>. This
  indicates that the vibrational degree of freedom does not completely
  thermalize with the helium buffer gas. If we extract a temperature from the
  ratio of populations in only the first two vibrational levels, we obtain
  <math|T<rsup|c*e*l*l><rsub|v*i*b>\<approx\>T<rsup|b*e*a*m><rsub|v*i*b>\<approx\>>
  300 K. This is substantially higher than <math|T<rsub|0>>, but still
  significantly lower than the initial temperature of the SrF molecules
  created through ablation. We observe little or no cooling of the
  vibrational degree of freedom in the beam.>>

  <subsubsection|Beam Rotational and Vibrational Temperature>

  In Fig. <reference|fig:rotationalinsideoutsidechecked> we show the relative
  rotational populations measured at <math|L<rsub|p>=10> mm for
  <math|\<cal-F\>=5> sccm. This distribution is consistent with a beam
  rotational temperature of <math|T<rsub|r*o*t><rsup|b*e*a*m>=1.2> K and is
  significantly colder than the measured in-cell rotational temperature of
  <math|T<rsup|c*e*l*l><rsub|r*o*t>=5.3> K. The observation of
  <math|T<rsup|c*e*l*l><rsub|r*o*t>\<gtr\>T<rsup|b*e*a*m><rsub|r*o*t>> is
  attributed to cooling of rotational degrees of freedom via collisions near
  the aperture, as is typically observed in standard free jet expansions
  <cite|Scoles88|Pauly2000>.

  In a separate measurement at <math|L<rsub|p>=> 20 mm downstream, similar
  rotational cooling was observed for a variety of <math|\<cal-F\>>, as shown
  in Fig. <reference|fig:rotationaltemperatureversusflowratechecked>. We find
  that <math|T<rsup|b*e*a*m><rsub|r*o*t>\<approx\>1> K for all flow rates
  investigated. Since the number of collisions outside the aperture is
  expected to scale linearly with <math|\<cal-F\>>, it is interesting that
  there is little change in <math|T<rsup|b*e*a*m><rsub|r*o*t>> over the range
  <math|\<cal-F\>> = 5-30 sccm. The measured values of
  <math|T<rsup|b*e*a*m><rsub|r*o*t>> may be compared to the conservative
  upper limit on the ultimate downstream He temperature at these flow rates
  using Eq. (<reference|eq:supersonicfinaltemp>). In this limit we find
  <math|T<rsub|H*e><rsup|b*e*a*m>> <math|\<less\>> 2.38 K, 0.99 K and 0.57 K
  for <math|\<cal-F\>> = 5, 15 and 30 sccm respectively. Similar results
  demonstrating <math|T<rsub|r*o*t><rsup|b*e*a*m>> largely independent of
  backing pressure have been observed for CO seeded in room-temperature He
  <cite|Ahern1999>.

  In Fig. <reference|fig:vibrationalpopulationschecked> we plot the relative
  vibrational populations in the beam at <math|L<rsub|p>> = 10 mm. Little if
  any cooling of the higher vibrational levels in the beam was observed; this
  is consistent with the notion that many more collisions are required to
  thermalize the vibrational degree of freedom <cite|Krems2009> than the
  rotational or translational degrees of freedom.

  <big-figure|<image|brightnessversusflowrate.eps||2.6in||><label|fig:brightnessversusflowrate>|<math|\<cal-B\>>
  for various flow rates <math|\<cal-F\>> measured at <math|L<rsub|p>=> 1 mm
  <with|font-size|0.84|(<with|font-size|0.71|<math|\<blacksquare\>>>) and
  <math|L<rsub|p>=> 135 mm (<with|font-size|1.19|color|red|mode|math|\<bullet\>>).
  The data indicate the beam is attenuated over long distances, when the cell
  is operated at flow rates <math|F\<gtrsim\>20> sccm. The peak downstream
  signal (at <math|\<cal-F\>=5-20> sccm) corresponds to
  <math|\<cal-B\>\<approx\>1.2\<times\>10<rsup|11>> <math|N<rsub|r*o*t>=0>
  molecules/sr/pulse. The increased <math|\<cal-B\>> downstream versus
  upstream at low flow rates is likely due to rotational cooling in the beam.
  Downstream data were taken with the plate at <math|L<rsub|d>=34> mm.>>

  <subsubsection|Beam Brightness>

  Finally, we have measured <math|\<cal-B\>>, the brightness of the molecular
  beam in the X (<math|N<rsub|r*o*t>=0>) state, both just outside the cell
  (at <math|L<rsub|p>=1> mm) and at <math|L<rsub|p>=135> mm in a
  room-temperature environment, as shown in Fig.
  <reference|fig:brightnessversusflowrate>. Inside the cryostat, geometrical
  constraints make further slowing, trapping, or precision spectroscopy of
  the molecular beam quite challenging, so <math|\<cal-B\>(L<rsub|p>=135> mm)
  is representative of the useful beam brightness for most experiments. To
  calculate <math|\<cal-B\>> downstream we use Eq.
  (<reference|eq:beamnumber>). A collimating aperture constrains the
  molecular beam to <math|\<sim\>0.03> sr, so we assume a uniform
  <math|n<rsub|S*r*F>> over this solid angle and the Doppler spread
  associated with this geometry. Nominally, we expect <math|\<cal-B\>> to
  remain constant as the beam propagates. However, we observe
  <math|\<cal-B\>*<around|(|L<rsub|p>=135<text|mm>|)>/\<cal-B\>*<around|(|L<rsub|p>=1<text|mm>|)>\<gtr\>1>
  for low <math|\<cal-F\>>. We attribute this increase in observed downstream
  brightness to rotational cooling during the the first <math|\<sim\>> 10 mm
  of beam propagation. For high <math|\<cal-F\>>,
  <math|\<cal-B\>*<around|(|L<rsub|p>=135<text|mm>|)>/\<cal-B\>*<around|(|L<rsub|p>=1<text|mm>|)>\<less\>1>,
  indicating a loss of molecules during beam propagation. Because this loss
  increases with larger <math|\<cal-F\>>, we believe that the cause is a
  higher helium gas load, which can lead to a larger background density of
  helium and hence collisional attenuation of the SrF beam.

  In our initial experiments, the ratio <math|\<cal-B\>*<around|(|L<rsub|p>=135<text|mm>|)>/\<cal-B\>*<around|(|L<rsub|p>=1<text|mm>|)>>
  was significantly worse at high flow rates. We found that placing a
  charcoal-covered plate (2.5 mm thick, with a 6.35 mm diameter hole) in the
  beam line substantially reduced this problem. We suspect that the plate
  provides strong pumping of He gas near the beam axis, creating a
  differentially-pumped region behind the plate through which the beam can
  travel through without undergoing collisions with background helium. This
  plate was tested in two separate positions, at <math|L<rsub|d>=21> mm and
  <math|L<rsub|d>=34> mm downstream from the cell aperture; both placements
  largely eliminated beam brightness decreases for <math|F\<lesssim\>20>
  sccm. Ultimately we find that <math|L<rsub|d>=34> mm results in the highest
  brightness at <math|L<rsub|p>=135> mm for <math|\<cal-F\>\<lesssim\>20>
  sccm. For <math|\<cal-F\>\<gtrsim\>20> sccm, we still observe a significant
  reduction in <math|\<cal-B\>>. We did not investigate this further because
  we plan to primarily operate the apparatus in the low flow
  (<math|\<cal-F\>\<lesssim\>20> sccm) regime where the forward speeds are
  the lowest. We speculate that the use of a true molecular beam skimmer
  might help alleviate this problem.

  <big-figure|<image|targetdurability.eps||2.6in||><label|fig:targetdurability>|Normalized
  <math|N<rsup|c*e*l*l><rsub|S*r*F>> (which is well-correlated with
  <math|N<rsup|b*e*a*m><rsub|S*r*F>>) as a function of ablation shot number.
  The same ablation spot was used for all 2000 shots to illustrate the
  durability of the target. <math|N<rsup|c*e*l*l><rsub|S*r*F>> decays to half
  its initial value in 500-1000 shots. In the main figure, each data point
  represents the average of 10 ablation shots. The inset shows
  <math|N<rsup|c*e*l*l><rsub|S*r*F>> for 30 consecutive shots to illustrate
  the shot-to-shot fluctuations in <math|N<rsup|c*e*l*l><rsub|S*r*F>>. The
  variation shown here (<math|\<less\>10%>) is typical for this system. For
  the data shown in the inset, the pulse tube refrigerator was turned off, to
  distinguish ablation variation from the 1.4 Hz pulse tube temperature
  variation. >

  <subsubsection|Ablation, Noise and Variation>

  We typically ablate the SrF<rsub|<math|2>> target at <math|R<rsub|YAG>=1>
  Hz rep. rate. We observe that operation at <math|R<rsub|YAG>\<gtr\>1> Hz
  sometimes decreases <math|N<rsub|S*r*F><rsup|c*e*l*l>> by a factor of 2 or
  more. Other times <math|N<rsub|S*r*F><rsup|c*e*l*l>> is nominally
  independent of <math|R<rsub|YAG>>, up to <math|R<rsub|YAG>\<sim\>> 15 Hz.
  This dependence on <math|R<rsub|YAG>> varies from target to target, and
  from spot to spot on the same target.

  For consecutive shots on the same spot on the target,
  <math|N<rsub|S*r*F><rsup|c*e*l*l>> typically varies by <math|\<sim\>5%>
  from shot to shot. Thus to produce consistent data, the ablation spot was
  changed only when necessary. Ablation yield from a single spot on the
  target was found to decrease after many shots. Typically
  <math|N<rsub|S*r*F><rsup|c*e*l*l>> decreased by a factor of 2 after
  500-1000 shots on the same spot (although this could vary by a factor of 2
  or more). The steady decrease in <math|N<rsub|S*r*F><rsup|c*e*l*l>> versus
  shot number, depicted in Fig. <reference|fig:targetdurability>, is typical.

  The in-cell ablation yields are observed to vary significantly (a factor of
  2 or more) for different nearby spots on the target. However, in the
  absence of significant visible damage to the window, an ablation spot can
  generally be found which will yield very nearly the maximum
  <math|N<rsub|S*r*F><rsup|c*e*l*l>> from that target. Finding such optimal
  spots typically requires sampling of a dozen or so different ablation
  spots.

  In an effort to improve yield, durability, or allow consistent operation at
  higher <math|R<rsub|YAG>>, we investigated different ablation targets: a
  SrF<rsub|<math|2>> single crystal, a commercial isostatically hot-pressed
  SrF<rsub|<math|2>> target, and eight cold-pressed targets made in-house
  with the same procedure but using different precursor materials. The
  in-house targets used pure powders of anhydrous SrF<rsub|<math|2>>,
  precipitated SrF<rsub|<math|2>>, 1 <math|\<mu\>>m SrF<rsub|<math|2>> and
  crushed macroscopic crystals of SrF<rsub|<math|2>>, as well as the same
  powders mixed with powdered boron metal in a 1/9 molar ratio. While the
  yield from all targets was the same to within a factor of <math|\<sim\>> 2,
  ultimately the anhydrous SrF<rsub|<math|2>> with powdered boron metal
  offered the greatest yield and allowed rep. rates up to 15 Hz, equal to the
  best rep. rates of the group. All targets lasted for the same number of
  shots to within a factor of <math|\<sim\>> 2.

  Ablation of SrF<rsub|<math|2>> produced macroscopic amounts of dust inside
  the cell. However, this dust did not create any known problems. After more
  than <math|10<rsup|6>> total ablation shots, both cell windows were visibly
  covered with dust (resulting in less than 10<math|%> transmission of a cw
  probe laser through each cell window), but
  <math|N<rsub|S*r*F><rsup|c*e*l*l>> was not significantly affected. Thus
  <math|10<rsup|6>> can be taken as a lower bound on the number of ablation
  shots possible before the apparatus must be opened and the target replaced.
  The ablation laser appears to remove any dust from the window in its path.

  In addition to variation due to ablation, the periodic temperature
  oscillation of the pulse tube refrigerator's second stage (1.4 Hz period,
  <math|T<rsub|m*i*n>=2.85> K, <math|T<rsub|m*a*x>=3.15> K) was observed to
  affect both <math|N<rsub|S*r*F><rsup|c*e*l*l>> and
  <math|N<rsub|S*r*F><rsup|b*e*a*m>>. This oscillation correlates with a
  <math|\<sim\>> <math|10%> peak to peak variation of
  <math|N<rsub|S*r*F><rsup|c*e*l*l>> and a <math|\<sim\>25%> peak to peak
  variation of <math|N<rsub|S*r*F><rsup|b*e*a*m>>. While temperature-induced
  variation in the rotational population may explain the variation of
  <math|N<rsub|S*r*F><rsup|c*e*l*l>>, it cannot account for the larger
  variation in <math|N<rsub|S*r*F><rsup|b*e*a*m>>. We speculate that the
  background He pressure outside the cell is changing at the 1.4 Hz frequency
  due to temperature-dependent pumping and/or outgassing rates from the
  charcoal cryosorb. We have seen that in a similar apparatus cooled with
  liquid helium rather than a pulse tube, both
  <math|N<rsub|S*r*F><rsup|c*e*l*l>> and <math|N<rsub|S*r*F><rsup|b*e*a*m>>
  vary by 5<math|%> or less shot to shot.

  <subsubsection|Source Comparison>

  For the production of bright, slow, and cold beams of free radicals and
  refractory molecular species, this source compares favorably in many
  respects to competing technologies. In particular, the brightness
  <math|\<cal-B\>=1.2\<times\>10<rsup|11>> <math|N<rsub|r*o*t>=0>
  molecules/sr/pulse, is approximately 100 times that produced by a source
  based on an ablation-seeded room temperature free jet expansion for YbF
  <cite|Tarbutt2002>. Furthermore, that free jet expansion beam has a mean
  forward velocity of 280<math|<frac|m|s>>, roughly twice that of the
  cryogenic buffer gas beam characterized in this paper. Another group
  created a beam of SrF by heating SrF<math|<rsub|2><space|-0.17em>> and
  boron metal to 1550 K <cite|Tu2009>. While the total brightness (over all
  states) of <math|2.1\<times\>10<rsup|15>> molecules/sr/s of that source is
  quite high, the brightness in the rovibrational ground state is
  <math|\<cal-B\>=5\<times\>10<rsup|11>> molecules/sr/s, comparable to the
  source presented here for <math|R<rsub|YAG>=4> Hz. However, the
  high-temperature source can only be operated for a short time before the
  oven must be refilled. Moreover, the forward (effusive) velocity is
  <math|v<rsub|S*r*F\<parallel\>><rsup|e>\<sim\>650*<frac|m|s>> at that
  temperature, undesirable for many experiments.

  While the measurements in this work were performed using only SrF, our beam
  source can be readily adapted by changing the target to create a wide
  variety of species. Within our group beams of BaF and ThO have been
  realized using similar techniques, with similar brightness and overall
  performance.

  <section|Conclusion>

  We have developed and characterized a robust cryogenic beam source for
  producing bright, slow beams of translationally and rotationally cold free
  radicals. We routinely produce a beam with a brightness of
  <math|1.2\<times\>10<rsup|11>> <math|N<rsub|r*o*t>=0> molecules/sr/pulse in
  the rovibrational ground state, with forward velocity of
  <math|140*<frac|m|s>>. Under these conditions the source can run for
  <math|\<gtrsim\>> 20 hours before the charcoal cryopumps must be
  regenerated. For the species SrF we estimate this source can allow
  <math|\<gtrsim\>10<rsup|6>> ablation shots, with repetition rates in the
  range 1-15 Hz, before the source must be opened to change the target. We
  believe this source may be useful for the wide variety of experiments that
  require molecular beams of free radical and/or refractory species.

  We acknowledge the contributions of N. Hutzler, E. Petrik, D. Patterson, J.
  Doyle, A. Vutha, P. Orth, M. Steinecker, C. Yale, and C. Bruzewicz. This
  material is based upon work supported by the ARO, the NSF and the AFOSR
  under the MURI award FA9550-09-1-0588.

  <\bibliography|bib|plain|ColdMoleculesRefs_current>
    <bib-list|[99]|>
  </bibliography>

  Spectroscopy of diatomic molecules is expected to be useful for tests of
  fundamental symmetries and measurements of time variation of fundamental
  constants. In these applications, the sensitivity of the measurements can
  be greatly enhanced through the larger interaction times enabled by slower
  velocities, so in these applications slow, bright, cold molecular beams are
  ideal as well.
</body>