<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <\hide-preamble>
    <assign|PRA|<macro|<with|font-shape|italic|Phys.<nbsp>Rev.<nbsp>A> >>

    <assign|PR|<macro|<with|font-shape|italic|Phys.<nbsp>Rev.> >>

    <assign|JPB|<macro|<with|font-shape|italic|J.<nbsp>Phys.<nbsp>B: At. Mol.
    Opt. Phys.> >>

    <assign|PRL|<macro|<with|font-shape|italic|Phys.<nbsp>Rev.<nbsp>Lett.> >>

    <assign|RMP|<macro|<with|font-shape|italic|Rev.<nbsp>Mod.<nbsp>Phys.> >>

    <assign|JCP|<macro|<with|font-shape|italic|J.<nbsp>Chem.<nbsp>Phys.> >>

    <assign|PSc|<macro|<with|font-shape|italic|Phys.<nbsp>Scr.> >>

    <assign|eg|<macro|<with|font-shape|italic|e.g., >>>

    <assign|ie|<macro|<with|font-shape|italic|i.e., >>>

    <assign|ec|<macro|1|(<reference|1>)>>

    <assign|myscaleboxa|<macro|1|<scalebox|0.33|[>0.33]<arg|1>>>

    <assign|myscaleboxb|<macro|1|<scalebox|0.42|[>0.46]<arg|1>>>
  </hide-preamble>

  <doc-data|<doc-title|Calibration of distorted wave Born approximation for
  electron impact excitation of Ne and Ar at incident energies below 100
  eV>|<doc-author|<author-data|<author-name|Yaqiu Liang<rsup|<math|1>>,
  Zhangjin Chen<rsup|<math|2>>, D. H. Madison<rsup|<math|3>> and C. D.
  Lin<rsup|<math|2>>>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    We calibrate the distorted wave Born approximation (DWBA) for electron
    impact excitation processes empirically. Differential cross sections
    (DCS) for the excitation of the <math|2*p<rsup|5>*3*s>,
    <math|2*p<rsup|5>*3*p>, <math|2*p<rsup|5>*4*s>, and
    <math|2*p<rsup|5>*4*p> configurations of Ne and the
    <math|3*p<rsup|5>*4*s> and <math|3*p<rsup|5>*4*p> configurations of Ar by
    electron impact are calculated using DWBA for incident energies between
    20 and 100 eV. The calculated results are compared with the absolute
    experimental measurements and other theoretical results. We found that
    the structure of the DCS can be well reproduced by the DWBA model while
    the magnitude is overestimated for most cases considered here. The
    differences in magnitude between DWBA and experiment are used to test the
    calibration of DWBA such that the DWBA can be used to describe
    laser-induced electron impact excitation processes. These processes are
    involved in the non-sequential double ionization of atoms in strong laser
    fields.
  </abstract>>

  <submitto|<JPB>>

  <section|Introduction>

  The process of electron impact excitation of atoms and ions is one of the
  most basic and important processes in atomic physics. Numerous theoretical
  methods have been used for the process calculations, including distorted
  wave Born approximation (DWBA)<nbsp><cite|Madison-jpb1987>, second-order
  distorted wave model<nbsp><cite|Madison-jpb1983>, <math|R>-matrix
  method<nbsp><cite|Bartschat-jpb1997>, and convergent close-coupling (CCC)
  calculations<nbsp><cite|Igor-pra-1992>, among which the DWBA is the
  simplest. The sophisticated theoretical models, such as CCC and
  <math|R>-matrix method, are capable of reproducing accurate angular
  differential cross sections (DCS), as well as the absolute magnitude. They
  are more suitable for low incident energies. For higher energies, both the
  integrated and differential cross sections predicted by DWBA are fairly
  accurate. However, it has been well recognized that, at low energies, the
  total cross sections (TCS) predicted by the DWBA signicantly exceed the
  experimental values. Ideally, one would use the <math|R>-matrix approach
  for low energies, the DWBA for high energies, but at intermediate energies,
  neither method is efficient if a large amount of data is needed.

  The purpose of this work is to correct (by renormalization) the DWBA
  predictions empirically such that the DCS calculated from DWBA can be used
  for low collision energies. We will use the empirical formula proposed by
  Tong <em|et al>.<nbsp><cite|Tong03pra> for the total excitation cross
  sections. Our ultimate objective is to apply the calibrated DWBA (C-DWBA)
  to simulate the correlated momentum distributions in nonsequential double
  ionization (NSDI) of atoms in strong laser fields.

  The process of NSDI of atoms in linearly polarized laser pulses is one of
  the most interesting and challenging topics in strong field physics. In
  NSDI, one electron that is first released near the maximum of the
  oscillating electric field may be driven back to revisit the parent ion
  when the electric field is near zero. When the returning electron collides
  with the parent ion with energies above the ionization threshold, it may
  kick out another bound electron, resulting in an (e,<nbsp>2e)-like process.
  The returning electron may also excite the bound electron to a higher
  excited state which is subsequently tunnel ionized when the electric field
  increases again. Since the year of 2000, complete experimental measurements
  on the full momentum vectors of the two outgoing electrons along the
  direction of polarization of the laser pulse have become
  available<nbsp><cite|Weber_Nature|Staudte_PRL07>, and a number of
  theoretical studies have also been carried out.

  Recently, Chen <em|et al>.<nbsp><cite|Chen_pra09> have developed a
  quantitative rescattering (QRS) theory which has been applied to various
  rescattering processes induced by short intense laser
  pulses<nbsp><cite|Lin-jpb-review|Chen-pra09R|Liang-pra10|Sam-NSDI|Chen-prl10|Chen-pra10>.
  The significant advantage of the QRS theory is that it treats the
  rescattering processes in the laser field as laser-<em|free> scattering
  processes, where the laser-induced returning electrons are described by a
  wavepacket. The QRS enables us to simulate two-dimensional correlated
  momentum distributions for NSDI <em|quantitatively> by calculating the
  triple differential cross sections (TDCS) for
  (e,<nbsp>2e)<nbsp><cite|Chen-prl10> and the DCS for electron impact
  excitation of ions<nbsp><cite|Chen-pra10>. However, to obtain the
  correlated momentum spectra that can be compared with experimental
  measurements, one needs to evaluate the TDCS for (e,<nbsp>2e) and the DCS
  for excitation for all possible momenta of the returning electrons. For
  NSDI of atoms in strong laser pulses, the highest energy,
  <math|E<rsub|i><rsup|<math-up|max>>>, of the returning (incident) electron
  is determined by the laser field, which is less than 100 eV for typical 800
  nm lasers. To simulate the correlated momentum distributions for NSDI, the
  DCS's for electron impact excitation of the parent ion at all incident
  energies from threshold to <math|E<rsub|i><rsup|<math-up|max>>> are needed.
  To reduce the computational effort a simple and efficient theoretical model
  is desirable. In this work, we develop the C-DWBA for this purpose.

  The organization of this paper is as follows: In section II, the basic
  theory of DWBA for electron impact excitation is presented and the method
  to calibrate DWBA is introduced. In section III, the DCS of DWBA for
  electron impact excitation of Ne and Ar at incident energies below 100 eV
  are normalized and compared with the absolute experimental data. The
  normalization factors are then used to test the calibration for DWBA.

  Atomic units are used in this paper unless otherwise specified.

  <section|Theory>

  In this section, we present the DWBA theory on electron impact excitation
  of atoms and the method to calibrate the DWBA at low energies. The formulas
  presented here are generic and therefore can be easily applied to the
  processes of electron impact excitation of ions which are involved in NSDI.

  <subsection|DWBA>

  Suppose we have an electron with momentum <math|<math-bf|k><rsub|i>> which
  collides with an atom <math|A>, after the collision, the scattered electron
  has momentum <math|<math-bf|k><rsub|f>>, and one bound electron in atom
  <math|A> is excited to a higher energy bound state. In the frozen core
  approximation, the \Pexact" Hamiltonian for the whole system is

  <eqnarray|<tformat|<table|<row|<cell|H=-<frac|1|2>*\<nabla\><rsub|1><rsup|2>+V<rsub|A<rsup|+>><around|(|r<rsub|1>|)>-<frac|1|2>*\<nabla\><rsub|2><rsup|2>+V<rsub|A<rsup|+>><around|(|r<rsub|2>|)>+<frac|1|r<rsub|12>>.<eq-number>>>>>>

  where <math|<math-bf|r><rsub|1>> and <math|<math-bf|r><rsub|2>> are the
  position vectors for the projectile and the bound state electron with
  respect to the nucleus, respectively. This Hamiltonian can be rewritten
  approximately as

  <eqnarray|<tformat|<table|<row|<cell|H<rsub|j>=-<frac|1|2>*\<nabla\><rsub|1><rsup|2>+U<rsub|j><around|(|r<rsub|1>|)>-<frac|1|2>*\<nabla\><rsub|2><rsup|2>+V<rsub|A<rsup|+>><around|(|r<rsub|2>|)>*<around|(|j=i,f|)>.<eq-number>>>>>>

  In this equation, <math|U<rsub|i>> (<math|U<rsub|f>>) is the distorting
  potential used to calculate the initial (final) state wave function
  <math|\<chi\><rsub|<math-bf|k><rsub|i>>>
  (<math|\<chi\><rsub|<math-bf|k><rsub|f>>>) for the projectile. In the
  distorted wave Born approximation, the direct transition amplitude for
  excitation from an initial state <math|\<Psi\><rsub|i>> to a final state
  <math|\<Psi\><rsub|f>> is expressed by

  <eqnarray|<tformat|<table|<row|<cell|f=<around|\<langle\>|\<chi\><rsup|-><rsub|<math-bf|k><rsub|f>><around|(|1|)>*\<Psi\><rsub|f><around|(|2|)><around|\||V<rsub|i>|\|>*\<Psi\><rsub|i><around|(|2|)>*\<chi\><rsup|+><rsub|<math-bf|k><rsub|i>><around|(|1|)>|\<rangle\>>,<eq-number><label|t-matrix>>>>>>

  where <math|V<rsub|i>> is the perturbation interaction,

  <eqnarray|<tformat|<table|<row|<cell|V<rsub|i>=H-H<rsub|i>=<frac|1|r<rsub|12>>+V<rsub|A<rsup|+>><around|(|r<rsub|1>|)>-U<rsub|i><around|(|r<rsub|1>|)>.<eq-number><label|pot>>>>>>

  In Eq.<nbsp>(<reference|t-matrix>), the initial and final state wave
  functions for the projectile satisfy the differential equation

  <eqnarray|<tformat|<table|<row|<cell|<around*|[|-<frac|1|2>*\<nabla\><rsub|1><rsup|2>+U<rsub|j><around|(|r<rsub|1>|)>-<frac|1|2>*k<rsup|2><rsub|j>|]>*\<chi\><rsub|<math-bf|k><rsub|j>><around|(|<math-bf|r><rsub|1>|)>=0*<around|(|j=i,f|)>,<eq-number><label|prjectile>>>>>>

  and the bound state wave functions are eigenfunctions of the equation

  <eqnarray|<tformat|<table|<row|<cell|<around*|[|-<frac|1|2>*\<nabla\><rsub|2><rsup|2>+V<rsub|A<rsup|+>><around|(|r<rsub|2>|)>-\<epsilon\><rsub|j>|]>*\<Psi\><rsub|j><around|(|<math-bf|r><rsub|2>|)>=0*<around|(|j=i,f|)>,<eq-number><label|initial2>>>>>>

  where <math|\<epsilon\><rsub|j>> (<math|j=i,f>) are the corresponding
  eigenenergies of the initial and final bound states which can be expressed
  as

  <\eqnarray>
    <\tformat>
      <\table>
        <\row>
          <\cell>
            \<Psi\><rsub|j><around|(|<with|font-series|bold|r>|)>=\<psi\><rsub|N<rsub|j>*L*j><around|(|r|)>*Y<rsub|L<rsub|j>*M<rsub|j>><around|(|<wide|<with|font-series|bold|r>|^>|)>

            <around|(|j=i,f|)>.
          </cell>

          <eq-number>
        </row>
      </table>
    </tformat>
  </eqnarray>

  The exchange scattering amplitude is given by

  <eqnarray|<tformat|<table|<row|<cell|g=<around|\<langle\>|\<Psi\><rsub|f><around|(|1|)>*\<chi\><rsup|-><rsub|<math-bf|k><rsub|f>><around|(|2|)><around|\||V<rsub|i>|\|>*\<Psi\><rsub|i><around|(|2|)>*\<chi\><rsup|+><rsub|<math-bf|k><rsub|i>><around|(|1|)>|\<rangle\>>.<eq-number><label|exchange-T-martrix>>>>>>

  Finally, the differential cross section for electron impact excitation is
  given by

  <eqnarray|<tformat|<table|<row|<cell|<label|dcs><frac|d*\<sigma\>|d*\<Omega\>>>|<cell|=>|<cell|N*<around|(|2*\<pi\>|)><rsup|4><frac|k<rsub|f>|k<rsub|i>>*<frac|1|2*L<rsub|i>+1>>>|<row|<cell|>|<cell|\<times\>>|<cell|<big|sum><rsup|+L<rsub|i>><rsub|M<rsub|i>=-L<rsub|i>><big|sum><rsup|+L<rsub|f>><rsub|M<rsub|f>=-L<rsub|f>><around*|(|<frac|3|4>*<around|\||f-g|\|><rsup|2>+<frac|1|4>*<around|\||f+g|\|><rsup|2>|)>.<eq-number>>>>>>

  The prefactor <math|N> in Eq.<nbsp>(<reference|dcs>) denotes the number of
  electrons in the subshell from which one electron is excited.

  The distorting potentials, <math|U<rsub|i>> and <math|U<rsub|f>>, used in
  Eq.<nbsp>(<reference|prjectile>) to calculate the wave functions for the
  projectile in the initial and final states, respectively, are not
  determined directly by the formalism. Here, we use static potentials which
  take the form as

  <eqnarray|<tformat|<table|<row|<\cell>
    U<rsub|j><around|(|r<rsub|1>|)>=V<rsub|A<rsup|+>><around|(|r<rsub|1>|)>+

    <big|int>

    d<math-bf|r><rsub|2><frac|<around|\||\<Psi\><rsub|j><around|(|<math-bf|r><rsub|2>|)>|\|><rsup|2>|r<rsub|12>>

    <around|(|j=i,f|)>

    .

    <eq-number><label|dist-pot>
  </cell>>>>>

  As shown previously, <math|V<rsub|A<rsup|+>><around|(|r|)>> in
  Eq.<nbsp>(<reference|dist-pot>) is the atomic potential used to evaluate
  eigenstate wave functions of the bound state electron. Here we use the
  effective potential from Tong and Lin<nbsp><cite|Tong> based on single
  active electron approximation, which is given by

  <eqnarray|<tformat|<table|<row|<cell|V<rsub|A<rsup|+>><around|(|r|)>=-<frac|1+a<rsub|1>*e<rsup|-a<rsub|2>*r>+a<rsub|3>*r*e<rsup|-a<rsub|4>*r>+a<rsub|5>*e<rsup|-a<rsub|6>*r>|r>,<eq-number>>>>>>

  where the parameters <math|a<rsub|i>>, as given explicitly in table 1 in
  Tong and Lin<nbsp><cite|Tong>, are obtained by fitting the calculated
  binding energies from this potential to the experimental ones of the ground
  state and the first few excited states of the target atom.

  <subsection|Calibration of DWBA>

  The overestimate of DWBA on DCS can be corrected by using the empirical
  method proposed by Tong <em|et al>.<nbsp><cite|Tong03pra> to evaluate the
  total cross sections for electron impact excitation:

  <eqnarray|<tformat|<table|<row|<cell|\<sigma\><rsub|<math-up|Tong>><around|(|E<rsub|i>|)>=\<alpha\><frac|\<pi\>|\<Delta\>*E<rsup|2>>*e<rsup|1.5*<around|(|\<Delta\>*E-\<epsilon\>|)>/E<rsub|i>>*f<around*|(|<frac|E<rsub|i>|\<Delta\>*E>|)>,<eq-number><label|xm1>>>>>>

  where

  <eqnarray|<tformat|<table|<row|<cell|f<around|(|x|)>=<frac|1|x>*<around*|[|\<beta\>*ln
  x-\<gamma\>*<around*|(|1-<frac|1|x>|)>+\<delta\><frac|ln
  x|x>|]>.<eq-number><label|xm2>>>>>>

  In Eq.<nbsp>(<reference|xm1>), <math|\<Delta\>*E> is the excitation energy
  for a given transition, <math|\<epsilon\>> is the eigenenergy of the
  corresponding excited state. The original formula given by Tong <em|et al>.
  does not have the prefactor <math|\<alpha\>> which is added in the present
  work to ensure that it reproduces the same cross sections as those from
  DWBA at high energies. The parameters in Eq.<nbsp>(<reference|xm2>) have
  been obtained initially by fitting to the convergent-close coupling
  excitation cross sections for hydrogen and He<rsup|<math|+>>. Explicitly,
  these parameters are <math|\<beta\>=0.7638>, <math|\<gamma\>=1.1759>, and
  <math|\<delta\>=0.6706>.

  The total cross section of DWBA at fixed incident energy
  <math|E<rsub|i>=k<rsub|i><rsup|2>/2> can be obtained from
  Eq.<nbsp>(<reference|dcs>) by

  <eqnarray|<tformat|<table|<row|<cell|\<sigma\><rsub|<math-up|DWBA>><around|(|E<rsub|i>|)>=<big|int><frac|d*\<sigma\>|d*\<Omega\>>*d*<wide|<with|font-series|bold|k>|^><rsub|f>.<eq-number><label|total-dwba>>>>>>

  By matching the total cross sections from Eq.<nbsp>(<reference|xm1>) with
  those from Eq.<nbsp>(<reference|total-dwba>) at high incident energies, say
  <math|E<rsub|i>=500> eV, one obtains the prefactor <math|\<alpha\>> in
  Eq.<nbsp>(<reference|xm1>) for excitation of each configuration. To
  calibrate the DWBA at low energies, we define a scaling factor

  <eqnarray|<tformat|<table|<row|<cell|\<cal-C\><around|(|E<rsub|i>|)>=\<sigma\><rsub|<math-up|Tong>><around|(|E<rsub|i>|)>/\<sigma\><rsub|<math-up|DWBA>><around|(|E<rsub|i>|)>.<eq-number><label|xm3>>>>>>

  It is the the scaling factor in Eq.<nbsp>(<reference|xm3>) that should be
  used to normalize the differential cross sections of DWBA at different
  incident energies.

  <section|Results and discussions>

  The perturbative nature of DWBA makes it overestimate electron impact
  excitation cross sections of ions at low energies. To calibrate the DWBA
  theory, one should compare its predictions to accurate theoretical results
  or absolute experimental measurements. Unfortunately, neither are easily
  available for atomic and molecular ions. Thus we use neutral Ne and Ar
  atoms for the calibration.

  <big-figure|<with|par-mode|center|<text|<rotatebox|270|<myscaleboxa|<image|Fig-1ab-3s-100eV-50eV.eps||||>>>>
  <text|<rotatebox|270|<myscaleboxa|<image|Fig-1cd-3s-30eV-25eV.eps||||>>>>
  >|DCS for the excitation of the <math|2*p<rsup|5>*3*s> configuration of Ne
  by electron impact at incident energies of (a) 100 eV, (b) 50 eV, (c) 30
  eV, and (d) 25 eV. The absolute experimental measurements are from Register
  <em|et al>.<nbsp><cite|Register> and Khakoo <em|et al>.<nbsp><cite|Khakoo>.
  For incident energies of 30 and 25 eV, the results of <math|R>-Matrix from
  Khakoo <em|et al>.<nbsp><cite|Khakoo> are also plotted for comparison.>

  <big-figure|<with|par-mode|center|<text|<rotatebox|270|<myscaleboxa|<image|Fig-2-3p-50eV-30eV.eps||||>>>>
  >|Same as Fig.<nbsp>1 but for configuration of <math|2*p<rsup|5>*3*p> at
  incident energies of (a) 50 eV and (b) 30 eV.>

  <big-figure|<with|par-mode|center|<text|<rotatebox|270|<myscaleboxa|<image|Fig-3-4s-50eV-30eV.eps||||>>>>
  >|Same as Fig.<nbsp>1 but for the <math|2*p<rsup|5>*4*s> configuration at
  incident energies of (a) 50 eV and (b) 30 eV.>

  <big-figure|<with|par-mode|center|<text|<rotatebox|270|<myscaleboxa|<image|Fig-4-4p-50eV-30eV.eps||||>>>>
  >|Same as Fig.<nbsp>1 but for the <math|2*p<rsup|5>*4*p> configuration at
  incident energies of (a) 50 eV and (b) 30 eV.>

  In Figures<nbsp>1-4, the DCS's for the excitation of the
  <math|2*p<rsup|5>*3*s>, <math|2*p<rsup|5>*3*p>, <math|2*p<rsup|5>*4*s> and
  <math|2*p<rsup|5>*4*p> configurations of Ne for incident energies below 100
  eV from DWBA are compared with the absolute experimental
  data<nbsp><cite|Register|Khakoo>. For the <math|2*p<rsup|5>*3*s>
  configuration, the DCS's from the <math|R>-matrix theory are also plotted
  for incident energies of 30 and 25 eV. It can be seen from Figs.<nbsp>1-4
  that the DWBA overestimates the DCS's for all the cases considered here. To
  get best overall agreement, different normalization factors are assigned to
  the DWBA for different configurations and different incident energies. For
  incident energies below 30 eV, the DCS's of DWBA could be 2-7 times higher
  than the experimental measurements. To see the distorting effect from the
  DWBA, the results of plane wave Born approximation (PWBA), in which plane
  waves are used to describe the projectile electron in both the initial and
  final states, are also displayed for comparison. For scattering angles
  greater than 30<rsup|<math|\<circ\>>>, one can see that the PWBA fails
  completely in predicting the angular distributions even for incident energy
  of 100 eV. In contrast, the enhanced DCS's for backward scattering observed
  in experiment are well reproduced by the DWBA.

  <big-figure|<with|par-mode|center|<text|<rotatebox|270|<myscaleboxa|<image|Fig-5ab-4s-100eV-50eV.eps||||>>>>
  <text|<rotatebox|270|<myscaleboxa|<image|Fig-5cd-4s-30eV-20eV.eps||||>>>>
  >|DCS for the excitation of the <math|3*p<rsup|5>*4*s> configuration of Ar
  by electron impact at incident energies of (a) 100 eV, (b) 50 eV, (c) 30 eV
  and (d) 20 eV. The absolute experimental measurements are from Chutjian and
  Cartwright<nbsp><cite|Chutjain>.>

  <big-figure|<with|par-mode|center|<text|<rotatebox|270|<myscaleboxa|<image|Fig-6ab-4p-100eV-50eV.eps||||>>>>
  <text|<rotatebox|270|<myscaleboxa|<image|Fig-6cd-4p-30eV-20eV.eps||||>>>>
  >|Same as Fig.<nbsp>5 but for the <math|3*p<rsup|5>*4*p> configuration at
  incident energies of (a) 100 eV, (b) 50 eV, (c) 30 eV, and (d) 20 eV.>

  In Figs.<nbsp>5 and 6, we show similar comparison for the excitation of
  <math|3*p<rsup|5>*4*s> and <math|3*p<rsup|5>*4*p> configurations of Ar. The
  experimental measurements were performed by Chutjian and
  Cartwright<nbsp><cite|Chutjain>. Compared to the excitation of Ne, the DCS
  of Ar have more structures. For example, for <math|3*p<rsup|5>*4*s> at 100
  eV and 50 eV, as shown in Figs.<nbsp>5(a,b), in addition to the rapid slope
  change around 25<rsup|<math|\<circ\>>>, extra minima were observed in
  experiment which are reproduced by the DWBA. For <math|3*p<rsup|5>*4*p> at
  100 eV and 50 eV, as shown in Figs.<nbsp>6(a,b), DWBA predicts triple
  minima in the DCS. They were observed in experiment as well despite that
  the backscattering is overestimated by the DWBA. This might indicate that
  the distorting potential used in the calculations needs to be improved. For
  lower incident energies of 30 eV and 20 eV, the agreement between DWBA and
  experiment for <math|3*p<rsup|5>*4*p> of Ar can not be regarded as
  satisfactory. However, the main feature can still be predicted by the DWBA.
  It should be noted that, for the excitation of <math|3*p<rsup|5>*4*p> of Ar
  at 20 eV (see Fig.<nbsp>6(d)), the yield from DWBA exceeds the experimental
  value by an even greater margin than the PWBA result. For this case, the
  DWBA predicts the DCS which is about 40 times higher than experiment.

  <big-figure|<with|par-mode|center|<text|<rotatebox|270|<myscaleboxb|<image|Fig-7-Ne-ratio-3s-3p-4s-4p.eps||||>>>>
  >|Total cross sections (left vertical axis) and normalization factors of
  DWBA (right vertical axis) for electron impact excitation of Ne from
  <math|2*p<rsup|6>> to (a) <math|2*p<rsup|5>*3*s>, (b)
  <math|2*p<rsup|5>*3*p>, (c) <math|2*p<rsup|5>*4*s>, and (d)
  <math|2*p<rsup|5>*4*p>. Solid curve, total cross sections of DWBA; Dotted
  curve, total cross sections calculated using the empirical formula of Tong
  <em|et al>.<nbsp><cite|Tong03pra>; Chain curve, scaling factor
  <math|\<cal-C\><around|(|E<rsub|i>|)>>; Solid circles, normalization
  factors used in Figs.<nbsp>1-4 for DWBA to obtain the best overall
  agreement with experiment.>

  <big-figure|<with|par-mode|center|<text|<rotatebox|270|<myscaleboxb|<image|Fig-8-Ar_ratio-4s-4p.eps||||>>>>
  >|Same as Fig.<nbsp>7 but for Ar from <math|3*p<rsup|6>> to (a)
  <math|3*p<rsup|5>*4*s> and (b) <math|3*p<rsup|5>*4*p>. The solid circles
  are the normalization factors used in Figs.<nbsp>5 and 6 for DWBA to obtain
  the best overall agreement with experiment.>

  The empirical formula, Eq.<nbsp>(<reference|xm1>), has already been used to
  calculate the total ionization yield of Ar in NSDI as a function of the
  peak intensity for a linearly polarized laser pulse by Micheau <em|et
  al>.<nbsp><cite|Sam-NSDI>.

  To obtain the scaling factor <math|\<cal-C\><around|(|E<rsub|i>|)>> for
  electron-Ne excitation, we calculate the TCS's using DWBA and those using
  Eq.<nbsp>(<reference|xm1>) for all the four configurations considered here
  at incident energies from threshold up to 500 eV. These TCS's for incident
  energies below 120 eV are plotted in Fig.<nbsp>7 referring to the left
  vertical axis. It can be seen that the difference in the magnitude of TCS
  between DWBA and Tong <em|et al> increases with decreasing incident energy.
  This difference is indicated by the the scaling factor
  <math|\<cal-C\><around|(|E<rsub|i>|)>> which is also plotted in
  Fig.<nbsp>7, referring to the right vertical axis. To see the accuracy of
  the scaling factor, the normalization factors used in Figs.<nbsp>1-4 for
  DWBA to obtain the best overall agreement with the experimental DCS's are
  displayed for comparison. One can see that all the normalization factors
  used in Figs.<nbsp>1-4 agree well with those predicted by the scaling
  factor <math|\<cal-C\><around|(|E<rsub|i>|)>>. In Fig.<nbsp>8, similar
  comparisons for Ar are shown. The good agreement of
  <math|\<cal-C\><around|(|E<rsub|i>|)>> with the normalization factors used
  in Figs.<nbsp>5 and 6 confirms again the validity of the calibration
  method.

  In conclusion, we proposed a method to calibrate the DCS from DWBA for
  electron impact excitation of atoms at low energies. The method will be
  applied to simulate the correlated electron momentum spectra for NSDI of
  atoms in a strong laser field, in which electron impact excitation of the
  ions is involved. This work paves the way for theoretical study, based on
  the QRS model, on NSDI of atoms in strong laser pulse.

  <section*|Acknowledgment>

  This work was supported in part by Chemical Sciences, Geosciences and
  Biosciences Division, Office of Basic Energy Sciences, Office of Science,
  US Department of Energy. Y Liang was supported with financial aids from
  China Scholarship Council, China Education Ministry under Grant No.
  2009-1590, and Education Department in Liaoning Province of China under
  Grant No. 2009A305. The work of D.H.M. was supported by the National
  Science Foundation under Grant No. PHY-0757749.

  <section*|References>

  <\thebibliography|xx>
    <bibitem|Madison-jpb1987>Bartschat K and Madison D H 1987
    <JPB><with|font-series|bold|20> 5839

    <bibitem|Madison-jpb1983>Madison D H and Winters K H 1983
    <JPB><with|font-series|bold|16> 4437

    <bibitem|Bartschat-jpb1997>Zeman V and Bartschat K 1997
    <JPB><with|font-series|bold|30> 4609

    <bibitem|Igor-pra-1992>Bray Igor and Stelbovics Andris T 1992
    <PRA><with|font-series|bold|46> 6995

    <bibitem|Tong03pra>Tong X M, Zhao Z. X and Lin C D 2003
    <PRA><with|font-series|bold|68> 043412

    <bibitem|Weber_Nature>Weber Th, Giessen H, Weckenbrock M, Urbasch G,
    Staudte A, Spielberger L, Jagutzki O, Mergel V, Vollmer M and Drner R
    2000 <em|Nature> (London) <with|font-series|bold|405> 658

    <bibitem|Staudte_PRL07>Staudte A, Ruiz C, Schffler M, Schssler S,
    Zeidler D, Weber Th, Meckel M, Villeneuve D M, Corkum P B, Becker A and
    Drner R 2007 <PRL><with|font-series|bold|99> 263002

    <bibitem|Chen_pra09>Chen Zhangjin, Le Anh-Thu, Morishita Toru and Lin C D
    2009 <PRA><with|font-series|bold|79> 033409

    <bibitem|Lin-jpb-review>Lin C D, Le Anh-Thu, Chen Zhangjin, Morishita
    Toru and Lucchese Robert 2009 <JPB><with|font-series|bold|43> 122001

    <bibitem|Chen-pra09R>Chen Zhangjin, Wittmann T, Horvath B and Lin C D
    2009 <PRA><with|font-series|bold|80> 061402(R)

    <bibitem|Liang-pra10>Yaqiu Liang 2010 <PRA><with|font-series|bold|82>
    055403

    <bibitem|Sam-NSDI>Micheau Samuel, Chen Zhangjin, Le Anh-Thu and Lin C D
    2009 <PRA><with|font-series|bold|79> 013417

    <bibitem|Chen-prl10>Chen Zhangjin, Liang Yaqiu and Lin C D 2010
    <PRL><with|font-series|bold|104> 253201

    <bibitem|Chen-pra10>Chen Zhangjin, Liang Yaqiu and Lin C D 2010
    <PRA><with|font-series|bold|82> 063417

    <bibitem|Tong>Tong X M and Lin C D 2005 <JPB><with|font-series|bold|38>
    2593

    <bibitem|Register>Register D F, Trajmar S, Steffensen G and Cartwright
    David C 1984 <PRA><with|font-series|bold|29> 1793

    <bibitem|Khakoo>Khakoo M A, Wrkich J, Larsen M, Kleiban G, Kanik I,
    Trajmar S, Brunger M J, Teubner P J O, Crowe A, Fontes C J, Clark R E H,
    Zeman V, Bartschat K, Madison D H, Srivastava R and Stauffer A D 2002
    <PRA><with|font-series|bold|65> 062711

    <bibitem|Chutjain>Chutjian A and Cartwright D C 1981
    <PRA><with|font-series|bold|23> 2178
  </thebibliography>
</body>