<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <doc-data|<doc-title|Pseudospin and spin-spin interactions in ultra-cold
  alkali atoms>|<doc-author|<author-data|<author-name|D. H. Santamore\<dag\>
  and Eddy Timmermans\<ddag\>>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    Ultra-cold alkali atoms trapped in two distinct hyperfine states in an
    external magnetic field can mimic magnetic systems of spin <math|1/2>
    particles. We describe the spin-dependent effective interaction as a
    spin-spin interaction. As a consequence of the zero-range, the
    interaction of spin <math|1/2> bosons can be described as an Ising or,
    alternatively, as an XY-coupling. We calculated the spin-spin interaction
    parameters as a function of the external magnetic field in the Degenerate
    Internal State (DIS) approximation. We illustrate the advantage of the
    spin-spin interaction form by mapping the system of N spin <math|1/2>
    bosons confined by a tight trapping potential on that of N spin
    <math|1/2> spins coupled via an infinite range interaction.
  </abstract>>

  <section|Introduction>

  The ability to mimic quantum spins and the promise for controlling their
  mutual interactions are central ingredients of the cold atom prospects for
  simulating complex quantum systems: Quantum computation schemes rely on the
  entanglement of qubits <cite|Chuang>, which act as spin <math|<frac|1|2>>
  objects. Lattice spin models have provided successful descriptions of
  strongly correlated electron systems <cite|Sachdevpaper>, usually with the
  parameters situated near a quantum phase transition so that the systems
  exhibits quantum critical behavior. A general description of quantum phase
  transitions has not been devised yet <cite|Sachdevbook> and while scaling
  arguments have been applied <cite|quantumscaling>, a general
  renormalization scheme remains an outstanding challenge. The experimental
  inaccessibility of the condensed strongly correlated electron systems
  certainly contributes to the challenge of understanding quantum phase
  transition physics. Cold atom experiments, which offer a very different
  accessibility and a very different set of control knobs may offer a
  different and independent laboratory to test concepts. Spin
  <math|<frac|1|2>> degrees of freedom are also essential building blocks of
  quantum fluids in regimes that are novel for table-top experiments such as
  Cooper-paired fermion fluids in the BEC-BCS crossover regime
  <cite|MCSLSSK99|PSKJH05|PWLH07>, and polarized fermion superfluids (for
  example, see theory: <cite|AGIM02|EV02|XGLW03|A06|KMJT06|PW07|MOYDOM08|KSSS09|BDNJ09>
  and experiments: <cite|SSSK08|SSSK208|PWLHHS06|LPLH09|BARJCDG04|WRAKSDG07>.)
  In addition, bosons trapped in two hyperfine states can act as spin
  <math|<frac|1|2>> particles <cite|Legg>. In Bose-Einstein condensates
  (BEC's) of such particles, the formation of spin <math|<frac|1|2>> magnetic
  domains has been observed <cite|Ketterle1>, which is a phase separation
  transition <cite|Eddy>.

  The observation of spin domain formation <cite|Ketterle1>, of intricate
  multi-component spin physics in BECs <cite|Wiemel1>, of unstable spin
  dynamics in spin <math|1> BECs <cite|Stamper> and the engineering of
  two-component BEC vortex states <cite|Wiemel2> and <cite|Wiemel22>
  highlight the cold atom ability to access, populate and control hyperfine
  spin states in cold atom traps. Other experiments demonstrated the cold
  atom ability to select specific hyperfine spin states in a static, external
  magnetic field as effective spin components: The above mentioned
  observation of BEC-phase separation, the probing of the BCS-BEC crossover
  regime, the spin polarized fermion superfluids, and the recently observed
  phase transition in an itinerant ferromagnet-like system were all carried
  out with effective spin <math|<frac|1|2>> particles that occupy a linear
  combination of hyperfine spin eigenstates in the presence of a static
  external magnetic field. For reasons we describe below, we refer to the
  effective spin as `pseudospin'.

  In this paper, we derive the short-range, effective pseudospin-spin
  interaction potential that describes <math|s>-wave interactions of
  ultra-cold atoms that occupy a superposition of two hyperfine states in an
  external magnetic field. The resulting spin-spin interaction has an
  anisotropic form, but the commutation or anticommutation relations that
  respectively characterize bosonic and fermionic systems, combined with the
  short-range (delta-function) nature of the interaction project the
  interactions onto the pseudospin triplet subspace for bosons and on the
  pseudospin singlet subspace for fermions. For bosonic atoms, we find that
  the inter-particle interactions can be described by three terms: the first
  term is a short-range spin independent interaction potential; the second
  term describes the coupling of one particle's pseudospin to a short-range,
  spin-independent effective magnetic field carried by the other particle;
  and the third term is a short-range Ising spin-spin coupling.
  Alternatively, the spin-spin interaction can be cast into the form of an
  <math|X*Y>-coupling. We show how these terms can be calculated in the
  Degenerate Internal State (DIS) approximation <cite|Boud1>. We illustrate
  the advantage of the spin-spin interaction description by deriving the
  many-spin hamiltonian of N boson particles contained in a tightly confining
  trap. This system, a controllable quantum magnet, is a promising system to
  probe macroscopic quantum tunneling, realize spin squeezing and
  Heisenberg-limited interferometry <cite|Dowl>.

  <section|Cold atom spins>

  The first question to be addressed in simulating one system by another is:
  what are the salient features of the simulated system that the simulating
  system needs to possess? As we see below, a spin operator has three
  components that satisfy a particular commutator algebra. Any operator that
  satisfies this algebra is a candidate to acts as a spin. We construct the
  available alkali atom spin states in an external magnetic field explicitly.
  By selecting two of these states the experimentalists create a cold atom
  system of effective spin <math|<frac|1|2>> particles.

  <subsection|General spin properties: spin and rotation>

  We denote the quantum state of a spin <math|<wide|\<xi\>|\<wide-varrightarrow\>>>
  by the spinor <math|<around*|\||\<xi\>|\<rangle\>>>. A spin of amplitude
  <math|\<xi\>>, where <math|\<xi\>> is an integer or half-integer number,
  has <math|2*\<xi\>+1> eigenstates <math|<around*|\||\<xi\><rsub|j>|\<nobracket\>>\<rangle\>>
  of the spin projection operator <math|<around*|\<nobracket\>|<around*|\<nobracket\>|<wide|\<xi\>|^><rsub|z><around*|\||\<xi\><rsub|j>|\<rangle\>>|\<nobracket\>>=j<around*|\||\<xi\><rsub|j>|\<rangle\>>|\<nobracket\>>>
  with <math|j=-\<xi\>,-\<xi\>+1,...,\<xi\>-1,\<xi\>>. The spin operator is
  the generator of rotations so that under a rotation
  <math|\<cal-R\><rsub|<wide|\<epsilon\>|\<vect\>>,\<alpha\>>> by an angle
  <math|\<alpha\>> around the direction of unit vector
  <math|<wide|\<epsilon\>|\<vect\>>>, the spin state
  <math|<around*|\||\<xi\>|\<rangle\>>> (which is a superposition of the
  states <math|<around*|\<nobracket\>|<around*|\||\<xi\><rsub|j>|\<rangle\>>|\<nobracket\>>>)
  transforms according to

  <\equation>
    <around*|\||\<cal-R\><rsub|<wide|\<epsilon\>|\<vect\>>,\<alpha\>><around*|(|\<xi\>|)>|\<rangle\>>=exp
    <around*|(|i*\<alpha\>*<wide|\<epsilon\>|\<vect\>>\<cdot\><wide|\<xi\>|\<wide-varrightarrow\>>|)><around*|\||\<xi\>|\<rangle\>>.<label|rot>
  </equation>

  For an infinitesimal rotation, <math|\<alpha\>=\<delta\>*\<alpha\>\<ll\>1>,
  to lowest order in <math|\<delta\>*\<alpha\>>,

  <\equation>
    <around*|\||\<cal-R\><rsub|<wide|\<epsilon\>|\<vect\>>,\<delta\>*\<alpha\>><around*|(|\<xi\>|)>|\<rangle\>>\<approx\><around*|[|1+i*\<delta\>*\<alpha\>*<wide|\<epsilon\>|\<vect\>>\<cdot\><wide|\<xi\>|\<wide-varrightarrow\>>|]><around*|\||\<xi\>|\<rangle\>>.<label|infrot>
  </equation>

  Quantum mechanically, an operator <math|\<cal-O\>> in the Hilbert space of
  a single spin is characterized by its matrix elements
  <math|<around*|\<langle\>|\<xi\><rsub|i><around|\||\<cal-O\>|\|>*\<xi\><rsub|j>|\<rangle\>>>
  where <math|<around*|\||\<xi\><rsub|i>|\<rangle\>>> is the <math|i>-th
  element of the <math|<around*|{|\<xi\><rsub|\<xi\>>,\<xi\><rsub|\<xi\>-1>,...|}>>,
  basis. We relate the basis matrix elements in the original and in the
  rotated spinor basis <math|<around|\||\<xi\><rsub|i><rprime|'>|\<rangle\>>>.
  When the rotated frame is obtained by rotating around
  <math|<wide|\<epsilon\>|\<vect\>>> over an angle
  <math|-\<delta\>*\<alpha\>>,

  <\equation>
    <around|\<langle\>|\<xi\><rsub|i><rprime|'><around|\||\<cal-O\>|\|>*\<xi\><rsub|j><rprime|'>|\<rangle\>>\<approx\><around|\<langle\>|\<xi\><rsub|i><around|\||<around*|(|\<cal-O\>-i*<space|0.27em>\<delta\>*\<alpha\>*<space|0.27em><around*|[|\<cal-O\>,<wide|\<epsilon\>|\<wide-varrightarrow\>>\<cdot\><wide|\<xi\>|\<wide-varrightarrow\>>|]><rsub|->|)>|\|>*\<xi\><rsub|j>|\<rangle\>><space|0.27em>,
  </equation>

  where the subscript (<math|->) outside the bracket indicates the usual
  commutator. As a consequence, the operator <math|\<cal-O\>> transforms as

  <\equation>
    \<cal-O\><rprime|'>=\<cal-O\>-i*<space|0.27em>\<delta\>*\<alpha\>*<space|0.27em><around*|[|\<cal-O\>,<wide|\<epsilon\>|\<wide-varrightarrow\>>\<cdot\><wide|\<xi\>|\<wide-varrightarrow\>>|]><rsub|->.<label|rotop>
  </equation>

  Moreover, if the <math|\<cal-O\>>\Uoperator is rotationally invariant,
  <math|\<cal-O\><rprime|'>=\<cal-O\>>, then
  <math|<around*|[|\<cal-O\>,<wide|\<epsilon\>|\<wide-varrightarrow\>>\<cdot\><wide|\<xi\>|\<wide-varrightarrow\>>|]><rsub|->=0>
  is the necessary and sufficient condition to ensure that the
  <math|\<cal-O\>>\Uoperator is invariant under a rotation around the
  <math|<wide|\<epsilon\>|\<wide-varrightarrow\>>>-vector.

  Classically an infinitesimal rotation transforms a general vector
  <math|<wide|v|\<wide-varrightarrow\>>> to
  <math|\<cal-R\><rsub|<wide|\<epsilon\>|\<wide-varrightarrow\>>,\<delta\>*\<alpha\>><around*|(|<wide|v|\<wide-varrightarrow\>>|)>=<wide|v|\<wide-varrightarrow\>>+<space|0.27em>\<delta\>*\<alpha\>*<space|0.27em><wide|\<epsilon\>|\<wide-varrightarrow\>>\<times\><wide|v|\<wide-varrightarrow\>>>.
  If spin is to act as a vector under a rotation, it is to transform as

  <\equation>
    \<cal-R\><rsub|<wide|\<epsilon\>|\<wide-varrightarrow\>>,\<delta\>*\<alpha\>><around*|(|<wide|\<xi\>|\<wide-varrightarrow\>>|)>=<wide|\<xi\>|\<wide-varrightarrow\>>+<space|0.27em>\<delta\>*\<alpha\>*<space|0.27em><wide|\<epsilon\>|\<wide-varrightarrow\>>\<times\><wide|\<xi\>|\<wide-varrightarrow\>>.<label|rotvec>
  </equation>

  Choosing <math|\<cal-O\>=<wide|\<xi\>|\<wide-varrightarrow\>>>, by
  combining Eqs. (<reference|rotop>) and (<reference|rotvec>), and
  identifying the terms linear in <math|\<delta\>*\<alpha\>> we obtain

  <\equation>
    i*<space|0.27em><wide|\<epsilon\>|\<wide-varrightarrow\>><space|0.27em>\<times\><space|0.27em><wide|\<xi\>|\<wide-varrightarrow\>>=<around*|[|<wide|\<xi\>|\<wide-varrightarrow\>>,<wide|\<epsilon\>|\<wide-varrightarrow\>>\<cdot\><wide|\<xi\>|\<wide-varrightarrow\>>|]><rsub|->.
  </equation>

  The scalar product of the above vector equality with a unit vector
  <math|<wide|\<eta\>|\<wide-varrightarrow\>>> gives

  <\equation>
    <around*|[|<wide|\<xi\>|\<wide-varrightarrow\>>\<cdot\><wide|\<eta\>|\<wide-varrightarrow\>>,<wide|\<xi\>|\<wide-varrightarrow\>>\<cdot\><wide|\<epsilon\>|\<wide-varrightarrow\>>|]><rsub|->=i*<space|0.27em><wide|\<xi\>|\<wide-varrightarrow\>>\<cdot\><around*|(|<wide|\<eta\>|\<wide-varrightarrow\>>\<times\><wide|\<epsilon\>|\<wide-varrightarrow\>>|)>,
  </equation>

  and choosing the <math|<wide|\<eta\>|\<vect\>>> and
  <math|<wide|\<epsilon\>|\<vect\>>> vectors as part of a Cartesian
  <math|<around|(|x,y,z|)>> reference frame,
  <math|<wide|\<eta\>|\<vect\>>=<wide|x|\<vect\>>> and
  <math|<wide|\<epsilon\>|\<vect\>>=<wide|y|\<vect\>>>, we obtain

  <\equation>
    <around*|[|<wide|\<xi\>|^><rsub|x>,<wide|\<xi\>|^><rsub|y>|]><rsub|->=i*<space|0.27em><wide|\<xi\>|^><rsub|z>,<label|alg>
  </equation>

  the usual form of the angular momentum commutator relation. From this
  commutator, it can be shown that <math|<wide|\<xi\>|^><rsub|x>\<pm\><wide|\<xi\>|^><rsub|y>>
  are raising and lowering operators, increasing and decreasing the spin
  projection eigenvalue of <math|<wide|\<xi\>|^><rsub|z>> by one unit. As
  operators evolve according to the Heisenberg commutator equations in the
  quantum evolution of the system, any operator satisfying the above
  commutator relations will evolve as a spin (or angular momentum) of the
  same Hamiltonian.

  The pseudospins we describe below are <with|font-shape|italic|not> the
  generators of rotation and their mutual interactions are
  <with|font-shape|italic|not> rotationally invariant. However, the
  pseudospins can be described by pseudospin operators that
  <with|font-shape|italic|do> satisfy an angular momentum algebra. In the
  Heisenberg picture, the quantum equations of motion shows that the dynamics
  is identical to that of real spins except that the spins and their mutual
  interactions are <with|font-shape|italic|not> rotationally invariant.

  <subsection|The spin structure of alkali atoms in a magnetic
  field><label|Sec>

  Alkali atoms have two spin variables: the electron spin
  <math|<math-bf|s><rsub|e>> of magnitude <math|s<rsub|e>=<frac|1|2>> carried
  by the <math|s>-wave valence electron and the nuclear spin
  <math|<math-bf|i>> of magnitude <math|i>. The electron 'spins' in the
  magnetic field of the nucleus and the short-range part of the nuclear
  spin's magnetic field (the Fermi contact term) contributes to the energy in
  a first-order perturbation calculation <cite|Foote>. The corresponding
  contribution takes the form <math|a<rsub|h*f><math-bf|i>\<cdot\><math-bf|s><rsub|e>>,
  which is the hyperfine interaction. We refer to <math|a<rsub|h*f>> as the
  hyperfine energy.

  In a static, external, homogeneous magnetic field <math|<math-bf|B>> of
  strength <math|B>, <math|<math-bf|B>=B<math-bf|z>>, the interaction of the
  electronic and nuclear spins with the magnetic field and with each other
  are described by the Zeeman spin Hamiltonian

  <\equation>
    \<cal-H\>=B<math-bf|z>\<cdot\><around*|[|\<mu\><rsub|e><math-bf|s><rsub|e>-\<mu\><rsub|N><math-bf|i>|]>+a<rsub|h*f><math-bf|s><rsub|e>\<cdot\><math-bf|i>,<label|Zeeman1>
  </equation>

  where <math|\<mu\><rsub|e>=\<hbar\>/2*m<rsub|e>*c>,
  <math|\<mu\><rsub|N>=\<hbar\>/2*m<rsub|p>*c> represent the electronic and
  nuclear Bohr magneton, respectively, with <math|m<rsub|e>> for the electron
  mass and <math|m<rsub|p>> for the proton mass. As the nucleons are heavier
  and the nuclear Bohr magneton, <math|\<mu\><rsub|N>>, proportionally
  smaller (by three orders of magnitude) than <math|\<mu\><rsub|e>>,
  <math|\<mu\><rsub|N>> and we neglect it for now. Scaling the magnetic field
  strength in units of the hyperfine field
  <math|B<rsub|h*f>=a<rsub|h*f>/\<mu\><rsub|e>>, <math|b=B/B<rsub|h*f>>, the
  Zeeman Hamiltonian takes the form

  <\equation>
    <frac|\<cal-H\>|a<rsub|h*f>>=<math-bf|s><rsub|e>\<cdot\><math-bf|i>+b<space|0.27em><math-bf|z>\<cdot\><math-bf|s><rsub|e>.<label|zeeman>
  </equation>

  At zero magnetic field, <math|b=0>, the structure of the spin Hamiltonian
  eigenstates is most readily analyzed by introducing the total hyperfine
  spin operator, <math|<math-bf|f>=<math-bf|i>+<math-bf|s><rsub|e>>. The
  Hamiltonian eigenstates can be chosen to be eigenstates of good
  <math|<around*|(|<math-bf|f><rsup|2>|)>> and
  <math|<math-bf|f>\<cdot\><math-bf|z>> quantum numbers. The eigenvalues of
  the <math|<math-bf|f><rsup|2>> operator are <math|f*<around*|(|f+1|)>>,
  with <math|f=i\<pm\>1/2>. The eigenvalues of the
  <math|<math-bf|f>\<cdot\><math-bf|z>> are labeled by the eigenvalue
  <math|m<rsub|f>>. The <math|<around|\||f,m<rsub|f>|\<rangle\>>> states of
  the same <math|f>-quantum number are degenerate. The first term of Eq.
  (<reference|zeeman>) can be written as <math|<around*|(|<math-bf|f><rsup|2>-<math-bf|s><rsub|e><rsup|2>-<math-bf|i><rsup|2>|)>/2>,
  and when <math|b=0>, <math|E<around|(|f,m<rsub|f>,b|)>=E<rsub|0><around|(|f|)>>
  and <math|E<rsub|0>*<around|(|f=i+1/2|)>=a<rsub|h*f>*i/2> and
  <math|E<rsub|0>*<around|(|f=i-1/2|)>=-a<rsub|h*f>*<around|(|i+1|)>/2>,
  giving a hyperfine splitting <math|a<rsub|h*f>*<around|(|i+<frac|1|2>|)>>.
  This splitting is determined spectroscopically. For example,
  <math|<rsup|23>N*a> has a hyperfine energy measured to be
  <math|a<rsub|h*f>=42.5*m*K=0.95*G*H*z> (which greatly exceeds cold atom
  trap depths <math|\<sim\>\<mu\>*K>), corresponding to a hyperfine magnetic
  field strength equal to <math|B<rsub|h*f>\<approx\>709*G>.

  At finite magnetic field, <math|f> is not a good quantum number, but it is
  convenient and customary to refer to the <math|f>-value that the same state
  takes on in the adiabatic <math|b\<rightarrow\>0>-limit. On the other hand,
  the total spin projection, <math|m<rsub|f>> remains a good quantum number.
  We parametrize the corresponding state by an angle <math|\<theta\>> as

  <eqnarray|<tformat|<table|<row|<cell|<around*|\||f<rsup|\<pm\>>,m<rsub|f>|\<rangle\>>>|<cell|=>|<cell|\<pm\>cos
  <around*|(|<frac|\<theta\><rsup|\<pm\>>|2>|)>*<around*|\||m<rsub|i>=m<rsub|f>-<frac|1|2>,m<rsub|e>=+<frac|1|2>|\<rangle\>>>>|<row|<cell|>|<cell|>|<cell|+sin
  <around*|(|<frac|\<theta\><rsup|\<pm\>>|2>|)>*<around*|\||m<rsub|i>=m<rsub|f>+<frac|1|2>,m<rsub|e>=-<frac|1|2>|\<rangle\>>.<eq-number><label|parame>>>>>>

  We restrict the range of <math|\<theta\>>-angles to the
  <math|<around*|[|0,\<pi\>|]>> interval, allowing for coefficients of a
  different sign by adding <math|\<pm\>> explicitly to the cosine term. By
  parametrizing the state as in Eq. (<reference|parame>), the
  <math|\<theta\>> is also the inclination angle of the average electron spin
  vector in that hyperfine state. The optimal value of <math|\<theta\>>
  depends on the spin projection eigenvalue <math|m<rsub|f>>.

  Using the angular momentum algebra Eq. (<reference|alg>), the spin product
  expectation value <math|<around|\<langle\>|<math-bf|s><rsub|e>\<cdot\><math-bf|i>|\<rangle\>>>,
  of the states of Eq. (<reference|parame>) give

  <\equation>
    <around*|\<langle\>|<math-bf|s><rsub|e>\<cdot\><math-bf|i>|\<rangle\>>=<frac|1|2>*<around*|[|cos
    <around*|(|\<theta\>|)>*m<rsub|f>\<pm\>sin
    <around*|(|\<theta\>|)><sqrt|<around*|(|i+<frac|1|2>|)><rsup|2>-m<rsub|f><rsup|2>>|]>-<frac|1|4>,
  </equation>

  where, <math|\<pm\>> refer to the relative sign of the electron spin up and
  down components, as introduced in (<reference|parame>). Taking the extreme
  of the expectation value of Eq. (<reference|zeeman>) with respect to
  <math|\<theta\>> in (<reference|parame>) gives

  <\equation>
    <frac|E(\<pm\>,m<rsub|f>)|a<rsub|h*f>>=<around*|(|b+m<rsub|f>|)>*cos
    <around*|(|\<theta\>|)>\<pm\>sin <around*|(|\<theta\>|)><sqrt|<around*|(|i+<frac|1|2>|)><rsup|2>-m<rsub|f><rsup|2>>-<frac|1|4>,
  </equation>

  and by requiring <math|\<partial\>*E/\<partial\>*\<theta\>=0>, we obtain
  the optimal inclination angle <math|tan
  <around*|(|\<theta\><rsup|\<pm\>>|)>>,

  <\equation>
    tan <around*|(|\<theta\><rsup|\<pm\>>|)>=\<pm\><frac|<sqrt|<around*|(|i+<frac|1|2>|)><rsup|2>-m<rsub|f><rsup|2>>|<around*|(|b+m<rsub|f>|)>>.
  </equation>

  As <math|b\<gg\>1>, <math|tan <around*|(|\<theta\><rsup|\<pm\>>|)>\<rightarrow\>\<pm\><lbrack>i+1]/b\<rightarrow\>\<pm\>\<infty\>>,
  corresponding to <math|\<theta\><rsup|+>\<rightarrow\>0> and
  <math|\<theta\><rsup|->\<rightarrow\>\<pi\>>: the electron spin in
  hyperfine states align or anti-align with the external magnetic field when
  the strength of that field significantly exceeds the hyperfine field
  strength. For notational convenience we introduce the square root of the
  sum of the squares of the numerator and denominator,

  <\equation>
    e<around*|(|m<rsub|f>,b|)>=<sqrt|b<rsup|2>+2*m<rsub|f>*b+<around*|(|i+<frac|1|2>|)><rsup|2>>.
  </equation>

  Then the angular projections can be written as

  <\equation>
    cos <around*|(|\<theta\><rsup|\<pm\>>|)>=\<pm\><frac|<around*|(|b+m<rsub|f>|)>|e<around*|(|m<rsub|f>,b|)>>,<no-number><next-line><space|0.27em><space|0.27em><space|0.27em><space|0.27em><space|0.27em><space|0.27em>sin
    <around*|(|\<theta\><rsup|\<pm\>>|)>=<frac|<sqrt|<around*|(|i+1/2|)><rsup|2>-<around*|(|m<rsub|f>|)><rsup|2>>|e<around*|(|m<rsub|f>,b|)>>.<label|cossin>
  </equation>

  Substitution of Eq. (<reference|cossin>) into Eq. (<reference|zeeman>)
  yields the Zeeman eigenenergies <math|E*<around*|(|\<pm\>,m<rsub|f>,b|)>> ,

  <\equation>
    <frac|E*<around*|(|\<pm\>,m<rsub|f>,b|)>|a<rsub|h*f>>=\<pm\><frac|e<around*|(|m<rsub|f>,b|)>|2>-1/4,<label|Zeeman2>
  </equation>

  where the superscripts <math|\<pm\>> are now seen to indicate whether the
  hyperfine state belongs to the <math|f<rsup|+>=i+1/2> or the
  <math|f<rsup|->=i-1/2>\Usuperpositions of Eq. (<reference|parame>). To see
  that, note that in the limit of vanishing magnetic field,
  <math|lim<rsub|b\<rightarrow\>0>>, <math|e<around|(|m<rsub|f>,b|)>\<rightarrow\>i+1/2>,
  so that <math|E(+,m<rsub|f>,b>) approaches
  <math|E<rsub|0>*<around*|(|f=i+1/2|)>=a<rsub|h*f>*i/2> while
  <math|E(-,m<rsub|f>,b>) approaches <math|E<rsub|0>*<around*|(|f=i-1/2|)>=-a<rsub|h*f>*<around*|[|i+1|]>/2>.
  Actually, the expression Eq. (<reference|Zeeman2> ) describes the
  `non-stretched' states, <math|<around*|\||m<rsub|f>|\|>\<less\>i+1/2>. For
  the stretched states <math|<around*|\||f=i+1/2,m<rsub|f>=i+1/2|\<rangle\>>>
  and <math|<around*|\||f=i+1/2,m<rsub|f>=-i-1/2|\<rangle\>>>,

  <\equation>
    <frac|E*<around*|(|f<rsup|+>,m<rsub|f>=\<pm\>f<rsup|+>,b|)>|a<rsub|h*f>>=\<pm\><frac|b|2>+<frac|i|2>,
  </equation>

  corresponding to <math|\<theta\>=0> and <math|\<theta\>=\<pi\>> in the
  linear superpositions of Eq. (<reference|parame>).

  <\big-figure>
    <image|Fig1hyperfine_i3half.eps|3in|||>

    <label|Fig1boson>
  </big-figure|Hyperfine energy levels for nuclear spin <math|i=3/2>, the
  nuclear spin magnitude of bosonic atoms such as <math|<rsup|7>L*i>,
  <math|<rsup|23>N*a> and <math|<rsup|87>R*b>.>

  In Fig. <reference|Fig1boson>, we show the magnetic field dependence of the
  spin states for the nuclear spin value <math|i=<frac|3|2>> that describes
  <math|<rsup|7>L*i>, <math|<rsup|23>N*a> and <math|<rsup|87>R*b>, three of
  the most used cold atom alkali atom species.

  The electron spin expectation value <math|<around|\<langle\>|<math-bf|s><rsub|e>|\<rangle\>>>,

  <\equation>
    <around*|\<langle\>|f,m<rsub|f><around*|\||<math-bf|s><rsub|e>|\|>*f,m<rsub|f>|\<rangle\>>=<math-bf|z><frac|cos
    <around*|(|\<theta\>|)>|2>=\<pm\><math-bf|z><frac|<around*|(|b+m<rsub|f>|)>|2*e<around*|(|m<rsub|f>,b|)>>,<label|inclin>
  </equation>

  points in the direction of the external magnetic field.

  <subsection|Pseudospin><label|Sec>

  By trapping cold atoms in a specific hyperfine state in an external
  magnetic field and by coherently transferring part of the spin population
  into a different hyperfine state, either by accessing a laser-driven
  two-photon Raman transition or by means of another magnetic field that is
  oscillating near the energy-difference, the experimentalists prepare the
  atoms in a superposition of two hyperfine states,
  <math|<around*|\||f<rsub|1>,m<rsub|f<rsub|1>>|\<rangle\>>> and
  <math|<around*|\||f<rsub|2>,m<rsub|f<rsub|2>>|\<rangle\>>>. If the
  hyperfine states have been selected to ensure that no other spin states
  couple, <math|<around*|\||f<rsub|1>,m<rsub|f<rsub|1>>|\<rangle\>>> and
  <math|<around*|\||f<rsub|2>,m<rsub|f<rsub|2>>|\<rangle\>>> act as the basis
  of an effective spin <math|<frac|1|2>>. We can than assign one the role of
  `spin-up' the other that of `spin-down' state,
  <math|<around*|\<nobracket\>|<around*|\||f<rsub|1>,m<rsub|f<rsub|1>>|\<rangle\>>=<around*|\||\<uparrow\>|\<rangle\>>|\<nobracket\>>>
  and <math|<around*|\<nobracket\>|<around*|\||f<rsub|2>,m<rsub|f<rsub|2>>|\<rangle\>>=<around*|\||\<downarrow\>|\<rangle\>>|\<nobracket\>>>.
  Interestingly, if the atoms are bosonic, i.e. if their hyperfine spin
  <math|f> takes on an integer value, the atoms become effective spin
  <math|<frac|1|2>> bosons.

  The coupling to other hyperfine states has to be avoided because not only
  does the role of additional hyperfine states require a larger Hilbert space
  description, but also it generally causes significant particle loss. For
  magnetic field strengths near the hyperfine magnetic field,
  <math|b\<sim\>1>, the Zeeman levels are widely spaced with energy
  differences comparable to <math|a<rsub|h*f>> (tens of <math|m*K>),
  considerably larger than the typical trap depths (<math|\<mu\>*K>). Hence,
  spin flip collisions in which particles end up in lower energy spin states
  create particle pairs of sufficient kinetic energy to evict spin flipped
  particles from the trap. However, conservation of energy and conservation
  of total spin projection (<math|m<rsub|f>>) in binary atom interactions
  limit the spin-changing collisions that can take place in an external
  magnetic field.

  In the case of nuclear spin <math|i=<frac|3|2>>, the experimentalist can
  select either the two lowest or the two highest energy levels of the
  <math|f=1> manifold: either <math|<around*|\||1,0|\<rangle\>>> and
  <math|<around*|\||1,-1|\<rangle\>>> or <math|<around*|\||1,0|\<rangle\>>>
  and <math|<around*|\||1,+1|\<rangle\>>>. While collisions
  <math|<around*|\||1,0|\<rangle\>>+<around*|\||1,0|\<rangle\>>>
  <math|\<rightarrow\><around*|\||1,-1|\<rangle\>>+<around*|\||1,+1|\<rangle\>>>
  would produce spin states not included in the spin-up and spin-down basis,
  in the region <math|b\<sim\>1>, the energy cost of a spin flip up
  (<math|m<rsub|f>> from <math|0> to <math|+1>) outweighs the energy gain
  from the corresponding spin flip down process (<math|m<rsub|f>> from
  <math|0> to <math|-1>), as can be seen from Fig.<nbsp><reference|Fig1boson>
  so that this process is energy forbidden. For nuclear spin <math|1>,
  <math|i=1>, as in the case of <math|<rsup|6>L*i>, <rsup|<math|23>>Na and
  <rsup|<math|87>>Rb, the experimentalist can select the two lowest energy
  hyperfine states, <math|<around*|\||\<uparrow\>|\<rangle\>>=<around|\||<frac|1|2>,<frac|1|2>|\<rangle\>>>,
  and <math|<around*|\||\<downarrow\>|\<rangle\>>=<around*|\||<frac|1|2>,-<frac|1|2>|\<rangle\>>>,
  for instance.

  In the <math|<around*|\<nobracket\>|<around*|\||f<rsub|1>,m<rsub|f<rsub|1>>|\<rangle\>>=<around*|\||\<uparrow\>|\<rangle\>>|\<nobracket\>>>
  and <math|<around*|\<nobracket\>|<around*|\||f<rsub|2>,m<rsub|f<rsub|2>>|\<rangle\>>=<around*|\||\<downarrow\>|\<rangle\>>|\<nobracket\>>>
  basis the pseudospin operator takes the form
  <math|<math-bf|s>=<frac|1|2>*<with|math-font-family|bf|\<sigma\>>>, where
  <math|<with|math-font-family|bf|\<sigma\>>> is the Pauli-spin vector
  operator, <math|<with|math-font-family|bf|\<sigma\>>=\<sigma\><rsub|x><math-bf|x>+\<sigma\><rsub|y><math-bf|y>+\<sigma\><rsub|z><math-bf|z>>,
  with <math|\<sigma\><rsub|x>>, <math|\<sigma\><rsub|y>>, and
  <math|\<sigma\><rsub|z>> the Pauli spin matrices. Note that
  <math|<math-bf|s>> is <with|font-shape|italic|not> the generator of
  rotations. Under rotation, the spin components do not transform among each
  other according to Eq.<nbsp>(<reference|rot>), although the
  <math|<math-bf|s>> components still satisfy angular momentum commutator
  relations <math|<around*|[|s<rsub|x>,s<rsub|y>|]><rsub|->=i*s<rsub|z>>.
  Therefore, the time evolution of the many-spin system (governed by
  commutation relations in the Heisenberg picture) is indistinguishable from
  the quantum evolution of the magnetic many-spin system of the same
  parameters. The concept of effective spin parallels closely that of
  iso-spin in nuclear physics <cite|DeBenedetti>, except that a Raman
  transition and/or oscillating magnetic field can convert spin-down into
  spin-up particles. Likewise, as emphasized by Bloch <cite|Bloch>, any
  two-state system (and its decoherence) can be described by an effective
  spin <math|<frac|1|2>> system.

  To picture the role of the pseudo-spin direction, we parametrize an
  arbitrary, normalized two component spinor
  <math|<around*|\||\<xi\><rsub|p*s>|\<rangle\>>> by introducing two angles
  <math|\<theta\>> and <math|\<phi\>>.

  <\equation>
    <around*|\||\<xi\><rsub|p*s>|\<rangle\>>=

    <\around*|(>
      <array|c|l|\<xi\><rsub|\<uparrow\>><next-line>\<xi\><rsub|\<downarrow\>>>
    </around*|)>

    =

    <\around*|(>
      <array|c|l|e<rsup|i*<frac|\<phi\>|2>>*cos
      <frac|\<theta\>|2><next-line>e<rsup|-i*<frac|\<phi\>|2>>*sin
      <frac|\<theta\>|2>>
    </around*|)>

    .
  </equation>

  In this notation, <math|\<phi\>> denotes the relative phase: the difference
  of the complex phase of the `up' amplitude and of that of the `down'
  amplitude. Also, <math|cos \<theta\>> denotes the effective polarization:
  the difference between the up probability and the down probability. Then
  the expectation value of the effective spin vector
  <math|<around*|\<langle\>|<math-bf|s>|\<rangle\>>> in terms of
  <math|\<theta\>> and <math|\<phi\>> is

  <\equation>
    <around*|\<langle\>|<math-bf|s>|\<rangle\>>=<frac|1|2><around*|\<langle\>|\<xi\><rsub|p*s>|\|><wide|\<sigma\>|\<vect\>><around*|\||\<xi\><rsub|p*s>|\<rangle\>>=<frac|1|2>*<around*|(|sin
    \<theta\>*cos \<phi\><math-bf|x>+sin \<theta\>*sin \<phi\><math-bf|y>+cos
    \<theta\><math-bf|z>|)>,<no-number>
  </equation>

  which is a vector on the surface of a sphere of radius <math|<frac|1|2>>
  (known as the `Bloch sphere'). The inclination <math|\<theta\>> and
  azimuthal <math|\<phi\>> angles of the expectation value of the pseudospin
  vector then respectively characterize the `polarization' and the phase
  difference. If an ensemble measurement reveals
  <math|N<rsub|\<uparrow\><around|(|\<downarrow\>|)>>> atoms in the `up'
  (`down') hyperfine state, then <math|<around*|\<langle\>|cos
  <around|(|\<theta\>|)>|\<rangle\>>=<around*|(|N<rsub|\<uparrow\>>-N<rsub|\<downarrow\>>|)>/<around*|(|N<rsub|\<uparrow\>>+N<rsub|\<downarrow\>>|)>>.

  <section|Spin-spin binary atom interactions>

  Cold alkali atoms are interesting building blocks for simulating magnetic
  systems: their mutual interactions preserve the overall spin projection
  (the sum of <math|m<rsub|f>> is preserved), the interactions are naturally
  spin dependent and the strength of these interactions and their
  spin-dependence can be varied by a Feshbach resonance. We write the
  effective atom-atom interaction as a spin-spin interaction. The statistics
  of indistinguishability, combined with the short-range nature of the
  effective interaction gives a short-range Ising-like spin-spin interaction
  or, alternatively, a short-range <math|X*Y>-interaction. We calculate the
  spin-dependence in the Degenerate Internal State (DIS) approximation.

  <subsection|Effective inter-particle interaction in pseudospin language>

  In cold atom experiments, the length scales relevant to the many-body
  physics description (<math|\<sim\>\<mu\>*m>) significantly exceed the
  length scale on which the atoms interact (which ranges from Bohr-radius to
  <math|n*m>). As a consequence, the interactions of indistinguishable atoms
  <math|i> and <math|j> with position coordinates <math|<math-bf|x><rsub|i>>
  and <math|<math-bf|x><rsub|j>> can be described by an effective contact
  interaction potential

  <\equation>
    V<around*|(|<math-bf|x><rsub|i>,<math-bf|x><rsub|j>|)>=<frac|4*\<pi\>*\<hbar\><rsup|2>|m>*a*\<delta\>*<around*|(|<math-bf|x><rsub|i>-<math-bf|x><rsub|j>|)>.<label|delta>
  </equation>

  where <math|a> denotes the scattering length and <math|m> represents the
  single particle mass. In the low energy regime of interest in a many-body
  description, this interaction reproduces the real binary atom scattering
  physics (to all orders) in a first order perturbation calculation. The
  interaction potential reproduces the correct binary atom s-wave scattering
  amplitude in the Born approximation. Introducing the annihilation
  (creation) field operators <math|<wide|\<psi\>|^>>
  (<math|<wide|\<psi\>|^><rsup|\<dagger\>>>), the particle-particle
  interactions are described by

  <eqnarray|<tformat|<table|<row|<cell|<wide|H|^><rsub|i*n*t>>|<cell|=>|<cell|<frac|1|2>*<big|int>d<rsup|3>*x*<big|int>d<rsup|3>*x<rprime|'>*<space|0.27em><space|0.27em><wide|\<psi\>|^><rsup|\<dagger\>><around|(|<with|font-series|bold|x>|)>*<wide|\<psi\>|^><rsup|\<dagger\>><around|(|<with|font-series|bold|x><rprime|'>|)>*V*<around*|(|<with|font-series|bold|x>-<with|font-series|bold|x><rprime|'>|)>*<wide|\<psi\>|^><around|(|<with|font-series|bold|x><rprime|'>|)><wide|\<psi\>|^><around|(|<with|font-series|bold|x>|)>>>|<row|<cell|>|<cell|=>|<cell|<frac|1|2><around*|(|<frac|4*\<pi\>*\<hbar\><rsup|2>|m>|)>*<big|int>d<rsup|3>*x*<space|0.27em><space|0.27em><wide|\<psi\>|^><rsup|\<dagger\>><around|(|<with|font-series|bold|x>|)>*<wide|\<psi\>|^><rsup|\<dagger\>><around|(|<with|font-series|bold|x>|)><wide|\<psi\>|^><around|(|<with|font-series|bold|x>|)><wide|\<psi\>|^><around|(|<with|font-series|bold|x>|)><space|0.27em>,<eq-number>>>>>>

  in the Hamiltonian operator. When the indistinguishable particles are
  bosons that occupy two possible spin states,
  <math|<around*|\||\<uparrow\>|\<rangle\>>> and
  <math|<around*|\||\<downarrow\>|\<rangle\>>>, we distinguish interactions
  between particles in like spin states, described by a scattering length
  <math|a<rsub|\<uparrow\>>> (<math|a<rsub|\<downarrow\>>>) if that state is
  the `up' (`down') spin-state, and between particles in unlike spin states,
  described by scattering length <math|a<rsub|u>>. The Hamiltonian operator
  that accounts for these interactions takes the form

  <eqnarray|<tformat|<table|<row|<cell|<wide|H|^><rsub|i*n*t>>|<cell|=<frac|1|2><around*|(|<frac|4*\<pi\>*\<hbar\><rsup|2>|m>|)>*<around*|(|a<rsub|\<uparrow\>>*<big|int>d<rsup|3>*x*<space|0.27em><space|0.27em><wide|\<psi\>|^><rsub|\<uparrow\>><rsup|\<dagger\>><around|(|<math-bf|x>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><rsup|\<dagger\>><around|(|<math-bf|x>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around|(|<math-bf|x>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around|(|<math-bf|x>|)>|\<nobracket\>>>>|<row|<cell|>|<cell|+a<rsub|\<downarrow\>>*<big|int>d<rsup|3>*x*<space|0.27em><space|0.27em><wide|\<psi\>|^><rsub|\<downarrow\>><rsup|\<dagger\>><around|(|<math-bf|x>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><rsup|\<dagger\>><around|(|<math-bf|x>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around|(|<math-bf|x>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around|(|<math-bf|x>|)>>>|<row|<cell|>|<cell|<around*|\<nobracket\>|+2*a<rsub|u>*<big|int>d<rsup|3>*x*<space|0.27em><space|0.27em><wide|\<psi\>|^><rsub|\<uparrow\>><rsup|\<dagger\>><around|(|<math-bf|x>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><rsup|\<dagger\>><around|(|<math-bf|x>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around|(|<math-bf|x>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around|(|<math-bf|x>|)>|)>.<eq-number><label|b2>>>>>>

  By virtue of Pauli exclusion principle, fermion particles occupying two
  spin states <math|<around*|\||\<uparrow\>|\<rangle\>>> and
  <math|<around*|\||\<downarrow\>|\<rangle\>>> only interact via short-ranged
  interactions if they are in different spin states,

  <\equation>
    <wide|H|^><rsub|i*n*t>=<around*|(|<frac|4*\<pi\>*\<hbar\><rsup|2>*a<rsub|F>|m>|)>*<big|int>d<rsup|3>*x*<space|0.27em><space|0.27em><wide|\<psi\>|^><rsup|\<dagger\>><rsub|\<uparrow\>><around|(|<with|font-series|bold|x>|)>*<wide|\<psi\>|^><rsup|\<dagger\>><rsub|\<downarrow\>><around|(|<with|font-series|bold|x>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around|(|<with|font-series|bold|x>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around|(|<with|font-series|bold|x>|)><space|0.27em>,<label|f2>
  </equation>

  where <math|a<rsub|F>> describes the low energy fermion-fermion scattering.
  We obtain these expressions from a scattering picture and derive a pseudo
  spin-spin form of the particle-particle effective interaction potentials.

  If the effective pseudo spin projection is conserved, interacting spin
  <math|<frac|1|2>> atoms, <math|1> and <math|2>, can undergo four types of
  scattering events, represented in Fig.<nbsp><reference|Fig2collision>,
  <math|<around*|\||\<uparrow\>*\<uparrow\>|\<rangle\>>\<rightarrow\><around*|\||\<uparrow\>*\<uparrow\>|\<rangle\>>>,
  <math|<around*|\||\<downarrow\>*\<downarrow\>|\<rangle\>>\<rightarrow\><around*|\||\<downarrow\>*\<downarrow\>|\<rangle\>>>,
  <math|<around*|\||\<uparrow\>*\<downarrow\>|\<rangle\>>\<rightarrow\><around*|\||\<uparrow\>*\<downarrow\>|\<rangle\>>>
  (with the same amplitude as <math|<around*|\||\<downarrow\>*\<uparrow\>|\<rangle\>>\<rightarrow\><around*|\||\<downarrow\>*\<uparrow\>|\<rangle\>>>
  ) and <math|<around*|\||\<downarrow\>*\<uparrow\>|\<rangle\>>\<rightarrow\><around*|\||\<uparrow\>*\<downarrow\>|\<rangle\>>>,
  (with the same amplitude as <math|<around*|\||\<uparrow\>*\<downarrow\>|\<rangle\>>\<rightarrow\><around*|\||\<downarrow\>*\<uparrow\>|\<rangle\>>>
  ) where the first arrow in the brackets indicates the spin of atom
  <math|1>, the second arrow shows the spin of atom <math|2>. By
  construction, the effective interaction yields the correct transition
  matrix elements in the Born-approximation for the four types of binary atom
  scattering events: <math|<around|(|4*\<pi\>*\<hbar\><rsup|2>*a<rsub|\<downarrow\>>/m|)>>
  for the mutual scattering of two `down' particles,
  <math|<around|(|4*\<pi\>*\<hbar\><rsup|2>*a<rsub|\<uparrow\>>/m|)>> for the
  mutual scattering of two `up' particles,
  <math|<around|(|4*\<pi\>*\<hbar\><rsup|2>*a<rsub|D>/m|)>> for direct
  scattering (unlike spin scattering without spin flip) and
  <math|<around|(|4*\<pi\>*\<hbar\><rsup|2>*a<rsub|x>/m|)>> for exchange
  scattering events (unlike spin scattering with spin flip).

  Denoting the full coordinate of particle <math|i>, which consists of
  position <math|<math-bf|x><rsub|i>> and spin <math|<math-bf|s><rsub|i>> by
  <math|<math-bf|r><rsub|i>>, we can replace the effective interaction
  potential Eq. (<reference|delta>) by

  <\equation>
    V<around*|(|<math-bf|r><rsub|1>,<math-bf|r><rsub|2>|)>=<frac|4*\<pi\>*\<hbar\><rsup|2>|m>*<wide|a|^>*\<delta\>*<around*|(|<math-bf|x><rsub|1>-<math-bf|x><rsub|2>|)>,<label|delta>
  </equation>

  which is a spin-operator. In the basis of the up and down spins,
  <math|<around*|{|<around*|\||\<uparrow\>*\<uparrow\>|\<rangle\>>,<around*|\||\<uparrow\>*\<downarrow\>|\<rangle\>>,<around*|\||\<downarrow\>*\<uparrow\>|\<rangle\>>,<around*|\||\<downarrow\>*\<downarrow\>|\<rangle\>>|}>>,
  the <math|<wide|a|^>>-operator reads

  <\equation>
    <wide|a|^>=

    <\around*|(>
      <array|c|l*l*l*l|<tformat|<table|<row|<cell|a<rsub|\<uparrow\>>>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|a<rsub|D>>|<cell|a<rsub|x>>|<cell|0>>|<row|<cell|0>|<cell|a<rsub|x>>|<cell|a<rsub|D>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>|<cell|a<rsub|\<downarrow\>>>>>>>
    </around*|)>

    ,<label|amatrix>
  </equation>

  in accordance with the above description.

  <\big-figure>
    <image|Fig2spin_interaction.eps|3in|||>

    <label|Fig2collision>
  </big-figure|Graphic illustration of the four types of binary atom
  scattering processes: (a) two spin-up particles collide, (b) two spin down
  particles collide, (c) one spin up and one spin-down particle particle
  scatter while the spin projection of the interacting particles remains the
  same, and (d) a spin-up and a spin-down particle exchange spin states in
  the collision.>

  To connect with spin physics we write the spin dependent scattering length
  operator, <math|<wide|a|^>>, as the sum of products of single particle
  spin-operators. We write Eq. (<reference|amatrix>) as

  <\equation>
    <wide|a|^>=a<rsub|o>*<wide|I|^>+a<rsub|z,+>*<around*|(|s<rsub|1,z>+s<rsub|2,z>|)>+a<rsub|z,p>*<around*|[|4*<around*|(|s<rsub|1,z>*s<rsub|2,z>|)>|]>+a<rsub|x>*<around*|[|2*<around*|(|s<rsub|1,x>*s<rsub|2,x>+s<rsub|1,y>*s<rsub|2,y>|)>|]>,
  </equation>

  where <math|<wide|I|^>> denotes the unit operator. The operators in square
  brackets are the spin projection sum operator,

  <\equation>
    s<rsub|1,z>+s<rsub|2,z>=

    <\around*|(>
      <array|c|c*c*c*c|<tformat|<table|<row|<cell|1>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>|<cell|-1>>>>>
    </around*|)>

    ,
  </equation>

  the spin projection product operator,

  <\equation>
    s<rsub|1,z>*s<rsub|2,z>=

    <\around*|(>
      <array|c|c*c*c*c|<tformat|<table|<row|<cell|1>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|-1>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|-1>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>|<cell|1>>>>>
    </around*|)>

    ,
  </equation>

  and the exchange operator,

  <\equation>
    s<rsub|1,x>*s<rsub|2,x>+s<rsub|1,y>*s<rsub|2,y>=

    <\around*|(>
      <array|c|l*l*l*l|<tformat|<table|<row|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|1>|<cell|0>>|<row|<cell|0>|<cell|1>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>|<cell|0>>>>>
    </around*|)>

    .
  </equation>

  By comparing the off-diagonal matrix elements, it is clear that the
  exchange operator coefficient must be equal to the exchange scattering
  length <math|a<rsub|x>>. Identifying the diagonal matrix elements we find
  <math|a<rsub|o>,a<rsub|z,p>,a<rsub|z,+>>;

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|a<rsub|o>=<frac|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>+2*a<rsub|D>|4>,>>|<row|<cell|>|<cell|a<rsub|z,p>=<frac|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>-2*a<rsub|D>|4>,>>|<row|<cell|>|<cell|a<rsub|z,+>=<frac|a<rsub|\<uparrow\>>-a<rsub|\<downarrow\>>|2><space|0.27em>.<eq-number>>>>>>

  Hence, the expression

  <eqnarray|<tformat|<table|<row|<cell|V<around|(|<wide|r|\<vect\>><rsub|1>,<wide|r|\<vect\>><rsub|2>|)>>|<cell|=>|<cell|<around*|(|<frac|4*\<pi\>*\<hbar\><rsup|2>|m>|)>*\<delta\>*<around|(|<math-bf|x><rsub|1>-<math-bf|x><rsub|2>|)>*<around*|{|<around*|[|<frac|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>+2*a<rsub|D>|4>|]>+<around*|[|<frac|a<rsub|\<uparrow\>>-a<rsub|\<downarrow\>>|2>|]>*<around*|(|s<rsub|1,z>+s<rsub|2,z>|)>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|+<around*|[|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>-2*a<rsub|D>|]>*<around*|(|s<rsub|1,z>*s<rsub|2,z>|)>+2*a<rsub|x>*<around*|(|s<rsub|1,x>*s<rsub|2,x>+s<rsub|1,y>*s<rsub|2,y>|)>|}>.<eq-number><label|effspin>>>>>>

  translates the effective interaction potential operator Eq.
  (<reference|delta>) into pseudo-spin language.

  <subsection|A magnetic-like interaction form of the inter-particle
  interactions>

  In the interest of exploiting the magnetism analogy, we note that the
  effective spin-dependent interaction Eq. (<reference|effspin>) can be
  rephrased as a magnetic interaction. Specifically, the spin-dependent part
  stems from the interaction of the effective spin of one particle with an
  effective short-ranged magnetic field carried by the other particle. That
  description allows one to interpret the interaction of one particle in a
  many-body system to be caused by the interaction with an external field and
  with an internal magnetic field generated by the moments of the other
  particles.

  We write the effective interaction of atoms <math|1> and <math|2>, as the
  sum of a spin independent contact interaction, <math|V<rsub|o>> and and a
  spin interaction, <math|V<rsub|s>>, <math|V<around*|(|<wide|r|\<vect\>><rsub|1>,<wide|r|\<vect\>><rsub|2>|)>=V<rsub|o>*<around*|(|<wide|x|\<vect\>><rsub|1>-<wide|x|\<vect\>><rsub|2>|)>+V<rsub|s><around*|(|<wide|r|\<vect\>><rsub|1>,<wide|r|\<vect\>><rsub|2>|)>>
  where

  <\equation>
    V<rsub|o>*<around*|(|<math-bf|x><rsub|1>-<math-bf|x><rsub|2>|)>=<frac|\<pi\>*\<hbar\><rsup|2>|m>*<around*|(|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>+2*a<rsub|D>|)>*\<delta\>*<around*|(|<math-bf|x><rsub|1>-<math-bf|x><rsub|2>|)>.<label|spinin2>
  </equation>

  The spin-dependent part we cast into the form of the energy of a spin in a
  magnetic field with unit effective Bohr-magneton (as we chose the spin to
  be dimensionless, the effective magnetic field than takes the units of
  energy)

  <\equation>
    V<rsub|s><around*|(|<math-bf|r><rsub|1>,<math-bf|r><rsub|2>|)>=<math-bf|s><rsub|1>\<cdot\><math-bf|h><rsub|2><around*|(|<math-bf|x><rsub|1>|)>+<math-bf|s><rsub|2>\<cdot\><math-bf|h><rsub|1><around*|(|<math-bf|x><rsub|2>|)>,<label|spin2>
  </equation>

  where we assume the effective <math|<math-bf|h>>\Umagnetic field to be the
  short-range part of an effective moment <math|<math-bf|m>>,

  <\equation>
    <math-bf|h><rsub|i><around*|(|<math-bf|x>|)>=<math-bf|m><rsub|i>\<delta\>*<around*|(|<math-bf|x>-<math-bf|x><rsub|i>|)>.<space|0.27em><label|h2>
  </equation>

  The effective <math|<math-bf|m>>-moment is an operator,

  <\equation>
    <math-bf|m><rsub|i>=m<rsub|s,o><math-bf|z>+m<rsub|s,\<parallel\>><math-bf|z><space|0.27em><around*|(|<space|0.27em><math-bf|s><rsub|i><space|0.27em>\<cdot\><math-bf|z><space|0.27em>|)>+m<rsub|s,\<perp\>><space|0.27em><math-bf|z>\<times\><around*|(|<space|0.27em><math-bf|s><rsub|i>\<times\><math-bf|z><space|0.27em>|)>,<label|mom2>
  </equation>

  with moment parameters

  <eqnarray|<tformat|<table|<row|<cell|m<rsub|s,o>>|<cell|=<frac|2*\<pi\>*\<hbar\><rsup|2>|m>*<around*|(|a<rsub|\<uparrow\>>-a<rsub|\<downarrow\>>|)>,>>|<row|<cell|m<rsub|s,\<parallel\>>>|<cell|=<frac|2*\<pi\>*\<hbar\><rsup|2>|m>*<around*|(|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>-2*a<rsub|D>|)>,>>|<row|<cell|m<rsub|s,\<perp\>>>|<cell|=<frac|4*\<pi\>*\<hbar\><rsup|2>|m>*a<rsub|x>,<eq-number><label|gyro2>>>>>>

  that depend on the scattering lengths.

  <subsection|The effect of quantum statistics on short-range spin-spin
  interactions>

  As the pseudo spin operators are not the generators of rotations, the
  spin-spin interaction can be and generally is anisotropic. The
  <math|m<rsub|o>>-term describes the interaction of <math|<wide|s|\<vect\>>>
  with an effective short-range magnetic moment that points in the
  <math|<wide|z|\<vect\>>>-direction (the direction of the physical magnetic
  field, the actual field that splits the Zeeman-levels) and is independent
  of the pseudo-spin of the particle that carries the moment. Another source
  of anisotropy is the difference in the <math|m<rsub|\<parallel\>>> and
  <math|m<rsub|\<perp\>>>-moment parameters. The short-range nature of the
  interactions and the quantum statistics of the interacting particles, give
  a moment that can be chosen to align itself with the magnetic field
  direction or to be perpendicular to it. To see that, consider the
  interaction

  <\equation>
    <wide|H|^><rsub|i*n*t>=<frac|1|2><around*|(|<frac|4*\<pi\>*\<hbar\><rsup|2>|m>|)>*<big|int>d<rsup|3>*x*<space|0.27em><space|0.27em><around*|\<langle\>|<wide|\<psi\>|^><rsup|\<dagger\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsup|\<dagger\>><around*|(|<wide|x|\<vect\>>|)><around*|\||<wide|a|^>|\|><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)>|\<rangle\>>,
  </equation>

  where <math|<wide|a|^>> denotes the spin-dependent scattering length
  operator of Eq. (<reference|amatrix>), where

  <\equation>
    <around*|\<nobracket\>|\|<wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)>|\<rangle\>>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>>>|<row|<cell|<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>>>|<row|<cell|<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>>>|<row|<cell|<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>>>>>>|)>,<label|2spin>
  </equation>

  indicates the two-particle spinor. The short-range nature of the
  interaction causes the field operators to be evaluated at the same
  position, <math|<wide|x|\<vect\>>>. As pairs of annihilation and creation
  operators of the same argument, the two-particle spinor components obey
  commutator (anti-commutator) relations if the interacting particles are
  bosonic (fermionic), <math|<wide|\<psi\>|^><rsub|i><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|j><around*|(|<wide|x|\<vect\>>|)>=\<pm\><wide|\<psi\>|^><rsub|j><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|i><around*|(|<wide|x|\<vect\>>|)>>.
  By writing the components of the two particle spinor Eq.
  (<reference|2spin>) as half the sum with itself, then replacing the second
  term by <math|\<pm\>> its reverse order, we obtain, for bosons

  <\equation>
    <around*|\||<wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)>|\<rangle\>>=

    <\around*|(>
      <array|c|c|<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)><next-line><frac|1|<sqrt|2>><around*|(|<frac|<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>+<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>|<sqrt|2>>|)><next-line><frac|1|<sqrt|2>><around*|(|<frac|<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>+<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>|<sqrt|2>>|)><next-line><wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>>
    </around*|)>

    ,<label|bspin>
  </equation>

  for bosons and for fermions

  <\equation>
    <around*|\||<wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)>|\<rangle\>>=

    <\around*|(>
      <array|c|c|0<next-line><frac|1|<sqrt|2>><around*|(|<frac|<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>-<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>|<sqrt|2>>|)><next-line><frac|1|<sqrt|2>><around*|(|<frac|<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>-<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>|<sqrt|2>>|)><next-line>0>
    </around*|)>

    .<label|fspin>
  </equation>

  The resulting non-vanishing column matrix elements are components of the
  pseudo-spin triplet manifold in the boson-case and the pseudospin singlet
  state in the fermion case. We find that the two-particle spinor is
  projected onto the triplet subspace if the fields are bosonic and onto the
  singlet subspace if the fields are fermionic,

  <eqnarray|<tformat|<table|<row|<cell|<around*|\||<wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)>|\<rangle\>><rsub|b*o*s*o*n*s>>|<cell|=>|<cell|<wide|\<Pi\>|^><rsub|T><around*|\||<wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)>|\<rangle\>>,>>|<row|<cell|<around*|\||<wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)>|\<rangle\>><rsub|f*e*r*m*i*o*n*s>>|<cell|=>|<cell|<wide|\<Pi\>|^><rsub|S><around*|\||<wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)>|\<rangle\>>,<eq-number>>>>>>

  where the <math|<wide|\<Pi\>|^><rsub|T>> (<math|<wide|\<Pi\>|^><rsub|S>>)
  project onto the two-particle pseudospin triplet (singlet) subspace. We can
  check that statement by direct inspection. For instance, the second
  component of the column matrices Eq. (<reference|bspin>) and Eq.
  (<reference|fspin>) represents the two-particle annihilation field of the
  <math|<around|\||\<uparrow\>*\<downarrow\>|\<rangle\>>>\Ustate, which can
  be written as <math|<around|\||\<uparrow\>*\<downarrow\>|\<rangle\>>=<frac|1|<sqrt|2>>*<around*|(|<frac|<around|\||\<uparrow\>*\<downarrow\>|\<rangle\>>+<around|\||\<downarrow\>*\<uparrow\>|\<rangle\>>|<sqrt|2>>+<frac|<around|\||\<uparrow\>*\<downarrow\>|\<rangle\>>-<around|\||\<downarrow\>*\<uparrow\>|\<rangle\>>|<sqrt|2>>|)>>,
  so that <math|<wide|\<Pi\>|^><rsub|T>\|\<uparrow\>*\<downarrow\>\<rangle\>=<frac|1|<sqrt|2>>*<frac|<around|\||\<uparrow\>*\<downarrow\>|\<rangle\>>+<around|\||\<downarrow\>*\<uparrow\>|\<rangle\>>|<sqrt|2>>>
  and <math|<wide|\<Pi\>|^><rsub|S>\|\<uparrow\>*\<downarrow\>\<rangle\>=<frac|1|<sqrt|2>>*<frac|<around|\||\<uparrow\>*\<downarrow\>|\<rangle\>>-<around|\||\<downarrow\>*\<uparrow\>|\<rangle\>>|<sqrt|2>>>,
  corresponding to the spin states of the second component of the right-hand
  sides of Eqs. (<reference|bspin>) and (<reference|fspin>).

  Writing the boson matrix product of the interaction Hamiltonian out, we
  find that we can also write the effective interaction Hamiltonian as a
  bracket of the triplet two-particle spinor,

  <\equation>
    <around*|\||<wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)>|\<rangle\>><rsub|T>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>>>|<row|<cell|<frac|<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>+<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>|<sqrt|2>>>>|<row|<cell|<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>>>>>>|)>,<label|tspin>
  </equation>

  in terms of which

  <\equation>
    <wide|H|^><rsub|i*n*t>=<frac|1|2><around*|(|<frac|4*\<pi\>*\<hbar\><rsup|2>|m>|)>*<big|int>d<rsup|3>*x*<space|0.27em><space|0.27em><rsub|T><around*|\<langle\>|<wide|\<psi\>|^><rsup|\<dagger\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsup|\<dagger\>><around*|(|<wide|x|\<vect\>>|)><around|\||<wide|a|^><rsub|T>|\|><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)>|\<rangle\>><rsub|T>,<label|bint>
  </equation>

  where the triplet scattering length operator <math|<wide|a|^><rsub|T>> is
  now represented by a diagonal matrix,

  <\equation>
    <wide|a|^>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|a<rsub|\<uparrow\>>>|<cell|<space|0.27em><space|0.27em><space|0.27em><space|0.27em><space|0.27em>0>|<cell|0>>|<row|<cell|0>|<cell|a<rsub|D>+a<rsub|x>>|<cell|0>>|<row|<cell|0>|<cell|<space|0.27em><space|0.27em><space|0.27em><space|0.27em><space|0.27em>0>|<cell|a<rsub|\<downarrow\>>>>>>>|)>.<label|atmatrix>
  </equation>

  One more application of the commutator relations casts the interaction
  Hamiltonian Eq. (<reference|bint>) in the form of Eq. (<reference|b2>)
  provided we identify the unlike boson scattering length <math|a<rsub|u>>
  with <math|a<rsub|u>=a<rsub|D>+a<rsub|x>>. Likewise, the fermion
  interaction

  <\equation>
    <wide|H|^><rsub|i*n*t>=<frac|1|2><around*|(|<frac|4*\<pi\>*\<hbar\><rsup|2>|m>|)>*<big|int>d<rsup|3>*x*<space|0.27em><space|0.27em><rsub|S><around*|\<langle\>|<wide|\<psi\>|^><rsup|\<dagger\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsup|\<dagger\>><around*|(|<wide|x|\<vect\>>|)><around|\||<wide|a|^><rsub|S>|\|><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)>|\<rangle\>><rsub|S>,<label|fint>
  </equation>

  with two-particle singlet spin component

  <\equation>
    <around*|\||<wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)><wide|\<psi\>|^><around*|(|<wide|x|\<vect\>>|)>|\<rangle\>><rsub|S>=<frac|<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>-<wide|\<psi\>|^><rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>*<wide|\<psi\>|^><rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>|<sqrt|2>><space|0.27em>,
  </equation>

  and singlet scattering length,

  <\equation>
    <wide|a|^><rsub|S>=a<rsub|D>-a<rsub|x><space|0.27em>,
  </equation>

  reduces to the form of Eq. (<reference|f2>) if we identify <math|a<rsub|F>>
  with <math|a<rsub|F>=a<rsub|D>-a<rsub|x>>.

  As an interesting consequence of the triplet projection caused by boson
  statistics, the spin-spin interaction can be written in two equivalent
  forms. As <math|<wide|s|\<vect\>><rsub|1>\<cdot\><wide|s|\<vect\>><rsub|2>=1/4>
  in a triplet state, we can either replace
  <math|s<rsub|1,z>*s<rsub|2,z>=1/4-<around*|(|s<rsub|1,x>*s<rsub|2,x>+s<rsub|1,y>*s<rsub|2,y>|)>>
  or, alternatively, <math|s<rsub|1,x>*s<rsub|2,x>+s<rsub|1,y>*s<rsub|2,y>>
  by <math|s<rsub|1,x>*s<rsub|2,x>+s<rsub|1,y>*s<rsub|2,y>=1/4-s<rsub|1,z>*s<rsub|2,z>>.
  As a consequence of the second replacement, the effective spin-spin
  interaction takes the form of a short-range Ising-like interaction, the
  second replacement gives a short-range XY spin-spin interaction. The
  resulting boson spin-spin interactions

  <eqnarray|<tformat|<table|<row|<cell|V<rsub|I><around*|(|<wide|r|\<vect\>><rsub|1>,<wide|r|\<vect\>><rsub|2>|)>>|<cell|=>|<cell|<around*|(|<frac|4*\<pi\>*\<hbar\><rsup|2>|m>|)>*\<delta\>*<around*|(|<wide|x|\<vect\>><rsub|1>-<wide|x|\<vect\>><rsub|2>|)><around*|{|<around*|[|<frac|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>+2*a<rsub|u>|4>|]>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|+<around*|[|<frac|a<rsub|\<uparrow\>>-a<rsub|\<downarrow\>>|2>|]>*<around*|(|s<rsub|1,z>+s<rsub|2,z>|)>+<around*|[|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>-2*a<rsub|u>|]>*<around*|(|s<rsub|1,z>*s<rsub|2,z>|)>|}>,<eq-number><label|I>>>>>>

  and

  <eqnarray|<tformat|<table|<row|<cell|V<rsub|X*Y><around*|(|<wide|r|\<vect\>><rsub|1>,<wide|r|\<vect\>><rsub|2>|)>>|<cell|=<around*|(|<frac|4*\<pi\>*\<hbar\><rsup|2>|m>|)>*\<delta\>*<around*|(|<wide|x|\<vect\>><rsub|1>-<wide|x|\<vect\>><rsub|2>|)>*<around*|{|<around*|[|<frac|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>|2>|]>+<around*|[|<frac|a<rsub|\<uparrow\>>-a<rsub|\<downarrow\>>|2>|]>*<around*|(|s<rsub|1,z>+s<rsub|2,z>|)>|\<nobracket\>>>>|<row|<cell|>|<cell|<space|0.27em><around*|\<nobracket\>|-<around*|[|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>-2*a<rsub|u>|]>*<around*|(|s<rsub|1,x>*s<rsub|2,x>+s<rsub|1,y>*s<rsub|2,y>|)>|}><eq-number><label|XY>>>>>>

  are equivalent to each other and to the more conventional expression of Eq.
  (<reference|b2>). One advantage of the <math|X*Y>-form, Eq.
  (<reference|XY>), <math|V<rsub|X*Y><around*|(|<wide|r|\<vect\>><rsub|1>,<wide|r|\<vect\>><rsub|2>|)>>,
  is that the unlike boson scattering length <math|a<rsub|u>> only occurs in
  the spin-spin term. As a consequence a mixed spin channel Feshbach
  resonance will vary only the <math|X*Y>spin-spin coupling. In general, a
  Feshbach resonance occurs when the incident particle channel becomes
  degenerate with the quasi-bound state of another collision channel. Hence a
  particular resonance will either vary <math|a<rsub|\<uparrow\>>>, or
  <math|a<rsub|\<downarrow\>>> or <math|a<rsub|u>>. A mixed spin channel
  resonance of magnetic field width <math|\<Delta\>*B> around magnetic field
  strength <math|B<rsub|r*e*s>> varies the unlike scattering length
  <math|a<rsub|u>> as

  <\equation>
    a<rsub|u,r*e*s><around*|(|B|)>=a<rsub|u>*<around*|[|1-<frac|\<Delta\>*B|B-B<rsub|r*e*s>>|]><space|0.27em>,
  </equation>

  where <math|a<rsub|u>> is the background scattering length that varies
  slowly with magnetic field (on the magnetic field scale of
  <math|B<rsub|h*f>>. The Feshbach variation thereby adds an effective
  interaction potential

  <\equation>
    \<Delta\>*V<rsub|X*Y><around*|(|<wide|r|\<vect\>><rsub|1>,<wide|r|\<vect\>><rsub|2>|)>=<around*|(|<frac|\<Delta\>*B|B<rsub|r*e*s>-B>|)><around*|(|<frac|4*\<pi\>*\<hbar\><rsup|2>*a<rsub|u>|m>|)>*\<delta\>*<around*|(|<wide|x|\<vect\>><rsub|1>-<wide|x|\<vect\>><rsub|2>|)>*<around*|(|s<rsub|1,x>*s<rsub|2,x>+s<rsub|1,y>*s<rsub|2,y>|)>
  </equation>

  to the above <math|X*Y> form of the spin-dependent particle-particle
  interaction Eq. (<reference|XY>).

  In terms of the magnetic form of the inter-particle interactions,

  <\equation>
    V<rsub|I<around|(|X,Y|)>>=V<rsub|o,I<around|(|X,Y|)>>*<around*|(|<wide|x|\<vect\>><rsub|1>-<wide|x|\<vect\>><rsub|2>|)>+V<rsub|s,I<around|(|X,Y|)>><around*|(|<wide|r|\<vect\>><rsub|1>,<wide|r|\<vect\>><rsub|2>|)>,
  </equation>

  where <math|V<rsub|o,I*<around|(|X*Y|)>>=<around|[|4*\<pi\>*\<hbar\><rsup|2>/m|]>*\<delta\>*<around*|(|<wide|x|\<vect\>><rsub|1>-<wide|x|\<vect\>><rsub|2>|)>*a<rsub|o,I<around|(|X,Y|)>>>
  in which

  <eqnarray|<tformat|<table|<row|<cell|a<rsub|o,I>>|<cell|=>|<cell|<frac|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>+2*a<rsub|u>|4>,>>|<row|<cell|a<rsub|o,X*Y>>|<cell|=>|<cell|<space|0.27em><space|0.27em><space|0.27em><frac|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>|2>,<eq-number>>>>>>

  denote the Ising and XY expressions of the spin independent scattering
  length. The spin interactions take the usual form
  <math|V<rsub|s,I*<around|(|X*Y|)>><around*|(|<wide|r|\<vect\>><rsub|1>,<wide|r|\<vect\>><rsub|2>|)>=<math-bf|s><rsub|1>\<cdot\><math-bf|h><rsub|2,I*<around|(|X*Y|)>><around*|(|<wide|x|\<vect\>><rsub|1>|)>+<math-bf|s><rsub|2>\<cdot\><math-bf|h><rsub|1,I*<around|(|X*Y|)>><around*|(|<wide|x|\<vect\>><rsub|2>|)>>
  with <math|<math-bf|h><rsub|i,I*<around|(|X*Y|)>><around*|(|<wide|x|\<vect\>>|)>=\<delta\>*<around*|(|<wide|x|\<vect\>>-<wide|x|\<vect\>><rsub|i>|)><math-bf|m><rsub|i,I*<around|(|X*Y|)>>>
  and

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|m><rsub|i,I>>|<cell|=>|<cell|m<rsub|o><math-bf|z>+<around*|(|m<rsub|\<parallel\>>-m<rsub|\<perp\>>|)><math-bf|z><space|0.27em><around*|(|<math-bf|s><rsub|i>\<cdot\><math-bf|z>|)>,>>|<row|<cell|<math-bf|m><rsub|i,X*Y>>|<cell|=>|<cell|m<rsub|o><math-bf|z>+<around*|(|m<rsub|\<perp\>>-m<rsub|\<parallel\>>|)><math-bf|z>\<times\><around*|(|<math-bf|s><rsub|i>\<times\><math-bf|z>|)>,<eq-number>>>>>>

  with moment parameters (<math|m<rsub|o>,m<rsub|\<parallel\>>,m<rsub|\<perp\>>>)
  defined in Eq. (<reference|gyro2>).

  <subsection|Spin dependence of alkali atom interactions and the degenerate
  internal state approximation>

  The spin-dependence of the alkali-atom interactions stems from the exchange
  of valence electrons. As two alkali-nuclei approach each other to nanometer
  and sub-nanometer distance, their valence electrons, now encircling the two
  closely-spaced nuclei, become strongly correlated. If these electrons are
  indistinguishable, i.e., if their spins align in a triplet sate, the
  likelihood of finding them simultaneously in each others vicinity is
  reduced by virtue of the Pauli principle. Pauli exclusion then reduces the
  Coulomb energy shift in the inter-atomic potential. In contrast, spin
  singlet electrons can approach each other more closely, shifting the
  inter-atomic potential upward. Hence, the triplet potential
  <math|V<rsub|T>> is generally deeper than the singlet potential
  <math|V<rsub|S>>. The overall interaction of atoms can be expressed by an
  inter-atomic potential operator

  <\equation>
    V<around*|(|<math-bf|r><rsub|1>,<math-bf|r><rsub|2>|)>=V<rsub|T><around*|(|<around*|\||<math-bf|x><rsub|1>-<math-bf|x><rsub|2>|\|>|)>*<wide|\<Pi\>|^><rsub|e,T>+V<rsub|S><around*|(|<around*|\||<math-bf|x><rsub|1>-<math-bf|x><rsub|2>|\|>|)>*<wide|\<Pi\>|^><rsub|e,S>,<label|micrint>
  </equation>

  where the <math|<math-bf|r>> represent both the spatial coordinates
  <math|<math-bf|x>>, and spin, and <math|<wide|\<Pi\>|^><rsub|e,T>> ,
  <math|<wide|\<Pi\>|^><rsub|e,S>> denote the projection operators for the
  electron triplet <math|S=1> and singlet <math|S=0> states. When acting upon
  a triplet state, the square of the total electron spin operator,
  <math|<math-bf|S><rsub|e><rsup|2>=<frac|3|2>+2<math-bf|s><rsub|e,1>\<cdot\><math-bf|s><rsub|e,2>>
  yields an eigenvalue of <math|2> (i.e. <math|S*<around*|(|S+1|)>> with
  <math|S=1>). Acting upon a singlet state, the same operator gives zero, so
  that the triplet projection operator takes the form

  <\equation>
    <wide|\<Pi\>|^><rsub|e,T>=<frac|<math-bf|S><rsub|e><rsup|2>|2>=<frac|3|4>+<math-bf|s><rsub|e,1>\<cdot\><math-bf|s><rsub|e,2>.<label|proj1>
  </equation>

  Since <math|<wide|\<Pi\>|^><rsub|e,T>+<wide|\<Pi\>|^><rsub|e,S>=1>, the
  singlet projection operator is equal to

  <\equation>
    <wide|\<Pi\>|^><rsub|e,S>=1-<wide|\<Pi\>|^><rsub|e,T>=<frac|1|4>-<math-bf|s><rsub|e,1>\<cdot\><math-bf|s><rsub|e,2><space|0.27em>.<label|proj2>
  </equation>

  With Eqs. (<reference|proj1>) and (<reference|proj2>), the interatomic
  interaction potential operator Eq. (<reference|micrint>) reads

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|V<around*|(|<math-bf|r><rsub|1>,<math-bf|r><rsub|2>|)>=<frac|1|4>*<around*|[|3*V<rsub|T><around*|(|<around*|\||<math-bf|x><rsub|1>-<math-bf|x><rsub|2>|\|>|)>+V<rsub|S><around*|(|<around*|\||<math-bf|x><rsub|1>-<math-bf|x><rsub|2>|\|>|)>|]>>>|<row|<cell|>|<cell|<space|0.27em><space|0.27em><space|0.27em><space|0.27em><space|0.27em>+<around*|[|V<rsub|T><around*|(|<around*|\||<math-bf|x><rsub|1>-<math-bf|x><rsub|2>|\|>|)>-V<rsub|S><around*|(|<around*|\||<math-bf|x><rsub|1>-<math-bf|x><rsub|2>|\|>|)>|]><math-bf|s><rsub|e,1>\<cdot\><math-bf|s><rsub|e,2><space|0.27em>.<eq-number><label|sintrip>>>>>>

  The depth of the <math|V<rsub|S>> and <math|V<rsub|T>> potentials
  (<math|\<sim\>> electron Volt - <math|10<rsup|4>*K>) greatly exceeds the
  energy of the Zeeman spin interactions <math|\<sim\>a<rsub|h*f>>, tens of
  <math|m*K>). Inside the potential well, <math|r\<less\>r<rsub|1>>, the
  hyperfine interaction can be neglected whereas in the outer region,
  <math|r\<gtr\>r<rsub|1>>, the hyperfine interaction determines the spin
  state of the collision channel. The exchange interaction,
  <math|<around*|(|V<rsub|T>-V<rsub|S>|)>*<wide|s|\<vect\>><rsub|e,1>\<cdot\><wide|s|\<vect\>><rsub|e,2>>
  also falls off rapidly (exponentially) in the outer region. One can then
  calculate the scattering wavefunction while omitting the Zeeman terms in
  <math|r\<less\>r<rsub|1>> and treating the exchange interaction in the
  region <math|r\<gtr\>r<rsub|1>> as a perturbation term. In lowest order
  perturbation the T-matrix should then have a contribution proportional to
  <math|<wide|s|\<vect\>><rsub|e,1>\<cdot\><wide|s|\<vect\>><rsub|e,2>>
  evaluated for the initial and outgoing channels. The spin-independent and
  the <math|<wide|s|\<vect\>><rsub|e,1>\<cdot\><wide|s|\<vect\>><rsub|e,2>>-parts
  of the T-matrix should reproduce the correct triplet and singlet scattering
  lengths <math|a<rsub|S>> and <math|a<rsub|T>> in the limit of vanishing
  magnetic field and hyperfine energy. In this approximation, the low energy
  <math|i,j\<rightarrow\>k,l> transition matrix element then takes the form,

  <\equation>
    T<rsub|i,j;k,l>\<approx\><around*|(|<frac|4*\<pi\>*\<hbar\><rsup|2>|m>|)>*<around|\<langle\>|i,j*<around|\||<wide|a|\<bar\>>+a<rsub|->*<wide|s|\<vect\>><rsub|e,1>\<cdot\><wide|s|\<vect\>><rsub|e,2>|\|>*k,s|\<rangle\>><space|0.27em>,
  </equation>

  where <math|<wide|a|\<bar\>>> denotes the scattering length averaged over
  the singlet and triplet states,

  <\equation>
    <wide|a|\<bar\>>=<around*|(|<frac|3*a<rsub|T>+a<rsub|S>|4>|)><space|0.27em>,
  </equation>

  and where <math|a<rsub|->> represents the difference scattering length,

  <\equation>
    a<rsub|->=a<rsub|T>-a<rsub|S><space|0.27em><space|0.27em><space|0.27em>.
  </equation>

  This approximation is called the Degenerate Internal State (DIS)
  approximation. While it was primarily designed for calculating the two-body
  loss rate of atoms occupying specific hyperfine states in an external
  magnetic field. In that case, if the magnetic field is comparable to the
  hyperfine field, the above formula does not work very well as the
  wavefunction of the outgoing channel is not very well approximated by the
  zero energy wave function. We are not considering lossy channels, which
  will not be there if the hyperfine states are chosen carefully as described
  in the previous section. We are only considering the cases <math|i=k,j=l>
  or <math|i=l,j=k> with <math|i,j=\<uparrow\>,\<downarrow\>>, for which the
  incident and final channel wavefunctions have the same low energy value.
  Even in that case, the approximation is not always satisfied, particularly
  for atoms that have a naturally large scattering length at zero magnetic
  field, such as <math|<rsup|7>L*i> <cite|Stoof1> and <rsup|<math|123>>Cs
  <cite|Stoof2> and for higher magnetic field values. We expect that the
  treatment, may, however, yield a reasonable approximation for magnetic
  field values near such low magnetic field resonances as the <math|9*G>
  resonance observed in <math|<rsup|87>R*b> <cite|Sengstock>.

  In the DIS approximation, we can calculate the above defined scattering
  lengths explicitly

  <eqnarray|<tformat|<table|<row|<cell|a<rsub|\<uparrow\>>>|<cell|=<wide|a|\<bar\>>+a<rsub|->*<around*|\<langle\>|\<uparrow\>*\<uparrow\>*<around*|\||<math-bf|s><rsub|e,1>\<cdot\><math-bf|s><rsub|e,2>|\|>*\<uparrow\>*\<uparrow\>|\<rangle\>>,>>|<row|<cell|a<rsub|\<downarrow\>>>|<cell|=<wide|a|\<bar\>>+a<rsub|->*<around*|\<langle\>|\<downarrow\>*\<downarrow\>*<around*|\||<math-bf|s><rsub|e,1>\<cdot\><math-bf|s><rsub|e,2>|\|>*\<downarrow\>*\<downarrow\>|\<rangle\>>,>>|<row|<cell|a<rsub|D>>|<cell|=a<rsub|->*<around*|\<langle\>|\<uparrow\>*\<downarrow\>*<around*|\||<math-bf|s><rsub|e,1>\<cdot\><math-bf|s><rsub|e,2>|\|>*\<uparrow\>*\<downarrow\>|\<rangle\>>,>>|<row|<cell|a<rsub|x>>|<cell|=a<rsub|->*<around*|\<langle\>|\<uparrow\>*\<downarrow\>*<around*|\||<math-bf|s><rsub|e,1>\<cdot\><math-bf|s><rsub|e,2>|\|>*\<downarrow\>*\<uparrow\>|\<rangle\>>.<eq-number><label|ax>>>>>>

  in terms of the single electron spin matrix elements
  <math|<math-bf|s><rsub|e,\<uparrow\>>=<around*|\<langle\>|\<uparrow\><around*|\||<math-bf|s><rsub|e>|\|>*\<uparrow\>|\<rangle\>>>,
  <math|<math-bf|s><rsub|e,\<downarrow\>>=<around*|\<langle\>|\<downarrow\><around*|\||<math-bf|s><rsub|e>|\|>*\<downarrow\>|\<rangle\>>>,

  <eqnarray|<tformat|<table|<row|<cell|<around*|\<langle\>|\<uparrow\>*\<uparrow\>*<around*|\||<math-bf|s><rsub|e,1>\<cdot\><math-bf|s><rsub|e,2>|\|>*\<uparrow\>*\<uparrow\>|\<rangle\>>>|<cell|=<math-bf|s><rsub|e,\<uparrow\>>\<cdot\><math-bf|s><rsub|e,\<uparrow\>>,<eq-number>>>|<row|<cell|<around*|\<langle\>|\<downarrow\>*\<downarrow\>*<around*|\||<math-bf|s><rsub|e,1>\<cdot\><math-bf|s><rsub|e,2>|\|>*\<downarrow\>*\<downarrow\>|\<rangle\>>>|<cell|=<math-bf|s><rsub|e,\<downarrow\>>\<cdot\><math-bf|s><rsub|e,\<downarrow\>>,<eq-number>>>|<row|<cell|<around*|\<langle\>|\<uparrow\>*\<downarrow\>*<around*|\||<math-bf|s><rsub|e,1>\<cdot\><math-bf|s><rsub|e,2>|\|>*\<uparrow\>*\<downarrow\>|\<rangle\>>>|<cell|=<math-bf|s><rsub|e,\<uparrow\>>\<cdot\><math-bf|s><rsub|e,\<downarrow\>>.<eq-number>>>>>>

  The exchange spin matrix element involves spin-flip matrix elements of the
  type <math|<around*|\<langle\>|\<uparrow\><around*|\||<math-bf|s><rsub|e>|\|>*\<downarrow\>|\<rangle\>>=<math-bf|s><rsub|e,\<uparrow\>*\<downarrow\>>>,
  so that

  <\equation>
    <around*|\<langle\>|\<uparrow\>*\<downarrow\>*<around*|\||<math-bf|s><rsub|e,1>\<cdot\><math-bf|s><rsub|e,2>|\|>*\<downarrow\>*\<uparrow\>|\<rangle\>>=<math-bf|s><rsub|e,\<uparrow\>*\<downarrow\>>\<cdot\><math-bf|s><rsub|e,\<downarrow\>*\<uparrow\>><space|0.27em>.
  </equation>

  The spin-spin interaction parameters,

  <eqnarray|<tformat|<table|<row|<cell|a<rsub|o,I>>|<cell|=<wide|a|\<bar\>>+<frac|a<rsub|->|4>*<around*|(|<math-bf|s><rsub|e,\<uparrow\>>+<math-bf|s><rsub|e,\<downarrow\>>|)>\<cdot\><around*|(|<math-bf|s><rsub|e,\<uparrow\>>+<math-bf|s><rsub|e,\<downarrow\>>|)>,>>|<row|<cell|m<rsub|s,o>>|<cell|=<frac|2*\<pi\>*\<hbar\><rsup|2>|m>*a<rsub|->*<around*|(|<math-bf|s><rsub|e,\<uparrow\>>+<math-bf|s><rsub|e,\<downarrow\>>|)>\<cdot\><around*|(|<math-bf|s><rsub|e,\<uparrow\>>-<math-bf|s><rsub|e,\<downarrow\>>|)>,>>|<row|<cell|m<rsub|s,\<parallel\>>>|<cell|=<frac|2*\<pi\>*\<hbar\><rsup|2>|m>*a<rsub|->*<around*|(|<math-bf|s><rsub|e,\<uparrow\>>-<math-bf|s><rsub|e,\<downarrow\>>|)>\<cdot\><around*|(|<math-bf|s><rsub|e,\<uparrow\>>-<math-bf|s><rsub|e,\<downarrow\>>|)>,>>|<row|<cell|m<rsub|s,\<perp\>>>|<cell|=<frac|2*\<pi\>*\<hbar\><rsup|2>|m>*a<rsub|->*2<math-bf|s><rsub|e,\<uparrow\>*\<downarrow\>>\<cdot\><math-bf|s><rsub|e,\<downarrow\>*\<uparrow\>>,<eq-number>>>>>>

  then depend on the single electron spin-flip and spin matrix elements.

  As the electron spin expectation values depend on the external magnetic
  field, the interaction parameters do as well. To express the dependence
  explicitly, we cast the expressions in parametric form, choosing the
  electron spin inclination angles <math|\<theta\><rsub|\<uparrow\>>>,
  <math|\<theta\><rsub|\<downarrow\>>> of the `up' and `down' hyperfine
  states of Eq. (<reference|inclin>) as variable. For notational convenience
  we introduce external magnetic field-dependent spin factors
  <math|\<cal-S\><rsub|m,n><around|(|b|)>> with <math|m> and <math|n> equal
  to <math|+1> or <math|-1>,

  <eqnarray|<tformat|<table|<row|<cell|\<cal-S\><rsub|m,n><around*|(|b|)>>|<cell|=<around*|(|<math-bf|s><rsub|e,\<uparrow\>>+m*<wide|s|\<vect\>><rsub|e,\<downarrow\>>|)>\<cdot\><around*|(|<math-bf|s><rsub|e,\<uparrow\>>+n<math-bf|s><rsub|e,\<downarrow\>>|)>,>>|<row|<cell|>|<cell|=<around*|[|<frac|cos
  <around*|(|\<theta\><rsub|\<uparrow\>>|)>+m*cos
  <around*|(|\<theta\><rsub|\<downarrow\>>|)>|2>|]><around*|[|<frac|cos
  <around*|(|\<theta\><rsub|\<uparrow\>>|)>+n*cos
  <around*|(|\<theta\><rsub|\<downarrow\>>|)>|2>|]>.<eq-number>>>>>>

  In addition, we introduce the exchange spin factor,
  <math|\<cal-S\><rsub|x><around*|(|b|)>>, with
  <math|\<cal-S\><rsub|x><around*|(|b|)>=2<math-bf|s><rsub|e,\<uparrow\>*\<downarrow\>>\<cdot\><math-bf|s><rsub|e,\<downarrow\>*\<uparrow\>>>.
  To determine its value we make assumptions about how the
  <math|<around*|\||\<uparrow\>|\<rangle\>>> and
  <math|<around*|\||\<downarrow\>|\<rangle\>>> are chosen: We assume that
  their respective <math|m<rsub|f>>-values differ by one unit (if not,
  <math|<math-bf|s><rsub|e,\<uparrow\>*\<downarrow\>>=<math-bf|s><rsub|e,\<downarrow\>*\<uparrow\>>=0>)
  and we choose the <math|<around*|\||\<uparrow\>|\<rangle\>>> to have the
  highest <math|m<rsub|f>>. We also assume that both states are chosen among
  the states with Zeeman energy-curves that slope down at high magnetic
  fields (either the <math|f<rsup|->>-states or the stretched electron
  spin-down state, <math|<around*|\||f=f<rsup|+>,m<rsub|f>=-f<rsup|+>|\<rangle\>>>).
  In that case the <math|<around*|\||\<uparrow\>|\<rangle\>>>-state has the
  lower Zeeman energy. With this convention, we find

  <\equation>
    \<cal-S\><rsub|x><around*|(|b|)>=<around*|[|<frac|1+cos
    <around*|(|\<theta\><rsub|\<uparrow\>>|)>|2>|]><around*|[|<frac|1-cos
    <around*|(|\<theta\><rsub|\<downarrow\>>|)>|2>|]>,
  </equation>

  where the projection of the inclination angle varies with the external
  magnetic field as in Eq.<nbsp>(<reference|inclin>). In terms of the
  <math|\<cal-S\>>\Uspin factors, the effective pseudospin interaction
  parameters take on simple forms

  <eqnarray|<tformat|<table|<row|<cell|a<rsub|o,I>>|<cell|=>|<cell|<wide|a|\<bar\>>+<frac|a<rsub|->|4>*<space|0.27em>\<cal-S\><rsub|+,+><around*|(|b|)><space|0.27em>,>>|<row|<cell|m<rsub|s,o>>|<cell|=>|<cell|<frac|2*\<pi\>*\<hbar\><rsup|2>|m>*a<rsub|->*<space|0.27em>\<cal-S\><rsub|+,-><around*|(|b|)><space|0.27em>,>>|<row|<cell|m<rsub|s,\<parallel\>>>|<cell|=>|<cell|<frac|2*\<pi\>*\<hbar\><rsup|2>|m>*a<rsub|->*<space|0.27em>\<cal-S\><rsub|-,-><around*|(|b|)><space|0.27em>,>>|<row|<cell|m<rsub|s,\<perp\>>>|<cell|=>|<cell|<frac|2*\<pi\>*\<hbar\><rsup|2>|m>*a<rsub|->*<space|0.27em>\<cal-S\><rsub|x><around*|(|b|)><space|0.27em><space|0.27em>.<eq-number>>>>>>

  Note that all three moment parameters are proportional to the difference
  scattering length <math|a<rsub|->>.

  <\big-figure>
    <image|Fig3moment.eps|2.8in|||>

    <label|Fig3moment>
  </big-figure|The graph shows the magnetic field dependence
  (<math|b=B/B<rsub|h*f>>) of the moment parameters as calculated in the DIS
  approximation for <math|i=3/2>, <math|<around*|\||\<uparrow\>|\<rangle\>>=<around|\||f=1,m<rsub|f>=0|\<rangle\>>>
  and <math|<around|\||f=1,m<rsub|f>=-1|\<rangle\>>>. The full line shows
  <math|m<rsub|0>/<around*|(|\<pi\>*\<hbar\><rsup|2>/m|)>*a<rsub|->>, whereas
  the dashed line shows <math|2*<around*|(|m<rsub|\<parallel\>>-m<rsub|\<perp\>>|)>/<around*|(|\<pi\>*\<hbar\><rsup|2>/m|)>*a<rsub|->>,
  where <math|a<rsub|->> represents the difference of the zero magnetic field
  triplet (<math|a<rsub|T>>) and singlet (<math|a<rsub|S>>) scattering
  lengths, <math|a<rsub|->=a<rsub|T>-a<rsub|S>>. The dashed lines show the
  cosine of the electron spin projection angle of the `up' and `down'
  hyperfine states. The higher lying dashed line plots <math|cos
  <around*|(|\<theta\><rsub|\<downarrow\>>|)>>, the lower dashed line plots
  <math|cos <around*|(|\<theta\><rsub|\<uparrow\>>|)>>. It is near the
  <math|b=1> at which the down state electron spin changes its direction from
  parallel to antiparellel to the external magnetic field that
  <math|m<rsub|o>> changes sign and <math|<around|\||m<rsub|\<parallel\>>-m<rsub|\<perp\>>|\|>>
  is maximized.>

  Figure <reference|Fig3moment> plots the magnetic field dependence
  (<math|b=B/B<rsub|h*f>> as defined above Eq. (<reference|zeeman>)) of the
  relevant moment-parameters as calculated in the DIS approximation for the
  special case, <math|i=3/2>, <math|<around*|\||\<uparrow\>|\<rangle\>>=<around|\||f=1,m<rsub|f*f>=0|\<rangle\>>>
  and <math|<around|\||f=1,m<rsub|f>=-1|\<rangle\>>> (i.e., the second and
  third lowest Zeeman energy levels of Fig. <reference|Fig1boson>). The full
  line plots <math|m<rsub|o>>, whereas the dash-dotted line plots
  <math|2*<around|(|m<rsub|\<parallel\>>-m<rsub|\<perp\>>|)>>, both in units
  of <math|<around*|(|\<pi\>*\<hbar\><rsup|2>*a<rsub|->/m|)>>. For reference,
  note that the Ising form of the spin <math|<frac|1|2>> boson
  particle-particle interaction takes the form

  <\equation>
    V<around*|(|<wide|r|\<vect\>><rsub|1>,<wide|r|\<vect\>><rsub|2>|)>=\<delta\>*<around*|(|<wide|x|\<vect\>><rsub|1>-<wide|x|\<vect\>><rsub|2>|)>*<around*|[|\<lambda\><rsub|0>+m<rsub|o>*s<rsub|1,z>*s<rsub|2,z>+2*<around*|(|m<rsub|\<parallel\>>-m<rsub|\<perp\>>|)>*s<rsub|1,z>*s<rsub|2,z>|]>,
  </equation>

  where <math|\<lambda\><rsub|0>> denotes the spin-independent interaction
  strength in the Ising form, <math|\<lambda\><rsub|0>=<around|(|\<pi\>*\<hbar\><rsup|2>/m|)>*<around*|[|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>+2*a<rsub|u>|]>>.
  Note that <math|m<rsub|o>> changes sign near <math|b=0.535>, so that there
  exists an external magnetic field strength at which the spin-independent
  effective short-range magnetic field carried by the interacting particles
  can be made to vanish (without having to take recourse to a Feshbach
  resonance). The Ising spin-spin interaction coefficient does not change
  sign but it's magnitude is maximized at a magnetic field
  <math|b\<sim\>1.75>. The precise values of the magnetic fields at which the
  interaction parameters exhibit this behavior may be different, but we
  expect the DIS-approximation to give the correct qualitative behavior even
  if the DIS-approximation is not expected to be accurate at higher magnetic
  field values.

  <section|A controllable <math|N> boson quantum magnet>

  The spin-spin forms of the effective inter-particle interactions reveal the
  analogy with magnetic systems. As an illustration we consider a specific
  system that promises a particularly powerful and interesting simulation of
  a quantum magnet: N indistinguishable bosons occupying two hyperfine spin
  states <math|<around*|\||\<uparrow\>|\<rangle\>>>,
  <math|<around*|\||\<downarrow\>|\<rangle\>>>, confined by a tight spatial
  potential (which could be a single well of an optical lattice). We assume
  that both <math|<around*|\||\<uparrow\>|\<rangle\>>> and
  <math|<around*|\||\<downarrow\>|\<rangle\>>> experience the same trapping
  potential <math|V<rsub|\<uparrow\>><around*|(|<wide|x|\<vect\>>|)>=V<rsub|\<downarrow\>><around*|(|<wide|x|\<vect\>>|)>=V<rsub|T><around*|(|<wide|x|\<vect\>>|)>>
  of single-particle ground state <math|\<chi\><rsub|T><around*|(|<wide|x|\<vect\>>|)>>
  and single particle ground state energy <math|e<rsub|T>>. When
  <math|e<rsub|T>> exceeds all other energy-per-particle values and the
  system relaxed to its motional ground state, all of the <math|N> bosons
  occupy the <math|\<chi\><rsub|T>>-orbital and the spatial degrees of
  freedom are `frozen', allowing only spin dynamics. We also assume that the
  <math|<around*|\||\<uparrow\>|\<rangle\>>> and
  <math|<around*|\||\<downarrow\>|\<rangle\>>> experience a coherent
  two-photon Raman coupling which can be effected by pulses of near-resonant
  lasers (or by means of an oscillating magnetic field). The resonant Raman
  coupling also introduces a detuning <math|\<epsilon\>> which acts as an
  effective energy difference between <math|<around*|\||\<uparrow\>|\<rangle\>>>
  and <math|<around*|\||\<downarrow\>|\<rangle\>>> and the Raman coupling is
  described by a term

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|<big|sum><rsub|j=1><rsup|N><around*|[|-E<rsub|R><around*|(|t|)>*<around*|(|<around*|\||\<downarrow\>|\<rangle\>><rsub|j>*<space|0.27em><rsub|j><around*|\<langle\>|\<uparrow\>*<around*|\||+|\|>*\<uparrow\>|\<rangle\>><rsub|j><space|0.27em><rsub|j><around*|\<langle\>|\<downarrow\>|\|>|)>+<frac|\<epsilon\>|2>*<around*|(|<around*|\||\<uparrow\>|\<rangle\>><rsub|j>*<space|0.27em><rsub|j><around*|\<langle\>|\<uparrow\>*<around*|\||-|\|>*\<downarrow\>|\<rangle\>><rsub|j><space|0.27em><rsub|j><around*|\<langle\>|\<downarrow\>|\|>|)>|]>>>|<row|<cell|>|<cell|=-2*E<rsub|R><around*|(|t|)>*<big|sum><rsub|j=1><rsup|N><space|0.27em>s<rsub|j,x><space|0.27em>+\<epsilon\>*<big|sum><rsub|j=1><rsup|N><space|0.27em>s<rsub|j,z>,<eq-number>>>>>>

  in the Hamiltonian. In the above expression, <math|E<rsub|R>> denotes the
  Rabi-coupling energy which varies in time if the coupling is caused by a
  pulse.

  The premise of a trapping potential sufficiently tight to freeze out the
  spatial degrees of freedom translates into an <math|N>-particle
  wavefunction of the type

  <\equation>
    \<Psi\><around*|(|<wide|r|\<vect\>><rsub|1>,<wide|r|\<vect\>><rsub|2>,....,<wide|r|\<vect\>><rsub|N>|)>=\<chi\><rsub|T><around*|(|<wide|x|\<vect\>><rsub|1>|)>*\<chi\><rsub|T><around*|(|<wide|x|\<vect\>><rsub|2>|)>...*\<chi\><rsub|T><around*|(|<wide|x|\<vect\>><rsub|N>|)>*<space|0.27em><around*|\||S<rsup|N>*<around*|(|<wide|s|\<vect\>><rsub|1>,<wide|s|\<vect\>><rsub|2>,...*<wide|s|\<vect\>><rsub|N>|)>|\<rangle\>>,
  </equation>

  where <math|<around*|\||S<rsup|N>|\<rangle\>>> denotes the spin state of
  the <math|N>-boson system. By virtue of permutation symmetry \U the full
  wavefunction has to be even under permutation of the full
  <math|<wide|r|\<vect\>>=<around*|(|<wide|x|\<vect\>>,<wide|s|\<vect\>>|)>>
  coordinates of any pair of particles \U the
  <math|<around*|\||S<rsup|N>|\<rangle\>>> spin state is required to be even
  with respect to the permutation of any pair of spin variables <math|i> and
  <math|j>. This condition limits the spin states to the manifold of maximal
  spin magnitude. Specifically, if we introduce the total spin operator,
  <math|<math-bf|S><rsup|N>=<big|sum><rsub|j=1><rsup|N><math-bf|s><rsub|j>>,
  then <math|<math-bf|S><rsup|N>\<cdot\><math-bf|S><rsup|N><around*|\||S<rsup|N>|\<rangle\>>=<frac|N|2>*<around*|(|<frac|N|2>+1|)><around*|\||S<rsup|N>|\<rangle\>>>,
  corresponding to a total spin magnitude <math|<frac|N|2>>, i.e., all
  pseudo-spins aligned. Hence, the spin state is a linear combination of
  <math|S<rsup|N>=<frac|N|2>> states of total spin projection
  <math|M<rsub|S>=-<frac|N|2>,...,<frac|N|2>>,
  <math|<around*|\||S<rsup|N>=<frac|N|2>,M<rsub|S>|\<rangle\>>> with
  <math|S<rsub|z><rsup|N>*<around*|\||S<rsup|N>=<frac|N|2>,M<rsub|S>|\<rangle\>>=M<rsub|S>*<around*|\||S<rsup|N>=<frac|N|2>,M<rsub|S>|\<rangle\>>>.
  The <math|M<rsub|S>=<frac|N|2>> is an <math|N>-spin stretched state.

  <\equation>
    <around*|\||S<rsup|N>=<frac|N|2>,M<rsub|S>=<frac|N|2>|\<rangle\>>=<around*|\||\<uparrow\>|\<rangle\>><rsub|1><space|0.27em><around*|\||\<uparrow\>|\<rangle\>><rsub|2><space|0.27em>...<space|0.27em><around*|\||\<uparrow\>|\<rangle\>><rsub|N>,
  </equation>

  In deriving the expression for the total energy <math|E> of the <math|N>
  interacting boson system, we use the Ising spin-spin form of the
  short-range particle-particle interaction. Integrating out the position
  variables explicitly, we encounter a volume <math|v>, the `trap volume'
  that characterizes the `tightness' of the confining <math|V<rsub|T>>,

  <\equation>
    <frac|1|v>=<big|int>d<rsup|3>*<wide|x|\<vect\>><space|0.27em><around|\||\<chi\><rsub|T><around*|(|<wide|x|\<vect\>>|)>|\|><rsup|4><space|0.27em>,
  </equation>

  For instance, the spin-independent interaction energy per particle,
  <math|e<rsub|0>>, is inversely proportional to the trap volume <math|v> and
  proportional to the spin-independent interaction strength in the Ising
  form, <math|\<lambda\><rsub|0>=<around*|(|4*\<pi\>*\<hbar\><rsup|2>/m|)><around*|[|<frac|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>+2*a<rsub|u>|4>|]>>,

  <\equation>
    e<rsub|0>=<frac|\<lambda\><rsub|0>|v>.
  </equation>

  The analogous spin-interaction energies per particle are given by the
  expressions

  <eqnarray|<tformat|<table|<row|<cell|\<epsilon\><rsub|o>>|<cell|=<space|0.27em><frac|m<rsub|o>|v><space|0.27em>=<frac|4*\<pi\>*\<hbar\><rsup|2>|m><around*|(|<frac|a<rsub|\<uparrow\>>-a<rsub|\<downarrow\>>|2>|)><frac|1|v>,>>|<row|<cell|\<epsilon\><rsub|I>>|<cell|=<frac|2*<around*|(|m<rsub|\<parallel\>>-m<rsub|\<perp\>>|)>|v><space|0.27em>=<space|0.27em><frac|4*\<pi\>*\<hbar\><rsup|2>|m>*<around*|(|a<rsub|\<uparrow\>>+a<rsub|\<downarrow\>>-2*a<rsub|u>|)>*<frac|1|v>.<eq-number>>>>>>

  The total many-body energy, <math|E>, takes the form

  <eqnarray|<tformat|<table|<row|<cell|E>|<cell|=N*<around*|[|e<rsub|T>+<frac|<around*|(|N-1|)>|2>*e<rsub|0>|]>+<around*|(|N-1|)>*\<epsilon\><rsub|o>*<big|sum><rsub|j=1><rsup|N><around*|\<langle\>|S<rsup|N><around*|\||s<rsub|j,z>|\|>*S<rsup|N>|\<rangle\>>>>|<row|<cell|>|<cell|+<frac|\<epsilon\><rsub|I>|2>*<big|sum><rsub|i\<neq\>j><around*|\<langle\>|S<rsup|N>*<around*|\||s<rsub|j,z>*s<rsub|j,z>|\|>*S<rsup|N>|\<rangle\>>+<big|sum><rsub|j=1><rsup|N><around*|\<langle\>|S<rsup|N><around*|\||<around*|(|-2*\<epsilon\><rsub|R>*s<rsub|j,x>+\<epsilon\>*s<rsub|j,z>|)>|\|>*S<rsup|N>|\<rangle\>>,<eq-number>>>>>>

  so that the integration over the position variable with short-range
  interactions maps the <math|N> spin-1/2 boson problem into that of <math|N>
  1/2 spins coupled via an infinite range spin-spin interaction. By adding
  and subtracting

  <\equation>
    <frac|\<epsilon\><rsub|I>|2>*<big|sum><rsub|j=1><rsup|N>s<rsub|j,z>*s<rsub|j,z>=<frac|N*\<epsilon\><rsub|I>|8>,
  </equation>

  we cast the Hamiltonian in terms of the total spin-operator
  <math|<math-bf|S><rsup|N>=<big|sum><rsub|j=1><rsup|N><math-bf|s><rsub|j>>.
  We also define effective magnetic fields that are <math|c> numbers,

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|H><rsub|o>=<around*|(|N-1|)><math-bf|z>\<epsilon\><rsub|o>>>|<row|<cell|<math-bf|H><rsub|R>=-2*\<epsilon\><rsub|R><math-bf|x>+\<epsilon\><math-bf|z><eq-number>>>>>>

  The energy <math|E>, up to an unimportant shift,
  <math|E<rprime|'>=E-N*<around*|[|e<rsub|T>+<around*|(|N-1|)>*<frac|e<rsub|0>|2>|]>-<frac|N*\<epsilon\><rsub|I>|8>>,
  then takes the form

  <\equation>
    E<rprime|'>=<around*|\<langle\>|S<rsup|N>*<around*|\||<math-bf|S><rsup|N>\<cdot\><around*|(|<math-bf|H><rsub|o>+<math-bf|H><rsub|R>|)>+<frac|\<epsilon\>|2>*S<rsub|z><rsup|N>*S<rsub|z><rsup|N>|\|>*S<rsup|N>|\<rangle\>>,<label|spinh>
  </equation>

  reminiscent of the Hamiltonian of magnetic single domain grains with
  anisotropic spin-spin interactions <cite|gun>. Chudnovsky and Gunther had
  pointed out that the anisotropy can set conditions under which we expect
  macroscopic quantum tunneling: sufficiently strong exchange interactions
  force the individual spins to align into a macroscopic spin vector, the
  anisotropy can give local energy minima corresponding to two distinct
  directions of the macroscopic spin and quantum mechanically, the
  macroscopic spin can travel through a classically forbidden region giving
  tunneling although the expected rate for such processes are exponentially
  suppressed with the number of spins. In the <math|N>-boson quantum magnet,
  the alignment is enforced by permutation symmetry, the anisotropy caused by
  the Ising (or XY) nature of the effective inter-particle interactions and
  the number of bosons can, in principle, be controlled experimentally.

  We recognize the operator in the spin bracket of Eq. (<reference|spinh>) as
  the spin Hamiltonian <math|<wide|H|^>>. The Heisenberg equation of motion
  for the total spin operator,

  <\equation>
    i*\<hbar\>*<frac|d<math-bf|S><rsup|N>|d*t>=<around*|[|<math-bf|S><rsup|N>,<wide|H|^>|]><rsub|->=i<math-bf|S><rsup|N>\<times\><around*|[|<math-bf|H><rsub|o>+<math-bf|H><rsub|R>|]>+i*\<epsilon\><rsub|I><math-bf|S><rsup|N><rsub|\<parallel\>><around*|(|<math-bf|S><rsup|N>\<cdot\><math-bf|z>|)><space|0.27em>,
  </equation>

  where <math|<math-bf|S><rsup|N><rsub|\<parallel\>>> denotes the part of the
  total spin vector that points in the direction of the magnetic field,
  <math|<math-bf|S><rsup|N><rsub|\<parallel\>>=<math-bf|z><space|0.27em><around*|(|<math-bf|S><rsup|N>\<cdot\><math-bf|z>|)>>,
  yields an Ehrenfest type of equation for the total spin expectation value
  if we take its expectation value. We can write the resulting equation as a
  Landau-Lifshitz equation (without damping term) <cite|landau>,

  <\equation>
    <frac|d|d*t><around|\<langle\>|<with|math-font-family|bf|S<rsup|N>>|\<rangle\>>=<frac|1|\<hbar\>>*<around|\<langle\>|<math-bf|S><rsup|N>\<times\><math-bf|H><rsub|t*o*t*a*l>|\<rangle\>><space|0.27em><space|0.27em>,
  </equation>

  where the total magnetic field <math|<math-bf|H><rsub|t*o*t*a*l>> includes
  the Raman coupling effective field, the the effective, spin-independent
  short-range field carried by the other particles and the contribution
  caused by the Ising spin-spin interactions,

  <\equation>
    <math-bf|H><rsub|t*o*t*a*l>=<math-bf|H><rsub|o>+<math-bf|H><rsub|R>+\<epsilon\><rsub|I><math-bf|S><rsup|N><rsub|\<parallel\>><around*|(|<math-bf|S><rsub|N>\<cdot\><math-bf|z>|)><space|0.27em>.
  </equation>

  In the absence of Raman coupling <math|<math-bf|H><rsub|R>=0> the total
  magnetic field <math|<math-bf|H><rsub|t*o*t*a*l>> points in the z-direction
  and all the spin expectation vector can do is precess around the
  z-direction. In fact, the derivative of the expectation value of any power
  of <math|S<rsup|N><rsub|z>> vanishes so that the conservation of up and
  down particles ensures that the distribution of the spin up and spin down
  particles will remain constant in time precluding collective tunneling of
  the spin in the absence of Raman coupling. A Raman pulse can then precisely
  control and initiate the macroscopic quantum tunneling while leaving the
  other assumptions and parameters of the system untouched. In addition to
  tunneling, the ground state of the system can be a superposition of two
  distinct states in each of which the total spin points in different
  directions. That Raman-coupled (or Josephson-coupled) two-component BEC
  systems can take on macroscopic Schrodinger cat states was pointed out in
  <cite|Cirac> and worked out in <cite|Gordon> \U we simply determine the
  interaction parameters and indicate how these can be controlled. The Raman
  control provides an important advantage to the N-boson quantum magnet over
  the double-well proposals for realizing macroscopic quantum tunneling and
  creating macrocopic Schrodinger cat states. Varying the potential barrier
  in a double well system to control the tunneling can also render the
  two-state approximation invalid and lead to unwanted excitations.

  Observing the coherent oscillations of the total spin that is quantum
  tunneling can also test fundamental aspects of quantum mechanics (against
  macroscopic realism) by verifying Legget-Garg inequalities <cite|legg2>. In
  addition, the <math|N>-boson quantum magnet spin dynamics can also explore
  spin squeezing, non-classical quantum evolution near unstable trajectories
  <cite|vardi> and, when the Ising interaction is eliminated by a Feshbach
  resonance, realize the Burnett-Holand proposal for Heisenberg limited
  interferometry <cite|Burnett> by using the Raman pulse as a beam-splitter.
  These connections become obvious using the spin-spin form of the
  inter-particle interactions which also reveal the control that routine cold
  atom knobs such as the intensity of the confining potential, the detuning
  of the Raman coupling pulse and the magnetic field of a Feshbach resonance
  can exercise.

  <section|Conclusions>

  In conclusion, we described the effective spin-dependent interactions of
  ultra-cold alkali atoms occupying two distinct hyperfine states in an
  external magnetic field. The magnetic field lifts the degeneracy of the
  atomic Zeeman levels and permits the selection of two hyperfine states to
  act as the effective `spin-up' and `spin-down' states of the particles so
  the atoms can mimic the behavior of magnetic spin-<math|<frac|1|2>>
  particles. We described the spin-dependent effective interaction as a
  spin-spin interaction. The form of the effective spin-spin interaction
  depends explicitly on the quantum statistics of the interacting particles.
  As a consequence of the zero-range nature of the interaction, the
  interaction of spin-<math|<frac|1|2>> bosons can be described as an Ising
  or, alternatively, as an <math|X*Y>-coupling. The parameters of the
  spin-spin interaction depend on the scattering lengths of the relevant
  binary alkali atom collision channels in the external magnetic field. For
  relatively low values of the magnetic field (sufficiently large to cause a
  Zeeman level splitting that permits the selection of two hyperfine levels)
  we calculated the parameters as a function of the external magnetic field
  in the Degenerate Internal State (DIS) approximation. We illustrated the
  advantage of the spin-spin interaction form by mapping the system of N
  spin-<math|<frac|1|2>> bosons in a tight trapping potential on that of N
  spin-<math|<frac|1|2>> spins coupled via an infinite range interaction. The
  explicit expressions reveal which parameters of the spin Hamiltonian can be
  controlled and how. The spin Hamiltonian also suggests that the N-boson
  quantum magnet provides an intriguing laboratory for the exploration of
  fundamental quantum studies. The list of promising uses include the study
  of collective quantum spin tunneling (which can be used for testing
  fundamental aspects of quantum mechanics), the controlled observation and
  utilization of spin squeezing and the creation and study of highly
  non-classical states.

  <section|Acknowledgments>

  The work of one of the authors, E.T., was supported by the Los Alamos
  Laboratory Directed Research and Development (LDRD) program.

  <section*|References>

  <\thebibliography|99>
    <bibitem|Chuang>Michael A. Nielsen and Isaac L. Chuang,
    <with|font-shape|italic|Quantum Computation and Quantum Information>,
    (Cambridge University Press, Cambridge, 2000).

    <bibitem|Sachdevpaper>S. Sachdev, Quantum magnetism and criticality,
    Nature Physics <with|font-series|bold|4>, 173 (2008).

    <bibitem|Sachdevbook>Subir Sachdev, <with|font-shape|italic|Quantum Phase
    Transitions>, (Cambridge University Press, Cambridge, 2000).

    <bibitem|quantumscaling>M. A. Continento, Phys. Rep.
    <with|font-series|bold|239>, 179 (1994).

    <bibitem|MCSLSSK99>D. E. Miller, J. K. Chin, C. A. Stan, Y. Liu, W.
    Setiawan, C. Sanner, and W. Ketterle, Phys. Rev. Lett.
    <with|font-series|bold|99>, 070402 (2007).

    <bibitem|PSKJH05>G. B. Partridge, K. E. Strecker, R. I. Kamar, M. W.
    Jack, and R. G. Hulet, Phys. Rev. Lett. <with|font-series|bold|95>,
    020404 (2005).

    <bibitem|PWLH07>G. B. Partridge, Wenhui Li, Y. A. Liao, and R. G. Hulet,
    J. of Low Temp. Phys. <with|font-series|bold|148>, (3-4) 323 (2007).

    <bibitem|AGIM02>A. P. Albu1, S. A. Gardiner, F. Illuminati, and M.
    Wilkens, Phys. Rev. A <with|font-series|bold|65>, 053607 (2002).

    <bibitem|EV02>D. V. Efremov and L. Viverit, Phys. Rev. B
    <with|font-series|bold|65>, 134519 (2002).

    <bibitem|XGLW03>Gao Xianlong, F. Gleisberg, F. Lochmann, and W.
    Wonneberger, Phys. Rev. A <with|font-series|bold|67>, 023610 (2003).

    <bibitem|A06>Sadhan K Adhikari, New J. of Phys.
    <with|font-series|bold|8>, 258 (2006).

    <bibitem|KMJT06>T Koponen, J-P Martikainen , L M Jensen, P Trm, New J.
    of Phys. <with|font-series|bold|8>, 179 (2006).

    <bibitem|PW07>C.-H. Pao and Shin-Tza Wu, Phys. Rev. A
    <with|font-series|bold|76>, 053621 (2007).

    <bibitem|MOYDOM08>M. Machida, M. Okumura, S. Yamada, T. Deguchi, Y.
    Ohashi, and H. Matsumoto, Phys. Rev. B <with|font-series|bold|78>, 235117
    (2008).

    <bibitem|KSSS09>W. Ketterle, Y. Shin Y, A. Schirotzek, and C. H. Schunk,
    J. Phys.: Condens. Matter, <with|font-series|bold|21>, 164206 (2009).

    <bibitem|BDNJ09>George Bertsch, Jacek Dobaczewski, Witold Nazarewicz, and
    Junchen Pei, Phys. Rev. A <with|font-series|bold|79>, 043602 (2009).

    <bibitem|SSSK08>Yong-il Shin, Christian H. Schunck, Andr Schirotzek and
    Wolfgang Ketterle, Nature, <with|font-series|bold|451> (7179), 689
    (2008).

    <bibitem|SSSK208>Andr Schirotzek, Yong-il Shin, Christian H. Schunck,
    and Wolfgang Ketterle, Phys. Rev. Lett. <with|font-series|bold|101>,
    140403 (2008).

    <bibitem|PWLHHS06>G. B. Partridge, Wenhui Li, Y. A. Liao, R. G. Hulet, M.
    Haque, and H. T. C. Stoof, Phys. Rev. Lett. <with|font-series|bold|97>,
    190407 (2006).

    <bibitem|LPLH09>Wenhui Li, G. B. Partridge, Y. A. Liao, and R. G. Hulet,
    Int. J. Mod. Phys. B <with|font-series|bold|23> (15), 3195 (2009).

    <bibitem|BARJCDG04>M. Bartenstein, A. Altmeyer, S. Riedl, S. Jochim, C.
    Chin, J. Hecker Denschlag, and R. Grimm, Phys. Rev. Lett.
    <with|font-series|bold|92>, 203201 (2004).

    <bibitem|WRAKSDG07>M. J. Wright, S. Riedl, A. Altmeyer, C. Kohstall, E.
    R. Snchez Guajardo, J. Hecker Denschlag, and R. Grimm, Phys. Rev. Lett.
    <with|font-series|bold|99>, 150403 (2007).

    <bibitem|Legg>S. Ashhab, and A. J. Leggett, Phys. Rev. A,
    <with|font-series|bold|68>, 063612 (2002).

    <bibitem|Ketterle1>Gyu-Boong Jo, Ye-Ryoung Lee, Jae-Hoon Choi, Caleb A.
    Christensen, Tony H. Kim, Joseph H. Thywissen, David E. Pritchard, and
    Wolfgang Ketterle, Science, <with|font-series|bold|325> (5947), 1521
    (2009).

    <bibitem|Eddy>E. Timmermans, Phys. Rev. Lett. <with|font-series|bold|81>,
    5718 (1998).

    <bibitem|Wiemel1>M. R. Matthews, B. P. Anderson, P. C. Haljan, D. S.
    Hall, C. E. Wieman, and E. A. Cornell, Phys. Rev. Lett.
    <with|font-series|bold|83> (13), 2498 (1999).

    <bibitem|Stamper>R. W. Cherng, V. Gritsev, D. M. Stamper-Kurn, and E.
    Demler, Phys. Rev. Lett. <with|font-series|bold|100>, 180404 (2008).

    <bibitem|Wiemel2>E. Hodby, S. T. Thompson, C. A. Regal, M. Greiner, A. C.
    Wilson, D. S. Jin, E. A. Cornell1, and C. E. Wieman, Phys. Rev. Lett.
    <with|font-series|bold|94>, 120402 (2005).

    <bibitem|Wiemel22>D. S. Hall, M. R. Matthews, C. E. Wieman, and E. A.
    Cornell, Phys. Rev. Lett. <with|font-series|bold|81>, 1543 (1998).

    <bibitem|Boud1>J. M. V. A. Koelman, H. T. C. Stoof, B. J. Verhaar, and J.
    T. M. Walraven, Phys. Rev. Lett., <with|font-series|bold|59>, 676 (1987).

    <bibitem|Dowl>Hwang Lee, P. Kok, and J. P. Dowling, J. Mod. Opt.,
    <with|font-series|bold|49>, 2325 (2002).

    <bibitem|Foote>Christopher J. Foot, <with|font-shape|italic|Atomic
    Physics>, (Oxford University Press, Oxford, 2005).

    <bibitem|DeBenedetti>Sergio DeBenedetti, <with|font-shape|italic|Nuclear
    interactions>, (R. E. Krieger Pub. Co., Huntington, N.Y., 1974).

    <bibitem|Bloch>F. Bloch, Z. Phys. <with|font-series|bold|61>, 206 (1930).

    <bibitem|Stoof1>M. Houbiers, H. T. C. Stoof, W. I. McAlexander, and R. G.
    Hulet, Phys. Rev. A <with|font-series|bold|57> (3) , R1497 (1997).

    <bibitem|Stoof2>H. T. C. Stoof, Phys. Rev. A <with|font-series|bold|49>
    (5), 3824 (1993).

    <bibitem|Sengstock>M Erhardt et al., Phys. Rev. A,
    <with|font-series|bold|69>, 032705 (2004).

    <bibitem|gun>E. M. Chudnovsky and L. Gunther, Phys. Rev. Lett.,
    <with|font-series|bold|60>, 661 (1988).

    <bibitem|landau>L. D. Landau, and E. M. Lifshitz, Phys. Z. Sowietunion,
    <with|font-series|bold|8>, 153 (1935).

    <bibitem|Cirac>J. I. Cirac, M. Lewenstein, K. Molmer, and P. Zoller,
    Phys. Rev. A, <with|font-series|bold|57>, 1208 (1998).

    <bibitem|Gordon>D. Gordon, and C. M. Savage, Phys. Rev. A,
    <with|font-series|bold|59>, 4623 (1999).

    <bibitem|legg2>A. J. Leggett, and A. Garg, Phys. Rev. Lett.,
    <with|font-series|bold|54>, 857 (1985).

    <bibitem|vardi>A. Vardi, and J. R. Anglin, Phys. Rev. Lett.,
    <with|font-series|bold|86>, 568 (2001).

    <bibitem|Burnett>M. Holland, and K. Burnett, Phys. Rev. Lett.,
    <with|font-series|bold|71>, 1355 (1993).
  </thebibliography>
</body>