<TeXmacs|1.99.7>

<style|<tuple|aps|std-latex>>

<\body>
  <doc-data|<doc-title|Chemical pathways in ultracold reactions of SrF
  molecules>|<doc-author|<author-data|<author-name|Edmund R.
  Meyer<footnotemark*|1>>>>|<doc-author|<author-data|<author-name|John L.
  Bohn>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    We present a theoretical investigation of the chemical reaction SrF + SrF
    <math|\<rightarrow\>> products, focusing on reactions at ultralow
    temperatures. We find that bond swapping, SrF + SrF <math|\<rightarrow\>>
    Sr<rsub|<math|2>> + F<rsub|<math|2>>, is energetically forbidden at these
    temperatures. Rather, the only energetically allowed reaction is SrF +
    SrF <math|\<rightarrow\>> SrF<rsub|<math|2>> + Sr, and even then only
    singlet states of the SrF<rsub|<math|2>> trimer can form. A calculation
    along a reduced reaction path demonstrates that this abstraction reaction
    is barrierless, and proceeds by one SrF molecule ``handing off'' a
    fluorine atom to the other molecule.
  </abstract>>

  <section|Introduction>

  After many years of experimental effort, chemical reaction dynamics has now
  entered the cold and ultracold regime. Robust techniques such as buffer-gas
  cooling<nbsp><cite|Campbell09_book> and Stark
  deceleration<nbsp><cite|Meerakker09_book> have pushed the energy resolution
  of molecular beam techniques down to the mK level, resulting in new probes
  of chemical dynamics <cite|Scharfenberg10_PCCP|Hummon10_preprint|ye10|Parazzoli10_preprint>.
  Extending the low-energy limit even farther, coherent optical techniques
  have produced samples of alkali dimers in their absolute ground state, at
  temperatures in the 1-100 <math|\<mu\>>K
  range<nbsp><cite|rbcspaper|kkniscience|Danzl10_NatP|tokyoKRb>. These
  ultracold molecules are so exquisitely sensitive to comparatively weak
  influences, that chemistry can be studied and controlled by exploiting
  quantum statistics <cite|Ospelkaus10_Science>, electric fields
  <cite|Ni10_Nature>, and confinement in optical lattices
  <cite|Gorshkov09_PRL|Quemener10_PRA|Micheli10_PRL|Miranda10_preprint>.

  With these new capabilities naturally come questions of what can be learned
  about chemical reaction dynamics under these novel circumstances. The
  <with|font-shape|italic|manipulation> of chemical reactions by external
  electric and magnetic fields relies heavily on the behavior of long-range
  physics, where the molecules exert, say, dipolar forces on one another, but
  are too far away from one another to react. Indeed, the theoretical
  analysis of the reaction 2KRb <math|\<rightarrow\>> K<rsub|<math|2>> +
  Rb<rsub|<math|2>>, observed and studied at JILA, took this point of view,
  by treating the actual reaction as a nearly perfectly absorbing \Pblack
  box,\Q which removed the molecules when they got close enough together, but
  without regard for what exactly happened to them<nbsp><cite|iqbj10|ij10>.

  Vice versa, to <with|font-shape|italic|understand> more about chemical
  dynamics from these experiments would presumably require a scattering
  simulation on a complete four-body potential energy surface (PES) for the
  K-K-Rb-Rb system, which does not yet exist. In very recent work, however,
  Byrd <with|font-shape|italic|et al.> have described the main salient
  features of this surface<nbsp><cite|byrd10>. First, along its main reaction
  coordinate, the reaction presents no energetic barrier to reaction
  (consistent with the high reaction rates observed at JILA). Second, its
  transition state, at the borderline between reactants and products,
  represents a T-geometry characteristic of an insertion reaction, wherein a
  K atom from one molecule inserts itself between the K and Rb of the other.
  This circumstance suggests that the reaction proceeds by a complicated
  four-body dance of the involved atoms, which may be revealed at ultralow
  temperatures by characterizing the resonant states of the complex.
  Observing these transition-state resonances and interpreting their
  influence in chemical reactions is a longstanding goal of physical
  chemistry, and one in which the high energy resolution of ultracold
  molecules may be a great help.

  Set against this backdrop, it would also be useful to explore other
  molecules reacting at ultralow temperatures, to gain additional insight
  into what can be learned. To this end, the SrF molecule is an appealing
  candidate, and the one with which we deal in this article. SrF is a prime
  example of a class of molecules that have been identified as amenable to
  direct laser cooling from a beam<nbsp><cite|demille09>, and in fact laser
  cooling has been recently demonstrated<nbsp><cite|Shuman10_Nature>. It is
  quite polar (dipole moment <math|\<approx\>1.4> Debye), so that electric
  field manipulation is a possibility. Moreover, it has an open-shell
  <math|<rsup|2>\<Sigma\>> ground state that gives it a magnetic moment as
  well. This circumstance opens opportunities such as trapping the molecules
  magnetically, while manipulating their interactions
  electrically<nbsp><cite|hudson07>.

  In this article we explore the possibility and mechanisms for chemical
  reactions of SrF molecules at ultralow temperatures. We make several
  observations. First, the exchange reaction

  <\equation>
    <label|e:bs>2<nbsp><math-up|SrF>\<rightarrow\><math-up|Sr><rsub|2>+<math-up|F><rsub|2>+\<Delta\>*E<rsub|<math-up|ex>>
  </equation>

  is energetically disallowed, as might be expected for a reaction that turns
  two ionic bonds into two covalent ones. Therefore, the reaction, if it
  happens at all, must proceed by an abstraction reaction in which an atom
  jumps from one molecule to the other. This is exactly the opposite
  situation from what occurs in KRb, where the exchange is the only possible
  reaction, and then only just barely<nbsp><cite|byrd10|hutson10|meyer10>

  Second, we find that the Sr-abstraction reaction

  <eqnarray|<tformat|<table|<row|<cell|2<math-up|SrF>>|<cell|\<rightarrow\><math-up|Sr><rsub|2><math-up|F>+<math-up|F>+\<Delta\>*E<rsub|<math-up|trimer>><rprime|'><eq-number><label|e:trimer1>>>>>>

  cannot occur at low temperature, whereas the F-abstraction

  <eqnarray|<tformat|<table|<row|<cell|2<math-up|SrF>>|<cell|\<rightarrow\><text|<with|font-family|rm|SrF>><rsub|2>+<math-up|Sr>+\<Delta\>*E<rsub|<math-up|trimer>><eq-number><label|e:trimer2>>>>>>

  <with|font-shape|italic|can> occur, as it produces the deeply bound
  SrF<rsub|<math|2>> trimer. Moreover, this reaction, which is barrierless,
  can only occur in the singlet channel, i.e., only if the reaction takes
  place on the PES with total electronic spin <math|S=0>. Therefore, chemical
  reactions are expected to occur at quite high rates for unpolarized SrF
  molecules, while they should be strongly suppressed for spin-polarized SrF,
  which scatter primarily on the triplet surface. Spin-rotation couplings
  will ensure that this suppression is not complete<nbsp><cite|krems07>.
  Nevertheless, one must be mindful of any opportunity to suppress inelastic
  collisions, as they can easily destabilize the gas and derail attempts to
  exploit the molecules for many-body physics applications.

  Third, we describe the basic physics of the abstraction process by looking
  at a restricted version of the four-body PES. We find that the F end of one
  SrF molecule approaches the Sr end of the other, as dictated by the
  dipole-dipole interaction between molecules. Next, the F atom is handed off
  from one molecule to the other, and the free Sr goes off by itself. By this
  hand-off mechanism it is possible that the reaction proceeds without
  forming a resonant complex, and that its interpretation from ultracold
  collision data may be more straightforward than the complete re-arrangement
  necessary in reactions of KRb. In any event, complementary dynamics should
  give us complementary insights into these quite different reactions.

  <section|<with|font-shape|italic|Ab initio> calculations>

  In this section we will study the relevant molecular species: the dimers
  SrF, Sr<rsub|<math|2>> and F<rsub|<math|2>>; and the trimers
  SrF<rsub|<math|2>> and Sr<rsub|<math|2>>F. All calculations of these
  species are performed using the <with|font-shape|small-caps|molpro> suite
  of <with|font-shape|italic|ab initio> electronic structure
  codes<nbsp><cite|molpro>. We use the relativistic effective core potential
  and associated basis set of the Stuttgart group for Sr<nbsp><cite|stutt>
  (ECP28MDF) and the augmented, correlation consistent valence triple
  (quadruple) zeta basis set (AVTZ (AVQZ)) of Dunning for
  F<nbsp><cite|dunning>. For the diatomic properties, the AVQZ basis is used.

  We perform the calculations by first computing a spin-restricted
  Hartree-Fock (RHF) wave function as a starting guess for a coupled-cluster
  singles, doubles, and non-iterative triples excitations calculation
  (CCSD(T))<nbsp><cite|ccsd1>. The minimum energy configuration is obtained
  using the method of steepest descents. Properties such as dipole moment,
  polarizability, and quadrupole moment are calculated using the finite field
  approach. To compare the energies to the free atom limit, we use basis set
  superposition error (BSSE) corrections as given by the method of Boys and
  Bernardi<nbsp><cite|bsse>. We calculate the vibrational frequencies by
  making the symmetry-independent displacements of the atoms and calculating
  the Hessian within the <with|font-shape|small-caps|molpro> suite of
  routines.

  <subsection|Diatomic species>

  In the collision of two SrF molecules there are three diatomic species to
  consider; the reactant SrF and the possible products Sr<rsub|<math|2>> and
  F<rsub|<math|2>>. In the following we will investigate the relevant
  diatomic properties such as equilibrium bond length, well depth, and
  vibration constant. But first, an exercise in bond strengths can
  immediately inform us as to whether the reactions in
  Eq.<nbsp>(<reference|e:bs>) can occur. On the left hand side of the
  reaction we have two ionic bonds. On the right hand side we have one van
  der Waals bond and one covalent bond; the former is very weak and the
  latter usually less bound than an ionic bond. An ionic bond can be thought
  of as a strengthening of the single covalent bond because of a transferring
  of charge from one atom to the other. From these simple considerations, we
  conclude that the reaction in (<reference|e:bs>) is energetically
  unfavorable at ultracold temperatures.

  Sr<rsub|<math|2>> is a van der Waals molecule. The
  <rsup|<math|1>>S<rsub|<math|0>> atomic structure means that the the outer
  <math|s>-electrons are already paired up and therefore play a limited role
  in the bonding of two Sr atoms. Previous work has shown that this molecule
  is not deeply bound, with a well depth of
  <math|D<rsub|e>=1081.8><nbsp>cm<rsup|<math|-1>><nbsp><cite|sr2|stein>.
  Because of the large binding length and relatively larger mass of Sr atoms,
  the vibrational constant is fairly small,
  <math|\<omega\><rsub|e>=40.3><nbsp>cm<rsup|<math|-1>><nbsp><cite|stein>.
  Therefore, the energy required to dissociate this molecule from the zeroth
  vibrational level is given by <math|D<rsub|0>=1061.6><nbsp>cm<rsup|<math|-1>>.

  F<rsub|<math|2>> is a covalently bonded species, with a ground state of
  <math|<rsup|1>\<Sigma\><rsub|<math-up|g>><rsup|<math-up|+>>> symmetry.
  F<rsub|<math|2>> has an appreciably large binding energy of
  <math|D<rsub|0>=>12950<nbsp>cm<rsup|<math|-1>><nbsp><cite|hao> and much
  smaller bond length compared to Sr<rsub|<math|2>>. The unpaired
  <math|p>-electrons in the F atoms pair up and form a fairly deep well. Due
  to the lighter mass and tighter confining potential, the F<rsub|<math|2>>
  molecule has a comparatively large vibrational constant,
  917<nbsp>cm<rsup|<math|-1>><nbsp><cite|chen>. Therefore, the well depth,
  <math|D<rsub|e>=13410><nbsp>cm<rsup|<math|<math-up|-1>>> when combining the
  work of <cite|hao> and <cite|chen>.

  SrF is a highly polar molecule. The willingness of F to take an extra
  electron, and of Sr to give one up, would lead one to conclude that at the
  minimum of the well the molecule is well described by a
  Sr<rsup|<math|<math-up|+>>>F<rsup|<math|<math-up|->>> configuration. We
  therefore compared the optimized geometry calculated at the
  RHF-CCSD(T)+BSSE calculation in two ways. The first was to compare the
  energy at the bottom of the potential energy surface to that of free Sr and
  F atoms. The other was to compare to free Sr<rsup|<math|<math-up|+>>> and
  F<rsup|<math|<math-up|->>> ions and then calculate the ionization potential
  of Sr and the electron affinity of F. These calculations agreed with each
  other to within several cm<rsup|<math|-1>>. The well depth <math|D<rsub|e>>
  we report here refers to the energy required to separate SrF into its
  neutral partners, Sr and F.

  <big-table| <ruledtabular| <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|1ln>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|1ln>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|5|5|cell-rborder|1ln>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|6|6|cell-rborder|1ln>|<cwith|1|-1|7|7|cell-halign|c>|<cwith|1|-1|7|7|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|4|4|1|-1|cell-bborder|1ln>|<cwith|6|6|1|-1|cell-bborder|1ln>|<cwith|8|8|1|-1|cell-bborder|1ln>|<table|<row|<cell|Molecule>|<cell|<math|D<rsub|e>>>|<cell|<math|R<rsub|e>>>|<cell|<math|\<omega\><rsub|e>>>|<cell|<math|d<rsub|m>>>|<cell|<math|\<alpha\><rsub|z>>>|<cell|<math|\<theta\><rsub|z*z>>>>|<row|<cell|SrF
  (this work)>|<cell|44200>|<cell|2.084>|<cell|499>|<cell|1.38>|<cell|126>|<cell|8.95>>|<row|<cell|<nbsp><nbsp>Expt.>|<cell|45290(560)<footnotemark*|1>>|<cell|2.075<footnotemark*|2>>|<cell|502.4<footnotemark*|2>>|<cell|1.36<footnotemark*|3>>|<cell|<nbsp>>|<cell|<nbsp>>>|<row|<cell|<nbsp><nbsp>Theory>|<cell|45000<footnotemark*|4>>|<cell|2.085>|<cell|507>|<cell|<nbsp>>|<cell|<nbsp>>|<cell|<nbsp>>>|<row|<cell|Sr<rsub|<math|2>>
  (this work)>|<cell|820>|<cell|4.773>|<cell|36.2>|<cell|<nbsp>>|<cell|<nbsp>>|<cell|<nbsp>>>|<row|<cell|<nbsp><nbsp>Expt.<footnotemark*|5>>|<cell|1081.8>|<cell|4.672>|<cell|40.3>|<cell|<nbsp>>|<cell|<nbsp>>|<cell|<nbsp>>>|<row|<cell|F<rsub|<math|2>>
  (this work)>|<cell|12880>|<cell|1.410>|<cell|927>|<cell|<nbsp>>|<cell|<nbsp>>|<cell|<nbsp>>>|<row|<cell|<nbsp><nbsp>Expt.>|<cell|13410<footnotemark*|6>>|<cell|1.411<footnotemark*|7>>|<cell|917<footnotemark*|7>>|<cell|<nbsp>>|<cell|<nbsp>>|<cell|<nbsp>>>>>>>
  |<label|t:diatoms> The molecular properties of Sr<rsub|<math|2>>,
  F<rsub|<math|2>>, and SrF. Energies are in cm<rsup|<math|<math-up|-1>>>,
  bond lengths in <math|>, and moments in atomic units. Experimental values
  are given where known.>

  In Table<nbsp><reference|t:diatoms> we present the results of our
  RHF-CCSD(T)+BSSE calculations. All bond lengths (<math|R<rsub|e>>) are in
  <math|>, well depths (<math|D<rsub|e>>) and vibration constants
  (<math|\<omega\><rsub|e>>) are in cm<rsup|<math|<math-up|-1>>>, and
  associated dipole and quadrupole moments (<math|d<rsub|m>> and
  <math|\<theta\><rsub|z*z>>) are in atomic units (<math|e<nbsp>a<rsub|0>>
  and <math|e<nbsp>a<rsub|0><rsup|2>>, respectively). The corresponding
  experimental values are from the references given, and uncertainties are
  printed for those where the value was reported. The theoretical calculation
  of Langhoff <with|font-shape|italic|et al.>, is done at the configuration
  interaction with single and double excitations level of
  theory<nbsp><cite|langhoff>. Our current method yields a well depth smaller
  than the experimentally obtained value by
  <math|2*\<sigma\>><nbsp><cite|eng79>. The bond length is in good agreement
  with that of <nbsp><cite|langhoff>. From these results we immediately see
  that the reaction in Eq.<nbsp>(<reference|e:bs>) is energetically
  forbidden, by more than 70,000 cm<rsup|<math|-1>>, and is of no concern in
  an ultracold gas.

  <subsection|Triatomic species>

  There are two different triatomic species to consider as given in
  Eqs.<nbsp>(<reference|e:trimer1>) and (<reference|e:trimer2>). At first
  glance, we might think both are quite easily allowed. From a simple bond
  strength argument, we can see that one is favored over the other.
  Particularly, that the triatom in Eq.<nbsp>(<reference|e:trimer1>) is less
  bound than the triatom in Eq.<nbsp>(<reference|e:trimer2>). The triatom in
  (<reference|e:trimer2>) has two ionic bonds, while the triatom in
  (<reference|e:trimer1>) can have only one. Therefore, from the fact that
  two ionic bonds should be more deeply bound than one, we expect the triatom
  in (<reference|e:trimer2>) to be more deeply bound than in
  (<reference|e:trimer1>). In addition, it is expected that the reaction in
  (<reference|e:trimer1>) is energetically unfavorable because there are
  stronger bonds on the LHS than on the RHS. However, the reaction in
  (<reference|e:trimer2>) cannot be determined from these arguments. Thus, it
  is to be calculated using the same <with|font-shape|italic|ab initio>
  methods as in the previous section. For the SrF<rsub|<math|2>> singlet
  state, we use the AVQZ basis for F as we did for SrF. However, for the
  remaining states we only used the AVTZ basis. This is because these states
  are so energetically forbidden (as we will see) that the less
  time-consuming calculation is adequate for our purposes.

  In Fig.<nbsp>1, we give the three coordinates that are used in the
  optimization of the geometry. Using these three coordinates
  (<math|r<rsub|1>>, <math|r<rsub|2>>, and <math|\<theta\>>), without
  constraining then, ensures that the electronic wave function belongs to the
  C<rsub|<math|<math-up|s>>> symmetry group. Thus, there are electronic
  states with even (A<math|<rprime|'>>) and odd
  (A<rsup|<math|\<prime\>*\<prime\>>>) reflection symmetry through the plane
  containing the three atoms. When the two bond lengths are equal, the
  symmetry group is instead expanded to C<rsub|<math|<math-up|2v>>>. This
  added symmetry describes whether the molecule possesses even or odd
  reflection about the line which bisects the homonuclear bond. Where the
  ground state has equal bond lengths, we have indicated this with the
  appropriate notation; <math|A<rsub|1>> (<math|B<rsub|2>>) have even
  reflection symmetry about the mid-point between the homonuclear bond and
  even (odd) reflection symmetry through the plane containing the three
  atoms. Similarly, <math|A<rsub|2>> (<math|B<rsub|1>>) has odd reflection
  about the midpoint of the homonuclear bond with even (odd) reflection
  through the plane containing the three atoms.

  <\big-figure>
    <label|f:triGeom>

    <resizebox|3.in|!|<image|fig1.eps||||>>

    <vspace|-.33in>

    \;
  </big-figure|(Color Online) Diagram of the geometries considered in the
  calculation of the the molecules Sr<rsub|<math|2>>F and SrF<rsub|<math|2>>.
  The coordinates <math|r<rsub|1>>, <math|r<rsub|2>>, and <math|\<theta\>>
  were varied and energy optimized to find the minimum energy configuration
  in both the A<math|<rprime|'>> and A<rsup|<math|\<prime\>*\<prime\>>>
  symmetry groups.>

  <big-table| <ruledtabular| <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|1ln>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|1ln>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|5|5|cell-rborder|1ln>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|6|6|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|4|4|1|-1|cell-bborder|1ln>|<cwith|5|5|1|-1|cell-bborder|1ln>|<cwith|6|6|1|-1|cell-bborder|1ln>|<cwith|7|7|1|-1|cell-bborder|1ln>|<table|<row|<cell|Molecule>|<cell|Symm.>|<cell|<math|D<rsub|e>>>|<cell|<math|r<rsub|1>>>|<cell|<math|r<rsub|2>>>|<cell|<math|\<theta\>>>>|<row|<cell|SrF<rsub|<math|2>>>|<cell|<rsup|<math|1>>A<rsub|<math|1>>>|<cell|91870>|<cell|2.13>|<cell|2.13>|<cell|135.7>>|<row|<cell|<nbsp><nbsp>Theory<footnotemark*|1>>|<cell|<nbsp>>|<cell|<nbsp>>|<cell|2.16>|<cell|2.16>|<cell|138.8>>|<row|<cell|<nbsp><nbsp>Expt.<footnotemark*|2>>|<cell|<nbsp>>|<cell|89300
  to 91900>|<cell|<nbsp>>|<cell|<nbsp>>|<cell|<nbsp>>>|<row|<cell|Sr<rsub|<math|2>>F>|<cell|<rsup|<math|2>>B<rsub|<math|2>>>|<cell|52300>|<cell|2.26>|<cell|2.26>|<cell|115.8>>|<row|<cell|Sr<rsub|<math|2>>F>|<cell|<rsup|<math|2>>B<rsub|<math|1>>>|<cell|43900>|<cell|2.25>|<cell|2.25>|<cell|101.7>>|<row|<cell|SrF<rsub|<math|2>>>|<cell|<rsup|<math|3>>A<rsup|<math|\<prime\>*\<prime\>>>>|<cell|43400>|<cell|2.10>|<cell|3.72>|<cell|70.4>>>>>>
  |<label|t:triatom> The molecular properties of SrF<rsub|<math|2>> and
  Sr<rsub|<math|2>>F. Energies are in cm<rsup|<math|<math-up|-1>>>, bond
  lengths in <math|> and angles in degrees. Previous theoretical values are
  given where applicable.>

  In Table<nbsp><reference|t:triatom> we present the results of the
  RHF-CCSD(T)+BSSE calculation. As is evident, the most deeply bound trimer
  is given by the <rsup|<math|1>>A<rsub|<math|1>> symmetry for
  SrF<rsub|<math|2>>. It is also the only one for which previous theoretical
  work is available for comparison. In Ref.<nbsp><cite|kaupp91>, Kaupp et al.
  present a theoretical study of many alkaline-earth metal atoms with two
  halogen atoms. We note that alkaline-earth di-halides have historically
  been of significant interest in chemistry, as some have bent geometries
  (hence possess permanent dipole moments in their body frame) and some are
  linear (with no such dipole moment). A bend is not expected from classical
  models of charged particles interacting, and therefore correctly predicting
  the bend is a measure of the quality of the wave function. This is because
  the bend is a result of the presence of <math|d>-electron orbitals on the
  ground state. Our calculation agrees well with that of <cite|kaupp91> in
  the description of the bond length and bending angle. For the first time,
  we present the energy required to pull apart the molecule into its atomic
  constituents - atomization. This energy is greater than that of two SrF
  molecules and therefore, in the absence of a barrier, should react
  chemically at ultracold temperatures.

  Vice versa, the triplet SrF<rsub|<math|2>> molecule (last line of Table II)
  is far less bound, and indeed has binding energy similar to that of a
  single SrF molecule. A simple way to understand this is to think of this as
  a triplet covalent bond in F<rsub|<math|2>> with a Sr atom bound to one or
  the other F atoms ionically. The triplet bond in F<rsub|<math|2>> is much
  shallower than the singlet covalent bond in the ground state. Then the Sr
  comes along and binds to one of the F atoms. A simple charge population
  analysis shows that only the F atom closer to Sr captures charge.
  Importantly, the triplet trimer is energetically disallowed at ultracold
  (and even room) temperature studies of SrF collisions.

  The other potential trimer, Sr<rsub|<math|2>>F, is reported in the second
  and third lines of Table<nbsp><reference|t:triatom>. This molecule, while
  more deeply bound than the triplet state of SrF<rsub|<math|2>>, is not deep
  enough to be chemically reactive, as expected from the simple bond
  arguments. Thus, this reaction will not proceed at ultracold temperatures.
  Notice that this molecule has a binding energy only slightly more than that
  of a single SrF diatom. The doublet nature of this molecule is due to the
  one unpaired electron that can be viewed as coming from the F atom plus a
  Sr<rsub|<math|2>> bond, or from the doublet nature of SrF plus a free Sr
  atom.

  We therefore conclude that only the singlet electronic state of
  SrF<rsub|<math|2>> will form in the collision of two SrF molecules, at
  ultralow collision energy. We find that the energy released is
  <math|3470><nbsp>cm<rsup|<math|<math-up|-1>>>. To be thorough, we must take
  into account the zero-point vibrational energy of the systems in
  consideration. In Table<nbsp><reference|t:diatoms> we gave the calculated
  and experimental values of the vibrational constants of SrF. We have
  calculated the vibrational constants of SrF<rsub|<math|2>> in the singlet
  electronic state: <math|\<omega\><rsub|<math-up|sym>>=472.9>,
  <math|\<omega\><rsub|<math-up|asym>>=478.7>, and
  <math|\<omega\><rsub|<math-up|bend>>=79.3><nbsp>cm<with|font-family|rm|-1>,
  where these represent the symmetric (or breathing) mode, the anti-symmetric
  mode, and the bending mode of the triatomic molecule. This yields a
  zero-point energy of 515.5<nbsp>cm<rsup|<math|<math-up|-1>>>. Therefore,
  all the exoergic reactions are reduced by
  <math|\<approx\>><nbsp>20<nbsp>cm<rsup|<math|<math-up|-1>>>. It is evident
  that the added vibrational modes (three vs one in the diatom SrF) are not
  enough to overcome the energy released in the chemical reaction. In fact,
  there are roughly 150 vibrational states accessible in the reactants, given
  using the calculated exoergicity of <math|\<Delta\><rsub|<math-up|trimer>>=3450><nbsp>cm<rsup|<math|<math-up|-1>>>.

  To our knowledge, this quantity has been measured only once, in a gas cell
  which maintained chemical equilibrium between reactants and products at
  <math|\<sim\>1500> K, using mass spectroscopy to measure their relative
  abundance <cite|Hildenbrand68_JCP>. Knowing the temperature, this
  measurement provided information on the enthalpy of formation
  <math|\<Delta\><rsub|f>*H>, which corresponds to the energy released,
  <math|\<Delta\>*E<rsub|<math-up|trimer>>> in
  Eq.<nbsp>(<reference|e:trimer2>). This measurement agrees that the reaction
  is exothermic, but by a more modest value of <math|\<Delta\><rsub|f>*H=2.1>
  kcal/mol = <math|740> cm<rsup|<math|-1>>, than we have calculated. Given
  that the experimental uncertainty was comparable to 700 cm<rsup|<math|-1>>
  and our computational uncertainty is perhaps 2000 cm<rsup|<math|-1>>, the
  results are not too seriously in disagreement. Ultimately, measurements in
  laser-cooled SrF samples should sort out this issue in detail.

  <section|Reaction path basics>

  To compute the full PES of the four-body system involved in the reaction is
  of course a complicated affair. Here we instead compute selected slices of
  this PES. One is a reaction-path coordinate version that will verify that
  the reaction is barrierless. The second is a more detailed examination of
  the \Phand-off\Q mechanism that drives this abstraction reaction. We will
  focus exclusively on the singlet PES, as it is the only one leading to
  reactions in an ultralow temperature SrF gas. All calculations are
  performed with the ECP28MDF basis set and ECP of the Stuttgart group for Sr
  along with the AVTZ basis of Dunning for F. We use the RHF-CCSD(T)+BSSE
  level of theory.

  A basic idea in constructing the reaction path surface is that the
  relatively heavy Sr atoms move comparatively slowly, and therefore the
  Sr-Sr distance can be regarded (approximately) as an adiabatic coordinate.
  Fixing this distance, denoted <math|R<rsub|<math-up|Sr-Sr>>>, we optimize
  the coordinates <math|r<rsub|1>>, <math|r<rsub|2>>,
  <math|\<theta\><rsub|1>>, and <math|\<theta\><rsub|2>> of the F atoms, as
  defined in Figure 2, so as to minimize the energy. For simplicity, we
  constrain all four atoms to lie in a plane. While this limits the
  possibility of the molecules changing the dihedral angle, it does not
  prevent all insertion type configurations from being explored. As we will
  see, the optimizations of the other coordinates suggest a preference for
  linear orientations upon approach.

  To track the progress of the reaction, we define the approximate reaction
  coordinate <math|\<Delta\>> via

  <\equation>
    <label|e:reactcoord>\<Delta\>=r<rsub|2>-r<rprime|'>.
  </equation>

  In the limit that <math|\<Delta\>> is negative and large, it denotes the
  distance between the two SrF diatoms, whereas when <math|\<Delta\>> is
  positive and large, it refers to the distance between the
  SrF<rsub|<math|2>> trimer and the free Sr atom.

  <\big-figure>
    <label|f:react>

    <resizebox|3.25in|!|<image|fig2a.eps||||>>
    <resizebox|3.25in|!|<image|fig2b.eps||||>>

    <vspace|-.33in>

    \;
  </big-figure|(Color Online) The top portion of the figure describes the
  geometry of the situation. <math|r<rsub|1>>, <math|r<rsub|2>>,
  <math|\<theta\><rsub|1>>, and <math|\<theta\><rsub|2>> are optimized so as
  to produce the minimal energy for a fixed <math|R<rsub|<math-up|Sr-Sr>>>.
  The LHS describes the approach of two dipole objects. On the RHS, the
  approach is more van der Waals like where the polar SrF<rsub|<math|2>>
  polarizes the Sr atom. The middle is a sharp point that is an artifact of
  the choice of <math|\<Delta\>=r<rsub|2>-r<rprime|'>>. The larger, blue
  (smaller, red) filled disks represent Sr (F) atoms. The approach to the
  transition state near <math|\<Delta\>=0><nbsp><math|> is very nearly
  linear up to the point of F capture. Then <math|\<theta\><rsub|1>> and
  <math|\<theta\><rsub|2>> rotate to form a complex which contains a slightly
  distorted SrF<rsub|<math|2>> configuration. The lowest panel shows the
  optimized angles <math|\<theta\><rsub|1>> (solid, black line),
  <math|\<theta\><rsub|2>> (large dashed, blue line), and <math|\<theta\>>
  (small dashed, red line). The values remain fairly constant for
  <math|<around|\||\<Delta\>|\|>\<gtr\>1><nbsp><math|>, and change to form
  the transition state in the region <math|<around|\||\<Delta\>|\|>\<less\>1><nbsp><math|>>

  The optimized energy is plotted as a function of <math|\<Delta\>> in the
  middle panel of Fig.<nbsp>2, adjusted so that the zero of energy refers to
  two free, separated SrF molecules. The PES along this path shows very
  little structure: it corresponds to almost pure dipolar attraction between
  reactants for <math|\<Delta\>\<less\>0>, and almost pure van der Waals
  attraction between the products for <math|\<Delta\>\<gtr\>0>. In
  particular, this cut through the PES shows clearly that there is
  <with|font-shape|italic|no barrier> to reaction, at least along the minimum
  energy path.

  This choice of reaction coordinate is useful, but also leads to a
  structural discontinuity in the surface of Fig.<nbsp>2. This discontinuity
  is made clear in the last panel of Fig.<nbsp>2 which depicts the variation
  in the angles <math|\<theta\><rsub|1>>, <math|\<theta\><rsub|2>>, and
  <math|\<theta\>> (see top panel of Fig.<nbsp>2). This is an artifact of the
  choice in approximate reaction coordinate. Physically, this discontinuity
  arises because <math|R<rsub|<math-up|Sr-Sr>>> is not strictly an adiabatic
  coordinate. At some point, the intermediate F atom glides from its local
  minimum (attached to the right-hand Sr atom) to its global minimum
  (attached to the SrF on the left). When this occurs, a single value of
  <math|R<rsub|<math-up|Sr-Sr>>> corresponds to two distinct values of the
  reaction coordinate <math|\<Delta\>> where the adiabatic energy is the
  same. This mechanism will be clarified by looking at the PES from a
  different perspective, below.

  For <math|\<Delta\>\<less\>0>, the system is described by a linear geometry
  (<math|\<theta\><rsub|1>=\<theta\><rsub|2>=0<rsup|\<circ\>>>). As the
  diatoms approach one another, they reach a location in <math|\<Delta\>>
  where the discontinuity occurs. From the <math|\<Delta\>\<gtr\>0> side, the
  values of <math|\<theta\><rsub|1>>, <math|\<theta\><rsub|2>>, and
  <math|\<theta\>> are fairly constant. As <math|\<Delta\>> is decreased
  toward zero by decreasing R<rsub|<math|<math-up|Sr-Sr>>>, the 4-atom system
  reaches a minimum near <math|\<Delta\>=0>. As the
  R<rsub|<math|<math-up|Sr-Sr>>> is decreased further,
  <math|\<theta\><rsub|1>> approaches <math|0<rsup|\<circ\>>> and the system
  approaches the geometrical discontinuity from the other side. This leads to
  a fairly smooth reaction path in the coordinate <math|\<Delta\>>, but hides
  the change in the geometrical configuration of the 4-atom system.

  Using the information contained in the values of <math|\<theta\><rsub|1>>,
  <math|\<theta\><rsub|2>>, and <math|\<theta\>> we are led to study the F
  capture process by analyzing the linear configuration. Even though the
  final trimer's ground state is bent, the energy of the linear configuration
  is only <math|\<sim\>>500<nbsp>cm<rsup|<math|-1>> above the bent
  configuration of SrF<rsub|<math|2>>. For this reason, we can make a
  reasonable qualitative description of the reaction by constraining all
  atoms to lie on a line, as in the upper panel of Fig.<nbsp>3.

  We again treat the Sr-Sr distance as an adiabatic coordinate. Then, for
  fixed Sr-Sr distances <math|R<rsub|<math-up|Sr-Sr>>>, we vary the location
  of the middle F atom, describing it with coordinate <math|r<rprime|'>> as
  depicted at the top of Fig.<nbsp>3. The leftmost F atom is fixed to the
  diatom bond length of SrF, <math|r<rsub|1>>. Because the bond length in SrF
  and SrF<rsub|<math|2>> are so similar, this is a reasonable assumption.
  Using the RHF-CCSD(T)+BSSE method we calculate the potential experienced by
  the middle F atom. The results are presented in Fig.<nbsp>3 for various
  values of <math|R<rsub|<math-up|Sr-Sr>>>. The BSSE compares the energy to
  the atomization limit. In the figure, we offset the energy by the binding
  energy of two SrF molecules. Thus, zero energy is the energy of two SrF
  diatoms.

  <\big-figure>
    <label|f:handoff>

    <resizebox|3.25in|!|<image|fig3.eps||||>>

    <vspace|-.33in>

    \;
  </big-figure|(Color Online) The top portion gives the geometry of the
  system. The bond length <math|r<rsub|1>> is fixed while <math|r<rsub|2>> is
  varied. <math|r<rprime|'>> gives the distance to the middle F to the other
  Sr atom and is called the hand-off coordinate since it describes the
  handing off of a F to one Sr from the other Sr. Each subsequent plot is for
  a fixed value of <math|R<rsub|<math-up|Sr-Sr>>> given in the upper RHS. As
  the value of <math|R<rsub|<math-up|Sr-Sr>>> is reduced, the barrier to
  forming the system F-Sr-F + Sr is diminished until it no longer stops the
  transfer of F. The calculations were performed at the RHF-CCSD(T)+BSSE with
  the Sr ECP28MDF and F AVTZ bases respectively.>

  In the first plot of Fig.<nbsp>3 the two Sr atoms are far from one another.
  The potential for the F atom has two minima, representing the fluorine
  attached to the original Sr atom (right hand well) or else attached to the
  other SrF to form the product SrF<rsub|<math|2>> (left hand well). The
  latter well being deeper signifies that the products SrF<rsub|<math|2>> +
  Sr are energetically favored and the reaction is exoergic, even within a
  strictly linear geometry. Between these minima stands a high barrier, which
  naturally prevents the F atoms from jumping from reactants to products when
  the Sr atoms are this far apart.

  In subsequent panels of Fig.<nbsp>3, the two Sr atoms approach one another.
  In each case the barrier lowers until it eventually disappears altogether,
  and the F atom rests at the bottom of a single minimum in the last plot of
  Fig.<nbsp>3. This configuration defines the four-body transition state with
  <math|\<Delta\>\<approx\>0><nbsp><math|>. At this point the Sr atom can
  recede, and to the extent that its motion really is adiabatic, the F atom
  will tend to remain in the lower well, thus finding itself a part of the
  SrF<rsub|<math|2>> final product. We say that this F-abstraction reaction
  occurs by a \Phand-off\Q mechanism, whereby the right-hand Sr atom
  approaches, gently hands off the F, and then goes away. As compared to the
  KRb-KRb surface <cite|byrd10>, this reaction is less likely to partake in a
  complicated dance of the four atoms, becoming thoroughly enmeshed in a
  four-body transition-state complex.

  <section|Conclusions>

  In summary, we have established that ground-state SrF molecules will indeed
  by chemically reactive, even at ultralow temperatures that will be achieved
  via laser cooling. The only possible outcome of such a reactive collision
  would be the singlet trimer SrF<rsub|<math|2>>, plus a free Sr atom.
  Because of the need to produce a singlet final state, chemical reactivity
  should be strongly suppressed in a spin-polarized sample. This species
  therefore looks like a promising candidate for ultracold molecular studies.
  On the one hand, SrF may serve as a useful platform for probing and
  understanding abstraction reactions in unprecedented detail. On the other
  hand, if producing a spin-polarized sample suppresses reactions
  sufficiently, there is also hope that the molecules may live long enough to
  perform interesting experiments on dipolar degenerate quantum gases. To
  estimate if this is so, future work will need to study in more detail both
  the triplet surface, and its detailed coupling to the reactive singlet
  surface.

  <acknowledgments>We are grateful for support from the NSF. We acknowledge
  useful discussions with G. Qumenr about chemical reaction processes.

  <\thebibliography|41>
    <expandafter><ifx><csname>natexlab<endcsname><assign|natexlab|<macro|1|<arg|1>>><fi><expandafter><ifx><csname>bibnamefont<endcsname>

    <assign|bibnamefont|<macro|1|<arg|1>>><fi><expandafter><ifx><csname>bibfnamefont<endcsname>

    <assign|bibfnamefont|<macro|1|<arg|1>>><fi><expandafter><ifx><csname>citenamefont<endcsname>

    <assign|citenamefont|<macro|1|<arg|1>>><fi><expandafter><ifx><csname>url<endcsname>

    <assign|url|<macro|1|<with|font-family|tt|<arg|1>>>><fi><expandafter><ifx><csname>urlprefix<endcsname><assign|urlprefix|<macro|URL
    >><fi><assign|bibinfo|<macro|1|2|<arg|2>>>
    <assign|eprint*|<macro|1|2|<slink|>>><assign|eprint|<macro|2|<eprint*||<arg|2>>>>

    <bibitem-with-key|(2009)|Campbell09_book>
    <bibinfo|author|<bibfnamefont|W.><nbsp><bibnamefont|Campbell>>
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Doyle>>,
    in <em|<bibinfo|booktitle|Cold Molecules: Theory, Experiment,
    Applications>>, edited by <bibinfo|editor|<bibfnamefont|R.<nbsp>V.>
    <bibnamefont|Krems>>, <bibinfo|editor|<bibfnamefont|W.<nbsp>C.>
    <bibnamefont|Stwalley>>, <bibnamefont|and>
    <bibinfo|editor|<bibfnamefont|B.><nbsp><bibnamefont|Friedrich>>
    (<bibinfo|publisher|CRC Press>, <bibinfo|address|Boca Raton>,
    <bibinfo|year|2009>), pp. <bibinfo|pages|473--508>.

    <bibitem-with-key|(2009)|Meerakker09_book>
    <bibinfo|author|<bibfnamefont|S.<nbsp>Y.<nbsp>T.>
    <bibnamefont|van<nbsp>der Meerakker>>,
    <bibinfo|author|<bibfnamefont|H.<nbsp>L.> <bibnamefont|Bethlem>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|G.><nbsp><bibnamefont|Meijer>>,
    in <em|<bibinfo|booktitle|Cold Molecules: Theory, Experiment, and
    Applications>>, edited by <bibinfo|editor|<bibfnamefont|W.<nbsp>C.<nbsp>S.>
    <bibnamefont|R.<nbsp>V.<nbsp>Krems>> <bibnamefont|and>
    <bibinfo|editor|<bibfnamefont|B.><nbsp><bibnamefont|Friedrich>>
    (<bibinfo|publisher|CRC Press>, <bibinfo|address|Boca Raton>,
    <bibinfo|year|2009>), pp. <bibinfo|pages|509 -- 554>.

    <bibitem-with-key|(2010)|Scharfenberg10_PCCP>
    <bibinfo|author|<bibfnamefont|L.><nbsp><bibnamefont|Scharfenberg>>,
    <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Klos>>,
    <bibinfo|author|<bibfnamefont|P.<nbsp>J.> <bibnamefont|Dagdigian>>,
    <bibinfo|author|<bibfnamefont|M.<nbsp>H.> <bibnamefont|Alexander>>,
    <bibinfo|author|<bibfnamefont|G.><nbsp><bibnamefont|Meijer>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|S.<nbsp>Y.<nbsp>T.>
    <bibnamefont|van<nbsp>der Meerakker>>, <bibinfo|journal|Phys. Chem. Chem.
    Phys> <with|font-series|bold|<bibinfo|volume|12>>, <bibinfo|pages|10660>
    (<bibinfo|year|2010>).

    <bibitem-with-key|(2010)|Hummon10_preprint>
    <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Hummon>>,
    <bibinfo|author|<bibfnamefont|T.><nbsp><bibnamefont|Tscherbul>>,
    <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Klos>>,
    <bibinfo|author|<bibfnamefont|H.-I.> <bibnamefont|Lu>>,
    <bibinfo|author|<bibfnamefont|E.><nbsp><bibnamefont|Tsikata>>,
    <bibinfo|author|<bibfnamefont|W.><nbsp><bibnamefont|Campbell>>,
    <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Dalgarno>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|J.<nbsp>M.>
    <bibnamefont|Doyle>>, <bibinfo|journal|arXiv:1009.2513>
    (<bibinfo|year|2010>).

    <bibitem-with-key|(2010)|ye10> <bibinfo|author|<bibfnamefont|B.<nbsp>C.>
    <bibnamefont|Sawyer>>, <bibinfo|author|<bibfnamefont|B.<nbsp>K.>
    <bibnamefont|Stuhl>>, <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Yeo>>,
    <bibinfo|author|<bibfnamefont|T.<nbsp>V.> <bibnamefont|Tscherbul>>,
    <bibinfo|author|<bibfnamefont|M.<nbsp>T.> <bibnamefont|Hummon>>,
    <bibinfo|author|<bibfnamefont|Y.><nbsp><bibnamefont|Xia>>,
    <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Klos>>,
    <bibinfo|author|<bibfnamefont|D.><nbsp><bibnamefont|Patterson>>,
    <bibinfo|author|<bibfnamefont|J.<nbsp>M.> <bibnamefont|Doyle>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Ye>>,
    <bibinfo|journal|arxiv:1008.5127v1> (<bibinfo|year|2010>).

    <bibitem-with-key|(2010)|Parazzoli10_preprint>
    <bibinfo|author|<bibfnamefont|P.<nbsp>P.>
    <bibnamefont|<with|font-shape|italic|et al.>>>, <bibinfo|journal|in
    preparation> (<bibinfo|year|2010>).

    <bibitem-with-key|(2005)|rbcspaper> <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Sage>>,
    <bibinfo|author|<bibfnamefont|S.><nbsp><bibnamefont|Sainis>>,
    <bibinfo|author|<bibfnamefont|T.><nbsp><bibnamefont|Bergeman>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|D.><nbsp><bibnamefont|DeMille>>,
    <bibinfo|journal|Phys. Rev. Lett.> <with|font-series|bold|<bibinfo|volume|94>>,
    <bibinfo|pages|203001> (<bibinfo|year|2005>).

    <bibitem-with-key|(2008)|kkniscience>
    <bibinfo|author|<bibfnamefont|K.-K.> <bibnamefont|Ni>>,
    <bibinfo|author|<bibfnamefont|S.><nbsp><bibnamefont|Ospelkaus>>,
    <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Miranda>>,
    <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Peer>>,
    <bibinfo|author|<bibfnamefont|B.><nbsp><bibnamefont|Neyenhuis>>,
    <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Zirbel>>,
    <bibinfo|author|<bibfnamefont|S.><nbsp><bibnamefont|Kotochigova>>,
    <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Julienne>>,
    <bibinfo|author|<bibfnamefont|D.><nbsp><bibnamefont|Jin>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Ye>>,
    <bibinfo|journal|Science> <with|font-series|bold|<bibinfo|volume|322>>,
    <bibinfo|pages|231> (<bibinfo|year|2008>).

    <bibitem-with-key|(2010)|Danzl10_NatP>
    <bibinfo|author|<bibfnamefont|J.<nbsp>G.> <bibnamefont|Danzl>>,
    <bibinfo|author|<bibfnamefont|M.<nbsp>J.> <bibnamefont|Mark>>,
    <bibinfo|author|<bibfnamefont|E.><nbsp><bibnamefont|Haller>>,
    <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Gustavvson>>,
    <bibinfo|author|<bibfnamefont|R.><nbsp><bibnamefont|Hart>>,
    <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Aldegunde>>,
    <bibinfo|author|<bibfnamefont|J.<nbsp>M.> <bibnamefont|Hutson>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|H.-C.>
    <bibnamefont|Ngerl>>, <bibinfo|journal|Nature Phys.>
    <with|font-series|bold|<bibinfo|volume|6>>, <bibinfo|pages|265>
    (<bibinfo|year|2010>).

    <bibitem-with-key|(2010)|tokyoKRb> <bibinfo|author|<bibfnamefont|K.><nbsp><bibnamefont|Aikawa>>,
    <bibinfo|author|<bibfnamefont|D.><nbsp><bibnamefont|Akamatsu>>,
    <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Hayashi>>,
    <bibinfo|author|<bibfnamefont|K.><nbsp><bibnamefont|Oasa>>,
    <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Kobayashi>>,
    <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Naidon>>,
    <bibinfo|author|<bibfnamefont|T.><nbsp><bibnamefont|Kishimoto>>,
    <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Ueda>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|S.><nbsp><bibnamefont|Inouye>>,
    <bibinfo|journal|arXiv:1008.5034v1> (<bibinfo|year|2010>).

    <bibitem-with-key|(2010)|Ospelkaus10_Science>
    <bibinfo|author|<bibfnamefont|S.><nbsp><bibnamefont|Ospelkaus>>,
    <bibinfo|author|<bibfnamefont|K.-K.> <bibnamefont|Ni>>,
    <bibinfo|author|<bibfnamefont|D.><nbsp><bibnamefont|Wang>>,
    <bibinfo|author|<bibfnamefont|M.<nbsp>H.<nbsp>G.>
    <bibnamefont|de<nbsp>Miranda>>, <bibinfo|author|<bibfnamefont|B.><nbsp><bibnamefont|Neyenhuis>>,
    <bibinfo|author|<bibfnamefont|G.><nbsp><bibnamefont|Qumner>>,
    <bibinfo|author|<bibfnamefont|P.<nbsp>S.> <bibnamefont|Julienne>>,
    <bibinfo|author|<bibfnamefont|J.<nbsp>L.> <bibnamefont|Bohn>>,
    <bibinfo|author|<bibfnamefont|D.<nbsp>S.> <bibnamefont|Jin>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Ye>>,
    <bibinfo|journal|Science> <with|font-series|bold|<bibinfo|volume|327>>,
    <bibinfo|pages|853> (<bibinfo|year|2010>).

    <bibitem-with-key|(2010)|Ni10_Nature>
    <bibinfo|author|<bibfnamefont|K.-K.> <bibnamefont|Ni>>,
    <bibinfo|author|<bibfnamefont|S.><nbsp><bibnamefont|Ospelkaus>>,
    <bibinfo|author|<bibfnamefont|D.><nbsp><bibnamefont|Wang>>,
    <bibinfo|author|<bibfnamefont|G.><nbsp><bibnamefont|Qumner>>,
    <bibinfo|author|<bibfnamefont|B.><nbsp><bibnamefont|Neyenhuis>>,
    <bibinfo|author|<bibfnamefont|M.<nbsp>H.<nbsp>G.>
    <bibnamefont|de<nbsp>Miranda>>, <bibinfo|author|<bibfnamefont|J.<nbsp>L.>
    <bibnamefont|Bohn>>, <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Ye>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|D.<nbsp>S.>
    <bibnamefont|Jin>>, <bibinfo|journal|Nature>
    <with|font-series|bold|<bibinfo|volume|464>>, <bibinfo|pages|1324>
    (<bibinfo|year|2010>).

    <bibitem-with-key|(2009)|Gorshkov09_PRL>
    <bibinfo|author|<bibfnamefont|A.<nbsp>V.> <bibnamefont|Gorshkov>>,
    <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Rabl>>,
    <bibinfo|author|<bibfnamefont|G.><nbsp><bibnamefont|Pupillo>>,
    <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Micheli>>,
    <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Zoller>>,
    <bibinfo|author|<bibfnamefont|M.<nbsp>D.> <bibnamefont|Lukin>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|H.<nbsp>P.>
    <bibnamefont|Buchler>>, <bibinfo|journal|Phys. Rev. Lett.>
    <with|font-series|bold|<bibinfo|volume|101>>, <bibinfo|pages|073201>
    (<bibinfo|year|2009>).

    <bibitem-with-key|(2010)|Quemener10_PRA>
    <bibinfo|author|<bibfnamefont|G.><nbsp><bibnamefont|Qumner>>
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|J.<nbsp>L.>
    <bibnamefont|Bohn>> (<bibinfo|year|2010>).

    <bibitem-with-key|(2010)|Micheli10_PRL>
    <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Micheli>>,
    <bibinfo|author|<bibfnamefont|Z.><nbsp><bibnamefont|Idziaszek>>,
    <bibinfo|author|<bibfnamefont|G.><nbsp><bibnamefont|Pupillo>>,
    <bibinfo|author|<bibfnamefont|M.<nbsp>A.> <bibnamefont|Baranov>>,
    <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Zoller>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|P.<nbsp>S.>
    <bibnamefont|Julienne>>, <bibinfo|journal|Phys. Rev. Lett>
    <with|font-series|bold|<bibinfo|volume|105>>, <bibinfo|pages|073202>
    (<bibinfo|year|2010>).

    <bibitem-with-key|()|Miranda10_preprint>
    <bibinfo|author|<bibfnamefont|M.<nbsp>H.<nbsp>G.>
    <bibnamefont|de<nbsp>Miranda>>, <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Chotia>>,
    <bibinfo|author|<bibfnamefont|B.><nbsp><bibnamefont|Neyenhuis>>,
    <bibinfo|author|<bibfnamefont|D.><nbsp><bibnamefont|Wang>>,
    <bibinfo|author|<bibfnamefont|G.><nbsp><bibnamefont|Qumner>>,
    <bibinfo|author|<bibfnamefont|S.><nbsp><bibnamefont|Ospelkaus>>,
    <bibinfo|author|<bibfnamefont|J.<nbsp>L.> <bibnamefont|Bohn>>,
    <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Ye>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|D.<nbsp>S.>
    <bibnamefont|Jin>>, <bibinfo|journal|submitted> (????).

    <bibitem-with-key|(2010)|iqbj10> <bibinfo|author|<bibfnamefont|Z.><nbsp><bibnamefont|Idziaszek>>,
    <bibinfo|author|<bibfnamefont|G.<nbsp>Q.> <bibnamefont|Qumner>>,
    <bibinfo|author|<bibfnamefont|J.<nbsp>L.> <bibnamefont|Bohn>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|P.<nbsp>S.>
    <bibnamefont|Julienne>>, <bibinfo|journal|Phys. Rev. A>
    <with|font-series|bold|<bibinfo|volume|82>>, <bibinfo|pages|020703>
    (<bibinfo|year|2010>).

    <bibitem-with-key|(2010)|ij10> <bibinfo|author|<bibfnamefont|Z.><nbsp><bibnamefont|Idziaszek>>
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|P.<nbsp>S.>
    <bibnamefont|Julienne>>, <bibinfo|journal|Phys. Rev. Lett.>
    <with|font-series|bold|<bibinfo|volume|104>>, <bibinfo|pages|113202>
    (<bibinfo|year|2010>).

    <bibitem-with-key|(2010)|byrd10> <bibinfo|author|<bibfnamefont|J.<nbsp>N.>
    <bibnamefont|Byrd>>, <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|J.<nbsp>A.<nbsp>Montgomery>>,
    , <bibnamefont|and> <bibinfo|author|<bibfnamefont|R.><nbsp><bibnamefont|Ct>>,
    <bibinfo|journal|Phys. Rev. A> <with|font-series|bold|<bibinfo|volume|82>>,
    <bibinfo|pages|010502> (<bibinfo|year|2010>).

    <bibitem-with-key|(2009)|demille09> <bibinfo|author|<bibfnamefont|E.<nbsp>S.>
    <bibnamefont|Shuman>>, <bibinfo|author|<bibfnamefont|J.<nbsp>F.>
    <bibnamefont|Barry>>, <bibinfo|author|<bibfnamefont|D.<nbsp>R.>
    <bibnamefont|Glenn>>, <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|D.><nbsp><bibnamefont|DeMille>>,
    <bibinfo|journal|Phys. Rev. Lett.> <with|font-series|bold|<bibinfo|volume|103>>,
    <bibinfo|pages|223001> (<bibinfo|year|2009>).

    <bibitem-with-key|(published online Sept. 19, 2010)|Shuman10_Nature>
    <bibinfo|author|<bibfnamefont|E.<nbsp>S.> <bibnamefont|Shuman>>,
    <bibinfo|author|<bibfnamefont|J.<nbsp>F.> <bibnamefont|Barry>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|D.><nbsp><bibnamefont|DeMille>>,
    <bibinfo|journal|Nature> (<bibinfo|year|published online Sept. 19,
    2010>).

    <bibitem-with-key|(2007)|hudson07> <bibinfo|author|<bibfnamefont|B.<nbsp>C.>
    <bibnamefont|Sawyer>>, <bibinfo|author|<bibfnamefont|B.<nbsp>L.>
    <bibnamefont|Lev>>, <bibinfo|author|<bibfnamefont|E.<nbsp>R.>
    <bibnamefont|Hudson>>, <bibinfo|author|<bibfnamefont|B.<nbsp>K.>
    <bibnamefont|Stuhl>>, <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Lara>>,
    <bibinfo|author|<bibfnamefont|J.<nbsp>L.> <bibnamefont|Bohn>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Ye>>,
    <bibinfo|journal|Phys. Rev. Lett.> <with|font-series|bold|<bibinfo|volume|98>>,
    <bibinfo|pages|253002> (<bibinfo|year|2007>).

    <bibitem-with-key|(2010)|hutson10> <bibinfo|author|<bibfnamefont|P.<nbsp>S.>
    <bibnamefont|Zuchowski>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|J.<nbsp>M.> <bibnamefont|Hutson>>,
    <bibinfo|journal|Phys. Rev. A> <with|font-series|bold|<bibinfo|volume|81>>,
    <bibinfo|pages|060703> (<bibinfo|year|2010>).

    <bibitem-with-key|(2010)|meyer10> <bibinfo|author|<bibfnamefont|E.<nbsp>R.>
    <bibnamefont|Meyer>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|J.<nbsp>L.> <bibnamefont|Bohn>>,
    <bibinfo|journal|Phys. Rev. A> <with|font-series|bold|<bibinfo|volume|in
    review>> (<bibinfo|year|2010>).

    <bibitem-with-key|(2007)|krems07> <bibinfo|author|<bibfnamefont|T.<nbsp>V.>
    <bibnamefont|Tscherbul>>, <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Klos>>,
    <bibinfo|author|<bibfnamefont|L.><nbsp><bibnamefont|Rajchel>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|R.<nbsp>V.>
    <bibnamefont|Krems>>, <bibinfo|journal|Phys. Rev. A>
    <with|font-series|bold|<bibinfo|volume|75>>, <bibinfo|pages|033416>
    (<bibinfo|year|2007>).

    <bibitem-with-key|(2008)|molpro> <bibinfo|author|<bibfnamefont|H.-J.>
    <bibnamefont|Werner>>, <bibinfo|author|<bibfnamefont|P.<nbsp>J.>
    <bibnamefont|Knowles>>, <bibinfo|author|<bibfnamefont|R.><nbsp><bibnamefont|Lindh>>,
    <bibinfo|author|<bibfnamefont|F.<nbsp>R.> <bibnamefont|Manby>>,
    <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Schtz>>,
    <bibnamefont|et<nbsp>al.>, <em|<bibinfo|title|Molpro, version 2008.3, a
    package of ab initio programs>> (<bibinfo|year|2008>), <bibinfo|note|see
    http://www.molpro.net>.

    <bibitem-with-key|(2007)|stutt> <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Moritz>>,
    <bibinfo|author|<bibfnamefont|X.><nbsp><bibnamefont|Cao>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Dolg>>,
    <bibinfo|journal|Theor. Chem. Acc.> (<bibinfo|year|2007>),
    <bibinfo|note|<with|font-shape|italic|accepted>>.

    <bibitem-with-key|(1989)|dunning> <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|T.H.<nbsp>Dunning>>,
    <bibinfo|journal|J. Chem. Phys.> <with|font-series|bold|<bibinfo|volume|90>>,
    <bibinfo|pages|1007> (<bibinfo|year|1989>).

    <bibitem-with-key|(1992)|ccsd1> <bibinfo|author|<bibfnamefont|C.><nbsp><bibnamefont|Hampel>>,
    <bibinfo|author|<bibfnamefont|K.><nbsp><bibnamefont|Peterson>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|H.-J.>
    <bibnamefont|Werner>>, <bibinfo|journal|Chem. Phys. Letters>
    <with|font-series|bold|<bibinfo|volume|190>>, <bibinfo|pages|1>
    (<bibinfo|year|1992>).

    <bibitem-with-key|(1970)|bsse> <bibinfo|author|<bibfnamefont|S.<nbsp>F.>
    <bibnamefont|Boys>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|F.><nbsp><bibnamefont|Bernardi>>,
    <bibinfo|journal|Mol. Phys.> <with|font-series|bold|<bibinfo|volume|19>>,
    <bibinfo|pages|553> (<bibinfo|year|1970>).

    <bibitem-with-key|(2010)|sr2> <bibinfo|author|<bibfnamefont|G.<nbsp>P.>
    <bibnamefont|Yin>>, <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|Li>>,
    , <bibnamefont|and> <bibinfo|author|<bibfnamefont|K.<nbsp>T.>
    <bibnamefont|Tang>>, <bibinfo|journal|J. Chem. Phys.>
    <with|font-series|bold|<bibinfo|volume|132>>, <bibinfo|pages|074303>
    (<bibinfo|year|2010>).

    <bibitem-with-key|(2008)|stein> <bibinfo|author|<bibfnamefont|A.><nbsp><bibnamefont|Stein>>,
    <bibinfo|author|<bibfnamefont|H.><nbsp><bibnamefont|Knckel>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|E.><nbsp><bibnamefont|Tiemann>>,
    <bibinfo|journal|Phys. Rev. A> <with|font-series|bold|<bibinfo|volume|78>>,
    <bibinfo|pages|042508> (<bibinfo|year|2008>).

    <bibitem-with-key|(2005)|hao> <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Yang>>,
    <bibinfo|author|<bibfnamefont|Y.><nbsp><bibnamefont|Hao>>,
    <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Li>>,
    <bibinfo|author|<bibfnamefont|C.><nbsp><bibnamefont|Zhou>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|Y.><nbsp><bibnamefont|Mo>>,
    <bibinfo|journal|J. Chem. Phys.> <with|font-series|bold|<bibinfo|volume|122>>,
    <bibinfo|pages|134308> (<bibinfo|year|2005>).

    <bibitem-with-key|(1985)|chen> <bibinfo|author|<bibfnamefont|E.<nbsp>C.<nbsp>M.>
    <bibnamefont|Chen>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|W.<nbsp>G.> <bibnamefont|Wentworth>>,
    <bibinfo|journal|J. Phys. Chem.> <with|font-series|bold|<bibinfo|volume|89>>,
    <bibinfo|pages|4099> (<bibinfo|year|1985>).

    <bibitem-with-key|(1979)|eng79> <bibinfo|author|<bibfnamefont|F.><nbsp><bibnamefont|Engelke>>,
    <bibinfo|journal|Chem. Phys.> <with|font-series|bold|<bibinfo|volume|39>>,
    <bibinfo|pages|279> (<bibinfo|year|1979>).

    <bibitem-with-key|(1979)|herzberg> <bibinfo|author|<bibfnamefont|K.<nbsp>P.>
    <bibnamefont|Huber>> <bibnamefont|and>
    <bibinfo|author|<bibfnamefont|G.><nbsp><bibnamefont|Herzberg>>,
    <em|<bibinfo|title|Constants of Diatomic Molecules>>
    (<bibinfo|publisher|Van Nostrand Reinhold>, <bibinfo|year|1979>).

    <bibitem-with-key|(1985)|ernst> <bibinfo|author|<bibfnamefont|W.<nbsp>E.>
    <bibnamefont|Ernst>>, <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|Kandler>>,
    <bibinfo|author|<bibfnamefont|S.><nbsp><bibnamefont|Kindt>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|T.><nbsp><bibnamefont|Torring>>,
    <bibinfo|journal|Chem. Phys. Lett.> <with|font-series|bold|<bibinfo|volume|113>>,
    <bibinfo|pages|351> (<bibinfo|year|1985>).

    <bibitem-with-key|(1986)|langhoff> <bibinfo|author|<bibfnamefont|S.<nbsp>R.>
    <bibnamefont|Langhoff>>, <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|C.<nbsp>W.<nbsp>Bauschlicher>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|H.><nbsp><bibnamefont|Partridge>>,
    <bibinfo|journal|J. Chem. Phys.> <with|font-series|bold|<bibinfo|volume|84>>,
    <bibinfo|pages|1687> (<bibinfo|year|1986>).

    <bibitem-with-key|(1991)|kaupp91> <bibinfo|author|<bibfnamefont|M.><nbsp><bibnamefont|Kaupp>>,
    <bibinfo|author|<bibfnamefont|P.><nbsp><bibnamefont|v.<nbsp>R.<nbsp>Schleyer>>,
    <bibinfo|author|<bibfnamefont|H.><nbsp><bibnamefont|Stoll>>,
    <bibnamefont|and> <bibinfo|author|<bibfnamefont|H.><nbsp><bibnamefont|Preuss>>,
    <bibinfo|journal|J. Am. Chem. Soc.> <with|font-series|bold|<bibinfo|volume|113>>,
    <bibinfo|pages|6012> (<bibinfo|year|1991>).

    <bibitem-with-key|(1998)|nistSrF2> <bibinfo|author|<bibfnamefont|J.><nbsp><bibnamefont|M.<nbsp>W.<nbsp>Chase>>,
    <bibinfo|journal|J. Phys. Chem. Ref. Data>
    <with|font-series|bold|<bibinfo|volume|Monograph 9>>, <bibinfo|pages|1>
    (<bibinfo|year|1998>).

    <bibitem-with-key|(1968)|Hildenbrand68_JCP>
    <bibinfo|author|<bibfnamefont|D.<nbsp>L.> <bibnamefont|Hildenbrand>>,
    <bibinfo|journal|J. Chem. Phys.> <with|font-series|bold|<bibinfo|volume|48>>,
    <bibinfo|pages|3657> (<bibinfo|year|1968>).
  </thebibliography>
</body>