<TeXmacs|1.99.7>

<style|<tuple|article|std-latex>>

<\body>
  <\hide-preamble>
    <new-theorem|theorem|Theorem>

    <new-theorem|prop|Proposition>

    <new-theorem|lemma|Lemma>

    <new-theorem|corr|Corollary>

    <new-theorem|defi|Definition>

    <assign|E|<macro|\<bbb-E\>>>

    <assign|RR|<macro|\<bbb-R\>>>

    <assign|Z|<macro|\<bbb-Z\>>>

    <assign|PP|<macro|\<bbb-P\>>>
  </hide-preamble>

  <doc-data|<doc-title|Epidemics and vaccination on weighted
  graphs>|<doc-author|<author-data|<\author-misc>
    Department of Mathematics, Stockholm University, 106 91 Stockholm.

    Email: mia@math.su.se.
  </author-misc>|<author-name|Maria Deijfen>>>|<doc-date|November 2010>>

  <abstract-data|<\abstract>
    <no-indent>A Reed-Frost epidemic with inhomogeneous infection
    probabilities on a graph with prescribed degree distribution is studied.
    Each edge <math|<around|(|u,v|)>> in the graph is equipped with two
    weights <math|W<rsub|<around|(|u,v|)>>> and
    <math|W<rsub|<around|(|v,u|)>>> that represent the (subjective) strength
    of the connection and determine the probability that <math|u> infects
    <math|v> in case <math|u> is infected and vice versa. Expressions for the
    epidemic threshold are derived for i.i.d. weights and for weights that
    are functions of the degrees. For i.i.d. weights, a variation of the so
    called acquaintance vaccination strategy is analyzed where vertices are
    chosen randomly and neighbors of these vertices with large edge weights
    are vaccinated. This strategy is shown to outperform the strategy where
    the neighbors are chosen randomly in the sense that the basic
    reproduction number is smaller for a given vaccination coverage.

    <no-indent><vspace|0.5cm>

    <no-indent><em|Keywords:> Reed-Frost epidemic, weighted graph, degree
    distribution, epidemic threshold, vaccination. <vspace|0.5cm>

    <no-indent>AMS 2000 Subject Classification: 92D30, 05C80.
  </abstract>>

  <thispagestyle|empty>

  <section|Introduction>

  The Reed-Frost model is one of the simplest stochastic epidemic models. It
  was formulated by Lowell Reed and Wade Frost in 1928 (in unpublished work)
  and describes the evolution of an infection in generations. Each infected
  individual in generation <math|t> (<math|t=1,2,\<ldots\>>) independently
  infects each susceptible individual in the population with some probability
  <math|p>. The individuals that become infected by the individuals in
  generation <math|t> then constitute generation <math|t+1> and the
  individuals in generation <math|t> are removed from the epidemic process.
  See <cite|vBML> for a description of the asymptotic (as the population size
  grows to infinity) behavior of the process.

  In the original version, an infective individual infects each susceptible
  individual in the population with the same probability. Realistically
  however an infective individual has the possibility to infect only those
  individuals with whom she actually has some kind of social contact. The
  Reed-Frost model is easily modified to capture this by introducing a graph
  to represent the social structure in the population and then let the
  infection spread on this graph. More precisely, an infective individual
  infects each neighbor in the graph independently with some probability
  <math|p>.

  When analyzing epidemics on graphs, the graph is usually taken to be
  unweighted with respect to the infection, that is, transmission takes place
  along all edges with the same probability. In this paper however,
  inhomogeneity will be incorporated in the transmission probability by aid
  of weights on the edges. More precisely, each edge <math|<around|(|u,v|)>>
  in the graph is assigned two weights <math|W<rsub|<around|(|u,v|)>>> and
  <math|W<rsub|<around|(|v,u|)>>> that are assumed to take values in [0,1].
  The probability that <math|u> infects <math|v> if <math|u> gets infected is
  then given by <math|W<rsub|<around|(|u,v|)>>> and vice versa. Note that it
  may well be that <math|W<rsub|<around|(|u,v|)>>\<neq\>W<rsub|<around|(|v,u|)>>>.
  We shall mainly consider i.i.d. weights, although we briefly treat weights
  that are determined by the degrees of the vertices in Section 3.

  To describe the underlying network, we shall use the so called
  configuration model <cite|MR-95|MR-98>. Once the graph has been generated,
  each edge is equipped with two weights as described above. Basically, the
  configuration model takes a probability distribution with support on
  positive integers as input and generates a graph with this particular
  degree distribution; see Section 2 for further details. The degree
  distribution is indeed an important characteristic of a network with a
  large impact on the properties of the network and it is therefore desirable
  to be able to control this in a graph model. Furthermore, the configuration
  model exhibits short distances between the vertices, which is in agreement
  with empirical findings; see <cite|vHHvM>. Epidemics on un-weighted graphs
  generated by the configuration model has previously been studied in
  <cite|A-98|A-99|BJML>. Related results have also appeared in the physics
  literature <cite|N>.

  An important quantity in epidemic modeling is the epidemic threshold,
  commonly denoted by <math|R<rsub|0>>. It is defined as a function of the
  parameters of the model such that a large outbreak in the epidemic has
  positive probability if and only if <math|R<rsub|0>\<gtr\>1>. Expressions
  for <math|R<rsub|0>> typically stems from branching process approximations
  of the initial stages of the epidemic. It is well-known from branching
  process theory that the process has a positive probability of exploding if
  and only if the expected number of children of an individual exceeds 1. A
  natural candidate for <math|R<rsub|0>> is hence the expected number of new
  cases caused by a typical infective in the beginning of the time course.
  For this reason, the epidemic threshold is often referred to as the basic
  reproduction number.

  The main goal of the paper is to study how the epidemic threshold is
  affected by vaccination strategies based on the edges weights. To this end,
  we assume that a perfect vaccine is available that completely removes
  vaccinated individuals from the epidemic process. The simplest possible
  vaccination strategy, usually referred to as random vaccination, is to draw
  a random sample from the population and then vaccinate the corresponding
  individuals. An alternative, known as acquaintance vaccination, is to
  choose individuals randomly and then, for each chosen individual, vaccinate
  a random neighbor rather than the individual itself <cite|CHbA|BJML>. The
  idea is that, by doing this, individuals with larger degrees are
  vaccinated. We shall study a version of acquaintance vaccination where,
  instead of vaccinating a random neighbor, the neighbor with the largest
  weight on its edge from the sampled vertex is vaccinated. In a human
  population, this correspond to asking individuals to name their
  <em|closest> friend (in some respect) instead of just naming a random
  friend. It is demonstrated that this is more efficient than standard
  acquaintance vaccination, in the sense that the basic reproduction number
  with the weight based strategy is smaller for a given vaccination coverage.

  Throughout this paper we shall use the term \Pinfection\Q to refer to the
  phenomenon that is spreading on the network. We remark that this does not
  necessarily consist of an infectious disease spreading in a human
  population, but may also refer to other infectious phenomena such as a
  computer virus spreading in a computer network, information routed in a
  communication net or a rumor growing in a social media. In many of these
  situations the connections are indeed highly inhomogeneous. Furthermore,
  depending on what type of spreading phenomenon that is at hand, the term
  vaccination can refer to different types of immunization.

  Epidemics on weighted graphs have been very little studied so far and there
  are few theoretical results. See however <cite|N> for an approach based on
  generating function and <cite|Gang|Schumm> for simulation studies. We
  mention also the recent work on first passage percolation on random graphs
  by Bhamidi et al. <cite|BvHH:1|BvHH:2|BvHH:3>. There, each edge in a graph
  generated according to the configuration model is equipped with an
  exponential weight and the length and weight of the weight-minimizing path
  between two vertices are studied. Interpreting the weights as the traversal
  times for an infection, this can be related to the time-dynamics of an
  epidemic.

  The rest of the paper is organized so that the graph model and the epidemic
  model are described in more detail in Section 2. In Section 3, expressions
  for the epidemic thresholds are given and calculated for some specific
  weight distributions. Section 4 is devoted to vaccination: In Section 4.1,
  a weight based acquaintance vaccination strategy for weights with a
  continuous distribution is described and an expression for the epidemic
  threshold is derived. Section 4.2 treats a strategy for a two-point weight
  distribution. The findings are summarized in Section 5, where also some
  directions for further work are given. We shall throughout refrain from
  giving rigorous details for the underlying branching process
  approximations, but instead focus on heuristic derivations of the epidemic
  quantities. Indeed, what needs to be proved is basically that the branching
  process approximations hold long enough so that conclusions for the
  branching processes are valid also for the epidemic processes. This however
  is not affected by weights on edges (as long as these are not functions of
  the structure of the graph) and hence rigorous details can presumably be
  filled in by straightforward modifications of the arguments in <cite|BJML>
  (the degree based weights mentioned in Section 3 might however require some
  more work).

  <section|Description of the model>

  We consider a population of size <math|n> represented by <math|n> vertices.
  The graph representing the connections in the population is generated by
  the configuration model. To produce the graph, a probability distribution
  with support on the non-negative integers is fixed and each vertex <math|u>
  is independently equipped with a random number of half-edges
  <math|D<rsub|u>> according to this distribution. These half-edges are then
  paired randomly to create the edges in the graph, that is, first two
  half-edges are picked at random and joined, then another two half-edges are
  picked at random from the set of remaining half-edges and joined, etc. If
  the total number of half-edges is odd, a half-edge is added at a randomly
  chosen vertex to pair with the last half-edge.

  This procedure gives a multi-graph, that is, a graph where self-loops and
  multiple edges between vertices may occur. If <math|D> has finite second
  moment however, there will not be very many of these imperfections. In
  particular, the probability that the resulting graph is simple will be
  bounded away from 0 as <math|n\<to\>\<infty\>>; see <cite-detail|BJML|Lemma
  5.5> or <cite-detail|vH|Theorem 7.10>. If <math|D> has finite second moment
  we can hence condition on the event that the graph is simple, and work
  under this assumption. Another option is to erase self-loops and merge
  multiple edges, which asymptotically does not affect the degree
  distribution if <math|D> has finite second moment; see
  <cite-detail|vH|Theorem 7.9>. Henceforth we shall hence assume that
  <math|D> has finite second moment and ignore self-loops and multiple edges.

  When the graph has been generated, each edge <math|<around|(|u,v|)>> is
  assigned two weights <math|W<rsub|<around|(|u,v|)>>> and
  <math|W<rsub|<around|(|v,u|)>>> that are assumed to take values in [0,1].
  This can be thought of as if each one of the half-edges that is used to
  create the edge independently receives a weight. The epidemic spread is
  initiated in that one randomly chosen vertex is infected. This vertex
  constitutes generation 1. The epidemic then propagates in that each vertex
  <math|u> in generation <math|t> (<math|t=1,2,\<ldots\>>) infects each
  susceptible neighbor <math|v> independently with probability
  <math|W<rsub|<around|(|u,v|)>>>. Generation <math|t+1> then consists of the
  vertices that are infected by the vertices in generation <math|t> and the
  vertices in generation <math|t> are removed from the epidemic process.

  We shall mainly restrict to the case where the weights are taken to be
  independent. However, we mention also the possibility to let them be
  functions of the degrees of the vertices:<vspace|1fn>

  <no-indent><with|font-series|bold|Independent weights.> The weights are
  taken to be i.i.d. copies of a random variable <math|W> that takes values
  in [0,1]. The distribution of <math|W> can be defined in many different
  ways:

  <\itemize>
    <item*|<math|\<bullet\>>>As an intrinsic distribution on [0,1], for
    instance a uniform distribution or, more generally, a Beta distribution.

    <item*|<math|\<bullet\>>>By letting <math|N> be an integer valued random
    variable, indicating for instance how many times a given vertex contacts
    a given neighbor during some time period, and then setting
    <math|W<above|=|d>1-<around|(|1-p|)><rsup|N>>, with
    <math|p\<in\><around|[|0,1|]>> denoting the probability of infection at a
    given contact.

    <item*|<math|\<bullet\>>>By, similarly, letting <math|X> be a positive
    random variable, interpreted as the (subjective) strength of a
    connection, and then for instance setting
    <math|W<above|=|d><with|math-font-family|bf|1>*<around|{|X\<geq\>\<theta\>|}>>
    for some <math|\<theta\>\<geq\>0> or <math|W<above|=|d>1-\<alpha\><rsup|X>>
    for <math|\<alpha\>\<in\><around|[|0,1|]>>. Alternatively, <math|X> could
    be interpreted as the resistance involved in a connection and <math|W>
    modeled as a decreasing function of <math|X>.
  </itemize>

  <no-indent><with|font-series|bold|Degree dependent weights.> The weights of
  an edge <math|<around|(|u,v|)>> could also be modeled as functions of
  <math|D<rsub|u>> and <math|D<rsub|v>>. We shall consider the case when
  <math|W<rsub|<around|(|u,v|)>>=g<around|(|D<rsub|u>|)>> for some function
  <math|g> that takes values in [0,1]. All outgoing edges from <math|u> hence
  have the same weight, and independent trials with this success probability
  determine whether the edges are used to transmit infection. With <math|g>
  increasing, this setup means that vertices with large degree have a larger
  probability of infecting their neighbors, for instance in that they tend to
  be more active. With <math|g> decreasing, high degree vertices are instead
  less likely to infect their neighbors, which might be the case for instance
  in a situation where high degree vertices have weaker bonds to their
  acquaintances.

  <section|Epidemic threshold>

  As mentioned in the introduction, expressions for epidemic thresholds
  usually come from branching process approximations of the initial stages of
  an epidemic. As for epidemics on graphs, branching process approximations
  are typically in force as soon as the graph is tree-like, that is, if with
  high probability the graph does not contain short cycles. This means that
  the neighbors of a given infective in the beginning of the time course are
  susceptible with high probability and hence the initial stages of the
  generation process of infectives is well approximated by a branching
  process. Under the assumption that the degree distribution has finite
  second moment, the configuration model is indeed tree-like, allowing for
  such an approximation; see e.g. <cite|vHHvM|BJML> for details. The epidemic
  threshold is then given by the reproduction mean in the approximating
  branching process, which in turn is given by the expected number of new
  cases generated by an infective vertex in the beginning of the epidemic.
  When calculating this, one should not consider the initial infective, since
  this vertex might be atypical, but rather an infective vertex in, say, the
  second generation.

  Let <math|<around|{|p<rsub|k>|}><rsub|k\<geq\>0>> be the probabilities
  defining the degree distribution in the configuration model. Then the
  initial infective has degree distribution <math|<around|{|p<rsub|k>|}>>,
  while the neighbors of this vertex have the size biased degree distribution
  <math|<around|{|<wide|p|~><rsub|k>|}>> defined by

  <\equation*>
    <wide|p|~><rsub|k>=<frac|k*p<rsub|k>|\<mu\>>,
  </equation*>

  where <math|\<mu\>=<big|sum>k*p<rsub|k>> denotes the mean degree. The
  infective vertices in the second (and later) generations hence have degree
  distribution <math|<around|{|<wide|p|~><rsub|k>|}>>. Denote by
  <math|<wide|D|~>> a random variable with this distribution.<vspace|1fn>

  <no-indent><with|font-series|bold|Independent weights.> Consider an
  infected vertex in the second generation. One neighbor of this vertex must
  have transmitted the infection and can hence not get reinfected, while the
  other neighbors are with high probability susceptible. The number of new
  cases generated by the vertex is hence distributed as

  <\equation>
    <label|eq:new><big|sum><rsub|i=1><rsup|<wide|D|~>-1><with|math-font-family|bf|1><around|{|<text|neighbor
    <math|i> infected>|}>.
  </equation>

  If the weights are i.i.d. copies of <math|W>, then the mean of the
  indicators is <math|\<gamma\>\<assign\><E><around|[|W|]>> and we get

  <\equation*>
    R<rsub|0>=\<gamma\><E><around|[|<wide|D|~>-1|]>=\<gamma\>*<around*|(|\<mu\>+<frac|<text|Var><around|(|D|)>-\<mu\>|\<mu\>>|)>.
  </equation*>

  In this case the epidemic threshold is hence the same as in a model with
  constant infection probability <math|p=\<gamma\>> ; see <cite|A-99|BJML>.
  Note that, for degree distributions with large variance, <math|R<rsub|0>>
  can be large even if <math|\<mu\>> is small. Also note that the above
  reasoning remains valid in a situation where the weights
  <math|W<rsub|<around|(|u,v|)>>> and <math|W<rsub|<around|(|v,u|)>>> on a
  given edge are correlated, as long as the weights are independent between
  edges. In fact, as long as the transmission between separate links are
  i.i.d., the whole epidemic process is equivalent to a Reed Frost model (on
  the configuration model) with <math|p=<E><around|[|W|]>>.<vspace|1fn>

  <no-indent><with|font-series|bold|Degree dependent weights.> Assume that
  <math|W<rsub|<around|(|u,v|)>>=g<around|(|D<rsub|u>|)>>. Since
  <math|W<rsub|<around|(|u,v|)>>> does not depend on <math|D<rsub|v>>, the
  degree distribution of an infective in the second generation is
  <math|<around|{|<wide|p|~><rsub|k>|}>>. Conditionally on its degree
  <math|<wide|D|~>=<wide|d|~>>, the number of new cases generated by an
  infective in the second generation is Bin(<math|<wide|d|~>-1,g<around|(|<wide|d|~>|)>>)-distributed.
  It follows that

  <\equation*>
    R<rsub|0><rsup|d*e*g>=<E><around|[|<around|(|<wide|D|~>-1|)>*g<around|(|<wide|D|~>|)>|]>.
  </equation*>

  Let <math|R<rsub|0><rsup|h*1>> denote the basic reproduction number for an
  epidemic with a homogeneous infection probability given by the transmission
  probability <math|<E><around|[|g<around|(|<wide|D|~>|)>|]>> for a randomly
  chosen half-edge, that is,

  <\equation*>
    R<rsup|h*1><rsub|0>=<E><around|[|g<around|(|<wide|D|~>|)>|]><E><around|[|<wide|D|~>-1|]>.
  </equation*>

  When <math|g> is an increasing function we have
  <math|R<rsub|0><rsup|d*e*g>\<geq\>R<rsub|0><rsup|h*1>>, due to the positive
  correlation between <math|g<around|(|<wide|D|~>|)>> and <math|<wide|D|~>>,
  while, if <math|g> is decreasing, then <math|R<rsub|0><rsup|d*e*g>\<leq\>R<rsub|0><rsup|h*1>>.
  Another comparison that might be relevant is to relate
  <math|R<rsub|0><rsup|d*e*g>> to the basic reproduction number for an
  epidemic with a homogeneous infection probability given by
  <math|<E><around|[|g<around|(|D|)>|]>>, that is, an epidemic where the
  infection probability <math|g<around|(|D|)>> for a vertex with degree
  <math|D> is averaged over all possible degrees. The basic reproduction
  number in such an epidemic is given by

  <\equation*>
    R<rsub|0><rsup|h*2>=<E><around|[|<wide|D|~>-1|]><E><around|[|g<around|(|D|)>|]>.
  </equation*>

  <no-indent><with|font-series|bold|Example 3.1.> First take <math|D\<sim\>>
  Po(<math|\<mu\>>). It is not hard to see that then
  <math|<wide|p|~><rsub|k>=p<rsub|k-1>>. Take
  <math|g<around|(|x|)>=<with|math-font-family|bf|1>*<around|{|x\<geq\>\<theta\>|}>>.
  If <math|W<rsub|<around|(|u,v|)>>=g<around|(|D<rsub|u>|)>>, this means that
  only vertices with degree at least <math|\<theta\>> transmit the infection.
  We have

  <\equation*>
    <E><around|[|<with|math-font-family|bf|1>*<around|{|<wide|D|~>\<geq\>\<theta\>|}>|]>=<PP><around|(|D\<geq\>\<theta\>-1|)>
  </equation*>

  and

  <\equation*>
    <E><around|[|<around|(|<wide|D|~>-1|)>*<with|math-font-family|bf|1>*<around|{|<wide|D|~>\<geq\>\<theta\>|}>|]>=<big|sum><rsub|k\<geq\>\<theta\>><around|(|k-1|)>*<frac|k*p<rsub|k>|\<mu\>>=<big|sum><rsub|k\<geq\>\<theta\>><frac|\<mu\><rsup|k-1>|<around|(|k-2|)>!>*e<rsup|-\<mu\>>=\<mu\><PP><around|(|D\<geq\>\<theta\>-2|)>.
  </equation*>

  Hence

  <\equation*>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|R<rsub|0><rsup|h*2>>|<cell|=>|<cell|\<mu\><PP><around|(|D\<geq\>\<theta\>|)>>>|<row|<cell|R<rsub|0><rsup|h*1>>|<cell|=>|<cell|\<mu\><PP><around|(|D\<geq\>\<theta\>-1|)>>>|<row|<cell|R<rsub|0><rsup|d*e*g>>|<cell|=>|<cell|\<mu\><PP><around|(|D\<geq\>\<theta\>-2|)>.>>>>>
  </equation*>

  With <math|g<around|(|x|)>=\<alpha\><rsup|x>> for
  <math|\<alpha\>\<in\><around|(|0,1|)>>, we get

  <\equation*>
    <E><around|[|\<alpha\><rsup|D>|]>=e<rsup|-\<mu\>*<around|(|1-\<alpha\>|)>><space|1em><text|and><space|1em><E><around|[|\<alpha\><rsup|<wide|D|~>>|]>=\<alpha\>*e<rsup|-\<mu\>*<around|(|1-\<alpha\>|)>>.
  </equation*>

  Furthermore

  <\equation*>
    <E><around|[|<around|(|<wide|D|~>-1|)>*\<alpha\><rsup|<wide|D|~>>|]>=<big|sum><rsub|k\<geq\>1><around|(|k-1|)>*\<alpha\><rsup|k>*<frac|k*p<rsub|k>|\<mu\>>=\<alpha\><rsup|2>*<big|sum><rsub|k\<geq\>0>\<alpha\><rsup|k>*p<rsub|k>=\<alpha\><rsup|2>*e<rsup|-\<mu\>*<around|(|1-\<alpha\>|)>>.
  </equation*>

  Hence

  <\equation*>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|R<rsub|0><rsup|h*2>>|<cell|=>|<cell|\<mu\>*e<rsup|-\<mu\>*<around|(|1-\<alpha\>|)>>>>|<row|<cell|R<rsub|0><rsup|h*1>>|<cell|=>|<cell|\<mu\>*\<alpha\>*e<rsup|-\<mu\>*<around|(|1-\<alpha\>|)>>>>|<row|<cell|R<rsub|0><rsup|d*e*g>>|<cell|=>|<cell|\<mu\>*\<alpha\><rsup|2>*e<rsup|-\<mu\>*<around|(|1-\<alpha\>|)>>.>>>>>
  </equation*>

  <htab|0pt><math|\<Box\>><vspace|1fn>

  <no-indent><with|font-series|bold|Example 3.2.> Now take a distribution
  with <math|p<rsub|k>\<sim\>c*k<rsup|-3.5>>. In this case exact computations
  are out of reach but numerical values of the thresholds are easily
  obtained. We give an example with <math|g<around|(|x|)>=x<rsup|-\<tau\>>>
  for <math|\<tau\>\<in\><around|[|0,1|]>>. The initial degrees in the graph
  have been modified to give a mean of 4. In Figure 1, the basic reproduction
  numbers are plotted against <math|\<tau\>>, showing that
  <math|R<rsub|0><rsup|h*2>\<gtr\>R<rsub|0><rsup|h*1>\<gtr\>R<rsub|0><rsup|d*e*g>>.
  The homogeneous epidemics remain supercritical (that is, their reproduction
  numbers exceed 1) at <math|\<tau\>=1>, while the epidemic with degree
  dependent weights becomes subcritical for <math|\<tau\>> close to 1.
  Indeed, the degree dependent epidemic is subcritical at <math|\<tau\>=1>
  for any degree distribution.<htab|0pt><math|\<Box\>><vspace|1fn>

  <\big-figure>
    <text|<image|trosklar.eps|0.8tex-text-width|0.35tex-text-height||>>

    \;
  </big-figure|The basic reproduction numbers <math|R<rsub|0><rsup|h*2>>
  (solid line), <math|R<rsub|0><rsup|h*1>> (dashed line) and
  <math|R<rsub|0><rsup|d*e*g>> (dash-dotted line) with
  <math|g<around|(|x|)>=x<rsup|-\<tau\>>> plotted against <math|\<tau\>>. The
  degree distribution is a power law with exponent 3.5 and mean 4.>

  For the remainder of the paper we shall restrict to the case with
  independent weights.

  <section|Vaccination>

  We now proceed to analyze a version of the so called acquaintance
  vaccination strategy. To this end, suppose that a perfect vaccine is
  available that prevents vaccinated vertices from participating in the
  epidemic process and that this vaccine is distributed prior to the start of
  the epidemic. More precisely, first we generate the underlying graph and
  assign the edge weights, then we choose which vertices that are to be
  vaccinated and finally, when the vaccine has been distributed, we analyze
  the epidemic spread among the unvaccinated vertices.

  The simplest vaccination scheme is to vaccinate each vertex independently
  with some probability <math|v>. We shall refer to this as uniform
  vaccination and write <math|R<rsub|v><rsup|<verbatim|U>>> for the
  corresponding basic reproduction number. By reasoning as in the case
  without vaccination and keeping in mind that only unvaccinated vertices can
  be infected, it is not hard to see that <math|R<rsub|v><rsup|<verbatim|U>>>
  is obtained by multiplying the expression for the case without vaccination
  with <math|<around|(|1-v|)>>, that is,

  <\equation>
    <label|eq:RvU>R<rsub|v><rsup|<verbatim|U>>=<around|(|1-v|)>*\<gamma\>*<around*|(|\<mu\>+<frac|<text|Var><around|(|D|)>-\<mu\>|\<mu\>>|)>.
  </equation>

  An alternative strategy, referred to as acquaintance vaccination, is to
  vaccinate neighbors of the chosen vertices rather than the vertices
  themselves; see <cite|CHbA>. More precisely, each vertex is sampled
  independently with probability <math|s> and, for each sampled vertex, a
  randomly chosen neighbor is vaccinated. A neighbor that is chosen via more
  than one vertex is (of course) vaccinated only once. The fact that two
  vertices can both pick a common neighbor to receive vaccination means that
  the asymptotic fraction of vaccinated vertices <math|v<around|(|s|)>>,
  referred to as the <em|vaccination coverage>, is smaller than <math|s>. In
  fact, in many cases it is not possible to push an epidemic below
  criticality (that is, to obtain a basic reproduction number smaller than 1)
  even when <math|s=1>. This motivates a strategy where a vertex can be
  sampled more than once and thereby have more than one neighbor vaccinated.

  In <cite|BJML>, a strategy is analyzed where each vertex is sampled
  independently a Po(<math|\<beta\>>) number of times and each time a vertex
  is sampled, a randomly chosen neighbor is vaccinated. When there are
  weights on the edges however, more efficient strategies are possible. Here
  we shall consider strategies where, rather than choosing neighbors randomly
  for vaccination, neighbors with large weights on their edges from the
  sampled vertices are chosen. We treat the case with independent directed
  weights. In Section 4.1, the weights are assumed to come from a continuous
  distribution and Section 4.2 is devoted to a strategy for two-point
  distributions.

  <subsection|Weight based acquaintance vaccination: continuous weights>

  Assume that the directed edge weights are i.i.d. realizations from a
  continuous probability distribution on [0,1]. Each vertex <math|u> is
  sampled independently a Po(<math|\<beta\>>) number of times. Write
  <math|\<cal-N\><rsub|u>> for the set of neighbors of a vertex <math|u> and,
  for <math|i=1,\<ldots\>,<around|\||\<cal-N\><rsub|u>|\|>>, let
  <math|v<rsub|i>\<in\>\<cal-N\><rsub|u>> be the vertex corresponding to the
  <math|i>:th largest element in <math|<around|{|W<rsub|<around|(|u,v|)>>:v\<in\>\<cal-N\><rsub|u>|}>>
  (note that <math|v<rsub|i>> is almost surely unique, since the weights are
  assumed to come from a continuous distribution). Then, if <math|u> is
  sampled <math|i\<leq\>D<rsub|u>> times, the neighbors
  <math|v<rsub|1>,\<ldots\>,v<rsub|i>> are vaccinated. If
  <math|i\<geq\>D<rsub|u>>, all neighbors of <math|u> are vaccinated and, if
  <math|D<rsub|u>=0>, no action is taken. This will be referred to as weight
  based acquaintance vaccination.

  To derive an expression for the vaccinated fraction
  <math|v<around|(|\<beta\>|)>> of the population, let <math|V\<sim\>>
  Po<math|<around|(|\<beta\>|)>> represent the number of times that a given
  vertex is sampled. The probability that a randomly chosen vertex <math|u>
  is not chosen for vaccination by a given neighbor with degree <math|k> is
  given by

  <\equation>
    <label|eq:r>r<rsub|k>=<big|sum><rsub|i=0><rsup|k-1><PP><around|(|V=i|)>*<around*|(|1-<frac|i|k>|)>.
  </equation>

  Since the neighbors of <math|u> have degree distribution
  <math|<around|{|<wide|p|~><rsub|k>|}>>, the probability that <math|u>
  avoids being chosen for vaccination by a given neighbor equals

  <\equation*>
    \<alpha\>=<big|sum><rsub|k\<geq\>1>r<rsub|k>*<wide|p|~><rsub|k>.
  </equation*>

  If <math|u> has degree <math|j>, then the probability that <math|u> is not
  vaccinated is <math|\<alpha\><rsup|j>>. The degree distribution of <math|u>
  is <math|<around|{|p<rsub|j>|}>> and, since the fraction of unvaccinated
  vertices coincides with the probability that a randomly chosen vertex is
  not vaccinated, we obtain <math|v<around|(|\<beta\>|)>> from the equation

  <\equation*>
    1-v<around|(|\<beta\>|)>=<big|sum><rsub|j\<geq\>0>\<alpha\><rsup|j>*p<rsub|j>.
  </equation*>

  Next, to identify the epidemic threshold in a population vaccinated
  according to the weight based acquaintance strategy, we shall employ a
  branching process approximation of the initial stages of the epidemic. The
  process however is slightly more complicated than in the case with uniform
  vaccination, and this is because the knowledge that an edge has not been
  used for vaccination carries information of the degrees of the
  corresponding vertices. The process is analogous to the one used in
  <cite|BJML>. To describe it, say that a directed edge
  <math|<around|(|u,w|)>> is <em|used for vaccination> if <math|u> is sampled
  and chooses the neighbor <math|w> for vaccination. Furthermore,
  conditionally on the weight, a directed edge is said to be <em|open for
  transmission> if a bernoulli trial with success probability given by the
  weight of the edge results in a success. A directed edge that is not used
  for vaccination and that is open for transmission is called <em|dangerous>.

  An \Pindividual\Q in the branching process now consists of an unvaccinated
  vertex <math|u> along with a dangerous outgoing edge
  <math|<around|(|u,w|)>>. The individual then gives birth to a new
  individual if the vertex <math|w> is unvaccinated and in turn has a
  dangerous edge <math|<around|(|w,w<rprime|'>|)>> pointing out from it. Note
  that an unvaccinated vertex can hence give rise to several individuals (if
  it has more than one outgoing dangerous edge) or no individuals at all (if
  it does not have any outgoing dangerous edges). Furthermore, the
  individuals reproduce independently.

  It is not hard to see that the epidemic has a positive probability of
  taking off if and only if the above branching process has a positive
  probability of exploding: With positive probability the initial infective
  in unvaccinated and with positive probability it has at least one dangerous
  out-edge. The propagation of the epidemic from the vertices that are hit by
  these dangerous edges is then approximated by the above branching process.
  To find an expression for the reproduction mean of the process, consider a
  given unvaccinated vertex <math|u> along with an outgoing dangerous edge
  <math|<around|(|u,w|)>>. How many new individuals does this give rise to?
  First, the degree distribution of <math|w>, which is size biased, is now
  affected also by the information that the edge <math|<around|(|w,u|)>> has
  not been used for vaccination. Write <math|A> for the latter event and
  <math|<PP><rsub|A>> and <math|<E><rsub|A>> for probability and expectation
  respectively conditionally on <math|A>. We get

  <\equation*>
    <PP><rsub|A><around|(|D<rsub|w>=k|)>=<frac|r<rsub|k>*<wide|p|~><rsub|k>|<big|sum>r<rsub|k>*<wide|p|~><rsub|k>>=<frac|r<rsub|k>*<wide|p|~><rsub|k>|\<alpha\>>,
  </equation*>

  where <math|r<rsub|k>> is defined in (<reference|eq:r>). If <math|w> has
  degree <math|k>, then the probability that <math|w> is not chosen for
  vaccination by any of its other <math|k-1> neighbors (apart from <math|u>
  that, by assumption, does not have a dangerous edge to <math|w>) is
  <math|\<alpha\><rsup|k-1>>. Write <math|H> for the number of dangerous
  edges <math|<around|(|w,w<rprime|'>|)>> with <math|w<rprime|'>\<neq\>u>.
  Note that, conditionally on the degree of <math|w>, the event that <math|w>
  is unvaccinated (which carries information on the in-weights of <math|w>)
  does not affect <math|H> (which is determined by the out-weights of
  <math|w>). The reproduction mean of the branching process is hence given by

  <\equation>
    <label|eq:RbW>R<rsub|\<beta\>><rsup|<verbatim|W>>=<big|sum><rsub|k\<geq\>2><PP><rsub|A><around|(|D<rsub|w>=k|)>*\<alpha\><rsup|k-1><E><rsub|A,k><around|[|H|]>,
  </equation>

  where <math|<E><rsub|A,k><around|[|H|]>\<assign\><E><rsub|A><around|[|H\|D<rsub|w>=k|]>>
  (below we use <math|<PP><rsub|A,k>> to denote the corresponding probability
  and <math|<PP><rsub|k>> to denote probability conditional only on that
  <math|D<rsub|w>=k>). It remains to quantify this expectation. Clearly
  <math|H> is affected by the number of times <math|V<rsub|w>> that <math|w>
  is sampled to name a neighbor in the vaccination procedure, which in turn
  is affected by the information that <math|<around|(|w,u|)>> was not used
  for vaccination. Specifically, when <math|D<rsub|w>=k>, we have, for
  <math|i=0,\<ldots\>,k-1>, that

  <eqnarray*|<tformat|<table|<row|<cell|<PP><rsub|A,k><around|(|V<rsub|w>=i|)>>|<cell|=>|<cell|<frac|<PP><rsub|k><around|(|A\|V<rsub|w>=i|)><PP><rsub|k><around|(|V<rsub|w>=i|)>|<PP><rsub|k><around|(|A|)>>>>|<row|<cell|>|<cell|=>|<cell|<frac|<around*|(|1-<frac|i|k>|)><PP><around|(|V<rsub|w>=i|)>|r<rsub|k>>.>>>>>

  Let <math|W<rsup|<around|(|k|)>><rsub|j>> denote a random variable
  distributed as the <math|j>:th smallest in a collection of <math|k>
  independent weight variables. If <math|V<rsub|w>=i>
  (<math|i=1,\<ldots\>,k-1>), then the out-edges with the <math|i> largest
  weights are used for vaccination. The remaining <math|k-i> out-edges are
  dangerous with a probability given by the expectation of their weights.
  Note however that we do not want to count the edge to <math|u>, whose
  weight indeed belongs to the <math|k-i> smallest since, by assumption, it
  is not used for vaccination. The ordering of the weight on the edge to
  <math|u> among the remaining <math|k-i> out-weights is uniform on
  <math|<around|{|1,\<ldots\>,k-i|}>>. We obtain

  <\equation>
    <label|eq:vvHk><E><rsub|A,k><around|[|H\|V<rsub|w>=i|]>=<around*|(|1-<frac|1|k-i>|)>*<big|sum><rsub|j=1><rsup|k-i><E><around|[|W<rsup|<around|(|k|)>><rsub|j>|]>.
  </equation>

  Note that, if <math|V<rsub|w>=0>, then each one of the <math|k-1> out-edges
  from <math|w> to <math|\<cal-N\><rsub|w>\<setminus\><around|{|u|}>> is
  dangerous independently with probability <math|\<gamma\>>, and the above
  expression reduces to <math|<around|(|k-1|)>*\<gamma\>>. If
  <math|V<rsub|w>\<geq\>k-1>, then all out-edges (except
  <math|<around|(|w,u|)>>) are used for vaccination meaning that there are no
  dangerous out-edges. Hence

  <\equation*>
    <E><rsub|A,k><around|[|H|]>=<big|sum><rsub|i=0><rsup|k-2><PP><rsub|A,k><around|(|V<rsub|w>=i|)><E><rsub|A,k><around|[|H\|V<rsub|w>=i|]>.
  </equation*>

  This concludes the derivation of the reproduction mean
  (<reference|eq:RbW>).

  Calculating the reproduction mean involves calculating expectations of
  order statistics (c.f. (<reference|eq:vvHk>)). Finding analytical
  expressions for such expectations is typically not possible. However, the
  density of the <math|j>:th smallest observation in a collection of <math|k>
  i.i.d. variables with density <math|f> and distribution function <math|F>
  is given by

  <\equation>
    <label|eq:ord>f<rsub|k,j><around|(|x|)>=<frac|\<Gamma\>*<around|(|k+1|)>|\<Gamma\><around|(|j|)>*\<Gamma\>*<around|(|k+1-j|)>><around|(|F<around|(|x|)>|)><rsup|j-1>*<around|(|1-F<around|(|x|)>|)><rsup|k-j>*f<around|(|x|)>,
  </equation>

  where <math|\<Gamma\><around|(|\<cdummy\>|)>> denotes the gamma function.
  For a given weight distribution <math|F>, the mean can hence be calculated
  by aid of numerical integration. A particularly easy case is when the
  weights are uniform on [0,1]. Then

  <\equation*>
    W<rsub|j><rsup|<around|(|k|)>>\<sim\><text|Beta><around|(|j,k+1-j|)>
  </equation*>

  so that <math|<E><around|[|W<rsub|j><rsup|<around|(|k|)>>|]>=j/<around|(|k+1|)>>,
  and hence

  <\equation>
    <label|eq:uni><E><rsub|A,k><around|[|H\|V<rsub|w>=i|]>=<around*|(|1-<frac|1|k-i>|)>*<big|sum><rsub|j=1><rsup|k-i><frac|j|k+1>=<frac|<around|(|k-i-1|)>*<around|(|k-i+1|)>|2*<around|(|k+1|)>>.
  </equation>

  We now want to compare the epidemic threshold for the weight based strategy
  to the threshold for the standard acquaintance vaccination strategy, where
  neighbors are chosen randomly. In <cite|BJML>, the vaccination coverage
  <math|v<around|(|\<beta\>|)>> for the latter strategy is shown to be given
  by

  <\equation*>
    1-v<around|(|\<beta\>|)>=<big|sum><rsub|j\<geq\>0>\<alpha\><rsup|j>*p<rsub|j>
  </equation*>

  with <math|\<alpha\>=<big|sum>e<rsup|-\<beta\>/k>*<wide|p|~><rsub|k>>.
  Furthermore, for a homogeneous infection probability <math|p>, the basic
  reproduction number is shown to be

  <\equation>
    <label|eq:RbA>R<rsub|\<beta\>><rsup|<verbatim|A>>=p*<big|sum><rsub|k\<geq\>2><around|(|k-1|)>*\<alpha\><rsup|k-2>*e<rsup|-2*\<beta\>/k>*<wide|p|~><rsub|k>.
  </equation>

  Straightforward modifications of the arguments leading up to these
  expressions reveals that they apply also for the inhomogeneous case with
  independent weights, with <math|p> replaced by the mean weight
  <math|\<gamma\>>.<vspace|1fn>

  <no-indent><with|font-series|bold|Example 4.1.1.> Let the edge weights be
  uniformly distributed on <math|<around|[|0,1|]>>. Then <math|\<gamma\>=1/2>
  and, using (<reference|eq:uni>), the reproduction mean
  <math|R<rsub|\<beta\>><rsup|<verbatim|W>>> in (<reference|eq:RbW>) is
  easily calculated for a given degree distribution
  <math|<around|{|p<rsub|k>|}>>. Figure 2 shows the basic reproduction number
  <math|R<rsub|\<beta\>><rsup|<verbatim|W>>> plotted against the vaccination
  coverage <math|v<around|(|\<beta\>|)>> when the degree distribution is
  Po(6). The plot also shows the reproduction number for standard
  acquaintance vaccination and for uniform vaccination. For a given
  vaccination coverage, we have <math|R<rsup|<verbatim|U>>\<gtr\>R<rsup|<verbatim|A>>\<gtr\>R<rsup|<verbatim|W>>>,
  although the difference between standard acquaintance vaccination and the
  weight based strategy is quite small. Note however that, in practical
  situations also a small gain could be valuable: The vaccination coverage
  required to push the epidemic threshold below 1 \U thereby preventing large
  outbreaks \U is referred to as the <em|critical vaccination coverage>.
  Clearly, when fighting an infectious disease in a large human population
  for instance, even a very small decrease in the critical vaccination
  coverage might imply large savings in terms of vaccination
  costs.<htab|0pt><math|\<Box\>><vspace|1fn>

  <no-indent><with|font-series|bold|Example 4.1.2.> Let the weights have a
  Beta distribution with parameters 0.5 and 2.5; see Figure 3. In this case
  it is not possible to write down analytical expressions in closed form for
  <math|R<rsup|<verbatim|W>>> but it is easily computed numerically. Figure 4
  shows the basic reproduction numbers plotted against the vaccination
  coverage when the degree distribution is Po(14). In this case the weight
  based strategy performs clearly better than the standard acquaintance
  vaccination. In particular, the critical vaccination coverage for uniform
  vaccination and standard acquaintance vaccination is 0.58 and 0.53
  respectively, while for the weight based strategy it is decreased to 0.47.
  The reason is that the weight distribution is right-skewed: Most weights
  are small but there is a thick right-tail with large weights, and by
  getting rid of these large weights the mean in the weight distribution is
  decreased more than in the uniform case.<htab|0pt><math|\<Box\>><vspace|1fn>

  <no-indent><with|font-series|bold|Example 4.1.3.> Finally, let the weights
  have the same Beta distribution as in the previous example, but take the
  degree distribution to be a power-law with exponent 3.5 and the same mean
  14 as in the Poisson distribution. Figure 5 displays the basic reproduction
  numbers in this case. Again the weight based strategy performs better than
  standard acquaintance vaccination. In this case however, the most striking
  feature is the difference between the uniform vaccination and the
  acquaintance based strategies: when the degree distribution is a power law,
  the basic reproduction number is pushed down very effectively by targeting
  high degree vertices.<htab|0pt><math|\<Box\>><vspace|1fn>

  <\big-figure>
    <text|<image|kont_uni_Po_l.eps|0.8tex-text-width|0.35tex-text-height||>>

    \;
  </big-figure|Basic reproduction numbers with <math|U<around|(|0,1|)>>
  weights for a Po(6) degree distribution plotted against the vaccination
  coverage: the weight based acquaintance strategy (solid line), the standard
  acquaintance vaccination (dashed line) and uniform vaccination (dash-dotted
  line).>

  <\big-figure>
    <text|<image|beta_plot.eps|0.8tex-text-width|0.35tex-text-height||>>

    \;
  </big-figure|A Beta density with parameter 0.5 and 2.5.>

  <\big-figure>
    <text|<image|kont_beta_Po_l.eps|0.8tex-text-width|0.34tex-text-height||>>

    \;
  </big-figure|Basic reproduction numbers with Beta(0.5,2.5) weights for a
  Po(14) degree distribution plotted against the vaccination coverage: the
  weight based acquaintance strategy (solid line), the standard acquaintance
  vaccination (dashed line) and uniform vaccination (dash-dotted line).>

  <\big-figure>
    <text|<image|kont_beta_pl_l.eps|0.8tex-text-width|0.34tex-text-height||>>

    \;
  </big-figure|Basic reproduction numbers with Beta(0.5,2.5) weights for
  power-law degree distribution with exponent 3.5 and mean 14 plotted against
  the vaccination coverage.>

  <subsection|Weight based vaccination: two-point weights>

  The finding in the previous section that the weight based strategy performs
  well for right-skewed weight distributions in the continuous case might
  lead one to suspect that the strategy is particularly useful for a
  \Ppolarized\Q discrete distribution. In this section we analyze the simple
  case when the weights have a two-point distribution. As a motivation we can
  think of a network having two types of directed transmission links, one
  that spreads an infection with high probability and one that does so only
  with a very small probability. It would then be natural to design a
  strategy that targets vertices with highly infectious connections.

  Assume that <math|W\<in\><around|{|a,b|}>> where <math|a\<less\>b> and
  write <math|p<rsub|a>=<PP><around|(|W=a|)>> and
  <math|p<rsub|b>=<PP><around|(|W=b|)>>. The strategy is defined so that each
  vertex is sampled independently with probability <math|s> and, for each
  sampled vertex <math|u>, its neighbors with weight <math|b> on their edge
  from <math|u> are vaccinated: Recall that <math|\<cal-N\><rsub|u>> denotes
  the set of neighbors of a vertex <math|u> and let

  <\equation*>
    \<cal-N\><rsub|u><rsup|<around|(|b|)>>=<around|{|v\<in\>\<cal-N\><rsub|u>:W<rsub|<around|(|u,v|)>>=b|}>,
  </equation*>

  that is, <math|\<cal-N\><rsub|u><rsup|<around|(|b|)>>> is the set of
  neighbors of <math|u> for which the weight on the edge
  <math|<around|(|u,v|)>> attains the larger value <math|b>. Then, if
  <math|u> is sampled, the vertices in <math|\<cal-N\><rsub|u><rsup|<around|(|b|)>>>
  are vaccinated. No action is taken if <math|\<cal-N\><rsub|u><rsup|<around|(|b|)>>>
  is empty.

  To derive the vaccination coverage, note that the probability that a
  randomly chosen vertex in the graph is not chosen for vaccination by a
  given neighbor equals

  <\equation*>
    \<alpha\>=1-s*p<rsub|b>.
  </equation*>

  As in the previous section we obtain the vaccination coverage from the
  equation

  <\equation*>
    1-v<around|(|s|)>=<big|sum><rsub|j\<geq\>0>\<alpha\><rsup|j>*p<rsub|j>.
  </equation*>

  The derivation of the epidemic threshold is based on the same branching
  process as in the previous section, that is, an individual in the branching
  process consists of an unvaccinated vertex <math|u> along with an outgoing
  edge <math|<around|(|u,w|)>> that is not used for vaccination and that is
  open for transmission. To find an expression for the reproduction mean
  <math|R<rsub|s><rsup|<verbatim|D>>>, which serves as the epidemic
  threshold, first note that in this case the degree distribution of vertex
  <math|w> is not affected by the information that <math|w> did not chose
  <math|u> for vaccination (recall that the latter event is denoted
  <math|A>). Indeed, whether <math|u> is vaccinated or not if <math|w> is
  sampled is determined only by <math|W<rsub|<around|(|w,u|)>>>. Hence
  <math|<PP><rsub|A><around|(|D<rsub|w>=k|)>=<wide|p|~><rsub|k>>.

  Conditionally on <math|D<rsub|w>=k>, the probability that <math|w> is not
  vaccinated via any of its other <math|k-1> neighbors (apart from <math|u>)
  is given by <math|\<alpha\><rsup|k-1>>. We also need to determine the
  expected number of dangerous edges from <math|w> to vertices in
  <math|\<cal-N\><rsub|w>\<setminus\><around|{|u|}>> conditionally on that
  <math|D<rsub|w>=k> and on <math|A> (note that, conditionally on the degree,
  the distribution of the number of dangerous edges from <math|w> is not
  affected by the information that <math|w> is not vaccinated). For this we
  need the corresponding probability that <math|w> is sampled to name a
  neighbor for vaccination. With <math|V<rsub|w>\<in\><around|{|0,1|}>>
  denoting the number of times that <math|w> is sampled to name a neighbor,
  we get

  <\equation*>
    <PP><rsub|A,k><around|(|V<rsub|w>=1|)>=<frac|<PP><rsub|k><around|(|A\|V<rsub|w>=1|)><PP><rsub|k><around|(|V<rsub|w>=1|)>|<PP><rsub|k><around|(|A|)>>=<frac|p<rsub|a>*s|\<alpha\>>=:\<nu\>.
  </equation*>

  Note that this probability does not depend on <math|k>. If
  <math|V<rsub|w>=0>, then the expected number of dangerous edges from
  <math|w> (to other vertices than <math|u>) is
  <math|<around|(|k-1|)>*\<gamma\>>. If <math|V<rsub|w>=1> on the other hand,
  then the neighbors reached by edges with the large weight are vaccinated.
  The expected number of remaining out-edges from <math|w> (to other vertices
  than <math|u>) is <math|<around|(|k-1|)>*p<rsub|a>> and each one of these
  is open for transmission with probability <math|a>. The expected number of
  dangerous edges from <math|w> is hence <math|<around|(|k-1|)>*a*p<rsub|a>>.
  Write <math|R<rsub|s><rsup|<verbatim|W*2>>> for the basic reproduction
  number with the current vaccination strategy. We get

  <\equation>
    <label|eq:RsW2>R<rsub|s><rsup|<verbatim|W*2>>=<around|(|\<nu\>*a*p<rsub|a>+<around|(|1-\<nu\>|)>*\<gamma\>|)>*<big|sum><rsub|k\<geq\>2><wide|p|~><rsub|k>*\<alpha\><rsup|k-1>*<around|(|k-1|)>.
  </equation>

  We now compare this to the epidemic threshold (<reference|eq:RvU>) for
  uniform vaccination and, in particular, to the threshold
  (<reference|eq:RbA>) for the standard acquaintance vaccination
  strategy.<vspace|1fn>

  <no-indent><with|font-series|bold|Example 4.2.1.> Figure 6 shows the basic
  reproduction numbers when the degree distribution is Po(14) and the weight
  distribution is specified by <math|<PP><around|(|W=0.1|)>=1-<PP><around|(|W=1|)>=0.9>
  (most edges hence have a very small weight, but a small fraction has weight
  1, implying almost sure transmission). The plot reveals that the weight
  based strategy clearly outperforms the other strategies in this case. The
  critical vaccination coverage is lowered from 0.58 with standard
  acquaintance vaccination to 0.48 with the weight based
  strategy.<htab|0pt><math|\<Box\>><vspace|1fn>

  <no-indent><with|font-series|bold|Example 4.2.2.> Figure 7 shows the basic
  reproduction numbers for the same weight distribution as in the previous
  example when the degree distribution is a power-law with exponent 3.5 and
  mean 14. Again we see that the weight based strategy is the most efficient.
  <htab|0pt><math|\<Box\>><vspace|1fn>

  <no-indent><with|font-series|bold|Example 4.2.3.> Finally, Figure 8
  displays the basic reproduction numbers for the same power-law degree
  distribution as in the previous example but for a weight distribution
  specified by <math|<PP><around|(|W=0.1|)>=1-<PP><around|(|W=1|)>=0.5>. In
  this case almost nothing is gained by using the weight based strategy
  compared to standard acquaintance vaccination (the lines are almost
  aligned). The explanation for this is that, although the weight based
  strategy targets highly infective links, it does so more \Plocally\Q in the
  graph: Recall that <em|all> neighbors with large weight on their edges from
  a sampled vertex are vaccinated. This means that, to achieve a given
  vaccination coverage, a much smaller sample of vertices is required
  compared to standard acquaintance vaccination if the probability of the
  larger weight is reasonably large; Figure 9 shows a plot for the current
  example. Thus the weight based strategy affects fewer parts of the graph
  and this cancels the positive effect that lies in securing high risk
  connections. However, the strategy does not perform worse than the standard
  acquaintance strategy. Hence the strategy is still more effective in the
  sense that it requires a smaller sample of vertices to name neighbors for
  vaccination to obtain a given vaccination coverage. In situations when
  there are costs associated with selecting and communication with the
  sampled vertices, this might be important.<htab|0pt><math|\<Box\>><vspace|1fn>

  <\big-figure>
    1cm

    <text|<image|disk_po_l.eps|0.8tex-text-width|0.35tex-text-height||>>

    \;
  </big-figure|Basic reproduction numbers plotted against the vaccination
  coverage with <math|<PP><around|(|W=0.1|)>=1-<PP><around|(|W=1|)>=0.9> and
  a Po(14) degree distribution: the weight based acquaintance strategy (solid
  line), the standard acquaintance vaccination (dashed line) and uniform
  vaccination (dash-dotted line).>

  <\big-figure>
    <text|<image|disk_pl_l.eps|0.8tex-text-width|0.35tex-text-height||>>

    \;
  </big-figure|Basic reproduction numbers plotted against the vaccination
  coverage with <math|<PP><around|(|W=0.1|)>=1-<PP><around|(|W=1|)>=0.9> and
  a power law degree distribution with exponent 3.5 and mean 14.>

  <\big-figure>
    <text|<image|disk_pl_hom_l.eps|0.8tex-text-width|0.34tex-text-height||>>

    \;
  </big-figure|Basic reproduction numbers plotted against the vaccination
  coverage with <math|<PP><around|(|W=0.1|)>=1-<PP><around|(|W=1|)>=0.5> and
  a power law degree distribution with exponent 3.5 and mean 14: the weight
  based acquaintance strategy (solid line), the standard acquaintance
  vaccination (dashed line) and uniform vaccination (dash-dotted line).>

  <\big-figure>
    <text|<image|disk_sampling.eps|0.8tex-text-width|0.34tex-text-height||>>

    \;
  </big-figure|The fraction of the population that has to be sampled to
  vaccinate (at least one) neighbor(s) plotted against the resulting
  vaccination coverage for the weight based strategy (solid line) and
  standard acquaintance vaccination (dashed line).>

  <section|Summary and discussion>

  We have formulated and analyzed a model for epidemic spread on weighted
  graphs, where the weight of an edge indicates the probability that it is
  used for transmission. Expressions have been derived for the epidemic
  threshold, specifying when there is a positive probability for an epidemic
  to take off. The case with independent weights is analogous to the case
  with a constant infection probability given by the mean weight. For degree
  dependent out-weights \U which for instance makes it possible to model a
  situation where high degree vertices infect their neighbors with a smaller
  probability \U however the behavior is different from a homogeneous
  epidemic.

  Furthermore, we have analyzed a version of the acquaintance vaccination
  strategy where neighbors of the sampled vertices reached by edges with
  large weights are vaccinated. The selected vertices hence impose
  vaccination on the neighbor(s) that they have the strongest connection(s)
  to instead of a random neighbor. Two versions of this strategy have been
  treated: one for continuous weight distributions and one for two-point
  distributions. In the examples we have looked at, these strategies have
  been seen to outperform standard acquaintance vaccination, the difference
  being largest in cases where the weight distribution is highly
  right-skewed. The reason why the weight based acquaintance strategies
  perform better than standard acquaintance vaccination is that, in addition
  to removing the vaccinated neighbors, the ability to spread the epidemic is
  decreased also for the sampled vertices in that their high-weight
  connections are secured.

  As for further work, there are numerous possibilities. In many situations
  it would be desirable to allow for (typically positive) correlations
  between the weights <math|W<rsub|<around|(|u,v|)>>> and
  <math|W<rsub|<around|(|v,u|)>>> on a given edge, for instance one might
  want to assign only one weight per edge, specifying the probability of
  transmission in any direction. This leads to complications in the current
  analysis, basically because the information that a vertex is unvaccinated
  then gives information on the weights on the edges of its neighbors.
  Furthermore, the basic idea in acquaintance vaccination is that, by
  vaccinating neighbors of the sampled vertices, one reaches vertices with
  higher degree. A natural further development of this idea would be to
  vaccinate neighbors with maximal degree, that is, selected vertices are
  asked to identify their neighbor(s) with the largest degree among the
  neighbors (assuming that they have this information) and these neighbors
  are then vaccinated. Unfortunately this seems to lead to complicated
  dependencies in the resulting epidemic process.

  We also mention that it would be interesting to investigate the final size
  of the epidemic. This is usually related to the probability of a large
  outbreak and quantified via an equation involving the generating function
  of the reproduction distribution. For the vaccination strategies that we
  have considered here, this equation would involve the distribution
  (<reference|eq:ord>) of order statistics and is hence presumably
  complicated. But it would be interesting to study the final size by aid of
  simulation. Other possible continuations include investigating how the
  results are affected by introducing clustering (triangles and other short
  cycles) in the underlying graph, to involve time-dynamic in the vaccination
  procedure and to generalize the model for the epidemic spread.<vspace|2fn>

  <no-indent><with|font-series|bold|Acknowledgement.> The author gratefully
  acknowledges the support from The Bank of Sweden Tercentenary Foundation.

  <\thebibliography|1>
    <bibitem|A-98>Andersson, H. (1998): Limit theorems for a random graph
    epidemic model, <em|Ann. Appl. Probab.> <with|font-series|bold|8>,
    1331\U1349.

    <bibitem|A-99>Andersson, H. (1999): Epidemic models and social networks,
    <em|The Mathematical Scientist> <with|font-series|bold|24>, 128\U147.

    <bibitem|vBML>von Bahr, B. and Martin-Lf, A. (1980): Threshold limit
    theorems for some epidemic processes, <em|Adv. Appl. Probab.>
    <with|font-series|bold|12>, 319\U349.

    <bibitem|BvHH:1>Bhamidi, S., van der Hofstad, R. and Hooghiemstra, G.
    (2010): First passage percolation on random graphs with finite mean
    degrees, <em|Ann. Appl. Probab.> <with|font-series|bold|20>, 1907-1965.

    <bibitem|BvHH:2>Bhamidi, S., van der Hofstad, R. and Hooghiemstra, G.
    (2010): Extreme value theory, Poisson-Dirichlet distributions and first
    passage percolation on random networks, <em|Adv. Appl. Probab.>
    <with|font-series|bold|42>.

    <bibitem|BvHH:3>Bhamidi, S., van der Hofstad, R. and Hooghiemstra, G.
    (2010): First passage percolation on the Erdos-Renyi random graph,
    preprint.

    <bibitem|BJML>Britton, T., Janson, S. and Martin-Lf, A. (2007): Graphs
    with specified degree distributions, simple epidemics and local
    vacination strategies, <em|Adv. Appl. Prob.> <with|font-series|bold|39>,
    922-948.

    <bibitem|CHbA>Cohen, R., Havlin, S. and ben-Avrahan, D. (2003): Efficient
    immunization strategies for computer networks and populations, <em|Phys.
    Rev. Lett.> <with|font-series|bold|91>, 247901.

    <bibitem|Gang>Gang, Y., Tao, T., Jie, W., Zhong-Qian, F. and Bing-Hong,
    W. (2005): Epidemic spread in weighted scale-free networks, <em|Chi.
    Phys. Lett.> <with|font-series|bold|22>, 510.

    <bibitem|vHHvM>van der Hofstad, R., Hooghiemstra, G. and van Mieghem, P.
    (2005): Random graphs with finite variance degrees, <em|Rand. Struct.
    Alg.> <with|font-series|bold|26>, 76-123.

    <bibitem|vH>van der Hofstad, R. (2010): Random graphs and complex
    networks, lecture notes available at www.win.tue.nl<math|\<sim\>>rhofstad

    <bibitem|MR-95>Molloy, M. and Reed, B. (1995): A critical point for
    random graphs with a given degree sequence, <em|Rand. Struct. Alg.>
    <with|font-series|bold|6>, 161-179.

    <bibitem|MR-98>Molloy, M. and Reed, B. (1998): The size of the giant
    component of a random graphs with a given degree sequence, <em|Comb.
    Prob. Comp.> <with|font-series|bold|7>, 295-305.

    <bibitem|N>Newman, M.E.J. (2001): The spread of epidemic disease on
    networks, <em|Phys. Rev. E> <with|font-series|bold|66>, 016128.

    <bibitem|Schumm>Schumm, P., Scoglio, C. Gruenbacher, D. and Easton, T.
    (2007): Epidemic spreading on weighted contact networks, in <em|Proc.
    IEEE/ACM Bionetics 2007, Budapest, Hungary>.
  </thebibliography>
</body>