<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <doc-data|<doc-title|Michaelis-Menten Relations for Complex Enzymatic
  Networks>|<doc-author|<author-data|<author-name|<with|font-series|bold|Anatoly
  B. Kolomeisky>>|<author-affiliation|Department of Chemistry, Rice
  University, Houston, TX 77005-1892, USA>>>>

  <abstract-data|<\abstract>
    All biological processes are controlled by complex systems of enzymatic
    chemical reactions. Although the majority of enzymatic networks have very
    elaborate structures, there are many experimental observations indicating
    that some turnover rates still follow a simple Michaelis-Menten relation
    with a hyperbolic dependence on a substrate concentration. The original
    Michaelis-Menten mechanism has been derived as a steady-state
    approximation for a single-pathway enzymatic chain. The validity of this
    mechanism for many complex enzymatic systems is surprising. To determine
    general conditions when this relation might be observed in experiments,
    enzymatic networks consisting of coupled parallel pathways are
    investigated theoretically. It is found that the Michaelis-Menten
    equation is satisfied for specific relations between chemical rates, and
    it also corresponds to the situation with no fluxes between parallel
    pathways. Our results are illustrated for simple models. The importance
    of the Michaelis-Menten relationship and derived criteria for
    single-molecule experimental studies of enzymatic processes are
    discussed.
  </abstract>>

  <\titlepage>
    \;
  </titlepage>

  <section|Introduction>

  It is known that all chemical reactions in biological systems are catalyzed
  by protein enzymatic molecules.<cite|alberts|lodish> Fundamental
  understanding of cellular processes cannot be accomplished without
  determining how involved enzymatic networks function. First catalytic
  mechanism that involves enzyme molecules has been proposed almost a century
  ago by Michaelis and Menten,<cite|MM> and since it became one of the most
  used and celebrated relations in biochemical and biophysical studies of
  natural phenomena. Similar relations between chemical rates and substrate
  concentrations have been observed in many enzymatic
  systems.<cite|segel|fersht|cook|english06> However, why the
  Michaelis-Menten (MM) mechanism, i.e., the hyperbolic dependence on the
  concentration of substrate, is working even for some very complex enzymatic
  networks is still not well understood.

  The original MM mechanism has been derived as a steady-state approximation
  to a simple single-pathway enzymatic process with irreversible creation of
  product molecules as shown in a scheme at Fig. 1.<cite|houston> In
  addition, it was assumed that the initial concentration of enzyme was much
  smaller than the initial concentration of the substrate, and that not too
  many product molecules have been produced.<cite|houston> Then the rate of
  the catalyzed reaction can be written in terms of the rate constants shown
  in Fig. 1 as

  <\equation>
    V=<frac|k<rsub|2>*c|c+K<rsub|M>>,
  </equation>

  where <math|c> is the concentration of substrate molecules,
  <math|K<rsub|M>=<around|(|k<rsub|2>+k<rsub|-1>|)>/k<rsub|1>> is known as
  the Michaelis constant and the rate <math|k<rsub|2>> is called the
  catalytic rate. The rate of enzymatic reaction in the MM mechanism is
  proportional to the concentration of the substrate molecules at low
  concentrations while it saturates at high concentrations. Surprisingly,
  similar behavior is also observed experimentally in many enzymatic systems
  with much more complex topology of chemical transitions than one shown in
  Fig. 1.<cite|segel|fersht|cook|english06> Several theoretical studies have
  been presented in order to understand why turnover rates in complex
  enzymatic networks might follow the simple MM
  relation.<cite|kou05|min06|gopich06|cao11> It has been argued that the MM
  equation will be satisfied for fluctuating enzymatic systems when
  conformational transition rates are very large or very low in comparison
  with catalytic rates, although with redefined definitions of catalytic
  rates and <math|K<rsub|M>> constants.<cite|kou05|min06> A general approach
  to analyze enzymatic kinetics, based on the flux balance method, has been
  developed recently,<cite|cao11> and it suggests that the MM relation will
  not be observed when the detailed balance is broken. However, in all
  current approaches only enzymatic networks with several irreversible
  transitions have been considered. In addition, general expressions for the
  rate of product formation have not been derived, and explicit conditions on
  validity of the MM equation have not been obtained.

  In this paper, we present an alternative theoretical method of analyzing
  complex enzymatic networks based on solving discrete-state stochastic
  master equations. This approach has been utilized successfully to describe
  dynamic properties and mechanisms of motor proteins, and also in the
  analysis of other single-molecule experiments.<cite|KF00|kolomeisky00|kolomeisky01|stukalin06|AR|das09>
  Specifically, we consider enzymatic networks consisting of coupled parallel
  pathways with all chemical transitions assumed to be reversible. Our method
  allows us to describe explicitly conditions when the MM relation for the
  turnover rate is satisfied. These conditions are analogous to the
  requirement that the flux between parallel pathways vanishes at each state.
  Using simple models to explain our method we argue that all turnover rates
  behave qualitatively similar to the MM relation.

  The paper is organized as follows. In Sec. II our theoretical method is
  presented for general coupled parallel enzymatic networks. Examples to
  illustrate obtained results are given in Sec. III. Finally, Sec. IV
  provides a summary of our findings.

  <section|Theoretical Analysis>

  As an example of complex enzymatic networks a system made of several
  coupled parallel biochemical pathways, as shown in Fig. 2, will be
  analyzed. We adopt here a single-molecule approach, and to simplify
  calculations all derivations will be made for the network of two coupled
  parallel pathways (see Fig. 2), although the analysis can be easily
  extended to many coupled parallel pathways. This situation corresponds to a
  single enzymatic molecule that can be found in one of two conformations,
  and it catalyzes the reaction of the substrate transformation to the
  corresponding product in both conformations but with different rates.

  It is assumed that in each pathway there are <math|N> discrete chemical
  states per each enzymatic cycle. The enzyme molecule can be found in the
  state <math|i> from which it can move forward or backward along the same
  reaction channel with rates <math|u<rsub|i>> or <math|w<rsub|i>>,
  respectively, or it can change its conformation by moving to the state
  <math|i> in the second pathway with the rate <math|\<gamma\><rsub|i>>: see
  Fig. 2. Similarly, if the molecule is in the state <math|i> of the second
  reaction channel it can make forward (backward) transition with the rate
  <math|\<alpha\><rsub|i>> (<math|\<beta\><rsub|i>>), or it can change its
  conformational state by going to the first pathway with the rate
  <math|\<delta\><rsub|i>>, as illustrated in Fig. 2. We also assume that the
  enzyme molecule binds to the substrate in the states <math|i=0>, i.e., the
  corresponding transition rates are proportional to the concentration of
  substrate molecules <math|c>, <math|u<rsub|0>=k<rsub|1>*c> and
  <math|\<alpha\><rsub|0>=k<rsub|2>*c>. Let us define a function
  <math|P<rsub|i><rsup|<around|(|k|)>><around|(|t|)>> as a probability to
  find the enzyme molecule in the state <math|i> at the reaction channel
  <math|k> (<math|k=1> or 2) at time <math|t>. The temporal evolution of this
  enzymatic network can be described by a system of master equations,

  <\equation>
    <label|me1><frac|d*P<rsub|i><rsup|<around|(|1|)>><around|(|t|)>|d*t>=u<rsub|i-1>*P<rsub|i-1><rsup|<around|(|1|)>><around|(|t|)>+w<rsub|i+1>*P<rsub|i+1><rsup|<around|(|1|)>><around|(|t|)>+\<delta\><rsub|i>*P<rsub|i><rsup|<around|(|2|)>><around|(|t|)>-<around|(|u<rsub|i>+w<rsub|i>+\<gamma\><rsub|i>|)>*P<rsub|i><rsup|<around|(|1|)>><around|(|t|)>;
  </equation>

  <\equation>
    <label|me2><frac|d*P<rsub|i><rsup|<around|(|2|)>><around|(|t|)>|d*t>=\<alpha\><rsub|i-1>*P<rsub|i-1><rsup|<around|(|2|)>><around|(|t|)>+\<beta\><rsub|i+1>*P<rsub|i+1><rsup|<around|(|2|)>><around|(|t|)>+\<gamma\><rsub|i>*P<rsub|i><rsup|<around|(|1|)>><around|(|t|)>-<around|(|\<alpha\><rsub|i>+\<beta\><rsub|i>+\<delta\><rsub|i>|)>*P<rsub|i><rsup|<around|(|2|)>><around|(|t|)>.
  </equation>

  Because of periodicity, it is convenient to define a new function,

  <\equation>
    R<rsub|i><rsup|<around|(|k|)>><around|(|t|)>=<big|sum><rsub|l>P<rsub|i+l*N><rsup|<around|(|k|)>><around|(|t|)>,
  </equation>

  with <math|l> being any integer number. Then the conformational transition
  flux between the states <math|i> (<math|i=0,1,\<ldots\>,N-1>) in two
  pathways can be written as

  <\equation>
    <label|flux>J<rsub|i>=\<gamma\><rsub|i>*R<rsub|i><rsup|<around|(|1|)>>-\<delta\><rsub|i>*R<rsub|i><rsup|<around|(|2|)>>.
  </equation>

  When the system reaches a stationary state
  (<math|t\<rightarrow\>\<infty\>>), Master equations (<reference|me1>) and
  (<reference|me2>) transform into the following expressions,

  <\equation>
    <label|me>0=u<rsub|i-1>*R<rsub|i-1><rsup|<around|(|1|)>>+w<rsub|i+1>*R<rsub|i+1><rsup|<around|(|1|)>><around|(|t|)>-J<rsub|i>-<around|(|u<rsub|i>+w<rsub|i>|)>*R<rsub|i><rsup|<around|(|1|)>>;
  </equation>

  <\equation>
    <label|me>0=\<alpha\><rsub|i-1>*R<rsub|i-1><rsup|<around|(|2|)>>+\<beta\><rsub|i+1>*R<rsub|i+1><rsup|<around|(|2|)>>+J<rsub|i>-<around|(|\<alpha\><rsub|i>+\<beta\><rsub|i>|)>*R<rsub|i><rsup|<around|(|2|)>>.
  </equation>

  In addition, at large times total conformational flux between states in two
  pathways must disappear,

  <\equation>
    <label|current><big|sum><rsub|i=0><rsup|N-1>J<rsub|i>=0.
  </equation>

  Now we can define new effective rates,

  <\equation>
    <label|u><wide|u<rsub|i>|~>=u<rsub|i>+\<alpha\><rsub|i>*<frac|\<gamma\><rsub|i>|\<delta\><rsub|i>>,
  </equation>

  and

  <\equation>
    <label|w><wide|w<rsub|i>|~>=w<rsub|i>+\<beta\><rsub|i>*<frac|\<gamma\><rsub|i>|\<delta\><rsub|i>>.
  </equation>

  Using these definitions and the expression for the flux (<reference|flux>)
  one can obtain from Eq. (<reference|me>)

  <\equation>
    <label|eq>0=<wide|u<rsub|i-1>|~>R<rsub|i-1><rsup|<around|(|1|)>>-<wide|w<rsub|i>|~>R<rsub|i><rsup|<around|(|1|)>>-K<rsub|i-1>-<wide|u<rsub|i>|~>R<rsub|i><rsup|<around|(|1|)>>+<wide|w<rsub|i+1>|~>R<rsub|i+1><rsup|<around|(|1|)>>+K<rsub|i>,
  </equation>

  where a new function <math|K<rsub|i>> is defined as

  <\equation>
    K<rsub|i>=<frac|\<alpha\><rsub|i>|\<delta\><rsub|i>>*J<rsub|i>-<frac|\<beta\><rsub|i+1>|\<delta\><rsub|i+1>>*J<rsub|i+1>.
  </equation>

  Since Eq. (<reference|eq>) must be satisfied for any chemical state
  <math|i> it leads to

  <\equation>
    <label|eq><wide|u<rsub|i>|~>R<rsub|i><rsup|<around|(|1|)>>-<wide|w<rsub|i+1>|~>R<rsub|i+1><rsup|<around|(|1|)>>-K<rsub|i>=C,
  </equation>

  where <math|C> is some unknown constant. Using periodicity Eq.
  (<reference|eq>) can be easily solved, yielding

  <\equation>
    <label|eq>R<rsub|i><rsup|<around|(|1|)>>=<frac|C*r<rsub|i>+r<rsub|i><around|(|K|)>|1-\<Gamma\>>,
  </equation>

  with

  <\equation>
    \<Gamma\>=<big|prod><rsub|i=0><rsup|N-1><frac|<wide|w<rsub|i>|~>|<wide|u<rsub|i>|~>>;
  </equation>

  <\equation>
    r<rsub|i>=<frac|1|<wide|u<rsub|i>|~>>*<around*|(|1+<big|sum><rsub|k=1><rsup|N-1><big|prod><rsub|j=1><rsup|k><frac|<wide|w<rsub|j+1>|~>|<wide|u<rsub|j+1>|~>>|)>;
  </equation>

  and

  <\equation>
    r<rsub|i><around|(|K|)>=<frac|1|<wide|u<rsub|i>|~>>*<around*|(|K<rsub|i>+<big|sum><rsub|k=1><rsup|N-1>K<rsub|i+k>*<big|prod><rsub|j=1><rsup|k><frac|<wide|w<rsub|j+1>|~>|<wide|u<rsub|j+1>|~>>|)>.
  </equation>

  The unknown constant <math|C> can be found from the normalization
  condition, namely,

  <\equation>
    <big|sum><rsub|i=0><rsup|N-1><around*|(|R<rsub|i><rsup|<around|(|1|)>>+R<rsub|i><rsup|<around|(|2|)>>|)>=1,
  </equation>

  which produces

  <\equation>
    <label|const>C=<frac|<around|(|1+L|)>*<around|(|1-\<Gamma\>|)>-S<around|(|K|)>|S>,
  </equation>

  where new auxiliary functions are defined as

  <\equation>
    L=<big|sum><rsub|i=0><rsup|N-1><frac|J<rsub|i>|\<delta\><rsub|i>>;
  </equation>

  <\equation>
    S=<big|sum><rsub|i=0><rsup|N-1><around*|(|1+<frac|\<gamma\><rsub|i>|\<delta\><rsub|i>>|)>*r<rsub|i>,
  </equation>

  and

  <\equation>
    S<around|(|K|)>=<big|sum><rsub|i=0><rsup|N-1><around*|(|1+<frac|\<gamma\><rsub|i>|\<delta\><rsub|i>>|)>*r<rsub|i><around|(|K|)>.
  </equation>

  Substituting Eq. (<reference|const>) into Eq. (<reference|eq>) it can be
  shown that

  <\equation>
    R<rsub|i><rsup|<around|(|1|)>>=<around*|(|<frac|1+L|R>-<frac|R<around|(|K|)>|R*<around|(|1-\<Gamma\>|)>>|)>*r<rsub|i>+<frac|r<rsub|i><around|(|K|)>|<around|(|1-\<Gamma\>|)>>.
  </equation>

  These expression for the probability to be found in the state <math|i> of
  the first reaction channel at steady-state conditions allow us to compute
  all dynamic properties of the system. The turnover rate for this enzymatic
  network,

  <\equation>
    V=<big|sum><rsub|i=0><rsup|N-1><around|(|u<rsub|i>-w<rsub|i>|)>*R<rsub|i><rsup|<around|(|1|)>>+<big|sum><rsub|i=0><rsup|N-1><around|(|\<alpha\><rsub|i>-\<beta\><rsub|i>|)>*R<rsub|i><rsup|<around|(|2|)>>,
  </equation>

  which can be written as

  <\equation>
    V=<big|sum><rsub|i=0><rsup|N-1><around|(|<wide|u<rsub|i>|~>-<wide|w<rsub|i>|~>|)>*R<rsub|i><rsup|<around|(|1|)>>-<big|sum><rsub|i=0><rsup|N-1>K<rsub|i>.
  </equation>

  Then it can be shown that

  <\equation>
    <big|sum><rsub|i=0><rsup|N-1><around|(|<wide|u<rsub|i>|~>-<wide|w<rsub|i>|~>|)>*r<rsub|i>=N*<around|(|1-\<Gamma\>|)>,
  </equation>

  and

  <\equation>
    <big|sum><rsub|i=0><rsup|N-1><around|(|<wide|u<rsub|i>|~>-<wide|w<rsub|i>|~>|)>*r<rsub|i><around|(|K|)>=<around|(|1-\<Gamma\>|)>*<big|sum><rsub|i=0><rsup|N-1>K<rsub|i>.
  </equation>

  It leads to a compact expression for the chemical reaction rate,

  <\equation>
    V=<frac|N*<around|(|1-\<Gamma\>|)>|S>+<frac|N*<around|(|1-\<Gamma\>|)>*L|S>+<frac|N*R<around|(|K|)>|S>.
  </equation>

  We can repeat derivations if we choose another set of effective rates,

  <\equation>
    <wide|\<alpha\><rsub|i>|~>=\<alpha\><rsub|i>+u<rsub|i>*<frac|\<delta\><rsub|i>|\<gamma\><rsub|i>>,
  </equation>

  and

  <\equation>
    <wide|\<beta\><rsub|i>|~>=\<beta\><rsub|i>+w<rsub|i>*<frac|\<delta\><rsub|i>|\<gamma\><rsub|i>>.
  </equation>

  Comparing them with Eqs. (<reference|u>) and (<reference|w>) we conclude
  that

  <\equation>
    <frac|<wide|u<rsub|i>|~>|<wide|\<alpha\><rsub|i>|~>>=<frac|<wide|w<rsub|i>|~>|<wide|\<beta\><rsub|i>|~>>=<frac|\<gamma\><rsub|i>|\<delta\><rsub|i>>.
  </equation>

  Again the equation for the turnover rate can be derived with this set of
  effective rates. Combining both expression, we arrive to the final formula
  for the reaction speed of the enzymatic process presented in Fig. 2,

  <\equation>
    <label|eq>V=<frac|N*<around|(|1-\<Gamma\>|)>|S>+<frac|N*<around|(|1-\<Gamma\>|)>|2*S>*<big|sum><rsub|i=0><rsup|N-1>J<rsub|i>*<around*|(|<frac|1|\<delta\><rsub|i>>-<frac|1|\<gamma\><rsub|i>>|)>+<frac|N*S<around|(|M|)>|2*S>,
  </equation>

  with

  <\equation>
    r<rsub|i><around|(|M|)>=<frac|1|<wide|u<rsub|i>|~>>*<around*|(|M<rsub|i>+<big|sum><rsub|k=1><rsup|N-1>M<rsub|i+k>*<big|prod><rsub|j=1><rsup|k><frac|<wide|w<rsub|j+1>|~>|<wide|u<rsub|j+1>|~>>|)>,
  </equation>

  <\equation>
    S<around|(|M|)>=<big|sum><rsub|i=0><rsup|N-1><around*|(|1+<frac|\<gamma\><rsub|i>|\<delta\><rsub|i>>|)>*r<rsub|i><around|(|M|)>,
  </equation>

  and functions <math|M<rsub|i>> are defined as

  <\equation>
    M<rsub|i>=<around*|(|<frac|\<alpha\><rsub|i>|\<delta\><rsub|i>>-<frac|u<rsub|i>|\<gamma\><rsub|i>>|)>*J<rsub|i>-<around*|(|<frac|\<beta\><rsub|i+1>|\<delta\><rsub|i+1>>-<frac|w<rsub|i+1>|\<gamma\><rsub|i+1>>|)>*J<rsub|i+1>.
  </equation>

  Eq. (<reference|eq>) is an exact expression for the turnover rate for
  general enzymatic network made of coupled parallel pathways. It depends on
  chemical rates for individual transitions as well as conformational fluxes
  <math|J<rsub|i>>. It should be noted that these fluxes are not independent
  parameters. Explicit forms of conformational fluxes can be found utilizing
  Eqs. (<reference|flux>) and also from the balance of total fluxes through
  each chemical state,<cite|stukalin06>

  <\equation>
    u<rsub|i-1>*R<rsub|i-1><rsup|<around|(|1|)>>-w<rsub|i>*R<rsub|i><rsup|<around|(|1|)>>=J<rsub|i>+u<rsub|i>*R<rsub|i><rsup|<around|(|1|)>>-w<rsub|i+1>*R<rsub|i+1><rsup|<around|(|1|)>>,
  </equation>

  <\equation>
    \<alpha\><rsub|i-1>*R<rsub|i-1><rsup|<around|(|2|)>>-\<beta\><rsub|i>*R<rsub|i><rsup|<around|(|2|)>>+J<rsub|i>=\<alpha\><rsub|i>*R<rsub|i><rsup|<around|(|2|)>>-\<beta\><rsub|i+1>*R<rsub|i+1><rsup|<around|(|2|)>>.
  </equation>

  It is convenient to analyze the expression (<reference|eq>) for the overall
  chemical rate of the coupled enzymatic network if it follows or not the MM
  dependence. It can be easily shown that the first term has a hyperbolic
  dependence on the concentration of the substrate and it does not depend on
  conformational fluxes. At the same time, the second and the third terms do
  depend on <math|J<rsub|i>> and they are not satisfying the MM relation for
  any non-zero conformational fluxes. Thus the condition for the turnover
  rate to follow the MM dependence is when last two terms in Eq.
  (<reference|eq>) vanish, which can only take place when conformational
  fluxes disappear. This condition can be written explicitly in terms of
  relations between chemical rates,

  <\equation>
    <label|relations><frac|u<rsub|i>|\<alpha\><rsub|i>>=<frac|w<rsub|i>|\<beta\><rsub|i>>=<frac|\<gamma\><rsub|i>|\<delta\><rsub|i>>,
  </equation>

  or in the different form as

  <\equation>
    <label|relations1><frac|u<rsub|i>|\<gamma\><rsub|i>>=<frac|\<alpha\><rsub|i>|\<delta\><rsub|i>>,<space|1em><frac|w<rsub|i>|\<gamma\><rsub|i>>=<frac|\<beta\><rsub|i>|\<delta\><rsub|i>>.
  </equation>

  This is the main result of our work. A general coupled parallel enzymatic
  network will follow the MM relation when rates of coupled pathways satisfy
  the equation (<reference|relations>) for each chemical state. This is a
  clear and explicit criterion on the MM dependence of the enzymatic cycle in
  such complex systems.

  All previously discussed situations of the MM behavior for the turnover
  rate in enzymatic networks<cite|kou05|min06|cao11> can be described by our
  general approach. It has been argued that conformationally fluctuating
  enzymes still obey the MM relationship for 1) quasi-static conditions (when
  conformational rates are very slow in comparison with other chemical
  transitions), and for 2) quasi-equilibrium conditions (when conformational
  rates are very fast). The last case has been also analyzed in Ref.
  <cite|stukalin06>. The first situation corresponds to
  <math|\<gamma\><rsub|i>\<ll\>1> and <math|\<delta\><rsub|i>\<ll\>1>. Then
  Eqs. (<reference|relations1>) are valid for any value of other chemical
  rates (as long as they are larger than conformational transitions rates).
  The second case describes very large <math|\<gamma\><rsub|i>> and
  <math|\<delta\><rsub|i>>, and again Eqs. (<reference|relations1>) predict
  that it might happen for any value of chemical rates <math|u<rsub|i>>,
  <math|w<rsub|i>>, <math|\<alpha\><rsub|i>> and <math|\<beta\><rsub|i>>. It
  was also found<cite|min06> that the MM relation still holds when only one
  group of the conformationally-related states <math|i> is found in
  quasi-static or quasi-equilibrium conditions. Since <math|N=2> periodic
  system has been used for analyzing fluctuating enzymes, then from Eq.
  (<reference|current>) one can easily conclude that there are two
  conformational fluxes, <math|J<rsub|1>> and <math|J<rsub|2>>, and they are
  related via <math|J<rsub|1>+J<rsub|2>=0>. If one of them goes to zero the
  second flux must also vanish, and the MM relationship is recovered. Cao has
  argued that the MM dependence is observed when the detailed balance is not
  broken.<cite|cao11> For the system of coupled parallel pathways it means
  that the overall circular current in each loop (see Fig. 2) is zero. The
  ratio of clockwise and counterclockwise currents for any loop can be
  written with the help of Eqs. (<reference|relations>) as

  <\equation>
    <frac|u<rsub|i>*\<gamma\><rsub|i+1>*\<beta\><rsub|i+1>*\<delta\><rsub|i>|\<alpha\><rsub|i>*\<delta\><rsub|i+1>*w<rsub|i+1>*\<gamma\><rsub|i>>=<frac|\<gamma\><rsub|i+1>*\<beta\><rsub|i+1>|\<delta\><rsub|i+1>*w<rsub|i+1>>=1,
  </equation>

  which indicates that the loop current vanishes when the MM relation is
  observed.

  It is important to note also that criteria given in Eqs.
  (<reference|relations>) suggest that the MM dependence is found for systems
  where each state has similar free-energy landscape near each chemical
  state. Then the enzymatic network of coupled parallel reaction channels can
  be effectively viewed as a single enzymatic pathway with properly rescaled
  transitions rates which by definition follow the MM behavior.

  <section|Examples>

  To illustrate our theoretical method let us present some explicit results
  for the <math|N=2> system which is the most relevant for analyzing
  fluctuating enzyme systems.<cite|MM|segel|cook|kou05|min06> The dynamic
  properties of enzyme molecule in such system has been already
  obtained.<cite|stukalin06> The general formula for the turnover rate is
  given by<cite|stukalin06>

  <eqnarray|<tformat|<table|<row|<cell|V>|<cell|=>|<cell|<around|(|1/\<Omega\>|)>*<around|{|k<rsub|1>*c*u<rsub|1>-w<rsub|0>*w<rsub|1>|)>*<around|[|<around|(|k<rsub|2>*c+\<beta\><rsub|0>|)>*\<delta\><rsub|1>+<around|(|\<alpha\><rsub|1>+\<beta\><rsub|1>|)>*\<delta\><rsub|0>+\<delta\><rsub|0>*\<delta\><rsub|1>|]><eq-number><label|eqV2>>>|<row|<cell|>|<cell|>|<cell|+<around|(|k<rsub|2>*c*\<alpha\><rsub|1>-\<beta\><rsub|0>*\<beta\><rsub|1>|)>*<around|[|<around|(|k<rsub|1>*c+w<rsub|0>|)>*\<gamma\><rsub|1>+<around|(|u<rsub|1>+w<rsub|1>|)>*\<gamma\><rsub|0>+\<gamma\><rsub|0>*\<gamma\><rsub|1>|]>>>|<row|<cell|>|<cell|>|<cell|+<around|(|k<rsub|1>*c*\<alpha\><rsub|1>-w<rsub|0>*\<beta\><rsub|1>|)>*\<delta\><rsub|0>*\<gamma\><rsub|1>+<around|(|k<rsub|2>*c*u<rsub|1>-\<beta\><rsub|0>*w<rsub|1>|)>*\<gamma\><rsub|0>*\<delta\><rsub|1>},>>>>>

  where the function <math|\<Omega\>> is defined as

  <eqnarray|<tformat|<table|<row|<cell|\<Omega\>>|<cell|=>|<cell|<around|(|k<rsub|1>*c+w<rsub|0>+\<gamma\><rsub|0>|)>*<around|[|<around|(|k<rsub|2>*c+\<beta\><rsub|0>|)>*\<delta\><rsub|1>+<around|(|\<alpha\><rsub|1>+\<beta\><rsub|1>|)>*\<gamma\><rsub|1>|]><eq-number><label|Omega>>>|<row|<cell|>|<cell|>|<cell|+<around|(|u<rsub|1>+w<rsub|1>+\<gamma\><rsub|1>|)>*<around|[|<around|(|k<rsub|2>*c+\<beta\><rsub|0>|)>*\<gamma\><rsub|0>+<around|(|\<alpha\><rsub|1>+\<beta\><rsub|1>|)>*\<delta\><rsub|0>|]>>>|<row|<cell|>|<cell|>|<cell|+<around|(|k<rsub|2>*c+\<beta\><rsub|0>+\<delta\><rsub|0>|)>*<around|[|<around|(|k<rsub|1>*c+w<rsub|0>|)>*\<gamma\><rsub|1>+<around|(|u<rsub|1>+w<rsub|1>|)>*\<delta\><rsub|1>|]>>>|<row|<cell|>|<cell|>|<cell|+<around|(|\<alpha\><rsub|1>+\<beta\><rsub|1>+\<delta\><rsub|1>|)>*<around|[|<around|(|k<rsub|1>*c+w<rsub|0>|)>*\<delta\><rsub|0>+<around|(|u<rsub|1>+w<rsub|1>|)>*\<gamma\><rsub|0>|]>.>>>>>

  The conformational flux is equal to

  <\equation>
    <label|J2>J<rsub|0>=-J<rsub|1>=J=<around|(|1/\<Omega\>|)>*<around|[|<around|(|u<rsub|1>+w<rsub|1>|)>*<around|(|k<rsub|2>*c+\<beta\><rsub|0>|)>*\<gamma\><rsub|0>*\<delta\><rsub|1>-<around|(|k<rsub|1>*c+w<rsub|0>|)>*<around|(|\<alpha\><rsub|1>+\<beta\><rsub|1>|)>*\<gamma\><rsub|1>*\<delta\><rsub|0>|]>.
  </equation>

  When the conformational fluxes are zero the turnover rate has the MM
  dependence,

  <\equation>
    V=<frac|<around|(|k<rsub|1>*\<delta\><rsub|0>+k<rsub|2>*\<gamma\><rsub|0>|)>*<around|(|u<rsub|1>*\<delta\><rsub|1>+\<alpha\><rsub|1>*\<gamma\><rsub|1>|)>*c-<around|(|w<rsub|0>*\<delta\><rsub|0>+\<beta\><rsub|0>*\<gamma\><rsub|0>|)>*<around|(|w<rsub|1>*\<delta\><rsub|1>+\<beta\><rsub|1>*\<gamma\><rsub|1>|)>|<around|[|<around|(|k<rsub|1>*c+w<rsub|0>|)>*\<delta\><rsub|0>+<around|(|k<rsub|2>*c+\<beta\><rsub|0>|)>*\<gamma\><rsub|0>|]>*<around|(|\<gamma\><rsub|1>+\<delta\><rsub|1>|)>+<around|[|u<rsub|1>+w<rsub|1>|)>*\<delta\><rsub|1>+<around|(|\<alpha\><rsub|1>+\<beta\><rsub|1>|)>*\<gamma\><rsub|1>]<around|(|\<gamma\><rsub|0>+\<delta\><rsub|0>|)>>.
  </equation>

  Reaction rates for different sets of parameters are presented in Fig. 3.
  The dependence of all enzymatic rates on the substrate concentration is
  qualitatively similar: increasing function at small <math|c> and saturation
  to a constant value for <math|c\<gg\>1>. There is nothing special in the MM
  relation (black curve in Fig. 3). This can be easily understood because the
  turnover rate is equal to the ratio of polynomial functions of <math|c>.
  For the MM case both numerator and denominator are just linear functions.
  At large concentrations of the substrate molecules transitions from the
  states <math|i=1> become rate-limiting leading to effectively
  concentration-independent behavior. One could also observe that changing
  transition rates for <math|i=0> does not affect much overall enzymatic
  rates in comparison with the MM relation (green and blue curves in Fig. 3).
  However, modifying transition rates associated with <math|i=1> can
  significantly alter reaction rates (red and brown curves in Fig. 3). In
  addition, analyzing all reaction rates curves we conclude that many
  experimental observations for systems that could analyzed by <math|N=2>
  coupled periodic models might be easily assumed to follow effectively the
  MM relation, especially if experimental errors are taken into account.

  The conformational fluxes for different sets of parameters are shown in
  Fig. 4. In the MM case the <math|J=0> as expected, while in other cases the
  complex behavior is observed. At large concentrations all conformational
  fluxes tend to zero because in this case transitions from <math|i=1> are
  becoming rate limiting, and they do depend on <math|c>. In some situations
  the magnitude of the conformational flux reaches a maximum for the specific
  concentration of the substrate molecules.

  <section|Summary and Conclusions>

  A new theoretical method of analyzing complex enzymatic networks is
  developed. It is based on solving explicitly master equations for
  discrete-state stochastic models. Applying this approach for systems made
  of coupled parallel enzymatic pathways, we derived explicit criteria on
  when the MM behavior might be observed. It leads to special relations
  between all chemical rates. This method allows to explain all previous
  theoretical observations on the validity of the MM relationship in complex
  enzymatic systems. Theoretical analysis is illustrated for simple models
  relevant for conformationally fluctuating enzyme molecules. It is found
  that general behavior of enzymatic rates is qualitatively similar to the MM
  equation. Our theoretical method argues that turnover rates can be viewed
  as a ratio of polynomial functions of the substrate concentrations. The MM
  relationship is observed when these polynomials are linear functions of
  concentrations.

  The presented theoretical method might be a powerful tool for analyzing
  single-molecule experiments since it allows to compute all dynamic
  properties for complex enzymatic networks. It will be interesting to test
  experimentally developed criteria for coupled enzymatic pathways. It will
  be also important to extend this approach to other enzymatic systems and
  for computations of other experimentally observed quantities such as
  dwell-time distributions and diffusion constants.

  <section*|Acknowledgments>

  The author would like to acknowledge the support from the Welch Foundation
  (Grant C-1559), the U.S. National Science Foundation (Grant ECCS-0708765),
  and from U.S. National Institute of Health (Grant R01GM094489). The author
  also acknowledges useful discussions with Jianshu Cao.

  <\thebibliography|99>
    <bibitem|alberts>Alberts, B., <with|font-shape|italic|et al.>,
    <with|font-shape|italic|Molecular Biology of the Cell>, (4-th Ed., Taylor
    & Francis, 2002).

    <bibitem|lodish>Lodish, H., <with|font-shape|italic|et al.>,
    <with|font-shape|italic|Molecular Cell Biology>, (4-th Ed., W.H. Freeman
    and Company, New York, 2000).

    <bibitem|MM>L. Michaelis and M.L. Menten, Biochem. Z.
    <with|font-series|bold|49>, 333 (1913).

    <bibitem|segel>Segel, I.H.,<with|font-shape|italic|Enzyme Kinetics:
    Behavior and Analysis of Rapid Equilibrium and Steady State Enzyme
    Systems>, (Wiley Classics Library, New York, 1993).

    <bibitem|fersht>Fersht, A., <with|font-shape|italic|Structure and
    Mechanism in Protein Science>, (W.H. Freeman and Company, New York,
    1998).

    <bibitem|cook>Cook, P.F., and Cleland, W.W.,
    <with|font-shape|italic|Enzyme Kinetics and Mechanism>, (Garland Science,
    New York, 2007).

    <bibitem|english06>B.P. English, W. Min, A.M. van Oijen, K.T. Lee, G.
    Luo, H. Sun, B.J. Cherayil, S.C. Kou and X.S. Xie, Nature Chem. Biol.
    <with|font-series|bold|2>, 87 (2006).

    <bibitem|houston>Houston, P.L., <with|font-shape|italic|Chemical Kinetics
    and Reaction Dynamics>, (McGraw Hill, New York. 2001).

    <bibitem|kou05>S.C. Kou, B.J. Cherayil, W. Min, B.P. English and X.S.
    Xie, J. Phys. Chem. B <with|font-series|bold|109>, 19068 (2005).

    <bibitem|min06>W. Min, I.V. Gopich, B.P. English, S.C. Kou, X.S. Xie and
    A. Szabo, J. Phys. Chem. B <with|font-series|bold|110>, 20093 (2006).

    <bibitem|gopich06>I.V. Gopich and A. Szabo, J. Chem. Phys.
    <with|font-series|bold|124>, 154712 (2006).

    <bibitem|cao11>J. Cao, to appear in J. Phys. Chem. B, 2011.

    <bibitem|KF00>A.B. Kolomeisky and M.E. Fisher, Physica A
    <with|font-series|bold|279>, 1 (2000).

    <bibitem|kolomeisky00>A.B. Kolomeisky and M.E. Fisher, J. Chem. Phys.
    <with|font-series|bold|113>, 10867 (2000).

    <bibitem|kolomeisky01>A.B. Kolomeisky, J. Chem. Phys.
    <with|font-series|bold|115>, 7253 (2001).

    <bibitem|stukalin06>E.B. Stukalin, and A.B. Kolomeisky J. Chem. Phys.
    <with|font-series|bold|124>, 204901 (2006).

    <bibitem|AR>A.B. Kolomeisky and M.E. Fisher, Annu. Rev. Phys. Chem.
    <with|font-series|bold|58>, 675 (2007).

    <bibitem|das09>R.K. Das and A.B. Kolomeisky, Phys. Chem. Chem. Phys.
    <with|font-series|bold|11>, 4791 (2009).
  </thebibliography>

  <new-page>

  <no-indent><with|font-series|bold|Figure Captions:><next-line><vspace|5mm>

  <no-indent>Fig. 1. A reaction scheme for the simple enzymatic process that
  can be described by the Michael-Menten (MM) mechanism. An enzyme molecule
  <math|E> reacts reversibly with a substrate molecule <math|S> to produce an
  intermediate molecule <math|X> which can irreversibly transition to a
  product molecule <math|P> and the enzyme <math|E> with corresponding rates.

  <vspace|5mm><no-indent>Fig. 2. Enzymatic network with two coupled parallel
  pathways. Both pathways have <math|N> discrete states per each enzymatic
  cycle. The enzyme molecule in the state <math|i> can transition forward
  (backward) with the rate <math|u<rsub|i>> (<math|w<rsub|i>>) if found in
  the pathway 1, while in the second channel the forward (backward) rates are
  <math|\<alpha\><rsub|i>> (<math|\<beta\><rsub|i>>) (with
  <math|i=0,1,\<ldots\>,N-1>). The conformational transitions between two
  <math|i>-th states in different pathways are given by rates
  <math|\<gamma\><rsub|i>> and <math|\<delta\><rsub|i>>.

  <vspace|5mm><no-indent>Fig. 3. The turnover reaction rate as a function of
  the concentration of substrate molecules for <math|N=2> periodic coupled
  parallel enzymatic network. Calculations have been performed utilizing Eq.
  (<reference|eqV2>) for the following parameters for all curves:
  <math|k<rsub|1>=10> <math|\<mu\>>M<rsup|<math|-1>> s<rsup|<math|-1>>,
  <math|k<rsub|2>=1> <math|\<mu\>>M<rsup|<math|-1>> s<rsup|<math|-1>>,
  <math|u<rsub|1>=5> s<rsup|<math|-1>>, <math|w<rsub|1>=\<gamma\><rsub|0>=1>
  s<rsup|<math|-1>>, <math|\<beta\><rsub|0>=\<beta\><rsub|1>=0.1>
  s<rsup|<math|-1>> and <math|\<delta\><rsub|1>=0.5> s<rsup|<math|-1>>. In
  addition, for the brown curve we used <math|\<alpha\><rsub|1>=5>
  s<rsup|<math|-1>>, <math|\<delta\><rsub|0>=0.1> s<rsup|<math|-1>>,
  <math|\<gamma\><rsub|1>=5> s<rsup|<math|-1>> and <math|w<rsub|0>=1>
  s<rsup|<math|-1>>; for the green curve we used <math|\<alpha\><rsub|1>=0.5>
  s<rsup|<math|-1>>, <math|\<delta\><rsub|0>=1> s<rsup|<math|-1>>,
  <math|\<gamma\><rsub|1>=5> s<rsup|<math|-1>> and <math|w<rsub|0>=1>
  s<rsup|<math|-1>>; for the black curve we used <math|\<alpha\><rsub|1>=0.5>
  s<rsup|<math|-1>>, <math|\<delta\><rsub|0>=0.1> s<rsup|<math|-1>>,
  <math|\<gamma\><rsub|1>=5> s<rsup|<math|-1>> and <math|w<rsub|0>=1>
  s<rsup|<math|-1>>; for the blue curve we used <math|\<alpha\><rsub|1>=0.5>
  s<rsup|<math|-1>>, <math|\<delta\><rsub|0>=0.1> s<rsup|<math|-1>>,
  <math|\<gamma\><rsub|1>=5> s<rsup|<math|-1>> and <math|w<rsub|0>=10>
  s<rsup|<math|-1>>; and for the red curve we used
  <math|\<alpha\><rsub|1>=0.5> s<rsup|<math|-1>>,
  <math|\<delta\><rsub|0>=0.1> s<rsup|<math|-1>>, <math|\<gamma\><rsub|1>=50>
  s<rsup|<math|-1>> and <math|w<rsub|0>=1> s<rsup|<math|-1>>. The
  Michaelis-Menten case is described by the black curve.

  <vspace|5mm><no-indent>Fig. 4. The conformational flux as a function of the
  concentration of substrate molecules for <math|N=2> periodic coupled
  parallel enzymatic network. Calculations have been performed utilizing Eq.
  (<reference|J2>) for the following parameters for all curves:
  <math|k<rsub|1>=10> <math|\<mu\>>M<rsup|<math|-1>> s<rsup|<math|-1>>,
  <math|k<rsub|2>=1> <math|\<mu\>>M<rsup|<math|-1>> s<rsup|<math|-1>>,
  <math|u<rsub|1>=5> s<rsup|<math|-1>>, <math|w<rsub|1>=\<gamma\><rsub|0>=1>
  s<rsup|<math|-1>>, <math|\<beta\><rsub|0>=\<beta\><rsub|1>=0.1>
  s<rsup|<math|-1>> and <math|\<delta\><rsub|1>=0.5> s<rsup|<math|-1>>. In
  addition, for the brown curve we used <math|\<alpha\><rsub|1>=5>
  s<rsup|<math|-1>>, <math|\<delta\><rsub|0>=0.1> s<rsup|<math|-1>>,
  <math|\<gamma\><rsub|1>=5> s<rsup|<math|-1>> and <math|w<rsub|0>=1>
  s<rsup|<math|-1>>; for the green curve we used <math|\<alpha\><rsub|1>=0.5>
  s<rsup|<math|-1>>, <math|\<delta\><rsub|0>=1> s<rsup|<math|-1>>,
  <math|\<gamma\><rsub|1>=5> s<rsup|<math|-1>> and <math|w<rsub|0>=1>
  s<rsup|<math|-1>>; for the blue curve we used <math|\<alpha\><rsub|1>=0.5>
  s<rsup|<math|-1>>, <math|\<delta\><rsub|0>=0.1> s<rsup|<math|-1>>,
  <math|\<gamma\><rsub|1>=5> s<rsup|<math|-1>> and <math|w<rsub|0>=10>
  s<rsup|<math|-1>>; and for the red curve we used
  <math|\<alpha\><rsub|1>=0.5> s<rsup|<math|-1>>,
  <math|\<delta\><rsub|0>=0.1> s<rsup|<math|-1>>, <math|\<gamma\><rsub|1>=50>
  s<rsup|<math|-1>> and <math|w<rsub|0>=1> s<rsup|<math|-1>>. For parameters
  describing the MM relationship the conformational flux is equal to zero.

  <new-page>

  <\big-figure>
    <unitlength>1in \ <vspace|1in><with|font-size|1.41| Figure 1. Kolomeisky>
  </big-figure|>

  <new-page>

  <\big-figure>
    <unitlength>1in \ <vspace|1in><with|font-size|1.41| Figure 2. Kolomeisky>
  </big-figure|>

  <new-page>

  <\big-figure>
    <unitlength>1in \ <vspace|1in><with|font-size|1.41| Figure 3. Kolomeisky>
  </big-figure|>

  <new-page>

  <\big-figure>
    <unitlength>1in \ <vspace|1in><with|font-size|1.41| Figure 4. Kolomeisky>
  </big-figure|>
</body>