<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <doc-data|<doc-title|Hierarchical organization of brain functional network
  during visual task>|<doc-author|<author-data|<author-name|Zhao
  Zhuo<rsup|<math|1>>>>>|<doc-author|<author-data|<author-name|Shi-Min
  Cai<rsup|<math|1>>>>>|<doc-author|<author-data|<author-name|Zhong-Qian
  Fu<rsup|<math|1>>>>>|<doc-author|<author-data|<author-name|Jie
  Zhang<rsup|<math|2>>>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    In this paper, the brain functional networks derived from high-resolution
    synchronous EEG time series during visual task are generated by
    calculating the phase synchronization among the time series. The
    hierarchical modular organizations of these networks are systematically
    investigated by the fast Girvan-Newman algorithm. At the same time, the
    spatially adjacent electrodes (corresponding to EEG channels) are
    clustered into functional groups based on anatomical parcellation of
    brain cortex, and this clustering information are compared to that of the
    functional network. The results show that the modular architectures of
    brain functional network are in coincidence with that from the anatomical
    structures over different levels of hierarchy, which suggests that
    population of neurons performing the same function excite and inhibit in
    identical rhythms. The structure-function relationship further reveals
    that the correlations among EEG time series in the same functional group
    are much stronger than those in different ones and that the hierarchical
    organization of brain functional network may be a consequence of
    functional segmentation of brain cortex.
  </abstract>>

  <section|Introduction>

  Human brain, which is consisting of ten thousand million neurons and even
  more synapses, is perhaps the most complex system ever known. Benefiting
  from the development of brain anatomy since the nineteenth century, we now
  know that the neuronal elements of the brain constitute an extremely
  complex structural network, which supports a wide variety of cognitive
  functions and neural activities <cite|Cajal1995|Swanson2003>. Recently, it
  has gained great interests of scientists to investigate functional
  connectivity of brain based on complex network theory in which the brain
  can naturally be abstracted as a functional network. A brain functional
  network can be extracted based on functional MRI (fMRI),
  electroencephalography (EEG), magnetoencephalography (MEG), or
  multielectrode array (MEA) data, which record electric, magnetic, or other
  signals representing cognitive cortical activities of brain
  <cite|Bullmore2009>. Vertices of brain functional network derived from fMRI
  data describe anatomically localized regions of interest (ROIs) or voxels
  of fMRI image, whereas the vertices of those derived from EEG, MEG, or MEA
  data mimic the surface electrodes or sensors. The functional connectivity
  (or edge) between pairs of vertices is usually estimated using correlation
  between records of different vertices.

  It has been widely observed that the brain functional networks demonstrate
  properties such as small-worldness <cite|Watts1998> and power-law degree
  distribution <cite|Barabasi1999>, which distinguish brain functional
  network from regular and random networks
  <cite|Stam2004|Eguiluz2005|Bassett2006|Achard2006|Heuvel2008|Gong2009>.
  However, the small-worldness and power-law degree distribution only
  represent the global properties of brain functional networks. To understand
  brain functional networks imposed by structural and functional constraints
  more comprehensively, other aspects, which are expected to reflect both
  local and global organization of brain functional network (e.g.
  hierarchical modular organization), need to be investigated.

  Hierarchical organization, also called community structure and modular
  architecture, describes that some nodes in a network are densely connected
  as groups, and these groups are only sparsely connected among themselves,
  which is a common phenomenon in diverse networks such as World Wide Web,
  scientist collaborating networks, genetic networks, protein-protein
  interaction networks, and financial networks
  <cite|Newman2004|Wilkinso2004|Jonsson2006|Cai2010>. A large number of
  algorithms are developed to detect the hierarchical organizations of real
  networks <cite|Girvan2002|Newman2004|Capocci2005|Arenas2008|Zhang2009|Zhang2010>
  (also see review work <cite|Fortunato2010>). Interestingly, several recent
  works have also found the hierarchical organization of brain functional
  network derived from resting-state fMRI data
  <cite|Salvador2005|Ferrarini2009> and epileptic MEG signals
  <cite|Chavez2010>, respectively.

  Since the large-scale neuronal networks of brain emerge from synchronized
  delta oscillations, the cortical EEG time series are able to distinguish
  the ongoing from the evoked activities of brain <cite|Langheim2006|Lu2007>.
  In our work, the brain functional networks are derived from high-resolution
  synchronous EEG time series, which consist of 238 channels and are recorded
  during a cognitive task involved in visual, judgment and motor functions of
  brain. In particular, vertices correspond to surface electrodes (i.e.
  channels), and edges are determined by correlation (degree of phase
  synchronization) of EEG time series from pairs of channels. In fact, the
  electrodes can also be clustered into functional groups by their spatial
  positions on the scalp and specifically priori knowledge of anatomical
  parcellation of brain cortex. For example, electrodes near visual cortex
  area mainly represent visual function, and are therefore clustered
  together. The anatomical parcellation of brain cortex is performed
  according to Brodmann segmentation scheme <cite|Brodmann>. The fast
  Girvan-Newman (GN) algorithm is first applied to analyze the hierarchical
  organizations of brain functional networks. Strong evidence for the
  existence of modular architecture is found. Comparing the clustering
  results from the brain functional network and the anatomical segmentation,
  we find significant coincidence of the modular architecture in the network
  derived from EEG data and anatomical organization of the cortex over
  different levels of hierarchy. This result suggests that vertices are more
  tightly coupled in same functional cortex region than those belonging to
  different ones and that the patterns of neural activities of brain cortex
  are to a large extent determined by the anatomical modular architectures of
  the brain.

  <section|Materials and methods>

  <subsection|Data acquisition>

  The high-resolution EEG time series were synchronously recorded during
  visual task by using a large number of scalp electrodes (238-channels).
  Therefore, they had a high spatial and temporal resolution, which provide
  very helpful and detailed information of electrical activity of cortical
  surface. Specifically, the single-subject data set was recorded by A.
  Delorme et al. in the Swartz Center, UCSD, with the sampling rate 256 Hz
  using a Biosemi Active Two system <cite|web>. Experiments were performed as
  follows: Filled white disks appeared briefly inside one of five empty
  squares, and one of the five outlines was colored green to mark the square
  as a visual target, then the candidate made a motor response by pressing a
  mouse button with their right hand as quickly as possible whenever the
  filled white disk appeared at the attended location. It is noted that these
  locations were counterbalanced across blocks in pseudorandom order. The
  more detailed description of experiment can be found in several previous
  works <cite|Makeig2002|Makeig2004>. In this data set, each visual target
  was represented by a synchronous EEG recording with five sections, and
  about three thousands trials of experiment were performed. In addition,
  there are 235 channels of EEG used in our work by dropping 3 channels of
  EOG.

  <subsection|Network construction based on Phase synchronization>

  The concept of phase synchronization is introduced to study synchronization
  of coupled oscillators and has gained particular interests to investigate
  coupling among nonlinear complex systems
  <cite|Kuramoto1984|Yeung1999|Timme2002>. The phase
  <math|\<Phi\><around|(|t|)>> of a real-value time series
  <math|X<around|(|t|)>> is defined using Gabor's analytic signal approach
  <cite|Gabor1946>:

  <\equation>
    V<around|(|t|)>=X<around|(|t|)>+i*X<rsub|h><around|(|t|)>=A*e<rsup|i*\<Phi\><around|(|t|)>>,<label|equ:Hilbert>
  </equation>

  where the imaginary part <math|X<rsub|h><around|(|t|)>> is the Hilbert
  transformation of <math|X<around|(|t|)>>. Hence, the degree of phase
  synchronization between time series <math|X<rsub|i><around|(|t|)>> and
  <math|X<rsub|j><around|(|t|)>> is evaluated by a bivariate phase coupling
  index <cite|Schelter2006>:

  <\equation>
    R<rsub|i,j>=<around|\<\|\|\>|<frac|1|T>*<big|sum><rsub|t=1><rsup|T>e<rsup|i*<around|(|\<phi\><rsub|i><around|(|t|)>-\<phi\><rsub|j><around|(|t|)>|)>>|\<\|\|\>>,<label|equ:index>
  </equation>

  which is in the interval [0,1]. If the phases of two time series are
  completely synchronized, the phase coupling index will be maximum.

  The phase synchronization method is able to reduce the nonstationary
  effect, compared with the calculation of the correlation of two EEG time
  series directly. The functional connectivity (edge) between pairs of
  electrodes (vertices) has been estimated using the measure of phase
  synchronization, and then it is thresholded to generate functional
  networks. Herein each vertex is connected to its <math|N> nearest neighbors
  (i.e. those channels that are most phase-synchronized with itself)
  <cite|xiaoke>. Notice that the resulting brain functional networks are not
  necessarily symmetric, i.e. if vertex <math|i> is a neighbor of vertex
  <math|j>, vertex <math|j> may not necessarily be a neighbor of vertex
  <math|i>, and vice versa. Though the edges are intrinsically directed, we
  analyze the networks in an undirected way for convenience. The mean degree
  of network is generally determined by <math|N>. However, since the directed
  edges are identified as undirected ones, the actual mean degree is a little
  larger than <math|N>. In this way, the connectivity of brain functional
  network is naturally guaranteed without dense connections, which will
  otherwise disturb the hierarchy detection.

  <subsection|Clustering EEG channels by electrode position and anatomical
  parcellation of brain cortex>

  EEG time series recorded through each channel mainly represent the
  electrical activities of neurons near the corresponding electrode. Thus,
  the EEG channels can be directly clustered into functional groups according
  to the spatial position of electrodes and anatomical parcellation of brain
  cortex based on Brodmann area. We used the Brodmann template image
  distributed with MRIcro , which is restricted to the standard MNI space
  <cite|MRIcro>. Resolution of image is <math|181\<times\>217\<times\>181>
  and size of voxels is <math|1*m*m\<times\>\<times\>1*m*m\<times\>1*m*m>.
  Each hemisphere is partitioned into 41 areas according to cytoarchitecture
  of neurons, together with the same labels suggesting same cognitive
  functions in two hemispheres. The locations of electrodes are registered to
  MNI space using SPM8 toolbox (open-source software) <cite|SPM8>. By
  checking Brodmann areas in which the electrodes belong to, the electrodes
  that are spatially nearby are labeled by the same Brodmann areas index. At
  last, these 235 channels are clustered into 25 functional groups
  corresponding to 25 Brodmann areas (e.g. functional group 47 corresponds
  Brodmann area 47). Other Brodmann ares are absent due to deeply inside
  position of the brain cortex. The size of functional groups varies from 1
  to 29, as shown in Tab.<reference|tab:numberofchannels>. Moreover, Brodmann
  areas can be roughly scaled into 9 major substructures according to
  specific physiological functions, by which the EEG channels can be further
  clustered at a higher hierarchy, as shown in
  Tab.<reference|tab:functionalgroup>. Hence, the EEG channels are organized
  into two levels of hierarchy according to the above mentioned segmentation.

  <big-table| <ruledtabular| <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|4|4|cell-halign|l>|<cwith|1|-1|4|4|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|2|2|1|-1|cell-bborder|1ln>|<table|<row|<cell|Brodmann>|<cell|EEG
  channel>|<cell|Brodmann>|<cell|EEG channel>>|<row|<cell|area>|<cell|number>|<cell|area>|<cell|number>>|<row|<cell|20>|<cell|29>|<cell|4>|<cell|7>>|<row|<cell|19>|<cell|26>|<cell|10>|<cell|7>>|<row|<cell|6>|<cell|19>|<cell|8>|<cell|5>>|<row|<cell|18>|<cell|16>|<cell|22>|<cell|5>>|<row|<cell|9>|<cell|14>|<cell|38>|<cell|5>>|<row|<cell|37>|<cell|13>|<cell|44>|<cell|5>>|<row|<cell|45>|<cell|12>|<cell|43>|<cell|4>>|<row|<cell|40>|<cell|11>|<cell|48>|<cell|4>>|<row|<cell|7>|<cell|10>|<cell|1>|<cell|3>>|<row|<cell|21>|<cell|9>|<cell|2>|<cell|3>>|<row|<cell|46>|<cell|9>|<cell|5>|<cell|2>>|<row|<cell|17>|<cell|8>|<cell|47>|<cell|1>>|<row|<cell|39>|<cell|8>|<cell|>|<cell|>>>>>>|<label|tab:numberofchannels>
  Number of channels restricted to Brodmann area.>

  <big-table| <ruledtabular| <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|2|2|1|-1|cell-bborder|1ln>|<table|<row|<cell|Functional>|<cell|Brodmann>|<cell|EEG
  channel>>|<row|<cell|substructure>|<cell|area>|<cell|number>>|<row|<cell|Broca's(B)>|<cell|44,
  45>|<cell|17>>|<row|<cell|Audition(A)>|<cell|22>|<cell|5>>|<row|<cell|Cognition(C)>|<cell|9,
  10, 46, 47>|<cell|31>>|<row|<cell|Emotion(E)>|<cell|38>|<cell|5>>|<row|<cell|Vision(V)>|<cell|17,
  18, 19>|<cell|50>>|<row|<cell|Vision-parietal(Vp)>|<cell|7,
  39>|<cell|18>>|<row|<cell|Vision-temporal(Vt)>|<cell|20, 21,
  37>|<cell|51>>|<row|<cell|Motor(M)>|<cell|4, 6,
  8>|<cell|31>>|<row|<cell|Sensory(S)>|<cell|1, 2, 5,
  40>|<cell|19>>>>>>|<label|tab:functionalgroup> Number of channels
  restricted to functional substructure>

  The hierarchical organization of EEG channels have two aspects, modular
  architecture of brain functional networks detected by fast GN algorithm and
  functional groups according to anatomical parcellation of brain cortex
  based on Brodmann area. Thus, the association of these two kinds of
  hierarchical organizations, e.g. the overlap between the communities of the
  channel sets and the functional groups, is a key question which is expected
  to shed lights onto the relation between brain function and structure.

  <section|Empirical results>

  We calculate the phase-synchronization index matrix of all the sections
  which consist of continuously recorded multi-channel EEG time series. An
  average is performed over all twenty-five sections. Then the brain
  functional networks are generated using an alterable <math|N> (the number
  of nearest neighbors). The average cluster coefficient (CC) and character
  path length (CPL) are computed as a function of <math|N> (see in Fig.
  <reference|fig:smallworld>). The brain functional networks behave large CC
  and short CPL, which suggests the small-world property in consistency with
  previous works.

  <big-figure|<with|par-mode|center|<image|1.eps|3.5in|||><label|fig:smallworld>
  >|(Color online) Average cluster coefficient and character path length as a
  function of <math|N> >

  <big-figure|<with|par-mode|center|<image|2.eps|3.5in|||><label|fig:comnum>
  >|(Color online) Maximum modularity and corresponding community number as a
  function of <math|N>>

  Community structure and modular architecture are two crucial properties of
  brain functional networks during visual task. The fast GN algorithm is
  applied to explore these hierarchical organizations of these networks.
  Results are shown in Fig. <reference|fig:comnum> for different <math|N>, of
  which the minimum value is <math|3>. Figure <reference|fig:comnum>
  concretely shows that maximum modularities monotonously decrease with
  <math|N>, all above 0.5 even when <math|N\<leq\>30>, which obviously
  differs from that of randomly connected network. Furthermore, small maximum
  modularity also corresponds to large mean degree of network, which suggests
  that the more edges bridge the communities to reduce gaps of clusters and
  render community structure less visible. Obviously, the number of community
  corresponding to maximum modularity is also a monotonously decreasing
  function of <math|N>. With these considerations in mind, we mainly
  investigate the community structure and modular architecture of brain
  functional network with <math|N=3>.

  To better understand the architecture structure of brain functional
  network, we study the average cluster coefficient
  <math|<around|\<langle\>|C|\<rangle\>>> for vertices with degree <math|k>.
  Their relation reveals a negative correlation, which suggests that
  low-degree vertices generally belong to well connected clusters while the
  neighbors of high-degree vertices belong to many different communities
  which are not directly connected among themselves, namely hierarchical
  organization (see Fig. <reference|fig:correlation>). Simultaneously, the
  assortative mixing pattern (degree-degree correlation of vertices) is
  investigated by using a measure of average nearest-neighbor degree
  <math|<around|\<langle\>|K<rsub|n*n>|\<rangle\>>> that defined as the
  average over vertices with degree <math|k> (see Fig.
  <reference|fig:correlation>). Degree mixing can be organized into two
  patterns: assortative behavior if <math|<around|\<langle\>|K<rsub|n*n>|\<rangle\>>>
  increases with <math|k>, which indicates that high-degree vertices are
  preferentially connected with other high-degree vertices, and
  disassortative behavior if <math|<around|\<langle\>|K<rsub|n*n>|\<rangle\>>>
  decreases with <math|k>, which denotes that links are more easily built
  between high-degree vertices and small ones. In Fig.
  <reference|fig:correlation>, we find that
  <math|<around|\<langle\>|K<rsub|n*n>|\<rangle\>>> decreases with <math|k>,
  which indicates a disassortative behavior of brain functional network.

  <big-figure|<with|par-mode|center|<image|3.eps|3.5in|||><label|fig:correlation>
  >|(Color online) The distributions of <math|<around|\<langle\>|C|\<rangle\>>>
  and <math|<around|\<langle\>|k<rsub|n*n>|\<rangle\>>> as a function of
  <math|k>. Network is generated with <math|N=3>.>

  The community structure of brain functional network is further described by
  a dendrogram plot computed with fast GN algorithms, as shown in Fig
  <reference|fig:MM>. In Fig. <reference|fig:modularityk3>, the number of
  community corresponding to maximum modularity is 20, which is marked by a
  dash-line. Thus, in Fig. <reference|fig:Hierarchyk3>, the dendrogram plot
  only shows hierarchical tree that splits the network into 20 communities.
  Note that we do not present the whole dendrogram plot so that the end
  points of hierarchical tree still denote communities with numeric labels
  from <math|1> to <math|20> that are randomly ordered in Fig.
  <reference|fig:Hierarchyk3>.

  <big-figure|<with|par-mode|center|<subfigure*||<label|fig:modularityk3><image|4.eps|3.5in|1.6in||>>
  <space|0.3in><subfigure*||<label|fig:Hierarchyk3><image|5.eps|3.5in|1.6in||>><label|fig:MM>>|(Color
  online) Modularity (a) and dendrogram plot (b) when network is generated
  with <math|N=3>>

  To further investigate the coincidence of the two kinds of hierarchical
  organizations, we compute the overlap between modular architecture of brain
  functional network and functional groups based on anatomy parcellation of
  brain cortex in two ways. On one hand, we check how many EEG channels of
  same community belong to the same function group, which is represented by
  the composition of community written as

  <\equation>
    c<around|(|i,j|)>=<around|\||C<around|(|i|)>\<cap\>G<around|(|j|)>|\|>/<around|\||C<around|(|i|)>|\|>.<label|equ:composition>
  </equation>

  On the other hand, we investigate whether EEG channels of the same
  functional group are exactly divided into an identical community, which is
  described by participation of functional group defined as

  <\equation>
    p<around|(|i,j|)>=<around|\|||\|>*C<around|(|i|)>\<cap\>G<around|(|j|)>\|/G<around|(|j|)>\|.<label|equ:participation>
  </equation>

  In Eqs. <reference|equ:composition> and <reference|equ:participation>,
  <math|C<around|(|i|)>> and <math|G<around|(|j|)>> denote the channel set of
  community <math|i> and functional group <math|j>, respectively. If there is
  a perfect one-to-one correspondence between communities and functional
  groups, we will have <math|c<around|(|i,i|)>=p<around|(|i,i|)>=1> and
  <math|c<around|(|i,j|)>=p<around|(|i,j|)>=0>. Figure
  <reference|fig:BrodmannCom> shows the composition of the communities, which
  suggests that most of communities are mainly formed by channel sets that
  are restricted to the same Brodmann area. For instance, the community
  <math|12> (numeric label) almost overlaps with Brodmann area <math|9>, i.e.
  the channels belonging to the same function group (by anatomical
  parcellation) are densely connected, or coupled in the corresponding brain
  functional network. In Fig. <reference|fig:Participation>, the
  participation of functional group reveals that most of channel sets
  restricted to the same Brodmann areas are divided into the same
  communities. In particular, Brodmann areas <math|10>, <math|17>, and
  <math|47> are completely overlapped with the communities <math|20>,
  <math|10>, and <math|1> (numeric labels), respectively. It is noticed that
  some channel sets of functional groups are divided into several large
  communities because Brodmann areas involved with these functional groups
  are distributed in both left and right cerebral hemisphere with much larger
  spatial distance which reduces the coupling strength among neurons. For
  instance, Brodmann area 21 is mainly divided into two larger communities
  with numeric labels <math|1> and <math|15>, which are distributed in left
  and right cerebral hemispheres, respectively. This explains why the
  one-to-one correspondence between communities and functional groups are not
  perfect (i.e. <math|c<around|(|i,i|)>,p<around|(|i,i|)>\<neq\>1>).

  <big-figure|<with|par-mode|center|<subfigure*| Composition of
  community|<label|fig:Composition><image|6.eps|3.5in|||>><next-line><subfigure*|
  Participation of functional group|<label|fig:Participation><image|7.eps|3.5in|||>><label|fig:BrodmannCom>>|(Color
  online) (a) Composition of community from different function groups
  restricted to Brodmann areas. (b) Participation of functional group in
  communities of brain functional network. The result reveals the coincidence
  between modular architectures of brain functional network and functional
  groups based on anatomy parcellation of brain cortex. Network generated
  with <math|N=3> is divided into 20 communities.>

  <big-figure|<with|par-mode|center|<subfigure*| Composition of
  community|<label|fig:Compositionh><image|8.eps|3.3in|||>><next-line><subfigure*|
  Participation of functional substructure|<label|fig:Participationh>
  <image|9.eps|3.3in|||>><label|fig:GroupCom>>|(Color online) (a) Composition
  of community from different functional substructure restricted to specific
  physiological functions. (b) Participation of functional substructure in
  communities of brain functional network at a higher lever of hierarchy. The
  result shows the coincidence between modular architectures of brain
  functional network and functional substructure according to specific
  physiological functions of brain cortex. Network generated with <math|N=3>
  is divided into 9 communities.>

  In a higher level of hierarchy, the coincidence of modular architectures
  (i.e. larger communities) of brain functional network and functional
  substructures (see Tab.<reference|tab:functionalgroup>) of brain cortex is
  also studied in aforementioned ways. Concretely, the brain functional
  network is partitioned into 9 larger communities. The composition of the
  communities shows that the communities are mainly formed by channel sets
  associated with functional substructures like <em|Vision>, <em|Sensory>,
  <em|Vision-temporal>, <em|Motor>, which is well consistent with the visual
  task involved in visual, judgment and motor functions of brain (see Fig.
  <reference|fig:Compositionh>). For the participation of functional
  substructure, most of functional substructures are almost divided into
  unique communities, except for the <em|Visual-temporal> part, which is
  symmetrically distributed in two hemispheres and is separated into two
  communities, see Fig. <reference|fig:Participationh>.

  In addition, the electrical activity of neuronal networks is known to
  oscillate at various frequencies and amplitudes. The densely interconnected
  oscillators in same communities will synchronize more easily than those in
  different communities, which suggests that the synchronization reveals
  hierarchical organization for a network with a nontrivial community
  structure <cite|Arenas2006|Zhou2006a|Gardenes2007|Arenas2007|Yan2007>.
  Moreover, the simulation of neuronal activity based on anatomical cat brain
  network determines that the correlated clusters are consistent with
  anatomical areas of same brain functions
  <cite|zhou2006b|Zemanova2006|zhou2007c>. Thus, the coincidence of modular
  architectures of brain functional network and function groups of brain
  cortex at two levels of hierarchy suggests that the correlation of EEG time
  series in same functional groups is much stronger than that in different
  ones and the hierarchical organization of brain functional network may be a
  consequence of functional segmentation of brain cortex.

  <section|Conclusion>

  In conclusion, we have investigated the hierarchical organization of brain
  functional network derived from high-resolution synchronous EEG time series
  during visual task through defining vertices as EEG channels and evaluating
  connectivity between channels using a measure of phase synchronization. The
  resulting brain functional networks show common small-world property and
  community structure organized in hierarchical way. Meanwhile, by clustering
  EEG channels into functional groups based on anatomical parcellation of
  brain cortex, we find that the modular architectures of brain functional
  networks are in coincidence with these functional groups at different
  levels of hierarchy via computing overlap between communities of channel
  sets and functional groups. These interesting results suggest that
  population of neurons performing the same functions excite and inhibit in
  identical rhythms. This is reflected by that the correlation between pairs
  of EEG time series (channels) representing the neuroelectrical activity of
  same functional cortex region is enhanced during tasks related to vision,
  judgement and motor functions of brain. The structure-function relationship
  further reveals that the strong connection of channels and community
  formation in brain functional networks may be a consequence of functional
  segmentation of brain cortex.

  <\acknowledgements>
    \ This work is supported by the National Natural Science Foundation of
    China under Grant Nos. 60874090, 60974079, 61004102. S-MC appreciates the
    financial support of K.C. Wong Education Foundation, China Postdoctoral
    Science Foundation, and the Fundamental Research Funds for the Central
    Universities.
  </acknowledgements>

  <\thebibliography|Cajal1995>
    <bibitem|Cajal1995>S. R. Cajal, Histology of the Nervous System of Man
    and Vertebrates, Oxford Univ. Press, New York, 1995.

    <bibitem|Swanson2003>L. W. Swanson, Brain Architecture, Oxford Univ.
    Press, Oxford, 2003.

    <bibitem|Bullmore2009>E. Bullmore and O. Sporns, Nature Rev. Neurosci.
    10, 1 (2009).

    <bibitem|Watts1998>D.J. Watts and S.H. Strogatz, Nature 393, 440 (1998).

    <bibitem|Barabasi1999>A. L. Barabsi and R. Albert, Science 286, 509
    (1999).

    <bibitem|Stam2004>C. J. Stam, Neurosci. Lett. 355, 25 (2004).

    <bibitem|Eguiluz2005>V. M. Eguiluz, D. R. Chialvo, G. A. Cecchi, M.
    Baliki, and A. V. Apkarian, Phys. Rev. Lett. 94, 018102 (2005).

    <bibitem|Bassett2006>D. S. Bassett and E. Bullmore, The Neurosicentist
    12, 512 (2006).

    <bibitem|Achard2006>S. Achard, R. Salvador, B. Whitcher, J. Suckling, and
    E. Bullmore, J. Neurosci. 26, 63 (2006).

    <bibitem|Heuvel2008>M. P. Van den Heuvel, C. J. Stam, M. Boersma, and H.
    E. Hulshoff Pol, NeuroImage 43, 528 (2008).

    <bibitem|Gong2009>G. L. Gong, Y. He, L. Concha, C. Lebel, D. W. Gross, A.
    C. Evans, and C. Beaulieu, Cereb. Cortex 19, 524 (2009).

    <bibitem|Newman2004>M. E. J. Newman and M. Girvan, Phys. Rev. E 69,
    026113 (2004).

    <bibitem|Wilkinso2004>D. M. Wilkinson and B.A. Huberman, Proc. Natl.
    Acad. Sci. USA 101, 5241 (2004).

    <bibitem|Jonsson2006>P. F. Jonsson, T. Gavanna, D. Zicha, and P. A.
    Bates, BMC Bioinf. 7, 2 (2006).

    <bibitem|Cai2010>S. M. Cai, Y. B. Zhou, T. Zhou, and P. L. Zhou, Int. J.
    Mod. Phys. B 21(3), 433 (2010).

    <bibitem|Girvan2002>M. Girvan and M. E. J. Newman, Proc. Natl. Acad. Sci.
    USA 99, 7821 (2002).

    <bibitem|Capocci2005>A. Capocci, V. D. P. Servedio, G. Caldarelli, and F.
    Colaiori, Physica A 352, 669 (2005).

    <bibitem|Arenas2008>A. Arenas, A. Fernndez, and S. Gmez, New J. Phys.
    10(5), 053039 (2008).

    <bibitem|Zhang2009>J. Zhang, K. Zhang, X. Xu, C. K. Tse and M. Small, New
    J. Phys. 11, 113003 (2009).

    <bibitem|Zhang2010>J. Zhang, C. Zhou, X. Xu, and M. Small, Phys. Rev. E
    82, 026116 (2010).

    <bibitem|Fortunato2010>S. Fortunato, Phys. Rep. 486, 75 (2010).

    <bibitem|Salvador2005>R. Salvador, J. Suckling, M. R. Coleman, J. D.
    Pickard, D. Menon, and E. Bullmore, Cereb. Cortex 15, 1332 (2005).

    <bibitem|Ferrarini2009>L. Ferrarini, I. M. Veer, E. Baerends, M. van Tol,
    R. J. Renken, N. van der Wee, D. J. Veltman, A. Aleman, F. G. Zitman, B.
    Penninx, M. A. van Buchem, J. Reiber, S. Rombouts , and J. Milles, Hum.
    Brain Map. 30, 2220 (2009).

    <bibitem|Chavez2010>M. Chaveez, M. Valencia, V. Navarro, V. Latora, and
    J. Martinerie, Phys. Rev. Lett 104, 118701 (2010).

    <bibitem|Langheim2006>F. J. P. Langheim, A. C. Leuthold, and A. P.
    Georgopoulos, Proc. Natl. Acad. Sci. USA 103, 455 (2006).

    <bibitem|Lu2007>H. B. Lu, Y. T. Zou, H. Gu, J. A. Waltz, C. A. Scholl, W.
    Rea, Y. H. Yang, and E. A. Stein, Proc. Natl. Acad. Sci. USA 104, 18265
    (2007).

    <bibitem|Brodmann>Introduction to Brodmann area,
    <slink|http://en.wikipedia.org/wiki/Brodmann_area>

    <bibitem|web>A Human Electrophysiology Data Resource,
    <slink|http://sccn.ucsd.edu/eeglab/data/headit.html>.

    <bibitem|Makeig2002>S. Makeig, M. Westerfield, T. P. Jung, S. Enghoff, J.
    Townsend, E. Courchesne, and T. J. Sejnowski, Science 295, 690 (2002).

    <bibitem|Makeig2004>S. Makeig, A. Delorme, M. Westerfield, J. Townsend,
    E. Courchense, and T. J. Sejnowski, PLOS Biology 2, 742 (2004).

    <bibitem|Kuramoto1984>Y. Kuramoto, Chemical Oscillations, Waves, and
    Turbulence, Springer, Berlin, 1984.

    <bibitem|Yeung1999>M. K. S. Yeung and S. H. Strogatz, Phys. Rev. Lett.
    82, 648 (1999).

    <bibitem|Timme2002>M. Timme, F. Wolf and T. Geisel, Phys. Rev. Lett. 89,
    258701 (2002).

    <bibitem|Gabor1946>D. Gabor,\PTheory of information", J. IEE, 1946.

    <bibitem|Schelter2006>B. Schelter, M. Winterhalder, R. Dahlhaus, J.
    Kurth, and J. Timmer, Phys. Rev. Lett. 96, 208103 (2006).

    <bibitem|xiaoke>X. Xu, J. Zhang, and M. Small, Proc. Natl. Acad. Sci.
    105, 19601 (2008).

    <bibitem|MRIcro>Introduction to MRIcro,
    <slink|http://www.sph.sc.edu/comd/rorden/mricro.html>.

    <bibitem|SPM8>Download software from website,
    <slink|http://www.fil.ion.ucl.ac.uk/spm/software/spm8/>.

    <bibitem|Arenas2006>A. Arenas, A. Diaz-Guilera, and C. J. Perez-Vicente,
    Phys. Rev. Lett. 96, 114102 (2006).

    <bibitem|Zhou2006a>C. S. Zhou and J. Kurths, Chaos 16, 015104 (2006).

    <bibitem|Gardenes2007>J. Gomez-Gardenes, Y. Moreno, and A. Arenas, Phys.
    Rev. Lett. 98, 034101 (2007).

    <bibitem|Arenas2007>A. Arenas and A. D\D\<ordfeminine\>az-Guilera, Euro.
    Phys. Jour. B 143(1), 19 (2007).

    <bibitem|Yan2007>G. Yan, Z.-Q. Fu, J. Ren, and W. X. Wang, Phys. Rev. E
    75, 016108 (2007).

    <bibitem|zhou2006b>C. S. Zhou, L. Zemanov, G. Z. Lpez, C. C. Hilgetag,
    and J. Kurths, Phys. Rew. Lett. 97, 238103 (2006)

    <bibitem|Zemanova2006>L. Zemanov, C. S. Zhou, and J. Kurths, Physica D
    224, 202 (2006).

    <bibitem|zhou2007c>C. S. Zhou, L. Zemanov, G. Z. Lpez, C. C. Hilgetag,
    and J. Kurths, New J. Phys. 9, 178 (2007).
  </thebibliography>
</body>