<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <doc-data|<doc-title|Dynamic scaling, data-collapse and self-similarity in
  Barabsi and Albert networks>|<doc-author|<author-data|<author-name|M.
  Kamrul Hassan<rsup|<math|1>>, M. Zahedul Hassan<rsup|<math|2>>, and Neeaj
  I. Pavel<rsup|<math|1>>>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    In this article, we show that if each node in the Barabsi and Albert
    (BA) network is characterized by the generalized degree <math|q>, i.e.
    the product of their degree <math|k> and the square root of their
    respective birth time, then the distribution function
    <math|F<around|(|q,t|)>> exhibits dynamic scaling
    <math|F*<around|(|q,t\<rightarrow\>\<infty\>|)>\<sim\>t<rsup|-1/2>*\<phi\>*<around|(|q/t<rsup|1/2>|)>>
    where <math|\<phi\><around|(|x|)>> is the scaling function. Furthermore,
    we show that a series of distinct curves obtained by plotting
    <math|F<around|(|q,N|)>> vs <math|q> for different network sizes <math|N>
    collapse onto a single universal curve if
    <math|N<rsup|1/2>*F<around|(|q,N|)>> is plotted against
    <math|q/N<rsup|1/2>> instead. Finally, we find that the BA network that
    grow by sequential addition of a node with single edge and those with
    multiple edges belong to two different universality classes which are
    otherwise regarded as the same.
  </abstract>>

  Many complex systems can be described as an interwoven web of large network
  if the constituents are regarded as nodes or vertices and the interactions
  between constituents as links or edges. For example, cells of living
  systems are networks of molecules linked by chemical interaction
  <cite|ref.brain|ref.protein|ref.metabolic>, the Internet is a network of
  routers and computers linked by cables or wireless links <cite|ref.www>,
  the power-grid is a network of substations linked by transmission lines
  <cite|ref.powergrid>, and social networks are networks of individuals
  linked by friendships, professional ties, <with|font-shape|italic|etc>
  <cite|ref.redner|ref.watts|ref.amaral|ref.newman|ref.newman_1>. The first
  theoretical attempt to guide our understanding about complex network
  topology began with the seminal work of Paul Erds and Alfrd Rnyi in 1959
  <cite|ref.erdos>. The main result of the Erds-Rnyi (ER) model is that the
  degree distribution <math|P<around|(|k|)>>, the probability that a randomly
  chosen node is connected to <math|k> other nodes by one edge, is Poissonian
  revealing that it is almost impossible to find nodes that have
  significantly higher or fewer links than the average degree. However, real
  networks are neither completely regular where all the nodes have the same
  degree <math|k> nor completely random where the degree distribution is
  Poissonian.

  Just over a decade ago Barabsi and Albert revolutionized the notion of the
  network theory by recognizing the fact that natural and man-made networks
  are not static rather they grow by continuous addition of new nodes. They
  further argued that the new nodes establish links to the well connected
  existing ones <with|font-shape|italic|preferentially> rather than
  <with|font-shape|italic|randomly> - known as the preferential attachment
  (PA) rule. It essentially embodies the intuitive idea of the
  <with|font-shape|italic|rich get richer> principle of the Matthew effect in
  sociology <cite|ref.barabasi>. Barabsi and Albert (BA) then presented a
  simple theoretical model incorporating both the ingredients and showed that
  the resulting network can reproduce the power-law degree distribution which
  most real life networks exhibit <cite|ref.barabasi_1|ref.review_1>.
  Recently, we have shown that random sequential partition of a square into
  contiguous and non-overlapping blocks can be described as a network with
  power-law degree distribution if blocks are regarded as nodes and common
  border between blocks as links <cite|ref.hassan>.

  A power-law distribution function is regarded as scale-free since it looks
  the same whatever scale we look at it. In general, a function is called
  scale-free if it satisfies

  <\equation>
    <label|eq:1>f*<around|(|\<lambda\>*x|)>=g<around|(|\<lambda\>|)>*f<around|(|x|)>.
  </equation>

  It can be rigorously proved that such function can only have none but
  power-law solution <cite|ref.newman_2>. The kinetic view of network
  topology and the new terminology, <with|font-shape|italic|scale-free
  network>, has attracted physicists, mathematicians and computer scientists
  all alike which resulted in a surge of research activities
  <cite|ref.barabasi_1|ref.review_1>. On the other hand, a function
  <math|f<around|(|x,t|)>> is said to obey dynamic scaling if one of the
  variable <math|t> strictly denotes time and if it has the form

  <\equation>
    <label|eq:3>f<around|(|x,t|)>\<sim\>t<rsup|\<theta\>>*\<phi\>*<around|(|x/t<rsup|z>|)>,
  </equation>

  where exponents <math|\<theta\>> and <math|z> are fixed by the dimensional
  relations <math|<around|[|t<rsup|\<theta\>>|]>=<around|[|f|]>> and
  <math|<around|[|t<rsup|z>|]>=<around|[|x|]>> respectively, while
  <math|\<phi\><around|(|\<xi\>|)>> is known as the scaling function
  <cite|ref.family_Vicsek>. There exists yet another scaling hypothesis,
  known as the finite-size scaling (FSS), that has been extensively used as a
  very powerful tool for estimating finite size effects in the critical
  phenomena. Within the FSS formalism, a function with exactly the same form
  as in Eq. (<reference|eq:3>) is said to obey finite-size scaling if
  <math|x>, though typically denoted by <math|\<epsilon\>>, measure the
  distance from the critical point of the phenomenon under investigation and
  <math|t>, though typically denoted by <math|L>, describes the linear size
  of the system <cite|ref.fss|ref.fss_1>.

  By definition, the BA model describes a time developing phenomenon and
  hence, besides its scale-free property, one could also look for its dynamic
  scaling property. This aspect of the BA model, however, has never been
  examined. To this end, we argue that each node in the dynamic network can
  be better characterized by generalized degree <math|q>, the product of the
  square root of the birth time of each node and their corresponding degree
  <math|k>, instead of the degree <math|k> alone since the time of birth
  matters in the network. We find that the generalized degree distribution
  <math|F<around|(|q,t|)>> has some non-trivial features and exhibits dynamic
  scaling <math|F<around|(|q,t|)>\<sim\>t<rsup|-1/2>*\<phi\>*<around|(|q/t<rsup|1/2>|)>>
  in the long-time limit which has been verified using the idea of
  data-collapse. For instance, we show that a series of distinct curves
  <math|F<around|(|q,t|)>> vs <math|q> for different network sizes <math|N>
  can be made to collapse onto a single universal curve if we plot
  <math|N<rsup|1/2>*F> against <math|q/N<rsup|1/2>>. In addition, we find
  that it provides a means to classify the BA networks into different
  universality classes which are otherwise regarded as the same. Establishing
  self-similarity and data-collapse or finding the scale-free property in any
  system has always been regarded as a significant progress towards gaining
  deeper insight into the problem <cite|ref.stanley|ref.barenblatt>.

  The BA model begins with a small number of nodes <math|m<rsub|0>> as seeds
  which are already linked. Then, at each time step a new node with
  <math|m\<less\>m<rsub|0>> edges is added to the existing network. Edges of
  each new node are attached with <math|m> different existing nodes by
  picking them preferentially with respect to their degree <math|k>. That is,
  the probability that a new node will be connected to an already existing
  node <math|i> is proportional to its degree <math|k<rsub|i>> and hence the
  degree <math|k<rsub|i>> of the node <math|i> changes following the
  dynamical equation

  <\equation>
    <label|eq6><frac|\<partial\>*k<rsub|i>|\<partial\>*t>=m*<frac|k<rsub|i>|<big|sum><rsub|j><rsup|N-1>k<rsub|j>>.
  </equation>

  Note that every time a node is added to the system it adds <math|m> edges
  contributing to the increase of <math|2*m> degrees and hence
  <math|<big|sum><rsub|j><rsup|N-1>k<rsub|j>=2*m*<around|(|t-1|)>>. Solving
  Eq. (<reference|eq6>) in the long time limit and using the fact that node
  <math|i> is born at time <math|t<rsub|i>> with degree <math|m>, i.e.
  <math|k<rsub|i><around|(|t<rsub|i>|)>=m>, gives

  <\equation>
    <label|eq8>k<rsub|i><around|(|t|)>=m<around*|(|<frac|t|t<rsub|i>>|)><rsup|\<beta\>>.
  </equation>

  It implies that the degree of a node <math|i> depends not only on the
  progressing time <math|t> but also on the birth time <math|t<rsub|i>>.

  <big-figure|<image|./scaledCumulativeDistribution.ps|5.5cm|8.5cm||><label|fig
  1>|Plots of the cumulative degree distributions
  <math|C*D<around|(|k|)>\<equiv\>P*<around|(|k<rprime|'>\<geq\>k|)>> is
  shown for the BA model with <math|m=1>. The data points are averaged over
  500 independent realizations. >

  We can find the degree distribution <math|P<around|(|k,t|)>> by
  appreciating the fact that it is related to the homogeneous probability
  function <math|P<around|(|t<rsub|i>|)>\<approx\><frac|1|t>> (nodes are
  added at equal time intervals) by

  <\equation>
    <label|eq9>P<around|(|k|)>*d*k=-P<around|(|t<rsub|i>|)>*d*t<rsub|i>.
  </equation>

  Here, the minus sign is introduced to take into account that the smaller
  the <math|t<rsub|i>> the larger the degree <math|k<rsub|i>> in the
  statistical sense. Finding derivative of <math|t<rsub|i>> with respect to
  <math|k<rsub|i>> from Eq. (<reference|eq8>) and using it in Eq.
  (<reference|eq9>) we find that

  <\equation>
    <label|eq10>P<around|(|k|)>\<sim\>2*m<rsup|1/\<beta\>>*k<rsup|-\<gamma\>><space|0.5cm><math-up|with><space|0.5cm>\<gamma\>=3,
  </equation>

  which is independent of time <math|t> albeit <math|k> depends on <math|t>
  and it satisfies the scale-free form given by Eq. (<reference|eq:1>). It
  means that the network in the long time limit self-organizes into a
  scale-free state where it no longer depends on time.

  It is interesting to note that the degree distribution
  <math|P<around|(|k|)>> typically has a long tail with relatively scarce
  data points which turns into a fat-tail when we plot <math|P<around|(|k|)>>
  in log-log scale. This complicates the process of identifying the range
  over which the power-law holds and hence estimating the exponent
  <math|\<gamma\>>. One way of reducing the noise at the tail-end is to plot
  cumulative distribution <math|P*<around|(|k<rprime|'>\<geq\>k|)>> which is
  related to degree distribution <math|P<around|(|k|)>> via

  <\equation>
    P<around|(|k|)>=-<frac|d*P*<around|(|k<rprime|'>\<geq\>k|)>|d*k>.
  </equation>

  Figure 1 shows that <math|ln <around|(|P*<around|(|k<rprime|'>\<geq\>k|)>|)>>
  decays linearly against <math|ln <around|(|k|)>> with slope equal to
  <math|\<gamma\>-1=2> as expected according to Eq. (<reference|eq10>) except
  at the tail-end due to finite-size effect. Furthermore, it shows that the
  extent of linearity increases as network size <math|N> increases revealing
  that the sudden fall off near the tail-end is indeed due to finite-size
  effect. Waclaw and Sokolov in Ref. <cite|ref.waclaw> suggested that the
  finite size effect in the degree distribution of the BA network can be well
  approximated by <math|P<rsub|N><around|(|k|)>=P<around|(|k|)>*w*<around|(|k/<sqrt|N>|)>>
  where the cut-off function <math|w<around|(|x|)>> is found highly sensitive
  to both <math|m> and <math|m<rsub|0>>.

  <big-figure|<image|./scaledDegreeDistribution-multiplot.ps|5.5cm|8.5cm||><label|fig2>|Generalized
  degree distributions <math|F<around|(|q,t|)>> is shown against <math|q> for
  three different network size <math|N>. In each case data in the graph
  represent averaged over <math|500> independent realizations. >

  We thus find that the degree distribution <math|P<around|(|k,t|)>>
  self-organizes into a time invariant state in the long-time and large-size
  limit instead of a state where it assumes a dynamic scaling form. Our aim
  from now on is to look for a quantity which exhibits dynamic scaling in the
  BA model. Note that a complete characterization of the nodes in the dynamic
  network can be made by specifying their degree <math|k> as well as their
  respective birth time. We, however, find it highly instructive to combine
  the two into a single variable using Eq. (<reference|eq8>). That is, the
  node <math|i> at time <math|t> can be characterized by the generalized
  degree <math|q<rsub|i><around|(|t|)>=k<rsub|i>*t<rsub|i><rsup|\<beta\>>>
  where the exponent <math|\<beta\>> value is fixed by the dimensional
  relation <math|<around|[|q<rsup|1/\<beta\>>|]>=<around|[|t|]>>. The
  advantage of using <math|q> is that it depends only on time <math|t> since
  according to Eq. (<reference|eq8>) we have

  <\equation>
    <label|eq11>q<rsub|i><around|(|t|)>\<sim\>t<rsup|\<beta\>><space|0.5cm><math-up|with><space|0.5cm>\<beta\>=1/2.
  </equation>

  It is now customary to consider the generalized degree distribution
  <math|F<around|(|q,t|)>> instead of the traditional degree distribution
  <math|P<around|(|k|)>>. That is, if we pick a node at random at time
  <math|t> then <math|F<around|(|q,t|)>> is the probability that its
  generalized degree is <math|q>. In Fig. 2 we have drawn
  <math|F<around|(|q,t|)>> vs <math|q> for three different network sizes
  <math|N> and found some remarkable features. For instance, we find that the
  value of <math|F<around|(|q,t|)>> initially increases quite sharply and
  then register a sudden and sharp fall to a non-zero value at
  <math|q<rsub|c>> from which it rises again to a secondary maximum followed
  by a smooth decrease with a long tail. The value <math|q<rsub|c>>, where
  the first minimum occurs, increases with the network size <math|N> and at
  the same time both primary and secondary heights systematically decreases
  as <math|N> increases.

  We shall now invoke the idea of the dimensional analysis to show that
  <math|F<around|(|q,t|)>> in the long-time large-size limit self-organize
  into a state where it exhibits dynamic scaling <cite|ref.barenblatt>.
  Clearly, there are two governing parameters <math|q> and <math|t> and a
  governed parameter <math|F<around|(|q,t|)>> in the problem at hand.
  However, according to Eq. (<reference|eq11>) the governing parameter
  <math|q> can be expressed in terms of time <math|t> alone and hence we can
  define a dimensionless governing parameter

  <\equation>
    <label|eq:12>\<xi\>=<frac|q|t<rsup|1/2>>.
  </equation>

  It means we can express <math|F<around|(|q,t|)>> too in terms of time
  <math|t> alone since time <math|t> is chosen to be an independent
  parameter. Applying the power-monomial law of the dimensional function of a
  physical quantity we can write a dimensional relation
  <math|F<around|(|q,t|)>\<sim\>t<rsup|\<alpha\>>> where the exponent
  <math|\<alpha\>> assumes a value that makes <math|t<rsup|\<alpha\>>> bear
  the dimension of <math|F<around|(|q,t|)>> <cite|ref.barenblatt>. We can
  therefore define yet another dimensionless governed parameter
  <math|\<phi\>> as follows

  <\equation>
    <label|eq:13>\<phi\>=<frac|F<around|(|q,t|)>|t<rsup|\<alpha\>>>.
  </equation>

  Now, within a given class one can pass from one unit of measurements to
  another by changing <math|t>, for instance, by an arbitrary factor leaving
  the other factor <math|q> unchanged. Upon such transition within the given
  class the numerical value of the quantity on the right hand side of Eq.
  (<reference|eq:13>) must remain unchanged since the left hand side is a
  dimensionless quantity.

  <big-figure|<image|./data_collapse_m1.ps|5.5cm|8.5cm||><label|fig 3>|The
  same data of Fig. 2 is shown in the self-similar coordinates
  <math|N<rsup|1/2>*F<around|(|q,N|)>> and <math|q/N<rsup|1/2>> and it shows
  that all the three curves of Fig 2 collapsed on a single universal curve. >

  <big-figure|<image|./data_Collapse_rescaled_m123.ps|5.5cm|8.5cm||><label|fig
  4>|The value of <math|F<around|(|q,N|)>> for <math|m=1,2> and <math|3> are
  plotted in the self-similar coordinates. It clearly shows that universal
  curve for <math|m=1> do not collapse with those for <math|m\<gtr\>1> and
  hence belong to two different classes. >

  We thus find that the quantity <math|<frac|F<around|(|q,t|)>|t<rsup|\<alpha\>>>>
  <with|font-shape|italic|vis-a-vis> <math|\<phi\>> can at best be a function
  of another dimensionless quantity <math|\<xi\>> given by Eq.
  (<reference|eq:12>) since this is the only dimensionless governing
  parameter. We can express Eq. (<reference|eq:13>) as

  <\equation>
    <label|eq:ansatz>F<around|(|q,t|)>\<sim\>t<rsup|\<alpha\>>*\<phi\>*<around|(|q/t<rsup|1/2>|)>,
  </equation>

  where the exponent <math|\<alpha\>> is obtained by applying the
  normalization condition <math|<big|int><rsub|0><rsup|\<infty\>>F<around|(|q,t|)>*d*q=1>
  to give <math|\<alpha\>=-1/2>. We thus finally find that the generalized
  degree distribution assumes exactly the same dynamical scaling form as Eq.
  (<reference|eq:3>). An interesting aspect of the structure of the dynamic
  scaling form given by Eq. (<reference|eq:ansatz>) is that the distribution
  of <math|F<around|(|q,t|)>> at various moments of time can be obtained from
  one another by a similarity transformation

  <\equation>
    q\<longrightarrow\>\<lambda\><rsup|1/2>*q,<space|0.20cm>t\<longrightarrow\>\<lambda\>*t,<space|0.20cm>F\<longrightarrow\>\<lambda\><rsup|-1/2>*F,
  </equation>

  revealing the self-similar nature of the function <math|F<around|(|q,t|)>>.

  The question is: How do we verify Eq. (<reference|eq:ansatz>) using the
  data extracted from numerical simulation? Note that the total number of
  nodes at time <math|t> in the BA model is <math|N=m<rsub|0>+t> and hence in
  the long time limit we can write <math|t\<sim\>N> since the seed size is
  always assumed to satisfy <math|m<rsub|0>\<less\>\<less\>N>. Using
  <math|t\<sim\>N> in Eq. (<reference|eq:ansatz>) we can re-write it as

  <\equation>
    <label|eq:ansatz>F<around|(|q,N|)>\<sim\>N<rsup|-1/2>*\<phi\>*<around|(|q/N<rsup|1/2>|)>,
  </equation>

  and hence <math|N<rsup|1/2>*F<around|(|q,N|)>\<sim\>\<phi\>*<around|(|q/N<rsup|1/2>|)>>
  where quantities on both sides are now dimensionless. This has far reaching
  consequence in the sense that the data of <math|F<around|(|q,N|)>> for
  various network size <math|N> can be made to collapse on a single master
  curve which is essentially the scaling function
  <math|\<phi\>*<around|(|q/N<rsup|1/2>|)>>, if we plot
  <math|N<rsup|1/2>*F<around|(|q,N|)>> against <math|q/N<rsup|1/2>> which are
  known as the self-similar coordinates. In Fig. 3 we have drawn the scaled
  generalized degree distribution <math|N<rsup|\<beta\>>*F<around|(|q,t|)>>
  as a function of scaled generalized degree <math|q/N<rsup|\<beta\>>> for
  three different network sizes <math|N> assuming <math|m=1> in each case and
  find that all the distinct curves of Fig. 2 merge superbly onto a single
  curve. The first discontinuity occurs at <math|q/N<rsup|1/2>=1> and the
  second discontinuity at <math|q/N<rsup|1/2>=2> that is why both the
  discontinuities in Fig. 2 shift towards larger value of <math|q> as the
  network size <math|N> increases. Now the question is what if nodes arrive
  in the BA network with more than one edges (<math|m\<gtr\>1>)? Below, we
  attempt to give an answer to this question.

  <big-figure|<image|./log-data_Collapse_m123.ps|5.5cm|8.5cm||><label|fig
  5>|Plots of <math|ln (N<rsup|1/2>*F<around|(|q,N|)>> vs <math|ln
  <around|(|q/N<rsup|1/2>|)>> for <math|m=1> and <math|m\<gtr\>1>. It shows
  that the scaling functions <math|\<phi\><around|(|\<xi\>|)>> in both cases
  grow obeying power-law until <math|q/N<rsup|1/2>\<less\>1> but with
  exponent <math|2> and <math|2.9> for <math|m=1> and <math|m\<gtr\>1>
  respectively. >

  <big-figure|<image|./expon_d_collapse_m123.ps|5.5cm|8.5cm||><label|fig
  6>|Plots of <math|ln (N<rsup|1/2>*F<around|(|q,N|)>> as a function of
  <math|\<xi\>=q/N<rsup|1/2>> for <math|m=1> and <math|m\<gtr\>1> which
  clearly show that the scaling function <math|\<phi\><around|(|\<xi\>|)>>
  beyond <math|q/N<rsup|1/2>=2> and <math|q/N<rsup|1/2>=1.5> respectively
  decay exponentially but with two different decay constant.>

  In fact, it is expected that the data points for the BA network that grow
  by sequential addition of a node with multiple edges (<math|m\<gtr\>1>)
  should also lie on the same curve as the one for single edge (<math|m=1>)
  unless they are fundamentally different in some subtle way which the
  ordinary degree distribution <math|P<around|(|k|)>> fail to differentiate.
  Surprisingly, we find that the data points of
  <math|N<rsup|1/2>*F<around|(|q,N|)>> for <math|m=2,3,4> etc. do collapse on
  a single curve if plotted against <math|q/N<rsup|1/2>> but do not coincide
  with the one for <math|m=1> (see Fig. 4). Although the two distinct
  universal curves, one for <math|m=1> and the other for <math|m\<gtr\>1>,
  behave qualitatively almost in the similar fashion but they are different
  quantitatively. For instance, one noteworthy difference is that although
  the first discontinuity occurs at the same point as for <math|m=1>, the
  second discontinuity, however, occurs at <math|q/N<rsup|1/2>=1.5> for
  <math|m\<gtr\>1> while at <math|q/N<rsup|1/2>=2> for <math|m=1>. These
  difference can even be better appreciated if we plot
  <math|N<rsup|1/2>*F<around|(|q,N|)>> vs <math|q/N<rsup|1/2>> either in the
  log-log scale or in the log-linear scale as shown in figures 5 and 6
  respectively. Using these figures we can write the solutions for the
  universal scaling function <math|\<phi\><around|(|\<xi\>|)>> both for
  <math|m=1>

  <\equation>
    <label|eq:binary>\<phi\><around|(|\<xi\>|)>\<sim\><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<table|<row|<cell|\<xi\><rsup|2><htab|0pt>>|<cell|<space|0.5cm><math-up|if><space|.4cm>\<xi\>\<less\>1>>|<row|<cell|e<rsup|-a*\<xi\>><htab|0pt>>|<cell|<space|0.5cm><math-up|if><space|.4cm>\<xi\>\<gtr\>2>>>>>|\<nobracket\>>,
  </equation>

  and for <math|m\<gtr\>1>

  <\equation>
    <label|eq:binary>\<phi\><around|(|\<xi\>|)>\<sim\><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<table|<row|<cell|\<xi\><rsup|2.9><htab|0pt>>|<cell|<space|0.5cm><math-up|if><space|.4cm>\<xi\>\<less\>1>>|<row|<cell|e<rsup|-b*\<xi\>><htab|0pt>>|<cell|<space|0.5cm><math-up|if><space|.4cm>\<xi\>\<gtr\>1.5>>>>>|\<nobracket\>>,
  </equation>

  where <math|a\<approx\>1.4> and <math|b\<approx\>2.5>.

  Besides proving the existence of self-similarity by data-collapse we have
  also found that there are two distinct classes of networks resulting from
  the BA model: (i) The network that grows by sequential addition of one node
  with single edge (<math|m=1>) and (ii) the network that grows by sequential
  addition of one with multiple edges (<math|m\<gtr\>1>). There must be some
  reasons behind such behaviour. One apparent difference between the two
  classes of networks is that the clustering coefficient <math|C<rsub|N>=0>
  if <math|m=1> and <math|C<rsub|N>\<neq\>0> rather decays like
  <math|C<rsub|N>\<sim\>N<rsup|-0.75>> if <math|m\<gtr\>1> for network of
  size <math|N>. Regardless of the value <math|m>, the universal scaling
  function <math|\<phi\><around|(|\<xi\>|)>> always suffers two
  discontinuities which divide the nodes in the network always into three
  different classes. For instance, nodes which have generalized degree
  <math|q\<less\>N<rsup|1/2>> fall into one class, those which have
  generalized degree within <math|N<rsup|1/2>\<less\>q\<less\>2*N<rsup|1/2>>
  for <math|m=1> and <math|N<rsup|1/2>\<less\>q\<less\>1.5*N<rsup|1/2>> for
  <math|m\<gtr\>1> into another class and finally those which lie beyond
  these limits.

  To summarize, we have proposed a systematic processing procedure to obtain
  the dynamic scaling ansatz and the self-similar coordinates for the BA
  networks. To this end we have used dimensional analysis and shown that it
  provides deeper insight into the problem. We have found that if the nodes
  of the BA network are characterized by the generalized degree
  <math|q<rsub|i><around|(|t|)>> of the node <math|i> at time <math|t>,
  defined as the product of its degree <math|k<rsub|i><around|(|t|)>> at time
  <math|t> and the square root of its birth time <math|t<rsub|i>>, then its
  distribution <math|F<around|(|q,t|)>> in the long-time limit exhibits
  dynamic scaling <math|F<around|(|q,t|)>\<sim\>t<rsup|-1/2>*\<phi\>*<around|(|q/t<rsup|1/2>|)>>.
  We have verified it numerically by showing that all the data points for
  various network size <math|N> collapse onto a single universal curve if we
  plot <math|N<rsup|1/2>*F<around|(|q,N|)>> as a function of
  <math|q/N<rsup|1/2>> where <math|t> is replaced by <math|N>. Our findings
  suggest that there are two distinct classes of universal scaling functions,
  depending on whether each new node arrive with single edge or with multiple
  edges. The scaling functions <math|\<phi\><around|(|\<xi\>|)>> for
  <math|m=1> and <math|m\<gtr\>1> have some remarkable features in the sense
  that they both suffer discontinuity once at <math|\<xi\>=1> and then the
  curve for <math|m=1> at <math|\<xi\>=2> and the corresponding curve for
  <math|m\<gtr\>1> at <math|\<xi\>=1.5> albeit qualitatively they are very
  much similar. The two types of BA networks are indeed fundamentally
  different. For instance, the clustering coefficient <math|C<rsub|N>=0> if
  <math|m=1> and <math|C<rsub|N>\<sim\>N<rsup|-0.75>> if <math|m\<gtr\>1>.
  The idea of data-collapse developed for the BA model could also be applied
  on real life data as well as on the existing dynamic networks. It would
  certainly be an attractive proposition to check if the generalized degree
  distribution derived from the real life data or from other kinetic network
  too exhibit dynamic scaling with similar universal features or not. We
  intend to continue our work in this direction in our future endeavour.

  MKH and NIP gratefully acknowledge financial support from the Bose Centre
  for Advanced Study and Research of Dhaka University, Bangladesh.

  <thebibliography|99|<bibitem|ref.brain>V. M. Eguiluz, D. R. Chialvo, G. A.
  Cecchi, M. Baliki, and A. V. Apkarian, Phys. Rev. Lett.
  <with|font-series|bold|94> 018102 (2005).<bibitem|ref.protein>E. Eisenberg
  and E. Y. Levanon, Phys. Rev. Lett. <with|font-series|bold|91> 138701
  (2003).<bibitem|ref.metabolic>H. Jeong, B. Tombor, R. Albert, Z. N. Oltvai,
  and A.-L. Barabasi, Nature <with|font-series|bold|407> 651
  (2000).<bibitem|ref.www>R. Albert, H. Jeong, and A.-L. Barabsi, Nature
  <with|font-series|bold|401> 130 (1999).<bibitem|ref.powergrid>R. Albert, I.
  Albert, and G. L. Nakarado, Phys. Rev. E <with|font-series|bold|69> 025103
  (2004).<bibitem|ref.redner>S. Redner, Eur. Phys. J. B
  <with|font-series|bold|4> 131 (1998).<bibitem|ref.watts>D.J. Watts and S.H.
  Strogatz, Nature <with|font-series|bold|393> 440
  (1998).<bibitem|ref.amaral>L.A.N. Amaral, A. Scala, M. Barthelemy, and H.E.
  Stanley, PNAS <with|font-series|bold|10> 21 (2000).<bibitem|ref.newman>M.
  E. J. Newman, Phys. Rev. E <with|font-series|bold|64> 016131 (2001); ibd
  016132.<bibitem|ref.newman_1>M. E. J. Newman, Phys. Rev. E
  <with|font-series|bold|64> 025102(R) (2001).<bibitem|ref.erdos>P. Erds and
  A. Rnyi, Publications Mathematicae <with|font-series|bold|6> 290 (1959);
  Publ. Math. Inst. Hung. Acad. Sci. <with|font-series|bold|5> 17
  (1960).<bibitem|ref.barabasi>A.-L. Barabsi and R. Albert, Science
  <with|font-series|bold|286> 509 (1999).<bibitem|ref.barabasi_1>A.-L.
  Barabasi, R. Albert and H. Jeong, Physica A <with|font-series|bold|272> 173
  (1999).<bibitem|ref.review_1>S. Dorogovtsev and J. Mendes, Adv. Phys.
  <with|font-series|bold|51>, 1079 (2002).<bibitem|ref.hassan>M. K. Hassan,
  M. Z. Hassan and P. I. Pavel, New J. Phys. <with|font-series|bold|12>
  093045 (2010).<bibitem|ref.newman_2>M. E. J. Newman, SIAM Review
  <with|font-series|bold|45> 167 (2003).<bibitem|ref.family_Vicsek>F. Family
  and T. Vicsek, J. Phys. A: Math. Gen. <with|font-series|bold|18> L75
  (1985).<bibitem|ref.fss>M. E. Fisher, Critical Phenomena, edited by M. S.
  Green (Academic, New York, 1971).<bibitem|ref.fss_1>K. Binder, Phys. Rev.
  Lett. <with|font-series|bold|47> 693 (1981).<bibitem|ref.stanley>H. E.
  Stanley, <with|font-shape|italic|Introduction to Phase Transitions and
  Critical Phenomena> (Oxford University Press, London,
  1987).<bibitem|ref.barenblatt>G. I. Barenblatt,
  <with|font-shape|italic|Scaling, Self-similarity, and Intermediate
  Asymptotics> (Cmpridge University Press, 1996).<bibitem|ref.waclaw>B.
  Waclaw and I. M. Sokolov, Phys. Rev. E <with|font-series|bold|75> 056114
  (2007).>
</body>