<TeXmacs|1.99.7>

<style|<tuple|article|std-latex>>

<\body>
  <\hide-preamble>
    <assign|catquot|<macro|1|<arg|1>/<space|-0.17em><space|-0.17em><space|-0.17em>\<equiv\>>>

    <assign|strid|<macro|1|<cpdfinput|<arg|1>.ps>>>

    <assign|sstrid|<macro|1|<strid|<arg|1>>>>

    <assign|svxym|<macro|1|<vcenter|<xymatrix@C>=7ex@R=7ex<arg|1>>>>

    <assign|axioms|<macro|<em|Ax>>>

    <assign|sgramor|<macro| \| \ \ >>

    <assign|wrt|<macro|wrt>>

    <assign|tc|<macro|1|2|<xtwocell*|<arg|1>|><omit|<arg|2>>>>

    <assign|Inno|<macro|<math-bf|Inno>>>

    <assign|LInno|<macro|<math-bf|LInno>>>

    <assign|PreInno|<macro|<math-bf|PreInno>>>

    <assign|Aut|<macro|1|<math-up|Aut>(<arg|1>)>>

    <assign|Bij|<macro|<math-bf|Bij>>>

    <assign|FinSet|<macro|<math-bf|FinSet>>>

    <assign|FMR|<macro|<math-bf|MRel>>>

    <assign|FOR|<macro|<math-bf|FinOrdRel>>>

    <assign|FBA|<macro|<math-bf|FBAlg>>>

    <assign|BBA|<macro|<math-bf|BBiAlg>>>

    <assign|Games|<macro|<math-bf|Games>>>

    <assign|CGames|<macro|<math-bf|CGames>>>

    <assign|Alg|<macro|1|2|<math-bf|Alg><rsub|<arg|1>><rsup|<arg|2>>>>

    <assign|intset|<macro|1|<arg|1>>>

    <assign|End|<macro|1|<math-up|End><pa|<arg|1>>>>

    <assign|moves|<macro|1|M<rsub|<arg|1>>>>

    <assign|Unit|<macro|<math-bf|U>>>

    <assign|quest|<macro|<math-bf|q>>>

    <assign|unit|<macro|<math-bf|u>>>

    <assign|gameorder|<macro|1|\<leq\><rsub|<arg|1>>>>

    <assign|strategyorder|<macro|1|\<leq\><rsub|<arg|1>>>>

    <assign|qforall|<macro|1|\<forall\><arg|1>.>>

    <assign|qexists|<macro|1|\<exists\><arg|1>.>>

    <new-theorem|definition|Definition>

    <new-theorem|corollary|Corollary>

    <new-theorem|lemma|Lemma>

    <new-theorem|property|Property>

    <new-theorem|proposition|Proposition>

    <new-theorem|theorem|Theorem>

    <new-theorem|fct|Fact>

    <new-theorem|example|Example>

    <new-theorem|remark|Remark>

    <assign|paragraph|<macro|1|<vspace|2fn><no-indent><with|font-series|bold|<arg|1>><space|0.27em>>>

    <assign|qtis|<macro|<space|1em>is<space|1em>>>

    <assign|eqth|<macro|1|<with|math-font|Euler|<arg|1>>>>

    <assign|intp|<macro|1|\<llbracket\><arg|1>\<rrbracket\>>>

    <assign|card|<macro|1|<left|\|><arg|1><right|\|>>>

    <assign|size|<macro|1|<left|\|><arg|1><right|\|>>>

    <assign|lrule|<macro|1|(<arg|1>)>>

    <assign|lrulel|<macro|1|<lrule|<math|<arg|1>>-L>>>

    <assign|lruler|<macro|1|<lrule|<math|<arg|1>>-R>>>

    <assign|before|<macro|\<varolessthan\>>>

    <assign|after|<macro|\<varogreaterthan\>>>

    <assign|labelitemi|<macro|-->>
  </hide-preamble>

  <doc-data|<doc-title|The Structure of First-Order
  Causality>|<doc-author|<author-data|<author-misc|This work was has been
  supported by the CHOCO (``Curry Howard pour la Concurrence'',
  ANR-07-BLAN-0324) French ANR project.>|<author-name|Samuel
  Mimram>>>|<doc-date|>>

  <abstract-data|<\abstract>
    Game semantics describe the interactive behavior of proofs by
    interpreting formulas as games on which proofs induce strategies. Such a
    semantics is introduced here for capturing dependencies induced by
    quantifications in first-order propositional logic. One of the main
    difficulties that has to be faced during the elaboration of this kind of
    semantics is to characterize definable strategies, that is strategies
    which actually behave like a proof. This is usually done by restricting
    the model to strategies satisfying subtle combinatorial conditions, whose
    preservation under composition is often difficult to show. Here, we
    present an original methodology to achieve this task, which requires to
    combine advanced tools from game semantics, rewriting theory and
    categorical algebra. We introduce a diagrammatic presentation of the
    monoidal category of definable strategies of our model, by the means of
    generators and relations: those strategies can be generated from a finite
    set of atomic strategies and the equality between strategies admits a
    finite axiomatization, this equational structure corresponding to a
    polarized variation of the notion of bialgebra. This work thus bridges
    algebra and denotational semantics in order to reveal the structure of
    dependencies induced by first-order quantifiers, and lays the foundations
    for a mechanized analysis of causality in programming languages.
  </abstract>>

  Denotational semantics were introduced to provide useful abstract
  invariants of proofs and programs modulo cut-elimination or reduction. In
  particular, game semantics, introduced in the nineties, have been very
  successful in capturing precisely the interactive behavior of programs. In
  these semantics, every type is interpreted as a <em|game> (that is as a set
  of <em|moves> that can be played during the game) together with the rules
  of the game (formalized by a partial order on the moves of the game
  indicating the dependencies between them). Every move is to be played by
  one of the two players, called <em|Proponent> and <em|Opponent>, who should
  be thought respectively as the program and its environment. The
  interactions between these two players are sequences of moves respecting
  the partial order of the game, called <em|plays>. In this setting, a
  program is characterized by the set of plays that it can exchange with its
  environment during an execution and thus defines a <em|strategy> reflecting
  the interactive behavior of the program inside the game specified by the
  type of the program.

  The notion of <em|pointer game>, introduced by Hyland and
  Ong<nbsp><cite|hyland-ong:full-abstraction-pcf>, gave one of the first
  fully abstract models of PCF (a simply-typed <math|\<lambda\>>-calculus
  extended with recursion, conditional branching and arithmetical constants).
  It has revealed that PCF programs generate strategies with partial memory,
  called <em|innocent> because they react to Opponent moves according to
  their own <em|view> of the play. Innocence is in this setting the main
  ingredient to characterize <em|definable> strategies, that is strategies
  which are the interpretation of a PCF term, because it describes the
  behavior of the purely functional core of the language
  (<ie><math|\<lambda\>>-terms), which also corresponds to proofs in
  propositional logic. This seminal work has lead to an extremely successful
  series of semantics: by relaxing in various ways the innocence constraint
  on strategies, it became suddenly possible to generalize this
  characterization to PCF programs extended with imperative features such as
  references, control, non-determinism, etc.

  Unfortunately, these constraints are quite specific to game semantics and
  remain difficult to link with other areas of computer science or algebra.
  They are moreover very subtle and combinatorial and thus sometimes
  difficult to work with. This work is an attempt to find new ways to
  describe the behavior of proofs.

  <paragraph|Generating instead of restricting.> In this paper, we introduce
  a game semantics capturing dependencies induced by quantifiers in
  first-order propositional logic, forming a strict monoidal category called
  <math|<Games>>. Instead of characterizing definable strategies of the model
  by restricting to strategies satisfying particular conditions, we show here
  that we can equivalently use a kind of converse approach. We show how to
  <em|generate> definable strategies by giving a <em|presentation> of those
  strategies: a finite set of definable strategies can be used to generate
  all definable strategies by composition and tensoring, and the equality
  between strategies obtained this way can be finitely axiomatized.

  What we mean precisely by a presentation is a generalization of the usual
  notion of presentation of a monoid to monoidal categories. For example,
  consider the additive monoid <math|\<bbb-N\><rsup|2>=\<bbb-N\>\<times\>\<bbb-N\>>.
  It admits the presentation<nbsp><math|<pangle|<space|0.27em>p,q<space|0.27em>\|<space|0.27em>q*p=p*q<space|0.27em>>>,
  where <math|p> and <math|q> are two <em|generators> and <math|q*p=p*q> is a
  relation between two elements of the free monoid <math|M> on
  <math|<around|{|p,q|}>>. This means that <math|\<bbb-N\><rsup|2>> is
  isomorphic to the free monoid <math|M> on the two generators, quotiented by
  the smallest congruence <math|\<equiv\>> (<wrt> multiplication) such that
  <math|q*p\<equiv\>p*q>. More generally, a (strict) monoidal
  category<nbsp><math|\<cal-C\>> (such as<nbsp><math|<Games>>) can be
  presented by a <em|polygraph>, consisting of typed generators in dimension
  1 and<nbsp>2 and relations in dimension 3, such that the
  category<nbsp><math|\<cal-C\>> is monoidally equivalent to the free
  monoidal category on the generators, quotiented by the congruence generated
  by the relations.

  <paragraph|Reasoning locally.> The usefulness of our construction is both
  theoretic and practical. It reveals that the essential algebraic structure
  of dependencies induced by quantifiers is a polarized variation of the
  well-known structure of bialgebra, thus bridging game semantics and
  algebra. It also proves very useful from a technical point of view: this
  presentation allows us to reason locally about strategies. In particular,
  it enables us to deduce a posteriori that these strategies actually
  <em|compose>, which is not trivial, and it also enables us to deduce that
  the strategies of the category<nbsp><math|<Games>> are <em|definable> (one
  only needs to check that generators are definable). Finally, the
  presentation gives a finite description of the category, that we can hope
  to manipulate with a computer, paving the way for a series of new tools to
  automate the study of semantics of programming languages.

  <paragraph|A game semantics capturing first-order causality.> Game
  semantics has revealed that proofs in logic describe particular strategies
  to explore formulas, or more generally sequents. Namely, a formula (or a
  sequent) is a syntactic tree expressing in which order its connectives must
  be introduced in cut-free proofs. In this sense, it can be seen as the
  rules of a game whose moves correspond to connectives. For instance,
  consider a sequent of the form

  <\equation>
    <label|eq:ex-formula><qforall|x>P<space|1em>\<vdash\><space|1em><qforall|y><qexists|z>Q
  </equation>

  where <math|P> and <math|Q> are propositional formulas which may contain
  free variables. When searching for a proof of<nbsp><eqref|eq:ex-formula>,
  the <math|\<forall\>y> quantification must be introduced before the
  <math|\<exists\>z> quantification, and the <math|\<forall\>x>
  quantification can be introduced independently. Here, introducing an
  existential quantification on the right of a sequent should be thought as
  playing a Proponent move (the strategy gives a witness for which the
  formula holds) and introducing an universal quantification as playing an
  Opponent move (the strategy receives a term from its environment, for which
  it has to show that the formula holds); introducing a quantification on the
  left of a sequent is similar but with polarities inverted since it is the
  same as introducing the dual quantification on the right of the sequent.
  So, the game associated to the formula<nbsp><eqref|eq:ex-formula> will be
  the partial order on the first-order quantifications appearing in the
  formula, depicted below (to be read from the top to the bottom):

  <\equation>
    <tformat|<table|<row|<cell|<label|eq:ex-formula-game><xymatrix@R>=4*e*x*@*C=4*e*x\<forall\>x>|<cell|<ar@*|-|d>\<forall\>y>>|<row|<cell|>|<cell|\<exists\>z>>|<row|<cell|>|<cell|>>>>
  </equation>

  This partial order is sometimes called the <em|syntactic partial order>
  generated by the sequent. Possible proofs of
  sequent<nbsp><eqref|eq:ex-formula> in first-order propositional logic are
  of one of the three following shapes:

  <\equation*>
    <inferrule|<inferrule|<inferrule|<inferrule|\<vdots\>|P*<around|[|t/x|]>\<vdash\>Q*<around|[|t<rprime|'>/z|]>>|P*<around|[|t/x|]>\<vdash\><qexists|z>Q>|P*<around|[|t/x|]>\<vdash\><qforall|y><qexists|z>Q>|<qforall|x>P\<vdash\><qforall|y><qexists|z>Q><space|2em><space|2em><inferrule|<inferrule|<inferrule|<inferrule|\<vdots\>|P*<around|[|t/x|]>\<vdash\>Q*<around|[|t<rprime|'>/z|]>>|P*<around|[|t/x|]>\<vdash\><qexists|z>Q>|<qforall|x>P\<vdash\><qexists|z>Q>|<qforall|x>P\<vdash\><qforall|y><qexists|z>Q><space|2em><space|2em><inferrule|<inferrule|<inferrule|<inferrule|\<vdots\>|P*<around|[|t/x|]>\<vdash\>Q*<around|[|t<rprime|'>/z|]>>|<qforall|x>P\<vdash\>Q*<around|[|t<rprime|'>/z|]>>|<qforall|x>P\<vdash\><qexists|z>Q>|<qforall|x>P\<vdash\><qforall|y><qexists|z>Q>
  </equation*>

  where <math|P*<around|[|t/x|]>> denotes the formula <math|P> where every
  occurrence of the free variable <math|x> has been replaced by the term
  <math|t>. These proofs introduce the connectives in the orders depicted
  respectively below

  <\equation*>
    <xymatrix@R>=4*e*x*@*C=4*e*x<ar@*|-|d>\<forall\>x<next-line><ar@*|-|d>\<forall\>y<next-line>\<exists\>z<next-line><space|2em><xymatrix@R>=4*e*x*@*C=4*e*x<ar@*|-|d>\<forall\>y<next-line><ar@*|-|d>\<forall\>x<next-line>\<exists\>z<next-line><space|2em><xymatrix@R>=4*e*x*@*C=4*e*x<ar@*|-|d>\<forall\>y<next-line><ar@*|-|d>\<exists\>z<next-line>\<forall\>x<next-line>
  </equation*>

  which are all total orders extending the partial order of the
  game<nbsp><eqref|eq:ex-formula-game>: these correspond to the plays in the
  strategies interpreting the proofs in the game semantics. In this sense,
  they have more dependencies between moves: proofs add causal dependencies
  between connectives.

  Some sequentializations induced by proofs are not really relevant. For
  example consider a proof of the form

  <\equation*>
    <inferrule|<inferrule|<inferrule|\<pi\>|P\<vdash\>Q>|P\<vdash\><qforall|y>Q>|<qexists|x>P\<vdash\><qforall|y>Q>
  </equation*>

  The order in which the introduction rules of the universal and existential
  quantifications are introduced is not really significant here since this
  proof might always be reorganized into the proof

  <\equation*>
    <inferrule|<inferrule|<inferrule|\<pi\>|P\<vdash\>Q>|<qexists|x>P\<vdash\>Q>|<qexists|x>P\<vdash\><qforall|y>Q>
  </equation*>

  by \Ppermuting\Q the introduction rules. Similarly, the following
  permutations of rules are always possible:

  <\equation*>
    <inferrule|<inferrule|<inferrule|\<pi\>|P*<around|[|t/x|]>\<vdash\>Q*<around|[|u/y|]>>|P*<around|[|t/x|]>\<vdash\><qexists|y>Q>|<qforall|x>P\<vdash\><qexists|y>Q>\<rightsquigarrow\><inferrule|<inferrule|<inferrule|\<pi\>|P*<around|[|t/x|]>\<vdash\>Q*<around|[|u/y|]>>|<qforall|x>P\<vdash\>Q*<around|[|u/y|]>>|<qforall|x>P\<vdash\><qexists|y>Q><qtand><inferrule|<inferrule|<inferrule|\<pi\>|P*<around|[|t/x|]>\<vdash\>Q>|P*<around|[|t/x|]>\<vdash\><qforall|y>Q>|<qforall|x>P\<vdash\><qforall|y>Q>\<rightsquigarrow\><inferrule|<inferrule|<inferrule|\<pi\>|P*<around|[|t/x|]>\<vdash\>Q>|<qforall|x>P\<vdash\>Q>|<qforall|x>P\<vdash\><qforall|y>Q>
  </equation*>

  Interestingly, the permutation

  <\equation*>
    <inferrule|<inferrule|<inferrule|\<pi\>|P\<vdash\>Q*<around|[|t/y|]>>|P\<vdash\><qexists|y>Q>|<qexists|x>P\<vdash\><qexists|y>Q><space|2em>\<rightsquigarrow\><space|2em><inferrule|<inferrule|<inferrule|\<pi\>|P\<vdash\>Q*<around|[|t/y|]>>|<qexists|x>P\<vdash\>Q*<around|[|t/y|]>>|<qexists|x>P\<vdash\><qexists|y>Q>
  </equation*>

  is only possible if the term <math|t> used in the introduction rule of the
  <math|\<exists\>y> connective does not have <math|x> as free variable. If
  the variable<nbsp><math|x> is free in <math|t> then the rule introducing
  <math|\<exists\>y> can only be used after the rule introducing the
  <math|\<exists\>x> connective. Now, the
  sequent<nbsp><math|<qexists|x>P\<vdash\><qexists|y>Q> will be interpreted
  by the following game

  <\equation*>
    <strid|d*e*p<rsub|e>*x*0>
  </equation*>

  Whenever the<nbsp><math|\<exists\>y> connective depends on
  the<nbsp><math|\<exists\>x> connective (<ie>whenever<nbsp><math|x> is free
  in the witness term<nbsp><math|t> provided for<nbsp><math|y>), the strategy
  corresponding to the proof will contain a causal dependency, which will be
  depicted by an oriented wire

  <\equation*>
    <strid|d*e*p<rsub|e>*x>
  </equation*>

  and we sometimes say that the move<nbsp><math|\<exists\>x> <em|justifies>
  the move<nbsp><math|\<exists\>y>. A simple further study of permutability
  of introduction rules of first-order quantifiers shows that this is the
  only kind of relevant dependencies. These permutations of rules where the
  motivation for the introduction of non-alternating asynchronous game
  semantics<nbsp><cite|mellies-mimram:ag5>, where plays are considered modulo
  certain permutations of consecutive moves. However, we focus here on
  causality and define strategies by the dependencies they induce on moves (a
  precise description of the relation between these two points of view was
  investigated in<nbsp><cite|mimram:phd>). They are also very closely related
  to the motivations for the introduction of Hintikka's games and
  independence friendly logic<nbsp><cite|hintikka-sandu:gts>.

  We thus build a strict monoidal category whose objects are games and whose
  morphisms are strategies, in which we can interpret formulas and proofs in
  the connective-free fragment of first-order propositional logic, and
  write<nbsp><math|<Games>> for the subcategory of definable strategies. One
  should thus keep in mind the following correspondences while reading this
  paper:

  <\center>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|1ln>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|3|3|1|-1|cell-bborder|1ln>|<table|<row|<cell|category>|<cell|logic>|<cell|game
    semantics>|<cell|combinatorial objects>>|<row|<cell|object>|<cell|formula>|<cell|game>|<cell|syntactic
    order>>|<row|<cell|morphism>|<cell|proof>|<cell|strategy>|<cell|justification
    order>>>>>
  </center>

  This paper is devoted to the construction of a presentation for this
  category. We introduce formally the notion of presentation of a monoidal
  category in Section<nbsp><reference|sec:pres> and recall some useful
  classical algebraic structures in Section<nbsp><reference|sec:alg-struct>.
  Then, we give a presentation of the category of relations in
  Section<nbsp><reference|section:presentation-rel> and extend this
  presentation to the category<nbsp><math|<Games>>, that we define formally
  in Section<nbsp><reference|section:games-strategies>.

  <section|Presentations of monoidal categories><label|sec:pres>

  We recall here briefly some basic definitions in category theory. The
  interested reader can find a more detailed presentation of these concepts
  in MacLane's reference book<nbsp><cite|maclane:cwm>.

  <paragraph|Monoidal categories.> A <em|monoidal category>
  <math|<around|(|\<cal-C\>,\<otimes\>,I|)>> is a category <math|\<cal-C\>>
  together with a functor

  <\equation*>
    \<otimes\>:\<cal-C\>\<times\>\<cal-C\>\<to\>\<cal-C\>
  </equation*>

  and natural isomorphisms

  <\equation*>
    \<alpha\><rsub|A,B,C>:<around|(|A\<otimes\>B|)>\<otimes\>C\<to\>A\<otimes\><around|(|B\<otimes\>C|)><tcomma><space|1em>\<lambda\><rsub|A>:I\<otimes\>A\<to\>A<qtand>\<rho\><rsub|A>:A\<otimes\>I\<to\>A
  </equation*>

  satisfying coherence axioms<nbsp><cite|maclane:cwm>. A symmetric monoidal
  category <math|\<cal-C\>> is a monoidal category <math|\<cal-C\>> together
  with a natural isomorphism

  <\equation*>
    \<gamma\><rsub|A,B>:A\<otimes\>B\<to\>B\<otimes\>A
  </equation*>

  satisfying coherence axioms and such that
  <math|\<gamma\><rsub|B,A>\<circ\>\<gamma\><rsub|A,B>=<rsub|A\<otimes\>B>>.
  A monoidal category<nbsp><math|\<cal-C\>> is <em|strictly> monoidal when
  the natural isomorphisms <math|\<alpha\>>, <math|\<lambda\>> and
  <math|\<rho\>> are identities. For the sake of simplicity, in the rest of
  this paper we only consider strict monoidal categories. Formally, it can be
  shown that it is not restrictive, using MacLane's coherence
  theorem<nbsp><cite|maclane:cwm>: every monoidal category is monoidally
  equivalent to a strict one.

  A (strict) <em|monoidal functor> <math|F:\<cal-C\>\<to\>\<cal-D\>> between
  two strict monoidal categories <math|\<cal-C\>> and <math|\<cal-D\>> is a
  functor <math|F> between the underlying categories such that
  <math|F*<around|(|A\<otimes\>B|)>=F<around|(|A|)>\<otimes\>F<around|(|B|)>>
  for every objects <math|A> and <math|B> of <math|\<cal-C\>>, and
  <math|F<around|(|I|)>=I>. A <em|monoidal natural transformation>
  <math|\<theta\>:F\<to\>G> between two monoidal functors
  <math|F,G:\<cal-C\>\<to\>\<cal-D\>> is a natural transformation between the
  underlying functors <math|F> and <math|G> such that
  <math|\<theta\><rsub|A\<otimes\>B>=\<theta\><rsub|A>\<otimes\>\<theta\><rsub|B>>
  for every objects <math|A> and <math|B> of <math|\<cal-C\>>, and
  <math|\<theta\><rsub|I>=<rsub|I>>. Two monoidal categories <math|\<cal-C\>>
  and <math|\<cal-D\>> are <em|monoidally equivalent> when there exists a
  pair of monoidal functors <math|F:\<cal-C\>\<to\>\<cal-D\>> and
  <math|G:\<cal-D\>\<to\>\<cal-C\>> and two invertible monoidal natural
  transformations <math|\<eta\>:<math-up|Id><rsub|<mathcal>>C\<to\>G*F> and
  <math|\<varepsilon\>:F*G\<to\><math-up|Id><rsub|<mathcal>>D>.

  <paragraph|Monoidal theories.> A <em|monoidal theory> <math|\<bbb-T\>> is a
  strict monoidal category whose objects are the natural integers, such that
  the tensor product on objects is the addition of integers. By an integer
  <math|<wide*|n|\<bar\>>>, we mean here the finite ordinal
  <math|<wide*|n|\<bar\>>=<around|{|0,1,\<ldots\>,n-1|}>> and the addition is
  given by <math|<wide*|m|\<bar\>>+<wide*|n|\<bar\>>=<wide*|m+n|\<bar\>>> (we
  will simply write<nbsp><math|n> instead of<nbsp><math|<wide*|n|\<bar\>>> in
  the following). An <em|algebra> <math|F> of a monoidal theory
  <math|\<bbb-T\>> in a strict monoidal category <math|\<cal-C\>> is a strict
  monoidal functor from<nbsp><math|\<bbb-T\>> to <math|\<cal-C\>>; we
  write<nbsp><math|<Alg|\<bbb-T\>|\<cal-C\>>> for the category of algebras
  from <math|\<bbb-T\>> to <math|\<cal-C\>> and monoidal natural
  transformations between them. Monoidal theories are sometimes called PRO,
  this terminology was introduced by MacLane in<nbsp><cite|maclane:ca> as an
  abbreviation for \Pcategory with products\Q. They generalize equational
  theories \U or Lawere theories<nbsp><cite|lawvere:phd> \U in the sense that
  operations are typed and can moreover have multiple outputs as well as
  multiple inputs, and are not necessarily cartesian but only monoidal.

  <paragraph|Presentations of monoidal categories.><label|subsection:moncat-presentation>We
  now recall the notion of <em|presentation> of a monoidal category by the
  means of typed 1- and 2-dimensional generators and relations.

  Suppose that we are given a set <math|E<rsub|1>> whose elements are called
  <em|atomic types> or <em|generators for objects>. We write
  <math|E<rsub|1><rsup|\<ast\>>> for the free monoid on the set
  <math|E<rsub|1>> and <math|i<rsub|1>:E<rsub|1>\<to\>E<rsub|1><rsup|\<ast\>>>
  for the corresponding injection; the product of this monoid is written
  <math|\<otimes\>>. The elements of<nbsp><math|E<rsub|1><rsup|\<ast\>>> are
  called <em|types>. Suppose moreover that we are given a set
  <math|E<rsub|2>>, whose elements are called <em|generators> (<em|for
  morphisms>), together with two functions
  <math|s<rsub|1>,t<rsub|1>:E<rsub|2>\<to\>E<rsub|1><rsup|\<ast\>>>, which to
  every generator associate a type called respectively its <em|source> and
  <em|target>. We call a <em|signature> such a 4-uple
  <math|<around|(|E<rsub|1>,s<rsub|1>,t<rsub|1>,E<rsub|2>|)>>:

  <\equation*>
    <svxym|<tformat|<table|<row|<cell|E<rsub|1><ar*|d><rsub|i<rsub|1>>>|<cell|<ar@>\<less\>-0.7*e*x\<gtr\><around|[|d*l|]><rsub|s<rsub|1>><ar@>\<less\>0.7*e*x\<gtr\><around|[|d*l|]><rsup|t<rsub|1>>*E<rsub|2>>>|<row|<cell|E<rsub|1><rsup|\<ast\>>>|<cell|>>|<row|<cell|>|<cell|>>>>>
  </equation*>

  <no-indent>Every such signature <math|<around|(|E<rsub|1>,s<rsub|1>,t<rsub|1>,E<rsub|2>|)>>
  generates a free strict monoidal category <math|\<cal-E\>>, whose objects
  are the elements of<nbsp><math|E<rsub|1><rsup|\<ast\>>> and whose morphisms
  are formal composite and formal tensor products of elements of
  <math|E<rsub|2>>, quotiented by suitable laws imposing associativity of
  composition and tensor and compatibility of composition with tensor,
  see<nbsp><cite|burroni:higher-word>. If we write
  <math|E<rsub|2><rsup|\<ast\>>> for the morphisms of this category and
  <math|i<rsub|2>:E<rsub|2>\<to\>E<rsub|2><rsup|\<ast\>>> for the injection
  of the generators into this category, we get a diagram

  <\equation*>
    <svxym|<tformat|<table|<row|<cell|E<rsub|1><ar*|d><rsub|i<rsub|1>>>|<cell|<ar@>\<less\>-0.7*e*x\<gtr\><around|[|d*l|]><rsub|s<rsub|1>><ar@>\<less\>0.7*e*x\<gtr\><around|[|d*l|]><rsup|t<rsub|1>>*E<rsub|2><ar*|d><rsub|i<rsub|2>>>>|<row|<cell|E<rsub|1><rsup|\<ast\>>>|<cell|<ar@>\<less\>-0.7*e*x\<gtr\><around|[|l|]><rsub|<wide|s<rsub|1>|\<bar\>>><ar@>\<less\>0.7*e*x\<gtr\><around|[|l|]><rsup|<wide|t<rsub|1>|\<bar\>>>*E<rsub|2><rsup|\<ast\>>>>|<row|<cell|>|<cell|>>>>>
  </equation*>

  in <math|<Set>> together with a structure of monoidal
  category<nbsp><math|\<cal-E\>> on the graph

  <\equation*>
    <tformat|<table|<row|<cell|<xymatrix@C>=10*e*x*@*R=10*e*xE<rsub|1><rsup|\<ast\>>>|<cell|<ar@>\<less\>-0.7*e*x\<gtr\><around|[|l|]><rsub|<wide|s<rsub|1>|\<bar\>>><ar@>\<less\>0.7*e*x\<gtr\><around|[|l|]><rsup|<wide|t<rsub|1>|\<bar\>>>*E<rsub|2><rsup|\<ast\>>>>|<row|<cell|>|<cell|>>>>
  </equation*>

  where the morphisms <math|<wide|s<rsub|1>|\<bar\>>,<wide|t<rsub|1>|\<bar\>>:E<rsub|2><rsup|\<ast\>>\<to\>E<rsub|1><rsup|\<ast\>>>
  are the morphisms (unique by universality of
  <math|E<rsub|2><rsup|\<ast\>>>) such that
  <math|s<rsub|1>=<wide|s<rsub|1>|\<bar\>>\<circ\>i<rsub|2>> and
  <math|t<rsub|1>=<wide|t<rsub|1>|\<bar\>>\<circ\>i<rsub|2>>. The <em|size>
  <math|<size|f>> of a morphism <math|f:A\<to\>B> in
  <math|E<rsub|2><rsup|\<ast\>>> is defined inductively by

  <\equation*>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<table|<row|<cell|<size|>>|<cell|0>|<cell|<size|f>>|<cell|1<text|<space|1em>if
    <math|f> is a generator>>>|<row|<cell|<size|f<rsub|1>\<otimes\>f<rsub|2>>>|<cell|<size|f<rsub|1>>+<size|f<rsub|2>>>|<cell|<size|f<rsub|2>\<circ\>f<rsub|1>>>|<cell|<size|f<rsub|1>>+<size|f<rsub|2>>>>>>>
  </equation*>

  In particular, a morphism is of size <math|0> if and only if it is an
  identity.

  Our constructions are an instance in dimension 2 of Burroni's polygraphs
  <cite|burroni:higher-word>, and Street's
  2<nbd>computads<nbsp><cite|street:limit-indexed-by-functors>, who made
  precise the sense in which the generated monoidal category is free on the
  signature. Namely, the following notion of equational theory is a
  specialization of the definition of a 3-polygraph to the case where there
  is only one generator for 0-cells.

  <\definition>
    A <with|font-series|bold|monoidal equational theory> is a 7-uple

    <\equation*>
      <eqth|E>=<around|(|E<rsub|1>,s<rsub|1>,t<rsub|1>,E<rsub|2>,s<rsub|2>,t<rsub|2>,E<rsub|3>|)>
    </equation*>

    where <math|<around|(|E<rsub|1>,s<rsub|1>,t<rsub|1>,E<rsub|2>|)>> is a
    signature together with a set <math|E<rsub|3>> of <em|relations> and two
    morphisms <math|s<rsub|2>,t<rsub|2>:E<rsub|3>\<to\>E<rsub|2><rsup|\<ast\>>>,
    as pictured in the diagram

    <\equation*>
      <svxym|<tformat|<table|<row|<cell|E<rsub|1><ar*|d><rsub|i<rsub|1>>>|<cell|<ar@>\<less\>-0.7*e*x\<gtr\><around|[|d*l|]><rsub|s<rsub|1>><ar@>\<less\>0.7*e*x\<gtr\><around|[|d*l|]><rsup|t<rsub|1>>*E<rsub|2><ar*|d><rsub|i<rsub|2>>>|<cell|<ar@>\<less\>-0.7*e*x\<gtr\><around|[|d*l|]><rsub|s<rsub|2>><ar@>\<less\>0.7*e*x\<gtr\><around|[|d*l|]><rsup|t<rsub|2>>*E<rsub|3>>>|<row|<cell|E<rsub|1><rsup|\<ast\>>>|<cell|<ar@>\<less\>-0.7*e*x\<gtr\><around|[|l|]><rsub|<wide|s<rsub|1>|\<bar\>>><ar@>\<less\>0.7*e*x\<gtr\><around|[|l|]><rsup|<wide|t<rsub|1>|\<bar\>>>*E<rsub|2><rsup|\<ast\>>>|<cell|>>|<row|<cell|>|<cell|>|<cell|>>>>>
    </equation*>

    such that <math|<wide|s<rsub|1>|\<bar\>>\<circ\>s<rsub|2>=<wide|s<rsub|1>|\<bar\>>\<circ\>t<rsub|2>>
    and <math|<wide|t<rsub|1>|\<bar\>>\<circ\>s<rsub|2>=<wide|t<rsub|1>|\<bar\>>\<circ\>t<rsub|2>>.
  </definition>

  Every equational theory defines a monoidal category
  <math|\<bbb-E\>=<catquot|\<cal-E\>>> obtained from the monoidal category
  <math|\<cal-E\>> generated by the signature
  <math|<around|(|E<rsub|1>,s<rsub|1>,t<rsub|1>,E<rsub|2>|)>> by quotienting
  the morphisms by the congruence <math|\<equiv\>> generated by the relations
  of the equational theory <math|<eqth|E>>: it is the smallest congruence
  (<wrt> both composition and tensoring) such that
  <math|s<rsub|2><around|(|e|)>\<equiv\>t<rsub|2><around|(|e|)>> for every
  element <math|e> of <math|E<rsub|3>>.

  We say that a monoidal equational theory <math|<eqth|E>> is a
  <em|presentation> of a strict monoidal category <math|\<cal-M\>> when
  <math|\<cal-M\>> is monoidally equivalent to the category <math|\<bbb-E\>>
  generated by<nbsp><math|<eqth|E>>. Any monoidal
  category<nbsp><math|\<cal-M\>> admits a presentation (for example, the
  trivial presentation with<nbsp><math|E<rsub|1>> the set of objects
  of<nbsp><math|\<cal-M\>>, <math|E<rsub|2>> the set of morphisms
  of<nbsp><math|\<cal-M\>>, and<nbsp><math|E<rsub|3>> the set of all
  equalities between morphisms holding in<nbsp><math|\<cal-M\>>), which is
  not unique in general. In such a presentation, the category
  <math|\<cal-E\>> generated by the signature underlying<nbsp><math|<eqth|E>>
  should be thought as a category of \Pterms\Q (which will be considered
  modulo the relations described by<nbsp><math|E<rsub|2>>) and is thus
  sometimes called the <em|syntactic category> of<nbsp><math|<eqth|E>>.

  We sometimes informally say that an equational theory has a <em|generator>
  <math|f:A\<to\>B> to mean that <math|f> is an element of <math|E<rsub|2>>
  such that <math|s<rsub|1><around|(|f|)>=A> and
  <math|t<rsub|1><around|(|f|)>=B>. We also say that the equational theory
  has a <em|relation> <math|f=g> to mean that there exists an element
  <math|e> of <math|E<rsub|3>> such that <math|s<rsub|2><around|(|e|)>=f>
  and<nbsp><math|t<rsub|2><around|(|e|)>=g>.

  We say that two equational theories are <em|equivalent> when they generate
  monoidally equivalent categories. A generator <math|f> in an equational
  theory <math|<eqth|E>> is <em|superfluous> when the equational theory
  <math|<eqth|E<rprime|'>>> obtained from <math|<eqth|E>> by removing the
  generator <math|f> and all equations involving <math|f>, is equivalent to
  <math|<eqth|E>>. Similarly, an equation <math|e> is <em|superfluous> when
  the equational theory <math|<eqth|E<rprime|'>>> obtained from
  <math|<eqth|E>> by removing the equation <math|e> is equivalent to
  <math|<eqth|E>>. An equational theory is <em|minimal> when it does not
  contain any superfluous generator or equation.

  Notice that every monoidal equational theory
  <math|<around|(|E<rsub|1>,s<rsub|1>,t<rsub|1>,E<rsub|2>,s<rsub|2>,t<rsub|2>,E<rsub|3>|)>>
  where the set<nbsp><math|E<rsub|1>> is reduced to only one object
  <math|<around|{|1|}>> generates a monoidal category which is a monoidal
  theory (<math|<N>> is the free monoid on one object), thus giving a notion
  of presentation of those categories.

  <paragraph|Presented categories as models.> Suppose that a strict monoidal
  category <math|\<cal-M\>> is presented by an equational theory
  <math|<eqth|E>>, generating a category <math|\<bbb-E\>=<catquot|\<cal-E\>>>.
  The proof that <math|<eqth|E>> presents<nbsp><math|\<cal-M\>> can generally
  be decomposed in two parts:

  <\enumerate>
    <item><em|<math|\<cal-M\>> is a model of the equational theory
    <math|<eqth|E>>>: there exists a functor
    <math|M:\<bbb-E\>\<to\>\<cal-M\>>. This amounts to checking that there
    exists a functor <math|M<rprime|'>:\<cal-E\>\<to\>\<cal-M\>> such that
    for all morphisms <math|f,g:A\<to\>B> in <math|\<cal-E\>>,
    <math|f\<equiv\>g> implies <math|M<rprime|'>*f=M<rprime|'>*g>.

    <item><em|<math|\<cal-M\>> is a fully-complete model of the equational
    theory <math|<eqth|E>>>: the functor <math|M> is full and faithful.
  </enumerate>

  We sometimes say that a morphism <math|f:A\<to\>B> of <math|\<bbb-E\>>
  <em|represents> the morphism <math|Mf:MA\<to\>MB> of<nbsp><math|\<cal-M\>>.

  Usually, the first point is a straightforward verification. Proving that
  the functor <math|M> is full and faithful often requires more work. In this
  paper, we use the methodology introduced by
  Burroni<nbsp><cite|burroni:higher-word> and refined by
  Lafont<nbsp><cite|lafont:boolean-circuits>. We first define <em|canonical
  forms> which are canonical representatives of the equivalence classes of
  morphisms of <math|\<cal-E\>> under the congruence <math|\<equiv\>>
  generated by the relations of <math|<eqth|E>>. Proving that every morphism
  is equal to a canonical form can be done by induction on the size of the
  morphisms. Then, we show that the functor <math|M> is full and faithful by
  showing that the canonical forms are in bijection with the morphisms
  of<nbsp><math|\<cal-M\>>.

  It should be noted that this is not the only technique to prove that an
  equational theory presents a monoidal category. In particular, Joyal and
  Street have used topological methods<nbsp><cite|joyal-street:geometry-tensor-calculus>
  by giving a geometrical construction of the category generated by a
  signature, in which morphisms are equivalence classes under continuous
  deformation of progressive plane diagrams (we give some more details about
  those diagrams, also called string diagrams, later on). Their work is for
  example extended by Baez and Langford in<nbsp><cite|baez-langford:two-tangles>
  to give a presentation of the 2-category of 2-tangles in 4<nbsp>dimensions.
  The other general methodology the author is aware of, is given by Lack
  in<nbsp><cite|lack:composing-props>, by constructing elaborate monoidal
  theories from simpler monoidal theories. Namely, a monoidal theory can be
  seen as a monad in a particular span bicategory, and monoidal theories can
  therefore be \Pcomposed\Q given a distributive law between their
  corresponding monads. We chose not to use those methods because, even
  though they can be very helpful to build intuitions, they are difficult to
  formalize and even more to mechanize: we believe indeed that some of the
  tedious proofs given in this paper could be somewhat automated, a first
  step in this direction was given in<nbsp><cite|mimram:rta10> where we
  describe an algorithm to compute critical pairs in polygraphic rewriting
  systems of dimension 2.

  <paragraph|String diagrams.><label|subsection:string-diagrams><em|String
  diagrams> provide a convenient way to represent and manipulate the
  morphisms in the category generated by a presentation. Given an object
  <math|M> in a strict monoidal category <math|\<cal-C\>>, a morphism
  <math|\<mu\>:M\<otimes\>M\<to\>M> can be drawn graphically as a device with
  two inputs and one output of type <math|M> as follows:

  <\equation*>
    <strid|m*u*l*t<rsub|m><rsub|l>*a*b*e*l><space|2em><text|or simply
    as><space|2em><strid|m*u*l*t<rsub|m>>
  </equation*>

  when it is clear from the context which morphism of type
  <math|M\<otimes\>M\<to\>M> we are picturing (we sometimes even omit the
  source and target of the morphisms). Similarly, the identity
  <math|<rsub|M>:M\<to\>M> (which we sometimes simply write <math|M>) can be
  pictured as a wire

  <\equation*>
    <strid|i*d<rsub|m>>
  </equation*>

  The tensor <math|f\<otimes\>g> of two morphisms <math|f:A\<to\>B> and
  <math|g:C\<to\>D> is obtained by putting the diagram corresponding to
  <math|f> above the diagram corresponding to<nbsp><math|g>. So, for
  instance, the morphism <math|\<mu\>\<otimes\>M> can be drawn
  diagrammatically as

  <\equation*>
    <strid|m*u*l*t<rsub|x><rsub|i>*d<rsub|m>>
  </equation*>

  Finally, the composite <math|g\<circ\>f:A\<to\>C> of two morphisms
  <math|f:A\<to\>B> and <math|g:B\<to\>C> can be drawn diagrammatically by
  putting the diagram corresponding to <math|g> at the right of the diagram
  corresponding to <math|f> and \Plinking the wires\Q. The diagram
  corresponding to the morphism <math|\<mu\>\<circ\><around|(|\<mu\>\<otimes\>M|)>>
  is thus

  <\equation*>
    <strid|m*u*l*t<rsub|a>*s*s*o*c<rsub|l><rsub|m>>
  </equation*>

  Suppose that <math|<around|(|E<rsub|1>,s<rsub|1>,t<rsub|1>,E<rsub|2>|)>> is
  a signature. Every element <math|f> of <math|E<rsub|2>> such that

  <\equation*>
    s<rsub|1><around|(|f|)>=A<rsub|1>\<otimes\>\<cdots\>\<otimes\>A<rsub|m><qtand>t<rsub|1><around|(|f|)>=B<rsub|1>\<otimes\>\<cdots\>\<otimes\>B<rsub|n>
  </equation*>

  where the <math|A<rsub|i>> and <math|B<rsub|i>> are elements of
  <math|E<rsub|1>>, can be similarly represented by a diagram

  <\equation*>
    <strid|s*i*g*n*a*t*u*r*e<rsub|f>>
  </equation*>

  where wires correspond to generators for objects and circled points to
  generators for morphisms. Bigger diagrams can be constructed from these
  diagrams by composing and tensoring them, as explained above. Joyal and
  Street have shown in details in<nbsp><cite|joyal-street:geometry-tensor-calculus>
  that the category of those diagrams, modulo continuous deformations, is
  precisely the free category generated by a signature (which they call a
  \Ptensor scheme\Q). For example, the equality

  <\equation*>
    <around|(|M\<otimes\>\<mu\>|)>\<circ\><around|(|\<mu\>\<otimes\>M\<otimes\>M|)><qeq><around|(|\<mu\>\<otimes\>M|)>\<circ\><around|(|M\<otimes\>M\<otimes\>\<mu\>|)>
  </equation*>

  in the category <math|\<cal-C\>> of the above example, which holds because
  of the axioms satisfied in any monoidal category, can be shown by
  continuously deforming the diagram on the left-hand side below into the
  diagram on the right-hand side:

  <\equation*>
    <sstrid|m*u<rsub|x><rsub|m>*u<rsub|r>><qeq><sstrid|m*u<rsub|x><rsub|m>*u<rsub|l>>
  </equation*>

  All the equalities satisfied in any monoidal category generated by a
  signature have a similar geometrical interpretation. And conversely, any
  deformation of diagrams corresponds to an equality of morphisms in monoidal
  categories.

  <section|Algebraic structures><label|sec:alg-struct>

  In this section, we recall the categorical formulation of some well-known
  algebraic structures, the most fundamental in this work being maybe the
  notion of <em|bialgebra>. We give those definitions in the setting of a
  strict monoidal category which is <em|not> required to be symmetric. We
  suppose that <math|<around|(|\<cal-C\>,\<otimes\>,I|)>> is a strict
  monoidal category, fixed throughout the section.

  <paragraph|Symmetric objects.> A <em|symmetric object> of <math|\<cal-C\>>
  is an object<nbsp><math|S> together with a morphism

  <\equation*>
    \<gamma\>:S\<otimes\>S\<to\>S\<otimes\>S
  </equation*>

  called <em|symmetry> and pictured as

  <\equation>
    <label|eq:sym-string><strid|s*y*m<rsub|s>>
  </equation>

  such that the diagrams

  <\equation*>
    <\latex_preview|xymatrix>
      <\text>
        \\xymatrix{

        \ \ S\\otimes S\\otimes S\\ar[d]_{S\\otimes\\gamma}\\ar[r]^{\\gamma\\otimes
        S}&S\\otimes S\\otimes S\\ar[r]^{S\\otimes\\gamma}&S\\otimes
        S\\otimes S\\ar[d]^{\\gamma\\otimes S}\\\\

        \ \ S\\otimes S\\otimes S\\ar[r]_{\\gamma\\otimes S}&S\\otimes
        S\\otimes S\\ar[r]_{S\\otimes\\gamma}&S\\otimes S\\otimes S\\\\

        }
      </text>
    </latex_preview>
  </equation*>

  and

  <\equation*>
    <\latex_preview|xymatrix>
      <\text>
        \\xymatrix{

        \ \ &S\\otimes S\\ar[dr]^{\\gamma}&\\\\

        \ \ S\\otimes S\\ar[ur]^{\\gamma}\\ar[rr]_{S\\otimes S}&&S\\otimes
        S\\\\

        }
      </text>
    </latex_preview>
  </equation*>

  commute. Graphically,

  <\equation>
    <label|eq:sym><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<sstrid|y*a*n*g<rsub|b>*a*x*t*e*r<rsub|r>>>|<cell|<qeq>>|<cell|<sstrid|y*a*n*g<rsub|b>*a*x*t*e*r<rsub|l>>>>|<row|<cell|<sstrid|s*y*m<rsub|s>*y*m>>|<cell|<qeq>>|<cell|<sstrid|i*d<rsub|x><rsub|i>*d>>>>>>
  </equation>

  (the first equation is sometimes called the Yang-Baxter equation for
  braids). In particular, in a symmetric monoidal category, every object is
  canonically equipped with a structure of symmetric object.

  <paragraph|Monoids.><label|subsection:monoids>A <em|monoid>
  <math|<around|(|M,\<mu\>,\<eta\>|)>> in <math|\<cal-C\>> is an object
  <math|M> together with two morphisms

  <\equation*>
    \<mu\>:M\<otimes\>M\<to\>M<qtand>\<eta\>:I\<to\>M
  </equation*>

  called respectively <em|multiplication> and <em|unit> and pictured
  respectively as

  <\equation>
    <label|eq:monoid-string><strid|m*u*l*t<rsub|m>><qtand><strid|u*n*i*t<rsub|m>>
  </equation>

  such that the diagrams

  <\equation*>
    <vxym|<tformat|<table|<row|<cell|M\<otimes\>M\<otimes\>M<ar*|d><rsub|M\<otimes\>\<mu\>><ar*|r><rsup|->\<mu\>\<otimes\>M>|<cell|M\<otimes\>M<ar*|d><rsup|\<mu\>>>>|<row|<cell|M\<otimes\>M<ar*|r><rsub|\<mu\>>>|<cell|M>>>>><tand><vxym|<tformat|<table|<row|<cell|<ar*|d*r><rsub|M>I\<otimes\>M<ar*|r><rsup|\<eta\>\<otimes\>M>>|<cell|M\<otimes\>M<ar*|d><rsub|\<mu\>>>|<cell|<ar*|l><rsub|M\<otimes\>\<eta\>>M\<otimes\>I<ar*|d*l><rsup|M>>>|<row|<cell|>|<cell|M>|<cell|>>>>>
  </equation*>

  commute. Graphically,

  <\equation>
    <label|eq:monoid><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<strid|m*u*l*t<rsub|a>*s*s*o*c<rsub|l>><qeq><strid|m*u*l*t<rsub|a>*s*s*o*c<rsub|r>>>>|<row|<cell|<sstrid|m*u*l*t<rsub|u>*n*i*t<rsub|l>><qeq><sstrid|m*u*l*t<rsub|u>*n*i*t<rsub|c>><qeq><sstrid|m*u*l*t<rsub|u>*n*i*t<rsub|r>>>>>>>
  </equation>

  A <em|symmetric monoid> is a monoid equipped with a symmetry morphism
  <math|\<gamma\>:M\<otimes\>M\<to\>M\<otimes\>M> which is compatible with
  the operations of the monoid in the sense that it makes the diagrams

  <\equation*>
    <\tabular*>
      <\tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<cwith|1|1|1|-1|cell-valign|top>|<cwith|1|1|1|-1|cell-vmode|exact>|<cwith|1|1|1|-1|cell-height|<plus|1fn|4ex>>|<cwith|2|2|1|-1|cell-valign|top>|<cwith|2|2|1|-1|cell-vmode|exact>|<cwith|2|2|1|-1|cell-height|<plus|1fn|4ex>>>
        <\table>
          <\row>
            <\cell>
              <\latex_preview|xymatrix>
                <\text>
                  \\xymatrix{

                  \ \ \ \ \ \ \\ar[d]_{\\mu\\otimes M}M\\otimes M\\otimes
                  M\\ar[r]^{M\\otimes \\gamma}&M\\otimes M\\otimes
                  M\\ar[r]^{\\gamma\\otimes M}&M\\otimes M\\otimes
                  M\\ar[d]^{M\\otimes\\mu}\\\\

                  \ \ \ \ \ \ M\\otimes M\\ar[rr]_{\\gamma}&&M\\otimes M\\\\

                  \ \ \ \ }
                </text>
              </latex_preview>
            </cell>
          </row>
        <|table>
          <\row>
            <\cell>
              <\latex_preview|xymatrix>
                <\text>
                  \\xymatrix{

                  \ \ \ \ \ \ \\ar[d]_{M\\otimes \\mu}M\\otimes M\\otimes
                  M\\ar[r]^{\\gamma\\otimes M}&M\\otimes M\\otimes
                  M\\ar[r]^{M\\otimes\\gamma}&M\\otimes M\\otimes
                  M\\ar[d]^{\\mu\\otimes M}\\\\

                  \ \ \ \ \ \ M\\otimes M\\ar[rr]_{\\gamma}&&M\\otimes M\\\\

                  \ \ \ \ }
                </text>
              </latex_preview>
            </cell>
          </row>
        </table|<row|<\cell>
          <\latex_preview|xymatrix>
            <\text>
              \\xymatrix{

              \ \ \ \ \ \ &M\\otimes M\\ar[dr]^{\\gamma}&\\\\

              \ \ \ \ \ \ M\\ar[ur]^{\\eta\\otimes M}\\ar[rr]_{\\eta\\otimes
              M}&&M\\otimes M\\\\

              \ \ \ \ }
            </text>
          </latex_preview>

          <space|2em>

          <\latex_preview|xymatrix>
            <\text>
              \\xymatrix{

              \ \ \ \ \ \ &M\\otimes M\\ar[dr]^{\\gamma}&\\\\

              \ \ \ \ \ \ M\\ar[ur]^{M\\otimes\\eta}\\ar[rr]_{M\\otimes\\eta}&&M\\otimes
              M\\\\

              \ \ \ \ }
            </text>
          </latex_preview>
        </cell>>>
      </tformat>
    </tabular*>
  </equation*>

  commute. Graphically,

  <\equation>
    <label|eq:monoid-nat><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<strid|m*u*l*t<rsub|s>*y*m<rsub|r>*n*a*t<rsub|r>><qeq><strid|m*u*l*t<rsub|s>*y*m<rsub|r>*n*a*t<rsub|l>>>>|<row|<cell|<strid|e*t*a<rsub|s>*y*m<rsub|r>*n*a*t<rsub|l>><qeq><strid|e*t*a<rsub|s>*y*m<rsub|r>*n*a*t<rsub|r>>>>>>>
  </equation>

  are satisfied, as well as the equations obtained by turning the diagrams
  upside-down. A <em|commutative monoid> is a symmetric monoid such that the
  diagram

  <\equation*>
    <vxym|<tformat|<table|<row|<cell|>|<cell|M\<otimes\>M<ar*|d*r><rsup|\<mu\>>>|<cell|>>|<row|<cell|M\<otimes\>M<ar*|u*r><rsup|\<gamma\>><ar*|r*r><rsub|\<mu\>>>|<cell|>|<cell|M>>>>>
  </equation*>

  commutes. Graphically,

  <\equation>
    <label|eq:monoid><strid|m*u*l*t<rsub|c>*o*m*m><qeq><strid|m*u*l*t>
  </equation>

  In particular, a commutative monoid in a symmetric monoidal category is a
  commutative monoid whose symmetry corresponds to the symmetry of the
  category: <math|\<gamma\>=\<gamma\><rsub|M,M>>. In this case, the equations
  <eqref|eq:monoid-nat> can always be deduced from the naturality of the
  symmetry of the monoidal category.

  A <em|comonoid> <math|<around|(|M,\<delta\>,\<varepsilon\>|)>> in
  <math|\<cal-C\>> is an object <math|M> together with two morphisms

  <\equation*>
    \<delta\>:M\<to\>M\<otimes\>M<qtand>\<varepsilon\>:M\<to\>I
  </equation*>

  respectively drawn as

  <\equation>
    <label|eq:comonoid-string><strid|c*o*m*u*l*t<rsub|m>><qqtand><strid|c*o*u*n*i*t<rsub|m>>
  </equation>

  satisfying dual coherence diagrams. Similarly, the notions symmetric
  comonoid and cocommutative comonoid can be defined by duality.

  The definition of a monoid can be reformulated internally, in the language
  of equational theories:

  <\definition>
    <label|definition:e-t-monoid>The <em|equational theory of monoids>
    <math|<eqth|M>> has one generator for objects <math|1> and two generators
    for morphisms <math|\<mu\>:2\<to\>1> and <math|\<eta\>:0\<to\>1> subject
    to the three relations

    <\equation>
      <label|eq:monoid-theory><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|\<mu\>\<circ\><around|(|\<mu\>\<otimes\><rsub|1>|)><qeq>\<mu\>\<circ\><around|(|<rsub|1>\<otimes\>\<mu\>|)>>>|<row|<cell|\<mu\>\<circ\><around|(|\<eta\>\<otimes\><rsub|1>|)><qeq><rsub|1><qeq>\<mu\>\<circ\><around|(|<rsub|1>\<otimes\>\<eta\>|)>>>>>>
    </equation>
  </definition>

  <no-indent>The equations<nbsp><eqref|eq:monoid-theory> correspond precisely
  to the equations for a monoid object<nbsp><eqref|eq:monoid>. If we write
  <math|\<bbb-M\>> for the monoidal category generated by the equational
  theory <math|<eqth|M>>, the algebras of <math|\<bbb-M\>> in a strict
  monoidal category<nbsp><math|\<cal-C\>> are precisely its monoids: the
  category <math|<Alg|\<bbb-M\>|\<cal-C\>>> of algebras of the monoidal
  theory <math|\<bbb-M\>> in <math|\<cal-C\>> is monoidally equivalent to the
  category of monoids in<nbsp><math|\<cal-C\>>. Similarly, all the algebraic
  structures introduced in this section can be defined using algebraic
  theories.

  <\remark>
    The presentations given here are not necessarily minimal. For example, in
    the theory of commutative monoids one equation for units of
    monoids<nbsp><eqref|eq:monoid-string> is derivable from the
    equation<nbsp><eqref|eq:monoid<rsub|m>ult<rsub|c>omm>, one of the
    equations<nbsp><eqref|eq:monoid-nat> and one of the equations for units
    of monoids<nbsp><eqref|eq:monoid-string>:

    <\equation*>
      <sstrid|m*u*l*t<rsub|u>*n*i*t<rsub|r>><space|-0.17em><qeq><space|-0.17em><sstrid|m*u*l*t<rsub|u>*n*i*t<rsub|r><rsub|s>*y*m><space|-0.17em><qeq><space|-0.17em><sstrid|m*u*l*t<rsub|u>*n*i*t<rsub|l>><space|-0.17em><qeq><space|-0.17em><sstrid|m*u*l*t<rsub|u>*n*i*t<rsub|c>>
    </equation*>

    A minimal presentation of this equational theory with three generators
    and seven equations is given in<nbsp><cite|massol:minimality>. However,
    not all the equational theories introduced in this paper have a known
    presentation which is proved to be minimal.
  </remark>

  <paragraph|Bialgebras.> A <em|bialgebra>
  <math|<around|(|B,\<mu\>,\<eta\>,\<delta\>,\<varepsilon\>,\<gamma\>|)>> in
  <math|\<cal-C\>> is an object <math|B> together with five morphisms

  <\equation*>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<table|<row|<cell|\<mu\>>|<cell|B\<otimes\>B\<to\>B>|<cell|\<eta\>>|<cell|I\<to\>B>>|<row|<cell|\<delta\>>|<cell|B\<to\>B\<otimes\>B>|<cell|\<varepsilon\>>|<cell|B\<to\>I>>>>><tand>

    \<gamma\>:B\<otimes\>B\<to\>B\<otimes\>B
  </equation*>

  such that <math|\<gamma\>:B\<otimes\>B\<to\>B\<otimes\>B> is a symmetry for
  <math|B>, <math|<around|(|B,\<mu\>,\<eta\>,\<gamma\>|)>> is a symmetric
  monoid and <math|<around|(|B,\<delta\>,\<varepsilon\>,\<gamma\>|)>> is a
  symmetric comonoid. The morphism <math|\<gamma\>> is thus pictured as
  in<nbsp><eqref|eq:sym-string>, <math|\<mu\>> and <math|\<eta\>> as in
  <eqref|eq:monoid-string>, and<nbsp><math|\<delta\>>
  and<nbsp><math|\<varepsilon\>> as in<nbsp><eqref|eq:comonoid-string>. Those
  two structures should be coherent, in the sense that the diagrams

  <\equation*>
    <\tabular*>
      <\tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>>
        <\table>
          <\row>
            <\cell>
              <\latex_preview|xymatrix>
                <\text>
                  \\xymatrix{

                  \ \ \ \ B\\otimes B\\ar[d]_{\\delta\\otimes\\delta}\\ar[r]^-{\\mu}&B\\ar[r]^-{\\delta}&B\\otimes
                  B\\\\

                  \ \ \ \ B\\otimes B\\otimes B\\otimes
                  B\\ar[rr]_{B\\otimes\\gamma\\otimes
                  B}&&\\ar[u]_{\\mu\\otimes\\mu}B\\otimes B\\otimes B\\otimes
                  B\\\\

                  \ \ }
                </text>
              </latex_preview>
            </cell>
          <|row>
            <\cell>
              <\latex_preview|xymatrix>
                <\text>
                  \\xymatrix{

                  \ \ \ \ &B\\ar[dr]^{\\varepsilon}&\\\\

                  \ \ \ \ I\\ar[ur]^{\\eta}\\ar[rr]_{I}&&I

                  \ \ }
                </text>
              </latex_preview>
            </cell>
          </row>
        <|table>
          <\row>
            <\cell>
              <\latex_preview|xymatrix>
                <\text>
                  \\xymatrix{

                  \ \ \ \ &B\\ar[dr]^{\\varepsilon}&\\\\

                  \ \ \ \ B\\otimes B\\ar[ur]^{\\mu}\\ar[rr]_{\\varepsilon\\otimes\\varepsilon}&&I\\otimes
                  I=I

                  \ \ }
                </text>
              </latex_preview>
            </cell>
          <|row>
            <\cell>
              <\latex_preview|xymatrix>
                <\text>
                  \\xymatrix{

                  \ \ \ \ &B\\ar[dr]^{\\delta}&\\\\

                  \ \ \ \ I=I\\otimes I\\ar[ur]^{\\eta}\\ar[rr]_{\\eta\\otimes\\eta}&&B\\otimes
                  B

                  \ \ }
                </text>
              </latex_preview>
            </cell>
          </row>
        </table>
      </tformat>
    </tabular*>
  </equation*>

  should commute. Graphically,

  <\equation>
    <label|eq:bialg><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<sstrid|h*o*p*f<rsub|l>>=<sstrid|h*o*p*f<rsub|r>>>>|<row|<cell|<sstrid|c*o*u*n*i*t<rsub|m>*u*l*t>=<sstrid|c*o*u*n*i*t<rsub|x><rsub|c>*o*u*n*i*t><space|2em><sstrid|c*o*m*u*l*t<rsub|u>*n*i*t>=<sstrid|u*n*i*t<rsub|x><rsub|u>*n*i*t><space|2em><sstrid|u*n*i*t<rsub|c>*o*u*n*i*t>=>>>>>
  </equation>

  should be satisfied.

  A bialgebra is <em|commutative> (<resp><em|cocommutative>) when the induced
  symmetric monoid <math|<around|(|B,\<mu\>,\<eta\>,\<gamma\>|)>>
  (<resp>symmetric comonoid <math|<around|(|B,\<delta\>,\<varepsilon\>,\<gamma\>|)>>)
  is commutative (<resp>cocommutative), and <em|bicommutative> when it is
  both commutative and cocommutative. A bialgebra is <em|qualitative> when
  the diagram

  <\equation*>
    <\latex_preview|xymatrix>
      <\text>
        \\xymatrix{

        \ \ &B\\otimes B\\ar[dr]^{\\mu}&\\\\

        \ \ B\\ar[ur]^{\\delta}\\ar[rr]_{B}&&B

        }
      </text>
    </latex_preview>
  </equation*>

  commutes. Graphically,

  <\equation>
    <label|eq:qualitative><strid|r*e*l<rsub|l>><qeq><strid|r*e*l<rsub|r>>
  </equation>

  <\definition>
    We write <math|<eqth|B>> for the <em|equational theory of bicommutative
    bialgebras>. It has one generator for objects<nbsp><math|1>, five
    generators for morphisms

    <\equation*>
      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<table|<row|<cell|\<mu\>>|<cell|2\<to\>1>|<cell|\<eta\>>|<cell|0\<to\>1>>|<row|<cell|\<delta\>>|<cell|1\<to\>2>|<cell|\<varepsilon\>>|<cell|1\<to\>0>>>>><tand>

      \<gamma\>:2\<to\>2
    </equation*>

    and twenty-two relations: the two relations of
    symmetry<nbsp><eqref|eq:sym>, the eight relations of commutative
    monoids<nbsp><eqref|eq:monoid> <eqref|eq:monoid-nat>
    <eqref|eq:monoid<rsub|m>ult<rsub|c>omm>, the eight relations of
    cocommutative comonoids which are dual of<nbsp><eqref|eq:monoid>
    <eqref|eq:monoid-nat> <eqref|eq:monoid<rsub|m>ult<rsub|c>omm>, and the
    four compatibility relations for bialgebras<nbsp><eqref|eq:bialg>.

    We also write <math|<eqth|R>> for the <em|equational theory of
    qualitative bicommutative bialgebras> which is defined
    as<nbsp><math|<eqth|B>>, with the relation<nbsp><eqref|eq:qualitative>
    added.
  </definition>

  <paragraph|Dual objects.> An object <math|L> of <math|\<cal-C\>> is said to
  be <em|left dual> to an object <math|R> when there exists two morphisms

  <\equation*>
    \<eta\>:I\<to\>R\<otimes\>L<qtand>\<varepsilon\>:L\<otimes\>R\<to\>I
  </equation*>

  called respectively the <em|unit> and the <em|counit> of the duality and
  respectively pictured as

  <\equation*>
    <strid|a*d*j<rsub|u>*n*i*t<rsub|l>*r><qtand><strid|a*d*j<rsub|c>*o*u*n*i*t<rsub|l>*r>
  </equation*>

  making the diagrams

  <\equation*>
    <vxym|<tformat|<table|<row|<cell|>|<cell|L\<otimes\>R\<otimes\>L<ar*|d*r><rsup|\<varepsilon\>\<otimes\>L>>|<cell|>>|<row|<cell|L<ar*|u*r><rsup|L\<otimes\>\<eta\>><ar*|r*r><rsub|L>>|<cell|>|<cell|L>>|<row|<cell|>|<cell|>|<cell|>>>>><qtand><vxym|<tformat|<table|<row|<cell|>|<cell|R\<otimes\>L\<otimes\>R<ar*|d*r><rsup|R\<otimes\>\<varepsilon\>>>|<cell|>>|<row|<cell|R<ar*|u*r><rsup|\<eta\>\<otimes\>R><ar*|r*r><rsub|R>>|<cell|>|<cell|R>>|<row|<cell|>|<cell|>|<cell|>>>>>
  </equation*>

  commute. Graphically,

  <\equation*>
    <strid|z*i*g<rsub|z>*a*g<rsub|l>>=<strid|i*d<rsub|L>><space|-0.17em><qtand><space|-0.17em><strid|z*i*g<rsub|z>*a*g<rsub|r>>=<strid|i*d<rsub|R>>
  </equation*>

  We write<nbsp><math|<eqth|D>> for the equational theory associated to dual
  objects.

  <\remark>
    If <math|\<cal-C\>> is a category, two dual objects in the monoidal
    category <math|<math-up|End><around|(|\<cal-C\>|)>> of endofunctors of
    <math|\<cal-C\>>, with tensor product given on objects by composition of
    functors, are adjoint endofunctors of <math|\<cal-C\>>. The theory of
    adjoint functors in a 2-category is described precisely
    in<nbsp><cite|street:free-adj>, the definition of <math|<eqth|D>> is a
    specialization of this construction to the case where there is only one
    0-cell.
  </remark>

  <section|Presenting the category of relations><label|section:presentation-rel>

  We now introduce a presentation of the category <math|<Rel>> of finite
  ordinals and relations, by refining presentations of simpler categories.
  This result is mentioned in Examples<nbsp>6 and<nbsp>7
  of<nbsp><cite|hyland-power:symmetric-monoidal-sketches> and is proved in
  three different ways in<nbsp><cite|lafont:equational-reasoning-diagrams>,
  <cite|pirashvili:bialg-prop> and<nbsp><cite|lack:composing-props>. The
  methodology adopted here to build this presentation has the advantage of
  being simple to check (although very repetitive) and can be extended to
  give the presentation of the category of games and strategies described in
  Section<nbsp><reference|subsection:walking-inno>.

  <paragraph|The simplicial category.> The simplicial category
  <math|\<Delta\>> is the monoidal theory whose morphisms
  <math|f:<intset|m>\<to\><intset|n>> are the monotone functions from
  <math|<intset|m>> to <math|<intset|n>>. It has been known for a long time
  that this category is closely related to the notion of monoid,
  see<nbsp><cite|maclane:cwm> or<nbsp><cite|lafont:boolean-circuits> for
  example. This result can be formulated as follows:

  <\property>
    <label|property:delta-presentation>The monoidal category <math|\<Delta\>>
    is presented by the equational theory of monoids<nbsp><math|<eqth|M>>.
  </property>

  <no-indent>In this sense, the simplicial category <math|\<Delta\>>
  impersonates the notion of monoid. We extend here this result to more
  complex categories.

  <paragraph|Multirelations.> A <em|multirelation> <math|R> between two
  finite sets<nbsp><math|A> and<nbsp><math|B> is a function
  <math|R:A\<times\>B\<to\><N>>. It can be equivalently be seen as a multiset
  whose elements are in <math|A\<times\>B> or as a matrix over <math|<N>>, or
  as a span

  <\equation*>
    <tformat|<table|<row|<cell|<xymatrix@C>=2*e*x*@*R=2*e*x>|<cell|<ar*|d*l><rsub|s>R<ar*|d*r><rsup|t>>|<cell|>>|<row|<cell|A>|<cell|>|<cell|B>>|<row|<cell|>|<cell|>|<cell|>>>>
  </equation*>

  in the category <math|<FinSet>> of finite sets \U for the latest case, the
  multiset representation can be recovered from the span by

  <\equation*>
    R<around|(|a,b|)><qeq><around*|\||<setof|e\<in\>R<tq>s<around|(|e|)>=a<tand>t<around|(|e|)>=b>|\|>
  </equation*>

  for every element <math|<around|(|a,b|)>\<in\>A\<times\>B>. If
  <math|R<rsub|1>:A\<to\>B> and <math|R<rsub|2>:B\<to\>C> are two
  multirelations, their composition is defined by

  <\equation*>
    R<rsub|2>\<circ\>R<rsub|1><around|(|a,c|)><qeq><big|sum><rsub|b\<in\>B>R<rsub|1><around|(|a,b|)>\<times\>R<rsub|2><around|(|b,c|)><tdot>
  </equation*>

  This corresponds to the usual composition of matrices if we see
  <math|R<rsub|1>> and <math|R<rsub|2>> as matrices over <math|<N>>, and as
  the span obtained by computing the pullback

  <\equation*>
    <tformat|<table|<row|<cell|<xymatrix@C>=2*e*x*@*R=2*e*x>|<cell|>|<cell|<ar*|d*l>R<rsub|2>\<circ\>R<rsub|1><ar*|d*r>>|<cell|>|<cell|>>|<row|<cell|>|<cell|<ar*|d*l><rsub|s<rsub|1>>R<rsub|1><ar*|d*r><rsup|t<rsub|1>>>|<cell|>|<cell|<ar*|d*l><rsub|s<rsub|2>>R<rsub|2><ar*|d*r><rsup|t<rsub|2>>>|<cell|>>|<row|<cell|A>|<cell|>|<cell|B>|<cell|>|<cell|C>>|<row|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>>>
  </equation*>

  if we see <math|R<rsub|1>> and <math|R<rsub|2>> as spans in <math|<Set>>.
  The cardinal <math|<card|R>> of a multirelation <math|R:A\<to\>B> is the
  sum

  <\equation*>
    <card|R><qeq><big|sum><rsub|<around|(|a,b|)>\<in\>A\<times\>B>R<around|(|a,b|)>
  </equation*>

  of its coefficients. We write <math|<FMR>> for the monoidal theory of
  multirelations: its objects are finite ordinals and morphisms are
  multirelations between them. It is a strict symmetric monoidal category
  with the tensor product <math|\<otimes\>> defined on objects and morphisms
  by disjoint union, and thus a monoidal theory. In this category, the
  object<nbsp><math|<intset|1>> can be equipped with the obvious structure of
  bicommutative bialgebra

  <\equation>
    <label|eq:mrel-bialg><around|(|1,R<rsup|\<mu\>>,R<rsup|\<eta\>>,R<rsup|\<delta\>>,R<rsup|\<varepsilon\>>|)>
  </equation>

  In this structure, <math|R<rsup|\<mu\>>:<intset|2>\<to\><intset|1>> is the
  multirelation defined by <math|R<rsup|\<mu\>><around|(|i,0|)>=1> for
  <math|i=0> or <math|i=1>, <math|R<rsup|\<delta\>>:<intset|1>\<to\><intset|2>>
  is the multirelation dual to<nbsp><math|R<rsup|\<mu\>>>, and
  <math|R<rsup|\<eta\>>:0\<to\>1> and <math|R<rsup|\<varepsilon\>>:1\<to\>0>
  are uniquely defined by the fact that the object <math|0> is both initial
  and terminal in<nbsp><math|<FMR>>. We now show that the category of
  multirelations is presented by the equational theory<nbsp><math|<eqth|B>>
  of bicommutative bialgebras. We write<nbsp><math|\<cal-B\>> for the
  syntactic category of<nbsp><math|<eqth|B>> (<ie>the monoidal category
  generated by the underlying signature of<nbsp><math|<eqth|B>>), so
  that<nbsp><math|<catquot|\<cal-B\>>> is the monoidal category generated
  by<nbsp><math|<eqth|B>>, where<nbsp><math|\<equiv\>> is the congruence
  generated by the relations of<nbsp><math|<eqth|B>>. The bicommutative
  bialgebra structure<nbsp><eqref|eq:mrel-bialg> induces an \Pinterpretation
  functor\Q <math|I:\<cal-B\>\<to\><FMR>> such
  that<nbsp><math|I<around|(|1|)>=1>, <math|I<around|(|\<mu\>|)>=R<rsup|\<mu\>>>,
  <math|I<around|(|\<eta\>|)>=R<rsup|\<eta\>>>,
  <math|I<around|(|\<delta\>|)>=R<rsup|\<delta\>>> and
  <math|I<around|(|\<varepsilon\>|)>=R<rsup|\<varepsilon\>>>. Since, the
  morphisms<nbsp><eqref|eq:mrel-bialg> satisfy the equations of bicommutative
  bialgebra, the interpretations of two morphisms of<nbsp><math|\<cal-B\>>
  related by<nbsp><math|\<equiv\>> will be equal. The interpretation functor
  thus extends to a functor <math|<catquot|I>:<catquot|\<cal-B\>>>

  \<to\><FMR>.

  <\example>
    Consider the morphism

    <\equation*>
      <around|(|<around|(|\<mu\>\<otimes\>\<eta\>\<otimes\>1|)>\<circ\><around|(|1\<otimes\>\<delta\>|)>\<circ\><around|(|\<delta\>\<otimes\>\<varepsilon\>|)>|)>\<otimes\>1<qcolon>3\<to\>4
    </equation*>

    of <math|\<cal-B\>> whose graphical representation is

    <\equation>
      <label|ex:intp-sd><strid|i*n*t*p>
    </equation>

    Its interpretation is the multirelation

    <\equation>
      <label|ex:intp-mr><around|(|<around|(|R<rsup|\<mu\>>\<otimes\>R<rsup|\<eta\>>\<otimes\>1|)>\<circ\><around|(|1\<otimes\>R<rsup|\<delta\>>|)>\<circ\><around|(|R<rsup|\<delta\>>\<otimes\>R<rsup|\<varepsilon\>>|)>|)>\<otimes\>1
    </equation>

    This multirelation is a function<nbsp><math|3\<times\>4\<to\><N>> (where
    <math|3> and <math|4> are respectively the
    sets<nbsp><math|<around|{|0,1,2|}>> and<nbsp><math|<around|{|0,1,2,3|}>>)
    and can thus be represented as the following <math|<N>>-valued matrix of
    size<nbsp><math|3\<times\>4>:

    <\equation*>
      <around*|(|<tabular*|<tformat|<table|<row|<cell|2>|<cell|0>|<cell|1>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>|<cell|1>>>>>|)>
    </equation*>

    This matrix is computed by evaluating the formula<nbsp><eqref|ex:intp-mr>
    but has in fact a very natural interpretation if we consider the string
    diagrammatic representation<nbsp><eqref|ex:intp-sd> of the morphism: an
    entry<nbsp><math|<around|(|i,j|)>> of the matrix is precisely the number
    of different paths in wires linking the object<nbsp><math|i> on the input
    to the object<nbsp><math|j> on the output (for example,
    from<nbsp><math|0> there are two paths to<nbsp><math|0> and one
    to<nbsp><math|2>, thus the first line of the matrix).
  </example>

  For every morphism <math|\<phi\>:m+1\<to\>n> in <math|\<cal-B\>>, where
  <math|m\<gtr\>0>, we define a morphism written
  <math|S<rsup|m\<to\>n>*\<phi\>:m+1\<to\>n> by

  <\equation>
    <label|eq:ctx-S>S<rsup|m\<to\>n>*\<phi\><qeq>\<phi\>\<circ\><around|(|\<gamma\>\<otimes\><rsub|m-1>|)>
  </equation>

  Graphically,

  <\equation*>
    S<rsup|m\<to\>n>*\<phi\><qeq><strid|g*s*y*m<rsub|s>>
  </equation*>

  The <em|stairs> morphisms are defined inductively as either <rsub|<math|1>>
  or <math|S*\<phi\><rprime|'>> where <math|\<phi\><rprime|'>> is a stair,
  and are represented graphically as

  <\equation*>
    <sstrid|g*s*y*m>
  </equation*>

  The <em|length> of a stairs is defined as <math|0> if it is an
  identity<nbsp><rsub|<math|1>>, or as the length of the
  stairs<nbsp><math|\<phi\><rprime|'>> plus one if it is of the form
  <math|S*\<phi\><rprime|'>>. The stairs of length<nbsp><math|n+1> is
  written<nbsp><math|\<gamma\><rsub|n>:n\<to\>n>.

  Morphisms<nbsp><math|\<phi\>> which are <em|precanonical forms> are defined
  inductively: <math|\<phi\>> is either empty or

  <\equation*>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|5|5|cell-rborder|0ln>|<table|<row|<cell|H<rsup|m\<to\>n>*\<phi\><rprime|'>=<sstrid|b*i*a*l*g<rsub|n>*f<rsub|e>*t*a>>|<cell|<tor>>|<cell|E<rsup|m\<to\>n>*\<phi\><rprime|'>=<sstrid|b*i*a*l*g<rsub|n>*f<rsub|e>*p*s>>>>>>
  </equation*>

  or

  <\equation*>
    W<rsub|i><rsup|m\<to\>n>*\<phi\><rprime|'><qeq><sstrid|b*i*a*l*g<rsub|n>*f<rsub|m>*u>
  </equation*>

  where <math|\<phi\>:m\<to\>n> is a precanonical form. In this case, we
  write respectively <math|\<phi\>> as<nbsp><math|Z:0\<to\>0> (the identity
  morphism<nbsp><rsub|<math|<intset|0>>>),
  as<nbsp><math|H<rsup|m\<to\>n>*\<phi\><rprime|'>:m\<to\>n+1>, as
  <math|E<rsup|m\<to\>n>*\<phi\><rprime|'>:m+1\<to\>n> or as
  <math|W<rsub|i><rsup|m\<to\>n>*\<phi\><rprime|'>:m\<to\>n> (where <math|i>
  is the length of the stairs in the morphism). Algebraically,

  <\equation*>
    Z=<rsub|0><space|2em>E<rsup|m\<to\>n>*\<phi\><rprime|'>=\<varepsilon\>\<otimes\>\<phi\><rprime|'>*<space|2em>H<rsup|m\<to\>n>*\<phi\><rprime|'>=\<eta\>\<otimes\>\<phi\><rprime|'>
  </equation*>

  and

  <\equation*>
    W<rsub|i><rsup|m\<to\>n>*\<phi\><rprime|'><qeq><around|(|i\<otimes\>\<mu\>\<otimes\><around|(|n-1-i|)>|)>\<circ\><around|(|\<gamma\><rsub|i>\<otimes\><around|(|n-i|)>|)>\<circ\><around|(|1\<otimes\>\<phi\><rprime|'>|)>\<circ\><around|(|\<delta\>\<otimes\><around|(|m-1|)>|)>
  </equation*>

  Precanonical forms<nbsp><math|\<phi\>> are thus the well formed morphisms
  (where compositions respect types) generated by the following grammar:

  <\equation>
    <label|eq:precan-mrel-gram>\<phi\><qgramdef>Z<gramor>H<rsup|m\<to\>n>*\<phi\><gramor>E<rsup|m\<to\>n>*\<phi\><gramor>W<rsub|i><rsup|m\<to\>n>*\<phi\>
  </equation>

  In order to simplify the notation, we will remove the superscripts in the
  following and simply write<nbsp><math|W<rsub|i>*\<phi\>> instead
  of<nbsp><math|W<rsub|i><rsup|m\<to\>n>*\<phi\>>.

  It is easy to remark that every non-identity morphism<nbsp><math|\<phi\>>
  of a category generated by a monoidal equational theory (such
  as<nbsp><math|<eqth|B>>) can be written as
  <math|\<phi\>=<around|(|<intset|m>\<otimes\>\<pi\>\<otimes\><intset|n>|)>\<circ\>\<phi\><rprime|'>>,
  where<nbsp><math|\<pi\>> is a generator, thus allowing us to reason
  inductively about morphisms, by case analysis on the integer
  <math|<intset|m>> and on the generator<nbsp><math|\<pi\>>. Using this
  technique, we can prove that

  <\lemma>
    <label|lemma:mrel-precan>Every morphism<nbsp><math|\<phi\>:m\<to\>n>
    of<nbsp><math|\<cal-B\>> is equivalent (<wrt> the relation
    <math|\<equiv\>>) to a precanonical form.
  </lemma>

  <\proof>
    By induction on the size <math|<size|\<phi\>>> of<nbsp><math|\<phi\>>.

    <\itemize>
      <item>If<nbsp><math|<size|\<phi\>>=0> then <math|m=n> and
      <math|\<phi\>=<rsub|n>>. If<nbsp><math|n=0> then<nbsp><math|\<phi\>=Z>.
      Otherwise, we have <math|\<phi\>=<rsub|n+1>=1\<otimes\><rsub|n>=W<rsub|0>*E*H<rsub|n>>
      and<nbsp><rsub|<math|n>> is equivalent to a canonical form by induction
      on<nbsp><math|n>.

      <item>Otherwise, the morphism<nbsp><math|\<phi\>> is of the
      form<nbsp><math|\<phi\>=\<xi\>\<circ\>\<psi\>>
      with<nbsp><math|<size|\<xi\>>=1> and
      <math|<size|\<xi\>>+<size|\<psi\>>=<size|\<phi\>>>. By induction
      hypothesis, the morphism<nbsp><math|\<psi\>> is equivalent to a
      canonical form. Moreover, the morphism<nbsp><math|\<xi\>> is of the
      form<nbsp><math|m<rsub|1>\<otimes\>\<pi\>\<otimes\>m<rsub|2>>
      where<nbsp><math|\<pi\>> is either<nbsp><math|\<mu\>>, <math|\<eta\>>,
      <math|\<delta\>>, <math|\<varepsilon\>> or<nbsp><math|\<gamma\>>. We
      show the result by distinguishing these five cases
      for<nbsp><math|\<pi\>> and for each case by distinguishing whether the
      precanonical form of<nbsp><math|\<psi\>> is of the form<nbsp><math|Z>,
      <math|H*\<psi\><rprime|'>>, <math|E*\<psi\><rprime|'>>
      or<nbsp><math|W<rsub|i>*\<psi\><rprime|'>>.

      <\enumerate>
        <item>Suppose that<nbsp><math|\<pi\>=\<mu\>>.

        <\enumerate>
          <item>If<nbsp><math|\<psi\>=H*\<psi\><rprime|'>> then we
          distinguish two cases.

          <\itemize>
            <item>If<nbsp><math|m<rsub|1>=0> then we have the equivalence

            <\equation*>
              <strid|b*i*a*l*g<rsub|m>*u<rsub|h><rsub|1><rsub|1>><qequiv><strid|b*i*a*l*g<rsub|m>*u<rsub|h><rsub|1><rsub|2>>
            </equation*>

            where<nbsp><math|\<psi\><rprime|'>> is equivalent to a
            precanonical form by induction hypothesis.

            <item>Otherwise, the morphism<nbsp><math|\<phi\>> can be
            represented by

            <\equation*>
              <strid|b*i*a*l*g<rsub|m>*u<rsub|h><rsub|2><rsub|1>>
            </equation*>

            and is of the form<nbsp><math|H*<around|(|<around|(|<around|(|m<rsub|1>-1|)>\<otimes\>\<mu\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>|)>>,
            where the morphism <math|<around|(|<around|(|m<rsub|1>-1|)>\<otimes\>\<mu\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>>
            is equivalent to a precanonical form by induction hypothesis.
          </itemize>

          <item>If<nbsp><math|\<psi\>=E*\<psi\><rprime|'>> then the
          morphism<nbsp><math|\<phi\>> can be represented by

          <\equation*>
            <strid|b*i*a*l*g<rsub|m>*u<rsub|e>>
          </equation*>

          and is of the form<nbsp><math|E*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
          where the morphism<nbsp><math|\<xi\>\<circ\>\<psi\><rprime|'>> is
          equivalent to a precanonical form by induction hypothesis.

          <item>If<nbsp><math|\<psi\>=W<rsub|i><rprime|'>*\<psi\><rprime|'>>
          then we distinguish four cases

          <\itemize>
            <item>If<nbsp><math|m<rsub|1>\<less\>i-1> then we have the
            equivalence

            <\equation*>
              <strid|b*i*a*l*g<rsub|m>*u<rsub|w><rsub|1><rsub|1>><qequiv><strid|b*i*a*l*g<rsub|m>*u<rsub|w><rsub|1><rsub|2>>
            </equation*>

            and<nbsp><math|\<phi\>> is of the
            form<nbsp><math|W<rsub|i-1>*<around|(|<around|(|<around|(|m<rsub|1>-1\<otimes\>\<mu\>\<otimes\>m<rsub|2>|)>|)>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|<around|(|<around|(|m<rsub|1>-1\<otimes\>\<mu\>\<otimes\>m<rsub|2>|)>|)>\<circ\>\<psi\><rprime|'>>
            is equivalent to a precanonical form by induction hypothesis.

            <item>If<nbsp><math|m<rsub|1>=i-1> then we have the equivalences

            <\equation*>
              <space|-2cm><strid|b*i*a*l*g<rsub|m>*u<rsub|w><rsub|2><rsub|1>>\<equiv\><strid|b*i*a*l*g<rsub|m>*u<rsub|w><rsub|2><rsub|2>>\<equiv\><strid|b*i*a*l*g<rsub|m>*u<rsub|w><rsub|2><rsub|3>>
            </equation*>

            and we actually are in the case which is handled just below.

            <item>If<nbsp><math|m<rsub|1>=i> then we have the equivalence

            <\equation*>
              <strid|b*i*a*l*g<rsub|m>*u<rsub|w><rsub|3><rsub|1>><qequiv><strid|b*i*a*l*g<rsub|m>*u<rsub|w><rsub|3><rsub|2>>
            </equation*>

            and<nbsp><math|\<phi\>> is of the
            form<nbsp><math|W<rsub|i>*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis.

            <item>If<nbsp><math|m<rsub|1>\<gtr\>i> then<nbsp><math|\<phi\>>
            can be represented by

            <\equation*>
              <strid|b*i*a*l*g<rsub|m>*u<rsub|w><rsub|4><rsub|1>>
            </equation*>

            and is of the form<nbsp><math|W<rsub|i>*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism<nbsp><math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis.
          </itemize>
        </enumerate>

        <item>Suppose that<nbsp><math|\<pi\>=\<eta\>>.

        <\enumerate>
          <item>If<nbsp><math|\<psi\>=Z> then<nbsp><math|\<phi\>=H*Z> which
          is a precanonical form.

          <item>If<nbsp><math|\<psi\>=H*\<psi\><rprime|'>> then we
          distinguish two cases.

          <\itemize>
            <item>If<nbsp><math|m<rsub|1>=0>
            then<nbsp><math|\<phi\>=H*H*\<psi\><rprime|'>> which is a
            precanonical form.

            <item>Otherwise, <math|\<phi\>=H*<around|(|<around|(|<around|(|m<rsub|1>-1|)>\<otimes\>\<eta\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>|)>>
            where <math|<around|(|m<rsub|1>-1|)>\<otimes\>\<eta\>\<otimes\>m<rsub|2>>
            is equivalent to a precanonical form by induction hypothesis.
          </itemize>

          <item>If<nbsp><math|\<psi\>=E*\<psi\><rprime|'>>
          then<nbsp><math|\<phi\>=E*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
          where the morphism<nbsp><math|\<xi\>\<circ\>\<psi\><rprime|'>> is
          equivalent to a precanonical form by induction hypothesis.

          <item>If<nbsp><math|\<psi\>=W<rsub|i>*\<psi\><rprime|'>> then we
          distinguish two cases.

          <\itemize>
            <item>If<nbsp><math|m<rsub|1>\<leq\>i>
            then<nbsp><math|\<phi\>\<equiv\>W<rsub|i+1>*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism<nbsp><math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis.

            <item>Otherwise, <math|\<phi\>=W<rsub|i>*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism<nbsp><math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis.
          </itemize>
        </enumerate>

        <item>Suppose that <math|\<pi\>=\<delta\>>.

        <\enumerate>
          <item>If <math|\<psi\>=H*\<psi\><rprime|'>> then we distinguish two
          cases.

          <\itemize>
            <item>If <math|m<rsub|1>=0> then
            <math|\<phi\>\<equiv\>H*H*\<psi\><rprime|'>> where
            <math|\<psi\><rprime|'>> is a precanonical form.

            <item>Otherwise, <math|\<phi\>\<equiv\>H*<around|(|<around|(|<around|(|m<rsub|1>-1|)>\<otimes\>\<delta\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>|)>>
            where <math|<around|(|<around|(|m<rsub|1>-1|)>\<otimes\>\<delta\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>>
            is equivalent to a precanonical form by induction hypothesis.
          </itemize>

          <item>If <math|\<psi\>=E*\<psi\><rprime|'>> then
          <math|\<phi\>=E*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>> where
          the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is equivalent
          to a precanonical form by induction hypothesis

          <item>If <math|\<psi\>=W<rsub|i>*\<psi\><rprime|'>> the we
          distinguish three cases.

          <\itemize>
            <item>If <math|m<rsub|1>\<less\>i> then
            <math|\<phi\>\<equiv\>W<rsub|i+1>*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis

            <item>If <math|m<rsub|1>=i> then
            <math|\<phi\>\<equiv\>W<rsub|i>*W<rsub|i+1>*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis.

            <item>Otherwise, <math|\<phi\>=W<rsub|i>*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis.
          </itemize>
        </enumerate>

        <item>Suppose that <math|\<pi\>=\<varepsilon\>>.

        <\enumerate>
          <item>If <math|\<psi\>=H*\<psi\><rprime|'>> then we distinguish two
          cases.

          <\itemize>
            <item>If <math|m<rsub|1>=0> then
            <math|\<phi\>\<equiv\>\<psi\><rprime|'>> where the morphism
            <math|\<psi\><rprime|'>> is a precanonical form.

            <item>Otherwise, <math|\<psi\>=H*<around|(|<around|(|<around|(|m<rsub|1>-1|)>\<otimes\>\<varepsilon\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>|)>>
            where <math|<around|(|<around|(|m<rsub|1>-1|)>\<otimes\>\<varepsilon\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>>
            is equivalent to a precanonical form by induction hypothesis.
          </itemize>

          <item>If <math|\<psi\>=E*\<psi\><rprime|'>> then
          <math|\<phi\>=E*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>> where
          the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is equivalent
          to a precanonical form by induction hypothesis.

          <item>If <math|\<psi\>=W<rsub|i>*\<psi\><rprime|'>> then we
          distinguish three cases.

          <\itemize>
            <item>If <math|m<rsub|1>\<less\>i> then
            <math|\<phi\>\<equiv\>W<rsub|i-1>*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis.

            <item>If <math|m<rsub|1>=i> then
            <math|\<phi\>\<equiv\>E*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis.

            <item>Otherwise, <math|\<phi\>=W<rsub|i>*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis.
          </itemize>
        </enumerate>

        <item>Suppose that <math|\<pi\>=\<gamma\>>.

        <\enumerate>
          <item>If <math|\<psi\>=H*\<psi\><rprime|'>> then we distinguish two
          cases.

          <\itemize>
            <item>If <math|m<rsub|1>=0> then
            <math|\<phi\>\<equiv\><around|(|<around|(|1\<otimes\>\<eta\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|<around|(|1\<otimes\>\<eta\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>>
            is equivalent to a precanonical form by induction hypothesis.

            <item>Otherwise, <math|\<phi\>=H*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis.
          </itemize>

          <item>If <math|\<psi\>=E*\<psi\><rprime|'>> then
          <math|\<phi\>=E*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>> where
          the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is equivalent
          to a precanonical form by induction hypothesis.

          <item>If <math|\<psi\>=W<rsub|i>*\<psi\><rprime|'>> then we
          distinguish four cases.

          <\itemize>
            <item>If <math|m<rsub|1>\<less\>i-1> then
            <math|\<phi\>\<equiv\>W<rsub|i>*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis.

            <item>If <math|m<rsub|1>=i-1> then
            <math|\<phi\>\<equiv\>W<rsub|i-1>*<around|(|<around|(|<around|(|m<rsub|1>+1|)>\<otimes\>\<gamma\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|<around|(|<around|(|m<rsub|1>+1|)>\<otimes\>\<gamma\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>>
            is equivalent to a precanonical form by induction hypothesis.

            <item>If <math|m<rsub|1>=i> then
            <math|\<phi\>\<equiv\>W<rsub|i+1>*<around|(|<around|(|<around|(|m<rsub|1>+1|)>\<otimes\>\<gamma\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|<around|(|<around|(|m<rsub|1>+1|)>\<otimes\>\<gamma\>\<otimes\>m<rsub|2>|)>\<circ\>\<psi\><rprime|'>>
            is equivalent to a precanonical form by induction hypothesis.

            <item>Otherwise, <math|\<phi\>=W<rsub|i>*<around|(|\<xi\>\<circ\>\<psi\><rprime|'>|)>>
            where the morphism <math|\<xi\>\<circ\>\<psi\><rprime|'>> is
            equivalent to a precanonical form by induction hypothesis.
          </itemize>
        </enumerate>
      </enumerate>
    </itemize>
  </proof>

  The <em|canonical forms> are precanonical forms which are normal <wrt> the
  following rewriting system:

  <\equation>
    <label|eq:mrel-cf-rs><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<table|<row|<cell|H*W<rsub|i>>|<cell|W<rsub|i+1>*H>>|<row|<cell|H*E>|<cell|E*H>>|<row|<cell|W<rsub|i>*W<rsub|j>>|<cell|W<rsub|j>*W<rsub|i>*<space|2em><text|when
    >i\<less\>j>>>>>
  </equation>

  when considered as words generated by the
  grammar<nbsp><eqref|eq:precan-mrel-gram>. It is routine verifications to
  show that two precanonical forms<nbsp><math|\<phi\>>
  and<nbsp><math|\<psi\>> such that<nbsp><math|\<phi\>> rewrites
  to<nbsp><math|\<psi\>> are equivalent. This rewriting system thus provides
  us with a notion of canonical form for precanonical forms:

  <\lemma>
    <label|lemma:mrel-can>The rewriting system<nbsp><eqref|eq:mrel-cf-rs> is
    normalizing.
  </lemma>

  <\proof>
    We first show that the rewriting system is terminating by defining an
    interpretation of precanonical forms into<nbsp><math|<N>\<times\><N>>,
    ordered lexicographically. This interpretation<nbsp><math|<intp|->> is
    defined on generators by

    <\equation*>
      <intp|Z>=<around|(|0,0|)><space|2em><intp|H>=<around|(|0,0|)><space|2em><intp|E>=<around|(|1,0|)><space|2em><intp|W<rsub|i>>=<around|(|1,i|)>
    </equation*>

    and on composition and identities by

    <\equation*>
      <intp|G\<circ\>F>=<around|(|<intp|G><rsub|1>+2\<times\><intp|F<rsub|1>>,<intp|G><rsub|2>+2\<times\><intp|F><rsub|2>|)><qtand><intp|>=<around|(|0,0|)>
    </equation*>

    where<nbsp><math|F> and<nbsp><math|G> are such
    that<nbsp><math|<intp|F>=<around|(|<intp|F><rsub|1>,<intp|F><rsub|2>|)>>
    and<nbsp><math|<intp|G>=<around|(|<intp|G><rsub|1>,<intp|G><rsub|2>|)>>.
    It can be remarked that the rules are strictly decreasing <wrt>this
    interpretation:

    <\equation*>
      <intp|H*W<rsub|i>>=<around|(|2,2*i|)>\<gtr\><around|(|1,i|)>=<intp|W<rsub|i>*H><space|2em><intp|H*E>=<around|(|2,0|)>\<gtr\><around|(|1,0|)>=<intp|E*H>
    </equation*>

    and

    <\equation*>
      <intp|W<rsub|i>*W<rsub|j>>=<around|(|3,i+2*j|)>\<gtr\><around|(|3,j+2*i|)>=<intp|W<rsub|j>*W<rsub|i>>
    </equation*>

    The rewriting system is therefore terminating. It moreover locally
    confluent, since the two critical pairs are joinable:

    <\equation*>
      <space|-6mm><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<vxym|<tformat|<table|<row|<cell|>|<cell|<ar*|d*l>W<rsub|i>*W<rsub|j>*W<rsub|k><ar*|d*r>>|<cell|>>|<row|<cell|W<rsub|j>*W<rsub|i>*W<rsub|k><ar*|d>>|<cell|>|<cell|W<rsub|i>*W<rsub|k>*W<rsub|j><ar*|d>>>|<row|<cell|W<rsub|j>*W<rsub|k>*W<rsub|i><ar*|d*r>>|<cell|>|<cell|W<rsub|k>*W<rsub|i>*W<rsub|k><ar*|d*l>>>|<row|<cell|>|<cell|W<rsub|k>*W<rsub|j>*W<rsub|i>>|<cell|>>|<row|<cell|>|<cell|>|<cell|>>>>>>|<cell|<vxym|<tformat|<table|<row|<cell|>|<cell|<ar*|d*l>H*W<rsub|i>*W<rsub|j><ar*|d*r>>|<cell|>>|<row|<cell|W<rsub|i+1>*H*W<rsub|j><ar*|d>>|<cell|>|<cell|H*W<rsub|j>*W<rsub|i><ar*|d>>>|<row|<cell|W<rsub|i+1>*W<rsub|j+1>*H<ar*|d*r>>|<cell|>|<cell|W<rsub|j+1>*H*W<rsub|i><ar*|d*l>>>|<row|<cell|>|<cell|W<rsub|j+1>*W<rsub|i+1>*H>|<cell|>>|<row|<cell|>|<cell|>|<cell|>>>>>>>|<row|<cell|<text|with
      >i\<less\>j\<less\>k>|<cell|<text|with >i\<less\>j>>>>>
    </equation*>

    The rewriting system being terminating, it is thus confluent.
  </proof>

  <\remark>
    Canonical forms are the precanonical forms of the form

    <\equation>
      <label|eq:mrel-can>W<rsub|i<rsup|n><rsub|k<rsub|n>>>*\<cdots\>*W<rsub|i<rsup|n><rsub|1>>*E*\<cdots\>*\<cdots\>*W<rsub|i<rsup|1><rsub|k<rsub|1>>>*\<cdots\>*W<rsub|i<rsup|1><rsub|1>>*E*H*\<cdots\>*H*Z
    </equation>

    with <math|i<rsup|p><rsub|1>\<geq\>\<ldots\>\<geq\>i<rsup|p><rsub|k<rsub|p>>>,
    for every<nbsp><math|p> such that <math|1\<leq\>p\<leq\>n>.
  </remark>

  From Lemmas<nbsp><reference|lemma:mrel-precan>
  and<nbsp><reference|lemma:mrel-can>, we can finally deduce that every
  morphism of the category<nbsp><math|\<cal-B\>> is equivalent to an unique
  canonical form.

  <\lemma>
    <label|lemma:mrel-bij>The interpretation
    functor<nbsp><math|<catquot|I>:<catquot|\<cal-B\>>\<to\><FMR>> is full.
  </lemma>

  <\proof>
    We show the result by showing that the
    functor<nbsp><math|I:\<cal-B\>\<to\><FMR>> is full, <ie>that every
    multirelation<nbsp><math|R:<intset|m>\<to\><intset|n>> is the image of a
    precanonical form<nbsp><math|\<phi\>:m\<to\>n> in<nbsp><math|\<cal-B\>>,
    by induction on<nbsp><math|m> and on the cardinal <math|<card|R>> of
    <math|R>.

    <\enumerate>
      <item>If <math|m=0> then <math|R> is the interpretation of the
      precanonical form <math|H*\<ldots\>*H*Z>, with<nbsp><math|n>
      occurrences of <math|H>.

      <item>If <math|m\<gtr\>0> and for every <math|j\<less\>n>,
      <math|R<around|(|0,j|)>=0> then <math|R> is of the form
      <math|R=R<rsup|\<varepsilon\>>\<otimes\>R<rprime|'>>,
      where<nbsp><math|R<rprime|'>:<intset|m-1>\<to\><intset|n>> is the
      multirelation such that<nbsp><math|R<rprime|'><around|(|i,j|)>=R*<around|(|i+1,j|)>>.
      By induction hypothesis, <math|R<rprime|'>> is the interpretation of a
      precanonical form<nbsp><math|\<phi\><rprime|'>> and<nbsp><math|R> is
      therefore the interpretation of the precanonical
      form<nbsp><math|E*\<phi\><rprime|'>>.

      <item>Otherwise, we necessarily have<nbsp><math|n\<neq\>0> and there
      exists and index<nbsp><math|k<rprime|'>> such that
      <math|R<around|(|0,k|)>\<neq\>0>. We write<nbsp><math|k> for the
      greatest such index. The multirelation<nbsp><math|R> is of the form

      <\equation*>
        R<qeq><around|(|<intset|k>\<otimes\>R<rsup|\<mu\>>\<otimes\><intset|n-1-k>|)>\<circ\><around|(|R<rsup|\<gamma\><rsub|k>>\<otimes\><intset|n-k>|)>\<circ\><around|(|1\<otimes\>R<rprime|'>|)>\<circ\><around|(|R<rsup|\<delta\>>\<otimes\><intset|m-1>|)>
      </equation*>

      Where <math|R<rprime|'>:<intset|m>\<to\><intset|n>> is the
      multirelation defined by <math|R<rprime|'><around|(|0,k|)>=R<around|(|0,k|)>-1>
      and <math|R<rprime|'><around|(|i,j|)>=R<around|(|i,j|)>> for
      every<nbsp><math|<around|(|i,j|)>\<neq\><around|(|0,k|)>>. The
      multirelation<nbsp><math|R<rprime|'>> is thus of cardinal
      <math|<card|R<rprime|'>>=<card|R>-1> and is the interpretation of a
      precanonical form<nbsp><math|\<phi\><rprime|'>:m\<to\>n> by induction
      hypothesis. Finally, <math|R> is the interpretation of the precanonical
      form<nbsp><math|W<rsub|k>*\<phi\><rprime|'>>.
    </enumerate>
  </proof>

  The proof of the previous lemma provides us with an algorithm which, given
  a multirelation<nbsp><math|R>, builds a precanonical
  form<nbsp><math|\<phi\>> whose interpretation is<nbsp><math|R>. The
  execution of this algorithm consists in enumerating the coefficients of the
  multirelation column after column. We suppose given a
  multirelation<nbsp><math|R:<intset|m>\<to\><intset|n>>. In pseudo-code, the
  algorithm can be written as follows:

  <vspace|2ex><no-indent>for <math|i=0> to <math|m-1>
  do<next-line><null><space|2em>for <math|j=n-1> downto <math|0>
  do<next-line><null><space|2em><space|2em>for <math|k=0> to
  <math|R<around|(|i,j|)>> do<next-line><null><space|2em><space|2em><space|2em>print
  \P<math|W<rsub|j>>\Q<next-line><null><space|2em><space|2em>done<next-line><null><space|2em><space|2em>print
  \P<math|H>\Q<next-line><null><space|2em>done<next-line>done<next-line>for
  <math|j=0> to <math|n-1> do<next-line><null><space|2em>print
  \P<math|E>\Q<next-line>done<next-line>print \P<math|Z>\Q

  <vspace|2ex><no-indent>The word printed by the algorithm will be a
  precanonical form whose interpretation is<nbsp><math|R>.

  Knowing the general form<nbsp><eqref|eq:mrel-can> of canonical forms, it is
  easy to show that the precanonical form produced by the algorithm are
  actually canonical forms. Conversely, every canonical
  form<nbsp><eqref|eq:mrel-can> can be read as an \Penumeration\Q of the
  coefficients of a multirelation in a way similar the previous algorithm.
  This shows that, in fact, multirelations<nbsp><math|R:<intset|m>\<to\><intset|n>>
  are in bijection with the canonical forms<nbsp><math|\<phi\>:m\<to\>n>. A
  morphism of<nbsp><math|\<cal-B\>> being equivalent to an unique canonical
  form, we finally deduce that

  <\theorem>
    <label|thm:fmr-pres>The categories<nbsp><math|<catquot|\<cal-B\>>>
    and<nbsp><math|<FMR>> are isomorphic, <ie>the category<nbsp><math|<FMR>>
    of natural numbers and multirelations is presented by the
    theory<nbsp><math|<eqth|B>> of bicommutative bialgebras.
  </theorem>

  <paragraph|Relations.> The monoidal category <math|<Rel>> has finite
  ordinals as objects and relations as morphisms. This category can be
  obtained from <math|<FMR>> by quotienting the morphisms by the equivalence
  relation <math|\<sim\>> on multirelations such that two multirelations
  <math|R<rsub|1>,R<rsub|2>:m\<to\>n> are equivalent when they have the same
  null coefficients. We can therefore easily adapt the previous presentation
  to show that

  <\theorem>
    The category <math|<Rel>> of relations is presented by the equational
    theory <math|<eqth|R>> of <em|qualitative> bicommutative bialgebras.
  </theorem>

  <no-indent>In particular, precanonical forms are the same and canonical
  forms are defined by adding the rule

  <\equation>
    <label|eq:rel-cf-rs>W<rsub|i>*W<rsub|i>\<Longrightarrow\>W<rsub|i>
  </equation>

  to the rewriting system<nbsp><eqref|eq:mrel-cf-rs>, which remains
  normalizing.

  <section|A game semantics for first-order
  causality><label|section:games-strategies>

  Suppose that we are given a fixed first-order
  language<nbsp><math|\<cal-L\>>, that is

  <\itemize>
    <item>a set of proposition symbols<nbsp><math|P,Q,\<ldots\>> with given
    arities,

    <item>a set of function symbols<nbsp><math|f,g,\<ldots\>> with given
    arities,

    <item>and a set of first-order variables<nbsp><math|x,y,\<ldots\>>.
  </itemize>

  <em|Terms><nbsp><math|t> and <em|formulas><nbsp><math|A> are respectively
  generated by the following grammars:

  <\equation*>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|t>|<cell|<qgramdef>>|<cell|x<gramor>f<around|(|t,\<ldots\>,t|)>>>|<row|<cell|A>|<cell|<qgramdef>>|<cell|P<around|(|t,\<ldots\>,t|)><gramor><qforall|x>A<gramor><qexists|x>A>>>>>
  </equation*>

  (we only consider formulas without connectives here). We suppose that
  application of propositions and functions always respect arities. Formulas
  are considered modulo renaming of bound variables and substitution
  <math|A*<around|[|t/x|]>> of a free variable <math|x> by a term <math|t> in
  a formula <math|A> is defined as usual, avoiding capture of variables. In
  the following, we sometimes omit the arguments of propositions when they
  are clear from the context. We also suppose given a
  set<nbsp><math|<axioms>> of <em|axioms>, that is pairs of propositions,
  which is reflexive, transitive and closed under substitution (so that the
  obtained logic has the cut-elimination property). The logic associated to
  these formulas has the following inference rules:

  <\equation*>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|2|2|1|-1|cell-valign|top>|<cwith|2|2|1|-1|cell-vmode|exact>|<cwith|2|2|1|-1|cell-height|<plus|1fn|2ex>>|<cwith|4|4|1|-1|cell-valign|top>|<cwith|4|4|1|-1|cell-vmode|exact>|<cwith|4|4|1|-1|cell-height|<plus|1fn|2ex>>|<table|<row|<cell|<inferrule|A*<around|[|t/x|]>\<vdash\>B|<qforall|x>A\<vdash\>B|<lrule|<math|\<forall\>>-L>>>|<cell|<inferrule|A\<vdash\>B|A\<vdash\><qforall|x>B|<lrule|<math|\<forall\>>-R>><around|[|0|]>>>|<row|<cell|>|<cell|<text|(with
    <math|x> not free in <math|A>)><around|[|0|]>>>|<row|<cell|<inferrule|A\<vdash\>B|<qexists|x>A\<vdash\>B|<lrule|<math|\<exists\>>-L>>>|<cell|<inferrule|A\<vdash\>B*<around|[|t/x|]>|A\<vdash\><qexists|x>B|<lrule|<math|\<exists\>>-R>><around|[|0|]>>>|<row|<cell|<text|(with
    <math|x> not free in <math|B>)>>|<cell|<around|[|0|]>>>|<row|<cell|<inferrule|<around|(|P,Q|)>\<in\><axioms>|P\<vdash\>Q|<lrule|A*x>>>|<cell|<inferrule|A\<vdash\>B<next-line>B\<vdash\>C|A\<vdash\>C|<lrule|C*u*t>>>>>>>
  </equation*>

  <paragraph|Games and strategies.><label|subsection:games-strategies>Games
  are defined as follows.

  <\definition>
    A <em|game> <math|A=<around|(|<moves|A>,\<lambda\><rsub|A>,\<leq\><rsub|A>|)>>
    consists of a set<nbsp><math|<moves|A>> whose elements are called
    <em|moves>, a function <math|\<lambda\><rsub|A>>
    from<nbsp><math|<moves|A>> to<nbsp><math|{-1,+1}> which to every move
    <math|m> associates its <em|polarity>, and a partial order
    <math|\<leq\><rsub|A>> on moves, called <em|causality> or
    <em|justification>, which should be well-founded, <ie> such that every
    move <math|m\<in\><moves|A>> defines a finite downward closed set

    <\equation*>
      m*<space|-0.17em>\<downarrow\><qeq><setof|n\<in\><moves|A><tq>n\<leq\><rsub|A>m>
    </equation*>

    A move <math|m> is said to be a <em|Proponent move> when
    <math|\<lambda\><rsub|A><around|(|m|)>=+1> and an <em|Opponent move>
    otherwise.
  </definition>

  <no-indent>The size<nbsp><math|<size|A>> of a game<nbsp><math|A> is the
  cardinal of its set of moves<nbsp><math|<moves|A>>.

  <\remark>
    More generally, games should be defined as event
    structures<nbsp><cite|winskel:event-structures> in order to be able to
    model additive connectives. We don't detail this here since we only
    consider formulas without connectives.
  </remark>

  If <math|A> and <math|B> are two games, their tensor product
  <math|A\<otimes\>B> is defined by disjoint union on moves, polarities and
  causality:

  <\equation*>
    <moves|A\<otimes\>B>=<moves|A>\<uplus\><moves|B><tcomma><space|1em>\<lambda\><rsub|A\<otimes\>B>=\<lambda\><rsub|A>+\<lambda\><rsub|B><qtand>\<leq\><rsub|A\<otimes\>B>=\<leq\><rsub|A>\<cup\>\<leq\><rsub|B>
  </equation*>

  The opposite game <math|A<rsup|\<ast\>>> of the game <math|A> is obtained
  from<nbsp><math|A> by inverting polarities of moves:

  <\equation*>
    A<rsup|\<ast\>>=(<moves|A>,-\<lambda\><rsub|A>,\<leq\><rsub|A>)<tdot>
  </equation*>

  Finally, the arrow game <math|A<llimp>B> is defined by

  <\equation*>
    A<llimp>B<qeq>A<rsup|\<ast\>>\<otimes\>B<tdot>
  </equation*>

  A game <math|A> is <em|filiform> when the associated partial order is total
  (we are mostly interested in such games in the following).

  <\definition>
    <label|def:strategy>A <em|strategy> <math|\<sigma\>> on a game <math|A>
    is a partial order <math|\<leq\><rsub|\<sigma\>>> on the moves of
    <math|A> which satisfies the two following properties:

    <\enumerate>
      <item><em|polarity>: for every pair of moves <math|m,n\<in\><moves|A>>,

      <\equation*>
        m\<less\><rsub|\<sigma\>>n<qqtimpl>\<lambda\><rsub|A><around|(|m|)>=-1<qtand>\<lambda\><rsub|A><around|(|n|)>=+1
      </equation*>

      <item><em|acyclicity>: the partial order <math|\<leq\><rsub|\<sigma\>>>
      is compatible with the partial order of the game, in the sense that the
      transitive closure of their union is still a partial order (<ie>is
      acyclic).
    </enumerate>
  </definition>

  The <em|size> <math|<size|A>> of a game <math|A> is the cardinal of
  <math|<moves|A>> and the <em|size> <math|<size|\<sigma\>>> of a strategy
  <math|\<sigma\>:A> is the cardinal of the
  relation<nbsp><math|\<leq\><rsub|\<sigma\>>>.

  <paragraph|A category of games.> At this point it would be very tempting to
  build a category whose

  <\itemize>
    <item>objects are games,

    <item>morphisms<nbsp><math|\<sigma\>:A\<to\>B> are strategies on the
    game<nbsp><math|A<llimp>B>.
  </itemize>

  The identity strategy<nbsp><math|<rsub|A>:A<rprime|'>\<to\>A> (the
  apostrophe sign is only used here to identify unambiguously the two copies
  of<nbsp><math|A>) would be the strategy such that for every
  move<nbsp><math|m> in<nbsp><math|A> and<nbsp><math|m<rprime|'>>
  in<nbsp><math|A<rprime|'>>, which are instances of a same
  move<nbsp><math|m>, we have<nbsp><math|m<rprime|'>\<leq\><rsub|A>m>
  whenever<nbsp><math|\<lambda\><rsub|A><around|(|m|)>=+1>
  and<nbsp><math|m\<leq\><rsub|A>m<rprime|'>>
  whenever<nbsp><math|\<lambda\><rsub|A><around|(|m|)>=-1> (it can easily be
  checked that this definition satisfies the axioms for strategies). Now
  consider two strategies<nbsp><math|\<sigma\>:A\<to\>B>
  and<nbsp><math|\<tau\>:B\<to\>C>. The partial
  order<nbsp><math|\<leq\><rsub|\<sigma\>>> on the
  set<nbsp><math|<moves|A>\<uplus\><moves|B>> is relation
  on<nbsp><math|<moves|A>\<uplus\><moves|B>>, <ie>a subset
  of<nbsp><math|<around|(|<moves|A>\<uplus\><moves|B>|)><rsup|2>>, and
  similarly for<nbsp><math|\<tau\>>. The partial
  order<nbsp><math|\<leq\><rsub|\<tau\>\<circ\>\<sigma\>>> corresponding to
  composite <math|\<tau\>\<circ\>\<sigma\>:A\<to\>C> of the two
  strategies<nbsp><math|\<sigma\>> and<nbsp><math|\<tau\>> would be defined
  as the transitive closure of the relation<nbsp><math|\<leq\><rsub|\<sigma\>>\<cup\>\<leq\><rsub|\<tau\>>>
  on<nbsp><math|<moves|A>\<uplus\><moves|B>\<uplus\><moves|C>> restricted to
  the set<nbsp><math|<moves|A>\<uplus\><moves|C>>. It is easily checked that
  identities act as neutral elements for composition. Similar ideas for
  composing strategies were in particular developed in the appendix
  of<nbsp><cite|hyland-schalk:games-graphs>.

  For example, consider the game<nbsp><math|A> with two Proponent
  moves<nbsp><math|m<rsub|1>> and<nbsp><math|m<rsub|2>> and the empty
  causality relation, the game<nbsp><math|B> with two Proponent
  moves<nbsp><math|n<rsub|1>> and<nbsp><math|n<rsub|2>> and the causality
  relation<nbsp><math|n<rsub|1>\<leq\><rsub|B>n<rsub|2>>, the
  strategy<nbsp><math|\<sigma\>:A<rprime|'>\<to\>A> such
  that<nbsp><math|m<rsub|1><rprime|'>\<leq\><rsub|\<sigma\>>m<rsub|2>>
  and<nbsp><math|m<rsub|2><rprime|'>\<leq\><rsub|\<sigma\>>m<rsub|1>> and the
  strategy<nbsp><math|\<tau\>:A\<to\>B> such
  that<nbsp><math|m<rsub|1>\<leq\><rsub|\<tau\>>n<rsub|1>>
  and<nbsp><math|m<rsub|2>\<leq\><rsub|\<tau\>>n<rsub|2>>. Their composite is
  the strategy<nbsp><math|\<tau\>\<circ\>\<sigma\>:A<rprime|'>\<to\>B> such
  that<nbsp><math|m<rsub|2><rprime|'>\<leq\><rsub|\<tau\>\<circ\>\<sigma\>>n<rsub|1>>
  and <math|m<rsub|1><rprime|'>\<leq\><rsub|\<tau\>\<circ\>\<sigma\>>n<rsub|2>>.
  This can be viewed graphically as follows:

  <\equation*>
    <space|-4ex><vxym|<tformat|<table|<row|<cell|A<rprime|'><ar*|r*r*r><rsup|\<sigma\>>>|<cell|>|<cell|>|<cell|A<ar*|r*r*r><rsup|\<tau\>>>|<cell|>|<cell|>|<cell|B>>|<row|<cell|m<rsub|1><rprime|'><ar@>/<rsup|4>e*x/<around|[|r*r*r*r|]>>|<cell|m<rsub|2><rprime|'><ar@>/<rsup|/><around|[|r*r|]>>|<cell|>|<cell|m<rsub|1><ar@>/<rsub|3>e*x/<around|[|r*r*r|]>>|<cell|m<rsub|2><ar*|d*r*r>>|<cell|>|<cell|n<rsub|1><ar@*|.\<gtr\>|d>>>|<row|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|n<rsub|2>>>|<row|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>>>><space|2em>\<rightsquigarrow\><space|2em><vxym|<tformat|<table|<row|<cell|A<rprime|'><ar*|r*r*r><rsup|\<tau\>\<circ\>\<sigma\>>>|<cell|>|<cell|>|<cell|B>>|<row|<cell|m<rsub|1><rprime|'><ar*|d*r*r*r>>|<cell|m<rsub|2><rprime|'><ar@>/<rsub|/><around|[|r*r|]>>|<cell|>|<cell|n<rsub|1><ar@*|.\<gtr\>|d>>>|<row|<cell|>|<cell|>|<cell|>|<cell|n<rsub|2>>>|<row|<cell|>|<cell|>|<cell|>|<cell|>>>>>
  </equation*>

  In the diagram above the dotted arrows represent the causal dependencies in
  the games and solid arrows the dependencies in the strategies.

  However, the composite of two strategies is not necessarily a strategy! For
  example consider the game<nbsp><math|A> defined as before excepted
  that<nbsp><math|m<rsub|1>> is now an Opponent move, the game<nbsp><math|B>
  defined as before excepted that<nbsp><math|n<rsub|2>> is now an Opponent
  move, the strategy <math|\<sigma\>:0\<to\>A> (where <math|0> denotes the
  empty game) such that<nbsp><math|m<rsub|1>\<leq\><rsub|\<sigma\>>m<rsub|2>>
  and the strategy <math|\<tau\>:A\<to\>B> such
  that<nbsp><math|n<rsub|2>\<leq\><rsub|\<tau\>>m<rsub|1>>
  and<nbsp><math|m<rsub|2>\<leq\><rsub|\<tau\>>n<rsub|1>>. Their
  \Pcomposite\Q is <em|not> a strategy because it does not satisfy the
  acyclicity property:

  <\equation*>
    <space|-1ex><vxym|<tformat|<table|<row|<cell|0<ar*|r*r*r><rsup|\<sigma\>>>|<cell|>|<cell|>|<cell|A<ar*|r*r*r><rsup|\<tau\>>>|<cell|>|<cell|>|<cell|B>>|<row|<cell|>|<cell|>|<cell|>|<cell|m<rsub|1><ar@>/<rsup|/><around|[|r|]>>|<cell|m<rsub|2><ar@>/<rsub|/><around|[|r*r|]>>|<cell|>|<cell|n<rsub|1><ar@*|.\<gtr\>|d>>>|<row|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|<ar@>/<rsup|/><around|[|u*l*l*l|]>*n<rsub|2>>>|<row|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>>>><space|2em>\<rightsquigarrow\><space|2em><vxym|<tformat|<table|<row|<cell|0<ar*|r*r*r><rsup|\<tau\>\<circ\>\<sigma\>>>|<cell|>|<cell|>|<cell|B>>|<row|<cell|>|<cell|>|<cell|>|<cell|n<rsub|1><ar@*|.\<gtr\>|d>>>|<row|<cell|>|<cell|>|<cell|>|<cell|<ar@>/<rsup|4>e*x/<around|[|u|]>*n<rsub|2>>>|<row|<cell|>|<cell|>|<cell|>|<cell|>>>>>
  </equation*>

  This is a typical example of the fact that compositionality of strategies
  in game semantics is often a subtle property that should be checked very
  carefully.

  <\remark>
    <label|rem:ll-acyclicity>A more conceptual explanation of this
    compositionality problem can be given as follows. If we
    write<nbsp><math|P> for the game with only one Proponent move, the
    game<nbsp><math|A> should correspond, in a model of linear logic to
    either the tensor or the par of <math|P> and <math|P<rsup|\<ast\>>>.
    However, we have not included in our strategies conditions which are
    necessary to distinguish between the interpretation of tensor and par.
    This explains why we are not able to recover the compositionality of the
    acyclicity property, which is deeply linked with the correctness
    criterion of linear logic. We leave a precise investigation of this for
    future works, in which we plan to extend our model to first-order linear
    logic.
  </remark>

  Fortunately, if we restrict the previous attempt of construction of a
  category, by only allowing <em|finite filiform games> as objects, then we
  actually construct a category (<ie>the composite of two morphisms is a
  morphism) that we write<nbsp><math|<Games>>. Moreover, we show that the
  connective-free fragment of first-order propositional logic can be
  interpreted in this category and that the conditions imposed on strategies
  characterize exactly the strategies interpreting proofs
  (Theorem<nbsp><reference|thm:definability>).

  We could give a direct proof of the fact that<nbsp><math|<Games>> is
  actually a category. However, a direct proof of the fact that the composite
  of two acyclic strategies is acyclic is combinatorial, lengthy and requires
  global reasoning about strategies. This proof would show, by reductio ad
  absurdum, that if the composite of two strategies contains a cycle
  (together with the causality of the game) then one of the strategies
  already contains a cycle. So, it would moreover not be very satisfactory in
  the sense that it would not be constructive. Instead of proceeding in this
  way, we define the category<nbsp><math|<Games>> in an abstract fashion,
  construct a presentation of this category, and conclude <em|a posteriori>
  that in fact its only morphisms are strategies, which implies in particular
  (Theorem<nbsp><reference|thm:composition>) that strategies do actually
  compose!

  We first define a weaker notion of strategy

  <\definition>
    A <em|cyclic strategy><nbsp><math|\<sigma\>> on a game<nbsp><math|A> is a
    relation on the moves of<nbsp><math|A>, <ie>a subset
    of<nbsp><math|<moves|A>\<times\><moves|A>>, such that

    <\enumerate>
      <item>the relation<nbsp><math|\<sigma\>> is reflexive and transitive,

      <item><em|polarity>: for every pair of moves <math|m,n\<in\><moves|A>>,

      <\equation*>
        m*\<sigma\>*n<qtand>m\<neq\>n<qqtimpl>\<lambda\><rsub|A><around|(|m|)>=-1<qtand>\<lambda\><rsub|A><around|(|n|)>=+1
      </equation*>
    </enumerate>
  </definition>

  In particular, every strategy is a cyclic strategy. From this definition it
  is very easy to build a category<nbsp><math|<CGames>> whose

  <\itemize>
    <item>objects are games,

    <item>morphisms<nbsp><math|\<sigma\>:A\<to\>B> are strategies on the
    game<nbsp><math|A<llimp>B>,

    <item>identities and composition are defined as above.
  </itemize>

  Since the definition of cyclic strategy is much weaker than the notion of
  strategy, it is routine to check that the category is well-defined. We now
  define the category<nbsp><math|<Games>> as the category generated
  in<nbsp><math|<CGames>> by finite filiform games and strategies, <ie>the
  smallest category whose

  <\itemize>
    <item>objects are finite filiform games,

    <item>for every objects<nbsp><math|A> and<nbsp><math|B>, and every
    strategy<nbsp><math|\<sigma\>:A<llimp>B> in the sense of
    Definition<nbsp><reference|def:strategy>, we have that <math|\<sigma\>>
    is a morphism in<nbsp><math|<Hom><around|(|A,B|)>>,

    <item>for every objects<nbsp><math|A>, <math|B> and<nbsp><math|C>,
    if<nbsp><math|\<sigma\>> is a morphism in <math|<Hom><around|(|A,B|)>>
    and<nbsp><math|\<tau\>> is a morphism
    in<nbsp><math|<Hom><around|(|B,C|)>> then their
    composite<nbsp><math|\<tau\>\<circ\>\<sigma\>> (in the
    category<nbsp><math|<CGames>>) is a morphism
    in<nbsp><math|<Hom><around|(|A,C|)>>.
  </itemize>

  As mentioned above, we will show in Theorem<nbsp><reference|thm:composition>
  that the only morphisms of this category are actually strategies.

  <paragraph|A monoidal structure on <math|<Games>>.> If <math|A> and
  <math|B> are two games, the game <math|A<before>B> (to be read <math|A>
  <em|before> <math|B>) is the game defined as <math|A<lltens>B> on moves and
  polarities and <math|\<leq\><rsub|A<before>B>> is the transitive closure of
  the relation

  <\equation*>
    \<leq\><rsub|A<lltens>B>\<cup\><space|0.27em><setof|<around|(|a,b|)><tq>a\<in\><moves|A><tand>b\<in\><moves|B>>
  </equation*>

  This operation is extended as a bifunctor on strategies as follows. If
  <math|\<sigma\>:A\<to\>B> and <math|\<tau\>:C\<to\>D> are two strategies,
  the strategy <math|\<sigma\><before>\<tau\>:A<before>C\<to\>B<before>D> is
  defined as the relation <math|\<leq\><rsub|\<sigma\><before>\<tau\>>=\<leq\><rsub|\<sigma\>>\<uplus\>\<leq\><rsub|\<tau\>>>.
  This bifunctor induces a monoidal structure
  <math|<around|(|<Games>,<before>,I|)>> on the category <math|<Games>>,
  where <math|I> denotes the empty game.

  We write <math|O> for a game with only one Opponent move and <math|P> for a
  game with only one Proponent move. It can be easily remarked that finite
  filiform games <math|A> are generated by the following grammar

  <\equation*>
    A<qqgramdef>I<gramor>O<before>A<gramor>P<before>A
  </equation*>

  A game <math|X<rsub|1><before>\<cdots\><before>X<rsub|n><before>I> where
  the <math|X<rsub|i>> are either <math|O> or <math|P> is represented
  graphically as

  <\equation*>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|X<rsub|1>>>|<row|<cell|\<vdots\>>>|<row|<cell|X<rsub|n>>>>>>
  </equation*>

  and a strategy <math|\<sigma\>:A\<to\>B> is represented graphically by
  drawing a line from a move <math|m> to a move <math|n> whenever
  <math|m\<leq\><rsub|\<sigma\>>n>. For example, the strategy
  <math|\<mu\><rsup|P>:P<before>P\<to\>P>

  <\equation*>
    <strid|m*u*l*t<rsub|P>>
  </equation*>

  is the strategy on the game <math|<around|(|O<before>O|)>\<otimes\>P> in
  which both Opponent move of the left-hand game justify the Proponent move
  of the right-hand game. When a move does not justify (or is not justified
  by) any other move, we draw a line ended by a small circle. For example,
  the strategy <math|\<varepsilon\><rsup|P>:P\<to\>I>, drawn as

  <\equation*>
    <strid|c*o*u*n*i*t<rsub|P><rsub|s>*m*a*l*l>
  </equation*>

  is the unique strategy from <math|P> to the terminal object <math|I>. With
  these conventions, we introduce notations for some morphisms which are
  depicted in Figure<nbsp><reference|fig:inno-gen>.

  <\big-figure>
    <\vbox>
      <\equation*>
        <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<table|<row|<cell|\<mu\><rsup|O>>|<cell|O<before>O\<to\>O>|<cell|\<mu\><rsup|P>>|<cell|P<before>P\<to\>P>>|<row|<cell|\<eta\><rsup|O>>|<cell|I\<to\>O>|<cell|\<eta\><rsup|P>>|<cell|I\<to\>P>>|<row|<cell|\<delta\><rsup|O>>|<cell|O\<to\>O<before>O>|<cell|\<delta\><rsup|P>>|<cell|P\<to\>P<before>P>>|<row|<cell|\<varepsilon\><rsup|O>>|<cell|O\<to\>I>|<cell|\<varepsilon\><rsup|P>>|<cell|P\<to\>I>>|<row|<cell|\<gamma\><rsup|O>>|<cell|O<before>O\<to\>O<before>O>|<cell|\<gamma\><rsup|P>>|<cell|P<before>P\<to\>P<before>P>>|<row|<cell|\<eta\><rsup|O*P>>|<cell|I\<to\>O<before>P>|<cell|\<varepsilon\><rsup|O*P>>|<cell|P<before>O\<to\>I>>>>>>>|<row|<cell|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|\<gamma\><rsup|O*P>>|<cell|:>|<cell|P<before>O\<to\>O<before>P>>>>>>>>>>
      </equation*>

      respectively drawn as

      <\equation*>
        <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|1|1|-1|cell-valign|top>|<cwith|1|1|1|-1|cell-vmode|exact>|<cwith|1|1|1|-1|cell-height|<plus|1fn|4ex>>|<cwith|2|2|1|-1|cell-valign|top>|<cwith|2|2|1|-1|cell-vmode|exact>|<cwith|2|2|1|-1|cell-height|<plus|1fn|4ex>>|<cwith|3|3|1|-1|cell-valign|top>|<cwith|3|3|1|-1|cell-vmode|exact>|<cwith|3|3|1|-1|cell-height|<plus|1fn|4ex>>|<cwith|4|4|1|-1|cell-valign|top>|<cwith|4|4|1|-1|cell-vmode|exact>|<cwith|4|4|1|-1|cell-height|<plus|1fn|4ex>>|<cwith|5|5|1|-1|cell-valign|top>|<cwith|5|5|1|-1|cell-vmode|exact>|<cwith|5|5|1|-1|cell-height|<plus|1fn|4ex>>|<table|<row|<cell|<strid|m*u*l*t<rsub|O>>>|<cell|<strid|m*u*l*t<rsub|P>>>>|<row|<cell|<strid|u*n*i*t<rsub|O>>>|<cell|<strid|u*n*i*t<rsub|P>>>>|<row|<cell|<strid|c*o*m*u*l*t<rsub|O>>>|<cell|<strid|c*o*m*u*l*t<rsub|P>>>>|<row|<cell|<strid|c*o*u*n*i*t<rsub|O>>>|<cell|<strid|c*o*u*n*i*t<rsub|P>>>>|<row|<cell|<strid|s*y*m<rsub|O>>>|<cell|<strid|s*y*m<rsub|P>>>>|<row|<cell|<strid|u*n*i*t<rsub|O>*P>>|<cell|<strid|c*o*u*n*i*t<rsub|O>*P>>>>>>>>|<row|<cell|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<strid|s*y*m<rsub|O>*P>>>>>>>>>>>
      </equation*>
    </vbox>

    <label|fig:inno-gen>
  </big-figure|Generators of the strategies.>

  <paragraph|A game semantics.> A formula <math|A> is interpreted as a
  filiform game<nbsp><math|<intp|A>> by

  <\equation*>
    <intp|P>=I<space|2em><intp|<qforall|x>A>=O<before><intp|A><space|2em><intp|<qexists|x>A>=P<before><intp|A>
  </equation*>

  A cut-free proof <math|\<pi\>:A\<vdash\>B> is interpreted as a strategy
  <math|\<sigma\>:<intp|A><llimp><intp|B>> whose causality partial order
  <math|\<leq\><rsub|\<sigma\>>> is defined as follows. For every Proponent
  move <math|P> interpreting a quantifier introduced by a rule which is
  either

  <\equation*>
    <inferrule|A*<around|[|t/x|]>\<vdash\>B|<qforall|x>A\<vdash\>B|<lrule|<math|\<forall\>>-L>><qqtor><inferrule|A\<vdash\>B*<around|[|t/x|]>|A\<vdash\><qexists|x>B|<lrule|<math|\<exists\>>-R>>
  </equation*>

  every Opponent move <math|O> interpreting an universal quantification
  <math|\<forall\>x> on the right-hand side of a sequent, or an existential
  quantification <math|\<exists\>x> on the left-hand side of a sequent, is
  such that <math|O\<leq\><rsub|\<sigma\>>P> whenever the variable <math|x>
  is free in the term <math|t>. For example, a proof

  <\equation*>
    <inferrule|<inferrule|<inferrule|<inferrule|<null>|P\<vdash\>Q*<around|[|t/z|]>|<lrule|A*x>>|P\<vdash\><qexists|z>Q|<lrule|<math|\<exists\>>-R>>|<qexists|y>P\<vdash\><qexists|z>Q|<lrule|<math|\<exists\>>-L>>|<qexists|x><qexists|y>P\<vdash\><qexists|z>Q|<lrule|<math|\<exists\>>-L>>
  </equation*>

  is interpreted respectively by the strategies

  <\equation>
    <label|eq:ex-intp><sstrid|s*t*r*a*t<rsub|e>*x<rsub|x>*y>

    <sstrid|s*t*r*a*t<rsub|e>*x<rsub|x>>

    <sstrid|s*t*r*a*t<rsub|e>*x<\<sub\>>>
  </equation>

  when the free variables of <math|t> are <math|<around|{|x,y|}>>,
  <math|<around|{|x|}>> or <math|\<emptyset\>>.

  <\remark>
    This interpretation could be generalized to proofs with cuts using the
    composition of the category<nbsp><math|<Games>>, and one could show that
    the interpretation is invariant under cut-elimination. However, we do not
    detail this here since it is best expressed using connectives and leave
    this for future works.
  </remark>

  <paragraph|An equational theory of strategies.><label|subsection:walking-inno>We
  can now introduce the equational theory which will be shown to present the
  category<nbsp><math|<Games>>.

  <\definition>
    <label|definition:innocent-strategies>The <em|equational theory of
    strategies> is the equational theory <math|<eqth|G>> with two atomic
    types <math|O> and <math|P> and thirteen generators depicted in
    Figure<nbsp><reference|fig:inno-gen> such that

    <\itemize>
      <item>the Opponent structure

      <\equation>
        <label|eq:O-struct><around|(|O,\<mu\><rsup|O>,\<eta\><rsup|O>,\<delta\><rsup|O>,\<varepsilon\><rsup|O>,\<gamma\><rsup|O>|)>
      </equation>

      is a bicommutative qualitative bialgebra,

      <item>the object <math|P> is left dual to the object <math|O> with
      <math|\<eta\><rsup|O*P>> as unit and <math|\<varepsilon\><rsup|O*P>> as
      counit,

      <item>the Proponent structure <math|<around|(|P,\<mu\><rsup|P>,\<eta\><rsup|P>,\<delta\><rsup|P>,\<varepsilon\><rsup|P>,\<gamma\><rsup|P>|)>>,
      as well as the morphism<nbsp><math|\<gamma\><rsup|O*P>>, are deduced
      from the Opponent structure <eqref|eq:O-struct> by composition with the
      duality morphisms<nbsp><math|\<eta\><rsup|O*P>>
      and<nbsp><math|\<varepsilon\><rsup|O*P>>, in the sense that the
      equations of Figure<nbsp><reference|fig:PO-adj> hold.
    </itemize>
  </definition>

  <\big-figure>
    <\with|par-mode|center>
      <\equation*>
        <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|1|1|-1|cell-valign|top>|<cwith|1|1|1|-1|cell-vmode|exact>|<cwith|1|1|1|-1|cell-height|<plus|1fn|4ex>>|<cwith|2|2|1|-1|cell-valign|top>|<cwith|2|2|1|-1|cell-vmode|exact>|<cwith|2|2|1|-1|cell-height|<plus|1fn|4ex>>|<cwith|3|3|1|-1|cell-valign|top>|<cwith|3|3|1|-1|cell-vmode|exact>|<cwith|3|3|1|-1|cell-height|<plus|1fn|4ex>>|<cwith|4|4|1|-1|cell-valign|top>|<cwith|4|4|1|-1|cell-vmode|exact>|<cwith|4|4|1|-1|cell-height|<plus|1fn|4ex>>|<cwith|5|5|1|-1|cell-valign|top>|<cwith|5|5|1|-1|cell-vmode|exact>|<cwith|5|5|1|-1|cell-height|<plus|1fn|10ex>>|<table|<row|<cell|<strid|m*u*l*t<rsub|P>>>|<cell|<strid|c*o*m*u*l*t<rsub|O><rsub|a>*d*j>>>|<row|<cell|<strid|c*o*m*u*l*t<rsub|P>>>|<cell|<strid|m*u*l*t<rsub|O><rsub|a>*d*j>>>|<row|<cell|<strid|u*n*i*t<rsub|P>>>|<cell|<strid|c*o*u*n*i*t<rsub|O><rsub|a>*d*j>>>|<row|<cell|<strid|c*o*u*n*i*t<rsub|P>>>|<cell|<strid|u*n*i*t<rsub|P><rsub|a>*d*j>>>|<row|<cell|<strid|s*y*m<rsub|P>>>|<cell|<strid|s*y*m<rsub|O><rsub|a>*d*j>>>|<row|<cell|<strid|s*y*m<rsub|O>*P>>|<cell|<strid|s*y*m<rsub|O><rsub|a>*d*j<rsub|O>*P>>>>>>
      </equation*>

      <label|fig:PO-adj>
    </with>
  </big-figure|Proponent is left dual to Opponent.>

  <no-indent>We write <math|<catquot|\<cal-G\>>> for the monoidal category
  generated by <math|<eqth|G>>. It can be noticed that the generators
  <math|\<mu\><rsup|P>>, <math|\<eta\><rsup|P>>, <math|\<delta\><rsup|P>>,
  <math|\<varepsilon\><rsup|P>>, <math|\<gamma\><rsup|P>>
  and<nbsp><math|\<gamma\><rsup|O*P>> are superfluous in this presentation
  (since they can be deduced from the Opponent structure and duality).
  However, removing them would seriously complicate the proofs.

  <\remark>
    If we adopt the point of view of logic, the relations of
    Figure<nbsp><reference|fig:PO-adj> (as well as in fact all the relations
    of our presentation) can be understood as rules for cut-elimination. For
    example, suppose for clarity that function symbols include a nullary
    symbol<nbsp><math|0>, that proposition symbols include a nullary
    symbol<nbsp><math|\<top\>> and a binary symbol<nbsp><math|=>, and that
    the set<nbsp><math|<axioms>> of axioms contains the reasonable axioms for
    equality, <eg><math|<around|(|\<top\>,x=x|)>\<in\><axioms>>, etc. In the
    third equation of Figure<nbsp><reference|fig:PO-adj>, the left and right
    members are respectively the interpretation of the proofs

    <\equation*>
      <inferrule|<inferrule|<null>|\<top\>\<vdash\>0=0|<lrule|A*x>>|\<top\>\<vdash\><qexists|x>x=0|<lruler|\<exists\>>>
    </equation*>

    and

    <\equation*>
      <inferrule|<inferrule|<inferrule|<inferrule|<null>|\<top\>\<vdash\>y=y|<lrule|A*x>>|\<top\>\<vdash\><qexists|z>y=z|<lruler|\<exists\>>>|\<top\>\<vdash\><qforall|y><qexists|z>y=z|<lruler|\<forall\>>><next-line><inferrule|<inferrule|<inferrule|<inferrule|<null>|0=z\<vdash\>z=0|<lrule|A*x>>|0=z\<vdash\><qexists|x>x=0|<lruler|\<exists\>>>|<qexists|z>0=z\<vdash\><qexists|x>x=0|<lrulel|\<exists\>>>|<qforall|y><qexists|z>y=z\<vdash\><qexists|x>x=0|<lrulel|\<exists\>>>|\<top\>\<vdash\><qexists|x>x=0|<lrule|C*u*t>>
    </equation*>

    and the second proof reduces to the first one by cut-elimination.
  </remark>

  <\lemma>
    With the notations of<nbsp><reference|definition:innocent-strategies>, we
    have:

    <\itemize>
      <item><math|<around|(|P,\<mu\><rsup|P>,\<eta\><rsup|P>,\<delta\><rsup|P>,\<varepsilon\><rsup|P>,\<gamma\><rsup|P>|)>>
      is a qualitative bicommutative bialgebra,

      <item>the Yang-Baxter equalities

      <\equation*>
        <strid|y*a*n*g<rsub|b>*a*x*t*e*r<rsub|x>*y*z<rsub|r>><qeq><strid|y*a*n*g<rsub|b>*a*x*t*e*r<rsub|x>*y*z<rsub|l>>
      </equation*>

      hold whenever <math|<around|(|X,Y,Z|)>> is either
      <math|<around|(|O,O,O|)>>, <math|<around|(|P,O,O|)>>,
      <math|<around|(|P,P,O|)>> or <math|<around|(|P,P,P|)>>,

      <item>the equalities

      <\equation*>
        <strid|m*u*l*t<rsub|s>*y*m<rsub|r>*n*a*t<rsub|P><rsub|l>>=<strid|m*u*l*t<rsub|s>*y*m<rsub|r>*n*a*t<rsub|P><rsub|r>>
      </equation*>

      and

      <\equation*>
        <strid|m*u*l*t<rsub|s>*y*m<rsub|l>*n*a*t<rsub|O><rsub|l>>=<strid|m*u*l*t<rsub|s>*y*m<rsub|l>*n*a*t<rsub|O><rsub|r>>
      </equation*>

      hold (and dually for comultiplications),

      <item>the equalities

      <\equation*>
        <strid|e*t*a<rsub|s>*y*m<rsub|r>*n*a*t<rsub|P><rsub|l>>=<strid|e*t*a<rsub|s>*y*m<rsub|r>*n*a*t<rsub|P><rsub|r>>
      </equation*>

      and

      <\equation*>
        <strid|e*t*a<rsub|s>*y*m<rsub|l>*n*a*t<rsub|O><rsub|l>>=<strid|e*t*a<rsub|s>*y*m<rsub|l>*n*a*t<rsub|O><rsub|r>>
      </equation*>

      hold (and dually for counits),

      <item>the equalities

      <\equation*>
        <strid|a*d*j<rsub|c>*o*u*n*i*t<rsub|O><rsub|r>>=<strid|a*d*j<rsub|c>*o*u*n*i*t<rsub|O><rsub|l>>
      </equation*>

      and

      <\equation*>
        <strid|a*d*j<rsub|c>*o*u*n*i*t<rsub|P><rsub|r>>=<strid|a*d*j<rsub|c>*o*u*n*i*t<rsub|P><rsub|l>>
      </equation*>

      hold (and dually for the counit of duality).
    </itemize>
  </lemma>

  We can now proceed as in Section<nbsp><reference|section:presentation-rel>
  to show that the theory<nbsp><math|<eqth|G>> introduced in
  Definition<nbsp><reference|definition:innocent-strategies> presents the
  category<nbsp><math|<Games>>. First, in the category <math|<Games>> with
  the monoidal structure induced by <math|<before>>, the objects <math|O> and
  <math|P> can be canonically equipped with thirteen morphisms as shown in
  Figure<nbsp><reference|fig:inno-gen> in order to form a model of the
  theory<nbsp><math|<eqth|G>>.

  Conversely, we need to introduce a notion of canonical form for the
  morphisms of<nbsp><math|\<cal-G\>>. Stairs are defined similarly as before,
  but are now constructed from the three kinds of polarized crossings
  <math|\<gamma\><rsup|O>>, <math|\<gamma\><rsup|P>> and
  <math|\<gamma\><rsup|O*P>> instead of simply<nbsp><math|\<gamma\>>
  in<nbsp><eqref|eq:ctx-S>: a <em|stair> is either <rsub|<math|O>>
  or<nbsp><rsub|<math|P>> or

  <\equation*>
    <strid|g*s*y*m<rsub|s>*y*m<rsub|O>><tor><strid|g*s*y*m<rsub|s>*y*m<rsub|P>><tor><strid|g*s*y*m<rsub|s>*y*m<rsub|O>*P>
  </equation*>

  The notion of <em|precanonical form><nbsp><math|\<phi\>> is now defined
  inductively as shown in Figure<nbsp><reference|fig:precan-strat>,

  <big-figure|<\with|par-mode|center>
    <\vbox>
      <math|\<phi\>> is either empty or

      <\equation*>
        <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<cwith|1|1|1|-1|cell-valign|top>|<cwith|1|1|1|-1|cell-vmode|exact>|<cwith|1|1|1|-1|cell-height|<plus|1fn|37ex>>|<cwith|2|2|1|-1|cell-valign|top>|<cwith|2|2|1|-1|cell-vmode|exact>|<cwith|2|2|1|-1|cell-height|<plus|1fn|20ex>>|<table|<row|<cell|A<rsub|i>*\<phi\><rprime|'><space|1em>=<sstrid|n*f<rsub|a>*d*j><qtor>B<rsub|i>*\<phi\><rprime|'><space|1em>=<sstrid|n*f<rsub|c>*o*a*d*j>>>|<row|<cell|<qtor>H<rsup|X>*\<phi\><rprime|'><space|1em>=<sstrid|n*f<rsub|e>*t*a><qtor>E<rsup|X>*\<phi\><rprime|'><space|1em>=<sstrid|n*f<rsub|e>*p*s>>>|<row|<cell|<qtor>W<rsub|i>*\<phi\><rprime|'><space|1em>=<sstrid|n*f<rsub|m>*u>>>>>>
      </equation*>
    </vbox>

    <label|fig:precan-strat>
  </with>|Precanonical forms for strategies.>

  where the object<nbsp><math|X> is either<nbsp><math|O> or<nbsp><math|P> and
  <math|\<phi\><rprime|'>> is a precanonical form. These cases correspond
  respectively to the productions of the following grammar

  <\equation*>
    \<phi\><qgramdef>Z<sgramor>A<rsub|i>*\<phi\><sgramor>B<rsub|i>*\<phi\><sgramor>W<rsub|i>*\<phi\><sgramor>E<rsup|X>*\<phi\><sgramor>H<rsup|X>*\<phi\>
  </equation*>

  By induction on the size of morphisms, it can be shown that every morphism
  of<nbsp><math|\<cal-G\>> is equivalent to a precanonical form and a notion
  of canonical form can be defined by adapting the rewriting
  system<nbsp><eqref|eq:mrel-cf-rs> into a rewriting system for precanonical
  forms, by adding the rules

  <\equation*>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<table|<row|<cell|H<rsup|X>*W<rsub|i>>|<cell|W<rsub|i+1>*H<rsup|X>>|<cell|>>|<row|<cell|H<rsup|X>*E<rsup|Y>>|<cell|E<rsup|Y>*H<rsup|X>>|<cell|>>|<row|<cell|W<rsub|i>*W<rsub|j>>|<cell|W<rsub|j>*W<rsub|i>>|<cell|<text|when
    >i\<less\>j>>|<row|<cell|W<rsub|i>*W<rsub|i>>|<cell|W<rsub|i>>|<cell|>>|<row|<cell|H<rsup|X>*A<rsub|i>>|<cell|A<rsub|i>*H<rsup|X>>|<cell|>>|<row|<cell|A<rsub|i>*W<rsub|j>>|<cell|W<rsub|j>*A<rsub|i>>|<cell|>>|<row|<cell|A<rsub|i>*A<rsub|j>>|<cell|A<rsub|j>*A<rsub|i>>|<cell|<text|when
    >i\<less\>j>>|<row|<cell|A<rsub|i>*A<rsub|i>>|<cell|A<rsub|i>>|<cell|>>|<row|<cell|E<rsup|X>*B<rsub|i>>|<cell|E<rsup|X>>|<cell|>>|<row|<cell|B<rsub|i>*W<rsub|j>>|<cell|W<rsub|j>*B<rsub|i>>|<cell|>>|<row|<cell|B<rsub|i>*B<rsub|j>>|<cell|B<rsub|j>*B<rsub|i>>|<cell|<text|when
    >i\<less\>j>>|<row|<cell|B<rsub|i>*B<rsub|i>>|<cell|B<rsub|i>>|<cell|>>|<row|<cell|B<rsub|i>*A<rsub|j>>|<cell|A<rsub|j>*B<rsub|i>>|<cell|>>>>>
  </equation*>

  to the rewriting system containing the rules<nbsp><eqref|eq:mrel-cf-rs>
  and<nbsp><eqref|eq:rel-cf-rs>. It is simple to extend the proof of
  Lemma<nbsp><reference|lemma:mrel-can> in order to show that this rewriting
  system is normalizing. The general form for canonical forms is

  <\equation>
    <label|eq:games-explicit-cf><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<table|<row|<cell|W<rsub|i<rsup|n><rsub|k<rsub|n>>>*\<cdots\>*W<rsub|i<rsup|n><rsub|1>>*A<rsub|j<rsup|n><rsub|l<rsub|n>>>*\<cdots\>*A<rsub|j<rsup|n><rsub|1>>*E*\<cdots\>>|<cell|\<cdots\>*W<rsub|i<rsup|1><rsub|k<rsub|1>>>*\<cdots\>*W<rsub|i<rsup|1><rsub|1>>*A<rsub|j<rsup|1><rsub|l<rsub|1>>>*\<cdots\>*A<rsub|j<rsup|1><rsub|1>>*E>>|<row|<cell|>|<cell|\<cdots\>*B<rsub|h<rsup|p><rsub|m<rsub|p>>>*\<cdots\>*B<rsub|h<rsup|p><rsub|1>>*H*\<cdots\>*B<rsub|h<rsup|1><rsub|m<rsub|1>>>*\<cdots\>*B<rsub|h<rsup|1><rsub|1>>*H*Z>>>>>
  </equation>

  with

  <\itemize>
    <item><math|i<rsup|p><rsub|k<rsub|p>>\<gtr\>\<ldots\>\<gtr\>i<rsup|p><rsub|1>>
    for every integer <math|r> such that <math|1\<leq\>r\<leq\>k<rsub|n>>,

    <item><math|j<rsup|p><rsub|l<rsub|p>>\<gtr\>\<ldots\>\<gtr\>j<rsup|p><rsub|1>>
    for every integer <math|r> such that <math|1\<leq\>r\<leq\>l<rsub|n>>,

    <item><math|h<rsup|p><rsub|l<rsub|p>>\<gtr\>\<ldots\>\<gtr\>h<rsup|p><rsub|1>>
    for every integer <math|r> such that <math|1\<leq\>r\<leq\>m<rsub|n>>.
  </itemize>

  <\lemma>
    Every strategy <math|\<sigma\>:A\<to\>B> is the interpretation of an
    unique canonical form.
  </lemma>

  <\proof>
    We show that every strategy<nbsp><math|\<sigma\>:A\<to\>B> is the
    interpretation of a precanonical form<nbsp><math|\<phi\>:A\<to\>B> by
    induction on the triple<nbsp><math|<around|(|<size|A>,<size|\<sigma\>>,<size|B>|)>>,
    ordered lexicographically.

    <\enumerate>
      <item>If<nbsp><math|A=B=I> then<nbsp><math|\<sigma\>> is the
      interpretation of the precanonical form<nbsp><math|Z>.

      <item>If<nbsp><math|A=I> and<nbsp><math|B=X\<otimes\>B<rprime|'>>,
      where<nbsp><math|X> is either<nbsp><math|P> or<nbsp><math|O> then we
      distinguish two cases.

      <\itemize>
        <item>If no move depends on<nbsp><math|X> in the strategy, this
        strategy is the image of a precanonical
        form<nbsp><math|H<rsub|X>*\<phi\><rprime|'>>, where
        <math|\<phi\><rprime|'>> is a precanonical form, obtained by
        induction hypothesis whose interpretation is the strategy
        <math|\<sigma\><rprime|'>:I\<to\>B<rprime|'>> obtained by
        restricting<nbsp><math|\<sigma\>> to the codomain<nbsp><math|B> (the
        size of<nbsp><math|\<sigma\><rprime|'>>
        is<nbsp><math|<size|\<sigma\><rprime|'>>=<size|\<sigma\>>>).

        <item>Otherwise, we write<nbsp><math|i> for the index
        in<nbsp><math|B> of the move of minimal index which depends
        on<nbsp><math|X> in the strategy. The strategy is the image of a
        precanonical form<nbsp><math|B<rsub|i>*\<phi\><rprime|'>>,
        where<nbsp><math|\<phi\><rprime|'>> is precanonical form, obtained by
        induction hypothesis, whose interpretation is the
        strategy<nbsp><math|\<sigma\><rprime|'>:I\<to\>B> obtained
        from<nbsp><math|\<sigma\>> by removing the dependency of the
        <math|i>-th move of<nbsp><math|B> on the first move of<nbsp><math|B>
        (its size is such that<nbsp><math|<size|\<sigma\><rprime|'>>\<less\><size|\<sigma\>>>).
      </itemize>

      <item>If<nbsp><math|A=X\<otimes\>A<rprime|'>>, where<nbsp><math|X> is
      either<nbsp><math|P> or<nbsp><math|O>, then we distinguish three cases.

      <\itemize>
        <item>If no move depends on<nbsp><math|X> in the strategy, this
        strategy is the image of a precanonical
        form<nbsp><math|E<rsup|X>*\<phi\><rprime|'>>,
        where<nbsp><math|\<phi\><rprime|'>> is a precanonical form, obtained
        by induction hypothesis, whose interpretation is the strategy
        <math|\<sigma\><rprime|'>:A<rprime|'>\<to\>B> obtained by
        restricting<nbsp><math|\<sigma\>> to the
        domain<nbsp><math|A<rprime|'>>.

        <item>If there exists a move of<nbsp><math|X> which depends
        on<nbsp><math|X>, we write<nbsp><math|i> for the index
        in<nbsp><math|A> of such a move of minimal index. The strategy is the
        interpretation of a precanonical form<nbsp><math|A<rsub|i>*\<phi\><rprime|'>>,
        where<nbsp><math|\<phi\><rprime|'>> is a precanonical form, obtained
        by induction hypothesis, whose interpretation is the
        strategy<nbsp><math|\<sigma\><rprime|'>:A\<to\>B> obtained
        from<nbsp><math|\<sigma\>> by removing the dependency of the
        <math|i>-th move of<nbsp><math|A> on the first move of<nbsp><math|A>
        (its size is such that <math|<size|\<sigma\><rprime|'>>\<less\><size|\<sigma\>>>).

        <item>Otherwise, there exists a move in<nbsp><math|B> which depends
        on the move<nbsp><math|X>. We write<nbsp><math|i> of the index
        in<nbsp><math|B> of such a move of minimal index. The strategy is the
        interpretation of a precanonical form<nbsp><math|W<rsub|i>*\<phi\><rprime|'>>,
        where<nbsp><math|\<phi\><rprime|'>> is a precanonical form, obtained
        by induction hypothesis, whose interpretation is the
        strategy<nbsp><math|\<sigma\><rprime|'>:A\<to\>B>, obtained
        from<nbsp><math|\<sigma\>> by removing the dependency of the
        <math|i>-th move of<nbsp><math|B> on the first move of<nbsp><math|A>
        (its size is such that<nbsp><math|<size|\<sigma\><rprime|'>>\<less\><size|\<sigma\>>>).
      </itemize>
    </enumerate>

    Knowing the general form<nbsp><eqref|eq:games-explicit-cf> of canonical
    forms, it is easy to show that the precanonical forms thus constructed
    are actually canonical and that canonical
    forms<nbsp><math|\<phi\>:A\<to\>B> are in bijection with
    strategies<nbsp><math|\<sigma\>:A\<to\>B>, as in the proof of
    Theorem<nbsp><reference|thm:fmr-pres>.
  </proof>

  We therefore deduce the main theorem of this article:

  <\theorem>
    <label|thm:pres-games>The monoidal category <math|<Games>> (with
    the<nbsp><math|<before>> tensor product) is presented by the equational
    theory <math|<eqth|G>>.
  </theorem>

  <no-indent>As a direct consequence of this Theorem, we deduce the two
  following properties which show the technical benefits of our construction.

  <\theorem>
    <label|thm:composition>The composite of two strategies, in the sense of
    Definition<nbsp><reference|def:strategy>, is itself a strategy (in
    particular, the acyclicity property is preserved by composition).
  </theorem>

  <\proof>
    Two strategies<nbsp><math|\<sigma\>:A\<to\>B>
    and<nbsp><math|\<tau\>:B\<to\>C> can be seen as
    morphisms<nbsp><math|<wide|\<sigma\>|~>> and<nbsp><math|<wide|\<tau\>|~>>
    the category<nbsp><math|<catquot|\<cal-G\>>> and the image of their
    composite is<nbsp><math|<wide|\<tau\>\<circ\>\<sigma\>|~>=<wide|\<tau\>|~>\<circ\><wide|\<sigma\>|~>>,
    which corresponds to the image of an unique acyclic strategy.
  </proof>

  <\theorem>
    <label|thm:definability>The strategies of<nbsp><math|<Games>> are
    definable (when the set<nbsp><math|<axioms>> of axioms is reasonably
    large enough): it is enough to check that generators are definable \U for
    example, the first case of<nbsp><eqref|eq:ex-intp> shows
    that<nbsp><math|\<mu\><rsup|P>> is definable.
  </theorem>

  <\proof>
    Suppose that there is a countable number of variable symbols. Suppose
    moreover that there exists a unary propositional symbol<nbsp><math|I>,
    which enables us to see every term<nbsp><math|t> as a
    proposition<nbsp><math|I<around|(|t|)>>, which we will simply
    write<nbsp><math|t> by abuse of notation. We also suppose that the set of
    propositions contains two nullary propositions<nbsp><math|\<top\>>
    and<nbsp><math|\<bot\>> and is closed under formal conjunctions and
    disjunctions: if we have that<nbsp><math|P<around|(|x<rsub|1>,\<ldots\>,x<rsub|n>|)>>
    and<nbsp><math|Q<around|(|y<rsub|1>,\<ldots\>,y<rsub|m>|)>> are
    propositions then <math|P<around|(|x<rsub|1>,\<ldots\>,x<rsub|n>|)>\<wedge\>Q<around|(|y<rsub|1>,\<ldots\>,y<rsub|m>|)>>
    and <math|P<around|(|x<rsub|1>,\<ldots\>,x<rsub|n>|)>\<vee\>Q<around|(|y<rsub|1>,\<ldots\>,y<rsub|m>|)>>
    are also propositions. We then define a set<nbsp><math|<axioms>> of
    axioms as the smallest set of pairs of propositions which is reflexive,
    transitive and such that:

    <\itemize>
      <item>for every proposition <math|P>,

      <\itemize>
        <item><math|<around|(|P,\<top\>|)>\<in\><axioms>>,

        <item><math|<around|(|\<bot\>,P|)>\<in\><axioms>>,
      </itemize>

      <item>for every propositions <math|P>, <math|P<rsub|1>> and
      <math|P<rsub|2>>,

      <\itemize>
        <item>if <math|<around|(|P,P<rsub|1>|)>\<in\><axioms>> and
        <math|<around|(|P,P<rsub|2>|)>\<in\><axioms>> then
        <math|<around|(|P,P<rsub|1>\<wedge\>P<rsub|2>|)>\<in\><axioms>>,

        <item>if <math|<around|(|P,P<rsub|1>|)>\<in\><axioms>> or
        <math|<around|(|P,P<rsub|1>|)>\<in\><axioms>> then
        <math|<around|(|P,P<rsub|1>\<vee\>P<rsub|2>|)>\<in\><axioms>>,

        <item>if <math|<around|(|P<rsub|1>,P|)>\<in\><axioms>> or
        <math|<around|(|P<rsub|2>,P|)>\<in\><axioms>> then
        <math|<around|(|P<rsub|1>\<wedge\>P<rsub|2>,P|)>\<in\><axioms>>,

        <item>if <math|<around|(|P<rsub|1>,P|)>\<in\><axioms>> and
        <math|<around|(|P<rsub|2>,P|)>\<in\><axioms>> then
        <math|<around|(|P<rsub|1>\<vee\>P<rsub|2>,P|)>\<in\><axioms>>.
      </itemize>
    </itemize>

    (for concision, we did not mention the arguments of propositions). By
    Theorem<nbsp><reference|thm:pres-games>, every strategy can be expressed
    as a tensor and composite of the generating strategies pictured in
    Figure<nbsp><reference|fig:inno-gen>. It is therefore enough to show that
    those strategies are definable.

    <\itemize>
      <item>the strategies<nbsp><math|\<mu\><rsup|P>>
      and<nbsp><math|\<eta\><rsup|P>> are the respective interpretations of
      the proofs

      <\equation*>
        <inferrule|<inferrule|<inferrule|<inferrule|<null>|x\<wedge\>y\<vdash\>x\<wedge\>y|<lrule|A*x>>|x\<wedge\>y\<vdash\><qexists|z>z|<lruler|\<exists\>>>|<qexists|y>x\<wedge\>y\<vdash\><qexists|z>z|<lrulel|\<exists\>>>|<qexists|x><qexists|y>x\<wedge\>y\<vdash\><qexists|z>z|<lrulel|\<exists\>>><qtand><inferrule|<inferrule|<null>|\<top\>\<vdash\>\<top\>|<lrule|A*x>>|\<top\>\<vdash\><qexists|x>x|<lruler|\<exists\>>>
      </equation*>

      <item>the strategies<nbsp><math|\<delta\><rsup|P>>
      and<nbsp><math|\<varepsilon\><rsup|P>> are the respective
      interpretations of the proofs

      <\equation*>
        <inferrule|<inferrule|<inferrule|<inferrule|<null>|x\<vdash\>x\<wedge\>x|<lrule|A*x>>|x\<vdash\><qexists|z>x\<wedge\>z|<lruler|\<exists\>>>|x\<vdash\><qexists|y><qexists|z>y\<wedge\>z|<lruler|\<exists\>>>|<qexists|x>x\<vdash\><qexists|y><qexists|z>y\<wedge\>z|<lrulel|\<exists\>>><qtand><inferrule|<inferrule|<null>|x\<vdash\>\<top\>|<lrule|A*x>>|<qexists|x>x\<vdash\>\<top\>|<lrulel|\<exists\>>>
      </equation*>

      <item>the strategies<nbsp><math|\<eta\><rsup|O*P>>
      and<nbsp><math|\<varepsilon\><rsup|O*P>> are the respective
      interpretations of the proofs

      <\equation*>
        <inferrule|<inferrule|<inferrule|<null>|\<top\>\<vdash\>x\<vee\><around|(|x\<vee\>\<top\>|)>|<lrule|A*x>>|\<top\>\<vdash\><qexists|y>x\<vee\>y|<lruler|\<exists\>>>|\<top\>\<vdash\><qforall|x><qexists|y>x\<vee\>y|<lruler|\<forall\>>><qtand><inferrule|<inferrule|<inferrule|<null>|x\<wedge\><around|(|x\<wedge\>\<bot\>|)>\<vdash\>\<bot\>|<lrule|A*x>>|<qforall|y>x\<wedge\>y\<vdash\>\<bot\>|<lrulel|\<forall\>>>|<qexists|x><qforall|y>x\<wedge\>y\<vdash\>\<bot\>|<lrulel|\<exists\>>>
      </equation*>

      <item>the strategies<nbsp><math|\<gamma\><rsup|P>>
      and<nbsp><math|\<gamma\><rsup|O*P>> are the respective interpretations
      of the proofs

      <\equation*>
        <inferrule|<inferrule|<inferrule|<inferrule|<inferrule|<null>|x\<wedge\>y\<vdash\>x\<wedge\>y|<lrule|A*x>>|x\<wedge\>y\<vdash\><qexists|t>t\<wedge\>y|<lruler|\<exists\>>>|x\<wedge\>y\<vdash\><qexists|z><qexists|t>t\<wedge\>z|<lruler|\<exists\>>>|<qexists|y>x\<wedge\>y\<vdash\><qexists|z><qexists|t>t\<wedge\>z|<lrulel|\<exists\>>>|<qexists|x><qexists|y>x\<wedge\>y\<vdash\><qexists|z><qexists|t>t\<wedge\>z|<lrulel|\<exists\>>><qtand><inferrule|<inferrule|<inferrule|<inferrule|<inferrule|<null>|x\<wedge\>z\<vdash\>x\<wedge\>z|<lrule|A*x>>|x\<wedge\>z\<vdash\><qexists|t>t\<wedge\>z|<lruler|\<exists\>>>|<qforall|y>x\<wedge\>y\<vdash\><qexists|t>t\<wedge\>z|<lrulel|\<forall\>>>|<qexists|x><qforall|y>x\<wedge\>y\<vdash\><qexists|t>t\<wedge\>z|<lrulel|\<exists\>>>|<qexists|x><qforall|y>x\<wedge\>y\<vdash\><qforall|z><qexists|t>t\<wedge\>z|<lruler|\<forall\>>>
      </equation*>

      <item>etc.
    </itemize>
  </proof>

  A given strategy is not necessarily the interpretation of a unique proof.
  In particular, as explained in the introduction, two proofs which only
  differ by the order of introduction of some successive connectives are
  identified in the semantics.

  In the preceding proof, we could of course have taken the set of all pairs
  of propositions as set<nbsp><math|<axioms>> of axioms. The set that we have
  used shows however that our definability result can be obtained with a
  reasonable set of axioms: it is in particular <em|coherent>, which means
  that there exists a sequent which cannot be proved (the sequent
  <math|\<top\>\<vdash\>\<bot\>> for example), which would not have been the
  case with the trivial set of axioms.

  <section|Conclusion>

  We have constructed a game semantics for first-order propositional logic
  and given a presentation of the category<nbsp><math|<Games>> of games and
  definable strategies. This has revealed the essential structure of
  causality induced by quantifiers as well as provided technical tools to
  show definability and composition of strategies.

  We consider this work much more as a starting point to bridge semantics and
  algebra than as a final result. The methodology presented here seems to be
  very general and many tracks remain to be explored.

  First, we would like to extend the presentation to a game semantics for
  richer logic systems, containing connectives (such as conjunction or
  disjunction). Whilst we do not expect essential technical complications,
  this case is much more difficult to grasp and manipulate, since a
  presentation of such a semantics would have generators up to
  dimension<nbsp>3: games would be modeled as trees of connectives and
  strategies as \Psurface diagrams\Q between these trees. It would be
  particularly interesting to do this for the multiplicative fragment of
  linear logic (MLL) with first-order quantifiers since it would provide us
  with a local reformulation of the Danos-Regnier criterion for MLL extended
  with the MIX rule (this is hinted in Remark<nbsp><reference|rem:ll-acyclicity>).

  Some of the proofs (such as the proof of
  Lemma<nbsp><reference|lemma:mrel-precan>) are very repetitive, which we
  think is a good point: we believe that they could be mechanically checked
  or automated. It turns out that it is quite difficult to find a good
  representation of morphisms in monoidal categories, which is suitable for a
  computer to manipulate them without having to handle complex congruences
  such as the exchange law. We have proposed such a representation as well as
  an unification algorithm for monoidal rewriting
  systems<nbsp><cite|mimram:rta10>, but many properties and generalizations
  of these techniques remain to be investigated in order to have really
  useful tools. Formulated in categorical terms this amounts to generalize
  term rewriting techniques from Lawvere theories (which are categories with
  products, thus monoidal categories, thus 2-categories with one object) to
  the general setting of 2-categories. In particular, it would also be
  interesting to know whether it is possible to orient the equalities in the
  presentations in order to obtain strongly normalizing rewriting systems for
  the algebraic structures described in the paper. Such rewriting systems are
  given in<nbsp><cite|lafont:boolean-circuits>, for monoids and commutative
  monoids, etc., but for example finding a strongly normalizing rewriting
  system presenting the theory of bialgebras is a difficult
  problem<nbsp><cite|mimram:phd>, not to mention a strongly normalizing
  presentation of our category of games. Such a presentation would have a
  very high number of critical pairs which makes us see the development of
  automated tools to compute them a necessary preliminary step.

  Finally, there is a striking analogy between the string diagrams we have
  used and wires in electronic circuits. This is actually one of the starting
  point of the current work of Ghica (as well as game semantics), who is
  currently elaborating a compiler from a high-level language into integrated
  circuits<nbsp><cite|ghica:geometry-synthesis>. The categorical
  string-diagrammatic axioms reveal to be crucial in this setting in order to
  establish designing principles for the circuits. Following this point of
  view, we believe that a deep understanding of the algebraic structure of
  categories of semantics of programming languages will prove very useful in
  order to design and optimize circuits implementing programs in these
  languages.

  <paragraph|Acknowledgments.> I would like to thank Martin Hyland and
  Paul-Andr Mellis, as well as John Baez, Albert Burroni, Jonas Frey, Yves
  Guiraud, Yves Lafont, Franois Mtayer and Luke Ong, for the lively
  discussion we had, during which I learned so much; I also thank the
  anonymous referee for valuable suggestions.

  <\bibliography|bib|alpha|these>
    <bib-list|[99]|>
  </bibliography>
</body>