<TeXmacs|1.99.7>

<style|<tuple|ieeetran|std-latex>>

<\body>
  <\hide-preamble>
    <assign|BibTeX|<macro|<with|font-family|rm|B<kern>-.05em<with|font-shape|small-caps|i<kern>-.025em
    b><kern>-.08em T<kern>-.1667em<lower>.7exE<kern>-.125emX>>>

    <new-theorem|theorem|Theorem>
  </hide-preamble>

  <doc-data|<doc-title|Source Optimization in MISO Relaying<next-line>with
  Channel Mean Feedback:<next-line>A Stochastic Ordering
  Approach>|<doc-author|<author-data|<author-name|Minhua Ding,
  <with|font-shape|italic|Member, IEEE>, and Q. T. Zhang,
  <with|font-shape|italic|Fellow, IEEE><next-line>Department of Electronic
  Engineering, City University of Hong Kong<next-line>Email:
  minhua.ding@ieee.org, eekzhang@cityu.edu.hk>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    This paper investigates the optimum source transmission strategy to
    maximize the capacity of a multiple-input single-output (MISO)
    amplify-and-forward relay channel, assuming source-relay channel mean
    feedback at the source. The challenge here is that relaying introduces a
    nonconvex structure in the objective function, thereby excluding the
    possible use of previous methods dealing with mean feedback that
    generally rely on the concavity of the objective function. A novel method
    is employed, which divides the feasible set into two subsets and
    establishes the optimum from one of them by comparison. As such, the
    optimization is transformed into the comparison of two nonnegative random
    variables in the <with|font-shape|italic|Laplace transform order>, which
    is one of the important stochastic orders. It turns out that the optimum
    transmission strategy is to transmit along the known channel mean and its
    orthogonal eigenchannels. The condition for rank-one precoding
    (beamforming) to achieve capacity is also determined. Our results subsume
    those for traditional MISO precoding with mean feedback.
  </abstract>>

  <section|Introduction><label|intro>

  Wireless relay systems have been a recent subject of intensive research due
  to their potential of providing increased diversity, extended coverage, or
  flexibility in compromising system performance and complexity/power
  consumption. Efficient relaying protocols have been developed, among which
  the most popular are the amplify-and-forward (AF) and decode-and-forward
  protocols<nbsp><cite|Laneman_1>.

  To further enhance system performance, multiple antennas are deployed on
  one or more nodes of cooperative relay networks<nbsp><cite|Nabar_performance>-<cite|Dharmawansa_McKay_journal>.
  However, in multi-antenna systems, the optimum system structure and the
  resultant performance (capacity, error rate, mean-square error, etc.)
  depend heavily on the nature of channels and the channel state information
  (CSI) available at the transceiver (see<nbsp><cite|MIMO_capacity_goldsmith>-<cite|mding_sdb_T_IT_2010_to_appear>
  and references therein). Therefore, research on multi-antenna relay
  communications has progressed from early work assuming perfect
  CSI<nbsp><cite|tang_hua_perfect_CSI><cite|medina_Olga> to recent studies
  assuming more realistic partial CSI<nbsp><cite|Prathapa_ICC>.

  Consider a <with|font-shape|italic|half-duplex> AF relay link with <math|M>
  antennas (<math|M\<geq\>2>) at the source and a single antenna at both the
  relay and the destination. This scenario typically occurs when a
  traditional multiple-input single-output (MISO) link (without relaying) is
  obstructed, and then a relay is used to maintain the link and coverage. We
  assume that the destination has full knowledge of the source-relay and
  relay-destination channels, whereas the relay and the source are only aware
  of the long-term statistics of the source-relay channel. Relaying without
  instantaneous CSI is commonly referred to as
  <with|font-shape|italic|noncoherent relaying>.

  The above scenario has been considered in<nbsp><cite|Prathapa_ICC>, where
  the source and the relay are assumed to have the long-term
  <with|font-shape|italic|covariance information> of a rapidly changing
  source-relay channel, and the optimum source covariance to maximize the
  ergodic capacity is determined. However, when the
  <with|font-shape|italic|mean information><footnote|Channel covariance
  (mean) information at the transmitter is also referred to as channel
  covariance (mean) feedback<nbsp><cite|MIMO_capacity_goldsmith>.> of a
  slowly varying source-relay channel is available at the source, the
  capacity-achieving transmission strategy remains as an open problem and is
  tackled in this work. Mean feedback models the uncertainty in CSI due to
  channel estimation errors, quantization errors or imperfectness of the
  feedback link, and is feasible in slowly varying fading
  channels<nbsp><cite|Zhou_Giannakis_CMF>.

  Channel mean and covariance feedback generally require different
  treatments, as they constrain the solution differently. Regarding utilizing
  mean feedback for maximum ergodic capacity in traditional MISO, the
  optimization method in<nbsp><cite|Visotsky_madhow><nbsp><cite|Jafar_Goldsmith>
  is based on calculus of variations using the Frchet differential, whereas
  in<nbsp><cite|ALMoustakas>, the expression for ergodic capacity is first
  obtained and then ordinary calculus is used for optimization. Both methods
  rely on the concavity of the objective function in transmit
  covariance<nbsp><cite|Visotsky_madhow>-<cite|ALMoustakas>. However, such
  concavity cannot be established in our case, and these methods do not
  apply.

  We, therefore, take a nonconventional powerful approach based on one of the
  stochastic orders, the <with|font-shape|italic|Laplace transform
  order><nbsp><cite|Shaked_Shanth>, which circumvents the requirement of
  concavity. Optimum source precoding matrix (or equivalently, the covariance
  matrix) is determined. A special case of precoding, i.e., beamforming,
  occurs when the covariance matrix is of rank one, which has appealing
  reduced complexity but may not always be capacity-optimum. Here we derive
  the necessary and sufficient condition for it to achieve capacity. All our
  results subsume as a special case those for traditional MISO precoding with
  channel mean feedback.

  <section|System model and problem statement><label|sec>

  We focus on a half-duplex AF link with <math|M> antennas at the source and
  with a single antenna at both the relay and the destination,<footnote|The
  analysis in this paper can be extended to the case when the relay has
  multiple antennas. Details are not discussed due to space constraint.>
  resulting in a MISO source-relay link (backward channel) and a single-input
  single-output relay-destination link (forward channel). No direct
  source-destination link exists. The backward channel
  <math|<math-bf|h><rsub|B>> is modeled as<nbsp><cite|Visotsky_madhow>:

  <align|<tformat|<table|<row|<cell|<math-bf|h><rsub|B>=\<b-mu\>+<sqrt|\<alpha\>><math-bf|h><rsub|w>,<label|backward>>>>>>

  where <math|<math-bf|h><rsub|w>> represents the scattering and is
  distributed as <math|\<cal-N\><rsub|c><around|(|0,<math-bf|I><rsub|M>|)>>
  (circularly symmetric complex Gaussian), and <math|\<alpha\>> is a
  nonnegative scaling constant (<math|\<alpha\>\<geq\>0>). Only the knowledge
  of the source-relay channel mean <math|\<b-mu\>> and <math|\<alpha\>> is
  provided to the source, which we refer to as
  <with|font-shape|italic|channel mean feedback> (at the source). In the
  first time slot, the received signal in the source-relay link is given by

  <align|<tformat|<table|<row|<cell|<no-number>*r<rsub|1>=<math-bf|h><rsub|B><rsup|\<dagger\>><math-bf|Fx>+n<rsub|1>,>>>>>

  where <math|<math-bf|x>> is the source signal with
  <math|\<bbb-E\><around|{|<math-bf|xx><rsup|\<dagger\>>|}>=<frac|\<gamma\>|M><math-bf|I><rsub|M>>
  and <math|n<rsub|1>> is the noise at the relay distributed as
  <math|\<cal-N\><rsub|c><around|(|0,1|)>>. The precoding (shaping) matrix
  <math|<math-bf|F>> is related to the transmit covariance matrix
  <math|<math-bf|Q>> through <math|<math-bf|Q>\<triangleq\><frac|1|M><math-bf|FF><rsup|\<dagger\>>>.
  A transmit power constraint is imposed on the source:
  <math|\<bbb-E\><around|{|<text|tr><around|(|<math-bf|Fx><around|(|<math-bf|Fx>|)><rsup|\<dagger\>>|)>|}>=\<gamma\><text|tr><around|(|<math-bf|Q>|)>\<leq\>\<gamma\>>,
  which yields the constraint on the transmit covariance matrix:
  tr<math|<around|(|<math-bf|Q>|)>\<leq\>1>. Denote the amplifying factor of
  the relay as <math|\<eta\>>. Due to noncoherent relaying, a long-term power
  constraint, <math|G>, is imposed on the relay, i.e.,

  <align|<tformat|<table|<row|<cell|G=\<bbb-E\><around|{|<around|\||\<eta\>*r<rsub|1>|\|><rsup|2>|}>=\<eta\><rsup|2>*<around|[|\<gamma\>*\<b-mu\><rsup|\<dagger\>><math-bf|Q>\<b-mu\>+\<gamma\>*\<alpha\><text|tr><around|(|<math-bf|Q>|)>+1|]>.<label|relay>>>>>>

  Thus, <math|\<eta\>=<sqrt|G/<around*|{|1+\<gamma\>*<around|[|\<b-mu\><rsup|\<dagger\>><math-bf|Q>\<b-mu\>+\<alpha\><text|tr><around|(|<math-bf|Q>|)>|]>|}>>>.
  In (<reference|relay>), we have used: <math|\<bbb-E\><around|{|<math-bf|h><rsub|w><rsup|\<dagger\>><math-bf|Qh><rsub|w>|}>=<text|tr><around|(|<math-bf|Q>|)>>,
  since <math|<math-bf|h><rsub|w>> is <math|\<cal-N\><rsub|c><around|(|0,<math-bf|I><rsub|M>|)>>.
  In the second time slot, the received signal in the relay-destination link
  is given by

  <align|<tformat|<table|<row|<cell|<no-number>*r<rsub|2>=\<eta\>*<space|0.27em>h<rsub|F>*<space|0.27em>r<rsub|1>+n<rsub|2>,>>>>>

  where <math|h<rsub|F>> is the forward channel coefficient, and
  <math|n<rsub|2>> is the noise at the destination with distribution
  <math|\<cal-N\><rsub|c><around|(|0,1|)>>.

  Perfect knowledge of <math|<math-bf|h><rsub|B>> and <math|h<rsub|F>> is
  assumed at the destination. No knowledge about <math|h<rsub|F>> is
  available at the source or relay. The ergodic capacity of the above relay
  channel is given below<nbsp><cite|Prathapa_ICC>

  <align|<tformat|<table|<row|<cell|max<rsub|<stack|<tformat|<table|<row|<cell|<math-bf|Q>\<succeq\>0>>|<row|<cell|<text|tr><around|(|<math-bf|Q>|)>\<leq\>1>>>>>>
  <frac|1|2>*\<bbb-E\><rsub|<math-bf|h><rsub|B>,<space|0.27em>h<rsub|F>><around*|{|log
  <around*|[|1+<frac|\<eta\><rsup|2>*\<gamma\><around|\||h<rsub|F>|\|><rsup|2><math-bf|h><rsub|B><rsup|\<dag\>><math-bf|Qh><rsub|B>|\<eta\><rsup|2><around|\||h<rsub|F>|\|><rsup|2>+1>|]>|}>,<label|capacity>>>>>>

  where <math|<frac|1|2>> is due to the half-duplex assumption. The
  <math|log> function here denotes natural logarithm, and thus the unit is
  nats per channel use. After substituting <math|\<eta\>> into
  (<reference|capacity>) and applying a technique used
  in<nbsp><cite-detail|ding_Blostein_PIMRC09|Appendix A>, the ergodic
  capacity <with|font-shape|italic|under mean feedback> can be further shown
  equivalent to:

  <align|<tformat|<table|<row|<cell|>|<cell|max<rsub|<math-bf|Q>\<succeq\>0,<space|0.27em><text|tr><around|(|<math-bf|Q>|)>=1><text|C><around|(|<math-bf|Q>|)><label|cmf>>>>>>

  where

  <align|<tformat|<table|<row|<cell|<text|C><around|(|<math-bf|Q>|)>=<frac|1|2>*\<bbb-E\><rsub|<math-bf|h><rsub|B>,<space|0.27em>h<rsub|F>><around*|{|log
  <around*|[|1+<frac|G<around|\||h<rsub|F>|\|><rsup|2><math-bf|h><rsub|B><rsup|\<dagger\>><math-bf|Qh><rsub|B>|\<b-mu\><rsup|\<dagger\>><math-bf|Q>\<b-mu\>+\<alpha\>+<frac|G<around|\||h<rsub|F>|\|><rsup|2>+1|\<gamma\>>>|]>|}>.<label|C>>>>>>

  Our goal is to find the optimum <math|<math-bf|Q>> for the problem defined
  by (<reference|cmf>)-(<reference|C>). The main challenge here is that in
  (<reference|C>), the <math|log> function inside the expectation operator is
  nonconvex in <math|<math-bf|Q>>. Previous methods for MISO precoding with
  channel mean feedback<nbsp><cite|Visotsky_madhow>-<cite|ALMoustakas>, which
  generally utilize the concavity of the objective function in the transmit
  covariance matrix, are not applicable here. Below we employ a new method
  based on the Laplace transform order<nbsp><cite|Shaked_Shanth>. Some
  mathematical preliminaries pertaining to the Laplace transform order are
  given in Appendix I.

  <section|Optimum Source Covariance Matrix>

  <nbsp><label|solution> <with|font-shape|italic|Theorem 1>
  <space|0.27em><space|0.27em> The optimum <math|<math-bf|Q>> for the problem
  (<reference|cmf>) is given by <math|<math-bf|Q><rsub|o*p*t>=<math-bf|V>\<b-Phi\><math-bf|V><rsup|\<dagger\>>>,
  where

  <align|<tformat|<table|<row|<cell|<math-bf|V>=>|<cell|<space|0.27em><around*|[|\<b-mu\>/<around|\<\|\|\>|\<b-mu\>|\<\|\|\>><space|2mm><math-bf|v><rsub|2><space|0.27em>\<ldots\><space|0.27em><math-bf|v><rsub|M>|]>,<label|cmf>>>|<row|<cell|\<b-Phi\>=>|<cell|<space|0.27em><text|diag><around*|{|\<phi\>,<frac|1-\<phi\>|M-1>,\<ldots\>,<frac|1-\<phi\>|M-1>|}>,<label|cmf>>>>>>

  and <math|<math-bf|v><rsub|2>\<ldots\><math-bf|v><rsub|M>> are arbitrary
  orthonormal vectors orthogonal to <math|\<b-mu\>> in
  <math|\<bbb-C\><rsup|M>>.

  <with|font-shape|italic|Proof>: Due to space constraint, we only provide a
  detailed outline here. A complete proof can be found
  in<nbsp><cite|mding_kzhang>.

  To ease the presentation, we first sketch the basic idea. A globally
  optimum <math|<math-bf|Q>> exists for (<reference|cmf>) due to the
  Weierstrass' Theorem<nbsp><cite|Chong>. We divide the feasible set into two
  subsets, represented by <math|<math-bf|Q><rsub|1>> and
  <math|<math-bf|Q><rsub|2>>. Specifically, denote as
  <math|<math-bf|Q><rsub|1>> a feasible but otherwise arbitrary covariance
  matrix, which has <with|font-shape|italic|none> of its eigenvectors aligned
  with <math|\<b-mu\>>. Let <math|<math-bf|Q><rsub|2>> have the same
  eigenvectors as <math|<math-bf|Q><rsub|o*p*t>> [see (<reference|cmf>)].
  Here <math|<math-bf|Q><rsub|2>> is customized for the proof. Our goal is to
  show that given any <math|<math-bf|Q><rsub|1>>, by proper power allocation
  in <math|<math-bf|Q><rsub|2>>, we can always have
  C<math|<around|(|<math-bf|Q><rsub|2>|)>\<geq\><text|C><around|(|<math-bf|Q><rsub|1>|)>>.
  We will show that to maximize C<math|<around|(|<math-bf|Q><rsub|2>|)>>,
  equal power must be allocated to <math|<math-bf|v><rsub|2>\<ldots\><math-bf|v><rsub|M>>
  as in (<reference|cmf>). We will also show that <math|<math-bf|Q><rsub|2>>
  with its optimum power allocation achieves at least the same ergodic
  capacity as <math|<math-bf|Q><rsub|1>> does. The optimality of
  <math|<math-bf|Q><rsub|o*p*t>> can then be established. Below the proof
  starts.

  To facilitate subsequent comparison, our first step is to exploit the
  eigen-structures of covariance matrices. Let <math|<math-bf|Q><rsub|1>> be
  eigen-decomposed as <math|<math-bf|Q><rsub|1>=<math-bf|U>\<b-Lambda\><math-bf|U><rsup|\<dag\>>>
  with

  <align|<tformat|<table|<row|<cell|<math-bf|U>=<around|[|<math-bf|u><rsub|1>\<ldots\><math-bf|u><rsub|M>|]>,\<b-Lambda\>=<text|diag><around|{|\<lambda\><rsub|1>,\<ldots\>,\<lambda\><rsub|M>|}>.<label|sub>>>>>>

  Here <math|<around|{|<math-bf|u><rsub|1>\<ldots\><math-bf|u><rsub|M>|}>> is
  an arbitrary orthonormal basis in <math|\<bbb-C\><rsup|M>>, among which
  none is aligned with <math|\<b-mu\>>, and
  <math|<big|sum><rsub|i=1><rsup|M>\<lambda\><rsub|i>=1>. Let
  <math|<math-bf|Q><rsub|2>> have the same eigenvectors as given in
  (<reference|cmf>), i.e.,

  <align|<tformat|<table|<row|<cell|<math-bf|Q><rsub|2>=<math-bf|V><wide|\<b-Phi\>|^><math-bf|V><rsup|\<dag\>>,<space|0.27em><wide|\<b-Phi\>|^>=<text|diag><around|{|<wide|\<phi\>|^><rsub|1>,<wide|\<phi\>|^><rsub|2>,\<ldots\>,<wide|\<phi\>|^><rsub|M>|}>,<space|0.27em><big|sum><rsub|i=1><rsup|M><wide|\<phi\>|^><rsub|i>=1.<label|Phi>>>>>>

  Also define <math|\<b-beta\>\<triangleq\><around|(|\<beta\><rsub|1>*\<ldots\>*\<beta\><rsub|M>|)><rsup|T>\<triangleq\><math-bf|U><rsup|\<dagger\>>\<b-mu\>>.
  Clearly, <math|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>>=<around|\<\|\|\>|\<b-beta\>|\<\|\|\>>>.
  From (<reference|sub>) and (<reference|backward>), we obtain
  <math|\<b-mu\><rsup|\<dag\>><math-bf|Q><rsub|1>\<b-mu\>=<big|sum><rsub|i=1><rsup|M>\<lambda\><rsub|i><around|\||\<beta\><rsub|i>|\|><rsup|2>>,
  and

  <align|<tformat|<table|<row|<cell|<no-number><math-bf|h><rsub|B><rsup|\<dagger\>><math-bf|Q><rsub|1><math-bf|h><rsub|B>=>|<cell|<space|0.27em><around|[|\<b-beta\>+<sqrt|\<alpha\>><wide|<math-bf|h>|\<breve\>><rsub|w>|]><rsup|\<dagger\>>*\<b-Lambda\>*<around|[|\<b-beta\>+<sqrt|\<alpha\>><wide|<math-bf|h>|\<breve\>><rsub|w>|]>=<space|0.27em>\<alpha\>*W<rsub|Q*1>,>>>>>

  where <math|<wide|<math-bf|h>|\<breve\>><rsub|w>\<triangleq\><around|(|<wide|h|\<breve\>><rsub|w*1>*\<ldots\>*<wide|h|\<breve\>><rsub|w*M>|)><rsup|T>\<triangleq\><math-bf|U><rsup|\<dagger\>><math-bf|h><rsub|w>>
  has the same distribution as <math|<math-bf|h><rsub|w>>,
  <math|<around|\||<wide|h|\<breve\>><rsub|w*i>+<frac|\<beta\><rsub|i>|<sqrt|\<alpha\>>>|\|><rsup|2>>
  is a noncentral chi-square random variable of two degrees of freedom with
  the noncentrality parameter given by <math|<around|\||\<beta\><rsub|i>|\|><rsup|2>/\<alpha\>>,
  for all <math|i><nbsp><cite-detail|Proakis|p. 43>, and
  <math|W<rsub|Q*1>\<triangleq\><big|sum><rsub|i=1><rsup|M>\<lambda\><rsub|i>*<around|\||<wide|h|\<breve\>><rsub|w*i>+<frac|\<beta\><rsub|i>|<sqrt|\<alpha\>>>|\|><rsup|2>>.
  Similarly, <math|\<b-mu\><rsup|\<dagger\>><math-bf|Q><rsub|2>\<b-mu\>=<wide|\<phi\>|^><rsub|1><around|\<\|\|\>|\<b-mu\>|\<\|\|\>><rsup|2>>,
  and

  <align|<tformat|<table|<row|<cell|<no-number>>|<cell|<space|0.27em><math-bf|h><rsub|B><rsup|\<dagger\>><math-bf|Q><rsub|2><math-bf|h><rsub|B>=<space|0.27em><around|[|\<b-mu\>+<sqrt|\<alpha\>><math-bf|h><rsub|w>|]><rsup|\<dagger\>><math-bf|V><wide|\<b-Phi\>|^><math-bf|V><rsup|\<dagger\>><around|[|\<b-mu\>+<sqrt|\<alpha\>><math-bf|h><rsub|w>|]>>>|<row|<cell|<no-number>=>|<cell|<space|0.27em><around|[|<around|(|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>>*<space|0.27em>0*\<ldots\>*0|)>+<sqrt|\<alpha\>><space|0.27em><wide|<math-bf|h>|^><rsub|w><rsup|\<dagger\>>|]>*<space|0.27em><wide|\<b-Phi\>|^>*<space|0.27em><around|[|<around|(|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>>*<space|0.27em>0*\<ldots\>*0|)><rsup|T>+<sqrt|\<alpha\>><space|0.27em><wide|<math-bf|h>|^><rsub|w>|]>>>|<row|<cell|<no-number>=>|<cell|<space|0.27em>\<alpha\>*W<rsub|Q*2>,>>>>>

  where <math|W<rsub|Q*2>\<triangleq\><wide|\<phi\>|^><rsub|1>*<around|\||<wide|h|^><rsub|w*1>+<frac|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>>|<sqrt|\<alpha\>>>|\|><rsup|2>+<big|sum><rsub|i=2><rsup|M><wide|\<phi\>|^><rsub|i><around|\||<wide|h|^><rsub|w*i>|\|><rsup|2>>.
  Here <math|<wide|<math-bf|h>|^><rsub|w>\<triangleq\><around|(|<wide|h|^><rsub|w*1>*\<ldots\>*<wide|h|^><rsub|w*M>|)><rsup|T>\<triangleq\><math-bf|V><rsup|\<dagger\>><math-bf|h><rsub|w>>
  has the same distribution as <math|<math-bf|h><rsub|w>>, and thus
  <math|<around|\||<wide|h|^><rsub|w*i>|\|><rsup|2>> is distributed as
  central chi-square of two degrees of freedom (or simply, exponential),
  <math|i=2,\<ldots\>,M>.

  Now, within the subset represented by <math|<math-bf|Q><rsub|2>>, it can be
  shown that, given any <math|0\<leq\><wide|\<phi\>|^><rsub|1>\<leq\>1>,
  among all <math|<wide|\<b-Phi\>|^>> matrices [see (<reference|Phi>)],

  <align|<tformat|<table|<row|<cell|<wide|\<b-Phi\>|^><rsup|\<ast\>>=<text|diag><around|{|<wide|\<phi\>|^><rsub|1>,<frac|1-<wide|\<phi\>|^><rsub|1>|M-1>,\<ldots\>,<frac|1-<wide|\<phi\>|^><rsub|1>|M-1>|}><label|opt>>>>>>

  maximizes C<math|<around|(|<math-bf|Q><rsub|2>|)>>; i.e., to maximize
  C<math|<around|(|<math-bf|Q><rsub|2>|)>>, equal power
  <math|<frac|1-<wide|\<phi\>|^><rsub|1>|M-1>> must be allocated to
  <math|<math-bf|v><rsub|2>\<ldots\><math-bf|v><rsub|M>><nbsp><cite|mding_kzhang>.
  Thus, we denote

  <align|<tformat|<table|<row|<cell|<wide|W|^><rsub|Q*2>\<triangleq\><wide|\<phi\>|^><rsub|1>*<around*|\||<wide|h|^><rsub|w*1>+<frac|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>>|<sqrt|\<alpha\>>>|\|><rsup|2>+<frac|1-<wide|\<phi\>|^><rsub|1>|M-1>*<big|sum><rsub|i=2><rsup|M><around|\||<wide|h|^><rsub|w*i>|\|><rsup|2>.<label|S>>>>>>

  Up to now, we have

  <align|<tformat|<table|<row|<cell|<text|C><around|(|<math-bf|Q><rsub|1>|)>=>|<cell|<space|0.27em><frac|1|2>*\<bbb-E\><rsub|<math-bf|h><rsub|B>,h<rsub|F>><around|{|log
  <around|[|1+k<rsub|1>*W<rsub|Q*1>|]>|}>,<label|C>>>|<row|<cell|<text|C><around|(|<math-bf|Q><rsub|2>|)>=>|<cell|<space|0.27em><frac|1|2>*\<bbb-E\><rsub|<math-bf|h><rsub|B>,h<rsub|F>><around|{|log
  <around|[|1+k<rsub|2>*<wide|W|^><rsub|Q*2>|]>|}>,<label|C>>>>>>

  where optimum equal power allocation among
  <math|<math-bf|v><rsub|2>\<ldots\><math-bf|v><rsub|M>> is used in
  <math|<math-bf|Q><rsub|2>>,

  <align|<tformat|<table|<row|<cell|k<rsub|1>=>|<cell|<frac|G<around|\||h<rsub|F>|\|><rsup|2>*\<alpha\>|<big|sum><rsub|i=1><rsup|M>\<lambda\><rsub|i><around|\||\<beta\><rsub|i>|\|><rsup|2>+\<alpha\>+<frac|1+G<around|\||h<rsub|F>|\|><rsup|2>|\<gamma\>>>,<label|k1>>>|<row|<cell|k<rsub|2>=>|<cell|<frac|G<around|\||h<rsub|F>|\|><rsup|2>*\<alpha\>|<wide|\<phi\>|^><rsub|1><around|\<\|\|\>|\<b-mu\>|\<\|\|\>><rsup|2>+\<alpha\>+<frac|1+G<around|\||h<rsub|F>|\|><rsup|2>|\<gamma\>>>.<label|k2>>>>>>

  Note that (<reference|C>) and (<reference|C>) differ not only in
  <math|W<rsub|Q*1>> and <math|<wide|W|^><rsub|Q*2>>, but also in
  <math|k<rsub|1>> and <math|k<rsub|2>>, making further comparison
  prohibitively difficult. To proceed, we choose the only free (unspecified)
  parameter in <math|<math-bf|Q><rsub|2>>, i.e.,
  <math|<wide|\<phi\>|^><rsub|1>>, as follows:

  <align|<tformat|<table|<row|<cell|<wide|\<phi\>|^><rsub|1>=<frac|\<b-mu\><rsup|\<dag\>><math-bf|Q><rsub|1>\<b-mu\>|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>><rsup|2>>=<frac|<big|sum><rsub|i=1><rsup|M>\<lambda\><rsub|i><around|\||\<beta\><rsub|i>|\|><rsup|2>|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>><rsup|2>>=<frac|<big|sum><rsub|i=1><rsup|M>\<lambda\><rsub|i><around|\||\<beta\><rsub|i>|\|><rsup|2>|<around|\<\|\|\>|\<b-beta\>|\<\|\|\>><rsup|2>>,<label|beta>>>>>>

  such that <math|k<rsub|1>=k<rsub|2>=k\<gtr\>0> in (<reference|k1>) and
  (<reference|k2>). Since <math|0\<leq\>min<rsub|i>
  \<lambda\><rsub|i>\<leq\><frac|\<b-mu\><rsup|\<dag\>><math-bf|Q><rsub|1>\<b-mu\>|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>><rsup|2>>\<leq\>max<rsub|i>
  \<lambda\><rsub|i>\<leq\>1>, (<reference|beta>) is always valid. The choice
  of <math|<wide|\<phi\>|^><rsub|1>> in (<reference|beta>) is crucial and
  will be shown to enable the final comparison. Naturally, our next step is
  to show that

  <align|<tformat|<table|<row|<cell|>|<cell|<space|0.27em>\<bbb-E\><rsub|W<rsub|Q*1>><around|{|log
  <around|(|1+k*W<rsub|Q*1>|)>|}>\<leq\>\<bbb-E\><rsub|<wide|W|^><rsub|Q*2>><around|{|log
  <around|(|1+k*<wide|W|^><rsub|Q*2>|)>|}>,<label|equi>>>>>>

  when <math|h<rsub|F>> is given and <math|<wide|\<phi\>|^><rsub|1>> is
  chosen as per (<reference|beta>).

  A straightforward method to show the above is to calculate the expectations
  on both sides of the inequality. The difficulty here is that the
  calculation involves the probability density function (p.d.f.) of a convex
  combination of <math|M> non-central chi-square random variables, which is
  too complicated to serve our purpose<nbsp><cite|chi_square_convex_combinations>.
  On the other hand, the Laplace transform of this p.d.f. does possess a more
  elegant structure<nbsp><cite|Proakis>. If we can avoid the p.d.f. and use
  its Laplace transform instead, we will be able to overcome the difficulty.
  It turns out that <with|font-shape|italic|Lemma 1> in Appendix I is the
  precise tool we need here.

  Based on <with|font-shape|italic|Lemma 1>, to show (<reference|equi>), it
  suffices to show that

  <\equation*>
    W<rsub|Q*1>\<leq\><rsub|LT><wide|W|^><rsub|Q*2>,<space|0.27em><text|subject
    to><space|0.27em><around|(|<reference|beta>|)>.
  </equation*>

  Let <math|\<cal-M\><rsub|W<rsub|Q*1>><around|(|s|)>>
  [<math|\<cal-M\><rsub|<wide|W|^><rsub|Q*2>><around|(|s|)>>] be the Laplace
  transform of the p.d.f. of <math|W<rsub|Q*1>>
  (<math|<wide|W|^><rsub|Q*2>>). According to
  <with|font-shape|italic|Definition 1> (see Appendix I), it is equivalent to
  show that <math|\<cal-M\><rsub|<wide|W|^><rsub|Q*2>><around|(|s|)>\<leq\>\<cal-M\><rsub|W<rsub|Q*1>><around|(|s|)>,\<forall\>s\<gtr\>0,<text|subject
  to><space|0.27em><around|(|<reference|beta>|)>>, or,

  <align|<tformat|<table|<row|<cell|log <space|0.27em><around|[|\<cal-M\><rsub|<wide|W|^><rsub|Q*2>><around|(|s|)>/\<cal-M\><rsub|W<rsub|Q*1>><around|(|s|)>|]>\<leq\>0,<space|0.27em>\<forall\>s\<gtr\>0,<space|0.27em><text|under><space|0.27em><around|(|<reference|beta>|)>.<label|temp>>>>>>

  It can be shown that<nbsp><cite-detail|Proakis|p. 43>

  <align|<tformat|<table|<row|<cell|<no-number>>|<cell|<space|0.27em>log
  <around*|[|\<cal-M\><rsub|<wide|W|^><rsub|Q*2>><around|(|s|)>/\<cal-M\><rsub|W<rsub|Q*1>><around|(|s|)>|]>=\<cal-J\><around|(|s|)>-<frac|s|\<alpha\>>*\<cal-R\><around|(|s|)>,>>|<row|<cell|>|<cell|<space|0.27em>\<cal-J\><around|(|s|)>=log
  <around*|[|<frac|<around|(|1+\<lambda\><rsub|1>*s|)>*\<ldots\>*<around|(|1+\<lambda\><rsub|M>*s|)>|<around|(|1+<wide|\<phi\>|^><rsub|1>*s|)>*<around*|(|1+<frac|1-<wide|\<phi\>|^><rsub|1>|M-1>*s|)><rsup|M-1>>|]><label|J>>>|<row|<cell|>|<cell|<space|0.27em>\<cal-R\><around|(|s|)>=<frac|<wide|\<phi\>|^><rsub|1><around|\<\|\|\>|\<b-mu\>|\<\|\|\>><rsup|2>|1+<wide|\<phi\>|^><rsub|1>*s>-<big|sum><rsub|i=1><rsup|M><frac|\<lambda\><rsub|i><around|\||\<beta\><rsub|i>|\|><rsup|2>|1+\<lambda\><rsub|i>*s>.<label|R>>>>>>

  To show that <math|\<cal-J\><around|(|s|)>\<leq\>0> for all
  <math|s\<gtr\>0>, note that <math|<big|sum><rsub|i=1><rsup|M>log
  <around|(|1+t<rsub|i>*s|)>> is a Schur-concave function in
  <math|<math-bf|t>=<around|(|t<rsub|1>*\<ldots\>*t<rsub|M>|)><rsup|T>>, for
  all <math|s\<gtr\>0>, and subject to (<reference|beta>),

  <\equation*>
    <around*|(|<wide|\<phi\>|^><rsub|1>*<space|0.27em><frac|1-<wide|\<phi\>|^><rsub|1>|M-1>*\<ldots\>*<frac|1-<wide|\<phi\>|^><rsub|1>|M-1>|)>\<prec\><around*|(|\<lambda\><rsub|1>*\<ldots\>*\<lambda\><rsub|M>|)>,
  </equation*>

  i.e., the left-hand side is majorized by the right-hand
  side<nbsp><cite|mding_kzhang><cite|Marshall_Olkin>. We can also show that
  <math|\<cal-R\><around|(|s|)>\<geq\>0>, <math|\<forall\>s\<gtr\>0>, by
  repeatedly using (<reference|beta>). Thus, (<reference|temp>) holds, which
  implies that (<reference|equi>) holds. Since the construction of
  <math|<math-bf|Q><rsub|2>> involves only (<reference|cmf>),
  (<reference|opt>) and (<reference|beta>), none of which depends on
  <math|h<rsub|F>>, and (<reference|equi>) holds for any <math|h<rsub|F>>, we
  obtain

  <align|<tformat|<table|<row|<cell|<no-number><text|C><around|(|<math-bf|Q><rsub|1>|)>=>|<cell|<space|0.27em><frac|1|2>*\<bbb-E\><rsub|h<rsub|F>><around*|{|\<bbb-E\><rsub|W<rsub|Q*1>><around|{|log
  <around|(|1+k*W<rsub|Q*1>|)>|}>|}>>>|<row|<cell|\<leq\>>|<cell|<space|0.27em><frac|1|2>*\<bbb-E\><rsub|h<rsub|F>><around*|{|\<bbb-E\><rsub|<wide|W|^><rsub|Q*2>><around|{|log
  <around|(|1+k*<wide|W|^><rsub|Q*2>|)>|}>|}>=<text|C><around|(|<math-bf|Q><rsub|2>|)>.<label|final>>>>>>

  Based on the arbitrariness of <math|<math-bf|Q><rsub|1>> and
  <math|<around|(|<math-bf|v><rsub|2>\<ldots\><math-bf|v><rsub|M>|)>>, we
  conclude that the optimum solution, as it exists, must have the same
  eigen-structure as <math|<math-bf|Q><rsub|2>>. Also, as seen in the proof,
  equal power allocation among <math|<math-bf|v><rsub|2>\<ldots\><math-bf|v><rsub|M>>
  is necessary for optimality. At this moment, the only parameter in
  <math|<math-bf|Q><rsub|2>> available for further optimization is
  <math|<wide|\<phi\>|^><rsub|1>>. Though <math|<wide|\<phi\>|^><rsub|1>>
  chosen as in (<reference|beta>) is sufficient to guarantee
  (<reference|final>) for a specific <math|<math-bf|Q><rsub|1>>, it can be
  potentially further optimized to obtain <math|\<phi\>> as in
  <math|<math-bf|Q><rsub|o*p*t>>. Therefore, for (<reference|cmf>),
  <math|<math-bf|Q><rsub|o*p*t>> [see<nbsp>(<reference|cmf>)-(<reference|cmf>)]
  is the optimum with <math|\<phi\>> numerically optimized according to the
  fading statistics of <math|<math-bf|h><rsub|B>> and <math|h<rsub|F>>.
  <math|\<Box\>>

  <vspace|1mm><with|font-shape|italic|Remark 1> <space|0.27em><space|0.27em>
  The fading distribution of the relay-destination channel <math|h<rsub|F>>
  has no effect on the optimum transmit directions (eigenvectors of the
  covariance matrix) at the source. However, it does affect the optimum value
  of <math|\<phi\>>. In fact, <math|\<phi\>> is determined by solving:
  <math|max<rsub|0\<leq\>\<phi\>\<leq\>1> <frac|1|2>*\<bbb-E\><around|{|log
  <around|[|1+G<around|\||h<rsub|F>|\|><rsup|2>*\<alpha\>*<wide|c|~><around|(|\<phi\>|)>|]>|}>>,
  where

  <\equation*>
    <wide|c|~><around|(|\<phi\>|)>=<frac|\<phi\>*<around|\||<wide|h|^><rsub|w*1>+<frac|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>>|\<alpha\>>|\|><rsup|2>+<frac|1-\<phi\>|M-1>*<big|sum><rsub|i=2><rsup|M><around|\||<wide|h|^><rsub|w*i>|\|><rsup|2>|\<phi\><around|\<\|\|\>|\<b-mu\>|\<\|\|\>><rsup|2>+\<alpha\>+<frac|1+G<around|\||h<rsub|F>|\|><rsup|2>|\<gamma\>>>.
  </equation*>

  This problem can be readily solved using one-dimensional search
  methods<nbsp><cite|Chong>. It is also interesting to see that the capacity
  depends on <math|\<b-mu\>> only through its Euclidean length
  <math|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>>>.

  <with|font-shape|italic|Remark 2> <space|0.27em><space|0.27em> When the
  relay power <math|G\<rightarrow\>\<infty\>>, (<reference|cmf>) becomes:
  <math|max<rsub|<math-bf|Q>\<succeq\>0,<space|0.27em><text|tr><around|(|<math-bf|Q>|)>=1>
  <frac|1|2>*\<bbb-E\><rsub|<math-bf|h><rsub|B>><around|{|log
  <around|[|1+\<gamma\><math-bf|h><rsub|B><rsup|\<dag\>><math-bf|Qh><rsub|B>|]>|}>>,
  which is the same mathematical problem as
  in<nbsp><cite-detail|Visotsky_madhow|Theorem 3.1>. Thus, our result
  subsumes as a special case the optimum (traditional) MISO precoding with
  channel mean feedback, and it is not surprising to see the result in
  <with|font-shape|italic|Theorem 1> and that
  in<nbsp><cite-detail|Visotsky_madhow|Theorem 3.1> share the same
  structure.<footnote|Similar observations have also been reported
  in<nbsp><cite|Prathapa_ICC> with channel covariance feedback.> In
  particular, our proof here can also serve to
  prove<nbsp><cite-detail|Visotsky_madhow|Theorem 3.1>.

  <section|Optimality of Beamforming along <math|\<b-mu\>>>

  Beamforming along the source-relay channel mean <math|\<b-mu\>> is optimum
  if and only if all the source transmit power is allocated to
  <math|\<b-mu\>/<around|\<\|\|\>|\<b-mu\>|\<\|\|\>>>, and thus
  <math|\<phi\>=1> and <math|<math-bf|Q><rsub|o*p*t>> is rank-one.

  <with|font-shape|italic|Theorem 2> <space|0.27em><space|0.27em> Assume that
  <math|h<rsub|F>> is distributed as <math|\<cal-N\><rsub|c><around|(|0,1|)>>.<footnote|Note
  that the result in <with|font-shape|italic|Theorem 1> holds with any fading
  distribution of <math|h<rsub|F>>. However, the condition for beamforming to
  be optimum does depend on the distribution of <math|h<rsub|F>>.> Given
  <math|\<gamma\>>, <math|G>, <math|\<b-mu\>> and <math|\<alpha\>>,
  beamforming in the direction of <math|\<b-mu\>> can achieve capacity if and
  only if

  <align|<tformat|<table|<row|<cell|<no-number>*\<bbb-E\><around|{|Z|}>+>|<cell|<frac|1|G>*\<bbb-E\>*<around|{|Z*exp
  <around|(|Z|)>*\<Gamma\><around|(|0,Z|)>|}>>>|<row|<cell|>|<cell|<space|15mm>\<leq\>\<bbb-E\>*<around|{|Z<rsup|2>*exp
  <around|(|Z|)>*\<Gamma\><around|(|0,Z|)>|}>+D<rsub|2>,<label|BF>>>>>>

  where the expectation is taken with respect to the random variable <math|Z>
  with the following probability density function

  <align|<tformat|<table|<row|<cell|<no-number>*p<rsub|Z><around|(|z|)>=>|<cell|<frac|D<rsub|1>|\<alpha\>*\<gamma\>*z<rsup|2>>*exp
  <around*|{|-<around*|[|<frac|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>><rsup|2>|\<alpha\>>+<frac|1|\<alpha\>*\<gamma\>>*<around*|(|<frac|D<rsub|1>|z>-1|)>|]>|}>>>|<row|<cell|<no-number>\<times\>I<rsub|0>>|<cell|<around*|(|<around|(|2<around|\<\|\|\>|\<b-mu\>|\<\|\|\>><sqrt|<around|(|D<rsub|1>/z|)>-1>|)>/<around|(|\<alpha\>*<sqrt|\<gamma\>>|)>|)>;<space|3mm>0\<less\>z\<leq\>D<rsub|1>.>>>>>

  In the above, we have defined <math|D<rsub|1>\<triangleq\><around|(|\<alpha\>*\<gamma\>+1+\<gamma\><around|\<\|\|\>|\<b-mu\>|\<\|\|\>><rsup|2>|)>/G>
  and <math|D<rsub|2>\<triangleq\><frac|D<rsub|1>|\<alpha\>*\<gamma\>+1>*<around*|[|1-<frac|\<gamma\><around|\<\|\|\>|\<b-mu\>|\<\|\|\>><rsup|2>|G>*exp
  <around|(|D<rsub|1>|)>*\<Gamma\><around*|(|0,D<rsub|1>|)>|]>>,
  <math|\<Gamma\><around|(|a,x|)>> is the complementary incomplete Gamma
  function<nbsp><cite-detail|integration_book|Eqs. (6.5.3), (6.5.15)>, and
  <math|I<rsub|0><around|(|x|)>> is the zeroth-order modified Bessel function
  of the first kind<nbsp><cite-detail|integration_book|Eqs. (9.6.10),
  (9.6.16)>.

  <with|font-shape|italic|Proof>: Due to space limitation, the proof is
  omitted. Numerical methods are required to evaluate
  <math|\<bbb-E\><around|{|Z|}>>, <math|\<bbb-E\>*<around|{|Z*exp
  <around|{|Z|}>*\<Gamma\><around|(|0,Z|)>|}>> and
  <math|\<bbb-E\>*<around|{|Z<rsup|2>*exp
  <around|{|Z|}>*\<Gamma\><around|(|0,Z|)>|}>>. <math|\<Box\>>

  <with|font-shape|italic|Remark 3> <space|0.27em><space|0.27em> When
  <math|G\<rightarrow\>\<infty\>>, (<reference|BF>) coincides
  with<nbsp><cite-detail|Jafar_Goldsmith|Theorem 4, <math|n<rsub|R>=1>>.

  <section|Numerical Examples>

  <nbsp><label|sec> We now provide simulation results to corroborate the
  analytical results. We choose the number of antennas at the source <math|M>
  to be 2. Fig.<nbsp><reference|fig> shows capacity versus <math|\<gamma\>>.
  Since the noise power is normalized to one, <math|\<gamma\>> denotes the
  transmit signal-to-noise ratio (SNR). Here the \Poptimum\Q refers to
  <math|<math-bf|Q><rsub|o*p*t>> which achieves capacity, and the
  \Psub-optimum\Q refers to a sub-optimum <math|<math-bf|Q><rsub|1>> (see the
  proof of <with|font-shape|italic|Theorem 1>) with numerically optimized
  power allocation. The optimality of <math|<math-bf|Q><rsub|o*p*t>> is
  clearly shown in Fig.<nbsp><reference|fig>. At high <math|\<gamma\>>, the
  difference between the rates using the optimum and the sub-optimum
  diminishes. From Fig.<nbsp><reference|fig>, capacity increases with
  <math|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>>> with other parameters fixed.
  Similar observations can be made with different sets of parameters, which
  are not presented here due to space constraint.

  Fig.<nbsp><reference|fig> gives simulation results to corroborate
  (<reference|BF>). Consider the case with two antennas at the source
  (<math|M=2>). Given the parameters <math|\<alpha\>>, <math|\<b-mu\>>, and
  <math|G>, the optimum <math|\<phi\>> can be determined for a specific
  <math|\<gamma\>>, and let <math|f<around|(|\<gamma\>|)>=\<bbb-E\><around|{|Z|}>+<frac|1|G>*\<bbb-E\>*<around*|{|Z*exp
  <around|(|Z|)>*\<Gamma\><around|(|0,Z|)>|}>-<around*|(|\<bbb-E\>*<around*|{|Z<rsup|2>*exp
  <around|(|Z|)>*\<Gamma\><around|(|0,Z|)>|}>+D<rsub|2>|)>>. According to
  (<reference|BF>), if beamforming is optimum, then <math|\<phi\>=1> [or,
  <math|1-\<phi\>> = 0], and <math|f<around|(|\<gamma\>|)>\<leq\>0>. This
  consistency is clearly reflected in Fig.<nbsp><reference|fig>.

  <\big-figure>
    <image|fig_1.eps|3.5in|5in||><label|fig>
  </big-figure|Comparison of optimum and sub-optimum solutions for
  <math|M=2>, <math|\<alpha\>=0.1>, <math|\<b-mu\>=<around|(|0.3518+j*0.2496<space|0.27em>-0.4039-j*1.0437|)><rsup|T>>
  (<math|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>><rsup|2>/\<alpha\>=14.3851>),
  <math|G=15> dB.>

  <\big-figure>
    <image|fig_2.eps|3.5in|5in||><label|fig>
  </big-figure|Illustration of the impact of
  <math|<around|\<\|\|\>|\<b-mu\>|\<\|\|\>>> on capacity for <math|M=2>,
  <math|\<alpha\>=0.1>, <math|G=15> dB.>

  <\big-figure>
    <image|optimality.eps|3.5in|5in||><label|fig>
  </big-figure|Illustration of the validity of (<reference|BF>) for
  <math|M=2>, <math|\<alpha\>=0.5>, <math|\<b-mu\>=(-0.2163+j*0.0627<space|0.27em>-0.8328+j*0.1438)<rsup|T>>,
  <math|G=10> dB. The function <math|f<around|(|\<gamma\>|)>> is given in
  Section<nbsp><reference|sec>.>

  <section|Concluding remarks>

  <nbsp><label|sec> The optimum source covariance matrix of a noncoherent
  half-duplex AF MISO relay channel has been determined with channel mean
  feedback at the source. We have used a new method based on the Laplace
  transform order of two nonnegative random variables. Our results subsume as
  an asymptotic case the optimum precoding for a traditional MISO link. The
  superiority of the optimum transmit strategy over sub-optimum ones has been
  shown by simulations and is seen more pronounced at low to medium transmit
  SNR. Necessary and sufficient condition for optimality of beamforming has
  also been derived. It is expected that the powerful Laplace transform
  ordering approach used in this paper will find many applications pertaining
  to stochastic optimization problems in wireless communications and signal
  processing<nbsp><cite|mding_qtz_icassp11>.

  <section*|Appendix I>

  We introduce the key mathematical elements of this paper.

  <with|font-shape|italic|Definition 1><nbsp><cite-detail|Shaked_Shanth|p.
  95> <space|0.27em><space|0.27em> Let <math|T<rsub|1>> and <math|T<rsub|2>>
  be two <with|font-shape|italic|nonnegative> random variables such that
  <math|\<bbb-E\><around|{|e<rsup|-s*T<rsub|1>>|}>\<geq\>\<bbb-E\><around|{|e<rsup|-s*T<rsub|2>>|}>,\<forall\>s\<gtr\>0>.
  Then <math|T<rsub|1>> is said to be <with|font-shape|italic|smaller> than
  <math|T<rsub|2>> <with|font-shape|italic|in the Laplace transform order>,
  denoted by <math|T<rsub|1>\<leq\><rsub|LT>T<rsub|2>>.

  <with|font-shape|italic|Definition 2><nbsp><cite-detail|Shaked_Shanth|p.
  96> <space|0.27em><space|0.27em> A function <math|q>:
  <math|\<bbb-R\><rsub|+>\<rightarrow\>\<bbb-R\>> is said to be completely
  monotone if all its derivatives <math|q<rsup|<around|(|n|)>>> exist and
  (<math|-1)<rsup|n>q<rsup|<around|(|n|)>><around|(|x|)>\<geq\>0>, for all
  <math|x\<gtr\>0> and <math|n=0,1,2,\<ldots\>> (all nonnegative integer
  values).

  <with|font-shape|italic|Lemma 1> <space|0.27em><space|0.27em> Let
  <math|T<rsub|1>> and <math|T<rsub|2>> be two
  <with|font-shape|italic|nonnegative> random variables, and let <math|d> be
  any positive constant (<math|d\<gtr\>0>). If
  <math|T<rsub|1>\<leq\><rsub|LT>T<rsub|2>>, then
  <math|\<bbb-E\><around*|{|log <around|(|1+d*T<rsub|1>|)>|}>\<leq\>\<bbb-E\><around*|{|log
  <around|(|1+d*T<rsub|2>|)>|}>>.

  <with|font-shape|italic|Proof>: The proof involves Theorem 3.B.4 (a) (p.
  97) and Eq. (3.B.2) (p. 96) of<nbsp><cite|Shaked_Shanth>, and is based on
  the fact that <math|log <around|(|1+d*x|)>,d\<gtr\>0>, is a positive
  function in <math|x> when <math|x\<gtr\>0> with its first-order derivative
  being completely monotone (see <with|font-shape|italic|Definition 2>).
  Details can be found in<nbsp><cite|mding_kzhang>. <math|\<Box\>>

  <section*|Acknowledgment>

  The authors would like to thank Dr. P. Dharmawansa, Prof. R. K. Mallik,
  Prof. M. R. McKay, and Prof. K. B. Letaief for helpful discussions.

  <balance>

  <\thebibliography|>
    <bibitem|Laneman_1>J. N. Laneman, D. Tse, and G. W. Wornell,
    \PCooperative diversity in wireless networks: efficient protocols and
    outage bahavior,\Q <with|font-shape|italic|IEEE Trans. Inf. Theory>, vol.
    50, no. 12, pp. 3062-3080, Dec. 2004.

    <bibitem|Nabar_performance>H. Blcskei, R. U. Nabar, O. Oyman, and A.
    Paulraj, \PCapacity scaling laws in MIMO relay networks,\Q
    <with|font-shape|italic|IEEE Trans. Wireless Commun.>, vol. 5, no. 6, pp.
    1433-1444, Jun. 2006.

    <bibitem|tang_hua_perfect_CSI>X. Tang and Y. Hua, \POptimal design of
    non-regenrative MIMO wireless relays,\Q <with|font-shape|italic|IEEE
    Trans. Wireless Commun.>, vol. 6, no. 4, pp. 1398-1407, Apr. 2007.

    <bibitem|medina_Olga>O. Munz-Medina, J. Vidal, and A. Augstn, \PLinear
    transceiver design in nonregenerative relays with channel state
    information,\Q <with|font-shape|italic|IEEE Trans. Signal Process.>, vol.
    55, no. 6, pp. 2593-2604, Jun. 2007.

    <bibitem|Prathapa_ICC>P. Dharmawansa, M. R. McKay, R. K. Mallik, and K.
    B. Letaief, \POptimality of beamforming for a correlated MISO relay
    channel,\Q in <with|font-shape|italic|Proc. IEEE ICC 2010>, pp. 1-5, May
    2010.

    <bibitem|Dharmawansa_McKay_journal>P. Dharmawansa, M. R. McKay, R. K.
    Mallik, and K. B. Letaief, \PErgodic capacity and beamforming optimality
    for MISO relaying with statistical CSI,\Q submitted to
    <with|font-shape|italic|IEEE Trans. Commun.>.

    <bibitem|MIMO_capacity_goldsmith>A. Goldsmith, S. A. Jafar, N. Jindal,
    and S. Vishwanath, \PCapacity limits of MIMO channels,\Q
    <with|font-shape|italic|IEEE JSAC>, vol. 21, no. 5, pp. 684-702, Jun.
    2003.

    <bibitem|Zhou_Giannakis_CMF>S. Zhou and G. B. Giannakis, \POptimal
    transmitter eigen-beamforming and space-time block coding based on
    channel mean feedback,\Q <with|font-shape|italic|IEEE Trans. Signal
    Process.>, vol. 50, no. 10, pp. 2599-2613, Oct. 2002.

    <bibitem|Visotsky_madhow>E. Visotsky and U. Madhow, \PSpace-time transmit
    precoding with imperfect feedback,\Q <with|font-shape|italic|IEEE Trans.
    Inf. Theory>, vol. 47, no. 6, pp. 2632-2639, Sep. 2001.

    <bibitem|Jafar_Goldsmith>S. A. Jafar and A. Goldsmith, \PTransmitter
    optimization and optimality of beamforming for multiple antenna systems
    with imperfect feedback,\Q <with|font-shape|italic|IEEE Trans. Wireless
    Commun.>, vol. 3, no. 4, pp. 1165-1175, Jul. 2004.

    <bibitem|ALMoustakas>A. L. Moustakas and S. H. Simon, \POptimizing
    multiple-input single-output (MISO) communication systems with general
    Gaussian channels: nontrivial covariance and nonzero mean,\Q
    <with|font-shape|italic|IEEE Trans. Inf. Theory>, vol. 49, no. 10, pp.
    2770-2780, Oct. 2003.

    <bibitem|Boche_covariance_feedback>E. Jorswieck and H. Boche, \PChannel
    capacity and capacity-range of beamforming in MIMO wireless systems under
    correlated fading with covriance feedback,\Q <with|font-shape|italic|IEEE
    Trans. Wireless Commun.>, vol. 3, no. 5, pp. 1543-1553, Sep. 2004.

    <bibitem|mding_sdb_T_IT_2010_to_appear>M. Ding and S. D. Blostein,
    \PMaximum mutual information design for MIMO systems with imperfect
    channel knowledge,\Q <with|font-shape|italic|IEEE Trans. Inf. Theory>,
    vol. 56, no. 10, pp. 4793-4801, Oct. 2010.

    <bibitem|mding_kzhang>M. Ding and Q. T. Zhang, \PSource optimization in a
    noncoherent relay channel with channel mean feedback,\Q submitted to
    <with|font-shape|italic|IEEE Trans. Inf. Theory> in Jun. 2010.

    <bibitem|chi_square_convex_combinations>S. J. Press, \PLinear
    combinations of non-central chi-square variates,\Q
    <with|font-shape|italic|Ann. Math. Stat.>, vol. 37, no. 2, pp. 480-487,
    Apr. 1966.

    <bibitem|Proakis>J. G. Proakis, <with|font-shape|italic|Digital
    Communications>, McGraw-Hill, 2000.

    <bibitem|Shaked_Shanth>M. Shaked, J. G. Shanthikumar,
    <with|font-shape|italic|Stochatic Orders and Their Applications>,
    Academic Press, 1994.

    <bibitem|Marshall_Olkin>A. W. Marshall, I. Olkin,
    <with|font-shape|italic|Inequalities: Theory of Majorization and Its
    Applications>, Academic Press, 1979.

    <bibitem|Chong>E. K. P. Chong, S. H. ak, <with|font-shape|italic|An
    Introduction to Optimization>, 3rd Edition, Wiley, 2008.

    <bibitem|integration_book>M. Abramowitz, I. A. Stegun,
    <with|font-shape|italic|Handbook of Mathematical Functions>, Dover
    Publications, 1965.

    <bibitem|ding_Blostein_PIMRC09>M. Ding, S. D. Blostein, et al., \PA
    general framework for MIMO transceiver design with imperfect CSI and
    transmit correlation,\Q in <with|font-shape|italic|Proc. IEEE PIMRC>, pp.
    182-186, Sep. 2009.

    <bibitem|mding_qtz_icassp11>M. Ding and Q. T. Zhang, \PStochastic
    optimization based on the Laplace transform order with applications to
    precoder designs,\Q to appear in <with|font-shape|italic|Proc. IEEE
    ICASSP 2011>, May 2011.
  </thebibliography>
</body>