<TeXmacs|1.99.7>

<style|<tuple|article|std-latex>>

<\body>
  <\hide-preamble>
    <assign|set|<macro|1|2|<left|{><arg|1><left|\|><vphantom|<arg|1>><vphantom|<arg|2>><right|.><arg|2><right|}>>>

    <assign|oneset|<macro|1|<left|{><mathinner|<arg|1>><right|}>>>

    <assign|smallset|<macro|1|<left|{><mathinner|<arg|1>><right|}>>>

    <assign|abs|<macro|1|<left|\|><mathinner|<arg|1>><right|\|>>>

    <assign|floor|<macro|1|<left|lfloor><mathinner|<arg|1>> <right|rfloor>>>

    <assign|ceil|<macro|1|<left|lceil><mathinner|<arg|1>> <right|rceil>>>

    <assign|bracket|<macro|1|<left|[><mathinner|<arg|1>> <right|]>>>

    <assign|dbracket|<macro|1|<left|llbracket><mathinner|<arg|1>>
    <right|rrbracket>>>

    <assign|parenth|<macro|1|<left|(><mathinner|<arg|1>> <right|)>>>

    <assign|gen|<macro|1|<left|\<less\>> <mathinner|<arg|1>>
    <right|\<gtr\>>>>

    <assign|N|<macro|\<bbb-N\>>>

    <assign|Z|<macro|\<bbb-Z\>>>

    <assign|Q|<macro|\<bbb-Q\>>>

    <assign|R|<macro|\<bbb-R\>>>

    <assign|C|<macro|\<bbb-C\>>>

    <assign|Oh|<macro|\<cal-O\>>>

    <assign|oh|<macro|o>>

    <assign|cA|<macro|\<cal-A\>>>

    <assign|cB|<macro|\<cal-B\>>>

    <assign|cC|<macro|\<cal-C\>>>

    <assign|cF|<macro|\<cal-F\>>>

    <assign|cG|<macro|\<cal-G\>>>

    <assign|cH|<macro|\<cal-H\>>>

    <assign|cI|<macro|\<cal-I\>>>

    <assign|cL|<macro|\<cal-L\>>>

    <assign|cM|<macro|\<cal-M\>>>

    <assign|cQ|<macro|\<cal-Q\>>>

    <assign|cU|<macro|\<cal-U\>>>

    <assign|cR|<macro|\<cal-R\>>>

    <assign|cS|<macro|\<cal-S\>>>

    <assign|cT|<macro|\<cal-T\>>>

    <assign|mb|<macro|1|<with|math-font-family|bf|<arg|1>>>>

    <assign|mc|<macro|1|<with|math-font|cal|<arg|1>>>>

    <assign|ms|<macro|1|<with|math-font|cal*|<arg|1>>>>

    <assign|w|<macro|<mb|w>>>

    <assign|BAR|<macro|<wide|<phantom|ii>|\<bar\>>>>

    <assign|smalloverline|<macro|1|<mspace|1mu><wide|<mspace|-1mu><arg|1><mspace|-1mu>|\<bar\>><mspace|1mu>>>

    <assign|ov|<macro|1|<smalloverline|<arg|1>>>>

    <assign|ti|<macro|1|<wide|<arg|1>|~>>>

    <assign|PSPACE|<macro|<math|<math-up|PSPACE>>>>

    <assign|EXPSPACE|<macro|<math|<math-up|EXPSPACE>>>>

    <assign|NP|<macro|<math|<math-up|NP>>>>

    <assign|REG|<macro|<math|<math-up|REG>>>>

    <assign|refthm|<macro|1|Theorem<nbsp><reference|1>>>

    <assign|refcor|<macro|1|Corollary<nbsp><reference|1>>>

    <assign|refdef|<macro|1|Definition<nbsp><reference|1>>>

    <assign|reflem|<macro|1|Lemma<nbsp><reference|1>>>

    <assign|refprop|<macro|1|Proposition<nbsp><reference|1>>>

    <assign|refrem|<macro|1|Remark<nbsp><reference|1>>>

    <assign|refprob|<macro|1|Problem<nbsp><reference|1>>>

    <assign|refcon|<macro|1|Conjecture<nbsp><reference|1>>>

    <assign|reffig|<macro|1|Figure<nbsp><reference|1>>>

    <assign|refsec|<macro|1|Section<nbsp><reference|1>>>

    <assign|IFF|<macro|if and only if>>

    <assign|hom|<macro|homomorphism>>

    <assign|hpc|<macro|hairpin completion>>

    <assign|cf|<macro|context-free>>

    <assign|cfg|<macro|context-free grammar>>

    <assign|cfl|<macro|context-free language>>

    <assign|lcf|<macro|linear context-free>>

    <assign|lcfg|<macro|linear context-free grammar>>

    <assign|lcfl|<macro|linear context-free language>>

    <assign|unam|<macro|unambiguous>>

    <assign|nd|<macro|non-deterministic>>

    <assign|svndt|<macro|single-valued non-deterministic transduction>>

    <assign|NL|<macro|<with|font-series|bold|NL>>>

    <assign|NC|<macro|<with|font-series|bold|NC>>>

    <assign|TM|<macro|Turing machine>>

    <assign|svlstd|<macro|single-valued <nd><math|log>-space transduction>>

    <assign|Svlstd|<macro|Single-valued <nd><math|log>-space transduction>>

    <assign|e|<macro|1>>

    <assign|lds|<macro|,...,>>

    <assign|cds|<macro|\<cdots\>>>

    <assign|ccH|<macro|<math|<cH><rsub|k><around|(|L<rsub|1>,L<rsub|2>|)>>>>

    <assign|kH|<macro|<cH><rsub|k>>>

    <assign|Hk|<macro|<cH><rsub|k>>>

    <assign|sse|<macro|\<subseteq\>>>

    <assign|es|<macro|\<emptyset\>>>

    <assign|sm|<macro|\<setminus\>>>

    <assign|dead|<macro|t>>

    <assign|SIM|<macro|1|\<sim\><rsub|<arg|1>><mspace|-1mu>>>

    <assign|CLASS|<macro|1|2|[<arg|1>]<rsub|<arg|2>>>>

    <assign|syn|<macro|1|<cM><rsub|<arg|1>>>>

    <assign|phi|<macro|\<varphi\>>>

    <assign|inphi|<macro|\<phi\><rsup|-1>>>

    <assign|eps|<macro|\<varepsilon\>>>

    <assign|GG|<macro|\<Gamma\>>>

    <assign|oo|<macro|\<omega\>>>

    <assign|alp|<macro|\<alpha\>>>

    <assign|bet|<macro|\<beta\>>>

    <assign|gam|<macro|\<gamma\>>>

    <assign|del|<macro|\<delta\>>>

    <assign|Alp|<macro|\<alpha\>>>

    <assign|Sig|<macro|\<Sigma\>>>

    <assign|Gam|<macro|\<Gamma\>>>

    <assign|Del|<macro|\<Delta\>>>

    <assign|aba|<macro|\<alpha\>\<beta\><ov|\<alpha\>>>>

    <assign|abba|<macro|\<alpha\>\<beta\>'<ov|\<alpha\>>>>

    <assign|gabag|<macro|\<gamma\>\<alpha\>\<beta\><ov|\<alpha\>><ov|\<gamma\>>>>

    <assign|gaba|<macro|\<gamma\>\<alpha\>\<beta\><ov|\<alpha\>>>>

    <assign|abag|<macro|\<alpha\>\<beta\><ov|\<alpha\>><ov|\<gamma\>>>>

    <assign|symP|<macro|<math|<around|(|P,<ti|p<rsub|1>>,<ti|p<rsub|2>>|)>>>>

    <assign|symQ|<macro|<math|<around|(|Q<rsub|0>,<ti|q<rsub|1>>,<ti|q<rsub|2>>|)>>>>

    <assign|pre|<macro|pre>>

    <assign|suf|<macro|suf>>

    <assign|RAS|<macro|1|<overset|<arg|1>>\<Longrightarrow\>>>

    <assign|ras|<macro|1|<overset|<arg|1>>\<longrightarrow\>>>

    <new-theorem|theorem|Theorem>

    <new-theorem|proposition|Proposition>

    <new-theorem|lemma|Lemma>

    <new-theorem|corollary|Corollary>

    <new-theorem|definition|Definition>

    <new-theorem|example|Example>

    <new-theorem|remark|Remark>

    <\assign|test>
      <\macro|1|body>
        <\trivlist>
          <\surround>
            <item*|labelsep <with|font-series|bold|Test
            <arg|1>:<space|0.17em>>>
          </surround||<\with|font-shape|italic>
            <arg|body>
          </with>>
        </trivlist>
      </macro>
    </assign>

    <assign|property|<macro|1|body|<trivlist|<\surround>
      <item*|labelsep <with|font-series|bold|Property
      <arg|1>:<space|0.17em>>>
    <|surround|>
      <arg|body>
    </surround>>>>

    <assign|vd|<macro|body|<\surround|<no-indent><with|color|blue|VD >|>
      <arg|body>
    </surround>>>

    <assign|vdd|<macro|1|<vd| <arg|1>>>>

    <assign|sk|<macro|body|<\surround|<no-indent><with|color|red|SK >|>
      <arg|body>
    </surround>>>

    <assign|skk|<macro|1|<sk| <arg|1>>>>

    <assign|eps|<macro|\<varepsilon\>>>

    <assign|ra|<macro|\<rightarrow\>>>

    <assign|Lra|<macro|\<Longrightarrow\>>>

    <assign|Ra|<macro|\<Rightarrow\>>>

    <assign|lra|<macro|\<longrightarrow\>>>

    <assign|gdw|<macro|\<Leftrightarrow\>>>
  </hide-preamble>

  <doc-data|<doc-title|It Is NL-complete to Decide Whether a Hairpin
  Completion of Regular Languages Is Regular>|<doc-author|<author-data|<author-name|Volker
  Diekert, Steffen Kopecki<next-line><with|font-size|0.84|<with|font-family|tt|{diekert,kopecki}@fmi.uni-stuttgart.de><next-line>University
  of Stuttgart, Institute for Formal Methods in Computer Science
  (FMI),<next-line>Universittsstrae 38, D-70569
  Stuttgart>>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    The hairpin completion is an operation on formal languages which is
    inspired by the hairpin formation in biochemistry. Hairpin formations
    occur naturally within DNA-computing. It has been known that the hairpin
    completion of a regular language is linear context-free, but not regular,
    in general. However, for some time it is was open whether the regularity
    of the hairpin completion of a regular language is is decidable. In 2009
    this decidability problem has been solved positively in
    <cite|DiekertKM09> by providing a polynomial time algorithm. In this
    paper we improve the complexity bound by showing that the decision
    problem is actually <NL>-complete. This complexity bound holds for both,
    the one-sided and the two-sided <hpc>s.

    <vspace|baselineskip><no-indent><with|font-series|bold|Keywords:>
    Automata and Formal Languages; Regular Languages, Finite Automata;
    <NL>-Complete Problems; DNA-Computing; Hairpin Completion.
  </abstract>>

  <section|Introduction>

  The hairpin completion is a natural operation of formal languages which has
  been inspired by molecular phenomena in biology and which occurs naturally
  during DNA-computing. An intramolecular base pairing, known as a
  <em|hairpin>, is a pattern that can occur in single-stranded DNA and, more
  commonly, in RNA. Hairpin or hairpin-free structures have numerous
  applications to DNA computing and molecular genetics, see
  <cite|garzon1|garzon2|garzon3|KariKLST05|KariMT07> and the references
  within for a detailed discussion. For example, an instance of
  <with|font-shape|small-caps|3-Sat> has been solved with a DNA-algorithm and
  one of the main concepts was to eliminate all molecules with a hairpin
  structure, see <cite|KensakuSakamoto05192000>.

  In this paper we study the <hpc>from a purely formal language viewpoint.
  The <hpc>of a formal language was first defined by Cheptea,
  Mart<math|<wide|<text|\Y>|\<acute\>>>n-Vide, and Mitrana in
  <cite|ChepteaMM06>; here we use a slightly more general definition which
  was introduced in <cite|DiekertKM09>. The hairpin completion and some
  related operations have been studied in a series of papers from language
  theoretic and algorithmic point of view, see e.g.,
  <cite|DBLP:conf/cie/ManeaM07|ManeaMY09tcs|ManeaMM09|Ito2010|ManeaMY10|ManeaMM10|Kopecki10>.
  The formal operation of the <hpc>on words is best explained in
  Figure<nbsp><reference|whatanicehairpin>. In that picture as in the rest of
  the paper we mean by putting a <em|bar> on a word (like <math|<ov|<alp>>>)
  to read it from right-to-left and in addition to replace a letter <math|a>
  with the (Watson-Crick) complement <math|<ov|a>>. The hairpin completion of
  a regular language is linear context-free, but not regular, in general
  <cite|ChepteaMM06>.

  <\big-figure>
    <\with|par-mode|center>
      <\latex_preview|begin-tikzpicture>
        \\begin{tikzpicture}[text height=1.5ex,text depth=.25ex]

        \ \ \ \ \\draw [\|-\|] (-4,1) .. controls +(.5,.25) and +(-.5,-.25)
        ..

        \ \ \ \ \ \ node [above] {$\\gamma$} (-3,1);

        \ \ \ \ \\draw [-] (-3,1) .. controls +(.25,.125) and +(-.25,.125) ..

        \ \ \ \ \ \ node [above] {$\\alpha$} (-2.5,1);

        \ \ \ \ \\draw [\|-\|] (-2.5,1) .. controls +(.5,-.25) and +(-.5,.25)
        ..

        \ \ \ \ \ \ node [above] {$\\beta$} (-1.5,1);

        \ \ \ \ \\draw [-\|] (-1.5,1) .. controls +(.25,-.125) and
        +(-.25,-.125) ..

        \ \ \ \ \ \ node [above] {$\\ov\\alpha$} (-1,1);

        \;

        \t\\draw [-\<gtr\>,decorate,decoration=

        \t\t\t{snake,amplitude=.3mm,segment length=1.5mm,post length=1mm}]

        \t\t(-.5,1) -- (2,1) node [above,text centered,midway] {annealing};

        \ \ \ \ \\draw [\|-] (2.5,0) -- node [above,sloped] {$\\gamma$}
        (2.5,1);

        \ \ \ \ \\draw [\|-\|] (2.5,1) -- node [above,sloped] {$\\alpha$}
        (2.5,1.5);

        \ \ \ \ \\draw [-] (2.5,1.5) .. controls +(up:.25) and +(down:.25) ..
        (2.25,2)

        \ \ \ \ \ \ .. controls +(up:.5) and +(up:.5) .. node [above,sloped]
        {$\\beta$} (3,2)

        \ \ \ \ \ \ .. controls +(down:.25) and +(up:.25) .. (2.75,1.5);

        \ \ \ \ \\draw [\|-\|] (2.75,1.5) -- node [above,sloped]
        {$\\ov\\alpha$} (2.75,1);

        \;

        \t\\draw [-\<gtr\>,decorate,decoration=

        \t\t\t{snake,amplitude=.3mm,segment length=1.5mm,post length=1mm}]

        \t\t(3.25,1) -- (5.75,1) node [above,text centered,midway]
        {lengthening};

        \;

        \ \ \ \ \\draw [\|-] (6.25,0) -- node [above,sloped] {$\\gamma$}
        (6.25,1);

        \ \ \ \ \\draw [\|-\|] (6.25,1) -- node [above,sloped] {$\\alpha$}
        (6.25,1.5);

        \ \ \ \ \\draw [-] (6.25,1.5) .. controls +(up:.25) and +(down:.25)
        .. (6,2)

        \ \ \ \ \ \ .. controls +(up:.5) and +(up:.5) .. node [above,sloped]
        {$\\beta$}

        \ \ \ \ \ \ (6.75,2) .. controls +(down:.25) and +(up:.25) ..
        (6.5,1.5);

        \ \ \ \ \\draw [\|-\|] (6.5,1.5) -- node [above,sloped]
        {$\\ov\\alpha$} (6.5,1);

        \ \ \ \ \\draw [-\|] (6.5,1) -- node [above,sloped] {$\\ov\\gamma$}
        (6.5,0);

        \;

        \ \ \ \ \\node at (-2.5,-.5) {strand};

        \ \ \ \ \\node at (2.625,-.5) {hairpin};

        \ \ \ \ \\node at (6.375,-.5) {hairpin completion};

        \ \ \\end{tikzpicture}
      </latex_preview>

      <label|whatanicehairpin>
    </with>
  </big-figure|Hairpin completion of a DNA-strand (or a word).>

  For some time it was not known whether regularity of the hairpin completion
  of a regular language is decidable. It was only in 2009 when we presented
  in <cite|DiekertKM09> a decision algorithm. Actually, we proved a better
  result by providing a polynomial time algorithm with a (rough) runtime
  estimation of about <math|<Oh><around|(|n<rsup|20>|)>>.

  In an extended abstract which appeared at the CIAA<nbsp>2010 we presented a
  modified approach to solve the same problem <cite|DieKop11> which led, in
  particular, to the following two new results: First, the time complexity of
  the new decision algorithm is in <math|<Oh><around|(|n<rsup|8>|)>>. Second,
  the decision problem is NLOGSPACE-complete, i.e., <NL>-complete.

  This paper is the journal version of <cite|DieKop11> for the second result.
  We decided to focus on the space complexity since, in terms of complexity,
  <NL>-completeness yields a precise characterization and because the given
  page limit did not allow to include full proofs for all results of
  <cite|DieKop11>. Moreover, our proofs are still rather technical and the
  focus on the <NL>-algorithm simplifies the presentation.

  We consider the one-sided and the two-sided <hpc>s simultaneously. It turns
  out that <NL>-completeness holds in both cases.

  The paper is organized as follows. In <refsec|secpn> we fix the notation
  used throughout. We give the formal definition of the <hpc><math|<ccH>> and
  we discuss our input model using appropriate deterministic automata.

  In <refsec|secmain> we state the main result (<refthm|thm:main>) and we
  give a full proof in the subsequent subsections. A main technical tool is
  the use of <svlstd>s, which might be not fairly standard. They are
  explained in <refsec|svlstd>. In <refsec|secopen> we give a short
  conclusion and we state some open problems.

  <section|Preliminaries and Notation><label|secpn>

  We assume the reader to be familiar with the basic concepts of formal
  language theory, automata theory, and complexity theory, as one can find in
  the text books<cite|HU|pap94>. By <NL>we mean the complexity class
  NLOGSPACE, which contains the problems which can be decided by a <nd>
  <TM>using <math|<Oh><around|(|log n|)>> work space. Throughout we use the
  well-known result that <NL>is closed under complementation, see e.g.
  <cite|pap94>. We also use the fact that if <math|L> can be reduced to
  <math|L<rprime|'>> via some <svlstd>and <math|L<rprime|'>\<in\>> <NL>, then
  we have <math|L\<in\>> <NL>, see <cite|AlvarezJenner95>\<varspace\>and
  <refsec|svlstd> for more details.

  By <math|<Sig>> we denote a finite alphabet with at least two letters. The
  set of words over <math|<Sig>> is denoted <math|<Sig><rsup|\<ast\>>>; and
  the <em|empty word> is denoted by <math|<e>>. Given a word <math|w>, we
  denote by <math|<around|\||w|\|>> its length and
  <math|w<around|(|m|)>\<in\><Sig>> its <math|m>-th letter. If <math|w=x*y*z>
  for some <math|x,y,z\<in\><Sig><rsup|\<ast\>>>, then <math|x> and <math|z>
  are called <em|prefix> and <em|suffix> of <math|w>, respectively. By a
  proper prefix <math|x> of <math|w> we mean a prefix such that
  <math|x\<neq\>w> (but we allow <math|x=<e>>). The prefix relation between
  words <math|x> and <math|w> is denoted by <math|x\<leq\>w> and for proper
  prefixes by <math|x\<less\>w>.

  We assume that the alphabet <math|<Sig>> is equipped with an involution
  <math|<BAR>:<Sig>\<to\><Sig>>. An <em|involution> for a set is a bijection
  such that <math|<wide|<ov|a>|\<bar\>>=a>. We extend the involution to words
  <math|a<rsub|1>*\<cdots\>*a<rsub|n>> by
  <math|<ov|a<rsub|1>*\<cdots\>*a<rsub|n>>=<ov|a<rsub|n>>\<cdots\><ov|a<rsub|1>>>
  where the <math|a<rsub|i>>'s are letters. This convention is like taking
  inverses in groups. For languages <math|L<sse><Sig><rsup|\<ast\>>> we
  denote by <math|<ov|L>> the set

  <\equation*>
    <ov|L>=<set|<ov|w>|w\<in\>L>.
  </equation*>

  Throughout the paper <math|L<rsub|1>,L<rsub|2>> are two regular languages
  in <math|<Sig><rsup|\<ast\>>> and by <math|k> we mean a (small) constant.
  (In a biological setting <math|k\<sim\>10> yields a reasonable value.)
  According to <reffig|whatanicehairpin>\<varspace\>we define the <em|hairpin
  completion> <math|<ccH>> by

  <\equation*>
    <ccH>=<set|\<gamma\>*\<alpha\>*\<beta\><ov|\<alpha\>><ov|\<gamma\>>|(\<gamma\>\<alpha\>\<beta\><ov|\<alpha\>>\<in\>L<rsub|1>\<vee\>\<alpha\>\<beta\><ov|\<alpha\>><ov|\<gamma\>>\<in\>L<rsub|2>)\<wedge\>\|\<alpha\>\|=k>.
  </equation*>

  This definition is slightly more general than the original definition in
  <cite|ChepteaMM06|ManeaMY09tcs>. It allows us to treat the two-sided
  hairpin completion (<math|L<rsub|1>=L<rsub|2>>) and the one-sided hairpin
  completion (either <math|L<rsub|1>=<es>> or <math|L<rsub|2>=<es>>)
  simultaneously.

  A regular language can be specified by a <nd>finite automaton (NFA)
  <math|<cA>=<around|(|<cQ>,<Sig>,E,<cI>,<cF>|)>>, where <math|<cQ>> is the
  finite set of <em|states>, <math|<cI><sse><cQ>> is the set of <em|initial
  states>, and <math|<cF><sse><cQ>> is the set of <em|final states>. The set
  <math|E> contains labeled <em|edges> (or <em|arcs>), it is a subset of
  <math|<cQ>\<times\><Sig>\<times\><cQ>>. For a word
  <math|u\<in\><Sig><rsup|\<ast\>>> we write <math|p<ras|u>q>, if there is a
  path from state <math|p> to <math|q> which is labeled by the word <math|u>.
  Thus, the accepted language becomes

  <\equation*>
    L<around|(|<cA>|)>=<set|u\<in\><Sig><rsup|\<ast\>>|\<exists\>p\<in\><cI><space|0.17em>\<exists\>q\<in\><cF>:<space|0.27em>p<ras|u>q>.
  </equation*>

  Later it will be crucial to use also paths which avoid final states. For
  this we introduce a special notation. First remove all arcs
  <math|<around|(|p,a,q|)>> where <math|q\<in\><cF>> is a final state. Thus,
  final states do not have incoming arcs anymore. Let us write
  <math|p<RAS|u>q>, if there is a path from state <math|p> to <math|q> which
  is labeled by the word <math|u> in this new automaton after removing these
  arcs. Note that for such a path <math|p<RAS|u>q> we allow
  <math|p\<in\><cF>>, but on the path we never enter any final state again.

  An NFA is called a <em|deterministic finite automaton> (DFA), if it has
  exactly one initial state and for every state <math|p\<in\><cQ>> and every
  letter <math|a\<in\><Sig>> there is exactly one arc
  <math|<around|(|p,a,q|)>\<in\>E>. In particular, in this paper a DFA is
  always <em|complete.>\<varspace\>Thus, we can read every word to its end.
  We also write <math|p\<cdot\>u=q>, if <math|p<ras|u>q>. This yields a
  (totally defined) function <math|<cQ>\<times\>\<Sigma\><rsup|\<ast\>>\<to\><cQ>>.
  (It defines an action of <math|\<Sigma\><rsup|\<ast\>>> on <math|<cQ>> on
  the right.)

  In the following we use a DFA accepting <math|L<rsub|1>> as well as a DFA
  accepting <math|L<rsub|2>>, but the DFA for <math|L<rsub|2>> has to work
  from right-to-left. Instead of introducing this concept we use a DFA
  (working as usual from left-to-right), which accepts <math|<ov|L<rsub|2>>>.
  This automaton has the same number of states as (and is structurally
  isomorphic to) a DFA accepting the <em|reversal language> of
  <math|L<rsub|2>>.

  As input we assume that the regular languages <math|L<rsub|1>> and
  <math|<ov|L<rsub|2>>> are specified by DFAs <math|<cA><rsub|1>> and
  <math|<cA><rsub|2>> with state set <math|<cQ><rsub|i>>, state
  <math|q<rsub|0*i>\<in\><cQ><rsub|i>> as initial state, and
  <math|<cF><rsub|i>\<subseteq\><cQ><rsub|i>> as final states. By <math|n> we
  denote the input size

  <\equation*>
    n=<abs|<cQ><rsub|1>>+<abs|<cQ><rsub|2>>.
  </equation*>

  We also need the usual product DFA with state space

  <\equation*>
    <cQ>=<set|<around|(|p<rsub|1>,p<rsub|2>|)>\<in\><cQ><rsub|1>\<times\><cQ><rsub|2>|\<exists\>w\<in\><Sig><rsup|\<ast\>>:(p<rsub|1>,p<rsub|2>)=(q<rsub|01>\<cdot\>w,<space|0.27em>q<rsub|02>\<cdot\>w)>.
  </equation*>

  The action is given by <math|<around|(|p<rsub|1>,p<rsub|2>|)>\<cdot\>a=<around|(|p<rsub|1>\<cdot\>a,<space|0.27em>p<rsub|2>\<cdot\>a|)>>.
  As <math|<cQ>> contains only reachable states, the size of <math|<cQ>>
  might be smaller than <math|<abs|<cQ><rsub|1>>\<cdot\><abs|<cQ><rsub|2>>>.
  In the following we work simultaneously in all three automata defined so
  far. Moreover, in <math|<cQ><rsub|1>> and <math|<cQ><rsub|2>> we are going
  to work backwards. This leads to nondeterminism.

  <section|Main result><label|secmain>

  The purpose of this paper is to prove the following result:

  <\theorem>
    <label|thm:main>The following problem is <NL>-complete:

    <with|font-series|bold|Input:>\<varspace\> Two DFAs <math|<cA><rsub|1>>
    and <math|<cA><rsub|2>> recognizing <math|L<rsub|1>> and
    <math|<ov|L<rsub|2>>> with state sets <math|<cQ><rsub|1>> and
    <math|<cQ><rsub|2>> resp.\<varspace\>such that
    <math|n=<abs|<cQ><rsub|1>>+<abs|<cQ><rsub|2>>>.

    <with|font-series|bold|Question:> Is <ccH>regular?
  </theorem>

  Since <NL>is included in <with|font-series|bold|P> we obtain the following
  result from <cite|DiekertKM09> as a corollary.

  <\corollary>
    <label|cor:main>The problem whether the hairpin completion <ccH>is
    regular is decidable in polynomial time.
  </corollary>

  We now turn to the proof of <refthm|thm:main>. The <NL>-hardness is
  immediate:

  <\lemma>
    The problem whether the hairpin completion <ccH>is regular is <NL>-hard,
    even for <math|L<rsub|2>=<es>>.
  </lemma>

  <\proof>
    The well-known <NL>-complete <with|font-shape|italic|Graph-Accessibility-Problem>
    <cite|pap94> can easily be reduced to the following problem for DFAs:

    Let <math|<Sig>=<oneset|a,<ov|a>,b,<ov|b>>> be an alphabet with four
    letters. Decide for a given DFA, which accepts a language
    <math|L<sse><oneset|b,<ov|b>><rsup|\<ast\>>>, whether or not <math|L> is
    empty.

    Now let <math|L<rsub|1>=a<rsup|\<ast\>>*L<ov|a><rsup|k>>. The hairpin
    completion

    <\equation*>
      <Hk><around|(|L<rsub|1>,<es>|)>=<set|a<rsup|i>*w<ov|a><rsup|j>|i\<geq\>j\<geq\>k\<wedge\>w\<in\>L>
    </equation*>

    is regular if and only if <math|L> is empty (because
    <math|L<sse><oneset|b,<ov|b>><rsup|\<ast\>>>).
  </proof>

  The difficult part is to show that deciding regularity of <ccH>is in <NL>.
  This is subject of the rest of this section.

  <subsection|<Svlstd>s><label|svlstd>

  A <svlstd>is performed by a <nd><math|log>-space Turing machine which may
  stop on every input <math|w> with some output <math|r<around|(|w|)>>.
  <em|Single-valued> means that, in case that the machine stops on input
  <math|w>, the output is always the same, independently of <nd>moves during
  the computation. Thus, <math|w\<mapsto\>r<around|(|w|)>> is a well-defined
  function from words to words. A <svlstd>is a <em|reduction> from a language
  <math|L> to <math|L<rprime|'>>, if we have
  <math|w\<in\>L\<Longleftrightarrow\>r<around|(|w|)>\<in\>L<rprime|'>>.

  The following lemma belongs to folklore. Its proof is exactly the same as
  for the standard case of deterministic <math|log>-space reductions
  <cite|HU> and therefore omitted.

  <\lemma>
    <label|lem:svlstd>Let <math|L<rprime|'>\<in\>> <NL>and assume that there
    exists a <svlstd>from <math|L> to <math|L<rprime|'>>. Then we have
    <math|L\<in\>> <NL>, too.
  </lemma>

  Due to <reflem|lem:svlstd> we are free to use several <svlstd>s in order to
  enrich the input.

  <subsection|Bridges><label|bridges>

  Let <math|<cQ><rsub|1>,<cQ><rsub|2>> be the state sets as fixed by
  <refthm|thm:main>. For every quadruple <math|<around|(|p<rsub|1>,p<rsub|2>,q<rsub|1>,q<rsub|2>|)>\<in\><cQ><rsub|1>\<times\><cQ><rsub|2>\<times\><cQ><rsub|1>\<times\><cQ><rsub|2>>
  we define a regular language <math|B<around|(|p<rsub|1>,p<rsub|2>,q<rsub|1>,q<rsub|2>|)>>
  as follows:

  <\equation*>
    B<around|(|p<rsub|1>,p<rsub|2>,q<rsub|1>,q<rsub|2>|)>=<set|<bet>\<in\><Sig><rsup|\<ast\>>|p<rsub|1>\<cdot\><bet>=q<rsub|1>\<wedge\>p<rsub|2>\<cdot\><ov|<bet>>=q<rsub|2>>.
  </equation*>

  We say that a quadruple <math|<around|(|p<rsub|1>,p<rsub|2>,q<rsub|1>,q<rsub|2>|)>>
  is a <em|bridge>, if <math|B<around|(|p<rsub|1>,p<rsub|2>,q<rsub|1>,q<rsub|2>|)>\<neq\><es>>.
  The idea behind this notation is that <math|B<around|(|p<rsub|1>,p<rsub|2>,q<rsub|1>,q<rsub|2>|)>>
  closes a gap between pairs <math|<around|(|p<rsub|1>,p<rsub|2>|)>> and
  <math|<around|(|q<rsub|1>,q<rsub|2>|)>>. For a bridge
  <math|<around|(|p<rsub|1>,p<rsub|2>,q<rsub|1>,q<rsub|2>|)>> the words
  <math|<bet>\<in\>B<around|(|p<rsub|1>,p<rsub|2>,q<rsub|1>,q<rsub|2>|)>>
  correspond later exactly to the <math|<bet>>-part in
  <reffig|whatanicehairpin>.

  <\lemma>
    <label|lem:bridge>There is a <svlstd>which outputs the table of all
    bridges.
  </lemma>

  <\proof>
    Graph reachability and its complement are solvable in <NL>. Therefore we
    can decide for each quadruple <math|<around|(|p<rsub|1>,p<rsub|2>,q<rsub|1>,q<rsub|2>|)>\<in\><cQ><rsub|1>\<times\><cQ><rsub|2>\<times\><cQ><rsub|1>\<times\><cQ><rsub|2>>
    if it is a bridge, and we can output <math|<around|(|p<rsub|1>,p<rsub|2>,q<rsub|1>,q<rsub|2>|)>>
    in the affirmative case.
  </proof>

  <subsection|The NFA <math|<cA>>><label|secnfa>

  Next, we construct an NFA, which is called simply <math|<cA>>, and we
  explore properties of this NFA. The NFA <math|<cA>> uses <math|k+1> levels
  (or layers) of a product automaton over
  <math|<cQ>\<times\><cQ><rsub|1>\<times\><cQ><rsub|2><sse><cQ><rsub|1>\<times\><cQ><rsub|2>\<times\><cQ><rsub|1>\<times\><cQ><rsub|2>>
  where <math|<cQ>> has been defined as in Section<nbsp><reference|secpn>.
  Hence, the number of states is at most <math|<around|(|k+1|)>*n<rsup|4>>
  which is in <math|<Oh><around|(|n<rsup|4>|)>>.

  Formally, we use a <em|level> for each <math|\<ell\>> with
  <math|0\<leq\>\<ell\>\<leq\>k>, hence there are <math|k+1> levels. By
  <math|<around|[|k|]>> we denote in this paper the set
  <math|<oneset|0<lds>k>>. Define

  <\equation*>
    <cQ><rsub|<cA>>=<set|<around|(|<around|(|p<rsub|1>,p<rsub|2>|)>,q<rsub|1>,q<rsub|2>,\<ell\>|)>\<in\><cQ>\<times\><cQ><rsub|1>\<times\><cQ><rsub|2>\<times\><around|[|k|]>|(p<rsub|1>,p<rsub|2>,q<rsub|1>,q<rsub|2>)<text|is
    a bridge>>
  </equation*>

  as the state space of an NFA called <math|<cA>>.

  We call a state <math|<around|(|<around|(|p<rsub|1>,p<rsub|2>|)>,q<rsub|1>,q<rsub|2>,\<ell\>|)>>
  a <em|bridge at level <math|\<ell\>>>, and we keep in mind that there
  exists a word <math|w> such that <math|p<rsub|1>\<cdot\>w=q<rsub|1>> and
  <math|p<rsub|2>\<cdot\><ov|w>=q<rsub|2>>. Frequently (and by a slight abuse
  of language) we call a state <math|<around|(|<around|(|p<rsub|1>,p<rsub|2>|)>,q<rsub|1>,q<rsub|2>,\<ell\>|)>>
  simply a <em|bridge>, too. Bridges at level <math|\<ell\>> are also denoted
  by <math|<around|(|P,q<rsub|1>,q<rsub|2>,\<ell\>|)>> with
  <math|P=<around|(|p<rsub|1>,p<rsub|2>|)>\<in\><cQ>>,
  <math|q<rsub|i>\<in\>Q<rsub|i>>, <math|i=1,2>, and
  <math|\<ell\>\<in\><around|[|k|]>>. Bridges at different levels play a
  central rle in the following.

  Let <math|a\<in\>\<Sigma\>>. The <math|a>-transitions in the NFA are given
  by the following arcs:

  <alignat*|2|<tformat|<table|<row|<cell|<around|(|P,<space|0.27em>q<rsub|1>\<cdot\><ov|a>,<space|0.27em>q<rsub|2>\<cdot\><ov|a>,0|)>>|<cell|<ras|a>
  <around|(|P\<cdot\>a,<space|0.27em>q<rsub|1>,q<rsub|2>,0|)>>|<cell|<text|for
  >q<rsub|i>\<cdot\><ov|a>\<nin\><cF><rsub|i>,<space|0.17em>i=1,2,>>|<row|<cell|<around|(|P,<space|0.27em>q<rsub|1>\<cdot\><ov|a>,<space|0.27em>q<rsub|2>\<cdot\><ov|a>,0|)>>|<cell|<ras|a>
  <around|(|P\<cdot\>a,<space|0.27em>q<rsub|1>,q<rsub|2>,1|)>>|<cell|<text|for
  >q<rsub|1>\<cdot\><ov|a>\<in\><cF><rsub|1> <text|or
  >q<rsub|2>\<cdot\><ov|a>\<in\><cF><rsub|2>,>>|<row|<cell|<around|(|P,<space|0.27em>q<rsub|1>\<cdot\><ov|a>,<space|0.27em>q<rsub|2>\<cdot\><ov|a>,\<ell\>|)>>|<cell|<ras|a>
  <around|(|P\<cdot\>a,<space|0.27em>q<rsub|1>,q<rsub|2>,\<ell\>+1|)>>|<cell|<text|for
  >1\<leq\>\<ell\>\<less\>k.>>>>>

  Thus, for the <math|P>-component an <math|a>-transition behaves as in a
  usual product automaton, but for the <math|q<rsub|1>>- and
  <math|q<rsub|2>>-components we move backwards using the
  <math|<ov|a>>-transitions in the original automata. This is why the
  resulting automaton <math|<cA>> is <nd>.

  Observe that no state of the form <math|<around|(|P,q<rsub|1>,q<rsub|2>,0|)>>
  with <math|q<rsub|1>\<in\><cF><rsub|1>> or
  <math|q<rsub|2>\<in\><cF><rsub|2>> has an outgoing arc to level zero; we
  must switch to level one. There are no outgoing arcs on level <math|k>, and
  for each tuple <math|<around|(|a,P,q<rsub|1>,q<rsub|2>,\<ell\>|)>\<in\>\<Sigma\>\<times\><cQ>\<times\><cQ><rsub|1>\<times\><cQ><rsub|2>\<times\><around|[|k-1|]>>
  there exists at most one arc <math|<around|(|P,q<rsub|1><rprime|'>,q<rsub|2><rprime|'>,\<ell\>|)><ras|a><around|(|P\<cdot\>a,q<rsub|1>,q<rsub|2>,\<ell\><rprime|'>|)>>.
  Indeed, the <math|P\<cdot\>a> is determined by <math|P> and the letter
  <math|a>, and the triple <math|<around|(|q<rsub|1><rprime|'>,q<rsub|2><rprime|'>,\<ell\><rprime|'>|)>>
  is determined by <math|<around|(|q<rsub|1>,q<rsub|2>,\<ell\>|)>> and the
  letter <math|a>. Not all such arcs exist in <math|<cA>>, because
  <math|<around|(|P,q<rsub|1><rprime|'>,q<rsub|2><rprime|'>,\<ell\>|)>> might
  be a bridge whereas <math|<around|(|P\<cdot\>a,q<rsub|1>,q<rsub|2>,\<ell\><rprime|'>|)>>
  is not. (Observe however that if <math|<around|(|P\<cdot\>a,q<rsub|1>,q<rsub|2>,\<ell\><rprime|'>|)>>
  is a bridge, then <math|<around|(|P,q<rsub|1><rprime|'>,q<rsub|2><rprime|'>,\<ell\>|)>>
  is a bridge, too.)

  The set of initial states <math|<cI>> contains all bridges at level zero of
  the form <math|<around|(|Q<rsub|0>,q<rprime|'><rsub|1>,q<rprime|'><rsub|2>,0|)>>
  with <math|Q<rsub|0>=<around|(|q<rsub|01>,<space|0.17em>q<rsub|02>|)>>. The
  set of final states <math|<cF>> is given by all bridges
  <math|<around|(|P,q<rsub|1>,q<rsub|2>,k|)>> at level <math|k>.

  This concludes the definition of the NFA <math|<cA>>. For an example and a
  graphical presentation of the NFA, see Figure<nbsp><reference|steffen>.

  <\remark>
    <label|rem:prec>By Lemma<nbsp><reference|lem:bridge>, the NFA <math|<cA>>
    can be computed by a <svlstd>. Thus, we have direct access to <math|<cA>>
    and henceforth we assume that <math|<cA>> is also written on the input
    tape.
  </remark>

  <big-figure|<\with|par-mode|center>
    <\latex_preview|begin-tikzpicture>
      \\begin{tikzpicture}[shorten \<gtr\>=1pt,node distance=2cm,auto,initial
      text=,%

      \ \ initial distance=4mm,bend angle=45,scale=.85]

      \ \ \ \ \\tikzstyle{every node}=[scale=.85]

      \ \ \ \ \\tikzstyle{every loop}=[distance=.5cm]

      \t\\node at (0,5.5)\t[state,initial]\t\t(A0)\t\t\t\t\t\t{$q_{01}$};

      \t\\node \t\t\t[state]\t\t\t\t(A1)\t\t[right of=A0]\t{$p_1$};

      \t\\node \t\t\t[state, accepting]\t(A2)\t\t[right of=A1]\t{$f_1$};

      \t\\node \t\t\t[state]\t\t\t\t(A3)\t\t[below of=A1]\t{$\\dead_1$};

      \t\\node\t\t\t[above of=A1,node distance=1.5cm]\t\t\t{$L_1 = a^*(b+
      \\ov b)\\ov a$};

      \;

      \ \ \ \ \\path [-\<gtr\>]\t(A0)\tedge\t[loop
      above]\tnode\t\t\t{$a$}\t\t\t()

      \ \ \ \ \t\t\t\t\tedge\t\t\t\t\tnode\t\t\t{$b,\\ov b$}\t\t(A1)

      \ \ \ \ \t\t\t\t\tedge\t[bend right]\tnode\t[swap]\t{$\\ov a$}\t\t(A3)

      \ \ \ \ \t\t\t(A1)\tedge\t\t\t\t\tnode\t\t\t{$\\ov a$}\t\t(A2)

      \t \ \ \ \t\t\t\tedge\t\t\t\t\tnode\t\t\t{$a,b,\\ov b$}\t(A3)

      \ \ \ \ \t\t\t(A2)\tedge\t[bend left]\t\tnode\t\t\t{$\\Sigma$}\t\t(A3)

      \ \ \ \ \t\t\t(A3)\tedge\t[loop below]\tnode\t\t\t{$\\Sigma$}\t\t();

      \;

      \;

      \ \ \ \ \\node at (7,5.5)\t[state,initial]\t\t(B0)\t\t\t\t\t{$q_{02}$};

      \ \ \ \ \\node\t\t\t[state]\t\t\t\t(B1)\t[right of=B0]\t{$p_2$};

      \ \ \ \ \\node\t\t\t[state, accepting]\t(B2)\t[right of=B1]\t{$f_2$};

      \ \ \ \ \\node\t\t\t[state]\t\t\t\t(B3)\t[below of=B1]\t{$\\dead_2$};

      \t\\node\t\t\t[above of=B1,node distance=1.5cm]\t\t\t{$\\ov{L_2} =
      a^*\\ov b\\ov a$};

      \;

      \ \ \ \ \\path [-\<gtr\>]\t(B0)\tedge\t[loop
      above]\tnode\t\t\t{$a$}\t\t\t()

      \ \ \ \ \t\t\t\t\tedge\t\t\t\t\tnode\t\t\t{$\\ov b$}\t\t(B1)

      \ \ \ \ \t\t\t\t\tedge\t[bend right]\tnode\t[swap]\t{$\\ov a,b$} \t(B3)

      \ \ \ \ \t\t\t(B1)\tedge\t\t\t\t\tnode\t\t\t{$\\ov a$}\t\t(B2)

      \ \ \ \ \t\t\t\t\tedge\t\t\t\t\tnode\t\t\t{$a,b,\\ov b$}\t(B3)

      \ \ \ \ \t\t\t(B2)\tedge\t[bend left]\t\tnode\t\t\t{$\\Sigma$}\t\t(B3)

      \ \ \ \ \t\t\t(B3)\tedge\t[loop below]\tnode\t\t\t{$\\Sigma$}\t\t();

      % \ \\end{tikzpicture}

      %\\end{figure}

      \;

      %

      %\\begin{figure}

      % \ \\centering

      % \ \\begin{tikzpicture}[shorten \<gtr\>=1pt,auto,initial text=]

      \ \ \ \ \\tikzstyle{every state}=[rectangle]

      \ \ \ \ \\tikzstyle{every pin}=[pin distance=4mm]

      \ \ \ \ \\tikzstyle{every pin edge}=[shorten \<less\>=1pt]

      \ \ \ \ \\tikzstyle{init}=[pin={[pin edge={\<less\>-}]170:}]

      \;

      \ \ \ \ \\node at (0,0)\t\t[state,initial]\t\t(A)\t\t{$(Q_0,\\dead_1,\\dead_2,0)$};

      \ \ \ \ \\node at (3,0)\t\t[state,init]\t\t(B)\t\t{$(Q_0,f_1,f_2,0)$};

      \ \ \ \ \\node at (6,0)\t\t[state,accepting]\t(B1)\t{$(Q_0,p_1,p_2,1)$};

      \ \ \ \ \\node at (7.25,0)\t[right]\t\t\t\t\t\t{$B(q_{01},q_{02},p_1,p_2)=
      b$};

      \ \ \ \ \\node at (3,1)\t\t[state,initial]\t\t(C)\t\t{$(Q_0,f_1,\\dead_2,0)$};

      \ \ \ \ \\node at (6,1)\t\t[state,accepting]\t(C1)\t{$(Q_0,p_1,\\dead_2,1)$};

      \ \ \ \ \\node at (7.25,1)\t[right]\t\t\t\t\t\t{$B(q_{01},q_{02},p_1,\\dead_2)=
      aa^+b + a^*\\ov b$};

      \ \ \ \ \\node at (6,2)\t\t[state,accepting]\t(C2)\t{$(Q_0,p_1,f_2,1)$};

      \ \ \ \ \\node at (7.25,2)\t[right]\t\t\t\t\t\t{$B(q_{01},q_{02},p_1,f_2)=
      ab$};

      \ \ \ \ \\node at (3,-1)\t[state,initial]\t\t(D)\t\t{$(Q_0,\\dead_1,f_2,0)$};

      \ \ \ \ \\node at (6,-1)\t[state,accepting]\t(D1)\t{$(Q_0,\\dead_1,p_2,1)$};

      \ \ \ \ \\node at (7.25,-1)\t[right]\t\t\t\t\t\t{$B(q_{01},q_{02},\\dead_1,p_2)=
      b\\ov a\\ov a^+$};

      \ \ \ \ \\node at (6,-2)\t[state,accepting]\t(D2)\t{$(Q_0,f_1,p_2,1)$};

      \ \ \ \ \\node at (7.25,-2)\t[right]\t\t\t\t\t\t{$B(q_{01},q_{02},f_1,p_2)=
      b\\ov a$};

      \ \ \ \ \\node at (-.8,2) \t{$\\cA$:};

      \;

      \;

      \ \ \ \ \\path [-\<gtr\>]\t(A)\tedge\t\t\t\t\t\t\t\t\t\tnode\t\t\t{$a$}\t(B)

      \t\t\t\t\tedge\t[loop,out=125,in=55,distance=1cm]\tnode\t\t
      \t{$a$}\t(A)

      \t\t\t\t\tedge\t\t\t\t\t\t\t\t\t\tnode\t\t\t{$a$}\t(C)

      \t\t\t\t\tedge\t\t\t\t\t\t\t\t\t\tnode\t[swap]\t{$a$}\t(D)

      \t\t\t\t(B)\tedge\t\t\t\t\t\t\t\t\t\tnode\t\t\t{$a$}\t(B1)

      \t\t\t\t(C)\tedge\t\t\t\t\t\t\t\t\t\tnode\t\t\t{$a$}\t(C1)

      \t\t\t\t\tedge\t\t\t\t\t\t\t\t\t\tnode\t\t\t{$a$}\t(C2)

      \t\t\t\t(D)\tedge\t\t\t\t\t\t\t\t\t\tnode\t\t\t{$a$}\t(D1)

      \t\t\t\t\tedge\t\t\t\t\t\t\t\t\t\tnode\t[swap]\t{$a$}\t(D2);

      \ \ \\end{tikzpicture}
    </latex_preview>

    <label|steffen>\ 
  </with>|DFAs for <math|L<rsub|1>> and <math|<ov|L<rsub|2>>> and the
  resulting NFA <math|<cA>> with 4 initial states and 5 final states
  associated to the (<lcf>) <hpc> <math|<ccH>=a<rsup|+>*b<ov|a><rsup|+>\<cup\><around|{|a<rsup|s><ov|b><ov|a><rsup|t>\<mid\>s\<geq\>t\<geq\>1|}>>
  with <math|k=1>. >

  The next result shows the unambiguity of paths in the automaton
  <math|<cA>>. It is a crucial property.

  <\lemma>
    <label|unam>Let <math|w\<in\><Sig><rsup|\<ast\>>> be the label of a path
    in <math|<cA>> from a bridge <math|A=<around|(|P,p<rsub|1>,p<rsub|2>,\<ell\>|)>>
    to <math|A<rprime|'>=<around|(|P<rprime|'>,p<rsub|1><rprime|'>,p<rsub|2><rprime|'>,\<ell\><rprime|'>|)>>,
    then the path is unique. This means that <math|B=B<rprime|'>> whenever
    <math|w=u*v> and

    <align*|<tformat|<table|<row|<cell|A>|<cell|<ras|u>B<ras|v>A<rprime|'>,>|<cell|>|<cell|A<ras|u>B<rprime|'><ras|v>A<rprime|'>.>>>>>
  </lemma>

  <\proof>
    It is enough to consider <math|u=a\<in\><Sig>>. Let
    <math|B=<around|(|Q,q<rsub|1>,q<rsub|2>,m|)>>. Then we have
    <math|Q=P\<cdot\>a> and <math|q<rsub|i>=p<rsub|i><rprime|'>\<cdot\><ov|v>>.
    If <math|\<ell\>=0> and <math|p<rsub|i>\<nin\><cF><rsub|i>> for
    <math|i=1,2>, then <math|m=0>, too; otherwise <math|m=\<ell\>+1>. Thus,
    <math|B> is determined by <math|A>, <math|A<rprime|'>>, and <math|u>,
    <math|v>. We conclude <math|B=B<rprime|'>>.
  </proof>

  We will now show that the automaton <math|<cA>> encodes the hairpin
  completion in a natural way. For languages <math|U> and <math|V> we define
  the language <math|V<rsup|U>> as follows:

  <\equation*>
    V<rsup|U>=<set|u*v<ov|u>|u\<in\>U,<space|0.17em>v\<in\>V>.
  </equation*>

  Clearly, if <math|U> and <math|V> are regular, then <math|V<rsup|U>> is
  <lcf>, but not regular, in general. (The notation <math|V<rsup|U>> is
  adopted from group theory where exponentiation denotes conjugation and the
  canonical involution refers to taking inverses.)

  <\lemma>
    <label|lem:str>For each pair <math|\<tau\>=<around|(|I,F|)>\<in\><cI>\<times\><cF>>
    with <math|F=<around|(|<around|(|d<rsub|1>,d<rsub|2>|)>,e<rsub|1>,e<rsub|2>,k|)>>
    let <math|R<rsub|\<tau\>>> be the (regular) set of words which label a
    path from the initial bridge <math|I> to the final bridge <math|F>, and
    let <math|B<rsub|\<tau\>>=B<around|(|d<rsub|1>,d<rsub|2>,e<rsub|1>,e<rsub|2>|)>>.

    The <hpc><math|<ccH>> is a disjoint union

    <\equation*>
      <ccH>=<big|cup><rsub|\<tau\>\<in\><cI>\<times\><cF>>B<rsub|\<tau\>><rsup|R<rsub|\<tau\>>>.
    </equation*>

    Moreover, for each word <math|w\<in\>B<rsub|\<tau\>><rsup|R<rsub|\<tau\>>>>
    there is a unique factorization <math|w=\<rho\><bet><ov|\<rho\>>> with
    <math|\<rho\>\<in\>R<rsub|\<tau\>>> and
    <math|<bet>\<in\>B<rsub|\<tau\>>>.
  </lemma>

  <\proof>
    Let <math|w\<in\><ccH>>. There exists some factorization <math|w=<gabag>>
    such that <math|<abs|<alp>>=k> and there are runs as in <reffig|firstrun>
    in the original DFAs <math|<cA><rsub|1>> and <math|<cA><rsub|2>> where
    <math|f<rsub|1><rprime|'>\<in\><cF><rsub|1>> or
    <math|f<rsub|2><rprime|'>\<in\><cF><rsub|2>> (or both):

    <\big-figure>
      <align*|<tformat|<table|<row|<cell|L<rsub|1>:<space|1em>>|<cell|q<rsub|01><ras|<gam>>c<rsub|1><rprime|'><ras|<alp>>d<rsub|1><rprime|'><ras|<bet>>e<rsub|1><rprime|'><ras|<ov|<alp>>>f<rsub|1><rprime|'><ras|<ov|<gam>>>q<rsub|1><rprime|'>,>>|<row|<cell|<ov|L<rsub|2>>:<space|1em>>|<cell|q<rsub|02><ras|<gam>>c<rsub|2><rprime|'><ras|<alp>>d<rsub|2><rprime|'><ras|<ov|<bet>>>e<rsub|2><rprime|'><ras|<ov|<alp>>>f<rsub|2><rprime|'><ras|<ov|<gam>>>q<rsub|2><rprime|'>>>>>>

      <label|firstrun>
    </big-figure|Some run defined by <math|w\<in\><ccH>>>

    Choosing among all these runs the length <math|<abs|<ov|<gam>>>> to be
    minimal, we see that we actually find the following picture according to
    <reffig|urun>. In other words, either <math|<gaba>> is the longest prefix
    of <math|w> belonging to <math|L<rsub|1>> or <math|<abag>> is the longest
    suffix of <math|w> belonging to <math|L<rsub|2>>, or both. The difference
    to the precedent figure is is that between <math|f<rsub|i>> and
    <math|q<rprime|'><rsub|i>> (<math|i=1,2>) we never enter a final state.

    <\big-figure>
      <align*|<tformat|<table|<row|<cell|L<rsub|1>:<space|1em>>|<cell|q<rsub|01><ras|<gam>>c<rsub|1><ras|<alp>>d<rsub|1><ras|<bet>>e<rsub|1><ras|<ov|<alp>>>f<rsub|1><RAS|<ov|<gam>>>q<rsub|1><rprime|'>,>>|<row|<cell|<ov|L<rsub|2>>:<space|1em>>|<cell|q<rsub|02><ras|<gam>>c<rsub|2><ras|<alp>>d<rsub|2><ras|<ov|<bet>>>e<rsub|2><ras|<ov|<alp>>>f<rsub|2><RAS|<ov|<gam>>>q<rsub|2><rprime|'>>>>>>

      <label|urun>
    </big-figure|The unique run defined by <math|w\<in\><ccH>> with
    <math|<abs|<ov|<gam>>>> minimal>

    By the definition of the NFA <math|<cA>> we see that
    <math|\<rho\>=<gam><alp>> is the unique prefix of <math|w> such that
    <math|w=\<rho\><bet><ov|\<rho\>>> with
    <math|\<rho\>\<in\>R<rsub|\<tau\>>> and <math|<bet>\<in\>B<rsub|\<tau\>>>
    for some <math|\<tau\>>. Now, as the length <math|<abs|<ov|<gam>>>> is
    fixed by <math|w>, we see that all states <math|c<rsub|i>>,
    <math|d<rsub|i>>, <math|e<rsub|i>>, <math|f<rsub|i>>, and
    <math|q<rsub|i><rprime|'>> are uniquely defined by <math|w> for
    <math|i=1,2>. Thus, there is a unique
    <math|\<tau\>\<in\><cI>\<times\><cF>> with
    <math|w\<in\>B<rsub|\<tau\>><rsup|R<rsub|\<tau\>>>>. More precisely, we
    have:

    <\equation*>
      \<tau\>=<around|(|<around|(|<around|(|q<rsub|01>,q<rsub|02>|)>,q<rsub|1><rprime|'>,q<rsub|2><rprime|'>,0|)>,<space|0.17em><around|(|<around|(|d<rsub|1>,d<rsub|2>|)>,e<rsub|1>,e<rsub|2>,k|)>|)>.
    </equation*>
  </proof>

  <subsection|First Tests><label|test>

  By construction, the automaton <math|<cA>> accepts the union of the
  languages <math|R<rsub|\<tau\>>> as defined in
  Lemma<nbsp><reference|lem:str>. If the accepted language is finite then all
  <math|R<rsub|\<tau\>>> are finite and hence all
  <math|B<rsub|\<tau\>><rsup|R<rsub|\<tau\>>>> are regular. This leads
  immediately to the following result:

  <\proposition>
    <label|prop:onesided>It can be decided in <NL>whether or not the accepted
    language of the NFA <math|<cA>> is finite. If the accepted language is
    finite, then the <hpc><math|<ccH>> is regular.
  </proposition>

  <\proof>
    To see that the accepted language is infinite it is enough to guess a
    path from an initial state to final one which uses some (guessed) state
    at least twice. Since <NL>is closed under complementation the finiteness
    test is possible in <NL>, too. The second assertion follows from
    Lemma<nbsp><reference|lem:str>.
  </proof>

  We check this property (although strictly speaking Test<nbsp>0 is
  redundant):

  <\test|0>
    \ Decide in <NL>whether or not <math|L<around|(|<cA>|)>> is finite. If it
    is finite, then stop with the output that <math|<ccH>> is regular.
  </test>

  For convenience we may assume in the following that <math|<cA>> accepts an
  infinite language and that all states are reachable from an initial bridge
  and lead to some final bridge.

  For sake of completeness let us state another result which shows that
  deciding regularity of the one-sided <hpc>is somewhat easier, because the
  finiteness condition is also necessary in this case. However, as we neither
  use this result nor does it change the <NL>-completeness of the problem, we
  leave the proof of <refprop|prop:trueonesided> to the interested reader.

  <\proposition>
    <label|prop:trueonesided>If <math|L<rsub|1>> or <math|L<rsub|2>> is
    finite, but the accepted language of <math|<cA>> is infinite, then the
    <hpc><math|<ccH>> is not regular.
  </proposition>

  Let <math|K> be the set of non-trivial strongly connected components of the
  automaton <math|<cA>> (read as a directed graph). Every non-trivial
  strongly connected component is on level 0 and, moreover, as <math|<cA>>
  accepts an infinite language, there is at least one. For
  <math|\<kappa\>\<in\>K> let <math|N<rsub|\<kappa\>>> be the number of
  states in the component <math|\<kappa\>>. We have
  <math|N<rsub|\<kappa\>>=<abs|\<kappa\>>\<leq\>n<rsup|4>>.

  The next lemma tells us that for a regular <hpc><math|<ccH>> every strongly
  connected component <math|\<kappa\>\<in\>K> is a simple cycle.

  <\lemma>
    <label|lem:loop>Let the hairpin completion <ccH>be regular,
    <math|A<ras|v<rsub|A>>A> be a path in a strongly connected component
    <math|\<kappa\>> with <math|1\<leq\><abs|v<rsub|A>>\<leq\>N<rsub|\<kappa\>>>,
    and let <math|A<ras|w>F> be a path in <math|<cA>> from <math|A> to a
    final bridge <math|F>. Then the word <math|w> is a prefix of some word in
    <math|v<rsub|A><rsup|+>>.

    In addition, the word <math|v<rsub|A>> is uniquely defined by the
    conditions <math|A<ras|v<rsub|A>>A> and
    <math|1\<leq\><abs|v><rsub|A>\<leq\>N<rsub|\<kappa\>>>. The loop
    <math|A<ras|v<rsub|A>>A> visits every other state <math|B\<in\>\<kappa\>>
    exactly once. Thus it builds a Hamiltonian cycle of <math|\<kappa\>> and
    <math|<abs|v<rsub|A>>=N<rsub|\<kappa\>>>.
  </lemma>

  <\proof>
    Let <math|A<ras|v>A> be some non-trivial loop. We see that <math|A> is on
    level zero. Consider a path labeled by <math|w> from <math|A> to a final
    bridge <math|F=<around|(|<around|(|p<rsub|1>,p<rsub|2>|)>,q<rsub|1>,q<rsub|2>,k|)>>.
    By assumption, all states in <math|<cA>> are reachable from some initial
    state. Thus, we find a word <math|u> such that the automaton <math|<cA>>
    accepts <math|u*v<rsup|i>*w> for all <math|i\<geq\>0>. We see next that
    <math|u*v<rsup|i>*w<bet><ov|w><ov|v><rsup|i><ov|u>\<in\><ccH>> for all
    <math|i\<geq\>0> and all <math|<bet>\<in\>B<around|(|p<rsub|1>,p<rsub|2>,q<rsub|1>,q<rsub|2>|)>>.
    As <math|<ccH>> is regular, there are <math|s,t\<in\><N>> with
    <math|u*v<rsup|s>*w<bet><ov|w><ov|v><rsup|s+t><ov|u>\<in\><ccH>> and
    <math|t\<gtr\><abs|w<bet>>>, by pumping. This means that the <hpc>is
    forced to use a suffix in <math|L<rsub|2>>, because the longest prefix
    belonging to <math|L<rsub|1>> is too short to create the <hpc>. Due to
    the definition of <math|<cA>> we conclude that <math|u*v<rsup|s>*w> must
    be a prefix of <math|u*v<rsup|s+t>*w>. This implies that <math|w> is a
    prefix of <math|v<rsup|t>> and thus the first statement of our lemma.

    Let <math|v<rsub|A>> be some shortest word such that
    <math|A<ras|v<rsub|A>>A>. Observe first that
    <math|<abs|v<rsub|A>>\<leq\>N<rsub|\<kappa\>>>. Now, let
    <math|A\<neq\>B\<in\>\<kappa\>> and <math|A<ras|v<rprime|'>>B<ras|v<rprime|''>>A>.
    For some <math|i,j\<gtr\>0> we have <math|<abs|v<rsub|A><rsup|i>>=<abs|<around|(|v<rprime|'>*v<rprime|''>|)><rsup|j>>>.
    Thus, <math|v<rsub|A><rsup|i>=<around|(|v<rprime|'>*v<rprime|''>|)><rsup|j>>
    by the first statement. By the unique-path-property stated in
    Lemma<nbsp><reference|unam> we obtain that the loop
    <math|A<ras|<around|(|v<rprime|'>*v<rprime|''>|)><rsup|j>>A> just uses
    the shortest loop <math|A<ras|v<rsub|A>>A> several times. In particular,
    <math|B> is on the shortest loop around <math|A>. This yields
    <math|<abs|v<rsub|A>>\<geq\>N<rsub|\<kappa\>>> and hence the second
    statement.
  </proof>

  <\example>
    In the example given in Figure<nbsp><reference|steffen> the state
    <math|<around|(|Q<rsub|0>,<dead><rsub|1>,<dead><rsub|2>,0|)>> forms the
    only strongly connected component and the corresponding path is labeled
    with <math|a>. As one can easily observe the automaton <math|<cA>>
    satisfies the properties stated in Lemma<nbsp><reference|lem:loop> (even
    though the <hpc>is not regular).
  </example>

  Due to the technique of <svlstd>s we may assume that the set of non-trivial
  strongly connected components <math|K> is part of the input. Moreover, for
  each state <math|A> and <math|\<kappa\>\<in\>K> we know whether or not
  <math|A\<in\>\<kappa\>>, and we know <math|N<rsub|\<kappa\>>=<abs|\<kappa\>>>.

  The next test tries to falsify the property of <reflem|lem:loop>. Hence it
  gives a sufficient condition that <math|<ccH>> is not regular.

  <\test|1>
    \ Guess some state <math|A> and <math|\<kappa\>\<in\>K> with
    <math|A\<in\>\<kappa\>>, a letter <math|a\<in\><Sig>>, and a position
    <math|1\<leq\>m\<leq\>N<rsub|\<kappa\>>> such that:

    <\enumerate>
      <item>There is a path <math|A<ras|v>A> where
      <math|m\<leq\><abs|v>\<leq\>N<rsub|\<kappa\>>> and
      <math|v<around|(|m|)>=a>.

      <item>There is a path <math|A<ras|w>F> where
      <math|w*<around|(|i\<cdot\><abs|v>+m|)>\<neq\>a> for some
      <math|i\<in\><N>> with <math|1\<leq\>i\<cdot\><abs|v>+m\<leq\><abs|w>>.
    </enumerate>

    If such a triple <math|<around|(|A,a,m|)>> exists, then output that
    <ccH>is not regular.
  </test>

  The correctness of Test<nbsp>1 follows by Lemma<nbsp><reference|lem:loop>
  and, because for the existence of paths 1.) and 2.) we only have to
  remember the triple <math|<around|(|A,a,m|)>>, Test<nbsp>1 can be performed
  in <NL>.

  <\remark>
    <label|rem:test1>We can perform Test<nbsp>1 in <NL>and in case it yields
    that the hairpin completion <ccH>is not regular, we can stop. Henceforth,
    we assume that the algorithm did not stop during Test<nbsp>1 and that
    every strongly connected component <math|\<kappa\>\<in\>K> is a simple
    cycle. Performing another <svlstd>we may assume that for each
    <math|A\<in\>\<kappa\>> the word <math|v<rsub|A>> is attached to <math|A>
    and each <math|v<rsub|A>> is part of the input.
  </remark>

  <subsection|Second and Third Test><label|test2>

  We fix a bridge <math|A=<around|(|<around|(|p<rsub|1>,p<rsub|2>|)>,q<rsub|1>,q<rsub|2>|)>>
  in a strongly connected component. We let <math|v=v<rsub|A>> as defined in
  Lemma<nbsp><reference|lem:loop> and let <math|<alp>> be the prefix of
  length <math|k> of some long enough word in <math|v<rsup|+>>. (By
  <refrem|rem:test1> the word <math|v> is written in plain form on the input
  tape.) By <math|u> we denote some word leading from an initial bridge to
  <math|A>. (The <NL>algorithm does not know <math|u>, but it knows that it
  exists.) The main idea is to investigate runs through the DFAs for
  <math|L<rsub|1>> and <math|<ov|L<rsub|2>>> where <math|s,t\<geq\>n>
  according to <reffig|otto>. Recall that <math|n> refers to the original
  input size, thus <math|n\<geq\><abs|<cQ><rsub|i>>> for <math|i=1,2>.

  <\big-figure>
    <alignat*|3|<tformat|<table|<row|<cell|>|<cell|L<rsub|1>:>|<cell|<space|1em>>|<cell|q<rsub|01>
    <ras|u> p<rsub|1> <ras|v<rsup|s>> p<rsub|1> <ras|x> c<rsub|1> <ras|y>
    d<rsub|1> <ras|<ov|<alp>>> e<rsub|1> <RAS|<ov|v><rsup|n>>>|<cell|>|<cell|q<rsub|1>
    <RAS|<ov|v><rsup|\<ast\>>> q<rsub|1> <RAS|<ov|u>>
    q<rsub|1><rprime|'>>>|<row|<cell|>|<cell|<ov|L<rsub|2>>:>|<cell|>|<cell|q<rsub|02>
    <ras|u> p<rsub|2> <ras|v<rsup|t>> p<rsub|2> <ras|<alp>> c<rsub|2>
    <ras|<ov|y>> d<rsub|2> <ras|<ov|x>> e<rsub|2>
    <RAS|<ov|v><rsup|n>>>|<cell|>|<cell|q<rsub|2> <RAS|<ov|v><rsup|\<ast\>>>
    q<rsub|2> <RAS|<ov|u>> q<rsub|2><rprime|'>>>>>>

    <label|otto>
  </big-figure|Runs through <math|<cA><rsub|1>> and <math|<cA><rsub|2>> based
  on the loop <math|A<long-arrow|\<rubber-rightarrow\>|<mspace|5*m*u>v<mspace|5*m*u>>A>>

  We investigate the case where <math|u*v<rsup|s>*x*y<ov|<alp>><ov|v><rsup|t><ov|u>\<in\><ccH>>
  for all <math|s\<geq\>t> and where (by symmetry) this property is due to
  the longest prefix belonging to <math|L<rsub|1>> (hence
  <math|e<rsub|1>\<in\><cF><rsub|1>>).

  The following lemma is rather technical. The notations are however chosen
  to fit exactly to <reffig|otto>.

  <\lemma>
    <label|lem:egil>Let <math|x,y\<in\><Sig><rsup|\<ast\>>> be words and
    <math|<around|(|d<rsub|1>,d<rsub|2>|)>\<in\><cQ><rsub|1>\<times\><cQ><rsub|2>>
    with the following properties:

    <\enumerate>
      <item><math|<alp>\<leq\>x> and <math|x\<less\>v<alp>>.

      <item><math|y\<in\>B<around|(|c<rsub|1>,c<rsub|2>,d<rsub|1>,d<rsub|2>|)>>,
      where <math|c<rsub|1>=p<rsub|1>\<cdot\>x> and
      <math|c<rsub|2>=p<rsub|2>\<cdot\><alp>>, and <math|x> is the longest
      common prefix of <math|x*y> and <math|v<alp>>.

      <item><math|e<rsub|1>=d<rsub|1>\<cdot\><ov|<alp>>\<in\><cF><rsub|1>> is
      a final state, <math|q<rsub|1>=e<rsub|1>\<cdot\><ov|v><rsup|n>>, and
      during the computation of <math|e<rsub|1>\<cdot\><ov|v><rsup|n>> we do
      not enter a final state in <math|<cF><rsub|1>>.

      <item><math|e<rsub|2>=d<rsub|2>\<cdot\><ov|x>> and
      <math|q<rsub|2>=e<rsub|2>\<cdot\><ov|v><rsup|n>>. Moreover, during the
      computation of <math|e<rsub|2>\<cdot\><ov|v><rsup|n>> we do not enter a
      final state in <math|<cF><rsub|2>> (but
      <math|e<rsub|2>\<in\><cF><rsub|2>> is possible).
    </enumerate>

    If <math|<ccH>> is regular, then there exists a factorization
    <math|x*y<ov|<alp>><ov|v>=\<mu\><del><bet><ov|<del>><ov|\<mu\>>> where
    <math|<abs|<del>>=k> and <math|p<rsub|2>\<cdot\>\<mu\><del><ov|<bet>><ov|<del>>\<in\><cF><rsub|2>>
    (which implies <math|<del><bet><ov|<del>><ov|\<mu\>><ov|v><rsup|\<ast\>><ov|u><sse>L<rsub|2>>).
  </lemma>

  <\proof>
    The conditions imply that <math|u*v<rsup|s>*x*y<ov|<alp>><ov|v><rsup|t><ov|u>\<in\><ccH>>
    for all <math|s\<geq\>t\<geq\>n>. Moreover, by 3.) the <hpc>can be
    achieved with a prefix in <math|L<rsub|1>> and the longest prefix of
    <math|u*v<rsup|s>*x*y<ov|<alp>><ov|v><rsup|t><ov|u>> belonging to
    <math|L<rsub|1>> is <math|u*v<rsup|s>*x*y<ov|<alp>>>.

    If <math|<ccH>> is regular, then we have
    <math|u*v<rsup|s>*x*y<ov|<alp>><ov|v><rsup|s+1><ov|u>\<in\><ccH>>, too,
    as soon as <math|s> is large enough, by a simple pumping argument. For
    this <hpc>we must use a suffix belonging to <math|L<rsub|2>>. For
    <math|y=<e>> this follows from <math|x\<less\>v<alp>>. For
    <math|y\<neq\><e>> we use <math|x\<less\>v<alp>> and additionally that
    the word <math|x*a> with <math|a=y<around|(|1|)>> is not a prefix of
    <math|v<alp>>.

    By 4.) the longest suffix of <math|u*v<rsup|s>*x*y<ov|<alp>><ov|v><rsup|s+1><ov|u>>
    belonging to <math|L<rsub|2>> is a suffix of
    <math|x*y<ov|<alp>><ov|v><rsup|s+1><ov|u>>. Thus, we can write

    <\equation*>
      u*v<rsup|s>*x*y<ov|<alp>><ov|v><rsup|s+1><ov|u>=u*v<rsup|s>*x*y<ov|<alp>><ov|v><ov|v><rsup|s><ov|u>=u*v<rsup|s>*\<mu\><del><bet><ov|<del>><ov|\<mu\>><ov|v><rsup|s><ov|u>
    </equation*>

    where <math|<del><bet><ov|<del>><ov|\<mu\>><ov|v><rsup|s><ov|u>\<in\>L<rsub|2>>
    and <math|<abs|<del>>=k>. We obtain <math|x*y<ov|<alp>><ov|v>=\<mu\><del><bet><ov|<del>><ov|\<mu\>>>.

    (Recall that our second DFA <math|<cA><rsub|2>> accepts
    <math|<ov|L<rsub|2>>>.) Hence, as <math|p<rsub|2>=q<rsub|02>\<cdot\>u>
    and <math|p<rsub|2>=p<rsub|2>\<cdot\>v>, we see that
    <math|p<rsub|2>\<cdot\>\<mu\><del><ov|<bet>><ov|<del>>\<in\><cF><rsub|2>>.

    We conclude as desired: if <math|<ccH>> is regular, then
    <math|p<rsub|2>\<cdot\>\<mu\><del><ov|<bet>><ov|<del>>\<in\><cF><rsub|2>>.
  </proof>

  <\example>
    Let us take a look at Figure<nbsp><reference|steffen> again. Let
    <math|A=<around|(|Q<rsub|0>,<dead><rsub|1>,<dead><rsub|2>,0|)>>,
    <math|v=a> and <math|u=<e>>. If we choose <math|x=a>, <math|y=<ov|b>> and
    <math|<around|(|d<rsub|1>,d<rsub|2>|)>=<around|(|p<rsub|1>,p<rsub|2>|)>>
    we can see, that conditions 1.) to 4.) of Lemma<nbsp><reference|lem:egil>
    are satisfied but there is no factorization
    <math|a<ov|b><ov|a><ov|a>=\<mu\><del><bet><ov|<del>><ov|\<mu\>>> with
    <math|<abs|<del>>=k> such that <math|<del><bet><ov|<del>><ov|\<mu\>><ov|u>\<in\>L<rsub|2>>.
    Hence, the <hpc>is not regular.
  </example>

  The next lemma yields another sufficient condition that <math|<ccH>> is not
  regular.

  <\lemma>
    <label|lem:final>The existence of words
    <math|x,y\<in\><Sig><rsup|\<ast\>>> and states
    <math|<around|(|d<rsub|1>,d<rsub|2>|)>\<in\><cQ><rsub|1>\<times\><cQ><rsub|2>>
    satisfying 1.) to 4.) of Lemma<nbsp><reference|lem:egil>, but where for
    all factorizations <math|x*y<ov|<alp>><ov|v>=\<mu\><del><bet><ov|<del>><ov|\<mu\>>>
    we have <math|p<rsub|2>\<cdot\>\<mu\><del><ov|<bet>><ov|<del>>\<nin\><cF><rsub|2>>
    can be decided in <NL>.
  </lemma>

  <\proof>
    It is enough to perform either Test<nbsp>2 or<nbsp>3 below
    (non-deterministically chosen) and to prove the <NL>performance of these
    tests. The tests distinguish whether the word <math|y> is empty or
    non-empty.

    <test|2| Decide the existence of a word <math|x\<in\><Sig><rsup|\<ast\>>>
    and states <math|<around|(|d<rsub|1>,d<rsub|2>|)>\<in\><cQ><rsub|1>\<times\><cQ><rsub|2>>
    satisfying 1.) to 4.) of Lemma<nbsp><reference|lem:egil> with
    <math|y=<e>>, but where for all factorizations
    <math|x<ov|<alp>><ov|v>=\<mu\><del><bet><ov|<del>><ov|\<mu\>>> we have
    <math|p<rsub|2>\<cdot\>\<mu\><del><ov|<bet>><ov|<del>>\<nin\><cF><rsub|2>>.
    If we find such a situation, then output that <math|<ccH>> is not
    regular.>

    <test|3| Decide the existence of words
    <math|x,y\<in\><Sig><rsup|\<ast\>>> with <math|y\<neq\><e>> and states
    <math|<around|(|d<rsub|1>,d<rsub|2>|)>\<in\><cQ><rsub|1>\<times\><cQ><rsub|2>>
    satisfying 1.) to 4.) of Lemma<nbsp><reference|lem:egil>, but where for
    all factorizations <math|x*y<ov|<alp>><ov|v>=\<mu\><del><bet><ov|<del>><ov|\<mu\>>>
    we have <math|p<rsub|2>\<cdot\>\<mu\><del><ov|<bet>><ov|<del>>\<nin\><cF><rsub|2>>.
    If we find such a situation, then output that <math|<ccH>> is not
    regular.>

    The correctness of both tests follows by Lemma<nbsp><reference|lem:egil>
    and they can be performed as follows: For both tests we guess the length
    of a word <math|x> which satisfies 1.) and which is therefore a prefix of
    <math|v<alp>>. Thus we can remember <math|x>, because <math|v<alp>> is
    available by the input. We guess states
    <math|<around|(|d<rsub|1>,d<rsub|2>|)>\<in\><cQ><rsub|1>\<times\><cQ><rsub|2>>,
    and verify that conditions 3.) and 4.) hold, which is easy because we can
    reconstruct <math|x>. For Test<nbsp>2 we check that
    <math|p<rsub|1>\<cdot\>x=d<rsub|1>> and
    <math|p<rsub|2>\<cdot\><alp>=d<rsub|2>>. Then we have to test whether for
    all factorizations <math|x<ov|<alp>><ov|v>=\<mu\><del><bet><ov|<del>><ov|\<mu\>>>
    with <math|<abs|<del>>=k> the condition
    <math|p<rsub|2>\<cdot\>\<mu\><del><ov|<bet>><ov|<del>>\<nin\><cF><rsub|2>>
    holds. This can easily be done in <NL>because we have full access to the
    word <math|x<ov|<alp>><ov|v>>.

    Test<nbsp>3 is a bit more tricky. We guess <math|a\<in\><Sig>> and we
    check that <math|x*a> is not a prefix of <math|v<alp>>. We have to verify
    that a path from <math|c<rsub|1>> to <math|d<rsub|1>> exists which is
    labelled by some non-empty word <math|y\<in\>a<Sig><rsup|\<ast\>>> and
    that a path from <math|c<rsub|2>> to <math|d<rsub|2>> exists which is
    labelled by <math|<ov|y>>. This can be achieved by a graph reachability
    algorithm which uses forward edges in the DFA of <math|L<rsub|1>> and
    simultaneously uses backwards edges in the DFA of <math|<ov|L<rsub|2>>>.
    Now, in a factorization <math|x*y<ov|<alp>><ov|v>=\<mu\><del><bet><ov|<del>><ov|\<mu\>>>
    we cannot have that <math|x> is a proper prefix of <math|\<mu\><del>>
    otherwise <math|x*a> would be a prefix of <math|v<alp>>. But this was
    excluded by the choice of <math|a>. Thus, <math|\<mu\><del>> is a prefix
    of <math|x> and <math|<ov|<del>><ov|\<mu\>>> is a suffix of
    <math|<ov|x>>. This means, to ensure that there is no factorization with
    <math|p<rsub|2>\<cdot\>\<mu\><del><ov|<bet>><ov|<del>>\<in\><cF><rsub|2>>,
    we do not need to remember the word <math|y>. We just compute
    <math|d<rsub|2>\<cdot\><ov|x>> and during this computation we validate
    that there are no final states in <math|<cF><rsub|2>> after <math|k> or
    more steps.
  </proof>

  We claim that, if all three tests did not yield that the hairpin completion
  <ccH>is not regular, then the hairpin completion is indeed regular. This
  will complete the proof of Theorem<nbsp><reference|thm:main>.

  <\lemma>
    <label|lem:finaltests>Suppose no outcome of Tests 1, 2, and 3 is \Pnot
    regular\Q. Then the <hpc><math|<ccH>> is regular.
  </lemma>

  <\proof>
    Let <math|\<pi\>\<in\><ccH>>. Write <math|\<pi\>=<gam><alp><bet><ov|<alp>><ov|<gam>>>
    with <math|<abs|<gam>>> minimal such that either
    <math|<gam><alp><bet><ov|<alp>>\<in\>L<rsub|1>> or
    <math|<alp><bet><ov|<alp>><ov|<gam>>\<in\>L<rsub|2>>. By symmetry we
    assume <math|<gam><alp><bet><ov|<alp>>\<in\>L<rsub|1>>. We may also
    assume that <math|<abs|<gam>>\<gtr\>2*n<rsup|4>> (cf.
    Proposition<nbsp><reference|prop:onesided> and Test<nbsp>0). We can
    factorize <math|<gam>=u*v*w> with <math|<abs|u*v>\<leq\>n<rsup|4>> and
    <math|1\<leq\><abs|v>\<leq\><abs|w>> such that there are runs as in
    Figure<nbsp><reference|karl>.

    <\big-figure>
      <alignat*|3|<tformat|<table|<row|<cell|>|<cell|L<rsub|1>:>|<cell|<space|1em>>|<cell|q<rsub|01>
      <ras|u> p<rsub|1> <ras|v> p<rsub|1>
      <ras|w<alp>\<beta\><ov|<alp>>>>|<cell|>|<cell|f<rsub|1> <RAS|<ov|w>>
      q<rsub|1> <RAS|<ov|v>> q<rsub|1> <RAS|<ov|u>>
      q<rsub|1><rprime|'>>>|<row|<cell|>|<cell|<ov|L<rsub|2>>:>|<cell|>|<cell|q<rsub|02>
      <ras|u> p<rsub|2> <ras|v> p<rsub|2>
      <ras|w<alp><ov|\<beta\>><ov|<alp>>>>|<cell|>|<cell|f<rsub|2>
      <RAS|<ov|w>> q<rsub|2> <RAS|<ov|v>> q<rsub|2> <RAS|<ov|u>>
      q<rsub|2><rprime|'>>>>>>

      <label|karl>
    </big-figure|Runs through <math|<cA><rsub|1>> and <math|<cA><rsub|2>> for
    the word <math|\<pi\>>. We assume <math|f<rsub|1>\<in\><cF><rsub|1>>.>

    We infer from Test<nbsp>1 that <math|w<alp>> is a prefix of some word in
    <math|v<rsup|+>>. We may assume that <math|w\<in\>v<rsup|+>> by adjusting
    the choices of <math|u>, <math|v>, and <math|w>. (Possibly, <math|u> gets
    longer but it is still shorter than <math|n<rsup|4>>, <math|v> is
    transposed, and <math|w> gets shorter.)

    Hence, we can write <math|w<alp><bet>=v<rsup|m>*x*y> with
    <math|m\<geq\>0> such that <math|v<rsup|m>*x> is the maximal common
    prefix of <math|w<alp><bet>> and some word in <math|v<rsup|+>> with
    <math|<alp>\<leq\>x\<less\>v<alp>>.

    We see that for some <math|s\<geq\>t\<geq\>0> we can write

    <\equation*>
      \<pi\>=u*v<rsup|s>*x*y<ov|<alp>><ov|v><rsup|t><ov|u>.
    </equation*>

    Moreover, <math|u*v<rsup|s>*x*y<ov|<alp>><ov|v><rsup|t><ov|u>\<in\><ccH>>
    for all <math|s\<geq\>t\<geq\>0>. There are only finitely many choices
    for <math|u,v,x> (due to the lengths bounds) and for each of them there
    is a regular set <math|R<rsub|y>> associated to the finite collection of
    bridges such that

    <\equation*>
      \<pi\>\<in\><set|u*v<rsup|s>*x*R<rsub|y><ov|<alp>><ov|v><rsup|t><ov|u>|s\<geq\>t\<geq\>0><sse><ccH>.
    </equation*>

    More precisely, we can choose <math|R<rsub|y>=<oneset|<e>>> for
    <math|y=<e>>, and otherwise we can choose

    <\equation*>
      R<rsub|y>\<in\><set|B<around|(|c<rsub|1>,c<rsub|2>,d<rsub|1>,d<rsub|2>|)>\<cap\>a<Sig><rsup|\<ast\>>|(c<rsub|1>,c<rsub|2>,d<rsub|1>,d<rsub|2>)<text|is
      a bridge and >\<varspace\>a\<in\><Sig>>.
    </equation*>

    Note that the sets <math|<set|u*v<rsup|s>*x*R<rsub|y><ov|<alp>><ov|v><rsup|t><ov|u>|s\<geq\>t\<geq\>0>>
    are not regular, in general. If we bound however the exponent <math|t> by
    <math|n>, then the finite union

    <\equation*>
      <big|cup><rsub|0\<leq\>t\<leq\>n><set|u*v<rsup|s>*x*R<rsub|y><ov|<alp>><ov|v><rsup|t><ov|u>|s\<geq\>t>
    </equation*>

    becomes regular. Thus, we may assume that <math|t\<gtr\>n>. Let
    <math|e<rsub|2>=p<rsub|2>\<cdot\><alp><ov|y><ov|x>>. We have
    <math|e<rsub|2>\<cdot\><ov|v><rsup|n>=q<rsub|2>> and, if there is a final
    state during the computation of <math|e<rsub|2>\<cdot\><ov|v><rsup|n>>,
    then for all <math|t\<geq\>s\<geq\>n> and <math|y\<in\>R<rsub|y>> we have
    that <math|u*v<rsup|s>*x*y<ov|<alp>><ov|v><rsup|t><ov|u>\<in\><ccH>>, due
    to a suffix in <math|L<rsub|2>>, and <math|u*v<rsup|n>*v<rsup|+>*x*R<rsub|y><ov|<alp>><ov|v><rsup|+><ov|v><rsup|n><ov|u><sse><ccH>>.

    Otherwise Test<nbsp>2 or<nbsp>3 tells us that for all
    <math|y\<in\>R<rsub|y>> the word <math|x*y<ov|<alp>><ov|v>> has a
    factorization <math|\<mu\>*\<delta\>*\<nu\><ov|\<delta\>><ov|\<mu\>>>
    such that <math|<abs|\<delta\>>=k> and
    <math|p<rsub|2>\<cdot\>\<mu\><del><ov|\<nu\>><ov|<del>>\<in\><cF><rsub|2>>.
    The paths <math|q<rsub|02>\<cdot\>u=p<rsub|2>> and
    <math|p<rsub|2>\<cdot\>v=p<rsub|2>> yield
    <math|\<delta\>*\<nu\><ov|\<delta\>><ov|\<mu\>><ov|v><rsup|\<ast\>><ov|u><sse>L<rsub|2>>
    and, again, <math|u*v<rsup|n>*v<rsup|+>*x*R<rsub|y><ov|<alp>><ov|v><rsup|+><ov|v><rsup|n><ov|u><sse><ccH>>.

    The <hpc><math|<ccH>> is a finite union of regular languages and hence it
    is regular itself.
  </proof>

  <section|Conclusion and open problems><label|secopen>

  We have shown that the problem to decide the regularity of
  <hpc><math|<ccH>> for given regular languages <math|L<rsub|1>> and
  <math|L<rsub|2>> is <NL>-complete. In particular it can be solved
  efficiently in parallel with Boolean circuits of polynomial size and
  poly-log depth, because <NL>is contained in <em|Nick's Class>
  <math|<with|font-series|bold|N*C><rsub|2>> (see e.g.
  <cite-detail|pap94|Thm.<nbsp>16.1>).

  Our <NL>-result is based on the fact that the input is given by DFAs
  accepting <math|L<rsub|1>> and <math|<ov|L<rsub|2>>>. It is open, what
  happens if the input is given in a more concise form, say the input is
  given by NFAs accepting <math|L<rsub|1>> and <math|L<rsub|2>> (or
  <math|<ov|L<rsub|2>>>).

  Another result of <cite|DieKop11> says that the time complexity of the same
  problem is in <math|<Oh><around|(|n<rsup|8>|)>>. The full proof of this
  fact is quite involved, and it employs different ideas. It will appear
  elsewhere. It is open whether the <math|<Oh><around|(|n<rsup|8>|)>> time
  bound is optimal. A further improvement on this time bound seems however to
  ask for quite different ideas. So far, the best algorithm known (to us)
  considers all pairs of states in the automaton <math|<cA>>. There are
  <math|\<Omega\><around|(|n<rsup|8>|)>> pairs and it is unclear how to avoid
  this bound.

  There is also a very natural variant of <hpc>which was introduced in
  <cite|DiekertKM09>. It has been called <em|partial hairpin
  completion>\<varspace\>and further investigated in <cite|ManeaMM10>, where
  the operation has been called <em|hairpin lengthening>. The partial hairpin
  completion of <math|L<rsub|1>> and <math|L<rsub|2>> is given by the set of
  words <math|<gam><alp><bet><ov|<alp>><ov|<gam><rprime|'>>>, where
  <math|<gam><rprime|'>> is a prefix <math|<gam>> and
  <math|<gam><alp><bet><ov|<alp>>\<in\>L<rsub|1>> or <math|<gam>> is a prefix
  <math|<gam><rprime|'>> and <math|<alp><bet><ov|<alp>><ov|<gam><rprime|'>>\<in\>L<rsub|2>>.

  Again, the partial <hpc>of a regular language is linear context-free, but
  not regular, in general. It is open whether regularity of the partial
  <hpc>of regular languages is decidable.

  <assign|Ju|<macro|Ju>><assign|Ph|<macro|Ph>><assign|Th|<macro|Th>><assign|Ch|<macro|Ch>><assign|Yu|<macro|Yu>><assign|Zh|<macro|Zh>>

  <\thebibliography|10>
    <bibitem|AlvarezJenner95>C.<nbsp>lvarez and B.<nbsp>Jenner. <newblock>A
    note on logspace optimization. <newblock><with|font-shape|italic|Comput.
    Complex.>, 5:155\U166, April 1995.

    <bibitem|ChepteaMM06>D.<nbsp>Cheptea, C.<nbsp>Martn-Vide, and
    V.<nbsp>Mitrana. <newblock>A new operation on words suggested by DNA
    biochemistry: Hairpin completion. <newblock><with|font-shape|italic|Transgressive
    Computing>, pages 216\U228, 2006.

    <bibitem|garzon1>R.<nbsp>Deaton, R.<nbsp>Murphy, M.<nbsp>Garzon,
    D.<nbsp>Franceschetti, and S.<nbsp>Stevens. <newblock>Good encodings for
    DNA-based solutions to combinatorial problems.
    <newblock><with|font-shape|italic|Proc. of DNA-based computers DIMACS
    Series>, 44:247\U258, 1998.

    <bibitem|DieKop11>V.<nbsp>Diekert and S.<nbsp>Kopecki.
    <newblock>Complexity results and the growths of regular languages
    (extended abstract). <newblock>In M.<nbsp>Domaratzki and K.<nbsp>Salomaa,
    editors, <with|font-shape|italic|CIAA 2010>, number 6482 in Lecture Notes
    in Computer Science, pages 105\U114. Springer-Verlag, 2011.

    <bibitem|DiekertKM09>V.<nbsp>Diekert, S.<nbsp>Kopecki, and
    V.<nbsp>Mitrana. <newblock>On the hairpin completion of regular
    languages. <newblock>In M.<nbsp>Leucker and C.<nbsp>Morgan, editors,
    <with|font-shape|italic|ICTAC>, volume 5684 of
    <with|font-shape|italic|Lecture Notes in Computer Science>, pages
    170\U184. Springer, 2009.

    <bibitem|garzon2>M.<nbsp>Garzon, R.<nbsp>Deaton, P.<nbsp>Neathery,
    R.<nbsp>Murphy, D.<nbsp>Franceschetti, and E.<nbsp>Stevens. <newblock>On
    the encoding problem for DNA computing.
    <newblock><with|font-shape|italic|The Third DIMACS Workshop on DNA-Based
    Computing>, pages 230\U237, 1997.

    <bibitem|garzon3>M.<nbsp>Garzon, R.<nbsp>Deaton, L.<nbsp>Nino,
    S.<nbsp>Stevens Jr., and M.<nbsp>Wittner. <newblock>Genome encoding for
    DNA computing. <newblock><with|font-shape|italic|Proc. Third Genetic
    Programming Conference>, pages 684\U690, 1998.

    <bibitem|HU>J.<nbsp>E. Hopcroft and J.<nbsp>D. Ulman.
    <newblock><with|font-shape|italic|Introduction to Automata Theory,
    Languages and Computation>. <newblock>Addison-Wesley, 1979.

    <bibitem|Ito2010>M.<nbsp>Ito, P.<nbsp>Leupold, F.<nbsp>Manea, and
    V.<nbsp>Mitrana. <newblock>Bounded hairpin completion.
    <newblock><with|font-shape|italic|Information and Computation>, In Press,
    Accepted Manuscript:\U, 2010.

    <bibitem|KariKLST05>L.<nbsp>Kari, S.<nbsp>Konstantinidis,
    E.<nbsp>Losseva, P.<nbsp>Sosk, and G.<nbsp>Thierrin. <newblock>Hairpin
    structures in DNA words. <newblock>In A.<nbsp>Carbone and N.<nbsp>A.
    Pierce, editors, <with|font-shape|italic|DNA>, volume 3892 of
    <with|font-shape|italic|Lecture Notes in Computer Science>, pages
    158\U170. Springer, 2005.

    <bibitem|KariMT07>L.<nbsp>Kari, K.<nbsp>Mahalingam, and G.<nbsp>Thierrin.
    <newblock>The syntactic monoid of hairpin-free languages.
    <newblock><with|font-shape|italic|Acta Inf.>, 44(3-4):153\U166, 2007.

    <bibitem|Kopecki10>S.<nbsp>Kopecki. <newblock>On the iterated hairpin
    completion. <newblock>In Y.<nbsp>Gao, H.<nbsp>Lu, S.<nbsp>Seki, and
    S.<nbsp>Yu, editors, <with|font-shape|italic|Developments in Language
    Theory>, volume 6224 of <with|font-shape|italic|Lecture Notes in Computer
    Science>, pages 438\U439. Springer Berlin / Heidelberg, 2010.

    <bibitem|ManeaMM09>F.<nbsp>Manea, C.<nbsp>Martn-Vide, and
    V.<nbsp>Mitrana. <newblock>On some algorithmic problems regarding the
    hairpin completion. <newblock><with|font-shape|italic|Discrete Applied
    Mathematics>, 157(9):2143\U2152, 2009.

    <bibitem|ManeaMM10>F.<nbsp>Manea, C.<nbsp>Martn-Vide, and
    V.<nbsp>Mitrana. <newblock>Hairpin lengthening. <newblock>In
    F.<nbsp>Ferreira, B.<nbsp>Lwe, E.<nbsp>Mayordomo, and L.<nbsp>M. Gomes,
    editors, <with|font-shape|italic|CiE>, volume 6158 of
    <with|font-shape|italic|Lecture Notes in Computer Science>, pages
    296\U306. Springer, 2010.

    <bibitem|DBLP:conf/cie/ManeaM07>F.<nbsp>Manea and V.<nbsp>Mitrana.
    <newblock>Hairpin completion versus hairpin reduction. <newblock>In
    S.<nbsp>B. Cooper, B.<nbsp>Lwe, and A.<nbsp>Sorbi, editors,
    <with|font-shape|italic|CiE>, volume 4497 of
    <with|font-shape|italic|Lecture Notes in Computer Science>, pages
    532\U541. Springer, 2007.

    <bibitem|ManeaMY09tcs>F.<nbsp>Manea, V.<nbsp>Mitrana, and
    T.<nbsp>Yokomori. <newblock>Two complementary operations inspired by the
    DNA hairpin formation: Completion and reduction.
    <newblock><with|font-shape|italic|Theor. Comput. Sci.>,
    410(4-5):417\U425, 2009.

    <bibitem|ManeaMY10>F.<nbsp>Manea, V.<nbsp>Mitrana, and T.<nbsp>Yokomori.
    <newblock>Some remarks on the hairpin completion.
    <newblock><with|font-shape|italic|Int. J. Found. Comput. Sci.>,
    21(5):859\U872, 2010.

    <bibitem|pap94><Ch>.<nbsp>H. Papadimitriou.
    <newblock><with|font-shape|italic|Computatational Complexity>.
    <newblock>Addison Wesley, 1994.

    <bibitem|KensakuSakamoto05192000>K.<nbsp>Sakamoto, H.<nbsp>Gouzu,
    K.<nbsp>Komiya, D.<nbsp>Kiga, S.<nbsp>Yokoyama, T.<nbsp>Yokomori, and
    M.<nbsp>Hagiya. <newblock>Molecular Computation by DNA Hairpin Formation.
    <newblock><with|font-shape|italic|Science>, 288(5469):1223\U1226, 2000.
  </thebibliography>
</body>