<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <\hide-preamble>
    <assign|chg|<macro|<empty>>>

    <assign|endchg|<macro|<empty>>>

    <assign|comment|<macro|1|<empty>>>

    <assign|subto|<macro|\<hookrightarrow\>>>

    <assign|refeq|<macro|1|(<reference|1>)>>

    <assign|ol|<macro|1|<wide|<arg|1>|\<bar\>>>>

    <assign|the-equation|<macro|<the-section>.<number|<equation-nr>|arabic>>>

    <assign|Set|<macro|<math|<St>>>>

    <assign|FF|<macro|<math|<with|math-font|cal*|F>>>>

    <assign|KK|<macro|<math|<with|math-font|cal*|K>>>>

    <assign|WW|<macro|<math|<with|math-font|cal*|W>>>>

    <assign|AAA|<macro|<math|<with|math-font|cal*|A>>>>

    <assign|SetF|<macro|<math|<St><rsup|<with|math-font|cal*|F>>>>>

    <assign|CC|<macro|<math|<with|math-font|cal*|C>>>>

    <assign|DD|<macro|<math|<with|math-font|cal*|D>>>>

    <assign|fr|<macro|fr>>

    <assign|Gfr|<macro|<math|\<Gamma\><rsub|<kern>-.*5*pt<fr>>>>>

    <assign|rr|<macro|<math|\<bbb-R\>>>>

    <assign|nn|<macro|<math|\<bbb-N\>>>>

    <assign|MM|<macro|<math|\<bbb-M\>>>>

    <assign|TT|<macro|<math|\<bbb-T\>>>>

    <assign|Sig|<macro|<math|\<Sigma\>>>>

    <assign|tecd|<macro|.>>

    <assign|tec|<macro|\<cdot\>>>

    <assign|nsi|<macro|1|<long-arrow|\<rubber-rightarrow\>|<rule|1mm|0mm><arg|1><rule|1mm|0mm>>>>

    <assign|lnsi|<macro|1|<long-arrow|\<rubber-leftarrow\>|<rule|1mm|0mm><arg|1><rule|1mm|0mm>>>>

    <assign|zav|<macro|<math-plus|@>>>

    <assign|ctv|<macro|<math-plus|<move|<math|<with|math-level|1|\<Box\>>>|0pt|.5pt>>>>

    <assign|op|<macro|op>>

    <assign|card|<macro|card>>

    <assign|inr|<macro|<math-ss|inr>>>

    <assign|inl|<macro|<math-ss|inl>>>

    <assign|injection|<macro|<math-ss|in>>>

    <assign|fold|<macro|<math-ss|fold>>>

    <assign|unfold|<macro|<math-ss|unfold>>>

    <assign|curry|<macro|<math-ss|curry>>>

    <assign|obj|<macro|obj>>

    <assign|can|<macro|<math-ss|can>>>

    <assign|Fin|<macro|Fin>>

    <assign|St|<macro|<with|font-series|bold|Set>>>

    <assign|id|<macro|id>>

    <assign|Id|<macro|Id>>

    <assign|Alg|<macro|<with|font-series|bold|Alg>>>

    <assign|PowA|<macro|<with|font-series|bold|Pow><rsub|<space|-0.17em>A>>>

    <assign|cpo|<macro|CPO>>

    <assign|CPO|<macro|<math|<cpo>>>>

    <assign|cpob|<macro|<with|font-series|bold|CPO>>>

    <assign|*|<macro|<colim>>>

    <assign|Kan|<macro|Kan>>

    <assign|Var|<macro|<math-ss|Var>>>

    <assign|spitze|<macro|1|\<langle\><arg|1>,<arg|1>\<rangle\>>>

    <assign|sem|<macro|1|[<space|-0.17em> [ <arg|1>]<space|-0.17em>]>>

    <new-theorem|notation|Notation>

    <assign|pf|<macro|1|body|<trivlist|<\surround>
      <item*|<space|labelsep><with|font-shape|italic|<arg|1>>>
    <|surround|<math|\<Box\>>>
      <arg|body>
    </surround>>>>

    <assign|sketch|<macro|body|<trivlist|<\surround>
      <item*|<space|labelsep><with|font-shape|italic|Sketch of proof.>>
    <|surround|<math|\<Box\>>>
      <arg|body>
    </surround>>>>

    <assign|pst|<macro|<pst@arrowtable>,H-H>>

    <assign|tx|<macro|RHook >>
  </hide-preamble>

  <doc-data|<doc-title|Semantics of Higher-Order Recursion
  Schemes>|<doc-author|<author-data|<author-name|Admek, Milius,
  Velebil>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    <no-indent>Higher-order recursion schemes are recursive equations
    defining new operations from given ones called ``terminals''. Every such
    recursion scheme is proved to have a least interpreted semantics in every
    Scott's model of <math|\<lambda\>>-calculus in which the terminals are
    interpreted as continuous operations. For the uninterpreted semantics
    based on infinite <math|\<lambda\>>-terms we follow the idea of Fiore,
    Plotkin and Turi and work in the category of sets in context, which are
    presheaves on the category of finite sets. <chg>Fiore
    <with|font-shape|italic|et al> showed how to capture the type of variable
    binding in <math|\<lambda\>>-calculus by an endofunctor
    <math|H<rsub|\<lambda\>>> and they explained simultaneous substitution of
    <math|\<lambda\>>-terms by proving that the presheaf of
    <math|\<lambda\>>-terms is an initial <math|H<rsub|\<lambda\>>>-monoid.
    Here we work with the presheaf of <endchg>rational infinite
    <math|\<lambda\>>-terms and prove that this is an initial iterative
    <math|H<rsub|\<lambda\>>>-monoid. We conclude that every guarded
    higher-order recursion scheme has a unique uninterpreted solution in this
    monoid.
  </abstract>>

  <section|Introduction>

  The present paper is a contribution to the study of the semantics of
  recursive definitions using category-theoretic tools and methods. Our goal
  is to present a category-theoretic semantics of higher-order recursion
  schemes in the sense of W.<nbsp>Damm<nbsp><cite|D>. To reach this goal we
  apply the theory of rational monads on a category<nbsp><KK>, developed in
  our previous work<nbsp><cite|AMV1> in order to formalize iteration in
  algebra, to the category

  <\equation*>
    <KK>=<SetF><space|2em><around|(|<FF>=<text|finite sets and functions>|)>
  </equation*>

  of sets in context. We use the approach to <math|\<lambda\>>-calculus based
  on <math|H>-monoids in the category of sets in context due to
  M.<nbsp>Fiore, G.<nbsp>Plotkin and D.<nbsp>Turi<nbsp><cite|FPT>. Our main
  result is a description of the initial iterative <math|H>-monoid as the
  monoid of rational <math|\<lambda\>>-terms, and the fact that in this
  monoid every higher-order recursion scheme has a unique uninterpreted
  solution.

  We now explain the motivation of our paper in more detail. In the
  higher-order semantics we assume a given collection<nbsp><Sig>

  of existing programs of given types (that is, a many-sorted signature of
  \Pterminals\Q). One recursively defines new typed programs
  <math|p<rsub|1>,\<ldots\>,p<rsub|n>> (forming a many-sorted signature of
  \Pnonterminals\Q) using symbols from <math|<Sig>> and
  <math|<around|{|p<rsub|1>,\<ldots\>,p<rsub|n>|}>>. If the recursion only
  concerns application, we can formalize this as a collection of equations

  <\equation>
    <label|hrjj>p<rsub|i>=f<rsub|i>*<space|2em><around|(|i=1,\<ldots\>,n|)>
  </equation>

  whose right-hand sides<nbsp><math|f<rsub|i>> are terms in the signature of
  all terminals and all non-terminals. Such collections are called
  (first-order) <with|font-shape|italic|recursion schemes> and were studied
  in 1970's by various authors, e.g. B.<nbsp>Courcelle, M.<nbsp>Nivat and
  I.<nbsp>Guessarian (see the monograph<nbsp><cite|G> and references there)
  or S.<nbsp>J.<nbsp>Garland and D.<nbsp>C.<nbsp>Luckham<nbsp><cite|GL>.
  Recently, a categorical approach to semantics of first-order recursion
  schemes was presented by S.<nbsp>Milius and L.<nbsp>Moss<nbsp><cite|MM>. In
  the present paper we take a first step in an analogous approach to the
  semantics of <with|font-shape|italic|higher-order recursion schemes> in
  which <math|\<lambda\>>-abstraction is also used as one of the operations.
  That is, a higher-order recursion scheme, as introduced by
  W.<nbsp>Damm<nbsp><cite|D> (see also the recent contributions <cite|Ae>
  and<nbsp><cite|M>) is a collection of equations <math|p<rsub|i>=f<rsub|i>>
  where <math|f<rsub|i>><nbsp>are terms using application and
  <math|\<lambda\>>-abstraction on symbols from<nbsp><math|<Sig>> and
  <math|<around|{|p<rsub|1>,\<ldots\>,p<rsub|n>|}>>. As in<nbsp><cite|MM>, we
  first study the uninterpreted semantics, where the given system is regarded
  as a purely syntactic construct. At this stage the operation symbols in
  <math|\<Sigma\>> as well as <math|\<lambda\>>-abstraction and application
  have no interpretation on actual data. So the semantics is provided by
  formal (infinite) terms. These terms can be represented by rational trees,
  i.<space|0.17em>e., infinite trees having finitely many subtrees. Thus the
  uninterpreted solution assigns to each of the recursive variables
  <math|p<rsub|i>> in<nbsp>(<reference|hrjj>) a rational tree
  <math|p<rsub|i><rsup|\<dag\>>> such that the formal equations become
  identities if we substitute<nbsp><math|p<rsub|i><rsup|\<dag\>>>
  for<nbsp><math|p<rsub|i>> (<math|i=1,\<ldots\>,n>). We assume
  <math|\<alpha\>>-conversion (renaming of bound variables) but no other
  rules in the uninterpreted semantics. We next turn to an interpreted
  semantics. Here a recursion scheme is given together with an interpretation
  of all symbols from <math|\<Sigma\>> as well as
  <math|\<lambda\>>-abstraction and application. <chg>Following
  D.<nbsp>Scott, we interpret the <math|\<lambda\>>-calculus on a CPO, say
  <math|D>. <endchg>The symbols of <math|\<Sigma\>> are interpreted as
  continuous operations on<nbsp><math|D>, and formal
  <math|\<lambda\>>-abstraction and application are the actual
  <math|\<lambda\>>-abstraction and application in the model <math|D>. An
  interpreted solution in<nbsp><math|D> then assigns to
  each<nbsp><math|p<rsub|i>> in the context<nbsp><math|\<Gamma\>> of all free
  variables in<nbsp><eqref|hrjj> an element of
  <math|<cpob><around|(|D<rsup|\<Gamma\>>,D|)>> (continuously giving to each
  assignment of free variables in <math|D<rsup|\<Gamma\>>> an element of
  <math|D>) such that the formal equations in the recursion scheme become
  identities in<nbsp><math|D> when the right-hand sides are interpreted
  in<nbsp><math|D>.

  <\exa>
    <label|jj>The fixed-point operator<nbsp><math|Y> is specified by

    <\equation*>
      Y=\<lambda\>*f.*f*<around|(|Y*f|)>
    </equation*>

    and the uninterpreted semantics is the rational tree

    <\equation>
      <label|rnjj>Y<rsup|\<dag\>>=<space|1em><move|<pstree*|n*o*d*e*s*e*p=3*p*t,l*e*v*e*l*s*e*p=10*m*m,t*r*e*e*s*e*p=18*m*m|<TR|\<lambda\>*f>|<pstree|<TR|<zav>>|<TR|f><pstree|<TR|<zav>>|<pstree|<TR|\<lambda\>*f>|<pstree|<TR|<zav>>|<TR|f><TR|\<ddots\>>>><TR|f>>>>|0pt|25mm>
    </equation>

    (The symbol<nbsp><math|<zav>> makes application explicit.) The
    interpreted solution in <math|D> is the least fixed point operator
    (considered as an element of <math|D>).
  </exa>

  The above example is untyped, and indeed we are only treating the untyped
  case in the present paper since its uninterpreted semantics is technically
  simpler than the typed case; however, the basic ideas of uninterpreted
  semantics are similar. In contrast, the interpreted semantics (based on a
  specified model of <math|\<lambda\>>-calculus with \Pterminal\Q symbols
  interpreted as operations) is more subtle in the untyped case.

  Our main result is that every guarded higher-order recursion scheme has a
  unique uninterpreted solution, and a least interpreted one. This
  demonstrates that the methods for iteration in locally finitely presentable
  categories developed in<nbsp><cite|AMV1> can serve not only for first-order
  iteration, when applied to endofunctors of <math|<Set>>, but also for
  higher-order iteration: it is possible to apply these methods to other
  categories, here the category of sets in context. <vspace|1fn>

  <no-indent><with|font-series|bold|Related Work.> This is an extended and
  revised version of the conference paper<nbsp><cite|AMV2>. In addition to
  the material in that extended abstract we include here the theory of
  iterative monoids in a monoidal category, see Section<nbsp><reference|snc>
  below, and we provide detailed proofs.

  <section|Presheaves as Algebras><label|sd>

  <reset-counter|equation>

  <\notation>
    <label|dj>(1) Throughout the paper a given countably infinite
    set<nbsp><math|<Var>> of variables is assumed. Finite subsets
    <math|\<Gamma\>\<subseteq\><Var>> are called contexts and form a full
    subcategory<nbsp><FF> of<nbsp><Set>. We also assume that a (possibly
    empty) finitary signature<nbsp><Sig> is given.

    When speaking about formulas in context<nbsp><math|\<Gamma\>> we mean
    those that have all free variables in<nbsp><math|\<Gamma\>>. For example,
    <math|\<lambda\>*x<tecd>y*x> is a formula in context
    <math|\<Gamma\>=<around|{|y,y<rprime|'>|}>>.

    (2) The category<nbsp><SetF> of \Pcovariant presheaves\Q on<nbsp><FF>

    is well known to be equivalent to the category of finitary endofunctors
    of<nbsp><Set>. Indeed, every endofunctor<nbsp><math|X> yields the
    presheaf<nbsp><math|X<restriction><FF>>, and conversely, every
    presheaf<nbsp><math|X> in<nbsp><SetF> has a left
    <math|<Kan>><nbsp>extension to a finitary endofunctor of<nbsp><Set>: for
    every set<nbsp><math|M> we have

    <\equation*>
      X<around|(|M|)>=<big|cup>X*i<rsub|\<Gamma\>><around*|[|X<around|(|\<Gamma\>|)>|]>
    </equation*>

    where the union ranges over embeddings
    <math|i<rsub|\<Gamma\>>:\<Gamma\>\<hookrightarrow\>M> of contexts
    <math|\<Gamma\>> into<nbsp><math|M>, and
    <math|X*i<rsub|\<Gamma\>><around|[|X<around|(|\<Gamma\>|)>|]>> denotes
    the image of <math|X*i<rsub|\<Gamma\>>>.

    (3) From now on we speak about presheaves when objects of<nbsp><SetF> are
    meant. The word endofunctor is reserved for endofunctors on<nbsp><SetF>
    throughout our paper.
  </notation>

  <\exa>
    <label|dd>(i) The <with|font-shape|italic|presheaf of variables>,
    <math|V>, is our name for the embedding
    <math|<FF>\<hookrightarrow\><Set>>: <math|V<around|(|\<Gamma\>|)>=\<Gamma\>>.
    As we will see in Section<nbsp><reference|ht>, <math|V><nbsp>is the unit
    of the monoidal operation of substitution.

    <vspace|1fn><no-indent>(ii) <with|font-shape|italic|Free presheaf> on one
    generator of context<nbsp><math|\<Gamma\>> is our name for the
    representable presheaf

    <\equation*>
      <FF>(\<Gamma\>,-).
    </equation*>

    Indeed, the Yoneda lemma states that this presheaf is freely generated by
    the element<nbsp><rsub|<math|\<Gamma\>>> of
    context<nbsp><math|\<Gamma\>>: for every presheaf<nbsp><math|X> and every
    <math|x\<in\>X<around|(|\<Gamma\>|)>> there exists a unique morphism
    <math|f:<FF><around|(|\<Gamma\>,-|)>\<to\>X> with
    <math|f<rsub|\<Gamma\>><around|(|<rsub|\<Gamma\>>|)>=x>. Observe that
    <math|<FF><around|(|\<Gamma\>,-|)>><nbsp>is naturally isomorphic to the
    functor <math|X\<mapsto\>X<rsup|n>>, where <math|n=<card>\<Gamma\>> is
    the power of<nbsp><math|\<Gamma\>>. Consequently a free presheaf on
    <math|k><nbsp>generators in contexts <math|\<Gamma\><rsub|1>,\<ldots\>,\<Gamma\><rsub|k>>
    has the form

    <\equation*>
      \<Gamma\>\<mapsto\>\<Gamma\><rsup|n<rsub|1>>+\<ldots\>+\<Gamma\><rsup|n<rsub|k>>,<space|2em><text|where
      <math|n<rsub|i>=<card>\<Gamma\><rsub|i>>.>
    </equation*>

    This is the ``polynomial presheaf''<nbsp><math|X<rsub|<Sig>>> of a
    signature<nbsp><Sig>

    of <math|k><nbsp>operation symbols of the given
    arities<nbsp><math|n<rsub|i>>.

    <vspace|1fn><no-indent>(iii) The <with|font-shape|italic|presheaf<nbsp><math|F<rsub|\<lambda\>>>
    of (finite) <math|\<lambda\>>-terms> is defined via a quotient since we
    want to treat <math|\<lambda\>>-terms always modulo
    <math|\<alpha\>>-conversion. <chg>We first consider the set of all
    <math|\<lambda\>>-trees<nbsp><math|\<tau\>> given by the grammar

    <\equation>
      <label|add>\<tau\><math-plus|:\<assign\>>x\<mid\>\<tau\><zav>\<tau\>\<mid\>\<lambda\>*y<tecd>\<tau\>*<space|2em><around|(|x,y\<in\><Var>|)>.
    </equation>

    In the graphic form:

    <\equation>
      <label|rdj>

      <\latex_preview|begin-pspicture>
        <\text>
          \\begin{pspicture}(0,0)

          \\pscirclebox[linewidth=.5pt,framesep=1.5pt]{$x$}

          \\end{pspicture}
        </text>
      </latex_preview>

      <space|2em><text|or><space|1em><move|<pstree*|l*e*v*e*l*s*e*p=10*m*m,t*r*e*e*s*e*p=10*m*m|<TR|<move|<rule|0*p*t|12*p*t>|0pt|-3pt><zav>>|<pstree|<Tp><nbsp><around|[|t*n*p*o*s=b,t*n*s*e*p=5*m*m|]>*\<tau\>|<Tfan>><pstree|<Tp><nbsp><around|[|t*n*p*o*s=b,t*n*s*e*p=5*m*m|]>*\<tau\><rprime|'>|<Tfan>>>|0pt|10mm><space|2em><text|or><space|2em><move|<pstree*|l*e*v*e*l*s*e*p=10*m*m,t*r*e*e*s*e*p=10*m*m|<TR|<move|<rule|0*p*t|12*p*t>|0pt|-3pt>\<lambda\>*y>|<pstree|<Tp><nbsp><around|[|t*n*p*o*s=b,t*n*s*e*p=5*m*m|]>*\<tau\>|<Tfan>>>|0pt|10mm>
    </equation>

    <vspace|2mm>The notions of a free and bound variable of a
    <math|\<lambda\>>-tree <math|\<tau\>> are defined as usual.

    As explained in<nbsp><cite|FPT>, the following approach is equivalent to
    defining <math|\<lambda\>>-terms up to <math|\<alpha\>>-equivalence by de
    Bruijn levels: We first denote by<nbsp><math|F<rprime|'><rsub|\<lambda\>><around|(|\<Gamma\>|)>>
    the set of all finite <math|\<lambda\>>-trees with free variables in the
    context <math|\<Gamma\>=<around|{|x<rsub|1>,\<ldots\>,x<rsub|n>|}>>.
    <endchg>We then define the presheaf <math|F<rsub|\<lambda\>>> in context
    <math|\<Gamma\>> by

    <\equation*>
      F<rsub|\<lambda\>><around|(|\<Gamma\>|)>=F<rprime|'><rsub|\<lambda\>><around|(|\<Gamma\>|)>/\<sim\><rsub|\<alpha\>>
    </equation*>

    where <math|\<sim\><rsub|\<alpha\>>><nbsp>represents the
    <math|\<alpha\>>-conversion: this is the least congruence with
    <math|\<lambda\>*y<tecd>\<tau\>\<sim\><rsub|\<alpha\>>\<lambda\>*z<tecd>\<tau\><around*|[|<move|<math|z>|0pt|2pt><mid|/><move|<math|y>|0pt|-2pt>|]>>,
    <chg>where <math|z> is not a free variable of <math|\<tau\>>. And we
    define <math|F<rsub|\<lambda\>>> on morphisms
    <math|\<gamma\>:\<Gamma\>\<to\>\<Gamma\><rprime|'>> by choosing a term
    <math|t\<in\>F<rsub|\<lambda\>><around|(|\<Gamma\>|)>>, relabelling all
    bound variables so that they do not lie in <math|\<Gamma\><rprime|'>>,
    and denoting by <math|F<rsub|\<lambda\>>*\<gamma\><around|(|t|)>> the
    term obtained by relabelling every free variable <math|x\<in\>\<Gamma\>>
    to <math|\<gamma\><around|(|x|)>\<in\>\<Gamma\><rprime|'>>. <endchg>

    We call the congruence classes of finite <math|\<lambda\>>-trees modulo
    <math|\<alpha\>>-conversion <em|finite <math|\<lambda\>>-terms>.
    <chg>(Finite <math|\<lambda\>>-trees do not form a presheaf, due to
    possible clashes of bound and free variables. For example consider the
    <math|\<lambda\>>-tree

    <\equation*>
      <xy><POS><around|(|000,000|)>\<ast\>+\<lambda\>*x="*r*",<around|(|000,-10|)>\<ast\>+<zav>="*a*",(-05,-20)\<ast\>+x="*x*",<around|(|005,-20|)>\<ast\>+y="*y*"<ar@|->"*r*";"*a*"<ar@|->"*a*";"*x*"<ar@|->"*a*";"*y*"<endxy>
    </equation*>

    in <math|F<rsub|\<lambda\>><rprime|'><around|{|<space|0.17em>y<space|0.17em>|}>>
    and the function <math|j:<around|{|<space|0.17em>y<space|0.17em>|}>\<to\>\<Gamma\>>
    with <math|x\<in\>\<Gamma\>> and <math|j<around|(|y|)>=x>. Then to define
    the action of <math|F<rsub|\<lambda\>><rprime|'>> on <math|j> we must
    rename the bound variable <math|x> to some <math|z\<nin\>\<Gamma\>>. But
    in fact, any other renaming to <math|z<rprime|'>\<nin\>\<Gamma\>> is
    fine, too. So trying to define the action of
    <math|F<rsub|\<lambda\>><rprime|'>> on functions naturally forces us to
    consider equivalence classes modulo <math|\<alpha\>>-conversion.)
    <endchg>

    <vspace|1fn><no-indent>(iv) The <em|presheaf
    <math|F<rsub|\<lambda\>,<Sig>>> of finite
    <math|\<lambda\>>-<math|\<Sigma\>>-terms> is defined analogously: in
    <eqref|add> we just add the term <math|\<sigma\><around|(|\<tau\><rsub|1>,\<ldots\>,\<tau\><rsub|n>|)>>
    for every <math|n>-ary operation symbol <math|\<sigma\>\<in\><Sig>>, and
    in<nbsp><eqref|rdj> the corresponding tree.

    <vspace|1fn><no-indent>(v) The presheaf <math|T<rsub|\<lambda\>>> of all
    (finite and infinite) <em|<math|\<lambda\>>-terms> is defined analogously
    to <math|F<rsub|\<lambda\>>>. We first denote by
    <math|T<rprime|'><rsub|\<lambda\>><around|(|\<Gamma\>|)>> the set of all
    trees<nbsp><eqref|rdj> dropping the assumption of finiteness. Then we use
    <math|\<alpha\>>-conversion: for infinite trees <math|t> and
    <math|t<rprime|'>> we write

    <\equation*>
      t\<sim\><rsub|\<alpha\>>t<rprime|'>
    </equation*>

    if their (finite) cuttings at level <math|k> (with label <math|\<bot\>>
    for all leaves at level <math|k>) are <math|\<alpha\>>-equivalent in the
    above sense for all <math|k\<in\><nn>>. (We can formalize this by using
    <math|\<Sigma\><rsub|\<bot\>>=\<Sigma\>\<cup\><around|{|<space|0.17em>\<bot\><space|0.17em>|}>>
    with <math|\<bot\>> a constant symbol outside of
    <math|<Sig>\<cup\><Var>>). The presheaf <math|T<rsub|\<lambda\>>> is
    defined on objects <math|\<Gamma\>> by
    <math|T<rsub|\<lambda\>><around|(|\<Gamma\>|)>=T<rsub|\<lambda\>><rprime|'><around|(|\<Gamma\>|)>/<math-ordinary|\<sim\><rsub|\<alpha\>>>>
    and on morphisms <math|\<gamma\>:\<Gamma\>\<to\>\<Gamma\><rprime|'>> by
    relabellings of variables as in<nbsp>(iii). Observe that since
    <math|<Var>\<setminus\>\<Gamma\>> is infinite, the relabelling of bound
    variables needed here causes no problem.

    <vspace|1fn><no-indent>(vi) The presheaf<nbsp><math|R<rsub|\<lambda\>>>
    of <em|rational <math|\<lambda\>>-terms> is also defined analogously.
    Recall that a tree is called <with|font-shape|italic|rational> if it has
    up to isomorphism only finitely many subtrees. We denote by
    <math|R<rsub|\<lambda\>><rprime|'><around|(|\<Gamma\>|)>> the set of all
    rational trees in <math|T<rsub|\<lambda\>><rprime|'><around|(|\<Gamma\>|)>>
    and define a presheaf <math|R<rsub|\<lambda\>>> by
    <math|R<rsub|\<lambda\>><around|(|\<Gamma\>|)>=R<rsub|\<lambda\>><rprime|'><around|(|\<Gamma\>|)>/<math-ordinary|\<sim\><rsub|\<alpha\>>>>
    on objects, and by relabellings of variables (as in<nbsp>(iii)) on
    morphisms. Observe that, by definition, every rational
    <math|\<lambda\>>-term <math|t> is represented by a rational
    <math|\<lambda\>>-tree. However, <math|t> can also be represented by
    non-rational <math|\<lambda\>>-trees<emdash>for example, if it contains
    infinitely many <math|\<lambda\>>'s, the <math|\<alpha\>>-conversion can
    introduce an infinite number of bound variables.

    <vspace|1fn><no-indent>(vii) The presheaves
    <math|T<rsub|\<lambda\>,\<Sigma\>>> (of all
    <math|\<lambda\>>-<Sig>-terms) and <math|R<rsub|\<lambda\>,<Sig>>> (of
    rational <math|\<lambda\>>-<Sig>-terms) are obvious modifications
    of<nbsp>(iv) and<nbsp>(v): one adds to <eqref|add> and<nbsp><eqref|rdj>
    the case <math|\<sigma\><around|(|\<tau\><rsub|1>,\<ldots\>,\<tau\><rsub|n>|)>>
    for all <math|n>-ary symbols <math|\<sigma\>\<in\><Sig>> and all
    (rational) <math|\<lambda\>>-<Sig>-trees
    <math|\<tau\><rsub|1>,\<ldots\>,\<tau\><rsub|n>>.
  </exa>

  <\notation>
    <label|dt>We denote by <math|\<delta\>:<SetF>\<to\><SetF>> the
    endofunctor defined by

    <\equation*>
      \<delta\>*X<around|(|\<Gamma\>|)>=X*<around|(|\<Gamma\>+1|)>.
    </equation*>

    Observe that <math|\<delta\>><nbsp>preserves limits and colimits.

    Note that an algebra for<nbsp><math|\<delta\>> is a
    presheaf<nbsp><math|Y> together with an operation
    <math|Y*<around|(|\<Gamma\>+1|)>\<to\>Y<around|(|\<Gamma\>|)>> for all
    contexts<nbsp><math|\<Gamma\>>\Vthis is precisely the form of
    <math|\<lambda\>>-abstraction, where to a formula <math|f>
    in<nbsp><math|Y*<around|(|\<Gamma\>+<around|{|y|}>|)>> we assign
    <math|\<lambda\>*y<tecd>f> in<nbsp><math|Y<around|(|\<Gamma\>|)>>. The
    other <math|\<lambda\>>-operation, application, is simply a presheaf
    morphism <math|X\<times\>X\<to\>X>, that is, a binary operation
    on<nbsp><math|X>. We put these two together:
  </notation>

  <\notation>
    <label|dc>Let <math|H<rsub|\<lambda\>>><nbsp>denote the endofunctor
    of<nbsp><SetF> given by

    <\equation*>
      H<rsub|\<lambda\>>*X=X\<times\>X+\<delta\>*X.
    </equation*>

    Thus, an algebra for<nbsp><math|H<rsub|\<lambda\>>> is a
    presheaf<nbsp><math|X> together with operations of application
    <math|X<around|(|\<Gamma\>|)>\<times\>X<around|(|\<Gamma\>|)>\<to\>X<around|(|\<Gamma\>|)>>
    and abstraction <math|X*<around|(|\<Gamma\>+1|)>\<to\>X<around|(|\<Gamma\>|)>>
    for all contexts<nbsp><math|\<Gamma\>>; these operations are compatible
    with the renaming of free variables.
  </notation>

  <\exa>
    <label|dp>The presheaves <math|F<rsub|\<lambda\>>>,
    <math|T<rsub|\<lambda\>>> and<nbsp><math|R<rsub|\<lambda\>>> are algebras
    for<nbsp><math|H<rsub|\<lambda\>>> in the obvious sense.
  </exa>

  <\rem>
    <label|ds>(i) The slice category<nbsp><math|V/<SetF>> of
    presheaves<nbsp><math|X> together with a morphism <math|i:V\<to\>X> is
    called the category of <with|font-shape|italic|pointed presheaves>. For
    example <math|F<rsub|\<lambda\>>> is a pointed presheaf in a canonical
    sense: <math|i<rsup|F>:V\<to\>F<rsub|\<lambda\>>> takes a
    variable<nbsp><math|x> to the term<nbsp><math|x>. Analogously
    <math|i<rsup|T>:V\<to\>T<rsub|\<lambda\>>> and
    <math|i<rsup|R>:V\<to\>R<rsub|\<lambda\>>> are pointed presheaves, and so
    are <math|F<rsub|\<lambda\>,<Sig>>>, <math|R<rsub|\<lambda\>,<Sig>>> and
    <math|T<rsub|\<lambda\>,<Sig>>>.

    (ii) Recall that the category<nbsp><math|<Alg>H<rsub|\<lambda\>>> of
    algebras for<nbsp><math|H<rsub|\<lambda\>>> has as morphisms the usual
    <math|H<rsub|\<lambda\>>>-homomorphisms, i.e., a morphism from
    <math|a:H<rsub|\<lambda\>>*X\<to\>X> to
    <math|b:H<rsub|\<lambda\>>*Y\<to\>Y> is a natural transformation
    <math|f:X\<to\>Y> such that <math|f<tec>a=b<tec>H<rsub|\<lambda\>>*f>.
    Then <math|<Alg>H<rsub|\<lambda\>>><nbsp>is a concrete category
    over<nbsp><SetF> with the forgetful functor
    <math|<around|(|H<rsub|\<lambda\>>*X\<to\>X|)>\<mapsto\>X>.
  </rem>

  <\thm|see <cite|FPT>>
    <label|dss>The presheaf<nbsp><math|F<rsub|\<lambda\>>> of finite
    <math|\<lambda\>>-terms is the free <math|H<rsub|\<lambda\>>>-algebra
    on<nbsp><math|V>.
  </thm>

  <\defi|see <cite|AMV1>>
    <label|do>Given an endofunctor<nbsp><math|H>, an algebra
    <math|a:H*A\<to\>A> is called

    (1) <with|font-shape|italic|completely iterative> (cia for short) if for
    every object<nbsp><math|X> (of variables) and every (flat equation)
    morphism <math|e:X\<to\>H*X+A> there exists a unique
    <with|font-shape|italic|solution> which means a unique morphism
    <math|e<rsup|\<dag\>>:X\<to\>A> such that the square below commutes

    <\equation>
      <label|rdd><vcenter|<tformat|<table|<row|<cell|<xymatrix@C>+1*p*cX<ar*|r><rsup|e<rsup|\<dag\>>><ar*|d><rsub|e>>|<cell|A>>|<row|<cell|H*X+A<ar*|r><rsub|H*e<rsup|\<dag\>>+>>|<cell|H*A+A<ar*|u><rsub|<around|[|a,|]>>>>>>>
    </equation>

    (2) <with|font-shape|italic|iterative> if every equation morphism
    <math|e:X\<to\>H*X+A> with <math|X><nbsp>finitely presentable has a
    unique solution <math|e<rsup|\<dag\>>:X\<to\>A>.
  </defi>

  We are going to characterize finitely presentable presheaves in
  Theorem<nbsp><reference|hdjj>. In practice, we are interested only in
  equations using free presheaves (on polynomial endofunctors of<nbsp><Set>)
  as<nbsp><math|X>, but including the more general concept does not
  \Pdisturb\Q anything as we explain in Remark<nbsp><reference|td>.

  <\exa>
    <label|ndoa>As proved in<nbsp><cite|nn>, Corollary<nbsp>6.3, the free
    completely iterative algebra for an arbitrary finitary
    endofunctor<nbsp><math|H> on an object<nbsp><math|X> is precisely the
    terminal coalgebra for <math|H(-)+X>. More detailed, suppose
    <math|T*X><nbsp>is the terminal coalgebra for <math|H(-)+X>, then its
    structure morphism is an isomorphism by Lambek's Lemma and the inverse of
    this morphism has the components

    <\equation*>
      \<tau\><rsup|<phantom|T>><rsub|X>:H*T*X\<to\>T*X*<space|2em><text|and><space|2em>\<eta\><rsup|T><rsub|X>:X\<to\>T*X
    </equation*>

    making<nbsp><math|T*X> a free cia on<nbsp><math|X>.

    Conversely, let <math|\<tau\><rsup|<phantom|T>><rsub|X>:H*T*X\<to\>T*X>
    be a cia which is free on<nbsp><math|X> w.r.t. the universal
    arrow<nbsp><math|\<eta\><rsup|T><rsub|X>>. Then
    <math|<around|[|\<tau\><rsup|<phantom|T>><rsub|X>,\<eta\><rsup|T><rsub|X>|]>:H*T*X+X\<to\>T*X>
    is an isomorphism, and its inverse is the structure of the terminal
    coalgebra for <math|H(-)+X>.
  </exa>

  <\thm>
    <label|ddv>The presheaf<nbsp><math|T<rsub|\<lambda\>>> of infinite
    <math|\<lambda\>>-terms is the free completely iterative
    <math|H<rsub|\<lambda\>>>-algebra on<nbsp><math|V>.
  </thm>

  <\proof>
    As explained in Example<nbsp><reference|ndoa> above, the free completely
    iterative algebra for<nbsp><math|H<rsub|\<lambda\>>> on<nbsp><math|V> is
    precisely the terminal coalgebra for <math|H<rsub|\<lambda\>>(-)+V>. The
    latter functor clearly preserves limits of
    <math|\<omega\><rsup|<value|op>>>-chains. Consequently, its terminal
    coalgebra is a limit of the chain<nbsp><math|W> with <math|W<rsub|0>=1>
    (the terminal presheaf) and <math|W<rsub|n+1>=H<rsub|\<lambda\>>*W<rsub|n>+V>,
    where the connecting maps are the unique
    <math|w<rsub|0>:W<rsub|1>\<to\>W<rsub|0>> and
    <math|w<rsub|n+1>=H<rsub|\<lambda\>>*w<rsub|n>+<rsub|V>>.

    <chg>Observe first that the limit of <math|W> is computed objectwise. So
    for every context<nbsp><math|\<Gamma\>> we can
    identify<nbsp><math|W<rsub|0><around|(|\<Gamma\>|)>> with the
    set<nbsp><math|{\<perp\>}> where <math|\<perp\>\<nin\><Var>>, and we have

    <\equation*>
      W<rsub|n+1><around|(|\<Gamma\>|)>=W<rsub|n><around|(|\<Gamma\>|)>\<times\>W<rsub|n><around|(|\<Gamma\>|)>+W<rsub|n>*<around|(|\<Gamma\>+1|)>+\<Gamma\>.
    </equation*>

    An easy induction proof now shows that
    <endchg><math|W<rsub|n><around|(|\<Gamma\>|)>><nbsp>can be identified
    with the set of all <math|\<lambda\>>-terms in context <math|\<Gamma\>>
    of depth at most<nbsp><math|n> having all leaves of depth<nbsp><math|n>
    labelled by<nbsp><math|\<perp\>>. And
    <math|w<rsub|n+1>:W<rsub|n+1>\<to\>W<rsub|n>> cuts away the
    level<nbsp><math|n+1> in the trees of<nbsp><math|W<rsub|n+1><around|(|\<Gamma\>|)>>,
    relabelling level-<math|n> leaves by<nbsp><math|\<perp\>>. With this
    identification we obtain<nbsp><math|T<rsub|\<lambda\>>> as a limit
    of<nbsp><math|W<rsub|n>> where the limit maps
    <math|T<rsub|\<lambda\>>\<to\>W<rsub|n>> cut the trees
    in<nbsp><math|T<rsub|\<lambda\>><around|(|\<Gamma\>|)>> at
    level<nbsp><math|n> and relabel level-<math|n> leaves
    by<nbsp><math|\<perp\>>.
  </proof>

  <\exa>
    <label|nedv>The complete iterativity of the
    algebra<nbsp><math|T<rsub|\<lambda\>>> means that we are able to solve
    systems of recursive equations such as

    <\equation>
      <label|eq:system><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|p<rsub|1>>|<cell|=>|<cell|p<rsub|1><zav><around|(|\<lambda\>*x<tecd>p<rsub|2>|)>>>|<row|<cell|p<rsub|2>>|<cell|=>|<cell|y<zav>p<rsub|1>.>>>>>
    </equation>

    Indeed, the solution in<nbsp><math|T<rsub|\<lambda\>><around|(|<around|{|y|}>|)>>
    is formed by the <math|\<lambda\>>-terms represented by the following
    trees <math|<wide|t|^><rsub|1>> and<nbsp><math|<wide|t|^><rsub|2>>:

    <\equation*>
      <wide|t|^><rsub|1>=<move|<pstree*|n*o*d*e*s*e*p=3*p*t,l*e*v*e*l*s*e*p=10*m*m,t*r*e*e*s*e*p=12*m*m|<TR|<zav>>|<pstree|<TR|<zav>>|<pstree|<TR|<zav>>|<TR|.<move|.|0pt|4pt><move|.|0pt|8pt>><pstree|<TR|\<lambda\>*x>|<pstree|<TR|<zav>>|<TR|y|<pstree|<TR|<zav>>|<pstree|<TR|<zav>>|<pstree|<TR|<zav>>|<pstree|<TR|<move|\<vdots\>|0pt|-5pt>>|>>><TR|<move|.|0pt|8pt><move|.|0pt|4pt>.>>>>>><pstree|<TR|\<lambda\>*x>|<pstree|<TR|<zav>>|<TR|y|<pstree|<TR|<zav>>|<pstree|<TR|<zav>>|<pstree|<TR|<zav>>|<pstree|<TR|<move|\<vdots\>|0pt|-5pt>>|>>><TR|<move|.|0pt|8pt><move|.|0pt|4pt>.>>>>>><pstree|<TR|\<lambda\>*x>|<pstree|<TR|<zav>>|<TR|y|<pstree|<TR|<zav>>|<pstree|<TR|<zav>>|<pstree|<TR|<zav>>|<pstree|<TR|<move|\<vdots\>|0pt|-5pt>>|>>><TR|<move|.|0pt|8pt><move|.|0pt|4pt>.>>>>>>|0pt|25mm><space|1em><wide|t|^><rsub|2>=<space|1em><move|<pstree*|l*e*v*e*l*s*e*p=10*m*m,t*r*e*e*s*e*p=10*m*m|<TR|<move|<rule|0*p*t|12*p*t>|0pt|-3pt><zav>>|<TR|<move|<math|y>|0pt|-8pt><rule|8*p*t|0*p*t>><pstree|<Tp><nbsp><around|[|t*n*p*o*s=b,t*n*s*e*p=5*m*m|]>*<wide|t|^><rsub|1>|<Tfan>>>|0pt|10mm>
    </equation*>

    How is this related to the above concept of
    Definition<nbsp><reference|do>? Firstly, every system of recursive
    equations can be flattened: a flat system has in
    context<nbsp><math|\<Gamma\>> the right-hand sides of only three types:
    <math|p<rsub|i><zav>p<rsub|j>> or <math|\<lambda\>*x<tecd>p<rsub|i>> or a
    term in<nbsp><math|T<rsub|\<lambda\>><around|(|\<Gamma\>|)>>. For
    example, we flatten the system<nbsp><refeq|eq:system> to

    <\equation>
      <label|eq:sysflat><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|p<rsub|1>>|<cell|=>|<cell|p<rsub|1><zav>p<rsub|3>>>|<row|<cell|p<rsub|2>>|<cell|=>|<cell|p<rsub|4><zav>p<rsub|1>>>|<row|<cell|p<rsub|3>>|<cell|=>|<cell|\<lambda\>*x<tecd>p<rsub|2>>>|<row|<cell|p<rsub|4>>|<cell|=>|<cell|y>>>>>
    </equation>

    Let <math|\<Gamma\>=<around|{|y|}>> be the context of all free variables
    and let <math|X><nbsp>be the free presheaf on generators
    <math|p<rsub|1>,\<ldots\>,p<rsub|4>> of context<nbsp><math|\<Gamma\>>,
    see Example<nbsp><reference|dd>. <chg>Notice that even though the
    recursion variables <math|p<rsub|1>,\<ldots\>,p<rsub|4>> appear as
    constants in the system<nbsp><refeq|eq:sysflat>, the associated presheaf
    <math|X> is not a constant presheaf. Using the Yoneda lemma, the above
    system<nbsp><refeq|eq:sysflat> <endchg>defines an obvious morphism

    <\equation*>
      e:X\<to\>H<rsub|\<lambda\>>*X+T<rsub|\<lambda\>>
    </equation*>

    viz, the unique one such that <math|e<rsub|\<Gamma\>><around|(|p<rsub|i>|)>><nbsp>is
    the right-hand side of the equation above. The solution

    <\equation*>
      e<rsup|\<dag\>>:X\<to\>T<rsub|\<lambda\>>
    </equation*>

    is the unique morphism such that <math|e<rsup|\<dag\>><rsub|\<Gamma\>>>
    takes<nbsp><math|p<rsub|i>> to the solution
    in<nbsp><math|T<rsub|\<lambda\>>>; for example
    <math|e<rsup|\<dag\>><rsub|\<Gamma\>><around|(|p<rsub|1>|)>=<around|[|<wide|t|^><rsub|1>|]>>
    for the above tree<nbsp><math|<wide|t|^><rsub|1>>. We will see in
    Theorem<nbsp><reference|hncss> below that equations such
    as<nbsp><eqref|eq:sysflat> have a unique solution yielding rational
    trees.
  </exa>

  <\rem>
    <label|nrmdv>Given an equation morphism

    <\equation*>
      e:X\<to\>H<rsub|\<lambda\>>*X+T<rsub|\<lambda\>>
    </equation*>

    then the solution <math|e<rsup|\<dag\>>:X\<to\>T<rsub|\<lambda\>>> allows
    us to choose, for every element<nbsp><math|p>
    of<nbsp><math|X<around|(|\<Gamma\>|)>>, a
    tree<nbsp><math|<wide|t|^><rsub|p>> in
    <math|T<rsub|\<lambda\>><around|(|\<Gamma\>|)>> with

    <\equation*>
      e<rsup|\<dag\>><rsub|\<Gamma\>><around|(|p|)>=<around|[|<wide|t|^><rsub|p>|]>.
    </equation*>

    Due to the commutativity of<nbsp><eqref|rdd> for
    <math|H<rsub|\<lambda\>>*X=X\<times\>X+\<delta\>*X> we have three
    possible cases for every<nbsp><math|p>:

    (a) <math|e<rsub|\<Gamma\>><around|(|p|)>=<around|(|p<rsub|1>,p<rsub|2>|)>>
    in <math|X<around|(|\<Gamma\>|)>\<times\>X<around|(|\<Gamma\>|)>>, then
    for the operation <math|\<tau\>:H<rsub|\<lambda\>>*T<rsub|\<lambda\>>\<to\>T<rsub|\<lambda\>>>
    we have

    <\equation*>
      <around|[|<wide|t|^><rsub|p>|]>=\<tau\><around*|(|<around|[|<wide|t|^><rsub|p<rsub|1>>|]>,<around|[|<wide|t|^><rsub|p<rsub|2>>|]>|)>
    </equation*>

    in other words,

    <\equation*>
      <wide|t|^><rsub|p>\<sim\><rsub|\<alpha\>><move|<pstree*|n*o*d*e*s*e*p=3*p*t,l*e*v*e*l*s*e*p=15*m*m|<TR|<zav>>|<TR|<wide|t|^><rsub|p<rsub|1>>><TR|<wide|t|^><rsub|p<rsub|2>>>>|0pt|7mm>
    </equation*>

    (b) <math|e<rsub|\<Gamma\>><around|(|p|)>=q> in
    <math|X*<around|(|\<Gamma\>+<around|{|x|}>|)>>, then

    <\equation*>
      <around|[|<wide|t|^><rsub|p>|]>=\<tau\><around*|(|<around|[|<wide|t|^><rsub|q>|]>|)>
    </equation*>

    in other words

    <\equation*>
      <wide|t|^><rsub|q>\<sim\><rsub|\<alpha\>><move|<pstree*|n*o*d*e*s*e*p=3*p*t,l*e*v*e*l*s*e*p=15*m*m|<TR|\<lambda\>*x>|<TR|<wide|t|^><rsub|p>>>|0pt|7mm>
    </equation*>

    or

    (c) <math|e<rsub|\<Gamma\>><around|(|p|)>><nbsp>lies
    in<nbsp><math|T<rsub|\<lambda\>><around|(|\<Gamma\>|)>> and is
    represented by<nbsp><math|<wide|t|^><rsub|p>>:

    <\equation*>
      e<rsup|\<dag\>><rsub|\<Gamma\>><around|(|p|)>=<around|[|<wide|t|^><rsub|p>|]>=e<rsub|\<Gamma\>><around|(|p|)>.
    </equation*>
  </rem>

  <\rem>
    <label|djn>We are going to characterize the
    presheaf<nbsp><math|R<rsub|\<lambda\>>> as a free iterative algebra
    for<nbsp><math|H<rsub|\<lambda\>>>. That is, in equations we admit only
    presheaves<nbsp><math|X> of variables that are
    <with|font-shape|italic|finitely presentable>. Recall that an
    object<nbsp><math|X> of a category<nbsp><math|<WW>> is
    <with|font-shape|italic|finitely presentable> provided that its
    <math|hom>-functor <math|<WW><around|(|X,-|)>> preserves filtered
    colimits. We are first going to characterize the finitely presentable
    presheaves by using the following concept:
  </rem>

  <\defi|see <cite|AMV2>>
    <label|ndfdjj>A presheaf<nbsp><math|X> is called
    <with|font-shape|italic|super-finitary> provided that
    each<nbsp><math|X<around|(|\<Gamma\>|)>> is finite and there exists a
    nonempty context<nbsp><math|\<Gamma\><rsub|0>>
    <with|font-shape|italic|generating<nbsp><math|X>> in the sense that for
    every nonempty context<nbsp><math|\<Gamma\>> we have

    <\equation>
      <label|rdt>X<around|(|\<Gamma\>|)>=<big|cup><rsub|\<gamma\>:\<Gamma\><rsub|0>\<to\>\<Gamma\>>X*\<gamma\><around*|[|X<around|(|\<Gamma\><rsub|0>|)>|]>.
    </equation>
  </defi>

  <\exa>
    <label|plus>A signature<nbsp><Sig> defines the polynomial
    presheaf<nbsp><math|X<rsub|<Sig>>>, see Example<nbsp><reference|dd>(ii),
    by <math|X<rsub|<Sig>><around|(|\<Gamma\>|)>=<big|coprod><rsub|\<sigma\>\<in\><Sig>>\<Gamma\><rsup|<math-up|ar><around|(|\<sigma\>|)>>>.
    This is a super-finitary presheaf iff <Sig><nbsp>is a finite signature.
    Other super-finitary presheaves are precisely the quotients
    of<nbsp><math|X<rsub|<Sig>>> with <Sig><nbsp>finite.
  </exa>

  <\thm>
    <label|hdjj>A presheaf in<nbsp><SetF> is finitely presentable iff it is
    super-finitary.
  </thm>

  <\proof>
    (1) Let <math|X><nbsp>be a super-finitary presheaf and let
    <math|\<Gamma\><rsub|0>><nbsp>be a context of <math|n><nbsp>variables
    generating<nbsp><math|X>. We prove that <math|X><nbsp>is a finite colimit
    of representables. Since representables are (due to Yoneda lemma) clearly
    finitely presentable, this proves finite presentability of<nbsp><math|X>.

    Form the finite diagram of all presheaves

    <\equation*>
      Z<rsub|a>=<FF><around|(|\<Gamma\>,-|)>
    </equation*>

    where <math|\<Gamma\>\<subseteq\>\<Gamma\><rsub|0>+\<Gamma\><rsub|0>> is
    a context of at most <math|2*n><nbsp>variables<footnote|The reason why we
    need <math|2*n> variables will become clear in<nbsp><eqref|nnrdss>
    below.> and <math|a\<in\>X<around|(|\<Gamma\>|)>>. The connecting
    morphisms are the Yoneda transformations

    <\equation*>
      Y*f:Z<rsub|a>\<to\>Z<rsub|a<rprime|'>>*<space|2em><text|for
      <math|a\<in\>X<around|(|\<Gamma\>|)>> and
      >a<rprime|'>\<in\>X<around|(|\<Gamma\><rprime|'>|)>
    </equation*>

    where <math|f:\<Gamma\><rprime|'>\<to\>\<Gamma\>> is a function that
    fulfils <math|X*f<around|(|a<rprime|'>|)>=a>. The Yoneda transformations

    <\equation*>
      z<rsub|a>:Z<rsub|a>\<to\>X,<space|1em><text|with the components defined
      by><space|1em>f\<mapsto\>X*f<around|(|a|)>,
    </equation*>

    clearly form a compatible cocone of this finite diagram. We prove that
    this is a colimit cocone. In other words, for every
    context<nbsp><math|<wide|\<Gamma\>|\<bar\>>> we must prove that the
    cocone of all <math|<wide|\<Gamma\>|\<bar\>>>-components<nbsp><math|z<rsub|a><rsup|<wide|\<Gamma\>|\<bar\>>>>
    (sending elements <math|f:\<Gamma\>\<to\><wide|\<Gamma\>|\<bar\>>> of
    <math|Z<rsub|a>=<FF><around|(|\<Gamma\>,-|)>>
    to<nbsp><math|X*f<around|(|a|)>>) is a colimit in<nbsp><math|<Set>>. For
    that we only need to verify that in every
    context<nbsp><math|<wide|\<Gamma\>|\<bar\>>>

    <\enumerate>
      <item*|(i)>the cocone<nbsp><math|z<rsub|a><rsup|<wide|\<Gamma\>|\<bar\>>>>
      is collectively epimorphic
    </enumerate>

    and

    <\enumerate>
      <item*|(ii)>whenever two elements <math|f:\<Gamma\>\<to\><wide|\<Gamma\>|\<bar\>>>
      of<nbsp><math|Z<rsub|a>> and <math|f<rprime|'>:\<Gamma\><rprime|'>\<to\><wide|\<Gamma\>|\<bar\>>>
      of<nbsp><math|Z<rsub|a<rprime|'>>> fulfil
      <math|z<rsub|a><rsup|<wide|\<Gamma\>|\<bar\>>><around|(|f|)>=z<rsub|a<rprime|'>><rsup|<wide|\<Gamma\>|\<bar\>>><around|(|f<rprime|'>|)>>,
      then there exists a zig-zag connecting <math|f>
      and<nbsp><math|f<rprime|'>> in the <math|<wide|\<Gamma\>|\<bar\>>>-component
      of our diagram.
    </enumerate>

    The proof of<nbsp>(i) is trivial: given an element
    <math|a\<in\>X<around|(|<wide|\<Gamma\>|\<bar\>>|)>>, either
    <math|<wide|\<Gamma\>|\<bar\>>=\<emptyset\>> or by
    Equation<nbsp><eqref|rdt> there exists
    <math|f:\<Gamma\><rsub|0>\<to\><wide|\<Gamma\>|\<bar\>>> and an element
    <math|b\<in\>X<around|(|\<Gamma\><rsub|0>|)>> with
    <math|a=X*f<around|(|b|)>>, in other words,

    <\equation*>
      a=z<rsub|b><rsup|<wide|\<Gamma\>|\<bar\>>><around|(|f|)>.
    </equation*>

    In case <math|<wide|\<Gamma\>|\<bar\>>=\<emptyset\>> we have
    <math|a=z<rsub|a><rsup|<wide|\<Gamma\>|\<bar\>>><around|(|<rsub|\<emptyset\>>|)>>.

    To prove<nbsp>(ii), observe that the given equation states

    <\equation*>
      X*f<around|(|a|)>=X*f<rprime|'><around|(|a<rprime|'>|)>.
    </equation*>

    In case <math|<wide|\<Gamma\>|\<bar\>>><nbsp>has at most
    <math|2*n><nbsp>variables, we can assume
    <math|<wide|\<Gamma\>|\<bar\>>\<subseteq\>\<Gamma\><rsub|0>+\<Gamma\><rsub|0>>
    and the desired zig-zag is

    <\equation*>
      Z<rsub|a><lnsi|Y*f>Z<rsub|b><nsi|Y*f<rprime|'>>Z<rsub|a<rprime|'>>,
    </equation*>

    where <math|b=X*f<around|(|a|)>>. Thus, we can assume that
    <math|<wide|\<Gamma\>|\<bar\>>><nbsp>has more than
    <math|2*n><nbsp>elements.

    Case<nbsp>1: <math|\<Gamma\>=\<emptyset\>=\<Gamma\><rprime|'>>. Here
    <math|f=f<rprime|'>> and we have <math|X*f<around|(|a|)>=X*f<around|(|a<rprime|'>|)>>.
    Choose a monomorphism <math|m:\<Gamma\><rsub|0>\<to\><wide|\<Gamma\>|\<bar\>>>
    and observe that <math|f=m<tec>g> for the unique
    <math|g:\<emptyset\>\<to\>\<Gamma\><rsub|0>>. Thus
    <math|X*m*<around|(|X*g<around|(|a|)>|)>=X*m*<around|(|X*g<around|(|a<rprime|'>|)>|)>>
    and since <math|m><nbsp>is a split monomorphism, we conclude
    <math|X*g<around|(|a|)>=X*g<around|(|a<rprime|'>|)>=c>. The desired
    zig-zag is

    <\equation*>
      Z<rsub|a><lnsi|Y*g>Z<rsub|c><nsi|Y*g<rprime|'>>Z<rsub|a<rprime|'>>.
    </equation*>

    Case<nbsp>2: <math|\<Gamma\>=\<emptyset\>\<neq\>\<Gamma\><rprime|'>>.
    Factorize<nbsp><math|f<rprime|'>> as an epimorphism<nbsp><math|e>
    followed by a split monomorphism<nbsp><math|m>:

    <\equation*>
      <psmatrix|c*o*l*s*e*p=20*m*m|<tformat|<table|<row|<cell|\<Gamma\><rprime|'>>|<cell|>|<cell|<wide|\<Gamma\>|\<bar\>>>>|<row|<cell|>|<cell|\<Gamma\><rsub|1><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,3><rsup|f<rprime|'>><ncline|-\<gtr\>\<gtr\>|1,1|2,2>\<less\>e<ncline|\<gtr\>-\<gtr\>|2,2|1,3>\<gtr\>m>|<cell|>>>>>
    </equation*>

    Then, since for the unique <math|h:\<emptyset\>\<to\>\<Gamma\><rsub|1>>
    we have <math|f=m<tec>h>, we obtain

    <\equation*>
      X*m*<around*|(|X*e<around|(|a<rprime|'>|)>|)>=X*m*<around*|(|X*h<around|(|a|)>|)>.
    </equation*>

    Thus, <math|X*e<around|(|a<rprime|'>|)>=X*h<around|(|a|)>=c> which yields
    the zig-zag

    <\equation*>
      Z<rsub|a><lnsi|Y*h>Z<rsub|c><nsi|Y*e>Z<rsub|a<rprime|'>>.
    </equation*>

    Case<nbsp>3: <math|\<Gamma\>\<neq\>\<emptyset\>\<neq\>\<Gamma\><rprime|'>>.
    Find <math|g:\<Gamma\><rsub|0>\<to\>\<Gamma\>> with
    <math|a=X*g<around|(|b|)>> and <math|g<rprime|'>:\<Gamma\><rsub|0>\<to\>\<Gamma\><rprime|'>>
    with <math|a<rprime|'>=X*g<rprime|'><around|(|b<rprime|'>|)>> for some
    <math|b,b<rprime|'>\<in\>X<around|(|\<Gamma\><rsub|0>|)>>. Then
    <math|X<around|(|f<tec>g|)><around|(|b|)>=X<around|(|f<rprime|'><tec>g<rprime|'>|)><around|(|b<rprime|'>|)>>.
    Now factorize <math|<around|[|f<tec>g,f<rprime|'><tec>g<rprime|'>|]>:\<Gamma\><rsub|0>+\<Gamma\><rsub|0>\<to\><wide|\<Gamma\>|\<bar\>>>
    as an epimorphism followed by a split monomorphism; so we obtain a
    commutative diagram

    <\equation>
      <label|nnrdss><move|<psmatrix|c*o*l*s*e*p=20*m*m|<tformat|<table|<row|<cell|\<Gamma\><rsub|0>+\<Gamma\><rsub|0>>|<cell|>|<cell|<wide|\<Gamma\>|\<bar\>>>>|<row|<cell|>|<cell|\<Gamma\><rsub|1><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,3><rsup|<around|[|f<tec>g,f<rprime|'><tec>g<rprime|'>|]>><ncline|-\<gtr\>\<gtr\>|1,1|2,2>\<less\><around|[|e,e<rprime|'>|]><ncline|\<gtr\>-\<gtr\>|2,2|1,3>\<gtr\>m>|<cell|>>>>>|0pt|-10mm>
    </equation>

    Since <math|m><nbsp>is a split monomorphism, conclude that
    <math|X*e<around|(|b|)>=X*e<rprime|'><around|(|b<rprime|'>|)>=c>. The
    desired zig-zag is

    <\equation*>
      <psmatrix|c*o*l*s*e*p=20*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|Z<rsub|a>>|<cell|>|<cell|Z<rsub|a<rprime|'>>>>|<row|<cell|Z<rsub|b>>|<cell|>|<cell|Z<rsub|b<rprime|'>>>>|<row|<cell|>|<cell|Z<rsub|c><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|2,1>\<less\>Y*g<ncline|1,3|2,3>\<gtr\>Y*g<rprime|'><ncline|3,2|2,1>\<less\>Y*e<ncline|3,2|2,3>\<gtr\>Y*e<rprime|'>>|<cell|>>>>>
    </equation*>

    (2) Let <math|X><nbsp>be a finitely presentable object of<nbsp><SetF>.
    The empty maps are denoted by <math|t<rsub|\<Gamma\>>:\<emptyset\>\<to\>\<Gamma\>>.
    For every nonempty context<nbsp><math|\<Gamma\><rsub|0>> let
    <math|X<rsub|\<Gamma\><rsub|0>>><nbsp>be the subfunctor of<nbsp><math|X>
    generated by the elements of <math|X<around|(|\<Gamma\><rsub|0>|)>\<cup\>X<around|(|\<emptyset\>|)>>:
    it assigns to every<nbsp><math|\<Gamma\>> the subset
    of<nbsp><math|X<around|(|\<Gamma\>|)>> given by

    <\equation*>
      X<rsub|\<Gamma\><rsub|0>><around|(|\<Gamma\>|)>=X*t<rsub|\<Gamma\>><around*|[|X<around|(|\<emptyset\>|)>|]>\<cup\><big|cup><rsub|f:\<Gamma\><rsub|0>\<to\>\<Gamma\>>X*f<around*|[|X<around|(|\<Gamma\><rsub|0>|)>|]>.
    </equation*>

    We obviously have a union

    <\equation*>
      X=<big|cup><rsub|\<Gamma\><rsub|0>\<in\><FF>\<setminus\><around|{|\<emptyset\>|}>>X<rsub|\<Gamma\><rsub|0>>
    </equation*>

    which is directed: given nonempty contexts<nbsp><math|\<Gamma\><rsub|0>,\<Gamma\><rsub|1>>
    then <math|X<rsub|\<Gamma\><rsub|0>>\<cup\>X<rsub|\<Gamma\><rsub|1>>\<subseteq\>X<rsub|\<Gamma\><rsub|0>\<cup\>\<Gamma\><rsub|1>>>.
    Since <math|X><nbsp>is finitely presentable, the morphism

    <\equation*>
      <rsub|X>:X\<to\><colim><rsub|\<Gamma\><rsub|0>\<in\><FF>\<setminus\><around|{|\<emptyset\>|}>>X<rsub|\<Gamma\><rsub|0>>
    </equation*>

    factorizes through one of the colimit injections
    <math|X<rsub|\<Gamma\><rsub|0>>\<hookrightarrow\>X>. In other words

    <\equation*>
      X=X<rsub|\<Gamma\><rsub|0>><space|2em><text|for some
      <math|\<Gamma\><rsub|0>\<neq\>\<emptyset\>>.>
    </equation*>

    It remains to prove that the sets <math|X<around|(|\<Gamma\><rsub|0>|)>>
    and<nbsp><math|X<around|(|\<emptyset\>|)>> are finite, then
    every<nbsp><math|X<around|(|\<Gamma\>|)>> is finite.

    For every finite set <math|M\<subseteq\>X<around|(|\<emptyset\>|)>> we
    have the subfunctor<nbsp><math|X<rsup|M>> of<nbsp><math|X> equal
    to<nbsp><math|X> on nonempty objects and maps, and
    assigning<nbsp><math|M> to<nbsp><math|\<emptyset\>>. We obviously
    get<nbsp><math|X> as a directed union of these
    subfunctors<nbsp><math|X<rsup|M>>, thus, as above, there
    exists<nbsp><math|M> with <math|X=X<rsup|M>>. Then
    <math|X<around|(|\<emptyset\>|)>=M> is finite.

    For every finite set <math|M\<subseteq\>X<around|(|\<Gamma\><rsub|0>|)>>
    we have the subfunctor<nbsp><math|<rsup|M><space|-0.17em>X> of
    <math|X=X<rsub|\<Gamma\><rsub|0>>> generated by the elements of
    <math|M\<cup\>X<around|(|\<emptyset\>|)>>:

    <\equation*>
      <rsup|M><space|-0.17em>X<around|(|\<Gamma\>|)>=X*t<rsub|\<Gamma\>><around*|[|X<around|(|\<emptyset\>|)>|]>\<cup\><big|cup><rsub|f:\<Gamma\><rsub|0>\<to\>\<Gamma\>>X*f<around|[|M|]>.
    </equation*>

    Again <math|X><nbsp>is a directed union of these
    subfunctors<nbsp><math|<rsup|M><space|-0.17em>X>, thus, there
    exists<nbsp><math|M> with <math|X=<rsup|M><space|-0.17em>X>, proving that
    <math|X<around|(|\<Gamma\><rsub|0>|)>> is finite.
  </proof>

  <\thm>
    <label|hdjt>The presheaf<nbsp><math|R<rsub|\<lambda\>>> of rational
    <math|\<lambda\>>-terms is the free iterative
    <math|H<rsub|\<lambda\>>>-algebra on<nbsp><math|V>.
  </thm>

  <\proof>
    (I) <math|R<rsub|\<lambda\>>><nbsp>is an iterative algebra
    for<nbsp><math|H<rsub|\<lambda\>>>. Indeed, given an equation morphism

    <\equation*>
      e:X\<to\>H<rsub|\<lambda\>>*X+R<rsub|\<lambda\>>
    </equation*>

    where Equation<nbsp><eqref|rdt> holds for<nbsp><math|\<Gamma\><rsub|0>>,
    we know that its extension

    <\equation*>
      <wide|e|\<bar\>>:X<nsi|e>H<rsub|\<lambda\>>*X+R<rsub|\<lambda\>>\<hookrightarrow\>H<rsub|\<lambda\>>*X+T<rsub|\<lambda\>>
    </equation*>

    has a unique solution <math|e<rsup|\<dag\>>:X\<to\>T<rsub|\<lambda\>>>,
    and we are going to prove that the trees
    <math|e<rsup|\<dag\>><rsub|\<Gamma\><rsub|0>><around|(|p|)>>
    and<nbsp><math|e<rsup|\<dag\>><rsub|\<emptyset\>><around|(|p|)>> are all
    rational. It then follows that all the
    trees<nbsp><math|e<rsup|\<dag\>><rsub|\<Gamma\>><around|(|p|)>> are
    rational for all contexts<nbsp><math|\<Gamma\>>, and this gives us the
    desired solution <math|X\<to\>R<rsub|\<lambda\>>>. Indeed, for each
    <math|x\<in\>X<around|(|\<Gamma\>|)>> with
    <math|\<Gamma\>\<neq\>\<emptyset\>> we have <math|x=X*f<around|(|p|)>>
    for some <math|f:\<Gamma\><rsub|0>\<to\>\<Gamma\>> and
    <math|p\<in\>X<around|(|\<Gamma\><rsub|0>|)>>. Then
    <math|e<rsup|\<dag\>><rsub|\<Gamma\>><around|(|x|)>=e<rsup|\<dag\>><rsub|\<Gamma\>>*<around|(|X*f<around|(|p|)>|)>=T<rsub|\<lambda\>>*f<around|(|e<rsup|\<dag\>><rsub|\<Gamma\><rsub|0>><around|(|p|)>|)>>
    by the naturality of<nbsp><math|e<rsup|\<dag\>>>, and since
    <math|e<rsup|\<dag\>><rsub|\<Gamma\><rsub|0>><around|(|p|)>><nbsp>is
    rational, so is<nbsp><math|T<rsub|\<lambda\>>*f<around|(|e<rsup|\<dag\>><rsub|\<Gamma\><rsub|0>><around|(|p|)>|)>>.
    (The action of<nbsp><math|T<rsub|\<lambda\>>*f> is just relabelling
    leaves according to<nbsp><math|f>.)

    Now every element of <math|X<around|(|\<Gamma\><rsub|0>|)>=<around|{|p<rsub|1>,\<ldots\>,p<rsub|n>|}>>
    yields an element

    <\equation*>
      e<rsub|\<Gamma\><rsub|0>><around|(|p<rsub|i>|)>\<in\>X<around|(|\<Gamma\><rsub|0>|)>\<times\>X<around|(|\<Gamma\><rsub|0>|)>+X*<around*|(|\<Gamma\><rsub|0>+<around|{|x|}>|)>+R<rsub|\<lambda\>><around|(|\<Gamma\><rsub|0>|)>
    </equation*>

    which is either (i)<nbsp>a pair <math|<around|(|p<rsub|j>,p<rsub|k>|)>>
    or (ii) <math|q\<in\>X*<around|(|\<Gamma\><rsub|0>+<around|{|x|}>|)>> or
    (iii)<nbsp>a rational tree in<nbsp><math|R<rsub|\<lambda\>><around|(|\<Gamma\><rsub|0>|)>>.
    Put <math|t<rsub|i>=e<rsup|\<dag\>><rsub|\<Gamma\><rsub|0>><around|(|p<rsub|i>|)>>,
    then in the last case the commutativity of Diagram<nbsp><eqref|rdd>
    implies that <math|e<rsub|\<Gamma\><rsub|0>><around|(|p<rsub|i>|)>=t<rsub|i>>
    (cf. Remark<nbsp><reference|nrmdv>). From<nbsp><eqref|rdd> we also obtain
    in cases (i) and<nbsp>(ii)

    <\equation*>
      t<rsub|i>=t<rsub|j><zav>t<rsub|k>*<space|2em><text|and><space|2em>t<rsub|i>=\<lambda\>*x<tecd>e<rsup|\<dag\>><rsub|\<Gamma\><rsub|0>+<around|{|x|}>><around|(|q|)>,<space|2em><text|respectively.>
    </equation*>

    From Equation<nbsp><eqref|rdt> we see that in case<nbsp>(ii) there exists
    <math|f:\<Gamma\><rsub|0>\<to\>\<Gamma\><rsub|0>+<around|{|x|}>> with
    <math|q=X*f<around|(|p<rsub|j>|)>> for some<nbsp><math|j>, then
    <math|e<rsup|\<dag\>><rsub|\<Gamma\><rsub|0>+<around|{|x|}>><around|(|q|)>=T<rsub|\<lambda\>>*f<around|(|e<rsup|\<dag\>><rsub|\<Gamma\><rsub|0>><around|(|p<rsub|j>|)>|)>=T<rsub|\<lambda\>>*f<around|(|t<rsub|j>|)>>.
    Thus we get equations telling us that for every<nbsp><math|i> either
    <math|t<rsub|i>=t<rsub|j><zav>t<rsub|k>> or
    <math|t<rsub|i>=\<lambda\>*x<tecd>T<rsub|\<lambda\>>*f<around|(|t<rsub|j>|)>>
    or <math|t<rsub|i>><nbsp>is a rational tree. Using these equations it is
    now easy, for every <math|i=1,\<ldots\>,n>, to prove by induction on the
    depth<nbsp><math|k> of subtrees of<nbsp><math|t<rsub|i>> that each
    subtree of<nbsp><math|t<rsub|i>> is either of the
    form<nbsp><math|s=T<rsub|\<lambda\>>*f<around|(|e<rsup|\<dag\>><rsub|\<Gamma\><rsub|0>><around|(|r|)>|)>>
    for some <math|r\<in\>X<around|(|\<Gamma\><rsub|0>|)>> and some
    <math|f:\<Gamma\><rsub|0>\<to\>\<Gamma\><rsub|0>+<around|{|x|}>>, or
    <math|s><nbsp>is a subtree of some rational tree
    <math|e<rsup|\<dag\>><rsub|\<Gamma\><rsub|0>><around|(|r|)>=e<rsub|\<Gamma\><rsub|0>><around|(|r|)>>
    in case<nbsp>(iii). Since <math|X<around|(|\<Gamma\><rsub|0>|)>><nbsp>is
    a finite set, it follows that every tree<nbsp><math|t<rsub|i>> has only
    finitely many subtrees, whence <math|t<rsub|i>\<in\>R<rsub|\<lambda\>><around|(|\<Gamma\><rsub|0>|)>>.

    The case <math|X<around|(|\<emptyset\>|)>=<around|{|p<rsub|1>,\<ldots\>,p<rsub|n>|}>>
    is analogous: for <math|t<rsub|i>=e<rsup|\<dag\>><rsub|\<Gamma\>><around|(|p<rsub|i>|)>>
    we get (i) <math|t<rsub|i>=t<rsub|j><zav>t<rsub|k>> or (ii)
    <math|t<rsub|i>=\<lambda\>*x<tecd>e<rsup|\<dag\>><rsub|<around|{|x|}>><around|(|q|)>>
    or (iii) <math|t<rsub|i>=e<rsub|\<emptyset\>><around|(|p<rsub|i>|)>\<in\>R<rsub|\<lambda\>><around|(|\<emptyset\>|)>>.
    We already know that the trees in case<nbsp>(ii) are rational. Thus, each
    subtree of<nbsp><math|e<rsup|\<dag\>><rsub|\<emptyset\>><around|(|p<rsub|i>|)>>
    is either<nbsp><math|e<rsup|\<dag\>><rsub|\<emptyset\>><around|(|r|)>> or
    it is a subtree of some rational tree in cases (ii) or<nbsp>(iii).

    The solution of<nbsp><math|e> in<nbsp><math|R<rsub|\<lambda\>>> is unique
    because every solution in<nbsp><math|R<rsub|\<lambda\>>> yields a
    solution of the extended morphism<nbsp><math|<wide|e|\<bar\>>>
    in<nbsp><math|T<rsub|\<lambda\>>>.

    (II) Let <DD><nbsp>be the category of all equation morphisms

    <\equation*>
      e:X\<to\>H<rsub|\<lambda\>>*X+V,<space|2em>X<text| finitely
      presentable,>
    </equation*>

    whose morphisms are the coalgebra homomorphisms
    for<nbsp><math|H<rsub|\<lambda\>>(-)+V>. The diagram
    <math|D:<DD>\<to\><SetF>>, <math|D<around|(|e|)>=X>, is filtered and its
    colimit is the free iterative <math|H<rsub|\<lambda\>>>-algebra
    on<nbsp><math|V>, see<nbsp><cite|AMV1>. We will prove that
    <math|R<rsub|\<lambda\>>><nbsp>is a colimit of<nbsp><math|D>. Recall that
    <math|R<rsub|\<lambda\>>><nbsp>is a pointed presheaf (see
    Remark<nbsp><reference|ds>).

    For every <math|e> as above the equation morphism

    <\equation*>
      <wide|e|~>\<equiv\>X<nsi|e>H<rsub|\<lambda\>>*X+V<nsi|+i<rsup|R>>H<rsub|\<lambda\>>*X+R<rsub|\<lambda\>>
    </equation*>

    has a unique solution <math|<wide|e|~><rsup|\<dag\>>:X\<to\>R<rsub|\<lambda\>>>.
    It is easy to verify that these morphisms form a cocone for the
    diagram<nbsp><math|D>. Since <math|D><nbsp>is a filtered diagram
    in<nbsp><SetF> and since colimits in<nbsp><SetF> are constructed
    objectwise in<nbsp><Set>, in order to prove that

    <\equation*>
      R<rsub|\<lambda\>>=<colim>D<space|2em><text|with the colimit cocone
      ><around|(|<wide|e|~><rsup|\<dag\>>|)>
    </equation*>

    all we need to prove is that for every context<nbsp><math|\<Gamma\>>

    <\enumerate>
      <item*|(a)>the cocone <math|<wide|e|~><rsup|\<dag\>><rsub|\<Gamma\>>>
      is collectively epimorphic: <math|R<rsub|\<lambda\>><around|(|\<Gamma\>|)>=<big|cup><wide|e|~><rsup|\<dag\>><rsub|\<Gamma\>><around|[|X|]>>
    </enumerate>

    and

    <\enumerate>
      <item*|(b)>whenever <math|<wide|e|~><rsup|\<dag\>><rsub|\<Gamma\>>><nbsp>merges
      <math|x,x<rprime|'>\<in\>X<around|(|\<Gamma\>|)>>, there exists a
      connecting morphism in<nbsp><math|<DD>> merging <math|x>
      and<nbsp><math|x<rprime|'>> too.
    </enumerate>

    To prove<nbsp>(a), let <math|t\<in\>R<rsub|\<lambda\>><around|(|\<Gamma\>|)>>
    be a rational tree and let <math|\<Gamma\><rsub|0>><nbsp>be the context
    of variables<nbsp><math|x<rsub|s>> indexed by the finitely many
    subtrees<nbsp><math|s> of<nbsp><math|t> (up to isomorphism). Let
    <math|X><nbsp>be the free presheaf on the
    set<nbsp><math|\<Gamma\><rsub|0>> of generators of context
    <math|<wide|\<Gamma\>|\<bar\>>=\<Gamma\>\<cup\>\<Gamma\><rsub|0>>, see
    Example<nbsp><reference|dd>(ii). Define

    <\equation*>
      e:X\<to\>H<rsub|\<lambda\>>*X+V
    </equation*>

    by assigning to every variable<nbsp><math|x<rsub|s>>, for a
    subtree<nbsp><math|s> of<nbsp><math|t>, the following value: if
    <math|s=s<rprime|'><zav>s<rprime|''>> in<nbsp><math|t>, then

    <\equation*>
      e<rsub|\<Gamma\>><around|(|x<rsub|s>|)>=x<rsub|s<rprime|'>><zav>x<rsub|s<rprime|''>><space|2em><text|in
      <math|X<around|(|<wide|\<Gamma\>|\<bar\>>|)>\<times\>X<around|(|<wide|\<Gamma\>|\<bar\>>|)>>,>
    </equation*>

    if <math|s=\<lambda\>*y<tecd>s<rprime|'>> in<nbsp><math|t>, then

    <\equation*>
      e<rsub|\<Gamma\>><around|(|x<rsub|s>|)>=\<lambda\>*y.*x<rsub|s<rprime|'>><space|2em><text|in
      <math|X*<around*|(|<wide|\<Gamma\>|\<bar\>>+<around|{|y|}>|)>>,>
    </equation*>

    and if <math|s><nbsp>is a leaf labelled by <math|x\<in\>\<Gamma\>>, then

    <\equation*>
      e<rsub|\<Gamma\>><around|(|x<rsub|s>|)>=x<space|2em><text|in
      <math|\<Gamma\>=V<around|(|\<Gamma\>|)>>.>
    </equation*>

    This object<nbsp><math|e> of<nbsp><DD> yields two equation morphisms:
    <math|<wide|e|~>:X\<to\>H<rsub|\<lambda\>>*X+R<rsub|\<lambda\>>> above,
    and analogously <math|<wide|e|^>=<around|(|+i<rsup|T>|)><tec>e:X\<to\>H<rsub|\<lambda\>>*X+T<rsub|\<lambda\>>>.
    The solution of the latter is the unique morphism

    <\equation*>
      <wide|e|^><rsup|\<dag\>>:X\<to\>T<rsub|\<lambda\>><space|2em><text|with<space|2em><math|<wide|e|^><rsup|\<dag\>><rsub|<wide|\<Gamma\>|\<bar\>>><around|(|x<rsub|s>|)>=s>
      for all <math|s\<in\>\<Gamma\><rsub|0>>.>
    </equation*>

    Indeed, Diagram<nbsp><eqref|rdd><nbsp>is easily seen to commute for
    <math|<wide|e|^>> and<nbsp><math|<wide|e|^><rsup|\<dag\>>>. In
    (I)<nbsp>above we saw that the solution
    <math|<wide|e|~><rsup|\<dag\>>:X\<to\>R<rsub|\<lambda\>>> is a codomain
    restriction of<nbsp><math|<wide|e|^><rsup|\<dag\>>>. In particular:

    <\equation*>
      t=<wide|e|~><rsup|\<dag\>><rsub|<wide|\<Gamma\>|\<bar\>>><around|(|x<rsub|t>|)>.
    </equation*>

    This proves<nbsp>(a).

    To prove<nbsp>(b) let <math|\<tau\>:H<rsub|\<lambda\>>*T<rsub|\<lambda\>>\<to\>T<rsub|\<lambda\>>>
    denote the algebra structure of<nbsp><math|T<rsub|\<lambda\>>>. By
    Theorem<nbsp><reference|ddv> and Example<nbsp><reference|ndoa> we have
    that

    <\equation*>
      <around|[|\<tau\>,i<rsup|T>|]>:H<rsub|\<lambda\>>*T<rsub|\<lambda\>>+V\<to\>T<rsub|\<lambda\>><space|2em><text|is
      an isomorphism.>
    </equation*>

    From Diagram<nbsp><eqref|rdd> we get

    <\equation*>
      <wide|e|^><rsup|\<dag\>>=<around|[|\<tau\>,<rsub|T<rsub|\<lambda\>>>|]><tec><around|[|H<rsub|\<lambda\>>*<wide|e|^><rsup|\<dag\>>+<rsub|T<rsub|\<lambda\>>>|]><tec><around|(|<rsub|H<rsub|\<lambda\>>*X>+i<rsup|T>|)><tec>e
    </equation*>

    which yields

    <\equation*>
      <around|[|\<tau\>,i<rsup|T>|]><rsup|-1><tec><wide|e|^><rsup|\<dag\>>=<around|(|H<rsub|\<lambda\>>*<wide|e|^><rsup|\<dag\>>+<rsub|V>|)><tec>e.
    </equation*>

    Let us factorize<nbsp><math|<wide|e|^><rsup|\<dag\>>> as a strong
    epimorphism <math|k:X\<to\>Y> followed by a monomorphism
    <math|m:Y\<to\>T<rsub|\<lambda\>>>. Then the last equation makes it
    possible to apply the diagonal fill in: <vspace|1pt>

    <\equation*>
      <psmatrix|<tformat|<table|<row|<cell|X>|<cell|Y>>|<row|<cell|H<rsub|\<lambda\>>*X+V>|<cell|T<rsub|\<lambda\>>>>|<row|<cell|H<rsub|\<lambda\>>*Y+V>|<cell|H<rsub|\<lambda\>>*T<rsub|\<lambda\>>+V<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|k><ncline|1,2|2,2>\<gtr\>m<ncline|1,1|2,1>\<less\>e<ncline|2,1|3,1>\<less\>H<rsub|\<lambda\>>*k+<ncline|2,2|3,2>\<gtr\><around|[|\<tau\>,i<rsup|T>|]><rsup|-1><ncline|3,1|3,2><rsub|H<rsub|\<lambda\>>*m+><ncline*|l*i*n*e*s*t*y*l*e=d*a*s*h*e*d|1,2|3,1>\<gtr\>f>>>>>
    </equation*>

    <vspace|3pt>

    <no-indent>Indeed, <math|H<rsub|\<lambda\>>=(-)<rsup|2>+\<delta\>>
    preserves connected limits (because each summand does), thus,
    monomorphisms; consequently, <math|H<rsub|\<lambda\>>*m+<rsub|V>> is a
    monomorphism. Since <math|Y><nbsp>is a strong quotient of<nbsp><math|X>,
    it follows from Theorem<nbsp><reference|hdjj> that <math|Y><nbsp>is
    finitely presentable. Thus,

    <\equation*>
      f:Y\<to\>H<rsub|\<lambda\>>*Y+V
    </equation*>

    is an object of<nbsp><DD>, and clearly <math|k><nbsp>is a connecting
    morphism from<nbsp><math|e> to<nbsp><math|f>.

    From<nbsp>(I) we know that <math|<wide|e|~><rsup|\<dag\>>><nbsp>is the
    domain restriction of<nbsp><math|<wide|e|^><rsup|\<dag\>>>, thus we see
    that <math|<wide|e|~><rsup|\<dag\>><rsub|\<Gamma\>><around|(|x|)>=<wide|e|~><rsup|\<dag\>><rsub|\<Gamma\>><around|(|x<rprime|'>|)>>
    implies <math|<wide|e|^><rsup|\<dag\>><rsub|\<Gamma\>><around|(|x|)>=<wide|e|^><rsup|\<dag\>><rsub|\<Gamma\>><around|(|x<rprime|'>|)>>,
    and since <math|m<rsub|\<Gamma\>>><nbsp>is a monomorphism with
    <math|<wide|e|^><rsup|\<dag\>><rsub|\<Gamma\>>=m<rsub|\<Gamma\>><tec>k<rsub|\<Gamma\>>>,
    we conclude

    <\equation*>
      k<rsub|\<Gamma\>><around|(|x|)>=k<rsub|\<Gamma\>><around|(|x<rprime|'>|)>
    </equation*>

    as requested.
  </proof>

  <chg>

  <\rem>
    <label|ndjj>As mentioned in the Introduction we want to combine
    application and abstraction with other operations. Suppose
    <math|<Sig>=<around|(|<Sig><rsub|n>|)><rsub|n\<in\><nn>>> is a signature
    (of ``terminals''). Then we can form the
    endofunctor<nbsp><math|H<rsub|\<lambda\>,<Sig>>> of<nbsp><SetF> on
    objects by

    <\equation*>
      H<rsub|\<lambda\>,<Sig>>*X=X\<times\>X+\<delta\>*X+<big|coprod><rsub|n\<in\><nn>><Sig><rsub|n>\<bullet\>X<rsup|n>
    </equation*>

    where <math|<Sig><rsub|n>\<bullet\>X<rsup|n>> is the coproduct (that is:
    disjoint union in every context) of <math|<Sig><rsub|n>><nbsp>copies of
    the <math|n>-th Cartesian power of<nbsp><math|X>. For this endofunctor an
    algebra is an <math|H<rsub|\<lambda\>>>-algebra<nbsp><math|A> together
    with an <math|n>-ary operation on<nbsp><math|A<around|(|\<Gamma\>|)>> for
    every <math|\<sigma\>\<in\><Sig><rsub|n>> and every
    context<nbsp><math|\<Gamma\>>.
  </rem>

  \ <endchg>

  In the following result we use notation of
  Example<nbsp><reference|dd>(vii).

  <\thm>
    <label|djp>For every signature<nbsp><Sig>

    <\enumerate>
      <item*|<text|(i)>><math|F<rsub|\<lambda\>,<Sig>>><nbsp>is the free
      <math|H<rsub|\<lambda\>,<Sig>>>-algebra on<nbsp><math|V>,

      <item*|<text|(ii)>><math|R<rsub|\<lambda\>,<Sig>>><nbsp>is the free
      iterative <math|H<rsub|\<lambda\>,<Sig>>>-algebra on<nbsp><math|V>, and

      <item*|<text|(iii)>><math|T<rsub|\<lambda\>,<Sig>>><nbsp>is the free
      completely iterative <math|H<rsub|\<lambda\>,<Sig>>>-algebra
      on<nbsp><math|V>.
    </enumerate>
  </thm>

  Indeed, (i)<nbsp>was proved in<nbsp><cite|FPT>, and the proofs of (ii)
  and<nbsp>(iii) are completely analogous to the proofs of Theorems
  <reference|hdjt> and<nbsp><reference|ddv>.

  <section|Presheaves as Monoids>

  <reset-counter|equation><label|ht>

  So far we have not treated one of the basic features of
  <math|\<lambda\>>-calculus: substitution of subterms. For the
  presheaf<nbsp><math|F<rsub|\<lambda\>,<Sig>>> of finite
  <math|\<lambda\>>-<Sig>-terms this was elegantly performed by Fiore
  <with|font-shape|italic|et al><nbsp><cite|FPT> based on the monoidal
  structure of the category<nbsp><SetF>. As mentioned in
  Notation<nbsp><reference|dj>(3), we can work with the equivalent
  category<nbsp><math|<Fin><around|(|<Set>,<Set>|)>> of all finitary
  endofunctors of<nbsp><Set>. Composition of functors makes this a (strict,
  non-symmetric) monoidal category with unit<nbsp><math|<Id><rsub|<Set>>>.
  This monoidal structure, as shown in<nbsp><cite|FPT>, corresponds to
  simultaneous substitution. Indeed, let <math|X> and<nbsp><math|Y> be
  objects of<nbsp><math|<Fin><around|(|<Set>,<Set>|)>>. Then the \Pformulas
  of the composite presheaf<nbsp><math|X<tec>Y>\Q in
  context<nbsp><math|\<Gamma\>> are the elements of

  <\equation>
    <label|newr>X<tec>Y<around|(|\<Gamma\>|)>=X<around*|(|Y<around|(|\<Gamma\>|)>|)>=<big|cup><rsub|u:<wide|\<Gamma\>|\<bar\>><subto>Y<around|(|\<Gamma\>|)>>X*u<around|[|<wide|\<Gamma\>|\<bar\>>|]>,
  </equation>

  where <math|u:<wide|\<Gamma\>|\<bar\>><subto>Y<around|(|\<Gamma\>|)>>
  ranges over finite subobjects of <math|Y<around|(|\<Gamma\>|)>>. Indeed,
  <math|X><nbsp>preserves the filtered colimit
  <math|Y<around|(|\<Gamma\>|)>=<colim><wide|\<Gamma\>|\<bar\>>>.

  Consequently, in order to specify an <math|X<tec>Y>-formula<nbsp><math|t>
  in context<nbsp><math|\<Gamma\>> we need (a)<nbsp>an
  <math|X>-formula<nbsp><math|s> in some new
  context<nbsp><math|<wide|\<Gamma\>|\<bar\>>> and (b)<nbsp>for every
  variable <math|x\<in\><wide|\<Gamma\>|\<bar\>>> a <math|Y>-formula of
  context<nbsp><math|\<Gamma\>>, say, <math|r<rsub|x>>. We can then think
  of<nbsp><math|t> as the formula<nbsp><math|s*<around|(|r<rsub|x>/x|)>>
  obtained from<nbsp><math|s> by simultaneous substitution.

  <chg>

  <\exa>
    \ We consider the presheaves <math|F<rsub|\<lambda\>,\<Sigma\>>> and
    <math|F<rsub|\<lambda\>,\<Sigma\><rprime|'>>>, where <math|\<Sigma\>> is
    the signature with a binary operation symbol <math|\<ast\>> and
    <math|\<Sigma\><rprime|'>> a signature with a unary operation symbol
    <math|o>. Then for every context <math|\<Gamma\>>, the elements of
    <math|F<rsub|\<lambda\>,\<Sigma\>><tec>F<rsub|\<lambda\>,\<Sigma\><rprime|'>><around|(|\<Gamma\>|)>>
    are <math|\<lambda\>>-<math|<Sig>>-terms in some context
    <math|<ol|\<Gamma\>>> with free variables replaced by
    <math|\<lambda\>>-<math|<Sig><rprime|'>>-terms in context
    <math|\<Gamma\>>. For a concrete example, let
    <math|<ol|\<Gamma\>>=<around|{|<space|0.17em>y,z<space|0.17em>|}>> and
    <math|\<Gamma\>=<around|{|<space|0.17em>z<rprime|'><space|0.17em>|}>> and
    consider the <math|\<lambda\>>-<math|<Sig>>-term

    <\equation*>
      t=\<lambda\>*x.*x\<ast\><around|(|y\<ast\>z|)>*<space|2em><text|in
      >F<rsub|\<lambda\>,\<Sigma\>><around|{|<space|0.17em>y,z<space|0.17em>|}>
    </equation*>

    and the function

    <\equation*>
      u:<ol|\<Gamma\>>\<to\>F<rsub|\<lambda\>,<Sig><rprime|'>><around|(|\<Gamma\>|)><space|2em><text|with>

      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|u<around|(|y|)>>|<cell|=>|<cell|\<lambda\>*x.*o<around|(|x|)><zav>z<rprime|'>>>|<row|<cell|u<around|(|z|)>>|<cell|=>|<cell|z<rprime|'><zav>o<around|(|o<around|(|z<rprime|'>|)>|)>>>>>>
    </equation*>

    Then the element of <math|F<rsub|\<lambda\>,<Sig>><tec>F<rsub|\<lambda\>,<Sig><rprime|'>><around|(|\<Gamma\>|)>>
    corresponding to <math|t> and <math|u> is the term

    <\equation*>
      \<lambda\>*x.*x\<ast\><around*|(|<around|(|\<lambda\>*x.*o<around|(|x|)><zav>z<rprime|'>|)>\<ast\><around|(|z<rprime|'><zav>o<around|(|o<around|(|z<rprime|'>|)>|)>|)>|)>.
    </equation*>
  </exa>

  \ <endchg>

  <\rem>
    <label|hndj>(i) The monoidal structure on<nbsp><SetF> corresponding to
    composition in the category <math|<Fin><around|(|<Set>,<Set>|)>> will be
    denoted by<nbsp><math|\<otimes\>>. Its unit (corresponding
    to<nbsp><math|<Id>>) is<nbsp><math|V>, see
    Notation<nbsp><reference|dd>(i). Observe that every
    endofunctor<nbsp><math|-\<otimes\>X> preserves colimits, e.g.,
    <math|<around|(|A+B|)>\<otimes\>X\<cong\><around|(|A\<otimes\>X|)>+<around|(|B\<otimes\>X|)>>.

    (ii) Explicitly, the monoidal structure can be described by the coend

    <\equation>
      <label|eq:3.2><around|(|X\<otimes\>Y|)><around|(|\<Gamma\>|)>=<big|int><rsup|<wide|\<Gamma\>|\<bar\>>><Set><around|(|<wide|\<Gamma\>|\<bar\>>,Y<around|(|\<Gamma\>|)>|)>\<bullet\>X<around|(|<wide|\<Gamma\>|\<bar\>>|)>.
    </equation>

    (iii) Recall that monoids in the monoidal
    category<nbsp><math|<Fin><around|(|<Set>,<Set>|)>> are precisely the
    finitary monads on<nbsp><Set>.

    (iv) The presheaf<nbsp><math|F<rsub|\<lambda\>,<Sig>>> is endowed with
    the usual simultaneous substitution of <math|\<lambda\>>-terms which
    defines a morphism <math|m<rsup|F>:F<rsub|\<lambda\>,<Sig>>\<otimes\>F<rsub|\<lambda\>,<Sig>>\<to\>F<rsub|\<lambda\>,<Sig>>>.
    Together with the canonical pointing <math|i<rsup|F>:V\<to\>F<rsub|\<lambda\>,<Sig>>>,
    see Remark<nbsp><reference|ds>, this constitutes a monoid as proved
    in<nbsp><cite|FPT>.

    Analogously the simultaneous substitution of infinite
    <math|\<lambda\>>-terms defines a monoid

    <\equation*>
      <around|(|T<rsub|\<lambda\>,<Sig>>,m<rsup|T>,i<rsup|T>|)>.
    </equation*>

    It is easy to see that given a rational term, every simultaneous
    substitution of rational terms for variables yields again a rational
    term. Thus, we have a submonoid <math|<around|(|R<rsub|\<lambda\>,<Sig>>,m<rsup|R>,i<rsup|R>|)>>.

    (v) The monoidal operation of<nbsp><math|F<rsub|\<lambda\>,<Sig>>> is
    well connected to its structure of an
    <math|H<rsub|\<lambda\>,<Sig>>>-algebra. This was expressed
    in<nbsp><cite|FPT> by the concept of an
    <with|font-shape|italic|<math|H<rsub|\<lambda\>,<Sig>>>-monoid>.

    In order to recall this concept, we need the notion of point-strength
    introduced in<nbsp><cite|F> under the name
    <math|<around|(|I/<WW>|)>>-strength; this is a weakening of the classical
    strength (necessary since <math|H<rsub|\<lambda\>,<Sig>>><nbsp>is
    unfortunately not strong). Recall that given an object<nbsp><math|I> of a
    category<nbsp><WW>, then objects of the slice category<nbsp><math|I/<WW>>
    are morphisms <math|x:I\<to\>X> for <math|X\<in\><obj><WW>>.
  </rem>

  <\defi|see<nbsp><cite|F>>
    <label|hntj>Let <math|<around|(|<WW>,\<otimes\>,I|)>><nbsp>be a strict
    monoidal category and <math|H> an endofunctor on<nbsp><math|<WW>>. A
    <with|font-series|bold|point-strength> of<nbsp><math|H> is a collection
    of morphisms

    <\equation*>
      s<rsub|<around|(|X,x|)><around|(|Y,y|)>>:H*X\<otimes\>Y\<to\>H*<around|(|X\<otimes\>Y|)>
    </equation*>

    natural in <math|<around|(|X,x|)>> and<nbsp><math|<around|(|Y,y|)>>
    ranging through<nbsp><math|I/<WW>> such that

    <\enumerate>
      <item*|<with|font-shape|right|(i)>><math|s<rsub|<around|(|X,x|)><around|(|I,|)>>=<rsub|H*X>>,
      and

      <item*|<with|font-shape|right|(ii)>>the following triangles commute:
      <vspace|7pt>

      <\equation>
        <label|triangle><move|<math|<psmatrix|c*o*l*s*e*p=10*m*m|<tformat|<table|<row|<cell|H*X\<otimes\>Y\<otimes\>Z>|<cell|>|<cell|H*<around|(|X\<otimes\>Y\<otimes\>Z|)>>>|<row|<cell|>|<cell|H*<around|(|X\<otimes\>Y|)>\<otimes\>Z<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,3><rsup|s<rsub|<around|(|X,x|)>,<around|(|Y\<otimes\>Z,y\<otimes\>z|)>>><ncline|1,1|2,2>\<less\>s<rsub|<around|(|X,x|)>,<around|(|Y,y|)>>\<otimes\><rsub|Z><ncline|2,2|1,3>\<gtr\>s<rsub|<around|(|X\<otimes\>Y,x\<otimes\>y|)>,<around|(|Z,z|)>>>|<cell|>>>>>>|0pt|-10mm>
      </equation>
    </enumerate>
  </defi>

  \ <vspace|1mm>

  <\exa>
    <label|hntd>(i) The endofunctor <math|X\<mapsto\>X\<otimes\>X> (which
    usually fails to be strong) has the point-strength

    <\equation*>
      s<rsub|<around|(|X,x|)><around|(|Y,y|)>>=<around|(|X\<otimes\>X|)>\<otimes\>Y=<around|(|X\<otimes\>I\<otimes\>X|)>\<otimes\>Y<nsi|<rsub|X>\<otimes\>y\<otimes\><rsub|X\<otimes\>Y>><around|(|X\<otimes\>Y|)>\<otimes\><around|(|X\<otimes\>Y|)>.
    </equation*>

    (ii) The endofunctor <math|X\<mapsto\>X<rsup|n>> of<nbsp><SetF> is
    clearly (point-)strong for every <math|n\<in\><nn>>.

    (iii) The functor <math|\<delta\>> in Notation<nbsp><reference|dt> is
    point-strong, as observed in<nbsp><cite|FPT>. The easiest way to describe
    its point-strength is by working in <math|<Fin><around|(|<Set>,<Set>|)>>.
    Given pointed endofunctors <math|x:<Id>\<to\>X> and <math|y:<Id>\<to\>Y>,
    then the point-strength <math|s<rsub|<around|(|X,x|)><around|(|Y,y|)>>:<around|(|\<delta\>*X|)><tec>Y\<to\>\<delta\><around|(|X<tec>Y|)>>
    has components

    <\equation*>
      X*<around*|(|Y<around|(|\<Gamma\>|)>+1|)><nsi|X*<around|(|+y<rsub|1>|)>>X*<around*|(|Y<around|(|\<Gamma\>|)>+Y<around|(|1|)>|)><nsi|X<can>>X<tec>Y*<around|(|\<Gamma\>+1|)>,
    </equation*>

    where <math|<can>:Y<around|(|\<Gamma\>|)>+Y<around|(|1|)>\<to\>Y*<around|(|\<Gamma\>+1|)>>
    denotes the canonical morphism.

    (iv) A coproduct of point-strong functors is point-strong.
  </exa>

  <\cor>
    <label|hntt>The endofunctors <math|H<rsub|\<lambda\>>>
    and<nbsp><math|H<rsub|\<lambda\>,<Sig>>> are point-strong. Their
    point-strength is denoted by<nbsp><math|s<rsup|H>>.
  </cor>

  <\defi|see<nbsp><cite|FPT>>
    <label|hntc>Let <math|H><nbsp>be a point-strong endofunctor of a monoidal
    category. By an <with|font-series|bold|<math|H>-monoid> is meant an
    <math|H>-algebra<nbsp><math|<around|(|A,a|)>> which is also a monoid

    <\equation*>
      m:A\<otimes\>A\<to\>A*<space|2em><text|and><space|2em>i:I\<to\>A
    </equation*>

    such that the square below commutes: <vspace|3mm>

    <\equation>
      <label|abb><move|<psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|H*A\<otimes\>A>|<cell|H*<around|(|A\<otimes\>A|)>>|<cell|H*A>>|<row|<cell|A\<otimes\>A>|<cell|>|<cell|A<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s<rsub|<around|(|A,i|)><around|(|A,i|)>>><ncline|1,1|2,1>\<less\>a\<otimes\><ncline|2,1|2,3><rsub|m><ncline|1,2|1,3><rsup|H*m><ncline|1,3|2,3>\<gtr\>a>>>>>|0pt|-10mm>
    </equation>
  </defi>

  \ <vspace|2mm>

  <\rem>
    <label|ntpjp>(1) Homomorphisms of <math|H>-monoids are those monoid
    homomorphisms which are also <math|H>-algebra homomorphisms.

    (2) An <math|H>-monoid is called <with|font-shape|italic|(completely)
    iterative> if its underlying <math|H>-algebra has this property.
  </rem>

  <\exa>
    <label|ntptp>(i) <math|F<rsub|\<lambda\>>><nbsp>is an
    <math|H<rsub|\<lambda\>>>-monoid. Indeed, we know that substitution
    yields the monoid structure (Remark<nbsp><reference|ds>) and tree tupling
    yields the algebra structure (Example<nbsp><reference|dp>). Let us
    consider the square <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=18*m*m|<tformat|<table|<row|<cell|H<rsub|\<lambda\>>*F<rsub|\<lambda\>>\<otimes\>F<rsub|\<lambda\>>>|<cell|H<rsub|\<lambda\>>*<around|(|F<rsub|\<lambda\>>\<otimes\>F<rsub|\<lambda\>>|)>>|<cell|H*F<rsub|\<lambda\>>>>|<row|<cell|F<rsub|\<lambda\>>\<otimes\>F<rsub|\<lambda\>>>|<cell|>|<cell|F<rsub|\<lambda\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s><ncline|1,1|2,1>\<less\>\<varphi\>\<otimes\><ncline|2,1|2,3><rsub|m<rsup|F>><ncline|1,2|1,3><rsup|<rule|16*p*t|0*p*t>H*m<rsup|F>><ncline|1,3|2,3>\<gtr\>\<varphi\>>>>>>
    </equation*>

    <vspace|2mm>

    <no-indent>The elements<nbsp><math|t> of
    <math|H<rsub|\<lambda\>>*F\<otimes\>F<rsub|\<lambda\>>> in
    context<nbsp><math|\<Gamma\>> are those of

    <\equation*>
      H<rsub|\<lambda\>>*F<rsub|\<lambda\>><around|(|\<Gamma\><rsub|0>|)>=F<rsub|\<lambda\>><around|(|\<Gamma\><rsub|0>|)>\<times\>F<rsub|\<lambda\>><around|(|\<Gamma\><rsub|0>|)>+F<rsub|\<lambda\>>*<around*|(|\<Gamma\><rsub|0>+<around|{|x|}>|)>
    </equation*>

    for a given context<nbsp><math|\<Gamma\><rsub|0>> together with a
    substitution <math|f:\<Gamma\><rsub|0>\<to\>F<rsub|\<lambda\>><around|(|\<Gamma\>|)>>.
    In case of the summand <math|F<rsub|\<lambda\>><around|(|\<Gamma\><rsub|0>|)>\<times\>F<rsub|\<lambda\>><around|(|\<Gamma\><rsub|0>|)>>
    the lower passage <math|m<rsup|F><rsub|\<Gamma\>>*<around|(|\<varphi\><rsub|\<Gamma\>>\<otimes\>|)>>
    assigns to <math|t=<around|(|t<rsub|1>,t<rsub|2>|)>> the term
    <math|t<rsub|1><zav>t<rsub|2>> with variables substituted according
    to<nbsp><math|f>. And the upper passage first substitutes to
    <math|t<rsub|1>> and<nbsp><math|t<rsub|2>> according to<nbsp><math|f>
    separately, and then forms<nbsp><math|<zav>>; the result is the same. In
    case of the summand <math|F<rsub|\<lambda\>>*<around|(|\<Gamma\><rsub|0>+<around|{|x|}>|)>>
    the lower passage assigns to<nbsp><math|t> the
    term<nbsp><math|\<lambda\>*x<tecd>t> with variables substituted according
    to<nbsp><math|f>; the upper one first substitutes in<nbsp><math|t> and
    then forms<nbsp><math|\<lambda\>*x<tecd>-> yielding the same result
    again.

    (ii) More generally, for every signature<nbsp><Sig> we have an
    <math|H<rsub|\<lambda\>,<Sig>>>-monoid <math|F<rsub|\<lambda\>,<Sig>>>.
  </exa>

  <\thm|see<nbsp><cite|FPT>>
    <label|hnts>The presheaf<nbsp><math|F<rsub|\<lambda\>,<Sig>>> of finite
    <math|\<lambda\>>-<Sig>-terms is the initial
    <math|H<rsub|\<lambda\>,<Sig>>>-monoid.
  </thm>

  <\thm|see <cite|MU>>
    <label|ntsjt>The presheaf <math|T<rsub|\<lambda\>,\<Sigma\>>> of
    <math|\<lambda\>>-<Sig>-terms is an <math|H<rsub|\<lambda\>,\<Sigma\>>>-monoid
    with simultaneous substitution as monoid structure.
  </thm>

  Although in<nbsp><cite|MU>, Example<nbsp>13, just <math|T<rsub|\<lambda\>>>
  is used, the methods of that paper apply to <math|T<rsub|\<lambda\>,<Sig>>>
  immediately. The following theorem proves a stronger property
  of<nbsp><math|T<rsub|\<lambda\>,<Sig>>>, corresponding to
  Theorem<nbsp><reference|hnts> above.

  <\thm>
    <label|hntss>The presheaf<nbsp><math|T<rsub|\<lambda\>,<Sig>>> of
    <math|\<lambda\>>-<Sig>-terms is the initial completely iterative
    <math|H<rsub|\<lambda\>,<Sig>>>-monoid.
  </thm>

  An elementary proof of this theorem was presented in<nbsp><cite|AMV2>. Here
  we will prove a more general result in Theorem<nbsp><reference|nncjjjp>
  below.

  <section|The Initial Iterative <math|H>-Monoid>

  <reset-counter|equation><label|snc>

  The aim of this section is to prove that the
  presheaf<nbsp><math|R<rsub|\<lambda\>,<Sig>>> of rational
  <math|\<lambda\>>-<Sig>-terms is the initial iterative
  <math|H<rsub|\<lambda\>,<Sig>>>-monoid in<nbsp><SetF>. We have (in contrast
  to the characterization of<nbsp><math|T<rsub|\<lambda\>>> in the preceding
  section) no elementary proof. Rather, we need to work with the
  monad<nbsp><math|<rr><rsub|\<lambda\>,<Sig>>> of free iterative
  <math|H<rsub|\<lambda\>,<Sig>>>-algebras on<nbsp><SetF>

  (for which <math|R<rsub|\<lambda\>,<Sig>>><nbsp>is<nbsp><math|<rr><rsub|\<lambda\>,<Sig>><around|(|V|)>>)
  and prove that it is point-strong and use this strength further. We will
  actually work in a more general setting (which can be applied later for the
  case of typed <math|\<lambda\>>-calculus).

  <\asm>
    <label|nncj>

    <\text>
      Throughout this section we assume that <math|H><nbsp>is a finitary
      endofunctor of<nbsp><WW> where

      <\enumerate>
        <item*|<text|(1)>><WW><nbsp>is a locally finitely presentable
        category, i.e., a cocomplete category with a set of finitely
        presentable objects<nbsp><math|<WW><rsub|<math-ss|fp>>> whose closure
        under filtered colimits is all of<nbsp><WW>.

        <item*|<text|(2)>><WW><nbsp>is also a strict monoidal category with
        the unit<nbsp><math|I> finitely presentable and the tensor product
        preserving finite presentability: if <math|A,B><nbsp>are finitely
        presentable, then so is <math|A\<otimes\>B>.

        <item*|<text|(3)>><WW><nbsp>is right distributive, that is, for every
        object<nbsp><math|W> the endofunctor<nbsp><math|-\<otimes\>W>
        preserves finite coproducts.

        <item*|<text|(4)>>The tensor product is a finitary functor, i.e., its
        preserves filtered colimits (in both variables).
      </enumerate>

      We call categories satisfying (1)--(4)
      <with|font-shape|italic|monoidally locally finitely presentable>.
    </text>

    \;
  </asm>

  <\exa>
    <label|ncdjp>Set is, as a cartesian closed category, monoidally locally
    finitely presentable. For every monoidally locally finitely presentable
    category<nbsp><WW> all functor categories<nbsp><math|<WW><rsup|<AAA>>>,
    <AAA><nbsp>small, have the property too; for example, <SetF><nbsp>with
    the cartesian product as tensor. However, in our paper we only use the
    fact that <SetF><nbsp>is a monoidally locally finitely presentable
    w.r.t.<nbsp><math|\<otimes\>> in Remark<nbsp><reference|hndj>(i). This
    follows from the fact that this is equivalent
    to<nbsp><math|<Fin><around|(|<Set>,<Set>|)>> with the tensor product
    given by composition. Observe that <math|\<otimes\>><nbsp>is right
    distributive (since precomposition with a given functor preserves
    colimits) but not left distributive.
  </exa>

  <\notation>
    <label|nncd>For every object<nbsp><math|Y> of<nbsp><WW> we denote by

    <\equation*>
      \<varrho\><rsub|Y>:H*R*Y\<to\>R*Y*<space|2em><text|and><space|2em>\<eta\><rsub|Y>:Y\<to\>R*Y
    </equation*>

    the structure and oniversal morphism of the free iterative
    <math|H>-algebra on<nbsp><math|Y>, which exists as proved
    in<nbsp><cite|AMV1>. This gives rise to the monad

    <\equation*>
      <rr>=<around|(|R,\<eta\>,\<mu\>|)>
    </equation*>

    where <math|\<mu\><rsub|X>:R*R*Y\<to\>R*Y> is the unique homomorphism
    extending<nbsp><math|\<eta\><rsub|Y>>: <vspace|3mm>

    <\equation>
      <label|nnrcj><move|<psmatrix|<tformat|<table|<row|<cell|H*R*R*Y>|<cell|R*R*Y>|<cell|Y>>|<row|<cell|H*R*Y>|<cell|R*Y<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|\<varrho\><rsub|R*Y>><ncline|1,3|1,2><rsup|\<eta\><rsub|R*Y>><ncline|1,1|2,1>\<less\>H*\<mu\><rsub|Y><ncline|1,3|2,2>\<gtr\>\<eta\><rsub|Y><ncline|2,1|2,2><rsub|\<varrho\><rsub|Y>><ncline|1,2|2,2>\<less\>\<mu\><rsub|Y>>|<cell|>>>>>|0pt|-7mm>
    </equation>

    <vspace|2mm>

    <no-indent><rr><nbsp>is called the rational monad of the
    endofunctor<nbsp><math|H>.
  </notation>

  <\rem>
    <label|nnct>In<nbsp><cite|AMV1> we described the free iterative
    <math|H>-algebra<nbsp><math|R*Y> as the colimit of the diagram of all
    ``flat equation'' morphisms

    <\equation*>
      e:W\<to\>H*W+Y,<space|2em>W\<in\><WW><text| finitely presentable,>
    </equation*>

    whose connecting morphisms (``equation morphisms'') are just the
    coalgebra homomorphisms<nbsp><math|h> for the endofunctor <math|H(-)+Y>:
    <vspace|3mm>

    <\equation>
      <label|nnrcd><move|<psmatrix|<tformat|<table|<row|<cell|W>|<cell|H*W+Y>>|<row|<cell|W<rprime|'>>|<cell|H*W<rprime|'>+Y<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|e<rule|8*p*t|0*p*t>><ncline|1,1|2,1>\<less\>h<ncline|2,1|2,2><rsub|e<rprime|'><rule|8*p*t|0*p*t>><ncline|1,2|2,2>\<gtr\>H*h+>>>>>|0pt|-7mm>
    </equation>

    <vspace|2mm>

    <no-indent>More detailed:

    <\enumerate>
      <item*|(i)>The category<nbsp><math|<math-ss|EQ><rsub|Y>> of all flat
      equation morphisms in<nbsp><math|Y> is filtered. The filtered diagram

      <\equation*>
        <math-ss|Eq><rsub|Y>:<math-ss|EQ><rsub|Y>\<to\>W,<space|2em><math-ss|Eq><rsub|Y><around|(|W<nsi|e>H*W+Y|)>=W
      </equation*>

      has a colimit<nbsp><math|R*Y> with the colimit injections
      <math|e<rsup|#>:W\<to\>R*Y>.

      <item*|(ii)>For the flat equation morphism <math|<inl>:Y\<to\>H*Y+Y>
      put

      <\equation>
        <label|nnrct>\<eta\><rsub|Y>=<inr><rsup|#>:Y\<to\>R*Y.
      </equation>

      <item*|(iii)>There is a unique isomorphism <math|i:R*Y\<to\>H*R*Y+Y>
      such that the squares <vspace|3mm>

      <\equation>
        <label|nnrcc><move|<math|<psmatrix|<tformat|<table|<row|<cell|W>|<cell|H*W+Y>>|<row|<cell|R*Y>|<cell|H*R*Y+Y<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|e<rule|8*p*t|0*p*t>><ncline|1,1|2,1>\<less\>e<rsup|#><ncline|2,1|2,2><rsub|i<rsub|Y><rule|8*p*t|0*p*t>><ncline|1,2|2,2>\<gtr\>H*e<rsup|#>+Y>>>>>>|0pt|-7mm>
      </equation>

      <vspace|2mm>

      <no-indent>commute for all flat equations<nbsp><math|e>. Put

      <\equation*>
        \<varrho\>\<equiv\>H*R*Y<nsi|<inl>>H*R*Y+Y<nsi|i<rsub|Y><rsup|-1>>R*Y.
      </equation*>

      Then <math|R*Y> together with <math|\<eta\><rsub|Y>>
      and<nbsp><math|\<varrho\><rsub|Y>> is the free iterative
      <math|H>-algebra on<nbsp><math|Y>. We also have

      <\equation>
        <label|nnrcp>i<rsub|Y>=<around|[|\<varrho\><rsub|Y>,\<eta\><rsub|Y>|]><rsup|-1>.
      </equation>

      Furthermore, <math|e<rsup|#>><nbsp>is the unique coalgebra homomorphism
      from<nbsp><math|e> to<nbsp><math|i<rsub|Y>>.

      <item*|(iv)>For every <math|e:W\<to\>H*W+Y> the morphism
      <math|e<rsup|#>:W\<to\>R*Y> is the unique solution (in the iterative
      algebra<nbsp><math|R*Y>) of

      <\equation*>
        \<eta\><rsub|Y>\<bullet\>e\<equiv\>W<nsi|e>H*W+Y<nsi|H*W+\<eta\><rsub|Y>>H*W+R*Y.
      </equation*>

      <item*|(v)>Let

      <\equation*>
        e:W\<to\>H*W+R*Y*<space|2em><text|and><space|2em>e<rprime|'>:W<rprime|'>\<to\>H*W<rprime|'>+R*Y
      </equation*>

      be two equation morphisms with <math|W> and<nbsp><math|W<rprime|'>>
      finitely presentable, and let <math|h><nbsp>be a coalgebra homomorphism
      from<nbsp><math|<around|(|W,e|)>> to<nbsp><math|<around|(|W,e<rprime|'>|)>>.
      Then for the unique solutions of <math|e> and<nbsp><math|e<rprime|'>>
      we have

      <\equation*>
        e<rsup|\<dag\>>=<around*|(|e<rprime|'>|)><rsup|\<dag\>><tec>h:W\<to\>R*Y.
      </equation*>

      <item*|(vi)>Suppose we have two morphisms

      <\equation*>
        f:V\<to\>H*V+W*<space|2em><text|and><space|2em>e:W\<to\>H*W+R*Y
      </equation*>

      where <math|V,W><nbsp>are finitely presentable. Then we can form an
      equation morphism <vspace|3mm>

      <\equation*>
        <psmatrix|c*o*l*s*e*p=20*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|e<ctv>f\<equiv\>V+W>|<cell|H*V+W>|<cell|H*V+H*W+R*Y>>|<row|<cell|>|<cell|>|<cell|H*<around|(|V+W|)>+R*Y<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|<rule*|4*m*m|0*m*m|f,<inr>>><ncline|1,2|1,3><rsup|H*V+e<rule|5*m*m|0*m*m>><ncline|1,3|2,3>\<gtr\><can>+R*Y>>>>>
      </equation*>

      and we have

      <\equation>
        <label|rcoo><around*|(|e<rsup|\<dag\>>\<bullet\>f|)><rsup|\<dag\>>=<around|(|e<ctv>f|)><rsup|\<dag\>><tec><inl>,
      </equation>

      see<nbsp><cite|AMV-Elgot>.

      <item*|(vii)>Finally, every homomorphism<nbsp><math|h:A\<to\>B> of
      <math|H>-algebras between iterative algebras <math|A> and<nbsp><math|B>
      <with|font-shape|italic|preserves solutions>:

      <\equation*>
        h<tec>e<rsup|\<dag\>>=<around|(|h\<bullet\>e|)><rsup|\<dag\>>:X\<to\>B
      </equation*>

      for every equation morphism <math|e:X\<to\>H*X+A>.
    </enumerate>
  </rem>

  <\exa>
    <label|nncc>The rational monad of<nbsp><math|H<rsub|\<lambda\>>> is the
    monad<nbsp><math|<rr><rsub|\<lambda\>>> of rational
    <math|\<lambda\>>-terms with constants: to every presheaf<nbsp><math|Y>
    it assigns the presheaf<nbsp><math|R<rsub|\<lambda\>><around|(|Y|)>>
    defined precisely as<nbsp><math|R<rsub|\<lambda\>>> in
    Example<nbsp><reference|dd>(v) except that in every
    context<nbsp><math|\<Gamma\>> we can also use elements
    of<nbsp><math|Y<around|(|\<Gamma\>|)>> to label the leaves.

    More detailed: we first define the set<nbsp><math|R<rprime|'><rsub|\<lambda\>><around|(|Y|)><around|(|\<Gamma\>|)>>
    of rational trees in context<nbsp><math|\<Gamma\>> with constants
    from<nbsp><math|Y>. It consists of all rational trees of the
    form<nbsp><eqref|rdj> such that

    <\equation*>
      <text|a node labelled by an element
      of<nbsp><math|Y<around|(|\<Gamma\>|)>> is a leaf.>
    </equation*>

    By using the <math|\<alpha\>>-conversion precisely as in
    Example<nbsp><reference|dd>(iii), we obtain the desired presheaf

    <\equation*>
      R<rsub|\<lambda\>><around|(|Y|)><around|(|\<Gamma\>|)>=R<rprime|'><rsub|\<lambda\>><around|(|Y|)><around|(|\<Gamma\>|)>/\<sim\><rsub|\<alpha\>>.
    </equation*>

    It is again pointed; the pointing <math|i<rsup|R<rsub|\<lambda\>><around|(|Y|)>>:V\<to\>R<rsub|\<lambda\>><around|(|Y|)>>
    assigns to every variable the corresponding singleton tree. And
    <math|R<rsub|\<lambda\>><around|(|Y|)>><nbsp>is canonically an
    <math|H<rsub|\<lambda\>>>-algebra. We define

    <\equation*>
      \<eta\><rsub|Y>:Y\<to\>R<rsub|\<lambda\>><around|(|Y|)>
    </equation*>

    to assign to every element of<nbsp><math|Y<around|(|\<Gamma\>|)>> the
    corresponding singleton tree. This is the free iterative
    <math|H<rsub|\<lambda\>>>-algebra on<nbsp><math|Y>, the proof is
    completely analogous to that of Theorem<nbsp><reference|hdjt>.
  </exa>

  <\defi>
    <label|nncp>A <with|font-shape|italic|point-strong monad> is a monad
    <math|<MM>=<around|(|M,\<eta\>,\<mu\>|)>> on<nbsp><WW>

    together with a point-strength

    <\equation*>
      s<rsub|<around|(|X,x|)>,<around|(|Y,y|)>>:<around|(|M*X|)>\<otimes\>Y\<to\>M*<around|(|X\<otimes\>Y|)>
    </equation*>

    see Definition<nbsp><reference|hntj>, such that <math|s><nbsp>preserves
    the unit: <vspace|3mm>

    <\equation>
      <label|nnnrcp><move|<psmatrix|c*o*l*s*e*p=13*m*m,r*o*w*s*e*p=13*m*m|<tformat|<table|<row|<cell|M*X\<otimes\>Y>|<cell|>|<cell|M*<around|(|X\<otimes\>Y|)>>>|<row|<cell|>|<cell|X\<otimes\>Y<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,3><rsup|S<rsub|<around|(|X,x|)>,<around|(|Y,y|)>>><ncline|2,2|1,1>\<less\>\<eta\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X>\<otimes\>Y<ncline|2,2|1,3>\<gtr\>\<eta\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X\<otimes\>Y>>|<cell|>>>>>|0pt|-7mm>
    </equation>

    and the multiplication: <vspace|3mm>

    <\equation>
      <label|nnrcs><move|<psmatrix|c*o*l*s*e*p=27*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|M*M*X\<otimes\>Y>|<cell|M*<around|(|M*X\<otimes\>Y|)>>|<cell|M*M*<around|(|X\<otimes\>Y|)>>>|<row|<cell|M*X\<otimes\>Y>|<cell|>|<cell|M*<around|(|X\<otimes\>Y|)><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s<rsub|<around|(|M*X,\<eta\><rsub|X><tec>x|)>,<around|(|Y,y|)>>><ncline|1,2|1,3><rsup|M*s<rsub|<around|(|X,x|)>,<around|(|Y,y|)>>><ncline|1,1|2,1>\<less\>\<mu\><rsub|X>\<otimes\>Y<ncline|2,1|2,3><rsub|s<rsub|<around|(|X,x|)>,<around|(|Y,y|)>>><ncline|1,3|2,3>\<gtr\>\<mu\><rsub|Y>>>>>>|0pt|-7mm>
    </equation>
  </defi>

  \ <vspace|2mm>

  <\exa>
    <label|E:monad-T>By our assumption that <math|H><nbsp>be finitary we know
    that all terminal coalgebras for <math|H(-)+X> exist, this follows
    from<nbsp><cite|n>, see also<nbsp><cite|nc>. Equivalently, all free
    completely iterative algebras for<nbsp><math|H> exist (cf.
    Example<nbsp><reference|ndoa>), and they yield the object map of a monad
    <math|<TT>=<around|(|T,\<eta\><rsup|T>,\<mu\><rsup|T>|)>>. This monad is
    the free completely iterative monad on the endofunctor<nbsp><math|H>,
    see<nbsp><cite|nn>. The monad multiplication
    <math|\<mu\><rsup|T><rsub|X>:T*T*X\<to\>T*X> is the unique algebra
    homomorphism extending<nbsp><rsub|<math|T*X>>, i.e., such that

    <\equation>
      <label|homo>\<mu\><rsup|T><rsub|X><tec>\<tau\><rsup|<phantom|T>><rsub|T*X>=\<tau\><rsup|<phantom|T>><rsub|X><tec>H*\<mu\><rsup|T><rsub|X>*<space|2em><text|and><space|2em>\<mu\><rsup|T><rsub|X><tec>\<eta\><rsup|T><rsub|T*X>=<rsub|T*X>.
    </equation>
  </exa>

  <\thm>
    <label|T:monad-T>The free completely iterative monad<nbsp><TT> of a
    point-strong endofunctor<nbsp><math|H> is point-strong.
  </thm>

  <\trivlist>
    <item*|<space|labelsep><with|font-series|bold|Remark.>>The strength
    of<nbsp><TT> will be proved to be the unique natural
    transformation<nbsp><math|s<rsup|T>> for which the diagram

    <\equation>
      <label|ffflat><move|<psmatrix|c*o*l*s*e*p=20*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|H*T*X\<otimes\>Y>|<cell|H*<around|(|T*X\<otimes\>Y|)>>|<cell|H*T*<around|(|X\<otimes\>Y|)>>>|<row|<cell|T*X\<otimes\>Y>|<cell|>|<cell|T*<around|(|X\<otimes\>Y|)>>>|<row|<cell|X\<otimes\>Y<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s<rsup|H>><ncline|1,2|1,3><rsup|H*s<rsup|T>><ncline|1,1|2,1>\<less\>\<tau\><rsub|X>\<otimes\>Y<ncline|2,1|2,3><rsup|s<rsup|T>><ncline|1,3|2,3>\<gtr\>\<tau\><rsup|<phantom|T>><rsub|X\<otimes\>Y><ncline|3,1|2,1>\<less\>\<eta\><rsub|X><rsup|T>\<otimes\>Y<ncline|3,1|2,3>\<gtr\>\<eta\><rsub|X\<otimes\>Y><rsup|T>>|<cell|>|<cell|>>>>>|0pt|-12mm>
    </equation>

    commutes. Note that we have dropped the subscripts indicating the
    components of the natural transformations <math|s<rsup|H>>
    and<nbsp><math|s<rsup|T>> above; from now on we shall frequently do this
    when components of natural transformations are clear from the context.
  </trivlist>

  <\proof>
    (a) Let <math|<around|(|X,x|)>> and<nbsp><math|<around|(|Y,y|)>> be
    pointed objects. For every morphism <math|f:X\<otimes\>Y\<to\>T*Z> there
    exists a unique morphism <math|f<rsup|\<flat\>>:T*X\<otimes\>Y\<to\>T*Z>
    such that that the diagram <vspace|2mm>

    <\equation>
      <label|fflat><move|<psmatrix|c*o*l*s*e*p=20*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|H*T*X\<otimes\>Y>|<cell|H*<around|(|T*X\<otimes\>Y|)>>|<cell|H*T*Z>>|<row|<cell|T*X\<otimes\>Y>|<cell|>|<cell|T*Z>>|<row|<cell|X\<otimes\>Y<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s<rsup|H>><ncline|1,2|1,3><rsup|H*f<rsup|\<flat\>>><ncline|1,1|2,1>\<less\>\<tau\>\<otimes\>Y<ncline|2,1|2,3><rsup|f<rsup|\<flat\>>><ncline|1,3|2,3>\<gtr\>\<tau\><ncline|3,1|2,1>\<less\>\<eta\>\<otimes\>Y<ncline|3,1|2,3>\<gtr\>f>|<cell|>|<cell|>>>>>|0pt|-12mm>
    </equation>

    <vspace|2mm>

    <no-indent>commutes. Indeed, the algebra<nbsp><math|T*Z> is completely
    iterative. Due to <math|<around|(|H*T*X+Y|)>\<otimes\>Y=H*T*X\<otimes\>Y+X\<otimes\>Y>,
    see Assumption<nbsp><reference|nncj>(3), we obtain an equation morphism
    in<nbsp><math|T*Z> as follows:

    <\equation*>
      T*X\<otimes\>Y<nsi|<around|[|\<tau\><rsub|X><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>>,\<eta\><rsub|X><rsup|T>|]><rsup|-1>\<otimes\>Y>H*T*X\<otimes\>Y+X\<otimes\>Y<nsi|s<rsup|H><rsub|X,Y>+f>H*<around|(|T*X\<otimes\>Y|)>+T*Z.
    </equation*>

    Its unique solution is denoted by<nbsp><math|f<rsup|\<flat\>>>. It is
    characterized by the commutative diagram <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=40*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|T*X\<otimes\>Y>|<cell|T*Z>>|<row|<cell|H*T*X\<otimes\>Y+X\<otimes\>Y>|<cell|>>|<row|<cell|H*<around|(|T*X\<otimes\>Y|)>+T*Z>|<cell|H*T*Z+T*Z<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|2,1|1,1>\<less\><around|[|\<tau\>,\<eta\><rsup|T>|]>\<otimes\>Y<ncline|2,1|3,1>\<less\>s<rsup|H>+f<ncline|1,1|1,2><rsup|f<rsup|\<flat\>>><ncline|3,1|3,2><rsub|H*f<rsup|\<flat\>>+T*Z><ncline|3,2|1,2>\<gtr\><around|[|\<tau\>,T*Z|]>>>>>>
    </equation*>

    <vspace|1mm>

    <no-indent>It is easy to verify that this diagram commutes iff
    <eqref|fflat><nbsp>does.

    (b) Put

    <\equation*>
      s<rsup|T><rsub|<around|(|X,x|)>,<around|(|Y,y|)>>=<around*|(|\<eta\><rsup|T><rsub|X\<otimes\>Y>|)><rsup|\<flat\>>:T*X\<otimes\>Y\<to\>T*<around|(|X\<otimes\>Y|)>.
    </equation*>

    In other words, we define the components of<nbsp><math|s<rsup|T>> via
    <eqref|fflat> uniquely.

    (b1) <math|s<rsup|T>><nbsp>is natural: the squares <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=35*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|T*X\<otimes\>Y>|<cell|T*<around|(|X\<otimes\>Y|)>>>|<row|<cell|T<rprime|'>*X\<otimes\>Y<rprime|'>>|<cell|T*<around|(|X<rprime|'>\<otimes\>Y<rprime|'>|)><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s<rsup|T>><ncline|1,1|2,1>\<less\>T*g\<otimes\>h<ncline|1,2|2,2>\<gtr\>T*<around|(|g\<otimes\>h|)><ncline|2,1|2,2><rsub|s<rsup|T>>>>>>>
    </equation*>

    <vspace|1mm>

    <no-indent>commute for all morphisms <math|g> and<nbsp><math|h>
    of<nbsp><math|I/<WW>> since both passages
    form<nbsp><math|f<rsup|\<flat\>>> for

    <\equation*>
      f=\<eta\><rsup|T><rsub|X<rprime|'>\<otimes\>Y<rprime|'>><tec><around|(|g\<otimes\>h|)>:X\<otimes\>Y\<to\>T*<around|(|X<rprime|'>\<otimes\>Y<rprime|'>|)>.
    </equation*>

    Indeed, for the upper passage, <math|f<rsup|\<flat\>>=T*<around|(|g\<otimes\>h|)><tec>s<rsup|T>>,
    use the following diagram: <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=19*m*m,r*o*w*s*e*p=15*m*m|<tformat|<table|<row|<cell|H*T*X\<otimes\>Y>|<cell|H*T*X\<otimes\>Y>|<cell|H*T*<around|(|X\<otimes\>Y|)>>|<cell|H*T*<around|(|X<rprime|'>\<otimes\>Y<rprime|'>|)>>>|<row|<cell|T*X\<otimes\>Y>|<cell|>|<cell|T*<around|(|X\<otimes\>Y|)>>|<cell|T*<around|(|X<rprime|'>\<otimes\>Y<rprime|'>|)>>>|<row|<cell|X\<otimes\>Y>|<cell|>|<cell|>|<cell|X<rprime|'>\<otimes\>Y<rprime|'><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s<rsup|H>><ncline|1,2|1,3><rsup|H*s<rsup|T>><ncline|1,3|1,4><rsup|H*T*<around|(|h\<otimes\>g|)>><ncline|1,1|2,1>\<less\>H*\<tau\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X>\<otimes\>Y<ncline|1,3|2,3>\<gtr\>\<tau\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X\<otimes\>Y><ncline|1,4|2,4>\<gtr\>\<tau\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X<rprime|'>\<otimes\>Y<rprime|'>><ncline|2,1|2,3><rsup|s<rsup|T>><ncline|2,3|2,4><rsup|T*<around|(|h\<otimes\>g|)>><ncline|3,1|2,1>\<less\>\<eta\><rsup|T><rsub|X>\<otimes\>Y<ncline|3,1|2,3>\<gtr\>\<eta\><rsup|T><rsub|X\<otimes\>Y><ncline|3,4|2,4>\<gtr\>\<eta\><rsup|T><rsub|X<rprime|'>\<otimes\>Y<rprime|'>><ncline|3,1|3,4><rsub|h\<otimes\>g>>>>>>
    </equation*>

    <vspace|1mm>

    <no-indent>The two left-hand parts form Diagram<nbsp><eqref|fflat>, the
    remaining two commute by naturality of <math|\<tau\>>
    and<nbsp><math|\<eta\>>.

    The lower passage <math|f<rsup|\<flat\>>=s<rsup|T><tec><around|(|T*g\<otimes\>h|)>>
    follows from the following diagram: <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=19*m*m,r*o*w*s*e*p=15*m*m|<tformat|<table|<row|<cell|H*T*X\<otimes\>Y>|<cell|H*T*X<rprime|'>\<otimes\>Y<rprime|'>>|<cell|H*<around|(|T<around|(|X<rprime|'>|)>\<otimes\>Y<rprime|'>|)>>|<cell|H*T*<around|(|X<rprime|'>\<otimes\>Y<rprime|'>|)>>>|<row|<cell|T*X\<otimes\>Y>|<cell|T*X<rprime|'>\<otimes\>Y<rprime|'>>|<cell|>|<cell|T*<around|(|X<rprime|'>\<otimes\>Y<rprime|'>|)>>>|<row|<cell|X\<otimes\>Y>|<cell|X<rprime|'>\<otimes\>Y<rprime|'><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|H*T*g\<otimes\>h><ncline|1,2|1,3><rsup|s<rsup|H>><ncline|1,3|1,4><rsup|H*s<rsup|T>><ncline|1,1|2,1>\<less\>\<tau\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X>\<otimes\>Y<ncline|1,2|2,2>\<gtr\>\<tau\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X<rprime|'>>\<otimes\>Y<rprime|'><ncline|1,4|2,4>\<gtr\>\<tau\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X<rprime|'>\<otimes\>Y<rprime|'>><ncline|2,1|2,2><rsup|T*g\<otimes\>h><ncline|2,2|2,4><rsup|s<rsup|T>><ncline|3,1|2,1>\<less\>\<eta\><rsup|T><rsub|X>\<otimes\>Y<ncline|3,2|2,2>\<gtr\>\<eta\><rsup|T><rsub|X<rprime|'>>\<otimes\>Y<rprime|'><ncline|3,2|2,4>\<gtr\>\<eta\><rsup|T><rsub|X<rprime|'>\<otimes\>Y<rprime|'>><ncline|3,1|3,2><rsub|g\<otimes\>h>>|<cell|>|<cell|>>>>>
    </equation*>

    <vspace|1mm>

    <no-indent>The right-hand parts form Diagram<nbsp><eqref|strength-T>, the
    left-hand ones commute by naturality of <math|\<tau\>>
    and<nbsp><math|\<eta\><rsup|T>>.

    (b2) <math|s<rsup|T>><nbsp>is a point-strength of the
    endofunctor<nbsp><math|T>. Indeed, the axiom

    <\equation>
      <label|strength-T>s<rsup|T><rsub|<around|(|X,x|)><around|(|V,v|)>>=<rsub|T<around|(|X|)>>
    </equation>

    follows from the fact that if <math|<around|(|Y,y|)>=<around|(|V,|)>>,
    then Diagram<nbsp><eqref|ffflat> commutes
    with<nbsp><rsub|<math|T<around|(|X|)>>> in lieu of<nbsp><math|s<rsup|T>>.
    To verify the Axiom<nbsp><eqref|triangle>, apply<nbsp>(a) to
    <math|f=\<eta\><rsup|T><rsub|X\<otimes\>Y\<otimes\>Z>>: we prove that the
    lower passage of<nbsp><eqref|triangle> serves
    as<nbsp><math|f<rsup|\<flat\>>>. In detail, the diagram <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=24*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|>|<cell|H*T*<around|(|X\<otimes\>Y|)>\<otimes\>Z>|<cell|H*<around|(|T*<around|(|X\<otimes\>Y|)>\<otimes\>Z|)>>>|<row|<cell|H*T*X\<otimes\>Y\<otimes\>Z>|<cell|H*<around|(|T*X\<otimes\>Y|)>\<otimes\>Z>|<cell|H*T*<around|(|X\<otimes\>Y\<otimes\>Z|)>>>|<row|<cell|T*X\<otimes\>Y\<otimes\>Z>|<cell|T*<around|(|X\<otimes\>Y|)>\<otimes\>Z>|<cell|T*<around|(|X\<otimes\>Y\<otimes\>Z|)>>>|<row|<cell|X\<otimes\>Y\<otimes\>Z<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|2,2|1,2>\<less\>H*s<rsup|T>\<otimes\>Z<ncline|1,2|1,3><rsup|s<rsup|H>><ncline|1,3|2,3>\<gtr\>H*s<rsup|T><ncline|2,1|2,2><rsup|s<rsup|H>\<otimes\>Z><ncline|2,1|3,1>\<less\>\<tau\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X>\<otimes\>Y\<otimes\>Z<ncarc*|a*r*c*a*n*g*l*e=75|1,2|3,2>\<gtr\>\<tau\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X\<otimes\>Y>\<otimes\>Z<ncline|2,3|3,3>\<gtr\>\<tau\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X\<otimes\>Y\<otimes\>Z><ncline|3,1|3,2><rsup|s<rsup|T>\<otimes\>Z><ncline|3,2|3,3><rsup|s<rsup|T>><ncline|4,1|3,1>\<less\>\<eta\><rsup|T><rsub|X>\<otimes\>Y\<otimes\>Z<ncline|4,1|3,2>\<less\>\<eta\><rsup|T><rsub|X\<otimes\>Y>\<otimes\>Z<ncline|4,1|3,3>\<gtr\><rule|0*p*t|10*p*t>\<eta\><rsup|T><rsub|X\<otimes\>Y\<otimes\>Z>>|<cell|>|<cell|>>>>>
    </equation*>

    <vspace|1mm>

    <no-indent>commutes. Indeed, all inner parts commute by two applications
    of<nbsp><eqref|ffflat>.

    (b3) It remains to verify the axioms of Definition<nbsp><reference|nncp>.
    For<nbsp><eqref|nnnrcp> use the lower triangle of
    Diagram<nbsp><eqref|ffflat>. For<nbsp><eqref|nnrcs> apply<nbsp>(a) to

    <\equation*>
      f=s<rsup|T>:T*X\<otimes\>Y\<to\>T*<around|(|X\<otimes\>Y|)>.
    </equation*>

    We prove that both passages of<nbsp><eqref|nnrcs> serve
    as<nbsp><math|f<rsup|\<flat\>>>. For the lower passage,
    <math|<around|(|s<rsup|T>|)><rsup|\<flat\>>=s<rsup|T><tec>\<mu\><rsup|T>\<otimes\>Y>,
    use the following diagram <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=22*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|H*T*T*X\<otimes\>Y>|<cell|H*T*<around|(|T*X\<otimes\>Y|)>>|<cell|H*T>|<cell|H*T*<around|(|X\<otimes\>Y|)>>>|<row|<cell|>|<cell|H*T*X\<otimes\>Y>|<cell|>|<cell|>>|<row|<cell|T*T*X\<otimes\>Y>|<cell|T*X\<otimes\>Y>|<cell|>|<cell|T*<around|(|X\<otimes\>Y|)>>>|<row|<cell|T*X\<otimes\>Y<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s<rsup|H>><ncline|1,2|1,3><rsup|<rule|6*m*m|0*m*m>H*<around|(|\<mu\><rsup|T>\<otimes\>Y|)>><ncline|1,3|1,4><rsup|H*s<rsup|T>><ncline|1,1|2,2>\<less\>H*\<mu\><rsup|T>\<otimes\>Y<ncline|2,2|1,3>\<gtr\>s<rsup|H><ncline|2,2|3,2>\<gtr\>\<tau\>\<otimes\>Y<ncline|1,1|3,1>\<less\>\<tau\>\<otimes\>Y<ncline|1,4|3,4>\<gtr\>\<tau\><ncline|3,1|3,2><rsup|\<mu\><rsup|T>\<otimes\>Y><ncline|3,2|3,4><rsup|s<rsup|T>><ncline|4,1|3,1>\<less\>\<eta\><rsup|T>*T\<otimes\>Y<ncline*|d*o*u*b*l*e*l*i*n*e=t*r*u*e|-|4,1|3,2><ncline|4,1|3,4>\<gtr\>s<rsup|T>>|<cell|>|<cell|>|<cell|>>>>>
    </equation*>

    <vspace|1mm>

    <no-indent>The upper left-hand part is Equation<nbsp><eqref|homo>, the
    lower one commutes by the monad axiom
    <math|\<mu\><rsup|T><tec>\<eta\><rsup|T>*T=>, the upper triangle is the
    naturality of<nbsp><math|s<rsup|H>>, and the right-hand part follows
    from<nbsp><eqref|ffflat>.

    For the upper passage, <math|<around|(|s<rsup|T>|)><rsup|\<flat\>>=\<mu\><rsup|T><tec>T*s<rsup|T><tec>s<rsup|T>>,
    use the following diagram <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=19*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|H*<around|(|T*T*X\<otimes\>Y|)>>|<cell|>|<cell|>|<cell|>>|<row|<cell|H*T*T*X\<otimes\>Y>|<cell|H*T*<around|(|T*X\<otimes\>Y|)>>|<cell|H*T*T*<around|(|X\<otimes\>Y|)>>|<cell|H*T*<around|(|X\<otimes\>Y|)>>>|<row|<cell|T*T*X\<otimes\>Y>|<cell|T*<around|(|T*X\<otimes\>Y|)>>|<cell|T*T*<around|(|X\<otimes\>Y|)>>|<cell|T*<around|(|X\<otimes\>Y|)>>>|<row|<cell|T*X\<otimes\>Y<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|2,1|1,1>\<less\>s<rsup|H><ncline|1,1|2,2>\<gtr\>H*s<rsup|T><ncline|2,2|2,3><rsup|H*T*s<rsup|T>><ncline|2,3|2,4><rsup|H*\<mu\><rsup|T>><ncline|2,1|3,1>\<less\>\<tau\>\<otimes\>Y<ncline|2,2|3,2>\<gtr\>\<tau\><ncline|2,3|3,3>\<gtr\>\<tau\><ncline|2,4|3,4>\<gtr\>\<tau\><ncline|3,1|3,2><rsup|s<rsup|T>><ncline|3,2|3,3><rsup|T*s<rsup|T>><ncline|3,3|3,4><rsup|\<mu\><rsup|T>><ncline|4,1|3,1>\<less\>\<eta\><rsup|T>\<otimes\>Y<ncline|4,1|3,2>\<less\>\<eta\><rsup|T><ncline|4,1|3,4>\<gtr\><rule|8*p*t|0*p*t>s<rsup|T>>|<cell|>|<cell|>|<cell|>>>>>
    </equation*>

    The three upper squares commute due to<nbsp><eqref|ffflat>, the
    naturality of<nbsp><math|\<tau\>> and<nbsp><eqref|homo>. The lower
    triangles commute due to<nbsp><eqref|ffflat>, the naturality
    of<nbsp><math|s<rsup|T>> and <math|\<mu\><rsup|T><tec>\<eta\><rsup|T>*T=>.
  </proof>

  <\rem>
    <label|R:monad-T>Recall from Example<nbsp><reference|ndoa> that
    <math|T=H*T+<Id>> with injections <math|\<tau\>>
    and<nbsp><math|\<eta\><rsup|T>>. From the Diagram<nbsp><eqref|ffflat> we
    see that the strength<nbsp><math|s<rsup|T>> then has the form

    <\equation*>
      s<rsup|T>=H*s<rsup|T><tec>s<rsup|H>+X\<otimes\>Y:H*T*X\<otimes\>Y+X\<otimes\>Y\<to\>H*T*<around|(|X\<otimes\>Y|)>+X\<otimes\>Y.
    </equation*>
  </rem>

  <\thm>
    <label|nncs>The rational monad of a point-strong endofunctor is
    point-strong.
  </thm>

  <\trivlist>
    <item*|<space|labelsep><with|font-series|bold|Remark.>>The strength
    of<nbsp><rr> will be proved to be the unique natural
    transformation<nbsp><math|s<rsup|R>> for which the diagram <vspace|2mm>

    <\equation>
      <label|nnrcsjp><move|<psmatrix|c*o*l*s*e*p=20*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|H*R*X\<otimes\>Y>|<cell|H*<around|(|R*X\<otimes\>Y|)>>|<cell|H*R*<around|(|X\<otimes\>Y|)>>>|<row|<cell|R*X\<otimes\>Y>|<cell|>|<cell|R*<around|(|X\<otimes\>Y|)>>>|<row|<cell|X\<otimes\>Y<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s<rsup|H>><ncline|1,2|1,3><rsup|H*s<rsup|R>><ncline|1,1|2,1>\<less\>\<varrho\><rsub|X>\<otimes\>Y<ncline|2,1|2,3><rsup|s<rsup|R>><ncline|1,3|2,3>\<gtr\>\<varrho\><rsub|X\<otimes\>Y><ncline|3,1|2,1>\<less\>\<eta\><rsub|X>\<otimes\>Y<ncline|3,1|2,3>\<gtr\>\<eta\><rsub|X\<otimes\>Y>>|<cell|>|<cell|>>>>>|0pt|-12mm>
    </equation>

    <vspace|2mm>

    <no-indent>commutes.
  </trivlist>

  <\proof>
    (a) Given pointed objects <math|<around|(|X,x|)>>
    and<nbsp><math|<around|(|Y,y|)>>, we prove that for every morphism
    <math|f:X\<otimes\>Y\<to\>R*Z> there exists a unique morphism
    <math|f<rsup|\<flat\>>:R*X\<otimes\>Y\<to\>R*Z> such that the following
    diagram commutes: <vspace|3mm>

    <\equation>
      <label|nnrcss><move|<psmatrix|c*o*l*s*e*p=20*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|H*R*X\<otimes\>Y>|<cell|H*<around|(|R*X\<otimes\>Y|)>>|<cell|H*R*Z>>|<row|<cell|R*X\<otimes\>Y>|<cell|>|<cell|R*Z>>|<row|<cell|X\<otimes\>Y<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s<rsup|H>><ncline|1,2|1,3><rsup|H*f<rsup|\<flat\>>><ncline|1,1|2,1>\<less\>\<varrho\><rsub|X>\<otimes\>Y<ncline|2,1|2,3><rsup|f<rsup|\<flat\>>><ncline|1,3|2,3>\<gtr\>\<varrho\><rsub|Z><ncline|3,1|2,1>\<less\>\<eta\><rsub|X>\<otimes\>Y<ncline|3,1|2,3>\<gtr\>f>|<cell|>|<cell|>>>>>|0pt|-12mm>
    </equation>

    <vspace|3mm>

    (a1) Assume that <math|Y><nbsp>is finitely presentable. Recall
    <math|R*Y=<colim><math-ss|Eq><rsub|Y>> from Remark<nbsp><reference|nnct>.
    For every object

    <\equation*>
      e:W\<to\>H*W+X<space|2em><text|in ><math-ss|EQ><rsub|X>
    </equation*>

    define, using the distributivity <math|<around|(|H*W+Y|)>\<otimes\>Y=H*W\<otimes\>Y+X\<otimes\>Y>
    (see Assumption<nbsp><reference|nncj>(3)), the equation morphism

    <\equation>
      <label|rcxxx><wide|e|^>\<equiv\>W\<otimes\>Y<nsi|e\<otimes\>Y>H*W\<otimes\>Y+X\<otimes\>Y<nsi|s<rsup|H>+f>H*<around|(|W\<otimes\>Y|)>+R*Z.
    </equation>

    Since <math|W\<otimes\>Y> is finitely presentable by
    Assumption<nbsp><reference|nncj>(2), we obtain the unique solution
    <math|<wide|e|^><rsup|\<dag\>>:W\<otimes\>Y\<to\>R*Z>, and those
    solutions form a cocone of the diagram
    <math|<math-ss|Eq><rsub|X>\<otimes\>Y>. Indeed, given a connecting
    morphism <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=20*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|W>|<cell|H*W+X>>|<row|<cell|W<rprime|'>>|<cell|H*W<rprime|'>+X<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|e<rule|5*m*m|0*m*m>><ncline|1,1|2,1>\<less\>h<ncline|2,1|2,2><rsub|e<rprime|'><rule|5*m*m|0*m*m>><ncline|1,2|2,2>\<gtr\>H*h+X>>>>>
    </equation*>

    <vspace|2mm>

    <no-indent>then <math|h\<otimes\>Y> is a coalgebra homomorphism
    from<nbsp><math|<wide|e|^>> to<nbsp><math|<wide|e|^><rprime|'>>:
    <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=20*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|W\<otimes\>Y>|<cell|<around|(|H*W\<otimes\>Y|)>+<around|(|X\<otimes\>Y|)>>|<cell|H*<around|(|W\<otimes\>Y|)>+R*Z>>|<row|<cell|W<rprime|'>\<otimes\>Y>|<cell|<around|(|H*W<rprime|'>\<otimes\>Y|)>+<around|(|X\<otimes\>Y|)>>|<cell|H*<around|(|W<rprime|'>\<otimes\>Y|)>+R*Z<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|e\<otimes\>Y<rule|12*m*m|0*m*m>><ncline|1,2|1,3><rsup|s<rsup|H>+f><ncline|1,1|2,1>\<less\>h\<otimes\>Y<ncline|1,2|2,2>\<gtr\><around|(|H*h\<otimes\>Y|)>+<around|(|X\<otimes\>Y|)><ncline|2,1|2,2><rsub|e<rprime|'>\<otimes\>Y<rule|12*m*m|0*m*m>><ncline|1,3|2,3>\<gtr\>H*<around|(|h\<otimes\>Y|)>+R*Z<ncline|2,2|2,3><rsub|s<rsup|H>+f>>>>>>
    </equation*>

    <vspace|2mm>

    <no-indent>which implies, by Remark<nbsp><reference|nnct>(v) that

    <\equation*>
      <wide|e|^><rsup|\<dag\>>=<wide|e<rprime|'>|^><rule|0*p*t|11*p*t><rsup|\<dag\>><tec><around|(|h\<otimes\>Y|)>.
    </equation*>

    Consequently, we can define

    <\equation*>
      f<rsup|\<flat\>>:R*X\<otimes\>Y\<to\>R*Z
    </equation*>

    by the commutativity of the triangles <vspace|3mm>

    <\equation>
      <label|nnrco><move|<psmatrix|c*o*l*s*e*p=20*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|W\<otimes\>Y>|<cell|>>|<row|<cell|R*X\<otimes\>Y>|<cell|R*Z<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|2,1>\<less\>e<rsup|#>\<otimes\>Y<ncline|1,1|2,2>\<gtr\><wide|e|^><rsup|\<dag\>><ncline|2,1|2,2><rsub|f<rsup|\<flat\>>>>>>>>|0pt|-7mm><space|2em><space|1em><text|for
      all <math|e\<in\><math-ss|EQ><rsub|X>>.>
    </equation>

    <vspace|2mm>

    <no-indent>Indeed, since <math|-\<otimes\>Y> is a finitary functor by
    Assumption<nbsp><reference|nncj>(4), we see that <math|R*X\<otimes\>Y> is
    a colimit of<nbsp><math|<math-ss|Eq><rsub|Y>\<otimes\>Y> with the colimit
    cocone <math|e<rsup|#>\<otimes\>Y>. We now verify that the
    Diagram<nbsp><eqref|nnrcss> commutes. Consider the diagram below:
    <vspace|3mm>

    <\equation>
      <label|rcyyy><move|<psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|W\<otimes\>Y>|<cell|R*X\<otimes\>Y>|<cell|R*Z>>|<row|<cell|H*W\<otimes\>Y+X\<otimes\>Y>|<cell|H*R*X\<otimes\>Y+X\<otimes\>Y>|<cell|>>|<row|<cell|H*<around|(|W\<otimes\>Y|)>+R*Z>|<cell|H*<around|(|R*X\<otimes\>Y|)>+R*Z>|<cell|H*R*Z+R*Z<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|2,1>\<less\>e\<otimes\>Y<ncline|1,1|1,2><rsup|e<rsup|#>\<otimes\>Y><ncline|1,2|1,3><rsup|f<rsup|\<flat\>>><ncline|1,2|2,2>\<less\>i<rsub|X>\<otimes\>Y<ncline|2,1|2,2><rsub|H*e<rsup|#>\<otimes\>Y+X\<otimes\>Y><ncline|2,1|3,1>\<less\>s<rsup|H>+f<ncline|2,2|3,2>\<gtr\>s<rsup|H>+f<ncline|3,1|3,2><rsub|H*<around|(|e<rsup|#>\<otimes\>Y|)>+R*Z><ncline|3,2|3,3><rsub|H*f<rsup|\<flat\>>+R*Z><ncline|3,3|1,3>\<less\><around|[|\<varrho\><rsub|Z>,R*Z|]><ncarc*|a*r*c*a*n*g*l*e=-30,l*i*n*e*s*t*y*l*e=d*a*s*h*e*d|2,2|1,2>\<gtr\><around|[|\<varrho\><rsub|X>\<otimes\>Y,\<eta\><rsub|X>\<otimes\>Y|]>>>>>>|0pt|-17mm>
    </equation>

    <vspace|2mm>

    <no-indent>Notice first that the left-hand edge
    is<nbsp><math|<wide|e|^>>. The upper left-hand part commutes
    by<nbsp><eqref|nnrcc>, and the lower one does by naturality
    of<nbsp><math|s<rsup|H>>. The outside of the diagram commutes since
    <math|f<rsup|\<flat\>><tec><around|(|e<rsup|#>\<otimes\>Y|)>> is the
    unique solution of<nbsp><math|<wide|e|^>> in the iterative
    algebra<nbsp><math|R*Z>. Thus, the right-hand part commutes when
    precomposed by any <math|e<rsup|#>\<otimes\>Y>. So since the latter
    morphisms are collectively epimorphic (being the injections of
    <math|<colim><math-ss|Eq><rsub|X>\<otimes\>Y>), we see that the
    right-hand part commutes. Now we use that <math|i<rsub|X>><nbsp>is an
    isomorphism with the inverse<nbsp><math|<around|[|\<varrho\><rsub|X>,\<eta\><rsub|X>|]>>,
    see Equation<nbsp><eqref|nnrcp>, which implies

    <\equation*>
      <around|[|\<varrho\><rsub|X>\<otimes\>Y,\<eta\><rsub|X>\<otimes\>Y|]>=<around|(|i<rsub|X>\<otimes\>Y|)><rsup|-1>.
    </equation*>

    Finally observe that the two coproduct components of the right-hand part
    of<nbsp><eqref|rcyyy> yield precisely the upper and lower parts
    of<nbsp><eqref|nnrcss>\Vthis proves that <eqref|nnrcss><nbsp>commutes.

    It only remains to prove the uniqueness of<nbsp><math|f<rsup|\<flat\>>>.
    So suppose we have some <math|f<rsup|\<flat\>>> such that
    Diagram<nbsp><eqref|nnrcss> commutes. Equivalently, the right-hand part
    of<nbsp><eqref|rcyyy> commutes, and this implies that
    <math|f<rsup|\<flat\>><tec><around|(|e<rsup|#>\<otimes\>Y|)>> is, for
    every<nbsp><math|e> in<nbsp><math|<math-ss|EQ><rsub|X>>, a solution
    of<nbsp><math|<wide|e|^>>. This determines<nbsp><math|f<rsup|\<flat\>>>
    uniquely.

    (a2) Let <math|Y><nbsp>be arbitrary. Then since <WW><nbsp>is locally
    finitely presentable we can express<nbsp><math|Y> as a filtered colimit

    <\equation*>
      Y=<colim><rsub|q\<in\>Q>Y<rsup|q>*<space|2em><text|with colimit cocone
      >y<rsup|q>:Y<rsup|q>\<to\>Y
    </equation*>

    of finitely presentable objects<nbsp><math|Y<rsup|q>>. By
    Assumption<nbsp><reference|nncj>(2) the unit object<nbsp><math|I> is
    finitely presentable, thus the given pointing of<nbsp><math|Y>:

    <\equation*>
      y:I\<to\><colim><rsub|q\<in\>Q>Y<rsup|q>
    </equation*>

    factorizes through some<nbsp><math|y<rsup|q>>. The diagram above being
    filtered, we can assume that this factorization takes place for every
    <math|q\<in\>Q>, in other words, that we have a filtered diagram of
    pointed objects<nbsp><math|Y<rsup|q>> with colimit<nbsp><math|Y> (and
    with all the connecting morphisms <math|Y<rsup|q>\<to\>Y<rsup|q<rprime|'>>>
    preserving the pointing).

    Given <math|f:X\<otimes\>Y\<to\>R*Z>, for every <math|q\<in\>Q> we know
    from the previous part<nbsp>(a1) that there exists a unique

    <\equation*>
      f<rsub|q><rsup|\<flat\>>:R*X\<otimes\>Y<rsup|q>\<to\>R*Z
    </equation*>

    such that Diagram<nbsp><eqref|nnrcss> commutes when
    <math|f<rsup|\<flat\>>><nbsp>is replaced
    by<nbsp><math|f<rsup|\<flat\>><rsub|q>> and <math|f><nbsp>by

    <\equation*>
      f<rsub|q>\<equiv\>X\<otimes\>Y<rsup|q><nsi|X\<otimes\>y<rsup|q>>X\<otimes\>Y<nsi|f>R*Z.
    </equation*>

    This defines a unique <math|f<rsup|\<flat\>>:R*X\<otimes\>Y\<to\>R*Z>
    with

    <\equation>
      <label|nrcjsa>f<rsup|\<flat\>><rsub|q>=f<rsup|\<flat\>><tec><around|(|R*X\<otimes\>y<rsup|q>|)><space|2em><text|for
      all <math|q\<in\>Q>.>
    </equation>

    Now Diagram<nbsp><eqref|nnrcss> commutes because
    <math|H*R*X\<otimes\>Y=<colim><rsub|q\<in\>Q>H*R*X\<otimes\>Y<rsup|q>> as
    well as <math|X\<otimes\>Y=<colim><rsub|q\<in\>Q>X\<otimes\>Y<rsup|q>>.
    And <math|f<rsup|\<flat\>>><nbsp>is uniquely determined by this
    commutativity; indeed, for any<nbsp><math|f<rsup|\<flat\>>> such that
    <eqref|nnrcss><nbsp>commutes one easily verifies that<nbsp><eqref|nrcjsa>
    holds using the uniqueness of<nbsp><math|f<rsup|\<flat\>><rsub|q>> from
    part<nbsp>(a1).

    (b) Analogously to the proof of Theorem<nbsp><reference|T:monad-T> put

    <\equation>
      <label|nnrcojp>s<rsup|R><rsub|<around|(|X,x|)>,<around|(|Y,y|)>>=\<eta\><rsup|\<flat\>><rsub|X\<otimes\>Y>:R*X\<otimes\>Y\<to\>R*<around|(|X\<otimes\>Y|)>.
    </equation>

    The verification that <math|s<rsup|R>><nbsp>is the desired strength is
    analogous to the above proof: just replace <math|T> by<nbsp><math|R> (and
    <math|\<tau\>> by<nbsp><math|\<varrho\>>).
  </proof>

  <\rem>
    <label|R:new>The proofs of Theorems <reference|T:monad-T>
    and<nbsp><reference|nncs> have the same structure, and also the proof
    that the monad<nbsp><math|\<bbb-F\><rsub|\<lambda\>,<Sig>>> is
    point-strong can proceed analogously:

    Let <math|H><nbsp>be a point-strong endofunctor of<nbsp><WW> and let
    <math|<around|(|<wide|M|^>,<wide|\<mu\>|^>,<wide|\<eta\>|^>|)>><nbsp>be a
    monad. Suppose that a natural transformation
    <math|\<alpha\>:H*<wide|M|^>\<to\><wide|M|^>> has the property that for
    every morphism <math|f:X\<otimes\>Y\<to\>M*Z> there exists a unique
    morphism <math|f<rsup|\<flat\>>:M*X\<otimes\>Y\<to\>M*Z> with
    <math|f=f<rsup|\<flat\>><tec><around|(|<wide|\<eta\>|^><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X>\<otimes\>Y|)>>
    and <math|f<rsup|\<flat\>><tec><around|(|\<alpha\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X>\<otimes\>Y|)>=\<alpha\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X><tec>H*f<rsup|\<flat\>><tec>s<rsup|H>>.
    Then <math|M><nbsp>is a point-strong monad w.r.t.
    <math|s<rsup|M>=<wide|\<eta\>|^><rsup|\<flat\>><rsub|X\<otimes\>Y>>.
  </rem>

  <\rem>
    <label|copr>The morphisms

    <\equation*>
      \<varrho\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X>:H*R*X\<to\>R*X*<space|2em><text|and><space|2em>\<eta\><rsup|<resize||0pt|-0.3bls|0pt|0.7bls>><rsub|X>:X\<to\>R*X
    </equation*>

    of<nbsp><eqref|nnrcsjp> are coproduct injections of

    <\equation*>
      R*X=H*R*X+X
    </equation*>

    as proved in<nbsp><cite|AMV1>. From diagram<nbsp><eqref|nnrcsjp> we
    conclude that the strength of<nbsp><rr>,

    <\equation*>
      s<rsup|R>:R*X\<otimes\>Y\<to\>R*<around|(|X\<otimes\>Y|)>
    </equation*>

    whose domain is <math|H*R*X\<otimes\>Y+X\<otimes\>Y>
    by<nbsp><reference|nncj>(2) and codomain is
    <math|H*R*<around|(|X\<otimes\>Y|)>+X\<otimes\>Y>, has the form

    <\equation*>
      s<rsup|R>=H*s<rsup|R><tec>s<rsup|H>+X\<otimes\>Y.
    </equation*>
  </rem>

  <\cor>
    <label|nncss>For a point-strong endofunctor<nbsp><math|H> the free
    iterative <math|H>-algebra

    <\equation*>
      R*I
    </equation*>

    on the unit object is an <math|H>-monoid w.r.t. the unit
    <math|i=\<eta\><rsub|I>:I\<to\>R*I> and the multiplication

    <\equation>
      <label|multi>m\<equiv\>R*I\<otimes\>R*I<nsi|s<rsup|R><rsub|I,R*I>>R*R*I<nsi|\<mu\><rsub|I>>R*I.
    </equation>
  </cor>

  <\proof>
    Indeed, the unit laws are obvious: <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=20*m*m|<tformat|<table|<row|<cell|>|<cell|I\<otimes\>R*I>|<cell|R*I>|<cell|>>|<row|<cell|>|<cell|R*I\<otimes\>R*I>|<cell|R*R*I>|<cell|R*I>>|<row|<cell|>|<cell|R*I\<otimes\>I>|<cell|R*I<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,2|2,2>\<less\>\<eta\><rsub|I>\<otimes\>R*I<ncline|1,2|2,2>\<gtr\><rule|10*m*m|0*m*m><eqref|n*n*r*c*s*j*p><ncline|1,3|2,3>\<less\>\<eta\><rsub|R*I><ncline*|d*o*u*b*l*e*l*i*n*e=t*r*u*e,a*r*r*o*w*s=-|1,3|2,4><ncline|2,2|2,3><rsub|s<rsup|R><rsub|I,R*I>><ncline|2,3|2,4><rsub|\<mu\><rsub|I>><ncline|3,2|2,2>\<less\>R*I\<otimes\>\<eta\><rsub|I><ncline|3,3|2,3>\<less\>R*\<eta\><rsub|I><ncline|3,2|3,3><rsub|s<rsup|R><rsub|I,I>><ncline*|d*o*u*b*l*e*l*i*n*e=t*r*u*e,a*r*r*o*w*s=-|3,3|2,4><ncline*|d*o*u*b*l*e*l*i*n*e=t*r*u*e,a*r*r*o*w*s=-|1,2|1,3>>|<cell|>>>>>
    </equation*>

    <vspace|2mm>

    <no-indent>where the lower square commutes by the naturality
    of<nbsp><math|s<rsup|R>>. For the associativity we have the following
    commutative diagram <vspace|6mm>

    <\equation*>
      <rule|7*m*m|0*m*m><psmatrix|c*o*l*s*e*p=18*m*m|<tformat|<table|<row|<cell|R*I\<otimes\>R*I\<otimes\>R*I>|<cell|>|<cell|R*I\<otimes\>R*R*I>|<cell|R*I\<otimes\>R*I>>|<row|<cell|R*R*I\<otimes\>R*I>|<cell|R*<around|(|R*I\<otimes\>R*I|)>>|<cell|R*R*R*I>|<cell|R*R*I>>|<row|<cell|R*I\<otimes\>R*I>|<cell|>|<cell|R*R*I>|<cell|R*I<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,3><rsub|R*I\<otimes\>s<rsup|R><rsub|I,R*I>><ncline|1,3|1,4><rsub|R*I\<otimes\>\<mu\><rsub|I>><ncline|1,1|2,1>\<gtr\>s<rsup|R><rsub|I,R*I>\<otimes\>R*I<ncline|1,3|2,3>\<less\>s<rsup|R><rsub|I,R*R*I><ncline|1,4|2,4>\<less\>s<rsup|R><rsub|I,R*I><ncline|2,1|2,2><rsup|s<rsup|R><rsub|R*I,R*I>><ncline|2,2|2,3><rsup|R*s<rsup|R><rsub|I,R*I>><ncline|2,3|2,4><rsup|R*\<mu\><rsub|I>><ncline|2,1|3,1>\<gtr\>\<mu\><rsub|I>\<otimes\>R*I<rule|24*m*m|0*m*m><eqref|n*n*r*c*s><ncline|2,3|3,3>\<less\>\<mu\><rsub|R*I><ncline|3,1|3,3><rsup|s<rsup|R><rsub|I,R*I>><ncline|3,3|3,4><rsup|\<mu\><rsub|I>><ncline|2,4|3,4>\<less\>\<mu\><rsub|I><ncarc*|a*r*c*a*n*g*l*e=10|1,1|1,4><rsup|R*I\<otimes\>m><ncarc*|a*r*c*a*n*g*l*e=-10|3,1|3,4><rsub|m><ncarc*|a*r*c*a*n*g*l*e=-57|1,1|3,1>\<less\>m\<otimes\>R*I<ncarc*|a*r*c*a*n*g*l*e=30|1,4|3,4>\<gtr\>m<ncline|1,1|2,2>\<gtr\>s<rsup|R><rsub|I,R*I\<otimes\>R*I>>>>>>
    </equation*>

    <vspace|5mm>

    <no-indent>Finally, the Diagram<nbsp><eqref|abb> commutes due
    to<nbsp><eqref|nnrcsjp>: <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=20*m*m|<tformat|<table|<row|<cell|H*R*I\<otimes\>R*I>|<cell|H*<around|(|R*I\<otimes\>R*I|)>>|<cell|H*R*R*I>|<cell|H*R*I>>|<row|<cell|R*I\<otimes\>R*I>|<cell|>|<cell|R*R*I>|<cell|R*I<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s<rsup|H>><ncline|1,2|1,3><rsub|H*s<rsup|R>><ncline|1,3|1,4><rsub|H*\<mu\>><ncline|1,1|2,1>\<less\>\<varrho\>\<otimes\>R*I<ncline|1,3|2,3>\<gtr\>\<varrho\>*R<ncline|1,4|2,4>\<gtr\>\<varrho\><ncline|2,1|2,3><rsup|s<rsup|R>><ncline|2,3|2,4><rsup|\<mu\>><ncarc*|a*r*c*a*n*g*l*e=10|1,2|1,4><rsup|H*m><ncarc*|a*r*c*a*n*g*l*e=-10|2,1|2,4><rsub|m>>>>>>
    </equation*>
  </proof>

  <vspace|2mm>

  <\cor>
    <label|cojp>The free completely iterative <math|H>-algebra

    <\equation*>
      T*I
    </equation*>

    on the unit object is an <math|H>-monoid w.r.t.
    <math|\<eta\><rsup|T><rsub|I>> and<nbsp><math|\<mu\><rsup|T><rsub|I><tec>s<rsup|T><rsub|I,T*I>>.
  </cor>

  The proof is completely analogous to the previous one.

  <\notation>
    <label|nnco>Let

    <\equation*>
      e:W\<to\>H*W+I
    </equation*>

    be a flat equation morphism in<nbsp><math|I>, and let a pointing
    of<nbsp><math|W> be given.

    <\enumerate>
      <item*|(i)><math|e<rsup|#>:W\<to\>R*I> denotes the colimit morphism of
      <math|R*I=<colim><math-ss|Eq><rsub|I>> and

      <\equation*>
        <wide|e<rsup|#>|^>:R*W\<to\>R*I
      </equation*>

      its unique extension to a homomorphism of <math|H>-algebras.

      <item*|(ii)><math|e\<ast\>W><nbsp>denotes the following equation
      morphism in<nbsp><math|W>:

      <\equation*>
        e\<ast\>W\<equiv\>W\<otimes\>W<nsi|e\<otimes\>W>H*W\<otimes\>W+W<nsi|s<rsup|H>+W>H*<around|(|W\<otimes\>W|)>+W.
      </equation*>

      <item*|(iii)><math|<around|\<langle\>|e|\<rangle\>>:W\<otimes\>W+W\<to\>H*<around|(|W\<otimes\>W+W|)>+I>
      denotes the flat equation morphism whose left-hand component is
      <vspace|3mm>

      <\equation*>
        <psmatrix|c*o*l*s*e*p=15*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|<around|\<langle\>|e|\<rangle\>><tec><inl>\<equiv\>W\<otimes\>W>|<cell|H*<around|(|W\<otimes\>W|)>+W>|<cell|>>|<row|<cell|>|<cell|H*<around|(|W\<otimes\>W|)>+H*W+I>|<cell|H*<around|(|W\<otimes\>W+W|)>+I<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|e\<ast\>W><ncline|1,2|2,2>\<less\>H*<around|(|W\<otimes\>W|)>+e<ncline|2,2|2,3><rsup|<can>+I>>>>>>
      </equation*>

      and the right-hand one is

      <\equation*>
        <around|\<langle\>|e|\<rangle\>><tec><inr>\<equiv\>W<nsi|e>H*W+I<nsi|H<inr>+I>H*<around|(|W\<otimes\>W+W|)>+I.
      </equation*>
    </enumerate>
  </notation>

  <\lem>
    <label|nncdv>For every flat equation morphism <math|e:W\<to\>H*W+I> with
    <math|W><nbsp>pointed the square <vspace|3mm>

    <\equation>
      <label|nnrcjn><move|<psmatrix|<tformat|<table|<row|<cell|W\<otimes\>W>|<cell|R*W>>|<row|<cell|W\<otimes\>W+W>|<cell|R*I<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|<rule|3*m*m|0*m*m><around|(|e\<ast\>W|)><rsup|#>><ncline|1,2|2,2>\<gtr\><wide|e<rsup|#>|^><ncline|1,1|2,1>\<less\><inl><ncline|2,1|2,2><rsub|<rule|7*m*m|0*m*m><around|\<langle\>|e|\<rangle\>><rsup|#>>>>>>>|0pt|-10mm>
    </equation>

    commutes.
  </lem>

  <\proof>
    Notice that <math|<around|\<langle\>|e|\<rangle\>>><nbsp>is precisely of
    the form <math|e<ctv>f> from Remark<nbsp><reference|nnct>(vi) for
    <math|f=e\<ast\>W>. Also recall from Remark<nbsp><reference|nnct>(iv)
    that <math|<around|\<langle\>|e|\<rangle\>><rsup|#>=<around|(|\<eta\>\<bullet\><around|\<langle\>|e|\<rangle\>>|)><rsup|\<dag\>>>
    and similarly <math|<around|(|e\<ast\>W|)><rsup|#>=<around|(|\<eta\>\<bullet\><around|(|e\<ast\>W|)>|)><rsup|\<dag\>>>.
    We shall also use that the <math|H>-algebra
    homomorphism<nbsp><math|<wide|e<rsup|#>|^>> preserves solutions (cf.
    Remark<nbsp><reference|nnct>(vii)). Thus, we compute

    <align*|<tformat|<table|<row|<cell|<wide|e<rsup|#>|^><tec><around|(|e\<ast\>W|)><rsup|#>>|<cell|=<wide|e<rsup|#>|^><tec><around*|(|\<eta\>\<bullet\><around|(|e\<ast\>W|)>|)><rsup|\<dag\>>>|<cell|<text|<reference|nnct>(iv)>>>|<row|<cell|>|<cell|=<around*|(|<around|(|<wide|e<rsup|#>|^><tec>\<eta\>|)>\<bullet\><around|(|e\<ast\>W|)>|)><rsup|\<dag\>>>|<cell|<text|<reference|nnct>(vii)>>>|<row|<cell|>|<cell|=<around*|(|e<rsup|#>\<bullet\><around|(|e\<ast\>W|)>|)><rsup|\<dag\>>>|<cell|<wide|e<rsup|#>|^><text|
    extends >e<rsup|#>>>|<row|<cell|>|<cell|=<around*|(|<around|(|\<eta\><tec>e|)><rsup|\<dag\>>\<bullet\><around|(|e\<ast\>W|)>|)><rsup|\<dag\>>>|<cell|<text|<reference|nnct>(iv)>>>|<row|<cell|>|<cell|=<around|(|\<eta\><tec>e<ctv>e\<ast\>W|)><rsup|\<dag\>><tec><inl>>|<cell|<text|<eqref|rcoo>>>>|<row|<cell|>|<cell|=<around*|(|\<eta\>\<bullet\><around*|(|e<ctv><around|(|e\<ast\>W|)>|)>|)><rsup|\<dag\>><tec><inl>>|<cell|<text|obvious>>>|<row|<cell|>|<cell|=<around*|(|e<ctv><around|(|e\<ast\>W|)>|)><rsup|#><tec><inl>>|<cell|<text|<reference|nnct>(iv)>>>|<row|<cell|>|<cell|=<around|\<langle\>|e|\<rangle\>><rsup|#><tec><inl>>|<cell|<text|<reference|nnct>(vi)>>>>>>

    This completes the proof.
  </proof>

  <\thm>
    <label|nncjn>Let <math|H><nbsp>be a finitary, point-strong endofunctor.
    Then the above <math|H>-monoid<nbsp><math|R*I> is the initial iterative
    <math|H>-monoid.
  </thm>

  That is, for every <math|H>-monoid<nbsp><math|A> there exists precisely one
  morphism <math|h:R*I\<to\>A> which is both a monoid homomorphism and a
  homomorphism of <math|H>-algebras.

  <\proof>
    (1) Given an iterative <math|H>-monoid

    <\equation*>
      <wide|a|\<bar\>>:H*<wide|A|\<bar\>>\<to\><wide|A|\<bar\>>,<space|2em><wide|i|\<bar\>>:I\<to\><wide|A|\<bar\>>*<space|2em><text|and><space|2em><wide|m|\<bar\>>:<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>\<to\><wide|A|\<bar\>>
    </equation*>

    we know that there is a unique <math|H>-algebra homomorphism

    <\equation*>
      h:R*I\<to\><wide|A|\<bar\>>*<space|2em><text|with><space|2em>h<tec>\<eta\><rsub|I>=<wide|i|\<bar\>>.
    </equation*>

    It is our task to prove that <math|h><nbsp>preserves multiplication:
    <vspace|3mm>

    <\equation>
      <label|nnnrcjj><move|<psmatrix|<tformat|<table|<row|<cell|R*I\<otimes\>R*I>|<cell|R*R*I>|<cell|R*I>>|<row|<cell|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>|<cell|>|<cell|<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|<rule|3*m*m|0*m*m>s<rsup|R>><ncline|1,2|1,3><rsup|\<mu\><rsub|I>><ncline|1,3|2,3>\<gtr\>h<ncline|1,1|2,1>\<less\>h\<otimes\>h<ncline|2,1|2,3><rsub|<wide|m|\<bar\>>>>>>>>|0pt|-10mm>
    </equation>

    <vspace|3mm>

    (2) Recall <math|R*I=<colim><math-ss|Eq><rsub|I>> from
    Remark<nbsp><reference|nnct>. We can substitute<nbsp><math|<math-ss|EQ><rsub|I>>
    by the category of all <math|e:W\<to\>H*W+I> with <math|W><nbsp>pointed.
    The argument is as in<nbsp>(a2) of Theorem<nbsp><reference|nncs>. We
    indicate pointing by writing<nbsp><math|W<rsub|\<bullet\>>> instead
    of<nbsp><math|W> (this stands for the
    notation<nbsp><math|<around|(|W,i<rsup|W>|)>>). We know that
    <math|\<otimes\>><nbsp>is finitary, thus

    <\equation*>
      R*I\<otimes\>R*I=<colim><math-ss|Eq><rsub|I>\<otimes\><math-ss|Eq><rsub|I>
    </equation*>

    with the colimit cocone

    <\equation*>
      e<rsup|#>\<otimes\>e<rsup|#>:W<rsub|\<bullet\>>\<otimes\>W<rsub|\<bullet\>>\<to\>R*I\<otimes\>R*I.
    </equation*>

    It is thus sufficient to prove that for every<nbsp><math|e> the square
    <vspace|3mm>

    <\equation>
      <label|nnrcjd><move|<psmatrix|c*o*l*s*e*p=20*m*m|<tformat|<table|<row|<cell|W<rsub|\<bullet\>>\<otimes\>W<rsub|\<bullet\>>>|<cell|R*I\<otimes\>R*I>|<cell|R*R*I>|<cell|R*I>>|<row|<cell|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>|<cell|>|<cell|>|<cell|<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|<rule|3*m*m|0*m*m>e<rsup|#>\<otimes\>e<rsup|#>><ncline|1,2|1,3><rsup|s<rsup|R>><ncline|1,3|1,4><rsup|\<mu\><rsub|I>><ncline|1,4|2,4>\<gtr\>h<ncline|1,1|2,1>\<less\><around|(|h*e<rsup|#>|)>\<otimes\><around|(|h*e<rsup|#>|)><ncline|2,1|2,4><rsub|<wide|m|\<bar\>>>>>>>>|0pt|-10mm>
    </equation>

    <vspace|2mm>

    <no-indent>commutes.

    For every flat equation morphism <math|e:W\<to\>H*W+I> recall
    <math|<around|\<langle\>|e|\<rangle\>>> from
    Notation<nbsp><reference|nnco>(iii) and put

    <\equation>
      <label|nnrcjdjp><wide|e|\<bar\>>\<equiv\>W<nsi|e>H*W+I<nsi|H*W+<wide|i|\<bar\>>>H*W+<wide|A|\<bar\>>.
    </equation>

    We prove that<nbsp><eqref|nnrcjd> commutes by verifying that the two
    sides of the square are both the left-hand part of the solution
    <math|<wide|f|\<bar\>><rsup|\<dag\>>:W\<otimes\>W+W\<to\><wide|A|\<bar\>>>
    of the equation morphism<nbsp><math|<wide|f|\<bar\>>> for

    <\equation*>
      f=<around|\<langle\>|e|\<rangle\>>:W\<otimes\>W+W\<to\>H*<around|(|W\<otimes\>W+W|)>+I.
    </equation*>

    (3) Proof of the upper passage of<nbsp><eqref|nnrcjd>:

    <\equation>
      <label|nnrcjt>h<tec>\<mu\><rsub|I><tec>s<rsup|R><tec><around|(|e<rsup|#>\<otimes\>e<rsup|#>|)>=<wide|f|\<bar\>><rsup|\<dag\>><tec><inl>:W\<otimes\>W\<to\><wide|A|\<bar\>>.
    </equation>

    Since <math|h:R*I\<to\><wide|A|\<bar\>>> preserves solutions by
    Remark<nbsp><reference|nnct>(vii), and since <math|f<rsup|#>><nbsp>is a
    solution of <math|\<eta\><rsub|I>\<bullet\>f> as mentioned in
    Remark<nbsp><reference|nnct>(iv), the
    composite<nbsp><math|h<tec>f<rsup|#>> is a solution of the equation
    morphism <math|<wide|f|\<bar\>>>: indeed, <math|h><nbsp>takes
    <math|\<eta\><rsub|I>\<bullet\>f> to<nbsp><math|<wide|f|\<bar\>>> due to
    the diagram <vspace|3mm>

    <\equation*>
      <psmatrix|<tformat|<table|<row|<cell|W\<otimes\>W+W>|<cell|>|<cell|H*<around|(|W\<otimes\>W+W|)>+R*I>>|<row|<cell|>|<cell|H*<around|(|W\<otimes\>W+W|)>+I>|<cell|>>|<row|<cell|>|<cell|>|<cell|H*<around|(|W\<otimes\>W+W|)>+<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,3><rsup|\<eta\><rsub|I>\<bullet\>f><ncline|1,1|2,2>\<gtr\>f<ncline|2,2|1,3>\<gtr\>+\<eta\><rsub|I><ncline|1,3|3,3>\<gtr\>+h<ncline|2,2|3,3>\<gtr\>+<wide|i|\<bar\>><ncarc*|a*r*c*a*n*g*l*e=-24|1,1|3,3>\<less\><wide|f|\<bar\>>>>>>>
    </equation*>

    Shortly, the triangle <vspace|5mm>

    <\equation>
      <label|nnrcjc><move|<psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|W\<otimes\>W+W>|<cell|R*I>>|<row|<cell|>|<cell|<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|f<rsup|#>><ncline|1,2|2,2>\<gtr\>h<ncline|1,1|2,2>\<less\><wide|f|\<bar\>><rsup|\<dag\>>>>>>>|0pt|-10mm>
    </equation>

    commutes.

    Observe that also the triangle <vspace|1mm>

    <\equation>
      <label|nnrcjp><move|<psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|R*W>|<cell|>>|<row|<cell|R*R*I>|<cell|R*I<psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|2,2>\<gtr\><wide|e<rsup|#>|^><ncline|1,1|2,1>\<less\>R*e<rsup|#><ncline|2,1|2,2><rsub|\<mu\>>>>>>>|0pt|-10mm>
    </equation>

    <vspace|2mm>

    <no-indent>commutes since <math|R*W><nbsp>is the free iterative algebra
    on <math|\<eta\><rsub|W>:W\<to\>R*W> and the three morphisms above are
    homomorphisms of <math|H>-algebras which are merged
    by<nbsp><math|\<eta\><rsub|W>>\Vindeed:

    <\equation*>
      <wide|e<rsup|#>|^><tec>\<eta\><rsub|W>=e<rsup|#>
    </equation*>

    as well as

    <\equation*>
      \<mu\><tec>R*e<rsup|#><tec>\<eta\><rsub|W>=\<mu\><tec>\<eta\><rsub|R*I><tec>e<rsup|#>=e<rsup|#>.
    </equation*>

    Let us verify that

    <\equation>
      <label|nnrcjs>s<rsub|I,W><tec><around|(|e<rsup|#>\<otimes\>W|)>=<around|(|e\<ast\>W|)><rsup|#>.
    </equation>

    Indeed, for <math|e:W\<to\>H*W+I> and <math|f=\<eta\><rsub|W>>
    form<nbsp><math|<wide|e|^>> as in<nbsp><eqref|rcxxx> and observe that
    <math|<wide|e|^>=\<eta\><rsub|W>\<bullet\><around|(|e\<ast\>W|)>> holds.
    Now recall from Equation<nbsp><eqref|nnrcojp> that
    <math|s<rsup|R><rsub|I,W>=\<eta\><rsup|\<flat\>><rsub|W>>. Thus, we have

    <align*|<tformat|<table|<row|<cell|s<rsup|R><rsub|I,W><tec><around|(|e<rsup|#>\<otimes\>W|)>>|<cell|=\<eta\><rsup|\<flat\>><rsub|W><tec><around|(|e<rsup|#>\<otimes\>W|)>>|<cell|>|<cell|>>|<row|<cell|>|<cell|=<wide|e|^><rsup|\<dag\>>>|<cell|>|<cell|<text|by
    <eqref|nnrco>>>>|<row|<cell|>|<cell|=<around*|(|\<eta\><rsub|W>\<bullet\><around|(|e\<ast\>W|)>|)><rsup|\<dag\>>>|<cell|>|<cell|>>|<row|<cell|>|<cell|=<around|(|e\<ast\>W|)><rsup|#>>|<cell|>|<cell|<text|by
    Remark <reference|nnct>(iv)>.>>>>>

    We are now in the position to demonstrate<nbsp><eqref|nnrcjt>:
    <vspace|3mm>

    <\equation*>
      <psmatrix|<tformat|<table|<row|<cell|W<rsub|\<bullet\>>\<otimes\>W<rsub|\<bullet\>>>|<cell|>|<cell|<around|(|W<rsub|\<bullet\>>\<otimes\>W<rsub|\<bullet\>>|)>+W<rsub|\<bullet\>>>|<cell|>>|<row|<cell|R*I\<otimes\>W<rsub|\<bullet\>>>|<cell|R*W>|<cell|>|<cell|>>|<row|<cell|R*I\<otimes\>R*I>|<cell|R*R*I>|<cell|R*I>|<cell|<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,3><rsup|<inl>><ncline|1,1|2,2>\<gtr\><around|(|e\<ast\>W<rsub|\<bullet\>>|)><rsup|#><ncline|1,1|2,1>\<less\>e<rsup|#>\<otimes\>W<ncline|1,1|2,1>\<gtr\><rule|1*m*m|0*m*m><eqref|n*n*r*c*j*s><ncline|2,1|2,2><rsub|s<rsup|R>><ncline|1,3|3,3>\<gtr\>f<rsup|#><ncline|1,3|3,3>\<less\><move|<math|<with|math-level|1|<eqref|n*n*r*c*j*n>>><rule|10*mm|0*mm>|0pt|5mm><ncline|2,1|3,1>\<less\>R*I\<otimes\>e<rsup|#><ncline|2,2|3,2>\<less\>R*e<rsup|#><ncline|2,2|3,3>\<gtr\><wide|e<rsup|#>|^><ncline|1,3|3,4>\<gtr\><wide|f|\<bar\>><rsup|\<dag\>><ncline|3,1|3,2><rsub|s<rsup|R>><ncline|3,2|3,3><rsub|\<mu\><rsup|I>><ncline|3,3|3,4><rsub|h><ncline|2,2|3,3>\<less\><eqref|n*n*r*c*j*p><rule|2*m*m|0*m*m><ncline|3,3|3,4><rsup|<move|<math|<with|math-level|1|<eqref|n*n*r*c*j*c>>><rule|10*mm|0*mm>|0pt|9mm>>>>>>>
    </equation*>

    <vspace|3mm>

    <\comment>
      (4) Before continuing with our proof we observe two commutative
      squares. <vspace|3mm>

      <\equation>
        <label|nnnrcjs><move|<psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|H*W\<otimes\>W>|<cell|H*<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>|<cell|H*<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>>>|<row|<cell|H*<around|(|W\<otimes\>W|)>>|<cell|H*<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>>|<cell|H*<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|H*<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>><ncline|1,2|1,3><rsup|s<rsup|H>><ncline|1,1|2,1>\<less\>s<rsup|H><ncline|1,3|2,3>\<gtr\>H*<wide|m|\<bar\>><ncline|2,1|2,2><rsub|H*<around|(|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>|)>><ncline|2,2|2,3><rsub|H*<wide|m|\<bar\>>>>>>>>|0pt|-10mm>
      </equation>

      <vspace|2mm>

      <no-indent>which is just the naturality square
      for<nbsp><math|s<rsup|H>> followed by<nbsp><math|H*<wide|m|\<bar\>>>,
      and the other one is <vspace|3mm>

      <\equation>
        <label|nnrcjss><move|<psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|W=I\<otimes\>W>|<cell|<wide|A|\<bar\>>\<otimes\>W>|<cell|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>>|<row|<cell|>|<cell|I\<otimes\><wide|A|\<bar\>>>|<cell|>>|<row|<cell|W>|<cell|>|<cell|<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|<wide|i|\<bar\>>\<otimes\>W><ncline|1,2|1,3><rsup|<wide|A|\<bar\>>\<otimes\><wide|e|\<bar\>>><ncline|1,1|2,2>\<less\>I\<otimes\><wide|e|\<bar\>><ncline|1,1|3,1>\<less\>W<ncline|2,2|1,3>\<less\><wide|i|\<bar\>>\<otimes\><wide|A|\<bar\>><ncline*|a*r*r*o*w*s=-,d*o*u*b*l*e*l*i*n*e=t*r*u*e|2,2|3,3><ncline|1,3|3,3>\<gtr\><wide|m|\<bar\>><ncline|3,1|3,3><rsub|e<rsup|\<dag\>>>>>>>>|0pt|-20mm>
      </equation>

      <vspace|3mm>

      (5) We now prove the lower passage of<nbsp><eqref|nnrcjd>:

      <\equation*>
        <wide|m|\<bar\>>*<around*|(|<around|(|h<tec><wide|e|\<bar\>><rsup|#>|)>\<otimes\><around|(|h<tec><wide|e|\<bar\>><rsup|#>|)>|)>=<wide|f|\<bar\>><rsup|\<dag\>><tec><inl>.
      </equation*>

      Since the homomorphism <math|h:R*I\<to\>A> preserves solutions and,
      by<nbsp><reference|nnct>(iv), <math|e<rsup|#>><nbsp>is the solution of
      <math|\<eta\><rsub|I>\<bullet\>e> in<nbsp><math|R*I>, it follows that
      <math|<wide|e|\<bar\>><rsup|\<dag\>>=h<tec>e<rsup|#>>. Thus. our task
      is to prove

      <\equation>
        <label|nnrcjo><wide|m|\<bar\>><tec><around|(|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>|)>=<wide|f|\<bar\>><rsup|\<dag\>><tec><inl>.
      </equation>

      We first observe that we have a commutative diagram <vspace|3mm>

      <\equation>
        <label|nnnrcjo><move|<psmatrix|c*o*l*s*e*p=22*m*m|<tformat|<table|<row|<cell|>|<cell|<wide|A|\<bar\>>\<otimes\>A>|<cell|>>|<row|<cell|W\<otimes\>W>|<cell|<wide|A|\<bar\>>\<otimes\>W>|<cell|<wide|A|\<bar\>>>>|<row|<cell|>|<cell|<around|(|H*<wide|A|\<bar\>>+<wide|A|\<bar\>>|)>\<otimes\>W>|<cell|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>+<wide|A|\<bar\>>>>|<row|<cell|<around|(|H*W\<otimes\>W|)>+W>|<cell|<around|(|H*W+<wide|A|\<bar\>>|)>\<otimes\>W>|<cell|<around|(|H*<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>+<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>>>|<row|<cell|H*<around|(|W\<otimes\>W|)>+W>|<cell|H*<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>+<wide|A|\<bar\>>>|<cell|H*<wide|A|\<bar\>>+<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|2,2|1,2>\<less\><wide|A|\<bar\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>><ncline|1,2|2,3>\<gtr\><wide|m|\<bar\>><ncline|2,1|2,2><rsup|<wide|e|\<bar\>><rsup|\<dag\>>*W><ncline|2,1|4,1>\<less\>e\<otimes\>W<ncline|2,1|4,2>\<less\><wide|e|\<bar\>>\<otimes\>W<ncline|3,2|2,2>\<gtr\><around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]>\<otimes\>W<ncline|5,1|5,2><rsub|H*<around|(|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>|)>+<wide|e|\<bar\>><rsup|\<dag\>>><ncline|3,3|2,3>\<gtr\><around|[|<wide|m|\<bar\>>,<wide|A|\<bar\>>|]><ncline|4,2|3,2>\<gtr\>(H*<wide|e|\<bar\>><rsup|\<dag\>>+<wide|A|\<bar\>>\<otimes\>W<ncline|3,2|4,3>\<gtr\>\<otimes\><wide|e|\<bar\>><ncline|4,3|3,3>\<gtr\><around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]>\<otimes\><wide|A|\<bar\>><ncline|4,1|5,1>\<less\>s<rsup|H+W><ncline|4,3|5,3>\<gtr\>H*<wide|m|\<bar\>><tec>s<rsup|H>+<wide|m|\<bar\>><ncline|5,2|5,3><rsub|H*<wide|m|\<bar\>>+<wide|A|\<bar\>>><ncline|4,1|4,2><rsub|<around|(|H*W+<wide|i|\<bar\>>|)>\<otimes\>W><ncline|4,1|5,1>\<gtr\><rule|35*m*m|0*m*m><text|<with|font-size|0.84|<eqref|nnnrcjs>
        & <eqref|nnrcjss>>>>>>>>|0pt|-30mm>
      </equation>

      <vspace|2mm>

      <no-indent>We now conclude<nbsp><eqref|nnrcjss> by
      using<nbsp><reference|nnco>(iii) (recall
      <math|f=<around|\<langle\>|e|\<rangle\>>>):
    </comment>

    (4) We shall prove for the lower passage of<nbsp><eqref|nnrcjd> that

    <\equation*>
      <wide|m|\<bar\>><tec><around*|(|<around|(|h<tec><wide|e|\<bar\>><rsup|#>|)>\<otimes\><around|(|h<tec><wide|e|\<bar\>><rsup|#>|)>|)>=<wide|f|\<bar\>><rsup|\<dag\>><tec><inl>:W\<otimes\>W\<to\><wide|A|\<bar\>>.
    </equation*>

    Since the homomorphism <math|h:R*I\<to\>A> preserves solutions and, by
    Remark<nbsp><reference|nnct>(iv), <math|e<rsup|#>><nbsp>is the solution
    of <math|\<eta\><rsub|I>\<bullet\>e> in<nbsp><math|R*I>, it follows that
    <math|<wide|e|\<bar\>><rsup|\<dag\>>=h<tec>e<rsup|#>>
    (cf.<nbsp><eqref|nnrcjc>). So we will prove that

    <\equation*>
      <wide|f|\<bar\>><rsup|\<dag\>>=<around*|[|<wide|m|\<bar\>><tec><around|(|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>|)>,<wide|e|\<bar\>><rsup|\<dag\>>|]>:W\<otimes\>W+W\<to\><wide|A|\<bar\>>.
    </equation*>

    To see this it suffices to verify that the following diagram <vspace|3mm>

    <\equation>
      <label|rcsss><move|<psmatrix|c*o*l*s*e*p=35*m*m|<tformat|<table|<row|<cell|W\<otimes\>W+W>|<cell|<wide|A|\<bar\>>>>|<row|<cell|H*<around|(|W\<otimes\>W+W|)>+<wide|A|\<bar\>>>|<cell|H*<wide|A|\<bar\>>+<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|<around|[|<wide|m|\<bar\>><tec><around|(|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>|)>,<wide|e|\<bar\>><rsup|\<dag\>>|]>><ncline|1,1|2,1>\<less\><wide|f|\<bar\>><ncline|2,2|1,2>\<gtr\><around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]><ncline|2,1|2,2><rsub|<rule|8*m*m|0*m*m>H<around|[|<wide|m|\<bar\>><tec><around|(|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>|)>,<wide|e|\<bar\>><rsup|\<dag\>>|]>+<wide|A|\<bar\>>>>>>>>|0pt|-10mm>
    </equation>

    <vspace|2mm>

    <no-indent>commutes. In order to do so we consider the components of the
    upper left-hand coproduct separately. For the right-hand component with
    domain<nbsp><math|W> we obtain <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|W>|<cell|>|<cell|<wide|A|\<bar\>>>>|<row|<cell|H*W+I>|<cell|H*W+<wide|A|\<bar\>>>|<cell|>>|<row|<cell|H*<around|(|W\<otimes\>W+W|)>+<wide|A|\<bar\>>>|<cell|>|<cell|H*<wide|A|\<bar\>>+<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,3><rsup|<wide|e|\<bar\>><rsup|\<dag\>>><ncline|1,1|2,1>\<less\>e<ncline|1,1|2,2>\<gtr\><wide|e|\<bar\>><ncline|2,1|2,2><rsup|H*W+<wide|i|\<bar\>>><ncline|2,1|3,1>\<less\>H<inr>+<wide|i|\<bar\>><ncline|2,2|3,1>\<gtr\>H<inr>+<wide|A|\<bar\>><ncline|2,2|3,3>\<gtr\>H*<wide|e|\<bar\>><rsup|\<dag\>>+<wide|A|\<bar\>><ncline|3,3|1,3>\<gtr\><around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]><ncline|3,1|3,3><rsub|<rule|8*m*m|0*m*m>H<around|[|<wide|m|\<bar\>><tec><around|(|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>|)>,<wide|e|\<bar\>><rsup|\<dag\>>|]>+<wide|A|\<bar\>>>>>>>>
    </equation*>

    <vspace|2mm>

    <no-indent>This diagram commutes: the upper right-hand part commutes
    since <math|<wide|e|\<bar\>><rsup|\<dag\>>><nbsp>is a solution
    of<nbsp><math|<wide|e|\<bar\>>>, and all other inner parts are obvious.

    For the left-hand component of<nbsp><eqref|rcsss> we prove that the
    following diagram <vspace|1mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=21*m*m|<tformat|<table|<row|<cell|W\<otimes\>W>|<cell|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>|<cell|<wide|A|\<bar\>>>>|<row|<cell|<around|(|H*W\<otimes\>W|)>+W>|<cell|<around|(|H*<wide|A|\<bar\>>+<wide|A|\<bar\>>|)>\<otimes\>W>|<cell|<around|(|H*<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>+<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>>>|<row|<cell|H*<around|(|W\<otimes\>W|)>+W>|<cell|H*<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>+<wide|A|\<bar\>>>|<cell|H*<wide|A|\<bar\>>+<wide|A|\<bar\>>>>|<row|<cell|H*<around|(|W\<otimes\>W|)>+H*W+<wide|A|\<bar\>>>|<cell|H*<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>+H*<wide|A|\<bar\>>+<wide|A|\<bar\>>>|<cell|>>|<row|<cell|H*<around|(|W\<otimes\>W+W|)>+<wide|A|\<bar\>>>|<cell|H*<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>+<wide|A|\<bar\>>|)>+<wide|A|\<bar\>>>|<cell|H*<wide|A|\<bar\>>+<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>><ncline|1,2|1,3><rsup|<wide|m|\<bar\>>><ncline*|a*r*r*o*w*s=-,d*o*u*b*l*e*l*i*n*e=t*r*u*e|3,3|5,3>\<less\><text|(vii)><rule|17*m*m|0*m*m><ncline*|a*r*r*o*w*s=-,d*o*u*b*l*e*l*i*n*e=t*r*u*e|3,3|5,3>\<gtr\><rule|7*m*m|0*m*m><text|(ii)><ncline|1,1|2,1>\<gtr\>e\<otimes\>W<ncline|2,3|1,3>\<less\><text|(iv)><rule|10*m*m|0*m*m><wide|m|\<bar\>><tec><around|(|<around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]>\<otimes\><wide|A|\<bar\>>|)><ncline|2,1|2,2><rsub|<around|(|H*<wide|e|\<bar\>><rsup|\<dag\>>+<wide|i|\<bar\>>|)>\<otimes\>W><ncline|2,2|2,3><rsub|\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>><ncline|2,1|3,1>\<gtr\><around|(|s<rsup|H>+W|)><rule|43*m*m|0*m*m><text|(v)><ncline|3,1|4,1>\<gtr\>+<wide|e|\<bar\>><rule|17*m*m|0*m*m><text|(vi)><ncline|2,3|3,3>\<less\>H*<wide|m|\<bar\>><tec>s<rsup|H>+<wide|m|\<bar\>><ncline|3,1|3,2><rsub|H*<around|(|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>|)>+<wide|e|\<bar\>><rsup|\<dag\>>><ncline|3,2|3,3><rsub|H*<wide|m|\<bar\>>+<wide|A|\<bar\>>><ncline|4,2|3,2>\<gtr\>+<around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]><ncline|4,1|5,1>\<gtr\><can>+<wide|A|\<bar\>><rule|13*m*m|0*m*m><text|(viii)><ncline|4,2|5,3>\<less\><text|(ix)><rule|2*m*m|0*m*m><ncline|4,2|5,2>\<gtr\><can>+<wide|A|\<bar\>><ncline|4,1|4,2><rsub|H*<around|(|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>|)>+H*<wide|e|\<bar\>><rsup|\<dag\>>+<wide|A|\<bar\>>><ncline|4,2|5,3>\<gtr\>H*<wide|m|\<bar\>>+<around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]><ncline|5,1|5,2><rsup|H*<around|(|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>+<wide|e|\<bar\>><rsup|\<dag\>>|)>+<wide|A|\<bar\>>><ncline|5,2|5,3><rsup|H<around|[|<wide|m|\<bar\>>,<wide|A|\<bar\>>|]>+<wide|A|\<bar\>>><ncarc*|a*r*c*a*n*g*l*e=-10|5,1|5,3><rsub|H<around|[|<wide|m|\<bar\>><tec><around|(|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>|)>,<wide|e|\<bar\>><rsup|\<dag\>>|]>+<wide|A|\<bar\>>><ncarc*|a*r*c*a*n*g*l*e=-70|5,3|1,3>\<less\><around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]><ncarc*|a*r*c*a*n*g*l*e=-70|1,1|5,1>\<gtr\><wide|f|\<bar\>><tec><inl><ncline|2,1|3,1>\<less\><text|(i)><rule|10*m*m|0*m*m><ncline|2,2|1,2>\<less\><text|(iii)><rule*|12*m*m|0*m*m|<wide|a|\<bar\>>,A>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>>>>>>
    </equation*>

    <vspace|6mm>

    <no-indent>commutes: the left-hand part<nbsp>(i) commutes by the
    definition of <math|<wide|f|\<bar\>>=<wide|<around|\<langle\>|e|\<rangle\>>|\<bar\>>>
    and right-hand part<nbsp>(ii) is obvious since
    <math|<wide|A|\<bar\>>><nbsp>is an <math|H>-monoid, i.e.,
    <math|<wide|a|\<bar\>><tec>H*<wide|m|\<bar\>><tec>s<rsup|H>=<wide|m|\<bar\>><tec><around|(|<wide|a|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>>.
    For part<nbsp>(iii) observe that <math|<around|(|H*W\<otimes\>W|)>+W=<around|(|H*W+I|)>\<otimes\>W>
    and use Diagram<nbsp><eqref|rdd> and Equation<nbsp><eqref|nnrcjdjp>. In
    part<nbsp>(iv) we use the distributivity for the object in the lower
    right-hand corner: <math|<around|(|H*<wide|A|\<bar\>>+<wide|A|\<bar\>>|)>\<otimes\><wide|A|\<bar\>>=H*<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>+<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>\Vthe
    commutativity is then obvious. We postpone part<nbsp>(v) to the end.
    Part<nbsp>(vi) commutes by using<nbsp><eqref|rdd>. Parts (vii)
    and<nbsp>(viii) are trivial. We do not claim that part<nbsp>(ix)
    commutes, but it clearly does when post-composed
    with<nbsp><math|<around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]>>, which
    suffices for the commutativity of the outside of the diagram. Finally, it
    remains to prove that part<nbsp>(v) commutes: we consider the components
    of the coproduct <math|<around|(|H*W\<otimes\>W|)>+W> separately. For the
    right-hand component we obtain the commutative diagram <vspace|3mm>

    <\equation>
      <label|nnrcjss><move|<psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|W=I\<otimes\>W>|<cell|<wide|A|\<bar\>>\<otimes\>W>|<cell|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>>|<row|<cell|>|<cell|I\<otimes\><wide|A|\<bar\>>>|<cell|>>|<row|<cell|W>|<cell|>|<cell|<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|<wide|i|\<bar\>>\<otimes\>W><ncline|1,2|1,3><rsup|<wide|A|\<bar\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>><ncline|1,1|2,2>\<less\>I\<otimes\><wide|e|\<bar\>><rsup|\<dag\>><ncline*|a*r*r*o*w*s=-,d*o*u*b*l*e*l*i*n*e=t*r*u*e|1,1|3,1><ncline|2,2|1,3>\<less\><wide|i|\<bar\>>\<otimes\><wide|A|\<bar\>><ncline*|a*r*r*o*w*s=-,d*o*u*b*l*e*l*i*n*e=t*r*u*e|2,2|3,3><ncline|1,3|3,3>\<gtr\><wide|m|\<bar\>><ncline|3,1|3,3><rsub|<wide|e|\<bar\>><rsup|\<dag\>>>>>>>>|0pt|-20mm>
    </equation>

    <vspace|2mm>

    <no-indent>and for the left-hand one consider the diagram below
    <vspace|3mm>

    <\equation>
      <label|nnnrcjs><move|<psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|H*W\<otimes\>W>|<cell|H*<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>|<cell|H*<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>>>|<row|<cell|H*<around|(|W\<otimes\>W|)>>|<cell|H*<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>>|<cell|H*<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|H*<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>><ncline|1,2|1,3><rsup|s<rsup|H>><ncline|1,1|2,1>\<less\>s<rsup|H><ncline|1,3|2,3>\<gtr\>H*<wide|m|\<bar\>><ncline|2,1|2,2><rsub|H*<around|(|<wide|e|\<bar\>><rsup|\<dag\>>\<otimes\><wide|e|\<bar\>><rsup|\<dag\>>|)>><ncline|2,2|2,3><rsub|H*<wide|m|\<bar\>>><ncline*|a*r*r*o*w*s=-,d*o*u*b*l*e*l*i*n*e=t*r*u*e|2,2|1,3>>>>>>|0pt|-10mm>
    </equation>

    <vspace|2mm>

    <no-indent>This completes the proof.
  </proof>

  <\thm>
    <label|nncjjjp>Let <math|H><nbsp>be a finitary, point-strong endofunctor.
    Then the monoid<nbsp><math|T*I> from Corollary<nbsp><text|<reference|cojp>>
    is the initial completely iterative <math|H>-monoid.
  </thm>

  Notice that our proof below uses just the existence of the completely
  iterative algebras for<nbsp><math|H> (cf.
  Example<nbsp><reference|E:monad-T>) and not finitariness of<nbsp><math|H>
  directly.

  <\proof>
    Analogously to the preceding proof, given a completely iterative
    <math|H>-monoid <math|<around|(|<wide|A|\<bar\>>,<wide|i|\<bar\>>,<wide|m|\<bar\>>,<wide|a|\<bar\>>|)>>
    we know that there exists a unique <math|H>-algebra homomorphism

    <\equation*>
      h:T*I\<to\><wide|A|\<bar\>>*<space|2em><text|with><space|2em>h<tec>\<eta\><rsup|T><rsub|I>=<wide|i|\<bar\>>
    </equation*>

    and it is our task to prove that it preserves multiplication:
    <vspace|3mm>

    <\equation>
      <label|mon><move|<psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|T*I\<otimes\>T*I>|<cell|T*T*I>|<cell|T*I>>|<row|<cell|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>|<cell|>|<cell|<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s<rsup|T>><ncline|1,2|1,3><rsup|\<mu\><rsup|T>><ncline|1,1|2,1>\<less\>h\<otimes\>h<ncline|1,3|2,3>\<gtr\>h<ncline|2,1|2,3><rsub|<wide|m|\<bar\>>>>>>>>|0pt|-10mm>
    </equation>

    <vspace|2mm>

    <no-indent>To prove this, we define an equation morphism
    in<nbsp><math|<wide|A|\<bar\>>>:

    <\equation*>
      e:T*I\<otimes\>T*I=H*T*I\<otimes\>T*I+T*I\<to\>H*<around|(|T*I\<otimes\>T*I|)>+<wide|A|\<bar\>>
    </equation*>

    such that both passages of<nbsp><eqref|mon> are solutions
    of<nbsp><math|e> in<nbsp><math|<wide|A|\<bar\>>>: put

    <\equation*>
      e=s<rsup|H><rsub|T*I,T*I>+h.
    </equation*>

    For the upper passage of<nbsp><eqref|mon> we need to verify that the
    square <vspace|3mm>

    <\equation>
      <label|mul><move|<psmatrix|c*o*l*s*e*p=35*m*m|<tformat|<table|<row|<cell|T*I\<otimes\>T*I>|<cell|<wide|A|\<bar\>>>>|<row|<cell|H*<around|(|T*I\<otimes\>T*I|)>+<wide|A|\<bar\>>>|<cell|H*<wide|A|\<bar\>>+<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|h<tec>\<mu\><rsup|T><tec>s<rsup|T>><ncline|1,1|2,1>\<less\>e<ncline|1,2|2,2>\<gtr\><around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]><ncline|2,1|2,2><rsub|<rule|5*m*m|0*m*m>H<around|(|h<tec>\<mu\><rsup|T><tec>s<rsup|T>|)>+<wide|A|\<bar\>>>>>>>>|0pt|-10mm>
    </equation>

    <vspace|2mm>

    <no-indent>commutes. Consider the components of
    <math|H*T*I\<otimes\>T*I+I\<otimes\>T*I> separately. The left-hand
    component yields <vspace|2mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=23*m*m,r*o*w*s*e*p=12*m*m|<tformat|<table|<row|<cell|H*<around|(|T*I\<otimes\>T*I|)>>|<cell|H*T*T*I>|<cell|H*T*I>|<cell|H*<wide|A|\<bar\>>>>|<row|<cell|H*T*I\<otimes\>T*I>|<cell|>|<cell|>|<cell|>>|<row|<cell|T*I\<otimes\>T*I>|<cell|T*T*I>|<cell|T*I>|<cell|<wide|A|\<bar\>>>>|<row|<cell|H*<around|(|T*I\<otimes\>T*I|)>>|<cell|>|<cell|>|<cell|>>|<row|<cell|H*<around|(|T*I\<otimes\>T*I|)>+<wide|A|\<bar\>>>|<cell|H*T*T*I+<wide|A|\<bar\>>>|<cell|H*T*I+<wide|A|\<bar\>>>|<cell|H*<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|2,1|1,1>\<less\>s<rsup|H><ncline|1,1|1,2><rsup|H*s<rsup|T>><ncline|1,2|1,3><rsup|H*\<mu\><rsup|T>><ncline|1,3|1,4><rsup|H*h><ncarc*|a*r*c*a*n*g*l*e=-55|2,1|4,1>\<less\>s<rsup|H><ncline|2,1|3,1>\<gtr\>\<tau\>\<otimes\>T*I<ncarc*|a*r*c*a*n*g*l*e=70|3,1|5,1>\<gtr\>e<ncline|3,1|3,2><rsup|s<rsup|T>><ncline|3,2|3,3><rsup|\<mu\><rsup|T>><ncline|3,3|3,4><rsup|h><ncline|1,2|3,2>\<gtr\>\<tau\><ncline|1,3|3,3>\<gtr\>\<tau\><ncline|1,4|3,4>\<gtr\><wide|a|\<bar\>><ncline|4,1|5,1>\<less\><inl><ncline|5,1|5,2><rsub|H*s<rsup|T>+<wide|A|\<bar\>>><ncline|5,2|5,3><rsub|H*\<mu\><rsup|T>+<wide|A|\<bar\>>><ncline|5,3|5,4><rsub|H*h+<wide|A|\<bar\>>><ncline|5,4|3,4>\<gtr\><around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]>>>>>>
    </equation*>

    <vspace|1mm>

    <no-indent>The two upper right-hand squares commute since
    <math|\<mu\><rsup|T>> and<nbsp><math|h> are homomorphisms of algebras,
    the upper left-hand square is Diagram<nbsp><eqref|ffflat> and the lower
    left-hand part is obvious. Thus, since the outside of the diagram clearly
    commutes we see that its lower part<nbsp><eqref|mul> commutes when
    extended by the left-hand injection <math|\<tau\><rsub|I>\<otimes\>T*I>,
    as desired.

    The right-hand component of<nbsp><eqref|mul> yields <vspace|.5mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=23*m*m,r*o*w*s*e*p=15*m*m|<tformat|<table|<row|<cell|I\<otimes\>T*I=T*I>|<cell|>|<cell|>|<cell|>>|<row|<cell|T*I\<otimes\>T*I>|<cell|T*T*I>|<cell|T*I>|<cell|<wide|A|\<bar\>>>>|<row|<cell|<wide|A|\<bar\>>>|<cell|H*<around|(|T*I\<otimes\>T*I|)>+<wide|A|\<bar\>>>|<cell|>|<cell|H*<wide|A|\<bar\>>+<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncarc*|a*r*c*a*n*g*l*e=-55|1,1|3,1>\<less\>h<ncline|1,1|2,1>\<gtr\>\<eta\><rsup|T>\<otimes\>T*I<ncarc*|a*r*c*a*n*g*l*e=-10|1,1|2,2>\<gtr\>\<eta\><rsup|T>*T<ncline*|d*o*u*b*l*e*l*i*n*e=t*r*u*e|-|1,1|2,3><ncline|2,1|2,2><rsub|s<rsup|T>><ncline|2,1|3,2>\<gtr\>e<ncline|2,2|2,3><rsub|\<mu\><rsup|T>><ncline|2,3|2,4><rsup|h><ncline|3,1|3,2><rsub|<inr><rule|8*m*m|0*m*m>><ncline|3,2|3,4><rsub|H<around|(|h<tec>\<mu\><rsup|T><tec>s<rsup|T>|)>+<wide|A|\<bar\>>><ncline|3,4|2,4>\<gtr\><around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]>>>>>>
    </equation*>

    <vspace|1mm>

    <no-indent>Since all other parts clearly commute we see that the
    right-hand lower part<nbsp><eqref|mul> commutes when extended by the
    coproduct injection <math|\<eta\><rsup|T><rsub|I>\<otimes\>T*I> as
    desired. For the lower passage of<nbsp><eqref|mon> we verify that the
    square <vspace|3mm>

    <\equation>
      <label|low><move|<psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|T*I\<otimes\>T*I>|<cell|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>|<cell|<wide|A|\<bar\>>>>|<row|<cell|H*<around|(|T*I\<otimes\>T*I|)>+<wide|A|\<bar\>>>|<cell|H*<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>+<wide|A|\<bar\>>>|<cell|H*<wide|A|\<bar\>>+<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|h\<otimes\>h><ncline|1,2|1,3><rsup|<wide|a|\<bar\>>><ncline|1,1|2,1>\<less\>e<ncline|2,3|1,3>\<gtr\><around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]><ncline|2,1|2,2><rsub|H*<around|(|h\<otimes\>h|)>+<wide|A|\<bar\>>><ncline|2,2|2,3><rsub|H*<wide|m|\<bar\>>+<wide|A|\<bar\>>>>>>>>|0pt|-10mm>
    </equation>

    <vspace|2mm>

    <no-indent>commutes. The left-hand component of
    <math|T*I\<otimes\>T*I=<around|(|H*T*I+I|)>\<otimes\>T*I=<around|(|H*T*I\<otimes\>T*I|)>+T*I>
    (with coproduct injections <math|\<tau\>\<otimes\>T*I> and
    <math|\<eta\><rsup|T>\<otimes\>T*I>) yields <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=21*m*m,r*o*w*s*e*p=15*m*m|<tformat|<table|<row|<cell|H*T*I\<otimes\>T*I>|<cell|H*<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>|<cell|H*<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>>|<cell|H*<wide|A|\<bar\>>>>|<row|<cell|H*<around|(|T*I\<otimes\>T*I|)>>|<cell|T*I\<times\>T*I>|<cell|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>|<cell|<wide|A|\<bar\>>>>|<row|<cell|>|<cell|H*<around|(|T*I\<otimes\>T*I|)>+<wide|A|\<bar\>>>|<cell|H*<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>+<wide|A|\<bar\>>>|<cell|H*<wide|A|\<bar\>>+<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|H*h\<otimes\>h><ncline|1,2|1,3><rsup|s<rsup|H>><ncline|1,3|1,4><rsup|H*<wide|m|\<bar\>>><ncline|1,1|2,1>\<less\>s<rsup|H><ncline|1,1|2,2>\<less\>\<tau\>\<otimes\>T*I<ncline|1,2|2,3>\<gtr\><wide|a|\<bar\>>\<otimes\><wide|A|\<bar\>><ncline|1,4|2,4>\<gtr\><wide|a|\<bar\>><ncline|2,1|3,2>\<less\><inl><ncline|2,2|3,2>\<gtr\>e<ncline|3,4|2,4>\<gtr\><around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]><ncline|3,2|3,3><rsub|H*<around|(|h\<otimes\>h|)>+<wide|A|\<bar\>>><ncline|3,3|3,4><rsub|H*<wide|m|\<bar\>>+<wide|A|\<bar\>>><ncline|2,2|2,3><rsup|h\<otimes\>h><ncline|2,3|2,4><rsup|<wide|m|\<bar\>>>>>>>>
    </equation*>

    <vspace|1mm>

    <no-indent>The upper right-hand square is Diagram<nbsp><eqref|abb> and
    the middle one commutes since <math|h><nbsp>is an <math|H>-algebra
    homomorphism. The left-hand part is clear since <math|e=s<rsup|H>+h>. The
    lowest passage in the last diagram is

    <\equation*>
      <wide|a|\<bar\>><tec>H*<wide|m|\<bar\>><tec>H*<around|(|h\<otimes\>h|)><tec>s<rsup|H>=<wide|a|\<bar\>><tec>H*<wide|m|\<bar\>><tec>s<rsup|H><tec><around|(|H*h\<otimes\>h|)>
    </equation*>

    due to the naturality of<nbsp><math|s<rsup|H>>. Thus, the outside of the
    diagram commutes, showing that <eqref|low><nbsp>commutes when extended by
    <math|\<tau\><rsub|I>\<otimes\>T*I>.

    Finally, the right-hand component of<nbsp><eqref|low> is obvious:
    <vspace|2mm><vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=21*m*m,r*o*w*s*e*p=15*m*m|<tformat|<table|<row|<cell|I\<otimes\>T*I=T*I>|<cell|>|<cell|>|<cell|>>|<row|<cell|<wide|A|\<bar\>>>|<cell|T*I\<otimes\>T*I>|<cell|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>>|<cell|<wide|A|\<bar\>>>>|<row|<cell|>|<cell|H*<around|(|T*I\<otimes\>T*I|)>+<wide|A|\<bar\>>>|<cell|H*<around|(|<wide|A|\<bar\>>\<otimes\><wide|A|\<bar\>>|)>+<wide|A|\<bar\>>>|<cell|H*<wide|A|\<bar\>>+<wide|A|\<bar\>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|2,1>\<less\>h<ncline|1,1|2,2>\<less\>\<eta\><rsup|T>\<otimes\>T*I<ncline|1,1|2,3>\<less\><wide|i|\<bar\>>\<otimes\>h<ncline|1,1|2,4><rsup|h><ncline|2,2|2,3><rsub|h\<otimes\>h><ncline|2,3|2,4><rsub|<wide|a|\<bar\>>><ncline|2,1|3,2>\<less\><inl><ncline|2,2|3,2>\<less\>e<ncline|3,2|3,3><rsub|H*<around|(|h\<otimes\>h|)>+<wide|A|\<bar\>>><ncline|3,3|3,4><rsub|H*<wide|m|\<bar\>>+<wide|A|\<bar\>>><ncline|3,4|2,4>\<gtr\><around|[|<wide|a|\<bar\>>,<wide|A|\<bar\>>|]>>>>>>
    </equation*>

    <vspace|1mm>

    <no-indent>The lower passage is<nbsp><math|h> and so is the upper one:

    <\equation*>
      <wide|a|\<bar\>><tec><around|(|<wide|i|\<bar\>>\<otimes\>h|)>=a<tec><around|(|i\<otimes\><wide|A|\<bar\>>|)><tec><around|(|I\<otimes\>h|)>=I\<otimes\>h.
    </equation*>

    This shows that <eqref|low> commutes when extended by
    <math|\<eta\><rsup|T><rsub|I>\<otimes\>T*I>, which completes the proof.
  </proof>

  <\cor>
    <label|nncjjtc>For every signature<nbsp><Sig> the
    presheaf<nbsp><math|T<rsub|\<lambda\>,<Sig>>> is the initial completely
    iterative <math|H<rsub|\<lambda\>,<Sig>>>-monoid, and the
    presheaf<nbsp><math|R<rsub|\<lambda\>,<Sig>>> is the initial iterative
    <math|H<rsub|\<lambda\>,<Sig>>>-monoid.
  </cor>

  <\comment>
    This follows from Theorem<nbsp><reference|nncjjjp> since
    <math|T<rsub|\<lambda\>,<Sig>>><nbsp>is the free completely iterative
    <math|H<rsub|\<lambda\>,<Sig>>>-algebra on<nbsp><math|V> (cf.
    Theorem<nbsp><reference|ddv>).

    <cor|<label|nncjj> <math|R<rsub|\<lambda\>,<Sig>>><nbsp>is the initial
    iterative <math|H<rsub|\<lambda\>,<Sig>>>-monoid.>
  </comment>

  Indeed, <SetF><nbsp>is monoidally locally finitely presentable category and
  <math|H<rsub|\<lambda\>,<Sig>>><nbsp>is finitary and point-strong by
  Corollary<nbsp><reference|hntt>. Moreover,
  <math|<rr><rsub|\<lambda\>,<Sig>><around|(|V|)>=R<rsub|\<lambda\>,<Sig>>>
  by Theorem<nbsp><reference|djp>, and <math|<TT><rsub|\<lambda\>,<Sig>><around|(|V|)>=T<rsub|\<lambda\>,<Sig>>>
  by Theorem<nbsp><reference|nncjjjp>.

  <section|Higher-Order Recursion Schemes>

  <reset-counter|equation><label|kt>

  We can reformulate (and slightly extend) higher-order recursion
  schemes<nbsp><eqref|hrjj> categorically. Throughout this section we put
  <math|<WW>=<SetF>>.

  <\defi>
    <label|tj>A <with|font-shape|italic|higher-order recursion scheme> on a
    signature<nbsp><Sig> (of ``terminals'') is a presheaf morphism

    <\equation>
      <label|nott>e:X\<to\>F<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>
    </equation>

    where <math|X><nbsp>is a finitely presentable presheaf.
  </defi>

  <\rem>
    <label|td>(i) The presheaf <math|F<rsub|\<lambda\>,\<Sigma\>>\<otimes\><around|(|X+V|)>>
    assigns to a context <math|\<Gamma\>> the set
    <math|F<rsub|\<lambda\>,\<Sigma\>>*<around|(|X<around|(|\<Gamma\>|)>+\<Gamma\>|)>>
    of finite <math|\<lambda\>>-terms in contexts
    <math|<wide|\<Gamma\>|\<bar\>>\<subseteq\>X<around|(|\<Gamma\>|)>+\<Gamma\>>.

    (ii) Although <math|F<rsub|\<lambda\>,<Sig>>> is the free
    <math|H<rsub|\<lambda\>,<Sig>>>-algebra on <math|V>, see
    Theorem<nbsp><reference|dss>, it is not in general true that
    <math|F<rsub|\<lambda\>,<Sig>>\<otimes\>Z> is the free
    <math|H<rsub|\<lambda\>,<Sig>>>-algebra on a presheaf <math|Z>. For
    example, if <math|Z=V\<times\>V>, then terms in
    <math|<around|(|F<rsub|\<lambda\>,<Sig>>\<otimes\>Z|)><around|(|\<Gamma\>|)>>
    are precisely the finite <math|\<lambda\>>-<Sig>-terms whose free
    variables are substituted by pairs in <math|\<Gamma\>\<times\>\<Gamma\>>.
    In contrast, the free <math|H<rsub|\<lambda\>,<Sig>>>-algebra on
    <math|V\<times\>V> contains in context <math|\<Gamma\>> also terms such
    as <math|\<lambda\>*x.<around|(|x,y|)>> for <math|y\<in\>\<Gamma\>>, that
    is, in variable pairs one member can be bound and one free.

    (iii) In the introduction we considered, for a given context

    <\equation*>
      \<Gamma\><rsub|n*t>=<around|{|p<rsub|1>,\<ldots\>,p<rsub|n>|}>
    </equation*>

    of ``nonterminals'', a system of equations <math|p<rsub|i>=f<rsub|i>>,
    where <math|f<rsub|i>><nbsp>is a <math|\<lambda\>>-<Sig>-term in some
    context <math|\<Gamma\><rsub|0>=<around|{|x<rsub|1>,\<ldots\>,x<rsub|k>|}>>.
    Let <math|X><nbsp>be the free presheaf in <math|n><nbsp>generators
    <math|p<rsub|1>,\<ldots\>,p<rsub|n>> of
    context<nbsp><math|\<Gamma\><rsub|0>> (a coproduct of
    <math|n><nbsp>copies of<nbsp><math|<FF><around|(|\<Gamma\><rsub|0>,-|)>>,
    see Example<nbsp><reference|dd>(ii)). Then the system of equations
    defines the unique morphism

    <\equation*>
      e:X\<to\>F<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>
    </equation*>

    assigning to every<nbsp><math|p<rsub|i>> the right-hand side
    <math|f<rsub|i>> lying in

    <\equation*>
      F<rsub|\<lambda\>,<Sig>>*<around|(|\<Gamma\><rsub|n*t>+\<Gamma\><rsub|0>|)>\<subseteq\>F<rsub|\<lambda\>,<Sig>>*<around|(|X<around|(|\<Gamma\><rsub|0>|)>+\<Gamma\><rsub|0>|)>.
    </equation*>

    Here we consider <math|F<rsub|\<lambda\>,<Sig>>> as an object
    of<nbsp><math|<Fin><around|(|<Set>,<Set>|)>>.

    (iv) Conversely, every morphism<nbsp><eqref|nott> yields a system of
    equations <math|p<rsub|i>=f<rsub|i>> as follows: let
    <math|\<Gamma\><rsub|0>><nbsp>fulfill<nbsp><eqref|rdt> in
    Definition<nbsp><reference|ndfdjj>, and define
    <math|\<Gamma\><rsub|n*t>=X<around|(|\<Gamma\><rsub|0>|)>>. The element
    <math|f<rsub|p>=e<rsub|\<Gamma\><rsub|0>><around|(|p|)>> lies, for every
    nonterminal <math|p\<in\>\<Gamma\><rsub|n*t>>, in
    <math|F<rsub|\<lambda\>,<Sig>>*<around|(|\<Gamma\><rsub|n*t>+\<Gamma\><rsub|0>|)>>.
    We obtain a system of equations <math|p=f<rsub|p>> describing the given
    morphism<nbsp><math|e>.

    (v) We will use the presheaf<nbsp><math|R<rsub|\<lambda\>,<Sig>>> for our
    uninterpreted solutions of recursion schemes:

    A solution of the system of (formal) equations <math|p<rsub|i>=f<rsub|i>>
    are rational <math|\<lambda\>>-<Sig>-terms
    <math|p<rsub|1><rsup|\<dag\>>,\<ldots\>,p<rsub|n><rsup|\<dag\>>> making
    those equations identities in<nbsp><math|R<rsub|\<lambda\>,<Sig>><around|(|\<Gamma\><rsub|0>|)>>
    when we substitute in<nbsp><math|f<rsub|i>> the
    <math|\<lambda\>>-<Sig>-terms<nbsp><math|p<rsup|\<dag\>><rsub|j>> for the
    nonterminals<nbsp><math|p<rsub|j>> (<math|j=1,\<ldots\>,n>). This is
    expressed by the Definition<nbsp><reference|ntd> below.

    (vi) The general case of ``equation morphisms'' as considered
    in<nbsp><cite|AMV1> is (for the endofunctor
    <math|H<rsub|\<lambda\>,\<Sigma\>>>) a morphism of type
    <math|e:X\<to\>\<bbb-R\><rsub|\<lambda\>,\<Sigma\>>*<around|(|X+V|)>>. We
    see that every higher-order recursion scheme gives an equation morphism
    via the inclusion <math|F<rsub|\<lambda\>,<Sig>><subto>R<rsub|\<lambda\>,<Sig>>>
    and the strength of the monad <math|\<bbb-R\><rsub|\<lambda\>,<Sig>>>
    (but not necessarily conversely). Our solution theorem below is an
    application of the general result of<nbsp><cite|AMV1>.
  </rem>

  <\defi>
    <label|ntd>A <with|font-shape|italic|solution> of a higher-order
    recursion scheme <math|e:X\<to\>F<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>>
    is a morphism <math|e<rsup|\<dag\>>:X\<to\>R<rsub|\<lambda\>,<Sig>>> such
    that the square below, where <math|j:F<rsub|\<lambda\>,<Sig>>\<to\>R<rsub|\<lambda\>,<Sig>>>
    denotes the embedding, commutes:

    <\equation*>
      <tformat|<table|<row|<cell|<xymatrix@C>+2*p*c*@*R-.*5*p*cX<ar*|r><rsup|e<rsup|\<dagger\>>><ar*|d><rsub|e>>|<cell|R<rsub|\<lambda\>,<Sig>>>>|<row|<cell|F<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)><ar*|d><rsub|j\<otimes\><around|(|X+V|)>>>|<cell|>>|<row|<cell|R<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)><ar*|r><rsub|<rule|2*m*m|0*m*m>R<rsub|\<lambda\>,<Sig>>\<otimes\><around|[|e<rsup|\<dagger\>>,i|]>>>|<cell|R<rsub|\<lambda\>,<Sig>>\<otimes\>R<rsub|\<lambda\>,<Sig>><ar*|u*u><rsub|m>>>>>
    </equation*>

    <\comment>
      <vspace|1pt>

      <\equation*>
        <psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|X>|<cell|R<rsub|\<lambda\>,<Sig>>>>|<row|<cell|F<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>>|<cell|>>|<row|<cell|R<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>>|<cell|R<rsub|\<lambda\>,<Sig>>\<otimes\>R<rsub|\<lambda\>,<Sig>><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|e<rsup|\<dag\>>><ncline|1,1|2,1>\<less\>e<ncline*|a*r*r*o*w*s=H-\<gtr\>,b*r*a*c*k*e*t*l*e*n*g*t*h=-.*6,t*b*a*r*s*i*z*e=-3*m*m|2,1|3,1>\<less\>j\<otimes\><around|(|X+V|)><ncline|3,2|1,2>\<gtr\>m<rsup|R><ncline|3,1|3,2><rsub|<rule|4*m*m|0*m*m>R<rsub|\<lambda\>,<Sig>>\<otimes\><around|[|e<rsup|\<dag\>>,i<rsup|R>|]><rule|3*m*m|0*m*m>>>>>>>
      </equation*>
    </comment>
  </defi>

  <vspace|0.5fn><exa|<label|tt>The equation for the fixed-point combinator
  (see Example<nbsp><reference|jj>) with <math|<Sig>=\<emptyset\>>
  defines<nbsp><math|e> whose domain is the terminal presheaf<nbsp>1, that
  is, <math|e:1\<to\>F<rsub|\<lambda\>>\<otimes\><around|(|1+V|)>>. The
  solution <math|e<rsup|\<dag\>>:1\<to\>R<rsub|\<lambda\>>> assigns to the
  unique element of<nbsp>1 the tree<nbsp><eqref|rnjj>.>

  <\rem>
    <label|tp>Recursion schemes such as <math|p<rsub|1>=p<rsub|1>> make no
    sense<emdash>and they certainly fail to have a unique solution. In
    general, we want to avoid right-hand sides of the
    form<nbsp><math|p<rsub|i>>. A recursion scheme is called
    <with|font-shape|italic|guarded> if no right-hand side lies
    in<nbsp><math|\<Gamma\><rsub|n*t>>. (Theorem<nbsp><reference|hncss> below
    shows that no other restrictions are needed.) Guardedness can be
    formalized as follows: since

    <\equation*>
      R<rsub|\<lambda\>,<Sig>>=H<rsub|\<lambda\>,<Sig>><around|(|R<rsub|\<lambda\>,<Sig>>|)>+V*<space|2em><text|with
      injections <math|\<varrho\><rsub|V>> and >i
    </equation*>

    by Remark<nbsp><reference|copr>, we have (see
    Remark<nbsp><reference|hndj>(i))

    <\equation*>
      R<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>\<cong\>H<rsub|\<lambda\>,<Sig>><around|(|R<rsub|\<lambda\>,<Sig>>|)>\<otimes\><around|(|X+V|)>+X+V
    </equation*>

    with coproduct injections <math|\<varrho\><rsub|V>\<otimes\><rsub|X+V>>
    and <math|i\<otimes\><rsub|X+V>>. Then <math|e><nbsp>is guarded if its
    extension <math|<around|(|j\<otimes\><around|(|X+V|)>|)><tec>e:X\<to\>R<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>>
    factorizes through the embedding of the first and third summand of this
    coproduct:
  </rem>

  <\defi>
    <label|hncs>A higher-order recursion scheme
    <math|e:X\<to\>F<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>> is
    called <with|font-shape|italic|guarded> if
    <math|<around|(|j\<otimes\><around|(|X+V|)>|)><tec>e><nbsp>factorizes
    through

    <\equation*>
      <around*|[|\<varrho\>\<otimes\>,<around|(|i\<otimes\>|)><tec><inr>|]>:H<rsub|\<lambda\>><around|(|R<rsub|\<lambda\>,<Sig>>|)>\<otimes\><around|(|X+V|)>+V\<to\>R<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>.
    </equation*>
  </defi>

  <\thm>
    <label|hncss>Every guarded higher-order recursion scheme has a unique
    solution.
  </thm>

  <\trivlist>
    <item*|<space|labelsep><with|font-series|bold|Remark.>>In
    Definition<nbsp><reference|tj> we restricted higher-order recursion
    schemes to have <math|F<rsub|\<lambda\>,<Sig>>> in their codomain. This
    corresponds well to the classical notion of recursion schemes as
    explained in Remark<nbsp><reference|td>. Moreover, this leads to a simple
    presentation of the interpreted semantics in Section<nbsp><reference|hp>
    below. However, Theorem<nbsp><reference|hncss> remains valid if we
    replace<nbsp><math|F<rsub|\<lambda\>,<Sig>>>
    by<nbsp><math|R<rsub|\<lambda\>,<Sig>>> in Definition<nbsp><reference|tj>
    and define solution by <math|e<rsup|\<dagger\>>=m\<cdot\>R<rsub|\<lambda\>,<Sig>>\<otimes\><around|[|e<rsup|\<dagger\>>,i|]>\<cdot\>e>.
    This extends the notion of a higher-order recursion
    scheme<nbsp><eqref|hrjj> to allow the right-hand
    sides<nbsp><math|f<rsub|i>> to be rational <math|\<lambda\>>-<Sig>-terms.
    We shall prove Theorem<nbsp><reference|hncss> working with higher-order
    schemes of the form <math|e:X\<to\>R<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>>,
    <math|X> finitely presentable. We call <math|e> guarded if it factorizes
    through <math|<around|[|\<varrho\>\<otimes\>,<around|(|i\<otimes\>|)><tec><inr>|]>>.
  </trivlist>

  <\proof>
    Let us apply the monad<nbsp><math|<rr><rsub|\<lambda\>,<Sig>>> and its
    point-strength<nbsp><math|s<rsup|R>> from Theorem<nbsp><reference|nncs>.
    We construct for every higher-order recursion scheme
    <math|e:X\<to\><rr><rsub|\<lambda\>,<Sig>><around|(|V|)>\<otimes\><around|(|X+V|)>>
    a rational equation morphism <math|<wide|e|\<bar\>>:X\<to\><rr><rsub|\<lambda\>,<Sig>><around|(|X+V|)>>
    in the sense of<nbsp><cite|AMV1> as follows:

    <\equation*>
      <wide|e|\<bar\>>\<equiv\>X<nsi|e><rr><rsub|\<lambda\>,<Sig>><around|(|V|)>\<otimes\><around|(|X+V|)><nsi|s<rsup|R><rsub|<around|(|V,|)>*<around|(|X+V,<inr>|)>>><rr><rsub|\<lambda\>,<Sig>><around|(|X+V|)>.
    </equation*>

    From the guardedness of<nbsp><math|e> we conclude that
    <math|<wide|e|\<bar\>>><nbsp>is guarded in the sense of<nbsp><cite|AMV1>,
    that is, <math|<wide|e|\<bar\>>><nbsp>factorizes through the summand
    <math|H<rsub|\<lambda\>,<Sig>><rr><rsub|\<lambda\>,<Sig>><around|(|X+V|)>+V>
    of <math|<rr><rsub|\<lambda\>,<Sig>><around|(|X+V|)>>, see
    Remark<nbsp><reference|copr>. Indeed, this follows from the following
    diagram <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=11*m*m|<tformat|<table|<row|<cell|>|<cell|H<rsub|\<lambda\>,<Sig>><around|(|R<rsub|\<lambda\>,<Sig>>|)>\<otimes\><around|(|X+V|)>+V>|<cell|>|<cell|H<rsub|\<lambda\>,<Sig>><around|(|<rr><rsub|\<lambda\>,<Sig>><around|(|X+V|)>|)>+V>>|<row|<cell|X>|<cell|R<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>>|<cell|>|<cell|<rr><rsub|\<lambda\>,<Sig>><around|(|X+V|)><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,2|1,4><rsup|H<rsub|\<lambda\>,<Sig>>*s<rsup|R>+><ncline*|l*i*n*e*s*t*y*l*e=d*a*s*h*e*d|2,1|1,2><ncline|2,1|2,2><rsub|e><ncline|2,2|2,4><rsub|s<rsup|R>><ncline*|a*r*r*o*w*s=H-\<gtr\>,b*r*a*c*k*e*t*l*e*n*g*t*h=-.*6,t*b*a*r*s*i*z*e=-3*m*m|1,2|2,2><ncline*|a*r*r*o*w*s=H-\<gtr\>,b*r*a*c*k*e*t*l*e*n*g*t*h=-.*6,t*b*a*r*s*i*z*e=-3*m*m|1,4|2,4>>>>>>
    </equation*>

    <vspace|1mm>

    <no-indent>Consequently, by Theorem<nbsp>4.5 in<nbsp><cite|AMV1> there
    exists a unique solution<nbsp><math|<wide|e|\<bar\>><rsup|\<dag\>>>
    of<nbsp><math|<wide|e|\<bar\>>> with respect to the
    monad<nbsp><math|<rr><rsub|\<lambda\>,<Sig>>>\Vthis means that there
    exists a unique morphism <math|<wide|e|\<bar\>><rsup|\<dag\>>:X\<to\><rr><rsub|\<lambda\>,<Sig>><around|(|V|)>>
    such that the outside of the diagram below commutes:

    <\equation*>
      <psmatrix|c*o*l*s*e*p=5*m*m|<tformat|<table|<row|<cell|X>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|<rr><rsub|\<lambda\>,<Sig>><around|(|V|)>>>|<row|<cell|<rr><rsub|\<lambda\>,<Sig>><around|(|V|)>\<otimes\><around|(|X+V|)>>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|<rr><rsub|\<lambda\>,<Sig>><around|(|V|)>\<otimes\><rr><rsub|\<lambda\>,<Sig>><around|(|V|)>>|<cell|>>|<row|<cell|<rr><rsub|\<lambda\>,<Sig>><around|(|X+V|)>>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|<rr><rsub|\<lambda\>,<Sig>><around|(|V|)><around|(|<rr><rsub|\<lambda\>,<Sig>><around|(|V|)>|)><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,7><rsup|<wide|e|\<bar\>><rsup|\<dag\>>><ncline|1,1|2,1>\<less\>e<ncline|2,1|2,6><rsub|<rr><rsub|\<lambda\>,<Sig>><around|(|<rsub|V>|)>\<otimes\><around|[|<wide|e|\<bar\>><rsup|\<dag\>>,i|]>><ncline|2,6|1,7>\<less\>m<ncline|2,1|3,1>\<gtr\>s<rsub|<around|(|V,|)>*<around|(|X+V,<inr>|)>><rsup|R><ncline|2,6|3,7>\<less\>s<rsub|<around|(|V,|)><around|(|R<rsub|\<lambda\>,<Sig>>,i|)>><rsup|R><ncline|3,1|3,7><rsub|<rr><rsub|\<lambda\>,<Sig>><around|[|<wide|e|\<bar\>><rsup|\<dag\>>,i|]>><ncline|3,7|1,7>\<gtr\>\<mu\><rsub|V>>>>>>
    </equation*>

    <vspace|1mm>

    <no-indent>Since the right-hand triangle is Equation<nbsp><eqref|multi>
    and the lower square commutes by the naturality of<nbsp><math|s<rsup|R>>,
    we see that <math|<wide|e|\<bar\>><rsup|\<dag\>>> is a solution
    of<nbsp><math|e> in the sense of Definition<nbsp><reference|ntd> iff
    <math|<wide|e|\<bar\>><rsup|\<dag\>>><nbsp>is a solution
    of<nbsp><math|<wide|e|\<bar\>>> in the sense of<nbsp><cite|AMV1>. This
    proves that <math|e><nbsp>has a unique solution.
  </proof>

  <\rem>
    <label|solution>Analogously we could define a solution of a higher-order
    recursion scheme of the form <math|e:X\<to\>T<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>>
    in the initial completely iterative monoid<nbsp><math|T<rsub|\<lambda\>,<Sig>>>,
    see Theorem<nbsp><reference|hntss>. (Here we, moreover, do not need to
    assume that <math|X><nbsp>is finitely presentable.) And guardedness means
    here that <math|e><nbsp>factorizes through the summand
    <math|H<rsub|\<lambda\>,<Sig>>*T<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>+V>
    of <math|T<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>> (cf. Remarks
    <reference|R:monad-T> and<nbsp><reference|hndj>(i)). Every such guarded
    scheme has a unique solution in<nbsp><math|T<rsub|\<lambda\>,<Sig>>>. The
    proof is completely analogous to the previous one
    for<nbsp><math|R<rsub|\<lambda\>,<Sig>>> but using Corollary<nbsp>3.8
    in<nbsp><cite|AAMV> in lieu of Theorem<nbsp>4.5 from<nbsp><cite|AMV1>.
  </rem>

  <\rem>
    <label|npdv>Notice that the definitions and results in this section
    generalize to the setting as considered in Section<nbsp><reference|snc>
    (see Assumption<nbsp><reference|nncj>). Simply
    replace<nbsp><math|H<rsub|\<lambda\>,<Sig>>> by the finitary
    functor<nbsp><math|H>, the monoid<nbsp><math|F<rsub|\<lambda\>,<Sig>>> by
    the initial <math|H>-monoid<nbsp><math|F>; this exists and is given by
    the free <math|H>-algebra on<nbsp><math|V>, see<nbsp><cite|FPT>. Further
    replace the monoid<nbsp><math|R<rsub|\<lambda\>,<Sig>>> by the initial
    iterative <math|H>-monoid<nbsp><math|R*I> (cf.
    Theorem<nbsp><reference|nncjn>), and <math|T<rsub|\<lambda\>,<Sig>>><nbsp>by
    the initial completely iterative <math|H>-monoid (cf.
    Theorem<nbsp><reference|nncjjjp>).
  </rem>

  <section|Interpreted Solutions>

  <reset-counter|equation><label|hp>

  In the present section we prove that every Scott model of
  <math|\<lambda\>>-calculus as a <CPO>, <math|D>, with fold and unfold
  operations can be used as a model of higher-order recursion. Following
  M.<nbsp>Fiore et al<nbsp><cite|FPT> we work with the
  presheaf<nbsp><math|<around|\<langle\>|D,D|\<rangle\>>> which to a
  context<nbsp><math|\<Gamma\>> assigns the set of all continuous functions
  from<nbsp><math|D<rsup|\<Gamma\>>> to<nbsp><math|D>. We prove that every
  higher-order recursion scheme has a least solution
  in<nbsp><math|<around|\<langle\>|D,D|\<rangle\>>>.

  We denote by <math|<cpob>> the cartesian closed category of posets with
  directed joins and continuous functions. Thus least elements are not
  assumed; if they exist we use<nbsp><math|\<perp\>> for them.

  <\asm>
    <label|nnpj>We assume that a Scott model <math|D> of
    <math|\<lambda\>>-calculus is given, i.e., a CPO with <math|\<bot\>> and
    with an embedding-projection pair

    <\equation>
      <label|eq:5.1><fold>:<cpob><around|(|D,D|)>\<triangleleft\>D:<unfold>.
    </equation>

    Moreover, for the given signature<nbsp><Sig> of terminals we also assume
    that continuous operations

    <\equation*>
      \<sigma\><rsup|D>:D<rsup|n>\<to\>D*<space|1em><text|for every
      <math|n>-ary <math|\<sigma\>> in >\<Sigma\>
    </equation*>

    are given.
  </asm>

  <\notation>
    <label|nnpd>We define a presheaf<nbsp><math|<around|\<langle\>|D,D|\<rangle\>>>
    by

    <\equation*>
      <spitze|D>\<Gamma\>=<cpob><around|(|D<rsup|\<Gamma\>>,D|)>.
    </equation*>
  </notation>

  <\rem>
    <label|nnpt>(a) Observe that elements of <math|<spitze|D>> can always be
    interpreted in <math|D>: the above function
    <math|<fold>:<spitze|D>1\<to\>D> yields obvious functions
    <math|<fold><rsub|\<Gamma\>>:<spitze|D>\<Gamma\>\<to\>D> for all
    contexts<nbsp><math|\<Gamma\>> via induction:
    define<nbsp><math|<fold><rsub|\<Gamma\>+1>> by <vspace|3mm>

    <\equation*>
      <psmatrix|c*o*l*s*e*p=25*m*m|<tformat|<table|<row|<cell|<makebox*|0*p*t><around|[|r|]><math|<around|\<langle\>|D,D|\<rangle\>>*<around|(|\<Gamma\>+1|)>\<cong\>><cpob><around|(|D<rsup|\<Gamma\>>\<times\>D,D|)>>|<cell|D>>|<row|<cell|<cpob><around|(|D<rsup|\<Gamma\>>,D<rsup|D>|)>>|<cell|<cpob><around|(|D<rsup|\<Gamma\>>,D|)><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|<fold><rsub|\<Gamma\>+1>><ncline|2,2|1,2>\<gtr\><fold><rsub|\<Gamma\>><ncline|1,1|2,1>\<less\><curry><ncline|2,1|2,2><rsub|<cpob><around|(|D<rsup|\<Gamma\>>,<fold>|)>>>>>>>
    </equation*>

    <vspace|2mm>

    <no-indent>where <math|<curry>:<cpob><around|(|D<rsup|\<Gamma\>>\<times\>D,D|)>\<to\><cpob><around|(|D<rsup|\<Gamma\>>,D<rsup|D>|)>>
    is the currification.

    <\comment>
      <\equation*>
        <spitze|D><around|(|\<Gamma\>+1|)>\<cong\><cpob><around|(|D<rsup|\<Gamma\>>\<times\>D,D|)><nsi|<curry>><cpob><around|(|D<rsup|\<Gamma\>>,<around|[|D,D|]>|)><nsi|<cpob><around|(|D<rsup|\<Gamma\>>,<fold>|)>><cpob><around|(|D<rsup|\<Gamma\>>,D|)><nsi|<fold><rsub|\<Gamma\>>>D
      </equation*>
    </comment>

    (b) The projections <math|D<rsup|\<Gamma\>>\<to\>D> are continuous
    functions, that is, elements of<nbsp><math|<around|\<langle\>|D,D|\<rangle\>>*\<Gamma\>>.
    This defines a natural pointing

    <\equation*>
      \<iota\>:V\<to\><around|\<langle\>|D,D|\<rangle\>>
    </equation*>

    of the presheaf<nbsp><math|<around|\<langle\>|D,D|\<rangle\>>>.
  </rem>

  <\rem>
    <label|nnpc>The presheaf <math|<spitze|D>> is an
    <math|H<rsub|\<lambda\>,\<Sigma\>>>-monoid. Indeed, application and
    abstraction are naturally obtained from<nbsp>(<reference|eq:5.1>),
    see<nbsp><cite|FPT>. The monoid structure

    <\equation*>
      m:<spitze|D>\<otimes\><spitze|D>\<to\><spitze|D>
    </equation*>

    can be described directly by using the coend
    formula<nbsp>(<reference|eq:3.2>) or indirectly:

    (a) For the direct description consider the component
    of<nbsp><math|m<rsub|\<Gamma\>>> corresponding, for an element
    <math|f\<in\><Set><around|(|<wide|\<Gamma\>|\<bar\>>,<cpob><around|(|D<rsup|\<Gamma\>>,D|)>|)>>,
    to the injection

    <\equation*>
      <injection><rsub|f>:<cpob><around|(|D<rsup|<wide|\<Gamma\>|\<bar\>>>,D|)>\<to\><big|int><rsup|<wide|\<Gamma\>|\<bar\>>><Set><around|(|<wide|\<Gamma\>|\<bar\>>,<cpob><around|(|D<rsup|\<Gamma\>>,D|)>|)>\<bullet\><cpob><around|(|D<rsup|<wide|\<Gamma\>|\<bar\>>>,D|)>.
    </equation*>

    Observe that <math|f><nbsp>yields a continuous function
    <math|<wide|f|~>:D<rsup|\<Gamma\>>\<to\>D<rsup|<wide|\<Gamma\>|\<bar\>>>>
    defined by <math|<wide|f|~><around|(|x|)>=f(-)<around|(|x|)>> for all
    <math|x\<in\>\<Gamma\>>. We define the component
    <math|m<rsub|\<Gamma\>><tec><injection><rsub|f>>
    of<nbsp><math|m<rsub|\<Gamma\>>> by <vspace|3mm>

    <\equation>
      <label|eq:5.2><rule|30*m*m|0*m*m><move|<psmatrix|c*o*l*s*e*p=10*m*m|<tformat|<table|<row|<cell|<makebox*|0*p*t><around|[|r|]><math|<around|\<langle\>|D,D|\<rangle\>>\<otimes\><around|\<langle\>|D,D|\<rangle\>><around|(|\<Gamma\>|)>=><big|int><rsup|<wide|\<Gamma\>|\<bar\>>><Set><around|(|<wide|\<Gamma\>|\<bar\>>,<cpob><around|(|D<rsup|\<Gamma\>>,D|)>|)>\<bullet\><cpob><around|(|D<rsup|<wide|\<Gamma\>|\<bar\>>>,D|)>>|<cell|<cpob><around|(|D<rsup|\<Gamma\>>,D|)><makebox*|0*p*t><around|[|l|]><math|=<around|\<langle\>|D,D|\<rangle\>>*\<Gamma\>>>>|<row|<cell|<CPO><around|(|D<rsup|<wide|\<Gamma\>|\<bar\>>>,D|)><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|<rule|22*m*m|0*m*m>m<rsub|\<Gamma\>>><ncline|2,1|1,1>\<less\><injection><rsub|f><ncline|2,1|1,2>\<gtr\>g\<mapsto\>g<tec><wide|f|~>>|<cell|>>>>>|0pt|-10mm>
    </equation>

    <vspace|1mm>

    (b) There is a much more elegant way of obtaining the monoid structure of
    <math|<spitze|D>>. From results of Steve Lack<nbsp><cite|lack> we see
    that the monoidal category <math|<around|(|<Set><rsup|<FF>>,\<otimes\>,V|)>>
    has the following monoidal action <math|\<ast\>> on <math|<cpob>>: given
    <math|X> in <math|<Set><rsup|<FF>>> and <math|C> in <math|<cpob>>, we put
    <math|X\<ast\>C=<big|int><rsup|\<Gamma\>>X<around|(|\<Gamma\>|)>\<bullet\>C<rsup|\<Gamma\>>>.
    Moreover, extending the above notation to pairs <math|C>,
    <math|C<rprime|'>> of CPO's and defining
    <math|<around|\<langle\>|C,C<rprime|'>|\<rangle\>>*\<Gamma\>=<cpob><around|(|C<rsup|\<Gamma\>>,C<rprime|'>|)>>
    we obtain a presheaf with a natural isomorphism

    <\equation*>
      <Set><rsup|<FF>><around|(|X,<around|\<langle\>|C,C<rprime|'>|\<rangle\>>|)>\<cong\><cpob><around|(|X\<ast\>C,C<rprime|'>|)>.
    </equation*>

    As observed by George Janelidze and Max Kelly<nbsp><cite|janelidze+kelly>
    this yields an enriched category whose hom-objects are
    <math|<around|\<langle\>|C,C<rprime|'>|\<rangle\>>>. In particular,
    <math|<spitze|D>> receives a monoid structure. It is tedious but not
    difficult to prove that this monoid structure is given
    by<nbsp>(<reference|eq:5.2>) above and it forms an
    <math|H<rsub|\<lambda\>,\<Sigma\>>>-monoid
    (cf.<nbsp>Definition<nbsp><reference|hntc>).
  </rem>

  <\notation>
    <label|nnpp>We denote by

    <\equation*>
      <sem|->:F<rsub|\<lambda\>,\<Sigma\>>\<to\><spitze|D>
    </equation*>

    the unique <math|H<rsub|\<lambda\>,\<Sigma\>>>-monoid homomorphism (see
    Theorem<nbsp><reference|hnts>). For every finite term <math|t> in context
    <math|\<Gamma\>> we thus obtain its interpretation as a continuous
    function <math|<sem|t><rsub|\<Gamma\>>:D<rsup|\<Gamma\>>\<to\>D>
  </notation>

  <\rem>
    <label|nnps>What is our intuition of an interpreted solution of higher
    order recursion scheme <math|e:X\<to\>F<rsub|\<lambda\>,\<Sigma\>>\<otimes\><around|(|X+V|)>>
    in the presheaf <math|<spitze|D>>? This should be an interpretation of
    <math|X>-terms in <math|<spitze|D>> via a natural transformation

    <\equation*>
      e<rsup|\<dag\>>:X\<to\><spitze|D>
    </equation*>

    with the following property: Given an <math|X>-term <math|x> in context
    <math|\<Gamma\>>, then <math|e<rsub|\<Gamma\>>> assigns to it an element
    <math|e<rsub|\<Gamma\>><around|(|x|)>> of
    <math|<around|(|F<rsub|\<lambda\>,\<Sigma\>>\<otimes\><around|(|X+V|)>|)><around|(|\<Gamma\>|)>>,
    that is, a finite term <math|t\<in\>F<rsub|\<lambda\>,\<Sigma\>><around|(|<wide|\<Gamma\>|\<bar\>>|)>>
    for some <math|<wide|\<Gamma\>|\<bar\>>\<subseteq\>X<around|(|\<Gamma\>|)>+\<Gamma\>>.
    We request that the solution assigns to <math|x> the same value
    <math|e<rsup|\<dag\>><rsub|\<Gamma\>><around|(|x|)>:D<rsup|\<Gamma\>>\<to\>D>
    that we obtain from the interpretation <math|<sem|t><rsub|1>> of the
    given term by substituting the <math|<wide|\<Gamma\>|\<bar\>>>-variables
    using <math|<around|[|e<rsup|\<dag\>>,\<iota\>|]>:X+V\<to\><spitze|D>>.
    This substitution is given by composing
    <math|<sem|->\<otimes\><around|[|e<rsup|\<dag\>>,\<iota\>|]>> with the
    monoid structure of <math|<spitze|D>>. This leads to the following
  </rem>

  <\defi>
    <label|nnpss>Given a higher-order recursion scheme
    <math|e:X\<to\>F<rsub|\<lambda\>,\<Sigma\>>\<otimes\><around|(|X+V|)>> by
    an <with|font-shape|italic|interpreted solution> is meant a presheaf
    morphism <math|e<rsup|\<dag\>>:X\<to\><spitze|D>> such that the square
    below commutes:

    <\equation>
      <label|eq:int><vcenter|<tformat|<table|<row|<cell|<xymatrix@C>+2*p*c*@*R-.*5*p*cX<ar*|r><rsup|e<rsup|\<dag\>>><ar*|d><rsub|e>>|<cell|<spitze|D>>>|<row|<cell|F<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)><ar*|r><rsub|<sem|->\<otimes\><around|[|e<rsup|\<dag\>>,\<iota\>|]>>>|<cell|<spitze|D>\<otimes\><spitze|D><ar*|u><rsub|m>>>>>><comment|<move|<math|<psmatrix|<tformat|<table|<row|<cell|X>|<cell|<spitze|D>>>|<row|<cell|F<rsub|\<lambda\>,\<Sigma\>>\<otimes\><around|(|X+V|)>>|<cell|<spitze|D>\<otimes\><spitze|D><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|e<rsup|\<dag\>>><ncline|2,2|1,2>\<gtr\>m<ncline|1,1|2,1>\<less\>e<ncline|2,1|2,2><rsub|<sem|->\<otimes\><around|[|e<rsup|\<dag\>>,\<iota\>|]>>>>>>>>|0pt|-10mm>>
    </equation>
  </defi>

  <\thm>
    <label|nnpo>Every higher-order recursion scheme has a least interpreted
    solution in <math|<spitze|D>> in the pointwise ordering of
    <math|<SetF><around|(|X,<around|\<langle\>|D,D|\<rangle\>>|)>>.
  </thm>

  <\proof>
    Observe that <math|<Set><rsup|<FF>><around|(|X,<spitze|D>|)>> is a CPO
    with <math|\<bot\>>. Therefore it is sufficient to prove that the endomap
    of <math|<Set><rsup|<FF>><around|(|X,<spitze|D>|)>> given by

    <\equation>
      <label|nnrpc>s\<mapsto\>m\<cdot\><around|(|<sem|->\<otimes\><around|[|s,\<iota\>|]>|)>\<cdot\>e
    </equation>

    is continuous, then we can use the Kleene Fixed-Point Theorem. Observe
    that the function<nbsp><eqref|nnrpc> is a composite <vspace|3mm>

    <\equation>
      <label|nnrpp><move|<psmatrix|c*o*l*s*e*p=30*m*m|<tformat|<table|<row|<cell|<SetF><around|(|X,<around|\<langle\>|D,D|\<rangle\>>|)>>|<cell|<SetF><around|(|X,<around|\<langle\>|D,D|\<rangle\>>|)>>>|<row|<cell|<SetF><around|(|X+V,<around|\<langle\>|D,D|\<rangle\>>|)>>|<cell|<SetF><around|(|F<rsub|\<lambda\>,<Sig>>\<otimes\><around|(|X+V|)>,<around|\<langle\>|D,D|\<rangle\>>|)><psset|a*r*r*o*w*s=-\<gtr\>,n*o*d*e*s*e*p=3*p*t><everypsbox|><ncline|1,1|1,2><rsup|s\<mapsto\>m<tec><around|(|<sem|->\<otimes\><around|[|s,\<iota\>|]>|)><tec>e><ncline|1,1|2,1>\<less\>[-,\<iota\>]<ncline|2,2|1,2>\<gtr\>-<tec>e<ncline|2,1|2,2><rsub|z\<mapsto\>m<tec><around|(|<rsub|F<rsub|\<lambda\>,<Sig>>>\<otimes\>z|)><rule|10*m*m|0*m*m>>>>>>>|0pt|-10mm>
    </equation>

    <vspace|1mm>

    <no-indent>where the vertical arrows are obviously continuous. It remains
    to prove the continuity of

    <\equation*>
      z\<mapsto\>m<tec><around|(|\<otimes\>z|)>*<space|2em><text|for
      >z:Z\<to\><around|\<langle\>|D,D|\<rangle\>>
    </equation*>

    where <math|Z=X+V> (but this structure of<nbsp><math|Z> plays no role).

    We use the coend formula<nbsp><eqref|eq:3.2>. It is obvious what the
    components of

    <\equation*>
      <around|(|\<otimes\>z|)><rsub|\<Gamma\>>:<big|int><rsup|<wide|\<Gamma\>|\<bar\>>><Set>(<around*|(|<wide|\<Gamma\>|\<bar\>>,Z<around|(|\<Gamma\>|)>|)>\<bullet\><around|\<langle\>|D,D|\<rangle\>><wide|\<Gamma\>|\<bar\>>\<to\><big|int><rsup|<wide|\<Gamma\>|\<bar\>>><Set><around*|(|<wide|\<Gamma\>|\<bar\>>,<around|\<langle\>|D,D|\<rangle\>>*\<Gamma\>|)>\<bullet\><around|\<langle\>|D,D|\<rangle\>><wide|\<Gamma\>|\<bar\>>
    </equation*>

    are: the <math|<wide|\<Gamma\>|\<bar\>>>-component composed with the
    coproduct injection of <math|u\<in\><Set><around|(|<wide|\<Gamma\>|\<bar\>>,Z<around|(|\<Gamma\>|)>|)>>
    yields the coproduct injection of

    <\equation*>
      f=z<rsub|\<Gamma\>><tec>u\<in\><Set><around*|(|<wide|\<Gamma\>|\<bar\>>,<around|\<langle\>|D,D|\<rangle\>>*\<Gamma\>|)>.
    </equation*>

    Combined with the component of<nbsp><math|m<rsub|\<Gamma\>>>,
    see<nbsp><eqref|eq:5.2>, this yields the components
    of<nbsp><math|<around|(|m<tec><around|(|\<otimes\>z|)>|)><rsub|\<Gamma\>>>
    as follows: for every context<nbsp><math|<wide|\<Gamma\>|\<bar\>>> the
    component composed with the coproduct
    injection<nbsp><math|<injection><rsub|u>> of<nbsp><math|u> is the map

    <\equation*>
      g\<mapsto\>g<tec><wide|z<rsub|\<Gamma\>><tec>u|~><space|2em><text|for
      <math|g\<in\><around|\<langle\>|D,D|\<rangle\>><wide|\<Gamma\>|\<bar\>>>.>
    </equation*>

    We are ready to prove that the lower horizontal arrow
    of<nbsp><eqref|nnrpp> is continuous. Suppose

    <\equation*>
      z=<big|sqcup><rsub|k\<in\>K>z<rsup|k>
    </equation*>

    is a directed join in the pointwise ordering of
    <math|<SetF><around|(|X+V,<around|\<langle\>|D,D|\<rangle\>>|)>>. In
    order to prove the equality

    <\equation*>
      m<tec><around|(|\<otimes\>z|)>=<big|sqcup><rsub|k\<in\>K>m<tec><around|(|\<otimes\>z<rsup|k>|)>
    </equation*>

    in<nbsp><SetF>, we choose an arbitrary context<nbsp><math|\<Gamma\>> and
    prove that

    <\equation*>
      m<rsub|\<Gamma\>><tec><around|(|\<otimes\>z<rsub|\<Gamma\>>|)>=<big|sqcup><rsub|k\<in\>K>m<rsub|\<Gamma\>><tec><around|(|\<otimes\>z<rsup|k><rsub|\<Gamma\>>|)>
    </equation*>

    holds in<nbsp><Set>. For that use the fact that the injection maps, for
    all contexts<nbsp><math|<wide|\<Gamma\>|\<bar\>>> and all
    <math|u\<in\><Set><around|(|<wide|\<Gamma\>|\<bar\>>,Z<around|(|\<Gamma\>|)>|)>>,

    <\equation*>
      <around|\<langle\>|D,D|\<rangle\>><wide|\<Gamma\>|\<bar\>><nsi|<injection><rsub|u>><Set><around*|(|<wide|\<Gamma\>|\<bar\>>,Z<around|(|\<Gamma\>|)>|)>\<bullet\><around|\<langle\>|D,D|\<rangle\>><wide|\<Gamma\>|\<bar\>><nsi|<injection><rsub|<wide|\<Gamma\>|\<bar\>>>><big|int><rsup|<wide|\<Gamma\>|\<bar\>>><Set><around*|(|<wide|\<Gamma\>|\<bar\>>,Z<around|(|\<Gamma\>|)>|)>\<bullet\><around|\<langle\>|D,D|\<rangle\>><wide|\<Gamma\>|\<bar\>>
    </equation*>

    form a collectively epimorphic cocone. Thus, it is sufficient to prove
    that for every context<nbsp><math|<wide|\<Gamma\>|\<bar\>>> and every
    <math|g\<in\><around|\<langle\>|D,D|\<rangle\>><wide|\<Gamma\>|\<bar\>>>
    we have

    <\equation*>
      g<tec><wide|z<rsub|\<Gamma\>><tec>u|~>=<big|sqcup><rsub|k\<in\>K>g<tec><wide|z<rsup|k><rsub|\<Gamma\>><tec>u|~>.
    </equation*>

    Since <math|g><nbsp>is continuous from<nbsp><math|D<rsup|<wide|\<Gamma\>|\<bar\>>>>
    to<nbsp><math|D>, we just need to verify

    <\equation*>
      <wide|z<rsub|\<Gamma\>><tec>u|~>=<big|sqcup><rsub|k\<in\>K><wide|z<rsup|k><rsub|\<Gamma\>><tec>u|~>.
    </equation*>

    From the pointwise ordering we clearly get
    <math|z<rsub|\<Gamma\>><tec>u=<big|sqcup><rsub|k\<in\>K>z<rsup|k><rsub|\<Gamma\>><tec>u>,
    thus, we only need to observe the continuity of the map
    <math|f\<mapsto\><wide|f|~>>, and this follows from the coordinate-wise
    ordering of<nbsp><math|D<rsup|\<Gamma\>>>.
  </proof>

  <section|Conclusions>

  <reset-counter|equation><label|p>

  We proved that guarded higher-order recursion schemes have a unique
  uninterpreted solution, i.e., a solution as a rational
  <math|\<lambda\>>-<Sig>-term. And they also have the least interpreted
  solution for interpretations based on Scott's models of
  <math|\<lambda\>>-calculus as CPO's with continuous operations for all
  \Pterminal\Q symbols of the recursion scheme.

  Following M.<nbsp>Fiore <with|font-shape|italic|et al><nbsp><cite|FPT> we
  worked in the category<nbsp><SetF> of sets in context, that is, covariant
  presheaves on the category<nbsp><FF> of finite sets and functions. A
  presheaf is a set dependent on a context (a finite set of variables). For
  every signature<nbsp><Sig> of \Pterminal\Q operation symbols it was proved
  in<nbsp><cite|FPT> that the presheaf<nbsp><math|F<rsub|\<lambda\>,<Sig>>>
  of all finite <math|\<lambda\>>-<Sig>-terms is the initial
  <math|H<rsub|\<lambda\>,<Sig>>>-monoid. This means that
  <math|F<rsub|\<lambda\>,<Sig>>><nbsp>has (i)<nbsp>the
  <math|\<lambda\>>-operations (of abstraction and application) together with
  the operations given by<nbsp><Sig> rendering an
  <math|H<rsub|\<lambda\>,<Sig>>>-algebra, (ii)<nbsp>the operation expressing
  simultaneous substitution rendering a monoid in the category of presheaves,
  and (iii)<nbsp>these two structures are canonically related. And
  <math|F<rsub|\<lambda\>,<Sig>>><nbsp>is the initial presheaf with such
  structure. R.<nbsp>Matthes and T.<nbsp>Uutalu<nbsp><cite|MU> showed that
  the presheaf<nbsp><math|T<rsub|\<lambda\>,<Sig>>> of finite and infinite
  <math|\<lambda\>>-<Sig>-terms is also an
  <math|H<rsub|\<lambda\>,<Sig>>>-monoid. Here we proved that this is the
  initial completely iterative <math|H<rsub|\<lambda\>,<Sig>>>-monoid. And
  its subpresheaf<nbsp><math|R<rsub|\<lambda\>,<Sig>>> of all rational
  <math|\<lambda\>>-<Sig>-terms is the initial iterative
  <math|H<rsub|\<lambda\>,<Sig>>>-monoid. We used that last presheaf in our
  uninterpreted semantics of recursion schemes.

  Our approach was based on untyped <math|\<lambda\>>-calculus. The ideas in
  the typed version are quite analogous. If <math|S><nbsp>is the set of all
  types, then we form the full subcategory<nbsp><FF>
  of<nbsp><math|<Set><rsup|S>> of finite <math|S>-sorted sets and consider
  presheaves in<nbsp><math|<around|(|<Set><rsup|S>|)><rsup|<FF>>>\Vthe latter
  category is equivalent to that of finitary endofunctors of the
  category<nbsp><math|<Set><rsup|S>>. The definition
  of<nbsp><math|H<rsub|\<lambda\>,<Sig>>> is then completely analogous to the
  untyped case, and one can form the presheaves<nbsp><math|F<rsub|\<lambda\>,<Sig>>>
  (free algebra on<nbsp><math|V>), <math|T<rsub|\<lambda\>,<Sig>>> (free
  completely iterative algebra) and<nbsp><math|R<rsub|\<lambda\>,<Sig>>>
  (free iterative algebra). Each of them is a monoid, in fact, an
  <math|H<rsub|\<lambda\>,<Sig>>>-monoid in the sense of<nbsp><cite|FPT>.
  Moreover, every guarded higher-order recursion scheme has a unique solution
  in<nbsp><math|R<rsub|\<lambda\>,<Sig>>>. The interpreted semantics can be
  built up on a <CPO>-enriched cartesian closed category (as our model of
  typed <math|\<lambda\>>-calculus) with additional continuous morphisms for
  all terminals. The details of the typed version are more involved, and we
  leave them for future work.

  Related results on higher-order substitution can be found e.g. in <cite|MU>
  and<nbsp><cite|P>.

  In future work we will, analogously as in<nbsp><cite|MM>, investigate the
  relation of uninterpreted and interpreted solutions.

  <\thebibliography|00>
    <bibitem|AAMV>Aczel, P., Admek, J., Milius, S., Velebil, J.: Infinite
    trees and completely iterative theories: a coalgebraic view. Theoret.
    Comput. Sci. <with|font-series|bold|300> (2003), 1\U45.

    <bibitem|AMV1>Admek, J., Milius, S., Velebil, J.: Iterative algebras at
    work. Math. Structures Comput. Sci. <with|font-series|bold|16> (2006),
    1085\U1131.

    <bibitem|AMV-Elgot>Admek, J., Milius, S., Velebil, J.: Elgot Algebras.
    Log. Methods Comput. Sci.<nbsp><with|font-series|bold|2>(5:4), 2006,
    32<nbsp>pp.

    <bibitem|AMV2>Admek, J., Milius, S., Velebil, J.: Semantics of
    higher-order recursion schemes. Proc. Algebra and Coalgebra in Computer
    Science (CALCO<nbsp>2009), Lect. Notes Comput.
    Sci.<nbsp><with|font-series|bold|5728>, Springer<nbsp>2009, 49\U63.

    <bibitem|nc>Admek, J., Porst, H. E.: On tree coalgebras and coalgebra
    presentations. Theoret. Comput. Sci. <with|font-series|bold|311> (2004),
    257\U283.

    <bibitem|AT>Admek, J., Trnkov, V.: Automata and algebras in a category.
    Kluwer Academic Publishers, Dordrecht, 1990.

    <bibitem|Ae>Aehlig, K.: A finite semantics of simply-typed lambda terms
    for infinite runs of automata. Proc. Computer Science Logic 2006, Lect.
    Notes Comput. Sci. <with|font-series|bold|4207>, Springer<nbsp>2006,
    104\U118.

    <bibitem|D>Damm, W.: Higher-order program schemes and their languages.
    Lect. Notes Comput. Sci. <with|font-series|bold|48>, Springer 1979,
    51\U72.

    <bibitem|F>Fiore M.: Second order dependently sorted abstract syntax.
    Proc. Logic in Computer Science 2008, IEEE Press 2008, 57\U68.

    <bibitem|FPT>Fiore, M., Plotkin, G., Turi, D.: Abstract syntax and
    variable binding. Proc. Logic in Computer Science 1999, IEEE Press 1999,
    193\U202.

    <bibitem|GL>Garland, S. J., Luckham, D. C.: Program schemes, recursion
    schemes and formal languages. J. Comput. Syst. Sci.
    <with|font-series|bold|7> (1973), 119\U160.

    <bibitem|G>Guessarian, I.: Algebraic semantics. Lect. Notes Comput. Sci.
    99, Springer, 1981.

    <bibitem|janelidze+kelly>Janelidze, G., Kelly, G. M.: A note on actions
    of a monoidal category. Theory Appl. Categ. <with|font-series|bold|9>
    (2001), 61\U91

    <bibitem|lack>Lack, S.: On the monadicity of finitary monads. J. Pure
    Appl. Algebra <with|font-series|bold|140> (1999), 65\U73.

    <bibitem|n>Makkai, M., Par R.: Accessible Categories: The Foundations of
    Categorical Model Theory. Contemporary Mathematics
    Vol.<nbsp><with|font-series|bold|104>, American Mathematical Society,
    1989.

    <bibitem|MU>Matthes, R., Uustalu, T.: Substitution in non-wellfounded
    syntax with variable binding. Theoret. Comput. Sci.
    <with|font-series|bold|327> (2004), 155\U174.

    <bibitem|nn>Milius, S.: Completely iterative algebras and completely
    iterative monads. Inform. and Comput. <with|font-series|bold|196> (2005),
    1\U41.

    <bibitem|MM>Milius, S., Moss, L.: The category theoretic solution of
    recursive program schemes. Theoret. Comput. Sci.
    <with|font-series|bold|366> (2006), 3\U59, corrigendum in
    <with|font-series|bold|403> (2008), 409\U415.

    <bibitem|M>Miranda, G.: Structures generated by higher-order grammars and
    the safety constraint. Ph.D. Thesis, Merton College, Oxford, 2006.

    <bibitem|P>Power, J.: A unified category theoretical approach to variable
    binding. Proc. MERLIN 2003.
  </thebibliography>
</body>