<TeXmacs|1.99.7>

<style|<tuple|article|std-latex>>

<\body>
  <\hide-preamble>
    <assign|U|<macro|1|<protect><rule|.1in|.1in>>>

    <new-theorem|theorem|Theorem>

    <new-theorem|acknowledgement|Acknowledgement>

    <new-theorem|algorithm|Algorithm>

    <new-theorem|axiom|Axiom>

    <new-theorem|case|Case>

    <new-theorem|claim|Claim>

    <new-theorem|conclusion|Conclusion>

    <new-theorem|condition|Condition>

    <new-theorem|conjecture|Conjecture>

    <new-theorem|corollary|Corollary>

    <new-theorem|criterion|Criterion>

    <new-theorem|definition|Definition>

    <new-theorem|example|Example>

    <new-theorem|exercise|Exercise>

    <new-theorem|lemma|Lemma>

    <new-theorem|notation|Notation>

    <new-theorem|problem|Problem>

    <new-theorem|proposition|Proposition>

    <new-theorem|remark|Remark>

    <new-theorem|solution|Solution>

    <new-theorem|summary|Summary>

    <assign|render-proof|<macro|1|body|<\surround|<no-indent><with|font-series|bold|<arg|1>.>
    | <rule|0.5em|0.5em>>
      <arg|body>
    </surround>>><assign|proof|<macro|body|<render-proof|Proof|<arg|body>>>>
  </hide-preamble>

  <\center>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<table|<row|<cell|<with|font-size|1.41|Fully
    Flexible Views: Theory and Practice><footnote|This article appears as
    Meucci A., 2008, <with|font-shape|italic|Fully Flexible Views: Theory and
    Practice>, Risk, <with|font-series|bold|21> (10)
    97-102>>>|<row|<cell|>>|<row|<cell|<with|font-size|1.19|Attilio
    Meucci><footnote|The author is grateful to Paul Glasserman, Sridhar
    Gollamudi, Ninghui Liu and an anonymous referee for their helpful
    feedback; and to aorda.com for providing Portfolio Safeguard to benchmark
    some numerical computations>>>|<row|<cell|attilio_meucci@symmys.com>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|this
    version: December 13 2010>>|<row|<cell|latest version available at
    <slink|http://ssrn.com/abstract=1213325>>>>>>
  </center>

  <vspace|2fn>

  <\center>
    <with|font-series|bold|Abstract>
  </center>

  <no-indent>We propose a unified methodology to input non-linear views from
  any number of users in fully general non-normal markets, and perform, among
  others, stress-testing, scenario analysis, and ranking allocation. We walk
  the reader through the theory and we detail an extremely efficient
  algorithm to easily implement this methodology under fully general
  assumptions. As it turns out, no repricing is ever necessary, hence the
  methodology can be readily applied to books with complex derivatives. We
  also present an analytical solution, useful for benchmarking, which per se
  generalizes notable previous results. Code illustrating this methodology in
  practice is available at

  <slink|http://www.mathworks.com/matlabcentral/fileexchange/21307>.

  <vspace|2fn>JEL Classification: <with|font-shape|italic|C1,
  G11><vspace|2fn>

  Keywords: <with|font-shape|italic|Black-Litterman, stress-test, scenario
  analysis, entropy, opinion pooling, Bayesian theory, change of measure,
  Kullback-Leibler, Monte Carlo simulations, importance sampling, fat-tails,
  median, regime shift, normal mixtures, multi-manager, skill, ranking,
  ordering information, option trading, macro
  views.><vspace|2fn><vspace|2fn><new-page>

  <section|Introduction>

  Scenario analysis allows the practitioner to explore the implications on a
  given portfolio of a set of subjective views on possible market
  realizations, see e.g. <cite|MinaXiao01>. The pathbreaking approach
  pioneered by <cite|BlackLitt90> (BL in the sequel) generalizes scenario
  analysis, by adding uncertainty on the views and on the reference risk
  model. Further generalizations have been proposed in recent years.
  <cite|Qian01> provide a framework to stress-test volatilities and
  correlations in addition to expectations. <cite|Pezier07> processes partial
  views on expectations and covariances based on least discrimination.
  <cite|Meucci08f> extends the above models to act on risk factors instead of
  returns, and thus covers highly non-linear derivative markets and views on
  external factors that influence the p&l only statistically.

  In the above techniques, the reference distribution of the risk factors is
  normal. The COP in <cite|Meucci06b> explores non-normal markets, but
  correlation stress-testing and non-linear views are not allowed.
  Furthermore, the COP relies on ad-hoc manipulations.

  Here we present the entropy pooling approach (EP in the sequel) which fully
  generalizes the above and related techniques. The inputs are an arbitrary
  market model, which we call "prior", and fully general views or
  stress-tests on that market. The output is a distribution, which we call
  "posterior", that incorporates all the inputs and can be used for risk
  management and portfolio optimization.

  To obtain the posterior, we interpret the views as statements that distort
  the prior distribution, in such a way that the least possible amount of
  spurious structure is imposed. The natural index for the structure of a
  distribution is its entropy. Therefore we define the posterior distribution
  as the one that minimizes the entropy relative to the prior. Then by
  opinion pooling we assign different confidence levels to different views
  and users.

  Among others, the EP handles non-normal markets; views on non-linear
  combinations of risk factors that impact the p&l directly or only
  statistically through correlations; views on expectations, but also
  medians, to handle fat tails; views on volatilities, correlations, tail
  behaviors, etc.; lax views, such as ranking, on all of the above, thereby
  generalizing <cite|AlmgrenChriss06>; inputs from multiple users and
  multiple confidence levels for different views.

  Furthermore, in its most general implementation the reference model is
  represented by Monte Carlo simulations, and the posterior which
  incorporates all the inputs is represented by the
  <with|font-shape|italic|same> simulations with new probabilities. Hence the
  most complex securities can be handled without costly repricing.

  In Section <reference|SecTHaoifgasodg> we introduce the EP theoretical
  framework. In Section <reference|SecImapea copy(1)> we present an
  analytical formula, which generalizes the previous results and provides a
  benchmark for the numerical implementation. In Section
  <reference|SecImapea> we discuss the numerical routine to implement the EP
  in full generality. In Section <reference|Exzagwga> we illustrate a case
  study: option trading in a non-normal environment with non-linear and
  ranking views on realized volatility, implied volatility and external macro
  factors. In Section <reference|SeccdCndogd> we conclude, comparing the EP
  to other related techniques. Fully documented code for this and other case
  studies, such as portfolios from ranking, can be downloaded at MATLAB
  Central File Exchange.

  <section|The entropy pooling approach><label|SecTHaoifgasodg>

  We consider a book driven by an <math|N>-dimensional vector of risk factors
  <math|<math-bf|X>>. In other words, denoting by <math|t> the current time,
  by <math|\<cal-I\><rsub|t>> the information currently available, and by
  <math|\<tau\>> the time to the investment horizon, there exists a
  deterministic function <math|P> that maps the realizations of
  <math|<math-bf|X>> and the information <math|\<cal-I\><rsub|t>> into the
  price <math|P<rsub|t+\<tau\>>> of each security in the book at the horizon:

  <\equation>
    P<rsub|t+\<tau\>>\<equiv\>P<around*|(|<math-bf|X>,\<cal-I\><rsub|t>|)><text|.<label|PRoixag>>
  </equation>

  This framework is completely general. For instance, in a book of options
  <math|<math-bf|X>> can represent the changes in all the underlyings and
  implied volatilities: in this case <math|<around*|(|<reference|PRoixag>|)>>
  is approximated by a second-order Taylor expansion whose coefficients are
  the "deltas", "vegas", "gammas", "vannas", "volgas", etc. Also,
  <math|<math-bf|X>> can represent a set of risk factors behind a
  computationally expensive full Monte-Carlo pricing function, such as
  interest rate values at different monitoring times for mortgage
  derivatives. Furthermore, <math|<math-bf|X>> can be augmented with a set of
  external risk factors that do not feed directly the pricing function
  <math|<around*|(|<reference|PRoixag>|)>>, but that still influence the p&l
  statistically through correlation. We explore a detailed example in these
  directions in Section <reference|Exzagwga>. In any case, we emphasize that
  <math|<math-bf|X>> can be, but by no means is restricted to, returns on a
  set of securities.

  <with|font-series|bold|The reference model>

  We assume the existence of a risk model, i.e. a model for the joint
  distribution of the risk factors, as represented by its probability density
  function (pdf)

  <\equation>
    <math-bf|X>\<sim\>f<rsub|<math-bf|X>><text|.><label|MAara>
  </equation>

  In BL, this is the "prior" factor distribution. More in general, this is a
  model that risk managers use to perform risk analyses, such as the
  computation of the volatility, tracking error, VaR, expected shortfall of a
  portfolio, along with the contributions to such measures from the different
  sources of risk. Portfolio managers and traders on the other hand use this
  model to optimize their positions. They specify a subjective index of
  satisfaction <math|\<cal-S\>>, such as the mean-(C)VaR trade-off, or the
  certainty equivalent stemming from a utility function, or a spectral
  measure, etc., see examples in <cite|Meucci05>. Satisfaction depends both
  on the market distribution <math|f<rsub|<math-bf|X>>> through the prices
  <math|<around*|(|<reference|PRoixag>|)>> and on the positions in the book,
  represented by a vector <math|<math-bf|w>>. Then the optimal book
  <math|<math-bf|w><rsup|\<ast\>>> is defined as

  <\equation>
    <math-bf|w><rsup|\<ast\>>\<equiv\><with|math-font-family|rm|\<ast\>>a*r*g*m*a*x<rsub|<math-bf|w>\<in\>\<cal-C\>><around*|{|\<cal-S\><around*|(|<math-bf|w>;f<rsub|<math-bf|X>>|)>|}><text|,<label|asgdsedhid>>
  </equation>

  where <math|\<cal-C\>> is a given set of investment constraints. The
  reference model <math|<around*|(|<reference|MAara>|)>> can be estimated
  from historical analysis, or calibrated to current market observables, see
  <cite|Meucci08f>.

  <with|font-series|bold|The views>

  In the most general case, the user expresses views on generic functions of
  the market <math|g<rsub|1><around*|(|<math-bf|X>|)>,\<ldots\>,g<rsub|K><around*|(|<math-bf|X>|)>>.
  These functions constitute a <math|K>-dimensional random variable whose
  joint distribution is implied by the reference model
  <math|<around*|(|<reference|MAara>|)>>:

  <\equation>
    <math-bf|V>\<equiv\><math-bf|g><around*|(|<math-bf|X>|)>\<sim\>f<rsub|<math-bf|V>><text|.><label|MAfa>
  </equation>

  We emphasize that, unlike in BL, in EP we do not assume that the functions
  <math|g<rsub|k>> be linear. Notice that, as a special case, one can express
  views also on the securities values <math|<around*|(|<reference|PRoixag>|)>>.

  The views, or the stress-tests, are statements on the variables
  <math|<around*|(|<reference|MAfa>|)>> which can clash with the reference
  model. In a stochastic environment, this means statements on their
  distribution. Therefore, the most detailed possible view specification is a
  complete, subjective joint distribution for those variables:

  <\equation>
    <math-bf|V>\<sim\><wide|f|~><rsub|<math-bf|V>>\<neq\>f<rsub|<math-bf|V>><text|.<label|MAfa
    copy(1)>>
  </equation>

  However, views in general are statements on only select features of the
  distribution of <math|<math-bf|V>>.

  <\itemize>
    <item>The classical views a-la BL are statements on
    <math|<wide|\<bbb-E\>|~><around*|{|V<rsub|k>|}>>, the expectations of
    each of the <math|V<rsub|k>>'s according to the new distribution
    <math|<wide|f|~><rsub|<math-bf|V>>>. Since for distributions such as
    stable distributions the expectation is not defined, in EP we consider
    views on a more general location measure
    <math|<wide|m|~><around*|{|V<rsub|k>|}>>, which can be the expectation or
    the median. The views are then set as

    <\equation>
      <wide|m|~><around*|{|V<rsub|k>|}>\<gtreqqless\>m<rsub|k>,<space|1em>k=1,\<ldots\>,K<text|,><label|BUllwivas>
    </equation>

    The values <math|m<rsub|k>> can be determined exogenously. If the user
    has only qualitative views, it is convenient to set as in
    <cite|Meucci08a>

    <\equation>
      m<rsub|k>\<equiv\>m<around*|{|V<rsub|k>|}>+\<varkappa\>*\<sigma\><around*|{|V<rsub|k>|}><text|.<label|PSfadgdg>>
    </equation>

    In this expression <math|\<sigma\>> is a measure of volatility in the
    reference model, such as the standard deviation or, in fat-tailed markets
    with infinite variance, the interquartile range; and <math|\<varkappa\>>
    is an ad-hoc multiplier, such as <math|-2>, <math|-1>, <math|1>, and
    <math|2> for "very bearish", "bearish", "bullish" and "very bullish"
    respectively.

    <item>The generalized BL views <math|<around*|(|<reference|BUllwivas>|)>>
    are not necessarily expressed as equality constraint: EP can process
    views expressed as inequalities. In particular, EP can process ordering
    information, frequent in stock and bond management:

    <\equation>
      <wide|m|~><around*|{|V<rsub|1>|}>\<geq\><wide|m|~><around*|{|V<rsub|2>|}>\<geq\>\<cdots\>\<geq\><wide|m|~><around*|{|V<rsub|K>|}><text|.><label|SyoafkaRand>
    </equation>

    <item>Views can be expressed on the volatilities. A convenient
    formulation reads:

    <\equation>
      <wide|\<sigma\>|~><around*|{|V<rsub|k>|}>\<gtreqqless\>\<varkappa\>*\<sigma\><around*|{|V<rsub|k>|}>,<space|1em>k=1,\<ldots\>,K<text|.><label|tasbVOslafs>
    </equation>

    <item>Correlation stress-tests are also views. Convenient specifications
    for the correlation matrix <math|<wide|\<bbb-C\>|~><around*|{|<math-bf|V>|}>>
    are the homogeneous shrinkage

    <\equation>
      <wide|\<bbb-C\>|~><around*|{|<math-bf|V>|}>\<equiv\>\<rho\><rsub|1><math-bf|I>+\<rho\><rsub|2>*\<bbb-C\><around*|{|<math-bf|V>|}>+\<rho\><rsub|3>*<with|math-font-family|bf|11><rprime|'><text|,<label|COtdefs>>
    </equation>

    where <math|0\<leq\>\<rho\><rsub|1>,\<rho\><rsub|2>,\<rho\><rsub|3>\<less\>1>,
    <math|\<rho\><rsub|1>+\<rho\><rsub|2>+\<rho\><rsub|3>\<equiv\>1>,
    <math|<math-bf|I>> is the identity matrix and
    <math|<with|math-font-family|bf|1>> is a vector of ones. For different
    structures see e.g. <cite|BrigoMercurio01>.

    <item>The user can input views on the lower (upper) tail behavior, as
    represented e.g. by <math|<wide|Q|~><rsub|V><around*|(|u|)>>, the
    quantile of <math|V<rsub|k>> according to the new distribution
    <math|<wide|f|~><rsub|<math-bf|V>>>, where the tail level <math|u> is
    close to zero (one). A convenient specification is

    <\equation>
      <wide|Q|~><rsub|V><around*|(|u|)>\<gtreqqless\>Q<rsub|V><around*|(|u|)><text|,<label|GTIsalzidgd
      copy(1)>>
    </equation>

    where <math|Q<rsub|V>> is the reference quantile induced by
    <math|f<rsub|<math-bf|V>>>, or alternatively benchmark quantiles such as
    the normal or the Student <math|t>.

    <item>Lower (upper) tail codependence, as represented by
    <math|<wide|C|~><rsub|<math-bf|V>><around*|(|<math-bf|u>|)>>, the cdf of
    the copula of <math|<math-bf|V>> at joint threshold levels
    <math|<math-bf|u>> close to zero (one). A convenient specification reads

    <\equation>
      <wide|C|~><rsub|<math-bf|V>><around*|(|<math-bf|u>|)>\<gtreqqless\>\<varkappa\>*C<rsub|<math-bf|V>><around*|(|<math-bf|u>|)><text|,<label|GTIsalzidgd>>
    </equation>

    where <math|C<rsub|<math-bf|V>>> is the reference copula cdf induced by
    <math|f<rsub|<math-bf|V>>>, or alternatively benchmark copula cdf's such
    as normal or Student <math|t>.
  </itemize>

  The above is a very partial list of all the possible features on which the
  user can wish to express views, and which can be handled by the EP.

  <with|font-series|bold|The posterior>

  The posterior distribution should satisfy the views without adding
  additional structure and should be as close as possible to the reference
  model <math|<around*|(|<reference|MAara>|)>>.

  The relative entropy between a generic distribution
  <math|<wide|f|~><rsub|<math-bf|X>>> and a reference distribution
  <math|f<rsub|<math-bf|X>>>

  <\equation>
    \<cal-E\><around*|(|<wide|f|~><rsub|<math-bf|X>>,f<rsub|<math-bf|X>>|)>\<equiv\><big|int><wide|f|~><rsub|<math-bf|X>><around*|(|<math-bf|x>|)>*<around*|[|ln
    <wide|f|~><rsub|<math-bf|X>><around*|(|<math-bf|x>|)>-ln
    f<rsub|<math-bf|X>><around*|(|<math-bf|x>|)>|]>*d<math-bf|x><text|.<label|SVIhjasJKL>>
  </equation>

  is a natural measure of the amount of structure in
  <math|<wide|f|~><rsub|<math-bf|X>>>; furthermore, it also measures how
  distorted <math|<wide|f|~><rsub|<math-bf|X>>> is with respect to
  <math|f<rsub|<math-bf|X>>>. Indeed, if the two distributions coincide,
  relative entropy is zero; by imposing constraints on
  <math|<wide|f|~><rsub|<math-bf|X>>> this distribution departs from
  <math|f<rsub|<math-bf|X>>> and relative entropy increases.

  Therefore, we define the posterior market distribution as

  <\equation>
    <wide|f|~><rsub|<math-bf|X>>\<equiv\><with|math-font-family|rm|\<ast\>>a*r*g*m*i*n<rsub|f\<in\>\<bbb-V\>><around*|{|\<cal-E\><around*|(|f,f<rsub|<math-bf|X>>|)>|}><text|,<label|FLSKnadd
    copy(1)>>
  </equation>

  where <math|f\<in\>\<bbb-V\>> stands for all the distributions consistent
  with the views statements such as <math|<around*|(|<reference|BUllwivas>|)>>-<math|<around*|(|<reference|GTIsalzidgd>|)>>.

  Entropy minimization is widely applied in physics and statistics, see
  <cite|CoverThomas06>. For applications to finance, see e.g.
  <cite|Avellaneda99>, <cite|DAmFusTa03>, <cite|ContTankov07> and
  <cite|Pezier07>. In our context, entropy minimization is even more natural,
  as it generalizes Bayesian updating, see <cite|CatichaGiffin06>.

  <with|font-series|bold|The confidence>

  One last step is required: the posterior
  <math|<wide|f|~><rsub|<math-bf|X>>> follows by assuming that the
  practitioner has full confidence in his statements. If the confidence is
  less than full, the posterior distribution of the factors must shrink
  towards the reference factor distribution. This is easily achieved as in
  <cite|Meucci06b> by opinion-pooling the reference model and the
  full-confidence posterior:

  <\equation>
    <wide|f|~><rsub|<math-bf|X>><rsup|c>\<equiv\><around*|(|1-c|)>*f<rsub|<math-bf|X>>+c*<wide|f|~><rsub|<math-bf|X>><text|.<label|Sateg>>
  </equation>

  The pooling parameter <math|c\<in\><around*|[|0,1|]>> represents the
  confidence level in the views: in the extreme case when the confidence is
  total, the full-confidence posterior is recovered; on the other hand, in
  the absence of confidence, the reference risk model is recovered.

  Opinion pooling becomes very useful in a multi-manager context. Indeed,
  consider <math|S> users that input their separate views on (possibly, but
  not necessarily) different functions of the market. As in
  <math|<around*|(|<reference|FLSKnadd copy(1)>|)>>, we obtain <math|S>
  full-confidence posterior distributions
  <math|<wide|f|~><rsub|<math-bf|X>><rsup|<around*|(|s|)>>>,
  <math|s=1,\<ldots\>,S>. Then the posterior distribution results naturally
  as the confidence-weighted average of the individual full-confidence
  posteriors:

  <\equation>
    <wide|f|~><rsub|<math-bf|X>><rsup|<math-bf|c>>\<equiv\><big|sum><rsub|s=1><rsup|S>c<rsub|s>*<wide|f|~><rsub|<math-bf|X>><rsup|<around*|(|s|)>><text|.<label|Mulaigte>>
  </equation>

  These confidence levels can be linked naturally to the track-record of the
  respective manager, i.e. the <math|s>-th confidence <math|c<rsub|s>> can be
  set as an increasing function of the number of past views, i.e. seniority,
  and of the correlation of these views with the actual market realization,
  in the same spirit as the "skill" measure in <cite|GrinoldKahn99>.

  The definitions <math|<around*|(|<reference|Sateg>|)>>-<math|<around*|(|<reference|Mulaigte>|)>>
  follow from a probabilistic interpretation of the confidence: one can
  easily specify different confidence levels for the different views of the
  same user and integrate these within a multi-user context. As it turns out,
  this amounts to specifying a probability measure on the power set of the
  views: we discuss these simple rules in detail in Appendix
  <reference|AppPRvab>.

  We emphasize that, unlike in BL, in EP the confidence in the views
  <math|<around*|(|<reference|Sateg>|)>> and the views on volatility
  <math|<around*|(|<reference|tasbVOslafs>|)>> are modeled separately:
  indeed, being sure about future volatility and being uncertain about future
  market realizations are two very different issues.

  <with|font-series|bold|Limit cases>

  If the practitioner has no views, i.e. <math|\<bbb-V\>> is the empty set in
  <math|<around*|(|<reference|FLSKnadd copy(1)>|)>>, then the
  confidence-weighted posterior distribution equals the reference model
  <math|f<rsub|<math-bf|X>>>.

  On the other extreme, if the views fully specify a joint distribution
  <math|<around*|(|<reference|MAfa copy(1)>|)>> the minimization
  <math|<around*|(|<reference|FLSKnadd copy(1)>|)>> is not necessary. Indeed,
  consistently with the principle of minimum discrimination information, the
  full-confidence posterior follows from its conditional-marginal
  decomposition:

  <\equation>
    <wide|f|~><rsub|<math-bf|X>><around*|(|<math-bf|x>|)>\<equiv\><big|int>f<rsub|<math-bf|X>\|<math-bf|v>><around*|(|<math-bf|x>|)>*<wide|f|~><rsub|<math-bf|V>><around*|(|<math-bf|v>|)>*d<math-bf|v><text|.<label|FUlagsgas>>
  </equation>

  In particular, this is the case in scenario analysis, where the user
  associates full probability to one single scenario
  <math|<math-bf|g><around*|(|<math-bf|X>|)>\<equiv\><wide|<math-bf|v>|~>>:
  the views are represented with a Dirac delta centered on the scenario
  <math|<wide|f|~><rsub|<math-bf|V>><around*|(|<math-bf|v>|)>\<equiv\>\<delta\>*<around*|(|<math-bf|v>-<wide|<math-bf|v>|~>|)>>,
  which, substituted in <math|<around*|(|<reference|FUlagsgas>|)>>, yields
  <math|<wide|f|~><rsub|<math-bf|X>>\<equiv\>f<rsub|<math-bf|X>\|<wide|<math-bf|v>|~>>>.
  In words, the full-confidence posterior distribution is simply the
  reference distribution, conditioned on <math|<math-bf|g><around*|(|<math-bf|X>|)>>
  assuming the scenario values <math|<wide|<math-bf|v>|~>>. Therefore, EP
  includes full-distribution specification and standard scenario analysis as
  special cases.

  <section|An analytical formula><label|SecImapea copy(1)>

  Consider as in BL a normal reference model

  <\equation>
    <math-bf|X>\<sim\><math-up|N><around*|(|<with|math-font-family|bf|\<mu\>>,<with|math-font-family|bf|\<Sigma\>>|)><text|.<label|Signaosgs>>
  </equation>

  Consider views on the expectations of arbitrary linear combinations
  <math|<math-bf|QX>> and on the covariances of arbitrary, potentially
  different, linear combinations <math|<math-bf|GX>>

  <\equation>
    \<bbb-V\>:<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<table|<row|<cell|<wide|\<bbb-E\>|~><around*|{|<math-bf|QX>|}>\<equiv\><wide|<with|math-font-family|bf|\<mu\>>|~><rsub|<math-bf|Q>>>>|<row|<cell|<wide|\<bbb-C\>|~>*o*v<around*|{|<math-bf|GX>|}>\<equiv\><wide|<with|math-font-family|bf|\<Sigma\>>|~><rsub|<math-bf|G>>,>>>>>|\<nobracket\>><label|Coaidsgna>
  </equation>

  where <math|<math-bf|Q>>, <math|<math-bf|G>>,
  <math|<wide|<with|math-font-family|bf|\<Sigma\>>|~><rsub|<math-bf|G>>> and
  <math|<wide|<with|math-font-family|bf|\<mu\>>|~><rsub|<math-bf|Q>>> are
  conformable matrices/vector.

  As we show in Appendix <reference|Appfasfppdfd>, the full-confidence
  posterior distribution <math|<around*|(|<reference|FLSKnadd copy(1)>|)>> is
  normal:

  <\equation>
    <math-bf|X>\<sim\><math-up|N><around*|(|<wide|<with|math-font-family|bf|\<mu\>>|~>,<wide|<with|math-font-family|bf|\<Sigma\>>|~>|)><text|,<label|POsterw>>
  </equation>

  where

  <align|<tformat|<table|<row|<cell|<wide|<with|math-font-family|bf|\<mu\>>|~>>|<cell|\<equiv\><with|math-font-family|bf|\<mu\>>+<with|math-font-family|bf|\<Sigma\>Q><rprime|'><around*|(|<with|math-font-family|bf|Q\<Sigma\>Q><rprime|'>|)><rsup|-1>*<around*|(|<wide|<with|math-font-family|bf|\<mu\>>|~><rsub|<math-bf|Q>>-<with|math-font-family|bf|Q\<mu\>>|)><text|,<label|MMuasfas>>>>|<row|<cell|<wide|<with|math-font-family|bf|\<Sigma\>>|~>>|<cell|\<equiv\><with|math-font-family|bf|\<Sigma\>>+<with|math-font-family|bf|\<Sigma\>G><rprime|'>*<around*|(|<around*|(|<with|math-font-family|bf|G\<Sigma\>G><rprime|'>|)><rsup|-1>*<wide|<with|math-font-family|bf|\<Sigma\>>|~><with|math-font-family|bf|<rsub|G>><around*|(|<with|math-font-family|bf|G\<Sigma\>G><rprime|'>|)><rsup|-1>-<around*|(|<with|math-font-family|bf|G\<Sigma\>G><rprime|'>|)><rsup|-1>|)>*<with|math-font-family|bf|G\<Sigma\>><text|.><label|BBuas>>>>>>

  Then the confidence-weighted posterior distribution
  <math|<around*|(|<reference|Sateg>|)>> is a normal mixture:

  <\equation>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|4|4|cell-halign|l>|<cwith|1|-1|4|4|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<table|<row|<cell|>|<cell|>|<cell|<math-up|N><around*|(|<with|math-font-family|bf|\<mu\>>,<with|math-font-family|bf|\<Sigma\>>|)>>|<cell|<around|(|probability:1-c|)>>>|<row|<cell|>|<cell|\<nearrow\>>|<cell|>|<cell|>>|<row|<cell|<math-bf|X>\<sim\>>|<cell|>|<cell|>|<cell|>>|<row|<cell|>|<cell|\<searrow\>>|<cell|>|<cell|>>|<row|<cell|>|<cell|>|<cell|<math-up|N><around*|(|<wide|<with|math-font-family|bf|\<mu\>>|~>,<wide|<with|math-font-family|bf|\<Sigma\>>|~>|)>>|<cell|<around|(|probability:c|)>>>>>><label|boiajasgfsd>
  </equation>

  This distribution is suitable for instance to stress-test market crashes,
  where high volatilities, high correlations and low expectations in
  <math|<wide|<with|math-font-family|bf|\<mu\>>|~>,<wide|<with|math-font-family|bf|\<Sigma\>>|~>>
  are expected to occur with probability <math|c\<ll\>1>.

  Formula <math|<around*|(|<reference|boiajasgfsd>|)>> generalizes results in
  <cite|Pezier07>. Also, the special case of full-confidence
  <math|c\<equiv\>1> on only one set of linear combinations
  <math|<math-bf|Q>\<equiv\><math-bf|G>> yields the result in <cite|Qian01>:
  this is not surprising, as the authors' approach is equivalent to the
  decomposition <math|<around*|(|<reference|FUlagsgas>|)>>. Finally, the
  further specialization to null dispersion in the views
  <math|<wide|<with|math-font-family|bf|\<Sigma\>>|~><with|math-font-family|bf|<rsub|G>>\<rightarrow\><with|math-font-family|bf|0>>,
  yields scenario analysis as in <cite|Meucci05>, which in turn generalizes
  the standard regression-based approach that appears e.g. in
  <cite|MinaXiao01>.

  <section|Numerical implementation><label|SecImapea>

  Except for the special case in Section <reference|SecImapea copy(1)>, the
  EP cannot be implemented analytically. However, the numerical
  implementation of the EP in full generality is extremely simple and
  computationally efficient.

  First, we represent the reference distribution
  <math|<around*|(|<reference|MAara>|)>> of the market <math|<math-bf|X>> in
  terms of a <math|J\<times\>N> panel <math|\<cal-X\>> of simulations: the
  generic <math|j>-th row of <math|\<cal-X\>> represents one in a very large
  number of joint scenarios for the <math|N> variables <math|<math-bf|X>>,
  whereas the generic <math|n>-th column of <math|\<cal-X\>> represents the
  marginal distribution of the <math|n>-th factor <math|X<rsub|n>>. With the
  scenarios we associate the <math|J\<times\>1> vector of the respective
  probabilities <math|<math-bf|p>>, whose each entry typically, but not
  necessarily, equals <math|1/J>, see <cite|GlassermanYu05> for a variety of
  methods to determine <math|<math-bf|p>>.

  We assume that each of the joint scenarios in <math|\<cal-X\>> has been
  mapped into the respective joint price scenarios for the <math|I>
  securities in the market considered by the user, by means of the
  potentially costly function <math|<around*|(|<reference|PRoixag>|)>>,
  thereby generating a <math|J\<times\>I> panel of prices <math|\<cal-P\>>.
  The panel of the security prices <math|\<cal-P\>>, along with the
  respective probabilities <math|<math-bf|p>>, is then analyzed for risk
  management purposes, or it is fed into an optimization algorithm to perform
  the asset allocation step <math|<around*|(|<reference|asgdsedhid>|)>>.

  The user expresses views on generic non-linear functions of the market
  <math|<around*|(|<reference|MAfa>|)>>. Their distribution as implied by the
  reference model is readily represented by the <math|J\<times\>K> panel
  <math|\<cal-V\>> defined entry-wise as follows:

  <\equation>
    \<cal-V\><rsub|j,k>\<equiv\>g<rsub|k><around*|(|\<cal-X\><rsub|j,1>,\<ldots\>,\<cal-X\><rsub|j,N>|)><text|,<label|VScene>>
  </equation>

  To represent the posterior distribution of the market that includes the
  views, instead of generating new simulations, we use the
  <with|font-shape|italic|same> scenarios with different probabilities
  <math|<wide|<math-bf|p>|~>>. Then, as we show in Appendix
  <reference|APpdgiasdpg>, general views such as
  <math|<around*|(|<reference|BUllwivas>|)>>-<math|<around*|(|<reference|GTIsalzidgd>|)>>
  can be written as a set of linear constraints on the new, yet to be
  determined, probabilities

  <\equation>
    <wide*|<math-bf|a>|\<bar\>>\<leq\><math-bf|A><wide|<math-bf|p>|~>\<leq\><wide|<math-bf|a>|\<bar\>><text|,><label|Cliagad>
  </equation>

  where <math|<math-bf|A>>, <math|<wide*|<math-bf|a>|\<bar\>>> and
  <math|<wide|<math-bf|a>|\<bar\>>> are simple expressions of the panel
  <math|<around*|(|<reference|VScene>|)>>. For instance, for standard views
  on expectations <math|<math-bf|A>\<equiv\>\<cal-V\><rprime|'>> and
  <math|<wide*|<math-bf|a>|\<bar\>>\<equiv\><wide|<math-bf|a>|\<bar\>>>
  quantify the views.

  <big-figure|<with|par-mode|center|<image|LDDU3004__1.eps|302.25pt|201.5pt||><label|FigPOsaSFaczc>>|Entropy
  pooling: numerical approach matches analytical solution>

  Furthermore, the relative entropy <math|<around*|(|<reference|SVIhjasJKL>|)>>
  becomes its discrete counterpart

  <\equation>
    \<cal-E\><around*|(|<wide|<math-bf|p>|~>,<math-bf|p>|)>\<equiv\><big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*<around*|[|ln
    <around*|(|<wide|p|~><rsub|j>|)>-ln <around*|(|p<rsub|j>|)>|]><text|.><label|Egnadogids>
  </equation>

  Therefore, the full-confidence posterior distribution
  <math|<around*|(|<reference|FLSKnadd copy(1)>|)>> is defined as

  <\equation>
    <wide|<math-bf|p>|~>\<equiv\><with|math-font-family|rm|\<ast\>>a*r*g*m*i*n<rsub|<wide*|<math-bf|a>|\<bar\>>\<leq\><math-bf|Af>\<leq\><wide|<math-bf|a>|\<bar\>>><around*|{|\<cal-E\><around*|(|<math-bf|f>,<math-bf|p>|)>|}><text|.<label|acsggad>>
  </equation>

  This optimization can be solved very efficiently: as we show in Appendix
  <reference|AppSovEBter>, the dual formulation is a simple linearly
  constrained convex program in a number of variables equal to the number of
  views, not the number of Monte Carlo simulations, which can be kept large.
  Therefore we can achieve an excellent accuracy even under extreme views,
  see Figure <reference|FigPOsaSFaczc>.

  Now it is immediate to compute the opinion-pooling, confidence-weighted
  posterior <math|<around*|(|<reference|Sateg>|)>>: this is represented by
  <math|<around*|(|\<cal-X\>,<math-bf|p><rsub|c>|)>>, the same simulations as
  for the reference model, but with new probabilities

  <\equation>
    <math-bf|p><rsub|c>\<equiv\><around*|(|1-c|)><math-bf|p>+c<wide|<math-bf|p>|~><text|.<label|VOaggadf>>
  </equation>

  A similar expression holds for the more general multi-user,
  multi-confidence posterior discussed in Appendix <reference|AppPRvab>.

  Since the posterior factor distribution is obtained by tweaking the
  relative probabilities of the scenarios <math|\<cal-X\>> without affecting
  the scenarios themselves, the posterior distribution of the market prices
  is represented by <math|<around*|(|\<cal-P\>,<math-bf|p><rsub|c>|)>>, the
  <with|font-shape|italic|original> panel of joint prices and the new
  probabilities. Hence no repricing is necessary to process views and
  stress-tests.

  <section|Case study: option trading><label|Exzagwga>

  As in <cite|Meucci08f>, we consider a trader of butterflies, defined as
  long positions in one call and one put with the same strike, underlying,
  and time to maturity. The price <math|P<rsub|t+\<tau\>>> of the butterfly
  at the investment horizon can be written in the format
  <math|<around*|(|<reference|PRoixag>|)>> as a deterministic non-linear
  function of a set of risk factors and current information. Indeed

  <\equation>
    P<rsub|t+\<tau\>>=B*S*<around*|(|y<rsub|t>*e<rsup|X<rsub|y>>,h*<around*|(|y<rsub|t>*e<rsup|X<rsub|y>>,\<sigma\><rsub|t>+X<rsub|\<sigma\>>,K,T-\<tau\>|)>;K,T-\<tau\>,r|)><text|.><label|PRasf>
  </equation>

  In this expression <math|\<tau\>> is the investment horizon;
  <math|y<rsub|t>> is the current value and <math|X<rsub|y>\<equiv\>ln
  <around*|(|y<rsub|t+\<tau\>>/y<rsub|t>|)>> is the log-change of the
  underlying; <math|\<sigma\><rsub|t>> is the current value and
  <math|X<rsub|\<sigma\>>\<equiv\>\<sigma\><rsub|t+\<tau\>>-\<sigma\><rsub|t>>
  is the change in ATM implied volatility; <math|B*S> is the Black-Scholes
  formula

  <\equation>
    B*S<around*|(|y,\<sigma\>;K,T,r|)>\<equiv\>y*<around*|[|\<Phi\><around*|(|d<rsub|1>|)>-\<Phi\>*<around*|(|-d<rsub|1>|)>|]>-K*e<rsup|-r*T>*<around*|[|\<Phi\><around*|(|d<rsub|2>|)>-\<Phi\>*<around*|(|-d<rsub|2>|)>|]><text|,<label|PRicsnafg>>
  </equation>

  where <math|\<Phi\>> is the standard normal cdf; <math|K> is the strike;
  <math|T> is the time to expiry; <math|r> is the risk-free rate;
  <math|d<rsub|1>\<equiv\><around*|(|ln <around*|(|y/K|)>+<around*|(|r+\<sigma\><rsup|2>/2|)>*T|)>/\<sigma\><sqrt|T>>,
  <math|d<rsub|2>\<equiv\>d<rsub|1>-\<sigma\><sqrt|T>>; and <math|h> is a
  skew/smile map

  <\equation>
    h<around*|(|y,\<sigma\>;K,T|)>\<equiv\>\<sigma\>+\<alpha\><frac|ln
    <around*|(|y/K|)>|<sqrt|T>>+\<beta\><around*|(|<frac|ln
    <around*|(|y/K|)>|<sqrt|T>>|)><rsup|2><text|,>
  </equation>

  for coefficients <math|\<alpha\>> and <math|\<beta\>> which depend on the
  underlying and are fitted empirically, similarly to <cite|Malz97>. If the
  investment horizon <math|\<tau\>> is short, a delta-gamma-vega
  approximation of <math|<around*|(|<reference|PRasf>|)>> would suffice.
  However, we leave the exact formulation to demonstrate how the present
  approach does not require costly repricing.

  Consider a portfolio represented by the vector <math|<math-bf|w>>, whose
  generic <math|i>-th entry is the number of contracts in the respective
  butterfly. The p&l then reads

  <\equation>
    \<Pi\><rsub|<math-bf|w>>\<equiv\><big|sum><rsub|i=1><rsup|I>w<rsub|i>*<around*|(|P<rsub|i><around*|(|<math-bf|X>,\<cal-I\><rsub|t>|)>-P<rsub|i,t>|)><text|,>
  </equation>

  where <math|P<rsub|i><around*|(|<math-bf|X>,\<cal-I\><rsub|t>|)>> is the
  price at the horizon <math|<around*|(|<reference|PRasf>|)>> and
  <math|P<rsub|i,t>> is the currently traded price of the <math|i>-th
  butterfly. We assume that, in order to account for market asymmetries and
  downside risk, the trader optimizes the mean-CVaR trade-off. Therefore
  <math|<around*|(|<reference|asgdsedhid>|)>> becomes

  <\equation>
    <math-bf|w><rsub|\<lambda\>>\<equiv\><with|math-font-family|rm|\<ast\>>a*r*g*m*a*x<rsub|<wide*|<math-bf|b>|\<bar\>>\<leq\><math-bf|Bw>\<leq\><wide|<math-bf|b>|\<bar\>>>*<around*|{|\<bbb-E\><around*|{|\<Pi\><rsub|<math-bf|w>>|}>-\<lambda\><with|math-font-family|rm|\<ast\>>C*V*a*R<rsub|\<gamma\>><around*|{|\<Pi\><rsub|<math-bf|w>>|}>|}><text|,<label|asgdsedhid
    copy(5)>>
  </equation>

  where <math|\<gamma\>> is the CVaR tail level; and <math|<math-bf|B>>,
  <math|<wide*|<math-bf|b>|\<bar\>>>, and <math|<wide|<math-bf|b>|\<bar\>>>
  are a matrix and vectors that represent investment constraints.

  To illustrate, we set <math|\<gamma\>\<equiv\>95%>, we impose that the
  long-short positions offset to a zero delta and a zero initial budget, and
  that the absolute investment in each option does not exceed a fixed
  threshold. We set the investment horizon as <math|\<tau\>\<equiv\>1> day.
  We consider a limited market of <math|I\<equiv\>9> securities: 1-month,
  2-month and 6-month butterflies on the three technology stocks Microsoft
  (M), Yahoo (Y) and Google (G).

  In addition to the respective underlyings and implied volatilities, we
  include the possibility of views on growth or inflation, as represented by
  the slope of the interest rate curve: therefore we add the changes in the
  two- and ten-year points of the curve, for a total of <math|N\<equiv\>14>
  factors:

  <\equation>
    <math-bf|X>\<equiv\><around*|(|X<rsup|M>,X<rsub|1*m><rsup|M>,X<rsub|2*m><rsup|M>,X<rsub|6*m><rsup|M>,\<ldots\>,,X<rsub|6*m><rsup|G>,X<rsub|2*y>,X<rsub|10*y>|)><rprime|'><text|.>
  </equation>

  To determine the reference distribution
  <math|<around*|(|<reference|MAara>|)>> of these factors we consider the
  panel of joint observations of the factors over a three-year horizon: this
  amounts to <math|700> observations. To achieve <math|J\<equiv\>10<rsup|5>>
  joint simulations we kernel-bootstrap the historical scenarios: for each
  historical observation <math|<math-bf|x><rsub|t>>, we draw
  <math|10<rsup|5>/700> observations from the multivariate normal
  distribution <math|<math-up|N><around*|(|<math-bf|x><rsub|t>,\<epsilon\>*<wide|<with|math-font-family|bf|\<Sigma\>>|^>|)>>,
  where <math|<wide|<with|math-font-family|bf|\<Sigma\>>|^>> is the sample
  covariance and we set <math|\<epsilon\>\<equiv\>0.15>. The juxtaposition of
  the above simulations yields the desired <math|J\<times\>N> panel
  <math|\<cal-X\>>, where each scenario has equal probability
  <math|p<rsub|j>\<equiv\>1/J>.

  Then we input each scenario of <math|\<cal-X\>> into the pricing function
  <math|<around*|(|<reference|PRicsnafg>|)>>, obtaining the joint p&l
  scenarios <math|\<cal-P\>> with equal probabilities <math|<math-bf|p>>. The
  sample counterpart of the mean-CVaR efficient frontier
  <math|<around*|(|<reference|asgdsedhid copy(5)>|)>> reads

  <\equation>
    <math-bf|w><rsub|\<lambda\>>\<equiv\><with|math-font-family|rm|\<ast\>>a*r*g*m*a*x<rsub|<wide*|<math-bf|b>|\<bar\>>\<leq\><math-bf|Bw>\<leq\><wide|<math-bf|b>|\<bar\>>>*<around*|{|<around*|(|<math-bf|w><rprime|'>\<cal-P\><rprime|'><math-bf|p>|)>+\<lambda\><frac|<around*|[|<math-bf|p>|]><rprime|'><around*|[|\<cal-P\><math-bf|w>|]>|<around*|[|<math-bf|p>|]><rprime|'><around*|[|<with|math-font-family|bf|1>|]>>|}><text|,<label|Inasgasdg
    copy(1)>>
  </equation>

  where the operator <math|<around*|[|<math-bf|x>|]>> selects in the generic
  vector <math|<math-bf|x>> only the entries that correspond to the
  <math|<around*|(|1-\<gamma\>|)>*J> smallest entries of
  <math|\<cal-P\><math-bf|w>>. If <math|J> is not too large this can be
  solved by linear programming as in <cite|RockafellarUryas00>. For very
  large <math|J> we solve this heuristically as in <cite|Meucci05> by a
  two-step approach: first determine the mean-variance efficient frontier,
  then perform a uni-variate grid search for the optimal trade-off
  <math|<around*|(|<reference|Inasgasdg copy(1)>|)>>.

  <big-figure|<with|par-mode|center|<image|LDDU3005__2.eps|302.25pt|141pt||><label|FigPERiaf>>|Mean-CVaR
  long-short efficient frontier: prior risk model>

  In Figure <reference|FigPERiaf> we display the frontier ensuing from the
  reference market model in our example. For the extreme case of zero risk
  appetite, not investing at all is optimal. As the risk appetite increases,
  leverage increases, always respecting the constraint of a zero net initial
  investment, as well as delta-neutrality. When the risk appetite increases
  further, the remaining constraints enter the picture.

  Now we consider the views of three distinct analysts. The first one is
  bearish about the 2m-6m implied volatility spread for Google. From
  <math|<around*|(|<reference|BUllwivas>|)>>-<math|<around*|(|<reference|PSfadgdg>|)>>
  this means

  <\equation>
    <wide|\<bbb-E\>|~>*<around*|{|X<rsub|6*m><rsup|G>-X<rsub|2*m><rsup|G>|}>\<leq\>\<bbb-E\>*<around*|{|X<rsub|6*m><rsup|G>-X<rsub|2*m><rsup|G>|}>-\<sigma\>*<around*|{|X<rsub|6*m><rsup|G>-X<rsub|2*m><rsup|G>|}><text|.<label|Vadidaada>>
  </equation>

  This view is represented in the form <math|<around*|(|<reference|Cliagad>|)>>
  as

  <\equation>
    <big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j><rsup|<around*|(|1|)>>*<around*|(|X<rsub|j,6*m><rsup|G>-X<rsub|j,2*m><rsup|G>|)>\<leq\><wide|m|^><rsub|6\|2>-<wide|\<sigma\>|^><rsub|6\|2><text|,><label|Serasg>
  </equation>

  where <math|<wide|m|^><rsub|6\|2>> and <math|<wide|\<sigma\>|^><rsub|6\|2>>
  are the sample counterparts of the respective terms in
  <math|<around*|(|<reference|Vadidaada>|)>>. We can compute
  <math|<wide|<math-bf|p>|~><rsup|<around*|(|1|)>>> as in
  <math|<around*|(|<reference|acsggad>|)>>, under the constraint
  <math|<around*|(|<reference|Serasg>|)>>. To illustrate, we show In Figure
  <reference|FIgPOsateSPera> the mean-CVaR efficient frontier
  <math|<around*|(|<reference|Inasgasdg copy(1)>|)>> when this view is
  processed: as expected, the G6m-G2m spread, previously long, is now short.

  <big-figure|<with|par-mode|center|<image|LDDU3006__3.eps|302.25pt|141pt||><label|FIgPOsateSPera>>|Mean-CVaR
  long-short efficient frontier: view on G6m-G2m spread>

  The second analyst is bullish on the realized volatility of Microsoft,
  defined as <math|<around*|\||X<rsup|M>|\|>>, the absolute log-change in the
  underlying: this is the variable such that, if larger than a threshold, a
  long position in the butterfly turns into a profit. Since this variable
  displays thick tails and the expectation might not be defined, see e.g.
  <cite|rachev03>, we issue a relative statement on the median, comparing it
  with the third quintile implied by the reference market model:

  <\equation>
    <wide|\<bbb-M\>|~><around*|{|<around*|\||X<rsup|M>|\|>|}>\<geq\>Q<rsub|<around*|\||X<rsup|M>|\|>><around*|(|<frac|3|5>|)><text|.>
  </equation>

  This view is represented in the form <math|<around*|(|<reference|Cliagad>|)>>
  as

  <\equation>
    <big|sum><rsub|j\<in\><wide|J|~>><wide|p|~><rsub|j><rsup|<around*|(|2|)>>\<leq\><frac|1|2><text|,<label|VIdaeSsytw>>
  </equation>

  where <math|<wide|J|~>> is the set of indices <math|j> such that
  <math|<around*|\||X<rsub|j><rsup|M>|\|>> is smaller than the sample third
  quintile of <math|<around*|\||X<rsup|M>|\|>>, see Appendix
  <reference|APpdgiasdpg>. Now we can compute
  <math|<wide|<math-bf|p>|~><rsup|<around*|(|2|)>>> as in
  <math|<around*|(|<reference|acsggad>|)>> under the constraint
  <math|<around*|(|<reference|VIdaeSsytw>|)>>.

  The third analyst believes that the slope of the curve will increase by
  five basis points. Therefore he formulates the view a-la BL, using in
  <math|<around*|(|<reference|BUllwivas>|)>> expectations and binding
  constraints:

  <\equation>
    <big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j><rsup|<around*|(|3|)>>*<around*|(|X<rsub|j,10*y>-X<rsub|j,2*y>|)>\<equiv\>0.0005<text|.>
  </equation>

  and <math|<wide|<math-bf|p>|~><rsup|<around*|(|3|)>>> can be computed as in
  <math|<around*|(|<reference|acsggad>|)>>.

  <big-figure|<with|par-mode|center|<image|LDDU3007__4.eps|302.25pt|141pt||><label|FIgPOsteStaea>>|Mean-CVaR
  long-short efficient frontier: all views>

  The management committee attributes <math|c<rsub|1>\<equiv\>0.20>,
  <math|c<rsub|2>\<equiv\>0.25> and <math|c<rsub|3>\<equiv\>0.20> confidence
  on the analysts' views, the remaining portion being attributed to the
  reference model. Then the uncertainty-weighted posterior probabilities read

  <\equation>
    <wide|<math-bf|p>|~><rsub|<math-bf|c>>\<equiv\><big|sum><rsub|s=0><rsup|3>c<rsub|s><wide|<math-bf|p>|~><rsup|<around*|(|s|)>><text|,>
  </equation>

  where <math|c<rsub|0>\<equiv\>1-c<rsub|1>-c<rsub|2>-c<rsub|3>> and
  <math|<wide|<math-bf|p>|~><rsup|<around*|(|0|)>>\<equiv\><math-bf|p>>. We
  show in Figure <reference|FIgPOsteStaea> the combined effects of all the
  views on the frontier <math|<around*|(|<reference|Inasgasdg copy(1)>|)>>.

  We emphasize that in this case study the market has a non-parametric,
  thick-tailed, non-normal distribution; two views are expressed as
  inequalities; one view acts on a non-linear function, the absolute value,
  of a factor; the slope of the curve in one view is an external factor that
  appears nowhere in the pricing function of the securities; features
  different from expectations are being assessed, namely the median; and no
  repricing was ever necessary.

  <section|Conclusions><label|SeccdCndogd>

  We present the EP, a unified framework to perform trading, portfolio
  management and generalized stress-testing in markets with complex
  derivatives driven by non-normal factors. The inputs are a possibly
  non-normal reference market model and a set of very general equality or
  inequality views on a variety of features of the market. The output is a
  posterior distribution that incorporates all the inputs. As it turns out,
  the EP avoids costly repricing by representing the posterior distribution
  in terms of the same scenarios as the reference model, but with different
  probabilities whose computation is extremely efficient.

  We summarize in the table below the capabilities of the EP as compared to
  <cite|BlackLitt90>, <cite|AlmgrenChriss06>, <cite|Qian01>, <cite|Pezier07>,
  <cite|Meucci08f> and the COP in <cite|Meucci06b>.

  <\equation*>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|7|7|cell-halign|c>|<cwith|1|-1|8|8|cell-halign|c>|<cwith|1|-1|8|8|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<table|<row|<cell|>|<cell|B*L>|<cell|A*C>|<cell|Q*G>|<cell|P>|<cell|M>|<cell|C*O*P>|<cell|E*P>>|<row|<cell|n*o*r*m*a*l*m*a*r*k*e*t*&*l*i*n*e*a*r*v*i*e*w*s>|<cell|\<checkmark\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>>|<row|<cell|scenario
    analysis>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>>|<row|<cell|correlation
    stress-test>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>>|<row|<cell|trading
    desk:non-linear pricing>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>>|<row|<cell|external
    factors:macro,etc.>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>>|<row|<cell|partial
    specifications>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>>|<row|<cell|non-normal
    market>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>>|<row|<cell|multiple
    users>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>|<cell|\<checkmark\>>>|<row|<cell|non-linear
    views>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>>|<row|<cell|trading
    desk:costly pricing>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>>|<row|<cell|lax
    constraints:ranking>|<cell|\<cdot\>>|<cell|\<checkmark\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<cdot\>>|<cell|\<checkmark\>>>>>>
  </equation*>

  <\bibliography|bib|jf|Finance>
    <bib-list|[99]|>
  </bibliography>

  <new-page>

  <section|Appendix>

  In this appendix we present proofs, results and details that can be skipped
  at first reading.

  <subsection|The analytical solution><label|Appfasfppdfd>

  Using the explicit expression for the multivariate normal pdf

  <\equation>
    ln f<rsub|<with|math-font-family|bf|\<mu\>>,<with|math-font-family|bf|\<Sigma\>>><around*|(|<math-bf|x>|)>\<equiv\>-<frac|N|2>*ln
    <around*|(|2*\<pi\>|)>-<frac|1|2>*ln <around*|\||<with|math-font-family|bf|\<Sigma\>>|\|>-<frac|1|2>*<around*|(|<math-bf|x>-<with|math-font-family|bf|\<mu\>>|)><rprime|'>*\<Sigma\><rsup|-1>*<around*|(|<math-bf|x>-<with|math-font-family|bf|\<mu\>>|)>
  </equation>

  we can compute the Kullback-Leibler divergence between normal
  distributions:

  <align|<tformat|<table|<row|<cell|D<rsub|K*L><around*|(|f<rsub|<wide|<with|math-font-family|bf|\<mu\>>|~>,<wide|<with|math-font-family|bf|\<Sigma\>>|~>>,f<rsub|<with|math-font-family|bf|\<mu\>>,<with|math-font-family|bf|\<Sigma\>>>|)>>|<cell|\<equiv\><big|int><rsub|\<bbb-R\><rsup|N>>f<rsub|<wide|<with|math-font-family|bf|\<mu\>>|~>,<wide|<with|math-font-family|bf|\<Sigma\>>|~>><around*|(|<math-bf|x>|)>*ln
  f<rsub|<wide|<with|math-font-family|bf|\<mu\>>|~>,<wide|<with|math-font-family|bf|\<Sigma\>>|~>><around*|(|<math-bf|x>|)>*d<math-bf|x><text|<label|KSagfs>>>>|<row|<cell|>|<cell|-<big|int><rsub|\<bbb-R\><rsup|N>>f<rsub|<wide|<with|math-font-family|bf|\<mu\>>|~>,<wide|<with|math-font-family|bf|\<Sigma\>>|~>><around*|(|<math-bf|x>|)>*ln
  f<rsub|<with|math-font-family|bf|\<mu\>>,<with|math-font-family|bf|\<Sigma\>>><around*|(|<math-bf|x>|)>*d<math-bf|x><no-number>>>|<row|<cell|>|<cell|=-<frac|N|2>*ln
  <around*|(|2*\<pi\>|)>-<frac|1|2>*ln <around*|\||<wide|<with|math-font-family|bf|\<Sigma\>>|~>|\|>-<frac|1|2>*<wide|\<bbb-E\>|~><around*|{|<around*|(|<math-bf|X>-<wide|<with|math-font-family|bf|\<mu\>>|~>|)><rprime|'>*<wide|<with|math-font-family|bf|\<Sigma\>>|~><rsup|-1>*<around*|(|<math-bf|X>-<wide|<with|math-font-family|bf|\<mu\>>|~>|)>|}><no-number>>>|<row|<cell|>|<cell|+<frac|N|2>*ln
  <around*|(|2*\<pi\>|)>+<frac|1|2>*ln <around*|\||<with|math-font-family|bf|\<Sigma\>>|\|>+<frac|1|2>*<wide|\<bbb-E\>|~><around*|{|<around*|(|<math-bf|X>-<with|math-font-family|bf|\<mu\>>|)><rprime|'>*<with|math-font-family|bf|\<Sigma\>><rsup|-1>*<around*|(|<math-bf|X>-<with|math-font-family|bf|\<mu\>>|)>|}><no-number>>>|<row|<cell|>|<cell|=<frac|1|2>*ln
  <around*|\||<wide|<with|math-font-family|bf|\<Sigma\>>|~><rsup|-1>*<with|math-font-family|bf|\<Sigma\>>|\|>-<frac|1|2><math-up|tr><around*|[|<wide|\<bbb-E\>|~><around*|{|<around*|(|<math-bf|X>-<wide|<with|math-font-family|bf|\<mu\>>|~>|)>*<around*|(|<math-bf|X>-<wide|<with|math-font-family|bf|\<mu\>>|~>|)><rprime|'>|}>*<wide|<with|math-font-family|bf|\<Sigma\>>|~><rsup|-1>|]><no-number>>>|<row|<cell|>|<cell|+<frac|1|2><math-up|tr><around*|[|<wide|\<bbb-E\>|~><around*|{|<around*|(|<math-bf|X>-<with|math-font-family|bf|\<mu\>>|)>*<around*|(|<math-bf|X>-<with|math-font-family|bf|\<mu\>>|)><rprime|'>|}>*<with|math-font-family|bf|\<Sigma\>><rsup|-1>|]><no-number>>>|<row|<cell|>|<cell|=<frac|1|2>*ln
  <around*|\||<wide|<with|math-font-family|bf|\<Sigma\>>|~><rsup|-1>*<with|math-font-family|bf|\<Sigma\>>|\|>-<frac|N|2>+<frac|1|2><math-up|tr><around*|[|<around*|(|<wide|<with|math-font-family|bf|\<Sigma\>>|~>+<around*|(|<wide|<with|math-font-family|bf|\<mu\>>|~>-<with|math-font-family|bf|\<mu\>>|)>*<around*|(|<wide|<with|math-font-family|bf|\<mu\>>|~>-<with|math-font-family|bf|\<mu\>>|)><rprime|'>|)>*<with|math-font-family|bf|\<Sigma\>><rsup|-1>|]><no-number>>>|<row|<cell|>|<cell|=<frac|1|2>*ln
  <around*|\||<wide|<with|math-font-family|bf|\<Sigma\>>|~><rsup|-1>*<with|math-font-family|bf|\<Sigma\>>|\|>-<frac|N|2>+<frac|1|2><math-up|tr><around*|[|<wide|<with|math-font-family|bf|\<Sigma\>>|~>*<with|math-font-family|bf|\<Sigma\>><rsup|-1>|]><no-number>>>|<row|<cell|>|<cell|+<frac|1|2>*<around*|(|<wide|<with|math-font-family|bf|\<mu\>>|~>-<with|math-font-family|bf|\<mu\>>|)><rprime|'>*<with|math-font-family|bf|\<Sigma\>><rsup|-1>*<around*|(|<wide|<with|math-font-family|bf|\<mu\>>|~>-<with|math-font-family|bf|\<mu\>>|)>*<no-number>>>>>>

  Our purpose is to minimize the Kullback-Leibler divergence
  <math|<around*|(|<reference|KSagfs>|)>> under the constraints
  <math|<around*|(|<reference|Coaidsgna>|)>>. Using the following matrix
  identity

  <\equation>
    <math-up|vec><around*|(|<with|math-font-family|bf|\<Gamma\>>|)><rprime|'><math-up|vec><around*|(|<math-bf|A>|)>\<equiv\><big|sum><rsub|i,k>\<Gamma\><rsub|k*i>*A<rsub|k*i>=<math-up|tr><around*|(|<with|math-font-family|bf|\<Gamma\>><rprime|'><math-bf|A>|)><text|,<label|casiofadso>>
  </equation>

  we write the Lagrangian as

  <align|<tformat|<table|<row|<cell|\<cal-L\>>|<cell|=<frac|1|2>*<around*|(|<wide|<with|math-font-family|bf|\<mu\>>|~>-<with|math-font-family|bf|\<mu\>>|)><rprime|'>*<with|math-font-family|bf|\<Sigma\>><rsup|-1>*<around*|(|<wide|<with|math-font-family|bf|\<mu\>>|~>-<with|math-font-family|bf|\<mu\>>|)>+<frac|1|2><math-up|tr><around*|(|<with|math-font-family|bf|\<Sigma\>><rsup|-1>*<wide|<with|math-font-family|bf|\<Sigma\>>|~>|)>-<frac|1|2>*ln
  <around*|(|<around*|\||<with|math-font-family|bf|\<Sigma\>><rsup|-1>*<wide|<with|math-font-family|bf|\<Sigma\>>|~>|\|>|)>>>|<row|<cell|>|<cell|-<with|math-font-family|bf|\<lambda\>><rprime|'>*<around*|(|<math-bf|Q><wide|<with|math-font-family|bf|\<mu\>>|~>-<wide|<with|math-font-family|bf|\<mu\>>|~><rsub|<math-bf|Q>>|)>-<frac|1|2><math-up|tr><around*|(|<with|math-font-family|bf|\<Gamma\>><rprime|'>*<around*|(|<math-bf|G><wide|<with|math-font-family|bf|\<Sigma\>>|~><math-bf|G><rprime|'>-<wide|<with|math-font-family|bf|\<Sigma\>>|~><with|math-font-family|bf|<rsub|G>>|)>|)><text|.><no-number>>>>>>

  The first order conditions for <math|<wide|<with|math-font-family|bf|\<mu\>>|~>>
  read

  <\equation>
    <with|math-font-family|bf|0>\<equiv\><frac|\<partial\>*\<cal-L\>|\<partial\><wide|<with|math-font-family|bf|\<mu\>>|~>>=<with|math-font-family|bf|\<Sigma\>><rsup|-1>*<around*|(|<wide|<with|math-font-family|bf|\<mu\>>|~>-<with|math-font-family|bf|\<mu\>>|)>-<math-bf|Q><rprime|'><with|math-font-family|bf|\<lambda\>><text|,>
  </equation>

  or equivalently

  <\equation>
    <wide|<with|math-font-family|bf|\<mu\>>|~>-<with|math-font-family|bf|\<mu\>>=<with|math-font-family|bf|\<Sigma\>Q><rprime|'><with|math-font-family|bf|\<lambda\>><text|.<label|Faidogg>>
  </equation>

  Pre-multiplying by <math|<math-bf|Q>> both sides this implies

  <\equation>
    <with|math-font-family|bf|\<lambda\>>=<around*|(|<with|math-font-family|bf|Q\<Sigma\>Q><rprime|'>|)><rsup|-1>*<around*|(|<wide|<with|math-font-family|bf|\<mu\>>|~><rsub|<math-bf|Q>>-<with|math-font-family|bf|Q\<mu\>>|)><text|.>
  </equation>

  Substituting this in <math|<around*|(|<reference|Faidogg>|)>> we obtain

  <\equation>
    <wide|<with|math-font-family|bf|\<mu\>>|~>=<with|math-font-family|bf|\<mu\>+\<Sigma\>Q><rprime|'><around*|(|<math-bf|Q><wide|<with|math-font-family|bf|\<Sigma\>>|~><math-bf|Q><rprime|'>|)><rsup|-1>*<around*|(|<wide|<with|math-font-family|bf|\<mu\>>|~><rsub|<math-bf|Q>>-<with|math-font-family|bf|Q\<mu\>>|)><label|gfpaogjad>
  </equation>

  To determine the first order conditions for
  <math|<wide|<with|math-font-family|bf|\<Sigma\>>|~>> we first use the
  identity in <cite|Minka03>

  <\equation>
    d*ln <around*|\||<math-bf|X>|\|>=<math-up|tr><around*|(|<math-bf|X><rsup|-1>d<math-bf|X>|)>
  </equation>

  and the symmetry of <math|<with|math-font-family|bf|\<Gamma\>>> to express
  the differential of the Lagrangian with respect to
  <math|<wide|<with|math-font-family|bf|\<Sigma\>>|~>> as follows:

  <\equation>
    d*\<cal-L\>=<frac|1|2><math-up|tr><around*|(|<with|math-font-family|bf|\<Sigma\>><rsup|-1>*d*<wide|<with|math-font-family|bf|\<Sigma\>>|~>|)>-<frac|1|2><math-up|tr><around*|(|<wide|<with|math-font-family|bf|\<Sigma\>>|~><rsup|-1>*d*<wide|<with|math-font-family|bf|\<Sigma\>>|~>|)>-<frac|1|2><math-up|tr><around*|(|<math-bf|G><rprime|'><with|math-font-family|bf|\<Gamma\>G>*d*<wide|<with|math-font-family|bf|\<Sigma\>>|~>|)><text|.<label|asjgpasdg>>
  </equation>

  Using again <math|<around*|(|<reference|casiofadso>|)>> to setting
  <math|<around*|(|<reference|asjgpasdg>|)>> to zero we obtain:

  <\equation>
    <wide|<with|math-font-family|bf|\<Sigma\>>|~><rsup|-1>=<with|math-font-family|bf|\<Sigma\>><rsup|-1>-<math-bf|G><rprime|'><with|math-font-family|bf|\<Gamma\>G><text|<label|aospgjpdag>>
  </equation>

  Using the following matrix identity (<math|<math-bf|A>> and
  <math|<math-bf|D>> invertible, <math|<math-bf|B>> and <math|<math-bf|C>>
  conformable)

  <\equation>
    <around*|(|<math-bf|A>-<math-bf|BD><rsup|-1><math-bf|C>|)><rsup|-1>=<math-bf|A><rsup|-1>-<math-bf|A><rsup|-1><math-bf|B><around*|(|<math-bf|CA><rsup|-1><math-bf|B>-<math-bf|D>|)><rsup|-1><math-bf|CA><rsup|-1><text|,><label|MatrIdent87>
  </equation>

  we can write <math|<around*|(|<reference|aospgjpdag>|)>> as

  <align|<tformat|<table|<row|<cell|<wide|<with|math-font-family|bf|\<Sigma\>>|~>>|<cell|=<around*|(|<with|math-font-family|bf|\<Sigma\>><rsup|-1>-<math-bf|G><rprime|'><with|math-font-family|bf|\<Gamma\>G>|)><rsup|-1><label|apogjpadgd>>>|<row|<cell|>|<cell|=<with|math-font-family|bf|\<Sigma\>>-<with|math-font-family|bf|\<Sigma\>G><rprime|'>*<around*|(|<with|math-font-family|bf|G\<Sigma\>G><rprime|'>-<with|math-font-family|bf|\<Gamma\>><rsup|-1>|)><rsup|-1>*<with|math-font-family|bf|G\<Sigma\>><text|.><no-number>>>>>>

  Using the constraints

  <\equation>
    <wide|<with|math-font-family|bf|\<Sigma\>>|~><with|math-font-family|bf|<rsub|G>>\<equiv\><math-bf|G><wide|<with|math-font-family|bf|\<Sigma\>>|~><math-bf|G><rprime|'>=<with|math-font-family|bf|G\<Sigma\>G><rprime|'>-<with|math-font-family|bf|G\<Sigma\>G><rprime|'>*<around*|(|<with|math-font-family|bf|G\<Sigma\>G><rprime|'>-<with|math-font-family|bf|\<Gamma\>><rsup|-1>|)><rsup|-1>*<with|math-font-family|bf|G\<Sigma\>G><rprime|'>
  </equation>

  or

  <\equation>
    <around*|(|<with|math-font-family|bf|G\<Sigma\>G><rprime|'>-<with|math-font-family|bf|\<Gamma\>><rsup|-1>|)><rsup|-1>=<around*|(|<with|math-font-family|bf|G\<Sigma\>G><rprime|'>|)><rsup|-1>-<around*|(|<with|math-font-family|bf|G\<Sigma\>G><rprime|'>|)><rsup|-1>*<wide|<with|math-font-family|bf|\<Sigma\>>|~><with|math-font-family|bf|<rsub|G>><around*|(|<with|math-font-family|bf|G\<Sigma\>G><rprime|'>|)><rsup|-1>
  </equation>

  Substituting this result back into <math|<around*|(|<reference|apogjpadgd>|)>>
  yields

  <\equation>
    <wide|<with|math-font-family|bf|\<Sigma\>>|~>=<with|math-font-family|bf|\<Sigma\>>+<with|math-font-family|bf|\<Sigma\>G><rprime|'>*<around*|(|<around*|(|<with|math-font-family|bf|G\<Sigma\>G><rprime|'>|)><rsup|-1>*<wide|<with|math-font-family|bf|\<Sigma\>>|~><with|math-font-family|bf|<rsub|G>><around*|(|<with|math-font-family|bf|G\<Sigma\>G><rprime|'>|)><rsup|-1>-<around*|(|<with|math-font-family|bf|G\<Sigma\>G><rprime|'>|)><rsup|-1>|)>*<with|math-font-family|bf|G\<Sigma\>><text|.>
  </equation>

  <subsection|Views as linear constraints on the
  probabilities><label|APpdgiasdpg>

  Since this change is fully defined by the reference and the posterior
  distribution of the views <math|<math-bf|V>>, to determine
  <math|<wide|<math-bf|p>|~>> we need only focus on this lower dimensional
  space instead of the whole market <math|<math-bf|X>>.

  <subsubsection|Partial information views>

  <\itemize>
    <item>Views a-la Black Litterman
  </itemize>

  The generalized BL bullish/bearish view reads

  <\equation>
    <wide|m|~><around*|{|V<rsub|k>|}>\<gtreqqless\>m<rsub|k><text|.<label|BUllwivasss>>
  </equation>

  We can define <math|m<rsub|k>> exogenously. Alternatively, as in
  <math|<around*|(|<reference|PSfadgdg>|)>> we set

  <\equation>
    m<rsub|k>\<equiv\><wide|m|^><rsub|k>+\<varkappa\>*<wide|\<sigma\>|^><rsub|k><text|,>
  </equation>

  where <math|<wide|m|^><rsub|k>> is the sample mean of the <math|k>-th
  column of the panel <math|\<cal-V\>> based on the prior probability

  <\equation>
    <wide|m|^><rsub|k>\<equiv\><big|sum><rsub|j=1><rsup|J>p<rsub|j>*\<cal-V\><rsub|j,k><text|,>
  </equation>

  and <math|<wide|\<sigma\>|^><rsub|k>> is its sample standard deviation of
  the <math|k>-th column of the panel <math|\<cal-V\>> based on the prior
  probability

  <\equation>
    <wide|\<sigma\>|^><rsub|k><rsup|2>\<equiv\><big|sum><rsub|j=1><rsup|J>p<rsub|j>*<around*|(|\<cal-V\><rsub|j,k>-<wide|m|^><rsub|k>|)><rsup|2><text|.>
  </equation>

  Alternatively, we set <math|m<rsub|k>> in
  <math|<around*|(|<reference|BUllwivasss>|)>> as the sample
  <math|<around*|(|<frac|1|2>+<frac|\<kappa\>|5>|)>>-tile of the <math|k>-th
  column of the panel <math|\<cal-V\>> based on the prior probability

  <\equation>
    m<rsub|k>\<equiv\>\<cal-V\><rsub|s<around*|(|<wide|I|\<bar\>>|)>,k><text|.<label|Sadgpog>>
  </equation>

  In this expression <math|s> is the sorting function of the <math|k>-th
  column of the panel <math|\<cal-V\>>, i.e. denoting by
  <math|\<cal-V\><rsub|i:J,k>> the <math|i>-th order statistics of the
  <math|k>-th column the function <math|s> is defined as

  <\equation>
    \<cal-V\><rsub|s<around*|(|i|)>,k>\<equiv\>\<cal-V\><rsub|i:J,k>*<text|,<space|1em>>i=1,\<ldots\>,J<text|;>
  </equation>

  and the index <math|<wide|I|\<bar\>>> satisfies

  <\equation>
    <wide|I|\<bar\>>\<equiv\><with|math-font-family|rm|\<ast\>>a*r*g*m*a*x<rsub|I>*<around*|{|<big|sum><rsub|i=1><rsup|I>p<rsub|s<around*|(|i|)>>\<leq\><around*|(|<frac|1|2>+<frac|\<kappa\>|5>|)>|}><text|.>
  </equation>

  To express <math|<around*|(|<reference|BUllwivasss>|)>> as in
  <math|<around*|(|<reference|Cliagad>|)>> we first consider the case where
  <math|<wide|m|~><around*|{|V<rsub|k>|}>> is the expectation. Then its
  sample counterpart is the sample mean and
  <math|<around*|(|<reference|BUllwivasss>|)>> reads

  <\equation>
    <big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*\<cal-V\><rsub|j,k>\<gtreqqless\>m<rsub|k><text|,>
  </equation>

  On the other hand, if <math|<wide|m|~><around*|{|V<rsub|k>|}>> in
  <math|<around*|(|<reference|BUllwivasss>|)>> is the median, then the view
  reads

  <\equation>
    <big|sum><rsub|j\<in\>I<rsub|k>><wide|p|~><rsub|j>\<gtreqqless\><frac|1|2><text|,>
  </equation>

  where <math|I<rsub|k>> denotes the indices of the scenarios in
  <math|\<cal-V\><rsub|\<cdot\>,k>> larger than <math|m<rsub|k>>.

  <\itemize>
    <item>Relative ranking
  </itemize>

  The relative ordering view

  <\equation>
    <wide|m|~><around*|{|V<rsub|1>|}>\<geq\><wide|m|~><around*|{|V<rsub|2>|}>\<geq\>\<cdots\>\<geq\><wide|m|~><around*|{|V<rsub|K>|}><text|,><label|SyoafkaRand
    copy(1)>
  </equation>

  when the location parameter is expectation translates into the following
  set of linear constraints:

  <align|<tformat|<table|<row|<cell|<big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*<around*|(|\<cal-V\><rsub|j,1>-\<cal-V\><rsub|j,2>|)>>|<cell|\<geq\>0*<no-number>>>|<row|<cell|>|<cell|\<vdots\>>>|<row|<cell|<big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*<around*|(|\<cal-V\><rsub|j,K-1>-\<cal-V\><rsub|j,K>|)>>|<cell|\<geq\>0*<text|.><no-number>>>>>>

  <\itemize>
    <item>Views on volatility
  </itemize>

  A view on volatility reads

  <\equation>
    <wide|\<sigma\>|~><around*|{|V<rsub|k>|}>\<gtreqqless\>\<sigma\><rsub|k><text|.<label|tasbVOslafs
    copy(1)>>
  </equation>

  First we consider the case where <math|<wide|\<sigma\>|~><around*|{|V<rsub|k>|}>>
  is the standard deviation. Then <math|<around*|(|<reference|tasbVOslafs
  copy(1)>|)>> can be expressed as in <math|<around*|(|<reference|Cliagad>|)>>
  as

  <\equation>
    <big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*\<cal-V\><rsub|j,k><rsup|2>\<gtreqqless\><wide|m|^><rsub|k><rsup|2>+\<sigma\><rsub|k><rsup|2><text|,>
  </equation>

  where <math|<wide|m|^><rsub|k>> is the sample mean of the <math|k>-th
  column of the panel <math|\<cal-V\>>. The benchmark
  <math|\<sigma\><rsub|k>> can be set exogenously. Alternatively, we set

  <\equation>
    \<sigma\><rsub|k>\<equiv\>\<varkappa\>*<wide|\<sigma\>|^><rsub|k><text|,>
  </equation>

  where <math|<wide|\<sigma\>|^><rsub|k>> is the sample standard deviation of
  the <math|k>-th column of the panel <math|\<cal-V\>>.

  When <math|<wide|\<sigma\>|~><around*|{|V<rsub|k>|}>> in
  <math|<around*|(|<reference|tasbVOslafs copy(1)>|)>> is the range between
  the <math|<around*|(|<frac|1|2>-\<gamma\>|)>>-tile and the
  <math|<around*|(|<frac|1|2>+\<gamma\>|)>>-tile of the distribution of
  <math|V<rsub|k>> we proceed as follows. First, compute the sample
  <math|<around*|(|<frac|1|2>-\<kappa\>*\<gamma\>|)>>-tile
  <math|<wide*|\<cal-V\>|\<bar\>><rsub|k>> of the <math|k>-th column of the
  panel <math|\<cal-V\>> as in <math|<around*|(|<reference|Sadgpog>|)>> and
  similarly the sample <math|<around*|(|<frac|1|2>+\<kappa\>*\<gamma\>|)>>-tile
  <math|<wide|\<cal-V\>|\<bar\>><rsub|k>>. Then the view reads

  <\equation>
    <big|sum><rsub|j\<in\><wide*|I|\<bar\>><rsub|k>><wide|p|~><rsub|j>\<gtreqqless\><frac|1|2>-\<gamma\>,<space|1em><big|sum><rsub|j\<in\><wide|I|\<bar\>><rsub|k>><wide|p|~><rsub|j>\<gtreqqless\><frac|1|2>-\<gamma\><text|.>
  </equation>

  where <math|<wide*|I|\<bar\>><rsub|k>> denotes the scenarios in the
  <math|k>-th column of <math|\<cal-V\>> that are smaller than
  <math|<wide*|\<cal-V\>|\<bar\>><rsub|k>> and
  <math|<wide*|I|\<bar\>><rsub|k>> denotes the scenarios that are larger than
  <math|<wide|\<cal-V\>|\<bar\>><rsub|k>>.

  <\itemize>
    <item>Views on correlations
  </itemize>

  To stress test the correlations with a pre-defined matrix such as
  <math|<around*|(|<reference|COtdefs>|)>> we impose

  <\equation>
    <big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*\<cal-V\><rsub|j,k>*\<cal-V\><rsub|j,l>\<equiv\><wide|m|^><rsub|k>*<wide|m|^><rsub|l>+<wide|\<sigma\>|^><rsub|k>*<wide|\<sigma\>|^><rsub|l>*<wide|\<bbb-C\>|~><rsub|k,l><text|,>
  </equation>

  where <math|<wide|m|^><rsub|k>> is the sample mean and
  <math|<wide|\<sigma\>|^><rsub|k>> is the sample standard deviation of the
  <math|k>-th column of the panel <math|\<cal-V\>> .

  <\itemize>
    <item>Views on tail codependence
  </itemize>

  First we extract the empirical copula from the panel <math|\<cal-V\>> as in
  <cite|Meucci06b>: we sort the columns of <math|\<cal-V\>> in ascending
  order; then we define a panel <math|\<cal-U\>>, whose generic
  <math|<around*|(|j,k|)>>-th entry is the normalized ranking of
  <math|\<cal-V\><rsub|j,k>> within the <math|k>-th column (for instance, if
  <math|\<cal-V\><rsub|5,7>> is the 423-th smallest simulation in column
  <math|7>, then <math|\<cal-U\><rsub|5,7>\<equiv\>423/J>). Each row of
  <math|\<cal-U\>> represents a simulation from the copula of
  <math|f<rsub|<math-bf|V>>>.

  Stress-testing the tail codependence means

  <\equation>
    <wide|C|~><rsub|<math-bf|V>><around*|(|<math-bf|u>|)>\<gtreqqless\><wide|C|~><text|,<label|GTIsalzidgd
    copy(2)>>
  </equation>

  where <math|<wide|C|~>> can be set exogenously. This translates into

  <\equation>
    <big|sum><rsub|j\<in\>I<rsub|<math-bf|u>>><wide|p|~><rsub|j>\<gtreqqless\><wide|C|~><text|,>
  </equation>

  where <math|I<rsub|<math-bf|u>>> denotes the scenarios in <math|\<cal-U\>>
  that lie jointly below <math|<math-bf|u>>. To better tweak
  <math|<wide|C|~>> a convenient formulation is as the sample counterpart of
  <math|\<varkappa\>*C<rsub|<math-bf|V>><around*|(|<math-bf|u>|)>>, for a
  reference copula <math|C<rsub|<math-bf|V>>> computed as above.

  <subsubsection|Full-information views>

  <\itemize>
    <item>Views on copula
  </itemize>

  If a full copula is specified, we draw a <math|J\<times\>K> panel of
  simulations <math|<wide|\<cal-U\>|~>> from it. To do so, we can fit to
  <math|\<cal-U\>> a parametric copula <math|<math-bf|U><rsub|<with|math-font-family|bf|\<theta\>>>>
  that depends on a set of parameters <math|<with|math-font-family|bf|\<theta\>>>;
  then <math|<wide|\<cal-U\>|~>> is obtained by drawing from the copula
  <math|<math-bf|U><rsub|<wide|<with|math-font-family|bf|\<theta\>>|~>>>,
  where <math|<wide|<with|math-font-family|bf|\<theta\>>|~>> is a
  perturbation of estimated parameters <math|<with|math-font-family|bf|\<theta\>>>.

  Then <math|<wide|<math-bf|p>|~>> is determined by matching all the cross
  moments

  <align|<tformat|<table|<row|<cell|<big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*\<cal-U\><rsub|j,k>*\<cal-U\><rsub|j,l>>|<cell|=<big|sum><rsub|j=1><rsup|J>p<rsub|j>*<wide|\<cal-U\>|~><rsub|j,k>*<wide|\<cal-U\>|~><rsub|j,l>,<space|1em>k\<gtr\>l=1,\<ldots\>,K>>|<row|<cell|<big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*\<cal-U\><rsub|j,k>*\<cal-U\><rsub|j,l>*\<cal-U\><rsub|j,i>>|<cell|=<big|sum><rsub|j=1><rsup|J>p<rsub|j>*<wide|\<cal-U\>|~><rsub|j,k>*<wide|\<cal-U\>|~><rsub|j,l>*<wide|\<cal-U\>|~><rsub|j,i>,<space|1em>k\<gtr\>l\<gtr\>i=1,\<ldots\>,K>>|<row|<cell|>|<cell|\<vdots\><no-number>>>>>>

  and as well as all the marginal moments of the uniform distribution

  <align|<tformat|<table|<row|<cell|<big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*\<cal-U\><rsub|j,k>>|<cell|=<frac|1|2>>>|<row|<cell|<big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*\<cal-U\><rsub|j,k><rsup|2>>|<cell|=<frac|1|3>>>|<row|<cell|>|<cell|\<vdots\><no-number>>>>>>

  up to a given order.

  <\itemize>
    <item>Views on marginal distributions
  </itemize>

  If a full marginal distribution for the <math|k>-th view is specified, we
  draw a <math|J\<times\>1> vector of simulations
  <math|<wide|\<cal-V\>|~><rsub|\<cdot\>,k>> from it. Then
  <math|<wide|<math-bf|p>|~>> is determined by matching all the moments up to
  a given order:

  <align|<tformat|<table|<row|<cell|<big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*\<cal-V\><rsub|j,k>>|<cell|=<big|sum><rsub|j=1><rsup|J>p<rsub|j>*<wide|\<cal-V\>|~><rsub|j,k>,>>|<row|<cell|<big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j><around*|(|\<cal-V\><rsub|j,k>|)><rsup|2>>|<cell|=<big|sum><rsub|j=1><rsup|J>p<rsub|j><around*|(|<wide|\<cal-V\>|~><rsub|j,k>|)><rsup|2>>>|<row|<cell|<big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j><around*|(|\<cal-V\><rsub|j,k>|)><rsup|3>>|<cell|=<big|sum><rsub|j=1><rsup|J>p<rsub|j><around*|(|<wide|\<cal-V\>|~><rsub|j,k>|)><rsup|3>>>|<row|<cell|>|<cell|\<vdots\><no-number>>>>>>

  <\itemize>
    <item>Views on joint distribution
  </itemize>

  If a full joint view distribution <math|<around*|(|<reference|MAfa
  copy(1)>|)>> is specified, we draw a <math|J\<times\>K> panel of
  simulations <math|<wide|\<cal-V\>|~>> from it. This can be done in one
  shot, or by paring a desired copula with desired marginals as in
  <cite|Meucci06b>. Then <math|<wide|<math-bf|p>|~>> is determined by
  matching all the cross moments up to a given order:

  <align|<tformat|<table|<row|<cell|<big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*\<cal-V\><rsub|j,k>>|<cell|=<big|sum><rsub|j=1><rsup|J>p<rsub|j>*<wide|\<cal-V\>|~><rsub|j,k>,<space|1em>k=1,\<ldots\>,K>>|<row|<cell|<big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*\<cal-V\><rsub|j,k>*\<cal-V\><rsub|j,l>>|<cell|=<big|sum><rsub|j=1><rsup|J>p<rsub|j>*<wide|\<cal-V\>|~><rsub|j,k>*<wide|\<cal-V\>|~><rsub|j,l>,<space|1em>k\<geq\>l=1,\<ldots\>,K>>|<row|<cell|<big|sum><rsub|j=1><rsup|J><wide|p|~><rsub|j>*\<cal-V\><rsub|j,k>*\<cal-V\><rsub|j,l>,\<cal-V\><rsub|j,i>>|<cell|=<big|sum><rsub|j=1><rsup|J>p<rsub|j>*<wide|\<cal-V\>|~><rsub|j,k>*<wide|\<cal-V\>|~><rsub|j,l>*<wide|\<cal-V\>|~><rsub|j,i>,<space|1em>k\<geq\>l\<geq\>i=1,\<ldots\>,K>>|<row|<cell|>|<cell|\<vdots\><no-number>>>>>>

  <subsection|Numerical entropy minimization><label|AppSovEBter>

  The entropy minimization problem <math|<around*|(|<reference|acsggad>|)>>
  reads explicitly

  <\equation>
    <wide|<math-bf|p>|~>\<equiv\><with|math-font-family|rm|\<ast\>>a*r*g*m*i*n<rsub|<stack|<tformat|<table|<row|<cell|<math-bf|Fx>\<leq\><math-bf|f>>>|<row|<cell|<math-bf|Hx>\<equiv\><math-bf|h>>>>>>><around*|{|<big|sum><rsub|j=1><rsup|J>x<rsub|j>*<around*|(|ln
    <around*|(|x<rsub|j>|)>-ln <around*|(|p<rsub|j>|)>|)>|}><text|,<label|acsggad
    copy(1)>>
  </equation>

  where we have collected all the inequality constraints in the matrix-vector
  pair <math|<around*|(|<math-bf|F>,<math-bf|f>|)>>, all the equality
  constraints in the matrix-vector pair <math|<around*|(|<math-bf|H>,<math-bf|h>|)>>
  and where we do not include the extra-constraint

  <\equation>
    <math-bf|x>\<geq\><with|math-font-family|bf|0><label|VCPsinsdbf>
  </equation>

  because it will be automatically satisfied.

  The Lagrangian for <math|<around*|(|<reference|acsggad copy(1)>|)>> reads

  <\equation>
    \<cal-L\><around*|(|<math-bf|x>,<with|math-font-family|bf|\<lambda\>>,<with|math-font-family|bf|\<nu\>>|)>\<equiv\><math-bf|x><rprime|'><around*|(|ln
    <around*|(|<math-bf|x>|)>-ln <around*|(|<math-bf|p>|)>|)>+<with|math-font-family|bf|\<lambda\>><rprime|'>*<around*|(|<math-bf|Fx>-<math-bf|f>|)>+<with|math-font-family|bf|\<nu\>><rprime|'>*<around*|(|<math-bf|Hx>-<math-bf|h>|)><text|.>
  </equation>

  The first order conditions for <math|<math-bf|x>> read

  <\equation>
    <with|math-font-family|bf|0>\<equiv\><frac|\<partial\>*\<cal-L\>|\<partial\><math-bf|x>>=ln
    <around*|(|<math-bf|x>|)>-ln <around*|(|<math-bf|p>|)>+<with|math-font-family|bf|1>+<math-bf|F><rprime|'><with|math-font-family|bf|\<lambda\>>+<math-bf|H><rprime|'><with|math-font-family|bf|\<nu\>><text|.>
  </equation>

  The solution is

  <\equation>
    <math-bf|x><around*|(|<with|math-font-family|bf|\<lambda\>>,<with|math-font-family|bf|\<nu\>>|)>=e<rsup|ln
    <around*|(|<math-bf|p>|)>-<with|math-font-family|bf|1>-<math-bf|F><rprime|'><with|math-font-family|bf|\<lambda\>>-<math-bf|H><rprime|'><with|math-font-family|bf|\<nu\>>><text|.>
  </equation>

  Notice that the solution is always positive, which justifies not
  considering <math|<around*|(|<reference|VCPsinsdbf>|)>>.

  The Lagrange dual function is defined as

  <\equation>
    \<cal-G\><around*|(|<with|math-font-family|bf|\<lambda\>>,<with|math-font-family|bf|\<nu\>>|)>\<equiv\>\<cal-L\><around*|(|<math-bf|x><around*|(|<with|math-font-family|bf|\<lambda\>>,<with|math-font-family|bf|\<nu\>>|)>,<with|math-font-family|bf|\<lambda\>>,<with|math-font-family|bf|\<nu\>>|)><text|.>
  </equation>

  This function can be computed explicitly. The optimal Lagrange multipliers
  follow from the numerical maximization of the Lagrange dual function

  <\equation>
    <around*|(|<with|math-font-family|bf|\<lambda\>><rsup|\<ast\>>,<with|math-font-family|bf|\<nu\>><rsup|\<ast\>>|)>\<equiv\><with|math-font-family|rm|\<ast\>>a*r*g*m*a*x<rsub|<with|math-font-family|bf|\<lambda\>>\<geq\><with|math-font-family|bf|0>,<with|math-font-family|bf|\<nu\>>><around*|{|\<cal-G\><around*|(|<with|math-font-family|bf|\<lambda\>>,<with|math-font-family|bf|\<nu\>>|)>|}><text|.><label|NUmSOPgagds>
  </equation>

  Notice that, whereas the Lagrangian should be minimized, the dual
  Lagrangian must be maximized. Also notice that both gradient and Hessian
  can be easily computed (the former from the envelope theorem) in order to
  speed up the efficiency of the algorithm.

  Finally, the solution to the original problem
  <math|<around*|(|<reference|acsggad copy(1)>|)>> reads

  <\equation>
    <wide|<math-bf|p>|~>=<math-bf|x><around*|(|<with|math-font-family|bf|\<lambda\>><rsup|\<ast\>>,<with|math-font-family|bf|\<nu\>><rsup|\<ast\>>|)><text|.>
  </equation>

  The numerical optimization <math|<around*|(|<reference|NUmSOPgagds>|)>>
  acts on a very limited number of variables, equal to the number of views.
  It does not act directly on the very large number of variables of interest,
  namely the probabilities of the Monte Carlo scenarios: this feature
  guarantees the numerical feasibility of entropy optimization.

  <subsection|Confidence specification><label|AppPRvab>

  We consider five increasingly complex cases. First, there is only one user
  with equal confidence in all his views. Second, there is only one user, but
  each view can potentially have a different confidence. Third, there are
  multiple users, where each user has equal confidence in their own views.
  Fourth, there are multiple users, but each view of each user can
  potentially have a different confidence. Fifth, we propose a general
  framework to accommodate all possible specifications.

  <subsubsection|One user, equal confidence in all views>

  This is the case considered in the pooling expression
  <math|<around*|(|<reference|Sateg>|)>>. The confidence <math|c> can be
  interpreted as the subjective probability that the views be correct,
  instead of the reference market model. Indeed, consider the mixture market

  <\equation>
    <wide|<math-bf|X>|^><above|=|d><around*|(|1-B|)><math-bf|X>+B<wide|<math-bf|X>|~><text|,<label|PRoabvas>>
  </equation>

  where <math|<math-bf|X>> is distributed according to the reference model
  <math|<around*|(|<reference|MAara>|)>> and <math|<wide|<math-bf|X>|~>>
  according to the regime shift <math|<around*|(|<reference|FUlagsgas>|)>>
  implied by the views. If <math|B> is a <math|0>-<math|1> Bernoulli variable
  that decides between the two regimes with probabilities <math|1-c> and
  <math|c> respectively, the pdf of <math|<wide|<math-bf|X>|^>> is exactly
  <math|<around*|(|<reference|Sateg>|)>>.

  Alternatively, we can represent the Bernoulli variable in
  <math|<around*|(|<reference|PRoabvas>|)>> as follows:

  <\equation>
    <wide|<math-bf|X>|^><above|=|d>I<rsub|1-c><around*|(|U|)><math-bf|X>+I<rsub|c><around*|(|U|)><wide|<math-bf|X>|~><text|,<label|PRoabvas
    copy(3)>>
  </equation>

  where <math|U> is a uniform random variable; and <math|I<rsub|c>> and
  <math|I<rsub|1-c>> are indicator functions of non-overlapping intervals of
  size <math|c> and <math|1-c>.

  <subsubsection|One user, views with different confidences>

  Consider the case where different views have different confidence levels.
  Each view is a statement such as <math|<around*|(|<reference|BUllwivas>|)>>-<math|<around*|(|<reference|GTIsalzidgd>|)>>.

  We illustrate this situation with an example

  <\equation>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<table|<row|<cell|i*n*d*e*x>|<cell|v*i*e*w>|<cell|c*o*n*f*i*d*e*n*c*e>>|<row|<cell|1>|<cell|<wide|m|~><around*|{|V<rsub|1>|}>\<geq\><wide|m|~><around*|{|V<rsub|2>|}>>|<cell|10%>>|<row|<cell|2>|<cell|<wide|m|~><around*|{|V<rsub|2>|}>\<geq\><wide|m|~><around*|{|V<rsub|3>|}>>|<cell|30%>>>>>
  </equation>

  One could model this situation in a way similar to
  <math|<around*|(|<reference|PRoabvas>|)>>: in <math|10%> of the cases only
  the first view is satisfied and in <math|30%> of the cases only the second
  view satisfied. However, this is not correct. Instead, in <math|10%> of the
  cases both views are satisfied and in <math|20%> of the cases only the
  second view is satisfied.

  In other words, we are assigning probabilities to the subsets of views
  combinations as follows:

  <\equation>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<table|<row|<cell|s*u*b*s*e*t>|<cell|c*o*n*f*i*d*e*n*c*e>>|<row|<cell|<around*|{|1,2|}>>|<cell|c<rsub|<around*|{|1,2|}>>\<equiv\>10%>>|<row|<cell|<around*|{|1|}>>|<cell|c<rsub|<around*|{|1|}>>\<equiv\>0%>>|<row|<cell|<around*|{|2|}>>|<cell|c<rsub|<around*|{|2|}>>\<equiv\>20%>>|<row|<cell|\<varnothing\>>|<cell|c<rsub|\<varnothing\>>\<equiv\>70%>>>>><label|tqsabsaas>
  </equation>

  Then, the posterior reads

  <\equation>
    <wide|<math-bf|X>|~><above|=|d>I<rsub|c<rsub|\<varnothing\>>><around*|(|U|)><wide|<math-bf|X>|~><rsub|\<varnothing\>>+I<rsub|c<rsub|<around*|{|1|}>>><around*|(|U|)><wide|<math-bf|X>|~><rsub|<around*|{|1|}>>+I<rsub|c<rsub|<around*|{|2|}>>><around*|(|U|)><wide|<math-bf|X>|~><rsub|<around*|{|2|}>>+I<rsub|c<rsub|<around*|{|1,2|}>>><around*|(|U|)><wide|<math-bf|X>|~><rsub|<around*|{|1,2|}>><text|.<label|PRoabvas
    copy(1)>>
  </equation>

  In this expression <math|<wide|<math-bf|X>|~><rsub|\<varnothing\>>> is a
  random variable distributed according to the reference model
  <math|<around*|(|<reference|MAara>|)>>;
  <math|<wide|<math-bf|X>|~><rsub|<around*|{|1|}>>> is an independent random
  variable, distributed according to the posterior with only the first view,
  whose pdf, which follows from <math|<around*|(|<reference|FLSKnadd
  copy(1)>|)>>, we denote by <math|<wide|f|~><rsub|<around*|{|1|}>>>;
  similarly for <math|<wide|<math-bf|X>|~><rsub|<around*|{|2|}>>>;
  <math|<wide|<math-bf|X>|~><rsub|<around*|{|1,2|}>>> is an independent
  random variable, distributed according to the posterior from both views,
  whose pdf we denote by <math|<wide|f|~><rsub|<around*|{|1,2|}>>>; <math|U>
  is a uniform random variable; and the <math|I<rsub|c>>'s are indicators
  functions of the on non-overlapping intervals with size <math|c> as in
  Table <reference|tqsabsaas>: in particular
  <math|I<rsub|c<rsub|<around*|{|1|}>>><around*|(|U|)>> is always zero. Then
  the pdf of <math|<around*|(|<reference|PRoabvas copy(1)>|)>> reads

  <\equation>
    <wide|f|~><rsub|<math-bf|X>>=c<rsub|\<varnothing\>>*f<rsub|<math-bf|X>>+c<rsub|<around*|{|1|}>>*<wide|f|~><rsub|<around*|{|1|}>>+c<rsub|<around*|{|2|}>>*<wide|f|~><rsub|<around*|{|2|}>>+c<rsub|<around*|{|1,2|}>>*<wide|f|~><rsub|<around*|{|1,2|}>><text|.<label|PRoabvas
    copy(4)>>
  </equation>

  In general, we start from a set of <math|L> views with <math|L> potentially
  different confidences

  <\equation>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<table|<row|<cell|i*n*d*e*x>|<cell|v*i*e*w>|<cell|c*o*n*f*i*d*e*n*c*e>>|<row|<cell|1>|<cell|\<ldots\>>|<cell|c<rsub|1>>>|<row|<cell|2>|<cell|\<ldots\>>|<cell|c<rsub|2>>>|<row|<cell|\<vdots\>>|<cell|\<vdots\>>|<cell|\<vdots\>>>|<row|<cell|L>|<cell|\<ldots\>>|<cell|c<rsub|L>>>>>>
  </equation>

  From this, we obtain a probability <math|c<rsub|A>> for each subset
  <math|A> of <math|<around*|{|1,2,\<ldots\>,L|}>> as follows:

  <align|<tformat|<table|<row|<cell|<around*|{|1,2,\<ldots\>,L|}>>|<cell|\<mapsto\>c<rsub|<around*|{|1,2,\<ldots\>*L|}>>\<equiv\>min
  <around*|(|c<rsub|l>\|l\<in\><around*|{|1,2,\<ldots\>,L|}>|)><no-number>>>|<row|<cell|<around*|{|1,2,\<ldots\>,L-1|}>>|<cell|\<mapsto\>c<rsub|<around*|{|1,2,\<ldots\>,L-1|}>>\<equiv\>min
  <around*|(|c<rsub|l>\|l\<in\><around*|{|1,2,\<ldots\>,L-1|}>|)><no-number>>>|<row|<cell|>|<cell|-c<rsub|<around*|{|1,2,\<ldots\>*L|}>>*<no-number>>>|<row|<cell|>|<cell|\<vdots\><label|Cspafjsgf>>>|<row|<cell|<around*|{|2,\<ldots\>,L|}>>|<cell|\<mapsto\>c<rsub|<around*|{|2,\<ldots\>,L|}>>\<equiv\>min
  <around*|(|c<rsub|l>\|l\<in\><around*|{|2,\<ldots\>,L|}>|)>-c<rsub|<around*|{|1,2,\<ldots\>*L|}>>*<no-number>>>|<row|<cell|<around*|{|1,2,\<ldots\>,L-2|}>>|<cell|\<mapsto\>c<rsub|<around*|{|1,2,\<ldots\>,L-2|}>>\<equiv\>min
  <around*|(|c<rsub|l>\|l\<in\><around*|{|1,2,\<ldots\>,L-2|}>|)><no-number>>>|<row|<cell|>|<cell|-c<rsub|<around*|{|1,2,\<ldots\>,L-1|}>>-c<rsub|<around*|{|1,2,\<ldots\>*L|}>>*<no-number>>>|<row|<cell|>|<cell|\<vdots\><no-number>>>|<row|<cell|\<varnothing\>>|<cell|\<mapsto\>c<rsub|\<varnothing\>>\<equiv\>1-<big|sum><rsub|l=1><rsup|L>c<rsub|l>*<no-number>>>>>>

  The set of subsets is known as the "power set" and is denoted
  <math|2<rsup|<around*|{|1,\<ldots\>,L|}>>>. Therefore, the views and their
  confidences are mapped into a probability on the power set of the views.

  The posterior is defined in distribution as follows

  <\equation>
    <wide|<math-bf|X>|~><above|=|d><big|sum><rsub|A\<in\>2<rsup|<around*|{|1,\<ldots\>,L|}>>>I<rsub|c<rsub|A>><around*|(|U|)><wide|<math-bf|X>|~><rsub|A><text|,<label|PRoabvas
    copy(6)>>
  </equation>

  where <math|U> is a uniform random variable; the <math|I<rsub|c>>'s are
  indicators functions of the on non-overlapping intervals with size
  <math|c<rsub|A>> as in <math|<around*|(|<reference|Cspafjsgf>|)>>; the
  <math|<wide|<math-bf|X>|~><rsub|A>>'s are independent random variables,
  distributed according to the posterior with only the views in the set
  <math|A>, whose pdf we denote by <math|<wide|f|~><rsub|A>>.

  The pdf of the posterior <math|<around*|(|<reference|PRoabvas copy(6)>|)>>
  then reads

  <\equation>
    <wide|f|~><rsub|<math-bf|X>>=<big|sum><rsub|A\<in\>2<rsup|<around*|{|1,\<ldots\>,L|}>>>c<rsub|A>*<wide|f|~><rsub|A><text|.<label|PRoabvas
    copy(7)>>
  </equation>

  Notice that in practice the vast majority of the potentially
  <math|2<rsup|L>> subsets will have null probability <math|c<rsub|A>> and
  therefore those terms will not appear in
  <math|<around*|(|<reference|PRoabvas copy(6)>|)>> or
  <math|<around*|(|<reference|PRoabvas copy(7)>|)>>.

  <subsubsection|Multiple users, equal confidence levels in their views>

  This is the case considered in the pooling expression
  <math|<around*|(|<reference|Mulaigte>|)>>, which we report here

  <\equation>
    <wide|f|~><rsub|<math-bf|X>><rsup|<math-bf|c>>\<equiv\><big|sum><rsub|s=0><rsup|S><wide|c|~><rsub|s>*<wide|f|~><rsub|<math-bf|X>><rsup|<around*|(|s|)>><text|.<label|Mulaigte
    copy(1)>>
  </equation>

  <subsubsection|Multiple users, different confidence levels in their
  views><label|SecMsiaog>

  More in general, consider <math|S> users. The generic <math|s>-th user has
  <math|L<rsub|s>> views with potentially different relative confidences,
  modeled as in <math|<around*|(|<reference|PRoabvas copy(7)>|)>>. On the
  other hand, each user has been given an overall confidence level as in
  <math|<around*|(|<reference|Mulaigte copy(1)>|)>>. The pdf of the posterior
  follows from integrating the bottom-up approach
  <math|<around*|(|<reference|PRoabvas copy(7)>|)>> and the top-down approach
  <math|<around*|(|<reference|Mulaigte copy(1)>|)>> as follows:

  <\equation>
    <wide|f|~><rsub|<math-bf|X>>=<big|sum><rsub|s=0><rsup|S><wide|c|~><rsub|s>*<big|sum><rsub|A<rsub|s>\<in\>2<rsup|<around*|{|1,\<ldots\>,L<rsub|s>|}>>>c<rsub|A<rsub|s>>*<wide|f|~><rsub|A<rsub|s>><text|.<label|PRoabvas
    copy(10)>>
  </equation>

  We remark that in practice the vast majority of the potentially large
  number of the terms <math|c<rsub|A<rsub|s>>> in
  <math|<around*|(|<reference|PRoabvas copy(10)>|)>> is null. Also this model
  can be embedded in the framework of a probability on the power set of the
  views, as in <math|<around*|(|<reference|PRoabvas
  copy(6)>|)>>-<math|<around*|(|<reference|PRoabvas copy(7)>|)>>, see
  Appendix <reference|AppGeapfBdvdfio>.

  <subsubsection|General case><label|AppGeapfBdvdfio>

  We can interpret the multi-user, multi-confidence framework as a set of
  <math|L\<equiv\>L<rsub|1>+\<cdots\>*L<rsub|S>> views with confidences
  defined as the product of the overall confidence in the user times the
  relative confidence of the user in his different views.

  <\equation>
    <array|c|c|<text|user >1<text|:><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<table|<row|<cell|i*n*d*e*x>|<cell|v*i*e*w>|<cell|c*o*n*f.>>|<row|<cell|<math|<around*|(|1,1|)>>>|<cell|<math|\<ldots\>>>|<cell|<math|c<rsub|1,1>>>>|<row|<cell|<math|<around*|(|1,2|)>>>|<cell|<math|\<ldots\>>>|<cell|<math|c<rsub|1,2>>>>|<row|<cell|<math|\<vdots\>>>|<cell|<math|\<vdots\>>>|<cell|<math|\<vdots\>>>>|<row|<cell|<math|<around*|(|1,L<rsub|1>|)>>>|<cell|<math|\<ldots\>>>|<cell|<math|c<rsub|1,L<rsub|1>>>>>>>>|\<nobracket\>><next-line>\<vdots\><label|Vasasgfrtgt><next-line><text|user
    >S<text|:><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<table|<row|<cell|index>|<cell|view>|<cell|conf.>>|<row|<cell|<math|<around*|(|S,1|)>>>|<cell|<math|\<ldots\>>>|<cell|<math|c<rsub|S,1>>>>|<row|<cell|<math|<around*|(|S,2|)>>>|<cell|<math|\<ldots\>>>|<cell|<math|c<rsub|S,2>>>>|<row|<cell|<math|\<vdots\>>>|<cell|<math|\<vdots\>>>|<cell|<math|\<vdots\>>>>|<row|<cell|<math|<around*|(|S,L<rsub|S>|)>>>|<cell|<math|\<ldots\>>>|<cell|<math|c<rsub|S,L<rsub|S>>>>>>>>|\<nobracket\>>>
  </equation>

  Consider the power set

  <\equation>
    \<cal-A\>\<equiv\>2<rsup|<around*|{|<around*|(|1,1|)>,\<ldots\>,<around*|(|S,L<rsub|S>|)>|}>><text|.>
  </equation>

  The sum in <math|<around*|(|<reference|PRoabvas copy(10)>|)>> can be
  expressed as

  <\equation>
    <wide|f|~><rsub|<math-bf|X>>=<big|sum><rsub|A\<in\>\<cal-A\>>c<rsub|A>*<wide|f|~><rsub|A><text|,<label|PRoabvas
    copy(2)>>
  </equation>

  where the coefficients <math|c<rsub|A>> are determined by the integration
  of the bottom-up approach <math|<around*|(|<reference|PRoabvas copy(7)>|)>>
  and the top-down approach <math|<around*|(|<reference|Mulaigte
  copy(1)>|)>>: due to this integration only very few among all the possible
  elements <math|A\<in\>\<cal-A\>> have a non-null coefficient
  <math|c<rsub|A>>.

  However, there are many choices of the <math|c<rsub|A>>'s consistent with
  <math|<around*|(|<reference|Vasasgfrtgt>|)>>. According to any such choice,
  the posterior is expressed in distribution as

  <\equation>
    <wide|<math-bf|X>|~><above|=|d><big|sum><rsub|A\<in\>\<cal-A\>>I<rsub|c<rsub|A>><around*|(|U|)><wide|<math-bf|X>|~><rsub|A><text|,<label|PRoabvas
    copy(8)>>
  </equation>

  where the same notation as <math|<around*|(|<reference|PRoabvas
  copy(6)>|)>> applies, and the pdf reads

  <\equation>
    <wide|f|~><rsub|<math-bf|X>>=<big|sum><rsub|A\<in\>\<cal-A\>>c<rsub|A>*<wide|f|~><rsub|A><text|.<label|PRoabvas
    copy(9)>>
  </equation>
</body>