<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <\hide-preamble>
    <assign|be|<macro|>>

    <assign|ee|<macro|>>

    <assign|bra|<macro|\<langle\>>>

    <assign|ket|<macro|\<rangle\>>>

    <assign|bea|<macro|>>

    <assign|eea|<macro|>>

    <assign|dis|<macro|>>
  </hide-preamble>

  <doc-data|<doc-title|*>|<doc-author|<author-data|<author-name|Tetsuya
  Takaishi>>>|<doc-date|<date|>>>

  <\abstract>
    A Bayesian estimation of a GARCH model is performed for US
    Dollar/Japanese Yen exchange rate by the Metropolis-Hastings algorithm
    with a proposal density given by the adaptive construction scheme. In the
    adaptive construction scheme the proposal density is assumed to take a
    form of a multivariate Student's t-distribution and its parameters are
    evaluated by using the sampled data and updated adaptively during Markov
    Chain Monte Carlo simulations. We find that the autocorrelation times
    between the data sampled by the adaptive construction scheme are
    considerably reduced. We conclude that the adaptive construction scheme
    works efficiently for the Bayesian inference of the GARCH model.\ 
  </abstract>

  Bayesian estimation of GARCH model with an adaptive proposal density

  <section|Introduction>

  In finance volatility of asset returns plays an important role to manage
  financial risk. To forecast volatility, various empirical models which
  mimic the properties of the volatility have been proposed. Engle<cite|ARCH>
  proposed Autoregressive Conditional Heteroskedasticity (ARCH) model where
  the present volatility is assumed to depend on the squares of past
  observations. Later Bollerslev<cite|GARCH> advocated Generalized ARCH
  (GARCH) model which is an extension of the ARCH model and includes
  additional past volatility terms to the present volatility estimate. It is
  known that the volatility of the financial assets exhibits clustering in
  the financial time series. The GARCH model can captures this property.
  Furthermore the return distribution generated from the GARCH process shows
  a fat-tailed distribution which is also seen in the real financial markets.
  There also exists extension of the GARCH model which incorporates the
  asymmetric property of the volatility<cite|EGARCH|GJR|APGARCH|QGARCH>.

  A preferred algorithm to infer GARCH model parameters is the Maximum
  Likelihood (ML) method which estimates the parameters by maximaizing the
  corresponding likelihood function of the GARCH model. In this algorithm
  there is a practical difficulty in the maximization procedure when the
  output results are sensitive to starting values.

  By the recent computer development the Bayesian inference by Markov chain
  Monte Carlo (MCMC) methods, which is an alternative approach to estimate
  GARCH parameters, has become popular. There exist a variety of methods
  proposed to implement the MCMC scheme<cite|Bauwens>-<cite|HMC>. In a recent
  survey<cite|ASAI> it is shown that Acceptance-Rejection/Metropolis-Hastings
  (AR/MH) algorithm works better than other algorithms. In the AR/MH
  algorithm the proposal density is assumed to be a multivariate Student's
  t-distribution and the parameters to specify the distribution are estimated
  by the ML technique. Recently a new method to estimate those parameters
  without relying on the ML technique was proposed<cite|ACS>. In the method
  the parameters are determined by an MCMC simulation. During the MCMC
  simulation, the parameters are updated adaptively using the data sampled by
  the MCMC method itself. We call this method "adaptive construction scheme".
  The adaptive construction scheme was tested for artificial GARCH data and
  it is shown that the adaptive construction scheme can significantly reduce
  the correlation between sampled data<cite|ACS>. In this study we apply the
  adaptive construction scheme to real financial data, US Dollar/Japanese Yen
  exchange rate and examine the efficiency of the adaptive construction
  scheme.

  <section|GARCH Model>

  The GARCH(p,q) model by Bollerslev<cite|GARCH> is given by

  <\equation>
    y<rsub|t>=\<sigma\><rsub|t>*\<epsilon\><rsub|t>,
  </equation>

  <\equation>
    \<sigma\><rsub|t><rsup|2>=\<omega\>+<big|sum><rsub|i=1><rsup|q>\<alpha\><rsub|i>*y<rsub|t-i><rsup|2>+<big|sum><rsub|i=1><rsup|p>\<beta\><rsub|i>*\<sigma\><rsub|t-i><rsup|2>,
  </equation>

  where the GARCH parameters are restricted to <math|\<omega\>\<gtr\>0>,
  <math|\<alpha\><rsub|i>\<gtr\>0> and <math|\<beta\><rsub|i>\<gtr\>0> to
  ensure a positive volatility, and the stationary condition
  <math|<big|sum><rsub|i=1><rsup|q>\<alpha\><rsub|i>+<big|sum><rsub|i=1><rsup|p>\<beta\><rsub|i>\<less\>1>
  is also required. <math|\<epsilon\><rsub|t>> is an independent normal error
  <math|\<sim\>N<around|(|0,1|)>>.

  In this study we focus on GARCH(1,1) model where the volatility
  <math|\<sigma\><rsub|t><rsup|2>> is given by

  <\equation>
    \<sigma\><rsub|t><rsup|2>=\<omega\>+\<alpha\>*y<rsub|t-1><rsup|2>+\<beta\>*\<sigma\><rsub|t-1><rsup|2>.
  </equation>

  The likelihood function of the GARCH model is given by

  <\equation>
    <around*|\<nobracket\>|L<around|(|y\|\<theta\>|)>=\<Pi\><rsub|i=1><rsup|n>*<frac|1|<sqrt|2*\<pi\>*\<sigma\><rsub|t><rsup|2>>>*exp
    <around*|\<nobracket\>||(>-<frac|y<rsub|t><rsup|2>|\<sigma\><rsub|t><rsup|2>>|\<nobracket\>>).
  </equation>

  <section|Bayesian inference>

  Using Bayes' rule the posterior density
  <math|\<pi\><around|(|\<theta\>\|y|)>> with <math|n> observations denoted
  by <math|y=<around|(|y<rsub|1>,y<rsub|2>,\<ldots\>,y<rsub|n>|)>> is given
  by

  <\equation>
    \<pi\><around|(|\<theta\>\|y|)>\<propto\>L<around|(|y\|\<theta\>|)>*\<pi\><around|(|\<theta\>|)>,
  </equation>

  where <math|L<around|(|y\|\<theta\>|)>> is the likelihood function.
  <math|\<pi\><around|(|\<theta\>|)>> is the prior density which we have to
  specify depending on <math|\<theta\>>. In this study we assume that the
  prior density <math|\<pi\><around|(|\<theta\>|)>> is constant.

  With <math|\<pi\><around|(|\<theta\>\|y|)>> we infer <math|\<theta\>> as
  expectation values of <math|\<theta\>>. The expectation values are given by

  <\equation>
    <bra><with|font-series|bold|\<theta\>><ket>=<frac|1|Z>*<big|int><with|font-series|bold|\<theta\>>*\<pi\><around|(|\<theta\>\|y|)>*d*\<theta\>,<label|eq:int>
  </equation>

  where <math|Z=<big|int>\<pi\><around|(|\<theta\>\|y|)>*d*\<theta\>> is the
  normalization constant. Hereafter we omit <math|Z> since this factor is
  irrelevant to MCMC estimations.

  The MCMC technique gives a method to estimate eq.(<reference|eq:int>)
  numerically. The basic procedure of the MCMC method is as follows. First we
  sample <math|\<theta\>> drawn from a probability distribution
  <math|\<pi\><around|(|\<theta\>\|y|)>>. Sampling is done by a technique
  which produces a Markov chain. After sampling some data, we evaluate the
  expectation value as an average value over the sampled data
  <math|\<theta\><rsup|<around|(|i|)>>>,

  <\equation>
    <bra><with|font-series|bold|\<theta\>><ket>=lim<rsub|k\<rightarrow\>\<infty\>>
    <frac|1|k>*<big|sum><rsub|i=1><rsup|k>\<theta\><rsup|<around|(|i|)>>,
  </equation>

  where <math|k> is the number of the sampled data. The statistical error for
  <math|k> independent data is proportional to <math|<frac|1|<sqrt|k>>>. When
  the sampled data are correlated the statistical error will be proportional
  to <math|<sqrt|<frac|2*\<tau\>|k>>> where <math|\<tau\>> is the
  autocorrelation time between the sampled data. The autocorrelation time
  depends on the MCMC method we employ. Thus it is desirable to take an MCMC
  method which can generate data with a small <math|\<tau\>>.

  <section|Metropolis-Hastings algorithm>

  The Metropolis-Hastings (MH) algorithm<cite|MH> is an MCMC simulation
  method which generates draws from any probability density. The MH algorithm
  is an extension of the original Metropolis algorithm<cite|METRO>. Let us
  consider a probability distribution <math|P<around|(|x|)>> from which we
  would like to sample data x. The MH algorithm consists of the following
  steps.

  (1) First we set an initial value <math|x<rsub|0>> and <math|i=1>.

  (2) Then we generate a new value <math|x<rsub|i>> from a certain
  probability distribution <math|g<around|(|x<rsub|i>\|x<rsub|i-1>|)>> which
  we call proposal density.

  (3) We accept the candidate <math|x<rsub|i>> with a probability of
  <math|P<rsub|M*H><around|(|x<rsub|i-1>,x<rsub|i>|)>> where

  <\equation>
    P<rsub|M*H><around|(|x<rsub|i-1>,x<rsub|i>|)>=min
    <around*|[|1,<frac|P<around|(|x<rsub|i>|)>|P<around|(|x<rsub|i-1>|)>>*<frac|g<around|(|x<rsub|i>\|x<rsub|i-1>|)>|g<around|(|x<rsub|i-1>\|x<rsub|i>|)>>|]>.<label|eq:MH>
  </equation>

  When <math|x<rsub|i>> is rejected we keep <math|x<rsub|i-1>>, i.e.
  <math|x<rsub|i>=x<rsub|i-1>>.

  (4) Go back to (2) with an increment of <math|i=i+1>.

  For a symmetric proposal density <math|g<around|(|x<rsub|i>\|x<rsub|i-1>|)>=g<around|(|x<rsub|i-1>\|x<rsub|i>|)>>,
  eq.(<reference|eq:MH>) reduces to the Metropolis accept probability:

  <\equation>
    P<rsub|M*e*t*r*o><around|(|x<rsub|i-1>,x<rsub|i>|)>=min
    <around*|[|1,<frac|P<around|(|x<rsub|i>|)>|P<around|(|x<rsub|i-1>|)>>|]>.
  </equation>

  <section|Adaptive construction scheme>

  Since the proposal density <math|g<around|(|x<rsub|i>\|x<rsub|i-1>|)>> is
  dependent of the previous value <math|x<rsub|i-1>>, usually the sampled
  data are correlated. One may use an independent proposal density
  <math|g<around|(|x<rsub|i>|)>> which does not depend on the previous value.
  Although in this case we can generate independent candidates
  <math|x<rsub|i>>, it is important to choose the one close enough to the
  posterior density, in order to make the acceptance high enough.

  The posterior density of GARCH parameters often resembles to a
  Gaussian-like shape. Thus one may choose a density similar to a Gaussian
  distribution as the proposal density. Following <cite|WATANABE|ASAI>, in
  order to cover the tails of the posterior density we use a (p-dimensional)
  multivariate Student's t-distribution given by

  <\equation>
    g<around|(|\<theta\>|)>=<frac|\<Gamma\>*<around|(|<around|(|\<nu\>+p|)>/2|)>/\<Gamma\>*<around|(|\<nu\>/2|)>|det
    \<Sigma\><rsup|1/2>*<around|(|\<nu\>*\<pi\>|)><rsup|p/2>>*<around*|[|1+<frac|<around|(|\<theta\>-M|)><rsup|t>*\<Sigma\><rsup|-1>*<around|(|\<theta\>-M|)>|\<nu\>>|]><rsup|-<around|(|\<nu\>+p|)>/2>,<label|eq:ST>
  </equation>

  where <math|\<theta\>> and <math|M> are column vectors,

  <\equation>
    \<theta\>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|\<theta\><rsub|1>>>|<row|<cell|\<theta\><rsub|2>>>|<row|<cell|\<vdots\>>>|<row|<cell|\<theta\><rsub|p>>>>>>|]>,M=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|M<rsub|1>>>|<row|<cell|M<rsub|2>>>|<row|<cell|\<vdots\>>>|<row|<cell|M<rsub|p>>>>>>|]>,
  </equation>

  and <math|M<rsub|i>=E<around|(|\<theta\><rsub|i>|)>>. <math|<dis>\<Sigma\>>
  is the covariance matrix defined as

  <\equation>
    <frac|\<nu\>*\<Sigma\>|\<nu\>-2>=E*<around|[|<around|(|\<theta\>-M|)>*<around|(|\<theta\>-M|)><rsup|t>|]>.
  </equation>

  For later use we also define a matrix <math|V> as

  <\equation>
    V=E*<around|[|<around|(|\<theta\>-M|)>*<around|(|\<theta\>-M|)><rsup|t>|]>.
  </equation>

  <math|\<nu\>> is a parameter to tune the shape of Student's t-distribution.
  When <math|\<nu\>\<rightarrow\>\<infty\>> the Student's t-distribution goes
  to a Gaussian distribution. In this study we take <math|\<nu\>=10>.

  There are three parameters to be inferred for the GARCH(1,1) model.
  Therefore in this case <math|p=3> and <math|<dis>\<theta\>=<around|(|\<theta\><rsub|1>,\<theta\><rsub|2>,\<theta\><rsub|3>|)>=<around|(|\<alpha\>,\<beta\>,\<omega\>|)>>,
  and <math|\<Sigma\>> is a <math|3\<times\>3> matrix. The values of
  <math|\<Sigma\>> and <math|M> are not known a priori. We determine these
  unknown parameters <math|M> and <math|\<Sigma\>> through MCMC simulations.
  First we make a short run by the Metropolis algorithm and accumulate some
  data. Then we estimate <math|M> and <math|\<Sigma\>>. Note that there is no
  need to estimate <math|M> and <math|\<Sigma\>> accurately. Second we
  perform an MH simulation with the proposal density of
  eq.(<reference|eq:ST>) with the estimated <math|M> and <math|\<Sigma\>>.
  After accumulating more data, we recalculate <math|M> and <math|\<Sigma\>>,
  and update <math|M> and <math|\<Sigma\>> of eq.(<reference|eq:ST>). By
  doing this, we adaptively change the shape of eq.(<reference|eq:ST>) to fit
  the posterior density more accurately. We call eq.(<reference|eq:ST>) with
  the estimated <math|M> and <math|\<Sigma\>> "adaptive proposal density".

  The random number generation for the multivariate Student's t-distribution
  can be done easily as follows. First we decompose the symmetric covariance
  matrix <math|\<Sigma\>> by the Cholesky decomposition as
  <math|\<Sigma\>=L*L<rsup|t>>. Then substituting this result to
  eq.(<reference|eq:ST>) we obtain

  <\equation>
    g<around|(|X|)>\<sim\><around*|[|1+<frac|X<rsup|t>*X|\<nu\>>|]><rsup|-<around|(|\<nu\>+p|)>/2>,
  </equation>

  where <math|X=L<rsup|-1>*<around|(|\<theta\>-M|)>>. The random numbers
  <math|X> are given by <math|<dis>X=Y<sqrt|<frac|\<nu\>|w>>>, where <math|Y>
  follows <math|N<around|(|0,I|)>> and <math|w> is taken from the chi-square
  distribution <math|\<nu\>> degrees of freedom
  <math|\<chi\><rsup|2><rsub|\<nu\>>>. Finally we obtain the random number
  <math|\<theta\>> by <math|\<theta\>=L*X+M>.

  <section|Empirical analysis>

  We make an empirical analysis based on daily data of the exchange rates for
  US Dollar and Japanese Yen. The sampling period of the exchange rates is 4
  January 1999 to 29 December 2006, which gives 2006 observations. The
  exchange rates <math|p<rsub|i>> are transformed to
  <math|<dis>r<rsub|i>=100*<around|[|ln <around|(|p<rsub|i>/p<rsub|i-1>|)>-<wide|s|\<bar\>>|]>>
  where <math|<dis><wide|s|\<bar\>>> stands for the average value of <math|ln
  <around|(|p<rsub|i>/p<rsub|i-1>|)>>.

  Our implementation of the adaptive construction scheme is as follows. First
  we make a short run by the Metropolis algorithm. We discard the first 3000
  data as burn-in process. Then we accumulate 1000 data to estimate <math|M>
  and <math|\<Sigma\>>. The estimated <math|M> and <math|\<Sigma\>> are
  substituted to <math|g<around|(|\<theta\>|)>> of eq.(<reference|eq:ST>).
  The shape parameter <math|\<nu\>> is set to 10. We re-start a run by the MH
  algorithm with the proposal density <math|g<around|(|\<theta\>|)>>. Every
  1000 update we re-calculate <math|M> and <math|\<Sigma\>> using all
  accumulated data and update <math|g<around|(|\<theta\>|)>> for the next
  run. We accumulate 100000 data for analysis.

  <big-table|<with|par-mode|center|<label|tab:1><with|font-size|0.71|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|4|4|cell-halign|l>|<cwith|1|-1|4|4|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|2|2|cell-col-span|1>|<cwith|1|1|2|2|cell-halign|c>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-col-span|1>|<cwith|1|1|3|3|cell-halign|c>|<cwith|1|1|3|3|cell-rborder|0ln>|<cwith|1|1|4|4|cell-col-span|1>|<cwith|1|1|4|4|cell-halign|c>|<cwith|1|1|4|4|cell-rborder|0ln>|<cwith|1|1|1|-1|cell-bborder|2ln>|<cwith|5|5|1|-1|cell-bborder|1ln>|<cwith|9|9|1|-1|cell-bborder|1ln>|<table|<row|<cell|>|<cell|<math|\<alpha\>>>|<cell|<math|\<beta\>>>|<cell|<math|\<omega\>>>>|<row|<cell|Adaptive
  construction>|<cell|0.03151>|<cell|0.9403>|<cell|0.01104>>|<row|<cell|standard
  deviation<space|3mm>>|<cell|0.0078>|<cell|0.017>|<cell|0.0047>>|<row|<cell|statistical
  error>|<cell|0.00004>|<cell|0.0001>|<cell|0.00003>>|<row|<cell|<math|2*\<tau\><rsub|i*n*t>>>|<cell|<math|2.8\<pm\>0.3>>|<cell|<math|3.8\<pm\>0.4>>|<cell|<math|4.1\<pm\>0.5>>>|<row|<cell|Metropolis>|<cell|0.0318>|<cell|0.9391>|<cell|0.0114>>|<row|<cell|standard
  deviation>|<cell|0.0079>|<cell|0.018>|<cell|0.005>>|<row|<cell|statistical
  error>|<cell|0.0005>|<cell|0.0014>|<cell|0.0004>>|<row|<cell|<math|2*\<tau\><rsub|i*n*t>>>|<cell|<math|400\<pm\>60><space|2mm>>|<cell|<math|650\<pm\>100><space|2mm>>|<cell|<math|620\<pm\>80><space|2mm>>>>>>
  >>|Results of parameters.>

  We also make a Metropolis simulation and accumulate 100000 data for
  analysis. The Metropolis algorithm in this study is implemented as follows.
  We draw a new <math|\<theta\><rprime|'>> by adding a small random value
  <math|\<delta\>*\<theta\>> to the present value
  <math|\<theta\>=<around|(|\<theta\><rsub|1>,\<theta\><rsub|2>,\<theta\><rsub|3>|)>=<around|(|\<alpha\>,\<beta\>,\<omega\>|)>>:

  <\equation>
    \<theta\><rprime|'><rsub|j>=\<theta\><rsub|j>+\<delta\>*\<theta\><rsub|j>,
  </equation>

  where <math|<dis>\<delta\>*\<theta\><rsub|j>=d*<around|(|r-0.5|)>>.
  <math|r> is a uniform random number in <math|<around|[|0,1|]>> and <math|d>
  is a constant to tune the Metropolis acceptance. We choose <math|d> so that
  the acceptance becomes greater than <math|50%>.

  <big-figure|<vspace|5mm><with|par-mode|center|<image|alpha_imp_mu10.eps||4.1cm||>
  <image|alpha_metro_emp.eps||4.1cm||> <vspace|1mm><label|fig:History>>|Monte
  Carlo time histories of <math|\<alpha\>> sampled by the adaptive
  construction scheme (left) and the Metropolis algorithm(right). >

  Fig.<nbsp>1 compares the Monte Carlo time history of <math|\<alpha\>>
  sampled by the adaptive construction scheme with that by the Metropolis
  algorithm. It is clearly seen that the data <math|\<alpha\>> produced by
  the Metropolis algorithm are very correlated. On the other hand the sampled
  data by the adaptive construction scheme seem to be well de-correlated. For
  other parameters <math|\<beta\>> and <math|\<omega\>> we also see the
  similar behavior.

  In order to see correlations between sampled data, we measure the
  autocorrelation function (ACF) defined as

  <\equation>
    A*C*F<around|(|t|)>=<frac|<frac|1|N>*<big|sum><rsub|j=1><rsup|N><around|(|x<around|(|j|)>-<bra>x<ket>|)>*<around|(|x*<around|(|j+t|)>-<bra>x<ket>|)>|\<sigma\><rsup|2><rsub|x>>,
  </equation>

  where <math|<bra>x<ket>> and <math|\<sigma\><rsup|2><rsub|x>> are the
  average value and the variance of certain successive data <math|x>
  respectively.

  <big-figure|<vspace|5mm><with|par-mode|center|<image|corr_imp_alpha.eps||4.0cm||>
  <image|corr_alpha_metro.eps||4.0cm||> <vspace|1mm><label|fig:ACF>>|Autocorrelation
  functions of <math|\<alpha\>> for the adaptive construction scheme (left)
  and the Metropolis algorithm (right). >

  Fig.<nbsp>2 shows the ACF for the adaptive construction scheme and the
  Metropolis algorithm. The ACF of the the adaptive construction scheme
  decreases quickly as Monte Carlo time <math|t> increases. On the other hand
  the ACF of the Metropolis algorithm decreases very slowly which indicates
  that the correlation between the sampled data is very large.

  We estimate the autocorrelation time by the integrated autocorrelation time
  <math|\<tau\><rsub|i*n*t>>. To calculate <math|\<tau\><rsub|i*n*t>> we
  define <math|\<tau\><rsub|i*n*t><around|(|T|)>> as

  <\equation>
    \<tau\><rsub|i*n*t><around|(|T|)>=<frac|1|2>+<big|sum><rsub|i=1><rsup|T>A*C*F<around|(|i|)>.
  </equation>

  <math|\<tau\><rsub|i*n*t>> is given by <math|\<tau\><rsub|i*n*t><assign|tau|<macro|i*n*t>><around|(|T=\<infty\>|)>>.
  In practice, however, it is impossible to sum up <math|A*C*F<around|(|t|)>>
  to <math|T=\<infty\>>. Since typically <math|\<tau\><rsub|i*n*t><around|(|T|)>>
  increases with <math|T> and reaches a plateau we estimate
  <math|\<tau\><rsub|i*n*t>> at this plateau. Fig.<nbsp>3 illustrates
  <math|\<tau\><rsub|i*n*t><around|(|T|)>> of <math|\<alpha\>> sampled by the
  adaptive construction scheme. <math|\<tau\><rsub|i*n*t><around|(|T|)>>
  increases with <math|T> and reaches a plateau around <math|T\<ge\>20>.

  <big-figure|<vspace|5mm><with|par-mode|center|<image|int_corr_imp_alpha.eps||5.0cm||>
  <vspace|1mm><label|fig:ACT>>|The integrated autocorrelation time
  <math|\<tau\><rsub|i*n*t><around|(|T|)>> of <math|\<alpha\>> sampled by the
  adaptive construction scheme. >

  Results of <math|\<tau\><rsub|i*n*t>> are summarized in Table 1. The values
  of <math|\<tau\><rsub|i*n*t>> from the Metropolis simulations are very
  large, typically several hundreds. On the other hand
  <math|\<tau\><rsub|i*n*t>> from the adaptive construction scheme are very
  small, <math|2*\<tau\><rsub|i*n*t>\<sim\>2-3><footnote|<math|2*\<tau\><rsub|i*n*t>>
  is called an inefficiency factor.>. This results in a factor of 10
  reduction in terms of the statistical error. This reduction property is
  confirmed by the statistical errors of the sampled data (See Table 1). Thus
  it is concluded that the adaptive construction scheme is effectively
  working for reducing the correlations between the sampled data.

  <big-figure|<vspace|5mm><with|par-mode|center|<image|sig_diagonl.eps||4.0cm||>
  <space|1mm><image|sig_offdiagonl.eps||4.0cm||>
  <vspace|1mm><label|fig:SIG>>|The matrix elements of the symmetric
  covariance matrix <math|V>. Diagonal elements (left) and off-diagonal
  elements (right). >

  Fig.<nbsp>4 shows the convergence property of the matrix <math|V>. The
  matrix elements <math|V<rsub|i*j>> are defined by
  <math|<dis>V=E*<around|[|<around|(|\<theta\>-M|)>*<around|(|\<theta\>-M|)><rsup|t>|]>>
  with <math|\<theta\>=<around|(|\<theta\><rsub|1>,\<theta\><rsub|2>,\<theta\><rsub|3>|)>=<around|(|\<alpha\>,\<beta\>,\<omega\>|)>>.
  For instance <math|V<rsub|12>=V<rsub|\<alpha\>*\<beta\>>>. All elements of
  <math|V> converge quickly to certain values as the simulations are
  proceeded.

  <big-figure|<vspace|5mm><with|par-mode|center|<image|impacc.eps||5.5cm||>
  <vspace|1mm><label|fig:ACC>>|Acceptance at MH step with the adaptive
  proposal density. >

  Fig.<nbsp>5 shows the acceptance at the MH algorithm with the adaptive
  proposal density of eq.(<reference|eq:ST>). Each acceptance is calculated
  every 1000 updates and the calculation of the acceptance is based on the
  latest 1000 data. At the first stage of the simulation the acceptance is
  low. This is because at this stage <math|M> and <math|\<Sigma\>> are not
  calculated accurately yet. However the acceptances increase quickly as the
  simulations are proceeded and reaches a plateau where the acceptance is
  more than 70%.

  <section|Summary>

  We proposed the adaptive construction scheme to construct a proposal
  density for the MH algorithm of the GARCH(1,1) model. The construction of
  the proposal density is performed using the data generated by MCMC methods.
  During the MCMC simulations the proposal density is updated adaptively. In
  this study we applied the adaptive construction scheme for the Bayesian
  inference of the GARCH(1,1) model by using US Dollar/Japanese Yen exchange
  rate. The numerical results show that the adaptive construction scheme
  significantly reduces the correlations between the sampled data. The
  autocorrelation time of the adaptive construction method is calculated to
  be <math|2*\<tau\><rsub|i*n*t>\<sim\>2-3>, which is comparable to that of
  the AR/MH method<cite|ASAI>. It is concluded that the adaptive construction
  scheme is an efficient method for the Bayesian inference of the GARCH(1,1)
  model. The adaptive construction scheme is not limited to the GARCH(1,1)
  model and can be applied for other GARCH-type models.

  <section*|Acknowledgments>

  The numerical calculations were carried out on Altix at the Institute of
  Statistical Mathematics and on SX8 at the Yukawa Institute for Theoretical
  Physics in Kyoto University.

  <\thebibliography|4>
    <bibitem|ARCH>Engle, R.<nbsp>F.: Autoregressive Conditional
    Heteroskedasticity with Estimates of the Variance of the United Kingdom
    inflation. Econometrica 50, 987\U1007 (1982)

    <bibitem|GARCH>Bollerslev,<nbsp>T.: Generalized Autoregressive
    Conditional Heteroskedasticity. Journal of Econometrics 31, 307\U327
    (1986)

    <bibitem|EGARCH>Nelson, D.<nbsp>B.: Conditional Heteroskedasticity in
    Asset Returns: A New Approach. Econometrica 59, 347\U370 (1991)

    <bibitem|GJR>Glston, L.<nbsp>R., Jaganathan,<nbsp>R. Runkle,<nbsp>D.E.:
    On the Relation Between the Expected Value and the Volatility of the
    Nominal Excess on Stocks. Journal of Finance 48, 1779\U1801 (1993)

    <bibitem|APGARCH>Ding, Z., Granger, C.W.J., Engle, R.F.: A long memory
    property of stock market returns and a new model. Journal of Empirical
    Finance 1, 83\U106 (1993)

    <bibitem|QGARCH>Sentana, E.: Quadratic ARCH Models. Review of Economic
    Studies 62, 639\U661 (1995)

    <bibitem|Bauwens>Bauwens, L., Lubrano, M.: Bayesian inference on GARCH
    models using the Gibbs sampler. Econometrics Journal 1, c23-c46 (1998)

    <bibitem|Kim>Kim. S., Shephard, N., Chib, S.: Stochastic volatility:
    Likelihood inference and comparison with ARCH models. Review of Economic
    Studies 65, 361\U393 (1998)

    <bibitem|Nakatsuma>Nakatsuma, T.: Bayesian analysis of ARMA-GARCH models:
    Markov chain sampling approach. Journal of Econometrics 95, 57\U69 (2000)

    <bibitem|WATANABE>Mitsui, H., Watanabe, T.: Bayesian analysis of GARCH
    option pricing models. J. Japan Statist. Soc. (Japanese Issue) 33,
    307\U324 (2003)

    <bibitem|ASAI>Asai, M.: Comparison of MCMC Methods for Estimating GARCH
    Models. J. Japan Statist. Soc. 36, 199\U212 (2006)

    <bibitem|HMC>Takaishi, T.: Bayesian Estimation of GARCH model by Hybrid
    Monte Carlo. Proceedings of the 9th Joint Conference on Information
    Sciences 2006, CIEF-214<next-line>arXiv:physics/0702240v1 (2007)

    doi:10.2991/jcis.2006.159

    <bibitem|ACS>Takaishi, T.: An adaptive Markov Chain Monte Carlo method
    for GARCH model. arXiv:0901.0992v1 (2009)

    <bibitem|MH>Hastings, W.K.: Monte Carlo Sampling Methods Using Markov
    Chains and Their Applications. Biometrika 57, 97\U109 (1970)

    <bibitem|METRO>Metropolis, N., Rosenbluth, A.W., Rosenbluth, M.N.,
    Teller, A.H., Teller, E.: Equations of State Calculations by Fast
    Computing Machines. J. of Chem. Phys. 21, 1087\U1091 (1953)
  </thebibliography>
</body>