<TeXmacs|1.99.7>

<style|<tuple|generic|std-latex>>

<\body>
  <doc-data|<doc-title|Path integral approach to the pricing of timer options
  with the Duru-Kleinert time transformation>|<doc-author|<author-data|<author-name|L.
  Z. J. Liang>>>|<doc-author|<author-data|<author-name|D.
  Lemmens>>>|<doc-author|<author-data|<author-name|J.
  Tempere>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    In this paper, a time substitution as used by Duru and Kleinert in their
    treatment of the hydrogen atom with path integrals is performed to price
    timer options under stochastic volatility models. We present general
    pricing formulas for both the perpetual timer call options and the finite
    time-horizon timer call options. These general results allow us to find
    closed-form pricing formulas for both the perpetual and the finite
    time-horizon timer options under the 3/2 stochastic volatility model as
    well as under the Heston stochastic volatility model. For the treatment
    of timer option under the 3/2 model we will rely on the path integral for
    the Morse potential, with the Heston model we will rely on the Kratzer
    potential.
  </abstract>>

  <section|Introduction><label|Introduction>

  Timer options, first introduced for sale by Societe Generale Corporate and
  Investment Banking (SG CIB) in 2007 <cite|SG|Fontenay>, are relatively new
  products in the equity volatility market. The basic principle of this
  option is similar to the European vanilla option, with the key distinction
  being the uncertain expiration date. Rather than a fixed maturity time that
  is set at inception for the vanilla option, the expiry date of the timer
  option is a stopping time equal to the time needed for the realized
  variance of the underlying asset to reach a pre-specified level.

  Stopping times, sometimes formulated as first passage or hitting times,
  have applications in various research fields. Traditional applications of
  stopping times in physics are for example the situation where internal
  fluctuations induce the current of an electric circuit to attain a critical
  value <cite|Roberts|Lindenberg> and Kramer's problem <cite|Weiss3|Hanggi>.
  Recent applications of stopping times can be found in neuroscience, where a
  neuron emits a signal when its membrane voltage exceeds a certain threshold
  <cite|Ditlevsen|Bulsara|Bibbona>; in the research field of quantum hitting
  times of Markov chains and hitting times of quantum random walks
  <cite|Krovi|Varbanov>; and in econophysics <cite|Masoliver|Katz>. For an
  introduction to first passage problems and an overview of possible
  applications see <cite|Redner|Weiss>.

  When the expiration date is only determined by a stopping time that can
  theoretically become infinite the option is called a perpetual timer
  option. According to Hawkins and Krol <cite|Hawkins>, it is usual practice
  to specify a maximum expiry for the timer option, at which point the option
  expires in the same manner as vanilla options, to prevent excessively long
  maturity times. These options are called finite time-horizon timer options.

  Timer options were first proposed in literature by Neuberger
  <cite|Neuberger> as "mileage" options in 1990. In the middle 1990s, Bick
  emphasized the application of dynamic trading strategies with timer options
  to portfolio insurance as well as to hedging strategies <cite|Bick>.
  Recently, after timer options were traded in the market, the amount of
  research concerning the pricing of perpetual timer options has increased.
  Li studied the pricing and hedging under the Heston stochastic volatility
  model <cite|Li>. Bernard and Cui proposed a fast and accurate almost-exact
  simulation method in general stochastic volatility models <cite|Bernard>.
  Saunders developed an asymptotic approximation under fast mean-reverting
  stochastic volatility models <cite|Saunders>. We contribute to the existing
  literature by presenting analytical pricing results for both perpetual and
  finite time-horizon timer options for a general stochastic process. These
  general results are then applied to determine explicit closed-form formulas
  for the 3/2 and the Heston stochastic volatility model. Especially for
  timer options it is relevant to investigate different stochastic volatility
  models, since the price of these options is particularly sensitive to the
  behavior of the volatility.

  We will derive these results in the path integral framework. The
  applications of path integral methodology drawn from quantum mechanics to
  finance can be found, among others, in <cite|Kleinert|Linetsky|Bennati|Damiaan|Lingzhi|Baaquie>
  and references therein. The virtue of this method lies in its capacity to
  provide an intuitive way to derive the transition probability density
  function (propagator) of the underlying stochastic processes. Since the
  pricing of financial options comes down to evaluating expectation values of
  stochastic processes, the path integral formalism is a suitable alternative
  to partial differential equations.

  To derive our general results we will rely on the Duru-Kleinert space-time
  substitution method used by Duru and Kleinert to treat the hydrogen atom
  with path integrals <cite|Kleinert|Duru|Duru2>. This method has recently
  been used in finance by Decamps and De Schepper to derive asymptotic
  formulas for Black-Scholes implied volatilities <cite|Decamps>. The
  Duru-Kleinert space-time substitution approach serves here to translate the
  original stochastic processes to new ones behaving in a stochastic time
  horizon. Under this new time horizon, the random expiry time is expressed
  as a functional of the transformed stochastic volatility. Then a method
  related to variational perturbation theory <cite|Feynman|Kleinert> is
  applied to derive the joint propagator of the transformed stochastic
  volatility process and the stopping time process in the new time horizon.
  Based on these transition probability density functions, we arrive at the
  pricing formulas for the perpetual timer option. In addition, we obtain
  pricing formulas for the finite time-horizon timer option by deriving the
  joint propagator of the log-return and the realized variance process.

  For stochastic volatility processes, we start by emphasizing the 3/2
  stochastic volatility model <cite|Ahn|Andreasen|Gabriel> not only in view
  of its analytical tractability but also because of the support from
  empirical evidence <cite|Jones|Bakshi|Carr2>. The results for this model
  are obtained by making a connection with the Morse potential. Next we treat
  the Heston stochastic volatility model <cite|Heston> by relating it to the
  Kratzer potential. This leads to closed-form pricing formulas for perpetual
  and finite time-horizon timer options for both models. The result for the
  perpetual timer option under the Heston model corresponds to the one found
  by Li <cite|Li>, confirming our approach.

  This paper is organized as follows. In section <reference|General> we
  present general pricing formulas for perpetual and finite time-horizon
  timer call options under general stochastic volatility models. Section
  <reference|Propagators> is devoted to deriving closed-form formulas for the
  3/2 and the Heston stochastic volatility model. In section <reference|Disc>
  the closed-form formulas are compared with Monte Carlo simulations and some
  properties of timer options are discussed. And finally a conclusion is
  given in section <reference|Conclusion>.

  <section|General pricing formula of timer call options><label|General>

  <subsection|Model description>

  For conciseness of representation, in this paper we only consider option
  pricing in a risk-neutral world. Moreover we assume that the initial time
  of the option is the current time <math|t=0> because the generalization to
  the case of a forward-start option is straightforward.

  Let <math|<around|{|S<around|(|t|)>|}>> denote the underlying asset price
  process following a Black-Scholes type stochastic differential equation
  (SDE), with a variance <math|v<around|(|t|)>>, which is stochastic variable
  itself. Conventionally, the time evolution of <math|S<around|(|t|)>> is
  represented in terms of the log-return <math|x<around|(|t|)>=ln
  <frac|S<around|(|t|)>|S<rsub|0>>>, with <math|S<rsub|0>=S<around|(|0|)>>.
  The realization of a stochastic process <math|Z> at a special time <math|s>
  will be denoted by <math|Z<rsub|s>>, and we will use this notation
  throughout the paper. After the transformation to the log-return, the
  system is governed by the SDEs:

  <align|<tformat|<table|<row|<cell|d*x<around|(|t|)>>|<cell|=<around*|(|r-<frac|v|2>|)>*d*t+<sqrt|v>*<around*|(|<sqrt|1-\<rho\><rsup|2>>*d*W<rsub|1>+\<rho\>*d*W<rsub|2>|)>,<label|dx>>>|<row|<cell|d*v<around|(|t|)>>|<cell|=\<alpha\><around|(|v|)>*d*t+\<beta\><around|(|v|)>*d*W<rsub|2>,<label|dv>>>>>>

  where <math|r> is the constant risk-neutral interest rate,
  <math|W<rsub|1><around|(|t|)>> and <math|W<rsub|2><around|(|t|)>> are two
  independent Wiener processes, <math|\<rho\>\<in\>[-1,1]> is the correlation
  coefficient between <math|x<around|(|t|)>> and its variance
  <math|v<around|(|t|)>>.

  Now we introduce the notion of the realized variance, which is a principal
  ingredient of timer options. In practice the realized variance is given by
  <math|<big|sum><rsub|n=1><rsup|N><around*|(|x<rsub|t<rsub|n>>-x<rsub|t<rsub|n-1>>|)><rsup|2>>,
  where the set of evaluation times <math|t<rsub|n>> are for example daily
  closing times. In the literature (see <cite|Sepp|Li>), the realized
  variance of the underlying asset during a time period
  <math|<around|[|0,T|]>>, denoted by <math|I<rsub|T>>, is usually
  approximated by:

  <\equation>
    I<rsub|T><space|0.17em>=<big|int><rsub|0><rsup|T>v<around|(|t|)>*d*t.<label|defrv>
  </equation>

  Also in this paper equation (<reference|defrv>) will be used as the
  definition of the realized variance.

  <subsection|Pricing of perpetual timer options>

  The price of a perpetual timer call option with strike price <math|K> can
  be expressed as the expectation of the discounted payoff:

  <\equation>
    <label|Cperp1>\<cal-C\><rsub|P*e*r*p>=\<bbb-E\>*<around*|[|e<rsup|-r*\<cal-T\><rsub|<mathcal>>*B>*<space|0.17em><with|font-family|rm|m*a*x>*<around*|(|S<rsub|0>*<space|0.17em>e<rsup|x<rsub|\<cal-T\><rsub|<mathcal>>*B>>-K,0|)>|]>.
  </equation>

  This expression is similar to the one for the vanilla call option, except
  for the uncertain expiry time <math|\<cal-T\><rsub|<mathcal>>*B>, which is
  the stopping time defined as

  <\equation>
    \<cal-T\><rsub|<mathcal>>*B=inf <around*|{|u\<gtr\>0;<space|0.17em><big|int><rsub|0><rsup|u>v<around|(|t|)>*d*t=\<cal-B\>|}>.
  </equation>

  Here <math|\<cal-B\>=\<sigma\><rsub|0><rsup|2>*T<rsub|0>> is the
  pre-specified variance budget with <math|T<rsub|0>> the expected investment
  horizon and <math|\<sigma\><rsub|0>> the forecasted volatility of the
  underlying asset during that period.

  The dependence on the implicitly defined expiry time
  <math|\<cal-T\><rsub|<mathcal>>*B> is inconvenient. We will now apply the
  Duru-Kleinert method of quantum mechanics <cite|Kleinert> to construct
  variables in function of which <math|\<cal-T\><rsub|<mathcal>>*B> is
  explicitly given. Define a time substitution <math|\<tau\><around|(|t|)>>
  such that

  <\equation>
    \<tau\><around|(|t|)>=<big|int><rsub|0><rsup|t>v<around|(|s|)>*d*s,
  </equation>

  we will refer to <math|\<tau\>> as the pseudotime, following
  <cite|Kleinert>. The inverse function theorem gives us that

  <\equation>
    <frac|d*\<tau\><rsup|-1><around|(|t|)>|d*t>=<frac|1|v<around|(|\<tau\><rsup|-1><around|(|t|)>|)>>,
  </equation>

  from which it follows that <math|\<tau\><rsup|-1><around|(|t|)>> is given
  by:

  <\equation>
    \<tau\><rsup|-1><around|(|t|)>=<big|int><rsub|0><rsup|t><frac|1|v<around|(|\<tau\><rsup|-1><around|(|s|)>|)>>*d*s.
  </equation>

  Denote <math|v<around|(|\<tau\><rsup|-1><around|(|t|)>|)>> by
  <math|V<around|(|t|)>> and <math|x<around|(|\<tau\><rsup|-1><around|(|t|)>|)>>
  by <math|X<around|(|t|)>>, which follow new SDEs:

  <align|<tformat|<table|<row|<cell|d*V<around|(|t|)>=>|<cell|<frac|\<alpha\><around*|(|V|)>|V>*d*t+<frac|\<beta\><around*|(|V|)>|<sqrt|V>>*d*W<rsub|2>,>>|<row|<cell|d*X<around|(|t|)>=>|<cell|<around*|(|<frac|r|V>-<frac|1|2>|)>*d*t+<around*|(|<sqrt|1-\<rho\><rsup|2>>*d*W<rsub|1>+\<rho\>*d*W<rsub|2>|)>.>>>>>

  Given the timer call variance budget

  <\equation>
    \<cal-B\>=<big|int><rsub|0><rsup|\<cal-T\><rsub|<mathcal>>*B>v<around|(|t|)>*d*t=\<tau\>*<around|(|\<cal-T\><rsub|<mathcal>>*B|)>,
  </equation>

  we obtain the explicit expression for the stopping time as

  <\equation>
    <label|T>\<cal-T\><rsub|<mathcal>>*B=\<tau\><rsup|-1><around|(|\<cal-B\>|)>=<big|int><rsub|0><rsup|\<cal-B\>><frac|1|v<around|(|\<tau\><rsup|-1><around|(|t|)>|)>>*d*t=<big|int><rsub|0><rsup|\<cal-B\>><frac|1|V<around|(|t|)>>*d*t.
  </equation>

  Note that <math|<around|(|x<around|(|t|)>,v<around|(|t|)>|)>=<around|(|X<around|(|\<tau\><around|(|t|)>|)>,V<around|(|\<tau\><around|(|t|)>|)>|)>>
  , so as <math|<around|(|x<around|(|t|)>,v<around|(|t|)>|)>> evolves in the
  period <math|<around|[|0,\<cal-T\><rsub|<mathcal>>*B|]>>,
  <math|<around|(|X<around|(|t|)>,V<around|(|t|)>|)>> evolves in
  <math|<around|[|\<tau\><around|(|0|)>,\<tau\>*<around|(|\<cal-T\><rsub|<mathcal>>*B|)>|]>>,
  that is <math|<around|[|0,\<cal-B\>|]>>. Therefore
  <math|<around|[|0,\<cal-B\>|]>> is now a fixed horizon in pseudotime, and
  not only do the processes <math|X>, <math|V> and <math|\<cal-T\>> evolve
  during that period, but also expression (<reference|Cperp1>) can be written
  as

  <\equation>
    <label|Cperp2>\<cal-C\><rsub|P*e*r*p>=\<bbb-E\>*<around*|[|e<rsup|-r*\<cal-T\><rsub|<mathcal>>*B>*<space|0.17em><with|font-family|rm|m*a*x>*<around*|(|S<rsub|0>*<space|0.17em>e<rsup|X<rsub|\<cal-B\>>>-K,0|)>|]>.
  </equation>

  Hence, it is intuitive to study the joint transition probability density
  function of the dynamics of <math|<around*|(|X,\<cal-T\>|)>>. However, as
  <math|\<cal-T\>> depends on <math|V>, we turn to the joint propagator of
  the dynamics of <math|<around*|(|X,V,\<cal-T\>|)>>.

  The substitutions

  <align|<tformat|<table|<row|<cell|z<around|(|t|)>=>|<cell|<big|int><frac|<sqrt|V>|\<beta\><around*|(|V|)>>*d*V<around|(|t|)>,<label|z>>>|<row|<cell|y<around|(|t|)>=>|<cell|X<around|(|t|)>-\<rho\>*z<around|(|t|)>,>>>>>

  help change the correlated dynamics of <math|<around|(|X,V|)>> into two
  independent processes following

  <align|<tformat|<table|<row|<cell|d*y<around|(|t|)>=>|<cell|<around*|[|<frac|r|V<around|(|z|)>>-<frac|1|2>-\<rho\>*\<cal-A\><around*|(|z|)>|]>*d*t+<sqrt|1-\<rho\><rsup|2>>*d*W<rsub|1>,>>|<row|<cell|d*z<around|(|t|)>=>|<cell|\<cal-A\><around*|(|z|)>*d*t+d*W<rsub|2>,>>>>>

  where

  <\equation>
    <label|A>\<cal-A\><around*|(|z<around|(|t|)>|)>=<frac|\<alpha\><around|(|V|)>|\<beta\><around|(|V|)><sqrt|V>>+<frac|1|2>*<frac|d|d*V><around*|(|<frac|<sqrt|V>|\<beta\><around|(|V|)>>|)><frac|\<beta\><rsup|2><around|(|V|)>|V>
  </equation>

  is a function of <math|z<around|(|t|)>> because <math|V<around|(|t|)>> is
  expressed in terms of <math|z<around|(|t|)>> according to expression
  (<reference|z>).

  To determine the price of the timer option, the propagator
  <math|\<cal-P\>*<around*|(|y<rsub|<mathcal>>*B,z<rsub|<mathcal>>*B,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>y<rsub|0>,z<rsub|0>,0|)>>
  is needed. This propagator describes the joint probability that <math|y>
  has the value <math|y<rsub|<mathcal>>*B>, <math|z> has the value
  <math|z<rsub|<mathcal>>*B> and the stopping time has the value
  <math|\<cal-T\><rsub|<mathcal>>*B> at a later pseudotime <math|\<cal-B\>>
  given their initial value <math|y<rsub|0>>, <math|z<rsub|0>> and 0 at
  pseudotime 0. Since the processes <math|y> and <math|z> are uncorrelated,
  the Lagrangian corresponding to their joint evolution can be written as
  <math|\<cal-L\><around|[|y,<wide|y|\<dot\>>,z|]>+\<cal-L\><around|[|z,<wide|z|\<dot\>>|]>>
  with:

  <align|<tformat|<table|<row|<cell|\<cal-L\><around|[|y,<wide|y|\<dot\>>,z|]>=>|<cell|<frac|<around*|[|<wide|y|\<dot\>>-<around*|(|<frac|r|V<around|(|z|)>>-<frac|1|2>-\<rho\>*\<cal-A\><around*|(|z|)>|)>|]><rsup|2>|2*<around*|(|1-\<rho\><rsup|2>|)>>,>>|<row|<cell|\<cal-L\><around|[|z,<wide|z|\<dot\>>|]>=>|<cell|<frac|1|2>*<around*|[|<wide|z|\<dot\>>-\<cal-A\><around*|(|z|)>|]><rsup|2>+<frac|1|2>*<frac|\<partial\>|\<partial\>*z>*\<cal-A\><around*|(|z|)>,>>>>>

  Using the path integral framework, the joint propagator
  <math|\<cal-P\>*<around*|(|y<rsub|<mathcal>>*B,z<rsub|<mathcal>>*B,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>y<rsub|0>,z<rsub|0>,0|)>>
  can be determined by:

  <align|<tformat|<table|<row|<cell|<label|PyBzBTb>>|<cell|\<cal-P\>*<around*|(|y<rsub|<mathcal>>*B,z<rsub|<mathcal>>*B,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>y<rsub|0>,z<rsub|0>,0|)>=<no-number>>>|<row|<cell|>|<cell|<big|int>\<cal-D\>*y*<big|int>\<cal-D\>*z*\<delta\>*<around*|(|\<cal-T\><rsub|<mathcal>>*B-<big|int><rsub|0><rsup|\<cal-B\>><frac|1|V<around|(|z|)>>*d*t|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|\<cal-B\>><around*|(|\<cal-L\><around|[|z,<wide|z|\<dot\>>|]>+\<cal-L\><around|[|y,<wide|y|\<dot\>>,z|]>|)>*d*t>,>>>>>

  where <math|\<delta\><around|(|\<cdummy\>|)>> is the delta function. It
  serves here to select these paths of <math|V>, expressed in terms of
  <math|z>, such that <math|<big|int><rsub|0><rsup|\<cal-B\>><frac|1|V<around|(|t|)>>*d*t>
  equals <math|\<cal-T\><rsub|<mathcal>>*B>.

  To proceed we introduce the Fourier transform of the delta function.
  Furthermore since the path integral corresponding to the <math|y> variable
  is quadratic it can be solved analytically. After performing this path
  integral, we can return to the original <math|X<rsub|\<cal-B\>>> variable.
  Expression (<reference|PyBzBTb>) then becomes:

  <align|<tformat|<table|<row|<cell|<label|PXzT>>|<cell|\<cal-P\>*<around*|(|X<rsub|\<cal-B\>>,z<rsub|<mathcal>>*B,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>y<rsub|0>,z<rsub|0>,0|)>=<no-number>>>|<row|<cell|>|<cell|<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*p|2*\<pi\>>*e<rsup|i*p*\<cal-T\><rsub|<mathcal>>*B>*<big|int>\<cal-D\>*z*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|\<cal-B\>><around*|(|\<cal-L\><around|[|z,<wide|z|\<dot\>>|]>+i*p*<frac|1|V<around|(|z|)>>|)>*d*t>*<frac|e<rsup|-<frac|<around*|[|X<rsub|\<cal-B\>>-\<Upsilon\><around*|(|z|)>|]><rsup|2>|2*<around*|(|1-\<rho\><rsup|2>|)>*\<cal-B\>>>|<sqrt|2*\<pi\>*<around*|(|1-\<rho\><rsup|2>|)>*\<cal-B\>>>,>>>>>

  where

  <\equation>
    <label|Upsilon>\<Upsilon\><around*|(|z|)>=\<rho\>*<around*|(|z<rsub|\<cal-B\>>-z<rsub|0>-<big|int><rsub|0><rsup|\<cal-B\>>\<cal-A\><around*|(|z<around|(|t|)>|)>*d*t|)>+r*\<cal-T\><rsub|<mathcal>>*B-<frac|\<cal-B\>|2>.
  </equation>

  In order to add the <math|z> dependent term
  <math|\<Upsilon\><around*|(|z|)>> to the Lagrangian of the <math|z> path
  integral one can introduce another Fourier integral, and
  <math|\<cal-P\>*<around*|(|X<rsub|\<cal-B\>>,z<rsub|<mathcal>>*B,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>y<rsub|0>,z<rsub|0>,0|)>>
  then becomes:

  <align|<tformat|<table|<row|<cell|<label|P3join>>|<cell|\<cal-P\>*<around*|(|X<rsub|\<cal-B\>>,z<rsub|<mathcal>>*B,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>y<rsub|0>,z<rsub|0>,0|)><no-number>>>|<row|<cell|=>|<cell|<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*l|2*\<pi\>>*<space|0.17em>e<rsup|i*<space|0.17em>l*X<rsub|<mathcal>>*B-<frac|<around*|(|1-\<rho\><rsup|2>|)>*\<cal-B\>|2>*l<rsup|2>>*<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*p|2*\<pi\>>*<space|0.17em>e<rsup|i*p*\<cal-T\><rsub|<mathcal>>*B>*<no-number>>>|<row|<cell|>|<cell|\<times\><big|int>\<cal-D\>*z<around|(|t|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|\<cal-B\>><around*|[|\<cal-L\><around|[|z,<wide|z|\<dot\>>|]>+i*p*<frac|1|V<around|(|z|)>>+i*l*\<Upsilon\><around*|(|z|)>|]>*d*t>.>>>>>

  Whether our approach will lead to closed-form pricing formulas for timer
  options will depend on the Lagrangian <math|\<cal-L\><around|[|z,<wide|z|\<dot\>>|]>+i*p*<frac|1|V<around|(|z|)>>+i*l*\<Upsilon\><around*|(|z|)>>.
  More precisely this means that <math|\<cal-A\><around*|(|z<around|(|t|)>|)>>
  and <math|\<Upsilon\><around*|(|z|)>> should be well behaved enough in
  terms of <math|z>. For the two examples illustrated in this paper, the
  functions <math|\<alpha\><around|(|V<around|(|t|)>|)>> and
  <math|\<beta\><around|(|V<around|(|t|)>|)>> are as such that
  <math|\<Upsilon\><around*|(|z|)>> is only a function of
  <math|z<rsub|<mathcal>>*B> and <math|\<cal-T\><rsub|<mathcal>>*B>, denoted
  by <math|\<Upsilon\>*<around*|(|z<rsub|<mathcal>>*B,\<cal-T\><rsub|<mathcal>>*B|)>>.
  Then it is not necessary to introduce the Fourier transform of expression
  (<reference|P3join>) and we can proceed with expression (<reference|PXzT>).
  Now the price of a perpetual timer option which is given by

  <align|<tformat|<table|<row|<cell|<label|CPerp0>\<cal-C\><rsub|P*e*r*p>=>|<cell|<big|int>d*X<rsub|<mathcal>>*B*<big|int>d*z<rsub|<mathcal>>*B*<big|int>d*\<cal-T\><rsub|<mathcal>>*B*<space|0.17em>\<cal-P\>*<around*|(|X<rsub|<mathcal>>*B,z<rsub|<mathcal>>*B,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>y<rsub|0>,z<rsub|0>,0|)><no-number>>>|<row|<cell|>|<cell|\<times\><around*|[|e<rsup|-r*\<cal-T\><rsub|<mathcal>>*B>*<space|0.17em><with|font-family|rm|m*a*x>*<around*|(|S<rsub|0>*<space|0.17em>e<rsup|X<rsub|\<cal-B\>>>-K,0|)>|]>,>>>>>

  can be written as:

  <\equation>
    <label|CPerp>\<cal-C\><rsub|P*e*r*p>=<big|int><rsub|0><rsup|\<infty\>>d*\<cal-T\><rsub|<mathcal>>*B*<big|int><rsub|-\<infty\>><rsup|\<infty\>>d*z<rsub|\<cal-B\>>*\<cal-P\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>z<rsub|0>,0|)><space|0.17em><wide|\<cal-C\>|\<bar\>><around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B|)>,
  </equation>

  with <math|<wide|\<cal-C\>|\<bar\>><around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B|)>>
  being the prices conditional on <math|z>:

  <align|<tformat|<table|<row|<cell|<label|C2>>|<cell|<wide|\<cal-C\>|\<bar\>><around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B|)><no-number>>>|<row|<cell|=>|<cell|<big|int><rsub|-\<infty\>><rsup|\<infty\>>d*X<rsub|\<cal-B\>>*<space|0.17em><frac|e<rsup|-<frac|<around*|[|X<rsub|\<cal-B\>>-\<Upsilon\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B|)>|]><rsup|2>|2*<around*|(|1-\<rho\><rsup|2>|)>*\<cal-B\>>>|<sqrt|2*\<pi\>*<around*|(|1-\<rho\><rsup|2>|)>*\<cal-B\>>>*<around*|[|e<rsup|-r*\<cal-T\><rsub|<mathcal>>*B>*<space|0.17em><with|font-family|rm|m*a*x>*<around*|(|S<rsub|0>*<space|0.17em>e<rsup|X<rsub|\<cal-B\>>>-K,0|)>|]><no-number>>>|<row|<cell|=>|<cell|S<rsub|0>*<space|0.17em>e<rsup|\<Upsilon\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B|)>-r*\<cal-T\><rsub|<mathcal>>*B+<frac|<around|(|1-\<rho\><rsup|2>|)>*\<cal-B\>|2>>*<space|0.17em>\<cal-N\><around*|(|d<rsub|+>|)>-K*<space|0.17em>e<rsup|-r*\<cal-T\><rsub|<mathcal>>*B>*\<cal-N\><around|(|d<rsub|->|)>,>>>>>

  where <math|\<cal-N\><around|(|\<cdummy\>|)>> is the cumulative
  distribution for the normal random variable and

  <align|<tformat|<table|<row|<cell|d<rsub|+>=>|<cell|<frac|ln
  <frac|S<rsub|0>|K>+<around*|(|1-\<rho\><rsup|2>|)>*\<cal-B\>+\<Upsilon\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B|)>|<sqrt|<around*|(|1-\<rho\><rsup|2>|)>*\<cal-B\>>>,>>|<row|<cell|d<rsub|->=>|<cell|<frac|ln
  <frac|S<rsub|0>|K>+\<Upsilon\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B|)>|<sqrt|<around*|(|1-\<rho\><rsup|2>|)>*\<cal-B\>>>,>>>>>

  and <math|\<cal-P\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>z<rsub|0>,0|)>>
  is given by

  <\equation>
    <label|PXzT2>\<cal-P\>*<around*|(|z<rsub|<mathcal>>*B,\<cal-T\><rsub|<mathcal>>*B\|z<rsub|0>,0|)>=<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*p|2*\<pi\>>*e<rsup|i*p*\<cal-T\><rsub|<mathcal>>*B>*<big|int>\<cal-D\>*z*e<rsup|-<big|int><rsub|0><rsup|\<cal-B\>><around*|(|\<cal-L\><around|[|z,<wide|z|\<dot\>>|]>+<frac|i*p|V<around|(|z|)>>|)>*d*t>.
  </equation>

  Note that expression (<reference|C2>) is a Black-Scholes-Merton type
  pricing formula for perpetual timer options. To determine the price of a
  perpetual timer option for a particular model one needs to evaluate
  <math|\<Upsilon\>*<around*|(|z<rsub|<mathcal>>*B,\<cal-T\><rsub|<mathcal>>*B|)>>
  in order to obtain <math|<wide|\<cal-C\>|\<bar\>><around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B|)>>.
  Furthermore if we also have the analytical expression for the joint
  propagator <math|\<cal-P\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>z<rsub|0>,0|)>>,
  formula (<reference|CPerp>) demonstrates that the closed-form perpetual
  timer option pricing formula can be derived through two trivial integrals.

  <subsection|Pricing of finite time-horizon timer options>

  In this subsection we consider the pricing of finite time-horizon timer
  option.

  Let the maximum expiry time to be <math|T>, then the price of a finite
  time-horizon timer option, denoted by <math|\<cal-C\><rsub|F*i*n*i>>, of
  strike price <math|K> can be expressed as a sum of two contributions:

  <\equation>
    \<cal-C\><rsub|F*i*n*i>=\<cal-C\><rsub|1>+\<cal-C\><rsub|2>,
  </equation>

  where

  <\equation>
    \<cal-C\><rsub|1>=<big|int><rsub|0><rsup|T>d*\<cal-T\><rsub|<mathcal>>*B*<big|int><rsub|-\<infty\>><rsup|\<infty\>>d*z<rsub|\<cal-B\>>*\<cal-P\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>z<rsub|0>,0|)><space|0.17em><wide|\<cal-C\>|\<bar\>><around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B|)>
  </equation>

  is the contribution from paths that exhausted their variance budget before
  time <math|T>, and

  <\equation>
    \<cal-C\><rsub|2>=<space|0.17em>e<rsup|-r*T>*<big|int><rsub|-\<infty\>><rsup|\<infty\>><around*|(|S<rsub|0>*<space|0.17em>e<rsup|x<rsub|T>>-K|)><rsub|+>*\<cal-P\><rsub|<mathcal>>*B<around*|(|x<rsub|T><space|0.17em>\|x<rsub|0><space|0.17em>|)>*d*x<rsub|T>
  </equation>

  is the contribution from paths that reach the preset finite time horizon.
  Note the integration range of <math|\<cal-T\><rsub|<mathcal>>*B> in
  <math|\<cal-C\><rsub|1>>, which is truncated by the maximum expiry time
  <math|T>.

  Denote the joint propagator of the log-return and the realized variance as
  <math|\<cal-P\><around*|(|x<rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>,0|)>>,
  then

  <\equation>
    <label|PB>\<cal-P\><rsub|<mathcal>>*B<around*|(|x<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>|)>=<big|int><rsub|0><rsup|<mathcal>>B*\<cal-P\><around*|(|x<rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>,0|)>*d*I<rsub|T>.
  </equation>

  Note <math|\<cal-P\><rsub|<mathcal>>*B<around*|(|x<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>|)>>
  is not the propagator of <math|x> that should be used for the European
  vanilla option, which represents the probability that <math|x> has the
  value <math|x<rsub|T>> at later time <math|T> given the initial values
  <math|x<rsub|0>> at time <math|0>. Instead
  <math|\<cal-P\><rsub|<mathcal>>*B<around*|(|x<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>|)>>
  in <math|\<cal-C\><rsub|2>> is the propagator of <math|x> which is also
  conditioned on the fact that the realized variance budget of each path has
  not been exhausted before the maximum expiry time <math|T>.

  Furthermore, if <math|\<cal-P\><rsub|<mathcal>>*B<around*|(|x<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>|)>>
  can be written as a Fourier integral:

  <\equation>
    \<cal-P\><rsub|<mathcal>>*B<around*|(|x<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>|)>=<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*l|2*\<pi\>>*<space|0.17em>e<rsup|i*l*<around*|(|x<rsub|T>-r*T|)>>*\<cal-F\><around|(|l|)>,
  </equation>

  then by following the derivation outlined in <cite|Kleinert2004>, we can
  rewrite <math|\<cal-C\><rsub|2>> explicitly, and thus the pricing formula
  of finite time-horizon Timer option as

  <align|<tformat|<table|<row|<cell|<label|CFini>\<cal-C\><rsub|F*i*n*i>=>|<cell|<big|int><rsub|0><rsup|T>d*\<cal-T\><rsub|<mathcal>>*B*<big|int><rsub|-\<infty\>><rsup|\<infty\>>d*z<rsub|\<cal-B\>>*\<cal-P\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>z<rsub|0>,0|)><space|0.17em><wide|\<cal-C\>|\<bar\>><around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B|)><no-number>>>|<row|<cell|>|<cell|+<frac|\<cal-G\><around|(|0|)>|2>+i*<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*l|2*\<pi\>>*<frac|e<rsup|i*l*<around*|(|ln
  <frac|K|S<rsub|0>>-r*T|)>>*\<cal-G\><around|(|l|)>|l>,>>>>>

  where

  <\equation>
    \<cal-G\><around|(|l|)>=S<rsub|0>*\<cal-F\>*<around|(|l+i|)>-K*<space|0.17em>e<rsup|-r*T>*\<cal-F\><around|(|l|)>.
  </equation>

  The integration of <math|\<cal-P\><rsub|<mathcal>>*B<around*|(|x<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>|)>>
  over all possible <math|x<rsub|T>>'s gives <math|\<cal-F\><around|(|0|)>>,
  which is the "survival probability" describing the probability that the
  underling asset is executed at the maximum expiry time <math|T>. This
  survival probability can also be determined by
  <math|<big|int><rsub|T><rsup|\<infty\>>d*\<cal-T\><rsub|<mathcal>>*B*<big|int>d*z<rsub|<mathcal>>*B*\<cal-P\>*<around*|(|z<rsub|<mathcal>>*B,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>z<rsub|0>,0|)>>,
  from which it is clear that this probability is independent from the
  evolution of <math|x>, thus does not depend on the correlation coefficient
  <math|\<rho\>>.

  For finite time-horizon timer option, besides the evaluation of propagator
  <math|\<cal-P\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>z<rsub|0>,0|)>>
  as for the perpetual timer option, we must also calculate the propagator
  <math|\<cal-P\><around*|(|x<rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>,0|)>>
  to derive the formula of <math|\<cal-F\><around|(|l|)>>.

  <section|Propagators for the 3/2 and the Heston model><label|Propagators>

  In this section we focus on the derivations of joint propagators
  <math|\<cal-P\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>z<rsub|0>,0|)>>
  and <math|\<cal-P\><around*|(|x<rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>,0|)>>.
  These are used in section <reference|Disc> in conjunction with expressions
  (<reference|CPerp>) and (<reference|CFini>) from the previous section to
  price perpetual and finite time-horizon timer options, respectively. Note
  that <math|\<cal-P\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>z<rsub|0>,0|)>>
  is evaluated in the pseudotime horizon and
  <math|\<cal-P\><around*|(|x<rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>,0|)>>
  in the original time horizon. The 3/2 and the Heston model are chosen both
  from mathematical and empirical considerations.

  As mentioned in the previous section, it is convenient to choose models
  such that <math|<big|int><rsub|0><rsup|<mathcal>>B*\<cal-A\><around*|(|z<around|(|t|)>|)>*d*t>
  is a function of <math|z<rsub|<mathcal>>*B> and
  <math|\<cal-T\><rsub|<mathcal>>*B>. In addition, from the perspective of
  mathematics, the total Lagrangian in expression (<reference|PXzT2>):

  <\equation>
    \<cal-L\><rsub|T*o*t><around|[|z,<wide|z|\<dot\>>|]>=\<cal-L\><around|[|z,<wide|z|\<dot\>>|]>+<frac|i*p|V<around|(|z|)>>
  </equation>

  written in terms of <math|z> and <math|<wide|z|\<dot\>>> should be well
  behaved enough to achieve a closed-form solution with the path integral.

  Furthermore there is substantial empirical evidence supporting the
  stochastic differential equation underlying the 3/2 model. The Heston
  model, on the other hand, is important because it is a standard model for
  the financial industry.

  <subsection|The 3/2 model and the Morse potential>

  The model dynamics of the 3/2 stochastic volatility model <cite|Ahn> is
  given by:

  <\equation>
    <label|dv32>d*v<around|(|t|)>=\<kappa\>*v*<around*|(|\<theta\>-v|)>*d*t+\<epsilon\>*v<rsup|3/2>*d*W<rsub|2>.
  </equation>

  Relating this model to the general stochastic volatility model used in
  (<reference|dv>), we have

  <align|<tformat|<table|<row|<cell|\<alpha\><around*|(|V|)>=>|<cell|\<kappa\>*V*<around*|(|\<theta\>-V|)>,>>|<row|<cell|\<beta\><around*|(|V|)>=>|<cell|\<epsilon\>*V<rsup|3/2>.>>>>>

  For calculation convenience, we multiply <math|z<around|(|t|)>> defined in
  expression (<reference|z>) by a factor <math|-\<epsilon\>> to obtain

  <\equation>
    z<around|(|t|)>=-ln V<around|(|t|)>.
  </equation>

  Thus, according to equations (<reference|T>), (<reference|A>) and
  (<reference|Upsilon>), we have

  <eqnarray|<tformat|<table|<row|<cell|\<cal-T\><rsub|<mathcal>>*B>|<cell|=>|<cell|<big|int><rsub|0><rsup|\<cal-B\>>e<rsup|z<around|(|t|)>>*d*t,<eq-number>>>|<row|<cell|<big|int><rsub|0><rsup|\<cal-B\>>\<cal-A\><around*|(|z<around|(|t|)>|)>*d*t>|<cell|=>|<cell|<frac|\<kappa\>*\<theta\>|\<epsilon\>>*\<cal-T\><rsub|<mathcal>>*B-<around*|(|<frac|\<kappa\>|\<epsilon\>>+<frac|\<epsilon\>|2>|)>*\<cal-B\><eq-number>>>|<row|<cell|\<Upsilon\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B|)>>|<cell|=>|<cell|-<frac|\<rho\>|\<epsilon\>>*<around*|(|z<rsub|\<cal-B\>>+ln
  v<rsub|0>|)>+r*\<cal-T\><rsub|<mathcal>>*B-<frac|\<cal-B\>|2>>>|<row|<cell|>|<cell|>|<cell|-\<rho\>*<around*|(|<frac|\<kappa\>*\<theta\>|\<epsilon\>>*\<cal-T\><rsub|<mathcal>>*B-<around*|(|<frac|\<kappa\>|\<epsilon\>>+<frac|\<epsilon\>|2>|)>*\<cal-B\>|)>,<eq-number><label|Upsilon32>>>>>>

  Therefore the total Lagrangian is

  <align|<tformat|<table|<row|<cell|\<cal-L\><rsub|T*o*t><around|[|z,<wide|z|\<dot\>>|]>>|<cell|=<frac|1|2*\<epsilon\><rsup|2>>*<wide|z|\<dot\>><rsup|2>+<frac|\<kappa\><rsup|2>*\<theta\><rsup|2>|2*\<epsilon\><rsup|2>>*<space|0.17em>e<rsup|2*z>-<around*|(|<frac|\<kappa\><rsup|2>*\<theta\>|\<epsilon\><rsup|2>>+\<kappa\>*\<theta\>-i*p|)>*<space|0.17em>e<rsup|z>*<no-number>>>|<row|<cell|>|<cell|+<frac|\<kappa\>*\<theta\>|\<epsilon\><rsup|2>>*<space|0.17em>e<rsup|z>*<wide|z|\<dot\>>-<around*|(|<frac|\<kappa\>|\<epsilon\><rsup|2>>+<frac|1|2>|)>*<wide|z|\<dot\>>+<frac|<around*|(|\<kappa\>+\<epsilon\><rsup|2>/2|)><rsup|2>|2*\<epsilon\><rsup|2>>.>>>>>

  The nontrivial terms of <math|\<cal-L\><rsub|T*o*t*a><around|[|z,<wide|z|\<dot\>>|]>>
  reveal that <math|z<around|(|t|)>> is subjected to a Morse potential. By
  making use of the known path integral for the Morse potential
  <cite|Grosche>, see Appendix <reference|Morse>, the joint propagator is
  expressed as

  <align|<tformat|<table|<row|<cell|>|<cell|\<cal-P\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>z<rsub|0>,0|)><no-number>>>|<row|<cell|=>|<cell|<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*p|2*\<pi\>>*<space|0.17em>e<rsup|i*p*\<cal-T\><rsub|<mathcal>>*B>*<big|int>\<cal-D\>*z<around|(|t|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|\<cal-B\>>\<cal-L\><rsub|T*o*t><around|[|z,<wide|z|\<dot\>>|]>*d*t>*<no-number>>>|<row|<cell|=>|<cell|e<rsup|-<frac|\<kappa\>*\<theta\>|\<epsilon\><rsup|2>>*<around*|(|e<rsup|z<rsub|\<cal-B\>>>-e<rsup|z<rsub|0>>|)>>*<space|0.17em>e<rsup|<around*|(|<frac|\<kappa\>|\<epsilon\><rsup|2>>+<frac|1|2>|)>*<around|(|z<rsub|\<cal-B\>>-z<rsub|0>|)>>*<space|0.17em>e<rsup|-<frac|<around*|(|\<kappa\>+<frac|\<epsilon\><rsup|2>|2>|)><rsup|2>*\<cal-B\>|2*\<epsilon\><rsup|2>>>*<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*p|2*\<pi\>>*<no-number>>>|<row|<cell|>|<cell|\<times\><space|0.17em>e<rsup|i*p*\<cal-T\><rsub|<mathcal>>*B>*<big|int>\<cal-D\>*z<around|(|t|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|\<cal-B\>><around*|[|<frac|<wide|z|\<dot\>><rsup|2>|2*\<epsilon\><rsup|2>>+<frac|\<kappa\><rsup|2>*\<theta\><rsup|2>|2*\<epsilon\><rsup|2>>*<space|0.17em>e<rsup|2*z>-<around*|(|<frac|\<kappa\><rsup|2>*\<theta\>|\<epsilon\><rsup|2>>+\<kappa\>*\<theta\>-i*p|)>*<space|0.17em>e<rsup|z>|]>*d*t>*<no-number>>>|<row|<cell|=>|<cell|<frac|\<kappa\>*\<theta\>|\<epsilon\><rsup|2>*sinh
  <frac|\<kappa\>*\<theta\>*\<cal-T\><rsub|<mathcal>>*B|2>>*<space|0.17em>e<rsup|-<frac|\<kappa\>*\<theta\>|\<epsilon\><rsup|2>>*<around*|(|e<rsup|z<rsub|\<cal-B\>>>-e<rsup|z<rsub|0>>|)>+<around*|(|<frac|\<kappa\>|\<epsilon\><rsup|2>>+<frac|1|2>|)>*<around*|(|z<rsub|\<cal-B\>>-z<rsub|0>|)>>*<no-number>>>|<row|<cell|>|<cell|\<times\><space|0.17em>e<rsup|-<around*|(|<frac|\<kappa\>|\<epsilon\><rsup|2>>+<frac|1|2>|)><rsup|2>*<frac|\<epsilon\><rsup|2>|2>*\<cal-B\>+<around*|(|<frac|\<kappa\>|\<epsilon\><rsup|2>>+1|)>*\<kappa\>*\<theta\>*\<cal-T\><rsub|<mathcal>>*B-<frac|\<kappa\>*\<theta\>|\<epsilon\><rsup|2>>*<around*|(|e<rsup|z<rsub|<mathcal>>*B>+e<rsup|z<rsub|0>>|)>*coth
  <frac|\<kappa\>*\<theta\>*\<cal-T\><rsub|<mathcal>>*B|2>>*<no-number>>>|<row|<cell|>|<cell|\<times\><big|int><rsub|0><rsup|\<infty\>><frac|d*\<Phi\><rsub|I>|\<pi\>>*<with|font-family|rm|R*e><around*|[|<space|0.17em>e<rsup|\<Phi\>*\<cal-B\>>*<space|0.17em>I<rsub|2*<sqrt|<frac|2|\<epsilon\><rsup|2>>*\<Phi\>>><around*|(|<frac|<frac|2*\<kappa\>*\<theta\>|\<epsilon\><rsup|2>>*<space|0.17em>e<rsup|<frac|z<rsub|<mathcal>>*B+z<rsub|0>|2>>|sinh
  <frac|\<kappa\>*\<theta\>*\<cal-T\><rsub|<mathcal>>*B|2>>|)>|]>,<label|PzBTB32>>>>>>

  with <math|I<rsub|.>*<around*|(|\<cdot\>|)>> the modified Bessel function
  of the first kind, and under the condition that the real part of the
  integration variable satisfies

  <\equation>
    \<Phi\><rsub|R>\<gtr\><frac|2|\<epsilon\><rsup|2>>*<around*|(|<frac|\<kappa\>|\<epsilon\><rsup|2>>+<frac|1|2>|)><rsup|2>,
  </equation>

  according to (<reference|Restriction2>).

  Plugging expressions (<reference|Upsilon32>) and (<reference|PzBTB32>) into
  formula (<reference|CPerp>) yields the closed-form pricing formula for the
  perpetual timer call options under the 3/2 model.

  The integral over all possible <math|z<rsub|\<cal-B\>>> can be done
  analytically, which leads to the marginal propagator for the stopping time
  <math|\<cal-T\><rsub|<mathcal>>*B>:

  <align|<tformat|<table|<row|<cell|\<cal-P\>*<around*|(|\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>0|)>=>|<cell|<frac|\<kappa\>*\<theta\>|\<epsilon\><rsup|2>>*<around*|(|1+coth
  <frac|\<kappa\>*\<theta\>*\<cal-T\><rsub|<mathcal>>*B|2>|)>*<space|0.17em>e<rsup|-<around*|(|<frac|\<kappa\>|\<epsilon\><rsup|2>>+<frac|1|2>|)><rsup|2>*<frac|\<epsilon\><rsup|2>|2>*\<cal-B\>>*<no-number>>>|<row|<cell|>|<cell|\<times\><big|int><rsub|0><rsup|\<infty\>><frac|d*\<Phi\><rsub|I>|\<pi\>>*<space|0.17em>e<rsup|\<Phi\>*\<cal-B\>><around*|(|<frac|\<cal-N\>|v<rsub|0>>|)><rsup|\<cal-M\>><frac|\<Gamma\>*<around*|(|2*<sqrt|<frac|2|\<epsilon\><rsup|2>>*\<Phi\>>-\<cal-M\>|)>|\<Gamma\>*<around*|(|2*<sqrt|<frac|2|\<epsilon\><rsup|2>>*\<Phi\>>+1|)>>*<no-number>>>|<row|<cell|>|<cell|\<times\><space|0.17em><rsub|1>F<rsub|1>*<around*|(|\<cal-M\>+1;<space|0.17em>2*<sqrt|<frac|2|\<epsilon\><rsup|2>>*\<Phi\>>+1;<space|0.17em>-<frac|\<cal-N\>|v<rsub|0>>|)>,>>>>>

  where <math|\<Gamma\>*<around*|(|\<cdot\>|)>> is the Euler gamma function,
  <math|<space|0.17em><rsub|1>F<rsub|1>*<around*|(|\<cdot\>;\<cdot\>;\<cdot\>|)>>
  is the confluent hypergeometric function, and

  <align|<tformat|<table|<row|<cell|\<cal-N\>*<around|(|\<cal-T\><rsub|<mathcal>>*B|)>>|<cell|=<frac|\<kappa\>*\<theta\>|\<epsilon\><rsup|2>>*<around*|(|coth
  <frac|\<kappa\>*\<theta\>*\<cal-T\><rsub|<mathcal>>*B|2>-1|)>,>>|<row|<cell|\<cal-M\><around*|(|\<Phi\>|)>>|<cell|=<sqrt|<frac|2|\<epsilon\><rsup|2>>*\<Phi\>>-<around*|(|<frac|\<kappa\>|\<epsilon\><rsup|2>>+<frac|1|2>|)>.>>>>>

  <with|par-columns|1|<big-figure|<with|par-mode|center|<image|f1.eps|3in|||>
  <image|f2.eps|3in|||> <image|f3.eps|3in|||>
  <image|f4.eps|3in|||><next-line><label|fig1>>|(Color online, two columns)
  This figure shows several aspects of the time evolution of variables
  relevant for timer options under the 3/2 stochastic volatility model. The
  upper left panel shows several simulated variance paths up to the point
  where the realized variance reached <math|\<cal-B\>>. The bottom left panel
  shows corresponding log-return paths. The inset of the upper left panel
  shows the probability distribution of the stopping time
  <math|\<cal-T\><rsub|<mathcal>>*B>. The inset of the bottom left panel
  shows the density <math|\<cal-P\><rsub|<mathcal>>*B<around*|(|x<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>|)>>
  determined by expression (<reference|PB>). The upper right panel shows the
  joint probability distribution of the variance and the stopping time. The
  bottom right panel shows the joint probability distribution of the
  log-return and the realized variance. The parameters used here are:
  <math|v<rsub|0>=<around|(|0.295|)><rsup|2>,\<kappa\>=22.84,\<theta\>=<around|(|0.4669|)><rsup|2>,\<epsilon\>=8.56,\<cal-B\>=v<rsub|0>,r=0.015,\<rho\>=-0.5,T=1.5>.>>

  We move on to the calculation of the propagator
  <math|\<cal-P\><around*|(|x<rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>,0|)>>
  by performing the following substitutions

  <align|<tformat|<table|<row|<cell|\<chi\><around|(|t|)>>|<cell|=x-<frac|\<rho\>|\<epsilon\>>*<around*|(|ln
  v-\<kappa\>*\<theta\>*t|)>-r*t,>>|<row|<cell|\<zeta\><around|(|t|)>>|<cell|=<frac|1|<sqrt|v>>,>>>>>

  which lead to two uncorrelated processes:

  <align|<tformat|<table|<row|<cell|d*\<chi\><around|(|t|)>=>|<cell|<around*|(|-<frac|1|2>+<frac|\<rho\>*\<kappa\>|\<epsilon\>>+<frac|\<rho\>*<space|0.17em>\<epsilon\>|2>|)>*v*d*t+<sqrt|v>*<sqrt|1-\<rho\><rsup|2>>*d*W<rsub|1>,>>|<row|<cell|d*\<zeta\><around|(|t|)>=>|<cell|<around*|[|-<frac|\<kappa\>*\<theta\>|2>*\<zeta\>+<around*|(|<frac|\<kappa\>|2>+<frac|3|8>*\<epsilon\><rsup|2>|)>*<frac|1|\<zeta\>>|]>*d*t-<frac|\<epsilon\>|2>*d*W<rsub|2>,>>>>>

  and thus the corresponding Lagrangians:

  <align|<tformat|<table|<row|<cell|\<cal-L\><around|[|\<chi\>,<wide|\<chi\>|\<dot\>>,v|]>>|<cell|=<frac|<around*|[|<wide|\<chi\>|\<dot\>>-<around*|(|-<frac|1|2>+<frac|\<rho\>*\<kappa\>|\<epsilon\>>+<frac|\<rho\>*<space|0.17em>\<epsilon\>|2>|)>*v|]><rsup|2>|2*v*<around*|(|1-\<rho\><rsup|2>|)>>,>>|<row|<cell|\<cal-L\><around|[|\<zeta\>,<wide|\<zeta\>|\<dot\>>|]>>|<cell|=\<cal-L\><rsub|1><around|[|\<zeta\>|]>+\<cal-L\><rsub|2><around|[|\<zeta\>|]>,>>>>>

  where

  <align|<tformat|<table|<row|<cell|\<cal-L\><rsub|1><around|[|\<zeta\>,<wide|\<zeta\>|\<dot\>>|]>>|<cell|=<frac|2|\<epsilon\><rsup|2>>*<around*|[|<wide|\<zeta\>|\<dot\>><rsup|2>+<frac|\<kappa\><rsup|2>*\<theta\><rsup|2>|4>*\<zeta\><rsup|2>|]>+<frac|<around*|(|<frac|2*\<kappa\>|\<epsilon\><rsup|2>>+1|)><rsup|2>-<frac|1|4>|8/\<epsilon\><rsup|2>>*<frac|1|\<zeta\><rsup|2>>,>>|<row|<cell|\<cal-L\><rsub|2><around|[|\<zeta\>,<wide|\<zeta\>|\<dot\>>|]>>|<cell|=<frac|2*\<kappa\>*\<theta\>|\<epsilon\><rsup|2>>*\<zeta\>*<wide|\<zeta\>|\<dot\>>-<around*|(|<frac|2*\<kappa\>|\<epsilon\><rsup|2>>+<frac|3|2>|)>*<frac|<wide|\<zeta\>|\<dot\>>|\<zeta\>>-<around*|(|<frac|\<kappa\><rsup|2>*\<theta\>|\<epsilon\><rsup|2>>+\<kappa\>*\<theta\>|)>.>>>>>

  Since <math|\<chi\>> is independent from <math|\<zeta\>>, so the
  probability that <math|\<chi\>> goes to <math|\<chi\><rsub|T>>,
  <math|\<zeta\>> goes to <math|\<zeta\><rsub|T>> and the realized variance
  reaches <math|I<rsub|T>> at a later time <math|T> given the original
  positions <math|\<chi\><rsub|0>>, <math|\<zeta\><rsub|0>> and
  <math|I<rsub|0>=0> at the initial time <math|0> is

  <align|<tformat|<table|<row|<cell|>|<cell|\<cal-P\><around|(|\<chi\><rsub|T>,\<zeta\><rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>\<chi\><rsub|0>,\<zeta\><rsub|0>,0|)><no-number>>>|<row|<cell|=>|<cell|<big|int>\<cal-D\>*\<zeta\><around|(|t|)>*<space|0.17em>\<delta\>*<around*|(|I<rsub|T>-<big|int><rsub|0><rsup|T>v<around|(|t|)>*<space|0.17em>d*t|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|T>\<cal-L\><around|[|\<zeta\>,<wide|\<zeta\>|\<dot\>>|]>*d*t>*<no-number>>>|<row|<cell|>|<cell|\<times\><big|int>\<cal-D\>*\<chi\><around|(|t|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|T>\<cal-L\><around|[|\<chi\>,<wide|\<chi\>|\<dot\>>,v|]>*d*t>*<no-number>>>|<row|<cell|=>|<cell|<around*|(|<frac|\<zeta\><rsub|T>|\<zeta\><rsub|0>>|)><rsup|<frac|2*\<kappa\>|\<epsilon\><rsup|2>>+<frac|3|2>>*<space|0.17em>e<rsup|-<frac|\<kappa\>*\<theta\>|\<epsilon\><rsup|2>>*<around|(|\<zeta\><rsub|T><rsup|2>-\<zeta\><rsub|0><rsup|2>|)>+<around*|(|<frac|\<kappa\><rsup|2>*\<theta\>|\<epsilon\><rsup|2>>+\<kappa\>*\<theta\>|)>*T>*<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*p|2*\<pi\>>*<space|0.17em>e<rsup|i*p*<space|0.17em>I<rsub|T>>*<no-number>>>|<row|<cell|>|<cell|\<times\><big|int><rsub|-\<infty\>><rsup|+\<infty\>><frac|d*l|2*\<pi\>>*<space|0.17em>e<rsup|i*l*<around*|[|x<rsub|T>+<frac|\<rho\>*\<kappa\>*\<theta\>|\<epsilon\>>*T-r*T|]>><around*|(|<frac|\<zeta\><rsub|T>|\<zeta\><rsub|0>>|)><rsup|2*i*l*<frac|\<rho\>|\<epsilon\>>><no-number>>>|<row|<cell|>|<cell|\<times\><big|int>\<cal-D\>*\<zeta\><around|(|t|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|T><around*|[|\<cal-L\><rsub|1><around|[|\<zeta\>,<wide|\<zeta\>|\<dot\>>|]>+<frac|i*l*<around*|(|-<frac|1|2>+<frac|\<rho\>*\<kappa\>|\<epsilon\>>+<frac|\<rho\>*\<epsilon\>|2>|)>+<frac|<around|(|1-\<rho\><rsup|2>|)>*l<rsup|2>|2>+<space|0.17em>i*p|\<zeta\><rsup|2>>|]>*d*t>,>>>>>

  where the remaining path integral over <math|\<cal-D\>*\<zeta\><around|(|t|)>>
  of the radial harmonic oscillator potential <cite|Grosche> given by:

  <\equation>
    <frac|2*\<kappa\>*\<theta\>*<sqrt|\<zeta\><rsub|T>*\<zeta\><rsub|0>>|\<epsilon\><rsup|2>*<space|0.17em>sinh
    <around|(|<frac|\<kappa\>*\<theta\>*T|2>|)>>*<space|0.17em>e<rsup|-<frac|\<kappa\>*\<theta\>|\<epsilon\><rsup|2>>*<around*|(|\<zeta\><rsub|T><rsup|2>+\<zeta\><rsub|0><rsup|2>|)>*coth
    <around|(|<frac|\<kappa\>*\<theta\>*T|2>|)>>*<space|0.17em>I<rsub|\<lambda\>><around*|(|<frac|2*\<kappa\>*\<theta\>*<space|0.17em>\<zeta\><rsub|T>*\<zeta\><rsub|0>|\<epsilon\><rsup|2>*<space|0.17em>sinh
    <around|(|<frac|\<kappa\>*\<theta\>*T|2>|)>>|)>,
  </equation>

  with

  <\equation>
    \<lambda\>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|>|<cell|<around*|(|<frac|2*\<kappa\>|\<epsilon\><rsup|2>>+1|)><rsup|2>>>|<row|<cell|>|<cell|+<frac|8|\<epsilon\><rsup|2>>*<around*|[|i*l*<around*|(|-<frac|1|2>+<frac|\<rho\>*\<kappa\>|\<epsilon\>>+<frac|\<rho\>*\<epsilon\>|2>|)>+<frac|<around|(|1-\<rho\><rsup|2>|)>*l<rsup|2>|2>+i*p|]>>>>>>|)><rsup|<frac|1|2>>.
  </equation>

  Integrating over <math|\<zeta\><rsub|T>> leads to
  <math|\<cal-P\><around*|(|\<chi\><rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>\<chi\><rsub|0>,0|)>>:

  <align|<tformat|<table|<row|<cell|<label|chiTIT>>|<cell|\<cal-P\><around*|(|\<chi\><rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>\<chi\><rsub|0>,0|)><no-number>>>|<row|<cell|=>|<cell|<big|int><rsub|0><rsup|\<infty\>>\<cal-P\><around|(|\<chi\><rsub|T>,\<zeta\><rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>\<chi\><rsub|0>,\<zeta\><rsub|0>,0|)>*<space|0.17em>d*\<zeta\><rsub|T>*<no-number>>>|<row|<cell|=>|<cell|<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*p|2*\<pi\>>*<space|0.17em>e<rsup|i*p*<space|0.17em>I<rsub|T>>*<big|int><rsub|-\<infty\>><rsup|+\<infty\>><frac|d*l|2*\<pi\>>*<space|0.17em>e<rsup|i*l*<around*|(|x<rsub|T>-r*T|)>><around*|(|<frac|2|\<epsilon\><rsup|2>*N>|)><rsup|M><no-number>>>|<row|<cell|>|<cell|\<times\><frac|\<Gamma\>*<around|(|\<lambda\>+1-M|)>|\<Gamma\>*<around|(|\<lambda\>+1|)>>*<space|0.17em><rsub|1>F<rsub|1>*<around*|(|M;\<lambda\>+1;-<frac|2|\<epsilon\><rsup|2>*N>|)>,>>>>>

  where

  <align|<tformat|<table|<row|<cell|M>|<cell|=<frac|\<lambda\>|2>-<frac|\<kappa\>|\<epsilon\><rsup|2>>-<frac|1|2>-i*l*<frac|\<rho\>|\<epsilon\>>,>>|<row|<cell|N>|<cell|=<frac|2*sinh
  <around|(|<frac|\<kappa\>*\<theta\>*T|2>|)>|\<kappa\>*\<theta\>>*<space|0.17em>e<rsup|<frac|\<kappa\>*\<theta\>*T|2>>*v<rsub|0>.>>>>>

  Expression (<reference|chiTIT>) agrees with expression (73) in
  <cite|Carr2>.

  According to (<reference|PB>), we have for the 3/2 model

  <\equation>
    <label|PB32>\<cal-P\><rsub|<mathcal>>*B<around*|(|x<rsub|T>,T\|x<rsub|0>,0|)>=<big|int><rsub|-\<infty\>><rsup|+\<infty\>><frac|d*l|2*\<pi\>>*<space|0.17em>e<rsup|i*l*<around*|(|x<rsub|T>-r*T|)>>*\<cal-F\><around|(|l|)>,
  </equation>

  where

  <align|<tformat|<table|<row|<cell|<label|Fl32>\<cal-F\><around|(|l|)>=>|<cell|-i*<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*p|2*\<pi\>>*<frac|e<rsup|i*p*\<cal-B\>>-1|p><around*|(|<frac|2|\<epsilon\><rsup|2>*N>|)><rsup|M><frac|\<Gamma\>*<around|(|\<lambda\>+1-M|)>|\<Gamma\>*<around|(|\<lambda\>+1|)>>*<no-number>>>|<row|<cell|>|<cell|\<times\><space|0.17em><rsub|1>F<rsub|1>*<around*|(|M;\<lambda\>+1;-<frac|2|\<epsilon\><rsup|2>*N>|)>.>>>>>

  The closed-form pricing formula for the finite time-horizon timer call
  options is derived by substituting (<reference|PB32>) and
  (<reference|Fl32>) in expression (<reference|CFini>).

  <subsection|The Heston model and the Kratzer potential>

  For Heston stochastic volatility model <cite|Heston>, the model dynamics is
  written as:

  <\equation>
    <label|dvHes>d*v<around|(|t|)>=\<kappa\>*<around*|(|\<theta\>-v|)>*d*t+\<sigma\>*<sqrt|v>*d*W<rsub|2>.
  </equation>

  To relate this model to the general stochastic volatility model
  (<reference|dv>), <math|\<alpha\><around*|(|V|)>> and
  <math|\<beta\><around*|(|V|)>> are given by

  <align|<tformat|<table|<row|<cell|\<alpha\><around|(|V|)>>|<cell|=\<kappa\>*<around*|(|\<theta\>-V|)>,>>|<row|<cell|\<beta\><around|(|V|)>>|<cell|=\<sigma\>*<sqrt|V>.>>>>>

  From equation (<reference|z>), we have the relation between
  <math|z<around|(|t|)>> and <math|V<around|(|t|)>>:

  <\equation>
    z<around|(|t|)>=<frac|1|\<sigma\>>*V<around|(|t|)>.
  </equation>

  thus the stopping time <math|\<cal-T\><rsub|<mathcal>>*B> is a functional
  of <math|z<around|(|t|)>>:

  <\equation>
    \<cal-T\><rsub|<mathcal>>*B=<frac|1|\<sigma\>>*<big|int><rsub|0><rsup|\<cal-B\>><frac|1|z<around|(|t|)>>*d*t.
  </equation>

  Plugging equations (<reference|dvHes>) and (<reference|dv>) into definition
  (<reference|A>) gives

  <\equation>
    <big|int><rsub|0><rsup|\<cal-B\>>\<cal-A\><around*|(|z<around|(|t|)>|)>*d*t=<frac|\<kappa\>*\<theta\>|\<sigma\>>*\<cal-T\><rsub|<mathcal>>*B-<frac|\<kappa\>|\<sigma\>>*\<cal-B\>,
  </equation>

  therefore (written in original variable <math|v<rsub|0>>)

  <align|<tformat|<table|<row|<cell|\<Upsilon\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B|)>=>|<cell|\<rho\>*<around*|(|z<rsub|\<cal-B\>>-<frac|v<rsub|0>|\<sigma\>>-<frac|\<kappa\>*\<theta\>|\<sigma\>>*\<cal-T\><rsub|<mathcal>>*B+<frac|\<kappa\>|\<sigma\>>*\<cal-B\>|)>+r*\<cal-T\><rsub|<mathcal>>*B-<frac|\<cal-B\>|2>,<label|UpsilonHes>>>|<row|<cell|\<cal-L\><rsub|T*o*t><around|[|z,<wide|z|\<dot\>>|]>=>|<cell|<frac|1|2>*<wide|z|\<dot\>><rsup|2>+<frac|\<lambda\><rsup|2>-<frac|1|4>|2*z<rsup|2>>-<frac|<around*|(|\<lambda\>+<frac|1|2>|)>*\<mu\>-<frac|i*p|\<sigma\>>|z>*<no-number>>>|<row|<cell|>|<cell|-<around*|(|\<lambda\>+<frac|1|2>|)>*<frac|<wide|z|\<dot\>>|z>+\<mu\>*<wide|z|\<dot\>>+<frac|1|2>*\<mu\><rsup|2>,>>>>>

  where

  <\equation>
    \<lambda\>=<frac|\<kappa\>*\<theta\>|\<sigma\><rsup|2>>-<frac|1|2>,<space|1em><space|1em>\<mu\>=<frac|\<kappa\>|\<sigma\>>.
  </equation>

  The nontrivial terms of the total Lagrangian
  <math|\<cal-L\><rsub|T*o*t><around|[|z,<wide|z|\<dot\>>|]>> manifest that
  <math|z<around|(|t|)>> is subjected to a Kratzer potential. With the help
  of the known path integral for Kratzer potential <cite|Grosche>, see
  Appendix <reference|Kratzer>, we obtain the joint propagator as:

  <align|<tformat|<table|<row|<cell|>|<cell|\<cal-P\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>z<rsub|0>,0|)><no-number>>>|<row|<cell|=>|<cell|<big|int>\<cal-D\>*z<around|(|t|)>*<space|0.17em>\<delta\>*<around*|(|\<cal-T\><rsub|<mathcal>>*B-<frac|1|\<sigma\>>*<big|int><rsub|0><rsup|\<cal-B\>><frac|1|z<around|(|t|)>>*d*t|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|\<cal-B\>>\<cal-L\><around|[|z,<wide|z|\<dot\>>|]>*d*t>*<no-number>>>|<row|<cell|=>|<cell|<around*|(|<frac|z<rsub|\<cal-B\>>|z<rsub|0>>|)><rsup|\<lambda\>+<frac|1|2>>*<space|0.17em>e<rsup|-\<mu\>*<around*|(|z<rsub|\<cal-B\>>-z<rsub|0>|)>-<frac|1|2>*\<mu\><rsup|2>*\<cal-B\>>*<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*p|2*\<pi\>>*<space|0.17em>e<rsup|i*p*\<cal-T\><rsub|<mathcal>>*B>*<no-number>>>|<row|<cell|>|<cell|\<times\><big|int>\<cal-D\>*z<around|(|t|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|\<cal-B\>><around*|[|<frac|1|2>*<wide|z|\<dot\>><rsup|2>+<frac|\<lambda\><rsup|2>-<frac|1|4>|2*z<rsup|2>>-<frac|<around*|(|\<lambda\>+<frac|1|2>|)>*\<mu\>-<frac|i*p|\<sigma\>>|z>|]>*d*t>*<no-number>>>|<row|<cell|=>|<cell|<frac|\<sigma\>|2>*<space|0.17em><frac|z<rsub|\<cal-B\>><rsup|\<lambda\>+1>|z<rsub|0><rsup|\<lambda\>>>*<space|0.17em>e<rsup|-\<mu\>*<around*|(|z<rsub|\<cal-B\>>-z<rsub|0>|)>-<frac|1|2>*\<mu\><rsup|2>*\<cal-B\>+<around*|(|\<lambda\>+<frac|1|2>|)>*\<mu\>*\<sigma\>*\<cal-T\><rsub|<mathcal>>*B>*<big|int><rsub|0><rsup|\<infty\>><frac|d*\<Phi\><rsub|I>|\<pi\>>*<no-number>>>|<row|<cell|>|<cell|\<times\><with|font-family|rm|R*e><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|>|<cell|<space|0.17em>e<rsup|\<Phi\>*\<cal-B\>>*<space|0.17em>e<rsup|-<sqrt|2*\<Phi\>>*<around*|(|z<rsub|\<cal-B\>>+z<rsub|0>|)>*coth
  <around*|(|<sqrt|<frac|\<Phi\>|2>>*\<sigma\>*\<cal-T\><rsub|<mathcal>>*B|)>>>>|<row|<cell|>|<cell|\<times\><frac|2*<sqrt|2*\<Phi\>>|sinh
  <around*|(|<sqrt|<frac|\<Phi\>|2>>*\<sigma\>*\<cal-T\><rsub|<mathcal>>*B|)>>*<space|0.17em>I<rsub|2*\<lambda\>><around*|(|<frac|2*<sqrt|2*\<Phi\>>*<sqrt|z<rsub|\<cal-B\>>*z<rsub|0>>|sinh
  <around*|(|<sqrt|<frac|\<Phi\>|2>>*\<sigma\>*\<cal-T\><rsub|<mathcal>>*B|)>>|)>>>>>>|]><label|JoinH1>.>>>>>

  According to the condition given by (<reference|Restriction1>), the real
  part of the complex variable <math|\<Phi\>> must satisfy

  <\equation>
    \<Phi\><rsub|R>\<gtr\><frac|\<kappa\><rsup|2>|2*<space|0.17em>\<sigma\><rsup|2>>.
  </equation>

  Again, plugging the expressions (<reference|UpsilonHes>) and
  (<reference|JoinH1>) into formula (<reference|CPerp>) yields the
  closed-form pricing formula for the perpetual timer call options under the
  Heston model .

  Note the similarity of expression (<reference|JoinH1>) with the result
  obtained in <cite|Li>. Expression (<reference|JoinH1>) has a clear meaning
  as joint transition probability density function which illustrates the
  conciseness of physics; path integration allows to derive expression
  (<math|<reference|JoinH1>>) without applying any previous results of Bessel
  processes as done in <cite|Li>.

  Li <cite|Li> computed the risk-neutral expected maturity in expression
  (5.2) by doing two numerical integrals. Actually, we can derive the
  marginal propagator of the stopping time <math|\<cal-T\><rsub|<mathcal>>*B>
  by integrating over all possible <math|z<rsub|\<cal-B\>>> as follows

  <align|<tformat|<table|<row|<cell|>|<cell|\<cal-P\>*<around*|(|\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>0|)><no-number>>>|<row|<cell|=>|<cell|<big|int><rsub|0><rsup|\<infty\>>\<cal-P\>*<around*|(|z<rsub|\<cal-B\>>,\<cal-T\><rsub|<mathcal>>*B<space|0.17em>\|<space|0.17em>z<rsub|0>,0|)>*d*z<rsub|\<cal-B\>>*<no-number>>>|<row|<cell|=>|<cell|\<sigma\>*<space|0.17em>e<rsup|-<frac|1|2>*\<mu\><rsup|2>*\<cal-B\>+<around*|(|\<lambda\>+<frac|1|2>|)>*\<mu\>*\<sigma\>*\<cal-T\><rsub|<mathcal>>*B>*<big|int><rsub|0><rsup|\<infty\>><frac|d*\<Phi\><rsub|I>|\<pi\>>*<no-number>>>|<row|<cell|>|<cell|\<times\><with|font-family|rm|R*e><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|>|<cell|<space|0.17em>exp
  <around*|{|\<Phi\>*\<cal-B\>+<frac|<around*|(|\<mu\><rsup|2>-2*\<Phi\>|)>*<space|0.17em>z<rsub|0>|\<mu\>+<sqrt|2*\<Phi\>>*coth
  <around*|(|<sqrt|<frac|\<Phi\>|2>>*<space|0.17em>\<sigma\>*\<cal-T\><rsub|<mathcal>>*B|)>>|}>>>|<row|<cell|>|<cell|\<times\><space|0.17em><frac|<around*|(|<frac|<sqrt|2*\<Phi\>>|sinh
  <around*|(|<sqrt|<frac|\<Phi\>|2>>*\<sigma\>*\<cal-T\><rsub|<mathcal>>*B|)>>|)><rsup|2*\<lambda\>+1>|<around*|(|\<mu\>+<sqrt|2*\<Phi\>>*coth
  <around*|(|<sqrt|<frac|\<Phi\>|2>>*<space|0.17em>\<sigma\>*\<cal-T\><rsub|<mathcal>>*B|)>|)><rsup|2*\<lambda\>+2>>>>|<row|<cell|>|<cell|\<times\><around*|(|2*\<lambda\>+1+<frac|<around*|(|<frac|<sqrt|2*\<Phi\>>|sinh
  <around*|(|<sqrt|<frac|\<Phi\>|2>>*\<sigma\>*\<cal-T\><rsub|<mathcal>>*B|)>>|)><rsup|2>*z<rsub|0>|\<mu\>+<sqrt|2*\<Phi\>>*coth
  <around*|(|<sqrt|<frac|\<Phi\>|2>>*<space|0.17em>\<sigma\>*\<cal-T\><rsub|<mathcal>>*B|)>>|)>>>>>>|]>.>>>>>

  For the calculation of <math|\<cal-P\><around*|(|x<rsub|T>,I<rsub|T>\|0,0|)>>,
  we follow the derivation in <cite|Damiaan>. Substitutions

  <align|<tformat|<table|<row|<cell|\<chi\><around|(|t|)>>|<cell|=x-<frac|\<rho\>|\<sigma\>>*<around*|(|v-\<kappa\>*\<theta\>*t|)>-r*t,>>|<row|<cell|\<zeta\><around|(|t|)>>|<cell|=<sqrt|v>,>>>>>

  give two uncorrelated processes:

  <align|<tformat|<table|<row|<cell|d*\<chi\><around|(|t|)>>|<cell|=<around*|(|<frac|\<rho\>*\<kappa\>|\<sigma\>>-<frac|1|2>|)>*v*<space|0.17em>d*t+<sqrt|v>*<sqrt|1-\<rho\><rsup|2>>*d*W<rsub|1>,>>|<row|<cell|d*\<zeta\><around|(|t|)>>|<cell|=<around*|[|<frac|\<kappa\>*\<theta\>-<frac|\<sigma\><rsup|2>|4>|2*\<zeta\>>-<frac|\<kappa\>|2>*\<zeta\>|]>*d*t+<frac|\<sigma\>|2>*d*W<rsub|2>.>>>>>

  The corresponding Lagrangians are:

  <align|<tformat|<table|<row|<cell|\<cal-L\><around*|[|\<chi\>,<wide|\<chi\>|\<dot\>>,v|]>>|<cell|=<frac|1|2*v*<around*|(|1-\<rho\><rsup|2>|)>>*<around*|[|<wide|\<chi\>|\<dot\>>-<around*|(|<frac|\<rho\>*\<kappa\>|\<sigma\>>-<frac|1|2>|)>*v|]><rsup|2>,>>|<row|<cell|\<cal-L\><around|[|\<zeta\>,<wide|\<zeta\>|\<dot\>>|]>>|<cell|=\<cal-L\><rsub|1><around|[|\<zeta\>,<wide|\<zeta\>|\<dot\>>|]>+\<cal-L\><rsub|2><around|[|\<zeta\>,<wide|\<zeta\>|\<dot\>>|]>,>>>>>

  where

  <align|<tformat|<table|<row|<cell|\<cal-L\><rsub|1><around*|[|\<zeta\>,<wide|\<zeta\>|\<dot\>>|]>=>|<cell|<frac|2|\<sigma\><rsup|2>>*<wide|\<zeta\>|\<dot\>><rsup|2>+<frac|<around|(|\<kappa\>*\<theta\>-<frac|\<sigma\><rsup|2>|4>|)>*<around|(|\<kappa\>*\<theta\>-<frac|3*\<sigma\><rsup|2>|4>|)>|2*<space|0.17em>\<sigma\><rsup|2>*\<zeta\><rsup|2>>+<frac|\<kappa\><rsup|2>|2*\<sigma\><rsup|2>>*\<zeta\><rsup|2>,>>|<row|<cell|\<cal-L\><rsub|2><around*|[|\<zeta\>,<wide|\<zeta\>|\<dot\>>|]>=>|<cell|-<around*|(|<frac|2*\<kappa\>*\<theta\>|\<sigma\><rsup|2>>-<frac|1|2>|)>*<frac|<wide|\<zeta\>|\<dot\>>|\<zeta\>>+<frac|2*\<kappa\>|\<sigma\><rsup|2>>*\<zeta\>*<wide|\<zeta\>|\<dot\>>-<frac|\<kappa\><rsup|2>*\<theta\>|\<sigma\><rsup|2>>.>>>>>

  Since <math|\<chi\>> is independent from <math|\<zeta\>>, we similarly have
  the joint propagator of the dynamics of <math|\<chi\>>, <math|\<zeta\>> and
  <math|I>:

  <align|<tformat|<table|<row|<cell|>|<cell|\<cal-P\><around|(|\<chi\><rsub|T>,\<zeta\><rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>\<chi\><rsub|0>,\<zeta\><rsub|0>,0|)><no-number>>>|<row|<cell|=>|<cell|<big|int>\<cal-D\>*\<zeta\><around|(|t|)>*<space|0.17em>\<delta\>*<around*|(|I<rsub|T>-<big|int><rsub|0><rsup|T>v<around|(|t|)>*<space|0.17em>d*t|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|T>\<cal-L\><around|[|\<zeta\>,<wide|\<zeta\>|\<dot\>>|]>*d*t>*<no-number>>>|<row|<cell|>|<cell|\<times\><big|int>\<cal-D\>*\<chi\><around|(|t|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|T>\<cal-L\><around|[|\<chi\>,<wide|\<chi\>|\<dot\>>,v|]>*d*t>*<no-number>>>|<row|<cell|=>|<cell|<around*|(|<frac|\<zeta\><rsub|T>|\<zeta\><rsub|0>>|)><rsup|<frac|2*\<kappa\>*\<theta\>|\<sigma\><rsup|2>>-<frac|1|2>>*<space|0.17em>e<rsup|-<frac|\<kappa\>|\<sigma\><rsup|2>>*<around|(|\<zeta\><rsub|T><rsup|2>-\<zeta\><rsub|0><rsup|2>|)>+<frac|\<kappa\><rsup|2>*\<theta\>|\<sigma\><rsup|2>>*T>*<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*p|2*\<pi\>>*<space|0.17em>e<rsup|i*p*<space|0.17em>I<rsub|T>>*<no-number>>>|<row|<cell|>|<cell|\<times\><big|int><rsub|-\<infty\>><rsup|+\<infty\>><frac|d*l|2*\<pi\>>*<space|0.17em>e<rsup|i*l*<around*|[|x<rsub|T>+<frac|\<rho\>*\<kappa\>*\<theta\>|\<sigma\>>*T-r*T|]>>*<space|0.17em>e<rsup|-i*l*<frac|\<rho\>|\<sigma\>>*<around*|(|\<zeta\><rsub|T><rsup|2>-\<zeta\><rsub|0><rsup|2>|)>>*<no-number>>>|<row|<cell|>|<cell|\<times\><big|int>\<cal-D\>*\<zeta\><around|(|t|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|T><around*|[|\<cal-L\><rsub|1><around|[|\<zeta\>,<wide|\<zeta\>|\<dot\>>|]>+<around*|(|i*l*<around*|(|<frac|\<rho\>*\<kappa\>|\<sigma\>>-<frac|1|2>|)>+<frac|<around*|(|1-\<rho\><rsup|2>|)>*l<rsup|2>|2>+i*p|)>*\<zeta\><rsup|2>|]>*d*t>,>>>>>

  where the path integral for the radial harmonic oscillator potential
  <cite|Grosche> is given by:

  <\equation>
    <frac|4*\<omega\>*<sqrt|\<zeta\><rsub|T>*\<zeta\><rsub|0>>|\<sigma\><rsup|2>*<space|0.17em>sinh
    <around|(|\<omega\>*T|)>>*<space|0.17em>e<rsup|-<frac|2*\<omega\>|\<sigma\><rsup|2>>*<around*|(|\<zeta\><rsub|T><rsup|2>+\<zeta\><rsub|0><rsup|2>|)>*coth
    <around|(|\<omega\>*T|)>>*<space|0.17em>I<rsub|<frac|2*\<kappa\>*\<theta\>|\<sigma\><rsup|2>>-1><around*|(|<frac|4*\<omega\>*<space|0.17em>\<zeta\><rsub|T>*\<zeta\><rsub|0>|\<sigma\><rsup|2>*<space|0.17em>sinh
    <around|(|\<omega\>*T|)>>|)>,
  </equation>

  where

  <\equation>
    \<omega\>=<frac|\<sigma\>|2>*<sqrt|<frac|\<kappa\><rsup|2>|\<sigma\><rsup|2>>+<around*|(|1-\<rho\><rsup|2>|)>*l<rsup|2>+i*l*<around*|(|<frac|2*\<rho\>*\<kappa\>|\<sigma\>>-1|)>+2*i*p>.
  </equation>

  Integrating over <math|\<zeta\><rsub|T>> leads to
  <math|\<cal-P\><around*|(|\<chi\><rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>\<chi\><rsub|0>,0|)>>:

  <align|<tformat|<table|<row|<cell|<label|chiTIT2>>|<cell|\<cal-P\><around*|(|\<chi\><rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>\<chi\><rsub|0>,0|)><no-number>>>|<row|<cell|=>|<cell|<big|int><rsub|0><rsup|\<infty\>>\<cal-P\><around|(|x<rsub|T>,\<zeta\><rsub|T>,I<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>,\<zeta\><rsub|0>,0|)>*<space|0.17em>d*\<zeta\><rsub|T>*<no-number>>>|<row|<cell|=>|<cell|<space|0.17em>e<rsup|<frac|\<kappa\>|\<sigma\><rsup|2>>*v<rsub|0>+<frac|\<kappa\><rsup|2>*\<theta\>|\<sigma\><rsup|2>>*T>*<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*p|2*\<pi\>>*<space|0.17em>e<rsup|i*p*<space|0.17em>I<rsub|T>>*<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*l|2*\<pi\>>*<space|0.17em>e<rsup|i*l*<around*|(|x<rsub|T>-r*T|)>>*<no-number>>>|<row|<cell|>|<cell|\<times\><space|0.17em>e<rsup|i*l*<frac|\<rho\>|\<sigma\>>*<around*|(|\<kappa\>*\<theta\>*T+v<rsub|0>|)>>*N<rsup|<frac|2*\<kappa\>*\<theta\>|\<sigma\><rsup|2>>>*<space|0.17em>e<rsup|-<frac|2*\<omega\>*<around*|(|cosh
  <around|(|\<omega\>*T|)>-N|)>|\<sigma\><rsup|2>*sinh
  <around|(|\<omega\>*T|)>>*<space|0.17em>v<rsub|0>>,>>>>>

  where

  <\equation>
    N=<around*|(|cosh <around|(|\<omega\>*T|)>+<frac|\<kappa\>+i*l*\<rho\>*\<sigma\>|2*\<omega\>>*sinh
    <around|(|\<omega\>*T|)>|)><rsup|-1>.
  </equation>

  Note the similarity of expression (<reference|chiTIT2>) with the result
  obtained in <cite|Gabriel>.

  According to (<reference|PB>), we have for the Heston model

  <\equation>
    \<cal-P\><rsub|<mathcal>>*B<around*|(|x<rsub|T><space|0.17em>\|<space|0.17em>x<rsub|0>|)>=<big|int><rsub|-\<infty\>><rsup|+\<infty\>><frac|d*l|2*\<pi\>>*<space|0.17em>e<rsup|i*l*<around*|(|x<rsub|T>-r*T|)>>*\<cal-F\><around|(|l|)>,
  </equation>

  where

  <eqnarray|<tformat|<table|<row|<cell|\<cal-F\><around|(|l|)>>|<cell|=>|<cell|-i*<space|0.17em>e<rsup|<frac|\<kappa\>|\<sigma\><rsup|2>>*v<rsub|0>+<frac|\<kappa\><rsup|2>*\<theta\>|\<sigma\><rsup|2>>*T>*<big|int><rsub|-\<infty\>><rsup|\<infty\>><frac|d*p|2*\<pi\>>*<frac|e<rsup|i*p*\<cal-B\>>-1|p>>>|<row|<cell|>|<cell|>|<cell|\<times\><space|0.17em>e<rsup|i*l*<frac|\<rho\>|\<sigma\>>*<around*|(|\<kappa\>*\<theta\>*T+v<rsub|0>|)>>*N<rsup|<frac|2*\<kappa\>*\<theta\>|\<sigma\><rsup|2>>>*<space|0.17em>e<rsup|-<frac|2*\<omega\>*<around*|(|cosh
  <around|(|\<omega\>*T|)>-N|)>|\<sigma\><rsup|2>*sinh
  <around|(|\<omega\>*T|)>>*<space|0.17em>v<rsub|0>>,<eq-number>>>>>>

  with which we obtain the closed-form pricing formula for the finite
  time-horizon timer call options according to formula (<reference|CFini>).

  <with|par-columns|1|<big-figure|<with|par-mode|center|<image|f5.eps|3in|||>
  <image|f6.eps|3in|||> <image|f7.eps|3in|||>
  <image|f8.eps|3in|||><next-line><label|fig2> >|(Color online, two columns)
  This figure is similar to figure 1, but now for the Heston stochastic
  volatility model. The parameters used here are:
  <math|v<rsub|0>=0.087,\<kappa\>=2,\<theta\>=0.09,\<sigma\>=0.375,\<cal-B\>=v<rsub|0>,r=0.015,\<rho\>=-0.5,T=1.5>.>>

  <\center>
    <big-table|<with|font-size|0.71|<label|T><tabular*|<tformat|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|1|cell-row-span|2>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|2|2|cell-row-span|2>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|3|3|cell-col-span|3>|<cwith|1|1|3|3|cell-halign|c>|<cwith|1|1|3|3|cell-rborder|1ln>|<cwith|1|1|6|6|cell-col-span|3>|<cwith|1|1|6|6|cell-halign|c>|<cwith|1|1|6|6|cell-rborder|1ln>|<cwith|1|1|3|8|cell-bborder|1ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|5|5|1|-1|cell-bborder|1ln>|<cwith|8|8|1|-1|cell-bborder|1ln>|<cwith|11|11|1|-1|cell-bborder|1ln>|<table|<row|<cell|<math|K>>|<cell|<math|\<rho\>>>|<cell|<math|<space|0.17em>\<cal-C\><rsub|P*e*r*p>>>|<cell|>|<cell|>|<cell|<math|<space|0.17em>\<cal-C\><rsub|F*i*n*i>>>|<cell|>|<cell|>>|<row|<cell|>|<cell|>|<cell|<math|<space|0.17em><with|font-family|rm|A*n*a*l*y*t*i*c>>>|<cell|<math|<with|font-family|rm|M*C>>>|<cell|<math|<with|font-family|rm|R*E>(%)>
    <space|0.17em>>|<cell|<space|0.17em><math|<with|font-family|rm|A*n*a*l*y*t*i*c>>>|<cell|<math|<with|font-family|rm|M*C>>>|<cell|<math|<with|font-family|rm|R*E>(%)>
    <space|0.17em>>>|<row|<cell|>|<cell|- 0.5>|<cell|<space|0.17em>
    17.8064>|<cell|17.8128>|<cell|-0.0359
    <space|0.17em>>|<cell|<space|0.17em> 17.6813>|<cell|17.6790>|<cell|0.0130
    <space|0.17em>>>|<row|<cell|90>|<cell|0>|<cell|<space|0.17em>
    17.7046>|<cell|17.7129>|<cell|-0.0469
    <space|0.17em>>|<cell|<space|0.17em> 17.5385>|<cell|17.5510>|<cell|-0.0712
    <space|0.17em>>>|<row|<cell|>|<cell|0.5>|<cell|<space|0.17em>
    17.5839>|<cell|17.5853>|<cell|-0.0080
    <space|0.17em>>|<cell|<space|0.17em> 17.4260>|<cell|17.4301>|<cell|-0.0235
    <space|0.17em>>>|<row|<cell|>|<cell|- 0.5>|<cell|<space|0.17em>
    12.5780>|<cell|12.5784>|<cell|-0.0032
    <space|0.17em>>|<cell|<space|0.17em> 12.4089>|<cell|12.3998>|<cell|0.0734
    <space|0.17em>>>|<row|<cell|100>|<cell|0>|<cell|<space|0.17em>
    12.4619>|<cell|12.4683>|<cell|-0.0513
    <space|0.17em>>|<cell|<space|0.17em> 12.2780>|<cell|12.2890>|<cell|-0.0895
    <space|0.17em>>>|<row|<cell|>|<cell|0.5>|<cell|<space|0.17em>
    12.3300>|<cell|12.3231>|<cell|0.0560 <space|0.17em>>|<cell|<space|0.17em>
    12.2104>|<cell|12.2032>|<cell|0.0590 <space|0.17em>>>|<row|<cell|>|<cell|-
    0.5>|<cell|<space|0.17em> 8.6518>|<cell|8.6414>|<cell|0.0486
    <space|0.17em>>|<cell|<space|0.17em> 8.4381>|<cell|8.4301>|<cell|0.0949
    <space|0.17em>>>|<row|<cell|110>|<cell|0>|<cell|<space|0.17em>
    8.5339>|<cell|8.5388>|<cell|-0.0574 <space|0.17em>>|<cell|<space|0.17em>
    8.3531>|<cell|8.3611>|<cell|-0.0957 <space|0.17em>>>|<row|<cell|>|<cell|0.5>|<cell|<space|0.17em>
    8.4026>|<cell|8.3943>|<cell|0.0989 <space|0.17em>>|<cell|<space|0.17em>
    8.3229>|<cell|8.3153>|<cell|0.0914 <space|0.17em>>>>>>>|Comparison of the
    analytical and the Monte Carlo (MC) simulation values for both perpetual
    (<math|\<cal-C\><rsub|P*e*r*p>>) and finite time-horizon
    (<math|\<cal-C\><rsub|F*i*n*i>>) timer call option prices under the 3/2
    model. The columns indicated by RE shows the relative error (in %).
    Parameters used here are: <math|v<rsub|0>=<around|(|0.295|)><rsup|2>,\<kappa\>=22.84,\<theta\>=<around|(|0.4669|)><rsup|2>,\<epsilon\>=8.56,\<cal-B\>=v<rsub|0>,r=0.015,T=1.5>.>
  </center>

  <section|Pricing results and discussion><label|Disc>

  In the previous sections explicit formulas concerning timer options are
  derived for the 3/2 and the Heston model. The analytical tractability of
  these formulas is demonstrated by figures <reference|fig1> and
  <reference|fig2> and tables I and II. Figure <reference|fig1> as well as
  table I are devoted to the 3/2 model and figure <reference|fig2> as well as
  table II to the Heston model. For the 3/2 model the parameters are based on
  Ref. <cite|Gabriel>, where they are calibrated on market prices of S&P500
  European options to guarantee the relevance of these parameters. The
  parameters for the Heston model were chosen such that the two models are
  comparable.

  The two tables compare timer option prices calculated with the formulas of
  the previous sections with prices obtained by Monte Carlo simulations.
  Results for both the perpetual and the finite time horizon timer option are
  presented for several strikes and correlation values. For all the Monte
  Carlo simulations presented here, we used 20 million samples and 3200 time
  steps per year. The relative error between the exact and the simulated
  prices is always less than <math|0.1%> confirming our formulas.

  Although the prices of the timer option presented in these tables vary only
  slightly as a function of the correlation coefficient <math|\<rho\>>, the
  timer option does have different features for different correlation values.
  This can be seen in figures <reference|fig1> and <reference|fig2>. The
  upper left panel shows possible realizations of the variance up to the
  point where the realized variance reached <math|\<cal-B\>>. The lower left
  panel shows the corresponding log-returns. In these figures we used a
  negative correlation. As a consequence, paths with a low log-return are
  more likely to have a high volatility and the corresponding option will
  probably be exercised sooner than an option with a high log-return. This
  behavior is also seen in the inset of the lower left panel. This inset
  shows the density given by formula (<reference|PB>) when the maximum expiry
  time <math|T> reached <math|1.5>. Recall that this is the distribution of
  log-returns whose realized variance has not yet reached <math|\<cal-B\>>.
  Due to the negative correlation, paths with a low log-return are more
  likely to have reached <math|\<cal-B\>> and will therefore less likely
  contribute to this distribution than paths with a high log-return.
  Therefore this distribution is clearly shifted to the right. The lower
  right panel shows the joint density of the log-return <math|x<rsub|T>> and
  the realized variance <math|I<rsub|T>> when <math|T> equals <math|1.5> and
  also illustrates this behavior.

  <\center>
    <big-table|<with|font-size|0.71|<label|T><tabular*|<tformat|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|1|cell-row-span|2>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|2|2|cell-row-span|2>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|3|3|cell-col-span|3>|<cwith|1|1|3|3|cell-halign|c>|<cwith|1|1|3|3|cell-rborder|1ln>|<cwith|1|1|6|6|cell-col-span|3>|<cwith|1|1|6|6|cell-halign|c>|<cwith|1|1|6|6|cell-rborder|1ln>|<cwith|1|1|3|8|cell-bborder|1ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|5|5|1|-1|cell-bborder|1ln>|<cwith|8|8|1|-1|cell-bborder|1ln>|<cwith|11|11|1|-1|cell-bborder|1ln>|<table|<row|<cell|<math|K>>|<cell|<math|\<rho\>>>|<cell|<math|<space|0.17em>\<cal-C\><rsub|P*e*r*p>>>|<cell|>|<cell|>|<cell|<math|<space|0.17em>\<cal-C\><rsub|F*i*n*i>>>|<cell|>|<cell|>>|<row|<cell|>|<cell|>|<cell|<math|<space|0.17em><with|font-family|rm|A*n*a*l*y*t*i*c>>>|<cell|<math|<with|font-family|rm|M*C>>>|<cell|<math|<with|font-family|rm|R*E>(%)>
    <space|0.17em>>|<cell|<space|0.17em><math|<with|font-family|rm|A*n*a*l*y*t*i*c>>>|<cell|<math|<with|font-family|rm|M*C>>>|<cell|<math|<with|font-family|rm|R*E>(%)>
    <space|0.17em>>>|<row|<cell|>|<cell|- 0.5>|<cell|<space|0.17em>
    17.8095>|<cell|17.7948>|<cell|0.0826 <space|0.17em>>|<cell|<space|0.17em>
    17.6914>|<cell|17.6851>|<cell|0.0356 <space|0.17em>>>|<row|<cell|90>|<cell|0>|<cell|<space|0.17em>
    17.7249>|<cell|17.7232>|<cell|0.0096 <space|0.17em>>|<cell|<space|0.17em>
    17.5351>|<cell|17.5330>|<cell|0.0120 <space|0.17em>>>|<row|<cell|>|<cell|0.5>|<cell|<space|0.17em>
    17.6263>|<cell|17.6146>|<cell|0.0664 <space|0.17em>>|<cell|<space|0.17em>
    17.4627>|<cell|17.4680>|<cell|-0.0303
    <space|0.17em>>>|<row|<cell|>|<cell|- 0.5>|<cell|<space|0.17em>
    12.5789>|<cell|12.5668>|<cell|0.0963 <space|0.17em>>|<cell|<space|0.17em>
    12.4034>|<cell|12.4010>|<cell|0.0194 <space|0.17em>>>|<row|<cell|100>|<cell|0>|<cell|<space|0.17em>
    12.4772>|<cell|12.4763>|<cell|0.0072 <space|0.17em>>|<cell|<space|0.17em>
    12.2675>|<cell|12.2678>|<cell|-0.0024
    <space|0.17em>>>|<row|<cell|>|<cell|0.5>|<cell|<space|0.17em>
    12.3691>|<cell|12.3586>|<cell|0.0842 <space|0.17em>>|<cell|<space|0.17em>
    12.2426>|<cell|12.2464>|<cell|-0.0310
    <space|0.17em>>>|<row|<cell|>|<cell|- 0.5>|<cell|<space|0.17em>
    8.6515>|<cell|8.6412>|<cell|0.1192 <space|0.17em>>|<cell|<space|0.17em>
    8.4206>|<cell|8.4218>|<cell|-0.0142 <space|0.17em>>>|<row|<cell|110>|<cell|0>|<cell|<space|0.17em>
    8.5449>|<cell|8.5446>|<cell|0.0035 <space|0.17em>>|<cell|<space|0.17em>
    8.3393>|<cell|8.3405>|<cell|-0.0144 <space|0.17em>>>|<row|<cell|>|<cell|0.5>|<cell|<space|0.17em>
    8.4393>|<cell|8.4317>|<cell|0.0890 <space|0.17em>>|<cell|<space|0.17em>
    8.3522>|<cell|8.3542>|<cell|-0.0239 <space|0.17em>>>>>>>|Comparison of
    the analytical and the MC simulation values for timer call option prices
    under the Heston model. The columns indicated by RE shows the relative
    error (in %). Parameters used here are:
    <math|v<rsub|0>=0.087,\<kappa\>=2,\<theta\>=0.09,\<sigma\>=0.375,\<cal-B\>=v<rsub|0>,r=0.015,\<rho\>=-0.5,T=1.5>.>
  </center>

  Tables I and II illustrate that the prices for timer options are quite
  similar for the two stochastic volatility models. Nevertheless there are
  important differences between the two models concerning timer options. This
  is illustrated by the upper panels of figures <reference|fig1> and
  <reference|fig2>. As already mentioned, the upper left panel shows several
  possible time evolutions of the variance. The inset of this panel shows the
  probability distribution of the stopping time
  <math|\<cal-T\><rsub|\<cal-B\>>>. The upper right panel shows the joint
  density of the variance and the stopping time, which is useful for an
  intuitive understanding of the time evolution of the underlying processes.
  The explicit form of this density is not included in the text because it is
  not needed to calculate prices and because it can easily be derived from
  expression (<reference|PXzT2>). For the 3/2 model, the probability that the
  variance reaches large values is larger than for the Heston model, while
  the probability that the variance reaches very small values is smaller than
  for the Heston model. Therefore the probability that the timer option will
  be exercised very fast is larger for the 3/2 model than for the Heston
  model. On the other hand for the Heston model there is a larger probability
  that the timer option will only be exercised after a long time than for the
  3/2 model.

  <section|Conclusion><label|Conclusion>

  In this paper we construct a method to price both the perpetual and the
  finite time-horizon timer option for a general stochastic volatility model.
  Pricing of such options is related to first passage time problems in that
  the stopping time for the option is determined by a boundary on a
  cumulative stochastic process. The method proposed here is based on the
  Duru-Kleinert time transformation and the path integral framework.
  Furthermore we discuss the conditions a stochastic volatility model has to
  satisfy in order to be able to derive closed-form pricing formulas. These
  general results are then applied to derive closed-form formulas for the
  Heston and the 3/2 stochastic volatility model. For the 3/2 model this
  involves the solution of the Morse potential, for the Heston model the
  Kratzer potential needs to be solved. Finally, our closed-form pricing
  formulas are shown to be computationally tractable and are validated by
  Monte Carlo simulation.

  <section|Path integral for Morse potential><label|Morse>

  The path integral for the Morse potential is given in Ref. <cite|Grosche>:

  <align|<tformat|<table|<row|<cell|>|<cell|<frac|i|\<hbar\>>*<big|int><rsub|0><rsup|\<infty\>>d*T*<space|0.17em>e<rsup|i*E*T/\<hbar\>>*<big|int><rsub|x<rprime|'>><rsup|x<rsup|\<prime\>*\<prime\>>>\<cal-D\>*x<around|(|t|)>*<space|0.17em>e<rsup|<frac|i|\<hbar\>>*<big|int><rsub|t<rprime|'>><rsup|t<rsup|\<prime\>*\<prime\>>><around*|[|<frac|m|2>*<wide|x|\<dot\>><rsup|2>-<frac|\<hbar\><rsup|2>*V<rsub|0><rsup|2>|2*m>*<around*|(|e<rsup|2*x>-2*\<alpha\>*<space|0.17em>e<rsup|x>|)>|]>*d*t>*<no-number>>>|<row|<cell|=>|<cell|<frac|m*\<Gamma\>*<around*|(|<frac|1|2>+<sqrt|-2*m*E>/\<hbar\>-\<alpha\>*V<rsub|0>|)>|\<hbar\><rsup|2>*V<rsub|0>*\<Gamma\>*<around*|(|1+2*<sqrt|-2*m*E>|)>>*<space|0.17em>W<rsub|\<alpha\>*V<rsub|0>,<sqrt|-<frac|2*m*E|\<hbar\><rsup|2>>>>*<around*|(|2*V<rsub|0>*<space|0.17em>e<rsup|x<rsub|\<gtr\>>>|)><no-number>>>|<row|<cell|>|<cell|\<times\><space|0.17em>e<rsup|-<around*|(|x<rprime|'>+x<rsup|\<prime\>*\<prime\>>|)>/2>*<space|0.17em>M<rsub|\<alpha\>*V<rsub|0>,<sqrt|-<frac|2*m*E|\<hbar\><rsup|2>>>>*<around*|(|2*V<rsub|0>*<space|0.17em>e<rsup|x<rsub|\<less\>>>|)>,>>>>>

  where <math|V<rsub|0>\<gtr\>0>, <math|x<rsub|\<gtr\>><space|0.17em><around|(|x<rsub|\<less\>>|)>>
  is the larger (smaller) of two variables <math|x<rprime|'>> and
  <math|x<rsup|\<prime\>*\<prime\>>>, <math|\<Gamma\><around|(|\<cdummy\>|)>>
  is the gamma function, and <math|M<rsub|\<cdot\>,\<cdot\>><around|(|\<cdummy\>|)>>
  and <math|W<rsub|\<cdot\>,\<cdot\>><around|(|\<cdummy\>|)>> are the
  Whittaker functions related to the Kummer and Tricomi confluent
  hypergeometric functions, respectively.

  This path integral (let <math|\<hbar\>=1,-E=\<Phi\>=\<Phi\><rsub|R>+i*\<Phi\><rsub|I>>),
  analytically continued to "imaginary time" defined by

  <\equation>
    t=-i*\<tau\>*<space|0.17em><space|0.17em><around|(|\<tau\>\<in\>\<bbb-R\>|)>,<space|1em>T=-i*\<Delta\>*<space|0.17em><space|0.17em><around|(|\<Delta\>\<in\>\<bbb-R\>|)>,
  </equation>

  results in:

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|<big|int><rsub|0><rsup|\<infty\>>d*\<Delta\>*<space|0.17em>e<rsup|-\<Phi\>*\<Delta\>>*<big|int><rsub|x<rprime|'>><rsup|x<rsup|\<prime\>*\<prime\>>>\<cal-D\>*x<around|(|\<tau\>|)>*<space|0.17em>e<rsup|-<big|int><rsub|0><rsup|\<Delta\>><around*|[|<frac|m|2><around*|(|<frac|d*x|d*\<tau\>>|)><rsup|2>+<frac|V<rsub|0><rsup|2>|2*m>*<around*|(|e<rsup|2*x>-2*\<alpha\>*<space|0.17em>e<rsup|x>|)>|]>*d*\<tau\>>>>|<row|<cell|>|<cell|=>|<cell|<frac|m*\<Gamma\>*<around*|(|<frac|1|2>+<sqrt|2*m*\<Phi\>>-\<alpha\>*V<rsub|0>|)>|V<rsub|0>*\<Gamma\>*<around*|(|1+2*<sqrt|2*m*\<Phi\>>|)>>*<space|0.17em>e<rsup|-<around*|(|x<rprime|'>+x<rsup|\<prime\>*\<prime\>>|)>/2>>>|<row|<cell|>|<cell|>|<cell|\<times\>W<rsub|\<alpha\>*V<rsub|0>,<sqrt|2*m*\<Phi\>>>*<around*|(|2*V<rsub|0>*<space|0.17em>e<rsup|x<rsub|\<gtr\>>>|)>*<space|0.17em>M<rsub|\<alpha\>*V<rsub|0>,<sqrt|2*m*\<Phi\>>>*<around*|(|2*V<rsub|0>*<space|0.17em>e<rsup|x<rsub|\<less\>>>|)>.<eq-number>>>>>>

  Therefore the inverse Laplace transform gives the expression of the
  propagator evolving in the "imaginary" time horizon
  <math|<around*|[|0,\<Delta\>|]>> as shown in Ref. <cite|Kleinert>:

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|<big|int>\<cal-D\>*x<around|(|\<tau\>|)>*e<rsup|-<big|int><rsub|0><rsup|\<Delta\>><around*|[|<frac|m|2><around*|(|<frac|d*x|d*\<tau\>>|)><rsup|2>+<frac|V<rsub|0><rsup|2>|2*m>*<around*|(|e<rsup|2*x>-2*\<alpha\>*<space|0.17em>e<rsup|x>|)>|]>*d*\<tau\>>>>|<row|<cell|>|<cell|=>|<cell|<big|int><rsub|\<Phi\><rsub|R>-i*\<infty\>><rsup|\<Phi\><rsub|R>+i*\<infty\>><frac|d*\<Phi\>|2*\<pi\>*i>*<space|0.17em>e<rsup|\<Phi\>*\<Delta\>>*<frac|m*\<Gamma\>*<around*|(|<frac|1|2>+<sqrt|2*m*\<Phi\>>-\<alpha\>*V<rsub|0>|)>|V<rsub|0>*\<Gamma\>*<around*|(|1+2*<sqrt|2*m*\<Phi\>>|)>>*<space|0.17em>e<rsup|-<frac|x<rprime|'>+x<rsup|\<prime\>*\<prime\>>|2>>>>|<row|<cell|>|<cell|>|<cell|\<times\>W<rsub|\<alpha\>*V<rsub|0>,<sqrt|2*m*\<Phi\>>>*<around*|(|2*V<rsub|0>*<space|0.17em>e<rsup|x<rsub|\<gtr\>>>|)>*<space|0.17em>M<rsub|\<alpha\>*V<rsub|0>,<sqrt|2*m*\<Phi\>>>*<around*|(|2*V<rsub|0>*<space|0.17em>e<rsup|x<rsub|\<less\>>>|)>>>|<row|<cell|>|<cell|=>|<cell|2*m*<big|int><rsub|0><rsup|\<infty\>><frac|d*\<Phi\><rsub|I>|\<pi\>>*<space|0.17em><with|font-family|rm|R*e><around*|[|<space|0.17em>e<rsup|\<Phi\>*\<Delta\>>*<big|int><rsub|0><rsup|\<infty\>><frac|d*\<xi\>|sinh
  \<xi\>>*<space|0.17em>e<rsup|2*\<alpha\>*V<rsub|0>*\<xi\>>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|\<times\><around*|\<nobracket\>|<space|0.17em>e<rsup|-V<rsub|0>*<around*|(|e<rsup|x<rprime|'>>+e<rsup|x<rsup|\<prime\>*\<prime\>>>|)>*coth
  \<xi\>>*<space|0.17em>I<rsub|2*<sqrt|2*m*\<Phi\>>><around*|(|<frac|2*V<rsub|0>*<space|0.17em>e<rsup|<frac|x<rprime|'>+x<rsup|\<prime\>*\<prime\>>|2>>|sinh
  \<xi\>>|)>|]>,<eq-number>>>>>>

  under the condition

  <\equation>
    <with|font-family|rm|R*e>*<around*|[|<frac|1|2>+<sqrt|2*m*\<Phi\>>-\<alpha\>*V<rsub|0>|]>\<gtr\>0,
  </equation>

  that is

  <\equation>
    <label|Restriction2>\<Phi\><rsub|R>\<gtr\><frac|<around*|(|<with|font-family|rm|R*e><around|[|\<alpha\>|]>*V<rsub|0>-<frac|1|2>|)><rsup|2>|2*m>.
  </equation>

  <section|Path integral for Kratzer potential><label|Kratzer>

  The path integral for Kratzer potential is given in Ref. <cite|Grosche>
  <math|<around*|(|\<lambda\>\<gtr\>0,\<kappa\>=<frac|e<rsub|1>*e<rsub|2>|\<hbar\>>*<sqrt|-<frac|m|2*E>>|)>>:

  <align|<tformat|<table|<row|<cell|>|<cell|<frac|i|\<hbar\>>*<big|int><rsub|0><rsup|\<infty\>>d*T*<space|0.17em>e<rsup|i*E*T/\<hbar\>>*<big|int><rsub|r<rprime|'>><rsup|r<rsup|\<prime\>*\<prime\>>>\<cal-D\>*r<around|(|t|)>*<space|0.17em>e<rsup|<frac|i|\<hbar\>>*<big|int><rsub|t<rprime|'>><rsup|t<rsup|\<prime\>*\<prime\>>><around*|(|<frac|m|2>*<wide|r|\<dot\>><rsup|2>+<frac|e<rsub|1>*e<rsub|2>|r>-<frac|\<hbar\><rsup|2>|2*m>*<frac|\<lambda\><rsup|2>-<frac|1|4>|r<rsup|2>>|)>*d*t>*<no-number>>>|<row|<cell|=>|<cell|<frac|1|\<hbar\>>*<sqrt|-<frac|m|2*E>>*<frac|\<Gamma\>*<around*|(|<frac|1|2>+\<lambda\>-\<kappa\>|)>|\<Gamma\>*<around*|(|2*\<lambda\>+1|)>>*<no-number>>>|<row|<cell|>|<cell|\<times\>W<rsub|\<kappa\>,\<lambda\>>*<around*|(|<sqrt|-8*m*E>*<space|0.17em><frac|r<rsub|\<gtr\>>|\<hbar\>>|)>*<space|0.17em>M<rsub|\<kappa\>,\<lambda\>>*<around*|(|<sqrt|-8*m*E>*<space|0.17em><frac|r<rsub|\<less\>>|\<hbar\>>|)>,>>>>>

  The analytical continuation of this path integral (let
  <math|\<hbar\>=1,m=1,e<rsub|1>*e<rsub|2>=\<beta\>,-E=\<Phi\>=\<Phi\><rsub|R>+i*\<Phi\><rsub|I>>)
  as used in Appendix <reference|Morse> gives
  <math|<around*|(|\<kappa\>=<frac|\<beta\>|<sqrt|2*\<Phi\>>>|)>>:

  <align|<tformat|<table|<row|<cell|>|<cell|<big|int><rsub|0><rsup|\<infty\>>d*\<Delta\>*<space|0.17em>e<rsup|-\<Phi\>*\<Delta\>>*<big|int><rsub|r<around|(|0|)>=r<rprime|'>><rsup|r<around|(|\<Delta\>|)>=r<rsup|\<prime\>*\<prime\>>>\<cal-D\>*r<around|(|\<tau\>|)>*e<rsup|-<big|int><rsub|0><rsup|\<Delta\>><around*|[|<frac|1|2><around*|(|<frac|d*r|d*\<tau\>>|)><rsup|2>+<frac|\<lambda\><rsup|2>-<frac|1|4>|2*r<rsup|2>>-<frac|\<beta\>|r>|]>*d*\<tau\>>*<no-number>>>|<row|<cell|=>|<cell|<frac|\<Gamma\>*<around*|(|<frac|1|2>+\<lambda\>-\<kappa\>|)>|<sqrt|2*\<Phi\>>*<space|0.17em>\<Gamma\>*<around*|(|2*\<lambda\>+1|)>>*W<rsub|\<kappa\>,\<lambda\>>*<around*|(|2*<sqrt|2*\<Phi\>>*<space|0.17em><space|0.17em>r<rsub|\<gtr\>>|)>*<space|0.17em>M<rsub|\<kappa\>,\<lambda\>>*<around*|(|2*<sqrt|2*\<Phi\>>*<space|0.17em><space|0.17em>r<rsub|\<less\>>|)>.>>>>>

  Therefore the inverse Laplace transform leads to the propagator in time
  horizon <math|<around|[|0,\<Delta\>|]>> as in Ref. <cite|Grosche2>:

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|<big|int>\<cal-D\>*r<around|(|\<tau\>|)>*e<rsup|-<big|int><rsub|0><rsup|\<Delta\>><around*|[|<frac|1|2><around*|(|<frac|d*r|d*\<tau\>>|)><rsup|2>+<frac|\<lambda\><rsup|2>-<frac|1|4>|2*r<rsup|2>>-<frac|\<beta\>|r>|]>*d*\<tau\>>>>|<row|<cell|>|<cell|=>|<cell|<big|int><rsub|0><rsup|\<infty\>><frac|d*\<Phi\><rsub|I>|\<pi\>>*<space|0.17em><with|font-family|rm|R*e><around*|[|<space|0.17em>e<rsup|\<Phi\>*\<Delta\>>*<space|0.17em>2*<sqrt|2*\<Phi\>>*<big|int><rsub|0><rsup|\<infty\>>d*\<xi\>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|\<times\><space|0.17em>e<rsup|2*\<beta\>*\<xi\>-<sqrt|2*\<Phi\>>*<around*|(|r<rsub|\<gtr\>>+r<rsub|\<less\>>|)>*coth
  <around*|(|<sqrt|2*\<Phi\>>*<space|0.17em>\<xi\>|)>>>>|<row|<cell|>|<cell|>|<cell|\<times\><around*|\<nobracket\>|<frac|<sqrt|r<rsub|\<gtr\>>*<space|0.17em>r<rsub|\<less\>>>|sinh
  <around*|(|<sqrt|2*\<Phi\>>*<space|0.17em>\<xi\>|)>>*<space|0.17em><space|0.17em>I<rsub|2*\<lambda\>><around*|(|<frac|2*<sqrt|2*\<Phi\>>*<space|0.17em><sqrt|r<rsub|\<gtr\>>*<space|0.17em>r<rsub|\<less\>>>|sinh
  <around*|(|<sqrt|2*\<Phi\>>*<space|0.17em>\<xi\>|)>>|)>|]>,<eq-number>>>>>>

  valid under the condition

  <\equation>
    <with|font-family|rm|R*e>*<around*|[|<frac|1|2>+\<lambda\>-<frac|\<beta\>|<sqrt|2*\<Phi\>>>|]>\<gtr\>0,
  </equation>

  that is

  <\equation>
    <label|Restriction1>\<Phi\><rsub|R>\<gtr\><frac|1|2><around*|(|<frac|\<beta\>|\<lambda\>+<frac|1|2>>|)><rsup|2>.
  </equation>

  <\bibliography|bib|plain|bibfile>
    <bib-list|[99]|>
  </bibliography>
</body>