<TeXmacs|1.99.7>

<style|<tuple|amsart|std-latex>>

<\body>
  <\hide-preamble>
    <new-theorem|theorem|Theorem>

    <new-theorem|lem|Lemma>

    <new-theorem|prop|Proposition>

    <new-theorem|cond|Condition>

    <new-theorem|coro|Corollary>

    <new-theorem|fact|Fact>

    <new-theorem|conj|Conjecture>

    <new-theorem|defi|Definition>

    <new-theorem|ex|Example>

    <new-theorem|rem|Remark>

    <new-theorem|prob|Problem>

    <assign|Z|<macro|\<bbb-Z\>>>

    <assign|N|<macro|\<bbb-N\>>>

    <assign|Q|<macro|\<bbb-Q\>>>

    <assign|R|<macro|\<bbb-R\>>>

    <assign|C|<macro|\<bbb-C\>>>
  </hide-preamble>

  <doc-data|<doc-title|Solution of a uniqueness problem in the discrete
  tomography of algebraic Delone sets>|<doc-author|<author-data|<author-name|Christian
  Huck>>>|<doc-author|<author-data|<author-name|Michael
  Spie>|<author-affiliation|Fakultt fr Mathematik, Universitt Bielefeld,
  Postfach 100131, 33501 Bielefeld, Germany>|<author-email|huck@math.uni-bielefeld.de>|<author-email|mspiess@math.uni-bielefeld.de>>>>

  <abstract-data|<abstract-keywords|Discrete tomography| X-ray| algebraic
  Delone set| model set| <math|U>-polygon| convex
  body.>|<abstract-msc|Primary 52C23| Secondary 11R04| 11R06| 11R18| 12F10|
  52A10| 52C05|82D99>|<\abstract>
    We consider algebraic Delone sets <math|<varLambda>> in the Euclidean
    plane and address the problem of distinguishing convex subsets of
    <math|<varLambda>> by X-rays in prescribed <math|<varLambda>>-directions,
    i.e., directions parallel to nonzero interpoint vectors of
    <math|<varLambda>>. Here, an X-ray in direction <math|u> of a finite set
    gives the number of points in the set on each line parallel to <math|u>.
    It is shown that for any algebraic Delone set <math|<varLambda>> there
    are four prescribed <math|<varLambda>>-directions such that any two
    convex subsets of <math|<varLambda>> can be distinguished by the
    corresponding X-rays. We further prove the existence of a natural number
    <math|c<rsub|<varLambda>>> such that any two convex subsets of
    <math|<varLambda>> can be distinguished by their X-rays in any set of
    <math|c<rsub|<varLambda>>> prescribed <math|<varLambda>>-directions. In
    particular, this extends a well-known result of Gardner and Gritzmann on
    the corresponding problem for planar lattices to nonperiodic cases that
    are relevant in quasicrystallography.
  </abstract>>

  <section|Introduction><label|intro>

  <with|font-shape|italic|Discrete tomography> is concerned with the inverse
  problem of retrieving information about some
  <with|font-shape|italic|finite> object in Euclidean space from (generally
  noisy) information about its slices. One important problem is the
  <with|font-shape|italic|unique reconstruction> of a finite point set in
  Euclidean <math|3>-space from its <with|font-shape|italic|(discrete
  parallel) X-rays> in a small number of directions, where the
  <with|font-shape|italic|X-ray> of the finite set in a certain direction is
  the <with|font-shape|italic|line sum function> giving the number of points
  in the set on each line parallel to this direction.

  The interest in the discrete tomography of planar Delone sets
  <math|<varLambda>> with long-range order is motivated by the requirement in
  materials science for the unique reconstruction of solid state materials
  like <with|font-shape|italic|quasicrystals> slice by slice from their
  images under quantitative <with|font-shape|italic|high resolution
  transmission electron microscopy> (HRTEM). In fact, in<nbsp><cite|ks>,
  <cite|sk> a technique is described, which can, for certain crystals,
  effectively measure the number of atoms lying on densely occupied columns.
  It is reasonable to expect that future developments in technology will
  extend this situation to other solid state materials. The aforementioned
  density condition forces us to consider only <math|<varLambda>>-directions,
  i.e., directions parallel to nonzero interpoint vectors of
  <math|<varLambda>>. Further, since typical objects may be damaged or even
  destroyed by the radiation energy after about <math|3> to <math|5> images
  taken by HRTEM, applicable results may only use a small number of X-rays.
  It actually is this restriction to few high-density directions that makes
  the problems of discrete tomography mathematically challenging, even if one
  assumes the absence of noise.

  In the traditional setting, motivated by <with|font-shape|italic|crystals>,
  the positions to be determined form a finite subset of a three-dimensional
  lattice, the latter allowing a slicing into equally spaced congruent copies
  of a planar lattice. In the crystallographic setting, by the affine nature
  of the problem, it therefore suffices to study the discrete tomography of
  the square lattice; cf.<nbsp><cite|GG>, <cite|GG2>, <cite|GGP>, <cite|Gr>,
  <cite|HT>, <cite|HK>, <cite|HK2> for an overview. For the
  <with|font-shape|italic|quasicrystallographic> setting, the positions to be
  determined form a finite subset of a <with|font-shape|italic|nonperiodic
  Delone set> with <with|font-shape|italic|long-range order> (more precisely,
  a <with|font-shape|italic|mathematical quasicrystal> or
  <with|font-shape|italic|model set><nbsp><cite|BM>, <cite|Moody>) which on
  the other hand is contained in a free additive subgroup of
  <math|<R><rsup|3>> of finite rank <math|r\<gtr\>3>. These model sets
  possess, as it is the case for lattices, a dimensional hierarchy, i.e.,
  they allow a slicing into planar model sets. However, the slices are in
  general no longer pairwise congruent or equally spaced in <math|3>-space;
  cf.<nbsp><cite|PABP2>. Still, most of the model sets that describe real
  quasicrystallographic structures allow a slicing such that each slice is,
  when seen from a common perpendicular viewpoint, a (planar)
  <with|font-shape|italic|<math|n>-cyclotomic model set>, where <math|n=5>,
  <math|n=8> and <math|n=12>, respectively (Example<nbsp><reference|algex>);
  cf.<nbsp><cite-detail|H|Sec.<nbsp>1.2>, <cite|H2>,
  <cite-detail|H5|Sec.<nbsp>4.5> and <cite|St> for details. These cyclotomic
  model sets thus take over the role played by the planar lattices in the
  crystallographic case. In the present text, we shall focus on the larger
  class of <with|font-shape|italic|algebraic Delone sets>
  (Definition<nbsp><reference|algdeldef>).

  Since different finite subsets of a Delone set <math|<varLambda>> may have
  the same X-rays in several <math|<varLambda>>-directions (in other words,
  the above problem of uniquely reconstructing a finite point set from its
  X-rays is an <with|font-shape|italic|ill-posed> problem in general), one is
  naturally interested in conditions to be imposed on the set of
  <math|<varLambda>>-directions together with restrictions on the possible
  finite subsets of <math|<varLambda>> such that the latter phenomenon cannot
  occur. Here, we consider the <with|font-shape|italic|convex subsets> of
  <math|<varLambda>> (i.e., bounded subsets of <math|<varLambda>> with the
  property that their convex hull contains no new points of
  <math|<varLambda>>) and show that for any algebraic Delone set
  <math|<varLambda>> there are four prescribed <math|<varLambda>>-directions
  such that any two convex subsets of <math|<varLambda>> can be distinguished
  by the corresponding X-rays, whereas less than four
  <math|<varLambda>>-directions never suffice for this purpose
  (Theorem<nbsp><reference|dtmain>(a)). We further prove the existence of a
  finite number <math|c<rsub|<varLambda>>> such that any two convex subsets
  of <math|<varLambda>> can be distinguished by their X-rays in
  <with|font-shape|italic|any> set of <math|c<rsub|<varLambda>>> prescribed
  <math|<varLambda>>-directions (Theorem<nbsp><reference|dtmain>(b)).
  Moreover, we demonstrate that the least possible numbers
  <math|c<rsub|<varLambda>>> in the case of the practically most relevant
  examples of <math|n>-cyclotomic model sets <math|<varLambda>> with
  <math|n=5>, <math|n=8> and <math|n=12> are (in that very order) <math|11>,
  <math|9> and <math|13> (Theorem<nbsp><reference|dtmain2>(b) and
  Remark<nbsp><reference|rembest>). This extends a well-known result of
  Gardner and Gritzmann (cf.<nbsp><cite-detail|GG|Thm.<nbsp>5.7>) on the
  corresponding problem for planar lattices <math|<varLambda>>
  (<math|c<rsub|<varLambda>>=7>) to cases that are relevant in
  quasicrystallography and particularly solves Problem 4.34
  of<nbsp><cite|H5>. The above results and their continuous analogue
  (Theorem<nbsp><reference|tmain>) follow from deep insights into the
  existence of certain <with|font-shape|italic|<math|U>-polygons> in the
  plane (cf.<nbsp>Sec.<nbsp><reference|sec1>). We believe that our main
  result on these polygons (Theorem<nbsp><reference|main>) is of independent
  interest from a purely geometrical point of view. For the algorithmic
  reconstruction problem in the quasicrystallographic setting, we refer the
  reader to<nbsp><cite|BG2>,<nbsp><cite|H2>.

  <section|Preliminaries and notation><label|sec1>

  Natural numbers are always assumed to be positive. We denote the norm in
  Euclidean <math|d>-space by <math|<around|\<\|\|\>|\<cdummy\>|\<\|\|\>>>.
  The Euclidean plane will occasionally be identified with the complex
  numbers. For <math|z\<in\><C>>, <math|<wide|z|\<bar\>>> denotes the complex
  conjugate of <math|z> and <math|<around|\||z|\|>=<sqrt|z*<wide|z|\<bar\>>>>
  its modulus. The unit circle in <math|<C>> is denoted by
  <math|\<bbb-S\><rsup|1>> and its elements are also called
  <with|font-shape|italic|directions>. For <math|z\<in\><C><rsup|\<ast\>>>,
  we denote by <math|<math-up|sl><around|(|z|)>> the slope of <math|z>, i.e.,
  <math|<math-up|sl><around|(|z|)>=-i*<around|(|z-<wide|z|\<bar\>>|)>/<around|(|z+<wide|z|\<bar\>>|)>\<in\>\<bbb-R\>\<cup\><around|{|\<infty\>|}>>.
  For <math|r\<gtr\>0> and <math|z\<in\><C>>, <math|B<rsub|r><around|(|z|)>>
  is the open ball of radius <math|r> about <math|z>. Recall that an
  (<math|<R>>-)<with|font-shape|italic|linear endomorphism> (resp.,
  <with|font-shape|italic|affine endomorphism>) of <math|<C>> is given by
  <math|z\<mapsto\>a*z+b*<wide|z|\<bar\>>> (resp.,
  <math|z\<mapsto\>a*z+b*<wide|z|\<bar\>>+t>), where <math|a,b,t\<in\><C>>.
  In both cases, it is an automorphism if and only if
  <math|a*z+b*<wide|z|\<bar\>>=0> only holds for <math|z=0>. A
  <with|font-shape|italic|homothety> <math|h<space|-0.17em>:<space|0.17em><C>\<rightarrow\><C>>
  is given by <math|z\<mapsto\>\<lambda\>*z+t>, where
  <math|\<lambda\>\<in\><R>> is positive and <math|t\<in\><C>>. In the
  following, let <math|<varLambda>> be a subset of <math|<C>>. A direction
  <math|u\<in\>\<bbb-S\><rsup|1>> is called a
  <math|<varLambda>><with|font-shape|italic|-direction> if it is parallel to
  a nonzero element of the difference set
  <math|<varLambda>-<varLambda>=<around|{|v-w<space|0.17em>\|<space|0.17em>v,w\<in\><varLambda>|}>>
  of <math|<varLambda>>. A <with|font-shape|italic|convex polygon> is the
  convex hull of a finite set of points in <math|<C>>. A
  <with|font-shape|italic|polygon in> <math|<varLambda>> is a convex polygon
  with all vertices in <math|<varLambda>>. Further, a bounded subset <math|C>
  of <math|<varLambda>> is called a <with|font-shape|italic|convex subset of>
  <math|<varLambda>> if <math|C=<math-up|conv><around|(|C|)>\<cap\><varLambda>>,
  where <math|<math-up|conv><around|(|C|)>> denotes the convex hull of
  <math|C>. Let <math|U\<subset\>\<bbb-S\><rsup|1>> be a finite set of
  directions. A nondegenerate convex polygon <math|P> is called a
  <with|font-shape|italic|<math|U>-polygon> if it has the property that
  whenever <math|v> is a vertex of <math|P> and <math|u\<in\>U>, the line in
  the complex plane in direction <math|u> which passes through <math|v> also
  meets another vertex <math|v<rprime|'>> of <math|P>. By a
  <with|font-shape|italic|regular polygon> we shall always mean a
  nondegenerate convex regular polygon. An <with|font-shape|italic|affinely
  regular polygon> is the image of a regular polygon under an affine
  automorphism of the complex plane. <math|<varLambda>> is called
  <with|font-shape|italic|uniformly discrete> if there is a radius
  <math|r\<gtr\>0> such that every ball <math|B<rsub|r><around|(|z|)>> with
  <math|z\<in\><C>> contains at most one point of <math|<varLambda>>. Note
  that the bounded subsets of a uniformly discrete set <math|<varLambda>> are
  precisely the finite subsets of <math|<varLambda>>. <math|<varLambda>> is
  called <with|font-shape|italic|relatively dense> if there is a radius
  <math|R\<gtr\>0> such that every ball <math|B<rsub|R><around|(|z|)>> with
  <math|z\<in\><C>> contains at least one point of <math|<varLambda>>.
  <math|<varLambda>> is called a <with|font-shape|italic|Delone set> if it is
  both uniformly discrete and relatively dense. <math|<varLambda>> is said to
  be of <em|finite local complexity> if <math|<varLambda>-<varLambda>> is
  discrete and closed. Note that <math|<varLambda>> is of finite local
  complexity if and only if for every <math|r\<gtr\>0> there are, up to
  translation, only finitely many <em|patches of radius <math|r>>, i.e., sets
  of the form <math|<varLambda>\<cap\>B<rsub|r><around|(|z|)>>, where
  <math|z\<in\><C>>; cf.<nbsp><cite|Moody>. A Delone set <math|<varLambda>>
  is a <em|Meyer set> if <math|<varLambda>-<varLambda>> is uniformly
  discrete. Trivially, any Meyer set is of finite local complexity.
  <math|<varLambda>> is called <with|font-shape|italic|periodic> if it has
  nonzero translation symmetries. Finally, we denote by
  <math|K<rsub|<varLambda>>> the intermediate field of <math|<C>/<Q>> that is
  given by

  <\equation*>
    K<rsub|<varLambda>><space|0.17em><space|0.17em>\<assign\><space|0.17em><space|0.17em><Q><around*|(|<around*|(|<varLambda>-<varLambda>|)>\<cup\><around*|(|<wide|<varLambda>-<varLambda>|\<bar\>>|)>|)><space|0.17em>.
  </equation*>

  <subsection|Recollections from the theory of cyclotomic fields>

  Let <math|K\<subset\><C>> be a field and let <math|\<mu\>> be the group of
  roots of unity in <math|<C>>. We denote the maximal real subfield
  <math|K\<cap\><R>> of <math|K> by <math|K<rsup|+>> and set
  <math|\<mu\><around|(|K|)>\<assign\>\<mu\>\<cap\>K>. For
  <math|n\<in\>\<bbb-N\>>, we always let <math|\<zeta\><rsub|n>\<assign\>e<rsup|2*\<pi\>*i/n>>,
  a primitive <math|n>th root of unity in <math|<C>>. Then,
  <math|<Q><around|(|\<zeta\><rsub|n>|)>> is the <math|n>th cyclotomic field.
  Further, <math|\<phi\>> will always denote Euler's totient function, i.e.,

  <\equation*>
    \<phi\><around|(|n|)>=<math-up|card><around*|(|<around*|{|k\<in\>\<bbb-N\><space|0.17em><mid|\|><space|0.17em>1\<leq\>k\<leq\>n<text|and
    ><math-up|gcd><around|(|k,n|)>=1|}>|)><space|0.17em>.
  </equation*>

  Recall that <math|\<phi\>> is multiplicative with
  <math|\<phi\><around|(|p<rsup|r>|)>=p<rsup|r-1>*<around|(|p-1|)>> for
  <math|p> prime and <math|r\<in\><N>>.

  <\fact>
    [Gau]<cite-detail|Wa|Thm.<nbsp> 2.5><label|gau>
    <math|<around|[|<Q><around|(|\<zeta\><rsub|n>|)>:<Q>|]>=\<phi\><around|(|n|)>>
    and the field extension <math|<Q><around|(|\<zeta\><rsub|n>|)>/<Q>> is a
    Galois extension with Abelian Galois group
    <math|G*<around|(|<Q><around|(|\<zeta\><rsub|n>|)>/<Q>|)>\<simeq\><around|(|<Z>/n<Z>|)><rsup|\<times\>>>,
    with <math|a<pmod|n>> corresponding to the automorphism given by
    <math|\<zeta\><rsub|n>\<mapsto\>\<zeta\><rsub|n><rsup|a>>.<math|\<Box\>>
  </fact>

  Note that the composition <math|<Q><around|(|\<zeta\><rsub|n>|)><Q><around|(|\<zeta\><rsub|m>|)>=<Q><around|(|\<zeta\><rsub|n>,\<zeta\><rsub|m>|)>>
  of cyclotomic fields is equal to the cyclotomic field
  <math|<Q><around|(|\<zeta\><rsub|<math-up|lcm><around|(|n,m|)>>|)>>.
  Further, the intersection <math|<Q><around|(|\<zeta\><rsub|n>|)>\<cap\><Q><around|(|\<zeta\><rsub|m>|)>>
  of cyclotomic fields is equal to the cyclotomic field
  <math|<Q><around|(|\<zeta\><rsub|<math-up|gcd><around|(|n,m|)>>|)>>. Note
  that <math|<Q><around|(|\<zeta\><rsub|n>|)><rsup|+>=<Q><around|(|\<zeta\><rsub|n>+<wide|\<zeta\>|\<bar\>><rsub|n>|)>=<Q><around|(|\<zeta\><rsub|n>+\<zeta\><rsub|n><rsup|-1>|)>>.
  Clearly, if <math|n> divides <math|m> then
  <math|<Q><around|(|\<zeta\><rsub|n>|)>> is a subfield of
  <math|<Q><around|(|\<zeta\><rsub|m>|)>>. Since
  <math|<Q><around|(|\<zeta\><rsub|n>|)>=<Q><around|(|\<zeta\><rsub|2*n>|)>>
  for odd <math|n> by Fact<nbsp><reference|gau>, we may sometimes restrict
  ourselves to <math|n\<in\><N>> with <math|n\<nequiv\>2<pmod|4>>.

  <subsection|Cross ratios>

  Let <math|<around|(|t<rsub|1>,t<rsub|2>,t<rsub|3>,t<rsub|4>|)>> be an
  ordered tuple of four pairwise distinct elements of
  <math|\<bbb-R\>\<cup\><around|{|\<infty\>|}>>. Then, its
  <with|font-shape|italic|cross ratio> <math|<around|\<langle\>|t<rsub|1>,t<rsub|2>,t<rsub|3>,t<rsub|4>|\<rangle\>>>
  is the nonzero real number defined by

  <\equation*>
    <around|\<langle\>|t<rsub|1>,t<rsub|2>,t<rsub|3>,t<rsub|4>|\<rangle\>>\<assign\><frac|<around|(|t<rsub|3>-t<rsub|1>|)>*<around|(|t<rsub|4>-t<rsub|2>|)>|<around|(|t<rsub|3>-t<rsub|2>|)>*<around|(|t<rsub|4>-t<rsub|1>|)>><space|0.17em>,
  </equation*>

  with the usual conventions if one of the <math|t<rsub|i>> equals
  <math|\<infty\>>. We need the following invariance property of cross ratios
  of slopes.

  <\fact>
    <cite-detail|H|Lemma 2.17><label|crossratio> Let
    <math|z<rsub|1>,z<rsub|2>,z<rsub|3>,z<rsub|4>\<in\><C><rsup|\<ast\>>> be
    pairwise nonparallel and let <math|\<Psi\>> be a linear automorphism of
    the complex plane. Then, one has

    <\equation*>
      <around*|\<langle\>|<math-up|sl><around|(|z<rsub|1>|)>,<math-up|sl><around|(|z<rsub|2>|)>,<math-up|sl><around|(|z<rsub|3>|)>,<math-up|sl><around|(|z<rsub|4>|)>|\<rangle\>>=<around*|\<langle\>|<math-up|sl><around|(|\<Psi\><around|(|z<rsub|1>|)>|)>,<math-up|sl><around|(|\<Psi\><around|(|z<rsub|2>|)>|)>,<math-up|sl><around|(|\<Psi\><around|(|z<rsub|3>|)>|)>,<math-up|sl><around|(|\<Psi\><around|(|z<rsub|4>|)>|)>|\<rangle\>><space|0.17em>.*\<Box\>
    </equation*>
  </fact>

  <\fact>
    <cite-detail|H|Lemma 2.20><label|crkn4gen> Let
    <math|<varLambda>\<subset\><C>>. Then the cross ratio of slopes of four
    pairwise nonparallel <math|<varLambda>>-directions is an element of
    <math|K<rsub|<varLambda>><rsup|+>>.<math|\<Box\>>
  </fact>

  <section|Algebraic Delone sets>

  The following notions will be useful; see also<nbsp><cite|H3>, <cite|H4>,
  <cite|H5> for generalisations and for results related to those presented
  below.

  <\defi>
    <label|algdeldef>A Delone set <math|<varLambda>\<subset\><C>> is called
    an <with|font-shape|italic|algebraic Delone set> if it satisfies the
    following properties:

    <eqnarray*|<tformat|<table|<row|<cell|<text|(Alg)>>|<cell|>|<cell|<around|[|K<rsub|<varLambda>>:<Q>|]>\<less\>\<infty\><space|0.17em>.>>|<row|<cell|<text|(Hom)>>|<cell|>|<cell|<text|For
    any finite subset <math|F> of <math|K<rsub|<varLambda>>>, there is a
    homothety>>>|<row|<cell|>|<cell|>|<cell|<math|h><text| of the complex
    plane such that <math|h<around|(|F|)>\<subset\><varLambda>><space|0.17em>.
    >>>>>>

    Moreover, <math|<varLambda>> is called an
    <with|font-shape|italic|<math|n>-cyclotomic Delone set> if it satisfies
    the property

    <\equation*>
      <text|(<math|n>-Cyc)><space|1em><space|1em>K<rsub|<varLambda>>\<subset\><Q><around|(|\<zeta\><rsub|n>|)>
    </equation*>

    for some <math|n\<geq\>3> and has property (Hom). Further,
    <math|<varLambda>> is called a <with|font-shape|italic|cyclotomic Delone
    set> if it is an <math|n>-cyclotomic Delone set for a suitable
    <math|n\<geq\>3>.
  </defi>

  <\rem>
    <label|remalg>Algebraic Delone sets were already introduced
    in<nbsp><cite-detail|H5|Definition 4.1>. Clearly, for every algebraic
    Delone set <math|<varLambda>>, the field extension
    <math|K<rsub|<varLambda>>/<Q>> is an imaginary extension (due to
    <math|<varLambda>> being relatively dense) with
    <math|<wide|K<rsub|<varLambda>>|\<bar\>>=K<rsub|<varLambda>>>. By the
    Kronecker-Weber theorem (cf.<nbsp><cite-detail|Wa|Thm.<nbsp> 14.1>) and
    Fact<nbsp><reference|gau>, the cyclotomic Delone sets are precisely the
    algebraic Delone sets <math|<varLambda>> with the additional property
    that <math|K<rsub|<varLambda>>/<Q>> is an Abelian extension.
  </rem>

  Following Moody<nbsp><cite|Moody>, modified along the lines of the
  algebraic setting of Pleasants<nbsp><cite|PABP>, we define as follows.

  <\defi>
    <label|algmodel>Let <math|K\<subset\><C>> be an imaginary quadratic
    extension of a real algebraic number field (necessarily, this real
    algebraic number field is <math|K<rsup|+>>) of degree
    <math|<around|[|K:<Q>|]>=:d> over <math|<Q>> (in particular, <math|d> is
    even). Let <math|\<cal-O\><rsub|K>> be the ring of integers in <math|K>
    and let <math|.<rsup|\<star\>><space|-0.17em>:<space|0.17em>\<cal-O\><rsub|K>\<rightarrow\><C><rsup|s-1>\<times\><R><rsup|t>>
    be any map of the form <math|z\<mapsto\><around|(|\<sigma\><rsub|2><around|(|z|)>,\<ldots\>,\<sigma\><rsub|s><around|(|z|)>,\<sigma\><rsub|s+1><around|(|z|)>,\<ldots\>,\<sigma\><rsub|s+t><around|(|z|)>|)>>,
    where <math|\<sigma\><rsub|s+1>,\<ldots\>,\<sigma\><rsub|s+t>> are the
    real embeddings of <math|K/<Q>> into <math|<C>/<Q>> and
    <math|\<sigma\><rsub|2>,\<ldots\>,\<sigma\><rsub|s>> arise from the
    complex embeddings of <math|K/<Q>> into <math|<C>/<Q>> except the
    identity and the complex conjugation by choosing exactly one embedding
    from each pair of complex conjugate ones (in particular, <math|d=2*s+t>
    and <math|s\<geq\>1>). Then, for any such choice, each translate
    <math|<varLambda>> of

    <\equation*>
      <varLambda><around|(|W|)>\<assign\><around|{|z\<in\>\<cal-O\><rsub|K><space|0.17em>\|<space|0.17em>z<rsup|\<star\>>\<in\>W|}><space|0.17em>,
    </equation*>

    where <math|W\<subset\><C><rsup|s-1>\<times\><R><rsup|t>\<simeq\><R><rsup|d-2>>
    is a relatively compact set with nonempty interior, is called a
    <em|<math|K>-algebraic model set>. Moreover, <math|.<rsup|\<star\>>> and
    <math|W> are called the <em|star map> and the <em|window> of
    <math|<varLambda>>, respectively.
  </defi>

  <\rem>
    <label|modelrem>Algebraic number fields <math|K> as above may be obtained
    by starting with a real algebraic number field <math|L> and adjoining the
    square root of a negative number from <math|L>. Note that, in the
    situation of Definition<nbsp><reference|algmodel>, the quadratic
    extension <math|K/K<rsup|+>> is a Galois extension with
    <math|G*<around|(|K/K<rsup|+>|)>> containing the identity and the complex
    conjugation (in particular, one has <math|<wide|K|\<bar\>>=K>). We use
    the convention that for <math|d=2> (meaning that <math|s=1> and
    <math|t=0>), <math|<C><rsup|s-1>\<times\><R><rsup|t>> is the trivial
    group <math|<around|{|0|}>> and the star map is the zero map. Due to the
    Minkowski representation <math|<around|{|<around|(|z,z<rsup|\<star\>>|)><space|0.17em>\|<space|0.17em>z\<in\>\<cal-O\><rsub|K>|}>>
    of the maximal order <math|\<cal-O\><rsub|K>> of <math|K> being a (full)
    lattice in <math|<C>\<times\><C><rsup|s-1>\<times\><R><rsup|t>\<simeq\><R><rsup|d>>
    (cf.<nbsp><cite-detail|Bo|Ch.<nbsp>2, Sec.<nbsp>3>) that is in one-to-one
    correspondence with <math|\<cal-O\><rsub|K>> via the canonical projection
    on the first factor and due to <math|\<cal-O\><rsub|K><rsup|\<star\>>>
    being a dense subset of <math|<C><rsup|s-1>\<times\><R><rsup|t>> (see
    Lemma<nbsp><reference|dense> below), <math|K>-algebraic model sets are
    indeed <with|font-shape|italic|model sets> and thus are Meyer sets;
    cf.<nbsp><cite|BM>, <cite|BM2>, <cite|Moody>, <cite|Schl2>, <cite|Schl>
    for the general setting and further properties of model sets. Since the
    star map is a monomorphism of Abelian groups for <math|d\<gtr\>2> and
    since the window is a bounded set, a <math|K>-algebraic model set
    <math|<varLambda>> is periodic if and only if <math|d=2>, in which case
    <math|<varLambda>> is a translate of the planar lattice
    <math|\<cal-O\><rsub|K>>.
  </rem>

  A real algebraic integer <math|\<lambda\>> is called a
  <with|font-shape|italic|Pisot-Vijayaraghavan number>
  (<with|font-shape|italic|PV-number>) if <math|\<lambda\>\<gtr\>1> while all
  other conjugates of <math|\<lambda\>> have moduli strictly less than
  <math|1>.

  <\fact>
    <cite-detail|Sa|Ch.<nbsp>1, Thm.<nbsp> 2><label|pisot> Every real
    algebraic number field contains a primitive element that is a
    PV-number.<math|\<Box\>>
  </fact>

  Before we can show that <math|K>-algebraic model sets are algebraic Delone
  sets, we need the following lemmata.

  <\lem>
    <label|r2>Let <math|<varLambda>> be a nonperiodic <math|K>-algebraic
    model set with star map <math|.<rsup|\<star\>>>. Then, there is an
    algebraic integer <math|\<lambda\>\<in\>K<rsup|+>> such that a suitable
    power of the <math|<Z>>-module endomorphism
    <math|m<rsub|\<lambda\>><rsup|\<star\>>> of
    <math|\<cal-O\><rsub|K><rsup|\<star\>>>, defined by
    <math|m<rsub|\<lambda\>><rsup|\<star\>><around|(|z<rsup|\<star\>>|)>=<around|(|\<lambda\>*z|)><rsup|\<star\>>>,
    is contractive, i.e., there is an <math|l\<in\><N>> and a real number
    <math|c\<in\><around|(|0,1|)>> such that
    <math|<around|\<\|\|\>|<around|(|m<rsub|\<lambda\>><rsup|\<star\>>|)><rsup|l><around|(|z<rsup|\<star\>>|)>|\<\|\|\>>\<leq\>c<space|0.17em><around|\<\|\|\>|z<rsup|\<star\>>|\<\|\|\>>>
    holds for all <math|z\<in\>\<cal-O\><rsub|K>>.
  </lem>

  <\proof>
    By Fact<nbsp><reference|pisot>, we may choose a PV-number
    <math|\<lambda\>> of degree <math|d/2=<around|[|K<rsup|+>:<Q>|]>> in
    <math|K<rsup|+>>, where <math|d=<around|[|K:<Q>|]>\<geq\>4> due to the
    nonperiodicity; see Remark<nbsp><reference|modelrem>. Since all norms on
    <math|<C><rsup|s-1>\<times\><R><rsup|t>\<simeq\><R><rsup|d-2>> are
    equivalent, it suffices to prove the assertion in case of the maximum
    norm on <math|<C><rsup|s-1>\<times\><R><rsup|t>> with respect to the
    absolute value on <math|<C>> and <math|<R>>, respectively, rather than
    considering the Euclidean norm itself. But in that case, the assertion
    follows immediately with <math|l\<assign\>1> and

    <\equation*>
      c\<assign\><math-up|max><around*|{|<around|\<lvert\>|\<sigma\><rsub|j><around|(|\<lambda\>|)>|\<rvert\>><space|0.17em><mid|\|><space|0.17em>j\<in\><around|{|2,\<ldots\>,s+t|}>|}><space|0.17em>,
    </equation*>

    since the set <math|<around|{|\<sigma\><rsub|2><around|(|\<lambda\>|)>,\<ldots\>,\<sigma\><rsub|s+t><around|(|\<lambda\>|)>|}>>
    of conjugates of <math|\<lambda\>> does not contain <math|\<lambda\>>
    itself. To see this, note that <math|\<sigma\><rsub|j><around|(|\<lambda\>|)>=\<lambda\>>,
    where <math|j\<in\><around|{|2,\<ldots\>,s+t|}>>, implies that
    <math|\<sigma\><rsub|j>> fixes <math|K<rsup|+>> whence
    <math|\<sigma\><rsub|j>> is the identity or the complex conjugation, a
    contradiction; see<nbsp>Definition<nbsp><reference|algmodel> and
    Remark<nbsp><reference|modelrem>.
  </proof>

  <\lem>
    <label|dense>Let <math|<varLambda>> be a <math|K>-algebraic model set
    with star map <math|.<rsup|\<star\>>> and let
    <math|d\<assign\><around|[|K:<Q>|]>>. Then
    <math|\<cal-O\><rsub|K><rsup|\<star\>>> is dense in
    <math|<C><rsup|s-1>\<times\><R><rsup|t>\<simeq\><R><rsup|d-2>>.
  </lem>

  <\proof>
    If <math|d=2>, one even has <math|\<cal-O\><rsub|K><rsup|\<star\>>=<C><rsup|s-1>\<times\><R><rsup|t>=<around|{|0|}>>.
    Otherwise, choose a PV-number <math|\<lambda\>> of degree <math|d/2> in
    <math|K<rsup|+>>; cf.<nbsp>Fact<nbsp><reference|pisot>. Since
    <math|\<cal-O\><rsub|K>> is a full <math|<Z>>-module in <math|K>, the set
    <math|<around|{|\<lambda\><rsup|k>*z<space|0.17em>\|<space|0.17em>z\<in\>\<cal-O\><rsub|K>|}>>
    is a full <math|<Z>>-module in <math|K> for any <math|k\<in\><N>> . Thus
    the set

    <\equation*>
      <around|{|<around|(|\<lambda\><rsup|k>*z,<around|(|m<rsub|\<lambda\>><rsup|\<star\>>|)><rsup|k><around|(|z<rsup|\<star\>>|)>|)><space|0.17em>\|<space|0.17em>z\<in\>\<cal-O\><rsub|K>|}><space|0.17em>,
    </equation*>

    is a (full) lattice in <math|<C><rsup|s>\<times\><R><rsup|t>\<simeq\><R><rsup|d>>
    for any <math|k\<in\><N>>, where <math|m<rsub|\<lambda\>><rsup|\<star\>>>
    is the <math|<Z>>-module endomorphism of
    <math|\<cal-O\><rsub|K><rsup|\<star\>>> from Lemma<nbsp><reference|r2>;
    cf.<nbsp><cite-detail|Bo|Ch.<nbsp>2, Sec.<nbsp>3>. In conjunction with
    Lemma<nbsp><reference|r2>, this implies that, for any
    <math|\<varepsilon\>\<gtr\>0>, the <math|<Z>>-module
    <math|\<cal-O\><rsub|K><rsup|\<star\>>> contains an <math|<R>>-basis of
    <math|<C><rsup|s-1>\<times\><R><rsup|t>> whose elements have norms
    <math|\<leq\>\<varepsilon\>>. The assertion follows.
  </proof>

  <\lem>
    <label|dilate>Let <math|<varLambda>> be a <math|K>-algebraic model set.
    Then, for any finite set <math|F\<subset\>K>, there is a homothety
    <math|h> of the complex plane such that
    <math|h<around|(|F|)>\<subset\><varLambda>>. Moreover, <math|h> can be
    chosen such that <math|h<around|(|z|)>=\<kappa\>*z+v>, where
    <math|\<kappa\>\<in\>K<rsup|+>> is an algebraic integer with
    <math|\<kappa\>\<geq\>1> and <math|v\<in\><varLambda>>.
  </lem>

  <\proof>
    Without loss of generality, we may assume that <math|<varLambda>> is of
    the form <math|<varLambda><around|(|W|)>> (see
    Definition<nbsp><reference|algmodel>) and that
    <math|F\<neq\>\<varnothing\>>. Note that there is an
    <math|l\<in\>\<bbb-N\>> such that <math|<around|{|l*z<space|0.17em>\|<space|0.17em>z\<in\>F|}>\<subset\>\<cal-O\><rsub|K>>.
    Let <math|d\<assign\><around|[|K:<Q>|]>> and let <math|.<rsup|\<star\>>>
    be the star map of <math|<varLambda>>. If <math|d=2>, we are done by
    setting <math|h<around|(|z|)>\<assign\>l*z>. Otherwise, since <math|W>
    has nonempty interior, Lemma<nbsp><reference|dense> shows the existence
    of a suitable <math|z<rsub|0>\<in\>\<cal-O\><rsub|K>> with
    <math|z<rsub|0><rsup|\<star\>>\<in\>W<rsup|\<circ\>>>. Consider the open
    neighbourhood <math|V\<assign\>W<rsup|\<circ\>>-z<rsub|0><rsup|\<star\>>>
    of <math|0> in <math|<C><rsup|s-1>\<times\><R><rsup|t>> and choose a
    PV-number <math|\<lambda\>> of degree <math|d/2> in <math|K<rsup|+>>;
    cf.<nbsp>Fact<nbsp><reference|pisot>. By virtue of
    Lemma<nbsp><reference|r2>, there is a <math|k\<in\>\<bbb-N\>> such that

    <\equation*>
      <around|(|m<rsub|\<lambda\>><rsup|\<star\>>|)><rsup|k><around*|(|<around|(|l*F|)><rsup|\<star\>>|)>\<subset\>V<space|0.17em>.
    </equation*>

    It follows that <math|<around|{|<around|(|\<lambda\><rsup|k>*z+z<rsub|0>|)><rsup|\<star\>><space|0.17em>\|<space|0.17em>z\<in\>l*F|}>\<subset\>W<rsup|\<circ\>>>
    and, further, that <math|h<around|(|F|)>\<subset\><varLambda>>, where
    <math|h> is the homothety given by <math|z\<mapsto\><around|(|l*\<lambda\><rsup|k>|)>*z+z<rsub|0>>.
    The additional statement follows immediately from the observation that
    <math|z<rsub|0>\<in\><varLambda>>.
  </proof>

  <\prop>
    <label|cmsads><math|K>-algebraic model sets are algebraic Delone sets.
    Moreover, any <math|K>-algebraic model set <math|<varLambda>> satisfies
    <math|K<rsub|<varLambda>>=K>.
  </prop>

  <\proof>
    Since <math|K<rsub|<varLambda>>=K<rsub|t+<varLambda>>> for any
    <math|t\<in\><C>>, we may assume that <math|<varLambda>> is of the form
    <math|<varLambda><around|(|W|)>> (see
    Definition<nbsp><reference|algmodel>). Any <math|K>-algebraic model set
    <math|<varLambda>> is a Delone set by Remark<nbsp><reference|modelrem>.
    Property (Alg) follows from the observation that
    <math|K<rsub|<varLambda>>\<subset\>K> (recall that
    <math|<varLambda>-<varLambda>\<subset\>\<cal-O\><rsub|K>> and that
    <math|<wide|K|\<bar\>>=K>). Further, property (Hom) is an immediate
    consequence of Lemma<nbsp><reference|dilate>. Let
    <math|<around|{|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|d>|}>> be a
    <math|<Q>>-basis of <math|K/<Q>>. By the additional statement of
    Lemma<nbsp><reference|dilate> there is a nonzero element
    <math|\<kappa\>\<in\>K<rsup|+>> and a point <math|v\<in\><varLambda>>
    such that the <math|<Q>>-linear independent set
    <math|<around|{|\<kappa\>*\<alpha\><rsub|1>,\<ldots\>,\<kappa\>*\<alpha\><rsub|d>|}>>
    is contained in <math|<varLambda>-<around|{|v|}>\<subset\>K<rsub|<varLambda>>>.
    Since <math|K<rsub|<varLambda>>\<subset\>K>, this shows that
    <math|K<rsub|<varLambda>>=K>.
  </proof>

  <\rem>
    <label|okdirections>As another immediate consequence of
    Lemma<nbsp><reference|dilate>, one verifies that, for any
    <math|K>-algebraic model set <math|<varLambda>>, the set of
    <math|<varLambda>>-directions is precisely the set of
    <math|\<cal-O\><rsub|K>>-directions.
  </rem>

  <\ex>
    <label|algex>Standard examples of <math|n>-cyclotomic Delone sets are the
    <math|<Q><around|(|\<zeta\><rsub|n>|)>>-algebraic model sets, where
    <math|n\<geq\>3>, which from now on are called
    <with|font-shape|italic|<math|n>-cyclotomic model sets>;
    cf.<nbsp>Fact<nbsp><reference|gau> and
    Proposition<nbsp><reference|cmsads> (note also that
    <math|<Q><around|(|\<zeta\><rsub|n>|)>> is obtained from
    <math|<Q><around|(|\<zeta\><rsub|n>|)><rsup|+>> by adjoining the square
    root of the negative number <math|\<zeta\><rsub|n><rsup|2>+\<zeta\><rsub|n><rsup|-2>-2\<in\><Q><around|(|\<zeta\><rsub|n>|)><rsup|+>>,
    the latter being the discriminant of <math|X<rsup|2>-<around|(|\<zeta\><rsub|n>+\<zeta\><rsub|n><rsup|-1>|)>*X+1>).
    These sets were also called <with|font-shape|italic|cyclotomic model sets
    with underlying <math|<Z>>-module <math|<Z><around|[|\<zeta\><rsub|n>|]>>>
    in<nbsp><cite-detail|H5|Sec.<nbsp>4.5>, since
    <math|<Z><around|[|\<zeta\><rsub|n>|]>> is the ring of integers in the
    <math|n>th cyclotomic field; cf.<nbsp><cite-detail|Wa|Thm.<nbsp> 2.6>.
    The latter range from periodic examples like the fourfold square lattice
    (<math|n=4>) or the sixfold triangular lattice (<math|n=3>) to
    nonperiodic examples like the vertex set of the tenfold Tbingen triangle
    tiling<nbsp><cite|bk1>, <cite|bk2> (<math|n=5>), the eightfold
    Ammann-Beenker tiling of the plane<nbsp><cite|am>, <cite|bj>, <cite|ga>
    (<math|n=8>) or the twelvefold shield tiling<nbsp><cite|ga>
    (<math|n=12>); see<nbsp><cite-detail|H4|Fig.<nbsp>1>,
    <nbsp><cite-detail|H5|Fig.<nbsp>2> and
    Fig.<nbsp><reference|fig:tilingupolygon> below for illustrations. In
    general, for any divisor <math|m> of <math|<math-up|lcm><around|(|n,2|)>>,
    one can choose the window such that the corresponding <math|n>-cyclotomic
    model sets have <math|m>-fold cyclic symmetry in the sense of symmetries
    of LI-classes, meaning that a discrete structure has a certain symmetry
    if the original and the transformed structure are locally
    indistinguishable; cf.<nbsp><cite|B> for details. Note that the vertex
    sets of the famous Penrose tilings of the plane fail to be
    <math|5>-cyclotomic model sets but can still be seen to be
    <math|5>-cyclotomic Delone sets; see<nbsp><cite|bh> and references
    therein.
  </ex>

  <section|A cyclotomic theorem><label|cyc>

  <\defi>
    <label|fmddefi>Let <math|m\<geq\>4> be a natural number. Set

    <\equation*>
      D<rsub|m>\<assign\><around*|{|<around|(|k<rsub|1>,k<rsub|2>,k<rsub|3>,k<rsub|4>|)>\<in\>\<bbb-N\><rsup|4><space|0.17em><mid|\|><space|0.17em>k<rsub|3>\<less\>k<rsub|1>\<leq\>k<rsub|2>\<less\>k<rsub|4>\<leq\>m-1*<text|and
      >k<rsub|1>+k<rsub|2>=k<rsub|3>+k<rsub|4>|}>
    </equation*>

    and define the function <math|f<rsub|m><space|0.17em>:<space|0.17em>D<rsub|m>\<rightarrow\><C><rsup|\<ast\>>>
    by

    <\equation>
      <label|fmd>f<rsub|m><around|(|k<rsub|1>,k<rsub|2>,k<rsub|3>,k<rsub|4>|)>\<assign\><frac|<around|(|1-\<zeta\><rsub|m><rsup|k<rsub|1>>|)>*<around|(|1-\<zeta\><rsub|m><rsup|k<rsub|2>>|)>|<around|(|1-\<zeta\><rsub|m><rsup|k<rsub|3>>|)>*<around|(|1-\<zeta\><rsub|m><rsup|k<rsub|4>>|)>>.
    </equation>

    We further set <math|\<cal-C\><rsub|m>\<assign\>f<rsub|m><around|(|D<rsub|m>|)>>
    (note that <math|\<cal-C\><rsub|m>\<subset\>\<cal-C\><rsub|m<rprime|'>>>
    for any multiple <math|m<rprime|'>> of <math|m>) and
    <math|\<cal-C\>\<assign\><big|cup><rsub|m\<geq\>4>\<cal-C\><rsub|m>>.
    Moreover, for a subset <math|K> of <math|<C>>, we set
    <math|\<cal-C\><around|(|K|)>\<assign\>\<cal-C\>\<cap\>K> and
    <math|\<cal-C\><rsub|m><around|(|K|)>\<assign\>\<cal-C\><rsub|m>\<cap\>K>.
  </defi>

  <\fact>
    <label|fmdg1><cite-detail|GG|Lemma 3.1> Let <math|m\<geq\>4>. The
    function <math|f<rsub|m>> is real-valued. Moreover, one has
    <math|f<rsub|m><around|(|d|)>\<gtr\>1> for all
    <math|d\<in\>D<rsub|m>>.<math|\<Box\>>
  </fact>

  For our application to discrete tomography, we shall below show the
  <with|font-shape|italic|finiteness> of the set
  <math|\<cal-C\><around|(|L|)>> for all real algebraic number fields
  <math|L> and provide explicit results in the three cases
  <math|<Q><around|(|\<zeta\><rsub|5>|)><rsup|+>=<Q><around|(|<sqrt|5>|)>>,
  <math|<Q><around|(|\<zeta\><rsub|8>|)><rsup|+>=<Q><around|(|<sqrt|2>|)>>
  and <math|<Q><around|(|\<zeta\><rsub|12>|)><rsup|+>=<Q><around|(|<sqrt|3>|)>>.
  Gardner and Gritzmann showed the following result for the field
  <math|<Q>=<Q><around|(|\<zeta\><rsub|3>|)><rsup|+>=<Q><around|(|\<zeta\><rsub|4>|)><rsup|+>>.

  <\theorem>
    <cite-detail|GG|Lemma 3.8, Lemma 3.9 and Thm.<nbsp>
    3.10><label|intersectq>

    <\equation*>
      \<cal-C\><around|(|<Q>|)>=\<cal-C\><rsub|12><around|(|<Q>|)>=<around*|{|<tfrac|4|3>,<tfrac|3|2>,2,3,4|}><space|0.17em>.
    </equation*>

    Moreover, all solutions of <math|f<rsub|m><around|(|d|)>=q\<in\><Q>>,
    where <math|m\<geq\>4> and <math|d\<in\>D<rsub|m>>, are either given, up
    to multiplication of <math|m> and <math|d> by the same factor, by
    <math|m=12> and one of the following

    <\equation*>
      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|3|3|cell-halign|r>|<cwith|1|-1|4|4|cell-halign|l>|<cwith|1|-1|4|4|cell-rborder|0ln>|<table|<row|<cell|<text|(i)>>|<cell|d=<around|(|6,6,4,8|)>,q=<frac|4|3>;>|<cell|<text|(ii)>>|<cell|d=<around|(|6,6,2,10|)>,q=4;>>|<row|<cell|<text|(iii)>>|<cell|d=<around|(|4,8,3,9|)>,q=<frac|3|2>;>|<cell|<text|(iv)>>|<cell|d=<around|(|4,8,2,10|)>,q=3;>>|<row|<cell|<text|(v)>>|<cell|d=<around|(|4,4,2,6|)>,q=<frac|3|2>;>|<cell|<text|(vi)>>|<cell|d=<around|(|8,8,6,10|)>,q=<frac|3|2>;>>|<row|<cell|<text|(vii)>>|<cell|d=<around|(|4,4,1,7|)>,q=3;>|<cell|<text|(viii)>>|<cell|d=<around|(|8,8,5,11|)>,q=3;>>|<row|<cell|<text|(ix)>>|<cell|d=<around|(|3,9,2,10|)>,q=2;>|<cell|<text|(x)>>|<cell|d=<around|(|3,3,1,5|)>,q=2;>>|<row|<cell|<text|(xi)>>|<cell|d=<around|(|9,9,7,11|)>,q=2;>|<cell|>|<cell|>>>>>
    </equation*>

    or by one of the following

    <\equation*>
      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<text|(xii)>>|<cell|d=<around|(|2*k,s,k,k+s|)>,q=2,<text|where
      >s\<geq\>2,m=2*s*<text|and >1\<leq\>k\<leq\><frac|s|2>;>>|<row|<cell|<text|(xiii)>>|<cell|d=<around|(|s,2*k,k,k+s|)>,q=2,<text|where
      >s\<geq\>2,m=2*s*<text|and ><frac|s|2>\<leq\>k\<less\>s.*\<Box\>>>>>>
    </equation*>
  </theorem>

  The next three lemmata are the key tools for our approach.

  <\lem>
    <label|l1>Let <math|a\<in\><R><rsup|\<ast\>>>. If
    <math|a=<tfrac|1+x|1+y>> for <math|x,y\<in\>\<mu\>\<cup\><around|{|0|}>>
    with <math|y\<neq\>-1> then <math|a\<in\><around|{|<tfrac|1|2>,1,2|}>>.

    <\proof>
      It suffices to consider the cases <math|a=1+\<omega\>> and
      <math|a=<tfrac|1+\<omega\><rsub|1>|1+\<omega\><rsub|2>>> with
      <math|\<omega\>,\<omega\><rsub|1>,\<omega\><rsub|2>\<in\>\<mu\>> and
      <math|\<omega\><rsub|2>\<neq\>-1>. In the first case, one has
      <math|\<omega\>=a-1\<in\>\<mu\><around|(|<R>|)>={\<pm\>1}> whence
      <math|\<omega\>=1> (due to <math|a\<neq\>0>) and <math|a=2>. In the
      second case, one has

      <\equation*>
        a=<wide|a|\<bar\>>=<frac|1+<wide|\<omega\>|\<bar\>><rsub|1>|1+<wide|\<omega\>|\<bar\>><rsub|2>>=\<omega\><rsub|2>*\<omega\><rsub|1><rsup|-1>*<frac|1+\<omega\><rsub|1>|1+\<omega\><rsub|2>>=\<omega\><rsub|2>*\<omega\><rsub|1><rsup|-1>*a
      </equation*>

      wherefore <math|\<omega\><rsub|1>=\<omega\><rsub|2>> and <math|a=1>.
    </proof>
  </lem>

  <\lem>
    [Comparison of coefficients]<label|l2> Let <math|K\<subset\><C>> be a
    field, let <math|m\<in\><N>>, and let <math|\<zeta\>\<in\>\<mu\>> with
    <math|\<zeta\><rsup|m>\<in\>K>. Let <math|a<rsub|0>,\<ldots\>,a<rsub|m-1>,b<rsub|0>,\<ldots\>,b<rsub|m-1>\<in\>K>
    with

    <\equation*>
      <big|sum><rsub|i=0><rsup|m-1>a<rsub|i>*\<zeta\><rsup|i>=<big|sum><rsub|i=0><rsup|m-1>b<rsub|i>*\<zeta\><rsup|i><space|0.17em>.
    </equation*>

    Then one has <math|a<rsub|i>=b<rsub|i>> for all <math|i=0,\<ldots\>,m-1>
    if one of the following conditions holds.

    <\itemize>
      <item*|(a)><math|<around|[|K<around|(|\<zeta\>|)>:K|]>=m>.

      <item*|(b)><math|<around|[|K<around|(|\<zeta\>|)>:K|]>=m-1> and at most
      <math|m-1> of <math|a<rsub|0>,\<ldots\>,a<rsub|m-1>,b<rsub|0>,\<ldots\>,b<rsub|m-1>>
      are nonzero.
    </itemize>

    Moreover, if <math|<around|[|K<around|(|\<zeta\>|)>:K|]>=m-1> and
    <math|a<rsub|k>-b<rsub|k>\<neq\>0> for some <math|k> then
    <math|<around|\||a<rsub|i>-b<rsub|i>|\|>=<around|\||a<rsub|j>-b<rsub|j>|\|>\<neq\>0>
    for all <math|i,j>.
  </lem>

  <\proof>
    In case (a), the assertion follows immediately from the linear
    independence of <math|1,\<zeta\>,\<ldots\>,\<zeta\><rsup|m-1>> over
    <math|K>. If <math|<around|[|K<around|(|\<zeta\>|)>:K|]>=m-1>, set
    <math|\<omega\>\<assign\>\<zeta\><rsup|m>\<in\>K>. The minimum polynomial
    <math|f\<in\>K<around|[|X|]>> of <math|\<zeta\>> over <math|K> has degree
    <math|m-1> and one has <math|X<rsup|m>-\<omega\>=<around|(|X-\<epsilon\>|)>*f>
    with <math|\<epsilon\>\<in\>K>, hence
    <math|\<omega\>=\<epsilon\><rsup|m>> (in particular,
    <math|\<epsilon\>\<in\>\<mu\><around|(|K|)>>) and

    <\equation*>
      f=<frac|X<rsup|m>-\<epsilon\><rsup|m>|X-\<epsilon\>>=<big|sum><rsub|i=0><rsup|m-1>\<epsilon\><rsup|m-1-i>*X<rsup|i><space|0.17em>.
    </equation*>

    If <math|<big|sum><rsub|i=0><rsup|m-1><around|(|a<rsub|i>-b<rsub|i>|)>*\<zeta\><rsup|i>=0>
    then there is an element <math|c\<in\>K> with
    <math|a<rsub|i>=b<rsub|i>+c*\<epsilon\><rsup|m-1-i>> for all
    <math|i=0,\<ldots\>,m-1>. By assumption (b) one has
    <math|a<rsub|i>=0=b<rsub|i>> for some <math|i>. This implies <math|c=0>
    and therefore the assertion. For the additional statement, first observe
    that due to <math|a<rsub|k>\<neq\>b<rsub|k>> for some <math|k> one has
    <math|c\<neq\>0>. Thus <math|<around|\||a<rsub|i>-b<rsub|i>|\|>=<around|\||c*\<epsilon\><rsup|m-1-i>|\|>=<around|\||c|\|>=<around|\||c*\<epsilon\><rsup|m-1-j>|\|>=<around|\||a<rsub|j>-b<rsub|j>|\|>\<neq\>0>
    for all <math|i,j>.
  </proof>

  <\lem>
    <label|l3>Let <math|K\<subset\><C>> be a field, let <math|m\<in\><N>>,
    and let <math|\<zeta\>\<in\>\<mu\>> with <math|\<zeta\><rsup|m>\<in\>K>.
    Further, let <math|\<omega\><rsub|1>,\<omega\><rsub|2>,\<omega\><rsub|3>,\<omega\><rsub|4>\<in\>\<mu\><around|(|K|)>>
    and <math|k<rsub|1>,k<rsub|2>,k<rsub|3>,k<rsub|4>\<in\><around|{|0,\<ldots\>,m-1|}>>
    satisfy the following conditions.

    <\itemize>
      <item><math|<math-up|gcd><around|(|k<rsub|i>,m|)>=1> for some
      <math|i\<in\><around|{|1,2,3,4|}>>.

      <item><math|k<rsub|1>+k<rsub|2>\<equiv\>k<rsub|3>+k<rsub|4><pmod|m>>

      <item><math|\<omega\><rsub|3>*\<zeta\><rsup|k<rsub|3>>,\<omega\><rsub|4>*\<zeta\><rsup|k<rsub|4>>\<neq\>1>
      and <math|a\<assign\><frac|<around|(|1-\<omega\><rsub|1>*\<zeta\><rsup|k<rsub|1>>|)>*<around|(|1-\<omega\><rsub|2>*\<zeta\><rsup|k<rsub|2>>|)>|<around|(|1-\<omega\><rsub|3>*\<zeta\><rsup|k<rsub|3>>|)>*<around|(|1-\<omega\><rsub|4>*\<zeta\><rsup|k<rsub|4>>|)>>\<in\>K\<cap\><around|(|<R><rsup|\<ast\>>\<setminus\>|{>\<pm\>1})>.
    </itemize>

    Then one has <math|a\<in\><around|{|<tfrac|1|2>,2|}>> if one of the
    following conditions holds.

    <\itemize>
      <item*|(a)><math|<around|[|K<around|(|\<zeta\>|)>:K|]>=m> and
      <math|m\<geq\>3>.

      <item*|(b)><math|<around|[|K<around|(|\<zeta\>|)>:K|]>=m-1> and
      <math|m\<geq\>5>.
    </itemize>
  </lem>

  <\proof>
    Without restriction, we may assume that
    <math|<math-up|gcd><around|(|k<rsub|1>,m|)>=1>. Then, for <math|i=2,3,4>,
    there are <math|a<rsub|i>,b<rsub|i>\<in\><Z>> such that
    <math|k<rsub|i>=a<rsub|i>*k<rsub|1>+b<rsub|i>*m> and, with
    <math|\<zeta\><rprime|'>\<assign\>\<zeta\><rsup|k<rsub|1>>>,
    <math|\<zeta\><rsup|k<rsub|i>>=<around|(|\<zeta\><rprime|'>|)><rsup|a<rsub|i>><around|(|\<zeta\><rsup|m>|)><rsup|b<rsub|i>>>.
    Since one has <math|<around|(|\<zeta\><rprime|'>|)><rsup|m>\<in\>K>,
    <math|K<around|(|\<zeta\><rprime|'>|)>=K<around|(|\<zeta\>|)>> and

    <\equation*>
      <frac|<around|(|1-\<omega\><rsub|1>*\<zeta\><rsup|k<rsub|1>>|)>*<around|(|1-\<omega\><rsub|2>*\<zeta\><rsup|k<rsub|2>>|)>|<around|(|1-\<omega\><rsub|3>*\<zeta\><rsup|k<rsub|3>>|)>*<around|(|1-\<omega\><rsub|4>*\<zeta\><rsup|k<rsub|4>>|)>>=<frac|<around|(|1-\<omega\><rprime|'><rsub|1>*\<zeta\><rprime|'>|)>*<around|(|1-\<omega\><rprime|'><rsub|2>*\<zeta\><rprime|'><rsup|k<rprime|'><rsub|2>>|)>|<around|(|1-\<omega\><rprime|'><rsub|3>*\<zeta\><rprime|'><rsup|k<rprime|'><rsub|3>>|)>*<around|(|1-\<omega\><rprime|'><rsub|4>*\<zeta\><rprime|'><rsup|k<rprime|'><rsub|4>>|)>>
    </equation*>

    for suitable <math|\<omega\><rprime|'><rsub|1>,\<omega\><rprime|'><rsub|2>,\<omega\><rprime|'><rsub|3>,\<omega\><rprime|'><rsub|4>\<in\>\<mu\><around|(|K|)>>
    and <math|k<rprime|'><rsub|2>,k<rprime|'><rsub|3>,k<rprime|'><rsub|4>\<in\><around|{|0,\<ldots\>,m-1|}>>
    with <math|1+k<rprime|'><rsub|2>\<equiv\>k<rprime|'><rsub|3>+k<rprime|'><rsub|4><pmod|m>>,
    we may further assume that <math|k<rsub|1>=1>. We thus obtain

    <\equation*>
      1-\<omega\><rsub|1>*\<zeta\>-\<omega\><rsub|2>*\<zeta\><rsup|k<rsub|2>>+\<omega\><rsub|1>*\<omega\><rsub|2>*\<zeta\><rsup|k<rsub|2>+1>=a-a*\<omega\><rsub|3>*\<zeta\><rsup|k<rsub|3>>-a*\<omega\><rsub|4>*\<zeta\><rsup|k<rsub|4>>+a*\<omega\><rsub|3>*\<omega\><rsub|4>*\<zeta\><rsup|k<rsub|3>+k<rsub|4>><space|0.17em>,
    </equation*>

    where, without restriction, <math|k<rsub|3>\<leq\>k<rsub|4>>. From now
    on, let <math|<around|[|k|]>\<in\><around|{|0,\<ldots\>,m-1|}>> denote
    the canonical representative of the equivalence class of
    <math|k\<in\><Z>> modulo <math|m>. We may finally write

    <\equation*>
      1-\<omega\><rsub|1>*\<zeta\>-\<omega\><rsub|2>*\<zeta\><rsup|k<rsub|2>>+\<omega\><rsub|1>*\<omega\><rsub|2>*\<omega\>*\<zeta\><rsup|<around|[|k<rsub|2>+1|]>>=a-a*\<omega\><rsub|3>*\<zeta\><rsup|k<rsub|3>>-a*\<omega\><rsub|4>*\<zeta\><rsup|<around|[|1+k<rsub|2>-k<rsub|3>|]>>+a*\<omega\><rsub|3>*\<omega\><rsub|4>*\<omega\><rprime|'>*\<zeta\><rsup|<around|[|k<rsub|2>+1|]>>
    </equation*>

    with <math|k<rsub|3>\<leq\><around|[|1+k<rsub|2>-k<rsub|3>|]>> and
    suitable <math|\<omega\>,\<omega\><rprime|'>\<in\>\<mu\><around|(|K|)>>.

    <with|font-series|bold|Case 1.> <math|k<rsub|2>=0>. Then

    <\equation*>
      1-\<omega\><rsub|1>*\<zeta\>-\<omega\><rsub|2>+\<omega\><rsub|1>*\<omega\><rsub|2>*\<omega\>*\<zeta\>=a-a*\<omega\><rsub|3>*\<zeta\><rsup|k<rsub|3>>-a*\<omega\><rsub|4>*\<zeta\><rsup|<around|[|1-k<rsub|3>|]>>+a*\<omega\><rsub|3>*\<omega\><rsub|4>*\<omega\><rprime|'>*\<zeta\>
    </equation*>

    If <math|k<rsub|3>=0> then <math|a=<frac|1-\<omega\><rsub|2>|1-\<omega\><rsub|3>>>
    by Lemma<nbsp><reference|l2> and the assertion follows from
    Lemma<nbsp><reference|l1>. The case <math|k<rsub|3>=1> cannot occur (due
    to <math|k<rsub|3>\<leq\><around|[|1-k<rsub|3>|]>>), whereas
    <math|k<rsub|3>\<geq\>2> implies <math|a=1-\<omega\><rsub|2>> by
    Lemma<nbsp><reference|l2>. The assertion follows from
    Lemma<nbsp><reference|l1>.

    <with|font-series|bold|Case 2.> <math|k<rsub|2>=1>. Then

    <\equation*>
      1-<around|(|\<omega\><rsub|1>+\<omega\><rsub|2>|)>*\<zeta\>+\<omega\><rsub|1>*\<omega\><rsub|2>*\<omega\>*\<zeta\><rsup|2>=a-a*\<omega\><rsub|3>*\<zeta\><rsup|k<rsub|3>>-a*\<omega\><rsub|4>*\<zeta\><rsup|<around|[|2-k<rsub|3>|]>>+a*\<omega\><rsub|3>*\<omega\><rsub|4>*\<omega\><rprime|'>*\<zeta\><rsup|2>
    </equation*>

    If <math|k<rsub|3>=0> then <math|a=<frac|1|1-\<omega\><rsub|3>>> by
    Lemma<nbsp><reference|l2> and the assertion follows from
    Lemma<nbsp><reference|l1>. If <math|k<rsub|3>=1> then
    Lemma<nbsp><reference|l2> implies <math|a=1>, which is excluded by
    assumption. The case <math|k<rsub|3>=2> is impossible (due to
    <math|k<rsub|3>\<leq\><around|[|2-k<rsub|3>|]>>). Let
    <math|k<rsub|3>\<geq\>3> (hence <math|m\<geq\>4>). Under
    condition<nbsp>(a), this implies <math|a=1> by Lemma<nbsp><reference|l2>,
    which is excluded by assumption. Under condition<nbsp>(b),
    <math|k<rsub|3>=3> implies

    <\equation*>
      1-<around|(|\<omega\><rsub|1>+\<omega\><rsub|2>|)>*\<zeta\>+\<omega\><rsub|1>*\<omega\><rsub|2>*\<omega\>*\<zeta\><rsup|2>=a-a*\<omega\><rsub|3>*\<zeta\><rsup|3>-a*\<omega\><rsub|4>*\<zeta\><rsup|m-1>+a*\<omega\><rsub|3>*\<omega\><rsub|4>*\<omega\><rprime|'>*\<zeta\><rsup|2>
    </equation*>

    with <math|m-1\<geq\>4> (due to <math|m\<geq\>5>). The additional
    statement of Lemma<nbsp><reference|l2> implies <math|m=5> and
    <math|<around|\||1-a|\|>=<around|\||a*\<omega\><rsub|4>|\|>=<around|\||a|\|>>,
    wherefore <math|a=1/2>. If <math|k<rsub|3>\<geq\>4> then <math|m\<geq\>6>
    (due to <math|k<rsub|3>\<leq\><around|[|2-k<rsub|3>|]>>) and
    Lemma<nbsp><reference|l2> implies <math|a=1>, which is excluded by
    assumption.

    <with|font-series|bold|Case 3.> <math|k<rsub|2>\<in\><around|{|2,\<ldots\>,m-2|}>>
    (hence <math|m\<geq\>4> and <math|2\<leq\>k<rsub|2>\<less\>k<rsub|2>+1\<leq\>m-1>).
    Then

    <\equation*>
      <around|(|1-a|)>-\<omega\><rsub|1>*\<zeta\>-\<omega\><rsub|2>*\<zeta\><rsup|k<rsub|2>>+<around|(|\<omega\><rsub|1>*\<omega\><rsub|2>*\<omega\>-a*\<omega\><rsub|3>*\<omega\><rsub|4>*\<omega\><rprime|'>|)>*\<zeta\><rsup|k<rsub|2>+1>=-a*\<omega\><rsub|3>*\<zeta\><rsup|k<rsub|3>>-a*\<omega\><rsub|4>*\<zeta\><rsup|<around|[|1+k<rsub|2>-k<rsub|3>|]>>
    </equation*>

    Under condition<nbsp>(a), Lemma<nbsp><reference|l2> shows that this is
    impossible, since there are at least three nontrivial coefficients on the
    left-hand side and at most two nontrivial coefficients on the right-hand
    side of this equation. Under condition<nbsp>(b) (hence <math|m\<geq\>5>),
    <math|k<rsub|3>=0> implies <math|a-1=a*\<omega\><rsub|3>> by
    Lemma<nbsp><reference|l2> wherefore <math|a=<frac|1|1-\<omega\><rsub|3>>>
    and the assertion follows from Lemma<nbsp><reference|l1>. If
    <math|k<rsub|3>=1> then <math|a=1> by Lemma<nbsp><reference|l2>, which is
    excluded by assumption. If <math|k<rsub|3>\<geq\>2> and <math|m\<geq\>7>
    then <math|a=1> by Lemma<nbsp><reference|l2>, which is excluded by
    assumption. Employing the additional statement of
    Lemma<nbsp><reference|l2>, we shall now see that the missing cases
    (<math|k<rsub|3>\<geq\>2> and <math|m\<in\><around|{|5,6|}>>) are either
    impossible or yield <math|<around|\||1-a|\|>=1> and thus <math|a=2> (due
    to <math|a\<neq\>0>). In fact, <math|m=5> and <math|k<rsub|3>=2> imply
    <math|k<rsub|2>=3> (due to <math|k<rsub|3>\<leq\><around|[|1+k<rsub|2>-k<rsub|3>|]>>)
    and, further, <math|<around|\||1-a|\|>=<around|\||\<omega\><rsub|1>|\|>=1>.
    The case <math|m=5> and <math|k<rsub|3>=3> cannot occur (due to
    <math|k<rsub|3>\<leq\><around|[|1+k<rsub|2>-k<rsub|3>|]>>). If <math|m=5>
    and <math|k<rsub|3>=4> then <math|k<rsub|2>=2> (due to
    <math|k<rsub|3>\<leq\><around|[|1+k<rsub|2>-k<rsub|3>|]>>) and, further,
    <math|<around|\||1-a|\|>=<around|\||\<omega\><rsub|1>|\|>=1>. If
    <math|m=6> and <math|k<rsub|3>=2> then
    <math|k<rsub|2>\<in\><around|{|3,4|}>> (due to
    <math|k<rsub|3>\<leq\><around|[|1+k<rsub|2>-k<rsub|3>|]>>). The case
    <math|k<rsub|2>=3> is impossible, whereas the case <math|k<rsub|2>=4>
    yields <math|<around|\||1-a|\|>=<around|\||\<omega\><rsub|1>|\|>=1>. The
    case <math|m=6> and <math|k<rsub|3>=3> is impossible (due to
    <math|k<rsub|3>\<leq\><around|[|1+k<rsub|2>-k<rsub|3>|]>>). The case
    <math|m=6> and <math|k<rsub|3>=4> implies <math|k<rsub|2>=2> (due to
    <math|k<rsub|3>\<leq\><around|[|1+k<rsub|2>-k<rsub|3>|]>>) and, further,
    <math|<around|\||1-a|\|>=<around|\||\<omega\><rsub|1>|\|>=1>. Finally,
    the case <math|m=6> and <math|k<rsub|3>=5> implies <math|k<rsub|2>=3>
    (due to <math|k<rsub|3>\<leq\><around|[|1+k<rsub|2>-k<rsub|3>|]>>) and,
    once again, <math|<around|\||1-a|\|>=<around|\||\<omega\><rsub|1>|\|>=1>.

    <with|font-series|bold|Case 4.> <math|k<rsub|2>=m-1>. Then

    <\equation*>
      <around|(|1+\<omega\><rsub|1>*\<omega\><rsub|2>*\<omega\>|)>-\<omega\><rsub|1>*\<zeta\>-\<omega\><rsub|2>*\<zeta\><rsup|m-1>=a*<around|(|1+\<omega\><rsub|3>*\<omega\><rsub|4>*\<omega\><rprime|'>|)>-a*\<omega\><rsub|3>*\<zeta\><rsup|k<rsub|3>>-a*\<omega\><rsub|4>*\<zeta\><rsup|<around|[|m-k<rsub|3>|]>>
    </equation*>

    Under condition<nbsp>(a), Lemma<nbsp><reference|l2> implies
    <math|<around|{|k<rsub|3>,<around|[|m-k<rsub|3>|]>|}>=<around|{|1,m-1|}>>,
    wherefore <math|k<rsub|3>=1> and <math|<around|[|m-k<rsub|3>|]>=m-1> (due
    to <math|k<rsub|3>\<leq\><around|[|m-k<rsub|3>|]>>). Further,
    Lemma<nbsp><reference|l2> yields <math|a=\<omega\><rsub|2>/\<omega\><rsub|4>>,
    a contradiction (due to <math|<around|\||a|\|>\<neq\>1>). By the
    additional statement of Lemma<nbsp><reference|l2>, condition<nbsp>(b)
    (hence <math|m\<geq\>5>) implies <math|m=5>, <math|k<rsub|3>=2> and,
    further, <math|<around|\||a*\<omega\><rsub|3>|\|>=<around|\||\<omega\><rsub|2>|\|>=1>,
    a contradiction (due to <math|<around|\||a|\|>\<neq\>1>).
  </proof>

  We are now in a position to prove the following extension of
  Theorem<nbsp><reference|intersectq>.

  <\theorem>
    <label|t1>For <math|n\<in\><N>>, one has

    <\equation*>
      \<cal-C\><around|(|<Q><around|(|\<zeta\><rsub|n>|)><rsup|+>|)>=\<cal-C\><rsub|<math-up|lcm><around|(|2*n,12|)>><around|(|<Q><around|(|\<zeta\><rsub|n>|)><rsup|+>|)><space|0.17em>.
    </equation*>

    In particular, the last set is finite. Moreover, all solutions of
    <math|f<rsub|m><around|(|d|)>\<in\><Q><around|(|\<zeta\><rsub|n>|)><rsup|+>>,
    where <math|m\<geq\>4> and <math|d\<in\>D<rsub|m>>, are either of the
    form (xii) or (xiii) of Theorem<nbsp><reference|intersectq> or are given,
    up to multiplication of <math|m> and <math|d> by the same factor, by
    <math|m=<math-up|lcm><around|(|2*n,12|)>> and <math|d> from a finite
    list.
  </theorem>

  <\proof>
    Since <math|<Q><around|(|\<zeta\><rsub|n>|)><rsup|+>=<Q><around|(|\<zeta\><rsub|2*n>|)><rsup|+>>
    for odd <math|n> it suffices to consider the case where <math|n> is even
    (hence <math|<math-up|lcm><around|(|2*n,12|)>=<math-up|lcm><around|(|2*n,3|)>>).
    Let <math|m\<geq\>4> and <math|d\<assign\><around|(|k<rsub|1>,k<rsub|2>,k<rsub|3>,k<rsub|4>|)>\<in\>D<rsub|m>>
    such that

    <\equation*>
      a\<assign\>f<rsub|m><around|(|d|)>=<frac|<around|(|1-\<zeta\><rsub|m><rsup|k<rsub|1>>|)>*<around|(|1-\<zeta\><rsub|m><rsup|k<rsub|2>>|)>|<around|(|1-\<zeta\><rsub|m><rsup|k<rsub|3>>|)>*<around|(|1-\<zeta\><rsub|m><rsup|k<rsub|4>>|)>>\<in\><Q><around|(|\<zeta\><rsub|n>|)><rsup|+>
    </equation*>

    Recall that <math|a\<gtr\>1> by Fact<nbsp><reference|fmdg1>. We may
    assume that <math|<math-up|gcd><around|(|m,k<rsub|1>,k<rsub|2>,k<rsub|3>,k<rsub|4>|)>=1>.
    By virtue of Theorem<nbsp><reference|intersectq>, we may also assume that
    <math|a\<nin\><Q>>. Observe that

    <\equation*>
      a\<in\><Q><around|(|\<zeta\><rsub|n>|)><rsup|+>\<cap\><Q><around|(|\<zeta\><rsub|m>|)><rsup|+>=<Q><around|(|\<zeta\><rsub|<math-up|gcd><around|(|m,n|)>>|)><rsup|+>
    </equation*>

    Claims 1 and 2 below show that <math|<math-up|lcm><around|(|2*n,3|)>> is
    a multiple of <math|m>, hence the assertion.

    <with|font-series|bold|Claim 1.> Let <math|p> be an odd prime number and
    assume that <math|<math-up|ord><rsub|p><around|(|n|)>\<less\><math-up|ord><rsub|p><around|(|m|)>>.
    Then one has <math|p=3>, <math|<math-up|ord><rsub|p><around|(|m|)>=1> and
    <math|<math-up|ord><rsub|p><around|(|n|)>=0>.

    To see this, set <math|r\<assign\><math-up|ord><rsub|p><around|(|m|)>\<geq\>1>,
    <math|K\<assign\><Q><around|(|\<zeta\><rsub|m/p>|)>> and note that
    <math|<Q><around|(|\<zeta\><rsub|<math-up|gcd><around|(|m,n|)>>|)>\<subset\>K>.
    Let <math|m=p<rsup|r>*m<rprime|'>>, where
    <math|<math-up|gcd><around|(|p,m<rprime|'>|)>=1>. Then, for
    <math|i=1,2,3,4>, there are <math|a<rsub|i>,b<rsub|i>\<in\><Z>> such that
    <math|k<rsub|i>=a<rsub|i>*p+b<rsub|i>*m<rprime|'>> and, further,
    <math|\<zeta\><rsub|m><rsup|k<rsub|i>>=\<zeta\><rsub|m/p><rsup|a<rsub|i>>*\<zeta\><rsub|p<rsup|r>><rsup|b<rsub|i>>>.
    Since <math|\<zeta\><rsub|p<rsup|r>><rsup|p>=\<zeta\><rsub|p<rsup|r-1>>\<in\>K>
    one has

    <\equation*>
      a=<frac|<around|(|1-\<omega\><rsub|1>*\<zeta\><rsub|p<rsup|r>><rsup|l<rsub|1>>|)>*<around|(|1-\<omega\><rsub|2>*\<zeta\><rsub|p<rsup|r>><rsup|l<rsub|2>>|)>|<around|(|1-\<omega\><rsub|3>*\<zeta\><rsub|p<rsup|r>><rsup|l<rsub|3>>|)>*<around|(|1-\<omega\><rsub|4>*\<zeta\><rsub|p<rsup|r>><rsup|l<rsub|4>>|)>>
    </equation*>

    for suitable <math|\<omega\><rsub|1>,\<omega\><rsub|2>,\<omega\><rsub|3>,\<omega\><rsub|4>\<in\>\<mu\><around|(|K|)>>
    and <math|l<rsub|1>,l<rsub|2>,l<rsub|3>,l<rsub|4>\<in\><around|{|0,\<ldots\>,p-1|}>>
    with <math|<math-up|gcd><around|(|l<rsub|i>,p|)>=1> for some
    <math|i\<in\><around|{|1,2,3,4|}>> and
    <math|l<rsub|1>+l<rsub|2>\<equiv\>l<rsub|3>+l<rsub|4><pmod|p>>. Further,
    by Fact<nbsp><reference|gau>, one has

    <\equation*>
      <around|[|K<around|(|\<zeta\><rsub|p<rsup|r>>|)>:K|]>=<around|[|<Q><around|(|\<zeta\><rsub|m>|)>:<Q><around|(|\<zeta\><rsub|m/p>|)>|]>=<frac|\<phi\><around|(|p<rsup|r>|)>|\<phi\><around|(|p<rsup|r-1>|)>>=<around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|p-1>|<cell|<text|if
      <math|r=1>;>>>|<row|<cell|p>|<cell|<text|if
      <math|r\<geq\>2>.>>>>>>|\<nobracket\>>
    </equation*>

    Lemma<nbsp><reference|l3> implies both for <math|p\<geq\>5> and
    <math|r\<geq\>2> that <math|a=2>, a contradiction. Therefore <math|p=3>,
    <math|r=<math-up|ord><rsub|p><around|(|m|)>=1> and consequently
    <math|<math-up|ord><rsub|p><around|(|n|)>=0>.

    <with|font-series|bold|Claim 2.> <math|<math-up|ord><rsub|2><around|(|m|)>\<leq\><math-up|ord><rsub|2><around|(|n|)>+1>.

    Assume that <math|r\<assign\><math-up|ord><rsub|2><around|(|m|)>\<geq\><math-up|ord><rsub|2><around|(|n|)>+2\<geq\>3>.
    Set <math|K\<assign\><Q><around|(|\<zeta\><rsub|m/4>|)>> and note that
    <math|<Q><around|(|\<zeta\><rsub|<math-up|gcd><around|(|m,n|)>>|)>\<subset\>K>.
    As above, since <math|\<zeta\><rsub|2<rsup|r>><rsup|4>=\<zeta\><rsub|2<rsup|r-2>>\<in\>K>,
    one has

    <\equation*>
      a=<frac|<around|(|1-\<omega\><rsub|1>*\<zeta\><rsub|2<rsup|r>><rsup|l<rsub|1>>|)>*<around|(|1-\<omega\><rsub|2>*\<zeta\><rsub|2<rsup|r>><rsup|l<rsub|2>>|)>|<around|(|1-\<omega\><rsub|3>*\<zeta\><rsub|2<rsup|r>><rsup|l<rsub|3>>|)>*<around|(|1-\<omega\><rsub|4>*\<zeta\><rsub|2<rsup|r>><rsup|l<rsub|4>>|)>>
    </equation*>

    for suitable <math|\<omega\><rsub|1>,\<omega\><rsub|2>,\<omega\><rsub|3>,\<omega\><rsub|4>\<in\>\<mu\><around|(|K|)>>
    and <math|l<rsub|1>,l<rsub|2>,l<rsub|3>,l<rsub|4>\<in\><around|{|0,1,2,3|}>>
    with <math|<math-up|gcd><around|(|l<rsub|i>,4|)>=1> for some
    <math|i\<in\><around|{|1,2,3,4|}>> and
    <math|l<rsub|1>+l<rsub|2>\<equiv\>l<rsub|3>+l<rsub|4><pmod|4>>. Further,
    by Fact<nbsp><reference|gau>, one has

    <\equation*>
      <around|[|K<around|(|\<zeta\><rsub|2<rsup|s>>|)>:K|]>=<around|[|<Q><around|(|\<zeta\><rsub|m>|)>:<Q><around|(|\<zeta\><rsub|m/4>|)>|]>=<frac|\<phi\><around|(|2<rsup|r>|)>|\<phi\><around|(|2<rsup|r-2>|)>>=4<space|0.17em>.
    </equation*>

    Lemma<nbsp><reference|l3> now implies <math|a=2>, a contradiction. This
    proves the claim.
  </proof>

  <\rem>
    Similar to the proof of Theorem<nbsp><reference|t1>, one can also use
    Lemma<nbsp><reference|l3> to give another proof of the fact shown
    in<nbsp><cite|GG> that all solutions of
    <math|f<rsub|m><around|(|d|)>\<in\><Q>\<setminus\><around|{|2|}>>, where
    <math|m\<geq\>4> and <math|d\<in\>D<rsub|m>>, are given, up to
    multiplication of <math|m> and <math|d> by the same factor, by
    <math|m=12>. Thus the number <math|2> plays a special role in this
    context. Indeed this number leads to infinite families of solutions (see
    Theorem<nbsp><reference|intersectq>(xii)-(xiii) above) that can be found
    by using the <math|2>-adic valuation; cf.<nbsp><cite|GG> for details.
  </rem>

  One even has the following result, which
  improves<nbsp><cite-detail|H5|Thm.<nbsp> 4.19>.

  <\theorem>
    <label|algcoro>For any real algebraic number field <math|L>, the set
    <math|\<cal-C\><around|(|L|)>> is finite. Moreover, there is a number
    <math|m<rsub|L>\<in\><N>> such that all solutions of
    <math|f<rsub|m><around|(|d|)>\<in\>L>, where <math|m\<geq\>4> and
    <math|d\<in\>D<rsub|m>>, are either of the form (xii) or (xiii) of
    Theorem<nbsp><reference|intersectq> or are given, up to multiplication of
    <math|m> and <math|d> by the same factor, by <math|m=m<rsub|L>> and
    <math|d> from a finite list.
  </theorem>

  <\proof>
    The finiteness of <math|L/<Q>> together with the identity

    <\equation*>
      <Q><around|(|\<mu\>|)><rsup|+>=<big|cup><rsub|n\<in\><N>><Q><around|(|\<zeta\><rsub|n>|)><rsup|+>
    </equation*>

    implies that <math|L\<cap\><Q><around|(|\<mu\>|)><rsup|+>=L\<cap\><Q><around|(|\<zeta\><rsub|n>|)><rsup|+>>
    for some <math|n\<in\><N>>. Since <math|\<cal-C\>\<subset\><Q><around|(|\<mu\>|)><rsup|+>>
    by Fact<nbsp><reference|fmdg1> it follows that

    <\equation*>
      \<cal-C\><around|(|L|)>=L\<cap\>\<cal-C\>=L\<cap\>\<cal-C\>\<cap\><Q><around|(|\<mu\>|)><rsup|+>=L\<cap\>\<cal-C\>\<cap\><Q><around|(|\<zeta\><rsub|n>|)><rsup|+>\<subset\>\<cal-C\><around|(|<Q><around|(|\<zeta\><rsub|n>|)><rsup|+>|)><space|0.17em>.
    </equation*>

    By virtue of Theorem<nbsp><reference|t1>, the assertion follows with
    <math|m<rsub|L>\<assign\><math-up|lcm><around|(|2*n,12|)>>.
  </proof>

  <\coro>
    <label|coro8125>

    <\itemize>
      <item*|(a)>

      <eqnarray*|<tformat|<table|<row|<cell|\<cal-C\><around|(|<Q><around|(|<sqrt|5>|)>|)>>|<cell|=>|<cell|\<cal-C\><rsub|60><around|(|<Q><around|(|<sqrt|5>|)>|)>>>|<row|<cell|>|<cell|=>|<cell|<around*|{|<tfrac|10-2*<sqrt|5>|5>,<tfrac|<sqrt|5>|2>,<tfrac|9-3*<sqrt|5>|2>,<tfrac|5+3*<sqrt|5>|10>,<tfrac|5+<sqrt|5>|6>,-1+<sqrt|5>,<tfrac|3+<sqrt|5>|4>,<tfrac|4|3>,<tfrac|5-<sqrt|5>|2>,<tfrac|5+<sqrt|5>|5>,|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<hphantom|<around*|{||\<nobracket\>>><tfrac|3|2>,6-2*<sqrt|5>,<tfrac|1+<sqrt|5>|2>,<tfrac|5+<sqrt|5>|4>,<tfrac|-3+3*<sqrt|5>|2>,<tfrac|5+2*<sqrt|5>|5>,2,<tfrac|2+<sqrt|5>|2>,<tfrac|15+3*<sqrt|5>|10>,<sqrt|5>,>>|<row|<cell|>|<cell|>|<cell|<hphantom|<around*|{||\<nobracket\>>><tfrac|3+<sqrt|5>|2>,<tfrac|10+2*<sqrt|5>|5>,3,1+<sqrt|5>,<tfrac|5+<sqrt|5>|2>,4,2+<sqrt|5>,3+<sqrt|5>,<tfrac|5+3*<sqrt|5>|2>,<tfrac|7+3*<sqrt|5>|2>,>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|<hphantom|<around*|{||\<nobracket\>>><tfrac|9+3*<sqrt|5>|2>,5+2*<sqrt|5>,6+2*<sqrt|5>|}>>>>>>

      Moreover, all solutions of <math|f<rsub|m><around|(|d|)>\<in\><Q><around|(|<sqrt|5>|)>>,
      where <math|m\<geq\>4> and <math|d\<in\>D<rsub|m>>, are either of the
      form (xii) or (xiii) of Theorem<nbsp><reference|intersectq> or are
      given, up to multiplication of <math|m> and <math|d> by the same
      factor, by <math|m=60> and <math|d> from the following list.

      <\equation*>
        <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|r>|<cwith|1|-1|3|3|cell-rborder|1ln>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|1ln>|<cwith|1|-1|5|5|cell-halign|r>|<cwith|1|-1|5|5|cell-rborder|1ln>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|6|6|cell-rborder|1ln>|<cwith|1|-1|7|7|cell-halign|r>|<cwith|1|-1|7|7|cell-rborder|1ln>|<cwith|1|-1|8|8|cell-halign|c>|<cwith|1|-1|8|8|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|3|3|1|-1|cell-bborder|1ln>|<cwith|4|4|1|-1|cell-bborder|1ln>|<cwith|5|5|1|-1|cell-bborder|1ln>|<cwith|6|6|1|-1|cell-bborder|1ln>|<cwith|7|7|1|-1|cell-bborder|1ln>|<cwith|8|8|1|-1|cell-bborder|1ln>|<cwith|9|9|1|-1|cell-bborder|1ln>|<cwith|10|10|1|-1|cell-bborder|1ln>|<cwith|11|11|1|-1|cell-bborder|1ln>|<cwith|12|12|1|-1|cell-bborder|1ln>|<cwith|13|13|1|-1|cell-bborder|1ln>|<cwith|14|14|1|-1|cell-bborder|1ln>|<cwith|15|15|1|-1|cell-bborder|1ln>|<cwith|16|16|1|-1|cell-bborder|1ln>|<cwith|17|17|1|-1|cell-bborder|1ln>|<cwith|18|18|1|-1|cell-bborder|1ln>|<cwith|19|19|1|-1|cell-bborder|1ln>|<cwith|20|20|1|-1|cell-bborder|1ln>|<cwith|21|21|1|-1|cell-bborder|1ln>|<cwith|22|22|1|-1|cell-bborder|1ln>|<cwith|23|23|1|-1|cell-bborder|1ln>|<cwith|24|24|1|-1|cell-bborder|1ln>|<cwith|25|25|1|-1|cell-bborder|1ln>|<cwith|26|26|1|-1|cell-bborder|1ln>|<cwith|27|27|1|-1|cell-bborder|1ln>|<cwith|28|28|1|-1|cell-bborder|1ln>|<cwith|29|29|1|-1|cell-bborder|1ln>|<cwith|30|30|1|-1|cell-bborder|1ln>|<cwith|31|31|1|-1|cell-bborder|1ln>|<cwith|32|32|1|-1|cell-bborder|1ln>|<cwith|33|33|1|-1|cell-bborder|1ln>|<cwith|34|34|1|-1|cell-bborder|1ln>|<cwith|35|35|1|-1|cell-bborder|1ln>|<cwith|36|36|1|-1|cell-bborder|1ln>|<cwith|37|37|1|-1|cell-bborder|1ln>|<cwith|38|38|1|-1|cell-bborder|1ln>|<cwith|39|39|1|-1|cell-bborder|1ln>|<cwith|40|40|1|-1|cell-bborder|1ln>|<cwith|41|41|1|-1|cell-bborder|1ln>|<cwith|42|42|1|-1|cell-bborder|1ln>|<cwith|43|43|1|-1|cell-bborder|1ln>|<cwith|44|44|1|-1|cell-bborder|1ln>|<cwith|45|45|1|-1|cell-bborder|1ln>|<cwith|46|46|1|-1|cell-bborder|1ln>|<table|<row|<cell|<math|1>>|<cell|<math|<around|(|12,36,6,42|)>>>|<cell|<math|2>>|<cell|<math|<around|(|24,24,9,39|)>>>|<cell|<math|3>>|<cell|<math|<around|(|24,48,18,54|)>>>|<cell|<math|4>>|<cell|<math|<around|(|36,36,21,51|)>>>>|<row|<cell|<math|5>>|<cell|<math|<around|(|24,24,18,30|)>>>|<cell|<math|6>>|<cell|<math|<around|(|36,36,30,42|)>>>|<cell|<math|7>>|<cell|<math|<around|(|4,8,2,10|)>>>|<cell|<math|8>>|<cell|<math|<around|(|5,25,3,27|)>>>>|<row|<cell|<math|9>>|<cell|<math|<around|(|6,42,4,44|)>>>|<cell|<math|10>>|<cell|<math|<around|(|8,14,4,18|)>>>|<cell|<math|11>>|<cell|<math|<around|(|8,32,5,35|)>>>|<cell|<math|12>>|<cell|<math|<around|(|8,50,6,52|)>>>>|<row|<cell|<math|13>>|<cell|<math|<around|(|9,21,5,25|)>>>|<cell|<math|14>>|<cell|<math|<around|(|9,39,6,42|)>>>|<cell|<math|15>>|<cell|<math|<around|(|10,10,4,16|)>>>|<cell|<math|16>>|<cell|<math|<around|(|10,28,6,32|)>>>>|<row|<cell|<math|17>>|<cell|<math|<around|(|10,52,8,54|)>>>|<cell|<math|18>>|<cell|<math|<around|(|12,18,6,24|)>>>|<cell|<math|19>>|<cell|<math|<around|(|14,26,8,32|)>>>|<cell|<math|20>>|<cell|<math|<around|(|14,34,9,39|)>>>>|<row|<cell|<math|21>>|<cell|<math|<around|(|14,42,10,46|)>>>|<cell|<math|22>>|<cell|<math|<around|(|16,32,10,38|)>>>|<cell|<math|23>>|<cell|<math|<around|(|18,18,8,28|)>>>|<cell|<math|24>>|<cell|<math|<around|(|18,26,10,34|)>>>>|<row|<cell|<math|25>>|<cell|<math|<around|(|18,36,12,42|)>>>|<cell|<math|26>>|<cell|<math|<around|(|18,46,14,50|)>>>|<cell|<math|27>>|<cell|<math|<around|(|18,54,16,56|)>>>|<cell|<math|28>>|<cell|<math|<around|(|21,51,18,54|)>>>>|<row|<cell|<math|29>>|<cell|<math|<around|(|24,24,12,36|)>>>|<cell|<math|30>>|<cell|<math|<around|(|24,42,18,48|)>>>|<cell|<math|31>>|<cell|<math|<around|(|26,32,16,42|)>>>|<cell|<math|32>>|<cell|<math|<around|(|26,46,21,51|)>>>>|<row|<cell|<math|33>>|<cell|<math|<around|(|28,34,18,44|)>>>|<cell|<math|34>>|<cell|<math|<around|(|28,44,22,50|)>>>|<cell|<math|35>>|<cell|<math|<around|(|28,52,25,55|)>>>|<cell|<math|36>>|<cell|<math|<around|(|32,50,28,54|)>>>>|<row|<cell|<math|37>>|<cell|<math|<around|(|34,42,26,50|)>>>|<cell|<math|38>>|<cell|<math|<around|(|34,46,28,52|)>>>|<cell|<math|39>>|<cell|<math|<around|(|35,55,33,57|)>>>|<cell|<math|40>>|<cell|<math|<around|(|36,36,24,48|)>>>>|<row|<cell|<math|41>>|<cell|<math|<around|(|39,51,35,55|)>>>|<cell|<math|42>>|<cell|<math|<around|(|42,42,32,52|)>>>|<cell|<math|43>>|<cell|<math|<around|(|42,48,36,54|)>>>|<cell|<math|44>>|<cell|<math|<around|(|46,52,42,56|)>>>>|<row|<cell|<math|45>>|<cell|<math|<around|(|50,50,44,56|)>>>|<cell|<math|46>>|<cell|<math|<around|(|52,56,50,58|)>>>|<cell|<math|47>>|<cell|<math|<around|(|18,18,6,30|)>>>|<cell|<math|48>>|<cell|<math|<around|(|42,42,30,54|)>>>>|<row|<cell|<math|49>>|<cell|<math|<around|(|4,52,2,54|)>>>|<cell|<math|50>>|<cell|<math|<around|(|5,35,2,38|)>>>|<cell|<math|51>>|<cell|<math|<around|(|6,18,2,22|)>>>|<cell|<math|52>>|<cell|<math|<around|(|8,10,2,16|)>>>>|<row|<cell|<math|53>>|<cell|<math|<around|(|8,28,3,33|)>>>|<cell|<math|54>>|<cell|<math|<around|(|8,46,4,50|)>>>|<cell|<math|55>>|<cell|<math|<around|(|8,56,6,58|)>>>|<cell|<math|56>>|<cell|<math|<around|(|9,21,3,27|)>>>>|<row|<cell|<math|57>>|<cell|<math|<around|(|9,39,4,44|)>>>|<cell|<math|58>>|<cell|<math|<around|(|10,32,4,38|)>>>|<cell|<math|59>>|<cell|<math|<around|(|10,50,6,54|)>>>|<cell|<math|60>>|<cell|<math|<around|(|12,42,6,48|)>>>>|<row|<cell|<math|61>>|<cell|<math|<around|(|14,18,4,28|)>>>|<cell|<math|62>>|<cell|<math|<around|(|14,26,5,35|)>>>|<cell|<math|63>>|<cell|<math|<around|(|14,34,6,42|)>>>|<cell|<math|64>>|<cell|<math|<around|(|14,52,10,56|)>>>>|<row|<cell|<math|65>>|<cell|<math|<around|(|16,28,6,38|)>>>|<cell|<math|66>>|<cell|<math|<around|(|18,24,6,36|)>>>|<cell|<math|67>>|<cell|<math|<around|(|18,34,8,44|)>>>|<cell|<math|68>>|<cell|<math|<around|(|18,42,10,50|)>>>>|<row|<cell|<math|69>>|<cell|<math|<around|(|18,48,12,54|)>>>|<cell|<math|70>>|<cell|<math|<around|(|21,51,16,56|)>>>|<cell|<math|71>>|<cell|<math|<around|(|24,36,12,48|)>>>|<cell|<math|72>>|<cell|<math|<around|(|25,55,22,58|)>>>>|<row|<cell|<math|73>>|<cell|<math|<around|(|26,28,10,44|)>>>|<cell|<math|74>>|<cell|<math|<around|(|26,42,16,52|)>>>|<cell|<math|75>>|<cell|<math|<around|(|26,46,18,54|)>>>|<cell|<math|76>>|<cell|<math|<around|(|28,50,22,56|)>>>>|<row|<cell|<math|77>>|<cell|<math|<around|(|32,34,16,50|)>>>|<cell|<math|78>>|<cell|<math|<around|(|32,44,22,54|)>>>|<cell|<math|79>>|<cell|<math|<around|(|32,52,27,57|)>>>|<cell|<math|80>>|<cell|<math|<around|(|34,46,25,55|)>>>>|<row|<cell|<math|81>>|<cell|<math|<around|(|36,42,24,54|)>>>|<cell|<math|82>>|<cell|<math|<around|(|39,51,33,57|)>>>|<cell|<math|83>>|<cell|<math|<around|(|42,46,32,56|)>>>|<cell|<math|84>>|<cell|<math|<around|(|42,54,38,58|)>>>>|<row|<cell|<math|85>>|<cell|<math|<around|(|50,52,44,58|)>>>|<cell|<math|86>>|<cell|<math|<around|(|12,12,2,22|)>>>|<cell|<math|87>>|<cell|<math|<around|(|12,24,3,33|)>>>|<cell|<math|88>>|<cell|<math|<around|(|12,36,4,44|)>>>>|<row|<cell|<math|89>>|<cell|<math|<around|(|12,48,6,54|)>>>|<cell|<math|90>>|<cell|<math|<around|(|24,24,6,42|)>>>|<cell|<math|91>>|<cell|<math|<around|(|24,36,10,50|)>>>|<cell|<math|92>>|<cell|<math|<around|(|24,48,16,56|)>>>>|<row|<cell|<math|93>>|<cell|<math|<around|(|36,36,18,54|)>>>|<cell|<math|94>>|<cell|<math|<around|(|36,48,27,57|)>>>|<cell|<math|95>>|<cell|<math|<around|(|48,48,38,58|)>>>|<cell|<math|96>>|<cell|<math|<around|(|8,28,6,30|)>>>>|<row|<cell|<math|97>>|<cell|<math|<around|(|14,26,10,30|)>>>|<cell|<math|98>>|<cell|<math|<around|(|18,24,12,30|)>>>|<cell|<math|99>>|<cell|<math|<around|(|18,42,15,45|)>>>|<cell|<math|100>>|<cell|<math|<around|(|32,52,30,54|)>>>>|<row|<cell|<math|101>>|<cell|<math|<around|(|34,46,30,50|)>>>|<cell|<math|102>>|<cell|<math|<around|(|36,42,30,48|)>>>|<cell|<math|103>>|<cell|<math|<around|(|12,24,6,30|)>>>|<cell|<math|104>>|<cell|<math|<around|(|24,36,15,45|)>>>>|<row|<cell|<math|105>>|<cell|<math|<around|(|36,48,30,54|)>>>|<cell|<math|106>>|<cell|<math|<around|(|15,45,12,48|)>>>|<cell|<math|107>>|<cell|<math|<around|(|18,30,12,36|)>>>|<cell|<math|108>>|<cell|<math|<around|(|30,42,24,48|)>>>>|<row|<cell|<math|109>>|<cell|<math|<around|(|24,36,20,40|)>>>|<cell|<math|110>>|<cell|<math|<around|(|10,30,8,32|)>>>|<cell|<math|111>>|<cell|<math|<around|(|15,15,9,21|)>>>|<cell|<math|112>>|<cell|<math|<around|(|18,30,14,34|)>>>>|<row|<cell|<math|113>>|<cell|<math|<around|(|24,30,18,36|)>>>|<cell|<math|114>>|<cell|<math|<around|(|30,36,24,42|)>>>|<cell|<math|115>>|<cell|<math|<around|(|30,42,26,46|)>>>|<cell|<math|116>>|<cell|<math|<around|(|30,50,28,52|)>>>>|<row|<cell|<math|117>>|<cell|<math|<around|(|45,45,39,51|)>>>|<cell|<math|118>>|<cell|<math|<around|(|15,15,3,27|)>>>|<cell|<math|119>>|<cell|<math|<around|(|18,30,6,42|)>>>|<cell|<math|120>>|<cell|<math|<around|(|30,42,18,54|)>>>>|<row|<cell|<math|121>>|<cell|<math|<around|(|45,45,33,57|)>>>|<cell|<math|122>>|<cell|<math|<around|(|8,32,2,38|)>>>|<cell|<math|123>>|<cell|<math|<around|(|14,34,4,44|)>>>|<cell|<math|124>>|<cell|<math|<around|(|18,18,3,33|)>>>>|<row|<cell|<math|125>>|<cell|<math|<around|(|18,36,6,48|)>>>|<cell|<math|126>>|<cell|<math|<around|(|24,42,12,54|)>>>|<cell|<math|127>>|<cell|<math|<around|(|26,46,16,56|)>>>|<cell|<math|128>>|<cell|<math|<around|(|28,52,22,58|)>>>>|<row|<cell|<math|129>>|<cell|<math|<around|(|42,42,27,57|)>>>|<cell|<math|130>>|<cell|<math|<around|(|10,30,2,38|)>>>|<cell|<math|131>>|<cell|<math|<around|(|15,45,6,54|)>>>|<cell|<math|132>>|<cell|<math|<around|(|18,30,4,44|)>>>>|<row|<cell|<math|133>>|<cell|<math|<around|(|24,30,6,48|)>>>|<cell|<math|134>>|<cell|<math|<around|(|30,36,12,54|)>>>|<cell|<math|135>>|<cell|<math|<around|(|30,42,16,56|)>>>|<cell|<math|136>>|<cell|<math|<around|(|30,50,22,58|)>>>>|<row|<cell|<math|137>>|<cell|<math|<around|(|24,36,6,54|)>>>|<cell|<math|138>>|<cell|<math|<around|(|30,30,6,54|)>>>|<cell|<math|139>>|<cell|<math|<around|(|30,30,18,42|)>>>|<cell|<math|140>>|<cell|<math|<around|(|12,12,6,18|)>>>>|<row|<cell|<math|141>>|<cell|<math|<around|(|12,24,8,28|)>>>|<cell|<math|142>>|<cell|<math|<around|(|12,36,9,39|)>>>|<cell|<math|143>>|<cell|<math|<around|(|12,48,10,50|)>>>|<cell|<math|144>>|<cell|<math|<around|(|24,24,14,34|)>>>>|<row|<cell|<math|145>>|<cell|<math|<around|(|24,36,18,42|)>>>|<cell|<math|146>>|<cell|<math|<around|(|24,48,21,51|)>>>|<cell|<math|147>>|<cell|<math|<around|(|36,36,26,46|)>>>|<cell|<math|148>>|<cell|<math|<around|(|36,48,32,52|)>>>>|<row|<cell|<math|149>>|<cell|<math|<around|(|48,48,42,54|)>>>|<cell|<math|150>>|<cell|<math|<around|(|14,26,2,38|)>>>|<cell|<math|151>>|<cell|<math|<around|(|18,42,6,54|)>>>|<cell|<math|152>>|<cell|<math|<around|(|34,46,22,58|)>>>>|<row|<cell|<math|153>>|<cell|<math|<around|(|14,34,12,36|)>>>|<cell|<math|154>>|<cell|<math|<around|(|18,18,12,24|)>>>|<cell|<math|155>>|<cell|<math|<around|(|26,46,24,48|)>>>|<cell|<math|156>>|<cell|<math|<around|(|42,42,36,48|)>>>>|<row|<cell|<math|157>>|<cell|<math|<around|(|18,42,12,48|)>>>|<cell|<math|158>>|<cell|<math|<around|(|20,20,2,38|)>>>|<cell|<math|159>>|<cell|<math|<around|(|20,40,6,54|)>>>|<cell|<math|160>>|<cell|<math|<around|(|40,40,22,58|)>>>>|<row|<cell|<math|161>>|<cell|<math|<around|(|20,20,8,32|)>>>|<cell|<math|162>>|<cell|<math|<around|(|40,40,28,52|)>>>|<cell|<math|163>>|<cell|<math|<around|(|20,20,14,26|)>>>|<cell|<math|164>>|<cell|<math|<around|(|20,40,18,42|)>>>>|<row|<cell|<math|165>>|<cell|<math|<around|(|40,40,34,46|)>>>|<cell|<math|166>>|<cell|<math|<around|(|20,40,12,48|)>>>|<cell|<math|167>>|<cell|<math|<around|(|24,24,4,44|)>>>|<cell|<math|168>>|<cell|<math|<around|(|36,36,16,56|)>>>>|<row|<cell|<math|169>>|<cell|<math|<around|(|30,30,12,48|)>>>|<cell|<math|170>>|<cell|<math|<around|(|30,30,24,36|)>>>|<cell|<math|171>>|<cell|<math|<around|(|30,30,20,40|)>>>|<cell|<math|172>>|<cell|<math|<around|(|30,30,10,50|)>>>>|<row|<cell|<math|173>>|<cell|<math|<around|(|20,40,15,45|)>>>|<cell|<math|174>>|<cell|<math|<around|(|20,40,10,50|)>>>|<cell|<math|175>>|<cell|<math|<around|(|20,20,10,30|)>>>|<cell|<math|176>>|<cell|<math|<around|(|40,40,30,50|)>>>>|<row|<cell|<math|177>>|<cell|<math|<around|(|20,20,5,35|)>>>|<cell|<math|178>>|<cell|<math|<around|(|40,40,25,55|)>>>|<cell|<math|179>>|<cell|<math|<around|(|15,45,10,50|)>>>|<cell|<math|180>>|<cell|<math|<around|(|15,15,5,25|)>>>>|<row|<cell|<math|181>>|<cell|<math|<around|(|45,45,35,55|)>>>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>>>>
      </equation*>

      <item*|(b)>

      <eqnarray*|<tformat|<table|<row|<cell|\<cal-C\><around|(|<Q><around|(|<sqrt|2>|)>|)>>|<cell|=>|<cell|\<cal-C\><rsub|48><around|(|<Q><around|(|<sqrt|2>|)>|)>>>|<row|<cell|>|<cell|=>|<cell|<around*|{|<tfrac|2+<sqrt|2>|3>,4-2*<sqrt|2>,<tfrac|1+<sqrt|2>|2>,-3+3*<sqrt|2>,<tfrac|4|3>,<sqrt|2>,<tfrac|3|2>,<tfrac|2+<sqrt|2>|2>,2,,1+<sqrt|2>,|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|<hphantom|<around*|{||\<nobracket\>>>3,2+<sqrt|2>,4,<tfrac|6+3*<sqrt|2>|2>,3+2*<sqrt|2>,4+2*<sqrt|2>,4+3*<sqrt|2>|}><space|0.17em>.>>>>>

      Moreover, all solutions of <math|f<rsub|m><around|(|d|)>\<in\><Q><around|(|<sqrt|2>|)>>,
      where <math|m\<geq\>4> and <math|d\<in\>D<rsub|m>>, are either of the
      form (xii) or (xiii) of Theorem<nbsp><reference|intersectq> or are
      given, up to multiplication of <math|m> and <math|d> by the same
      factor, by <math|m=48> and <math|d> from the following list.

      <\equation*>
        <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|r>|<cwith|1|-1|3|3|cell-rborder|1ln>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|1ln>|<cwith|1|-1|5|5|cell-halign|r>|<cwith|1|-1|5|5|cell-rborder|1ln>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|6|6|cell-rborder|1ln>|<cwith|1|-1|7|7|cell-halign|r>|<cwith|1|-1|7|7|cell-rborder|1ln>|<cwith|1|-1|8|8|cell-halign|c>|<cwith|1|-1|8|8|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|3|3|1|-1|cell-bborder|1ln>|<cwith|4|4|1|-1|cell-bborder|1ln>|<cwith|5|5|1|-1|cell-bborder|1ln>|<cwith|6|6|1|-1|cell-bborder|1ln>|<cwith|7|7|1|-1|cell-bborder|1ln>|<cwith|8|8|1|-1|cell-bborder|1ln>|<cwith|9|9|1|-1|cell-bborder|1ln>|<cwith|10|10|1|-1|cell-bborder|1ln>|<cwith|11|11|1|-1|cell-bborder|1ln>|<cwith|12|12|1|-1|cell-bborder|1ln>|<cwith|13|13|1|-1|cell-bborder|1ln>|<cwith|14|14|1|-1|cell-bborder|1ln>|<cwith|15|15|1|-1|cell-bborder|1ln>|<cwith|16|16|1|-1|cell-bborder|1ln>|<cwith|17|17|1|-1|cell-bborder|1ln>|<cwith|18|18|1|-1|cell-bborder|1ln>|<cwith|19|19|1|-1|cell-bborder|1ln>|<cwith|20|20|1|-1|cell-bborder|1ln>|<cwith|21|21|1|-1|cell-bborder|1ln>|<table|<row|<cell|<math|1>>|<cell|<math|<around|(|6,18,4,20|)>>>|<cell|<math|2>>|<cell|<math|<around|(|10,36,8,38|)>>>|<cell|<math|3>>|<cell|<math|<around|(|12,12,6,18|)>>>|<cell|<math|4>>|<cell|<math|<around|(|12,22,8,26|)>>>>|<row|<cell|<math|5>>|<cell|<math|<around|(|12,30,9,33|)>>>|<cell|<math|6>>|<cell|<math|<around|(|12,38,10,40|)>>>|<cell|<math|7>>|<cell|<math|<around|(|18,18,10,26|)>>>|<cell|<math|8>>|<cell|<math|<around|(|18,24,12,30|)>>>>|<row|<cell|<math|9>>|<cell|<math|<around|(|18,36,15,39|)>>>|<cell|<math|10>>|<cell|<math|<around|(|24,30,18,36|)>>>|<cell|<math|11>>|<cell|<math|<around|(|26,36,22,40|)>>>|<cell|<math|12>>|<cell|<math|<around|(|30,30,22,38|)>>>>|<row|<cell|<math|13>>|<cell|<math|<around|(|30,42,28,44|)>>>|<cell|<math|14>>|<cell|<math|<around|(|36,36,30,42|)>>>|<cell|<math|15>>|<cell|<math|<around|(|4,10,2,12|)>>>|<cell|<math|16>>|<cell|<math|<around|(|8,40,6,42|)>>>>|<row|<cell|<math|17>>|<cell|<math|<around|(|9,33,6,36|)>>>|<cell|<math|18>>|<cell|<math|<around|(|10,26,6,30|)>>>|<cell|<math|19>>|<cell|<math|<around|(|12,18,6,24|)>>>|<cell|<math|20>>|<cell|<math|<around|(|15,39,12,42|)>>>>|<row|<cell|<math|21>>|<cell|<math|<around|(|18,30,12,36|)>>>|<cell|<math|22>>|<cell|<math|<around|(|20,26,12,34|)>>>|<cell|<math|23>>|<cell|<math|<around|(|22,28,14,36|)>>>|<cell|<math|24>>|<cell|<math|<around|(|22,38,18,42|)>>>>|<row|<cell|<math|25>>|<cell|<math|<around|(|30,36,24,42|)>>>|<cell|<math|26>>|<cell|<math|<around|(|38,44,36,46|)>>>|<cell|<math|27>>|<cell|<math|<around|(|10,22,8,24|)>>>|<cell|<math|28>>|<cell|<math|<around|(|18,18,12,24|)>>>>|<row|<cell|<math|29>>|<cell|<math|<around|(|26,38,24,40|)>>>|<cell|<math|30>>|<cell|<math|<around|(|30,30,24,36|)>>>|<cell|<math|31>>|<cell|<math|<around|(|18,30,16,32|)>>>|<cell|<math|32>>|<cell|<math|<around|(|4,38,2,40|)>>>>|<row|<cell|<math|33>>|<cell|<math|<around|(|8,8,2,14|)>>>|<cell|<math|34>>|<cell|<math|<around|(|9,15,3,21|)>>>|<cell|<math|35>>|<cell|<math|<around|(|10,22,4,28|)>>>|<cell|<math|36>>|<cell|<math|<around|(|10,44,8,46|)>>>>|<row|<cell|<math|37>>|<cell|<math|<around|(|12,30,6,36|)>>>|<cell|<math|38>>|<cell|<math|<around|(|18,18,6,30|)>>>|<cell|<math|39>>|<cell|<math|<around|(|18,36,12,42|)>>>|<cell|<math|40>>|<cell|<math|<around|(|20,22,8,34|)>>>>|<row|<cell|<math|41>>|<cell|<math|<around|(|26,28,14,40|)>>>|<cell|<math|42>>|<cell|<math|<around|(|26,38,20,44|)>>>|<cell|<math|43>>|<cell|<math|<around|(|30,30,18,42|)>>>|<cell|<math|44>>|<cell|<math|<around|(|33,39,27,45|)>>>>|<row|<cell|<math|45>>|<cell|<math|<around|(|40,40,34,46|)>>>|<cell|<math|46>>|<cell|<math|<around|(|6,30,2,34|)>>>|<cell|<math|47>>|<cell|<math|<around|(|10,12,2,20|)>>>|<cell|<math|48>>|<cell|<math|<around|(|12,18,3,27|)>>>>|<row|<cell|<math|49>>|<cell|<math|<around|(|12,26,4,34|)>>>|<cell|<math|50>>|<cell|<math|<around|(|12,36,6,42|)>>>|<cell|<math|51>>|<cell|<math|<around|(|18,24,6,36|)>>>|<cell|<math|52>>|<cell|<math|<around|(|18,30,8,40|)>>>>|<row|<cell|<math|53>>|<cell|<math|<around|(|18,42,14,46|)>>>|<cell|<math|54>>|<cell|<math|<around|(|22,36,14,44|)>>>|<cell|<math|55>>|<cell|<math|<around|(|24,30,12,42|)>>>|<cell|<math|56>>|<cell|<math|<around|(|30,36,21,45|)>>>>|<row|<cell|<math|57>>|<cell|<math|<around|(|36,38,28,46|)>>>|<cell|<math|58>>|<cell|<math|<around|(|10,26,2,34|)>>>|<cell|<math|59>>|<cell|<math|<around|(|18,30,6,42|)>>>|<cell|<math|60>>|<cell|<math|<around|(|22,38,14,46|)>>>>|<row|<cell|<math|61>>|<cell|<math|<around|(|12,24,2,34|)>>>|<cell|<math|62>>|<cell|<math|<around|(|24,24,6,42|)>>>|<cell|<math|63>>|<cell|<math|<around|(|24,36,14,46|)>>>|<cell|<math|64>>|<cell|<math|<around|(|12,24,10,26|)>>>>|<row|<cell|<math|65>>|<cell|<math|<around|(|24,24,18,30|)>>>|<cell|<math|66>>|<cell|<math|<around|(|24,36,22,38|)>>>|<cell|<math|67>>|<cell|<math|<around|(|16,16,10,22|)>>>|<cell|<math|68>>|<cell|<math|<around|(|32,32,26,38|)>>>>|<row|<cell|<math|69>>|<cell|<math|<around|(|18,18,2,34|)>>>|<cell|<math|70>>|<cell|<math|<around|(|30,30,14,46|)>>>|<cell|<math|71>>|<cell|<math|<around|(|16,32,6,42|)>>>|<cell|<math|72>>|<cell|<math|<around|(|24,24,16,32|)>>>>|<row|<cell|<math|73>>|<cell|<math|<around|(|24,24,8,40|)>>>|<cell|<math|74>>|<cell|<math|<around|(|16,32,12,36|)>>>|<cell|<math|75>>|<cell|<math|<around|(|16,32,8,40|)>>>|<cell|<math|76>>|<cell|<math|<around|(|16,16,8,24|)>>>>|<row|<cell|<math|77>>|<cell|<math|<around|(|32,32,24,40|)>>>|<cell|<math|78>>|<cell|<math|<around|(|16,16,4,28|)>>>|<cell|<math|79>>|<cell|<math|<around|(|32,32,20,44|)>>>|<cell|<math|80>>|<cell|<math|<around|(|12,36,8,40|)>>>>|<row|<cell|<math|81>>|<cell|<math|<around|(|12,12,4,20|)>>>|<cell|<math|82>>|<cell|<math|<around|(|36,36,28,44|)>>>|<cell|>|<cell|>|<cell|>|<cell|>>>>>
      </equation*>

      <item*|(c)>

      <eqnarray*|<tformat|<table|<row|<cell|\<cal-C\><around|(|<Q><around|(|<sqrt|3>|)>|)>>|<cell|=>|<cell|\<cal-C\><rsub|24><around|(|<Q><around|(|<sqrt|3>|)>|)>>>|<row|<cell|>|<cell|=>|<cell|<around*|{|8-4*<sqrt|3>,<tfrac|3+2*<sqrt|3>|6>,<tfrac|-3+3*<sqrt|3>|2>,<tfrac|3+<sqrt|3>|4>,<tfrac|2+<sqrt|3>|3>,3-<sqrt|3>,<tfrac|4|3>,<tfrac|1+<sqrt|3>|2>,-2+2*<sqrt|3>,|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<hphantom|<around*|{||\<nobracket\>>><tfrac|3|2>,<tfrac|3+<sqrt|3>|3>,<sqrt|3>,<tfrac|2+<sqrt|3>|2>,2,<tfrac|3+2*<sqrt|3>|3>,<tfrac|3+<sqrt|3>|2>,1+<sqrt|3>,3,<tfrac|6+2*<sqrt|3>|3>,2+<sqrt|3>,4,>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|<hphantom|<around*|{||\<nobracket\>>>3+<sqrt|3>,<tfrac|5+3*<sqrt|3>|2>,3+2*<sqrt|3>,4+2*<sqrt|3>,6+3*<sqrt|3>,7+4*<sqrt|3>,8+4*<sqrt|3>|}><space|0.17em>.>>>>>

      Moreover, all solutions of <math|f<rsub|m><around|(|d|)>\<in\><Q><around|(|<sqrt|3>|)>>,
      where <math|m\<geq\>4> and <math|d\<in\>D<rsub|m>>, are either of the
      form (xii) or (xiii) of Theorem<nbsp><reference|intersectq> or are
      given, up to multiplication of <math|m> and <math|d> by the same
      factor, by <math|m=24> and <math|d> from the following list.

      <\equation*>
        <tabular*|<tformat|<cwith|1|-1|1|1|cell-lborder|1ln>|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|1ln>|<cwith|1|-1|3|3|cell-halign|r>|<cwith|1|-1|3|3|cell-rborder|1ln>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|1ln>|<cwith|1|-1|5|5|cell-halign|r>|<cwith|1|-1|5|5|cell-rborder|1ln>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|6|6|cell-rborder|1ln>|<cwith|1|-1|7|7|cell-halign|r>|<cwith|1|-1|7|7|cell-rborder|1ln>|<cwith|1|-1|8|8|cell-halign|c>|<cwith|1|-1|8|8|cell-rborder|1ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|3|3|1|-1|cell-bborder|1ln>|<cwith|4|4|1|-1|cell-bborder|1ln>|<cwith|5|5|1|-1|cell-bborder|1ln>|<cwith|6|6|1|-1|cell-bborder|1ln>|<cwith|7|7|1|-1|cell-bborder|1ln>|<cwith|8|8|1|-1|cell-bborder|1ln>|<cwith|9|9|1|-1|cell-bborder|1ln>|<cwith|10|10|1|-1|cell-bborder|1ln>|<cwith|11|11|1|-1|cell-bborder|1ln>|<cwith|12|12|1|-1|cell-bborder|1ln>|<cwith|13|13|1|-1|cell-bborder|1ln>|<cwith|14|14|1|-1|cell-bborder|1ln>|<cwith|15|15|1|-1|cell-bborder|1ln>|<cwith|16|16|1|-1|cell-bborder|1ln>|<cwith|17|17|1|-1|cell-bborder|1ln>|<cwith|18|18|1|-1|cell-bborder|1ln>|<cwith|19|19|1|-1|cell-bborder|1ln>|<cwith|20|20|1|-1|cell-bborder|1ln>|<cwith|21|21|1|-1|cell-bborder|1ln>|<cwith|22|22|1|-1|cell-bborder|1ln>|<cwith|23|23|1|-1|cell-bborder|1ln>|<cwith|24|24|1|-1|cell-bborder|1ln>|<cwith|25|25|1|-1|cell-bborder|1ln>|<cwith|26|26|1|-1|cell-bborder|1ln>|<cwith|27|27|1|-1|cell-bborder|1ln>|<cwith|28|28|1|-1|cell-bborder|1ln>|<table|<row|<cell|<math|1>>|<cell|<math|<around|(|4,8,2,10|)>>>|<cell|<math|2>>|<cell|<math|<around|(|6,16,4,18|)>>>|<cell|<math|3>>|<cell|<math|<around|(|8,10,4,14|)>>>|<cell|<math|4>>|<cell|<math|<around|(|8,14,5,17|)>>>>|<row|<cell|<math|5>>|<cell|<math|<around|(|8,18,6,20|)>>>|<cell|<math|6>>|<cell|<math|<around|(|10,16,7,19|)>>>|<cell|<math|7>>|<cell|<math|<around|(|14,16,10,20|)>>>|<cell|<math|8>>|<cell|<math|<around|(|16,20,14,22|)>>>>|<row|<cell|<math|9>>|<cell|<math|<around|(|3,15,2,16|)>>>|<cell|<math|10>>|<cell|<math|<around|(|4,6,2,8|)>>>|<cell|<math|11>>|<cell|<math|<around|(|6,14,4,16|)>>>|<cell|<math|12>>|<cell|<math|<around|(|9,21,8,22|)>>>>|<row|<cell|<math|13>>|<cell|<math|<around|(|10,12,6,16|)>>>|<cell|<math|14>>|<cell|<math|<around|(|10,18,8,20|)>>>|<cell|<math|15>>|<cell|<math|<around|(|12,14,8,18|)>>>|<cell|<math|16>>|<cell|<math|<around|(|18,20,16,22|)>>>>|<row|<cell|<math|17>>|<cell|<math|<around|(|10,14,8,16|)>>>|<cell|<math|18>>|<cell|<math|<around|(|4,4,2,6|)>>>|<cell|<math|19>>|<cell|<math|<around|(|4,14,3,15|)>>>|<cell|<math|20>>|<cell|<math|<around|(|5,7,3,9|)>>>>|<row|<cell|<math|21>>|<cell|<math|<around|(|5,17,4,18|)>>>|<cell|<math|22>>|<cell|<math|<around|(|6,10,4,12|)>>>|<cell|<math|23>>|<cell|<math|<around|(|7,19,6,20|)>>>|<cell|<math|24>>|<cell|<math|<around|(|8,14,6,16|)>>>>|<row|<cell|<math|25>>|<cell|<math|<around|(|10,10,6,14|)>>>|<cell|<math|26>>|<cell|<math|<around|(|10,16,8,18|)>>>|<cell|<math|27>>|<cell|<math|<around|(|10,20,9,21|)>>>|<cell|<math|28>>|<cell|<math|<around|(|14,14,10,18|)>>>>|<row|<cell|<math|29>>|<cell|<math|<around|(|14,18,12,20|)>>>|<cell|<math|30>>|<cell|<math|<around|(|17,19,15,21|)>>>|<cell|<math|31>>|<cell|<math|<around|(|20,20,18,22|)>>>|<cell|<math|32>>|<cell|<math|<around|(|4,10,2,12|)>>>>|<row|<cell|<math|33>>|<cell|<math|<around|(|10,14,6,18|)>>>|<cell|<math|34>>|<cell|<math|<around|(|14,20,12,22|)>>>|<cell|<math|35>>|<cell|<math|<around|(|4,16,2,18|)>>>|<cell|<math|36>>|<cell|<math|<around|(|6,8,2,12|)>>>>|<row|<cell|<math|37>>|<cell|<math|<around|(|8,10,3,15|)>>>|<cell|<math|38>>|<cell|<math|<around|(|8,14,4,18|)>>>|<cell|<math|39>>|<cell|<math|<around|(|8,20,6,22|)>>>|<cell|<math|40>>|<cell|<math|<around|(|10,16,6,20|)>>>>|<row|<cell|<math|41>>|<cell|<math|<around|(|14,16,9,21|)>>>|<cell|<math|42>>|<cell|<math|<around|(|16,18,12,22|)>>>|<cell|<math|43>>|<cell|<math|<around|(|8,10,6,12|)>>>|<cell|<math|44>>|<cell|<math|<around|(|14,16,12,18|)>>>>|<row|<cell|<math|45>>|<cell|<math|<around|(|3,9,1,11|)>>>|<cell|<math|46>>|<cell|<math|<around|(|4,18,2,20|)>>>|<cell|<math|47>>|<cell|<math|<around|(|6,10,2,14|)>>>|<cell|<math|48>>|<cell|<math|<around|(|6,20,4,22|)>>>>|<row|<cell|<math|49>>|<cell|<math|<around|(|10,12,4,18|)>>>|<cell|<math|50>>|<cell|<math|<around|(|12,14,6,20|)>>>|<cell|<math|51>>|<cell|<math|<around|(|14,18,10,22|)>>>|<cell|<math|52>>|<cell|<math|<around|(|15,21,13,23|)>>>>|<row|<cell|<math|53>>|<cell|<math|<around|(|4,10,1,13|)>>>|<cell|<math|54>>|<cell|<math|<around|(|4,20,2,22|)>>>|<cell|<math|55>>|<cell|<math|<around|(|5,7,1,11|)>>>|<cell|<math|56>>|<cell|<math|<around|(|5,17,2,20|)>>>>|<row|<cell|<math|57>>|<cell|<math|<around|(|6,14,2,18|)>>>|<cell|<math|58>>|<cell|<math|<around|(|7,19,4,22|)>>>|<cell|<math|59>>|<cell|<math|<around|(|8,10,2,16|)>>>|<cell|<math|60>>|<cell|<math|<around|(|10,14,4,20|)>>>>|<row|<cell|<math|61>>|<cell|<math|<around|(|10,18,6,22|)>>>|<cell|<math|62>>|<cell|<math|<around|(|14,16,8,22|)>>>|<cell|<math|63>>|<cell|<math|<around|(|14,20,11,23|)>>>|<cell|<math|64>>|<cell|<math|<around|(|17,19,13,23|)>>>>|<row|<cell|<math|65>>|<cell|<math|<around|(|6,8,1,13|)>>>|<cell|<math|66>>|<cell|<math|<around|(|6,16,2,20|)>>>|<cell|<math|67>>|<cell|<math|<around|(|8,12,2,18|)>>>|<cell|<math|68>>|<cell|<math|<around|(|8,18,4,22|)>>>>|<row|<cell|<math|69>>|<cell|<math|<around|(|12,16,6,22|)>>>|<cell|<math|70>>|<cell|<math|<around|(|16,18,11,23|)>>>|<cell|<math|71>>|<cell|<math|<around|(|6,8,4,10|)>>>|<cell|<math|72>>|<cell|<math|<around|(|6,16,5,17|)>>>>|<row|<cell|<math|73>>|<cell|<math|<around|(|8,12,6,14|)>>>|<cell|<math|74>>|<cell|<math|<around|(|8,18,7,19|)>>>|<cell|<math|75>>|<cell|<math|<around|(|12,16,10,18|)>>>|<cell|<math|76>>|<cell|<math|<around|(|16,18,14,20|)>>>>|<row|<cell|<math|77>>|<cell|<math|<around|(|6,12,4,14|)>>>|<cell|<math|78>>|<cell|<math|<around|(|12,18,10,20|)>>>|<cell|<math|79>>|<cell|<math|<around|(|6,18,2,22|)>>>|<cell|<math|80>>|<cell|<math|<around|(|10,12,2,20|)>>>>|<row|<cell|<math|81>>|<cell|<math|<around|(|12,14,4,22|)>>>|<cell|<math|82>>|<cell|<math|<around|(|8,14,2,20|)>>>|<cell|<math|83>>|<cell|<math|<around|(|10,16,4,22|)>>>|<cell|<math|84>>|<cell|<math|<around|(|8,16,2,22|)>>>>|<row|<cell|<math|85>>|<cell|<math|<around|(|10,14,2,22|)>>>|<cell|<math|86>>|<cell|<math|<around|(|12,12,2,22|)>>>|<cell|<math|87>>|<cell|<math|<around|(|12,12,10,14|)>>>|<cell|<math|88>>|<cell|<math|<around|(|4,14,2,16|)>>>>|<row|<cell|<math|89>>|<cell|<math|<around|(|10,10,4,16|)>>>|<cell|<math|90>>|<cell|<math|<around|(|10,20,8,22|)>>>|<cell|<math|91>>|<cell|<math|<around|(|14,14,8,20|)>>>|<cell|<math|92>>|<cell|<math|<around|(|6,12,2,16|)>>>>|<row|<cell|<math|93>>|<cell|<math|<around|(|12,18,8,22|)>>>|<cell|<math|94>>|<cell|<math|<around|(|8,8,6,10|)>>>|<cell|<math|95>>|<cell|<math|<around|(|16,16,14,18|)>>>|<cell|<math|96>>|<cell|<math|<around|(|10,10,2,18|)>>>>|<row|<cell|<math|97>>|<cell|<math|<around|(|14,14,6,22|)>>>|<cell|<math|98>>|<cell|<math|<around|(|10,10,8,12|)>>>|<cell|<math|99>>|<cell|<math|<around|(|14,14,12,16|)>>>|<cell|<math|100>>|<cell|<math|<around|(|12,12,8,16|)>>>>|<row|<cell|<math|101>>|<cell|<math|<around|(|12,12,4,20|)>>>|<cell|<math|102>>|<cell|<math|<around|(|8,16,6,18|)>>>|<cell|<math|103>>|<cell|<math|<around|(|8,16,4,20|)>>>|<cell|<math|104>>|<cell|<math|<around|(|8,8,4,12|)>>>>|<row|<cell|<math|105>>|<cell|<math|<around|(|16,16,12,20|)>>>|<cell|<math|106>>|<cell|<math|<around|(|8,8,2,14|)>>>|<cell|<math|107>>|<cell|<math|<around|(|16,16,10,22|)>>>|<cell|<math|108>>|<cell|<math|<around|(|6,18,4,20|)>>>>|<row|<cell|<math|109>>|<cell|<math|<around|(|6,6,2,10|)>>>|<cell|<math|110>>|<cell|<math|<around|(|18,18,14,22|)>>>|<cell|>|<cell|>|<cell|>|<cell|>>>>>
      </equation*>
    </itemize>
  </coro>

  <\proof>
    Applying Theorem<nbsp><reference|t1> to the cases <math|n=5,8,12>, the
    assertions follow from a direct computation. Note that in either case the
    last eleven entries of the lists above derive from (i)-(xi) of
    Theorem<nbsp><reference|intersectq>.
  </proof>

  <section|Determination of convex subsets of algebraic Delone sets by
  X-rays>

  <\defi>
    <label|xray..>

    <\itemize>
      <item*|(a)>Let <math|F> be a finite subset of <math|<C>>, let
      <math|u\<in\>\<bbb-S\><rsup|1>> be a direction, and let
      <math|\<cal-L\><rsub|u>> be the set of lines in the complex plane in
      direction <math|u>. Then the <with|font-shape|italic|(discrete
      parallel)> <with|font-shape|italic|X-ray> of <math|F>
      <with|font-shape|italic|in direction> <math|u> is the function
      <math|X<rsub|u>*F:\<cal-L\><rsub|u>\<rightarrow\>\<bbb-N\><rsub|0>\<assign\>\<bbb-N\>\<cup\><around|{|0|}>>,
      defined by

      <\equation*>
        X<rsub|u>*F<around|(|\<ell\>|)>\<assign\><math-up|card><around|(|F\<cap\>\<ell\><space|0.17em>|)><space|0.17em>.
      </equation*>

      <item*|(b)>Let <math|\<cal-F\>> be a collection of finite subsets of
      <math|<C>> and let <math|U\<subset\>\<bbb-S\><rsup|1>> be a finite set
      of directions. We say that the elements of <math|\<cal-F\>> are
      <with|font-shape|italic|determined> by the X-rays in the directions of
      <math|U> if, for all <math|F,F<rprime|'>\<in\>\<cal-F\>>, one has

      <\equation*>
        <around|(|X<rsub|u>*F=X<rsub|u>*F<rprime|'><space|0.27em><space|0.17em>\<forall\>u\<in\>U|)><space|0.27em>\<Rightarrow\><space|0.27em>F=F<rprime|'><space|0.17em>.
      </equation*>
    </itemize>
  </defi>

  The following negative result shows that, for algebraic Delone sets
  <math|<varLambda>>, one has to impose some restriction on the finite
  subsets of <math|<varLambda>> to be determined. The proof only needs
  property (Hom).

  <\fact>
    <cite-detail|H5|Prop.<nbsp> 3.1 and Remark 3.2><label|source> Let
    <math|<varLambda>> be an algebraic Delone set and let
    <math|U\<subset\>\<bbb-S\><rsup|1>> be a finite set of pairwise
    nonparallel <math|<varLambda>>-directions. Then the finite subsets of
    <math|<varLambda>> are not determined by the X-rays in the directions of
    <math|U>. <math|\<Box\>>
  </fact>

  Here, we shall focus on the convex subsets of algebraic Delone sets. One
  has the following fundamental result which even holds for Delone sets
  <math|<varLambda>> with property (Hom). See
  Figure<nbsp><reference|fig:tilingupolygon> for an illustration of direction
  (i)<math|\<Rightarrow\>>(ii).

  <\fact>
    <cite-detail|H5|Prop.<nbsp> 4.6 and Lemma 4.5><label|characungen> Let
    <math|<varLambda>> be an algebraic Delone set and let
    <math|U\<subset\>\<bbb-S\><rsup|1>> be a set of two or more pairwise
    nonparallel <math|<varLambda>>-directions. The following statements are
    equivalent:

    <\itemize>
      <item*|(i)>The convex subsets of <math|<varLambda>> are determined by
      the X-rays in the directions of <math|U>.

      <item*|(ii)>There is no <math|U>-polygon in <math|<varLambda>>.
    </itemize>

    In addition, if <math|<math-up|card><around|(|U|)>\<less\>4>, then there
    is a <math|U>-polygon in <math|<varLambda>>. <math|\<Box\>>
  </fact>

  The proof of the following central result uses Darboux's theorem on second
  midpoint polygons; see<nbsp><cite|D>, <nbsp><cite|GM>
  or<nbsp><cite-detail|G|Ch.<nbsp>1>.

  <\fact>
    <cite-detail|GG|Prop.<nbsp> 4.2><label|uaffine> Let
    <math|U\<subset\>\<bbb-S\><rsup|1>> be a finite set of directions. Then
    there exists a <math|U>-polygon if and only if there is an affinely
    regular polygon such that each direction in <math|U> is parallel to one
    of its edges. <math|\<Box\>>
  </fact>

  <\rem>
    <label|urem>Clearly, <math|U>-polygons have an even number of vertices.
    Moreover, an affinely regular polygon with an even number of vertices is
    a <math|U>-polygon if and only if each direction of <math|U> is parallel
    to one of its edges. On the other hand, it is important to note that a
    <math|U>-polygon need not be affinely regular, even if it is a
    <math|U>-polygon in an algebraic Delone set. For example, there is a
    <math|U>-icosagon in the vertex set of the Tbingen triangle tiling of
    the plane (a <math|5>-cyclotomic model set;
    see<nbsp><cite-detail|H4|Fig.<nbsp>1, Corollary 14 and Example 15>),
    which cannot be affinely regular since that restricts the number of
    vertices to <math|3>, <math|4>, <math|5>, <math|6> or <math|10>
    by<nbsp><cite-detail|H3|Corollary 4.2>; see
    also<nbsp><cite-detail|GG|Example 4.3> for an example in the case of the
    square lattice. In general, there is an affinely regular polygon with
    <math|n\<geq\>3> vertices in an algebraic Delone set <math|<varLambda>>
    if and only if <math|<Q><around|(|\<zeta\><rsub|n>|)><rsup|+>\<subset\>K<rsub|<varLambda>><rsup|+>>,
    the latter being a relation which (due to property (Alg)) can only hold
    for finitely many values of <math|n>;
    cf.<nbsp><nbsp><cite-detail|H3|Thm.<nbsp> 3.3>.
  </rem>

  We can now prove our main result on <math|U>-polygons which is an extension
  of<nbsp><cite-detail|GG|Thm.<nbsp> 4.5>. In fact, we use the same arguments
  as introduced by Gardner and Gritzmann in conjunction with
  Fact<nbsp><reference|crkn4gen> and Theorem<nbsp><reference|algcoro>. Note
  that the result even holds for arbitrary sets <math|<varLambda>> with
  property (Alg).

  <\theorem>
    <label|main>Let <math|<varLambda>> be an algebraic Delone set. Further,
    let <math|U\<subset\>\<bbb-S\><rsup|1>> be a set of four or more pairwise
    nonparallel <math|<varLambda>>-directions and suppose the existence of a
    <math|U>-polygon. Then the cross ratio of slopes of any four directions
    of <math|U>, arranged in order of increasing angle with the positive real
    axis, is an element of the set <math|\<cal-C\><around|(|K<rsub|<varLambda>><rsup|+>|)>>.
    Moreover, <math|\<cal-C\><around|(|K<rsub|<varLambda>><rsup|+>|)>> is
    finite and <math|<math-up|card><around|(|U|)>> is bounded above by a
    finite number <math|b<rsub|<varLambda>>\<in\><N>> that only depends on
    <math|<varLambda>>.
  </theorem>

  <\proof>
    Let <math|U> be as in the assertion. By Fact<nbsp><reference|uaffine>,
    <math|U> consists of directions parallel to the edges of an affinely
    regular polygon. There is thus a linear automorphism <math|\<Psi\>> of
    the complex plane such that

    <\equation*>
      V\<assign\><around*|{|\<Psi\><around|(|u|)>/<around|\||\<Psi\><around|(|u|)>|\|><space|0.17em><mid|\|><space|0.17em>u\<in\>U|}>
    </equation*>

    is contained in a set of directions that are equally spaced in
    <math|\<bbb-S\><rsup|1>>, i.e., the angle between each pair of adjacent
    directions is the same. Since the directions of <math|U> are pairwise
    nonparallel, we may assume that there is an <math|m\<in\><N>> with
    <math|m\<geq\>4> such that each direction of <math|V> is given by
    <math|e<rsup|h*\<pi\>*i/m>>, where <math|h\<in\><N><rsub|0>> satisfies
    <math|h\<leq\>m-1>. Let <math|u<rsub|j>>, <math|1\<leq\>j\<leq\>4>, be
    four directions of <math|U>, arranged in order of increasing angle with
    the positive real axis. By Fact<nbsp><reference|crkn4gen>, one has

    <\equation*>
      q\<assign\><around*|\<langle\>|<math-up|sl><around|(|u<rsub|1>|)>,<math-up|sl><around|(|u<rsub|2>|)>,<math-up|sl><around|(|u<rsub|3>|)>,<math-up|sl><around|(|u<rsub|4>|)>|\<rangle\>>\<in\>K<rsub|<varLambda>><rsup|+><space|0.17em>.
    </equation*>

    We may assume that <math|\<Psi\><around|(|u<rsub|j>|)>/<around|\||\<Psi\><around|(|u<rsub|j>|)>|\|>=e<rsup|h<rsub|j>*\<pi\>*i/m>>,
    where <math|h<rsub|j>\<in\><N><rsub|0>>, <math|1\<leq\>j\<leq\>4>, and,
    <math|h<rsub|1>\<less\>h<rsub|2>\<less\>h<rsub|3>\<less\>h<rsub|4>\<leq\>m-1>.
    Fact<nbsp><reference|crossratio> now implies

    <eqnarray*|<tformat|<table|<row|<cell|q>|<cell|=>|<cell|<around*|\<langle\>|<math-up|sl><around|(|\<Psi\><around|(|u<rsub|1>|)>|)>,<math-up|sl><around|(|\<Psi\><around|(|u<rsub|2>|)>|)>,<math-up|sl><around|(|\<Psi\><around|(|u<rsub|3>|)>|)>,<math-up|sl><around|(|\<Psi\><around|(|u<rsub|4>|)>|)>|\<rangle\>>>>|<row|<cell|>|<cell|=>|<cell|<frac|<around|(|tan
    <around|(|<frac|h<rsub|3>*\<pi\>|m>|)>-tan
    <around|(|<frac|h<rsub|1>*\<pi\>|m>|)>|)>*<around|(|tan
    <around|(|<frac|h<rsub|4>*\<pi\>|m>|)>-tan
    <around|(|<frac|h<rsub|2>*\<pi\>|m>|)>|)>|<around|(|tan
    <around|(|<frac|h<rsub|3>*\<pi\>|m>|)>-tan
    <around|(|<frac|h<rsub|2>*\<pi\>|m>|)>|)>*<around|(|tan
    <around|(|<frac|h<rsub|4>*\<pi\>|m>|)>-tan
    <around|(|<frac|h<rsub|1>*\<pi\>|m>|)>|)>>>>|<row|<cell|>|<cell|=>|<cell|<frac|sin
    <around|(|<frac|<around|(|h<rsub|3>-h<rsub|1>|)>*\<pi\>|m>|)>*sin
    <around|(|<frac|<around|(|h<rsub|4>-h<rsub|2>|)>*\<pi\>|m>|)>|sin
    <around|(|<frac|<around|(|h<rsub|3>-h<rsub|2>|)>*\<pi\>|m>|)>*sin
    <around|(|<frac|<around|(|h<rsub|4>-h<rsub|1>|)>*\<pi\>|m>|)>><space|0.17em>.>>>>>

    Setting <math|k<rsub|1>\<assign\>h<rsub|3>-h<rsub|1>>,
    <math|k<rsub|2>\<assign\>h<rsub|4>-h<rsub|2>>,
    <math|k<rsub|3>\<assign\>h<rsub|3>-h<rsub|2>> and
    <math|k<rsub|4>\<assign\>h<rsub|4>-h<rsub|1>>, one gets
    <math|1\<leq\>k<rsub|3>\<less\>k<rsub|1>,k<rsub|2>\<less\>k<rsub|4>\<leq\>m-1>
    and <math|k<rsub|1>+k<rsub|2>=k<rsub|3>+k<rsub|4>>. Using <math|sin
    <around|(|\<theta\>|)>=-e<rsup|-i*\<theta\>>*<around|(|1-e<rsup|2*i*\<theta\>>|)>/2*i>,
    one finally obtains

    <\equation*>
      K<rsub|<varLambda>><rsup|+><owns>q=<frac|<around|(|1-\<zeta\><rsub|m><rsup|k<rsub|1>>|)>*<around|(|1-\<zeta\><rsub|m><rsup|k<rsub|2>>|)>|<around|(|1-\<zeta\><rsub|m><rsup|k<rsub|3>>|)>*<around|(|1-\<zeta\><rsub|m><rsup|k<rsub|4>>|)>>=f<rsub|m><around|(|d|)><space|0.17em>,
    </equation*>

    with <math|d\<assign\><around|(|k<rsub|1>,k<rsub|2>,k<rsub|3>,k<rsub|4>|)>>,
    as in<nbsp>(<reference|fmd>). Then, <math|d\<in\>D<rsub|m>> if its first
    two coordinates are interchanged, if necessary, to ensure that
    <math|k<rsub|1>\<leq\>k<rsub|2>>; note that this operation does not
    change the value of <math|f<rsub|m><around|(|d|)>>. This proves the first
    assertion.

    Suppose that <math|<math-up|card><around|(|U|)>\<geq\>7>. Let
    <math|U<rprime|'>> consist of seven directions of <math|U> and let
    <math|V<rprime|'>\<assign\>{\<Psi\><around|(|u|)>/<around|\||\<Psi\><around|(|u|)><around|\||<space|0.17em>|\|>*<space|0.17em>u\<in\>U<rprime|'>|}>>.
    We may assume that all the directions of <math|V<rprime|'>> are in the
    first two quadrants, so one of these quadrants, say the first, contains
    at least four directions of <math|V<rprime|'>>. Application of the above
    argument to these four directions gives integers <math|h<rsub|j>>
    satisfying <math|0\<leq\>h<rsub|1>\<less\>h<rsub|2>\<less\>h<rsub|3>\<less\>h<rsub|4>\<leq\>m/2>,
    where we may also assume, by rotating the directions of
    <math|V<rprime|'>> if necessary, that <math|h<rsub|1>=0>. As above, we
    obtain a corresponding solution of <math|f<rsub|m><around|(|d|)>=q\<in\>K<rsub|<varLambda>><rsup|+>>,
    where <math|d\<in\>D<rsub|m>>.

    By property (Alg) and Theorem<nbsp><reference|algcoro>, the set
    <math|\<cal-C\><around|(|K<rsub|<varLambda>><rsup|+>|)>> is finite and
    there is a number <math|m<rsub|<varLambda>>\<in\><N>> such that all
    solutions of <math|f<rsub|m><around|(|d|)>\<in\>K<rsub|<varLambda>><rsup|+>>,
    where <math|m\<geq\>4> and <math|d\<in\>D<rsub|m>>, are either of the
    form (xii) or (xiii) of Theorem<nbsp><reference|intersectq> or are given,
    up to multiplication of <math|m> and <math|d> by the same factor, by
    <math|m=m<rsub|<varLambda>>> and <math|d> from a finite list. Without
    restriction, we may assume that <math|m<rsub|<varLambda>>> is even.

    Suppose that the above solution is of the form (xii) or (xiii) of
    Theorem<nbsp><reference|intersectq>. Then using <math|h<rsub|1>=0>, one
    obtains <math|h<rsub|4>=k<rsub|4>=k+s\<gtr\>m/2>, a contradiction. Thus,
    our solution derives from <math|m=m<rsub|<varLambda>>> and finitely many
    values of <math|d\<in\>D<rsub|m>>. Since this applies to any four
    directions of <math|V<rprime|'>> lying in the first quadrant, all such
    directions correspond to angles with the positive real axis which are
    integer multiples of <math|\<pi\>/m<rsub|<varLambda>>>.

    We claim that all directions of <math|V<rprime|'>> have the latter
    property. To see this, suppose that there is a direction
    <math|v\<in\>V<rprime|'>> in the second quadrant, and consider a set of
    four directions <math|v<rsub|j>>, <math|1\<leq\>j\<leq\>4>, in
    <math|V<rprime|'>>, where <math|v<rsub|4>=v> and <math|v<rsub|j>>,
    <math|1\<leq\>j\<leq\>3>, lie in the first quadrant. Suppose that
    <math|v<rsub|j>=e<rsup|h<rsub|j>*\<pi\>*i/m>>, <math|1\<leq\>j\<leq\>4>.
    Then <math|h<rsub|j>> is an integer multiple of
    <math|m/m<rsub|<varLambda>>>, for <math|1\<leq\>j\<leq\>3>. Again, we
    obtain a corresponding solution of <math|f<rsub|m><around|(|d|)>=q\<in\>K<rsub|<varLambda>><rsup|+>>,
    where <math|d\<in\>D<rsub|m>>. If this solution derives from the finite
    list guaranteed by Theorem<nbsp><reference|algcoro>, then clearly
    <math|h<rsub|4>> is also an integer multiple of
    <math|m/m<rsub|<varLambda>>>. Otherwise, by
    Theorem<nbsp><reference|algcoro>, this solution is of the form (xii) or
    (xiii) of Theorem<nbsp><reference|intersectq> and we can take
    <math|h<rsub|1>=0> as before, whence either <math|h<rsub|2>=k>,
    <math|h<rsub|3>=2*k> and <math|h<rsub|4>=k+s>,
    <math|1\<leq\>k\<leq\>s/2>, or <math|h<rsub|2>=s-k>, <math|h<rsub|3>=s>
    and <math|h<rsub|4>=k+s>, <math|s/2\<leq\>k\<less\>s>, where
    <math|m=2*s>. Since <math|s=m/2=<around|(|m<rsub|<varLambda>>/2|)>*<around|(|m/m<rsub|<varLambda>>|)>>
    is an integer multiple of <math|m/m<rsub|<varLambda>>>, we conclude in
    either case that <math|k>, and hence <math|h<rsub|4>=k+s>, is also an
    integer multiple of <math|m/m<rsub|<varLambda>>>. This proves the claim.

    It thus remains to examine the case <math|m=m<rsub|<varLambda>>> in more
    detail. Let <math|h<rsub|j>>, <math|1\<leq\>j\<leq\>4>, correspond to the
    four directions of <math|V<rprime|'>> having the smallest angles with the
    positive real axis, so that <math|h<rsub|1>=0> and
    <math|h<rsub|j>\<leq\>m/2>, <math|2\<leq\>j\<leq\>4>. We have already
    shown that the corresponding <math|d=<around|(|k<rsub|1>,k<rsub|2>,k<rsub|3>,k<rsub|4>|)>>
    must occur in the finite list guaranteed by
    Theorem<nbsp><reference|algcoro>. Since <math|h<rsub|j>\<leq\>m/2>,
    <math|1\<leq\>j\<leq\>4>, we also have <math|k<rsub|j>\<leq\>m/2>,
    <math|1\<leq\>j\<leq\>4>. This yields only finitely many quadruples
    <math|<around|(|h<rsub|1>,h<rsub|2>,h<rsub|3>,h<rsub|4>|)>=<around|(|0,k<rsub|1>-k<rsub|3>,k<rsub|1>,k<rsub|4>|)>>.

    Suppose that <math|h> corresponds to any other direction of
    <math|V<rprime|'>> and replace <math|<around|(|h<rsub|1>,h<rsub|2>,h<rsub|3>,h<rsub|4>|)>>
    by <math|<around|(|h<rsub|2>,h<rsub|3>,h<rsub|4>,h|)>>. We obtain
    finitely many <math|d=<around|(|h<rsub|4>-h<rsub|2>,h-h<rsub|3>,h<rsub|4>-h<rsub|3>,h-h<rsub|2>|)>\<in\>D<rsub|m>>,
    which, by Theorem<nbsp><reference|algcoro>, either occur in (xii) or
    (xiii) of Theorem<nbsp><reference|intersectq> with
    <math|m=m<rsub|<varLambda>>> or occur in the finite list guaranteed by
    that result. This gives only finitely many possible finite sets of more
    than four directions, which implies that
    <math|<math-up|card><around|(|U|)>> is bounded from above by a finite
    number that only depends on <math|<varLambda>> (since the above analysis
    only depends on <math|<varLambda>>).
  </proof>

  Similarly, the next result even holds for arbitrary sets <math|<varLambda>>
  with property (<math|n>-Cyc), where <math|n\<geq\>3>.

  <\theorem>
    <label|finitesetncr0gen>Let <math|n\<geq\>3> and let <math|<varLambda>>
    be an <math|n>-cyclotomic Delone set. Further, let
    <math|U\<subset\>\<bbb-S\><rsup|1>> be a set of four or more pairwise
    nonparallel <math|<varLambda>>-directions and suppose the existence of a
    <math|U>-polygon. Then the cross ratio of slopes of any four directions
    of <math|U>, arranged in order of increasing angle with the positive real
    axis, is an element of the subset <math|\<cal-C\><around|(|K<rsub|<varLambda>><rsup|+>|)>>
    of <math|\<cal-C\><around|(|<Q><around|(|\<zeta\><rsub|n>|)><rsup|+>|)>>.
    Moreover

    <\equation*>
      \<cal-C\><around|(|<Q><around|(|\<zeta\><rsub|n>|)><rsup|+>|)>=\<cal-C\><rsub|<math-up|lcm><around|(|2*n,12|)>><around|(|<Q><around|(|\<zeta\><rsub|n>|)><rsup|+>|)>
    </equation*>

    is finite and <math|<math-up|card><around|(|U|)>> is bounded above by a
    finite number <math|b<rsub|n>\<in\><N>> that only depends on <math|n>. In
    particular, one can choose <math|b<rsub|3>=b<rsub|4>=6>,
    <math|b<rsub|5>=10>, <math|b<rsub|8>=8> and <math|b<rsub|12>=12>.
  </theorem>

  <\proof>
    Employing Theorem<nbsp><reference|t1> together with the trivial
    observation that <math|K<rsub|<varLambda>><rsup|+>\<subset\><Q><around|(|\<zeta\><rsub|n>|)><rsup|+>>
    for any <math|n>-cyclotomic Delone set, the general result follows from
    the same arguments as used in the proof of Theorem<nbsp><reference|main>.
    The work of Gardner and Gritzmann shows that one can choose
    <math|b<rsub|3>=b<rsub|4>=6>; cf.<nbsp><cite-detail|GG|Thm.<nbsp> 4.5>.
    The specific bounds <math|b<rsub|n>> for <math|n=5,8,12> are obtained by
    following the proof of Theorem<nbsp><reference|main> and employing
    Corollary<nbsp><reference|coro8125>.

    More precisely, let <math|n=8> (whence
    <math|<math-up|lcm><around|(|2*n,12|)>=48>) and suppose that
    <math|<math-up|card><around|(|U|)>\<geq\>7>. Let <math|U<rprime|'>>
    consist of seven directions of <math|U> and let
    <math|V<rprime|'>\<assign\>{\<Psi\><around|(|u|)>/<around|\||\<Psi\><around|(|u|)><around|\||<space|0.17em>|\|>*<space|0.17em>u\<in\>U<rprime|'>|}>>,
    with <math|\<Psi\>> as described in the proof of
    Theorem<nbsp><reference|main>. Then all directions of <math|V<rprime|'>>
    correspond to angles with the positive real axis which are integer
    multiples of <math|\<pi\>/48> and it suffices to examine the case
    <math|m=48> in more detail. Let <math|h<rsub|j>>,
    <math|1\<leq\>j\<leq\>4>, correspond to the four directions of
    <math|V<rprime|'>> having the smallest angles with the positive real
    axis, so that <math|h<rsub|1>=0> and <math|h<rsub|j>\<leq\>m/2=24>,
    <math|2\<leq\>j\<leq\>4>. The corresponding
    <math|d=<around|(|k<rsub|1>,k<rsub|2>,k<rsub|3>,k<rsub|4>|)>> must occur
    in (1)-(82) of Corollary<nbsp><reference|coro8125>(b). Since
    <math|h<rsub|j>\<leq\>24>, <math|1\<leq\>j\<leq\>4>, we also have
    <math|k<rsub|j>\<leq\>24>, <math|1\<leq\>j\<leq\>4>. The only
    possibilities are (1), (3), (15), (19), (27), (28), (33), (34), (47),
    (67), (76) and (81) of Corollary<nbsp><reference|coro8125>(b). These
    yield

    <eqnarray*|<tformat|<table|<row|<cell|<around|(|h<rsub|1>,h<rsub|2>,h<rsub|3>,h<rsub|4>|)>>|<cell|\<in\>>|<cell|<around*|{|<around|(|0,2,6,20|)>,<around|(|0,6,12,18|)>,<around|(|0,2,4,12|)>,<around|(|0,6,12,24|)>,|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<hphantom|<around*|{||\<nobracket\>>><around|(|0,2,10,24|)>,<around|(|0,6,18,24|)>,<around|(|0,6,8,14|)>,<around|(|0,6,9,21|)>,>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|<hphantom|<around*|{||\<nobracket\>>><around|(|0,8,10,20|)>,<around|(|0,6,16,22|)>,<around|(|0,8,16,24|)>,<around|(|0,8,12,20|)>|}><space|0.17em>.>>>>>

    Suppose that <math|h> corresponds to any other direction of
    <math|V<rprime|'>> and replace <math|<around|(|h<rsub|1>,h<rsub|2>,h<rsub|3>,h<rsub|4>|)>>
    by <math|<around|(|h<rsub|2>,h<rsub|3>,h<rsub|4>,h|)>>. The corresponding
    <math|d> either occur in (xii) or (xiii) of
    Theorem<nbsp><reference|intersectq> with <math|m=48> or occur in (1)-(82)
    of Corollary<nbsp><reference|coro8125>(b). We obtain
    <math|<around|(|18,h-6,14,h-2|)>>, <math|<around|(|12,h-12,6,h-6|)>>,
    <math|<around|(|10,h-4,8,h-2|)>>, <math|<around|(|18,h-12,12,h-6|)>>,
    <math|<around|(|22,h-10,14,h-2|)>>, <math|<around|(|18,h-18,6,h-6|)>>,
    <math|<around|(|8,h-8,6,h-6|)>>, <math|<around|(|15,h-9,12,h-6|)>>,
    <math|<around|(|12,h-10,10,h-8|)>>, <math|<around|(|16,h-16,6,h-6|)>>,
    <math|<around|(|16,h-16,8,h-8|)>> and <math|<around|(|12,h-12,8,h-8|)>>.
    The only possibilities are <math|h=24,30,36,42> for
    <math|<around|(|12,h-12,6,h-6|)>>, <math|h=26,40> for
    <math|<around|(|10,h-4,8,h-2|)>>, <math|h=30,36,42> for
    <math|<around|(|18,h-12,12,h-6|)>>, <math|h=38,46> for
    <math|<around|(|22,h-10,14,h-2|)>>, <math|h=36,42> for
    <math|<around|(|18,h-18,6,h-6|)>>, <math|h=34> for
    <math|<around|(|12,h-10,10,h-8|)>>, <math|h=32,40> for
    <math|<around|(|16,h-16,8,h-8|)>> and <math|h=34> for
    <math|<around|(|12,h-12,8,h-8|)>>. It follows that the only possible sets
    of more than four directions only comprise directions of the form
    <math|e<rsup|h*\<pi\>*i/48>> and are given by the ranges

    <eqnarray*|<tformat|<table|<row|<cell|>|<cell|>|<cell|<around|{|0,8,16,24,32,40|}>,<around|{|0,8,12,20,34|}>,<around|{|0,6,12,18,24,30,36,42|}>,>>|<row|<cell|>|<cell|>|<cell|<around|{|0,2,4,12,26,40|}>,<around|{|0,6,12,24,30,36,42|}>,<around|{|0,2,10,24,38,46|}>,>>|<row|<cell|>|<cell|>|<cell|<around|{|0,6,18,24,36,42|}>,<around|{|0,8,10,20,34|}>>>>>>

    of <math|h>. In particular, <math|<math-up|card><around|(|U|)>\<leq\>8>.

    With the help of Corollary<nbsp><reference|coro8125>, the cases
    <math|n=5,12> can be treated analogously with the following results.

    For <math|n=12>, the only possible sets of more than four directions only
    comprise directions of the form <math|e<rsup|h*\<pi\>*i/24>> and are
    given by the ranges

    <eqnarray*|<tformat|<table|<row|<cell|>|<cell|>|<cell|<around|{|0,4,8,12,16,18,20,22|}>,<around|{|0,4,6,10,14,16,18,20,22|}>,>>|<row|<cell|>|<cell|>|<cell|<around|{|0,2,4,10,12,14,18,20,22|}>,<around|{|0,2,4,8,12,14,16,18,20,22|}>,>>|<row|<cell|>|<cell|>|<cell|<around|{|0,2,4,6,8,10,12,14,16,18,20,22|}>,<around|{|0,2,6,12,16,18,20,22|}>,>>|<row|<cell|>|<cell|>|<cell|<around|{|0,2,4,12,14,20,22|}>,<around|{|0,4,6,12,14,16,18,20,22|}>,<around|{|0,2,8,12,18,20,22|}>,>>|<row|<cell|>|<cell|>|<cell|<around|{|0,2,6,10,14,16,18,20,22|}>,<around|{|0,2,8,10,16,18,20,22|}>,<around|{|0,2,10,12,20,22|}>>>>>>

    of <math|h>, whence <math|<math-up|card><around|(|U|)>\<leq\>12>.

    For <math|n=5>, the only possible sets of more than four directions only
    comprise directions of the form <math|e<rsup|h*\<pi\>*i/60>> and are
    given by the ranges

    <eqnarray*|<tformat|<table|<row|<cell|>|<cell|>|<cell|<around|{|0,10,20,30,40,50|}>,<around|{|0,6,24,30,48,54|}>,<around|{|0,2,4,10,32,54|}>,>>|<row|<cell|>|<cell|>|<cell|<around|{|0,4,8,18,34,50|}>,<around|{|0,6,10,16,38|}>,<around|{|0,6,12,24,30,36,42,48,54|}>,>>|<row|<cell|>|<cell|>|<cell|<around|{|0,10,18,28,44|}>,<around|{|0,12,18,30,36,42,48,54|}>,<around|{|0,6,8,16,38|}>,>>|<row|<cell|>|<cell|>|<cell|<around|{|0,10,14,28,34|}>,<around|{|0,2,8,30,52,58|}>,<around|{|0,4,14,30,46,56|}>,>>|<row|<cell|>|<cell|>|<cell|<around|{|0,6,18,30,42,48,54|}>,<around|{|0,6,12,30,36,42,48,54|}>,>>|<row|<cell|>|<cell|>|<cell|<around|{|0,6,12,18,24,30,36,42,48,54|}>,<around|{|0,6,18,24,36,42,48,54|}>>>>>>

    of <math|h>, whence <math|<math-up|card><around|(|U|)>\<leq\>10> in this
    case.
  </proof>

  Without further mention, the following result will be used in
  Remark<nbsp><reference|maxrem> below.

  <\lem>
    <label|upollem>Let <math|<varLambda>> be a <math|K>-algebraic model set
    and let <math|U\<subset\>\<bbb-S\><rsup|1>> be a finite set of
    directions. The following statements are equivalent:

    <\itemize>
      <item*|(i)>There is a <math|U>-polygon in <math|<varLambda>>.

      <item*|(ii)>For any <math|K>-algebraic model set
      <math|<varLambda><rprime|'>>, there is a <math|U>-polygon in
      <math|<varLambda><rprime|'>>.
    </itemize>
  </lem>

  <\proof>
    The assertion follows immediately from
    Proposition<nbsp><reference|cmsads> together
    with<nbsp><cite-detail|H5|Fact 4.4>.
  </proof>

  <big-figure|<epsfysize>=0.6tex-text-width<epsfbox|shield.eps><label|fig:tilingupolygon>|The
  boundary of a <math|U>-polygon in the vertex set <math|<varLambda>> of the
  twelvefold shield tiling, where <math|U> is the set of twelve pairwise
  nonparallel <math|<varLambda>>-directions given by the edges and diagonals
  of the central regular dodecagon. The vertices of <math|<varLambda>> in the
  interior of the <math|U>-polygon together with the vertices indicated by
  the black and grey dots, respectively, give two different convex subsets of
  <math|<varLambda>> with the same X-rays in the directions of <math|U>.>

  <\rem>
    <label|maxrem>The work of Gardner and Gritzmann shows that
    <math|b<rsub|3>=b<rsub|4>=6> is best possible for any <math|3>- or
    <math|4>-cyclotomic model set; cf.<nbsp><cite-detail|GG|Example 4.3>. The
    <math|U>-icosagon in the vertex set of the Tbingen triangle tiling from
    Remark<nbsp><reference|urem> has the property that
    <math|<math-up|card><around|(|U|)>=10>; see<nbsp><cite-detail|H4|Figure
    1>. This shows that, for any <math|5>-cyclotomic model set, the number
    <math|b<rsub|5>=10> is best possible.
    Fig.<nbsp><reference|fig:tilingupolygon> shows a <math|U>-polygon with
    <math|24> vertices in the vertex set of the shield tiling with
    <math|<math-up|card><around|(|U|)>=12>, wherefore <math|b<rsub|12>=12> is
    best possible for any <math|12>-cyclotomic model set. A similar example
    of a <math|U>-polygon with <math|16> vertices in the vertex set of the
    Ammann-Beenker tiling with <math|<math-up|card><around|(|U|)>=8> shows
    that <math|b<rsub|8>=8> is best possible for any <math|8>-cyclotomic
    model set; cf.<nbsp><cite-detail|H5|Fig.<nbsp>2>. <math|U>-polygons of
    <with|font-shape|italic|class <math|c\<geq\>4>> (i.e., <math|U>-polygons
    with <math|4> <with|font-shape|italic|consecutive edges> parallel to
    directions of <math|U>) in cyclotomic model sets were studied
    in<nbsp><cite|H4>. By<nbsp><cite-detail|H4|Corollary 14> (see
    also<nbsp><cite-detail|DP|Thm.<nbsp> 12>), the existence of a
    <math|U>-polygon of class <math|c\<geq\>4> in an <math|n>-cyclotomic
    model set with <math|n\<nequiv\>2<pmod|4>> having the property that
    <math|\<phi\><around|(|n|)>/2> is equal to one or a prime number implies
    that <math|<math-up|card><around|(|U|)>\<leq\>a<rsub|n>>, where
    <math|a<rsub|3>=a<rsub|4>=6>, <math|a<rsub|8>=8>, <math|a<rsub|12>=12>
    and <math|a<rsub|n>=2*n> for all other such values of <math|n>. In
    particular, one observes the coincidence <math|b<rsub|n>=a<rsub|n>> for
    <math|n=3,4,5,8,12>; cf.<nbsp>Theorem<nbsp><reference|finitesetncr0gen>.
    However, there does not seem to be a reason why the least possible
    numbers <math|b<rsub|n>> in Theorem<nbsp><reference|finitesetncr0gen> may
    not be larger than <math|a<rsub|n>> for other <math|n\<geq\>3> having the
    above property.
  </rem>

  Summing up, we finally obtain our main result on the determination of
  convex subsets of algebraic Delone sets;
  see<nbsp><cite-detail|H5|Thm.<nbsp> 4.21> for a weaker version.

  <\theorem>
    <label|dtmain>Let <math|<varLambda>> be an algebraic Delone set.

    <\itemize>
      <item*|(a)>There are sets of four pairwise nonparallel
      <math|<varLambda>>-directions such that the convex subsets of
      <math|<varLambda>> are determined by the corresponding X-rays. In
      addition, less than four pairwise nonparallel
      <math|<varLambda>>-directions never suffice for this purpose.

      <item*|(b)>There is a finite number <math|c<rsub|<varLambda>>\<in\><N>>
      such that the convex subsets of <math|<varLambda>> are determined by
      the X-rays in any set of <math|c<rsub|<varLambda>>> pairwise
      nonparallel <math|<varLambda>>-directions.
    </itemize>
  </theorem>

  <\proof>
    To prove<nbsp>(a), it suffices by Fact<nbsp><reference|characungen> and
    Theorem<nbsp><reference|main> to take any set of four pairwise
    nonparallel <math|<varLambda>>-directions such that the cross ratio of
    their slopes, arranged in order of increasing angle with the positive
    real axis, is not an element of the finite set
    <math|\<cal-C\><around|(|K<rsub|<varLambda>><rsup|+>|)>>. Since
    <math|<varLambda>> is relatively dense, the set of
    <math|<varLambda>>-directions is dense in <math|\<bbb-S\><rsup|1>>. In
    particular, this shows that the set of slopes of
    <math|<varLambda>>-directions is infinite. For example by fixing three
    pairwise nonparallel <math|<varLambda>>-directions and letting the fourth
    one vary, one sees from this that the set of cross ratios of slopes of
    four pairwise nonparallel <math|<varLambda>>-directions, arranged in
    order of increasing angle with the positive real axis, is infinite as
    well. The assertion follows. The additional statement follows immediately
    from Fact<nbsp><reference|characungen>. Part<nbsp>(b) is a direct
    consequence of Fact<nbsp><reference|characungen> and
    Theorem<nbsp><reference|main>.
  </proof>

  The following result improves<nbsp><cite-detail|H5|Thm.<nbsp> 4.33> and
  particularly solves Problem 4.34 of<nbsp><cite|H5>;
  cf.<nbsp>Example<nbsp><reference|algex> and
  compare<nbsp><cite-detail|GG|Thm.<nbsp> 5.7>.

  <\theorem>
    <label|dtmain2>Let <math|n\<geq\>3> and let <math|<varLambda>> be an
    <math|n>-cyclotomic Delone set.

    <\itemize>
      <item*|(a)>There are sets of four pairwise nonparallel
      <math|<varLambda>>-directions such that the convex subsets of
      <math|<varLambda>> are determined by the corresponding X-rays. In
      addition, less than four pairwise nonparallel
      <math|<varLambda>>-directions never suffice for this purpose.

      <item*|(b)>There is a finite number <math|c<rsub|n>\<in\><N>> that only
      depends on <math|n> such that the convex subsets of <math|<varLambda>>
      are determined by the X-rays in any set of <math|c<rsub|n>> pairwise
      nonparallel <math|<varLambda>>-directions. In particular, one can
      choose <math|c<rsub|3>=c<rsub|4>=7>, <math|c<rsub|5>=11>,
      <math|c<rsub|8>=9> and <math|c<rsub|12>=13>.
    </itemize>
  </theorem>

  <\proof>
    Part<nbsp>(a) follows immediately from
    Theorem<nbsp><reference|dtmain>(a). Note that, by
    Fact<nbsp><reference|characungen> and
    Theorem<nbsp><reference|finitesetncr0gen>, it suffices to take any set of
    four pairwise nonparallel <math|<varLambda>>-directions such that the
    cross ratio of their slopes, arranged in order of increasing angle with
    the positive real axis, is not an element of the finite set
    <math|\<cal-C\><around|(|<Q><around|(|\<zeta\><rsub|n>|)><rsup|+>|)>>.
    Part<nbsp>(b) is a direct consequence of
    Fact<nbsp><reference|characungen> in conjunction with
    Theorem<nbsp><reference|finitesetncr0gen>.
  </proof>

  <\rem>
    <label|rembest>Remark<nbsp><reference|maxrem> shows that, for any
    <math|n>-cyclotomic model set with <math|n=3,4,5,8,12>, the number
    <math|c<rsub|n>> above is best possible with respect to the numbers of
    X-rays used. As already explained in the introduction, for practical
    applications, one additionally has to make sure that the
    <math|<varLambda>>-directions used yield densely occupied lines in
    <math|<varLambda>>. For the practically most relevant case of
    <math|n>-cyclotomic model sets with <math|n=3,4,5,8,12>, this can
    actually be achieved; cf.<nbsp><cite-detail|GG|Remark 5.8>
    and<nbsp><cite-detail|H5|Sec.<nbsp>4> for examples of suitable sets of
    four pairwise nonparallel <math|<varLambda>>-directions in these cases.
    For the latter examples also recall that, for any <math|n>-cyclotomic
    model set <math|<varLambda>>, the set of <math|<varLambda>>-directions is
    precisely the set of <math|<Z><around|[|\<zeta\><rsub|n>|]>>-directions;
    cf. Remark<nbsp><reference|okdirections> and
    Example<nbsp><reference|algex>. It was shown
    in<nbsp><cite-detail|H2|Prop.<nbsp> 3.11> that
    <with|font-shape|italic|icosahedral model sets>
    <math|<varLambda>\<subset\><R><rsup|3>> can be sliced orthogonal to a
    fivefold axis of their underlying <math|<Z>>-module into
    <math|5>-cyclotomic model sets. Applying Theorem<nbsp><reference|dtmain2>
    to each such slice, one sees that the convex subsets of
    <math|<varLambda>> are determined by the X-rays in suitable four and any
    eleven pairwise nonparallel <math|<varLambda>>-directions orthogonal to
    the slicing axis.
  </rem>

  <section|Determination of convex bodies by continuous X-rays>

  In<nbsp><cite|GM>, the following continuous version of
  Fact<nbsp><reference|characungen> was shown; compare
  Fact<nbsp><reference|uaffine>. Here, the <with|font-shape|italic|continuous
  X-ray> of a <with|font-shape|italic|convex body> <math|K\<subset\><C>>
  (i.e., <math|K> is compact with nonempty interior) in direction
  <math|u\<in\>\<bbb-S\><rsup|1>> gives the length of each chord of <math|K>
  parallel to <math|u> and the concept of determination is defined as in the
  discrete case; cf.<nbsp> <cite|G>, <cite|GM> for details.

  <\fact>
    <label|characuncont>Let <math|U\<subset\>\<bbb-S\><rsup|1>> be a set of
    two or more pairwise nonparallel directions. The following statements are
    equivalent:

    <\itemize>
      <item*|(i)>The convex bodies in <math|<C>> are determined by the
      continuous X-rays in the directions of <math|U>.

      <item*|(ii)>There is no <math|U>-polygon.
    </itemize>

    In addition, if <math|<math-up|card><around|(|U|)>\<less\>4>, then there
    is a <math|U>-polygon. <math|\<Box\>>
  </fact>

  Employing Fact<nbsp><reference|characuncont> instead of
  Fact<nbsp><reference|characungen>, the following result follows from the
  same arguments as used in the proofs of Theorems<nbsp><reference|dtmain>
  and<nbsp><reference|dtmain2>; compare<nbsp><cite-detail|GG|Thm. 6.2>. Note
  that neither the uniform discreteness of <math|<varLambda>> nor property
  (Hom) are needed in the proof. More precisely, our proof of part<nbsp>(a)
  needs property (Alg) and the relative denseness of <math|<varLambda>>,
  whereas part<nbsp>(b) and the additional statement hold for arbitrary sets
  <math|<varLambda>> with property (Alg) and (<math|n>-Cyc) (where
  <math|n\<geq\>3>), respectively.

  <\theorem>
    <label|tmain>Let <math|<varLambda>> be an algebraic Delone set.

    <\itemize>
      <item*|(a)>There are sets of four pairwise nonparallel
      <math|<varLambda>>-directions such that the convex bodies in <math|<C>>
      are determined by the corresponding continuous X-rays. In addition,
      less than four pairwise nonparallel <math|<varLambda>>-directions never
      suffice for this purpose.

      <item*|(b)>There is a finite number <math|c<rsub|<varLambda>>\<in\><N>>
      such that the convex bodies in <math|<C>> are determined by the
      continuous X-rays in any set of <math|c<rsub|<varLambda>>> pairwise
      nonparallel <math|<varLambda>>-directions.
    </itemize>

    Moreover, for any <math|n>-cyclotomic Delone set <math|<varLambda>>,
    there is a finite number <math|c<rsub|n>\<in\><N>> that only depends on
    <math|n> such that the convex bodies in <math|<C>> are determined by the
    continuous X-rays in any set of <math|c<rsub|n>> pairwise nonparallel
    <math|<varLambda>>-directions. In particular, one can choose
    <math|c<rsub|3>=c<rsub|4>=7>, <math|c<rsub|5>=11>, <math|c<rsub|8>=9> and
    <math|c<rsub|12>=13>.<math|\<Box\>>
  </theorem>

  <\rem>
    Employing the <math|U>-polygons from Remark<nbsp><reference|maxrem>, it
    is straightforward to show that the above numbers <math|c<rsub|n>>, where
    <math|n=3,4,5,8,12>, are best possible.
  </rem>

  <section*|Acknowledgements>

  This work was supported by the German Research Council (Deutsche
  Forschungsgemeinschaft), within the CRC 701. C.<nbsp>H.<nbsp>is grateful to
  Richard J.<nbsp>Gardner for his cooperation and encouragement. The authors
  thank M.<nbsp>Baake for useful comments on the manuscript.

  <\thebibliography|99>
    <bibitem|am><em|R. Ammann>, <em|B. Grnbaum> \ <em|G. C. Shephard>,
    Aperiodic tiles, Discrete Comput. Geom. <with|font-series|bold|8> (1992),
    1\U25.

    <bibitem|B><em|M. Baake>, A guide to mathematical quasicrystals, in:
    Quasicrystals. An Introduction to Structure, Physical Properties, and
    Applications, eds. J.-B. Suck, M. Schreiber \ P. Hussler, Springer,
    Berlin, 2002, pp. 17\U48; <slink|http://arxiv.org/abs/math-ph/9901014v1>

    <bibitem|BG2><em|M. Baake>, <em|P. Gritzmann>, <em|C. Huck>, <em|B.
    Langfeld> <em|K. Lord>, Discrete tomography of planar model sets, Acta
    Crystallogr. A <with|font-series|bold|62> (2006), 419\U433;
    <with|font-family|tt|arXiv:math/0609393v1 [math.MG]>

    <bibitem|bh><em|M. Baake> <em|C. Huck>, Discrete tomography of Penrose
    model sets, Philos. Mag. <with|font-series|bold|87> (2007), 2839\U2846;
    <with|font-family|tt|arXiv:math-ph/0610056v1>

    <bibitem|bj><em|M. Baake> <em|D. Joseph>, Ideal and defective vertex
    configurations in the planar octagonal quasilattice, Phys. Rev. B
    <with|font-series|bold|42> (1990), 8091\U8102.

    <bibitem|bk1><em|M. Baake>, <em|P. Kramer>, <em|M. Schlottmann> <em|D.
    Zeidler>, The triangle pattern \U a new quasiperiodic tiling with
    fivefold symmetry, Mod. Phys. Lett. B <with|font-series|bold|4> (1990),
    249\U258.

    <bibitem|bk2><em|M. Baake>, <em|P. Kramer>, <em|M. Schlottmann> <em|D.
    Zeidler>, Planar patterns with fivefold symmetry as sections of periodic
    structures in 4-space, Int. J. Mod. Phys. B <with|font-series|bold|4>
    (1990), 2217\U2268.

    <bibitem|BM><em|M. Baake> <em|R. V. Moody> (eds.), Directions in
    Mathematical Quasicrystals, CRM Monograph Series, vol. 13, AMS,
    Providence, RI, 2000.

    <bibitem|BM2><em|M. Baake> <em|R. V. Moody>, Weighted Dirac combs with
    pure point diffraction, J. reine angew. Math. <with|font-series|bold|573>
    (2004), 61\U94.

    <bibitem|Bo><em|Z. I. Borevich> <em|I. R. Shafarevich>, Number Theory,
    Academic Press, New York, 1966.

    <bibitem|D><em|M. G. Darboux>, Sur un problme de gomtrie lmentaire,
    Bull. Sci. Math. <with|font-series|bold|2> (1878), 298\U304.

    <bibitem|DP><em|P. Dulio> <em|C. Peri>, On the geometric structure of
    lattice <math|U>-polygons, Discrete Math. <with|font-series|bold|307>
    (2007), 2330\U2340.

    <bibitem|G><em|R. J. Gardner>, Geometric Tomography, 2nd ed., Cambridge
    University Press, New York, 2006.

    <bibitem|GG><em|R. J. Gardner> <em|P. Gritzmann>, Discrete tomography:
    determination of finite sets by X-rays, Trans. Amer. Math. Soc.
    <with|font-series|bold|349> (1997), 2271\U2295.

    <bibitem|GG2><em|R. J. Gardner> <em|P. Gritzmann>, Uniqueness and
    complexity in discrete tomography, in: <nbsp><cite|HK>, pp. 85\U114.

    <bibitem|GGP><em|R. J. Gardner>, <em|P. Gritzmann> <em|D. Prangenberg>,
    On the computational complexity of reconstructing lattice sets from their
    X-rays, Discrete Math. <with|font-series|bold|202> (1999), 45\U71.

    <bibitem|GM><em|R. J. Gardner> <em|P. McMullen>, On Hammer's X-ray
    problem, J. London Math. Soc. (2) <with|font-series|bold|21> (1980),
    171\U175.

    <bibitem|Gr><em|P. Gritzmann>, On the reconstruction of finite lattice
    sets from their X-rays, in: Lecture Notes on Computer Science, eds. E.
    Ahronovitz \ C. Fiorio, Springer, London, 1997, pp. 19\U32.

    <bibitem|ga><em|F. Ghler>, Matching rules for quasicrystals: the
    composition-decomposition method, J. Non-Cryst. Solids
    <with|font-series|bold|153-154> (1993), 160\U164.

    <bibitem|HT><em|L. Hajdu> <em|R. Tijdeman>, Algebraic aspects of discrete
    tomography, J. reine angew. Math. <with|font-series|bold|534> (2001),
    119\U128.

    <bibitem|HK><em|G. T. Herman> <em|A. Kuba> (eds.), Discrete Tomography:
    Foundations, Algorithms, and Applications, Birkhuser, Boston, 1999.

    <bibitem|HK2><em|G. T. Herman> <em|A. Kuba> (eds.), Advances in Discrete
    Tomography and its Applications, Birkhuser, Boston, 2007.

    <bibitem|H><em|C. Huck>, Discrete Tomography of Delone Sets with
    Long-Range Order, Ph.D. thesis (Universitt Bielefeld), Logos Verlag,
    Berlin, 2007.

    <bibitem|H3><em|C. Huck>, A note on affinely regular polygons, European
    J. Combin. <with|font-series|bold|30> (2009), no. 2, 387\U395;
    <with|font-family|tt|arXiv:0801.3218v1 [math.MG]>

    <bibitem|H2><em|C. Huck>, Discrete tomography of icosahedral model sets,
    Acta Crystallogr. A <with|font-series|bold|65> (2009), 240\U248;
    <with|font-family|tt|arXiv:0705.3005v2 [math.MG]>

    <bibitem|H4><em|C. Huck>, On the existence of <math|U>-polygons of class
    <math|c\<geq\>4> in planar point sets, Discrete Math.
    <with|font-series|bold|309> (2009), 4977\U4981;
    <with|font-family|tt|arXiv:0811.3546v1 [math.MG]>

    <bibitem|H5><em|C. Huck>, Uniqueness in discrete tomography of Delone
    sets with long-range order, Discrete Comput. Geom.
    <with|font-series|bold|42> (2009), no. 4, 740\U758;
    <with|font-family|tt|arXiv:0711.4525v2 [math.MG]>

    <bibitem|ks><em|C. Kisielowski>, <em|P. Schwander>, <em|F. H. Baumann>,
    <em|M. Seibt>, <em|Y. Kim> <em|A. Ourmazd>, An approach to quantitative
    high-resolution transmission electron microscopy of crystalline
    materials, Ultramicroscopy <with|font-series|bold|58> (1995), 131\U155.

    <bibitem|Moody><em|R. V. Moody>, Model sets: a survey, in: From
    Quasicrystals to More Complex Systems, eds. F. Axel, F. Dnoyer J.-P.
    Gazeau, EDP Sciences, Les Ulis, and Springer, Berlin, 2000, pp. 145\U166;
    <with|font-family|tt|arXiv:math/0002020v1 [math.MG]>

    <bibitem|PABP><em|P. A. B. Pleasants>, Designer quasicrystals:
    cut-and-project sets with pre-assigned properties, in: <nbsp><cite|BM>,
    pp. 95\U141.

    <bibitem|PABP2><em|P. A. B. Pleasants>, Lines and planes in <math|2>- and
    <math|3>-dimensional quasicrystals, in: Coverings of Discrete
    Quasiperiodic Sets, eds. P. Kramer Z. Papadopolos, Springer Tracts in
    Modern Physics, vol. <with|font-series|bold|180>, Springer, Berlin, 2003,
    pp. 185\U225.

    <bibitem|Sa><em|R. Salem>, Algebraic Numbers and Fourier Analysis, D. C.
    Heath and Company, Boston, 1963.

    <bibitem|Schl2><em|M. Schlottmann>, Cut-and-project sets in locally
    compact Abelian groups, in: Quasicrystals and Discrete Geometry, ed. J.
    Patera, Fields Institute Monographs, vol. 10, AMS, Providence, RI, 1998,
    pp. 247\U264.

    <bibitem|Schl><em|M. Schlottmann>, Generalized model sets and dynamical
    systems, in: <nbsp><cite|BM>, pp. 143\U159.

    <bibitem|sk><em|P. Schwander>, <em|C. Kisielowski>, <em|M. Seibt>, <em|F.
    H. Baumann>, <em|Y. Kim> <em|A. Ourmazd>, Mapping projected potential,
    interfacial roughness, and composition in general crystalline solids by
    quantitative transmission electron microscopy, Phys. Rev. Lett.
    <with|font-series|bold|71> (1993), 4150\U4153.

    <bibitem|St><em|W. Steurer>, Twenty years of structure research on
    quasicrystals. Part I. Pentagonal, octagonal, decagonal and dodecagonal
    quasicrystals, Z. Kristallogr. <with|font-series|bold|219> (2004),
    391\U446.

    <bibitem|Wa><em|L. C. Washington>, Introduction to Cyclotomic Fields, 2nd
    ed., Springer, New York, 1997.
  </thebibliography>
</body>