<TeXmacs|1.99.7>

<style|<tuple|amsart|std-latex>>

<\body>
  <\hide-preamble>
    <new-theorem|theorem|Theorem>

    <new-theorem|conjecture|Conjecture>

    <new-theorem|corollary|Corollary>

    <new-theorem|lemma|Lemma>

    <new-theorem|proposition|Proposition>

    <new-theorem|problem|Problem>

    <new-theorem|question|Question>

    <new-theorem|example|Example>

    <new-theorem|definition|Definition>

    <assign|conv|<macro|<with|font-family|rm|conv>>>

    <assign|convSet|<macro|1|<with|font-family|rm|conv>{<arg|1>}>>

    <assign|intr|<macro|<with|font-family|rm|int>>>

    <assign|R|<macro|\<bbb-R\>>>

    <assign|Z|<macro|\<bbb-Z\>>>

    <assign|N|<macro|\<bbb-N\>>>

    <assign|calC|<macro|\<cal-C\>>>

    <assign|calE|<macro|\<cal-E\>>>

    <assign|calM|<macro|\<cal-M\>>>
  </hide-preamble>

  <doc-data|<doc-title|Projecting lattice polytopes without interior lattice
  points>|<doc-author|<author-data|<author-name|Benjamin
  Nill>|<author-email|bnill@math.uga.edu>>>|<doc-author|<author-data|<author-name|Gnter
  M. Ziegler>|<author-email|ziegler@math.tu-berlin.de>>>>

  <abstract-data|<\abstract>
    We show that up to unimodular equivalence there are only finitely many
    <math|d>-dimensional lattice polytopes without interior lattice points
    that do not admit a lattice projection onto a
    <math|<around|(|d-1|)>>-dimensional lattice polytope without interior
    lattice points. This was conjectured by Treutlein. As an immediate
    corollary, we get a short proof of a recent result of Averkov, Wagner &
    Weismantel, namely the finiteness of the number of maximal lattice
    polytopes without interior lattice points. Moreover, we show that in
    dimension four and higher some of these finitely many polytopes are not
    maximal as convex bodies without interior lattice points.
  </abstract>>

  <address*|Benjamin Nill|Department of Mathematics, University of Georgia,
  Athens, GA 30602, USA >

  <address*|Gnter M. Ziegler|Inst. Mathematics, MA 6-2, TU Berlin, 10623
  Berlin, Germany >

  <section|Introduction and main results>

  <subsection|Notation>

  A <em|lattice polytope> <math|P\<subset\><R><rsup|d>> is the convex hull of
  finitely many lattice points (in <math|<Z><rsup|d>>). We identify two
  lattice polytopes if they are <em|unimodularly equivalent>, i.e., there is
  a lattice-preserving affine isomorphism mapping them onto each other. All
  lattice polytopes considered here will be <em|<math|d>-polytopes>, i.e.,
  full-dimensional, <math|dim <around|(|P|)>=d>, . The volume of a lattice
  polytope is always taken with respect to the given lattice (here,
  <math|<Z><rsup|d>>), i.e., the volume of a fundamental parallepiped
  <math|<around|[|0,1|]><rsup|d>> is equal to <math|1>.

  In the geometry of numbers, convex bodies (compact convex sets) without
  lattice points are often called <em|lattice-free>. Sometimes, this
  terminology is extended to convex bodies without <em|interior> lattice
  points <cite|AWW10>. However, in the literature the term \Plattice-free
  polytopes\Q had already been used to denote <em|empty> lattice polytopes
  <cite|BK00> <cite|DO95> <cite|Kan99>, i.e., where the only lattice points
  are the vertices. In order to avoid these ambiguities we use in this note
  the following definition.

  <\definition>
    A convex body <math|P\<subset\><R><rsup|d>> is <em|hollow> if it does not
    contain any lattice points in its interior.
  </definition>

  A <math|0>-dimensional lattice polytope (a lattice point) is considered to
  be hollow. Important examples of hollow lattice polytopes are <em|Cayley
  polytopes> (lattice polytopes of lattice width one), i.e., lattice
  polytopes whose vertices lie on two adjacent lattice hyperplanes, i.e. on
  two hyperplanes spanned by lattice points with no lattice points strictly
  between.

  <subsection|The main theorem>

  Lattice polytopes without interior points are of interest in geometry of
  numbers, optimization and Ehrhart theory, e.g., <cite|Sca85> <cite|Seb99>
  <cite|Bar02> <cite|BN07> <cite|AWW10>. The only hollow <math|1>-polytope is
  <math|<around|[|0,1|]>>. Hollow polygons are either isomorphic to
  <math|<convSet|<around|(|0,0|)>,<around|(|2,0|)>,<around|(|0,2|)>>> or
  Cayley polytopes, see e.g. <cite|Rab89>. In dimension three, so far no
  complete classification exists, however recently some significant progress
  was made <cite|Tre08> <cite|Tre10> <cite|AWW09> <cite|AWW10>. A famous
  theorem by Howe <cite|Sca85> states that empty lattice <math|3>-polytopes
  are Cayley polytopes. In <cite|Tre08> Treutlein used this result to prove
  that hollow <math|3>-polytopes are either Cayley polytopes, project onto
  <math|<convSet|<around|(|0,0|)>,<around|(|2,0|)>,<around|(|0,2|)>>> or
  belong to a finite set of (not yet completely determined) exceptions. He
  conjectured that such a result should hold in any dimension. The
  confirmation of this conjecture is the main result of this paper.

  <\theorem>
    Any hollow lattice <math|d>-polytope <math|P> admits a lattice projection
    onto a hollow lattice <math|<around|(|d-1|)>>-polytope, except if
    <math|P> belongs to one of finitely many exceptions.<label|main>
  </theorem>

  The proof can be found in Section<nbsp><reference|proof>. It follows from
  combining the main results in two fundamental papers in the geometry of
  numbers: <cite|KL88> by Kannan and Lovsz, and <cite|Pik01> by Pikhurko.
  Roughly speaking, Kannan and Lovsz showed that if the volume of a hollow
  convex body is large enough, then it can be projected onto a
  lower-dimensional convex body where any lattice point lies arbitrarily
  close to the boundary. On the other hand, Pikhurko proved that such a
  lattice polytope has to be hollow.

  <subsection|Maximal hollow lattice polytopes>

  We say that a hollow lattice polytope is <em|maximal hollow> if it is not
  properly contained in a larger hollow lattice polytope. As a corollary of
  Theorem<nbsp><reference|main> we get a finiteness result, which was
  recently proven by Averkov, Wagner & Weismantel <cite-detail|AWW10|Theorem
  2.1>:

  <\corollary>
    There are only finitely many maximal hollow lattice <math|d>-polytopes.
    Moreover, if a hollow lattice polytope is one of the exceptions in
    Theorem<nbsp><reference|main>, then it is contained in a maximal hollow
    lattice polytope.<label|max>
  </corollary>

  <\proof>
    Any lattice <math|d>-polytope <math|P> that projects onto a hollow
    lattice polytope is necessarily also hollow. In particular, any such
    lattice polytope <math|P> is strictly contained in a bigger hollow
    lattice polytope, so it cannot be maximal. On the other hand, if a hollow
    lattice polytope is not contained in a maximal one, then it is contained
    in an infinite inclusion-chain of hollow lattice polytopes. Hence by
    Theorem<nbsp><reference|main> one of these bigger hollow lattice
    polytopes admits a lattice projection onto a lower-dimensional hollow
    lattice polytope.
  </proof>

  Let us denote the finite list of maximal hollow lattice <math|d>-polytopes
  by <math|<calE><rsub|d>>. The previous result shows that it is
  theoretically possible to completely `classify' all hollow lattice
  <math|d>-polytopes by determining <math|<calE><rsub|d<rprime|'>>> for
  <math|d<rprime|'>\<leq\>d>. We have <math|<calE><rsub|1>=\<emptyset\>> and
  <math|<calE><rsub|2>=<around|{|<convSet|<around|(|0,0|)>,<around|(|2,0|)>,<around|(|0,2|)>>|}>>.

  <vspace|1fn>For <math|<calE><rsub|3>> an important partial result was
  achieved in <cite|AWW10> using a relaxed notion of maximality. For this,
  let us compare being maximal <em|as a hollow lattice polytope> with being
  maximal <em|as a hollow convex body>. As was observed in <cite|Lov89>, a
  convex body is maximal as a hollow convex body if and only if it is a
  polytope such that each facet contains a lattice point in its relative
  interior. Let us denote by <math|<calM><rsub|d>> the set of lattice
  <math|d>-polytopes which are maximal as hollow convex bodies. Of course,
  <math|<calM><rsub|d>\<subseteq\><calE><rsub|d>>. We observe that equality
  holds for <math|d\<leq\>2>. However, for <math|d\<geq\>4> the inclusion
  <math|<calM><rsub|d>\<subsetneq\><calE><rsub|d>> is strict:

  <\theorem>
    For <math|d\<geq\>4>, there are lattice <math|d>-polytopes that are
    maximal hollow lattice polytopes but not maximal hollow convex
    bodies.<label|examples>
  </theorem>

  The proof is given in Section<nbsp><reference|examples-proof>. This leaves
  the case <math|d=3>, where it is believed but still open that there is no
  difference in these two notions of maximality.

  <\question>
    <with|font-family|rm|Is <math|<calM><rsub|3>=<calE><rsub|3>><nbsp>?<label|q>>
  </question>

  In <cite|Tre08> <cite|Tre10> it was shown that
  <math|<around|\||<calM><rsub|3>|\|>\<geq\>10>. Recently, in <cite|AWW10> it
  was proven that <math|<around|\||<calM><rsub|3>|\|>=12>. Therefore,
  confirming Question<nbsp><reference|q> would finish the classification of
  <math|<calE><rsub|3>>.

  <vspace|0.5fn>The method of proof of Theorem<nbsp><reference|main> yields
  an upper bound on the volume of a lattice polytope in
  <math|<calE><rsub|d>>. However, already for <math|d=3> this yields a number
  with <math|117> digits. Using the results of Pikhurko <cite|Pik01> we give
  a slightly more reasonable bound, to be proved at the end of
  Section<nbsp><reference|proof>:

  <\proposition>
    The volume of a lattice polytope in <math|<calE><rsub|3>> is at most
    <math|4106>.<label|bound>
  </proposition>

  We remark that the maximal volume of a lattice polytope in
  <math|<calM><rsub|3>> is<nbsp><math|6>. It is likely that the methods of
  Treutlein <cite|Tre08> <cite|Tre10> could eventually lead to a sharpening
  of this bound or even a proof of Question<nbsp><reference|q>.

  <subsection|Lattice width>

  One of the main motivation to study hollow lattice polytopes comes from the
  general interest in geometry of numbers and optimization in flatness and
  lattice width of convex bodies, see e.g.<nbsp><cite|Bar02>. The <em|lattice
  width> of a lattice polytope is defined as the infimum of <math|max
  <around|(|u<around|(|P|)>|)>-min <around|(|u<around|(|P|)>|)>> over all
  non-zero integer lattice directions <math|u>.

  <\corollary>
    The maximal lattice width of <math|d>-dimensional hollow lattice
    polytopes equals the maximal lattice width of lattice polytopes in
    <math|<calE><rsub|d<rprime|'>>> for <math|d<rprime|'>\<leq\>d>. Moreover,
    there are only finitely many <math|d>-dimensional hollow lattice
    polytopes whose lattice width is larger than that of any
    <math|<around|(|d-1|)>>-dimensional hollow lattice polytope.
  </corollary>

  <\proof>
    Let <math|P> be a <math|d>-dimensional hollow lattice polytope with a
    lattice projection onto a <math|<around|(|d-1|)>>-dimensional hollow
    lattice polytope <math|P<rprime|'>>. Then the lattice width of <math|P>
    is at most the lattice width of <math|P<rprime|'>>.
  </proof>

  The reader may compare this result with the conjecture on empty lattice
  <math|d>-simplices in <cite-detail|HZ00|Conj.<nbsp>7>, which was recently
  proven for <math|d\<leq\>4> <cite|BBBK09>.

  <section|Proofs of Theorem<nbsp><reference|main> and
  Proposition<nbsp><reference|bound>><label|proof>

  <no-indent>We will prove a slightly more general version of
  Theorem<nbsp><reference|main>. Throughout, let <math|P> be a lattice
  <math|d>-polytope. We denote the interior of <math|P> by
  <math|<intr><around|(|P|)>>. For a positive integer <math|s>, let us define
  as in <cite|Pik01>

  <\equation*>
    I<rsub|s><around|(|P|)>\<assign\><intr><around|(|P|)>\<cap\>s<Z><rsup|d>.
  </equation*>

  We say that a lattice polytope <math|P> is <em|<math|s>-hollow>, if
  <math|I<rsub|s><around|(|P|)>=\<emptyset\>>.

  <\theorem>
    Any <math|s>-hollow lattice <math|d>-polytope <math|P> admits a lattice
    projection onto an <math|s>-hollow <math|<around|(|d-1|)>>-dimensional
    lattice polytope, except if <math|P> belongs to one of finitely many
    exceptions. The volume of any such exceptional <math|s>-hollow lattice
    polytope is bounded by

    <\equation*>
      s<rsup|d>*<around*|(|8*<around|(|d-1|)>*<around|(|8*s+7|)><rsup|2<rsup|2*d-1>>+1|)><rsup|d>.
    </equation*>

    <label|main2>
  </theorem>

  In particular, as in the proof of Corollary<nbsp><reference|max>, we get
  the following finiteness result, which was recently proven in <cite|AWW10>:

  <\corollary>
    There are only finitely many maximal <math|s>-hollow lattice
    <math|d>-polytopes.
  </corollary>

  In order to prove Theorem<nbsp><reference|main2> we need the following
  notion, which was introduced in <cite|KL88>.

  <\definition>
    A point <math|w\<in\><intr><around|(|P|)>> is
    <em|<math|\<delta\>>-central> for some <math|\<delta\>\<gtr\>0> if for
    every <math|y\<in\>P> there is some <math|z\<in\>P> such that
    <math|z-w=\<delta\>*<around|(|z-y|)>>, i.e.,
    <math|z-w=-<frac|\<delta\>|1-\<delta\>>*<around|(|y-w|)>>.
  </definition>

  Here is one of the main results in <cite|KL88>, Corollary (3.8), in a
  version for lattice polytopes.

  <\theorem>
    [Kannan & Lovsz 1988 <cite|KL88>] Let <math|P\<subset\><R><rsup|d>> be
    an <math|s>-hollow lattice <math|d>-polytope. Let
    <math|\<Delta\><rsub|1>,\<ldots\>,\<Delta\><rsub|d>> be real numbers with
    <math|0=\<Delta\><rsub|0>\<less\>\<Delta\><rsub|1>\<less\>\<cdots\>\<less\>\<Delta\><rsub|d>\<leq\>1>.
    Then there is an <math|i\<in\><around|{|0,\<ldots\>,d-1|}>> and a
    sublattice <math|\<Gamma\>\<subseteq\>s<Z><rsup|d>> of rank <math|i> such
    that for the projection <math|\<pi\><space|0.27em>:<space|0.27em><R><rsup|d>\<to\><R><rsup|d>/<around|(|\<Gamma\>\<otimes\><rsub|<Z>><R>|)>>
    the following two properties hold:

    <\enumerate>
      <item><math|\<pi\><around|(|P|)>> does not contain points in
      <math|I<rsub|s><around|(|\<pi\><around|(|P|)>|)>> that are
      <math|\<delta\>>-central with <math|\<delta\>\<gtr\>\<Delta\><rsub|i>>,

      <item>the volume of <math|\<pi\><around|(|P|)>> (w.r.t.
      <math|\<pi\><around|(|<Z><rsup|d>|)>>) is at most
      <math|s<rsup|d-i>/<around|(|\<Delta\><rsub|i+1>-\<Delta\><rsub|i>|)><rsup|d-i>>.
    </enumerate>

    <label|theorem-kl>
  </theorem>

  <\proof>
    We want to apply <cite-detail|KL88|Corollary (3.8)> to the
    <math|s>-hollow lattice polytope <math|P>. Since this result is only
    formulated for convex bodies that contain no points in the lattice
    <math|s<Z><rsup|d>>, we choose a fixed point
    <math|x\<in\><intr><around|(|P|)>> and approximate <math|P> by
    <math|P<rsub|t>\<assign\>t*<around|(|P-x|)>+x> for
    <math|0\<less\>t\<less\>1>. Let <math|b<rsub|1>,\<ldots\>,b<rsub|d>> be
    the reduced basis (see <cite-detail|KL88|Definition (3.3)>) for the
    lattice <math|s<Z><rsup|d>> with respect to the centrally symmetric
    convex body <math|P<rsub|t>-P<rsub|t>=t*<around|(|P-P|)>>. By definition,
    this basis is independent of the choice of<nbsp><math|t>. For
    <math|P<rsub|t>> it is shown in <cite-detail|KL88|proof of
    Cor.<nbsp>(3.8)> that there is an <math|i\<in\><around|{|0,\<ldots\>,d-1|}>>
    such that the projection along the subspace spanned by
    <math|b<rsub|1>,\<ldots\>,b<rsub|i>> (for <math|i\<gtr\>0>; respectively,
    along <math|<around|{|0|}>> for <math|i=0>) satisfies the two desired
    conditions. Since we may assume that <math|i> is the same for infinitely
    many <math|t> arbitrarily close to <math|1>, the statement follows.
  </proof>

  We apply the theorem to the numbers

  <\equation*>
    \<Delta\><rsub|j>\<assign\><frac|1|8*<around|(|d-j|)>*<around|(|8*s+7|)><rsup|2<rsup|2*<around|(|d-j|)>+1>>+1>
  </equation*>

  with <math|j=1,\<ldots\>,d>. Note that <math|0\<less\>\<Delta\><rsub|1>\<less\>\<cdots\>\<less\>\<Delta\><rsub|d>=1>.

  In the case <math|i=0>, we observe from (2) that the volume of
  <math|\<pi\><around|(|P|)>=P> is bounded by
  <math|s<rsup|d>/\<Delta\><rsub|1><rsup|d>>, a function in <math|d>. Hence,
  a result of Lagarias and the second author <cite-detail|LZ91|Thm.<nbsp>2>
  implies that there are only finitely many lattice polytopes of at most this
  volume.

  So, let <math|i\<in\><around|{|1,\<ldots\>,d-1|}>>. We may assume that the
  <math|<around|(|d-i|)>>-dimensional lattice polytope
  <math|\<pi\><around|(|P|)>> is not <math|s>-hollow. In order to get a
  contradiction, we use <cite-detail|Pik01|Theorem 4>. For this, let us
  recall the following definition:

  <\definition>
    <\with|font-family|rm>
      The <em|coefficient of asymmetry> of an interior point <math|w> of
      <math|P> is defined as

      <\equation*>
        <text|ca><around|(|w,P|)>\<assign\>max<rsub|<around|\||y|\|>=1>
        <frac|max <around|{|\<lambda\><space|0.27em>\|<space|0.27em>w+\<lambda\>*y\<in\>P|}>|max
        <around|{|\<lambda\><space|0.27em>\|<space|0.27em>w-\<lambda\>*y\<in\>P|}>>
      </equation*>
    </with>
  </definition>

  This notion is just a variant of the above definition of centrality: An
  interior point <math|w> of <math|P> with coefficient of asymmetry <math|c>
  is <math|<frac|1|c+1>>-central.

  <\theorem>
    [Pikhurko 2001 <cite|Pik01>] Let <math|P<rprime|'>\<subset\><R><rsup|k>>
    be a <math|k>-dimensional lattice polytope with interior points in
    <math|s<Z><rsup|k>>. Then there is a point
    <math|w\<in\>I<rsub|s><around|(|P<rprime|'>|)>> with

    <\equation*>
      <math-up|ca><around|(|w,P<rprime|'>|)>\<leq\>8*k*<around|(|8*s+7|)><rsup|2<rsup|2*k+1>>-1.
    </equation*>

    In particular, <math|w> is <math|\<delta\>>-central for

    <\equation*>
      \<delta\>=<frac|1|8*k*<around|(|8*s+7|)><rsup|2<rsup|2*k+1>>>.
    </equation*>

    <label|pik>
  </theorem>

  We apply Pikhurko's theorem for <math|P<rprime|'>\<assign\>\<pi\><around|(|P|)>>
  and <math|k\<assign\>d-i>. Hence the point
  <math|w\<in\>I<rsub|s><around|(|\<pi\><around|(|P|)>|)>> is
  <math|\<delta\>>-central with <math|\<delta\>\<gtr\>\<Delta\><rsub|i>>, a
  contradiction to condition (1). This finishes the proof of
  Theorem<nbsp><reference|main2>.

  <math|<htab|0pt>> <math|\<Box\>>

  <vspace|2fn>Finally, let us give the proof of
  Proposition<nbsp><reference|bound>. Here <math|d=3> and <math|s=1>. From
  the above proof we see that we have to sharpen
  Theorem<nbsp><reference|pik>. Using Pikhurko's results, we get the
  following lemma.

  <\lemma>
    Let <math|P<rprime|'>> be a lattice polygon with interior lattice points.
    Then there is a point <math|w\<in\>I<rsub|1><around|(|P<rprime|'>|)>>
    with

    <\equation*>
      <math-up|ca><around|(|w,P<rprime|'>|)>\<leq\><frac|2|0.124904>-1
    </equation*>
  </lemma>

  <\proof>
    Let <math|P<rprime|'>> be a lattice polygon with interior lattice points.
    Let us choose a triangle <math|S\<subset\>P<rprime|'>> of maximal area.
    We may assume that the vertices <math|v<rsub|0>,v<rsub|1>,v<rsub|2>> of
    <math|S> are also vertices of <math|P<rprime|'>> and that
    <math|P<rprime|'>\<subseteq\>(-2)S+<around|(|v<rsub|0>+v<rsub|1>+v<rsub|2>|)>>,
    see <cite|Pik01>. We consider three cases.

    <\enumerate>
      <item>If <math|S> has no lattice points except its vertices, then it is
      unimodular equivalent to the unimodular triangle
      <math|<convSet|<around|(|0,0|)>,<around|(|1,0|)>,<around|(|0,1|)>>>.
      Therefore, <math|P<rprime|'>> is contained in
      (<math|-2)S+<around|(|1,1|)>>, which is hollow, a contradiction.

      <item>If <math|S> is hollow but has a lattice point in the interior of
      an edge, then by the classification of hollow lattice polygons we may
      assume that <math|S> is of one of the following:

      <\enumerate>
        <item><math|S=<convSet|<around|(|0,0|)>,<around|(|2,0|)>,<around|(|0,2|)>>>.
        In this case, by going through the possible lattice subpolygons of
        <math|(-2)S+<around|(|2,2|)>> one checks that there always is an
        interior lattice point <math|w> of <math|P<rprime|'>> with
        <with|font-family|rm|ca><math|<around|(|w,P<rprime|'>|)>\<leq\>3>.

        <item><math|S=<convSet|<around|(|0,0|)>,<around|(|k,0|)>,<around|(|0,1|)>>>
        for some <math|k\<geq\>2>. The facts that <math|P<rprime|'>> is not
        hollow and that <math|S> has maximal area imply that
        <math|P<rprime|'>=<convSet|<around|(|0,0|)>,<around|(|k,0|)>,<around|(|0,1|)>,<around|(|k,-1|)>>>.
        In this case, <math|<around|(|0,<around|\<lfloor\>|k/2|\<rfloor\>>|)>>
        is an interior lattice point <math|w> of <math|P<rprime|'>> with
        <with|font-family|rm|ca><math|<around|(|w,P<rprime|'>|)>\<leq\>2>.
      </enumerate>

      <item>If <math|S> has interior lattice points, then we can read off
      from <cite-detail|Pik01|Table<nbsp>1> (`guaranteed' lower bound for
      <math|\<beta\><around|(|2,1|)>>) that there is an interior lattice
      point <math|w> with <with|font-family|rm|ca><math|<around|(|w,S|)>\<leq\><frac|1|0.124904>-1>.
      Therefore, <cite-detail|Pik01|Lemma 3> yields that
      <with|font-family|rm|ca><math|<around|(|w,P<rprime|'>|)>\<leq\>2<math-up|ca><around|(|w,S|)>+2-1=<frac|2|0.124904>-1\<approx\>15.012>.
    </enumerate>
  </proof>

  We define <math|\<Delta\><rsub|1>\<assign\>0.124903/2>, and choose
  <math|\<Delta\><rsub|1>\<less\>\<Delta\><rsub|2>\<less\>1/3\<less\>\<Delta\><rsub|3>=1>.
  Then the above proof yields <math|1/<around|(|\<Delta\><rsub|1>|)><rsup|3>\<approx\>4105.55>
  as the improved bound on the volume of a hollow lattice <math|3>-polytope
  <math|P> in the case <math|i=0>. This finishes the proof of
  Proposition<nbsp><reference|bound>.<math|<htab|0pt>\<Box\>>

  <section|Proof of Theorem<nbsp><reference|examples>><label|examples-proof>

  <no-indent>In the following we describe for each <math|d\<ge\>4> a
  <math|d>-dimensional lattice polytope <math|\<Delta\><around|(|d|)><rsub|I>>
  that is <em|hollow> (no interior lattice point), is maximal as a hollow
  lattice polytope (it is not properly contained in a hollow lattice
  polytope), but is not maximal as a hollow convex body (it is properly
  contained in the hollow simplex <math|\<Delta\><around|(|d|)>>).

  <\definition>
    For <math|d\<ge\>3> let <math|\<Delta\><around|(|d|)>> be the hollow
    simplex given by<label|delta-def>

    <eqnarray*|<tformat|<table|<row|<cell|\<Delta\><around|(|d|)>>|<cell|\<assign\>>|<cell|<around*|{|x\<in\><R><rsup|d>:x<rsub|i>\<ge\>0*<with|font-family|rm|f*o*r>*1\<le\>i\<le\>d,|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<tformat|<table|<row|<cell|<around*|\<nobracket\>|<hphantom|<around*|{|x\<in\><R><rsup|d>:|\<nobracket\>>><frac|x<rsub|1>|2>+<frac|x<rsub|2>|4>+\<ldots\>+<frac|x<rsub|d-3>|2<rsup|d-3>>+<frac|x<rsub|d-2>|2<rsup|d-2>>+<frac|x<rsub|d-1>|2<rsup|d-1>-1>+<frac|x<rsub|d>|2<rsup|d-1>+1+\<alpha\>>\<le\>1|}>>|<cell|>|<cell|>>|<row|<cell|>|<cell|=>|<cell|<conv><around|{|0,2*e<rsub|1>,4*e<rsub|2>,\<ldots\>,2<rsup|d-2>*e<rsub|d-2>,<around|(|2<rsup|d-1>-1|)>*e<rsub|d-1>,<around|(|2<rsup|d-1>+1+\<alpha\>|)>*e<rsub|d>|}>,>>>>>>>>>

    where <math|\<alpha\>\<assign\><frac|1|2<rsup|d-2>-1>\<gtr\>0>. Note that
    this is <em|not> a lattice simplex for <math|d\<gtr\>3>, i.e.

    when <math|\<alpha\>\<less\>1>.
  </definition>

  <\theorem>
    <label|thm:Delta>For <math|d\<ge\>4> the integer hull
    <math|\<Delta\><around|(|d|)><rsub|I>\<assign\><conv><around|(|\<Delta\><around|(|d|)>\<cap\><Z><rsup|d>|)>>
    is given by

    <eqnarray*|<tformat|<table|<row|<cell|\<Delta\><around|(|d|)><rsub|I>>|<cell|=>|<cell|<around*|{|x\<in\><R><rsup|d>:x<rsub|i>\<ge\>0*<with|font-family|rm|f*o*r>*1\<le\>i\<le\>d,|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<tformat|<table|<row|<cell|<hphantom|<around*|{|x\<in\><R><rsup|d>:|\<nobracket\>>><frac|x<rsub|1>|2>+<frac|x<rsub|2>|4>+\<ldots\>+<frac|x<rsub|d-3>|2<rsup|d-3>>+<frac|x<rsub|d-2>|2<rsup|d-2>>+<frac|x<rsub|d-1>|2<rsup|d-1>-1>+<frac|x<rsub|d>|2<rsup|d-1>+1+\<alpha\>>\<le\>1,>|<cell|>|<cell|>>|<row|<cell|>|<cell|>|<cell|<tformat|<table|<row|<cell|<around*|\<nobracket\>|<hphantom|<around*|{|x\<in\><R><rsup|d>:|\<nobracket\>>><frac|x<rsub|1>|2>+<frac|x<rsub|2>|4>+\<ldots\>+<frac|x<rsub|d-3>|2<rsup|d-3>>+<frac|2*x<rsub|d-2>+x<rsub|d-1>+x<rsub|d>|2<rsup|d-1>+1><space|2em>\<le\>1|}>>|<cell|>|<cell|>>|<row|<cell|>|<cell|=>|<cell|<conv>{0,2*e<rsub|1>,4*e<rsub|2>,\<ldots\>,2<rsup|d-2>*e<rsub|d-2>,<around|(|2<rsup|d-1>-1|)>*e<rsub|d-1>,>>|<row|<cell|>|<cell|>|<cell|<hphantom|<conv>{><around|(|2<rsup|d-1>+1|)>*e<rsub|d>,e<rsub|d-1>+2<rsup|d-1>*e<rsub|d>,e<rsub|d-2>+<around|(|2<rsup|d-1>-1|)>*e<rsub|d>}.>>>>>>>>>>>>>

    This polytope is a <math|<around|(|d-3|)>>-fold pyramid over a triangular
    prism.

    This lattice polytope is hollow. It is not contained properly in any
    larger <math|d>-dimensional lattice polytope, but it is properly
    contained in <math|\<Delta\><around|(|d|)>>.
  </theorem>

  <\proof>
    One first checks that the vertex description and the inequality
    description given in the definition of
    <math|\<Delta\><around|(|d|)><rsub|I>> above are equivalent.

    If one takes the inequality system given for
    <math|\<Delta\><around|(|d|)><rsub|I>> as the definition, then it is
    clear that <math|\<Delta\><around|(|d|)><rsub|I>> arises from
    <math|\<Delta\><around|(|d|)>> by a hyperplane cut that cuts off the
    last, non-integral vertex <math|<around|(|2<rsup|d-1>+1+\<alpha\>|)>*e<rsub|d>>.
    The hyperplane cut goes through the <math|d-3> vertices
    <math|2*e<rsub|1>,4*e<rsub|2>,\<ldots\>,2<rsup|d-3>*e<rsub|d-3>>, while
    it cuts trough the tetrahedron spanned by the other <math|4> vertices.
    This shows that <math|\<Delta\><around|(|d|)><rsub|I>> is a
    <math|<around|(|d-3|)>>-fold pyramid over a tetrahedron with a vertex cut
    off, that is, a triangular prism.

    Using this combinatorial description one easily checks that the vertices
    of this polytope <math|\<Delta\><around|(|d|)><rsub|I>> are indeed as
    listed in Theorem<nbsp><reference|thm:Delta>; thus, in particular,
    <math|\<Delta\><around|(|d|)><rsub|I>> is a lattice polytope.

    <vspace|1fn>Next we check that <math|\<Delta\><around|(|d|)><rsub|I>> is
    indeed the full integer hull of <math|\<Delta\><around|(|d|)>>, that is,
    that there are no integer points that would satisfy

    <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|x<rsub|i>\<ge\>0<with|font-family|rm|<space|1em>f*o*r>1\<le\>i\<le\>d,>>|<row|<cell|<vspace*|2pt>>|<cell|>|<cell|<tformat|<table|<row|<cell|<frac|x<rsub|1>|2>+<frac|x<rsub|2>|4>+\<ldots\>+<frac|x<rsub|d-3>|2<rsup|d-3>>+<frac|x<rsub|d-2>|2<rsup|d-2>>+<frac|x<rsub|d-1>|2<rsup|d-1>-1>+<frac|x<rsub|d>|2<rsup|d-1>+1+\<alpha\>>\<le\>1,>|<cell|>|<cell|>>|<row|<cell|>|<cell|>|<cell|<frac|x<rsub|1>|2>+<frac|x<rsub|2>|4>+\<ldots\>+<frac|x<rsub|d-3>|2<rsup|d-3>>+<frac|2*x<rsub|d-2>+x<rsub|d-1>+x<rsub|d>|2<rsup|d-1>+1><space|2em>\<gtr\>1.>>>><eq-number><label|eqn:1><label|eqn:2>>>>>>

    Indeed, the inequality \P<math|x<rsub|d>\<ge\>0>\Q is not needed for
    this. For the proof we rewrite the last two inequalities. We multiply
    <reference|eqn:1> by <math|-<around|(|2<rsup|d-1>+1+\<alpha\>|)>> as

    <\equation>
      -<big|sum><rsub|i=1><rsup|d-3><around|(|2<rsup|d-1>+1+\<alpha\>|)>*<frac|x<rsub|i>|2<rsup|i>>-<around|(|2<rsup|d-1>+1+\<alpha\>|)>*<frac|x<rsub|d-2>|2<rsup|d-2>>-<around|(|2<rsup|d-1>+1+\<alpha\>|)>*<frac|x<rsub|d-1>|2<rsup|d-1>-1>-x<rsub|d>\<ge\>-<around|(|2<rsup|d-1>+1+\<alpha\>|)><label|eqn:3>
    </equation>

    and we multiply the strict inequality <reference|eqn:2> by
    <math|2<rsup|d-1>+1>,

    <\equation*>
      <big|sum><rsub|i=1><rsup|d-3><around|(|2<rsup|d-1>+1|)>*<frac|x<rsub|i>|2<rsup|i>>+2*x<rsub|d-2>+x<rsub|d-1>+x<rsub|d>\<gtr\>2<rsup|d-1>+1,
    </equation*>

    and then convert it into the equivalent (with respect to integer
    solvability) nonstrict inequality

    <\equation>
      <big|sum><rsub|i=1><rsup|d-3><around|(|2<rsup|d-1>+1|)>*<frac|x<rsub|i>|2<rsup|i>>+2*x<rsub|d-2>+x<rsub|d-1>+x<rsub|d>\<ge\>2<rsup|d-1>+1+<frac|1|2<rsup|d-3>>.<label|eqn:4>
    </equation>

    Adding the two inequalities <reference|eqn:3> and <reference|eqn:4> we
    obtain

    <\equation*>
      <big|sum><rsub|i=1><rsup|d-3>(-\<alpha\>)<frac|x<rsub|i>|2<rsup|i>>+<frac|-1-\<alpha\>|2<rsup|d-2>>*x<rsub|d-2>+<frac|-2-\<alpha\>|2<rsup|d-1>-1>*x<rsub|d-1>\<ge\><frac|1|2<rsup|d-3>>-\<alpha\>.
    </equation*>

    Clearly, for <math|d\<ge\>4>, that is when
    <math|<frac|1|2<rsup|d-3>>-\<alpha\>=<frac|1|2<rsup|d-3>>-<frac|1|2<rsup|d-2>-1>\<gtr\>0>,
    this cannot be satisfied when <math|x<rsub|1>,\<ldots\>,x<rsub|d-1>> are
    nonnegative. <vspace|1fn>

    Finally, we show that <math|\<Delta\><around|(|d|)><rsub|I>> is maximal
    as a hollow lattice polytope. For this, we check that out of the
    <math|d+2> facets the first <math|d+1> contain relatively interior
    points, which are <math|<with|math-font|Bbb*|1>-e<rsub|1>,<with|math-font|Bbb*|1>-e<rsub|2>,\<ldots\>,<with|math-font|Bbb*|1>-e<rsub|d>>
    for the first <math|d> of them and <math|<with|math-font|Bbb*|1>>
    (denoting the all-ones vector) for the next to last one. If an additional
    vertex were added to <math|\<Delta\><around|(|d|)><rsub|I>> that is
    <em|beyond> any of these (in the sense of Grnbaum <cite|Gr1-2>
    <cite|Z35>), then this automatically results in an interior lattice
    point. Thus any additional vertex must be beyond the last facet, but
    beneath all the other facets (or on their hyperplanes). However, there is
    no such integral point, because the first <math|d+1> inequalities define
    <math|\<Delta\><around|(|d|)>>, and all integral points of this simplex
    lie in<nbsp><math|\<Delta\><around|(|d|)><rsub|I>>.
  </proof>

  <with|font-size|0.84| >

  <subsubsection*|Acknowledgements.>

  <with|font-size|0.84|The simplices <math|\<Delta\><around|(|d|)>> with
  <math|\<alpha\>=0> appear in the diploma thesis <cite|dipl-Myrach> as
  examples of simplices that are maximal as hollow lattice simplices, but not
  as hollow convex bodies; note that lattice simplices are maximal hollow
  lattice polytopes if and only if they are maximal hollow convex bodies.
  Thanks to Gregor Myrach for valuable discussions and to Jaron Treutlein for
  helpful comments. Lattice point computations using
  <with|font-family|tt|polymake> <cite|polymake_lattice> were crucial help
  for Section<nbsp><reference|examples-proof>. This paper was finished when
  the first author stayed at Institut Mittag-Leffler during the program
  \PAlgebraic Geometry with a view towards applications\Q. The second author
  was supported by DFG, Research Training Group \PMethods for Discrete
  Structures\Q.>

  <\thebibliography|10>
    <bibitem|AWW09><with|font-shape|small-caps|K.<nbsp>Andersen,
    C.<nbsp>Wagner, and R.<nbsp>Weismantel>, <with|font-shape|italic|Maximal
    integral simplices with no interior integer points>. <newblock>Preprint,
    May 2009, 16<nbsp>pages, <with|font-family|tt|arXiv:0904.2108>.

    <bibitem|AWW10><with|font-shape|small-caps|G.<nbsp>Averkov,
    C.<nbsp>Wagner, and R.<nbsp>Weismantel>, <with|font-shape|italic|Maximal
    lattice-free polyhedra: finiteness and an explicit description in
    dimension three>. <newblock>Preprint, Oct.<nbsp>2010, 23<nbsp>pages,
    <with|font-family|tt|arXiv:1010.1077>.

    <bibitem|BK00><with|font-shape|small-caps|I.<nbsp>Brny and J.-M.
    Kantor>, <with|font-shape|italic|On the number of lattice free
    polytopes>, Europ. J. Combinatorics, 21 (2000), pp.<nbsp>103\U110.

    <bibitem|BBBK09><with|font-shape|small-caps|M.<nbsp>Barile,
    D.<nbsp>Bernardi, A.<nbsp>Borisov, and J.-M. Kantor>,
    <with|font-shape|italic|On empty lattice simplices in dimension 4>.
    <newblock>Preprint Dec.<nbsp>2009, 8<nbsp>pages,
    <with|font-family|tt|arXiv:0912.5310>.

    <bibitem|Bar02><with|font-shape|small-caps|A.<nbsp>Barvinok>,
    <with|font-shape|italic|A Course in Convexity>, vol.<nbsp>54 of Graduate
    Studies in Math., Amer. Math. Soc., Providence, RI, 2002.

    <bibitem|BN07><with|font-shape|small-caps|V.<nbsp>Batyrev and
    B.<nbsp>Nill>, <with|font-shape|italic|Multiples of lattice polytopes
    without interior lattice points>, Moscow Math. J., 7 (2007),
    pp.<nbsp>195\U207.

    <bibitem|DO95><with|font-shape|small-caps|M.<nbsp>Deza and S.<nbsp>Onn>,
    <with|font-shape|italic|Lattice-free polytopes and their diameter>,
    Discrete Comput. Geometry, 13 (1995), pp.<nbsp>59\U75.

    <bibitem|Gr1-2><with|font-shape|small-caps|B.<nbsp>Grnbaum>,
    <with|font-shape|italic|Convex Polytopes>, vol.<nbsp>221 of Graduate
    Texts in Math., Springer-Verlag, New York, 2003. <newblock>Second ed.
    prepared by V. Kaibel, V. Klee and G. M. Ziegler (original edition:
    Interscience, London 1967).

    <bibitem|HZ00><with|font-shape|small-caps|C.<nbsp>Haase and G.<nbsp>M.
    Ziegler>, <with|font-shape|italic|On the maximal width of empty lattice
    simplices>, Europ. J. Combinatorics, 21 (2000), pp.<nbsp>111\U119.

    <bibitem|polymake_lattice><with|font-shape|small-caps|M.<nbsp>Joswig,
    B.<nbsp>Lorenz, and A.<nbsp>Paffenholz>,
    <with|font-shape|italic|<with|font-family|tt|polymake> and lattice
    polytopes>, in Proc. 21st Int. Conf. \PFormal Power Series and Algebraic
    Combinatorics\Q (FPSAC), Hagenberg, July 2009, C.<nbsp>Krattenthaler,
    V.<nbsp>Strehl, and M.<nbsp>Kauers, eds., Discrete Math. & Theor.
    Computer Science (DMTCS), 2009, pp.<nbsp>491\U502.

    <bibitem|KL88><with|font-shape|small-caps|R.<nbsp>Kannan and
    L.<nbsp>Lovsz>, <with|font-shape|italic|Covering minima and
    lattice-point-free convex bodies>, Annals Math. (2), 128 (1988),
    pp.<nbsp>577\U602.

    <bibitem|Kan99><with|font-shape|small-caps|J.-M. Kantor>,
    <with|font-shape|italic|On the width of lattice-free simplices>,
    Compositio Math., 118 (1999), pp.<nbsp>235\U241.

    <bibitem|LZ91><with|font-shape|small-caps|J.<nbsp>C. Lagarias and
    G.<nbsp>M. Ziegler>, <with|font-shape|italic|Bounds for lattice polytopes
    containing a fixed number of interior points in a sublattice>, Canadian
    J. Math., 43 (1991), pp.<nbsp>1022\U1035.

    <bibitem|Lov89><with|font-shape|small-caps|L.<nbsp>Lovsz>,
    <with|font-shape|italic|Geometry of numbers and integer programming>, in
    \PMathematical Programming\Q (Tokyo, 1988), vol.<nbsp>6 of Math. Appl.
    (Japanese Ser.), SCIPRESS, Tokyo, 1989, pp.<nbsp>177\U201.

    <bibitem|dipl-Myrach><with|font-shape|small-caps|G.<nbsp>Myrach>,
    <with|font-shape|italic|Gitterpunktfreie Gittersimplices>, Diplomarbeit,
    TU Berlin, 2010. <newblock>(in German).

    <bibitem|Pik01><with|font-shape|small-caps|O.<nbsp>Pikhurko>,
    <with|font-shape|italic|Lattice points in lattice polytopes>,
    Mathematika, 48 (2001), pp.<nbsp>15\U24.

    <bibitem|Rab89><with|font-shape|small-caps|S.<nbsp>Rabinowitz>,
    <with|font-shape|italic|A census of convex lattice polygons with at most
    one interior lattice point>, Ars Combinatorica, 28 (1989),
    pp.<nbsp>83\U96.

    <bibitem|Sca85><with|font-shape|small-caps|H.<nbsp>E. Scarf>,
    <with|font-shape|italic|Integral polyhedra in three space>, Math.
    Operations Research, 10 (1985), pp.<nbsp>403\U438.

    <bibitem|Seb99><with|font-shape|small-caps|A.<nbsp>Seb>,
    <with|font-shape|italic|An introduction to empty lattice simplices>, in
    \PInteger Programming and Combinatorial Optimization\Q (Graz, 1999),
    vol.<nbsp>1610 of Lecture Notes in Comput. Science, Springer, Berlin,
    1999, pp.<nbsp>400\U414.

    <bibitem|Tre08><with|font-shape|small-caps|J.<nbsp>Treutlein>,
    <with|font-shape|italic|<math|3>-dimensional lattice polytopes without
    interior lattice points>. <newblock>Sept.<nbsp> 2008, 12<nbsp>pages,
    <with|font-family|tt|arXiv:0809.1787>.

    <bibitem|Tre10><leavevmode><vrule>height 2pt depth -1.6pt width 23pt,
    <with|font-shape|italic|Birationale Eigenschaften generischer
    Hyperflchen in algebraischen Tori>, PhD thesis, Universitt Tbingen,
    2010.

    <bibitem|Z35><with|font-shape|small-caps|G.<nbsp>M. Ziegler>,
    <with|font-shape|italic|Lectures on Polytopes>, vol.<nbsp>152 of Graduate
    Texts in Mathematics, Springer-Verlag, New York, 1995. <newblock>Revised
    edition, 1998; seventh updated printing 2007.
  </thebibliography>
</body>