<TeXmacs|1.99.7>

<style|<tuple|amsart|std-latex>>

<\body>
  <\hide-preamble>
    <assign|R|<macro|\<bbb-R\>>>

    <new-theorem|thm|Theorem>

    <new-theorem|lemm|Lemma>

    <new-theorem|cor|Corollary>

    <new-theorem|remark|Remark>
  </hide-preamble>

  <doc-data|<doc-title|On the Positivstellensatz for Enveloping
  Algebras>|<doc-author|<author-data|<author-name|J.
  Nahas>|<author-email|joules.nahas@epfl.ch>|<author-note|The author would
  like to thank Mihai Putinar for introducing him to this subject, and for
  many fruitful discussions. He would also like to thank the referee for
  valuable comments that helped to improve this work.>>>>

  <abstract-data|<abstract-msc|47L60| 14P10>|<abstract-keywords|Positivstellensatz|
  enveloping algebras>|<\abstract>
    <no-indent>We use Reznick's Theorem for positive homogeneous polynomials
    to prove an elliptic regularity result for representations of enveloping
    algebras of Lie algebras. This allows us to relax a technical condition
    for a sum of squares decomposition for representations of these algebras.
  </abstract>>

  \ <address*|J. Nahas|cole Polytechnique Fdrale de Lausanne<next-line>MA
  B1 487<next-line>CH-1015 Lausanne>

  <section|Introduction>

  For a *-algebra <math|\<cal-A\>>, we say that <math|x\<in\>\<cal-A\>> is a
  sum of squares if there exist <math|y<rsub|1>,\<ldots\>,y<rsub|k>\<in\>\<cal-A\>>
  so that

  <\equation>
    <label|smf-dfn>x=<big|sum><rsub|i=1><rsup|k>y<rsub|i><rsup|\<ast\>>*y<rsub|i>.
  </equation>

  In a representation of <math|\<cal-A\>> on a Hilbert space
  <math|<around|(|\<cal-H\>,|\<langle\>>\<cdot\>,\<cdot\><around|\<rangle\>||)>>,
  it is easy to see from <eqref|smf-dfn> that <math|x> would be a positive
  operator. Because of this, results that classify elements of algebras as a
  sum of squares are called <em|positivstellensatz>. For a review of some of
  the excellent work done in this area, we refer to <cite|MR2389626> and
  references therein. Positivstellenstze are particularly useful because of
  their relation to optimization problems. In the case of algebras of
  polynomials, sums of squares decompositions are used to extremize
  polynomials in works such as <cite|PAR00> and <cite|MR1814045>. These
  methods have been adapted (for example in <cite|pir-nav-aci>, and
  <cite|JC>) to the corresponding problem for noncommutative algebras: given
  <math|x\<in\>\<cal-A\>>, for representations <math|\<Phi\>> of
  <math|\<cal-A\>> on a Hilbert space <math|<around|(|\<cal-H\>,|\<langle\>>\<cdot\>,\<cdot\><around|\<rangle\>||)>>,
  find

  <\equation>
    inf<rsub|v\<in\>\<cal-H\>,\<Phi\>><around|\<langle\>|v,\<Phi\><around|(|x|)>*v|\<rangle\>>.<label|nnc-ptm>
  </equation>

  Just as in the case for polynomials, positivstellenstze play an important
  role for efficiently solving <eqref|nnc-ptm>.

  In <cite|MR2148796> and <cite|MR2244371>, Schmdgen classified strictly
  positive elements of (respectively) the canonical representation of the
  Weyl algebra, and representations of enveloping algebras of an arbitrary
  finite dimensional Lie algebra, <math|\<cal-E\><around|(|\<frak-g\>|)>>.
  The results in <cite|MR2148796> and <cite|MR2244371> require a strong form
  of positivity in order to hold. In <cite|N-weyl-alg>, we relaxed this
  strong positivity condition for the positivstellensatz of the Weyl algebra.
  The same condition is needed for the case of representations of
  <math|\<cal-E\><around|(|\<frak-g\>|)>>, but the techniques in
  <cite|N-weyl-alg> are too specific to generalize to all
  <math|\<cal-E\><around|(|\<frak-g\>|)>>. In this paper, we develop
  different tools that allow us to relax the strong positivity condition for
  any <math|\<cal-E\><around|(|\<frak-g\>|)>>.

  The precise statement of the positivstellensatz in <cite|MR2244371>
  requires some notation. Let <math|G> denote a connected, simply connected
  Lie group, and <math|\<frak-g\>> the corresponding Lie algebra. Let
  <math|<wide|G|^>> denote the set of equivalence classes of unitary
  representations of <math|G>. We pick a basis
  <math|x<rsub|1>,\<ldots\>,x<rsub|d>> for <math|\<frak-g\>>, and make
  <math|\<cal-E\><around|(|\<frak-g\>|)>> into a *-algebra by defining
  <math|x<rsub|i><rsup|\<ast\>>=-x<rsub|i>>.

  Let <math|x<rsub|0>=I>, and <math|a=x<rsub|0><rsup|2>+x<rsub|1><rsup|\<ast\>>*x<rsub|1>+\<ldots\>+x<rsub|d><rsup|\<ast\>>*x<rsub|d>=I-x<rsub|1><rsup|2>-\<ldots\>-x<rsub|d><rsup|2>>.
  We will often use the fact that <math|a> commutes with all elements of
  <math|\<cal-E\><around|(|\<frak-g\>|)>>. Let <math|S> denote a right Ore
  subset of <math|\<cal-E\><around|(|\<frak-g\>|)>\<setminus\><around|{|0|}>>
  containing <math|a>. Denote by <math|f> an r-tuple
  <math|<around|(|f<rsub|1>,\<ldots\>,f<rsub|r>|)>> where
  <math|f<rsub|i>\<in\>\<cal-E\><around|(|\<frak-g\>|)>>,
  <math|r\<in\>\<bbb-N\>>, and <math|f<rsub|1>=1>. Let

  <\equation>
    \<cal-K\><rsub|f>=<around|{|\<kappa\>\<in\><wide|G|^>:<space|0.17em>d*U<rsub|\<kappa\>><around|(|f<rsub|1>|)>\<ge\>0,\<ldots\>,<space|0.17em>d*U<rsub|\<kappa\>><around|(|f<rsub|r>|)>\<ge\>0|}>,
  </equation>

  <\equation>
    \<cal-T\><rsub|f>=<around|{|z=<big|sum><rsub|j=1><rsup|k><big|sum><rsub|l=1><rsup|r>z<rsub|j*l><rsup|\<ast\>>*f<rsub|l>*z<rsub|j*l>:z<rsub|j*l>\<in\>\<cal-E\><around|(|\<frak-g\>|)>,k\<in\>\<bbb-N\>|}>,
  </equation>

  and

  <\equation>
    \<cal-E\><around|(|\<frak-g\>;f|)><rsub|+>=<around|{|z\<in\>\<cal-E\><around|(|\<frak-g\>|)><rsub|h>:<space|0.17em>d*U<rsub|\<kappa\>><around|(|z|)>\<ge\>0*<text|for
    >\<kappa\>\<in\>\<cal-K\><rsub|f>|}>.
  </equation>

  Let <math|\<gamma\>> be the vector space homomorphism from
  <math|\<cal-E\><around|(|\<frak-g\>|)>> to
  <math|\<bbb-C\><around|[|t<rsub|1>,\<ldots\>,t<rsub|d>|]>> that sends
  <math|x<rsub|1><rsup|n<rsub|1>>*\<ldots\>*x<rsub|d><rsup|n<rsub|d>>> to
  <math|<around|(|i*t<rsub|1>|)><rsup|n<rsub|1>>*\<ldots\>*<around|(|i*t<rsub|d>|)><rsup|n<rsub|d>>>.
  The image of <math|\<gamma\>> is similar to the graded algebra associated
  to the canonical filtration of <math|\<cal-E\><around|(|\<frak-g\>|)>> (see
  Section 2.3 in <cite|D>), which gives us a notion of degree on
  <math|\<cal-E\><around|(|\<frak-g\>|)>>. Let <math|c<rsub|n><around|(|t|)>>
  denote the degree <math|n> part of <math|\<gamma\><around|(|c|)><around|(|t|)>>.
  The strict positivstellensatz in <cite|MR2244371> is stated as follows.

  <\thm>
    <label|pos>Suppose that c is a hermitean element of the enveloping
    algebra <math|\<cal-E\><around|(|\<frak-g\>|)>> of even degree 2m
    satisfying the following assumptions:

    <\enumerate>
      <item>There exists <math|\<epsilon\>\<gtr\>0> such that
      <math|c-\<epsilon\>*I\<in\>\<cal-E\><around|(|\<frak-g\>;f|)><rsub|+>>.

      <item><math|c<rsub|2*m><around|(|t|)>\<gtr\>0> for all
      <math|t\<in\>\<bbb-R\><rsup|d>>, <math|t\<ne\>0>.
    </enumerate>

    If <math|m> is even, there exists an element <math|s\<in\>S> such that
    <math|s<rsup|\<ast\>>*c*s\<in\>\<cal-T\><rsub|f>>. If <math|m> is odd,
    there is an <math|s\<in\>S> such that

    <\equation>
      <big|sum><rsub|k=0><rsup|d>s<rsup|\<ast\>>*x<rsub|k><rsup|\<ast\>>*c*x<rsub|k>*s\<in\>\<cal-T\><rsub|f>.
    </equation>
  </thm>

  For a representation <math|U> of <math|G> on a Hilbert space, let
  <math|\<cal-D\><rsup|\<infty\>><around|(|U|)>> denote the set of smooth
  vectors, and <math|<around|\<langle\>|\<cdummy\>,\<cdummy\>|\<rangle\>>>
  denote the inner product. In this paper, we relax the first condition of
  this result to prove the following positivstellensatz.

  <\thm>
    <label|pos>Suppose that c is a hermitean element of the enveloping
    algebra <math|\<cal-E\><around|(|\<frak-g\>|)>> of even degree 2m
    satisfying the following assumptions:

    <\enumerate>
      <item>For all <math|\<kappa\>\<in\>\<cal-K\><rsub|f>> and nonzero
      <math|\<phi\>\<in\>\<cal-D\><rsup|\<infty\>><around|(|U<rsub|\<kappa\>>|)>>,
      <math|<around|\<langle\>|\<phi\>,<space|0.17em>d*U<rsub|\<kappa\>><around|(|c|)>*\<phi\>|\<rangle\>>\<gtr\>0>.

      <item><math|c<rsub|2*m><around|(|t|)>\<gtr\>0> for all
      <math|t\<in\>\<bbb-R\><rsup|d>>, <math|t\<ne\>0>.
    </enumerate>

    If <math|m> is even, there exists an element <math|s\<in\>S> such that
    <math|s<rsup|\<ast\>>*c*s\<in\>\<cal-T\><rsub|f>>. If <math|m> is odd,
    there is an <math|s\<in\>S> such that

    <\equation*>
      <big|sum><rsub|k=0><rsup|d>s<rsup|\<ast\>>*x<rsub|k><rsup|\<ast\>>*c*x<rsub|k>*s\<in\>\<cal-T\><rsub|f>.
    </equation*>
  </thm>

  The proof of Theorem <reference|pos> closely follows the proof of Theorem
  <reference|pos>. In the following subsection, we briefly discuss the proof
  of Theorem <reference|pos>, explaining what changes are needed to prove
  Theorem <reference|pos>.

  <subsection|Sketch of the proof of Theorem <reference|pos>>

  Let <math|\<kappa\>\<in\>\<cal-K\><rsub|f>>. From the corresponding
  representation <math|<space|0.17em>d*U<rsub|\<kappa\>>> on the
  <math|\<cal-E\><around|(|\<frak-g\>|)>>, we construct a *-algebra
  <math|\<cal-X\>> that acts on <math|\<cal-D\><rsup|\<infty\>><around|(|U<rsub|\<kappa\>>|)>>.
  Let <math|Y=<space|0.17em>d*U<rsub|\<kappa\>><around|(|a|)><rsup|-1>>. Then
  <math|\<cal-X\>> is generated by <math|I>,
  <math|Y<rsub|k*l>\<equiv\><space|0.17em>d*U<rsub|\<kappa\>><around|(|x<rsub|k>|)>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|x<rsub|l>|)>*Y>,
  and <math|Y<rsub|-l-k>\<equiv\>Y*<space|0.17em>d*U<rsub|\<kappa\>><around|(|x<rsub|l>|)>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|x<rsub|k>|)>>
  with <math|Y<rsub|k*l><rsup|\<ast\>>\<equiv\>Y<rsub|-l-k>>. It can be shown
  that the algebra <math|\<cal-X\>> is algebraically bounded.

  If <math|p\<in\>\<bbb-N\>> obeys <math|4*p\<gtr\><with|font-family|rm|d*e*g><around|(|f<rsub|l>|)>>,
  then by direct calculation, it follows that
  <math|Y<rsup|p>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|f<rsub|l>|)>*Y<rsup|p>\<in\>\<cal-X\>>.
  This allows us to define <math|\<cal-C\><rsub|f>> as the subset of
  <math|\<cal-X\>> where any element is a finite sum of
  <math|X<rsup|\<ast\>>*X> and <math|Z<rsup|\<ast\>>*Y<rsup|p>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|f<rsub|l>|)>*Y<rsup|p>*Z>,
  for <math|X,Z\<in\>\<cal-X\>> and <math|l=1,\<ldots\>,r>. The main part of
  the proof consists of showing that <math|Y<rsup|m>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|c|)>*Y<rsup|m>\<in\>\<cal-C\><rsub|f>>.

  Because <math|\<cal-X\>> is algebraically bounded, there is a functional
  <math|F> on <math|\<cal-X\>> that is positive in the wedge
  <math|\<cal-C\><rsub|f>>, but nonpositive outside of it. Using the GNS
  construction for the functional <math|F>, we obtain a *-representation
  <math|\<pi\><rsub|F>> of <math|\<cal-X\>> on the Hilbert space
  <math|<around|(|\<cal-H\>,|\<langle\>>\<cdot\>,\<cdot\><around|\<rangle\>||)>>,
  with cyclic vector <math|\<varphi\>>. This representation is a direct sum
  of representations <math|\<pi\><rsub|\<infty\>>> on
  <math|<with|font-family|rm|k*e*r>*\<pi\><rsub|F><around|(|Y|)>>, \ and
  <math|\<pi\><rsub|0>> on <math|\<cal-H\><rsub|0>\<equiv\><around|(|<with|font-family|rm|k*e*r>*\<pi\><rsub|F><around|(|Y|)>|)><rsup|\<perp\>>>.

  Suppose to the contrary that there is some
  <math|c\<in\>\<cal-E\><around|(|\<frak-g\>|)>> that satisfies the
  conditions of Theorem <reference|pos>, but
  <math|Y<rsup|m>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|c|)>*Y<rsup|m>\<in\>\<cal-X\>>
  lies outside the wedge <math|\<cal-C\><rsub|f>>. From the GNS construction,

  <\equation>
    F<around|(|X|)>=<around|\<langle\>|\<pi\><rsub|0><around|(|X|)>*\<varphi\><rsub|0>,\<varphi\><rsub|0>|\<rangle\>>+<around|\<langle\>|\<pi\><rsub|\<infty\>><around|(|X|)>*\<varphi\><rsub|\<infty\>>,\<varphi\><rsub|\<infty\>>|\<rangle\>>,<with|font-family|rm|f*o*rX>\<in\>\<cal-X\>.<label|gns>
  </equation>

  Showing that both terms in the right hand side of <eqref|gns> are positive
  for <math|X=Y<rsup|m>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|c|)>*Y<rsup|m>>
  contradicts the fact that <math|Y<rsup|m>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|c|)>*Y<rsup|m>>
  is outside <math|\<cal-C\><rsub|f>>.

  The positive <math|\<epsilon\>> in the first condition of Theorem
  <reference|pos> is only used in the proof that
  <math|<around|\<langle\>|\<pi\><rsub|0><around|(|x|)>*\<varphi\><rsub|0>,\<varphi\><rsub|0>|\<rangle\>>\<gtr\>0>.
  We need to conclude that if

  <\equation>
    \<forall\>\<phi\>\<in\>\<cal-D\><rsup|\<infty\>><around|(|U<rsub|\<kappa\>>|)>,\<phi\>\<ne\>0,<around|\<langle\>|\<pi\><rsub|0>*<around|(|Y<rsup|m>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|c|)>*Y<rsup|m>|)>*\<phi\>,\<phi\>|\<rangle\>>\<gtr\>0,
  </equation>

  then

  <\equation>
    \<forall\>\<phi\>\<in\>\<cal-H\><rsub|0>,\<phi\>\<ne\>0,<around|\<langle\>|\<pi\><rsub|0>*<around|(|Y<rsup|m>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|c|)>*Y<rsup|m>|)>*\<phi\>,\<phi\>|\<rangle\>>\<gtr\>0.
  </equation>

  In order to prove Theorem <reference|pos>, it suffices to show that if

  <\equation>
    <around|\<langle\>|\<pi\><rsub|0>*<around|(|Y<rsup|m>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|c|)>*Y<rsup|m>|)>*\<phi\>,\<phi\>|\<rangle\>>=0,
  </equation>

  then <math|\<phi\>\<in\>\<cal-D\><rsup|\<infty\>><around|(|U<rsub|\<kappa\>>|)>>.

  <subsection|Outline and notation>

  We prove Theorem <reference|pos> by studying regularity properties of
  solutions <math|u\<in\>\<cal-H\>> to equations of the form

  <\equation>
    <space|0.17em>d*V<around|(|p|)>*u=\<psi\>,
  </equation>

  for <math|p\<in\>\<cal-E\><around|(|\<frak-g\>|)>>, and <math|V> a unitary
  representation of <math|G>. In order to do this, we use some techniques
  from real algebraic geometry and functional analysis, which are introduced
  in Section 2 and Section 3 respectively. Regularity properties and our main
  result, Theorem <reference|pos>, are proven in Section 4. In addition to
  the notation already introduced, we denote by <math|C<rsub|0>> a constant
  that may change from line to line. An arbitrary unitary representation of
  <math|G> on a Hilbert space <math|\<cal-H\>> will be denoted by <math|V>,
  and <math|B> will denote <math|<wide|<space|0.17em>d*V<around|(|a|)>|\<bar\>>>.
  We use <math|A\<preceq\>D> for <math|A,D\<in\><space|0.17em>d*V<around|(|\<cal-E\><around|(|\<frak-g\>|)>|)>>
  to mean that for all <math|f\<in\>\<cal-D\><rsup|\<infty\>><around|(|V|)>>,

  <\equation>
    <around|\<langle\>|f,A*f|\<rangle\>>\<leq\><around|\<langle\>|f,D*f|\<rangle\>>.
  </equation>

  For an operator <math|A\<in\><space|0.17em>d*V<around|(|\<cal-E\><around|(|\<frak-g\>|)>|)>>,
  we denote the spectral projection for <math|A> on
  <math|[-\<Lambda\>,\<Lambda\>]> by <math|\<Pi\><rsub|<around|\||A|\|>\<leq\>\<Lambda\>>>.

  <section|Some Real Algebraic Geometry Tools>

  Let <math|p\<in\>\<cal-E\><around|(|\<frak-g\>|)>> with
  <math|\<gamma\><around|(|p|)><around|(|t|)>\<gtr\>0> for <math|t\<ne\>0>.
  We expect that the positivity of <math|\<gamma\><around|(|p|)><around|(|t|)>>
  should somehow be reflected in <math|p>. The fact that positive polynomials
  can be written as a sum of squares of rational functions serves as an
  algebraic characterization of positivity that can in part be transfered to
  <math|p>. For positive homogeneous polynomials, by a celebrated result of
  Reznick (see <cite|REZ>), we can make the sum of squares of rational
  functions more explicit.

  <\lemm>
    <label|positiv>Suppose <math|p<around|(|t|)>\<in\>\<bbb-R\><around|[|t<rsub|1>,\<ldots\>,t<rsub|d>|]>>
    is of degree <math|2*m>, homogeneous, and obeys
    <math|p<around|(|t|)>\<gtr\>0> for <math|t\<ne\>0>. Then there exists a
    <math|k> so that

    <\equation>
      <around|(|<big|sum><rsub|i=1><rsup|d>t<rsub|i><rsup|2>|)><rsup|n>*p<around|(|t|)>=<big|sum><rsub|l=1><rsup|k>q<rsub|l><rsup|2><around|(|t|)>,
    </equation>

    for some <math|q<rsub|l><around|(|t|)>\<in\>\<bbb-R\><around|[|t<rsub|1>,\<ldots\>,t<rsub|d>|]>>.
  </lemm>

  Positive homogeneous polynomials also have the advantage that they are
  stable under certain perturbations.

  <\lemm>
    <label|poly>Suppose <math|p<around|(|t|)>\<in\>\<bbb-R\><around|[|t<rsub|1>,\<ldots\>,t<rsub|d>|]>>
    is a homogeneous polynomial of degree <math|2*m> that satisfies
    <math|p<around|(|t|)>\<gtr\>0> for all <math|t\<in\>\<bbb-R\><rsup|d>>,
    <math|t\<ne\>0>. Then there exists a <math|\<lambda\>\<in\><R><rsub|+>>
    so that the polynomial

    <\equation>
      p<around|(|t|)>-\<lambda\><around|(|<big|sum><rsub|i=1><rsup|d>t<rsub|i><rsup|2>|)><rsup|m>
    </equation>

    is positive except at <math|t=0>.
  </lemm>

  <\proof>
    Let <math|v> be the minimum of <math|p<around|(|t|)>> on the sphere
    <math|\<bbb-S\><rsup|d-1>>, and let <math|\<lambda\>=<frac|v|2>>. Since
    <math|\<bbb-S\><rsup|d-1>> is compact, <math|v> is finite. It will
    suffice to show that the minimum of

    <\equation>
      <wide|p|~><around|(|t|)>\<equiv\>p<around|(|t|)>-\<lambda\><around|(|<big|sum><rsub|i=1><rsup|d>t<rsub|i><rsup|2>|)><rsup|m>
    </equation>

    on <math|\<bbb-S\><rsup|d-1>> is greater than <math|0>. This is because
    <math|p<around|(|t|)>> and <math|<wide|p|~><around|(|t|)>> are
    homogeneous polynomials, and for any nonzero
    <math|y\<in\>\<bbb-R\><rsup|d>>, there is a
    <math|y<rsub|0>\<in\>\<bbb-S\><rsup|d-1>>, and a
    <math|\<rho\>\<in\>\<bbb-R\>\<setminus\><around|{|0|}>>, so that
    <math|\<rho\>*y<rsub|0>=y>. This implies that

    <\equation>
      <wide|p|~><around|(|y|)>=\<rho\><rsup|2*m>*<wide|p|~><around|(|y<rsub|0>|)>.
    </equation>

    Therefore <math|<wide|p|~><around|(|t|)>> is determined by its values on
    <math|\<bbb-S\><rsup|d-1>>.

    Since <math|0> is not in <math|\<bbb-S\><rsup|d-1>>, <math|v\<gtr\>0>.
    Then the minimum of <math|<wide|p|~><around|(|t|)>> on
    <math|\<bbb-S\><rsup|d-1>> is <math|<frac|v|2>>. Therefore
    <math|<wide|p|~><around|(|t|)>> is never <math|0> on
    <math|\<bbb-S\><rsup|d-1>>, and <math|<wide|p|~><around|(|t|)>=0> only
    when <math|t=0>.
  </proof>

  From Lemma <reference|positiv> and Lemma <reference|poly>, given a degree
  <math|2*m> positive homogeneous polynomial <math|p<around|(|t|)>>, there is
  a <math|\<lambda\>\<in\>\<bbb-R\><rsup|+>> small enough and
  <math|n\<in\>\<bbb-N\>> large enough so that

  <\equation>
    <around|(|<big|sum><rsub|i=1><rsup|d>t<rsub|i><rsup|2>|)><rsup|n>*<around|(|p<around|(|t|)>-\<lambda\><around|(|<big|sum><rsub|i=1><rsup|d>t<rsub|i><rsup|2>|)><rsup|m>|)>
  </equation>

  is a sum of squares of polynomials.

  We would like to transfer this result to elements of
  <math|\<cal-E\><around|(|\<frak-g\>|)>>, but it does not carry over
  exactly. If <math|\<gamma\><around|(|p|)><around|(|t|)>> is a positive
  homogeneous polynomial, then for large <math|n>,

  <\equation>
    <around|(|a-I|)><rsup|n>*<around|(|p-\<lambda\>*<around|(|a-I|)><rsup|m>|)>
  </equation>

  will be a sum of squares, up to smaller degree terms. A version of this,
  tailored to our later needs, is presented in the following lemma.

  <\lemm>
    <label|cheap>Let <math|p\<in\>\<cal-E\><around|(|\<frak-g\>|)>>, with the
    degree of <math|p> equal to <math|2*m>, that satisfies
    <math|\<gamma\><around|(|p|)><around|(|t|)>=p<rsub|2*m><around|(|t|)>\<gtr\>0>
    for all <math|t\<in\>\<bbb-R\><rsup|d>>, <math|t\<ne\>0>. Then there
    exists <math|q<rsub|i>,r\<in\>\<cal-E\><around|(|\<frak-g\>|)>>, and
    <math|\<lambda\>\<in\>\<bbb-R\><rsup|+>> so that

    <align|<tformat|<table|<row|<cell|p*a<rsup|n>>|<cell|=<around|(|<big|sum><rsub|i=1><rsup|k>q<rsub|i><rsup|\<ast\>>*q<rsub|i>|)>+\<lambda\>*<around|(|a-I|)><rsup|m>*a<rsup|n>+r,>>>>>

    where <math|deg <around|(|q<rsub|i>|)>\<leq\>m+n>, and <math|deg
    <around|(|r|)>\<leq\>2*<around|(|m+n|)>-1>.

    In the case that the dimension of <math|\<frak-g\>> is at most <math|2>
    there exists <math|q<rsub|i>,r\<in\>\<cal-E\><around|(|\<frak-g\>|)>> so
    that

    <align|<tformat|<table|<row|<cell|p>|<cell|=<around|(|<big|sum><rsub|i=1><rsup|k>q<rsub|i><rsup|\<ast\>>*q<rsub|i>|)>+\<lambda\>*<around|(|a-I|)><rsup|m>+r,<label|cheap>>>>>>

    where <text|deg><math|<around|(|q<rsub|i>|)>\<leq\>m>, and
    <text|deg><math|<around|(|r|)>\<leq\>2*m-1>.
  </lemm>

  <\proof>
    We will first consider the case when the
    <math|<with|font-family|rm|d*i*m><around|(|\<frak-g\>|)>\<gtr\>2>. By
    showing

    <\equation>
      p*<around|(|a-I|)><rsup|n>=<big|sum><rsub|i=1><rsup|k>q<rsub|i><rsup|\<ast\>>*q<rsub|i>+\<lambda\>*<around|(|a-I|)><rsup|m+n>+r,<label|cheap>
    </equation>

    the result will follow.

    Let <math|\<cal-F\>> be the free algebra generated by
    <math|<math-bf|x><rsub|1>,\<ldots\>,<math-bf|x><rsub|d>> over
    <math|\<bbb-C\>>, with the obvious notion of degree. By defining
    <math|<math-bf|x><rsub|l><rsup|\<ast\>>=-<math-bf|x><rsub|l>> for each
    <math|<math-bf|x><rsub|l>>, <math|\<cal-F\>> becomes a *-algebra.

    Since <math|\<frak-g\>> is a Lie algebra, there exists
    <math|c<rsub|i*j><rsup|l>\<in\>\<bbb-C\>> (<math|l> is a superscript) so
    that

    <\equation>
      <around|[|x<rsub|i>,x<rsub|j>|]>=<big|sum><rsub|l=1><rsup|d>c<rsub|i*j><rsup|l>*x<rsub|l>.<label|lie>
    </equation>

    Define a map <math|\<alpha\>> from <math|\<cal-F\>> to
    <math|\<cal-E\><around|(|\<frak-g\>|)>> by moding out by the relations
    <eqref|lie<rsub|a>lg>. There is also a map <math|\<beta\>> from
    <math|\<cal-F\>> to <math|\<bbb-C\><around|[|t<rsub|1>,\<ldots\>,t<rsub|d>|]>>
    obtained by moding out by commutators
    <math|<around|[|<math-bf|x><rsub|i>,<math-bf|x><rsub|j>|]>>, and
    identifying each <math|<math-bf|x><rsub|l>> with <math|i*t<rsub|l>>. Note
    that <math|\<beta\>> and <math|\<alpha\>> are *-algebra homomorphisms.

    Let <math|\<lambda\>\<in\>\<bbb-R\><rsup|+>>,
    <math|<wide|p|~>=p-\<lambda\>*<around|(|a-I|)><rsup|m>>, and let
    <math|<wide|<math-bf|p>|~>\<in\>\<cal-F\>> be such that <math|deg
    <around|(|<wide|<math-bf|p>|~>|)>=2*m>,
    <math|\<alpha\><around|(|<wide|<math-bf|p>|~>|)>=<wide|p|~>>, and
    <math|\<beta\><around|(|<wide|<math-bf|p>|~>|)><around|(|t|)>=\<gamma\><around|(|<wide|p|~>|)><around|(|t|)>>.
    For <math|\<lambda\>> sufficiently small by Lemma <reference|poly>, and
    sufficiently large <math|n>, by Lemma <reference|positiv> and our
    assumption on <math|p<rsub|2*m><around|(|t|)>>,
    <math|\<beta\><around|(|<wide|<math-bf|p>|~>|)><around|(|t|)><around|(|<big|sum><rsub|i=1><rsup|d>t<rsub|i><rsup|2>|)><rsup|n>>
    can be written as a sum of squares,

    <\equation>
      \<beta\><around|(|<wide|<math-bf|p>|~>|)><around|(|t|)><around|(|<big|sum><rsub|i=1><rsup|d>t<rsub|i><rsup|2>|)><rsup|n>=\<gamma\><around|(|<wide|p|~>|)><around|(|t|)><around|(|<big|sum><rsub|i=1><rsup|d>t<rsub|i><rsup|2>|)><rsup|n>=<big|sum><rsub|i=1><rsup|k>q<rsub|i><rsup|2><around|(|t|)>
    </equation>

    for some <math|q<rsub|i><around|(|t|)>\<in\>\<bbb-R\><around|[|t<rsub|1>,\<ldots\>,t<rsub|d>|]>>.
    Let <math|<math-bf|q><rsub|i>\<in\>\<cal-F\>> be such that <math|deg
    <around|(|<math-bf|q><rsub|i>|)>=deg <around|(|q<rsub|i><around|(|t|)>|)>>,
    and <math|\<beta\><around|(|<math-bf|q><rsub|i>|)><around|(|t|)>=q<rsub|i><around|(|t|)>>.
    Since

    <\equation>
      \<beta\><around|(|<wide|<math-bf|p>|~>|)><around|(|t|)><around|(|<big|sum><rsub|i=1><rsup|d>t<rsub|i><rsup|2>|)><rsup|n>-<big|sum><rsub|i=1><rsup|k>q<rsub|i><rsup|2><around|(|t|)>=0,
    </equation>

    it follows that

    <\equation>
      <wide|<math-bf|p>|~><around|(|<big|sum><rsub|i=1><rsup|d><math-bf|x><rsub|i><rsup|2>|)><rsup|n>-<big|sum><rsub|i=1><rsup|k><math-bf|q><rsub|i><rsup|2>\<in\><around|\<langle\>|<around|[|<math-bf|x><rsub|1>,<math-bf|x><rsub|2>|]>,<around|[|<math-bf|x><rsub|1>,<math-bf|x><rsub|3>|]>,\<ldots\>,<around|[|<math-bf|x><rsub|d-1>,<math-bf|x><rsub|d>|]>|\<rangle\>>.
    </equation>

    This, and the degree bounds for <math|<wide|<math-bf|p>|~>> and
    <math|<math-bf|q><rsub|i>> imply that for some
    <math|<math-bf|s><rsub|i,j,\<iota\>>,<math-bf|d><rsub|i,j,\<nu\>>\<in\>\<cal-F\>>,

    <\equation>
      <wide|<math-bf|p>|~><around|(|<big|sum><rsub|i=1><rsup|d><math-bf|x><rsub|i><rsup|2>|)><rsup|n>-<big|sum><rsub|i=1><rsup|k><math-bf|q><rsub|i><rsup|2>=<big|sum><rsub|i,j,\<iota\>,\<nu\>><math-bf|s><rsub|i,j,\<iota\>><around|[|<math-bf|x><rsub|i>,<math-bf|x><rsub|j>|]><math-bf|d><rsub|i,j,\<nu\>>,<label|qtn>
    </equation>

    where <math|deg <around|(|<math-bf|d><rsub|i,j,\<nu\>>|)>+deg
    <around|(|<math-bf|s><rsub|i,j,\<iota\>>|)>\<leq\>2*<around|(|m+n-1|)>>
    for all <math|i,j,\<iota\>,\<nu\>>. We apply the map <math|\<alpha\>> to
    <eqref|qtn>,

    <align|<tformat|<table|<row|<cell|>|<cell|\<alpha\><around|(|<wide|<math-bf|p>|~><around|(|<big|sum><rsub|i=1><rsup|d><math-bf|x><rsub|i><rsup|2>|)><rsup|n>|)>-<big|sum><rsub|i=1><rsup|k>\<alpha\><around|(|<math-bf|q><rsub|i><rsup|2>|)>>>|<row|<cell|>|<cell|<space|1em>=<big|sum><rsub|i,j,\<iota\>,\<nu\>>\<alpha\><around|(|<math-bf|s><rsub|i,j,\<iota\>>|)>*\<alpha\><around|(|<around|[|<math-bf|x><rsub|i>,<math-bf|x><rsub|j>|]>|)>*\<alpha\><around|(|<math-bf|d><rsub|i,j,\<nu\>>|)>.>>>>>

    Therefore,

    <align|<tformat|<table|<row|<cell|>|<cell|<wide|p|~>*<around|(|a-I|)><rsup|n>-<big|sum><rsub|i=1><rsup|k>\<alpha\><around|(|<math-bf|q><rsub|i>|)><rsup|\<ast\>>*\<alpha\><around|(|<math-bf|q><rsub|i>|)>>>|<row|<cell|>|<cell|<space|1em>=<big|sum><rsub|i,j,\<iota\>,\<nu\>>\<alpha\><around|(|<math-bf|s><rsub|i,j,\<iota\>>|)>*\<alpha\><around|(|<around|[|<math-bf|x><rsub|i>,<math-bf|x><rsub|j>|]>|)>*\<alpha\><around|(|<math-bf|d><rsub|i,j,\<nu\>>|)>.>>>>>

    Since the degree of <math|\<alpha\><around|(|<around|[|<math-bf|x><rsub|i>,<math-bf|x><rsub|j>|]>|)>>
    is at most <math|1>, <eqref|cheap<rsub|s>os<rsub|p>1> follows.

    To prove <eqref|cheap<rsub|s>os<rsub|p>2>, we follow the proof of
    <eqref|cheap<rsub|s>os<rsub|p>1>, noting that any positive homogeneous
    polynomial in one or two variables can be written as a sum of squares of
    homogeneous polynomials, instead of appealing to Reznick's Theorem.
  </proof>

  In a representation <math|<space|0.17em>d*V> of the enveloping algebra, we
  can solve for <math|<space|0.17em>d*V<around|(|p|)>> in
  <eqref|cheap<rsub|s>os<rsub|p>1>, and allow <math|p> to have lower degree
  terms which are absorbed by the remainder <math|r>. This is the form of
  Lemma <reference|cheap> that we will later use.

  <\cor>
    <label|cheap>Let <math|p\<in\>\<cal-E\><around|(|\<frak-g\>|)>>, with the
    degree of <math|p> equal to <math|2*m>, that satisfies
    <math|p<rsub|2*m><around|(|t|)>\<gtr\>0> for all
    <math|t\<in\>\<bbb-R\><rsup|d>>, <math|t\<ne\>0>. Then there exists
    <math|\<lambda\>\<in\>\<bbb-R\><rsup|+>>, and <math|n\<in\>\<bbb-N\>>
    sufficiently large so that

    <align|<tformat|<table|<row|<cell|<space|0.17em>d*V<around|(|p|)>>|<cell|=<big|sum><rsub|i=1><rsup|k>B<rsup|-<frac|n|2>>*<space|0.17em>d*V<around|(|q<rsub|i><rsup|\<ast\>>|)>*<space|0.17em>d*V<around|(|q<rsub|i>|)>*B<rsup|-<frac|n|2>>+\<lambda\>*<around|(|B-I|)><rsup|m>+B<rsup|-<frac|n|2>>*<space|0.17em>d*V<around|(|r|)>*B<rsup|-<frac|n|2>>,>>>>>

    where <text|deg><math|<around|(|q<rsub|i>|)>\<leq\>m+n>, and
    <text|deg><math|<around|(|r|)>\<leq\>2*<around|(|m+n|)>-1>.

    In the case that the dimension of <math|\<frak-g\>> is at most <math|2>
    there exists <math|q<rsub|i>,r\<in\>\<cal-E\><around|(|\<frak-g\>|)>> so
    that

    <align|<tformat|<table|<row|<cell|<space|0.17em>d*V<around|(|p|)>>|<cell|=<around|(|<big|sum><rsub|i=1><rsup|k><space|0.17em>d*V<around|(|q<rsub|i>|)><rsup|\<ast\>>*<space|0.17em>d*V<around|(|q<rsub|i>|)>|)>+\<lambda\>*<around|(|B-I|)><rsup|m>+<space|0.17em>d*V<around|(|r|)>,>>>>>

    where <text|deg><math|<around|(|q<rsub|i>|)>\<leq\>m>, and
    <text|deg><math|<around|(|r|)>\<leq\>2*m-1>.
  </cor>

  <section|Some Functional Analysis Tools>

  Our main result requires a smoothing effect in terms of <math|B>. To this
  end we compare the <math|<space|0.17em>d*V<around|(|x<rsub|i>|)>>'s with
  <math|B>, and expect that for <math|\<psi\>\<in\>\<cal-D\><rsup|\<infty\>><around|(|V|)>>,
  <math|<around|\<\|\|\>|<space|0.17em>d*V<around|(|x<rsub|i<rsub|1>>|)>*\<ldots\>*<space|0.17em>d*V<around|(|x<rsub|i<rsub|l>>|)>*\<psi\>|\<\|\|\>>\<leq\>C<rsub|0>*<around|\<\|\|\>|B<rsup|<frac|l|2>>*\<psi\>|\<\|\|\>>>.
  The following lemmas allow us to conclude this.

  <\lemm>
    <label|crs-trm>For any <math|P,Q,R,Z\<in\><space|0.17em>d*V<around|(|\<cal-E\><around|(|\<frak-g\>|)>|)>>
    with <math|-Z\<preceq\>Q\<preceq\>Z> and <math|0\<preceq\>Z>,

    <align|<tformat|<table|<row|<cell|P<rsup|\<ast\>>*Q*R+R<rsup|\<ast\>>*Q*P>|<cell|\<preceq\>C<rsub|0>*<around|(|P<rsup|\<ast\>>*Z*P+R<rsup|\<ast\>>*Z*R|)>.>>>>>
  </lemm>

  <\proof>
    We first observe that since

    <align|<tformat|<table|<row|<cell|0>|<cell|\<preceq\><around|(|P-R|)><rsup|\<ast\>>*Z*<around|(|P-R|)>>>|<row|<cell|>|<cell|\<preceq\>P<rsup|\<ast\>>*Z*P+R<rsup|\<ast\>>*Z*R-P<rsup|\<ast\>>*Z*R-R<rsup|\<ast\>>*Z*P,>>>>>

    it follows that

    <align|<tformat|<table|<row|<cell|P<rsup|\<ast\>>*Z*R+R<rsup|\<ast\>>*Z*P>|<cell|\<preceq\>P<rsup|\<ast\>>*Z*P+R<rsup|\<ast\>>*Z*R.<label|pst-crs-trm>>>>>>

    We further observe that

    <\equation>
      -P<rsup|\<ast\>>*Z*P\<preceq\>P<rsup|\<ast\>>*Q*P,<label|bvs-n>
    </equation>

    and

    <\equation>
      -R<rsup|\<ast\>>*Z*R\<preceq\>R<rsup|\<ast\>>*Q*R.<label|bvs-w>
    </equation>

    Using <eqref|pst-crs-trm>, we see that

    <align|<tformat|<table|<row|<cell|P<rsup|\<ast\>>*Q*P+R<rsup|\<ast\>>*Q*R+P<rsup|\<ast\>>*Q*R+R<rsup|\<ast\>>*Q*P>|<cell|=<around|(|P+R|)><rsup|\<ast\>>*Q*<around|(|P+R|)>>>|<row|<cell|>|<cell|\<preceq\><around|(|P+R|)><rsup|\<ast\>>*Z*<around|(|P+R|)>>>|<row|<cell|>|<cell|=P<rsup|\<ast\>>*Z*P+R<rsup|\<ast\>>*Z*R+P<rsup|\<ast\>>*Z*R+R<rsup|\<ast\>>*Z*P>>|<row|<cell|>|<cell|\<preceq\>2*P<rsup|\<ast\>>*Z*P+2*R<rsup|\<ast\>>*Z*R.<label|mxd-trm-bnd>>>>>>

    Applying <eqref|bvs-n> and <eqref|bvs-w> to <eqref|mxd-trm-bnd>,

    <align|<tformat|<table|<row|<cell|P<rsup|\<ast\>>*Q*R+R<rsup|\<ast\>>*Q*P>|<cell|\<preceq\>2*P<rsup|\<ast\>>*Z*P+2*R<rsup|\<ast\>>*Z*R-P<rsup|\<ast\>>*Q*P-R<rsup|\<ast\>>*Q*R>>|<row|<cell|>|<cell|\<preceq\>3*P<rsup|\<ast\>>*Z*P+3*R<rsup|\<ast\>>*Z*R.>>>>>
  </proof>

  We remark that of course Lemma <reference|crs-trm> can be proven for more
  general families of operators, but content ourselves with the current
  version, which is sufficient for our purposes.

  Lemma <reference|crs-trm> allows us to prove our comparison results.

  <\lemm>
    <label|even-bound>Let <math|p> be a degree <math|n> element of
    <math|\<cal-E\><around|(|\<frak-g\>|)>>. Then

    <\equation>
      -C<rsub|0>*B<rsup|<frac|n|2>>\<preceq\><space|0.17em>d*V<around|(|p|)>\<preceq\>C<rsub|0>*B<rsup|<frac|n|2>>.<label|vn-cs>
    </equation>
  </lemm>

  <\proof>
    We proceed by induction on <math|n>. For the case that <math|n=1>, we
    observe that any <math|<space|0.17em>d*V<around|(|x<rsub|l>|)>> obeys

    <\equation>
      -<around|\||<space|0.17em>d*V<around|(|x<rsub|l>|)>|\|>\<preceq\><space|0.17em>d*V<around|(|x<rsub|l>|)>\<preceq\><around|\||<space|0.17em>d*V<around|(|x<rsub|l>|)>|\|>.<label|bsl-bnd>
    </equation>

    Combining the fact that

    <\equation>
      B=<big|sum><rsub|i\<ne\>l><space|0.17em>d*V<around|(|x<rsub|i>|)><rsup|\<ast\>>*<space|0.17em>d*V<around|(|x<rsub|i>|)>+<space|0.17em>d*V<around|(|x<rsub|l>|)><rsup|\<ast\>>*<space|0.17em>d*V<around|(|x<rsub|l>|)>\<succeq\><space|0.17em>d*V<around|(|x<rsub|l>|)><rsup|\<ast\>>*<space|0.17em>d*V<around|(|x<rsub|l>|)>,<label|smp-b-bnd>
    </equation>

    and that <math|x<rsub|l>> commutes with <math|a>, it follows that

    <\equation>
      <around|\||<space|0.17em>d*V<around|(|x<rsub|l>|)>|\|>\<preceq\>B<rsup|<frac|1|2>>.<label|n-qls-n>
    </equation>

    From <eqref|bsl-bnd> and <eqref|n-qls-n>, the case <math|n=1> of
    <eqref|vn-cs> is verified.

    Suppose <eqref|bsl-bnd> is true for some <math|n-1\<in\>\<bbb-N\>>. It
    suffices to derive the upper bound for terms of the form

    <\equation>
      p=x<rsub|1><rsup|n<rsub|1>>*\<cdots\>*x<rsub|d><rsup|n<rsub|d>>,
    </equation>

    where <math|<big|sum><rsub|i=1><rsup|d>n<rsub|i>=n>. We will assume
    without loss of generality that <math|n<rsub|1>,n<rsub|d>\<ge\>1>. The
    argument for other cases follows a similar line of reasoning. By the
    commutation relations, there is an <math|r\<in\>\<cal-E\><around|(|\<frak-g\>|)>>
    of degree at most <math|n-1> so that

    <\equation>
      p=-<frac|1|2>*x<rsub|1><rsup|\<ast\>>*x<rsub|1><rsup|n<rsub|1>-1>*\<cdots\>*x<rsub|d><rsup|n<rsub|d>-1>*x<rsub|d>-<frac|1|2>*x<rsub|d><rsup|\<ast\>>*x<rsub|1><rsup|n<rsub|1>-1>*\<cdots\>*x<rsub|d><rsup|n<rsub|d>-1>*x<rsub|1>+r.<label|cngj-pls-rrr>
    </equation>

    Since <math|deg r\<leq\>n-1>, it follows by the induction hypothesis that

    <\equation>
      -C<rsub|0>*B<rsup|<frac|n|2>>\<preceq\>-C<rsub|0>*B<rsup|<frac|n-1|2>>\<preceq\><space|0.17em>d*V<around|(|r|)>\<preceq\>C<rsub|0>*B<rsup|<frac|n-1|2>>\<preceq\>C<rsub|0>*B<rsup|<frac|n|2>>.<label|lwr-rdr-trm>
    </equation>

    Using the induction hypothesis again,

    <\equation>
      -C<rsub|0>*B<rsup|<frac|n-2|2>>\<preceq\>-<space|0.17em>d*V*<around|(|x<rsub|1><rsup|n<rsub|1>-1>*\<cdots\>*x<rsub|d><rsup|n<rsub|d>-1>|)>\<preceq\>C<rsub|0>*B<rsup|<frac|n-2|2>>.<label|nsd>
    </equation>

    Combining <eqref|cngj-pls-rrr>, <eqref|lwr-rdr-trm>, <eqref|nsd>, and
    Lemma <reference|crs-trm>,

    <align|<tformat|<table|<row|<cell|<space|0.17em>d*V<around|(|p|)>>|<cell|\<preceq\>C<rsub|0>(<space|0.17em>d*V<around|(|x<rsub|1>|)><rsup|\<ast\>>*B<rsup|<frac|n-2|2>>*<space|0.17em>d*V<around|(|x<rsub|1>|)>>>|<row|<cell|>|<cell|<space|1em>+<space|0.17em>d*V<around|(|x<rsub|d>|)><rsup|\<ast\>>*B<rsup|<frac|n-2|2>>*<space|0.17em>d*V<around|(|x<rsub|d>|)>+B<rsup|n>).<label|cng-pls-sml>>>>>>

    Then make the observation that since <math|a> commutes with all
    <math|x<rsub|i>>,

    <\equation>
      <space|0.17em>d*V<around|(|x<rsub|i>|)><rsup|\<ast\>>*B<rsup|<frac|n-2|2>>*<space|0.17em>d*V<around|(|x<rsub|i>|)>=<around|(|B<rsup|<frac|n-2|4>>|)><rsup|\<ast\>>*<space|0.17em>d*V<around|(|x<rsub|i>|)><rsup|\<ast\>>*<space|0.17em>d*V<around|(|x<rsub|i>|)>*B<rsup|<frac|n-2|4>>.<label|sqr>
    </equation>

    By applying <eqref|smp-b-bnd> to <eqref|sqr>, and applying that result in
    turn to <eqref|cng-pls-sml>, the statement <eqref|vn-cs> holds for
    <math|n>. By induction the lemma follows.
  </proof>

  If the leading terms of <math|\<gamma\><around|(|p|)><around|(|t|)>> for a
  degree <math|2*m> <math|p\<in\>\<cal-E\><around|(|\<frak-g\>|)>> obey a
  strong positivity condition, then we may use Lemma <reference|even-bound>
  and Corollary <reference|cheap> to conclude a sort of equivalence between
  <math|<space|0.17em>d*V<around|(|p|)>> and <math|B<rsup|m>>.

  <\lemm>
    <label|c-qvl-bm>For degree <math|2*m>
    <math|p\<in\>\<cal-E\><around|(|\<frak-g\>|)>> satisfying
    <math|p<rsub|2*m><around|(|t|)>\<gtr\>0> when <math|t\<ne\>0>, there
    exists <math|\<vartheta\>,\<delta\>\<in\>\<bbb-R\><rsup|+>> so that

    <\equation>
      <frac|1|\<delta\>>*B<rsup|m>\<preceq\><space|0.17em>d*V<around|(|p|)>+\<vartheta\>*I\<preceq\>\<delta\>*B<rsup|m>.
    </equation>
  </lemm>

  <\proof>
    It immediately follows from Lemma <reference|even-bound> that

    <\equation>
      <space|0.17em>d*V<around|(|p|)>+\<vartheta\>*I\<preceq\>C<rsub|0>*B<rsup|m>.
    </equation>

    For the other direction we use Corollary <reference|cheap>, assuming
    without loss of generality that <math|dim \<frak-g\>\<gtr\>2>,

    <align|<tformat|<table|<row|<cell|<space|0.17em>d*V*<around|(|p+\<vartheta\>*I|)>>|<cell|=<big|sum><rsub|i=1><rsup|k>B<rsup|-<frac|n|2>>*<space|0.17em>d*V<around|(|q<rsub|i><rsup|\<ast\>>|)>*<space|0.17em>d*V<around|(|q<rsub|i>|)>*B<rsup|-<frac|n|2>>+\<lambda\>*<around|(|B-I|)><rsup|m>>>|<row|<cell|>|<cell|<space|1em>+B<rsup|-<frac|n|2>>*<space|0.17em>d*V<around|(|r|)>*B<rsup|-<frac|n|2>>+\<vartheta\>*I>>|<row|<cell|>|<cell|\<succeq\>\<lambda\>*<around|(|B-I|)><rsup|m>+B<rsup|-<frac|n|2>>*<space|0.17em>d*V<around|(|r|)>*B<rsup|-<frac|n|2>>+\<vartheta\>*I.<label|c-lwr-bnd>>>>>>

    By Lemma <reference|even-bound>, the Spectral Theorem, and an elementary
    inequality, for any <math|\<varepsilon\>\<gtr\>0>,

    <\equation>
      B<rsup|-<frac|n|2>>*<space|0.17em>d*V<around|(|r|)>*B<rsup|-<frac|n|2>>\<succeq\>-C<rsub|0>*B<rsup|m-<frac|1|2>>\<succeq\>-C<rsub|0>*<around|(|\<varepsilon\>*B<rsup|m>+<frac|1|\<varepsilon\><rsup|2*m-1>>*I|)>.<label|rmn-bnd>
    </equation>

    Combining <eqref|c-lwr-bnd> and <eqref|rmn-bnd>,

    <\equation>
      <space|0.17em>d*V*<around|(|p+\<vartheta\>*I|)>\<succeq\>\<lambda\>*<around|(|B-I|)><rsup|m>+\<vartheta\>*I-C<rsub|0>*<around|(|\<varepsilon\>*B<rsup|m>+<frac|1|\<varepsilon\><rsup|2*m-1>>*I|)>.
    </equation>

    By first picking <math|\<varepsilon\>> small enough, then
    <math|\<vartheta\>> large enough, the result follows.
  </proof>

  Using the fact that <math|p> and <math|a> commute, along with Lemma
  <reference|c-qvl-bm>, we have the following corollary.

  <\cor>
    <label|b-qvl-c>For <math|p\<in\>\<cal-E\><around|(|\<frak-g\>|)>> of
    degree <math|2*m> that obeys <math|p<rsub|2*m><around|(|t|)>\<gtr\>0>
    when <math|t\<ne\>0>, large enough <math|\<vartheta\>,\<delta\>\<in\>\<bbb-R\><rsup|+>>,
    <math|f\<in\>\<cal-D\><rsup|\<infty\>><around|(|V|)>>, and any
    <math|l\<in\>\<bbb-R\><rsup|+>>,

    <\equation>
      <frac|1|\<delta\>>*<around|\<\|\|\>|B<rsup|<frac|l|2>>*f|\<\|\|\>>\<leq\><around|\<\|\|\>|<around|(|<space|0.17em>d*V<around|(|p|)>+\<vartheta\>*I|)><rsup|<frac|l|2*m>>*f|\<\|\|\>>\<leq\>\<delta\>*<around|\<\|\|\>|B<rsup|<frac|l|2>>*f|\<\|\|\>>.
    </equation>

    In particular, for any <math|u\<in\>\<cal-H\>>,
    <math|\<Pi\><rsub|<around|\||<space|0.17em>d*V*<around|(|p+\<vartheta\>*I|)>|\|>\<leq\>\<Lambda\>>*u\<in\>\<cal-D\><rsup|\<infty\>><around|(|V|)>>.
  </cor>

  <section|Main Results>

  Let <math|p\<in\>\<cal-E\><around|(|\<frak-g\>|)>> of degree <math|2*m>
  obey <math|p<rsub|2*m><around|(|t|)>\<gtr\>0> when <math|t\<ne\>0>.
  Inspired by the Elliptic Regularity Theorem for PDEs, we might expect that
  if <math|\<psi\>\<in\>\<cal-D\>*<around|(|B<rsup|\<nosymbol\>>*\<mu\>*2|)>>,
  then the solution <math|u> of

  <\equation>
    <label|pde><space|0.17em>d*V<around|(|p|)>*u=\<psi\>
  </equation>

  is in the space <math|\<cal-D\><around|(|B<rsup|<frac|\<mu\>+m|2>>|)>>. If
  we do not know whether <math|u\<in\>\<cal-D\>*<around|(|<space|0.17em>d*V<around|(|p|)>|)>>,
  we may interpret <eqref|pde> in a <math|<around|(|\<cal-D\><rsup|\<infty\>><around|(|V|)>|)><rsup|\<ast\>>>
  sense. That is for all <math|\<zeta\>\<in\>\<cal-D\><rsup|\<infty\>><around|(|V|)>>,

  <\equation>
    <label|weak-sol><around|\<langle\>|<space|0.17em>d*V<around|(|p|)><rsup|\<ast\>>*\<zeta\>,u|\<rangle\>>=<around|\<langle\>|\<zeta\>,\<psi\>|\<rangle\>>.
  </equation>

  From Lemma <reference|c-qvl-bm>, we know that
  <math|<space|0.17em>d*V<around|(|p|)>> is equivalent to <math|B<rsup|m>>,
  modulo smaller terms. By considering

  <\equation*>
    <around|\<langle\>|u,<space|0.17em>d*V<around|(|p|)>*u|\<rangle\>>=<around|\<langle\>|u,\<psi\>|\<rangle\>>\<less\>\<infty\>,
  </equation*>

  if the smaller terms in <math|<around|\<langle\>|u,<space|0.17em>d*V<around|(|p|)>*u|\<rangle\>>>
  are finite, we obtain that <math|u> gains an amount of regularity through
  <math|<space|0.17em>d*V<around|(|p|)>>. We formalize this argument in the
  following theorem.

  <\thm>
    <label|ellip>Let <math|V> be a unitary representation of <math|G>, and
    <math|p> a degree <math|2*m> element of
    <math|\<cal-E\><around|(|\<frak-g\>|)>> that satisfies
    <math|p<rsub|2*m><around|(|t|)>\<gtr\>0> when <math|t\<ne\>0>. If
    <math|\<psi\>\<in\>\<cal-D\><around|(|B<rsup|<frac|\<mu\>|2>>|)>> for
    some <math|\<mu\>\<in\>\<bbb-R\><rsup|+>>, and <math|u\<in\>\<cal-H\>>
    which is a solution to

    <\equation>
      <space|0.17em>d*V<around|(|p|)>*u=\<psi\>,<label|llp-eq>
    </equation>

    in a <math|<around|(|\<cal-D\><rsup|\<infty\>><around|(|V|)>|)><rsup|\<ast\>>>
    sense, then <math|u\<in\>\<cal-D\><around|(|B<rsup|<frac|\<mu\>+m|2>>|)>>.
  </thm>

  <\proof>
    It is necessary to regularize <math|u> in order to bound higher
    derivatives. To this end we choose <math|\<vartheta\>> as in Lemma
    <reference|c-qvl-bm>, then apply <math|\<Pi\><rsub|\<Lambda\>>\<equiv\>\<Pi\><rsub|<around|\||<space|0.17em>d*V*<around|(|p+\<vartheta\>*I|)>|\|>\<leq\>\<Lambda\>>>
    to <eqref|llp-eq>,

    <align|<tformat|<table|<row|<cell|<space|0.17em>d*V<around|(|p|)>*\<Pi\><rsub|\<Lambda\>>*u>|<cell|=\<Pi\><rsub|\<Lambda\>>*\<psi\>.<label|rgl-llp-eq>>>>>>

    In order to obtain a positive operator acting on
    <math|\<Pi\><rsub|\<Lambda\>>*u> on the left hand side of
    <eqref|rgl-llp-eq>, we can add <math|\<vartheta\>*\<Pi\><rsub|\<Lambda\>>*u>
    by Lemma <reference|c-qvl-bm>.

    <\equation>
      <space|0.17em>d*V<around|(|p|)>*\<Pi\><rsub|\<Lambda\>>*u+\<vartheta\>*\<Pi\><rsub|\<Lambda\>>*u=\<Pi\><rsub|\<Lambda\>>*\<psi\>+\<vartheta\>*\<Pi\><rsub|\<Lambda\>>*u.<label|rgl-llp-eq-1>
    </equation>

    Multiplying <eqref|rgl-llp-eq-1> by <math|<around|(|d*V<around|(|p|)>+\<vartheta\>*I|)><rsup|<frac|\<mu\>|2*m>>>,

    <align|<tformat|<table|<row|<cell|<around|(|d*V<around|(|p|)>+\<vartheta\>*I|)><rsup|1+<frac|\<mu\>|2*m>>*\<Pi\><rsub|\<Lambda\>>*u>|<cell|=<around|(|d*V<around|(|p|)>+\<vartheta\>*I|)><rsup|<frac|\<mu\>|2*m>>*\<Pi\><rsub|\<Lambda\>>*\<psi\>>>|<row|<cell|>|<cell|<space|1em>+\<vartheta\>*<around|(|d*V<around|(|p|)>+\<vartheta\>*I|)><rsup|<frac|\<mu\>|2*m>>*\<Pi\><rsub|\<Lambda\>>*u.<label|dt-me>>>>>>

    Taking the inner product of <eqref|dt-me> with
    <math|<around|(|d*V<around|(|p|)>+\<vartheta\>*I|)><rsup|\<mu\>/<around|(|2*m|)>>*\<Pi\><rsub|\<Lambda\>>*u>,
    applying Cauchy-Schwarz, and using Corollary <reference|b-qvl-c>,

    <align|<tformat|<table|<row|<cell|<frac|1|\<delta\><rsup|2>>*<around|\<\|\|\>|B<rsup|<frac|m+\<mu\>|2>>*\<Pi\><rsub|\<Lambda\>>*u|\<\|\|\>><rsup|2>>|<cell|\<leq\>C<rsub|0>*<around|(|<around|\<\|\|\>|B<rsup|<frac|\<mu\>|2>>*\<Pi\><rsub|\<Lambda\>>*u|\<\|\|\>>*<around|\<\|\|\>|B<rsup|<frac|\<mu\>|2>>*\<psi\>|\<\|\|\>>+\<vartheta\>*<around|\<\|\|\>|B<rsup|<frac|\<mu\>|2>>*\<Pi\><rsub|\<Lambda\>>*u|\<\|\|\>><rsup|2>|)>.>>>>>

    Applying an elementary inequality to the right hand side,

    <align|<tformat|<table|<row|<cell|<frac|1|\<delta\><rsup|2>>*<around|\<\|\|\>|B<rsup|<frac|m+\<mu\>|2>>*\<Pi\><rsub|\<Lambda\>>*u|\<\|\|\>><rsup|2>>|<cell|\<leq\>C<rsub|0>*<around|(|<around|\<\|\|\>|B<rsup|<frac|\<mu\>|2>>*\<Pi\><rsub|\<Lambda\>>*u|\<\|\|\>><rsup|2>+<around|\<\|\|\>|B<rsup|<frac|\<mu\>|2>>*\<psi\>|\<\|\|\>><rsup|2>+\<vartheta\>*<around|\<\|\|\>|B<rsup|<frac|\<mu\>|2>>*\<Pi\><rsub|\<Lambda\>>*u|\<\|\|\>><rsup|2>|)>.<label|smp-stp>>>>>>

    By using the Spectral Theorem and an elementary inequality, for arbitrary
    <math|\<varepsilon\>\<gtr\>0>,

    <align|<tformat|<table|<row|<cell|<around|\<\|\|\>|B<rsup|<frac|\<mu\>|2>>*\<Pi\><rsub|\<Lambda\>>*u|\<\|\|\>><rsup|2>>|<cell|=<around|\<langle\>|\<Pi\><rsub|\<Lambda\>>*u,B<rsup|\<mu\>>*\<Pi\><rsub|\<Lambda\>>*u|\<rangle\>>>>|<row|<cell|>|<cell|\<leq\>C<rsub|0>*<around|(|\<varepsilon\>*<around|\<langle\>|\<Pi\><rsub|\<Lambda\>>*u,B<rsup|m+\<mu\>>*\<Pi\><rsub|\<Lambda\>>*u|\<rangle\>>+<frac|1|\<varepsilon\><rsup|<frac|\<mu\>|m>>>*<around|\<langle\>|\<Pi\><rsub|\<Lambda\>>*u,\<Pi\><rsub|\<Lambda\>>*u|\<rangle\>>|)>>>|<row|<cell|>|<cell|\<leq\>C<rsub|0>*<around|(|\<varepsilon\>*<around|\<\|\|\>|B<rsup|<frac|m+\<mu\>|2>>*\<Pi\><rsub|\<Lambda\>>*u|\<\|\|\>><rsup|2>+<frac|1|\<varepsilon\><rsup|<frac|\<mu\>|m>>><around|\<\|\|\>|u|\<\|\|\>><rsup|2>|)>.<label|bnd-fr-sml-trm>>>>>>

    Inserting <eqref|bnd-fr-sml-trm> into <eqref|smp-stp>, and applying
    Corollary <reference|b-qvl-c>,

    <align|<tformat|<table|<row|<cell|<frac|1|\<delta\><rsup|2>>*<around|\<\|\|\>|B<rsup|<frac|m+\<mu\>|2>>*\<Pi\><rsub|\<Lambda\>>*u|\<\|\|\>><rsup|2>>|<cell|\<leq\>C<rsub|0>*<around|(|1+\<vartheta\>|)>*<around|(|\<varepsilon\>*<around|\<\|\|\>|B<rsup|<frac|m+\<mu\>|2>>*\<Pi\><rsub|\<Lambda\>>*u|\<\|\|\>><rsup|2>+<frac|1|\<varepsilon\><rsup|<frac|\<mu\>|m>>><around|\<\|\|\>|u|\<\|\|\>><rsup|2>|)>+C<rsub|0>*<around|\<\|\|\>|B<rsup|<frac|\<mu\>|2>>*\<psi\>|\<\|\|\>><rsup|2>>>|<row|<cell|>|<cell|\<less\>\<infty\>.>>>>>

    By taking <math|C<rsub|0>*\<varepsilon\>*<around|(|1+\<vartheta\>|)>\<less\>1/\<delta\><rsup|2>>,
    we have that

    <align|<tformat|<table|<row|<cell|0\<leq\><around|(|<frac|1|\<delta\><rsup|2>>-C<rsub|0>*\<varepsilon\>*<around|(|1+\<vartheta\>|)>|)>*<around|\<\|\|\>|B<rsup|<frac|m+\<mu\>|2>>*\<Pi\><rsub|\<Lambda\>>*u|\<\|\|\>><rsup|2>>|<cell|\<leq\>C<rsub|0>*<around|(|<frac|1|\<varepsilon\><rsup|<frac|\<mu\>|m>>>*<around|(|1+\<vartheta\>|)><around|\<\|\|\>|u|\<\|\|\>><rsup|2>+<around|\<\|\|\>|B<rsup|<frac|\<mu\>|2>>*\<psi\>|\<\|\|\>><rsup|2>|)>>>|<row|<cell|>|<cell|\<less\>\<infty\>.<label|rg-rslt>>>>>>

    Since the bound in <eqref|rg-rslt> is independent of <math|\<Lambda\>>,
    by taking the limit as <math|\<Lambda\>\<rightarrow\>\<infty\>> the
    result follows.
  </proof>

  We remark that we can prove the result corresponding to Lemma
  <reference|ellip> for elements of the Weyl algebra by using harmonic
  analysis on the Heisenberg group. This would slightly strengthen our result
  in <cite|N-weyl-alg>, which required that <math|u> in <eqref|pde> had more
  regularity. The proof of Lemma <reference|ellip> does not apply in this
  case, since Lemma <reference|even-bound> requires that <math|a> commute
  with all other elements of the algebra. It is an interesting open question
  to extend Lemma <reference|ellip> to elements of more general algebras,
  instead of using the Lie algebra structure.

  With Theorem <reference|ellip>, we can prove our main result.

  <\proof>
    <dueto|Proof of Theorem <reference|pos>>From Section 1.1, it suffices to
    prove that if <math|\<kappa\>\<in\>\<cal-K\><rsub|f>>, and
    <math|\<phi\>\<in\>\<cal-H\><around|(|U<rsub|\<kappa\>>|)>> satisfies

    <\equation>
      <around|\<langle\>|\<pi\><rsub|0>*<around|(|Y<rsup|m>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|c|)>*Y<rsup|m>|)>*\<phi\>,\<phi\>|\<rangle\>>=0,
    </equation>

    then <math|\<phi\>\<in\>\<cal-D\><rsup|\<infty\>><around|(|U<rsub|\<kappa\>>|)>>.

    In <cite|MR2244371>, it is shown that there is a unitary representation
    <math|V> of <math|G> on <math|\<cal-H\><rsub|0>> so that

    <\equation>
      <wide|<space|0.17em>d*V<around|(|x<rsub|k>|)>|\<bar\>>=-i<wide|\<pi\><rsub|0><around|(|Y<rsub|k*0>|)>*\<pi\><rsub|0><around|(|Y|)><rsup|-1>|\<bar\>>,
    </equation>

    <math|\<cal-D\><rsup|\<infty\>><around|(|V|)>=\<cal-D\><rsup|\<infty\>><around|(|U<rsub|\<kappa\>>|)>>,
    <math|B=\<pi\><rsub|0><around|(|Y|)><rsup|-1>>, and
    <math|<space|0.17em>d*V<around|(|c|)>\<gtr\>0>. Let
    <math|\<phi\>\<in\>\<cal-H\><around|(|V|)>> be such that
    <math|<around|\<langle\>|\<pi\><rsub|0>*<around|(|Y<rsup|m>*<space|0.17em>d*U<around|(|c|)>*Y<rsup|m>|)>*\<phi\>,\<phi\>|\<rangle\>>=0>,
    and <math|<wide|\<phi\>|~>=B<rsup|-m>*\<phi\>>. Since
    <math|<space|0.17em>d*V<around|(|c|)>> is nonnegative,

    <align|<tformat|<table|<row|<cell|<around|\<langle\>|\<pi\><rsub|0>*<around|(|Y<rsup|m>*<space|0.17em>d*U<rsub|\<kappa\>><around|(|c|)>*Y<rsup|m>|)>*\<phi\>,\<phi\>|\<rangle\>>>|<cell|=<around|\<langle\>|<space|0.17em>d*V<around|(|c|)>*<wide|\<phi\>|~>,<wide|\<phi\>|~>|\<rangle\>>>>|<row|<cell|>|<cell|=<around|\<langle\>|<space|0.17em>d*V<around|(|c|)><rsup|<frac|1|2>>*<wide|\<phi\>|~>,<space|0.17em>d*V<around|(|c|)><rsup|<frac|1|2>>*<wide|\<phi\>|~>|\<rangle\>>>>|<row|<cell|>|<cell|=<around|\<\|\|\>|<space|0.17em>d*V<around|(|c|)><rsup|<frac|1|2>>*<wide|\<phi\>|~>|\<\|\|\>>=0.>>>>>

    Therefore <math|d*V<around|(|c|)><rsup|<frac|1|2>>*<wide|\<phi\>|~>=0>,
    so that <math|d*V<around|(|c|)>*<wide|\<phi\>|~>=0>. Since
    <math|0\<in\>\<cal-D\><rsup|\<infty\>><around|(|V|)>>, it follows by
    Theorem <reference|ellip> that

    <\equation>
      <wide|\<phi\>|~>\<in\>\<cap\><rsub|l=1><rsup|\<infty\>>\<cal-D\><around|(|B<rsup|l>|)>\<equiv\>\<cal-D\><around|(|B<rsup|\<infty\>>|)>.
    </equation>

    By Lemma <reference|even-bound>, <math|\<cal-D\><rsup|\<infty\>><around|(|V|)>=\<cal-D\><around|(|B<rsup|\<infty\>>|)>>.
    We conclude from this that <math|B<rsup|m>*<wide|\<phi\>|~>=\<phi\>\<in\>D<rsup|\<infty\>><around|(|U<rsub|\<kappa\>>|)>>.
  </proof>

  <no-indent>

  <bibliography|sos-bib|>
</body>