<TeXmacs|1.99.7>

<style|<tuple|amsart|std-latex>>

<\body>
  <\hide-preamble>
    <assign|tcb|<macro|<textcolor|blue>>>

    <assign|tcr|<macro|<textcolor|red>>>

    <assign|Aut|<macro|<math-up|Aut>>>

    <assign|End|<macro|<math-up|End>>>

    <assign|Dom|<macro|<math-up|Dom>>>

    <assign|newspan|<macro|<math-up|span>>>

    <assign|clsp|<macro|<wide|<math-up|span>|\<bar\>>>>

    <assign|range|<macro|<math-up|range>>>

    <assign|supp|<macro|<math-up|supp>>>

    <assign|ker|<macro|<math-up|ker>>>

    <assign|PIsom|<macro|<math-up|PIsom>>>

    <assign|dim|<macro|<math-up|dim>>>

    <assign|ALNR|<macro|<math-up|ALNR>>>

    <assign|id|<macro|<math-up|id>>>

    <assign|iso|<macro|<math-up|iso>>>

    <assign|cov|<macro|<math-up|cov>>>

    <assign|Ind|<macro|<math-up|Ind>>>

    <assign|ind|<macro|<math-up|ind>>>

    <assign|Ad|<macro|<math-up|Ad>>>

    <assign|UHF|<macro|<math-up|UHF>>>

    <assign|sup|<macro|<math-up|sup>>>

    <assign|max|<macro|<math-up|max>>>

    <assign|min|<macro|<math-up|min>>>

    <assign|argmax|<macro|<math-up|argmax>>>

    <assign|Var|<macro|<math-up|Var>>>

    <assign|Cov|<macro|<math-up|Cov>>>

    <assign|Re|<macro|<math-up|Re>>>

    <assign|Im|<macro|<math-up|Im>>>

    <assign|var|<macro|<math-up|var>>>

    <assign|Prob|<macro|<math-up|Prob>>>

    <assign|arg|<macro|<math-up|arg>>>

    <assign|id|<macro|<math-up|id>>>

    <assign|supp|<macro|<math-up|supp>>>

    <assign|MCE|<macro|<math-up|MCE>>>

    <assign|interior|<macro|<math-up|int>>>

    <assign|Ext|<macro|<math-up|Ext>>>

    <assign|Her|<macro|<math-up|Her>>>

    <assign|tr|<macro|<math-up|tr>>>

    <assign|C|<macro|\<bbb-C\>>>

    <assign|F|<macro|\<bbb-F\>>>

    <assign|R|<macro|\<bbb-R\>>>

    <assign|N|<macro|\<bbb-N\>>>

    <assign|Z|<macro|\<bbb-Z\>>>

    <assign|T|<macro|\<bbb-T\>>>

    <assign|P|<macro|\<bbb-P\>>>

    <assign|E|<macro|\<bbb-E\>>>

    <assign|Q|<macro|\<bbb-Q\>>>

    <assign|TT|<macro|\<cal-T\>>>

    <assign|LL|<macro|\<cal-L\>>>

    <assign|OO|<macro|\<cal-O\>>>

    <assign|KK|<macro|\<cal-K\>>>

    <assign|MM|<macro|\<cal-M\>>>

    <assign|NN|<macro|\<cal-N\>>>

    <assign|BB|<macro|\<cal-B\>>>

    <assign|GG|<macro|\<cal-G\>>>

    <assign|HH|<macro|\<cal-H\>>>

    <assign|AA|<macro|\<cal-A\>>>

    <assign|XX|<macro|\<cal-X\>>>

    <assign|DD|<macro|\<cal-D\>>>

    <assign|PP|<macro|\<cal-P\>>>

    <assign|CC|<macro|\<cal-C\>>>

    <assign|RR|<macro|\<cal-R\>>>

    <assign|ZZ|<macro|\<cal-Z\>>>

    <assign|II|<macro|\<cal-I\>>>

    <assign|SS|<macro|\<cal-S\>>>

    <assign|FF|<macro|\<cal-F\>>>

    <assign|UU|<macro|\<cal-U\>>>

    <assign|MM|<macro|\<cal-M\>>>

    <assign|EE|<macro|\<cal-E\>>>

    <assign|JJ|<macro|\<cal-J\>>>

    <assign|QQ|<macro|\<cal-Q\>>>

    <assign|VV|<macro|\<cal-V\>>>

    <assign|NO|<macro|\<cal-N\>\<cal-O\>>>

    <assign|NT|<macro|\<cal-N\>\<cal-T\>>>

    <assign|FE|<macro|\<cal-F\>\<cal-E\>>>

    <assign|hatz|<macro|<wide|<Z>|^>>>

    <assign|cq|<macro|\<cal-C\><rsub|<Q>>>>

    <assign|nx|<macro|\<bbb-N\><rsup|\<times\>>>>

    <assign|inv|<macro|<rsup|-1>>>

    <assign|sn|<macro|\<cal-N\>>>

    <assign|nxnx|<macro|\<bbb-N\> \<rtimes\>\<bbb-N\><rsup|\<times\>>>>

    <assign|qxqx|<macro|\<bbb-Q\> \<rtimes\>\<bbb-Q\><rsup|*><rsub|+>>>

    <assign|qn|<macro|\<cal-Q\><rsub|<mathbb>>N>>

    <assign|tn|<macro|\<cal-T\><rsub|<nxnx>>>>

    <assign|qx|<macro|\<bbb-Q\><rsup|*><rsub|+>>>

    <assign|primes|<macro|\<cal-P\>>>

    <assign|notdiv|<macro|\<nmid\>>>

    <assign|add|<macro|<with|font-shape|right|add>>>

    <assign|mult|<macro|<with|font-shape|right|mult>>>

    <assign|CL|<macro|<with|font-shape|right|CL>>>

    <assign|labelarrow|<macro|1| <frac|<buildrel><arg|1> |\<longrightarrow\>>
    >>

    <assign|vs|<macro|<vspace|0.3cm>>>

    <new-theorem|thm|Theorem>

    <new-theorem|cor|Corollary>

    <new-theorem|res|Result>

    <new-theorem|lemma|Lemma>

    <new-theorem|prop|Proposition>

    <new-theorem|thm1|Theorem>

    <new-theorem|definition|Definition>

    <new-theorem|notation|Notation>

    <new-theorem|remark|Remark>

    <new-theorem|problem|Problem>

    <new-theorem|example|Example>

    <new-theorem|examples|Examples>

    <new-theorem|conj|Conjectures>

    <new-theorem|remarks|Remarks>
  </hide-preamble>

  <doc-data|<doc-title|Phase transition on Exel crossed
  products<next-line>associated to dilation
  matrices>|<doc-author|<author-data|<author-name|Marcelo
  Laca>>>|<doc-author|<author-data|<author-name|Iain Raeburn>>>|<doc-date|25
  January 2011>|<doc-author|<author-data|<author-name|Jacqui
  Ramagge>|<author-affiliation|Marcelo Laca, Department of Mathematics and
  Statistics<next-line>University of Victoria<next-line>Victoria, BC V8W
  3P4<next-line>Canada>|<author-email|laca@math.uvic.ca>|<author-affiliation|Iain
  Raeburn, Department of Mathematics and Statistics<next-line>University of
  Otago<next-line>PO Box 56<next-line>Dunedin 9054<next-line>New
  Zealand>|<author-email|iraeburn@maths.otago.ac.nz>|<author-affiliation|Jacqui
  Ramagge, School of Mathematics and Applied Statistics<next-line>University
  of Wollongong<next-line>NSW 2522<next-line>Australia>|<author-email|ramagge@uow.edu.au>|<author-note|This
  research was supported by the Natural Sciences and Engineering Research
  Council of Canada, by the University of Otago, and by the Australian
  Research Council.>>>>

  <abstract-data|<\abstract>
    An integer matrix <math|A\<in\>M<rsub|d><around|(|<Z>|)>> induces a
    covering <math|\<sigma\><rsub|A>> of <math|<T><rsup|d>> and an
    endomorphism <math|\<alpha\><rsub|A>:f\<mapsto\>f\<circ\>\<sigma\><rsub|A>>
    of <math|C<around|(|<T><rsup|d>|)>> for which there is a natural transfer
    operator <math|L>. In this paper, we compute the KMS states on the Exel
    crossed product <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>,L><N>>
    and its Toeplitz extension. We find that
    <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>,L><N>>
    has a unique KMS state, which has inverse temperature <math|\<beta\>=log
    <around|\||det A|\|>>. Its Toeplitz extension, on the other hand,
    exhibits a phase transition at <math|\<beta\>=log <around|\||det A|\|>>,
    and for larger <math|\<beta\>> the simplex of KMS<rsub|<math|\<beta\>>>
    states is isomorphic to the simplex of probability measures on
    <math|<T><rsup|d>>.
  </abstract>>

  <section|Introduction><label|sec:Exel>

  Actions of the real line <math|<R>> on <math|C<rsup|\<ast\>>>-algebras are
  used to describe the time evolution in physical models, and also arise in a
  wide variety of mathematical contexts. The KMS states for the action were
  originally intended to be mathematical realisations of the equilibrium
  states in statistical mechanics <cite|bra-rob>. More recently,
  mathematicians have found actions of <math|<R>> on algebras of
  number-theoretic origin that exhibit phase transitions of the sort one
  might expect in a statistical-mechanical model <cite|bos-con|laca98|lr>.
  Here we describe a similar phenomenon for the gauge action on an Exel
  crossed-product <math|C<rsup|\<ast\>>>-algebra associated to an integer
  dilation matrix <math|A>.

  An illuminating example for the analysis of KMS states is the action
  <math|\<sigma\>> lifted from the gauge action of <math|<T>> on the
  Toeplitz-Cuntz algebra <math|<TT><OO><rsub|n>> <cite|eva>. The system
  <math|<around|(|<TT><OO><rsub|n>,\<sigma\>|)>> has a single KMS state for
  each inverse temperature <math|\<beta\>\<geq\>log n>, but only the one at
  <math|\<beta\>=log n> factors through the purely infinite simple quotient
  <math|<OO><rsub|n>> (see, for example, <cite-detail|ln|Example<nbsp>2.8>) .
  Our situation is similar: the Exel crossed product is purely infinite
  simple and has a unique KMS state, which has inverse temperature
  <math|\<beta\>=log <around|\||det A|\|>>, whereas its Toeplitz analogue has
  KMS<rsub|<math|\<beta\>>> states for all <math|\<beta\>\<geq\>log
  <around|\||det A|\|>>. Here, though, the simplex of
  KMS<rsub|<math|\<beta\>>> states is large for <math|\<beta\>\<gtr\>log
  <around|\||det A|\|>>, and we have a phase transition at <math|\<beta\>=log
  <around|\||det A|\|>>.

  Before stating our results more precisely, we set up some notation. We
  consider a matrix <math|A\<in\>M<rsub|d><around|(|<Z>|)>> with nonzero
  determinant, and write <math|\<sigma\><rsub|A>> for the associated
  self-covering of <math|<T><rsup|d>=<R><rsup|d>/<Z><rsup|d>>. Then
  <math|\<alpha\><rsub|A>:f\<mapsto\>f\<circ\>\<sigma\><rsub|A>> is an
  endomorphism of <math|C<around|(|<T><rsup|d>|)>>,

  <\equation>
    <label|defL>L<around|(|f|)><around|(|z|)>=<frac|1|<around|\||det
    A|\|>>*<big|sum><rsub|\<sigma\><rsub|A><around|(|w|)>=z>f<around|(|w|)>
  </equation>

  defines a transfer operator <math|L> for <math|\<alpha\><rsub|A>>, and the
  triple <math|<around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>> is
  one of the Exel systems studied in <cite|ehr>. We write <math|M<rsub|L>>
  for the associated right-Hilbert bimodule over
  <math|C<around|(|<T><rsup|d>|)>>, which has underlying space
  <math|C<around|(|<T><rsup|d>|)>>, actions defined by
  <math|f\<cdot\>m\<cdot\>g=f*m*\<alpha\><rsub|A><around|(|g|)>>, and inner
  product defined by <math|<around|\<langle\>|m,n|\<rangle\>>=L*<around|(|m<rsup|\<ast\>>*n|)>>.
  We write <math|\<phi\>> for the homomorphism of
  <math|C<around|(|<T><rsup|d>|)>> into <math|<LL><around|(|M<rsub|L>|)>>
  which implements the left action.

  If <math|\<Sigma\>> is a set of coset representatives for
  <math|<Z><rsup|d>/A<rsup|t><Z><rsup|d>>, then the characters
  <math|<around|{|\<gamma\><rsub|m>:z\<mapsto\>z<rsup|m><space|0.27em>:<space|0.27em>m\<in\>\<Sigma\>|}>>,
  viewed as continuous functions on <math|<T><rsup|d>> and hence as elements
  of <math|M<rsub|L>>, form an orthonormal basis for <math|M<rsub|L>> (this
  observation is due to Packer and Rieffel <cite|pr>, and a proof consistent
  with our notation is given in <cite-detail|ehr|Lemma<nbsp>2.6>). The
  reconstruction formula for this basis implies that
  <math|\<phi\><around|(|f|)>> is the finite-rank operator
  <math|<big|sum><rsub|m>\<Theta\><rsub|f\<cdot\>\<gamma\><rsub|m>,\<gamma\><rsub|m>>>
  for every <math|f\<in\>C<around|(|<T><rsup|d>|)>>. Then since
  <math|\<alpha\><rsub|A>> is unital, the results of <cite|br> imply that
  Exel's Toeplitz algebra <math|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>>
  is the Toeplitz algebra <math|<TT><around|(|M<rsub|L>|)>>, and that the
  Exel crossed product <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>,L><N>>
  is isomorphic to the Cuntz-Pimsner algebra
  <math|<OO><around|(|M<rsub|L>|)>>.

  The Toeplitz algebra <math|<TT><around|(|M|)>> of a Hilbert bimodule
  <math|M> over <math|C> is generated by a universal representation
  <math|<around|(|i<rsub|M>,i<rsub|C>|)>> of <math|M>, and carries a gauge
  action of <math|<T>> characterised by <math|\<gamma\><rsub|z><around|(|i<rsub|M><around|(|m|)>|)>=z*i<rsub|M><around|(|m|)>>
  and <math|\<gamma\><rsub|z><around|(|i<rsub|C><around|(|c|)>|)>=i<rsub|C><around|(|c|)>>;
  this action descends to the Cuntz-Pimsner algebra
  <math|<around|(|<OO><around|(|M|)>,j<rsub|M>,j<rsub|C>|)>>. The gauge
  actions inflate to actions <math|\<sigma\>> of <math|<R>> which are
  characterised by

  <align|<tformat|<table|<row|<cell|<label|defdynamics>>|<cell|\<sigma\><rsub|t>\<circ\>i<rsub|C>=i<rsub|C>*<text|and
  >\<sigma\><rsub|t><around|(|i<rsub|M><around|(|m|)>|)>=e<rsup|i*t>*i<rsub|M><around|(|m|)>,<text|and
  >>>|<row|<cell|>|<cell|\<sigma\><rsub|t>\<circ\>j<rsub|C>=j<rsub|C>*<text|and
  >\<sigma\><rsub|t><around|(|j<rsub|M><around|(|m|)>|)>=e<rsup|i*t>*j<rsub|M><around|(|m|)>.>>>>>

  Our goal is the following description of the KMS states of
  <math|<around|(|<TT><around|(|M<rsub|L>|)>,\<sigma\>|)>> and
  <math|<around|(|<OO><around|(|M<rsub|L>|)>,\<sigma\>|)>>.

  <\thm>
    <label|summary>Suppose that <math|A\<in\>M<rsub|d><around|(|<Z>|)>> has
    nonzero determinant, <math|<around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>>
    is the associated Exel system, and <math|\<sigma\>> denotes the action of
    <math|<R>> on <math|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>>
    satisfying <eqref|defdynamics>.

    <vspace|0.5fn><text|(a)> There are no KMS<rsub|<math|\<beta\>>> states on
    <math|<around|(|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>,\<sigma\>|)>>
    unless <math|\<beta\>\<geq\>log <around|\||det A|\|>>.

    <vspace|0.5fn><text|(b)> For each <math|\<beta\>\<in\><around|(|log
    <around|\||det A|\|>,\<infty\>|]>>, the simplex of
    KMS<rsub|<math|\<beta\>>> states on <math|<around|(|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>,\<sigma\>|)>>
    is affinely homeomorphic to the simplex <math|P<around|(|<T><rsup|d>|)>>
    of probability measures on <math|<T><rsup|d>>.

    <vspace|0.5fn><text|(c)> If <math|A> is a dilation matrix, then
    <math|<around|(|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>,\<sigma\>|)>>
    has a unique KMS<rsub|<math|log <around|\||det A|\|>>> state, and this
    state factors through the quotient map

    <\equation*>
      Q:<around|(|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>,\<sigma\>|)>\<to\><around|(|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\>,L><N>,\<sigma\>|)>.
    </equation*>

    <text|(d)> Every ground state of <math|<around|(|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>,\<sigma\>|)>>
    is a KMS<rsub|<math|\<infty\>>> state.
  </thm>

  After a short review of notation and coventions, we begin in
  <reference|sec-pres> by giving presentations of
  <math|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>> and
  <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\>,L><N>> in terms of
  a unitary repesentation <math|u> of <math|<Z><rsup|d>> and an isometry
  <math|v> which, loosely, implements the action <math|\<alpha\><rsub|A>>.
  Then in <reference|sec-charKMS>, we characterise the KMS states of
  <math|<around|(|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>,\<sigma\>|)>>
  in terms of their behaviour with respect to the presentation in
  <reference|sec-pres>.

  We then set about proving Theorem<nbsp><reference|summary> in stages, and
  we give more precise formulations of our results as we go. For example, we
  prove part (c) in <reference|sec-Exelcp>, and we prove a little more than
  we stated above: we only need to assume that <math|A> is a dilation matrix
  to get uniqueness of the KMS<rsub|<math|log <around|\||det A|\|>>> state.
  In <reference|sec-existence>, we prove existence of lots of KMS states
  (see Proposition<nbsp><reference|existforbeta\<gtr\>1>); a novelty in our
  construction is the use of induced representations to build Hilbert spaces
  where we can construct KMS states from vector states. Then in
  <reference|sec-par>, we prove that we have found all the
  KMS<rsub|<math|\<beta\>>> states for <math|\<beta\>\<gtr\>log
  <around|\||det A|\|>>. In <reference|sec-ground>, we prove part (d).

  Theorem<nbsp><reference|summary> and our strategy for proving it were
  motivated by our previous work in <cite|lr>, or more precisely, by what it
  says about the KMS states of the additive boundary quotient
  <math|<around|(|<TT><rsub|<add>><around|(|<nxnx>|)>,\<sigma\>|)>> of the
  Toeplitz algebra <math|<TT><around|(|<nxnx>|)>> (see
  <cite-detail|BaHLR|4>). The connection with Exel crossed products is made
  in <cite-detail|BaHLR|5>, where it is shown that there is an Exel system
  <math|<around|(|C<around|(|<T>|)>,\<alpha\>,L,<nx>|)>> of the kind studied
  in <cite|l> whose Nica-Toeplitz crossed product
  <math|<NT><around|(|C<around|(|<T>|)>,\<alpha\>,L,<nx>|)>> is
  <math|<TT><rsub|<add>><around|(|<nxnx>|)>> and whose Exel crossed product
  <math|C<around|(|<T>|)>\<rtimes\><rsub|\<alpha\>,L><nx>> is the Crisp-Laca
  boundary quotient of <math|<TT><around|(|<nxnx>|)>> (or in other words,
  Cuntz's <math|<QQ><rsub|<N>>> <cite|c2>). So our present analysis differs
  from that in <cite|lr> in that we have raised the dimension of the torus to
  <math|d>, but have replaced <math|<nx>\<cong\><N><rsup|\<infty\>>> by
  <math|<N>>. The case <math|d=1>, where <math|A> has the form
  <math|<around|(|N|)>>, is in some sense an intersection of our results with
  those in <cite|lr>, and in <reference|BSsemigp> we carry out an analysis
  of the KMS states on <math|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>>
  parallel to that in <cite-detail|BaHLR|4>.

  We close in <reference|sec-gpalgs> with a discussion of the case where
  <math|A> is invertible over <math|<Z>>. The endomorphism
  <math|\<alpha\><rsub|A>> is then an automorphism, and
  <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>,L><N>> is
  the usual crossed product <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>><Z>>,
  which can also be viewed as a group algebra
  <math|C<rsup|\<ast\>>*<around|(|<Z><rsup|d>\<rtimes\><rsub|A<rsup|t>><Z>|)>>.
  We know from <reference|sec-Exelcp> that there can only be
  KMS<rsub|<math|\<beta\>>> states when <math|\<beta\>=log <around|\||det
  A|\|>=0>, so we are left to determine the invariant traces, which we do in
  Proposition<nbsp><reference|invtr>. When
  <math|<Z><rsup|d>\<rtimes\><rsub|A<rsup|t>><Z>> is the integer Heisenberg
  group, for example, we can find lots of invariant traces.

  <section|Notation and coventions>

  <subsection|Integer matrices.>

  Throughout this paper <math|A> is a matrix in
  <math|M<rsub|d><around|(|<Z>|)>> whose determinant <math|det A> is nonzero.
  If the eigenvalues <math|\<lambda\>> of
  <math|A\<in\>M<rsub|d><around|(|<Z>|)>> all satisfy
  <math|<around|\||\<lambda\>|\|>\<gtr\>1>, then we call <math|A> a
  <em|dilation matrix>. This was a standing assumption in <cite|ehr>, but
  here we do not in general assume that <math|A> is a dilation matrix. We use
  multiindex notation, so that <math|e<rsup|2*\<pi\>*i*x>=<around|(|e<rsup|2*\<pi\>*i*x<rsub|1>>,\<cdots\>,e<rsup|2*\<pi\>*i*x<rsub|d>>|)>>
  for <math|x\<in\><R><rsup|d>>, and the covering map
  <math|\<sigma\><rsub|A>:<T><rsup|d>\<to\><T><rsup|d>> is characterised by
  <math|\<sigma\><rsub|A><around|(|e<rsup|2*\<pi\>*i*x>|)>=e<rsup|2*\<pi\>*i*A*x>>
  for <math|x\<in\><R><rsup|d>>. Since the transpose <math|A<rsup|t>> appears
  more often than <math|A>, we write <math|B\<assign\>A<rsup|t>>; we have
  tried to avoid using the letters <math|A> and <math|B> for anything else.
  We choose a set <math|\<Sigma\>> of coset representatives for
  <math|<Z><rsup|d>/B<Z><rsup|d>>, and assume for convenience that
  <math|0\<in\>\<Sigma\>>. We sometimes write <math|N> for
  <math|<around|\||det A|\|>=<around|\||det B|\|>>.

  <subsection|Hilbert bimodules>

  A bimodule <math|M> over a <math|C<rsup|\<ast\>>>-algebra <math|C> is a
  right-Hilbert bimodule if it is a right Hilbert <math|C>-module, and if the
  left action of <math|C> is implemented by a homomorphism <math|\<phi\>> of
  <math|C> into the <math|C<rsup|\<ast\>>>-algebra <math|<LL><around|(|M|)>>
  of adjointable operators. (Such bimodules are also called
  \Pcorrespondences\Q over <math|C>, or just \PHilbert bimodules\Q for
  short.) Our <math|C<rsup|\<ast\>>>-algebras will always have identities,
  and our bimodules are always essential in the sense that
  <math|\<phi\>:C\<to\><LL><around|(|M|)>> is unital.

  A representation<footnote|These are often called Toeplitz representations,
  but we now believe this to have been an unfortunate choice of name (see
  <cite-detail|BaHLR|Remark<nbsp>5.3>).> <math|<around|(|\<psi\>,\<pi\>|)>>
  of a Hilbert bimodule <math|M> in a <math|C<rsup|\<ast\>>>-algebra <math|D>
  consists of a linear map <math|\<psi\>:M\<to\>D> and a unital
  representation <math|\<pi\>:C\<to\>D> such that

  <\equation*>
    \<psi\>*<around|(|c<rsub|1>\<cdot\>m\<cdot\>c<rsub|2>|)>=\<pi\><around|(|c<rsub|1>|)>*\<psi\><around|(|m|)>*\<pi\><around|(|c<rsub|2>|)>*<text|and
    >\<pi\><around|(|<around|\<langle\>|m,n|\<rangle\>>|)>=\<psi\><around|(|m|)><rsup|\<ast\>>*\<psi\><around|(|n|)>.
  </equation*>

  Every Hilbert bimodule <math|M> has a Toeplitz algebra
  <math|<TT><around|(|M|)>>, which is generated by a universal representation
  <math|<around|(|i<rsub|M>,i<rsub|C>|)>>.

  Every representation <math|<around|(|\<psi\>,\<pi\>|)>> of <math|M> in
  <math|D> induces a representation <math|<around|(|\<psi\>,\<pi\>|)><rsup|<around|(|1|)>>:<KK><around|(|M|)>\<to\>D>
  such that <math|<around|(|\<psi\>,\<pi\>|)><rsup|<around|(|1|)>><around|(|\<Theta\><rsub|m,n>|)>=\<psi\><around|(|m|)>*\<psi\><around|(|n|)><rsup|\<ast\>>>
  (see <cite-detail|p|page<nbsp>202> or <cite-detail|fr|Proposition<nbsp>1.6>).
  The representation <math|<around|(|\<psi\>,\<pi\>|)>> is Cuntz-Pimsner
  covariant if

  <\equation*>
    <around|(|\<psi\>,\<pi\>|)><rsup|<around|(|1|)>><around|(|\<phi\><around|(|a|)>|)>=\<pi\><around|(|a|)>*<text|whenever
    >\<phi\><around|(|a|)>\<in\><KK><around|(|M|)>.
  </equation*>

  The Cuntz-Pimsner algebra <math|<OO><around|(|M|)>> is the quotient of
  <math|<TT><around|(|M|)>> that is universal for Cuntz-Pimsner covariant
  representations. We write <math|Q:<TT><around|(|M|)>\<to\><OO><around|(|M|)>>
  for the quotient map, and <math|<around|(|j<rsub|M>,j<rsub|C>|)>\<assign\><around|(|Q\<circ\>i<rsub|M>,Q\<circ\>i<rsub|C>|)>>
  for the universal Cuntz-Pimser covariant representation in
  <math|<OO><around|(|M|)>>. (Though there are several different definitions
  of Cuntz-Pimsner covariance out there, they all coincide for the bimodules
  in this paper.)

  <subsection|Exel crossed products>

  An Exel system consists of an endomorphism <math|\<alpha\>> of a
  <math|C<rsup|\<ast\>>>-algebra <math|C>, and a transfer operator <math|L>
  for <math|\<alpha\>>, which is a bounded positive linear map
  <math|L:C\<to\>C> such that <math|L*<around|(|\<alpha\><around|(|c|)>*d|)>=c*L<around|(|d|)>>.
  The examples of interest here are the systems
  <math|<around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>> discussed
  in the introduction, where <math|\<alpha\><rsub|A>> is the endomorphism
  <math|f\<mapsto\>f\<circ\>\<sigma\><rsub|A>> associated to an integer
  matrix <math|A>, and <math|L> is defined by averaging over inverse images
  of points, as in <eqref|defL>. Notice that both <math|\<alpha\>> and
  <math|L> are unital.

  Every Exel system <math|<around|(|C,\<alpha\>,L|)>> gives rise to a Hilbert
  bimodule over <math|C> as follows. We first make a copy <math|C<rsub|L>> of
  <math|C> into a bimodule over <math|C> by setting <math|c\<cdot\>m=c*m> and
  <math|m\<cdot\>c=m*\<alpha\><around|(|c|)>> for <math|m\<in\>C<rsub|L>> and
  <math|c\<in\>C>. The formula <math|<around|\<langle\>|m,n|\<rangle\>>\<assign\>L*<around|(|m<rsup|\<ast\>>*n|)>>
  carries a <math|C>-valued pre-inner product on <math|C<rsub|L>>, and
  completing <math|C<rsub|L>> gives a right Hilbert <math|C>-module
  <math|M<rsub|L>>. Because <math|L> is bounded, the left action of <math|C>
  extends to an action of <math|C> by adjointable operators on the completion
  <math|M<rsub|L>>. (The details are in <cite-detail|br|3>.) In general the
  completion process involves modding out by vectors of length zero, so that
  the quotient carries a <math|C>-valued inner product. However, for the
  systems <math|<around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>>,
  the module <math|C<around|(|<T><rsup|d>|)>> has no vectors of length zero
  and is already complete (see <cite-detail|LR2|Lemma<nbsp>3.3>). So we
  dispense with the quotient maps <math|q:C<rsub|L>\<to\>M<rsub|L>> which
  were used in <cite|br> to distinguish between elements of the algebra and
  elements of the bimodule.

  For an Exel system <math|<around|(|C,\<alpha\>,L|)>>, we define the
  Toeplitz algebra <math|<TT><around|(|C,\<alpha\>,L|)>> to be
  <math|<TT><around|(|M<rsub|L>|)>>, and the Exel crossed product
  <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>,L><N>> to
  be the Cuntz-Pimsner algebra <math|<OO><around|(|M<rsub|L>|)>>. This is not
  quite Exel's original definition <cite|e1>, but for the systems
  <math|<around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>> of
  interest to us it is equivalent. (The precise relationship between Exel's
  crossed product and Cuntz-Pimsner algebras is worked out in
  <cite-detail|br|3>.) So <math|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>>
  and <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>,L><N>>
  are generated by universal representations
  <math|<around|(|i<rsub|M<rsub|L>>,i<rsub|C<around|(|<T><rsup|d>|)>>|)>> and
  <math|<around|(|j<rsub|M<rsub|L>>,j<rsub|C<around|(|<T><rsup|d>|)>>|)>>.

  <subsection|KMS states>

  Suppose that <math|\<sigma\>> is an action of <math|<R>> by automorphisms
  of a <math|C<rsup|\<ast\>>>-algebra <math|C>. An element <math|c> of
  <math|C> is analytic if <math|t\<mapsto\>\<sigma\><rsub|t><around|(|c|)>>
  is the restriction of an entire function. A state <math|\<phi\>> of
  <math|C> is a KMS state at inverse temperature
  <math|\<beta\>\<in\><around|(|0,\<infty\>|)>> if there is a set <math|S> of
  analytic elements such that <math|<newspan>S> is dense in <math|C> and

  <\equation*>
    \<phi\>*<around|(|d*c|)>=\<phi\>*<around|(|c*\<sigma\><rsub|i*t><around|(|d|)>|)><text|for
    <math|c,d\<in\>S>.>
  </equation*>

  In <cite-detail|lr|7>, we were careful to explain why this definition is
  equivalent to that used in the standard sources <cite|bra-rob> and
  <cite|ped>. We also adopt two more recent conventions which are possibly
  nonstandard. First, we regard the KMS<rsub|<math|0>> states to be the
  <em|<math|\<sigma\>>-invariant> traces; this agrees with the convention in
  <cite|ped> rather than the one in <cite|bra-rob>. Second, we use the
  conventions of Connes and Marcolli <cite|cm>, which distinguish between the
  KMS<rsub|<math|\<infty\>>> states (those which are weak* limits of
  KMS<rsub|<math|\<beta\>>> states as <math|\<beta\>\<to\>\<infty\>>) and the
  ground states (those such that <math|z\<mapsto\>\<phi\>*<around|(|c*\<sigma\><rsub|z><around|(|d|)>|)>>
  is bounded on the upper half-plane). Neither <cite|bra-rob> nor <cite|ped>
  makes this distinction.

  <section|A presentation><label|sec-pres>

  We describe a presentation of the Toeplitz algebra
  <math|<TT><around|(|M<rsub|L>|)>> like that of
  <math|<TT><around|(|<nxnx>|)>> in <cite-detail|lr|Theorem<nbsp>4.1>, or,
  more precisely, like that of the additive boundary quotient
  <math|<TT><rsub|<add>><around|(|<nxnx>|)>> in
  <cite-detail|BaHLR|Proposition<nbsp>3.3>.

  <\prop>
    <label|presadd>Suppose that <math|A\<in\>M<rsub|d><around|(|<Z>|)>> has
    <math|det A\<neq\>0>, and consider the Exel system
    <math|<around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>>. Then
    the Toeplitz algebra <math|<TT><around|(|M<rsub|L>|)>> is the universal
    <math|C<rsup|\<ast\>>>-algebra generated by a unitary representation
    <math|u:<Z><rsup|d>\<to\>U<around|(|<TT><around|(|M<rsub|L>|)>|)>> and an
    isometry <math|v\<in\><TT><around|(|M<rsub|L>|)>> satisfying

    <\itemize>
      <item*|(E1)><math|v*u<rsub|m>=u<rsub|B*m>*v>, and <vspace|0.5fn>

      <item*|(E2)><math|v<rsup|\<ast\>>*u<rsub|m>*v=<choice|<tformat|<table|<row|<cell|u<rsub|B<rsup|-1>*m>>|<cell|<text|if
      ><math|m\<in\>B<Z><rsup|d>>>>|<row|<cell|0>|<cell|<text|otherwise.>>>>>>>
    </itemize>

    If <math|U> is a unitary representation of <math|<Z><rsup|d>> in a
    <math|C<rsup|\<ast\>>>-algebra <math|C> and <math|V\<in\>C> is an
    isometry satisfying <text|(E1)> and <text|(E2)>, then the corresponding
    representation <math|<around|(|\<psi\>,\<pi\>|)>> of <math|M<rsub|L>>
    satisfies <math|U<rsub|m>=\<pi\><around|(|\<gamma\><rsub|m>|)>> and
    <math|V=\<psi\><around|(|1|)>>.
  </prop>

  <\remark>
    It might be helpful to see how our presentation is related to the
    presentation of <math|<TT><rsub|<add>><around|(|<nxnx>|)>> in
    <cite|BaHLR>. The isometries <math|<around|{|v<rsub|p>:p\<in\><primes>|}>>
    have become the single isometry <math|v>, and the additive generator
    <math|s> has been replaced by the unitary representation <math|u> of the
    additive group <math|<Z><rsup|d>>. The relations (T2) and (T3) in
    <cite-detail|BaHLR|Proposition<nbsp>3.3> are not needed because here \Pwe
    only have one prime\Q (which we will normalise to <math|e> when we define
    our dynamics!), and the relation (Q6) in
    <cite-detail|BaHLR|Proposition<nbsp>3.3> is replaced by the assumption
    that <math|u> is a unitary representation. So we are left with (T1) and
    (T5), which are analogous to (E1) and (E2) respectively.

    The relation (E2) implies that <math|<around|{|u<rsub|m>*v:m\<in\>\<Sigma\>|}>>
    is a Toeplitz-Cuntz family. The analogue of the relation (Q5) used in
    <cite|lr> and <cite|BaHLR> is the Cuntz relation

    <\itemize>
      <item*|(E3)><math|1=<big|sum><rsub|m\<in\>\<Sigma\>><around|(|u<rsub|m>*v|)>*<around|(|u<rsub|m>*v|)><rsup|\<ast\>>>,
    </itemize>

    which is satisfied in the Cuntz-Pimsner algebra
    <math|<OO><around|(|M<rsub|L>|)>> (see
    Proposition<nbsp><reference|CPquotient> below).
  </remark>

  <\proof>
    <dueto|Proof of Proposition<nbsp><reference|presadd>>The Toeplitz algebra
    <math|<TT><around|(|M<rsub|L>|)>> is generated by a universal
    representation <math|<around|(|i<rsub|M<rsub|L>>,i<rsub|C<around|(|<T><rsup|d>|)>>|)>>.
    It is shown in <cite-detail|br|Corollary<nbsp>3.3> that
    <math|<TT><around|(|M<rsub|L>|)>> is generated by the range of
    <math|i<rsub|C<around|(|<T><rsup|d>|)>>> and the single element
    <math|S\<assign\>i<rsub|M<rsub|L>><around|(|1|)>>, that
    <math|<around|(|i<rsub|C<around|(|<T><rsup|d>|)>>,S|)>> is a
    Toeplitz-covariant representation in the sense of
    <cite-detail|br|Definition<nbsp>3.1>, and that
    <math|<around|(|<TT><around|(|M<rsub|L>|)>,i<rsub|C<around|(|<T><rsup|d>|)>>,S|)>>
    is universal for Toeplitz-covariant representations
    <math|<around|(|\<rho\>,V|)>> satisfying

    <\itemize>
      <item*|(TC1)><math|V*\<rho\><around|(|a|)>=\<rho\><around|(|\<alpha\><rsub|A><around|(|a|)>|)>*V>,
      and<label|TCrels> <vspace|0.5fn>

      <item*|(TC2)><math|V<rsup|\<ast\>>*\<rho\><around|(|a|)>*V=\<rho\><around|(|L<around|(|a|)>|)>>.
    </itemize>

    In our system <math|L<around|(|1|)>=1>, and (TC2) implies that the
    operator <math|V> is an isometry.

    The Stone-Weierstrass theorem implies that the characters
    <math|\<gamma\><rsub|m>:z\<mapsto\>z<rsup|m>> of <math|<T><rsup|d>> span
    a dense <math|\<ast\>>-subalgebra of <math|C<around|(|<T><rsup|d>|)>>,
    and a representation <math|\<rho\>> of <math|C<around|(|<T><rsup|d>|)>>
    is completely determined by the unitary representation
    <math|u:m\<mapsto\>\<rho\><around|(|\<gamma\><rsub|m>|)>> of
    <math|<Z><rsup|d>>. One checks that <math|\<alpha\><rsub|A><around|(|\<gamma\><rsub|m>|)>=\<gamma\><rsub|B*m>>,
    so (TC1) is equivalent to (E1). We will complete the proof by showing
    that (TC2) is equivalent to (E2).

    To see what (TC2) says about the <math|u<rsub|m>>, we need to compute
    <math|L<around|(|\<gamma\><rsub|m>|)>>. For any
    <math|f\<in\>C<around|(|<T><rsup|d>|)>> and
    <math|z=e<rsup|2*\<pi\>*i*x>\<in\><T><rsup|d>>, we can compute
    <math|L<around|(|f|)><around|(|z|)>> by choosing one solution
    <math|w<rsub|0>> of <math|\<sigma\><rsub|A><around|(|w|)>=z>, such as
    <math|w<rsub|0>=e<rsup|2*\<pi\>*i*A<rsup|-1>*x>>, and computing

    <\equation*>
      L<around|(|f|)><around|(|e<rsup|2*\<pi\>*i*x>|)>=<frac|1|<around|\||det
      A|\|>>*<big|sum><rsub|w\<in\>ker\<sigma\><rsub|A>>f*<around|(|w*w<rsub|0>|)>,
    </equation*>

    and hence

    <\equation*>
      L<around|(|\<gamma\><rsub|m>|)><around|(|e<rsup|2*\<pi\>*i*x>|)>=<frac|1|<around|\||det
      A|\|>>*\<gamma\><rsub|m><around|(|e<rsup|2*\<pi\>*i*A<rsup|-1>*x>|)>*<big|sum><rsub|w\<in\>ker\<sigma\><rsub|A>>\<gamma\><rsub|m><around|(|w|)>.
    </equation*>

    If <math|\<gamma\><rsub|m>\|<rsub|ker\<sigma\><rsub|A>>> is not the
    identity character, then <math|<around|{|\<gamma\><rsub|m><around|(|w|)>:w\<in\>ker\<sigma\><rsub|A>|}>>
    is a nontrivial subgroup of <math|<T>>, the sum is zero, and
    <math|L<around|(|\<gamma\><rsub|m>|)>=0>. So
    <math|L<around|(|\<gamma\><rsub|m>|)>\<neq\>0\<Longleftrightarrow\>\<gamma\><rsub|m>\<in\><around|(|ker\<sigma\><rsub|A>|)><rsup|\<perp\>>>,
    and for such <math|m>, <math|L<around|(|\<gamma\><rsub|m>|)><around|(|e<rsup|2*\<pi\>*i*x>|)>=\<gamma\><rsub|m><around|(|e<rsup|2*\<pi\>*i*A<rsup|-1>*x>|)>=\<gamma\><rsub|B<rsup|-1>*m><around|(|e<rsup|2*\<pi\>*i*x>|)>>.
    Now

    <align*|<tformat|<table|<row|<cell|\<gamma\><rsub|m>\<in\><around|(|ker\<sigma\><rsub|A>|)><rsup|\<perp\>>>|<cell|\<Longleftrightarrow\>e<rsup|2*\<pi\>*i*m<rsup|t>*A<rsup|-1>*n>=1*<text|for
    all >n\<in\><Z><rsup|d>>>|<row|<cell|>|<cell|\<Longleftrightarrow\>e<rsup|2*\<pi\>*i*<around|(|B<rsup|-1>*m|)><rsup|t>*n>=1*<text|for
    all >n\<in\><Z><rsup|d>>>|<row|<cell|>|<cell|\<Longleftrightarrow\>m\<in\>B<Z><rsup|d>.>>>>>

    Thus

    <\equation*>
      L<around|(|\<gamma\><rsub|m>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      >m\<in\>B<Z><rsup|d>>>|<row|<cell|\<gamma\><rsub|B<rsup|-1>*m>>|<cell|<text|if
      <math|m\<in\>B<Z><rsup|d>>,>>>>>>
    </equation*>

    and using this we can see that (TC2) is equivalent to (E2).

    For the last comment, recall from <cite-detail|br|2> that the
    representation <math|<around|(|\<psi\>,\<pi\>|)>> corresponding to the
    Toeplitz-covariant representation <math|<around|(|\<rho\>,V|)>> in the
    above argument is characterised by <math|\<pi\>=\<rho\>> and
    <math|V=\<psi\><around|(|1|)>>, and that <math|\<rho\>> satisfies
    <math|\<rho\><around|(|\<gamma\><rsub|m>|)>=u<rsub|m>>.
  </proof>

  We now want an analogous presentation of <math|<OO><around|(|M<rsub|L>|)>>.
  To help keep things straight later, we write
  <math|<wide|u|\<bar\>>\<assign\>Q\<circ\>u> and
  <math|<wide|v|\<bar\>>\<assign\>Q<around|(|v|)>>.

  <\prop>
    <label|CPquotient>Suppose that <math|A\<in\>M<rsub|d><around|(|<Z>|)>>
    has <math|det A\<neq\>0>, and consider the Exel system
    <math|<around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,L|)>>. Then
    the Cuntz-Pimsner algebra <math|<OO><around|(|M<rsub|L>|)>> is the
    universal <math|C<rsup|\<ast\>>>-algebra generated by a unitary
    representation <math|<wide|u|\<bar\>>:<Z><rsup|d>\<to\>U<around|(|<OO><around|(|M<rsub|L>|)>|)>>
    and an isometry <math|<wide|v|\<bar\>>\<in\><OO><around|(|M<rsub|L>|)>>
    satisfying <text|(E1)>, <text|(E2)> and <text|(E3)>.
  </prop>

  <\proof>
    We need to prove that the unitary representation <math|<wide|u|\<bar\>>>
    and the isometry <math|<wide|v|\<bar\>>> satisfy (E1\U3) and are
    universal for families satisfying these relations. They satisfy (E1) and
    (E2) because <math|u> and <math|v> do. To see that they satisfy (E3),
    note that the unitary <math|u<rsub|m>> in
    Proposition<nbsp><reference|presadd> is
    <math|i<rsub|C<around|(|<T><rsup|d>|)>><around|(|\<gamma\><rsub|m>|)>>
    and the isometry <math|v> is <math|i<rsub|M<rsub|L>><around|(|1|)>>. We
    know from <cite-detail|ehr|Lemma<nbsp>2.6> that
    <math|<around|{|\<gamma\><rsub|m>:m\<in\>\<Sigma\>|}>> is an orthonormal
    basis for <math|M<rsub|L>>, so Lemma<nbsp>2.5 of <cite|ehr> says that a
    representation <math|<around|(|\<psi\>,\<pi\>|)>> is Cuntz-Pimsner
    covariant if and only if

    <\equation>
      <label|CPcovgeneral>1=<big|sum><rsub|m\<in\>\<Sigma\>>\<psi\><around|(|\<gamma\><rsub|m>|)>*\<psi\><around|(|\<gamma\><rsub|m>|)><rsup|\<ast\>>.
    </equation>

    Since <math|\<gamma\><rsub|m>=\<gamma\><rsub|m>\<cdot\>1> in
    <math|M<rsub|L>>, we have

    <\equation>
      <label|checkCP>Q\<circ\>i<rsub|M<rsub|L>><around|(|\<gamma\><rsub|m>|)>=Q\<circ\>i<rsub|C<around|(|<T><rsup|d>|)>><around|(|\<gamma\><rsub|m>|)>*Q\<circ\>i<rsub|M<rsub|L>><around|(|1|)>=Q<around|(|u<rsub|m>|)>*Q<around|(|v|)>,
    </equation>

    and Equation<nbsp><eqref|CPcovgeneral> for
    <math|<around|(|Q\<circ\>i<rsub|M<rsub|L>>,Q\<circ\>i<rsub|C<around|(|<T><rsup|d>|)>>|)>>
    reduces to (E3) for <math|Q\<circ\>u> and <math|Q<around|(|v|)>>.

    Next suppose that <math|U<rsub|m>> and <math|V> satisfy (E1), (E2) and
    (E3). Then Proposition<nbsp><reference|presadd> gives a representation
    <math|<around|(|\<psi\>,\<pi\>|)>> of <math|M<rsub|L>> such that
    <math|U<rsub|m>=\<pi\><around|(|\<gamma\><rsub|m>|)>> and
    <math|V=\<psi\><around|(|1|)>>, and, in view of <eqref|checkCP>, (E3)
    implies that <math|\<psi\>> satisfies Equation<nbsp><eqref|CPcovgeneral>.
    Thus <math|<around|(|\<psi\>,\<pi\>|)>> is Cuntz-Pimsner covariant, and
    hence factors through a representation of
    <math|<OO><around|(|M<rsub|L>|)>>, and this representation takes
    <math|<wide|u|\<bar\>><rsub|m>=Q<around|(|u<rsub|m>|)>> to
    <math|U<rsub|m>> and <math|<wide|v|\<bar\>>=Q<around|(|v|)>> to <math|V>
    because <math|\<psi\>\<times\>\<pi\>> takes <math|u<rsub|m>> to
    <math|U<rsub|m>> and <math|v> to <math|V>.
  </proof>

  Next we want a convenient spanning family to do calculations with. Again,
  we are looking for something similar to what we used in <cite|lr>.

  <\lemma>
    In <math|<TT><around|(|M<rsub|L>|)>> we have

    <\equation>
      <around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>*<around|(|u<rsub|p>*v<rsup|i>*v<rsup|\<ast\>j>*u<rsub|q><rsup|\<ast\>>|)>=<choice|<tformat|<table|<row|<cell|u<rsub|m+B<rsup|k-l>*<around|(|p-n|)>>*v<rsup|k+i-l>*v<rsup|\<ast\>j>*u<rsub|q><rsup|\<ast\>>>|<cell|<text|if
      <math|i\<geq\>l> and >p-n\<in\>B<rsup|l><Z><rsup|d>>>|<row|<cell|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\><around|(|l+j-i|)>>*u<rsub|B<rsup|j-i>*<around|(|n-p|)>+q><rsup|\<ast\>>>|<cell|<text|if
      <math|i\<less\>l> and >p-n\<in\>B<rsup|i><Z><rsup|d>>>|<row|<cell|0>|<cell|<text|otherwise.>>>>>><label|alternatives>
    </equation>
  </lemma>

  <\proof>
    We compute, using first (E2) and then (E1), to get

    <align*|<tformat|<table|<row|<cell|<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>>|<cell|<around|(|u<rsub|p>*v<rsup|i>*v<rsup|\<ast\>j>*u<rsub|q><rsup|\<ast\>>|)>=u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|p-n>*v<rsup|i>*v<rsup|\<ast\>j>*u<rsub|q><rsup|\<ast\>>>>|<row|<cell|>|<cell|=<choice|<tformat|<table|<row|<cell|u<rsub|m>*v<rsup|k>*u<rsub|B<rsup|-l>*<around|(|p-n|)>>*v<rsup|i-l>*v<rsup|\<ast\>j>*u<rsub|q><rsup|\<ast\>>>|<cell|<text|if
    <math|i\<geq\>l> and >p-n\<in\>B<rsup|l><Z><rsup|d>>>|<row|<cell|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\><around|(|l-i|)>>*u<rsub|B<rsup|-i>*<around|(|n-p|)>><rsup|\<ast\>>*v<rsup|\<ast\>j>*u<rsub|q><rsup|\<ast\>>>|<cell|<text|if
    <math|i\<less\>l> and >p-n\<in\>B<rsup|i><Z><rsup|d>>>|<row|<cell|0>|<cell|<text|otherwise>>>>>>>>|<row|<cell|>|<cell|=<choice|<tformat|<table|<row|<cell|u<rsub|m+B<rsup|k-l>*<around|(|p-n|)>>*v<rsup|k+i-l>*v<rsup|\<ast\>j>*u<rsub|q><rsup|\<ast\>>>|<cell|<text|if
    <math|i\<geq\>l> and >p-n\<in\>B<rsup|l><Z><rsup|d>>>|<row|<cell|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\><around|(|l+j-i|)>>*u<rsub|B<rsup|j-i>*<around|(|n-p|)>+q><rsup|\<ast\>>>|<cell|<text|if
    <math|i\<less\>l> and >p-n\<in\>B<rsup|i><Z><rsup|d>>>|<row|<cell|0>|<cell|<text|otherwise,>>>>>>>>>>>

    as required.
  </proof>

  <\cor>
    We have

    <\equation>
      <label|spanningset><TT><around|(|M<rsub|L>|)>=<clsp><around*|{|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>:m,n\<in\><Z><rsup|d>,k,l\<in\><N>|}>.
    </equation>
  </cor>

  <\proof>
    Equation<nbsp><eqref|alternatives> implies that
    <math|<newspan><around|{|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|}>>
    is a <math|\<ast\>>-algebra, and it contains all the generators of
    <math|<TT><around|(|M<rsub|L>|)>>.
  </proof>

  <\remark>
    Since <math|u> is a unitary representation, we have
    <math|u<rsub|n><rsup|\<ast\>>=u<rsub|-n>>, and the <rsup|<math|\<ast\>>>
    in <math|u<rsub|n><rsup|\<ast\>>> in <eqref|spanningset> is technically
    redundant. We have retained the <rsup|<math|\<ast\>>> to emphasise the
    parallels between this situation and the one in <cite|lr>. It also makes
    formulas more symmetric, and this sometimes simplifies calculations.
  </remark>

  <section|A characterisation of KMS states><label|sec-charKMS>

  The gauge action <math|\<gamma\>:<T>\<to\><Aut><TT><around|(|M<rsub|L>|)>>
  is characterised by <math|\<gamma\><rsub|z><around|(|i<rsub|M<rsub|L>><around|(|x|)>|)>=z*i<rsub|M<rsub|L>><around|(|x|)>>
  and <math|\<gamma\><rsub|z><around|(|i<rsub|C<around|(|<T><rsup|d>|)>><around|(|f|)>|)>=i<rsub|C<around|(|<T><rsup|d>|)>><around|(|f|)>>,
  or equivalently by <math|\<gamma\><rsub|z><around|(|v|)>=z*v> and
  <math|\<gamma\><rsub|z><around|(|u<rsub|m>|)>=u<rsub|m>>. Our dynamics
  <math|\<sigma\>:<R>\<to\><Aut><TT><around|(|M<rsub|L>|)>> is defined in
  terms of the gauge action by <math|\<sigma\><rsub|t>=\<gamma\><rsub|e<rsup|i*t>>>.
  Then we have

  <\equation*>
    <label|sigmagen>\<sigma\><rsub|t>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>=e<rsup|i*t*<around|(|k-l|)>>*u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>,
  </equation*>

  which since <math|z\<mapsto\>e<rsup|i*z*<around|(|k-l|)>>> is entire
  implies that the spanning elements <math|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>>
  are all analytic elements. Thus a state <math|\<phi\>> on
  <math|<TT><around|(|M<rsub|L>|)>> is a KMS<rsub|<math|\<beta\>>> state for
  <math|\<sigma\>> if and only if

  <\equation>
    <label|defKMSbeta>\<phi\>*<around*|(|<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>*<around|(|u<rsub|p>*v<rsup|i>*v<rsup|\<ast\>j>*u<rsub|q><rsup|\<ast\>>|)>|)>=e<rsup|-<around|(|k-l|)>*\<beta\>>*\<phi\>*<around*|(|<around|(|u<rsub|p>*v<rsup|i>*v<rsup|\<ast\>j>*u<rsub|q><rsup|\<ast\>>|)>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>|)>
  </equation>

  for all <math|m,n,p,q\<in\><Z><rsup|d>> and <math|i,j,k,l\<in\><N>>.

  The next result is an analogue of <cite-detail|lr|Lemma<nbsp>8.3>.

  <\prop>
    <label|charKMSbeta>The system <math|<around|(|<TT><around|(|M<rsub|L>|)>,\<sigma\>|)>>
    has no KMS<rsub|<math|\<beta\>>> states for <math|\<beta\>\<less\>log
    <around|\||det A|\|>>. For <math|\<beta\>\<geq\>log <around|\||det
    A|\|>>, a state <math|\<phi\>> of <math|<TT><around|(|M<rsub|L>|)>> is a
    KMS<rsub|<math|\<beta\>>> state if and only if

    <\equation>
      <label|charKMS>\<phi\>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      <math|k=l> and >m-n\<in\>B<rsup|k><Z><rsup|d>>>|<row|<cell|e<rsup|-k*\<beta\>>*\<phi\><around|(|u<rsub|B<rsup|-k>*<around|(|m-n|)>>|)>>|<cell|<text|if
      <math|k=l> and <math|m-n\<in\>B<rsup|k><Z><rsup|d>>.>>>>>>
    </equation>
  </prop>

  <\proof>
    Suppose that <math|\<phi\>> is a KMS<rsub|<math|\<beta\>>> state on
    <math|<around|(|<TT><around|(|M<rsub|L>|)>,\<sigma\>|)>>. Then for every
    <math|m\<in\><Z><rsup|d>>, we have

    <\equation*>
      \<phi\>*<around|(|u<rsub|m>*v*v<rsup|\<ast\>>*u<rsub|m><rsup|\<ast\>>|)>=\<phi\>*<around|(|v<rsup|\<ast\>>*u<rsub|m><rsup|\<ast\>>*\<sigma\><rsub|i*\<beta\>>*<around|(|u<rsub|m>*v|)>|)>=e<rsup|-\<beta\>>*\<psi\>*<around|(|v<rsup|\<ast\>>*u<rsub|m><rsup|\<ast\>>*u<rsub|m>*v|)>=e<rsup|-\<beta\>>*\<psi\><around|(|1|)>=e<rsup|-\<beta\>>.
    </equation*>

    Since <math|<around|{|u<rsub|m>*v:m\<in\>\<Sigma\>|}>> is a
    Toeplitz-Cuntz family with <math|<around|\||det A|\|>> elements, we have

    <\equation*>
      1=\<phi\><around|(|1|)>\<geq\><big|sum><rsub|m\<in\>\<Sigma\>>\<phi\>*<around|(|u<rsub|m>*v*v<rsup|\<ast\>>*u<rsub|m><rsup|\<ast\>>|)>=<around|\||det
      A|\|>*e<rsup|-\<beta\>>.
    </equation*>

    Thus <math|e<rsup|\<beta\>>\<geq\><around|\||det A|\|>>, and
    <math|\<beta\>\<geq\>log <around|\||det A|\|>>.

    Next we verify that <math|\<phi\>> satisfies <eqref|charKMS>. Applying
    the KMS condition twice gives

    <\equation*>
      \<phi\>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>=e<rsup|-k*\<beta\>>*\<phi\>*<around|(|v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>*u<rsub|m>*v<rsup|k>|)>=e<rsup|-<around|(|k-l|)>*\<beta\>>*\<phi\>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>.
    </equation*>

    Since <math|\<beta\>\<geq\>log <around|\||det A|\|>\<gtr\>0>, this
    implies that <math|\<phi\>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>=0>
    unless <math|k=l>. For <math|k=l> we have

    <\equation>
      <label|calcphi>\<phi\>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>k>*u<rsub|n><rsup|\<ast\>>|)>=e<rsup|-k*\<beta\>>*\<phi\>*<around|(|v<rsup|\<ast\>k>*u<rsub|n><rsup|\<ast\>>*u<rsub|m>*v<rsup|k>|)>=e<rsup|-k*\<beta\>>*\<phi\>*<around|(|v<rsup|\<ast\>k>*u<rsub|m-n>*v<rsup|k>|)>.
    </equation>

    From <math|k> applications of (E2), we see that

    <\equation*>
      v<rsup|\<ast\>k>*u<rsub|m-n>*v<rsup|k>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      >m-n\<in\>B<rsup|k><Z><rsup|d>>>|<row|<cell|u<rsub|B<rsup|-k>*<around|(|m-n|)>>>|<cell|<text|if
      <math|m-n\<in\>B<rsup|k><Z><rsup|d>>,>>>>>>
    </equation*>

    and <eqref|calcphi> implies <eqref|charKMS>.

    Now we suppose that <math|\<phi\>> is a state of
    <math|<TT><around|(|M<rsub|L>|)>> satisfying <eqref|charKMS>, and aim to
    prove that <math|\<phi\>> is a KMS<rsub|<math|\<beta\>>> state by
    verifying <eqref|defKMSbeta>. There is a certain amount of symmetry to
    the two nonzero alternatives in formula <eqref|alternatives>, so we may
    as well assume that <math|i\<geq\>l> and
    <math|p-n\<in\>B<rsup|l><Z><rsup|d>>. Then <eqref|alternatives> and
    <eqref|charKMS> imply that <math|\<phi\>*<around*|(|<around|(|u<rsub|m>*u<rsup|k>*u<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>*<around|(|u<rsub|p>*v<rsup|i>*v<rsup|\<ast\>j>*u<rsub|q><rsup|\<ast\>>|)>|)>>
    is

    <\equation*>
      <choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless <math|k+i-l=j>
      and >m+B<rsup|k-l>*<around|(|p-n|)>-q\<in\>B<rsup|j><Z><rsup|d>>>|<row|<cell|e<rsup|-j*\<beta\>>*\<phi\><around|(|u<rsub|B<rsup|-j>*<around|(|m+B<rsup|k-l>*<around|(|p-n|)>-q|)>>|)>>|<cell|<text|if
      <math|k+i-l=j> and <math|m+B<rsup|k-l>*<around|(|p-n|)>-q\<in\>B<rsup|j><Z><rsup|d>>.>>>>>>
    </equation*>

    The right-hand side of <eqref|defKMSbeta> also vanishes unless
    <math|k+i-l=j>, so we assume this from now on. Rewriting this equation as
    <math|k-j=l-i> shows that our assumption <math|i\<geq\>l> is equivalent
    to <math|k\<leq\>j>. Thus when we calculate the right-hand side of
    <eqref|defKMSbeta>, the second alternative in <eqref|alternatives> comes
    into play:

    <align*|<tformat|<table|<row|<cell|\<phi\><around|(||(>>|<cell|u<rsub|p>*v<rsup|i>*v<rsup|\<ast\>j>*u<rsub|q><rsup|\<ast\>>)<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>)=<choice|<tformat|<table|<row|<cell|\<phi\>*<around|(|u<rsub|p>*v<rsup|i>*v<rsup|\<ast\><around|(|j+l-k|)>>*u<rsub|B<rsup|l-k>*<around|(|q-m|)>+n><rsup|\<ast\>>|)>>|<cell|<text|if
    >q-m\<in\>B<rsup|k><Z><rsup|d>>>|<row|<cell|0>|<cell|<text|otherwise>>>>>>>>|<row|<cell|>|<cell|=<choice|<tformat|<table|<row|<cell|e<rsup|-i*\<beta\>>*\<phi\><around|(|u<rsub|B<rsup|-i>*<around|(|p-B<rsup|l-k>*<around|(|q-m|)>-n|)>>|)>>|<cell|<text|if
    <math|q-m\<in\>B<rsup|k><Z><rsup|d>> and
    >p-B<rsup|l-k>*<around|(|q-m|)>-n\<in\>B<rsup|i><Z><rsup|d>>>|<row|<cell|0>|<cell|<text|otherwise.>>>>>>>>>>>

    Multiplying this by <math|e<rsup|-<around|(|k-l|)>*\<beta\>>> gives the
    right-hand side of <eqref|defKMSbeta>, and in view of the equation
    <math|k+i-l=j>, it follows that the right-hand side of <eqref|defKMSbeta>
    is

    <\equation*>
      <choice|<tformat|<table|<row|<cell|e<rsup|-j*\<beta\>>*\<phi\><around|(|u<rsub|B<rsup|-i>*<around|(|p-B<rsup|l-k>*<around|(|q-m|)>-n|)>>|)>>|<cell|<text|if
      <math|q-m\<in\>B<rsup|k><Z><rsup|d>> and
      >p-B<rsup|l-k>*<around|(|q-m|)>-n\<in\>B<rsup|i><Z><rsup|d>>>|<row|<cell|0>|<cell|<text|otherwise.>>>>>>
    </equation*>

    Since

    <align*|<tformat|<table|<row|<cell|B<rsup|-i>*<around|(|p-B<rsup|l-k>*<around|(|q-m|)>-n|)>>|<cell|=B<rsup|-i>*<around|(|p-n|)>+B<rsup|-<around|(|i+k-l|)>>*<around|(|m-q|)>>>|<row|<cell|>|<cell|=B<rsup|-j+k-l>*<around|(|p-n|)>+B<rsup|-j>*<around|(|m-q|)>,>>>>>

    we have

    <\equation*>
      e<rsup|-j*\<beta\>>*\<phi\><around|(|u<rsub|B<rsup|-i>*<around|(|p-B<rsup|l-k>*<around|(|q-m|)>-n|)>>|)>=e<rsup|-j*\<beta\>>*\<phi\><around|(|u<rsub|B<rsup|-j>*<around|(|m+B<rsup|k-l>*<around|(|p-n|)>-q|)>>|)>,
    </equation*>

    so the numbers arising on the two sides of <eqref|defKMSbeta> are the
    same, and it remains to check that the conditions for nonvanishing are
    equivalent. So we need to check that

    <align*|<tformat|<table|<row|<cell|p-n\<in\>B<rsup|l><Z><rsup|d><text|and
    >>|<cell|m+B<rsup|k-l>*<around|(|p-n|)>-q\<in\>B<rsup|j><Z><rsup|d>>>|<row|<cell|>|<cell|\<Longleftrightarrow\>q-m\<in\>B<rsup|k><Z><rsup|d><text|and
    >p-B<rsup|l-k>*<around|(|q-m|)>-n\<in\>B<rsup|i><Z><rsup|d>.>>>>>

    Suppose that the first set of conditions holds. Then <math|q-m> belongs
    to the coset <math|B<rsup|<around|(|k-l|)>>*<around|(|p-n|)>+B<rsup|j><Z><rsup|d>>,
    which is contained in <math|B<rsup|k><Z><rsup|d>> because
    <math|k\<leq\>j> and <math|B<rsup|-l>*<around|(|p-n|)>> is in
    <math|<Z><rsup|d>>, and

    <\equation*>
      p-B<rsup|l-k>*<around|(|q-m|)>-n=B<rsup|l-k>*<around|(|B<rsup|k-l>*<around|(|p-n|)>-<around|(|q-m|)>|)>
    </equation*>

    belongs to <math|B<rsup|l-k>*B<rsup|j><Z><rsup|d>=B<rsup|l-k+j><Z><rsup|d>=B<rsup|i><Z><rsup|d>>.
    So the forward implication holds, and similar arguments prove the
    converse. We have now proved <eqref|defKMSbeta>, and thus <math|\<phi\>>
    is a KMS<rsub|<math|\<beta\>>> state.
  </proof>

  <section|KMS states for <math|\<beta\>=log <around|\||det
  A|\|>>.><label|sec-Exelcp>

  We begin by showing that the Exel crossed product has very few KMS states.

  <\prop>
    <label|onlybeta>If <math|\<phi\>> is a KMS<rsub|<math|\<beta\>>> state on
    <math|<around|(|<OO><around|(|M<rsub|L>|)>,\<sigma\>|)>>, then
    <math|\<beta\>=log <around|\||det A|\|>>.
  </prop>

  <\proof>
    We compute using the relation (E3) and the KMS condition:

    <align*|<tformat|<table|<row|<cell|1=\<phi\><around|(|1|)>>|<cell|=\<phi\><around*|(|<big|sum><rsub|m\<in\>\<Sigma\>><wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>>*<wide|v|\<bar\>><rsup|\<ast\>>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>|)>=<big|sum><rsub|m\<in\>\<Sigma\>>\<phi\>*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>>*<wide|v|\<bar\>><rsup|\<ast\>>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|m\<in\>\<Sigma\>>\<phi\>*<around|(|<wide|v|\<bar\>><rsup|\<ast\>>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>*\<sigma\><rsub|i*\<beta\>>*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>>|)>|)>=<big|sum><rsub|m\<in\>\<Sigma\>>e<rsup|-\<beta\>>*\<phi\>*<around|(|<wide|v|\<bar\>><rsup|\<ast\>>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>*<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>>|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|m\<in\>\<Sigma\>>e<rsup|-\<beta\>>*\<phi\><around|(|1|)>=N*e<rsup|-\<beta\>>,>>>>>

    since <math|<around|\||\<Sigma\>|\|>=<around|\||<Z><rsup|d>/B<Z><rsup|d>|\|>=<around|\||det
    B|\|>=<around|\||det A|\|>=N>.
  </proof>

  <\lemma>
    Every KMS<rsub|<math|log N>> state of
    <math|<around|(|<TT><around|(|M<rsub|L>|)>,\<sigma\>|)>> factors through
    the quotient map <math|Q> of <math|<TT><around|(|M<rsub|L>|)>> onto
    <math|<OO><around|(|M<rsub|L>|)>>.
  </lemma>

  <\proof>
    Suppose that <math|\<phi\>> is a KMS<rsub|<math|log N>> state of
    <math|<around|(|<TT><around|(|M<rsub|L>|)>,\<sigma\>|)>>. The formula
    <eqref|charKMS> implies that <math|\<phi\>*<around|(|u<rsub|m>*v*v<rsup|\<ast\>>*u<rsub|m><rsup|\<ast\>>|)>=N<rsup|-1>>,
    and hence

    <\equation*>
      \<phi\>*<around*|(|1-<big|sum><rsub|m\<in\>\<Sigma\>>u<rsub|m>*v*v<rsup|\<ast\>>*u<rsub|m><rsup|\<ast\>>|)>=1-N*N<rsup|-1>=0.
    </equation*>

    Now the argument of <cite-detail|lr|Lemma<nbsp>10.3> implies that
    <math|\<phi\>> vanishes on the ideal generated by
    <math|1-<big|sum><rsub|m\<in\>\<Sigma\>>u<rsub|m>*v*v<rsup|\<ast\>>*u<rsub|m><rsup|\<ast\>>>.
    But Proposition<nbsp><reference|CPquotient> says that this ideal is the
    kernel of <math|Q>, and the result follows.
  </proof>

  The next result was first obtained by Ted Boey as an application of the
  general theory in<nbsp><cite|ln>.

  <\thm>
    <label|betalogN>Suppose that <math|A\<in\>M<rsub|d><around|(|<Z>|)>> has
    <math|N\<assign\><around|\||det A|\|>\<neq\>0>. Then there is a
    KMS<rsub|<math|log N>> state <math|\<phi\>> of
    <math|<around|(|<OO><around|(|M<rsub|L>|)>,\<sigma\>|)>> such that

    <\equation>
      <label|KMSlogN>\<phi\>*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>l>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      <math|k=l> and >m=n>>|<row|<cell|N<rsup|-k>>|<cell|<text|if <math|k=l>
      and <math|m=n>.>>>>>>
    </equation>

    If <math|A> is a dilation matrix, then this is the only KMS state of
    <math|<around|(|<OO><around|(|M<rsub|L>|)>,\<sigma\>|)>>.
  </thm>

  We will construct the state by factoring through an expectation onto the
  commutative subalgebra spanned by the range projections of the generators.

  <\lemma>
    <label|existexpect>Suppose that <math|A\<in\>M<rsub|d><around|(|<Z>|)>>
    has nonzero determinant. Then there is an expectation <math|E> of
    <math|<OO><around|(|M<rsub|L>|)>> onto

    <\equation>
      <label|fpa><OO><around|(|M<rsub|L>|)><rsup|\<delta\>>\<assign\><clsp><around*|{|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>:m\<in\><Z><rsup|d>,k\<in\><N>|}>
    </equation>

    such that

    <\equation>
      <label|defexpect>E*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>l>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      <math|k=l> and >m=n>>|<row|<cell|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>>|<cell|<text|if
      <math|k=l> and <math|m=n>.>>>>>>
    </equation>
  </lemma>

  We prove this by averaging over a dual coaction, following a line of
  argument used in <cite|lr1> and <cite|lr> (and this explains the notation
  <math|<OO><around|(|M<rsub|L>|)><rsup|\<delta\>>>). We will later give a
  second proof which avoids the use of coactions.

  <\proof>
    <dueto|First proof of Lemma<nbsp><reference|existexpect>>The
    Baumslag-Solitar group <math|<Z><around|[|B<rsup|-1>|]>\<rtimes\><Z>> is
    the semidirect product of the additive subgroup
    <math|<Z><around|[|B<rsup|-1>|]>\<assign\><big|cup><rsub|k>B<rsup|-k><Z><rsup|d>>
    of <math|<Q>> by the action of <math|<Z>> by powers of <math|B>. We write
    <math|\<epsilon\>> for the canonical unitary representation of
    <math|<Z><around|[|B<rsup|-1>|]>\<rtimes\><Z>> in
    <math|C<rsup|\<ast\>>*<around|(|<Z><around|[|B<rsup|-1>|]>\<rtimes\><Z>|)>>,
    so that in particular

    <align*|<tformat|<table|<row|<cell|\<epsilon\><rsub|<around|(|0,1|)>>*\<epsilon\><rsub|<around|(|m,0|)>>>|<cell|=\<epsilon\><rsub|<around|(|B*m,1|)>>=\<epsilon\><rsub|<around|(|B*m,0|)>>*\<epsilon\><rsub|<around|(|0,1|)>>,<text|and>>>|<row|<cell|\<epsilon\><rsub|<around|(|0,1|)>><rsup|\<ast\>>*\<epsilon\><rsub|<around|(|m,0|)>>*\<epsilon\><rsub|<around|(|0,1|)>>>|<cell|=\<epsilon\><rsub|<around|(|B<rsup|-1>*m,0|)>>.>>>>>

    These identities imply that <math|U<rsub|m>\<assign\><wide|u|\<bar\>><rsub|m>\<otimes\>\<epsilon\><rsub|<around|(|m,0|)>>>
    and <math|V\<assign\><wide|v|\<bar\>>\<otimes\>\<epsilon\><rsub|<around|(|0,1|)>>>
    satisfy the relations (E1), (E2) and (E3), and hence give a homomorphism
    <math|\<delta\>\<assign\>\<pi\><rsub|U,V>> of
    <math|<OO><around|(|M<rsub|L>|)>> into
    <math|<OO><around|(|M<rsub|L>|)>\<otimes\>C<rsup|\<ast\>>*<around|(|<Z><around|[|B<rsup|-1>|]>\<rtimes\><Z>|)>>.
    One can check on generators that <math|\<delta\>> is a coaction of
    <math|<Z><around|[|B<rsup|-1>|]>\<rtimes\><Z>> on
    <math|<OO><around|(|M<rsub|L>|)>>. Since
    <math|<Z><around|[|B<rsup|-1>|]>\<rtimes\><Z>> is amenable, averaging
    over this coaction gives an expectation <math|E> of
    <math|<OO><around|(|M<rsub|L>|)>> onto the fixed-point algebra

    <\equation*>
      <OO><around|(|M<rsub|L>|)><rsup|\<delta\>>\<assign\><around*|{|a\<in\><OO><around|(|M<rsub|L>|)>:\<delta\><around|(|a|)>=a\<otimes\>1=a\<otimes\>\<epsilon\><rsub|<around|(|0,0|)>>|}>
    </equation*>

    (see <cite-detail|lr1|Lemma<nbsp>6.5>). Since

    <\equation*>
      \<delta\>*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>l>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>|)>=<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>l>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>\<otimes\>\<epsilon\><rsub|<around|(|m,k|)><around|(|n,l|)><rsup|-1>>,
    </equation*>

    <math|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>l>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>>
    belongs to the fixed-point algebra if and only if
    <math|<around|(|m,k|)>=<around|(|n,l|)>>, and thus <math|E> satisfies
    <eqref|defexpect>. Since <math|E> is norm-decreasing, and the
    <math|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>l>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>>
    span a dense subspace of <math|<OO><around|(|M<rsub|L>|)>>,
    <eqref|defexpect> implies <eqref|fpa>.
  </proof>

  The coaction-free proof of Lemma<nbsp><reference|existexpect> involves
  averaging twice over actions of abelian groups. Averaging over the gauge
  action <math|\<gamma\>:<T>\<to\><Aut><OO><around|(|M<rsub|L>|)>> gives an
  expectation <math|E<rsup|\<gamma\>>> onto the fixed-point algebra
  <math|<OO><around|(|M<rsub|L>|)><rsup|\<gamma\>>>; since this expectation
  is continuous and kills elements <math|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>l>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>>
  with <math|k\<neq\>l>, we have

  <\equation>
    <label|gaugefpa><OO><around|(|M<rsub|L>|)><rsup|\<gamma\>>=<clsp><around*|{|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>:m,n\<in\><Z><rsup|d>,k\<in\><N>|}>.
  </equation>

  For this proof of Lemma<nbsp><reference|existexpect>, we need to analyse
  the structure of <math|<OO><around|(|M<rsub|L>|)><rsup|\<gamma\>>>, and
  since we'll use this analysis elsewhere in the proof of
  Theorem<nbsp><reference|betalogN>, we might as well do it properly now. As
  a point of notation, we write

  <\equation>
    <label|defSigmak>\<Sigma\><rsub|k>\<assign\><around*|{|\<mu\><rsub|1>+B*\<mu\><rsub|2>+\<cdots\>*B<rsup|k-1>*\<mu\><rsub|k>:\<mu\>\<in\>\<Sigma\><rsup|k>|}>,
  </equation>

  and observe that <math|\<Sigma\><rsub|k>> is a set of coset representatives
  for <math|<Z><rsup|d>/B<rsup|k><Z><rsup|d>>.

  <\prop>
    <label|analcore><text|(a)> For each <math|k\<geq\>1>, we set

    <\equation*>
      C<rsub|k>\<assign\><clsp><around*|{|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>:m,n\<in\><Z><rsup|d>|}>.
    </equation*>

    Then the <math|C<rsub|k>> are <math|C<rsup|\<ast\>>>-subalgebras of
    <math|<OO><around|(|M<rsub|L>|)><rsup|\<gamma\>>> satisfying
    <math|C<rsub|k>\<subset\>C<rsub|k+1>> and
    <math|<OO><around|(|M<rsub|L>|)><rsup|\<gamma\>>=<wide|<big|cup><rsub|k=1><rsup|\<infty\>>C<rsub|k>|\<bar\>>>.

    <vspace|0.5fn><text|(b)> For each <math|k\<geq\>1>,
    <math|<around|{|e<rsub|m,n><rsup|k>\<assign\><wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>:m,n\<in\>\<Sigma\><rsub|k>|}>>
    is a set of nonzero matrix units which spans a matrix algebra
    <math|M<rsub|\<Sigma\><rsub|k>><around|(|<C>|)>>. The respresentation
    <math|<wide|u|\<bar\>>> of <math|<Z><rsup|d>> in
    <math|<OO><around|(|M<rsub|L>|)>> maps <math|B<rsup|k><Z><rsup|d>> into
    <math|C<rsub|k>>, and every <math|<wide|u|\<bar\>><rsub|B<rsup|k>*m>>
    belongs to the commutant of <math|M<rsub|\<Sigma\><rsub|k>><around|(|<C>|)>>
    in <math|C<rsub|k>>.

    <vspace|0.5fn><text|(c)> The inclusion <math|\<iota\><rsub|k>> of
    <math|M<rsub|\<Sigma\><rsub|k>><around|(|<C>|)>> in
    <math|<OO><around|(|M<rsub|L>|)><rsup|\<gamma\>>> and the integrated form
    <math|\<pi\><rsub|<wide|u|\<bar\>>,k>> of
    <math|<wide|u|\<bar\>>\|<rsub|B<rsup|k><Z><rsup|d>>> give an isomorphism
    <math|\<iota\><rsub|k>\<otimes\>\<pi\><rsub|<wide|u|\<bar\>>,k>> of
    <math|M<rsub|\<Sigma\><rsub|k>><around|(|<C>|)>\<otimes\>C<rsup|\<ast\>><around|(|B<rsup|k><Z><rsup|d>|)>>
    onto <math|C<rsub|k>> which carries <math|e<rsub|m,n><rsup|k>\<otimes\>\<epsilon\><rsub|B<rsup|k>*p>>
    into <math|<wide|u|\<bar\>><rsub|m+B<rsup|k>*p>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>>.
  </prop>

  <\proof>
    Calculations using the relations (E1) and (E2) show that

    <\equation>
      <label|calcinCk><around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>|)>*<around|(|<wide|u|\<bar\>><rsub|p>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|q><rsup|\<ast\>>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      >p-n\<in\>B<rsup|k><Z><rsup|d>>>|<row|<cell|<wide|u|\<bar\>><rsub|m+p-n>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|q><rsup|\<ast\>>>|<cell|<text|if
      <math|p-n\<in\>B<rsup|k><Z><rsup|d>>,>>>>>>
    </equation>

    which implies that <math|C<rsub|k>> is a
    <math|C<rsup|\<ast\>>>-subalgebra. The Cuntz relation (E3) implies that

    <align*|<tformat|<table|<row|<cell|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>>|<cell|=<big|sum><rsub|p\<in\>\<Sigma\>><wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<around|(|<wide|u|\<bar\>><rsub|p>*<wide|v|\<bar\>>*<wide|v|\<bar\>><rsup|\<ast\>>*<wide|u|\<bar\>><rsub|p><rsup|\<ast\>>|)>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>=<big|sum><rsub|p\<in\>\<Sigma\>><wide|u|\<bar\>><rsub|m+B<rsup|k>*p>*<wide|v|\<bar\>><rsup|k+1>*<wide|v|\<bar\>><rsup|\<ast\><around|(|k+1|)>>*<wide|u|\<bar\>><rsub|n+B<rsup|k>*p><rsup|\<ast\>>,>>>>>

    which in view of the definition of <math|\<Sigma\><rsub|k+1>> implies
    that <math|C<rsub|k>\<subset\>C<rsub|k+1>>. Now
    <math|<OO><around|(|M<rsub|L>|)><rsup|\<gamma\>>=<wide|<big|cup><rsub|k=1><rsup|\<infty\>>C<rsub|k>|\<bar\>>>
    follows from <eqref|gaugefpa>, and we have proved (a).

    Since <math|<around|{|S<rsub|m>\<assign\><wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>>:m\<in\>\<Sigma\>|}>>
    is a Cuntz family, for each fixed <math|k> the products
    <math|<around|{|S<rsub|\<mu\>>=S<rsub|\<mu\><rsub|1>>*\<cdots\>*S<rsub|\<mu\><rsub|k>>:\<mu\>\<in\>\<Sigma\><rsup|k>|}>>
    form a Cuntz family; since

    <\equation*>
      S<rsub|\<mu\>>=<around|(|<wide|u|\<bar\>><rsub|\<mu\><rsub|1>>*<wide|v|\<bar\>>|)>*<around|(|<wide|u|\<bar\>><rsub|\<mu\><rsub|2>>*<wide|v|\<bar\>>|)>*\<cdots\>*<around|(|<wide|u|\<bar\>><rsub|\<mu\><rsub|k>>*<wide|v|\<bar\>>|)>=<wide|u|\<bar\>><rsub|\<mu\><rsub|1>+B*\<mu\><rsub|2>+\<cdots\>*B<rsup|k-1>*\<mu\><rsub|k>>*<wide|v|\<bar\>><rsup|k>,
    </equation*>

    this Cuntz family is precisely <math|<around|{|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>:m\<in\>\<Sigma\><rsub|k>|}>>,
    and it follows that the <math|e<rsub|m,n><rsup|k>> are nonzero matrix
    units. The relation (E1) implies that
    <math|<wide|u|\<bar\>><rsub|B<rsup|k>*p>> commutes with every
    <math|e<rsub|m,n><rsup|k>>, which gives (b).

    Since the representation of <math|C<rsup|\<ast\>><around|(|B<rsup|k><Z><rsup|d>|)>>
    in <math|C<around|(|<T><rsup|d>|)>> is faithful, and since
    <math|j<rsub|C<around|(|<T><rsup|d>|)>>:C<around|(|<T><rsup|d>|)>\<to\>C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>,L><N>=<OO><around|(|M<rsub|L>|)>>
    is injective (by <cite-detail|br|Corollary<nbsp>4.3>, for example),
    <math|\<pi\><rsub|<wide|u|\<bar\>>,k>> is injective, and hence so is the
    representation <math|\<iota\><rsub|k>\<otimes\>\<pi\><rsub|<wide|u|\<bar\>>,k>>
    of <math|M<rsub|\<Sigma\><rsub|k><around|(|<C>|)>>\<otimes\>C<rsup|\<ast\>><around|(|B<rsup|k><Z><rsup|d>|)>=M<rsub|\<Sigma\><rsub|k>><around|(|C<rsup|\<ast\>><around|(|B<rsup|k><Z><rsup|d>|)>|)>>.
    It is surjective because every <math|m\<in\><Z><rsup|d>> can be written
    uniquely as <math|m<rprime|'>+B<rsup|k>*m<rprime|''>> for some
    <math|m<rprime|'>\<in\>\<Sigma\><rsub|k>>, and then

    <\equation*>
      <wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>=<wide|u|\<bar\>><rsub|B<rsup|k>*m<rprime|''>>*<around|(|<wide|u|\<bar\>><rsub|m<rprime|'>>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|n<rprime|'>><rsup|\<ast\>>|)>*<wide|u|\<bar\>><rsub|B<rsup|k>*n<rprime|''>><rsup|\<ast\>>
    </equation*>

    is in <math|C<rsub|k>> because each matrix unit and each
    <math|<wide|u|\<bar\>><rsub|B<rsup|k>*m<rprime|''>>> are. To see the last
    assertion about what <math|\<iota\><rsub|k>\<otimes\>\<pi\><rsub|<wide|u|\<bar\>>,k>>
    does to <math|e<rsub|m,n><rsup|k>\<otimes\>\<epsilon\><rsub|B<rsup|k>*p>>,
    recall that the representation <math|\<phi\>\<otimes\>\<psi\>> of a
    tensor product <math|C\<otimes\>D> coming from commuting representations
    <math|\<phi\>> of <math|C> and <math|\<psi\>> of <math|D> takes
    <math|c\<otimes\>d> to <math|\<phi\><around|(|c|)>*\<psi\><around|(|d|)>=\<psi\><around|(|d|)>*\<phi\><around|(|c|)>>
    (see <cite-detail|tfb|Theorem<nbsp>B.2>, for example).
  </proof>

  <\cor>
    <label|2ndaction>There is a continuous action <math|\<tau\>> of
    <math|<T><rsup|d>> on <math|<OO><around|(|M<rsub|L>|)><rsup|\<gamma\>>>
    such that

    <\equation>
      <label|deftau>\<tau\><rsub|z>*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>|)>=z<rsup|m-n>*<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>><text|for
      <math|m,n\<in\><Z><rsup|d>>, <math|k\<in\><N>>.>
    </equation>
  </cor>

  <\proof>
    There is a continuous action <math|\<eta\>> of <math|<T><rsup|d>> on
    <math|M<rsub|\<Sigma\><rsub|k>><around|(|<C>|)>> such that
    <math|\<eta\><rsub|z><around|(|e<rsub|m,n><rsup|k>|)>=z<rsup|m-n>*e<rsub|m,n><rsup|k>>
    \V indeed, <math|\<eta\><rsub|z>> is conjugation by the unitary
    <math|<big|sum><rsub|m\<in\>\<Sigma\><rsub|k>>z<rsup|m>*e<rsub|m,m><rsup|k>>.
    Lifting the dual action of <math|<around|(|B<rsup|k><Z><rsup|d>|)><rsup|\<wedge\>>=<T><rsup|d>/<around|(|B<rsup|k><Z><rsup|d>|)><rsup|\<perp\>>>
    to <math|<T><rsup|d>> gives an action <math|\<zeta\>> of
    <math|<T><rsup|d>> on <math|C<rsup|\<ast\>><around|(|B<rsup|k><Z><rsup|d>|)>>
    which multiplies the generator <math|\<epsilon\><rsub|B<rsup|k>*m>> by
    <math|z<rsup|B<rsup|k>*m>>. Pulling the action
    <math|\<eta\>\<otimes\>\<zeta\>> on <math|M<rsub|\<Sigma\><rsub|k><around|(|<C>|)>>\<otimes\>C<rsup|\<ast\>><around|(|B<rsup|k><Z><rsup|d>|)>>
    over to <math|<OO><around|(|M<rsub|L>|)><rsup|\<gamma\>>> under the
    isomorphism of Proposition<nbsp><reference|analcore>(c) gives an action
    <math|\<tau\><rsup|k>> on <math|C<rsub|k>> which satisfies <eqref|deftau>
    (for fixed <math|k>). A calculation using the Cuntz relation (E3) shows
    that the automorphisms <math|\<tau\><rsup|k><rsub|z>> combine to give an
    automorphism <math|\<tau\><rsub|z>> of
    <math|<big|cup><rsub|k=1><rsup|\<infty\>>C<rsub|k>>, which is isometric
    because each <math|\<tau\><rsup|k><rsub|z>> is, and hence extends to an
    automorphism of <math|<OO><around|(|M<rsub|L>|)><rsup|\<gamma\>>>.
    Continuity follows from the continuity of scalar multiplication.
  </proof>

  <\proof>
    <dueto|Second proof of Lemma<nbsp><reference|existexpect>>Averaging over
    the action <math|\<tau\>> of Corollary<nbsp><reference|2ndaction> gives
    an expectation <math|E<rsup|\<tau\>>> of
    <math|<OO><around|(|M<rsub|L>|)><rsup|\<gamma\>>> onto
    <math|<OO><around|(|M<rsub|L>|)><rsup|\<delta\>>>, and
    <math|E\<assign\>E<rsup|\<tau\>>\<circ\>E<rsup|\<gamma\>>> has the
    required properties.
  </proof>

  <\proof>
    <dueto|Proof of existence in Theorem<nbsp><reference|betalogN>>The
    description of <math|<OO><around|(|M<rsub|L>|)><rsup|\<delta\>>> in
    <eqref|fpa> shows that each <math|\<sigma\><rsub|t>> is the identity on
    <math|<OO><around|(|M<rsub|L>|)><rsup|\<delta\>>>, so it suffices to find
    a trace <math|\<tau\>> on <math|<OO><around|(|M<rsub|L>|)><rsup|\<delta\>>>
    such that <math|\<tau\>*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>|)>=N<rsup|-k>>,
    and then Proposition<nbsp><reference|charKMSbeta> implies that
    <math|\<tau\>\<circ\>E> is a KMS<rsub|<math|log N>> state on
    <math|<around|(|<OO><around|(|M<rsub|L>|)>,\<sigma\>|)>>.

    We can write each <math|m\<in\><Z><rsup|d>> uniquely as
    <math|m<rprime|'>+B<rsup|k>*m<rprime|''>> for some
    <math|m<rprime|'>\<in\>\<Sigma\><rsub|k>>, and then part<nbsp>(b) of
    Proposition<nbsp><reference|analcore> implies that

    <align*|<tformat|<table|<row|<cell|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>>|<cell|=<wide|u|\<bar\>><rsub|B<rsup|k>*m<rprime|''>>*<around|(|<wide|u|\<bar\>><rsub|m<rprime|'>>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m<rprime|'>><rsup|\<ast\>>|)>*<wide|u|\<bar\>><rsub|B<rsup|k>*m<rprime|''>><rsup|\<ast\>>>>|<row|<cell|>|<cell|=<wide|u|\<bar\>><rsub|B<rsup|k>*m<rprime|''>>*<wide|u|\<bar\>><rsub|B<rsup|k>*m<rprime|''>><rsup|\<ast\>>*<around|(|<wide|u|\<bar\>><rsub|m<rprime|'>>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m<rprime|'>><rsup|\<ast\>>|)>>>|<row|<cell|>|<cell|=<wide|u|\<bar\>><rsub|m<rprime|'>>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m<rprime|'>><rsup|\<ast\>>.>>>>>

    Now part<nbsp>(a) of Proposition<nbsp><reference|analcore> implies that

    <\equation*>
      D<rsub|k>\<assign\><newspan><around*|{|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>:m\<in\><Z><rsup|d>|}>=<newspan><around*|{|<wide|u|\<bar\>><rsub|m<rprime|'>>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m<rprime|'>><rsup|\<ast\>>:m<rprime|'>\<in\>\<Sigma\><rsub|k>|}>
    </equation*>

    is a finite-dimensional commutative <math|C<rsup|\<ast\>>>-algebra, and
    that <math|D<rsub|k>> has a normalised trace <math|\<tau\><rsub|k>>
    satisfying <math|\<tau\><rsub|k>*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>|)>=N<rsup|-k>>.
    The Cuntz relation (E3) implies that <math|D<rsub|k>\<subset\>D<rsub|k+1>>,
    and the normalised traces <math|\<tau\><rsub|k>> combine to give a trace
    <math|\<tau\>> on <math|<OO><around|(|M<rsub|L>|)><rsup|\<delta\>>=<wide|<big|cup><rsub|k>D<rsub|k>|\<bar\>>>
    such that <math|\<tau\>*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>|)>=N<rsup|-k>>.
    Then, as foreshadowed above, <math|\<phi\>\<assign\>\<tau\>\<circ\>E> is
    a KMS<rsub|<math|log N>> state on <math|<around|(|<OO><around|(|M<rsub|L>|)>,\<sigma\>|)>>
    satisfying <eqref|KMSlogN>.
  </proof>

  For the proof of uniqueness, we need a standard fact about dilation
  matrices.

  <\lemma>
    <label|dilpure>If <math|B> is an integer dilation matrix, then
    <math|<big|cap><rsub|k=1><rsup|\<infty\>>B<rsup|k><Z><rsup|d>=<around|{|0|}>>.
  </lemma>

  <\proof>
    Suppose that <math|m\<in\><big|cap><rsub|k=0><rsup|\<infty\>>B<rsup|k><Z><rsup|d>>.
    Then <math|B<rsup|-k>*m> belongs to <math|<Z><rsup|d>> for every
    <math|k>, and since we know from <cite-detail|ehr|Lemma<nbsp>4.12>, for
    example, that <math|<around|\<\|\|\>|B<rsup|-k>*m|\<\|\|\>>\<to\>0> as
    <math|k\<to\>\<infty\>>, we must have <math|B<rsup|k>*m=0> for large
    <math|k>, and <math|m=0>.
  </proof>

  <\proof>
    <dueto|Proof of uniqueness in Theorem<nbsp><reference|betalogN>>Suppose
    that <math|\<phi\>> is a KMS state of
    <math|<around|(|<OO><around|(|M<rsub|L>|)>,\<sigma\>|)>>.
    Proposition<nbsp><reference|onlybeta> implies that <math|\<phi\>> has
    inverse temperature <math|\<beta\>=log N>. We need to prove that
    <math|\<phi\>> satisfies <eqref|KMSlogN>, and comparing <eqref|KMSlogN>
    with <eqref|charKMS> (which we know holds with
    <math|e<rsup|-k*\<beta\>>=N<rsup|-k>>) shows that we need to prove that
    <math|\<phi\><around|(|<wide|u|\<bar\>><rsub|n>|)>=0> for all nonzero
    <math|n>. So suppose <math|n\<in\><Z><rsup|d>> and <math|n\<neq\>0>.
    Lemma<nbsp><reference|dilpure> implies that there is a smallest integer
    <math|k> such that <math|n> does not belong to
    <math|B<rsup|k><Z><rsup|d>>. Then, recalling from the proof of existence
    that <math|<around|{|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>:m\<in\>\<Sigma\><rsub|k>|}>>
    is a Cuntz family in <math|<OO><around|(|M<rsub|L>|)>>, we have

    <\equation*>
      \<phi\><around|(|<wide|u|\<bar\>><rsub|n>|)>=\<phi\>*<around*|(|<wide|u|\<bar\>><rsub|n>*<big|sum><rsub|m\<in\>\<Sigma\><rsub|k>><wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>|)>=<big|sum><rsub|m\<in\>\<Sigma\><rsub|k>>\<phi\>*<around|(|<wide|u|\<bar\>><rsub|n+m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|m><rsup|\<ast\>>|)>,
    </equation*>

    which vanishes by <eqref|charKMS> because <math|<around|(|n+m|)>-m=n> is
    not in <math|B<rsup|k><Z><rsup|d>> for every <math|m>.
  </proof>

  It seems to be quite easy to find representations of
  <math|<OO><around|(|M<rsub|L>|)>>, and we describe an interesting one in
  the following example (which was one of our reasons for becoming interested
  in the <math|C<rsup|\<ast\>>>-algebras associated to dilation matrices in
  the first place <cite|ehr>). However, it does not seem to be so easy to
  find natural Hilbert space representations of
  <math|<OO><around|(|M<rsub|L>|)>> in which the KMS<rsub|<math|log
  <around|\||det A|\|>>> state is a vector state.

  <\example>
    <label|BrattJorgrep>The operators <math|V> and <math|U<rsub|m>> on
    <math|L<rsup|2><around|(|<T><rsup|d>|)>> defined by

    <\equation*>
      <around|(|V*\<xi\>|)><around|(|z|)>=\<xi\><around|(|\<sigma\><rsub|A><around|(|z|)>|)>*<text|and
      ><around|(|U<rsub|m>*\<xi\>|)><around|(|z|)>=z<rsup|m>*\<xi\><around|(|z|)>
    </equation*>

    satisfy (E1\U3), and hence give a representation of
    <math|<OO><around|(|M<rsub|L>|)>> on <math|L<rsup|2><around|(|<T><rsup|d>|)>>.
    The Cuntz family <math|<around|{|U<rsub|m>*V:m\<in\>\<Sigma\>|}>> is one
    of the sort studied by Bratteli and Jorgensen in the context of wavelets
    <cite|bj>, or more precisely, one of the more general sort studied
    in<nbsp><cite|aijln>.

    To make the connection, note that the characters
    <math|<around|{|\<gamma\><rsub|n>:n\<in\>\<Sigma\>|}>> form an
    orthonormal basis for the right Hilbert module <math|M<rsub|L>>, or what
    is called in <cite|aijln> a \Pfilter bank for dilation by <math|A>\Q. It
    is shown in <cite-detail|aijln|Proposition<nbsp>2.2> that any filter bank
    <math|<around|{|m<rsub|i>:0\<leq\>i\<less\>N|}>> gives rise to a Cuntz
    family <math|S<rsub|i>\<assign\>M<around|(|m<rsub|i>|)>*V>, where
    <math|M<around|(|f|)>> is the operator of multiplication by
    <math|f\<in\>C<around|(|<T><rsup|d>|)>>. In the construction of wavelets,
    the more interesting filter banks are those in which <math|m<rsub|0>> is
    \Plow-pass\Q, which implies in particular that
    <math|m<rsub|0><around|(|1|)>=N<rsup|1/2>> and
    <math|m<rsub|i><around|(|1|)>=0> for <math|i\<gtr\>0> (see
    <cite-detail|aijln|Example<nbsp>4.2>); the filters
    <math|\<gamma\><rsub|n>> satisfy <math|<around|\||\<gamma\><rsub|n>|\|>\<equiv\>1>,
    and hence are \Pall-pass\Q.
  </example>

  <\remark>
    Exel has previously studied KMS states on Exel crossed products
    <cite|e2>, and we now reconcile our result with his
    <cite-detail|e2|Proposition<nbsp>9.2>. The situation in <cite|e2> is more
    general than ours, but applies with <math|h=e*1> and
    <math|E=\<alpha\>\<circ\>L>, which is easily seen to be an expectation of
    <math|C<around|(|<T><rsup|d>|)>> onto the range of <math|\<alpha\>>;
    since our orthonormal basis for <math|M<rsub|L>> is a quasi-basis,
    <math|E> has finite type with index <math|N\<assign\><around|\||det
    A|\|>> (strictly speaking, <math|<ind>E> is the element <math|N*1> of
    <math|C<around|(|<T><rsup|d>|)>>). Exel proved in
    <cite-detail|e2|Theorem<nbsp>8.9> that there is an expectation
    <math|G:C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\>,L><N>\<to\>j<rsub|C<around|(|<T><rsup|d>|)>><around|(|C<around|(|<T><rsup|d>|)>|)>>
    such that <math|G*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>l>*<wide|u|\<bar\>><rsup|\<ast\>><rsub|n>|)>=\<delta\><rsub|k,l>*N<rsup|-k>*<wide|u|\<bar\>><rsub|m>*<wide|u|\<bar\>><rsup|\<ast\>><rsub|n>>;
    in our situation, it is quite easy to check directly that <math|G> is
    given by first averaging over the gauge action <math|\<gamma\>>, and then
    combining the expectations <math|G<rsub|k>> on
    <math|C<rsub|k>\<assign\><clsp><around|{|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>k>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>|}>>
    defined by <math|G<rsub|k><around|(|T|)>=N<rsup|-k>*<big|sum><rsub|p\<in\>\<Sigma\><rsub|k>><wide|u|\<bar\>><rsub|p>*T*<wide|u|\<bar\>><rsub|p><rsup|\<ast\>>>
    to get <math|G> on <math|<around|(|C<around|(|<T><rsup|d>|)>\<rtimes\><N>|)><rsup|\<gamma\>>=<wide|<big|cup><rsub|k\<geq\>0>C<rsub|k>|\<bar\>>>
    (see <cite-detail|ev|Corollary<nbsp>7.5>). Then
    <cite-detail|e2|Proposition<nbsp>9.2> implies that the
    KMS<rsub|<math|\<beta\>>> states on <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\>,L><N>>
    have the form <math|\<phi\>\<circ\>G>, where <math|\<phi\>> is a trace on
    <math|C<around|(|<T><rsup|d>|)>> satisfying
    <math|\<phi\><around|(|f|)>=e<rsup|-\<beta\>>*N*\<phi\><around|(|L<around|(|f|)>|)>>
    for <math|f\<in\>C<around|(|<T><rsup|d>|)>>.

    Traces on <math|C<around|(|<T><rsup|d>|)>> are given by measures
    <math|\<mu\>>, and Exel's condition says that <math|\<mu\>> satisfies

    <\equation>
      <label|Exelschar><big|int>f*<space|0.17em>d*\<mu\>=e<rsup|-\<beta\>>*<big|int><rsub|<T><rsup|d>><big|sum><rsub|\<sigma\><rsub|A><around|(|w|)>=z>f<around|(|w|)>*<space|0.17em>d*\<mu\><around|(|z|)><text|for
      <math|f\<in\>C<around|(|<T><rsup|d>|)>>.>
    </equation>

    It follows from <cite-detail|aijln|Lemma<nbsp>2.3>, for example, that the
    Haar measure <math|\<lambda\>> on <math|<T><rsup|d>> satisfies
    <eqref|Exelschar> with <math|1=e<rsup|-\<beta\>>*N>, and since
    <math|<wide|u|\<bar\>><rsub|m>\<in\>C<around|(|<T><rsup|d>|)>\<rtimes\><N>>
    is the image of the function <math|z<rsup|n>> in
    <math|C<around|(|<T><rsup|d>|)>>, the corresponding KMS<rsub|<math|log
    N>> state <math|\<psi\>> on <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>,L><N>>
    satisfies

    <align*|<tformat|<table|<row|<cell|\<psi\>*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>*<wide|v|\<bar\>><rsup|\<ast\>l>*<wide|u|\<bar\>><rsub|n><rsup|\<ast\>>|)>>|<cell|=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
    >k=l>>|<row|<cell|<big|int><rsub|<T><rsup|d>>N<rsup|-k>*z<rsup|m>*z<rsup|-n>*<space|0.17em>d*\<lambda\><around|(|z|)>>|<cell|<text|if
    >k=l>>>>>>>|<row|<cell|>|<cell|=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
    <math|k=l> and >m=n>>|<row|<cell|N<rsup|-k>>|<cell|<text|if <math|k=l>
    and <math|m=n>.>>>>>>>>>>>

    Thus Exel's result also gives the KMS<rsub|<math|log N>> state described
    in Theorem<nbsp><reference|betalogN>, even though his state was obtained
    by factoring through a different expectation on
    <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>,L><N>>.
  </remark>

  <section|Existence of KMS states for <math|\<beta\>\<gtr\>log
  <around|\||det A|\|>>.><label|sec-existence>

  Our goal here is to prove the existence of KMS<rsub|<math|\<beta\>>> states
  for <math|\<beta\>\<gtr\>log <around|\||det A|\|>>. Note that, when
  <math|A> is a dilation matrix, Lemma<nbsp><reference|dilpure> implies that
  the sum on the right-hand side of <eqref|formpsibetamu> is finite.

  <\prop>
    <label|existforbeta\<gtr\>1>Suppose that
    <math|A\<in\>M<rsub|d><around|(|<Z>|)>> satisfies <math|det A\<neq\>0>
    and that <math|\<beta\>\<gtr\>log <around|\||det A|\|>>. Then for each
    probability measure <math|\<mu\>> on <math|<T><rsup|d>>, there is a
    KMS<rsub|<math|\<beta\>>> state <math|\<psi\>=\<psi\><rsub|\<beta\>,\<mu\>>>
    of <math|<around|(|<TT><around|(|M<rsub|L>|)>,\<sigma\>|)>> such that
    <math|\<psi\>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>>
    vanishes unless <math|k=l> and <math|m-n\<in\>B<rsup|k><Z><rsup|d>>, and

    <\equation>
      <label|formpsibetamu>\<psi\>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>=<around|(|1-<around|\||det
      A|\|>*e<rsup|-\<beta\>>|)>*<big|sum><rsub|<around|{|j\<geq\>k<space|0.27em>:<space|0.27em>m-n\<in\>B<rsup|j><Z><rsup|d>|}>><around|\||det
      A|\|><rsup|j-k>*e<rsup|-j*\<beta\>>*<big|int><rsub|<T><rsup|d>>z<rsup|B<rsup|-j>*<around|(|m-n|)>>*<space|0.17em>d*\<mu\><around|(|z|)>
    </equation>

    when <math|k=l> and <math|m-n\<in\>B<rsup|k><Z><rsup|d>>.
  </prop>

  We use the representation <math|M> of <math|C<around|(|<T><rsup|d>|)>> by
  multiplication operators on <math|L<rsup|2>*<around|(|<T><rsup|d>,d*\<mu\>|)>>,
  and use the same notation for the corresponding unitary representation of
  <math|<Z><rsup|d>>, so that <math|M<rsub|m>\<assign\>M<around|(|\<gamma\><rsub|m>|)>>.
  For each <math|j\<in\><N>>, we have a unitary representation
  <math|M\<circ\>B<rsup|-j>> of the subgroup <math|B<rsup|j><Z><rsup|d>> of
  <math|<Z><rsup|d>>, and we denote by <math|<HH><rsub|j>> the Hilbert space
  of the induced representation <math|<Ind><rsub|B<rsup|j><Z><rsup|d>><rsup|<Z><rsup|d>>M\<circ\>B<rsup|-j>>.
  Our state <math|\<psi\><rsub|\<beta\>,\<mu\>>> will be built from vector
  states for a representation <math|\<pi\><rsub|\<mu\>>> of
  <math|<TT><around|(|M<rsub|L>|)>> on <math|<HH><rsub|\<mu\>>\<assign\><big|oplus><rsub|j=0><rsup|\<infty\>><HH><rsub|j>>.

  We will need to do some calculations in the Hilbert spaces
  <math|<HH><rsub|j>>, and for this it is convenient to use the sets
  <math|\<Sigma\><rsub|j>> described in <eqref|defSigmak>; for
  <math|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>>, we write
  <math|c<rsub|j><around|(|g|)>> for the element of <math|\<Sigma\><rsub|j>>
  such that <math|c<rsub|j><around|(|g|)>\<in\>g>. Then (from
  <cite-detail|tfb|page<nbsp>296>, for example) <math|<HH><rsub|j>> is the
  completion of the space

  <\equation*>
    <VV><rsub|c>\<assign\><around*|{|\<xi\>:<Z><rsup|d>\<to\>L<rsup|2>*<around|(|<T><rsup|d>,d*\<mu\>|)>*<text|such
    that >\<xi\>*<around|(|m-n|)>=M<rsub|B<rsup|-j>*n><around|(|\<xi\><around|(|m|)>|)>*<text|for
    >n\<in\>B<rsup|j><Z><rsup|d>|}>
  </equation*>

  in the inner product defined by

  <\equation*>
    <around|(|\<xi\><space|0.17em>\|<space|0.17em>\<eta\>|)>=<big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>><around*|(|\<xi\><around|(|c<rsub|j><around|(|g|)>|)><space|0.17em>\|<space|0.17em>\<eta\><around|(|c<rsub|j><around|(|g|)>|)>|)>=<big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>><big|int><rsub|<T><rsup|d>>\<xi\><around|(|c<rsub|j><around|(|g|)>|)><around|(|z|)><wide|\<eta\><around|(|c<rsub|j><around|(|g|)>|)><around|(|z|)>|\<bar\>><space|0.17em>d*\<mu\><around|(|z|)>.
  </equation*>

  (Although we have used the cross-section <math|c<rsub|j>> to get a useful
  formula for the inner product, the translation condition on <math|\<xi\>>
  and <math|\<eta\>> means that this inner product does not depend on the
  choice of <math|c<rsub|j>>.) Then the induced representation acts on
  <math|<HH><rsub|j>> by

  <\equation*>
    <around*|(|<around|(|<Ind><rsub|B<rsup|j><Z><rsup|d>><rsup|<Z><rsup|d>>M\<circ\>B<rsup|-j>|)><rsub|m>*\<xi\>|)><around|(|n|)>=\<xi\>*<around|(|n-m|)>.
  </equation*>

  We now take <math|U> to be the unitary representation of <math|<Z><rsup|d>>
  on <math|<HH><rsub|\<mu\>>> defined by

  <\equation*>
    U\<assign\><with|math-display|false|<big|oplus><rsub|j=0><rsup|\<infty\>><around*|(|<Ind><rsub|B<rsup|j><Z><rsup|d>><rsup|<Z><rsup|d>>M\<circ\>B<rsup|-j>|)>.>
  </equation*>

  For each <math|j\<geq\>0> and <math|\<xi\>\<in\><HH><rsub|j>>, we define

  <\equation*>
    <around|(|V<rsub|j>*\<xi\>|)><around|(|m|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
    >m\<in\>B<Z><rsup|d>>>|<row|<cell|\<xi\>*<around|(|B<rsup|-1>*m|)>>|<cell|<text|if
    <math|m\<in\>B<Z><rsup|d>>;>>>>>>
  </equation*>

  a quick calculation shows that <math|V<rsub|j>*\<xi\>> belongs to
  <math|<HH><rsub|j+1>>. The <math|V<rsub|j>> combine to give an isometry
  <math|V> on <math|<HH><rsub|\<mu\>>=<big|oplus><rsub|j><HH><rsub|j>>, and
  the adjoint <math|V<rsup|\<ast\>>> is given on <math|<HH><rsub|j+1>> by the
  formula <math|<around|(|V<rsup|\<ast\>>*\<xi\>|)><around|(|n|)>=\<xi\>*<around|(|B*n|)>>.
  Calculations show that the pair <math|<around|(|U,V|)>> satisfies (E1) and
  (E2), and hence there is a representation <math|\<pi\><rsub|\<mu\>>> of
  <math|<TT><around|(|M<rsub|L>|)>> on <math|<HH><rsub|\<mu\>>> such that
  <math|\<pi\><rsub|\<mu\>><around|(|u<rsub|m>|)>=U<rsub|m>> and
  <math|\<pi\><rsub|\<mu\>><around|(|v|)>=V>.

  We now let <math|e<rsub|0,0>> be the constant function <math|1> viewed as a
  unit vector in <math|<HH><rsub|0>=L<rsup|2>*<around|(|<T><rsup|d>,d*\<mu\>|)>>.
  For <math|j\<in\><N>> and <math|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>>,
  we define <math|e<rsub|j,g>\<assign\>U<rsub|c<rsub|j><around|(|g|)>>*V<rsup|j>*e<rsub|0,0>>,
  so that for each <math|j>,

  <\equation*>
    <around*|{|e<rsub|j,g>:g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>|}>
  </equation*>

  is an orthonormal set of <math|<around|\||det B|\|><rsup|j>=<around|\||det
  A|\|><rsup|j>> vectors in <math|<HH><rsub|j>>. We view them as elements of
  <math|<HH><rsub|\<mu\>>> by adding <math|0>s in the other summands.
  Inspired by the proof of <cite-detail|lr|Proposition<nbsp>9.3>, we define

  <\equation*>
    \<psi\><around|(|T|)>\<assign\><around|(|1-<around|\||det
    A|\|>*e<rsup|-\<beta\>>|)>*<big|sum><rsub|j=0><rsup|\<infty\>><big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>>e<rsup|-j*\<beta\>>*<around*|(|\<pi\><rsub|\<mu\>><around|(|T|)>*e<rsub|j,g><space|0.17em>\|<space|0.17em>e<rsub|j,g>|)>.
  </equation*>

  Summing the geometric series <math|<big|sum><rsub|j><around|(|<around|\||det
  A|\|>*e<rsup|-\<beta\>>|)><rsup|j>> shows that this series converges in
  norm in <math|<TT><around|(|M<rsub|L>|)><rsup|\<ast\>>>, and that the sum
  is a state <math|\<psi\>> of <math|<TT><around|(|M<rsub|L>|)>>.

  Next we fix <math|m,n\<in\><Z><rsup|d>> and <math|k,l\<in\><N>>, and verify
  the formula for <math|\<psi\>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>>.
  Then

  <\equation*>
    V<rsup|\<ast\>l>*U<rsub|n><rsup|\<ast\>>*e<rsub|j,g>=V<rsup|\<ast\>l>*U<rsub|n><rsup|\<ast\>>*U<rsub|c<rsub|j><around|(|g|)>>*V<rsup|j>*e<rsub|0,0>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
    >l\<leq\>j>>|<row|<cell|V<rsup|\<ast\>l>*U<rsub|c<rsub|j><around|(|g|)>-n>*V<rsup|j>*e<rsub|0,0>>|<cell|<text|if
    >l\<leq\>j>>>>>
  </equation*>

  belongs to <math|<HH><rsub|j-l>>, and hence

  <align*|<tformat|<table|<row|<cell|<around*|(|\<pi\><rsub|\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>|\<nobracket\>>>|<cell|<around*|\<nobracket\>|e<rsub|j,g><space|0.17em>\|<space|0.17em>e<rsub|j,g>|)>=<around*|(|V<rsup|\<ast\>l>*U<rsub|n><rsup|\<ast\>>*e<rsub|j,g><space|0.17em>\|<space|0.17em>V<rsup|\<ast\>k>*U<rsub|m><rsup|\<ast\>>*e<rsub|j,g>|)>>>|<row|<cell|>|<cell|=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
  >k=l\<leq\>j>>|<row|<cell|<around*|(|V<rsup|\<ast\>k>*U<rsub|c<rsub|j><around|(|g|)>-n>*V<rsup|j>*e<rsub|0,0><space|0.17em>\|<space|0.17em>V<rsup|\<ast\>k>*U<rsub|c<rsub|j><around|(|g|)>-m>*V<rsup|j>*e<rsub|0,0>|)>>|<cell|<text|if
  <math|k=l\<leq\>j>.>>>>>>>>>>>

  We now recall that <math|<HH><rsub|j-k>> is the Hilbert space of the
  representation <math|<Ind><rsub|B<rsup|j-k><Z><rsup|d>><rsup|<Z><rsup|d>><around|(|M\<circ\>B<rsup|j-k>|)>>,
  and hence

  <align|<tformat|<table|<row|<cell|<around*|(|V<rsup|\<ast\>k>|\<nobracket\>>>|<cell|<around*|\<nobracket\>|U<rsub|c<rsub|j><around|(|g|)>-n>*V<rsup|j>*e<rsub|0,0><space|0.17em>\|<space|0.17em>V<rsup|\<ast\>k>*U<rsub|c<rsub|j><around|(|g|)>-m>*V<rsup|j>*e<rsub|0,0>|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|h\<in\><Z><rsup|d>/B<rsup|j-k><Z><rsup|d>><around*|(|V<rsup|\<ast\>k>*U<rsub|c<rsub|j><around|(|g|)>-n>*V<rsup|j>*e<rsub|0,0><around|(|c<rsub|j-k><around|(|h|)>|)><space|0.17em>\|<space|0.17em>V<rsup|\<ast\>k>*U<rsub|c<rsub|j><around|(|g|)>-m>*V<rsup|j>*e<rsub|0,0><around|(|c<rsub|j-k><around|(|h|)>|)>|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|h\<in\><Z><rsup|d>/B<rsup|j-k><Z><rsup|d>><around*|(|U<rsub|c<rsub|j><around|(|g|)>-n>*V<rsup|j>*e<rsub|0,0>*<around|(|B<rsup|k>*c<rsub|j-k><around|(|h|)>|)><space|0.17em>\|<space|0.17em>U<rsub|c<rsub|j><around|(|g|)>-m>*V<rsup|j>*e<rsub|0,0>*<around|(|B<rsup|k>*c<rsub|j-k><around|(|h|)>|)>|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|h\<in\><Z><rsup|d>/B<rsup|j-k><Z><rsup|d>><around*|(|V<rsup|j>*e<rsub|0,0>*<around|(|B<rsup|k>*c<rsub|j-k><around|(|h|)>-c<rsub|j><around|(|g|)>+n|)><space|0.17em>\|<space|0.17em>V<rsup|j>*e<rsub|0,0>*<around|(|B<rsup|k>*c<rsub|j-k><around|(|h|)>-c<rsub|j><around|(|g|)>+m|)>|)>.<label|formforip2>>>>>>

  The <math|h>-summand vanishes unless both

  <\equation>
    <label|condsongh>B<rsup|k>*c<rsub|j-k><around|(|h|)>-c<rsub|j><around|(|g|)>+n\<in\>B<rsup|j><Z><rsup|d><text|and
    >B<rsup|k>*c<rsub|j-k><around|(|h|)>-c<rsub|j><around|(|g|)>+m\<in\>B<rsup|j><Z><rsup|d>.
  </equation>

  As a function in the Hilbert space

  <\equation*>
    <around*|\<nobracket\>|<HH><rsub|0>=<HH><around|(|<Ind><rsub|<Z><rsup|d>><rsup|<Z><rsup|d>>M|)>=<around*|{|\<xi\>:<Z><rsup|d>\<to\>L<rsup|2>*<around|(|<T><rsup|d>,d*\<mu\>|)>*<text|such
    that >\<xi\>|(>-n)=M<rsub|n>*\<xi\><around|(|0|)>|}>,
  </equation*>

  <math|e<rsub|0,0>> satisfies <math|e<rsub|0,0><around|(|q|)><around|(|z|)>=z<rsup|-q>>,
  and <math|<around|(|V<rsup|j>*e<rsub|0,0>|)>*<around|(|B<rsup|j>*q|)><around|(|z|)>=e<rsub|0,0><around|(|q|)><around|(|z|)>=z<rsup|-q>>.
  Thus, when both criteria in <eqref|condsongh> are satisfied, we have

  <align|<tformat|<table|<row|<cell|<around*|(|\<pi\><rsub|\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>k>*u<rsub|n><rsup|\<ast\>>|)>*e<rsub|j,g><space|0.17em>|\<nobracket\>>>|<cell|<around*|\||<space|0.17em>e<rsub|j,g>|)>=<around*|(|V<rsup|\<ast\>k>*U<rsub|c<rsub|j><around|(|g|)>-n>*V<rsup|j>*e<rsub|0,0><space|0.17em>\|<space|0.17em>V<rsup|\<ast\>k>*U<rsub|c<rsub|j><around|(|g|)>-m>*V<rsup|j>*e<rsub|0,0>|)><label|calcip1>>>|<row|<cell|>|<cell|=<big|int><rsub|<T><rsup|d>>z<rsup|-B<rsup|-j>*<around|(|B<rsup|k>*c<rsub|j-k><around|(|h|)>-c<rsub|j><around|(|g|)>+n|)>><wide|z<rsup|-B<rsup|-j>*<around|(|B<rsup|k>*c<rsub|j-k><around|(|h|)>-c<rsub|j><around|(|g|)>+m|)>>|\<bar\>><space|0.17em>d*\<mu\><around|(|z|)>>>|<row|<cell|>|<cell|=<big|int><rsub|<T><rsup|d>>z<rsup|B<rsup|-j>*<around|(|m-n|)>>*<space|0.17em>d*\<mu\><around|(|z|)>.<label|calcip>>>>>>

  (Notice that when <eqref|condsongh> holds, we have
  <math|m-n\<in\>B<rsup|j><Z><rsup|d>>, so the last integral makes sense.)
  For each pair <math|m,n> such that <math|m-n> is in
  <math|B<rsup|j><Z><rsup|d>>, and each <math|h> in
  <math|<Z><rsup|d>/B<rsup|j-k><Z><rsup|d>>, there is exactly one <math|g>
  such that <eqref|condsongh> holds. Thus, using <eqref|formforip2> to view

  <\equation>
    <label|collapsiblesum><big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>>e<rsup|-j*\<beta\>>*<around*|(|\<pi\><rsub|\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>*e<rsub|j,g><space|0.17em>\|<space|0.17em>e<rsub|j,g>|)>
  </equation>

  as a sum over <math|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>> and
  <math|h\<in\><Z><rsup|d>/B<rsup|j-k><Z><rsup|d>>, we find that
  <eqref|collapsiblesum> has exactly

  <\equation*>
    <around|\||<Z><rsup|d>/B<rsup|j-k><Z><rsup|d>|\|>=<around|\||det
    A|\|><rsup|j-k>
  </equation*>

  nonzero terms, each of which is equal to <eqref|calcip>. Thus
  <math|\<psi\>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>>
  vanishes unless <math|k=l> and <math|m-n\<in\>B<rsup|k><Z><rsup|d>>, and
  then equals

  <\equation>
    <label|ansforpsi><around|(|1-<around|\||det
    A|\|>*e<rsup|-\<beta\>>|)>*<big|sum><rsub|<around|{|j\<geq\>k<space|0.27em>:<space|0.27em>m-n\<in\>B<rsup|j><Z><rsup|d>|}>><around|\||det
    A|\|><rsup|j-k>*e<rsup|-j*\<beta\>>*<big|int><rsub|<T><rsup|d>>z<rsup|B<rsup|-j>*<around|(|m-n|)>>*<space|0.17em>d*\<mu\><around|(|z|)>,
  </equation>

  as stated in the Proposition.

  We still need to prove that <math|\<psi\>> is a KMS<rsub|<math|\<beta\>>>
  state, and we will do this using Proposition<nbsp><reference|charKMSbeta>.
  So we need to compute <math|e<rsup|-k*\<beta\>>*\<psi\><around|(|u<rsub|B<rsup|-k>*<around|(|m-n|)>>|)>>
  under the assumption that <math|m-n\<in\>B<rsup|k><Z><rsup|d>>. We have
  already done most of the work: the calculation <eqref|calcip1> shows that

  <align*|<tformat|<table|<row|<cell|e<rsup|-k*\<beta\>>>|<cell|\<psi\><around|(|u<rsub|B<rsup|-k>*<around|(|m-n|)>>|)>=e<rsup|-k*\<beta\>>*<around|(|1-<around|\||det
  A|\|>*e<rsup|-\<beta\>>|)>*<big|sum><rsub|j<rprime|'>=0><rsup|\<infty\>><big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j<rprime|'>><Z><rsup|d>>e<rsup|-j<rprime|'>*\<beta\>>*<around*|(|U<rsub|B<rsup|-k>*<around|(|m-n|)>>*e<rsub|j<rprime|'>,g><space|0.17em>\|<space|0.17em>e<rsub|j<rprime|'>,g>|)>>>|<row|<cell|>|<cell|=e<rsup|-k*\<beta\>>*<around|(|1-<around|\||det
  A|\|>*e<rsup|-\<beta\>>|)>*<big|sum><rsub|<around|{|j<rprime|'><space|0.27em>:<space|0.27em>B<rsup|-k>*<around|(|m-n|)>\<in\>B<rsup|j<rprime|'>><Z><rsup|d>|}>><big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j<rprime|'>><Z><rsup|d>>e<rsup|-j<rprime|'>*\<beta\>>*<big|int><rsub|<T><rsup|d>>z<rsup|B<rsup|-j<rprime|'>>*B<rsup|-k>*<around|(|m-n|)>>*<space|0.17em>d*\<mu\><around|(|z|)>>>|<row|<cell|>|<cell|=e<rsup|-k*\<beta\>>*<around|(|1-<around|\||det
  A|\|>*e<rsup|-\<beta\>>|)>*<big|sum><rsub|<around|{|j<rprime|'><space|0.27em>:<space|0.27em>B<rsup|-k>*<around|(|m-n|)>\<in\>B<rsup|j<rprime|'>><Z><rsup|d>|}>><around|\||det
  A|\|><rsup|j<rprime|'>>*e<rsup|-j<rprime|'>*\<beta\>>*<big|int><rsub|<T><rsup|d>>z<rsup|B<rsup|-j<rprime|'>>*B<rsup|-k>*<around|(|m-n|)>>*<space|0.17em>d*\<mu\><around|(|z|)>,>>>>>

  which reduces to <eqref|ansforpsi> on writing <math|j=j<rprime|'>+k>. Thus
  Proposition<nbsp><reference|charKMSbeta> implies that <math|\<psi\>> is a
  KMS<rsub|<math|\<beta\>>> state, and this completes the proof of
  Proposition<nbsp><reference|existforbeta\<gtr\>1>.

  <section|Parametrisation of KMS<rsub|<math|\<beta\>>>
  states><label|sec-par>

  <\prop>
    <label|parametrisation>Suppose that <math|A\<in\>M<rsub|d><around|(|<Z>|)>>
    has nonzero determinant and <math|\<beta\>\<gtr\>log <around|\||det
    A|\|>>. Then the map <math|\<mu\>\<mapsto\>\<psi\><rsub|\<beta\>,\<mu\>>>
    of Proposition<nbsp><reference|existforbeta\<gtr\>1> is an affine
    homeomorphism of the simplex <math|P<around|(|<T><rsup|d>|)>> of
    probability measures onto the simplex of KMS<rsub|<math|\<beta\>>> states
    for <math|<around|(|<TT><around|(|M<rsub|L>|)>,\<sigma\>|)>>.
  </prop>

  As in <cite-detail|lr|10>, the crux of the argument is a reconstruction
  formula which allows us to recover a KMS<rsub|<math|\<beta\>>> state from
  its \Pconditioning\Q <math|\<phi\><rsub|P>> to a corner
  <math|P<TT><around|(|M<rsub|L>|)>*P>. In the present situation, though, the
  projection

  <\equation*>
    P\<assign\>1-<big|sum><rsub|g\<in\><Z><rsup|d>/B<Z><rsup|d>>u<rsub|c<around|(|g|)>>*v*v<rsup|\<ast\>>*u<rsub|c<around|(|g|)>><rsup|\<ast\>>=<big|prod><rsub|g\<in\><Z><rsup|d>/B<Z><rsup|d>><around|(|1-u<rsub|c<around|(|g|)>>*v*v<rsup|\<ast\>>*u<rsub|c<around|(|g|)>><rsup|\<ast\>>|)>
  </equation*>

  belongs to <math|<TT><around|(|M<rsub|L>|)>>, so we don't need to resort to
  spatial arguments to make sense of the conditioning: we can just define

  <\equation*>
    \<phi\><rsub|P><around|(|a|)>=<frac|1|1-<around|\||det
    A|\|>*e<rsup|-\<beta\>>>*\<phi\>*<around|(|P*a*P|)>,
  </equation*>

  and then since <math|\<phi\>*<around|(|u<rsub|c<around|(|g|)>>*v*v<rsup|\<ast\>>*u<rsub|c<around|(|g|)>><rsup|\<ast\>>|)>=e<rsup|-\<beta\>>>,
  the normalising factor ensures that <math|\<phi\><rsub|P>> is a state of
  <math|<TT><around|(|M<rsub|L>|)>>. We can now state our reconstruction
  formula.

  <\prop>
    <label|reconstruct>Suppose that <math|\<beta\>\<gtr\>log <around|\||det
    A|\|>>, and that <math|\<phi\>> is a KMS<rsub|<math|\<beta\>>> state on
    <math|<TT><around|(|M<rsub|L>|)>>. Then for every
    <math|a\<in\><TT><around|(|M<rsub|L>|)>> we have

    <\equation>
      <label|reconform>\<phi\><around|(|a|)>=lim<rsub|n\<to\>\<infty\>><around|(|1-<around|\||det
      A|\|>*e<rsup|-\<beta\>>|)>*<big|sum><rsub|j=0><rsup|n><big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>>e<rsup|-j*\<beta\>>*\<phi\><rsub|P>*<around*|(|v<rsup|\<ast\>j>*u<rsub|c<rsub|j><around|(|g|)>><rsup|\<ast\>>*a*u<rsub|c<rsub|j><around|(|g|)>>*v<rsup|j>|)>.
    </equation>
  </prop>

  Convergence of the limit in Proposition<nbsp><reference|reconstruct> will
  follow from the following simple lemma:

  <\lemma>
    <label|approxstate>Suppose that <math|\<phi\>> is a state of a unital
    <math|C<rsup|\<ast\>>>-algebra <math|A>, and that
    <math|<around|{|p<rsub|n>|}>> is a sequence of projections in <math|A>
    such that <math|\<phi\><around|(|p<rsub|n>|)>\<to\>1>. Then
    <math|\<phi\>*<around|(|p<rsub|n>*a*p<rsub|n>|)>\<to\>\<phi\><around|(|a|)>>
    for every <math|a\<in\>A>.
  </lemma>

  <\proof>
    We know that <math|\<phi\>*<around|(|1-p<rsub|n>|)>=1-\<phi\><around|(|p<rsub|n>|)>\<to\>0>,
    so the Cauchy-Schwarz inequality for <math|\<phi\>> implies that
    <math|\<phi\>*<around|(|a*<around|(|1-p<rsub|n>|)>|)>\<to\>0> for all
    <math|a\<in\>A>. Another application of the Cauchy-Schwarz inequality
    shows that <math|\<phi\>*<around|(|p<rsub|n>*a*<around|(|1-p<rsub|n>|)>|)>\<to\>0>
    also, so

    <\equation*>
      \<phi\><around|(|a|)>-\<phi\>*<around|(|p<rsub|n>*a*p<rsub|n>|)>=\<phi\>*<around|(|a*<around|(|1-p<rsub|n>|)>|)>+\<phi\>*<around|(|<around|(|1-p<rsub|n>|)>*a*p<rsub|n>|)>\<to\>0.
    </equation*>
  </proof>

  When we apply Lemma<nbsp><reference|approxstate>, the projections
  <math|p<rsub|n>> will be sums of the projections in the next proposition.

  <\prop>
    <label|Psorthog>For <math|j\<in\><N>> and
    <math|g\<in\><Z><rsup|d>/B<rsup|p><Z><rsup|d>> we define

    <\equation*>
      P<rsub|j,g>\<assign\>u<rsub|c<rsub|j><around|(|g|)>>*v<rsup|j>*P*v<rsup|\<ast\>j>*u<rsub|c<rsub|j><around|(|g|)>><rsup|\<ast\>>.
    </equation*>

    Then the <math|P<rsub|j,g>> are mutually orthogonal projections in
    <math|<TT><around|(|M<rsub|L>|)>>.
  </prop>

  The proposition follows from the next lemma.

  <\lemma>
    <label|calcorthog>For each pair <math|<around|(|j,g|)>> and
    <math|<around|(|l,h|)>> we have

    <\equation*>
      P*v<rsup|\<ast\>j>*u<rsub|c<rsub|j><around|(|g|)>><rsup|\<ast\>>*u<rsub|c<rsub|j><around|(|h|)>>*v<rsup|l>*P=<choice|<tformat|<table|<row|<cell|P>|<cell|<text|if
      <math|j=l> and >g=h>>|<row|<cell|0>|<cell|<text|otherwise.>>>>>>
    </equation*>
  </lemma>

  <\proof>
    If <math|j\<neq\>l>, say <math|j\<less\>l>, then for
    <math|m\<in\><Z><rsup|d>> we have

    <\equation*>
      P*v<rsup|\<ast\>j>*u<rsub|m>*v<rsup|l>*P=<choice|<tformat|<table|<row|<cell|P*u<rsub|B<rsup|-j>*m>*v<rsup|l-j>*P>|<cell|<text|if
      >m\<in\>B<rsup|j><Z><rsup|d>>>|<row|<cell|0>|<cell|<text|otherwise.>>>>>>
    </equation*>

    Now every <math|n\<in\><Z><rsup|d>> (including <math|n=B<rsup|-j>*m>) has
    the form <math|n=c<around|(|n|)>+B*k>, so

    <\equation*>
      P*u<rsub|n>*v<rsup|l-j>*P=P*u<rsub|c<around|(|n|)>+B*k>*v*v<rsup|l-j-1>*P=P*u<rsub|c<around|(|n|)>>*v*u<rsub|k>*v<rsup|l-j-1>*P,
    </equation*>

    which vanishes because <math|P> contains the factor
    <math|<around|(|1-u<rsub|c<around|(|n|)>>*v*v<rsup|\<ast\>>*u<rsub|c<around|(|n|)>><rsup|\<ast\>>|)>>.
    So <math|P*v<rsup|\<ast\>j>*u<rsub|m>*v<rsup|l>*P> vanishes when
    <math|j\<neq\>l>, and for <math|j=l>,
    <math|P*v<rsup|\<ast\>j>*u<rsub|c<rsub|j><around|(|h|)>-c<rsub|j><around|(|g|)>>*v<rsup|j>*P>
    vanishes unless <math|c<rsub|j><around|(|h|)>-c<rsub|j><around|(|g|)>>
    belongs to <math|B<rsup|j><Z><rsup|d>>, which occurs precisely when
    <math|g=h> in <math|<Z><rsup|d>/B<rsup|j><Z><rsup|d>>.
  </proof>

  <\proof>
    <dueto|Proof of Proposition<nbsp><reference|reconstruct>>We aim to apply
    Lemma<nbsp><reference|approxstate> with

    <\equation*>
      p<rsub|n>\<assign\><big|sum><rsub|j=0><rsup|n><big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>>P<rsub|j,g>,
    </equation*>

    which is a projection by Proposition<nbsp><reference|Psorthog>. So we
    need to compute <math|\<phi\><around|(|p<rsub|n>|)>>, which we do using
    the KMS condition:

    <align*|<tformat|<table|<row|<cell|\<phi\><around|(|p<rsub|n>|)>>|<cell|=<big|sum><rsub|j=0><rsup|n><big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>>\<phi\><around|(|P<rsub|j,g>|)>=<big|sum><rsub|j=0><rsup|n><big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>>\<phi\>*<around*|(|u<rsub|c<rsub|j><around|(|g|)>>*v<rsup|j>*P*v<rsup|\<ast\>j>*u<rsub|c<rsub|j><around|(|g|)>><rsup|\<ast\>>|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|j=0><rsup|n><big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>>e<rsup|-j*\<beta\>>*\<phi\>*<around*|(|P*v<rsup|\<ast\>j>*u<rsub|c<rsub|j><around|(|g|)>><rsup|\<ast\>>*u<rsub|c<rsub|j><around|(|g|)>>*v<rsup|j>*P|)>>>|<row|<cell|>|<cell|=\<phi\><around|(|P|)>*<big|sum><rsub|j=0><rsup|n><around|\||det
    A|\|><rsup|j>*e<rsup|-j*\<beta\>><space|2em><text|(by
    Lemma<nbsp><reference|calcorthog>)>>>|<row|<cell|>|<cell|=<around|(|1-<around|\||det
    A|\|>*e<rsup|-\<beta\>>|)>*<big|sum><rsub|j=0><rsup|n><around|\||det
    A|\|><rsup|j>*e<rsup|-j*\<beta\>>,>>>>>

    which on summing the geometric series converges to <math|1> as
    <math|n\<to\>\<infty\>>. So Lemma<nbsp><reference|approxstate> implies
    that for every <math|a\<in\><TT><around|(|M<rsub|L>|)>>, we have

    <\equation*>
      \<phi\><around|(|a|)>=lim<rsub|n\<to\>\<infty\>>
      <big|sum><rsub|j,l=0><rsup|n><big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>><big|sum><rsub|h\<in\><Z><rsup|d>/B<rsup|l><Z><rsup|d>>\<phi\>*<around|(|P<rsub|j,g>*a*P<rsub|l,h>|)>.
    </equation*>

    Applying the KMS condition shows that this sum is

    <align*|<tformat|<table|<row|<cell|lim<rsub|n\<to\>\<infty\>>
    <big|sum><rsub|j,l=0><rsup|n><big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>><big|sum><rsub|h\<in\><Z><rsup|d>/B<rsup|l><Z><rsup|d>>e<rsup|-j*\<beta\>>*\<phi\>*<around*|(|P*v<rsup|\<ast\>j>*u<rsub|c<rsub|j><around|(|g|)>><rsup|\<ast\>>*a*u<rsub|c<rsub|l><around|(|h|)>>*v<rsup|l>*P*v<rsup|\<ast\>l>*u<rsub|c<rsub|l><around|(|h|)>><rsup|\<ast\>>*<around|(|u<rsub|c<rsub|j><around|(|g|)>>*v<rsup|j>*P|)>|)>,>>>>>

    and it follows from Lemma<nbsp><reference|calcorthog> that the summands
    are zero unless <math|j=l> and <math|g=h>, in which case the right-hand
    factor <math|P*v<rsup|\<ast\>l>*u<rsub|c<rsub|l><around|(|h|)>><rsup|\<ast\>>*u<rsub|c<rsub|j><around|(|g|)>>*v<rsup|j>*P>
    collapses to <math|P>, and we recover the desired formula
    <eqref|reconform>.
  </proof>

  <\proof>
    <dueto|Proof of Proposition<nbsp><reference|parametrisation>>The formula
    <eqref|formpsibetamu> for <math|\<psi\><rsub|\<beta\>,\<mu\>>> shows that
    <math|\<mu\>\<mapsto\>\<psi\><rsub|\<beta\>,\<mu\>>> is affine and weak*
    continuous, and both sets of states are weak* compact, so it suffices to
    show that <math|\<mu\>\<mapsto\>\<psi\><rsub|\<beta\>,\<mu\>>> is
    surjective and one-to-one.

    To see that <math|\<mu\>\<mapsto\>\<psi\><rsub|\<beta\>,\<mu\>>> is
    surjective, suppose that <math|\<phi\>> is a KMS<rsub|<math|\<beta\>>>
    state of <math|<TT><around|(|M<rsub|L>|)>>. On
    <math|C<rsup|\<ast\>><around|(|u|)>=C<around|(|<T><rsup|d>|)>>, the
    conditioned state <math|\<phi\><rsub|P>> is given by a probability
    measure <math|\<mu\>>; we choose <math|\<mu\>> such that

    <\equation*>
      \<phi\><rsub|P><around|(|u<rsub|m>|)>=<big|int><rsub|<T><rsup|d>>z<rsup|m>*<space|0.17em>d*\<mu\><around|(|z|)>*<text|for
      >m\<in\><Z><rsup|d>,
    </equation*>

    and aim to prove that <math|\<phi\>=\<psi\><rsub|\<beta\>,\<mu\>>>. Since
    both states are KMS<rsub|<math|\<beta\>>> states, formula <eqref|charKMS>
    shows that it suffices to check that <math|\<phi\><around|(|u<rsub|m>|)>=\<psi\><rsub|\<beta\>,\<mu\>><around|(|u<rsub|m>|)>>.
    Since <math|<Z><rsup|d>> is abelian, the reconstruction formula
    <eqref|reconform> implies that

    <align*|<tformat|<table|<row|<cell|\<phi\><around|(|u<rsub|m>|)>>|<cell|=lim<rsub|n\<to\>\<infty\>><around|(|1-<around|\||det
    A|\|>*e<rsup|-\<beta\>>|)>*<big|sum><rsub|j=0><rsup|n><big|sum><rsub|g\<in\><Z><rsup|d>/B<rsup|j><Z><rsup|d>>e<rsup|-j*\<beta\>>*\<phi\><rsub|P>*<around|(|v<rsup|\<ast\>j>*u<rsub|m>*v<rsup|j>|)>>>|<row|<cell|>|<cell|=lim<rsub|n\<to\>\<infty\>><around|(|1-<around|\||det
    A|\|>*e<rsup|-\<beta\>>|)>*<big|sum><rsub|j=0><rsup|n><around|\||det
    A|\|><rsup|j>*e<rsup|-j*\<beta\>>*\<phi\><rsub|P>*<around|(|v<rsup|\<ast\>j>*u<rsub|m>*v<rsup|j>|)>>>|<row|<cell|>|<cell|=lim<rsub|n\<to\>\<infty\>><around|(|1-<around|\||det
    A|\|>*e<rsup|-\<beta\>>|)>*<big|sum><rsub|<around|{|j\<leq\>n<space|0.27em>:<space|0.27em>m\<in\>B<rsup|j><Z><rsup|d>|}>><around|\||det
    A|\|><rsup|j>*e<rsup|-j*\<beta\>>*\<phi\><rsub|P><around|(|u<rsub|B<rsup|-j>*m>|)>>>|<row|<cell|>|<cell|=<around|(|1-<around|\||det
    A|\|>*e<rsup|-\<beta\>>|)>*<big|sum><rsub|<around|{|j<space|0.27em>:<space|0.27em>m\<in\>B<rsup|j><Z><rsup|d>|}>><around|\||det
    A|\|><rsup|j>*e<rsup|-j*\<beta\>>*<big|int><rsub|<T><rsup|d>>z<rsup|B<rsup|-j>*m>*<space|0.17em>d*\<mu\><around|(|z|)>,>>>>>

    which by <eqref|formpsibetamu> is precisely
    <math|\<psi\><rsub|\<beta\>,\<mu\>><around|(|u<rsub|m>|)>>. We have now
    proved surjectivity.

    To see that our map is one-to-one, suppose that <math|\<mu\>> and
    <math|\<nu\>> are probability measures on <math|<T><rsup|d>> and
    <math|\<psi\><rsub|\<beta\>,\<mu\>>=\<psi\><rsub|\<beta\>,\<nu\>>>. Write
    <math|M<rsub|\<mu\>><around|(|n|)>> for the <math|n>th moment
    <math|<big|int><rsub|<T><rsup|d>>z<rsup|n>*<space|0.17em>d*\<mu\><around|(|z|)>>
    of <math|\<mu\>>, and fix <math|m\<in\><Z><rsup|d>>. Two applications of
    <eqref|formpsibetamu> show that

    <\equation>
      <label|equatemoments><big|sum><rsub|<around|{|j<space|0.27em>:<space|0.27em>m\<in\>B<rsup|j><Z><rsup|d>|}>><around|\||det
      A|\|><rsup|j>*e<rsup|-j*\<beta\>>*M<rsub|\<mu\>>*<around|(|B<rsup|-j>*m|)>=<big|sum><rsub|<around|{|j<space|0.27em>:<space|0.27em>m\<in\>B<rsup|j><Z><rsup|d>|}>><around|\||det
      A|\|><rsup|j>*e<rsup|-j*\<beta\>>*M<rsub|\<nu\>>*<around|(|B<rsup|-j>*m|)>.
    </equation>

    The left-hand side of <eqref|equatemoments> can be rewritten as

    <align*|<tformat|<table|<row|<cell|M<rsub|\<mu\>>(m>|<cell|)+<big|sum><rsub|<around|{|j<space|0.27em>:<space|0.27em>j\<gtr\>0,<space|0.27em>m\<in\>B<rsup|j><Z><rsup|d>|}>><around|\||det
    A|\|><rsup|j>*e<rsup|-j*\<beta\>>*M<rsub|\<mu\>>*<around|(|B<rsup|-j>*m|)>>>|<row|<cell|>|<cell|=M<rsub|\<mu\>><around|(|m|)>+<around|\||det
    A|\|>*e<rsup|-\<beta\>>*<big|sum><rsub|<around|{|j<space|0.27em>:<space|0.27em>j\<gtr\>0,<space|0.27em>m\<in\>B<rsup|j><Z><rsup|d>|}>><around|\||det
    A|\|><rsup|j-1>*e<rsup|-<around|(|j-1|)>*\<beta\>>*M<rsub|\<mu\>>*<around|(|B<rsup|-<around|(|j-1|)>>*B<rsup|-1>*m|)>>>|<row|<cell|>|<cell|=M<rsub|\<mu\>><around|(|m|)>+<around|\||det
    A|\|>*e<rsup|-\<beta\>>*<big|sum><rsub|<around|{|j<rprime|'><space|0.27em>:<space|0.27em>B<rsup|-1>*m\<in\>B<rsup|j<rprime|'>><Z><rsup|d>|}>><around|\||det
    A|\|><rsup|j<rprime|'>>*e<rsup|-j<rprime|'>*\<beta\>>*M<rsub|\<mu\>>*<around|(|B<rsup|-j<rprime|'>>*B<rsup|-1>*m|)>,>>>>>

    which by <eqref|formpsibetamu> is

    <\equation*>
      <choice|<tformat|<table|<row|<cell|M<rsub|\<mu\>><around|(|m|)>>|<cell|<text|if
      <math|m> is not in >B<Z><rsup|d>>>|<row|<cell|M<rsub|\<mu\>><around|(|m|)>+<around|\||det
      A|\|>*e<rsup|-\<beta\>>*\<psi\><rsub|\<beta\>,\<mu\>><around|(|u<rsub|B<rsup|-1>*m>|)>>|<cell|<text|if
      <math|m\<in\>B<Z><rsup|d>>.>>>>>>
    </equation*>

    If <math|m> is not in <math|B<Z><rsup|d>>, then <eqref|equatemoments>
    says precisely that <math|M<rsub|\<mu\>><around|(|m|)>=M<rsub|\<nu\>><around|(|m|)>>;
    if <math|m\<in\>B<Z><rsup|d>>, then, since
    <math|\<psi\><rsub|\<beta\>,\<mu\>><around|(|u<rsub|B<rsup|-1>*m>|)>=\<psi\><rsub|\<beta\>,\<nu\>><around|(|u<rsub|B<rsup|-1>*m>|)>>,
    subtracting <math|<around|\||det A|\|>*e<rsup|-\<beta\>>*\<psi\><rsub|\<beta\>,\<mu\>><around|(|u<rsub|B<rsup|-1>*m>|)>>
    from both sides of <eqref|equatemoments> shows that
    <math|M<rsub|\<mu\>><around|(|m|)>=M<rsub|\<nu\>><around|(|m|)>>. Thus
    <math|\<mu\>> and <math|\<nu\>> have the same moments, and are therefore
    equal.
  </proof>

  <subsection|Limits of KMS states><label|seclimits>

  Proposition<nbsp><reference|parametrisation> describes all the
  KMS<rsub|<math|\<beta\>>> states for <math|\<beta\>\<gtr\>\<beta\><rsub|c>\<assign\>log
  <around|\||det A|\|>>, and Theorem<nbsp><reference|betalogN> says there is
  exactly one KMS<rsub|<math|\<beta\><rsub|c>>> state when <math|A> is a
  dilation matrix. So it is natural to ask what we can say about the
  KMS<rsub|<math|\<beta\><rsub|c>>> states when <math|A> is not a dilation
  matrix. General results from <cite|bra-rob> suggest that we might be able
  to find other KMS<rsub|<math|\<beta\><rsub|c>>> states by taking limits of
  KMS<rsub|<math|\<beta\>>> states as <math|\<beta\>\<to\>\<beta\><rsub|c>>
  from above.

  <\prop>
    <label|limitKMS>Let <math|\<mu\>\<in\>P<around|(|<T><rsup|d>|)>>. Then
    there is a decreasing sequence <math|\<beta\><rsub|n>\<to\>\<beta\><rsub|c>>
    such that <math|<around|{|\<psi\><rsub|\<beta\><rsub|n>,\<mu\>>|}>>
    converges weak* to a state <math|\<psi\><rsub|\<mu\>>>, and then
    <math|\<psi\><rsub|\<mu\>>> is a KMS<rsub|<math|\<beta\><rsub|c>>> state
    of <math|<around|(|T<around|(|M<rsub|L>|)>,\<sigma\>|)>>.
  </prop>

  <\proof>
    Choose any decreasing sequence converging to <math|\<beta\><rsub|c>>, and
    the weak* compactness of the state space implies that there is a
    subsequence <math|<around|{|\<beta\><rsub|n>|}>> such that
    <math|<around|{|\<psi\><rsub|\<beta\><rsub|n>,\<mu\>>|}>> converges in
    the weak* topology. Now <cite-detail|bra-rob|Proposition<nbsp>5.3.23>
    implies that the limit <math|\<psi\><rsub|\<mu\>>> is a
    KMS<rsub|<math|\<beta\><rsub|c>>> state, at least when
    <math|\<beta\><rsub|c>\<gtr\>0>. When <math|\<beta\><rsub|c>=0>,
    <cite-detail|bra-rob|Proposition<nbsp>5.3.23> only asserts that
    <math|\<psi\><rsub|\<mu\>>> is a trace (because that is what being a
    KMS<rsub|<math|0>> state means in <cite|bra-rob>). However,
    KMS<rsub|<math|\<beta\>>> states for <math|\<beta\>\<gtr\>0> are
    <math|\<sigma\>>-invariant, and hence so is the limit. Thus
    <math|\<psi\><rsub|\<mu\>>> is a KMS<rsub|<math|0>> state in the sense we
    are using.
  </proof>

  We now assume that <math|A> is not a dilation matrix, so that
  <math|<big|cap><rsub|j=0><rsup|\<infty\>>B<rsup|j><Z><rsup|d>> could be
  bigger than <math|<around|{|0|}>>. Suppose
  <math|\<beta\>\<gtr\>\<beta\><rsub|c>> and write
  <math|r=e<rsup|-<around|(|\<beta\>-\<beta\><rsub|c>|)>>>. As in the last
  proof, we write <math|M<rsub|\<mu\>><around|(|m|)>> for the <math|m>th
  moment <math|<big|int><rsub|<T><rsup|d>>z<rsup|m>*<space|0.17em>d*\<mu\><around|(|z|)>>.
  Rearranging <eqref|formpsibetamu> shows that
  <math|\<psi\><rsub|\<beta\>,\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>>
  vanishes unless <math|k=l> and <math|m-n\<in\>B<rsup|k><Z><rsup|d>>, and
  then equals

  <\equation>
    <label|formrewritten><big|sum><rsub|<around|{|j\<geq\>0<space|0.17em>:<space|0.17em>m-n\<in\>B<rsup|j+k><Z><rsup|d>|}>>e<rsup|-k*\<beta\>>*<around|(|1-r|)>*r<rsup|j>*M<rsub|\<mu\>>*<around|(|B<rsup|-<around|(|j+k|)>>*<around|(|m-n|)>|)>.
  </equation>

  So we want to compute the limit of <eqref|formrewritten> as
  <math|\<beta\>\<to\>\<beta\><rsub|c>>, in which case <math|r\<to\>1->. If
  <math|m-n> does not belong to <math|<big|cap><rsub|j=0><rsup|\<infty\>>B<rsup|j+k><Z><rsup|d>=<big|cap><rsub|j=0><rsup|\<infty\>>B<rsup|j><Z><rsup|d>>,
  then the sum in <eqref|formrewritten> is finite, and since
  <math|<around|(|1-r|)>*r<rsup|j>\<to\>0> as <math|r\<to\>1> for each fixed
  <math|j>, <eqref|formrewritten> converges to <math|0> as <math|r\<to\>1>.
  So it remains for us to compute the limit of <eqref|formrewritten> when
  <math|m-n\<in\><big|cap><rsub|j=0><rsup|\<infty\>>B<rsup|j><Z><rsup|d>>.
  Unfortunately, this seems to be a fairly delicate matter (see
  Remark<nbsp><reference|cantuseDCT> below), and the best we can do is
  illustrate the issues with some examples.

  <\itemize>
    <item*|(a)>If <math|\<mu\>> is normalised Haar measure on
    <math|<T><rsup|d>>, then <math|M<rsub|\<mu\>><around|(|0|)>=1> and
    <math|M<rsub|\<mu\>><around|(|m|)>=0> for all other <math|m>. The series
    in <eqref|formrewritten> is identically zero unless <math|m=n>, and then
    is geometric; summing it shows that

    <\equation*>
      \<psi\><rsub|\<beta\>,\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      <math|k=l> and >m=n>>|<row|<cell|e<rsup|-k*\<beta\>>>|<cell|<text|if
      <math|k=l> and <math|m=n>.>>>>>>
    </equation*>

    Letting <math|\<beta\>\<to\>\<beta\><rsub|c>> gives the state described
    in Theorem<nbsp><reference|betalogN>.

    <item*|(b)>If <math|\<mu\>> has the property that
    <math|M<rsub|\<mu\>><around|(|m|)>=1> for every
    <math|m\<in\><big|cap><rsub|j=0><rsup|\<infty\>>B<rsup|j><Z><rsup|d>>,
    then the series in <eqref|formrewritten> is geometric whenever
    <math|m-n\<in\><big|cap><rsub|j=0><rsup|\<infty\>>B<rsup|j><Z><rsup|d>>.
    Summing and letting <math|\<beta\>\<to\>\<beta\><rsub|c>> shows that the
    limit <math|\<psi\><rsub|\<mu\>>> satisfies

    <\equation*>
      \<psi\><rsub|\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      <math|k=l> and >m-n\<in\><big|cap><rsub|j=0><rsup|\<infty\>>B<rsup|j><Z><rsup|d>>>|<row|<cell|e<rsup|-k*\<beta\><rsub|c>>>|<cell|<text|if
      <math|k=l> and <math|m-n\<in\><big|cap><rsub|j=0><rsup|\<infty\>>B<rsup|j><Z><rsup|d>>.>>>>>>
    </equation*>

    <item*|(c)>The previous item (b) applies in particular to the point mass
    <math|\<delta\><rsub|1>> at the identity
    <math|1=<around|(|1,1,\<cdots\>,1|)>> of <math|<T><rsup|d>>. This shows
    that the KMS<rsub|<math|\<beta\><rsub|c>>> state in
    Theorem<nbsp><reference|betalogN> is unique if and only if
    <math|<big|cap><rsub|j=0><rsup|\<infty\>>B<rsup|j><Z><rsup|d>=<around|{|0|}>>.

    <item*|(d)>Consider the matrix <math|A=<around*|(|<matrix*|<tformat|<table|<row|<cell|2>|<cell|0>>|<row|<cell|0>|<cell|1>>>>>|)>>,
    for which <math|<big|cap><rsub|j=0><rsup|\<infty\>>B<rsup|j><Z><rsup|2>=<around|{|0|}>\<times\><Z>>.
    Then item (b) applies to any measure of the form
    <math|\<nu\>\<times\>\<delta\><rsub|1>>. Thus when <math|A> is not a
    dilation matrix, we expect there to be many
    KMS<rsub|<math|\<beta\><rsub|c>>> states besides the one in
    Theorem<nbsp><reference|betalogN>.

    <item*|(e)>We wonder whether every KMS<rsub|<math|\<beta\><rsub|c>>>
    state is a limit of KMS<rsub|<math|\<beta\>>> states. It is trivially the
    case in our examples when <math|<around|\||det A|\|>\<gtr\>1>, and in
    these examples it also works for <math|\<beta\><rsub|c>=0>.

    <item*|(f)>When <math|\<beta\><rsub|c>=0>, we have to be careful to
    distinguish between traces (the KMS<rsub|<math|0>> states in
    <cite|bra-rob>) and the invariant traces (the KMS<rsub|<math|0>> states
    in <cite|ped>). Certainly any limit of KMS<rsub|<math|\<beta\>>> states
    will be invariant, so the answer to the previous question is trivially
    false with the definition in <cite|bra-rob> if the algebra has traces
    which are not invariant. We give an example where this happens in
    Remark<nbsp><reference|tracesonHgp>.
  </itemize>

  <\remark>
    <label|cantuseDCT>The obvious way to try to compute the limit of
    <eqref|formrewritten> as <math|r\<to\>1-> is to evaluate it term-by-term.
    This amounts to pulling <math|lim<rsub|r\<to\>1->> through the infinite
    sum, and therefore requires the dominated convergence theorem. Write
    <math|m<rsub|j>\<assign\>M<rsub|\<mu\>>*<around|(|B<rsup|-<around|(|j+k|)>>*<around|(|m-n|)>|)>>.
    To apply the dominated convergence theorem, we need a convergent series
    <math|<big|sum><rsub|j>a<rsub|j>> such that
    <math|0\<leq\><around|(|1-r|)>*r<rsup|j><around|\||m<rsub|j>|\|>\<leq\>a<rsub|j>>
    (and we need to consider a sequence <math|<around|{|r<rsub|n>|}>>). We
    know <math|<around|\||m<rsub|j>|\|>\<leq\>1>. Calculus shows that
    <math|max<around|{|<around|(|1-t|)>*t<rsup|j>:t\<in\><around|[|0,1|]>|}>>
    occurs at <math|j/<around|(|j+1|)>>. So the best general estimate seems
    to be

    <\equation*>
      <around|(|1-r|)>*r<rsup|j><around|\||m<rsub|j>|\|>\<leq\><around*|(|1-<frac|j|j+1>|)><around*|(|<frac|j|j+1>|)><rsup|j>=<frac|j<rsup|j>|<around|(|j+1|)><rsup|j+1>>.
    </equation*>

    Taking <math|a<rsub|j>> to be the right-hand side and
    <math|b<rsub|j>\<assign\>1/<around|(|j+1|)>>, we have

    <\equation*>
      <frac|b<rsub|j>|a<rsub|j>>=<around*|(|<frac|j+1|j>|)><rsup|j>=<around*|(|1+<frac|1|j>|)><rsup|j>\<to\>e<text|as
      <math|j\<to\>\<infty\>>,>
    </equation*>

    and the limit form of the comparison test implies that
    <math|<big|sum>a<rsub|j>> diverges.

    So pulling the limit through the sum seems to be a nontrivial matter. Of
    course, it is really just as well we can't do this, since we know that
    <math|<big|sum><rsub|j=0><rsup|\<infty\>><around|(|1-r|)>*r<rsup|j>=1\<to\>1>
    as <math|r\<to\>1->, whereas the term-by-term calculation would give
    <math|0>.
  </remark>

  <section|KMS<rsub|<math|\<infty\>>> and ground states><label|sec-ground>

  <\prop>
    <label|betainfty>Suppose that <math|A\<in\>M<rsub|d><around|(|<Z>|)>> has
    nonzero determinant. Then for every probability measure <math|\<mu\>> on
    <math|<T><rsup|d>>, there is a KMS<rsub|<math|\<infty\>>> state
    <math|\<psi\><rsub|\<infty\>,\<mu\>>> on
    <math|<around|(|<TT><around|(|M<rsub|L>|)>,\<sigma\>|)>> such that

    <\equation*>
      \<psi\><rsub|\<infty\>,\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>=<choice|<tformat|<table|<row|<cell|<big|int><rsub|<T><rsup|d>>z<rsup|m-n>*<space|0.17em>d*\<mu\><around|(|z|)>>|<cell|<text|if
      >k=l=0>>|<row|<cell|0>|<cell|<text|otherwise.>>>>>>
    </equation*>

    Every ground state of <math|<around|(|<TT><around|(|M<rsub|L>|)>,\<sigma\>|)>>
    has the form <math|\<psi\><rsub|\<infty\>,\<mu\>>>, and is in particular
    a KMS<rsub|<math|\<infty\>>> state.
  </prop>

  The proof of <cite-detail|lr|Lemma<nbsp>8.4> gives the following
  characterisation of ground states.

  <\lemma>
    <label|charground>A state <math|\<phi\>> of
    <math|<TT><around|(|M<rsub|L>|)>> is a ground state for <math|\<sigma\>>
    if and only if

    <\equation*>
      \<phi\><rsub|\<infty\>,\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>=<choice|<tformat|<table|<row|<cell|\<phi\><around|(|u<rsub|m-n>|)>>|<cell|<text|if
      >k=l=0>>|<row|<cell|0>|<cell|<text|otherwise.>>>>>>
    </equation*>
  </lemma>

  <\proof>
    <dueto|Proof of Proposition<nbsp><reference|betainfty>>Choose a sequence
    <math|<around|{|\<beta\><rsub|i>|}>> such that
    <math|\<beta\><rsub|i>\<to\>\<infty\>>; by passing to a subsequence, we
    may suppose that <math|\<psi\><rsub|\<beta\><rsub|i>,\<mu\>>> converges
    in the weak* topology to a state <math|\<psi\><rsub|\<infty\>,\<mu\>>>,
    which is by definition a KMS<rsub|<math|\<infty\>>> state. Next we verify
    the formula for <math|\<psi\><rsub|\<infty\>,\<mu\>>>. As
    <math|\<beta\>\<to\>\<infty\>>, each summand in the right-hand side of
    <eqref|formpsibetamu> with <math|j\<gtr\>0> goes to zero. Thus as
    <math|i\<to\>\<infty\>>, we have

    <\equation*>
      \<psi\><rsub|\<beta\><rsub|i>,\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>\<to\><choice|<tformat|<table|<row|<cell|<big|int><rsub|<T><rsup|d>>z<rsup|m-n>*<space|0.17em>d*\<mu\><around|(|z|)>>|<cell|<text|if
      >k=l=0>>|<row|<cell|0>|<cell|<text|otherwise,>>>>>>
    </equation*>

    and hence <math|\<phi\><rsub|\<infty\>,\<mu\>>> has the required form.
    (If <math|A> is not a dilation matrix, so that
    <math|<big|cap><rsub|k=1><rsup|\<infty\>>B<rsup|k><Z><rsup|d>> could
    contain nonzero elements, then the sum on the right-hand side of
    <eqref|formpsibetamu> could have infinitely many nonzero terms, and
    calculating the limit as <math|i\<to\>\<infty\>> would require some
    analysis of the sort discussed in Remark<nbsp><reference|cantuseDCT>.)

    If <math|\<phi\>> is a ground state, then the restriction of
    <math|\<phi\>> to the range of <math|i<rsub|C<around|(|<T><rsup|d>|)>>>
    is given by a probability measure <math|\<mu\>>, and then
    Lemma<nbsp><reference|charground> implies that
    <math|\<phi\>=\<psi\><rsub|\<infty\>,\<mu\>>>.
  </proof>

  <section|The Toeplitz algebra of the Baumslag-Solitar
  semigroup><label|BSsemigp>

  We fix an integer <math|N> with <math|N\<gtr\>1>, and consider the additive
  group <math|<Z><around|[|N<rsup|-1>|]>> of rational numbers of the form
  <math|m*N<rsup|-l>> for <math|m,l\<in\><Z>>. The <em|Baumslag-Solitar
  group> is the semidirect product <math|<Z><around|[|N<rsup|-1>|]>\<rtimes\><Z>>
  with

  <\equation*>
    <around|(|r,k|)><around|(|s,l|)>=<around|(|r+N<rsup|k>*s,k+l|)>.
  </equation*>

  The semigroup semidirect product <math|<N>\<rtimes\><rsub|N><N>> is a
  subsemigroup of <math|<Z><around|[|N<rsup|-1>|]>\<rtimes\><Z>>, and the
  pair <math|<around|(|<Z><around|[|N<rsup|-1>|]>\<rtimes\><Z>,<N>\<rtimes\><rsub|N><N>|)>>
  is closely related to the pair <math|<around|(|<qxqx>,<nxnx>|)>> studied in
  <cite|lr>. Indeed, the map <math|<around|(|r,k|)>\<mapsto\><around|(|r,N<rsup|k>|)>>
  of <math|<Z><around|[|N<rsup|-1>|]>\<rtimes\><N>> into <math|<qxqx>>
  carries <math|<N>\<rtimes\><rsub|N><N>> into <math|<nxnx>>. The pair
  <math|<around|(|<Z><around|[|N<rsup|-1>|]>\<rtimes\><Z>,<N>\<rtimes\><rsub|N><N>|)>>
  is also quasi-lattice ordered in the sense of Nica <cite|n>. (One way to
  see this is via the embedding of <math|<Z><around|[|N<rsup|-1>|]>\<rtimes\><N>>
  in <math|<qxqx>>: we just need to check that if
  <math|<around|(|r,k|)>\<in\><Z><around|[|N<rsup|-1>|]>\<rtimes\><N>> and
  <math|<around|(|r,N<rsup|k>|)>> has an upper bound in
  <math|<N>\<rtimes\>N<rsup|<N>>>, then the least upper bound constructed in
  <cite-detail|lr|Proposition<nbsp>2.2> lies in
  <math|<N>\<rtimes\>N<rsup|<N>>>.) So <math|<around|(|<Z><around|[|N<rsup|-1>|]>\<rtimes\><Z>,<N>\<rtimes\><rsub|N><N>|)>>
  also has a Toeplitz algebra <math|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>>
  which is universal for Nica covariant representations of
  <math|<N>\<rtimes\><rsub|N><N>> <cite|n|lr1>. The Toeplitz algebra
  <math|<TT><around|(|C<around|(|<T>|)>,\<alpha\><rsub|N>,L,<N>|)>> is a
  quotient of <math|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>> analogous to
  the additive boundary quotient of <math|<TT><around|(|<nxnx>|)>> studied in
  <cite|BaHLR>. We now discuss the KMS states on
  <math|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>>, following the analysis of
  <cite-detail|BaHLR|4>.

  The Toeplitz algebra <math|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>> is
  generated by two isometries <math|s=T<rsub|<around|(|1,0|)>>> and
  <math|v=T<rsub|<around|(|0,1|)>>>, and an argument like that of
  <cite-detail|lr|4> shows that <math|<around|(|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>,s,v|)>>
  is universal among <math|C<rsup|\<ast\>>>-algebras generated by a pair of
  isometries <math|S> and <math|V> satisfying

  <\itemize>
    <item*|(T1)><math|V*S=S<rsup|N>*V>, <vspace|0.5fn>

    <item*|(T4)><math|S<rsup|\<ast\>>*V=S<rsup|N-1>*V*S<rsup|\<ast\>>>, and
    <vspace|0.5fn>

    <item*|(T5)><math|V<rsup|\<ast\>>*S<rsup|k>*V=0> for
    <math|1\<leq\>k\<less\>N>.
  </itemize>

  We define <math|<TT><rsub|<add>><around|(|<N>\<rtimes\><rsub|N><N>|)>> to
  be the quotient of <math|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>> by the
  extra relation <math|s*s<rsup|\<ast\>>=1>,
  <math|<TT><rsub|<mult>><around|(|<N>\<rtimes\><rsub|N><N>|)>> to be the
  quotient by the relation <math|1=<big|sum><rsub|k=0><rsup|N-1>s<rsup|k>*v*v<rsup|\<ast\>>*s<rsup|\<ast\>k>>,
  and <math|<TT><rsub|<add>,<space|0.27em><mult>><around|(|<N>\<rtimes\><rsub|N><N>|)>>
  to be the quotient in which both extra relations hold, and which is
  therefore the analogue of Cuntz's <math|<qn>>. Thus we have the following
  commutative diagram of quotient maps:

  <\equation>
    <label|commdiagBS>

    <\latex_preview|xymatrix>
      <\text>
        \\xymatrix{

        &\\TT(\\N\\rtimes_N \\N)\\ar[dl]_{q_{\\add}}\\ar[dr]^{q_{\\mult}}&\\\\

        \\TT_{\\add}(\\N\\rtimes_N \\N)\\ar[dr]&&\\TT_{\\mult}(\\N\\rtimes_N
        \\N)\\ar[dl]\\\\

        &\\TT_{\\add,\\;\\mult}(\\N\\rtimes_N \\N).&

        }
      </text>
    </latex_preview>
  </equation>

  In <math|<TT><rsub|<add>><around|(|<N>\<rtimes\><rsub|N><N>|)>> the
  generator <math|s> becomes unitary, and (T4) is redundant. The unitary
  <math|s> generates a unitary representation
  <math|u:<Z>\<to\>U<around|(|<TT><rsub|<add>><around|(|<N>\<rtimes\><rsub|N><N>|)>|)>>,
  and the relations (T1) and (T5) (taken together) are equivalent to (E1) and
  (E2) (taken together). Thus Proposition<nbsp><reference|presadd> implies
  that <math|<TT><rsub|<add>><around|(|<N>\<rtimes\><rsub|N><N>|)>> is our
  Toeplitz algebra <math|<TT><around|(|M<rsub|L>|)>>.
  Proposition<nbsp><reference|CPquotient> implies that
  <math|<TT><rsub|<add>,<space|0.27em><mult>><around|(|<N>\<rtimes\><rsub|N><N>|)>>
  is the quotient <math|<OO><around|(|M<rsub|L>|)>> of
  <math|<TT><around|(|M<rsub|L>|)>>. (When <math|N=2>,
  <math|<OO><around|(|M<rsub|L>|)>> has been studied by Larsen and Li under
  the name <math|\<cal-Q\><rsub|2>>; see <cite-detail|LL|3>.)

  Since the presentation of <math|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>>
  is not affected by multiplying <math|v> by <math|z\<in\><T>>, we can deduce
  from the presentation that there is an action
  <math|\<gamma\>:<T>\<to\><Aut><TT><around|(|<N>\<rtimes\><rsub|N><N>|)>>
  such that <math|\<gamma\><rsub|z><around|(|s|)>=s> and
  <math|\<gamma\><rsub|z><around|(|v|)>=z*v>. Inflating this action to
  <math|<R>> gives a dynamics <math|\<sigma\>:<R>\<to\><Aut><TT><around|(|<N>\<rtimes\><rsub|N><N>|)>>
  such that <math|\<sigma\><rsub|t><around|(|s|)>=s> and
  <math|\<sigma\><rsub|t><around|(|v|)>=e<rsup|i*t>*v>. This action leaves
  the kernels of the quotient maps in the diagram <eqref|commdiagBS>
  invariant, and hence induces actions (still denoted by <math|\<sigma\>>) on
  all three quotients. On <math|<TT><rsub|<add>><around|(|<N>\<rtimes\><rsub|N><N>|)>>
  and <math|<TT><rsub|<add>,<space|0.27em><mult>><around|(|<N>\<rtimes\><rsub|N><N>|)>>
  we recover the actions on <math|<TT><around|(|M<rsub|L>|)>> and
  <math|<OO><around|(|M<rsub|L>|)>> that we have been studying, in the case
  where <math|A> is the <math|1\<times\>1> matrix <math|<around|(|N|)>> and
  <math|\<sigma\><rsub|A>> is the covering map <math|z\<mapsto\>z<rsup|N>> of
  <math|<T>>. So our results tell us about the KMS states of
  <math|<around|(|<TT><rsub|<add>><around|(|<N>\<rtimes\><rsub|N><N>|)>,\<sigma\>|)>>
  and <math|<around|(|<TT><rsub|<add>,<space|0.27em><mult>><around|(|<N>\<rtimes\><rsub|N><N>|)>,\<sigma\>|)>>.

  Just as in <cite-detail|lr|Lemma<nbsp>10.4>, every
  KMS<rsub|<math|\<beta\>>> state of <math|<around|(|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>,\<sigma\>|)>>
  vanishes on the ideal generated by <math|1-s*s<rsup|\<ast\>>>, and hence
  comes from a KMS<rsub|<math|\<beta\>>> state of
  <math|<TT><around|(|M<rsub|L>|)>>. So we know all the KMS states of
  <math|<around|(|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>,\<sigma\>|)>>.
  For ground states, though, there is a difference. As in
  <cite-detail|lr|Lemma<nbsp>8.4> (or Lemma<nbsp><reference|charground>
  above), a ground state of <math|<around|(|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>,\<sigma\>|)>>
  is determined by its values on <math|C<rsup|\<ast\>><around|(|s|)>>, and we
  claim that the map <math|\<phi\>\<mapsto\>\<phi\>\|<rsub|C<rsup|\<ast\>><around|(|s|)>>>
  is an affine homeomorphism of the set of ground states onto the state space
  of <math|C<rsup|\<ast\>><around|(|s|)>\<cong\><TT><around|(|<N>|)>>.
  Indeed, we can deduce this from <cite-detail|lr|Theorem<nbsp>7.1(4)>, since
  Theorem<nbsp>3.7 of <cite|lr1> implies that
  <math|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>> embeds as the subalgebra
  <math|C<rsup|\<ast\>><around|(|s,v<rsub|N>|)>> of
  <math|<TT><around|(|<nxnx>|)>>, and the homeomorphism
  <math|\<phi\>\<mapsto\>\<phi\>\|<rsub|C<rsup|\<ast\>><around|(|s|)>>>
  factors through <math|C<rsup|\<ast\>><around|(|s,v<rsub|N>|)>>.

  We can sum up these results by saying that the system
  <math|<around|(|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>,\<sigma\>|)>> has
  a phase transition at inverse temperature <math|\<beta\>=log N>, and a
  further phase transition (in the sense of Connes and Marcolli) at
  <math|\<beta\>=\<infty\>>. We believe that this is the simplest known
  system which exhibits both these phenomena. As for the system in <cite|lr>,
  the circular symmetry at <math|\<beta\>=log N> which disappears for
  <math|\<beta\>\<gtr\>log N> is not apparently realised by an action of
  <math|<T>> on <math|<TT><around|(|<N>\<rtimes\><rsub|N><N>|)>>. In
  <cite|lr>, though, this circular symmetry persists for
  <math|\<beta\>\<in\><around|[|1,2|]>>, as a result of the more complicated
  convergence issues for the series representations of the normalising
  factors.

  <\remark>
    Since we can view <math|<N>\<rtimes\><rsub|N><N>> as a subsemigroup of
    <math|<nxnx>>, it might be more natural to use the dynamics satisfying
    <math|\<sigma\><rsub|t><around|(|v|)>=N<rsup|i*t>*v>. If we do this, then
    the phase transition will occur at <math|\<beta\>=1>.
  </remark>

  <section|Integer matrices with determinant
  <math|\<pm\>1>><label|sec-gpalgs>

  When <math|A\<in\>M<rsub|d><around|(|<Z>|)>> has <math|<around|\||det
  A|\|>=1>, the inverse <math|A<rsup|-1>> has integer entries (as the
  cofactor formula shows), the map <math|\<sigma\><rsub|A>> is a
  homeomorphism, and <math|\<alpha\><rsub|A>> is an automorphism. The inverse
  <math|\<alpha\><rsub|A><rsup|-1>> is then a transfer operator for
  <math|\<alpha\><rsub|A>>, so we have an Exel system
  <math|<around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,\<alpha\><rsub|A><rsup|-1>|)>>,
  and this system has a Toeplitz algebra and an Exel crossed product. One
  would guess that these <math|C<rsup|\<ast\>>>-algebras must be related to
  the ordinary crossed product, and they are, but we have not seen this
  explicitly pointed out before.

  <\prop>
    Suppose that <math|\<alpha\>> is an automorphism of a unital
    <math|C<rsup|\<ast\>>>-algebra <math|C>. Then

    <vspace|0.5fn><text|(a)> Exel's Toeplitz algebra
    <math|<TT><around|(|C,\<alpha\>,\<alpha\><rsup|-1>|)>> is the universal
    <math|C<rsup|\<ast\>>>-algebra generated by an isometry <math|v> and a
    unital representation <math|i<rsub|C>> of <math|C> satisfying
    <math|v*i<rsub|C><around|(|c|)>=i<rsub|C><around|(|\<alpha\><around|(|c|)>|)>*v>,
    and

    <vspace|0.5fn><text|(b)> the Exel crossed product
    <math|C\<rtimes\><rsub|\<alpha\>,\<alpha\><rsup|-1>><N>> is the universal
    <math|C<rsup|\<ast\>>>-algebra generated by a unitary <math|u> and a
    unital representation <math|j<rsub|C>> of <math|C> satisfying
    <math|j<rsub|C><around|(|\<alpha\><around|(|c|)>|)>=u*j<rsub|C><around|(|c|)>*u<rsup|\<ast\>>>.
  </prop>

  <\proof>
    We know from <cite-detail|br|3> that
    <math|<TT><around|(|C,\<alpha\>,\<alpha\><rsup|-1>|)>> is universal for
    Toeplitz-covariant representations <math|<around|(|\<rho\>,V|)>>
    satisfying two relations called (TC1) and (TC2) (see
    page<nbsp><pageref|TCrels>). As we observed earlier, plugging the
    identity <math|1> of <math|C> into (TC2) shows that <math|V> is an
    isometry. For our system <math|<around|(|C,\<alpha\>,\<alpha\><rsup|-1>|)>>,
    (TC1) implies (TC2):

    <\equation*>
      V<rsup|\<ast\>>*\<rho\><around|(|c|)>*V=V<rsup|\<ast\>>*\<rho\><around|(|\<alpha\><around|(|\<alpha\><rsup|-1><around|(|c|)>|)>|)>*V=V<rsup|\<ast\>>*V*\<rho\><around|(|\<alpha\><rsup|-1><around|(|c|)>|)>=\<rho\><around|(|\<alpha\><rsup|-1><around|(|c|)>|)>,
    </equation*>

    and (a) follows.

    To establish (b), notice first that <math|\<phi\><around|(|c|)>\<in\><LL><around|(|M<rsub|\<alpha\><rsup|-1>>|)>>
    is the rank-one operator <math|\<Theta\><rsub|c,1>>. The Cuntz-Pimsner
    algebra is generated by a universal Cuntz-Pimsner covariant
    representation <math|<around|(|j<rsub|M<rsub|\<alpha\><rsup|-1>>>,j<rsub|C>|)>>,
    and then the isometry <math|v> in part (a) is
    <math|v=j<rsub|M<rsub|\<alpha\><rsup|-1>>><around|(|1|)>>. Cuntz-Pimsner
    covariance says that

    <\equation*>
      j<rsub|C><around|(|c|)>=<around|(|j<rsub|M<rsub|\<alpha\><rsup|-1>>>,j<rsub|C>|)><rsup|<around|(|1|)>><around|(|\<phi\><around|(|c|)>|)>=<around|(|j<rsub|M<rsub|\<alpha\><rsup|-1>>>,j<rsub|C>|)><rsup|<around|(|1|)>><around|(|\<Theta\><rsub|c,1>|)>=j<rsub|M<rsub|\<alpha\><rsup|-1>>><around|(|c|)>*j<rsub|M<rsub|\<alpha\><rsup|-1>>><around|(|1|)><rsup|\<ast\>>;
    </equation*>

    since <math|c=c\<cdot\>1>, we have <math|j<rsub|M<rsub|\<alpha\><rsup|-1>>><around|(|c|)>=j<rsub|C><around|(|c|)>*j<rsub|M<rsub|\<alpha\><rsup|-1>>><around|(|1|)>>,,
    and Cuntz-Pimsner covariance is equivalent to
    <math|j<rsub|C><around|(|c|)>=j<rsub|C><around|(|c|)>*v*v<rsup|\<ast\>>>.
    This is equivalent to <math|v*v<rsup|\<ast\>>=1>, so <math|v> is unitary,
    and now <math|v*j<rsub|C><around|(|c|)>=j<rsub|C><around|(|\<alpha\><around|(|c|)>|)>*v>
    is equivalent to <math|j<rsub|C><around|(|\<alpha\><around|(|c|)>|)>=v*j<rsub|C><around|(|c|)>*v<rsup|\<ast\>>>.
  </proof>

  These universal properties immediately imply that our algebras are familiar
  objects:

  <\cor>
    <label|ordcp>Suppose that <math|\<alpha\>> is an automorphism of a unital
    <math|C<rsup|\<ast\>>>-algebra <math|C>. Then the Exel crossed product
    <math|C\<rtimes\><rsub|\<alpha\>,\<alpha\><rsup|-1>><N>> is the usual
    crossed product <math|C\<rtimes\><rsub|\<alpha\>><Z>>, and the Toeplitz
    algebra <math|<TT><around|(|C,\<alpha\>,\<alpha\><rsup|-1>|)>> is the
    crossed product <math|C\<times\><rsub|\<alpha\>><N>> introduced and
    studied by Murphy <cite|m>. In both cases, the gauge action of <math|<T>>
    is the dual action of <math|<T>=<wide|<Z>|^>>.
  </cor>

  <\remark>
    Although <math|M<rsub|\<alpha\><rsup|-1>>> is not the bimodule <math|E>
    considered by Pimsner in <cite-detail|p|Example<nbsp>(3), page<nbsp>193>,
    the two are isomorphic; indeed, <math|a\<mapsto\>\<alpha\><around|(|a|)>>
    is a Hilbert-bimodule isomorphism of <math|E> onto
    <math|M<rsub|\<alpha\><rsup|-1>>>. So the identity
    <math|C\<rtimes\><rsub|\<alpha\>,\<alpha\><rsup|-1>><N>=C\<rtimes\><rsub|\<alpha\>><Z>>
    also follows from the assertion in <cite-detail|p|Example<nbsp>(3)>.
  </remark>

  We now return to the case of an integer matrix <math|A> with
  <math|<around|\||det A|\|>=1>, where Corollary<nbsp><reference|ordcp>
  identifies the Toeplitz algebra <math|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,\<alpha\><rsub|A><rsup|-1>|)>>
  as a Murphy crossed product, and the Exel crossed product
  <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>,\<alpha\><rsub|A><rsup|-1>><N>>
  with the ordinary crossed product <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>><Z>>.
  We will be working primarily with the crossed product, so it is worth
  observing that the generator <math|<wide|v|\<bar\>>> is now unitary, and
  hence we can simplify our presentation: we view
  <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\>><Z>> as being
  generated by a unitary representation <math|<wide|u|\<bar\>>> of
  <math|<Z><rsup|d>> and a unitary <math|<wide|v|\<bar\>>> satisfying
  <math|<wide|v|\<bar\>>*<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|\<ast\>>=<wide|u|\<bar\>><rsub|B*m>>,
  and then

  <\equation*>
    C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>><Z>=<clsp><around|{|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>:m\<in\><Z><rsup|d>,k\<in\><Z>|}>.
  </equation*>

  We can if we wish make the further identification of the crossed product
  <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>><Z>> with
  the group algebra <math|C<rsup|\<ast\>>*<around|(|<Z><rsup|d>\<rtimes\><rsub|B><Z>|)>>
  of the semidirect product (using Proposition 3.11 of <cite|tfb^2>, for
  example).

  As before, lifting the dual actions of <math|<T>> gives actions
  <math|\<sigma\>> of <math|<R>> on <math|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,\<alpha\><rsub|A><rsup|-1>|)>>
  and <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>><Z>>
  such that <math|\<sigma\><rsub|t>> fixes the copies of
  <math|C<around|(|<T><rsup|d>|)>> and multiplies the additive generators by
  <math|e<rsup|i*t>>. Proposition<nbsp><reference|existforbeta\<gtr\>1>
  describes the KMS<rsub|<math|\<beta\>>> states of
  <math|<around|(|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,\<alpha\><rsub|A><rsup|-1>|)>,\<sigma\>|)>>
  for <math|\<beta\>\<gtr\>log <around|\||det A|\|>=0>. Since
  <math|<around|\||det B|\|>=1>, <math|B> is invertible over the integers,
  <math|B<rsup|j><Z><rsup|d>=<Z><rsup|d>> for all <math|j>, and the series in
  <eqref|formpsibetamu> is infinite for every pair <math|m>, <math|n>. Thus
  for each <math|\<mu\>\<in\>P<around|(|<T><rsup|d>|)>> there is a
  KMS<rsub|<math|\<beta\>>> state <math|\<psi\><rsub|\<beta\>,\<mu\>>> on
  <math|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,\<alpha\><rsub|A><rsup|-1>|)>>
  such that

  <\equation>
    <label|psibeta>\<psi\><rsub|\<beta\>,\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
    >k=l>>|<row|<cell|<big|sum><rsub|j=k><rsup|\<infty\>><around|(|1-e<rsup|-\<beta\>>|)>*e<rsup|-j*\<beta\>>*M<rsub|\<mu\>>*<around|(|B<rsup|-j>*<around|(|m-n|)>|)>>|<cell|<text|if
    <math|k=l>.>>>>>>
  </equation>

  Indeed, the proof of Proposition<nbsp><reference|existforbeta\<gtr\>1>
  simplifies substantially in this case: with
  <math|U=<big|oplus><rsub|j=0><rsup|\<infty\>>M\<circ\>B<rsup|-j>> acting on
  <math|<big|oplus><rsub|j=0><rsup|\<infty\>>L<rsup|2>*<around|(|<T><rsup|d>,d*\<mu\>|)>>,
  <math|V> the unilateral shift on the same direct sum, and <math|e<rsub|j>>
  the constant function <math|1> in the <math|j>th summand and <math|0>
  elsewhere, we have

  <\equation*>
    \<psi\><rsub|\<beta\>,\<mu\>><around|(|T|)>=<big|sum><rsub|j=0><rsup|\<infty\>><around|(|1-e<rsup|-\<beta\>>|)>*e<rsup|-j*\<beta\>>*<around|(|\<pi\><rsub|U,V><around|(|T|)>*e<rsub|j><space|0.17em>\|<space|0.17em>e<rsub|j>|)>.
  </equation*>

  Proposition<nbsp><reference|existforbeta\<gtr\>1> also shows that all the
  KMS<rsub|<math|0>> states (that is, the invariant traces) on
  <math|<TT><around|(|C<around|(|<T><rsup|d>|)>,\<alpha\><rsub|A>,\<alpha\><rsub|A><rsup|-1>|)>>
  factor through traces of <math|C<rsup|\<ast\>><around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>><Z>>.
  Since the uniqueness assertion in Theorem<nbsp><reference|betalogN> does
  not apply, we might expect to find more than one.

  <\prop>
    <label|invtr>Suppose that <math|A\<in\>M<rsub|d><around|(|<Z>|)>> has
    <math|<around|\||det A|\|>=1>. If <math|\<mu\>\<in\>P<around|(|<T><rsup|d>|)>>
    satisfies <math|\<sigma\><rsub|A><rsup|\<ast\>>*\<mu\>=\<mu\>>, then
    there is a <math|\<sigma\>>-invariant trace <math|\<psi\><rsub|\<mu\>>>
    on <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>><Z>>
    such that

    <\equation>
      <label|proppsimu>\<psi\><rsub|\<mu\>>*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      >k=0>>|<row|<cell|M<rsub|m><around|(|\<mu\>|)>>|<cell|<text|if
      <math|k=0>,>>>>>>
    </equation>

    and every <math|\<sigma\>>-invariant trace on
    <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>><Z>> has
    this form.
  </prop>

  Since the action <math|\<sigma\>> of <math|<R>> is inflated from the dual
  action <math|<wide|\<alpha\>|^><rsub|A>> of <math|<T>>, a state is
  invariant for <math|\<sigma\>> if and only if it is invariant for
  <math|<wide|\<alpha\>|^><rsub|A>>. So the following standard lemma is
  useful.

  <\lemma>
    <label|invstate>Suppose that <math|\<gamma\>:<T>\<to\><Aut>D> is a
    strongly continuous action on a unital <math|C<rsup|\<ast\>>>-algebra
    <math|D> and <math|E<rsup|\<gamma\>>:d\<mapsto\><big|int><rsub|<T>>\<gamma\><rsub|z><around|(|d|)>*<space|0.17em>d*z>
    is the expectation onto the fixed-point algebra <math|D<rsup|\<gamma\>>>.
    Then a state <math|\<phi\>> of <math|D> is <math|\<gamma\>>-invariant if
    and only if there is a state <math|\<tau\>> of <math|D<rsup|\<gamma\>>>
    such that <math|\<phi\>=\<tau\>\<circ\>E<rsup|\<gamma\>>>.
  </lemma>

  <\proof>
    Suppose <math|\<phi\>=\<tau\>\<circ\>E<rsup|\<gamma\>>>. Then the
    invariance of Haar measure implies that
    <math|E<rsup|\<gamma\>>\<circ\>\<gamma\><rsub|z>=E<rsup|\<gamma\>>>, and
    hence <math|\<phi\>\<circ\>\<gamma\><rsub|z>=\<tau\>\<circ\>E<rsup|\<gamma\>>\<circ\>\<gamma\><rsub|z>=\<tau\>\<circ\>E<rsup|\<gamma\>>=\<phi\>>,
    so <math|\<phi\>> is invariant. Conversely, if <math|\<phi\>> is
    invariant, then

    <\equation*>
      \<phi\><around|(|d|)>=<big|int><rsub|<T>>\<phi\><around|(|d|)>*<space|0.17em>d*z=<big|int><rsub|<T>>\<phi\><around|(|\<gamma\><rsub|z><around|(|d|)>|)>*<space|0.17em>d*z=\<phi\><around*|(|<big|int><rsub|<T>>\<gamma\><rsub|z><around|(|d|)>*<space|0.17em>d*z|)>=\<phi\>\<circ\>E<rsup|\<gamma\>><around|(|d|)>,
    </equation*>

    so <math|\<phi\>=\<phi\>\|<rsub|D<rsup|\<gamma\>>>\<circ\>E<rsup|\<gamma\>>>;
    since <math|1\<in\>D<rsup|\<gamma\>>>,
    <math|\<phi\>\|<rsub|D<rsup|\<gamma\>>>> is a state.
  </proof>

  <\proof>
    <dueto|Proof of Proposition<nbsp><reference|invtr>>With
    <math|\<gamma\>=<wide|\<alpha\>|^><rsub|A>>, the expectation
    <math|E<rsup|\<gamma\>>> is given by

    <\equation*>
      E<rsup|\<gamma\>>*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      >k=0>>|<row|<cell|<wide|u|\<bar\>><rsub|m>>|<cell|<text|if
      <math|k=0>.>>>>>>
    </equation*>

    It follows easily that if <math|\<theta\><rsub|\<mu\>>> is the state on
    <math|C<around|(|<T><rsup|d>|)>=<clsp><around|{|<wide|u|\<bar\>><rsub|m>:m\<in\><Z><rsup|d>|}>>
    given by integration against <math|\<mu\>\<in\>P<around|(|<T><rsup|d>|)>>,
    then <math|\<psi\><rsub|\<mu\>>\<assign\>\<theta\><rsub|\<mu\>>\<circ\>E<rsup|\<gamma\>>>
    satisfies <eqref|proppsimu>. Lemma<nbsp><reference|invstate> implies that
    every invariant state of <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>><Z>>
    has this form. So we need to show that <math|\<psi\><rsub|\<mu\>>> is a
    trace if and only if <math|\<mu\>> is invariant under
    <math|\<sigma\><rsub|A><rsup|\<ast\>>>.

    We compute

    <\equation*>
      \<psi\><rsub|\<mu\>>*<around|(|<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>|)>*<around|(|<wide|u|\<bar\>><rsub|n>*<wide|v|\<bar\>><rsup|l>|)>|)>=<choice|<tformat|<table|<row|<cell|\<psi\><rsub|\<mu\>><around|(|<wide|u|\<bar\>><rsub|m+B<rsup|k>*n>|)>>|<cell|<text|if
      >k+l=0>>|<row|<cell|0>|<cell|<text|otherwise,>>>>>>
    </equation*>

    and similarly the other way round. Thus <math|\<psi\><rsub|\<mu\>>> is a
    trace if and only if

    <\equation*>
      \<psi\><rsub|\<mu\>><around|(|<wide|u|\<bar\>><rsub|m+B<rsup|-l>*n>|)>=\<psi\><rsub|\<mu\>><around|(|<wide|u|\<bar\>><rsub|n+B<rsup|l>*m>|)>=\<psi\><rsub|\<mu\>><around|(|<wide|u|\<bar\>><rsub|B<rsup|l>*<around|(|B<rsup|-l>*n+m|)>>|)><text|for
      all <math|l\<in\><Z>>, <math|m,n\<in\><Z><rsup|d>>;>
    </equation*>

    or, equivalently, if and only if <math|\<psi\><rsub|\<mu\>><around|(|<wide|u|\<bar\>><rsub|m>|)>=\<psi\><rsub|\<mu\>><around|(|<wide|u|\<bar\>><rsub|B*m>|)>>
    for all <math|m\<in\><Z><rsup|d>>. But these are just the moments of
    <math|\<mu\>>, and a calculation shows that
    <math|M<rsub|B*m><around|(|\<mu\>|)>=M<rsub|m>*<around|(|\<sigma\><rsub|A><rsup|\<ast\>>*\<mu\>|)>>.
    So we deduce that <math|\<psi\><rsub|\<mu\>>> is a trace if and only if
    <math|\<mu\>> is invariant, as required.
  </proof>

  <\remark>
    When <math|\<mu\>> is invariant under <math|\<sigma\><rsub|A>>, the
    moments <math|M<rsub|\<mu\>>*<around|(|B<rsup|-j>*<around|(|m-n|)>|)>>
    appearing in <eqref|psibeta> are all equal to
    <math|M<rsub|\<mu\>>*<around|(|m-n|)>>. Thus the series on the right-hand
    side of <eqref|psibeta> is geometric, and summing it shows that

    <\equation*>
      \<psi\><rsub|\<beta\>,\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      >k=l>>|<row|<cell|e<rsup|-k*\<beta\>>*M<rsub|\<mu\>>*<around|(|m-n|)>>|<cell|<text|if
      <math|k=l>,>>>>>>
    </equation*>

    which converges to <math|\<psi\><rsub|\<mu\>>*<around|(|Q*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>l>*u<rsub|n><rsup|\<ast\>>|)>|)>=\<psi\><rsub|\<mu\>>*<around|(|<wide|u|\<bar\>><rsub|m+B<rsup|k-l>*n>*<wide|v|\<bar\>><rsup|k-l>|)>>
    as <math|\<beta\>\<to\>0>. In view of
    Proposition<nbsp><reference|limitKMS>, this gives an alternative proof
    that <math|\<psi\><rsub|\<mu\>>> is an invariant trace.
  </remark>

  <\cor>
    When <math|<around|\||det A|\|>=1>, <math|C<around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>><Z>>
    has many invariant traces.
  </cor>

  <\proof>
    The homeomorphism <math|\<sigma\><rsub|A>> has many finite orbits \V
    indeed, the periodic points are dense in <math|<T><rsup|d>>. (If the
    coordinates of <math|r\<in\><Q><rsup|d>> have common denominator
    <math|N>, then the denominators of all the coordinates in all the
    <math|A<rsup|n>*r> divide <math|N> too, and the pigeon-hole principle
    implies that <math|e<rsup|2*\<pi\>*i*r>> is periodic.) But if
    <math|z\<in\><T><rsup|d>> has <math|\<sigma\><rsub|A><rsup|n><around|(|z|)>=z>,
    then <math|n<rsup|-1>*<big|sum><rsub|j=0><rsup|n-1>\<delta\><rsub|\<sigma\><rsub|A><rsup|j><around|(|z|)>>>
    is an invariant measure.
  </proof>

  <\example>
    <label|tracesHgp>Consider <math|A=<around*|(|<matrix*|<tformat|<table|<row|<cell|1>|<cell|0>>|<row|<cell|1>|<cell|1>>>>>|)>>,
    for which we have <math|\<sigma\><rsub|A><around|(|w,z|)>=<around|(|w,w*z|)>>.
    Let <math|\<lambda\>> denote Haar measure on <math|<T>> and let
    <math|\<nu\>> be a probability measure on <math|<T>>. Then the product
    measure <math|\<mu\>=\<nu\>\<times\>\<lambda\>> is invariant for
    <math|\<sigma\><rsub|A>>:

    <align*|<tformat|<table|<row|<cell|<big|int><rsub|<T><rsup|2>>f\<circ\>\<sigma\><rsub|A>>|<cell|<around|(|w,z|)>*<space|0.17em>d*\<mu\><around|(|w,z|)>=<big|int><rsub|<T>><space|-0.17em><big|int><rsub|<T>>f*<around|(|w,w*z|)>*<space|0.17em>d*\<lambda\><around|(|z|)>*<space|0.17em>d*\<nu\><around|(|w|)>>>|<row|<cell|>|<cell|=<big|int><rsub|<T>><space|-0.17em><big|int><rsub|<T>>f<around|(|w,z|)>*<space|0.17em>d*\<lambda\><around|(|z|)>*<space|0.17em>d*\<nu\><around|(|w|)>=<big|int><rsub|<T><rsup|2>>f<around|(|w,z|)>*<space|0.17em>d*\<mu\><around|(|w,z|)>.>>>>>

    The moments of <math|\<mu\>> are given by

    <\equation*>
      M<rsub|\<mu\>><around|(|m|)>=<big|int><rsub|<T>><space|-0.17em><big|int><rsub|<T>>w<rsup|m<rsub|1>>*z<rsup|m<rsub|2>>*<space|0.17em>d*\<lambda\><around|(|z|)>*<space|0.17em>d*\<nu\><around|(|w|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      >m<rsub|2>=0>>|<row|<cell|M<rsub|\<nu\>><around|(|m<rsub|1>|)>>|<cell|<text|if
      <math|m<rsub|2>=0>.>>>>>>
    </equation*>

    Thus Proposition<nbsp><reference|invtr> gives <math|\<sigma\>>-invariant
    traces <math|<around|{|\<phi\><rsub|\<nu\>>:\<nu\>\<in\>P<around|(|<T>|)>|}>>
    on <math|C<rsup|\<ast\>><around|(|<T><rsup|d>|)>\<rtimes\><rsub|\<alpha\><rsub|A>><Z>>
    such that

    <\equation*>
      \<phi\><rsub|\<nu\>>*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      <math|k=0> and >m<rsub|2>=0>>|<row|<cell|M<rsub|\<nu\>><around|(|m<rsub|1>|)>>|<cell|<text|if
      <math|k=0> and <math|m<rsub|2>=0>.>>>>>>
    </equation*>
  </example>

  <\example>
    When <math|A=<around*|(|<matrix*|<tformat|<table|<row|<cell|1>|<cell|0>>|<row|<cell|1>|<cell|1>>>>>|)>>
    and <math|\<mu\>=\<lambda\>\<times\>\<nu\>>, we claim that the state
    <math|\<psi\><rsub|\<beta\>,\<mu\>>> described in <eqref|psibeta>
    converges as <math|\<beta\>\<to\>0+> to the state of
    Theorem<nbsp><reference|betalogN>, which for <math|\<beta\>=log
    <around|\||det A|\|>=0> vanishes on <math|u<rsub|m>*v<rsup|k>> unless
    <math|<around|(|m,k|)>=<around|(|0,0|)>> and satisfies
    <math|\<psi\><around|(|u<rsub|0>|)>=1>. To see this, note that
    <math|B=A<rsup|t>=<around*|(|<matrix*|<tformat|<table|<row|<cell|1>|<cell|1>>|<row|<cell|0>|<cell|1>>>>>|)>>,
    so <math|B<rsup|-j>=<around*|(|<matrix*|<tformat|<table|<row|<cell|1>|<cell|-j>>|<row|<cell|0>|<cell|1>>>>>|)>>,
    and

    <\equation*>
      M<rsub|\<lambda\>\<times\>\<nu\>>*<around|(|B<rsup|-j>*<around|(|m-n|)>|)>=<big|int><space|-0.17em><big|int>w<rsup|<around|(|m<rsub|1>-n<rsub|1>|)>-j*<around|(|m<rsub|2>-n<rsub|2>|)>>*<space|0.17em>d*\<lambda\><around|(|w|)>*<space|0.17em>z<rsup|m<rsub|2>-n<rsub|2>>*<space|0.17em>d*\<nu\><around|(|z|)>,
    </equation*>

    which vanishes unless <math|m<rsub|1>-n<rsub|1>=j*<around|(|m<rsub|2>-n<rsub|2>|)>>.
    For <math|m=n>, we have <math|M<rsub|\<mu\>>*<around|(|B<rsup|-j>*<around|(|m-n|)>|)>=1>
    for all <math|j>, and summing the series shows that
    <math|\<psi\><rsub|\<beta\>,\<mu\>>*<around|(|u<rsub|n>*v<rsup|k>*v<rsup|\<ast\>k>*u<rsub|n><rsup|\<ast\>>|)>=e<rsup|-k*\<beta\>>\<to\>1>
    as <math|\<beta\>\<to\>0> for all <math|k>. If <math|m\<neq\>n> and
    <math|m-n> does not have the form <math|<around|(|l*i,i|)>>, then
    <math|\<psi\><rsub|\<beta\>,\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>k>*u<rsub|n><rsup|\<ast\>>|)>=0>
    for all <math|k>. If <math|m-n=<around|(|l*i,i|)>>, then
    <math|\<psi\><rsub|\<beta\>,\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>k>*u<rsub|n><rsup|\<ast\>>|)>>
    vanishes for <math|k\<gtr\>l>, and

    <\equation*>
      \<psi\><rsub|\<beta\>,\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>k>*u<rsub|n><rsup|\<ast\>>|)>=<around|(|1-e<rsup|-\<beta\>>|)>*e<rsup|-l*\<beta\>>*M<rsub|\<nu\>><around|(|i|)>\<to\>0*<text|as
      >\<beta\>\<to\>0
    </equation*>

    for <math|k\<leq\>l>. So whenever <math|m\<neq\>n>, we have
    <math|\<psi\><rsub|\<beta\>,\<mu\>>*<around|(|u<rsub|m>*v<rsup|k>*v<rsup|\<ast\>k>*u<rsub|n><rsup|\<ast\>>|)>\<to\>0>
    as <math|\<beta\>\<to\>0>, and the limit is the state <math|\<phi\>> of
    Theorem<nbsp><reference|betalogN>, as claimed. (Well, strictly speaking
    the limit is <math|\<phi\>\<circ\>Q>.)
  </example>

  <\remark>
    <label|tracesonHgp>When <math|A=<around*|(|<matrix*|<tformat|<table|<row|<cell|1>|<cell|0>>|<row|<cell|1>|<cell|1>>>>>|)>>
    and <math|B=A<rsup|t>=<around*|(|<matrix*|<tformat|<table|<row|<cell|1>|<cell|1>>|<row|<cell|0>|<cell|1>>>>>|)>>,
    the map

    <\equation>
      <label|defHgp><around|(|m,k|)>=<around|(|<around|(|m<rsub|1>,m<rsub|2>|)>,k|)>\<mapsto\><matrix|<tformat|<table|<row|<cell|1>|<cell|k>|<cell|m<rsub|1>>>|<row|<cell|0>|<cell|1>|<cell|m<rsub|2>>>|<row|<cell|0>|<cell|0>|<cell|1>>>>>
    </equation>

    is an isomorphism of <math|<Z><rsup|2>\<rtimes\><rsub|B><Z>> onto the
    integer Heisenberg group <math|H<around|(|<Z>|)>>. (The crux is that
    <math|B<rsup|k>=<around*|(|<matrix*|<tformat|<table|<row|<cell|1>|<cell|k>>|<row|<cell|0>|<cell|1>>>>>|)>>.)
    For <math|\<theta\>\<in\><around|[|0,1|]>>, we view the rotation algebra
    <math|<AA><rsub|\<theta\>>> as the universal
    <math|C<rsup|\<ast\>>>-algebra generated by unitaries <math|U,V>
    satisfying <math|V*U=e<rsup|2*\<pi\>*i*\<theta\>>*U*V>, and then the
    unitary representation <math|<around|(|m,k|)>\<mapsto\>e<rsup|2*\<pi\>*i*m<rsub|1>*\<theta\>>*U<rsup|m<rsub|2>>*V<rsup|k>>
    induces a surjection <math|q<rsub|\<theta\>>> of
    <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>> onto
    <math|<AA><rsub|\<theta\>>>. (Indeed, the quotients
    <math|<AA><rsub|\<theta\>>> are the fibres of a
    <math|C<rsup|\<ast\>>>-bundle over <math|<T>> which has
    <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>> as its algebra of
    continuous sections \V see <cite|e>, <cite-detail|ap|1> or
    <cite-detail|prae|Example<nbsp>1.4>.)

    Every rotation algebra <math|<AA><rsub|\<theta\>>> has a trace
    <math|\<tau\><rsub|\<theta\>>> which kills
    <math|U<rsup|m<rsub|2>>*V<rsup|k>> unless <math|m<rsub|2>=0=k>, and the
    composition <math|\<tau\><rsub|\<theta\>>\<circ\>q<rsub|\<theta\>>> is
    the invariant trace described in Example<nbsp><reference|tracesHgp> for
    <math|\<nu\>> the point mass at <math|e<rsup|2*\<pi\>*i*\<theta\>>>. When
    <math|\<theta\>> is irrational, <math|\<tau\><rsub|\<theta\>>> is the
    only trace on <math|<AA><rsub|\<theta\>>> (see
    <cite-detail|dav|Proposition<nbsp>VI.1.3>, for example). When
    <math|\<theta\>> is rational, <math|<AA><rsub|\<theta\>>> is a
    homogeneous <math|C<rsup|\<ast\>>>-algebra with spectrum
    <math|<T><rsup|2>> (by, for example, <cite-detail|dr|2>), and has other
    traces which give non-invariant traces of
    <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>>. For example, the
    matrices <math|T=<around*|(|<matrix*|<tformat|<table|<row|<cell|0>|<cell|1>>|<row|<cell|1>|<cell|0>>>>>|)>>
    and <math|S=<around*|(|<matrix*|<tformat|<table|<row|<cell|-1>|<cell|0>>|<row|<cell|0>|<cell|1>>>>>|)>>
    are unitary and satisfy <math|T*S=-S*T>, hence give a homomorphism
    <math|\<pi\><rsub|S,T>:<AA><rsub|1/2>\<to\>M<rsub|2><around|(|<C>|)>>,
    and composing with the usual normalised trace <math|2<rsup|-1><tr>> gives
    a trace <math|\<tau\>> on <math|<AA><rsub|1/2>> such that
    <math|\<tau\>*<around|(|U<rsup|m<rsub|2>>*V<rsup|k>|)>=2<rsup|-1><tr><around|(|S<rsup|m<rsub|2>>*T<rsup|k>|)>>.
    Since <math|T<rsup|2>=1>, we have <math|\<tau\><around|(|V<rsup|2>|)>=\<tau\><around|(|1|)>=1>,
    and since <math|\<sigma\><rsub|t><around|(|v<rsup|2>|)>=e<rsup|2*i*t>*v<rsup|2>>,
    <math|\<tau\><around|(|V<rsup|2>|)>=1> implies that
    <math|\<tau\>\<circ\>q<rsub|1/2>> cannot be <math|\<sigma\>>-invariant.

    To explain where the other invariant traces in
    Example<nbsp><reference|tracesHgp> come from, we examine the structure of
    <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>> from another point
    of view. Consider the normal subgroup <math|N> of matrices <eqref|defHgp>
    with <math|k=m<rsub|2>=0>, which is the centre of
    <math|H<around|(|<Z>|)>>, and which has quotient
    <math|H<around|(|<Z>|)>/N> isomorphic to <math|<Z><rsup|2>> via
    <math|<around|(|m,k|)>\<mapsto\><around|(|k,m<rsub|2>|)>>. Applying
    Theorem<nbsp>4.1 of <cite|prae2> to <math|N> gives a realisation of
    <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>=<C>\<times\><rsub|,1>H<around|(|<Z>|)>>
    as a Busby-Smith twisted crossed product
    <math|C<rsup|\<ast\>><around|(|N|)>\<rtimes\><rsub|\<beta\>,\<omega\>><Z><rsup|2>>;
    identifying <math|C<rsup|\<ast\>><around|(|N|)>> with
    <math|C<around|(|<T>|)>> and ploughing through the formulas in
    <cite|prae2> shows that <math|\<beta\>> is the identity and the cocycle
    <math|\<omega\>:<Z><rsup|2>\<to\>U<around|(|C<around|(|<T>|)>|)>=C<around|(|<T>,<T>|)>>
    is given by

    <\equation*>
      \<omega\><around|(|<around|(|k,m<rsub|2>|)>,<around|(|l,n<rsub|2>|)>|)><around|(|z|)>=z<rsup|k*n<rsub|2>>.
    </equation*>

    Averaging over the dual action of <math|<T><rsup|2>> gives an expectation
    <math|E<rsup|<wide|\<beta\>|^>>> whose range is the fixed-point algebra
    <math|C<around|(|<T>|)>\<subset\>C<around|(|<T>|)>\<rtimes\><rsub|,\<omega\>><Z><rsup|2>>,
    which we can pull over to an expectation <math|E> on
    <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>> such that

    <\equation*>
      E*<around|(|<wide|u|\<bar\>><rsub|m>*<wide|v|\<bar\>><rsup|k>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      <math|k=0> and >m<rsub|2>=0>>|<row|<cell|<wide|u|\<bar\>><rsub|m<rsub|1>,0>>|<cell|<text|if
      <math|k=0> and <math|m<rsub|2>=0>.>>>>>>
    </equation*>

    A direct calculation shows that <math|E> has the tracial property
    <math|E*<around|(|a*b|)>=E*<around|(|b*a|)>> (<math|E> is a
    <em|centre-valued trace> on <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>><space|0.27em>),
    and the isomorphism of <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>>
    onto <math|C<around|(|<T>|)>\<rtimes\><rsub|,\<omega\>><Z><rsup|2>>
    carries <math|\<sigma\>> into <math|t\<mapsto\><wide|\<beta\>|^><rsub|<around|(|e<rsup|i*t>,1|)>>>.
    Thus any state of the form <math|\<phi\>\<circ\>E> is an invariant trace
    of <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>>. These are the
    traces described in Example<nbsp><reference|tracesHgp>.
  </remark>

  <\thebibliography|20>
    <bibitem|ap>J. Anderson and W. Paschke, <with|font-shape|italic|The
    rotation algebra>, Houston J. Math. <with|font-series|bold|15> (1989),
    1\U26.

    <bibitem|aijln>L.W. Baggett, N.S. Larsen, J.A. Packer, I. Raeburn and A.
    Ramsay, <with|font-shape|italic|Direct limits, multiresolution analyses,
    and wavelets>, J. Funct. Anal. <with|font-series|bold|258> (2010),
    2714\U2738.

    <bibitem|bos-con>J.-B. Bost and A. Connes, <em|Hecke algebras, type III
    factors and phase transitions with spontaneous symmetry breaking in
    number theory>, Selecta Math. (New Series) <with|font-series|bold|1>
    (1995), 411\U457.

    <bibitem|bj>O. Bratteli and P.E.T. Jorgensen,
    <with|font-shape|italic|Isometries, shifts, Cuntz algebras and
    multiresolution analyses of scale <math|N>>, Integral Equations Operator
    Theory <with|font-series|bold|28> (1997), 382\U443.

    <bibitem|bra-rob>O. Bratteli and D.W. Robinson, Operator Algebras and
    Quantum Statistical Mechanics II, Second Edition, Springer-Verlag,
    Berlin, 1997.

    <bibitem|BaHLR>N. Brownlowe, A. an Huef, M. Laca and I. Raeburn,
    <with|font-shape|italic|Boundary quotients of the Toeplitz algebra of the
    affine semigroup over the natural numbers>, Ergodic Theory Dynam.
    Systems, to appear; arXiv:1009.3678.

    <bibitem|br>N. Brownlowe and I. Raeburn, <with|font-shape|italic| Exel's
    crossed product and relative Cuntz-Pimsner algebras>, Math. Proc.
    Cambridge Philos. Soc. <with|font-series|bold|141> (2006), 497\U508.

    <bibitem|cm>A. Connes and M. Marcolli, Noncommutative Geometry, Quantum
    Fields, and Motives, Colloquium Publications, vol. 55, Amer. Math. Soc.,
    Providence, 2008.

    <bibitem|cl>J. Crisp and M. Laca, <with|font-shape|italic|Boundary
    quotients and ideals of Toeplitz <math|C<rsup|\<ast\>>>-algebras of Artin
    groups>, J. Funct. Anal. <with|font-series|bold|242> (2007), 127\U156.

    <bibitem|c2>J. Cuntz, <with|font-shape|italic|<math|C<rsup|\<ast\>>>-algebras
    associated with the <math|a*x+b>-semigroup over <math|<N>>>, in:
    <math|K>-Theory and Noncommutative Geometry (Valladolid, 2006), European
    Math. Soc., Zrich, 2008, pages<nbsp>201\U215.

    <bibitem|dav>K.R. Davidson, <math|C<rsup|\<ast\>>>-Algebras by Example,
    Fields Institute Monographs, vol. 6, Amer. Math. Soc., Providence, 1996.

    <bibitem|dr>S. Disney and I. Raeburn, <with|font-shape|italic|Homogeneous
    <math|C<rsup|\<ast\>>>-algebras whose spectra are tori>, J. Aust. Math.
    Soc. (Ser. A) <with|font-series|bold|38> (1985), 9\U39.

    <bibitem|e>G.A. Elliott, <with|font-shape|italic|On the <math|K>-theory
    of the <math|C<rsup|\<ast\>>>-algebra generated by a projective
    representation of a torsion-free discrete group>, in: Operator Algebras
    and Group Representations, Vol I (Neptun, 1980), Monographs and Studies
    in Mathematics, vol. 17, Pitman, Boston, 1984, pages 157\U184.

    <bibitem|eva>D.E. Evans, <with|font-shape|italic|On
    <math|\<cal-O\><rsub|n>>>, Publ. Res. Inst. Math. Sci.
    <with|font-series|bold|16> (1980), 915\U927.

    <bibitem|e1>R. Exel, <with|font-shape|italic|A new look at the
    crossed-product of a <math|C<rsup|\<ast\>>>-algebra by an endomorphism>,
    Ergodic Theory Dynam. Systems <with|font-series|bold|23> (2003), 1\U18.

    <bibitem|e2>R. Exel, <with|font-shape|italic|Crossed-products by finite
    index endomorphisms and KMS states>, J. Funct. Anal.
    <with|font-series|bold|199> (2003), 153\U188.

    <bibitem|ehr>R. Exel, A. an Huef and I. Raeburn,
    <with|font-shape|italic|Purely infinite simple
    <math|C<rsup|\<ast\>>>-algebras associated to integer dilation matrices>,
    Indiana Univ. Math. J., to appear; arXiv:1003.2097.

    <bibitem|ev>R. Exel and A. Vershik, <with|font-shape|italic|<math|C<rsup|\<ast\>>>-algebras
    of irreversible dynamical systems>, Canad. J. Math.
    <with|font-series|bold|58> (2006), 39\U63.

    <bibitem|fr>N.J. Fowler and I. Raeburn, <with|font-shape|italic|The
    Toeplitz algebra of a Hilbert bimodule>, Indiana Univ. Math. J.
    <with|font-series|bold|48> (1999), 155\U181.

    <bibitem|laca98>M. Laca, <with|font-shape|italic|Semigroups of
    <math|\<ast\>>-endomorphisms, Dirichlet series, and phase transitions>,
    J. Funct. Anal. <with|font-series|bold|152> (1998), 330\U378.

    <bibitem|ln>M. Laca and S. Neshveyev, <with|font-shape|italic|KMS states
    of quasi-free dynamics on Pimsner algebras>, J. Funct. Anal.
    <with|font-series|bold|211> (2004), 457\U482.

    <bibitem|lr1>M. Laca and I. Raeburn, <with|font-shape|italic|Semigroup
    crossed products and the Toeplitz algebras of nonabelian groups>, J.
    Funct. Anal. <with|font-series|bold|139> (1996), 415\U440.

    <bibitem|lr>M. Laca and I. Raeburn, <with|font-shape|italic|Phase
    transition on the Toeplitz algebra of the affine semigroup over the
    natural numbers>, Adv. Math. <with|font-series|bold|225> (2010),
    643\U688.

    <bibitem|l>N. S. Larsen, <with|font-shape|italic|Crossed products by
    abelian semigroups via transfer operators>, Ergodic Theory Dynam. Systems
    <with|font-series|bold|30> (2010), 1147\U1164.

    <bibitem|LL>N.S. Larsen and X. Li, <with|font-shape|italic|The
    <math|2>-adic ring <math|C<rsup|\<ast\>>>-algebra of the integers and its
    representations>, arXiv:1011.5622.

    <bibitem|LR2>N.S. Larsen and I. Raeburn,
    <with|font-shape|italic|Projective multi-resolution analyses arising from
    direct limits of Hilbert modules>, Math. Scand.
    <with|font-series|bold|100> (2007), 317\U360.

    <bibitem|m>G.J. Murphy, <with|font-shape|italic|Ordered groups and
    crossed products of <math|C<rsup|\<ast\>>>-algebras>, Pacific J. Math.
    <with|font-series|bold|148> (1991), 319\U349.

    <bibitem|n>A. Nica, <with|font-shape|italic|<math|C<rsup|\<ast\>>>-algebras
    generated by isometries and Wiener-Hopf operators>, J. Operator Theory
    <with|font-series|bold|27> (1992), 17\U52.

    <bibitem|prae2>J.A. Packer and I. Raeburn,
    <with|font-shape|italic|Twisted crossed products of
    <math|C<rsup|\<ast\>>>-algebras>, Math. Proc. Cambridge Philos. Soc.
    <with|font-series|bold|106> (1989), 293\U311.

    <bibitem|prae>J.A. Packer and I. Raeburn, <with|font-shape|italic|On the
    structure of twisted group <math|C<rsup|\<ast\>>>-algebras>, Trans. Amer.
    Math. Soc. <with|font-series|bold|334> (1992), 685\U718.

    <bibitem|pr>J.A. Packer and M.A. Rieffel, <with|font-shape|italic|Wavelet
    filter functions, the matrix completion problem, and projective modules
    over <math|C<around|(|<T><rsup|n>|)>>>, J. Fourier Anal. Appl.
    <with|font-series|bold|9> (2003), 101\U116.

    <bibitem|ped>G.K. Pedersen, <math|C<rsup|\<ast\>>>-Algebras and their
    Automorphism Groups, London Math. Soc. Monographs, vol.<nbsp>14, Academic
    Press, London, 1979.

    <bibitem|p>M.V. Pimsner, <with|font-shape|italic|A class of
    <math|C<rsup|\<ast\>>>-algebras generalizing both Cuntz-Krieger algebras
    and crossed products by <math|<Z>>>, in: Free Probability Theory
    (Waterloo, 1995), Fields Institute Commun., vol. 12, Amer. Math. Soc.,
    Providence, 1997, 189\U212.

    <bibitem|tfb>I. Raeburn and D.P. Williams, Morita Equivalence and
    Continuous-Trace <math|C<rsup|\<ast\>>>-Algebras, Math. Surveys and
    Monographs, vol. 60, Amer. Math. Soc., Providence, 1998.

    <bibitem|tfb^2>D.P. Williams, Crossed Products of
    <math|C<rsup|\<ast\>>>-Algebras, Math. Surveys and Monographs, vol. 134,
    Amer. Math. Soc., Providence, 2007.
  </thebibliography>

  <\prop>
    There is an expectation <math|E> of <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>>
    onto <math|C<rsup|\<ast\>><around|(|u<rsub|<around|(|1,0|)>>|)>> such
    that

    <\equation>
      <label|charE>E*<around|(|u<rsub|<around|(|m<rsub|1>,m<rsub|2>|)>>*v<rsup|k>|)>=<choice|<tformat|<table|<row|<cell|0>|<cell|<text|unless
      >m<rsub|2>=k=0>>|<row|<cell|u<rsub|<around|(|m<rsub|1>,0|)>>>|<cell|<text|if
      <math|m<rsub|2>=k=0>,>>>>>>
    </equation>

    and we have <math|E*<around|(|a*b|)>=E*<around|(|b*a|)>> for all
    <math|a,b\<in\>C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>>.
  </prop>

  <\proof>
    We consider the normal subgroup <math|N> of <math|H<around|(|<Z>|)>> of
    matrices <eqref|defHgp> with <math|k=m<rsub|2>=0>, identify the quotient
    <math|H<around|(|<Z>|)>/N> with <math|<Z><rsup|2>> via the map which
    sends the matrix <eqref|defHgp> to <math|<around|(|k,m<rsub|2>|)>>, and
    define <math|c:H<around|(|<Z>|)>/N\<to\>H<around|(|<Z>|)>> by

    <\equation*>
      c<around|(|k,m<rsub|2>|)>=<matrix|<tformat|<table|<row|<cell|1>|<cell|k>|<cell|0>>|<row|<cell|0>|<cell|1>|<cell|m<rsub|2>>>|<row|<cell|0>|<cell|0>|<cell|1>>>>>.
    </equation*>

    Applying the decomposition theorem <cite-detail|prae2|Theorem<nbsp>4.1>
    to the twisted crossed product <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>=<C>\<times\><rsub|,1>H<around|(|<Z>|)>>
    with this data gives a twisted action
    <math|<around|(|\<beta\>,\<omega\>|)>> of
    <math|<Z><rsup|2>=H<around|(|<Z>|)>/N> on
    <math|<C>\<times\><rsub|,1>N=C<rsup|\<ast\>><around|(|N|)>> and an
    isomorphism <math|\<phi\>> of <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>>
    onto <math|C<rsup|\<ast\>><around|(|N|)>\<times\><rsub|\<beta\>,\<omega\>><Z><rsup|2>>.
    Since the original twisted action <math|<around|(|,1|)>> is trivial, and
    since <math|N> is central, the formulas in <cite|prae2> collapse to give
    <math|\<beta\>=>, and

    <\equation*>
      \<omega\><around|(|<around|(|k,m<rsub|2>|)>,<around|(|l,n<rsub|2>|)>|)>=i<rsub|N>*<around|(|c<around|(|k,m<rsub|2>|)>*c<around|(|l,n<rsub|2>|)>*c*<around|(|k+l,m<rsub|2>+n<rsub|2>|)><rsup|-1>|)>=i<rsub|N><space|-0.17em><space|-0.17em><around*|(|<matrix|<tformat|<table|<row|<cell|1>|<cell|0>|<cell|k*n<rsub|2>>>|<row|<cell|0>|<cell|1>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|1>>>>>|)>.
    </equation*>

    when we identify <math|C<rsup|\<ast\>><around|(|N|)>> with
    <math|C<rsup|\<ast\>><around|(|<Z>|)>> and <math|C<around|(|<T>|)>> in
    the obvious way, <math|\<omega\>:<Z><rsup|2>\<times\><Z><rsup|2>\<to\>U*C<around|(|<T>|)>>
    is given by

    <\equation*>
      \<omega\><around|(|<around|(|k,m<rsub|2>|)>,<around|(|l,n<rsub|2>|)>|)><around|(|z|)>=z<rsup|k*n<rsub|2>>.
    </equation*>

    The formulas for the isomorphism <math|\<phi\>> (unfortunately buried in
    the proof of <cite-detail|prae2|Theorem<nbsp>4.1>) also collapse, and we
    have

    <\equation*>
      \<phi\>*<around|(|u<rsub|m>*v<rsup|k>|)>=i<rsub|C<around|(|<T>|)>><around|(|\<iota\><rsup|m<rsub|1>>|)>*i<rsub|<Z><rsup|2>><around|(|k,m<rsub|2>|)>=i<rsub|<Z><rsup|2>><around|(|k,m<rsub|2>|)>*i<rsub|C<around|(|<T>|)>><around|(|\<iota\><rsup|m<rsub|1>>|)>.
    </equation*>

    The crossed product <math|C<around|(|<T>|)>\<times\><rsub|,\<omega\>><Z><rsup|2>>
    carries a natural dual action <math|<wide|\<beta\>|^>> of
    <math|<T><rsup|2>=<around|(|<Z><rsup|2>|)><rsup|\<wedge\>>>, which is
    characterised by

    <\equation*>
      <wide|\<beta\>|^><rsub|<around|(|w,z|)>>*<around|(|i<rsub|<Z><rsup|2>><around|(|k,m<rsub|2>|)>*i<rsub|C<around|(|<T>|)>><around|(|\<iota\><rsup|m<rsub|1>>|)>|)>=w<rsup|k>*z<rsup|m<rsub|2>>*i<rsub|<Z><rsup|2>><around|(|k,m<rsub|2>|)>*i<rsub|C<around|(|<T>|)>><around|(|\<iota\><rsup|m<rsub|1>>|)>.
    </equation*>

    Averaging over <math|<wide|\<beta\>|^>> gives an expectation of
    <math|C<around|(|<T>|)>\<times\><rsub|,\<omega\>><Z><rsup|2>> onto
    <math|i<rsub|C<around|(|<T>|)>><around|(|C<around|(|<T>|)>|)>=i<rsub|C<around|(|<T>|)>><around|(|C<rsup|\<ast\>><around|(|\<iota\>|)>|)>>,
    and pulling this back to <math|C<rsup|\<ast\>><around|(|H<around|(|<Z>|)>|)>>
    gives an expectation <math|E> onto <math|\<phi\><rsup|-1><around|(|i<rsub|C<around|(|<T>|)>><around|(|C<rsup|\<ast\>><around|(|\<iota\>|)>|)>|)>=C<rsup|\<ast\>><around|(|u<rsub|<around|(|1,0|)>>|)>>
    satisfying <eqref|charE>. A direct computation with
    <math|a=u<rsub|m>*v<rsup|k>> and <math|b=u<rsub|n>*v<rsup|l>> gives the
    last assertion.
  </proof>
</body>