<TeXmacs|1.99.7>

<style|<tuple|ieeetran|std-latex>>

<\body>
  <\hide-preamble>
    <assign|mref|<macro|1|(<reference|1>)>>

    <assign|algorithmicrequire|<macro|<with|font-series|bold|Input:>>>

    <assign|algorithmicensure|<macro|<with|font-series|bold|Output:>>>

    <assign|bal|<macro|<with|math-font-family|bf|\<alpha\>>>>

    <assign|bep|<macro|<with|math-font-family|bf|\<epsilon\>>>>

    <assign|bth|<macro|<with|math-font-family|bf|\<theta\>>>>

    <assign|brho|<macro|<with|math-font-family|bf|\<rho\>>>>

    <assign|bPhi|<macro|<with|math-font-family|bf|\<Phi\>>>>

    <assign|bphi|<macro|<with|math-font-family|bf|\<phi\>>>>

    <assign|bDel|<macro|<with|math-font-family|bf|\<Delta\>>>>

    <assign|bdel|<macro|<with|math-font-family|bf|\<delta\>>>>

    <assign|bDelta|<macro|<with|math-font-family|bf|\<Delta\>>>>

    <assign|bbeta|<macro|<with|math-font-family|bf|\<beta\>>>>

    <assign|bmu|<macro|<with|math-font-family|bf|\<mu\>>>>

    <assign|bet|<macro|<with|math-font-family|bf|\<eta\>>>>

    <assign|bGam|<macro|<with|math-font-family|bf|\<Gamma\>>>>

    <assign|bgam|<macro|<with|math-font-family|bf|\<gamma\>>>>

    <assign|bchi|<macro|<with|math-font-family|bf|\<chi\>>>>

    <assign|bxi|<macro|<with|math-font-family|bf|\<xi\>>>>

    <assign|bUps|<macro|<with|math-font-family|bf|\<Upsilon\>>>>

    <assign|bomega|<macro|<with|math-font-family|bf|\<omega\>>>>

    <assign|bOmega|<macro|<with|math-font-family|bf|\<Omega\>>>>

    <assign|bSig|<macro|<with|math-font-family|bf|\<Sigma\>>>>

    <assign|bPsi|<macro|<with|math-font-family|bf|\<Psi\>>>>

    <assign|bLam|<macro|<with|math-font-family|bf|\<Lambda\>>>>

    <assign|ba|<macro|<math-bf|a>>>

    <assign|bb|<macro|<math-bf|b>>>

    <assign|bc|<macro|<math-bf|c>>>

    <assign|bd|<macro|<math-bf|d>>>

    <assign|be|<macro|<math-bf|e>>>

    <assign|bg|<macro|<math-bf|g>>>

    <assign|bh|<macro|<math-bf|h>>>

    <assign|bi|<macro|<math-bf|i>>>

    <assign|bj|<macro|<math-bf|j>>>

    <assign|bk|<macro|<math-bf|k>>>

    <assign|bl|<macro|<math-bf|l>>>

    <assign|bm|<macro|<math-bf|m>>>

    <assign|bn|<macro|<math-bf|n>>>

    <assign|bo|<macro|<math-bf|o>>>

    <assign|bp|<macro|<math-bf|p>>>

    <assign|bq|<macro|<math-bf|q>>>

    <assign|br|<macro|<math-bf|r>>>

    <assign|bs|<macro|<math-bf|s>>>

    <assign|bt|<macro|<math-bf|t>>>

    <assign|bu|<macro|<math-bf|u>>>

    <assign|bv|<macro|<math-bf|v>>>

    <assign|bw|<macro|<math-bf|w>>>

    <assign|bx|<macro|<math-bf|x>>>

    <assign|by|<macro|<math-bf|y>>>

    <assign|bz|<macro|<math-bf|z>>>

    <assign|bA|<macro|<math-bf|A>>>

    <assign|bB|<macro|<math-bf|B>>>

    <assign|bC|<macro|<math-bf|C>>>

    <assign|bD|<macro|<math-bf|D>>>

    <assign|bE|<macro|<math-bf|E>>>

    <assign|bF|<macro|<math-bf|F>>>

    <assign|bG|<macro|<math-bf|G>>>

    <assign|bH|<macro|<math-bf|H>>>

    <assign|bI|<macro|<math-bf|I>>>

    <assign|bJ|<macro|<math-bf|J>>>

    <assign|bK|<macro|<math-bf|K>>>

    <assign|bL|<macro|<math-bf|L>>>

    <assign|bN|<macro|<math-bf|N>>>

    <assign|bM|<macro|<math-bf|M>>>

    <assign|bO|<macro|<math-bf|O>>>

    <assign|bP|<macro|<math-bf|P>>>

    <assign|bQ|<macro|<math-bf|Q>>>

    <assign|bR|<macro|<math-bf|R>>>

    <assign|bS|<macro|<math-bf|S>>>

    <assign|bT|<macro|<math-bf|T>>>

    <assign|bU|<macro|<math-bf|U>>>

    <assign|bV|<macro|<math-bf|V>>>

    <assign|bW|<macro|<math-bf|W>>>

    <assign|bX|<macro|<math-bf|X>>>

    <assign|bY|<macro|<math-bf|Y>>>

    <assign|bZ|<macro|<math-bf|Z>>>

    <assign|complexC|<macro|\<bbb-C\>>>

    <assign|realR|<macro|\<bbb-R\>>>

    <assign|tbH|<macro|<wide|<bH>|~>>>

    <assign|tbh|<macro|<wide|<bh>|~>>>

    <assign|bzero|<macro|\<b-0\>>>

    <assign|bone|<macro|\<b-1\>>>

    <assign|mX|<macro|\<cal-X\>>>

    <assign|mY|<macro|\<cal-Y\>>>

    <assign|mS|<macro|\<cal-S\>>>

    <assign|mL|<macro|\<cal-L\>>>

    <assign|mI|<macro|\<cal-I\>>>

    <assign|mJ|<macro|\<cal-J\>>>

    <assign|mR|<macro|\<cal-R\>>>

    <assign|b|<macro|\<b-0\>>>

    <assign|bPi|<macro|<with|math-font-family|bf|\<Pi\>>>>

    <assign|norm|<macro|1|<left|\|\|><arg|1> <right|\|\|>>>

    <assign|snorm|<macro|1|<left|\|\|><arg|1> <right|\|\|><rsup|2> >>

    <assign|pp|<macro|1|<left|(> <arg|1> <right|)>>>

    <new-theorem|prop|Proposition>
  </hide-preamble>

  <doc-data|<doc-title|Solutions for the MIMO Gaussian Wiretap Channel with a
  Cooperative Jammer>|<doc-author|<author-data|<author-name|<with|font-size|1|S.
  Ali. A. Fakoorian*, <with|font-shape|italic|Student Member, IEEE> and A.
  Lee Swindlehurst, <with|font-shape|italic|Fellow,
  IEEE>>>>>|<doc-date|<date|>>|<doc-note|The authors are with the Dept. of
  Electrical Engineering and Computer Science, University of California,
  Irvine, CA 92697-2625, USA. e-mail:{afakoori,
  swindle}@uci.edu>|<doc-note|This work was supported by the U.S. Army
  Research Office under the Multi-University Research Initiative (MURI) grant
  W911NF-07-1-0318.>>

  <abstract-data|<\abstract>
    We study the Gaussian MIMO wiretap channel with a transmitter, a
    legitimate receiver, an eavesdropper and an external helper, each
    equipped with multiple antennas. The transmitter sends confidential
    messages to its intended receiver, while the helper transmits jamming
    signals independent of the source message to confuse the eavesdropper.
    The jamming signal is assumed to be treated as noise at both the intended
    receiver and the eavesdropper. We obtain a closed-form expression for the
    structure of the artificial noise covariance matrix that guarantees no
    decrease in the secrecy capacity of the wiretap channel. We also describe
    how to find specific realizations of this covariance matrix expression
    that provide good secrecy rate performance, even when there is no
    non-trivial null space between the helper and the intended receiver.
    Unlike prior work, our approach considers the general MIMO case, and is
    not restricted to SISO or MISO scenarios.

    <keywords| Physical-layer security, interference channel, MIMO wiretap
    channel, cooperative jamming.>
  </abstract>>

  <DeclareGraphicsExtensions|.eps>

  <\center>
    <with|font-series|bold|EDICS: WIN-CONT, WIN-PHYL, WIN-INFO, MSP-CAPC>
  </center>

  <new-page>

  <section|Introduction>

  Recent information-theoretic research on secure communication has focused
  on enhancing security at the physical layer. The wiretap channel, first
  introduced and studied by Wyner <cite|Wyner>, is the most basic physical
  layer model that captures the problem of communication security. This work
  led to the development of the notion of perfect secrecy capacity, which
  quantifies the maximum rate at which a transmitter can reliably send a
  secret message to its intended recipient, without it being decoded by an
  eavesdropper. The Gaussian wiretap channel, in which the outputs of the
  legitimate receiver and the eavesdropper are corrupted by additive white
  Gaussian noise, was studied in <cite|GW1978>. The secrecy capacity of a
  Gaussian wiretap channel, which is in general a difficult non-convex
  optimization problem, has been addressed and solved for in
  <cite|Hassibi>-<cite|Bustin>. The secrecy capacity under an average power
  constraint is treated in <cite|KhistiMIMO> and <cite|ours>, where in
  <cite|KhistiMIMO> a beamforming approach, based on the generalized singular
  value decomposition (GSVD), is proposed that achieves the secrecy capacity
  in the high SNR regime. In <cite|ours>, we propose an optimal power
  allocation that achieves the secrecy capacity of the GSVD-based
  multiple-input, multiple-output (MIMO) Gaussian wiretap channel for any
  SNR. In <cite|Bustin>, a closed-form expression for the secrecy capacity is
  derived under a certain power-covariance constraint.

  It was shown in <cite|Csiszar> that, for a wiretap channel without
  feedback, a non-zero secrecy capacity can only be obtained if the
  eavesdropper's channel is of lower quality than that of the intended
  recipient. Otherwise, it is infeasible to establish a secure link under
  Wyner's wiretap channel model. In such situations, one approach is to
  exploit user cooperation in facilitating the transmission of confidential
  messages from the source to the destination. In <cite|Tekin>-<cite|IFCHlp>,
  for example, a four-terminal relay-eavesdropper channel is considered,
  where a source wishes to send messages to a destination while leveraging
  the help of a relay/helper node to hide the messages from the eavesdropper.
  While the relay can assist in the transmission of confidential messages,
  its computational cost may be prohibitive and there are difficulties
  associated with the coding and decoding schemes at both the relay and the
  intended receiver. Alternatively, a cooperating node can be used as a
  helper that simply transmits jamming signals, independent of the source
  message, to confuse the eavesdropper and increase the range of channel
  conditions under which secure communications can take place. The strategy
  of using a helper to improve the secrecy of the source-destination
  communication is generally known as cooperative jamming
  <cite|Tekin|Petropulu> or noise-forwarding <cite|Gamal> in prior work.

  In <cite|Tekin>, the scenario where multiple single-antenna users
  communicate with a common receiver (i.e., the multiple access channel) in
  the presence of an eavesdropper is considered, and the optimal transmit
  power allocation that achieves the maximum secrecy sum-rate ia obtained.
  The work of <cite|Tekin> shows that any user prevented from transmitting
  based on the obtained power allocation can help increase the secrecy rate
  for other users by transmitting artificial noise to the eavesdropper
  (cooperative jamming). In <cite|Petropulu>, a source-destination system in
  the presence of multiple helpers and multiple eavesdroppers is considered,
  where the helpers can transmit weighted jamming signals to degrade the
  eavesdropper's ability to decode the source. While the objective is to
  select the weights so as to maximize the secrecy rate under a total power
  constraint, or to minimize the total power under a secrecy rate constraint,
  the results in <cite|Petropulu> yield sub-optimal weights for both single
  and multiple eavesdroppers, due to the assumption that the jamming signal
  must be nulled at the destination. The noise forwarding scheme of
  <cite|Gamal> requires that the interferer's codewords be decoded by the
  intended receiver. A generalization of <cite|Tekin|Petropulu> and
  <cite|Gamal> is proposed in <cite|IFCHlp>, in which the helper's codewords
  do not have to be decoded by the receiver.

  The prior work in <cite|Tekin>-<cite|IFCHlp> assumes single antenna nodes
  and models single-input, single-output (SISO) or multiple-input,
  single-output (MISO) cases. A more general MIMO case with multiple
  cooperative jammers was studied in <cite|WangS>, in which the jammers
  aligned their interference to lie within a pre-specified \Pjamming
  subspace\Q at the receiver, but the dimensions of the subspace and the
  power allocation were not optimized. In this paper, we also address the
  general MIMO case, where the transmitter, legitimate receiver, eavesdropper
  and helper are in general all equipped with multiple antennas. The
  transmitter sends confidential messages to its intended receiver, while the
  helper node assists the transmitter by sending jamming signals independent
  of the source message to confuse the eavesdropper. While the previous work
  on this problem shows the fundamental role of jamming as a means to
  increase secrecy rates, it also emphasizes the fact that that non-carefully
  designed jamming strategies can preclude secure communication
  <cite|Laneman>.

  In this work, we derive a closed-form expression for the structure of the
  artificial noise covariance matrix of a cooperating jammer that guarantees
  no decrease in the secrecy capacity of the wiretap channel, assuming the
  jamming signal from the helper is treated as noise at both the intended
  receiver and the eavesdropper. We describe algorithms for finding specific
  realizations of this covariance expression that provide good secrecy rate
  performance, and show that even when there is no non-trivial nullspace
  between the helper and the intended receiver, the helper can still transmit
  artificial noise that does not impact the mutual information between the
  transmitter and the intended receiver, while decreasing the mutual
  information between the transmitter and the eavesdropper. Hence, the
  secrecy level of the confidential message is increased. The situation we
  consider is different from the one in <cite|GoelN08>, where the transmitter
  itself rather than an external helper broadcasts artificial noise to
  degrade the eavesdropper's channel. However, both approaches are able to
  achieve a positive perfect secrecy rate in scenarios where the secrecy
  capacity in the absence of jamming is zero.

  The remainder of the paper is organized as follows. In Section
  <reference|sysmod>, we describe the system model for the helper-assisted
  Gaussian MIMO wiretap channel and formulate the problem to be solved. In
  Sections <reference|analysis> and <reference|scenarios>, we derive the
  artificial noise covariance matrix that guarantees no decrease in the
  secrecy capacity of the wiretap channel. Numerical results in Section
  <reference|numrst> are presented to illustrate the proposed solution.
  Finally, Section <reference|conc> concludes the paper.

  <with|font-series|bold|Notation:> Throughout the paper, we use boldface
  uppercase letters to denote matrices. Vector-valued random variables are
  written with non-boldface uppercase letters (<with|font-shape|italic|e.g.,>
  <math|X>), while the corresponding lowercase boldface letter (<math|<bx>>)
  denotes a specific realization of the random variable. Scalar variables are
  written with non-boldface (lowercase or uppercase) letters. We use
  <math|<around|(|.|)><rsup|T>> to represent matrix transposition,
  <math|<around|(|.|)><rsup|H>> the Hermitian (i.e., conjugate) transpose,
  Tr(.) the matrix trace, <math|E> the expectation operator,
  <with|font-series|bold|I> the identity matrix, and
  <with|font-series|bold|0> a matrix or vector with all zeros. Mutual
  information between the random variables <math|A> and <math|B> is denoted
  by <math|I<around|(|A;B|)>>, and <math|<with|math-font|cal|C*N><around|(|0,1|)>>
  represents the complex circularly symmetric Gaussian distribution with zero
  mean and unit variance.

  <section|System Model><label|sysmod>

  We consider a MIMO wiretap channel that includes a transmitter, an intended
  receiver, a helping interferer and an eavesdropper, with <math|n<rsub|t>>,
  <math|n<rsub|r>>, <math|n<rsub|h>> and <math|n<rsub|e>> antennas,
  respectively. The transmitter sends a confidential message to the intended
  receiver with the aid of the helper, in the presence of an eavesdropper. We
  assume that the helper does not know the confidential message and transmits
  only a Gaussian jamming signal which is not known at the intended receiver
  nor the eavesdropper and which is treated as noise at both receivers. The
  mathematical model for this scenario is given by:

  <eqnarray|<tformat|<table|<row|<cell|<by><rsub|1>>|<cell|=>|<cell|<bH><rsub|1><bx><rsub|1>+<bG><rsub|2><bx><rsub|2>+<bz><rsub|1><eq-number><label|hlp1>>>|<row|<cell|<by><rsub|2>>|<cell|=>|<cell|<bH><rsub|2><bx><rsub|2>+<bG><rsub|1><bx><rsub|1>+<bz><rsub|2><space|0.27em>,<eq-number><label|hlp2>>>>>>

  where <math|<bx><rsub|1>> is a zero-mean <math|n<rsub|t>\<times\>1>
  transmitted signal vector, <math|<bx><rsub|2>> is a zero-mean
  <math|n<rsub|h>\<times\>1> jamming vector transmitted by the helper, and
  <math|<bz><rsub|1>\<in\>\<bbb-C\><rsup|n<rsub|r>\<times\>1>>,
  <math|<bz><rsub|2>\<in\>\<bbb-C\><rsup|n<rsub|e>\<times\>1>> are additive
  white Gaussian noise (AWGN) vectors at the intended receiver and the
  eavesdropper, respectively, with i.i.d. entries distributed as
  <math|<with|math-font|cal|C*N><around|(|0,1|)>>. The matrices
  <math|<bH><rsub|1>,<bG><rsub|1>> represent the channels from the
  transmitter to the intended receiver and eavesdropper, respectively, while
  <math|<bH><rsub|2>,<bG><rsub|2>> are the channels from the helper to the
  eavesdropper and intended receiver, respectively. The channels are assumed
  to be independent of each other and full rank with arbitrary dimensions. We
  also assume that the transmitter has full channel state information and is
  aware of the effective noise covariance at both receivers, where the
  effective noise is the background noise plus the received artificial noise.
  Both the helper and the eavesdropper are also aware of all channel matrices
  as well.

  The jamming signal transmitted by the helper satisfies an average power
  constraint:

  <\equation>
    <label|hlp3><text|Tr><around|(|E*<around|{|X<rsub|2>*X<rsub|2><rsup|H>|}>|)>=<text|Tr><around|(|<bK><rsub|w>|)>\<leq\>P<rsub|h>
  </equation>

  where <math|X<rsub|2>> is the random variable associated with the specific
  realization <math|<bx><rsub|2>> and <math|<bK><rsub|w>> is the
  corresponding covariance matrix. The channel input is subject to a matrix
  power constraint <cite|Bustin|RLiu>

  <\equation>
    <label|hlp4>E*<around|{|X<rsub|1>*X<rsub|1><rsup|H>|}>=<bK><rsub|x>\<preceq\><bS>
  </equation>

  where <math|<bK><rsub|x>> is the input covariance matrix, <math|<bS>> is a
  positive semi-definite matrix, and \P<math|\<preceq\>>\Q denotes that
  <math|<bS>-<bK><rsub|x>> is positive semi-definite. Note
  that<nbsp>(<reference|hlp4>) is a rather general power constraint that
  subsumes many other important power constraints, including the average
  total and per-antenna power constraints as special cases. The approach
  developed in this paper will assume that <math|P<rsub|h>> and <math|<bS>>
  (or Tr<math|<around|(|<bS>|)>\<leq\>P<rsub|t>>) are fixed, and that power
  is not allocated jointly between the transmitter and helper. The numerical
  results presented later, however, will illustrate the trade-off associated
  with the power allocation when <math|P<rsub|h>+P<rsub|t>> is fixed.

  As mentioned before, we assume Gauusian signaling for the helper. Thus the
  effective noise at both receivers is Gaussian and consequently the above
  MIMO wiretap channel model is Gaussian. For this case, a Gaussian input
  signal is the optimal choice <cite|TLiu|RLiu>. Hence, the general
  optimization problem is equivalent to finding the matrices
  <math|<bK><rsub|x>\<succeq\>0> and <math|<bK><rsub|w>\<succeq\>0> that
  allow the secrecy capacity of the network to be obtained. A matrix
  characterization of this optimization problem is given by:

  <eqnarray|<tformat|<table|<row|<cell|<label|hlp5>C<rsub|s*e*c>>|<cell|=>|<cell|max<rsub|<bK><rsub|x>\<succeq\>0,<bK><rsub|w>\<succeq\>0><around|[|I<around|(|X<rsub|1>;Y<rsub|1>|)>-I<around|(|X<rsub|1>;Y<rsub|2>|)>|]>>>|<row|<cell|>|<cell|=>|<cell|max<rsub|<bK><rsub|x>\<succeq\>0,<bK><rsub|w>\<succeq\>0>
  log <around|\||<bK><rsub|x><bH><rsub|1><rsup|H><around|(|<bG><rsub|2><bK><rsub|w><bG><rsub|2><rsup|H>+<with|font-series|bold|I>|)><rsup|-1><bH><rsub|1>+<with|font-series|bold|I>|\|>>>|<row|<cell|>|<cell|>|<cell|<space|2em><space|2em><space|1em>-log
  <around|\||<bK><rsub|x><bG><rsub|1><rsup|H><around|(|<bH><rsub|2><bK><rsub|w><bH><rsub|2><rsup|H>+<with|font-series|bold|I>|)><rsup|-1><bG><rsub|1>+<with|font-series|bold|I>|\|><space|0.27em>,<eq-number>>>>>>

  where the non-convex maximization problem in carried out under the power
  constraints given in<nbsp>(<reference|hlp3>) and<nbsp>(<reference|hlp4>).
  <math|<next-line>> <with|font-series|bold|Lemma 1:> For a given
  <math|<bK><rsub|w>>, the maximum of (<reference|hlp5>) is given by

  <\equation>
    <label|hlp6>C<rsub|s*e*c><around|(|<bS>|)>=<big|sum><rsub|i=1><rsup|\<rho\>>log
    \<gamma\><rsub|i>
  </equation>

  where <math|\<gamma\><rsub|i>>, <math|i=1,\<cdots\>,\<rho\>>, are the
  generalized eigenvalues of the pencil

  <\equation>
    <label|hlp7><around|(|<bS><rsup|<frac|1|2>><bH><rsub|1><rsup|H><around|(|<bG><rsub|2><bK><rsub|w><bG><rsub|2><rsup|H>+<with|font-series|bold|I>|)><rsup|-1><bH><rsub|1><bS><rsup|<frac|1|2>>+<with|font-series|bold|I>,<space|1em><bS><rsup|<frac|1|2>><bG><rsub|1><rsup|H><around|(|<bH><rsub|2><bK><rsub|w><bH><rsub|2><rsup|H>+<with|font-series|bold|I>|)><rsup|-1><bG><rsub|1><bS><rsup|<frac|1|2>>+<with|font-series|bold|I>|)>
  </equation>

  that are greater than 1.<math|<next-line>> <with|font-series|bold|Proof:>
  When the optimization problem in (<reference|hlp5>) is performed over
  <math|<bK><rsub|x>> under the matrix power constraint (<reference|hlp4>)
  for a given <math|<bK><rsub|w>>, it is equivalent to a simple MIMO Gaussian
  wiretap channel without a helper, where the noise covariance matrices at
  the receiver and the eavesdropper are <math|<around|(|<bG><rsub|2><bK><rsub|w><bG><rsub|2><rsup|H>+<with|font-series|bold|I>|)>>
  and <math|<around|(|<bH><rsub|2><bK><rsub|w><bH><rsub|2><rsup|H>+<with|font-series|bold|I>|)>>,
  respectively. The above lemma is a natural extension of <cite|Bustin> and
  <cite-detail|RLiu|Theorem 3> for the standard MIMO Gaussian wiretap
  channel.

  Note that since both elements of the pencil<nbsp>(<reference|hlp7>) are
  strictly positive definite, all of the generalized eigenvalues are real and
  positive <cite|RLiu|Horn>. In<nbsp>(<reference|hlp6>), a total of
  <math|\<rho\>> of them are assumed to be greater than one. Clearly, if
  there are no such eigenvalues, then the information signal received at the
  intended receiver is a degraded version of that of the eavesdropper, and in
  this case the secrecy capacity is zero. Note also that Lemma<nbsp>1 only
  provides the secrecy capacity for the optimal <math|<bK><rsub|x>>, but does
  not give an explicit expression for this <math|<bK><rsub|x>>. A general
  expression for the maximizing <math|<bK><rsub|x>> will be given in the next
  section.

  To solve the general optimization problem in (<reference|hlp5>), we would
  need to find the <math|<bK><rsub|w>> that
  maximizes<nbsp>(<reference|hlp6>). Unfortunately, this appears to be a very
  difficult problem to solve without resorting to some type of
  <with|font-shape|italic|ad hoc> search. In the following we obtain a
  sub-optimal closed-form solution for the artificial noise covariance matrix
  <math|<bK><rsub|w>> that guarantees no decrease in the mutual information
  between the transmitter and the intended receiver compared with the case
  where <math|<bK><rsub|w>=<with|math-font-family|bf|0>>, while maintaining
  the power constraint in<nbsp>(<reference|hlp5>). Hence, the new non-zero
  <math|<bK><rsub|w>> will only interfere with the eavesdropper, and the
  secrecy level of the confidential message will be increased. Once such a
  <math|<bK><rsub|w>> is found, additional improvement in the secrecy rate
  can be achieved if the transmitter updates its covariance matrix
  <math|<bK><rsub|x>> for the obtained <math|<bK><rsub|w>>. The final secrecy
  rate for this method is obtained by simply
  computing<nbsp>(<reference|hlp6>) and<nbsp>(<reference|hlp7>) for the
  resulting <math|<bK><rsub|w>>. Note that we will not propose an iterative
  algorithm that would further alternate between calculating
  <math|<bK><rsub|x>> and <math|<bK><rsub|w>>. We will see in the next
  section that there is no clear way to update <math|<bK><rsub|w>> from a
  known non-zero value.

  <section|Analytical Method><label|analysis>

  We begin with the case where the helper transmits no signal
  <math|<around|(|<bK><rsub|w>=0|)>>. In this case, the communication system
  is reduced to a simple MIMO Gaussian wiretap channel without helper. Based
  on Lemma<nbsp>1, the maximum of (<reference|hlp5>) when
  <math|<bK><rsub|w>=0> is obtained by applying the generalized eigenvalue
  decomposition to the following two Hermitian positive definite matrices
  <cite|Bustin|RLiu>:

  <\equation*>
    <bS><rsup|<frac|1|2>><bH><rsub|1><rsup|H><bH><rsub|1><bS><rsup|<frac|1|2>>+<with|font-series|bold|I>,<space|1em><bS><rsup|<frac|1|2>><bG><rsub|1><rsup|H><bG><rsub|1><bS><rsup|<frac|1|2>>+<with|font-series|bold|I><space|0.27em>.
  </equation*>

  In particular, there exists an invertible generalized eigenvector matrix
  <math|<bC>> such that <cite|Horn>

  <\equation>
    <label|hlp8><bC><rsup|H><around*|[|<bS><rsup|<frac|1|2>><bG><rsub|1><rsup|H><bG><rsub|1><bS><rsup|<frac|1|2>>+<with|font-series|bold|I>|]><bC>=<with|font-series|bold|I>
  </equation>

  <\equation>
    <label|hlp9><bC><rsup|H><around*|[|<bS><rsup|<frac|1|2>><bH><rsub|1><rsup|H><bH><rsub|1><bS><rsup|<frac|1|2>>+<with|font-series|bold|I>|]><bC>=<with|math-font-family|bf|\<Lambda\>>
  </equation>

  where <math|<with|math-font-family|bf|\<Lambda\>>=<text|diag><around|{|\<lambda\><rsub|1>,...,\<lambda\><rsub|n<rsub|t>>|}>>
  is a positive definite diagonal matrix and
  <math|\<lambda\><rsub|1>,...,\<lambda\><rsub|n<rsub|t>>> represent the
  generalized eigenvalues. Without loss of generality, we assume the
  generalized eigenvalues are ordered as

  <\equation*>
    \<lambda\><rsub|1>\<geq\>...\<geq\>\<lambda\><rsub|b>\<gtr\>1\<geq\>\<lambda\><rsub|b+1>\<geq\>...\<geq\>\<lambda\><rsub|n<rsub|t>>\<gtr\>0
  </equation*>

  so that a total of <math|b> <math|<around|(|0\<leq\>b\<leq\>n<rsub|t>|)>>
  are assumed to be greater than 1. Hence, we can write
  <math|<with|math-font-family|bf|\<Lambda\>>> as

  <\equation>
    <label|hlp10><with|math-font-family|bf|\<Lambda\>>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|0>>|<row|<cell|0>|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|2>>>>>>|]>
  </equation>

  where <math|<with|math-font-family|bf|\<Lambda\>><rsub|1>=<text|diag><around|{|\<lambda\><rsub|1>,...,\<lambda\><rsub|b>|}>>
  and <math|<with|math-font-family|bf|\<Lambda\>><rsub|2>=<text|diag><around|{|\<lambda\><rsub|b+1>,...,\<lambda\><rsub|n<rsub|t>>|}>>.
  Also, we can write <math|<bC>> as

  <\equation>
    <label|hlp11><bC>=<around|[|<bC><rsub|1><space|1em><bC><rsub|2>|]>
  </equation>

  where <math|<bC><rsub|1>> is the <math|n<rsub|t>\<times\>b> submatrix
  representing the generalized eigenvectors corresponding to
  <math|<around|{|\<lambda\><rsub|1>,...,\<lambda\><rsub|b>|}>> and
  <math|<bC><rsub|2>> is the <math|n<rsub|t>\<times\><around|(|n<rsub|t>-b|)>>
  submatrix representing the generalized eigenvectors corresponding to
  <math|<around|{|\<lambda\><rsub|b+1>,...,\<lambda\><rsub|n<rsub|t>>|}>>.

  For the case of <math|<bK><rsub|w>=0>, the secrecy capacity of
  (<reference|hlp5>) under the matrix power constraint (<reference|hlp4>) is
  given by (Lemma 1 or <cite-detail|RLiu|Theorem 3>):

  <\equation>
    <label|cs>C<rsub|s*e*c>=<big|sum><rsub|i=1><rsup|b>log
    \<lambda\><rsub|i>=log <around|\||<with|math-font-family|bf|\<Lambda\>><rsub|1>|\|>
  </equation>

  and the input covariance matrix <math|<bK><rsub|x><rsup|\<ast\>>> that
  maximizes (<reference|hlp5>) is given by (<cite|Bustin|RLiu>):

  <\equation>
    <label|hlp12><bK><rsub|x><rsup|\<ast\>>=<bS><rsup|<frac|1|2>><bC><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>>|<cell|0>>|<row|<cell|0>|<cell|0>>>>>|]><bC><rsup|H><bS><rsup|<frac|1|2>><space|0.27em>.
  </equation>

  Note that<nbsp>(<reference|hlp12>) is a general expression for the
  <math|<bK><rsub|x>> that optimizes<nbsp>(<reference|hlp5>) for a given
  <math|<bK><rsub|w>> even when <math|<bK><rsub|w>\<ne\>0>, although in this
  case the <math|<bC>> will be the generalized eigenvector matrix of the
  pencil<nbsp>(<reference|hlp7>). From<nbsp>(<reference|hlp9>) we note that
  <math|<bH><rsub|1><rsup|H><bH><rsub|1>> can be written as

  <\equation>
    <label|hlp13><bH><rsub|1><rsup|H><bH><rsub|1>=<bS><rsup|-1/2><around*|[|<bC><rsup|-H><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|0>>|<row|<cell|0>|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|2>>>>>>|]><bC><rsup|-1>-<with|font-series|bold|I>|]><bS><rsup|-1/2><space|0.27em>.
  </equation>

  The following lemma gives the mutual information
  <math|I<around|(|X<rsub|1>;Y<rsub|1>|)>> between the transmitter and the
  intended receiver when <math|<bK><rsub|w>=0> and <math|<bK><rsub|x>> is
  given by (<reference|hlp12>).<math|<next-line>>
  <with|font-series|bold|Lemma 2:> The following equality holds:

  <\equation>
    <label|hlp14>I<around|(|X<rsub|1>;Y<rsub|1>|)>\|<rsub|<bK><rsub|w>=0,<bK><rsub|x>=<bK><rsub|x><rsup|\<ast\>>>=log
    <around*|\||<bK><rsub|x><rsup|\<ast\>><bH><rsub|1><rsup|H><bH><rsub|1>+<with|font-series|bold|I>|\|>=log
    <around*|\||<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>*<with|math-font-family|bf|\<Lambda\>><rsub|1>|\|><space|0.27em>.
  </equation>

  <with|font-series|bold|Proof:> Following the same steps as the proof of
  <cite-detail|Bustin|App. D> and using (<reference|hlp12>) and
  (<reference|hlp13>), we have

  <eqnarray|<tformat|<table|<row|<cell|<around*|\||<bK><rsub|x><rsup|\<ast\>><bH><rsub|1><rsup|H><bH><rsub|1>+<with|font-series|bold|I>|\|>>|<cell|=>|<cell|<around*|\||<bS><rsup|<frac|1|2>><bC><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>>|<cell|0>>|<row|<cell|0>|<cell|0>>>>>|]><bC><rsup|H>\<times\><around*|[|<bC><rsup|-H><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|0>>|<row|<cell|0>|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|2>>>>>>|]><bC><rsup|-1>-<with|font-series|bold|I>|]><bS><rsup|-1/2>+<with|font-series|bold|I>|\|>>>|<row|<cell|>|<cell|=>|<cell|<around*|\||<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>>|<cell|0>>|<row|<cell|0>|<cell|0>>>>>|]>\<times\><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|0>>|<row|<cell|0>|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|2>>>>>>|]>-<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>>|<cell|0>>|<row|<cell|0>|<cell|0>>>>>|]><bC><rsup|H><bC>+<with|font-series|bold|I>|\|><eq-number><label|hlp15>>>|<row|<cell|>|<cell|=>|<cell|<around*|\||<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>*<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|0>>|<row|<cell|0>|<cell|0>>>>>|]>-<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|font-series|bold|I>>|<cell|<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1><bC><rsub|1><rsup|H><bC><rsub|2>>>|<row|<cell|0>|<cell|0>>>>>|]>+<with|font-series|bold|I>|\|><eq-number><label|hlp16>>>|<row|<cell|>|<cell|=>|<cell|<around*|\||<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>*<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|-<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1><bC><rsub|1><rsup|H><bC><rsub|2>>>|<row|<cell|0>|<cell|<bI>>>>>>|]>|\|>>>|<row|<cell|>|<cell|=>|<cell|<around*|\||<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>*<with|math-font-family|bf|\<Lambda\>><rsub|1>|\|><eq-number><label|hlp17>>>>>>

  where (<reference|hlp15>) follows from the fact that
  <math|<around*|\||<bA><bB>+<bI>|\|>=<around*|\||<bB><bA>+<bI>|\|>>, and
  (<reference|hlp16>) follows since

  <\equation*>
    <bC><rsup|H><bC>=<around*|[|<bC><rsub|1><space|1em><bC><rsub|2>|]><rsup|H><around*|[|<bC><rsub|1><space|1em><bC><rsub|2>|]>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<bC><rsub|1><rsup|H><bC><rsub|1>>|<cell|<bC><rsub|1><rsup|H><bC><rsub|2>>>|<row|<cell|<bC><rsub|2><rsup|H><bC><rsub|1>>|<cell|<bC><rsub|2><rsup|H><bC><rsub|2>>>>>>|]><space|0.27em>.
  </equation*>

  We now return to the general optimization problem in (<reference|hlp5>)
  with non-zero <math|<bK><rsub|w>>. As the helper begins to broadcast
  artificial noise, both the mutual information between the transmitter and
  the intended receiver <math|I<around|(|X<rsub|1>;Y<rsub|1>|)>> and the
  mutual information between the transmitter and the eavesdropper
  <math|I<around|(|X<rsub|1>;Y<rsub|2>|)>> are in general decreased. Both of
  these functions are non-increasing in <math|<bK><rsub|w>> since

  <\equation*>
    <frac|<around*|\||<bA>+<bB>|\|>|<around*|\||<bB>|\|>>\<geq\><frac|<around*|\||<bA>+<bB>+<with|math-font-family|bf|<big|triangleup>>|\|>|<around*|\||<bB>+<with|math-font-family|bf|<big|triangleup>>|\|>>
  </equation*>

  when <math|<bA>>, <math|<with|math-font-family|bf|<big|triangleup>>\<succeq\>0>
  and <math|<bB>\<succ\>0> <cite|Weingarten>. A favorable choice for
  <math|<bK><rsub|w>> would be one that reduces
  <math|I<around|(|X<rsub|1>;Y<rsub|2>|)>> more than
  <math|I<around|(|X<rsub|1>;Y<rsub|1>|)>>. Since the optimal solution to
  (<reference|hlp5>) is intractable, we propose a suboptimal approach that
  introduces an additional constraint; namely, we search among those
  <math|<bK><rsub|w>> matrices that guarantee no decrease in the favorable
  term <math|I<around|(|X<rsub|1>;Y<rsub|1>|)>> while the power constraint
  (<reference|hlp3>) is satisfied. It should be noted that this approach is
  more general than the cooperative jamming schemes proposed in
  <cite|Han|Petropulu> for the MISO case where the jamming signal is nulled
  out at the destination. Clearly, such sub-optimal solutions are restricted
  to the case where there exists a null space between the helper and the
  intended receiver.

  In the following, we obtain an expression that represents all
  <math|<bK><rsub|w>\<succeq\>0> matrices with the power constraint
  Tr<math|<around|(|<bK><rsub|w>|)>=P<rsub|h>> that do not impact the mutual
  information between the transmitter and the intended receiver; i.e.,

  <\equation*>
    I<around|(|X<rsub|1>;Y<rsub|1>|)>\|<rsub|<bK><rsub|w>\<succeq\>0,<bK><rsub|x>=<bK><rsub|x><rsup|\<ast\>>>=I<around|(|X<rsub|1>;Y<rsub|1>|)>\|<rsub|<bK><rsub|w>=0,<bK><rsub|x>=<bK><rsub|x><rsup|\<ast\>>><space|0.27em>,
  </equation*>

  or from (<reference|hlp14>)

  <\equation>
    <label|hlp18>log <around*|\||<bK><rsub|x><rsup|\<ast\>><bH><rsub|1><rsup|H><around|(|<bG><rsub|2><bK><rsub|w><bG><rsub|2><rsup|H>+<bI>|)><rsup|-1><bH><rsub|1>+<bI>|\|>=log
    <around*|\||<bK><rsub|x><rsup|\<ast\>><bH><rsub|1><rsup|H><bH><rsub|1>+<bI>|\|>=log
    <around*|\||<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>*<with|math-font-family|bf|\<Lambda\>><rsub|1>|\|>.
  </equation>

  Note that, without loss of generality, we have used an equality power
  constraint Tr<math|<around|(|<bK><rsub|w>|)>=P<rsub|h>> since for the
  desired <math|<bK><rsub|w>> the best performance is in general obtained
  when helper transmits at maximum power.

  <with|font-series|bold|Theorem 1:> All <math|<bK><rsub|w>\<succeq\>0>
  matrices for which <math|log <around*|\||<bK><rsub|x><rsup|\<ast\>><bH><rsub|1><rsup|H><around|(|<bG><rsub|2><bK><rsub|w><bG><rsub|2><rsup|H>+<bI>|)><rsup|-1><bH><rsub|1>+<bI>|\|>=log
  <around*|\||<bK><rsub|x><rsup|\<ast\>><bH><rsub|1><rsup|H><bH><rsub|1>+<bI>|\|>=log
  <around*|\||<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>*<with|math-font-family|bf|\<Lambda\>><rsub|1>|\|>>
  satisfy the following relation:

  <\equation>
    <label|hlp19><bH><rsub|1><rsup|H><around|(|<bG><rsub|2><bK><rsub|w><bG><rsub|2><rsup|H>+<bI>|)><rsup|-1><bH><rsub|1>=<bS><rsup|-1/2><around*|[|<bC><rsup|-H><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|0>>|<row|<cell|0>|<cell|<bN>>>>>>|]><bC><rsup|-1>-<with|font-series|bold|I>|]><bS><rsup|-1/2>
  </equation>

  where

  <\equation>
    <label|hlp20><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|22>\<preceq\><bN>\<preceq\><with|math-font-family|bf|\<Lambda\>><rsub|2>>>|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|22>=<bC><rsub|2><rsup|H><bC><rsub|2>+<bC><rsub|2><rsup|H><bC><rsub|1><around|(|<with|math-font-family|bf|\<Lambda\>><rsub|1>-<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1><bC><rsub|1><rsup|H><bC><rsub|2>>>>>>
  </equation>

  and <math|<with|math-font-family|bf|\<Lambda\>><rsub|1>>,
  <math|<with|math-font-family|bf|\<Lambda\>><rsub|2>>, <math|<bC>>,
  <math|<bC><rsub|1>> and <math|<bC><rsub|2>> are defined in
  (<reference|hlp8>)-(<reference|hlp11>).

  <with|font-series|bold|Proof:> In Appendix A, using similar steps as those
  used to obtain (<reference|hlp17>), we show that all
  <math|<with|math-font-family|bf|\<Sigma\>>\<succeq\>0> matrices for which
  <math|log <around*|\||<bK><rsub|x><rsup|\<ast\>><with|math-font-family|bf|\<Sigma\>>+<bI>|\|>=log
  <around*|\||<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>*<with|math-font-family|bf|\<Lambda\>><rsub|1>|\|>>
  must have the following form

  <\equation>
    <label|hlp21><with|math-font-family|bf|\<Sigma\>>=<bS><rsup|-1/2><around*|[|<bC><rsup|-H><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|<bM>>>|<row|<cell|<bM><rsup|H>>|<cell|<bN>>>>>>|]><bC><rsup|-1>-<with|font-series|bold|I>|]><bS><rsup|-1/2><space|0.27em>.
  </equation>

  In the following, we obtain matrices <math|<bN>\<succeq\>0> and <math|<bM>>
  and complete the proof by considering the following specific choice for
  <math|<with|math-font-family|bf|\<Sigma\>>>:

  <\equation>
    <label|hlp22><with|math-font-family|bf|\<Sigma\>>=<bH><rsub|1><rsup|H><around|(|<bG><rsub|2><bK><rsub|w><bG><rsub|2><rsup|H>+<bI>|)><rsup|-1><bH><rsub|1><space|0.27em>.
  </equation>

  For the specific <math|<with|math-font-family|bf|\<Sigma\>>> in
  (<reference|hlp22>), it is evident that

  <\equation>
    <label|hlp23>0\<preceq\><with|math-font-family|bf|\<Sigma\>>\<preceq\><bH><rsub|1><rsup|H><bH><rsub|1>.
  </equation>

  By applying the constraint <math|<with|math-font-family|bf|\<Sigma\>>\<preceq\><bH><rsub|1><rsup|H><bH><rsub|1>>
  on (<reference|hlp21>) and using (<reference|hlp13>), it is enough to show
  that:

  <\equation*>
    <around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|<bM>>>|<row|<cell|<bM><rsup|H>>|<cell|<bN>>>>>>|]>\<preceq\><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|0>>|<row|<cell|0>|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|2>>>>>>|]>
  </equation*>

  or equivalently that

  <\equation*>
    <around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|-<bM>>>|<row|<cell|-<bM><rsup|H>>|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|2>-<bN>>>>>>|]>\<succeq\>0<space|0.27em>.
  </equation*>

  By applying the Schur Complement Lemma <cite|Horn>, the above relationship
  is true <em|iff> <math|<with|math-font-family|bf|\<Lambda\>><rsub|2>-<bN>\<succeq\>0>
  and <math|-<bM><around|(|<with|math-font-family|bf|\<Lambda\>><rsub|2>-<bN>|)><rsup|-1><bM><rsup|H>\<succeq\>0>,
  which in turn is true only when

  <eqnarray|<tformat|<table|<row|<cell|<bM>>|<cell|=>|<cell|0<eq-number><label|hlp24>>>|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|2>-<bN>>|<cell|\<succeq\>>|<cell|0<space|0.27em>.<eq-number><label|hlp25>>>>>>

  Applying the results of (<reference|hlp24>) and (<reference|hlp25>) in
  (<reference|hlp21>) for the specific choice of
  <math|<with|math-font-family|bf|\<Sigma\>>=<bH><rsub|1><rsup|H><around|(|<bG><rsub|2><bK><rsub|w><bG><rsub|2><rsup|H>+<bI>|)><rsup|-1><bH><rsub|1>>,
  we have:

  <\equation>
    <label|hlp26><with|math-font-family|bf|\<Sigma\>>=<bS><rsup|-1/2><around*|[|<bC><rsup|-H><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|0>>|<row|<cell|0>|<cell|<bN>>>>>>|]><bC><rsup|-1>-<with|font-series|bold|I>|]><bS><rsup|-1/2><space|0.27em>.
  </equation>

  Based on (<reference|hlp23>), we also need to show that
  <math|<with|math-font-family|bf|\<Sigma\>>\<succeq\>0>. From
  (<reference|hlp26>), it is enough to show that

  <\equation*>
    <around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|0>>|<row|<cell|0>|<cell|<bN>>>>>>|]>-<bC><rsup|H><bC>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>-<bC><rsub|1><rsup|H><bC><rsub|1>>|<cell|-<bC><rsub|1><rsup|H><bC><rsub|2>>>|<row|<cell|-<bC><rsub|2><rsup|H><bC><rsub|1>>|<cell|<bN>-<bC><rsub|2><rsup|H><bC><rsub|2>>>>>>|]>\<succeq\>0<space|0.27em>.
  </equation*>

  By applying the Schur Complement Lemma, the above relationship is true
  <em|iff> <math|<with|math-font-family|bf|\<Lambda\>><rsub|1>-<bC><rsub|1><rsup|H><bC><rsub|1>\<succeq\>0>
  and <math|<bN>-<bC><rsub|2><rsup|H><bC><rsub|2>-<bC><rsub|2><rsup|H><bC><rsub|1><around|(|<with|math-font-family|bf|\<Lambda\>><rsub|1>-<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1><bC><rsub|1><rsup|H><bC><rsub|2>\<succeq\>0>.
  Using Eqs. (<reference|hlp8>)-(<reference|hlp10>), it is evident that

  <\equation*>
    <with|math-font-family|bf|\<Lambda\>><rsub|1>-<bC><rsub|1><rsup|H><bC><rsub|1>=<bC><rsub|1><rsup|H><around*|[|<bS><rsup|<frac|1|2>><bH><rsub|1><rsup|H><bH><rsub|1><bS><rsup|<frac|1|2>>+<with|font-series|bold|I>|]><bC><rsub|1>-<bC><rsub|1><rsup|H><bC><rsub|1>=<bC><rsub|1><rsup|H><bS><rsup|<frac|1|2>><bH><rsub|1><rsup|H><bH><rsub|1><bS><rsup|<frac|1|2>><bC><rsub|1>\<succeq\>0
  </equation*>

  and finally the lower bound for <math|<bN>> is given by
  <math|<bN>\<succeq\><bC><rsub|2><rsup|H><bC><rsub|2>+<bC><rsub|2><rsup|H><bC><rsub|1><around|(|<with|math-font-family|bf|\<Lambda\>><rsub|1>-<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1><bC><rsub|1><rsup|H><bC><rsub|2>\<succ\>0<space|0.27em>>,
  which completes the proof.

  It should be noted that as <math|<bN>\<rightarrow\><with|math-font-family|bf|\<Lambda\>><rsub|22>>,
  we have Tr<math|<around|(|<bK><rsub|w>|)>\<rightarrow\>\<infty\>>.
  Moreover, Tr<math|<around|(|<bK><rsub|w>|)>=0> is achieved by
  <math|<bN>=<with|math-font-family|bf|\<Lambda\>><rsub|2>>. Hence, for each
  scalar <math|P<rsub|h>>, there always exists an <math|<bN>> in the range
  <math|<with|math-font-family|bf|\<Lambda\>><rsub|22>\<preceq\><bN>\<preceq\><with|math-font-family|bf|\<Lambda\>><rsub|2>>
  that will lead to a <math|<bK><rsub|w>> that satisfies (<reference|hlp19>)
  with Tr<math|<around|(|<bK><rsub|w>|)>=P<rsub|h>>.

  Thus far, we have not made any assumption on the number of antennas at each
  node. But it is clear from (<reference|hlp19>) that, for example when
  <math|<bG><rsub|2>> has more columns than rows, for a fixed <math|<bN>> in
  the acceptable range (<reference|hlp20>) there will be an infinite number
  of <math|<bK><rsub|w>> matrices that satisfy (<reference|hlp19>) and
  consequently do not decrease <math|I<around|(|X<rsub|1>;Y<rsub|1>|)>>. In
  fact, in this example, a common policy for the helper is to simply transmit
  artificial noise in the null space of <math|<bG><rsub|2>>. A more
  interesting case occurs when no such null space exists, i.e., when the
  number of antennas at the helper is less than or equal to that of the
  intended receiver (<math|n<rsub|h>\<leq\>n<rsub|r>>). The above result
  demonstrates the non-trivial fact that even when
  <math|n<rsub|h>\<leq\>n<rsub|r>>, it is possible to find a non-zero jamming
  signal that does not impact <math|I<around|(|X<rsub|1>;Y<rsub|1>|)>> even
  when the jamming signal can not be nulled by the channel. In the next
  section, we find more constructive expressions for the <math|<bK><rsub|w>>
  matrices that satisfy (<reference|hlp19>) for various combinations of the
  number of antennas at different nodes. In particular, we show that when
  <math|n<rsub|h>\<le\>n<rsub|r>>, a closed-form expression for
  <math|<bK><rsub|w>> can be found.

  <section|Results for Different Scenarios><label|scenarios>

  In this section, we consider all possible combinations of the number of
  antennas at the transmitter, helper and intended receiver, and obtain
  constructive methods for computing specific <math|<bK><rsub|w>> matrices
  that satisfy (<reference|hlp19>). Such <math|<bK><rsub|w>> will have no
  impact on <math|I<around|(|X<rsub|1>;Y<rsub|1>|)>>, but will in general
  decrease <math|I<around|(|X<rsub|1>;Y<rsub|2>|)>>, the mutual information
  between the transmitter and the eavesdropper, compared with the case that
  there is no helper. Hence, the secrecy level of the confidential message is
  increased. As mentioned before, additional improvement in the secrecy rate
  can be achieved if the transmitter updates its covariance matrix
  <math|<bK><rsub|x>> once <math|<bK><rsub|w>> is computed. Note, however,
  that such an iterative process will not be pursued beyond updating
  <math|<bK><rsub|x>>; unlike the first step, where <math|<bK><rsub|w>> was
  updated from its initial value of zero, there is no guarantee that finding
  a new <math|<bK><rsub|w>> will reduce <math|I<around|(|X<rsub|1>;Y<rsub|2>|)>>.
  Hence, the final secrecy rate for the proposed method is obtained by simply
  computing (<reference|hlp6>) and (<reference|hlp7>) for the resulting
  <math|<bK><rsub|w>> matrices derived in this section.

  <subsection|Case 1: <math|n<rsub|h>\<leq\>min
  <around|{|n<rsub|r>,n<rsub|t>|}>>><label|sec:num1>

  We show here that for the case where <math|n<rsub|h>\<leq\>min
  <around|{|n<rsub|r>,n<rsub|t>|}>> and for a fixed <math|<bN>> in the
  acceptable range (<reference|hlp20>), there is only one <math|<bK><rsub|w>>
  matrix that satisfies (<reference|hlp19>) and consequently does not
  decrease <math|I<around|(|X<rsub|1>;Y<rsub|1>|)>>. Using the matrix
  inversion lemma, Eq. (<reference|hlp19>) can be written as:

  <eqnarray|<tformat|<table|<row|<cell|<bH><rsub|1><rsup|H><around|(|<bG><rsub|2><bK><rsub|w><bG><rsub|2><rsup|H>+<bI>|)><rsup|-1><bH><rsub|1>>|<cell|=>|<cell|<bH><rsub|1><rsup|H><bH><rsub|1>-<bH><rsub|1><rsup|H><bG><rsub|2><around|(|<bG><rsub|2><rsup|H><bG><rsub|2>+<bK><rsub|w><rsup|-1>|)><rsup|-1><bG><rsub|2><rsup|H><bH><rsub|1>>>|<row|<cell|>|<cell|=>|<cell|<bS><rsup|-1/2><around*|[|<bC><rsup|-H><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>>|<cell|0>>|<row|<cell|0>|<cell|<bN>>>>>>|]><bC><rsup|-1>-<with|font-series|bold|I>|]><bS><rsup|-1/2><space|0.27em>.>>>>>

  Replacing <math|<bH><rsub|1><rsup|H><bH><rsub|1>> with (<reference|hlp13>),
  we have:

  <\equation>
    <label|hlp27><bH><rsub|1><rsup|H><bG><rsub|2><around|(|<bG><rsub|2><rsup|H><bG><rsub|2>+<bK><rsub|w><rsup|-1>|)><rsup|-1><bG><rsub|2><rsup|H><bH><rsub|1>=<bS><rsup|-1/2><bC><rsup|-H><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|2>-<bN>>>>>>|]><bC><rsup|-1><bS><rsup|-1/2><space|0.27em>.
  </equation>

  Since we have assumed that the channels are full rank, in the case of
  <math|n<rsub|h>\<leq\>n<rsub|r>\<leq\>n<rsub|t>> or
  <math|n<rsub|h>\<leq\>n<rsub|t>\<leq\>n<rsub|r>>, it is clear that
  rank<math|<around|(|<bG><rsub|2><rsup|H><bH><rsub|1>|)>=n<rsub|h>>. Thus,
  from (<reference|hlp27>) we have:

  <\equation>
    <label|hlp28><around|(|<bG><rsub|2><rsup|H><bG><rsub|2>+<bK><rsub|w><rsup|-1>|)><rsup|-1>=<bO><rsup|H><bS><rsup|-1/2><bC><rsup|-H><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|2>-<bN>>>>>>|]><bC><rsup|-1><bS><rsup|-1/2><bO>
  </equation>

  where <math|<bO>> is the right inverse of
  <math|<bG><rsub|2><rsup|H><bH><rsub|1>>, which, for example when
  <math|n<rsub|h>\<leq\>n<rsub|r>\<leq\>n<rsub|t>>, can be written as
  <math|<bO>=<bH><rsub|1><rsup|H><around|(|<bH><rsub|1><bH><rsub|1><rsup|H>|)><rsup|-1><bG><rsub|2><around|(|<bG><rsub|2><rsup|H><bG><rsub|2>|)><rsup|-1>>.
  The following lemma is a direct result of Eqs.<nbsp>(<reference|hlp27>) and
  (<reference|hlp28>).

  <with|font-series|bold|Lemma 3:> For the case of <math|n<rsub|h>\<leq\>min
  <around|{|n<rsub|r>,n<rsub|t>|}>> and for a fixed <math|<bN>> in the
  acceptable range (<reference|hlp20>), the <math|<bK><rsub|w>\<succeq\>0>
  matrix for which (<reference|hlp19>) is satisfied and
  <math|I<around|(|X<rsub|1>;Y<rsub|1>|)>> is not decreased is given by

  <\equation>
    <label|hlp29><bK><rsub|w>=<bQ>-<bQ><bG><rsub|2><rsup|H><around|(|<bG><rsub|2><bQ><bG><rsub|2><rsup|H>-<bI>|)><rsup|-1><bG><rsub|2><bQ>
  </equation>

  where <math|<bQ>> is the RHS of (<reference|hlp28>).

  <with|font-series|bold|Proof:> After applying the matrix inversion lemma on
  the LHS of (<reference|hlp28>), a straightforward computation yields
  (<reference|hlp29>).

  As is evident from Eqs. (<reference|hlp28>)-(<reference|hlp29>), we still
  have a design parameter, <math|<bN>>, that should be chosen in its
  acceptable range <math|<with|math-font-family|bf|\<Lambda\>><rsub|22>\<preceq\><bN>\<preceq\><with|math-font-family|bf|\<Lambda\>><rsub|2>>
  such that the power constraint Tr<math|<around|(|<bK><rsub|w>|)>=P<rsub|h>>
  is satisfied. Finding the optimal <math|<bN>> that minimizes
  <math|I<around|(|X<rsub|1>;Y<rsub|2>|)>> when <math|<bK><rsub|x>> and
  <math|<bK><rsub|w>> are given by (<reference|hlp12>) and
  (<reference|hlp29>), respectively, is as intractable as the general
  optimization problem in (<reference|hlp5>). Instead, we simply restrict the
  <math|<bN>> we consider to those that can be linearly parameterized within
  the acceptable range, as follows:

  <\equation>
    <label|hlp30><bN>=<with|math-font-family|bf|\<Lambda\>><rsub|22>+t*<around*|(|<with|math-font-family|bf|\<Lambda\>><rsub|2>-<with|math-font-family|bf|\<Lambda\>><rsub|22>|)><space|0.27em>.
  </equation>

  Consequently the term <math|<with|math-font-family|bf|\<Lambda\>><rsub|2>-<bN>>
  in Eq. (<reference|hlp29>) becomes

  <\equation*>
    <with|math-font-family|bf|\<Lambda\>><rsub|2>-<bN>=<around|(|1-t|)>*<around*|(|<with|math-font-family|bf|\<Lambda\>><rsub|2>-<with|math-font-family|bf|\<Lambda\>><rsub|22>|)>
  </equation*>

  where the scalar <math|0\<leq\>t\<leq\>1> is chosen such that the power
  constraint Tr<math|<around|(|<bK><rsub|w>|)>=P<rsub|h>> is satisfied. Note
  that as <math|t\<rightarrow\>0> <math|<around|(|<bN>\<rightarrow\><with|math-font-family|bf|\<Lambda\>><rsub|22>|)>>
  then Tr<math|<around|(|<bK><rsub|w>|)>\<rightarrow\>\<infty\>>, and as
  <math|t\<rightarrow\>1> <math|<around|(|<bN>\<rightarrow\><with|math-font-family|bf|\<Lambda\>><rsub|2>|)>>
  then Tr<math|<around|(|<bK><rsub|w>|)>\<rightarrow\>0>. Thus, we are
  guaranteed that an acceptable <math|<bN>> can be found in this way.

  <subsection|Case 2: <math|n<rsub|h>\<gtr\>min
  <around|{|n<rsub|r>,n<rsub|t>|}>>><label|sec:num2>

  As mentioned before, for the case of <math|n<rsub|h>\<gtr\>n<rsub|r>> and
  for a fixed <math|<bN>> in the acceptable range (<reference|hlp20>), there
  are many <math|<bK><rsub|w>> matrices that satisfy (<reference|hlp19>) and
  consequently do not decrease <math|I<around|(|X<rsub|1>;Y<rsub|1>|)>>. A
  common policy for the helper in this case is to transmit artificial noise
  in the null space of <math|<bG><rsub|2>>. However, as (<reference|hlp19>)
  shows, this policy is sufficient but it is not necessary. In other words,
  it is possible that the optimal <math|<bK><rsub|w>> satisfying
  (<reference|hlp19>) has elements outside the null space of
  <math|<bG><rsub|2>>. Because of the non-linear constraint in
  (<reference|hlp19>), finding the optimal <math|<bK><rsub|w>> is
  intractable. A similar discussion applies for the case of
  <math|n<rsub|t>\<less\>n<rsub|h>\<leq\>n<rsub|r>>.

  In this section, we present an approach for computing a suitable
  <math|<bK><rsub|w>>. Consider the following jamming signal covariance
  matrix:

  <\equation>
    <label|hlpext1><bK><rsub|w>=<with|math-font-family|bf|\<Gamma\>><space|0.17em><with|math-font-family|bf|\<Pi\>>*<space|0.17em><with|math-font-family|bf|\<Gamma\>><rsup|H><space|0.27em>,
  </equation>

  where <math|<with|math-font-family|bf|\<Pi\>>> is a <math|d\<times\>d>
  positive semidefinite matrix, and <math|<with|math-font-family|bf|\<Gamma\>>>
  is an <math|n<rsub|h>\<times\>d> matrix. For the case of
  <math|n<rsub|t>\<less\>n<rsub|h>\<leq\>n<rsub|r>> or
  <math|n<rsub|h>\<gtr\>n<rsub|r>>, we can choose
  <math|<with|math-font-family|bf|\<Gamma\>>> such that
  <math|<bG><rsub|2><space|0.17em><with|math-font-family|bf|\<Gamma\>>> is
  orthogonal to <math|<bH><rsub|1><space|0.17em><bK><rsub|x><rsup|\<ast\>><rsup|\<nosymbol\>>12>,
  i.e., <math|<bK><rsub|x><rsup|\<ast\>><rsup|\<nosymbol\>>12<bH><rsub|1><rsup|H><bG><rsub|2><space|0.17em><with|math-font-family|bf|\<Gamma\>>=<b>0>.
  For example, <math|<with|math-font-family|bf|\<Gamma\>>> can be chosen as
  the <math|d> right singular vectors in the nullspace of
  <math|<bK><rsub|x><rsup|\<ast\>><rsup|\<nosymbol\>>12<bH><rsub|1><rsup|H><bG><rsub|2>>.
  Since <math|<bK><rsub|x>> will often be rank deficient, the value of
  <math|d> will typically be larger than <math|n<rsub|h>-n<rsub|t>> for the
  case of <math|n<rsub|t>\<less\>n<rsub|h>\<leq\>n<rsub|r>>, and larger than
  <math|n<rsub|h>-n<rsub|r>> for the case of
  <math|n<rsub|h>\<gtr\>n<rsub|r>>. For this choice of
  <math|<with|math-font-family|bf|\<Gamma\>>>, the resulting
  <math|<bK><rsub|w>> in (<reference|hlpext1>) satisfies (<reference|hlp19>),
  and doesn't decrease <math|I<around|(|X<rsub|1>;Y<rsub|1>|)>> for
  <math|<bN>=<with|math-font-family|bf|\<Lambda\>><rsub|2>>, as is clear from
  (<reference|hlp19>). Given <math|<with|math-font-family|bf|\<Gamma\>>>, the
  choice of <math|<with|math-font-family|bf|\<Pi\>>> can be made to maximize
  the transfer of the \Pinformation\Q in the helper's jamming signal to the
  eavesdropper. In particular, note that at the eavesdropper, the covariance
  of the helper's jamming signal will be given by
  <math|<bH><rsub|2><with|math-font-family|bf|\<Gamma\>\<Pi\>\<Gamma\>><rsup|H><bH><rsub|2><rsup|H>>.
  If the eigenvalue decomposition of <math|<with|math-font-family|bf|\<Gamma\>><rsup|H><bH><rsub|2><rsup|H><bH><rsub|2><with|math-font-family|bf|\<Gamma\>>>
  is written as

  <\equation*>
    <with|math-font-family|bf|\<Gamma\>><rsup|H><bH><rsub|2><rsup|H><bH><rsub|2><with|math-font-family|bf|\<Gamma\>>=<bU><space|0.17em><bD><space|0.17em><bU><rsup|H>
  </equation*>

  with <math|<bU>> unitary and <math|<bD>> square and diagonal, then
  <math|<with|math-font-family|bf|\<Pi\>>> can be found via waterfilling;
  i.e.,

  <\equation*>
    <with|math-font-family|bf|\<Pi\>>=<bU><space|0.17em><with|math-font-family|bf|\<Delta\>><space|0.17em><bU><rsup|H><space|0.27em>,
  </equation*>

  where <math|<with|math-font-family|bf|\<Delta\>>=<around*|[|\<eta\><bI>-<bD><rsup|-1>|]><rsup|+>>,
  the operation <math|<around|[|<bA>|]><rsup|+>> zeros out any negative
  elements, and the water-filling level <math|\<eta\>> is chosen such that
  Tr<math|<around|(|<bK><rsub|w>|)>=<text|Tr><around|(|<with|math-font-family|bf|\<Delta\>>|)>=P<rsub|h>>.

  <section|Numerical Results><label|numrst>

  In this section, we present numerical results to illustrate our theoretical
  findings. In all of the following figures, channels are assumed to be
  quasi-static flat Rayleigh fading and independent of each other. The
  channel matrices <math|<bH><rsub|1>\<in\>\<bbb-C\><rsup|n<rsub|r>\<times\>n<rsub|t>>>
  and <math|<bG><rsub|2>\<in\>\<bbb-C\><rsup|n<rsub|r>\<times\>n<rsub|h>>>
  have i.i.d. entries distributed as <math|<with|math-font|cal|C*N><around|(|0,\<sigma\><rsub|d><rsup|2>|)>>,
  while <math|<bG><rsub|1>\<in\>\<bbb-C\><rsup|n<rsub|e>\<times\>n<rsub|t>>>
  and <math|<bH><rsub|2>\<in\>\<bbb-C\><rsup|n<rsub|e>\<times\>n<rsub|h>>>
  have i.i.d. entries distributed as <math|<with|math-font|cal|C*N><around|(|0,\<sigma\><rsub|c><rsup|2>|)>>.
  In each figure, values for the number of antennas at each node, as well as
  <math|\<sigma\><rsub|d><rsup|2>> and <math|\<sigma\><rsub|c><rsup|2>>, will
  be depicted. Unless otherwise indicated, results are calculated based on an
  average of at least 500 independent channel realizations.

  In the first example, Fig. 1, we randomly generate positive definite
  matrices <math|<bS>> such that Tr<math|<around|(|<bS>|)>\<leq\>P<rsub|t>>.
  For each <math|<bS>>, we compute the secrecy capacity of the MIMO Gaussian
  wiretap channel without helper (<math|<bK><rsub|w>=<b>0>) as given by
  (<reference|cs>). Next, using (<reference|hlp29>), we obtain a
  <math|<bK><rsub|w>> with the average power constraint
  Tr<math|<around|(|<bK><rsub|w>|)>=P<rsub|h>> that does not decrease
  <math|I<around|(|X<rsub|1>;Y<rsub|1>|)>>, and then update
  <math|<bK><rsub|x>> and compute <math|C<rsub|s*e*c><around|(|<bS>|)>>,
  using (<reference|hlp6>) and (<reference|hlp7>), accordingly. Fig. 1
  compares the secrecy capacity of the wiretap channel with (solid lines) and
  without (dotted lines) the helper. Note that the vertical difference
  between the solid curves (about 0.6 bps/channel use) represents the role of
  the transmit power <math|P<rsub|t>> on the secrecy capacity with helper
  when <math|P<rsub|t>> changes from 100 to 150 and <math|P<rsub|h>=20>. This
  relatively small difference indicates that, in this example,
  <math|P<rsub|t>> does not have a big impact on the secrecy capacity. Its
  role is even more negligible when <math|P<rsub|h>=0>, where only an
  increase of <math|0.3><nbsp>bps/channel use is obtained as <math|P<rsub|t>>
  increases from 100 to 150. The role of the helper on the other hand is
  significantly more important; increasing <math|P<rsub|h>> from 0 to 20
  while holding <math|P<rsub|t>> fixed results in an increase on the order of
  3<nbsp>bps/channel use. Furthermore, the use of the helper with a total
  power of only 120 (<math|P<rsub|t>=100,P<rsub|h>=20>) provides
  significantly better secrecy performance than not using the helper and
  transmitting with total power equal to 150
  (<math|P<rsub|t>=150,P<rsub|h>=0>).

  In the next examples, we calculate the secrecy capacity of the proposed
  algorithms under the assumption of an <with|font-shape|italic|average>
  power constraint <math|P<rsub|t>> at the transmitter, and under the
  constraint that the helper does not reduce the mutual information between
  the transmitter and receiver. While Eqs.<nbsp>(<reference|hlp6>)
  and<nbsp>(<reference|hlp7>) provide the performance for a specific
  <math|<bS>>, one must solve <cite|RLiu>, <cite-detail|Weingarten|Lemma 1>

  <\equation>
    <label|maxS>C<rsub|s*e*c><around|(|P<rsub|t>|)>=max<rsub|<bS>\<succeq\>0,<text|Tr><around|(|<bS>|)>\<le\>P<rsub|t>>
    C<rsub|s*e*c><around|(|<bS>|)>
  </equation>

  to find the secrecy capacity over all <math|<bS>> that satisfy the average
  power constraint. In the examples that follow, we perform a numerical
  search to solve<nbsp>(<reference|maxS>) and compute the secrecy capacity.

  Fig. 2 shows the secrecy capacity versus <math|P<rsub|h>> for a fixed total
  average power <math|P<rsub|t>+P<rsub|h>=110>. In this figure, we consider a
  situation in which <math|\<sigma\><rsub|c>\<gtr\>\<sigma\><rsub|d>>, or in
  other words where the channel between the transmitter and the intended
  receiver is weaker than the channel between the transmitter and the
  eavesdropper, and the channel between the helper and the intended receiver
  is weaker than the channel between the helper and the eavesdropper. The
  arrow in the figure shows the secrecy capacity without the helper
  <math|<around|(|P<rsub|h>=0|)>>. The figure shows that a helper with just a
  single antenna can provide a dramatic improvement in secrecy rate with very
  little power allocated to the jamming signal; in fact, the optimal rate is
  obtained when <math|P<rsub|h>> is less than 2% of the total available
  transmit power. If the number of antennas at the helper increases, a much
  higher secrecy rate can be obtained, but at the expense of allocating more
  power to the helper and less to the signal for the desired user.

  In Fig. 3, we consider a situation in which, unlike the above example, we
  have <math|\<sigma\><rsub|d>\<gtr\>\<sigma\><rsub|c>>. Thus, the intended
  receiver, in comparison with the eavesdropper, receives a weaker
  information signal and a stronger jamming signal than the eavesdropper. It
  might seem that in this situation, the helper cannot be very useful, but
  the figure shows that even in this case we can have a notable improvement
  in the secrecy rate (about 4<nbsp>bps/channel use) by increasing the number
  of antennas at the helper, and with an appropriate power assignment between
  the transmitter and the helper, without requiring extra total transmit
  power for the helper node.

  In Fig. 4, we consider a specific scenario where the secrecy capacity in
  the absence of the helper node is zero. While channel matrices
  <math|<bH><rsub|2>> and <math|<bG><rsub|2>> are generated randomly with
  i.i.d. entries distributed as <math|<with|math-font|cal|C*N><around|(|0,\<sigma\><rsub|c><rsup|2>|)>>
  and <math|<with|math-font|cal|C*N><around|(|0,\<sigma\><rsub|d><rsup|2>|)>>,
  respectively, we assume the following specific choices for
  <math|<bH><rsub|1>> and <math|<bG><rsub|1>>:

  <\equation*>
    <bH><rsub|1>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-0.25+0.5*i>|<cell|-0.35>|<cell|-1.25-0.9*i>>|<row|<cell|-0.4+0.1*i>|<cell|-0.2+0.75*i>|<cell|-i>>>>>|]>
  </equation*>

  <\equation*>
    <bG><rsub|1>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|2+0.25*i>|<cell|1.5+0.5*i>|<cell|2*i>>|<row|<cell|0.25+0.25*i>|<cell|-0.7+1.5*i>|<cell|0.5+0.33*i>>|<row|<cell|-1.5>|<cell|-0.5-i>|<cell|-2.9*i>>>>>|]>.
  </equation*>

  Since <math|<bH><rsub|1><rsup|H><bH><rsub|1>\<preceq\><bG><rsub|1><rsup|H><bG><rsub|1>>,
  all the generalized eigenvalues of the pencil

  <\equation*>
    <around*|(|<bS><rsup|<frac|1|2>><bH><rsub|1><rsup|H><bH><rsub|1><bS><rsup|<frac|1|2>>+<with|font-series|bold|I>|)>-\<gamma\>*<around*|(|<bS><rsup|<frac|1|2>><bG><rsub|1><rsup|H><bG><rsub|1><bS><rsup|<frac|1|2>>+<with|font-series|bold|I>|)>
  </equation*>

  are zero for all <math|<bS>\<succeq\>0> and consequently, the secrecy
  capacity without helper will be zero. In this example, we also assume that
  not only is the total power fixed at <math|P<rsub|t>+P<rsub|h>=110>, but
  also the total number of transmit antennas is fixed at
  <math|n<rsub|t>+n<rsub|h>=3>. As in the other examples, the secrecy rate of
  the wiretap channel is considerably improved with the helper. In this case,
  the best performance is obtained when the helper has only a single antenna.

  Finally, in Fig. 5, we consider the role of number of antennas at the
  helper, <math|n<rsub|h>>, in the secrecy rate for the specific matrix power
  constraint <math|<bS>=<frac|P<rsub|t>|n<rsub|t>><bI>>. Note that the
  solution of Section<nbsp><reference|sec:num1> applies for
  <math|n<rsub|h>\<leq\>3>, while the solution of
  Section<nbsp><reference|sec:num2> holds for <math|n<rsub|h>\<gtr\>3>. In
  all cases, we see that the secrecy rate increases considerably as
  <math|n<rsub|h>> increases.

  <section|Conclusions><label|conc>

  In this paper, we have studied the Gaussian MIMO Wiretap channel in the
  presence of an external jammer/helper, where the helper node assists the
  transmitter by sending artificial noise independent of the source message
  to confuse the eavesdropper. The jamming signal from the helper is not
  required to be decoded by the intended receiver and is treated as noise at
  both the intended receiver and the eavesdropper. We obtained a closed-form
  relationship for the structure of the helper's artificial noise covariance
  matrix that guarantees no decrease in the mutual information between the
  transmitter and the intended receiver. We showed how to find appropriate
  solutions within this covariance matrix framework that provide very good
  secrecy rate performance, even when there is no non-trivial null space
  between the helper and the intended receiver. The proposed scheme is shown
  to achieve a notable improvement in secrecy rate even for a fixed average
  total power and a fixed total number of antennas at the transmitter and the
  helper, without requiring extra power or antennas to be allocated to the
  helper node.

  <appendices>

  <section|>

  We are interested in finding a relationship that represents all matrices
  <math|<with|math-font-family|bf|\<Sigma\>>\<succ\>0> for which

  <\equation>
    <label|hlpap1>log <around*|\||<bK><rsub|x><rsup|\<ast\>><with|math-font-family|bf|\<Sigma\>>+<bI>|\|>=log
    <around*|\||<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>*<with|math-font-family|bf|\<Lambda\>><rsub|1>|\|><space|0.27em>,
  </equation>

  where

  <\equation>
    <label|hlpap2><bK><rsub|x><rsup|\<ast\>>=<bS><rsup|<frac|1|2>><bC><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>>|<cell|0>>|<row|<cell|0>|<cell|0>>>>>|]><bC><rsup|H><bS><rsup|<frac|1|2>><space|0.27em>.
  </equation>

  Using the fact that <math|<around|\||<bA><bB>+<bI>|\|>=<around|\||<bB><bA>+<bI>|\|>>,
  it is clear that <math|<with|math-font-family|bf|\<Sigma\>>> will have the
  form <math|<with|math-font-family|bf|\<Sigma\>>=<bS><rsup|-<frac|1|2>><bC><rsup|-H><bX><bC><rsup|-1><bS><rsup|-<frac|1|2>>>
  for some matrix <math|<bX>=<bX><rsup|H>>. Substituting this expression for
  <math|<with|math-font-family|bf|\<Sigma\>>> into<nbsp>(<reference|hlpap1>)
  results in the following equation that must be solved for <math|<bX>>:

  <\equation>
    <label|hlpap3>log <around*|\||<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>>|<cell|0>>|<row|<cell|0>|<cell|0>>>>>|]><bX>+<bI>|\|>=log
    <around*|\||<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>*<with|math-font-family|bf|\<Lambda\>><rsub|1>|\|><space|0.27em>.
  </equation>

  Write <math|<bX>> as <math|<bX>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<bX><rsub|1>>|<cell|<bX><rsub|2>>>|<row|<cell|<bX><rsub|2><rsup|H>>|<cell|<bX><rsub|3>>>>>>|]>>
  so that we have

  <\equation*>
    <around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1>>|<cell|0>>|<row|<cell|0>|<cell|0>>>>>|]><bX>+<bI>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1><bX><rsub|1>+<bI>>|<cell|<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1><bX><rsub|2>>>|<row|<cell|0>|<cell|<bI>>>>>>|]><space|0.27em>,
  </equation*>

  and note that the determinant of the above matrix is given by
  <math|<around*|\||<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)><rsup|-1><bX><rsub|1>+<bI>|\|>>.
  By comparing this result with (<reference|hlpap1>), we see that
  <math|<bX><rsub|1>=<with|math-font-family|bf|\<Lambda\>><rsub|1>-<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)>>.
  Consequently, we have:

  <\equation>
    <label|hlpap4><with|math-font-family|bf|\<Sigma\>>=<bS><rsup|-<frac|1|2>><bC><rsup|-H><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Lambda\>><rsub|1>-<around|(|<bC><rsub|1><rsup|H><bC><rsub|1>|)>>|<cell|<bX><rsub|2>>>|<row|<cell|<bX><rsub|2><rsup|H>>|<cell|<bX><rsub|3>>>>>>|]><bC><rsup|-1><bS><rsup|-<frac|1|2>>
  </equation>

  where <math|<bX><rsub|2>> and <math|<bX><rsub|3>> are still unknown and
  must be found as described in the text. It is clear that
  (<reference|hlpap4>) and (<reference|hlp21>) are equivalent.

  <thebibliography|1|<bibitem|Wyner>A.<nbsp>Wyner, \PThe wire-tap channel,\Q
  <em|Bell. Syst. Tech. J.>, vol. 54, no. 8, pp. 1355-1387, Jan.
  1975.<bibitem|GW1978>S.<nbsp>K.<nbsp>Leung-Yan-Cheong and
  M.<nbsp>E.<nbsp>Hellman, \PThe Gaussian wire-tap channel,\Q <em|IEEE Trans.
  Inf. Theory>, vol. 24, pp. 451-456, Jul.
  1978.<bibitem|Hassibi>F.<nbsp>Oggier and B.<nbsp>Hassibi, \PThe secrecy
  capacity of the MIMO wiretap channel,\Q in <em|Proc. IEEE Int. Symp.
  Information Theory> Toronto, ON, Canada, Jul. 2008, pp.
  524-528.<bibitem|KhistiMIMO>A.<nbsp>Khisti and G.<nbsp>Wornell, \PSecure
  transmission with multiple antennas II: The MIMOME wiretap channel,\Q to
  appear, <em|IEEE Trans. Inf. Theory>, 2010. Available at:
  http://allegro.mit.edu/pubs/posted/journal/2008-khisti-wornell-it.pdf<bibitem|ours>S.
  Ali. A. Fakoorian and A. L. Swindlehurst, \POptimal power allocation for
  the GSVD based MIMO Gaussian wiretap channel,\Q submitted to <em|IEEE
  Trans. Inf. Theory>, Available: http://arxiv.org/abs/1006.1890<bibitem|TLiu>T.<nbsp>Liu
  and S.<nbsp>Shamai (Shitz), \PA note on secrecy capacity of the
  multi-antenna wiretap channel,\Q <em|IEEE Trans. Inf. Theory>, vol. 55, no.
  6, pp. 2547-2553, 2009.<bibitem|Bustin>R.<nbsp>Bustin, R.<nbsp>Liu,
  H.<nbsp>V.<nbsp>Poor, and S.<nbsp>Shamai (Shitz), \PA MMSE approach to the
  secrecy capacity of the MIMO Gaussian wiretap channel,\Q <em|EURASIP
  Journal on Wireless Communications and Networking>, vol. 2009, Article ID
  370970, 8 pages, 2009.<bibitem|Csiszar>I.<nbsp>Csiszar and J.<nbsp>Korner,
  \PBroadcast channels with confidential messages,\Q <em|IEEE Trans. Inf.
  Theory>, vol. 24, pp. 339-348, May 1978.<bibitem|Tekin>E. Tekin and A.
  Yener, \PThe general Gaussian multiple access and two-way wire-tap
  channels: Achievable rates and cooperative jamming,\Q <em|IEEE Trans. Inf.
  Theory>, vol. 54, no. 6, pp. 27352751, Jun.
  2008.<bibitem|Han>L.<nbsp>Dong, Z.<nbsp>Han, A.<nbsp>P.<nbsp>Petropulu, H.
  V. Poor, \PCooperative jamming for wireless physical layer security", in
  Proc. of <em|IEEE Workshop on Statistical Signal Processing>, Cardiff,
  Wales, U.K. 2009<bibitem|Petropulu>L. Dong, Z. Han, A. P. Petropulu, and H.
  V. Poor, \PImproving wireless physical layer security via cooperating
  relays,\Q <em|IEEE Trans. Signal Proc.>, vol. 58, NO. 3, pp. 1875-1888,
  Mar. 2010.<bibitem|Gamal>L. Lai and H. El Gamal, \PThe relay-eavesdropper
  channel: Cooperation for secrecy,\Q <em|IEEE Trans. Inf. Theory>, vol. 54,
  no. 9, pp. 40054019, Sep. 2008.<bibitem|IFCHlp>X. Tang, R. Liu, P.
  Spasojevic, and H. V. Poor, \PThe Gaussian wiretap channel with a helping
  interferer,\Q in <em|Proc. IEEE Int. Symp. Inf. Theory>, Toronto, ON,
  Canada, Jul. 2008.<bibitem|WangS>J.<nbsp>Wang and A.<nbsp>Swindlehurst,
  \PCooperative jamming in MIMO ad hoc networks,\Q in <em|Proc. Asilomar
  Conf. on Signals, Systems and Computers>, pp. 1719-1723, Nov.,
  2009.<bibitem|Laneman>E. MolavianJazi, M. Bloch, and J. N. Laneman,
  \PArbitrary jamming can preclude secure communication,\Q in <em|Proc.
  Allerton Conf.> Communications, Control, and Computing, Monticello, IL,
  Sept. 2009.<bibitem|GoelN08>S. Goel and R. Negi, \PGuaranteeing secrecy
  using artificial noise," <em|IEEE Trans. Wireless Commun>., vol. 7, no. 6,
  pp. 2180-2189, June 2008.<bibitem|RLiu>Ruoheng Liu, Tie Liu,
  H.<nbsp>Vincent Poor, and Shlomo Shamai (Shitz), \PMultiple-input
  multiple-output Gaussian broadcast channels with confidential messages,\Q
  <em|IEEE Trans. Inf. Theory>, to appear.<bibitem|Horn>R. A. Horn and C. R.
  Johnson, <em|Matrix Analysis>, University Press, Cambridge, UK,
  1985.<bibitem|Heath>S. W. Peters and R. W. Heath, Jr., \PInterference
  alignment via alternating minimization,\Q in Proc. of <em|IEEE ICASSP>,
  April 2009, Taiwan.<bibitem|Weingarten>H.<nbsp>Weingarten,
  Y.<nbsp>Steinberg, and S.<nbsp>Shamai (Shitz), \PThe capacity region of the
  Gaussian multiple-input multiple-output broadcast channel,\Q <em|IEEE
  Trans. Inf. Theory>, vol. 52, no. 9, pp. 3936-3964, 2006>

  <\big-figure>
    <image|1.eps|3.5in|3.5in||>

    <label|fig>
  </big-figure|Comparison of secrecy capacity for MIMO Gaussian wiretap
  channel with and without helper for different <math|P<rsub|t>> and
  <math|P<rsub|h>>.>

  <\big-figure>
    <image|2.eps|3.5in|3.5in||>

    <label|fig>
  </big-figure|Comparison of the secrecy capacity for the MIMO Gaussian
  wiretap channel with and without a helper versus <math|P<rsub|h>> for
  different number of antennas at the helper, <math|P<rsub|t>+P<rsub|h>=110>,
  assuming the eavesdropper's channels are stronger than those of the
  receiver (<math|\<sigma\><rsub|d><rsup|2>=1,\<sigma\><rsub|c><rsup|2>=5>).>

  <\big-figure>
    <image|3.eps|3.5in|3.5in||>

    <label|fig>
  </big-figure|Comparison of the secrecy capacity for the MIMO Gaussian
  wiretap channel with and without a helper versus <math|P<rsub|h>> for
  different number of antennas at the helper, <math|P<rsub|t>+P<rsub|h>=110>,
  assuming the receiver's channels are stronger than those of the
  eavesdropper (<math|\<sigma\><rsub|d><rsup|2>=2,\<sigma\><rsub|c><rsup|2>=1>).>

  <\big-figure>
    <image|4.eps|3.5in|3.5in||>

    <label|fig>
  </big-figure|Comparison of the secrecy capacity for the MIMO Gaussian
  wiretap channel with and without a helper versus <math|P<rsub|h>> for
  different number of antennas at the helper, <math|P<rsub|t>+P<rsub|h>=110>,
  and <math|n<rsub|t>+n<rsub|h>=3>.>

  <\big-figure>
    <image|5.eps|3.5in|3.5in||>

    <label|fig>
  </big-figure|Secrecy data rate versus <math|n<rsub|h>> for a specific
  matrix power constraint <math|<bS>=<frac|P<rsub|t>|n<rsub|t>><bI>>.>
</body>