<TeXmacs|1.99.7>

<style|<tuple|ieeetran|std-latex>>

<\body>
  <\hide-preamble>
    <assign|baselinestretch|<macro|1.0>>
  </hide-preamble>

  <doc-data|<doc-title|High-rate Space-Time-Frequency Codes Achieving
  Full-Diversity with Partial Interference Cancellation Group
  Decoding>|<doc-author|<author-data|<author-misc|Moon Ho Lee is with the
  Institute of Information and Communication, Chonbuk National University,
  Chonju 561-756, Korea. (e-mail:moonho@chonbuk.ac.kr).>|<author-misc|Ying
  Guo is with School of Information Science and Engineering, Central South
  University, Changsha, 410083, China. (e-mail:sdguoying@gmail.com).>|<author-name|Moon
  Ho Lee, <nbsp><IEEEmembership|Senior Member, IEEE> and Ying
  Guo>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    The partial interference cancellation (PIC) group decoding has recently
    been proposed to deal with the decoding complexity and code rate
    trade-off on the basis of space-time block code (STBC) design criterion
    when full diversity is achieved. It provides a framework to arrange the
    rate-complexity-performance tradeoff by choosing a suitable size of
    information symbol groups. In this paper, a simple design of a linear
    dispersive space-time-frequency (STF) code is proposed with a design
    criterion to achieve high rate for frequency-selective channels in terms
    of multipath when the PIC group decoding is applied at receiver. With an
    appropriate grouping scheme as well as the PIC group decoding, the
    proposed STF code is shown to obtain the similar diversity gain as the
    maximum likelihood (ML) decoding, namely full-dimensional sphere
    decoding, but have a low decoding complexity. It seems as an intermediate
    decoding between the ML receiver and zero-forcing (ZF) receiver. The
    proposed grouping design criterion for the PIC group decoding to achieve
    full diversity deploying the orthogonal-frequency-division multiplexing
    (OFDM) technique is also an intermediate condition between the loosest ML
    full rank criterion of codewords and the strongest ZF linear independence
    condition of the column vectors for the equivalent frequency-selective
    channel matrix. It can achieves full diversity with the PIC group
    decoding for any number of sub-carriers and the data rate can be made
    high. Several code design examples are illustrated for the feasibility of
    this coding scheme. Simulation results show that the proposed STF code
    can well address the rate-performance-complexity tradeoff of the
    multiple-input multiple-output orthogonal frequency division multiplexing
    (MIMO-OFDM) communication system.
  </abstract>>

  <section|Introduction>

  The next generation wireless communication systems are expected to support
  high-data-rate transmissions with high-quality services. The harsh wireless
  channels, including time-selective and frequency-selective fading channels,
  along with limited spectrum resources, have become dominating challenges
  for future wireless communication networks. To address these challenges,
  various remarkable breakthroughs in wireless communication networks have
  been witnessed in last decades. The multiple-input multiple-output (MIMO)
  technique has ever been viewed as one of great breakthrough solutions to
  increase the channel capacity, communication reliability and spectrum
  efficiency of wireless networks without requiring additional bandwidth. The
  eminent merits of MIMO system lie in its potential temporal diversity gain,
  spatial diversity gain and multiplexing gain to enhance link reliability.
  This elegant technique can be further exploited to explore the potential
  spatial and temporal diversity on flat-fading or frequency-selective
  channels with some proper transmission schemes, such as space-time (ST)
  coding <cite|Alamouti99|Tarokh991|Tarokh04|Xia09>, space-frequency (SF)
  coding <cite|Zhang04|Gong04|Su04|Su05|Zhang05|Zhang07>, and
  space-time-frequency (STF) coding <cite|Gong526|GongLiu|Wang26|GSu526|Xia526>.
  It is shown that the coding gain and diversity can be simultaneously
  achieved with suitable coding schemes. Unfortunately, as the number of
  transmit antennas becomes large, the complexity of decoding increases,
  which makes the design of coding or modulating schemes difficult. When the
  channel state information (CSI) is available at the receiver, the full rank
  design criterion can be derived to achieve maximum diversity with the ML
  decoding. However, while achieving maximum diversity gain, the transmission
  rate may be reduced and the computational complexity of the ML receiver
  grows exponentially. Even though the quasi-orthogonal ST codes, SF/STF
  codes can support a higher transmission rate than orthogonal codes
  <cite|Tarokh991>, the diversity gain is not still made much large as a
  desirable outcome. It makes the ML decoding difficult for these codes while
  a great deal of information symbols are embedded in.

  To solve the afore-mentioned problem of reducing the decoding complexity
  with a high rate, one may decode each symbol separately by placing a filter
  at the receiver to strength the main symbol while suppressing the
  interference symbols. One decoding approach called ZF decoding is designed
  to completely eliminate the interference symbols. Another is minimum mean
  square error (MMSE) decoding. The above decoding criterions based on ST
  coding or SF/STF coding design have attracted considerable attentions
  recently because they exploit gains of the efficiency and reliability of
  signal transmissions over MIMO systems with low-complexity receivers. The
  Alamouti code <cite|Alamouti99> has the orthogonality structure so that it
  ensures symbol-by-symbol decoding equivalent to the ML decoding. The
  Toeplitz code <cite|Zhang5> was proposed to achieve full diversity and high
  rate with the ZF receiver. After that, The overlapped Alamouti code was
  proposed achieving full diversity with ZF or MMSE receivers
  <cite|Shang5|Shang51|Shang52>. It is shown that for any orthogonal ST code,
  its ZF receiver has the similar performance as the ML receiver.
  Unfortunately, the rate of the linear receivers based on ST or SF codes is
  always upper bounded by one. To address the complexity and rate tradeoff, a
  partial interference cancellation (PIC) group decoding was proposed with
  the derived design criterion for ST codes <cite|Xia09>. In essence, the PIC
  group decoding can be viewed as an intermediate decoding between the ML
  decoding and ZF decoding. A similar decoding algorithm as the PIC group
  decoding was suggested for the layered ST codes <cite|Dai04>. After that, a
  systematic design of ST codes achieving full diversity with PIC group
  decoding was proposed for flat-fading channels <cite|Zhang52>. The decoding
  complexity of the ST coding design is equivalent to the ML decoding
  complexity of multiple symbols. Unfortunately, the design of SF/STF codes
  achieving full diversity with PIC group decoding over frequency-selective
  channels still faces a challenge to handle the rate-performance-complexity
  tradeoff for MIMO-OFDM systems.

  Recently, the OFDM technology has been recognized as one of the most
  efficient and effective techniques to deal with frequency-selective fading
  channels while achieving high speed data transmissions in broadband
  wireless networks. The increasing attraction of the OFDM technology is
  mainly due to how the system handles the multipath interferences at the
  receiver with practical implementation because of availability of the
  digital signal processor that makes the fast FFT affordable
  <cite|Bingham5>. Its main idea is to split the high rate data stream into
  several lower rate streams and modulate them over a number of subcarriers.
  This technique provides a number of frequency-flat subcarriers within
  frequency-selective channels. In an OFDM scheme, a large number of
  orthogonal, overlapping, narrow-band subcarriers divide the available
  transmission bandwidth, which results in facile resource allocation
  <cite|Letaief99>. Due to its simple implementation via the fast FFT, the
  OFDM technology has been widely adopted as a main physical layer solution
  in broadband access. In the light of superiority of the MIMO and OFDM
  techniques, the MIMO-OFDM technique is being pursued as a promising
  candidate for high data rate broadband wireless networks
  <cite|Wang52|Lu52|Lu521|Lu522|Lu523|Lu524|Lu525|Lu526>. A systematic method
  for exploiting the available multipath or frequency diversity results in
  the rapid development of SF/STF codes for MIMO-OFDM systems. The first SF
  coding design criteria was presented in <cite|Wang52>. This code makes full
  use of two dimensions of antennas and subcarriers to achieve a maximum
  diversity while the STF code exploits three dimensions of time, antennas
  and subcarriers to achieve an additional temporal diversity advantage
  superior to space and multipath diversity gain.

  To exploit the spatial diversity gain provided by multiple antennas at
  transmitters and receivers, a great deal of SF coding schemes have been
  proposed for MIMO-OFDM systems <cite|Zhang04|Gong04|Su04|Su05|Zhang05|Zhang07>.
  Consequently, several full-diversity SF codes have since been designed
  using linearly transformed data <cite|Wang52|Lu52|Lu521|Lu522|Lu523|Lu524|Lu525|Lu526>.
  An SF coding scheme with transmission of cyclically shifted data from
  multi-antennas was suggested to achieve full diversity and optimal coding
  gain for sampled channels <cite|Lu524>. However, its performance is not
  ensured to be optimal for such channels with arbitrary delay profiles. Then
  a particular SF coding design criterion was proposed on the basis of the
  available diversity without considering the effect of delay profiles for
  the sampled channels <cite|Lu525>. Furthermore, the full rate SF codes were
  investigated for frequency selective channels under the assumption of the
  perfect knowledge of delay profile at the transmitter <cite|Lu521>.
  Recently, the SF codes asymptotically achieving the Gilbert-Varshamov bound
  have been investigated <cite|Liu526>. These codes can obtain a target
  diversity gain but the decoding complexities grow exponentially with the
  desired diversity. Therefore, how to address the rate-diversity-complexity
  tradeoff of the SF coding schemes for frequency-selective channels is still
  a retained problem.

  It is known an SF code can achieve link-reliability within only one OFDM
  block. However, the temporal dimension may also be exploited for multiple
  OFDM blocks. This leads to the STF code that can achieve the maximum
  diversity gain over MIMO-OFDM system. The first STF code was proposed for
  two antennas <cite|Gong526> and then developed <cite|GongLiu|Wang26>. For
  these STF codes, all channels were assumed to be constant. However, for
  constant channels they do not offer any temporal diversity, and performance
  gains are always obtained at a high complexity. In <cite|GSu526>, a
  performance criteria for the STF code was derived with the ML decoding.
  However, the maximization coding gain was not considered. In the recent
  work <cite|Xia526>, a high rate STF code has been presented, but it was not
  optimized in terms of coding gain. Late on, a quasi-orthogonal STF code was
  proposed with the reduced ML decoding complexity to improve the symbol rate
  at the tradeoff of the high decoding complexity. Because of this partial
  orthogonal structure, the quasi-orthogonal STF code can be decoded with the
  ML pair-by-pair complex symbols, which has a higher decoding complexity
  compared to the orthogonal STF code. As will be shown later in this paper,
  the afore-mentioned decoding is a special case of the PIC group decoding
  which is an intermediate decoding between the ML decoding and ZF (or MMSE)
  decoding. The design of SF/STF codes achieving full diversity with PIC
  group decoding can handle the well rate-performance-complexity tradeoff for
  MIMO-OFDM systems.

  The following characteristics are summarized for some existing SF/STF
  coding schemes.

  <\enumerate>
    <item>The complexity of a decoder is largely independent of number of
    subcarriers and receive antennas. It guarantees full diversity for an
    arbitrary number of transmit antennas with any memoryless modulation
    approaches in terms of the ML receiver or ZF/MMSE receiver;

    <item>They have ability to exploit the spatial, frequency and even
    temporal diversity without any information of channel at transmitter.

    <item>The design coding approach offers a high transmission rate
    achieving full-diversity and optimal-coding gain without considering the
    decoding complexity of the receiver.
  </enumerate>

  The above viewpoints propel us to design such SF/STF coding schemes with
  the linear receiver. Towards this end, the specific coding schemes
  <cite|Xia09|Zhang52> raise several problems, which also serve as a
  motivation for our present work.

  <\enumerate>
    <item>Are there other SF/STF codes exploiting full-diversity with high
    rate for frequency-selective channels? If so, how do such codes compare
    with the existing SF/STF codes in terms of the pairwise error probability
    (PEP) performance and decoding-complexity?

    <item>When perfect channel information is not available at the
    transmitter, can a full-diversity SF/STF code having a high-coding gain
    be designed with a low-complexity receiver?
  </enumerate>

  These problems actuate us to explore the design of SF/STF codes achieving
  full-diversity with the PIC group decoding for frequency-selective
  channels.

  In this paper, we address the afore-mentioned problems by deriving a family
  of SF/STF codes with the PIC group decoding which can simultaneously
  achieve high transmission rate, full diversity and low-complexity decoding.
  The main contributions of this paper can be summarized as follows.

  <\itemize>
    <item>A simple SF/STF coding scheme is explicitly designed on the basis
    of the PIC group decoding for a family of linear dispersion codes. We
    provide a unified PIC decoding structure that decodes the information
    symbols embedded in SF/STF codes while dividing them into several
    suitable groups and decoding each group separately via a linear PIC
    operation. It can be viewed as an intermediate decoding between the ML
    decoding and ZF decoding. The PIC group decoding for frequency-selective
    channels provides a framework to adjust the complexity-performance
    tradeoff by choosing suitable sizes of information symbol groups
    corresponding to its equivalent channel matrix.

    <item>A design criteria for the SF/STF code achieving full diversity is
    established. The proposed design criterion is an intermediate criterion
    between the ML full rank criterion of codewords and the ZF linear
    independence criterion of column vectors in the equivalent channel
    matrix. It therefore provides a pretty rate-performance-complexity
    tradeoff. We pursue such a unified approach for the design of the SF/STF
    codes where the SF code can be regarded as a special case of the STF
    code. Also, we illustrate the value of the STF code design while taking
    the multi-block quality into account.

    <item>A problem of the SF/STF code structure is addressed for MIMO-OFDM
    systems. We suggest a systematic approach for the design of
    full-diversity SF/STF codes with the PIC group decoding. These codes are
    designed with the multiple-diagonal-layer structure and thus achieve full
    diversity with high transmission rate, but have low-complexity decoding.

    <item>Motivated from the conditional detection
    <cite|Sezginer526|Sirianunpiboonr526>, we suggest a conditional PIC group
    decoding concept for the SF/STF code that can not satisfy the
    conventional PIC group decoding criteria, but can be similarly decoded
    with low complexity. For the conditional PIC group decoding, we select
    each trial of a fixed group of information symbols, and then decode the
    remaining symbols with the conventional PIC group decoding. The final
    decoding results are the optimal solution among all trials of the fixed
    group of symbols with the ML decoding. Consequently, we obtain another
    design criterion for the SF/STF code with high rate that achieves the
    similar full diversity as that of the PIC group decoding.
  </itemize>

  This paper is organized as follows. In Section II, we describe the channel
  model and system model for MIMO-OFDM systems with the PIC group decoding.
  In Section III, we systematically study the diversity property of the
  SF/STF codes with the PIC group decoding, and derive the design criterion
  for the SF/STF codes. In Section VI, we present several design examples to
  illustrate the feasibility of the STF coding design criteria with some
  simulation results. Finally, conclusions are drawn in Section V.

  Some notations are defined throughout this paper as follows:

  <\itemize>
    <item><math|\<bbb-C\>>: complex number field;

    <item><math|\<cal-A\>>: a signal constellation;

    <item><math|<math-up|tr>>: trace of a matrix;

    <item>Bold faced upper-case letters, such as <math|<math-bf|A>>:
    matrices;

    <item>Bold faced lower-case letters, such as <math|<math-bf|a>>: column
    vectors;

    <item>Superscripts <math|<around|(|\<cdummy\>|)><rsup|<mathrm>>*T>,
    <math|<around|(|\<cdummy\>|)><rsup|<mathrm>>*H>, and
    <math|<around|(|\<cdummy\>|)><rsup|\<ast\>>>: transpose, complex
    conjugate transpose, complex conjugate, respectively;

    <item><math|\<\|\|\>\<cdot\>\<\|\|\><rsub|<mathrm>>F>: Frobenius norm of
    a matrix;

    <item><math|E<around|[|x|]>>: expectation of variable <math|x>;

    <item><math|\<otimes\>>: the Kronecker product;

    <item><math|<math-bf|I><rsub|n>>: identity matrix of size
    <math|n\<times\>n>;

    <item><math|<math-up|diag><around|(|<math-bf|d><rsub|0><nbsp>\<cdots\><nbsp><math-bf|d><rsub|N-1>|)>>:
    a diagonal matrix with diagonal entries
    <math|<math-bf|d><rsub|0><nbsp>\<cdots\><nbsp><math-bf|d><rsub|N-1>>.
  </itemize>

  <section|MIMO-OFDM System and PIC Group Decoding over Block-Fading
  Channels>

  <subsection|Channel Model>

  We consider an MIMO-OFDM system with <math|M<rsub|t>> transmit antennas,
  <math|M<rsub|r>> receive antennas. Each transmit antenna deploys an OFDM
  modulator with <math|N> sub-carriers. Suppose that the receiver has perfect
  channel knowledge but no knowledge at the transmitter since training
  sequences are typically available. The MIMO channels experience block
  frequency-selective fading simultaneously induced by <math|L> independent
  channel taps between each pair of transmit and receive antennas. The path
  gains between each pair of transmit and receive antennas are constant over
  each fading block period, but may be independent from one fading block to
  another. Each OFDM symbol is transmitted during only one fading block. The
  channel impulse response from transmit antenna <math|i> to receive antenna
  <math|j> during the <math|k<rsup|t*h>> fading block is given by

  <eqnarray|<tformat|<table|<row|<cell|h<rsub|i,j><rsup|k><around|(|\<tau\>|)>=<big|sum><rsub|l=0><rsup|L-1>\<alpha\><rsub|i,j><rsup|k><around|(|l|)>*\<delta\>*<around|(|\<tau\>-\<tau\><rsub|l>|)>,<eq-number><label|Channel1>>>>>>

  where <math|\<tau\><rsub|l>> is the delay of the <math|l<rsup|t*h>> channel
  tap, and <math|\<alpha\><rsub|i,j><rsup|k><around|(|l|)>> denotes the
  complex amplitude of the <math|l<rsup|t*h>> channel tap from transmit
  antenna <math|i> to receive antenna <math|j>. The complex amplitude
  <math|\<alpha\><rsub|i,j><rsup|k><around|(|l|)>> is modelled as a
  zero-mean, complex Gaussian random variable with variance
  <math|E<around|(|<around|\||\<alpha\><rsub|i,j><rsup|k><around|(|l|)>|\|><rsup|2>|)>=\<delta\><rsub|l><rsup|2>>
  for any given <math|<around|(|i,j,k,l|)>>, where
  <math|i\<in\><around|{|1,\<cdots\>,M<rsub|r>|}>>,
  <math|j\<in\><around|{|1,\<cdots\>,M<rsub|t>|}>>,
  <math|k\<in\><around|{|1,\<cdots\>,M<rsub|b>|}>>, and
  <math|l\<in\><around|{|0,\<cdots\>,L-1|}>>. The powers of <math|L>
  independent channel taps are normalized such that
  <math|<big|sum><rsub|l=0><rsup|L-1>\<delta\><rsub|l><rsup|2>=1>. According
  to (<reference|Channel1>), the fading coefficient for the
  <math|n<rsup|t*h>> subcarrier between transmit antenna <math|i> and receive
  antenna <math|j> for frequency response of the channel is then given by

  <eqnarray|<tformat|<table|<row|<cell|H<rsub|i,j><rsup|k><around|(|n|)>=<big|sum><rsub|l=0><rsup|L-1>\<alpha\><rsub|i,j><rsup|k><around|(|l|)>*e<rsup|-\<iota\>*2*\<pi\>*n*\<Delta\><rsub|f>*\<tau\><rsub|l>>,<eq-number><label|Channel2>>>>>>

  where <math|\<iota\>=<sqrt|-1>>, <math|\<Delta\><rsub|f>> denotes the
  inter-subcarrier spacing, <math|\<tau\><rsub|l>=l*T<rsub|s>> represents the
  <math|l<rsup|t*h>> path delay, and <math|T<rsub|s>=<around|(|N*\<Delta\><rsub|f>|)><rsup|-1>>
  is the sampling interval of OFDM system. We assume that no spacial fading
  correlation exists between antennas, i.e., channel taps
  <math|\<alpha\><rsub|i,j><rsup|k><around|(|l|)>> are independent for any
  different indices <math|<around|(|i,j,k,l|)>>.

  Denote <math|<math-bf|h><rsub|i,j><rsup|k>=<around|(|\<alpha\><rsub|i,j><rsup|k><around|(|0|)>,\<alpha\><rsub|i,j><rsup|k><around|(|1|)>,\<cdots\>,\<alpha\><rsub|i,j><rsup|k>*<around|(|L-1|)>|)><rsup|<mathrm>>*T>
  and <math|<math-bf|H><rsub|i,j><rsup|k>=<around|(|H<rsub|i,j><rsup|k><around|(|0|)>,H<rsub|i,j><rsup|k><around|(|1|)>,\<cdots\>,H<rsub|i,j><rsup|k>*<around|(|N-1|)>|)><rsup|<mathrm>>*T>,
  respectively. Thus the frequency response of the channel is given by

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|H><rsup|k><rsub|i,j>=<math-bf|Fh><rsub|i,j><rsup|k>,<eq-number><label|Channelfrequency>>>>>>

  where matrix <math|<math-bf|F>> is given by

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|F>>|<cell|=>|<cell|<around*|[|<math-bf|f><rsup|\<tau\><rsub|0>>,<math-bf|f><rsup|\<tau\><rsub|1>>,\<cdots\>,<math-bf|f><rsup|\<tau\><rsub|L-1>>|]><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|0ln>|<table|<row|<cell|1>|<cell|1>|<cell|\<cdots\>>|<cell|1>>|<row|<cell|\<xi\><rsup|\<tau\><rsub|0>>>|<cell|\<xi\><rsup|\<tau\><rsub|1>>>|<cell|\<cdots\>>|<cell|\<xi\><rsup|\<tau\><rsub|L-1>>>>|<row|<cell|\<xi\><rsup|2*\<tau\><rsub|0>>>|<cell|\<xi\><rsup|2*\<tau\><rsub|1>>>|<cell|\<cdots\>>|<cell|\<xi\><rsup|2*\<tau\><rsub|L-1>>>>|<row|<cell|\<vdots\>>|<cell|\<vdots\>>|<cell|\<vdots\>>|<cell|\<vdots\>>>|<row|<cell|\<xi\><rsup|<around|(|N-1|)>*\<tau\><rsub|0>>>|<cell|\<xi\><rsup|<around|(|N-1|)>*\<tau\><rsub|1>>>|<cell|\<cdots\>>|<cell|\<xi\><rsup|<around|(|N-1|)>*\<tau\><rsub|L-1>>>>>>>|]>,<eq-number>>>>>>

  where <math|\<xi\>=e<rsup|-2*\<pi\>*\<iota\>/T<rsub|s>>>. Consequently, the
  correlation matrix of the channel frequency response from transmit antenna
  <math|i> to receive antenna <math|j> during the <math|k<rsup|t*h>> fading
  block can be calculated as

  <eqnarray|<tformat|<table|<row|<cell|R<rsup|k><rsub|i,j>>|<cell|=>|<cell|E*<around|{|<math-bf|H><rsub|i,j><rsup|k><around|[|<math-bf|H><rsub|i,j><rsup|k>|]><rsup|<mathrm>>*H|}><eq-number><label|relatiohship>>>|<row|<cell|>|<cell|=>|<cell|<math-bf|F>E*<around|{|<math-bf|h><rsub|i,j><rsup|k><around|[|<math-bf|h><rsub|i,j><rsup|k>|]><rsup|<mathrm>>*H|}><math-bf|F><rsup|<mathrm>>H<eq-number>>>|<row|<cell|>|<cell|=>|<cell|<math-bf|F><math-up|diag><around|(|\<delta\><rsub|0><rsup|2>,\<delta\><rsub|1><rsup|2>,\<cdots\>,\<delta\><rsub|L-1><rsup|2>|)><math-bf|F><rsup|<mathbf>>H.<eq-number>>>>>>

  In this paper, it is assumed that <math|R<rsup|k<rsub|1>><rsub|i,j>=R<rsup|k<rsub|2>><rsub|i,j>=R>,
  <math|\<forall\><nbsp>k<rsub|1>,k<rsub|2>\<in\><around|{|1,\<cdots\>,M<rsub|b>|}>>,
  for each pair of transmit and receive antennas with parameters
  <math|<around|(|i,j|)>>.

  <subsection|System Model>

  Suppose the information source generate <math|\<eta\>> information symbols
  from discrete alphabet <math|\<cal-A\>>, which are <math|q>-ary quadrature
  amplitude modulation (QAM) or pulse amplitude modulation (PAM) symbols
  normalized into the unit power. Deploying a mapping
  <math|f:<math-bf|x>\<mapsto\><math-bf|C>>, an arbitrary information symbol
  vector <math|<math-bf|x>=<around|[|x<rsub|0><nbsp>x<rsub|1><nbsp>\<cdots\><nbsp>x<rsub|\<eta\>-1>|]><rsup|<mathrm>>*T\<in\>\<cal-A\><rsup|\<eta\>>>
  is encoded a code matrix <math|<math-bf|C>\<in\>\<bbb-C\><rsup|N*M<rsub|b>\<times\>M<rsub|t>>>
  given by

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|C>=<around|[|<math-bf|C><rsub|1><rsup|<mathrm>>T<nbsp><math-bf|C><rsub|2><rsup|<mathrm>>T<nbsp>\<cdots\><nbsp><math-bf|C><rsub|M<rsub|b>><rsup|<mathrm>>T|]><rsup|<mathrm>>*T,<eq-number><label|C><label|codeword>>>>>>

  where matrix <math|<math-bf|C><rsub|k>=<around|[|<math-bf|c><rsub|1><rsup|k><nbsp><math-bf|c><rsub|2><rsup|k><nbsp>\<cdots\><nbsp><math-bf|c><rsub|M<rsub|t>><rsup|k>|]>>,
  <math|\<forall\><nbsp>k\<in\><around|{|1,2,\<cdots\>,M<rsub|b>|}>>, of size
  <math|N\<times\>M<rsub|t>> represents the subcodeword, an SF codeword,
  ready to be sent during the <math|k<rsup|t*h>> fading block. The
  <math|k<rsup|t*h>> subcodeword <math|<math-bf|C><rsub|k>\<in\>\<bbb-C\><rsup|N\<times\>M<rsub|t>>>
  is represented by

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|C><rsub|k>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|0ln>|<table|<row|<cell|c<rsub|1><rsup|k><around|(|0|)>>|<cell|c<rsub|2><rsup|k><around|(|0|)>>|<cell|\<cdots\>>|<cell|c<rsub|M<rsub|t>><rsup|k><around|(|0|)>>>|<row|<cell|c<rsub|1><rsup|k><around|(|1|)>>|<cell|c<rsub|2><rsup|k><around|(|1|)>>|<cell|\<cdots\>>|<cell|c<rsub|M<rsub|t>><rsup|k><around|(|1|)>>>|<row|<cell|\<vdots\>>|<cell|\<vdots\>>|<cell|\<vdots\>>|<cell|\<vdots\>>>|<row|<cell|c<rsub|1><rsup|k>*<around|(|N-1|)>>|<cell|c<rsub|2><rsup|k>*<around|(|N-1|)>>|<cell|\<cdots\>>|<cell|c<rsub|M<rsub|t>><rsup|k>*<around|(|N-1|)>>>>>>|]>,<eq-number><label|tch>>>>>>

  where <math|c<rsub|i><rsup|k><around|(|n|)>> is the data transmitted by the
  <math|i<rsup|t*h>> transmit antenna at the <math|n<rsup|t*h>> frequency
  subcarrier during the <math|k<rsup|t*h>> OFDM symbol duration. The
  <math|i<rsup|t*h>> column <math|<math-bf|c><rsub|i><rsup|k>> of size
  <math|N\<times\>1> is sent at the <math|i<rsup|t*h>> transmit antenna,
  <math|\<forall\><nbsp>i\<in\><around|{|1,2,\<cdots\>,M<rsub|t>|}>>. An STF
  codeword has an additional time dimension added to the above mentioned SF
  codeword in (<reference|tch>), which can be represented, as an example for
  <math|M<rsub|b>=2>,

  <\equation*>
    <math-bf|C><rsub|<math-up|STF>>=<around|[|<math-bf|C><rsub|k><rsup|<mathrm>>T<nbsp><math-bf|C><rsub|k+1><rsup|<mathrm>>T|]><rsup|<mathrm>>*T\<in\>\<bbb-C\><rsup|2*N\<times\>M<rsub|t>>.
  </equation*>

  Thus the proposed code <math|<math-bf|C>> in (<reference|C>) is the
  generalized STF codeword in essence. We assume the STF code
  <math|<math-bf|C>> satisfy the energy constraint
  <math|E*<around|(|<around|\<\|\|\>|<math-bf|C>|\<\|\|\>><rsub|<mathrm>>*F<rsup|2>|)>=N*M<rsub|b>*M<rsub|t>>.

  The OFDM transmitter performs an <math|N>-point inverse fast Fourier
  transform (IFFT) modulation over the frequency tones. To remove the inter
  symbol interference caused by the multipath delay of channels, one needs to
  insert a cyclic prefix (CP) to each OFDM symbol. After that, OFDM symbols
  are launched into the propagation environment from transmit antennas
  simultaneously.

  At the receiver, suppose that the perfect synchronization is available.
  After removing the CP and applying fast Fourier transform (FFT)
  demodulation, the received signal at the <math|j<rsup|t*h>> receive antenna
  for the <math|n<rsup|t*h>> frequency subcarrier during the
  <math|k<rsup|t*h>> OFDM symbol duration is given by

  <eqnarray|<tformat|<table|<row|<cell|Y<rsub|j><rsup|k><around|(|n|)>=<sqrt|<frac|\<rho\>|M<rsub|t>>>*<big|sum><rsub|i=1><rsup|M<rsub|t>>c<rsub|i><rsup|k><around|(|n|)>*H<rsub|i*j><rsup|k><around|(|n|)>+N<rsub|j><rsup|k><around|(|n|)>,<eq-number><label|receive>>>>>>

  where <math|\<rho\>> is the average signal-to-noise ratio (SNR) at each
  receive antenna, and <math|N<rsub|j><rsup|k><around|(|n|)>> is a zero-mean
  circularly symmetric complex Gaussian random variable vector with unit
  variance corresponding to the <math|n<rsup|t*h>> frequency subcarrier.
  Using the notations <math|c<rsub|i><rsup|k><around|(|n|)>=c<rsub|i>*<around|[|<around|(|k-1|)>*N+n|]>>,
  <math|H<rsub|i,j><rsup|k><around|(|n|)>=H<rsub|i,j>*<around|[|<around|(|k-1|)>*N+n|]>>,
  <math|N<rsub|j><rsup|k><around|(|n|)>=N<rsub|j>*<around|[|<around|(|k-1|)>*N+n|]>>,
  and <math|Y<rsub|j><rsup|k><around|(|n|)>=Y<rsub|j>*<around|[|<around|(|k-1|)>*N+n|]>>,
  <math|\<forall\><nbsp>k\<in\><around|{|1,\<cdots\>,M<rsub|b>|}>>,
  <math|n\<in\><around|{|0,1,\<cdots\>,N-1|}>>,
  <math|i\<in\><around|{|1,\<cdots\>,M<rsub|t>|}>>, and
  <math|j\<in\><around|{|1,\<cdots\>,M<rsub|r>|}>>, the received signals can
  be rewritten as

  <eqnarray|<tformat|<table|<row|<cell|Y<rsub|j><around|(|m|)>=<sqrt|<frac|\<rho\>|M<rsub|t>>>*<big|sum><rsub|i=1><rsup|M<rsub|t>>c<rsub|i><around|(|m|)>*H<rsub|i*j><around|(|m|)>+N<rsub|j><around|(|m|)>,<eq-number><label|receive>>>>>>

  <math|\<forall\><nbsp>m\<in\><around|{|0,1,\<cdots\>,N*M<rsub|b>-1|}>>,
  where <math|M<rsub|b>> denotes the minimum of the coherence time of
  channels. Taking the notation <math|D<rsub|i>=<math-up|diag><around|{|c<rsub|i><around|(|0|)>,\<cdots\>,c<rsub|i>*<around|(|N*M<rsub|b>-1|)>|}>>,
  we design an <math|N*M<rsub|r>*M<rsub|b>\<times\>N*M<rsub|r>*M<rsub|t>*M<rsub|b>>
  matrix <math|<math-bf|X>> from the STF codeword <math|<math-bf|C>> in
  (<reference|C>) as

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|X>=<math-bf|I><rsub|M<rsub|r>>\<otimes\><around|[|D<rsub|1><nbsp>D<rsub|2><nbsp>\<cdots\><nbsp>D<rsub|M<rsub|t>>|]>.<eq-number><label|codeword1>>>>>>

  Moreover, we denote channel vector <math|<math-bf|h>> of size
  <math|N*M<rsub|t>*M<rsub|r>*M<rsub|b>\<times\>1> as

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|h>=<around|[|H<rsub|1,1><rsup|<mathrm>>*T<nbsp>\<cdots\><nbsp>H<rsub|M<rsub|t>,1><rsup|<mathrm>>*T<nbsp>\<cdots\><nbsp>H<rsub|1,M<rsub|r>><rsup|<mathrm>>*T<nbsp>\<cdots\><nbsp>H<rsub|M<rsub|t>,M<rsub|r>><rsup|<mathrm>>*T|]><rsup|<mathrm>>*T,<eq-number><label|channelve>>>>>>

  where <math|H<rsub|i,j>=<around|[|H<rsub|i,j><around|(|0|)><nbsp>\<cdots\><nbsp>H<rsub|i,j>*<around|(|N*M<rsub|b>-1|)>|]><rsup|<mathrm>>*T>.
  The received signal vector <math|<math-bf|Y>> is denoted by
  <math|<math-bf|Y>=<around|[|Y<rsub|1><around|(|0|)><nbsp>\<cdots\><nbsp>Y<rsub|1>*<around|(|N*M<rsub|b>-1|)><nbsp>\<cdots\><nbsp>Y<rsub|M<rsub|r>><around|(|0|)><nbsp>\<cdots\><nbsp>Y<rsub|M<rsub|r>>*<around|(|N*M<rsub|b>-1|)>|]><rsup|<mathrm>>*T>,
  and the noise vector <math|<math-bf|N>>, the additive complex Gaussian
  noise with zero mean and unit variance of size
  <math|N*M<rsub|r>*M<rsub|b>\<times\>1>, is represented as
  <math|<math-bf|N>=<around|[|N<rsub|1><around|(|0|)><nbsp>\<cdots\><nbsp>N<rsub|1>*<around|(|N*M<rsub|b>-1|)><nbsp>\<cdots\><nbsp>N<rsub|M<rsub|r>><around|(|0|)><nbsp>\<cdots\><nbsp>N<rsub|M<rsub|r>>*<around|(|N*M<rsub|b>-1|)>|]><rsup|<mathrm>>*T>.
  After some permutations of matrices and vectors, the received signals
  <math|Y<rsub|j>> in (<reference|receive>) can be rewritten in matrix format
  given by

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|Y>=<sqrt|<frac|\<rho\>|M<rsub|t>>><math-bf|Xh>+<math-bf|N>.<eq-number><label|system>>>>>>

  Actually, while taking <math|<math-bf|F><rsub|l>=<math-up|diag><around|(|<math-bf|f><rsup|\<tau\><rsub|l>>|)>>
  and <math|<with|math-font-family|bf|\<alpha\>><rsub|j><rsup|k><around|(|l|)>=<around|[|\<alpha\><rsub|1,j><around|(|l|)>,\<cdots\>,\<alpha\><rsub|M<rsub|t>,j><around|(|l|)>|]><rsup|<mathrm>>*T>,
  <math|\<forall\><nbsp>l\<in\><around|{|0,1,\<cdots\>,L-1|}>> and using
  notations <math|<math-bf|X><rprime|'><rsub|k>=<around|(|<math-bf|F><rsub|0><math-bf|C><rsub|k><nbsp>\<cdots\><nbsp><math-bf|F><rsub|L-1><math-bf|C><rsub|k>|)>>
  and <math|\<alpha\><rsub|j><rsup|k>=<around|[|<around|(|\<alpha\><rsub|j><rsup|k><around|(|0|)>|)><rsup|<mathrm>>*T<nbsp>\<cdots\><nbsp><around|(|\<alpha\><rsub|j><rsup|k>*<around|(|L-1|)>|)><rsup|<mathrm>>*T|]><rsup|<mathrm>>*T>,
  the system in (<reference|system>) can be equivalent to

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|Y>=<sqrt|<frac|\<rho\>|M<rsub|t>>><math-bf|X><rprime|'><math-bf|h><rprime|'>+<math-bf|N>,<eq-number><label|system1>>>>>>

  where <math|<math-bf|X><rprime|'>=<math-bf|I><rsub|M<rsub|r>>\<otimes\><math-up|diag><around|(|<math-bf|X><rprime|'><rsub|1><nbsp>\<cdots\><nbsp><math-bf|X><rprime|'><rsub|M<rsub|b>>|)>>
  and <math|<math-bf|h><rprime|'>=<around|[|<around|(|\<alpha\><rsub|1><rsup|1>|)><rsup|<mathrm>>*T<nbsp>\<cdots\><nbsp><around|(|\<alpha\><rsub|1><rsup|M<rsub|b>>|)><rsup|<mathrm>>*T<nbsp>\<cdots\><nbsp><around|(|\<alpha\><rsub|M<rsub|r>><rsup|1>|)><rsup|<mathrm>>*T<nbsp>\<cdots\><nbsp><around|(|\<alpha\><rsub|M<rsub|r>><rsup|M<rsub|b>>|)><rsup|<mathrm>>*T|]><rsup|<mathrm>>*T>.

  Assume the path gains <math|\<alpha\><rsub|i,j><rsup|k><around|(|l|)>> are
  independent for different paths <math|l>, transmit antenna <math|i>,
  receive antenna <math|j>, and fading block <math|k>. Then the block
  (temporal) correlation is defined as <math|r<rsub|b><around|(|m|)>=E<around|{|\<alpha\><rsub|i,j><rsup|k><around|(|l|)><around|(|\<alpha\><rsub|i,j><rsup|k+m><around|(|l|)>|)><rsup|\<ast\>>|}>>,
  <math|\<forall\><nbsp>m,k\<in\><around|{|1,2,\<cdots\>,M<rsub|b>|}>>. Using
  notation <math|<math-bf|a><rsub|i,j>=<around|[|\<alpha\><rsub|i,j><rsup|1><around|(|0|)><nbsp>\<cdots\><nbsp>\<alpha\><rsub|i,j><rsup|1>*<around|(|L-1|)><nbsp>\<cdots\><nbsp>\<alpha\><rsub|i,j><rsup|M<rsub|b>><around|(|0|)>*\<cdots\><nbsp>\<alpha\><rsub|i,j><rsup|M<rsub|b>>*<around|(|L-1|)>|]><rsup|<mathrm>>*T>,
  we have the correlation matrix <math|E<around|(|<math-bf|a><rsub|i,j><math-bf|a><rsub|i,j><rsup|<mathrm>>H|)>=R<rsub|b>\<otimes\><math-up|diag><around|{|\<delta\><rsub|0><rsup|2>,\<cdots\>,\<delta\><rsub|L-1><rsup|2>|}>>,
  where <math|R<rsub|b>=<around|(|r<rsub|p,q>|)><rsub|M<rsub|b>\<times\>M<rsub|b>>>
  is the temporal correlation matrix, each entry <math|r<rsub|p,q>>
  calculating from <math|r<rsub|p,q>=r<rsub|b>*<around|(|q-p|)>>
  <math|\<forall\><nbsp>p,q\<in\><around|{|1,\<cdots\>,M<rsub|b>|}>>. For the
  channel vector <math|<math-bf|h>> of size
  <math|N*M<rsub|t>*M<rsub|r>*M<rsub|b>\<times\>1>, the correlation matrix
  <math|<math-bf|R>> of size <math|N*M<rsub|t>*M<rsub|r>*M<rsub|b>\<times\>N*M<rsub|t>*M<rsub|r>*M<rsub|b>>
  is formatted by

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|R>>|<cell|=>|<cell|<math-up|diag><around|{|R<rsub|1,1><nbsp>\<cdots\>*R<rsub|M<rsub|t>,1><nbsp>\<cdots\>*R<rsub|1,M<rsub|r>>*\<cdots\><nbsp>R<rsub|M<rsub|t>,M<rsub|r>>|}><eq-number><label|R>>>|<row|<cell|>|<cell|=>|<cell|<math-bf|I><rsub|M<rsub|t>*M<rsub|r>>\<otimes\><around|(|R<rsub|b>\<otimes\>R|)>.<eq-number>>>>>>

  Suppose <math|<math-bf|X>> and <math|<wide|<math-bf|X>|~>> of size
  <math|N*M<rsub|b>*M<rsub|r>\<times\>N*M<rsub|b>*M<rsub|r>*M<rsub|t>> are
  two matrices corresponding to codewords <math|<math-bf|C>> and
  <math|<wide|<math-bf|C>|~>> of size <math|N*M<rsub|b>\<times\>M<rsub|t>>.
  The pairwise error probability (PEP) between <math|<math-bf|X>> and
  <math|<wide|<math-bf|X>|~>> is given by

  <eqnarray|<tformat|<table|<row|<cell|\<cal-P\>*<around|(|<math-bf|X>\<rightarrow\><wide|<math-bf|X>|~>|)><space|-0.17em>=P*<around|(|<around|\<\|\|\>|<math-bf|Y>-<math-bf|Xh>|\<\|\|\>><rsub|<mathrm>>*F<rsup|2>\<gtr\><around|\<\|\|\>|<math-bf|Y>-<wide|<math-bf|X>|~><math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F<rsup|2><nbsp>\<mid\><math-bf|X><nbsp><math-up|send>|)><eq-number><label|PEP>>>|<row|<cell|=P*<around|(|<around|(|\<Delta\><math-bf|Xh>+<math-bf|N>|)><rsup|<mathrm>>*H*<around|(|\<Delta\><math-bf|Xh>+<math-bf|N>|)>\<less\><math-up|N><rsup|<mathrm>>H<math-up|N><nbsp>\<mid\><math-bf|X><nbsp><math-up|send>|)><eq-number>>>>>>

  where <math|\<Delta\><math-bf|X>=<math-bf|X>-<wide|<math-bf|X>|~>>.

  Using notations <math|\<Delta\><math-bf|C>=<math-bf|C>-<wide|<math-bf|C>|~>>
  and <math|\<Delta\><math-bf|D><rsub|i>=<math-bf|D><rsub|i>-<wide|<math-bf|D>|~><rsub|i>>,
  <math|\<forall\><nbsp>i\<in\><around|{|1,\<cdots\>,M<rsub|t>|}>>, matrix
  <math|\<Delta\><math-bf|XR>\<Delta\><math-bf|X><rsup|<mathrm>>H> can be
  represented as

  <eqnarray|<tformat|<table|<row|<cell|\<Delta\><math-bf|XR>\<Delta\><math-bf|X><rsup|<mathrm>>H>|<cell|=>|<cell|I<rsub|M<rsub|r>>\<otimes\><around|(|<big|sum><rsub|i=1><rsup|M<rsub|t>>\<Delta\><math-bf|D><rsub|i><around|(|R<rsub|b>\<otimes\>R|)>*\<Delta\><math-bf|D><rsub|i><rsup|<mathrm>>H|)><eq-number>>>|<row|<cell|>|<cell|=>|<cell|I<rsub|M<rsub|r>>\<otimes\><around|[|<around|(|\<Delta\><math-bf|C>\<Delta\><math-bf|C><rsup|<mathrm>>H|)>\<circ\><around|(|R<rsub|b>\<otimes\>R|)>|]>,<eq-number>>>>>>

  where <math|\<circ\>> denotes Hadamard product. Let

  <\equation*>
    <math-bf|W>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|\<Delta\><math-bf|XR>\<Delta\><math-bf|X><rsup|<mathrm>>H+<math-bf|I><rsub|N*M<rsub|b>*M<rsub|r>>>|<cell|-<math-bf|I><rsub|N*M<rsub|b>*M<rsub|r>>>>|<row|<cell|<math-bf|I><rsub|N*M<rsub|b>*M<rsub|r>>>|<cell|-<math-bf|I><rsub|N*M<rsub|b>*M<rsub|r>>>>>>>|]>,
  </equation*>

  then the characteristic function is given by

  <eqnarray|<tformat|<table|<row|<cell|\<Phi\><rsub|<mathbf>>*C<around|(|t|)>>|<cell|=>|<cell|E<around|(|e<rsup|\<iota\>*Q*t>|)>=<frac|1|<math-up|det><around|(|<math-bf|I><rsub|2*N*M<rsub|b>*M<rsub|r>>-\<iota\>*t<math-bf|W>|)>>.<eq-number>>>>>>

  where <math|Q=<around|(|\<Delta\><math-bf|Xh>+<math-bf|N>|)><rsup|<mathrm>>*H*<around|(|\<Delta\><math-bf|Xh>+<math-bf|N>|)>-<math-up|N><rsup|<mathrm>>H<math-up|N>>.
  Thus the PEP between <math|<math-bf|X>> and <math|<wide|<math-bf|X>|~>> can
  be upper bounded by <cite|Sirianunpiboonr52011>

  <eqnarray|<tformat|<table|<row|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>\<cal-P\>*<around|(|<math-bf|X>\<rightarrow\><wide|<math-bf|X>|~>|)><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>=<space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><frac|1|2*\<pi\>>*<big|int><rsub|-\<infty\>><rsup|0><big|int><rsub|-\<infty\>><rsup|+\<infty\>>\<Phi\><rsub|<mathbf>>*C<around|(|t|)>*e<rsup|-\<iota\>*x*t>*d*x*d*t<eq-number><label|bound2>>>|<row|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>\<leq\>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|2*\<kappa\>*M<rsub|r>-1>>|<row|<cell|\<kappa\>*M<rsub|r>>>>>>|]><around*|[|<big|prod><rsub|i=1><rsup|\<kappa\>>\<lambda\><rsub|i>|]><rsup|-M<rsub|r>><around*|[|<frac|\<rho\>|M<rsub|t>>|]><rsup|-\<kappa\>*M<rsub|r>><eq-number>>>>>>

  where <math|\<lambda\><rsub|i>> denotes the <math|i<rsup|t*h>> nonzero
  eigenvalue of <math|<around|(|\<Delta\><math-bf|C>\<Delta\><math-bf|C><rsup|<mathrm>>H|)>\<circ\><around|(|R<rsub|b>\<otimes\>R|)>>,
  and <math|\<kappa\>> denotes the number of nonzero eigenvalues or the rank
  of the Hadamard product matrix <math|<around|(|\<Delta\><math-bf|C>\<Delta\><math-bf|C><rsup|<mathrm>>H|)>\<circ\><around|(|R<rsub|b>\<otimes\>R|)>>.

  Thus there are two STF code design criterions <cite|Lu522|Lu523> described
  as follows.

  <\enumerate>
    <item>Diversity (rank) criterion: the minimum rank of
    <math|<around|(|\<Delta\><math-bf|C>\<Delta\><math-bf|C><rsup|<mathrm>>H|)>\<circ\><around|(|R<rsub|b>\<otimes\>R|)>>
    should be as large as possible for all pairs of codewords
    <math|<math-bf|C>> and <math|<wide|<math-bf|C>|~>>.

    <item>Product (gain) criterion: the minimum value of product
    <math|<big|prod><rsub|i=1><rsup|\<kappa\>>\<lambda\><rsub|i>> should be
    maximized as large as possible for all pairs of codewords
    <math|<math-bf|C>> and <math|<wide|<math-bf|C>|~>>.
  </enumerate>

  It is necessary to note that since rank of
  <math|\<Delta\><math-bf|C>\<Delta\><math-bf|C><rsup|<mathrm>>H> is at most
  <math|M<rsub|t>> and rank of <math|R> is at most <math|L>, we have

  <eqnarray|<tformat|<table|<row|<cell|<math-up|Rank><around|[|<around|(|\<Delta\><math-bf|C>\<Delta\><math-bf|C><rsup|<mathrm>>H|)><space|-0.17em>\<circ\><space|-0.17em><around|(|R<rsub|b>\<otimes\>R|)>|]><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|\<leq\>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>min
  <around|{|L*M<rsub|t><math-up|Rank><around|(|R<rsub|b>|)>,N*M<rsub|b>|}>,<eq-number>>>>>>

  which is a result of the rank inequalities on the Hadamard product and
  tensor product.

  <subsection|PIC Group Decoding Algorithm>

  The rule mapping information symbols to the SF/STF codewords is usually the
  one that minimizes the error probability for given codes. Without utilizing
  any design structures, it seems difficult to decode the SF/STF codes due to
  the significant complexity and storage requirements that grow with larger
  rates. To overcome these difficulties, information symbols
  <math|x<rsub|v>\<in\>\<cal-A\>>, <math|\<forall\><nbsp>v\<in\><around|{|1,\<cdots\>,\<eta\>|}>>
  are assumed to be encoded by the linear dispersion STF codes in which
  codewords are a linear function of data symbols with the canonical
  decomposition

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|X>=<big|sum><rsub|v=1><rsup|\<eta\>><around|(|x<rsub|v><math-bf|A><rsub|v>+x<rsub|v><rsup|\<ast\>><math-bf|B><rsub|v>|)>,<eq-number><label|STF>>>>>>

  where <math|<math-bf|A><rsub|v>,<math-bf|B><rsub|v>\<in\>\<bbb-C\><rsup|N*M<rsub|r>*M<rsub|b>\<times\>N*M<rsub|t>*M<rsub|r>*M<rsub|b>>>
  are constant matrices called dispersion matrices. The key to the linear
  dispersion STF code design is that the basis matrices
  <math|<around|{|<around|(|<math-bf|A><rsub|v>,<math-bf|B><rsub|v>|)>:v\<in\><around|{|1,\<cdots\>,\<eta\>|}>|}>>
  are chosen such that the resulting codes can maximize the ergodic capacity
  of the equivalent MIMI-OFDM system and hence provide good performance in
  terms of error probability. In this paper, we only consider the codeword
  <math|\<cal-X\>> generated from a simple linear dispersion STF code defined
  as <math|<math-bf|X>=<big|sum><rsub|v=1><rsup|\<eta\>>x<rsub|v><math-bf|A><rsub|v>>,
  i.e.,

  <eqnarray|<tformat|<table|<row|<cell|\<cal-X\>\<triangleq\><around|{|<math-bf|X>=<big|sum><rsub|v=1><rsup|\<eta\>>x<rsub|v><math-bf|A><rsub|v>:x<rsub|v>\<in\>\<cal-A\>,v\<in\><around|{|1,\<cdots\>,\<eta\>|}>|}>.<eq-number><label|codebook>>>>>>

  In a case that the complex conjugated information symbols are involved, it
  can be converted into the form in (<reference|codebook>) if the real and
  imaginary parts are represented as two independent variables. Assuming
  <math|<math-bf|E><around|[|x<rsub|n>|]>=0> and
  <math|<math-bf|E><around|[|<around|\||x<rsub|n>|\|><rsup|2>|]>=1>, the
  basis matrices should satisfy the power constraint
  <math|<math-up|tr><around|(|<big|sum><rsub|v=1><rsup|\<eta\>><math-bf|A><rsub|v><math-bf|A><rsub|v><rsup|<mathrm>>H|)>=N*M<rsub|b>>.
  It is known that the SF/STF code is fully determined by the set of codeword
  matrices <math|<math-bf|A><rsub|v>> that can be identified by transmitter
  and receiver.

  In order to decode the transmitted symbol vector
  <math|<math-bf|x>=<around|(|x<rsub|1>,\<cdots\>,x<rsub|\<eta\>>|)><rsup|<mathrm>>*T\<in\>\<cal-A\><rsup|\<eta\>>>
  at the receiver, we need to extract <math|<math-bf|x>> from the codeword
  <math|<math-bf|X>> using the PIC group decoding algorithm. Substituting
  <math|<math-bf|X>> in (<reference|system>) with a simple linear dispersion
  STF code expressed in (<reference|codebook>), we have

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|Y>>|<cell|=>|<cell|<sqrt|<frac|\<rho\>|M<rsub|t>>>*<big|sum><rsub|v=1><rsup|\<eta\>><math-bf|A><rsub|v><math-bf|h>x<rsub|v>+<math-bf|N><eq-number><label|finall>>>|<row|<cell|>|<cell|=>|<cell|<sqrt|<frac|\<rho\>|M<rsub|t>>><around|(|<math-bf|A><rsub|1><math-bf|h>,\<cdots\>,<math-bf|A><rsub|\<eta\>><math-bf|h>|)><math-bf|x>+<math-bf|N><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<sqrt|<frac|\<rho\>|M<rsub|t>>>*\<cal-H\><around|(|<math-bf|h>|)><math-bf|x>+<math-bf|N>,<eq-number>>>>>>

  where <math|<math-bf|Y>> is the received signal vector of size
  <math|N*M<rsub|r>*M<rsub|b>\<times\>1>,
  <math|\<cal-H\><around|(|<math-bf|h>|)>=<around|(|<math-bf|A><rsub|1><math-bf|h>,\<cdots\>,<math-bf|A><rsub|\<eta\>><math-bf|h>|)>>
  is an equivalent channel matrix of size
  <math|N*M<rsub|r>*M<rsub|b>\<times\>\<eta\>>, and <math|<math-bf|N>> is the
  additive white Gaussian noise vector of size
  <math|N*M<rsub|r>*M<rsub|b>\<times\>1>. Since the decoding complexity grows
  with increasing <math|\<eta\>>, it is sufficient to take
  <math|\<eta\>=N*M<rsub|b>*M<rsub|t>> to achieve full capacity of MIMO-OFDM
  channels given by

  <\equation*>
    C<rsub|<mathbf>>*H=<math-bf|E><rsub|<mathbf>>Hlog
    <math-up|det><around|(|<math-bf|I><rsub|M<rsub|r>>+<frac|\<rho\>|M<rsub|t>><math-bf|HH><rsup|<mathrm>>H|)>,
  </equation*>

  where the selection of input distribution which maximizes the mutual
  information is circular complex Gaussian with covariance
  <math|1/<around|(|N*M<rsub|b>*M<rsub|t>|)><math-bf|I><rsub|N*M<rsub|b>*M<rsub|t>>>.

  Let us define the index set <math|\<cal-I\>=<around|{|1,2,\<cdots\>,\<eta\>|}>>,
  where <math|\<eta\>> represents the number of information symbols in
  <math|<math-bf|x>>. The set <math|\<cal-I\>> is then partitioned into
  <math|P> subsets, i.e., <math|\<cal-I\>=<around|{|\<cal-I\><rsub|p>:1\<leq\>p\<leq\>P|}>>
  with

  <\equation*>
    \<cal-I\><rsub|p>\<triangleq\><around|{|i<rsub|p,1>,\<cdots\>,i<rsub|p,\<eta\><rsub|p>>|}>
  </equation*>

  such that <math|\<cal-I\>=<big|cup><rsub|p=1><rsup|P>\<cal-I\><rsub|p>> and
  <math|<big|sum><rsub|p=1><rsup|P>\<eta\><rsub|p>=\<eta\>>, where
  <math|\<eta\><rsub|p>> denotes the cardinality of subset
  <math|\<cal-I\><rsub|p>>. We define <math|<math-bf|x><rsub|\<cal-I\><rsub|p>>>
  as the information symbols with indices in <math|\<cal-I\><rsub|p>>, i.e.,

  <\equation*>
    <math-bf|x><rsub|\<cal-I\><rsub|p>>\<triangleq\><around|[|x<rsub|i<rsub|p,1>><nbsp>\<cdots\><nbsp>x<rsub|i<rsub|p,\<eta\><rsub|p>>>|]><rsup|T>.
  </equation*>

  In this case the STF code <math|<math-bf|X>> in (<reference|codebook>) can
  be represented as <math|<math-bf|X><around|(|<math-bf|x>|)>\<triangleq\><math-bf|X><around|(|<math-bf|x><rsub|\<cal-I\><rsub|1>>,\<cdots\>,<math-bf|x><rsub|\<cal-I\><rsub|P>>|)>>.
  Let each column vector <math|<math-bf|A><rsub|i><math-bf|h>> of an
  equivalent channel matrix <math|\<cal-H\><around|(|<math-bf|h>|)>> be
  denoted as <math|\<cal-H\><rsub|i><around|(|<math-bf|h>|)>>,
  <math|\<forall\><nbsp>i\<in\>\<cal-I\>>. Then we have

  <eqnarray|<tformat|<table|<row|<cell|\<cal-H\><around|(|<math-bf|h>|)>\<triangleq\><around|[|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)><nbsp>\<cdots\><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>|]>,<eq-number><label|equal-Channel>>>>>>

  where grouping vector set is given by

  <eqnarray|<tformat|<table|<row|<cell|\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>\<triangleq\><around|[|\<cal-H\><rsub|i<rsub|p,1>><around|(|<math-bf|h>|)><nbsp>\<cdots\><nbsp>\<cal-H\><rsub|i<rsub|p,\<eta\><rsub|p>>><around|(|<math-bf|h>|)>|]>.<eq-number><label|equal-Channel>>>>>>

  Consequently, the formula in (<reference|finall>) can be described as

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|Y>=<sqrt|<frac|\<rho\>|M<rsub|t>>>*<big|sum><rsub|p=1><rsup|P>\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|x><rsub|\<cal-I\><rsub|p>>+<math-bf|N>.<eq-number><label|Normal>>>>>>

  At the receiver, we need to recover the symbol vector embedded in the
  <math|p<rsup|t*h>> subset <math|<math-bf|x><rsub|\<cal-I\><rsub|p>>>. To
  apply the PIC group decoding to completely eliminate the interferences from
  other subsets <math|<math-bf|x><rsub|\<cal-I\><rsub|q>>> for
  <math|p\<neq\>q>, a suitable operation (matched filtering and symbol-rate
  sampling) <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>>
  should be designed such that all interferences from other subsets
  <math|<math-bf|x><rsub|\<cal-I\><rsub|q>>> are eliminated while multiplying
  <math|<math-bf|Y>> by <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>>,
  i.e., <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>\<cdot\>\<cal-H\><rsub|\<cal-I\><rsub|q>><around|(|<math-bf|h>|)>=<with|math-font-family|bf|0>>.
  The interference cancellation matrix <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>>>
  can be chosen from formula

  <eqnarray|<tformat|<table|<row|<cell|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>=I<rsub|N*M<rsub|r>*M<rsub|b>>-<math-bf|Q><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>,<eq-number><label|PICh>>>>>>

  where

  <\equation*>
    <math-bf|Q><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>=\<cal-H\><rsub|\<cal-I\><rsub|p>><rsup|c><around|(|<math-bf|h>|)>*<around|[|<around|(|\<cal-H\><rsub|\<cal-I\><rsub|p>><rsup|c><around|(|<math-bf|h>|)>|)><rsup|<mathrm>>*H*\<cal-H\><rsub|\<cal-I\><rsub|p>><rsup|c><around|(|<math-bf|h>|)>|]><rsup|-1><around|(|\<cal-H\><rsub|\<cal-I\><rsub|p>><rsup|c><around|(|<math-bf|h>|)>|)><rsup|<mathrm>>*H,
  </equation*>

  and <math|\<cal-H\><rsub|\<cal-I\><rsub|p>><rsup|c><around|(|<math-bf|h>|)>>
  of size <math|N*M<rsub|r>*M<rsub|b>\<times\><around|(|\<eta\>-\<eta\><rsub|p>|)>>
  denotes the reduced matrix that is obtained by removing the column vectors
  in <math|\<cal-H\><around|(|<math-bf|h>|)>> with indices in
  <math|\<cal-I\><rsub|p>>, i.e.,

  <\equation*>
    \<cal-H\><rsub|\<cal-I\><rsub|p>><rsup|c><around|(|<math-bf|h>|)>=<around|[|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)><nbsp>\<cdots\><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|p-1>><around|(|<math-bf|h>|)><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|p+1>><around|(|<math-bf|h>|)><nbsp>\<cdots\><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|\<eta\>>><around|(|<math-bf|h>|)>|]>.
  </equation*>

  It is assumed that the reduced matrix <math|\<cal-H\><rsub|\<cal-I\><rsub|p>><rsup|c><around|(|<math-bf|h>|)>>
  is of full column rank. If <math|\<cal-H\><rsub|\<cal-I\><rsub|p>><rsup|c><around|(|<math-bf|h>|)>>
  is not of full column rank, one should pick a maximal linear independent
  vector set from <math|\<cal-H\><rsub|\<cal-I\><rsub|p>><rsup|c><around|(|<math-bf|h>|)>>,
  from which an interference cancellation matrix
  <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>>
  can be constructed in a similar way.

  Using the yielded matrix <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>>,
  <math|\<forall\><nbsp>p\<in\><around|{|1,\<cdots\>,P|}>>, we denote
  <math|<math-bf|Z><rsub|\<cal-I\><rsub|p>>=<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|Y>>
  and obtain

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|Z><rsub|\<cal-I\><rsub|p>>>|<cell|=>|<cell|<sqrt|<frac|\<rho\>|M<rsub|t>>>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*<big|sum><rsub|p=1><rsup|P>\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|x><rsub|\<cal-I\><rsub|p>>+<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|N><eq-number><label|PICdecoding>>>|<row|<cell|>|<cell|=>|<cell|<sqrt|<frac|\<rho\>|M<rsub|t>>>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|x><rsub|\<cal-I\><rsub|p>>+<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|N>.<eq-number>>>>>>

  It is shown that the interferences from other symbol subsets are cancelled
  and output <math|<math-bf|Z><rsub|\<cal-I\><rsub|p>>> contains symbol
  subset <math|<math-bf|x><rsub|\<cal-I\><rsub|p>>> if the received signal
  vector <math|<math-bf|Y>> pass through the linear filter
  <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>>.
  After that, symbol subset <math|<math-bf|x><rsub|\<cal-I\><rsub|p>>> can be
  decoded with the ML decoding algorithm through the decision

  <eqnarray|<tformat|<table|<row|<cell|<wide|<math-bf|x>|^><rsub|\<cal-I\><rsub|p>>=arg
  min<rsub|<math-bf|x><rsub|\<cal-I\><rsub|p>>\<in\>\<cal-A\><rsup|\<eta\><rsub|p>>><around|\<\|\|\>|<math-bf|Z><rsub|\<cal-I\><rsub|p>>-<sqrt|<frac|\<rho\>|M<rsub|t>>>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|x><rsub|\<cal-I\><rsub|p>>|\<\|\|\>><rsub|<mathrm>>*F,<eq-number><label|decodePICD>>>>>>

  which is the PIC group decoding algorithm employed in this paper. It is
  obvious that the complexity of this system is much lower than that of the
  original system expressed in (<reference|finall>).

  In order to decode <math|<math-bf|x>> at the receiver, we consider the
  dimension-reduced channel model in (<reference|PICdecoding>) with the
  optimal detection of <math|<math-bf|x><rsub|\<cal-I\><rsub|p>>> from
  <math|<math-bf|Z><rsub|\<cal-I\><rsub|p>>>. It is known that the singular
  value decomposition (SVD) of <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>>
  is given by calculating

  <\equation*>
    <with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>=U<rsub|r><math-up|diag><around|(|\<sigma\><rsub|1>,\<cdots\>,\<sigma\><rsub|\<eta\><rsub|p>>|)>*U<rsub|c>,
  </equation*>

  where <math|U<rsub|r>> and <math|U<rsub|c>> are two unitary operations.
  Then we can design the PIC group decoding algorithm, in which the different
  decoding orders may result in different performances. Thus we should select
  a proper decoding order so that the dimension-reduced system at the current
  decoding stage has the best upper-bound of pair-wise error probability
  (PEP) performance. Let <math|<math-bf|x><rsub|\<cal-I\><rsub|p>>,<wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|p>>\<in\>\<cal-A\><rsup|\<eta\><rsub|p>>>
  are two different vectors, and <math|\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>=<math-bf|x><rsub|\<cal-I\><rsub|p>>-<wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|p>>>.
  For the <math|p<rsup|t*h>> dimension-reduced system, the upper-bound of PEP
  can be calculated as

  <eqnarray|<tformat|<table|<row|<cell|\<cal-P\>*<around|(|<math-bf|x><rsub|\<cal-I\><rsub|p>>\<rightarrow\><wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|p>>|)><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>\<cal-Q\>*<around|(|<around|\<\|\|\>|<sqrt|<frac|\<rho\>|M<rsub|t>>>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|\<\|\|\>><rsub|<mathrm>>*F|)><eq-number>>>|<row|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>\<cal-Q\>*<around|(|<sqrt|<frac|\<rho\>|M<rsub|t>>>*<around|\<\|\|\>|<math-up|diag><around|(|\<sigma\><rsub|1>,\<cdots\>,\<sigma\><rsub|\<eta\><rsub|p>>|)>*U<rsub|c>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|\<\|\|\>><rsub|<mathrm>>*F|)><eq-number>>>|<row|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>\<leq\>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>\<cal-Q\>*<around|(|<sqrt|<frac|\<rho\>|M<rsub|t>>>*<around|\<\|\|\>|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>|\<\|\|\>><rsub|<mathrm>>*Fmin
  <around|{|U<rsub|c>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|}>|)>,<eq-number>>>>>>

  where <math|min <around|{|U<rsub|c>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|}>>
  denotes the minimum value among the absolute values of the entries of
  vector <math|U<rsub|c>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>>. Thus,
  the dimension-reduced system with the largest
  <math|<around|\<\|\|\>|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>|\<\|\|\>><rsub|<mathrm>>*F>
  has the smallest upper-bound of PEP. Without loss of generality, we assume
  that

  <\equation*>
    <around|\<\|\|\>|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>|\<\|\|\>><rsub|<mathrm>>*F\<geq\>\<cdots\>\<geq\><around|\<\|\|\>|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|P>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|P>><around|(|<math-bf|h>|)>|\<\|\|\>><rsub|<mathrm>>*F,
  </equation*>

  which corresponds to the ordered symbol sets
  <math|<math-bf|x><rsub|\<cal-I\><rsub|1>>,<math-bf|x><rsub|\<cal-I\><rsub|2>>,\<cdots\>,<math-bf|x><rsub|\<cal-I\><rsub|P>>>.
  Then the ordered PIC group decoding algorithm can be designed as follows.

  <\enumerate>
    <item>Decode the first set of symbols
    <math|<math-bf|x><rsub|\<cal-I\><rsub|1>>> with the PIC group decoding
    algorithm in (<reference|decodePICD>);

    <item>Let <math|p=1> and <math|<math-bf|Y><rsub|1>=<math-bf|Y>>, where
    <math|<math-bf|Y>> is defined in (<reference|Normal>);

    <item>Remove the components of the already-detected symbol set
    <math|<math-bf|x><rsub|\<cal-I\><rsub|p>>> from (<reference|Normal>),
    i.e.,

    <eqnarray|<tformat|<table|<row|<cell|<math-bf|Y><rsub|p+1>>|<cell|=>|<cell|<math-bf|Y><rsub|p>-<sqrt|<frac|\<rho\>|M<rsub|t>>>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|x><rsub|\<cal-I\><rsub|p>><eq-number><label|partdecodePICD>>>|<row|<cell|>|<cell|=>|<cell|<sqrt|<frac|\<rho\>|M<rsub|t>>>*<big|sum><rsub|j=p+1><rsup|P>\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|x><rsub|\<cal-I\><rsub|p>>+<math-bf|N>.<eq-number>>>>>>

    <item>Decoding <math|<math-bf|x><rsub|\<cal-I\><rsub|p+1>>> in
    (<reference|partdecodePICD>) using the PIC group decoding algorithm in
    (<reference|decodePICD>);

    <item>If <math|p\<less\>P>, then set <math|p\<assign\>p+1> and go to 3);
    otherwise stop the algorithm.
  </enumerate>

  In order to derive the design criterion for the high-rate STF coding
  schemes achieving full-diversity with the PIC group decoding, we cite the
  main results of the STBC design criterion to achieve full diversity with
  the PIC group decoding <cite|Xia09>, which can be stated as follows.

  <with|font-shape|italic|Theorem 2.1:> For an SF/STF code
  <math|<math-bf|X><around|(|<math-bf|x>|)>\<in\>\<cal-X\>> with the PIC
  group decoding over the frequency-selective channels, full diversity is
  achieved for <math|<math-bf|h>\<neq\>0> when the code <math|<math-bf|X>>
  satisfies the full rank criterion, i.e., it achieves full diversity when
  the ML receiver is used; and for a fixed <math|p>, any nonzero linear
  combination over <math|\<Delta\>*\<cal-A\>> of vectors in the
  <math|p<rsup|t*h>> subset <math|\<cal-H\><rsub|\<cal-I\><rsub|p>>> does not
  belong to the space linearly spanned by all vectors in the remaining vector
  subsets <math|<around|{|\<cal-H\><rsub|\<cal-I\><rsub|q>>:q\<neq\>p|}>>,
  <math|\<forall\><nbsp>p,q\<in\><around|{|1,\<cdots\>,P|}>>.

  Notice that in the PIC group decoding, we may use successive interference
  cancellation (SIC) strategy in decoding process. The main idea of this
  strategy is to remove the already-decoded symbols from the received signals
  to reduce interferences as that of the decoding process in
  (<reference|partdecodePICD>). For the properly-selected decoding order, for
  example <math|<around|(|<math-bf|x><rsub|\<cal-I\><rsub|1>>,\<cdots\>,<math-bf|x><rsub|\<cal-I\><rsub|P>>|)>>,
  we can first decode symbol subset <math|<math-bf|x><rsub|\<cal-I\><rsub|1>>>
  by the PIC group decoding to obtain the decision elements
  <math|<wide|<math-bf|x>|^><rsub|\<cal-I\><rsub|1>>>. After removing the
  already-detected symbol group <math|<wide|<math-bf|x>|^><rsub|\<cal-I\><rsub|1>>>
  from (<reference|Normal>)

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|Y><rsub|1>=<math-bf|Y>-<sqrt|<frac|\<rho\>|M<rsub|t>>>*\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)><wide|<math-bf|x>|^><rsub|\<cal-I\><rsub|1>><eq-number><label|ww>>>>>>

  we decode <math|<wide|<math-bf|x>|^><rsub|\<cal-I\><rsub|2>>> from
  (<reference|ww>) by the PIC group decoding. Repeat this process till all
  symbols are decoded. Then, the full diversity criterion for the ordered PIC
  group decoding for the STF code in terms of the PEP performance can be
  similarly stated in <cite|Xia09>.

  <with|font-shape|italic|Theorem 2.2:> For an SF/STF
  <math|<math-bf|X><around|(|<math-bf|x>|)>\<in\>\<cal-X\>> with the ordered
  SIC group decoding, full diversity is achieved when code <math|X> satisfies
  the full rank criterion, i.e., it achieves full diversity when the ML
  receiver is deployed; and at each decoding stage, for the
  <math|p<rsup|t*h>> dimension-reduced equivalent channel
  <math|\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>>
  corresponding to the current to-be decoded symbol subset
  <math|<math-bf|x><rsub|\<cal-I\><rsub|p>>>, any nonzero linear combination
  over <math|\<Delta\>*\<cal-A\>> of vectors in
  <math|\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>> does not
  belong to the space linearly spanned by all vectors in subsets
  <math|<around|{|\<cal-H\><rsub|\<cal-I\><rsub|p+1>><around|(|<math-bf|h>|)>,\<cdots\>,\<cal-H\><rsub|\<cal-I\><rsub|P>><around|(|<math-bf|h>|)>|}>>
  for any <math|<math-bf|h>\<neq\>0>.

  The proof of Theorem 2.1 and Theorem 2.2 can be found in Ref.<cite|Xia09>
  while deriving the PIC decoding criteria for the STBC in the Guo-Xia's main
  theorem.

  We note that for the ZF receiver, the estimate
  <math|<wide|<math-bf|x>|^><rsup|Z*F>> of the transmitted symbols
  <math|<math-bf|x>> embedded in <math|<math-bf|X><around|(|<math-bf|x>|)>>
  is

  <eqnarray|<tformat|<table|<row|<cell|<wide|<math-bf|x>|^><rsup|Z*F>=arg
  min<rsub|<math-bf|x>\<in\>\<cal-A\><rsup|\<eta\>>><around|\<\|\|\>|<with|math-font-family|bf|\<Gamma\>><rsup|Z*F><around|(|<math-bf|h>|)><math-bf|Y>-<math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F,<eq-number><label|esta1>>>>>>

  where <math|<with|math-font-family|bf|\<Gamma\>><rsup|Z*F>=<sqrt|<frac|M<rsub|t>|\<rho\>>>*<around|[|\<cal-H\><around|(|<math-bf|h>|)><rsup|<mathrm>>*H*\<cal-H\><around|(|<math-bf|h>|)>|]><rsup|-1>*\<cal-H\><around|(|<math-bf|h>|)><rsup|<mathrm>>*H>.
  For the ML receiver the estimate <math|<wide|<math-bf|x>|^><rsup|M*L>> is
  given by

  <eqnarray|<tformat|<table|<row|<cell|<wide|<math-bf|x>|^><rsup|M*L>=arg
  min<rsub|<math-bf|x>\<in\>\<cal-A\><rsup|\<eta\>>><around|\<\|\|\>|<math-bf|Y>-<sqrt|<frac|\<rho\>|M<rsub|t>>>*\<cal-H\><around|(|<math-bf|h>|)><math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F.<eq-number><label|esta2>>>>>>

  The decoding complexity is defined as the number of squared Frobenious
  norms <math|\<\|\|\>\<cdot\>\<\|\|\><rsub|<mathrm>>F> computed in decoding
  process. Consequently, the decoding complexity of the ZF detection for the
  SF/STF code is <math|\<eta\><around|\||\<cal-A\>|\|>> while the decoding
  complexity of the ML detection is <math|<around|\||\<cal-A\>|\|><rsup|\<eta\>>>.
  However, the complexity of the PIC group decoding algorithm for the present
  SF/STF code is calculated as <math|<big|sum><rsub|p=1><rsup|P><around|\||\<cal-A\>|\|><rsup|\<eta\><rsub|p>>>.
  It implies that the PIC group decoding for the SF/STF code has also
  provided a flexible decoding complexity as that of the STFC, which is a
  tradeoff between the ZF decoding and the ML decoding. In particular, if
  <math|P=1>, then the grouping scheme of the SF/STF code is
  <math|\<cal-I\>=<around|{|\<cal-I\><rsub|1>|}>> and then the PIC group
  decoding is equivalent to the ML decoding where all information symbols in
  <math|<math-bf|x>> are jointly decoded. If <math|P=\<eta\>>, then the
  grouping scheme is <math|\<cal-I\>=<around|{|\<cal-I\><rsub|1>,\<cdots\>,\<cal-I\><rsub|\<eta\>>|}>>
  with <math|\<cal-I\><rsub|i>=<around|{|i|}>>,
  <math|\<forall\><nbsp>i\<in\><around|{|1,\<cdots\>,\<eta\>|}>> and then the
  PIC group decoding is equivalent to the ZF decoding where each information
  symbol can be decoded independently.

  <section|SF/STF Coding Design Criterion with the PIC Group Decoding>

  In this section, we consider a design criterion for the linear dispersion
  SF/STF code that achieves full diversity with the PIC group decoding. The
  present design is derived from the STBC design criterion for the
  flat-fading channels <cite|Xia09> with appropriate adjustments.

  As for the performance of a decoding algorithm for an MIMO-OFDM system, it
  is related to the diversity order. For an MIMO-OFDM system with
  <math|M<rsub|t>> transmit antennas, <math|M<rsub|r>> receiver antennas and
  <math|L> independent channel taps, the maximum diversity order is
  <math|L*M<rsub|t>*M<rsub|r>>. While optimizing the reception performance of
  this system, full diversity is usually pursued which can be achieved by
  using a suitable signal transmitting scheme. Thus the
  \Prank-and-determinant criterion" of the SF/STF code design was proposed to
  maximize both the diversity gain and coding gain with the ML decoding. In
  order to achieve full diversity with the PIC group decoding, the STBC
  design criterion has been derived for flat-fading channels <cite|Xia09>.
  However, the code design of the full-diversity SF/STF code with the PIC
  group decoding still remains an open problem.

  In order to analyze full diversity of the SF/STF codes, we consider the
  system model in (<reference|Normal>). For any two distinct complex numbers
  <math|x<rsub|u>,x<rsub|v>\<in\>\<cal-A\>> and two distinct complex vectors
  <math|<math-bf|x><rsub|u>,<math-bf|x><rsub|v>\<in\>\<cal-A\><rsup|\<eta\>>>,
  we take notations <math|\<Delta\>*x=x<rsub|u>-x<rsub|v>\<in\>\<Delta\>*\<cal-A\>>
  and <math|\<Delta\><math-bf|x>=<math-bf|x><rsub|u>-<math-bf|x><rsub|v>\<in\>\<Delta\>*\<cal-A\><rsup|\<eta\>>>,
  respectively.

  <with|font-shape|italic|Definition 3.1:> The channel system in
  (<reference|Normal>) achieves diversity order
  <math|d=<big|prod><rsub|i=1><rsup|4>r<rsub|i>> with the ML receiver if the
  equivalent channel <math|\<cal-H\><around|(|<math-bf|h>|)>=<around|{|\<cal-H\><rsub|\<cal-I\><rsub|p>>:1\<leq\>p\<leq\>P|}>>
  satisfy the following inequality

  <eqnarray|<tformat|<table|<row|<cell|\<\|\|\>\<cal-H\><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><around|\|||\|><rsub|<mathrm>>*F<rsup|2>\<geq\><space|-0.17em>c\<cdot\><space|-0.17em><space|-0.17em><space|-0.17em><big|sum><rsub|i<rsub|\<nu\>>=1><rsup|r<rsub|1>><big|sum><rsub|j<rsub|\<nu\>>=1><rsup|r<rsub|2>><big|sum><rsub|k<rsub|\<nu\>>=1><rsup|r<rsub|3>><big|sum><rsub|n<rsub|\<nu\>>=1><rsup|r<rsub|4>><around|\||H<rsub|i<rsub|\<nu\>>,j<rsub|\<mu\>>><rsup|k<rsub|\<nu\>>><around|(|n<rsub|\<nu\>>|)>|\|><rsup|2><space|-0.17em>\<cdot\><space|-0.17em><around|\<\|\|\>|\<Delta\><math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F<rsup|2>,<eq-number><label|channelmodelconditions>>>>>>

  or

  <eqnarray|<tformat|<table|<row|<cell|\<\|\|\>\<cal-H\><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><around|\|||\|><rsub|<mathrm>>*F<rsup|2>\<geq\>c<space|-0.17em>\<cdot\><space|-0.17em><space|-0.17em><space|-0.17em><big|sum><rsub|i<rsub|\<nu\>>=1><rsup|r<rsub|1>><big|sum><rsub|j<rsub|\<nu\>>=1><rsup|r<rsub|2>><big|sum><rsub|k<rsub|\<nu\>>=1><rsup|r<rsub|3>><big|sum><rsub|l<rsub|\<nu\>>=1><rsup|r<rsub|4>><around|\||\<alpha\><rsub|i<rsub|\<nu\>>,j<rsub|\<mu\>>><rsup|k<rsub|\<nu\>>><around|(|l<rsub|\<nu\>>|)>|\|><rsup|2><space|-0.17em>\<cdot\><space|-0.17em><around|\<\|\|\>|\<Delta\><math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F<rsup|2>,<eq-number><label|channelmodelconditions>>>>>>

  where <math|c> is a positive constant, <math|<around|{|i<rsub|1>,\<cdots\>,i<rsub|r<rsub|1>>|}>\<subseteq\><around|{|1,\<cdots\>,M<rsub|t>|}>>,
  <math|<around|{|j<rsub|1>,\<cdots\>,j<rsub|r<rsub|2>>|}>\<subseteq\><around|{|1,\<cdots\>,M<rsub|r>|}>>,
  <math|<around|{|k<rsub|1>,\<cdots\>,k<rsub|r<rsub|3>>|}>\<subseteq\><around|{|1,\<cdots\>,M<rsub|b>|}>>,
  <math|<around|{|n<rsub|1>,\<cdots\>,n<rsub|r<rsub|4>>|}>\<subseteq\><around|{|0,\<cdots\>,N-1|}>>,
  and <math|<around|{|l<rsub|1>,\<cdots\>,l<rsub|r<rsub|4>>|}>\<subseteq\><around|{|0,\<cdots\>,L-1|}>>.

  <with|font-shape|italic|Theorem 3.1:> Consider the channel model in
  (<reference|finall>) with the given linear dispersion
  <math|<math-bf|X>\<in\>\<cal-X\>> for signal constellation
  <math|\<cal-A\>>. Let <math|\<cal-H\><around|(|<math-bf|h>|)>> be the
  equivalent channel of <math|<math-bf|X>> for any
  <math|<math-bf|h>\<neq\>0>. If the <math|\<eta\>> column vectors of
  <math|\<cal-H\><around|(|<math-bf|h>|)>> are linearly independent over
  <math|\<Delta\>*\<cal-A\>>, then the coding scheme <math|\<cal-X\>> has
  power gain order <math|L*M<rsub|t>*M<rsub|r>*M<rsub|b>> and hence achieves
  diversity order <math|L*M<rsub|t>*M<rsub|r>*M<rsub|b>>.

  <with|font-shape|italic|Proof:> The proof can be found in Appendix A.

  <with|font-shape|italic|Theorem 3.2:> For an arbitrary linear dispersion
  <math|<math-bf|X>\<in\>\<cal-X\>> of the SF/STF code with the equivalent
  channel <math|\<cal-H\><around|(|<math-bf|h>|)>> for any
  <math|<math-bf|h>\<neq\>0>, it has the full rank property if and only if
  the <math|\<eta\>> column vectors of <math|\<cal-H\><around|(|<math-bf|h>|)>>
  are linearly independent over <math|\<Delta\>*\<cal-A\>>.

  <with|font-shape|italic|Proof:> The proof can be found in Appendix B.

  Next we derive an SF/STF code design criterion based on the PIC group
  decoding.

  <with|font-shape|italic|Theorem 3.3:> Consider the linear dispersion SF/STF
  code <math|<math-bf|X>\<in\>\<cal-X\>>. The communication system in
  (<reference|finall>) has <math|M<rsub|t>> transmit antennas,
  <math|M<rsub|r>> receive antennas, <math|N> subcarriers corresponding to
  <math|L> independent channel taps with <math|P> equivalent channel groups,
  <math|<around|{|\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>\<in\>\<bbb-C\><rsup|N*M<rsub|r>*M<rsub|b>\<times\>\<eta\><rsub|p>>:1\<leq\>p\<leq\>P|}>>.
  The received signal is decoded with the PIC group decoding via grouping
  index sets <math|<around|{|\<cal-I\><rsub|p>:1\<leq\>p\<leq\>P|}>>. Then
  each dimension-reduced system

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|Z><rsub|\<cal-I\><rsub|p>>=<sqrt|<frac|\<rho\>|M<rsub|t>>>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|x><rsub|\<cal-I\><rsub|p>>+<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|N>,<eq-number><label|PICD>>>>>>

  has diversity gain order <math|L*M<rsub|t>*M<rsub|r>*M<rsub|b>> if and only
  if

  <\itemize>
    <item>1) Full-diversity Criteria: for any two linear dispersions
    <math|<math-bf|X>> and <math|<wide|<math-bf|X>|~>> corresponding to
    distinct codewords <math|<math-bf|C>> and <math|<wide|<math-bf|C>|~>>,
    matrix <math|\<Delta\><math-bf|X>=<math-bf|X>-<wide|<math-bf|X>|~>\<in\>\<cal-X\>>
    has the full rank;

    <item>2) Linear-independent Criteria: for an arbitrary subset
    <math|\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>>, any
    non-zero linear combination over <math|\<Delta\>*\<cal-A\>> of the
    <math|\<eta\><rsub|p>> column vectors in
    <math|\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>> does not
    belong to the linear space spanned by all vectors in the remaining
    <math|P-1> subsets <math|<around|{|\<cal-H\><rsub|\<cal-I\><rsub|q>><around|(|<math-bf|h>|)>:q\<neq\>p|}>>
    of the equivalent channel <math|\<cal-H\><around|(|<math-bf|h>|)>>.
  </itemize>

  <with|font-shape|italic|Proof:> The proof can be found in Appendix C.

  Recently, the SF/STF code design criteria for multiple access channels has
  been introduced on the basis of the error event analysis with different
  error regions <cite|tner05|Gallager85>. For the region where a single error
  event dominates, the well known SF code for a single OFDM block, i.e.,
  <math|M<rsub|b>=1>, can work well. However, for the region where more than
  one OFDM blocks, i.e., <math|M<rsub|b>\<geq\>2>, in error dominate, it
  requires a joint OFDM block design criteria. In the following, we shall
  show the PEP performance for multiple access channels with multiple OFDM
  blocks.

  Let <math|<math-bf|C>=<around|[|<math-bf|C><rsub|1><rsup|<mathrm>>T<nbsp><math-bf|C><rsub|2><rsup|<mathrm>>T<nbsp>\<cdots\><nbsp><math-bf|C><rsub|M<rsub|b>><rsup|<mathrm>>T|]><rsup|<mathrm>>*T>
  and <math|<wide|<math-bf|C>|~>=<around|[|<wide|<math-bf|C>|~><rsub|1><rsup|<mathrm>>T<nbsp><wide|<math-bf|C>|~><rsub|2><rsup|<mathrm>>T<nbsp>\<cdots\><nbsp><wide|<math-bf|C>|~><rsub|M<rsub|b>><rsup|<mathrm>>T|]><rsup|<mathrm>>*T>
  be the transmitted and received codeword, respectively. We consider the PEP
  denoted by <math|\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>|)>>.
  Let <math|\<Omega\><rsub|k>> be the set of block index <math|k> such that
  <math|<math-bf|C><rsub|k>\<neq\><wide|<math-bf|C>|~><rsub|k>>,
  <math|\<forall\><nbsp>k\<in\>\<Omega\><rsub|k>\<subseteq\><around|{|1,\<cdots\>,M<rsub|b>|}>>.
  As an example, taking <math|k=1>, we have
  <math|\<Omega\><rsub|1>=<around|{|<around|{|1|}>,\<cdots\>,<around|{|\<Omega\><rsub|M<rsub|b>>|}>|}>>.
  Then, for <math|<math-bf|C>\<neq\><wide|<math-bf|C>|~>>, we have
  <math|<around|\||\<Omega\><rsub|k>|\|>\<geq\>1>, and hence
  <math|<math-bf|C><rsub|\<Omega\>>\<triangleq\><around|{|<math-bf|C><rsub|k>\<neq\><wide|<math-bf|C>|~><rsub|k>:k\<in\>\<Omega\><rsub|k>|}>>.
  Consequently, the PEP <math|\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>|)>>
  is given by

  <eqnarray|<tformat|<table|<row|<cell|\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>|)>>|<cell|=>|<cell|<big|sum><rsub|k=1><rsup|M<rsub|b>><big|sum><rsub|\<Omega\><rsub|k>>\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>,<math-bf|C><rsub|\<Omega\><rsub|k>>|)><eq-number><label|PEP>>>>>>

  The terms in (<reference|PEP>) characterize all error events of the
  pairwise codeword error corresponding to
  <math|<around|(|<math-bf|C>,<wide|<math-bf|C>|~>|)>>. Without loss of
  generality, we take <math|M<rsub|b>=2> as an example to illustrate the PEP
  of the STF code. Then we have

  <eqnarray|<tformat|<table|<row|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>|)><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>=<space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><big|sum><rsub|k\<in\><around|{|1,2|}>>\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>,<math-bf|C><rsub|k>\<neq\><wide|<math-bf|C>|~><rsub|k>|)><eq-number><label|PEP2>>>|<row|<cell|>|<cell|=>|<cell|\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>,<math-bf|C><rsub|1>\<neq\><wide|<math-bf|C>|~><rsub|1>,<math-bf|C><rsub|2>=<wide|<math-bf|C>|~><rsub|2>|)><eq-number>>>|<row|<cell|>|<cell|>|<cell|+\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>,<math-bf|C><rsub|1>=<wide|<math-bf|C>|~><rsub|1>,<math-bf|C><rsub|2>\<neq\><wide|<math-bf|C>|~><rsub|2>|)><eq-number>>>|<row|<cell|>|<cell|>|<cell|+\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>,<math-bf|C><rsub|1>\<neq\><wide|<math-bf|C>|~><rsub|1>,<math-bf|C><rsub|2>\<neq\><wide|<math-bf|C>|~><rsub|2>|)>.<eq-number>>>>>>

  We note that the first term in (<reference|PEP2>) implies the error
  probability of the event that only the first block
  <math|<math-bf|C><rsub|1>> is in error. Namely, for the single block
  <math|<math-bf|C><rsub|1>> with the coding gain <math|c<rsub|1>> and rank
  <math|d<rsub|1>=M<rsub|r>\<cdot\>min<rsub|<math-bf|C><rsub|1>\<neq\><wide|<math-bf|C>|~><rsub|1>><math-up|rank><around|(|<math-bf|C>-<wide|<math-bf|C>|~>|)>>,
  we have

  <eqnarray|<tformat|<table|<row|<cell|\<cal-P\><rsub|10>>|<cell|=>|<cell|\<cal-P\>*<around|(|<math-bf|C><rsub|1>\<rightarrow\><wide|<math-bf|C>|~><rsub|1>,<math-bf|C><rsub|1>\<neq\><wide|<math-bf|C>|~><rsub|1>,<math-bf|C><rsub|2>=<wide|<math-bf|C>|~><rsub|2>|)><eq-number><label|PEPterm1>>>|<row|<cell|>|<cell|=>|<cell|\<cal-P\>*<around|(|<math-bf|C><rsub|1>\<rightarrow\><wide|<math-bf|C>|~><rsub|1>|)>*\<cal-P\>*<around|(|<math-bf|C><rsub|1>\<neq\><wide|<math-bf|C>|~><rsub|1>|)>*\<cal-P\>*<around|(|<math-bf|C><rsub|2>=<wide|<math-bf|C>|~><rsub|2>|)><eq-number>>>|<row|<cell|>|<cell|\<leq\>>|<cell|c<rsub|1><around|(|<frac|\<rho\>|M<rsub|t>>|)><rsup|-d<rsub|1>>*<around|(|1-\<alpha\><rsub|1>|)>*\<alpha\><rsub|2>,<eq-number>>>>>>

  where <math|\<alpha\><rsub|k>\<triangleq\>P*<around|(|<math-bf|C><rsub|k>=<wide|<math-bf|C>|~><rsub|k>|)>>,
  <math|\<forall\><nbsp>k\<in\><around|{|1,2|}>>. Similarly, the second term
  represents the error for the second block <math|<math-bf|C><rsub|2>> while
  the first block is correctly decoded, i.e.,

  <eqnarray|<tformat|<table|<row|<cell|\<cal-P\><rsub|01>>|<cell|=>|<cell|\<cal-P\>*<around|(|<math-bf|C><rsub|2>\<rightarrow\><wide|<math-bf|C>|~><rsub|2>,<math-bf|C><rsub|1>=<wide|<math-bf|C>|~><rsub|1>,<math-bf|C><rsub|2>\<neq\><wide|<math-bf|C>|~><rsub|2>|)><eq-number><label|PEPterm2>>>|<row|<cell|>|<cell|=>|<cell|\<cal-P\>*<around|(|<math-bf|C><rsub|2>\<rightarrow\><wide|<math-bf|C>|~><rsub|2>|)>*\<cal-P\>*<around|(|<math-bf|C><rsub|1>=<wide|<math-bf|C>|~><rsub|1>|)>*\<cal-P\>*<around|(|<math-bf|C><rsub|2>\<neq\><wide|<math-bf|C>|~><rsub|2>|)><eq-number>>>|<row|<cell|>|<cell|\<leq\>>|<cell|c<rsub|2><around|(|<frac|\<rho\>|M<rsub|t>>|)><rsup|-d<rsub|2>>*<around|(|1-\<alpha\><rsub|2>|)>*\<alpha\><rsub|1>.<eq-number>>>>>>

  where <math|c<rsub|2>> is the coding gain and
  <math|d<rsub|2>=M<rsub|r>\<cdot\>min<rsub|<math-bf|C><rsub|2>\<neq\><wide|<math-bf|C>|~><rsub|2>><math-up|rank><around|(|<math-bf|C>-<wide|<math-bf|C>|~>|)>>.
  The last term denotes that two blocks <math|<math-bf|C><rsub|1>> and
  <math|<math-bf|C><rsub|2>> are both in errors, i.e.,

  <eqnarray|<tformat|<table|<row|<cell|\<cal-P\><rsub|11>>|<cell|=>|<cell|\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>,<math-bf|C><rsub|1>\<neq\><wide|<math-bf|C>|~><rsub|1>,<math-bf|C><rsub|2>\<neq\><wide|<math-bf|C>|~><rsub|2>|)><eq-number><label|PEPterm3>>>|<row|<cell|>|<cell|=>|<cell|\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>|)>*\<cal-P\>*<around|(|<math-bf|C><rsub|1>\<neq\><wide|<math-bf|C>|~><rsub|1>|)>*\<cal-P\>*<around|(|<math-bf|C><rsub|2>\<neq\><wide|<math-bf|C>|~><rsub|2>|)><eq-number>>>|<row|<cell|>|<cell|\<leq\>>|<cell|c<rsub|3><around|(|<frac|\<rho\>|M<rsub|t>>|)><rsup|-d<rsub|3>>*<around|(|1-\<alpha\><rsub|1>|)>*<around|(|1-\<alpha\><rsub|2>|)>,<eq-number>>>>>>

  where <math|c<rsub|3>> is the coding gain and
  <math|d<rsub|3>=M<rsub|r>\<cdot\>min<rsub|<math-bf|C><rsub|1>\<neq\><wide|<math-bf|C>|~><rsub|1>,<math-bf|C><rsub|2>\<neq\><wide|<math-bf|C>|~><rsub|2>><math-up|rank><around|(|<math-bf|C>-<wide|<math-bf|C>|~>|)>>.
  Therefore we have the total PEP of the STF code as follows

  <eqnarray|<tformat|<table|<row|<cell|\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>|)>>|<cell|=>|<cell|\<cal-P\><rsub|10>+\<cal-P\><rsub|01>+\<cal-P\><rsub|11>.<eq-number><label|PEP12>>>>>>

  In a case that a single OFDM block is in error, the well known SF code is
  sufficient to obtain full diversity. While more than one OFDM blocks are in
  error, the joint STF code design is hence necessary. If the single-block
  full-diversity SF coding scheme is applied to each OFDM block
  independently, we get diversity gain order <math|L*M<rsub|t>*M<rsub|r>>
  which is the maximum achievable diversity gain for this kind of the STF
  codes. But for the rate region where two blocks are both in error, the PEP
  in (<reference|PEPterm3>) demonstrates that the maximum diversity gain
  should be larger than that of single blocks. This is because the joint STF
  code is a concatenation of two single-block SF codes and the maximum
  achievable diversity gain is twice of <math|<math-bf|C><rsub|1>> or
  <math|<math-bf|C><rsub|2>>. Since the maximum achievable diversity of
  <math|P<rsub|11>> in the above-mentioned example is
  <math|2*M<rsub|t>*M<rsub|r>> which can be achieved when matrix
  <math|<math-bf|C>-<wide|<math-bf|C>|~>> is of full rank for both
  <math|<math-bf|C><rsub|1>-<wide|<math-bf|C>|~><rsub|1>> and
  <math|<math-bf|C><rsub|2>-<wide|<math-bf|C>|~><rsub|2>>, it can be seen
  that single-block SF codes are not optimal for the multi-block MIMO-OFDM
  systems. An optimal STF code for multi-block MIMO-OFDM system should be
  able to achieve the full diversity in terms of the PEP
  <math|\<cal-P\><rsub|i*j>>, <math|\<forall\><nbsp>i,j\<in\><around|{|0,1|}>>.

  In a case of the STF code with <math|M<rsub|b>> blocks, the upper bound of
  the PEP <math|\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>|)>>
  is given by

  <eqnarray|<tformat|<table|<row|<cell|\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>|)>>|<cell|=>|<cell|<big|sum><rsub|k=1><rsup|M<rsub|b>><big|sum><rsub|\<Omega\><rsub|k>>\<cal-P\>*<around|(|<math-bf|C><rsub|k>\<rightarrow\><wide|<math-bf|C><rsub|k>|~>|)>*\<cal-P\>*<around|(|<math-bf|C><rsub|k>\<neq\><wide|<math-bf|C><rsub|k>|~>|)><eq-number><label|PEP12>>>|<row|<cell|>|<cell|\<leq\>>|<cell|<big|sum><rsub|k=1><rsup|M<rsub|b>>c<rsub|k><around|(|<frac|\<rho\>|M<rsub|t>>|)><rsup|d<rsub|k>>*p<around|(|<math-bf|C><rsub|\<Omega\><rsub|k>>|)><eq-number>>>>>>

  where <math|p<around|(|<math-bf|C><rsub|\<Omega\><rsub|k>>|)>> denotes the
  probability that only <math|k> out of <math|M<rsub|b>> blocks have
  <math|<math-bf|C><rsub|k>\<neq\><wide|<math-bf|C>|~><rsub|k>>, and
  <math|d<rsub|k>> is the minimum rank of matrix
  <math|<math-bf|I><rsub|M<rsub|r>>\<otimes\><around|(|<math-bf|C>-<wide|<math-bf|C>|~>|)><rsup|<mathrm>>*H*<around|(|<math-bf|C>-<wide|<math-bf|C>|~>|)>>.

  Since parameter <math|d<rsub|k>> denotes diversity order with respective to
  the PEP when <math|k> OFDM blocks are all in error, the STF code design
  should guarantee full diversity with <math|<around|{|d<rsub|k>:1\<leq\>1\<leq\>M<rsub|b>|}>>
  for all possible error events. Concisely, we can write full diversity
  design criterion of the STF code by considering the PEP performance with
  all possible error events of <math|M<rsub|b>> OFDM blocks.

  <\itemize>
    <item>3) Multi-Block PEP Criterion: Maximize all diversity gains

    <\equation>
      <label|rank>d<rsub|k>=M<rsub|r>\<cdot\><math-up|rank><around|(|<math-bf|C>-<wide|<math-bf|C>|~>|)>
    </equation>

    over all pairs of distinct codewords <math|<math-bf|C>> and
    <math|<wide|<math-bf|C>|~>> when only <math|k> out of <math|M<rsub|b>>
    OFDM blocks have <math|<math-bf|C><rsub|k>\<neq\><wide|<math-bf|C>|~><rsub|k>>.
  </itemize>

  Currently, many coding scheme of SF/STF codes were proposed with ML
  receiver. However, no explicit systematic code design is given so far with
  the PIC group decoding. In what follows, we will propose a systematic
  design of full diversity SF/STF codes of high symbol rate in terms of the
  PEP performance with the PIC group decoding.

  For a general linear disperse SF/STF code with <math|M<rsub|b>> OFDM
  blocks, we use the Chernoff bound to derive an upper bound on the average
  PEP that matrix codeword <math|<math-bf|C>> is misdecoded as
  <math|<wide|<math-bf|C>|~>>, i.e.,

  <\equation>
    <label|bound1>\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>|)>\<leq\><frac|1|<math-up|det><around|(|<math-bf|I><rsub|N*M<rsub|b>*M<rsub|r>>+<frac|\<rho\>|M<rsub|t>><math-bf|K><rsub|s>\<otimes\><math-bf|I><rsub|M*r>|)>>,
  </equation>

  where <math|<math-bf|K><rsub|s>=<around|(|<math-bf|C>-<wide|<math-bf|C>|~>|)>*<around|(|<math-bf|C>-<wide|<math-bf|C>|~>|)><rsup|<mathrm>>*H\<circ\><around|(|R<rsub|b>\<otimes\>R|)>>.
  Let <math|\<lambda\><rsub|n>> be the <math|n<rsup|t*h>> eigenvalue of
  <math|<math-bf|K><rsub|s>>. For high SNR, the PEP bound in
  (<reference|bound1>) can be rewritten as

  <\equation>
    <label|bound2>\<cal-P\>*<around|(|<math-bf|C>\<rightarrow\><wide|<math-bf|C>|~>|)>\<leq\><frac|1|<around|(|<frac|\<rho\>|M<rsub|t>>|)><rsup|<math-up|rank><around|(|<math-bf|K><rsub|s>|)>*M<rsub|r>>*<big|prod><rsub|n=1><rsup|<math-up|rank><around|(|<math-bf|K><rsub|s>|)>>\<lambda\><rsub|n><rsup|M<rsub|r>>>.
  </equation>

  Let two sequences <math|<around|{|x<rsub|i>:i\<in\>\<cal-I\>|}>> and
  <math|<around|{|<wide|x|~><rsub|i>:i\<in\>\<cal-I\>|}>> be the transmitted
  sequence corresponding to <math|<math-bf|C>> and the received sequence
  corresponding to <math|<wide|<math-bf|C>|~>>, respectively. The difference
  matrix <math|<math-bf|K><rsub|s>> can be calculated by

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|K><rsub|s>>|<cell|=>|<cell|<around|(|<big|sum><rsub|i=1><rsup|\<eta\>><math-bf|A><rsub|i>\<Delta\>*x<rsub|i>|)><around|(|<big|sum><rsub|i=1><rsup|\<eta\>><math-bf|A><rsub|i>\<Delta\>*x<rsub|i>|)><rsup|<mathrm>>*H\<circ\><around|(|R<rsub|b>\<otimes\>R|)><eq-number><label|difference1>>>|<row|<cell|>|<cell|=>|<cell|<around|(|<big|sum><rsub|i*1=1><rsup|\<eta\>><big|sum><rsub|i*2=1><rsup|\<eta\>><math-bf|A><rsub|i*1><math-bf|A><rsub|i*2><rsup|<mathrm>>H*\<Delta\>*x<rsub|i*1>*\<Delta\>*x<rsub|i*2><rsup|<mathrm>>*H|)>\<circ\><around|(|R<rsub|b>\<otimes\>R|)>.<eq-number>>>>>>

  We note that the rank of <math|<math-bf|K><rsub|s>> depends on all possible
  different linear combinations of matrices
  <math|<math-bf|A><rsub|i*1><math-bf|A><rsub|i*2><rsup|<mathrm>>H>. Namely,
  we have

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|K><rsub|s>=<around*|[|\<Delta\><math-bf|x><rsup|<mathrm>>H*\<Lambda\><rsub|s>*\<Delta\><math-bf|x>|]>\<circ\><space|-0.17em><around|(|R<rsub|b>\<otimes\>R|)>,<eq-number><label|difference111>>>>>>

  where <math|\<Delta\><math-bf|x>=<around|(|\<Delta\>*x<rsub|1>,\<cdots\>,\<Delta\>*x<rsub|\<eta\>>|)><rsup|<mathrm>>*T>,
  and

  <\equation*>
    \<Lambda\><rsub|s>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<math-bf|A><rsub|1><rsup|<mathrm>>H<math-bf|A><rsub|1>>|<cell|<space|-0.17em><space|-0.17em>\<cdots\>>|<cell|<space|-0.17em><space|-0.17em><math-bf|A><rsub|1><rsup|<mathrm>>H<math-bf|A><rsub|\<eta\>>>>|<row|<cell|\<vdots\>>|<cell|<space|-0.17em><space|-0.17em>\<ddots\>>|<cell|<space|-0.17em><space|-0.17em>\<vdots\>>>|<row|<cell|<math-bf|A><rsub|\<eta\>><rsup|<mathrm>>H<math-bf|A><rsub|1>>|<cell|<space|-0.17em><space|-0.17em>\<cdots\>>|<cell|<space|-0.17em><space|-0.17em><math-bf|A><rsub|\<eta\>><rsup|<mathrm>>H<math-bf|A><rsub|\<eta\>>>>>>>|]>.
  </equation*>

  It can be shown that matrix <math|\<Lambda\><rsub|s>> is Hermitian
  semi-definite, and matrix <math|<math-bf|K><rsub|s>> is Hermitian
  semi-definite since <math|\<eta\>> is typically greater than
  <math|M<rsub|t>> for the high rate SF/STF code. A necessary condition for
  <math|\<cal-A\><rsub|s>> to be full rank is that each submatrix has the
  constraint <math|\<Delta\>*x<rsub|i><rsup|\<ast\>><math-bf|A><rsub|i><rsup|<mathrm>>H<math-bf|A><rsub|i>\<Delta\>*x<rsub|i>\<neq\>0>,
  <math|\<forall\><nbsp>i\<in\>\<cal-I\>>.

  According to the rank inequalities of Hadamard products and Keronecker
  products in (<reference|difference111>), the diversity of the present STF
  code can be bounded by dimensions of codeword matrices, which is summarized
  as follows.

  <with|font-shape|italic|Theorem 3.4:> The diversity of a linear dispersion
  STF code is less than or equal to <math|M<rsub|r>*min
  <around|{|L*M<rsub|t><math-up|rank><around|(|R<rsub|b>|)>,N*M<rsub|b>|}>>.

  <with|font-shape|italic|Proof:> The proof can be found in Appendix D.

  It is necessary to note that in a case the frequency-selective channels
  stay constant over multiple OFDM block, i.e.,
  <math|<math-up|rank><around|(|R<rsub|b>|)>=1>, the maximum diversity is at
  most <math|M<rsub|r>*min <around|{|L*M<rsub|t>,N*M<rsub|b>|}>>. In this
  case, the STF code can not provide additional diversity advantage compared
  to the SF code, which will be illustrated in next section.

  <section|Designs of the Stacked STF Codes with Multi-layer Structure>

  The design of the STF code <math|<math-bf|C><rsub|S*T*F>> is based on the
  full-diversity SF code <math|<math-bf|C><rsub|S*F>> of size
  <math|N\<times\>M<rsub|t>>. Therefore, <math|<math-bf|C><rsub|S*T*F>> can
  be simply constructed by repeating <math|<math-bf|C><rsub|S*F>> multiple
  times. However, the symbol rate of this code can not be increased so much.
  In order to design a high symbol rate SF/STF code we propose an STF coding
  scheme with the multi-layer structure that achieves full diversity with the
  PIC group decoding.

  <subsection|The STF Codes with STBC Structure>

  <with|font-shape|italic|Example 4.1:> Consider the Alamouti code with
  <math|M<rsub|t>=2>, <math|M<rsub|b>=1>, <math|M<rsub|r>=1>, <math|N=2>, and
  <math|P=2>. Then the STF code, which is actually an SF code, can be
  designed as

  <\equation>
    <label|equa1><math-bf|C><rsub|<math-up|STF>>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|s<rsub|1,1>>|<cell|s<rsub|2,1>>>|<row|<cell|-s<rsub|2,1><rsup|\<ast\>>>|<cell|s<rsub|1,1><rsup|\<ast\>>>>>>>|]>,
  </equation>

  where <math|<math-bf|s><rsub|i>=<around|{|s<rsub|i,1>|}>=<around|{|x<rsub|i>|}>>,
  <math|\<forall\><nbsp>i\<in\><around|{|1,2|}>>. The symbol rate of this
  code is one. Let <math|<math-bf|h>\<triangleq\><around|[|H<rsub|i,1><around|(|0|)>,H<rsub|i,1><around|(|1|)>|]>=<around|[|H<rsup|1><rsub|i,1><around|(|0|)>,H<rsup|1><rsub|i,1><around|(|1|)>|]>>
  with the grouping scheme <math|\<cal-I\>=<around|{|\<cal-I\><rsub|1>,\<cal-I\><rsub|2>|}>=<around|{|<around|{|1|}>,<around|{|2|}>|}>>.
  Then the equivalent channel matrix can be written as

  <\equation>
    <label|ch1>\<cal-H\><around|(|<math-bf|h>|)>=<around|[|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>|]>,
  </equation>

  where

  <\equation*>
    \<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|H<rsub|1,1><around|(|0|)>>>|<row|<cell|H<rsub|2,1><rsup|\<ast\>><around|(|1|)>>>>>>|]>,<nbsp>\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|H<rsub|2,1><around|(|0|)>>>|<row|<cell|-H<rsub|1,1><rsup|\<ast\>><around|(|1|)>>>>>>|]>.
  </equation*>

  It is obvious that <math|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>>
  and <math|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>> are
  linear independent for <math|<math-bf|h>\<neq\>0>. Through the direct
  calculation, the projection matrices <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>>>
  and <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>>> can
  be derived as

  <eqnarray|<tformat|<table|<row|<cell|<space|-0.17em><space|-0.17em>>|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>>=h<rsup|1><rsub|0>\<cdot\><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<around|\||H<rsub|1,1><around|(|1|)>|\|><rsup|2>>|<cell|H<rsub|1,1><around|(|1|)>*H<rsub|2,1><around|(|0|)>>>|<row|<cell|H<rsub|1,1><rsup|\<ast\>><around|(|1|)>*H<rsub|2,1><rsup|\<ast\>><around|(|0|)>>|<cell|<around|\||H<rsub|2,1><around|(|0|)>|\|><rsup|2>>>>>>|]>,<eq-number><label|222>>>>>>

  and

  <eqnarray|<tformat|<table|<row|<cell|<space|-0.17em><space|-0.17em>>|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>>=h<rsup|1><rsub|1>\<cdot\><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<around|\||H<rsub|2,1><around|(|1|)>|\|><rsup|2>>|<cell|-H<rsub|2,1><around|(|1|)>*H<rsub|1,1><around|(|0|)>>>|<row|<cell|-H<rsub|2,1><rsup|\<ast\>><around|(|1|)>*H<rsub|1,1><rsup|\<ast\>><around|(|0|)>>|<cell|<around|\||H<rsub|1,1><around|(|0|)>|\|><rsup|2>>>>>>|]>,<eq-number>>>>>>

  where <math|h<rsup|1><rsub|0>=<around|(|<around|\||H<rsub|2,1><around|(|0|)>|\|><rsup|2>+<around|\||H<rsub|1,1><around|(|1|)>|\|><rsup|2>|)><rsup|-1>>
  and <math|h<rsup|1><rsub|1>=<around|(|<around|\||H<rsub|2,1><around|(|0|)>|\|><rsup|2>+<around|\||H<rsub|1,1><around|(|1|)>|\|><rsup|2>|)><rsup|-1>>.
  After passing the received signal vector <math|<math-bf|Y>> in
  (<reference|Normal>) through two linear filters
  <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>>> and
  <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>>>, the
  optimal detections of <math|x<rsub|1>> and <math|x<rsub|2>> can be achieved
  as

  <eqnarray|<tformat|<table|<row|<cell|<wide|x|^><rsub|1>>|<cell|=>|<cell|arg
  min<rsub|<wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|1>>\<in\>\<cal-A\>>\<parallel\><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>><math-bf|Y>-<sqrt|<frac|\<rho\>|2>>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>>*\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)><wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|1>>\<parallel\><rsub|<mathrm>>F<eq-number><label|kk>>>|<row|<cell|>|<cell|=>|<cell|arg
  min<rsub|<wide|x|\<bar\>><rsub|0>\<in\>\<cal-A\>>\<mid\>H<rsub|1,1><rsup|\<ast\>><around|(|1|)>*Y<rsub|1><around|(|0|)>+H<rsub|2,1><around|(|0|)>*Y<rsub|1><around|(|1|)><eq-number>>>|<row|<cell|>|<cell|>|<cell|+<sqrt|<frac|\<rho\>|2>>*<around|(|<around|\||H<rsub|1,1><around|(|0|)>|\|><rsup|2>+<around|\||H<rsub|2,1><around|(|1|)>|\|><rsup|2>|)>*<wide|x|\<bar\>><rsub|0>\<mid\>,<eq-number>>>>>>

  and

  <eqnarray|<tformat|<table|<row|<cell|<wide|x|^><rsub|2>>|<cell|=>|<cell|arg
  min<rsub|<wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|2>>\<in\>\<cal-A\>>\<parallel\><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>><math-bf|Y>-<sqrt|<frac|\<rho\>|2>>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>>*\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)><wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|2>>\<parallel\><rsub|<mathrm>>F<eq-number>>>|<row|<cell|>|<cell|=>|<cell|arg
  min<rsub|<wide|x|\<bar\>><rsub|1>\<in\>\<cal-A\>>\<mid\>H<rsub|2,1><rsup|\<ast\>><around|(|1|)>*Y<rsub|1><around|(|0|)>-H<rsub|1,1><around|(|0|)>*Y<rsub|1><around|(|1|)><eq-number>>>|<row|<cell|>|<cell|>|<cell|+<sqrt|<frac|\<rho\>|2>>*<around|(|<around|\||H<rsub|2,1><around|(|0|)>|\|><rsup|2>+<around|\||H<rsub|1,1><around|(|1|)>|\|><rsup|2>|)>*<wide|x|\<bar\>><rsub|1>\<mid\>.<eq-number>>>>>>

  <with|font-shape|italic|Example 4.2:> Consider the Alamouti code with
  <math|M<rsub|b>=2>, <math|M<rsub|t>=2>, <math|M<rsub|r>=1>, <math|N=2>, and
  <math|P=2>. Then the STF code with two OFDM blocks can be designed as

  <\equation>
    <label|equa2><math-bf|C><rsub|<math-up|STF>>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|s<rsub|1,1>>|<cell|s<rsub|2,1>>>|<row|<cell|-s<rsub|2,1><rsup|\<ast\>>>|<cell|s<rsub|1,1><rsup|\<ast\>>>>|<row|<cell|s<rsub|1,2>>|<cell|s<rsub|2,2>>>|<row|<cell|-s<rsub|2,2><rsup|\<ast\>>>|<cell|s<rsub|1,2><rsup|\<ast\>>>>>>>|]>,
  </equation>

  where <math|<math-bf|s><rsub|i>=<around|(|s<rsub|i,1>,s<rsub|i,2>|)><rsup|<mathrm>>*T=<around|(|x<rsub|2*i-2>,x<rsub|2*i-1>|)><rsup|<mathrm>>*T>,
  <math|\<forall\><nbsp>i\<in\><around|{|1,2|}>>. Let
  <math|<math-bf|h>\<triangleq\><around|[|H<rsub|i,1><around|(|0|)>,H<rsub|i,1><around|(|1|)>,H<rsub|i,1><around|(|2|)>,H<rsub|i,1><around|(|3|)>|]>=<around|[|H<rsup|1><rsub|i,1><around|(|0|)>,H<rsup|1><rsub|i,1><around|(|1|)>,H<rsup|2><rsub|i,1><around|(|0|)>,H<rsup|2><rsub|i,1><around|(|1|)>|]>>
  with the grouping scheme <math|\<cal-I\>=<around|{|\<cal-I\><rsub|1>,\<cal-I\><rsub|2>|}>=<around|{|<around|{|0,1|}>,<around|{|2,3|}>|}>>.
  Then the equivalent channel matrix can be written as follows

  <\equation>
    <label|ch1>\<cal-H\><around|(|<math-bf|h>|)>=<around|[|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>|]>,
  </equation>

  where

  <\equation*>
    \<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|H<rsub|1,1><around|(|0|)>>|<cell|0>>|<row|<cell|H<rsub|2,1><rsup|\<ast\>><around|(|1|)>>|<cell|0>>|<row|<cell|0>|<cell|H<rsub|1,1><around|(|2|)>>>|<row|<cell|0>|<cell|H<rsub|2,1><rsup|\<ast\>><around|(|3|)>>>>>>|]>,
  </equation*>

  and

  <\equation*>
    \<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|H<rsub|2,1><around|(|0|)>>|<cell|0>>|<row|<cell|-H<rsub|1,1><rsup|\<ast\>><around|(|1|)>>|<cell|0>>|<row|<cell|0>|<cell|H<rsub|2,1><around|(|2|)>>>|<row|<cell|0>|<cell|-H<rsub|1,1><rsup|\<ast\>><around|(|3|)>>>>>>|]>.
  </equation*>

  It is obvious that <math|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>>
  and <math|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>> are
  linear independent. Namely, an arbitrary column vector of
  <math|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>> does not
  belong to the linear space spanned by all column vectors of
  <math|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>> over
  <math|\<Delta\>*\<cal-A\>>. According to (<reference|PICh>), two projection
  matrices <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>>>
  and <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>>> can
  be obtained as

  <eqnarray|<tformat|<table|<row|<cell|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>><rsup|<around|(|0|)>>>|<cell|<with|math-font-family|bf|0><rsub|2\<times\>2>>>|<row|<cell|<with|math-font-family|bf|0><rsub|2\<times\>2>>|<cell|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>><rsup|<around|(|1|)>>>>>>>|]>,<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>><rsup|<around|(|0|)>>>|<cell|<with|math-font-family|bf|0><rsub|2\<times\>2>>>|<row|<cell|<with|math-font-family|bf|0><rsub|2\<times\>2>>|<cell|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>><rsup|<around|(|1|)>>>>>>>|]>,<eq-number>>>>>>

  where <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>><rsup|<around|(|i|)>>>
  and <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>><rsup|<around|(|i|)>>>
  can be calculated from the formulas in

  <eqnarray|<tformat|<table|<row|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>><rsup|<around|(|i|)>>=h<rsup|<around|(|2|)>><rsub|i><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<around|\||H<rsub|1,1>*<around|(|i+1|)>|\|><rsup|2>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>H<rsub|1,1>*<around|(|i+1|)>*H<rsub|2,1><around|(|i|)>>>|<row|<cell|H<rsub|1,1><rsup|\<ast\>>*<around|(|i+1|)>*H<rsub|2,1><rsup|\<ast\>><around|(|i|)>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><around|\||H<rsub|2,1><around|(|i|)>|\|><rsup|2>>>>>>|]>,<eq-number><label|333>>>>>>

  and

  <eqnarray|<tformat|<table|<row|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>><rsup|<around|(|i|)>>=h<rsup|<around|(|2|)>><rsub|i+1><around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><around|\||H<rsub|2,1>*<around|(|i+1|)>|\|><rsup|2>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>-H<rsub|2,1>*<around|(|i+1|)>*H<rsub|1,1><around|(|i|)>>>|<row|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>-H<rsub|2,1><rsup|\<ast\>>*<around|(|i+1|)>*H<rsub|1,1><rsup|\<ast\>><around|(|i|)>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><around|\||H<rsub|1,1><around|(|i|)>|\|><rsup|2>>>>>>|]>,<eq-number>>>>>>

  where <math|h<rsup|<around|(|2|)>><rsub|i>=<around|(|<around|\||H<rsub|2,1><around|(|i|)>|\|><rsup|2>+<around|\||H<rsub|1,1>*<around|(|i+1|)>|\|><rsup|2>|)><rsup|-1>>
  and <math|h<rsup|<around|(|2|)>><rsub|i+1>=<around|(|<around|\||H<rsub|1,1><around|(|i|)>|\|><rsup|2>+<around|\||H<rsub|2,1>*<around|(|i+1|)>|\|><rsup|2>|)><rsup|-1>>,
  <math|\<forall\><nbsp>i\<in\><around|{|0,1|}>>. In a similar way, optimal
  detections of <math|<math-bf|x><rsub|\<cal-I\><rsub|1>>> and
  <math|<math-bf|x><rsub|\<cal-I\><rsub|2>>> can be calculated as

  <eqnarray|<tformat|<table|<row|<cell|<wide|<math-bf|x>|^><rsub|\<cal-I\><rsub|1>><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>arg
  min<rsub|<wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|1>>\<in\>\<cal-A\><rsup|2>><around|\<\|\|\>|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>><math-bf|Y>-<sqrt|<frac|\<rho\>|2>>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>>*\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)><wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|1>>|\<\|\|\>><rsub|<mathrm>>*F<eq-number><label|kk>>>|<row|<cell|>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>arg
  min<rsub|<wide|x|\<bar\>><rsub|1>,<wide|x|\<bar\>><rsub|2>\<in\>\<cal-A\>>\<mid\>H<rsub|1,1><rsup|\<ast\>><around|(|1|)>*Y<rsub|1><around|(|0|)>+H<rsub|2,1><around|(|0|)>*Y<rsub|1><around|(|1|)><eq-number>>>|<row|<cell|>|<cell|>|<cell|+H<rsub|1,1><rsup|\<ast\>><around|(|3|)>*Y<rsub|1><around|(|2|)>+H<rsub|2,1><around|(|2|)>*Y<rsub|1><around|(|3|)>+<sqrt|<frac|\<rho\>|2>>[(<around|\||H<rsub|1,1><around|(|0|)>|\|><rsup|2><eq-number>>>|<row|<cell|>|<cell|>|<cell|+<around|\||H<rsub|2,1><around|(|1|)>|\|><rsup|2>)<wide|x|\<bar\>><rsub|0>+<around|(|<around|\||H<rsub|1,1><around|(|2|)>|\|><rsup|2>+<around|\||H<rsub|2,1><around|(|3|)>|\|><rsup|2>|)>*<wide|x|\<bar\>><rsub|1>]\<mid\>,<eq-number>>>>>>

  and

  <eqnarray|<tformat|<table|<row|<cell|<wide|<math-bf|x>|^><rsub|\<cal-I\><rsub|2>><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>arg
  min<rsub|<wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|2>>\<in\>\<cal-A\><rsup|2>><around|\<\|\|\>|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>><math-bf|Y>-<sqrt|<frac|\<rho\>|2>>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>>*\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)><wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|2>>|\<\|\|\>><rsub|<mathrm>>*F<eq-number>>>|<row|<cell|>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>arg
  min<rsub|<wide|x|\<bar\>><rsub|2>,<wide|x|\<bar\>><rsub|3>\<in\>\<cal-A\>>\<mid\>H<rsub|2,1><rsup|\<ast\>><around|(|1|)>*Y<rsub|1><around|(|0|)>-H<rsub|1,1><around|(|0|)>*Y<rsub|1><around|(|1|)><eq-number>>>|<row|<cell|>|<cell|>|<cell|+H<rsub|2,1><rsup|\<ast\>><around|(|3|)>*Y<rsub|1><around|(|2|)>-H<rsub|1,1><around|(|2|)>*Y<rsub|1><around|(|3|)>+<sqrt|<frac|\<rho\>|2>>[(<around|\||H<rsub|2,1><around|(|0|)>|\|><rsup|2><eq-number>>>|<row|<cell|>|<cell|>|<cell|+<around|\||H<rsub|1,1><around|(|1|)>|\|><rsup|2>)<wide|x|\<bar\>><rsub|2>+<around|(|<around|\||H<rsub|2,1><around|(|2|)>|\|><rsup|2>+<around|\||H<rsub|1,1><around|(|3|)>|\|><rsup|2>|)>*<wide|x|\<bar\>><rsub|3>]\<mid\>.<eq-number>>>>>>

  <subsection|Stacked STF Codes with Multi-layer Structure>

  Based on the above-mentioned decoding approach, we obtain the symbols in
  two subsets using ML decoding with lower complexity than that of direct ML
  decoding for symbols <math|<math-bf|x><rsub|<mathcal>>I> without grouping.
  However, the symbol rate is bounded by one for this STF code. Deploying the
  similar STF coding scheme with the PIC decoding, it can be extended by
  vertical stacking to <math|M<rsub|b>> SF/STF codes
  <math|<math-bf|C><rsub|S*F>> of size <math|N\<times\>M<rsub|t>>, given by

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|C><rsub|E*S*T*F>=<around|[|<math-bf|C><rsub|S*F><rsup|<mathrm>>T<nbsp><math-bf|C><rsub|S*F><rsup|<mathrm>>T<nbsp>\<cdots\><nbsp><math-bf|C><rsub|S*F><rsup|<mathrm>>T|]><rsup|<mathrm>>*T,<eq-number>>>>>>

  which has size <math|M<rsub|b>*N\<times\>M<rsub|t>>. For each
  <math|M<rsub|b>\<geq\>1>, the extended STF code
  <math|<math-bf|C><rsub|E*S*T*F>> and the original SF code
  <math|<math-bf|C><rsub|S*F>> have the same characteristics in terms of the
  PEP performance, such as the symbol rate, transmit diversity and coding
  gain <cite|H00>. Namely, the symbol rate, transmit diversity and coding
  gain of the stacked STF code is equal to that of the constituent SF code.

  According to the stacked STF code <math|<math-bf|C><rsub|E*S*T*F>>, its
  performance benefits from the improvement of the component SF code
  <math|<math-bf|C><rsub|S*F>>. Consequently, the maximization of the symbol
  rate, transmit diversity and coding gain of the stacked STF code
  <math|<math-bf|C><rsub|E*S*T*F>> reduces to the selection of the component
  SF code <math|<math-bf|C><rsub|S*F>> which has the maximum symbol rate,
  transmit diversity and coding gain. To design a high-rate STF code with
  low-decoding complexity, we focus on such a perspicacious selection of the
  component SF code <math|<math-bf|C><rsub|S*F>>, a multi-layer SF/STF code,
  achieving full-diversity with the PIC decoding.

  <with|font-shape|italic|Example 4.3:> Consider an SF code
  <math|<math-bf|C><rsub|<math-up|SF>>> with <math|M<rsub|t>=2>,
  <math|M<rsub|r>=1>, <math|N=3> and <math|P=2> as follows

  <\equation>
    <label|mm><math-bf|C><rsub|<math-up|SF>>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|s<rsub|1,1>>|<cell|0>>|<row|<cell|s<rsub|2,1>>|<cell|s<rsub|1,2>>>|<row|<cell|0>|<cell|s<rsub|2,2>>>>>>|]>.
  </equation>

  where <math|<math-bf|s><rsub|i>=<around|(|s<rsub|i,1>,s<rsub|i,2>|)><rsup|<mathrm>>*T=\<Theta\><rsub|2><around|(|x<rsub|2*<around|(|i-1|)>+1>,x<rsub|2*<around|(|i-1|)>+2>|)><rsup|<mathrm>>*T>,
  <math|\<forall\><nbsp>i\<in\><around|{|1,2|}>> and <math|\<Theta\><rsub|2>>
  is the transformed matrix

  <\equation>
    <label|mmt>\<Theta\><rsub|2>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|cos
    \<theta\>>|<cell|sin \<theta\>>>|<row|<cell|-sin \<theta\>>|<cell|cos
    \<theta\>>>>>>|]>,
  </equation>

  where <math|\<theta\>\<in\><around|(|0,2*\<pi\>|)>>. The symbol rate of
  this code is <math|4/3>. It is easy to prove that
  <math|<math-bf|C><rsub|<math-up|SF>>> has full rank property, which is
  equivalent to the STBC that achieves full diversity using PIC group
  decoding algorithm <cite|Xia09>. Actually, since there is only one receive
  antenna with

  <\equation*>
    <math-bf|h>\<triangleq\><around|[|H<rsub|1,1><around|(|0|)>,H<rsub|1,1><around|(|1|)>,H<rsub|1,1><around|(|2|)>,H<rsub|2,1><around|(|0|)>,H<rsub|2,1><around|(|1|)>,H<rsub|2,1><around|(|2|)>|]>,
  </equation*>

  the equivalent channel <math|\<cal-H\><around|(|<math-bf|h>|)>> can be
  written as

  <eqnarray|<tformat|<table|<row|<cell|\<cal-H\><around|(|<math-bf|h>|)>=<around|[|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>|]>,<eq-number><label|eq23>>>>>>

  where

  <\equation*>
    \<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|cos
    \<theta\>*H<rsub|1,1><around|(|0|)>>|<cell|sin
    \<theta\>*H<rsub|1,1><around|(|0|)>>>|<row|<cell|-sin
    \<theta\>*H<rsub|2,1><around|(|1|)>>|<cell|cos
    \<theta\>*H<rsub|2,1><around|(|1|)>>>|<row|<cell|0>|<cell|0>>>>>|]>
  </equation*>

  and

  <\equation*>
    \<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>>|<row|<cell|cos
    \<theta\>*H<rsub|1,1><around|(|1|)>>|<cell|sin
    \<theta\>*H<rsub|1,1><around|(|1|)>>>|<row|<cell|-sin
    \<theta\>*H<rsub|2,1><around|(|2|)>>|<cell|cos
    \<theta\>*H<rsub|2,1><around|(|2|)>>>>>>|]>.
  </equation*>

  It is obvious that <math|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>>
  and <math|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>> are
  linearly independent for the properly selected scalar
  <math|\<theta\>\<in\><around|(|0,2*\<pi\>|)>> for
  <math|<math-bf|h>\<neq\><with|math-font-family|bf|0>>. Actually, it can be
  shown that any column vector of <math|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>>
  can not be written as the linear combinations of column vectors of
  <math|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>> over
  <math|\<Delta\>*\<cal-A\>>. The scalar <math|\<theta\>> can be properly
  selected such that the proposed SF code can achieve the optimal PEP
  performance.

  Through the direct calculation in (<reference|PICh>), we have two
  projection matrices, <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>>>
  and <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>>>,
  i.e.,

  <eqnarray|<tformat|<table|<row|<cell|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|1>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>>>>>|]>,<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|1>>>>>|]>.<eq-number>>>>>>

  Thus, the SF code <math|<math-bf|C><rsub|<math-up|SF>>> achieves full
  diversity using the PIC group decoding provided with the grouping scheme
  <math|{<around|{|\<cal-I\><rsub|1>=<around|{|0,1|}>,\<cal-I\><rsub|2>=<around|{|2,3|}>|}>>.
  Actually, while passing the received signal vector
  <math|<math-bf|Y>=<around|(|Y<rsub|1><around|(|0|)>,Y<rsub|1><around|(|1|)>,Y<rsub|1><around|(|2|)>|)><rsup|<mathrm>>*T>
  through <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>>>
  and <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>>>,
  the optimal detections of <math|<math-bf|x><rsub|\<cal-I\><rsub|1>>> and
  <math|<math-bf|x><rsub|\<cal-I\><rsub|2>>> are given by

  <eqnarray|<tformat|<table|<row|<cell|<wide|x|^><rsub|1><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>arg
  min<rsub|<wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|1>>\<in\>\<cal-A\><rsup|2>>\<parallel\><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>><math-bf|Y>-<sqrt|<frac|\<rho\>|2>>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>>*\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)><wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|1>>\<parallel\><rsub|<mathrm>>F<eq-number><label|kk>>>|<row|<cell|>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>arg
  min<rsub|<wide|x|\<bar\>><rsub|0>,<wide|x|\<bar\>><rsub|1>\<in\>\<cal-A\>>\<mid\>Y<rsub|1><around|(|0|)>-<sqrt|<frac|\<rho\>|2>>(cos
  \<theta\>*H<rsub|1,1><around|(|0|)>*<wide|x|\<bar\>><rsub|0><eq-number>>>|<row|<cell|>|<cell|>|<cell|+sin
  \<theta\>*H<rsub|1,1><around|(|0|)>*<wide|x|\<bar\>><rsub|1>)\<mid\>,<eq-number>>>>>>

  and

  <eqnarray|<tformat|<table|<row|<cell|<wide|x|^><rsub|2><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>arg
  min<rsub|<wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|2>>\<in\>\<cal-A\><rsup|2>>\<parallel\><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>><math-bf|Y>-<sqrt|<frac|\<rho\>|2>>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|2>>*\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)><wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|2>>\<parallel\><rsub|<mathrm>>F<eq-number>>>|<row|<cell|>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>arg
  min<rsub|<wide|x|\<bar\>><rsub|2>,<wide|x|\<bar\>><rsub|3>\<in\>\<cal-A\>>\<mid\>Y<rsub|1><around|(|2|)>-<sqrt|<frac|\<rho\>|2>>(cos
  \<theta\>*H<rsub|2,1><around|(|2|)>*<wide|x|\<bar\>><rsub|0><eq-number>>>|<row|<cell|>|<cell|>|<cell|-sin
  \<theta\>*H<rsub|2,1><around|(|2|)>*<wide|x|\<bar\>><rsub|3>)\<mid\>.<eq-number>>>>>>

  To design an SF code with higher symbol rate, one may consider a code
  <math|<math-bf|C><rsub|S*F>> with <math|M<rsub|t>=2>, <math|N=4> and
  <math|P=3>. Then <math|<math-bf|C><rsub|<math-up|SF>>> can be designed as

  <\equation>
    <label|Ex13><math-bf|C><rsub|<math-up|STF>>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|s<rsub|1,1>>|<cell|0>>|<row|<cell|s<rsub|2,1>>|<cell|s<rsub|1,2>>>|<row|<cell|s<rsub|3,1>>|<cell|s<rsub|2,2>>>|<row|<cell|0>|<cell|s<rsub|3,2>>>>>>|]>,
  </equation>

  where <math|<math-bf|s><rsub|i>=<around|(|s<rsub|i,1>,s<rsub|i,2>|)><rsup|<mathrm>>*T=\<Theta\><rsub|2><around|(|x<rsub|2*<around|(|i-1|)>+1>,x<rsub|2*<around|(|i-1|)>+2>|)><rsup|<mathrm>>*T>,
  <math|\<forall\><nbsp>i\<in\><around|{|1,2,3|}>>. In this case, the symbol
  rate is <math|3/2>. Unfortunately, it is easy to check that
  <math|<math-bf|C><rsub|<math-up|SF>>> has no full rank property. In fact,
  while considering only one receive antenna with
  <math|<math-bf|h>\<triangleq\>[H<rsub|1,1><around|(|0|)>,H<rsub|1,1><around|(|1|)>,H<rsub|1,1><around|(|2|)>,H<rsub|1,1><around|(|3|)>,H<rsub|2,1><around|(|0|)>>,
  <math|H<rsub|2,1><around|(|1|)>,H<rsub|2,1><around|(|2|)>,H<rsub|2,1><around|(|3|)>]>,
  the equivalent channel can be written as

  <eqnarray|<tformat|<table|<row|<cell|\<cal-H\><around|(|<math-bf|h>|)>=<around|[|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|3>><around|(|<math-bf|h>|)>|]>,<eq-number><label|eq23>>>>>>

  where

  <\equation*>
    \<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|cos
    \<theta\>*H<rsub|1,1><around|(|0|)>>|<cell|sin
    \<theta\>*H<rsub|1,1><around|(|0|)>>>|<row|<cell|-sin
    \<theta\>*H<rsub|2,1><around|(|1|)>>|<cell|cos
    \<theta\>*H<rsub|2,1><around|(|1|)>>>|<row|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>>>>>|]>,
  </equation*>

  <\equation*>
    \<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>>|<row|<cell|cos
    \<theta\>*H<rsub|1,1><around|(|1|)>>|<cell|sin
    \<theta\>*H<rsub|1,1><around|(|1|)>>>|<row|<cell|-sin
    \<theta\>*H<rsub|2,1><around|(|2|)>>|<cell|cos
    \<theta\>*H<rsub|2,1><around|(|2|)>>>|<row|<cell|0>|<cell|0>>>>>|]>,
  </equation*>

  and

  <\equation*>
    \<cal-H\><rsub|\<cal-I\><rsub|3>><around|(|<math-bf|h>|)>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>>|<row|<cell|cos
    \<theta\>*H<rsub|1,1><around|(|2|)>>|<cell|sin
    \<theta\>*H<rsub|1,1><around|(|2|)>>>|<row|<cell|-sin
    \<theta\>*H<rsub|2,1><around|(|3|)>>|<cell|cos
    \<theta\>*H<rsub|2,1><around|(|3|)>>>>>>|]>.
  </equation*>

  It is obvious that <math|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>>,
  <math|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>>, and
  <math|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>> are not
  linearly independent for any <math|\<theta\>\<in\><around|(|0,2*\<pi\>|)>>.
  Thus, this code <math|<math-bf|C><rsub|<math-up|STF>>> can not achieve full
  diversity using the PIC group decoding provided with the grouping scheme
  <math|<around|{|\<cal-I\><rsub|1>=<around|{|0,1|}>,\<cal-I\><rsub|2>=<around|{|2,3|}>,\<cal-I\><rsub|3>=<around|{|4,5|}>|}>>.
  In order to decode with this grouping scheme with the low-complexity
  receiver, we implement the conditional PIC group decoding. First of all,
  any two group of column vectors in <math|<around|{|\<cal-H\><rsub|\<cal-I\><rsub|i>><around|(|<math-bf|h>|)>:i\<in\><around|{|1,2,3|}>|}>>,
  say <math|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>> and
  <math|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>>, can be
  used for PIC decoding for any possible trial of the information symbols in
  the remaining group, say <math|<math-bf|x><rsub|\<cal-I\><rsub|3>>>, since
  <math|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>> and
  <math|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>> are
  linearly independent except for <math|\<cal-H\><rsub|\<cal-I\><rsub|3>>>
  whenever <math|<math-bf|h>\<neq\><with|math-font-family|bf|0>> and
  <math|tan \<theta\>\<neq\>0>. Namely, taking the PIC decoding for the
  grouping scheme <math|<around|{|<math-bf|x><rsub|\<cal-I\><rsub|1>>,<math-bf|x><rsub|\<cal-I\><rsub|2>>|}>>
  with respect to any possible trial of information symbols
  <math|<wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|3>>\<in\>\<cal-A\><rsup|2>>,
  we should cancel them from the received signal, i.e.,

  <eqnarray|<tformat|<table|<row|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><math-bf|Y>-<sqrt|<frac|\<rho\>|2>>*\<cal-H\><rsub|\<cal-I\><rsub|3>><around|(|<math-bf|h>|)><wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|3>><eq-number><label|cancel>>>|<row|<cell|>|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>=<sqrt|<frac|\<rho\>|2>>*<big|sum><rsub|i=1><rsup|2>\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)><math-bf|x><rsub|\<cal-I\><rsub|i>>+<sqrt|<frac|\<rho\>|2>>*\<cal-H\><rsub|\<cal-I\><rsub|3>>*<around|(|<math-bf|x><rsub|\<cal-I\><rsub|3>>-<wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|3>>|)>+N.<eq-number>>>>>>

  After that we choose <math|<wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|3>>\<in\>\<cal-A\><rsup|2>>
  to minimize the ML metric from all yielded signals
  <math|<around|{|<math-bf|x><rsub|\<cal-I\><rsub|1>>,<math-bf|x><rsub|\<cal-I\><rsub|2>>|}>>,

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|x><rsub|\<cal-I\><rsub|3>>=arg
  min<rsub|<wide|<math-bf|x>|^><rsub|\<cal-I\><rsub|3>>\<in\>\<cal-A\><rsup|2>><around|\<\|\|\>|<math-bf|Y>-<sqrt|<frac|\<rho\>|2>>*<around|(|<big|sum><rsub|i=1><rsup|2>\<cal-H\><rsub|\<cal-I\><rsub|i>><math-bf|x><rsub|\<cal-I\><rsub|i>>+\<cal-H\><rsub|\<cal-I\><rsub|3>><wide|<math-bf|x>|\<bar\>><rsub|\<cal-I\><rsub|3>>|)>|\<\|\|\>><rsub|<mathrm>>*F.<eq-number>>>>>>

  According the above analysis, we state that the decoding complexity of the
  PIC decoding for two subsets <math|<math-bf|x><rsub|\<cal-I\><rsub|1>>> and
  <math|<math-bf|x><rsub|\<cal-I\><rsub|2>>> is
  <math|\<cal-O\><around|(|2<around|\||\<cal-A\>|\|><rsup|2>|)>>, and the ML
  decoding for subset <math|<math-bf|x><rsub|\<cal-I\><rsub|3>>> is
  <math|\<cal-O\><around|(|<around|\||\<cal-A\>|\|><rsup|2>|)>>. Therefore,
  the total decoding complexity for this conditional PIC decoding is
  <math|\<cal-O\><around|(|2<around|\||\<cal-A\>|\|><rsup|4>|)>>, which is
  still lower than the decoding complexity
  <math|\<cal-O\><around|(|<around|\||\<cal-A\>|\|><rsup|6>|)>> of
  <math|<math-bf|x>\<in\>\<cal-A\><rsup|6>> with the joint ML decoding.

  To design an SF code with the PIC decoding, we can also make use of the
  design approach of the conventional quasi-orthogonal STBC codes.

  <with|font-shape|italic|Example 4.4:> Consider the quasi-orthogonal STBC
  code with <math|M<rsub|t>=4>, <math|M<rsub|r>=1>, <math|N=4> and
  <math|P=2>. Then the SF code can be designed as

  <\equation>
    <label|equa3><space|-0.17em><space|-0.17em><math-bf|C><rsub|<math-up|SF>><space|-0.17em>=<space|-0.17em><space|-0.17em><around*|[|<space|-0.17em><space|-0.17em><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|4|4|cell-rborder|0ln>|<table|<row|<cell|s<rsub|1,1>>|<cell|<space|-0.17em><space|-0.17em>s<rsub|2,1>>|<cell|<space|-0.17em><space|-0.17em>cos
    \<theta\>*s<rsub|1,2>>|<cell|<space|-0.17em><space|-0.17em>sin
    \<theta\>*s<rsub|2,2>>>|<row|<cell|-s<rsub|2,1><rsup|\<ast\>>>|<cell|<space|-0.17em><space|-0.17em>s<rsub|1,1><rsup|\<ast\>>>|<cell|<space|-0.17em><space|-0.17em>-sin
    \<theta\>*s<rsub|2,2><rsup|\<ast\>>>|<cell|<space|-0.17em><space|-0.17em>cos
    \<theta\>*s<rsub|1,2><rsup|\<ast\>>>>|<row|<cell|cos
    \<theta\>*s<rsub|1,2>>|<cell|<space|-0.17em><space|-0.17em>sin
    \<theta\>*s<rsub|2,2>>|<cell|<space|-0.17em><space|-0.17em>s<rsub|1,1>>|<cell|<space|-0.17em><space|-0.17em>s<rsub|2,1>>>|<row|<cell|-sin
    \<theta\>*s<rsub|2,2><rsup|\<ast\>>>|<cell|<space|-0.17em><space|-0.17em>cos
    \<theta\>*s<rsub|1,2><rsup|\<ast\>>>|<cell|<space|-0.17em><space|-0.17em>-s<rsub|2,1><rsup|\<ast\>>>|<cell|<space|-0.17em><space|-0.17em>s<rsub|1,1><rsup|\<ast\>>>>>>><space|-0.17em><space|-0.17em>|]>,
  </equation>

  where <math|<math-bf|s><rsub|i>=<around|(|s<rsub|i,1>,s<rsub|i,2>|)><rsup|<mathrm>>*T=<around|(|x<rsub|2*<around|(|i-1|)>>,x<rsub|2*<around|(|i-1|)>+1>|)><rsup|<mathrm>>*T>,
  <math|\<forall\><nbsp>i\<in\><around|{|1,2|}>> and
  <math|\<theta\>\<in\><around|(|0,2*\<pi\>|)>>. Let
  <math|<math-bf|h>=<around|[|H<rsub|1,1><rsup|<mathrm>>*T,H<rsub|2,1><rsup|<mathrm>>*T,H<rsub|3,1><rsup|<mathrm>>*T,H<rsub|4,1><rsup|<mathrm>>*T|]><rsup|<mathrm>>*T>,
  where <math|H<rsub|t,1>=<around|[|H<rsub|t,1><rsup|<mathrm>>*T<around|(|0|)>,H<rsub|t,1><rsup|<mathrm>>*T<around|(|1|)>,H<rsub|t,1><rsup|<mathrm>>*T<around|(|2|)>,H<rsub|t,1><rsup|<mathrm>>*T<around|(|3|)>|]>>,
  <math|\<forall\><nbsp>t\<in\><around|{|1,2,3,4|}>> with the grouping scheme
  <math|\<cal-I\>=<around|{|\<cal-I\><rsub|1>,\<cal-I\><rsub|2>|}>=<around|{|<around|{|0,2|}>,<around|{|1,3|}>|}>>.
  Then the equivalent channel matrix can be written as

  <\equation>
    <label|ch1>\<cal-H\><around|(|<math-bf|h>|)>=<around|[|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>|]>,
  </equation>

  where

  <\equation*>
    \<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|H<rsub|1,1><around|(|0|)>>|<cell|cos
    \<theta\>*H<rsub|3,1><around|(|0|)>>>|<row|<cell|H<rsub|2,1><rsup|\<ast\>><around|(|1|)>>|<cell|cos
    \<theta\>*H<rsub|4,1><rsup|\<ast\>><around|(|1|)>>>|<row|<cell|H<rsub|3,1><around|(|2|)>>|<cell|cos
    \<theta\>*H<rsub|1,1><around|(|2|)>>>|<row|<cell|H<rsub|4,1><rsup|\<ast\>><around|(|3|)>>|<cell|cos
    \<theta\>*H<rsub|2,1><rsup|\<ast\>><around|(|3|)>>>>>>|]>
  </equation*>

  and

  <\equation*>
    \<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|H<rsub|2,1><around|(|0|)>>|<cell|sin
    \<theta\>*H<rsub|4,1><around|(|0|)>>>|<row|<cell|-H<rsub|1,1><rsup|\<ast\>><around|(|1|)>>|<cell|-sin
    \<theta\>*H<rsub|3,1><around|(|1|)>>>|<row|<cell|H<rsub|4,1><around|(|2|)>>|<cell|sin
    \<theta\>*H<rsub|2,1><around|(|2|)>>>|<row|<cell|-H<rsub|3,1><rsup|\<ast\>><around|(|3|)>>|<cell|-sin
    \<theta\>*H<rsub|1,1><rsup|\<ast\>><around|(|3|)>>>>>>|]>.
  </equation*>

  It is obvious that <math|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>>
  and <math|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>> are
  linear independent for <math|tan \<theta\>\<neq\>0> and
  <math|<math-bf|h>\<neq\>0>. Therefore, <math|<math-bf|C><rsub|S*F>>
  achieves full diversity under the PIC group decoding provided with the
  grouping scheme <math|<around|{|\<cal-I\><rsub|1>=<around|{|0,1|}>,\<cal-I\><rsub|2>=<around|{|2,3|}>|}>>.

  <subsection|The STF Block Codes with Multi-layer Structure>

  <with|font-shape|italic|Example 4.5:> Taking <math|M<rsub|t>=4>,
  <math|M<rsub|r>=1>, <math|M<rsub|b>=2> and <math|N=3>, we design an STF
  code with the Alamouti code structure as follows

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|C><rsub|<mathrm>>S*T*F=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<math-bf|C><rsub|<mathrm>>S*F*1>|<cell|<math-bf|C><rsub|<mathrm>>S*F*2>>|<row|<cell|-<math-bf|C><rsub|<mathrm>>S*F*2<rsup|\<ast\>>>|<cell|<math-bf|C><rsub|<mathrm>>S*F*1<rsup|\<ast\>>>>>>>|]><eq-number><label|equa4>>>>>>

  where <math|<math-bf|C><rsub|<mathrm>>S*F*1> and
  <math|<math-bf|C><rsub|<mathrm>>S*F*2> are two SF codes defined in
  (<reference|mm>), i.e.,

  <\equation>
    <label|Ex11><math-bf|C><rsub|<with|math-font-family|rm|STF1>>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|s<rsub|1,1>>|<cell|0>>|<row|<cell|s<rsub|2,1>>|<cell|s<rsub|1,2>>>|<row|<cell|0>|<cell|s<rsub|2,2>>>>>>|]>,<math-bf|C><rsub|<with|math-font-family|rm|STF2>>=<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|s<rsub|3,1>>|<cell|0>>|<row|<cell|s<rsub|4,1>>|<cell|s<rsub|3,2>>>|<row|<cell|0>|<cell|s<rsub|4,2>>>>>>|]>.
  </equation>

  Thus the equivalent channel can be written as

  <eqnarray|<tformat|<table|<row|<cell|\<cal-H\><around|(|<math-bf|h>|)>=<around|[|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|3>><around|(|<math-bf|h>|)><nbsp>\<cal-H\><rsub|\<cal-I\><rsub|4>><around|(|<math-bf|h>|)>|]>,<eq-number><label|eq23>>>>>>

  where

  <eqnarray|<tformat|<table|<row|<cell|\<cal-H\><rsub|\<cal-I\><rsub|1>><space|-0.17em>=<space|-0.17em><around*|[|<space|-0.17em><space|-0.17em><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<space|-0.17em><space|-0.17em>H<rsub|1,1><around|(|0|)><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>H<rsub|2,1><around|(|1|)>>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>H<rsup|\<ast\>><rsub|3,1><around|(|3|)><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>H<rsub|4,1><rsup|\<ast\>><around|(|4|)>>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>0>>>>><space|-0.17em><space|-0.17em>|]>,\<cal-H\><rsub|\<cal-I\><rsub|2>><space|-0.17em>=<space|-0.17em><around*|[|<space|-0.17em><space|-0.17em><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>H<rsub|1,1><around|(|1|)><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>H<rsub|2,1><around|(|2|)>>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>H<rsup|\<ast\>><rsub|3,1><around|(|4|)><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em>H<rsub|4,1><rsup|\<ast\>><around|(|5|)>>>>>><space|-0.17em><space|-0.17em>|]>,<eq-number>>>>>>

  <eqnarray|<tformat|<table|<row|<cell|\<cal-H\><rsub|\<cal-I\><rsub|3>><space|-0.17em>=<space|-0.17em><around*|[|<space|-0.17em><space|-0.17em><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<space|-0.17em><space|-0.17em>H<rsub|3,1><around|(|0|)><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>H<rsub|4,1><around|(|0|)>>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>-H<rsup|\<ast\>><rsub|1,1><around|(|3|)><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>-H<rsub|2,1><rsup|\<ast\>><around|(|4|)>>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>0>>>>><space|-0.17em><space|-0.17em>|]>,\<cal-H\><rsub|\<cal-I\><rsub|4>><space|-0.17em>=<space|-0.17em><around*|[|<space|-0.17em><space|-0.17em><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>H<rsub|3,1><around|(|1|)><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>H<rsub|4,1><around|(|2|)>>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>-H<rsup|\<ast\>><rsub|1,1><around|(|4|)><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>0>>|<row|<cell|<space|-0.17em><space|-0.17em>0<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>-H<rsub|2,1><rsup|\<ast\>><around|(|5|)>>>>>><space|-0.17em><space|-0.17em>|]>.<eq-number>>>>>>

  It is obvious that any three group vectors

  <\equation*>
    <around|{|\<cal-H\><rsub|\<cal-I\><rsub|k>><around|(|<math-bf|h>|)>,\<cal-H\><rsub|\<cal-I\><rsub|m>><around|(|<math-bf|h>|)>,\<cal-H\><rsub|\<cal-I\><rsub|n>><around|(|<math-bf|h>|)>|}>,\<forall\>k,m,n\<in\><around|{|1,2,3,4|}>
  </equation*>

  are linearly independent for <math|<math-bf|h>\<neq\><with|math-font-family|bf|0>>.
  Namely, any one vector of one group vectors, say
  <math|\<cal-H\><rsub|\<cal-I\><rsub|k>><around|(|<math-bf|h>|)>>, can not
  belong to the linear space spanned by all vectors in other two group
  vectors, <math|\<cal-H\><rsub|\<cal-I\><rsub|m>><around|(|<math-bf|h>|)>>
  and <math|\<cal-H\><rsub|\<cal-I\><rsub|n>><around|(|<math-bf|h>|)>>.
  However, four group vectors <math|<around|{|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>,\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>,\<cal-H\><rsub|\<cal-I\><rsub|3>><around|(|<math-bf|h>|)>,\<cal-H\><rsub|\<cal-I\><rsub|4>><around|(|<math-bf|h>|)>|}>>
  are not linearly independent since any one vector of one group vectors, say
  <math|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>>, belongs
  to the linear space spanned by all vectors in other three group vectors,
  <math|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>>,
  <math|\<cal-H\><rsub|\<cal-I\><rsub|3>><around|(|<math-bf|h>|)>> and
  <math|\<cal-H\><rsub|\<cal-I\><rsub|4>><around|(|<math-bf|h>|)>>. Thus, the
  code <math|<math-bf|C><rsub|<math-up|STF>>> in (<reference|equa4>) can not
  achieve full diversity using the PIC group decoding provided with the
  grouping scheme <math|\<cal-I\><rsub|i>=<around|{|2*i-2,2*i-1|}>>,
  <math|\<forall\><nbsp>i\<in\><around|{|1,2,3,4|}>>. Fortunately, any two
  group vectors in <math|<around|{|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>,\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>,\<cal-H\><rsub|\<cal-I\><rsub|3>><around|(|<math-bf|h>|)>,\<cal-H\><rsub|\<cal-I\><rsub|4>><around|(|<math-bf|h>|)>|}>>
  are linearly independent for <math|<math-bf|h>\<neq\><with|math-font-family|bf|0>>.
  For example, <math|<around|{|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>,\<cal-H\><rsub|\<cal-I\><rsub|3>><around|(|<math-bf|h>|)>|}>>
  and <math|<around|{|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>,\<cal-H\><rsub|\<cal-I\><rsub|4>><around|(|<math-bf|h>|)>|}>>
  are linearly independent for <math|<math-bf|h>\<neq\><with|math-font-family|bf|0>>.
  It implies that any one vector of the space spanned by two group vectors,
  <math|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>> and
  <math|\<cal-H\><rsub|\<cal-I\><rsub|3>><around|(|<math-bf|h>|)>>, does not
  belong to the linear space spanned by all vectors other two group vectors,
  <math|\<cal-H\><rsub|\<cal-I\><rsub|2>><around|(|<math-bf|h>|)>> and
  <math|\<cal-H\><rsub|\<cal-I\><rsub|4>><around|(|<math-bf|h>|)>>. Thus,
  this code <math|<math-bf|C><rsub|<math-up|STF>>> can achieve full diversity
  using the PIC group decoding provided that the grouping scheme
  <math|<around|{|\<cal-I\><rsub|1>=<around|{|0,1,4,5|}>,\<cal-I\><rsub|2>=<around|{|2,3,6,7|}>|}>>.

  <subsection|Simulation Results>

  So far, we have investigated the structure of the SF/STF codes with the PIC
  decoding. Next we show some simulation results for the proposed SF/STF
  codes for different modulations and compare their BER performance versus
  SNR. The OFDM modulation has <math|N=128> subcarriers and the number of
  independent channel taps is <math|L=12>.

  At first, we compare the STF code in (<reference|equa2>) using BPSK
  constellation with two transmit and one receive antennas for <math|2> OFDM
  blocks. For the ML decoding, ZF decoding and PIC decoding, the grouping
  size of the decoders is two. The rate for this coding scheme is <math|1>
  for two transmit antennas. It is shown in Fig.1 that the proposed STF code
  can achieve full diversity with the BPSK constellation. In this case, the
  BER performance behavior is almost same for three kinds of the decoding
  approaches.

  <\big-figure>
    <label|Fig1><image|BPSK-PIC.eps|95mm|70mm||>
  </big-figure|BER performance behaviors of the STF code with BPSK
  modulation.>

  <\big-figure>
    <label|Fig1><image|161.eps|95mm|70mm||>
  </big-figure|BER performance behaviors of the STF code with 16-QAM and
  64-QAM modulation.>

  In Fig.2, we compare our codes in (<reference|equa2>) and (<reference|mm>)
  using the standard complex quadrature amplitude modulation (QAM)
  constellations, such as 16-QAM, 64-QAM, and 256-QAM. For the STF code in
  (<reference|mm>), the group size of the group decoder is set to two. The
  rate for this STF coding scheme is <math|4/3>. For the optimal coding gain
  based on the standard QAM constellation, we select the parameter
  <math|\<theta\>=0.55> based on Monte Carlo simulations for the optimal STBC
  design in terms of the two-dimensional real rotation
  <math|\<theta\>=<frac|1|2>*tan<rsup|-1><around|(|2|)>> <cite|Xia09>. It is
  shown in Fig.2 that the proposed SF code can achieve full diversity with
  three different QAM modulations. In this case, the BER performance
  behaviors of two STF coding schemes are almost same for 16-QAM and 64-QAM.
  In addition, it implies that the BER performance of the PIC decoding
  outperforms the ZF decoding, but no better than that of the ML decoding.

  <section|Conclusion>

  In this paper, we have presented the PIC group decoding for the SF/STF
  codes to achieve full diversity when signals are transmitted and processed
  by a linear receiver in a frequency-selective environment. The proposed PIC
  decoding fills the gaps between the ML decoding and the ZF decoding. We
  then derived a design criterion criterion for the SF/STF codes to achieve
  full diversity with the PIC decoding in terms of the PEP performance. The
  derived criterion is a group independence criterion for an equivalent
  channel matrix for the MIMO-OFDM system. It provides a tradeoff between
  decoding complexity and symbol rate while full diversity is required.
  Specifically, we proposed the linear SF/STF code achieving full diversity
  for the MIMO-OFDM system, which satisfies the PIC group decoding criterion.
  While consider the design of the high symbol rate SF/STF codes, we present
  an example with the multi-layer structure that satisfies the newly-built
  design PIC group decoding criterion and thus they achieve full diversity
  with the PIC group decoding. We have shown that it contains an interesting
  property for such SF/STC codes, i.e., the symbol transmission rate for the
  code is usually more than one for the STF codes with the multi-layer
  structure. Simulations demonstrate that the proposed SF/STF codes perform
  well in terms of the PEP performance as well as the decoding complexity
  when the PIC group decoding is applied at the receiver.

  <section*|Appendix>

  <subsection|Proof of Theorem 3.1>

  For any given non-zero vectors <math|<math-bf|h>\<in\>\<bbb-C\><rsup|N*M<rsub|t>*M<rsub|r>*M<rsub|b>>>,
  <math|<math-bf|h><rprime|'>\<in\>\<bbb-C\><rsup|L*M<rsub|t>*M<rsub|r>*M<rsub|b>>>
  and <math|\<Delta\><math-bf|x>\<in\>\<cal-A\><rsup|\<eta\>>>, the
  <math|\<eta\>> column vectors of <math|\<cal-H\><around|(|<math-bf|h>|)>>
  and hence <math|\<cal-H\><around|(|<math-bf|h><rprime|'>|)>> are linearly
  independent over <math|\<Delta\>*\<cal-A\>>. Then there exists a positive
  constant <math|c> such that

  <eqnarray|<tformat|<table|<row|<cell|<around|\<\|\|\>|<frac|1|<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F>*\<cal-H\><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F>|<cell|=>|<cell|<around|\<\|\|\>|<around*|[|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<math-bf|A><rsub|1><frac|<math-bf|h>|<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F><nbsp>\<cdots\><nbsp><math-bf|A><rsub|\<eta\>><frac|<math-bf|h>|<around|\|||\|><math-bf|h><around|\|||\|><rsub|<mathrm>>*F>>>>>>|]>*\<Delta\><math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F<eq-number><label|ssa>>>|<row|<cell|>|<cell|>|<cell|\<geq\>c\<cdot\><around|\<\|\|\>|\<Delta\><math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F\<gtr\>0.<eq-number>>>>>>

  Consequently, we have

  <eqnarray|<tformat|<table|<row|<cell|<around|\<\|\|\>|\<cal-H\><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|\<geq\>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>c\<cdot\><around|\<\|\|\>|\<Delta\><math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F<eq-number><label|ssa1>>>|<row|<cell|<space|-0.17em><space|-0.17em>>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>c\<cdot\><around|\<\|\|\>|\<Delta\><math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F\<cdot\><around*|[|<big|sum><rsub|k=1><rsup|M<rsub|b>><big|sum><rsub|n=0><rsup|N-1><big|sum><rsub|i=1><rsup|M<rsub|t>><big|sum><rsub|j=1><rsup|M<rsub|r>><around|\||H<rsub|i,j><rsup|k><around|(|n|)>|\|><rsup|2>|]><rsup|1/2><eq-number>>>|<row|<cell|<space|-0.17em><space|-0.17em>>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>c\<cdot\><around|\<\|\|\>|\<Delta\><math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F\<cdot\><around*|[|<big|sum><rsub|k=1><rsup|M<rsub|b>><big|sum><rsub|l=0><rsup|L-1><big|sum><rsub|i=1><rsup|M<rsub|t>><big|sum><rsub|j=1><rsup|M<rsub|r>><around|\||\<alpha\><rsub|i,j><rsup|k><around|(|l|)>|\|><rsup|2>|]><rsup|1/2>.<eq-number>>>>>>

  This completes the proof of this theorem.

  <subsection|Proof of Theorem 3.2>

  For any two distinct dispersions <math|<math-bf|X>,<wide|<math-bf|X>|~>\<in\>\<cal-X\>>
  with <math|\<Delta\><math-bf|X>=<math-bf|X>-<wide|<math-bf|X>|~>\<in\>\<Delta\>*\<cal-X\>>,
  it is assumed that <math|\<Delta\><math-bf|X>> is a full rank matrix. Then
  there exist unitary matrix <math|<math-bf|U>> of size
  <math|N*M<rsub|r>*M<rsub|b>\<times\>N*M<rsub|r>*M<rsub|b>> and diagonal
  matrix <math|<math-bf|D>=<math-up|diag><around|(|\<lambda\><rsub|1>,\<cdots\>,\<lambda\><rsub|N*M<rsub|r>*M<rsub|b>>|)>>
  such that

  <\equation*>
    \<Delta\><math-bf|X>\<Delta\><math-bf|X><rsup|<mathrm>>H=<math-bf|UDU><rsup|<mathrm>>H.
  </equation*>

  Due to the full rank property of matrix <math|\<Delta\><math-bf|X>>, there
  exists positive value <math|\<lambda\><rsub|0>> such that
  <math|\<lambda\><rsub|0>=min <around|{|\<lambda\><rsub|1>,\<cdots\>,\<lambda\><rsub|N*M<rsub|r>*M<rsub|b>>|}>>.
  Therefore we have

  <eqnarray|<tformat|<table|<row|<cell|<around|\|||\|>*\<cal-H\><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><around|\|||\|><rsub|<mathrm>>*F<rsup|2>>|<cell|=>|<cell|<around|\|||\|>*\<Delta\><math-bf|Xh><around|\|||\|><rsub|<mathrm>>*F<rsup|2><eq-number><label|dd>>>|<row|<cell|>|<cell|=>|<cell|<math-up|tr><around|(|\<Delta\><math-bf|Xhh><rsup|<mathrm>>H*\<Delta\><math-bf|X><rsup|<mathrm>>H|)><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<math-up|tr><around|(|\<Delta\><math-bf|X>\<Delta\><math-bf|X><rsup|<mathrm>>H|)><math-bf|hh><rsup|<mathrm>>H<eq-number>>>|<row|<cell|>|<cell|\<geq\>>|<cell|\<lambda\><rsub|0>*<big|sum><rsub|k=1><rsup|M<rsub|b>><big|sum><rsub|n=0><rsup|N-1><big|sum><rsub|i=1><rsup|M<rsub|t>><big|sum><rsub|j=1><rsup|M<rsub|r>><around|\||H<rsub|i,j><rsup|k><around|(|n|)>|\|><rsup|2>.<eq-number>>>>>>

  It shows that for <math|<math-bf|h>\<neq\>0>,
  <math|\<cal-H\><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x>=0> if and only
  if <math|\<Delta\><math-bf|x>=0>. Thus all <math|\<eta\>> column vectors of
  <math|\<cal-H\><around|(|<math-bf|h>|)>> are linearly independent over
  <math|\<Delta\>*\<cal-A\>>.

  For the proof of the necessity, if the column vectors of
  <math|\<cal-H\><around|(|<math-bf|h>|)>> are linearly independent over
  <math|\<Delta\>*\<cal-A\>>, there exists a positive constant <math|c> such
  that

  <eqnarray|<tformat|<table|<row|<cell|<around|\|||\|>*\<Delta\><math-bf|Xh><around|\|||\|><rsub|<mathrm>>*F<rsup|2>>|<cell|=>|<cell|<around|\|||\|>*\<cal-H\><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><around|\|||\|><rsup|2><rsub|<mathrm>>*F<eq-number><label|dd>>>|<row|<cell|>|<cell|=>|<cell|<math-up|tr><around|(|\<cal-H\><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x>\<Delta\><math-bf|x><rsup|<mathrm>>H*\<cal-H\><around|(|<math-bf|h>|)><rsup|<mathrm>>*H|)><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<math-up|tr><around|(|\<cal-H\><around|(|<math-bf|h>|)>*\<cal-H\><around|(|<math-bf|h>|)><rsup|<mathrm>>*H*\<Delta\><math-bf|x>\<Delta\><math-bf|x><rsup|<mathrm>>H|)><eq-number>>>|<row|<cell|>|<cell|\<geq\>>|<cell|c<around|\|||\|>*\<Delta\><math-bf|x><around|\|||\|><rsub|F><rsup|2>*<big|sum><rsub|k=1><rsup|M<rsub|b>><big|sum><rsub|n=0><rsup|N-1><big|sum><rsub|i=1><rsup|M<rsub|t>><big|sum><rsub|j=1><rsup|M<rsub|r>><around|\||H<rsub|i,j><rsup|k><around|(|n|)>|\|><rsup|2>.<eq-number>>>>>>

  Thus the eigenvalues of <math|\<Delta\><math-bf|X>\<Delta\><math-bf|X><rsup|<mathrm>>H>
  are all positive values for any pair of <math|<math-bf|C>> and
  <math|<wide|<math-bf|C>|~>>. It implies that <math|\<cal-X\>> has the full
  rank property. This completes the proof of the Theorem.

  <subsection|Proof of Theorem 3.3>

  We consider the dimension-reduced system in (<reference|PICD>). Suppose the
  <math|\<eta\>> column vectors in <math|\<cal-H\><around|(|<math-bf|h>|)>>
  are linearly independent. Thus the <math|\<eta\><rsub|p>> column vectors
  <math|\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>> are
  linearly independent for any <math|p\<in\><around|{|1,\<cdots\>*P|}>>.
  According to the selection of matrix <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>>
  in (<reference|PICh>), the resulting <math|\<eta\><rsub|p>> column vectors
  <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>>
  are linearly independent over <math|\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>>.
  Then we have

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><frac|1|<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><eq-number>>>|<row|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*<around*|[|<frac|1|<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>|]><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><around*|[|<math-bf|A><rsub|\<cal-I\><rsub|p,1>><frac|<math-bf|h>|<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F><nbsp>\<cdots\><nbsp><math-bf|A><rsub|\<cal-I\><rsub|p,\<eta\><rsub|p>>><frac|<math-bf|h>|<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F>|]><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<frac|<math-bf|h>|<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<frac|<math-bf|h>|<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F>|)>.<eq-number>>>>>>

  The last equality holds since <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>=<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<frac|<math-bf|h>|<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F>|)>>,
  which is a direct result of design of matrix
  <math|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>>.
  Then there exists a positive constant <math|c> such that

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><around|\<\|\|\>|<frac|1|<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F>*<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|\<\|\|\>><rsub|<mathrm>>*F<eq-number><label|ssab>>>|<row|<cell|>|<cell|=>|<cell|<around|\<\|\|\>|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<frac|<math-bf|h>|<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<frac|<math-bf|h>|<around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F>|)>*\<Delta\><math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F<eq-number>>>|<row|<cell|>|<cell|\<geq\>>|<cell|c\<cdot\><around|\<\|\|\>|\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|\<\|\|\>><rsub|<mathrm>>*F\<gtr\>0.<eq-number>>>>>>

  Consequently, we have

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><around|\<\|\|\>|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|\<\|\|\>><rsub|<mathrm>>*F<eq-number><label|ssa1>>>|<row|<cell|>|<cell|\<geq\>>|<cell|c\<cdot\><around|\<\|\|\>|\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|\<\|\|\>><rsub|<mathrm>>*F\<cdot\><around|\<\|\|\>|<math-bf|h>|\<\|\|\>><rsub|<mathrm>>*F<eq-number>>>|<row|<cell|>|<cell|=>|<cell|c\<cdot\><around|\<\|\|\>|\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|\<\|\|\>><rsub|<mathrm>>*F\<cdot\><around*|[|<big|sum><rsub|k=1><rsup|M<rsub|b>><big|sum><rsub|n=0><rsup|N-1><big|sum><rsub|i=1><rsup|M<rsub|t>><big|sum><rsub|j=1><rsup|M<rsub|r>><around|\||H<rsub|i,j><rsup|k><around|(|n|)>|\|><rsup|2>|]><rsup|1/2><eq-number>>>|<row|<cell|>|<cell|=>|<cell|c\<cdot\><around|\<\|\|\>|\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|\<\|\|\>><rsub|<mathrm>>*F\<cdot\><around*|[|<around*|(|<big|sum><rsub|k=1><rsup|M<rsub|b>><big|sum><rsub|l=0><rsup|L-1><big|sum><rsub|i=1><rsup|M<rsub|t>><big|sum><rsub|j=1><rsup|M<rsub|r>><around|\||\<alpha\><rsub|i,j><rsup|k><around|(|l|)>|\|><rsup|2>|]><rsup|1/2>.|\<nobracket\>><eq-number>>>>>>

  Thus the dimension-reduced system in (<reference|PICD>) has power gain
  order <math|L*M<rsub|t>*M<rsub|r>*M<rsub|b>>.

  To prove the necessity, we firstly suppose one of <math|\<eta\><rsub|p>>
  column vectors <math|\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>>
  can be written as linear combination of <math|\<eta\>-\<eta\><rsub|p>>
  column vectors <math|<around|{|\<cal-H\><rsub|\<cal-I\><rsub|q>><around|(|<math-bf|h>|)>:p\<neq\>q|}>>.
  Then there exists a column vector, say one column
  <math|\<cal-H\><rsub|\<cal-I\><rsub|p,1>><around|(|<math-bf|h>|)>=<math-bf|A><rsub|\<cal-I\><rsub|p,1>><math-bf|h>>
  of <math|\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>> such
  that

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<around*|[|<with|math-font-family|bf|0><nbsp><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p,2>><around|(|<math-bf|h>|)><nbsp>\<cdots\><nbsp><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p,\<eta\><rsub|p>>><around|(|<math-bf|h>|)>|]><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<around*|[|<with|math-font-family|bf|0><nbsp><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|A><rsub|\<cal-I\><rsub|p,2>><math-bf|h><nbsp>\<cdots\><nbsp><with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)><math-bf|A><rsub|\<cal-I\><rsub|p,\<eta\><rsub|p>>><math-bf|h>|]>.<eq-number>>>>>>

  Taking <math|\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>=<around|[|c,0,\<cdots\>,0|]><rsup|<mathrm>>*T\<in\>\<cal-A\><rsup|\<eta\><rsub|p>>>
  for <math|0\<neq\>c\<in\>\<Delta\>*\<cal-A\>>, we have

  <\equation*>
    <around|\<\|\|\>|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|\<\|\|\>><rsub|<mathrm>>*F=0,
  </equation*>

  which contradicts with the condition that the dimension-reduced system in
  (<reference|PICD>) has power gain order
  <math|L*M<rsub|t>*M<rsub|r>*M<rsub|b>>. It shows that all column vectors
  <math|\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>> do not
  belong to the linear space spanned by column vectors
  <math|<around|{|\<cal-H\><rsub|\<cal-I\><rsub|q>><around|(|<math-bf|h>|)>:p\<neq\>q|}>>.
  Secondly, if <math|<with|math-font-family|bf|0>\<neq\>\<Delta\><math-bf|x>\<in\>\<cal-A\><rsup|\<eta\>>>,
  then there is at least <math|<with|math-font-family|bf|0>\<neq\>\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>\<in\>\<cal-A\><rsup|\<eta\><rsub|p>>>.
  We assume <math|\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|1>>\<in\>\<cal-A\><rsup|\<eta\><rsub|1>>\<neq\><with|math-font-family|bf|0>>
  without loss of generality. Then for any
  <math|<math-bf|h>\<neq\><with|math-font-family|bf|0>> there exists a
  positive constant <math|c> such that

  <eqnarray|<tformat|<table|<row|<cell|<around|\<\|\|\>|\<Delta\><math-bf|Xh>|\<\|\|\>><rsub|<mathrm>>*F<rsup|2><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><around|\<\|\|\>|\<cal-H\><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x>|\<\|\|\>><rsub|<mathrm>>*F<rsup|2><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><around|\<\|\|\>|\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|1>>+<big|sum><rsub|p=2><rsup|P>\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|\<\|\|\>><rsub|<mathrm>>*F<rsup|2><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><around|\<\|\|\>|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|1>>|\<\|\|\>><rsub|<mathrm>>*F<rsup|2><eq-number>>>|<row|<cell|>|<cell|>|<cell|+<around|\<\|\|\>|<math-bf|Q><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|1>>+<big|sum><rsub|p=2><rsup|P>\<cal-H\><rsub|\<cal-I\><rsub|p>><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|p>>|\<\|\|\>><rsub|<mathrm>>*F<rsup|2><eq-number>>>|<row|<cell|>|<cell|\<geq\>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><around|\<\|\|\>|<with|math-font-family|bf|\<Gamma\>><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>*\<cal-H\><rsub|\<cal-I\><rsub|1>><around|(|<math-bf|h>|)>*\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|1>>|\<\|\|\>><rsub|<mathrm>>*F<rsup|2><eq-number>>>|<row|<cell|>|<cell|\<geq\>>|<cell|<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>c\<cdot\><around*|[|<big|sum><rsub|k=1><rsup|M<rsub|b>><big|sum><rsub|l=0><rsup|L-1><big|sum><rsub|i=1><rsup|M<rsub|t>><big|sum><rsub|j=1><rsup|M<rsub|r>><around|\||\<alpha\><rsub|i,j><rsup|k><around|(|l|)>|\|><rsup|2>|]><around|\<\|\|\>|\<Delta\><math-bf|x><rsub|\<cal-I\><rsub|1>>|\<\|\|\>><rsub|<mathrm>>*F<rsup|2>\<gtr\>0<eq-number>>>>>>

  It shows that the matrix <math|\<Delta\><math-bf|X>> has the full rank
  property. This completes the proof of this theorem.

  <subsection|Proof of Theorem 3.4>

  Based on the formula in (<reference|difference1>), we have
  <math|<math-up|rank><math-bf|K><rsub|s>=min<rsub|i\<in\>\<cal-I\>><around|{|<math-bf|A><rsub|i><math-bf|A><rsub|i><rsup|<math-up|H>>\<circ\><space|-0.17em><around|(|R<rsub|b>\<otimes\>R|)>|}>>,
  where matrix <math|<math-bf|A><rsub|i>> has the size
  <math|N*M<rsub|b>\<times\>M<rsub|t>> for <math|i\<in\>\<cal-I\>>. According
  to the rank properties of Hadamard products and Keronecker products, we
  obtain

  <\equation*>
    <math-up|rank><around|(|<math-bf|A><rsub|i><math-bf|A><rsub|i><rsup|<math-up|H>>\<circ\><around|(|R<rsub|b>\<otimes\>R|)>|}>)<space|-0.17em>\<leq\><space|-0.17em><math-up|rank><around|(|<math-bf|A><rsub|i><math-bf|A><rsub|i><rsup|<math-up|H>>|)><math-up|rank><around|(|<around|(|R<rsub|b>|)><math-up|rank><around|(|R|)>|}>).
  </equation*>

  We observe that the rank of <math|<math-bf|A><rsub|i><math-bf|A><rsub|i><rsup|<math-up|H>>>
  is upper bounded by <math|min <around|{|N*M<rsub|b>,M<rsub|t>|}>>, and the
  rank of <math|R> is upper bounded by <math|L>. Therefore, the maximum
  achievable diversity is at most <math|M<rsub|r>*min
  <around|{|L*M<rsub|t><math-up|rank><around|(|R<rsub|b>|)>,N*M<rsub|b>|}>>.
  In a case of the SF code, we have <math|<math-up|rank><around|(|R<rsub|b>|)>=1>,
  and then complete the proof of this theorem.

  <section*|Acknowledgements>

  The authors thank Prof. Xiang-Gen Xia for his valuable motivations to
  improve this paper. This work was supported by the National Natural Science
  Foundation of China (60902044) and World Class University R32-
  2008-000-20014-0 NRF, Korea.

  <\thebibliography|>
    <bibitem|Tarokh04>V. Tarokh, N. Seshadri, and A. R. Calderbank,
    Space-time codes for high data rate wireless communication: Performance
    criterion and code construction, IEEE Trans. Inf. Theory, vol. 44, no. 3,
    pp. 744-765, Mar. 1998.

    <bibitem|Tarokh991>H. Jafarkhani, A Quasi-Orthogonal Space-Time Block
    Code, IEEE Trans. Commun., Vol. 49, No.1, pp. 1-4, Jan. 2001

    <bibitem|Alamouti99>S. M. Alamouti, A simple transmit diversity technique
    for wireless communication, IEEE J. Sel. Areas Commun., vol. 16, no. 10,
    pp. 1451-1458, Oct. 1998.

    <bibitem|Xia09>X. Guo and X.-G. Xia, \<degree\>On full diversity
    space-time block codes with partial interference cancellation group
    decoding,\<pm\> IEEE Trans. Inf. Theory, vol. 55, pp. 4366-4385, Oct.
    2009.

    <bibitem|Zhang04>W. Zhang, X.-G. Xia, and K. B. Letaief,
    Space-time/frequency coding for MIMO-OFDM in next generation broadband
    wireless systems, IEEE Wireless Commun. Mag., vol. 14, no. 6, pp. 32-43,
    Jun. 2007.

    <bibitem|Gong04>Y. Gong and K. B. Letaief, An efficient space-frequency
    coded OFDM system for broadband wireless communications, IEEE Trans.
    Commun., vol. 51, no. 12, pp. 2019-2029, Dec. 2003.

    <bibitem|Su04>W. Su, Z. Safar, M. Olfat, and K. J. R. Liu, Abtaining
    full-diversity space-frequency codes from space-time codes via mapping,
    IEEE Trans. Signal Process., vol. 51, no. 11, pp. 2905-2916, Nov. 2003.

    <bibitem|Su05>W. Su, Z. Safar, and K. J. R. Liu, Full-rate full-diversity
    space-frequency codes with optimum coding advantage, IEEE Trans. Inf.
    Theory, vol. 51, no. 1, pp. 229-249, Jan. 2005.

    <bibitem|Zhang05>W. Zhang, X.-G. Xia, and P. C. Ching, High-rate
    full-diversity space-time-frequency codes for broadband MIMO block-fading
    channels, IEEE Trans. Commun., vol. 55, no. 1, pp. 25-34, Jan.
    2007.<bibitem|Zhang07>W. Zhang, X.-G. Xia, and P. C. Ching,
    Full-diversity and fast ML decoding properties of general orthogonal
    space-time block codes for MIMO-OFDM systems, IEEE Trans. Wireless
    Commun., vol. 6, no. 5, pp. 1647-1653, May 2007.

    <bibitem|Gong526>Y. Gong and K. B. Letaief, Space-frequency-time coded
    OFDM for broadband wireless communications, in Proc. IEEE GLOBECOM, San
    Antonio, Texas, 2001, pp. 519-523.

    <bibitem|GongLiu>Z. Liu, Y. Xin, and G. B. Giannakis,
    Space-time-frequency coded OFDM over frequency-selective fading channels,
    IEEE Trans. Signal Process., vol. 50, no. 10, pp. 2465-2476, Oct. 2002.

    <bibitem|Wang26>B. Lu, X.Wang, and K. R. Narayanan, LDPC-based space-time
    coded OFDM systems over correlated fading channels: Performance analysis
    and receiver design, IEEE Trans. Commun., vol. 50, pp. 74-88, Jan. 2002.

    <bibitem|GSu526>W. Su, Z. Safar, and K. J. R. Liu, Towards maximum
    achievable diversity in space, time and frequency: Performance analysis
    and code design, IEEE Trans. Wireless Commun., vol. 4, no. 4, pp.
    1847-1857, Jul. 2005.

    <bibitem|Xia526>W. Zhang, X.-G. Xia, and P. C. Ching, High-rate
    full-diversity spacetime-frequency codes for broadband MIMO block-fading
    channels, IEEE Trans. Commun., vol. 55, pp. 25-34, Jan. 2007.

    <bibitem|Zhang5>J.-K. Zhang, J. Liu, and K. M.Wong, Linear Toeplitz space
    time block codes, in Proc. IEEE Int. Symp. Inf. Theory (ISIT05),
    Adelaide, Australia, Sep., 2005, pp. 1942-1946.

    <bibitem|Shang5>Y. Shang and X.-G. Xia, A criterion and design for
    space-time block codes achieving full diversity with linear receivers, in
    Proc. IEEE Int. Symp. Inf. Theory (ISIT07), Nice, France, Jun., 2007, pp.
    2906-2910.

    <bibitem|Shang51>Y. Shang and X.-G. Xia, Overlapped Alamouti codes, in
    Proc. IEEE Global Commun. Conf. (Globecom07),Wash., DC, Nov. 26-30, 2007,
    pp. 2927\DC2931.

    <bibitem|Shang52>Y. Shang and X.-G. Xia, Space-time block codes achieving
    full diversity with linear receivers, IEEE Trans. Inf. Theory, vol. 54,
    no. 10, pp. 4528\DC4547, Oct. 2008.

    <bibitem|Dai04>L. Dai, S. Sfar, and K. B. Letaief, An efficient detector
    for combined space-time coding and layered processing, IEEE Trans.
    Commun., vol. 53, no. 9, pp. 1438-1442, Sept. 2005.

    <bibitem|Zhang52>W. Zhang and X.-G. Xia, A systematic design of
    space-time block codes achieving full-diversity and partial interference
    cancellation group decoding, in Proc. IEEE Globecom, Hawaii, USA, Nov.,
    2009.

    <bibitem|Bingham5>J. A. C. Bingham, Multi-carrier modulation for data
    transmission: An idea whose time has come, IEEE Communications Magazine,
    vol.28, no. 5, pp. 5-14, May 1990.

    <bibitem|Letaief99>K. B. Letaief and Y. Zhang, Dynamic multiuser resource
    allocation and adaptation for wireless systems, IEEE Wireless Commun.
    Mag., vol. 13, no. 4, pp. 38-47, Aug. 2006.

    <bibitem|Wang52>B. Lu and X. Wang, Space-time code design in OFDM
    systems, in Proc. IEEE GLOBECOM, San Francisco, CA, Nov./Dec. 2000, vol.
    2, pp. 1000-1004.

    <bibitem|Lu52>H. Bolcskei, M. Borgmann, and A. J. Paulraj,
    Space-frequency coded MIMO-OFDM with variable multiplexing-diversity
    tradeoff, in Proc. IEEE ICC, Anchorage, AK, May 2003, pp. 2837-2841.

    <bibitem|Lu521>T. Kiran and B. S. Rajan, A systematic design of high-rate
    full diversity space frequency codes for MIMO-OFDM systems, in Proc. IEEE
    ISIT, 2005, pp. 2075-2079.

    <bibitem|Lu522>W. Su, Z. Safar, M. Olfat, and K. J. R. Liu, Obtaining
    full-diversity space frequency codes from space-time codes via mapping,
    IEEE Trans. Signal Process., vol. 51, no. 11, pp. 2905-2916, Nov. 2003.

    <bibitem|Lu523>W. Su, Z. Safar, and K. J. R. Liu, Full-rate
    full-diversity space-frequency codes with optimum coding advantage, IEEE
    Trans. Inf. Theory, vol. 51, no. 1, pp. 229-249, Jan. 2005.

    <bibitem|Lu524>X. Ma and G. B. Giannakis, Space-time-multipath coding
    using digital phase sweeping or circular delay diversity, IEEE Trans.
    Signal Process., vol. 53, no. 3, pp. 1121-1131, Mar. 2005.

    <bibitem|Lu525>L. Shao and S. Roy, Rate-one space-frequency block codes
    with maximum diversity for MIMO-OFDM, IEEE Trans. Wireless Commun., vol.
    4, no. 4, pp. 1674-1687, Jul. 2005.

    <bibitem|Lu526>X. Ma and G. B. Giannakis, Full-diversity full-rate
    complex-field space-time coding, IEEE Trans. Signal Process., vol. 51,
    no. 11, pp. 2917-2930, Nov. 2003.

    <bibitem|Liu526>H.-F. Liu and M. C. Chiu, Constructions of asymptotically
    optimal space-frequency codes for MIMO-OFDM systems, IEEE Trans. Inf.
    Theory, vol. 53, no. 5, pp. 1676-1688, May 2007.

    <bibitem|Sezginer526>S. Sezginer and H. Sari, Full-rate full-diversity
    <math|2\<otimes\>2> space-time codes of reduced decoder complexity, IEEE
    Commun. Lett., vol. 11, no. 12, pp. 973-975, Dec., 2007.

    <bibitem|Sirianunpiboonr526>S. Sirianunpiboon, Y. Wu, A. R. Calderbank,
    and S. Howard, Fast optimal decoding of multiplexed orthogonal designs by
    conditional optimization, IEEE Trans. Inform. Theory, vol. 56, No. 3, pp.
    1106-1113, Mar., 2010.

    <bibitem|Sirianunpiboonr52011>S. Siwamogsatham, M. P. Fitz, and J. Grimm,
    A new view of performance analysis of transmit diversity schemes in
    correlated Rayleigh fading, IEEE Trans. Inform. Theory, vol. 48, pp.
    950-956, Apr. 2002.

    <bibitem|H00>R. W. Heath and A. J. Paulraj, Linear Dispersion Codes for
    MIMO Systems Based on Frame Theory, IEEE Trans. Signal Process., Vol.50,
    No.10, pp.2429-2441, Oct. 2002.

    <bibitem|tner05>M. E. Gtner and H. Bcskei, Multiuser
    space-time/frequency code design, in Proc. IEEE ISIT, Seattle, WA, Jul.
    2006, pp. 2819-2823.

    <bibitem|Gallager85>R. G. Gallager, A perspective on multiaccess
    channels, IEEE Trans. Inf. Theory, vol. 31, no. 3, pp. 124-142, Mar.
    1985.
  </thebibliography>
</body>