<TeXmacs|1.99.7>

<style|<tuple|amsart|std-latex>>

<\body>
  <\hide-preamble>
    <new-theorem|theorem|Theorem>

    <new-theorem|lemma|Lemma>

    <new-theorem|proposition|Proposition>

    <new-theorem|corollary|Corollary>

    <new-theorem|Theorem|Theorem>

    <new-theorem|definition|Definition>

    <new-theorem|example|Example>

    <new-theorem|xca|Exercise>

    <new-theorem|remark|Remark>

    <assign|R|<macro|\<bbb-R\>>>

    <assign|N|<macro|\<bbb-N\>>>

    <assign|C|<macro|\<bbb-C\>>>

    <assign|Z|<macro|\<bbb-Z\>>>

    <assign|D|<macro|\<bbb-D\>>>

    <assign|J|<macro|\<cal-J\>>>

    <assign|Jset|<macro|Julia set >>

    <assign|sm|<macro|\<setminus\>>>

    <assign|ovl|<macro|1|<wide|<arg|1>|\<bar\>>>>

    <assign|eps|<macro|\<varepsilon\>>>

    <assign|Circle|<macro|\<bbb-S\><rsup|1>>>

    <assign|I|<macro|\<cal-I\>>>

    <\assign|proofof>
      <\macro|1>
        <vspace|1fn><no-indent><with|font-series|bold|<with|font-shape|small-caps|Proof
        of> <arg|1>. >
      </macro>
    </assign>

    <assign|changed|<macro|1|<with|font-family|ss|color|red|<arg|1>>>>

    <assign|old|<macro|1|<with|color|red|<sout|<arg|1>>>>>

    <assign|discussion|<macro|1|<with|font-family|tt|color|red|<arg|1>>>>

    <assign|hide|<macro|1|>>

    <assign|reminder|<macro|1|<with|font-family|ss|<arg|1>>>>
  </hide-preamble>

  <doc-data|<doc-title|Hausdorff Dimension and Biaccessibility for polynomial
  Julia Sets>|<doc-author|<author-data|<author-name|Philipp
  Meerkamp>|<author-affiliation|Department of Mathematics, Malott Hall,
  Cornell University, Ithaca, NY 14853-4201>|<author-email|pmeerkamp@math.cornell.edu>>>|<doc-author|<author-data|<author-name|Dierk
  Schleicher>|<author-affiliation|School of Engineering and Science, Jacobs
  University, Postfach 750<nbsp>561, D-28725 Bremen,
  Germany>|<author-email|dierk@jacobs-university.de>>>>

  <abstract-data|<abstract-msc|Primary 37F10| 37F20|
  37F35>|<abstract-keywords|Julia set| polynomial| biaccessible| Hausdorff
  dimension>|<\abstract>
    We investigate the set of biaccessible points for connected polynomial
    Julia sets of arbitrary degrees <math|d\<geq\>2>. We prove that the
    Hausdorff dimension of the set of external angles corresponding to
    biaccessible points is less than <math|1>, unless the Julia set is an
    interval. This strengthens theorems of Stanislav Smirnov and Anna Zdunik:
    they proved that the same set of external angles has zero
    <math|1>-dimensional measure.
  </abstract>>

  <section|Introduction><label|sec:Intro>

  The filled-in Julia set <math|K> of a polynomial <math|p:<C>\<to\><C>>,
  defined as the set of points in <math|<C>> with bounded orbits, is often an
  interesting set with rich topological, combinatorial or geometric
  properties. In many cases, such a set is a <em|dendrite>: a compact
  connected locally connected set that does not disconnect the plane. In some
  sense, such a set can often be viewed as an infinite tree. One way to ask
  our main question is, which proportion of this tree consists of
  \Pendpoints\Q, and which proportion consists of \Pnon-endpoints\Q? For
  finite (non-degenerate) trees, there are finitely many endpoints and a
  continuum of non-endpoints (on the arc); but what if the Julia set is a
  dendrite? And what in more general cases of filled-in Julia sets? And how
  are endpoints defined in general?

  One way to make this definition precise is to say that a point <math|z> in
  a tree is an endpoint unless there are points <math|x,y> in the tree,
  different from <math|x>, such that <math|z> is on an injective path
  connecting <math|x> to <math|y>. This definition works best for
  path-connected Julia sets. The definition that we use is the following:
  <em|a point <math|x\<in\>K> is an endpoint unless there are two curves in
  <math|<C><sm>K>, not homotopic to each other, that connect <math|\<infty\>>
  to <math|x>>. Such points <math|x> are also called <em|biaccessible>; an
  equivalent definition is that two different dynamic rays land at <math|x>
  (see the next section). Our main result is that in almost all cases, most
  points in <math|K> (in a very strong sense) are endpoints, unless <math|K>
  is an interval (a straight line segment).

  <\Theorem>
    [Hausdorff dimension of biaccessible angles]<label|Thm:Main>Let <math|p>
    be a polynomial of degree at least <math|2> with connected Julia set
    <math|J=\<partial\>*K>. Then the biaccessible points have external angles
    in a set of Hausdorff dimension less than 1, except when <math|J> is an
    interval.
  </Theorem>

  This result does not have any topological hypotheses on the Julia set,
  other than that it be connected. It need not be locally connected or path
  connected, or uniquely path connected. One might thus wonder whether a
  similar statement might be true for planar dendrites (or even continua)
  with certain conformal self-similarity properties, whether arising in
  complex dynamics or elsewhere.

  Our result extends known theorems by several people. The fact that
  biaccessible points have external angles in a set of <math|1>-dimensional
  measure zero was shown by Smirnov <cite|Sm> and Zdunik <cite|Zd> (in other
  words, these points have zero harmonic measure), except if the Julia set is
  a straight line segment. Earlier, Zakeri <cite|Za> had shown this for
  quadratic polynomials with locally connected Julia sets.

  The Hausdorff dimension of the set of external angles of biaccessible
  points has been investigated as well. Zakeri <cite|Za1> estimated this
  dimension for certain real quadratic polynomials, and Bruin and Schleicher
  <cite-detail|BS|Section<nbsp>14>, <cite|BSnew> gave estimates for all
  complex quadratic polynomials, as well as for certain subsets of parameter
  space (the Mandelbrot set). Radu <cite|RR>, in his Bachelor thesis, proved
  the same result as ours for the case of connected polynomial Julia sets
  satisfying certain additional hypotheses, including local connectivity of
  the Julia set and further assumptions on the critical values.

  <remark>There are also some known lower bounds on the Hausdorff dimension
  of external angles of biaccessible points. The dimension is clearly zero
  for Julia sets with no or only countably many biaccessible points. Bruin
  and Schleicher <cite-detail|BS|Section<nbsp>14>, <cite|BSnew> also showed
  that the dimension is zero for quadratic \PFeigenbaum\Q polynomials: these
  are limits of Julia sets with only countably many biaccessible points. For
  all other quadratic polynomials with connected Julia sets, the dimension is
  strictly positive. It is natural to ask how these results extend to
  polynomials of higher degrees, and whether the Hausdorff measure of the set
  of biaccessible angles in the \Pright\Q dimension is finite and positive
  (at least when the dimension is strictly positive).

  Bruin and Schleicher <cite-detail|BS|Section<nbsp>14>, <cite|BSnew> also
  showed that there can be no uniform upper bound on the Hausdorff dimension
  of biaccessible angles, even for fixed degrees: there are quadratic
  polynomials close to <math|z\<mapsto\>z<rsup|2>-2> where the biaccessible
  points have Hausdorff dimension arbitrarily close to <math|1>.

  Further properties of biaccessible points in polynomial Julia sets have
  been studied by Zakeri and Schleicher <cite|SZ|Za>.

  <remark>The concept of biaccessibility is a topological one, defined in
  terms of homotopy classes of curves outside of the Julia set. However, all
  our arguments are combinatorial and would allow to restate the result in a
  combinatorial way (that would actually be slightly stronger because not all
  dynamic rays must land). We will briefly discuss this in
  Section<nbsp><reference|Sec:Laminations>.

  <vspace|1fn><no-indent><em|Acknowledgement>. We would like to thank Remus
  Radu, Saeed Zakeri and especially Xavier Buff for useful discussions on
  this topic and on an earlier draft of this paper.

  <section|Background>

  Let <math|p:<C>\<rightarrow\><C>> be a polynomial of degree
  <math|d\<geq\>2>, which we may as well assume to be monic. The
  <with|font-shape|italic|filled <Jset>>of <math|p> is the set of all points
  in <math|<C>> with bounded forward orbit under <math|p>, and the
  <with|font-shape|italic|<Jset>>of <math|p> is
  <math|J\<assign\>\<partial\>*K>. It satisfies
  <math|J=p<around|(|J|)>=p<rsup|-1><around|(|J|)>>
  <cite-detail|M|Lemma<nbsp>4.3>.

  The sets <math|K> and <math|J> are nonempty compact subsets of <math|<C>>.
  Moreover, <math|K> is full, i.e., <math|<C>\<setminus\>K> is connected. In
  this paper, we assume that <math|J> (or equivalently <math|K>) is
  connected. In this case, there is a Riemann map

  <\equation>
    \<psi\>:<wide|<C>|\<bar\>>\<setminus\><wide|<D>|\<bar\>>\<rightarrow\><wide|<C>|\<bar\>>\<setminus\>K<space|0.27em>.
  </equation>

  When <math|p> is monic, then <math|\<psi\>> is unique by requiring
  <math|\<psi\><around|(|\<infty\>|)>=\<infty\>> and
  <math|lim<rsub|z\<to\>\<infty\>> \<psi\><around|(|z|)>/z\<to\>1>. This
  Riemann map satisfies

  <\equation>
    \<psi\><around|(|z<rsup|d>|)>=p<around|(|\<psi\><around|(|z|)>|)><space|0.27em>;<label|Eq:Conjugation>
  </equation>

  i.e., it conjugates <math|p> on its basin of <math|\<infty\>> to
  <math|z\<mapsto\>z<rsup|d>>.

  For <math|t\<in\>\<Circle\>\<assign\><R>/<Z>>, the image of the radial line
  <math|<around|{|\<psi\>*<around|(|r*e<rsup|2*\<pi\>*i*t>|)>:r\<gtr\>1|}>>
  is called the <with|font-shape|italic|dynamic ray at (external) angle
  <math|t>> and denoted <math|R<rsub|t>\<subset\><wide|<C>|\<bar\>>\<setminus\>K>;
  it satisfies <math|p<around|(|R<rsub|t>|)>=R<rsub|d*t>>.

  Consider the radial limit

  <\equation>
    <label|Limit>\<gamma\><around|(|t|)>=lim<rsub|r\<searrow\>1>
    \<psi\>*<around|(|r*e<rsup|2*\<pi\>*i*t>|)>.
  </equation>

  It need not exist for all <math|t\<in\>\<Circle\>>, but it is well known to
  exist for almost all <math|t> <cite-detail|M|Theorem<nbsp>18.2>. If this
  limit exists, one says that the ray <math|R<rsub|t>>
  <with|font-shape|italic|lands> at the point
  <math|\<gamma\><around|(|t|)>\<in\>J>.

  For all angles <math|t\<in\>\<Circle\>> for which <math|R<rsub|t>> lands,
  the ray <math|R<rsub|d*t>> lands as well, and

  <\equation>
    <label|conjugacy>\<gamma\>*<around|(|d*t|)>=p<around|(|\<gamma\><around|(|t|)>|)><space|0.27em>.
  </equation>

  Thus <math|\<gamma\>> is a semiconjugation of multiplication by <math|d> on
  <math|\<Circle\>> to the action of <math|p> on the <Jset>(restricted to
  those angles the rays of which land, and the corresponding landing points).
  In the particular case when the Julia set <math|J> is locally connected,
  the map <math|\<gamma\>:\<Circle\>\<rightarrow\>J> is defined everywhere,
  and it is a continuous surjection <math|\<gamma\>:\<Circle\>\<to\>J>
  <cite-detail|M|Theorem<nbsp>18.3>.

  We will denote distance on <math|\<Circle\>> by <math|\<tau\>> (normalized
  so as to inherit the metric locally from <math|<R>>, and always measuring
  along the shorter of the two arcs connecting two points in
  <math|\<Circle\>>). For an interval <math|I\<subset\>\<Circle\>>, let
  <math|\<tau\><around|(|I|)>> denote its length.

  A point <math|z\<in\>J> is called <with|font-shape|italic|accessible> if
  <math|z> is the landing point of a dynamic ray (by Lindelf's theorem, this
  is equivalent to the existence of a curve in <math|<C>\<setminus\>K>
  converging to <math|z>). The point <math|z> is called
  <with|font-shape|italic|biaccessible> if it is the landing point of at
  least two rays. If two dynamic rays <math|R<rsub|t>> and
  <math|R<rsub|t<rprime|'>>> land together, we call the external angles
  <math|t> and <math|t<rprime|'>> <with|font-shape|italic|biaccessible
  angles>, and we call <math|<around|(|t,t<rprime|'>|)>> a
  <with|font-shape|italic|biaccessible angle pair>. Let
  <math|\<Lambda\>\<subset\>\<Circle\>> be the set of all angles in
  biaccessible angle pairs. A <em|ray pair> is a set of two dynamic rays that
  land at a common point (so that their external angles form a biaccessible
  angle pair).

  As usual, a <with|font-shape|italic|critical point> of <math|p> is a point
  <math|z> with <math|p<rprime|'><around|(|z|)>=0>, and
  <math|p<around|(|z|)>> is the corresponding
  <with|font-shape|italic|critical value>.

  <\remark>
    <label|Remark>Note that <math|z> is biaccessible if and only if
    <math|p<around|(|z|)>> is biaccessible, unless <math|z> is a critical
    point for <math|p>. This also means that <math|t> is a biaccessible angle
    if and only if so is <math|d*t>, except when <math|R<rsub|t>> lands at a
    critical point.
  </remark>

  <\remark>
    <label|Rem:PolyAccessible>It may also happen that three or more rays land
    at a single point. We call such a point \Ppoly-accessible\Q. It is well
    known and easy to see that such points always form a countable set
    <cite-detail|Po|Proposition<nbsp>2.18> (for every <math|<eps>\<gtr\>0>,
    there can only be finitely many landing points of three rays the angles
    of which have mutual distance at least <math|<eps>>). If three or more
    rays land at the same point that is not eventually periodic and not
    eventually critical, then this landing point is called a \Pwandering
    triangle\Q (or, more generally, a \Pwandering polygon\Q), and the number
    of rays at such points, as well as the number of such orbits, satisfy
    certain bounds depending on the degree of <math|d>, in particular these
    numbers are finite (compare <cite|Kiwi|BL|BCLOS>). If three or more rays
    land at a periodic point, then either the landing point is repelling or
    parabolic and the number of rays is finite, or the landing point is a
    Cremer point (in which case it is not known whether any rays may land at
    all; compare <cite|SZ>). In total, there can thus be only countably many
    poly-accessible points, and exceptfor Cremer points the total number of
    rays involved is countable.
  </remark>

  <section|Endpoints of the Julia Set><label|sec:Arcs>

  <\definition>
    [J-Endpoint]<label|def:ends>A point <math|t\<in\>\<Circle\>> will be
    called a J-endpoint of a Julia set if there exists a sequence
    <math|<around|(|t<rsub|n>,t<rprime|'><rsub|n>|)>> of biaccessible angle
    pairs such that

    <\equation*>
      t<rsub|n>\<rightarrow\>t,<space|20pt>t<rprime|'><rsub|n>\<rightarrow\>t,
    </equation*>

    and such that for all large <math|n>, the point <math|t> lies in the
    shorter arc of <math|\<Circle\>> connecting <math|t<rsub|n>> and
    <math|t<rprime|'><rsub|n>>.
  </definition>

  <\lemma>
    [Trichotomy]<label|Lem:Trichotomy>For every connected polynomial Julia
    set <math|J>, exactly one of the following three cases holds:

    <\itemize>
      <item><math|J> has no biaccessible points and <math|\<Lambda\>> is
      empty;

      <item><math|J> is an interval and <math|\<Lambda\>> is
      <math|\<Circle\>> minus two points;

      <item><math|J> has at least three J-endpoints and <math|\<Lambda\>> is
      dense.
    </itemize>
  </lemma>

  <\proof>
    These three cases are clearly mutually exclusive. If <math|\<Lambda\>> is
    non-empty, then the preimage of any biaccessible point in <math|J> is a
    biaccessible point, and it follows easily that <math|\<Lambda\>> is
    infinite and dense.

    Now we show that if <math|\<Lambda\>> is non-empty, then <math|J> has at
    least two J-endpoints. Consider a biaccessible angle pair
    <math|<around|(|t,t<rprime|'>|)>>. The angles <math|t> and
    <math|t<rprime|'>> separate the circle <math|\<Circle\>> into two open
    intervals, say <math|I> and <math|I<rprime|'>>. Since <math|\<Lambda\>>
    is dense, there is a biaccessible angle pair
    <math|<around|(|t<rsub|1>,t<rsub|1><rprime|'>|)>> with
    <math|t<rsub|1>,t<rprime|'><rsub|1>\<in\>I>. Let
    <math|I<rsub|1>\<subset\>I> be the interval bounded by <math|t<rsub|1>>
    and <math|t<rsub|1><rprime|'>>. It has strictly smaller length than
    <math|I>; in fact, choosing <math|t<rsub|1>> in the middle third of
    <math|I>, we can assure that the length of <math|I<rsub|1>> is at most
    <math|2/3> of the length of <math|I>. Iterating this argument, we find a
    biaccessible angle pair in arbitrarily small intervals inside <math|I>
    and hence at least one J-endpoint in <math|I> (i.e., this J-endpoint is
    in the impression of a ray with angle in <math|I>). In a similar way we
    find at least one J-endpoint in <math|I<rprime|'>>. Thus the Julia set
    <math|J> has at least two J-endpoints.

    If <math|J> has exactly two J-endpoints, then <math|J> is an interval by
    <cite-detail|Zd|Lemma<nbsp>2> (and <math|p> is a Chebyshev polynomial, up
    to sign); see also <cite|Zd1>. (The idea is this: if a critical value is
    not a J-endpoint, then the corresponding critical point is a branch point
    of <math|J> and creates extra J-endpoints; moreover, J-endpoints always
    map to J-endpoints. This implies that if <math|J> has only two
    J-endpoints, then it is postcritically finite and has only two critical
    values. By conjugation, we may suppose that these two critical values are
    real. The polynomial <math|p> has a Hubbard tree without branch points,
    and all critical values are endpoints of this tree. The Hubbard tree is
    thus backwards invariant, so it equals the Julia set.)
  </proof>

  For us, the only interesting case is when the Julia set has at least three
  J-endpoints. We will assume this from now on.

  <section|Narrow Preimages of Ray Pairs><label|Sec:Narrow>

  Let <math|<around|(|t,t<rprime|'>|)>> be a biaccessible angle pair and
  <math|<around|(|t<rsub|1>,t<rprime|'><rsub|1>|)>> one of its preimage
  biaccessible angle pairs, i.e., a biaccessible angle pair with
  <math|d*t<rsub|1>=t> and <math|d*t<rprime|'><rsub|1>=t<rprime|'>>. We call
  the preimage <math|<around|(|t<rsub|1>,t<rprime|'><rsub|1>|)>> <em|narrow>
  if <math|\<tau\><around|(|t<rsub|1>,t<rprime|'><rsub|1>|)>=\<tau\><around|(|t,t<rprime|'>|)>/d>.
  An (iterated) preimage biaccessible angle pair
  <math|<around|(|t<rsub|n>,t<rprime|'><rsub|n>|)>> is called <em|narrow of
  generation <math|n>> if <math|<around|(|t<rsub|n>,t<rprime|'><rsub|n>|)>>
  is obtained from <math|<around|(|t,t<rprime|'>|)>> by taking <math|n>
  generations of preimages, and all intermediate preimages are narrow (so
  that <math|\<tau\><around|(|t<rsub|n>,t<rprime|'><rsub|n>|)>=\<tau\><around|(|t,t<rprime|'>|)>/d<rsup|n>>)<space|0.17em>).

  Our assumption that the Julia set has at least three J-endpoints implies
  that there are three biaccessible angle pairs, say
  <math|<around|(|a,a<rprime|'>|)>>, <math|<around|(|b,b<rprime|'>|)>> and
  <math|<around|(|c,c<rprime|'>|)>>, so that none of them separates the other
  two: we may assume that the cyclic order of these six angles is
  <math|a,a<rprime|'>,b,b<rprime|'>,c,c<rprime|'>>. To simplify the
  reasoning, suppose that the longer of the two intervals of
  <math|\<Circle\><sm><around|{|a,a<rprime|'>|}>> contains
  <math|<around|{|b,b<rprime|'>,c,c<rprime|'>|}>>, and similarly for
  <math|\<Circle\><sm><around|{|b,b<rprime|'>|}>> and
  <math|\<Circle\><sm><around|{|c,c<rprime|'>|}>>. We will call biaccessible
  angle pairs with this property <em|un-nested>. Each Julia set with at least
  three J-endpoints clearly has three such angle pairs.

  <\lemma>
    [Number of narrow preimage biaccessible angle
    pairs]<label|Lem:NumberStronglyNarrow>Consider a polynomial <math|p> of
    degree <math|d\<ge\>2> and suppose it has three un-nested biaccessible
    angle pairs. For generations <math|n\<ge\>0>, let <math|s<rsub|n>> be the
    combined number of narrow preimage biaccessible angle pairs of all three
    biaccessible angle pairs. Then <math|s<rsub|n+1>\<ge\>d*s<rsub|n>-2*<around|(|d-1|)>>.
  </lemma>

  <\proof>
    Denote the three given biaccessible angle pairs by
    <math|<around|(|a,a<rprime|'>|)>>, <math|<around|(|b,b<rprime|'>|)>> and
    <math|<around|(|c,c<rprime|'>|)>>. The set
    <math|<C><sm><ovl|R<rsub|a>\<cup\>R<rsub|a<rprime|'>>>> consists of two
    components, say <math|B<rsub|a>> and <math|B<rprime|'><rsub|a>>. The
    assumption that the three given ray pairs are non-nested means that one
    of these components, say <math|B<rprime|'><rsub|a>>, contains the other
    two given ray pairs; define <math|B<rsub|b>> and <math|B<rsub|c>>
    analogously.

    Suppose for simplicity that non of the ray pairs considered lands at a
    critical value. The immediate preimage of the biaccessible angle pair
    <math|<around|(|a,a<rprime|'>|)>> consists of <math|d> disjoint
    biaccessible angle pairs that may or many not be nested. The
    corresponding ray pairs disconnect <math|<C>> into <math|d+1> open
    complementary domains <math|U<rsub|1>,\<ldots\>,U<rsub|d+1>>. Each of the
    <math|U<rsub|j>> maps under <math|p> as a proper holomorphic map onto a
    component of <math|<C><sm><ovl|R<rsub|a>\<cup\>R<rsub|a<rprime|'>>>>, so
    each <math|U<rsub|j>> has an associated mapping degree that equals the
    number of critical points on <math|U<rsub|j>> plus <math|1> (always
    counting multiplicities). A domain <math|U<rsub|j>> is narrow (i.e.,
    <math|U<rsub|j>> is bounded by a single ray pair, and this ray pair is
    narrow) if and only if <math|U<rsub|j>> maps conformally onto
    <math|B<rsub|a>>; this implies that <math|U<rsub|j>> does not contain a
    critical point.

    The case with the maximal count of narrow components <math|U<rsub|j>> is
    when a single domain <math|U<rsub|d+1>> contains all <math|d-1> critical
    points and maps onto <math|B<rprime|'><rsub|a>> with degree <math|d>, and
    all other domains <math|U<rsub|1>>,..., <math|U<rsub|d>> map conformally
    onto <math|B<rsub|a>> and are narrow.

    If a domain <math|U<rsub|j>> contains a single critical point, then its
    mapping degree is <math|2>; if <math|U<rsub|j>> maps to <math|B<rsub|a>>,
    then the count of possible narrow domains <math|U<rsub|j>> decreases by
    <math|2>. Each further critical point in <math|U<rsub|j>> decreases this
    count by <math|1>. Therefore, the number of narrow components
    <math|U<rsub|j>> is at least <math|d> minus twice the number of critical
    points the images of which are in <math|B<rsub|a>>.

    The same arguments apply to the angle pairs
    <math|<around|(|b,b<rprime|'>|)>> and <math|<around|(|c,c<rprime|'>|)>>.
    Note that the domains <math|B<rsub|a>>, <math|B<rsub|b>>, and
    <math|B<rsub|c>> are disjoint, so each critical point that reduces the
    number of narrow components can count only for one of the three ray
    pairs. Therefore, the total number of narrow preimages of
    <math|<around|(|a,a<rprime|'>|)>>, <math|<around|(|b,b<rprime|'>|)>> and
    <math|<around|(|c,c<rprime|'>|)>> is <math|s<rsub|1>\<ge\>3*d-2*<around|(|d-1|)>=d+2>.
    All <math|s<rsub|1>> ray pairs are narrow and non-nested. Note that
    initially we had <math|s<rsub|0>=3> angle pairs, and
    <math|s<rsub|1>\<ge\>d*s<rsub|0>-2*<around|(|d-1|)>> as claimed.

    For the inductive step, the three initial angle pairs are replaced by
    <math|s<rsub|n>> non-nested ray pairs; for these, the argument can be
    repeated: each of these <math|s<rsub|n>> has at least <math|d*s<rsub|n>>
    narrow preimages minus twice the number of critical points that map into
    the narrow complementary component of any ray pair, and again each
    critical point can reduce the count of narrow preimages for only one ray
    pair, and only by two. This yields the formula
    <math|s<rsub|n+1>\<ge\>d*s<rsub|n>-2*<around|(|d-1|)>> as claimed.

    Finally, if some ray pair lands at a critical value, then some of its
    preimage ray pairs merge, and the statement remains true for an
    appropriate choice of rays to form pairs.
  </proof>

  Let <math|E> be the set of external angles with the property that for each
  <math|t\<in\>E>, there are infinitely many narrow biaccessible angle pairs
  <math|<around|(|t<rsub|k>,t<rprime|'><rsub|k>|)>> on the backwards orbit of
  <math|<around|(|a,a<rprime|'>|)>>, <math|<around|(|b,b<rprime|'>|)>>, or
  <math|<around|(|c,c<rprime|'>|)>> so that the interval
  <math|<around|(|t<rsub|k>,t<rprime|'><rsub|k>|)>\<subset\>\<Circle\>>
  contains <math|t>, and so that the lengths of these intervals tend to
  <math|0>. (<math|E> stands for \Pendpoints\Q of the Julia set.)

  <\lemma>
    Angles in <math|E> are not part of any biaccessible angle pair.
  </lemma>

  <\proof>
    Suppose that <math|<around|(|t,t<rprime|'>|)>> is a biaccessible angle
    pair, but <math|t\<in\>E>. Then there is a narrow biaccessible angle pair
    <math|<around|(|t<rsub|k>,t<rprime|'><rsub|k>|)>> with
    <math|\<tau\><around|(|t<rsub|k>,t<rprime|'><rsub|k>|)>\<less\>\<tau\><around|(|t,t<rprime|'>|)>>
    andso that the interval <math|<around|(|t<rsub|k>,t<rprime|'><rsub|k>|)>>
    contains <math|t>; this interval thus cannot contain <math|t<rprime|'>>.
    This is a contradiction unless all the rays at angles
    <math|t<rsub|k>,t<rprime|'><rsub|k>,t,t<rprime|'>> land at the same
    point. This would imply that for all biaccessible angle pairs
    <math|<around|(|t<rsub|m>,t<rprime|'><rsub|m>|)>> of higher generation
    than <math|<around|(|t<rsub|k>,t<rprime|'><rsub|k>|)>> such that <math|t>
    is contained in the interval <math|<around|(|t<rsub|m>,t<rprime|'><rsub|m>|)>>,
    the rays <math|R<rsub|t<rsub|m>>> and <math|R<rsub|t<rprime|'><rsub|m>>>
    must also land at the same point, so infinitely many rays would land at
    this point. We will now show that this is impossible.

    Indeed, the set <math|<C><sm><ovl|R<rsub|t<rsub|k>>\<cup\>R<rsub|t<rprime|'><rsub|k>>>>
    consists of two components; let <math|U<rsub|k>> be the component
    containing <math|R<rsub|t>>, and define <math|U<rsub|m>> similarly. We
    may assume that both angle pairs are on the backwards orbit of the same
    angle pair <math|<around|(|a,a<rprime|'>|)>>,
    <math|<around|(|b,b<rprime|'>|)>>, or <math|<around|(|c,c<rprime|'>|)>>,
    and indeed that <math|<around|(|t<rsub|m>,t<rprime|'><rsub|m>|)>> is on
    the backwards orbit of <math|<around|(|t<rsub|k>,t<rprime|'><rsub|k>|)>>,
    say after <math|s\<gtr\>0> iterations. Since all biaccessible angle pairs
    are narrow, this implies that <math|p<rsup|\<circ\>s>:U<rsub|m>\<to\>U<rsub|k>\<supset\>U<rsub|m>>
    is a conformal isomorphism with conformal inverse
    <math|q:U<rsub|k>\<to\>U<rsub|m>>. Iterating <math|q>, it follows that
    <math|t> is a periodic angle, so the landing point is repelling or
    parabolic, and only finitely many rays land there (compare
    Remark<nbsp><reference|Rem:PolyAccessible>).
  </proof>

  So all we need to do is prove that <math|\<Circle\><sm>E> has Hausdorff
  dimension less than <math|1> (most angles correspond to J-endpoints). We
  will prove the following result.

  <\lemma>
    <label|Lem:DimensionLemma>The Hausdorff dimension of
    <math|\<Circle\><sm>E> satisfies <math|dim<rsub|H><around|(|\<Circle\><sm>E|)>\<less\>\<eta\>\<less\>1>,
    where <math|\<eta\>> depends only on <math|d> and the lengths of
    <math|<around|(|a,a<rprime|'>|)>>, <math|<around|(|b,b<rprime|'>|)>>, and
    <math|<around|(|c,c<rprime|'>|)>>.
  </lemma>

  <\remark>
    Let <math|\<alpha\>> be the minimum of the three lengths of
    <math|<around|(|a,a<rprime|'>|)>>, <math|<around|(|b,b<rprime|'>|)>>,
    <math|<around|(|c,c<rprime|'>|)>>. The quantity <math|\<alpha\>> is, in
    some sense, a measure of the \Psize\Q of branch points of the Julia set:
    in a locally connected Julia set, a branch point <math|q> is the landing
    point of at least three dynamic rays, and its size can be defined as

    <\equation*>
      s<around|(|q|)>=sup <around|{|\<delta\>\<gtr\>0:<text|three rays at
      angles <math|t<rsub|1>>, <math|t<rsub|2>>, <math|t<rsub|3>> land at
      <math|q> with <math|\<tau\><around|(|t<rsub|i>,t<rsub|j>|)>\<gtr\>\<delta\>>
      for >i\<neq\>j|}><space|0.27em>.
    </equation*>
  </remark>

  This definition coincides with the maximal possible value of
  <math|\<alpha\>> in the locally connected case, so <math|\<alpha\>> can
  indeed be seen as a measure of size of a branch point (a branch point is
  \Psmall\Q if all the rays landing at it can be grouped into two sets so
  that the angles are contained in short intervals).

  The proof of Lemma<nbsp><reference|Lem:DimensionLemma> will be given, in
  somewhat abstract form, in the next section.

  <section|Hausdorff dimension>

  Let <math|g:\<Circle\>\<to\>\<Circle\>> be multiplication of angles by
  <math|d\<ge\>2>.

  <\lemma>
    Let <math|I<rsub|1>,I<rsub|2>,I<rsub|3>\<subset\>\<Circle\>> be three
    disjoint open intervals, each of length <math|d<rsup|-N>> for some
    <math|N\<in\><N>>, and each bounded by endpoints in <math|<Z>/d<rsup|N>>
    (projected into <math|<R>/Z>). Let <math|<I><rsub|0>\<assign\><around|{|I<rsub|1>,I<rsub|2>,I<rsub|3>|}>>.
    For <math|n\<ge\>1>, let <math|<I><rsub|n>> be the set of all
    <math|g>-preimages of all intervals in <math|<I><rsub|n-1>>, except that
    <math|2*<around|(|d-1|)>> intervals are missing in <math|<I><rsub|n>>.
    Then <math|<around|\||<I><rsub|n>|\|>=d<rsup|n>+2>, and for every
    <math|m\<in\><N>>, the set

    <\equation*>
      \<Circle\><sm><big|cup><rsub|n\<ge\>m><big|cup><rsub|I\<in\><I><rsub|n>>I
    </equation*>

    has Minkowski dimension at most <math|1-3/d<rsup|N>*N*log d\<less\>1>.
  </lemma>

  <\proof>
    We have <math|<around|\||<I><rsub|0>|\|>=3=d<rsup|0>+2> and
    <math|<around|\||<I><rsub|n+1>|\|>=d<around|\||<I><rsub|n>|\|>-2*<around|(|d-1|)>=d<rsup|n+1>+2>
    by induction.

    The condition on the endpoints assures that whenever
    <math|n<rprime|'>\<gtr\>n>, each interval in <math|<I><rsub|n<rprime|'>>>
    is either disjoint from or contained in any interval in
    <math|<I><rsub|n>>.

    For <math|n\<in\><N>>, set <math|A<rsub|n>\<assign\><big|cup><rsub|i\<in\><I><rsub|n>>I>,
    and let <math|c<rsub|n>> be the number of intervals of length
    <math|d<rsup|-n>> required to cover <math|\<Circle\><sm>A<rsub|n>>.

    The set <math|\<Circle\><sm>A<rsub|0>> consists of <math|3> intervals of
    length less than <math|1>. The set <math|\<Circle\><sm>g<rsup|-n><around|(|A<rsub|0>|)>>
    thus consists of <math|3*d<rsup|n>> intervals of length less than
    <math|d<rsup|-n>>, for each <math|n> (in this argument, we do not delete
    the <math|2*<around|(|d-1|)>> intervals in each generation).

    In general, we have <math|c<rsub|n+1>\<le\>d*c<rsub|n>+2*<around|(|d-2|)>>:
    taking preimages under <math|g> increases the required number of
    intervals by a factor of <math|d> (the length of the intervals decreases
    by a factor <math|d>), and each removed interval in <math|<I><rsub|n+1>>
    might require an extra covering interval.

    Choose <math|\<beta\>\<gtr\>0> so that
    <math|\<gamma\>\<assign\><around|(|1+\<beta\>|)><rsup|N>*<around|(|1-3*d<rsup|-N>|)>\<less\>1>.
    There is an <math|M\<in\><N>> so that
    <math|c<rsub|n+1>\<le\><around|(|1+\<beta\>|)>*d*c<rsub|n>> for all
    <math|n\<ge\>M>; possibly by enlarging <math|M>, suppose that <math|M> is
    divisible by <math|N>.

    The set <math|\<Circle\><sm>A<rsub|M>> can be covered by some number
    <math|C\<assign\>c<rsub|M>> intervals of length <math|d<rsup|-M>>. Then
    <math|\<Circle\><sm>A<rsub|M+N>> can be covered by
    <math|c<rsub|M+N>\<le\>d<rsup|N>*<around|(|1+\<beta\>|)><rsup|N>*C>
    intervals of length <math|d<rsup|-<around|(|M+N|)>>>, and
    <math|\<Circle\><sm><around|(|A<rsub|M+N>\<cup\>A<rsub|0>|)>> can be
    covered by <math|<around|(|d<rsup|N>-3|)>*<around|(|1+\<beta\>|)><rsup|N>*C=\<gamma\>*d<rsup|N>*C>
    intervals of the same length, because one in <math|d<rsup|N>> intervals
    is contained in each of the intervals in <math|A<rsub|0>>.

    This argument can be repeated: <math|\<Circle\><sm><around|(|A<rsub|M+2*N>\<cup\>A<rsub|N>|)>>
    can be covered by <math|<around|(|1+\<beta\>|)><rsup|N>*\<gamma\>*d<rsup|2*N>*C>
    intervals of length <math|d<rsup|-<around|(|M+2*N|)>>>, and for
    <math|\<Circle\><sm><around|(|A<rsub|M+2*N>\<cup\>A<rsub|N>\<cup\>A<rsub|0>|)>>,
    at most <math|<around|(|1-3*d<rsup|-N>|)>*<around|(|1+\<beta\>|)><rsup|N>*\<gamma\>*d<rsup|2*N>*C=\<gamma\><rsup|2>*d<rsup|2*N>*C>
    intervals are required.

    Let us focus on the case <math|m=0> in the claim: we are interested in
    the set <math|\<Circle\><sm><big|cup><rsub|n\<ge\>0>A<rsub|n>>, and this
    is contained in

    <\equation*>
      \<Circle\><sm><big|cup><rsub|k\<ge\>0>A<rsub|k*N>\<subset\>\<Circle\><sm><around*|(|A<rsub|M+K*N>\<cup\>A<rsub|<around|(|K-1|)>*N>\<cup\>A<rsub|<around|(|K-2|)>*N>\<cup\>\<ldots\>\<cup\>A<rsub|N>\<cup\>A<rsub|0>|)><space|0.27em>,
    </equation*>

    and this latter set can be covered by
    <math|\<gamma\><rsup|K>*d<rsup|K*N>*C> intervals of length
    <math|d<rsup|-<around|(|M+K*N|)>>>.

    For the Minkowski dimension, we get the upper bound

    <\equation*>
      lim<rsub|K\<to\>\<infty\>> <frac|log
      <around|(|\<gamma\><rsup|K>*d<rsup|K*N>*C|)>|log
      d<rsup|M+K*N>>=<frac|log <around|(|\<gamma\>*d<rsup|N>|)>|log
      d<rsup|N>>=1+<frac|log <around|(|1-3*d<rsup|-N>|)>+N*log
      <around|(|1+\<beta\>|)>|log d<rsup|N>><space|0.27em>.
    </equation*>

    Now <math|\<beta\>> can be chosen arbitrarily close to <math|0>. Since
    <math|log <around|(|1-3*d<rsup|-N>|)>\<less\>-3*d<rsup|-N>>, the
    dimension is bounded above by <math|1-3*d<rsup|-N>/N*log d>.

    Now we treat the case <math|m\<gtr\>0>. The set
    <math|\<Circle\><sm><big|cup><rsub|n\<ge\>0>A<rsub|n>> can be covered by
    <math|\<gamma\><rsup|K>*d<rsup|K*N>*C> intervals of length
    <math|d<rsup|-M+K*N>>, for every <math|K\<ge\>0>, so
    <math|\<Circle\><sm><big|cup><rsub|n\<ge\>m>A<rsub|n>> can be covered by
    <math|<around|(|1+\<beta\>|)><rsup|m>*\<gamma\><rsup|K>*d<rsup|K*N+m>*C>
    intervals of length <math|d<rsup|-<around|(|M+K*N+m|)>>>, and this leads
    to the same dimension.
  </proof>

  <\corollary>
    Using the notation of the previous lemma, the set

    <\equation*>
      \<Circle\><sm><big|cap><rsub|m\<ge\>0><big|cup><rsub|n\<ge\>m><big|cup><rsub|I\<in\><I><rsub|n>>
    </equation*>

    has Hausdorff dimension at most <math|<with|math-display|true|1-3/d<rsup|N>*N*log
    d>>.
  </corollary>

  <\proof>
    By the lemma, each set <math|B<rsub|m>\<assign\>\<Circle\><sm><big|cup><rsub|n\<ge\>m>A<rsub|n>=\<Circle\><sm><big|cup><rsub|n\<ge\>m><big|cup><rsub|I\<in\><I><rsub|n>>I>
    satisfies the same upper bound for Minkowski dimension, hence Hausdorff
    dimension. The set we are interested in is
    <math|\<Circle\><sm><big|cap><rsub|m><big|cup><rsub|n\<ge\>m>A<rsub|m>=<big|cup><rsub|m><around|(|\<Circle\><sm><big|cup><rsub|n\<ge\>m>A<rsub|n>|)>=<big|cup><rsub|m>B<rsub|m>>,
    and Hausdorff dimension is stable under countable unions.
  </proof>

  <\proofof|Lemma<nbsp><reference|Lem:DimensionLemma>>
    \ If the Julia set has three J-endpoints, then there are three
    biaccessible angle pairs <math|<around|(|a,a<rprime|'>|)>,<around|(|b,b<rprime|'>|)>,<around|(|c,c<rprime|'>|)>>
    so that the three intervals <math|<around|(|a,a<rprime|'>|)>>,
    <math|<around|(|b,b<rprime|'>|)>>, <math|<around|(|c,c<rprime|'>|)>> (as
    subsets of <math|\<Circle\>>) are disjoint. Let <math|\<alpha\>\<gtr\>0>
    be the minimum of their lengths. Their combined number of narrow
    preimages of generation <math|1> is at least
    <math|3*d-2*<around|(|d-2|)>=d+2> by Lemma<nbsp><reference|Lem:NumberStronglyNarrow>.
    If <math|d\<ge\>5>, then at least one of these three intervals, say
    <math|<around|(|a,a<rprime|'>|)>>, has three narrow preimages of length
    <math|\<alpha\>/d>.

    Call these intervals <math|I<rsub|1>>, <math|I<rsub|2>>,
    <math|I<rsub|3>>. The number of narrow preimages of further generations
    grows as in Lemma<nbsp><reference|Lem:NumberStronglyNarrow>. If we
    construct sets of intervals <math|<I><rsub|n>> as above and set
    <math|A<rsub|n>\<assign\><big|cup><rsub|I\<in\><I><rsub|n>>I>, then we
    have <math|E=<big|cap><rsub|m\<ge\>0><big|cup><rsub|n\<ge\>m>A<rsub|n>>.

    Our intervals do not yet satisfy the condition on the form of the
    endpoints, so we cannot directly apply the corollary. Restricting
    <math|<around|(|a,a<rprime|'>|)>> to a subinterval of length at least
    <math|1/2*d> times the original length, we obtain an interval
    <math|I<rsub|0>\<subset\><around|(|a,a<rprime|'>|)>> that is bounded by
    two numbers <math|k/d<rsup|N>> and <math|<around|(|k+1|)>/d<rsup|N>> for
    <math|k,N\<in\><N>>. This yields smaller sets <math|A<rsub|n>> and a
    smaller set <math|E>, hence a larger set <math|\<Circle\><sm>E>. The
    corollary applied to this larger set shows that <math|\<Circle\><sm>E>
    has Hausdorff dimension less than <math|1>.

    If <math|d\<in\><around|{|3,4|}>>, then we might have to resort to narrow
    intervals of generation two, ofwhich there are at least
    <math|d<rsup|2>+2\<ge\>11> for all three intervals combined, and the
    argument proceeds as above (except that the dimension formula uses
    intervals of length <math|\<alpha\>/d<rsup|2>>, rather than
    <math|\<alpha\>/d>).

    Finally, if <math|d=2>, then we have to go one generation further.
    <math|\<Box\>>
  </proofof>

  \ <vspace|1fn>

  This also proves the theorem.

  <section|A Remark on Laminations and Entropy><label|Sec:Laminations>

  As mentioned earlier, our results can also be stated in terms of
  laminations of Julia set, as developed by Thurston
  <cite-detail|Th|Chapter<nbsp>II>. In the complex unit disk <math|<D>>, we
  identify the boundary <math|\<partial\><D>=\<Circle\>/<Z>> with the set of
  external angles. For a given connected polynomial Julia set <math|J>, we
  connect two angles <math|\<alpha\>,\<beta\>\<in\>\<partial\><D>> by a
  geodesic of <math|<D>> whenever the two rays at angles <math|\<alpha\>> and
  <math|\<beta\>> land at a common (biaccessible) point. One usually uses
  hyperbolic geodesics for this purposes because this yields clearer
  pictures, even though the results are equivalent. Every biaccessible point
  is thus represented by an arc in <math|<D>>; polyaccessible points are
  represented by polygons. The <em|lamination> <math|J> is the closure of all
  these arcs (if the Julia set is locally connected, then the set of arcs is
  closed to begin with), and each arc is called a <em|leaf> in this
  lamination. A degenerate leaf is one that connects an angle to itself (it
  is a point).

  <big-figure|<image|Fig9-56c.eps|0.5tex-text-width|||>
  <image|FigLamination.eps|0.49tex-text-width|||><label|FigGapPreperiodicPolygon>|Left:
  a quadratic polynomial with three rays landing at the critical point, and
  thus six rays landing at the critical value. Right: a lamination modeling
  this Julia set. The critical point corresponds to a hexagon, the critical
  value to a triangle (both shaded). >

  All our arguments, especially those in the key
  Section<nbsp><reference|Sec:Narrow>, are combinatorial in nature and can
  thus be stated entirely in terms of Julia set laminations, or more
  combinatorially in terms of abstract laminations that satisfy certain
  natural invariance properties as discussed in
  <cite-detail|Th|Chapter<nbsp>II> (for the relation of laminations to Julia
  sets, see the appendix in <cite|Th>). We thus obtain an estimate about the
  Hausdorff dimension of the set endpoints of non-degenerate leaves in an
  invariant lamination. This setting relates to recent work of Thurston (as
  communicated in various talks and personal communication) as follows: if
  this dimension of endpoints is <math|\<eta\>>, then the union of the leaves
  has dimension <math|1+\<eta\>>. This dimension is related to the <em|core
  entropy> of a postcritically finite Julia set: such a Julia set has a
  Hubbard tree (defined as a minimal invariant tree connecting all
  postcritical points), and the core entropy is the entropy of the polynomial
  restricted to the Hubbard tree. If <math|H> denotes the core entropy, then
  <math|\<eta\>=H/log d>. Thurston's formula thus relates the topological
  concept of biaccessible points, and more precisely the geometric concept of
  the Hausdorff dimension of their angles, to the dynamic concept of entropy
  on the Hubbard tree.

  <\thebibliography|99>
    <bibitem|BCLOS>A. Blokh, C. Curry, G. Levin, L. Oversteegen, and D.
    Schleicher, <em|An extended Fatou-Shishikura inequality and wandering
    branch continua for polynomials>. Manuscript, submitted.

    <bibitem|BL>A. Blokh, G. Levin, <em|An inequality for laminations, Julia
    sets and \Pgrowing trees\Q>. Ergodic Theory Dynam. Systems
    <with|font-series|bold|22> 1 (2002), 63\U97.

    <bibitem|BKS>H. Bruin, A. Kaffl, D. Schleicher,
    <with|font-shape|italic|Symbolic dynamics of quadratic polynomials>.
    Monograph, in preparation.

    <bibitem|BS>H. Bruin, D. Schleicher, <with|font-shape|italic|Symbolic
    dynamics of quadratic polynomials>, Mittag Leffler Preprint
    <with|font-series|bold|7> (2001/02). To appear as <cite|BKS>.

    <bibitem|BSnew>H. Bruin, D. Schleicher, <em|Hausdorff dimension of
    biaccessible angles for quadratic polynomials>. Manuscript, in
    preparation.

    <bibitem|DH>A. Douady, J. H. Hubbard, <with|font-shape|italic|tude
    dynamique des polynmes complexes>, I, Publ. Math. Orsay, 1984.

    <bibitem|F>K. Falconer, <with|font-shape|italic|Fractal geometry,
    mathematical foundations and applications> 2nd edn., Wiley, 2003.

    <bibitem|Kiwi>J. Kiwi, <em|Wandering orbit portraits>. Trans. Amer. Math.
    Soc. <with|font-series|bold|354> 4 (2002), 1473\U1485.

    <bibitem|M>J. Milnor, <with|font-shape|italic|Dynamics in one complex
    variable>, 3rd edn., Princeton University Press, 2006.

    <bibitem|Po>C. Pommerenke, <with|font-shape|italic|Boundary behavior of
    conformal maps>, Springer, 1992.

    <bibitem|RR>R. Radu, <em|Hausdorff dimension and biaccessibility for
    polynomial Julia sets>. Bachelor's thesis, Jacobs University, 2007.

    <bibitem|SZ>D. Schleicher, S. Zakeri, <with|font-shape|italic|On
    biaccessible points in the Julia set of a Cremer quadratic polynomial>.
    Proc. AMS <with|font-series|bold|128> 3 (1999), 933\U937.

    <bibitem|Sm>S. Smirnov, <with|font-shape|italic|On supports of dynamical
    laminations and biaccessible points in polynomial Julia sets>, Colloq.
    Math. <with|font-series|bold|87> (2001) 2, 287\U295.

    <bibitem|Th>W. Thurston, <em|On the geometry and dynamics of iterated
    rational maps>. In: D. Schleicher (ed.), <em|Complex dynamics: families
    and friends>, AK Peters, Wellesley, MA, 2009, 1\U137.

    <bibitem|Za>S. Zakeri, <with|font-shape|italic|Biaccessibility in
    quadratic Julia sets>, Ergod. Th. & Dynam. Sys.,
    <with|font-series|bold|20> (2000), 1859\U1883.

    <bibitem|Za1>S. Zakeri, <with|font-shape|italic|External rays and the
    real slice of the Mandelbrot set>, Ergod. Th. & Dynam. Sys.,
    <with|font-series|bold|23> (2003), 637\U660.

    <bibitem|Zd>A. Zdunik, <with|font-shape|italic|On biaccessible points in
    Julia sets of polynomials>, Fund. Math., <with|font-series|bold|163>
    (2000), 277\U286.

    <bibitem|Zd1>A. Zdunik, <with|font-shape|italic|Parabolic orbifolds and
    the dimension of the maximal measure for rational maps>, Invent. Math.,
    <with|font-series|bold|99> (1990), 627\U649.
  </thebibliography>
</body>