<TeXmacs|1.99.7>

<style|<tuple|article|std-latex>>

<\body>
  <\hide-preamble>
    <assign|tablehere|<macro|body|<\surround|<assign|@|<macro|table>>|>
      <arg|body>
    </surround>>>

    <assign|figurehere|<macro|body|<\surround|<assign|@|<macro|figure>>|>
      <arg|body>
    </surround>>>
  </hide-preamble>

  }

  <thispagestyle|empty>

  <markboth|A. Vidybida|Testing of Information Condensation>

  <assign|page-nr|1><vspace|1.05truein>

  <\center>
    <with|font-size|1.19|font-series|bold|Testing of information condensation
    in a model<next-line><vspace*|0.04truein> reverberating spiking neural
    network<footnote|Accepted in the International Journal of Neural Systems,
    http://www.worldscinet.com/ijns/ijns.shtml>>
  </center>

  <vspace|0.04truein><vspace|0.45truein>

  <\center>
    A. K. Vidybida <vspace|0.0215truein>
  </center>

  <\center>
    <with|font-shape|italic|Department of Synergetics, Bogolyubov Institute
    for Theoretical Physics>\ 
  </center>

  <\center>
    <with|font-shape|italic|Metrologichna str., 14-B, 03680 Kyiv, Ukraine>\ 
  </center>

  <baselineskip>=11pt\ 

  <\center>
    <with|font-shape|italic|E-mail: vidybida@bitp.kiev.ua>
  </center>

  <vspace|0.29truein><abstract|Information about external world is delivered
  to the brain in the form of structured in time spike trains. During further
  processing in higher areas, information is subjected to a certain
  condensation process, which results in formation of abstract conceptual
  images of external world, apparently, represented as certain uniform
  spiking activity partially independent on the input spike trains details.
  Possible physical mechanism of condensation at the level of individual
  neuron was discussed recently. In a reverberating spiking neural network,
  due to this mechanism the dynamics should settle down to the same
  uniform/periodic activity in response to a set of various inputs. Since the
  same periodic activity may correspond to different input spike trains, we
  interpret this as possible candidate for information condensation mechanism
  in a network. Our purpose is to test this possibility in a network model
  consisting of five fully connected neurons, particularly, the influence of
  geometric size of the network, on its ability to condense information.
  Dynamics of 20 spiking neural networks of different geometric sizes are
  modelled by means of computer simulation. Each network was propelled into
  reverberating dynamics by applying various initial input spike trains. We
  run the dynamics until it becomes periodic. The Shannon's formula is used
  to calculate the amount of information in any input spike train and in any
  periodic state found. As a result, we obtain explicit estimate of the
  degree of information condensation in the networks, and conclude that it
  depends strongly on the net's geometric size.|><vspace|10pt>

  <with|par-columns|2|<section|Introduction>>

  <no-indent>The ability of a biological object to obtain enough information
  about external world is essential for the object's survival. The
  information is delivered to the central nervous system through various
  sensory pathways in the form of spike trains. The pathways' information
  throughput has been studyed for a long time in theoretical <cite|MacKay0>
  and experimental <cite|Passaglia> research. The paradigm of those research
  is consistent with the assumption that the best situation is when the brain
  receives maximum information from sensory systems. But compare this with
  <cite|Feldman>. Another paradigm, which is as well mature, <cite|MacKay>,
  concentrates on self-organization of spike trains when primary sensory
  activity spreads to higher brain areas. Self-organization is accompanied
  with information loss, <cite|self>, Indeed, a kind of standartization of
  activity evoked by various primary sensory inputs is obsereved
  experimentally in higher brain areas during olfactory <cite|Viret|Laurent>
  and auditory <cite|Cariani> perception. In visual system, simple examples
  are the transformation of scene representation to viewpoint-invariant,
  <cite|Durbin> or retinotopic-invariant <cite|Tang> coordinates. Here, spike
  trains in the optic nerve must depend on certain information (retinal
  position, viewpoint), which is removed in higher areas of conceptual
  representation. In the context of cognitive physiology, the process of
  reduction of information aimed at conceptual representation/recognition of
  external objects is known as information condensation, <cite|KonigKruger>.
  Usually pattern recognition phenomenon, which is closely related to
  information condensation, is considered in parallel with training, see
  <cite|Adeli|Johnston0|Nichols0|Schliebs0|Soltic0|Strain0|Widrow>, learning,
  <cite|Acharya0|Adeli0|Adeli2|KonigKruger>, or other plasticity,
  <cite|Villa>, in the corresponding network. In a biological network, the
  learning mechanism involves biosynthesis <cite|Scharf> and is therefore
  very slow process, which requires seconds or minutes, <cite|Merzenich>. At
  the same time, recognition of objects in visual scene can be accomplished
  within 150 ms, or faster, citeThorpe1,Thorpe. During this short period of
  time, the network has constant structure, but it is the spiking activity
  which evolves within it from information-rich at the sensory periphery into
  information-poor, representing concrete entities/concepts at higher brain
  areas.

  We now put a question: What could be the physical mechanism of information
  condensation in a spiking neural system? One possible mechanism, <cite|BNF>
  which operates at the level of single neuron, was discussed, see Fig.
  <reference|fig:paradigm>, <reference|BNexample> and n.
  2.1.1<reference|BNcond>, below. In a reverberating spiking network, due to
  this mechanism the spiking dynamics should settle down to the same definite
  periodic activity in response to any stimulus from a definite set of
  various inputs, and to another periodic activity in response to members of
  another set of inputs. If so, then the definite periodic dynamical state
  can be considered as an abstract representation of a feature, which all
  stimuli from the definite set have in common. And this is just what is
  expected from the condensation of information.

  Our purpose in this work is to study how the ability of a simple spiking
  neural net to condense information in the above described sense depends on
  its physical parameter \V the net's geometric size. For this purpose we
  simulate dynamics of a net composed of five binding neurons placed
  equidistantly on a circle. The circle's radius, <math|R>, characterizes the
  net's geometric size. The net is fully connected, and propagation velocity
  is taken the same for all connections and all values of <math|R>. Thus, the
  variations in <math|R> are expressed exclusively in the variations in the
  interneuronal propagation times. Initially, the net is stimulated by a
  spike train of input impulses triggering each of five neurons at times
  <math|<around|{|t<rsub|0>,t<rsub|1>,\<ldots\>,t<rsub|4>|}>>. Afterwards,
  the spiking dynamics is allowed to go freely until it settles down to a
  periodic one. This allows to figure out sets of input stimuli bringing
  about the same periodic dynamics. The number of different periodic dynamics
  and the number of input stimuli in a set, which corresponds to a definite
  periodic dynamics, characterize the net's ability to condense information.
  We found that this ability depends strongly on the net's size.

  <section|Methods>

  <\with|par-columns|1>
    <\big-figure>
      <image|paradigm.eps|0.65tex-text-width|||>

      <label|fig:paradigm>
    </big-figure|Signal processing in the binding neuron
    model.<protect><cite|Vid96a|Vid98>>
  </with>

  <subsection|The Binding Neuron Model>

  <no-indent>The understanding of mechanisms of higher brain functions
  expects a continuous reduction from higher activities to lower ones,
  eventually, to activities in individual neurons, expressed in terms of
  membrane potentials and ionic currents. While this approach is correct
  scientifically and desirable for applications, the complete range of the
  reduction is unavailable to a single researcher/engineer due to human brain
  limited capacity. In this connection, it would be helpful to abstract from
  the rules by which a neuron changes its membrane potentials to rules by
  which the input impulse signals are processed into its output impulses. The
  \Pcoincidence detector\Q, and \Ptemporal integrator\Q are the examples of
  such an abstraction, see discussion by Knig et al., <cite|Konig>. One more
  abstraction, the binding neuron (BN) model, is proposed as signal
  processing unit, <cite|Vid96> which can operate as either coincidence
  detector, or temporal integrator, depending on quantitative characteristics
  of stimulation applied. This conforms with behavior of real neurons, see,
  e.g. work by Rudolph & Destexhe, <cite|Rudolph>. The BN model describes
  functioning of a neuron in terms of discret events, which are input and
  output impulses, and degree of temporal coherence between the input events,
  see Fig. <reference|fig:paradigm>. Mathematically, this can be realized as
  follows. Each input impulse is stored in the BN for a fixed time,
  <math|\<tau\>>. The <math|\<tau\>> is similar to the \Ptolerance interval\Q
  discussed by MacKay, <cite|MacKay>. All input lines are excitatory and
  deliver identical impulses. The neuron fires an output impulse if the
  number of stored impulses, <math|\<Sigma\>>, is equal or higher than the
  threshold value, <math|N<rsub|0>>. In this model, inhibition is expressed
  in decreased <math|\<tau\>> value. It is clear, that BN is triggered when a
  bunch of input impulses is received in a narrow temporal interval. In this
  case, the bunch could be considered as compound event, and the output
  impulse \V as an abstract representation of this compound event. One could
  treat this mechanism as binding of individual input events into a single
  output event, provided the input events are coherent in time. Such
  interpretation is suggested by binding of features/events in largescale
  neuronal circuits, <cite|Damasio89|Eckhorn|Engel91a|Vid98>.

  It would be interesting to characterize the BN input-output relations in
  the form of transfer function, which allows exact calculation of output in
  terms of input. In our case, input is the sequence of discrete arriving
  moments of standard impulses: <math|T<rsub|i*n>=<around|{|l<rsub|1>,l<rsub|2>,l<rsub|3>,l<rsub|4>,\<ldots\>|}>>.
  The output is the sequence of discrete firing moments of BN:
  <math|T<rsub|o*u*t>=<around|{|f<rsub|1>,f<rsub|2>,\<ldots\>|}>>. It is
  clear that <math|T<rsub|o*u*t>\<subset\>T<rsub|i*n>>. The transfer function
  in our case could be the function <math|\<sigma\><around|(|l|)>>,
  <math|l\<in\>T<rsub|i*n>>, which equals 1 if <math|l> is the firing moment,
  <math|l\<in\>T<rsub|o*u*t>>, and 0 otherwise. For BN with threshold
  <math|N<rsub|0>> the required function can be constructed as follows. It is
  clear that the first <math|N<rsub|0>-1> input impulses are unable to
  trigger neuron, therefore <math|\<sigma\><around|(|l<rsub|1>|)>=0,\<ldots\>,\<sigma\><around|(|l<rsub|N<rsub|0>-1>|)>=0>.
  The next input is able to trigger if and only if all <math|N<rsub|0>>
  inputs are coherent in time:

  <\equation*>
    \<sigma\><around|(|l<rsub|N<rsub|0>>|)>=1*<with|font-family|rm|i*f*a*n*d*o*n*l*y*i*f>*l<rsub|N<rsub|0>>-l<rsub|1>\<le\>\<tau\>.
  </equation*>

  In order to determine <math|\<sigma\><around|(|l<rsub|N<rsub|0>+k>|)>>,
  <math|k\<ge\>1>, one must take into acount all previous input moments,
  therefore we use notation <math|\<sigma\><rsub|T<rsub|i*n>>> instead of
  <math|\<sigma\>>. The values of <math|\<sigma\><rsub|T<rsub|i*n>><around|(|l<rsub|N<rsub|0>+k>|)>>
  can be determined recursively:

  <gather|<tformat|<table|<row|<cell|\<sigma\><rsub|T<rsub|i*n>><around|(|l<rsub|N<rsub|0>+k>|)>=1*<with|font-family|rm|i*f*a*n*d*o*n*l*y*i*f><no-number>*l<rsub|N<rsub|0>+k>-l<rsub|k+1>\<le\>\<tau\><with|font-family|rm|a*n*d><no-number>>>|<row|<cell|<no-number>*\<sigma\><rsub|T<rsub|i*n>><around|(|l<rsub|i>|)>=0*<with|font-family|rm|f*o*r*a*l*l>*i\<in\><around|{|k+1,\<ldots\>,N<rsub|0>+k-1|}>.>>>>>

  The function <math|\<sigma\><rsub|T<rsub|i*n>>> describes completely the BN
  model for arbitrary threshold value <math|N<rsub|0>\<ge\>2> .

  <subsubsection|Information Condensation in a Single Neuron><label|BNcond>

  <no-indent>It is worth noticing, that any firing (triggering) moment of a
  spiking neuron is determined by the moment of last input impulse, which
  just ensures that the triggering condition is satisfied. In a neuron, which
  needs more than one input impulse to fire, variations of temporal position
  of impulses, received just before the triggering one, do not influence the
  moment of emitting the output impulse, provided those variations are in
  resonable limits and arrival moment of the triggering impulse remains the
  same.<vspace|0.5fn>

  <\figurehere>
    <\center>
      <image|SiCon.eps|0.4tex-text-width|||>
    </center>

    <caption|<label|BNexample>Example of two different inputs into a single
    neuron, which produce identical outputs.>
  </figurehere>

  <vspace|0.5fn>

  <no-indent>Thus, different input spike trains can produce exactly the same
  output. This looks like if some detailes of the input stimulus, which is
  composed of several impulses, were reduced/condensed in the output. In the
  BN, the triggering condition is that the number of impulses in the BN's
  internal memory equals to <math|N<rsub|0>>. Consider BN with
  <math|N<rsub|0>=4>, which is stimulated with two different spike trains
  with input impulses arrival times <math|S<rsub|1>=<around|{|t<rsub|11>,t<rsub|12>,t<rsub|13>,t<rsub|14>,t<rsub|15>|}>>,
  <math|t<rsub|11>\<less\>t<rsub|12>\<less\>t<rsub|13>\<less\>t<rsub|14>\<less\>t<rsub|15>>,
  and <math|S<rsub|2>=<around|{|t<rsub|21>,t<rsub|22>,t<rsub|23>,t<rsub|24>,t<rsub|25>|}>>,
  <math|t<rsub|21>\<less\>t<rsub|22>\<less\>t<rsub|23>\<less\>t<rsub|24>\<less\>t<rsub|25>>.
  Let the arrival moments satisfy the following conditions:

  <gather|<tformat|<table|<row|<cell|<label|exampleBN><no-number>*t<rsub|14>-t<rsub|11>\<less\>\<tau\>,<space|1em>t<rsub|25>-t<rsub|22>\<less\>\<tau\>,>>|<row|<cell|<no-number>*t<rsub|24>-t<rsub|21>\<gtr\>\<tau\>,<space|1em>t<rsub|14>=t<rsub|25>=t<rsub|o><space|0.17em>.>>>>>

  In this case, both <math|S<rsub|1>> and <math|S<rsub|2>>, if fed to the BN,
  will produce exactly the same output, namely, the single impulse at moment
  <math|t<rsub|o>>. This is illustrated in Fig. <reference|BNexample>.

  <subsection|The Network Model><label|Network>

  <no-indent>As a reverberating spiking neural net we take the net of five
  neurons placed equidistantly at a circle of radius <math|R>, see Fig,
  <reference|net>. Each neuron has threshold <math|N<rsub|0>=4>, and internal
  memory, <math|\<tau\>=10> ms. The net is fully connected. The connection
  lines are characterized with length and propagation velocity, <math|v>,
  which is the same in all lines. For <math|R> fixed, there are two types of
  connection line, the short one, with propagation delay <math|d>, and the
  long one with propagation delay <math|D>. Each neuron has additionally the
  external stimulus input line, which is used to start the net dynamics.
  Single impulse in the stimulus input line delivers to its target neuron
  just threshold excitation. This causes firing at the moment of the stimulus
  impulse arrival. For numerical simulations we use 20 networks of different
  sizes, see Table <reference|T1>. The propagation velocity in any
  interconnection line is taken <math|v=0.1> m/s.

  <\with|par-columns|1>
    <\big-figure>
      <image|5-neurons.eps|0.55tex-text-width|||>

      <label|net>
    </big-figure|The network, used for simulations. Here
    <math|<around|{|t<rsub|0>,t<rsub|1>,t<rsub|2>,t<rsub|3>,t<rsub|4>|}>>
    <emdash> is the input spike train, <math|d>, <math|D> <emdash> are the
    propagation delays in the connection lines. Any line can be either empty,
    or propagating one impulse.>
  </with>

  <subsubsection|Numerical Simulation>

  <no-indent>As programming language we use Python under Linux operating
  system. The dynamics was modelled by advancing time with step
  <math|d*t=200> <math|\<mu\>>s. The delay values <math|d> and <math|D>, when
  measured in the <math|d*t> units, were rounded to the nearest from below
  integers, see Table <reference|T1>. As a result, the simulating program
  operates in whole numbers with no rounding errors involved.

  <\with|par-columns|1>
    <\big-table>
      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|7|7|cell-halign|c>|<cwith|1|-1|8|8|cell-halign|c>|<cwith|1|-1|9|9|cell-halign|c>|<cwith|1|-1|10|10|cell-halign|c>|<cwith|1|-1|11|11|cell-halign|c>|<cwith|1|-1|12|12|cell-halign|c>|<cwith|1|-1|13|13|cell-halign|c>|<cwith|1|-1|14|14|cell-halign|c>|<cwith|1|-1|15|15|cell-halign|c>|<cwith|1|-1|16|16|cell-halign|c>|<cwith|1|-1|17|17|cell-halign|c>|<cwith|1|-1|18|18|cell-halign|c>|<cwith|1|-1|19|19|cell-halign|c>|<cwith|1|-1|20|20|cell-halign|c>|<cwith|1|-1|21|21|cell-halign|c>|<cwith|1|-1|21|21|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|3|3|1|-1|cell-bborder|1ln>|<cwith|4|4|1|-1|cell-bborder|1ln>|<cwith|5|5|1|-1|cell-bborder|1ln>|<table|<row|<cell|net
      #>|<cell|1>|<cell|2>|<cell|3>|<cell|4>|<cell|5>|<cell|6>|<cell|7>|<cell|8>|<cell|9>|<cell|10>>|<row|<cell|<math|R>,
      mm>|<cell|0.029>|<cell|0.057>|<cell|0.086>|<cell|0.114>|<cell|0.143>|<cell|0.171>|<cell|0.200>|<cell|0.229>|<cell|0.257>|<cell|0.286>>|<row|<cell|<math|d>,
      <math|d*t>>|<cell|1>|<cell|3>|<cell|5>|<cell|6>|<cell|8>|<cell|10>|<cell|11>|<cell|13>|<cell|15>|<cell|16>>|<row|<cell|<math|D>,
      <math|d*t>>|<cell|2>|<cell|5>|<cell|8>|<cell|10>|<cell|13>|<cell|16>|<cell|19>|<cell|21>|<cell|24>|<cell|27>>|<row|<cell|<math|M>,
      <math|d*t>>|<cell|5>|<cell|10>|<cell|15>|<cell|20>|<cell|25>|<cell|30>|<cell|35>|<cell|40>|<cell|45>|<cell|50>>>>>

      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|1ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|7|7|cell-halign|c>|<cwith|1|-1|8|8|cell-halign|c>|<cwith|1|-1|9|9|cell-halign|c>|<cwith|1|-1|10|10|cell-halign|c>|<cwith|1|-1|11|11|cell-halign|c>|<cwith|1|-1|12|12|cell-halign|c>|<cwith|1|-1|13|13|cell-halign|c>|<cwith|1|-1|14|14|cell-halign|c>|<cwith|1|-1|15|15|cell-halign|c>|<cwith|1|-1|16|16|cell-halign|c>|<cwith|1|-1|17|17|cell-halign|c>|<cwith|1|-1|18|18|cell-halign|c>|<cwith|1|-1|19|19|cell-halign|c>|<cwith|1|-1|20|20|cell-halign|c>|<cwith|1|-1|21|21|cell-halign|c>|<cwith|1|-1|21|21|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|-1|cell-bborder|1ln>|<cwith|3|3|1|-1|cell-bborder|1ln>|<cwith|4|4|1|-1|cell-bborder|1ln>|<table|<row|<cell|net
      #>|<cell|11>|<cell|12>|<cell|13>|<cell|14>|<cell|15>|<cell|16>|<cell|17>|<cell|18>|<cell|19>|<cell|20>>|<row|<cell|<math|R>,
      mm>|<cell|0.314>|<cell|0.343>|<cell|0.371>|<cell|0.400>|<cell|0.429>|<cell|0.457>|<cell|0.486>|<cell|0.514>|<cell|0.543>|<cell|0.571>>|<row|<cell|<math|d>,
      <math|d*t>>|<cell|18>|<cell|20>|<cell|21>|<cell|23>|<cell|25>|<cell|26>|<cell|28>|<cell|30>|<cell|31>|<cell|33>>|<row|<cell|<math|D>,
      <math|d*t>>|<cell|29>|<cell|32>|<cell|35>|<cell|38>|<cell|40>|<cell|43>|<cell|46>|<cell|48>|<cell|51>|<cell|54>>|<row|<cell|<math|M>,
      <math|d*t>>|<cell|55>|<cell|60>|<cell|65>|<cell|70>|<cell|75>|<cell|80>|<cell|85>|<cell|90>|<cell|95>|<cell|100>>>>>

      \;
    </big-table|<label|T1>Dimensions of networks used for simulations;
    <math|d*t=200> <math|\<mu\>>s.>
  </with>

  <\with|par-columns|1>
    <\big-table>
      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|7|7|cell-halign|c>|<cwith|1|-1|8|8|cell-halign|c>|<cwith|1|-1|9|9|cell-halign|c>|<cwith|1|-1|10|10|cell-halign|c>|<cwith|1|-1|11|11|cell-halign|c>|<cwith|1|-1|12|12|cell-halign|c>|<cwith|1|-1|13|13|cell-halign|c>|<cwith|1|-1|14|14|cell-halign|c>|<cwith|1|-1|15|15|cell-halign|c>|<cwith|1|-1|16|16|cell-halign|c>|<cwith|1|-1|17|17|cell-halign|c>|<cwith|1|-1|18|18|cell-halign|c>|<cwith|1|-1|19|19|cell-halign|c>|<cwith|1|-1|20|20|cell-halign|c>|<cwith|1|-1|21|21|cell-halign|c>|<cwith|1|-1|21|21|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|5|5|1|-1|cell-bborder|1ln>|<table|<row|<cell|net
      #>|<cell|1>|<cell|2>|<cell|3>|<cell|4>|<cell|5>|<cell|6>|<cell|7>|<cell|8>|<cell|9>|<cell|10>>|<row|<cell|>|<cell|3<rsup|<math|1>>>|<cell|6<rsup|<math|1>>>|<cell|9<rsup|<math|1>>>|<cell|11<rsup|<math|1>>>|<cell|14<rsup|<math|1>>>|<cell|17<rsup|<math|1>>>|<cell|20<rsup|<math|1>>>|<cell|22<rsup|<math|1>>>|<cell|25<rsup|<math|1>>>|<cell|28<rsup|<math|1>>>>|<row|<cell|>|<cell|>|<cell|10<rsup|<math|4>>>|<cell|15<rsup|<math|4>>>|<cell|18<rsup|<math|4>>>|<cell|23<rsup|<math|4>>>|<cell|28<rsup|<math|4>>>|<cell|32<rsup|<math|4>>>|<cell|36<rsup|<math|4>>>|<cell|41<rsup|<math|4>>>|<cell|45<rsup|<math|4>>>>|<row|<cell|>|<cell|>|<cell|12<rsup|<math|3>>>|<cell|18<rsup|<math|7>>>|<cell|22<rsup|<math|7>>>|<cell|28<rsup|<math|7>>>|<cell|34<rsup|<math|7>>>|<cell|40<rsup|<math|7>>>|<cell|44<rsup|<math|7>>>|<cell|50<rsup|<math|7>>>|<cell|56<rsup|<math|7>>>>|<row|<cell|>|<cell|>|<cell|>|<cell|24<rsup|<math|6>>>|<cell|29<rsup|<math|6>>>|<cell|37<rsup|<math|6>>>|<cell|45<rsup|<math|6>>>|<cell|52<rsup|<math|6>>>|<cell|>|<cell|>|<cell|>>>>>

      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|6|6|cell-halign|c>|<cwith|1|-1|7|7|cell-halign|c>|<cwith|1|-1|8|8|cell-halign|c>|<cwith|1|-1|9|9|cell-halign|c>|<cwith|1|-1|10|10|cell-halign|c>|<cwith|1|-1|11|11|cell-halign|c>|<cwith|1|-1|12|12|cell-halign|c>|<cwith|1|-1|13|13|cell-halign|c>|<cwith|1|-1|14|14|cell-halign|c>|<cwith|1|-1|15|15|cell-halign|c>|<cwith|1|-1|16|16|cell-halign|c>|<cwith|1|-1|17|17|cell-halign|c>|<cwith|1|-1|18|18|cell-halign|c>|<cwith|1|-1|19|19|cell-halign|c>|<cwith|1|-1|20|20|cell-halign|c>|<cwith|1|-1|21|21|cell-halign|c>|<cwith|1|-1|21|21|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<table|<row|<cell|net
      #>|<cell|11>|<cell|12>|<cell|13>|<cell|14>|<cell|15>|<cell|16>|<cell|17>|<cell|18>|<cell|19>|<cell|20>>|<row|<cell|>|<cell|30<rsup|<math|1>>>|<cell|33<rsup|<math|1>>>|<cell|36<rsup|<math|1>>>|<cell|39<rsup|<math|1>>>|<cell|41<rsup|<math|1>>>|<cell|44<rsup|<math|1>>>|<cell|47<rsup|<math|1>>>|<cell|49<rsup|<math|1>>>|<cell|52<rsup|<math|1>>>|<cell|55<rsup|<math|1>>>>|<row|<cell|>|<cell|49<rsup|<math|4>>>|<cell|54<rsup|<math|4>>>|<cell|58<rsup|<math|4>>>|<cell|63<rsup|<math|4>>>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>>>>

      \;
    </big-table|<label|T2>Distinct periods in <math|d*t> units of found
    periodic states in the short stimuli paradigm. Superscript denotes the
    number of different periodic states with this period.>
  </with>

  Each single tick of the program, the network's tick, advances time by
  <math|d*t>, and consists of three partial ticks, which are performed in the
  given order. Namely, (i) input tick, which advances time in the input
  lines, (ii) axonal tick, which advances time in the internal connection
  lines, (iii) neuronal tick, which advances time in the neurons.

  This manner of updating states can be treated as synchronous in a sense
  that each component of the network has the same physical time when the
  network's tick is complete. On the other hand, viewed as interneuronal
  communication process, the dynamics should be treated as asynchronous due
  to nonzero propagation delays.

  During the step (ii), a neuron can get impulse into its internal memory. If
  a neuron appears in the state \PFire\Q as a result of the network tick,
  then the output impulse it produces can appear in the connection lines only
  during the next network tick. This introduces effective delay of one
  <math|d*t> between delivering the triggering impulse to a neuron and
  emitting output impulse by that neuron.

  <subsection|Data Acquisition Algorithm>

  <subsubsection|Set of Stimuli>

  <no-indent>The net was entrained to reverberating dynamics by applying
  initial input spike train of five impulses, one triggering impulse per
  neuron, at times (in <math|d*t> units) <math|<around|{|t<rsub|0>=1,t<rsub|1>,t<rsub|2>,t<rsub|3>,t<rsub|4>|}>>.
  The triggering moment of neuron # 0 is taken 1 for all stimuli in order to
  exclude rotational symmetry between the stimuli applied. Other four
  triggering moments run independently through the set
  <math|<around|{|1,2,\<ldots\>,t<rsub|m*a*x>|}>>, where <math|t<rsub|m*a*x>>
  is choosen proportional to <math|R> for each net size. In choosing
  <math|t<rsub|m*a*x>>, we follow two different paradigms. In the first
  paradigm of short stimuli we restrict the overall duration of the stimulus
  train with the value <math|t<rsub|m*a*x>=d>. Thus, the set of stimuli has
  <math|d<rsup|4>> different stimuli. If <math|t<rsub|i>\<le\>d>,
  <math|i=0,\<ldots\>,4>, then any neuron in the net never obtains impulse
  from other neurons before it obtains its external input stimulation. In the
  second paradigm of extended stimuli, we restrict the overall duration of
  the stimulus train with the value <math|t<rsub|m*a*x>=M>, which is about
  three times longer than <math|d> for each network (see Table
  <reference|T1>). Here, all stimuli <math|<around|{|t<rsub|0>=1,t<rsub|1>,t<rsub|2>,t<rsub|3>,t<rsub|4>|}>>,
  which were presented to a network, cover the set of <math|M<rsup|4>>
  different trains, which equals from 625 different stimuli for net #1 to
  100<space|0.17em>000<space|0.17em>000 different stimuli for net #20 (see
  Table <reference|T1>). The stimuli were sampled in accordance with standard
  algorithm of 4-digit counter. Namely, we started from stimulus
  <math|<around|{|1,1,1,1,1|}>>, the next stimulus is obtained by advancing
  <math|t<rsub|1>> by 1, and so on. The stimulus next to
  <math|<around|{|1,M,1,1,1|}>> is <math|<around|{|1,1,2,1,1|}>>, the one
  next to <math|<around|{|1,M,M,1,1|}>> is <math|<around|{|1,1,1,2,1|}>> and
  so on, until stimulus <math|<around|{|1,M,M,M,M|}>> is presented.

  In the extended paradigm, the late external input impulse can enter
  corresponding neuron after it received impulses from neurons already
  triggered by early external input impulses.

  The second paradigme is in concordance with visual information processing,
  <cite|Bullier> where activity from higher brain areas, which was invoked
  due to visual stimulation at earlier time, is retroinjected to areas V1 and
  V2 in the primary visual cortex, where it interacts with activity invoked
  by visual input at later time during perception.

  <subsubsection|Figuring out Periodic States>

  <no-indent>After the last input impulse from the train
  <math|<around|{|t<rsub|0>=1,t<rsub|1>,t<rsub|2>,t<rsub|3>,t<rsub|4>|}>>
  reachs its target neuron, the program begins appending at each time step
  the instantaneous state of the net to a Python list. The instantaneous
  state consists of states of all 20 connection lines and all 5 neurons (see
  Fig. <reference|STATES>). Before appending, the program checks if the
  current instantaneous state was already included in the list. If it was,
  then the periodic dynamical state is found with its complete cyclic
  trajectory covered by instantaneous states between the inclusion and the
  last record in the list, inclusively. Measures are taken in order not to
  count the same cyclic trajectory, which was entrained at its different
  points, as different periodic states.

  <\with|par-columns|1>
    <\big-figure>
      <\verbatim>
        \;

        mysql\<gtr\> \ select * from STATES_5_9 where num=269;

        +------+------------------------------------------------------------------------------

        ----------------------------------------------+--------+

        \| num \ \| state

        \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \|
        period \|

        +------+------------------------------------------------------------------------------

        ----------------------------------------------+--------+

        \| \ 269 \| 0 1 1 0 8 8 17 17 24 15 15 24 8 8 0 0 8 17 17 8

        0 False False

        0 False False

        0 False False

        0 False False

        0 False True 49 1

        \ \| \ \ \ \ 82 \|

        +------+------------------------------------------------------------------------------

        ----------------------------------------------+--------+

        1 row in set (0.02 sec)

        \;

        mysql\<gtr\>

        \;
      </verbatim>
    </big-figure|<label|STATES>Example of single record in the MySQL table
    STATES. The first field (num) is numerical, and gives the serial number
    of periodic state found. The second field (state) is a string, which
    describes instantaneous state from the periodic state found (a point from
    the cyclic trajectory, which represents the whole trajectory, or periodic
    state). The first 20 numbers in the string describe states of all
    connection lines: '0' means that the line is empty, positive number
    specifies after how many ticks the propagating impulse will rich the
    targeted neuron. The next five chunks confined between the "next line"
    symbols describe states of neurons. The first number in each chunk is the
    "kick" <emdash> the total number of impulses obtained by neuron after the
    axonal tick was complete. During the neuronal tick, corresponding to that
    axonal tick, the "kick" is utilized and set to zero. The next boolean in
    the chunk indicates if the neuron is in the "Fire" state. The next
    boolean indicates if the neuron has any impulses in its internal memory.
    If it has, then next couples of numbers (up to three couples) describe
    those impulses. In this example, neuron #4 has 1 impulse with time to
    leave 49<math|\<cdot\>d*t>. The third field (period) specifies period (in
    <math|d*t> units) of this periodic state.>
  </with>

  <vspace|1fn>

  <\with|par-columns|1>
    <\big-figure>
      <image|net1.eps|0.45tex-text-width|||>
      <htab|0pt><image|net2.eps|0.45tex-text-width|||>

      \;
    </big-figure|<label|NS>Number of different periodic states found for each
    net with short (left panel), and extended (right panel) stimuli.>
  </with>

  <vspace|1fn>

  The data for each net were stored in two MySQL tables. Table STATES
  included the serial number of any periodic state found, one element from
  the corresponding cyclic trajectory, and period of the state (see Fig.
  <reference|STATES>). Single record in the INPUTS table included the input
  stimulus <math|<around|{|t<rsub|0>=1,t<rsub|1>,t<rsub|2>,t<rsub|3>,t<rsub|4>|}>>,
  the serial number of the periodic state it leads to (this number is 0 for
  fading dynamics), and relaxation time, namely, the time, which is spent
  between the last external input impulse is delivered and the net's entrance
  moment into the periodic regime.

  <section|Results>

  <subsection|Characterization of Periodic States Found>

  <no-indent>After initial stimulation, networks from #1 to #7 entrain to
  periodic activity after any stimulation, and networks #8 to #20 either
  entrain to periodic dynamics, or stops from any activity after some time.
  This takes place for both short and extended stimuli.The number of
  different periodic states found for each network is shown in Fig.
  <reference|NS>. Here, the maximal number of periodic states obtained with
  short stimuli is 18, and this number is achieved for net numbers from 3 to
  7. Exact values of periods, and number of different periodic states with
  this period is shown in Table <reference|T2> for short stimuli. We omit
  similar table for extended stimuli. The maximal number of different
  periodic states obtained with extended stimuli is 485, which is achieved in
  the net number 9. The maximal number of different periodic states with the
  same period is 294 for period 50<math|\<cdot\>d*t> in net #9. It should be
  mentioned that two periodic states, which can be turned into eachother by
  suitable renumeration of neurons, were considered as different.

  It is evident that in the network of five neurons with threshold 4, each
  neuron is triggered the same number of times during period. Indeed, expect
  that neuron <math|n<rsub|4>> fires <math|k<rsub|4>> times, and any of the
  other four fires less during period: <math|k<rsub|4>\<gtr\>k<rsub|i>,<nbsp>i=0,1,2,3>.
  In order to be triggered <math|k<rsub|4>> times, <math|n<rsub|4>> must
  obtain not less than <math|4*k<rsub|4>> input impulses during period. But
  it can obtain only <math|k<rsub|0>+k<rsub|1>+k<rsub|2>+k<rsub|3>>, which is
  less than required. Similarly, situation when <math|k<rsub|4>=k<rsub|3>>
  and <math|k<rsub|3>\<gtr\>k<rsub|i>,<nbsp>i=0,1,2> leads to contradiction,
  and so on.

  This number of triggering is either 1 or 2 for trajectories found, see
  examples in Fig. <reference|NETexamples>. Some nets have only one periodic
  state, which coresponds to synchronous firing of all 5 neurons and
  symmetrical states of connection lines at any moment of time. This is the
  case for nets number 1 and from 15 to 20 for short stimuli, and for nets
  number 19 and 20 for extended stimuli.

  <subsection|Condensation of Information><label|Coi>

  <no-indent>In order to estimate the degree of information condensation in
  the course of transformation of an external spike train into a certain
  periodic state of the net, one needs to calculate information amount, which
  is delivered by specifying a spike train, and which is delivered by
  specifying the state, it leads to.<vspace|0.5fn>

  <\figurehere>
    <\center>
      <image|trains66.eps|0.4tex-text-width|||>
    </center>

    <caption|<label|NETexamples>Examples of periodic states found for net
    number 9 in the extended stimuli paradigm. Spikes indicate the firing
    moments, labels near each spike give numbers of neurons, firing at this
    moment. The two upper trains show states with period 10 ms, the lower one
    - with period 13.2 ms.>
  </figurehere>

  <vspace|0.5fn>

  <no-indent>This can be done by wellknown Shannon's formula <cite|Shannon>

  <\equation>
    <label|Sh>H=-<big|sum><rsub|i>p<rsub|i>*log<rsub|2> p<rsub|i>,
  </equation>

  where <math|p<rsub|i>> is the probability to obtain case number <math|i>
  from a set of cases. At the input end we have the set of <math|d<rsup|4>>,
  or <math|M<rsup|4>> different external input spike trains. In our statement
  of the problem, it is natural to consider all external input trains as
  equally probable. If so, then information delivered by specifying certain
  train is

  <\equation>
    <label|Hs>H<rsub|s>=4*log<rsub|2> d,
  </equation>

  for the short stimuli paradigm, and

  <\equation>
    <label|He>H<rsub|e>=4*log<rsub|2> M,
  </equation>

  for the extended stimuli paradigm.

  While estimating information, delivered by specifying certain periodic
  state, one should take into account that probabilities of different
  periodic states are not the same. In order to calculate probability
  <math|p<rsub|n>> of a periodic state <math|C<rsub|n>>, we calculate the
  number of input spike trains leading to the <math|C<rsub|n>>, namely,
  <math|T<rsub|n>>, and divide this number by the total amount of different
  input stimuli (see histogram for <math|T<rsub|n>> in Fig.
  <reference|Histo>)

  <\equation>
    <label|Ps>p<rsub|n>=<frac|T<rsub|n>|d<rsup|4>>,
  </equation>

  for the short stimuli paradigm, and

  <\equation>
    <label|Pe>p<rsub|n>=<frac|T<rsub|n>|M<rsup|4>>,
  </equation>

  for the extended stimuli paradigm. Then we use Eq. (<reference|Sh>) with
  probabilities of individual periodic states found in accordance with
  (<reference|Ps>), (<reference|Pe>) to calculate information which should be
  ascribed to any periodic state. In this calculations, we treat uniformly
  with others the external input stimuli, which lead to fading dynamics.
  Correspondingly, the state with no activity is treated uniformly with
  periodic states. This is in the contrast with data presented in Fig.
  <reference|NS>, and Table <reference|T2>, where the state with no activity
  is excluded.<vspace|0.5fn>

  <\figurehere>
    <\center>
      <image|histog2.eps|0.45tex-text-width|||>
    </center>

    <caption|<label|Histo>Histogram of conceptual domain sizes for net #9 in
    extended stimuli paradigm. The bin size is 518. 23 domains with sizes
    from 50764 to 193732 are not presented.>
  </figurehere>

  <vspace|0.5fn>

  As it could be expected, the information amount in an external input spike
  train increases as logarithm of the net size, in accordance with Eqs.
  (<reference|Hs>), (<reference|He>), varying from 25 to 81 bits for short
  paradigm, and from 37 to 106 bits for extended paradigm. Information, which
  could be ascribed to a periodic state, depends on the net size in a more
  complicated manner, see Fig. <reference|info>. A remarkable feature is a
  kind of plateau between net #3 and #9 for both short, and extended
  stimulation paradigme. In the plateau, the<vspace|0.5fn>

  <\figurehere>
    <\center>
      <image|info.eps|0.45tex-text-width|||>
    </center>

    <caption|<label|info>Dependence of information amount, which is ascribed
    to periodic state, on the net size. Curve 'e' corresponds to extended
    stimuli paradigm, 's' <emdash> to the short stimuli one.>
  </figurehere>

  <vspace|0.5fn>

  <no-indent>information of a periodic state, calculated in accordance with
  Eq. (<reference|Sh>) with probabilities found due to Eqs. (<reference|Ps>),
  (<reference|Pe>), varies between 6.93 and 7.33 bits for extended stimuli,
  and between 3.17 and 3.46 for short stimuli. In the plateau, the degree of
  information condensation calculated as input information divided by the
  periodic state information, varies between 9.02 and 12.27 for extended
  stimuli, and between 11.2 and 19.31 for short stimuli. Out of a plateau
  range, for greater net sizes the amount of information in a periodic state
  drops sharply due to simplification of the set of periodic states. Namely,
  the total number of periodic states decreases to one, with the second one
  with no activity, and the probability is distributed very unevenly between
  this two states. This leads to the degree of information condensation as
  high as 41000 for extended stimuli, and 690 for short ones.

  <section|Discussion>

  <no-indent>Any reverberating spiking neural net can represent complicated
  dynamical behavior. If the net's instantaneous states can be described with
  whole numbers, then the net will inevitably either entrain to periodic
  dynamics, or stop its activity at all. In this study, it is appeared that a
  very simple net of Fig. <reference|net> can be engaged into a considerably
  large set of different periodic activities. It is not clear which part of
  all possible in this net periodic states was discovered in our simulation.
  As it follows from comparison between short and extended stimuli paradigm,
  the number of different periodic states found increases with increasing
  range of input stimuli. Certainly, this increase must saturate somewhere.
  This is because any two different periodic regimes are represented by their
  cyclic trajectories, which has no common points (instantaneous states). On
  the other hand, the total number of instantaneous states the network can
  have is finite due to finiteness of the set of states of each element the
  network is composed of.

  The number of periodic states found in a net depends on the net's geometric
  size. Variations in the net's size display themselves exclusively in
  variations of interneuronal propagation delays <math|d> and <math|D>. On
  the other hand, the duration of neuronal internal memory, <math|\<tau\>>,
  is the same for net of any size. Thus, it is namely the relationships
  between the times an impulse spends for travelling between neurons, and
  time it is allowed to spend in a neuron waiting for additional impulses,
  which controls possible number of periodic states.

  It is worth noticing that each net has one completely synchronized periodic
  state. The completely synchronozed state is stable and achieved during
  finite time. This is in the contrast to the case of pulse-coupled
  oscillators with delayed excitatory coupling, (see, e.g. Ref. <cite|Wu>).

  In the four-dimensional set of stimuli we used, the neighbouring stimuli
  differ from eachother by one <math|d*t> in one of four dimensions. This can
  be treated as analogous representation of some reality. The set of periodic
  states should be considered as a set of discrete entities due to
  qualitative difference between any two states. This conforms with a
  paradigm discussed in cognitive physiology, <cite|KonigKruger>. The process
  of transformation of initial analogous inputs into a discret set of
  periodic states implies a loss of information and can be treated as
  condensation of information.

  If we take a set of input stimuli, any of which leads to the same periodic
  state, then that periodic state can be considered as an abstract/conceptual
  representation of a feature, which all stimuli from the set have in common,
  and the corresponding set could be named as \Pconceptual domain\Q. What
  kind of feature or concept does the conceptual domain represent? If our net
  was trained to recognize a certain real feature, then it would be that
  feature. In the context of this study, the common feature is that all
  stimuli from the conceptual domain engage namely this net into namely this
  periodic dynamics. <vspace|0.5fn>

  <\figurehere>
    <\center>
      <image|domains0.ps|0.2tex-text-width|||><htab|0pt><image|domains1.ps|0.2tex-text-width|||><htab|0pt>
    </center>

    <caption|<label|domains>2-dimensional cross-section of the 4-dimensional
    space of inputs for network #9 in extended stimuli paradigm.
    <with|font-shape|italic|left,> cross-section is made with plane
    <math|<around|(|t<rsub|3>=23,t<rsub|4>=23|)>>,
    <with|font-shape|italic|right,> <math|<around|(|t<rsub|3>=21,t<rsub|4>=23|)>>.
    Origin for <math|<around|(|t<rsub|1>,t<rsub|2>|)>> is in the upper left
    corner. Both <math|t<rsub|1>> and <math|t<rsub|2>> run through the set
    <math|<around|{|1,2,\<ldots\>,45|}>> of values. Numbers in polygons
    indicate serial numbers of corresponding periodic states.>
  </figurehere>

  <vspace|0.5fn>

  It would be interesting to have a look on the topology of the conceptual
  domains in the 4-dimensional space of all stimuli. For this purpose we
  figured out 2-dimensional cross-section of the input stimuli (see Fig.
  <reference|domains>). In the cross-section, a typical conceptual domain is
  composed of several coherent clusters disconnected with eachother. The
  histogram of sizes of conceptual domains found is given in Fig.
  <reference|Histo>.

  Decomposition of the whole set of input stimuli into a number of conceptual
  domains represented by corresponding periodic dynamics resembles approach
  in analyses of multivariate datasets, see review in <cite|Gorban>. The
  difference is that here the 4-dimensional dataset (a conceptual domain) is
  represented by unidimensional cyclic trajectory, which corresponds to the
  domain, and the trajectory is composed of points/vectors, which have other
  dimension than the dataset vectors (see Fig. <reference|STATES>).
  Nevertheless, having the network, the whole cyclic trajectory can be
  reproduced starting from its any single point. Thus, here the datasets are
  reduced down to individual points. This is in concordance with the
  information condensation idea.

  Why do we stick ourselves with namely the periodic dynamics? The answer is
  related to the memory/learning problem, even if we do not consider any
  plasticity in this study. It is known <cite|Merzenich> that modification of
  synaptic strength may happen due to repetitive delivery of impulses to
  those synapses. Periodic dynamical states are just well suited for such
  repetitive delivery. All other dynamical behaviors are of transient type,
  and have less chances to cause plastic changes in biological network. On
  the other hand, successful perception expects ability to report about what
  was perceived, which is impossible without memory.

  Unfortunately, we cannot draw this biological analogy too far. Real
  biological network includes not only excitatory, but about 4% of inhibitory
  neurons, <cite|Schwartz>. Representing this characteristic in a model
  network requires to have at least 25 neurons in it. This dramatically
  increases the number of possible external stimuli, which requires a
  qualitative change in our approach as regards the speed of simulations and
  analysis of obtained data.

  Finally, what happens if we use another neuronal model in the network? Our
  opinion is that results will be qualitatively similar. Using the binding
  neuron here is natural, since it represents in refined form what a spiking
  neuron does with signals it receives. Additionally, the BN model easily
  allows to develop a program operating in whole numbers. This excludes
  possible dynamical artefacts due to rounding errors.

  In future work, it would be interesting to compare results, if another
  spiking neuron model is used in the network, to study the topology of
  conceptual domains and how the topology could change if a plasticity is
  introduced in the network model.

  <section|Conclusions>

  <no-indent>A network composed of spiking neurons is able to condense
  information due to the fact that different initial stimuli could lead the
  network to the same periodic dynamics. This happens by means of
  initial/basic condensation of information in spiking neurons, as it is
  described in n. 2.1.1<reference|BNcond>, above. The network's geometric
  size, which determines the interneuronal transmission delays, has
  considerable influence on the net's ability to condense information, mainly
  due to influence on the number of different periodic states the network can
  have, see Fig. <reference|NS>. The latter has influence on the amount of
  information, which should be ascribed to a single periodic state, see Fig.
  <reference|info>. As a result, the degree of information condensation
  varies between 9 and 41<space|0.17em>000, see n. 3.2<reference|Coi> for
  details.

  The networks considered here are too primitive to have reliable biological
  implications. At the same time, numerical parameters, see Table
  <reference|T1> and n. 2.2<reference|Network>, such as network sizes and
  spike propagation velocity, are taken corresponding to biological data. The
  threshold value 4 does not contradict to biological reality, as
  experimentally registered thresholds are between 1 and 300. The BN internal
  memory duration, <math|\<tau\>>, is commensurable with halfdecay time of
  the excitatory postsynaptic potentials (EPSP). Thus, in the framework of
  this extremely simple model, one could expect that the ability of
  biological neural network to condense information should depend on its
  geometric size, or on the relationships between interneuronal transmission
  delays and the EPSP halfdecay time. <vspace|2fn>

  <with|font-size|0.84|font-series|bold|Acknowledgments><no-indent><with|font-size|0.84|This
  work was supported by the Program of basic research of the National Academy
  of Science of Ukraine.>

  <with|font-size|0.84|Content of this work was partially published in an
  abstract form in the abstract book of the 2nd International Biophysics
  Congress and Biotechnology at GAP & 21th National Biophysics Congress, (5-9
  Oct. 2009) Diyarbak\Yr, Turkey, <slink|http://www.ibc2009.org/>
  ><vspace|1fn>

  <\thebibliography|000>
    <bibitem|Acharya0>Acharya, R., Chua, E.C.P., Chua, K.C., Min, L.C., and
    Tamura, T. (2010), \PAnalysis and Automatic Identification of Sleep
    Stages using Higher Order Spectra,\Q International Journal of Neural
    Systems, 20:6.

    <bibitem|Bullier>J. Bullier, \PIntegrated model of visual processing,\Q
    <with|font-shape|italic|Brain Res. Rev.,> <with|font-series|bold|36>,
    96\U\<hyphen\>107 (2001).

    <bibitem|Merzenich>D. V. Buonomano and M. M. Merzenich, \PCortical
    plasticity: from synapses to maps,\Q <with|font-shape|italic|Annu. Rev.
    Neurosci.,> <with|font-series|bold|21>, 149\U186 (1998).

    <bibitem|Cariani>P. Cariani, \PTemporal codes, timing nets, and music
    perception,\Q <with|font-shape|italic|J. New Music Res.,>
    <with|font-series|bold|30>, 107\U\<hyphen\>135 (2001).

    <bibitem|Damasio89>A. R. Damasio, \PThe brain binds entities and events
    by multiregional activation from convergence zones,\Q
    <with|font-shape|italic|Neural Comput.,> <with|font-series|bold|1>,
    123\U132 (1989).

    <bibitem|Viret>P. Duchamp-Viret and A. Duchamp, \POdor processing in the
    frog olfactory system,\Q <with|font-shape|italic|Prog. Neurobiol.,>
    <with|font-series|bold|53>, 561\U602 (1997).

    <bibitem|Durbin>R. Durbin and G. Mitchison, \PA dimension reduction
    framework for understanding cortical maps,\Q
    <with|font-shape|italic|Nature,> <with|font-series|bold|343>,
    644\U\<hyphen\>647 (1990).

    <bibitem|Eckhorn>R. Eckhorn, R. Bauer, W. Jordan, M. Brosch, W. Kruse, M.
    Munk and H. J. Reitboeck, \PCoherent oscillations: a mechanism for
    feature linking in the visual cortex?,\Q <with|font-shape|italic|Biol.
    Cybern.,> <with|font-series|bold|60>, 121\U130 (1988).

    <bibitem|Engel91a>A. K. Engel, P. Knig, A. K. Kreiter, C. M. Gray and W.
    Singer, \PTemporal coding by coherent oscillations as a potential
    solution to the binding problem: physiological evidence,\Q In Schuster,
    H.G., Singer, W. (ed), <with|font-shape|italic|Nonlinear Dynamics and
    Neuronal Networks,> 3\U25. VCH Weinheim (1991).

    <bibitem|Feldman>J. Feldman, \PEcological expected utility and the
    mythical neural code,\Q <with|font-shape|italic|Cognitive Neurodynamics,>
    <with|font-series|bold|4>, 25\U35 (2010).

    <bibitem|Adeli0>Ghosh-Dastidar, S. and Adeli, H. (2007), \PImproved
    Spiking Neural Networks for EEG Classification and Epilepsy and Seizure
    Detection,\Q Integrated Computer-Aided Engineering, Vol. 14, No. 3, pp.
    187-212.

    <bibitem|Adeli>S. Ghosh-Dastidar and H. Adeli, \PSpiking neural
    networks,\Q <with|font-shape|italic|Intern. J. Neural Sys.>
    <with|font-series|bold|19>, 295\U308 (2009).

    <bibitem|Adeli2>S. Ghosh-Dastidar and H. Adeli, \PA New Supervised
    Learning Algorithm for Multiple Spiking Neural Networks with Application
    in Epilepsy and Seizure Detection,\Q <with|font-shape|italic|Neural
    Networks> <with|font-series|bold|22>, 1419\U1431 (2009).

    <bibitem|Gorban>A. Gorban and A. Zinovyev, \PPrincipal manifolds and
    graphs in practice: from molecular biology to dynamical systems,"
    <with|font-shape|italic|Intern. J. Neural Sys.,>
    <with|font-series|bold|20>, 219\U232 (2010).

    <bibitem|self>H. Haken, \PBrain Dynamics. Synchronization and Activity
    Patterns in Pulse-Coupled Neural Nets with Delays and Noise,\Q Springer,
    Berlin 2007.

    <bibitem|Villa>J. Iglesias and A. E. P. Villa, \PEmergence of preferred
    firing sequences in large spiking neural networks during simulated
    neuronal development,\Q <with|font-shape|italic|Intern. J. Neural Sys.,>
    <with|font-series|bold|18>, 267\U277 (2008).

    <bibitem|Johnston0>Johnston, S.P., Prasad, G.,Maguire, L. and McGinnity,
    T.M. (2010), \PAn FPGA Hardware/software co-design methodology - towards
    evolvable spiking networks for robotics application,\Q
    <with|font-shape|italic|Intern. J. Neural Sys.>, 20:6.

    <bibitem|Schwartz>E. R. Kandel, J. H. Schwartz and T. M. Jessell,
    \PPrinciples of Neural Science,\Q (Fourth ed.), New York: McGraw-Hill
    (2000).

    <bibitem|Thorpe1>H. Kirchner and S. J. Thorpe, \PUltra-rapid object
    detection with saccadic eye movements: visual processing speed
    revisited,\Q <with|font-shape|italic|Vision Res.,>
    <with|font-series|bold|46>, 1762\U1776 (2006).

    <bibitem|Konig>P. Knig, A. K. Engel and W. Singer, \PIntegrator or
    coincidence detector? The role of the cortical neuron revisited,\Q
    <with|font-shape|italic|Trends Neurosci.,> <with|font-series|bold|19>,
    130\U137 (1996).

    <bibitem|KonigKruger>P. Knig and N. Krger, \PSymbols as self-emergent
    entities in an optimization process of feature extraction and
    predictions,\Q <with|font-shape|italic|Biol. Cybern.,>
    <with|font-series|bold|94>(4), 325\U334 (2006).

    <bibitem|MacKay0>D. M. MacKay and W. S. McCulloch, \PThe limiting
    information capacity of a neuronal link,\Q <with|font-shape|italic|Bull.
    Math. Biophys.,> <with|font-series|bold|14>, 127\U135, (1952).

    <bibitem|MacKay>D. M. MacKay, \PSelf-organization in the time domain,\Q
    In M. C. Yovitts, G. T. Jacobi and G. D. Goldstein (ed),
    <with|font-shape|italic|Self-Organizing Systems,> Spartan Books,
    Washington, 37\U48 (1962).

    <bibitem|Nichols0>Nichols, E., McDaid, L.J., and Siddique, N.H. (2010),
    \PCase Study on Self-organizing Spiking Neural Networks for Robot
    Navigation,\Q <with|font-shape|italic|Intern. J. Neural Sys.>, 20:6.

    <bibitem|Passaglia>Ch. L. Passaglia and J. B. Troy, \PInformation
    transmission rates of cat retinal ganglion cells,\Q
    <with|font-shape|italic|J. Neurophysiol.,> <with|font-series|bold|91>,
    1217\U\<hyphen\>1229 (2004).

    <bibitem|Rudolph>M. Rudolph and A. Destexhe, \PTuning neocortical
    pyramidal neurons between integrators and coincidence detectors, \Q
    <with|font-shape|italic|J. Comput. Neurosci.,>
    <with|font-series|bold|14>, 239\U251 (2003).

    <bibitem|Scharf>M. T. Scharf, N. H. Woo, K. M. Lattal, Z. Young, P. V.
    Nguyen and T. Abel, \PProtein synthesis is required for the enhancement
    of long-term potentiation and long-term memory by spaced training,\Q
    <with|font-shape|italic|J. Neurophysiol.,> <with|font-series|bold|87>
    2770\U2777 (2002).

    <bibitem|Schliebs0>Schliebs, S., Kasabv, N., and Defoin-Platel, M.
    (2010), \POn the Probabilistic Optimization of Spiking Neural Networks,\Q
    <with|font-shape|italic|Intern. J. Neural Sys.>, 20:6.

    <bibitem|Shannon>C. E. Shannon, \PA mathematical theory of
    communication,\Q <with|font-shape|italic|Bell System Technical J.,>
    <with|font-series|bold|27>, 379\U423 and 623\U656, July and October,
    (1948).

    <bibitem|Soltic0>Soltic and S. Kasabov, N. (2010), \PKnowledge extraction
    from evolving spiking neural networks with rank order population coding
    ,\Q <with|font-shape|italic|Intern. J. Neural Sys.>, 20:6.

    <bibitem|Strain0>Strain, T.J., McDaid, L.J., Maguire, L.P., and T.M.
    McGinnity, T.M. (2010), \PAn STDP Training Algorithm for a Spiking Neural
    Network with Dynamic Threshold Neurons,\Q <with|font-shape|italic|Intern.
    J. Neural Sys.>, 20:6.

    <bibitem|Tang>S. Tang, R. Wolf, S. Xu and M. Heisenberg, \PVisual pattern
    recognition in Drosophila is invariant for retinal position,\Q
    <with|font-shape|italic|Science,> <with|font-series|bold|305>, 1020\U1022
    (2004).

    <bibitem|Thorpe>S. Thorpe, D. Fize and C. Marlot, \PSpeed of processing
    in the human visual system,\Q <with|font-shape|italic|Nature,>
    <with|font-series|bold|381>, 520\U522 (1996).

    <bibitem|Vid96>A. K. Vidybida, \PNeuron as time coherence
    discriminator,\Q <with|font-shape|italic|Biol. Cybern.,>
    <with|font-series|bold|74>, 539\U544 (1996).

    <bibitem|Vid96a>A. K. Vidybida, \PInformation processing in a
    pyramidal-type neuron,\Q <with|font-shape|italic|Proc. BioNet'96
    \<hyphen\> Biologieorientierte Informatik und pulspropagierende Netze,
    3-d Workshop.> Ed.: Heinz G., pp. 96\U99. (1996).

    <bibitem|Vid98>A. K. Vidybida, \PInhibition as binding controller at the
    single neuron level,\Q <with|font-shape|italic|BioSystems,>
    <with|font-series|bold|48>, 263\U267 (1998).

    <bibitem|BNF>A. K. Vidybida, \POutput stream of binding neuron with
    instantaneous feedback,\Q <with|font-shape|italic|Eur. Phys. J. B,>
    <with|font-series|bold|65>, 577\U584 (2008); <with|font-shape|italic|Eur.
    Phys. J. B,> <with|font-series|bold|69>, 313 (2009).

    <bibitem|Laurent>M. Wehr and G. Laurent, \POdor encoding by temporal
    sequences of firing in oscillating neural assemblies\Q
    <with|font-shape|italic|Nature,> <with|font-series|bold|384>, 162\U166
    (1996).

    <bibitem|Widrow>B. Widrow, \PGeneralization and information storage in
    networks of adaline `neurons' \Q in: Yovitz,M.C., Jacobi,G.T.,
    Goldstein,G.(ed), <with|font-shape|italic|Self-Organizing Systems,>
    435\U461 (1962).

    <bibitem|Wu>W. Wu and T. Chen, \PImpossibility of asymptotic
    synchronization for pulse-coupled oscillators with delayed excitatory
    coupling," <with|font-shape|italic|Intern. J. Neural Sys.,>
    <with|font-series|bold|19>, 425\U435 (2009).

    <phantom|00>
  </thebibliography>
</body>