<TeXmacs|1.99.7>

<style|<tuple|llncs|std-latex>>

<\body>
  <doc-data|<doc-title|Robust Line Planning in case of Multiple Pools and
  Disruptions>|<doc-author|<author-data|<author-inst|1,3>|<author-name|Apostolos
  Bessas>|<author-affiliation|R.A.<nbsp>Computer Technology Institute,
  N.<nbsp>Kazantzaki Str., Patras University Campus, 26500 Patras,
  Greece>>>|<doc-author|<author-data|<author-inst|1,2>|<author-name|Spyros
  Kontogiannis>|<author-affiliation|R.A.<nbsp>Computer Technology Institute,
  N.<nbsp>Kazantzaki Str., Patras University Campus, 26500 Patras,
  Greece>>>|<doc-author|<author-data|<author-inst|1,3>|<author-name|Christos
  Zaroliagis>|<author-affiliation|R.A.<nbsp>Computer Technology Institute,
  N.<nbsp>Kazantzaki Str., Patras University Campus, 26500 Patras, Greece>>>>

  <abstract-data|<\abstract>
    We consider the line planning problem in public transportation, under a
    robustness perspective. We present a mechanism for robust line planning
    in the case of multiple line pools, when the line operators have a
    different utility function per pool. We conduct an experimental study of
    our mechanism on both synthetic and real-world data that shows fast
    convergence to the optimum. We also explore a wide range of scenarios,
    varying from an arbitrary initial state (to be solved) to small
    disruptions in a previously optimal solution (to be recovered). Our
    experiments with the latter scenario show that our mechanism can be used
    as an online recovery scheme causing the system to re-converge to its
    optimum extremely fast.
  </abstract>>

  <pagestyle|headings>

  <assign|myvector|<macro|1|<math|<with|math-font-series|bold|<arg|1>>>>><assign|mv|<macro|1|<myvector|<arg|1>>>><assign|hvec|<macro|1|<math|<myvector|<wide|<arg|1>|^>>>>><assign|tvec|<macro|1|<math|<myvector|<wide|<arg|1>|~>>>>><assign|bvec|<macro|1|<math|<myvector|<wide|<arg|1>|\<bar\>>>>>><assign|matrixrow|<macro|1|2|<math|<myvector|<arg|1>><rsub|<arg|2>,\<star\>>>>><assign|matrixcol|<macro|1|2|<math|<myvector|<arg|1>><rsub|\<star\>,<arg|2>>>>><assign|mymatrix|<macro|1|<math|<with|math-font-series|bold|<arg|1>>>>><assign|mm|<macro|1|<mymatrix|<arg|1>>>><assign|Rp|<macro|<matrixcol|R|p>>><assign|Rl|<macro|<matrixrow|R|\<ell\>>>><assign|reals|<macro|<math|\<bbb-R\>>>><assign|nonnegativereals|<macro|<math|\<bbb-R\><rsub|\<geq\>0>>>><assign|Event|<macro|\<cal-E\>>><assign|Ind|<macro|1|\<bbb-I\><rsub|<left|{><arg|1><right|}>>>><assign|vector|<macro|1|<wide|<arg|1>|\<vect\>>>><assign|hvec|<macro|1|<wide|<wide|<arg|1>|^>|\<vect\>>>><assign|tvec|<macro|1|<wide|<wide|<arg|1>|~>|\<vect\>>>><assign|La|<macro|\<Lambda\>>><assign|la|<macro|\<lambda\>>><assign|REMOVED|<macro|1|>>

  <vspace|-0.5cm>

  <\center>
    <date|>
  </center>

  <vspace|-0.5cm>

  <section|Introduction><label|sec:intro>

  Line planning is an important phase in the hierarchical planning process of
  every railway (or public transportation) network<footnote|For the sake of
  convenience, we concentrate in this work on railway networks, but the
  methods and ideas developed can be applied to any public transportation
  network.>. The goal is to determine the routes (or lines) of trains that
  will serve the customers along with the frequency each train will serve a
  particular route. Typically, the final set of lines is chosen by a
  (predefined) set of candidate lines, called the <em|line pool>. In certain
  cases, there may be <em|multiple line pools> representing the availability
  of the network infrastructure at different time slots or zones. This is due
  to variations in customer traffic (e.g., rush-hour pool, late evening pool,
  night pool), maintenance (some part of the network at a specific time zone
  may be unavailable), dependencies between lines (e.g., the choice of a
  high-speed line may affect the choice of lines for other trains), etc.

  The line planning problem has been extensively studied under cost-oriented
  or customer-oriented approaches (see e.g.,
  <cite|D78|GHK2004|SS2005|S2005>). Recently, robustness issues have been
  started to be investigated. In the <em|robust line planning> problem, the
  task is to provide a set of lines along with their frequencies, which are
  robust to fluctuations of input parameters; typical fluctuations include,
  for instance, disruptions to daily operations (e.g., delays), or varying
  customer demands. In <cite|SS2006>, a game-theoretic approach to robust
  line planning was presented that delivers lines and frequencies that are
  robust to delays.

  A different perspective of robust line planning was investigated in
  <cite|BKZ2009>. This perspective stems form recent regulations in the
  European Union that introduce competition and free railway markets for its
  members. Under these rules the following scenario emerges: there is a
  (usually state) authority that manages the railway network infrastructure,
  referred to as the <em|Network Operator> (NOP), and a (potentially) large
  number of <em|Line Operators> (LOPs) operating as commercial organizations
  which want to offer services to their customers using the given railway
  network. These LOPs act as competing agents for the exploitation of the
  shared infrastructure and are unwilling to disclose their utility functions
  that demonstrate their true incentives. The network operator wishes to set
  up a fair cost sharing scheme for the usage of the shared resources and to
  ensure the maximum possible level of satisfaction of the competing agents
  (by maximizing their aggregate utility functions). The former implies a
  resource pricing scheme that is robust against changes in the demands of
  the LOPs, while the latter establishes a notion of a socially optimal
  solution, which could also be considered as a fair solution, in the sense
  that the average level of satisfaction is maximized. In other words, the
  NOP wishes to establish an incentive-compatible mechanism that provides
  <em|robustness> to the system in the sense that it tolerates the agents'
  unknown incentives and elasticity of demand requests and it eventually
  stabilizes the system at an equilibrium point that is as close as possible
  to the social optimum.

  The first such mechanism, for robust line planning in the aforementioned
  scenario, was presented in <cite|BKZ2009>. In that paper, the following
  mechanism was investigated (motivated by the pioneering work of Kelly et
  al.<nbsp><cite|K97|KMT98> in communication networks): the LOPs offer bids,
  which they (dynamically) update for buying frequencies. The NOP announces
  an (anonymous) resource pricing scheme, which indirectly implies an
  allocation of frequencies to the LOPs, given their own bids. For the case
  of a single pool of lines, a distributed, dynamic, LOP bidding and
  (resource) price updating scheme was presented, whose equilibrium point is
  the unknown social optimum \U assuming strict concavity and monotonicity of
  the private (unknown) utility functions. This development was complemented
  by an experimental study on a discrete variant of the distributed, dynamic
  scheme on both synthetic and real-world data showing that the mechanism
  converges really fast to the social optimum. The approach to the single
  pool was extended to derive an analogous mechanism for the case of multiple
  line pools, where it was assumed that (i) the NOP can periodically exploit
  a whole set of (disjointly operating) line pools and he decides on how to
  divide the whole infrastructure among the different pools so that the
  resource capacity constraints are preserved; (ii) each LOP may be
  interested in different lines from different pools; and (iii) each LOP has
  a single utility function which depends on the aggregate frequency that she
  gets from all the pools in which she is involved.

  The aforementioned theoretical framework demonstrated the potential of
  converging to the social optimum via a mechanism (dynamic system) that
  exploits the selfishness of LOPs. A significant issue is the speed or rate
  of convergence of this mechanism. Since there was no theoretical treatment
  of this issue, its lack was covered in <cite|BKZ2009> for the single pool
  case via a complementary experimental study. Despite, however, the
  significance of the convergence rate issue, the mechanism for the multiple
  pool case was <em|not> experimentally evaluated in <cite|BKZ2009>.

  For the case of multiple line pools, it is often more realistic to assume
  that each LOP has a different utility function per pool, since different
  pools are expected to provide different profits (e.g., intercity versus
  regional lines, or rush-hour versus late-evening lines). Moreover, it seems
  more natural to assume that each LOP has a different utility function per
  pool that depends on the frequency she gets for that pool, rather than a
  single utility function that depends on the total frequency she gets across
  all pools.

  In this work, we continue this line of research by further investigating
  the multiple pool case. In particular, we make the following contributions:
  (1) Contrary to the approach in <cite|BKZ2009>, we consider the case where
  each LOP has a different utility function for each line pool she is
  interested in, and show how the approach in <cite|BKZ2009> can be extended
  in order to provide a mechanism for this case, too. (2) We conduct an
  experimental study on a discrete variant of the new mechanism on both
  synthetic and real-world data demonstrating its fast convergence to the
  social optimum. (3) We conduct an additional experimental study, on both
  synthetic and real-world data, to investigate the robustness of the system
  in the case of disruptions that affect the available capacity, which may be
  reduced (due to temporary unavailability of part of the network), or
  increased (by allowing usage of additional infrastructure during certain
  busy periods). In this case, we show that the NOP can re-converge (recover)
  the system to the social optimum pretty fast, starting from a previous
  optimal solution.

  The rest of the paper is organized as follows. In
  Section<nbsp><reference|sec:mlp>, we present the mechanism for the case of
  multiple line pools, where each LOP has a different utility function per
  pool. In Sections<nbsp><reference|sec:exp-mlp> and
  <reference|sec:disruptions>, we present the main contributions of this work
  for the multiple line pool case; namely, the experimental study showing the
  fast convergence of the new mechanism, and the robustness of the system in
  the case of disruptions, respectively. We conclude in
  Section<nbsp><reference|sec:conclusions>.

  <section|Multiple Line Pools: Different Utility Functions per
  Pool><label|sec:mlp>

  The exposition in this section follows that in <cite|BKZ2009>. Although the
  analysis of our approach is based on the same methodology as that in
  <cite|BKZ2009>, we have chosen to present all the details for making the
  paper self-contained and for the better understanding of the experimental
  studies.

  In the <em|line planning> problem, the NOP provides the public
  transportation network in the form of a directed graph
  <math|G=<around|(|V,L|)>>, where <math|V> is the node set representing
  train stations and important railway junctions, and <math|L> is the edge
  set representing direct connections or links (of railway tracks) between
  elements of <math|V>. Each edge <math|\<ell\>\<in\>L> is associated with a
  capacity <math|c<rsub|\<ell\>>\<gtr\>0>, which limits the number of trains
  that can use this edge in the period examined. A line <math|p> is a path in
  <math|G>.

  For our purposes, we assume that there is set <math|K> of line pools, where
  each pool represents a different set of possible routes (each corresponding
  to a different period of the day). We envision the line pools to be
  implemented in disjoint time intervals (e.g., via some sort of time
  division multiplexing), and also to concern different characteristics of
  the involved lines (e.g., high-speed pool, regular-speed pool, local-trains
  pool, rush-hour pool, night-shift pool, etc.). The capacity of each
  resource (edge) refers to its usage (number of trains) over the whole time
  period we consider (e.g., a day), and if a particular pool consumes (say)
  50% of the whole infrastructure, then this implies that for all the lines
  in this pool, each resource may exploit at most half of its capacity. It is
  up to the NOP to determine how to split a whole operational period of the
  railway infrastructure among the different pools, so that (for the whole
  period) the resource capacity constraints are not violated.

  There is also a set <math|P> of LOPs, who choose their lines from <math|K>.
  We assume that each LOP <math|p\<in\>P> is interested only in one line in
  each pool (we can always enforce this assumption by considering a LOP
  interested in more than one routes as different LOPs distinguished by the
  specific route). Each line pool and the preference of LOPs to lines in it
  are represented by a <em|routing matrix>
  <math|<mm|R><around|(|k|)>\<in\><around|{|0,1|}><rsup|<around|\||L|\|>\<times\><around|\||P|\|>>,k\<in\>K>.
  Each row <math|<matrixrow|R|\<ell\>><around|(|k|)>> corresponds to a
  different edge <math|\<ell\>\<in\>L>, and each column
  <math|<matrixcol|R|p><around|(|k|)>> corresponds to a different LOP
  <math|p\<in\>P>, showing which edges comprise her line in pool <math|k>.

  Each LOP <math|p\<in\>P> acquires a <em|frequency> of trains that she
  wishes to route over her paths in <math|<matrixcol|R|p><around|(|k|)>,k\<in\>K>,
  such that no edge capacity constraint is violated by the aggregate
  frequency running through it by all LOPs and pools. A utility function
  <math|U<rsub|p,k>:<nonnegativereals>\<mapsto\><nonnegativereals>>
  determines the <em|level of satisfaction> of LOP <math|p\<in\>P> in pool
  <math|k\<in\>K> for being given an end-to-end frequency
  <math|x<rsub|p,k>\<gtr\>0>. Having different utility functions per pool,
  instead of a single utility function across all pools, is more generic and
  hence more realistic, since a LOP <math|p> can indeed have different
  valuations for different periods of a day (rush-hour pool vs night-shift
  pool) and/or different types of trains (high-speed pool vs local-trains
  pool). These utility functions are assumed to be strictly increasing,
  strictly concave, non-negative real functions of the end-to-end frequency
  <math|x<rsub|p,k>> allocated to LOP <math|p\<in\>P> in pool
  <math|k\<in\>K>.

  The aggregate satisfaction level <math|U<rsub|p>> of LOP <math|p\<in\>P>
  across all pools is given by the sum of the individual gains she has in
  each pool, that is

  <\equation*>
    U<rsub|p><around|(|<vector|x><rsub|p>|)>=U<rsub|p><around|(|x<rsub|p,1>,\<ldots\>,x<rsub|p,k>|)>=<big|sum><rsub|k\<in\>K>U<rsub|p,k><around|(|x<rsub|p,k>|)>,<space|1em>\<forall\>p\<in\>P
  </equation*>

  where <math|<vector|x><rsub|p>=<around|(|x<rsub|p,k>|)><rsub|k\<in\>K>> is
  the vector of frequencies that <math|p> gets for all the pools. The utility
  functions are <em|private> to the LOP; she is not willing to share them for
  competitiveness reasons, not even with the NOP. This has a few implications
  on the necessary approach to handle the problem.

  The NOP, on the other hand, wishes to allocate to each LOP a frequency
  vector <math|<hvec|x><rsub|p>=<big|sum><rsub|k\<in\>K><wide|x|^><rsub|p,k>>
  such that the cumulative satisfaction of all the LOPs is maximized, while
  respecting all the edge capacity constraint. To achieve this, the NOP
  divides the whole railway infrastructure to the pools, using variables
  <math|f<rsub|k>,k\<in\>K> that determine the proportion of the total
  capacity of the edges that is assigned to pool <math|k>. Hence, the NOP
  wishes to solve the following strictly convex optimization problem:

  <\equation>
    <label|eq:MSC-diffU><aligned|<tformat|<table|<row|<cell|max<space|1em>>|<cell|<big|sum><rsub|p\<in\>P>U<rsub|p><around|(|<vector|x><rsub|p>|)>=<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K>U<rsub|p,k><around*|(|x<rsub|p,k>|)>>>|<row|<cell|s.*t.<space|1em>>|<cell|<big|sum><rsub|p\<in\>P>R<rsub|\<ell\>,p><around|(|k|)>\<cdot\>x<rsub|p,k>\<le\>c<rsub|\<ell\>>\<cdot\>f<rsub|k>,<space|0.17em>\<forall\><around|(|\<ell\>,k|)>\<in\>L\<times\>K>>|<row|<cell|>|<cell|<big|sum><rsub|k\<in\>K>f<rsub|k>\<le\>1>>|<row|<cell|>|<cell|<mv|x>,<mv|f>\<ge\>0>>>>>
  </equation>

  <REMOVED|The problem is convex, since it is a maximization problem and the
  objective function is the sum of concave functions as well as because the
  feasible space is linear (we make the assumption that a convex problem is a
  minimization problem with a convex objective function, which is equivalent
  with a maximization problem with a concave objective function). > Clearly,
  the NOP cannot solve this problem directly for (at least) two reasons: (i)
  the utility functions are unknown to him; (ii) the scale of the problem can
  be too large (as it is typical with railway networks) so that it can be
  solved efficiently via a centralized computation. The latter is
  particularly important when the whole system is already at some equilibrium
  state and then suddenly a (small, relative to the size of the whole
  problem) perturbation in the problem parameters occurs. Then, rather than
  having a whole new re-computation of the new optimal solution from scratch,
  it is particularly desirable that a dynamical scheme allows convergence to
  the new optimal solution, starting from this worm start (of the previously
  optimal solution). All the above reasons dictate searching for a different
  solution approach, that has to be as decentralized as possible.

  <paragraph|Optimal Solution.> We adopt the approach in <cite|BKZ2009> to
  design a mechanism that will be run by the NOP in order to solve the above
  problem. In particular, rather than having the NOP directly deciding for
  the frequencies of all the LOPs in each pool, we first let each LOP make
  her own bid for frequency in each pool. Then, the NOP consider the solution
  of a convex program which is similar, but not identical to
  (<reference|eq:MSC-diffU>), using a set of (strictly increasing, strictly
  concave) pseudo-utilities. Our goal is to exploit the rational
  (competitive) behavior of the LOPs, in order to assure that eventually the
  optimal solution reached for this new program is identical to that of
  (<reference|eq:MSC-diffU>), as required.

  We start by describing the necessary and sufficient optimality (KKT)
  conditions for (<reference|eq:MSC-diffU>). We study the Lagrangian function
  and exploit the economic interpretation of the Lagrangian multipliers. Let
  <math|<vector|<La>>> be the vector of Lagrangian multipliers for the
  resource capacity constraints, and <math|\<zeta\>> the Lagrangian
  multiplier concerning the constraint for the capacity proportions per pool.
  The Lagrangian function of (<reference|eq:MSC-diffU>) is as follows:

  <\equation*>
    <label|eq:lagrange-MNET-II><aligned|<tformat|<table|<row|<cell|>|<cell|L<around|(|<mv|x>,<mv|f>,<mv|\<Lambda\>>,\<zeta\>|)>=>>|<row|<cell|>|<cell|<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K>U<rsub|p,k><around|(|x<rsub|p,k>|)>-<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K>\<Lambda\><rsub|\<ell\>,k>\<cdot\><around*|[|<big|sum><rsub|p\<in\>P>R<rsub|\<ell\>,p><around|(|k|)>\<cdot\>x<rsub|p,k>-c<rsub|\<ell\>>\<cdot\>f<rsub|k>|]>-\<zeta\>*<around*|[|<big|sum><rsub|k\<in\>K>f<rsub|k>-1|]>=>>|<row|<cell|>|<cell|<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><around*|[|U<rsub|p,k><around|(|x<rsub|p,k>|)>-x<rsub|p,k><around*|(|<big|sum><rsub|\<ell\>\<in\>L>\<Lambda\><rsub|\<ell\>,k>\<cdot\>R<rsub|\<ell\>,p><around|(|k|)>|)>|]>+<big|sum><rsub|k\<in\>K>f<rsub|k>\<cdot\><around*|[|<mv|c><rsup|T><matrixcol|\<Lambda\>|k>-\<zeta\>|]>+\<zeta\>=>>|<row|<cell|>|<cell|<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><around*|[|U<rsub|p,k><around|(|x<rsub|p,k>|)>-x<rsub|p,k>\<cdot\>\<mu\><rsub|p,k><around|(|<mv|\<Lambda\>>|)>|]>+<big|sum><rsub|k\<in\>K>f<rsub|k>\<cdot\><around*|[|<mv|c><rsup|T><matrixcol|\<Lambda\>|k>-\<zeta\>|]>+\<zeta\>,>>>>>
  </equation*>

  where <math|\<mu\><rsub|p,k><around|(|<mv|\<Lambda\>>|)>\<equiv\><big|sum><rsub|\<ell\>\<in\>L>\<Lambda\><rsub|\<ell\>,k>\<cdot\>R<rsub|\<ell\>,p><around|(|k|)>>.
  We interpret <math|\<Lambda\><rsub|\<ell\>,k>> to be the
  per-unit-of-frequency price of edge <math|\<ell\>\<in\>L> in pool
  <math|k\<in\>K>. Thus, <math|\<mu\><rsub|p,k><around|(|<mv|\<Lambda\>>|)>>
  is the end-to-end per-unit price that LOP <math|p> has to pay for pool
  <math|k>.

  The optimality (KKT) conditions for (<reference|eq:MSC-diffU>) are the
  following:

  <align|<tformat|<table|<row|<cell|\<forall\><around|(|p,k|)>\<in\>P\<times\>K,<space|0.27em>U<rprime|'><rsub|p,k><around|(|<wide|x|^><rsub|p,k>|)>>|<cell|=<wide|\<mu\>|^><rsub|p,k>\<equiv\>\<mu\><rsub|p,k><around|(|<hvec|\<Lambda\>>|)><label|eq:selfish-KKT-MSC-2>>>|<row|<cell|<mv|c><rsup|T>\<cdot\><matrixcol|<wide|\<Lambda\>|^>|k>\<equiv\><big|sum><rsub|\<ell\>\<in\>L><wide|\<Lambda\>|^><rsub|\<ell\>,k>\<cdot\>c<rsub|\<ell\>>>|<cell|=<wide|\<zeta\>|^>,<space|0.27em>\<forall\>k\<in\>K<label|eq:zeta-KKT-MSC-2>>>|<row|<cell|<wide|\<Lambda\>|^><rsub|\<ell\>,k>*<around*|[|<big|sum><rsub|p\<in\>P>R<rsub|\<ell\>,p><around|(|k|)>*<wide|x|^><rsub|p,k>-c<rsub|\<ell\>>*<wide|f|^><rsub|k>|]>>|<cell|=0,<space|0.27em>\<forall\><around|(|\<ell\>,k|)>\<in\>L\<times\>K<label|eq:complementarity1-KKT-MSC-2>>>|<row|<cell|<wide|\<zeta\>|^>\<cdot\><around*|(|<big|sum><rsub|k\<in\>K><wide|f|^><rsub|k>-1|)>>|<cell|=0<label|eq:complementarity2-KKT-MSC-2>>>|<row|<cell|<big|sum><rsub|p\<in\>P>R<rsub|\<ell\>,p><around|(|k|)>\<cdot\><wide|x|^><rsub|p,k>>|<cell|\<leq\>c<rsub|\<ell\>>\<cdot\><wide|f|^><rsub|k>,<space|0.27em>\<forall\><around|(|\<ell\>,k|)>\<in\>L\<times\>K>>|<row|<cell|<big|sum><rsub|k\<in\>K><wide|f|^><rsub|k>>|<cell|\<leq\>1>>|<row|<cell|<hvec|x>,<hvec|f>,<hvec|\<Lambda\>>,<wide|\<zeta\>|^>>|<cell|\<geq\><mv|0><no-number>>>>>>

  These conditions characterize the optimal solution of <eqref|eq:MSC-diffU>.
  From these equations, one can observe for the optimal solution
  <math|<around|(|<hvec|x>,<hvec|f>|)>> and its accompanying vector of
  Lagrangian multipliers <math|<around|(|<hvec|<La>>,<wide|\<zeta\>|^>|)>>:

  <\enumerate>
    <item>By equation<nbsp>(<reference|eq:zeta-KKT-MSC-2>) all pools (at
    optimality) have the same (weighted with the capacities of the edges)
    aggregate per-unit-of-frequency cost <math|<wide|\<zeta\>|^>>.

    <item>By equation<nbsp>(<reference|eq:complementarity2-KKT-MSC-2>) either
    <math|<wide|\<zeta\>|^>=0> or <math|<big|sum><rsub|k\<in\>K><wide|f|^><rsub|k>=1>.
    The former case (all prices are set to zero) cannot actually happen,
    since otherwise all the pools would have zero aggregate cost (i.e., every
    edge is underutilized in every pool). Then we could slightly increase the
    frequencies of all the LOPs in all the pools by a positive constant and
    keep exactly the same vector of proportions <math|<hvec|f>>, which would
    lead to a strictly better solution (the utility functions are strictly
    increasing), contradicting the optimality of <math|<hvec|x>>. Hence, we
    consider only the case, where at least some resources have positive
    costs. In this case, the condition <math|<big|sum><rsub|k\<in\>K><wide|f|^><rsub|k>=1>
    must hold. Any vector <mv|f> for which this condition holds is said to
    <em|completely divide> the infrastructure among the pools.
  </enumerate>

  <paragraph|Limited Information and Decentralized Mechanism.> As already
  mentioned, the NOP cannot know the utility functions. Therefore, a slightly
  different problem is considered: Each LOP <math|p\<in\>P> announces
  (non-negative) bids <math|w<rsub|p,k>\<geq\>0> (one per pool), which she is
  committed to spend for acquiring frequencies in the pools. Consequently,
  the NOP replaces the unknown utility functions with the pseudo-utilities
  <math|w<rsub|p,k>*log <around|(|x<rsub|p,k>|)>> in order to determine a
  frequency vector that maximizes the aggregate level of pseudo-satisfaction.
  Observe that these used pseudo-utilities are also strictly increasing,
  strictly concave functions of the LOPs' frequencies. That means, that NOP
  wishes to solve the following (strictly convex) optimization problem that
  is completely known to him:

  <\equation>
    <label|eq:MNET-II><aligned|<tformat|<table|<row|<cell|max<space|1em>>|<cell|<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K>w<rsub|p,k>*log
    <around|(|x<rsub|p,k>|)>>>|<row|<cell|s.*t.<space|1em>>|<cell|<big|sum><rsub|p\<in\>P>R<rsub|\<ell\>,p><around|(|k|)>\<cdot\>x<rsub|p,k>\<leq\>c<rsub|\<ell\>>\<cdot\>f<rsub|k>,<space|0.27em>\<forall\><around|(|\<ell\>,k|)>\<in\>L\<times\>K>>|<row|<cell|>|<cell|<big|sum><rsub|k\<in\>K>f<rsub|k>\<leq\>1>>|<row|<cell|>|<cell|<mv|x>,<mv|f>\<ge\><mv|0>.>>>>>
  </equation>

  The optimal solution vector <math|<around|(|<bvec|x>,<bvec|f>|)>>, along
  with the corresponding vector of Lagrange multipliers
  <math|<around|(|<bvec|<La>>,<wide|\<zeta\>|\<bar\>>|)>>, must satisfy the
  following necessary and sufficient optimality (KKT) conditions for
  <eqref|eq:MNET-II>:

  <align*|<tformat|<table|<row|<cell|\<forall\><around|(|p,k|)>\<in\>P\<times\>K,<space|0.27em><frac|w<rsub|p,k>|<wide|x|\<bar\>><rsub|p,k>>>|<cell|=<wide|\<mu\>|\<bar\>><rsub|p,k>\<equiv\>\<mu\><rsub|p,k><around|(|<bvec|\<Lambda\>>|)><label|eq:selfish-KKT-MNET-2>>>|<row|<cell|<mv|c><rsup|T>\<cdot\><matrixcol|<wide|\<Lambda\>|\<bar\>>|k>\<equiv\><big|sum><rsub|\<ell\>\<in\>L><wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>\<cdot\>c<rsub|\<ell\>>>|<cell|=<wide|\<zeta\>|\<bar\>>,<space|0.27em>\<forall\>k\<in\>K<label|eq:zeta-KKT-MNET-2>>>|<row|<cell|<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>*<around*|[|<big|sum><rsub|p\<in\>P>R<rsub|\<ell\>,p><around|(|k|)>*<wide|x|\<bar\>><rsub|p,k>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|]>>|<cell|=0,<space|0.27em>\<forall\><around|(|\<ell\>,k|)>\<in\>L\<times\>K<label|eq:complementarity1-KKT-MNET-2>>>|<row|<cell|<wide|\<zeta\>|\<bar\>>\<cdot\><around*|(|<big|sum><rsub|k\<in\>K><wide|f|\<bar\>><rsub|k>-1|)>>|<cell|=0<label|eq:complementarity2-KKT-MNET-2>>>|<row|<cell|<big|sum><rsub|p\<in\>P>R<rsub|\<ell\>,p><around|(|k|)>\<cdot\><wide|x|\<bar\>><rsub|p,k>>|<cell|\<leq\>c<rsub|\<ell\>>\<cdot\><wide|f|\<bar\>><rsub|k>,<space|0.27em>\<forall\><around|(|\<ell\>,k|)>\<in\>L\<times\>K>>|<row|<cell|<big|sum><rsub|k\<in\>K><wide|f|\<bar\>><rsub|k>>|<cell|\<leq\>1>>|<row|<cell|<bvec|x>,<bvec|f>,<bvec|\<Lambda\>>,<wide|\<zeta\>|\<bar\>>>|<cell|\<geq\><mv|0><no-number>>>|<row|<cell|>|<cell|>>>>>

  This problem can of course be solved in polynomial time, given the bid of
  the LOPs <math|<vector|w>=<around|(|w<rsub|p,k>|)><rsub|<around|(|p,k|)>\<in\>P\<times\>K>>.
  Equation<nbsp><eqref|eq:selfish-KKT-MNET-2> means that the NOP (correctly)
  assigns frequency <math|<wide|x|\<bar\>><rsub|p,k>=<frac|w<rsub|p,k>|<wide|\<mu\>|\<bar\>><rsub|p,k>>>,
  which is affordable at the (path) per-unit price
  <math|<wide|\<mu\>|\<bar\>><rsub|p,k>> for LOP <math|p> who is committed to
  afford an amount of <math|w<rsub|p,k>> for acquiring frequency in pool
  <math|k>. As already said, <math|<around|(|<bvec|x>,<bvec|f>|)>> is the
  optimal solution for any bid vector declared by the LOPs, and in particular
  it also holds for the true bid vector that the LOPs would really wish to
  afford.

  Observe, also, that problems (KKT-MSC-II) and (KKT-MNET-II) differ only in
  equations (<reference|eq:selfish-KKT-MSC-2>) and
  (<reference|eq:selfish-KKT-MNET-2>). Our next step is to somehow assure
  that these two conditions coincide. To this direction, we exploit the
  rational behavior of the LOPs: Each LOP wishes to maximize her own
  aggregate level of satisfaction, therefore, she would declare a bid vector
  that would actually achieve this. In what follows, we assume that the LOPs
  are <em|price takers> meaning that each of them considers the prices
  announced by the NOP as constants, with no hope of affecting them by their
  own bid vector. This property is important in the following analysis, and
  is realistic when there exist many LOPs, each controlling only negligible
  fractions of the total flow (or bidding process) in the system. We now
  state and prove an important theorem for the existence of a mechanism for
  this problem.

  <\theorem>
    Given a transportation network <math|G=<around|(|V,L|)>>, a set of line
    pools <math|K> and a set <math|P> of selfish, price-taking LOPs, each
    having a private utility function for each pool with parameter the
    frequency that is allocated to her in the particular pool, there is a
    mechanism (a pair of a frequency allocation mechanism and a resource
    pricing scheme) that computes in polynomial time the optimal solution of
    the sum of the utility functions of the players, while respecting the
    capacities of the edges.
  </theorem>

  <\proof>
    We create the following mechanism. The NOP completely divides the
    infrastructure and, depending on the bids of the LOPs, announces the
    optimal frequencies <math|<wide|x|\<bar\>><rsub|p,k>> for each LOP
    <math|p\<in\>P> and the current resource (edge) prices
    <math|<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>,\<forall\>\<ell\>\<in\>L,k\<in\>K>.
    We have that, <math|<wide|x|\<bar\>><rsub|p,k>=<frac|w<rsub|p,k>|<wide|\<mu\>|\<bar\>><rsub|p,k>>>.
    Each (selfish) LOP is interested in solving the following strictly convex
    optimization problem:

    <\equation>
      <label|eq:muser-II><aligned|<tformat|<table|<row|<cell|max<space|1em>>|<cell|<big|sum><rsub|k\<in\>K><around*|(|U<rsub|p,k><around|(|<wide|x|\<bar\>><rsub|p,k>|)>-w<rsub|p,k>|)>=<big|sum><rsub|k\<in\>K><around*|(|U<rsub|p,k><around*|(|<frac|w<rsub|p,k>|<wide|\<mu\>|\<bar\>><rsub|p,k>>|)>-w<rsub|p,k>|)>>>|<row|<cell|s.*t.<space|1em>>|<cell|<space|8em>w<rsub|p,k>\<ge\>0,<space|0.27em>\<forall\>k\<in\>K>>>>>
    </equation>

    That is, she tries to maximize the utility she gets over the frequency
    she will be granted by the NOP, after subtracting the bid she has to pay
    for this frequency.

    Due to the price taking property of LOP <math|p>, we can obtain the
    solution of the <eqref|eq:muser-II> by differentiating the objective
    function and setting every partial derivative equal to zero:

    <\equation*>
      <frac|\<partial\>|\<partial\>*w<rsub|p,k>>*<big|sum><rsub|k\<in\>K><around*|(|U<rsub|p,k><around*|(|<frac|w<rsub|p,k>|<wide|\<mu\>|\<bar\>><rsub|p,k>>|)>-w<rsub|p,k>|)>=0,<space|0.27em>\<forall\>k\<in\>K
    </equation*>

    we get

    <gather*|<tformat|<table|<row|<cell|U<rprime|'><rsub|p,k><around*|(|<frac|w<rsub|p,k>|<wide|\<mu\>|\<bar\>><rsub|p,k>>|)>\<cdot\><frac|1|<wide|\<mu\>|\<bar\>><rsub|p,k>>-1=0\<Rightarrow\>U<rprime|'><rsub|p,k><around*|(|<wide|x|\<bar\>><rsub|p,k>|)>=<wide|\<mu\>|\<bar\>><rsub|p,k>>>>>>

    However, this is the set of equations <eqref|eq:selfish-KKT-MSC-2> of the
    KKT conditions for the (MSC-II) problem. That is, every LOP chooses the
    bids in a way that matches the equation <eqref|eq:selfish-KKT-MSC-2>. But
    this will happen in the optimal solution of (MNET-II) as well. Therefore,
    the selfish choice of bids by the LOPs enforces the identification of the
    optimal solution of MSC-II and MNET-II. I.e., we have managed to delegate
    the problem of choosing the optimal bids in each iteration to the LOPs
    and, in doing so, we have matched the first equation of the optimality
    conditions of MSC-II. <math|\<Box\>>
  </proof>

  This polynomially tractable mechanism (based on the solvability of MNET-II)
  is totally centralized and rather inconvenient for a dynamically changing
  (over time), large-scale railway system. The following lemma (whose proof
  can be found in the Appendix) is crucial in deriving a dynamical system for
  solving <eqref|eq:MSC-diffU>.

  <\lemma>
    <label|lm:main>For any (fixed) vector <mv|f> of capacity proportions that
    completely divides the railway infrastructure among the pools, the
    optimal value of <eqref|eq:MSC-diffU> exclusively depends on the optimal
    vector <bvec|\<Lambda\>> of the per-unit-of-frequency prices of the
    resources.
  </lemma>

  <\REMOVED>
    <\proof>
      The Lagrangian function of the problem is:

      <\equation*>
        L<around|(|<mv|x>,<mv|f>,<mv|\<Lambda\>>,\<zeta\>|)>=<next-line><big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><around*|[|U<rsub|p,k><around|(|x<rsub|p,k>|)>-x<rsub|p,k>\<cdot\>\<mu\><rsub|p,k><around|(|<mv|\<Lambda\>>|)>|]>+<big|sum><rsub|k\<in\>K>f<rsub|k>\<cdot\><around*|[|<mv|c><rsup|T><matrixcol|\<Lambda\>|k>-\<zeta\>|]>+\<zeta\>.
      </equation*>

      The dual problem of <eqref|eq:MSC-diffU> is the following:

      <\equation*>
        <aligned|<tformat|<table|<row|<cell|max<space|1em>>|<cell|D<around|(|<mv|\<Lambda\>>,\<zeta\>|)>>>|<row|<cell|s.*t.<space|1em>>|<cell|\<Lambda\><rsub|\<ell\>,k>\<ge\>0<space|1em>\<forall\>\<ell\>\<in\>L,<space|0.17em>\<forall\>k\<in\>K>>|<row|<cell|>|<cell|\<zeta\>\<ge\>0,>>>>>
      </equation*>

      where

      <align*|<tformat|<table|<row|<cell|>|<cell|D<around|(|<mv|\<Lambda\>>,\<zeta\>|)>=>>|<row|<cell|>|<cell|=max
      <around*|{|L<around|(|<mv|x>,<mv|f>,<mv|\<Lambda\>>,\<zeta\>|)>:<mv|x>,<mv|f>\<ge\><mv|0>|}>>>|<row|<cell|>|<cell|=max<rsub|<mv|x>,<mv|f>\<ge\><mv|0>><around*|{|<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><around*|[|U<rsub|p,k><around|(|x<rsub|p,k>|)>-x<rsub|p,k>*<big|sum><rsub|l\<in\>L>\<Lambda\><rsub|\<ell\>,k>*R<rsub|\<ell\>,p><around|(|k|)>|]>+<big|sum><rsub|k\<in\>K>f<rsub|k>*<around*|[|<big|sum><rsub|\<ell\>\<in\>L>\<Lambda\><rsub|\<ell\>,k>*c<rsub|\<ell\>>-\<zeta\>|]>+\<zeta\>|}>>>|<row|<cell|>|<cell|=max<rsub|<mv|x>\<ge\><mv|0>><around*|{|<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><around*|[|U<rsub|p><around|(|x<rsub|p>|)>-x<rsub|p,k>*\<mu\><rsub|p,k><around|(|<mv|\<Lambda\>>|)>|]>|}>+max<rsub|<mv|f>\<ge\><mv|0>><around*|{|<big|sum><rsub|k\<in\>K>f<rsub|k>*<around*|[|<big|sum><rsub|\<ell\>\<in\>L>\<Lambda\><rsub|\<ell\>,k>*c<rsub|\<ell\>>-\<zeta\>|]>|}>+\<zeta\>.>>>>>

      For the part

      <\equation*>
        P<rsub|1><around|(|<mv|\<Lambda\>>|)>=max<rsub|<mv|x>\<ge\><mv|0>><around*|{|<big|sum><rsub|p\<in\>P><around*|[|U<rsub|p><around|(|x<rsub|p>|)>-<big|sum><rsub|k\<in\>K>x<rsub|p,k>\<cdot\>\<mu\><rsub|p,k><around|(|<mv|\<Lambda\>>|)>|]>|}>
      </equation*>

      we have, that it is a simple maximization problem the solution of which
      depends exclusively on the optimal vector of resource prices
      <bvec|\<Lambda\>>.

      For the part

      <align*|<tformat|<table|<row|<cell|P<rsub|2><around|(|<mv|\<Lambda\>>,\<zeta\>|)>>|<cell|=max<rsub|<mv|f>\<ge\><mv|0>><around*|{|<big|sum><rsub|k\<in\>K>f<rsub|k>\<cdot\><around*|[|<big|sum><rsub|\<ell\>\<in\>L>\<Lambda\><rsub|\<ell\>,k>\<cdot\>c<rsub|\<ell\>>-\<zeta\>|]>|}>+\<zeta\>>>|<row|<cell|>|<cell|=max<rsub|<mv|f>\<ge\><mv|0>><around*|{|<big|sum><rsub|k\<in\>K>\<cdot\><around*|(|<mv|c><rsup|T>\<cdot\><matrixcol|\<Lambda\>|k>|)>+\<zeta\>\<cdot\><around*|(|1-<big|sum><rsub|k\<in\>K>f<rsub|k>|)>|}>>>>>>

      we have, that at optimality <math|\<zeta\>\<cdot\><around*|(|1-<big|sum><rsub|k\<in\>K>f<rsub|k>|)>>
      equals to zero. So, we get:

      <align*|<tformat|<table|<row|<cell|P<rsub|2><around|(|<mv|\<Lambda\>>,\<zeta\>|)>>|<cell|=max<rsub|<mv|1><rsup|T><mv|f>=1:<mv|f>\<ge\><mv|0>><around*|{|<big|sum><rsub|k\<in\>K>f<rsub|k>\<cdot\><around*|(|<mv|c><rsup|T>\<cdot\><matrixcol|\<Lambda\>|k>|)>|}>>>|<row|<cell|>|<cell|=max<rsub|k\<in\>K><around*|{|<mv|c><rsup|T>\<cdot\><matrixcol|\<Lambda\>|k>|}>>>|<row|<cell|>|<cell|=min
      <around*|{|<mv|z>:<mv|z>\<cdot\><mv|1><rsup|T>\<ge\><mv|c><rsup|T>\<cdot\><mv|\<Lambda\>>|}>.>>>>>

      That is, <math|P<rsub|2><around|(|<mv|\<Lambda\>>,\<zeta\>|)>>
      calculates the maximum cost among the pools. This, however, depends
      only on the optimal vector of resource prices <bvec|\<Lambda\>>.
    </proof>

    So, to prove the convergence of the above system , we can use the
    Lyapunov function

    <\equation*>
      V<around|(|<mm|\<Lambda\>><around|(|t|)>|)>=<frac|1|2>\<cdot\><around*|(|<mm|\<Lambda\>><around|(|t|)>-<bvec|\<Lambda\>>|)><rsup|T>\<cdot\><around*|(|<mm|\<Lambda\>><around|(|t|)>-<bvec|\<Lambda\>>|)>
    </equation*>

    and show that <math|<frac|d*V<around|(|<mv|\<Lambda\>><around|(|t|)>|)>|d*t>\<le\>0>.

    Indeed,

    <align*|<tformat|<table|<row|<cell|<frac|d*V<around|(|<mm|\<Lambda\>><around|(|t|)>|)>|d*t>>|<cell|=>>|<row|<cell|>|<cell|=<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><wide|\<Lambda\>|\<dot\>><around|(|t|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|max
    <around*|{|0,y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|}>\<cdot\><Ind|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>=0>|\<nobracket\>>>>|<row|<cell|>|<cell|<around*|\<nobracket\>|<space|5cm>+<around*|(|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|)>\<cdot\><Ind|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>\<gtr\>0>|]>>>|<row|<cell|>|<cell|\<leq\><big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|]><space|1em><text|(from
    <reference|inequality4>)>>>|<row|<cell|>|<cell|=<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-<wide|y|\<bar\>><rsub|\<ell\>,k>+<wide|y|\<bar\>><rsub|\<ell\>,k>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|]>>>|<row|<cell|>|<cell|\<leq\><big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-<wide|y|\<bar\>><rsub|\<ell\>,k>|]><space|1em><text|(from
    <reference|inequality5>)>>>|<row|<cell|>|<cell|=<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><big|sum><rsub|p\<in\>P>R<rsub|\<ell\>,p><around|(|k|)>\<cdot\><around*|[|x<rsub|p,k><around|(|t|)>-<wide|x|\<bar\>><rsub|p,k>|]>>>|<row|<cell|>|<cell|=<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><around*|[|x<rsub|p,k><around|(|t|)>-<wide|x|\<bar\>><rsub|p,k>|]>\<cdot\><around*|(|\<mu\><rsub|p,k><around|(|t|)>-<wide|\<mu\>|\<bar\>><rsub|p,k>|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><around*|[|x<rsub|p,k><around|(|t|)>-<wide|x|\<bar\>><rsub|p,k>|]>\<cdot\><around*|(|<frac|<wide|w|\<bar\>><rsub|p,k>|x<rsub|p,k><around|(|t|)>>-<frac|<wide|w|\<bar\>><rsub|p,k>|<wide|x|\<bar\>><rsub|p,k>>|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><wide|w|\<bar\>><rsub|p,k>\<cdot\><around*|[|2-<frac|x<rsub|p,k><around|(|t|)>|<wide|x|\<bar\>><rsub|p,k>>-<frac|<wide|x|\<bar\>><rsub|p,k>|x<rsub|p,k><around|(|t|)>>|]>>>|<row|<cell|>|<cell|\<leq\>0<space|1em><text|(from
    <reference|inequality6>)>>>>>>

    In the above, we have used the following inequalities:

    <\itemize>
      <item><label|inequality4> The following inequality holds:

      <align*|<tformat|<table|<row|<cell|>|<cell|<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|max
      <around*|{|0,y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|}>\<cdot\><Ind|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>=0>|\<nobracket\>>>>|<row|<cell|>|<cell|<around*|\<nobracket\>|<space|5cm>+<around*|(|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|)>\<cdot\><Ind|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>\<gtr\>0>|]>>>|<row|<cell|>|<cell|\<leq\><big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|]>>>|<row|<cell|>|<cell|>>>>>

      This is clearly true <math|\<forall\><around|(|\<ell\>,k|)>:\<Lambda\><rsub|\<ell\>,k><around|(|t|)>\<gtr\>0>,
      \<alpha\>\<lambda\>\<lambda\>\<#3AC\> \<kappa\>\<alpha\>\<iota\>
      <math|\<forall\><around|(|\<ell\>,k|)>:\<Lambda\><rsub|\<ell\>,k><around|(|t|)>=0>.
      The last part holds, because it will either be
      <math|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>\<ge\>0>
      (then it is obvious) or <math|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>\<less\>0>.
      In this case:

      <\equation*>
        <around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\>max
        <around*|{|0,y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|}>=-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>\<cdot\>0\<less\>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|]>.
      </equation*>

      <item><label|inequality5> The following inequality holds:

      <align*|<tformat|<table|<row|<cell|>|<cell|<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-<wide|y|\<bar\>><rsub|\<ell\>,k>+<wide|y|\<bar\>><rsub|\<ell\>,k>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|]>>>|<row|<cell|>|<cell|\<leq\><big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-<wide|y|\<bar\>><rsub|\<ell\>,k>|]>>>|<row|<cell|>|<cell|>>>>>

      The second inequality holds, because for the optimal matrix of resource
      prices <bvec|\<Lambda\>> (for given <bvec|w> and <bvec|f>) it holds,
      that

      <\equation*>
        <big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>*<around|(|<wide|y|\<bar\>><rsub|\<ell\>,k>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|)>=0
      </equation*>

      (due to equation<nbsp><eqref|eq:complementarity1-KKT-MSC-2>).

      <item><label|inequality6> The following inequality holds:

      <\equation*>
        <big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><wide|f|\<bar\>><rsub|k>*<wide|w|\<bar\>><rsub|p>\<cdot\><around*|[|2-<frac|x<rsub|p,k><around|(|t|)>|<wide|x|\<bar\>><rsub|p,k>>-<frac|<wide|x|\<bar\>><rsub|p,k>|x<rsub|p,k><around|(|t|)>>|]>\<leq\>0
      </equation*>

      The inequality holds, because <math|\<forall\>z\<gtr\>0,<space|0.27em>2-z-<frac|1|z>\<le\>0>
      and <math|<wide|f|\<bar\>><rsub|k>,\<forall\>k\<in\>K>,
      <math|<wide|w|\<bar\>><rsub|p>,\<forall\>p\<in\>P> are positive.
    </itemize>
  </REMOVED>

  <no-indent>The above lemma suggests the following mechanism.

  <\enumerate>
    <item>For every line pool <math|k\<in\>K>, solve an instance of the
    single-pool case, using the decentralized mechanism in <cite|BKZ2009>,
    obtaining the optimal solution <math|<around|(|<matrixcol|x|k>,<matrixcol|<vector|\<Lambda\>>|k>|)>>.

    <item>The NOP calculates the cost of each pool and sets the variable
    <math|\<zeta\><around|(|t|)>> to the average pool cost:

    <\equation*>
      \<zeta\><around|(|t|)>=<frac|1|<around|\||K|\|>>*<big|sum><rsub|k\<in\>K><mv|c><rsup|T>\<cdot\><matrixcol|\<Lambda\>|k><around|(|t|)>.
    </equation*>

    Then, he updates the capacity proportion vector <mv|f> and assigns a
    larger percentage of the total capacity to the most \Pexpensive\Q line
    pools, so that their cost decreases. This update is described by the
    following differential equations:

    <\equation>
      <label|eq:f>\<forall\>k\<in\>K,<space|0.27em><wide|f|\<dot\>><rsub|k><around|(|t|)>=max
      <around|{|0,<mv|c><rsup|T>\<cdot\><matrixcol|\<Lambda\>|k><around|(|t|)>-\<zeta\><around|(|t|)>|}>.
    </equation>

    Note that, at the end, the vector <mv|f> must be normalized, such that
    <math|<big|sum><rsub|k\<in\>K>f<rsub|k>=1> (the proportion vector must
    completely divide the infrastructure at all times). This is done by
    dividing each <math|f<rsub|k><around|(|t|)>> by
    <math|<big|sum><rsub|k\<in\>K>f<rsub|k><around|(|t|)>>.
  </enumerate>

  Roughly speaking, the convergence of the above mechanism for a specific
  capacity proportion vector <mv|f> is guaranteed by the convergence of the
  single-pool algorithm. Nevertheless, for the sake of completeness, we
  present the convergence proof in the Appendix
  (Lemma<nbsp><reference|lm:convergence>). When the <math|<around|\||K|\|>>
  single-pool instances are solved, the NOP updates the vector <mv|f>, so
  that the expensive pools get cheaper. The goal is that all pools should
  have the same cost. When this happens, we know for the optimal solution of
  both MNET-II and MSC-II <math|<around|(|<bvec|x>,<bvec|f>|)>> and the
  accompanying Lagrange multipliers, <math|<around|(|<bvec|\<Lambda\>>,<wide|\<zeta\>|\<bar\>>|)>>,
  that:

  <\itemize>
    <item>Equations <eqref|eq:selfish-KKT-MNET-2> and
    <eqref|eq:selfish-KKT-MSC-2> will match due to the fact that each LOP
    solves the <eqref|eq:muser-II> problem.

    <item>Equations <eqref|eq:zeta-KKT-MNET-2> (and
    <eqref|eq:zeta-KKT-MSC-2>) will be satisfied due to the updates to vector
    <mv|f> that take place at the end of each phase.

    <item>Equations <eqref|eq:complementarity1-KKT-MNET-2> (and
    <eqref|eq:complementarity1-KKT-MSC-2>) will be satisfied due to the
    resource price updating scheme chosen.

    <item>Equations <eqref|eq:complementarity2-KKT-MNET-2> (and
    <eqref|eq:complementarity2-KKT-MSC-2>) will be satisfied, because the NOP
    assures that at the end of each phase.
  </itemize>

  Hence, <math|<around|(|<bvec|x>,<bvec|f>|)>> is the optimal solution of
  both (KKT-MSC-II) and <eqref|eq:MNET-II>, and thus the proposed mechanism
  solves <eqref|eq:MSC-diffU>. The next theorem summarizes the preceding
  discussion.

  <\theorem>
    The above dynamic scheme of resource pricing, LOPs' bid updating and
    capacity proportion updating assures the monotonic convergence of the
    <eqref|eq:MNET-II> problem to the optimal solution. The algorithm may
    start from any initial state of resource prices, LOPs' bids and capacity
    proportion vector.
  </theorem>

  <section|Experimental Study of the Multiple-Line Pool
  Cases><label|sec:exp-mlp>

  In this section we present the experimental results for the multiple-line
  pool case where the LOPs have different utility functions per pool. We have
  implemented a discrete version of the decentralized mechanism, whose
  pseudocode is as follows. \ <algo-state|<math|f<rsub|k><around|(|0|)>=<frac|1|<around|\||K|\|>>>;>

  <algo-state|<math|t=t+1>;>

  <\algo-for|*|<math|k\<in\>K>>
    <algo-state|Solve an instance of the single-pool case for each line pool
    <math|k>;>
  </algo-for>

  <algo-state|<math|<math-up|cost><rsub|k><around|(|t|)>=<mv|c><rsup|T>\<cdot\><matrixcol|\<Lambda\>|k><around|(|t|)>>;>

  <algo-state|<math|\<zeta\>=<frac|<big|sum><rsub|k\<in\>K><math-up|cost><rsub|k>|<around|\||K|\|>>>;>

  <\algo-for|*|<math|k\<in\>K>>
    <algo-state|<math|<wide|f|\<dot\>><rsub|k><around|(|t|)>=<frac|max
    <around|{|0,<math-up|cost><rsub|k><around|(|t|)>-\<zeta\><around|(|t|)>|}>|\<zeta\><around|(|t|)>>>;>

    <algo-state|<math|f<rsub|k><around|(|t|)>=f<rsub|k>*<around|(|t-1|)>+0.1\<cdot\><wide|f|\<dot\>><rsub|k><around|(|t|)>>;>
  </algo-for>

  <algo-state|<math|<with|math-font-family|rm|total_f>=<big|sum><rsub|k\<in\>K>f<rsub|k><around|(|t|)>>;>

  <\algo-for|*|<math|k\<in\>K>>
    <algo-state|<math|f<rsub|k><around|(|t|)>=<frac|f<rsub|k><around|(|t|)>|<with|math-font-family|rm|total_f>>;<space|2em>>>
  </algo-for>

  \ The algorithm was implemented in C++ using the GNU g++ compiler (version
  4.4) with the second optimization level (-O2 switch) on. Experiments were
  performed on synthetic and real-world data.

  Synthetic data consisted of grid graphs having a number of 7 nodes on the
  vertical axis and a number of nodes in <math|<around|[|120,360|]>> along
  the horizontal axis; i.e., the size of the grid graphs varied from
  <math|7\<times\>120> to <math|7\<times\>360>. The capacity of each edge was
  randomly chosen from <math|<around|[|10,110|)>>. Four line pools were
  defined. In each pool, there were three LOPs, each one interested in a
  different line. Those lines had the first edge
  <math|<around|(|<around|(|0,3|)>,<around|(|1,3|)>|)>> in common. The next
  edges of each line were randomly chosen each time.

  Real-world data concern parts of the German railway network (mainly
  intercity train connections), denoted as R1 (280 nodes and 354 edges) and
  R2 (296 nodes and 393 edges). The capacities of the edges were in
  <math|<around|[|8,16|]>>. The total number of lines varies from 100 up to
  1000, depending on the size of the networks. For each network, we defined
  four line pools. The second, third and fourth pool differed from the first
  in about 10% of the lines (the new lines in each pool were randomly
  selected from the available lines in each network).

  In the experiments we measured the number of iterations needed to find the
  correct vector <mv|f> of capacity proportions (we did not concentrate on
  the solutions of the single-pool case, used as a subroutine, since this
  case was investigated in <cite|BKZ2009>).

  <\REMOVED>
    We started by assuming that the utility function for every LOP in each
    pool is given by <math|U<rsub|p,k><around|(|x<rsub|p,k>|)>=100\<cdot\><sqrt|x<rsub|p,k>>>.

    <\big-table>
      \ <subfloat|<with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|t>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|6|6|1|-1|cell-bborder|1ln>|<table|<row|<cell|<math|p>>|<cell|<nbsp><nbsp>No.<nbsp>of
      updates of <mv|f>>>|<row|<cell|120>|<cell|70>>|<row|<cell|180>|<cell|21>>|<row|<cell|240>|<cell|36>>|<row|<cell|300>|<cell|83>>|<row|<cell|360>|<cell|64>>>>>
      >>

      <\subfloat>
        \ 
      </subfloat>

      \ <subfloat|<with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|t>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|4|4|1|-1|cell-bborder|1ln>|<table|<row|<cell|Number
      of lines<nbsp>>|<cell|<nbsp>No.<nbsp>of updates of
      <mv|f>>>|<row|<cell|100>|<cell|17>>|<row|<cell|200>|<cell|26>>|<row|<cell|300>|<cell|13>>>>>
      >><label|tab:mp-grid-R1>\ 
    </big-table|Number of updates of <mv|f> for grid graphs of size
    <math|7\<times\>p> (left) and for R1 (right).>

    <\big-table>
      \ <subfloat|<with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|t>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|6|6|1|-1|cell-bborder|1ln>|<table|<row|<cell|Number
      of lines<nbsp>>|<cell|<nbsp>No.<nbsp>of updates of
      <mv|f>>>|<row|<cell|100>|<cell|18>>|<row|<cell|200>|<cell|33>>|<row|<cell|300>|<cell|6>>|<row|<cell|400>|<cell|13>>|<row|<cell|500>|<cell|1>>>>>
      >>

      <\subfloat>
        \ 
      </subfloat>

      \ <subfloat|<with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|t>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|11|11|1|-1|cell-bborder|1ln>|<table|<row|<cell|Number
      of lines<nbsp>>|<cell|<nbsp>No.<nbsp>of updates of
      <mv|f>>>|<row|<cell|100>|<cell|33>>|<row|<cell|200>|<cell|24>>|<row|<cell|300>|<cell|21>>|<row|<cell|400>|<cell|8>>|<row|<cell|500>|<cell|12>>|<row|<cell|600>|<cell|15>>|<row|<cell|700>|<cell|1>>|<row|<cell|800>|<cell|7>>|<row|<cell|900>|<cell|1>>|<row|<cell|1000>|<cell|1>>>>>
      >><label|tab:mp-710-gross>\ 
    </big-table|Number of updates of <mv|f> for R2 (left) and R3 (right).>

    \ The results for synthetic and real-world data are presented in
    Tables<nbsp><reference|tab:mp-grid-R1> and <reference|tab:mp-710-gross>.
    We observe a small number of necessary updates to the capacity proportion
    vector <mv|f>, until the system reaches the optimum. The most important
    reason for this is the use of the same utility function for every pool by
    the LOPs, because the algorithm starts with the initial values
    <math|f<rsub|k>=<frac|1|<around|\||K|\|>>> and the optimal values in this
    case are quite close to these initial values.

    Consequently, the next step is to use different utility functions (being
    also our initial goal) in each pool for each LOP.
  </REMOVED>

  \ We investigated the following four scenarios:

  <\enumerate>
    <item*|S1><math|U<rsub|p,1><around|(|x<rsub|p,1>|)>=10<rsup|4>*<sqrt|x<rsub|p,1>>*<text|and
    >U<rsub|p,2><around|(|x<rsub|p,2>|)>=10<rsup|4>*<sqrt|x<rsub|p,2>>,<space|0.27em>\<forall\>p\<in\>P>.

    <item*|S2><math|U<rsub|p,1><around|(|x<rsub|p,1>|)>=<frac|3|4>\<cdot\>10<rsup|4>\<cdot\><sqrt|x<rsub|p,1>>*<text|and
    >U<rsub|p,2><around|(|x<rsub|p,2>|)>=<frac|4|5>\<cdot\>10<rsup|4>\<cdot\><sqrt|x<rsub|p,2>>,<space|0.27em>\<forall\>p\<in\>P>.

    <item*|S3><math|U<rsub|p,1><around|(|x<rsub|p,1>|)>=10<rsup|4>\<cdot\><sqrt|x<rsub|p,1>>*<text|and
    >U<rsub|p,2><around|(|x<rsub|p,2>|)>=<frac|1|2>\<cdot\>10<rsup|4>\<cdot\><sqrt|x<rsub|p,2>>,<space|0.27em>\<forall\>p\<in\>P>.

    <item*|S4><math|U<rsub|p,1><around|(|x<rsub|p,1>|)>=10<rsup|4>\<cdot\><sqrt|x<rsub|p,1>>*<text|and
    >U<rsub|p,2><around|(|x<rsub|p,2>|)>=<frac|1|4>\<cdot\>10<rsup|4>\<cdot\><sqrt|x<rsub|p,2>>,<space|0.27em>\<forall\>p\<in\>P>.
  </enumerate>

  We report on experiments with the R1 network and two line pools for all
  four scenarios, and on R2 for scenarios S1 and S2 (similar results hold for
  the other scenarios). Table<nbsp><reference|tab:mp-dw> shows the results
  for 100, 200 and 300 lines per pool for R1, and for 100 to 500 lines per
  pool for R2.

  <big-table|<\with|par-mode|center>
    <subfloat|<with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|4|4|cell-halign|c>|<cwith|1|-1|5|5|cell-halign|c>|<cwith|1|-1|5|5|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|t>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|4|4|1|-1|cell-bborder|1ln>|<table|<row|<cell|Number
    of lines<nbsp><nbsp>>|<cell|S1>|<cell|S2>|<cell|S3>|<cell|S4>>|<row|<cell|100>|<cell|9>|<cell|33>|<cell|127>|<cell|178>>|<row|<cell|200>|<cell|12>|<cell|33>|<cell|127>|<cell|178>>|<row|<cell|300>|<cell|19>|<cell|29>|<cell|128>|<cell|178>>>>>
    >>

    <\subfloat>
      \ 
    </subfloat>

    \ <subfloat|<with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|t>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|6|6|1|-1|cell-bborder|1ln>|<table|<row|<cell|Number
    of lines<nbsp><nbsp>>|<cell|S1>|<cell|S2>>|<row|<cell|100>|<cell|33>|<cell|52>>|<row|<cell|200>|<cell|26>|<cell|49>>|<row|<cell|300>|<cell|1>|<cell|40>>|<row|<cell|400>|<cell|6>|<cell|34>>|<row|<cell|500>|<cell|1>|<cell|37>>>>>
    >><label|tab:mp-dw>
  </with>|Number of updates of <mv|f> for different utility functions and
  number of lines per pool (<math|<around|\||K|\|>=2>) for R1 (left) and R2
  (right).>

  For S1 (same utility functions), we observe a small number of necessary
  updates to the capacity proportion vector <mv|f>, until the system reaches
  the optimum. The main reason for this is the use of the same utility
  function for every pool by the LOPs, because the algorithm starts with the
  initial values <math|f<rsub|k>=<frac|1|<around|\||K|\|>>> and the optimal
  values in this case are quite close to these initial values. For the other
  scenarios with different utility functions per pool (S2, S3, S4), we
  observe a larger number of the updates required. We also observe that the
  more different the utility functions of each LOP in the two pools are, the
  larger the number of updates required to reach the optimum.

  Another interesting observation in the case of the different utility
  functions per line pool, is that the number of updates of <mv|f> is almost
  equal. This is due to the fact that the difference in utility functions
  across line pools has a more significant effect on the required number of
  updates than the difference in lines among the pools (in other words, more
  steps are required to reach the optimal values due to the different utility
  functions than due to the different costs of the line pools).

  In conclusion, the number of updates required by our mechanism to converge
  (to the optimal values of vector <mv|f>) depends largely on the exact
  parameters of the system of differential
  equations<nbsp><eqref|eq:f<rsub|u>pdate-2>.

  <section|Experimental Study of Disruptions in the
  Network><label|sec:disruptions>

  We turn now to a different experimental study. We assume that the network
  is currently operating at optimality and that a few disruptions occur.
  These disruptions affect the capacity of some edges. This can be due to
  technical problems leading to reducing the capacity of those edges, or to
  increasing their capacity for a particular period to handle increased
  traffic demand (e.g., during holidays, or rush hours) by \Preleasing" more
  infrastructure.

  We examine the behavior of the algorithms for the single and multiple pool
  cases in such situations. We investigated three disruption scenarios:

  <\enumerate>
    <item*|D1>Reducing the capacity of a certain number of edges (chosen
    among the congested ones).

    <item*|D2>Increasing the capacity of a certain number of edges (chosen
    among the congested ones).

    <item*|D3>Reducing the capacity of a certain number of edges, while
    increasing the capacity of an equal number of a different set of edges
    (chosen among the congested ones).
  </enumerate>

  We start from a known optimal solution to the problem. Then, we add
  disruptions to a few edges and apply the algorithm. The relative and
  absolute error for the differential equations were set to <math|0.1>.

  These scenarios were tested on grid graphs and on the R1 network (similar
  results hold for R2). For the grid graphs, the lines were chosen randomly,
  but all of them shared the same first edge. The number of lines in each
  pool were 10 and the capacities of the edges were chosen randomly in
  <math|<around|[|4,20|]>>.

  <subsection|Single pool case><label|sec:sp>

  For this case, we chose randomly, among the congested ones, 4 edges in the
  case of grid graphs and 10 edges in the case of R1. Their capacity was
  reduced (or increased) by 10% and 50%. In the experiments we measured the
  number of updates required for finding the optimal values of
  <math|<mv|\<Lambda\>>> (resource prices per-unit-of-frequency).

  The number of iterations required for finding the optimal values of
  <math|<mv|\<Lambda\>>> for grid graphs and R1, when we start from a
  previous optimal solution, is presented in Tables <reference|tab:sp> and
  <reference|tab:sp>. For comparison, the number of the required updates of
  <math|<mv|\<Lambda\>>> when we start from a random initial state is given
  in Tables <reference|tab:sp> and <reference|tab:sp>. We observe the
  significantly less number of updates required when we start from a previous
  optimal solution. This is due to the fact that the disruptions caused are
  not very big, and hence the new optimal solution is quite close to the
  previous one. There are, however, one or two exceptions; i.e., we observe
  in these cases a smaller number of updates when we start from a random
  initial solution. This happens, because the algorithms for solving
  differential equations are arithmetic methods that depend greatly on the
  exact parameters given. This results in a few pathological cases such as
  these. One can conclude, though, that in general the use of the previous
  optimal solution leads to a smaller number of required updates for
  <mv|\<Lambda\>>.

  <subsection|Multiple pool Case><label|sec:mp>

  We created two pools for these experiments. In the case of grid graphs, the
  lines in each pool were chosen randomly, and in the case of R1 there was a
  10% difference in the lines between the two pools. In these experiments we
  measured the number of updates of the bids of the LOPs (bid vector <mv|w>).
  In none case there was a need to update the capacity proportion vector
  <mv|f>.

  The results are shown in Tables <reference|tab:mp> and <reference|tab:mp>.
  One can see that only rarely there is a need to update the bid vector
  <mv|w>. Especially for the R1 network, we had to introduce disruptions of
  90% of the original capacity to get the bid vector to be updated. Hence,
  the algorithm reaches the optimal solution quite fast. The important
  observation is that, starting from the previous optimal solution, we avoid
  the update of the capacity proportion vector <mv|f>, which is the most
  expensive operation.

  <section|Conclusions><label|sec:conclusions>

  We have studied a variant of the robust multiple-pool line planning problem
  defined in <cite|BKZ2009>, where the LOPs have different utility functions
  per pool. We have shown that a dynamic, decentralized mechanism exists for
  this problem that eventually converges to the optimal solution.

  We have also studied the above mechanism experimentally, showing that the
  exact behavior of the algorithm greatly depends on the exact input
  parameters; however, the convergence is in general quite fast.

  Moreover, we studied the case that disruptions take place in the network.
  We have seen that in most cases it is much better to take advantage of the
  previous (optimal) solution to bootstrap the algorithm.

  <big-table|<with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|r>|<cwith|1|-1|4|4|cell-halign|r>|<cwith|1|-1|5|5|cell-halign|r>|<cwith|1|-1|5|5|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|1|cell-row-span|5>|<cwith|2|2|1|1|cell-valign|c>|<cwith|6|6|1|-1|cell-bborder|1ln>|<cwith|7|7|1|1|cell-row-span|5>|<cwith|7|7|1|1|cell-valign|c>|<cwith|11|11|1|-1|cell-bborder|1ln>|<table|<row|<cell|Disruption<nbsp>>|<cell|<nbsp><nbsp><math|p><nbsp><nbsp>>|<cell|D1>|<cell|D2>|<cell|D3>>|<row|<cell|10%>|<cell|120>|<cell|1292>|<cell|340>|<cell|9983>>|<row|<cell|>|<cell|180>|<cell|1235>|<cell|395>|<cell|550>>|<row|<cell|>|<cell|240>|<cell|317>|<cell|453>|<cell|407>>|<row|<cell|>|<cell|300>|<cell|4005>|<cell|556>|<cell|1337>>|<row|<cell|>|<cell|360>|<cell|163>|<cell|8484>|<cell|542>>|<row|<cell|50%>|<cell|120>|<cell|403>|<cell|480>|<cell|1022>>|<row|<cell|>|<cell|180>|<cell|248>|<cell|1116>|<cell|875>>|<row|<cell|>|<cell|240>|<cell|409>|<cell|498>|<cell|533>>|<row|<cell|>|<cell|300>|<cell|3966>|<cell|1284>|<cell|1180>>|<row|<cell|>|<cell|360>|<cell|751>|<cell|658>|<cell|712>>>>><label|tab:sp>>|Required
  number of updates of <mv|\<Lambda\>> for grid graphs with sizes
  <math|7\<times\>p>, when the algorithm starts from a previous optimal
  state, until the system reaches the equilibrium point after the disruptions
  under scenarios D1, D2, and D3.>

  <big-table|<with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|r>|<cwith|1|-1|4|4|cell-halign|r>|<cwith|1|-1|5|5|cell-halign|r>|<cwith|1|-1|5|5|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|1|cell-row-span|3>|<cwith|2|2|1|1|cell-valign|c>|<cwith|4|4|1|-1|cell-bborder|1ln>|<cwith|5|5|1|1|cell-row-span|3>|<cwith|5|5|1|1|cell-valign|c>|<cwith|7|7|1|-1|cell-bborder|1ln>|<table|<row|<cell|Disruption<nbsp>>|<cell|<nbsp>Number
  of lines<nbsp><nbsp>>|<cell|D1>|<cell|D2>|<cell|D3>>|<row|<cell|10%>|<cell|100>|<cell|10335>|<cell|90085>|<cell|464>>|<row|<cell|>|<cell|200>|<cell|32466>|<cell|2806>|<cell|5033>>|<row|<cell|>|<cell|300>|<cell|4171>|<cell|276>|<cell|5208>>|<row|<cell|50%>|<cell|100>|<cell|8409>|<cell|1057>|<cell|1506>>|<row|<cell|>|<cell|200>|<cell|1042>|<cell|1109>|<cell|4314>>|<row|<cell|>|<cell|300>|<cell|5430>|<cell|974>|<cell|1058>>>>><label|tab:sp>>|Required
  number of updates of <mv|\<Lambda\>> for R1, when the algorithm starts from
  a previous optimal state, until the system reaches the equilibrium point
  after the disruptions under scenarios D1, D2, and D3.>

  <big-table|<with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|r>|<cwith|1|-1|3|3|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|b>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|1|cell-row-span|5>|<cwith|2|2|1|1|cell-valign|c>|<cwith|6|6|1|-1|cell-bborder|1ln>|<cwith|7|7|1|1|cell-row-span|5>|<cwith|7|7|1|1|cell-valign|c>|<cwith|11|11|1|-1|cell-bborder|1ln>|<table|<row|<cell|Case
  of Disruption<nbsp>>|<cell|<nbsp><nbsp><math|p><nbsp><nbsp>>|<cell|<nbsp>Number
  of Updates of <mv|\<Lambda\>>>>|<row|<cell|10%>|<cell|120>|<cell|6701>>|<row|<cell|>|<cell|180>|<cell|6643>>|<row|<cell|>|<cell|240>|<cell|7835>>|<row|<cell|>|<cell|300>|<cell|6813>>|<row|<cell|>|<cell|360>|<cell|5854>>|<row|<cell|50%>|<cell|120>|<cell|7381>>|<row|<cell|>|<cell|180>|<cell|7246>>|<row|<cell|>|<cell|240>|<cell|6468>>|<row|<cell|>|<cell|300>|<cell|6197>>|<row|<cell|>|<cell|360>|<cell|7617>>>>><label|tab:sp>>|Number
  of updates of <mv|\<Lambda\>> for grid graphs of size <math|7\<times\>p>,
  when the algorithm starts from a random initial state.>

  <big-table|<with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|b>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|4|4|1|-1|cell-bborder|1ln>|<table|<row|<cell|Number
  of lines<nbsp>>|<cell|<nbsp>Number of updates of
  <mv|\<Lambda\>>>>|<row|<cell|100>|<cell|12393>>|<row|<cell|200>|<cell|6641>>|<row|<cell|300>|<cell|7817>>>>><label|tab:sp>>|Number
  of updates of <mv|\<Lambda\>> for R1, when the algorithm starts from a
  random initial state.>

  <big-table|<with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|r>|<cwith|1|-1|4|4|cell-halign|r>|<cwith|1|-1|5|5|cell-halign|r>|<cwith|1|-1|5|5|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|1|cell-row-span|5>|<cwith|2|2|1|1|cell-valign|c>|<cwith|6|6|1|-1|cell-bborder|1ln>|<cwith|7|7|1|1|cell-row-span|5>|<cwith|7|7|1|1|cell-valign|c>|<cwith|11|11|1|-1|cell-bborder|1ln>|<table|<row|<cell|Disruptions<nbsp>>|<cell|<nbsp><nbsp><math|p><nbsp><nbsp>>|<cell|D1>|<cell|D2>|<cell|D3>>|<row|<cell|10%>|<cell|120>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|>|<cell|180>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|>|<cell|240>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|>|<cell|300>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|>|<cell|360>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|50%>|<cell|120>|<cell|0>|<cell|2>|<cell|1>>|<row|<cell|>|<cell|180>|<cell|0>|<cell|2>|<cell|0>>|<row|<cell|>|<cell|240>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|>|<cell|300>|<cell|0>|<cell|1>|<cell|2>>|<row|<cell|>|<cell|360>|<cell|0>|<cell|2>|<cell|2>>>>><label|tab:mp>>|Required
  number of updates of <mv|w> for grid graphs of sizes <math|7\<times\>p> for
  scenarios D1, D2, D3, when the algorithm starts from a previous optimal
  state, so that the system returns to an equilibrium point after a
  disruption.>

  <big-table|<with|par-mode|center|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|r>|<cwith|1|-1|4|4|cell-halign|r>|<cwith|1|-1|5|5|cell-halign|r>|<cwith|1|-1|5|5|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|2|2|1|1|cell-row-span|3>|<cwith|2|2|1|1|cell-valign|c>|<cwith|4|4|1|-1|cell-bborder|1ln>|<cwith|5|5|1|1|cell-row-span|3>|<cwith|5|5|1|1|cell-valign|c>|<cwith|7|7|1|-1|cell-bborder|1ln>|<cwith|8|8|1|1|cell-row-span|3>|<cwith|8|8|1|1|cell-valign|c>|<cwith|10|10|1|-1|cell-bborder|1ln>|<table|<row|<cell|Disruption<nbsp>>|<cell|<nbsp>Number
  of lines<nbsp>>|<cell|D1>|<cell|D2>|<cell|D3>>|<row|<cell|10%>|<cell|100>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|>|<cell|200>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|>|<cell|300>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|50%>|<cell|100>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|>|<cell|200>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|>|<cell|300>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|90%>|<cell|100>|<cell|0>|<cell|3>|<cell|0>>|<row|<cell|>|<cell|200>|<cell|0>|<cell|2>|<cell|2>>|<row|<cell|>|<cell|300>|<cell|0>|<cell|0>|<cell|0>>>>><label|tab:mp>>|Required
  number of updates of <mv|w> for R1 for scenarios D1, D2, D3, when the
  algorithm starts from a previous optimal state, so that the system returns
  to an equilibrium point after a disruption.>

  <\thebibliography|99>
    <bibitem|BKZ2009>A.<nbsp>Bessas, S.<nbsp>Kontogiannis, and
    C.<nbsp>Zaroliagis, \PIncentive-Compatible Robust Line Planning\Q, In
    <em|Robust and Online Large-Scale Optimization>, Chapter 4, Springer
    2009, pp. 85-118.

    <bibitem|D78>H.<nbsp>Dienst, \PLinienplanung im spurgefhrten
    Personenverkehr mit Hilfe eines heuristischen Verfahrens\Q, PhD thesis,
    Technische Universitt Braunschweig, 1978.

    <bibitem|GHK2004>J.<nbsp>Goossens, C.<nbsp>van Hoesel, and L.<nbsp>Kroon,
    \PA branch and cut approach for solving line planning problems",
    <em|Transportation Science> 38<nbsp>(2004), pp.<nbsp>379393.

    <bibitem|K97>F.<nbsp>Kelly, \PCharging and rate control for elastic
    traffic\Q, <em|European Transactions on Telecommunications>,
    8<nbsp>(1997), pp.<nbsp>33-37.

    <bibitem|KMT98>F.<nbsp>Kelly, A.<nbsp>Maulloo, and D.<nbsp>Tan, \PRate
    control in communication networks: shadow prices, proportional fairness
    and stability\Q, <em|Journal of the Operational Research Society>,
    49<nbsp>(1998), pp.<nbsp>237-252.

    <bibitem|SS2005>A.<nbsp>Schbel and S.<nbsp>Scholl, \PLine Planning with
    Minimal Traveling Time", In <em|Proc.<nbsp>5th Workshop on Algorithmic
    Methods and Models for Optimization of Railways> \U ATMOS 2005.

    <bibitem|SS2006>A.<nbsp>Schbel and S.<nbsp>Schwarze, \PA Game-Theoretic
    Approach to Line Planning\Q, in <em|Proc.<nbsp>6th Workshop on
    Algorithmic Methods and Models for Optimization of Railways> \U ATMOS
    2006.

    <bibitem|S2005>S.<nbsp>Scholl, \PCustomer-oriented line planning", PhD
    thesis, Technische Universitt Kaiserslautern, 2005.
  </thebibliography>

  <section*|APPENDIX>

  <REMOVED|>

  <subsection*|A.1 Pseudocode of Algorithm>

  The pseudocode of the discrete version of our decentralized mechanism is as
  follows:

  \ <algo-state|<math|f<rsub|k><around|(|0|)>=<frac|1|<around|\||K|\|>>>;>

  <algo-state|<math|t=t+1>;>

  <\algo-for|*|<math|k\<in\>K>>
    <algo-state|Solve an instance of the single-pool case for each line pool
    <math|k>;>
  </algo-for>

  <algo-state|<math|<math-up|cost><rsub|k><around|(|t|)>=<mv|c><rsup|T>\<cdot\><matrixcol|\<Lambda\>|k><around|(|t|)>>;>

  <algo-state|<math|\<zeta\>=<frac|<big|sum><rsub|k\<in\>K><math-up|cost><rsub|k>|<around|\||K|\|>>>;>

  <\algo-for|*|<math|k\<in\>K>>
    <algo-state|<math|<wide|f|\<dot\>><rsub|k><around|(|t|)>=<frac|max
    <around|{|0,<math-up|cost><rsub|k><around|(|t|)>-\<zeta\><around|(|t|)>|}>|\<zeta\><around|(|t|)>>>;>

    <algo-state|<math|f<rsub|k><around|(|t|)>=f<rsub|k>*<around|(|t-1|)>+0.1\<cdot\><wide|f|\<dot\>><rsub|k><around|(|t|)>>;>
  </algo-for>

  <algo-state|<math|<with|math-font-family|rm|total_f>=<big|sum><rsub|k\<in\>K>f<rsub|k><around|(|t|)>>;>

  <\algo-for|*|<math|k\<in\>K>>
    <algo-state|<math|f<rsub|k><around|(|t|)>=<frac|f<rsub|k><around|(|t|)>|<with|math-font-family|rm|total_f>>;<space|2em>>>
  </algo-for>

  <subsection*|A.2 Omitted Proofs>

  }

  <with|font-series|bold|Proof of Lemma<nbsp><reference|lm:main>>

  <\proof>
    The Lagrangian function of the problem is:

    <\equation*>
      L<around|(|<mv|x>,<mv|f>,<mv|\<Lambda\>>,\<zeta\>|)>=<next-line><big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><around*|[|U<rsub|p,k><around|(|x<rsub|p,k>|)>-x<rsub|p,k>\<cdot\>\<mu\><rsub|p,k><around|(|<mv|\<Lambda\>>|)>|]>+<big|sum><rsub|k\<in\>K>f<rsub|k>\<cdot\><around*|[|<mv|c><rsup|T><matrixcol|\<Lambda\>|k>-\<zeta\>|]>+\<zeta\>.
    </equation*>

    The dual problem of <eqref|eq:MSC-diffU> is the following:

    <\equation*>
      <aligned|<tformat|<table|<row|<cell|max<space|1em>>|<cell|D<around|(|<mv|\<Lambda\>>,\<zeta\>|)>>>|<row|<cell|s.*t.<space|1em>>|<cell|\<Lambda\><rsub|\<ell\>,k>\<ge\>0<space|1em>\<forall\>\<ell\>\<in\>L,<space|0.17em>\<forall\>k\<in\>K>>|<row|<cell|>|<cell|\<zeta\>\<ge\>0,>>>>>
    </equation*>

    where

    <align*|<tformat|<table|<row|<cell|>|<cell|D<around|(|<mv|\<Lambda\>>,\<zeta\>|)>=>>|<row|<cell|>|<cell|=max
    <around*|{|L<around|(|<mv|x>,<mv|f>,<mv|\<Lambda\>>,\<zeta\>|)>:<mv|x>,<mv|f>\<ge\><mv|0>|}>>>|<row|<cell|>|<cell|=max<rsub|<mv|x>,<mv|f>\<ge\><mv|0>><around*|{|<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><around*|[|U<rsub|p,k><around|(|x<rsub|p,k>|)>-x<rsub|p,k>*<big|sum><rsub|l\<in\>L>\<Lambda\><rsub|\<ell\>,k>*R<rsub|\<ell\>,p><around|(|k|)>|]>+<big|sum><rsub|k\<in\>K>f<rsub|k>*<around*|[|<big|sum><rsub|\<ell\>\<in\>L>\<Lambda\><rsub|\<ell\>,k>*c<rsub|\<ell\>>-\<zeta\>|]>+\<zeta\>|}>>>|<row|<cell|>|<cell|=max<rsub|<mv|x>\<ge\><mv|0>><around*|{|<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><around*|[|U<rsub|p><around|(|x<rsub|p>|)>-x<rsub|p,k>*\<mu\><rsub|p,k><around|(|<mv|\<Lambda\>>|)>|]>|}>+max<rsub|<mv|f>\<ge\><mv|0>><around*|{|<big|sum><rsub|k\<in\>K>f<rsub|k>*<around*|[|<big|sum><rsub|\<ell\>\<in\>L>\<Lambda\><rsub|\<ell\>,k>*c<rsub|\<ell\>>-\<zeta\>|]>|}>+\<zeta\>.>>>>>

    For the part

    <\equation*>
      P<rsub|1><around|(|<mv|\<Lambda\>>|)>=max<rsub|<mv|x>\<ge\><mv|0>><around*|{|<big|sum><rsub|p\<in\>P><around*|[|U<rsub|p><around|(|x<rsub|p>|)>-<big|sum><rsub|k\<in\>K>x<rsub|p,k>\<cdot\>\<mu\><rsub|p,k><around|(|<mv|\<Lambda\>>|)>|]>|}>
    </equation*>

    we have, that it is a simple maximization problem the solution of which
    depends exclusively on the optimal vector of resource prices
    <bvec|\<Lambda\>>.

    For the part

    <align*|<tformat|<table|<row|<cell|P<rsub|2><around|(|<mv|\<Lambda\>>,\<zeta\>|)>>|<cell|=max<rsub|<mv|f>\<ge\><mv|0>><around*|{|<big|sum><rsub|k\<in\>K>f<rsub|k>\<cdot\><around*|[|<big|sum><rsub|\<ell\>\<in\>L>\<Lambda\><rsub|\<ell\>,k>\<cdot\>c<rsub|\<ell\>>-\<zeta\>|]>|}>+\<zeta\>>>|<row|<cell|>|<cell|=max<rsub|<mv|f>\<ge\><mv|0>><around*|{|<big|sum><rsub|k\<in\>K>\<cdot\><around*|(|<mv|c><rsup|T>\<cdot\><matrixcol|\<Lambda\>|k>|)>+\<zeta\>\<cdot\><around*|(|1-<big|sum><rsub|k\<in\>K>f<rsub|k>|)>|}>>>>>>

    we have, that at optimality <math|\<zeta\>\<cdot\><around*|(|1-<big|sum><rsub|k\<in\>K>f<rsub|k>|)>>
    equals to zero. So, we get:

    <align*|<tformat|<table|<row|<cell|P<rsub|2><around|(|<mv|\<Lambda\>>,\<zeta\>|)>>|<cell|=max<rsub|<mv|1><rsup|T><mv|f>=1:<mv|f>\<ge\><mv|0>><around*|{|<big|sum><rsub|k\<in\>K>f<rsub|k>\<cdot\><around*|(|<mv|c><rsup|T>\<cdot\><matrixcol|\<Lambda\>|k>|)>|}>>>|<row|<cell|>|<cell|=max<rsub|k\<in\>K><around*|{|<mv|c><rsup|T>\<cdot\><matrixcol|\<Lambda\>|k>|}>>>|<row|<cell|>|<cell|=min
    <around*|{|<mv|z>:<mv|z>\<cdot\><mv|1><rsup|T>\<ge\><mv|c><rsup|T>\<cdot\><mv|\<Lambda\>>|}>.>>>>>

    That is, <math|P<rsub|2><around|(|<mv|\<Lambda\>>,\<zeta\>|)>> calculates
    the maximum cost among the pools. This, however, depends only on the
    optimal vector of resource prices <bvec|\<Lambda\>>. <math|\<Box\>>
  </proof>

  The convergence of our decentralized mechanism is shown by the next lemma.

  <\lemma>
    <label|lm:convergence>For any choice of <em|fixed> bid vector
    <math|<bvec|w>=<around|(|w<rsub|p>|)><rsub|p\<in\>P>> offered by the
    LOPs, and any <em|fixed> vector of proportions
    <math|<bvec|f>=<around|(|f<rsub|k>|)><rsub|k\<in\>K>> determined by the
    NOP, the resource price updating scheme makes the resource prices
    converge to the corresponding optimal vector <math|<bvec|<La>>> (for
    these particular given bids and proportions).
  </lemma>

  <\proof>
    We use the Lyapunov function

    <\equation*>
      V<around|(|<mm|\<Lambda\>><around|(|t|)>|)>=<frac|1|2>\<cdot\><around*|(|<mm|\<Lambda\>><around|(|t|)>-<bvec|\<Lambda\>>|)><rsup|T>\<cdot\><around*|(|<mm|\<Lambda\>><around|(|t|)>-<bvec|\<Lambda\>>|)>
    </equation*>

    and showing that <math|<frac|d*V<around|(|<mv|\<Lambda\>><around|(|t|)>|)>|d*t>\<le\>0>.
    Indeed,

    <align*|<tformat|<table|<row|<cell|<frac|d*V<around|(|<mm|\<Lambda\>><around|(|t|)>|)>|d*t>>|<cell|=>>|<row|<cell|>|<cell|=<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><wide|\<Lambda\>|\<dot\>><around|(|t|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|max
    <around*|{|0,y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|}>\<cdot\><Ind|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>=0>|\<nobracket\>>>>|<row|<cell|>|<cell|<around*|\<nobracket\>|<space|5cm>+<around*|(|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|)>\<cdot\><Ind|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>\<gtr\>0>|]>>>|<row|<cell|>|<cell|\<leq\><big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|]>>>|<row|<cell|>|<cell|=<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-<wide|y|\<bar\>><rsub|\<ell\>,k>+<wide|y|\<bar\>><rsub|\<ell\>,k>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|]>>>|<row|<cell|>|<cell|\<leq\><big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-<wide|y|\<bar\>><rsub|\<ell\>,k>|]>>>|<row|<cell|>|<cell|=<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><big|sum><rsub|p\<in\>P>R<rsub|\<ell\>,p><around|(|k|)>\<cdot\><around*|[|x<rsub|p,k><around|(|t|)>-<wide|x|\<bar\>><rsub|p,k>|]>>>|<row|<cell|>|<cell|=<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><around*|[|x<rsub|p,k><around|(|t|)>-<wide|x|\<bar\>><rsub|p,k>|]>\<cdot\><around*|(|\<mu\><rsub|p,k><around|(|t|)>-<wide|\<mu\>|\<bar\>><rsub|p,k>|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><around*|[|x<rsub|p,k><around|(|t|)>-<wide|x|\<bar\>><rsub|p,k>|]>\<cdot\><around*|(|<frac|<wide|w|\<bar\>><rsub|p,k>|x<rsub|p,k><around|(|t|)>>-<frac|<wide|w|\<bar\>><rsub|p,k>|<wide|x|\<bar\>><rsub|p,k>>|)>>>|<row|<cell|>|<cell|=<big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><wide|w|\<bar\>><rsub|p,k>\<cdot\><around*|[|2-<frac|x<rsub|p,k><around|(|t|)>|<wide|x|\<bar\>><rsub|p,k>>-<frac|<wide|x|\<bar\>><rsub|p,k>|x<rsub|p,k><around|(|t|)>>|]>>>|<row|<cell|>|<cell|\<leq\>0>>>>>

    The first inequality

    <align*|<tformat|<table|<row|<cell|>|<cell|<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|max
    <around*|{|0,y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|}>\<cdot\><Ind|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>=0>|\<nobracket\>>>>|<row|<cell|>|<cell|<around*|\<nobracket\>|<space|5cm>+<around*|(|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|)>\<cdot\><Ind|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>\<gtr\>0>|]>>>|<row|<cell|>|<cell|\<leq\><big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|]>>>|<row|<cell|>|<cell|>>>>>

    clearly holds <math|\<forall\><around|(|\<ell\>,k|)>:\<Lambda\><rsub|\<ell\>,k><around|(|t|)>\<gtr\>0>,
    but it also holds when <math|\<forall\><around|(|\<ell\>,k|)>:\<Lambda\><rsub|\<ell\>,k><around|(|t|)>=0>.
    The last part holds, because it will either be
    <math|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>\<ge\>0>
    (then it is obvious) or <math|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>\<less\>0>.
    In this case:

    <\equation*>
      <around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\>max
      <around*|{|0,y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|}>=-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>\<cdot\>0\<less\>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|]>.
    </equation*>

    The second inequality

    <align*|<tformat|<table|<row|<cell|>|<cell|<big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-<wide|y|\<bar\>><rsub|\<ell\>,k>+<wide|y|\<bar\>><rsub|\<ell\>,k>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|]>>>|<row|<cell|>|<cell|\<leq\><big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><around*|(|\<Lambda\><rsub|\<ell\>,k><around|(|t|)>-<wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>|)>\<cdot\><around*|[|y<rsub|\<ell\>,k><around|(|t|)>-<wide|y|\<bar\>><rsub|\<ell\>,k>|]>>>|<row|<cell|>|<cell|>>>>>

    holds because for the optimal matrix of resource prices <bvec|\<Lambda\>>
    (for given <bvec|w> and <bvec|f>) it holds that

    <\equation*>
      <big|sum><rsub|\<ell\>\<in\>L><big|sum><rsub|k\<in\>K><wide|\<Lambda\>|\<bar\>><rsub|\<ell\>,k>*<around|(|<wide|y|\<bar\>><rsub|\<ell\>,k>-c<rsub|\<ell\>>*<wide|f|\<bar\>><rsub|k>|)>=0
    </equation*>

    (due to equation<nbsp><eqref|eq:complementarity1-KKT-MSC-2>). The third
    inequality

    <\equation*>
      <big|sum><rsub|p\<in\>P><big|sum><rsub|k\<in\>K><wide|f|\<bar\>><rsub|k>*<wide|w|\<bar\>><rsub|p>\<cdot\><around*|[|2-<frac|x<rsub|p,k><around|(|t|)>|<wide|x|\<bar\>><rsub|p,k>>-<frac|<wide|x|\<bar\>><rsub|p,k>|x<rsub|p,k><around|(|t|)>>|]>\<leq\>0
    </equation*>

    holds because <math|\<forall\>z\<gtr\>0,<space|0.27em>2-z-<frac|1|z>\<le\>0>
    and <math|<wide|f|\<bar\>><rsub|k>,\<forall\>k\<in\>K>,
    <math|<wide|w|\<bar\>><rsub|p>,\<forall\>p\<in\>P> are positive.
    <math|\<Box\>>
  </proof>
</body>