<TeXmacs|1.99.7>

<style|<tuple|ieeetran|std-latex>>

<\body>
  <\hide-preamble>
    <assign|dsum|<macro|<with|math-display|true|<big|sum>>>>

    <assign|hh|<macro|<vspace|0.5>to <hsize>>>

    <assign|dint|<macro|<with|math-display|true|<big|int>>>>

    <assign|dmax|<macro|<with|math-display|true|max>>>

    <assign|dprod|<macro|<with|math-display|true|<big|prod>>>>

    <new-theorem|definition|Definition>

    <new-theorem|theorem|Theorem>

    <new-theorem|lemma|Lemma>
  </hide-preamble>

  <doc-data|<doc-title|The Impact of Incomplete Information on Games in
  Parallel Relay Networks>|<doc-author|<author-data|<author-name|<with|font-size|1.19|Hongda
  Xiao and Edmund M. Yeh><next-line><with|font-size|1|Department of
  Electrical Engineering, Yale University, USA>>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    We consider the impact of incomplete information on incentives for node
    cooperation in parallel relay networks with one source node, one
    destination node, and multiple relay nodes. All nodes are selfish and
    strategic, interested in maximizing their own profit instead of the
    social welfare. We consider the practical situation where the channel
    state on any given relay path is not observable to the source or to the
    other relays. We examine different bargaining relationships between the
    source and the relays, and propose a framework for analyzing the
    efficiency loss induced by incomplete information. We analyze the source
    of the efficiency loss, and quantify the amount of inefficiency which
    results.
  </abstract>>

  <section|<protect><with|font-size|1.19|Introduction>>

  There is now widespread awareness of the importance of incentives in the
  management of communication networks <cite|paper:BLV05|paper:CGKO04|paper:MQ05|book:BH07|paper:KMT98|paper:CDR03>.
  Network nodes often cannot be relied upon to cooperatively implement
  network algorithms in the service of the social good. Instead, selfish
  nodes will behave in a given manner only if it is profitable for them to do
  so. Of clear interest is the impact of such selfish actions on the social
  good. From the network point of view, it is important to design incentives
  such as pricing schemes, which induce selfish behavior aligned with the
  social good.

  In single-hop networks, the incentive issue and its impact on social
  efficiency have been extensively studied. In
  <cite|Roughgarden02|paper:Rou05>, the authors considered the Nash
  Equilibrium for selfish routing, in which source packets choose paths to
  the destination to minimize their individual latency, rather than complying
  with a global routing algorithm to achieve social optimality. In
  <cite|Walrand05> and <cite|Srikant05>, the authors consider network service
  pricing for internet service providers. They showed that cooperation among
  multiple service providers is required when their links are used by common
  users. In <cite|Ozdaglar08>, the authors study competitive behavior among
  multiple parallel links, and characterized the efficiency loss due to
  competition.

  The issue of incentives has also been investigated for multi-hop networks.
  A number of papers<nbsp><cite|Neely07|Yang03|selfishadhoc> advocate the use
  of credits to provide incentives for network nodes to cooperate. In
  <cite|Roughgarden08>, the authors investigate the impact of heterogeneous
  traffic on the pricing of network service providers. Selfish behavior has
  also been investigated in the context of cooperative relay networks. In
  <cite|Yufang06>, the authors considered a nonlinear pricing game, where the
  relay nodes propose nonlinear charging functions to the source, and the
  source allocates the traffic to minimize the payment to relay nodes. In
  <cite|Liu09>, the authors considered a Stackelberg bargaining game, in
  which the relay nodes cooperate as one party in competing with the source
  node.

  All the above papers assume a complete information setting where players in
  the network game have complete knowledge about quantities such as the state
  of network links. In practice, this assumption is often too strong.
  Information regarding network quantities is typically incomplete and
  imperfect. In an internet service provider (ISP) pricing game, for
  instance, the characteristics and service requirements of the users can be
  opaque to the service providers <cite|Srikant07>. In a multi-hop network
  such as the Internet, a source does not typically have perfect information
  on the congestion state of links a few hops away <cite|Gallager>. Finally,
  in wireless networks, the source usually cannot observe or test the channel
  state from a relay to the destination. Neither can a relay observe the
  channel state from other relays to the destination. Given the above, it is
  clear that in analyzing selfish behavior in network settings, the role of
  incomplete information must be emphasized.

  One approach to network design problems with incomplete information is
  through dominant implementable mechanisms <cite|Nisan99>. This idea has
  been used in the context of spectrum auctions <cite|Archer04> and
  communication networks <cite|Johari05>. These mechanisms, however, require
  a centralized authority and extra funding from an outsider. This makes the
  extension to general multi-hop networks difficult. Another approach, based
  on the idea of Bayesian Nash Equilibrium, a generalization of the Nash
  Equilibrium concept, is advocated in <cite|Gairing08>. Here, the authors
  consider selfish routing in a single-hop network, where every source node
  knows only its own traffic requirement, but has knowledge of the traffic
  distribution of other sources. While the results in <cite|Gairing08> are
  appealing, it remains unclear how they might extend to the multi-hop
  network situation.

  In this work, we investigate the impact of incomplete information on the
  problem of pricing and incentives in a two-hop parallel relay network. We
  consider two scenarios, one in which the source has limited bargaining
  power and one in which the source has full bargaining power. In the limited
  bargaining power scenario, the source can only react passively to the
  relays' signals, and the game can be considered to be a pricing game. For
  this case, we show that all Nash Equilibria in the complete information
  game are efficient, including those induced by linear charging functions.
  We then characterize the Bayesian Nash Equilibrium for the incomplete
  information game in which relays propose linear pricing functions, and show
  that incomplete information can induce inefficiencies, which are
  exacerbated by asymmetric prior knowledge on the type distribution. Next,
  in the scenario where the source has full bargaining power, the source is
  allowed to provide a general contract. For this case, we first show that in
  the game with complete information, (Bayesian) Nash equilibria exist and
  are all efficient. Next, we investigate the game with incomplete
  information. To deal with the difficulty of characterizing the Bayesian
  Nash Equilibria in this case, we first show that if a resource allocation
  outcome can be realized by a Bayesian Nash equilibrium, then there exists a
  \Ptruth telling" Bayesian Nash equilibrium that realizes the outcome. We
  then show that the set of outcomes for the \Ptruth telling" Bayesian Nash
  equilibria is included in the set of outcomes for the Nash equilibria for a
  complete information game, in which the link cost functions are replaced by
  specified \Pvirtual cost functions." Using this approach, we obtain for a
  symmetric network scenario a bound on the amount of inefficiency which may
  result from incomplete information.

  <section|<protect><with|font-size|1.19|Network Model>><label|model>

  <subsection|<protect><with|font-size|1.19|font-shape|slanted|Network
  Traffic Allocation>>

  In wireline and wireless networks, it is often the case that an information
  source cannot directly reach its destination, but must do so with the aid
  of intermediate relays. We model such a situation as follows. Consider a
  parallel relay network modelled by a directed graph
  <math|G=<around|(|V,E|)>>, with a single source <math|s>, destination
  <math|d>, and a set of relays <math|I>, where <math|<around|\||I|\|>=n>. We
  assume that there is no direct link between <math|s> and <math|d>. Instead,
  The relays in <math|I> are used to forward traffic in a two-hop fashion
  from <math|s> to <math|d>.

  The source wishes to maintain a certain rate of transmission with the
  destination. We shall consider two scenarios. In the first <em|inelastic>
  scenario, the source has a fixed rate <math|r<rsub|s>> of transmission.
  This rate must be carried by the relays in <math|I>, where the traffic rate
  forwarded by relay <math|i> is <math|r<rsub|i>>, and
  <math|<big|sum><rsub|i=1><rsup|n>r<rsub|i>=r<rsub|s>>. In the second
  <em|elastic> scenario, the source may be willing to withhold some of its
  transmission rate, according to how the cost of sending traffic affects it
  overall utility. Let <math|r<rsub|0>> denote the amount of traffic withheld
  or rejected. Then <math|r<rsub|s>-r<rsub|0>> is the total admitted traffic
  from the source. A traffic vector <math|<math-bf|r>\<triangleq\><around|(|r<rsub|0>,r<rsub|1>,\<ldots\>,r<rsub|n>|)>\<in\>\<bbb-R\><rsub|+><rsup|n+1>>
  is a feasible routing of the source traffic if it satisfies
  <math|r<rsub|0>+<big|sum><rsub|i=1><rsup|n>r<rsub|i>=r<rsub|s>>.

  <subsection|<protect><with|font-size|1.19|font-shape|slanted|Cost Function
  and Utility Function>><label|sec:model>

  In general, for any relay node <math|i>, there is a cost involved in
  forwarding traffic for source <math|s>. This cost typically depends both on
  the properties of the links adjacent on relay <math|i> and the amount of
  traffic flowing through those links. Denote the traffic flow on link
  <math|<around|(|i,j|)>\<in\>E> by <math|f<rsub|i*j>>. We assume that link
  <math|<around|(|i,j|)>> has a cost function
  <math|C<rsub|i*j><around|(|\<theta\><rsub|i*j>,f<rsub|i*j>|)>> with
  <math|C<rsub|i*j><around|(|\<theta\><rsub|i*j>,0|)>=0>, where
  <math|\<theta\><rsub|i*j>> is a measure of the quality of link
  <math|<around|(|i,j|)>>. This quality may have different physical meanings
  in different contexts. For example, if the cost function reflects the
  queuing delay on <math|<around|(|i,j|)>>, then using the M/M/1
  approximation, <math|C<rsub|i*j><around|(|\<theta\><rsub|i*j>,f<rsub|i*j>|)>=<frac|f<rsub|i*j>|k<rsub|i*j>-f<rsub|i*j>>>.
  Here, <math|\<theta\><rsub|i*j>> denotes the link capacity
  <math|k<rsub|i*j>>. For another example, consider the cost of power
  assumption required for transmitting traffic of rate <math|f<rsub|i*j>>
  over a wireless link with channel gain <math|g<rsub|i*j>>, bandwidth
  <math|W>, and receiver noise power <math|N>. Using the Shannon capacity
  formula, we have <math|f<rsub|i*j>=W*log
  <around|(|1+g<rsub|i*j>*P<rsub|i*j>/N|)>>, where <math|P<rsub|i*j>> is
  transmission power required on link <math|<around|(|i,j|)>>. Thus, the link
  cost is

  <\equation*>
    C<rsub|i*j><around|(|\<theta\><rsub|i*j>,f<rsub|i*j>|)>=<frac|N|g<rsub|i*j>>*<around|(|2<rsup|f<rsub|i*j>/W>-1|)>.
  </equation*>

  Here, <math|\<theta\><rsub|i*j>> denotes the channel gain
  <math|g<rsub|i*j>>.

  <big-figure|<with|par-mode|center|<image|relay.eps||||> >|relay channel>

  Now consider the overall cost <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
  for relay node <math|i> to forward traffic of rate <math|r<rsub|i>> from
  source <math|s> to destination <math|d>, where <math|\<theta\><rsub|i>>
  measures the quality or <em|type> of the <em|path> from <math|s> to
  <math|d> through <math|i>. We assume that
  <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>=C<rsub|s*i><around|(|\<theta\><rsub|s*i>,r<rsub|i>|)>+C<rsub|i*d><around|(|\<theta\><rsub|i*d>,r<rsub|i>|)>>.
  The costs <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>> are
  particularly amenable to analysis if <math|\<theta\><rsub|i>> can be
  expressed as a simple scalar function of <math|\<theta\><rsub|s*i>> and
  <math|\<theta\><rsub|i*d>>: <math|\<theta\><rsub|i>=h<around|(|\<theta\><rsub|s*i>,\<theta\><rsub|i*d>|)>>.
  This is true in the example of the power consumption cost function given
  above, where <math|\<theta\><rsub|i*j>=g<rsub|i*j>> is the channel gain on
  link <math|<around|(|i,j|)>>. Normalizing the bandwidth and receiver noise
  power to 1, we have

  <eqnarray|<tformat|<table|<row|<cell|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>>|<cell|=>|<cell|P<rsub|s*i>+P<rsub|i*d><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<around|(|2<rsup|r<rsub|i>>-1|)>/g<rsub|s*i>+<around|(|2<rsup|r<rsub|i>>-1|)>/g<rsub|i*d><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<around|(|2<rsup|r<rsub|i>>-1|)>*\<theta\><rsub|i><rsup|-1>,<eq-number><label|Cost
  Function>>>>>>

  where <math|\<theta\><rsub|i>\<triangleq\><around|(|g<rsub|s*i><rsup|-1>+g<rsub|i*d><rsup|-1>|)><rsup|-1>=<around|(|\<theta\><rsub|s*i><rsup|-1>+\<theta\><rsub|i*d><rsup|-1>|)><rsup|-1>>.
  In this paper, we focus on situations where the path quality
  <math|\<theta\><rsub|i>> can be expressed as a scalar function of
  <math|\<theta\><rsub|s*i>> and <math|\<theta\><rsub|i*d>>. We further
  assume that <math|\<theta\><rsub|i>> belongs to a compact interval
  <math|<around|[|<wide*|\<theta\>|\<bar\>><rsub|i>,<wide|\<theta\>|\<bar\>><rsub|i>|]>>.

  Motivated by the power consumption example, we assume that
  <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>> is twice
  continuously differentiable on <math|<around|[|<wide*|\<theta\>|\<bar\>><rsub|i>,<wide|\<theta\>|\<bar\>><rsub|i>|]>\<times\><around|[|0,r<rsub|s>|]>>,
  and strictly increasing and convex in <math|r<rsub|i>>:
  <math|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>/\<partial\>*r<rsub|i>\<gtr\>0>
  and <math|\<partial\><rsup|2>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>/\<partial\>*r<rsub|i><rsup|2>\<gtr\>0>.
  Also, assume that <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
  is strictly decreasing in <math|\<theta\><rsub|i>>:
  <math|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>/\<partial\>*\<theta\><rsub|i>\<less\>0>.
  Furthermore, assume <math|\<partial\><rsup|2>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>/\<partial\>*\<theta\><rsub|i>*\<partial\>*r<rsub|i>\<leq\>0>.

  Now consider the source <math|s>. In the inelastic case, source <math|s>
  sends traffic at a fixed rate <math|r<rsub|s>> into the network. In the
  elastic case, source <math|s> may withhold traffic of rate <math|r<rsub|0>>
  from the network, and send the other part of the traffic
  <math|r<rsub|s>-r<rsub|0>> into the network. Let the utility function of
  the source be given by <math|W<rsub|s><around|(|\<theta\><rsub|s>,r|)>>,
  where <math|\<theta\><rsub|s>\<in\><lbrack><wide*|\<theta\>|\<bar\>><rsub|s>,<wide|\<theta\>|\<bar\>><rsub|s>]>
  parameterizes the utility for the source, and <math|r> is the source rate
  admitted into the network. For example, the source utility may be
  <math|W<rsub|s><around|(|\<theta\><rsub|s>,r|)>=\<theta\><rsub|s>*log
  <around|(|1+r|)>>. Assume that <math|W<rsub|s><around|(|r|)>=W<rsub|s><around|(|r<rsub|s>|)>>
  for all <math|r\<geq\>r<rsub|s>>, i.e. <math|r<rsub|s>> is the maximum
  desired source rate. <math|W<rsub|s><around|(|\<theta\><rsub|s>,r|)>> is
  assumed to be continuously differentiable, strictly increasing and concave
  in <math|r> on <math|<around|[|0,r<rsub|s>|]>>. Let
  <math|C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>\<triangleq\>W<rsub|s><around|(|r<rsub|s>|)>-W<rsub|s>*<around|(|r<rsub|s>-r<rsub|0>|)>>
  denote the source's <em|utility loss> from having traffic of rate
  <math|r<rsub|0>> withheld from the network. Equivalently, if
  <math|r<rsub|0>> is regarded as the traffic rate routed on a <em|virtual
  overflow link> directly from <math|s> to <math|d><nbsp><cite|Gallager>,
  then <math|C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>> represents
  the cost on the overflow link when the link parameter is
  <math|\<theta\><rsub|s>> and the flow rate is <math|r<rsub|0>>. Since
  <math|W<rsub|s><around|(|r<rsub|s>|)>> is a constant, it can be seen that
  <math|C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>> is continuously
  differentiable on <math|<around|[|<wide*|\<theta\>|\<bar\>><rsub|s>,<wide|\<theta\>|\<bar\>><rsub|s>|]>\<times\><lbrack>0,r<rsub|s>]>,
  strictly increasing and convex in <math|r<rsub|0>>:
  <math|\<partial\>*C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>/\<partial\>*r<rsub|0>\<gtr\>0>
  and <math|\<partial\><rsup|2>*C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>/\<partial\>*r<rsub|0><rsup|2>\<gtr\>0>.
  Furthermore, we assume that <math|C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>>
  is strictly decreasing in <math|\<theta\><rsub|s>>:
  <math|\<partial\>*C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>/\<partial\>*\<theta\><rsub|s>\<less\>0>.
  Finally, it can be seen that <math|C<rsub|s><around|(|\<theta\><rsub|s>,0|)>=0>
  for all <math|\<theta\><rsub|s>>. It can easily be checked that these
  properties are satisfied for the example
  <math|W<rsub|s><around|(|\<theta\><rsub|s>,r|)>=\<theta\><rsub|s>*log
  <around|(|1+r|)>>, for which <math|C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>=W<rsub|s><around|(|r<rsub|s>|)>-\<theta\><rsub|s>*log
  <around|(|1+r<rsub|s>-r<rsub|0>|)>>. With the aid of the virtual overflow
  link, we may view a game with an elastic source as a game with an inelastic
  source of rate <math|r<rsub|s>> and an overflow link
  <math|<around|(|s,w|)>> with cost function
  <math|C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>>.

  <subsection|<protect><with|font-size|1.19|font-shape|slanted|Socially
  Optimal Allocation>><label|sec:efficient>

  A socially optimal traffic allocation in a parallel relay network is an
  allocation which minimizes the total network cost, assumed to be the sum of
  the link costs. Such an allocation can be realized through cooperation of
  the network nodes. In networks with selfish and strategic nodes, a socially
  optimal allocation may or may not be realizable. Nevertheless, the optimal
  allocation serves as an important benchmark with which to measure the
  amount of potential inefficiency introduced by selfish and strategic
  behavior.

  Let <math|R\<triangleq\><around|{|<around|(|r<rsub|0>,r<rsub|1>,...,r<rsub|n>|)>:r<rsub|j>\<geq\>0<nbsp>\<forall\>j=0,\<ldots\>,n,<big|sum><rsub|j=0><rsup|n>r<rsub|j>=r<rsub|s>|}>>
  be the set of feasible traffic allocations, and let
  <math|<math-bf|r>\<in\>R> denote the vector of traffic rates in the
  network, where <math|r<rsub|0>> is the rate withheld by the source, and
  <math|r<rsub|i>> is the rate routed to relay <math|i,i=1,\<ldots\>,n>. Note
  that for the case of an inelastic source, <math|r<rsub|0>=0>.

  <\definition>
    A traffic allocation vector <math|<math-bf|r><rsup|\<ast\>>> is called
    socially optimal if

    <\equation>
      <math-bf|r><rsup|\<ast\>>\<in\>arg min<rsub|<math-bf|r>\<in\>R>
      C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>+<big|sum><rsub|i=1><rsup|n>C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>.
    </equation>
  </definition>

  Since the link cost functions <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
  as well as <math|C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>> are all
  strictly increasing and strictly convex, the socially optimal allocation
  <math|<math-bf|r><rsup|\<ast\>>> exists and is unique. The conditions for
  specifying <math|<math-bf|r><rsup|\<ast\>>> can be obtained using the
  Kuhn-Tucker conditions. Let <math|c<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>\<triangleq\>\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>/\<partial\>*r<rsub|i>>
  and <math|c<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>\<triangleq\>\<partial\>*C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>/\<partial\>*r<rsub|0>>
  denote the marginal cost function of link <math|i> and the marginal cost
  function of the overflow link for source <math|s>, respectively.

  For the case of an inelastic source, <math|<math-bf|r><rsup|\<ast\>>=<around|(|0,r<rsup|\<ast\>><rsub|1>,\<ldots\>,r<rsup|\<ast\>><rsub|n>|)>>
  is the socially optimal allocation if and only if for each
  <math|i=1,\<ldots\>,n>,

  <\equation>
    c<rsub|i><around|(|\<theta\><rsub|i>,r<rsup|\<ast\>><rsub|i>|)>=c<rsup|\<ast\>><nbsp><text|if><nbsp>r<rsup|\<ast\>><rsub|i>\<gtr\>0,<space|1em>c<rsub|i><around|(|\<theta\><rsub|i>,r<rsup|\<ast\>><rsub|i>|)>\<gtr\>c<rsup|\<ast\>><nbsp><text|if><nbsp>r<rsup|\<ast\>><rsub|i>=0.<label|eq:optcond>
  </equation>

  For the case of an elastic source, <math|<math-bf|r><rsup|\<ast\>>=<around|(|r<rsup|\<ast\>><rsub|0>,r<rsup|\<ast\>><rsub|1>,\<ldots\>,r<rsup|\<ast\>><rsub|n>|)>>
  is the socially optimal allocation if and only if<nbsp><eqref|eq:optcond>
  holds and furthermore,

  <\equation*>
    c<rsub|s><around|(|\<theta\><rsub|s>,r<rsup|\<ast\>><rsub|0>|)>=c<rsup|\<ast\>><nbsp><text|if><nbsp>r<rsup|\<ast\>><rsub|0>\<gtr\>0,<space|1em>c<rsub|s><around|(|\<theta\><rsub|s>,r<rsup|\<ast\>><rsub|0>|)>\<gtr\>c<rsup|\<ast\>><nbsp><text|if><nbsp>r<rsup|\<ast\>><rsub|0>=0.
  </equation*>

  <subsection|<protect><with|font-size|1.19|font-shape|slanted|Game
  Structure>><label|sec:general>

  Unlike the cooperative setting, in a network consisting of selfish and
  strategic nodes, the source as well as the relays will strategize to
  maximize their own utility, rather than work together to minimize the
  overall network cost. Since forwarding traffic entails cost, the relays
  will carry the source's traffic only if they are sufficiently well
  compensated. The source, on the hand, wishes to have its traffic forwarded
  at the smallest possible cost to itself. The natural setting in which to
  carry out this game is one which allows for transfer payments which
  accompany traffic allocations from the source to the respective relays.

  In this work, we assume that the (maximum) source input rate
  <math|r<rsub|s>> and the parameter <math|\<theta\><rsub|s>> are known to
  all nodes. As discussed above, the cost function
  <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>> for relay <math|i>
  depends on the path quality parameter or type <math|\<theta\><rsub|i>>. In
  practical network settings, the value of this type may be randomly
  fluctuating. For instance, in wireless communication, the channel gain
  <math|g<rsub|i*j>> fluctuates due to shadowing and fading. In the Internet,
  the quality of a particular path may fluctuate according to network
  congestion levels. Accordingly, we may assume that <math|\<theta\><rsub|i>>
  is randomly distributed according to distribution function
  <math|F<rsub|i><around|(|\<theta\><rsub|i>|)>>. In practical network
  scenarios, the exact realization of <math|\<theta\><rsub|i>> is typically
  known only to relay <math|i>, and not to the source or to the relays other
  than <math|i>. Thus, <math|\<theta\><rsub|i>> is <em|private information>
  to relay <math|i>. Nevertheless, the source and other relays may still have
  knowledge of the distribution <math|F<rsub|i><around|(|\<theta\><rsub|i>|)>>.
  For instance, a wireless source or a relay <math|j\<neq\>i> may know the
  distribution of the channel gains for relay <math|i>, but typically does
  not know the realization of those channel gains. An Internet source or a
  path <math|j\<neq\>i> may know the distribution of the congestion level on
  path <math|i>, but does not know the exact realization of the congestion
  level.

  In order for the source node to allocate its traffic intelligently in the
  presence of incomplete information regarding the
  <math|\<theta\><rsub|i>>'s, it needs to observe some \Psignal" from the
  relay nodes. This can be realized by having the relay node send a signal
  according to the realization of its type to the source.<footnote|One can
  also consider the possibility of the source sending a signal according to
  its type <math|\<theta\><rsub|s>>. However, since we assume
  <math|\<theta\><rsub|s>> is known to all network nodes, we do not consider
  this possibility here.> Let <math|M<rsub|i>> be the set of signals for
  relay <math|i>, where <math|M<rsub|i>> is a subset of the set of
  differentiable functions on <math|<around|[|0,r<rsub|s>|]>>. The signal map
  for relay <math|i> is

  <\equation*>
    s<rsub|i>:\<Theta\><rsub|i>\<rightarrow\>M<rsub|i>,
  </equation*>

  where <math|\<Theta\><rsub|i>\<triangleq\><around|[|<wide*|\<theta\>|\<bar\>><rsub|i>,<wide|\<theta\>|\<bar\>><rsub|i>|]>>
  and <math|s<rsub|i><around|(|\<theta\><rsub|i>|)>=m<rsub|i><around|(|\<cdummy\>|)>>.

  Given the signals <math|m<rsub|i><around|(|\<cdummy\>|)>,i=1,\<ldots\>,n>,
  the source decides on an allocation of its traffic as well as a vector of
  transfer payments to the relays. This allocation is called a <em|contract>.
  Let <math|<math-bf|r>=<around|(|r<rsub|0>,r<rsub|1>,...,r<rsub|n>|)>\<in\>R>
  denote the vector of traffic rates in the network, where <math|r<rsub|0>>
  is the rate withheld by the source, and <math|r<rsub|i>> is the rate routed
  to relay <math|i,i=1,\<ldots\>,n>. Note that for the inelastic case,
  <math|r<rsub|0>=0>. Now let <math|<math-bf|t>=<around|(|t<rsub|1>,t<rsub|2>,...,t<rsub|n>|)>\<in\>\<bbb-R\><rsub|+><rsup|n>>
  be the vector of transfer payments, where <math|t<rsub|i>> is the transfer
  payment to relay <math|i>. Let <math|M\<triangleq\>M<rsub|1>\<times\>\<cdots\>\<times\>M<rsub|n>>
  and <math|T\<triangleq\>\<bbb-R\><rsub|+><rsup|n>>. Then the allocation map
  of the source node is

  <\equation*>
    g:M\<rightarrow\>R\<times\>T,
  </equation*>

  where <math|g<around|(|m<rsub|1>|(>\<cdot\>),\<ldots\>,m<rsub|n>(\<cdot\><around|)||)>=<around|(|<math-bf|r>,<math-bf|t>|)>>.

  The above framework encompasses many forms of pricing games explored in
  previous literature. For instance, in<nbsp><cite|Yufang06>, the relay
  signals are simply charging functions <math|P<rsub|i><around|(|\<cdummy\>|)>>,
  and the transfer payments are required to equal the charges demanded by the
  relays, i.e. <math|t<rsub|i>=P<rsub|i><around|(|r<rsub|i>|)>>.

  The signal maps of the relays along with the allocation map of the source
  realize a corresponding network allocation map

  <\equation*>
    f:\<Theta\>\<rightarrow\>R\<times\>T,
  </equation*>

  where <math|f<around|(|\<theta\><rsub|1>,\<ldots\>,\<theta\><rsub|n>|)>=g<around|(|s<rsub|1><around|(|\<theta\><rsub|1>|)>,\<ldots\>,s<rsub|n><around|(|\<theta\><rsub|n>|)>|)>=<around|(|<math-bf|r>,<math-bf|t>|)>>.

  In the game with incomplete information corresponding to the above setting,
  the utility of the source is given by

  <\equation*>
    U<rsub|s>(\<theta\><rsub|s>,g<around|(|s<rsub|1><around|(|\<theta\><rsub|1>|)>,\<ldots\>,s<rsub|n><around|(|\<theta\><rsub|n>|)>|)>=W<rsub|s><around|(|r<rsub|s>|)>-C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>-<big|sum><rsub|i=1><rsup|n>t<rsub|i>.
  </equation*>

  The utility of relay <math|i> is given by

  <\equation*>
    U<rsub|i><around|(|\<theta\><rsub|i>,g<around|(|s<rsub|1><around|(|\<theta\><rsub|1>|)>,\<ldots\>,s<rsub|n><around|(|\<theta\><rsub|n>|)>|)>|)>=t<rsub|i>-C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>.
  </equation*>

  The game with incomplete information proceeds as follows. First, each relay
  <math|i> observes its own private information <math|\<theta\><rsub|i>>.
  Second, the source provides a contract for the relay nodes. The contract
  announces the source allocation rule <math|g:M\<rightarrow\>R\<times\>T>.
  Third, the relays simultaneously decide to either accept or reject the
  contract. If a given relay accepts the contract, then it will participate
  in the game which follows. Otherwise, the relay quits and receives zero
  utility.<footnote|Note that the relays which quit can simply be left out of
  the game formulation. Thus, without loss of generality, we assume for the
  rest of the paper that the source plays the game in a manner which gives
  non-negative expected utility to all relays, so that all relays stay in the
  game.> Fourth and finally, the relay nodes simultaneously send their
  signals to the source, and the source allocates rates and transfer payments
  according to the announced <math|g>.

  In the following, we give the formal definition of the Bayesian Nash
  equilibrium corresponds to the game with incomplete information described
  above. Let <math|<with|math-font-family|bf|\<theta\>>\<triangleq\><around|(|\<theta\><rsub|1>,\<ldots\>,\<theta\><rsub|n>|)>>,
  <math|<with|math-font-family|bf|\<theta\>><rsub|-i>\<triangleq\><around|(|\<theta\><rsub|j>|)><rsub|j\<neq\>i>>,
  and <math|s<rsub|-i><around|(|<with|math-font-family|bf|\<theta\>><rsub|-i>|)>\<triangleq\><around|(|s<rsub|j><around|(|\<theta\><rsub|j>|)>|)><rsub|j\<neq\>i>>.

  <\definition>
    A Bayesian Nash Equilibrium of the above game is a set of strategies
    <math|<around|{|s<rsub|1>,\<ldots\>,s<rsub|n>,g|}>> satisfying
    <new-counter|BNE>

    <\list|<with|font-series|bold|font-shape|right|<number|<BNE-nr>|arabic>.>|<usecounter|BNE>>
      <item>for each relay node <math|i> and every feasible
      <math|<wide|s<rsub|i>|~>:\<Theta\><rsub|i>\<rightarrow\>M<rsub|i>>,

      <eqnarray|<tformat|<table|<row|<cell|E<rsub|\<theta\><rsub|-i>><around*|{|U<rsub|i><around|(|\<theta\><rsub|i>,g<around|(|s<rsub|i><around|(|\<theta\><rsub|i>|)>,s<rsub|-i><around|(|\<theta\><rsub|-i>|)>|)>|)>|}>>>|<row|<cell|\<ge\>E<rsub|\<theta\><rsub|-i>><around*|{|U<rsub|i><around|(|\<theta\><rsub|i>,g<around|(|<wide|s<rsub|i>|~><around|(|\<theta\><rsub|i>|)>,s<rsub|-i><around|(|\<theta\><rsub|-i>|)>|)>|)>|}>,<eq-number><label|eq:relayopt>>>>>>

      <item>for every feasible <math|<wide|g|~>:M\<rightarrow\>R\<times\>T>,

      <\equation>
        E<rsub|<with|math-font-family|bf|\<theta\>>><around*|{|U<rsub|s><around|(|\<theta\><rsub|s>,g<around|(|s<around|(|<with|math-font-family|bf|\<theta\>>|)>|)>|)>|}>\<ge\>E<rsub|<with|math-font-family|bf|\<theta\>>><around*|{|U<rsub|s><around|(|\<theta\><rsub|s>,<wide|g|~><around|(|s<around|(|<with|math-font-family|bf|\<theta\>>|)>|)>|)>|}>.<label|eq:sourceopt>
      </equation>
    </list>
  </definition>

  <section|<protect><with|font-size|1.19|font-shape|slanted|Games with
  Limited Source Bargaining Power>>

  We first consider a specific instance of the general game described in
  Section<nbsp><reference|sec:general> in which the source has limited
  bargaining power. In this case, the source can only react passively to the
  relays' signals. Specifically, the transfer payment from the source to any
  given relay must equal the relay's signal function evaluated at the traffic
  rates routed to the relay. That is, the source allocation rule is given by
  <math|g<around|(|m<rsub|1>|(>\<cdot\>),\<ldots\>,m<rsub|n>(\<cdot\><around|)||)>=<around|(|<math-bf|r>,<math-bf|t>|)>>,
  where

  <eqnarray|<tformat|<table|<row|<cell|<math-bf|r>>|<cell|\<in\>>|<cell|arg
  max<rsub|<math-bf|r><rprime|'>\<in\>R> W<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|s>|)>-C<rsub|s><around|(|\<theta\><rsub|s>,r<rprime|'><rsub|0>|)>-<tformat|<table|<row|<cell|<big|sum><rsub|i=1><rsup|n>m<rsub|i><around|(|r<rsub|i><rprime|'>|)>>|<cell|>|<cell|>>|<row|<cell|t<rsub|i>>|<cell|=>|<cell|m<rsub|i><around|(|r<rsub|i>|)>,<space|1em>i=1,\<ldots\>,n.>>>><eq-number><label|eq:sourcenobargain1><label|eq:sourcenobargain2>>>>>>

  Effectively, the relays' signal functions act as charging functions, and
  the transfer payments must correspond to the relays' charges. The source
  can only allocate its traffic to minimize the cost of withheld traffic plus
  the total charges paid to the relays. In this case, the game can be
  considered to be a <em|pricing game>.

  <subsection|<protect><with|font-size|1.19|font-shape|slanted|Pricing Game
  with Complete Information>>

  In this section, we consider the specific pricing game with <em|complete
  information> where the source has limited bargaining power and the vector
  of relay types <math|\<theta\>=<around|(|\<theta\><rsub|1>,\<ldots\>,\<theta\><rsub|n>|)>>
  is known to all nodes in the network. Note that this is degenerate version
  of the game considered in Section<nbsp><reference|sec:general> where the
  prior distribution on the type of relay <math|i> available to all nodes is
  given by the distribution function <math|F<rsub|i><around|(|x|)>=0> for
  <math|x\<less\>\<theta\><rsub|i>> and <math|F<rsub|i><around|(|x|)>=1> for
  <math|x\<geq\>\<theta\><rsub|i>>, where <math|\<theta\><rsub|i>> is the
  realization of relay <math|i>'s type.

  Since the allocation rule of the source is fixed
  by<nbsp>(<reference|eq:sourcenobargain1>)-(<reference|eq:sourcenobargain2>),
  the knowledge of <math|\<theta\>> cannot cause the source to adjust its
  allocation rule accordingly. Thus, knowledge of <math|\<theta\>> is not
  useful to the source due to its lack of bargaining power. Also, due to the
  degenerate prior distribution on <math|\<theta\><rsub|i>>, we need only
  consider the usual concept of Nash equilibrium here. We now show that in
  fact all the Nash equilibria in this complete information pricing game are
  efficient.

  <\theorem>
    In the pricing game with complete information, Nash equilibria exist, and
    all Nash equilibria are efficient. Moreover, there exists an efficient
    Nash equilibrium in which each relay uses a linear charging function.
  </theorem>

  <\proof>
    We focus on the case for inelastic sources. The elastic case can be
    similarly handled. Since <math|\<theta\>=<around|(|\<theta\><rsub|1>,\<ldots\>,\<theta\><rsub|n>|)>>
    is known to all nodes in the network, we suppress the dependence of
    various quantities on <math|\<theta\>>. In this game with limited source
    bargaining power, the relays' signals represent charging functions. Let
    <math|B<rsub|i><around|(|r<rsub|i>|)>> be the charge required by relay
    <math|i> for forwarding traffic of rate <math|r<rsub|i>>, and let
    <math|b<rsub|i><around|(|r<rsub|i>|)>\<triangleq\>B<rprime|'><rsub|i><around|(|r<rsub|i>|)>>
    be the marginal charging function, or pricing function. Let
    <math|C<rsub|i><around|(|r<rsub|i>|)>> and
    <math|c<rsub|i><around|(|r<rsub|i>|)>> be cost function and marginal cost
    function for relay <math|i>, respectively.

    Let the (unique) socially optimal allocation be
    <math|<math-bf|r><rsup|\<ast\>>=<around|(|r<rsub|1><rsup|\<ast\>>,r<rsub|2><rsup|\<ast\>>,...,r<rsub|n><rsup|\<ast\>>|)>>.
    Suppose that there exists a Nash Equilibrium with charging functions
    <math|B<rsub|i><around|(|r<rsub|i>|)>> and corresponding rate allocation
    <math|<math-bf|r>=<around|(|r<rsub|1>,r<rsub|2>,...,r<rsub|n>|)>\<neq\><math-bf|r><rsup|\<ast\>>>.
    With a possible re-ordering of the relay indices, we may assume that
    <math|r<rsub|i>\<gtr\>r<rsub|i><rsup|\<ast\>>> for
    <math|i\<less\>k<rsub|1>>, <math|r<rsub|i>=r<rsub|i><rsup|\<ast\>>> for
    <math|k<rsub|1>\<le\>i\<less\>k<rsub|2>>, and
    <math|r<rsub|i>\<less\>r<rsub|i><rsup|\<ast\>>> for
    <math|i\<ge\>k<rsub|2>>. As <math|<math-bf|r>\<neq\><math-bf|r><rsup|\<ast\>>>
    and both must sum to <math|r<rsub|s>>, <math|k<rsub|1>\<gtr\>1> and
    <math|k<rsub|2>\<less\>n>.

    Since <math|<math-bf|r><rsup|\<ast\>>> is the unique socially optimal
    allocation, from the optimality conditions, we have

    <\equation>
      c<rsub|i><around|(|r<rsub|i><rsup|\<ast\>>|)>=c<rsup|\<ast\>><nbsp><text|if><nbsp>r<rsup|\<ast\>><rsub|i>\<gtr\>0,<space|1em>c<rsub|i><around|(|r<rsub|i><rsup|\<ast\>>|)>\<gtr\>c<rsup|\<ast\>><nbsp><text|if><nbsp>r<rsup|\<ast\>><rsub|i>=0.
    </equation>

    where <math|c<rsup|\<ast\>>> is the optimal marginal cost. Now by the
    strict convexity of <math|C<rsub|i><around|(|r<rsub|i>|)>>,

    <\equation>
      <label|Maginal1><around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|c<rsub|i><around|(|r|)>\<gtr\>c<rsup|\<ast\>><nbsp><text|for
      all><nbsp>r\<in\><around|[|r<rsup|\<ast\>><rsub|i>,r<rsub|i>|)><nbsp><text|if><nbsp>i\<less\>k<rsub|1>>|<cell|>>|<row|<cell|c<rsub|i><around|(|r|)>\<less\>c<rsup|\<ast\>><nbsp><text|for
      all><nbsp>r\<in\><around|(|r<rsub|i>,r<rsup|\<ast\>><rsub|i>|]><nbsp><text|if><nbsp>i\<gtr\>k<rsub|2>>|<cell|>>>>>|\<nobracket\>>
    </equation>

    The profit of relay <math|i> for <math|i\<less\>k<rsub|1>> is

    <\equation>
      <big|int><rsub|0><rsup|r<rsub|i><rsup|\<ast\>>>b<rsub|i><around|(|r|)>-c<rsub|i><around|(|r|)>*d*r+<big|int><rsub|r<rsub|i><rsup|\<ast\>>><rsup|r<rsub|i>>b<rsub|i><around|(|r|)>-c<rsub|i><around|(|r|)>*d*r.
    </equation>

    Since we are at a Nash equilibrium, for all <math|i\<less\>k<rsub|1>> and
    for any <math|0\<less\>\<delta\>\<less\>r<rsub|i>-r<rsub|i><rsup|\<ast\>>>,
    <math|<big|int><rsub|r<rsub|i>-\<delta\>><rsup|r<rsub|i>>b<rsub|i><around|(|r|)>-c<rsub|i><around|(|r|)>*d*r\<geq\>0>.
    For otherwise, relay <math|i\<less\>k<rsub|1>> will deviate to another
    charging function which is extremely high from
    <math|r<rsub|i><rsup|\<ast\>>> to <math|r<rsub|i>>, so as not to take the
    extra traffic <math|r<rsub|i>-r<rsub|i><rsup|\<ast\>>>. Now choose
    <math|\<epsilon\>\<less\>m*i*n<rsub|i:i\<less\>k<rsub|1><nbsp><text|or><nbsp>i\<geq\>k<rsub|2>>*<around|\||r<rsub|i>-r<rsub|i><rsup|\<ast\>>|\|>>.
    Let

    <\equation>
      <around*|{|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|m>|<cell|\<in\><space|1em>arg
      max<rsub|1\<le\>i\<less\>k<rsub|1>>
      <big|int><rsub|r<rsub|i>-\<epsilon\>><rsup|r<rsub|i>>c<rsub|i><around|(|r|)>*d*r>>|<row|<cell|l>|<cell|\<in\><space|1em>arg
      min<rsub|k<rsub|2>\<le\>i\<le\>n> <big|int><rsub|r<rsub|i>><rsup|r<rsub|i>+\<epsilon\>>c<rsub|i><around|(|r|)>*d*r>>>>>|\<nobracket\>>
    </equation>

    By<nbsp>(<reference|Maginal1>),

    <\equation>
      <big|int><rsub|r<rsub|m>-\<epsilon\>><rsup|r<rsub|m>>c<rsub|m><around|(|r|)>*d*r\<gtr\><big|int><rsub|r<rsub|l>><rsup|r<rsub|l>+\<epsilon\>>c<rsub|l><around|(|r|)>*d*r
    </equation>

    However, since <math|<big|int><rsub|r<rsub|m>-\<epsilon\>><rsup|r<rsub|m>>b<rsub|m><around|(|r|)>-c<rsub|m><around|(|r|)>*d*r\<geq\>0>,
    there exists a charging function <math|<wide|B|~><rsub|l><around|(|r|)>>
    for relay <math|l> such that <math|<wide|B|~><rsub|l><around|(|r|)>>
    equals <math|B<rsub|l><around|(|r|)>> from 0 to <math|r<rsub|l>>, but

    <\equation>
      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|l>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<big|int><rsub|r<rsub|m>-\<epsilon\>><rsup|r<rsub|m>>b<rsub|m><around|(|r|)>*d*r>|<cell|\<geq\><space|1em><big|int><rsub|r<rsub|m>-\<epsilon\>><rsup|r<rsub|m>>c<rsub|m><around|(|r|)>*d*r>>|<row|<cell|>|<cell|\<gtr\><space|1em><big|int><rsub|r<rsub|l>><rsup|r<rsub|l>+\<epsilon\>><wide|b|~><rsub|l><around|(|r|)>*d*r<space|1em>\<gtr\><space|1em><big|int><rsub|r<rsub|l>><rsup|r<rsub|l>+\<epsilon\>>c<rsub|l><around|(|r|)>*d*r.>>>>>
    </equation>

    Thus if relay <math|l> uses <math|<wide|B|~><rsub|l><around|(|r|)>>, then
    in order to maximize its profit, the source will switch an
    <math|\<epsilon\>> amount of traffic from relay <math|m> to relay
    <math|l>. Thus, relay <math|l> can deviate to
    <math|<wide|B|~><rsub|l><around|(|r|)>> and get a higher profit,
    contradicting our assumption of being at a Nash equilibrium.

    The existence of an efficient Nash equilibrium in which relays use linear
    charging functions has been demonstrated in<nbsp><cite|Yufang06>,
    completing the proof.
  </proof>

  <subsection|<protect><with|font-size|1.19|font-shape|slanted| Pricing Game
  with Incomplete Information>>

  When the source and the relays <math|j\<neq\>i> cannot observe the type
  <math|\<theta\><rsub|i>> of relay <math|i>, the source and the relays must
  content themselves with maximizing their expected profits. In this
  situation, the characterization of Bayesian Nash Equilibria for general
  nonlinear charging functions is very difficult. We limit our discussion to
  the case where relays bid <em|linear> charging functions, i.e.
  <math|B<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>=p<rsub|i><around|(|\<theta\><rsub|i>|)>*r<rsub|i>>,
  where the price <math|p<rsub|i><around|(|\<theta\><rsub|i>|)>> per unit
  traffic depends on the type <math|\<theta\><rsub|i>>. Let
  <math|w<rsub|i>\<triangleq\>p<rsub|i><rsup|-1>> be the inverse function of
  <math|p<rsub|i>> such that <math|\<theta\><rsub|i>=w<rsub|i><around|(|p<rsub|i><around|(|\<theta\><rsub|i>|)>|)>>.
  We assume that the density <math|f<rsub|i><around|(|\<theta\><rsub|i>|)>>
  is positive over <math|\<Theta\><rsub|i>=<around|[|<wide*|\<theta\>|\<bar\>><rsub|i>,<wide|\<theta\>|\<bar\>><rsub|i>|]>>.

  We prove the following theorem.

  <\theorem>
    If the source is inelastic, in any Bayesian Nash Equilibrium, the price
    function satisfies the following differential equations:

    <eqnarray|<tformat|<table|<row|<cell|<frac|d*w<rsub|i><around|(|p<rsub|i>|)>|d*p<rsub|i>>>|<cell|=>|<cell|<frac|F<rsub|i><around|(|w<rsub|i><around|(|p<rsub|i>|)>|)>|<around|(|n-1|)>*f<rsub|i><around|(|w<rsub|i><around|(|p<rsub|i>|)>|)>><around*|{|<frac|-<around|(|n-2|)>*r<rsub|s>|p<rsub|i>*r<rsub|s>-C<rsub|i><around|(|w<rsub|i><around|(|p<rsub|i>|)>,r<rsub|s>|)>>|\<nobracket\>><eq-number>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|+<big|sum><rsub|j\<neq\>i><frac|r<rsub|s>|p<rsub|i>*r<rsub|s>-C<rsub|j><around|(|w<rsub|j><around|(|p<rsub|i>|)>,r<rsub|s>|)>>|}>,<eq-number><label|Inelastic
    Equation>>>>>>

    where <math|p<rsub|i><around|(|\<theta\><rsub|i>|)>> is given by the
    inverse of <math|w<rsub|i><around|(|p<rsub|i>|)>>.

    In particular, in the symmetric situation where
    <math|F<rsub|i><around|(|\<theta\><rsub|i>|)>=F<around|(|\<theta\><rsub|i>|)>>
    and <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>=C<around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
    for all <math|i>, the Bayesian Nash Equilibrium satisfies:

    <\equation>
      p<rsub|i><around|(|\<theta\><rsub|i>|)>=<frac|1|r<rsub|s>>*<around*|{|C<around|(|\<theta\><rsub|i>,r<rsub|s>|)>-<frac|<big|int><rsub|<wide*|\<theta\>|\<bar\>>><rsup|\<theta\><rsub|i>>F<around|(|\<theta\>|)><rsup|n-1><frac|\<partial\>*C<around|(|\<theta\>,r<rsub|s>|)>|\<partial\>*\<theta\>>*d*\<theta\>|F<around|(|\<theta\><rsub|i>|)><rsup|n-1>>|}>.
    </equation>
  </theorem>

  <\proof>
    By an argument similar to that in <cite|Lebrun99>,
    <math|p<rsub|i><around|(|\<theta\><rsub|i>|)>> and
    <math|w<rsub|i><around|(|p<rsub|i>|)>> are both strictly decreasing
    functions. Since the charging functions are linear, the source will
    always allocate all its traffic to the relay proposing the lowest
    price.<footnote|Note that since <math|\<theta\><rsub|i>> are continuous
    random variables and <math|p<rsub|i><around|(|\<theta\><rsub|i>|)>> are
    strictly decreasing functions, the probability that there are any ties in
    the relay prices is zero.> Given the other relays' pricing strategies
    <math|w<rsub|j><around|(|p<rsub|j>|)>,j\<neq\>i>, the probability that
    relay <math|i> proposes the lowest price is given by

    <eqnarray*|<tformat|<table|<row|<cell|Pr
    {p<rsub|i>>|<cell|\<less\>>|<cell|p<rsub|j>*<text|for all >j\<neq\>i}=Pr
    <around|{|\<theta\><rsub|j>\<less\>w<rsub|j><around|(|p<rsub|i>|)>*<text|for
    all >j\<neq\>i|}>>>|<row|<cell|>|<cell|=>|<cell|<big|prod><rsub|j\<neq\>i>F<rsub|j><around|(|w<rsub|j><around|(|p<rsub|i>|)>|)>>>>>>

    For each given private type <math|\<theta\><rsub|i>>, relay <math|i>
    wishes to choose its price <math|p<rsub|i>> to maximize the expected
    profit

    <eqnarray|<tformat|<table|<row|<cell|\<pi\><rsub|i><around|(|\<theta\><rsub|i>,p<rsub|i>|)>>|<cell|=>|<cell|Pr
    <around|{|p<rsub|i>\<less\>p<rsub|j>*<text|for all
    >j\<neq\>i|}>*<around|(|p<rsub|i>*r<rsub|s>-C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|s>|)>|)><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<big|prod><rsub|j\<neq\>i>F<rsub|j><around|(|w<rsub|j><around|(|p<rsub|i>|)>|)>*<around|(|p<rsub|i>*r<rsub|s>-C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|s>|)>|)><eq-number>>>>>>

    In order to maximize <math|\<pi\><rsub|i><around|(|\<theta\><rsub|i>,p<rsub|i>|)>>,
    the first-order condition must be hold:

    <eqnarray|<tformat|<table|<row|<cell|<frac|\<partial\>*ln
    \<pi\><rsub|i><around|(|\<theta\><rsub|i>,p<rsub|i>|)>|\<partial\>*p<rsub|i>>>|<cell|=>|<cell|<tformat|<table|<row|<cell|<big|sum><rsub|j\<neq\>i><frac|1|F<rsub|j><around|(|w<rsub|j><around|(|p<rsub|i>|)>|)>>*f<rsub|j><around|(|w<rsub|j><around|(|p<rsub|i>|)>|)><frac|d*w<rsub|j><around|(|p<rsub|i>|)>|d*p<rsub|i>>>|<cell|>|<cell|>>|<row|<cell|>|<cell|>|<cell|+<frac|r<rsub|s>|p<rsub|i>*r<rsub|s>-C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|s>|)>>>>|<row|<cell|>|<cell|=>|<cell|0>>>><eq-number>>>>>>

    After some algebra, we obtain (<reference|Inelastic Equation>).

    We now focus on the symmetric situation for an inelastic source, where
    <math|F<rsub|i><around|(|\<theta\><rsub|i>|)>=F<around|(|\<theta\><rsub|i>|)>>
    and <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>=C<around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
    for all <math|i>. First, using an argument similar to that
    in<nbsp><cite|Lebrun99>, all the relay nodes should have the same pricing
    strategy <math|p<around|(|\<theta\><rsub|i>|)>> and
    <math|w<around|(|p<rsub|i>|)>>. Thus, the expected profit for relay
    <math|i> is

    <\equation>
      \<pi\><rsub|i><around|(|\<theta\><rsub|i>,p<rsub|i>|)>=F<around|(|w<around|(|p<rsub|i>|)>|)><rsup|n-1>*<around|(|p<rsub|i>*r<rsub|s>-C<around|(|\<theta\><rsub|i>,r<rsub|s>|)>|)>.<label|eq:expectedprofit>
    </equation>

    Let the value function for relay <math|i> (the maximum profit for relay
    <math|i> given type <math|\<theta\><rsub|i>> by choosing the optimal
    <math|p<rsub|i><around|(|\<theta\><rsub|i>|)>>) be
    <math|v<rsub|i><around|(|\<theta\><rsub|i>|)>\<triangleq\>max<rsub|p<rsub|i>>
    \<pi\><rsub|i><around|(|\<theta\><rsub|i>,p<rsub|i>|)>>. By the envelope
    theorem,

    <eqnarray|<tformat|<table|<row|<cell|<frac|d*v<rsub|i><around|(|\<theta\><rsub|i>|)>|d*\<theta\><rsub|i>>>|<cell|=>|<cell|<frac|\<partial\>*<around|{|F<around|(|w<around|(|p<rsub|i>|)>|)><rsup|n-1>*<around|(|p<rsub|i>*r<rsub|s>-C<around|(|\<theta\><rsub|i>,r<rsub|s>|)>|)>|}>|\<partial\>*\<theta\><rsub|i>><mid|\|><rsub|p<rsub|i>=p<rsub|i><around|(|\<theta\><rsub|i>|)>><eq-number>>>|<row|<cell|>|<cell|=>|<cell|-F<around|(|w<around|(|p<rsub|i>|)>|)><rsup|n-1><frac|\<partial\>*C<around|(|\<theta\><rsub|i>,r<rsub|s>|)>|\<partial\>*\<theta\><rsub|i>><eq-number>>>|<row|<cell|>|<cell|=>|<cell|-F<around|(|\<theta\><rsub|i>|)><rsup|n-1><frac|\<partial\>*C<around|(|\<theta\><rsub|i>,r<rsub|s>|)>|\<partial\>*\<theta\><rsub|i>><eq-number>>>>>>

    Since <math|p<around|(|\<theta\><rsub|i>|)>> is decreasing, the lowest
    type player must win zero expected profit, i.e.,
    <math|v<rsub|i><around|(|<wide*|\<theta\>|\<bar\>>|)>=0>. Thus,

    <\equation>
      v<rsub|i><around|(|\<theta\><rsub|i>|)>=<big|int><rsub|<wide*|\<theta\>|\<bar\>>><rsup|\<theta\><rsub|i>>-F<around|(|\<theta\>|)><rsup|n-1><frac|\<partial\>*C<around|(|\<theta\>,r<rsub|s>|)>|\<partial\>*\<theta\>>*d*\<theta\>.<label|eq:valuefunction>
    </equation>

    We now use<nbsp><eqref|eq:expectedprofit>
    and<nbsp><eqref|eq:valuefunction> to solve for the optimal pricing
    function:

    <eqnarray|<tformat|<table|<row|<cell|p<rsub|i><around|(|\<theta\><rsub|i>|)>>|<cell|=>|<cell|p<around|(|\<theta\><rsub|i>|)><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<frac|1|r<rsub|s>>*<around*|{|<frac|v<rsub|i><around|(|\<theta\><rsub|i>|)>|F<around|(|w<around|(|p<rsub|i>|)>|)><rsup|n-1>>+C<around|(|\<theta\><rsub|i>,r<rsub|s>|)>|}><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<frac|1|r<rsub|s>>*<around*|{|C<around|(|\<theta\><rsub|i>,r<rsub|s>|)>-<frac|<big|int><rsub|<wide*|\<theta\>|\<bar\>>><rsup|\<theta\><rsub|i>>F<around|(|\<theta\>|)><rsup|n-1><frac|\<partial\>*C<around|(|\<theta\>,r<rsub|s>|)>|\<partial\>*\<theta\>>*d*\<theta\>|F<around|(|\<theta\><rsub|i>|)><rsup|n-1>>|}><eq-number>>>>>>
  </proof>

  The case of an elastic source can be treated in a similar way. We omit the
  proof here and simply state the result.

  <\theorem>
    If the source is elastic, in any Bayesian Nash Equilibrium, the price
    function satisfies the following differential equations:

    <eqnarray|<tformat|<table|<row|<cell|<frac|d*w<rsub|i><around|(|p<rsub|i>|)>|d*p<rsub|i>>>|<cell|=>|<cell|<frac|F<rsub|i><around|(|w<rsub|i><around|(|p<rsub|i>|)>|)>|<around|(|n-1|)>*f<rsub|i><around|(|w<rsub|i><around|(|p<rsub|i>|)>|)>><around*|{|<frac|-<around|(|n-2|)>(r<rsub|s>-r<rsub|0><around|(|p<rsub|i>|)>|p<rsub|i>*r<rsub|s>-C<rsub|i>*<around|(|w<rsub|i><around|(|p|)>,r<rsub|s>-r<rsub|0>|)>>|\<nobracket\>><eq-number>>>|<row|<cell|>|<cell|>|<cell|-<frac|-<frac|d*r<rsub|0><around|(|p<rsub|i>|)>|d*p<rsub|i>>*<around|(|p<rsub|i>-<frac|\<partial\>*C<rsub|i>*<around|(|\<theta\><rsub|i>,r<rsub|s>-r<rsub|0>|)>|\<partial\>*<around|(|r<rsub|s>-r<rsub|0>|)>>|)>)|p<rsub|i>*r<rsub|s>-C<rsub|i>*<around|(|w<rsub|i><around|(|p|)>,r<rsub|s>-r<rsub|0>|)>><eq-number><label|Elastic
    Equation>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|+<big|sum><rsub|j\<neq\>i><frac|r<rsub|s>+<frac|d*r<rsub|s><around|(|p<rsub|i>|)>|d*p<rsub|i>>*<around|(|p<rsub|i>-<frac|\<partial\>*C<rsub|i>*<around|(|\<theta\><rsub|i>,r<rsub|s>-r<rsub|0>|)>|\<partial\>*<around|(|r<rsub|s>-r<rsub|0>|)>>|)>|p<rsub|i>*r<rsub|s>-C<rsub|j>*<around|(|w<rsub|j><around|(|p|)>,r<rsub|s>-r<rsub|0>|)>>|}><eq-number>>>>>>

    where <math|p<rsub|i><around|(|\<theta\><rsub|i>|)>> is given by the
    inverse of <math|w<rsub|i><around|(|p<rsub|i>|)>>.
  </theorem>

  <subsection|<protect><with|font-size|1.19|font-shape|slanted|Efficiency
  Analysis>>

  In this section, we measure the inefficiency introduced by the pricing game
  with incomplete information. We shall use the useful measure <em|price of
  anarchy>, defined for each given type vector <math|\<theta\>>.

  <\definition>
    The price of anarchy <math|\<rho\><around|(|\<theta\>|)>> for a given
    type vector <math|\<theta\>> in the incomplete information game is

    <\equation>
      \<rho\><around|(|\<theta\>|)>=<frac|max<rsub|r<rsub|i>\<in\>R<rsup|E>>
      <big|sum><rsub|i>C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>|min<rsub|r<rsub|i>\<in\>R>
      <big|sum><rsub|i>C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
    </equation>

    where <math|R<rsup|E>> is the set of all traffic allocations
    corresponding to Bayesian Nash equilibria, and <math|R> is the set of all
    feasible traffic allocations.
  </definition>

  We shall focus on the case of an inelastic source. The elastic source case
  is similar. We consider the symmetric situation where
  <math|F<rsub|i><around|(|\<theta\><rsub|i>|)>=F<around|(|\<theta\><rsub|i>|)>>
  and <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>=C<around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
  for all <math|i>. In the case where all relays bid linear charging
  functions, the highest type relay will receive all the traffic. Here, the
  price of anarchy is determined by

  <\equation>
    \<rho\><around|(|\<theta\>|)>=<frac|C<around|(|max<rsub|i\<in\>I>
    \<theta\><rsub|i>,r<rsub|s>|)>|min<rsub|<math-bf|r>\<in\>R>
    <with|math-display|true|<big|sum><rsub|i>C<around|(|\<theta\><rsub|i>,r<rsub|i>|)>>>
  </equation>

  We develop the following bound on <math|\<rho\><around|(|\<theta\>|)>>.

  <\theorem>
    <label|Efficiency1>In the symmetric linear pricing game with incomplete
    information, if the marginal cost function
    <math|c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>=<frac|\<partial\>*C<around|(|\<theta\><rsub|i>,r<rsub|i>|)>|\<partial\>*r<rsub|i>>>
    is concave, then <math|\<rho\><around|(|\<theta\>|)>\<leq\>n>, where
    <math|n> is the number of relays, with equality if and only if
    <math|c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>> is linear in
    <math|r<rsub|i>> and the relay types <math|\<theta\><rsub|i>> are all the
    same.<label|thm:pa1>
  </theorem>

  <\proof>
    Let <math|<around|(|r<rsub|i><rsup|\<ast\>>|)><rsub|i=1><rsup|n>=<around|(|a<rsub|i>*r<rsub|s>|)><rsub|i=1><rsup|n>>
    be the socially optimal allocation for a given type realization
    <math|\<theta\>>, where <math|<big|sum><rsub|i=1><rsup|n>a<rsub|i>=1> and
    <math|a<rsub|i>\<geq\>0> for all <math|i>. Thus the optimal cost is

    <\equation>
      C<rsup|\<ast\>>=<big|sum><rsub|i=1><rsup|n><big|int><rsub|0><rsup|a<rsub|i>*r<rsub|s>>c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>*d*r<rsub|i><label|eq:optcost>
    </equation>

    Since <math|c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>> is concave, it can
    be shown that <math|<big|int><rsub|0><rsup|a<rsub|i>*r<rsub|s>>c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>*d*r<rsub|i>\<geq\>a<rsub|i><rsup|2>*<big|int><rsub|0><rsup|r<rsub|s>>c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>*d*r<rsub|i>>,
    where equality holds if and only if <math|c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
    is linear in <math|r<rsub|i>>. Thus we have

    <\equation>
      C<rsup|\<ast\>>\<geq\><big|sum><rsub|i=1><rsup|n>a<rsub|i><rsup|2>*<big|int><rsub|0><rsup|r<rsub|s>>c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>*d*r<rsub|i><label|C*>
    </equation>

    Therefore,

    <eqnarray|<tformat|<table|<row|<cell|\<rho\><around|(|\<theta\>|)>>|<cell|=>|<cell|<frac|<big|int><rsub|0><rsup|r<rsub|s>>c<around|(|max<rsub|i>
    \<theta\><rsub|i>,r<rsub|i>|)>*d*r<rsub|i>|<big|sum><rsub|i=1><rsup|n><big|int><rsub|0><rsup|a<rsub|i>*r<rsub|s>>c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>*d*r<rsub|i>>>>|<row|<cell|>|<cell|\<leq\>>|<cell|<frac|<big|int><rsub|0><rsup|r<rsub|s>>c<around|(|max<rsub|i>
    \<theta\><rsub|i>,r<rsub|i>|)>*d*r<rsub|i>|<big|sum><rsub|i=1><rsup|n>a<rsub|i><rsup|2>*<big|int><rsub|0><rsup|r<rsub|s>>c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>*d*r<rsub|i>><eq-number>>>|<row|<cell|>|<cell|\<leq\>>|<cell|<frac|<big|int><rsub|0><rsup|r<rsub|s>>c<around|(|max<rsub|i>
    \<theta\><rsub|i>,r<rsub|i>|)>*d*r<rsub|i>|<big|sum><rsub|i=1><rsup|n>a<rsub|i><rsup|2>*<big|int><rsub|0><rsup|r<rsub|s>>c<around|(|max<rsub|i>
    \<theta\><rsub|i>,r<rsub|i>|)>*d*r<rsub|i>>=<frac|1|<big|sum><rsub|i=1><rsup|n>a<rsub|i><rsup|2>>\<leq\>n>>>>>

    where the second inequality follows from the assumption that
    <math|\<partial\><rsup|2>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>/\<partial\>*\<theta\><rsub|i>*\<partial\>*r<rsub|i>\<leq\>0>.
    Equality obtains in all three previous inequalities if
    <math|c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>> is linear in
    <math|r<rsub|i>> and the relay types <math|\<theta\><rsub|i>> are all the
    same.
  </proof>

  Next, we give a general bound on the price of anarchy for all cost
  functions satisfying our assumptions in Section<nbsp><reference|model>.

  <\theorem>
    <label|Efficiency2>In the symmetric linear pricing game with incomplete
    information, let the support set for each <math|\<theta\><rsub|i>> be
    <math|\<Theta\>\<triangleq\><lbrack><wide*|\<theta\>|\<bar\>>,<wide|\<theta\>|\<bar\>>]>.
    If the marginal cost function <math|c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>=<frac|\<partial\>*C<around|(|\<theta\><rsub|i>,r<rsub|i>|)>|\<partial\>*r<rsub|i>>>
    satisfies <math|<frac|c<around|(|<wide*|\<theta\>|\<bar\>>,r<rsub|s>|)>|c<around|(|<wide|\<theta\>|\<bar\>>,0|)>>\<leq\>k>
    for some constant <math|k>, then <math|\<rho\><around|(|\<theta\>|)>\<leq\>k>.
  </theorem>

  <\proof>
    Since <math|C<around|(|\<theta\><rsub|i>,r<rsub|i>|)>> is convex in
    <math|r<rsub|i>> and <math|\<partial\><rsup|2>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>/\<partial\>*\<theta\><rsub|i>*\<partial\>*r<rsub|i>\<leq\>0>
    by assumption, <math|c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>\<geq\>c<around|(|\<theta\><rsub|i>,0|)>\<geq\>c<around|(|max<rsub|i>
    \<theta\><rsub|i>,r<rsub|i>|)>\<geq\>c<around|(|<wide|\<theta\>|\<bar\>>,0|)>>.
    Also <math|c<around|(|max<rsub|i> \<theta\><rsub|i>,r<rsub|i>|)>\<leq\>c<around|(|<wide*|\<theta\>|\<bar\>>,r<rsub|s>|)>>.
    Thus, <math|<big|sum><rsub|i=1><rsup|n><big|int><rsub|0><rsup|a<rsub|i>*r<rsub|s>>c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>*d*r<rsub|i>>
    <math|\<geq\>c<around|(|<wide|\<theta\>|\<bar\>>,0|)>*r<rsub|s>>, and
    <math|<big|int><rsub|0><rsup|r<rsub|s>>c<around|(|max<rsub|i>
    \<theta\><rsub|i>,r<rsub|i>|)>*d*r<rsub|i>>
    <math|\<leq\>c<around|(|<wide*|\<theta\>|\<bar\>>,r<rsub|s>|)>*r<rsub|s>>.
    The result follows.
  </proof>

  Recall our result that all Nash equilibria in the complete information
  pricing game are efficient, including any which results from linear
  pricing. Thus, we see that incomplete information can introduce
  inefficiencies. The main insight is that in an incomplete information
  pricing game, the relays cannot calculate the socially optimal traffic
  allocation due to the lack of information regarding types. Therefore, the
  relays cannot bid the marginal cost at the socially optimal outcome as the
  price, Thus, the game cannot reach an efficient Nash Equilibrium.

  Although Bayesian Nash Equilibria are not efficient in the symmetric linear
  pricing game with incomplete information, they satisfy an asymptotic
  efficient property: the outcome of the Bayesian Nash Equilibrium when
  <math|r<rsub|s>> goes to zero is efficient. To see this, note that by
  <cite|Lebrun99>, all the relay pricing functions in the symmetric case are
  the same and decreasing. Thus the highest type relay will always get all
  the traffic. When <math|r<rsub|s>> goes to zero, the efficient allocation
  also allocates all the traffic to the highest type relay. Thus, in the
  symmetric case, a Bayesian Nash Equilibrium is efficient when
  <math|r<rsub|s>> goes to zero.

  We now show, however, that in the asymmetric linear pricing game with
  incomplete information, the Bayesian Nash Equilibria are not efficient even
  when <math|r<rsub|s>> goes to zero. We focus on the case of two relays,
  where the cost functions of the relays are identical, but the distributions
  of the types are different. Using Theorem 2, we obtain the following
  differential equations:

  <eqnarray*|<tformat|<table|<row|<cell|<frac|d*w<rsub|1>|d*p>>|<cell|=>|<cell|-<frac|r<rsub|s>*F<rsub|1><around|(|w<rsub|1><around|(|p|)>|)>|<around|(|p*r<rsub|s>-C<around|(|w<rsub|2>,r<rsub|s>|)>|)>*f<rsub|1><around|(|w<rsub|1>|)>>>>|<row|<cell|<frac|d*w<rsub|2>|d*p>>|<cell|=>|<cell|-<frac|r<rsub|s>*F<rsub|2><around|(|w<rsub|2><around|(|p|)>|)>|<around|(|p*r<rsub|s>-C<around|(|w<rsub|1>,r<rsub|s>|)>|)>*f<rsub|2><around|(|w<rsub|2>|)>>>>>>>

  Explicitly solving for the solution is difficult, but we can observe some
  properties of the solution. First, we must have

  <\equation*>
    p<rsub|1><around|(|<wide|\<theta\>|\<bar\>>|)>=p<rsub|2><around|(|<wide|\<theta\>|\<bar\>>|)>=p<rsub|min>.
  </equation*>

  This is because if the relay prices for the highest type are not the same,
  then the relay with the higher price will lower its price to increase its
  probability of winning the game, thus increasing the expected revenue. From
  the differential equations, we obtain

  <\equation>
    w<rsub|1><around|(|p|)>=<wide|\<theta\>|\<bar\>>-<big|int><rsub|p<rsub|min>><rsup|p><frac|r<rsub|s>*F<rsub|1><around|(|w<rsub|1><around|(|p|)>|)>|<around|(|p*r<rsub|s>-C<around|(|w<rsub|2><around|(|p|)>,r<rsub|s>|)>|)>*f<rsub|1><around|(|w<rsub|1><around|(|p|)>|)>>*d*p
  </equation>

  <\equation>
    w<rsub|2><around|(|p|)>=<wide|\<theta\>|\<bar\>>-<big|int><rsub|p<rsub|min>><rsup|p><frac|r<rsub|s>*F<rsub|2><around|(|w<rsub|2><around|(|p|)>|)>|<around|(|p*r<rsub|s>-C<around|(|w<rsub|1><around|(|p|)>,r<rsub|s>|)>|)>*f<rsub|2><around|(|w<rsub|2><around|(|p|)>|)>>*d*p
  </equation>

  For a given <math|p>, let <math|\<theta\><rsub|1>> and
  <math|\<theta\><rsub|2>> be such that <math|p<rsub|1><around|(|\<theta\><rsub|1>|)>=p<rsub|2><around|(|\<theta\><rsub|2>|)>=p>.
  From the above equations, it is clear that
  <math|w<rsub|1><around|(|p|)>\<neq\>w<rsub|2><around|(|p|)>>, i.e.
  <math|\<theta\><rsub|1>\<neq\>\<theta\><rsub|2>>. Therefore, we have a
  situation where two relays with different type propose the same price. When
  this realization occurs, the highest type relay does not carry all the
  traffic, even when <math|r<rsub|s>> goes to zero. Thus, in the asymmetric
  case, the Bayesian Nash Equilibrium is not asymptotic efficient as
  <math|r<rsub|s>> goes to zero.

  <section|<protect><with|font-size|1.19|font-shape|slanted|Games with Full
  Source Bargaining Power>>

  In the discussion thus far, the source has limited bargaining power, and
  passively reacts to the relays' signals, which are equivalent to charging
  functions. The source can only allocate its traffic to minimize its cost in
  withheld traffic plus the total transfer payment to the relays. In this
  section, we examine the scenario where the source has full bargaining
  power, in the sense that the contract announced by the source is not
  limited to the one described in<nbsp><eqref|eq:sourcenobargain1>-<eqref|eq:sourcenobargain2>.
  We first investigate the (Bayesian) Nash equilibria which can result from
  games with source bargaining power in the case of complete information.
  Here, we show that all (Bayesian) Nash equilibria are efficient. Then, we
  proceed to the case of incomplete information, and characterize the
  potential inefficiencies associated with that case.

  <subsection|<protect><with|font-size|1.19|font-shape|slanted|Games with
  Complete Information>>

  In a game with source bargaining power and complete information, the source
  can observe the type vector <math|\<theta\>=<around|(|\<theta\><rsub|1>,\<ldots\>,\<theta\><rsub|n>|)>>
  of the relays, and then design the allocation map <math|g> according to
  <math|\<theta\>>. Since the type <math|\<theta\><rsub|i>> is not private to
  relay <math|i>, relay <math|i> cannot manipulate this information in
  designing its signalling strategy <math|s<rsub|i>>. Since the source can
  observe <math|\<theta\>>, it can effectively ignore the strategies of the
  relays in designing <math|g>. Nevertheless, the source needs to ensure that
  the relays will accept its proposed contract and stay in the game. The
  latter will hold as long as <math|U<rsub|i><around|(|\<theta\><rsub|i>,g<around|(|\<theta\>|)>|)>=t<rsub|i>-C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>\<geq\>0>
  for all <math|i>. That is, all relays receive non-negative utility by
  accepting the contract proposed by the source, and therefore are willing to
  participate in the game.

  <\lemma>
    In any (Bayesian) Nash Equilibrium of the complete information game with
    source bargaining power, all relays receive zero
    utility.<label|lemma:zero>
  </lemma>

  <\proof>
    Suppose that there exists a (Bayesian) Nash Equilibrium where the source
    allocation rule

    <\equation*>
      g<around|(|m<rsub|1>|(>\<cdot\>),...,m<rsub|n>(\<cdot\><around|)||)>=<around|(|<math-bf|r>,<math-bf|t>|)>
    </equation*>

    is such that <math|U<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>,t<rsub|i>|)>=t<rsub|i>-C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>\<gtr\>0>
    for some <math|i>. Since the source can observe <math|\<theta\>>, it
    could select another allocation rule <math|g<rprime|'><around|(|m<rsub|1>|(>\<cdot\>),...,m<rsub|n>(\<cdot\><around|)||)>=<around|(|<math-bf|r><rprime|'>,<math-bf|t><rprime|'>|)>>
    such that

    <\equation*>
      r<rprime|'><rsub|i>=r<rsub|i>,i=1,\<ldots\>,n;<space|1em>t<rprime|'><rsub|i>=t<rsub|i>-\<epsilon\>,<space|0.27em><space|0.27em>t<rprime|'><rsub|j>=t<rsub|j><nbsp><text|for
      all><nbsp>j\<neq\>i
    </equation*>

    where <math|\<epsilon\>> is small enough so that
    <math|t<rprime|'><rsub|i>-C<rsub|i><around|(|\<theta\><rsub|i>,r<rprime|'><rsub|i>|)>\<gtr\>0>.
    Note that the set of relays which would opt to accept contract <math|g>
    and stay in the game is the same as the set for contract
    <math|g<rprime|'>>. On the other hand, by shifting its allocation rule
    from <math|g> to <math|g<rprime|'>>, the source has strictly decreased
    its total transfer payment, while keeping the same traffic allocation.
    Thus, the source's utility is strictly increased. This contradicts our
    assumption of being at a Nash equilibrium.
  </proof>

  <\theorem>
    In the complete information game with source bargaining power, all
    (Bayesian) Nash equilibria are efficient.<label|thm:completebargain>
  </theorem>

  <\proof>
    At any Nash equilibrium, the source maximizes its utility

    <\equation*>
      U<rsub|s>(\<theta\><rsub|s>,g<around|(|s<rsub|1><around|(|\<theta\><rsub|1>|)>,\<ldots\>,s<rsub|n><around|(|\<theta\><rsub|n>|)>|)>=W<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|s>|)>-C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>-<big|sum><rsub|i=1><rsup|n>t<rsub|i>.
    </equation*>

    By Lemma<nbsp><reference|lemma:zero>, at the equilibrium, we have
    <math|t<rsub|i>=C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>> for
    all <math|i>. Thus, the traffic allocation by the source minimizes
    <math|C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>+<big|sum><rsub|i=1><rsup|n>C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>>,
    and therefore the equilibrium is efficient.
  </proof>

  Using Lemma<nbsp><reference|lemma:zero> and
  Theorem<nbsp><reference|thm:completebargain>, we can easily solve for the
  Nash equilibrium of the complete information game with source bargaining
  power. By Theorem<nbsp><reference|thm:completebargain>, the source
  allocation rule at the equilibrium may be obtained by solving for the
  socially optimal traffic allocation <math|<math-bf|r><rsup|\<ast\>>>, where
  <math|<math-bf|r><rsup|\<ast\>>=arg max<rsub|<math-bf|r>\<in\>R>
  C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>+<big|sum><rsub|i=1><rsup|n>C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>>.
  As noted in Section<nbsp><reference|sec:efficient>, due to the strict
  convexity of the optimization problem, <math|<math-bf|r><rsup|\<ast\>>>
  exists and is unique. By Lemma<nbsp><reference|lemma:zero>, at the
  equilibrium, the transfer payment <math|t<rsub|i>=C<rsub|i><around|(|\<theta\><rsub|i>,r<rsup|\<ast\>><rsub|i>|)>>
  for every <math|i=1,\<ldots\>,n>.<footnote|Recall that
  <math|C<rsub|i><around|(|\<theta\><rsub|i>,0|)>=0>.> For the relays, any
  feasible signal map <math|s<rsub|i>> may be chosen for the equilibrium.

  To see why this constitutes an equilibrium, note the following sequence of
  events in the game with source bargaining power. First, each relay <math|i>
  observes its type <math|\<theta\><rsub|i>>. Second, the source provides the
  contract <math|g:M\<rightarrow\><around|(|<math-bf|r><rsup|\<ast\>>,<math-bf|t>|)>>,
  where <math|<math-bf|r><rsup|\<ast\>>> is the socially optimal traffic
  allocation, and <math|t<rsub|i>=C<rsub|i><around|(|\<theta\><rsub|i>,r<rsup|\<ast\>><rsub|i>|)>>
  for every <math|i>. Note that <math|g> is independent of the signals sent
  by the relays. Third, the relays accept the mechanism because they each
  receive zero utility, and therefore are indifferent with respect to
  carrying traffic or not. Fourth and finally, the relay nodes will play
  signal map <math|s<rsub|i>> without deviation, since the source allocation
  map is independent of the relays' signals. Thus, the Nash equilibrium holds
  and is unique.

  <subsection|<protect><with|font-size|1.19|font-shape|slanted|Games with
  Incomplete Information>>

  We now turn to the case that source cannot observe the type of relay. Thus
  the relay nodes can manipulate their types in order to get more utility,
  and the source can no longer design the allocation according to
  <math|\<theta\>>. As in incomplete information games without bargaining
  power, the source must maximize the expectation of profits according to the
  signals sent by relays. The characterization of Bayesian Nash Equilibria
  for this case is very difficult due to the complexity of the strategy set
  and the possible behaviors of source and relays. Nevertheless, we devise a
  method for characterizing outcomes corresponding to the Bayesian Nash
  Equilibria which avoids the difficulty of calculating the the equilibria
  explicitly. We shall do this in two steps. First, we show that if a
  resource allocation outcome can be realized by a Bayesian Nash equilibrium
  for a game with source bargaining in which every relay receives
  non-negative expected utility, then there exists a \Ptruth telling"
  Bayesian Nash equilibrium that realizes the outcome. Second, we show that
  the set of outcomes for the \Ptruth telling" Bayesian Nash equilibria is
  included in the set of outcomes for the Nash equilibria for a <em|complete
  information game>, in which the link cost functions are replaced by a
  specified \Pvirtual cost functions."

  <\definition>
    A Bayesian Nash Equilibrium of the game with bargaining power is truth
    telling if <math|M=\<Theta\>> and every relay node is willing to report
    their true type to the source node.
  </definition>

  <\theorem>
    <label|thm:revelation>If a resource allocation outcome <math|f> can be
    realized by a Bayesian Nash Equilibrium of the game with source
    bargaining power, in which every relay receives non-negative expected
    utility, then there exists a truth telling Bayesian Nash Equilibrium
    which realizes <math|f>.
  </theorem>

  <\proof>
    Suppose there is a Bayesian Nash Equilibrium which realizes the
    allocation outcome <math|f<around|(|\<theta\>|)>>. By the definition of
    the Bayesian Nash Equilibrium, we have<nbsp><eqref|eq:relayopt>
    and<nbsp><eqref|eq:sourceopt>. Now observe that
    by<nbsp><eqref|eq:relayopt>, we must have

    <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|i>>|<cell|\<in\>>|<cell|arg
    max<rsub|<wide|\<theta\><rsub|i>|~>> E<rsub|\<theta\><rsub|-i>><around*|{|U<rsub|i><around|(|\<theta\><rsub|i>,g<around|(|s<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>|)>,s<rsub|-i><around|(|\<theta\><rsub|-i>|)>|)>|)>|}><eq-number>>>>>>

    for all <math|i>. Otherwise, if there exists some
    <math|\<theta\><rprime|'>> such that <math|E<rsub|\<theta\><rsub|-i>><around*|{|U<rsub|i><around|(|\<theta\><rsub|i>,g<around|(|s<rsub|i><around|(|\<theta\><rsub|i><rprime|'>|)>,s<rsub|-i><around|(|\<theta\><rsub|-i>|)>|)>|)>|}>>
    <math|\<gtr\>E<rsub|\<theta\><rsub|-i>><around*|{|U<rsub|i><around|(|\<theta\><rsub|i>,g<around|(|s<rsub|i><around|(|\<theta\><rsub|i>|)>,s<rsub|-i><around|(|\<theta\><rsub|-i>|)>|)>|)>|}>>,
    then there is another strategy <math|s<rsub|i><rprime|'><around|(|\<theta\>|)>>
    satisfying <math|s<rsub|i><rprime|'><around|(|\<theta\><rsub|i>|)>=s<rsub|i><around|(|\<theta\><rsub|i><rprime|'>|)>>
    and <math|s<rsub|i><rprime|'><around|(|\<theta\>|)>=s<rsub|i><around|(|\<theta\>|)>>
    for all <math|\<theta\>\<neq\>\<theta\><rsub|i>>, such that
    <math|E<rsub|\<theta\><rsub|-i>><around*|{|U<rsub|i><around|(|\<theta\><rsub|i>,g<around|(|s<rsub|i><rprime|'><around|(|\<theta\><rsub|i>|)>,s<rsub|-i><around|(|\<theta\><rsub|-i>|)>|)>|)>|}>>
    <math|\<gtr\>E<rsub|\<theta\><rsub|-i>><around*|{|U<rsub|i><around|(|\<theta\><rsub|i>,g<around|(|s<rsub|i><around|(|\<theta\><rsub|i>|)>,s<rsub|-i><around|(|\<theta\><rsub|-i>|)>|)>|)>|}>>,
    violating<nbsp><eqref|eq:relayopt>. Therefore, since
    <math|g<around|(|s<rsub|1><around|(|\<theta\><rsub|1>|)>,\<ldots\>,s<rsub|n><around|(|\<theta\><rsub|n>|)>|)>=f<around|(|\<theta\>|)>>,
    we have

    <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|i>>|<cell|\<in\>>|<cell|arg
    max<rsub|<wide|\<theta\><rsub|i>|~>\<in\>\<Theta\><rsub|i>>
    E<rsub|\<theta\><rsub|-i>><around*|{|U<rsub|i><around|(|\<theta\><rsub|i>,f<around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|)>|}>*<space|0.27em><space|0.27em><text|for<nbsp>all<nbsp>>i<space|0.27em><space|0.27em><eq-number><label|eq:truth1>>>|<row|<cell|f>|<cell|\<in\>>|<cell|arg
    max<rsub|<wide|f|~>> E<rsub|\<theta\>><around*|{|U<rsub|s><around|(|\<theta\><rsub|s>,<wide|f|~><around|(|\<theta\>|)>|)>|}>.<eq-number><label|eq:truth2>>>>>>

    Thus, there exists a direct truth telling Bayesian Nash Equilibrium with
    the outcome <math|f<around|(|\<theta\>|)>>.
  </proof>

  Theorem <reference|thm:revelation> says that the set of outcomes
  corresponding to Bayesian Nash Equilibria for the game with source
  bargaining power and incomplete information is a subset of the outcomes
  corresponding to truth telling Bayesian Nash Equilibria, in which each
  relay proposes its type truthfully to the source, and the source optimally
  allocates rates according to the relays' types. This finding simplifies our
  analysis considerably, since we can now focus on the truth telling Bayesian
  Nash Equilibria in order to bound the efficiency loss introduced by
  incomplete information in games with source bargaining power.

  We now investigate the outcomes which can be realized by truth telling
  Bayesian Nash Equilibria. Notice that these equilibria correspond to the
  solutions of the optimization problem given by<nbsp><eqref|eq:truth1>
  and<nbsp><eqref|eq:truth2>, in addition to the non-negative expected
  utility constraint

  <\equation>
    E<rsub|\<theta\><rsub|-i>><around*|{|U<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>|}>=E<rsub|\<theta\><rsub|-i>>*<around*|{|t<rsub|i><around|(|<with|math-font-family|bf|\<theta\>>,<math-bf|r>|)>-C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|\<theta\>|)>|)>|}>\<geq\>0<label|eq:nonnegative>
  </equation>

  for all <math|i>, and feasibility constraint <math|<math-bf|r>\<in\>R>.

  <\theorem>
    The set of solutions for the optimization problem defined
    by<nbsp><eqref|eq:truth1>-<eqref|eq:nonnegative> is included in the set
    of outcomes corresponding to the Nash equilibria for the complete
    information game in which the link cost functions
    <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>> are replaced by

    <\equation>
      J<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>=C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>-<frac|1-F<rsub|i><around|(|\<theta\><rsub|i>|)>|f<rsub|i><around|(|\<theta\><rsub|i>|)>>*<frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>|\<partial\>*\<theta\><rsub|i>>.<label|Virtual
      Cost>
    </equation>

    <label|thm:virtual>
  </theorem>

  <\proof>
    Please see the Appendix.
  </proof>

  We refer to the functions <math|J<rsub|i>> as <em|virtual cost functions>.
  Note that by Theorem<nbsp><reference|thm:completebargain>, all Nash
  equilibria corresponding to games with complete information are efficient.
  Thus, the set of outcomes corresponding to the Nash equilibria for the
  complete information game with virtual link cost functions
  <math|J<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>> is given by

  <\equation*>
    <math-bf|r><rprime|'>=arg min<rsub|<math-bf|r>\<in\>R>
    C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>+<big|sum><rsub|i=1><rsup|n>J<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>.
  </equation*>

  If <math|J<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>> is strictly
  convex in <math|r<rsub|i>> for all <math|i>, then the optimization problem
  has a unique solution. For instance, if all the relays' types
  <math|\<theta\><rsub|i>> are uniformly distributed on
  <math|<around|[|0,1|]>>, and the cost functions are given by
  <math|<frac|1|\<theta\><rsub|i>>*<around|(|e<rsup|r<rsub|i>>-1|)>>, then
  <math|J<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>=C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>-<frac|1-F<rsub|i><around|(|\<theta\><rsub|i>|)>|f<rsub|i><around|(|\<theta\><rsub|i>|)>>*<frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>|\<partial\>*\<theta\><rsub|i>>=<frac|1|\<theta\><rsub|i><rsup|2>>*<around|(|e<rsup|r<rsub|i>>-1|)>>,
  which is strictly convex in <math|r<rsub|i>> and strictly decreasing in
  <math|\<theta\><rsub|i>>. In this case, if a Bayesian Nash Equilibrium of
  the game with source bargaining power exists, then the corresponding
  traffic allocation is the solution of the optimization problem. In general,
  the set of traffic allocations corresponding to the Bayesian Nash
  Equilibria (of the game with source bargaining power) is a subset of the
  solution set for the optimization. In the next section, we use this fact to
  bound the efficiency loss for games with incomplete information.

  <subsection|<protect><with|font-size|1.19|font-shape|slanted|Efficiency
  Analysis>>

  In this section, we bound the amount of inefficiency in the outcomes for
  games with incomplete information. We focus on the inelastic scenario where
  <math|r<rsub|0>=0>. Following<nbsp><cite|Roughgarden02>, define the price
  of anarchy for type <math|\<theta\>> as:

  <\equation>
    \<rho\><around|(|\<theta\>|)>=<frac|max<rsub|<math-bf|r>\<in\>R<rsup|E>>
    <big|sum><rsub|i>C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>|min<rsub|<math-bf|r>\<in\>R>
    <big|sum><rsub|i>C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
  </equation>

  where <math|R<rsup|E>> is the set of all Bayesian Nash Equilibria for the
  game with incomplete information. Let <math|R<rsup|J>\<equiv\>arg
  min<rsub|<math-bf|r>\<in\>R> <big|sum><rsub|i>J<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>>.
  By Theorems<nbsp><reference|thm:revelation>
  and<nbsp><reference|thm:virtual>, we have
  <math|R<rsup|E>\<subseteq\>R<rsup|J>>. Therefore,

  <\equation>
    \<rho\><around|(|\<theta\>|)>\<leq\><frac|max<rsub|<math-bf|r>\<in\>R<rsup|J>>
    <big|sum><rsub|i>C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>|min<rsub|<math-bf|r>\<in\>R>
    <big|sum><rsub|i>C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
  </equation>

  Since the link cost functions are strictly convex, the socially optimal
  allocation <math|<math-bf|r><rsup|\<ast\>>> are given by the necessary and
  sufficient conditions in<nbsp><eqref|eq:optcond>. An allocation
  <math|<math-bf|r><rprime|'>> in <math|R<rsup|J>> must satisfy the following
  necessary conditions: for all <math|i\<in\><around|{|1,\<ldots\>,n|}>> such
  that <math|r<rsub|i><rprime|'>\<gtr\>0>,

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|<frac|\<partial\>*C<around|(|\<theta\><rsub|i>,r<rsub|i><rprime|'>|)>|\<partial\>*r<rsub|i>>-<frac|1-F<rsub|i><around|(|\<theta\><rsub|i>|)>|f<rsub|i><around|(|\<theta\><rsub|i>|)>>*<frac|\<partial\><rsup|2>*C<around|(|\<theta\><rsub|i>,r<rsub|i><rprime|'>|)>|\<partial\>*\<theta\><rsub|i>*\<partial\>*r<rsub|i>><eq-number><label|Virtual
  Optimality>>>|<row|<cell|>|<cell|\<leq\>>|<cell|<frac|\<partial\>*C<around|(|\<theta\><rsub|j>,r<rsub|j><rprime|'>|)>|\<partial\>*r<rsub|j>>-<frac|1-F<rsub|j><around|(|\<theta\><rsub|j>|)>|f<rsub|j><around|(|\<theta\><rsub|j>|)>>*<frac|\<partial\><rsup|2>*C<around|(|\<theta\><rsub|i>,r<rsub|j><rprime|'>|)>|\<partial\>*\<theta\><rsub|i>*\<partial\>*r<rsub|j>>*<space|1em><text|for
  all >j<eq-number>>>>>>

  We now bound the price of anarchy in the symmetric case.

  <\theorem>
    Consider the symmetric case where the link cost functions
    <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>> and the type
    distributions <math|F<rsub|i><around|(|\<theta\><rsub|i>|)>> are the same
    for all relays. If (i) <math|J<around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
    is convex in <math|r<rsub|i>> and decreasing in <math|\<theta\><rsub|i>>,
    (ii) <math|X<around|(|\<theta\><rsub|i>,r<rsub|i>|)>\<equiv\>J<around|(|\<theta\><rsub|i>,r<rsub|i>|)>-C<around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
    is concave in <math|r<rsub|i>>, (iii)
    <math|<frac|\<partial\>*X<around|(|\<theta\><rsub|i>,r<rsub|i>|)>|\<partial\>*\<theta\><rsub|i>*\<partial\>*r<rsub|i>>\<leq\>0>,
    then the price of anarchy <math|\<rho\><around|(|\<theta\>|)>> can be
    upper bounded as follows.

    If the marginal cost function <math|c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>=<frac|\<partial\>*C<around|(|\<theta\><rsub|i>,r<rsub|i>|)>|\<partial\>*r<rsub|i>>>
    is concave, then <math|\<rho\><around|(|\<theta\>|)>\<leq\>n>, where
    <math|n> is the number of relays (with equality if and only if
    <math|c<around|(|\<theta\><rsub|i>,r<rsub|i>|)>> is linear in
    <math|r<rsub|i>> and the relay types <math|\<theta\><rsub|i>> are all the
    same). If <math|<frac|c<around|(|<wide*|\<theta\>|\<bar\>>,r<rsub|s>|)>|c<around|(|<wide|\<theta\>|\<bar\>>,0|)>>\<leq\>k>
    for some constant <math|k>, then <math|\<rho\><around|(|\<theta\>|)>\<leq\>k>.<label|thm:anarchy>
  </theorem>

  Note that for the example where all the relays' types
  <math|\<theta\><rsub|i>> are uniformly distributed on
  <math|<around|[|0,1|]>> and the cost functions are given by
  <math|<frac|1|\<theta\><rsub|i>>*<around|(|e<rsup|r<rsub|i>>-1|)>>, the
  assumptions of the Theorem are satisfied.

  <\proof>
    Let <math|<around|(|r<rsub|i><rprime|'>|)><rsub|i\<in\>I>\<in\>arg
    min<rsub|i> <big|sum><rsub|i>J<around|(|\<theta\><rsub|i>,r<rsub|i>|)>>,
    and <math|<around|(|r<rsub|i><rsup|\<ast\>>|)>> be the efficient
    allocation. We first prove that if <math|\<theta\><rsub|m>\<gtr\>\<theta\><rsub|k>>,
    and <math|r<rsub|m>+r<rsub|k>=r<rsub|m*k>> is fixed,
    <math|r<rsub|m><rprime|'>\<geq\>r<rsub|m><rsup|\<ast\>>>. If for any
    <math|\<theta\><rsub|k>\<less\>\<theta\><rsub|m>>,
    <math|r<rsub|k><rprime|'>=0>, then the inequality immediately holds. We
    then consider the situation that there exists some
    <math|\<theta\><rsub|k>\<less\>\<theta\><rsub|m>> and
    <math|r<rsub|k><rprime|'>\<gtr\>0>. Let
    <math|x<around|(|\<theta\><rsub|i>,r<rsub|i>|)>=<frac|\<partial\>*X<around|(|\<theta\><rsub|i>,r<rsub|i>|)>|\<partial\>*r<rsub|i>>>.
    Thus for the optimal allocation, <math|r<rsub|m><rsup|\<ast\>>\<gtr\>r<rsub|k><rsup|\<ast\>>\<gtr\>0>
    and <math|r<rsub|m><rsup|\<ast\>>+r<rsub|k><rsup|\<ast\>>=r<rsub|m*k>>.
    As <math|x<around|(|\<theta\><rsub|i>,r<rsub|i>|)>> is decreasing in
    <math|\<theta\><rsub|i>>, we have <math|x<around|(|\<theta\><rsub|m>,r<rsub|k><rsup|\<ast\>>|)>\<leq\>x<around|(|\<theta\><rsub|k>,r<rsub|k><rsup|\<ast\>>|)>>.
    As <math|x<around|(|\<theta\><rsub|i>,r<rsub|i>|)>> is decreasing in
    <math|r<rsub|i>>, <math|x<around|(|\<theta\><rsub|m>,r<rsub|m><rsup|\<ast\>>|)>\<leq\>x<around|(|\<theta\><rsub|m>,r<rsub|k><rsup|\<ast\>>|)>>.
    Thus <math|x<around|(|\<theta\><rsub|m>,r<rsub|m><rsup|\<ast\>>|)>\<leq\>x<around|(|\<theta\><rsub|k>,r<rsub|k><rsup|\<ast\>>|)>>.
    As <math|c<around|(|\<theta\><rsub|m>,r<rsub|m><rsup|\<ast\>>|)>=c<around|(|\<theta\><rsub|k>,r<rsub|k><rsup|\<ast\>>|)>>
    , <math|c<around|(|\<theta\><rsub|m>,r<rsub|m><rsup|\<ast\>>|)>+x<around|(|\<theta\><rsub|m>,r<rsub|m><rsup|\<ast\>>|)>\<leq\>c<around|(|\<theta\><rsub|k>,r<rsub|k><rsup|\<ast\>>|)>+x<around|(|\<theta\><rsub|k>,r<rsub|k><rsup|\<ast\>>|)>>.
    By (<reference|Virtual Optimality>), <math|c<around|(|\<theta\><rsub|m>,r<rsub|m><rprime|'>|)>+x<around|(|\<theta\><rsub|m>,r<rsub|m><rprime|'>|)>\<geq\>c<around|(|\<theta\><rsub|k>,r<rsub|k><rprime|'>|)>+x<around|(|\<theta\><rsub|k>,r<rsub|k><rprime|'>|)>>,
    as <math|r<rsub|k><rprime|'>\<gtr\>0>. As
    <math|r<rsub|k><rsup|\<ast\>>+r<rsub|m><rsup|\<ast\>>=r<rsub|m*k>=r<rsub|k><rprime|'>+r<rsub|m><rprime|'>>,
    and virtual cost function is convex, we have
    <math|r<rsub|m><rprime|'>\<geq\>r<rsub|m><rsup|\<ast\>>>.

    Now we prove that <math|<big|sum><rsub|i>C<around|(|\<theta\><rsub|i>,r<rsub|i><rprime|'>|)>\<leq\>C<around|(|max<rsub|i>
    \<theta\><rsub|i>,r<rsub|s>|)>>. Without loss of generality, we assume
    that <math|\<theta\><rsub|1>\<less\>\<theta\><rsub|2>\<less\>...\<less\>\<theta\><rsub|n>>.
    Any situation where some types are the same can be handled by modifying
    number of relays. We have

    <eqnarray*|<tformat|<table|<row|<cell|>|<cell|>|<cell|min<rsub|<big|sum><rsub|i>r<rsub|i>=r<rsub|s>>
    <big|sum><rsub|i>C<around|(|\<theta\><rsub|i>,r<rsub|i>|)>>>|<row|<cell|>|<cell|=>|<cell|min<rsub|<big|sum><rsub|i>r<rsub|i>=r<rsub|s>><around*|[|C<around|(|\<theta\><rsub|n>,r<rsub|n>|)>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|+min<rsub|<big|sum><rsub|i\<less\>n>r<rsub|i>=r<rsub|s>-r<rsub|n>><around*|[|<big|sum><rsub|i\<gtr\>1>C<around|(|\<theta\><rsub|n-1>,r<rsub|n-1>|)>+min
    ...|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|<around*|\<nobracket\>|+min<rsub|r<rsub|1>+r<rsub|2>=r<rsub|s>-<big|sum><rsub|i\<gtr\>2>r<rsub|i>>
    C<around|(|\<theta\><rsub|2>,r<rsub|2>|)>+C<around|(|\<theta\><rsub|1>,r<rsub|1>|)>|]>*\<cdots\>|]>>>>>>

    As we showed above, <math|r<rsub|i><rprime|'>\<geq\>r<rsub|i><rsup|\<ast\>>>
    given <math|r<rsub|i><rprime|'>+r<rsub|i-1><rprime|'>=r<rsub|i><rsup|\<ast\>>+r<rsub|i-1><rsup|\<ast\>>=r<rsub|i,i-1>>.
    Thus <math|C<around|(|\<theta\><rsub|i>,r<rsub|i,i-1>|)>\<geq\>C<around|(|\<theta\><rsub|i>,r<rsub|i><rprime|'>|)>+C<around|(|\<theta\><rsub|i-1>,r<rsub|i-1><rprime|'>|)>\<geq\>C<around|(|\<theta\><rsub|i>,r<rsub|i><rsup|\<ast\>>|)>+C<around|(|\<theta\><rsub|i-1>,r<rsub|i-1><rsup|\<ast\>>|)>>.
    By induction, we can prove that <math|<big|sum><rsub|i>C<around|(|\<theta\><rsub|i>,r<rsub|i><rprime|'>|)>\<leq\>C<around|(|max<rsub|i>
    \<theta\><rsub|i>,r<rsub|s>|)>>. Now using the same technique as in the
    proofs of Theorems <reference|Efficiency1> and <reference|Efficiency2>,
    we obtain the result.
  </proof>

  If either the virtual cost functions <math|J<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>>
  are not convex, or the link cost functions and type distributions are not
  the same across relays, then higher prices of anarchy may result. Consider
  the situation in Figure 2. Here, there are only two relays.
  <math|<around|(|r<rsub|1><rsup|\<ast\>>,r<rsub|s>-r<rsub|1><rsup|\<ast\>>|)>>
  is the efficient allocation. Since the type distributions are not the same,
  the marginal virtual costs are as indicated in the figure. To minimize the
  sum of the virtual costs, the source allocates all traffic to relay 2,
  while this allocation is clearly the worst outcome for minimizing the sum
  of the link costs.

  <big-figure|<with|par-mode|center|<image|Asymmetric.eps||||> >|Efficiency
  Loss in Asymmetric Case>

  <section|Conclusion>

  This work investigated the impact of incomplete information on incentives
  for node cooperation in parallel relay networks. We considered two
  situations in which source either has partial bargaining power or full
  bargaining power. For the situation where the source has partial bargaining
  power, we have shown that all Nash Equilibria in the complete information
  game are efficient, including those induced by linear charging functions.
  We then characterized the Bayesian Nash Equilibrium for the incomplete
  information game in which relays propose linear pricing functions, and
  showed that incomplete information can induce inefficiencies, which are
  exacerbated by asymmetric prior knowledge on the type distribution. In the
  situation where the source has full bargaining power, we first showed that
  in the game with complete information, (Bayesian) Nash equilibria exist and
  are all efficient. Next, we investigated the game with incomplete
  information. To deal with the difficulty of characterizing the Bayesian
  Nash Equilibria in this case, we first showed that if a resource allocation
  outcome can be realized by a Bayesian Nash equilibrium, then there exists a
  \Ptruth telling" Bayesian Nash equilibrium that realizes the outcome. We
  then showed that the set of outcomes for the \Ptruth telling" Bayesian Nash
  equilibria is included in the set of outcomes for the Nash equilibria for a
  complete information game, in which the link cost functions are replaced by
  a specified \Pvirtual cost functions." Using this approach, we obtained for
  a symmetric network scenario a bound on the amount of inefficiency which
  may result from incomplete information.

  <section|Appendix>

  <with|font-shape|italic|Proof of Theorem<nbsp><reference|thm:virtual>>: The
  first and second-order conditions for<nbsp><eqref|eq:truth1> are:

  <\equation>
    <around*|\<nobracket\>|<frac|d*E<rsub|\<theta\><rsub|-i>><around*|{|U<rsub|i><around|(|\<theta\><rsub|i>,f<around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|)>|}>|d<wide|\<theta\><rsub|i>|~>>|\|><rsub|<wide|\<theta\><rsub|i>|~>=\<theta\><rsub|i>>=0<text|
    >
  </equation>

  and

  <\equation>
    <around*|\<nobracket\>|<frac|d<rsup|2>*E<rsub|\<theta\><rsub|-i>><around*|{|U<rsub|i><around|(|\<theta\><rsub|i>,f<around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|)>|}>|d<wide|\<theta\><rsub|i>|~><rsup|2>>|\|><rsub|<wide|\<theta\><rsub|i>|~>=\<theta\><rsub|i>>\<leq\>0.
  </equation>

  The first-order condition is equivalent to

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|E<rsub|\<theta\><rsub|-i>>*<frac|d*t<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|d<wide|\<theta\><rsub|i>|~>>|\|><rsub|<wide|\<theta\><rsub|i>|~>=\<theta\><rsub|i>><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<around*|\<nobracket\>|E<rsub|\<theta\><rsub|-i>>*<around*|{|<frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|)>|\<partial\>*r<rsub|i>>*<frac|d*r<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|d<wide|\<theta\><rsub|i>|~>>|}>|\|><rsub|<wide|\<theta\><rsub|i>|~>=\<theta\><rsub|i>>.<eq-number>>>>>>

  The second-order condition is equivalent to

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|E<rsub|\<theta\><rsub|-i>>*<frac|d<rsup|2>*t<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|d<wide|\<theta\><rsub|i>|~><rsup|2>>|\|><rsub|<wide|\<theta\><rsub|i>|~>=\<theta\><rsub|i>><eq-number>>>|<row|<cell|>|<cell|\<leq\>>|<cell|E<rsub|\<theta\><rsub|-i>><around*|{|<frac|\<partial\><rsup|2>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|)>|\<partial\>*r<rsub|i><rsup|2>><around*|[|<frac|d*r<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|d<wide|\<theta\><rsub|i>|~>>|]><rsup|2>|\<nobracket\>><eq-number>>>|<row|<cell|>|<cell|>|<cell|+<around*|\<nobracket\>|<around*|\<nobracket\>|<frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|)>|\<partial\>*r<rsub|i>>*<frac|d<rsup|2>*r<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|d<wide|\<theta\><rsub|i>|~><rsup|2>>|}>|\|><rsub|<wide|\<theta\><rsub|i>|~>=\<theta\><rsub|i>>.<eq-number>>>>>>

  By evaluating the first-order condition at <math|\<theta\><rsub|i>>
  differentiating with respect to <math|\<theta\><rsub|i>>, we get:

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|E<rsub|\<theta\><rsub|-i>><around*|{|<frac|d<rsup|2><around*|{|t<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|}>|d*\<theta\><rsub|i><rsup|2>>|}><eq-number>>>|<row|<cell|>|<cell|=>|<cell|E<rsub|\<theta\><rsub|-i>><around*|{|<frac|\<partial\><rsup|2>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|)>|\<partial\>*r<rsub|i><rsup|2>><around*|[|<frac|d*r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|d*\<theta\><rsub|i>>|]><rsup|2>|\<nobracket\>><eq-number>>>|<row|<cell|>|<cell|>|<cell|+<frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|)>|\<partial\>*r<rsub|i>>*<frac|d<rsup|2>*r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|d*\<theta\><rsub|i><rsup|2>><eq-number>>>|<row|<cell|>|<cell|>|<cell|+<around*|\<nobracket\>|<frac|\<partial\><rsup|2>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|)>|\<partial\>*r<rsub|i>*\<partial\>*\<theta\><rsub|i>>*<frac|d*r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|d*\<theta\><rsub|i>>|}>.<eq-number>>>>>>

  Comparing with the second-order condition, we get

  <\equation>
    E<rsub|\<theta\><rsub|-i>>*<frac|\<partial\><rsup|2>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|)>|\<partial\>*r<rsub|i>*\<partial\>*\<theta\><rsub|i>>*<frac|d*r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|d*\<theta\><rsub|i>>\<leq\>0.<label|eq:secondcondition>
  </equation>

  We have already assumed that

  <\equation>
    <frac|\<partial\><rsup|2>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|)>|\<partial\>*r<rsub|i>*\<partial\>*\<theta\><rsub|i>>\<leq\>0*<text|for
    each >\<theta\><rsub|-i>.<label|eq:assume1>
  </equation>

  Notice that when an outcome can be realized by a Bayesian Nash Equilibrium,
  the following condition must hold:

  <\equation>
    <frac|\<partial\>*r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|\<partial\>*\<theta\><rsub|i>>\<geq\>0*<text|given
    any >\<theta\><rsub|-i><label|eq:assume2>
  </equation>

  Otherwise, the source would allocate a higher rate to a lower type relay,
  which is not optimal. Notice that by<nbsp><eqref|eq:assume1>
  and<nbsp><eqref|eq:assume2>, <nbsp><eqref|eq:secondcondition> automatically
  holds.

  Thus, the following conditions are necessary for the first and second-order
  conditions to hold.

  <eqnarray*|<tformat|<table|<row|<cell|>|<cell|>|<cell|<frac|d*E<rsub|\<theta\><rsub|-i>><around*|{|t<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|}>|d<wide|\<theta\><rsub|i>|~>>>>|<row|<cell|>|<cell|=>|<cell|<around*|\<nobracket\>|E<rsub|\<theta\><rsub|-i>>*<frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|)>|\<partial\>*r<rsub|i>>*<frac|d*r<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|d<wide|\<theta\><rsub|i>|~>>|\|><rsub|<wide|\<theta\><rsub|i>|~>=\<theta\><rsub|i>>>>>>>

  <\equation*>
    <frac|\<partial\>*r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|\<partial\>*\<theta\><rsub|i>>\<geq\>0*<text|given
    any >\<theta\><rsub|-i>
  </equation*>

  Let <math|V<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>=max<rsub|<wide|\<theta\><rsub|i>|~>>
  U<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>,t<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|)>>.
  We use the envelope theorem just as we did in the previous sections:

  <eqnarray|<tformat|<table|<row|<cell|<frac|d*E<rsub|\<theta\><rsub|-i>>*V<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|d*\<theta\><rsub|i>>>|<cell|=>|<cell|<around*|\<nobracket\>|<frac|\<partial\>*E<rsub|\<theta\><rsub|-i>>*U<rsub|i>(\<theta\><rsub|i>,r<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>,t<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|\<partial\>*\<theta\><rsub|i>>|\|><rsub|<wide|\<theta\><rsub|i>|~>=\<theta\><rsub|i>><eq-number>>>|<row|<cell|>|<cell|=>|<cell|<around*|\<nobracket\>|-<frac|\<partial\>*E<rsub|\<theta\><rsub|-i>>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|<wide|\<theta\><rsub|i>|~>,\<theta\><rsub|-i>|)>|)>|\<partial\>*\<theta\><rsub|i>>|\|><rsub|<wide|\<theta\><rsub|i>|~>=\<theta\><rsub|i>><eq-number>>>>>>

  Let <math|<wide|\<theta\><rsub|i>|\<bar\>>> and
  <math|<wide*|\<theta\><rsub|i>|\<bar\>>> be the upper and lower bounds on
  relay node i's type, then

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|E<rsub|\<theta\><rsub|-i>>*V<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)><eq-number>>>|<row|<cell|>|<cell|=>|<cell|E<rsub|\<theta\><rsub|-i>>*V<rsub|i><around|(|<wide*|\<theta\><rsub|i>|\<bar\>>,\<theta\><rsub|-i>|)>-<big|int><rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|\<theta\><rsub|i>><frac|\<partial\>*E<rsub|\<theta\><rsub|-i>>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|)>|\<partial\>*\<theta\><rsub|i>>*d*\<theta\><rsub|i><eq-number>>>>>>

  We see from the above equation that, as we already assumed
  <math|<frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>|\<partial\>*\<theta\><rsub|i>>\<less\>0>,
  the expected utility of relay <math|i> is non-decreasing with respect to
  <math|\<theta\><rsub|i>>. Thus, to guarantee that constraints
  (<reference|eq:nonnegative>) holds, the lowest type must receive
  non-negative profit. On the other hand, the relay with the lowest type can
  never receive a positive profit, otherwise the source will reduce its
  profit by some small amount and still guarantee that the contract is
  acceptable to all, which contradicts the definition of Bayesian Nash
  Equilibrium. Thus, the lowest type relay should receive zero profit.

  <\equation>
    E<rsub|\<theta\><rsub|-i>>*V<rsub|i><around|(|<wide*|\<theta\><rsub|i>|\<bar\>>,\<theta\><rsub|-i>|)>=0
  </equation>

  Plugging in, we get

  <\equation>
    E<rsub|\<theta\><rsub|-i>>*V<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>=-<big|int><rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|\<theta\><rsub|i>><frac|\<partial\>*E<rsub|\<theta\><rsub|-i>>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|)>|\<partial\>*\<theta\><rsub|i>>*d*\<theta\><rsub|i>
  </equation>

  Suppose the type distribution function of relay <math|i> is
  <math|F<rsub|i><around|(|\<theta\><rsub|i>|)>> and the density is
  <math|f<rsub|i><around|(|\<theta\><rsub|i>|)>>. Let <math|R> be the
  expected revenue of the source node. Then,

  <eqnarray*|<tformat|<table|<row|<cell|R>|<cell|=>|<cell|E<rsub|\<theta\>>*<around*|{|W<rsub|s><around|(|r<rsub|s>|)>-C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>-<big|sum><rsub|i>t<rsub|i><around|(|\<theta\>|)>|}>>>|<row|<cell|>|<cell|=>|<cell|E<rsub|\<theta\>>*<around*|{|W<rsub|s><around|(|r<rsub|s>|)>-C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>-<big|sum><rsub|i>V<rsub|i><around|(|\<theta\>|)>-<big|sum><rsub|i>C<rsub|i><around|(|\<theta\>|)>|}>>>|<row|<cell|>|<cell|=>|<cell|E<rsub|\<theta\>>*<around*|{|W<rsub|s><around|(|r<rsub|s>|)>-C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>-<big|sum><rsub|i>C<rsub|i><around|(|\<theta\>|)>|}>>>|<row|<cell|>|<cell|>|<cell|+<big|sum><rsub|i><big|int><rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|<wide|\<theta\><rsub|i>|\<bar\>>>f<rsub|i><around|(|\<theta\><rsub|i>|)>*E<rsub|\<theta\><rsub|-i>><around*|[|<big|int><rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|\<theta\><rsub|i>><frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i><rprime|'>,r<rsub|i><around|(|\<theta\><rsub|i><rprime|'>,\<theta\><rsub|-i>|)>|)>|\<partial\>*\<theta\><rsub|i><rprime|'>>*d*\<theta\><rsub|i><rprime|'>|]>*d*\<theta\><rsub|i>>>|<row|<cell|>|<cell|=>|<cell|E<rsub|\<theta\>>*<around*|{|W<rsub|s><around|(|r<rsub|s>|)>-C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>-<big|sum><rsub|i>C<rsub|i><around|(|\<theta\>|)>|}>>>|<row|<cell|>|<cell|>|<cell|-<big|sum><rsub|i><big|int><rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|<wide|\<theta\><rsub|i>|\<bar\>>>E<rsub|\<theta\><rsub|-i>><around*|[|<big|int><rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|\<theta\><rsub|i>><frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i><rprime|'>,r<rsub|i><around|(|\<theta\><rsub|i><rprime|'>,\<theta\><rsub|-i>|)>|)>|\<partial\>*\<theta\><rsub|i><rprime|'>>*d*\<theta\><rsub|i><rprime|'>|]>>>|<row|<cell|>|<cell|>|<cell|\<times\>d*<around|(|1-F<rsub|i><around|(|\<theta\><rsub|i>|)>|)>>>|<row|<cell|>|<cell|=>|<cell|E<rsub|\<theta\>>*<around*|{|W<rsub|s><around|(|r<rsub|s>|)>-C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|s>|)>-<big|sum><rsub|i>C<rsub|i><around|(|\<theta\>|)>|}>>>|<row|<cell|>|<cell|>|<cell|-<big|sum><rsub|i>E<rsub|\<theta\><rsub|-i>><around*|[|<big|int><rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|\<theta\><rsub|i>><frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i><rprime|'>,r<rsub|i><around|(|\<theta\><rsub|i><rprime|'>,\<theta\><rsub|-i>|)>|)>|\<partial\>*\<theta\><rsub|i><rprime|'>>*d*\<theta\><rsub|i><rprime|'>|]>>>|<row|<cell|>|<cell|>|<cell|\<times\><around|(|1-F<rsub|i><around|(|\<theta\><rsub|i>|)>|)>\|<rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|<wide|\<theta\><rsub|i>|\<bar\>>>>>|<row|<cell|>|<cell|>|<cell|+<big|sum><rsub|i>E<rsub|\<theta\><rsub|-i>>*<big|int><rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|<wide|\<theta\><rsub|i>|\<bar\>>><around|(|1-F<rsub|i><around|(|\<theta\><rsub|i>|)>|)>>>|<row|<cell|>|<cell|>|<cell|\<times\>d<around*|[|<big|int><rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|\<theta\><rsub|i>><frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i><rprime|'>,r<rsub|i><around|(|\<theta\><rsub|i><rprime|'>,\<theta\><rsub|-i>|)>|)>|\<partial\>*\<theta\><rsub|i><rprime|'>>*d*\<theta\><rsub|i><rprime|'>|]>>>|<row|<cell|>|<cell|=>|<cell|E<rsub|\<theta\>>*<around*|{|W<rsub|s><around|(|r<rsub|s>|)>-C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>-<big|sum><rsub|i>C<rsub|i><around|(|\<theta\>|)>|}>>>|<row|<cell|>|<cell|>|<cell|+<big|sum><rsub|i>E<rsub|\<theta\><rsub|-i>>*<big|int><rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|<wide|\<theta\><rsub|i>|\<bar\>>><around|(|1-F<rsub|i><around|(|\<theta\><rsub|i>|)>|)>>>|<row|<cell|>|<cell|>|<cell|\<times\>d<around*|[|<big|int><rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|\<theta\><rsub|i>><frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i><rprime|'>,r<rsub|i><around|(|\<theta\><rsub|i><rprime|'>,\<theta\><rsub|-i>|)>|)>|\<partial\>*\<theta\><rsub|i><rprime|'>>*d*\<theta\><rsub|i><rprime|'>|]>>>|<row|<cell|>|<cell|=>|<cell|E<rsub|\<theta\>>*<around|{|W<rsub|s><around|(|r<rsub|s>|)>-C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>|}>>>|<row|<cell|>|<cell|>|<cell|-<big|sum><rsub|i>E<rsub|\<theta\><rsub|-i>>*<big|int><rsub|<wide*|\<theta\><rsub|i>|\<bar\>>><rsup|<wide|\<theta\><rsub|i>|\<bar\>>>C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|\<theta\><rsub|i>,\<theta\><rsub|-i>|)>|)>>>|<row|<cell|>|<cell|>|<cell|-<frac|1-F<rsub|i><around|(|\<theta\><rsub|i>|)>|f<rsub|i><around|(|\<theta\><rsub|i>|)>>*<frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|\<theta\>|)>|)>|\<partial\>*\<theta\><rsub|i>>*f<rsub|i><around|(|\<theta\><rsub|i>|)>*d*\<theta\><rsub|i>>>|<row|<cell|>|<cell|=>|<cell|E<rsub|\<theta\>>*<around|[|W<rsub|s><around|(|r<rsub|s>|)>-C<rsub|s><around|(|\<theta\><rsub|s>,r<rsub|0>|)>|]>>>|<row|<cell|>|<cell|>|<cell|-E<rsub|\<theta\>>*<big|sum><rsub|i><around*|(|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|\<theta\>|)>|)>-<frac|1-F<rsub|i><around|(|\<theta\><rsub|i>|)>|f<rsub|i><around|(|\<theta\><rsub|i>|)>>*<frac|\<partial\>*C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i><around|(|\<theta\>|)>|)>|\<partial\>*\<theta\><rsub|i>>|)>>>>>>

  Thus, we obtain a game with complete information and full source bargaining
  power where the revenue function is changed to
  <math|J<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>> rather than
  <math|C<rsub|i><around|(|\<theta\><rsub|i>,r<rsub|i>|)>>.

  <\bibliography|bib|ieeetr|./gameNet,./ICCBiblio>
    <bib-list|[99]|>
  </bibliography>
</body>