<TeXmacs|1.99.7>

<style|<tuple|article|std-latex>>

<\body>
  <\hide-preamble>
    <assign|ldots|<macro|...>>

    <assign|ppp|<macro|\<cal-P\>>>

    <assign|qqq|<macro|\<cal-Q\>>>

    <assign|rrr|<macro|\<cal-R\>>>

    <assign|eee|<macro|\<cal-L\>>>

    <assign|hhh|<macro|\<cal-H\>>>

    <assign|fff|<macro|\<cal-F\>>>

    <assign|ccc|<macro|\<cal-C\>>>

    <assign|diam|<macro|<with|font-family|rm|diam>>>

    <assign|E|<macro|<with|font-family|rm|E>>>

    <assign|pr|<macro|<with|font-family|rm|Pr>>>

    <assign|dun|<macro|<wide|\<cup\>|\<dot\>>>>

    <assign|Dun|<macro|<wide|<big|cup>|\<dot\>>>>

    <assign|dfn|<macro|1|<em|<arg|1>>>>

    <assign|sm|<macro|\<setminus\>>>

    <assign|pd|<macro|\<approx\>>>

    <assign|cn|<macro|\<sim\>>>

    <assign|sbs|<macro|\<subset\>>>

    <assign|abs|<macro|1|\<lvert\><arg|1> \<rvert\>>>

    <assign|flr|<macro|1|\<lfloor\><arg|1> \<rfloor\>>>

    <assign|clg|<macro|1|\<lceil\><arg|1> \<rceil\>>>

    <assign|st|<macro|<space|0.17em><vrule><space|0.17em>>>

    <assign|setchoose|<macro|1|2|<left|[>
    <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|<arg|1>>>|<row|<cell|<arg|2>>>>>>
    <right|]>>>

    <assign|lx|<macro|\<bullet\>>>

    <assign|Z|<macro|\<bbb-Z\>>>

    <assign|N|<macro|\<bbb-N\>>>

    <assign|R|<macro|\<bbb-R\>>>

    <assign|C|<macro|\<bbb-C\>>>

    <assign|Q|<macro|\<bbb-Q\>>>

    <new-theorem|theorem|Theorem>

    <new-theorem|conjecture|Conjecture>

    <new-theorem|fact|Fact>

    <new-theorem|lemma|Lemma>

    <new-theorem|cor|Corollary>

    <new-theorem|claim|Claim>

    <new-theorem|observ|Observation>

    <assign|ep|<macro|\<varepsilon\>>>

    <assign|aaa|<macro|27>>

    <assign|State|<macro|1|<no-indent><with|font-series|bold|State <arg|1>:>
    >>

    <assign|defense|<macro|4c>>

    <assign|offense|<macro|4a>>

    <assign|doffense|<macro|4b>>

    <assign|defensep|<macro|4c<math|<rprime|'>>>>

    <assign|offensep|<macro|4a<math|<rprime|'>>>>

    <assign|doffensep|<macro|4b<math|<rprime|'>>>>
  </hide-preamble>

  <doc-data|<doc-title|A finite goal set in the plane which is not a
  Winner>|<doc-author|<author-data|<author-name|Wesley
  Pegden<footnote|Department of Mathematics, Rutgers University (New
  Brunswick), 110 Frelinghuysen Rd., Piscataway, NJ 08854-8019. Email:
  pegden@math.rutgers.edu>>>>|<doc-date|September 20, 2007>>

  <abstract-data|<\abstract>
    J.<nbsp>Beck has shown that if two players alternately select previously
    unchosen points from the plane, Player 1 can always build a congruent
    copy of any given finite goal set <math|G>, in spite of Player 2's
    efforts to stop him <cite|ttt>. We give a finite goal set <math|G> (it
    has 5 points) which Player 1 cannot construct <em|before> Player 2 in
    this achievement game played in the plane.
  </abstract>>

  <psset|unit=2cm,dash=3pt 2pt,linewidth=.5pt,labelsep=.075,dotsize=4pt>

  <FPmul|<aaat>|2|<aaa>> <FPclip|<aaac>|<aaat>> <FPmul|<aaat>|3|<aaa>>
  <FPclip|<aaad>|<aaat>>

  <FPdiv|<halfaaat>|<aaa>|2> <FPclip|<halfaaa>|<halfaaat>>

  <FPadd|<threehalvesaaat>|<aaa>|<halfaaa>>
  <FPclip|<threehalvesaaa>|<threehalvesaaat>>

  <FPadd|<fivehalvesaaat>|<aaa>|<threehalvesaaa>>
  <FPclip|<fivehalvesaaa>|<fivehalvesaaat>>

  <FPadd|<oppt>|180|<threehalvesaaa>> <FPclip|<opp>|<oppt>>

  <FPadd|<ddt>|0|<threehalvesaaa>> <FPclip|<dd>|<ddt>>

  <section|Introduction>

  In the <math|G>-achievement game played in the plane, two players take
  turns choosing single points from the plane which have not already been
  chosen. A player achieves a <em|weak win> if he constructs a set congruent
  to the <em|goal set> <math|G<sbs><R><rsup|2>> made up entirely of his own
  points, and achieves a <em|strong win> if he constructs such a set before
  the other player does so. (So a `win' in usual terms, <em|e.g.>, in
  Tic-Tac-Toe, corresponds to a strong win in our terminology.) This is a
  special case of a positional hypergraph game, where players take turns
  choosing unchosen points (vertices of the hypergraph) in the hopes of
  occupying a whole edge of the hypergraph with just their own points.
  <cite|Bf|ttt> contain results and background in this more general area.

  The type of game we are considering here is the game-theoretic cousin of
  Euclidean Ramsey Theory (see <cite|euc> for a survey). Fixing some
  <math|r\<in\><N>> and some finite point set <math|G<sbs><R><rsup|2>>, the
  most basic type of question in Euclidean Ramsey Theory is to determine
  whether it is true that in every <math|r>-coloring of the plane, there is
  some monochromatic congruent copy of <math|G>.

  Restricting ourselves to 2 colors, the game-theoretic analog asks when
  Player 1 has a `win' in the achievement game with <math|G> as a goal set.
  Though one can allow transfinite move numbers indexed by ordinals (see
  Question <reference|trans> in Section <reference|qs>), it is natural to
  restrict our attention to games of length <math|\<omega\>>, in which moves
  are indexed by the natural numbers. In this case, a weak or strong winning
  strategy for a player is always a finite strategy (<em|i.e.>, must always
  result in weak or strong win, respectively, in a finite, though possibly
  unbounded, number of moves) so long as the goal set <math|G> is finite. J.
  Beck has shown <cite|ttt> that both players have strategies which guarantee
  them a weak win in finitely many moves for <em|any> finite goal set\Vthe
  proof is a potential function argument related to the classical
  Erds-Selfridge theorem<cite|es>. The question of when the first player has
  a strong win\Vthat is, whether he can construct a copy of <math|G>
  first\Vseems in general to be a <em|much> harder problem. (A strategy
  stealing argument shows that the second player cannot have a strategy which
  ensures him a strong win: see Lemma <reference|steal>.)

  For some simple goal sets, it is easy to give a finite strong winning
  strategy for Player 1. This is the case for any goal set with at most 3
  points, for example, or for the 4-point vertex-set of any parallelogram. We
  give a set <math|G> of 5 points for which we prove that the first player
  cannot have a finite strong win in the <math|G>-achievement game (proving,
  for example, that such finite goal sets do in fact exist). This answers a
  question of Beck (oral communication).

  Fix <math|\<theta\>=t*\<pi\>>, where <math|t> is irrational and
  <math|t\<less\><frac|1|9>>. Our set <math|G> is a set of 5 points
  <math|g<rsub|i>>, <math|1\<leq\>i\<leq\>5>, all lying on a unit circle
  <math|C> with center <math|c\<in\><R><rsup|2>>. For
  <math|1\<leq\>i\<leq\>3>, the angle from <math|g<rsub|i>> to
  <math|g<rsub|i+1>> is <math|\<theta\>>. The point <math|g<rsub|5>> (the
  `middle point') is the point on <math|C> lying on the bisector of the angle
  <math|\<angle\>*g<rsub|2>*c*g<rsub|3>>. (See Figure <reference|G>.) We call
  this set the <em|irrational pentagon>.

  <\big-figure>
    <\latex_preview|begin-pspicture>
      \\begin{pspicture}(-1,-1)(1,1)

      \;

      \t\\psline[linestyle=dotted,linewidth=1pt](1;\\dd)(0,0)

      \;

      \t\\uput*[\\aaa](1;0){\\small$g_1$}

      \t\\uput*{.3}[\\halfaaa](0,0){\\small$\\theta$}

      \;

      \;

      \t\\uput*[\\aaa](1;\\aaa){\\small$g_2$}

      \t\\uput*{.3}[\\threehalvesaaa](0,0){\\small$\\theta$}

      \;

      \t\\uput*{.3}[\\fivehalvesaaa](0,0){\\small$\\theta$}

      \t\\uput*[\\aaa](1;\\aaac){\\small$g_3$}

      \;

      \t\\uput*[\\aaad](1;\\aaad){\\small$g_4$}

      \;

      \t\\uput*[\\dd](1;\\dd){\\small$g_5$}

      \;

      \t\\uput*[-45](0,0){\\small$c$}

      \;

      \ \ \ \ \ \ \ \ \\pscircle[linewidth=.5pt,linestyle=dashed,dash=3pt
      2pt](0,0){1}

      \;

      \;

      \;

      \;

      \t\\psdot(1;0) \ % semicolon indicates polar coordinates

      \t\\psline[linestyle=dashed](0,0)(1;0)

      \;

      \;

      \;

      \t\\psdot(1;\\aaa)

      \t\\psline[linestyle=dashed](0,0)(1;\\aaa)

      \;

      \;

      \;

      \t\\psdot(1;\\aaac)

      \t\\psline[linestyle=dashed](0,0)(1;\\aaac)

      \;

      \;

      \t\\psdot(1;\\aaad)

      \t\\psline[linestyle=dashed](0,0)(1;\\aaad)

      \;

      \;

      \t\\psdot(1;\\dd)

      \;

      \;

      \;

      \t

      \;

      \;

      \;

      \;

      \ \ \ \ \\end{pspicture}
    </latex_preview>

    <label|G>

    <caption*|The goal set <math|G>|The goal set <math|G>. Player 2 can force
    a draw when the goal is this set, where <math|\<theta\>> is any
    irrational multiple of <math|\<pi\>> less than <math|<frac|\<pi\>|9>>.>
  </big-figure|>

  <\theorem>
    There is no finite strong winning strategy for Player 1 in the
    <math|G>-achievement game when <math|G> is the irrational
    pentagon.<label|nfswin>
  </theorem>

  <no-indent><with|font-series|bold|Idea:> Let
  <math|\<theta\><rsup|n><rsub|c><around|(|x|)>> denote the image of
  <math|x\<in\><R><rsup|2>> under the rotation <math|n*\<theta\>> about the
  point <math|c>. An important property of the irrational pentagon is that
  once a player has threatened to build a copy of it by selecting all the
  points <math|g<rsub|1>,g<rsub|2>,g<rsub|3>,g<rsub|4>>, he can give a new
  threat by choosing the point <math|\<theta\><rsub|c><around|(|g<rsub|4>|)>>
  or <math|\<theta\><rsub|c><rsup|-1><around|(|g<rsub|1>|)>>. Furthermore,
  since <math|\<theta\>> is an irrational multiple of <math|\<pi\>>, the
  player can continue to do this indefinitely, tying up his opponent (who
  must continuously block the new threats by selecting the corresponding
  middle points) while failing himself to construct a copy of <math|G>. If
  Player 1 is playing for a finite strong win, he cannot let Player 2
  indefinitely force in this manner. However, to deny Player 2 that
  possibility, we will see that Player 1's only option is the same indefinite
  forcing, which leaves him no better. The rest of the rigorous proof is a
  case study.

  <section|The Proof>

  For the proof of Theorem <reference|nfswin>, we will need the following
  lemma.

  <\lemma>
    There are no three unit circles <math|C<rsub|1>,C<rsub|2>,C<rsub|3>> so
    that the pairs <math|C<rsub|i>>,<math|C<rsub|j>> each intersect at 2
    distinct points <math|x<rsub|i*j>> and <math|y<rsub|i*j>>, so that the
    angles <math|\<angle\>*x<rsub|i*j>*c<rsub|i>*y<rsub|i*k>> are less than
    <math|<frac|\<pi\>|3>> for all <math|j\<neq\>i\<neq\>k>.<label|noclose>
  </lemma>

  <\big-figure>
    <\latex_preview|begin-pspicture>
      \\begin{pspicture}(-1,-1)(3,1)

      \;

      \ \ \ \ \ \ \ \ \\pscircle(1.8,0){1}

      \t\\uput*[0](1.8,0){\\small$c_i$}

      \;

      \t\\psdot(1.8,0)

      \;

      \t\\psdot(0,0)

      \;

      \t\\uput*[-25](1;25.8419){\\small$x_{ij}$}

      \t\\uput*[25](1;-25.8419){\\small$y_{ij}$}

      \t\\psline[linestyle=dashed](0,0)(1;25.8419)

      \t\\psline[linestyle=dashed](0,0)(1;-25.8419)

      \t\\psdot(1;25.8419)

      \t\\psdot(1;-25.8419)

      \;

      \;

      \;

      \t\\uput*[-56.24101](1;-56.25101){\\small$r_2$}

      \t\\psline(1.8,0)(-.0666666,1.2472191)

      \t\\psdot(1;-56.25101)

      \t\\psline[linestyle=dashed](0,0)(1;-56.25101)

      \;

      \;

      \t\\uput*[56.24101](1;56.25101){\\small$r_1$}

      \t\\psline(1.8,0)(-.0666666,-1.2472191)

      \t\\psdot(1;56.25101)

      \t\\psline[linestyle=dashed](0,0)(1;56.25101)

      \;

      \;

      \;

      \;

      \;

      \;

      \;

      \t\\uput*[180](0,0){\\small$c_j$}

      \ \ \ \ \ \ \ \ \\pscircle(0,0){1}

      \;

      \;

      \;

      \ \ \ \ \\end{pspicture}
    </latex_preview>

    <label|circs>

    \;
  </big-figure|Proving Lemma <reference|noclose>>

  <\proof>
    Let <math|B<rsub|i>> denote the unit ball whose boundary is
    <math|C<rsub|i>> for each <math|i>, and choose <math|C<rsub|i>> and
    <math|C<rsub|j>> from <math|<around|{|C<rsub|1>,C<rsub|2>,C<rsub|3>|}>>
    so that the area <math|A*<around|(|B<rsub|i>\<cap\>B<rsub|j>|)>> is
    maximal. In Figure 2, for any <math|C<rsub|k>> intersecting the circle
    <math|C<rsub|j>> at points <math|x<rsub|j*k>,y<rsub|j*k>> lying on
    <math|C<rsub|j>> between <math|r<rsub|1>> and <math|r<rsub|2>>, we would
    have <math|A*<around|(|B<rsub|i>\<cap\>B<rsub|k>|)>\<gtr\>A*<around|(|B<rsub|i>\<cap\>B<rsub|j>|)>>,
    a contradiction. The maximum angle between the points <math|r<rsub|1>>
    and <math|r<rsub|2>> on <math|C<rsub|j>> is <math|<frac|2*\<pi\>|3>>.
  </proof>

  We are now ready to prove Theorem <reference|nfswin>. Let <math|G> now
  denote the irrational pentagon.

  It is clear that Player 2 can either play indefinitely or reach a point
  where it is his move, he has a point <math|h<rsub|1>> at least 10 units
  away from any of Player 1's points, and Player 1 has no more than 2 points
  in any given (closed) ball of radius 10. (For example: on each turn until
  he has reached this point, Player 2 moves at least 30 units away from all
  of Player 1's points.) Reaching this point, Player 2 begins to build a copy
  of <math|G>; that is, he arbitrarily designates some `center point'
  <math|c> at unit distance from the point <math|h<rsub|1>>, and chooses as
  his move a point <math|h<rsub|2>> which is an angle <math|\<theta\>> away
  from <math|h<rsub|1>> on the unit circle <math|C> centered at <math|c>. In
  fact, <math|h<rsub|1>> and <math|h<rsub|2>> lie on two unit circles which
  are disjoint except at <math|h<rsub|1>,h<rsub|2>>, and so Player 1's
  response can lie on only one of them; thus we assume without loss of
  generality that his response does not lie on the circle <math|C>.

  Following Player 1's response, Player 2 will continue constructing his
  threat by choosing the point <math|h<rsub|3>> which lies on the circle
  <math|C> and is separated from the points <math|h<rsub|1>,h<rsub|2>> by
  angles <math|2*\<theta\>,\<theta\>>, respectively. Thus regardless of
  Player 1's choice of response, we see that Player 2 can reach the following
  situation:

  <leavevmode><reversemarginpar><marginal-note|normal||<htab|0pt><math|<around|(|\<star\>|)>>>
  It is Player 1's turn, Player 2 has points
  <math|h<rsub|1>,h<rsub|2>>,<math|h<rsub|3>> separated consecutively by
  angles <math|\<theta\>> on a unit circle <math|C> centered at <math|c>, and
  Player 1 has at most <math|3> points in any unblocked copy of <math|G>.
  Finally, Player 1 does not control 4 points of any unblocked copy of
  <math|G>, and controls at most one point within 8 units of <math|c>.

  <leavevmode><reversemarginpar><marginal-note|normal||<htab|0pt><math|<around|(|\<star\>*\<star\>|)>>>
  Moreover, there is in fact at most one unblocked copy of <math|G> on which
  Player 1 has 3 points, and, if it exists, Player 1 controls no other points
  within (say) 5 units of those 3 points.

  <vspace|1em>We classify the rest of the proof into Cases 1,2,3 based on
  Player 1's move. The analysis in Cases 1 and 3 depend just on the
  conditions in paragraph <math|<around|(|\<star\>|)>>, while Case 2 depends
  on the conditions in both paragraphs <math|<around|(|\<star\>|)>> and
  <math|<around|(|\<star\>*\<star\>|)>>.

  <with|font-series|bold|Case 1:> A natural response for Player 1 might be to
  play on the circle <math|C>, thus attempting to prevent Player 2 from
  building a significant threat. Since no point is a rotation of
  <math|h<rsub|1>> about the point <math|c> by both positive and negative
  integer multiples of <math|<frac|\<theta\>|2>>, we may assume WLOG that
  Player 1 does not choose any rotations of <math|h<rsub|1>> about <math|c>
  by positive integer multiples of <math|<frac|\<theta\>|2>>. Thus Player 2
  responds by choosing the point <math|h<rsub|4>> on <math|C> which is at an
  angle <math|\<theta\>,2*\<theta\>,3*\<theta\>> from the points
  <math|h<rsub|3>,h<rsub|2>,h<rsub|1>>, respectively. Since Player 2 is now
  threatening to build a copy of <math|G> on his next move and Player 1 is
  not (he has <math|\<leq\>3> points on any unblocked copy of <math|G>),
  Player 1 must take the point on <math|C> which together with
  <math|h<rsub|1>,h<rsub|2>,h<rsub|3>,h<rsub|4>> complete a copy of <math|G>.
  Player 2's response is naturally to choose the point <math|h<rsub|5>> on
  <math|C> at angle <math|\<theta\>,2*\<theta\>,3*\<theta\>> from
  <math|h<rsub|4>,h<rsub|3>,h<rsub|2>>, and we are in essentially the same
  situation: Player 1 has always at most 3 points in any unblocked congruent
  copy of <math|G> (since he has only one point `near' <math|C> which is not
  on <math|C>, and any set congruent to <math|G> and not on <math|C>
  intersects <math|C> in at most 2 points), and Player 2 can force
  indefinitely.

  <with|font-series|bold|Case 2:> Another response for Player 1 which may be
  possible is to play within the vicinity of his previously chosen points
  such that he controls 4 points of an unblocked copy of <math|G>. By
  <math|<around|(|\<star\>*\<star\>|)>> Player 1 has only one 4-point threat,
  and so Player 2 can choose the corresponding fifth point to avoid losing.
  Now, Player 1 may be able to continue to make threats on his subsequent
  moves, but it is easy to check using the conditions of
  <math|<around|(|\<star\>*\<star\>|)>> that his moves will have to stay on a
  single unit circle <math|C<rsub|1>> to do so, and that he will never be
  able to generate more than one threat, and thus never be able end his
  indefinite forcing with a win. On the other hand, each time it is Player
  1's move, the conditions in paragraph <math|<around|(|\<star\>|)>> are
  still satisfied, and so any move other than a continuation of the forcing
  will allow the analysis from Cases 1 and 3 to apply.

  <with|font-series|bold|Case 3:> Finally, we consider the case where Player
  1 does `none of the above'; that is, he chooses a point not on the circle
  <math|C>, but which nevertheless does not increase to 4 the number of
  points he controls in some congruent copy of <math|G>. This is the case
  where we make use of Lemma <reference|noclose>.

  Player 1 now has as many as two points within 8 units distance of the point
  <math|h<rsub|1>>. By choosing successively points
  <math|h<rsub|4>,h<rsub|5>,h<rsub|6>>, etc., as in Case 1, Player 2 hopes to
  successively force Player 1 to take the corresponding fifth point of each
  congruent copy of <math|G> that Player 2 threatens to build at each step.
  The only snag is this: it is conceivable that Player 1, in taking these
  corresponding `fifth' points, builds his own threat. He already has two
  points in the vicinity, and it is possible that they lie on a congruent
  copy of <math|G> which intersects the circle <math|C> in two points which
  Player 1 will eventually be forced to take by Player 2's moves. In this
  case, Player 2 would have to respond and could conceivably end up losing
  the game if Player 1 is able to break is forcing sequence.

  Of course, this is only truly a problem if Player 1 is threatening this in
  `both directions'\Vthat is, regardless of whether <math|h<rsub|4>> is at
  angles <math|\<theta\>,2*\<theta\>,3*\<theta\>> to the points
  <math|h<rsub|3>,h<rsub|2>,h<rsub|1>>, respectively, or to the points
  <math|h<rsub|1>,h<rsub|2>,h<rsub|3>>, respectively. However, such a double
  threat is immediately ruled out by Lemma <reference|noclose>, since this
  would require two sets <math|S<rsub|1>,S<rsub|2>\<cong\>G> (each a subset
  of a <math|3*\<theta\>>-arc of a unit circle) intersecting each other in
  two points (previously chosen by Player 1) and each also each intersecting
  <math|C> in two places. This completes the proof.<math|\<Box\>>

  <section|Further Questions><label|qs>

  <\q>
    Our (rather crude) methods do not appear suited to much larger goal sets.
    So we ask: are there arbitrarily large goal sets <math|G> for which
    Player 1 cannot force a finite strong win in the <math|G>-achievement
    game played in <math|<R><rsup|2>>?
  </q>

  <\q>
    We have examples of 4-point sets for which Player 1 has strong winning
    strategies, and we have given here a 5-point example where Player 2 has a
    drawing strategy. Are there 4-point sets where Player 2 has a drawing
    strategy?
  </q>

  <\q>
    Player 1 can easily be shown to have strong winning strategies for any
    goal set of size at most 3, and any 4-point goal set which consists of
    the vertices of a parallelogram. It is not difficult to give a 5 point
    goal set for which Player 1 can be shown to have a strong winning
    strategy. Are there arbitrarily large goal sets <math|G> for which Player
    1 has a strong winning strategy?
  </q>

  <\q>
    We restricted our attention here to the first <math|\<omega\>> moves, and
    indeed, our proof does not show that Player 1 can't force a strong win if
    transfinite move numbers are allowed. So we ask: are there finite sets
    <math|G> for which Player 1 cannot force a strong win, when the players
    make a move for each successor ordinal?<label|trans>
  </q>

  <\q>
    In the general achievement game played on a hypergraph (in which the two
    players select vertices, and the goal sets are the edges) we define some
    stronger win types for Player 1: <psset|xunit=1.4cm,yunit=1.4cm>

    <\big-figure>
      <\latex_preview|begin-pspicture>
        \\begin{pspicture}(0,0)(4,2)

        \\psdot*(2,2)

        \;

        \\psdot*(1,1) \ \\psdot*(3,1)

        \;

        \;

        \\psdot*(.5,0) \ \\psdot*(1.5,0) \\psdot*(2.5,0) \\psdot*(3.5,0)

        \;

        \;

        \\psccurve[showpoints=false](2,2.1)(1,1.2)(.4,0)(.5,-.1)(.6,0)(1,.8)(2,1.8)(2.1,2)(2,2.1)

        \;

        \\psecurve[showpoints=false](1.9,2)(2,2.1)(3,1.2)(3.6,0)(3.5,-.1)(3.4,0)(3,.8)(2,1.8)(1.9,2)(2,2.1)(3,1.2)

        \;

        \\psccurve[showpoints=false](2,2.1)(1.9,2)(2.9,1)(2.4,0)(2.5,-.1)(3.1,1)(2.1,2)(2,2.1)

        \;

        \\psecurve[showpoints=false](1.9,2)(2,2.1)(2.1,2)(1.1,1)(1.6,0)(1.5,-.1)(.9,1)(1.9,2)(2,2.1)(3,1.2)

        \;

        \;

        \;

        \;

        \;

        \\end{pspicture}
      </latex_preview>

      \;
    </big-figure|The hypergraph <math|<hhh><rsub|T>>, in the case where
    <math|T> is the balanced binary directed tree of depth 2.<label|HT>>

    <\definition>
      In the achievement game played on a hypergraph <math|<hhh>>, Player 1
      has a <em|fair win> if he builds some <math|e\<in\>E<around|(|<hhh>|)>>
      on a turn which comes before any turn on which Player 2 builds some
      <math|f\<in\>E<around|(|<hhh>|)>>.<label|fair>
    </definition>

    Each `turn' of the game consists of a move by Player 1 followed by a move
    by Player 2. Definition <reference|fair> requires simply that Player 1
    builds a goal set in fewer turns than it takes Player 2 to do the same
    (if Player 2 can at all).

    <\definition>
      In the achievement game played on a hypergraph <math|<hhh>>, Player 1
      has an <em|early win> if he builds some
      <math|e\<in\>E<around|(|<hhh>|)>>, say in <math|n> moves, such that
      there is no <math|m\<leq\>n> for which Player 2 had <math|<abs|e>-1>
      points of a set <math|e\<in\>E<around|(|<hhh>|)>> on his <math|m>th
      turn, and on which Player 1 had no point on his <math|m>th turn.
    </definition>

    So every early win is a fair win, and every fair win is a strong win. In
    general, none of the win types we have defined are the same, and they all
    occur for Player 1 for some hypergraph: Already for <math|K<rsub|4>>,
    Player 1 has a strong win but not a fair win. On the hypergraph
    <math|<hhh><rsub|T>>, whose vertices are the vertices of some balanced
    binary directed tree <math|T>, and whose edges are the vertex-sets of
    longest directed paths in <math|T> (Figure <reference|HT>), Player 1 has
    a fair win and an early win. Finally, let the hypergraph
    <math|<fff><rsub|n>> have vertex set <math|<around|[|n|]>\<times\><around|{|0,1|}>>.
    Edges are of two types: Type 1 edges are the <math|n>-subsets
    <math|S<sbs><around|[|n|]>\<times\><around|{|0,1|}>> for which the
    <math|\<pi\><rsub|1><around|(|S|)>=<around|[|n|]>> and
    <math|<around|(|1,0|)>\<in\>S>, and Type 2 edges are all the pairs
    <math|<around|{|<around|(|m,0|)>,<around|(|m,1|)>|}>> where
    <math|m\<in\><around|[|n|]>> (see Figure <reference|Fn>). Player 1 has a
    fair win in <math|<fff><rsub|n>> for <math|n\<geq\>2>, but not an early
    win. Probably, however, the situation is not so rich in the plane:

    <\conjecture>
      There is no finite point set <math|G<sbs><R><rsup|2>> for which Player
      1 has a strategy which ensures a fair win in the <math|G>-achievement
      game played in the plane.
    </conjecture>

    The conjecture may seem painfully obvious. If we play the achievement
    game in <math|<R>\<setminus\><around|{|c|}>> for any point
    <math|c\<in\><R><rsup|2>>, for example, Player 2 can prevent a fair win
    by always choosing the point which is the central reflection across
    <math|c> of Player 1's last move. Annoyingly, even proving that Player 1
    cannot have an early win for any <math|G> when playing in
    <math|<R><rsup|2>> may be very difficult.

    <psset|xunit=1.4cm,yunit=1.4cm>

    <\big-figure>
      <\latex_preview|begin-pspicture>
        \\begin{pspicture}(.9,-.5)(3,1.5)

        \;

        \;

        \;

        \\psdot(3,0)\\psdot(3,1)

        \\psccurve(2.9,-.2)(2.9,.5)(2.9,1.2)(3.1,1.2)(3.1,.5)(3.1,-.2)

        \;

        \\psdot(2,0)\\psdot(2,1)

        \\psccurve(1.9,-.2)(1.9,.5)(1.9,1.2)(2.1,1.2)(2.1,.5)(2.1,-.2)

        \;

        \\psdot[dotstyle=x](1,0)\\psdot(1,1)

        \\psccurve(0.9,-.2)(0.9,.5)(0.9,1.2)(1.1,1.2)(1.1,.5)(1.1,-.2)

        \;

        \;

        \;

        \;

        \;

        \;

        \\psccurve(.8,-.2)(2,-.3)(3.2,-.2)(3.2,.2)(2,.3)(.8,.2)

        \\psccurve(.8,-.2)(2,.7)(3.2,.8)(3.2,1.2)(2,1.3)(.8,-.2)

        \\psccurve(.8,-.2)(2,-.3)(3.2,.8)(3.2,1.2)(2,.3)(.8,.2)

        \\psccurve(.8,-.2)(2,.7)(3.2,-.2)(3.2,.2)(2,1.3)(.8,-.2)

        \;

        \\end{pspicture}
      </latex_preview>

      \;
    </big-figure|The hypergraph <math|<fff><rsub|3>>. There are four (in
    general <math|2<rsup|n-1>>) Type 1 edges, and three (in general <math|n>)
    Type 2 edges. (The vertex <math|<around|(|1,0|)>> is marked with
    <math|\<times\>>.)<label|Fn>>

    For the sake of completeness, we note the situation on the hypergraph
    <math|<hhh><rsub|T>> is in some way the worst possible for Player 2. It
    is easy to see that although Player 2 never occupies all but one vertex
    of an unblocked edge when playing on <math|<hhh><rsub|T>>, it is easy for
    him to occupy all but one vertex of some edge which may be blocked. The
    natural strengthening of the `early win' suggested here never occurs for
    Player 1:

    <\definition>
      In the achievement game played on a hypergraph <math|<hhh>>, Player 1
      has a <em|humiliating win> if he occupies some
      <math|e\<in\>E<around|(|<hhh>|)>> before Player 2 occupies all but one
      vertex of some edge <math|f\<in\>E<around|(|<hhh>|)>>.<label|hum>
    </definition>

    <no-indent>(So every humiliating win is an early win.) The fact that
    Player 1 never has a humiliating win will follow from the strategy
    stealing argument; we include the proof for completeness.

    <\lemma>
      [Strategy Stealing] On any hypergraph <math|<hhh>>, a second player
      cannot have a strategy which ensures strong win in the achievement
      game.<label|steal>
    </lemma>

    <\proof>
      The proof of Lemma <reference|steal> is the strategy stealing argument;
      we include the proof for completeness. We argue by contradiction: if
      the second player has a strong win strategy <math|\<sigma\>> (a
      function from game positions to vertices), the first player makes an
      arbitrary first move <math|g> (his ghost move). Now on each move, the
      first player mimics the second player's strategy by ignoring his ghost
      move: formally, let <math|G<rsub|n>> denote the game's position on the
      <math|n>th move, and let <math|G<rsub|n>\<setminus\>x> denote the game
      position modified so that the vertex <math|x> is unchosen. Then on each
      turn, the first player chooses the point
      <math|\<sigma\>*<around|(|G<rsub|n>\<setminus\>g|)>> if it is not equal
      to <math|g> (and thus must be unoccupied, since <math|\<sigma\>> is a
      valid strategy), or, if <math|\<sigma\>*<around|(|G<rsub|n>\<setminus\>g|)>=g>,
      the first player chooses an arbitrary point
      <math|x\<in\>V<around|(|<hhh>|)>> and sets <math|g\<assign\>x>. The
      fact that <math|\<sigma\>> was a `strong win' strategy for the second
      player implies that the first player will occupy all of an edge
      <math|e\<in\>E<around|(|<hhh>|)>> (even requiring <math|e\<nni\>g>)
      before the second player occupies all some some edge
      <math|f\<in\>E<around|(|<hhh>|)>>. In particular, the first player has
      a strong win, a contradiction.
    </proof>

    <fact|On any hypergraph <math|<hhh>>, Player 2 can prevent Player 1 from
    achieving a humiliating win.<label|nohum>>

    <\proof>
      Denote by <math|x> the vertex Player 1 chooses on his first move. The
      hypergraph <math|<hhh>\<setminus\>x> is the hypergraph with vertex-set
      <math|V\<setminus\><around|{|x|}>> and edges
      <math|e\<setminus\><around|{|x|}>> for each
      <math|e\<in\>E<around|(|H|)>>. We see that Player 1 has a humiliating
      win on <math|<hhh>> only if he has a strong win on
      <math|<hhh>\<setminus\><around|{|x|}>> <em|as a second player>, and we
      are done by Lemma <reference|steal>.
    </proof>

    Lemma <reference|steal> is deceptive in its simplicity. Of course we
    emphasize that the strategy stealing argument shows only the existence of
    a strategy for a first player to prevent a second player strong win. In
    general, we have no better way to find such a strategy than the nave
    `backwards labeling' method, which runs on the whole game tree. Thus,
    though Fact <reference|nohum> tells us that Player 2 should never fall
    more than one behind Player 1 (in the sense of Definition
    <reference|hum>), it is quite possible for this to happen in actual play
    between good (yet imperfect) players.
  </q>

  <subsubsection*|Acknowledgment>

  I'd like to thank Jzsef Beck for discussing with me the questions I
  consider here, and for helpful suggestions regarding the presentation.

  <\thebibliography|l>
    <bibitem-with-key|B|ttt> J.<nbsp>Beck, <em|Combinatorial Games:
    Tic-Tac-Toe Theory (Encyclopedia of Mathematics and its Applications)>,
    Cambridge University Press, <em|In press>.

    <bibitem-with-key|B96|Bf> J.<nbsp>Beck, Foundations of Positional Games,
    <em|Random Structures and Algorithms> <with|font-series|bold|9> (1996) pp
    15\U47.

    <bibitem-with-key|ES|es> P.<nbsp>Erds and J.<nbsp>Selfridge, On a
    combinatorial game, <em|Journal of Combinatorial Theory, Series A>
    <with|font-series|bold|14> (1973) 298-301

    <bibitem-with-key|G|euc> R.<nbsp>Graham, Euclidean Ramsey Theory, in:
    E.<nbsp>Goodman and J.<nbsp>O'Rourke (Eds.), <em|Handbook of Discrete and
    Computational Geometry>, CRC Press, Boca Raton, FL, 1997,
    pp.<nbsp>153\U166.
  </thebibliography>
</body>