<TeXmacs|1.99.7>

<style|<tuple|article|std-latex>>

<\body>
  <\hide-preamble>
    <assign|EtMiss|<macro|E<rsub|<mathrm>>T<space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em><space|-0.17em>/
    \ <space|0.27em> >>

    <assign|pubdate|<macro|<date|>>>

    <assign|wuppertal|<macro|Bergische Universitt
    Wuppertal<next-line>Gaustrae 20, D-42119 Wuppertal, GERMANY>>

    <assign|support|<macro|<footnote|Work supported by the Helmholtz Alliance
    ``Physics at the Terascale''.>>>

    <\assign|Title>
      <\macro|1>
        <\center>
          <with|font-size|1.41|<arg|1> >
        </center>
      </macro>
    </assign>

    <\assign|Author>
      <\macro|1>
        <\center>
          <with|font-shape|small-caps|<arg|1>>
        </center>
      </macro>
    </assign>

    <\assign|Address>
      <\macro|1>
        <\center>
          <with|font-shape|italic|<arg|1>>
        </center>
      </macro>
    </assign>

    <\assign|andauth>
      <\macro>
        <\center>
          and
        </center>
      </macro>
    </assign>

    <\assign|submit>
      <\macro|1>
        <\center>
          Submitted to <with|font-shape|slanted|<arg|1>>
        </center>
      </macro>
    </assign>

    <assign|pubblock|<macro|<rightline|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<cwith|1|-1|1|-1|cell-valign|c>|<table|<row|<cell|>>|<row|<cell|<pubdate>>>>>>>>>

    <assign|Abstract|<macro|body|<surround|<new-line>||<\quotation>
      <arg|body>
    </quotation>>>>

    <\assign|Presented>
      <\macro|body>
        <\surround|<new-line>|<new-line>>
          <\quotation>
            <\surround>
              <\center>
                PRESENTED AT
              </center>

              <vspace*|2fn>
            </surround|<new-line>|<\center>
              <\with|font-size|1.19>
                <arg|body>
              </with>
            </center>>
          </quotation>
        </surround>
      </macro>
    </assign>

    <\assign|Acknowledgements>
      <\macro>
        <vspace|2fn><vspace|2fn>

        <\center>
          <with|font-size|1.19|font-series|bold|ACKNOWLEDGEMENTS>
        </center>
      </macro>
    </assign>
  </hide-preamble>

  <\titlepage>
    <pubblock>

    <vfill><Title|Direct Measurements of <math|V<rsub|t*b>>>
    <vfill><Author|Wolfgang Wagner<support>> <Address|<wuppertal>>
    <vfill><Abstract| The measurement of the single top-quark production
    cross section in hadron collisions at the Tevatron and the LHC can be
    used to determine the absolute value of the CKM matrix element
    <math|V<rsub|t*b>> without assuming the unitarity of the CKM matrix. By
    measuring the branching ratio of the decay <math|t\<rightarrow\>W+b> one
    can relate <math|V<rsub|t*b>> to the matrix elements <math|V<rsub|t*s>>
    and <math|V<rsub|t*d>>. The current experimental status and future
    prospects of these measurements are reviewed.> <vfill><Presented| CKM
    2010<next-line>the <math|6<rsup|<mathrm>>*t*h> International Workshop on
    the CKM Unitarity Triangle<next-line>University of Warwick, United
    Kingdom, September 6--10, 2010> <vfill>
  </titlepage>

  <assign|the-footnote|<macro|<number|<footnote-nr>|fnsymbol>>><reset-counter|footnote>

  <section|Introduction>

  The main source of top quarks at the Tevatron is the pair production via
  the strong interaction. At leading order in perturbation theory
  (<math|\<alpha\><rsub|s><rsup|2>>) there are two processes that contribute
  to <math|t*<wide|t|\<bar\>>> production, quark-antiquark annihilation
  <math|q*<wide|q|\<bar\>>\<rightarrow\>t*<wide|t|\<bar\>>> and gluon-gluon
  fusion <math|g*g\<rightarrow\>t*<wide|t|\<bar\>>>. The corresponding
  Feynman diagrams for these processes are depicted in
  Fig.<nbsp><reference|fig:leadingOrderttbar>.

  <\big-figure>
    <subfigure*||<image|qqbar2ttbar.eps|0.18tex-text-width|||><label|subfig:qqtt>>
    <space|16mm> <subfigure*||<image|gggttbar.eps|0.18tex-text-width|||>
    <space|4mm> <image|ggtttbar.eps|0.18tex-text-width|||> <space|4mm>
    <image|ggtttbarCross.eps|0.18tex-text-width|||><label|subfig:ggtt>>

    \;
  </big-figure|<label|fig:leadingOrderttbar> Feynman diagrams of the leading
  order processes for <math|t*<wide|t|\<bar\>>> production:
  <subref|subfig:qqtt> quark-antiquark annihilation
  (<math|q*<wide|q|\<bar\>>\<rightarrow\>t*<wide|t|\<bar\>>>) and
  <subref|subfig:ggtt> gluon-gluon fusion
  (<math|g*g\<rightarrow\>t*<wide|t|\<bar\>>>). >

  At the Tevatron the <math|t*<wide|t|\<bar\>>> cross section is dominated by
  <math|q*<wide|q|\<bar\>>> annihilation processes contributing 85%, while
  only 15% of <math|t*<wide|t|\<bar\>>> pairs are produced via <math|g*g>
  fusion. At the LHC at <math|<sqrt|s>=14<space|0.17em><math-up|TeV>>, the
  situation is reversed, 90% of <math|t*<wide|t|\<bar\>>> events are produced
  by <math|g*g> fusion processes and only 10% by <math|q*<wide|q|\<bar\>>>
  annihilation. The reason for this phenomenon is the very different parton
  luminosities at partonic energies above the <math|t*<wide|t|\<bar\>>>
  threshold. Due to the higher center of mass energy at the LHC it is
  possible to produce <math|t*<wide|t|\<bar\>>> pairs already at lower
  <math|x> of the incoming partons where the gluon parton density dominates
  over the quark densities. In addition, the Tevatron features antiquarks as
  constituent quarks of the antiproton leading to a considerable large
  antiquark density at large <math|x>. The cross sections for
  <math|t*<wide|t|\<bar\>>> production are predicted <cite|Langenfeld:2009wd>
  to be

  <eqnarray|<tformat|<table|<row|<cell|\<sigma\><rsub|<mathrm>>*L*H*C>|<cell|=>|<cell|<around|(|887<rsup|+9><rsub|-33><space|0.17em><around|(|<math-up|scale>|)><rsup|+15><rsub|-15><space|0.17em><around|(|<math-up|PDF>|)>|)><space|0.27em><math-up|pb><space|1em><around|(|<math-up|at>14<space|0.27em><math-up|TeV>|)><space|0.17em>,<eq-number>>>|<row|<cell|\<sigma\><rsub|<mathrm>>*T*e*v>|<cell|=>|<cell|<around|(|7.04<rsup|+0.24><rsub|-0.36><space|0.17em><around|(|<math-up|scale>|)><rsup|+0.14><rsub|-0.14><space|0.17em><around|(|<math-up|PDF>|)>|)><space|0.27em><math-up|pb><space|1em><around|(|<math-up|at>1.96<space|0.27em><math-up|TeV>|)><space|0.17em>.<eq-number><label|eq:physics:top:ttbarxs>>>>>>

  According to the standard model (SM) top quarks decay with a branching
  ratio of nearly 100% to a bottom quark and a <math|W> boson and the
  <math|t*<wide|t|\<bar\>>> final states can be classified according to the
  decay modes of the <math|W> bosons. The most important (or golden) channel
  is the so-called <with|font-shape|italic|lepton+jets> channel where one
  <math|W> boson decays leptonically into a charged lepton (electron or muon)
  plus a neutrino, while the second <math|W> boson decays into jets. The
  lepton+jets channel features a large branching ratio of about 29%,
  manageable backgrounds, and allows for the full reconstruction of the event
  kinematics. Other accessible channels are the
  <with|font-shape|italic|dilepton> channel, in which both <math|W> bosons
  decay to leptons, and the <with|font-shape|italic|all-hadronic> channel,
  where both <math|W> bosons decay hadronically. The dilepton channel has the
  advantage of having a low background, but suffers on the other hand from a
  lower branching fraction (5%) compared to the lepton+jets channel. The
  all-hadronic channel, on the contrary, has the largest branching ratio of
  all <math|t*<wide|t|\<bar\>>> event categories (46%), but has the drawback
  of a huge QCD multijet background, that has to be controlled
  experimentally. The different categories of <math|t*<wide|t|\<bar\>>> and
  their branching fractions are summarized in
  Table<nbsp><reference|tab:ttbarDecay>.

  <\big-table>
    <tabular*|<tformat|<cwith|1|-1|1|-1|cell-valign|c>|<cwith|1|1|1|-1|cell-tborder|1ln>|<cwith|1|1|1|-1|cell-bborder|1ln>|<cwith|4|4|1|-1|cell-bborder|1ln>|<table|<row|<cell|<math|W>
    decays>|<cell|<math|e/\<mu\>*\<nu\>>>|<cell|<math|\<tau\>*\<nu\>>>|<cell|<math|q*<wide|q|\<bar\>>>>>|<row|<cell|<math|e/\<mu\>*\<nu\>>>|<cell|5%>|<cell|5%>|<cell|29%>>|<row|<cell|<math|\<tau\>*\<nu\>>>|<cell|-->|<cell|1%>|<cell|15%>>|<row|<cell|<math|q*<wide|q|\<bar\>>>>|<cell|-->|<cell|-->|<cell|46%>>>>>

    \;
  </big-table|<label|tab:ttbarDecay> Categories of <math|t*<wide|t|\<bar\>>>
  events and their branching fractions. The sum of all fractions is above
  100% because of rounding effects.>

  <section|Top-antitop Cross Section Measurements>

  The most precise <math|t*<wide|t|\<bar\>>> cross section measurements are
  obtained in the lepton+jets channel based on analyses in which the
  background is controlled either by the identification of the <math|b>-quark
  jets or by exploiting kinematic or topological information, see for
  example<nbsp><cite|Abazov:2008gc>. The experimental signature of
  lepton+jets <math|t*<wide|t|\<bar\>>> events comprises a reconstructed
  isolated lepton candidate, large missing transverse energy
  (<math|<EtMiss>>) and at least four jets with large transverse energy
  <math|E<rsub|T>\<equiv\>E\<cdot\>sin \<theta\>>. Two jets originate from
  <math|b>-quarks. Typical selection cuts ask for a charged lepton with
  <math|p<rsub|T>\<gtr\>20<space|0.27em><math-up|GeV>/c>,
  <math|<EtMiss>\<gtr\>20<space|0.27em><math-up|GeV>>, and at least four jets
  with <math|E<rsub|T>\<gtr\>20<space|0.27em><math-up|GeV>> and
  <math|<around|\||\<eta\>|\|>\<less\>2.0>, one of them identified as a
  <math|b>-quark jet. The most commonly used algorithm to identify
  <math|b>-quark jets is based on the reconstruction of secondary vertices in
  jets, exploiting the relatively long lifetime of <math|b>-hadrons and a
  large Lorentz boost. The typical decay length of <math|b>-hadrons in
  high-<math|p<rsub|T>> <math|b>-quark jets is on the order of a few
  millimeters. The requirement of a secondary vertex within one of the jets
  leads to a large reduction of the <math|W>+jets background by roughly a
  factor of 50, while the selection efficiency for <math|t*<wide|t|\<bar\>>>
  events is about 50% to 60%.

  The most recent CDF analysis based on secondary vertex <math|b>
  tagging<nbsp><cite|Aaltonen:2010ic> is a counting experiment in which the
  background rate is estimated using a combination of simulated events and
  data driven methods. The signal region is defined as the data set with a
  leptonic <math|W> candidate plus <math|\<geq\>3> jets. To further suppress
  background, a cut on the sum of all transverse energies
  <math|H<rsub|T>\<gtr\>230<space|0.17em><math-up|GeV>> is applied. The jet
  multiplicity distribution of the <math|W>+jets data set observed by this
  CDF analysis is shown in Figure<nbsp><reference|fig:Wjets>.

  <\big-figure>
    <image|njetplot.eps|0.5tex-text-width|||>

    \;
  </big-figure|<label|fig:Wjets>Jet multiplicity distribution for the
  <math|W>+jets data set, where the <math|W> boson is reconstructed in its
  leptonic decay <math|W<rsup|\<pm\>>\<rightarrow\>\<ell\><rsup|\<pm\>>*\<nu\><rsub|\<ell\>><around|(|<wide|\<nu\>|\<bar\>><rsub|\<ell\>>|)>>.
  A cut on <math|H<rsub|T>\<gtr\>230<space|0.17em><math-up|GeV>> was applied.
  The analyzed data set corresponds to <math|4.3<space|0.17em><with|math-font-family|rm|fb<rsup|-1>>>
  of CDF data.>

  The uncertainty on the luminosity measurement is reduced by measuring the
  ratio of <math|t*<wide|t|\<bar\>>>-to-<math|Z>-boson cross sections and the
  measured cross section is found to be <math|7.32\<pm\>0.36<space|0.17em><around|(|<math-up|stat>|)>\<pm\>0.59<around|(|<math-up|syst>|)>\<pm\>0.14<space|0.17em><around|(|<with|math-font-family|rm|Z<space|0.27em>theory>|)><space|0.27em><math-up|pb>>,
  assuming <math|m<rsub|t>=172.5<space|0.27em><math-up|GeV>/c<rsup|2>>. The
  cross section of <math|t*<wide|t|\<bar\>>> production and
  <math|Z/\<gamma\><rsup|\<ast\>>\<rightarrow\>\<ell\><rsup|+>*\<ell\>->
  production are measured in data samples corresponding to the same
  integrated luminosity. By forming the ratio of both measured cross sections
  and multiplying by the well-known theoretical
  <math|Z/\<gamma\><rsup|\<ast\>>\<rightarrow\>\<ell\><rsup|+>*\<ell\>->
  cross section the luminosity uncertainty of 6% is effectively removed and
  replaced by the uncertainty on the <math|Z/\<gamma\><rsup|\<ast\>>> cross
  section of 2%. In a similar measurement the Dcollaboration measured
  <math|\<sigma\><rsub|t*<wide|t|\<bar\>>>=7.93<rsup|+1.04><rsub|-0.91><space|0.27em><math-up|pb>><nbsp><cite|D0_CONF_6037>.

  Recently, the first observations of <math|t*<wide|t|\<bar\>>> pairs
  produced at the LHC have been made by the ATLAS and CMS
  collaborations<nbsp><cite|Collaboration:2010ey|Khachatryan:2010ez>. The
  measured <math|t*<wide|t|\<bar\>>> cross section at
  <math|<sqrt|s>=7<space|0.17em><math-up|TeV>> is
  <math|\<sigma\><rsub|t*<wide|t|\<bar\>>>=145\<pm\>31<space|0.17em><around|(|<math-up|stat>|)><space|0.27em><rsup|+42><rsub|-27><space|0.17em><around|(|<math-up|syst>|)><space|0.27em><math-up|pb>>
  and <math|\<sigma\><rsub|t*<wide|t|\<bar\>>>=194\<pm\>72<space|0.17em><around|(|<math-up|stat>|)>\<pm\>24<space|0.17em><around|(|<math-up|syst>|)>\<pm\>21<around|(|<math-up|lumi>|)><space|0.27em><math-up|pb>>,
  respectively.

  <section|The measurement of <math|\<cal-R\><rsub|b>>><label|subsec:top>

  In the SM the top quark is predicted to decay to a <math|W> boson and a
  <math|b> quark with a branching fraction
  <math|\<cal-R\><rsub|b>\<equiv\><math-up|BR><around|(|t\<rightarrow\>W*b|)>>
  close to 100%. This prediction is obtained in the following way. In
  general, the top quark can decay in three channels
  <math|t\<rightarrow\>d/s/b+W<rsup|+>> and <math|\<cal-R\><rsub|b>> is given
  by the ratio of the squares of the relevant CKM matrix elements:
  <math|\<cal-R\><rsub|b>=<around|\||V<rsub|t*b>|\|><rsup|2>/<around|(|<around|\||V<rsub|t*d>|\|><rsup|2>+<around|\||V<rsub|t*s>|\|><rsup|2>+<around|\||V<rsub|t*b>|\|><rsup|2>|)>>.
  In the SM the CKM matrix has to be unitary
  (<math|<with|math-font-family|bf|V V<rsup|\<dag\>>>=<with|math-font-family|bf|V<rsup|\<dag\>>V>=<with|math-font-family|bf|1>>),
  which leads to <math|<around|\||V<rsub|t*d>|\|><rsup|2>+<around|\||V<rsub|t*s>|\|><rsup|2>+<around|\||V<rsub|t*b>|\|><rsup|2>=1>
  and thereby to <math|\<cal-R\><rsub|b>=<around|\||V<rsub|t*b>|\|><rsup|2>>.
  Our present knowledge on <math|<around|\||V<rsub|t*b>|\|>> stems primarily
  from measurements of <math|b>-meson and <math|c>-meson decays which
  determine the values of the other CKM matrix elements. Using the unitarity
  condition of the CKM matrix one can obtain
  <math|<around|\||V<rsub|t*b>|\|>> in an indirect way. This method yields
  <math|<around|\||V<rsub|t*b>|\|>=0.999133\<pm\>0.000044> with very high
  precision<nbsp><cite|Amsler:2008zzb>.

  Only recently a determination of <math|<around|\||V<rsub|t*b>|\|>> without
  unitarity assumption was obtained from the measurement of the single
  top-quark cross section, yielding <math|<around|\||V<rsub|t*b>|\|>=0.88\<pm\>0.07><nbsp><cite|Group:2009qk>.
  However, if a fourth generation of quarks was present, the unitarity of the
  <math|3\<times\>3> CKM matrix could be violated. Therefore, it is desirable
  to make a direct measurement of <math|\<cal-R\><rsub|b>> using
  <math|t*<wide|t|\<bar\>>> candidate events.

  In most <math|t*<wide|t|\<bar\>>> cross section analyses the assumption
  <math|\<cal-R\><rsub|b>=1> is made, but CDF and D have also made two
  measurements without this constraint<nbsp><cite|Affolder:2000xb|Acosta:2005hr|Abazov:2008yn>.
  In the latest analysis from D<nbsp><cite|Abazov:2008yn> the <math|W>+jets
  data set is split in various disjoint subsets according to the number of
  jets (0, 1, or <math|\<geq\>2>), the charged lepton type (electron or
  muon), and most importantly the number of <math|b>-tagged jets. The fit
  results are: <math|\<cal-R\><rsub|b>=0.97<rsup|+0.09><rsub|-0.08>> and
  <math|\<sigma\>*<around|(|t*<wide|t|\<bar\>>|)>=8.18<rsup|+0.90><rsub|-0.84>\<pm\>0.50<space|0.27em><around|(|<math-up|lumi>|)><space|0.17em><math-up|pb>>,
  where the statistical and systematic uncertainties have been combined. The
  lower limit on <math|\<cal-R\><rsub|b>> is determined to be
  <math|\<cal-R\><rsub|b>\<gtr\>0.79> at the 95% C.L. In terms of the CKM
  matrix elements this result can be summarized by the following relation:

  <\equation>
    <around|\||V<rsub|t*d>|\|><rsup|2>+<around|\||V<rsub|t*s>|\|><rsup|2>\<less\>0.263\<cdot\><around|\||V<rsub|t*b>|\|><rsup|2>
  </equation>

  at the 95% C.L. The measurement quoted above is based on a data set
  corresponding to <math|0.9<space|0.17em><with|math-font-family|rm|fb<rsup|-1>>>,
  which is only a small fraction of the available data at the Tevatron. In
  this measurement the statistical and systematic uncertainties have about
  the same size. If the an update to the full data set was made, the
  measurement would be completely systematically limited.

  <section|Measurement of Single-Top Production>

  While <math|t*<wide|t|\<bar\>>> pair production via the strong interaction
  is the main source of top quarks at the Tevatron and the LHC, top quarks
  can also be produced singly via weak interactions involving the
  <math|W*t*b> vertex. There are three production modes which are
  distinguished by the virtuality, <math|Q<rsup|2>>, of the <math|W> boson.
  The dominant process is the <math|t> channel exchange of a virtual
  <math|W>, depicted in Fig.<nbsp><reference|fig:feynman><subref|fig:tchan>.

  <big-figure|<with|par-mode|center|<subfigure*||<image|singTopWg3Pict.epsi|0.25tex-text-width|||><label|fig:tchan>
  > <space|0.07tex-text-width> <subfigure*||<image|singTopAssocPict.epsi|0.18tex-text-width|||><label|fig:Wt>
  > <space|0.07tex-text-width> <subfigure*||<image|singTopSChanPict.epsi|0.18tex-text-width|||><label|fig:schan>
  ><label|fig:feynman>>|Feynman diagrams of single top-quark production
  processes. <subref|fig:tchan> <math|t> channel production, <subref|fig:Wt>
  associcated <math|W*t> production, and <subref|fig:schan> <math|s> channel
  production.>

  At the LHC, the subprocess with the second highest cross section is the
  associcated production of an on-shell <math|W> boson and a top quark, see
  Fig.<nbsp><reference|fig:feynman><subref|fig:Wt>. At the Tevatron,
  <math|W*t> production has a negligible cross section compared to the other
  two processes. The Drell-Yan type production of a
  <math|t*<wide|b|\<bar\>>>, see Fig.<nbsp><reference|fig:feynman><subref|fig:schan>,
  has only subleading character at the LHC, but is relevant at the Tevatron.

  While Run<nbsp>1 (1992\U1996) and early Run<nbsp>2 searches for single top
  quarks at CDF and D could only set upper limits on the production cross
  section<nbsp><cite|Acosta:2004bs|Abazov:2006uq>, analyses using more data
  and advanced analysis techniques were able to observe singly produced top
  quarks in March 2009 with a significance of five Gaussian standard
  deviations<nbsp><cite|Aaltonen:2009jj|Aaltonen:2010jr|Abazov:2009ii>. These
  analyses consider both production modes relevant at the Tevatron, <math|t>
  channel and <math|s> channel, as one single-top signal, assuming the ratio
  of <math|t> channel to <math|s> channel events to be given by the SM. This
  search strategy is often referred to as <with|font-shape|italic|combined
  search>. By measuring the inclusive single top-quark cross section and
  using theory predictions, one can deduce the absolute value of the CKM
  matrix element <math|V<rsub|t*b>>, without the assumption that there are
  only three generations of quarks. If one measured
  <math|<around|\||V<rsub|t*b>|\|>> to be significantly smaller than one this
  would be a strong indication for a fourth generation of quarks or other
  effects beyond the SM<nbsp><cite|Eberhardt:2010bm|Bobrowski:2009ng|Alwall:2006bx>.

  Single top-quark events feature a <math|W*b*<wide|b|\<bar\>>>
  (<math|s>-channel) or <math|W*b*q*<wide|b|\<bar\>>> (<math|t>-channel)
  partonic final state. The most sensitive analyses reconstruct the <math|W>
  boson originating from the top-quark decay in its leptonic decay modes
  <math|e*\<nu\><rsub|e>> or <math|\<mu\>*\<nu\><rsub|\<mu\>>>, while
  hadronic <math|W> decays and decays to <math|\<tau\>*\<nu\><rsub|\<tau\>>>
  are not explicitly considered, because of large backgrounds from
  QCD-induced jet production. The quarks from the hard scattering process
  manifest themselves as hadronic jets with large transverse momentum.
  Additional jets may arise from hard gluon radiation in the initial or final
  state. The experimental signature of SM single top-quarks is therefore
  given by one isolated high-<math|p<rsub|T>> charged lepton (electron or
  muon), large missing transverse energy (<math|<EtMiss>>), and two or three
  high-<math|E<rsub|T>> jets, of which one or two originate from a <math|b>
  or <math|<wide|b|\<bar\>>> quark.

  The dominating background process is <math|W*b*<wide|b|\<bar\>>>, followed
  by misidentified <math|W+> light-quark jet events,
  <math|W*c*<wide|c|\<bar\>>>, and <math|W*c*j>. In the <math|W+3> jets
  data-set <math|t*<wide|t|\<bar\>>> is the most important background. The
  total event detection efficiency of single top-quark events is about 2% for
  the <math|t>-channel process and about 3% for the <math|s> channel. Even
  though the single top-quark production cross section is predicted to amount
  to about 40% of the <math|t*<wide|t|\<bar\>>> cross section, the signal has
  been obscured for a long time by the very challenging background. After the
  cut-based event selection sketched above, the signal-to-background ratio is
  only about 5 to 6%. Further kinematic cuts on the event topology proved to
  be prohibitive, since the number of signal events in the resulting data set
  would become too small. Facing this challenge, the analysis groups in both
  Tevatron collaborations turned to multivariate techniques, in order to
  exploit as much information about the observed events as possible. The
  explored techniques comprise artificial neural networks, LO matrix
  elements, boosted decision trees, and likelihood ratios. All these
  techniques combine the information contained in several variables into one
  powerful discriminant, maximising the separation between the single
  top-quark signal and the backgrounds. All multivariate analyses see a
  signal of single top-quark production with significances ranging from 2.4
  to 5.2 Gaussian standard deviations. To obtain the most precise result, all
  analyses of the two collaborations are combined, resulting in a single
  top-quark cross section of <math|2.76<rsup|+0.58><rsub|-0.47><space|0.27em><math-up|pb>>
  (at <math|m<rsub|t>=170<space|0.17em><math-up|GeV>/c<rsup|2>>)<nbsp><cite|Group:2009qk>.

  The measured single top-quark production cross sections can be used to
  determine the absolute value of the CKM-matrix element <math|V<rsub|t*b>>,
  if one assumes <math|V<rsub|t*b>\<gg\>V<rsub|t*s>>,
  <math|V<rsub|t*b>\<gg\>V<rsub|t*d>>, and a SM-like left-handed coupling at
  the <math|W*t*b> vertex. Contrary to indirect determinations in the
  framework of flavour physics the extraction of
  <math|<around|\||V<rsub|t*b>|\|>> via single top-quark production does not
  assume unitarity of the CKM matrix and is thereby sensitive to a fourth
  generation of quarks. The assumption of <math|V<rsub|t*s>> and
  <math|V<rsub|t*d>> being small compared to <math|V<rsub|t*b>> enters on the
  production side, since top quarks can also be produced by <math|W*t*s> and
  <math|W*t*d> vertices, and in top-quark decay. The phenomenological
  analysis of<nbsp><cite|Eberhardt:2010bm|Bobrowski:2009ng> as well as the
  measurement of <math|R<rsub|b>>, see<nbsp><reference|subsec:top>, indicate
  that this assumption is well justified. To determine
  <math|<around|\||V<rsub|t*b>|\|>> the analysts divide the measured single
  top-quark cross section by the predicted value, which assumes
  <math|<around|\||V<rsub|t*b>|\|>=1>, and take the square root. Based on the
  combined cross-section result the Tevatron collaborations obtain
  <math|<around|\||V<rsub|t*b>|\|>=0.88\<pm\>0.07><nbsp><cite|Group:2009qk>.

  <section|Conclusion>

  Measurements of top-quark production and decay add valuable information to
  determine or constrain the CKM matrix elements <math|V<rsub|t*b>>,
  <math|V<rsub|t*s>>, and <math|V<rsub|t*d>>. These experimental constraints
  are complementary to measurements made with <math|b> and <math|c> hadrons.
  The measurements of <math|R<rsub|b>> and the single top-quark cross section
  lead currently to the contraints

  <\equation*>
    <around|\||V<rsub|t*d>|\|><rsup|2>+<around|\||V<rsub|t*s>|\|><rsup|2>\<less\>0.263\<cdot\><around|\||V<rsub|t*b>|\|><rsup|2>

    <with|math-font-family|rm|at \ the>*95%<space|0.17em><with|math-font-family|rm|C.L.and>
  </equation*>

  <\equation*>
    <around|\||V<rsub|t*b>|\|>=0.88\<pm\>0.07<space|0.27em>.
  </equation*>

  In the future it may be possible to also constrain <math|V<rsub|t*s>> and
  <math|V<rsub|t*d>> in measurements of single top-quark production, even
  though it will be very challenging to disentangle the different production
  modes experimentally. At the LHC, single top quarks will be produced in
  ample numbers, allowing for detailed investigations. However, the priority
  for the near future will be to establish a single top-quark signal at ATLAS
  and CMS. Strategies for the analysis of early LHC data have been devised by
  both collaborations<nbsp><cite|ATL-PHYS-PUB-2010-003|CMS-PAS-TOP-09-005>.

  <Acknowledgements>The author acknowledges the financial support of the
  Helmholtz-Alliance <with|font-shape|italic|Physics at the Terascale>.

  <\thebibliography|99>
    <bibitem|Langenfeld:2009wd>U.<nbsp>Langenfeld, S.<nbsp>Moch and
    P.<nbsp>Uwer, Phys. Rev. D <with|font-series|bold|80> (2009) 054009
    [arXiv:0906.5273 [hep-ph]].

    <bibitem|Abazov:2008gc>V.<nbsp>M.<nbsp>Abazov <with|font-shape|italic|et
    al.> [D0 Collaboration], Phys. Rev. Lett. <with|font-series|bold|100>
    (2008) 192004 [arXiv:0803.2779 [hep-ex]].

    <bibitem|Aaltonen:2010ic>T.<nbsp>Aaltonen <with|font-shape|italic|et al.>
    [CDF Collaboration], Phys. Rev. Lett. <with|font-series|bold|105>, 012001
    (2010) [arXiv:1004.3224 [hep-ex]].

    <bibitem|Collaboration:2010ey>The ATLAS Collaboration, [arXiv:1012.1792
    [hep-ex]].

    <bibitem|Khachatryan:2010ez>V.<nbsp>Khachatryan
    <with|font-shape|italic|et al.> [CMS Collaboration], Phys. Lett. B
    <with|font-series|bold|695> (2011) 424 [arXiv:1010.5994 [hep-ex]].

    <bibitem|D0_CONF_6037>The DCollaboration, public conference note no.
    6037-CONF, May 2010.

    <bibitem|Amsler:2008zzb>C.<nbsp>Amsler <with|font-shape|italic|et al.>
    [Particle Data Group], Phys. Lett. B <with|font-series|bold|667> (2008)
    1.

    <bibitem|Group:2009qk>T.<nbsp>E.<nbsp>W.<nbsp>Group [CDF Collaboration
    and D0 Collaboration], arXiv:0908.2171 [hep-ex].

    <bibitem|Affolder:2000xb>A.<nbsp>A.<nbsp>Affolder
    <with|font-shape|italic|et al.> [CDF Collaboration], Phys. Rev. Lett.
    <with|font-series|bold|86> (2001) 3233 [arXiv:hep-ex/0012029].

    <bibitem|Acosta:2005hr>D.<nbsp>E.<nbsp>Acosta <with|font-shape|italic|et
    al.> [CDF Collaboration], Phys. Rev. Lett. <with|font-series|bold|95>
    (2005) 102002 [arXiv:hep-ex/0505091].

    <bibitem|Abazov:2008yn>V.<nbsp>M.<nbsp>Abazov <with|font-shape|italic|et
    al.> [D0 Collaboration], Phys. Rev. Lett. <with|font-series|bold|100>
    (2008) 192003 [arXiv:0801.1326 [hep-ex]].

    <bibitem|Acosta:2004bs>D.<nbsp>E.<nbsp>Acosta <with|font-shape|italic|et
    al.> [CDF Collaboration], Phys. Rev. D <with|font-series|bold|71> (2005)
    012005 [arXiv:hep-ex/0410058].

    <bibitem|Abazov:2006uq>V.<nbsp>M.<nbsp>Abazov <with|font-shape|italic|et
    al.> [D0 Collaboration], Phys. Rev. D <with|font-series|bold|75> (2007)
    092007 [arXiv:hep-ex/0604020].

    <bibitem|Aaltonen:2009jj>T.<nbsp>Aaltonen <with|font-shape|italic|et al.>
    [CDF Collaboration], Phys. Rev. Lett. <with|font-series|bold|103> (2009)
    092002 [arXiv:0903.0885 [hep-ex]].

    <bibitem|Aaltonen:2010jr>T.<nbsp>Aaltonen <with|font-shape|italic|et al.>
    [CDF Collaboration], Phys. Rev. D <with|font-series|bold|82> (2010)
    112005 [arXiv:1004.1181 [hep-ex]].

    <bibitem|Abazov:2009ii>V.<nbsp>M.<nbsp>Abazov <with|font-shape|italic|et
    al.> [D0 Collaboration], Phys. Rev. Lett. <with|font-series|bold|103>
    (2009) 092001 [arXiv:0903.0850 [hep-ex]].

    <bibitem|Bobrowski:2009ng>M.<nbsp>Bobrowski, A.<nbsp>Lenz, J.<nbsp>Riedl
    and J.<nbsp>Rohrwild, Phys. Rev. D <with|font-series|bold|79> (2009)
    113006 [arXiv:0902.4883 [hep-ph]].

    <bibitem|Alwall:2006bx>J.<nbsp>Alwall <with|font-shape|italic|et al.>,
    Eur. Phys. J. C <with|font-series|bold|49> (2007) 791
    [arXiv:hep-ph/0607115].

    <bibitem|Eberhardt:2010bm>O.<nbsp>Eberhardt, A.<nbsp>Lenz and
    J.<nbsp>Rohrwild, Phys. Rev. D <with|font-series|bold|82> (2010) 095006
    [arXiv:1005.3505 [hep-ph]].

    <bibitem|ATL-PHYS-PUB-2010-003>The ATLAS Collaboration,
    ATL-PHYS-PUB-2010-003, May 2010.

    <bibitem|CMS-PAS-TOP-09-005>The CMS Collaboration, CMS-PAS-TOP-09-005,
    2009.
  </thebibliography>
</body>