<TeXmacs|1.99.7>

<style|<tuple|aps|std-latex>>

<\body>
  <doc-data|<doc-title|Next-to-leading QCD effect to the quark compositeness
  search at the LHC>|<doc-author|<author-data|<author-name|Jun
  Gao>>>|<doc-author|<author-data|<author-name|Chong Sheng
  Li>>>|<doc-author|<author-data|<author-name|Jian
  Wang>>>|<doc-author|<author-data|<author-name|Hua Xing
  Zhu>>>|<doc-author|<author-data|<author-name|C.-P.Yuan>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    Recently, the CMS and ATLAS Collaborations at the CERN Large Hadron
    Collider (LHC) have set exclusion limits on the quark compositeness scale
    by comparing their data to the leading order and the scaled
    next-to-leading order (NLO) QCD calculations, respectively. In this
    Letter, we present the exact NLO QCD corrections to the dijet production
    induced by the quark contact interactions. We show that as compared to
    the exact calculation, the scaled NLO QCD prediction adopted by the ATLAS
    Collaboration has overestimated the new physics effect on some direct
    observables by more than 30% and renders a higher limit on the quark
    compositeness scale. The destructive contribution from the exact NLO
    correction will also lower the compositeness scale limit set by the CMS
    Collaboration.
  </abstract>>

  The quark composite models have been studied extensively in the
  literature<nbsp><cite|Eichten:1983hw|Lane:1996gr>. It is assumed that
  quarks are composed of more fundamental particles with new strong
  interactions at a composite scale <math|\<Lambda\>>, much greater than the
  quark masses. At energy well below <math|\<Lambda\>>, quark contact
  interactions are induced by the underlying strong dynamics, and yield
  observable signals at hadron colliders. For example, the dijet production
  at the CERN Large Hadron Collider (LHC) could be largely modified. In the
  Standard Model (SM), the theory of Quantum Chromodynamics (QCD) predicts
  the jets in dijet events are preferably produced in large rapidity region,
  via small angle scatterings in t-channel processes. On the contrary, the
  dijet angular distribution induced by the quark contact interactions is
  expected to be more isotropic. The D0 and CDF Collaborations at the
  Fermilab Tevatron have set limits on the scale <math|\<Lambda\>> based on
  their dijet data<nbsp><cite|Abe:1996mj>. Recently, both the ATLAS and CMS
  collaborations have carried out similar
  analyses<nbsp><cite|Collaboration:2010eza|Khachatryan:2010te> using the LHC
  dijet data with <math|<sqrt|s>=7><with|font-family|rm|TeV> and an
  integrated luminosity of about <math|3>

  <with|font-family|rm|pb><rsup|-1>. The observed limits for
  <math|\<Lambda\>> at the <math|95%> confidence level (CL) are
  <math|3.4><with|font-family|rm|TeV> and
  <math|4.0><with|font-family|rm|TeV>, respectively, which have already
  exceeded the previous limits. With more integrated luminosity collected,
  these limits will be further improved.

  The limits on the composite scale <math|\<Lambda\>> were obtained by
  comparing the experimental dijet data with various theory predictions,
  including the SM NLO QCD corrections and contribution induced by the quark
  contact interactions<nbsp>which were handled differently in different
  experiments. While the CMS Collaboration included only the leading order
  (LO) contribution from the quark contact
  interactions<nbsp><cite|Khachatryan:2010te>, the D0, CDF and ATLAS
  Collaborations included the \Pscaled NLO QCD correction\Q which assumes the
  NLO correction (in terms of K-factors) to the dijet production from the
  contact interactions to be exactly the same as that from the SM QCD
  interactions<nbsp><cite|Abe:1996mj|Collaboration:2010eza>. In this Letter,
  we present the exact NLO QCD correction to the dijet production induced by
  the quark contact interactions, and discuss its impact to the existing
  experimental limits set by both the ATLAS and CMS Collaborations.

  To compare with the experimental analyses, we consider only the quark
  contact interactions that are the products of left-handed electroweak
  isoscalar quark currents which are assumed to be flavor-symmetric to avoid
  large flavor-changing neutral-current interactions<nbsp><cite|Lane:1996gr>.
  The effective Lagrangian can be written as

  <\equation>
    \<cal-L\><rsub|N*P>=<frac|1|2*\<Lambda\><rsup|2>>*<around|(|c<rsub|1>*O<rsub|1>+c<rsub|2>*O<rsub|2>|)>,
  </equation>

  where <math|c<rsub|1>>, <math|c<rsub|2>> are the Wilson coefficients, and
  <math|O<rsub|1>>, <math|O<rsub|2>> are the color-singlet and color-octet
  operators given by

  <eqnarray|<tformat|<table|<row|<cell|O<rsub|1>>|<cell|=>|<cell|\<delta\><rsub|i*j>*\<delta\><rsub|k*l><around*|(|<big|sum><rsub|c=1><rsup|3><wide|q|\<bar\>><rsub|L*c*i>*\<gamma\><rsub|\<mu\>>*q<rsub|L*c*j>*<big|sum><rsub|d=1><rsup|3><wide|q|\<bar\>><rsub|L*d*k>*\<gamma\><rsup|\<mu\>>*q<rsub|L*d*l>|)>,>>|<row|<cell|O<rsub|2>>|<cell|=>|<cell|<math-up|T><rsub|i*j><rsup|a><math-up|T><rsub|k*l><rsup|a><around*|(|<big|sum><rsub|c=1><rsup|3><wide|q|\<bar\>><rsub|L*c*i>*\<gamma\><rsub|\<mu\>>*q<rsub|L*c*j>*<big|sum><rsub|d=1><rsup|3><wide|q|\<bar\>><rsub|L*d*k>*\<gamma\><rsup|\<mu\>>*q<rsub|L*d*l>|)>,<eq-number>>>>>>

  in which <math|c>, <math|d> are the generation indices and <math|i>,
  <math|j>, <math|k>, <math|l>, <math|a> are the color indices, and
  <with|font-family|rm|T><rsup|<math|a>> are the Gell-Mann matrices. Here, we
  have included both the color-singlet and color-octet operators since they
  mix with each other at the NLO in QCD. The Wilson coefficients at the scale
  <math|\<Lambda\>> are conventionally normalized to be
  <math|c<rsub|1><around|(|\<Lambda\>|)>=4*\<pi\>*cos \<theta\>>,

  c<rsub|2>(\<Lambda\>)=4\<pi\>sin \<theta\>, with
  <math|0\<leq\>\<theta\>\<less\>2*\<pi\>>. Notice that the above operators
  can also arise from the exchange of new heavy resonances in various new
  physics models, such as <math|Z<rprime|'>>
  models<nbsp><cite|Langacker:2008yv> and extra dimensions
  models<nbsp><cite|Randall:1999ee>. Thus, our analyses are rather model
  independent and <math|\<Lambda\>> can be identified as the effective new
  physics (NP) scale. When using the above operators to calculate an
  observable at a scale much lower than <math|\<Lambda\>>, we have to
  consider the QCD running effects of the Wilson
  coefficients<nbsp><cite|Buchalla:1995vs>, which can be easily derived by
  solving the renormalization group equation using the one-loop anomalous
  dimension matrix of the operators, as following:

  <\equation>
    <around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|c<rsub|1><around|(|\<mu\><rsub|R>|)>>>|<row|<cell|c<rsub|2><around|(|\<mu\><rsub|R>|)>>>>>>|)>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|2|2|cell-rborder|0ln>|<table|<row|<cell|<frac|N+1|2*N>>|<cell|<frac|N-1|2*N>>>|<row|<cell|1>|<cell|-1>>>>>|)><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|1|1|cell-rborder|0ln>|<table|<row|<cell|b<rsub|1>*r<rsup|<frac|-3*<around|(|N-1|)>|N*\<beta\><rsub|0>>>>>|<row|<cell|b<rsub|2>*r<rsup|<frac|3*<around|(|N+1|)>|N*\<beta\><rsub|0>>>>>>>>|)>,
  </equation>

  with <math|r=\<alpha\><rsub|s><around|(|\<mu\><rsub|R>|)>/\<alpha\><rsub|s><around|(|\<Lambda\>|)>>,
  and

  <\equation>
    b<rsub|1>=c<rsub|1><around|(|\<Lambda\>|)>+<frac|C<rsub|F>|N+1>*c<rsub|2><around|(|\<Lambda\>|)>,

    b<rsub|2>=c<rsub|1><around|(|\<Lambda\>|)>-<frac|C<rsub|F>|N-1>*c<rsub|2><around|(|\<Lambda\>|)>,
  </equation>

  where <math|N=3> and <math|C<rsub|F>=4/3> for QCD,
  <math|\<beta\><rsub|0>=<around|(|11*N-2*n<rsub|f>|)>/3>, and
  <math|\<mu\><rsub|R>> is the renormalization scale, <math|n<rsub|f>=5> is
  the number of active quark flavors. In the studies of the ATLAS and CMS
  Collaborations, they focus on the color-singlet operator with destructive
  interference, which corresponds to <math|\<theta\>=0> in our analyses.
  Below, we will first discuss this case, and then extend to more general
  cases with arbitrary <math|\<theta\>> values.

  At the LO, there are several subprocesses which contribute to the dijet
  production at hadron colliders induced by the NP operators we considered,
  including

  <\equation>
    q*q<rprime|'><around|(|q|)>\<rightarrow\>q*q<rprime|'><around|(|q|)>,q*<wide|q|\<bar\>><rprime|'>\<rightarrow\>q*<wide|q|\<bar\>><rprime|'>,q*<wide|q|\<bar\>>\<rightarrow\>q*<wide|q|\<bar\>>*<around|(|q<rprime|'>*<wide|q|\<bar\>><rprime|'>|)>,
  </equation>

  where <math|q>, <math|q<rprime|'>> could be all the light quarks except the
  top quark. The NP contributions included in our calculation consist of two
  parts, the NP squared terms and the interference terms between the NP and
  the SM QCD interactions, which have different behavior with the increase of
  dijet invariant mass. We carried out the NLO calculations in the Feynman-'t
  Hooft gauge with dimensional regularization (DR) scheme (with naive
  <math|\<gamma\><rsub|5>> prescription)<nbsp><cite|Buchalla:1995vs> in
  <math|n=4-2*\<epsilon\>> dimensions to regularize all the divergences.
  Below, we only show the analytical results for the subprocess
  <math|q<around|(|p<rsub|1>|)>*q<rprime|'><around|(|p<rsub|2>|)>\<rightarrow\>q<around|(|p<rsub|3>|)>*q<rprime|'><around|(|p<rsub|4>|)>>,
  since the similar results for other subprocesses can be obtained by
  crossing symmetry.

  First, we define the following abbreviations for the color structures and
  the matrix element,

  <\eqnarray>
    <\tformat>
      <\table|<row|<cell|\<cal-M\><rsub|0>>|<cell|=>|<cell|<wide|u|\<bar\>><rsub|L><around|(|p<rsub|3>|)>*\<gamma\><rsub|\<mu\>>*u<rsub|L><around|(|p<rsub|1>|)>*<wide|u|\<bar\>><rsub|L><around|(|p<rsub|4>|)>*\<gamma\><rsup|\<mu\>>*u<rsub|L><around|(|p<rsub|2>|)>,>>>
        <\row|<cell|\<cal-C\><rsub|1>>|<cell|=>>
          <\cell>
            \<delta\><rsub|i<rsub|3>*i<rsub|1>>*\<delta\><rsub|i<rsub|4>*i<rsub|2>>,

            \<cal-C\><rsub|2>=<math-up|T><rsub|i<rsub|3>*i<rsub|1>><rsup|a><math-up|T><rsub|i<rsub|4>*i<rsub|2>><rsup|a>,
          </cell>

          <eq-number>
        </row>
      </table>
    </tformat>
  </eqnarray>

  where <math|i<rsub|1>>, <math|i<rsub|2>>, <math|i<rsub|3>> and
  <math|i<rsub|4>> are the color indices of the external quarks. The LO
  scattering amplitudes induced by the NP and the SM QCD interactions can be
  separately written as

  <eqnarray|<tformat|<table|<row|<cell|i*\<cal-M\><rsub|N*P><rsup|t*r*e*e>>|<cell|=>|<cell|i*\<cal-M\><rsub|0>*<around|(|c<rsub|1>*\<cal-C\><rsub|1>+c<rsub|2>*\<cal-C\><rsub|2>|)>/\<Lambda\><rsup|2>,>>|<row|<cell|i*\<cal-M\><rsub|S*M><rsup|t*r*e*e>>|<cell|=>|<cell|i*\<cal-M\><rsub|0>*<around|(|4*\<pi\>*\<alpha\><rsub|s>*\<cal-C\><rsub|2>|)>/t,<eq-number>>>>>>

  where <math|s,t,u> are the Mandelstam variables, and we only keep the
  left-handed current product of the SM QCD amplitudes here since others have
  no interference with the NP interactions. After adding the 1-loop
  amplitudes and the corresponding counterterms, we have the ultraviolet
  finite virtual amplitudes as follows.

  <eqnarray|<tformat|<table|<row|<cell|i*\<cal-M\><rsup|v><rsub|N*P>>|<cell|=>|<cell|i*\<cal-M\><rsub|0>*C<rsub|\<epsilon\>>*<frac|\<alpha\><rsub|s>|4*\<pi\>>*<around*|{|-2*C<rsub|F>*<around*|[|c<rsub|1>*\<cal-A\><around|(|t|)>+<frac|c<rsub|2>|2*N>*\<cal-B\><around|(|u|)>|]>*\<cal-C\><rsub|1>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<space|-1cm>+<around*|[|c<rsub|1>*<around*|(|-2*\<cal-B\><around|(|u|)>|)>+c<rsub|2>*<around*|(|-2*C<rsub|F>*\<cal-A\><around|(|u|)>+<frac|1|N>*<around*|(|\<cal-B\><around|(|u|)>+|\<nobracket\>>|\<nobracket\>>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|<around*|\<nobracket\>|<around*|\<nobracket\>|<around*|\<nobracket\>|<space|-1cm>\<cal-B\><around|(|t|)>|)>|)>|]>*\<cal-C\><rsub|2>|}>/\<Lambda\><rsup|2>,>>|<row|<cell|i*\<cal-M\><rsup|v><rsub|S*M>>|<cell|=>|<cell|i*\<cal-M\><rsub|0>*C<rsub|\<epsilon\>>*<frac|\<alpha\><rsub|s>|4*\<pi\>>*<around*|{|4*\<pi\>*\<alpha\><rsub|s>*<around*|[|-<frac|C<rsub|F>|2*N>*<around*|(|<frac|4|\<epsilon\>>*ln|(>-<frac|s|u>|)>-|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|<around*|\<nobracket\>|<space|-1cm>2*<frac|t|s>*ln
  <around|(|<frac|t|u>|)>-<frac|u<rsup|2>|s<rsup|2>>*ln<rsup|2><around|(|<frac|t|u>|)>+ln<rsup|2><around|(|<frac|s<rsup|2>|t*u>|)>+<around|(|1-<frac|u<rsup|2>|s<rsup|2>>|)>*\<pi\><rsup|2>|)>|]>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|<space|-1cm>\<cal-C\><rsub|1>+4*\<pi\>*\<alpha\><rsub|s>*<around*|[|-2*C<rsub|F>*<around*|(|<frac|2|\<epsilon\><rsup|2>>+<frac|1|\<epsilon\>>*<around*|(|3+2*ln|(>-<frac|s|u>|)>|)>|)>>>|<row|<cell|>|<cell|>|<cell|<space|-1cm>+<frac|2|N*\<epsilon\>>*ln
  <around|(|<frac|s<rsup|2>|t*u>|)>+\<beta\><rsub|0>*ln
  <around|(|<frac|\<mu\><rsub|R><rsup|2>|s>|)>-<around*|(|<frac|2|3>*n<rsub|f>-<frac|10|3>*C<rsub|F>-<frac|8|3*N>|)>>>|<row|<cell|>|<cell|>|<cell|<space|-1cm>ln
  (-<frac|s|t>)+<frac|3|N>*ln<rsup|2>(-<frac|s|t>)-<around*|(|<frac|1|2*N>-C<rsub|F>|)><around*|(|<frac|u<rsup|2>|s<rsup|2>><around*|(|ln<rsup|2><around|(|<frac|t|u>|)>|\<nobracket\>>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|<space|-1cm>+\<pi\><rsup|2>|)>-2*<frac|u|s>*ln
  <around|(|<frac|t|u>|)>+ln<rsup|2><around|(|<frac|t|u>|)>-2*ln
  (-<frac|s|u>)<around*|(|1+|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|<around*|\<nobracket\>|<space|-1cm>ln
  (-<frac|s|u>)|)>|)>+<around*|(|C<rsub|F>+<frac|3|2*N>|)>*\<pi\><rsup|2>-<around*|(|<frac|10|9>*n<rsub|f>-<frac|26|9>*C<rsub|F>|\<nobracket\>>>>|<row|<cell|>|<cell|>|<cell|<around*|\<nobracket\>|<around*|\<nobracket\>|<around*|\<nobracket\>|<space|-1cm>-<frac|85|9*N>|)>|]>*\<cal-C\><rsub|2>|}>/t,<eq-number><label|e1>>>>>>

  \ where <math|C<rsub|\<epsilon\>>=<around|(|<frac|4*\<pi\>*\<mu\><rsub|R><rsup|2>|s>|)><rsup|\<epsilon\>><frac|1|\<Gamma\>*<around|(|1-\<epsilon\>|)>>>,
  and

  <eqnarray|<tformat|<table|<row|<cell|\<cal-B\><around|(|x|)>>|<cell|=>|<cell|<frac|2|\<epsilon\>>*ln
  (-<frac|s|x>)+3*ln (-<frac|\<mu\><rsub|R><rsup|2>|x>)+ln<rsup|2>(-<frac|s|x>)+\<pi\><rsup|2>+9,>>|<row|<cell|\<cal-A\><around|(|x|)>>|<cell|=>|<cell|<frac|2|\<epsilon\><rsup|2>>+<frac|3|\<epsilon\>>+<around|(|<frac|2|\<epsilon\>>+3|)>*ln
  (-<frac|s|x>)+ln<rsup|2>(-<frac|s|x>)+8.<eq-number>>>>>>

  We have checked that the virtual correction for the SM QCD contributions
  given in Eq.<nbsp>(<reference|e1>) agrees with the ones shown in
  Ref.<nbsp><cite|Ellis:1985er>. The infrared divergences in virtual
  corrections should cancel with those in real corrections. As for the real
  corrections, we applied both the two cutoff
  method<nbsp><cite|Harris:2001sx> and the dipole subtraction
  method<nbsp><cite|Catani:1996vz> in our calculations for a cross-check. Due
  to the limited space, we will present the details of our analytical
  calculations elsewhere, and discuss only the numerical results.

  To compare with the dijet measurements of the ATLAS and CMS, we adopt the
  anti-<math|k<rsub|T>> jet algorithm<nbsp><cite|Cacciari:2008gp> with the
  <math|E<rsub|T>> recombination scheme<nbsp><cite|Bayatian:2006zz> at parton
  level. We use the same parton distribution function
  sets<nbsp><cite|Pumplin:2002vw> and set both the renormalization and
  factorization scales to the average jet transverse momentum
  <math|p<rsub|T>>, as in the experimental analyses. Since our calculations
  are based on the effective field theory approach, we only consider the
  dijet invariant mas <math|m<rsub|j*j>> up to the NP scale
  <math|\<Lambda\>>. The SM QCD contributions are also calculated up to NLO,
  using both the modified EKS code<nbsp><cite|Ellis:1992en> and the NLOjet++
  program<nbsp><cite|Nagy:2003tz> for a cross-check.

  The ATLAS measurement \V Following the ATLAS analysis, we impose the
  following kinematic cuts for selecting the dijet events.

  <eqnarray|<tformat|<table|<row|<cell|<around|\||y<rsub|j*e*t>|\|>\<less\>2.8,p<rsub|T*1<around|(|2|)>>\<gtr\>60<around|(|30|)><math-up|GeV>,m<rsub|j*j>\<gtr\>1.2<math-up|TeV>,>>|<row|<cell|<around|\||y<rsub|b>|\|>=<around|\||y<rsub|1>+y<rsub|2>|\|>/2\<less\>0.75,<around|\||y<rsup|\<ast\>>|\|>=<around|\||y<rsub|1>-y<rsub|2>|\|>/2\<less\>1.7.<eq-number>>>>>>

  The jet cone size <math|\<Delta\>*R> is chosen to be 0.6. To quantify the
  NP effects on dijet angular distribution, we divide the region of
  <math|<around|\||y<rsup|\<ast\>>|\|>>, between 0 and 3.3/2, into 11 bins
  with equal bin width, and define <math|F> as the ratio of the number of
  events in the first 4 bins (with cross section
  <math|\<sigma\>*<around|(|4*t*h|)>>) to that in the total 11 bins (with
  cross section <math|\<sigma\>*<around|(|t*o*t|)>>)<nbsp><cite|Collaboration:2010eza>.
  In Fig.<nbsp><reference|f1>(a) we show the effect of new physics
  contribution, defined through the discriminator
  <math|\<Delta\>=<around|(|F<rsub|N*P+S*M>-F<rsub|S*M>|)>/F<rsub|S*M>>,
  i.e.,

  <\equation>
    \<Delta\>=<dfrac|F<rsub|N*P+S*M>|F<rsub|S*M>>-1=<frac|\<sigma\><rsub|N*P+S*M>*<around|(|4*t*h|)>/\<sigma\><rsub|S*M>*<around|(|4*t*h|)>|\<sigma\><rsub|N*P+S*M>*<around|(|t*o*t|)>/\<sigma\><rsub|S*M>*<around|(|t*o*t|)>>-1,
  </equation>

  as a function of the compositeness scale <math|\<Lambda\>> in three cases:
  (1) including only the LO results as done by CMS; (2) using the scaled NLO
  QCD results as done by ATLAS; (3) including the exact NLO QCD corrections
  presented in this Letter. While the scaled NLO QCD calculation predicts a
  higher value of <math|\<Delta\>> than the LO calculation, the exact NLO QCD
  calculation yields a much smaller value. To further quantify the
  differences, we plot in Fig.<nbsp><reference|f2> the ratios (K-factors) of
  the scaled NLO (labeled as NLO1) and the exact NLO (labeled as NLO2)
  predictions for <math|\<Delta\>> to the LO results as functions of
  <math|\<Lambda\>>. The difference in the two NLO K-factors is also shown,
  which is generally larger than 30% for <math|\<Lambda\>> larger than about
  3 TeV. Using the scaled NLO prediction, ATLAS found the 95% CL exclusion
  limit on the quark compositeness scale is 3.4 <with|font-family|rm|TeV>,
  which corresponds to <math|\<Delta\>> value about 0.38. If using the exact
  NLO QCD calculation, the exclusion limit will reduce by about 10% to 3.1
  <with|font-family|rm|TeV>.

  <big-figure|<image|Atlas-des1|0.3tex-text-width|||>
  <image|Atlas-des2|0.3tex-text-width|||> <caption*||<math|\<Delta\>> as
  functions of the scale <math|\<Lambda\>>. The NLO1 curve represents the
  scaled NLO results, while the NLO2 curve gives the exact NLO QCD
  predictions. The invariant mass of the dijet is required to be larger than
  (a) 1.2 TeV and (b) 2 TeV, respectively. ><label|f1>|>

  <big-figure|<image|kfactor|0.3tex-text-width|||> <caption*||The scaled NLO
  and the exact NLO K-factors, and their differences, as functions of
  <math|\<Lambda\>>.><label|f2>|>

  Fig.<nbsp><reference|f1>(b) shows similar results as
  Fig.<nbsp><reference|f1>(a), but requiring the dijet invariant mass to be
  larger than 2 TeV instead of 1.2 TeV. This measurement will become feasible
  when more integrated luminosity is collected at the LHC. Again, the scaled
  NLO calculation would overestimate the exclusion limit as compared to the
  exact NLO QCD calculation. For <math|\<Delta\>=0.38>, the difference is
  more than 10%.

  The CMS measurement \V Following the CMS analyses, we require

  <\equation>
    <around|\||\<eta\><rsub|j*e*t>|\|>\<less\>1.3,p<rsub|T*j*e*t>\<gtr\>50<math-up|GeV>,\<Delta\>*R=0.7,
  </equation>

  and define the centrality ratio <math|R<rsup|\<eta\>>> as the number of
  events in the inner pseudo-rapidity region
  <math|<around|\||\<eta\><rsub|1,2>|\|>\<less\>0.7> (with cross section
  <math|\<sigma\><rsub|i*n>>) to the one in the outer region
  <math|0.7\<less\><around|\||\<eta\><rsub|1,2>|\|>\<less\>1.3> (with cross
  section <math|\<sigma\><rsub|o*u*t>>) to quantify the NP effects on the
  dijet angular distribution, and evaluate <math|R<rsup|\<eta\>>> in each
  invariant mass bin from several hundred GeV to 3
  TeV<nbsp><cite|Khachatryan:2010te>. In our calculation we use the same cuts
  and strategy as the CMS except that we only consider the last five
  invariant mass bins with equal width ranging from 1.5 TeV to 3 TeV, since
  the NP effects are more significant in this region. To quantitatively
  compare various theory predictions, we introduce the discriminator
  <math|\<rho\>> as the weighted average deviation of <math|R<rsup|\<eta\>>>
  from the SM predictions,

  <eqnarray|<tformat|<table|<row|<cell|\<rho\>>|<cell|=>|<cell|<around*|(|<big|sum><rsub|i=1><rsup|5>\<omega\><rsub|i><mid|\|>R<rsup|\<eta\>><rsub|N*P+S*M><around|(|i|)>-R<rsup|\<eta\>><rsub|S*M><around|(|i|)><mid|\|>/R<rsup|\<eta\>><rsub|S*M><around|(|i|)>|)>/<big|sum><rsub|i=1><rsup|5>\<omega\><rsub|i>,>>|<row|<cell|\<omega\><rsub|i>>|<cell|=>|<cell|<sqrt|\<cal-L\>/<around*|(|\<sigma\><rsub|i*n,N*P+S*M><around|(|i|)><rsup|-1>+\<sigma\><rsub|o*u*t,N*P+S*M><around|(|i|)><rsup|-1>|)>>,<eq-number>>>>>>

  where <math|\<omega\><rsub|i>> is the inverse of the relative statistical
  error of <math|R<rsub|N*P+S*M><rsup|\<eta\>><around|(|i|)>>, and
  <math|\<cal-L\>> is the integrated luminosity. In
  Fig.<nbsp><reference|f3>(a), we plot <math|\<rho\>> as functions of the
  compositeness scale <math|\<Lambda\>>, as predicted by the LO and the exact
  NLO calculations. The exact NLO QCD corrections generally reduce the value
  of <math|\<rho\>> as compared to the LO prediction. For completeness, the
  exact NLO K-factors of <math|\<rho\>> are shown in
  Fig.<nbsp><reference|f3>(b). Consequently, the exact NLO QCD corrections
  modify the CMS 95% CL exclusion limit of <math|\<Lambda\>> from 4.0 TeV to
  3.7 TeV.

  <big-figure|<image|Cms-des1|0.40tex-text-width|||> <caption*||(a)
  <math|\<rho\>> as functions of the compositeness scale <math|\<Lambda\>>,
  as predicted by the LO and the exact NLO calculations. (b) The exact NLO
  K-factors of <math|\<rho\>>, as functions of <math|\<Lambda\>>, for the
  dijet invariant mass ranging from 1.5 TeV to 3.0 TeV. ><label|f3>|>

  General cases with arbitrary <math|\<theta\>> values \V It is interesting
  to also study the general cases in which both the
  <math|c<rsub|1><around|(|\<Lambda\>|)>> and
  <math|c<rsub|2><around|(|\<Lambda\>|)>> coefficients in the effective
  Lagrangian are nonzero. Here, we consider the discovery potential of the
  LHC with <math|<sqrt|s>=14><with|font-family|rm|TeV>, and raise the dijet
  invariant mass cut to 3 TeV. In Fig.<nbsp><reference|f4> we plot the
  discriminator <math|\<Delta\>> as functions of <math|\<theta\>> for
  different values of <math|\<Lambda\>> together with the 3<math|\<sigma\>>
  error bands from the SM predictions, which are calculated by assuming an
  integrated luminosity of 1 <with|font-family|rm|fb<rsup|-1>>. We find that
  <math|\<Delta\>> varies largely from positive to negative values with the
  change of <math|\<theta\>> for a given <math|\<Lambda\>> value, and the
  difference between the scaled NLO and the exact NLO predictions can be
  larger than 30%. Another interesting observation is that there are regions
  of theory parameter space in which the NP effects on the angular
  distribution vanish, due to the cancellation of the contributions from the
  <math|O<rsub|1>> and <math|O<rsub|2>> operators. In that case, it will be
  difficult to study the quark compositeness scale through the dijet angular
  distribution measurement at the LHC. Finally, the quark contact
  interactions can also modify the top quark pair production at the Tevatron
  and the LHC. Since the dijet and the top quark pair production processes
  receive different corrections from the color-singlet and color-octet
  operators, it may be possible to distinguish the effects induced from those
  two operators by studying the correlations between those two production
  processes, which will be presented elsewhere.

  <big-figure|<image|scan|0.43tex-text-width|||> <caption*||<math|\<Delta\>>
  as functions of <math|\<theta\>> for different values of <math|\<Lambda\>>
  with <math|<sqrt|s>=14><math-up|TeV> and
  <math|m<rsub|j*j>\<gtr\>3><math-up|TeV>.><label|f4>|>

  In conclusion, we have calculated the exact NLO QCD corrections to the
  dijet production at the LHC, induced by the quark contact interactions
  which may arise from the quark compositeness models or other new physics
  models. From our results, the current exclusion limits of the quark
  compositeness scale set by the ATLAS and CMS Collaborations shall be
  lowered from 3.4 TeV to 3.1 TeV, and 4.0 TeV to 3.7 TeV, respectively.
  Moreover, we discussed the general cases with color-octet operator included
  in the quark contact interactions and found that in some regions of the
  theory parameter space, the quark compositeness may become undetectable at
  the LHC via the dijet angular distribution measurement.

  <\acknowledgments*>
    This work was supported in part by the National Natural Science
    Foundation of China, under Grants No.11021092 and No.10975004. C.P.Y
    acknowledges the support of the U.S. National Science Foundation under
    Grand No. PHY-0855561.
  </acknowledgments*>

  <\thebibliography|999>
    <bibitem|Eichten:1983hw>E.<nbsp>Eichten, K.<nbsp>D.<nbsp>Lane and
    M.<nbsp>E.<nbsp>Peskin, Phys. Rev. Lett. <with|font-series|bold|50>, 811
    (1983); E.<nbsp>Eichten, I.<nbsp>Hinchliffe, K.<nbsp>D.<nbsp>Lane and
    C.<nbsp>Quigg, Rev. Mod. Phys. <with|font-series|bold|56>, 579 (1984)
    [Addendum-ibid. <with|font-series|bold|58>, 1065 (1986)];
    P.<nbsp>Chiappetta and M.<nbsp>Perrottet, Phys. Lett. B
    <with|font-series|bold|253>, 489 (1991).

    <bibitem|Lane:1996gr>K.<nbsp>D.<nbsp>Lane, arXiv:hep-ph/9605257.

    <bibitem|Abe:1996mj>F.<nbsp>Abe <with|font-shape|italic|et al.> [CDF
    Collaboration], Phys. Rev. Lett. <with|font-series|bold|77>, 5336 (1996)
    [Erratum-ibid. <with|font-series|bold|78>, 4307 (1997)];
    V.<nbsp>M.<nbsp>Abazov <with|font-shape|italic|et al.> [D0
    Collaboration], Phys. Rev. Lett. <with|font-series|bold|103>, 191803
    (2009).

    <bibitem|Collaboration:2010eza>G.<nbsp>Aad <with|font-shape|italic|et
    al.> [ATLAS Collaboration], Phys. Lett. B <with|font-series|bold|694>,
    327 (2011).

    <bibitem|Khachatryan:2010te>V.<nbsp>Khachatryan
    <with|font-shape|italic|et al.> [CMS Collaboration], Phys. Rev. Lett.
    <with|font-series|bold|105>, 262001 (2010).

    <bibitem|Langacker:2008yv>P.<nbsp>Langacker, Rev. Mod. Phys.
    <with|font-series|bold|81>, 1199 (2008).

    <bibitem|Randall:1999ee>L.<nbsp>Randall and R.<nbsp>Sundrum, Phys. Rev.
    Lett. <with|font-series|bold|83>, 3370 (1999) .

    <bibitem|Buchalla:1995vs>G.<nbsp>Buchalla, A.<nbsp>J.<nbsp>Buras and
    M.<nbsp>E.<nbsp>Lautenbacher, Rev. Mod. Phys. <with|font-series|bold|68>,
    1125 (1996).

    <bibitem|Ellis:1985er>R.<nbsp>K.<nbsp>Ellis and J.<nbsp>C.<nbsp>Sexton,
    Nucl. Phys. B <with|font-series|bold|269>, 445 (1986); R.<nbsp>Kelley and
    M.<nbsp>D.<nbsp>Schwartz, arXiv:1008.2759 [hep-ph].

    <bibitem|Harris:2001sx>B.<nbsp>W.<nbsp>Harris and J.<nbsp>F.<nbsp>Owens,
    Phys. Rev. D <with|font-series|bold|65>, 094032 (2002).

    <bibitem|Catani:1996vz>S.<nbsp>Catani and M.<nbsp>H.<nbsp>Seymour, Nucl.
    Phys. B <with|font-series|bold|485>, 291 (1997) [Erratum-ibid. B
    <with|font-series|bold|510>, 503 (1998)].

    <bibitem|Cacciari:2008gp>M.<nbsp>Cacciari, G.<nbsp>P.<nbsp>Salam and
    G.<nbsp>Soyez, JHEP <with|font-series|bold|0804>, 063 (2008).

    <bibitem|Bayatian:2006zz>G.<nbsp>L.<nbsp>Bayatian
    <with|font-shape|italic|et al.> [CMS Collaboration], CERN-LHCC-2006-001.

    <bibitem|Pumplin:2002vw>J.<nbsp>Pumplin, D.<nbsp>R.<nbsp>Stump,
    J.<nbsp>Huston, H.<nbsp>L.<nbsp>Lai, P.<nbsp>M.<nbsp>Nadolsky and
    W.<nbsp>K.<nbsp>Tung, JHEP <with|font-series|bold|0207>, 012 (2002);
    A.<nbsp>Sherstnev and R.<nbsp>S.<nbsp>Thorne, Eur. Phys. J. C
    <with|font-series|bold|55>, 553 (2008); P.<nbsp>M.<nbsp>Nadolsky
    <with|font-shape|italic|et al.>, Phys. Rev. D <with|font-series|bold|78>,
    013004 (2008).

    <bibitem|Ellis:1992en>S.<nbsp>D.<nbsp>Ellis, Z.<nbsp>Kunszt and
    D.<nbsp>E.<nbsp>Soper, Phys. Rev. Lett. <with|font-series|bold|69>, 1496
    (1992).

    <bibitem|Nagy:2003tz>Z.<nbsp>Nagy, Phys. Rev. Lett.
    <with|font-series|bold|88>, 122003 (2002); Z.<nbsp>Nagy, Phys. Rev. D
    <with|font-series|bold|68>, 094002 (2003).
  </thebibliography>
</body>