<TeXmacs|1.99.7>

<style|<tuple|aps|std-latex>>

<\body>
  <doc-data|<doc-title|Parametrization of fermion mixing matrices in
  Kobayashi-Maskawa form>|<doc-author|<author-data|<author-name|Nan
  Qin>>>|<doc-author|<author-data|<author-name|Bo-Qiang
  Ma>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    Recent works show that the original Kobayashi-Maskawa (KM) form of
    fermion mixing matrix exhibits some advantages, especially when
    discussing problems such as unitarity boomerangs and maximal CP violation
    hypothesis. Therefore, the KM form of fermion mixing matrix is
    systematically studied in this paper. Starting with a general triminimal
    expansion of the KM matrix, we discuss the triminimal and
    Wolfenstein-like parametrizations with different basis matrices in
    detail. The quark-lepton complementarity relations play an important role
    in our discussions on describing quark mixing and lepton mixing in a
    unified way.
  </abstract>>

  <assign|*|<macro|<PKU>>>School of Physics and State Key Laboratory of
  Nuclear Physics and Technology, Peking University, Beijing 100871, China

  <assign|*|<macro|<chep>>>Center for High Energy Physics, Peking University,
  Beijing 100871, China

  <section|Introduction>

  As it is well known, the mixing between different generations of fermions
  is one of the most interesting issues in particle physics. For quarks, the
  mixing matrix is described by the Cabibbo<cite|cabibbo>-Kobayashi-Maskawa<cite|km>(CKM)
  matrix <math|V<rsub|<math-up|CKM>>>, and in the lepton sector, it is
  described by the Pontecorvo<cite|pontecorvo>-Maki-Nakawaga-Sakata<cite|mns>
  (PMNS) matrix <math|U<rsub|<math-up|PMNS>>>,

  <eqnarray|<tformat|<table|<row|<cell|V<rsub|<math-up|CKM>>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|V<rsub|u*d>>|<cell|V<rsub|u*s>>|<cell|V<rsub|u*b>>>|<row|<cell|V<rsub|c*d>>|<cell|V<rsub|c*s>>|<cell|V<rsub|c*b>>>|<row|<cell|V<rsub|t*d>>|<cell|V<rsub|t*s>>|<cell|V<rsub|t*b>>>>>>|)>,<space|1em>U<rsub|<math-up|PMNS>>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|U<rsub|e*1>>|<cell|U<rsub|e*2>>|<cell|U<rsub|e*3>>>|<row|<cell|U<rsub|\<mu\>*1>>|<cell|U<rsub|\<mu\>*2>>|<cell|U<rsub|\<mu\>*3>>>|<row|<cell|U<rsub|\<tau\>*1>>|<cell|U<rsub|\<tau\>*2>>|<cell|U<rsub|\<tau\>*3>>>>>>|)>.>>>>>

  Before more underlying theory of the origin of the mixing is found,
  parametrizing the mixing matrices properly is helpful to understanding the
  mixing pattern and search for deviations from the standard model both
  theoretically and experimentally. A commonly used form of the fermion
  mixing matrix is the standard parametrization proposed by Chau and Keung
  (CK)<nbsp><cite|ck>

  <eqnarray|<tformat|<table|<row|<cell|V<rsub|<math-up|CK>>>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|1>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|c<rsub|23>>|<cell|s<rsub|23>>>|<row|<cell|0>|<cell|-s<rsub|23>>|<cell|c<rsub|23>>>>>>|)><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|c<rsub|13>>|<cell|0>|<cell|s<rsub|13>*e<rsup|-i*\<delta\><rsub|<math-up|CK>>>>>|<row|<cell|0>|<cell|1>|<cell|0>>|<row|<cell|-s<rsub|13>*e<rsup|i*\<delta\><rsub|<math-up|CK>>>>|<cell|0>|<cell|c<rsub|13>>>>>>|)><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|c<rsub|12>>|<cell|s<rsub|12>>|<cell|0>>|<row|<cell|-s<rsub|12>>|<cell|c<rsub|12>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|1>>>>>|)>>>|<row|<cell|>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|c<rsub|12>*c<rsub|13>>|<cell|s<rsub|12>*c<rsub|13>>|<cell|s<rsub|13>*e<rsup|-i*\<delta\><rsub|<math-up|CK>>>>>|<row|<cell|-s<rsub|12>*c<rsub|23>-c<rsub|12>*s<rsub|23>*s<rsub|13>*e<rsup|i*\<delta\><rsub|<math-up|CK>>>>|<cell|c<rsub|12>*c<rsub|23>-s<rsub|12>*s<rsub|23>*s<rsub|13>*e<rsup|i*\<delta\><rsub|<math-up|CK>>>>|<cell|s<rsub|23>*c<rsub|13>>>|<row|<cell|s<rsub|12>*s<rsub|23>-c<rsub|12>*c<rsub|23>*s<rsub|13>*e<rsup|i*\<delta\><rsub|<math-up|CK>>>>|<cell|-c<rsub|12>*s<rsub|23>-s<rsub|12>*c<rsub|23>*s<rsub|13>*e<rsup|i*\<delta\><rsub|<math-up|CK>>>>|<cell|c<rsub|23>*c<rsub|13>>>>>>|)>,<eq-number><label|CK>>>>>>

  where <math|s<rsub|i*j>=sin \<theta\><rsub|i*j>> and <math|c<rsub|i*j>=cos
  \<theta\><rsub|i*j>> <math|<around|(|i,j=1,2,3|)>> are the rotation angles,
  and <math|\<delta\><rsub|<math-up|CK>>> is the CP-violating phase in the CK
  parametrization.

  Recently, it has been pointed out in many
  works<nbsp><cite|boomerang|recentwork|koide> that the original
  Kobayashi-Maskawa (KM)<nbsp><cite|km> matrix is convenient when discussing
  problems such as unitarity boomerangs<nbsp><cite|boomerang> and maximal CP
  violation hypothesis<nbsp><cite|maximalcp>. The original KM mixing matrix
  is given by

  <eqnarray|<tformat|<table|<row|<cell|V<rsub|<math-up|KM>>>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|1>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|c<rsub|2>>|<cell|-s<rsub|2>>>|<row|<cell|0>|<cell|s<rsub|2>>|<cell|c<rsub|2>>>>>>|)><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|c<rsub|1>>|<cell|-s<rsub|1>>|<cell|0>>|<row|<cell|s<rsub|1>>|<cell|c<rsub|1>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|e<rsup|i*\<delta\><rsub|<math-up|KM>>>>>>>>|)><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|1>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|c<rsub|3>>|<cell|s<rsub|3>>>|<row|<cell|0>|<cell|s<rsub|3>>|<cell|-c<rsub|3>>>>>>|)>>>|<row|<cell|>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|c<rsub|1>>|<cell|-s<rsub|1>*c<rsub|3>>|<cell|-s<rsub|1>*s<rsub|3>>>|<row|<cell|s<rsub|1>*c<rsub|2>>|<cell|c<rsub|1>*c<rsub|2>*c<rsub|3>-s<rsub|2>*s<rsub|3>*e<rsup|i*\<delta\><rsub|<math-up|KM>>>>|<cell|c<rsub|1>*c<rsub|2>*s<rsub|3>+s<rsub|2>*c<rsub|3>*e<rsup|i*\<delta\><rsub|<math-up|KM>>>>>|<row|<cell|s<rsub|1>*s<rsub|2>>|<cell|c<rsub|1>*s<rsub|2>*c<rsub|3>+c<rsub|2>*s<rsub|3>*e<rsup|i*\<delta\><rsub|<math-up|KM>>>>|<cell|c<rsub|1>*s<rsub|2>*s<rsub|3>-c<rsub|2>*c<rsub|3>*e<rsup|i*\<delta\><rsub|<math-up|KM>>>>>>>>|)><space|0.27em>,<eq-number><label|KM>>>>>>

  in which <math|s<rsub|i>=sin \<theta\><rsub|i>>, <math|c<rsub|i>=cos
  \<theta\><rsub|i>> <math|<around|(|i=1,2,3|)>> are Euler angles, and
  <math|\<delta\><rsub|<math-up|KM>>> is the CP-violating phase in the KM
  parametrization.

  If neutrinos are of the Majorana type, there should be an additional
  diagonal matrix with two Majorana phases
  <math|P=<math-up|diag><around|(|e<rsup|i*\<alpha\><rsub|1>/2>,e<rsup|i*\<alpha\><rsub|2>/2>,1|)>>
  multiplied to Eqs.<nbsp>(<reference|KM>) and (<reference|CK>) from the
  right. In this paper, we consider the neutrinos as Dirac neutrinos, and the
  presentation of formalisms for Majorana neutrinos can be derived
  straightforwardly by including the additional phases. In the following, we
  omit the subscript <with|font-family|rm|CK> and <with|font-family|rm|KM>
  since we deal with only the KM form. We also denote parameters in the quark
  sector with superscript <math|Q> and in the lepton sector with superscript
  <math|L> if necessary (except for the CP-violating phases in expressions
  with the consideration of concinnity, and bearing in mind that
  <math|\<delta\><rsup|Q>> appears in <math|V<rsub|<math-up|CKM>>> while
  <math|\<delta\><rsup|L>> appears in <math|U<rsub|<math-up|PMNS>>> ).

  The magnitudes of the CKM matrix elements have been well determined
  with<nbsp><cite|pdg>

  <eqnarray|<tformat|<table|<row|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0.97428\<pm\>0.00015>|<cell|0.2253\<pm\>0.0007>|<cell|0.00347<rsup|+0.00016><rsub|-0.00012>>>|<row|<cell|0.2252\<pm\>0.0007>|<cell|0.97345<rsup|+0.00015><rsub|-0.00016>>|<cell|0.0410<rsup|+0.0011><rsub|-0.0007>>>|<row|<cell|0.00862<rsup|+0.00026><rsub|-0.00020>>|<cell|0.0403<rsup|+0.0011><rsub|-0.0007>>|<cell|0.999152<rsup|+0.000030><rsub|-0.000045>>>>>>|)><space|0.27em>.<eq-number><label|ckmdata>>>>>>

  With <math|<around|\||V<rsub|u*d>|\|>>, <math|<around|\||V<rsub|u*b>|\|>>,
  <math|<around|\||V<rsub|t*d>|\|>> and <math|<around|\||V<rsub|c*b>|\|>> as
  input parameters, one can easily get the ranges for the angle parameters as

  <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|1><rsup|Q>=0.2273<rsub|-0.0003><rsup|+0.0011>,<space|1em>\<theta\><rsub|2><rsup|Q>=0.0383<rsub|-0.0010><rsup|+0.0011>,<space|1em>\<theta\><rsub|3><rsup|Q>=0.0154<rsub|-0.0006><rsup|+0.0008>,<space|1em>\<delta\><rsup|Q>=90.33<rsup|\<circ\>><rsub|-4.57<rsup|\<circ\>>><rsup|+2.85<rsup|\<circ\>>><space|0.27em>.<eq-number><label|kmdata>>>>>>

  The last equation apparently implies that the KM phase convention is
  consistent with the maximal CP violation hypothesis.

  For lepton mixing, the ranges for the PMNS matrix elements have been also
  constrained by (at <math|3*\<sigma\>> level)<nbsp><cite|gonzalez>

  <eqnarray|<tformat|<table|<row|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0.77-0.86>|<cell|0.50-0.63>|<cell|0.00-0.22>>|<row|<cell|0.22-0.56>|<cell|0.44-0.73>|<cell|0.57-0.80>>|<row|<cell|0.21-0.55>|<cell|0.40-0.71>|<cell|0.59-0.82>>>>>|)><space|0.27em>.<eq-number><label|pmnsdata>>>>>>

  Since the data are not accurate enough here, we do not calculate the
  parameters for leptons as what we do for quarks. Instead, the numerical
  results are presented in Sec.<nbsp>III and Sec.<nbsp>IV where unified
  description of quark mixing and lepton mixing are discussed.

  When studying mixing, it is useful to parametrize the matrix according to
  the hierarchical structure of the mixing to reveal more physical
  information about the underlying theory. The Wolfenstein parametrization
  for quarks is a famous example of this type, where
  <math|V<rsub|<math-up|CKM>>> is parametrized as<nbsp><cite|wolf>

  <eqnarray|<tformat|<table|<row|<cell|V<rsub|<math-up|CKM>>>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|1-<frac|1|2>*\<lambda\><rsup|2>>|<cell|\<lambda\>>|<cell|A*\<lambda\><rsup|3>*<around|(|\<rho\>-i*\<eta\>|)>>>|<row|<cell|-\<lambda\>>|<cell|1-<frac|1|2>*\<lambda\><rsup|2>>|<cell|A*\<lambda\><rsup|2>>>|<row|<cell|A*\<lambda\><rsup|3>*<around|(|1-\<rho\>-i*\<eta\>|)>>|<cell|-A*\<lambda\><rsup|2>>|<cell|1>>>>>|)>+\<cal-O\><around|(|\<lambda\><rsup|4>|)><space|0.27em>.<eq-number><label|wolf>>>>>>

  The up-to-date fit for the Wolfenstein parameters gives<nbsp><cite|pdg>

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|\<lambda\>=0.2253\<pm\>0.0007<space|0.27em>,<space|1em><space|1em>A=0.808<rsub|-0.015><rsup|+0.022><space|0.27em>,>>|<row|<cell|>|<cell|>|<cell|\<rho\>*<around|(|1-\<lambda\><rsup|2>/2+\<ldots\>|)>=0.132<rsub|-0.014><rsup|+0.022><space|0.27em>,<space|1em>\<eta\>*<around|(|1-\<lambda\><rsup|2>/2+\<ldots\>|)>=0.341\<pm\>0.013<space|0.27em>.<eq-number><label|wolfdata>>>>>>

  The Wolfenstein parametrization is actually an expansion of
  <math|V<rsub|<math-up|CKM>>> around the unit matrix basis with
  <math|\<lambda\>> as the expanding parameter. In this type of
  parametrization, the choice of the parameters and where to put them are
  arbitrary, making the meaning of the parameters subtle to some extent. For
  example, the CP-violating phase <math|\<delta\>> is not independent, i.e.,
  it is determined by two parameters <math|\<eta\>> and <math|\<rho\>> with
  <math|tan \<delta\>=\<eta\>/\<rho\>>. Therefore it would be better to
  expand the mixing matrix using small parameters with explicit physical
  meaning. A good choice is the idea of triminimal
  parametrization<nbsp><cite|triminimal> with an approximation as the basis
  matrix to the lowest order. The triminimal expansion of the quark and
  lepton mixing pointed out a new way to parametrize the mixing matrix with
  all angle parameters small, and with the CP-violating phase parameter free
  from others. The parameters are completely determined when the basis matrix
  is chosen.

  For quark mixing, the unit matrix is very simple while the matrix suggested
  in Ref.<nbsp><cite|lisw> given by

  <eqnarray|<tformat|<table|<row|<cell|V<rprime|'><rsub|0>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|0>>|<row|<cell|-<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|1>>>>>|)><eq-number><label|vnew>>>>>>

  is more close to experimental data so that they are both good choices.

  In lepton sector, it has been common to choose the bimaximal
  matrix<nbsp><cite|bi> and/or the tri-bimaximal matrix<nbsp><cite|tri> as
  the basis matrices

  <eqnarray|<tformat|<table|<row|<cell|U<rsub|<math-up|bi>>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|1/<sqrt|2>>|<cell|1/<sqrt|2>>|<cell|0>>|<row|<cell|-1/2>|<cell|1/2>|<cell|1/<sqrt|2>>>|<row|<cell|1/2>|<cell|-1/2>|<cell|1/<sqrt|2>>>>>>|)>,<space|1em>U<rsub|<math-up|tri>>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|2/<sqrt|6>>|<cell|1/<sqrt|3>>|<cell|0>>|<row|<cell|-1/<sqrt|6>>|<cell|1/<sqrt|3>>|<cell|1/<sqrt|2>>>|<row|<cell|1/<sqrt|6>>|<cell|-1/<sqrt|3>>|<cell|1/<sqrt|2>>>>>>|)>.<eq-number>>>>>>

  Although the former one is not favored by present experimental data as the
  later one, it looks more symmetric with also a possible connection with the
  unit basis in quark mixing<nbsp><cite|qlcparabi>. The tri-bimaximal basis
  is very close to experimental data and can serve as a good approximation
  for lepton mixing.

  Although it seems that the mixing of quarks and leptons are unrelated with
  each other, there indeed exist phenomenological relations between mixing
  angles called quark-lepton complementarity (QLC)<nbsp><cite|qlc>. For KM
  parameters, the QLC relations still stand<nbsp><cite|recentwork|zheng>,

  <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|1><rsup|Q>+\<theta\><rsub|1><rsup|L>=<frac|\<pi\>|4>,<space|1em>\<theta\><rsub|2><rsup|Q>+\<theta\><rsub|2><rsup|L>=<frac|\<pi\>|4>,<space|1em>\<theta\><rsub|3><rsup|Q>\<sim\>\<theta\><rsub|3><rsup|L>\<sim\>0<space|0.27em>.<eq-number><label|kmqlc>>>>>>

  It has been discussed that the quark mixing matrix and the lepton mixing
  matrix can be parametrized in a unified way with the QLC
  relations<nbsp><cite|unified>. However, the discussions in
  Ref.<nbsp><cite|unified> are based on the CK phase convention. Since the KM
  form of mixing matrices is promoted in many works, a detailed study of it
  is necessary, and unified parametrizations in KM phase convention may be
  helpful in both theoretical and phenomenological studies.

  The outline of this paper is as follows. In Sec.<nbsp>II, the general
  expressions of triminimal expansion of the KM matrix are presented. In
  Sec.<nbsp>III, we study the triminimal parametrization with unit matrix and
  bimaximal matrix as the basis for quarks and leptons respectively.
  Wolfenstein-like parametrizations are also discussed and numerical results
  of the parameters are presented. In Sec.<nbsp>IV, triminimal and
  Wolfenstein-like parametrizations are discussed in tri-bimaximal pattern.
  We show that the expansions converge much faster in both quark sector and
  lepton sector. In both Sec.<nbsp>III and Sec.<nbsp>IV, QLC relations play
  an important role in our discussions of parametrizing
  <math|V<rsub|<math-up|CKM>>> and <math|U<rsub|<math-up|PMNS>>> in a unified
  way. Finally, we present our conclusions in Sec.<nbsp>V.

  <section|The general results of triminimal expansion of KM matrix>

  The idea of the triminimal parametrization<nbsp><cite|triminimal> is to
  express a mixing angle in the mixing matrices as the sum of a zeroth order
  angle <math|\<theta\><rsup|0>> and a small perturbation angle
  <math|\<epsilon\>> as

  <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|1>=\<theta\><rsub|1><rsup|0>+\<epsilon\><rsub|1>,<space|1em>\<theta\><rsub|2>=\<theta\><rsub|2><rsup|0>+\<epsilon\><rsub|2>,<space|1em>\<theta\><rsub|3>=\<theta\><rsub|3><rsup|0>+\<epsilon\><rsub|3>.<eq-number>>>>>>

  With the deviations <math|\<epsilon\><rsub|i>>, one can expand the mixing
  matrices in powers of <math|\<epsilon\><rsub|i>> while different choices of
  <math|\<theta\><rsub|i><rsup|0>> lead to different matrices as the zeroth
  order of the expansion. Generally, to the second order of
  <math|\<epsilon\><rsub|i>>, the mixing matrix is expanded as

  <eqnarray|<tformat|<table|<row|<cell|V>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|c<rsub|1><rsup|0>>|<cell|-s<rsub|1><rsup|0>*c<rsub|3><rsup|0>>|<cell|-s<rsub|1><rsup|0>*s<rsub|3><rsup|0>>>|<row|<cell|s<rsub|1><rsup|0>*c<rsub|2><rsup|0>>|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*c<rsub|3><rsup|0>-s<rsub|2><rsup|0>*s<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*s<rsub|3><rsup|0>+s<rsub|2><rsup|0>*c<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>>|<row|<cell|s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|c<rsub|1><rsup|0>*s<rsub|2><rsup|0>*c<rsub|3><rsup|0>+c<rsub|2><rsup|0>*s<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>|<cell|c<rsub|1><rsup|0>*s<rsub|2><rsup|0>*s<rsub|3><rsup|0>-c<rsub|2><rsup|0>*c<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>>>>>|)>+\<epsilon\><rsub|1><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-s<rsub|1><rsup|0>>|<cell|-c<rsub|1><rsup|0>*c<rsub|3><rsup|0>>|<cell|-c<rsub|1><rsup|0>*s<rsub|3><rsup|0>>>|<row|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>>|<cell|-c<rsub|2><rsup|0>*c<rsub|3><rsup|0>*s<rsub|1><rsup|0>>|<cell|-c<rsub|2><rsup|0>*s<rsub|1><rsup|0>*s<rsub|3><rsup|0>>>|<row|<cell|c<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|-c<rsub|3><rsup|0>*s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|-s<rsub|1><rsup|0>*s<rsub|2><rsup|0>*s<rsub|3><rsup|0>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<epsilon\><rsub|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|-s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|-c<rsub|1><rsup|0>*c<rsub|3><rsup|0>*s<rsub|2><rsup|0>-c<rsub|2><rsup|0>*s<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>|<cell|-c<rsub|1><rsup|0>*s<rsub|2><rsup|0>*s<rsub|3><rsup|0>+c<rsub|2><rsup|0>*c<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>>|<row|<cell|c<rsub|2><rsup|0>*s<rsub|1><rsup|0>>|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*c<rsub|3><rsup|0>-s<rsub|2><rsup|0>*s<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*s<rsub|3><rsup|0>+c<rsub|3><rsup|0>*s<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<epsilon\><rsub|3><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|s<rsub|1><rsup|0>*s<rsub|3><rsup|0>>|<cell|-c<rsub|3><rsup|0>*s<rsub|1><rsup|0>>>|<row|<cell|0>|<cell|-c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*s<rsub|3><rsup|0>-c<rsub|3><rsup|0>*s<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*c<rsub|3><rsup|0>-s<rsub|2><rsup|0>*s<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>>|<row|<cell|0>|<cell|-c<rsub|1><rsup|0>*s<rsub|2><rsup|0>*s<rsub|3><rsup|0>+c<rsub|2><rsup|0>*c<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>|<cell|c<rsub|1><rsup|0>*c<rsub|3><rsup|0>*s<rsub|2><rsup|0>+c<rsub|2><rsup|0>*s<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>>>>>|)>+<frac|1|2>*\<epsilon\><rsub|1><rsup|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-c<rsub|1><rsup|0>>|<cell|c<rsub|3><rsup|0>*s<rsub|1><rsup|0>>|<cell|s<rsub|1><rsup|0>*s<rsub|3><rsup|0>>>|<row|<cell|-c<rsub|2><rsup|0>*s<rsub|1><rsup|0>>|<cell|-c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*c<rsub|3><rsup|0>>|<cell|-c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*s<rsub|3><rsup|0>>>|<row|<cell|-s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|-c<rsub|1><rsup|0>*c<rsub|3><rsup|0>*s<rsub|2><rsup|0>>|<cell|-c<rsub|1><rsup|0>*s<rsub|2><rsup|0>*s<rsub|3><rsup|0>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|<frac|1|2>*\<epsilon\><rsub|2><rsup|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|-c<rsub|2><rsup|0>*s<rsub|1><rsup|0>>|<cell|-c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*c<rsub|3><rsup|0>+s<rsub|2><rsup|0>*s<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>|<cell|-c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*s<rsub|3><rsup|0>-c<rsub|3><rsup|0>*s<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>>|<row|<cell|-s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|-c<rsub|1><rsup|0>*c<rsub|3><rsup|0>*s<rsub|2><rsup|0>-c<rsub|2><rsup|0>*s<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>|<cell|-c<rsub|1><rsup|0>*s<rsub|2><rsup|0>*s<rsub|3><rsup|0>+c<rsub|2><rsup|0>*c<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|<frac|1|2>*\<epsilon\><rsub|3><rsup|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|c<rsub|3><rsup|0>*s<rsub|1><rsup|0>>|<cell|s<rsub|1><rsup|0>*s<rsub|3><rsup|0>>>|<row|<cell|0>|<cell|-c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*c<rsub|3><rsup|0>+s<rsub|2><rsup|0>*s<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>|<cell|-c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*s<rsub|3><rsup|0>-c<rsub|3><rsup|0>*s<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>>|<row|<cell|0>|<cell|-c<rsub|1><rsup|0>*c<rsub|3><rsup|0>*s<rsub|2><rsup|0>-c<rsub|2><rsup|0>*s<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>|<cell|-c<rsub|1><rsup|0>*s<rsub|2><rsup|0>*s<rsub|3><rsup|0>+c<rsub|2><rsup|0>*c<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>>>>>|)>+\<epsilon\><rsub|1>*\<epsilon\><rsub|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|-c<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|c<rsub|3><rsup|0>*s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|s<rsub|1><rsup|0>*s<rsub|2><rsup|0>*s<rsub|3><rsup|0>>>|<row|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>>|<cell|-c<rsub|2><rsup|0>*c<rsub|3><rsup|0>*s<rsub|1><rsup|0>>|<cell|-c<rsub|2><rsup|0>*s<rsub|1><rsup|0>*s<rsub|3><rsup|0>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<epsilon\><rsub|2>*\<epsilon\><rsub|3><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|c<rsub|1><rsup|0>*s<rsub|2><rsup|0>*s<rsub|3><rsup|0>-c<rsub|2><rsup|0>*c<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>|<cell|-c<rsub|1><rsup|0>*c<rsub|3><rsup|0>*s<rsub|2><rsup|0>-c<rsub|2><rsup|0>*s<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>>|<row|<cell|0>|<cell|-c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*s<rsub|3><rsup|0>-c<rsub|3><rsup|0>*s<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*c<rsub|3><rsup|0>-s<rsub|2><rsup|0>*s<rsub|3><rsup|0>*e<rsup|i*\<delta\>>>>>>>|)>+\<epsilon\><rsub|1>*\<epsilon\><rsub|3><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|c<rsub|1><rsup|0>*s<rsub|3><rsup|0>>|<cell|-c<rsub|1><rsup|0>*c<rsub|3><rsup|0>>>|<row|<cell|0>|<cell|c<rsub|2><rsup|0>*s<rsub|1><rsup|0>*s<rsub|3><rsup|0>>|<cell|-c<rsub|2><rsup|0>*c<rsub|3><rsup|0>*s<rsub|1><rsup|0>>>|<row|<cell|0>|<cell|s<rsub|1><rsup|0>*s<rsub|2><rsup|0>*s<rsub|3><rsup|0>>|<cell|-c<rsub|3><rsup|0>*s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<cal-O\><around|(|\<epsilon\><rsub|i><rsup|3>|)><space|0.27em>,<eq-number><label|general>>>>>>

  where <math|s<rsub|i><rsup|0>=sin \<theta\><rsub|i><rsup|0>> and
  <math|c<rsub|i><rsup|0>=cos \<theta\><rsub|i><rsup|0>>.

  The rephasing invariant quantity <math|J><nbsp><cite|jarlskog> given by

  <eqnarray|<tformat|<table|<row|<cell|J=<math-up|Im><around|(|V<rsub|11>*V<rsub|22>*V<rsub|12><rsup|\<ast\>>*V<rsub|21><rsup|\<ast\>>|)>=s<rsub|1><rsup|2>*s<rsub|2>*s<rsub|3>*c<rsub|1>*c<rsub|2>*c<rsub|3>*sin
  \<delta\><eq-number><label|jarskog>>>>>>

  is independent of phase convention, making it important when discussing CP
  violation. Expanding <math|J> with <math|\<epsilon\><rsub|i>> to the second
  order gives

  <eqnarray|<tformat|<table|<row|<cell|J>|<cell|=>|<cell|J<rsub|0>(1+\<epsilon\><rsub|1>*<around|(|3*cot
  2*\<theta\><rsub|1><rsup|0>+csc 2*\<theta\><rsub|1><rsup|0>|)>+2*\<epsilon\><rsub|2>*cot
  2*\<theta\><rsub|2><rsup|0>+2*\<epsilon\><rsub|3>*cot
  2*\<theta\><rsub|3><rsup|0>+<frac|1|4>*\<epsilon\><rsub|1><rsup|2>*<around|(|9*cos
  2*\<theta\><rsub|1><rsup|0>-5|)>*csc<rsup|2>
  \<theta\><rsub|1><rsup|0>>>|<row|<cell|>|<cell|->|<cell|2*\<epsilon\><rsub|2><rsup|2>-2*\<epsilon\><rsub|3><rsup|2>+2*\<epsilon\><rsub|1>*\<epsilon\><rsub|2>*<around|(|3*cos
  2*\<theta\><rsub|1><rsup|0>+1|)>*cot 2*\<theta\><rsub|2><rsup|0>*csc
  2*\<theta\><rsub|1><rsup|0>+4*\<epsilon\><rsub|2>*\<epsilon\><rsub|3>*cot
  2*\<theta\><rsub|2><rsup|0>*cot 2*\<theta\><rsub|3><rsup|0>>>|<row|<cell|>|<cell|+>|<cell|2*\<epsilon\><rsub|1>*\<epsilon\><rsub|3>*<around|(|3*cos
  2*\<theta\><rsub|1><rsup|0>+1|)>*cot 2*\<theta\><rsub|3><rsup|0>*csc
  2*\<theta\><rsub|1><rsup|0>)+\<cal-O\><around|(|\<epsilon\><rsub|i><rsup|3>|)><space|0.27em>,<eq-number><label|generalj>>>>>>

  in which <math|J<rsub|0>=<around|(|s<rsub|1><rsup|0>|)><rsup|2>*s<rsub|2><rsup|0>*s<rsub|3><rsup|0>*c<rsub|1><rsup|0>*c<rsub|2><rsup|0>*c<rsub|3><rsup|0>*sin
  \<delta\>>.

  The general form Eqs.<nbsp>(<reference|general>) and (<reference|generalj>)
  look quite complicated since they are simple expansions in mathematics. We
  can simplify the general expansion by taking
  <math|\<theta\><rsub|3><rsup|0>=0> because <math|\<theta\><rsub|3><rsup|0>>
  is small in both quark and lepton sectors. In this case, the result is

  <eqnarray|<tformat|<table|<row|<cell|V>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|c<rsub|1><rsup|0>>|<cell|-s<rsub|1><rsup|0>>|<cell|0>>|<row|<cell|s<rsub|1><rsup|0>*c<rsub|2><rsup|0>>|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>>|<cell|s<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>>|<row|<cell|s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|c<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|-c<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>>>>>|)>+\<epsilon\><rsub|1><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-s<rsub|1><rsup|0>>|<cell|-c<rsub|1><rsup|0>>|<cell|0>>|<row|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>>|<cell|-c<rsub|2><rsup|0>*s<rsub|1><rsup|0>>|<cell|0>>|<row|<cell|c<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|0>>>>>|)>+\<epsilon\><rsub|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|-s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|-c<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|c<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>>|<row|<cell|c<rsub|2><rsup|0>*s<rsub|1><rsup|0>>|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>>|<cell|s<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<epsilon\><rsub|3><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|-s<rsub|1><rsup|0>>>|<row|<cell|0>|<cell|-s<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>>>|<row|<cell|0>|<cell|c<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>|<cell|c<rsub|1><rsup|0>*s<rsub|2><rsup|0>>>>>>|)>+<frac|1|2>*\<epsilon\><rsub|1><rsup|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-c<rsub|1><rsup|0>>|<cell|s<rsub|1><rsup|0>>|<cell|0>>|<row|<cell|-c<rsub|2><rsup|0>*s<rsub|1><rsup|0>>|<cell|-c<rsub|1><rsup|0>*c<rsub|2><rsup|0>>|<cell|0>>|<row|<cell|-s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|-c<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|0>>>>>|)>+<frac|1|2>*\<epsilon\><rsub|2><rsup|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|-c<rsub|2><rsup|0>*s<rsub|1><rsup|0>>|<cell|-c<rsub|1><rsup|0>*c<rsub|2><rsup|0>>|<cell|-s<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>>|<row|<cell|-s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|-c<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|c<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|<frac|1|2>*\<epsilon\><rsub|3><rsup|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|s<rsub|1><rsup|0>>|<cell|0>>|<row|<cell|0>|<cell|-c<rsub|1><rsup|0>*c<rsub|2><rsup|0>>|<cell|-s<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>>|<row|<cell|0>|<cell|-c<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|c<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>>>>>|)>+\<epsilon\><rsub|1>*\<epsilon\><rsub|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|-c<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>|<cell|0>>|<row|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>>|<cell|-c<rsub|2><rsup|0>*s<rsub|1><rsup|0>>|<cell|0>>>>>|)>+\<epsilon\><rsub|2>*\<epsilon\><rsub|3><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|-c<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>|<cell|-c<rsub|1><rsup|0>*s<rsub|2><rsup|0>>>|<row|<cell|0>|<cell|-s<rsub|2><rsup|0>*e<rsup|i*\<delta\>>>|<cell|c<rsub|1><rsup|0>*c<rsub|2><rsup|0>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<epsilon\><rsub|1>*\<epsilon\><rsub|3><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|-c<rsub|1><rsup|0>>>|<row|<cell|0>|<cell|0>|<cell|-c<rsub|2><rsup|0>*s<rsub|1><rsup|0>>>|<row|<cell|0>|<cell|0>|<cell|-s<rsub|1><rsup|0>*s<rsub|2><rsup|0>>>>>>|)>+\<cal-O\><around|(|\<epsilon\><rsub|i><rsup|3>|)><space|0.27em>,<eq-number>>>>>>

  and the Jarlskog parameter reduces to

  <eqnarray|<tformat|<table|<row|<cell|J=sin
  \<delta\>*<around|(|\<epsilon\><rsub|3>*c<rsub|1><rsup|0>*c<rsub|2><rsup|0><around|(|s<rsub|1><rsup|0>|)><rsup|2>*s<rsub|2><rsup|0>+\<epsilon\><rsub|2>*\<epsilon\><rsub|3>*c<rsub|1><rsup|0><around|(|s<rsub|1><rsup|0>|)><rsup|2>*cos
  2*\<theta\><rsub|2><rsup|0>-<frac|1|8>*\<epsilon\><rsub|1>*\<epsilon\><rsub|3>*sin
  2*\<theta\><rsub|2><rsup|0>*<around|(|s<rsub|1><rsup|0>-3*sin
  3*\<theta\><rsub|1><rsup|0>|)>|)><space|0.27em>.>>|<row|<cell|<eq-number>>>>>>

  These expressions for mixing matrix and Jarlskog parameter are still
  complicated, making it difficult to capture physical meanings from them. A
  good choice of the zeroth order matrix <math|V<rsub|0>> will simplify the
  parametrization greatly, lead to fast convergency of the expansion, reflect
  the physical insight of a parametrization, and provide hints for underlying
  theory producing the mixing. Therefore, in the following two sections,
  different basis matrices will be applied to make the expansions simpler and
  useful for both theoretical and experimental analysis.

  <section|Parametrization of KM matrix with unit and bimaximal basis
  matrices>

  <subsection|The triminimal expansion>

  Since <math|V<rsub|<math-up|CKM>>> is close to the unit matrix shown by
  Eq.<nbsp>(<reference|ckmdata>), we can naturally set

  <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|1><rsup|0*Q>=\<theta\><rsub|2><rsup|0*Q>=\<theta\><rsub|3><rsup|0*Q>=0<space|0.27em>,<eq-number><label|unitcondition>>>>>>

  and consequently have

  <eqnarray|<tformat|<table|<row|<cell|\<epsilon\><rsub|1><rsup|Q>=\<theta\><rsub|1><rsup|Q>=0.2273<rsub|-0.0003><rsup|+0.0011>,<space|1em>\<epsilon\><rsub|2><rsup|Q>=\<theta\><rsub|2><rsup|Q>=0.0383<rsub|-0.0010><rsup|+0.0011>,<space|1em>\<epsilon\><rsub|3><rsup|Q>=\<theta\><rsub|3><rsup|Q>=0.0154<rsub|-0.0006><rsup|+0.0008><space|0.27em>,<eq-number>>>>>>

  which show that <math|<around|(|\<epsilon\><rsub|1><rsup|Q>|)><rsup|2>\<sim\>\<epsilon\><rsub|2><rsup|Q>\<sim\>\<epsilon\><rsub|3><rsup|Q>>.
  In most cases the approximation to the second order of
  <math|\<epsilon\><rsub|i>> is enough. However, in order to keep the
  consistency of magnitudes in the expansion, we display all terms of
  <math|\<cal-O\><around|(|<around|(|\<epsilon\><rsub|1><rsup|Q>|)><rsup|3>|)>>
  in our parametrization, which is given by

  <eqnarray|<tformat|<table|<row|<cell|V<rsub|<math-up|CKM>>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|1-<frac|<around|(|\<epsilon\><rsub|1><rsup|Q>|)><rsup|2>|2>>|<cell|\<epsilon\><rsub|1><rsup|Q>-<frac|<around|(|\<epsilon\><rsub|1><rsup|Q>|)><rsup|3>|6>>|<cell|e<rsup|-i*\<delta\>>*\<epsilon\><rsub|1><rsup|Q>*\<epsilon\><rsub|3><rsup|Q>>>|<row|<cell|<frac|<around|(|\<epsilon\><rsub|1><rsup|Q>|)><rsup|3>|6>-\<epsilon\><rsub|1><rsup|Q>>|<cell|1-<frac|<around|(|\<epsilon\><rsub|1><rsup|Q>|)><rsup|2>|2>>|<cell|\<epsilon\><rsub|2><rsup|Q>+e<rsup|-i*\<delta\>>*\<epsilon\><rsub|3><rsup|Q>>>|<row|<cell|\<epsilon\><rsub|1><rsup|Q>*\<epsilon\><rsub|2><rsup|Q>>|<cell|-\<epsilon\><rsub|2><rsup|Q>-e<rsup|i*\<delta\>>*\<epsilon\><rsub|3><rsup|Q>>|<cell|1>>>>>|)>+\<cal-O\><around|(|<around|(|\<epsilon\><rsub|1><rsup|Q>|)><rsup|4>|)><space|0.27em>,<eq-number><label|unitexpand>>>>>>

  where the rephasing of quark fields

  <eqnarray|<tformat|<table|<row|<cell|c\<rightarrow\>c*e<rsup|i*\<pi\>>,<space|1em>s\<rightarrow\>s*e<rsup|i*\<pi\>>,<space|1em>b\<rightarrow\>b*e<rsup|i*<around|(|\<pi\>+\<delta\>|)>><eq-number><label|quarkrephase>>>>>>

  is implied to make the lowest order be unit matrix.

  Before moving on to lepton sector, we need to talk about the QLC relations
  in Eq.<nbsp>(<reference|kmqlc>) here. In terms of triminimal parameters, it
  is natural to rewrite Eq.<nbsp>(<reference|kmqlc>) as

  <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|1><rsup|0*Q>+\<theta\><rsub|1><rsup|0*L>=<frac|\<pi\>|4>,<space|1em>\<theta\><rsub|2><rsup|0*Q>+\<theta\><rsub|2><rsup|0*L>=<frac|\<pi\>|4>,<space|1em>\<theta\><rsub|3><rsup|0*Q>=\<theta\><rsub|3><rsup|0*L>=0,<eq-number><label|qlc>>>>>>

  and recognize all <math|\<epsilon\><rsub|i><rsup|Q>> and
  <math|\<epsilon\><rsub|i><rsup|L>> as small deviations. Therefore,
  corresponding to the choice in quark sector
  Eq.<nbsp>(<reference|unitcondition>), we have

  <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|1><rsup|0*L>=\<theta\><rsub|2><rsup|0*L>=<frac|\<pi\>|4>,<space|1em>\<theta\><rsub|3><rsup|0*L>=0<space|0.27em>,<eq-number>>>>>>

  in lepton sector. Similar redefinition of lepton fields

  <eqnarray|<tformat|<table|<row|<cell|\<mu\>\<rightarrow\>\<mu\>*e<rsup|i*\<pi\>>,<space|1em>\<nu\><rsup|\<mu\>>\<rightarrow\>\<nu\><rsup|\<mu\>>*e<rsup|i*\<pi\>>,<space|1em>\<nu\><rsup|\<tau\>>\<rightarrow\>\<nu\><rsup|\<tau\>>*e<rsup|i*<around|(|\<pi\>+\<delta\>|)>><eq-number><label|leptonrephase>>>>>>

  is also implied to adjust the phases. To the second order of
  <math|\<epsilon\><rsub|i><rsup|L>>, lepton mixing matrix is expanded as

  <eqnarray|<tformat|<table|<row|<cell|U<rsub|<math-up|PMNS>>>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<frac|1|<sqrt|2>>>|<cell|<frac|1|<sqrt|2>>>|<cell|0>>|<row|<cell|-<frac|1|2>>|<cell|<frac|1|2>>|<cell|<frac|1|<sqrt|2>>>>|<row|<cell|<frac|1|2>>|<cell|-<frac|1|2>>|<cell|<frac|1|<sqrt|2>>>>>>>|)>+\<epsilon\><rsub|1><rsup|L><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-<frac|1|<sqrt|2>>>|<cell|<frac|1|<sqrt|2>>>|<cell|0>>|<row|<cell|-<frac|1|2>>|<cell|-<frac|1|2>>|<cell|0>>|<row|<cell|<frac|1|2>>|<cell|<frac|1|2>>|<cell|0>>>>>|)>+\<epsilon\><rsub|2><rsup|L><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<frac|1|2>>|<cell|-<frac|1|2>>|<cell|<frac|1|<sqrt|2>>>>|<row|<cell|<frac|1|2>>|<cell|-<frac|1|2>>|<cell|-<frac|1|<sqrt|2>>>>>>>|)>+\<epsilon\><rsub|3><rsup|L><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|<frac|e<rsup|-i*\<delta\>>|<sqrt|2>>>>|<row|<cell|0>|<cell|-<frac|e<rsup|i*\<delta\>>|<sqrt|2>>>|<cell|<frac|e<rsup|-i*\<delta\>>|2>>>|<row|<cell|0>|<cell|-<frac|e<rsup|i*\<delta\>>|<sqrt|2>>>|<cell|-<frac|e<rsup|-i*\<delta\>>|2>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|<frac|<around|(|\<epsilon\><rsub|1><rsup|L>|)><rsup|2>|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-<frac|1|<sqrt|2>>>|<cell|-<frac|1|<sqrt|2>>>|<cell|0>>|<row|<cell|<frac|1|2>>|<cell|-<frac|1|2>>|<cell|0>>|<row|<cell|-<frac|1|2>>|<cell|<frac|1|2>>|<cell|0>>>>>|)>+<frac|<around|(|\<epsilon\><rsub|2><rsup|L>|)><rsup|2>|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<frac|1|2>>|<cell|-<frac|1|2>>|<cell|-<frac|1|<sqrt|2>>>>|<row|<cell|-<frac|1|2>>|<cell|<frac|1|2>>|<cell|-<frac|1|<sqrt|2>>>>>>>|)>+<frac|<around|(|\<epsilon\><rsub|3><rsup|L>|)><rsup|2>|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|-<frac|1|<sqrt|2>>>|<cell|0>>|<row|<cell|0>|<cell|-<frac|1|2>>|<cell|-<frac|1|<sqrt|2>>>>|<row|<cell|0>|<cell|<frac|1|2>>|<cell|-<frac|1|<sqrt|2>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|<frac|\<epsilon\><rsub|1><rsup|L>*\<epsilon\><rsub|2><rsup|L>|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|1>|<cell|1>|<cell|0>>|<row|<cell|1>|<cell|1>|<cell|0>>>>>|)>+\<epsilon\><rsub|2><rsup|L>*\<epsilon\><rsub|3><rsup|L><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|-<frac|e<rsup|i*\<delta\>>|<sqrt|2>>>|<cell|-<frac|e<rsup|-i*\<delta\>>|2>>>|<row|<cell|0>|<cell|<frac|e<rsup|i*\<delta\>>|<sqrt|2>>>|<cell|-<frac|e<rsup|-i*\<delta\>>|2>>>>>>|)>+\<epsilon\><rsub|1><rsup|L>*\<epsilon\><rsub|3><rsup|L><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|<frac|e<rsup|-i*\<delta\>>|<sqrt|2>>>>|<row|<cell|0>|<cell|0>|<cell|-<frac|e<rsup|-i*\<delta\>>|2>>>|<row|<cell|0>|<cell|0>|<cell|<frac|e<rsup|-i*\<delta\>>|2>>>>>>|)>+\<cal-O\><around|(|<around|(|\<epsilon\><rsub|i><rsup|L>|)><rsup|3>|)><space|0.27em>.<eq-number>>>>>>

  As we expect, the zeroth order is the bimaximal matrix
  <math|U<rsub|<math-up|bi>>>.

  <subsection|Wolfenstein-like parametrization>

  We now compare the triminimal parametrization with the Wolfenstein
  parametrization in quark sector. Since the original Wolfenstein
  parametrization takes the same phase convention as the standard CK
  form<nbsp><cite|unified>, which implies different choice of parameters,
  especially the CP-violating phase <math|\<delta\>>, it is complicated to
  arrive at the Wolfenstein parametrization from the triminimal expansion of
  KM matrix by adjusting the phases of the fields. Therefore, we only keep
  the original Wolfenstein expanding parameter <math|\<lambda\>>, which
  satisfies <math|\<lambda\>=sin \<theta\><rsub|1><rsup|Q>\<approx\>\<epsilon\><rsub|1><rsup|Q>-<frac|<around|(|\<epsilon\><rsub|1><rsup|Q>|)><rsup|3>|6>>,
  and introduce two new parameters with

  <eqnarray|<tformat|<table|<row|<cell|f*\<lambda\><rsup|2>=sin
  \<theta\><rsub|2><rsup|Q>\<approx\>\<epsilon\><rsub|2><rsup|Q>,<space|1em>h*\<lambda\><rsup|2>=sin
  \<theta\><rsub|3><rsup|Q>\<approx\>\<epsilon\><rsub|3><rsup|Q><space|0.27em>.<eq-number><label|fhrelation>>>>>>

  The CP-violating phase <math|\<delta\>> has clear physical meaning so we
  naturally keep it. Finally, by substituting them into
  Eq.<nbsp>(<reference|unitexpand>), we obtain a new Wolfenstein-like
  parametrization, given by

  <eqnarray|<tformat|<table|<row|<cell|V<rsub|<math-up|CKM>>=<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|1-<frac|\<lambda\><rsup|2>|2>>|<cell|\<lambda\>>|<cell|e<rsup|-i*\<delta\>>*h*\<lambda\><rsup|3>>>|<row|<cell|-\<lambda\>>|<cell|1-<frac|\<lambda\><rsup|2>|2>>|<cell|<around|(|f+e<rsup|-i*\<delta\>>*h|)>*\<lambda\><rsup|2>>>|<row|<cell|f*\<lambda\><rsup|3>>|<cell|-<around|(|f+e<rsup|i*\<delta\>>*h|)>*\<lambda\><rsup|2>>|<cell|1>>>>>|)><space|0.27em>,<eq-number><label|newwolf>>>>>>

  which is a new simple form of quark mixing matrix given in our recent
  work<nbsp><cite|qinnan>. Direct calculation of
  <math|f*\<lambda\><rsup|3>=<around|\||V<rsub|t*d>|\|>>,
  <math|h*\<lambda\><rsup|3>=<around|\||V<rsub|u*b>|\|>> and
  <math|<around|\||f+e<rsup|-i*\<delta\><rsup|Q>>*h|\|>*\<lambda\><rsup|2>=<around|\||V<rsub|c*b>|\|>>
  with the latest data<nbsp>(<reference|ckmdata>)
  and<nbsp>(<reference|wolfdata>) gives

  <eqnarray|<tformat|<table|<row|<cell|\<lambda\>=0.2253\<pm\>0.0007,<space|1em>h=0.303<rsup|+0.014><rsub|-0.010>,<space|1em>f=0.754<rsup|+0.022><rsub|-0.018>,<space|1em>\<delta\><rsup|Q>=90.97<rsup|\<circ\>><rsub|-4.44<rsup|\<circ\>>><rsup|+2.77<rsup|\<circ\>>><space|0.27em>,<eq-number><label|hf>>>>>>

  which are slightly different from the results in Ref.<nbsp><cite|qinnan>
  where previous data are used. This new form of quark mixing matrix
  preserves the hierarchical structure of the mixing. More importantly, it is
  convenient for numerical analysis, especially for constraint of the
  CP-violating phase. Along with unitarity boomerangs it may be useful to
  study the presence of new physics.

  To get unified Wolfenstein-like parametrizations for quark and lepton
  mixing, we need to use the QLC relations Eq.<nbsp>(<reference|kmqlc>), of
  which the first two equations lead to the choice of the parameters in the
  lepton sector as

  <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|1><rsup|L>=\<pi\>/4-arcsin
  \<lambda\>,<space|1em>\<theta\><rsub|2><rsup|L>=\<pi\>/4-arcsin
  f*\<lambda\><rsup|2>,<eq-number>>>>>>

  i.e., parameters <math|\<lambda\>> and <math|f>, which we introduce in
  quark sector are also employed in lepton sector. The other two parameters
  are one angle parameter related to <math|\<theta\><rsub|3><rsup|L>> and a
  CP-violating phase <math|\<delta\><rsup|L>>. Since the experimental data
  for the small angle <math|\<theta\><rsub|3><rsup|L>> is not accurate
  enough, we can either set <math|\<theta\><rsub|3><rsup|L>=\<eta\>*\<lambda\>>
  or <math|\<theta\><rsub|3><rsup|L>=\<eta\><rprime|'>*\<lambda\><rsup|2>>
  depending on the value of <math|<around|\||U<rsub|e*3>|\|>>. We now discuss
  these two cases separately.

  <with|font-family|rm|Case 1: <math|\<theta\><rsub|3><rsup|L>=\<eta\>*\<lambda\>>>

  The lepton mixing matrix can be expanded in order of <math|\<lambda\>> as

  <eqnarray|<tformat|<table|<row|<cell|U<rsub|<math-up|PMNS>>>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<frac|1|<sqrt|2>>>|<cell|<frac|1|<sqrt|2>>>|<cell|0>>|<row|<cell|-<frac|1|2>>|<cell|<frac|1|2>>|<cell|<frac|1|<sqrt|2>>>>|<row|<cell|<frac|1|2>>|<cell|-<frac|1|2>>|<cell|<frac|1|<sqrt|2>>>>>>>|)>+\<lambda\><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<frac|1|<sqrt|2>>>|<cell|-<frac|1|<sqrt|2>>>|<cell|<frac|e<rsup|-i*\<delta\>>*\<eta\>|<sqrt|2>>>>|<row|<cell|<frac|1|2>>|<cell|<frac|1|2>-<frac|e<rsup|i*\<delta\>>*\<eta\>|<sqrt|2>>>|<cell|<frac|1|2>*e<rsup|-i*\<delta\>>*\<eta\>>>|<row|<cell|-<frac|1|2>>|<cell|-<frac|e<rsup|i*\<delta\>>*\<eta\>|<sqrt|2>>-<frac|1|2>>|<cell|-<frac|1|2>*e<rsup|-i*\<delta\>>*\<eta\>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<lambda\><rsup|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-<frac|1|2*<sqrt|2>>>|<cell|-<frac|\<eta\><rsup|2>|2*<sqrt|2>>-<frac|1|2*<sqrt|2>>>|<cell|-<frac|e<rsup|-i*\<delta\>>*\<eta\>|<sqrt|2>>>>|<row|<cell|<frac|1|4>-<frac|f|2>>|<cell|-<frac|\<eta\><rsup|2>|4>+<frac|f|2>-<frac|1|4>>|<cell|-<frac|\<eta\><rsup|2>|2*<sqrt|2>>+<frac|1|2>*e<rsup|-i*\<delta\>>*\<eta\>-<frac|f|<sqrt|2>>>>|<row|<cell|-<frac|f|2>-<frac|1|4>>|<cell|<frac|\<eta\><rsup|2>|4>+<frac|f|2>+<frac|1|4>>|<cell|-<frac|(\<eta\><rsup|2>|2*<sqrt|2>>-<frac|1|2>*e<rsup|-i*\<delta\>>*\<eta\>+<frac|f|<sqrt|2>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<lambda\><rsup|3><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|<frac|\<eta\><rsup|2>|2*<sqrt|2>>>|<cell|-<frac|e<rsup|-i*\<delta\>>*\<eta\><rsup|3>|6*<sqrt|2>>-<frac|e<rsup|-i*\<delta\>>*\<eta\><rprime|'>|2*<sqrt|2>>>>|<row|<cell|<frac|f|2>>|<cell|<frac|e<rsup|i*\<delta\>>*\<eta\><rsup|3>|6*<sqrt|2>>-<frac|\<eta\><rsup|2>|4>+<frac|e<rsup|i*\<delta\>>*f*\<eta\>|<sqrt|2>>+<frac|f|2>>|<cell|-<frac|1|12>*e<rsup|-i*\<delta\>>*\<eta\><rsup|3>-<frac|1|4>*e<rsup|-i*\<delta\>>*\<eta\>+<frac|1|2>*e<rsup|-i*\<delta\>>*f*\<eta\>>>|<row|<cell|<frac|f|2>>|<cell|<frac|e<rsup|i*\<delta\>>*\<eta\><rsup|3>|6*<sqrt|2>>+<frac|\<eta\><rsup|2>|4>-<frac|e<rsup|i*\<delta\>>*f*\<eta\>|<sqrt|2>>+<frac|f|2>>|<cell|<frac|1|12>*e<rsup|-i*\<delta\>>*\<eta\><rsup|3>+<frac|1|4>*e<rsup|-i*\<delta\>>*\<eta\>+<frac|1|2>*e<rsup|-i*\<delta\>>*f*\<eta\>>>>>>|)>+\<cal-O\><around|(|\<lambda\><rsup|4>|)><space|0.27em>.<eq-number>>>>>>

  With the modulus of the element <math|U<rsub|e*3>> in
  Eq.<nbsp>(<reference|pmnsdata>) and the results for <math|\<lambda\>> and
  <math|f> in Eq.<nbsp>(<reference|hf>), the new parameter is constrained by
  <math|0\<less\>\<eta\>\<less\>1.923>.

  <with|font-family|rm|Case 2: <math|\<theta\><rsub|3><rsup|L>=\<eta\><rprime|'>*\<lambda\><rsup|2>>>

  In this case the expansion looks simpler since <math|\<eta\><rprime|'>>
  only starts to appear in <math|\<cal-O\><around|(|\<lambda\><rsup|2>|)>>
  terms:

  <eqnarray|<tformat|<table|<row|<cell|U<rsub|<math-up|PMNS>>>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<frac|1|<sqrt|2>>>|<cell|<frac|1|<sqrt|2>>>|<cell|0>>|<row|<cell|-<frac|1|2>>|<cell|<frac|1|2>>|<cell|<frac|1|<sqrt|2>>>>|<row|<cell|<frac|1|2>>|<cell|-<frac|1|2>>|<cell|<frac|1|<sqrt|2>>>>>>>|)>+\<lambda\><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<frac|1|<sqrt|2>>>|<cell|-<frac|1|<sqrt|2>>>|<cell|0>>|<row|<cell|<frac|1|2>>|<cell|<frac|1|2>>|<cell|0>>|<row|<cell|-<frac|1|2>>|<cell|-<frac|1|2>>|<cell|0>>>>>|)>+\<lambda\><rsup|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-<frac|1|2*<sqrt|2>>>|<cell|-<frac|1|2*<sqrt|2>>>|<cell|<frac|e<rsup|-i*\<delta\>>*\<eta\><rprime|'>|<sqrt|2>>>>|<row|<cell|<frac|1|4>-<frac|f|2>>|<cell|<frac|f|2>-<frac|e<rsup|i*\<delta\>>*\<eta\><rprime|'>|<sqrt|2>>-<frac|1|4>>|<cell|<frac|1|2>*e<rsup|-i*\<delta\>>*\<eta\><rprime|'>-<frac|f|<sqrt|2>>>>|<row|<cell|-<frac|f|2>-<frac|1|4>>|<cell|<frac|f|2>-<frac|e<rsup|i*\<delta\>>*\<eta\><rprime|'>|<sqrt|2>>+<frac|1|4>>|<cell|<frac|f|<sqrt|2>>-<frac|1|2>*e<rsup|-i*\<delta\>>*\<eta\><rprime|'>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<lambda\><rsup|3><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|-<frac|e<rsup|-i*\<delta\>>*\<eta\><rprime|'>|<sqrt|2>>>>|<row|<cell|<frac|f|2>>|<cell|<frac|f|2>>|<cell|<frac|1|2>*e<rsup|-i*\<delta\>>*\<eta\><rprime|'>>>|<row|<cell|<frac|f|2>>|<cell|<frac|f|2>>|<cell|-<frac|1|2>*e<rsup|-i*\<delta\>>*\<eta\><rprime|'>>>>>>|)>+\<cal-O\><around|(|\<lambda\><rsup|4>|)><space|0.27em>.<eq-number>>>>>>

  However, we have a larger range in this case with
  <math|0\<less\>\<eta\><rprime|'>\<less\>7.912>.

  To the lowest order the Jarlskog parameter in both quark and lepton sectors
  is given by

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|J<rsup|Q>=<math-up|Im><around|(|V<rsub|u*s>*V<rsub|c*b>*V<rsub|u*b><rsup|\<ast\>>*V<rsub|c*s><rsup|\<ast\>>|)>=f*h*\<lambda\><rsup|6>*sin
  \<delta\><rsup|Q>,>>|<row|<cell|>|<cell|>|<cell|J<rsup|L>=<math-up|Im><around|(|U<rsub|e*2>*U<rsub|\<mu\>*3>*U<rsub|e*3><rsup|\<ast\>>*U<rsub|\<mu\>*2><rsup|\<ast\>>|)>=<frac|1|4*<sqrt|2>>*\<eta\>*\<lambda\>*sin
  \<delta\><rsup|L>,>>|<row|<cell|>|<cell|>|<cell|J<rsup|L>=<math-up|Im><around|(|U<rsub|e*2>*U<rsub|\<mu\>*3>*U<rsub|e*3><rsup|\<ast\>>*U<rsub|\<mu\>*2><rsup|\<ast\>>|)>=<frac|1|4*<sqrt|2>>*\<eta\><rprime|'>*\<lambda\><rsup|2>*sin
  \<delta\><rsup|L><space|0.27em>.<eq-number>>>>>>

  The last two equations correspond to the two cases respectively.

  <section|Parametrization of the KM matrix in tri-bimaximal pattern>

  <subsection|The triminimal expansion>

  Present data of the PMNS matrix indicate that the mixing in the lepton
  sector is closer to the tri-bimaximal mixing. One would have a much faster
  convergent expansion if it starts with a tri-bimaximal mixing form as the
  basis, which implies again the rephasing of lepton fields in
  Eq.<nbsp>(<reference|leptonrephase>) and the choice of
  <math|\<theta\><rsub|i><rsup|0*L>> as

  <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|1><rsup|0*L>=arcsin
  <frac|1|<sqrt|3>>,<space|1em>\<theta\><rsub|2><rsup|0*L>=<frac|\<pi\>|4>,<space|1em>\<theta\><rsub|3><rsup|0*L>=0<space|0.27em>.<eq-number>>>>>>

  Under such conditions, the lepton mixing matrix expanded to the second
  order of <math|\<epsilon\><rsub|i><rsup|L>> is given by

  <eqnarray|<tformat|<table|<row|<cell|U<rsub|<math-up|PMNS>>>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<sqrt|<frac|2|3>>>|<cell|<frac|1|<sqrt|3>>>|<cell|0>>|<row|<cell|-<frac|1|<sqrt|6>>>|<cell|<frac|1|<sqrt|3>>>|<cell|<frac|1|<sqrt|2>>>>|<row|<cell|<frac|1|<sqrt|6>>>|<cell|-<frac|1|<sqrt|3>>>|<cell|<frac|1|<sqrt|2>>>>>>>|)>+\<epsilon\><rsub|1><rsup|L><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-<frac|1|<sqrt|3>>>|<cell|<sqrt|<frac|2|3>>>|<cell|0>>|<row|<cell|-<frac|1|<sqrt|3>>>|<cell|-<frac|1|<sqrt|6>>>|<cell|0>>|<row|<cell|<frac|1|<sqrt|3>>>|<cell|<frac|1|<sqrt|6>>>|<cell|0>>>>>|)>+\<epsilon\><rsub|2><rsup|L><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<frac|1|<sqrt|6>>>|<cell|-<frac|1|<sqrt|3>>>|<cell|<frac|1|<sqrt|2>>>>|<row|<cell|<frac|1|<sqrt|6>>>|<cell|-<frac|1|<sqrt|3>>>|<cell|-<frac|1|<sqrt|2>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<epsilon\><rsub|3><rsup|L><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|<frac|e<rsup|-i*\<delta\>>|<sqrt|3>>>>|<row|<cell|0>|<cell|-<frac|e<rsup|i*\<delta\>>|<sqrt|2>>>|<cell|<frac|e<rsup|-i*\<delta\>>|<sqrt|3>>>>|<row|<cell|0>|<cell|-<frac|e<rsup|i*\<delta\>>|<sqrt|2>>>|<cell|-<frac|e<rsup|-i*\<delta\>>|<sqrt|3>>>>>>>|)>+<frac|<around|(|\<epsilon\><rsub|1><rsup|L>|)><rsup|2>|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-<sqrt|<frac|2|3>>>|<cell|-<frac|1|<sqrt|3>>>|<cell|0>>|<row|<cell|<frac|1|<sqrt|6>>-<frac|1|<sqrt|3>>>|<cell|0>|<cell|>>|<row|<cell|-<frac|1|<sqrt|6>>>|<cell|<frac|1|<sqrt|3>>>|<cell|0>>>>>|)>+<frac|<around|(|\<epsilon\><rsub|2><rsup|L>|)><rsup|2>|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<frac|1|<sqrt|6>>>|<cell|-<frac|1|<sqrt|3>>>|<cell|-<frac|1|<sqrt|2>>>>|<row|<cell|-<frac|1|<sqrt|6>>>|<cell|<frac|1|<sqrt|3>>>|<cell|-<frac|1|<sqrt|2>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|<frac|<around|(|\<epsilon\><rsub|3><rsup|L>|)><rsup|2>|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|-<frac|1|<sqrt|3>>>|<cell|0>>|<row|<cell|0>|<cell|-<frac|1|<sqrt|3>>>|<cell|-<frac|1|<sqrt|2>>>>|<row|<cell|0>|<cell|<frac|1|<sqrt|3>>>|<cell|-<frac|1|<sqrt|2>>>>>>>|)>+\<epsilon\><rsub|1><rsup|L>*\<epsilon\><rsub|2><rsup|L><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<frac|1|<sqrt|3>>>|<cell|<frac|1|<sqrt|6>>>|<cell|0>>|<row|<cell|<frac|1|<sqrt|3>>>|<cell|<frac|1|<sqrt|6>>>|<cell|0>>>>>|)>+\<epsilon\><rsub|2><rsup|L>*\<epsilon\><rsub|3><rsup|L><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|-<frac|e<rsup|i*\<delta\>>|<sqrt|2>>>|<cell|-<frac|e<rsup|-i*\<delta\>>|<sqrt|3>>>>|<row|<cell|0>|<cell|<frac|e<rsup|i*\<delta\>>|<sqrt|2>>>|<cell|-<frac|e<rsup|-i*\<delta\>>|<sqrt|3>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<epsilon\><rsub|1><rsup|L>*\<epsilon\><rsub|3><rsup|L><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|<sqrt|<frac|2|3>>*e<rsup|-i*\<delta\>>>>|<row|<cell|0>|<cell|0>|<cell|-<frac|e<rsup|-i*\<delta\>>|<sqrt|6>>>>|<row|<cell|0>|<cell|0>|<cell|<frac|e<rsup|-i*\<delta\>>|<sqrt|6>>>>>>>|)>+\<cal-O\><around|(|<around|(|\<epsilon\><rsub|i><rsup|L>|)><rsup|3>|)><space|0.27em>.<eq-number>>>>>>

  With Eq.<nbsp>(<reference|qlc>) as our guide, we get the zeroth order of
  mixing angles in the quark sector as

  <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|1><rsup|0*Q>=arcsin
  <frac|<sqrt|2>-1|<sqrt|6>>,<nbsp>\<theta\><rsub|2><rsup|0*Q>=0,<nbsp>\<theta\><rsub|3><rsup|0*Q>=0<space|0.27em>.<eq-number>>>>>>

  In this case the deviations are

  <eqnarray|<tformat|<table|<row|<cell|\<epsilon\><rsub|1><rsup|Q>=0.0574<rsub|-0.0003><rsup|+0.0010>,<space|1em>\<epsilon\><rsub|2><rsup|Q>=0.0383<rsub|-0.0010><rsup|+0.0011>,<space|1em>\<epsilon\><rsub|3><rsup|Q>=0.0154<rsub|-0.0006><rsup|+0.0008><space|0.27em>,<eq-number>>>>>>

  according to Eq.<nbsp>(<reference|kmdata>). Thus
  <math|\<epsilon\><rsub|i><rsup|Q>\<sim\>\<cal-O\><around|(|10<rsup|-2>|)>>,
  and we have a faster convergent expansion for quark mixing as

  <eqnarray|<tformat|<table|<row|<cell|V<rsub|<math-up|CKM>>>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|0>>|<row|<cell|-<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|1>>>>>|)>+\<epsilon\><rsub|1><rsup|Q><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|0>>|<row|<cell|-<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|-<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>>>>>|)>+\<epsilon\><rsub|2><rsup|Q><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|1>>|<row|<cell|<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|-<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|0>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<epsilon\><rsub|3><rsup|Q><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|<frac|<sqrt|2>-1|<sqrt|6>>*e<rsup|-i*\<delta\>>>>|<row|<cell|0>|<cell|0>|<cell|<frac|<sqrt|2>+1|<sqrt|6>>*e<rsup|-i*\<delta\>>>>|<row|<cell|0>|<cell|-e<rsup|i*\<delta\>>>|<cell|0>>>>>|)>+<frac|<around|(|\<epsilon\><rsub|1><rsup|Q>|)><rsup|2>|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|-<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|0>>|<row|<cell|<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|-<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>>>>>|)>+<frac|<around|(|\<epsilon\><rsub|2><rsup|Q>|)><rsup|2>|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|-<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|-1>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|<frac|<around|(|\<epsilon\><rsub|3><rsup|Q>|)><rsup|2>|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|-<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|0>>|<row|<cell|0>|<cell|-<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|-1>>>>>|)>+\<epsilon\><rsub|1><rsup|Q>*\<epsilon\><rsub|2><rsup|Q><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|0>>>>>|)>+\<epsilon\><rsub|2><rsup|Q>*\<epsilon\><rsub|3><rsup|Q><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|-e<rsup|i*\<delta\>>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|-<frac|<sqrt|2>+1|<sqrt|6>>*e<rsup|-i*\<delta\>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<epsilon\><rsub|1><rsup|Q>*\<epsilon\><rsub|3><rsup|Q><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|0>|<cell|0>|<cell|<frac|<sqrt|2>+1|<sqrt|6>>*e<rsup|-i*\<delta\>>>>|<row|<cell|0>|<cell|0>|<cell|-<frac|<sqrt|2>-1|<sqrt|6>>*e<rsup|-i*\<delta\>>>>|<row|<cell|0>|<cell|0>|<cell|0>>>>>|)>+\<cal-O\><around|(|<around|(|\<epsilon\><rsub|i><rsup|Q>|)><rsup|3>|)><space|0.27em>.<eq-number>>>>>>

  Consistent with the results in Ref.<nbsp><cite|lisw>, the QLC relations
  relate the tri-bimaximal matrix in the lepton sector with
  <math|V<rprime|'><rsub|0>> in the quark sector, noting that they are both
  more close to experimental data compared with the bimaximal matrix and unit
  matrix.

  <subsection|Wolfenstein-like parametrization>

  Similarly with Sec.<nbsp>III, we now discuss the corresponding
  Wolfenstein-like parametrizations in both quark sector and lepton sector in
  a unified way with the help of QLC relations. For quark mixing, we can
  employ <math|\<rho\>=\<epsilon\><rsub|1><rsup|Q>> as expanding parameter
  and introduce two coefficients with <math|s*\<rho\>=\<epsilon\><rsub|2><rsup|Q>>,
  <math|t*\<rho\>=\<epsilon\><rsub|3><rsup|Q>>, i.e.,

  <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|1><rsup|Q>=arcsin
  <frac|<sqrt|2>-1|<sqrt|6>>+\<rho\>,<space|1em>\<theta\><rsub|2><rsup|Q>=s*\<rho\>,<space|1em>\<theta\><rsub|3><rsup|Q>=t*\<rho\><space|0.27em>.<eq-number>>>>>>

  Since the expansion around basis <math|V<rprime|'><rsub|0>> converges
  faster than the case in Sec.<nbsp>III, it is accurate enough to calculate
  to <math|\<cal-O\><around|(|\<rho\><rsup|2>|)>>, given by

  <eqnarray|<tformat|<table|<row|<cell|V<rsub|<math-up|CKM>>>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|0>>|<row|<cell|-<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|1>>>>>|)>+\<rho\><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|<frac|<around|(|<sqrt|2>-1|)>*e<rsup|-i*\<delta\>>*t|<sqrt|6>>>>|<row|<cell|-<frac|<sqrt|2>+1|<sqrt|6>>>|<cell|-<frac|<sqrt|2>-1|<sqrt|6>>>|<cell|s+<frac|<around|(|<sqrt|2>+1|)>*e<rsup|-i*\<delta\>>*t|<sqrt|6>>>>|<row|<cell|<frac|<around|(|<sqrt|2>-1|)>*s|<sqrt|6>>>|<cell|-<frac|<around|(|<sqrt|2>+1|)>*s|<sqrt|6>>-e<rsup|i*\<delta\>>*t>|<cell|0>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<rho\><rsup|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-<frac|<sqrt|2>+1|2*<sqrt|6>>>|<cell|-<frac|<around|(|<sqrt|2>-1|)>*<around|(|t<rsup|2>+1|)>|2*<sqrt|6>>>|<cell|<frac|<around|(|<sqrt|2>+1|)>*e<rsup|-i*\<delta\>>*t|<sqrt|6>>>>|<row|<cell|<frac|<around|(|<sqrt|2>-1|)>*<around|(|s<rsup|2>+1|)>|2*<sqrt|6>>>|<cell|-<frac|<around|(|<sqrt|2>+1|)>*<around|(|s<rsup|2>+t<rsup|2>+1|)>|2*<sqrt|6>>-e<rsup|i*\<delta\>>*t*s>|<cell|-<frac|<around|(|<sqrt|2>-1|)>*e<rsup|-i*\<delta\>>*t|<sqrt|6>>>>|<row|<cell|<frac|<around|(|<sqrt|2>+1|)>*s|<sqrt|6>>>|<cell|<frac|<around|(|<sqrt|2>-1|)>*s|<sqrt|6>>>|<cell|-<frac|<around|(|<sqrt|2>+1|)>*e<rsup|-i*\<delta\>>*t*s|<sqrt|6>>-<frac|s<rsup|2>|2>-<frac|t<rsup|2>|2>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<cal-O\><around|(|\<rho\><rsup|3>|)><space|0.27em>.<eq-number>>>>>>

  By using the data for elements <math|V<rsub|u*d>>, <math|V<rsub|u*b>>,
  <math|V<rsub|t*d>> and <math|V<rsub|c*b>> in
  Eq.<nbsp>(<reference|ckmdata>), we get the ranges for the parameters with

  <eqnarray|<tformat|<table|<row|<cell|\<rho\>=0.0574<rsup|+0.0006><rsub|-0.0007>,<space|1em>s=0.667<rsub|-0.016><rsup|+0.020>,<space|1em>t=0.268<rsub|-0.002><rsup|+0.013>,<space|1em>\<delta\><rsup|Q>=90.30<rsup|\<circ\>><rsub|-4.57<rsup|\<circ\>>><rsup|+2.85<rsup|\<circ\>>><space|0.27em>.<eq-number>>>>>>

  As we can see here, the expanding parameter is
  <math|\<rho\>\<sim\>\<cal-O\><around|(|10<rsup|-2>|)>>, making the
  expansion converge fast as we mentioned before, and indicating that
  <math|V<rprime|'><rsub|0>> is indeed a good choice of basis matrix.

  For the corresponding Wolfenstein-like matrix in lepton sector, by using
  the QLC relations in Eq.<nbsp>(<reference|kmqlc>), we have

  <eqnarray|<tformat|<table|<row|<cell|\<theta\><rsub|1><rsup|L>=<frac|\<pi\>|4>-<around|(|arcsin
  <frac|<sqrt|2>-1|<sqrt|6>>+\<rho\>|)>,<space|1em>\<theta\><rsub|2><rsup|L>=<frac|\<pi\>|4>-s*\<rho\><space|0.27em>.<eq-number>>>>>>

  We still need to retain the CP-violating phase <math|\<delta\><rsup|L>> and
  to introduce a new parameter <math|\<tau\>> (or <math|\<tau\><rprime|'>>).
  Here similar discussions as in Sec.<nbsp>III are needed depending on the
  value of <math|<around|\||U<rsub|e*3>|\|>>.

  <with|font-family|rm|Case 1: <math|\<theta\><rsub|3><rsup|L>=\<tau\>*\<rho\>>>

  To good accuracy, we expand the PMNS matrix to
  <math|\<cal-O\><around|(|\<rho\><rsup|2>|)>> and obtain

  <eqnarray|<tformat|<table|<row|<cell|U<rsub|<math-up|PMNS>>>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<sqrt|<frac|2|3>>>|<cell|<frac|1|<sqrt|3>>>|<cell|0>>|<row|<cell|-<frac|1|<sqrt|6>>>|<cell|<frac|1|<sqrt|3>>>|<cell|<frac|1|<sqrt|2>>>>|<row|<cell|<frac|1|<sqrt|6>>>|<cell|-<frac|1|<sqrt|3>>>|<cell|<frac|1|<sqrt|2>>>>>>>|)>+\<rho\><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<frac|1|<sqrt|3>>>|<cell|-<sqrt|<frac|2|3>>>|<cell|<frac|e<rsup|-i*\<delta\>>*\<tau\>|<sqrt|3>>>>|<row|<cell|<frac|1|<sqrt|3>>-<frac|s|<sqrt|6>>>|<cell|<frac|s|<sqrt|3>>-<frac|e<rsup|i*\<delta\>>*\<tau\>|<sqrt|2>>+<frac|1|<sqrt|6>>>|<cell|<frac|e<rsup|-i*\<delta\>>*\<tau\>|<sqrt|3>>-<frac|s|<sqrt|2>>>>|<row|<cell|-<frac|s|<sqrt|6>>-<frac|1|<sqrt|3>>>|<cell|<frac|s|<sqrt|3>>-<frac|e<rsup|i*\<delta\>>*\<tau\>|<sqrt|2>>-<frac|1|<sqrt|6>>>|<cell|<frac|s|<sqrt|2>>-<frac|e<rsup|-i*\<delta\>>*\<tau\>|<sqrt|3>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<rho\><rsup|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-<frac|1|<sqrt|6>>>|<cell|-<frac|\<tau\><rsup|2>|2*<sqrt|3>>-<frac|1|2*<sqrt|3>>>|<cell|-<sqrt|<frac|2|3>>*e<rsup|-i*\<delta\>>*\<tau\>>>|<row|<cell|<frac|s<rsup|2>|2*<sqrt|6>>+<frac|s|<sqrt|3>>+<frac|1|2*<sqrt|6>>>|<cell|-<frac|s<rsup|2>|2*<sqrt|3>>+<frac|e<rsup|i*\<delta\>>*\<tau\>*s|<sqrt|2>>+<frac|s|<sqrt|6>>-<frac|\<tau\><rsup|2>|2*<sqrt|3>>-<frac|1|2*<sqrt|3>>>|<cell|-<frac|s<rsup|2>|2*<sqrt|2>>+<frac|e<rsup|-i*\<delta\>>*\<tau\>*s|<sqrt|3>>-<frac|\<tau\><rsup|2>|2*<sqrt|2>>+<frac|e<rsup|-i*\<delta\>>*\<tau\>|<sqrt|6>>>>|<row|<cell|-<frac|s<rsup|2>|2*<sqrt|6>>+<frac|s|<sqrt|3>>-<frac|1|2*<sqrt|6>>>|<cell|<frac|s<rsup|2>|2*<sqrt|3>>-<frac|e<rsup|i*\<delta\>>*\<tau\>*s|<sqrt|2>>+<frac|s|<sqrt|6>>+<frac|\<tau\><rsup|2>|2*<sqrt|3>>+<frac|1|2*<sqrt|3>>>|<cell|-<frac|s<rsup|2>|2*<sqrt|2>>+<frac|e<rsup|-i*\<delta\>>*\<tau\>*s|<sqrt|3>>-<frac|\<tau\><rsup|2>|2*<sqrt|2>>-<frac|e<rsup|-i*\<delta\>>*\<tau\>|<sqrt|6>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<cal-O\><around|(|\<rho\><rsup|3>|)><space|0.27em>.<eq-number>>>>>>

  The upper bound of <math|<around|\||U<rsub|e*3>|\|>> gives
  <math|0\<less\>\<tau\>\<less\>7.493>.

  <with|font-family|rm|Case 2: <math|\<theta\><rsub|3><rsup|L>=\<tau\><rprime|'>*\<rho\><rsup|2>>>

  The expansion to <math|\<cal-O\><around|(|\<rho\><rsup|2>|)>> is given by

  <eqnarray|<tformat|<table|<row|<cell|U<rsub|<math-up|PMNS>>>|<cell|=>|<cell|<around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<sqrt|<frac|2|3>>>|<cell|<frac|1|<sqrt|3>>>|<cell|0>>|<row|<cell|-<frac|1|<sqrt|6>>>|<cell|<frac|1|<sqrt|3>>>|<cell|<frac|1|<sqrt|2>>>>|<row|<cell|<frac|1|<sqrt|6>>>|<cell|-<frac|1|<sqrt|3>>>|<cell|<frac|1|<sqrt|2>>>>>>>|)>+\<rho\><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|<frac|1|<sqrt|3>>>|<cell|-<sqrt|<frac|2|3>>>|<cell|0>>|<row|<cell|<frac|1|<sqrt|3>>-<frac|s|<sqrt|6>>>|<cell|<frac|s|<sqrt|3>>+<frac|1|<sqrt|6>>>|<cell|-<frac|s|<sqrt|2>>>>|<row|<cell|-<frac|s|<sqrt|6>>-<frac|1|<sqrt|3>>>|<cell|<frac|s|<sqrt|3>>-<frac|1|<sqrt|6>>>|<cell|<frac|s|<sqrt|2>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<rho\><rsup|2><around*|(|<tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|c>|<cwith|1|-1|1|1|cell-lborder|0ln>|<cwith|1|-1|2|2|cell-halign|c>|<cwith|1|-1|3|3|cell-halign|c>|<cwith|1|-1|3|3|cell-rborder|0ln>|<table|<row|<cell|-<frac|1|<sqrt|6>>>|<cell|-<frac|1|2*<sqrt|3>>>|<cell|<frac|e<rsup|-i*\<delta\>>*\<tau\><rprime|'>|<sqrt|3>>>>|<row|<cell|<frac|s<rsup|2>|2*<sqrt|6>>+<frac|s|<sqrt|3>>+<frac|1|2*<sqrt|6>>>|<cell|-<frac|s<rsup|2>|2*<sqrt|3>>+<frac|s|<sqrt|6>>-<frac|e<rsup|i*\<delta\>>*\<tau\><rprime|'>|<sqrt|2>>-<frac|1|2*<sqrt|3>>>|<cell|<frac|e<rsup|-i*\<delta\>>*\<tau\><rprime|'>|<sqrt|3>>-<frac|s<rsup|2>|2*<sqrt|2>>>>|<row|<cell|-<frac|s<rsup|2>|2*<sqrt|6>>+<frac|s|<sqrt|3>>-<frac|1|2*<sqrt|6>>>|<cell|<frac|s<rsup|2>|2*<sqrt|3>>+<frac|s|<sqrt|6>>-<frac|e<rsup|i*\<delta\>>*\<tau\><rprime|'>|<sqrt|2>>+<frac|1|2*<sqrt|3>>>|<cell|-<frac|s<rsup|2>|2*<sqrt|2>>-<frac|e<rsup|-i*\<delta\>>*\<tau\><rprime|'>|<sqrt|3>>>>>>>|)>>>|<row|<cell|>|<cell|+>|<cell|\<cal-O\><around|(|\<rho\><rsup|3>|)><space|0.27em>.<eq-number>>>>>>

  A larger range for the parameter is obtained as
  <math|0\<less\>\<tau\><rprime|'>\<less\>125.987>. If we would like to
  control the parameters to be <math|\<cal-O\><around|(|10<rsup|-1>|)>>, the
  former case is a better choice. However, further neutrino oscillation
  experiments are needed to determine <math|<around|\||U<rsub|e*3>|\|>> and
  the parameters we adopt here.

  The Jarlskog parameters in tri-bimaximal pattern are given by

  <eqnarray|<tformat|<table|<row|<cell|>|<cell|>|<cell|J<rsup|Q>=<math-up|Im><around|(|V<rsub|u*s>*V<rsub|c*b>*V<rsub|u*b><rsup|\<ast\>>*V<rsub|c*s><rsup|\<ast\>>|)>=<frac|1|6>*<sqrt|<frac|1|6>*<around|(|3-2*<sqrt|2>|)>>*s*t*\<rho\><rsup|2>*sin
  \<delta\><rsup|Q>,>>|<row|<cell|>|<cell|>|<cell|J<rsup|L>=<math-up|Im><around|(|U<rsub|e*2>*U<rsub|\<mu\>*3>*U<rsub|e*3><rsup|\<ast\>>*U<rsub|\<mu\>*2><rsup|\<ast\>>|)>=<frac|\<tau\>*\<rho\>*sin
  \<delta\><rsup|L>|3*<sqrt|6>>,>>|<row|<cell|>|<cell|>|<cell|J<rsup|L>=<math-up|Im><around|(|U<rsub|e*2>*U<rsub|\<mu\>*3>*U<rsub|e*3><rsup|\<ast\>>*U<rsub|\<mu\>*2><rsup|\<ast\>>|)>=<frac|\<tau\><rprime|'>*\<rho\><rsup|2>*sin
  \<delta\><rsup|L>|3*<sqrt|6>><space|0.27em>.<eq-number>>>>>>

  <section|Discussions and conclusions>

  In this paper, by using triminimal and Wolfenstein-like expansion
  techniques, we study in more detail the Kobayashi-Maskawa matrix in both
  quark and lepton sectors. Our motivation is based on the consideration of
  the convenience the KM form exhibits when discussing some problems such as
  unitarity boomerang and maximal CP violation.

  In the previous two sections, we choose the unit matrix and
  <math|V<rprime|'><rsub|0>> as basis matrices for quark mixing, while
  bimaximal and tri-bimaximal matrices for lepton mixing. Naturally, a
  question arises here: which pattern is better, bimaximal, or tri-bimaximal?
  On one hand, the bimaximal matrix is related with the unit matrix through
  QLC relations. The corresponding triminimal and Wolfenstein-like expansions
  are both comparatively simple and symmetric. On the other hand, compared
  with bimaximal matrix, the tri-bimaximal matrix is closer to the
  experimental data; thus, the expansion based on it converges much faster.
  This can be reflected from the smallness of the triminimal angles and the
  Wolfenstein-like expanding parameter. Therefore, if we are interested only
  in the leading order contribution, then the tri-bimaximal matrix should be
  chosen. Theoretically, there have been some attempts at understanding both
  bimaximal and tri-bimaximal matrices with the introduction of new
  symmetries to the standard model fermions. However, we still need a more
  fundamental theory to decide which pattern should be used, to reveal the
  origin of the mixing matrices.

  The Wolfenstein-like parametrizations presented in this paper are simpler
  than the results in Ref.<nbsp><cite|unified> and can be transformed to
  triminimal expansions with relations among parameters. Here by using two
  sets of the Wolfenstein-like parameters, i.e., <math|\<lambda\>>, <math|f>,
  <math|h>, <math|\<eta\>>(or <math|\<eta\><rprime|'>>),
  <math|\<delta\><rsup|Q>>, and <math|\<delta\><rsup|L>> in Sec.<nbsp>III and
  <math|\<rho\>>, <math|s>, <math|t>, <math|\<tau\>>(or
  <math|\<tau\><rprime|'>>), <math|\<delta\><rsup|Q>>, and
  <math|\<delta\><rsup|L>> in Sec.<nbsp>IV, we unify the parametrization of
  the KM matrix in quark and lepton sectors. The parameters in the quark
  sector can be well determined with current experimental data. However, the
  experimental results in lepton sector, especially for
  <math|<around|\||U<rsub|e*3>|\|>> and the CP-violating phase
  <math|\<delta\><rsup|L>>, are far from enough.

  The unified description of fermion mixing we get here results from the QLC
  relations in the KM form, and these relations are only approximately valid;
  thus, one may doubt the validity of the results. Actually, we can discuss
  this in a reversed way. By regarding these parameters for quarks and
  leptons as independent from each other, we can determine the parameters
  with data from quark experiments and lepton oscillations separately, and
  check the QLC relations. Even if the QLC relations violate, these
  parametrizations still stand separately in the quark sector and lepton
  sector. Thus, our study is helpful in understanding the mixing
  phenomenologically and may provide useful tools in searching for a profound
  theory on the fermion masses and mixing.

  <\acknowledgments*>
    This work is partially supported by National Natural Science Foundation
    of China (Grants No.<nbsp>11021092, No.<nbsp>10975003, No.<nbsp>11035003,
    ) and by the Key Grant Project of Chinese Ministry of Education (Grant
    No.<nbsp>305001).
  </acknowledgments*>

  <\thebibliography|99>
    <bibitem|cabibbo>N.<nbsp>Cabibbo, Phys. Rev. Lett.
    <with|font-series|bold|10>, 531 (1963).

    <bibitem|km>M.<nbsp>Kobayashi and T.<nbsp>Maskawa, Prog. Theor. Phys.
    <with|font-series|bold|49>, 652 (1973).

    <bibitem|pontecorvo>B.<nbsp>Pontecorvo, Sov. Phys. JETP
    <with|font-series|bold|6>, 429 (1957).

    <bibitem|mns>Z.<nbsp>Maki, M.<nbsp>Nakagawa, and S.<nbsp>Sakata, Prog.
    Theor. Phys. <with|font-series|bold|28>, 870 (1962).

    <bibitem|ck>L.L.<nbsp>Chau and W.Y.<nbsp>Keung, Phys. Rev. Lett.
    <with|font-series|bold|53>, 1802 (1984).

    <bibitem|boomerang>P.H.<nbsp>Frampton and X.-G.<nbsp>He, Phys. Lett.
    <with|font-series|bold|B688>, 67 (2010); P.H.<nbsp>Frampton and
    X.-G.<nbsp>He, Phys. Rev. <with|font-series|bold|D82>, 017301 (2010).

    <bibitem|recentwork>S.-W.<nbsp>Li and B.-Q.<nbsp>Ma, Phys. Lett.
    <with|font-series|bold|B691>, 37 (2010).

    <bibitem|koide>Y. Koide, Phys. Lett. <with|font-series|bold|B607>, 123
    (2005); Y.<nbsp>Koide and H.<nbsp>Nishiura, Phys. Rev.
    <with|font-series|bold|D79>, 093005 (2009).

    <bibitem|maximalcp>D.<nbsp>Hochberg and R.G.<nbsp>Sachs, Phys. Rev.
    <with|font-series|bold|D27>, 606 (1983); B.<nbsp>Stech, Phys. Lett.
    <with|font-series|bold|B130>, 189 (1983); I.<nbsp>Dunietz, O.W. Greenberg
    and D.-d.<nbsp>Wu, Phys. Rev. Lett. <with|font-series|bold|55>, 2935
    (1985); Y.<nbsp>Koide, M.<nbsp>Nakahara and C.<nbsp>Hamzaoui, US-91-04,
    SU-LA-91-03.

    <bibitem|pdg>Particle Data Group, J. Phys. <with|font-series|bold|G37>,
    075021 (2010).

    <bibitem|gonzalez>M.C.<nbsp>Gonzalez-Garcia and M.<nbsp>Maltoni, Phys.
    Rept. <with|font-series|bold|460>, 1 (2008).

    <bibitem|wolf>L.<nbsp>Wolfenstein, Phys. Rev. Lett.
    <with|font-series|bold|51>, 1945 (1983).

    <bibitem|triminimal>S.<nbsp>Pakvasa, W.<nbsp>Rodejohann and
    T.J.<nbsp>Weiler, Phy. Rev. Lett. <with|font-series|bold|100>, 111801
    (2008); X.-G.<nbsp>He, S.-W.<nbsp>Li and B.-Q.<nbsp>Ma, Phys. Rev.
    <with|font-series|bold|D78>, 111301R (2008).

    <bibitem|lisw>S.-W.<nbsp>Li and B.-Q.<nbsp>Ma, Phys. Rev.
    <with|font-series|bold|D77>, 093005 (2008).

    <bibitem|bi>F.<nbsp>Vissani, hep-ph/9708483; V.D.<nbsp>Barger, S.Pakvasa,
    T.J.<nbsp>Weiler, and K.<nbsp>Whisnant, Phys. Lett.
    <with|font-series|bold|B437>, 107 (1998); A.J.<nbsp>Baltz,
    A.S.<nbsp>Goldhaber, and M.<nbsp>Goldhaber, Phys. Rev. Lett.
    <with|font-series|bold|81>, 5730 (1998); I.<nbsp>Stancu and
    D.V.<nbsp>Ahluwalia, Phys. Lett. <with|font-series|bold|B460>, 431
    (1999); H.<nbsp>Georgi and S.L.<nbsp>Glashow, Phy. Rev.
    <with|font-series|bold|D61>, 097301 (2000); N.<nbsp>Li and B.-Q.<nbsp>Ma,
    Phys. Lett. B <with|font-series|bold|600>, 248 (2004)
    [arXiv:hep-ph/0408235].

    <bibitem|tri>P.F.<nbsp>Harrison, D.H.<nbsp>Perkins, and W.G.<nbsp>Scott,
    Phys. Lett. <with|font-series|bold|B458>, 79 (1999); Phys. Lett.
    <with|font-series|bold|B530>, 167 (2002); Z.Z.<nbsp>Xing, Phys. Lett.
    <with|font-series|bold|B533>, 85 (2002); P.F.<nbsp>Harrison and
    W.G.<nbsp>Scott, Phys. Lett. <with|font-series|bold|B535>, 163 (2002);
    Phys. Lett. <with|font-series|bold|B557>, 76 (2003); X.-G.<nbsp>He and
    A.<nbsp>Zee, Phys. Lett. <with|font-series|bold|B560>, 87 (2003);
    N.<nbsp>Li and B.-Q.<nbsp>Ma, Phys. Rev. D <with|font-series|bold|71>,
    017302 (2005) [arXiv:hep-ph/0412126]. See also L.<nbsp>Wolfenstein, Phys.
    Rev. <with|font-series|bold|D18>, 958 (1978); Y.<nbsp>Yamanaka,
    H.<nbsp>Sugawara, and S.<nbsp>Pakvasa, Phys. Rev.
    <with|font-series|bold|D25>, 1895(1982); <with|font-series|bold|D29>,
    2135(E)(1984).

    <bibitem|qlcparabi>N.<nbsp>Li and B.-Q.<nbsp>Ma, Eur. Phys. J.
    <with|font-series|bold|C42>, 17 (2005).

    <bibitem|qlc>A. Y. Smirnov, in <with|font-shape|italic|2nd International
    Workshop on Neutrino Oscillations in Venice (NOVE) December 3-5, 2003,
    Venice, Italy>, published in Venice 2003, Neutrino Oscillations, p. 1;
    H.<nbsp>Minakata and A.Y.<nbsp>Smirnov, Phys. Rev.
    <with|font-series|bold|D70>, 073009 (2004); M.<nbsp>Raidal, Phys. Rev.
    Lett. <with|font-series|bold|93>, 161801 (2004); P.H.<nbsp>Frampton and
    R.N.<nbsp>Mohapatra, JHEP <with|font-series|bold|0501>, 025 (2005);
    N.<nbsp>Li and B.-Q.<nbsp>Ma, Phys. Rev. <with|font-series|bold|D71>,
    097301 (2005); J.<nbsp>Ferrandis and S.<nbsp>Pakvasa, Phys. Rev.
    <with|font-series|bold|D71>, 033004 (2005); S.K.<nbsp>Kang, C.S.<nbsp>Kim
    and J.<nbsp>Lee, Phys. Lett. <with|font-series|bold|B619>, 129 (2005);
    S.<nbsp>Antusch, S.F.<nbsp>King and R.N.<nbsp>Mohapatra, Phys. Lett.
    <with|font-series|bold|B618>, 150 (2005); M.A.<nbsp>Schmidt and
    A.Y.<nbsp>Smirnov, Phys. Rev. <with|font-series|bold|D74>, 113003 (2006);
    F.<nbsp>Plentinger, G.<nbsp>Seidl and W.<nbsp>Winter, Phys. Rev.
    <with|font-series|bold|D76>, 113003 (2007).

    <bibitem|zheng>Y.-J.<nbsp>Zheng, Phys. Rev. <with|font-series|bold|D81>,
    073009 (2010).

    <bibitem|unified>X.-G.<nbsp>He, S.-W.<nbsp>Li and B.-Q.<nbsp>Ma, Phys.
    Rev. <with|font-series|bold|D79>, 073001 (2009).

    <bibitem|jarlskog>C.<nbsp>Jarlskog, Phys. Rev. Lett.
    <with|font-series|bold|55>, 1039 (1985); D.-d.<nbsp>Wu, Phys. Rev. D
    <with|font-series|bold|33>, 860 (1986); O.W.<nbsp>Greenberg, Phys. Rev.
    <with|font-series|bold|D32>, 1841 (1985).

    <bibitem|qinnan>N.<nbsp>Qin and B.-Q.<nbsp>Ma, Phys. lett
    <with|font-series|bold|B695>, 194 (2011).
  </thebibliography>
</body>