<TeXmacs|1.99.7>

<style|<tuple|article|std-latex>>

<\body>
  <\hide-preamble>
    <assign|U|<macro|1|<protect><rule|.1in|.1in>>>

    <new-theorem|theorem|Theorem>

    <new-theorem|acknowledgement|Acknowledgement>

    <new-theorem|algorithm|Algorithm>

    <new-theorem|axiom|Axiom>

    <new-theorem|case|Case>

    <new-theorem|claim|Claim>

    <new-theorem|conclusion|Conclusion>

    <new-theorem|condition|Condition>

    <new-theorem|conjecture|Conjecture>

    <new-theorem|corollary|Corollary>

    <new-theorem|criterion|Criterion>

    <new-theorem|definition|Definition>

    <new-theorem|example|Example>

    <new-theorem|exercise|Exercise>

    <new-theorem|lemma|Lemma>

    <new-theorem|notation|Notation>

    <new-theorem|problem|Problem>

    <new-theorem|proposition|Proposition>

    <new-theorem|remark|Remark>

    <new-theorem|solution|Solution>

    <new-theorem|summary|Summary>

    <assign|render-proof|<macro|1|body|<\surround|<no-indent><with|font-series|bold|<arg|1>.>
    | <rule|0.5em|0.5em>>
      <arg|body>
    </surround>>><assign|proof|<macro|body|<render-proof|Proof|<arg|body>>>>
  </hide-preamble>

  <doc-data|<doc-title|Upper bounds for the error in some interpolation and
  extrapolation designs>|<doc-author|<author-data|<author-name|Michel
  Broniatowski<rsup|<math|1>>,Giorgio Celant<rsup|<math|2>>, Marco Di
  Battista<rsup|<math|2>> , Samuela Leoni-Aubin<rsup|<math|3>>>>>|<doc-title|Upper
  bounds for the error in some interpolation and extrapolation
  designs>|<doc-author|<author-data|<author-name|Michel
  Broniatowski<rsup|<math|1>>,Giorgio Celant<rsup|<math|2>>, Marco Di
  Battista<rsup|<math|2>> , Samuela Leoni-Aubin<rsup|<math|3>><next-line><rsup|<math|1>><with|font-size|0.71|Universit
  Pierre et Marie Curie, LSTA,e-mail:michel.broniatowski@upmc.fr><next-line><rsup|<math|2>><with|font-size|0.71|University
  of Padua, Department of Statistical Sciences,><next-line><with|font-size|0.71|<no-indent>><rsup|<math|3>><with|font-size|0.71|INSA
  Lyon, ICJ, e-mail: samuela.leoni@insa-lyon.fr>>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    This paper deals with probabilistic upper bounds for the error in
    functional estimation defined on some interpolation and extrapolation
    designs, when the function to estimate is supposed to be analytic. The
    error pertaining to the estimate may depend on various factors: the
    frequency of observations on the knots, the position and number of the
    knots, and also on the error committed when approximating the function
    through its Taylor expansion. When the number of observations is fixed,
    then all these parameters are determined by the choice of the design and
    by the choice estimator of the unknown function.

    AMS (2010) Classification: 62K05, 41A5
  </abstract>>

  <no-indent>

  <section|Introduction<vspace|2fn> >

  Consider a function <math|\<varphi\>> defined on some open set
  <math|D\<subset\>\<bbb-R\>> and which can be observed on a compact subset
  <math|S> included in <math|D>. The problem that we consider is the
  estimation of this function through some interpolation or extrapolation
  techniques. This turns out to define a finite set of points
  <math|s<rsub|i>> in a domain <math|<wide|S|~>> included in <math|S> and the
  number of measurement of the function <math|\<varphi\>> at each of these
  points, that is to define a design <math|\<cal-P\>\<assign\><around*|{|<around*|(|s<rsub|i>,n<rsub|i>|)>\<in\>S\<times\>\<bbb-N\>,<nbsp>i=0,...,l,<nbsp><wide|S|~>\<subsetneqq\>S|}>>.
  The points <math|s<rsub|i>> are called the <em|knots>, <math|n<rsub|i>> is
  the frequency of observations at knot <math|s<rsub|i>> and <math|l+1> is
  the number of knots.<no-indent>The choice of the design <math|\<cal-P\>> is
  based on some optimality criterion. For example, we could choose an
  observation scheme that minimize the variance of the estimator of
  <math|\<varphi\>>.

  <no-indent>The choice of <math|\<cal-P\>> has been investigated by many
  authors. Hoel and Levine and Hoel (<cite|10> and <cite|11>) considered the
  case of the extrapolation of a polynomial function with known degree in one
  and two variables. Spruill, in a number of papers (see <cite|17>,
  <cite|18>, <cite|19> and <cite|20>) proposed a technique for the
  (interpolation and extrapolation) estimation of a function and its
  derivatives, when the function is supposed to belong to a Sobolev space,
  Celant (in <cite|4> and <cite|5>) considered the extrapolation of
  quasi-analytic functions and Broniatowski-Celant in <cite|3> studied
  optimal designs for analytic functions through some control of the bias.

  <no-indent>The main defect of any interpolation and extrapolation scheme is
  its extreme sensitivity to the uncertainties pertaining to the values of
  <math|\<varphi\>> on the knots. The largest the number <math|l+1> of knots,
  the more unstable is the estimate. In fact, even when the function
  <math|\<varphi\>> is accurately estimated on the knots, the estimates of
  <math|\<varphi\>> or of one of its derivatives
  <math|\<varphi\><rsup|<around|(|j|)>>> at some point in <math|D> may be
  quite unsatisfactory, due either to a wrong choice of the number of knots
  or to their location. The only case when the error committed while
  estimating the values <math|\<varphi\><around|(|s<rsub|i>|)>> is not
  amplified in the interpolation procedure is the linear case. Therefore, for
  any more envolved case the choice of <math|l> and
  <math|<around|(|s<rsub|i>,n<rsub|i>|)>> must be handled carefully, which
  explains the wide literature devoted to this subject. For example, if we
  estimate <math|\<varphi\><around*|(|v|)>,v\<in\>S*\<diagdown\>*<wide|S|~>>,
  by <math|<wide|\<varphi\><around*|(|s<rsub|k>|)>|^>\<assign\>\<varphi\><around*|(|s<rsub|k>|)>+\<varepsilon\><around*|(|k|)>>,
  where <math|\<varepsilon\><around*|(|k|)>> denotes the estimation error and
  <math|<wide|S|~>> a Tchebycheff set of points <math|S>, we obtain

  <\equation*>
    <around*|\||\<varphi\><around*|(|v|)>-<wide|\<varphi\><around*|(|s<rsub|k>|)>|^>|\|>\<leq\><around*|(|max<rsub|k><around*|\||\<varepsilon\><around*|(|k|)>|\|>|)>*\<Lambda\><rsub|l><around*|(|v,s<rsub|k>,0|)>,
  </equation*>

  where <math|\<Lambda\><rsub|l><around*|(|v,s<rsub|i>,j|)>> is a function
  that depends on <math|<wide|S|~>>, the number of knots and on the order of
  the derivative that we aim to estimate (here <math|0>), and (see <cite|2>
  and <cite|14> )

  <\equation*>
    max<rsub|k=0,...,l> \<Lambda\><rsub|l><around*|(|v,s<rsub|k>,0|)>\<assign\><frac|1|l+1>*<big|sum><rsub|k=0><rsup|l>c*t*g*<around*|(|<frac|2*k+1|4*<around*|(|l+1|)>>*\<pi\>|)>\<sim\><frac|2|\<pi\>>*ln
    <around*|(|l+1|)>*<space|1em><text|when >l\<rightarrow\>\<infty\>.
  </equation*>

  If equidistant knots are used, one gets (see <cite|16>)

  <\equation*>
    max<rsub|k=0,...,l> \<Lambda\><rsub|l><around*|(|v,s<rsub|k>,0|)>\<thicksim\><frac|2<rsup|l+1>|e*l*<around*|(|ln
    l+\<gamma\>|)>>,<space|2em>\<gamma\>=0,577<nbsp><nbsp><text|(Euler-Mascheroni
    constant).>
  </equation*>

  <no-indent>When the bias in the interpolation is zero, as in the case when
  <math|\<varphi\>> is polynomial with known degree, the design is optimized
  with respect to the variance of the interpolated value (see <cite|10> ). In
  the other cases the criterion that is employed is the minimal MSE
  criterion. The minimal MSE criterion allows the estimator to be as accurate
  as possible but it does not yield any information on the
  interpolation/extrapolation error.

  In this paper, we propose a probabilistic tool (based on the concentration
  of measure) in order to control the estimation error. In Section 2 we
  present the model, the design and the estimators. Section 3 deals with
  upper bouns for the error. Concluding remarks are given in Section 4.

  <section|The model, the design and the estimators>

  Consider an unknown real-valued analytic function <math|f> defined on some
  interval <math|D> :

  <align*|<tformat|<table|<row|<cell|f:<nbsp><nbsp>D\<assign\><around*|(|a,b|)>>|<cell|\<rightarrow\>\<bbb-R\>>>|<row|<cell|v>|<cell|\<mapsto\>f<around*|(|v|)>.>>>>>

  <no-indent>We assume that this function is observable on a compact subset
  <math|S> included in <math|D>, <math|S\<assign\><around*|[|<wide*|s|\<bar\>>,<wide|s|\<bar\>>|]>\<subset\>D>,
  and that its derivatives are not observable at any point of <math|D>. Let
  <math|<wide|S|~>\<assign\><around*|{|s<rsub|k>\<in\><wide|S|~>,k=0,...,l|}>>
  be a finite subset of <math|l+1> elements in the set <math|S>. The points
  <math|s<rsub|k>> are called the <em|knots>.

  <no-indent>Observations <math|Y<rsub|i>>, <math|i=1,\<ldots\>,n> are
  generated from the following location-scale model

  <align*|<tformat|<table|<row|<cell|Y<rsub|j><around*|(|s<rsub|k>|)>=>|<cell|f<around*|(|s<rsub|k>|)>+\<sigma\>*E<around*|(|Z<rsub|j>|)>+\<varepsilon\><rsub|j>,>>|<row|<cell|\<varepsilon\><rsub|j>\<assign\>>|<cell|\<sigma\>*Z<rsub|j>-\<sigma\>*E<around*|(|Z<rsub|j>|)>,<space|2em>j=1,...,n<rsub|k>,<nbsp><nbsp>k=0,...,l,>>>>>

  <no-indent>where <math|Z> is a completely specified continuous random
  variable, the location parameter <math|f<around*|(|v|)>> and the scale
  parameter <math|\<sigma\>\<gtr\>0> are unknown parameters.
  <math|E<around*|(|Z|)>,\<varsigma\>> respectively denote the mean and the
  variance of <math|Z>, and <math|n<rsub|k>> is the <em|frequency of
  observations> at knot <math|s<rsub|k>>.

  <no-indent>We assume to observe <math|<around|(|l+1|)>> i.i.d. samples,
  <math|<wide*|Y|\<bar\>><around*|(|k|)>\<assign\><around*|(|Y<rsub|1><around*|(|n<rsub|k>|)>,...,Y<rsub|n<rsub|k>><around*|(|n<rsub|k>|)>|)>,k=0,...,l>,
  and <math|Y<rsub|i><around*|(|n<rsub|k>|)>> i.i.d.
  <math|Y<rsub|1><around*|(|n<rsub|k>|)>>, for all <math|i\<neq\>k>,
  <math|i=0,\<ldots\>,l>.

  <no-indent>The aim is to estimate a derivative of <math|f<around*|(|v|)>>,
  <math|f<rsup|<around|(|d|)>><around|(|v|)>>, <math|d\<in\>\<bbb-N\>>, at a
  point <math|v\<in\><around*|(|a,<wide|s|\<bar\>>|)>>.

  <no-indent>Let <math|\<varphi\><around*|(|v|)>\<assign\>f<around*|(|v|)>+\<sigma\>*E<around*|(|Z|)>>,
  and consider the Lagrange polynomial

  <\equation*>
    L<rsub|s<rsub|k>><around*|(|v|)>\<assign\><big|prod><rsub|j\<neq\>k,j=0><rsup|l><frac|v-s<rsub|j>|s<rsub|k>-s<rsub|j>>.
  </equation*>

  <no-indent>We are interested in interpolating (or extrapolating) some
  derivatives of <math|\<varphi\>>, <math|\<varphi\><rsup|<around|(|d|)>>>,
  with <math|d\<in\>\<bbb-N\>>,

  <\equation*>
    \<cal-L\><rsub|l><around*|(|\<varphi\><rsup|<around*|(|d|)>>|)><around*|(|v|)>\<assign\><big|sum><rsub|k=0><rsup|l>\<varphi\><around*|(|s<rsub|k>|)>*L<rsub|s<rsub|k>><rsup|<around*|(|d|)>><around*|(|v|)>.
  </equation*>

  <no-indent>The domain of extrapolation is denoted
  <math|U\<assign\>D*\<diagdown\>*S>. It is convenient to define a generic
  point <math|v\<in\>D> stating that it is an <em|observed point> if it is a
  knot, an <em|interpolation point> if <math|v\<in\>S> and an
  <em|extrapolation point> if <math|v\<in\>U>.

  <no-indent>For all <math|d\<in\>\<bbb-N\>>, for any <math|v\<in\>S>, the
  Lagrange interpolation scheme converges for the function
  <math|\<varphi\><rsup|<around|(|d|)>>>, that is, for
  <math|l\<to\>\<infty\>>,

  <\equation*>
    \<cal-L\><rsub|l><around*|(|\<varphi\><rsup|<around*|(|d|)>>|)><around*|(|s|)>\<rightarrow\>\<varphi\><rsup|<around*|(|d|)>><around*|(|s|)>,<space|1em>\<forall\>s\<in\>S.
  </equation*>

  <no-indent>Interpolating the derivative
  <math|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>> at a
  point <math|s<rsup|\<ast\>>\<in\>S> opportunely chosen, a Taylor expansion
  with order <math|<around|(|m-1|)>> of <math|\<varphi\><rsup|<around*|(|d|)>><around|(|v|)>>
  at point <math|v> from <math|s<rsup|\<ast\>>> gives

  <\equation*>
    T<rsub|\<varphi\><rsup|<around*|(|d|)>>,m,l><around*|(|v|)>\<assign\><big|sum><rsub|i=0><rsup|m-1><frac|<around*|(|v-s<rsup|\<ast\>>|)>|i!><rsup|i>*\<cal-L\><rsub|l><around*|(|\<varphi\><rsup|<around*|(|d+i|)>>|)><around*|(|s<rsup|\<ast\>>|)>,<space|1em>s<rsup|\<ast\>>\<in\>S,
  </equation*>

  <no-indent>and we have

  <\equation*>
    lim<rsub|m\<rightarrow\>\<infty\>> lim<rsub|l\<rightarrow\>\<infty\>>
    T<rsub|\<varphi\><rsup|<around*|(|d|)>>,m,l><around*|(|v|)>=\<varphi\><rsup|<around*|(|d|)>><around*|(|v|)>,<space|1em>\<forall\>v\<in\>D.
  </equation*>

  <no-indent>When <math|\<varphi\><rsup|<around|(|d|)>>\<in\>\<cal-C\><rsup|\<alpha\>><around|(|D|)>>,
  <math|\<forall\>\<alpha\>>, <math|l\<geq\>2*\<alpha\>-3>, the upper bound
  for the error of approximation is given in <cite|1>,

  <\equation*>
    E<rsub|t>\<assign\>sup<rsub|v\<in\>D><around*|\||\<varphi\><rsup|<around*|(|d|)>><around*|(|v|)>-T<rsub|\<varphi\><rsup|<around*|(|d|)>>,m,l><around*|(|v|)>|\|>\<leq\>M<around|(|m,l,\<alpha\>|)>,
  </equation*>

  <no-indent>where <math|M<around|(|m,l,\<alpha\>|)>=A<around*|(|\<alpha\>,l|)>+B<around*|(|m|)>>,

  <\equation*>
    A<around*|(|\<alpha\>,l|)>\<assign\>K<around*|(|\<alpha\>,l|)>*<big|sum><rsub|i=0><rsup|m-1><around*|(|sup<rsub|s\<in\>S><around*|\||\<varphi\><rsup|<around*|(|d+i+\<alpha\>|)>><around*|(|s|)>|\|><frac|1|i!>*sup<rsub|v\<in\>U><around*|\||v-s<rsup|\<ast\>>|\|><rsup|i>|)>,
  </equation*>

  <\equation*>
    K<around*|(|\<alpha\>,l|)>\<assign\><around*|(|<frac|\<pi\>|2*<around*|(|1+l|)>>*<around*|(|<wide|s|\<bar\>>-<wide*|s|\<bar\>>|)>|)><rsup|\<alpha\>>*<around*|(|9+<frac|4|\<pi\>>*ln
    <around*|(|1+l|)>|)>,
  </equation*>

  <\equation*>
    <text|and ><space|1em>B<around*|(|m|)>\<assign\>sup<rsub|v\<in\><around*|(|a,<wide|s|\<bar\>>|)>><around*|(|<frac|<around*|\||u-s<rsup|\<ast\>>|\|><rsup|m><around*|\||\<varphi\><rsup|<around*|(|d+\<alpha\>|)>><around*|(|v|)>|\|>|m!>|)>.
  </equation*>

  <no-indent>The optimal design writes <math|<around*|{|<around*|(|n<rsub|k>,s<rsub|k>|)>\<in\><around*|(|\<bbb-N\>\<setminus\><around|{|0|}>|)><rsup|l+1>\<times\>\<bbb-R\><rsup|l+1>,<nbsp>n\<assign\><big|sum><rsub|k=0><rsup|l>n<rsub|k>,<nbsp>n<text|fixed>|}>>,
  where <math|n> is the total number of experiments and the
  <math|<around|(|l+1|)>> knots are defined by

  <\equation*>
    s<rsub|k>\<assign\><frac|<wide|s|\<bar\>>+<wide*|s|\<bar\>>|2>-<frac|<wide|s|\<bar\>>-<wide*|s|\<bar\>>|2>*cos
    <frac|2*k-1|2*l+2>*\<pi\>,<space|2em>k=0,\<ldots\>,l,
  </equation*>

  with <math|n<rsub|k>\<assign\><around*|[|<frac|n*<sqrt|P<rsub|k>>|<big|sum><rsub|k=0><rsup|l><sqrt|P<rsub|k>>>|]>>,
  <math|<around*|[|.|]>> denoting the integer part function, and (see
  <cite|3> for details)

  <\equation*>
    P<rsub|k>\<assign\><around*|\||<big|sum><rsub|\<beta\>=0><rsup|m><big|sum><rsub|\<alpha\>=0><rsup|m><frac|<around*|(|u-s|)><rsup|\<alpha\>+\<beta\>>|\<alpha\>!\<beta\>!>*L<rsub|s<rsub|k>><rsup|<around*|(|\<alpha\>|)>><around*|(|s|)>*L<rsub|s<rsub|k>><rsup|<around*|(|\<beta\>|)>><around*|(|s|)>|\|>,<space|2em>k=0,...,l.
  </equation*>

  <no-indent>The function <math|\<varphi\>> cannot be observed exactly at the
  knots.<no-indent>Let <math|<wide|\<varphi\><around*|(|s<rsub|k>|)>|^>>
  denote the least squares estimate of <math|\<varphi\><around*|(|s<rsub|k>|)>>
  at the knot <math|s<rsub|k>> and

  <\equation>
    <label|lagsch>\<cal-L\><rsub|l><around*|(|<wide|\<varphi\><rsup|<around*|(|d+i|)>>|^>|)><around*|(|v|)>\<assign\><big|sum><rsub|k=0><rsup|l><wide|\<varphi\><around*|(|s<rsub|k>|)>|^>L<rsub|s<rsub|k>><rsup|<around*|(|d+i|)>><around*|(|v|)>.
  </equation>

  We estimate the <math|d->th derivative of <math|\<varphi\><around*|(|v|)>>
  at <math|v\<in\>D> as follows

  <\equation*>
    <wide|T|^><rsub|\<varphi\><rsup|<around*|(|d|)>>,m,l><around*|(|v|)>\<assign\><big|sum><rsub|i=0><rsup|m-1><frac|<around*|(|v-s<rsup|\<ast\>>|)>|i!><rsup|i>*\<cal-L\><rsub|l><around*|(|<wide|\<varphi\><rsup|<around*|(|d+i|)>>|^>|)><around*|(|s<rsup|\<ast\>>|)>,<space|2em>s<rsup|\<ast\>>\<in\>S.
  </equation*>

  <no-indent>The knots <math|s<rsub|k>> are chosen in order to minimize the
  variance of <math|<wide|T|^><rsub|\<varphi\><rsup|<around*|(|d|)>>,m,l><around*|(|v|)>>
  and it holds

  <\equation*>
    lim<rsub|m\<rightarrow\>\<infty\>> lim<rsub|l\<rightarrow\>\<infty\>> lim
    <rsub|min<rsub|k=0,\<ldots\>,l><around*|(|n<rsub|k>|)>\<rightarrow\>\<infty\>><wide|T|^><rsub|\<varphi\><rsup|<around*|(|d|)>>,m,l><around*|(|v|)>=\<varphi\><rsup|<around*|(|d|)>><around*|(|v|)>,<space|2em>\<forall\>v\<in\>D.
  </equation*>

  <math|<wide|T|^><rsub|\<varphi\><rsup|<around*|(|d|)>>,m,l><around*|(|v|)>>
  is an extrapolation estimator when <math|v\<in\>U> and an interpolation
  estimator when <math|v\<in\>S>.

  <no-indent>For a fixed degree <math|l> of the Lagrange scheme
  (<reference|lagsch>), the total error committed while substituting
  <math|\<varphi\><rsup|<around*|(|d|)>><around*|(|v|)>> by
  <math|<wide|T|^><rsub|\<varphi\><rsup|<around*|(|d|)>>,m,l><around*|(|v|)>>
  writes

  <\equation*>
    E<rsub|T*o*t><around*|(|\<varphi\><rsup|<around*|(|d|)>><around*|(|v|)>|)>\<assign\>\<varphi\><rsup|<around*|(|d|)>><around*|(|v|)>-<wide|T|^><rsub|\<varphi\><rsup|<around*|(|d|)>>,m,l><around*|(|v|)>.
  </equation*>

  <no-indent>For the interpolation error concerning
  <math|\<varphi\><rsup|<around*|(|i+d|)>>>, we have the following result
  presented in <cite|6>, p.293 : if <math|\<varphi\><rsup|<around*|(|i+d|)>>\<in\>\<cal-C\><rsup|\<alpha\>><around*|(|S|)>>,
  <math|\<forall\>\<alpha\>>, <math|l\<geq\>2*\<alpha\>-3>, then

  <\equation*>
    sup<rsub|s\<in\>S><around*|\||\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s|)>-\<cal-L\><rsub|l><around*|(|\<varphi\><rsup|<around*|(|d+i|)>>|)><around*|(|s|)>|\|>\<leq\>M<rsub|1>\<assign\>K<around*|(|\<alpha\>,l|)>*sup<rsub|s\<in\>S><around*|\||\<varphi\><rsup|<around*|(|d+i+\<alpha\>|)>><around*|(|s|)>|\|>.
  </equation*>

  <no-indent>This error depends on the very choice of the knots and is
  controlled through a tuning of <math|l>.

  <no-indent>The error due to the Taylor expansion of order
  <math|<around*|(|m-1|)>>

  <\equation*>
    \<varphi\><rsup|<around*|(|d|)>><around*|(|v|)>-<big|sum><rsub|i=0><rsup|m-1><frac|<around*|(|v-s<rsup|\<ast\>>|)>|i!><rsup|i>*\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>
  </equation*>

  <no-indent>depends on <math|s<rsup|\<ast\>>>, it is a truncation error and
  it can be controlled through a tuning of <math|m>.

  <no-indent>Let <math|<wide|\<varphi\><around|(|s<rsub|k>|)>|^>> be an
  estimate of <math|\<varphi\><around|(|s<rsub|k>|)>> on the knot
  <math|s<rsub|k>> and

  <\equation*>
    \<varepsilon\><around*|(|k|)>\<assign\>\<varphi\><around*|(|s<rsub|k>|)>-<wide|\<varphi\><around*|(|s<rsub|k>|)>|^>,<space|2em>k=0,...,l
  </equation*>

  <no-indent>denote the error pertaining to
  <math|\<varphi\><around|(|s<rsub|k>|)>> due to this estimation.
  <math|\<varepsilon\><around*|(|k|)>> clearly depends on <math|n<rsub|k>>,
  the frequency of observations at knot <math|s<rsub|k>>.

  <no-indent>Finally, when <math|n> is fixed, the error committed while
  extrapolating depends on the design <math|<around|{|<around|(|n<rsub|k>,s<rsub|k>|)>\<in\><around*|(|\<bbb-N\>\<setminus\><around|{|0|}>|)><rsup|l+1>\<times\>\<bbb-R\><rsup|l+1>,<nbsp>k=0,\<ldots\>,l,<nbsp>n=<big|sum><rsub|k=0><rsup|l>n<rsub|k>|}>>,
  on <math|m> and on <math|l>.

  <no-indent>Without loss of generality, we will assume <math|\<sigma\>=1>.
  In this case we have <math|<wide|\<varphi\><around*|(|s<rsub|k>|)>|^>>
  =<math|<wide|Y|\<bar\>><around*|(|s<rsub|k>|)>\<assign\><frac|<big|sum><rsub|j=1><rsup|n<rsub|k>>Y<rsub|j><around*|(|k|)>|n<rsub|k>>>.
  The general case when <math|\<sigma\>> is unknown is described in <cite|3>.

  <no-indent>In the next Section we will provide upper bounds for the errors
  in order to control them.

  <no-indent>Since <math|\<varphi\>> is supposed to be an analytic function,
  we can consider the extrapolation as an analytic continuation of the
  function out of the set <math|S> obtained by a Taylor expansion from an
  opportunely chosen point <math|s<rsup|\<ast\>>> in <math|S>. So, the
  extrapolation error will depend on the order of the Taylor expansion and on
  the precision in the knowledge of the derivatives of the function at
  <math|s<rsup|\<ast\>>>. This precision is given by the interpolation error
  and by the estimation errors on the knots. The analyticity assumption also
  implies that the interpolation error will quickly converge to zero. Indeed,
  for all integer <math|r>, the following result holds:

  <\equation*>
    lim<rsub|l\<rightarrow\>\<infty\>> l<rsup|r>*sup<rsub|s\<in\>S><around*|\||\<varphi\><rsup|<around*|(|j|)>><around*|(|s|)>-<big|sum><rsub|k=0><rsup|l>L<rsub|s<rsub|k>><rsup|<around*|(|j|)>><around*|(|s|)>*\<varphi\><around*|(|s<rsub|k>|)>|\|>=0.
  </equation*>

  <no-indent>We remark that the instability of the interpolation and
  extrapolation schemes discussed by Runge (1901) can be avoided if the
  chosen knots form a Tchebycheff set of points in <math|S>, or if they form
  a Feteke set of points in <math|S>, or by using splines.

  <no-indent>Note that in all the works previously quoted the function is
  supposed to be polynomial with known degree (in <cite|10> and <cite|11>),
  to belongs to a Sobolev space (see <cite|17>, <cite|18>, <cite|19> and
  <cite|20>), or to be quasi analytic (in <cite|4> and <cite|5>), or analytic
  (in <cite|3>). Moreover, <math|<wide|S|~>> is chosen as a Tchebycheff set
  of points in <math|S> .

  <no-indent>Bernstein in <cite|2> affirmed that polynomials of low degree
  are good approximations for analytic functions. In the case of the
  Broniatowski-Celant design (<cite|3>), the double approximation to approach
  <math|\<varphi\>> allows to choose any subset of <math|S> as possible
  interpolation set. So, if the unknown function is supposed to be analytic,
  then we can choose a small interpolation set in order to obtain a small
  interpolation error.

  <section|Upper bounds and control of the error>

  The extrapolation error depends on three kinds of errors: truncation error,
  interpolation error and error of estimation of the function on the knots.
  In order to control the extrapolation error, we split an upper bound for it
  in a sum of three terms, each term depending only on one of the three kinds
  of errors.

  <no-indent>In the sequel, we will distinguish two cases: in the first case,
  we suppose that the observed random variable <math|Y> is bounded, in the
  second case <math|Y> is supposed to be a random variable with unbounded
  support. We suppose that the support is known.

  <subsection|<vspace|2fn>Case 1: <math|Y> is a bounded random variable>

  If <math|\<tau\><rsub|1>,\<tau\><rsub|2>> (assumed known) are such that
  <math|Pr <around*|(|\<tau\><rsub|1>\<leq\>Y\<leq\>\<tau\><rsub|2>|)>=1>, it
  holds <math|<around*|\||\<varphi\><around*|(|v|)>|\|>\<leq\>R>, where
  <math|R\<assign\>max <around*|{|<around*|\||\<tau\><rsub|1>|\|>,<around*|\||\<tau\><rsub|2>|\|>|}>>.
  Indeed, <math|E<around*|(|Y|)>=\<varphi\>\<in\><around*|[|-R,R|]>>. Let

  <\equation*>
    \<varepsilon\><around*|(|k|)>\<assign\><frac|<big|sum><rsub|j=1><rsup|n<rsub|k>>Y<rsub|j><around*|(|k|)>|n<rsub|k>>-\<varphi\><around*|(|s<rsub|k>|)>.
  </equation*>

  <no-indent>The variables <math|Y<rsub|j><around*|(|k|)>,\<forall\>j=1,...,n<rsub|k>,\<forall\>k=0,..,l>,
  are i.i.d., with the same bounded support and for all
  <math|k,E<around*|(|Y<rsub|j><around*|(|k|)>|)>=>
  <math|\<varphi\><around*|(|s<rsub|k>|)>>, hence we can apply the
  Hoeffding's inequality (in <cite|9>):

  <\equation*>
    Pr <around*|{|<around*|\||\<varepsilon\><around*|(|k|)>|\|>\<geq\>\<rho\>|}>\<leq\>2*exp
    <around*|(|-<frac|2*\<rho\><rsup|2>*n<rsub|k>|<around*|(|\<tau\><rsub|2>-\<tau\><rsub|1>|)><rsup|2>>|)>.
  </equation*>

  <no-indent>In Proposition 1, we give an upper bound for the extrapolation
  error denoted by <math|E<rsub|e*x*t>>. This bound is the sum of the three
  terms, <math|M<rsub|T*a*y*l*o*r>>, controlling the error associated to the
  truncation of the Taylor expansion which defines
  <math|\<varphi\><rsup|<around*|(|d|)>>>, <math|M<rsub|i*n*t*e*r*p>>,
  controlling the interpolation error and <math|M<rsub|e*s*t>>, describing
  the estimation error on the knots.

  <\proposition>
    For all <math|\<alpha\>\<in\>\<bbb-N\>\<setminus\><around|{|0|}>>, if
    <math|\<varphi\><rsup|<around*|(|i+d|)>>\<in\>\<cal-C\><rsup|\<alpha\>><around*|(|a,b|)>>,
    <math|l\<geq\>2*\<alpha\>-3>, then, <math|\<forall\>u\<in\>U>,
    <math|<around*|\||E<rsub|e*x*t><around*|(|u|)>|\|>\<leq\>M<rsub|T*a*y*l*o*r>+M<rsub|i*n*t*e*r*p>+M<rsub|e*s*t>>,
    where

    <\equation*>
      M<rsub|T*a*y*l*o*r>\<assign\>R<frac|<around*|(|d+m|)>!|m!><around*|(|<frac|s<rsup|\<ast\>>-u|b-a>|)><rsup|m><frac|1|<around*|(|b-a|)><rsup|d>>,
    </equation*>

    <\equation*>
      K<around*|(|l,\<alpha\>|)>\<assign\><around*|(|9+<frac|4|\<pi\>>*ln
      <around*|(|1+l|)>|)><around*|(|<frac|\<pi\>|2*<around*|(|1+l|)>>|)><rsup|\<alpha\>>,
    </equation*>

    <\equation*>
      M<rsub|i*n*t*e*r*p>\<assign\>K<around*|(|l,\<alpha\>|)><frac|R|<around*|(|<wide|s|\<bar\>>-<wide*|s|\<bar\>>|)><rsup|d+\<alpha\>>>*<big|sum><rsub|i=0><rsup|m-1><around*|(|<frac|s<rsup|\<ast\>>-u|<wide|s|\<bar\>>-<wide*|s|\<bar\>>>|)><rsup|i><frac|<around*|(|d+i+\<alpha\>|)>!|i!>,
    </equation*>

    <\equation*>
      \<Lambda\><around*|(|l,m|)>\<assign\><big|sum><rsub|i=0><rsup|m-1><big|sum><rsub|k=0><rsup|l><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!><around*|\||L<rsub|s<rsub|k>><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>|\|>,
    </equation*>

    <\equation*>
      M<rsub|e*s*t>\<assign\>\<Lambda\><around*|(|l,m|)><around*|(|max<rsub|k=0,...,l><around*|\||\<varepsilon\><around*|(|k|)>|\|>|)>.
    </equation*>
  </proposition>

  <\proof>
    \ By using the Cauchy's Theorem on the derivatives of the analytic
    functions, we obtain

    <\equation*>
      <around*|\||\<varphi\><rsup|<around*|(|d|)>><around*|(|u|)>-<wide|\<varphi\><rsup|<around*|(|d|)>><around*|(|u|)>|^>|\|>=<around*|\||\<varphi\><rsup|<around*|(|d|)>><around*|(|u|)>+<big|sum><rsub|i=0><rsup|m-1><frac|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>|i!>*<around*|(|u-s<rsup|\<ast\>>|)><rsup|i>-<big|sum><rsub|i=0><rsup|m-1><frac|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>|i!>*<around*|(|u-s<rsup|\<ast\>>|)><rsup|i>-<wide|\<varphi\><rsup|<around*|(|d|)>><around*|(|u|)>|^>|\|>
    </equation*>

    <\equation*>
      \<leq\><around*|\||\<varphi\><rsup|<around*|(|d|)>><around*|(|u|)>-<big|sum><rsub|i=0><rsup|m-1><frac|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>|i!>*<around*|(|u-s<rsup|\<ast\>>|)><rsup|i>|\|>+<around*|\||<big|sum><rsub|i=0><rsup|m-1><frac|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>|i!>*<around*|(|u-s<rsup|\<ast\>>|)><rsup|i>-<wide|\<varphi\><rsup|<around*|(|d|)>><around*|(|u|)>|^>|\|>
    </equation*>

    <\equation*>
      \<leq\><frac|sup<rsub|v\<in\>U><around*|\||\<varphi\><rsup|<around*|(|d+m|)>><around*|(|v|)>|\|>|m!>*<around*|(|s<rsup|\<ast\>>-u|)><rsup|m>+<around*|\||<big|sum><rsub|i=0><rsup|m-1><frac|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>|i!>*<around*|(|u-s<rsup|\<ast\>>|)><rsup|i>-<big|sum><rsub|i=0><rsup|m-1><frac|<wide|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>|^>|i!>*<around*|(|u-s<rsup|\<ast\>>|)><rsup|i>|\|>
    </equation*>

    <\equation*>
      \<leq\><frac|R*<around*|(|m+d|)>!|<around*|(|b-a|)><rsup|d>*m!><around*|(|<frac|s<rsup|\<ast\>>-u|b-a>|)><rsup|m>+<around*|\||<big|sum><rsub|i=0><rsup|m-1><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!>*<around*|(|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>-<wide|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>|^>|)>|\|>
    </equation*>

    <\equation*>
      \<leq\><frac|R*<around*|(|m+d|)>!|<around*|(|b-a|)><rsup|d>*m!><around*|(|<frac|s<rsup|\<ast\>>-u|b-a>|)><rsup|m>+<big|sum><rsub|i=0><rsup|m-1><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!>*<around*|\||\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>-<wide|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>|^>|\|>
    </equation*>

    <\equation*>
      \<leq\>M<rsub|T*a*y*l*o*r>+<big|sum>

      <rsub|i=0><rsup|m-1><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!>

      <\around*|\|>
        <array|c|c|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>-<big|sum><rsub|k=0><rsup|l>L<rsub|s<rsub|k>><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>*\<varphi\><around*|(|s<rsub|k>|)><next-line>+<big|sum><rsub|k=0><rsup|l>L<rsub|s<rsub|k>><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>*\<varphi\><around*|(|s<rsub|k>|)>-<wide|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>|^>>
      </around*|\|>
    </equation*>

    <align*|<tformat|<table|<row|<cell|>|<cell|\<leq\>M<rsub|T*a*y*l*o*r>+<big|sum><rsub|i=0><rsup|m-1><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!>*<around*|\||\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>-<big|sum><rsub|k=0><rsup|l>L<rsub|s<rsub|k>><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>*\<varphi\><around*|(|s<rsub|k>|)>|\|>+>>|<row|<cell|>|<cell|<big|sum><rsub|i=0><rsup|m-1><big|sum><rsub|k=0><rsup|l><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!>*L<rsub|s<rsub|k>><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>*<around*|\||\<varphi\><around*|(|s<rsub|k>|)>-<wide|Y|\<bar\>><around*|(|k|)>|\|>>>>>>

    <align*|<tformat|<table|<row|<cell|>|<cell|\<leq\>M<rsub|T*a*y*l*o*r>+<big|sum><rsub|i=0><rsup|m-1><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!>*K<around*|(|l,\<alpha\>|)><around*|(|sup<rsub|s\<in\>S><around*|\||\<varphi\><rsup|<around*|(|d+i+\<alpha\>|)>><around*|(|s|)>|\|>|)>>>|<row|<cell|>|<cell|+<big|sum><rsub|i=0><rsup|m-1><big|sum><rsub|k=0><rsup|l><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!>*L<rsub|s<rsub|k>><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>*<around*|\||\<varphi\><around*|(|s<rsub|k>|)>-<wide|Y|\<bar\>><around*|(|k|)>|\|>>>>>>

    <align*|<tformat|<table|<row|<cell|>|<cell|\<leq\>M<rsub|T*a*y*l*o*r>+<frac|R|<around*|(|<wide|s|\<bar\>>-<wide*|s|\<bar\>>|)><rsup|d+\<alpha\>>>*<big|sum><rsub|i=0><rsup|m-1><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!>*K<around*|(|l,\<alpha\>|)><frac|<around*|(|d+i+\<alpha\>|)>!|<around*|(|<wide|s|\<bar\>>-<wide*|s|\<bar\>>|)><rsup|i>>>>|<row|<cell|>|<cell|+<big|sum><rsub|i=0><rsup|m-1><big|sum><rsub|k=0><rsup|l><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!>*L<rsub|s<rsub|k>><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>*<around*|\||\<varphi\><around*|(|s<rsub|k>|)>-<wide|Y|\<bar\>><around*|(|k|)>|\|>>>>>>

    <\equation*>
      \<leq\>M<rsub|T*a*y*l*o*r>+M<rsub|i*n*t*e*r*p>+<big|sum><rsub|i=0><rsup|m-1><big|sum><rsub|k=0><rsup|l><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!>*L<rsub|s<rsub|k>><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>*<around*|\||\<varphi\><around*|(|s<rsub|k>|)>-<wide|Y|\<bar\>><around*|(|k|)>|\|>
    </equation*>

    <align*|<tformat|<table|<row|<cell|>|<cell|\<leq\>M<rsub|T*a*y*l*o*r>+M<rsub|i*n*t*e*r*p>+<around*|(|max<rsub|k=0,...,l><around*|\||\<varepsilon\><around*|(|k|)>|\|>|)>*<big|sum><rsub|i=0><rsup|m-1><big|sum><rsub|k=0><rsup|l><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!><around*|\||L<rsub|s<rsub|k>><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>|\|>>>|<row|<cell|>|<cell|=M<rsub|T*a*y*l*o*r>+M<rsub|i*n*t*e*r*p>+M<rsub|e*s*t>.>>>>>
  </proof>

  <no-indent>Proposition 2 yields the smallest integer such that the error of
  estimation is not greater than a chosen threshold with a fixed probability.

  <\proposition>
    <math|\<forall\>\<eta\>\<in\><around*|[|0,1|]>,\<forall\>\<rho\>\<in\>\<bbb-R\><rsup|+>,\<exists\>n\<in\>\<bbb-N\>>
    such that

    <\equation*>
      P*r*<around*|(|max<rsub|k=0,...,l><around*|\||\<varepsilon\><around*|(|k|)>|\|>\<geq\><frac|\<rho\>|\<Lambda\><around*|(|l,m|)>>|)>\<leq\>\<eta\>.
    </equation*>
  </proposition>

  <\proof>
    \ If, <math|\<forall\>k> <math|<around*|\||\<varepsilon\><around*|(|k|)>|\|>\<geq\><frac|\<rho\>|\<Lambda\><around*|(|l,m|)>>>,
    then <math|max<rsub|k=0,...,l><around*|\||\<varepsilon\><around*|(|k|)>|\|>\<geq\><frac|\<rho\>|\<Lambda\><around*|(|l,m|)>>>.
    We have

    <\equation*>
      Pr <around*|(|max<rsub|k=0,...,l><around*|\||\<varepsilon\><around*|(|k|)>|\|>\<geq\><frac|\<rho\>|\<Lambda\><around*|(|l,m|)>>|)>\<leq\><big|prod><rsub|k=0><rsup|l>Pr
      <around*|(|<around*|\||\<varepsilon\><around*|(|k|)>|\|>\<geq\><frac|\<rho\>|\<Lambda\><around*|(|l,m|)>>|)>\<leq\><big|prod><rsub|k=0><rsup|l>2*exp
      <around*|(|-<frac|2*\<rho\><rsup|2>|<around*|(|\<Lambda\><around*|(|l,m|)>|)><rsup|2>>*n<rsub|k>|)>.
    </equation*>

    <no-indent>So, we can choose

    <\equation*>
      n<rsup|\<ast\>>=<around*|[|<frac|<around*|(|l+1|)>*ln 2-ln
      \<eta\>|2><around*|(|<frac|\<Lambda\><around*|(|l,m|)>*<around*|(|\<tau\><rsub|2>-\<tau\><rsub|1>|)>|\<rho\>>|)><rsup|2>|]>.
    </equation*>
  </proof>

  <no-indent>Proposition 3 gives an upper bound for the extrapolation error
  that depends on <math|<around*|(|l,m,n|)>>. We recall that the number of
  knots <math|l+1> controls the interpolation error, <math|m> denotes the
  number of terms used in the Taylor expansion for
  <math|\<varphi\><rsup|<around*|(|d|)>>> and <math|n> is the total number of
  observations used to estimate <math|\<varphi\><around*|(|s<rsub|k>|)>,k=0,..,l>.
  Hence <math|n> controls the total estimation error.

  <\proposition>
    With the same hypotheses and notations, we have that

    <\equation*>
      \<forall\><around*|(|\<rho\><rsub|m>,\<rho\><rsub|l>,\<rho\><rsub|n>|)>\<in\>\<bbb-R\><around|(|\<bbb-R\><rsup|+>|)><rsup|3>,<space|1em><around*|\||E<rsub|e*x*t><around*|(|u|)>|\|>\<leq\>\<rho\><rsub|m>+\<rho\><rsub|l>+\<rho\><rsub|n>
    </equation*>

    <no-indent>with probability <math|\<eta\>>. <math|\<eta\>> depends on the
    choice of <math|<around*|(|\<rho\><rsub|m>,\<rho\><rsub|l>,\<rho\><rsub|n>|)>>,
    which depends on <math|<around*|(|m,l,n|)>>.
  </proposition>

  <\proof>
    \ When <math|<around*|(|\<rho\><rsub|m>,\<rho\><rsub|l>|)>> is fixed , we
    can choose <math|<around*|(|m,l|)>> as the solution of the system:

    <\equation*>
      <around*|(|M<rsub|T*a*y*l*o*r>,M<rsub|i*n*t*e*r*p>|)>=<around*|(|\<rho\><rsub|m>,\<rho\><rsub|l>|)>.
    </equation*>

    <no-indent>We end the proof by taking
    <math|\<rho\><rsub|n>=<frac|\<rho\>|\<Lambda\><around*|(|l,m|)>>> and
    <math|n=n<rsup|\<ast\>>>.
  </proof>

  <no-indent>In the case of the estimation of
  <math|\<varphi\><around*|(|u|)>> (i.e., when <math|d=0>) we obtain for the
  couple <math|<around*|(|m,n|)>> the explicit solution

  <\equation*>
    m=<frac|ln \<rho\><rsub|m>-ln R|ln <around*|(|s<rsup|\<ast\>>-u|)>-ln
    <around*|(|b-a|)>>,
  </equation*>

  <\equation*>
    n=<around*|[|<frac|<around*|(|l+1|)>*ln 2-ln
    \<eta\>|2><around*|(|<frac|\<Lambda\><around*|(|l|)>*<around*|(|\<tau\><rsub|2>-\<tau\><rsub|1>|)>|\<rho\>>|)><rsup|2>|]>,\<Lambda\><around*|(|l|)>=<big|sum><rsub|i=0><rsup|m-1><big|sum><rsub|k=0><rsup|l><frac|<around*|(|s<rsup|\<ast\>>-u|)><rsup|i>|i!><around*|\||L<rsub|s<rsub|k>><rsup|<around*|(|i|)>><around*|(|s<rsup|\<ast\>>|)>|\|>.
  </equation*>

  <no-indent>When <math|l\<geq\>2*\<alpha\>-3>, <math|l> is the solution of
  the equation

  <\equation*>
    \<rho\><rsub|l>=<around*|(|9+<frac|4|\<pi\>>*ln
    <around*|(|1+l|)>|)><around*|(|<frac|\<pi\>|2*<around*|(|1+l|)>>|)><rsup|\<alpha\>><frac|R|<around*|(|<wide|s|\<bar\>>-<wide*|s|\<bar\>>|)><rsup|\<alpha\>>>*<big|sum><rsub|i=0><rsup|m-1><around*|(|<frac|s<rsup|\<ast\>>-u|<wide|s|\<bar\>>-<wide*|s|\<bar\>>>|)><rsup|i><frac|<around*|(|i+\<alpha\>|)>!|i!>.
  </equation*>

  <no-indent>Theorem 4, due to Markoff, provides an uniform bound for the
  derivatives of a Lagrange polynomial.

  <\theorem>
    (Markoff) Let <math|P<rsub|l><around*|(|s|)>\<assign\><big|sum><rsub|j>a<rsub|j>*s<rsup|j>>
    be a polynomial with real coefficients and degree <math|l>. If
    <math|sup<rsub|s\<in\>S><around*|\||P<rsub|l><around*|(|s|)>|\|>\<leq\>W>,
    then for all <math|s> in <math|i*n*t*S> and for all <math|l> in
    <math|\<bbb-N\>>, it holds

    <\equation*>
      <around*|\||P<rsub|l><rsup|<around*|(|j|)>><around*|(|s|)>|\|>\<leq\><frac|l<rsup|2>*<around*|(|l<rsup|2>-1|)>...*<around*|(|l<rsup|2>-<around*|(|j-1|)><rsup|2>|)>|<around*|(|2*j-1|)>!!><around*|(|<frac|2|<around*|(|<wide|s|\<bar\>>-<wide*|s|\<bar\>>|)>>|)><rsup|j>*W.
    </equation*>
  </theorem>

  <no-indent>When applied to the elementary Lagrange polynomial, it is
  readily checked that <math|W=\<pi\>>. Indeed,

  <\equation*>
    <around*|\||L<rsub|s<rsub|k>><around*|(|s|)>|\|>=<around*|\||<frac|<around*|(|-1|)><rsup|k>*sin
    <around*|(|<frac|2*k-1|2*l+2>*\<pi\>|)>|l+1>*<frac|cos
    <around*|(|<around*|(|l+1|)>*\<theta\>|)>|cos \<theta\>-cos
    <around*|(|<frac|2*k-1|2*l+2>*\<pi\>|)>>|\|>\<leq\>
  </equation*>

  <\equation*>
    \<leq\><frac|<around*|\||sin <around*|(|<frac|2*k-1|2*l+2>*\<pi\>|)>|\|>|l+1>*<frac|<around*|\||cos
    <around*|(|<around*|(|l+1|)>*\<theta\>|)>|\|>|<around*|\||cos
    \<theta\>-cos <around*|(|<frac|2*k-1|2*l+2>*\<pi\>|)>|\|>>\<leq\>
  </equation*>

  <\equation*>
    \<leq\><frac|<around*|\||sin <around*|(|<frac|2*k-1|2*l+2>*\<pi\>|)>|\|>|l+1>*<frac|<around*|(|l+1|)>*<around*|\||\<theta\>-<frac|2*k-1|2*l+2>*\<pi\>|\|>|<frac|1|\<pi\>>*sin
    <around*|(|<frac|2*k-1|2*l+2>*\<pi\>|)>*<around*|\||\<theta\>-<frac|2*k-1|2*l+2>*\<pi\>|\|>>=\<pi\>.
  </equation*>

  <no-indent>We used

  <\equation*>
    <around*|\||cos <around*|(|<around*|(|l+1|)>*\<theta\>|)>|\|>=<around*|\||cos
    <around*|(|<around*|(|l+1|)>*\<theta\>|)>-cos
    <around*|(|<around*|(|l+1|)>*<frac|2*k-1|2*l+2>*\<pi\>|)>|\|>\<leq\><around*|(|l+1|)>*<around*|\||\<theta\>-<frac|2*k-1|2*l+2>*\<pi\>|\|>
  </equation*>

  <no-indent>and <math|cos <around*|(|<around*|(|l+1|)>*<frac|2*k-1|2*l+2>*\<pi\>|)>=0>.
  Moreover,

  <\equation*>
    <around*|\||cos \<theta\>-cos <around*|(|<frac|2*k-1|2*l+2>*\<pi\>|)>|\|>=2*sin
    <around*|(|<frac|\<theta\>+<frac|2*k-1|2*l+2>*\<pi\>|2>|)><around*|\||sin
    <around*|(|<frac|\<theta\>-<frac|2*k-1|2*l+2>*\<pi\>|2>|)>|\|>.
  </equation*>

  <no-indent>The concavity of the sine function on
  <math|<around*|[|0,\<pi\>|]>> implies

  <\equation*>
    sin <around*|(|<frac|\<theta\>+<frac|2*k-1|2*l+2>*\<pi\>|2>|)>\<geq\><frac|1|2>*<around*|(|sin
    \<theta\>+sin <around*|(|<frac|2*k-1|2*l+2>*\<pi\>|)>|)>
  </equation*>

  <\equation*>
    <around*|\||sin <around*|(|<frac|\<theta\>-<frac|2*k-1|2*l+2>*\<pi\>|2>|)>|\|>\<geq\><frac|2|\<pi\>>*<around*|\||\<theta\>-<frac|2*k-1|2*l+2>*\<pi\>|\|>,\<theta\>\<in\><around*|[|0,\<pi\>|]>.
  </equation*>

  <\remark>
    The Cauchy theorem merely gives a rough upper bound. In order to obtain a
    sharper upper bound, we would assume some additional hypotheses on the
    derivatives of the function.
  </remark>

  <subsection|Case 2: <math|Y> is an unbounded random variable>

  If the support of the random variable <math|Y> is not bounded and
  <math|\<varphi\>> is a polynomial of unknown degree <math|t>,
  <math|t\<leq\>g-1>, with <math|g> known, it's still possible to give an
  upper bound for the estimation error. Since

  <\equation*>
    \<varphi\><rsup|<around*|(|d|)>>=<big|sum><rsub|i=0><rsup|g-1><frac|\<varphi\><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>|i!>*<around*|(|u-s<rsup|\<ast\>>|)><rsup|i>=
  </equation*>

  <\equation*>
    =<big|sum><rsub|i=0><rsup|g-1><frac|<big|sum><rsub|k=0><rsup|g-1>L<rsub|s<rsub|k>><rsup|<around*|(|d+i|)>><around*|(|s<rsup|\<ast\>>|)>*\<varphi\><around*|(|s<rsub|k>|)>|i!>*<around*|(|u-s<rsup|\<ast\>>|)><rsup|i>=<big|sum><rsub|k=0><rsup|g-1>L<rsub|s<rsub|k>><rsup|<around*|(|d|)>><around*|(|u|)>*\<varphi\><around*|(|s<rsub|k>|)>,
  </equation*>

  <no-indent><math|\<varphi\><rsup|<around*|(|d|)>>> can be estimated as
  follows

  <\equation*>
    <wide|\<varphi\><rsup|<around*|(|d|)>><around*|(|u|)>|^>=<big|sum><rsub|k=0><rsup|g-1>L<rsub|s<rsub|k>><rsup|<around*|(|d|)>><around*|(|u|)><wide|Y|\<bar\>><around*|(|s<rsub|k>|)>.
  </equation*>

  <no-indent>We have in probability <math|<wide|\<varphi\><rsup|<around*|(|d|)>>|^>\<rightarrow\>\<varphi\><rsup|<around*|(|d|)>>>
  for <math|min <around*|(|n<rsub|k>|)>\<rightarrow\>\<infty\>>. So,

  <\equation*>
    V*a*r<around*|(|<wide|\<varphi\><rsup|<around*|(|d|)>>|^>|)>=<big|sum><rsub|k=0><rsup|g-1><around*|(|L<rsub|s<rsub|k>><rsup|<around*|(|d|)>><around*|(|u|)>|)><rsup|2><frac|\<varsigma\>|n<rsub|k>>\<rightarrow\>0,
  </equation*>

  <no-indent>where <math|\<varsigma\>> is the variance of <math|Z>. We use
  the Tchebycheff's inequality in order to obtain an upper bound for the
  estimation error. For a given <math|\<eta\>>,

  <\equation*>
    Pr <around*|{|<around*|\||<wide|\<varphi\><rsup|<around*|(|d|)>>|^>-\<varphi\><rsup|<around*|(|d|)>>|\|>\<geq\>\<eta\>|}>\<leq\><frac|<big|sum><rsub|k=0><rsup|g-1><around*|(|L<rsub|s<rsub|k>><rsup|<around*|(|d|)>><around*|(|u|)>|)><rsup|2><frac|\<varsigma\>|n<rsub|k>>|\<eta\><rsup|2>>.
  </equation*>

  <no-indent>If we aim to obtain, for all fixed <math|\<omega\>>, <math|Pr
  <around*|{|<around*|\||<wide|\<varphi\><rsup|<around*|(|d|)>>|^>-\<varphi\><rsup|<around*|(|d|)>>|\|>\<geq\>\<eta\>|}>\<leq\>\<omega\>>,
  we can choose <math|n<rsup|\<ast\>>> as the solution of the equation
  <math|<frac|<big|sum><rsub|k=0><rsup|g-1><around*|(|L<rsub|s<rsub|k>><rsup|<around*|(|d|)>><around*|(|u|)>|)><rsup|2><frac|\<varsigma\>|n<rsub|k>>|\<eta\><rsup|2>>=\<omega\>>,
  that is

  <\equation*>
    n<rsup|\<ast\>>=<frac|<big|sum><rsub|k=0><rsup|g-1><around*|(|L<rsub|s<rsub|k>><rsup|<around*|(|d|)>><around*|(|u|)>|)><rsup|2>*\<varsigma\>|\<omega\>*\<eta\><rsup|2>>.
  </equation*>

  <no-indent>The integer <math|<around*|[|n<rsup|\<ast\>>|]>> is such that
  the inequality <math|Pr <around*|{|<around*|\||<wide|\<varphi\><rsup|<around*|(|d|)>>|^>-\<varphi\><rsup|<around*|(|d|)>>|\|>\<geq\>\<eta\>|}>\<leq\>\<omega\>>
  is satisfied.

  <no-indent>We remark that if we know the degree <math|t> of the polynomial,
  then it is sufficient to set <math|g-1=t>. When
  <math|\<varphi\><around*|(|u|)>=\<varphi\><rsup|d><around*|(|u|)>> (i.e.,
  <math|d=0>), we have <math|<around*|[|n<rsup|\<ast\>>|]>=<frac|<big|sum><rsub|k=0><rsup|g-1><around*|(|L<rsub|s<rsub|k>><around*|(|u|)>|)><rsup|2>*\<varsigma\>|\<omega\>*\<eta\><rsup|2>>>.

  <no-indent>We underline that for <math|d=0> and when <math|t> is known
  <math|<wide|\<varphi\><rsup|<around*|(|d|)>><around*|(|u|)>|^>=<wide|\<varphi\><around*|(|u|)>|^>>
  coincides with Hoel's estimator.

  <no-indent>If the solely information on <math|\<varphi\>> is that
  <math|\<varphi\>> is analytic then we are constrained to give hypotheses on
  the derivatives of the function. More precisely, since
  <math|<math-up|Im>\<varphi\>\<subseteq\>\<bbb-R\>>, we can't apply the
  Cauchy theorem on the analytic functions; we can only say that
  <math|\<varphi\><around*|(|v|)>=E<around*|(|Y|)>\<in\>\<bbb-R\>>. So, we
  are not able to find a constant <math|R> such that
  <math|<around*|\||\<varphi\><around*|(|v|)>|\|>\<leq\>R>. Moreover, since
  we can't observe <math|\<varphi\><around*|(|v|)>> for <math|v\<nin\>S>, we
  don't have any data to estimate <math|M<rsub|T*a*y*l*o*r>>.

  <vspace|2fn><section|Bibliography>

  <\thebibliography|99>
    <bibitem-with-key|1|1>Bennett, G., 1962. Probability Inequalities for the
    Sum of Independent Random Variables, <em|Journal of the American
    Statistical Association>, 57, 297,33\U45.

    <bibitem-with-key|2|2>Bernstein, S.N., 1918. Quelques remarques sur
    l'interpolation, <em|Math. Ann.>, 79, 1\U12.

    <bibitem-with-key|3|3>Broniatowski, M., and Celant, G., 2007. Optimality
    and bias of some interpolation and extrapolation designs. <em|J. Statist.
    Plann. Inference>, 137, 858\U868.

    <bibitem-with-key|4|4>Celant, G., 2003. Extrapolation and optimal designs
    for accelerated runs. <em|Ann. I.S.U.P.>, 47, 3, 51\U84.

    <bibitem-with-key|5|5>Celant, G., 2002. Plans acclrs optimaux:
    estimation de la vie moyenne d'un systme. <em|C. R. Math. Acad. Sci.
    Paris>, 335, 1, 69\U72.

    <bibitem-with-key|6|6>Coatmlec, C., 1966. Approximation et interpolation
    des fonctions diffrentiables de plusieurs variables. <em|Ann. Sci. Ecole
    Norm. Sup.>, 83, 4, 271\U341.

    <bibitem-with-key|7|9>Hoeffding, W., 1963. Probability inequalities for
    sums of bounded random variables. <em|J. Amer. Statist. Assoc.>, 58,
    13\U30.

    <bibitem-with-key|8|10>Hoel, P.G., Levine, A., 1964. Optimal spacing and
    weighting in polynomial prediction. <em|Ann. Math. Statist.>, 35,
    1553\U1560.

    <bibitem-with-key|9|11>Hoel, P.G., 1965. Optimum designs for polynomial
    extrapolation. <em|Ann. Math. Statist.>, 36, 1483\U1493.

    <bibitem-with-key|10|14>Rivlin, T.J., 1969. An introduction to the
    approximation of functions. Blaisdell Publishing Co. Ginn and Co.,
    Waltham, Mass.-Toronto, Ont.-London

    <bibitem-with-key|11|16>Schnhage, A., 1961. Fehlerfortplanzung bei
    interpolation, <em|Numer. Math.>, 3, 62\U71.

    <bibitem-with-key|12|17>Spruill, M.C., 1984. Optimal designs for minimax
    extrapolation. <em|J. Multivariate Anal.>, 15, 1, 52\U62.

    <bibitem-with-key|13|18>Spruill, M.C., 1987. Optimal designs for
    interpolation. <em|J. Statist. Plann. Inference>, 16, 2, 219\U229.

    <bibitem-with-key|14|19>Spruill, M.C., 1987. Optimal extrapolation of
    derivatives. <em|Metrika>, 34, 1, 45\U60.

    <bibitem-with-key|15|20>Spruill, M.C., 1990. Optimal designs for
    multivariate interpolation. <em|J. Multivariate Anal.>, 34, 1, 141\U155.
  </thebibliography>
</body>