<TeXmacs|1.99.5>

<style|<tuple|tmarticle|vdh|centered-program|english>>

<\body>
  <\hide-preamble>
    <assign|Ce|<macro|x|<arg|x><rsub|c>>>

    <assign|Ra|<macro|x|<arg|x><rsub|r>>>

    <assign|Ball|<macro|c|r|\<cal-B\>(<arg|c>,<arg|r>)>>

    <assign|Beff|<macro|f|\<lceil\><space|-0.75spc>\<lceil\><arg|f>\<rceil\><space|-0.75spc>\<rceil\>>>

    <assign|Leff|<macro|f|\<lfloor\><space|-0.75spc>\<lfloor\><arg|f>\<rfloor\><space|-0.75spc>\<rfloor\>>>

    \;
  </hide-preamble>

  <doc-data|<doc-title|Efficient certification of<new-line>numeric solutions
  to eigenproblems>|<doc-running-title|Efficient certification of numeric
  solutions to eigenproblems>||<doc-author|<author-data|<author-name|Joris
  van der Hoeven>|<\author-affiliation>
    Laboratoire d'informatique, UMR 7161 CNRS

    Campus de l'cole polytechnique

    1, rue Honor d'Estienne d'Orves

    Btiment Alan Turing, CS35003

    91120 Palaiseau

    France

    Email: <verbatim|vdhoeven@lix.polytechnique.fr>
  </author-affiliation>>>|<doc-author|<author-data|<author-name|Bernard
  Mourrain>|<\author-affiliation>
    Inria Sophia Antipolis Mditerrane

    AROMATH

    2004 route des Lucioles

    06902 Sophia Antipolis

    France
  </author-affiliation>|<author-email|Bernard.Mourrain@inria.fr>>>|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    In this paper, we present an efficient algorithm for the certification of
    numeric solutions to eigenproblems. The algorithm relies on a mixture of
    ball arithmetic, a suitable Newton iteration, and clustering of
    eigenvalues that are close.
  </abstract>|<abstract-msc|65G20|03F60|65F99>|<abstract-keywords|Ball
  arithmetic, interval arithmetic, reliable computing, computable analysis>>

  <assign|fun|<macro|f|<with|font-family|ss|<arg|f>>>><assign|type|<macro|f|<with|font-family|ss|<arg|f>>>><math|<assign|C|\<cal-C\>><assign|R|\<cal-R\>><assign|K|\<cal-K\>>><section|Introduction>

  Let <math|\<bbb-F\>> be the set of floating point numbers for a fixed
  precision and a fixed exponent range. We will denote
  <math|\<bbb-F\><rsup|\<geqslant\>>=<around|{|x\<in\>\<bbb-F\>:x\<geqslant\>0|}>>.
  Consider an <math|n\<times\>n> matrix <math|M\<in\>\<bbb-F\><around|[|\<mathi\>|]><rsup|n\<times\>n>>
  with complex floating entries. The numeric <em|eigenproblem> associated to
  <math|M> is to compute a transformation matrix
  <math|T\<in\>\<bbb-F\><around|[|\<mathi\>|]><rsup|n\<times\>n>> and
  a<nbsp>diagonal matrix <math|D\<in\>\<bbb-F\><around|[|\<mathi\>|]><rsup|n\<times\>n>>
  such that

  <\eqnarray*>
    <tformat|<table|<row|<cell|D>|<cell|\<approx\>>|<cell|T<rsup|-1>*M*T.<eq-number><label|num-eigen-sol>>>>>
  </eqnarray*>

  The entries of <math|D> are the approximate eigenvalues and the columns of
  <math|T> are the approximate eigenvectors of <math|M>. In addition, we
  might require that <math|T> is normalized. For instance, each of the
  columns might have unit norm. Alternatively, the norm of the <math|i>-th
  column may be required to be the same as the norm of the <math|i>-th row of
  <math|T<rsup|-1>>, for each <math|i>. There are several well-known
  algorithms for solving the numeric eigenproblem<nbsp><cite|GL96>.

  Unfortunately, (<reference|num-eigen-sol>) is only an approximate equality.
  It is sometimes important to have rigourous bounds for the distance between
  the approximate eigenvalues and/or eigenvectors and the genuine ones. More
  precisely, we may ask for a<nbsp>diagonal matrix
  <math|D<rsub|r>\<in\><around|(|\<bbb-F\><rsup|\<geqslant\>>|)><rsup|n\<times\>n>>
  and a matrix <math|T<rsub|r>\<in\><around|(|\<bbb-F\><rsup|\<geqslant\>>|)><rsup|n\<times\>n>>
  such that there exists a<nbsp>matrix <math|T<rprime|'>\<in\>\<bbb-C\><rsup|n\<times\>n>>
  for which

  <\eqnarray*>
    <tformat|<table|<row|<cell|D<rprime|'>>|<cell|=>|<cell|<around|(|T<rprime|'>|)><rsup|-1>*M*T>>>>
  </eqnarray*>

  is diagonal and

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\||D<rprime|'><rsub|i,i>-D<rsub|i,i>|\|>>|<cell|\<leqslant\>>|<cell|<around|(|D<rsub|r>|)><rsub|i,i>>>|<row|<cell|<around|\||T<rsub|i,j><rprime|'>-T<rsub|i,j>|\|>>|<cell|\<leqslant\>>|<cell|<around|(|T<rsub|r>|)><rsub|i,j>>>>>
  </eqnarray*>

  for all <math|i,j>. This task will be called the <em|certification problem>
  of the numeric solution<nbsp><rigid|<math|<around|(|D,T|)>>> to the
  eigenproblem for <math|M>. The matrices <math|D<rsub|r>> and
  <math|T<rsub|r>> can be thought of as reliable error bounds for the
  numerical solution <math|<around*|(|D,T|)>> of the eigenproblem.

  It will be convenient to rely on <em|ball
  arithmetic><nbsp><cite|vdH:ball|Joh14>, which is a systematic technique for
  this kind of bound computations. When computing with complex numbers, ball
  arithmetic is more accurate than more classical interval
  arithmetic<nbsp><cite|Moo66|AH83|Neu90|JKDW01|Kul08|Intlab>, especially in
  multiple precision contexts. We will write
  <math|\<bbb-B\>=\<cal-B\><around|(|\<bbb-F\><around|[|\<mathi\>|]>,\<bbb-F\><rsup|\<geqslant\>>|)>>
  for the set of balls <math|\<b-z\>=\<cal-B\><around|(|z<rsub|c>,z<rsub|r>|)>=<around|{|z\<in\>\<bbb-C\>:<around|\||z-z<rsub|c>|\|>\<leqslant\>z<rsub|r>|}>>
  with centers <math|z<rsub|c>> in <with|mode|math|\<bbb-F\><around|[|\<mathi\>|]>>
  and radii <math|z<rsub|r>> in <with|mode|math|\<bbb-F\><rsup|\<geqslant\>>>.
  In a similar way, we may consider matricial balls
  <math|\<b-M\>=\<cal-B\><around|(|M<rsub|c>,M<rsub|r>|)>\<in\>\<cal-B\><around|(|\<bbb-F\><around|[|\<mathi\>|]><rsup|n\<times\>n>,<around*|(|\<bbb-F\><rsup|\<geqslant\>>|)><rsup|n\<times\>n>|)>>:
  given a center matrix <math|M<rsub|c>\<in\>\<bbb-F\><around|[|\<mathi\>|]><rsup|n\<times\>n>>
  and a radius matrix <math|M<rsub|r>\<in\><around|(|\<bbb-F\><rsup|\<geqslant\>>|)><rsup|n\<times\>n>>,
  we have

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-M\><space|1.2spc>=<space|1.2spc>\<cal-B\><around|(|M<rsub|c>,M<rsub|r>|)>>|<cell|=>|<cell|<around|{|M\<in\>\<bbb-C\><rsup|n\<times\>n>:\<forall\>i,j,<around|\||<around|(|M<rsub|c>|)><rsub|i,j>-M<rsub|i,j>|\|>\<leqslant\><around|(|M<rsub|r>|)><rsub|i,j>|}>.>>>>
  </eqnarray*>

  Alternatively, we may regard <math|\<cal-B\><around|(|M<rsub|c>,M<rsub|r>|)>>
  as the set of matrices in <math|\<bbb-B\><rsup|n\<times\>n>> with ball
  coefficients:

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<cal-B\><around|(|M<rsub|c>,M<rsub|r>|)><rsub|i,j>>|<cell|=>|<cell|\<cal-B\><around|(|<around|(|M<rsub|c>|)><rsub|i,j>,<around|(|M<rsub|r>|)><rsub|i,j>|)>.>>>>
  </eqnarray*>

  Standard arithmetic operations on balls are carried out in a reliable way.
  For instance, if <math|\<b-u\>,\<b-v\>\<in\>\<bbb-B\>>, then the
  computation of the product <math|\<b-w\>=\<b-u\>*<rigid|\<b-v\>>> using
  ball arithmetic has the property that <math|u*v\<in\>\<b-w\>> for any
  <math|u\<in\>\<b-u\>> and <math|v\<in\><rigid|\<b-v\>>>. Given a ball
  <math|\<b-z\>\<in\>\<bbb-B\>>, it will finally be convenient to write
  <math|<around|\<lfloor\>|\<b-z\>|\<rfloor\>>\<in\>\<bbb-F\><rsup|\<geqslant\>>>
  and <math|<around|\<lceil\>|\<b-z\>|\<rceil\>>\<in\>\<bbb-F\><rsup|\<geqslant\>>>
  for certified lower and upper bounds of <math|<around|\||\<b-z\>|\|>> in
  <math|\<bbb-F\><rsup|\<geqslant\>>>.

  In the language of ball arithmetic, it is natural to allow for small errors
  in the input and replace the numeric input
  <math|M\<in\>\<bbb-F\><around|[|\<mathi\>|]><rsup|n\<times\>n>> by a ball
  input <math|\<cal-B\><around|(|M<rsub|c>,M<rsub|r>|)>\<in\>\<bbb-B\><rsup|n\<times\>n>>.
  Then we may still compute a numeric solution

  <\eqnarray*>
    <tformat|<table|<row|<cell|D<rsub|c>>|<cell|\<approx\>>|<cell|T<rsub|c><rsup|-1>*M<rsub|c>*T<rsub|c>,<eq-number><label|center-problem>>>>>
  </eqnarray*>

  for the eigenproblem associated to the center <math|M<rsub|c>>. Assume that
  the matrices in <math|\<cal-B\><around|(|M<rsub|c>,M<rsub|r>|)>> are all
  diagonalizable. The generalized <em|certification problem> now consists of
  the computation of a diagonal matrix <math|D<rsub|r>\<in\><around|(|\<bbb-F\><rsup|\<geqslant\>>|)><rsup|n\<times\>n>>
  and a matrix <math|T<rsub|r>\<in\>\<bbb-F\><around|[|\<mathi\>|]><rsup|n\<times\>n>>
  such that, for every <math|M\<in\>\<cal-B\><around|(|M<rsub|c>,M<rsub|r>|)>>,
  there exist <math|D\<in\>\<cal-B\><around|(|D<rsub|c>,D<rsub|r>|)>> and
  <math|T\<in\>\<cal-B\><around|(|T<rsub|c>,T<rsub|r>|)>> with

  <\eqnarray*>
    <tformat|<table|<row|<cell|D>|<cell|=>|<cell|T<rsup|-1>*M*T.>>>>
  </eqnarray*>

  In absence of multiple eigenvalues, known algorithms for solving this
  problem such as<nbsp><cite|Yama80|Rump89> proceed by the individual
  certification of each eigenvector, which results in an
  <math|O<around|(|n<rsup|4>|)>> running time. From the more theoretical
  perspective of <math|\<alpha\>><nbhyph>theory<nbsp><cite|BlCuShSm1998>, we
  also refer to<nbsp><cite|ABBCS15> for numerically stable, strongly
  accurate, and theoretically efficient algorithms for solving eigenproblems.

  Extensions to a cluster of eigenvalues and the corresponding eigenvectors
  have been considered in <cite|DMW83|Rump01b>, with similar
  <math|O<around*|(|n<rsup|4>|)>> complexity bounds. Fixed points theorem
  based on interval arithmetic are used to prove the existence of a matrix
  with a given Jordan block in the matrix interval domain. Such an approach
  has been exploited for the analysis of multiple roots
  in<nbsp><cite|GT09|RG10>. A test that provides an enclosing of all the
  eigenvalues has been proposed in <cite|Miy10>. Its certification relies on
  interval and ball arithmetics. The complexity of the test is in
  <math|O<around*|(|n<rsup|3>|)>> but no iteration converging to the solution
  of the eigenproblem is described.\ 

  In this paper, we present a new algorithm of time complexity
  <math|O<around|(|n<rsup|3>|)>> for certifying and enclosing clusters of
  eigenvectors and eigenvalues in a single step. We also provide an iterative
  procedure that converges geometrically to clusters of solutions. This
  convergence is quadratic in the case of single eigenvalues. Our algorithm
  extends a<nbsp>previous algorithm from<nbsp><cite|vdH:ball> to the case of
  multiple eigenvalues. This yields an efficient test for <em|approximate
  eigenvalues>.

  From a more theoretical bit complexity point of view, our algorithm
  essentially reduces the certification problem to a constant number of
  numeric matrix multiplications. When using a precision
  of<nbsp><math|p><nbsp>bits for numerical computations, it has recently been
  shown<nbsp><cite|vdH:zmatmult> that two <math|n\<times\>n> matrices can be
  multiplied in time <math|<math-ss|MM><around*|(|n,p|)>=O<around*|(|n<rsup|2>*<math-ss|I><around*|(|p|)>+n<rsup|\<omega\>>*p*2<rsup|O*<around|(|lg<rsup|\<ast\>>
  p-lg<rsup|\<ast\>> n|)>>*<math-ss|I><around|(|lg d|)>/lg d|)>>. Here
  <math|<math-ss|I><around*|(|p|)>=O<around*|(|p*lg p*K<rsup|lg<rsup|\<ast\>>
  p>|)>> with <math|K\<leqslant\>6> is the cost of <math|p>-bit integer
  multiplication<nbsp><cite|vdH:mul|Har17> and
  <math|\<omega\>\<less\>2.3728639> is the exponent of matrix
  multiplication<nbsp><cite|Gall14>. If <math|p> is large enough with respect
  to the log of the condition number, then
  <math|O<around*|(|<math-ss|MM><around*|(|n,p|)>|)>> yields an asymptotic
  bound for the bit complexity of our certification problem.

  We recall that it is very unlikely that the numeric matrix
  <math|M<rsub|c>\<in\>\<bbb-F\><around|[|\<mathi\>|]><rsup|n\<times\>n>>
  with complex floating point coefficients has multiple eigenvalues. Indeed,
  small perturbations of matrices with multiple eigenvalues, as induced by
  rounding errors, generically only have simple eigenvalues. Consequently, we
  may assume without loss of generality that the numeric
  eigenproblem<nbsp>(<reference|center-problem>) has a reasonably accurate
  solution (if necessary, we may slightly perturb<nbsp><math|M<rsub|c>> and
  increase <math|M<rsub|r>> accordingly). Using ball arithmetic, it is
  straightforward to compute the matricial ball

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<cal-B\><around|(|N<rsub|c>,N<rsub|r>|)>>|<cell|=>|<cell|\<cal-B\><around|(|T<rsub|c>,0|)><rsup|-1>*\<cal-B\><around|(|M<rsub|c>,M<rsub|r>|)>*\<cal-B\><around|(|T<rsub|c>,0|)>.>>>>
  </eqnarray*>

  If our numerical algorithm is accurate, then the non diagonal entries of
  <with|mode|math|\<cal-B\><around|(|N<rsub|c>,N<rsub|r>|)>> tend to be
  small, whence <with|mode|math|\<cal-B\><around|(|N<rsub|c>,N<rsub|r>|)>>
  can be considered as a small perturbation of a diagonal matrix. If we can
  estimate how far eigenvalues and eigenvectors of diagonal matrices can
  drift away under small perturbations, we thus obtain a solution to the
  original certification problem.

  Section 2 introduces notations. In Section<nbsp><reference|perturb-sec>, we
  perform a detailed study of the eigenproblem for small
  perturbations<nbsp><math|M> of diagonal matrices. We exhibit a<nbsp>Newton
  iteration for finding the solutions. This iteration has quadratic
  convergence in the absence of multiple eigenvalues and is also an efficient
  tool for doubling the precision of a<nbsp>solution. However, in the case of
  multiple eigenvalues, the eigenproblem is ill-posed. Indeed, by a
  well-known observation, <em|any> vector occurs as the eigenvector of a
  small perturbation of the <math|2\<times\>2> identity matrix. The best we
  can hope for is to group eigenvectors with close eigenvalues together in
  \Pclusters\Q<nbsp>(see also<nbsp><cite|Rump01b>) and only require
  <math|T<rsup|-1>*M*T> to be block diagonal. For this reason, we present our
  Newton iteration in a sufficiently general setting which encompasses block
  matrices. We will show that the iteration still admits geometric
  convergence for sufficiently small perturbations and that the blockwise
  certification is still sufficient for the computation of rigourous error
  bounds for the eigenvalues. In Section<nbsp><reference|algo-sec>, we will
  present explicit algorithms for clustering and the overall certification
  problem.

  In absence of multiple eigenvalues, the <name|Analyziz> library of the
  <name|Mathemagix> system<nbsp><cite|vdH:mmx> contains an efficient
  implementation of our algorithm. The new algorithm from this paper has
  still to be integrated.

  <section|Notations>

  <subsection|Matrix norms><label|matrix-norm-sec>

  Throughout this paper, we will use the max norm for vectors and the
  corresponding matrix norm. More precisely, given a vector
  <math|v\<in\>\<bbb-C\><rsup|n>> and an <math|n\<times\>n> matrix
  <math|M\<in\>\<bbb-C\><rsup|n\<times\>n>>, we set

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\<\|\|\>|v|\<\|\|\>>>|<cell|=>|<cell|max
    <around|{|<around|\||v<rsub|1>|\|>,\<ldots\>,<around|\||v<rsub|n>|\|>|}>>>|<row|<cell|<around|\<\|\|\>|M|\<\|\|\>>>|<cell|=>|<cell|max<rsub|<around|\<\|\|\>|v|\<\|\|\>>=1>
    <around|\<\|\|\>|M v|\<\|\|\>>.>>>>
  </eqnarray*>

  For a second matrix <math|N\<in\>\<bbb-C\><rsup|n\<times\>n>>, we clearly
  have

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\<\|\|\>|M+N|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<around|\<\|\|\>|M|\<\|\|\>>+<around|\<\|\|\>|N|\<\|\|\>>>>|<row|<cell|<around|\<\|\|\>|M*N|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<around|\<\|\|\>|M|\<\|\|\>>*<around|\<\|\|\>|N|\<\|\|\>>.>>>>
  </eqnarray*>

  Explicit machine computation of the matrix norm is easy using the formula

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\<\|\|\>|M|\<\|\|\>>>|<cell|=>|<cell|max
    <around|{|<around|\||M<rsub|i,1>|\|>+\<cdots\>+<around|\||M<rsub|i,n>|\|>:1\<leqslant\>i\<leqslant\>n|}>.<eq-number><label|matrix-norm>>>>>
  </eqnarray*>

  In particular, when changing certain entries of a matrix <math|M> to zero,
  its matrix norm <math|<around|\<\|\|\>|M|\<\|\|\>>> can only decrease.

  <subsection|Clustering>

  Assume that we are given a partition

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|{|1,\<ldots\>,n|}>>|<cell|=>|<cell|I<rsub|1>\<amalg\>\<cdots\>\<amalg\>I<rsub|p>.<eq-number><label|clustering>>>>>
  </eqnarray*>

  Such a partition will also be called a <em|clustering> and denoted by
  <math|I>. Two indices <math|i,j> are said to belong to the same
  <em|cluster> if there exists a <math|k> with
  <math|<around|{|i,j|}>\<subseteq\>I<rsub|k>> and we will write
  <math|i\<sim\>j>. Two entries <math|M<rsub|i,j>> and
  <math|M<rsub|i<rprime|'>,j<rprime|'>>> of a matrix
  <math|M\<in\>\<bbb-C\><rsup|n\<times\>n>> are said to belong to the same
  <em|block> if <math|i\<sim\>j> and <math|i<rprime|'>\<sim\>j<rprime|'>>. We
  thus regard <math|M> as a generalized block matrix, for which the rows and
  columns of the blocks are not necessarily contiguous inside <math|M>.

  A matrix <math|M\<in\>\<bbb-C\><rsup|n\<times\>n>> is said to be <em|block
  diagonal> (relative to the clustering) if <math|M<rsub|i,j>=0> whenever
  <math|i\<nsim\>j>. Similarly, we say that <math|M> is <em|off block
  diagonal> if <math|M<rsub|i,j>=0> whenever <math|i\<sim\>j>. For a general
  <math|M\<in\>\<bbb-C\><rsup|n\<times\>n>>, we define its block diagonal and
  off block diagonal projections <math|\<Delta\><around|(|M|)>=\<Delta\><rsup|I><around|(|M|)>>
  and <math|\<Omega\><around|(|M|)>=\<Omega\><rsup|I><around|(|M|)>> by

  <\equation*>
    \<Delta\><around|(|M|)><rsub|i,j>=<choice|<tformat|<table|<row|<cell|M<rsub|i,j>>|<cell|<with|mode|text|if
    >i\<sim\>j>>|<row|<cell|0>|<cell|<with|mode|text|otherwise>>>>>><space|4em>\<Omega\><around|(|M|)><rsub|i,j>=<choice|<tformat|<table|<row|<cell|0>|<cell|<with|mode|text|if
    >i\<sim\>j>>|<row|<cell|M<rsub|i,j>>|<cell|<with|mode|text|otherwise>>>>>>
  </equation*>

  By our observation at the end of section<nbsp><reference|matrix-norm-sec>,
  we have

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\<\|\|\>|\<Delta\><around|(|M|)>|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<around|\<\|\|\>|M|\<\|\|\>>>>|<row|<cell|<around|\<\|\|\>|\<Omega\><around|(|M|)>|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<around|\<\|\|\>|M|\<\|\|\>>.>>>>
  </eqnarray*>

  For the <em|trivial clustering> <math|I<rsub|k>=<around|{|k|}>>, the
  matrices <math|\<Delta\><around|(|M|)>> and <math|\<Omega\><around|(|M|)>>
  are simply the diagonal and off diagonal projections of <math|M>. In that
  case we will also write <math|\<Delta\><rsup|\<ast\>>=\<Delta\>> and
  <math|\<Omega\><rsup|\<ast\>>=\<Omega\>>.

  <subsection|Diagonal matrices>

  Below, we will study eigenproblems for perturbations of a given diagonal
  matrix

  <\eqnarray*>
    <tformat|<table|<row|<cell|D>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|\<lambda\><rsub|1>>|<cell|>|<cell|>>|<row|<cell|>|<cell|\<ddots\>>|<cell|>>|<row|<cell|>|<cell|>|<cell|\<lambda\><rsub|n>>>>>>.<eq-number><label|diag-matrix>>>>>
  </eqnarray*>

  It follows from<nbsp>(<reference|matrix-norm>) that the matrix norm
  <math|\<mu\>=<around|\<\|\|\>|D|\<\|\|\>>> of a diagonal matrix <math|D> is
  given by

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<mu\>>|<cell|=>|<cell|max
    <around|{|<around|\||\<lambda\><rsub|1>|\|>,\<ldots\>,<around|\||\<lambda\><rsub|n>|\|>|}>.>>>>
  </eqnarray*>

  It will also be useful to define the <em|separation number>
  <math|\<sigma\><rsup|\<ast\>>=\<sigma\><rsup|\<ast\>><around|(|D|)>> by

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<sigma\><rsup|\<ast\>>>|<cell|=>|<cell|min<around*|{|<around|\||\<lambda\><rsub|i>-\<lambda\><rsub|j>|\|>:i\<neq\>j|}>.>>>>
  </eqnarray*>

  More generally, given a clustering as in the previous subsection, we also
  define the <em|block separation number>
  <math|\<sigma\>=\<sigma\><around|(|D|)>=\<sigma\><rsup|I><around|(|D|)>> by

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<sigma\>>|<cell|=>|<cell|min<around*|{|<around|\||\<lambda\><rsub|i>-\<lambda\><rsub|j>|\|>:i\<nsim\>j|}>>>>>
  </eqnarray*>

  This number <math|\<sigma\>> remains high if the clustering is chosen in
  such a way that the indices <math|i,j> of any two \Pclose\Q eigenvalues
  <math|\<lambda\><rsub|i>> and <math|\<lambda\><rsub|j>> belong to the same
  cluster. In particular, if <math|\<sigma\>\<gtr\>0>, then
  <math|\<lambda\><rsub|i>=\<lambda\><rsub|j>> implies <math|i\<sim\>j>.

  <section|Eigenproblems for perturbed diagonal matrices><label|perturb-sec>

  <subsection|The linearized equation>

  Let <math|D> be a diagonal matrix<nbsp>(<reference|diag-matrix>). Given a
  small perturbation

  <\eqnarray*>
    <tformat|<table|<row|<cell|M>|<cell|=>|<cell|D+H>>>>
  </eqnarray*>

  of <math|D>, where <math|H> is an off diagonal matrix, the aim of this
  section is to find a small matrix <math|E\<in\>\<bbb-C\><rsup|n\<times\>n>>
  for which

  <\eqnarray*>
    <tformat|<table|<row|<cell|M<rprime|'>>|<cell|=>|<cell|<around|(|1+E|)><rsup|-1>*M*<around|(|1+E|)>>>>>
  </eqnarray*>

  is block diagonal. In other words, we need to solve the equation

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<Omega\><around|(|<around|(|1+E|)><rsup|-1>*<around|(|D+H|)>*<around|(|1+E|)>|)>>|<cell|=>|<cell|0.>>>>
  </eqnarray*>

  When linearizing this equation in <math|E> and <math|H>, we obtain

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<Omega\><around|(|<around|[|D,E|]>+H|)>>|<cell|=>|<cell|0.>>>>
  </eqnarray*>

  If <math|E> is strongly off diagonal, then so is <math|<around|[|D,E|]>>,
  and the equation further reduces to

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|[|D,E|]>>|<cell|=>|<cell|-\<Omega\><around|(|H|)>.>>>>
  </eqnarray*>

  This equation can be solved using the following lemma:

  <\lemma>
    <label|fund-lem>Given a matrix <math|A\<in\>\<bbb-C\><rsup|n\<times\>n>>
    and a diagonal matrix <math|D> with entries
    <math|\<lambda\><rsub|1>,\<ldots\>,\<lambda\><rsub|n>>, let
    <math|B=\<Phi\><around|(|D,A|)>\<in\>\<bbb-C\><rsup|n\<times\>n>> be the
    strongly off diagonal matrix with

    <\eqnarray*>
      <tformat|<table|<row|<cell|B<rsub|i,j>>|<cell|=>|<cell|<choice|<tformat|<table|<row|<cell|0>|<cell|<with|mode|text|if
      >i\<sim\>j>>|<row|<cell|<frac|A<rsub|i,j>|\<lambda\><rsub|j>-\<lambda\><rsub|i>>>|<cell|<with|mode|text|otherwise>>>>>>>>>>
    </eqnarray*>

    Then <math|<around|\<\|\|\>|B|\<\|\|\>>\<leqslant\>\<sigma\><rsup|-1>*<around|\<\|\|\>|A|\<\|\|\>>>
    and

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around|[|D,B|]>>|<cell|=>|<cell|-\<Omega\><around|(|A|)>.<eq-number><label|comm-solve>>>>>
    </eqnarray*>
  </lemma>

  <\proof>
    The inequality follows from<nbsp>(<reference|matrix-norm>) and the
    definition of <math|\<sigma\>>. One may
    check<nbsp>(<reference|comm-solve>) using a straightforward computation.
  </proof>

  <subsection|The fundamental iteration><label|fund-iter-sec>

  In view of the lemma, we now consider the iteration

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|(|D,H|)>>|<cell|\<longmapsto\>>|<cell|<around|(|D<rprime|'>,H<rprime|'>|)>,>>>>
  </eqnarray*>

  where

  <\eqnarray*>
    <tformat|<table|<row|<cell|E>|<cell|=>|<cell|\<Phi\><around|(|D,H|)>>>|<row|<cell|M<rprime|'>>|<cell|=>|<cell|<around|(|1+E|)><rsup|-1><around|(|D+H|)>*<around|(|1+E|)>>>|<row|<cell|D<rprime|'>>|<cell|=>|<cell|\<Delta\><rsup|\<ast\>><around|(|M<rprime|'>|)>>>|<row|<cell|H<rprime|'>>|<cell|=>|<cell|\<Omega\><rsup|\<ast\>><around|(|M<rprime|'>|)>>>>>
  </eqnarray*>

  In order to study the convergence of this iteration, we introduce the
  quantities

  <\equation*>
    <tabular*|<tformat|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|5|5|cell-halign|r>|<cwith|1|-1|7|7|cell-halign|l>|<table|<row|<cell|\<mu\>>|<cell|=>|<cell|<around|\<\|\|\>|D|\<\|\|\>>>|<cell|>|<cell|\<mu\><rprime|'>>|<cell|=>|<cell|<around|\<\|\|\>|D<rprime|'>|\<\|\|\>>>>|<row|<cell|\<sigma\>>|<cell|=>|<cell|\<sigma\><around|(|D|)>>|<cell|>|<cell|\<sigma\><rprime|'>>|<cell|=>|<cell|\<sigma\><around|(|D<rprime|'>|)>>>|<row|<cell|\<eta\><rsub|1>>|<cell|=>|<cell|<around|\<\|\|\>|\<Delta\><around|(|H|)>|\<\|\|\>>>|<cell|<space|2em>>|<cell|\<eta\><rsub|1><rprime|'>>|<cell|=>|<cell|<around|\<\|\|\>|\<Delta\><around|(|H<rprime|'>|)>|\<\|\|\>>>>|<row|<cell|\<eta\><rsub|2>>|<cell|=>|<cell|<around|\<\|\|\>|\<Omega\><around|(|H|)>|\<\|\|\>>>|<cell|>|<cell|\<eta\><rsub|2><rprime|'>>|<cell|=>|<cell|<around|\<\|\|\>|\<Omega\><around|(|H<rprime|'>|)>|\<\|\|\>>>>>>>
  </equation*>

  <\equation*>
    <tabular|<tformat|<table|<row|<cell|\<alpha\>>|<cell|=>|<cell|min<around*|{|<frac|\<sigma\>|6*\<mu\>>,<frac|1|4>|}>.>>>>>
  </equation*>

  <\lemma>
    <label|iteration-lem>For <math|\<delta\>\<in\><around|(|0,1|]>>, assume
    that

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<eta\><rsub|1>+\<eta\><rsub|2>>|<cell|\<leqslant\>>|<cell|\<alpha\>*\<delta\>*\<mu\>>>|<row|<cell|\<eta\><rsub|2>>|<cell|\<leqslant\>>|<cell|\<alpha\>*\<delta\>*\<sigma\>.>>>>
    </eqnarray*>

    Then <math|<around|\<\|\|\>|D<rprime|'>-D|\<\|\|\>>\<leqslant\>\<delta\>*\<eta\><rsub|2>>
    and

    <\eqnarray*>
      <tformat|<cwith|2|2|3|3|cell-tsep|1spc>|<cwith|2|2|3|3|cell-bsep|1spc>|<table|<row|<cell|\<mu\><rprime|'>>|<cell|\<leqslant\>>|<cell|\<mu\>+\<delta\>*\<eta\><rsub|2>>>|<row|<cell|\<sigma\><rprime|'>>|<cell|\<geqslant\>>|<cell|\<sigma\>-2*\<delta\>*\<eta\><rsub|2>>>|<row|<cell|\<eta\><rsub|1><rprime|'>>|<cell|\<leqslant\>>|<cell|\<eta\><rsub|1>+\<delta\>*\<eta\><rsub|2>>>|<row|<cell|\<eta\><rsub|2><rprime|'>>|<cell|\<leqslant\>>|<cell|\<delta\>*\<eta\><rsub|2>.>>>>
    </eqnarray*>
  </lemma>

  <\proof>
    We have

    <\eqnarray*>
      <tformat|<table|<row|<cell|M<rprime|'>-D>|<cell|=>|<cell|H+<around|[|D,E|]>+R>>|<row|<cell|>|<cell|=>|<cell|\<Delta\><around|(|H|)>+R,>>>>
    </eqnarray*>

    where

    <\eqnarray*>
      <tformat|<table|<row|<cell|R>|<cell|=>|<cell|E<rsup|2>*<around|(|1+E|)><rsup|-1>*<around|(|D+H|)>*<around|(|1+E|)>-E*<around|(|D+H|)>*E+<around|[|H,E|]>.>>>>
    </eqnarray*>

    Setting <math|\<varepsilon\>=<around|\<\|\|\>|E|\<\|\|\>>\<leqslant\>\<sigma\><rsup|-1>*\<eta\><rsub|2>\<leqslant\>\<alpha\>*\<delta\>\<leqslant\><frac|1|4>>,
    the remainder <math|R> is bounded by

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around|\<\|\|\>|R|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|\<varepsilon\><rsup|2>*<frac|1|1-\<varepsilon\>>*<around|(|1+\<alpha\>*\<delta\>|)>*\<mu\>*<around|(|1+\<varepsilon\>|)>+\<varepsilon\>*<around|(|1+\<alpha\>*\<delta\>|)>*\<mu\>*\<varepsilon\>+2*<around|(|\<eta\><rsub|1>+\<eta\><rsub|2>|)>*\<varepsilon\>>>|<row|<cell|>|<cell|=>|<cell|<frac|2*\<varepsilon\><rsup|2>|1-\<varepsilon\>>*<around|(|1+\<alpha\>*\<delta\>|)>*\<mu\>+2*<around|(|\<eta\><rsub|1>+\<eta\><rsub|2>|)>*\<varepsilon\>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<around|(|4*\<varepsilon\>*\<mu\>+2*\<alpha\>*\<delta\>*\<mu\>|)>*\<varepsilon\>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|6*\<alpha\>*\<delta\>*\<mu\>*\<sigma\><rsup|-1>*\<eta\><rsub|2>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|\<delta\>*\<eta\><rsub|2>.>>>>
    </eqnarray*>

    Consequently,

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around|\<\|\|\>|D<rprime|'>-D|\<\|\|\>>>|<cell|=>|<cell|<around|\<\|\|\>|\<Delta\><rsup|\<ast\>><around|(|M<rprime|'>-D|)>|\<\|\|\>>=<around|\<\|\|\>|\<Delta\><rsup|\<ast\>><around|(|R|)>|\<\|\|\>>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<around|\<\|\|\>|R|\<\|\|\>>\<leqslant\>\<delta\>*\<eta\><rsub|2>>>|<row|<cell|\<eta\><rsub|1><rprime|'>>|<cell|=>|<cell|<around|\<\|\|\>|\<Delta\><around|(|H<rprime|'>|)>|\<\|\|\>>=<around|\<\|\|\>|\<Omega\><rsup|\<ast\>><around|(|\<Delta\><around|(|M<rprime|'>|)>|)>|\<\|\|\>>=<around|\<\|\|\>|\<Omega\><rsup|\<ast\>><around|(|\<Delta\><around|(|H+R|)>|)>|\<\|\|\>>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<around|\<\|\|\>|H+R|\<\|\|\>>\<leqslant\>\<eta\><rsub|1>+\<delta\>*\<eta\><rsub|2>>>|<row|<cell|\<eta\><rsub|2><rprime|'>>|<cell|=>|<cell|<around|\<\|\|\>|\<Omega\><around|(|H<rprime|'>|)>|\<\|\|\>>=<around|\<\|\|\>|\<Omega\><around|(|M<rprime|'>|)>|\<\|\|\>>=<around|\<\|\|\>|\<Omega\><around*|(|R|)>|\<\|\|\>>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|\<delta\>*\<eta\><rsub|2>.>>>>
    </eqnarray*>

    The inequalities <math|\<mu\><rprime|'>\<leqslant\>\<mu\>+\<delta\>*\<eta\><rsub|2>>
    and <math|\<sigma\><rprime|'>\<geqslant\>\<sigma\>-2*\<delta\>*\<eta\><rsub|2>>
    follow from <math|<around|\<\|\|\>|D<rprime|'>-D|\<\|\|\>>\<leqslant\>\<delta\>*\<eta\><rsub|2>>.
  </proof>

  <subsection|Convergence of the fundamental iteration>

  <\theorem>
    <label|conv-th>Assume that

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<eta\><rsub|1>+\<eta\><rsub|2>>|<cell|\<leqslant\>>|<cell|<tfrac|1|8>*\<alpha\>*\<mu\>>>|<row|<cell|\<eta\><rsub|2>>|<cell|\<leqslant\>>|<cell|<tfrac|1|8>*\<alpha\>*\<sigma\>.>>>>
    </eqnarray*>

    Then the sequence

    <\equation*>
      <around|(|D,H|)>,<around|(|D<rprime|'>,H<rprime|'>|)>,<around|(|D<rprime|''>,H<rprime|''>|)>,\<ldots\>
    </equation*>

    converges geometrically to a limit <math|<around|(|M<rsup|<around|(|\<infty\>|)>>,H<rsup|<around|(|\<infty\>|)>>|)>>
    with <math|<around|\<\|\|\>|D<rsup|<around|(|\<infty\>|)>>-M|\<\|\|\>>\<leqslant\>\<eta\><rsub|2>>
    and <math|<around|\<\|\|\>|H<rsup|<around|(|\<infty\>|)>>|\<\|\|\>>\<leqslant\>\<eta\><rsub|1>+\<eta\><rsub|2>>.
    The matrix <math|D<rsup|<around|(|\<infty\>|)>>+H<rsup|<around|(|\<infty\>|)>>>
    is block diagonal and there exists a matrix <math|<wide|E|^>>
    with<math|<around|\<\|\|\>|<wide|E|^>|\<\|\|\>>\<leqslant\>3*\<sigma\><rsup|-1>*\<eta\><rsub|2>>,
    such that

    <\eqnarray*>
      <tformat|<table|<row|<cell|D<rsup|<around|(|\<infty\>|)>>+H<rsup|<around|(|\<infty\>|)>>>|<cell|=>|<cell|<around|(|1+<wide|E|^>|)><rsup|-1>*<around|(|D+H|)>*<around|(|1+<wide|E|^>|)>.>>>>
    </eqnarray*>
  </theorem>

  <\proof>
    Let <math|<around|(|D<rsup|<around|(|i|)>>,H<rsup|<around|(|i|)>>|)>>
    stand for the <math|i>-th fundamental iterate of <math|<around|(|D,H|)>>
    and <math|E<rsup|<around|(|i|)>>=\<Phi\><around|(|H<rsup|<around|(|i|)>>,D<rsup|<around*|(|i|)>>|)>>.
    Denote <math|\<mu\><rsup|<around|(|i|)>>=<around|\<\|\|\>|D<rsup|<around|(|i|)>>|\<\|\|\>>>,
    <math|\<sigma\><rsup|<around|(|i|)>>=\<sigma\><around|(|D<rsup|<around|(|i|)>>|)>>,
    <math|\<eta\><rsub|1><rsup|<around|(|i|)>>=<around|\<\|\|\>|\<Delta\><around|(|H<rsup|<around|(|i|)>>|)>|\<\|\|\>>>
    and <math|\<eta\><rsub|2><rsup|<around|(|i|)>>=<around|\<\|\|\>|\<Omega\><around|(|H<rsup|<around|(|i|)>>|)>|\<\|\|\>>>.
    Let us show by induction over <math|i> that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around|\<\|\|\>|D<rsup|<around|(|i|)>>-D|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<around|(|1-<tfrac|1|2<rsup|i>>|)>*\<eta\><rsub|2>>>|<row|<cell|\<mu\><rsup|<around|(|i|)>>>|<cell|\<leqslant\>>|<cell|\<mu\>+<around|(|1-<tfrac|1|2<rsup|i>>|)>*\<eta\><rsub|2>>>|<row|<cell|\<sigma\><rsup|<around|(|i|)>>>|<cell|\<geqslant\>>|<cell|<tfrac|1|2>*<around|(|1+<tfrac|1|2<rsup|i>>|)>*\<sigma\>>>|<row|<cell|\<eta\><rsub|1><rsup|<around|(|i|)>>>|<cell|\<leqslant\>>|<cell|\<eta\><rsub|1>+<around|(|1-<tfrac|1|2<rsup|i>>|)>*\<eta\><rsub|2>>>|<row|<cell|\<eta\><rsub|2><rsup|<around|(|i|)>>>|<cell|\<leqslant\>>|<cell|<tfrac|1|2<rsup|i>>*\<eta\><rsub|2>.>>>>
    </eqnarray*>

    This is clear for <math|i=0>. Assume that the induction hypothesis holds
    for a given <math|i> and let

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<alpha\><rsup|<around|(|i|)>>>|<cell|=>|<cell|min<around*|{|<frac|\<sigma\><rsup|<around|(|i|)>>|6*\<mu\><rsup|<around|(|i|)>>>,<frac|1|4>|}>>>>>
    </eqnarray*>

    Since <math|<around|(|1-<frac|1|2<rsup|i>>|)>*\<eta\><rsub|2>\<leqslant\><frac|1|32>*\<mu\>>,
    the induction hypothesis implies

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<mu\><rsup|<around|(|i|)>>>|<cell|\<leqslant\>>|<cell|2*\<mu\>>>|<row|<cell|\<sigma\><rsup|<around|(|i|)>>>|<cell|\<geqslant\>>|<cell|<tfrac|1|2>*\<sigma\>>>|<row|<cell|\<alpha\><rsup|<around|(|i|)>>>|<cell|\<geqslant\>>|<cell|<tfrac|1|4>*\<alpha\>.>>>>
    </eqnarray*>

    Applying Lemma<nbsp><reference|iteration-lem> for
    <math|<around|(|D<rsup|<around|(|i|)>>,H<rsup|<around|(|i|)>>|)>> and
    <math|\<delta\>=<frac|1|2>>, we thus find

    <\eqnarray*>
      <tformat|<cwith|4|4|3|3|cell-bsep|1spc>|<cwith|4|4|3|3|cell-tsep|1spc>|<table|<row|<cell|<around|\<\|\|\>|D<rsup|<around|(|i+1|)>>-D|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<around|\<\|\|\>|D<rsup|<around|(|i|)>>-D|\<\|\|\>>+<around|\<\|\|\>|D<rsup|<around|(|i+1|)>>-D<rsup|<around|(|i|)>>|\<\|\|\>>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<around|(|1-<tfrac|1|2<rsup|i>>|)>*\<eta\><rsub|2>+<tfrac|1|2<rsup|i+1>>*\<eta\><rsub|2>\<leqslant\><around|(|1-<tfrac|1|2<rsup|i+1>>|)>*\<eta\><rsub|2>>>|<row|<cell|\<mu\><rsup|<around|(|i+1|)>>>|<cell|\<leqslant\>>|<cell|\<mu\><rsup|<around|(|i|)>>+<tfrac|1|2>*\<eta\><rsub|2><rsup|<around|(|i|)>>\<leqslant\>\<mu\>+<around|(|1-<tfrac|1|2<rsup|i+1>>|)>*\<eta\><rsub|2>>>|<row|<cell|\<sigma\><rsup|<around|(|i+1|)>>>|<cell|\<geqslant\>>|<cell|\<sigma\><rsup|<around|(|i|)>>-<tfrac|1|2>*\<eta\><rsub|2><rsup|<around|(|i|)>>\<geqslant\><tfrac|1|2>*<around|(|1+<tfrac|1|2<rsup|i>>-<tfrac|1|2<rsup|i+1>>|)>*\<sigma\>\<geqslant\><tfrac|1|2>*<around|(|1+<tfrac|1|2<rsup|i+1>>|)>*\<sigma\>>>|<row|<cell|\<eta\><rsub|1><rsup|<around|(|i+1|)>>>|<cell|\<leqslant\>>|<cell|\<eta\><rsub|1><rsup|<around|(|i|)>>+<tfrac|1|2>*\<eta\><rsub|2><rsup|<around|(|i|)>>\<leqslant\>\<eta\><rsub|1>+<around|(|1-<tfrac|1|2<rsup|i+1>>|)>*\<eta\><rsub|2>>>|<row|<cell|\<eta\><rsub|2><rsup|<around|(|i+1|)>>>|<cell|\<leqslant\>>|<cell|<tfrac|1|2>*\<eta\><rsub|2><rsup|<around|(|i|)>>\<leqslant\><tfrac|1|2<rsup|i+1>>*\<eta\><rsub|2>.>>>>
    </eqnarray*>

    This completes the induction.

    Applying the induction to the sequence starting at
    <math|D<rsup|<around*|(|i|)>>>, we have for every <math|j\<geqslant\>0>,

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around|\<\|\|\>|D<rsup|<around|(|i+j|)>>-D<rsup|<around*|(|i|)>>|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<around|(|1-<tfrac|1|2<rsup|j+1>>|)>*\<eta\><rsub|2><rsup|<around|(|i|)>>\<leqslant\><around|(|1-<tfrac|1|2<rsup|j+1>>|)><tfrac|1|2<rsup|i+1>>*\<eta\><rsub|2>.>>>>
    </eqnarray*>

    This shows that <math|D<rsup|<around*|(|i|)>>> is a Cauchy sequence that
    tends to a limit<nbsp><math|D<rsup|<around|(|\<infty\>|)>>> with
    <math|<rigid|<around|\<\|\|\>|D<rsup|<around|(|\<infty\>|)>>-D|\<\|\|\>>>\<leqslant\>\<eta\><rsub|2>>.
    From this inequality, we also deduce that
    <math|<around|\<\|\|\>|D<rsup|<around|(|\<infty\>|)>>-D<rsup|<around*|(|i|)>>|\<\|\|\>>\<leqslant\><tfrac|1|2<rsup|i+1>>*\<eta\><rsub|2>>,
    so <math|D<rsup|<around*|(|i|)>>> converges geometrically to
    <math|D<rsup|<around*|(|\<infty\>|)>>>.

    Moreover, for each <math|i>, we have <with|mode|math|\<varepsilon\><rsup|<around|(|i|)>>=<around|\<\|\|\>|E<rsup|<around|(|i|)>>|\<\|\|\>>\<leqslant\>\<sigma\><rsup|-1>*\<eta\><rsub|2><rsup|<around|(|i|)>>\<leqslant\><frac|1|2<rsup|i>>*\<sigma\><rsup|-1>*\<eta\><rsub|2>>.
    Hence, the matrix

    <\equation*>
      <wide|E|^>=<around|(|1+E<rsup|<around|(|0|)>>|)>*<around|(|1+E<rsup|<around|(|1|)>>|)>*<around|(|1+E<rsup|<around|(|2|)>>|)>*\<cdots\>-1
    </equation*>

    is well defined, and

    <\eqnarray*>
      <tformat|<table|<row|<cell|log<around|(|1+<around|\<\|\|\>|<wide|E|^>|\<\|\|\>>|)>>|<cell|\<leqslant\>>|<cell|log
      <around|(|1+\<varepsilon\><rsup|<around|(|0|)>>|)>+log<around|(|1+\<varepsilon\><rsup|<around|(|1|)>>|)>+log<around|(|1+\<varepsilon\><rsup|<around|(|2|)>>|)>+\<cdots\>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|2*\<sigma\><rsup|-1>*\<eta\><rsub|2>.>>>>
    </eqnarray*>

    We deduce that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around|\<\|\|\>|<wide|E|^>|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|\<mathe\><rsup|2*\<sigma\><rsup|-1>*\<eta\><rsub|2>>-1\<leqslant\>3*\<sigma\><rsup|-1>*\<eta\><rsub|2>,>>>>
    </eqnarray*>

    since <math|\<sigma\><rsup|-1>*\<eta\><rsub|2>\<leqslant\><frac|1|32>>.

    We claim that <math|M<rsup|<around*|(|i|)>>=D<rsup|<around*|(|i|)>>+H<rsup|<around*|(|i|)>>>
    converges geometrically to

    <\equation*>
      M<rsup|<around*|(|\<infty\>|)>>=<around*|(|1+<wide|E|^>|)><rsup|-1>*M<rsup|<around*|(|0|)>>*<around*|(|1+<wide|E|^>|)>.
    </equation*>

    For any matrix <math|M,E\<in\>\<bbb-C\><rsup|n\<times\>n>> with
    <math|<around*|\<\|\|\>|E|\<\|\|\>>\<less\>\<varepsilon\>\<less\>1>, we
    have

    <\eqnarray*>
      <tformat|<cwith|3|3|3|3|cell-bsep|1spc>|<cwith|3|3|3|3|cell-tsep|1spc>|<table|<row|<cell|<around*|\<\|\|\>|<around*|(|1+E|)><rsup|-1>*M*<around*|(|1+E|)>-M|\<\|\|\>>>|<cell|=>|<cell|<around*|\<\|\|\>|M*E-E
      <around*|(|1+E|)><rsup|-1>*M*<around*|(|1+E|)>|\<\|\|\>>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<around*|\<\|\|\>|M|\<\|\|\>>*<around*|(|\<varepsilon\>+\<varepsilon\>*<around*|(|1+\<varepsilon\>|)>*<around*|\<\|\|\>|<around*|(|1+E|)><rsup|-1>|\<\|\|\>>|)>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|\<varepsilon\>
      <around*|\<\|\|\>|M|\<\|\|\>>*<around*|(|1+<around*|(|1+\<varepsilon\>|)>
      <around*|(|1-\<varepsilon\>|)><rsup|-1>|)>>>|<row|<cell|>|<cell|=>|<cell|<frac|2*\<varepsilon\>|1-\<varepsilon\>>*<around*|\<\|\|\>|M|\<\|\|\>>.<eq-number><label|ineq:norm>>>>>
    </eqnarray*>

    Let <math|<wide|E|^><rsup|<around*|(|i|)>>=<around|(|1+E<rsup|<around|(|i|)>>|)>*<around|(|1+E<rsup|<around|(|i+1|)>>|)>*<around|(|1+E<rsup|<around|(|i+2|)>>|)>*\<cdots\>-1.>
    By the same arguments as above, we have
    <math|<wide|\<varepsilon\>|^><rsub|i>\<assign\><around*|\<\|\|\>|E<rsup|<around*|(|i|)>>|\<\|\|\>>\<leqslant\>3*\<sigma\><rsup|-1>*\<eta\><rsub|2><rsup|<around*|(|i|)>>=<frac|3|2<rsup|i+1>>
    \<sigma\><rsup|-1>*\<eta\><rsub|2>>. Since
    <math|M<rsup|<around*|(|\<infty\>|)>>=<around|(|1+<wide|E|^><rsup|<around*|(|i|)>>|)><rsup|-1>*M<rsup|<around*|(|i|)>>*<around|(|1+<wide|E|^><rsup|<around*|(|i|)>>|)>>,
    the inequality <eqref|ineq:norm> implies

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\<\|\|\>|M<rsup|<around*|(|\<infty\>|)>>-M<rsup|<around*|(|i|)>>|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<frac|2
      <wide|\<varepsilon\>|^><rsub|i>|1-<wide|\<varepsilon\>|^><rsub|i>>*<around*|(|<around*|\<\|\|\>|D<rsup|<around*|(|i|)>>|\<\|\|\>>+<around*|\<\|\|\>|H<rsup|<around*|(|i|)>>|\<\|\|\>>|)>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<frac|2
      <wide|\<varepsilon\>|^><rsub|i>|1-<wide|\<varepsilon\>|^><rsub|i>><around*|(|\<mu\><rsub|i>+\<eta\><rsub|1><rsup|<around*|(|i|)>>+\<eta\><rsub|2><rsup|<around*|(|i|)>>|)>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<frac|3|2<rsup|i>>*<frac|\<sigma\><rsup|-1>*\<eta\><rsub|2>|1-<wide|\<varepsilon\>|^><rsub|i>>*<around*|(|\<mu\>+\<eta\><rsub|1>+\<eta\><rsub|2>|)>.>>>>
    </eqnarray*>

    This shows that <math|M<rsup|<around*|(|i|)>>> converges geometrically to
    <math|M<rsup|<around*|(|\<infty\>|)>>>. We deduce that the sequence
    <math|H<rsup|<around|(|i|)>>=M<rsup|<around*|(|i|)>>-D<rsup|<around*|(|i|)>>>
    also converges geometrically to a<nbsp>limit<nbsp><math|H<rsup|<around|(|\<infty\>|)>>>
    with <math|<around|\<\|\|\>|H<rsup|<around|(|\<infty\>|)>>|\<\|\|\>>\<leqslant\>\<eta\><rsub|1>+\<eta\><rsub|2>>.
    Since <math|lim<rsub|i\<rightarrow\>\<infty\>>
    \<eta\><rsub|2><rsup|<around*|(|i|)>>=0>, we finally observe that
    <math|M<rsup|<around*|(|\<infty\>|)>>=D<rsup|<around|(|\<infty\>|)>>+H<rsup|<around|(|\<infty\>|)>>>
    is block diagonal.
  </proof>

  <\theorem>
    Assume <math|I<rsub|k>=<around|{|k|}>> for all <math|k>. Then, under the
    assumptions of Theorem<nbsp><reference|conv-th>, the sequence
    <with|mode|math|<around|(|D,H|)>,<around|(|D<rprime|'>,H<rprime|'>|)>,<around|(|D<rprime|''>,H<rprime|''>|)>,\<ldots\>>
    converges quadratically to <math|<around|(|D<rsup|<around|(|\<infty\>|)>>,0|)>>.
  </theorem>

  <\proof>
    The extra assumption implies that <math|\<eta\><rsub|1><rsup|<around|(|i|)>>=0>
    for all <math|i>. Let us show by induction over<nbsp><math|i> that we now
    have

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<eta\><rsub|2><rsup|<around|(|i|)>>>|<cell|\<leqslant\>>|<cell|<tfrac|1|2<rsup|2<rsup|i>-1>>*\<eta\><rsub|2>.>>>>
    </eqnarray*>

    This is clear for <math|i=0>. Assume that the result holds for a given
    <math|i>. Then we may apply Lemma<nbsp><reference|iteration-lem> to
    <math|<around|(|D<rsup|<around|(|i|)>>,H<rsup|<around|(|i|)>>|)>> for
    <math|\<delta\>=2<rsup|-2<rsup|i>+1>>, and obtain

    <\surround||<no-break-here>>
      <\eqnarray*>
        <tformat|<table|<row|<cell|\<eta\><rsub|2><rsup|<around|(|i+1|)>>>|<cell|\<leqslant\>>|<cell|<tfrac|1|2<rsup|2<rsup|i>-1>>*\<eta\><rsub|2><rsup|<around|(|i|)>>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<tfrac|1|2<rsup|2<rsup|i+1>-1>>.>>>>
      </eqnarray*>
    </surround>

    Since <math|<around|\<\|\|\>|D<rsup|<around|(|i+1|)>>-D<rsup|<around|(|i|)>>|\<\|\|\>>\<leqslant\>\<eta\><rsub|2><rsup|<around|(|i|)>>>,
    this establishes the quadratic convergence.
  </proof>

  <section|Algorithms><label|algo-sec>

  <subsection|Clustering>

  Let <math|M=D+H> be the perturbation of a diagonal
  matrix<nbsp>(<reference|diag-matrix>) as in the previous section. In order
  to apply theorem<nbsp><reference|conv-th>, we first have to find a suitable
  clustering<nbsp>(<reference|clustering>). For a given threshold separation
  <math|\<delta\>>, we will simply take the finest clustering (<abbr|i.e.>
  for which <math|p> is maximal) with the property that
  <math|<around|\||\<lambda\><rsub|i>-\<lambda\><rsub|j>|\|>\<leqslant\>\<delta\>\<Rightarrow\>i\<sim\>j>.
  This clustering can be computed using the algorithm <samp|Cluster> below.

  <\quote-env>
    <\named-specified-algorithm|<samp|Cluster>>
      <tabbed|<tformat|<table|<row|<cell|<strong|Input: >>|<\cell>
        eigenvalues <math|\<b-lambda\><rsub|1>,\<ldots\>,\<b-lambda\><rsub|n>\<in\>\<bbb-B\>>
        and <math|\<delta\>\<in\>\<bbb-F\><rsup|\<geqslant\>>>
      </cell>>|<row|<cell|<strong|Output: >>|<\cell>
        the finest clustering<nbsp>(<reference|clustering>) with
        <math|<around|\<lfloor\>|\<b-lambda\><rsub|i>-\<b-lambda\><rsub|j>|\<rfloor\>>\<leqslant\>\<delta\>\<Rightarrow\>i\<sim\>j>
      </cell>>>>>
    <|named-specified-algorithm>
      <\itemize>
        <item>Let <math|G> be the graph with vertices <math|1,\<ldots\>,n>
        and such that <math|i> and <math|j> are connected if and only if
        <math|<around|\<lfloor\>|\<b-lambda\><rsub|i>-\<b-lambda\><rsub|j>|\<rfloor\>>\<leqslant\>\<delta\>>.

        <item>Let <math|H> be the transitive closure of <math|G>.

        <item>Let <math|H<rsub|1>,\<ldots\>,H<rsub|p>> the connected
        components of <math|H>.

        <item>Let <math|I<rsub|k>> be the set of vertices of <math|H<rsub|k>>
        for each <math|k>.
      </itemize>
    </named-specified-algorithm>
  </quote-env>

  <subsection|Certification in the case of perturbed diagonal matrices>

  In order to apply theorem<nbsp><reference|conv-th>, it now remains to find
  a suitable threshold <math|\<delta\>> for which the conditions of the
  theorem hold. Starting with <math|\<delta\>=0>, we will simply increase
  <math|\<delta\>> to <math|\<sigma\><around|(|D|)>> whenever the conditions
  are not satisfied. This will force the number <math|p> of clusters to
  decrease by at least one at every iteration, whence the algorithm
  terminates. Notice that the workload of one iteration is
  <math|O<around|(|n<rsup|2>|)>>, so the total running time remains bounded
  by <math|O<around|(|n<rsup|3>|)>>.

  <\quote-env>
    <\named-specified-algorithm|<samp|DiagonalCertify>>
      <tabbed|<tformat|<twith|table-width|1par>|<twith|table-hmode|exact>|<table|<row|<cell|<strong|Input:
      >>|<\cell>
        a diagonal ball matrix <math|\<b-D\>\<in\>\<bbb-B\><rsup|n\<times\>n>>
        with entries <math|\<b-lambda\><rsub|1>,\<ldots\>,\<b-lambda\><rsub|n>>
        and

        an off diagonal ball matrix <math|\<b-H\>\<in\>\<bbb-B\><rsup|n\<times\>n>>
      </cell>>|<row|<cell|<strong|Output: >>|<\cell>
        a clustering <math|I> and <math|<wide|\<varepsilon\>|^>\<in\>\<bbb-F\>>
        such that, for any <math|M\<in\>\<b-D\>> and <math|H\<in\>\<b-H\>>,
        the conditions of theorem <reference|conv-th> hold and
        <math|<around|\<\|\|\>|<wide|E|^>|\<\|\|\>>\<leqslant\><wide|\<varepsilon\>|^>>
      </cell>>>>>
    <|named-specified-algorithm>
      <math|\<delta\>\<assign\>0>

      Repeat

      <\indent>
        Compute the clustering <math|I> for
        <math|\<b-lambda\><rsub|1>,\<ldots\>,\<b-lambda\><rsub|n>> and
        <math|\<delta\>> using <samp|Cluster>

        Let <math|\<b-mu\>\<assign\><around|\<\|\|\>|\<b-D\>|\<\|\|\>>>,
        <math|\<b-sigma\>\<assign\>\<sigma\><rsup|I><around|(|\<b-D\>|)>>,
        <math|\<b-eta\><rsub|1>\<assign\><around|\<\|\|\>|\<Delta\><rsup|I><around|(|\<b-H\>|)>|\<\|\|\>>>
        and <math|\<b-eta\><rsub|2>\<assign\><around|\<\|\|\>|\<Omega\><rsup|I><around|(|\<b-H\>|)>|\<\|\|\>>>

        Let <math|\<b-alpha\>\<assign\>min<around*|{|<frac|\<b-sigma\>|6*\<b-mu\>>,<frac|1|4>|}>>

        If <math|<around|\<lceil\>|\<b-eta\><rsub|1>+\<b-eta\><rsub|2>|\<rceil\>>\<leqslant\><around|\<lfloor\>|<frac|\<b-alpha\>*\<b-mu\>|8>|\<rfloor\>>>
        and <math|<around|\<lceil\>|\<b-eta\><rsub|2>|\<rceil\>>\<leqslant\><around|\<lfloor\>|<frac|\<b-alpha\>*\<b-sigma\>|8>|\<rfloor\>>><math|>,
        then return <math|<around|(|I,<around|\<lceil\>|<frac|3*\<b-eta\><rsub|2>|\<b-sigma\>>|\<rceil\>>|)>>

        Set <math|\<delta\>\<assign\><around|\<lceil\>|\<b-sigma\>|\<rceil\>>>
      </indent>
    </named-specified-algorithm>
  </quote-env>

  <subsection|Certification of approximate eigenvectors and eigenvalues>

  Let us now return to the original problem of certifying a numerical
  solution to an eigenproblem. We will denote by <math|\<bbb-1\><rsub|n>> the
  <math|n\<times\>n> matrix of which all entries are one.

  <\quote-env>
    <\named-specified-algorithm|<samp|EigenvectorCertify>>
      <tabbed|<tformat|<twith|table-width|1par>|<twith|table-hmode|exact>|<table|<row|<cell|<strong|Input:
      >>|<\cell>
        <math|\<b-M\>=\<cal-B\><around|(|M<rsub|c>,M<rsub|r>|)>\<in\>\<bbb-B\><rsup|n\<times\>n>>
        and <math|T<rsub|c>\<in\>\<bbb-F\><around|[|\<mathi\>|]><rsup|n\<times\>n>>

        such that <math|T<rsub|c><rsup|-1>*M<rsub|c>*T<rsub|c>> is
        approximately diagonal
      </cell>>|<row|<cell|<strong|Output: >>|<\cell>
        a clustering <math|I> and <math|\<b-T\>=\<cal-B\><around|(|T<rsub|c>,T<rsub|r>|)>\<in\>\<bbb-B\><rsup|n\<times\>n>>
        such that for any <math|M\<in\>\<b-M\>>,

        there exists a <math|T\<in\>\<b-T\>> for which <math|T<rsup|-1>*M*T>
        is block diagonal
      </cell>>>>>
    <|named-specified-algorithm>
      Compute <math|\<b-D\>\<assign\>\<cal-B\><around|(|T<rsub|c>,0|)><rsup|-1>*\<b-M\>*\<cal-B\><around|(|T<rsub|c>,T<rsub|r>|)>>

      Let <math|<around|(|I,\<varepsilon\>|)>\<assign\><math-ss|DiagonalCertify><around|(|\<Delta\><rsup|\<ast\>><around|(|\<b-D\>|)>,\<Omega\><rsup|\<ast\>><around|(|\<b-D\>|)>|)>>

      Let <math|\<b-E\>\<assign\>\<cal-B\><around|(|T<rsub|c>,0|)>*\<cal-B\><around|(|0,\<varepsilon\>|)>*\<bbb-1\><rsub|n>>

      Let <math|<around|(|T<rsub|r>|)><rsub|i,j>\<assign\><around|\<lceil\>|\<b-E\><rsub|i,j>|\<rceil\>>>
      for all <math|i,j>

      Return <math|<around|(|I,\<cal-B\><around|(|T<rsub|c>,T<rsub|r>|)>|)>>
    </named-specified-algorithm>
  </quote-env>

  <no-indent>Obviously, any eigenvalue <math|\<lambda\>\<in\>\<bbb-C\>> of a
  matrix <math|M\<in\>\<bbb-C\><rsup|n\<times\>n>> satisfies
  <math|<around|\||\<lambda\>|\|>\<leqslant\><around|\<\|\|\>|M|\<\|\|\>>>.
  We may thus use the following modification of <samp|EigenvectorCertify> in
  order to compute enclosures for the eigenvalues of <math|\<b-M\>>.

  <\quote-env>
    <\named-specified-algorithm|<samp|EigenvalueCertify>>
      <tabbed|<tformat|<twith|table-width|1par>|<twith|table-hmode|exact>|<table|<row|<cell|<strong|Input:
      >>|<\cell>
        <math|\<b-M\>=\<cal-B\><around|(|M<rsub|c>,M<rsub|r>|)>\<in\>\<bbb-B\><rsup|n\<times\>n>>
        and <math|T<rsub|c>\<in\>\<bbb-F\><around|[|\<mathi\>|]><rsup|n\<times\>n>>

        such that <math|T<rsub|c><rsup|-1>*M<rsub|c>*T<rsub|c>> is
        approximately diagonal
      </cell>>|<row|<cell|<strong|Output: >>|<\cell>
        ball enclosures <math|\<b-lambda\><rsub|1>,\<ldots\>,\<b-lambda\><rsub|n>\<in\>\<bbb-B\>>
        for the eigenvalues of <math|\<b-M\>>,

        with the appropriate multiplicities in cases of overlapping
      </cell>>>>>
    <|named-specified-algorithm>
      Compute <math|\<b-D\>\<assign\>\<cal-B\><around|(|T<rsub|c>,0|)><rsup|-1>*\<b-M\>*\<cal-B\><around|(|T<rsub|c>,T<rsub|r>|)>>

      Let <math|<around|(|I,\<varepsilon\>|)>\<assign\><math-ss|DiagonalCertify><around|(|\<Delta\><rsup|\<ast\>><around|(|\<b-D\>|)>,\<Omega\><rsup|\<ast\>><around|(|\<b-D\>|)>|)>>

      Let <math|\<b-eta\><rsub|1>\<assign\><around|\<\|\|\>|\<Delta\><rsup|I><around|(|\<Omega\><rsup|\<ast\>><around|(|\<b-D\>|)>|)>|\<\|\|\>>>
      and <math|\<b-eta\><rsub|2>\<assign\><around|\<\|\|\>|\<Omega\><rsup|I><around|(|\<Omega\><rsup|\<ast\>><around|(|\<b-D\>|)>|)>|\<\|\|\>>>

      For each <math|k\<in\><around|{|1,\<ldots\>,p|}>> do

      <\indent>
        If <math|I<rsub|k>=<around|{|i|}>> for some <math|i>, then let
        <math|\<b-lambda\><rsub|i>\<assign\>\<cal-B\><around|(|<around|(|D<rsub|c>|)><rsub|i,i>,<around|\<lceil\>|\<b-eta\><rsub|2>|\<rceil\>>|)>>

        Otherwise

        <\indent>
          Let <math|\<b-c\>> be the barycenter of the
          <math|\<b-D\><rsub|i,i>> with <math|i\<in\>I<rsub|k>>

          Let <math|\<b-r\>> be the maximum of
          <math|<around|\||\<b-D\><rsub|i,i>-c|\|>> for
          <math|i\<in\>I<rsub|k>>

          Let <math|\<b-lambda\><rsub|i>\<assign\>\<b-c\>+\<cal-B\><around|(|0,<around|\<lceil\>|\<b-r\>+\<b-eta\><rsub|1>+2*\<b-eta\><rsub|2>|\<rceil\>>|)>>
          for all <math|i\<in\>I<rsub|k>>
        </indent>
      </indent>

      Return <math|<around|(|\<b-lambda\><rsub|1>,\<ldots\>,\<b-lambda\><rsub|n>|)>>
    </named-specified-algorithm>
  </quote-env>

  <section|Possible extensions>

  Let <math|M\<in\>\<bbb-C\><rsup|n\<times\>n>> be a matrix with a
  (numerically) multiple eigenvalue <math|\<lambda\>>. We have already
  stressed that it is generally impossible to provide non trivial
  certifications for the corresponding eigenvectors. Nevertheless, two
  observations should be made:

  <\itemize>
    <item>If the eigenspace <math|E<rsub|\<lambda\>>> corresponding to
    <math|\<lambda\>> has dimension <math|1>, then small perturbations of the
    matrix <math|M> only induce small perturbations of <math|\<lambda\>> and
    <math|E<rsub|\<lambda\>>>.

    <item>Let <math|F<rsub|\<lambda\>>> denote the full invariant subspace
    associated to the eigenvalue <math|\<lambda\>> (or all eigenvalues in the
    cluster of <math|\<lambda\>>). Then small perturbations of <math|M> only
    induce small perturbations of <math|\<lambda\>> and
    <math|F<rsub|\<lambda\>>>.
  </itemize>

  More precisely, in these two cases, we may search for ball enclosures for
  orthonormal bases of the vector spaces <math|E<rsub|\<lambda\>>>
  <abbr|resp.><nbsp><math|F<rsub|\<lambda\>>>, which do not contain the zero
  vector.

  When considering the numeric solution (<reference|num-eigen-sol>) of the
  eigenproblem for <math|M>, the column vectors which generate
  <math|F<rsub|\<lambda\>>> are usually far from being orthogonal.
  Orthonormalization can only be done at the expense of making
  <math|T<rsup|-1>*M*T> only upper triangular. Moreover, the
  orthogonalization implies a big loss of accuracy, which requires the
  application of a<nbsp>correction method for restoring the accuracy. It
  seems that the fundamental Newton iteration from
  Section<nbsp><reference|fund-iter-sec> can actually be used as a correction
  method. For instance, for small perturbations of the matrix

  <\eqnarray*>
    <tformat|<table|<row|<cell|D>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|\<lambda\><rsub|1>>|<cell|1>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|\<lambda\><rsub|1>>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|\<lambda\><rsub|2>>|<cell|1>>|<row|<cell|0>|<cell|0>|<cell|0>|<cell|\<lambda\><rsub|2>>>>>>,>>>>
  </eqnarray*>

  it can be shown that the fundamental iteration still converges. However,
  for more general block diagonal matrices with triangular blocks, the
  details are quite technical and yet to be worked out.

  Yet another direction for future investigations concerns the quadratic
  convergence. As a refinement of Lemma<nbsp><reference|fund-lem>, we might
  replace <math|D> by a block diagonal matrix with entries
  <math|\<Lambda\><rsub|1>,\<ldots\>,\<Lambda\><rsub|p>>. Instead of taking
  <math|B<rsub|i,j>=<frac|M<rsub|i,j>|\<lambda\><rsub|j>-\<lambda\><rsub|i>>>,
  we then have to solve equations of the form

  <\eqnarray*>
    <tformat|<table|<row|<cell|B<rsub|i,j>*\<Lambda\><rsub|j>-\<Lambda\><rsub|i>*B<rsub|i,j>>|<cell|=>|<cell|M<rsub|i,j>.>>>>
  </eqnarray*>

  If the <math|\<Lambda\><rsub|i>> are sufficiently close to
  <math|\<lambda\><rsub|i>*Id>, it might then be possible to adapt the
  fundamental iteration accordingly so as to achieve quadratic convergence
  for the strongly off diagonal<nbsp>part.

  <\bibliography|bib|plain|all.bib>
    <\bib-list|10>
      <bibitem*|1><label|bib-AH83>G.<nbsp>Alefeld and J.<nbsp>Herzberger.
      <newblock><with|font-shape|italic|Introduction to interval analysis>.
      <newblock>Academic Press, New York, 1983.

      <bibitem*|2><label|bib-ABBCS15>D.<nbsp>Armentano, C.<nbsp>Beltrn,
      P.<nbsp>Brgisser, F.<nbsp>Cucker, and M.<nbsp>Shub. <newblock>A
      stable, polynomial-time algorithm for the eigenpair problem.
      <newblock>Technical report, ArXiv, 2014.
      <newblock><slink|http://arxiv.org/abs/1505.03290>.

      <bibitem*|3><label|bib-BlCuShSm1998>L.<nbsp>Blum, F.<nbsp>Cucker,
      M.<nbsp>Shub, and S.<nbsp>Smale. <newblock><with|font-shape|italic|Complexity
      and real computation>. <newblock>Springer-Verlag, 1998.

      <bibitem*|4><label|bib-DMW83>J.<nbsp>J. Dongarra, C.<nbsp>B. Moler, and
      J.<nbsp>H. Wilkinson. <newblock>Improving the accuracy of computed
      eigenvalues and eigenvectors. <newblock><with|font-shape|italic|SIAM
      Journal on Numerical Analysis>, 20(1):23\U45, 1983.

      <bibitem*|5><label|bib-Gall14>F.<nbsp>Le Gall. <newblock>Powers of
      tensors and fast matrix multiplication. <newblock>In
      <with|font-shape|italic|Proc. ISSAC 2014>, pages 296\U303, Kobe, Japan,
      July 23\U25 2014.

      <bibitem*|6><label|bib-GL96>G.<nbsp>H. Golub and F.<nbsp>Van Loan.
      <newblock><with|font-shape|italic|Matrix Computations>. <newblock>JHU
      Press, 1996.

      <bibitem*|7><label|bib-GT09>S.<nbsp>Graillat and Ph. Trbuchet.
      <newblock>A new algorithm for computing certified numerical
      approximations of the roots of a zero-dimensional system. <newblock>In
      <with|font-shape|italic|Proc. ISSAC '09>, pages 167\U174. ACM Press,
      2009.

      <bibitem*|8><label|bib-Har17>D.<nbsp>Harvey. <newblock>Faster truncated
      integer multiplication. <newblock><slink|https://arxiv.org/abs/1703.00640>,
      2017.

      <bibitem*|9><label|bib-vdH:zmatmult>D.<nbsp>Harvey and
      J.<nbsp>van<nbsp>der Hoeven. <newblock>On the complexity of integer
      matrix multiplication. <newblock>Technical report, HAL, 2014.
      <newblock><slink|http://hal.archives-ouvertes.fr/hal-01071191>,
      accepted for publication in JSC.

      <bibitem*|10><label|bib-vdH:mul>D.<nbsp>Harvey, J.<nbsp>van<nbsp>der
      Hoeven, and G.<nbsp>Lecerf. <newblock>Even faster integer
      multiplication. <newblock><with|font-shape|italic|Journal of
      Complexity>, 36:1\U30, 2016.

      <bibitem*|11><label|bib-vdH:ball>J.<nbsp>van<nbsp>der Hoeven.
      <newblock>Ball arithmetic. <newblock>Technical report, HAL, 2009.
      <newblock><slink|http://hal.archives-ouvertes.fr/hal-00432152>.

      <bibitem*|12><label|bib-vdH:mmx>J.<nbsp>van<nbsp>der Hoeven,
      G.<nbsp>Lecerf, B.<nbsp>Mourrain, et<nbsp>al. <newblock>Mathemagix,
      2002. <newblock><slink|http://www.mathemagix.org>.

      <bibitem*|13><label|bib-JKDW01>L.<nbsp>Jaulin, M.<nbsp>Kieffer,
      O.<nbsp>Didrit, and E.<nbsp>Walter.
      <newblock><with|font-shape|italic|Applied interval analysis>.
      <newblock>Springer, London, 2001.

      <bibitem*|14><label|bib-Joh14>F.<nbsp>Johansson. <newblock>Arb: A c
      library for ball arithmetic. <newblock><with|font-shape|italic|ACM
      Commun. Comput. Algebra>, 47(3/4):166\U169, 2014.

      <bibitem*|15><label|bib-Kul08>U.<nbsp>W. Kulisch.
      <newblock><with|font-shape|italic|Computer Arithmetic and Validity.
      Theory, Implementation, and Applications>. <newblock>Number<nbsp>33 in
      Studies in Mathematics. de Gruyter, 2008.

      <bibitem*|16><label|bib-Miy10>S.<nbsp>Miyajima. <newblock>Fast
      enclosure for all eigenvalues in generalized eigenvalue problems.
      <newblock><with|font-shape|italic|Journal of Computational and Applied
      Mathematics>, 233(11):2994\U3004, 2010.

      <bibitem*|17><label|bib-Moo66>R.<nbsp>E. Moore.
      <newblock><with|font-shape|italic|Interval Analysis>.
      <newblock>Prentice Hall, Englewood Cliffs, N.J., 1966.

      <bibitem*|18><label|bib-Neu90>A.<nbsp>Neumaier.
      <newblock><with|font-shape|italic|Interval methods for systems of
      equations>. <newblock>Cambridge university press, Cambridge, 1990.

      <bibitem*|19><label|bib-RG10>S.<nbsp>Rump and S.<nbsp>Graillat.
      <newblock>Verified error bounds for multiple roots of systems of
      nonlinear equations. <newblock><with|font-shape|italic|Num. Algs.>,
      54:359\U377, 2010.

      <bibitem*|20><label|bib-Rump89>S.<nbsp>M. Rump. <newblock>Guaranteed
      inclusions for the complex generalized eigenproblem.
      <newblock><with|font-shape|italic|Computing>, 42(2):225\U238, 1989.

      <bibitem*|21><label|bib-Intlab>S. M. Rump. <newblock>INTLAB - INTerval
      LABoratory. <newblock>In Tibor Csendes, editor,
      <with|font-shape|italic|Developments<nbsp>in<nbsp>Reliable Computing>,
      pages 77\U104. Kluwer Academic Publishers, Dordrecht, 1999.
      <newblock><slink|http://www.ti3.tu-harburg.de/rump/>.

      <bibitem*|22><label|bib-Rump01b>S.<nbsp>M. Rump.
      <newblock>Computational error bounds for multiple or nearly multiple
      eigenvalues. <newblock><with|font-shape|italic|Linear algebra and its
      applications>, 324(1-3):209\U226, 2001.

      <bibitem*|23><label|bib-Yama80>T.<nbsp>Yamamoto. <newblock>Error bounds
      for computed eigenvalues and eigenvectors.
      <newblock><with|font-shape|italic|Numerische Mathematik>,
      34(2):189\U199, 1980.
    </bib-list>
  </bibliography>
</body>

<\initial>
  <\collection>
    <associate|font-base-size|11>
    <associate|page-medium|paper>
    <associate|page-show-hf|true>
    <associate|par-hyphen|professional>
    <associate|sfactor|5>
  </collection>
</initial>

<\attachments>
  <\collection>
    <\associate|bib-bibliography>
      <\db-entry|+WglgIg8jPaNLt0|book|GL96>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1503503375>
      <|db-entry>
        <db-field|author|G. H. <name|Golub><name-sep>F. Van <name|Loan>>

        <db-field|title|Matrix Computations>

        <db-field|publisher|JHU Press>

        <db-field|year|1996>
      </db-entry>

      <\db-entry|+Li3PZLCHp1NMnW|techreport|vdH:ball>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1450799049>
      <|db-entry>
        <db-field|author|J. van der <name|Hoeven>>

        <db-field|title|Ball arithmetic>

        <db-field|institution|HAL>

        <db-field|year|2009>

        <db-field|note|<slink|http://hal.archives-ouvertes.fr/hal-00432152>>
      </db-entry>

      <\db-entry|+WglgIg8jPaNLt2|article|Joh14>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1503503375>
      <|db-entry>
        <db-field|author|F. <name|Johansson>>

        <db-field|title|Arb: a c library for ball arithmetic>

        <db-field|journal|ACM Commun. Comput. Algebra>

        <db-field|year|2014>

        <db-field|volume|47>

        <db-field|number|3/4>

        <db-field|pages|166\U169>
      </db-entry>

      <\db-entry|+63PGfIkmrfTqAB|book|Moo66>
        <db-field|newer|+Li3PZLCHp1NMhE>

        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1498579370>
      <|db-entry>
        <db-field|author|R. E. <name|Moore>>

        <db-field|title|Interval Analysis>

        <db-field|publisher|Prentice Hall>

        <db-field|year|1966>

        <db-field|address|Englewood Cliffs, N.J.>
      </db-entry>

      <\db-entry|+Li3PZLCHp1NMYm|book|AH83>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1450799043>
      <|db-entry>
        <db-field|author|G. <name|Alefeld><name-sep>J. <name|Herzberger>>

        <db-field|title|Introduction to interval analysis>

        <db-field|publisher|Academic Press>

        <db-field|year|1983>

        <db-field|address|New York>
      </db-entry>

      <\db-entry|+Li3PZLCHp1NMhZ|book|Neu90>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1450799047>
      <|db-entry>
        <db-field|author|A. <name|Neumaier>>

        <db-field|title|Interval methods for systems of equations>

        <db-field|publisher|Cambridge university press>

        <db-field|year|1990>

        <db-field|address|Cambridge>
      </db-entry>

      <\db-entry|+Li3PZLCHp1NMep|book|JKDW01>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1450799046>
      <|db-entry>
        <db-field|author|L. <name|Jaulin><name-sep>M.
        <name|Kieffer><name-sep>O. <name|Didrit><name-sep>E. <name|Walter>>

        <db-field|title|Applied interval analysis>

        <db-field|publisher|Springer>

        <db-field|year|2001>

        <db-field|address|London>
      </db-entry>

      <\db-entry|+63PGfIkmrfTq9z|book|Kul08>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1498579370>
      <|db-entry>
        <db-field|author|U. W. <name|Kulisch>>

        <db-field|title|Computer Arithmetic and Validity. Theory,
        Implementation, and Applications>

        <db-field|publisher|de Gruyter>

        <db-field|year|2008>

        <db-field|number|33>

        <db-field|series|Studies in Mathematics>
      </db-entry>

      <\db-entry|+63PGfIkmrfTq9h|incollection|Intlab>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1498579370>
      <|db-entry>
        <db-field|author|S. M. <name|Rump>>

        <db-field|title|INTLAB - INTerval LABoratory>

        <db-field|booktitle|Developments<nbsp>in<nbsp>Reliable Computing>

        <db-field|pages|77\U104>

        <db-field|publisher|Kluwer Academic Publishers>

        <db-field|year|1999>

        <db-field|editor|Tibor <name|Csendes>>

        <db-field|address|Dordrecht>

        <db-field|note|<slink|http://www.ti3.tu-harburg.de/rump/>>
      </db-entry>

      <\db-entry|+WglgIg8jPaNLt7|article|Yama80>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1503503375>
      <|db-entry>
        <db-field|author|T. <name|Yamamoto>>

        <db-field|title|Error bounds for computed eigenvalues and
        eigenvectors>

        <db-field|journal|Numerische Mathematik>

        <db-field|year|1980>

        <db-field|volume|34>

        <db-field|number|2>

        <db-field|pages|189\U199>
      </db-entry>

      <\db-entry|+WglgIg8jPaNLt5|article|Rump89>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1503503375>
      <|db-entry>
        <db-field|author|S. M. <name|Rump>>

        <db-field|title|Guaranteed inclusions for the complex generalized
        eigenproblem>

        <db-field|journal|Computing>

        <db-field|year|1989>

        <db-field|volume|42>

        <db-field|number|2>

        <db-field|pages|225\U238>
      </db-entry>

      <\db-entry|+Li3PZLCHp1NMa6|book|BlCuShSm1998>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1450799044>
      <|db-entry>
        <db-field|author|L. <name|Blum><name-sep>F. <name|Cucker><name-sep>M.
        <name|Shub><name-sep>S. <name|Smale>>

        <db-field|title|Complexity and real computation>

        <db-field|publisher|Springer-Verlag>

        <db-field|year|1998>

        <db-field|pages|0>

        <db-field|isbn|0-387-98281-7>

        <db-field|mrclass|68Q15 (03D15 13P99 14P99 65Y20 68-02)>

        <db-field|mrnumber|99a:68070>

        <db-field|mrreviewer|Klaus Meer>
      </db-entry>

      <\db-entry|+PYz9J1FzcfqzTY|techreport|ABBCS15>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1507672983>
      <|db-entry>
        <db-field|author|D. <name|Armentano><name-sep>C.
        <name|Beltrn><name-sep>P. <name|Brgisser><name-sep>F.
        <name|Cucker><name-sep>M. <name|Shub>>

        <db-field|title|A stable, polynomial-time algorithm for the eigenpair
        problem>

        <db-field|institution|ArXiv>

        <db-field|year|2014>

        <db-field|note|<slink|http://arxiv.org/abs/1505.03290>>
      </db-entry>

      <\db-entry|+WglgIg8jPaNLsz|article|DMW83>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1503503375>
      <|db-entry>
        <db-field|author|J. J. <name|Dongarra><name-sep>C. B.
        <name|Moler><name-sep>J. H. <name|Wilkinson>>

        <db-field|title|Improving the accuracy of computed eigenvalues and
        eigenvectors>

        <db-field|journal|SIAM Journal on Numerical Analysis>

        <db-field|year|1983>

        <db-field|volume|20>

        <db-field|number|1>

        <db-field|pages|23\U45>
      </db-entry>

      <\db-entry|+WglgIg8jPaNLt6|article|Rump01b>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1503503375>
      <|db-entry>
        <db-field|author|S. M. <name|Rump>>

        <db-field|title|Computational error bounds for multiple or nearly
        multiple eigenvalues>

        <db-field|journal|Linear algebra and its applications>

        <db-field|year|2001>

        <db-field|volume|324>

        <db-field|number|1-3>

        <db-field|pages|209\U226>
      </db-entry>

      <\db-entry|+WglgIg8jPaNLt1|inproceedings|GT09>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1503503375>
      <|db-entry>
        <db-field|author|S. <name|Graillat><name-sep>Ph. <name|Trbuchet>>

        <db-field|title|A new algorithm for computing certified numerical
        approximations of the roots of a zero-dimensional system>

        <db-field|booktitle|Proc. ISSAC '09>

        <db-field|pages|167\U174>

        <db-field|year|2009>

        <db-field|publisher|ACM Press>
      </db-entry>

      <\db-entry|+Li3PZLCHp1NMiy|article|RG10>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1450799048>
      <|db-entry>
        <db-field|author|S. <name|Rump><name-sep>S. <name|Graillat>>

        <db-field|title|Verified error bounds for multiple roots of systems
        of nonlinear equations>

        <db-field|journal|Num. Algs.>

        <db-field|year|2010>

        <db-field|volume|54>

        <db-field|pages|359\U377>
      </db-entry>

      <\db-entry|+WglgIg8jPaNLt4|article|Miy10>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1503503375>
      <|db-entry>
        <db-field|author|S. <name|Miyajima>>

        <db-field|title|Fast enclosure for all eigenvalues in generalized
        eigenvalue problems>

        <db-field|journal|Journal of Computational and Applied Mathematics>

        <db-field|year|2010>

        <db-field|volume|233>

        <db-field|number|11>

        <db-field|pages|2994\U3004>
      </db-entry>

      <\db-entry|+E00FWmNELVqHw7|techreport|vdH:zmatmult>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1472056740>
      <|db-entry>
        <db-field|author|D. <name|Harvey><name-sep>J. van der <name|Hoeven>>

        <db-field|title|On the complexity of integer matrix multiplication>

        <db-field|institution|HAL>

        <db-field|year|2014>

        <db-field|note|<slink|http://hal.archives-ouvertes.fr/hal-01071191>,
        accepted for publication in JSC>
      </db-entry>

      <\db-entry|+E00FWmNELVqHw6|article|vdH:mul>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1472056740>
      <|db-entry>
        <db-field|author|D. <name|Harvey><name-sep>J. van der
        <name|Hoeven><name-sep>G. <name|Lecerf>>

        <db-field|title|Even faster integer multiplication>

        <db-field|journal|Journal of Complexity>

        <db-field|year|2016>

        <db-field|volume|36>

        <db-field|pages|1\U30>
      </db-entry>

      <\db-entry|+PYz9J1FzcfqzTZ|unpublished|Har17>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1507672983>
      <|db-entry>
        <db-field|author|D. <name|Harvey>>

        <db-field|title|Faster truncated integer multiplication>

        <db-field|note|<slink|https://arxiv.org/abs/1703.00640>>

        <db-field|year|2017>
      </db-entry>

      <\db-entry|+Li3PZLCHp1NMd5|inproceedings|Gall14>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1450799045>
      <|db-entry>
        <db-field|author|F. Le <name|Gall>>

        <db-field|title|Powers of tensors and fast matrix multiplication>

        <db-field|booktitle|Proc. ISSAC 2014>

        <db-field|pages|296\U303>

        <db-field|year|2014>

        <db-field|address|Kobe, Japan>

        <db-field|month|July 23\U25>
      </db-entry>

      <\db-entry|+Li3PZLCHp1NMoY|misc|vdH:mmx>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1450799050>
      <|db-entry>
        <db-field|author|J. van der <name|Hoeven><name-sep>G.
        <name|Lecerf><name-sep>B. <name|Mourrain><name-sep><name|others>>

        <db-field|title|Mathemagix>

        <db-field|year|2002>

        <db-field|note|<slink|http://www.mathemagix.org>>
      </db-entry>
    </associate>
  </collection>
</attachments>

<\references>
  <\collection>
    <associate|algo-sec|<tuple|4|9|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-1|<tuple|1|1|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-10|<tuple|4|9|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-11|<tuple|4.1|9|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-12|<tuple|4.2|9|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-13|<tuple|4.3|10|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-14|<tuple|5|10|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-15|<tuple|<with|mode|<quote|math>|\<bullet\>>|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-2|<tuple|2|3|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-3|<tuple|2.1|3|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-4|<tuple|2.2|4|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-5|<tuple|2.3|4|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-6|<tuple|3|5|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-7|<tuple|3.1|5|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-8|<tuple|3.2|5|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|auto-9|<tuple|3.3|7|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-ABBCS15|<tuple|2|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-AH83|<tuple|1|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-BlCuShSm1998|<tuple|3|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-DMW83|<tuple|4|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-GL96|<tuple|6|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-GT09|<tuple|7|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-Gall14|<tuple|5|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-Har17|<tuple|8|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-Intlab|<tuple|21|12|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-JKDW01|<tuple|13|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-Joh14|<tuple|14|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-Kul08|<tuple|15|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-Miy10|<tuple|16|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-Moo66|<tuple|17|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-Neu90|<tuple|18|12|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-RG10|<tuple|19|12|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-Rump01b|<tuple|22|12|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-Rump89|<tuple|20|12|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-Yama80|<tuple|23|12|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-vdH:ball|<tuple|11|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-vdH:mmx|<tuple|12|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-vdH:mul|<tuple|10|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|bib-vdH:zmatmult|<tuple|9|11|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|center-problem|<tuple|2|2|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|clustering|<tuple|4|4|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|comm-solve|<tuple|6|5|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|conv-th|<tuple|3|7|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|diag-matrix|<tuple|5|4|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|fund-iter-sec|<tuple|3.2|5|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|fund-lem|<tuple|1|5|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|ineq:norm|<tuple|7|8|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|iteration-lem|<tuple|2|6|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|matrix-norm|<tuple|3|4|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|matrix-norm-sec|<tuple|2.1|3|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|num-eigen-sol|<tuple|1|1|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
    <associate|perturb-sec|<tuple|3|5|../../../../vdh/vdhoeven/publs/final/2017/certeigen/certeigen-macis.tm>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|bib>
      GL96

      vdH:ball

      Joh14

      Moo66

      AH83

      Neu90

      JKDW01

      Kul08

      Intlab

      Yama80

      Rump89

      BlCuShSm1998

      ABBCS15

      DMW83

      Rump01b

      GT09

      RG10

      Miy10

      vdH:ball

      vdH:zmatmult

      vdH:mul

      Har17

      Gall14

      Rump01b

      vdH:mmx
    </associate>
    <\associate|toc>
      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|1.<space|2spc>Introduction>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-1><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|2.<space|2spc>Notations>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-2><vspace|0.5fn>

      <with|par-left|<quote|1tab>|2.1.<space|2spc>Matrix norms
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-3>>

      <with|par-left|<quote|1tab>|2.2.<space|2spc>Clustering
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-4>>

      <with|par-left|<quote|1tab>|2.3.<space|2spc>Diagonal matrices
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-5>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|3.<space|2spc>Eigenproblems
      for perturbed diagonal matrices> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-6><vspace|0.5fn>

      <with|par-left|<quote|1tab>|3.1.<space|2spc>The linearized equation
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-7>>

      <with|par-left|<quote|1tab>|3.2.<space|2spc>The fundamental iteration
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-8>>

      <with|par-left|<quote|1tab>|3.3.<space|2spc>Convergence of the
      fundamental iteration <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-9>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|4.<space|2spc>Algorithms>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-10><vspace|0.5fn>

      <with|par-left|<quote|1tab>|4.1.<space|2spc>Clustering
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-11>>

      <with|par-left|<quote|1tab>|4.2.<space|2spc>Certification in the case
      of perturbed diagonal matrices <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-12>>

      <with|par-left|<quote|1tab>|4.3.<space|2spc>Certification of
      approximate eigenvectors and eigenvalues
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-13>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|5.<space|2spc>Possible
      extensions> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-14><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|Bibliography>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-15><vspace|0.5fn>
    </associate>
  </collection>
</auxiliary>