<TeXmacs|1.99.5>

<style|tmarticle>

<\body>
  <\hide-preamble>
    <assign|cst|<small|\<box\>>>

    \;
  </hide-preamble>

  <doc-data|<doc-title|Uniformly fast evaluation of<next-line> holonomic
  functions>|<doc-running-title|Uniformly fast evaluation of holonomic
  functions>|<doc-author|<author-data|<author-name|Joris van der
  Hoeven>|<\author-affiliation>
    Laboratoire d'informatique, UMR 7161 CNRS

    Campus de l'cole polytechnique

    1, rue Honor d'Estienne d'Orves

    Btiment Alan Turing, CS35003

    91120 Palaiseau
  </author-affiliation>>>|<doc-date|<date>>>

  <abstract-data|<abstract|In a series of previous articles, we have given
  efficient algorithms for the evaluation of holonomic functions over the
  algebraic numbers and for the computation of their limits at singularities.
  The focus of these articles was mainly on the efficient evaluation at a
  fixed point. In the present note, we will show that there exist uniformly
  efficient algorithms for evaluating holonomic functions. The main technical
  difficulty is to maintain uniform efficiency near irregular singularities.
  We will introduce a variant of accelerato-summation for this purpose that
  we call \Pexpedito-summation\Q.>|<abstract-keywords|holonomic
  function|special function|fast evaluation|accelero-summation|expedito-summation>|<abstract-msc|33-04|30-04|40-04|33F05|33E30|40G10|30B40>>

  <math|<assign|Mat|<with|math-font-family|ms|Mat>><assign|bd|<with|font-series|bold|math-font-series|bold|\<partial\>>><assign|Lie|<with|math-font-family|ms|Lie>><assign|GL|<with|math-font-family|ms|GL>><assign|Mono|<with|math-font-family|ms|Mono>><assign|Sto|<with|math-font-family|ms|Sto>><assign|Diag|<with|math-font-family|ms|Diag>><assign|Vect|<with|math-font-family|ms|Vect>><assign|Expo|<with|math-font-family|ms|Expo>><assign|Alg|<with|math-font-family|ms|Alg>><assign|Tor|<with|math-font-family|ms|Tor>><assign|Inv|<with|math-font-family|ms|Inv>>><section|Introduction>

  <subsection*|Statement of the problem and the main result>

  Let <math|\<bbb-K\>> be a subfield of <math|\<bbb-C\>>. A <em|holonomic
  function> over <math|\<bbb-K\>> is a solution<nbsp><math|f> to a linear
  differential equation <math|L f=0>, where
  <math|L=\<partial\><rsup|r>+L<rsub|r-1>*\<partial\><rsup|r-1>+\<cdots\>+L<rsub|0>\<in\>\<bbb-K\><around|(|z|)><around|[|\<partial\>|]>>
  is a monic linear differential operator of order<nbsp><math|r>. Many
  classical special functions, such as <math|exp>, <math|log>, <math|sin>,
  <math|cos>, <math|erf>, hypergeometric functions, Bessel functions, the
  Airy function, <abbr|etc.> are holonomic. Moreover, the class of holonomic
  functions is stable under many operations, such as addition,
  multiplication, differentiation, integration and postcomposition with
  algebraic functions.

  In the sequel, and unless stated otherwise, we will assume that
  <math|\<bbb-K\>> is the field of algebraic numbers. The only singularities
  of a holonomic function <math|f> as above can occur at the poles of the
  rational functions <math|L<rsub|0>,\<ldots\>,L<rsub|r-1>>; let
  <math|\<Sigma\>> denote the finite set of these poles. We will say
  that<nbsp><math|f> has <em|initial conditions in <math|\<bbb-K\>>> if
  <math|<around|(|f<around|(|z|)>,\<ldots\>,f<rsup|<around|(|r-1|)>><around|(|z|)>|)>\<in\>\<bbb-K\><rsup|r>>
  for a certain non-singular point <math|z\<in\>\<bbb-K\>\<setminus\>\<Sigma\>>.
  In this paper, we are interested in the design of efficient algorithms for
  the numeric evaluation of such a function <math|f>, with a particular focus
  on high precision and uniform efficiency as a<nbsp>function of the argument
  <math|z>.

  For a fixed non singular evaluation point, say
  <math|z\<in\>\<bbb-K\>\<setminus\>\<Sigma\>>, an efficient general purpose
  algorithm was first given by the Chudnovsky brothers<nbsp><cite|CC90>. More
  precisely, in the case when <math|\<bbb-K\>=\<bbb-Q\><around*|[|\<mathi\>|]>>,
  they proved that an <math|n>-bit approximation of <math|f<around*|(|z|)>>
  can be computed in time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|2>
  n|)>>. Here <math|<math-ss|I><around*|(|n|)>> stands for a complexity bound
  for integer multiplication and it has recently been proved that one may
  take <math|<math-ss|I><around*|(|n|)>=O<around*|(|n*log
  n*8<rsup|log<rsup|\<ast\>> n>|)>>, where <math|log<rsup|\<ast\>> n=min
  <around*|{|k\<in\>\<bbb-N\>:<around*|(|log\<circ\><above|\<ldots\>|k<math-postfix|\<times\>>>\<circ\>log|)><around*|(|n|)>\<leqslant\>1|}>>.
  The Chudnovsky\UChudnovsky algorithm was rediscovered
  in<nbsp><cite|vdH:hol> and generalized to the case when <math|\<bbb-K\>> is
  the field of algebraic numbers. An early precursor and further variants can
  be found in<nbsp><cite|Br76a|Kar93|HP97>.

  In order to design uniformly efficient evaluation algorithms, it is crucial
  to control the efficiency when <math|z> approaches one of the singularities
  in <math|\<Sigma\>>. Actually, one first question concerns the computation
  of the limit of a holonomic function at a singularity if this limit exists.
  This was first done in<nbsp><cite|vdH:singhol> for so called regular
  singularities (achieving the same complexity bound as for non singular
  points), and in<nbsp><cite|vdH:reshol> for irregular singularities (in
  which case we showed that <math|n>-bit approximations of limits can be
  computed in time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3>
  n|)>>). We refer to<nbsp><cite|vdH:singhol|vdH:reshol> for the definitions
  of the concepts of regular and irregular singularities.

  The main aim of this paper is to achieve the same kind of complexity bounds
  uniformly in <math|z>. Such bounds need to be stated with a lot of care.
  First of all, a holonomic function such as <math|f<around*|(|z|)>=exp z>
  grows exponentially fast at infinity: given the <math|n>-bit number
  <math|z=2<rsup|n>>, one needs <math|\<Theta\><around*|(|2<rsup|n>|)>> bits
  to merely write down the closest integer approximation
  <rigid|<math|<around*|\<lfloor\>|exp<around*|(|2<rsup|n>|)>+<frac*|1|2>|\<rfloor\>>>>
  of <math|f<around*|(|z|)>>. Using floating point approximations for both
  <math|z> and <math|f<around*|(|z|)>> does not help, since a<nbsp>similar
  explosion then occurs for the exponent. But we may hope for a good uniform
  complexity bound if we use fixed point approximations for <math|z> and
  floating point approximations for<nbsp><math|f<around*|(|z|)>>.

  Another complication is due to the number zero, which should be regarded as
  a singularity when using floating point representations: it is difficult to
  compute accurate floating point approximations for <math|f<around*|(|z|)>>
  if <math|z> is close to a zero of <math|f>. Predicting the exact locations
  of zeros of holonomic functions is a notoriously difficult problem. Even
  the basic question to decide whether <math|f<around*|(|z|)>=0> for
  <math|z\<in\>\<bbb-K\>\<setminus\>\<Sigma\>> admits no algorithmic answer
  for the moment. Nevertheless, the number <math|z> is often the
  approximation of some other complex number with a precision
  of<nbsp><math|n><nbsp>binary digits behind the dot. In that case, it is
  natural to consider the more general evaluation of <math|f> on the ball
  <math|\<cal-B\><around*|(|z,2<rsup|-n>|)>> with center <math|z> and
  radius<nbsp><math|2<rsup|-n>>, and to require that <math|f> admits no zeros
  on this ball.

  We are almost in a position to state the main result of this paper. Let
  <math|\<bbb-D\>=\<bbb-Z\>*2<rsup|\<bbb-Z\>>> be the set of <em|dyadic>
  numbers. Given <math|x=k*2<rsup|e>\<in\>\<bbb-D\>>, we denote by
  <math|size<around*|(|x|)>=<around*|\<lceil\>|log<rsub|2>
  <around*|(|<around*|\||k|\|>+1|)>|\<rceil\>>+<around*|\||e|\|>> the bitsize
  of <math|x>. Given <math|z=x+\<mathi\>*y\<in\>\<bbb-D\><around*|[|\<mathi\>|]>>,
  we also denote <math|size<around*|(|z|)>=size<around*|(|x|)>+size<around*|(|y|)>>.
  The set <math|\<bbb-F\>=\<bbb-Z\>*2<rsup|\<bbb-Z\>>> of <em|floating point>
  numbers is defined in the same way as <math|\<bbb-D\>>, but the exponent of
  a floating point numbers <math|x=k*2<rsup|e>\<in\>\<bbb-F\>> is represented
  in binary notation, so that the bitsize of <math|x> is now fiven by
  <math|fsize<around*|(|x|)>=<around*|\<lceil\>|log<rsub|2>
  <around*|(|<around*|\||k|\|>+1|)>|\<rceil\>>+<around*|\<lceil\>|log<rsub|2>
  <around*|(|<around*|\||e|\|>+1|)>|\<rceil\>>>.

  Let <math|z<rsub|0>\<in\>\<bbb-K\>> be the point at which we specified the
  initial conditions of <math|f>. We define <math|\<Omega\>> to be the open
  subset of <math|\<bbb-C\>> of all points <math|z> such that the
  straightline segment <math|<around*|[|z<rsub|0>,z|]>> from <math|z<rsub|0>>
  to<nbsp><math|z> does not intersect <math|\<Sigma\>>. We take <math|f> to
  be the unique solution of <math|L f=0> on <math|\<Omega\>> that matches the
  prescribed initial conditions at <math|z<rsub|0>>. Let
  <math|\<Theta\>\<subseteq\>\<Omega\>> denote the set of zeros of <math|f>.
  The main theorem of this paper is the following.

  <\theorem>
    <label|main-th>There exists an algorithm that takes
    <math|n\<in\>\<bbb-N\>> and <math|z\<in\>\<Omega\>\<cap\>\<bbb-D\><around*|[|\<mathi\>|]>>
    with <math|\<cal-B\><rigid|<around*|(|z,2<rsup|-n>|)>>\<cap\><around*|(|\<partial\>
    \<Omega\>\<cup\>\<Theta\>|)>=\<varnothing\>> and
    <math|size<around*|(|z|)>\<leqslant\>n> on input and that computes
    <math|v\<in\>\<bbb-F\><around*|[|\<mathi\>|]>> on output with
    <math|<around*|\||f<around*|(|z|)>-v|\|>\<leqslant\>2<rsup|-n>*<around*|\||f<around*|(|z|)>|\|>>.
    Moreover, the running time of the algorithm is bounded by
    <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>, uniformly
    in <math|z>.
  </theorem>

  <subsection*|Proof strategy>

  As long as <math|z> remains in a compact subset <math|K> of
  <math|\<Omega\>> in Theorem<nbsp><reference|main-th>, the conclusion
  essentially follows from the existing complexity bounds
  in<nbsp><cite|CC90|vdH:hol>; using a refinement<nbsp><cite|Mezza:phd> of
  the complexity analysis from<nbsp><cite|vdH:hol>, one even obtains the
  stronger complexity bound <math|O*<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|2>
  n|)>> for the evaluation of <math|f>. Using the techniques
  from<nbsp><cite|vdH:singhol>, these complexity bounds generalize to subsets
  <math|K\<cap\>\<Omega\>> of <math|\<Omega\>>, where <math|K> is a compact
  set that contains none of the irregular singularities
  of<nbsp><math|\<Sigma\>>. If the point at infinity is a regular
  singularity, then the bound also applies on subsets
  <math|<around*|{|z\<in\>U:<around*|\||z|\|>\<geqslant\>M|}>> for
  sufficiently large <math|M>, modulo the change of coordinates
  <math|z\<rightarrow\>z<rsup|-1>>.

  The above discussion shows that the proof of
  Theorem<nbsp><reference|main-th> involves two main difficulties:
  controlling the complexity near irregular singularities and controlling the
  complexity of evaluating <math|f<around*|(|z|)>> near zeros of <math|f>.
  For the first task, we will adapt the technique of accelero-summation
  from<nbsp><cite|vdH:reshol>. For the second task, we rely on the idea
  that<nbsp><math|f,\<ldots\>,f<rsup|<around*|(|r-1|)>>> can never
  simultaneously become \Psmaller than expected\Q. A precise statement will
  be presented in Section<nbsp><reference|global-sec>; this statement can be
  regarded as a quantitative version of the well-known property
  that<nbsp><rigid|<math|f,\<ldots\>,f<rsup|<around*|(|r-1|)>>>> cannot
  vanish simultaneously unless <math|f> vanishes itself.

  Let us return to the evaluation of <math|f> near an irregular singulary,
  say <math|0\<in\>\<Sigma\>>. At the origin, it is well-known that <math|L
  f=0> admits a basis of formal solution of the form

  <\equation*>
    <wide|b|~><rsub|i><around*|(|z|)>=<wide|\<varphi\>|~><rsub|i><around*|(|z|)>*z<rsup|\<lambda\><rsub|i>>*\<mathe\><rsup|P<rsub|i><around*|(|z<rsup|-1/\<kappa\>>|)>>
  </equation*>

  for <math|L f=0>, where <math|<wide|\<varphi\>|~><rsub|i><around*|(|z|)>\<in\>\<bbb-C\><around*|[|<around*|[|z<rsup|1/\<kappa\>>|]>|]><around*|[|log
  z|]>>, <math|\<lambda\><rsub|i>\<in\>\<bbb-C\>>,
  <math|P<rsub|i><around*|(|z<rsup|-1/\<kappa\>>|)>\<in\>\<bbb-C\><around*|[|z<rsup|-1/\<kappa\>>|]>>,
  <math|\<kappa\>\<in\>\<bbb-N\><rsup|\<neq\>>>, and where
  <math|\<varphi\><rsub|i><around*|(|z|)>\<sim\><around*|(|log
  z|)><rsup|k<rsub|i>>> for some <math|k<rsub|i>\<in\>\<bbb-N\>>.
  In<nbsp><cite|vdH:reshol>, it is shown that the series
  <math|<wide|\<varphi\>|~><rsub|i>> are accelero-summable and that we can
  associate actual functions <math|\<varphi\><rsub|i>> to them that are
  defined on sectors of the form

  <\equation*>
    \<cal-S\><rsub|R,\<theta\>,\<alpha\>>\<assign\><around*|{|r*\<mathe\><rsup|\<vartheta\>*\<mathi\>>:r\<in\><around*|(|0,R|]>,\<vartheta\>\<in\><around*|[|\<theta\>-\<alpha\>,\<theta\>+\<alpha\>|]>|}>.
  </equation*>

  Moreover, a finite number of these sectors can be made to cover a punctured
  neighbourhood of the origin. One crucual step toward the design of an
  efficient evaluation algorithm for<nbsp><math|f> on such a sector is to
  deal with the special case when <math|f=b<rsub|i>> for some <math|i>, which
  further reduces to the case when <math|f=\<varphi\><rsub|i>>.

  In the remainder of this paper, we will assume that the reader is familiar
  with<nbsp><cite|vdH:reshol> and the notations that we used there. For
  simplicity, we will also restrict to accelerations and Laplace transforms
  such that we integrate on the positive real axis. Using a change of
  variables <math|z\<rightarrow\>u*z> for a suitable
  <math|u\<in\>\<bbb-C\><rsup|\<neq\>>>, this entails no loss of generality.
  More precisely, we assume that we are in the following situation. The
  function <math|f> is the result

  <\eqnarray*>
    <tformat|<table|<row|<cell|f<rsub|p>>|<cell|=>|<cell|<around*|(|<wide|\<cal-L\>|\<check\>><rsub|k<rsub|p>>\<circ\><wide|\<cal-A\>|\<check\>><rsub|k<rsub|p-1>,k<rsub|p>>\<circ\>\<cdots\>\<circ\><wide|\<cal-A\>|\<check\>><rsub|k<rsub|1>,k<rsub|2>>\<circ\><wide|\<cal-B\>|\<check\>><rsub|k<rsub|1>>|)><around*|(|<wide|f|~><rsub|1>|)>>>>>
  </eqnarray*>

  of an accelero-summation process with critical times
  <math|z<rsub|1>=<sqrt|z|k<rsub|1>>,\<ldots\>,z<rsub|p>=<sqrt|z|k<rsub|p>>>,
  <math|k<rsub|1>\<gtr\>\<cdots\>\<gtr\>k<rsub|p>>, and all integrals taken
  on the positive real axis. The accelero-sum <math|f> is defined in some
  sector

  <\equation*>
    \<cal-S\><rsub|R,\<alpha\>>\<assign\>\<cal-S\><rsub|R,0,\<alpha\>>
  </equation*>

  for any <math|\<alpha\>\<gtr\>0> with <math|\<alpha\>\<less\>k<rsub|p>*\<mathpi\>/2>.

  For any fixed <math|z\<in\>\<bbb-D\><around*|[|\<mathi\>|]>\<cap\>\<cal-S\><rsub|R,\<alpha\>>>,
  the accelero-summation process from<nbsp><cite|vdH:reshol> provides us with
  an algorithm to compute <math|n> digits of <math|f<around*|(|z|)>> in time
  <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>. In
  Section<nbsp><reference|unif-accsum-sec>, we will show that this complexity
  is uniform in <math|z>, provided that <math|n<rsup|k<rsub|p>>\<geqslant\>\<beta\><rsub|p>/<around*|\||z|\|>>
  for some computable constant <math|\<beta\><rsub|p>\<gtr\>0>. In other
  words: accelero-summation is a good numerical scheme under the condition
  that we really need a lot of digits. In<nbsp><cite|vdH:reshol>, we also
  showed that the technique of \Psummation until the least
  term\Q<nbsp><cite|Poin1886> allows to compute <math|n> digits of
  <math|f<around*|(|z|)>> in time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|2>
  n|)>>, provided that <math|n<rsup|k<rsub|1>>\<leqslant\>\<beta\><rsub|1>/<around*|\||z|\|>>
  for some computable constant <math|\<beta\><rsub|1>\<gtr\>0>. This
  complexity bound is also uniform in <math|z>.

  The above uniform complexity bounds still leave a gap for precisions
  <math|n> between <rigid|<math|<around*|(|\<beta\><rsub|1>/<around*|\||z|\|>|)><rsup|1/k<rsub|1>>>>
  and <math|<around*|(|\<beta\><rsub|p>/<around*|\||z|\|>|)><rsup|1/k<rsub|p>>>.
  In order to fill this gap, we introduce the technique of expedito-summation
  in Section<nbsp><reference|expedito-sum-sec>. Roughly speaking, we perform
  the accelero-summation process until some critical time <math|z<rsub|q>>
  with <math|1\<leqslant\>q\<less\>p> and then \Pexpedite\Q the process by
  directly taking a truncated Laplace transform with respect to
  <math|\<zeta\><rsub|q>>. We will show in
  Section<nbsp><reference|expedito-complexity-sec> that there exist
  computable constants <math|\<beta\><rsub|2>,\<ldots\>,\<beta\><rsub|p-1>>
  such that expedito-summation until the critical time <math|z<rsub|q>>
  allows us compute <math|n> digits of <math|f<around*|(|z|)>> in time
  <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>, uniformly
  in <math|z> provided that <math|<around*|(|\<beta\><rsub|q>/<around*|\||z|\|>|)><rsup|1/k<rsub|q>>\<leqslant\>n\<leqslant\><around*|(|\<beta\><rsub|q+1>/<around*|\||z|\|>|)><rsup|1/k<rsub|q+1>>>.

  <subsection*|Notational conventions>

  This paper should be regarded as a supplement to<nbsp><cite|vdH:reshol>.
  For this reason, and as we already stressed before, we will freely use
  concepts and notations from that paper. In this area it also frequently
  happens that there exist algorithms to explicitly compute various constants
  involved in error bounds, but that the precise values of these constants
  are irrelevant. In<nbsp><cite|vdH:reshol>, we strived to make all error
  bounds as explicit as possible, but in this paper we will simply denote
  strictly positive constants of this kind by <math|<value|cst>>. In
  analysis, the habit to write <math|O<around*|(|1|)>> for \Psome bounded
  function\Q is somewhat analoguous. For instance, given a real
  function<nbsp><math|f> and a constant <math|\<sigma\>\<in\>\<bbb-Q\>>,
  saying that

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\||f<around*|(|x|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|<value|cst>*x>>>>>
  </eqnarray*>

  for all <math|x\<geqslant\>\<sigma\>> means that we can compute an explicit
  exponential bound for <math|f<around*|(|x|)>> on the interval
  <math|<around*|[|\<sigma\>,\<infty\>|)>>.

  <\acknowledgments*>
    We wish to like Grgoire <name|Lecerf> for some helpful remarks.
  </acknowledgments*>

  <section|Expedito-summation><label|expedito-sum-sec>

  Throughout this and the next section, we make the following assumptions:

  <\itemize>
    <item><math|<wide|f|~>\<in\>\<bbb-K\><around*|[|<around*|[|z<rsup|1/\<kappa\>>|]>|]><around*|[|log
    z|]>> with <math|\<kappa\>\<in\><around*|{|1,2,\<ldots\>|}>> is a formal
    solution to <math|L <wide|f|~>=0>.

    <item><math|<wide|f|~>> is accelero-summable with critical times
    <math|z<rsub|1>=<sqrt|z|k<rsub|1>>,\<ldots\>,z<rsub|p>=<sqrt|z|k<rsub|p>>>
    and <math|k<rsub|1>\<gtr\>\<cdots\>\<gtr\>k<rsub|p>>.

    <item>The holonomic equations satisfied by the Borel counterparts
    <math|<wide|f|^><rsub|1>,\<ldots\>,<wide|f|^><rsub|p>> at the various
    critical times admit no singularities on the positive real axis.

    <item>All acceleration integrals and the final Laplace transforms are
    performed on the positive real axis.
  </itemize>

  <subsection|Introduction to expedito-summation>

  In<nbsp><cite|vdH:reshol>, we provided a detailed analysis of two summation
  methods of <math|<wide|f|~>>. The usual accelero-summation process
  associates the accelero-sum <math|f=accsum <wide|f|~>> to <math|<wide|f|~>>
  using

  <\eqnarray*>
    <tformat|<table|<row|<cell|accsum <wide|f|~>>|<cell|=>|<cell|<around*|(|<wide|\<cal-L\>|\<check\>><rsub|k<rsub|p>>\<circ\><wide|\<cal-A\>|\<check\>><rsub|k<rsub|p-1>,k<rsub|p>>\<circ\>\<cdots\>\<circ\><wide|\<cal-A\>|\<check\>><rsub|k<rsub|1>,k<rsub|2>>\<circ\><wide|\<cal-B\>|\<check\>><rsub|k<rsub|1>>|)><around*|(|<wide|f|~>|)>.>>>>
  </eqnarray*>

  In the appendix, we also considered \Psummation up to the least term\Q:
  given <math|N\<in\>\<bbb-N\>>, one may approximate <math|accsum <wide|f|~>>
  by <math|sum<rsub|N> <wide|f|~>>, where

  <\equation*>
    <around|(|sum<rsub|N> <wide|f|~>|)><around|(|z|)>=<wide|f<rsub|0>|~>+\<cdots\>+<wide|f|~><rsub|N>*z<rsup|N>.
  </equation*>

  Taking <math|N=<around|(|<value|cst>*<around|\||z|\|>|)><rsup|\<um\>1/k<rsub|1>>>,
  we proved that

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\||<around*|(|sum<rsub|N>
    <wide|f|~>-accsum <wide|f|~>|)><around*|(|z|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<around|(|<value|cst>*<around|\||z|\|>|)><rsup|\<um\>1/k<rsub|1>>>,>>>>
  </eqnarray*>

  for all <math|z\<in\><around*|(|0,<value|cst>|]>>.

  Summation up to the least term completely shortcuts the whole
  accelero-summation process. It provides approximations of a precision that
  correspond to stopping the accelero-summation process at the first
  singularity for the first critical time. It is natural to consider more
  general shortcuts, where we perform the usual accelero-summation process up
  till a<nbsp>given critical time <math|z<rsub|q>> and then \Pexpedite\Q the
  remainer of the process by directly performing a truncated Laplace
  transform on <math|\<zeta\><rsub|q>\<in\><around*|(|0,\<Zeta\><rsub|q>|]>>
  for a suitable <math|\<Zeta\><rsub|q>\<in\>\<bbb-R\><rsup|\<gtr\>>>. More
  precisely, given <math|q\<in\><around*|{|1,\<ldots\>,p-1|}>> and
  <math|\<Zeta\><rsub|q>\<in\>\<bbb-R\><rsup|\<gtr\>>>, we define

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|(|exsum<rsub|q,\<Zeta\><rsub|q>>
    <wide|f|~>|)><around*|(|z<rsub|q>|)>>|<cell|=>|<cell|<around*|[|<around*|(|<wide|\<cal-L\>|\<check\>><rsub|k<rsub|q>,\<Zeta\><rsub|q>>\<circ\><wide|\<cal-A\>|\<check\>><rsub|k<rsub|q-1>,k<rsub|q>>\<circ\>\<cdots\>\<circ\><wide|\<cal-A\>|\<check\>><rsub|k<rsub|1>,k<rsub|2>>\<circ\><wide|\<cal-B\>|\<check\>><rsub|k<rsub|1>>|)><around*|(|<wide|f|~>|)>|)><around*|(|z<rsub|q>|)>>>|<row|<cell|<around*|(|<wide|\<cal-L\>|\<check\>><rsub|k<rsub|q>,\<Zeta\><rsub|q>>
    <wide|f|\<check\>><rsub|k<rsub|q>>|)><around*|(|z<rsub|q>|)>>|<cell|=>|<cell|<big|int><rsub|\<cal-H\><rsub|\<Zeta\><rsub|q>>><wide|f|\<check\>><rsub|q><around*|(|\<zeta\><rsub|q>|)>*\<mathe\><rsup|-\<zeta\><rsub|q>/z<rsub|q>>*\<mathd\>
    \<zeta\><rsub|q>.>>>>
  </eqnarray*>

  Here <math|\<cal-H\><rsub|\<Zeta\><rsub|q>>> denotes the contour from
  <math|\<Zeta\><rsub|q>> to <math|\<varepsilon\>\<gtr\>0>, turning around
  <math|0> and then back from <math|\<varepsilon\>> to
  <math|\<Zeta\><rsub|q>>.

  As for summation to the least term, it is natural to chose
  <math|\<Zeta\><rsub|q>> such that <math|<around*|\||<wide|f|^><rsub|q><around*|(|\<zeta\><rsub|q>|)>*\<mathe\><rsup|-\<zeta\><rsub|q>/z<rsub|q>>|\|>>
  is minimal. Since <math|<wide|f|^><rsub|q><around*|(|\<zeta\><rsub|q>|)>>
  satisfies a bound of the form

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\||<wide|f|^><rsub|q><around*|(|\<zeta\><rsub|q>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|<value|cst>*\<zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|q+1>>>>>>>>
  </eqnarray*>

  at infinity, this means that we should take
  <math|<value|cst>\<leqslant\>\<Zeta\><rsub|q>\<leqslant\>\<Zeta\><rsub|opt>>,
  where

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<Zeta\><rsub|opt>>|<cell|=>|<cell|<value|cst>*<around*|\||z<rsub|q>|\|><rsup|-<frac|k<rsub|q>-k<rsub|q+1>|k<rsub|q+1>>><space|0.6spc>=<space|0.6spc><value|cst>*<around*|\||z<rsub|q+1>|\|><rsup|-<frac|k<rsub|q>-k<rsub|q+1>|k<rsub|q>>>.>>>>
  </eqnarray*>

  Our main aim is to prove the error bound

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\||<around*|(|exsum<rsub|q,\<Zeta\><rsub|q>>
    <wide|f|~>-accsum <wide|f|~>|)><around*|(|z|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q>/<around*|\||z<rsub|q>|\|>>+<value|cst>*\<mathe\><rsup|-<value|cst>/<around*|\||z<rsub|q+1>|\|>>,>>>>
  </eqnarray*>

  for <math|z\<in\><around*|(|0,<value|cst>|]>>. When taking
  <math|\<Zeta\><rsub|q>=\<Zeta\><rsub|opt>>, this bound further simplifies
  to

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\||<around*|(|exsum<rsub|q,\<Zeta\><rsub|q>>
    <wide|f|~>-accsum <wide|f|~>|)><around*|(|z|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>/<around*|\||z<rsub|q+1>|\|>>.>>>>
  </eqnarray*>

  <subsection|The expedited approximation>

  <paragraph|The truncated Laplace transform>Let
  <math|<wide|g|\<check\>><rsub|q><around*|(|\<zeta\><rsub|q>|)>=<wide|f|\<check\>><rsub|q><around*|(|\<zeta\><rsub|q>|)>>
  for <math|Re \<zeta\><rsub|q>\<leqslant\>\<Zeta\><rsub|q>> and
  <math|<wide|g|\<check\>><rsub|q><around*|(|\<zeta\><rsub|q>|)>=0> for
  <math|Re \<zeta\><rsub|q>\<gtr\>\<Zeta\><rsub|q>>, so that

  <\eqnarray*>
    <tformat|<table|<row|<cell|g<around*|(|z|)><space|0.6spc>\<assign\><space|0.6spc>g<rsub|q><around*|(|z<rsub|q>|)>>|<cell|\<assign\>>|<cell|<around*|(|<wide|\<cal-L\>|\<check\>><rsub|k<rsub|q>>
    <wide|g|\<check\>><rsub|q>|)><around*|(|z<rsub|q>|)><space|0.6spc>=<space|0.6spc><around*|(|<wide|\<cal-L\>|\<check\>><rsub|k<rsub|q>,\<Zeta\><rsub|q>>
    <wide|f|\<check\>><rsub|q>|)><around*|(|z<rsub|q>|)>.>>>>
  </eqnarray*>

  Since we know how to compute a bound for
  <math|<around*|\||<wide|g|\<check\>>|\|>> on the contour
  <math|\<cal-H\><rsub|\<Zeta\><rsub|q>>>, we may compute an explicit bound
  of the form

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\||g<rsub|q><around*|(|z<rsub|q>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|<value|cst>/<around*|\||z<rsub|q>|\|>><eq-number><label|gq-bnd>>>>>
  </eqnarray*>

  for <math|z<rsub|q>> on a small positive sector near zero.

  <paragraph|Borel transforms of <math|g> at other critical times>For
  <math|i=q+1,\<ldots\>,p>, we define

  <\eqnarray*>
    <tformat|<table|<row|<cell|<wide|g|^><rsub|i><around*|(|\<zeta\><rsub|i>|)>>|<cell|\<assign\>>|<cell|<around*|(|<wide|\<cal-A\>|^><rsub|k<rsub|q>,k<rsub|i>>
    <wide|g|\<check\>><rsub|q>|)><around*|(|\<zeta\><rsub|i>|)><space|0.6spc>=<space|0.6spc><around*|(|<wide|\<cal-A\>|^><rsub|k<rsub|q>,k<rsub|i>,\<Zeta\><rsub|q>>
    <wide|f|\<check\>><rsub|q>|)><around*|(|\<zeta\><rsub|i>|)>,>>>>
  </eqnarray*>

  where

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|(|<wide|\<cal-A\>|^><rsub|k<rsub|q>,k<rsub|i>,\<Zeta\><rsub|q>>
    <wide|f|\<check\>><rsub|q>|)><around*|(|\<zeta\><rsub|i>|)>>|<cell|=>|<cell|<big|int><rsub|\<cal-H\><rsub|\<Zeta\><rsub|q>>><wide|f|\<check\>><rsub|q><around*|(|\<zeta\><rsub|q>|)>*<wide|\<cal-A\>|^><rsub|k<rsub|q>,k<rsub|i>><around*|(|\<zeta\><rsub|q>,\<zeta\><rsub|i>|)>*\<mathd\>
    \<zeta\><rsub|q>.>>>>
  </eqnarray*>

  We may also represent <math|<wide|g|^><rsub|i>> as the analytic Borel
  transform of <math|g<rsub|i><around*|(|z<rsub|i>|)>=g<rsub|q><around*|(|z<rsub|q>|)>>
  with respect to<nbsp><math|z<rsub|i>>. Using the
  bound<nbsp>(<reference|gq-bnd>), this allows us to compute a bound

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\||<wide|g|^><rsub|i><around*|(|\<zeta\><rsub|i>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|<value|cst>*\<zeta\><rsub|i>><eq-number><label|gi-exp-bnd>>>>>
  </eqnarray*>

  for <math|\<zeta\><rsub|i>\<in\><around*|[|<value|cst>,\<infty\>|)>>.

  <paragraph|The difference between <math|f> and <math|g>>Let
  <math|\<delta\>\<assign\>g-f>. For <math|i=q,\<ldots\>,p>, we also define

  <\eqnarray*>
    <tformat|<table|<row|<cell|<wide|\<delta\>|^><rsub|i>>|<cell|\<assign\>>|<cell|<wide|g|^><rsub|i>-<wide|f|^><rsub|i>>>|<row|<cell|\<delta\><rsub|i>>|<cell|\<assign\>>|<cell|g<rsub|i>-f<rsub|i>.>>>>
  </eqnarray*>

  For <math|i=q>, and setting <math|c<rsub|i>=\<Zeta\><rsub|q>>, we thus have

  <\eqnarray*>
    <tformat|<table|<row|<cell|<wide|\<delta\>|^><rsub|i><around*|(|\<zeta\><rsub|i>|)>>|<cell|=>|<cell|0>>>>
  </eqnarray*>

  for <math|\<zeta\><rsub|i>\<in\><around*|(|0,c<rsub|i>|]>>. One major topic
  of this section will be to compute bounds at the origin
  for<nbsp><math|<around*|\||<wide|\<delta\>|^><rsub|i><around*|(|\<zeta\><rsub|i>|)>|\|>>
  and <math|i\<gtr\>q>.

  <paragraph|Behaviour of the <math|<wide|\<delta\>|^><rsub|i>> at
  infinity>Let <math|q\<leqslant\>i\<less\>p>. Combining the
  bound<nbsp>(<reference|gi-exp-bnd>) with the superexponential bound for
  <math|<wide|f|^><rsub|i>>, as provided by the accelero-summation process,
  we may compute a bound

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\||<wide|\<delta\>|^><rsub|i><around*|(|\<zeta\><rsub|i>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|<value|cst>*\<zeta\><rsub|i><rsup|<frac|k<rsub|i>|k<rsub|i>-k<rsub|i+1>>>><eq-number><label|di-exp-growth>>>>>
  </eqnarray*>

  for <math|\<zeta\><rsub|i>\<in\><around*|[|<value|cst>,\<infty\>|)>>.
  Notice that we may also compute a bound

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\||<wide|\<cal-A\>|^><rsub|k<rsub|i>,k<rsub|i+1>><around*|(|\<zeta\><rsub|i>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*<around*|<left|(|-2>|\<zeta\><rsub|i><rsup|<frac|k<rsub|i>|k<rsub|i>-k<rsub|i+1>>>/\<zeta\><rsub|i+1><rsup|<frac|k<rsub|i+1>|k<rsub|i>-k<rsub|i+1>>>|<right|)|-2>>><eq-number><label|acc-growth>>>>>
  </eqnarray*>

  for <math|\<zeta\><rsub|i>\<in\><around*|[|<value|cst>,\<infty\>|)>> and
  <math|\<zeta\><rsub|i+1>\<in\><around*|(|0,<value|cst>|]>>.

  <paragraph|Majorants for specific accelerates and Laplace transforms>The
  following bounds will be useful for proving precise error estimates for the
  <math|<wide|\<delta\>|^><rsub|i>> and <math|\<delta\><rsub|p>>. The proofs
  are a routine application of the saddle point technique.

  <\lemma>
    Let <math|z<rsub|q>> and <math|z<rsub|i>> be critical times with
    <math|q\<less\>i>. Then

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||<big|int><rsub|0><rsup|\<infty\>>\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|i><rsup|<frac|-k<rsub|i>|k<rsub|q>-k<rsub|i>>>>*\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|i>/<around*|\||z<rsub|i>|\|>>*\<mathd\>
      \<zeta\><rsub|i>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>/<around*|\||z<rsub|q>|\|>>,<eq-number><label|lapl-err>>>>>
    </eqnarray*>

    for all <math|<around*|\||z<rsub|q>|\|>\<in\><around*|(|0,<value|cst>|]>>.
    If <math|q+1\<less\>i>, then

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|<left|\||-2>|<big|int><rsub|0><rsup|\<infty\>>\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|i-1><rsup|<frac|-k<rsub|i-1>|k<rsub|q>-k<rsub|i-1>>>>*<wide|\<cal-A\>|^><rsub|k<rsub|i-1>,k<rsub|i>><around*|(|\<zeta\><rsub|i-1>,\<zeta\><rsub|i>|)>*\<mathd\>
      \<zeta\><rsub|i-1>|<right|\||-2>>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|i><rsup|<frac|-k<rsub|i>|k<rsub|q>-k<rsub|i>>>>,<eq-number><label|acc-err>>>>>
    </eqnarray*>

    for all <math|\<zeta\><rsub|i>\<in\><around*|(|0,<value|cst>|]>>.
  </lemma>

  <subsection|The first acceleration>

  <\lemma>
    <label|first-acc-lem>Let <math|i=q+1>. We can compute
    <math|c<rsub|i>\<gtr\>0> such that, for
    <math|\<zeta\><rsub|i>\<in\><around*|(|0,c<rsub|i>|]>>, we have

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||<wide|\<delta\>|^><rsub|i><around*|(|\<zeta\><rsub|i>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|i>>>*\<zeta\><rsub|i><rsup|<frac|-k<rsub|i>|k<rsub|q>-k<rsub|i>>>>.>>>>
    </eqnarray*>
  </lemma>

  <\proof>
    We have

    <\equation*>
      \;
    </equation*>

    <\eqnarray*>
      <tformat|<table|<row|<cell|<wide|\<delta\>|^><rsub|i><around*|(|\<zeta\><rsub|i>|)>>|<cell|=>|<cell|<around|(|<wide|\<cal-A\>|^><rsub|k<rsub|q>,k<rsub|i>>
      <around|(|<wide|\<delta\>|^><rsub|q>|)>|)><around*|(|\<zeta\><rsub|i>|)>>>|<row|<cell|>|<cell|=>|<cell|<big|int><rsub|\<Zeta\><rsub|q>><rsup|\<infty\>><wide|\<delta\>|^><rsub|q><around*|(|\<zeta\><rsub|q>|)>*<wide|\<cal-A\>|^><rsub|k<rsub|q>,k<rsub|i>><around*|(|\<zeta\><rsub|q>,\<zeta\><rsub|i>|)>*\<mathd\>
      \<zeta\><rsub|q>.>>>>
    </eqnarray*>

    Using<nbsp>(<reference|di-exp-growth>) and<nbsp>(<reference|acc-growth>),
    it follows that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||<wide|\<delta\>|^><rsub|i><around*|(|\<zeta\><rsub|i>|)>|\|>>|<cell|\<leqslant\>>|<cell|<around*|<left|\||-1>|<value|cst>*<big|int><rsub|\<Zeta\><rsub|q>><rsup|\<infty\>>\<mathe\><rsup|<value|cst>*\<zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|i>>>-<value|cst>*<around*|<left|(|-2>|\<zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|i>>>/\<zeta\><rsub|i><rsup|<frac|k<rsub|i>|k<rsub|q>-k<rsub|i>>>|<right|)|-2>>>*\<mathd\>
      \<zeta\><rsub|q>|<right|\||-1>>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|i>>>*\<zeta\><rsub|i><rsup|<frac|-k<rsub|i>|k<rsub|q>-k<rsub|i>>>>,>>>>
    </eqnarray*>

    on an interval <math|\<zeta\><rsub|i>\<in\><around*|(|0,c<rsub|i>|]>> for
    some computable <math|c<rsub|i>\<gtr\>0>.
  </proof>

  <subsection|Subsequent accelerations>

  <\lemma>
    <label|next-acc-lem>For each <math|i\<gtr\>q+1>, we can compute a
    constant <math|c<rsub|i>\<gtr\>0>, together with a bound

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||<wide|\<delta\>|^><rsub|i><around*|(|\<zeta\><rsub|i>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|i>>>*\<zeta\><rsub|i><rsup|<frac|-k<rsub|i>|k<rsub|q>-k<rsub|i>>>>+<value|cst>*\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|i><rsup|<frac|-k<rsub|i>|k<rsub|q+1>-k<rsub|i>>>>>>>>
    </eqnarray*>

    for <math|\<zeta\><rsub|i>\<in\><around*|(|0,c<rsub|i>|]>>.
  </lemma>

  <\proof>
    We will prove the lemma by induction over <math|i>. We have

    <\equation*>
      \;
    </equation*>

    <\eqnarray*>
      <tformat|<table|<row|<cell|<wide|\<delta\>|^><rsub|i><around*|(|\<zeta\><rsub|i>|)>>|<cell|=>|<cell|<around|(|<wide|\<cal-A\>|^><rsub|k<rsub|i-1>,k<rsub|i>>
      <around|(|<wide|\<delta\>|^><rsub|i-1>|)>|)><around*|(|\<zeta\><rsub|i>|)><space|0.6spc>=<space|0.6spc>I<rsub|1><around*|(|\<zeta\><rsub|i>|)>+I<rsub|2><around*|(|\<zeta\><rsub|i>|)>,>>>>
    </eqnarray*>

    where

    <\eqnarray*>
      <tformat|<table|<row|<cell|I<rsub|1><around*|(|\<zeta\><rsub|i>|)>>|<cell|\<assign\>>|<cell|<big|int><rsub|0><rsup|c<rsub|i-1>><wide|\<delta\>|^><rsub|i-1><around*|(|\<zeta\><rsub|i-1>|)>*<wide|\<cal-A\>|^><rsub|k<rsub|i-1>,k<rsub|i>><around*|(|\<zeta\><rsub|i-1>,\<zeta\><rsub|i>|)>*\<mathd\>
      \<zeta\><rsub|i-1>>>|<row|<cell|I<rsub|2><around*|(|\<zeta\><rsub|i>|)>>|<cell|\<assign\>>|<cell|<big|int><rsub|c<rsub|i-1>><rsup|\<infty\>><wide|\<delta\>|^><rsub|i-1><around*|(|\<zeta\><rsub|i-1>|)>*<wide|\<cal-A\>|^><rsub|k<rsub|i-1>,k<rsub|i>><around*|(|\<zeta\><rsub|i-1>,\<zeta\><rsub|i>|)>*\<mathd\>
      \<zeta\><rsub|i-1>>>>>
    </eqnarray*>

    If <math|i=q+2>, then Lemma<nbsp><reference|first-acc-lem> yields a bound

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||<wide|\<delta\>|^><rsub|i-1><around*|(|\<zeta\><rsub|i-1>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|i-1>>>*\<zeta\><rsub|i-1><rsup|<frac|-k<rsub|i-1>|k<rsub|q>-k<rsub|i-1>>>>,>>>>
    </eqnarray*>

    for <math|\<zeta\><rsub|i-1>\<in\><around*|(|0,c<rsub|i-1>|]>>. For
    <math|i\<gtr\>q+2>, the induction hypothesis yields the bound

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||<wide|\<delta\>|^><rsub|i-1><around*|(|\<zeta\><rsub|i-1>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|i-1>>>*\<zeta\><rsub|i-1><rsup|<frac|-k<rsub|i-1>|k<rsub|q>-k<rsub|i-1>>>>+<value|cst>*\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|i-1><rsup|<frac|-k<rsub|i-1>|k<rsub|q+1>-k<rsub|i-1>>>>,>>>>
    </eqnarray*>

    for <math|\<zeta\><rsub|i-1>\<in\><around*|(|0,c<rsub|i-1>|]>>. Now, in
    view of (<reference|acc-err>), we may compute a suffiently small
    <math|c<rsub|i>\<gtr\>0> such that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|<left|\||-2>|<big|int><rsub|0><rsup|c<rsub|i-1>>\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|i-1>>>*\<zeta\><rsub|i-1><rsup|<frac|-k<rsub|i-1>|k<rsub|q>-k<rsub|i-1>>>>*<wide|\<cal-A\>|^><rsub|k<rsub|i-1>,k<rsub|i>><around*|(|\<zeta\><rsub|i-1>,\<zeta\><rsub|i>|)>*\<mathd\>
      \<zeta\><rsub|i-1>|<right|\||-2>>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|i>>>*\<zeta\><rsub|i><rsup|<frac|-k<rsub|i>|k<rsub|q>-k<rsub|i>>>>,>>>>
    </eqnarray*>

    for all <math|\<zeta\><rsub|i>\<in\><around*|(|0,c<rsub|i>|]>>. If
    <math|i\<gtr\>q+2>, then a similar computation yields

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|<left|\||-2>|<big|int><rsub|0><rsup|c<rsub|i-1>>\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|i-1><rsup|<frac|-k<rsub|i-1>|k<rsub|q+1>-k<rsub|i-1>>>>*<wide|\<cal-A\>|^><rsub|k<rsub|i-1>,k<rsub|i>><around*|(|\<zeta\><rsub|i-1>,\<zeta\><rsub|i>|)>*\<mathd\>
      \<zeta\><rsub|i-1>|<right|\||-2>>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|i><rsup|<frac|-k<rsub|i>|k<rsub|q+1>-k<rsub|i>>>>,>>>>
    </eqnarray*>

    for all <math|\<zeta\><rsub|i>\<in\><around*|(|0,c<rsub|i>|]>>, modulo a
    decrease of <math|c<rsub|i>> if necessary. Putting these bounds together,
    we obtain

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||I<rsub|1><around*|(|\<zeta\><rsub|i>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|i>>>*\<zeta\><rsub|i><rsup|<frac|-k<rsub|i>|k<rsub|q>-k<rsub|i>>>>+<value|cst>*\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|i><rsup|<frac|-k<rsub|i>|k<rsub|q+1>-k<rsub|i>>>>>>>>
    </eqnarray*>

    for <math|\<zeta\><rsub|i>\<in\><around*|(|0,c<rsub|i>|]>>.
    Using<nbsp>(<reference|di-exp-growth>) and<nbsp>(<reference|acc-growth>),
    we may also compute a bound

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||I<rsub|2><around*|(|\<zeta\><rsub|i>|)>|\|>>|<cell|\<leqslant\>>|<cell|<around*|<left|\||-1>|<value|cst>*<big|int><rsub|c<rsub|i-1>><rsup|\<infty\>>\<mathe\><rsup|<value|cst>*\<zeta\><rsub|i-1><rsup|<frac|k<rsub|i-1>|k<rsub|i-1>-k<rsub|i>>>-<value|cst>*<around*|<left|(|-2>|\<zeta\><rsub|i-1><rsup|<frac|k<rsub|i-1>|k<rsub|i-1>-k<rsub|i>>>/\<zeta\><rsub|i><rsup|<frac|k<rsub|i>|k<rsub|i-1>-k<rsub|i>>>|<right|)|-2>>>*\<mathd\>
      \<zeta\><rsub|i-1>|<right|\||-1>>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|i><rsup|<frac|-k<rsub|i>|k<rsub|i-1>-k<rsub|i>>>>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|i><rsup|<frac|-k<rsub|i>|k<rsub|q+1>-k<rsub|i>>>>>>>>
    </eqnarray*>

    for <math|\<zeta\><rsub|i>\<in\><around*|(|0,c<rsub|i>|]>>, modulo a
    further decrease of <math|c<rsub|i>> if necessary, and where we used the
    fact that <math|k<rsub|q+1>\<geqslant\>k<rsub|i-1>>. Combining the bounds
    for <math|I<rsub|1>> and <math|I<rsub|2>>, the result follows.
  </proof>

  <subsection|The final Laplace transform>

  <\lemma>
    <label|lapl-lem>For any aperture <math|\<alpha\>\<in\><around*|(|0,\<mathpi\>/2|)>\<cap\>\<bbb-Q\>>,
    we can compute a <math|\<sigma\>\<gtr\>0> and a bound

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||\<delta\><rsub|p><around*|(|z<rsub|p>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q>/<around*|\||z<rsub|q>|\|>>+<value|cst>*\<mathe\><rsup|-<value|cst>/<around*|\||z<rsub|q+1>|\|>>>>>>
    </eqnarray*>

    for all <math|z<rsub|p>\<in\>\<cal-S\><rsub|\<sigma\>,\<alpha\>>>.
  </lemma>

  <\proof>
    We have

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<delta\><rsub|p><around*|(|z<rsub|p>|)>>|<cell|=>|<cell|<around|(|<wide|\<cal-L\>|^><rsub|k<rsub|p>>
      <around|(|<wide|\<delta\>|^><rsub|p>|)>|)><around*|(|z<rsub|p>|)><space|0.6spc>=<space|0.6spc>I<rsub|1><around*|(|z<rsub|p>|)>+I<rsub|2><around*|(|z<rsub|p>|)>,>>>>
    </eqnarray*>

    where

    <\eqnarray*>
      <tformat|<table|<row|<cell|I<rsub|1><around*|(|z<rsub|p>|)>>|<cell|\<assign\>>|<cell|<big|int><rsub|0><rsup|c<rsub|p>><wide|\<delta\>|^><rsub|p><around*|(|\<zeta\><rsub|p>|)>*\<mathe\><rsup|-\<zeta\><rsub|p>/z<rsub|p>>*\<mathd\>
      \<zeta\><rsub|p>>>|<row|<cell|I<rsub|2><around*|(|z<rsub|p>|)>>|<cell|\<assign\>>|<cell|<big|int><rsub|c<rsub|p>><rsup|\<infty\>><wide|\<delta\>|^><rsub|p><around*|(|\<zeta\><rsub|p>|)>*\<mathe\><rsup|-\<zeta\><rsub|p>/z<rsub|p>>*\<mathd\>
      \<zeta\><rsub|p>.>>>>
    </eqnarray*>

    Using Lemma<nbsp><reference|next-acc-lem>
    and<nbsp>(<reference|lapl-err>), we can compute <math|\<sigma\>\<gtr\>0>
    and a bound

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||I<rsub|1><around*|(|z<rsub|p>|)>|\|>>|<cell|\<leqslant\>>|<cell|<big|int><rsub|0><rsup|c<rsub|p>><around*|<left|(|-1>|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|p>>>*\<zeta\><rsub|p><rsup|<frac|-k<rsub|p>|k<rsub|q>-k<rsub|p>>>>+<value|cst>*\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|p><rsup|<frac|-k<rsub|p>|k<rsub|q+1>-k<rsub|p>>>>|<right|)|-1>>*<around*|\||\<mathe\><rsup|-\<zeta\><rsub|p>/z<rsub|p>>|\|>*\<mathd\>
      \<zeta\><rsub|p>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<big|int><rsub|0><rsup|c<rsub|p>><around*|<left|(|-1>|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q><rsup|<frac|k<rsub|q>|k<rsub|q>-k<rsub|p>>>*\<zeta\><rsub|p><rsup|<frac|-k<rsub|p>|k<rsub|q>-k<rsub|p>>>>+<value|cst>*\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|p><rsup|<frac|-k<rsub|p>|k<rsub|q+1>-k<rsub|p>>>>|<right|)|-1>>*\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|p>/<around*|\||z<rsub|p>|\|>>*\<mathd\>
      \<zeta\><rsub|p>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q>/<around*|\||z<rsub|q>|\|>>+<value|cst>*\<mathe\><rsup|-<value|cst>/<around*|\||z<rsub|q+1>|\|>>>>>>
    </eqnarray*>

    for <math|z<rsub|p>\<in\>\<cal-S\><rsub|\<sigma\>,\<alpha\>>>.
    Using<nbsp>(<reference|gi-exp-bnd>) and the exponential bound for
    <math|<wide|f|^><rsub|p>> as provided by the accelero-summation process,
    we may also compute a bound

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||<wide|\<delta\>|^><around*|(|\<zeta\><rsub|p>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|<value|cst>*\<zeta\><rsub|p>>>>>>
    </eqnarray*>

    for <math|\<zeta\><rsub|p>\<in\><around*|[|<around*|\<nobracket\>|c<rsub|p>,\<infty\>|)>|\<nobracket\>>>.
    Modulo a further increase of <math|\<sigma\>> if necessary, this allows
    us to compute a<nbsp>bound

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||I<rsub|2><around*|(|z<rsub|p>|)>|\|>>|<cell|\<leqslant\>>|<cell|<big|int><rsub|c<rsub|p>><rsup|\<infty\>><value|cst>*\<mathe\><rsup|<value|cst>*\<zeta\><rsub|p>>*<around*|\||\<mathe\><rsup|-\<zeta\><rsub|p>/z<rsub|p>>|\|>*\<mathd\>
      \<zeta\><rsub|p>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<big|int><rsub|c<rsub|p>><rsup|\<infty\>><value|cst>*\<mathe\><rsup|<value|cst>*\<zeta\><rsub|p>>*\<mathe\><rsup|-<value|cst>*\<zeta\><rsub|p>/<around*|\||z<rsub|p>|\|>>*\<mathd\>
      \<zeta\><rsub|p>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>/<around*|\||z<rsub|p>|\|>>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>/<around*|\||z<rsub|q>|\|>>,>>>>
    </eqnarray*>

    for <math|z<rsub|p>\<in\>\<cal-S\><rsub|\<sigma\>,\<alpha\>>>. Adding up
    the bounds for <math|I<rsub|1>> and <math|I<rsub|2>>, the results
    follows.
  </proof>

  <\corollary>
    <label|lapl-cor>For any aperture <math|\<alpha\>\<in\><around*|(|0,\<mathpi\>/2|)>\<cap\>\<bbb-Q\>>,
    and assuming that

    <\equation*>
      <value|cst>\<leqslant\>\<Zeta\><rsub|q>\<leqslant\><value|cst>*<around*|\||z<rsub|q>|\|><rsup|-<frac|k<rsub|q>-k<rsub|q+1>|k<rsub|q+1>>>,
    </equation*>

    we can compute a <math|\<sigma\>\<gtr\>0> and a bound

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||\<delta\><rsub|p><around*|(|z<rsub|p>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q>/<around*|\||z<rsub|q>|\|>>>>>>
    </eqnarray*>

    for all <math|z<rsub|p>\<in\>\<cal-S\><rsub|\<sigma\>,\<alpha\>>>.
  </corollary>

  <\proof>
    This directly follows from the fact that
    <math|z<rsub|q><rsup|-<frac|k<rsub|q>-k<rsub|q+1>|k<rsub|q+1>>>/z<rsub|q>=z<rsub|q+1>>.
  </proof>

  <section|Uniform complexity on local sectors>

  <subsection|Uniform complexity of accelero-summation><label|unif-accsum-sec>

  <\proposition>
    <label|accsum-unif-prop>Let <math|\<alpha\>\<in\><around*|(|0,\<mathpi\>/2|)>\<cap\>\<bbb-D\>>
    be a fixed aperture and let <math|\<beta\><rsub|p>\<in\>\<bbb-D\><rsup|\<gtr\>>>.
    Then we can compute a constant <math|\<sigma\>\<gtr\>0> with the
    following property: given \ <math|z\<in\>\<bbb-D\><around*|[|\<mathi\>|]>>
    and <math|n\<geqslant\>size<around*|(|z|)>+<value|cst>> with

    <\equation*>
      \<beta\><rsub|p>/n<rsup|k<rsub|p>>\<leqslant\><around*|\||z|\|>\<leqslant\>\<sigma\>
    </equation*>

    and <math|<around*|\||arg z|\|>\<leqslant\>k<rsub|p>*\<alpha\>>, we can
    compute an approximation <math|v\<in\>\<bbb-D\><around*|[|\<mathi\>|]>>
    with <math|<around*|\||v-f<around*|(|z|)>|\|>\<leqslant\>2<rsup|-n>> in
    time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>,
    where the complexity bound holds uniformly in <math|z> under the above
    conditions.
  </proposition>

  <\proof>
    Recall that we may compute an exponential bound

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||<wide|f|^><rsub|p><around*|(|\<zeta\><rsub|p>|)>|\|>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|<value|cst>*\<zeta\><rsub|p>>>>>>
    </eqnarray*>

    for <math|<wide|f|^><rsub|p>> at infinity. For
    <math|\<Zeta\><rsub|p>=<value|cst>*n*<around*|\||z<rsub|p>|\|>> and
    <math|n\<geqslant\><value|cst>>, this yields a bound

    <\eqnarray*>
      <tformat|<table|<row|<cell|<big|int><rsub|\<Zeta\><rsub|p>><rsup|\<infty\>><around*|\||<wide|f|^><rsub|p><around*|(|\<zeta\><rsub|p>|)>|\|>*<around*|\||\<mathe\><rsup|-z<rsub|p>/\<zeta\><rsub|p>>|\|>*\<mathd\>
      \<zeta\><rsub|p>>|<cell|\<leqslant\>>|<cell|2<rsup|-n-1>.>>>>
    </eqnarray*>

    We now wish to compute <math|v> by approximating the truncated Laplace
    integral

    <\eqnarray*>
      <tformat|<table|<row|<cell|u>|<cell|\<assign\>>|<cell|<big|int><rsub|\<cal-H\><rsub|\<Zeta\><rsub|p>>><wide|f|\<check\>><rsub|p><around*|(|\<zeta\><rsub|p>|)>*\<mathe\><rsup|-z<rsub|p>/\<zeta\><rsub|p>>*\<mathd\>
      \<zeta\><rsub|p><eq-number><label|lapl-int>>>>>
    </eqnarray*>

    with precision <math|2<rsup|-n-1>>, <abbr|i.e.>
    <math|<around*|\||v-u|\|>\<leqslant\>2<rsup|-n-1>> and
    <math|<around*|\||v-f<around*|(|z|)>|\|>\<leqslant\>2<rsup|-n>>.

    Let us first consider the case when the bitsize of <math|z<rsub|p>> is
    bounded by <math|<value|cst>*log n>. Under the assumption that
    <math|<around*|\||z|\|>\<geqslant\>\<beta\><rsub|p>/n<rsup|k<rsub|p>>>,
    we observe that <math|\<Zeta\><rsub|p>\<geqslant\><value|cst>>. This
    implies that we can chose the contour
    <math|\<cal-H\><rsub|\<Zeta\><rsub|p>>> to use a circle of fixed radius
    around the origin (which does not depend on<nbsp><math|z<rsub|p>>). We
    next evaluate<nbsp>(<reference|lapl-int>) using the algorithm
    from<nbsp><cite-detail|vdH:reshol|Section<nbsp>6>. Our hypothesis that
    <math|size<around*|(|z<rsub|p>|)>=O<around*|(|log n|)>> implies that the
    primitive of <math|<wide|f|\<check\>><rsub|p><around*|(|\<zeta\><rsub|p>|)>*\<mathe\><rsup|-z<rsub|p>/\<zeta\><rsub|p>>>
    satisfies a holonomic equation of size <math|O<around*|(|log n|)>>,
    uniformly in <math|z<rsub|p>>. Consequently, it can be checked that the
    complexity bound from<nbsp><cite|vdH:reshol> holds uniformly in
    <math|z<rsub|p>>. This means that the required
    <math|2<rsup|-n-1>><nbhyph>approximation <math|v> of<nbsp><math|u> can be
    computed in time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3>
    n|)>>, uniformly in <math|z<rsub|p>>.

    For general <math|z>, we approximate <math|f<around*|(|z|)>> in two
    steps. Let <math|\<kappa\>=k<rsub|1>> be the growth rate of the linear
    differential equation satisfied by <math|f> at the origin. In
    <cite-detail|vdH:reshol|Theorem<nbsp>5.2>, we showed that in the sector
    <math|\<cal-S\>=\<cal-S\><rsub|<value|cst>,k<rsub|p>*\<alpha\>>>, we have
    the following bound for the transition matrix on a straightline path
    <math|z\<rightarrow\>z<rprime|'>> in <math|\<cal-S\>>:

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\<\|\|\>|\<Delta\><rsub|z\<rightarrow\>z<rprime|'>>|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<value|cst>*\<mathe\><rsup|<value|cst>*<around*|\||<around*|(|z<rprime|'>|)><rsup|-\<kappa\>>-z<rsup|-\<kappa\>>|\|>>.>>>>
    </eqnarray*>

    For <math|z<rprime|'>-z\<leqslant\><value|cst>*z<rsup|\<kappa\>+1>>, it
    follows that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\<\|\|\>|\<Delta\><rsub|z\<rightarrow\>z<rprime|'>>|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<value|cst>.<eq-number><label|trmat-bnd>>>>>
    </eqnarray*>

    Now let <math|z<rprime|'>\<in\>\<bbb-D\><around*|[|\<mathi\>|]>> be an
    approximation of<nbsp><math|z> with <math|z<rprime|'>-z\<leqslant\><value|cst>*z<rsup|\<kappa\>+1>>
    and <math|size<around*|(|z<rprime|'>|)>\<leqslant\><value|cst>*<around*|\||log
    <around*|\||z|\|>|\|>>. By what precedes, we may compute
    <math|2<rsup|-n-<value|cst>>>-approximations of
    <math|f<around*|(|z<rprime|'>|)>,\<ldots\>,f<rsup|<around*|(|r-1|)>><around*|(|z<rprime|'>|)>>
    in time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>,
    uniformly in <math|z>. Using the usual \Pbitburst\Q algorithm from
    <cite|CC90|vdH:hol|Mezza:phd>, together
    with<nbsp>(<reference|trmat-bnd>), it follows that we may compute a
    <math|2<rsup|-n>>-approximation of <math|f<around*|(|z|)>> using an
    additional time of <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|2>
    n|)>>, uniformly in <math|z>. Adding up these complexity bounds, the
    result follows.
  </proof>

  <subsection|Uniform complexity of summation until the least term>

  <\proposition>
    <label|ltsum-unif-prop>Let <math|\<alpha\>\<in\><around*|(|0,\<mathpi\>/2|)>\<cap\>\<bbb-D\>>.
    Then we may compute a constants <math|\<beta\><rsub|1>\<in\>\<bbb-D\><rsup|\<gtr\>>>
    such that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||<around*|(|sum<rsub|N>
      <wide|f|~>|)><around*|(|z|)>-f<around*|(|z|)>|\|>>|<cell|\<leqslant\>>|<cell|2<rsup|-n-1>>>>>
    </eqnarray*>

    for all <math|z\<in\>\<bbb-C\>>, <math|n\<geqslant\><value|cst>> and
    <math|N=<value|cst>*n> with

    <\equation*>
      <around*|\||z|\|>\<leqslant\>\<beta\><rsub|1>/n<rsup|k<rsub|1>>
    </equation*>

    and <math|<around*|\||arg z|\|>\<leqslant\>k<rsub|p>*\<alpha\>>.
    Moreover, if <math|z\<in\>\<bbb-D\><around*|[|\<mathi\>|]>> and
    <math|n\<geqslant\>size<around*|(|z|)>>, then we can compute an
    approximation <math|v\<in\>\<bbb-D\><around*|[|\<mathi\>|]>> with
    <math|<around*|\||v-<around*|(|sum<rsub|N>
    <wide|f|~>|)><around*|(|z|)>|\|>\<leqslant\>2<rsup|-n>> in time
    <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|2> n|)>>, where the
    complexity bound holds uniformly in <math|z> under the above conditions.
  </proposition>

  <\proof>
    Direct consequence of<nbsp><cite-detail|vdH:reshol|Theorem<nbsp>A.1>.
  </proof>

  <subsection|Uniform complexity of expedito-summation><label|expedito-complexity-sec>

  <\proposition>
    <label|exsum-unif-prop>Let <math|\<alpha\>\<in\><around*|(|0,\<mathpi\>/2|)>\<cap\>\<bbb-D\>>
    be a fixed aperture and let <math|\<beta\><rsub|q>\<in\>\<bbb-D\><rsup|\<gtr\>>>,
    where <math|q\<less\>p>. Then we may compute a constant
    <math|\<beta\><rsub|q+1>\<in\>\<bbb-D\><rsup|\<gtr\>>> such that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||<around*|(|exsum<rsub|q,\<Zeta\><rsub|q>>
      <wide|f|~>|)><around*|(|z|)>-f<around*|(|z|)>|\|>>|<cell|\<leqslant\>>|<cell|2<rsup|-n-1>>>>>
    </eqnarray*>

    for all <math|z\<in\>\<bbb-C\>> and <math|n\<geqslant\><value|cst>> with

    <\equation*>
      \<beta\><rsub|q>/n<rsup|k<rsub|q>>\<leqslant\><around*|\||z|\|>\<leqslant\>\<beta\><rsub|q+1>/n<rsup|k<rsub|q+1>>
    </equation*>

    and <math|<around*|\||arg z|\|>\<leqslant\>k<rsub|p>*\<alpha\>>, where

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<Zeta\><rsub|q>>|<cell|=>|<cell|<value|cst>*n*<around*|\||z<rsub|q>|\|>.>>>>
    </eqnarray*>

    Moreover, if <math|z\<in\>\<bbb-D\><around*|[|\<mathi\>|]>> and
    <math|n\<geqslant\>size<around*|(|z|)>>, then we can compute an
    approximation <math|v\<in\>\<bbb-D\><around*|[|\<mathi\>|]>> with
    <math|<around*|\||v-<around*|(|exsum<rsub|q,\<Zeta\><rsub|q>>
    <wide|f|~>|)><around*|(|z|)>|\|>\<leqslant\>2<rsup|-n-1>> in time
    <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>, where the
    complexity bound holds uniformly in <math|z> under the above conditions.
  </proposition>

  <\proof>
    Our hypothesis on <math|<around*|\||z|\|>> implies that

    <\equation*>
      <value|cst>\<leqslant\>\<Zeta\><rsub|q>\<leqslant\><value|cst>*<around*|\||z<rsub|q>|\|><rsup|-<frac|k<rsub|q>-k<rsub|q+1>|k<rsub|q+1>>>.
    </equation*>

    By Corollary<nbsp><reference|lapl-cor>, it follows that for all
    <math|z<rsub|p>> with <math|<around*|\||z|\|>=<around*|<left|\||-1>|z<rsub|p><rsup|k<rsub|p>>|<right|\||-1>>\<leqslant\><value|cst>>
    and <math|<around*|\||arg z|\|>=k<rsub|p>*<around*|\||arg
    z<rsub|p>|\|>\<leqslant\>k<rsub|p>*\<alpha\>>, we have

    <\equation*>
      <around*|\||<around*|(|exsum<rsub|q,\<Zeta\><rsub|q>>
      <wide|f|~>|)><around*|(|z|)>-f<around*|(|z|)>|\|><space|0.6spc>=<space|0.6spc><around*|\||\<delta\><rsub|p><around*|(|z<rsub|p>|)>|\|><space|0.6spc>=<space|0.6spc><value|cst>*\<mathe\><rsup|-<value|cst>*\<Zeta\><rsub|q>/<around*|\||z<rsub|q>|\|>><space|0.6spc>\<leqslant\><space|0.6spc>2<rsup|-n-1>.
    </equation*>

    For any suitable point <math|\<zeta\><rsub|q><rsup|init>> close to the
    origin and <math|i\<in\>\<bbb-N\>>, we have shown
    in<nbsp><cite|vdH:reshol> how to compute <math|n> decimal digits
    of<nbsp><math|<wide|f|\<check\>><rsub|q><rsup|<around*|(|i|)>><around*|(|\<zeta\><rsub|q><rsup|init>|)>>
    in time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>.
    This provides us with the required initial conditions for the analytic
    continuation of the integrant of the truncated Laplace integral

    <\eqnarray*>
      <tformat|<table|<row|<cell|u>|<cell|\<assign\>>|<cell|<big|int><rsub|\<cal-H\><rsub|\<Zeta\><rsub|q>>><wide|f|\<check\>><rsub|q><around*|(|\<zeta\><rsub|q>|)>*\<mathe\><rsup|-z<rsub|q>/\<zeta\><rsub|q>>*\<mathd\>
      \<zeta\><rsub|q>.>>>>
    </eqnarray*>

    In a similar way as in the proof of Proposition<nbsp><reference|accsum-unif-prop>,
    we may therefore approximate <math|u> to precision <math|2<rsup|-n-1>> in
    time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>,
    where the complexity bound is uniform in <math|z> under our conditions.
  </proof>

  <subsection|The combined local strategy>

  Putting Propositions<nbsp><reference|accsum-unif-prop>,
  <reference|ltsum-unif-prop> and<nbsp><reference|exsum-unif-prop> together,
  we obtain:

  <\theorem>
    <label|main-local-th>Let <math|\<alpha\>\<in\><around*|(|0,\<mathpi\>/2|)>\<cap\>\<bbb-D\>>
    be a fixed aperture. Then we may compute a constant
    <math|\<sigma\>\<in\>\<bbb-D\><rsup|\<gtr\>>> with the following
    property. Given <math|z\<in\>\<bbb-D\><around*|[|\<mathi\>|]><rsup|\<neq\>>>
    and <math|n\<in\>\<bbb-N\>> on input with <math|<around*|\||arg
    z|\|>\<leqslant\>k<rsub|p>*\<alpha\>> and
    <math|<around*|\||z|\|>\<leqslant\>\<sigma\>>, we may compute a
    <math|2<rsup|-n>>-approximation of <math|f<around*|(|z|)>> in time
    <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>, where the
    complexity bound holds uniformly in <math|z>.
  </theorem>

  <\proof>
    Let <math|\<sigma\>,\<beta\><rsub|1>,\<ldots\>,\<beta\><rsub|p>> be as in
    Propositions<nbsp><reference|ltsum-unif-prop>,
    <reference|exsum-unif-prop> and <reference|accsum-unif-prop>. For any
    <math|z\<in\>\<bbb-C\><rsup|\<neq\>>> with <math|<around*|\||arg
    z|\|>\<leqslant\>k<rsub|p>*\<alpha\>> and
    <math|<around*|\||z|\|>\<leqslant\>\<sigma\>>, at least one of the
    following three statements holds:

    <\enumerate>
      <item>We have <math|\<beta\><rsub|p>/n<rsup|k<rsub|p>>\<leqslant\><around*|\||z|\|>\<leqslant\>\<sigma\>>.

      <item>We have <math|\<beta\><rsub|q>/n<rsup|k<rsub|q>>\<leqslant\><around*|\||z|\|>\<leqslant\>\<beta\><rsub|q+1>/n<rsup|k<rsub|q+1>>>
      for some <math|q\<in\><around*|{|1,\<ldots\>,p-1|}>>.

      <item>We have <math|<around*|\||z|\|>\<leqslant\>\<beta\><rsub|1>/n<rsup|k<rsub|1>>>.
    </enumerate>

    In these cases we respectively apply Proposition<nbsp><reference|accsum-unif-prop>,
    <reference|exsum-unif-prop> or<nbsp><reference|ltsum-unif-prop> in order
    to obtain the desired result.
  </proof>

  <section|Globally efficient evaluation><label|global-sec>

  <subsection|Local analysis of cancellations>

  Assume that <math|L> is singular at the origin. Then for some
  <math|\<kappa\>\<in\>\<bbb-N\>>, there exists a basis of formal solutions
  of the form

  <\equation>
    <wide|b|~><rsub|i><around*|(|z|)>=<wide|\<varphi\>|~><rsub|i><around*|(|z|)>*z<rsup|\<lambda\><rsub|i>>*\<mathe\><rsup|P<rsub|i><around*|(|z<rsup|-1/\<kappa\>>|)>><label|formal-sol-basis>
  </equation>

  for <math|L f=0>, where <math|<wide|\<varphi\>|~><rsub|i><around*|(|z|)>\<in\>\<bbb-C\><around*|[|<around*|[|z<rsup|1/\<kappa\>>|]>|]><around*|[|log
  z|]>>, <math|\<lambda\><rsub|i>\<in\>\<bbb-C\>>,
  <math|P<rsub|i><around*|(|z<rsup|-1/\<kappa\>>|)>\<in\>\<bbb-C\><around*|[|z<rsup|-1/\<kappa\>>|]>>,
  and where <math|\<varphi\><rsub|i><around*|(|z|)>\<sim\><around*|(|log
  z|)><rsup|k<rsub|i>>> for some <math|k<rsub|i>\<in\>\<bbb-N\>>. Moreover,
  each <math|<wide|\<varphi\>|~><rsub|i>> belongs to the subset
  <math|\<bbb-A\>> of <math|\<bbb-C\><around*|[|<around*|[|z<rsup|1/\<kappa\>>|]>|]><around*|[|log
  z|]>> accelero-summable series.

  For each fixed accelero-summation scheme, there exist <math|\<rho\>>,
  <math|\<theta\>> and <math|\<alpha\>> such that the
  <math|<wide|\<varphi\>|~><rsub|i><around*|(|z|)>> and
  <math|<wide|b|~><rsub|i><around*|(|z|)>> give rise to analytic functions
  <math|\<varphi\><rsub|\<cal-S\>,i><around*|(|z|)>> and
  <math|b<rsub|\<cal-S\>,i><around*|(|z|)>> on the sector
  <math|\<cal-S\>=\<cal-S\><rsub|\<rho\>,\<theta\>,\<alpha\>>>. A
  sector<nbsp><math|\<cal-S\>> for which this happens is said to be
  <em|admissible>. Moreover, there exist a<nbsp>finite number of admissible
  sectors <math|\<cal-S\><rsub|\<rho\><rsub|1>,\<theta\><rsub|1>,\<alpha\><rsub|1>>,\<ldots\>,\<cal-S\><rsub|\<rho\><rsub|\<ell\>>,\<theta\><rsub|\<ell\>>,\<alpha\><rsub|\<ell\>>>>
  with <math|\<rho\><rsub|i>,\<mathe\><rsup|\<mathi\>*\<theta\><rsub|i>>,\<mathe\><rsup|\<mathi\>*\<alpha\><rsub|i>>\<in\>\<bbb-K\>>
  whose interiors cover a<nbsp>small neighbourhood
  of<nbsp><math|\<bbb-C\><rsup|\<neq\>>>. We will call this an <em|admissible
  cover>.

  Let <math|\<cal-S\>=\<cal-S\><rsub|\<rho\>,\<theta\>,\<alpha\>>> be one of
  the sectors in an admissible cover and let <math|\<varphi\><rsub|i>> and
  <math|b<rsub|i>> denote the accelero-sums of
  <math|<wide|\<varphi\>|~><rsub|i>> and <math|<wide|b|~><rsub|i>> on this
  sector. For each <math|i\<in\><around*|{|1,\<ldots\>,r|}>>, let
  <math|E<rsub|i><around*|(|z|)>=z<rsup|\<sigma\><rsub|i>>*\<mathe\><rsup|P<rsub|i><around*|(|z<rsup|-1/\<kappa\>>|)>>>.
  Let <math|\<cal-S\><rsub|Id>> denote the subset of all
  <math|z\<in\>\<cal-S\>> such that

  <\equation*>
    <around*|\||E<rsub|1><around*|(|z|)>|\|>\<geqslant\><around*|\||E<rsub|2><around*|(|z|)>|\|>\<geqslant\>\<cdots\>\<geqslant\><around*|\||E<rsub|r><around*|(|z|)>|\|>.
  </equation*>

  More generally, given a permutation <math|\<pi\>> of
  <math|<around*|{|1,\<ldots\>,r|}>>, let <math|\<cal-S\><rsub|\<pi\>>>
  denote the subset of all <math|z\<in\>\<cal-S\>> with

  <\equation*>
    <around*|\||E<rsub|\<pi\><around*|(|1|)>><around*|(|z|)>|\|>\<geqslant\><around*|\||E<rsub|\<pi\><around*|(|2|)>><around*|(|z|)>|\|>\<geqslant\>\<cdots\>\<geqslant\><around*|\||E<rsub|\<pi\><around*|(|r|)>><around*|(|z|)>|\|>.
  </equation*>

  Clearly, <math|\<cal-S\>=<big|cup><rsub|\<pi\>>\<cal-S\><rsub|\<pi\>>>.

  Let <math|f=\<lambda\><rsub|1>*b<rsub|1>+\<cdots\>+\<lambda\><rsub|r>*b<rsub|r>>
  be a non zero solution to <math|L f=0> on <math|\<cal-S\>> and let <math|F>
  be the column vectors with entries <math|f,f<rprime|'>,\<ldots\>,f<rsup|<around*|(|r-1|)>>>.
  Although <math|f> can vanish on <math|\<cal-S\>> due to cancellations among
  the terms <math|\<lambda\><rsub|i>*b<rsub|i>> and
  <math|\<lambda\><rsub|j>*b<rsub|j>>, the vector <math|F> cannot vanish
  unless <math|f=0>. We will now prove a stronger version of this observation
  by showing that the sup-norm <math|<around*|\<\|\|\>|F|\<\|\|\>>> of
  <math|F> cannot become much smaller than
  <math|<around*|\||E<rsub|1><around*|(|z|)>|\|>>.

  <\theorem>
    <label|vect-lower-bound-th>There exist constants <math|C\<gtr\>0> and
    <math|\<nu\>> such that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\<\|\|\>|F<around*|(|z|)>|\<\|\|\>>>|<cell|\<geqslant\>>|<cell|C*<around*|\||E<rsub|1><around*|(|z|)>*z<rsup|\<nu\>>|\|>,>>>>
    </eqnarray*>

    for all <math|z\<in\>\<cal-S\><rsub|Id>>.
  </theorem>

  <\proof>
    Without loss of generality, we may assume that
    <math|<around*|\||z|\|>\<leqslant\>1>. For each
    <math|k\<in\><around*|{|1,\<ldots\>,r|}>>, let<nbsp><math|W<rsub|r>> be
    the Wronskian matrix

    <\eqnarray*>
      <tformat|<table|<row|<cell|W<rsub|k><around*|(|z|)>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|b<rsub|1><around*|(|z|)>>|<cell|\<cdots\>>|<cell|b<rsub|k><around*|(|z|)>>>|<row|<cell|\<vdots\>>|<cell|>|<cell|\<vdots\>>>|<row|<cell|b<rsub|1><rsup|<around*|(|k-1|)>><around*|(|z|)>>|<cell|\<cdots\>>|<cell|b<rsub|k><rsup|<around*|(|k-1|)>><around*|(|z|)>>>>>>>>>>
    </eqnarray*>

    We may decompose

    <\eqnarray*>
      <tformat|<table|<row|<cell|W<rsub|k><around*|(|z|)>>|<cell|=>|<cell|U<rsub|k><around*|(|z|)>*\<Delta\><rsub|k><around*|(|z|)>,>>>>
    </eqnarray*>

    where

    <\equation*>
      \<Delta\><rsub|k><around*|(|z|)>=<matrix|<tformat|<table|<row|<cell|E<rsub|1><around*|(|z|)>>|<cell|>|<cell|>>|<row|<cell|>|<cell|\<ddots\>>|<cell|>>|<row|<cell|>|<cell|>|<cell|E<rsub|k><around*|(|z|)>>>>>>,
    </equation*>

    and where the entries of <math|U<rsub|k>> are in
    <math|\<bbb-A\>*z<rsup|-\<pi\><rsub|k>>> for some
    <math|\<pi\><rsub|k>\<in\>\<bbb-N\>> that only depends on the degrees of
    <math|P<rsub|1>,\<ldots\>,P<rsub|k>>. It follows that

    <\eqnarray*>
      <tformat|<table|<row|<cell|W<rsub|k><rsup|-1><around*|(|z|)>>|<cell|=>|<cell|\<Delta\><rsub|k><rsup|-1><around*|(|z|)>*<frac|adj<around*|(|U<rsub|k><around*|(|z|)>|)>|det<around*|(|U<rsub|k><around*|(|z|)>|)>>,>>>>
    </eqnarray*>

    where <math|det<around*|(|U<rsub|k><around*|(|z|)>|)>\<neq\>0> by the
    linear independence of <math|b<rsub|1>,\<ldots\>,b<rsub|k>>. Now
    <math|det<around*|(|U<rsub|k><around*|(|z|)>|)>> and the entries of
    <math|adj<around*|(|U<rsub|k><around*|(|z|)>|)>> are all elements of
    <math|\<bbb-A\>*z<rsup|-k*\<pi\><rsub|k>>>. It follows that there exists
    a constant <math|\<nu\><rsub|k>\<in\>\<bbb-R\>> such that
    <math|adj<around*|(|U<rsub|k><around*|(|z|)>|)>/det<around*|(|U<rsub|k><around*|(|z|)>|)>=O<around*|(|z<rsup|-\<nu\><rsub|k>>|)>>
    for all <math|z\<in\>\<cal-S\><rsub|Id>>.

    Now consider our fixed linear combination
    <math|f<around*|(|z|)>=\<lambda\><rsub|1>*b<rsub|1><around*|(|z|)>+\<cdots\>+\<lambda\><rsub|r>*b<rsub|r><around*|(|z|)>>
    and let

    <\equation*>
      \<Lambda\><rsub|k>=<matrix|<tformat|<table|<row|<cell|\<lambda\><rsub|1>>>|<row|<cell|\<vdots\>>>|<row|<cell|\<lambda\><rsub|k>>>>>>,<space|2em>G<rsub|k><around*|(|z|)>=<matrix|<tformat|<table|<row|<cell|g<rsub|k><around*|(|z|)>>>|<row|<cell|\<vdots\>>>|<row|<cell|<smash|g<rsub|k><rsup|<around*|(|k-1|)>><around*|(|z|)>>>>>>>,
    </equation*>

    where <math|g<rsub|k><around*|(|z|)>=\<lambda\><rsub|1>*b<rsub|1><around*|(|z|)>+\<cdots\>+\<lambda\><rsub|k>*b<rsub|k><around*|(|z|)>>,
    so that <math|F=G<rsub|r>> and <math|G<rsub|k>=W<rsub|k>*\<Lambda\><rsub|k>>.
    Also let <math|E<around*|(|z|)>> be the column vector with entries
    <math|E<rsub|1><around*|(|z|)>,\<ldots\>,E<rsub|r><around*|(|z|)>>. For
    the sup-norm on vectors, the above discussion shows that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\<\|\|\>|\<Lambda\><rsub|k>|\<\|\|\>>>|<cell|=>|<cell|O<around*|(|E<rsub|k><rsup|-1><around*|(|z|)>*z<rsup|-\<nu\><rsub|k>>*<around*|\<\|\|\>|G<rsub|k><around*|(|z|)>|\<\|\|\>>|)>.>>>>
    </eqnarray*>

    For some fixed constant <math|C<rsub|k>\<gtr\>0>, this means that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\<\|\|\>|G<rsub|k><around*|(|z|)>|\<\|\|\>>>|<cell|\<geqslant\>>|<cell|C<rsub|k>*<around*|\||E<rsub|k><around*|(|z|)>*z<rsup|\<nu\><rsub|k>>|\|>.<eq-number><label|Gk-bound>>>>>
    </eqnarray*>

    There also exist constants <math|M\<gtr\>0> and <math|\<mu\>> such that
    for all <math|k\<in\><around*|{|1,\<ldots\>,r|}>> and <math|i\<less\>r>,

    <\eqnarray*>
      <tformat|<table|<row|<cell|r*<around*|\||<around*|(|\<lambda\><rsub|k>*\<varphi\><rsub|k><around*|(|z|)>*E<rsub|k><around*|(|z|)>|)><rsup|<around*|(|i|)>>*E<rsub|k><around*|(|z|)><rsup|-1>|\|>>|<cell|\<leqslant\>>|<cell|M*<around*|\||z<rsup|\<mu\>>|\|>.<eq-number><label|derivatives-bnd>>>>>
    </eqnarray*>

    Now we may partition <math|\<cal-S\><rsub|Id>> into <math|r> subsets
    <math|\<cal-S\><rsub|Id,1>,\<ldots\>,\<cal-S\><rsub|Id,r>> as follows. By
    induction over <math|k>, we define <math|\<cal-S\><rsub|Id,k>> to be the
    subset of all <math|z\<in\>\<cal-S\><rsub|Id>\<setminus\><around*|(|\<cal-S\><rsub|Id,1>\<cup\>\<cdots\>\<cup\>\<cal-S\><rsub|Id,k-1>|)>>
    such that

    <\equation*>
      2*M*<around*|\||E<rsub|k+1><around*|(|z|)>*z<rsup|\<mu\>>|\|>\<less\>C<rsub|k>*<around*|\||E<rsub|k><around*|(|z|)>*z<rsup|\<nu\><rsub|k>>|\|>,
    </equation*>

    where we understand that <math|E<rsub|r+1><around*|(|z|)>=0>. If
    <math|z\<in\>\<cal-S\><rsub|Id,k>>, then it follows that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||E<rsub|2><around*|(|z|)>|\|>>|<cell|\<geqslant\>>|<cell|<around*|(|C<rsub|1>/2*M|)>*<around*|\||E<rsub|1><around*|(|z|)>*z<rsup|\<nu\><rsub|1>-\<mu\>>|\|>>>|<row|<cell|<around*|\||E<rsub|3><around*|(|z|)>|\|>>|<cell|\<geqslant\>>|<cell|<around*|(|C<rsub|1>*C<rsub|2>/4*M<rsup|2>|)>*<around*|\||E<rsub|1><around*|(|z|)>*z<rsup|\<nu\><rsub|1>+\<nu\><rsub|2>-2*\<mu\>>|\|>>>|<row|<cell|>|<cell|\<vdots\>>|<cell|>>|<row|<cell|<around*|\||E<rsub|k><around*|(|z|)>|\|>>|<cell|\<geqslant\>>|<cell|<around*|(|C<rsub|1>*\<cdots\>*C<rsub|k-1>/2<rsup|k-1>*M<rsup|k-1>|)>*<around*|\||E<rsub|1><around*|(|z|)>*z<rsup|\<nu\><rsub|1>+\<cdots\>+\<nu\><rsub|k-1>-<around*|(|k-1|)>*\<mu\>>|\|>>>>>
    </eqnarray*>

    Still for <math|z\<in\>\<cal-S\><rsub|Id,k>>, the
    relation<nbsp>(<reference|Gk-bound>) also implies the existence of an
    <math|i\<less\>k> such that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||g<rsub|k><rsup|<around*|(|i|)>><around*|(|z|)>|\|>>|<cell|\<geqslant\>>|<cell|C<rsub|k>*<around*|\||E<rsub|k><around*|(|z|)>*z<rsup|\<nu\><rsub|k>>|\|>.>>>>
    </eqnarray*>

    Using<nbsp>(<reference|derivatives-bnd>), it follows that

    <\eqnarray*>
      <tformat|<table|<row|<cell|>|<cell|>|<cell|2*<around*|\||<around*|(|f-g<rsub|k>|)><rsup|<around*|(|i|)>><around*|(|z|)>|\|>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|2*M*<around*|\||E<rsub|k+1><around*|(|z|)>*z<rsup|\<mu\>>|\|>>>|<row|<cell|>|<cell|\<less\>>|<cell|C<rsub|k>*<around*|\||E<rsub|k><around*|(|z|)>*z<rsup|\<nu\><rsub|k>>|\|>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<around*|\||g<rsub|k><rsup|<around*|(|i|)>><around*|(|z|)>|\|>,>>>>
    </eqnarray*>

    whence

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||f<rsup|<around*|(|i|)>><around*|(|z|)>|\|>>|<cell|\<geqslant\>>|<cell|<tfrac|1|2>*<around*|\||g<rsub|k><rsup|<around*|(|i|)>><around*|(|z|)>|\|>>>|<row|<cell|>|<cell|\<geqslant\>>|<cell|<tfrac|1|2>*C<rsub|k>*<around*|\||E<rsub|k><around*|(|z|)>*z<rsup|\<nu\><rsub|k>>|\|>>>|<row|<cell|>|<cell|\<geqslant\>>|<cell|<around*|(|C<rsub|1>*\<cdots\>*C<rsub|k>/2<rsup|k>*M<rsup|k-1>|)>*<around*|\||E<rsub|1><around*|(|z|)>*z<rsup|\<nu\><rsub|1>+\<cdots\>+\<nu\><rsub|k>-<around*|(|k-1|)>*\<mu\>>|\|>.>>>>
    </eqnarray*>

    We conclude that <math|<around*|\<\|\|\>|F<around*|(|z|)>|\<\|\|\>>\<geqslant\>C*<around*|\||E<rsub|1><around*|(|z|)>*z<rsup|\<nu\>>|\|>>
    for <math|C=min <around*|{|C<rsub|1>*\<cdots\>*C<rsub|k>/2<rsup|k>*M<rsup|k-1>:<around*|\<nobracket\>|1\<leqslant\>k\<leqslant\>r|\<nobracket\>>|}>>
    and <math|\<nu\>=max <around*|{|\<nu\><rsub|1>+\<cdots\>+\<nu\><rsub|k>-<around*|(|k-1|)>*\<mu\>:<around*|\<nobracket\>|1\<leqslant\>k\<leqslant\>r|\<nobracket\>>|}>>,
    using our assumption that <math|<around*|\||z|\|>\<leqslant\>1>.
  </proof>

  <\remark>
    It is plausible that a bound for <math|\<nu\>> can be stated in terms
    of<nbsp><math|\<kappa\>> and the degrees of
    <math|P<rsub|1>,\<ldots\>,P<rsub|r>>. We have not pursued this line of
    thought any further since any constant <math|\<nu\>> will do for our
    purposes.
  </remark>

  <subsection|Existence of zeros on disks>

  Consider the power series expansion <math|f<around*|(|z+t|)>=f<rsub|0>+f<rsub|1>*t+f<rsub|2>*t<rsup|2>+\<cdots\>>
  of <math|f> at <math|z>. For each <math|k\<in\>\<bbb-N\>>, let
  <math|\<Phi\><rsub|k>> be the vector with entries
  <math|f<rsub|k>,\<ldots\>,f<rsub|k+r-1>>.
  Theorem<nbsp><reference|vect-lower-bound-th> provides us with
  a<nbsp>uniform lower bound for <math|<around*|\<\|\|\>|\<Phi\><rsub|0>|\<\|\|\>>>
  in terms of <math|E<rsub|1>>. We also have the following upper bound for
  the remaining coefficients.

  <\lemma>
    <label|other-coeff-lem>There exist constants <math|\<varrho\>\<gtr\>0>,
    <math|A\<gtr\>0> and <math|\<tau\>\<in\>\<bbb-Z\>> such that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\<\|\|\>|\<Phi\><rsub|k>|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<around*|\<\|\|\>|\<Phi\><rsub|0>|\<\|\|\>>*<around*|\||A*z<rsup|\<tau\>>|\|><rsup|k>,>>>>
    </eqnarray*>

    for all <math|k\<in\>\<bbb-N\> and> <math|z\<in\>\<cal-S\>> with
    <math|<around*|\||z|\|>\<leqslant\>\<varrho\>>.
  </lemma>

  <\proof>
    Since <math|f> is holonomic, there exists a matrix <math|M<rsub|k>> with
    coefficients in <math|\<bbb-K\><around*|(|z|)><around*|[|k<rsup|-1>|]>>
    such that

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<Phi\><rsub|k+1>>|<cell|=>|<cell|M<rsub|k>*\<Phi\><rsub|k>.>>>>
    </eqnarray*>

    Consequently, there exists a uniform majorant equation for
    <math|\<Phi\><rsub|k+1>> of the form

    <\eqnarray*>
      <tformat|<table|<row|<cell|<wide|\<Phi\>|\<bar\>><rsub|k+1>>|<cell|=>|<cell|<frac|A|r>*J*<wide|\<Phi\>|\<bar\>><rsub|k>*<around*|\||z<rsup|\<tau\>>|\|>,>>>>
    </eqnarray*>

    for suitable constants <math|A\<gtr\>0> and
    <math|\<tau\>\<in\>\<bbb-Z\>>, and where <math|J> denotes the
    <math|r\<times\>r> matrix whose coefficients are all one. Taking
    <math|<wide|\<Phi\>|\<bar\>><rsub|0>> to be the vector with entries
    <math|<around*|\<\|\|\>|\<Phi\><rsub|0>|\<\|\|\>>,\<ldots\>,<around*|\<\|\|\>|\<Phi\><rsub|0>|\<\|\|\>>>,
    it follows that <math|<wide|\<Phi\>|\<bar\>><rsub|k>> is the vector with
    entries <math|<around*|\<\|\|\>|\<Phi\><rsub|0>|\<\|\|\>>*<around*|\||A*z<rsup|\<tau\>>|\|><rsup|k>,\<ldots\>,<around*|\<\|\|\>|\<Phi\><rsub|0>|\<\|\|\>>*<around*|\||A*z<rsup|\<tau\>>|\|><rsup|k>>.
    By construction<nbsp><rigid|<math|<around*|\<\|\|\>|\<Phi\><rsub|k>|\<\|\|\>>\<leqslant\><around*|\<\|\|\>|<wide|\<Phi\>|\<bar\>><rsub|k>|\<\|\|\>>>>.
  </proof>

  <\lemma>
    <label|an-lem>Let <math|g=g<rsub|0>+g<rsub|1>*t+\<cdots\>> be an analytic
    function on the unit disk <math|\<cal-B\><around*|(|0,1|)>> such that
    <math|<around*|\||g<rsub|0>|\|>\<leqslant\><around*|(|4*r|)><rsup|-r>>,
    <math|max <around*|(|<around*|\||g<rsub|1>|\|>,\<ldots\>,<around*|\||g<rsub|r>|\|>|)>=1>
    and <math|<around*|\||g<rsub|r>*t<rsup|r>+g<rsub|r+1>*t<rsup|r+1>+\<cdots\>|\|>\<leqslant\><around*|(|4*r|)><rsup|-r>>
    on <math|\<cal-B\><around*|(|0,1|)>>. Then <math|g> admits a root on
    <math|\<cal-B\><around*|(|0,1|)>>.
  </lemma>

  <\proof>
    Let <math|G<around*|(|t|)>=g<rsub|1>*t+\<cdots\>+g<rsub|r>*t<rsup|r>>. We
    may factor <math|G<around*|(|t|)>=<around*|(|t-\<alpha\><rsub|1>|)>*\<cdots\>*<around*|(|t-\<alpha\><rsub|r>|)>>
    with <math|\<alpha\><rsub|1>=0>. Let <math|0\<less\>\<rho\>\<leqslant\>1>
    be such that <math|<around*|\||\<rho\>-<around*|\||\<alpha\><rsub|i>|\|>|\|>\<geqslant\><frac|1|2*r-1>\<gtr\><frac|1|r>>
    for all <math|i>. Then we have <math|<around*|\||G<around*|(|t|)>|\|>\<geqslant\><around*|(|2*r|)><rsup|-r>>
    for all <math|t\<in\>\<bbb-C\>> with <math|<around*|\||t|\|>=\<rho\>>,
    whence <math|<around*|\||g<around*|(|t|)>-G<around*|(|t|)>|\|>\<leqslant\>2*<around*|(|4*r|)><rsup|-r>\<less\><around*|(|2*r|)><rsup|-r>\<leqslant\><around*|\||G<around*|(|t|)>|\|>>.
    By Rouch's theorem, it follows that <math|g> and <math|G> admit the same
    number of zeros in <math|\<cal-B\><around*|(|0,r|)>>. Hence <math|g>
    admits at least one zero inside <math|\<cal-B\><around*|(|0,r|)>\<subseteq\>\<cal-B\><around*|(|0,1|)>>.
  </proof>

  <\lemma>
    <label|main-zero-lem>There exist positive constants
    <math|\<rho\><rprime|'>>, <math|C> and <math|\<nu\>> such that

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|\||f<around*|(|z|)>|\|>\<leqslant\>C*<around*|\||E<rsub|1><around*|(|z|)>*z<rsup|\<nu\>>*2<rsup|-n*r>|\|>>|<cell|\<Longrightarrow\>>|<cell|\<exists\>z<rprime|'>\<in\>\<bbb-C\>,<around*|\||z<rprime|'>-z|\|>\<leqslant\>2<rsup|-n>\<wedge\>f<around*|(|z<rprime|'>|)>=0>>>>
    </eqnarray*>

    for all <math|n\<geqslant\><around*|\<lceil\>|r*log<rsub|2>
    <around*|(|4*r|)>|\<rceil\>>> and <math|z\<in\>\<cal-S\><rsub|Id>> with
    <math|2<rsup|-n>\<leqslant\><around*|\||z|\|>\<leqslant\>\<rho\><rprime|'>>.
  </lemma>

  <\proof>
    Let <math|C> and <math|\<nu\>> be as in
    Theorem<nbsp><reference|vect-lower-bound-th> and <math|\<varrho\>>,
    <math|A> and <math|\<tau\>> as in Lemma<nbsp><reference|other-coeff-lem>.
    Take <rigid|<math|\<rho\><rprime|'>=min<around*|(|\<rho\>,\<varrho\>|)>>>.
    We thus have <math|<around*|\<\|\|\>|\<Phi\><rsub|0>|\<\|\|\>>\<geqslant\>C*<around*|\||E<rsub|1><around*|(|z|)>*z<rsup|\<nu\>>|\|>>
    and <math|<around*|\||f<rsub|r+k>|\|>\<leqslant\><around*|\<\|\|\>|\<Phi\><rsub|0>|\<\|\|\>>*<around*|\||A*z<rsup|\<tau\>>|\|><rsup|k-r+1>>
    for all<nbsp><math|k>. Let <math|g<around*|(|t|)>=f<around*|(|z+2<rsup|-n>*t|)>=g<rsub|0>+g<rsub|1>*t+\<cdots\>>.
    Then it follows that <math|M\<assign\><rigid|max
    <around*|(|<around*|\||g<rsub|0>|\|>,\<ldots\>,<around*|\||g<rsub|r-1>|\|>|)>>\<geqslant\><around*|\<\|\|\>|\<Phi\><rsub|0>|\<\|\|\>>*2<rsup|-<around*|(|r-1|)>*n>>
    and <math|<around*|\||g<rsub|k>|\|>\<leqslant\><around*|\<\|\|\>|\<Phi\><rsub|0>|\<\|\|\>>*<around*|\||A*z<rsup|\<tau\>>|\|><rsup|k-r>*2<rsup|-k*n>\<leqslant\>M*<around*|\||A*z<rsup|\<tau\>>|\|><rsup|k-r+1>*2<rsup|-n>>
    for <math|k\<geqslant\>r>. Assuming that
    <math|<around*|\||f<around*|(|z|)>|\|>\<leqslant\>C*<around*|\||E<rsub|1><around*|(|z|)>*z<rsup|\<nu\>>*2<rsup|-n*r>|\|>>,
    we also obtain <math|<around*|\||g<rsub|0>|\|>\<leqslant\><around*|\<\|\|\>|\<Phi\><rsub|0>|\<\|\|\>>*2<rsup|-n*r>\<leqslant\>M*2<rsup|-n>\<leqslant\>M*<around*|(|4*r|)><rsup|-r>>.
    Decreasing <math|\<rho\><rprime|'>> if necessary, we may arrange
    ourselves so that <rigid|<math|<around*|\||A*z<rsup|\<tau\>>|\|>\<leqslant\><frac*|1|2>>>.
    Consequently, <math|\<delta\><around*|(|t|)>=g<rsub|r>*t<rsup|r>+g<rsub|r+1>*t<rsup|r+1>+\<cdots\>>
    satisfies <math|<around*|\||\<delta\><around*|(|t|)>|\|>\<leqslant\>M*2<rsup|-n>\<leqslant\>M*<around*|(|4*r|)><rsup|-r>>
    for <math|<around*|\||t|\|>\<leqslant\>1>. We now conclude by
    Lemma<nbsp><reference|an-lem>.
  </proof>

  <subsection|Global uniform complexity bounds>

  We are now in a position to prove our main theorem. We start with proving
  the uniform bound on \Psuper-admissible\Q sectors near singularities. Here
  the sector <math|\<cal-S\>=\<cal-S\><rsub|\<rho\>,\<theta\>,\<alpha\>>> is
  said to be <em|super-admissible> if we may take
  <math|\<rho\><rprime|'>=\<rho\>> in Lemma<nbsp><reference|main-zero-lem>,
  as well as in the analoguous statement on <math|\<cal-S\><rsub|\<sigma\>>>
  for each permutation <math|\<sigma\>> of
  <math|<around*|{|1,\<ldots\>,r|}>>. Given <math|\<varepsilon\>\<gtr\>0> and
  <math|z,z<rprime|'>\<in\>\<bbb-C\>> with
  <math|<around*|\||z<rprime|'>-z|\|>\<leqslant\>\<varepsilon\>>, we will say
  that <math|z<rprime|'>> is an <em|<math|\<varepsilon\>>-approximation> of
  <math|z>.

  <\lemma>
    <label|main-lem>Assume that <math|0> is a singularity for <math|L> and
    that <math|f> is a solution to <math|L f=0> on a<nbsp>super-admissible
    sector <math|\<cal-S\>=\<cal-S\><rsub|\<rho\>,\<theta\>,\<alpha\>>>, with
    holonomic initial conditions at a<nbsp>point in
    <math|\<cal-S\>\<cap\>\<bbb-K\>>. Denote
    <math|\<Theta\>=<around*|{|u\<in\>\<cal-S\>:f<around*|(|u|)>=0|}>>. Then
    there exists an algorithm that takes <math|n\<in\>\<bbb-N\>> and
    <math|z\<in\>\<cal-S\>\<cap\>\<bbb-D\><around*|[|\<mathi\>|]>> with
    <math|\<cal-B\><rigid|<around*|(|z,2<rsup|-n>|)>>\<cap\><around*|(|\<partial\>
    \<cal-S\>\<cup\>\<Theta\>|)>=\<varnothing\>> and
    <math|size<around*|(|z|)>\<leqslant\>n> on input and that computes
    <math|v\<in\>\<bbb-F\><around*|[|\<mathi\>|]>> on output with
    <math|<around*|\||f<around*|(|z|)>-v|\|>\<leqslant\>2<rsup|-n>*<around*|\||f<around*|(|z|)>|\|>>.
    Moreover, the running time of the algorithm is bounded by
    <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>, uniformly
    in <math|z>.
  </lemma>

  <\proof>
    Let <math|\<varphi\><rsub|i>> and <math|b<rsub|i>> denote the
    accelero-sums of <math|<wide|\<varphi\>|~><rsub|i>> and
    <math|<wide|b|~><rsub|i>> on <math|\<cal-S\>>. By
    Theorem<nbsp><reference|main-local-th>, we may compute
    <math|2<rsup|-n>>-approximations of the evaluations
    <math|\<varphi\><rsub|i><around*|(|z|)>> in time
    <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>, uniformly
    for <math|z\<in\>\<cal-S\>\<cap\>\<bbb-D\><around*|[|\<mathi\>|]>>. In
    particular, the constants <math|\<lambda\><rsub|1>,\<ldots\>,\<lambda\><rsub|r>>
    with <math|f=\<lambda\><rsub|1>*b<rsub|1>+\<cdots\>+\<lambda\><rsub|r>*b<rsub|r>>
    can be evaluated with a<nbsp>precision of <math|n> bits in time
    <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>.

    For a given <math|z\<in\>\<cal-S\>\<cap\>\<bbb-D\><around*|[|\<mathi\>|]>>,
    we first determine a permutation <math|\<pi\>> such that
    <math|z\<in\>\<cal-S\><rsub|\<pi\>>>. Modulo a<nbsp>permutation of the
    basis elements <math|b<rsub|i>>, we may assume without loss of generality
    that <math|\<pi\>=Id>. In order to evaluate <math|f> at <math|z>, we
    perform tentative evaluations at increasing bit precisions
    <math|n<rprime|'>=n,2*n,4*n,\<ldots\>> until the desired approximation
    with a<nbsp>relative precision of<nbsp><math|n> bits is found. For the
    tentative evaluations, we proceed as follows:

    <\itemize>
      <item>We compute <math|2<rsup|-n<rprime|'>-1>>-approximations of
      <math|\<varphi\><rsub|1><around*|(|z|)>,\<ldots\>,\<varphi\><rsub|r><around*|(|z|)>>.

      <item>We compute <math|2<rsup|-n<rprime|'>>>-approximations of
      <math|\<varphi\><rsub|2><around*|(|z|)>*E<rsub|2><around*|(|z|)>/E<rsub|1><around*|(|z|)>,\<ldots\>,\<varphi\><rsub|n><around*|(|z|)>*E<rsub|r><around*|(|z|)>/E<rsub|1><around*|(|z|)>>.

      <item>Summing up, we obtain a <math|r*2<rsup|-n<rprime|'>>>-approximation
      of <math|f<around*|(|z|)>/E<rsub|1><around*|(|z|)>>.
    </itemize>

    If the <math|r*2<rsup|-n<rprime|'>>>-approximation of
    <math|f<around*|(|z|)>/E<rsub|1><around*|(|z|)>> has a relative precision
    of at least <math|n+1> bits, then we obtain <math|v> using one final
    multiplication with a floating point approximation
    of<nbsp><math|E<rsub|1><around*|(|z|)>>. If
    <math|f<around*|(|z|)>/E<rsub|1><around*|(|z|)>> has a smaller relative
    precision, then we set <math|n<rprime|'>\<assign\>2*n<rprime|'>> and keep
    iterating.

    Now whenever both <math|n<rprime|'>\<geqslant\>r*n-<around*|\<lfloor\>|\<nu\>*log<rsub|2>
    <around*|\||z|\|>+log<rsub|2> C|\<rfloor\>>> and
    <math|<around*|\||f<around*|(|z|)>/E<rsub|1><around*|(|z|)>|\|>\<leqslant\>2<rsup|-n<rprime|'>>>,
    Lemma<nbsp><reference|main-zero-lem> implies that
    <math|\<cal-B\><rigid|<around*|(|z,2<rsup|-n>|)>>\<cap\>\<Theta\>\<neq\>\<varnothing\>>.
    In other words, the iteration will stop whenever
    <math|n<rprime|'>\<geqslant\>r*n-<around*|\<lfloor\>|\<nu\>*log<rsub|2>
    <around*|\||z|\|>+log<rsub|2> C|\<rfloor\>>+log<rsub|2> r>. Since
    <math|<around*|\||z|\|>\<geqslant\>2<rsup|-n>>, this happens for
    <math|n<rprime|'>=O<around*|(|n|)>>. Since we double <math|n<rprime|'>>
    at every iteration, the total running time is dominated by the running
    time of the last tentative evaluation at precision
    <math|n<rprime|'>=O<around*|(|n|)>>. The most expensive step of this
    tentative evaluation is the computation of the
    <math|2<rsup|-n<rprime|'>>>-approximations of
    <math|\<varphi\><rsub|1><around*|(|z|)>,\<ldots\>,\<varphi\><rsub|r><around*|(|z|)>>.
    By Theorem<nbsp><reference|main-local-th>, this can be done in
    time<nbsp><math|O<around*|(|<math-ss|I><around*|(|n<rprime|'>|)>*log<rsup|3>
    n<rprime|'>|)>=O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>,
    uniformly in <math|z>.
  </proof>

  <\render-proof|Proof of Theorem<nbsp><reference|main-th>>
    Let <math|\<sigma\>\<in\>\<Sigma\>> be one of the singularities and let
    <math|\<cal-S\><rsub|1>\<cup\>\<cdots\>\<cup\>\<cal-S\><rsub|\<ell\>>> be
    an admissible ball cover in the neighbourhood of <math|\<sigma\>>. For
    each admissible sector <math|\<cal-S\><rsub|i>> and each connected
    component <math|\<cal-C\>> of <math|\<cal-S\><rsub|i>\<cap\>\<Omega\>>
    (there are at most two such connected components), we also arbitrarily
    pick a point <math|z<rsub|\<cal-C\>>> in
    <math|\<cal-C\>\<cap\>\<bbb-D\><around*|[|\<mathi\>|]>>. We may compute
    <math|2<rsup|-n>>-approximations for <math|f<around*|(|z<rsub|\<cal-C\>>|)>,\<ldots\>,f<rsup|<around*|(|r-1|)>><around*|(|z<rsub|\<cal-C\>>|)>>
    in time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|2> n|)>>.
    These values may be used as initial conditions for <math|f> on
    <math|\<cal-S\><rsub|i>>.

    For <math|z\<in\>\<Omega\>\<cap\>\<bbb-D\><around*|[|\<mathi\>|]>>
    sufficiently close to <math|\<sigma\>>, we use the following algorithm
    for the evaluation of <math|f<around*|(|z|)>>. Among the sectors
    <math|\<cal-S\><rsub|i>> that contain<nbsp><math|z>, we pick the one for
    which <math|d<around*|(|z,\<partial\> \<cal-S\><rsub|i>|)>> is maximal.
    In particular, <math|d<around*|(|z,\<partial\>
    \<cal-S\><rsub|i>|)>\<geqslant\>\<gamma\><rsub|i>*<around*|\||z-\<sigma\>|\|>>
    for some fixed constant <math|\<gamma\><rsub|i>\<gtr\>0>.
    Let<nbsp><math|\<cal-C\>> be the connected component of of
    <math|\<cal-S\><rsub|i>\<cap\>\<Omega\>> that contains <math|z>. We now
    evaluate <math|f<around*|(|z|)>> using the algorithm from
    Lemma<nbsp><reference|main-lem>, by using the initial conditions for
    <math|f> at <math|z<rsub|\<cal-C\>>>. Applying
    Lemma<nbsp><reference|main-lem> on each of the sectors
    <math|\<cal-S\><rsub|i>>, we obtain a constant <math|r<rsub|\<sigma\>>>
    such that <math|f<around*|(|z|)>> can be approximated with a relative
    precision of <math|n> bits in time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3>
    n|)>>, uniformly in <math|z\<in\>\<Omega\>\<cap\>\<bbb-D\><around*|[|\<mathi\>|]>\<cap\>\<cal-B\><around*|(|\<sigma\>,r<rsub|\<sigma\>>|)>>,
    provided that <math|\<cal-B\><rigid|<around*|(|z,2<rsup|-n>|)>>\<cap\><around*|(|\<partial\>
    \<Omega\>\<cup\>\<Theta\>|)>=\<varnothing\>>.

    Considering the change of variables <math|z\<rightarrow\>1/z>, one may
    prove in a similar way that, for some sufficiently large <math|R>, we can
    approximate <math|f<around*|(|z|)>> with a relative precision of <math|n>
    bits in time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3>
    n|)>>, uniformly in <math|z\<in\>\<Omega\>\<cap\>\<bbb-D\><around*|[|\<mathi\>|]>\<cap\><around*|{|u\<in\>\<bbb-C\>:<around*|\||u|\|>\<geqslant\>R|}>>,
    provided that <math|\<cal-B\><rigid|<around*|(|z,2<rsup|-n>|)>>\<cap\><around*|(|\<partial\>
    \<Omega\>\<cup\>\<Theta\>|)>=\<varnothing\>>.

    Let <math|U=<around*|{|u\<in\>\<bbb-C\>:<around*|\||u|\|>\<gtr\>R\<wedge\><around*|(|\<forall\>\<sigma\>\<in\>\<Sigma\>,<around*|\||u-\<sigma\>|\|>\<less\>r<rsub|\<sigma\>>|)>|}>>.
    The complement <math|\<bbb-C\>\<setminus\>U> is a compact set that
    contains none of the singularities of <math|f>. Using the complexity
    bounds from<nbsp><cite|vdH:hol>, it follows that a
    <math|2<rsup|-n>>-approximation for <math|f<around*|(|z|)>> can be
    computed in time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|2>
    n|)>>, uniformly in <math|z\<in\><around*|(|\<bbb-C\>\<setminus\>U|)>\<cap\>\<Omega\>\<cap\>\<bbb-D\><around*|[|\<mathi\>|]>>.
    Now <math|f<around*|(|z|)>> admits only a finite number of zeros on
    <math|\<bbb-C\>\<setminus\>U> and each zero has multiplicity at most
    <math|r-1>. Considering the local power series expansions around any of
    these zeros <math|\<omega\>>, we observe that
    <math|<around*|\||f<around*|(|z|)>|\|>\<gtr\>c*<around*|\||z-\<omega\>|\|><rsup|r>>
    for some computable contant <math|c\<gtr\>0> and <math|z> sufficiently
    close to <math|\<omega\>>. Provided that
    <math|\<cal-B\><around*|(|z,2<rsup|-n>|)>\<cap\><around*|(|\<partial\>
    \<Omega\>\<cup\>\<Theta\>|)>=\<varnothing\>>, this implies that we can
    also compute an approximation for <math|f<around*|(|z|)>> with a relative
    precision of <math|n> bits in time <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|2>
    n|)>>, uniformly for <math|z\<in\><around*|(|\<bbb-C\>\<setminus\>U|)>\<cap\>\<Omega\>\<cap\>\<bbb-D\><around*|[|\<mathi\>|]>>.
  </render-proof>

  <section|Further thoughts and challenges>

  There are several directions in which the results of this paper can be
  extended or made more precise.

  <paragraph|More general constants>In our main
  Theorem<nbsp><reference|main-th>, we assumed that <math|\<bbb-K\>> is the
  field of algebraic numbers. Following the Chudnovsky's<nbsp><cite|CC90>,
  and using the baby-step-giant-step technique, one may replace
  <math|\<bbb-K\>> with more general effective subfield of <math|\<bbb-C\>>
  whose elements can be approximated fast. More precisely, if for any
  constants <math|z> in <math|\<bbb-K\>> we can compute
  a<nbsp><math|2<rsup|-n>><nbhyph>approximation of <math|z> in time
  <math|O<around*|(|<math-ss|I><around*|(|n<rsup|3/2>|)>*log<rsup|2> n|)>>,
  then Theorem<nbsp><reference|main-th> still holds, but one should replace
  the uniform complexity bound <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3>
  n|)>> by <math|O<around*|(|<math-ss|I><around*|(|n<rsup|3/2>|)>*log<rsup|2>
  n|)>>.

  <paragraph|Riemann surfaces>In this paper, we used <math|\<Omega\>> for the
  domain of our holonomic function<nbsp><math|f>. Of course, <math|f> is
  really defined on the covering space of
  <math|\<bbb-C\>\<setminus\>\<Sigma\>> which is a Riemann surface. Points on
  this Riemann surface can be represented by broken line paths as
  in<nbsp><cite|vdH:hol|vdH:singhol|vdH:reshol>. By using a suitable size
  function for broken line paths with vertices in
  <math|\<bbb-D\><around*|[|\<mathi\>|]>>, one may extend
  Theorem<nbsp><reference|main-th> to the evaluation of <math|f> at points
  above <math|\<bbb-D\><around*|[|\<mathi\>|]>> on this Riemann surface.

  <paragraph|Fast approximation of zeros>Given a sufficiently good
  approximation <math|<wide|z|~>\<in\>\<bbb-D\><around*|[|\<mathi\>|]>> of
  a<nbsp>zero <math|z> of <math|f> of multiplicity <math|\<mu\>> (we must
  have <math|\<mu\>\<less\>r>), we may use Newton method's
  <math|<wide|z|~><rprime|'>\<assign\><wide|z|~>-\<mu\>*f<around*|(|<wide|z|~>|)>/f<rprime|'><around*|(|<wide|z|~>|)>>
  to compute a better approximation <math|<wide|z|~><rprime|'>>. Since the
  evaluations of <math|f> and <math|f<rprime|'>> can be done with good
  uniform complexity, this should make it possible to compute a
  <math|2<rsup|-n>>-approximation of <math|z> in time
  <math|O<around*|(|<math-ss|I><around*|(|n|)>*log<rsup|3> n|)>>, uniformly
  in <math|<wide|z|~>> under suitable conditions. It would be a useful
  contribution to prove a more precise statement of this kind.

  <paragraph|Ball evaluations>In this paper, we assumed that the points
  <math|z> where we evaluate <math|f> are exactly known. An interesting
  question concerns the efficient computation of high quality ball
  lifts<nbsp><math|\<b-f\>> of <math|f>. In that case, the evaluation point
  <math|z> is replaced by an explicit ball
  <rigid|<math|\<b-z\>=\<cal-B\><around*|(|z,\<rho\>|)>>> with
  <math|z\<in\>\<bbb-D\><around*|[|\<mathi\>|]>> and
  <math|\<rho\>\<in\>\<bbb-D\><rsup|\<geqslant\>>>, and the evaluation
  <math|\<b-f\><around*|(|\<b-z\>|)>> should be a similar ball
  <math|\<b-u\>=\<cal-B\><around*|(|u,\<sigma\>|)>> with the property that
  <math|f<around*|(|\<b-z\>|)>\<subseteq\>\<b-u\>> and
  <math|f<around*|(|\<b-z\>|)>> contains two points with distance at least
  <math|\<sigma\>>. It would be worthwhile to extend
  Theorem<nbsp><reference|main-th> to this kind of arithmetic.

  <paragraph|Multi-summation>When introducing the theory of
  accelero-summability<nbsp><cite|Ec87|Ec92>, calle also described a variant
  which only relies on the evaluation of iterated Laplace integrals (instead
  of the more general accelerations). This idea was further developed by
  Balser<nbsp><cite|Bal94> who rebaptized it under the term
  \Pmulti-summation\Q. It is quite plausible that <cite|vdH:reshol> and the
  present paper can be adapted to this setting.

  <\bibliography|bib|plain|>
    <\bib-list|10>
      <bibitem*|1><label|bib-Bal94>W.<nbsp>Balser.
      <newblock><with|font-shape|italic|From divergent power series to
      analytic functions. Theory and application of multisummable power
      series>, volume 1582 of <with|font-shape|italic|Lect. Notes in Math.>
      <newblock>Springer-Verlag, Berlin, 1994.

      <bibitem*|2><label|bib-Br76a>R.<nbsp>P. Brent. <newblock>The complexity
      of multiprecision arithmetic. <newblock>In
      <with|font-shape|italic|Complexity of Computational problem solving>,
      1976.

      <bibitem*|3><label|bib-CC90>D.<nbsp>V. Chudnovsky and G.<nbsp>V.
      Chudnovsky. <newblock>Computer algebra in the service of mathematical
      physics and number theory (Computers in mathematics, Stanford, CA,
      1986). <newblock>In <with|font-shape|italic|Lect. Notes in Pure and
      Applied Math.>, volume 125, pages 109\U232, New-York, 1990. Dekker.

      <bibitem*|4><label|bib-Ec87>J.<nbsp>calle. <newblock>L'acclration
      des fonctions rsurgentes (survol). <newblock>Unpublished manuscript,
      1987.

      <bibitem*|5><label|bib-Ec92>J.<nbsp>calle.
      <newblock><with|font-shape|italic|Introduction aux fonctions
      analysables et preuve constructive de la conjecture de Dulac>.
      <newblock>Hermann, collection: Actualits mathmatiques, 1992.

      <bibitem*|6><label|bib-HP97>B.<nbsp>Haible and T.<nbsp>Papanikolaou.
      <newblock>Fast multiple-precision evaluation of elementary functions.
      <newblock>Technical Report TI-7/97, Universitt Darmstadt, 1997.

      <bibitem*|7><label|bib-vdH:hol>J.<nbsp>van<nbsp>der Hoeven.
      <newblock>Fast evaluation of holonomic functions.
      <newblock><with|font-shape|italic|TCS>, 210:199\U215, 1999.

      <bibitem*|8><label|bib-vdH:singhol>J.<nbsp>van<nbsp>der Hoeven.
      <newblock>Fast evaluation of holonomic functions near and in
      singularities. <newblock><with|font-shape|italic|JSC>, 31:717\U743,
      2001.

      <bibitem*|9><label|bib-vdH:reshol>J.<nbsp>van<nbsp>der Hoeven.
      <newblock>Efficient accelero-summation of holonomic functions.
      <newblock><with|font-shape|italic|JSC>, 42(4):389\U428, 2007.

      <bibitem*|10><label|bib-Kar93>E.<nbsp>A. Karatsuba. <newblock>Fast
      evaluation of Bessel functions. <newblock><with|font-shape|italic|Integral
      Transforms and Special Functions>, 1(4):269\U276, 1993.

      <bibitem*|11><label|bib-Mezza:phd>Marc Mezzarobba.
      <newblock><with|font-shape|italic|Autour de l'valuation numrique des
      fonctions D-finies>. <newblock>PhD thesis, cole polytechnique, 2011.

      <bibitem*|12><label|bib-Poin1886>H.<nbsp>Poincar. <newblock>Sur les
      intgrales irrgulires des quations linaires.
      <newblock><with|font-shape|italic|Acta Math.>, 8:295\U344, 1886.
    </bib-list>
  </bibliography>
</body>

<\initial>
  <\collection>
    <associate|font-base-size|11>
    <associate|par-hyphen|professional>
    <associate|preamble|false>
  </collection>
</initial>

<\attachments>
  <\collection>
    <\associate|bib-bibliography>
      <\db-entry|+U2YV1EuEKZY7La|inproceedings|CC90>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1501010771>

        <db-field|newer|+Li3PZLCHp1NMb0>

        <db-field|newer|+dG1O0ihIeNj9R9>
      <|db-entry>
        <db-field|author|D. V. <name|Chudnovsky><name-sep>G. V.
        <name|Chudnovsky>>

        <db-field|title|Computer algebra in the service of mathematical
        physics and number theory (Computers in mathematics, Stanford, CA,
        1986)>

        <db-field|booktitle|Lect. Notes in Pure and Applied Math.>

        <db-field|pages|109\U232>

        <db-field|year|1990>

        <db-field|volume|125>

        <db-field|address|New-York>

        <db-field|publisher|Dekker>
      </db-entry>

      <\db-entry|+Y7Wf699OJGUOd2|article|vdH:hol>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1451240633>

        <db-field|newer|+Oof3cak8H1iYxG>

        <db-field|newer|+Li3PZLCHp1NMmN>

        <db-field|newer|+dG1O0ihIeNj9cb>

        <db-field|newer|+WuEkwkWErJdSFZ>
      <|db-entry>
        <db-field|author|J. van der <name|Hoeven>>

        <db-field|title|Fast evaluation of holonomic functions>

        <db-field|journal|TCS>

        <db-field|year|1999>

        <db-field|volume|210>

        <db-field|pages|199\U215>
      </db-entry>

      <\db-entry|+U2YV1EuEKZY7LN|inproceedings|Br76a>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1501010771>

        <db-field|newer|+Li3PZLCHp1NMaT>

        <db-field|newer|+dG1O0ihIeNj9Qc>
      <|db-entry>
        <db-field|author|R. P. <name|Brent>>

        <db-field|title|The complexity of multiprecision arithmetic>

        <db-field|booktitle|Complexity of Computational problem solving>

        <db-field|year|1976>
      </db-entry>

      <\db-entry|+U2YV1EuEKZY7MT|article|Kar93>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1501010771>

        <db-field|newer|+Li3PZLCHp1NMf8>

        <db-field|newer|+dG1O0ihIeNj9VL>
      <|db-entry>
        <db-field|author|E. A. <name|Karatsuba>>

        <db-field|title|Fast evaluation of Bessel functions.>

        <db-field|journal|Integral Transforms and Special Functions>

        <db-field|year|1993>

        <db-field|volume|1>

        <db-field|number|4>

        <db-field|pages|269\U276>
      </db-entry>

      <\db-entry|+dG1O0ihIeNj9Ug|techreport|HP97>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1459100738>

        <db-field|newer|+Li3PZLCHp1NMeT>
      <|db-entry>
        <db-field|author|B. <name|Haible><name-sep>T. <name|Papanikolaou>>

        <db-field|title|Fast multiple-precision evaluation of elementary
        functions>

        <db-field|institution|Universitt Darmstadt>

        <db-field|year|1997>

        <db-field|number|TI-7/97>
      </db-entry>

      <\db-entry|+Y7Wf699OJGUOd7|article|vdH:singhol>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1451240633>

        <db-field|newer|+Oof3cak8H1iYxL>

        <db-field|newer|+Li3PZLCHp1NMmS>

        <db-field|newer|+dG1O0ihIeNj9cg>

        <db-field|newer|+WuEkwkWErJdSFe>
      <|db-entry>
        <db-field|author|J. van der <name|Hoeven>>

        <db-field|title|Fast evaluation of holonomic functions near and in
        singularities>

        <db-field|journal|JSC>

        <db-field|year|2001>

        <db-field|volume|31>

        <db-field|pages|717\U743>
      </db-entry>

      <\db-entry|+Y7Wf699OJGUOdh|article|vdH:reshol>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1451240633>

        <db-field|newer|+Oof3cak8H1iYxv>

        <db-field|newer|+Li3PZLCHp1NMn2>

        <db-field|newer|+dG1O0ihIeNj9dG>

        <db-field|newer|+WuEkwkWErJdSGE>
      <|db-entry>
        <db-field|author|J. van der <name|Hoeven>>

        <db-field|title|Efficient accelero-summation of holonomic functions>

        <db-field|journal|JSC>

        <db-field|year|2007>

        <db-field|volume|42>

        <db-field|number|4>

        <db-field|pages|389\U428>
      </db-entry>

      <\db-entry|+dG1O0ihIeNj9X5|phdthesis|Mezza:phd>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1459100739>

        <db-field|newer|+ao7aNqGlxB6h3d>

        <db-field|newer|+Li3PZLCHp1NMgr>
      <|db-entry>
        <db-field|author|Marc <name|Mezzarobba>>

        <db-field|title|Autour de l'valuation numrique des fonctions
        D-finies>

        <db-field|school|cole polytechnique>

        <db-field|year|2011>
      </db-entry>

      <\db-entry|+dG1O0ihIeNj9Yd|article|Poin1886>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1459100740>

        <db-field|newer|+Li3PZLCHp1NMiP>
      <|db-entry>
        <db-field|author|H. <name|Poincar>>

        <db-field|title|Sur les intgrales irrgulires des quations
        linaires>

        <db-field|journal|Acta Math.>

        <db-field|year|1886>

        <db-field|volume|8>

        <db-field|pages|295\U344>
      </db-entry>

      <\db-entry|+dG1O0ihIeNj9SS|unpublished|Ec87>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1459100737>

        <db-field|newer|+Li3PZLCHp1NMcH>
      <|db-entry>
        <db-field|author|J. <name|calle>>

        <db-field|title|L'acclration des fonctions rsurgentes (survol)>

        <db-field|note|Unpublished manuscript>

        <db-field|year|1987>
      </db-entry>

      <\db-entry|+M2XvD2msK5aQZQ|book|Ec92>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1454325270>

        <db-field|newer|+3a783HvX7LqvqJ>

        <db-field|newer|+dG1O0ihIeNj9ST>
      <|db-entry>
        <db-field|author|J. <name|calle>>

        <db-field|title|Introduction aux fonctions analysables et preuve
        constructive de la conjecture de Dulac>

        <db-field|publisher|Hermann, collection: Actualits mathmatiques>

        <db-field|year|1992>
      </db-entry>

      <\db-entry|+dG1O0ihIeNj9PK|book|Bal94>
        <db-field|contributor|vdhoeven>

        <db-field|modus|imported>

        <db-field|date|1459100736>

        <db-field|newer|+Li3PZLCHp1NMZB>
      <|db-entry>
        <db-field|author|W. <name|Balser>>

        <db-field|title|From divergent power series to analytic functions.
        Theory and application of multisummable power series>

        <db-field|publisher|Springer-Verlag>

        <db-field|year|1994>

        <db-field|volume|1582>

        <db-field|series|Lect. Notes in Math.>

        <db-field|address|Berlin>
      </db-entry>
    </associate>
  </collection>
</attachments>

<\references>
  <\collection>
    <associate|Gk-bound|<tuple|10|12|unifhol2.tm>>
    <associate|acc-err|<tuple|6|6|unifhol2.tm>>
    <associate|acc-growth|<tuple|4|6|unifhol2.tm>>
    <associate|accsum-unif-prop|<tuple|7|9|unifhol2.tm>>
    <associate|an-lem|<tuple|14|13|unifhol2.tm>>
    <associate|auto-1|<tuple|1|1|unifhol2.tm>>
    <associate|auto-10|<tuple|3|5|unifhol2.tm>>
    <associate|auto-11|<tuple|4|6|unifhol2.tm>>
    <associate|auto-12|<tuple|5|6|unifhol2.tm>>
    <associate|auto-13|<tuple|2.3|6|unifhol2.tm>>
    <associate|auto-14|<tuple|2.4|7|unifhol2.tm>>
    <associate|auto-15|<tuple|2.5|8|unifhol2.tm>>
    <associate|auto-16|<tuple|3|9|unifhol2.tm>>
    <associate|auto-17|<tuple|3.1|9|unifhol2.tm>>
    <associate|auto-18|<tuple|3.2|10|unifhol2.tm>>
    <associate|auto-19|<tuple|3.3|10|unifhol2.tm>>
    <associate|auto-2|<tuple|1|1|unifhol2.tm>>
    <associate|auto-20|<tuple|3.4|10|unifhol2.tm>>
    <associate|auto-21|<tuple|4|11|unifhol2.tm>>
    <associate|auto-22|<tuple|4.1|11|unifhol2.tm>>
    <associate|auto-23|<tuple|4.2|13|unifhol2.tm>>
    <associate|auto-24|<tuple|4.3|14|unifhol2.tm>>
    <associate|auto-25|<tuple|5|15|unifhol2.tm>>
    <associate|auto-26|<tuple|6|15|unifhol2.tm>>
    <associate|auto-27|<tuple|7|16|unifhol2.tm>>
    <associate|auto-28|<tuple|8|16|unifhol2.tm>>
    <associate|auto-29|<tuple|9|16|unifhol2.tm>>
    <associate|auto-3|<tuple|1|2|unifhol2.tm>>
    <associate|auto-30|<tuple|10|16|unifhol2.tm>>
    <associate|auto-31|<tuple|10|16|unifhol2.tm>>
    <associate|auto-4|<tuple|1|4|unifhol2.tm>>
    <associate|auto-5|<tuple|2|4|unifhol2.tm>>
    <associate|auto-6|<tuple|2.1|4|unifhol2.tm>>
    <associate|auto-7|<tuple|2.2|5|unifhol2.tm>>
    <associate|auto-8|<tuple|1|5|unifhol2.tm>>
    <associate|auto-9|<tuple|2|5|unifhol2.tm>>
    <associate|bib-Bal94|<tuple|1|16|unifhol2.tm>>
    <associate|bib-Br76a|<tuple|2|16|unifhol2.tm>>
    <associate|bib-CC90|<tuple|3|16|unifhol2.tm>>
    <associate|bib-Ec87|<tuple|4|16|unifhol2.tm>>
    <associate|bib-Ec92|<tuple|5|16|unifhol2.tm>>
    <associate|bib-HP97|<tuple|6|16|unifhol2.tm>>
    <associate|bib-Kar93|<tuple|10|16|unifhol2.tm>>
    <associate|bib-Mezza:phd|<tuple|11|16|unifhol2.tm>>
    <associate|bib-Poin1886|<tuple|12|16|unifhol2.tm>>
    <associate|bib-vdH:hol|<tuple|7|16|unifhol2.tm>>
    <associate|bib-vdH:reshol|<tuple|9|16|unifhol2.tm>>
    <associate|bib-vdH:singhol|<tuple|8|16|unifhol2.tm>>
    <associate|derivatives-bnd|<tuple|11|12|unifhol2.tm>>
    <associate|di-exp-growth|<tuple|3|6|unifhol2.tm>>
    <associate|expedito-complexity-sec|<tuple|3.3|10|unifhol2.tm>>
    <associate|expedito-sum-sec|<tuple|2|4|unifhol2.tm>>
    <associate|exsum-unif-prop|<tuple|9|10|unifhol2.tm>>
    <associate|first-acc-lem|<tuple|3|6|unifhol2.tm>>
    <associate|formal-sol-basis|<tuple|9|11|unifhol2.tm>>
    <associate|gi-exp-bnd|<tuple|2|5|unifhol2.tm>>
    <associate|global-sec|<tuple|4|11|unifhol2.tm>>
    <associate|gq-bnd|<tuple|1|5|unifhol2.tm>>
    <associate|lapl-cor|<tuple|6|8|unifhol2.tm>>
    <associate|lapl-err|<tuple|5|6|unifhol2.tm>>
    <associate|lapl-int|<tuple|7|9|unifhol2.tm>>
    <associate|lapl-lem|<tuple|5|8|unifhol2.tm>>
    <associate|ltsum-unif-prop|<tuple|8|10|unifhol2.tm>>
    <associate|main-lem|<tuple|16|14|unifhol2.tm>>
    <associate|main-local-th|<tuple|10|11|unifhol2.tm>>
    <associate|main-th|<tuple|1|2|unifhol2.tm>>
    <associate|main-zero-lem|<tuple|15|14|unifhol2.tm>>
    <associate|next-acc-lem|<tuple|4|7|unifhol2.tm>>
    <associate|other-coeff-lem|<tuple|13|13|unifhol2.tm>>
    <associate|trmat-bnd|<tuple|8|9|unifhol2.tm>>
    <associate|unif-accsum-sec|<tuple|3.1|9|unifhol2.tm>>
    <associate|vect-lower-bound-th|<tuple|11|11|unifhol2.tm>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|bib>
      CC90

      vdH:hol

      Br76a

      Kar93

      HP97

      vdH:singhol

      vdH:reshol

      vdH:singhol

      vdH:reshol

      CC90

      vdH:hol

      Mezza:phd

      vdH:hol

      vdH:singhol

      vdH:reshol

      vdH:reshol

      vdH:reshol

      vdH:reshol

      vdH:reshol

      Poin1886

      vdH:reshol

      vdH:reshol

      vdH:reshol

      vdH:reshol

      vdH:reshol

      vdH:reshol

      CC90

      vdH:hol

      Mezza:phd

      vdH:reshol

      vdH:reshol

      vdH:hol

      CC90

      vdH:hol

      vdH:singhol

      vdH:reshol

      Ec87

      Ec92

      Bal94

      vdH:reshol
    </associate>
    <\associate|toc>
      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|1.<space|2spc>Introduction>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-1><vspace|0.5fn>

      <with|par-left|<quote|1tab>|Statement of the problem and the main
      result <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-2>>

      <with|par-left|<quote|1tab>|Proof strategy
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-3>>

      <with|par-left|<quote|1tab>|Notational conventions
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-4>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|2.<space|2spc>Expedito-summation>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-5><vspace|0.5fn>

      <with|par-left|<quote|1tab>|2.1.<space|2spc>Introduction to
      expedito-summation <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-6>>

      <with|par-left|<quote|1tab>|2.2.<space|2spc>The expedited approximation
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-7>>

      <with|par-left|<quote|4tab>|The truncated Laplace transform
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-8><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Borel transforms of
      <with|mode|<quote|math>|g> at other critical times
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-9><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|The difference between
      <with|mode|<quote|math>|f> and <with|mode|<quote|math>|g>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-10><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Behaviour of the
      <with|mode|<quote|math>|<wide|\<delta\>|^><rsub|i>> at infinity
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-11><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Majorants for specific accelerates and
      Laplace transforms <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-12><vspace|0.15fn>>

      <with|par-left|<quote|1tab>|2.3.<space|2spc>The first acceleration
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-13>>

      <with|par-left|<quote|1tab>|2.4.<space|2spc>Subsequent accelerations
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-14>>

      <with|par-left|<quote|1tab>|2.5.<space|2spc>The final Laplace transform
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-15>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|3.<space|2spc>Uniform
      complexity on local sectors> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-16><vspace|0.5fn>

      <with|par-left|<quote|1tab>|3.1.<space|2spc>Uniform complexity of
      accelero-summation <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-17>>

      <with|par-left|<quote|1tab>|3.2.<space|2spc>Uniform complexity of
      summation until the least term <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-18>>

      <with|par-left|<quote|1tab>|3.3.<space|2spc>Uniform complexity of
      expedito-summation <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-19>>

      <with|par-left|<quote|1tab>|3.4.<space|2spc>The combined local strategy
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-20>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|4.<space|2spc>Globally
      efficient evaluation> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-21><vspace|0.5fn>

      <with|par-left|<quote|1tab>|4.1.<space|2spc>Local analysis of
      cancellations <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-22>>

      <with|par-left|<quote|1tab>|4.2.<space|2spc>Existence of zeros on disks
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-23>>

      <with|par-left|<quote|1tab>|4.3.<space|2spc>Global uniform complexity
      bounds <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-24>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|5.<space|2spc>Further
      thoughts and challenges> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-25><vspace|0.5fn>

      <with|par-left|<quote|4tab>|More general constants
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-26><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Riemann surfaces
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-27><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Fast approximation of zeros
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-28><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Ball evaluations
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-29><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Multi-summation
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-30><vspace|0.15fn>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|Bibliography>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-31><vspace|0.5fn>
    </associate>
  </collection>
</auxiliary>