<TeXmacs|1.99.2>

<style|<tuple|tmarticle|vdh|mathemagix|english>>

<\body>
  <\hide-preamble>
    <assign|Ce|<macro|x|<arg|x><rsub|c>>>

    <assign|Ra|<macro|x|<arg|x><rsub|r>>>

    <assign|Ball|<macro|c|r|\<cal-B\>(<arg|c>,<arg|r>)>>

    <assign|Ball-corrected|<macro|c|r|\<cal-B\><rsup|\<Delta\>>(<arg|c>,<arg|r>)>>

    <assign|Beff|<macro|f|\<lceil\><space|-0.75spc>\<lceil\><arg|f>\<rceil\><space|-0.75spc>\<rceil\>>>

    <assign|Leff|<macro|f|\<lfloor\><space|-0.75spc>\<lfloor\><arg|f>\<rfloor\><space|-0.75spc>\<rfloor\>>>

    \;

    <assign|bC|<macro|<smash|<with|font-series|bold|math-font-series|bold|\<bbb-C\>>>>>

    <assign|bK|<macro|<smash|<with|font-series|bold|math-font-series|bold|\<bbb-K\>>>>>

    <assign|bR|<macro|<smash|<with|font-series|bold|math-font-series|bold|\<bbb-R\>>>>>

    <assign|bT|<macro|<smash|<with|font-series|bold|math-font-series|bold|\<bbb-T\>>>>>

    <assign|bU|<macro|<smash|<with|font-series|bold|math-font-series|bold|\<bbb-U\>>>>>

    <assign|tf|<macro|<smash|<wide|f|~>>>>

    <assign|tC|<macro|<smash|<wide|\<bbb-C\>|~>>>>

    <assign|tK|<macro|<smash|<wide|\<bbb-K\>|~>>>>

    <assign|tbK|<macro|<smash|<wide|<with|font-series|bold|math-font-series|bold|\<bbb-K\>>|~>>>>

    <assign|tR|<macro|<smash|<wide|\<bbb-R\>|~>>>>

    \;
  </hide-preamble>

  <\doc-data|<doc-title|Reliable homotopy continuation>|<doc-subtitle|Third
  preliminary version>|<doc-author|<\author-data|<author-name|Joris van der
  Hoeven>|<\author-affiliation>
    LIX, CNRS

    cole polytechnique

    91128 Palaiseau Cedex

    France
  </author-affiliation>|<author-email|vdhoeven@lix.polytechnique.fr>|<author-homepage|http://lix.polytechnique.fr/~vdhoeven>>
    \;
  </author-data>>>
    \;
  <|doc-data|<\doc-note>
    This work has been supported by the ANR-09-JCJC-0098-01 <name|MaGiX>
    project, the Digiteo 2009-36HD grant and Rgion Ile-de-France.
  </doc-note>>
    \;
  </doc-data|<doc-date|<date|>>>

  <abstract-data|<\abstract>
    In this paper, we present several algorithms for certified homotopy
    continuation. One typical application is to compute the roots of a zero
    dimensional system of polynomial equations. We both present algorithms
    for the certification of single and multiple roots. We also present
    several ideas for improving the underlying numerical path tracking
    algorithms, especially in the case of multiple roots.
  </abstract>|<abstract-msc|65H20|65H04|65G20|30C15|13P15>|<abstract-keywords|Homotopy
  continuation, polynomial system solving, ball arithmetic, interval
  arithmetic, reliable computing>>

  <\render-remark|Disclaimer>
    This paper is a preliminary version, which is mainly intended as a
    working program for an ongoing implementation in the <name|Mathemagix>
    system. It is expected that several adjustments and corrections will have
    to be made during the implementation of the algorithms in this paper and
    their proof reading by colleagues.
  </render-remark>

  <section|Introduction>

  Besides Grbner basis computations, homotopy methods are a popular
  technique for solving systems of polynomial equations. In this paper, we
  will only consider zero dimensional systems. Given such a system

  <\eqnarray*>
    <tformat|<table|<row|<cell|P<around|(|z|)>>|<cell|=>|<cell|0,<eq-number><label|end-sys>>>>>
  </eqnarray*>

  with <math|P=<around|(|P<rsub|1>,\<ldots\>,P<rsub|n>|)>> and
  <math|z=<around|(|z<rsub|1>,\<ldots\>,z<rsub|n>|)>>, the idea is to find a
  suitable starting system

  <\eqnarray*>
    <tformat|<table|<row|<cell|Q<around|(|z|)>>|<cell|=>|<cell|0<eq-number><label|start-sys>>>>>
  </eqnarray*>

  of which all solutions are known, to introduce the homotopy

  <\eqnarray*>
    <tformat|<table|<row|<cell|H<around|(|z,t|)>>|<cell|=>|<cell|<around|(|1-t|)>*P<around|(|z|)>+t*Q<around|(|z|)>,<eq-number><label|hom>>>>>
  </eqnarray*>

  and to compute the solutions to <math|P<around|(|z|)>=0> by following the
  solutions of <math|Q<around|(|z|)>=0> from <math|t=1> to<nbsp><math|t=0>.
  Two main approaches exist:

  <\description>
    <item*|Algebraic homotopies>In this setting, the polynomial equations
    have exact rational or algebraic coefficients. The homotopy continuation
    is done exactly using suitable resultants. At the end of the homotopy,
    the solutions of the system <math|P<around|(|z|)>=0> are again given
    exactly, as the solutions of simpler systems. The theory was developed
    in<nbsp><cite|GHMP95|GHHMMP97|Lecerf:phd|Dur:phd> and a concrete
    implementation is available in the <name|Kronecker>
    system<nbsp><cite|Lecerf:phd>.

    <item*|Numeric homotopies>An alternative approach is to follow the
    solution paths using a<nbsp>numeric path tracking algorithm; see
    <cite|Mor87|Ver:phd|SW05> and references therein. This approach is
    usually faster, partly because most of the operations can be done at a
    significantly lower precision. However, the end result is only
    approximate. In particular, it cannot be used for the reliable resolution
    of overdetermined systems. Several implementations exist for numeric path
    tracking<nbsp><cite|Ver:PHCpack|Bertini|Ley09>.
  </description>

  It is surprising that little effort has been undertaken so far in order to
  bring both approaches closer together. Particularly interesting challenges
  are how to make numeric homotopy as reliable as possible and how to
  reconstruct exact end results from the numeric output. Part of this
  situation might be due to the fact that interval
  analysis<nbsp><cite|Moo66|AH83|Neu90|JKDW01|Kul08|MKC09|Rump10> is not so
  well-known in the communities where homotopy methods were developed, with
  the exception of one early paper <cite|KX94>. The main objective paper is
  to systematically exploit interval analysis techniques in the context of
  homotopy continuation. We will show how to certify homotopy continuations
  as well as single and multiple solutions of the polynomial system
  <math|P<around|(|z|)>=0>.

  Section<nbsp><reference|ball-sec> is devoted to preliminaries from the area
  of reliable computation. In section<nbsp><reference|ball-arith-sec>, we
  start by recalling the basic principles of ball
  arithmetic<nbsp><cite|vdH:ball>, which is a<nbsp>more suitable variant of
  interval arithmetic for our purposes. In
  section<nbsp><reference|Taylor-sec>, we pursue by recalling the concept of
  a Taylor model<nbsp><cite|MB96|MB04>, which is useful in order to compute
  with reliable enclosures of multivariate analytic functions on polydisks.
  We also introduce a<nbsp>variant of Taylors models in
  section<nbsp><reference|D-stable-Taylor-sec>, which simultaneously encloses
  an analytic function and a finite number of its derivatives. In
  sections<nbsp><reference|overest-sec> and<nbsp><reference|reduce-overest-sec>,
  we discuss the well known problem of overestimation which is inherent to
  ball arithmetic. We will provide some techniques to analyze, quantify and
  reduce overestimation.

  Before attacking the topic of certified path tracking, it is useful to
  review the theory of numeric path tracking first. In
  section<nbsp><reference|num-hom-sec>, we start with the case of non
  singular paths, in which case we use a classical predictor corrector
  approach based on Euler-Newton's method. The goal of a numeric path tracker
  is to advance as fast as possible on the solution path while minimizing the
  risk of errors. Clearly, the working precision has to be sufficiently large
  in order to ensure that function evaluations are reasonably accurate. In
  section<nbsp><reference|num-prec-sec>, we show how to find a suitable
  working precision using ball arithmetic. We consider this approach to be
  simpler, more robust and more general than the one proposed
  in<nbsp><cite|BSHW08>. In order to reduce the risk of jumping from one path
  to another path, we also need a criterion for checking whether our numeric
  approximations stay reasonably close to the true solution path. A
  numerically robust way to do this is to ensure that the Jacobian
  of<nbsp><math|H> does not change to rapidly during each step; see
  section<nbsp><reference|step-control-sec> and<nbsp><cite|BSHW08> for a
  related approach. Another technique is to detect near collisions of paths
  and undertake special action in this case; see
  section<nbsp><reference|near-coll-sec>.

  In section<nbsp><reference|num-mul-roots-sec>, we turn our attention to
  homotopies<nbsp>(<reference|hom>) such that the end
  system<nbsp>(<reference|end-sys>) admits multiple solutions. We will see
  that Euler-Newton iterations only admit a linear convergence near multiple
  solutions. Therefore, it is useful to search for alternative iterations
  which admit a better convergence. Now the solution path near a multiple
  solution is given by a convergent Puiseux series in <math|t>. When letting
  <math|t\<rightarrow\>\<mathe\><rsup|2*\<mathpi\>*\<mathi\>>*t> turn around
  the origin, we thus fall on another solution path. The collection of paths
  which are obtained through repeated rotations of this kind is called a
  herd. In sections<nbsp><reference|hurd-iter-sec>
  and<nbsp><reference|hurd-step-sec>, we will describe a<nbsp>new path
  tracking method with quadratic convergence, which operates simultaneously
  on all paths in a herd. The remaining issue of how to detect clusters and
  herds will be described in sections<nbsp><reference|cluster-detect-sec>,
  <reference|hurd-detect-sec> and<nbsp><reference|synchronize-sec>.

  In section<nbsp><reference|cert-hom-sec>, we turn our attention to the
  certification of single roots of<nbsp>(<reference|end-sys>) and single
  steps of a path tracker. An efficient and robust method for the
  certification of solutions to systems of non linear equations is Krawczyk's
  method<nbsp><cite|Kraw69>, with several improvements by
  Rump<nbsp><cite|Rump:phd>. In section<nbsp><reference|Kraw-sec>, we adapt
  this classical method to the setting of ball arithmetic. In
  section<nbsp><reference|simple-hom-cert-sec>, we will see that an easy
  generalization of this method provides an algorithm for certified path
  tracking. An alternative such algorithm was given in<nbsp><cite|KX94>, but
  the present algorithm presents similar advantages as Krawczyk's method with
  respect to other methods for the certification of solutions to systems of
  non linear equations. However, both methods still suffer from
  overestimation due to the fact that error bounds are computed on a polydisk
  which contains the solution path. Using the technique of Taylor models, we
  will show in section<nbsp><reference|tubular-sec> that it possible to
  compute the error bounds in small tubes around the actual solution path,
  thereby reducing the problem of overestimation.

  In section<nbsp><reference|univ-mult-cert-sec>, we first consider the more
  difficult problem of certifying multiple roots in the univariate case. We
  will describe two methods based on Rouch's theorem and a third method
  which rather aims at certifying a local factorization. The last method also
  serves as an important ingredient for making the Weierstrass preparation
  theorem effective in an analytic context.

  Before we turn our attention to the certification of multiple roots in the
  multivariate case, it will be convenient to have a general toolbox for
  effective complex analysis in several variables. In
  sections<nbsp><reference|an-def1-sec> and<nbsp><reference|an-def2-sec>, we
  first propose two ways how to formalize ``computable analytic functions''
  \ We next propose several basic algorithms for computations with such
  functions.

  In section<nbsp><reference|multiple-cert-sec>, we consider the more
  difficult problem of certifying multiple roots in the multivariate setting.
  Several algorithms have been proposed for this
  problem<nbsp><cite|OWM83|Lecerf:2001:fda|GiLeSaYa:2004:laczaf|GiLeSaYa:2004:laczcedo|LVZ06|LVZ08|RG10|MM11>.
  However, most existing strategies require the computation of a large number
  of derivatives of the system, which becomes prohibitive for large clusters
  of solutions. In the simplest case when the Jacobian matrix of the
  polynomial system has corank at most one at the singularity, our solution
  is based on the simultaneous consideration of all solution paths in a herd.
  The general case will essentially be reduced to this case using analytic
  elimination techniques which are similar to the geometric resolution method
  of polynomial systems<nbsp><cite|GHMP95|GHHMMP97|Dur:phd>. In
  section<nbsp><reference|global-cert-sec>, we will also outline a bridge
  between numeric and algebraic solutions which provides an alternative way
  to certify solutions.

  In section<nbsp><reference|an-sec>, we study generalizations to the
  resolution of systems of analytic equations in a given polydisk. In
  section<nbsp><reference|an-pol-red-sec>, we first consider a system of
  analytic equations as a<nbsp>perturbation of a system of polynomial
  equations. If, for <em|each> of the solutions to the system of polynomial
  equations, we can control the speed with which the solution moves under
  perturbations, then we can solve the perturbed system. Unfortunately, this
  forces us to keep track of solutions which are far away from the region of
  interest. In section<nbsp><reference|inc-sec>, we present an alternative
  strategy based on incremental resolution, as
  in<nbsp><cite|GHMP95|GHHMMP97|Dur:phd>. Although this strategy also may
  require to work outside the region of interest, it does stay closer.

  <section|Notations>

  <paragraph|Positive elements>Given a subset
  <math|R\<subseteq\>\<bbb-R\>\<cup\><around|{|\<pm\>\<infty\>|}>>, we denote

  <\eqnarray*>
    <tformat|<table|<row|<cell|R<rsup|\<geqslant\>>>|<cell|=>|<cell|<around|{|x\<in\>R:x\<geqslant\>0|}>>>|<row|<cell|R<rsup|\<gtr\>>>|<cell|=>|<cell|<around|{|x\<in\>R:x\<neq\>0|}>>>>>
  </eqnarray*>

  <paragraph|Vector notation>Unless stated otherwise, we will use the
  <math|L<rsub|1>>-norm for vectors <math|u\<in\>\<bbb-C\><rsup|n>>:

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\<\|\|\>|u|\<\|\|\>>>|<cell|=>|<cell|<around|\||u<rsub|1>|\|>+\<cdots\>+<around|\||u<rsub|n>|\|>.<eq-number><label|L1-norm>>>>>
  </eqnarray*>

  This norm should not be confused with taking componentwise absolute values

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\||u|\|>>|<cell|=>|<cell|<around|(|<around|\||u<rsub|1>|\|>,\<ldots\>,<around|\||u<rsub|n>|\|>|)>>>>>
  </eqnarray*>

  For <math|u,v\<in\>\<bbb-R\><rsup|n>> we also define

  <\eqnarray*>
    <tformat|<table|<row|<cell|u\<leqslant\>v>|<cell|\<Leftrightarrow\>>|<cell|u<rsub|1>\<leqslant\>v<rsub|1>\<wedge\>\<cdots\>\<wedge\>u<rsub|n>\<leqslant\>v<rsub|n>>>|<row|<cell|u\<less\>v>|<cell|\<Leftrightarrow\>>|<cell|u<rsub|1>\<less\>v<rsub|1>\<wedge\>\<cdots\>\<wedge\>u<rsub|n>\<less\>v<rsub|n>>>|<row|<cell|max<around|(|u,v|)>>|<cell|=>|<cell|<around|(|max<around|(|u<rsub|1>,v<rsub|1>|)>,\<ldots\>,max<around|(|u<rsub|n>,v<rsub|n>|)>|)>>>|<row|<cell|u\<cdot\>v>|<cell|=>|<cell|u<rsub|1>*v<rsub|1>+\<cdots\>+u<rsub|n>*v<rsub|n>>>>>
  </eqnarray*>

  If <math|z<rsub|1>,\<ldots\>,z<rsub|n>> are formal variables, then we write

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsup|u>>|<cell|=>|<cell|z<rsub|1><rsup|u<rsub|1>>*\<cdots\>*z<rsub|n><rsup|u<rsub|n>>>>>>
  </eqnarray*>

  <paragraph|Matrix notation>We write <math|\<bbb-K\><rsup|r\<times\>c>> for
  the set of <math|r\<times\>c> matrices over a set <math|\<bbb-K\>>. The
  matrix norm of a matrix <math|M\<in\>\<bbb-C\><rsup|r\<times\>c>>
  corresponding to the <math|L<rsub|1>>-norm<nbsp>(<reference|L1-norm>) for
  vectors

  <\eqnarray*>
    <tformat|<cwith|1|1|3|3|cell-bsep|1spc>|<table|<row|<cell|<around|\<\|\|\>|M|\<\|\|\>>>|<cell|=>|<cell|sup<rsub|<around|\<\|\|\>|z|\<\|\|\>>=1><around|\<\|\|\>|M*z|\<\|\|\>>>>|<row|<cell|>|<cell|=>|<cell|<big|sum><rsub|i>max<rsub|j>
    <around|\||M<rsub|i,j>|\|>.>>>>
  </eqnarray*>

  <paragraph|Directed acyclic graphs>We recall that labeled directed acyclic
  graphs are often used for the representation of symbolic expressions with
  potential common subexpressions. For instance,

  <\equation*>
    <with|gr-mode|<tuple|group-edit|props>|gr-frame|<tuple|scale|1.0cm|<tuple|0.5gw|0.470003gh>>|gr-geometry|<tuple|geometry|0.320027par|0.160018par|bottom>|gr-grid|<tuple|empty>|gr-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-edit-grid-aspect|<tuple|<tuple|axes|none>|<tuple|1|none>|<tuple|10|none>>|gr-edit-grid|<tuple|empty>|gr-edit-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-text-at-halign|center|gr-line-width|default|magnify|0.999999999999998|<graphics|<math|>|<with|text-at-halign|center|<text-at|\<times\>|<point|0|1>>>|<with|text-at-halign|center|<text-at|+|<point|0|0>>>|<with|text-at-halign|center|<text-at|x|<point|-1|-1>>>|<with|text-at-halign|center|<text-at|y|<point|1|-1>>>|<arc|<point|0.2|0.8>|<point|0.4|0.5>|<point|0.191271130734599|0.194929863944735>>|<arc|<point|-0.2|0.8>|<point|-0.4|0.5>|<point|-0.205608403924146|0.210805045331084>>|<line|<point|-0.2|-0.2>|<point|-0.7|-0.7>>|<line|<point|0.2|-0.2>|<point|0.7|-0.7>>>>
  </equation*>

  is a typical dag for the expression <math|<around*|(|x+y|)><rsup|2>>. We
  will denote by <math|s<rsub|f>> the size of a dag <math|f>. For instance,
  the size of the above dag is <math|s<rsub|f>=4>.

  <section|Reliable arithmetic><label|ball-sec>

  <subsection|Ball arithmetic><label|ball-arith-sec>

  Let us briefly recall the principles behind ball<nbsp>arithmetic. Given a
  normed vector space<nbsp><math|\<bbb-K\>>, we will denote by <math|<bK>> or
  <math|\<cal-B\><around|(|\<bbb-K\>,\<bbb-R\>|)>> the set of closed balls
  with centers in <math|\<bbb-K\>> and radii in
  <math|\<bbb-R\><rsup|\<geqslant\>>>. Given such a ball
  <math|\<b-z\>\<in\>\<cal-B\><around|(|\<bbb-K\>,\<bbb-R\>|)>>, we will
  denote its center by <math|cen<around|(|\<b-z\>|)>> and its radius by
  <math|rad<around|(|\<b-z\>|)>>. Conversely, given <math|z\<in\>\<bbb-K\>>
  and <math|r\<in\>\<bbb-R\>>, we will denote by
  <math|z+\<cal-B\><around|(|r|)>> the closed ball with center<nbsp><math|z>
  and radius <math|r>.

  A continuous operation <math|f:\<bbb-K\><rsup|d>\<rightarrow\>\<bbb-K\>> is
  said to <em|lift> into an operation <math|f<rsup|lift>:<bK><rsup|d>\<rightarrow\><bK>>
  on balls, which is usually also denoted by <math|f>, if the <em|inclusion
  property>

  <\eqnarray*>
    <tformat|<table|<row|<cell|f<around|(|x<rsub|1>,\<ldots\>,x<rsub|d>|)>>|<cell|\<in\>>|<cell|f<around|(|\<b-x\><rsub|1>,\<ldots\>,\<b-x\><rsub|d>|)><eq-number><label|lift-prop>>>>>
  </eqnarray*>

  is satisfied for any <math|\<b-x\><rsub|1>,\<ldots\>,\<b-x\><rsub|d>\<in\><bK>>
  and <math|x<rsub|1>\<in\>\<b-x\><rsub|1>,\<ldots\>,x<rsub|d>\<in\>\<b-x\><rsub|d>>.
  We also say that <math|f<around|(|\<b-x\><rsub|1>,\<ldots\>,\<b-x\><rsub|d>|)>>
  is an <em|enclosure> for the set <math|<around|{|f<around|(|x<rsub|1>,\<ldots\>,x<rsub|d>|)>:x<rsub|1>\<in\>\<b-x\><rsub|1>,\<ldots\>,x<rsub|d>\<in\>\<b-x\><rsub|d>|}>>,
  whenever<nbsp>(<reference|lift-prop>) holds. For instance, if
  <math|\<bbb-K\>> is a Banach algebra, then we may take

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-x\>+\<b-y\>>|<cell|=>|<cell|cen<around|(|\<b-x\>|)>+cen<around|(|\<b-y\>|)>+\<cal-B\><around|(|rad<around|(|\<b-x\>|)>+rad<around|(|\<b-y\>|)>|)>>>|<row|<cell|\<b-x\>-\<b-y\>>|<cell|=>|<cell|cen<around|(|\<b-x\>|)>-cen<around|(|\<b-y\>|)>+\<cal-B\><around|(|rad<around|(|\<b-x\>|)>+rad<around|(|\<b-y\>|)>|)>>>|<row|<cell|\<b-x\>*\<b-y\>>|<cell|=>|<cell|cen<around|(|\<b-x\>|)>*cen<around|(|\<b-y\>|)>+\<cal-B\><around|(|rad<around|(|\<b-x\>|)>*<around|(|<around|\||cen<around|(|\<b-y\>|)>|\|>+rad<around|(|\<b-y\>|)>|)>+<around|\||cen<around|(|\<b-y\>|)>|\|>*rad<around|(|\<b-x\>|)>|)>.>>>>
  </eqnarray*>

  Similar formulas can be given for division and elementary functions.
  Certified upper and lower bounds for <math|<around|\||\<b-x\>|\|>> will be
  denoted by <math|<around|\<lceil\>|\<b-x\>|\<rceil\>>=<around|\||cen<around|(|\<b-x\>|)>|\|>+rad<around|(|\<b-x\>|)>>
  and <math|<around|\<lfloor\>|\<b-x\>|\<rfloor\>>=max<around|{|0,<around|\||cen<around|(|\<b-x\>|)>|\|>-rad<around|(|\<b-x\>|)>|}>>.

  It is convenient to extend the notion of a ball to more general radius
  types, which only carry a partial ordering. This allows us for instance to
  regard a vector <math|\<b-x\>=<rigid|<around|(|\<b-x\><rsub|1>,\<ldots\>,\<b-x\><rsub|d>|)>>\<in\><rigid|\<cal-B\><around|(|\<bbb-K\>,\<bbb-R\>|)><rsup|d>>>
  of balls as a ``vectorial ball'' with center
  <math|cen<around|(|\<b-x\>|)>=<around|(|cen<around|(|\<b-x\><rsub|1>|)>,\<ldots\>,cen<around|(|\<b-x\><rsub|d>|)>|)>\<in\>\<bbb-K\><rsup|d>>
  and radius <math|rad<around|(|\<b-x\>|)>=<around|(|rad<around|(|\<b-x\><rsub|1>|)>,\<ldots\>,rad<around|(|\<b-x\><rsub|d>|)>|)>\<in\>\<bbb-R\><rsup|d>>.
  If <math|x=<around|(|x<rsub|1>,\<ldots\>,x<rsub|d>|)>\<in\>\<bbb-K\><rsup|d>>,
  then we write <math|x\<in\>\<b-x\>> if and only if
  <math|x<rsub|i>\<in\>\<b-x\><rsub|i>> for all
  <math|i\<in\><around|{|1,\<ldots\>,d|}>>. A similar remark holds for
  matrices and power series with ball coefficients.

  In concrete machine computations, numbers are usually approximated by
  floating point numbers with a finite precision. Let <math|<tR>> be the set
  of floating point numbers at a given working precision, which we will
  assume fixed. It is customary to include the
  infinities<nbsp><math|\<pm\>\<infty\>> in <math|<tR>> as well. The IEEE754
  standard<nbsp><cite|IEEE754> specifies how to perform basic arithmetic with
  floating point numbers in a predictable way, by specifying a rounding mode
  <rigid|<math|<math-ss|R>\<in\><around|{|\<downarrow\>,\<uparrow\>,\<updownarrow\>|}>>>
  among ``down'', ``up'' and ``nearest''. A multiple precision implementation
  of this standard is available in the <name|Mpfr> library<nbsp><cite|MPFR>.
  Given an operation <math|f:\<bbb-R\><rsup|d>\<rightarrow\>\<bbb-R\>>, we
  will denote by <rigid|<math|f<rsup|<math-ss|R>>:<tR><rsup|d>\<rightarrow\><tR>>>
  its approximation using floating pointing arithmetic with rounding mode
  <math|<math-ss|R>>. This notation extends to the case
  when<nbsp><math|\<bbb-R\>> and <math|<tR>> are replaced by their
  complexifications<nbsp><math|\<bbb-C\>> and
  <math|<tC>=<tR><around|[|\<mathi\>|]>>.

  Let <math|\<bbb-K\>=\<bbb-R\>> and <math|<tK>=<tR>> or
  <math|\<bbb-K\>=\<bbb-C\>> and <math|<tK>=<tC>>. We will denote by
  <math|<tbK>> or <math|\<cal-B\><around|(|<tK>,<tR>|)>> the set of closed
  balls in <math|\<bbb-K\>> with centers in <math|<tK>> and radii in
  <math|<tR><rsup|\<geqslant\>>>. In this case, we will also allow for balls
  with an infinite radius. A continuous operation
  <rigid|<math|f:\<bbb-K\><rsup|d>\<rightarrow\>\<bbb-K\>>> is again said to
  <em|lift> to an operation <math|f:<tbK><rsup|d>\<rightarrow\><tbK>> on
  balls if<nbsp>(<reference|lift-prop>) holds for any
  <rigid|<math|\<b-x\><rsub|1>,\<ldots\>,\<b-x\><rsub|d>\<in\><with|math-font-series|bold|<tbK>>>>
  and <math|x<rsub|1>\<in\>\<b-x\><rsub|1>,\<ldots\>,x<rsub|d>\<in\>\<b-x\><rsub|d>>.
  The formulas for the ring operations may now be adapted to

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-x\>+\<b-y\>>|<cell|=>|<cell|cen<around|(|\<b-x\>|)>+<rsup|\<updownarrow\>>cen<around|(|\<b-y\>|)>+\<cal-B\><around|(|rad<around|(|\<b-x\>|)>+<rsup|\<uparrow\>>rad<around|(|\<b-y\>|)>+<rsup|\<uparrow\>>\<epsilon\><rsub|+,\<b-x\>,\<b-y\>>|)>>>|<row|<cell|\<b-x\>-\<b-y\>>|<cell|=>|<cell|cen<around|(|\<b-x\>|)>-<rsup|\<updownarrow\>>cen<around|(|\<b-y\>|)>+\<cal-B\><around|(|rad<around|(|\<b-x\>|)>+<rsup|\<uparrow\>>rad<around|(|\<b-y\>|)>+<rsup|\<uparrow\>>\<epsilon\><rsub|-,\<b-x\>,\<b-y\>>|)>>>|<row|<cell|\<b-x\>*\<b-y\>>|<cell|=>|<cell|cen<around|(|\<b-x\>|)>\<times\><rsup|\<updownarrow\>>cen<around|(|\<b-y\>|)>+>>|<row|<cell|>|<cell|>|<cell|\<cal-B\><around|(|rad<around|(|\<b-x\>|)>\<times\><rsup|\<uparrow\>><around|(|<around|\||cen<around|(|\<b-y\>|)>|\|>+<rsup|\<uparrow\>>rad<around|(|\<b-y\>|)>|)>+<rsup|\<uparrow\>><around|\||cen<around|(|\<b-y\>|)>|\|>\<times\><rsup|\<uparrow\>>rad<around|(|\<b-x\>|)>+<rsup|\<uparrow\>>\<epsilon\><rsub|\<times\>,\<b-x\>,\<b-y\>>|)>,>>>>
  </eqnarray*>

  where <with|mode|math|\<epsilon\><rsub|+,\<b-x\>,\<b-y\>>>,
  <with|mode|math|\<epsilon\><rsub|-,\<b-x\>,\<b-y\>>> and
  <with|mode|math|\<epsilon\><rsub|\<times\>,\<b-x\>,\<b-y\>>> are reliable
  bounds for the rounding errors induced by the corresponding floating point
  operations on the centers; see<nbsp><cite|vdH:ball> for more
  details.<space|0.2spc>

  In order to ease the remainder of our exposition, we will avoid
  technicalities related to rounding problems, and compute with ``idealized''
  balls with centers in <math|\<bbb-K\>\<in\><around*|{|\<bbb-R\>,\<bbb-C\>|}>>
  and radii in <math|\<bbb-R\><rsup|\<geqslant\>>>. For those who are
  familiar with rounding errors, it should not be difficult though to adapt
  our results to more realistic machine computations.

  <\remark>
    In classical interval analysis so called interval lifts of operations
    <math|f:\<bbb-K\><rsup|d>\<rightarrow\>\<bbb-K\>> are sometimes required
    to satisfy the <em|inclusion monotonicity> property

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<b-x\><rsub|1>\<subseteq\>\<b-y\><rsub|1>\<wedge\>\<cdots\>\<wedge\>\<b-x\><rsub|d>\<subseteq\>\<b-y\><rsub|d>>|<cell|\<Longrightarrow\>>|<cell|f<around|(|\<b-x\><rsub|1>,\<ldots\>,\<b-x\><rsub|d>|)>\<subseteq\>f<around|(|\<b-y\><rsub|1>,\<ldots\>,\<b-y\><rsub|d>|)>,>>>>
    </eqnarray*>

    for all <math|\<b-x\><rsub|1>,\<ldots\>,\<b-x\><rsub|n>,\<b-y\><rsub|1>,\<ldots\>,\<b-y\><rsub|n>\<in\><bK>>,
    which clearly implies the usual inclusion
    property<nbsp>(<reference|lift-prop>). For floating intervals, it is easy
    to ensure this stronger property using correct rounding. In the ball
    setting, the exact ring operations in <math|<bR>> and <math|<bC>> are
    clearly inclusion monotonic, but it seems cumbersome to preserve this
    stronger property for floating balls. For this reason, we systematically
    develop our theory without assuming inclusion monotonicity.
  </remark>

  <subsection|Taylor models><label|Taylor-sec>

  If we are computing with analytic functions on a disk, or multivariate
  analytic functions on a polydisk, then Taylor models<nbsp><cite|MB96|MB04>
  provide a suitable functional analogue for ball arithmetic. We will use a
  multivariate setup with <math|z=<around|(|z<rsub|1>,\<ldots\>,z<rsub|d>|)>>
  as our coordinates and a<nbsp>polydisk <math|D=\<cal-B\><around|(|\<rho\>|)>=<around|{|z,<around|\||z|\|>\<leqslant\><around|\||\<rho\>|\|>|}>>
  for a fixed <math|\<rho\>=<around|(|\<rho\><rsub|1>,\<ldots\>,\<rho\><rsub|d>|)>\<in\><around|(|\<bbb-R\><rsup|\<gtr\>>|)><rsup|d>>.
  Taylor models come in different blends, depending on whether we use a
  global error bound on <math|D> or individual bounds for the coefficients of
  the polynomial approximation. Individual bounds are sharper (especially if
  we truncate up to an small order such that the remainder is not that
  small), but more expensive to compute. Our general setup covers all
  possible blends of Taylor models.

  We first need some more definitions and notations. Assume that
  <math|\<bbb-N\><rsup|d>> is given the natural partial ordering. Let
  <math|\<bbb-e\><rsub|k>> denote the <math|k>-th canonical basis vector of
  <math|\<bbb-N\><rsup|d>>, so that <math|<around|(|\<bbb-e\><rsub|k>|)><rsub|k>=1>
  and <math|<around|(|\<bbb-e\><rsub|k>|)><rsub|l>=0> for <math|l\<neq\>k>.
  For every <math|i\<in\>\<bbb-N\><rsup|d>>, recall that
  <math|<around|\<\|\|\>|i|\<\|\|\>>=<around|\||i<rsub|1>|\|>+\<cdots\>+<around|\||i<rsub|d>|\|>>.
  A subset <math|\<cal-I\>\<subseteq\>\<bbb-N\><rsup|d>> is called an
  <em|initial segment>, if for any <math|i\<in\>\<cal-I\>> and
  <math|j\<in\>\<bbb-N\><rsup|d>> with <math|j\<leqslant\>i>, we have
  <math|j\<in\>\<cal-I\>>. In that case, we write
  <with|mode|math|<wide|\<cal-I\>|\<abovering\>>=<around|{|i\<in\>\<cal-I\>:i+<around|{|\<bbb-e\><rsub|1>,\<ldots\>,\<bbb-e\><rsub|d>|}>\<subseteq\>\<cal-I\>|}>>
  and <math|\<partial\> \<cal-I\>=\<cal-I\>\<setminus\><wide|\<cal-I\>|\<abovering\>>>.
  In what follows, we assume that <math|\<cal-I\>> and <math|\<cal-J\>> are
  fixed initial segments of <math|\<bbb-N\><rsup|d>> with
  <with|mode|math|<wide|\<cal-J\>|\<abovering\>>\<subseteq\>\<cal-I\>>. For
  instance, we may take <math|\<cal-I\>=\<cal-T\><rsub|n>=<around|{|i\<in\>\<bbb-N\><rsup|d>:<around|\<\|\|\>|i|\<\|\|\>>\<leqslant\>n|}>>
  and <math|\<cal-J\>=\<cal-T\><rsub|n+1>> or
  <math|\<cal-J\>=\<cal-T\><rsub|n>> or <math|\<cal-J\>=<around|{|0|}>>.

  Let <math|\<bbb-K\>=\<bbb-R\>> or <math|\<bbb-K\>=\<bbb-C\>>. Given a
  series <math|f=<big|sum><rsub|i\<in\>\<bbb-N\><rsup|d>>f<rsub|i>*z<rsup|i>\<in\>\<bbb-K\><around|[|<around|[|z|]>|]>>,
  we will write <math|supp f=<around|{|i\<in\>\<bbb-N\><rsup|d>:f<rsub|i>\<neq\>0|}>>
  for its <em|support>. Given a subset <math|\<bbb-S\>\<subseteq\>\<bbb-K\><around|[|<around|[|z|]>|]>>
  and a subset <math|\<cal-S\>\<subseteq\>\<bbb-N\><rsup|d>>, we write
  <math|f<rsub|\<cal-S\>>=<big|sum><rsub|i\<in\>\<cal-S\>>f<rsub|i>*z<rsup|i>>
  and <math|\<bbb-S\><rsub|\<cal-S\>>=<around|{|g\<in\>\<bbb-S\>:supp
  g\<subseteq\>\<cal-S\>|}>>. If <math|f> is analytic on <math|D>, then we
  denote its sup-norm by

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\<\|\|\>|f|\<\|\|\>><rsub|D>>|<cell|=>|<cell|sup<rsub|z\<in\>D><around|\||f<around|(|z|)>|\|>.>>>>
  </eqnarray*>

  A <em|Taylor model> is a tuple <math|\<b-P\>=<around|(|\<rho\>,\<cal-I\>,\<cal-J\>,cen<around|(|\<b-P\>|)>,rad<around|(|\<b-P\>|)>|)>>,
  where <math|\<rho\>>, <math|\<cal-I\>> and <math|\<cal-J\>> are as above,
  <math|cen<around|(|\<b-P\>|)>\<in\>\<bbb-K\><around|[|z|]><rsub|\<cal-I\>>>
  and <math|rad<around|(|\<b-P\>|)>\<in\>\<bbb-R\><around|[|z|]><rsub|\<cal-J\>>>.
  We will write <math|<bT>=<bT><rsub|D,\<cal-I\>,\<cal-J\>>=<rigid|\<cal-B\><rsub|D><around|(|\<bbb-K\><around|[|z|]><rsub|\<cal-I\>>,\<bbb-R\><around|[|z|]><rsub|\<cal-J\>>|)>>>
  for the set of such Taylor models. Given <math|\<b-P\>\<in\><bT>> and
  <math|i\<in\>\<bbb-N\><rsup|d>>, we will also denote
  <rigid|<math|\<b-P\>=cen<around|(|\<b-P\>|)>+\<cal-B\><rsub|D><around|(|rad<around|(|\<b-P\>|)>|)>>>
  and <math|\<b-P\><rsub|i>=cen<around|(|\<b-P\>|)><rsub|i>+\<cal-B\><around|(|rad<around|(|\<b-P\>|)><rsub|i>|)>>.
  Given an analytic function<nbsp><math|f> on <math|D>, we write
  <math|f\<in\>\<b-P\>>, if there exists a decomposition

  <\eqnarray*>
    <tformat|<table|<row|<cell|f>|<cell|=>|<cell|cen<around|(|\<b-P\>|)>+<big|sum><rsub|i\<in\>\<cal-J\>>\<varepsilon\><rsub|i>*z<rsup|i>>>>>
  </eqnarray*>

  with <math|\<varepsilon\><rsub|i>\<in\>\<bbb-C\><around|[|<around|[|z|]>|]>>
  and <with|mode|math|<around|\<\|\|\>|\<varepsilon\><rsub|i>|\<\|\|\>><rsub|D>\<leqslant\>rad<around|(|\<b-P\>|)><rsub|i>>
  for all <math|i>. In particular, if <math|f\<in\>\<b-P\>>, then

  <\eqnarray*>
    <tformat|<table|<row|<cell|f<around|(|z|)>>|<cell|\<in\>>|<cell|<big|sum><rsub|i\<in\>\<cal-I\>\<cup\>\<cal-J\>>\<b-P\><rsub|i>*z<rsup|i>,>>>>
  </eqnarray*>

  for any <math|z\<in\>D>. Given two Taylor models
  <math|\<b-P\>,\<b-Q\>\<in\><bT>>, we will say that <math|\<b-P\>> is
  <em|included> in<nbsp><math|\<b-Q\>>, and we write
  <math|\<b-P\>\<subseteq\>\<b-Q\>> if <math|f\<in\>\<b-Q\>> for any
  <math|f\<in\>\<b-P\>>. This holds in particular if
  <math|\<b-P\><rsub|i>\<subseteq\>\<b-Q\><rsub|i>> for all <math|i>, in
  which case we say that <math|\<b-P\>> is <em|strongly included> in
  <math|\<b-Q\>> and write <math|P\<sqsubseteq\>Q>. We finally define
  <math|\<varpi\><around|(|\<b-P\>|)>\<in\><bC>> by

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<varpi\><around|(|\<b-P\>|)>>|<cell|=>|<cell|\<b-P\><rsub|0>+<big|sum><rsub|i\<neq\>0>\<b-P\><rsub|i>*\<cal-B\><around|(|\<rho\>|)><rsup|i>,>>>>
  </eqnarray*>

  so that <math|f<around|(|z|)>\<in\>\<varpi\><around|(|\<b-P\>|)>> for all
  <math|f\<in\>\<b-P\>> and <math|z\<in\>\<cal-B\><around|(|\<rho\>|)>>.

  Addition, subtraction and scalar multiplication are defined in a natural
  way on Taylor models. For multiplication, we need a projection
  <math|\<pi\>=\<pi\><rsub|\<cal-J\>>:\<bbb-N\><rsup|d>\<rightarrow\>\<cal-J\>>
  with <math|\<pi\><around|(|i|)>\<leqslant\>i> for all<nbsp><math|i> and
  <math|\<pi\><around|(|i|)>=i> if <math|i\<in\>\<cal-J\>>. One way to
  construct such a mapping is as follows. For <math|i\<in\>\<cal-J\>>, we
  must take <math|\<pi\><around|(|i|)>=i>. For <math|i\<nin\>\<cal-J\>>, let
  <math|k> be largest such that <math|i<rsub|k>\<neq\>0>. Then we recursively
  define <math|\<pi\><around|(|i|)>=\<pi\><around|(|i-\<bbb-e\><rsub|k>|)>>.
  Given <math|\<b-P\>,\<b-Q\>\<in\><bT>>, we now define their product by

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-P\>*\<b-Q\>>|<cell|=>|<cell|<big|sum><rsub|i,j\<in\>\<cal-I\>>\<b-P\><rsub|i>*\<b-Q\><rsub|j>*\<cal-B\><rsub|D><around|(|\<rho\>|)><rsup|i+j-\<pi\><around|(|i+j|)>>*z<rsup|\<pi\><around|(|i+j|)>>.>>>>
  </eqnarray*>

  Using the observation that <math|z<rsup|i+j>\<in\>\<cal-B\><rsub|D><around|(|\<rho\>|)><rsup|i+j-\<pi\><around|(|i+j|)>>*z<rsup|\<pi\><around|(|i+j|)>>>,
  this product satisfies the inclusion property that
  <math|f*g\<in\>\<b-P\>*\<b-Q\>> for any analytic functions
  <math|f\<in\>\<b-P\>> and <math|Q\<in\>\<b-Q\>> on <math|D>.

  <subsection|<math|\<cal-D\>>-stable Taylor
  models><label|D-stable-Taylor-sec>

  For some applications, it is convenient to use Taylor models for enclosing
  both an analytic function and a certain number of its derivatives. Let us
  show how to incorporate this in our formalism. Throughout this section, we
  assume that <math|\<cal-I\>=\<cal-J\>> and that <math|\<cal-D\>> is an
  initial segment with <math|\<cal-D\>\<subseteq\>\<cal-I\>>.

  Given a Taylor model <math|\<b-P\>\<in\><bT><rsub|D,\<cal-I\>,\<cal-I\>>>
  and <math|i\<in\>\<cal-D\>>, we notice that
  <math|\<partial\><rsup|i>\<b-P\>/\<partial\> z<rsup|i>> can be regarded as
  a Taylor model in <math|<bT><rsub|D,\<cal-I\><rprime|'>,\<cal-I\><rprime|'>>>
  with <math|\<cal-I\><rprime|'>=<around|{|j\<in\>\<bbb-N\><rsup|n>:i+j\<subseteq\>\<cal-I\>|}>>.
  Let <math|f\<in\>D\<rightarrow\>\<bbb-C\>> be an analytic function and
  <math|\<b-Q\>\<in\><bT><rsub|D,\<cal-I\>,\<cal-I\>>>. We define the
  relations <math|\<in\><rsub|\<cal-D\>>> and
  <math|\<subseteq\><rsub|\<cal-D\>>> by

  <\eqnarray*>
    <tformat|<table|<row|<cell|f\<in\><rsub|\<cal-D\>>\<b-P\>>|<cell|\<Longleftrightarrow\>>|<cell|\<forall\>i\<in\>\<cal-D\>,<frac|\<partial\><rsup|i>f|\<partial\>
    z<rsup|i>>\<subseteq\><frac|\<partial\><rsup|i>\<b-P\>|\<partial\>
    z<rsup|i>>>>|<row|<cell|\<b-P\>\<subseteq\><rsub|\<cal-D\>>\<b-Q\>>|<cell|\<Longleftrightarrow\>>|<cell|\<forall\>f\<in\><rsub|\<cal-D\>>\<b-P\>,f\<in\><rsub|\<cal-D\>>\<b-Q\>.>>>>
  </eqnarray*>

  Clearly, <math|\<b-P\>\<sqsubseteq\>\<b-Q\>\<Rightarrow\>\<b-P\>\<subseteq\><rsub|\<cal-D\>>\<b-Q\>>
  for all <math|\<b-P\>> and <math|\<b-Q\>>.

  Let <math|\<omega\>:\<bbb-C\><rsup|d>\<rightarrow\>\<bbb-C\>> be an
  operation. Then<nbsp><math|\<omega\>> is said to <math|\<cal-D\>>-lift to
  <math|<bT><rsub|D,\<cal-I\>,\<cal-I\>>>, if for all
  <math|<rigid|\<b-P\><rsub|1>,\<ldots\>,\<b-P\><rsub|d>>\<in\><bT><rsub|D,\<cal-I\>,\<cal-I\>>>
  and all <math|f<rsub|1>\<in\><rsub|\<cal-D\>>\<b-P\><rsub|1>,\<ldots\>,f<rsub|d>\<in\><rsub|\<cal-D\>>\<b-P\><rsub|d>>,
  we have <math|\<omega\>\<circ\><around|(|f<rsub|1>,\<ldots\>,f<rsub|d>|)>\<in\><rsub|\<cal-D\>>\<omega\><around|(|\<b-P\><rsub|1>,\<ldots\>,\<b-P\><rsub|d>|)>>.
  Addition, subtraction and scalar multiplication <math|\<cal-D\>>-lift in
  the usual way. As to multiplication, we take

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-P\>\<times\><rsub|\<cal-D\>>\<b-Q\>>|<cell|=>|<cell|<big|sum><rsub|<stack|<tformat|<table|<row|<cell|i,j\<in\>\<cal-I\>>>|<row|<cell|i+j\<in\>\<cal-I\>>>>>>>\<b-P\><rsub|i>*\<b-Q\><rsub|j>*z<rsup|i+j>+<big|sum><rsub|<stack|<tformat|<table|<row|<cell|i,j\<in\>\<cal-I\>>>|<row|<cell|i+j\<nin\>\<cal-I\>>>|<row|<cell|k\<in\>\<partial\>
    \<cal-I\>>>|<row|<cell|k\<leqslant\>i+j>>>>>>C<rsub|i,j,k>*\<b-P\><rsub|i>*\<b-Q\><rsub|j>*\<cal-B\><rsub|D><around|(|\<rho\>|)><rsup|i+j-k>*z<rsup|k>,>>>>
  </eqnarray*>

  with

  <\eqnarray*>
    <tformat|<table|<row|<cell|C<rsub|i,j,k>>|<cell|=>|<cell|max<rsub|<stack|<tformat|<table|<row|<cell|l\<in\>\<cal-D\>>>|<row|<cell|l\<leqslant\>k>>>>>>
    <around*|(|<frac|\<partial\><rsup|l>z<rsup|i+j>|z<rsup|i+j-l>*\<partial\>
    z<rsup|l>><mid|/><frac|\<partial\><rsup|l>z<rsup|k>|z<rsup|k-l>*\<partial\>
    z<rsup|l>>|)>.>>>>
  </eqnarray*>

  In order to see that <math|\<times\><rsub|\<cal-D\>>> satisfies the
  <math|\<cal-D\>>-inclusion property, it suffices to check that

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsup|i+j>>|<cell|\<in\><rsub|\<cal-D\>>>|<cell|z<rsup|i>\<times\><rsub|\<cal-D\>>z<rsup|j>>>>>
  </eqnarray*>

  for all <math|i,j\<in\>\<cal-I\>>. This is clear if
  <math|i+j\<in\>\<cal-I\>>. Otherwise,

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsup|i>\<times\><rsub|\<cal-D\>>z<rsup|j>>|<cell|=>|<cell|<big|sum><rsub|<stack|<tformat|<table|<row|<cell|k\<in\>\<partial\>
    \<cal-I\>>>|<row|<cell|k\<leqslant\>i+j>>>>>>C<rsub|i,j,k>*\<cal-B\><rsub|D><around|(|\<rho\>|)><rsup|i+j-k>*z<rsup|k>.>>>>
  </eqnarray*>

  For any <math|l\<in\>\<cal-D\>> with <math|l\<leqslant\>i+j>, there exists
  a <math|k\<in\>\<partial\> \<cal-I\>> with
  <math|l\<leqslant\>k\<leqslant\>i+j>. Hence,

  <\eqnarray*>
    <tformat|<table|<row|<cell|<frac|\<partial\><rsup|l>z<rsup|i+j>|\<partial\>z<rsup|l>>>|<cell|=>|<cell|<frac|\<partial\><rsup|l>z<rsup|i+j>|z<rsup|i+j-l>*\<partial\>
    z<rsup|l>>*z<rsup|i+j-l>>>|<row|<cell|>|<cell|\<in\>>|<cell|<frac|\<partial\><rsup|l>z<rsup|i+j>|z<rsup|i+j-l>*\<partial\>
    z<rsup|l>>*\<cal-B\><rsub|D><around|(|\<rho\>|)><rsup|i+j-k>*z<rsup|k-l>>>|<row|<cell|>|<cell|=>|<cell|<frac|\<partial\><rsup|l>|\<partial\>z<rsup|l>><around*|[|<around*|(|<frac|\<partial\><rsup|l>z<rsup|i+j>|z<rsup|i+j-l>*\<partial\>
    z<rsup|l>><mid|/><frac|\<partial\><rsup|l>z<rsup|k>|z<rsup|k-l>*\<partial\>
    z<rsup|l>>|)>*\<cal-B\><rsub|D><around|(|\<rho\>|)><rsup|i+j-k>*z<rsup|k>|]>>>|<row|<cell|>|<cell|\<subseteq\>>|<cell|<frac|\<partial\><rsup|l><around|(|z<rsup|i>\<times\><rsub|\<cal-D\>>z<rsup|j>|)>|\<partial\>
    z<rsup|l>>.>>>>
  </eqnarray*>

  In the particularly useful case when <math|\<cal-I\>=\<cal-J\>=\<cal-T\><rsub|1>=<around|{|i\<in\>\<bbb-N\><rsup|d>:<around|\<\|\|\>|i|\<\|\|\>>\<leqslant\>1|}>>,
  we notice that <math|C<rsub|\<bbb-e\><rsub|i>,\<bbb-e\><rsub|j>,\<bbb-e\><rsub|i>>=C<rsub|\<bbb-e\><rsub|i>,\<bbb-e\><rsub|j>,\<bbb-e\><rsub|j>>=1>
  for all <math|i\<neq\>j> and <math|C<rsub|\<bbb-e\><rsub|i>,\<bbb-e\><rsub|i>,\<bbb-e\><rsub|i>>=2>
  for all <math|i>.

  <subsection|Overestimation><label|overest-sec>

  The major problem in the area of ball arithmetic is overestimation. For
  example, even though the expression <math|x-x> evaluates to zero for any
  <math|x\<in\>\<bbb-R\>>, its evaluation at any ball in<nbsp><math|<bR>>
  with a non zero radius is not identically equal to zero. For instance,

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|(|1+\<cal-B\><around|(|0.1|)>|)>-<around|(|1+\<cal-B\><around|(|0.1|)>|)>>|<cell|=>|<cell|\<cal-B\><around|(|0.2|)>.>>>>
  </eqnarray*>

  Algorithms which rely on ball arithmetic have to be designed with care in
  order to avoid this kind of overly pessimistic error bounds. In particular,
  if we evaluate a dag using ball arithmetic, then a symbolically equivalent
  dag might lead to better error bounds.

  Consider a continuous function <math|f:\<bbb-K\><rsup|d>\<rightarrow\>\<bbb-K\>>
  with <math|\<bbb-K\>> as in section<nbsp><reference|ball-arith-sec>. We
  recall that<nbsp><math|f> is said to lift into an operation
  <math|f<rsup|lift>:<bK><rsup|d>\<rightarrow\><bK>> if the inclusion
  property

  <\eqnarray*>
    <tformat|<table|<row|<cell|f<around|(|x|)>>|<cell|\<in\>>|<cell|f<rsup|lift><around|(|\<b-x\>|)>>>>>
  </eqnarray*>

  is satisfied for all <math|\<b-x\>\<in\><bK><rsup|d>> and
  <math|x\<in\>\<b-x\>>. Clearly, such a lift is not unique: for any
  <math|\<varepsilon\>:<bK><rsup|d>\<rightarrow\><bK>> with <math|cen
  \<varepsilon\><around|(|\<b-x\>|)>=0> for all <math|\<b-x\>>, the function
  <math|f<rsup|alt>=f<rsup|lift>+\<varepsilon\>> is also a lift of <math|f>.
  If we require that <math|cen f<rsup|lift><around|(|\<b-x\>|)>=f<around|(|cen
  \<b-x\>|)>>, then the best possible lift is given by

  <\eqnarray*>
    <tformat|<table|<row|<cell|f<rsup|best><around|(|\<b-x\>|)>>|<cell|=>|<cell|f<around|(|cen
    \<b-x\>|)>+\<cal-B\><around|(|sup<rsub|x<rprime|'>\<in\>\<b-x\>><around|\||f<around|(|x<rprime|'>|)>-f<around|(|cen
    \<b-x\>|)>|\|>|)>.>>>>
  </eqnarray*>

  In general, this lift may be expensive to compute. Nevertheless, its
  existence suggest the following definition of the quality of a lift. The
  <em|overestimation> <math|\<chi\><rsub|f<rsup|lift>><around|(|\<b-x\>|)>>
  of <math|f<rsup|lift>> at <math|\<b-x\>> is defined by

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<chi\><rsub|f<rsup|lift>><around|(|\<b-x\>|)>>|<cell|=>|<cell|<frac|rad
    f<rsup|lift><around|(|\<b-x\>|)>|rad f<rsup|best><around|(|\<b-x\>|)>>.<eq-number>>>>>
  </eqnarray*>

  This quantity is easier to study if we let <math|rad \<b-x\>> tend to zero.
  Accordingly, we also define the <em|pointwise overestimation> function
  <math|\<chi\><rsub|f<rsup|lift>>:\<bbb-K\><rsup|d>\<rightarrow\>\<bbb-R\><rsup|\<geqslant\>>>
  by

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<chi\><rsub|f<rsup|lift>><around|(|x|)>>|<cell|=>|<cell|limsup<rsub|\<b-varepsilon\>\<rightarrow\>0>
    \<chi\><rsub|f<rsup|lift>><around|(|x+\<b-varepsilon\>|)>.<eq-number>>>>>
  </eqnarray*>

  Here <math|\<b-varepsilon\>\<rightarrow\>0> means that <math|cen
  \<b-varepsilon\>=0> and <math|rad \<b-varepsilon\>\<rightarrow\>0>.

  If <math|f<rsup|lift>> is computed by evaluating a dag <math|f>, then it
  would be nice to have explicit formulas for the pointwise overestimation.
  For <math|rad \<b-x\>\<rightarrow\>0> and assuming that the
  lift<nbsp><math|f<rsup|std>> is evaluated using the default ball
  implementations of <math|+,-> and <math|\<times\>> from
  section<nbsp><reference|ball-arith-sec> , we claim that there exists a dag
  <math|<wide|\<nabla\>|\<bar\>> f> with

  <\eqnarray*>
    <tformat|<table|<row|<cell|rad f<rsup|std><around|(|x+\<cal-B\><around|(|\<varepsilon\>|)>|)>>|<cell|=>|<cell|<around|(|<wide|\<nabla\>|\<bar\>>
    f|)>\<cdot\><around|\||\<varepsilon\>|\|>+\<cal-O\><around|(|\<varepsilon\><rsup|2>|)>,>>>>
  </eqnarray*>

  for <math|\<varepsilon\>\<rightarrow\>0>. Indeed, we may compute
  <math|<wide|\<nabla\>|\<bar\>> f> using the rules

  <\eqnarray*>
    <tformat|<table|<row|<cell|<wide|\<nabla\>|\<bar\>>
    c>|<cell|=>|<cell|<around|(|0,\<ldots\>,0|)><htab|5mm><around|(|c\<in\>\<bbb-K\>|)>>>|<row|<cell|<wide|\<nabla\>|\<bar\>>
    X<rsub|k>>|<cell|=>|<cell|<around|(|0,<above|\<ldots\>|k-1>,0,1,0,\<ldots\>,0|)><htab|5mm><around|(|k\<in\><around|{|1,\<ldots\>,r|}>|)>>>|<row|<cell|<wide|\<nabla\>|\<bar\>><around|(|f\<pm\>g|)>>|<cell|=>|<cell|<wide|\<nabla\>|\<bar\>>
    f+<wide|\<nabla\>|\<bar\>> g>>|<row|<cell|<wide|\<nabla\>|\<bar\>><around|(|f*g|)>>|<cell|=>|<cell|<around|(|<wide|\<nabla\>|\<bar\>>
    f|)>*<around|\||g|\|>+<around|\||f|\|>*<around|(|<wide|\<nabla\>|\<bar\>>
    g|)>,>>>>
  </eqnarray*>

  where <math|X<rsub|k>> stands for the <math|k>-th coordinate function. Now
  we also have

  <\eqnarray*>
    <tformat|<table|<row|<cell|rad f<rsup|best><around|(|x+\<cal-B\><around|(|\<varepsilon\>|)>|)>>|<cell|=>|<cell|<around|\||\<nabla\>
    f|\|>\<cdot\><around|\||\<varepsilon\>|\|>+\<cal-O\><around|(|\<varepsilon\><rsup|2>|)>,>>>>
  </eqnarray*>

  for <math|\<varepsilon\>\<rightarrow\>0>. Consequently,

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<chi\><rsub|f<rsup|std>><around|(|x|)>>|<cell|=>|<cell|limsup<rsub|\<varepsilon\>\<neq\>0>
    <frac|<around|(|<wide|\<nabla\>|\<bar\>>
    f|)><around|(|x|)>\<cdot\><around|\||\<varepsilon\>|\|>|<around|\||<around|(|\<nabla\>f|)><around|(|x|)>|\|>\<cdot\><around|\||\<varepsilon\>|\|>>.>>>>
  </eqnarray*>

  If <math|d=1>, then this formula simplifies to

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<chi\><rsub|f<rsup|std>><around|(|x|)>>|<cell|=>|<cell|<frac|<around|(|<wide|\<nabla\>|\<bar\>>
    f|)><around|(|x|)>|<around|\||f<rprime|'><around|(|x|)>|\|>>.>>>>
  </eqnarray*>

  <\example>
    <label|overest-ex>With <math|d=1>, let us compare the dags
    <math|f=X<rsup|2>-2*X+1> and <math|g=<around|(|X-1|)><rsup|2>>. We have
    <math|<wide|\<nabla\>|\<bar\>> f=2*X+2> and
    <math|<wide|\<nabla\>|\<bar\>> g=2*<around|\||X-1|\|>>, whence

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<chi\><rsub|f<rsup|std>><around|(|x|)>>|<cell|=>|<cell|<frac|<around|\||x|\|>+1|<around|\||x-1|\|>>>>|<row|<cell|\<chi\><rsub|g<rsup|std>><around|(|x|)>>|<cell|=>|<cell|1.>>>>
    </eqnarray*>

    The example shows that we have an infinite amount of overestimation near
    double zeros, except if the dag is explicitly given as a square near the
    double zero. More generally, for the dag
    <math|f=X<rsup|n>-n*X<rsup|n-1>+<binom|n|2>*X<rsup|n-2>+\<cdots\>+<around|(|-1|)><rsup|n>>
    with an <math|n>-fold zero, we obtain

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<chi\><rsub|f<rsup|std>><around|(|x|)>>|<cell|=>|<cell|<frac|<around|(|<around|\||x|\|>+1|)><rsup|n-1>|<around|\||x-1|\|><rsup|n-1>>.>>>>
    </eqnarray*>

    At a distance <math|\<varepsilon\>> of the zero, ball arithmetic thus
    produces bounds which are <math|<around|(|2/\<varepsilon\>|)><rsup|n-1>>
    times too pessimistic.
  </example>

  <\remark>
    An interesting problem is whether a good understanding of the pointwise
    overestimation also helps us to bound the overestimation on more general
    balls. One concrete question is whether we have

    <\eqnarray*>
      <tformat|<table|<row|<cell|rad f<rsup|std><around|(|\<b-x\>|)>>|<cell|\<leqslant\>>|<cell|<around*|(|sup<rsub|x\<in\>\<b-x\>>
      \<chi\><rsub|f<rsup|std>><around|(|x|)>|)>*rad
      f<rsup|best><around|(|\<b-x\>|)>,>>>>
    </eqnarray*>

    for all polynomial dags <math|f> and balls <math|\<b-x\>>. This
    inequality seems to hold in all easy cases that we have looked at, but we
    do not have a proof that it holds in general.
  </remark>

  <subsection|Reducing the overestimation><label|reduce-overest-sec>

  The example<nbsp><reference|overest-ex> shows that standard ball arithmetic
  generally produces an infinite amount of overestimation near double or
  multiple zeros. This raises the problem how to compute better ball lifts
  which do not present this drawback.

  One possible remedy is to systematically compute the ball lifts using
  Taylor models. Indeed, assume that we want to evaluate <math|f> at the ball
  <math|\<b-x\>=c+\<cal-B\><around|(|\<rho\>|)>>. Let
  <math|D=\<cal-B\><around|(|\<rho\>|)>>,
  <math|\<cal-I\>><nbsp>and<nbsp><math|\<cal-J\>> be as in
  section<nbsp><reference|Taylor-sec> and let
  <math|<bT>=\<cal-B\><rsub|D><around|(|\<bbb-K\><around|[|\<epsilon\>|]><rsub|\<cal-I\>>,\<bbb-R\><around|[|\<epsilon\>|]><rsub|\<cal-J\>>|)>>
  be the corresponding domain of Taylor models in
  <math|\<epsilon\>=<around|(|\<epsilon\><rsub|1>,\<ldots\>,\<epsilon\><rsub|d>|)>>.
  Let <math|\<b-xi\>=<around|(|x<rsub|1>+\<epsilon\><rsub|1>,\<ldots\>,x<rsub|n>+\<epsilon\><rsub|d>|)>\<in\><bT><rsup|d>>
  and consider the Taylor model evaluation of <math|f> at <math|\<b-xi\>>

  <\eqnarray*>
    <tformat|<table|<row|<cell|f<around|(|\<b-xi\>|)>>|<cell|=>|<cell|P+\<cal-B\><rsub|D><around|(|E|)>.>>>>
  </eqnarray*>

  Then

  <\eqnarray*>
    <tformat|<table|<row|<cell|f<rsup|tay><around|(|\<b-x\>|)>>|<cell|\<assign\>>|<cell|P<rsup|std><around|(|\<cal-B\><around|(|\<rho\>|)>|)>+\<cal-B\><around|(|<around|\<lceil\>|E<rsup|std><around|(|\<cal-B\><around|(|\<rho\>|)>|)>|\<rceil\>>|)>>>>>
  </eqnarray*>

  yields an enclosure of <math|<around|{|f<around|(|x|)>:x\<in\>\<b-x\>|}>>.
  Although the evaluation of <math|f<rsup|tay><around|(|\<b-x\>|)>> is
  usually far more expensive than the evaluation of
  <math|f<rsup|std><around|(|\<b-x\>|)>>, let us now study how much the
  overestimation has been reduced.

  Let <math|\<cal-F\>=\<bbb-N\><rsup|d>\<setminus\>\<cal-I\>> and let us
  introduce the operator <math|<wide|D|\<bar\>><rsup|\<cal-F\>>:\<varepsilon\>\<mapsto\><wide|D|\<bar\>><rsup|\<cal-F\>><around|(|\<varepsilon\>|)>>,
  which generalizes the mapping <math|\<varepsilon\>\<mapsto\>\<varepsilon\>\<cdot\><wide|\<nabla\>|\<bar\>>>.
  The operator is defined by induction over the size of <math|f>:

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|(|<wide|D|\<bar\>><rsup|\<cal-F\>>
    c|)><around|(|\<varepsilon\>|)>>|<cell|=>|<cell|0<htab|5mm><around|(|c\<in\>\<bbb-K\>|)>>>|<row|<cell|<around|(|<wide|D|\<bar\>><rsup|\<cal-F\>>
    X<rsub|k>|)><around|(|\<varepsilon\>|)>>|<cell|=>|<cell|<choice|<tformat|<table|<row|<cell|0>|<cell|<with|mode|text|if
    ><around|(|0,<above|\<ldots\>|k-1>,0,1,0,\<ldots\>,0|)>\<in\>\<cal-I\>>>|<row|<cell|\<varepsilon\><rsub|k>>|<cell|<with|mode|text|otherwise>>>>>><htab|5mm><around|(|k\<in\><around|{|1,\<ldots\>,r|}>|)>>>|<row|<cell|<around|(|<wide|D|\<bar\>><rsup|\<cal-F\>><around|(|f\<pm\>g|)>|)><around|(|\<varepsilon\>|)>>|<cell|=>|<cell|<around|(|<wide|D|\<bar\>><rsup|\<cal-F\>>
    f|)><around|(|\<varepsilon\>|)>+<around|(|<wide|D|\<bar\>><rsup|\<cal-F\>>
    g|)><around|(|\<varepsilon\>|)>>>|<row|<cell|<around|(|<wide|D|\<bar\>><rsup|\<cal-F\>><around|(|f*g|)>|)><around|(|\<varepsilon\>|)>>|<cell|=>|<cell|<around|(|<around|(|<wide|D|\<bar\>><rsup|\<cal-F\>>
    f|)>*<around|\||g|\|>+<around|\||f|\|>*<around|(|<wide|D|\<bar\>><rsup|\<cal-F\>>
    g|)>|)><around|(|\<varepsilon\>|)>+<big|sum><rsub|<stack|<tformat|<table|<row|<cell|i,j\<in\>\<cal-I\>\<setminus\><around|{|0|}>>>|<row|<cell|i+j\<in\>\<cal-F\>>>>>>><tfrac|\<varepsilon\><rsup|i+j>|i!*j!>*<around|\||f<rsup|<around|(|i|)>>|\|>*<around|\||g<rsup|<around|(|j|)>>|\|>>>>>
  </eqnarray*>

  For <math|\<b-xi\>=<around|(|x<rsub|1>+\<epsilon\><rsub|1>,\<ldots\>,x<rsub|n>+\<epsilon\><rsub|d>|)>>
  as above, we then have

  <\eqnarray*>
    <tformat|<table|<row|<cell|f<around|(|\<b-xi\>|)>>|<cell|\<subseteq\>>|<cell|<around*|(|<big|sum><rsub|i\<in\>\<cal-I\>><frac|1|i!>*f<rsup|<around|(|i|)>><around|(|x|)>*\<epsilon\><rsup|i>|)>+\<cal-B\><rsub|D><around|(|<around|(|<wide|D|\<bar\>><rsup|\<cal-F\>>
    f|)><around|(|\<rho\>|)>|)>.>>>>
  </eqnarray*>

  Now assume that <math|\<cal-I\>=\<cal-J\>=\<cal-T\><rsub|n>=<around|{|i\<in\>\<bbb-N\><rsup|d>:<around|\<\|\|\>|i|\<\|\|\>>\<leqslant\>n|}>>
  and let <math|\<mu\>> be the valuation of <math|f> at <math|x>. If
  <math|\<mu\>\<less\>n>, then we have

  <\eqnarray*>
    <tformat|<table|<row|<cell|rad f<rsup|best><around|(|x+\<cal-B\><around|(|\<rho\>|)>|)>>|<cell|=>|<cell|sup<rsub|\<varepsilon\>\<in\>\<cal-B\><around|(|r|)>>
    <around*|\||<big|sum><rsub|<around|\<\|\|\>|i|\<\|\|\>>=\<mu\>><frac|1|i!>*f<rsup|<around|(|i|)>><around|(|x|)>*\<rho\><rsup|i>|\|>+\<cal-O\><around|(|\<rho\><rsup|\<mu\>+1>|)><eq-number><label|best-mu>>>|<row|<cell|rad
    f<rsup|tay><around|(|x+\<cal-B\><around|(|\<rho\>|)>|)>>|<cell|=>|<cell|sup<rsub|\<varepsilon\>\<in\>\<cal-B\><around|(|r|)>>
    <around*|\||<big|sum><rsub|<around|\<\|\|\>|i|\<\|\|\>>=\<mu\>><frac|1|i!>*f<rsup|<around|(|i|)>><around|(|x|)>*\<rho\><rsup|i>|\|>+\<cal-O\><around|(|\<rho\><rsup|\<mu\>+1>|)><eq-number><label|tay-mu>>>|<row|<cell|\<chi\><rsub|f<rsup|tay>><around|(|x|)>>|<cell|=>|<cell|1.<eq-number><label|tay-qual>>>>>
  </eqnarray*>

  If <math|\<mu\>=n>, then we still have<nbsp>(<reference|best-mu>),
  but<nbsp>(<reference|tay-mu>) and<nbsp>(<reference|tay-qual>) become

  \;

  <\eqnarray*>
    <tformat|<table|<row|<cell|rad f<rsup|tay><around|(|x+\<cal-B\><around|(|\<rho\>|)>|)>>|<cell|\<leqslant\>>|<cell|<around|(|<wide|D|\<bar\>><rsup|\<cal-F\>>
    f|)><around|(|\<rho\>|)>>>|<row|<cell|\<chi\><rsub|f<rsup|tay>><around|(|x|)>>|<cell|=>|<cell|limsup<rsub|\<varepsilon\>\<neq\>0>
    <frac|<around|(|<wide|D|\<bar\>><rsup|\<cal-F\>>
    f|)><around|(|\<varepsilon\>|)>|<around*|\||<big|sum><rsub|<around|\<\|\|\>|i|\<\|\|\>>=n><frac|1|i!>*f<rsup|<around|(|i|)>><around|(|x|)>*\<varepsilon\><rsup|i>|\|>>.>>>>
  </eqnarray*>

  If <math|\<mu\>\<gtr\>n>, then we generally have

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<chi\><rsub|f<rsup|tay>><around|(|x|)>>|<cell|=>|<cell|\<infty\>,>>>>
  </eqnarray*>

  although <math|\<chi\><rsub|f<rsup|tay>><around|(|x|)>\<less\>\<infty\>>
  may occur in lucky cases.

  <section|Numeric path tracking><label|num-hom-sec>

  <subsection|General framework>

  Let <math|\<Omega\>> be an open subset of <math|\<bbb-C\><rsup|n>> and
  <math|H:\<Omega\>\<times\>\<bbb-C\>\<rightarrow\>\<bbb-C\><rsup|n>> an
  analytic function. We consider <math|H> as a<nbsp>function
  <rigid|<math|H<around|(|z,t|)>>> in <math|z> and the <em|time> <math|t>,
  where <math|z\<in\>\<Omega\>> and <math|t\<in\>\<bbb-C\>>, and also call
  <math|H> a <em|homotopy>. Assuming that <math|H<around|(|z<rsub|1>,1|)>=0>
  for some <math|z<rsub|1>\<in\>\<Omega\>> and that we are not in a
  ``degenerate'' case, there exists a<nbsp>unique analytic function
  <math|<around|[|0,1|]>\<rightarrow\>\<Omega\>:t\<mapsto\>z<rsub|t>> with
  <math|H<around|(|z<rsub|t>,t|)>=0> for all <math|t>. We are interested in
  the value of <math|z<rsub|t>> when <math|t\<rightarrow\>0>. More generally,
  given a vector <math|z<rsub|1>=<around|(|z<rsup|1><rsub|1>,\<ldots\>,z<rsup|k><rsub|1>|)>\<in\>\<Omega\><rsup|k>>
  of vectors, there exists a unique function
  <math|<around|[|0,1|]>\<rightarrow\>\<Omega\><rsup|k>:t\<mapsto\>z<rsub|t>>
  with <math|H<around|(|z<rsup|1><rsub|t>,t|)>=\<cdots\>=H<around|(|z<rsup|k><rsub|t>,t|)>=0>
  for all <math|t>.

  The goal of a numeric path tracker is to approximate the function
  <math|t\<mapsto\>z<rsub|t>> as well and as quickly possible and, above all,
  to compute its value <math|z<rsub|0>> at the ``end point'' <math|t=0>. In
  what follows, we will denote by <math|<wide|\<bbb-R\>|~>=\<bbb-R\><rsub|p>>
  the set of floating point numbers with <math|p><nbsp>bit mantissas. We also
  define <math|<wide|\<bbb-C\>|~>=\<bbb-C\><rsub|p>=\<bbb-R\><rsub|p><around|[|\<mathi\>|]>>,
  <math|<wide|\<Omega\>|~>=\<Omega\>\<cap\><wide|\<bbb-C\>|~>> and assume
  that we have a program for computing a<nbsp>numeric approximation
  <math|<wide|H|~>:<smash|<wide|\<Omega\>|~>>\<times\><wide|\<bbb-C\>|~>\<rightarrow\><smash|<wide|\<bbb-C\>|~>><rsup|n>>
  of <math|H>. Given <math|z<rsub|1>\<in\><smash|<wide|\<Omega\>|~>>> with
  <math|<wide|H|~><around|(|z<rsub|1>,1|)>\<approx\>0>, we thus want to
  compute <math|z<rsub|0>\<in\><smash|<wide|\<Omega\>|~>>> with
  <math|<wide|H|~><around|(|z<rsub|0>,0|)>\<approx\>0>, by following the
  homotopy.

  In many cases, we will be interested in homotopies for solving a system

  <\equation>
    <label|pol-sys>P<rsub|1><around|(|z|)>=\<cdots\>=P<rsub|n><around|(|z|)>=0
  </equation>

  of polynomial equations. The number <math|d> of solutions to a generic
  system of this kind is given by the Bezout number
  <math|d=d<rsub|1>*\<cdots\>*d<rsub|n>>, where <math|d<rsub|i>> is the total
  degree of <math|P<rsub|i>> for each <math|i>. For suitable scaling
  parameters <math|\<lambda\><rsub|1>,\<ldots\>,\<lambda\><rsub|n>,\<sigma\><rsub|1>,\<ldots\>,\<sigma\><rsub|n>\<in\>\<bbb-C\>>,
  we now define <math|H:\<bbb-C\><rsup|n+1>\<rightarrow\>\<bbb-C\>> by

  <\eqnarray*>
    <tformat|<table|<row|<cell|H<rsub|1><around|(|z,t|)>>|<cell|=>|<cell|<around|(|1-t|)>*P<rsub|1><around|(|z,t|)>+t*\<lambda\><rsub|1>*<around|(|z<rsup|d<rsub|1>>-\<sigma\><rsub|1><rsup|d<rsub|1>>|)>>>|<row|<cell|>|<cell|\<vdots\>>|<cell|>>|<row|<cell|H<rsub|n><around|(|z,t|)>>|<cell|=>|<cell|<around|(|1-t|)>*P<rsub|n><around|(|z,t|)>+t*\<lambda\><rsub|n>*<around|(|z<rsup|d<rsub|n>>-\<sigma\><rsub|n><rsup|d<rsub|n>>|)>.>>>>
  </eqnarray*>

  Let

  <\eqnarray*>
    <tformat|<table|<row|<cell|K>|<cell|=>|<cell|<around|{|0,\<ldots\>,d<rsub|1>-1|}>\<times\>\<cdots\>\<times\><around|{|0,\<ldots\>,d<rsub|n>-1|}>>>>>
  </eqnarray*>

  For any <math|k\<in\>K>, the point

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsup|k><rsub|1>>|<cell|=>|<cell|<around|(|\<sigma\><rsub|1>*\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*k<rsub|1>/d<rsub|1>>,\<ldots\>,\<sigma\><rsub|n>*\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*k<rsub|n>/d<rsub|n>>|)>>>>>
  </eqnarray*>

  clearly satisfies <math|H<around|(|z<rsup|k><rsub|1>|)>=0>, whereas any
  <math|z<rsup|k><rsub|0>> with <math|H<around|(|z<rsup|k><rsub|0>,0|)>=0>
  satisfies <math|P<around|(|z<rsup|k><rsub|0>|)>=0>.

  If the system<nbsp>(<reference|pol-sys>) is zero dimensional and the values
  <math|\<lambda\><rsub|1>,\<ldots\>,\<lambda\><rsub|n>,\<sigma\><rsub|1>,\<ldots\>,\<sigma\><rsub|n>>
  are complex and sufficiently random (we also say that the homotopy is in
  general position), then the system <math|H<rsub|1><around|(|z,t|)>=\<cdots\>=H<rsub|n><around|(|z,t|)>=0>
  is also zero dimensional for every <math|t\<in\><around|[|0,1|]>>. In what
  follows we will always assume that the homotopy has been chosen in such a
  way.

  <subsection|Solutions at infinity>

  One classical difficulty with homotopy methods for solving a polynomial
  system<nbsp>(<reference|pol-sys>) is that many of the solution paths
  <math|z<rsup|k><rsub|t>> may tend to infinity in the sense that
  <math|<around|(|z<rsup|k><rsub|t>|)><rsub|i>\<rightarrow\>\<infty\>> for
  some<nbsp><math|i> and <math|t\<rightarrow\>0>. Computations which
  infinities can be avoided by rewriting the equations in projective
  coordinates. More precisely, setting <math|z<rsup|pr>=<around|(|z<rsub|0>,\<ldots\>,z<rsub|n>|)>>,
  the projectivation <math|A<rsup|pr>\<in\>\<bbb-C\><around|[|z<rsup|pr>|]>>
  of a polynomial <math|A\<in\>\<bbb-C\><around|[|z|]>> is defined by

  <\eqnarray*>
    <tformat|<table|<row|<cell|A<rsup|pr><around|(|z<rsub|0>,\<ldots\>,z<rsub|n>|)>>|<cell|=>|<cell|z<rsub|0><rsup|deg
    A>*A<around|(|<tfrac|z<rsub|1>|z<rsub|0>>,\<ldots\>,<tfrac|z<rsub|n>|z<rsub|0>>|)>.>>>>
  </eqnarray*>

  Applying this to the system<nbsp>(<reference|pol-sys>), we obtain a new
  system

  <\equation>
    <label|pr-sys>P<rsub|1><rsup|pr><around|(|z<rsup|pr>|)><space|0.6spc>=<space|0.6spc>\<cdots\><space|0.6spc>=<space|0.6spc>P<rsup|pr><rsub|n><around|(|z<rsup|pr>|)><space|0.6spc>=<space|0.6spc>0
  </equation>

  of homogeneous equations in <math|z<rsup|pr>>. For a random hyperplane

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<alpha\><rsub|0>*z<rsub|0>+\<cdots\>+\<alpha\><rsub|n>*z<rsub|n>>|<cell|=>|<cell|\<beta\>,<eq-number><label|rnd-hyp>>>>>
  </eqnarray*>

  the composite system (<reference|pr-sys>--<reference|rnd-hyp>) is again
  zero dimensional, but without solutions at infinity. It is easy to
  reconstruct solutions to<nbsp>(<reference|pol-sys>) from solutions
  to<nbsp>(<reference|pr-sys>--<reference|rnd-hyp>) and <em|vice versa>.

  <subsection|Predictor corrector methods>

  Assume that we have a way to approximate the Jacobian <math|J<rsub|H>> of
  <math|H> by <rigid|<math|<wide|J|~><rsub|H>:<smash|<wide|\<Omega\>|~>>\<rightarrow\><smash|<wide|\<bbb-C\>|~>><rsup|n\<times\><around|(|n+1|)>>>>.
  For instance, if <math|H> is given by a dag, then a dag for
  <math|J<rsub|H>> can be computed using forward differentiation, and
  <math|<wide|J|~><rsub|H>> just corresponds to the approximated evaluation
  of this dag.

  Assume that we are given <math|y=<wide|H|~><around|(|z,t|)>> and
  <math|<wide|J|~><rsub|H><around|(|z,t|)>> at a certain point where
  <rigid|<math|<wide|H|~><around|(|z,t|)>\<approx\>0>>. We may write
  <math|<wide|J|~><rsub|H><around|(|z,t|)>=<around|(|U,<wide|y|\<dot\>>|)>>
  as the horizontal join of two matrices <math|U\<in\><smash|<wide|\<bbb-C\>|~>><rsup|n\<times\>n>>
  and <math|<wide|y|\<dot\>>\<in\><smash|<wide|\<bbb-C\>|~>><rsup|n\<times\>1>>.
  Given <math|t<rprime|'>=t+d<rsub|t>> close to <math|t>, we may find a
  <math|z<rsup|<around|(|1|)>>> for which
  <math|<wide|H|~><around|(|z<rsup|<around|(|1|)>>,t<rprime|'>|)>\<approx\>0>
  using Euler-Newton's method

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsup|<around|(|1|)>>>|<cell|=>|<cell|z-U<rsup|-1><around|(|y+<wide|y|\<dot\>>*<around|(|t<rprime|'>-t|)>|)>.>>>>
  </eqnarray*>

  The replacement <math|<around|(|z,t|)>\<rightsquigarrow\><around|(|z<rsup|<around|(|1|)>>,t<rprime|'>|)>>
  is called a <em|prediction> step. We may still apply the formula when
  <math|t<rprime|'>=t>, in which case <math|z<rprime|'>> is usually a better
  approximation than <math|z> to a genuine zero of <math|H> at <math|t> than
  <math|z>. In this situation, the replacement
  <math|<around|(|z,t|)>\<rightsquigarrow\><around|(|z<rsup|<around|(|1|)>>,t|)>>
  is called a <em|correction> step.

  From the computational point of view, the evaluation of the Jacobian
  <math|J<rsub|<wide|H|~>><around|(|z,t|)>> is usually about <math|n> times
  more expensive than the evaluation of the function
  <math|<wide|H|~><around|(|z,t|)>> itself (except for large <math|n> and
  sparse <math|J<rsub|<wide|H|~>>>). Instead of reevaluating the Jacobian
  after the prediction step at <math|<around|(|z<rsup|<around|(|1|)>>,t<rprime|'>|)>>,
  it may therefore be worth it to perform a few correction steps using the
  Jacobian at <math|<around|(|z,t|)>> instead:

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsup|<around|(|2|)>>>|<cell|=>|<cell|z<rsup|<around|(|1|)>>-U<rsup|-1>*<wide|H|~><around|(|z<rsup|<around|(|1|)>>,t<rprime|'>|)>>>|<row|<cell|>|<cell|\<vdots\>>|<cell|>>|<row|<cell|z<rsup|<around|(|\<kappa\>|)>>>|<cell|=>|<cell|z<rsup|<around|(|\<kappa\>-1|)>>-U<rsup|-1>*<wide|H|~><around|(|z<rsup|<around|(|\<kappa\>-1|)>>,t<rprime|'>|)>.>>>>
  </eqnarray*>

  Since the convergence of <math|z<rsup|<around|(|1|)>>,z<rsup|<around|(|2|)>>,\<ldots\>>
  is only linear, the number <math|\<kappa\>> is typically chosen quite small
  (<math|\<kappa\>\<leqslant\>3>). One full prediction-correction cyclus now
  just consists of the replacement <math|<around|(|z,t|)>\<rightsquigarrow\><around|(|z<rprime|'>,t<rprime|'>|)>=<around|(|z<rsup|<around|(|\<kappa\>|)>>,t<rprime|'>|)>>.

  From the complexity point of view, the evaluation of <math|<wide|H|~>> and
  <math|J<rsub|<wide|H|~>>> is usually far more expensive than the cost
  <math|\<cal-O\><around|(|n<rsup|3>|)>> of linear algebra at size <math|n>,
  at least for the examples we will be interested in here. Therefore, it will
  not be necessary to device the linear algebra algorithms with special care
  (for instance, we may simply compute the inverse <math|U<rsup|-1>> once and
  for all, instead of using LU decompositions). On the other hand, we
  typically want to increase the step size <math|t<rprime|'>-t> as much as
  possible, while trying to stay reasonably close to the true solution path.

  <subsection|Precision control><label|num-prec-sec>

  One obvious source of numeric errors is when the numeric precision being
  used is insufficient for producing sensible results. In<nbsp><cite|BSHW08>,
  a strategy has been proposed for selecting a<nbsp>sufficient precision for
  homotopy methods to be numerically reliable. We will now propose an
  alternative method for finding such a precision, whose justification is
  based on a simpler argument.

  Let <math|p> be the current working precision. Our method is based on the
  following idea: when evaluating <math|y=<wide|H|~><around|(|z,t|)>>, the
  actual precision <math|q> of the result is usually smaller
  than<nbsp><math|p> and of the form <math|q=p-c> for some fixed constant. We
  will call <math|q> the <em|effective precision> and we may expect the
  numeric evaluations to be reliable as long as <math|p> is picked
  sufficiently large such that <math|q\<geqslant\>\<tau\><rsub|0>> remains
  above a<nbsp>certain threshold <math|\<tau\><rsub|0>\<gtr\>0> (<abbr|e.g.>
  <math|\<tau\><rsub|0>=10>).

  We still need a more precise definition of the effective precision or a
  simple way to compute<nbsp>it. Assuming that <math|<wide|H|~>> admits a
  ball lift, we may evaluate <math|\<b-y\>=<wide|H|~><around|(|\<b-z\>,\<b-t\>|)>>
  at the ball <math|<around|(|\<b-z\>,\<b-t\>|)>=<around|(|z+\<cal-B\><around|(|0|)>,t+\<cal-B\><around|(|0|)>|)>\<in\>\<cal-B\><around|(|\<bbb-C\><rsub|p>,\<bbb-R\><rsub|p>|)><rsup|n+1>>.
  Then

  <\eqnarray*>
    <tformat|<table|<row|<cell|q<rsub|rel><around|(|z,t|)>>|<cell|=>|<cell|min<rsub|i>
    <around*|\<lfloor\>|log<rsub|2> <frac|<around|\||cen<around|(|\<b-y\><rsub|i>|)>|\|>|rad<around|(|\<b-y\><rsub|i>|)>>|\<rfloor\>>>>>>
  </eqnarray*>

  provides an estimate for the relative precision of <math|\<b-y\>>. If
  <math|<wide|H|~><around|(|z,t|)>\<approx\>0>, then this precision is
  potentially quite low. In that case, we may also consider
  <math|q<rsub|rel><around|(|z,t<rprime|'>|)>> at the next time
  <math|t<rprime|'>=t+d<rsub|t>>. Instead of performing one extra ball
  evaluation, we may also use the following approximation of
  <math|q<rsub|rel><around|(|z,t<rprime|'>|)>>:

  <\eqnarray*>
    <tformat|<table|<row|<cell|q<rsub|rel><rsup|\<ast\>><around|(|z,t<rprime|'>|)>>|<cell|=>|<cell|min<rsub|i>
    <around*|\<lfloor\>|log<rsub|2> <frac|<around|\||cen<around|(|\<b-y\><rsub|i>|)>+<wide|H|~><rsub|t><around|(|z,t|)><rsub|i>*d<rsub|t>|\|>|rad<around|(|\<b-y\><rsub|i>|)>>|\<rfloor\>>.>>>>
  </eqnarray*>

  We now take

  <\eqnarray*>
    <tformat|<table|<row|<cell|q=q<around|(|z,t,t<rprime|'>|)>>|<cell|=>|<cell|min<rsub|i>
    <around*|\<lfloor\>|log<rsub|2> <frac|max<around|{|<around|\||cen<around|(|\<b-y\><rsub|i>|)>|\|>,<around|\||cen<around|(|\<b-y\><rsub|i>|)>+<wide|H|~><rsub|t><around|(|z,t|)><rsub|i>*d<rsub|t>|\|>|}>|rad<around|(|\<b-y\><rsub|i>|)>>|\<rfloor\>>.>>>>
  </eqnarray*>

  for the current effective precision at <math|<around|(|z,t|)>> and assuming
  a current step size <math|d<rsub|t>>.

  <subsection|Step size control><label|step-control-sec>

  Since purely numeric homotopy methods are usually being designed for speed,
  the main focus is not on being 100% fool proof. Nevertheless, it remains
  worth it to search for cheap ways in order to detect errors and adapt the
  stepsize so as to avoid potential errors.

  Now assume that we perform one full prediction correction cyclus
  <math|<around|(|z,t|)>\<rightsquigarrow\><around|(|z<rprime|'>,t<rprime|'>|)>>.
  We first need a criterion for when to accept such a step. The main problem
  with the design of numeric criteria is there is no way to decide whether a
  numeric quantity is small or large; such checks can only be performed with
  respect to other quantities. Instead of checking whether we remain close to
  the genuine solution path, it is therefore more robust to check that the
  Jacobian <math|<wide|J|~><rsub|H>> does not change not change to quickly on
  the interval <math|<around|[|t,t<rprime|'>|]>>.

  More precisely, let <math|y=<wide|H|~><around|(|z,t|)>>,
  <rigid|<math|<around|(|U,<wide|y|\<dot\>>|)>=<wide|J|~><rsub|H><around|(|z,t|)>>>,
  <math|y<rprime|'>=<wide|H|~><around|(|z<rprime|'>,t<rprime|'>|)>> and
  <rigid|<math|<around|(|U<rprime|'>,<wide|y|\<dot\>><rprime|'>|)>=<wide|J|~><rsub|H><around|(|z<rprime|'>,t<rprime|'>|)>>>.
  Then it is natural to only accept steps for which

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\<\|\|\>|U<rsup|-1>*U<rprime|'>-1|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|\<tau\><rsub|1>,<eq-number><label|accept-crit>>>>>
  </eqnarray*>

  for a fixed threshold <math|\<tau\><rsub|1>\<less\>1> (<abbr|e.g.>
  <math|\<tau\><rsub|1>=<frac|1|4>>). Here we may use any matrix norm
  <math|<around|\<\|\|\>|\<cdot\>|\<\|\|\>>>, so it is most convenient to
  chose one which is easy to compute:

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\<\|\|\>|M|\<\|\|\>>>|<cell|=>|<cell|<big|sum><rsub|i>max<rsub|j>
    <around|\||M<rsub|i,j>|\|>.>>>>
  </eqnarray*>

  The condition<nbsp>(<reference|accept-crit>) is not fully satisfactory yet,
  since it relies on the expensive computation of a Jacobian
  <math|U<rprime|'>>. This is acceptable if the step has a good chance of
  being accepted (since we will need the Jacobian anyway for the next step),
  but annoying if the step is to be rejected. Before
  checking<nbsp>(<reference|accept-crit>), it is therefore wise to perform a
  few cheaper checks in order to increase the probability
  that<nbsp>(<reference|accept-crit>) will hold indeed. In particular, if
  <math|\<kappa\>\<geqslant\>2>, then we may verify that

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\<\|\|\>|U<rsup|-1>*<around|(|y<rprime|'>-y<rsup|<around|(|1|)>>|)>-<around|(|z<rprime|'>-z<rsup|<around|(|1|)>>|)>|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|\<tau\><rsub|2>*<around|\<\|\|\>|z<rprime|'>-z<rsup|<around|(|1|)>>|\<\|\|\>><eq-number><label|ind-crit>>>>>
  </eqnarray*>

  for the max-norm on vectors, where <math|\<tau\><rsub|2>\<leqslant\>\<tau\><rsub|1>>
  (<abbr|e.g.> <math|\<tau\><rsub|2>=<frac|1|2>*\<tau\><rsub|1>>) and
  <math|y<rsup|<around|(|1|)>>=<wide|H|~><around|(|z<rsup|<around|(|1|)>>,t<rprime|'>|)>>.
  This simplified check is linked to<nbsp>(<reference|accept-crit>) by
  remarking that <math|y<rprime|'>-y<rsup|<around|(|1|)>>\<approx\>U<rprime|'>*<around|(|z<rprime|'>-z|)>>.
  The new check<nbsp>(<reference|ind-crit>) should not be applied when
  <math|z<rprime|'>> and<nbsp><math|z<rsup|<around|(|1|)>>> are too close for
  <math|y<rprime|'>> and <math|y<rsup|<around|(|1|)>>> to be computed with
  sufficient precision. More precisely, it should really be replaced by the
  check

  <\eqnarray*>
    <tformat|<table|<row|<cell|>|<cell|>|<cell|<choice|<tformat|<table|<row|<cell|<around|\<\|\|\>|U<rsup|-1>*<around|(|y<rprime|'>-y<rsup|<around|(|1|)>>|)>-<around|(|z<rprime|'>-z<rsup|<around|(|1|)>>|)>|\<\|\|\>>\<leqslant\>\<tau\><rsub|2>*<around|\<\|\|\>|z<rprime|'>-z<rsup|<around|(|1|)>>|\<\|\|\>>\<vee\>\<nosymbol\>>>|<row|<cell|<around|\<\|\|\>|z<rprime|'>-z<rsup|<around|(|1|)>>|\<\|\|\>>\<leqslant\>2<rsup|-\<tau\><rsub|3>*q<around|(|z,t,t<rprime|'>|)>>*<around|\<\|\|\>|z<rsup|<around|(|1|)>>|\<\|\|\>>,>>>>><eq-number><label|improved-crit>>>>>
  </eqnarray*>

  where <math|\<tau\><rsub|3>> is slightly smaller than one (<abbr|e.g.>
  <math|\<tau\><rsub|3>=<frac|3|4>>) and <math|q<around|(|z,t,t<rprime|'>|)>>
  stands for the ``effective working precision'' from
  section<nbsp><reference|num-prec-sec>.

  In addition to the above checks, one might wish to ensure that
  <math|y<rprime|'>> is reasonably small after each step. Unfortunately,
  there is no satisfactory reference with respect which smallness can be
  checked, except for <math|y<rsup|<around|(|1|)>>,\<ldots\>,y<rsup|<around|(|\<kappa\>-1|)>>>.
  The best we can do therefore consists of checking whether
  <math|y<rsup|<around|(|1|)>>,y<rsup|<around|(|2|)>>,\<ldots\>> tend to
  <math|0> at some indicated rate:

  <\eqnarray*>
    <tformat|<table|<row|<cell|>|<cell|>|<cell|<choice|<tformat|<table|<row|<cell|<around|\<\|\|\>|y<rsup|<around|(|i+1|)>>|\<\|\|\>>\<leqslant\>\<tau\><rsub|4>*<around|\<\|\|\>|y<rsup|<around|(|i|)>>|\<\|\|\>>\<vee\>>>|<row|<cell|<around|\<\|\|\>|z<rsup|<around|(|i+1|)>>-z<rsup|<around|(|i|)>>|\<\|\|\>>\<leqslant\>2<rsup|-\<tau\><rsub|4>*q<around|(|z,t,t<rprime|'>|)>>*<around|\<\|\|\>|z<rsup|<around|(|i|)>>|\<\|\|\>>,>>>>><eq-number><label|newton-crit>>>>>
  </eqnarray*>

  for all <math|i\<less\>\<kappa\>>, where <math|\<tau\><rsub|4>\<less\>1>
  (<abbr|e.g.> <math|\<tau\><rsub|4>=<frac|1|2>>). Again, we need to insert a
  safety exemption for the case when the convergence is exceptionally good.

  Once that we have a criterion on whether a step
  <math|<around|(|z,t|)>\<rightsquigarrow\><around|(|z<rprime|'>,t<rprime|'>|)>>
  should be accepted, an algorithm for automatic stepsize control is easily
  implemented: assuming that we are walking from <math|t=1> to <math|t=0>, we
  start by setting <math|d<rsub|t>\<assign\>-1>. Given <math|t> and
  <math|d<rsub|t>>, we try a step <rigid|<math|<around|(|z,t|)>\<rightsquigarrow\><around|(|z<rprime|'>,t<rprime|'>|)>>>
  until <math|t<rprime|'>\<assign\>t+d<rsub|t>>. If the step fails, then we
  set <math|d<rsub|t>\<assign\>\<lambda\><rsub|fail>*d<rsub|t>> with
  <math|\<lambda\><rsub|fail>\<less\>1> (<abbr|e.g.>
  <math|\<lambda\><rsub|fail>=<frac|1|2>>), and retry for the smaller
  stepsize. Otherwise, we accept the step <math|t\<assign\>t<rprime|'>> and
  set <math|d<rsub|t>\<assign\>\<lambda\><rsub|ok>*d<rsub|t>> for the next
  step, where <math|\<lambda\><rsub|ok>\<gtr\>1> (<abbr|e.g.>
  <math|\<lambda\><rsub|ok>=<sqrt|2>>).

  <subsection|Near collisions><label|near-coll-sec>

  Another way to look at the numerical error problem is to investigate what
  can actually go wrong. Theoretically speaking, around each true solution
  path <math|z<rsub|t>>, there exists a small tube<nbsp><math|T<rsub|t>> of
  variable polyradius<nbsp><math|r<rsub|t>>, where Newton's method converges
  to the true solution<nbsp><math|z<rsub|t>>. As long as our current
  approximation <math|z> at time <math|t> remains in this tube
  <math|T<rsub|t>>, no errors will occur. Now the Newton iterations have a
  strong tendency of projecting back into the tubes, especially if we use the
  additional safeguard<nbsp>(<reference|newton-crit>). Nevertheless, it might
  happen that we jump from one tube into another tube, whenever two solution
  paths come close together.

  If we are considering a homotopy for solving a polynomial system
  <math|P<rsub|1>=\<cdots\>=P<rsub|n>>, then various solution paths will
  actually meet at <math|t=0> if the system admits multiple roots. Such
  multiple roots are an intrinsic difficulty and we will need dedicated ``end
  game'' strategies to ensure good numeric convergence in this case (see
  section<nbsp><reference|num-mul-roots-sec> below).

  For <math|t\<gtr\>0>, and for suitably prepared functions <math|H>, the
  Lebesgue probability that two solutions paths meet at a point is zero.
  Nevertheless, we may have near collisions, which usually occur in pairs:
  the probability that more than two paths simultaneously pass close to a
  same point is extremely low.

  So assume that we have a near collision of two solution paths. Then we have
  a true collision at <math|<around|(|z<rsub|\<ast\>>,t<rsub|\<ast\>>|)>> for
  some complex time <math|t<rsub|\<ast\>>> near the real axis. Locally around
  this collision point, the two paths are then given by

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsub|t><rsup|\<pm\>>>|<cell|=>|<cell|z<rsub|\<ast\>>\<pm\>u*<sqrt|t-t<rsub|\<ast\>>>+\<cal-O\><around|(|t-t<rsub|\<ast\>>|)>,>>>>
  </eqnarray*>

  for some vector <math|u>. If we only know <math|z<rsub|t><rsup|+>> at a few
  points, then we may try to compute <math|z<rsub|\<ast\>>>,
  <math|t<rsub|\<ast\>>> and <math|u>, and also check whether the second path
  <math|z<rsub|t><rsup|->> indeed exists.

  Now assume that we have approximated <math|z<rsub|t><rsup|+>> and
  derivative <math|<wide|z|\<dot\>><rsub|t><rsup|+>=\<mathd\>
  z<rsub|t><rsup|+>/\<mathd\> t> at two times
  <math|t<rsub|1>\<gtr\>t<rsub|2>>. Denote these approximations by
  <math|<wide|z|~><rsub|1>=<wide|z|~><rsub|1><rsup|+>\<approx\>z<rsub|t<rsub|1>><rsup|+>>,
  <math|<wide|<wide|z|\<dot\>>|~><rsub|1>\<approx\><wide|z|\<dot\>><rsub|t<rsub|1>><rsup|+>>,
  <math|<wide|z|~><rsub|2>=<wide|z|~><rsub|2><rsup|+>\<approx\>z<rsub|t<rsub|2>><rsup|+>>
  and <math|<wide|<wide|z|\<dot\>>|~><rsub|2>\<approx\><wide|z|\<dot\>><rsub|t<rsub|2>><rsup|+>>.
  Then

  <\eqnarray*>
    <tformat|<table|<row|<cell|<wide|<wide|z|\<dot\>>|~><rsub|i>>|<cell|\<approx\>>|<cell|<frac|u|2*<sqrt|t<rsub|i>-t<rsub|\<ast\>>>>>>>>
  </eqnarray*>

  for <math|i\<in\><around|{|1,2|}>>, whence we may use the following
  approximations for <math|z<rsub|\<ast\>>,t<rsub|\<ast\>>> and <math|u>:

  <\eqnarray*>
    <tformat|<cwith|1|1|3|3|cell-bsep|1spc>|<cwith|2|2|3|3|cell-bsep|1spc>|<table|<row|<cell|<wide|t|~><rsub|\<ast\>>>|<cell|\<assign\>>|<cell|<frac|<around|(|<wide|<wide|z|\<dot\>>|~><rsub|2>|)><rsup|2>*t<rsub|2>-<around|(|<wide|<wide|z|\<dot\>>|~><rsub|1>|)><rsup|2>*t<rsub|1>|<around|(|<wide|<wide|z|\<dot\>>|~><rsub|2>|)><rsup|2>-<around|(|<wide|<wide|z|\<dot\>>|~><rsub|1>|)><rsup|2>>>>|<row|<cell|<wide|u|~>>|<cell|\<assign\>>|<cell|2*<wide|<wide|z|\<dot\>>|~><rsub|2>*<sqrt|t<rsub|2>-<wide|t|~><rsub|*\<ast\>>>>>|<row|<cell|<wide|z|~><rsub|\<ast\>>>|<cell|\<assign\>>|<cell|<wide|z|~><rsub|2>-<wide|u|~>*<sqrt|t<rsub|2>-<wide|t|~><rsub|\<ast\>>>.>>>>
  </eqnarray*>

  We next perform several safety checks. First of all, we obtained
  <math|<wide|t|~><rsub|\<ast\>>> as the division of two vectors; we may use
  the mean value of the componentwise divisions and check that the variance
  remain small. We next verify that <math|<wide|z|~><rsub|1>-<wide|u|~>*<sqrt|t<rsub|1>-<wide|t|~><rsub|\<ast\>>>>
  and <math|<wide|z|~><rsub|\<ast\>>> are reasonably close. We also verify
  that the Newton iteration starting at <math|<wide|z|~><rsub|2><rsup|->=<wide|z|~><rsub|\<ast\>>-u*<sqrt|t<rsub|2>-<wide|t|~><rsub|\<ast\>>>>
  converges to a<nbsp>solution close to <math|<wide|z|~><rsub|2><rsup|->>. We
  finally verify that the same thing holds for
  <math|<wide|z|~><rsub|<wide|2|\<bar\>>><rsup|\<pm\>>=<wide|z|~><rsub|\<ast\>>\<pm\>u*<sqrt|t<rsub|<wide|2|\<bar\>>>-<wide|t|~><rsub|\<ast\>>>>
  instead of <math|<wide|z|~><rsub|2><rsup|\<pm\>>>, where
  <math|t<rsub|<wide|2|\<bar\>>>=Re <around|(|2*<wide|t|~><rsub|\<ast\>>-t<rsub|2>|)>>.

  We will not go into technical details on the precise numerical checks here,
  since section<nbsp><reference|hurd-step-sec> below contains a similar
  discussion for the case of multiple roots at <math|t=0>. We may also adapt
  the herd iteration from section<nbsp><reference|hurd-iter-sec> below to
  near collisions, which allows for the simultaneous continuation of
  <math|z<rsub|t><rsup|+>> and <math|z<rsub|t><rsup|->>. Contrary to the case
  when <math|t\<rightarrow\>0>, we also need to recompute better estimations
  of <math|t<rsub|\<ast\>>> at every step, which can be done <em|via> the
  simultaneous computation of <math|z<rsub|t><rsup|\<pm\>>> and the two
  ``conjugate'' paths <math|z<rsub|<wide|t|\<bar\>>><rsup|\<pm\>>> with
  <math|<wide|t|\<bar\>>=Re <around|(|2*<wide|t|~><rsub|\<ast\>>-t|)>>.
  Indeed, using the higher order expansion

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsub|t><rsup|\<pm\>>>|<cell|=>|<cell|z<rsub|\<ast\>>\<pm\>u*<sqrt|t-t<rsub|\<ast\>>>+v*<around|(|t-t<rsub|\<ast\>>|)>+w*<around|(|t-t<rsub|\<ast\>>|)><rsup|3/2>+\<cal-O\><around|(|<around|(|t-t<rsub|\<ast\>>|)><rsup|2>|)>,>>>>
  </eqnarray*>

  we get

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsub|t><rsup|+>+z<rsub|t><rsup|->>|<cell|=>|<cell|2*z<rsub|\<ast\>>+2*v*<around|(|t-t<rsup|\<ast\>>|)>+\<cal-O\><around|(|<around|(|t-t<rsup|\<ast\>>|)><rsup|2>|)>>>|<row|<cell|z<rsub|<wide|t|\<bar\>>><rsup|+>+z<rsub|<wide|t|\<bar\>>><rsup|->>|<cell|=>|<cell|2*z<rsub|\<ast\>>+2*v*<around|(|<wide|t|\<bar\>>-t<rsup|\<ast\>>|)>+\<cal-O\><around|(|<around|(|<wide|t|\<bar\>>-t<rsup|\<ast\>>|)><rsup|2>|)>>>|<row|<cell|<wide|z|\<dot\>><rsub|t><rsup|+>+<wide|z|\<dot\>><rsub|t><rsup|->>|<cell|=>|<cell|2*v+\<cal-O\><around|(|t-t<rsup|\<ast\>>|)>,>>>>
  </eqnarray*>

  from which we may deduce high quality approximations of
  <math|t<rsup|\<ast\>>> and <math|z<rsup|\<ast\>>>. As soon as
  <math|<wide|t|\<bar\>>-t> is small with respect to <math|Im
  t<rsub|\<ast\>>>, then the junction between paths and their conjugates
  occurs and we know how to traverse the near collision.

  <section|Multiple roots><label|num-mul-roots-sec>

  <subsection|Straightforward Euler-Newton type methods><label|num-univ-sec>

  Consider a homotopy induced by a polynomial
  system<nbsp>(<reference|pol-sys>) with a zero dimensional set of solutions.
  It frequently occurs that some of the solutions are multiple roots, in
  which case the predictor corrector algorithm slows down significantly when
  <math|t> approaches <math|0>. This is due to the fact that Newton's method
  only has a linear convergence if we are approaching a multiple root,
  whereas the convergence is quadratic for single roots.

  In order to get a better understanding of this phenomenon, it is
  instructive to quantify the slow down in the case of an <math|r>-fold root
  of a univariate polynomial <math|P>, which is more or less representative
  for the general case. In the neighbourhood of the root <math|\<alpha\>>, we
  have

  <\eqnarray*>
    <tformat|<table|<row|<cell|P<rsub|+\<alpha\>><around|(|z|)><space|0.6spc>\<assign\><space|0.6spc>P<around|(|\<alpha\>+z|)>>|<cell|=>|<cell|c*z<rsup|r>+\<cal-O\><around|(|z<rsup|r+1>|)>,>>>>
  </eqnarray*>

  with <math|c=<tfrac|1|r!>*P<rsup|<around|(|r|)>><around|(|\<alpha\>|)>>.
  Hence, the Newton iteration becomes

  <\eqnarray*>
    <tformat|<cwith|1|1|3|3|cell-bsep|1spc>|<table|<row|<cell|z<rprime|'>>|<cell|=>|<cell|z-<frac|P<rsub|+\<alpha\>><around|(|z|)>|P<rsub|+\<alpha\>><rprime|'><around|(|z|)>>>>|<row|<cell|>|<cell|=>|<cell|<around*|(|1-<tfrac|1|r>|)>*z+\<cal-O\><around|(|z<rsup|2>|)>.>>>>
  </eqnarray*>

  In particular, we see that we need roughly <math|r> iterations in order to
  divide <math|z> by <math|\<mathe\>>. We also notice that
  <math|P<around|(|\<alpha\>+z|)>> is roughly divided by <math|\<mathe\>> at
  every iteration. For complexity measures, it is more reasonable to study
  the speed of convergence of <math|P<around|(|\<alpha\>+z|)>> rather than
  <math|z> itself. Indeed, the relative precision of an <math|r>-fold root is
  intrinsically <math|r> times smaller than the working precision.

  If we are rather considering a homotopy
  <math|H<around|(|z,t|)>=<around|(|1-t|)>*P<around|(|z|)>+t*Q<around|(|z|)>>,
  then we usually have <math|q=Q<around|(|\<alpha\>|)>\<neq\>0>. Locally, we
  may thus write

  <\eqnarray*>
    <tformat|<table|<row|<cell|H<around|(|\<alpha\>+z,t|)>>|<cell|=>|<cell|c*z<rsup|r>+q*t+\<cal-O\><around|(|z<rsup|r+1>|)>+\<cal-O\><around|(|z*t|)>.>>>>
  </eqnarray*>

  Assume that we have <math|H<around|(|\<alpha\>+z,t|)>=0> for small <math|z>
  and <math|t\<gtr\>0>, so that

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsup|r>>|<cell|=>|<cell|-<tfrac|q|c>*t+\<cal-O\><around|(|z<rsup|r+1>|)>.>>>>
  </eqnarray*>

  Then the Euler-Newton iteration for step size <math|d<rsub|t>> yields

  <\eqnarray*>
    <tformat|<cwith|1|1|3|3|cell-bsep|1spc>|<table|<row|<cell|z<rprime|'>>|<cell|=>|<cell|z-<frac|q*d<rsub|t>|r*c*z<rsup|r-1>>>>|<row|<cell|>|<cell|=>|<cell|<around*|(|1-<frac|d<rsub|t>|r*t>|)>*z+\<cal-O\><around|(|z<rsup|2>|)>.>>>>
  </eqnarray*>

  Following our criterion<nbsp>(<reference|accept-crit>), we should have

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\||<around*|(|1-<frac|d<rsub|t>|r*t>|)><rsup|r-1>-1|\|>>|<cell|\<leqslant\>>|<cell|\<tau\><rsub|1>.>>>>
  </eqnarray*>

  Roughly speaking, this means that <math|d<rsub|t>\<leqslant\>\<tau\><rsub|1>*t>.
  Hence, <math|t> is multiplied by <math|1-\<tau\><rsub|1>> at every step and
  <math|z> is multiplied by <math|1-\<tau\><rsub|1>> every <math|r> steps.

  <subsection|The herd iteration><label|hurd-iter-sec>

  For high precision computations, it would be nice to have an algorithm with
  quadratic convergence in <math|t>. Before we give such an algorithm, let us
  first introduce some terminology and study the behaviour of the solutions
  paths when <math|t\<rightarrow\>0>.

  By assumption, we are given a system<nbsp>(<reference|pol-sys>) with an
  <math|r>-fold root <math|\<alpha\>\<in\>\<Omega\>>. Consider
  a<nbsp>solution path <math|z<rsub|t>> for the homotopy with
  <math|lim<rsub|t\<rightarrow\>0> z<rsub|t>=\<alpha\>>. Since
  <math|z<rsub|t>> is algebraic in <math|t>, we may expand

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsub|t>>|<cell|=>|<cell|\<alpha\>+c<rsub|1>*t<rsup|1/p>+c<rsub|2>*t<rsup|2/p>+\<cdots\>,>>>>
  </eqnarray*>

  as a Puiseux series in <math|t> for a certain ramification index <math|p>
  (which we assume to be taken minimal). Now letting <math|t> turn around
  <math|0> once, we have

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsub|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>>*t>>|<cell|=>|<cell|\<alpha\>+c<rsub|1>*\<omega\>*t<rsup|1/p>+c<rsub|2>*\<omega\><rsup|2>*t<rsup|2/p>+\<cdots\>,>>>>
  </eqnarray*>

  where <math|\<omega\>=\<mathe\><rsup|2*\<mathpi\>*\<mathi\>/p>>. When
  turning repeatedly, we thus obtain<nbsp><math|p> pairwise distinct
  solutions paths <math|z<rsup|k><rsub|t>\<assign\>z<rsub|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*k>*t>>
  with <math|k\<in\><around|{|0,\<ldots\>,p-1|}>>. We will call such
  a<nbsp>family of solution paths a <em|herd>.

  Contrary to the homotopy methods from section<nbsp><reference|num-hom-sec>,
  which operate on individual paths, the iteration that we will present now
  simultaneously operates on all paths in a herd. Consider a solution path
  <math|z<rsub|t>> with <math|lim<rsub|t\<rightarrow\>0> z<rsub|t>=\<alpha\>>
  as above and the corresponding herd <math|z<rsup|k><rsub|t>=z<rsub|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*k>*t>>
  with <math|k\<in\><around|{|0,\<ldots\>,p-1|}>>. We assume that both
  <math|<wide|z|~><rsup|k><rsub|t>\<approx\>z<rsup|k>> and
  <math|<wide|<wide|z|\<dot\>>|~><rsup|k><rsub|t>\<approx\><wide|z|\<dot\>><rsup|k><rsub|t>>
  are known for a<nbsp>given <math|t\<gtr\>0> and all
  <math|k\<in\><around|{|0,\<ldots\>,p-1|}>>. Let
  <math|<around|(|F<rsub|0>,\<ldots\>,F<rsub|p-1>|)>> and
  <math|<around|(|<wide|F|\<dot\>><rsub|0>,\<ldots\>,<wide|F|\<dot\>><rsub|p-1>|)>>
  denote the FFT-transforms of the vectors
  <math|<around|(|<wide|z|~><rsup|0><rsub|t>,\<ldots\>,<wide|z|~><rsup|p-1><rsub|t>|)>>
  and <math|<around|(|<wide|<wide|z|\<dot\>>|~><rsup|0><rsub|t>,\<ldots\>,<wide|<wide|z|\<dot\>>|~><rsup|p-1><rsub|t>|)>>
  with respect to <math|\<omega\><rsup|-1>>. Then we have

  <\eqnarray*>
    <tformat|<cwith|1|1|3|3|cell-bsep|1spc>|<cwith|2|2|3|3|cell-bsep|1spc>|<table|<row|<cell|F<rsub|k>>|<cell|=>|<cell|<big|sum><rsub|i=0><rsup|p-1><wide|z|~><rsup|i><rsub|t>*\<omega\><rsup|-i*k>>>|<row|<cell|>|<cell|=>|<cell|p*t<rsup|k/p>*<around|(|c<rsub|k>+c<rsub|k+p>*t+\<cal-O\><around|(|t<rsup|2>|)>|)>>>|<row|<cell|t*<wide|F|\<dot\>><rsub|k>>|<cell|=>|<cell|t<rsup|k/p>*<around|(|k*c<rsub|k>+<around|(|k+p|)>*c<rsub|k+p>*t+\<cal-O\><around|(|t<rsup|2>|)>|)>.>>>>
  </eqnarray*>

  for all <math|k>. We now compute <math|<wide|c|~><rsub|0>,\<ldots\>,<wide|c|~><rsub|2*p-1>>
  using the formulas

  <\eqnarray*>
    <tformat|<cwith|1|3|3|3|cell-bsep|1spc>|<table|<row|<cell|<wide|c|~><rsub|k+p>>|<cell|\<assign\>>|<cell|<tfrac|1|p*t<rsup|1+k/p>>*<around*|(|t*<wide|F|\<dot\>><rsub|k>-<tfrac|k|p>*F<rsub|k>|)>>>|<row|<cell|>|<cell|=>|<cell|c<rsub|k+p>+\<cal-O\><around|(|t|)>>>|<row|<cell|<wide|c|~><rsub|k>>|<cell|\<assign\>>|<cell|<tfrac|1|p*t<rsup|k/p>>*F<rsub|k>-<wide|c|~><rsub|k+p>*t>>|<row|<cell|>|<cell|=>|<cell|c<rsub|k>+\<cal-O\><around|(|t<rsup|2>|)>.>>>>
  </eqnarray*>

  For <math|t<rprime|'>\<gtr\>0> of the order of <math|t<rsup|2>>, we now
  have

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsup|k><rsub|t<rprime|'>>>|<cell|=>|<cell|<wide|z|~><rsup|k><rsub|t<rprime|'>>+\<cal-O\><around|(|t<rsup|2>|)>>>|<row|<cell|<wide|z|~><rsup|k><rsub|t<rprime|'>>>|<cell|\<assign\>>|<cell|<wide|c|~><rsub|0>+<wide|c|~><rsub|1>*\<omega\><rsup|k>*<around|(|t<rprime|'>|)><rsup|1/p>+\<cdots\>+<wide|c|~><rsub|2*p-1>*\<omega\><rsup|<around|(|2*p-1|)>*k>*<around|(|t<rprime|'>|)><rsup|<around|(|2*p-1|)>/p>,<eq-number><label|hurd-iter>>>>>
  </eqnarray*>

  for all <math|k\<in\><around|{|0,\<ldots\>,p-1|}>>. We
  call<nbsp>(<reference|hurd-iter>) the <em|herd prediction>. This prediction
  may be corrected using <math|\<kappa\>> conventional Newton iterations at
  time <math|t<rprime|'>>, for a fixed constant
  <math|\<kappa\>\<in\>\<bbb-N\>\<setminus\><around|{|0|}>>. A<nbsp>complete
  cyclus of this type will be called a <em|herd iteration>.

  <subsection|Step size control for herd iterations><label|hurd-step-sec>

  Several technical details need to be settled in order to obtain a robust
  implementation of herd iterations. First of all, we need a numeric
  criterion for deciding when the approximations
  <math|<wide|z|~><rsup|k><rsub|t>\<approx\>z<rsup|k><rsub|t>> and
  <math|<wide|<wide|z|\<dot\>>|~><rsup|k><rsub|t>\<approx\><wide|z|\<dot\>><rsup|k><rsub|t>>
  are of a sufficient quality for starting our herd iteration. Clearly, the
  error of the approximation should be in
  <math|\<cal-O\><around|(|t<rsup|2>|)>>.

  We may first ensure ourselves that the approximation can not substantially
  be improved using Newton iterations: let
  <math|<around|(|<wide|z|~><rsup|k><rsub|t>|)><rprime|'>> be the result of
  applying one Newton iteration to <math|<wide|z|~><rsup|k><rsub|t>> at time
  <math|t>. Then we check whether

  <\eqnarray*>
    <tformat|<table|<row|<cell|relerr<around|(|<wide|z|~><rsup|k><rsub|t>,<around|(|<wide|z|~><rsup|k><rsub|t>|)><rprime|'>|)>>|<cell|\<assign\>>|<cell|<frac|<around|\||<wide|z|~><rsup|k><rsub|t>-<around|(|<wide|z|~><rsup|k><rsub|t>|)><rprime|'>|\|>|<around|\||<wide|z|~><rsup|k><rsub|t>|\|>><space|0.6spc>\<leqslant\><space|0.6spc>\<tau\><rsub|5>*t<rsup|2>,<eq-number><label|rel-Newton-check>>>>>
  </eqnarray*>

  for some threshold <math|\<tau\><rsub|5>>, such as
  <math|\<tau\><rsub|5>=<frac|1|2>> (although this check becomes unstable if
  <math|<wide|z|~><rsup|k><rsub|t>\<approx\>0>, we notice that this situation
  cannot arise systematically for <math|t\<rightarrow\>0>).

  The check<nbsp>(<reference|rel-Newton-check>) for
  <math|k\<in\><around|{|0,\<ldots\>,p-1|}>> does not yet guarantee that the
  <math|<wide|z|~><rsup|k><rsub|t>> correspond to approximate evaluations of
  the Puiseux expansions. In order to check that this is indeed the case, we
  first compute the <math|<wide|c|~><rsub|k>> as described in the previous
  section. Defining

  <\eqnarray*>
    <tformat|<table|<row|<cell|<wide|c|~><around|(|t|)>>|<cell|=>|<cell|<wide|c|~><rsub|0>+<wide|c|~><rsub|1>*t<rsup|1/p>+\<cdots\>+<wide|c|~><rsub|2*p-1>*t<rsup|<around|(|2*p-1|)>/p>,>>>>
  </eqnarray*>

  we next evaluate <math|<wide|z|~><rsup|k+1/2><rsub|t>=<wide|c|~><around|(|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*k+\<mathpi\>*\<mathi\>>*t|)>>
  for all <math|k\<in\><around|{|0,\<ldots\>,p|}>> and apply one Newton
  iteration at time <math|t> to the results, yielding
  <math|<around|(|<wide|z|~><rsup|k+1/2><rsub|t>|)><rprime|'>>. We now check
  whether

  <\eqnarray*>
    <tformat|<table|<row|<cell|relerr<around|(|<wide|z|~><rsup|k+1/2><rsub|t>,<around|(|<wide|z|~><rsup|k+1/2><rsub|t>|)><rprime|'>|)>>|<cell|\<leqslant\>>|<cell|\<tau\><rsub|6>*t<rsup|2>,<eq-number><label|circle-check>>>>>
  </eqnarray*>

  for some threshold <math|\<tau\><rsub|6>>, such as
  <math|\<tau\><rsub|6>=1>, and all <math|k>. Of course, this second check is
  more expensive than the first check<nbsp>(<reference|rel-Newton-check>).
  The thresholds should therefore be adjusted in such a<nbsp>way that the
  second check is likely to succeed whenever the first one does.

  The above criteria can also be used for deciding whether a proposed herd
  iteration from<nbsp><math|t> to <math|t<rprime|'>> should be accepted or
  not. We still have to decide how to chose <math|t<rprime|'>>. For a fixed
  constant <math|\<gamma\>\<gtr\>1> and a positive integer <math|s> which may
  change at every step, we will take

  <\eqnarray*>
    <tformat|<table|<row|<cell|t<rprime|'>>|<cell|=>|<cell|2<rsup|-\<gamma\><rsup|s>>*t.>>>>
  </eqnarray*>

  If a step is accepted, then we increase <math|s> by one or a larger integer
  smaller than <math|1/log<rsub|2> \<gamma\>>. If a step is not accepted,
  then we decrease <math|s> by one and repeat the same procedure until
  acceptance or <math|s=0>. If <math|s=0>, then we have either reached the
  best possible accuracy for the current working precision, or our <math|p>
  paths did not really converge to the same point <math|\<alpha\>>. The first
  case occurs whenever the effective precision from
  section<nbsp><reference|num-prec-sec> drops below a given threshold. \ In
  the latter case, we revert to individual homotopies for further
  continuation.

  <subsection|Detection of clusters><label|cluster-detect-sec>

  Let us now go back to the initial polynomial
  system<nbsp>(<reference|pol-sys>) and assume that we have computed
  numerical approximations of all <math|d=d<rsub|1>*\<cdots\>*d<rsub|n>>
  individual homotopies <math|<around|(|z<rsup|k><rsub|t>|)><rsub|k\<in\>K>>
  up till a certain time<nbsp><math|t\<gtr\>0>. We need a way to partition
  the individual paths into herds. One obvious way is to follow all solution
  paths from <math|t> to <math|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>>*t> and
  deduce the corresponding permutation of <math|K>. However, this computation
  is quite expensive, so<nbsp>it would be nice to have something faster.

  A first step towards the detection of herds is to find all clusters,
  <abbr|i.e.> all groups of paths which tend to the same limit
  <math|\<alpha\>>. Here we notice that one cluster may contain several
  herds, as in the example

  <\eqnarray*>
    <tformat|<table|<row|<cell|x<rsup|2>>|<cell|=>|<cell|t>>|<row|<cell|y<rsup|2>>|<cell|=>|<cell|t,>>>>
  </eqnarray*>

  where all four solution paths <math|<around|(|x<rsub|t>,y<rsub|t>|)>=<around|(|\<epsilon\><rsub|x>*<sqrt|t>,\<epsilon\><rsub|y>*<sqrt|t>|)>>
  with <math|\<epsilon\><rsub|x>,\<epsilon\><rsub|y>\<in\><around|{|-1,1|}>>
  tend to the quadruple root <math|<around|(|0,0|)>> of
  <math|x<rsup|2>=y<rsup|2>=0>. This cluster contains two herds
  <math|<around|(|x<rsub|t>,y<rsub|t>|)>=<around|(|\<pm\><sqrt|t>,\<pm\><sqrt|t>|)>>
  and <math|<around|(|x<rsub|t>,y<rsub|t>|)>=<around|(|\<pm\><sqrt|t>,\<mp\><sqrt|t>|)>>.

  Now let <math|<wide|z|~><rsup|k><rsub|t>\<approx\>z<rsup|k><rsub|t>> and
  <math|<wide|<wide|z|\<dot\>>|~><rsup|k><rsub|t>\<approx\><wide|z|\<dot\>><rsup|k><rsub|t>>
  for all <math|k\<in\>K>. For each <math|k\<in\>K>, we consider the ball

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-z\><rsup|k><rsub|t>>|<cell|=>|<cell|<wide|z|~><rsup|k><rsub|t>+\<cal-B\><around|(|2*t*<wide|<wide|z|\<dot\>>|~><rsup|k><rsub|t>|)>.>>>>
  </eqnarray*>

  The radii of these balls has been chosen with care, such that, with high
  probability, any two paths which belong to the same herd are also in the
  same connected component of <rigid|<math|\<cal-Z\>\<assign\><big|cup><rsub|k\<in\>K>\<b-z\><rsup|k><rsub|t>>>.
  This is best verified on the case of path
  <math|z<rsub|t>=\<alpha\>+c*t<rsup|1/p>+\<cdots\>>. Then the next path in
  the cluster is <math|z<rsub|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>>*t>=\<alpha\>+c*\<omega\>*t<rsup|1/p>+\<cdots\>>
  and

  <\eqnarray*>
    <tformat|<table|<row|<cell|<tfrac|1|2>*<around|\||z<rsub|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>>*t>-z<rsub|t>|\|>>|<cell|\<approx\>>|<cell|<tfrac|c|2>*<around|\||\<omega\>-1|\|>*t<rsup|1/p>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|<tfrac|2*c|p>*t<rsup|1/p>>>|<row|<cell|>|<cell|\<approx\>>|<cell|2*t*<wide|z|\<dot\>><rsub|t>.>>>>
  </eqnarray*>

  An efficient way to separate different connected components of
  <math|\<cal-Z\>> is via projection. Let
  <math|\<lambda\>\<in\>\<bbb-R\><rsup|2*n>> be a random vector of real
  numbers of length <math|<around|\<\|\|\>|\<lambda\>|\<\|\|\>>=1>. Then any
  point <math|z\<in\>\<bbb-C\><rsup|n>> may be projected to the vector
  product <math|\<pi\><rsub|\<lambda\>><around|(|z|)>=\<lambda\>\<cdot\><around|(|Re
  z,Im z|)>\<in\>\<bbb-R\>>. Applying this projection to our balls
  <math|\<b-z\><rsup|k><rsub|t>>, we obtain intervals <math|\<b-x\><rsup|k>>.
  We may sort the <math|\<b-x\><rsup|k>> (and the
  corresponding<nbsp><math|\<b-z\><rsup|k><rsub|t>>) on their centers in time
  <math|\<cal-O\><around|(|d*log d|)>> and compute the various connected
  components of <with|mode|math|\<cal-X\>\<assign\><big|cup><rsub|k\<in\>K>\<b-x\><rsup|k>>
  using a linear pass. Whenever <math|\<b-x\><rsup|k>> and
  <math|\<b-x\><rsup|l>> are in different connected components, then so are
  <math|\<b-z\><rsup|k><rsub|t>> and <math|\<b-z\><rsup|l><rsub|t>>. Assuming
  that <math|t> is sufficiently small, application of this procedure for
  <math|2*n> random vectors<nbsp><math|\<lambda\>> results with probability
  one in the separation of all connected components corresponding to
  different clusters.

  <subsection|Detection of herds><label|hurd-detect-sec>

  Let <math|K<rprime|'>\<subseteq\>K> be a set of indices such that the
  <math|z<rsup|k>> with <math|k\<in\>K<rprime|'>> form a cluster with
  limit<nbsp><math|\<alpha\>>. We still need a way to find the various herds
  inside the cluster. In a similar way as in
  section<nbsp><reference|hurd-step-sec>, we may improve the quality of our
  approximations <math|<wide|z|~><rsup|k>> and
  <math|<wide|<wide|z|\<dot\>>|~><rsup|k>> <em|via> Newton iteration until
  <math|<wide|z|~><rsup|k><rsub|t>=z<rsup|t><rsub|t>+\<cal-O\><around|(|t<rsup|2>|)>>
  and <math|<wide|<wide|z|\<dot\>>|~><rsup|k><rsub|t>=<wide|z|\<dot\>><rsup|k><rsub|t>+\<cal-O\><around|(|t|)>>.
  From now on, we assume that we have done this.

  For each <math|k\<in\>K<rprime|'>> and <rigid|<math|i\<in\><around|{|1,\<ldots\>,n|}>>>,
  we may write

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|(|z<rsup|k><rsub|t>|)><rsub|i>>|<cell|=>|<cell|\<alpha\><rsub|i>+c<rsup|k><rsub|i>*t<rsup|\<beta\><rsup|k><rsub|i>>+\<cdots\>,>>>>
  </eqnarray*>

  for some <math|c<rsup|k><rsub|i>\<in\>\<bbb-C\>\<setminus\><around|{|0|}>>
  and <math|\<beta\><rsup|k><rsub|i>\<in\>\<bbb-Q\><rsup|\<gtr\>>>. We obtain
  a good approximation <math|A\<approx\>\<alpha\>+\<cal-O\><around|(|t|)>>
  using

  <\eqnarray*>
    <tformat|<table|<row|<cell|<wide|\<alpha\>|~>>|<cell|=>|<cell|<frac|1|<around|\||K<rprime|'>|\|>>*<big|sum><rsub|k\<in\>K<rprime|'>><wide|z|~><rsup|k><rsub|t>.<eq-number><label|alpha-approx>>>>>
  </eqnarray*>

  If <math|<around|\||K<rprime|'>|\|>> is not too large (so that
  <math|\<beta\><rsup|k><rsub|i>> has a small numerator and denominator),
  then we also obtain reasonably accurate approximations
  <math|<wide|\<beta\>|~><rsup|k><rsub|i>\<approx\>\<beta\><rsup|k><rsub|i>>
  and <math|<wide|c|~><rsup|k><rsub|i>\<approx\>c<rsup|k><rsub|i>> by

  <\eqnarray*>
    <tformat|<table|<row|<cell|<wide|\<beta\>|~><rsup|k><rsub|i>>|<cell|=>|<cell|<frac|t*<around|(|<wide|<wide|z|\<dot\>>|~><rsup|k><rsub|t>|)><rsub|i>|<around|(|<wide|z|~><rsup|k><rsub|t>|)><rsub|i>-\<alpha\><rsub|i>>>>|<row|<cell|<wide|c|~><rsup|k><rsub|i>>|<cell|=>|<cell|<around|(|<wide|z|~><rsup|k>-\<alpha\>|)>*t<rsup|-<wide|\<beta\>|~><rsup|k>>.>>>>
  </eqnarray*>

  and check whether

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsup|k><rsub|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>>*t>>|<cell|\<approx\>>|<cell|<wide|\<alpha\>|~>+<wide|c|~><rsup|k>*\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*<wide|\<beta\>|~><rsup|k>>*t<rsup|<wide|\<beta\>|~><rsup|k>>>>>>
  </eqnarray*>

  is indeed close to some <math|<wide|z|~><rsup|k<rprime|'>>> with
  <math|k<rprime|'>\<in\>K<rprime|'>>. Doing this for all
  <math|k\<in\>K<rprime|'>>, we thus obtain a candidate permutation
  <math|\<sigma\>:K<rprime|'>\<rightarrow\>K<rprime|'>> with
  <math|z<rsup|k><rsub|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>>*t>=z<rsup|\<sigma\><around|(|k|)>><rsub|t>>
  for all <math|k\<in\>K<rprime|'>>. Each cycle in this permutation induces a
  candidate herd. Using the criteria from<nbsp><reference|hurd-step-sec>, we
  may next check whether the quality of the candidate herd is sufficient. If
  not, then we may always resort to the more expensive computation of the
  solution path from <math|t> to <math|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>>*t>.

  <subsection|Synchronization><label|synchronize-sec>

  Our algorithms for the previous sections for cluster and herd detection
  rely on the availability of approximations
  <math|<wide|z|~><rsup|k><rsub|t>\<approx\>z<rsup|k><rsub|t>> on all paths
  at the <em|same> time <math|t>. Usually the individual homotopies are
  launched in parallel and advance at different speeds. Consequently, the
  synchronization of all paths at the same time <math|t> is a non trivial
  matter.

  Strictly speaking, we notice that it is not necessary to synchronize all
  paths, but rather those paths which belong to the same cluster or herd. In
  particular, we will concentrate on those paths which tend to multiple
  roots.

  So consider a path <math|z<rsup|k><rsub|t>> which tends to a multiple root
  <math|\<alpha\>>. As long as <math|z<rsup|k><rsub|t>> is approximated using
  an individual continuation, we have seen that the convergence to
  <math|t\<rightarrow\>0> is linear. For a fixed <math|\<gamma\>\<less\>1>
  (such as <math|\<gamma\>=<frac|1|2>>), the computation of
  <math|z<rsup|k><rsub|t>> at all ``checkpoints''
  <math|t=\<gamma\>,\<gamma\><rsup|2>,\<gamma\><rsup|3>,\<ldots\>> thus only
  requires a<nbsp>constant overhead. At every checkpoint, we may now launch
  the algorithm for the detection of clusters. For every candidate cluster
  <math|K<rprime|'>>, we next determine the
  checkpoint<nbsp><math|\<gamma\><rsup|i>> with highest <math|i> at which
  <math|z<rsup|k><rsub|\<gamma\><rsup|i>>> is available for all
  <math|k\<in\>K<rprime|'>>. We launch our algorithm for the detection of
  herds at this checkpoint <math|t=\<gamma\><rsup|i>>.

  In addition, it is a good practice to check that we still have points on
  all <rigid|<math|d=d<rsub|1>*\<cdots\>*d<rsub|n>>> paths at every
  checkpoint. For paths <math|z<rsup|k><rsub|t>> which tend to a single root,
  we may approximate<nbsp><math|z<rsup|k><rsub|\<gamma\><rsup|i>>> for large
  <math|i> using a single step continuation from <math|t=0> to
  <math|t=\<gamma\><rsup|i>>. For the approximation of <math|\<alpha\>>
  using<nbsp>(<reference|alpha-approx>), we notice that it important that no
  paths of the cluster are missing or counted twice. Indeed, in the contrary
  case, we only have <math|A=\<alpha\>+\<cal-O\><around|(|t<rsup|\<beta\>>|)>>
  with <math|\<beta\><rsub|i>=min<rsub|k\<in\>K<rprime|'>>
  \<beta\><rsup|k><rsub|i>> for all <math|i>, which is insufficient for the
  computation of accurate approximations of <math|\<beta\><rsup|k><rsub|i>>
  and <math|c<rsup|k><rsub|i>>.

  <section|Certified homotopies><label|cert-hom-sec>

  <subsection|Certification of Newton's method><label|Kraw-sec>

  Consider an analytic function <math|f:\<Omega\>\<rightarrow\>\<bbb-C\><rsup|n>>
  on some open subset <math|\<Omega\>> of <math|\<bbb-C\><rsup|n>> and assume
  that<nbsp><math|f> admits a ball lift. Given an isolated root <math|z> of
  <math|f>, it is well known that Newton's method converges to <math|z> in a
  small neighbourhood of <math|z>. It is a natural question to explicitly
  compute a ball neighbourhood for which this is the case (where we notice
  that a ``ball'' in <math|<bC><rsup|n>> is really a compact polydisk). One
  method which is both efficient and quite tight was proposed by
  Krawczyk<nbsp><cite|Kraw69>. Recall that <math|J<rsub|f>> denotes the
  Jacobian of <math|f>.

  <\theorem>
    <label|fp-existence-th>Let <math|\<b-u\>\<in\><bC><rsup|n>>, <math|u=cen
    \<b-u\>> and let <math|g:\<b-u\>\<rightarrow\>\<bbb-C\><rsup|n>> be an
    analytic function. Let <math|J<rsub|g><around|(|\<b-u\>|)>\<in\><bC><rsup|n\<times\>n>>
    be a ball enclosure of the set <math|im J<rsub|g>>. If

    <\eqnarray*>
      <tformat|<table|<row|<cell|g<around|(|u|)>-J<rsub|g><around|(|\<b-u\>|)>*\<cal-B\><around|(|rad
      \<b-u\>|)>>|<cell|\<subseteq\>>|<cell|\<b-u\>,>>>>
    </eqnarray*>

    then <math|g> admits a fixed point <math|z\<in\>\<b-u\>>.
  </theorem>

  <\proof>
    For any <math|z\<in\>\<b-u\>>, we have

    <\eqnarray*>
      <tformat|<table|<row|<cell|g<around|(|z|)>>|<cell|=>|<cell|g<around|(|u|)>+<big|int><rsub|0><rsup|1>J<rsub|g><around|(|u+<around|(|z-u|)>*t|)>*<around|(|z-u|)>*\<mathd\>
      t.>>>>
    </eqnarray*>

    Since <math|J<rsub|g><around|(|\<b-u\>|)>> is convex, we also have

    <\eqnarray*>
      <tformat|<table|<row|<cell|<big|int><rsub|0><rsup|1>J<rsub|g><around|(|u+<around|(|z-u|)>*t|)>*\<mathd\>
      t>|<cell|\<in\>>|<cell|J<rsub|g><around|(|\<b-u\>|)>.>>>>
    </eqnarray*>

    Hence

    <\eqnarray*>
      <tformat|<table|<row|<cell|g<around|(|z|)>>|<cell|\<in\>>|<cell|g<around|(|u|)>+J<rsub|g><around|(|\<b-u\>|)>*<around|(|\<b-u\>-u|)>>>|<row|<cell|>|<cell|\<subseteq\>>|<cell|\<b-u\>.>>>>
    </eqnarray*>

    It follows that <math|g> is an analytic function from the compact ball
    <math|\<b-u\>> into itself. By Brouwer's fixed point theorem, we conclude
    that there exists a <math|z\<in\>\<b-u\>> with <math|g<around|(|z|)>=z>.
  </proof>

  <\corollary>
    <label|New-existence-cor>Let <math|\<b-u\>\<in\><bC><rsup|n>>,
    <math|u=cen \<b-u\>> and let <math|V\<in\>\<bbb-C\><rsup|n\<times\>n>> be
    an invertible matrix with <math|V*J<rsub|f><around|(|cen
    \<b-u\>|)>\<approx\>1>. If <math|\<Omega\>\<supseteq\>\<b-u\>> and

    <\eqnarray*>
      <tformat|<table|<row|<cell|u-V*f<around|(|u|)>+<around|(|1-V*J<rsub|f><around|(|\<b-u\>|)>|)>*\<cal-B\><around|(|rad
      \<b-u\>|)>>|<cell|\<subseteq\>>|<cell|\<b-u\>,>>>>
    </eqnarray*>

    then the equation <math|f<around|(|z|)>=0> admits a root
    <math|z\<in\>\<b-u\>>.
  </corollary>

  <\proof>
    We apply the theorem for <math|g<around|(|z|)>=z-V*f<around|(|z|)>>.
  </proof>

  The above method is still a bit unsatisfactory in the sense that it does
  not guarantee the uniqueness of the solution. Denoting by
  <math|int<around|(|X|)>> the interior of a subset <math|X> of
  <math|\<bbb-R\><rsup|n>>, the following sharpening of the method is due to
  Rump<nbsp><cite|Rump:phd>.

  <\theorem>
    <label|fp-uniqueness-th>With the notations from
    theorem<nbsp><reference|fp-existence-th>, if

    <\eqnarray*>
      <tformat|<table|<row|<cell|g<around|(|u|)>-J<rsub|g><around|(|\<b-u\>|)>*\<cal-B\><around|(|rad
      \<b-u\>|)>>|<cell|\<subseteq\>>|<cell|int<around|(|\<b-u\>|)>,>>>>
    </eqnarray*>

    then <math|g> admits a unique fixed point in <math|\<b-u\>>.
  </theorem>

  <\proof>
    Let us first show that the spectral norm (<abbr|i.e.> the norm of the
    largest eigenvalue) of any <math|M\<in\>J<rsub|g><around|(|\<b-u\>|)>> is
    <math|\<less\>1>. Indeed, our assumption implies

    <\eqnarray*>
      <tformat|<table|<row|<cell|rad <around|(|J<rsub|g><around|(|\<b-u\>|)>*\<cal-B\><around|(|rad
      \<b-u\>|)>|)>>|<cell|\<less\>>|<cell|rad \<b-u\>.>>>>
    </eqnarray*>

    Now consider the norm <math|<around|\<\|\|\>|v|\<\|\|\>>=max
    <around|(|<around|\||v<rsub|1>|\|>/rad
    \<b-u\><rsub|1>,\<ldots\>,<around|\||v<rsub|n>|\|>/rad
    \<b-u\><rsub|n>|)>> on <math|\<bbb-C\><rsup|n>>. Then, for any
    <math|M\<in\>J<rsub|g><around|(|\<b-u\>|)>> and <math|v>
    with<nbsp><math|<around|\<\|\|\>|v|\<\|\|\>>=1>, we have

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around|\||M*v|\|>>|<cell|\<leqslant\>>|<cell|rad
      <around|(|M*\<cal-B\><around|(|<around|\||v|\|>|)>|)>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|rad
      <around|(|M*\<cal-B\><around|(|rad \<b-u\>|)>|)>>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|rad
      <around|(|J<rsub|g><around|(|\<b-u\>|)>*\<cal-B\><around|(|rad
      \<b-u\>|)>|)>>>|<row|<cell|>|<cell|\<less\>>|<cell|rad \<b-u\>,>>>>
    </eqnarray*>

    whence <math|<around|\<\|\|\>|M*v|\<\|\|\>>\<less\>1>. This is only
    possible if the spectral norm of <math|M> is <math|\<less\>1>.

    Now consider <math|\<varphi\><around|(|z|)>=z-g<around|(|z|)>>. By what
    precedes, any matrix <math|M> in <math|J<rsub|\<varphi\>><around|(|\<b-u\>|)>=1-J<rsub|g><around|(|\<b-u\>|)>>
    is invertible. For any two distinct points
    <math|z,z<rprime|'>\<in\>\<b-u\>>, we have

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<varphi\><around|(|z<rprime|'>|)>-\<varphi\><around|(|z|)>>|<cell|=>|<cell|<big|int><rsub|0><rsup|1>J<rsub|\<varphi\>><around|(|z+<around|(|z<rprime|'>-z|)>*t|)>*<around|(|z<rprime|'>-z|)>*\<mathd\>
      t.>>>>
    </eqnarray*>

    Since <math|J<rsub|\<varphi\>><around|(|\<b-u\>|)>> is convex, there
    exists a matrix <math|M\<in\>J<rsub|\<varphi\>><around|(|\<b-u\>|)>> with

    <\eqnarray*>
      <tformat|<table|<row|<cell|M>|<cell|=>|<cell|<big|int><rsub|0><rsup|1>J<rsub|\<varphi\>><around|(|z+<around|(|z<rprime|'>-z|)>*t|)>*\<mathd\>
      t.>>>>
    </eqnarray*>

    By what precedes, it follows that <math|\<varphi\><around|(|z<rprime|'>|)>-\<varphi\><around|(|z|)>=M*<around|(|z<rprime|'>-z|)>\<neq\>0>.
    We conclude that <math|g<around|(|z|)>\<neq\>z> or
    <math|g<around|(|z<rprime|'>|)>\<neq\>z<rprime|'>>. The existence of a
    fixed point follows from theorem<nbsp><reference|fp-existence-th>.
  </proof>

  <\corollary>
    <label|New-uniqueness-cor>With the notations of
    corollary<nbsp><reference|New-existence-cor>, if

    <\eqnarray*>
      <tformat|<table|<row|<cell|u-V*f<around|(|u|)>+<around|(|1-V*J<rsub|f><around|(|\<b-u\>|)>|)>*\<cal-B\><around|(|rad
      \<b-u\>|)>>|<cell|\<subseteq\>>|<cell|int<around|(|\<b-u\>|)>,>>>>
    </eqnarray*>

    then the equation <math|f<around|(|z|)>=0> admits a unique root
    <math|z\<in\>\<b-u\>>.
  </corollary>

  <\proof>
    Application of theorem<nbsp><reference|fp-uniqueness-th> for
    <math|g<around|(|z|)>=z-V*f<around|(|z|)>>.
  </proof>

  Assuming that we have computed a numeric approximation <math|<wide|z|~>> to
  a root <math|z> of <math|f>, a second question is how to find a suitable
  ball <math|\<b-z\>\<ni\><wide|z|~>> for which the corollaries apply.
  Starting with <math|\<b-z\><rsub|0>\<assign\><wide|z|~>+\<cal-B\><around|(|0|)>>,
  a simple solution is consider the sequence defined by

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-z\><rsub|i+1>>|<cell|=>|<cell|cen
    \<b-z\><rsub|i>+\<cal-B\><around|(|max<around|(|rad \<b-z\><rsub|i>,rad
    <around|(|K<around|(|\<b-z\><rsub|i>|)>-cen
    \<b-z\><rsub|i>|)>|)>|)><eq-number><label|start-rec>>>|<row|<cell|>|<cell|\<supseteq\>>|<cell|\<b-z\><rsub|i>\<cup\>K<around|(|\<b-z\><rsub|i>|)>,>>>>
  </eqnarray*>

  where

  <\eqnarray*>
    <tformat|<table|<row|<cell|K<around|(|\<b-u\>|)>>|<cell|=>|<cell|cen
    \<b-u\>-V*f<around|(|cen \<b-u\>|)>+<around|(|1-V*J<rsub|f><around|(|\<b-u\>|)>|)>*\<cal-B\><around|(|rad
    \<b-u\>|)>>>>>
  </eqnarray*>

  Whenever <math|K<around|(|\<b-z\><rsub|i>|)>\<subseteq\>int<around|(|\<b-z\><rsub|i>|)>>,
  then we are done. In order to ensure the convergence of this method, we
  need to tweak the recurrence<nbsp>(<reference|start-rec>) and replace it by

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-z\><rsub|i+1>>|<cell|=>|<cell|cen
    \<b-z\><rsub|i>+\<cal-B\><around|(|<around|(|1+\<varepsilon\>|)>*max<around|(|rad
    \<b-z\><rsub|i>,rad <around|(|K<around|(|\<b-z\><rsub|i>|)>-cen
    \<b-z\><rsub|i>|)>|)>+\<eta\>|)>,<eq-number><label|improved-cert-iter>>>>>
  </eqnarray*>

  for suitable small positive constants <math|\<varepsilon\>> and
  <math|\<eta\>>. We refer to<nbsp><cite|Rump:phd> for more details on this
  technique, which is called <math|\<varepsilon\>>-inflation.

  <subsection|Certification of a numeric homotopy
  continuation><label|simple-hom-cert-sec>

  Assume that the polynomial system<nbsp>(<reference|pol-sys>) admits only
  simple roots and that we have obtained numeric approximations
  <math|<wide|z|~><rsup|k>=<wide|z|~><rsup|k><rsub|0>> \ for all these roots
  using a numeric path tracker. Then theorem<nbsp><reference|New-existence-th>
  suffices for the joint certification of the numeric approximations
  <math|<around|{|<wide|z|~><rsup|k>|}><rsub|k\<in\>K>>. Indeed, using the
  above technique, we first compute balls
  <math|\<b-z\><rsup|k>\<ni\><wide|z|~><rsup|k>> for which
  theorem<nbsp><reference|New-existence-th> applies. To conclude, it then
  suffices to check that these balls are pairwise disjoint. This can be done
  using the same algorithm as for the detection of clusters, which was
  described in section<nbsp><reference|cluster-detect-sec>.

  In the case when two balls<nbsp><math|\<b-z\><rsup|k>> and
  <math|\<b-z\><rsup|k<rprime|'>>> do intersect, then we recompute
  approximations for the paths <math|z<rsup|k><rsub|t>>
  and<nbsp><math|z<rsup|k<rprime|'>><rsub|t>> using a smaller step size, that
  is, by lowering the constant<nbsp><math|\<tau\><rsub|1>>
  in<nbsp>(<reference|accept-crit>). We keep doing so until none of the balls
  <math|\<b-z\><rsup|k>> intersect; even if some of the <em|paths>
  <math|z<rsup|k><rsub|t>> may have been permuted due to numerical errors,
  the final <em|set> of all <math|\<b-z\><rsup|k>> is correct if none of the
  balls intersect. Indeed, each of the balls contains a solution and there
  can be no more solutions than the number predicted by the Bezout bound.

  If<nbsp><math|\<b-z\><rsup|k>> and <math|\<b-z\><rsup|k<rprime|'>>>
  intersect then, instead of recomputing the paths <math|z<rsup|k><rsub|t>>
  and <math|z<rsup|k<rprime|'>><rsub|t>> using smaller and smaller step
  sizes, we may also search for a way to certify the entire homotopy
  computations. This will be the topic of the remainder of this section. Let
  us first show how to adapt the theory from the previous section to
  certified path tracking. From now on, we assume that
  <math|H:\<Omega\>\<times\>\<bbb-C\>\<rightarrow\>\<bbb-C\><rsup|n>> is an
  analytic function which admits a ball lift.

  <\theorem>
    <label|hom-basic-th>Let <math|<around|(|\<b-u\>,\<b-t\>|)>\<in\><bC><rsup|n>\<times\><bC>>
    be such that <math|\<b-u\>\<subseteq\>\<Omega\>>. Let
    <math|J=<around|(|\<partial\> H/\<partial\> z|)><around|(|cen \<b-u\>,cen
    \<b-t\>|)>> and let <math|V\<in\>\<bbb-C\><rsup|n\<times\>n>> be an
    invertible matrix with <math|V*J\<approx\>1>. If

    <\eqnarray*>
      <tformat|<table|<row|<cell|cen \<b-u\>-V*H<around|(|cen
      \<b-u\>,\<b-t\>|)>+<around|(|1-V*<tfrac|\<partial\> H|\<partial\>
      z><around|(|\<b-u\>,\<b-t\>|)>|)>*\<cal-B\><around|(|rad
      \<b-u\>|)>>|<cell|\<subseteq\>>|<cell|int<around|(|\<b-u\>|)>,>>>>
    </eqnarray*>

    then the equation <math|H<around|(|z,t|)>=0> admits a unique root
    <math|z\<in\>\<b-u\>> for each <math|t\<in\>\<b-t\>>.
  </theorem>

  <\proof>
    Let <math|t\<in\>\<b-t\>> and consider the function
    <math|g:\<b-u\>\<rightarrow\>\<bbb-C\><rsup|n>;z\<mapsto\>z-H<around|(|z,t|)>>.
    Then <math|\<b-u\>-V*H<around|(|\<b-u\>,\<b-t\>|)>> encloses <math|im g>
    and <with|mode|math|1-V*<tfrac|\<partial\> H|\<partial\>
    z><around|(|\<b-u\>,\<b-t\>|)>> encloses <math|im J<rsub|g>>, and we
    conclude by theorem<nbsp><reference|fp-uniqueness-th>.
  </proof>

  Clearly, for any <math|t,t<rprime|'>\<in\>\<b-t\>>,
  theorem<nbsp><reference|hom-basic-th> ensures the existence of a unique
  solution path from <math|t> to <math|t<rprime|'>> in the tube
  <math|\<b-u\>\<times\><around|[|t,t<rprime|'>|]>>. As at the end of the
  previous section, the question again arises how to compute
  balls<nbsp><math|\<b-u\>> and<nbsp><math|\<b-t\>> for which the conditions
  of the theorem are likely to be satisfied. Since the computation of
  <with|mode|math|<tfrac|\<partial\> H|\<partial\>
  z><around|(|\<b-u\>,\<b-t\>|)>> is expensive, it is important to keep down
  the number of iterations of the type<nbsp>(<reference|start-rec>) or
  (<reference|improved-cert-iter>) as much as possible (say at most one
  iteration).

  Now assume that we performed a numeric homotopy computation from
  <math|<around|(|z,t|)>> to <rigid|<math|<around|(|z<rprime|'>,t<rprime|'>|)>>>.
  Then a reasonable first guess is to take

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-u\>>|<cell|=>|<cell|<frac*|1|2>*<around|(|z+z<rprime|'>|)>+\<cal-B\><around|(|c*<around|(|z<rprime|'>-z|)>|)>>>|<row|<cell|\<b-t\>>|<cell|=>|<cell|<frac*|1|2>*<around|(|t+t<rprime|'>|)>+\<cal-B\><around|(|<frac*|1|2>*<around|(|t<rprime|'>-t|)>|)>,>>>>
  </eqnarray*>

  for some <math|c\<gtr\><frac*|1|2>>, say <math|c=1>. Unfortunately, if one
  of the components of <math|z<rprime|'>-z> tends to zero, then this guess
  turns out to be inadequate. Therefore, it is recommended to use an
  additional inflation proportional to the norm of <math|z<rprime|'>-z>:

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-u\>>|<cell|=>|<cell|<frac*|1|2>*<around|(|z+z<rprime|'>|)>+\<cal-B\><around|(|c*<around|(|z<rprime|'>-z|)>+c<rprime|'>*<around|\<\|\|\>|z<rprime|'>-z|\<\|\|\>>|)>,>>>>
  </eqnarray*>

  for some small <math|c<rprime|'>\<gtr\>0>, say
  <math|c<rprime|'>=<frac*|1|10>>. Another idea is to use the radius of the
  previous step as a reference (except for the very first step, of course).
  For instance, if our previous step went from
  <math|<around|(|<lprime|`>z,<lprime|`>t|)>> to <math|<around|(|z,t|)>>,
  then we may take

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-u\>>|<cell|=>|<cell|<frac*|1|2>*<around|(|z+z<rprime|'>|)>+\<cal-B\><around|(|c*<around|(|z<rprime|'>-z|)>+c<rprime|''>*<around|(|z-<lprime|`>z|)>*<tfrac|t<rprime|'>-t|t-`t>|)>,>>>>
  </eqnarray*>

  for some small <math|c<rprime|''>\<gtr\>0>, say
  <math|c<rprime|''>=<frac*|1|10>>.

  <subsection|Certification <em|via> tubular models><label|tubular-sec>

  One important disadvantage of the method from the previous section for the
  certification of one path tracking step is that we use global error bounds
  on the tube <rigid|<math|\<b-u\>\<times\>\<b-t\>>>. Consequently, the
  inaccuracy <math|rad \<b-u\>> of <math|\<b-u\>> is proportional to the step
  size <math|2*rad \<b-t\>>, whence any overestimation in the evaluation of
  <math|H> or <math|J<rsub|H>> due to the inaccuracy in <math|\<b-u\>>
  requires a<nbsp>reduction of the step size.

  For this reason, it is much better to follow the solution path as closely
  as possible instead of enclosing it in a ``square tube''. This can be
  achieved <em|via> the use of Taylor models. Using <math|\<cal-D\>>-stable
  Taylor models, it is possible to simultaneously compute of accurate
  enclosures for<nbsp><math|H> and <math|J<rsub|H>> on the tube.

  More precisely, let <math|r<rsub|\<epsilon\>>\<in\><around|(|\<bbb-R\><rsup|\<gtr\>>|)><rsup|n>>,
  <math|r<rsub|\<delta\>>\<in\>\<bbb-R\><rsup|\<geqslant\>>> and
  <math|D=\<cal-B\><around|(|r<rsub|\<epsilon\>>|)>\<times\>\<cal-B\><around|(|r<rsub|\<delta\>>|)>>.
  For a fixed <math|k> in <math|\<bbb-N\>\<setminus\><around|{|0|}>>, let
  <math|\<cal-I\>=\<cal-J\>> be an initial segment of
  <math|\<bbb-N\><rsup|n+1>> of the form

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<cal-I\>>|<cell|=>|<cell|0\<times\><around|{|0,\<ldots\>,k|}>\<cup\><around|{|\<bbb-e\><rsub|1>,\<ldots\>,\<bbb-e\><rsub|n>|}>\<times\><around|{|0|}>>>>>
  </eqnarray*>

  and let <math|\<cal-D\>=\<cal-T\><rsub|1>=<around|{|i\<in\>\<bbb-N\><rsup|n+1>:<around|\<\|\|\>|i|\<\|\|\>>\<leqslant\>1|}>>.
  A <math|\<cal-D\>>-stable Taylor model in
  <rigid|<math|\<cal-B\><rsub|D><around|(|\<bbb-C\><around|[|\<epsilon\>,\<delta\>|]><rsub|\<cal-I\>>,\<bbb-R\><around|[|\<epsilon\>,\<delta\>|]><rsub|\<cal-I\>>|)>>>
  will also be called a <em|tubular model>. We will write
  <math|<bT><rsub|D,\<cal-I\>>> for the set of tubular models. Given
  <math|\<b-y\>\<in\><bT><rsub|D,\<cal-I\>><rsup|n>>, we let
  <math|\<b-y\><rsub|cst>\<in\><bC><rsup|n>> and
  <math|\<b-y\><rsub|lin>\<in\><bC><rsup|n\<times\>n>> be such that

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|(|\<b-y\><rsub|cst>|)><rsub|i>>|<cell|=>|<cell|\<varpi\><around|(|\<b-y\><rsub|i>|)>>>|<row|<cell|<around|(|\<b-y\><rsub|lin>|)><rsub|i,j>>|<cell|=>|<cell|\<varpi\><around*|(|<tfrac|\<partial\>
    \<b-y\><rsub|i>|\<partial\>\<epsilon\><rsub|j>>|)>,>>>>
  </eqnarray*>

  for all <math|i,j\<in\><around|{|1,\<ldots\>,n|}>>.

  <\big-figure|<with|gr-mode|<tuple|edit|text-at>|gr-frame|<tuple|scale|1cm|<tuple|0.0700408gw|0.100035gh>>|gr-geometry|<tuple|geometry|0.706678par|0.45334par|center>|gr-grid|<tuple|empty>|gr-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-edit-grid-aspect|<tuple|<tuple|axes|none>|<tuple|1|none>|<tuple|10|none>>|gr-edit-grid|<tuple|empty>|gr-edit-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-text-at-halign|center|gr-dash-style|default|gr-fill-color|default|gr-line-width|5ln|arrow-length|10ln|arrow-height|6ln|<graphics||<with|arrow-length|10ln|arrow-height|6ln|arrow-end|\<gtr\>|<line|<point|-0.5|0>|<point|9.5|0.0>>>|<with|arrow-length|10ln|arrow-height|6ln|arrow-end|\<gtr\>|<line|<point|0|-0.5>|<point|0.0|6.0>>>|<with|text-at-halign|center|<text-at|<math|t>|<point|9.5|0.4>>>|<with|text-at-halign|center|<text-at|<math|z>|<point|0.4|5.5>>>|<with|fill-color|pastel
  cyan|<cline|<point|2|3>|<point|2.0|3.0>|<point|8.0|5.0>|<point|8.0|3.0>|<point|2.0|1.0>>>|<with|dash-style|11100|arrow-length|10ln|arrow-height|6ln|arrow-end|\<gtr\>|<line|<point|0.5|1.5>|<point|9.5|4.5>>>|<with|dash-style|11100|arrow-length|10ln|arrow-height|6ln|arrow-end|\<gtr\>|<line|<point|5|1>|<point|5.0|5.0>>>|<with|text-at-halign|center|<text-at|<math|\<delta\>>|<point|9.4|3.8>>>|<with|text-at-halign|center|<text-at|<math|\<epsilon\>>|<point|5.3|5.2>>>|<with|arrow-length|10ln|arrow-height|6ln|arrow-begin|\<less\>|arrow-end|\<gtr\>|<line|<point|1.7|2.0>|<point|1.7|3.0>>>|<with|arrow-length|10ln|arrow-height|6ln|arrow-begin|\<less\>|arrow-end|\<gtr\>|<line|<point|5|0.5>|<point|8.0|0.5>>>|<with|text-at-halign|center|<text-at|<math|r<rsub|\<delta\>>>|<point|6.50604|0.770687>>>|<with|text-at-halign|center|<text-at|<math|r<rsub|\<epsilon\>>>|<point|1.36933304273052|2.38466844820743>>>|<with|text-at-halign|center|<text-at|<math|z<rsub|t>>|<point|8.89789|5.36389>>>|<with|line-width|5ln|<spline|<point|-0.479015081359968|0.601352692155047>|<point|4.57985513956873|2.63336750892975>|<point|9.4|5.3>>>>>>
    <label|slope-tube-fig>Illustration of a solution path <math|z<rsub|t>> in
    a tube.
  </big-figure>

  <\theorem>
    <label|hom-tube-th>Let <math|c=<around|(|c<rsub|\<epsilon\>>,c<rsub|\<delta\>>|)>\<in\>\<Omega\>\<times\>\<bbb-C\>>,
    <math|r=<around|(|r<rsub|\<epsilon\>>,r<rsub|\<delta\>>|)>\<in\><around|(|\<bbb-R\><rsup|\<gtr\>>|)><rsup|n>\<times\>\<bbb-R\><rsup|\<gtr\>>>,
    <math|D=\<cal-B\><around|(|r|)>> and let

    <\eqnarray*>
      <tformat|<table|<row|<cell|E<around|(|\<delta\>|)>>|<cell|=>|<cell|E<rsub|0>+\<cdots\>+E<rsub|k<rsub|1>>*\<delta\><rsup|k>>>>>
    </eqnarray*>

    be an approximation of the solution <math|\<varepsilon\><rsub|\<delta\>>>
    to <math|H<around|(|c<rsub|\<epsilon\>>+\<varepsilon\><rsub|\<delta\>>,c<rsub|\<delta\>>+\<delta\>|)>=0>.
    For instance, if <math|k=1> and <math|H<around|(|c|)>\<approx\>0>, then
    we may take <math|E<around|(|\<delta\>|)>\<approx\>-V F*\<delta\>>, with
    <math|V\<approx\><around|(|\<partial\> H/\<partial\>
    z|)><around|(|c|)><rsup|-1>> and <math|F\<approx\><around|(|\<partial\>
    H/\<partial\> t|)><around|(|c|)>>. Consider
    <math|\<b-u\>\<in\><bT><rsub|D,\<cal-I\>><rsup|n>> and
    <math|\<b-v\>\<in\><bT><rsub|D,\<cal-I\>>> with

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<b-u\><rsub|i>>|<cell|=>|<cell|<around|(|c<rsub|\<epsilon\>>|)><rsub|i>+\<epsilon\><rsub|i>+E<around|(|\<delta\>|)><rsub|i>>>|<row|<cell|\<b-v\>>|<cell|=>|<cell|c<rsub|\<delta\>>+\<delta\>.>>>>
    </eqnarray*>

    Let <math|g<around|(|z,t|)>=z-V*H<around|(|z,t|)>>,
    <math|\<b-x\>=g<around*|(|c<rsub|\<epsilon\>>+E<around*|(|\<delta\>|)>,\<b-v\>|)>>,
    <math|\<b-y\>=g<around|(|\<b-u\>,\<b-v\>|)>>. If

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<b-x\><rsub|cst>+\<b-y\><rsub|lin>*\<cal-B\><around|(|r<rsub|\<epsilon\>>|)>>|<cell|\<subseteq\>>|<cell|int<around|(|c<rsub|\<epsilon\>>+\<cal-B\><around|(|r<rsub|\<epsilon\>>|)>|)>,<eq-number><label|tube-hyp>>>>>
    </eqnarray*>

    then the equation <math|H<around|(|z,t|)>=0> admits a unique solution
    <math|z\<in\>c<rsub|\<epsilon\>>+E<around|(|t-c<rsub|\<delta\>>|)>+\<cal-B\><around|(|r<rsub|\<epsilon\>>|)>>,
    for every <math|t\<in\>c<rsub|\<delta\>>+\<cal-B\><around|(|r<rsub|\<delta\>>|)>>.
  </theorem>

  <\proof>
    For an illustration of the proof, see
    figure<nbsp><reference|slope-tube-fig>. Let
    <math|u=cen<around|(|\<b-u\>|)>\<in\>\<bbb-C\><around|[|\<epsilon\>,\<delta\>|]><rsup|n>>
    and <math|v=cen<around|(|\<b-v\>|)>\<in\>\<bbb-C\><around|[|\<delta\>|]>>.
    By construction, and using the facts that <math|\<partial\> u/\<partial\>
    \<epsilon\>=1> and <math|\<partial\> v/\<partial\>
    \<epsilon\>=\<partial\> E/\<partial\> \<epsilon\>=0>, we have

    <\eqnarray*>
      <tformat|<table|<row|<cell|g<around*|(|u<around*|(|0,\<delta\>|)>,v<around*|(|\<delta\>|)>|)>>|<cell|\<in\>>|<cell|\<b-x\><rsub|cst>>>|<row|<cell|<tfrac|\<partial\>
      g|\<partial\> u><around|(|u<around|(|\<epsilon\>,\<delta\>|)>,v<around|(|\<delta\>|)>|)>>|<cell|\<in\>>|<cell|\<b-y\><rsub|lin>>>>>
    </eqnarray*>

    for any <math|\<epsilon\>\<in\>\<cal-B\><around|(|r<rsub|\<epsilon\>>|)>>
    and <math|\<delta\>\<in\>\<cal-B\><around|(|r<rsub|\<delta\>>|)>>. For a
    fixed <math|t\<in\>c<rsub|\<delta\>>+\<cal-B\><around|(|r<rsub|\<delta\>>|)>>,
    it follows that <math|\<b-y\><rsub|lin>> encloses
    <math|<around|(|\<partial\> g/\<partial\> u|)><around|(|\<cdummy\>,t|)>>
    on the disk <math|\<cal-U\>\<assign\>c<rsub|\<epsilon\>>+E<around|(|t-c<rsub|\<delta\>>|)>+\<cal-B\><around|(|r<rsub|\<epsilon\>>|)>>.
    Our hypothesis<nbsp>(<reference|tube-hyp>) also implies that

    <\eqnarray*>
      <tformat|<table|<row|<cell|g<around*|(|c<rsub|\<epsilon\>>+E<around*|(|t-c<rsub|\<delta\>>|)>,t|)>+\<b-y\><rsub|lin>*\<cal-B\><around|(|r<rsub|\<epsilon\>>|)>>|<cell|\<subseteq\>>|<cell|int<around|(|\<cal-U\>|)>.>>>>
    </eqnarray*>

    From theorem<nbsp><reference|fp-uniqueness-th>, we conclude that
    <math|g<around|(|\<cdummy\>,t|)>> admits a unique fixed point
    <math|z\<in\>\<cal-U\>>.
  </proof>

  In order to apply the theorem, it remains to be shown how to find a good
  tube, <abbr|i.e.> how to choose <math|c<rsub|\<epsilon\>>>,
  <math|c<rsub|\<delta\>>>, <math|r<rsub|\<epsilon\>>>,
  <math|r<rsub|\<delta\>>> and <math|E<around|(|\<delta\>|)>>. For a fixed
  order <math|k> of the approximation, the idea is to adjust
  <math|c<rsub|\<epsilon\>>> and <math|E<around|(|\<delta\>|)>> such that
  <math|r<rsub|\<epsilon\>>> can be chosen minimal.

  Let us first consider the first order case <math|k=1>. Assume that we
  performed a numeric path continuation from <math|<around|(|z<rsub|t>,t|)>>
  to<nbsp><rigid|<math|<around|(|z<rsub|t<rprime|'>>,t<rprime|'>|)>>> and
  that both <math|<wide|z|\<dot\>><rsub|t>> and
  <math|<wide|z|\<dot\>><rsub|t<rprime|'>>> are approximatively known. Then
  there exists a unique curve <math|<wide|z|~><rsub|s>> of degree three with
  <math|<wide|z|~><rsub|t>=z<rsub|t>>, <math|<wide|z|~><rsub|t<rprime|'>>=z<rsub|t<rprime|'>>>,
  <math|<wide|<wide|z|~>|\<dot\>><rsub|t>=<wide|z|\<dot\>><rsub|t>> and
  <math|<wide|<wide|z|~>|\<dot\>><rsub|t<rprime|'>>=<wide|z|\<dot\>><rsub|t<rprime|'>>>.
  Let <math|<wide|<wide|z|~>|~><rsub|s>> be a linear curve which minimizes
  the maximum <math|\<mu\><rsub|i>> of <math|<around|\||<around|(|<wide|z|~><rsub|s>-<wide|<wide|z|~>|~><rsub|s>|)><rsub|i>|\|>>
  on <math|<around|[|t,t<rprime|'>|]>> for every <math|i>. Then we take
  <math|c<rsub|\<delta\>>=<around|(|t+t<rprime|'>|)>/2>,
  <math|r<rsub|\<delta\>>=<around|(|t<rprime|'>-t|)>/2>,
  <math|c<rsub|\<epsilon\>>=<wide|z|^><rsub|c<rsub|t>>> and
  <math|E<around|(|\<delta\>|)>=<wide|<wide|<wide|z|~>|~>|\<dot\>><rsub|c<rsub|t>>*\<delta\>>.
  We may also take <math|r<rsub|\<epsilon\>>=c*\<mu\>> for some fixed
  <math|c\<gtr\>1> such as <math|c=2>. However, for better performance it is
  recommended to apply an additional inflation to <math|r<rsub|\<epsilon\>>>,
  similar to what we did in the previous<nbsp>section.

  For higher orders <math|k>, we proceed in an essentially similar way. We
  first compute a<nbsp>high order numeric polynomial approximation
  <math|<wide|z|~><rsub|s>> of <math|z<rsub|s>>. For orders <math|\<gtr\>3>,
  this may require the accurate approximation of additional points
  <math|<around|(|z<rsub|t<rprime|''>>,t<rprime|''>|)>> with
  <math|t<rprime|''>\<in\><around|(|t,t<rprime|'>|)>> on the solution path.
  We next find a <math|k>-th order polynomial <math|<wide|z|^><rsub|s>> which
  approximates <math|<wide|z|~><rsub|s>> as good as possible and choose our
  tube in a similar way as above. It should be noticed that the evaluation
  <rigid|<math|g<around|(|\<b-u\>,\<b-v\>|)>>> in
  theorem<nbsp><reference|hom-tube-th> is at least thrice as expensive as the
  numeric evaluation of <math|J<rsub|H>>. This makes it worth it to improve
  the quality of the numeric approximations of points
  <rigid|<math|z<rsub|t>,z<rsub|t<rprime|'>>,z<rsub|t<rprime|''>>>> on the
  curve using one or more additional Newton iterations. The use of higher
  order approximations makes it possible to choose <math|r<rsub|\<epsilon\>>>
  very small, thereby avoiding a great deal of the overestimation due to the
  use of ball arithmetic.

  <subsection|Numeric spearhead computations and certification>

  We insist once more on the importance of performing all certifications as
  late as possible rather than along with the numeric computations
  themselves. One should regard the numeric computation (the spearhead) as an
  educated guess of what is happening and the certification as an independent
  problem at a second stage. In particular, only the numeric results which
  interests us (<abbr|i.e.> the solutions of the polynomial system) need to
  be certified and not the way we obtained them (<abbr|i.e.> the homotopies).

  Even in the case when we are interested in certifying the homotopies
  themselves, it is best to do so once the numeric computations have already
  been completed. This allows for instance for more parallelism in the
  computations. Indeed, we may cut the entire homotopy path in several pieces
  and certify these pieces in parallel. More numeric data may also be
  available once all numeric computations have been completed, which might be
  useful for guiding and accelerating the certification stage.

  Similar remarks apply more generally for certified integration of dynamical
  systems. In that setting, one is often interested in the flow in the
  neighbourhood of some initial condition. The sequential part of such a
  computation resides in the numeric integration for a<nbsp>particular
  initial condition. Once the corresponding numeric trajectory is known
  numerically, we may again cut it in pieces which and compute the
  corresponding flows and certifications in parallel. Whenever the dependence
  on the initial conditions is very strong, the actual numeric integration
  should be done using accurate high order Taylor methods using a multiple
  working precision.

  <section|Certification of multiple univariate
  roots><label|univ-mult-cert-sec>

  In section<nbsp><reference|num-univ-sec>, we have studied in detail the
  numeric determination of a multiple root of a<nbsp>univariate polynomial.
  It is instructive to take up this study and examine how we certify such
  multiple roots. Since the property of being an <math|r>-fold root is lost
  under small perturbations, this is actually impossible using ball
  arithmetic. The best we can hope for is to certify the existence of
  <math|r> roots in a small ball, or the existence of an <math|r>-fold root
  of a<nbsp>small perturbation of the polynomial (see
  also<nbsp><cite|Rump10>).

  <subsection|Applying Rouch's theorem>

  So consider a polynomial <math|P> with an approximate <math|r>-fold root at
  <math|c\<in\>\<bbb-C\>> and assume that we wish to certify that <math|P>
  admits exactly <math|r> roots in the ball
  <math|c+\<cal-B\><around|(|\<rho\>|)>>, for some <math|\<rho\>\<gtr\>0>.
  One first strategy is to make use of the Taylor series expansion of
  <math|P> at<nbsp><math|c>. More precisely, let
  <math|<bT>=<bT><rsub|D,\<cal-I\>,\<cal-I\>>> be the set of univariate
  Taylor models in <math|\<epsilon\>> with
  <math|D=\<cal-B\><around|(|\<rho\>|)>> and
  <math|\<cal-I\>=<around|{|0,\<ldots\>,s|}>> for some <math|s\<geqslant\>r>.
  Evaluating <math|P> at <math|\<b-c\>=c+\<epsilon\>>, we obtain a Taylor
  model <math|\<b-Q\>=P<around|(|\<b-c\>|)>> with the property that
  <math|P<around|(|c+z|)>\<in\>\<b-Q\><rsub|0>+\<cdots\>+\<b-Q\><rsub|s>*z<rsup|s>>
  for any <math|z\<in\>\<cal-B\><around|(|\<rho\>|)>>. It remains to be shown
  that any <math|Q\<in\>\<b-Q\>> admits <math|r> roots in
  <math|\<cal-B\><around|(|\<rho\>|)>>. We claim that this is the case if

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\<lceil\>|\<b-Q\><rsub|0>+\<cdots\>+\<b-Q\><rsub|r-1>*\<cal-B\><around|(|\<rho\>|)><rsup|r-1>+\<b-Q\><rsub|r+1>*\<cal-B\><around|(|\<rho\>|)><rsup|r+1>+\<cdots\>+\<b-Q\><rsub|s>*\<cal-B\><around|(|\<rho\>|)><rsup|s>|\<rceil\>>>|<cell|\<less\>>|<cell|<around|\<lfloor\>|\<b-Q\><rsub|r>|\<rfloor\>>*\<rho\><rsup|n>.<eq-number><label|univ-root-cert>>>>>
  </eqnarray*>

  Indeed, assume that we have<nbsp>(<reference|univ-root-cert>) and let
  <math|Q\<in\>\<b-Q\>>. Then

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around|\||Q<around|(|z|)>-Q<rsub|r>*z<rsup|r>|\|>>|<cell|\<less\>>|<cell|<around|\||Q<rsub|r>*z<rsup|n>|\|>>>>>
  </eqnarray*>

  for all <math|z> with <math|<around|\||z|\|>=\<rho\>>. By Rouch's
  theorem<nbsp><cite-detail|Lang76|page 158>, it follows that
  <math|Q<around|(|z|)>> and <math|Q<rsub|r>*z<rsup|r>> admit the same number
  of roots on <math|\<cal-B\><around|(|\<rho\>|)>>. If <math|r> becomes
  large, or if <math|P> admits other roots close to
  <math|\<cal-B\><around|(|\<rho\>|)>>, then the
  bound<nbsp>(<reference|univ-root-cert>) often does not hold. In that case,
  one may use more sophisticated techniques
  from<nbsp><cite|Sch82b|vdH:rootcount> in order to certify that
  <math|\<b-Q\>> admits <math|r> roots in
  <math|\<cal-B\><around|(|\<rho\>|)>>. From the complexity point of view,
  the series expansion method requires<nbsp><math|\<cal-O\><around|(|<math-ss|M><around|(|r|)>|)>>
  evaluations of<nbsp><math|P>, where<nbsp><math|<math-ss|M><around|(|r|)>>
  denotes the cost of multiplying two polynomials of
  degrees<nbsp><rigid|<math|\<leqslant\>r>>.

  <subsection|Computing the winding number>

  Another approach is to apply Rouch's theorem in a more direct way by
  computing <math|P> on a path <math|\<gamma\>> starting at <math|\<rho\>>
  and which circles around the origin once. If the reliable image
  <math|P\<circ\>\<gamma\>> of this path avoids the origin, then the number
  of roots of <math|P> coincides with the number of times that
  <math|P\<circ\>\<gamma\>> turns around the origin. More precisely, let
  <math|\<omega\>=\<mathe\><rsup|2*\<mathpi\>*\<mathi\>/R>> for
  a<nbsp>suitable <math|R\<gtr\>r> (see also below) and let
  <math|\<b-z\><rsub|i>=\<omega\><rsup|i>+\<cal-B\><around|(|<around|\||<sqrt|\<omega\>>-1|\|>|)>>
  for <math|i\<in\><around|{|0,\<ldots\>,R-1|}>>. Then we evaluate
  <math|\<b-y\><rsub|i>=P<around|(|\<b-z\><rsub|i>|)>> and check whether
  <math|0\<nin\>\<b-y\><rsub|i>> for all <math|i>. If this is the case, then

  <\eqnarray*>
    <tformat|<table|<row|<cell|r<rprime|'>>|<cell|=>|<cell|<frac|1|2*\<mathpi\>>*<big|sum><rsub|i=0><rsup|R-1>arg
    <frac|cen<around|(|\<b-y\><rsub|i+1 mod
    R>|)>|cen<around|(|\<b-y\><rsub|i>|)>>>>>>
  </eqnarray*>

  yields the exact number of roots of <math|P> inside
  <math|\<cal-B\><around|(|\<rho\>|)>>. This method requires<nbsp><math|R>
  evaluations of<nbsp><math|P>, but <math|R> needs to be sufficiently large
  if we want to ensure a reasonable chance of success for the method.

  Let us investigate the choice of an appropriate <math|R> in more detail on
  the simplest example when <math|c=1> and

  <\eqnarray*>
    <tformat|<table|<row|<cell|P<around|(|z|)>>|<cell|=>|<cell|z<rsup|r>-r*z<rsup|r-1>+<binom|r|2>*z<rsup|r-2>+\<cdots\>+<around|(|-1|)><rsup|r>.>>>>
  </eqnarray*>

  Consider the evaluation of <math|P> at <math|\<b-z\>=1+\<rho\>+\<cal-B\><around|(|\<epsilon\>|)>>.
  We have

  <\eqnarray*>
    <tformat|<table|<row|<cell|P<around|(|\<b-z\>|)>>|<cell|=>|<cell|P<around|(|1+\<rho\>|)>+\<cal-B\><around|(|\<sigma\>|)>>>|<row|<cell|>|<cell|=>|<cell|\<rho\><rsup|r>+\<cal-B\><around|(|\<sigma\>|)>>>|<row|<cell|\<sigma\>>|<cell|=>|<cell|<big|sum><rsub|k=0><rsup|r><binom|r|k>*<around|(|<around|(|1+\<rho\>+\<epsilon\>|)><rsup|k>-<around|(|1+\<rho\>|)><rsup|k>|)>>>|<row|<cell|>|<cell|=>|<cell|<around|(|2+\<rho\>+\<epsilon\>|)><rsup|r>-<around|(|2+\<rho\>|)><rsup|r>>>>>
  </eqnarray*>

  For small <math|\<epsilon\>>, the condition
  <math|0\<nin\>P<around|(|\<b-z\>|)>> thus implies

  <\eqnarray*>
    <tformat|<table|<row|<cell|r*<around|(|2+\<rho\>|)><rsup|r-1>*\<epsilon\>>|<cell|\<approx\>>|<cell|<around|(|2+\<rho\>+\<epsilon\>|)><rsup|r>-<around|(|2+\<rho\>|)><rsup|r><space|0.6spc>\<less\><space|0.6spc>\<rho\><rsup|r>.>>>>
  </eqnarray*>

  Roughly speaking, for <math|\<rho\>\<rightarrow\>0>, this means that

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<epsilon\>>|<cell|\<less\>>|<cell|<tfrac|1|r>*<around*|(|<tfrac|\<rho\>|2>|)><rsup|r-1>*\<rho\>>>|<row|<cell|R>|<cell|\<gtr\>>|<cell|<frac|\<rho\>|\<mathpi\>*\<epsilon\>><space|0.6spc>\<gtr\><space|0.6spc>r*<around*|(|<tfrac|2|\<rho\>>|)><rsup|r-1>.>>>>
  </eqnarray*>

  We recall from example<nbsp><reference|overest-ex> that
  <math|<around|(|\<rho\>/2|)><rsup|r-1>> also corresponds to the punctual
  overestimation of the ball evaluation of <math|P> at <math|1+\<rho\>>. If
  we want to reduce <math|R> to a quantity which does not depend on
  <math|\<rho\>>, then it follows from the considerations in
  section<nbsp><reference|reduce-overest-sec> that we need to
  evaluate<nbsp><math|P> using Taylor models of order at least <math|r>.
  However, in that case, we might just as well use the first method based on
  a direct series expansion of <math|P> at <math|c>.

  <subsection|Certifying a local factorization><label|factor-cert-sec>

  Whenever a polynomial <math|P<around*|(|z|)>> admits <math|r> roots
  <math|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|r>> in a disk, then the
  polynomial <math|Q=<around*|(|z-\<alpha\><rsub|1>|)>*\<cdots\>*<around*|(|z-\<alpha\><rsub|r>|)>=z<rsup|r>+Q<rsub|r-1>*z<rsup|r-1>+\<cdots\>+Q<rsub|0>>
  is a monic factor of <math|P>. Instead of trying to determine and certify
  the roots <math|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|r>>
  individually, another idea is to determine and certify this monic factor
  <math|Q> of <math|P>.

  Assuming that <math|P<around*|(|z|)>> admits no other roots near
  <math|<around*|{|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|r>|}>>, we will
  show in this section that <math|Q> forms an isolated zero of <math|P rem
  Q=0>, when regarding this equation as a system of <math|r> equations
  <math|<around*|(|P rem Q|)><rsub|0>=\<cdots\>=<around*|(|P rem
  Q|)><rsub|r-1>=0> in <math|r> variables
  <math|Q<rsub|0>,\<ldots\>,Q<rsub|r-1>>. On one hand, this approach has the
  advantage that we may apply Corollary<nbsp><reference|New-uniqueness-cor>
  in order to certify the factorization. On the other hand, we may use fast
  polynomial arithmetic for the actual evaluation of <math|P rem Q>.

  <\theorem>
    <label|local-fact-th>Let <math|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|\<ell\>>\<in\>\<bbb-C\>>
    be roots of a polynomial <math|P> of multiplicities
    <math|\<mu\><rsub|1>,\<ldots\>,\<mu\><rsub|\<ell\>>\<in\>\<bbb-N\><rsup|\<gtr\>>>,
    and <math|r=\<mu\><rsub|1>+\<cdots\>+\<mu\><rsub|\<ell\>>>. Then
    <math|Q=<around*|(|z-\<alpha\><rsub|1>|)><rsup|\<mu\><rsub|1>>*\<cdots\>*<around*|(|z-\<alpha\><rsub|\<ell\>>|)><rsup|\<mu\><rsub|\<ell\>>>>
    is an isolated zero of the system <math|P rem Q=0>, when considered as a
    system of <math|r> equations <math|<around*|(|P rem
    Q|)><rsub|0>=\<cdots\>=<around*|(|P rem Q|)><rsub|r-1>=0> in <math|r>
    variables <math|Q<rsub|0>,\<ldots\>,Q<rsub|r-1>>.
  </theorem>

  <\proof>
    Given the euclidean division <math|P=A*Q+B> of <math|P> by <math|Q>, we
    have <math|A*\<mathd\> Q+Q*\<mathd\> A+\<mathd\> B=\<mathd\> P=0> for
    small perturbations <math|\<mathd\> Q> of <math|Q>, with <math|deg
    <around*|(|\<mathd\> B|)>\<less\>r>. Consequently,

    <\eqnarray*>
      <tformat|<table|<row|<cell|\<mathd\><around*|(|P rem
      Q|)>>|<cell|=>|<cell|-<around*|(|<around*|(|P quo Q|)>*\<mathd\> Q|)>
      rem Q.>>>>
    </eqnarray*>

    Computing in the quotient algebra <math|\<bbb-C\><around*|[|x|]>/<around*|(|Q|)>>,
    this equation can be reread as

    <\eqnarray*>
      <tformat|<table|<row|<cell|<frac|\<partial\><around*|(|P rem
      Q|)>|\<partial\> Q>>|<cell|=>|<cell|-<around*|(|P quo Q|)> rem
      Q.<eq-number><label|rem-der>>>>>
    </eqnarray*>

    Since <math|P=Q*R> with <math|gcd<around*|(|R,Q|)>=1>, the multiplication
    mapping with <math|R=P quo Q> in <math|\<bbb-C\><around*|[|x|]>/<around*|(|Q|)>>
    is invertible. By<nbsp>(<reference|rem-der>), the Jacobian matrix of

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|(|Q<rsub|0>,\<ldots\>,Q<rsub|r-1>|)>>|<cell|\<longmapsto\>>|<cell|<around*|(|<around*|(|P
      rem Q|)><rsub|0>,\<ldots\>,<around*|(|P rem Q|)><rsub|r-1>|)>>>>>
    </eqnarray*>

    is precisely the matrix of this multiplication mapping with respect to
    the canonical basis <math|<around*|(|1,x,\<ldots\>,x<rsup|r-1>|)>>.
  </proof>

  <section|Effective complex analysis>

  For the sequel, it will sometimes be convenient to consider the more
  general context of analytic functions instead of mere polynomials. We
  provide two formalizations of computable multivariate analytic functions:
  an abstract one relying on analytic continuation in
  section<nbsp><reference|an-def1-sec>, as well as a more concrete evaluation
  based one in section<nbsp><reference|an-def2-sec>. In the remainder of the
  section, we will discuss evaluation of analytic functions in zero
  dimensional algebras, effective Weierstrass preparation, and computable
  meromorphic functions.

  <subsection|Computable multivariate analytic functions><label|an-def1-sec>

  We recall<nbsp><cite|Wei00> that a real number <math|x\<in\>\<bbb-R\>> is
  said to be <em|left> (<abbr|resp.> <em|right>) <em|computable> if there
  exists an increasing (<abbr|resp.> decreasing) computable sequence
  <math|<around*|(|x<rsub|n>|)>\<in\>\<bbb-Q\><rsup|\<gtr\>>> with
  <math|x=lim<rsub|n\<rightarrow\>\<infty\>> x<rsub|n>>. We say that
  <math|x\<in\>\<bbb-R\>> is <em|computable> if <math|x> is both left and
  right computable. We denote the sets of computable, left computable and
  right computable real numbers by <math|\<bbb-R\><rsup|com>>,
  <math|\<bbb-R\><rsup|lcom>> and <math|\<bbb-R\><rsup|rcom>>. We define
  <math|\<bbb-C\><rsup|com>=\<bbb-R\><rsup|com><around*|[|\<mathi\>|]>> to be
  the set of computable complex numbers. The definitions also adapt in a
  straightforward way to extended real numbers
  <math|x\<in\><wide|\<bbb-R\>|\<bar\>>=\<bbb-R\>\<cup\><around*|{|-\<infty\>,\<infty\>|}>>.
  The theory of computable real numbers provides a suitable abstract
  framework for studying which analytic problems can be solved.

  In<nbsp><cite|vdH:effan|vdH:riemann>, we proposed a similar concept of
  computable analytic functions. Given an analytic function <math|f> at the
  origin, we say that <math|f> is <em|computable> if there exists methods for
  computing the power series expansion of <math|f>, a lower bound for its
  convergence radius, an upper bound for <math|f> on any closed disk on which
  <math|f> converges, and a method for the analytic continuation of <math|f>.
  Formally speaking, denoting by <math|\<bbb-F\><rsup|com>> the set of such
  functions, this means that we may compute

  <\itemize>
    <item>The computable power series expansion
    <math|<with|math-font-family|ms|series><around|(|f|)>\<in\>\<bbb-C\><rsup|com><around|[|<around|[|z|]>|]><rsup|com>>
    of <math|f> (this means that we have an algorithm for the computation of
    the coefficients of <math|<with|math-font-family|ms|series><around|(|f|)>>).

    <item>A lower bound <math|<reff|f>\<in\><wide|\<bbb-R\>|\<bar\>><rsup|lcom,\<gtr\>>>
    for the radius of convergence <math|r<rsub|f>> of <math|f>.

    <item>A computable partial function <math|<Beff|f><rsub|\<cdot\>>:\<bbb-R\><rsup|com,\<gtr\>>\<rightharpoonup\>\<bbb-R\><rsup|rcom>>,
    which yields an upper bound <math|<Beff|f><rsub|\<rho\>>\<geqslant\><around*|\<\|\|\>|f|\<\|\|\>><rsub|\<rho\>>=sup<rsub|<around*|\||z|\|>\<leqslant\>\<rho\>>
    <around*|\||f<around*|(|z|)>|\|>> for every
    <math|\<rho\>\<less\><reff|f>>.

    <item>A computable partial function <math|f<rsub|+\<cdot\>>:\<bbb-C\><rsup|com>\<rightharpoonup\>\<bbb-F\><rsup|com>>,
    which yields the analytic continuation <math|f<rsub|+\<delta\>>> of
    <math|f> (with <math|f<rsub|+\<delta\>><around*|(|z|)>=f<around*|(|z+\<delta\>|)>>)
    as a function of <math|\<delta\>\<in\>\<bbb-C\><rsup|com>> with
    <math|<around|\||\<delta\>|\|>\<less\><reff|f>>.
  </itemize>

  Given <math|f\<in\>\<bbb-F\><rsup|com>>, we call <math|<reff|f>> its
  <em|computable radius of convergence>. Usually, <math|<reff|f>> is smaller
  than the genuine radius of convergence of
  <math|<with|math-font-family|ms|series><around|(|f<rsub|>|)>>.

  This definition admits several variants. In practice, it is usually most
  convenient to provide a method for the computation of bounds
  <math|<Beff|f><rsub|\<rho\>>> using ball arithmetic and allow for infinite
  bounds. In that case, we automatically obtain an algorithm for the
  computation of<nbsp><math|<reff|f>>, by taking <math|<reff|f>\<assign\>max
  <around*|{|\<rho\>\<in\>\<bbb-R\><rsup|com,\<gtr\>>:<Beff|f><rsub|\<rho\>>\<less\>\<infty\>|}>>.
  This definition is also convenient to extend to the case of multivariate
  analytic functions <math|f> in <math|z<rsub|1>,\<ldots\>,z<rsub|n>>. In
  this case, we require algorithms for the computation of:

  <\itemize>
    <item>The computable power series expansion
    <math|<with|math-font-family|ms|series><around|(|f|)>\<in\>\<bbb-C\><rsup|com><around|[|<around|[|z<rsub|1>,\<ldots\>,z<rsub|n>|]>|]><rsup|com>>
    of <math|f>.

    <item>A computable partial function <math|<Beff|f><rsub|\<cdot\>>:<around*|(|\<bbb-R\><rsup|com,\<gtr\>>|)><rsup|n>\<rightharpoonup\><wide|\<bbb-R\>|\<bar\>><rsup|rcom>>,
    which yields a possibly infinite upper bound
    <math|<Beff|f><rsub|\<rho\>>\<geqslant\><around*|\<\|\|\>|f|\<\|\|\>><rsub|\<rho\>>=sup<rsub|<around*|\||z|\|>\<leqslant\>\<rho\>>
    <around*|\||f<around*|(|z|)>|\|>>.

    <item>A computable partial function <math|f<rsub|+\<cdot\>>:<around*|(|\<bbb-C\><rsup|com>|)><rsup|n>\<rightharpoonup\>\<bbb-F\><rsup|com>>,
    which yields the analytic continuation <math|f<rsub|+\<delta\>>> of
    <math|f> as a function of <math|\<delta\>\<in\>\<bbb-C\><rsup|com>> with
    <math|<Beff|f><rsub|<around*|\||\<delta\>|\|>>\<less\>\<infty\>>.
  </itemize>

  Recall that the function <math|<Beff|f><rsub|\<cdummy\>>> is necessarily
  upper continuous<nbsp>(<abbr|e.g.> <cite-detail|vdH:riemann|Theorem 2.3>).
  In particular, for every <math|\<rho\>> with
  <math|<Beff|f><rsub|\<rho\>>\<less\>\<infty\>> there exists an
  <math|\<varepsilon\>\<in\>\<bbb-Q\><rsup|\<gtr\>>> with
  <math|<Beff|f><rsub|<around*|(|1+\<varepsilon\>|)>*\<rho\>>\<less\>\<infty\>>.

  <subsection|Multivariate analytic functions as evaluable
  functions><label|an-def2-sec>

  In practice, multivariate analytic functions such as <math|exp
  <around*|(|x*log<around*|(|1-y|)>|)>*erf<around*|(|x<rsup|2>-y<rsup|2>|)>>
  are often built up as dags from univariate analytic functions such as
  <math|log,exp> and <math|erf>. In that case, it would be very expensive to
  systematically use power series expansions in several variables in order to
  compute with such functions. Instead, it would be better to represent such
  multivariate analytic functions as objects which can be <em|evaluated> at
  analytic functions in an arbitrary number of variables, or even at points
  in more general algebras.

  More precisely, let <math|\<bbb-A\><rsup|com>\<supseteq\>\<bbb-C\><rsup|com>>
  be an effective Banach algebra over <math|\<bbb-C\><rsup|com>>. This means
  that <math|\<bbb-A\><rsup|com>> is the set of computable points in a Banach
  algebra <math|\<bbb-A\>> over <math|\<bbb-C\>>, and that the operations
  <math|+,-,\<times\>> and the norm <math|<around*|\<\|\|\>|\<cdummy\>|\<\|\|\>>:\<bbb-A\>\<rightarrow\>\<bbb-R\><rsup|\<geqslant\>>>
  can be computed by algorithm. Recall that

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\<\|\|\>|a+b|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<around*|\<\|\|\>|a|\<\|\|\>>+<around*|\<\|\|\>|b|\<\|\|\>>>>|<row|<cell|<around*|\<\|\|\>|a*b|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<around*|\<\|\|\>|a|\<\|\|\>>*<around*|\<\|\|\>|b|\<\|\|\>>,>>>>
  </eqnarray*>

  for all <math|a,b\<in\>\<bbb-A\>>. We do not necessarily assume
  <math|\<bbb-A\>> to be commutative. Given a multivariate analytic
  function<nbsp><math|f> in <math|z<rsub|1>,\<ldots\>,z<rsub|n>> with
  <math|<Beff|f><rsub|\<rho\>>\<less\>\<infty\>> and pairwise commuting
  <math|a<rsub|1>,\<ldots\>,a<rsub|n>\<in\>\<bbb-A\>> with
  <math|<around*|\<\|\|\>|a<rsub|i>|\<\|\|\>>\<leqslant\>\<rho\><rsub|i>> for
  <math|i=1,\<ldots\>,n>, the evaluation

  <\eqnarray*>
    <tformat|<table|<row|<cell|b=f<around*|(|a<rsub|1>,\<ldots\>,a<rsub|n>|)>>|<cell|=>|<cell|<big|sum><rsub|k\<in\>\<bbb-N\><rsup|n>>f<rsub|k>*a<rsub|1><rsup|k<rsub|1>>*\<cdots\>*a<rsub|n><rsup|k<rsub|n>><eq-number><label|banach-eval>>>>>
  </eqnarray*>

  is well defined. What is more: if <math|f\<in\>\<bbb-F\><rsup|com>> and
  <math|a<rsub|1>,\<ldots\>,a<rsub|n>\<in\>\<bbb-A\><rsup|com>>, then
  <math|f<around*|(|a<rsub|1>,\<ldots\>,a<rsub|n>|)>\<in\>\<bbb-A\><rsup|com>>.
  Indeed, we start by computing <math|\<varepsilon\>\<in\>\<bbb-Q\><rsup|\<gtr\>>>
  and <math|M=<Beff|f><rsub|<around*|(|1+\<varepsilon\>|)>*\<rho\>>\<less\>\<infty\>>
  such that <math|M\<less\>\<infty\>>. For fixed <math|K\<in\>\<bbb-N\>> and

  <\eqnarray*>
    <tformat|<table|<row|<cell|<wide|b|~>>|<cell|=>|<cell|<big|sum><rsub|k<rsub|1>,\<ldots\>,k<rsub|n>\<less\>K>f<rsub|k>*a<rsub|1><rsup|k<rsub|1>>*\<cdots\>*a<rsub|n><rsup|k<rsub|n>>,>>>>
  </eqnarray*>

  we then have

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\<\|\|\>|<wide|b|~>-b|\<\|\|\>>>|<cell|\<leqslant\>>|<cell|<big|sum><rsub|i=1><rsup|n><big|sum><rsub|k><around*|\<\|\|\>|f<rsub|k>*a<rsub|1><rsup|k<rsub|1>>*\<cdots\>*a<rsub|n><rsup|k<rsub|n>>*a<rsub|i><rsup|K>|\<\|\|\>>,>>|<row|<cell|>|<cell|\<leqslant\>>|<cell|n*M*<around*|(|<tfrac|1+\<varepsilon\>|\<varepsilon\>>|)><rsup|n>*<around*|(|<tfrac|1|1+\<varepsilon\>>|)><rsup|K*n>.>>>>
  </eqnarray*>

  By choosing <math|K> sufficiently large, we may thus make
  <math|<around*|\<\|\|\>|<wide|b|~>-b|\<\|\|\>>> as small as desired.

  Conversely, assume now that, in the definition of computable multivariate
  analytic functions, we replace the method
  <math|<with|math-font-family|ms|series>:\<bbb-F\><rsup|com>\<rightarrow\>\<bbb-C\><rsup|com><around*|[|<around*|[|z<rsub|1>,\<ldots\>,z<rsub|n>|]>|]><rsup|com>>
  by an evaluation method <math|<with|math-font-family|ms|eval><rsub|\<bbb-A\><rsup|com>>:\<bbb-F\><rsup|com>\<times\><around*|(|\<bbb-A\><rsup|com>|)><rsup|n>\<rightarrow\>\<bbb-A\><rsup|com>>
  for <em|any> effective Banach algebra <math|\<bbb-A\><rsup|com>>
  over<nbsp><math|\<bbb-C\><rsup|com>>. In particular, given
  <math|\<rho\>\<in\><around*|(|\<bbb-R\><rsup|com>|)><rsup|n>>, we may take
  <math|\<bbb-A\>> to be the algebra of all formal power series
  <math|\<varphi\>\<in\>\<bbb-C\><around*|[|<around*|[|z<rsub|1>,\<ldots\>,z<rsub|n>|]>|]>>
  for which

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\<\|\|\>|\<varphi\>|\<\|\|\>>>|<cell|=>|<cell|sup<rsub|k\<in\>\<bbb-N\><rsup|n>><around*|\<\|\|\>|\<varphi\><rsub|k>*\<rho\><rsup|k>|\<\|\|\>>>>>>
  </eqnarray*>

  is finite. Given <math|f\<in\>\<bbb-F\><rsub|com>> with
  <math|r<rsub|f>\<gtr\>\<rho\>>, it follows that the evaluation
  <math|><math|<with|math-font-family|ms|eval><rsub|\<bbb-A\><rsup|com>><around*|(|f,z<rsub|1>,\<ldots\>,z<rsub|n>|)>>
  is well defined, and this evaluation yields the power series expansion of
  <math|f> at the origin. This shows that providing an evaluation method
  <math|<with|math-font-family|ms|eval><rsub|\<bbb-A\><rsup|com>>> is
  essentially equivalent to providing a method
  <math|<with|math-font-family|ms|series>> for series expansion.

  <\remark>
    In fact, analytic continuation and bound computation can also be regarded
    as evaluations in suitable ``Banach algebras''. Indeed, the analytic
    continuation at <math|\<delta\>\<in\>\<bbb-C\><rsup|com>> corresponds to
    the evaluation at the analytic function <math|\<delta\>+z>. The
    computation of the bound <math|<Beff|f><rsub|\<rho\>>> can be done by
    evaluating <math|f> at the ball <math|<value|B><around*|(|0,\<rho\>|)>>
    and taking <math|<Beff|f><rsub|\<rho\>>=<around*|\<\|\|\>|f<around*|(|<value|B><around*|(|0,\<rho\>|)>|)>|\<\|\|\>>>,
    where <math|<around*|\<\|\|\>|<value|B><around*|(|c,r|)>|\<\|\|\>>=<around*|\||c|\|>+r>.
    Nevertheless, explicit methods for analytic continuation and bound
    computations are usually of a better quality. They may also be needed for
    the implementation of more general evaluation methods.

    Following the same line of ideas, it may also be useful to consider the
    evaluation of analytic functions at broken line paths (or more general
    piecewise analytic paths) instead of ordinary points, thereby combining
    analytic continuation and ordinary evaluation in a<nbsp>single method.
    One might even consider evaluations at ``paths''
    <math|\<bbb-A\><rsub|1>,\<ldots\>,\<bbb-A\><rsub|k>> of successive Banach
    algebras of a similar type, such as <math|\<bbb-A\><rsub|i>=\<bbb-C\><around*|[|z|]>/<around*|(|z<rsup|2>-\<alpha\><rsub|i>*z-\<beta\><rsub|i>|)>>
    with the <math|\<alpha\><rsub|i>> and the<nbsp><math|\<beta\><rsub|i>>
    sufficiently close, and <math|\<alpha\><rsub|1>=\<beta\><rsub|1>=0>.
  </remark>

  <subsection|Evaluation in commutative zero dimensional algebras>

  In order to simplify notations, we will now stop our digression on the
  abstract notions of computability and drop the superscripts ``com''. In
  view of what we have seen in section<nbsp><reference|herd-cert-sec>, it is
  particularly interesting to evaluate multivariate analytic functions in
  commutative zero dimensional algebras <math|\<bbb-A\>> over
  <math|\<bbb-C\>>. Therefore, we will now study this special case in
  more<nbsp>detail.

  Let <math|\<bbb-A\>> be a finite dimensional <math|\<bbb-C\>>-algebra.
  Given any basis for <math|\<bbb-A\>>, the elements of <math|\<bbb-A\>> can
  be represented by matrices, so <math|\<bbb-A\>> may be identified with a
  commutative subalgebra of the algebra <math|\<bbb-C\><rsup|k\<times\>k>> of
  <math|k\<times\>k> matrices for some <math|k>. In particular, any matrix
  norm on <math|\<bbb-C\><rsup|k\<times\>k>> induces a norm on
  <math|\<bbb-A\>>.

  Given a multivariate analytic function <math|f> at the origin which is
  convergent on a polydisk of polyradius <math|\<rho\>\<in\><around*|(|\<bbb-R\><rsup|\<gtr\>>|)><rsup|n>>,
  we may use<nbsp>(<reference|banach-eval>) in order to evaluate <math|f> at
  any points <math|a<rsub|1>,\<ldots\>,a<rsub|n>\<in\>\<bbb-A\>> with
  <math|<around*|\<\|\|\>|a<rsub|i>|\<\|\|\>>\<leqslant\>\<rho\><rsub|i>> for
  all <math|i>. Since the <math|a<rsub|i>> commute, it is actually possible
  to do a bit better. Indeed, it is classical that there exists an invertible
  matrix <math|U> (corresponding to a base change), such that

  <\eqnarray*>
    <tformat|<table|<row|<cell|U*a<rsub|i>*U<rsup|-1>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|T<rsub|i,1>>|<cell|>|<cell|>>|<row|<cell|>|<cell|\<ddots\>>|<cell|>>|<row|<cell|>|<cell|>|<cell|T<rsub|i,l>>>>>>=<matrix|<tformat|<table|<row|<cell|\<lambda\><rsub|i,1>+E<rsub|i,1>>|<cell|>|<cell|>>|<row|<cell|>|<cell|\<ddots\>>|<cell|>>|<row|<cell|>|<cell|>|<cell|\<lambda\><rsub|i,l>+E<rsub|i,l>>>>>>,>>>>
  </eqnarray*>

  where <math|\<lambda\><rsub|i,j>\<in\>\<bbb-C\>>, each <math|E<rsub|i,j>>
  is a nilpotent triagonal <math|k<rsub|j>\<times\>k<rsub|j>> matrix, and
  <math|k=k<rsub|1>+\<cdots\>+k<rsub|l>>. We may thus compute
  <math|f<around*|(|a<rsub|1>,\<ldots\>,a<rsub|n>|)>> using

  <\eqnarray*>
    <tformat|<table|<row|<cell|f<around*|(|a<rsub|1>,\<ldots\>,a<rsub|n>|)>>|<cell|=>|<cell|U*<matrix|<tformat|<table|<row|<cell|f<around*|(|T<rsub|1,1>,\<ldots\>,T<rsub|n,1>|)>>|<cell|>|<cell|>>|<row|<cell|>|<cell|\<ddots\>>|<cell|>>|<row|<cell|>|<cell|>|<cell|f<around*|(|T<rsub|1,l>,\<ldots\>,T<rsub|n,l>|)>>>>>>*U<rsup|-1>.>>>>
  </eqnarray*>

  For any <math|j> with <math|k<rsub|j>=1>, we notice that the evaluation
  <math|f<around*|(|T<rsub|1,j>,\<ldots\>,T<rsub|n,j>|)>> reduces to an
  evaluation <math|f<around*|(|\<lambda\><rsub|1,j>,\<ldots\>,\<lambda\><rsub|n,j>|)>>
  at an ordinary point. If <math|n=1>, then we also notice that

  <\eqnarray*>
    <tformat|<table|<row|<cell|f<around*|(|T<rsub|1,j>|)>>|<cell|=>|<cell|<big|sum><rsub|i=0><rsup|r>f<rsup|<around*|(|i|)>><around*|(|\<lambda\><rsub|1,j>|)>*E<rsub|1,j><rsup|i>,>>>>
  </eqnarray*>

  where <math|r> is minimal with <math|E<rsub|1,j><rsup|r+1>=0>.

  <subsection|Weierstrass preparation>

  <subsubsection|Implicit functions><label|impl-th-sec>

  Let us start with a special case of Weierstrass preparation: the implicit
  function theorem. Consider a computable analytic function <math|f> in
  <math|z<rsub|1>,\<ldots\>,z<rsub|n>> in the neighbourhood of a point
  <math|\<alpha\>=<around*|(|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|n>|)>>.
  Assume that <math|f<around*|(|\<alpha\>|)>=<around*|(|\<partial\>
  f/\<partial\> z<rsub|n>|)><around*|(|\<alpha\>|)>=0> but
  <math|<around|(|\<partial\> f/\<partial\>
  z<rsub|n>|)><around*|(|\<alpha\>|)>\<neq\>0>. Then the implicit function
  theorem states that there exists a unique analytic function
  <math|g=<rigid|<math-ss|solve><around*|(|f,\<alpha\>|)>>> in
  <rigid|<math|z<rsub|1>,\<ldots\>,z<rsub|n-1>>> such that
  <math|f<around*|(|z<rsub|1>,\<ldots\>,z<rsub|n-1>,g<around*|(|z<rsub|1>,\<ldots\>,z<rsub|n-1>|)>|)>=0>
  in a neighbourhood of <rigid|<math|<around*|(|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|n-1>|)>>>
  and <math|g<around*|(|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|n-1>|)>=\<alpha\><rsub|n>>.
  It is not hard to check that <math|g> is computable, for instance in the
  sense of section<nbsp><reference|an-def1-sec>:

  <\itemize>
    <item>The coefficients of <math|g> can be computed using the classical
    formulas for implicit functions or using relaxed power series
    evaluation<nbsp><cite|vdH:relax>.

    <item>Bound computations can be done using
    Corollary<nbsp><reference|New-uniqueness-cor>.

    <item>Given sufficiently small <math|\<delta\><rsub|1>,\<ldots\>,\<delta\><rsub|n-1>>
    and <math|\<delta\><rsub|n>=g<around*|(|\<alpha\><rsub|1>+\<delta\><rsub|1>,\<ldots\>,\<alpha\><rsub|n-1>+\<delta\><rsub|n-1>|)>-\<alpha\><rsub|n>>,
    the analytic continuation of <math|g> from
    <math|<around*|(|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|n-1>|)>> to
    <math|<around*|(|\<alpha\><rsub|1>+\<delta\><rsub|1>,\<ldots\>,\<alpha\><rsub|n-1>+\<delta\><rsub|n-1>|)>>
    is simply <math|g<rsub|+\<delta\>>=<math-ss|solve><around*|(|f<rsub|+\<delta\>>,\<alpha\>+\<delta\>|)>>.
  </itemize>

  More generally, given <math|k> analytic functions
  <math|f=<around*|(|f<rsub|1>,\<ldots\>,f<rsub|k>|)>> such that the Jacobian
  matrix <math|J=\<partial\> f/\<partial\> z> has full rank <math|k> at
  <math|\<alpha\>>, then it can be shown in a similar way that the system
  of<nbsp><math|k> equations in <math|k> unknowns
  <math|g<rsub|1>,\<ldots\>,g<rsub|k>>

  <\eqnarray*>
    <tformat|<table|<row|<cell|f<around*|(|z<rsub|1>,\<ldots\>,z<rsub|n-k>,g<rsub|1><around*|(|z<rsub|1>,\<ldots\>,z<rsub|n-k>|)>,\<ldots\>,g<rsub|k><around*|(|z<rsub|1>,\<ldots\>,z<rsub|n-k>|)>|)>>|<cell|=>|<cell|0>>|<row|<cell|g<rsub|i><around*|(|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|n-k>|)>>|<cell|=>|<cell|\<alpha\><rsub|n-k+i>>>>>
  </eqnarray*>

  admits a unique analytic solution at <math|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|n-k>>
  which is again computable. Notice that this more general case also follows
  through a <math|k>-fold application of the case of a single function.

  <subsubsection|Weierstrass preparation><label|weierstrass-sec>

  Let us still consider a computable analytic function <math|f> in
  <math|z<rsub|1>,\<ldots\>,z<rsub|n>> in the neighbourhood of a<nbsp>point
  <math|\<alpha\>=<around*|(|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|n>|)>>.
  Assume now that <math|f<around*|(|\<alpha\>|)>=<around*|(|\<partial\>
  f/\<partial\> z<rsub|n>|)><around*|(|\<alpha\>|)>=\<cdots\>=<rigid|<around|(|\<partial\><rsup|r-1>
  f/\<partial\> z<rsub|n><rsup|r-1>|)><around*|(|\<alpha\>|)>>=<no-break>0>
  but <math|<around|(|\<partial\><rsup|r> f/\<partial\>
  z<rsub|n><rsup|r>|)><around*|(|\<alpha\>|)>\<neq\>0>. Then the Weierstrass
  preparation theorem states that there exist unique analytic functions
  <math|g<rsub|0>,\<ldots\>,g<rsub|r-1>> in
  <math|z<rsub|1>,\<ldots\>,z<rsub|n-1>> and an invertible analytic function
  <math|u> in <rigid|<math|z<rsub|1>,\<ldots\>,z<rsub|n>>> such that

  <\eqnarray*>
    <tformat|<table|<row|<cell|f>|<cell|=>|<cell|<around|(|z<rsub|n><rsup|r>+g<rsub|r-1>*z<rsub|n><rsup|r-1>+\<cdots\>+g<rsub|0>|)>*u.<eq-number><label|weierstrass-dec>>>>>
  </eqnarray*>

  We may regard<nbsp>(<reference|weierstrass-dec>) as a local factorization
  of the analytic function <math|f> in <math|z<rsub|n>>, which depends on
  <math|z<rsub|1>,\<ldots\>,z<rsub|n-1>> as parameters. Now
  Theorem<nbsp><reference|local-fact-th> for the computation of local
  factorizations readily generalizes to computable analytic functions. More
  precisely, <math|g=z<rsub|n><rsup|r>+g<rsub|r-1>*z<rsub|n><rsup|r-1>+\<cdots\>+g<rsub|0>>
  is the solution of the system <math|f rem<rsub|z<rsub|n>> g=0>, which we
  consider as a<nbsp>system of <math|r> analytic equations <math|<around*|(|f
  rem<rsub|z<rsub|n>> g|)><rsub|0>=\<cdots\>=<around*|(|f rem<rsub|z<rsub|n>>
  g|)><rsub|r-1>=0> in <math|n-1+r> unknowns
  <math|<rigid|z<rsub|1>,\<ldots\>,z<rsub|n-1>>,<rigid|g<rsub|0>,\<ldots\>,g<rsub|r-1>>>.
  It can be checked that this system of equations admits full rank, so that
  we may compute <math|g<rsub|0>,\<ldots\>,g<rsub|r-1>> by applying the
  effective implicit function.

  <subsubsection|Certifying the multiplicity in a small
  neighbourhood><label|an-mult-sec>

  Effective Weierstrass preparation as described in the previous section can
  only be applied on rare occasions. Indeed, the assumption that we have an
  exact multiple cancellation <math|f<around*|(|\<alpha\>|)>=<around*|(|\<partial\>
  f/\<partial\> z<rsub|n>|)><around*|(|\<alpha\>|)>=\<cdots\>=<rigid|<around|(|\<partial\><rsup|r-1>
  f/\<partial\> z<rsub|n><rsup|r-1>|)>><around*|(|\<alpha\>|)>=0> is too
  ambitious, and needs to be replaced by the weaker condition that <math|f>
  has a multiplicity <math|r> in <math|z<rsub|n>> in a small neighbourhood of
  <math|\<alpha\>>. This condition is still enough for the existence of a
  unique solution to the system <math|f rem<rsub|z<rsub|n>> g> in a
  neighbourhood of <math|\<alpha\>>.

  This naturally leads us to the question how to certify that <math|f> has
  multiplicity <math|r> in <math|z<rsub|n>>, in a small neighbourhood of
  <math|\<alpha\>>, and uniformly in <math|z<rsub|1>,\<ldots\>,z<rsub|n-1>>.
  In fact, paying some care, all methods from
  section<nbsp><reference|univ-mult-cert-sec> can be generalized to this
  setting. First of all, when using ball arithmetic, the parameters
  <math|z<rsub|1>,\<ldots\>,z<rsub|n-1>> are simply replaced by small balls
  <math|\<b-alpha\><rsub|1>,\<ldots\>,\<b-alpha\><rsub|n-1>> around
  <math|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|n-1>>, which reduces the
  problem to a univariate one. Secondly, when working with Taylor models at
  any chosen truncation order <math|T>, the tail
  <math|f<rsub|T>*<around*|(|z<rsub|n>-\<alpha\><rsub|n>|)><rsup|T>+f<rsub|T+1>*<around*|(|z<rsub|n>-\<alpha\><rsub|n>|)><rsup|T+1>+\<cdots\>>
  of an analytic function near<nbsp><math|\<alpha\><rsub|n>> is replaced by a
  ball of the form <math|\<cal-B\><rsub|\<b-alpha\><rsub|n>><around|(|\<varepsilon\>|)>>
  or <math|\<cal-B\><rsub|\<b-alpha\><rsub|n>><around|(|\<varepsilon\>*z<rsub|n><rsup|T>|)>>.
  This reduction allows us to work with polynomials instead of series.

  We also notice that the above certification methods can actually prove
  something slightly stronger than a uniform multiplicity: they can usually
  be used to verify that the zero set <math|\<cal-Z\>=<around*|{|z\<in\>\<b-alpha\>:f<around*|(|z|)>=0|}>>
  does not intersect <math|\<b-alpha\><rsub|1>\<times\>\<cdots\>\<times\>\<b-alpha\><rsub|n-1>\<times\>\<partial\>
  \<b-alpha\><rsub|n>>. If such is the case, then we say that the equation
  <math|f<around*|(|z|)>=0> is <em|equisolvable> in <math|z<rsub|n>> on
  <math|\<b-alpha\>>.

  <subsubsection|Analytic elimination on small balls><label|resultant-sec>

  Given a ball <math|\<b-alpha\>\<in\><bC><rsup|n>> (and where we recall that
  such a ``ball'' is really a polydisk) such that we can certify a constant
  multiplicity <math|r> of <math|f> in<nbsp><math|z<rsub|n>> on
  <math|\<b-alpha\>>, the unique (and computable) analytic function
  <math|g=z<rsub|n><rsup|r>+g<rsub|r-1>*z<rsub|n><rsup|r-1>+\<cdots\>+g<rsub|0>>
  such that <math|f/g> is an analytic unit on <math|\<b-alpha\>> will be
  called the Weierstrass normalization of <math|f> on <math|\<b-alpha\>>.

  Given two analytic functions <math|f> and <math|\<varphi\>> on
  <math|\<b-alpha\>>, assume that we can certify a constant multiplicity for
  at least one of them, say for <math|f>, and let <math|g> be as above. Then
  Weierstrass division of <math|\<varphi\>> by <math|g> yields unique
  analytic functions <math|\<chi\>> and <math|\<rho\>> such that
  <math|\<varphi\>=\<chi\>*g+\<rho\>> and <math|\<rho\>> is polynomial in
  <math|z<rsub|n>> with <math|deg<rsub|z<rsub|n>> \<rho\>\<less\>r>. We may
  obtain (the residue class of) <math|\<rho\>> as a computable analytic
  function through evaluation of <math|\<varphi\>> in the quotient algebra
  <math|\<bbb-F\><rsup|com>/<around*|(|g|)>> of computable analytic functions
  in <math|z<rsub|1>,\<ldots\>,z<rsub|n>> by the relation <math|g=0>.

  Having computed the remainder <math|\<rho\>=\<varphi\> rem g> of the
  Weierstrass division of <math|\<varphi\>> by <math|g>, we may finally form
  the resultant <math|R=Res<rsub|z<rsub|n>><around*|(|\<rho\>,g|)>> of the
  polynomials <math|\<rho\>> and <math|g> in <math|z<rsub|n>>. This resultant
  is a computable analytic function in <math|z<rsub|1>,\<ldots\>,z<rsub|n-1>>
  whose zeros are precisely the projections of the common zeros of <math|f>
  and <math|\<varphi\>> on <math|\<bbb-C\><rsup|n-1>>. We will also call
  <math|R=Res<rsub|z<rsub|n>><around*|(|f,\<varphi\>|)>> the <em|analytic
  resultant> of <math|f> and <math|g> on <math|\<b-alpha\>>. Whenever
  <math|Res<rsub|z<rsub|n>><around*|(|\<varphi\>,f|)>> is also defined, it
  can be checked that <math|Res<rsub|z<rsub|n>><around*|(|\<varphi\>,f|)>=w*Res<rsub|z<rsub|n>><around*|(|f,\<varphi\>|)>>
  for some analytic unit <math|w> on <math|\<b-alpha\><rsub|1>\<times\>\<cdots\>\<times\>\<b-alpha\><rsub|n-1>>.
  Indeed, writing <math|f=u*g> and <math|\<varphi\>=v*\<psi\>> for analytic
  units <math|u> and <math|v>, <math|Res<rsub|z<rsub|n>><around*|(|f,\<varphi\>|)>\<equiv\><rigid|Res<rsub|z<rsub|n>><around*|(|g,\<varphi\>|)>>=Res<rsub|z<rsub|n>><around*|(|g,\<varphi\>
  rem g|)>=Res<rsub|z<rsub|n>><around*|(|g,v rem
  g|)>*Res<rsub|z<rsub|n>><around*|(|g,\<psi\> rem
  g|)>=Res<rsub|z<rsub|n>><around*|(|g,v rem
  g|)>*Res<rsub|z<rsub|n>><around*|(|g,\<psi\>|)>> and
  <math|Res<rsub|z<rsub|n>><around*|(|g,v rem g|)>> is a unit. Similarly,
  <math|Res<rsub|z<rsub|n>><around*|(|\<varphi\>,f|)>=Res<rsub|z<rsub|n>><around*|(|\<psi\>,u
  rem \<psi\>|)>*Res<rsub|z<rsub|n>><around*|(|\<psi\>,g|)>>.

  <subsection|Simplifying computable meromorphic functions>

  A computable meromorphic function is simply the quotient of two computable
  analytic functions such that the denominator is non zero. The computable
  meromorphic functions on a given domain form an effective field (but
  without a zero test). Using an external argument, we sometimes know that a
  computable meromorphic function <math|f/g> is actually analytic on some
  domain. In this case, we would like to conclude that <math|f/g> is
  computably analytic on this domain.

  <subsubsection|A reliable version of l'Hpital's rule>

  Let us first consider the case when <math|f> and <math|g> are both
  univariate computable analytic functions in <math|z>, in the neighbourhood
  of a single isolated zero <math|\<alpha\>>. We start with the subcase when
  <math|g=z-\<alpha\>> on a ball <math|\<b-alpha\>> with
  <math|\<alpha\>\<in\>\<b-alpha\>>. Let <math|\<b-sigma\>=f<rprime|'><around*|(|\<b-alpha\>|)>>
  be the ball evaluation of <math|f<rprime|'>> at<nbsp><math|\<b-alpha\>>.
  For all <math|z\<in\>\<b-alpha\>>, we then we have

  <\equation*>
    f<around*|(|z|)>=<big|int><rsub|\<alpha\>><rsup|z>f<rprime|'><around*|(|u|)>*\<mathd\>
    u\<subseteq\><big|int><rsub|\<alpha\>><rsup|z>\<b-sigma\>*\<mathd\>
    u\<subseteq\>\<b-sigma\>*<around*|(|z-\<alpha\>|)>.
  </equation*>

  Consequently, <math|<around*|(|f/<around*|(|z-\<alpha\>|)>|)><around*|(|\<b-alpha\>|)>\<subseteq\>f<rprime|'><around*|(|\<b-alpha\>|)>>.
  For general <math|g>, we obtain in a similar way that
  <math|<around*|(|g/<around*|(|z-\<alpha\>|)>|)><around*|(|\<b-alpha\>|)>\<subseteq\>g<rprime|'><around*|(|\<b-alpha\>|)>>.
  We conclude that

  <\eqnarray*>
    <tformat|<table|<row|<cell|<frac|f|g><around*|(|\<b-alpha\>|)>>|<cell|\<subseteq\>>|<cell|<frac|f<rprime|'>|g<rprime|'>><around*|(|\<b-alpha\>|)>.<eq-number><label|Hop-rule>>>>>
  </eqnarray*>

  <subsubsection|Higher multiplicities>

  It would be interesting to know whether there exist generalizations
  of<nbsp>(<reference|Hop-rule>) to higher multiplicities or involving the
  successive derivatives of <math|f/g>. In this section we will present
  a<nbsp>more <em|ad hoc> strategy for computing a reliable Taylor series
  expansion of <math|f/g> in the case when <math|f>, <math|g> and <math|f/g>
  are all analytic.

  Let <math|\<b-alpha\>> and <math|\<b-Alpha\>> be all small and a larger
  ball with the same center <math|c> and radii <math|\<varepsilon\>>
  and<nbsp><math|R>. Assume that <math|f> admits exactly <math|r> zeros
  <math|\<alpha\><rsub|1>,\<ldots\>,\<alpha\><rsub|r>> both on
  <math|\<b-alpha\>> and on <math|\<b-Alpha\>>. Let
  <math|g=<rigid|<around*|(|z-\<alpha\><rsub|1>|)>>*\<cdots\>*<rigid|<around*|(|z-\<alpha\><rsub|r>|)>>>
  and <math|h=f/g>. Writing <math|\<b-f\><rsub|i>=f<rsup|<around*|(|i|)>><around*|(|\<b-alpha\>|)>/i!>,
  <math|\<b-g\><rsub|i>=g<rsup|<around*|(|i|)>><around*|(|\<b-alpha\>|)>/i!>
  and <math|\<b-h\><rsub|i>=h<rsup|<around*|(|i|)>><around*|(|\<b-alpha\>|)>/i!>
  for each<nbsp><math|i>, we have

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-h\><rsub|i>>|<cell|\<subseteq\>>|<cell|\<b-f\><rsub|i>-<around*|(|\<b-h\><rsub|i+1>*\<b-g\><rsub|r-1>+\<cdots\>+\<b-h\><rsub|i+r>*\<b-g\><rsub|0>|)>.<eq-number><label|hi-bnd>>>>>
  </eqnarray*>

  Let <math|M> be an upper bound for <math|<around*|\||f<around*|(|\<b-Alpha\>|)>|\|>>.
  Since <math|h> achieves its maximum on <math|\<b-Alpha\>> at its border, we
  also have

  <\eqnarray*>
    <tformat|<table|<row|<cell|<around*|\||h<around*|(|\<b-Alpha\>|)>|\|>>|<cell|\<leqslant\>>|<cell|<frac|M|<around*|(|R-\<varepsilon\>|)><rsup|r>>.>>>>
  </eqnarray*>

  From Cauchy's formula, it follows that

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-h\><rsub|i>>|<cell|\<subseteq\>>|<cell|<frac|\<cal-B\><around*|(|0,M|)>|<around*|(|R-\<varepsilon\>|)><rsup|i+r>><eq-number><label|large-ball-bnd>>>>>
  </eqnarray*>

  for all <math|i>. Plugging this into<nbsp>(<reference|hi-bnd>), we obtain

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<b-h\><rsub|i>>|<cell|\<subseteq\>>|<cell|\<b-f\><rsub|i>+<frac|\<cal-B\><around*|(|0,M|)>|<around*|(|R-\<varepsilon\>|)><rsup|i+r>>*<around*|[|<frac|1|<around*|(|1-\<varepsilon\>/R|)><rsup|r>>-1|]>.<eq-number><label|small-ball-bnd>>>>>
  </eqnarray*>

  For the small balls, we may thus use<nbsp>(<reference|small-ball-bnd>) for
  the computation of an enclosure for <math|\<b-h\><rsub|i>>, and switch
  to<nbsp>(<reference|large-ball-bnd>) whenever this enclosure becomes
  better.

  <subsubsection|Recovering analytic functions from their values on a circle>

  More generally, it is in principle possible to recover any analytic
  function <math|f> on a closed disk <math|D> from its values on its boundary
  using Cauchy's formula. We will now describe an efficient method to do this
  effectively. When applied to computable meromorphic functions as above,
  this method has the advantage that we do not need to know the numerator and
  denominator explicitly; it is sufficient that we can compute its ball
  values on the boundary circle. Without loss of generally, we may assume
  that <math|D> is the unit disk.

  For a given number <math|N> of evaluation points (preferably a power of
  two) and with <math|\<delta\>=<around*|\||\<mathe\><rsup|\<mathpi\>*\<mathi\>/N>-1|\|>>,
  we evaluate <math|f> at the disks <math|\<b-omega\><rsub|k>=\<cal-B\><around*|(|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*k/N>,\<delta\>|)>>
  for <math|k\<in\><around*|{|0,\<ldots\>,N-1|}>>, yielding
  <math|\<b-v\><rsub|k>=f<around*|(|\<b-omega\><rsub|k>|)>=\<cal-B\><around*|(|v<rsub|k>,\<varepsilon\><rsub|k>|)>>.
  We next compute ball enclosures <math|\<b-P\><rsub|i>> for the coefficients
  of the unique polynomial <math|P> with <math|deg P\<less\>n> and
  <math|P<around*|(|\<mathe\><rsup|2*\<mathpi\>*\<mathi\>*k/N>|)>=v<rsub|k>>
  for all <math|k> using one reliable discrete Fourier transform. The
  remainder <math|R=f-P> is bounded by <math|\<varepsilon\>=max<rsub|k>
  \<varepsilon\><rsub|k>> on the unit circle, whence on the unit disk. This
  yields a Taylor model <math|\<b-P\>+\<cal-B\><rsub|D><around*|(|\<varepsilon\>|)>>
  for <math|f>. Taking <math|N> sufficiently large, the so computed Taylor
  model can be made as accurate as needed.

  <subsubsection|Multivariate meromorphic
  functions><label|mv-meromorphic-sec>

  Let us now consider a meromorphic function <math|f/g> in several variables
  <math|z<rsub|1>,\<ldots\>,z<rsub|n>> which is actually analytic on some
  small ball. Modulo a linear change of coordinates and shrinking the domain
  to a smaller ball <math|\<b-alpha\>>, we may first ensure that <math|g> has
  constant multiplicity in <math|z<rsub|n>> on <math|\<b-alpha\>>. We may
  then use any of the methods from the previous section for computing
  <math|f/g> as an analytic function in <math|z<rsub|n>>, which depends
  analytically on the parameters <math|z<rsub|1>,\<ldots\>,z<rsub|n-1>>.

  <section|Certification of multiple multivariate
  roots><label|multiple-cert-sec>

  <subsection|Jacobians of corank one>

  Consider a system<nbsp>(<reference|pol-sys>) and assume that we have
  numerically isolated a solution <math|\<alpha\>> of multiplicity <math|r>.
  Based on numerical computations, assume also that the Jacobian
  <math|J=\<partial\> P/\<partial\> z> is expected to have corank at most one
  at <math|\<alpha\>>.

  In a small ball <math|\<b-alpha\>> around <math|\<alpha\>> (and where we
  recall that <math|\<b-alpha\>> is really a polydisk) we may certify the
  corank assumption by computing <math|J<around*|(|\<b-alpha\>|)>> using ball
  arithmetic and then checking that an <math|<around*|(|n-1|)>\<times\><around*|(|n-1|)>>
  submatrix admits a non zero determinant (still using ball arithmetic).

  At the next stage, we would like to certify that there exist indeed exactly
  <math|r> solutions in a suitable neighbourhood of <math|\<alpha\>>, when
  counted with multiplicities. Now using our effective version of the
  implicit function theorem from section<nbsp><reference|impl-th-sec>, we may
  analytically eliminate at least <math|n-1> variables from the
  equations<nbsp>(<reference|pol-sys>), say
  <math|z<rsub|2>,\<ldots\>,z<rsub|n>> from the equations
  <math|P<rsub|2><around*|(|z|)>=\<cdots\>=P<rsub|n><around*|(|z|)>=0>. This
  yields computable analytic functions <math|\<Phi\><rsub|2><around*|(|z<rsub|1>|)>,\<ldots\>,\<Phi\><rsub|n><around*|(|z<rsub|1>|)>>
  such that

  <\eqnarray*>
    <tformat|<table|<row|<cell|P<rsub|i><around*|(|z<rsub|1>,\<Phi\><rsub|2><around*|(|z<rsub|1>|)>,\<ldots\>,\<Phi\><rsub|n><around*|(|z<rsub|1>|)>|)>>|<cell|=>|<cell|0>>>>
  </eqnarray*>

  for all <math|i\<in\><around*|{|2,\<ldots\>,n|}>>. We next compute the
  computable analytic function

  <\eqnarray*>
    <tformat|<table|<row|<cell|R<around*|(|z<rsub|1>|)>>|<cell|=>|<cell|P<rsub|1><around*|(|z<rsub|1>,\<Phi\><rsub|2><around*|(|z<rsub|1>|)>,\<ldots\>,\<Phi\><rsub|n><around*|(|z<rsub|1>|)>|)>.>>>>
  </eqnarray*>

  Using the techniques from section<nbsp><reference|an-mult-sec>, we finally
  check that <math|R> has multiplicity <math|r> in a<nbsp>suitable
  neighbourhood <math|\<b-alpha\><rsub|1>> of <math|\<alpha\><rsub|1>>.

  <\remark>
    One of the simplest examples when the corank one hypothesis fails is the
    following system:

    <\eqnarray*>
      <tformat|<table|<row|<cell|z<rsub|1><rsup|2>>|<cell|=>|<cell|0>>|<row|<cell|z<rsub|2><rsup|2>>|<cell|=>|<cell|0.>>>>
    </eqnarray*>
  </remark>

  <subsection|Certification of herd homotopies><label|herd-cert-sec>

  Let us still consider the system<nbsp>(<reference|pol-sys>) and assume that
  we are given a herd of numeric solution paths
  <math|z<rsup|1><rsub|t>,\<ldots\>,z<rsup|r><rsub|t>> which all tend to the
  same limit <math|\<alpha\>>. In this section, we will investigate the
  problem of simultaneously certifying each of the paths in the herd.

  We would like the follow the same strategy as in
  section<nbsp><reference|factor-cert-sec>, where we certified a single
  factor of order <math|r> instead of <math|r> separate roots. In the current
  setting, instead of viewing the <math|z<rsup|i><rsub|t>> as distinct
  individual paths, this amounts to regarding the whole herd
  <math|t\<mapsto\>\<cal-Z\><rsub|t>=<rigid|<around|{|z<rsup|1><rsub|t>,\<ldots\>,z<rsup|r><rsub|t>|}>>>
  as a single multivalued path. From the algebraic point of view, this means
  that we need to consider the ideal <math|\<frak-I\><rsub|t>> which
  annihilates <math|\<cal-Z\><rsub|t>>. There are several ways to represent
  this ideal<nbsp><math|\<frak-I\><rsub|t>> by a system
  <math|\<Sigma\><rsub|t>> of polynomial equations. We will use so called
  univariate representations.

  Now recall that each <math|z<rsup|i><rsub|t>> can be considered as a vector
  <math|z<rsup|i><rsub|t>=<around|(|z<rsup|i><rsub|t,1>,\<ldots\>,z<rsup|i><rsub|t,n>|)>>
  of Puiseux series<nbsp><math|z<rsup|i><rsub|t,j>> in <math|t> of valuations
  <math|\<geqslant\>0>. Setting

  <\eqnarray*>
    <tformat|<table|<row|<cell|A<rsub|t><around|(|z<rsub|1>|)>>|<cell|=>|<cell|<around|(|z<rsub|1>-z<rsup|1><rsub|t,1>|)>*\<cdots\>*<around|(|z<rsub|1>-z<rsup|r><rsub|t,1>|)>,>>>>
  </eqnarray*>

  we notice that <math|A<rsub|t><around|(|z<rsub|1>|)>> is invariant if we
  turn <math|t> once around the origin. This means
  that<nbsp><math|A<rsub|t><around|(|z<rsub|1>|)>> is really an analytic
  function in <math|t> at the origin. Assuming general position,
  <math|A<rsub|t><around|(|z<rsub|1>|)>> is actually the minimal annihilator
  of <math|<around|{|z<rsup|1><rsub|t,1>,\<ldots\>,z<rsup|r><rsub|t,1>|}>>.
  Furthermore, for <math|t\<neq\>0> sufficiently small, the roots
  <math|z<rsup|i><rsub|t,1>> are pairwise distinct, so there are unique
  interpolating polynomials <math|U<rsub|t,2>,\<ldots\>,U<rsub|t,n>\<in\>\<bbb-C\><around*|[|u|]>>
  of degree <math|\<less\>r> with

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsub|t,i>>|<cell|=>|<cell|U<rsub|t,i><around*|(|z<rsub|t,1>|)>>>>>
  </eqnarray*>

  for all <math|i\<in\><around*|{|2,\<ldots\>,n|}>>. In what follows, we will
  represent <math|\<frak-I\><rsub|t>> by the system of polynomials

  <\eqnarray*>
    <tformat|<table|<row|<cell|>|<cell|>|<cell|<choice|<tformat|<table|<row|<cell|A<rsub|t><around|(|z<rsub|t,1>|)>>>|<row|<cell|z<rsub|t,2>-U<rsub|t,2><around|(|z<rsub|t,1>|)>>>|<row|<cell|\<vdots\>>>|<row|<cell|z<rsub|t,n>-U<rsub|t,n><around|(|z<rsub|t,1>|)>,>>>>><eq-number><label|ideal-repr>>>>>
  </eqnarray*>

  where <math|A<rsub|t>> is monomic of degree <math|r> and <math|deg
  U<rsub|t,i>\<less\>r> for each <math|i>.

  Solving the original system <math|\<Sigma\>> for
  <math|z<rsub|1>,\<ldots\>,z<rsub|n>> of this form now amounts to a new
  system <math|<wide|\<Sigma\>|~>> of <math|n*r> equations in the unknowns
  <math|<around*|(|A<rsub|t>|)><rsub|j>> and
  <math|<around*|(|U<rsub|t,i>|)><rsub|j>>. This system can also be
  considered as a system of <math|n> equations in <math|n> unknowns
  <math|z<rsub|1>,\<ldots\>,z<rsub|n>> over the algebra
  <math|\<bbb-A\>=\<bbb-C\><around|[|u|]>/<around|(|A<rsub|t><around|(|u|)>|)>>,
  augmented with one special unknown <math|u<rsup|r>> and one special
  equation <math|z<rsub|1>=u>. In analogy with
  Theorem<nbsp><reference|local-fact-th>, we may hope that this new system is
  non singular near <math|t=0>, so that we can certify the herd using
  Corollary<nbsp><reference|New-uniqueness-cor>. It can be checked that this
  is always so in the corank one case from the previous section.
  Unfortunately, Theorem<nbsp><reference|local-fact-th> fails to generalize
  in general. In particular, the new system remains singular whenever several
  herds converge to the same singularity.

  <subsection|Equisolvability>

  Let us now return to the general case when the corank of the Jacobian
  matrix at the solution may be larger than one. First of all, it will be
  useful to generalize the notion of equisolvability from
  section<nbsp><reference|an-mult-sec> to the case of several equations.
  Consider the system

  <\equation>
    P<rsub|k><around*|(|z|)>=\<cdots\>=P<rsub|n><around*|(|z|)>=0<label|eqsol-sys>
  </equation>

  on <math|\<b-alpha\>\<in\><bC><rsup|n>>, where
  <math|P<rsub|k>,\<ldots\>,P<rsub|n>> might actually be analytic functions
  instead of mere polynomials. We say that<nbsp>(<reference|eqsol-sys>) is
  <em|equisolvable> in <math|z<rsub|k>,\<ldots\>,z<rsub|n>> on
  <math|\<b-alpha\>> if the zero set

  <\equation>
    <label|Z-def>\<cal-Z\>=\<cal-V\><rsub|\<b-alpha\>><around*|(|P<rsub|\<geqslant\>k>|)>=<around*|{|z\<in\>\<b-alpha\>:P<rsub|k><around*|(|z|)>=\<cdots\>=P<rsub|n><around*|(|z|)>=0|}>
  </equation>

  does not intersect <math|\<b-alpha\><rsub|\<less\>k>\<times\>\<partial\>
  \<b-alpha\><rsub|\<geqslant\>k>>, where
  <math|\<b-alpha\><rsub|\<less\>k>=\<b-alpha\><rsub|1>\<times\>\<cdots\>\<times\>\<b-alpha\><rsub|k-1>>
  and <math|\<b-alpha\><rsub|\<geqslant\>k>=\<b-alpha\><rsub|k>\<times\>\<cdots\>\<times\>\<b-alpha\><rsub|n>>.
  In particular, this means that the number of solutions
  <math|<around*|(|z<rsub|k>,\<ldots\>,z<rsub|n>|)>\<in\>\<b-alpha\><rsub|\<geqslant\>k>>
  of<nbsp>(<reference|eqsol-sys>) as a function of
  <math|<around*|(|z<rsub|1>,\<ldots\>,z<rsub|k-1>|)>\<in\>\<b-alpha\><rsub|\<less\>k>>
  does not depend on <math|z<rsub|1>,\<ldots\>,z<rsub|k-1>>. Furthermore, the
  following lemma shows that there are no exceptional fibers with an infinite
  number of solutions.

  <\lemma>
    <label|equisolv-comp-lem>Assume that <with|font-family|normal|(<reference|eqsol-sys>)>
    is equisolvable in <math|z<rsub|\<geqslant\>k>> on <math|\<b-alpha\>> and
    that <math|\<cal-X\>\<subseteq\>\<b-alpha\><rsub|\<less\>k>> is the zero
    set of a non zero analytic function on
    <math|\<b-alpha\><rsub|\<less\>k>>. Then none of the components of
    <math|\<cal-Z\>> can be contained entirely in the set
    <math|\<cal-X\>\<times\>\<b-alpha\><rsub|\<geqslant\>k>>.
  </lemma>

  <\proof>
    Assume for contradiction that <math|<around*|(|\<cal-X\>\<times\>\<b-alpha\><rsub|\<geqslant\>k>|)>\<cap\>\<cal-Z\>>
    has dimension <math|\<geqslant\>k-1>. Taking <math|u\<in\>\<cal-X\>>, the
    intersection <math|<around*|(|<around*|{|u|}>\<times\>\<b-alpha\><rsub|\<geqslant\>k>|)>\<cap\>\<cal-Z\>>
    has dimension <math|\<geqslant\>1>, whence it contains an analytic
    solution curve <math|t\<mapsto\>\<varphi\><around*|(|t|)>=<around*|(|u,\<varphi\><rsub|k><around*|(|t|)>,\<ldots\>,\<varphi\><rsub|n><around*|(|t|)>|)>\<in\>\<cal-Z\>>
    whose image has dimension one. Since<nbsp>(<reference|eqsol-sys>) is
    equisolvable in <math|z<rsub|\<geqslant\>k>> on <math|\<b-alpha\>>, the
    curve <math|<around*|(|\<varphi\><rsub|k><around*|(|t|)>,\<ldots\>,\<varphi\><rsub|n><around*|(|t|)>|)>>
    is entirely contained in <math|\<b-alpha\><rsub|\<geqslant\>k>\<setminus\>\<partial\>
    \<b-alpha\><rsub|\<geqslant\>k>>. Consequently, the analytic functions
    <math|\<varphi\><rsub|i><around*|(|t|)>> are all bounded, whence
    constant. This contradicts our assumption that <math|im \<varphi\>> has
    dimension one.
  </proof>

  <\example>
    <label|equisol-ex>The equation

    <\eqnarray*>
      <tformat|<table|<row|<cell|P<around*|(|x,y|)>=4*y<rsup|2>-x>|<cell|=>|<cell|0>>>>
    </eqnarray*>

    is equisolvable in <math|y> on <math|\<cal-B\><around*|(|0,1|)><rsup|2>>,
    since there are always two solutions, but

    <\eqnarray*>
      <tformat|<table|<row|<cell|Q<around*|(|x,y|)>=y-2*x>|<cell|=>|<cell|0>>>>
    </eqnarray*>

    is not equisolvable, since the equation has one solution for <math|x=0>,
    but no solutions for <math|x=1>. Of course, <math|Q> is equisolvable on
    <math|\<cal-B\><around*|(|0,1|)><rsup|2>> for <math|y> on a larger disk
    (or <math|x> on a smaller disk). Graphically speaking, an equation
    <math|P<around*|(|x,y|)>=0> is equisolvable if and only if all solution
    curves <math|y<around*|(|x|)>> are ``nicely horizontal'' in
    <math|\<cal-B\><around*|(|0,1|)><rsup|2>>.
  </example>

  <subsection|Kronecker representations>

  With the notations from the previous section, consider polynomials

  <\eqnarray*>
    <tformat|<table|<row|<cell|Q>|<cell|=>|<cell|z<rsub|k><rsup|d>+Q<rsub|k-1>*z<rsub|k><rsup|d-1>+\<cdots\>+Q<rsub|0>>>|<row|<cell|V<rsub|i>>|<cell|=>|<cell|V<rsub|i,d-1>*z<rsub|k><rsup|d-1>+\<cdots\>+V<rsub|i,0>,<space|2em>i\<gtr\>k,>>>>
  </eqnarray*>

  where the coefficients <math|Q<rsub|j>> and <math|V<rsub|i,j>> are
  computable analytic functions in <math|z<rsub|1>,\<ldots\>,z<rsub|k-1>> on
  <math|\<b-alpha\><rsub|\<less\>k>>, such that
  <math|Res<rsub|z<rsub|k>><around*|(|Q,Q<rprime|'>|)>\<neq\>0> (with
  <math|Q<rprime|'>=\<partial\> Q/\<partial\> z<rsub|k>>) and the
  system<nbsp>(<reference|eqsol-sys>) is equivalent to

  <\equation>
    <label|Kronecker-repr><choice|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<table|<row|<cell|Q<around*|(|z<rsub|\<leqslant\>k>|)>>|<cell|=>|<cell|0>>|<row|<cell|Q<rprime|'><around*|(|z<rsub|\<leqslant\>k>|)>*z<rsub|i>>|<cell|=>|<cell|V<rsub|i><around*|(|z<rsub|\<leqslant\>k>|)>,<space|1em>i\<gtr\>k,>>>>>
  </equation>

  for all <math|z\<in\>\<b-alpha\>\<setminus\><around*|(|\<cal-X\>\<times\>\<b-alpha\><rsub|\<geqslant\>k>|)>>,
  where <math|\<cal-X\>=\<cal-V\><rsub|\<b-alpha\><rsub|\<less\>k>><around*|(|Res<rsub|z<rsub|k>><around*|(|Q,Q<rprime|'>|)>|)>>.
  Then we call<nbsp>(<reference|Kronecker-repr>) the <em|Kronecker
  representation> for<nbsp>(<reference|eqsol-sys>) on <math|\<b-alpha\>>.

  <\lemma>
    <label|zerodim-Kronecker-lem>Assume that the system
    <math|P<rsub|1><around*|(|z|)>=\<cdots\>=P<rsub|n><around*|(|z|)>=0>
    admits a finite number of solutions in <math|\<b-alpha\>> and that the
    <math|z<rsub|1>>-coordinates of these solutions are pairwise distinct.
    Then there exists a Kronecker representation for
    <math|P<rsub|1><around*|(|z|)>=\<cdots\>=P<rsub|n><around*|(|z|)>=0> on
    <math|\<b-alpha\>>.
  </lemma>

  <\proof>
    Let <rigid|<math|z<rsup|1>,\<ldots\>,z<rsup|k>\<in\>\<bbb-C\><rsup|n>>>
    be such that <math|z<rsup|1><rsub|1>,\<ldots\>,z<rsup|k><rsub|1>> are
    pairwise distinct. Then we define the Kronecker representation for
    <math|\<cal-Z\>=<around|{|z<rsup|1>,\<ldots\>,z<rsup|k>|}>> to be the
    unique <math|n>-tuple <math|<around|(|Q,V<rsub|2>,\<ldots\>,V<rsub|n>|)>=\<Kappa\><rsup|\<cal-Z\>>=<rigid|<around|(|Q<rsup|\<cal-Z\>>,V<rsub|2><rsup|\<cal-Z\>>,\<ldots\>,V<rsub|n><rsup|\<cal-Z\>>|)>>>
    of univariate polynomials with <math|deg Q=k>, <math|Q<rsub|k>=1>,
    <math|deg V<rsub|2>\<less\>k,\<ldots\>,deg V<rsub|n>\<less\>k>, such
    that<nbsp><math|\<cal-Z\>> is annihilated by the system

    <\eqnarray*>
      <tformat|<table|<row|<cell|Q<around|(|z<rsub|1>|)>>|<cell|=>|<cell|0>>|<row|<cell|Q<rprime|'><around|(|z<rsub|1>|)>*z<rsub|2>>|<cell|=>|<cell|V<rsub|2><around|(|z<rsub|1>|)>>>|<row|<cell|>|<cell|\<vdots\>>|<cell|>>|<row|<cell|Q<rprime|'><around|(|z<rsub|1>|)>*z<rsub|n>>|<cell|=>|<cell|V<rsub|n><around|(|z<rsub|1>|)>.>>>>
    </eqnarray*>

    We may compute such a Kronecker representation as follows. If <math|k=1>,
    then we simply take <math|Q<around*|(|z<rsub|1>|)>=z<rsub|1>-z<rsup|1><rsub|1>>
    and <math|V<rsub|i>=z<rsup|1><rsub|i>> for all <math|i\<gtr\>1>. For
    <math|k\<gtr\>1>, we decompose <math|\<cal-Z\>=\<cal-X\>\<amalg\>\<cal-Y\>>
    with <math|<around*|\||\<cal-X\>|\|>=<around*|\<lfloor\>|<around*|\||\<cal-Z\>|\|>/2|\<rfloor\>>>
    and compute <math|\<Kappa\><rsup|\<cal-Z\>>> in terms of
    <math|\<Kappa\><rsup|\<cal-X\>>> and <math|\<Kappa\><rsup|\<cal-Y\>>>
    using

    <\eqnarray*>
      <tformat|<table|<row|<cell|Q<rsup|\<cal-Z\>>>|<cell|=>|<cell|Q<rsup|\<cal-X\>>*Q<rsup|\<cal-Y\>>>>|<row|<cell|V<rsub|i><rsup|\<cal-Z\>>>|<cell|=>|<cell|V<rsub|i><rsup|\<cal-X\>>*Q<rsup|\<cal-Y\>>+Q<rsup|\<cal-X\>>*V<rsub|i><rsup|\<cal-Y\>>,<space|1em>i\<gtr\>1.>>>>
    </eqnarray*>

    This yields an efficient dichotomic algorithm for the computation of
    <math|\<Kappa\><rsup|\<cal-Z\>>>. The result follows by applying the
    method to the solutions of <math|P<rsub|1><around*|(|z|)>=\<cdots\>=P<rsub|n><around*|(|z|)>=0>
    in <math|\<b-alpha\>>.
  </proof>

  <\theorem>
    <label|Kron-thm>Assume that<nbsp><with|font-family|normal|(<reference|eqsol-sys>)>
    is equisolvable in <math|z<rsub|\<geqslant\>k>> on <math|\<b-alpha\>>.
    For the zeroset <math|\<cal-X\>> of some non zero analytic function on
    <math|\<b-alpha\><rsub|\<less\>k>>, assume that for any
    <math|u\<in\>\<cal-U\>\<assign\>\<b-alpha\><rsub|\<less\>k>\<setminus\>\<cal-X\>>,
    the solutions of<nbsp><with|font-family|normal|(<reference|eqsol-sys>)>
    with <math|z<rsub|\<less\>k>=u> admit pairwise distinct
    <math|z<rsub|k>>-coordinates. Then there exists a Kronecker
    representation for<nbsp><with|font-family|normal|(<reference|eqsol-sys>)>.
  </theorem>

  <\proof>
    For any <math|u\<in\>\<cal-U\>>, the above lemma yields a Kronecker
    representation

    <\eqnarray*>
      <tformat|<table|<row|<cell|Q<around*|(|u,z<rsub|k>|)>>|<cell|=>|<cell|0>>|<row|<cell|Q<rprime|'><around*|(|u,z<rsub|k>|)>*z<rsub|i>>|<cell|=>|<cell|V<rsub|i><around*|(|u,z<rsub|k>|)>,<space|1em>i\<gtr\>k>>>>
    </eqnarray*>

    for the system (<reference|eqsol-sys>) with <math|z<rsub|\<less\>k>=u>.
    Moreover, the equisolvability assumption implies that the
    degree<nbsp><math|d> of <math|Q<rsup|u>> does not depend on <math|u>.
    Furthermore, since <math|Q<rprime|'><around*|(|u,z<rsub|k>|)>\<neq\>0>
    for <math|u\<in\>\<cal-U\>>, the way we compute the functions
    <math|Q,V<rsub|k+1>,\<ldots\>,V<rsub|n>> depends analytically on
    <math|u>. We thus obtain a ``Kronecker representation''
    for<nbsp>(<reference|eqsol-sys>) on the subset
    <math|\<cal-U\>\<times\>\<b-alpha\><rsub|\<geqslant\>k>> instead of
    <math|\<b-alpha\>>.

    Let <math|M\<gtr\>0> be such that <math|<around*|\||\<b-alpha\><rsub|k>|\|>\<leqslant\>M>.
    Expanding <math|Q<around*|(|u,z<rsub|k>|)>=z<rsub|k><rsup|d>+Q<rsub|d-1><around*|(|u|)>*z<rsub|k><rsup|d-1>+\<cdots\>+Q<rsub|0><around*|(|u|)>>
    and <math|<around*|(|z<rsub|k>-M|)><rsup|d>=z<rsub|k><rsup|d>+<wide|Q|\<bar\>><rsub|d-1>*z<rsub|k><rsup|d-1>+\<cdots\>+<wide|Q|\<bar\>><rsub|0>>
    with <math|<wide|Q|\<bar\>><rsub|i>=M<rsup|d-i>*<binom|d|i>>, we have
    <math|<around*|\||Q<rsub|i><around*|(|u|)>|\|>\<leqslant\><wide|Q|\<bar\>><rsub|i>>
    for all <math|u\<in\>\<cal-U\>>. Consequently,
    <math|Q<around*|(|u,z<rsub|k>|)>> remains bounded on
    <math|\<cal-U\>\<times\>\<b-alpha\><rsub|k>>. Since <math|\<cal-X\>> is a
    removable isolated singularity, it follows that
    <math|Q<around*|(|u,z<rsub|k>|)>> admits a unique analytic continuation
    on <math|\<cal-U\>>. It also follows that we may also choose
    <math|\<cal-X\>> to be the zero set of
    <math|Res<rsub|z<rsub|k>><around*|(|Q,Q<rprime|'>|)>>.

    It remains to be shown that the <math|V<rsub|i>> with <math|i\<gtr\>k>
    can also extended analytically from <math|\<cal-U\>\<times\>\<b-alpha\><rsub|k>>
    to <math|\<b-alpha\><rsub|\<leqslant\>k>>. For this, we consider a new
    coordinate <math|z<rsup|\<lambda\>><rsub|k>=z<rsub|k>+\<lambda\><rsub|k+1>*z<rsub|k+1>+\<cdots\>+\<lambda\><rsub|n>*z<rsub|n>>
    where <math|\<lambda\><rsub|k+1>,\<ldots\>,\<lambda\><rsub|n>> are
    parameters. For <math|<around*|(|\<lambda\><rsub|k+1>,\<ldots\>,\<lambda\><rsub|n>|)>>
    sufficiently close to <math|<around*|(|0,\<ldots\>,0|)>>, we may apply
    the above result to the system <math|P<rsub|k><around*|(|z|)>=\<cdots\>=P<rsub|n><around*|(|z|)>>
    rewritten as equations <math|P<rsup|\<lambda\>><rsub|k><around*|(|z<rsup|\<lambda\>>|)>=\<cdots\>=P<rsup|\<lambda\>><rsub|n><around*|(|z<rsup|\<lambda\>>|)>>
    in <math|z<rsup|\<lambda\>>=<around*|(|z<rsub|\<less\>k>,z<rsup|\<lambda\>><rsub|k>,z<rsub|\<gtr\>k>|)>>.
    Notice that this new system is defined on a<nbsp>domain
    <math|\<b-alpha\><rsup|\<lambda\>>> which is slightly smaller than
    <math|\<b-alpha\>>. We thus obtain a Kronecker representation

    <\eqnarray*>
      <tformat|<cwith|1|2|1|1|cell-halign|r>|<table|<row|<cell|Q<rsup|\<lambda\>><around*|(|z<rsup|\<lambda\>><rsub|\<leqslant\>k>|)>>|<cell|=>|<cell|0>>|<row|<cell|<around*|(|Q<rsup|\<lambda\>>|)><rprime|'><around*|(|z<rsup|\<lambda\>><rsub|\<leqslant\>k>|)>*z<rsub|i>>|<cell|=>|<cell|V<rsup|\<lambda\>><rsub|i><around*|(|z<rsup|\<lambda\>><rsub|\<leqslant\>k>|)>,<space|1em>i\<gtr\>k,>>>>
    </eqnarray*>

    which is equivalent to <math|P<rsup|\<lambda\>><rsub|k><around*|(|z<rsup|\<lambda\>>|)>=\<cdots\>=P<rsup|\<lambda\>><rsub|n><around*|(|z<rsup|\<lambda\>>|)>>
    for <math|z<rsup|\<lambda\>>> with <math|R<rsup|\<lambda\>><around*|(|z<rsup|\<lambda\>><rsub|\<less\>k>|)>\<neq\>0>,
    where <math|R<rsup|\<lambda\>>=Res<rsub|z<rsup|\<lambda\>><rsub|k>><around*|(|Q<rsup|\<lambda\>>,<around*|(|Q<rsup|\<lambda\>>|)><rprime|'>|)>>.
    The function <math|Q<rsup|\<lambda\>>> is defined on
    <math|\<b-alpha\><rsup|\<lambda\>>> and analytic both in
    <math|\<lambda\>> and <math|z<rsup|\<lambda\>>>. Differentiating the
    equation <math|Q<rsup|\<lambda\>><around*|(|z<rsup|\<lambda\>><rsub|\<leqslant\>k>|)>=0>
    with respect to <math|\<lambda\><rsub|i>> with <math|i\<gtr\>k>, we
    obtain

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|(|Q<rsup|\<lambda\>>|)><rprime|'><around*|(|z<rsup|\<lambda\>><rsub|\<leqslant\>k>|)>*z<rsub|i>>|<cell|=>|<cell|-<frac|\<partial\>
      Q<rsup|\<lambda\>>|\<partial\> \<lambda\><rsub|i>><around*|(|z<rsup|\<lambda\>><rsub|\<leqslant\>k>|)>.>>>>
    </eqnarray*>

    Letting <math|\<lambda\>> tend to <math|0>, we obtain that
    <math|V<rsub|i><around*|(|z<rsub|\<leqslant\>k>|)>=-<around*|(|\<partial\>
    Q<rsup|0>/\<partial\> \<lambda\><rsub|i>|)><around*|(|z<rsub|\<leqslant\>k>|)>>.
  </proof>

  <\proposition>
    <label|equisolvability-prop>Assume that
    <math|P<rsub|k+1><around*|(|z|)>=\<cdots\>=P<rsub|n><around*|(|z|)>> is
    equisolvable in <math|z<rsub|\<gtr\>k>> on <math|\<b-alpha\>>. Assume
    that we are given a Kronecker representation<nbsp><with|font-family|normal|(<reference|Kronecker-repr>)>
    for<nbsp><with|font-family|normal|(<reference|eqsol-sys>)> such that
    <math|Q<around*|(|z<rsub|\<leqslant\>k>|)>=0> is equisolvable in
    <math|z<rsub|k>> on <math|\<b-alpha\><rsub|\<leqslant\>k>> and such that
    <math|Q> vanishes on <math|\<cal-V\><rsub|\<b-alpha\>><around*|(|P<rsub|\<gtr\>k>|)>>.
    Then<nbsp><with|font-family|normal|(<reference|eqsol-sys>)> is
    equisolvable in<nbsp><math|z<rsub|\<geqslant\>k>> on <math|\<b-alpha\>>.
  </proposition>

  <\proof>
    Assume for contradiction that <math|z\<in\>\<cal-Z\>\<cap\>\<b-alpha\><rsub|\<less\>k>\<times\>\<partial\>
    \<b-alpha\><rsub|\<geqslant\>k>>. Since
    <math|P<rsub|k+1><around*|(|z|)>=\<cdots\>=P<rsub|n><around*|(|z|)>=0> is
    equisolvable in <math|z<rsub|k+1>,\<ldots\>,z<rsub|n>> on
    <math|\<b-alpha\>>, we cannot have <math|z\<in\>\<cal-Z\>\<cap\>\<b-alpha\><rsub|\<leqslant\>k>\<times\>\<partial\>
    \<b-alpha\><rsub|\<gtr\>k>>. Consequently,
    <math|z\<in\>\<b-alpha\><rsub|\<less\>k>\<times\>\<partial\>
    \<b-alpha\><rsub|k>\<times\>\<b-alpha\><rsub|\<gtr\>k>>. Hence, we both
    have <math|Q<around*|(|z<rsub|\<leqslant\>k>|)>=0> and
    <math|z<rsub|\<leqslant\>k>\<in\>\<b-alpha\><rsub|\<less\>k>\<times\>\<partial\>
    \<b-alpha\><rsub|k>>. This contradicts the assumption that <math|Q> is
    equisolvable in <math|z<rsub|k>> on <math|\<b-alpha\><rsub|\<leqslant\>k>>.
  </proof>

  <subsection|Univariate representations><label|univ-repr-sec>

  The <em|univariate representation> is a variant of the Kronecker
  representation. It consists of polynomials

  <\eqnarray*>
    <tformat|<table|<row|<cell|Q>|<cell|=>|<cell|z<rsub|k><rsup|d>+Q<rsub|k-1>*z<rsub|k><rsup|d-1>+\<cdots\>+Q<rsub|0>>>|<row|<cell|U<rsub|i>>|<cell|=>|<cell|U<rsub|i,d-1>*z<rsub|k><rsup|d-1>+\<cdots\>+U<rsub|i,0>,<space|2em>i\<gtr\>k,>>>>
  </eqnarray*>

  such that the coefficients <math|Q<rsub|j>> are computable analytic
  functions in <math|z<rsub|\<less\>k>> on
  <math|\<b-alpha\><rsub|\<less\>k>>, the coefficients <math|V<rsub|i,j>> are
  computable meromorphic functions in <math|z<rsub|\<less\>k>> which are
  analytic on <math|\<b-alpha\><rsub|\<less\>k>\<setminus\>\<cal-X\>>, where
  <math|\<cal-X\>=\<cal-V\><rsub|\<b-alpha\><rsub|\<less\>k>><around*|(|Res<rsub|z<rsub|k>><around*|(|Q,Q<rprime|'>|)>|)>>
  and <math|Res<rsub|z<rsub|k>><around*|(|Q,Q<rprime|'>|)>\<neq\>0>. Finally,
  the system<nbsp>(<reference|eqsol-sys>) is assumed to be equivalent to

  <\equation>
    <label|univ-repr><choice|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<table|<row|<cell|Q<around*|(|z<rsub|\<leqslant\>k>|)>>|<cell|=>|<cell|0>>|<row|<cell|z<rsub|i>>|<cell|=>|<cell|U<rsub|i><around*|(|z<rsub|\<leqslant\>k>|)>,<space|1em>i\<gtr\>k,>>>>>
  </equation>

  for all <math|z\<in\>\<b-alpha\>\<setminus\><around*|(|\<cal-X\>\<times\>\<b-alpha\><rsub|\<geqslant\>k>|)>>.
  Given a Kronecker representation, we may compute a univariate
  representation as follows. We first compute the inverse
  <math|I=I<rsub|d-1>*z<rsub|k><rsup|d-1>+\<cdots\>+I<rsub|0>> of
  <math|Q<rprime|'>> modulo<nbsp><math|Q>, whose coefficients are meromorphic
  and analytic on <math|\<cal-U\>=\<b-alpha\><rsub|\<less\>k>\<setminus\>\<cal-X\>>.
  Taking <math|U<rsub|i>=I*V<rsub|i> mod Q>, we may then retrieve the
  univariate representation from the Kronecker representation.

  <subsection|Intersection with a new equation><label|intersect-sec>

  Given a Kronecker representation satisfying the hypothesis of
  Proposition<nbsp><reference|equisolvability-prop>, let us now study the
  intersection problem with a new equation
  <math|P<rsub|k-1><around*|(|z|)>=0>. We first compute a<nbsp>univariate
  representation for<nbsp>(<reference|eqsol-sys>), as detailed in
  section<nbsp><reference|univ-repr-sec>. Now consider the resultant

  <\eqnarray*>
    <tformat|<table|<row|<cell|R<around*|(|z<rsub|\<less\>k>|)>>|<cell|=>|<cell|Res<rsub|z<rsub|k>><around*|(|Q<around*|(|z<rsub|\<leqslant\>k>|)>,P<rsub|k-1><around*|(|z<rsub|\<leqslant\>k>,U<rsub|\<gtr\>k><around*|(|z<rsub|\<leqslant\>k>|)>|)>|)>.>>>>
  </eqnarray*>

  In practice, we may compute <math|R> by evaluating <math|P<rsub|k-1>> at
  <math|<around*|(|z<rsub|\<leqslant\>k>,U<rsub|\<gtr\>k><around*|(|z<rsub|\<leqslant\>k>|)>|)>>
  in the algebra <math|\<bbb-B\>=\<bbb-A\><around*|[|z<rsub|k>|]>/<around*|(|Q|)>>
  where <math|\<bbb-A\>> is the set of computable analytic functions on
  <math|\<cal-U\>>, and then take the norm of this evaluation. Let
  <math|\<phi\><rsub|1><around*|(|z<rsub|\<less\>k>|)>,\<ldots\>,\<phi\><rsub|d><around*|(|z<rsub|\<less\>k>|)>>
  denote the solutions of<nbsp>(<reference|eqsol-sys>) in
  <math|z<rsub|\<geqslant\>k>> as a<nbsp>function of
  <math|z<rsub|\<less\>k>>, considered as analytic functions in
  <math|z<rsub|\<less\>k>> on some Riemann surface
  above<nbsp><math|\<cal-U\>>. By a<nbsp>classical property of resultants, we
  have

  <\eqnarray*>
    <tformat|<table|<row|<cell|R<around*|(|z<rsub|\<less\>k>|)>>|<cell|=>|<cell|<big|prod><rsub|i=1><rsup|d>P<rsub|k-1><around*|(|z<rsub|\<less\>k>,\<phi\><rsub|i><around*|(|z<rsub|\<less\>k>|)>|)><eq-number><label|Res-eval-formula>>>>>
  </eqnarray*>

  on <math|\<cal-U\>>. Whereas the functions
  <math|\<phi\><rsub|i><around*|(|z<rsub|\<less\>k>|)>> generally admit a non
  trivial monodromy, the value of <math|R<around*|(|z<rsub|\<less\>k>|)>> is
  uniquely determined as a function on <math|z<rsub|\<less\>k>> on
  <math|\<cal-U\>>. Moreover, since <math|\<phi\><rsub|i><around*|(|z<rsub|\<less\>k>|)>\<in\>\<b-alpha\><rsub|\<geqslant\>k>>
  for <math|z<rsub|\<less\>k>\<in\>\<b-alpha\><rsub|\<less\>k>>, the analytic
  function <math|R> is bounded on <math|\<cal-U\>>. Since the complement
  <math|\<cal-X\>> of <math|\<cal-U\>> in<nbsp><math|\<b-alpha\><rsub|\<less\>k>>
  is isolated, this means that <math|R> extends uniquely into an analytic
  function on <math|\<b-alpha\><rsub|\<less\>k>>.

  <\lemma>
    <label|resultant-vanish-lem>Given a Kronecker
    representation<nbsp><with|font-family|normal|(<reference|Kronecker-repr>)>
    for <math|P<rsub|\<geqslant\>k><around*|(|z|)>=0> and assuming that
    <math|P<rsub|\<geqslant\>k><around*|(|z|)>=0> is equisolvable in
    <math|z<rsub|\<geqslant\>k>> on <math|\<b-alpha\>>, the resultant
    <math|R> vanishes on <math|\<cal-V\><rsub|\<b-alpha\>><around*|(|P<rsub|\<geqslant\>k-1>|)>>.
  </lemma>

  <\proof>
    If <math|z\<in\>\<cal-V\><rsub|\<b-alpha\>><around*|(|P<rsub|\<geqslant\>k-1>|)>\<cap\><around*|(|\<cal-U\>\<times\>\<b-alpha\><rsub|\<gtr\>k>|)>>,
    then<nbsp>(<reference|Res-eval-formula>) directly yields
    <math|R<around*|(|z|)>=0>. For general
    <math|z\<in\>\<cal-V\><rsub|\<b-alpha\>><around*|(|P<rsub|\<geqslant\>k-1>|)>>,
    let <math|u\<in\>\<bbb-C\><rsup|k-1>> be a vector such such that
    <math|z<rsub|\<less\>k>+u*\<varepsilon\>\<in\>\<cal-U\>> for all
    sufficiently small <math|\<varepsilon\>\<neq\>0>. Then
    <math|f<rsub|i><around*|(|\<varepsilon\>|)>=P<rsub|k-1><around*|(|z<rsub|\<less\>k>+u*\<varepsilon\>,\<phi\><rsub|i><around*|(|z<rsub|\<less\>k>+u*\<varepsilon\>|)>|)>>
    is a bounded function, given by a<nbsp>Puiseux series of valuation
    <math|\<geqslant\>0> in <math|\<varepsilon\>>. Since
    <math|P<rsub|\<geqslant\>k><around*|(|z|)>> is equisolvable in
    <math|z<rsub|\<geqslant\>k>> on <math|\<b-alpha\>>, one of the curves
    <math|<around*|(|z<rsub|\<less\>k>+u*\<varepsilon\>,\<phi\><rsub|i><around*|(|z<rsub|\<less\>k>+u*\<varepsilon\>|)>|)>>
    tends to <math|z> for <math|\<varepsilon\>\<rightarrow\>0>. Since
    <math|P<rsub|k-1><around*|(|z|)>=0>, it follows that
    <math|f<rsub|i><around*|(|\<varepsilon\>|)>> and therefore
    <math|f<rsub|1><around*|(|\<varepsilon\>|)>*\<cdots\>*f<rsub|d><around*|(|\<varepsilon\>|)>>
    tend to <math|0> for <math|\<varepsilon\>\<rightarrow\>0>. We conclude
    that <math|R<around*|(|z|)>=0>, using the analyticity of <math|R>.
  </proof>

  We have shown above how to find an analytic relation <math|R> for
  <math|z<rsub|k-1>> which is implied by<nbsp><math|P<rsub|\<geqslant\>k>> on
  <math|\<b-alpha\>>. We still need to show how to express
  <math|z<rsub|\<geqslant\>k>> as a function of <math|z<rsub|\<less\>k>>. For
  this we use a similar technique as in the proof of
  Theorem<nbsp><reference|Kron-thm>. Consider formal variables
  <math|\<epsilon\><rsub|k>,\<ldots\>,\<epsilon\><rsub|n>> with
  <math|\<epsilon\><rsub|i>*\<epsilon\><rsub|j>=0> for all <math|i,j> and new
  coordinates <math|z<rsup|\<epsilon\>>> such that

  <\eqnarray*>
    <tformat|<table|<row|<cell|z<rsub|k-1>>|<cell|=>|<cell|z<rsup|\<epsilon\>><rsub|k-1>-\<epsilon\><rsub|\<geqslant\>k>\<cdot\>z<rsup|\<epsilon\>><rsub|\<geqslant\>k>>>|<row|<cell|z<rsub|i>>|<cell|=>|<cell|z<rsup|\<epsilon\>><rsub|i>,<space|2em>i\<neq\>k-1.>>>>
  </eqnarray*>

  With respect to these new coordinates, the univariate representation
  for<nbsp>(<reference|eqsol-sys>) may be rewritten as

  <\eqnarray*>
    <tformat|<table|<row|<cell|Q<rsup|\<epsilon\>><around*|(|z<rsup|\<epsilon\>><rsub|\<leqslant\>k>|)>>|<cell|=>|<cell|0>>|<row|<cell|z<rsup|\<epsilon\>><rsub|i>>|<cell|=>|<cell|U<rsup|\<epsilon\>><rsub|i><around*|(|z<rsup|\<epsilon\>><rsub|\<leqslant\>k>|)>,<space|1em>i\<gtr\>k.>>>>
  </eqnarray*>

  In a similar way as above above, we next evaluate the resultant

  <\eqnarray*>
    <tformat|<table|<row|<cell|R<rsup|\<epsilon\>><around*|(|z<rsup|\<epsilon\>><rsub|\<less\>k>|)>>|<cell|=>|<cell|Res<rsub|z<rsup|\<epsilon\>><rsub|k>><around*|(|Q<rsup|\<epsilon\>><around*|(|z<rsup|\<epsilon\>><rsub|\<leqslant\>k>|)>,P<rsub|k-1><around*|(|z<rsup|\<epsilon\>><rsub|\<less\>k-1>,z<rsup|\<epsilon\>><rsub|k-1>-\<epsilon\><rsub|k>*z<rsup|\<epsilon\>><rsub|k>-\<epsilon\><rsub|\<gtr\>k>\<cdot\>U<rsup|\<epsilon\>><rsub|\<gtr\>k><around*|(|z<rsup|\<epsilon\>><rsub|\<leqslant\>k>|)>,z<rsup|\<epsilon\>><rsub|k>,U<rsup|\<epsilon\>><rsub|\<gtr\>k><around*|(|z<rsup|\<epsilon\>><rsub|\<leqslant\>k>|)>|)>|)>.>>|<row|<cell|>|<cell|=>|<cell|R<around*|(|z<rsub|\<less\>k>|)>+\<epsilon\><rsub|k>*S<rsub|k><around*|(|z<rsub|\<less\>k>|)>+\<cdots\>+\<epsilon\><rsub|n>*S<rsub|n><around*|(|z<rsub|\<less\>k>|)>>>>>
  </eqnarray*>

  and prove that <math|S<rsub|k>,\<ldots\>,S<rsub|n>> are analytic functions
  in <math|z<rsub|\<less\>k>> on <math|\<b-alpha\><rsub|\<less\>k>>. The
  common zeros of<nbsp>(<reference|eqsol-sys>) and <math|P<rsub|k-1>>
  correspond to the zeros of this resultant with respect to the new
  coordinates. Setting <math|z<rsup|\<epsilon\>><rsub|k-1>=z<rsub|k-1>+\<epsilon\><rsub|\<geqslant\>>\<cdot\>z<rsub|\<geqslant\>k>>
  and <math|R<rsup|\<epsilon\>><around*|(|z<rsup|\<epsilon\>><rsub|\<less\>k>|)>=0>
  leads to

  <\eqnarray*>
    <tformat|<table|<row|<cell|R<around*|(|z<rsub|\<less\>k>|)>>|<cell|=>|<cell|0>>|<row|<cell|R<rprime|'><around*|(|z<rsub|\<less\>k>|)>*z<rsub|i>>|<cell|=>|<cell|S<rsub|i><around*|(|z<rsub|\<less\>k>|)>,<space|1em>i\<geqslant\>k,>>>>
  </eqnarray*>

  where <math|R<rprime|'>=\<partial\> R/\<partial\> z<rsub|k-1>>. Assuming
  that <math|Res<rsub|z<rsub|k-1>><around*|(|R,R<rprime|'>|)>> is not the
  zero function on <math|\<b-alpha\><rsub|\<less\>k-1>>, this almost yields a
  Kronecker representation for <math|P<rsub|\<geqslant\>k-1><around*|(|z|)>=0>.

  In order to obtain an actual Kronecker representation, we finally compute
  the Weierstrass normal form <math|<wide|Q|~>> of <math|R> with respect to
  <math|z<rsub|k-1>>, together with an invertible analytic function <math|W>
  in <math|z<rsub|\<less\>k>> such that <math|R=W*<wide|Q|~>>. Setting
  <math|<wide|U|~><rsub|i>=S<rsub|i>/W>, we then obtain the Kronecker
  representation

  <\eqnarray*>
    <tformat|<table|<row|<cell|<wide|Q|~><around*|(|z<rsub|\<less\>k>|)>>|<cell|=>|<cell|0>>|<row|<cell|<wide|Q|~><rprime|'><around*|(|z<rsub|\<less\>k>|)>*z<rsub|i>>|<cell|=>|<cell|<wide|U|~><rsub|i><around*|(|z<rsub|\<less\>k>|)>,<space|1em>i\<geqslant\>k>>>>
  </eqnarray*>

  for <math|P<rsub|\<geqslant\>k-1><around*|(|z|)>=0> on <math|\<b-alpha\>>,
  where <math|<wide|Q|~><rprime|'>=\<partial\> <wide|Q|~>/\<partial\>
  z<rsub|k-1>>. If <math|P<rsub|\<geqslant\>k><around*|(|z|)>=0> is
  equisolvable in <math|z<rsub|\<geqslant\>k>> on <math|\<b-alpha\>>, then
  Lemma<nbsp><reference|resultant-vanish-lem> also implies that
  <math|<wide|Q|~>> vanishes on <math|\<cal-V\><rsub|\<b-alpha\>><around*|(|P<rsub|\<geqslant\>k-1>|)>>.

  <subsection|Incremental multiplicity certification><label|inc-cert-sec>

  We are now in a position to certify the multiplicity of the
  system<nbsp>(<reference|pol-sys>) on a sufficiently small ball. We first
  construct a homotopy <math|H> for the system<nbsp>(<reference|pol-sys>)
  which is in sufficiently general position. For notational reasons, it will
  be convenient to use <math|z<rsub|0>> instead of <math|t> for the time
  parameter. We take

  <\eqnarray*>
    <tformat|<table|<row|<cell|H<rsub|i><around*|(|z<rsub|0>,\<ldots\>,z<rsub|n>|)>>|<cell|=>|<cell|<around*|(|1-z<rsub|0>|)>*P<rsub|i><around*|(|z<rsub|1>,\<ldots\>,z<rsub|n>|)>+z<rsub|0>*I<rsub|i><around*|(|z<rsub|1>,\<ldots\>,z<rsub|n>|)>>>|<row|<cell|I<rsub|i><around*|(|z<rsub|1>,\<ldots\>,z<rsub|n>|)>>|<cell|=>|<cell|<around*|(|z<rsub|i>+\<varepsilon\>*z<rsub|i+1>+\<cdots\>+\<varepsilon\><rsup|n-i>*z<rsub|n>|)><rsup|d<rsub|i>>-1,>>>>
  </eqnarray*>

  where <math|\<varepsilon\>=1/<around*|(|2*d<rsub|1>*\<cdots\>*d<rsub|n>|)>>.

  For <math|k=n,\<ldots\>,1> our main objective is to certify that the system
  <math|H<rsub|k><around*|(|z<rsub|0>,\<ldots\>,z<rsub|n>|)>=\<cdots\>=H<rsub|n><around*|(|z<rsub|0>,\<ldots\>,z<rsub|n>|)>=0>
  is equisolvable in <math|z<rsub|k>,\<ldots\>,z<rsub|n>> on a sufficiently
  small ball <math|\<b-alpha\>> with <math|0\<in\>\<b-alpha\><rsub|0>> around
  a<nbsp>numerical solution. For <math|k=n>, we proceed as in
  section<nbsp><reference|an-mult-sec>. Assume now that we have proved
  equisolvability in <math|z<rsub|\<gtr\>k>> for the system
  <math|H<rsub|\<gtr\>k><around*|(|z|)>=0> on <math|\<b-alpha\>> and that we
  also have a Kronecker representation

  <\eqnarray*>
    <tformat|<table|<row|<cell|<wide|Q|^><around*|(|z<rsub|\<leqslant\>k+1>|)>>|<cell|=>|<cell|0>>|<row|<cell|<wide|Q|^><rprime|'><around*|(|z<rsub|\<leqslant\>k+1>|)>*z<rsub|i>>|<cell|=>|<cell|<wide|V|^><rsub|i><around*|(|z<rsub|\<leqslant\>k+1>|)>,<space|1em>i\<gtr\>k+1>>>>
  </eqnarray*>

  for the same system, where <math|<wide|Q|^><rprime|'>=\<partial\>
  <wide|Q|^>/\<partial\> z<rsub|k+1>>. Using the algorithms from
  section<nbsp><reference|an-mult-sec>, we may again ensure
  that<nbsp><math|<wide|Q|^>> is equisolvable in <math|z<rsub|k>> on
  <math|\<b-alpha\><rsub|\<leqslant\>k>>. Using the algorithm from
  section<nbsp><reference|intersect-sec>, we next compute a<nbsp>Kronecker
  representation

  <\eqnarray*>
    <tformat|<table|<row|<cell|Q<around*|(|z<rsub|\<leqslant\>k>|)>>|<cell|=>|<cell|0>>|<row|<cell|Q<rprime|'><around*|(|z<rsub|\<leqslant\>k>|)>*z<rsub|i>>|<cell|=>|<cell|V<rsub|i><around*|(|z<rsub|\<leqslant\>k>|)>,<space|1em>i\<gtr\>k>>>>
  </eqnarray*>

  for the intersection<nbsp><math|\<cal-V\><rsub|\<b-alpha\>><around*|(|H<rsub|\<geqslant\>k>|)>>,
  where <math|Q<rprime|'>=\<partial\> Q/\<partial\> z<rsub|k>>. We will show
  below that <math|<rigid|Res<rsub|z<rsub|k>><around|(|Q,Q<rprime|'>|)>>\<neq\><no-break>0>
  on <math|\<b-alpha\><rsub|\<less\>k>>. Furthermore, <math|Q> vanishes on
  <math|\<cal-V\><rsub|\<b-alpha\>><around*|(|H<rsub|\<geqslant\>k-1>|)>>, by
  Lemma<nbsp><reference|resultant-vanish-lem>. We conclude that the system
  <math|H<rsub|\<geqslant\>k><around*|(|z|)>=0> is equisolvable in
  <math|z<rsub|\<geqslant\>k>> on <math|\<b-alpha\>>, by
  Proposition<nbsp><reference|equisolvability-prop>. By induction, this
  completes our algorithm to certify (almost) multiple roots <math|\<alpha\>>
  on a sufficiently small polydisk <math|\<b-alpha\>> around
  <math|\<alpha\>>.

  We still have to check that <math|<rigid|Res<rsub|z<rsub|k>><around|(|Q,Q<rprime|'>|)>>>
  is not identical to zero on <math|\<b-alpha\>>. Assume the contrary, so
  that <math|<rigid|Res<rsub|z<rsub|k>><around|(|Q,Q<rprime|'>|)>>> vanishes
  everywhere, by analytic continuation. In other words, for any fixed
  <math|z<rsub|\<less\>k>>, the equation <math|Q<around*|(|z|)>=0> admits a
  multiple solution in <math|z<rsub|k>>. In particular, taking
  <math|z<rsub|0>=1>, the generator <math|q<around*|(|z<rsub|k>|)>> of the
  ideal <math|<around*|(|I<rsub|k>,\<ldots\>,I<rsub|n>|)>\<cap\>\<bbb-C\><around*|[|z<rsub|k>|]>>
  admits a<nbsp>multiple solution. Denoting by
  <math|z<rsup|1>,\<ldots\>,z<rsup|s>> the solutions of the system
  <math|I<rsub|k><around*|(|z|)>=\<cdots\>=I<rsub|n><around*|(|z|)>=0>, we
  have <math|q<around*|(|z<rsub|k>|)>=<around*|(|z<rsub|k>-z<rsup|1><rsub|k>|)>*\<cdots\>*<around*|(|z<rsub|k>-z<rsup|s><rsub|k>|)>>.
  Now <math|\<varepsilon\>> was taken sufficiently small so as to ensure that
  <math|z<rsup|i><rsub|k>\<neq\>z<rsup|j><rsub|k>> for all <math|i\<neq\>j>,
  contradicting the assumption that <math|q> admits a multiple root.

  <subsection|Global algebraic certification><label|global-cert-sec>

  Even if the coefficients of the system<nbsp>(<reference|pol-sys>) are all
  rational or algebraic, then the computed solutions are only numeric
  approximations. For some applications, it is useful to have exact
  representations of the solutions. This allows for instance to check whether
  a given other polynomial with rational coefficients vanishes on the
  solution set or on some points of the solutions set.

  The Kronecker representation provides one useful exact representation for
  the set of solutions. Modulo a generic linear change of coordinates, we may
  assume without loss of generality that for any distinct solutions
  <math|z,z<rprime|'>> of<nbsp>(<reference|pol-sys>), their first coordinates
  <math|z<rsub|1>> and <math|z<rprime|'><rsub|1>> are also distinct. Using
  the algorithm in the proof of Lemma<nbsp><reference|zerodim-Kronecker-lem>,
  we may then compute a<nbsp>Kronecker representation for the
  system<nbsp>(<reference|pol-sys>).

  Assume now that<nbsp>(<reference|pol-sys>) has rational coefficients and
  that we have computed numeric approximations
  <math|<wide|z|~><rsup|1>,\<ldots\>,<wide|z|~><rsup|k>> of
  <math|z<rsup|1>,\<ldots\>,z<rsup|k>> with bit precision <math|p>. Using the
  above method, we may thus compute a numeric approximation of the Kronecker
  representation with an accuracy of approximately <math|p> bits. We apply
  rational number reconstruction<nbsp><cite-detail|GaGe02|Chapter<nbsp>5> in
  order to provide a<nbsp>guess for the Kronecker representation with
  rational coefficients. We may check whether this guess is correct by
  evaluating<nbsp><math|P> at <math|z<rsub|1>=u,z<rsub|2>=V<rsub|2><around|(|u|)>/Q<rprime|'><around|(|u|)>,\<ldots\>,z<rsub|n>=V<rsub|n><around|(|u|)>/Q<rprime|'><around|(|u|)>>
  over <math|\<bbb-A\>=\<bbb-Q\><around|[|u|]>/<around|(|Q<around|(|u|)>|)>>.
  If the check fails, then we double the bit precision, use Newton's method
  to improve the approximations <math|<wide|z|~><rsup|1>,\<ldots\>,<wide|z|~><rsup|k>>,
  and keep iterating.

  In the case that we suspect our system to admit multiple roots, which means
  that we have at least one herd of numerical solutions, the centers of herds
  of solutions are still known numerically with a precision of approximately
  <math|p> bits. Consequently, we may use the above method in order to
  compute the radical of the zero dimensional ideal <math|I> generated by
  the<nbsp><math|P<rsub|i>>. By evaluating the <math|P<rsub|i>> over suitable
  algebras with nilpotent elements, we may check in a<nbsp>similar way as
  above whether the multiplicity of each root matches with the numeric
  multiplicity and obtain an exact algebraic representation for <math|I>. In
  the projective setting with no solutions at infinity, this strategy can be
  used to provide a full algebraically certification of all solutions.

  <section|Systems of analytic equations><label|an-sec>

  It is possible to generalize the techniques of this paper to the local
  resolution of a system of analytic equations on a polydisk. In this
  section, we outline some ideas for generalizations of this kind. As a
  general rule, such generalizations usually work better when the local
  solutions in the polydisk are well separated from the other solutions
  outside the polydisk.

  <subsection|Univariate equations><label|univ-an-sec>

  Consider the equation

  <\equation*>
    f<around*|(|z|)>=0,
  </equation*>

  where <math|f> is an effective analytic function on the closed unit disk
  <math|\<cal-B\><around*|(|0,1|)>>, without any roots on the unit circle.
  Assume that we wish to find all roots of <math|f> in
  <math|\<cal-B\><around*|(|0,1|)>>. Using the methods from
  section<nbsp><reference|an-mult-sec>, the first step is to compute and
  certify the number <math|d> of roots in <math|\<cal-B\><around*|(|0,1|)>>.

  Having determined the exact number <math|d> of roots <math|f> inside
  <math|\<cal-B\><around*|(|0,1|)>>, most standard numerical methods for
  finding the <math|d> roots of a polynomial of degree <math|d> can be
  mimicked. For instance, we may use the homotopy

  <\equation*>
    \<lambda\>*<around*|(|z<rsup|d>-\<varepsilon\><rsup|d>|)>*t+f<around*|(|z|)>*<around*|(|1-t|)>=0
  </equation*>

  for <math|\<lambda\>=max <around*|\||f<rsub|k>|\|>> and
  <math|0\<less\><around*|\||\<varepsilon\>|\|>\<less\>1>. In the unlucky
  case that we only find a subset <rigid|<math|u<rsub|1>,\<ldots\>,u<rsub|k>>>
  of the roots with <math|k\<less\>d>, we set
  <math|P<around*|(|z|)>=<around*|(|z-u<rsub|1>|)>*\<cdots\>*<around*|(|z-u<rsub|k>|)>>
  and keep repeating the algorithm using a homotopy of the form

  <\equation*>
    \<lambda\>*<around*|(|z<rsup|d-k>-<wide|\<varepsilon\>|~><rsup|d-k>|)>*P<around*|(|z|)>*t+f<around*|(|z|)>*<around*|(|1-t|)>=0,
  </equation*>

  and for a new random choice of <math|<wide|\<varepsilon\>|~>> with
  <math|0\<less\><around*|\||<wide|\<varepsilon\>|~>|\|>\<less\>1>. This
  method will ultimately pick random<nbsp><math|<wide|\<varepsilon\>|~>>
  sufficiently close to any of the roots, thereby ensuring the termination of
  the method. We may also use Aberth's method, while resetting points that
  fall outside the unit disk to random points inside the disk.

  <subsection|Direct reduction to the polynomial case><label|an-pol-red-sec>

  Now consider a system

  <\equation>
    f<rsub|1><around*|(|z|)>=\<cdots\>=f<rsub|n><around*|(|z|)>=0<label|an-sys>
  </equation>

  of equations, where <math|f<rsub|1>,\<ldots\>,f<rsub|n>> are computable
  analytic functions on the closed unit polydisk
  <math|\<cal-B\><around*|(|0,1|)><rsup|n>>. From now on, our aim is to
  determine the solutions of this system in
  <math|\<cal-B\><around*|(|0,1|)><rsup|n>>.

  For any choice of degrees <math|d<rsub|1>,\<ldots\>,d<rsub|n>>, we may
  consider the truncated polynomials

  <\eqnarray*>
    <tformat|<table|<row|<cell|P<rsub|i>>|<cell|=>|<cell|<big|sum><rsub|<around*|\<\|\|\>|k|\<\|\|\>>\<leqslant\>d<rsub|i>><around*|(|f<rsub|i>|)><rsub|k>*z<rsup|k>,>>>>
  </eqnarray*>

  and consider the truncated system

  <\equation>
    P<rsub|1><around*|(|z|)>=\<cdots\>=P<rsub|n><around*|(|z|)>=0.<label|trunc-sys>
  </equation>

  Using the homotopy methods from this paper, we may compute the solutions of
  this system and keep only those ones which are in
  <math|\<cal-B\><around*|(|0,1|)><rsup|n>>. At a second stage, we form the
  homotopy

  <\eqnarray*>
    <tformat|<table|<row|<cell|H<rsub|i><around*|(|z,t|)>>|<cell|=>|<cell|P<rsub|i><around*|(|z|)>*t+f<rsub|i><around*|(|z|)>*<around*|(|1-t|)>>>>>
  </eqnarray*>

  and follow the solutions of the truncated systems from <math|t=1> to
  <math|t=0>. This yields an uncertified candidate for the set of solutions
  to<nbsp>(<reference|an-sys>).

  <\remark>
    The above method admits several variants. For instance, if we want to
    avoid the explicit computation of truncated polynomials, then we may
    directly use the homotopy

    <\eqnarray*>
      <tformat|<table|<row|<cell|H<rsub|i><around*|(|z,t|)>>|<cell|=>|<cell|<around*|(|z<rsub|i><rsup|d<rsub|i>>-\<sigma\><rsub|i><rsup|d<rsub|i>>|)>*t+\<lambda\><rsub|i>*f<rsub|i><around*|(|z|)>*<around*|(|1-t|)>>>>>
    </eqnarray*>

    for suitable <math|\<sigma\><rsub|i>\<in\>\<bbb-C\>> and
    <math|\<lambda\><rsub|i>\<in\>\<bbb-R\><rsup|\<gtr\>>> with
    <math|<around*|\||\<sigma\><rsub|i>|\|>=1>. While following the
    homotopies, we may also decide to drop any paths which lead ``too far''
    outside <math|\<cal-B\><around*|(|0,1|)><rsup|n>>.
  </remark>

  Given <math|i>, let us now investigate how to pick <math|d<rsub|i>>. For
  any <math|d\<in\>\<bbb-N\>>, we define

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<mu\><rsub|i,d>>|<cell|=>|<cell|max<rsub|<around*|\<\|\|\>|k|\<\|\|\>>=d><around*|\||<around*|(|f<rsub|i>|)><rsub|k>|\|>.>>>>
  </eqnarray*>

  Typically, we now take <math|d<rsub|i>> to be the degree <math|d> for which
  <math|\<mu\><rsub|i,d>> is maximal (and in any case larger than this
  value). We may determine this degree by first computing a bound
  <math|M<rsub|i>> for<nbsp><math|<around*|\||f<rsub|i>|\|>> on a polydisk
  <math|\<cal-B\><around*|(|0,\<rho\>|)><rsup|n>> with
  <math|\<rho\>\<gtr\>1>, so that <math|<around*|\||f<rsub|k>|\|>\<leqslant\>M<rsub|i>*\<rho\><rsup|-<around*|\<\|\|\>|k|\<\|\|\>>>>
  for all <math|k>, whence <math|\<mu\><rsub|i,d>\<leqslant\>M<rsub|i>*\<rho\><rsup|-d>>
  for all <math|d>. Starting with <math|\<delta\>\<assign\>0> and
  <math|d\<assign\>1>, we now repeat the following: if
  <math|\<mu\><rsub|i,d>\<gtr\>\<mu\><rsub|i,\<delta\>>>, then
  <math|\<delta\>\<assign\>d>. Else, if <math|M<rsub|i>*\<rho\><rsup|-d>\<less\>\<mu\><rsub|i,\<delta\>>>,
  then we stop and take <math|d<rsub|i>\<assign\>\<delta\>>. Otherwise, set
  <math|d\<assign\>d+1> and continue.

  Let us now investigate how to certify that we found all solutions in
  <math|\<cal-B\><around*|(|0,1|)><rsup|n>>. Since<nbsp>(<reference|an-sys>)
  is really a perturbation of<nbsp>(<reference|trunc-sys>), one idea would be
  ensure that for each solution of<nbsp>(<reference|trunc-sys>), the
  solutions remain either inside <math|\<cal-B\><around*|(|0,1|)><rsup|n>> or
  outside <math|\<cal-B\><around*|(|0,1|)><rsup|n>> for small perturbations.
  More precisely, for each <math|i>, we start by computing a bound
  <math|B<rsub|i>> for <math|<around*|\||f<rsub|i>-P<rsub|i>|\|>> on
  <math|\<cal-B\><around*|(|0,1|)><rsup|n>> (for instance, we may take
  <math|B<rsub|i>=<big|sum><rsub|<around*|\<\|\|\>|k|\<\|\|\>>\<gtr\>d<rsub|i>>M<rsub|i>*\<rho\><rsup|-k>>
  with the above notations, but is sometimes better to take more explicit
  coefficients for a sharper bound). We next consider the system

  <\equation*>
    P<rsub|1><around*|(|z|)>+\<cal-B\><around*|(|0,B<rsub|1>|)>=\<cdots\>=P<rsub|n><around*|(|z|)>+\<cal-B\><around*|(|0,B<rsub|n>|)>=0.
  </equation*>

  For each solution <math|z> to<nbsp>(<reference|trunc-sys>), we now compute
  a ball enclosure <math|\<cal-B\><around*|(|z,\<eta\>|)>> of this solution
  such that any solution <math|<wide|z|~>> to
  <math|P<rsub|1><around*|(|<wide|z|~>|)>+\<varepsilon\><rsub|1>=\<cdots\>=P<rsub|n><around*|(|<wide|z|~>|)>+\<varepsilon\><rsub|n>=0>
  with <math|<around*|\||\<varepsilon\><rsub|i>|\|>\<leqslant\>B<rsub|i>>
  near <math|z> lies in <math|\<cal-B\><around*|(|z,\<eta\>|)>>. This can be
  done using the ball version of Newton's method. We next check whether each
  of the obtained enclosures <math|\<cal-B\><around*|(|z,\<eta\>|)>> is
  either entirely contained in <math|\<cal-B\><around*|(|0,1|)><rsup|n>> or
  in its complement. If this is the case, then we have obtained the desired
  certification. Indeed, consider a<nbsp>solution
  <math|<wide|z|~>\<in\>\<cal-B\><around*|(|0,1|)><rsup|n>>
  to<nbsp>(<reference|an-sys>). Then setting
  <math|\<varepsilon\><rsub|i>=f<rsub|i><around*|(|<wide|z|~>|)>-P<rsub|i><around*|(|<wide|z|~>|)>>,
  we have <math|P<rsub|i><around*|(|<wide|z|~>|)>+\<varepsilon\><rsub|i>=0>
  and <math|<around*|\||\<varepsilon\><rsub|i>|\|>\<leqslant\>B<rsub|i>>, for
  all <math|i>. Hence <math|<wide|z|~>\<in\>\<cal-B\><around*|(|z,\<eta\>|)>\<subseteq\>\<cal-B\><around*|(|0,1|)><rsup|n>>
  for one of the above enclosures.

  <\remark>
    <label|global-cert-rem>One disadvantage of the above certification method
    is that we have to keep track of both the solutions inside and outside
    <math|\<cal-B\><around*|(|0,1|)><rsup|n>> for small perturbations
    of<nbsp>(<reference|trunc-sys>). An alternative idea would be to consider
    the set <math|\<cal-S\>> of all solutions to<nbsp>(<reference|an-sys>)
    inside <math|\<cal-B\><around*|(|0,1|)><rsup|n>> as a generalized point
    which is the solution of a suitably deflated system, as in we did in
    section<nbsp><reference|herd-cert-sec> for the certification of herd
    homotopies. This generalized solution is usually unique in a large
    polydisk, corresponding to large perturbations of the system of equations
    for<nbsp><math|\<cal-S\>>. With some luck, this polydisk actually
    contains all sets of <math|<around*|\||\<cal-S\>|\|>> points in
    <math|\<cal-B\><around*|(|0,1|)><rsup|n>>, thereby certifying that
    <math|\<cal-S\>> is the set of all solutions to<nbsp>(<reference|an-sys>)
    inside <math|\<cal-B\><around*|(|0,1|)><rsup|n>>.

    Unfortunately, this idea only works in dimension <math|1>. For instance,
    in dimension two, the ball of systems
    <math|\<cal-X\><rsub|r>=<around*|{|x<rsup|2>-a*x-b,y-c*x-d|}>> with
    <math|a,b,c,d\<in\>\<cal-B\><around*|(|0,r|)>> and
    <math|r\<in\>\<bbb-R\><rsup|\<gtr\>>> does not contain a<nbsp>system
    which admits the set <math|<around*|{|<around*|(|0,0|)>,<around*|(|0,1|)>|}>>
    as its solutions. Nevertheless, it can be checked that any set of two
    elements in <math|\<cal-B\><around*|(|0,1|)><rsup|2>> is the solution of
    a system in either <math|\<cal-X\><rsub|4>> or <math|\<cal-Y\><rsub|4>>,
    where <math|\<cal-Y\><rsub|r>=<around*|{|y<rsup|2>-a*y-b,x-c*y-d|}>> with
    <math|a,b,c,d\<in\>\<cal-B\><around*|(|0,r|)>> for any
    <math|r\<in\>\<bbb-R\><rsup|\<gtr\>>>.
  </remark>

  <subsection|Incremental resolution><label|inc-sec>

  As noticed in remark<nbsp><reference|global-cert-rem>, one major
  disadvantage of the certification method from the previous section is that
  we need to consider the behaviour of <em|all> solutions
  to<nbsp>(<reference|trunc-sys>) under small perturbations, and even of
  those which lie far outside <math|\<cal-B\><around*|(|0,1|)><rsup|n>>.

  The incremental geometric resolution technique from the
  section<nbsp><reference|inc-cert-sec> for the certification of multiple
  roots can also be used for finding and certifying an arbitrary set of roots
  in a polydisk <math|\<b-alpha\>>. For this to work, it is necessary that
  the system<nbsp>(<reference|trunc-sys>) is equisolvable
  on<nbsp><math|\<b-alpha\>>, which means in practice that we chose a
  sufficiently general position and that the other roots
  of<nbsp>(<reference|trunc-sys>) outside <math|\<b-alpha\>> are sufficiently
  far away from <math|\<b-alpha\>>.

  <\remark>
    In the analytic setting, it can be interesting to compute the numeric
    solutions to<nbsp>(<reference|trunc-sys>) in an incremental way as well.
    A heuristic way to do the intersection step numerically goes as follows.
    We assume general position and consider the last intersection (the other
    intersections are done similarly, in fibers with
    <math|z<rsub|1>=\<cdots\>=z<rsub|k-1>=0>). Suppose that we are given a
    Kronecker representation

    <\eqnarray*>
      <tformat|<table|<row|<cell|Q<around*|(|0,z<rsub|2>|)>>|<cell|=>|<cell|0>>|<row|<cell|Q<rprime|'><around*|(|0,z<rsub|2>|)>*z<rsub|i>>|<cell|=>|<cell|V<rsub|i><around*|(|0,z<rsub|2>|)>,<space|1em>i\<gtr\>2>>>>
    </eqnarray*>

    for the system <math|f<rsub|2><around*|(|z|)>=\<cdots\>=f<rsub|n><around*|(|z|)>=0>,
    in the fiber where <math|z<rsub|1>=0>. Let <math|\<mu\>> be an upper
    bound for the number of roots of <math|f<rsub|1><around*|(|z<rsub|1>,0,\<ldots\>,0|)>>.
    For each of the roots <math|\<omega\>> of the equation
    <math|z<rsub|1><rsup|\<mu\>>=1>, we continue our Kronecker representation
    to a new one in the fiber with <math|z<rsub|1>=\<omega\>>. We finally use
    the homotopy

    <\eqnarray*>
      <tformat|<table|<row|<cell|<around*|(|z<rsub|1><rsup|\<mu\>>-1|)>*t+f<rsub|1><around*|(|z|)>*<around*|(|1-t|)>>|<cell|=>|<cell|0>>|<row|<cell|Q<around*|(|z<rsub|1>,z<rsub|2>|)>>|<cell|=>|<cell|0>>|<row|<cell|Q<rprime|'><around*|(|z<rsub|1>,z<rsub|2>|)>*z<rsub|i>>|<cell|=>|<cell|V<rsub|i><around*|(|z<rsub|1>,z<rsub|2>|)>,<space|1em>i\<gtr\>2,>>>>
    </eqnarray*>

    and perform the analytic continuation of the <math|\<mu\>> known
    solutions at <math|t=1> until <math|t=0>.
  </remark>

  In the case when our method fails to prove equisolvability, we need to
  decompose the system<nbsp>(<reference|an-sys>) into simpler systems which
  are equisolvable. This can be done using the following techniques:

  <\itemize>
    <item>By covering <math|\<cal-B\><around*|(|0,1|)><rsup|n>> by a finite
    number of polydisks, each on which the system is equisolvable. For
    instance in the case of the function <math|Q> from
    example<nbsp><reference|equisol-ex>, we may cover
    <math|\<cal-B\><around*|(|0,1|)><rsup|2>> by the polydisk
    <math|\<cal-B\><around*|(|0,1|)>\<times\>\<cal-B\><around*|(|0,3|)>>, or
    by the polydisk <math|\<cal-B\><around*|(|0,<frac*|1|2>|)>\<times\>\<cal-B\><around*|(|0,<frac*|3|2>|)>>
    and several other polydisks of the form
    <math|\<cal-B\><around*|(|c,r|)>\<times\>\<cal-B\><around*|(|0,1|)>>.

    <item>By applying a permutation of the coordinates. For instance the
    function <math|Q> from example<nbsp><reference|equisol-ex> is
    equisolvable in <math|x\<in\>\<cal-B\><around*|(|0,1|)>> with respect to
    <math|y\<in\>\<cal-B\><around*|(|0,1|)>>. We may also consider other
    linear changes of coordinates modulo adjustment of the regions. For
    instance, the equation <math|x*y=0> cannot be made equisolvable by one of
    the above means. Nevertheless, after setting <math|x=u+v> and
    <math|y=u-v>, the equation becomes equisolvable on
    <math|\<cal-B\><around|(|0,2|)><rsup|2>>.

    <item>By factoring the equation. Especially when an analytic function is
    restricted to a<nbsp>small region, it frequently occurs that it can be
    factored into simpler functions on this region. For instance, the
    equation <math|x<rsup|4>-y<rsup|3>+100*x*y=0> can be factored as
    <math|100*<around*|(|x+\<cdots\>|)>*<around*|(|y+\<cdots\>|)>=0> on
    <math|\<cal-B\><around*|(|0,1|)><rsup|2>> into two equations
    <math|x+\<cdots\>=0> and <math|y+\<cdots\>=0> which are equisolvable in
    <math|x> <abbr|resp.> <math|y>.
  </itemize>

  In principle, it is always possible to reduce to the equisolvable case
  using these techniques, but the number of required subdivisions may quickly
  grow out of hands. Indeed, for each solution (which we assumed to be
  single), there exists a sufficiently small neighbourhood where the
  <math|f<rsub|i>> are essentially linear functionals. The design of a good
  algorithm for keeping the number of subdivisions as small as possible is
  beyond the scope of this paper.

  <\bibliography|bib|tm-alpha|all.bib>
    <\bib-list|42>
      <bibitem*|AH83><label|bib-AH83>G.<nbsp>Alefeld<localize| and
      >J.<nbsp>Herzberger.<newblock> <with|font-shape|italic|Introduction to
      interval analysis>.<newblock> Academic Press, New York, 1983.<newblock>

      <bibitem*|ANS08><label|bib-IEEE754>ANSI/IEEE.<newblock> IEEE standard
      for binary floating-point arithmetic.<newblock> <localize|Technical
      Report>, ANSI/IEEE, New York, 2008.<newblock> ANSI-IEEE Standard
      754-2008. Revision of IEEE 754-1985, approved on June 12, 2008 by IEEE
      Standards Board.<newblock>

      <bibitem*|BHSW06><label|bib-Bertini>D.<nbsp>Bates, J.<nbsp>Hauenstein,
      A.<nbsp>Sommese<localize| and >C.<nbsp>Wampler.<newblock> Bertini:
      software for numerical algebraic geometry.<newblock>
      <slink|http://www.nd.edu/~sommese/bertini/>, 2006.<newblock>

      <bibitem*|BSHW08><label|bib-BSHW08>D.J.<nbsp>Bates, A.J.<nbsp>Sommese,
      J.D.<nbsp>Hauenstein<localize| and >C.W.<nbsp>Wampler.<newblock>
      Adaptive multiprecision path tracking.<newblock>
      <with|font-shape|italic|SIAM Journal on Numerical Mathematics>,
      46(2):722--746, 2008.<newblock>

      <bibitem*|Dur08><label|bib-Dur:phd>C.<nbsp>Durvye.<newblock>
      <with|font-shape|italic|Algorithmes pour la dcomposition primaire des
      idaux polynomiaux de dimension nulle donns en valuation>.<newblock>
      <localize|PhD thesis>, Univ. de Versailles (France), 2008.<newblock>

      <bibitem*|GG02><label|bib-GaGe02>J. von zur<nbsp>Gathen<localize| and
      >J.<nbsp>Gerhard.<newblock> <with|font-shape|italic|Modern Computer
      Algebra>.<newblock> Cambridge University Press, 2-nd<localize|
      edition>, 2002.<newblock>

      <bibitem*|GHH+97><label|bib-GHHMMP97>M.<nbsp>Giusti, K.<nbsp>Hgele,
      J.<nbsp>Heintz, J.E.<nbsp>Morais, J.L<nbsp>Montaa<localize| and
      >L.M.<nbsp>Pardo.<newblock> Lower bounds for diophantine
      approximation.<newblock> <with|font-shape|italic|Journal of Pure and
      Applied Algebra>, 117--118:277--317, 1997.<newblock>

      <bibitem*|GHMP95><label|bib-GHMP95>M.<nbsp>Giusti, J.<nbsp>Heintz,
      J.E.<nbsp>Morais<localize| and >L.M.<nbsp>Pardo.<newblock> When
      polynomial equation systems can be solved fast?<newblock> <localize|In
      >G.<nbsp>Cohen, M.<nbsp>Giusti<localize| and >T.<nbsp>Mora<localize|,
      editors>, <with|font-shape|italic|Proc. AAECC'11>, <localize|volume>
      948<localize| of ><with|font-shape|italic|Lecture Notes in Computer
      Science>. Springer Verlag, 1995.<newblock>

      <bibitem*|GLSY05><label|bib-GiLeSaYa:2004:laczaf>M.<nbsp>Giusti,
      G.<nbsp>Lecerf, B.<nbsp>Salvy<localize| and
      >J.-C.<nbsp>Yakoubsohn.<newblock> On location and approximation of
      clusters of zeros of analytic functions.<newblock>
      <with|font-shape|italic|Foundations of Computational Mathematics>,
      5(3):257--311, 2005.<newblock>

      <bibitem*|GLSY07><label|bib-GiLeSaYa:2004:laczcedo>M.<nbsp>Giusti,
      G.<nbsp>Lecerf, B.<nbsp>Salvy<localize| and
      >J.-C.<nbsp>Yakoubsohn.<newblock> On location and approximation of
      clusters of zeros: case of embedding dimension one.<newblock>
      <with|font-shape|italic|Foundations of Computational Mathematics>,
      7(1):1--49, 2007.<newblock>

      <bibitem*|HLRZ00><label|bib-MPFR>G.<nbsp>Hanrot, V.<nbsp>Lefvre,
      K.<nbsp>Ryde<localize| and >P.<nbsp>Zimmermann.<newblock> MPFR, a C
      library for multiple-precision floating-point computations with exact
      rounding.<newblock> <slink|http://www.mpfr.org>, 2000.<newblock>

      <bibitem*|Hoe02><label|bib-vdH:relax>J. van der<nbsp>Hoeven.<newblock>
      Relax, but don't be too lazy.<newblock> <with|font-shape|italic|JSC>,
      34:479--542, 2002.<newblock>

      <bibitem*|Hoe05><label|bib-vdH:effan>J. van der<nbsp>Hoeven.<newblock>
      Effective complex analysis.<newblock> <with|font-shape|italic|JSC>,
      39:433--449, 2005.<newblock>

      <bibitem*|Hoe07><label|bib-vdH:riemann>J. van
      der<nbsp>Hoeven.<newblock> On effective analytic
      continuation.<newblock> <with|font-shape|italic|MCS>, 1(1):111--175,
      2007.<newblock>

      <bibitem*|Hoe09><label|bib-vdH:ball>J. van der<nbsp>Hoeven.<newblock>
      Ball arithmetic.<newblock> <localize|Technical Report>, HAL,
      2009.<newblock> <slink|Http://hal.archives-ouvertes.fr/hal-00432152>.<newblock>

      <bibitem*|Hoe11><label|bib-vdH:rootcount>J. van
      der<nbsp>Hoeven.<newblock> Efficient root counting for analytic
      functions on a disk.<newblock> <localize|Technical Report>, HAL,
      2011.<newblock> <slink|Http://hal.archives-ouvertes.fr/hal-00583139>.<newblock>

      <bibitem*|JKDW01><label|bib-JKDW01>L.<nbsp>Jaulin, M.<nbsp>Kieffer,
      O.<nbsp>Didrit<localize| and >E.<nbsp>Walter.<newblock>
      <with|font-shape|italic|Applied interval analysis>.<newblock> Springer,
      London, 2001.<newblock>

      <bibitem*|Kea94><label|bib-KX94>R.B.<nbsp>Kearfott.<newblock> An
      interval step control for continuation methods.<newblock>
      <with|font-shape|italic|SIAM J. Numer. Anal.>, 31(3):892--914,
      1994.<newblock>

      <bibitem*|Kra69><label|bib-Kraw69>R.<nbsp>Krawczyk.<newblock>
      Newton-algorithmen zur bestimmung von nullstellen mit
      fehler-schranken.<newblock> <with|font-shape|italic|Computing>,
      4:187--201, 1969.<newblock>

      <bibitem*|Kul08><label|bib-Kul08>U.W.<nbsp>Kulisch.<newblock>
      <with|font-shape|italic|Computer Arithmetic and Validity. Theory,
      Implementation, and Applications>.<newblock>
      <localize|Number><nbsp>33<localize| in >Studies in Mathematics. De
      Gruyter, 2008.<newblock>

      <bibitem*|Lan76><label|bib-Lang76>S.<nbsp>Lang.<newblock>
      <with|font-shape|italic|Complex analysis>.<newblock> Addison-Wesley,
      1976.<newblock>

      <bibitem*|Lec01><label|bib-Lecerf:phd>G.<nbsp>Lecerf.<newblock>
      <with|font-shape|italic|Une alternative aux mthodes de rcriture pour
      la rsolution des syst<math|<wide|<text|m>|\<grave\>>>es
      algbriques>.<newblock> <localize|PhD thesis>, cole polytechnique,
      2001.<newblock>

      <bibitem*|Lec02><label|bib-Lecerf:2001:fda>G.<nbsp>Lecerf.<newblock>
      Quadratic Newton iteration for systems with multiplicity.<newblock>
      <with|font-shape|italic|Foundations of Computational Mathematics>,
      2(3):247--293, 2002.<newblock>

      <bibitem*|Ley09><label|bib-Ley09>A.<nbsp>Leykin.<newblock>
      NAG.<newblock> <slink|http://www.math.uic.edu/~leykin/NAG4M2>,
      2009.<newblock> Macaulay 2 package for numerical algebraic
      geometry.<newblock>

      <bibitem*|LVZ06><label|bib-LVZ06>A.<nbsp>Leykin,
      J.<nbsp>Verschelde<localize| and >A.<nbsp>Zhao.<newblock> Newton's
      method with deflation for isolated singularities of polynomial
      systems.<newblock> <with|font-shape|italic|TCS>, 359(1--3):111--122,
      2006.<newblock>

      <bibitem*|LVZ08><label|bib-LVZ08>A.<nbsp>Leykin,
      J.<nbsp>Verschelde<localize| and >A.<nbsp>Zhao.<newblock>
      <with|font-shape|italic|Algorithms in algebraic geometry>,
      <localize|chapter> Higher-order deflation for polynomial systems with
      isolated singular solutions, <localize|pages >79--97.<newblock>
      Springer, New York, 2008.<newblock>

      <bibitem*|MB96><label|bib-MB96>K.<nbsp>Makino<localize| and
      >M.<nbsp>Berz.<newblock> Remainder differential algebras and their
      applications.<newblock> <localize|In >M.<nbsp>Berz, C.<nbsp>Bischof,
      G.<nbsp>Corliss<localize| and >A.<nbsp>Griewank<localize|, editors>,
      <with|font-shape|italic|Computational differentiation: techniques,
      applications and tools>, <localize|pages >63--74. SIAM, Philadelphia,
      1996.<newblock>

      <bibitem*|MB04><label|bib-MB04>K.<nbsp>Makino<localize| and
      >M.<nbsp>Berz.<newblock> Suppression of the wrapping effect by Taylor
      model-based validated integrators.<newblock> <localize|Technical
      Report> MSU Report MSUHEP 40910, Michigan State University,
      2004.<newblock>

      <bibitem*|MKC09><label|bib-MKC09>R.E.<nbsp>Moore,
      R.B.<nbsp>Kearfott<localize| and >M.J.<nbsp>Cloud.<newblock>
      <with|font-shape|italic|Introduction to Interval Analysis>.<newblock>
      SIAM Press, 2009.<newblock>

      <bibitem*|MM11><label|bib-MM11>A.<nbsp>Mantzaflaris<localize| and
      >B.<nbsp>Mourrain.<newblock> Deflation and certified isolation of
      singular zeros of polynomial systems.<newblock> <localize|In
      >A.<nbsp>Leykin<localize|, editor>, <with|font-shape|italic|Proc.
      ISSAC'11>, <localize|pages >249--256. San Jose, CA, US, Jun 2011. ACM
      New York.<newblock>

      <bibitem*|Moo66><label|bib-Moo66>R.E.<nbsp>Moore.<newblock>
      <with|font-shape|italic|Interval Analysis>.<newblock> Prentice Hall,
      Englewood Cliffs, N.J., 1966.<newblock>

      <bibitem*|Mor87><label|bib-Mor87>A.P.<nbsp>Morgan.<newblock>
      <with|font-shape|italic|Solving polynomial systems using continuation
      for] engineering and scientific problems>.<newblock> Prentice-Hall,
      Englewood Cliffs, N.J., 1987.<newblock>

      <bibitem*|Neu90><label|bib-Neu90>A.<nbsp>Neumaier.<newblock>
      <with|font-shape|italic|Interval methods for systems of
      equations>.<newblock> Cambridge university press, Cambridge,
      1990.<newblock>

      <bibitem*|OWM83><label|bib-OWM83>T.<nbsp>Ojika,
      S.<nbsp>Watanabe<localize| and >T.<nbsp>Mitsui.<newblock> Deflation
      algorithm for multiple roots of a system of nonlinear
      equations.<newblock> <with|font-shape|italic|J. of Math. An. and
      Appls.>, 96(2):463--479, 1983.<newblock>

      <bibitem*|RG10><label|bib-RG10>S.<nbsp>Rump<localize| and
      >S.<nbsp>Graillat.<newblock> Verified error bounds for multiple roots
      of systems of nonlinear equations.<newblock>
      <with|font-shape|italic|Num. Algs.>, 54:359--377, 2010.<newblock>

      <bibitem*|Rum80><label|bib-Rump:phd>S.M.<nbsp>Rump.<newblock>
      <with|font-shape|italic|Kleine Fehlerschranken bei
      Matrixproblemen>.<newblock> <localize|PhD thesis>, Universitt
      Karlsruhe, 1980.<newblock>

      <bibitem*|Rum10><label|bib-Rump10>S.M.<nbsp>Rump.<newblock>
      Verification methods: rigorous results using floating-point
      arithmetic.<newblock> <with|font-shape|italic|Acta Numerica>,
      19:287--449, 2010.<newblock>

      <bibitem*|Sch82><label|bib-Sch82b>A.<nbsp>Schnhage.<newblock> The
      fundamental theorem of algebra in terms of computational
      complexity.<newblock> <localize|Technical Report>, Math. Inst. Univ. of
      Tbingen, 1982.<newblock>

      <bibitem*|SW05><label|bib-SW05>A.J.<nbsp>Sommese<localize| and
      >C.W.<nbsp>Wampler.<newblock> <with|font-shape|italic|The Numerical
      Solution of Systems of Polynomials Arising in Engineering and
      Science>.<newblock> World Scientific, 2005.<newblock>

      <bibitem*|Ver96><label|bib-Ver:phd>J.<nbsp>Verschelde.<newblock>
      <with|font-shape|italic|Homotopy continuation methods for solving
      polynomial systems>.<newblock> <localize|PhD thesis>, Katholieke
      Universiteit Leuven, 1996.<newblock>

      <bibitem*|Ver99><label|bib-Ver:PHCpack>J.<nbsp>Verschelde.<newblock>
      PHCpack: a general-purpose solver for polynomial systems by homotopy
      continuation.<newblock> <with|font-shape|italic|ACM Transactions on
      Mathematical Software>, 25(2):251--276, 1999.<newblock> Algorithm
      795.<newblock>

      <bibitem*|Wei00><label|bib-Wei00>K.<nbsp>Weihrauch.<newblock>
      <with|font-shape|italic|Computable analysis>.<newblock>
      Springer-Verlag, Berlin/Heidelberg, 2000.<newblock>
    </bib-list>
  </bibliography>
</body>

<\initial>
  <\collection>
    <associate|font-base-size|11>
    <associate|page-show-hf|true>
    <associate|par-hyphen|professional>
    <associate|sfactor|5>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|D-stable-Taylor-sec|<tuple|3.3|7>>
    <associate|Delta-def|<tuple|9|7>>
    <associate|Delta-prime|<tuple|23|15>>
    <associate|E-prime|<tuple|23|15>>
    <associate|FFT-invert|<tuple|2|3>>
    <associate|H-cond|<tuple|31|20>>
    <associate|Hop-rule|<tuple|29|31>>
    <associate|Kraw-sec|<tuple|6.1|19>>
    <associate|Kron-thm|<tuple|16|35>>
    <associate|Kronecker-repr|<tuple|36|35>>
    <associate|L1-norm|<tuple|4|4>>
    <associate|New-existence-cor|<tuple|5|20>>
    <associate|New-existence-th|<tuple|5|?>>
    <associate|New-tube-th|<tuple|10|?>>
    <associate|New-uniqueness-cor|<tuple|7|21>>
    <associate|New-uniqueness-rump-th|<tuple|7|?>>
    <associate|New-uniqueness-th|<tuple|9|?>>
    <associate|Newton-check|<tuple|13|?>>
    <associate|Res-eval-formula|<tuple|38|37>>
    <associate|T-bound|<tuple|8|10>>
    <associate|TFT-sec|<tuple|5|5>>
    <associate|Taylor-sec|<tuple|3.2|6>>
    <associate|Z-def|<tuple|35|34>>
    <associate|accept-crit|<tuple|14|13>>
    <associate|add-tail|<tuple|42|26>>
    <associate|alpha-approx|<tuple|21|18>>
    <associate|an-def1-sec|<tuple|8.1|27>>
    <associate|an-def2-sec|<tuple|8.2|27>>
    <associate|an-mult-sec|<tuple|8.4.3|30>>
    <associate|an-pol-red-sec|<tuple|10.2|40>>
    <associate|an-sec|<tuple|10|39>>
    <associate|an-sys|<tuple|39|40>>
    <associate|asym-sec|<tuple|3.5|8>>
    <associate|auto-1|<tuple|1|1>>
    <associate|auto-10|<tuple|3.3|7>>
    <associate|auto-11|<tuple|3.4|8>>
    <associate|auto-12|<tuple|3.5|9>>
    <associate|auto-13|<tuple|4|10>>
    <associate|auto-14|<tuple|4.1|10>>
    <associate|auto-15|<tuple|4.2|11>>
    <associate|auto-16|<tuple|4.3|11>>
    <associate|auto-17|<tuple|4.4|12>>
    <associate|auto-18|<tuple|4.5|13>>
    <associate|auto-19|<tuple|4.6|14>>
    <associate|auto-2|<tuple|2|4>>
    <associate|auto-20|<tuple|5|15>>
    <associate|auto-21|<tuple|5.1|15>>
    <associate|auto-22|<tuple|5.2|16>>
    <associate|auto-23|<tuple|5.3|17>>
    <associate|auto-24|<tuple|5.4|17>>
    <associate|auto-25|<tuple|5.5|18>>
    <associate|auto-26|<tuple|5.6|19>>
    <associate|auto-27|<tuple|6|19>>
    <associate|auto-28|<tuple|6.1|19>>
    <associate|auto-29|<tuple|6.2|21>>
    <associate|auto-3|<tuple|1|4>>
    <associate|auto-30|<tuple|6.3|22>>
    <associate|auto-31|<tuple|1|23>>
    <associate|auto-32|<tuple|6.4|24>>
    <associate|auto-33|<tuple|7|24>>
    <associate|auto-34|<tuple|7.1|25>>
    <associate|auto-35|<tuple|7.2|25>>
    <associate|auto-36|<tuple|7.3|26>>
    <associate|auto-37|<tuple|8|26>>
    <associate|auto-38|<tuple|8.1|27>>
    <associate|auto-39|<tuple|8.2|27>>
    <associate|auto-4|<tuple|2|4>>
    <associate|auto-40|<tuple|8.3|29>>
    <associate|auto-41|<tuple|8.4|29>>
    <associate|auto-42|<tuple|8.4.1|29>>
    <associate|auto-43|<tuple|8.4.2|30>>
    <associate|auto-44|<tuple|8.4.3|30>>
    <associate|auto-45|<tuple|8.4.4|30>>
    <associate|auto-46|<tuple|8.5|31>>
    <associate|auto-47|<tuple|8.5.1|31>>
    <associate|auto-48|<tuple|8.5.2|31>>
    <associate|auto-49|<tuple|8.5.3|32>>
    <associate|auto-5|<tuple|3|4>>
    <associate|auto-50|<tuple|8.5.4|32>>
    <associate|auto-51|<tuple|9|32>>
    <associate|auto-52|<tuple|9.1|32>>
    <associate|auto-53|<tuple|9.2|33>>
    <associate|auto-54|<tuple|9.3|34>>
    <associate|auto-55|<tuple|9.4|35>>
    <associate|auto-56|<tuple|9.5|36>>
    <associate|auto-57|<tuple|9.6|37>>
    <associate|auto-58|<tuple|9.7|38>>
    <associate|auto-59|<tuple|9.8|39>>
    <associate|auto-6|<tuple|4|4>>
    <associate|auto-60|<tuple|10|39>>
    <associate|auto-61|<tuple|10.1|39>>
    <associate|auto-62|<tuple|10.2|40>>
    <associate|auto-63|<tuple|10.3|41>>
    <associate|auto-64|<tuple|<with|mode|<quote|math>|\<bullet\>>|42>>
    <associate|auto-65|<tuple|<with|mode|<quote|math>|\<bullet\>>|?>>
    <associate|auto-66|<tuple|<with|mode|<quote|math>|\<bullet\>>|?>>
    <associate|auto-7|<tuple|3|4>>
    <associate|auto-8|<tuple|3.1|4>>
    <associate|auto-9|<tuple|3.2|6>>
    <associate|auto.2-1|<tuple|1|?|#2>>
    <associate|auto.3-1|<tuple|2|?|#3>>
    <associate|auto.3-2|<tuple|1|?|#3>>
    <associate|auto.3-3|<tuple|2|?|#3>>
    <associate|auto.3-4|<tuple|3|?|#3>>
    <associate|auto.3-5|<tuple|4|?|#3>>
    <associate|auto.4-1|<tuple|3|?|#4>>
    <associate|auto.4-2|<tuple|3.1|?|#4>>
    <associate|auto.4-3|<tuple|3.2|?|#4>>
    <associate|auto.4-4|<tuple|3.3|?|#4>>
    <associate|auto.4-5|<tuple|3.4|?|#4>>
    <associate|auto.4-6|<tuple|3.5|?|#4>>
    <associate|auto.5-1|<tuple|4|?|#5>>
    <associate|auto.5-10|<tuple|4.9|?|#5>>
    <associate|auto.5-2|<tuple|4.1|?|#5>>
    <associate|auto.5-3|<tuple|4.2|?|#5>>
    <associate|auto.5-4|<tuple|4.3|?|#5>>
    <associate|auto.5-5|<tuple|4.4|?|#5>>
    <associate|auto.5-6|<tuple|4.5|?|#5>>
    <associate|auto.5-7|<tuple|4.6|?|#5>>
    <associate|auto.5-8|<tuple|4.7|?|#5>>
    <associate|auto.5-9|<tuple|4.8|?|#5>>
    <associate|auto.6-1|<tuple|5|?|#6>>
    <associate|auto.6-2|<tuple|5.1|?|#6>>
    <associate|auto.6-3|<tuple|5.2|?|#6>>
    <associate|auto.6-4|<tuple|5.3|?|#6>>
    <associate|auto.6-5|<tuple|5.4|?|#6>>
    <associate|auto.6-6|<tuple|5.5|?|#6>>
    <associate|auto.6-7|<tuple|5.6|?|#6>>
    <associate|auto.7-1|<tuple|6|?|#7>>
    <associate|auto.7-2|<tuple|6.1|?|#7>>
    <associate|auto.7-3|<tuple|6.2|?|#7>>
    <associate|auto.7-4|<tuple|6.3|?|#7>>
    <associate|auto.7-5|<tuple|1|?|#7>>
    <associate|auto.8-1|<tuple|7|?|#8>>
    <associate|auto.8-2|<tuple|7.1|?|#8>>
    <associate|auto.8-3|<tuple|7.2|?|#8>>
    <associate|auto.8-4|<tuple|7.3|?|#8>>
    <associate|auto.8-5|<tuple|7.4|?|#8>>
    <associate|auto.8-6|<tuple|7.5|?|#8>>
    <associate|auto.9-1|<tuple|14|?|#9>>
    <associate|ball-add|<tuple|5|6>>
    <associate|ball-add-ieee|<tuple|10|7>>
    <associate|ball-add-lip|<tuple|7|?>>
    <associate|ball-arith-sec|<tuple|3.1|4>>
    <associate|ball-def|<tuple|2|5>>
    <associate|ball-int-quality-sec|<tuple|4.3|12>>
    <associate|ball-int-sec|<tuple|4|10>>
    <associate|ball-mul|<tuple|7|6>>
    <associate|ball-mul-ieee|<tuple|12|7>>
    <associate|ball-mul-lip|<tuple|16|10>>
    <associate|ball-sec|<tuple|3|4>>
    <associate|ball-sub|<tuple|6|6>>
    <associate|ball-sub-ieee|<tuple|11|7>>
    <associate|banach-eval|<tuple|27|28>>
    <associate|best-mu|<tuple|8|10>>
    <associate|bib-AH83|<tuple|AH83|42>>
    <associate|bib-Ab80|<tuple|Abe80|31>>
    <associate|bib-BB85|<tuple|BB85|31>>
    <associate|bib-BCOSSS06|<tuple|BCO+06|31>>
    <associate|bib-BHL01|<tuple|BHL01|31>>
    <associate|bib-BK78|<tuple|BK78|31>>
    <associate|bib-BS83|<tuple|BS83|31>>
    <associate|bib-BSHW08|<tuple|BSHW08|42>>
    <associate|bib-Bern:FMA|<tuple|Ber|12>>
    <associate|bib-Bertini|<tuple|BHSW06|42>>
    <associate|bib-Berz98|<tuple|Ber98|31>>
    <associate|bib-BiFio00|<tuple|BF00|31>>
    <associate|bib-CK91|<tuple|CK91|31>>
    <associate|bib-CKL89|<tuple|CKL89|12>>
    <associate|bib-CLN|<tuple|Hai95|32>>
    <associate|bib-CT65|<tuple|CT65|31>>
    <associate|bib-Dur:phd|<tuple|Dur08|42>>
    <associate|bib-EKW84|<tuple|EKW84|31>>
    <associate|bib-EMO91|<tuple|EMOK91|32>>
    <associate|bib-Fur07|<tuple|Fr07|32>>
    <associate|bib-GHHMMP97|<tuple|GHH+97|42>>
    <associate|bib-GHMP95|<tuple|GHMP95|42>>
    <associate|bib-GMP|<tuple|Gra91|32>>
    <associate|bib-GS88|<tuple|GS88|32>>
    <associate|bib-GaGe02|<tuple|GG02|42>>
    <associate|bib-GiLeSaYa:2004:laczaf|<tuple|GLSY05|43>>
    <associate|bib-GiLeSaYa:2004:laczcedo|<tuple|GLSY07|43>>
    <associate|bib-Gmp|<tuple|Gra91|?>>
    <associate|bib-Grz57|<tuple|Grz57|32>>
    <associate|bib-HS67|<tuple|HS67|32>>
    <associate|bib-HaZi04|<tuple|HZ04|12>>
    <associate|bib-IEEE1788|<tuple|ANS09|31>>
    <associate|bib-IEEE754|<tuple|ANS08|42>>
    <associate|bib-IRRAM|<tuple|M0|32>>
    <associate|bib-Intlab|<tuple|Rum99b|33>>
    <associate|bib-JKDW01|<tuple|JKDW01|43>>
    <associate|bib-KR06|<tuple|KR06|32>>
    <associate|bib-KX94|<tuple|Kea94|43>>
    <associate|bib-Kar63|<tuple|KO63|32>>
    <associate|bib-Kraw69|<tuple|Kra69|43>>
    <associate|bib-Kuhn98|<tuple|K8|32>>
    <associate|bib-Kul08|<tuple|Kul08|43>>
    <associate|bib-LINBOX|<tuple|DGG+02b|31>>
    <associate|bib-LINBOX02|<tuple|DGG+02a|31>>
    <associate|bib-LVZ06|<tuple|LVZ06|43>>
    <associate|bib-LVZ08|<tuple|LVZ08|43>>
    <associate|bib-Lang76|<tuple|Lan76|43>>
    <associate|bib-LeSc03|<tuple|LS03|12>>
    <associate|bib-Lecerf:2001:fda|<tuple|Lec02|43>>
    <associate|bib-Lecerf:phd|<tuple|Lec01|43>>
    <associate|bib-Ley09|<tuple|Ley09|43>>
    <associate|bib-Linbox|<tuple|Lin02|?>>
    <associate|bib-Loh01|<tuple|Loh01|32>>
    <associate|bib-Loh88|<tuple|Loh88|32>>
    <associate|bib-MB04|<tuple|MB04|43>>
    <associate|bib-MB96|<tuple|MB96|43>>
    <associate|bib-MKC09|<tuple|MKC09|43>>
    <associate|bib-MM11|<tuple|MM11|43>>
    <associate|bib-MPFI|<tuple|Rev01|33>>
    <associate|bib-MPFR|<tuple|HLRZ00|43>>
    <associate|bib-Moo65|<tuple|Moo65|32>>
    <associate|bib-Moo66|<tuple|Moo66|43>>
    <associate|bib-Mor87|<tuple|Mor87|43>>
    <associate|bib-Mul00|<tuple|Mul00|12>>
    <associate|bib-Mul06|<tuple|Mul06|32>>
    <associate|bib-Neu02|<tuple|Neu02|32>>
    <associate|bib-Neu90|<tuple|Neu90|43>>
    <associate|bib-Neu93|<tuple|Neu93|32>>
    <associate|bib-Nick85|<tuple|Nic85|33>>
    <associate|bib-OWM83|<tuple|OWM83|43>>
    <associate|bib-Pan84|<tuple|Pan84|33>>
    <associate|bib-Pan94|<tuple|Pan94|12>>
    <associate|bib-QD|<tuple|BHL00|31>>
    <associate|bib-RG10|<tuple|RG10|43>>
    <associate|bib-Rump10|<tuple|Rum10|43>>
    <associate|bib-Rump99|<tuple|Rum99|33>>
    <associate|bib-Rump:phd|<tuple|Rum80|43>>
    <associate|bib-SS71|<tuple|SS71|33>>
    <associate|bib-SW05|<tuple|SW05|44>>
    <associate|bib-Sch82b|<tuple|Sch82|43>>
    <associate|bib-Str69|<tuple|Str69|33>>
    <associate|bib-Tur36|<tuple|Tur36|33>>
    <associate|bib-Ver:PHCpack|<tuple|Ver99|44>>
    <associate|bib-Ver:phd|<tuple|Ver96|44>>
    <associate|bib-WC87|<tuple|WC87|33>>
    <associate|bib-Wei00|<tuple|Wei00|44>>
    <associate|bib-XSC|<tuple|ea67|31>>
    <associate|bib-vdH:ball|<tuple|Hoe09|43>>
    <associate|bib-vdH:effan|<tuple|Hoe05|43>>
    <associate|bib-vdH:effreal|<tuple|vdH06a|33>>
    <associate|bib-vdH:eigen|<tuple|vdHMT|33>>
    <associate|bib-vdH:fnewton|<tuple|vdH06b|33>>
    <associate|bib-vdH:issac03|<tuple|vdH03b|12>>
    <associate|bib-vdH:issac97|<tuple|vdH97|12>>
    <associate|bib-vdH:metaexp|<tuple|vdH08b|33>>
    <associate|bib-vdH:mml|<tuple|vdHea05|14>>
    <associate|bib-vdH:mmx|<tuple|vdH+02b|33>>
    <associate|bib-vdH:newrelax|<tuple|vdH07a|33>>
    <associate|bib-vdH:relax|<tuple|Hoe02|43>>
    <associate|bib-vdH:riemann|<tuple|Hoe07|43>>
    <associate|bib-vdH:rootcount|<tuple|Hoe11|43>>
    <associate|bib-vdH:stablemult|<tuple|vdH08a|33>>
    <associate|bib-vdH:tft|<tuple|vdH04|14>>
    <associate|bin-fft|<tuple|2|4>>
    <associate|bin-pow|<tuple|36|22>>
    <associate|btft-fig|<tuple|7|10>>
    <associate|cert-hom-sec|<tuple|6|19>>
    <associate|cert-hurd-cond|<tuple|30|27|homotopy4.tm>>
    <associate|cert-hurd-impr-sec|<tuple|9.3|28|homotopy4.tm>>
    <associate|cert-hurd-th|<tuple|14|27|homotopy4.tm>>
    <associate|cert-mult-cond|<tuple|22|?>>
    <associate|circle-check|<tuple|20|17>>
    <associate|cluster-detect-sec|<tuple|5.4|17>>
    <associate|comp-num-sec|<tuple|3.4|8>>
    <associate|cross-array|<tuple|4|4>>
    <associate|cross-diagonal|<tuple|7|7>>
    <associate|cross-diagonal-2|<tuple|8|7>>
    <associate|cross-direct|<tuple|5|7>>
    <associate|cross-inverse|<tuple|6|7>>
    <associate|cross-rel|<tuple|1|2>>
    <associate|cross-rel-mv|<tuple|3|3>>
    <associate|diff-tail|<tuple|45|26>>
    <associate|direct-tft-th|<tuple|1|6>>
    <associate|discrete-wind-num|<tuple|10.1|33|homotopy4.tm>>
    <associate|dyn-add|<tuple|50|28>>
    <associate|dyn-mul|<tuple|49|28>>
    <associate|dyn-sys|<tuple|48|27>>
    <associate|eff-an-rem|<tuple|19|37|homotopy4.tm>>
    <associate|eig-1|<tuple|26|18>>
    <associate|eig-2|<tuple|27|19>>
    <associate|eig-3|<tuple|28|19>>
    <associate|eig-ass-1|<tuple|24|?>>
    <associate|eig-bnd-0|<tuple|29|19>>
    <associate|eig-bnd-1|<tuple|30|20>>
    <associate|eig-bnd-1a|<tuple|24|?>>
    <associate|eig-bnd-1b|<tuple|24|?>>
    <associate|eig-bnd-2|<tuple|35|20>>
    <associate|eig-ind-1|<tuple|32|20>>
    <associate|eig-ind-2|<tuple|33|20>>
    <associate|eig-ind-3|<tuple|34|20>>
    <associate|eig-sec|<tuple|6.3|18>>
    <associate|end-sys|<tuple|1|1>>
    <associate|eqsol-sys|<tuple|34|34>>
    <associate|equisol-ex|<tuple|14|34>>
    <associate|equisolv-comp-lem|<tuple|13|34>>
    <associate|equisolv-lem|<tuple|14|?>>
    <associate|equisolvability-prop|<tuple|17|36>>
    <associate|exp-relaxed|<tuple|40|25>>
    <associate|f-lip|<tuple|15|10>>
    <associate|f-lip-var|<tuple|8|?>>
    <associate|f-r|<tuple|14|9>>
    <associate|f-usual|<tuple|13|9>>
    <associate|factor-cert-sec|<tuple|7.3|26>>
    <associate|footnote-|<tuple|?|1>>
    <associate|fp-existence-th|<tuple|4|19>>
    <associate|fp-uniqueness-th|<tuple|6|20>>
    <associate|fti-bnd|<tuple|52|29>>
    <associate|full-fft|<tuple|1|3>>
    <associate|global-cert-rem|<tuple|20|41>>
    <associate|global-cert-sec|<tuple|9.8|39>>
    <associate|herd-cert-sec|<tuple|9.2|33>>
    <associate|hi-bnd|<tuple|30|31>>
    <associate|hier-num-fig|<tuple|1|?>>
    <associate|hom|<tuple|3|1>>
    <associate|hom-basic-th|<tuple|8|22>>
    <associate|hom-inj-prop|<tuple|3|?>>
    <associate|hom-tube-th|<tuple|9|23>>
    <associate|hurd-detect-sec|<tuple|5.5|18>>
    <associate|hurd-iter|<tuple|18|16>>
    <associate|hurd-iter-sec|<tuple|5.2|16>>
    <associate|hurd-step-sec|<tuple|5.3|17>>
    <associate|i-mat|<tuple|18|12>>
    <associate|ideal-repr|<tuple|33|33>>
    <associate|impl-eq|<tuple|47|27>>
    <associate|impl-th-sec|<tuple|8.4.1|29>>
    <associate|improved-cert-iter|<tuple|23|21>>
    <associate|improved-crit|<tuple|16|13>>
    <associate|inc-cert-sec|<tuple|9.7|38>>
    <associate|inc-sec|<tuple|10.3|41>>
    <associate|ind-crit|<tuple|15|13>>
    <associate|inj-form|<tuple|1|?>>
    <associate|inj-prop|<tuple|1|?>>
    <associate|int-tail|<tuple|45|26>>
    <associate|intersect-sec|<tuple|9.6|37>>
    <associate|inv-TFT-sec|<tuple|6|7>>
    <associate|inv-relaxed|<tuple|39|25>>
    <associate|inv-tail|<tuple|46|27>>
    <associate|inv-trunc-fft-1|<tuple|5|8>>
    <associate|inv-trunc-fft-2|<tuple|6|6>>
    <associate|inverse-tft-th|<tuple|2|8>>
    <associate|itv-ball-not-sec|<tuple|2.3|5>>
    <associate|itv-def|<tuple|1|5>>
    <associate|large-ball-bnd|<tuple|31|32>>
    <associate|lift-cw-op|<tuple|2|?>>
    <associate|lift-prop|<tuple|5|5>>
    <associate|lip-sec|<tuple|3.6|9>>
    <associate|local-fact-th|<tuple|10|26>>
    <associate|long-term-sec|<tuple|7.5|27>>
    <associate|mat-inv-1|<tuple|23|17>>
    <associate|mat-inv-2|<tuple|24|18>>
    <associate|mat-inv-3|<tuple|25|18>>
    <associate|mat-inv-sec|<tuple|6.2|17>>
    <associate|mat-mul-1|<tuple|19|16>>
    <associate|mat-mul-2|<tuple|20|16>>
    <associate|mat-mul-3|<tuple|21|17>>
    <associate|mat-mul-r|<tuple|22|17>>
    <associate|mat-prod-r|<tuple|17|?>>
    <associate|mat-repr-sec|<tuple|6.4|21>>
    <associate|mat-repr-sex|<tuple|6.4|?>>
    <associate|mat-repr-sexc|<tuple|6.4|?>>
    <associate|mat-sec|<tuple|6|16>>
    <associate|mul-tail|<tuple|44|26>>
    <associate|mult-BFT|<tuple|6|9>>
    <associate|mult-prec-rem|<tuple|15|28|homotopy4.tm>>
    <associate|multiple-cert-sec|<tuple|9|32>>
    <associate|mv-fft|<tuple|3|?>>
    <associate|mv-fft-sec|<tuple|3|3>>
    <associate|mv-meromorphic-sec|<tuple|8.5.4|32>>
    <associate|mv-th|<tuple|10|10>>
    <associate|mvpol-sec|<tuple|9|9>>
    <associate|mvser-sec|<tuple|9|10>>
    <associate|near-coll-sec|<tuple|4.6|14>>
    <associate|new-mul-bnd|<tuple|38|24>>
    <associate|newton-crit|<tuple|17|13>>
    <associate|num-hier-fig|<tuple|2|14>>
    <associate|num-hier-sec|<tuple|5|14>>
    <associate|num-hom-sec|<tuple|4|10>>
    <associate|num-mul-roots-sec|<tuple|5|15>>
    <associate|num-prec-sec|<tuple|4.4|12>>
    <associate|num-univ-sec|<tuple|5.1|15>>
    <associate|op-norm|<tuple|3|5>>
    <associate|overest-ex|<tuple|2|9>>
    <associate|overest-sec|<tuple|3.4|8>>
    <associate|pol-mul-1|<tuple|37|24>>
    <associate|pol-sys|<tuple|11|11>>
    <associate|pol-tail|<tuple|41|26>>
    <associate|pow-norm|<tuple|4|5>>
    <associate|pr-sys|<tuple|12|11>>
    <associate|real-fft-fig|<tuple|8|13>>
    <associate|rec|<tuple|16|?>>
    <associate|reduce-overest-sec|<tuple|3.5|9>>
    <associate|rel-Newton-check|<tuple|19|17>>
    <associate|rem-der|<tuple|26|26>>
    <associate|resultant-sec|<tuple|8.4.4|30>>
    <associate|resultant-vanish-lem|<tuple|18|37>>
    <associate|rnd-hyp|<tuple|13|11>>
    <associate|rnd-near|<tuple|8|7>>
    <associate|rnd-up|<tuple|17|11>>
    <associate|seg-rem|<tuple|4|4>>
    <associate|ser-repr-sec|<tuple|7.1|22>>
    <associate|ser-sec|<tuple|7|22>>
    <associate|simpl-th|<tuple|6|10>>
    <associate|simple-hom-cert-sec|<tuple|6.2|21>>
    <associate|slope-hom-incl|<tuple|18|?>>
    <associate|slope-step-th|<tuple|10|?>>
    <associate|slope-tube-fig|<tuple|1|23>>
    <associate|small-ball-bnd|<tuple|32|32>>
    <associate|start-rec|<tuple|22|21>>
    <associate|start-sys|<tuple|2|1>>
    <associate|step-2-sys|<tuple|33|?>>
    <associate|step-control-sec|<tuple|4.5|13>>
    <associate|step-orig-sol|<tuple|41|36>>
    <associate|step-orig-sys|<tuple|40|36>>
    <associate|step-sol|<tuple|43|36>>
    <associate|step-sys|<tuple|42|36>>
    <associate|sub-tail|<tuple|43|26>>
    <associate|synchronize-sec|<tuple|5.6|19>>
    <associate|tail-bound-sec|<tuple|7.4|26>>
    <associate|tail-prod-tail|<tuple|39|?>>
    <associate|tail3-bound|<tuple|35|?>>
    <associate|tay-mu|<tuple|9|10>>
    <associate|tay-qual|<tuple|10|10>>
    <associate|tft-1d-tab|<tuple|1|11>>
    <associate|tft-2d-tab|<tuple|2|11>>
    <associate|tft-3d-tab|<tuple|3|12>>
    <associate|tft-asym-fig|<tuple|4|6>>
    <associate|tft-mv-tab|<tuple|4|12>>
    <associate|tft-subset-fig|<tuple|3|6>>
    <associate|thick-sol|<tuple|45|36>>
    <associate|thicken-sys|<tuple|44|36>>
    <associate|trig-sys|<tuple|51|28>>
    <associate|trunc-fft|<tuple|2|6>>
    <associate|trunc-sys|<tuple|40|40>>
    <associate|tube-hyp|<tuple|24|23>>
    <associate|tube-sec|<tuple|6.4|?>>
    <associate|tubular-sec|<tuple|6.3|22>>
    <associate|unique-prop|<tuple|2|?>>
    <associate|univ-an-sec|<tuple|10.1|39>>
    <associate|univ-mult-cert-sec|<tuple|7|24>>
    <associate|univ-repr|<tuple|37|36>>
    <associate|univ-repr-sec|<tuple|9.5|36>>
    <associate|univ-root-cert|<tuple|25|25>>
    <associate|weierstrass-dec|<tuple|28|30>>
    <associate|weierstrass-sec|<tuple|8.4.2|30>>
    <associate|wrap-fig|<tuple|1|13>>
    <associate|zerodim-Kronecker-lem|<tuple|15|35>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|bib>
      GHMP95

      GHHMMP97

      Lecerf:phd

      Dur:phd

      Lecerf:phd

      Mor87

      Ver:phd

      SW05

      Ver:PHCpack

      Bertini

      Ley09

      Moo66

      AH83

      Neu90

      JKDW01

      Kul08

      MKC09

      Rump10

      KX94

      vdH:ball

      MB96

      MB04

      BSHW08

      BSHW08

      Kraw69

      Rump:phd

      KX94

      OWM83

      Lecerf:2001:fda

      GiLeSaYa:2004:laczaf

      GiLeSaYa:2004:laczcedo

      LVZ06

      LVZ08

      RG10

      MM11

      GHMP95

      GHHMMP97

      Dur:phd

      GHMP95

      GHHMMP97

      Dur:phd

      IEEE754

      MPFR

      vdH:ball

      MB96

      MB04

      BSHW08

      Kraw69

      Rump:phd

      Rump:phd

      Rump10

      Lang76

      Sch82b

      vdH:rootcount

      Wei00

      vdH:effan

      vdH:riemann

      vdH:riemann

      vdH:relax

      GaGe02
    </associate>
    <\associate|figure>
      <\tuple|normal>
        Illustration of a solution path <with|mode|<quote|math>|z<rsub|t>> in
        a tube.
      </tuple|<pageref|auto-31>>
    </associate>
    <\associate|toc>
      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|1.<space|2spc>Introduction>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-1><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|2.<space|2spc>Notations>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-2><vspace|0.5fn>

      <with|par-left|<quote|4tab>|Positive elements
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-3><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Vector notation
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-4><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Matrix notation
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-5><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Directed acyclic graphs
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-6><vspace|0.15fn>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|3.<space|2spc>Reliable
      arithmetic> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-7><vspace|0.5fn>

      <with|par-left|<quote|1tab>|3.1.<space|2spc>Ball arithmetic
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-8>>

      <with|par-left|<quote|1tab>|3.2.<space|2spc>Taylor models
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-9>>

      <with|par-left|<quote|1tab>|3.3.<space|2spc><with|mode|<quote|math>|\<cal-D\>>-stable
      Taylor models <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-10>>

      <with|par-left|<quote|1tab>|3.4.<space|2spc>Overestimation
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-11>>

      <with|par-left|<quote|1tab>|3.5.<space|2spc>Reducing the overestimation
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-12>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|4.<space|2spc>Numeric
      path tracking> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-13><vspace|0.5fn>

      <with|par-left|<quote|1tab>|4.1.<space|2spc>General framework
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-14>>

      <with|par-left|<quote|1tab>|4.2.<space|2spc>Solutions at infinity
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-15>>

      <with|par-left|<quote|1tab>|4.3.<space|2spc>Predictor corrector methods
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-16>>

      <with|par-left|<quote|1tab>|4.4.<space|2spc>Precision control
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-17>>

      <with|par-left|<quote|1tab>|4.5.<space|2spc>Step size control
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-18>>

      <with|par-left|<quote|1tab>|4.6.<space|2spc>Near collisions
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-19>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|5.<space|2spc>Multiple
      roots> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-20><vspace|0.5fn>

      <with|par-left|<quote|1tab>|5.1.<space|2spc>Straightforward
      Euler-Newton type methods <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-21>>

      <with|par-left|<quote|1tab>|5.2.<space|2spc>The herd iteration
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-22>>

      <with|par-left|<quote|1tab>|5.3.<space|2spc>Step size control for herd
      iterations <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-23>>

      <with|par-left|<quote|1tab>|5.4.<space|2spc>Detection of clusters
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-24>>

      <with|par-left|<quote|1tab>|5.5.<space|2spc>Detection of herds
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-25>>

      <with|par-left|<quote|1tab>|5.6.<space|2spc>Synchronization
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-26>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|6.<space|2spc>Certified
      homotopies> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-27><vspace|0.5fn>

      <with|par-left|<quote|1tab>|6.1.<space|2spc>Certification of Newton's
      method <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-28>>

      <with|par-left|<quote|1tab>|6.2.<space|2spc>Certification of a numeric
      homotopy continuation <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-29>>

      <with|par-left|<quote|1tab>|6.3.<space|2spc>Certification
      <with|font-shape|<quote|italic>|via> tubular models
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-30>>

      <with|par-left|<quote|1tab>|6.4.<space|2spc>Numeric spearhead
      computations and certification <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-32>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|7.<space|2spc>Certification
      of multiple univariate roots> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-33><vspace|0.5fn>

      <with|par-left|<quote|1tab>|7.1.<space|2spc>Applying Rouch's theorem
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-34>>

      <with|par-left|<quote|1tab>|7.2.<space|2spc>Computing the winding
      number <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-35>>

      <with|par-left|<quote|1tab>|7.3.<space|2spc>Certifying a local
      factorization <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-36>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|8.<space|2spc>Effective
      complex analysis> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-37><vspace|0.5fn>

      <with|par-left|<quote|1tab>|8.1.<space|2spc>Computable multivariate
      analytic functions <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-38>>

      <with|par-left|<quote|1tab>|8.2.<space|2spc>Multivariate analytic
      functions as evaluable functions <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-39>>

      <with|par-left|<quote|1tab>|8.3.<space|2spc>Evaluation in commutative
      zero dimensional algebras <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-40>>

      <with|par-left|<quote|1tab>|8.4.<space|2spc>Weierstrass preparation
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-41>>

      <with|par-left|<quote|2tab>|8.4.1.<space|2spc>Implicit functions
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-42>>

      <with|par-left|<quote|2tab>|8.4.2.<space|2spc>Weierstrass preparation
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-43>>

      <with|par-left|<quote|2tab>|8.4.3.<space|2spc>Certifying the
      multiplicity in a small neighbourhood
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-44>>

      <with|par-left|<quote|2tab>|8.4.4.<space|2spc>Analytic elimination on
      small balls <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-45>>

      <with|par-left|<quote|1tab>|8.5.<space|2spc>Simplifying computable
      meromorphic functions <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-46>>

      <with|par-left|<quote|2tab>|8.5.1.<space|2spc>A reliable version of
      l'Hpital's rule <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-47>>

      <with|par-left|<quote|2tab>|8.5.2.<space|2spc>Higher multiplicities
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-48>>

      <with|par-left|<quote|2tab>|8.5.3.<space|2spc>Recovering analytic
      functions from their values on a circle
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-49>>

      <with|par-left|<quote|2tab>|8.5.4.<space|2spc>Multivariate meromorphic
      functions <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-50>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|9.<space|2spc>Certification
      of multiple multivariate roots> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-51><vspace|0.5fn>

      <with|par-left|<quote|1tab>|9.1.<space|2spc>Jacobians of corank one
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-52>>

      <with|par-left|<quote|1tab>|9.2.<space|2spc>Certification of herd
      homotopies <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-53>>

      <with|par-left|<quote|1tab>|9.3.<space|2spc>Equisolvability
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-54>>

      <with|par-left|<quote|1tab>|9.4.<space|2spc>Kronecker representations
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-55>>

      <with|par-left|<quote|1tab>|9.5.<space|2spc>Univariate representations
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-56>>

      <with|par-left|<quote|1tab>|9.6.<space|2spc>Intersection with a new
      equation <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-57>>

      <with|par-left|<quote|1tab>|9.7.<space|2spc>Incremental multiplicity
      certification <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-58>>

      <with|par-left|<quote|1tab>|9.8.<space|2spc>Global algebraic
      certification <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-59>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|10.<space|2spc>Systems
      of analytic equations> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-60><vspace|0.5fn>

      <with|par-left|<quote|1tab>|10.1.<space|2spc>Univariate equations
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-61>>

      <with|par-left|<quote|1tab>|10.2.<space|2spc>Direct reduction to the
      polynomial case <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-62>>

      <with|par-left|<quote|1tab>|10.3.<space|2spc>Incremental resolution
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-63>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|font-shape|<quote|small-caps>|Bibliography>
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <pageref|auto-64><vspace|0.5fn>
    </associate>
  </collection>
</auxiliary>